LavaPack.loadBundle([
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\decoder\\DecodedBitStreamParser.js", {"../../FormatException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\FormatException.js","../../IllegalStateException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\IllegalStateException.js","../../common/BitSource":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\BitSource.js","../../common/DecoderResult":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\DecoderResult.js","../../common/StringUtils":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\StringUtils.js","../../util/StringBuilder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\StringBuilder.js","../../util/StringEncoding":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\StringEncoding.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cdatamatrix%5Cdecoder%5CDecodedBitStreamParser.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var DecoderResult_1 = require("../../common/DecoderResult");
var BitSource_1 = require("../../common/BitSource");
var StringBuilder_1 = require("../../util/StringBuilder");
var StringEncoding_1 = require("../../util/StringEncoding");
var StringUtils_1 = require("../../common/StringUtils");
var FormatException_1 = require("../../FormatException");
var IllegalStateException_1 = require("../../IllegalStateException");
/*
 * Copyright 2008 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var Mode;
(function (Mode) {
    Mode[Mode["PAD_ENCODE"] = 0] = "PAD_ENCODE";
    Mode[Mode["ASCII_ENCODE"] = 1] = "ASCII_ENCODE";
    Mode[Mode["C40_ENCODE"] = 2] = "C40_ENCODE";
    Mode[Mode["TEXT_ENCODE"] = 3] = "TEXT_ENCODE";
    Mode[Mode["ANSIX12_ENCODE"] = 4] = "ANSIX12_ENCODE";
    Mode[Mode["EDIFACT_ENCODE"] = 5] = "EDIFACT_ENCODE";
    Mode[Mode["BASE256_ENCODE"] = 6] = "BASE256_ENCODE";
})(Mode || (Mode = {}));
/**
 * <p>Data Matrix Codes can encode text as bits in one of several modes, and can use multiple modes
 * in one Data Matrix Code. This class decodes the bits back into text.</p>
 *
 * <p>See ISO 16022:2006, 5.2.1 - 5.2.9.2</p>
 *
 * @author bbrown@google.com (Brian Brown)
 * @author Sean Owen
 */
var DecodedBitStreamParser = /** @class */ (function () {
    function DecodedBitStreamParser() {
    }
    DecodedBitStreamParser.decode = function (bytes) {
        var bits = new BitSource_1.default(bytes);
        var result = new StringBuilder_1.default();
        var resultTrailer = new StringBuilder_1.default();
        var byteSegments = new Array();
        var mode = Mode.ASCII_ENCODE;
        do {
            if (mode === Mode.ASCII_ENCODE) {
                mode = this.decodeAsciiSegment(bits, result, resultTrailer);
            }
            else {
                switch (mode) {
                    case Mode.C40_ENCODE:
                        this.decodeC40Segment(bits, result);
                        break;
                    case Mode.TEXT_ENCODE:
                        this.decodeTextSegment(bits, result);
                        break;
                    case Mode.ANSIX12_ENCODE:
                        this.decodeAnsiX12Segment(bits, result);
                        break;
                    case Mode.EDIFACT_ENCODE:
                        this.decodeEdifactSegment(bits, result);
                        break;
                    case Mode.BASE256_ENCODE:
                        this.decodeBase256Segment(bits, result, byteSegments);
                        break;
                    default:
                        throw new FormatException_1.default();
                }
                mode = Mode.ASCII_ENCODE;
            }
        } while (mode !== Mode.PAD_ENCODE && bits.available() > 0);
        if (resultTrailer.length() > 0) {
            result.append(resultTrailer.toString());
        }
        return new DecoderResult_1.default(bytes, result.toString(), byteSegments.length === 0 ? null : byteSegments, null);
    };
    /**
     * See ISO 16022:2006, 5.2.3 and Annex C, Table C.2
     */
    DecodedBitStreamParser.decodeAsciiSegment = function (bits, result, resultTrailer) {
        var upperShift = false;
        do {
            var oneByte = bits.readBits(8);
            if (oneByte === 0) {
                throw new FormatException_1.default();
            }
            else if (oneByte <= 128) { // ASCII data (ASCII value + 1)
                if (upperShift) {
                    oneByte += 128;
                    // upperShift = false;
                }
                result.append(String.fromCharCode(oneByte - 1));
                return Mode.ASCII_ENCODE;
            }
            else if (oneByte === 129) { // Pad
                return Mode.PAD_ENCODE;
            }
            else if (oneByte <= 229) { // 2-digit data 00-99 (Numeric Value + 130)
                var value = oneByte - 130;
                if (value < 10) { // pad with '0' for single digit values
                    result.append('0');
                }
                result.append('' + value);
            }
            else {
                switch (oneByte) {
                    case 230: // Latch to C40 encodation
                        return Mode.C40_ENCODE;
                    case 231: // Latch to Base 256 encodation
                        return Mode.BASE256_ENCODE;
                    case 232: // FNC1
                        result.append(String.fromCharCode(29)); // translate as ASCII 29
                        break;
                    case 233: // Structured Append
                    case 234: // Reader Programming
                        // Ignore these symbols for now
                        // throw ReaderException.getInstance();
                        break;
                    case 235: // Upper Shift (shift to Extended ASCII)
                        upperShift = true;
                        break;
                    case 236: // 05 Macro
                        result.append('[)>\u001E05\u001D');
                        resultTrailer.insert(0, '\u001E\u0004');
                        break;
                    case 237: // 06 Macro
                        result.append('[)>\u001E06\u001D');
                        resultTrailer.insert(0, '\u001E\u0004');
                        break;
                    case 238: // Latch to ANSI X12 encodation
                        return Mode.ANSIX12_ENCODE;
                    case 239: // Latch to Text encodation
                        return Mode.TEXT_ENCODE;
                    case 240: // Latch to EDIFACT encodation
                        return Mode.EDIFACT_ENCODE;
                    case 241: // ECI Character
                        // TODO(bbrown): I think we need to support ECI
                        // throw ReaderException.getInstance();
                        // Ignore this symbol for now
                        break;
                    default:
                        // Not to be used in ASCII encodation
                        // but work around encoders that end with 254, latch back to ASCII
                        if (oneByte !== 254 || bits.available() !== 0) {
                            throw new FormatException_1.default();
                        }
                        break;
                }
            }
        } while (bits.available() > 0);
        return Mode.ASCII_ENCODE;
    };
    /**
     * See ISO 16022:2006, 5.2.5 and Annex C, Table C.1
     */
    DecodedBitStreamParser.decodeC40Segment = function (bits, result) {
        // Three C40 values are encoded in a 16-bit value as
        // (1600 * C1) + (40 * C2) + C3 + 1
        // TODO(bbrown): The Upper Shift with C40 doesn't work in the 4 value scenario all the time
        var upperShift = false;
        var cValues = [];
        var shift = 0;
        do {
            // If there is only one byte left then it will be encoded as ASCII
            if (bits.available() === 8) {
                return;
            }
            var firstByte = bits.readBits(8);
            if (firstByte === 254) { // Unlatch codeword
                return;
            }
            this.parseTwoBytes(firstByte, bits.readBits(8), cValues);
            for (var i = 0; i < 3; i++) {
                var cValue = cValues[i];
                switch (shift) {
                    case 0:
                        if (cValue < 3) {
                            shift = cValue + 1;
                        }
                        else if (cValue < this.C40_BASIC_SET_CHARS.length) {
                            var c40char = this.C40_BASIC_SET_CHARS[cValue];
                            if (upperShift) {
                                result.append(String.fromCharCode(c40char.charCodeAt(0) + 128));
                                upperShift = false;
                            }
                            else {
                                result.append(c40char);
                            }
                        }
                        else {
                            throw new FormatException_1.default();
                        }
                        break;
                    case 1:
                        if (upperShift) {
                            result.append(String.fromCharCode(cValue + 128));
                            upperShift = false;
                        }
                        else {
                            result.append(String.fromCharCode(cValue));
                        }
                        shift = 0;
                        break;
                    case 2:
                        if (cValue < this.C40_SHIFT2_SET_CHARS.length) {
                            var c40char = this.C40_SHIFT2_SET_CHARS[cValue];
                            if (upperShift) {
                                result.append(String.fromCharCode(c40char.charCodeAt(0) + 128));
                                upperShift = false;
                            }
                            else {
                                result.append(c40char);
                            }
                        }
                        else {
                            switch (cValue) {
                                case 27: // FNC1
                                    result.append(String.fromCharCode(29)); // translate as ASCII 29
                                    break;
                                case 30: // Upper Shift
                                    upperShift = true;
                                    break;
                                default:
                                    throw new FormatException_1.default();
                            }
                        }
                        shift = 0;
                        break;
                    case 3:
                        if (upperShift) {
                            result.append(String.fromCharCode(cValue + 224));
                            upperShift = false;
                        }
                        else {
                            result.append(String.fromCharCode(cValue + 96));
                        }
                        shift = 0;
                        break;
                    default:
                        throw new FormatException_1.default();
                }
            }
        } while (bits.available() > 0);
    };
    /**
     * See ISO 16022:2006, 5.2.6 and Annex C, Table C.2
     */
    DecodedBitStreamParser.decodeTextSegment = function (bits, result) {
        // Three Text values are encoded in a 16-bit value as
        // (1600 * C1) + (40 * C2) + C3 + 1
        // TODO(bbrown): The Upper Shift with Text doesn't work in the 4 value scenario all the time
        var upperShift = false;
        var cValues = [];
        var shift = 0;
        do {
            // If there is only one byte left then it will be encoded as ASCII
            if (bits.available() === 8) {
                return;
            }
            var firstByte = bits.readBits(8);
            if (firstByte === 254) { // Unlatch codeword
                return;
            }
            this.parseTwoBytes(firstByte, bits.readBits(8), cValues);
            for (var i = 0; i < 3; i++) {
                var cValue = cValues[i];
                switch (shift) {
                    case 0:
                        if (cValue < 3) {
                            shift = cValue + 1;
                        }
                        else if (cValue < this.TEXT_BASIC_SET_CHARS.length) {
                            var textChar = this.TEXT_BASIC_SET_CHARS[cValue];
                            if (upperShift) {
                                result.append(String.fromCharCode(textChar.charCodeAt(0) + 128));
                                upperShift = false;
                            }
                            else {
                                result.append(textChar);
                            }
                        }
                        else {
                            throw new FormatException_1.default();
                        }
                        break;
                    case 1:
                        if (upperShift) {
                            result.append(String.fromCharCode(cValue + 128));
                            upperShift = false;
                        }
                        else {
                            result.append(String.fromCharCode(cValue));
                        }
                        shift = 0;
                        break;
                    case 2:
                        // Shift 2 for Text is the same encoding as C40
                        if (cValue < this.TEXT_SHIFT2_SET_CHARS.length) {
                            var textChar = this.TEXT_SHIFT2_SET_CHARS[cValue];
                            if (upperShift) {
                                result.append(String.fromCharCode(textChar.charCodeAt(0) + 128));
                                upperShift = false;
                            }
                            else {
                                result.append(textChar);
                            }
                        }
                        else {
                            switch (cValue) {
                                case 27: // FNC1
                                    result.append(String.fromCharCode(29)); // translate as ASCII 29
                                    break;
                                case 30: // Upper Shift
                                    upperShift = true;
                                    break;
                                default:
                                    throw new FormatException_1.default();
                            }
                        }
                        shift = 0;
                        break;
                    case 3:
                        if (cValue < this.TEXT_SHIFT3_SET_CHARS.length) {
                            var textChar = this.TEXT_SHIFT3_SET_CHARS[cValue];
                            if (upperShift) {
                                result.append(String.fromCharCode(textChar.charCodeAt(0) + 128));
                                upperShift = false;
                            }
                            else {
                                result.append(textChar);
                            }
                            shift = 0;
                        }
                        else {
                            throw new FormatException_1.default();
                        }
                        break;
                    default:
                        throw new FormatException_1.default();
                }
            }
        } while (bits.available() > 0);
    };
    /**
     * See ISO 16022:2006, 5.2.7
     */
    DecodedBitStreamParser.decodeAnsiX12Segment = function (bits, result) {
        // Three ANSI X12 values are encoded in a 16-bit value as
        // (1600 * C1) + (40 * C2) + C3 + 1
        var cValues = [];
        do {
            // If there is only one byte left then it will be encoded as ASCII
            if (bits.available() === 8) {
                return;
            }
            var firstByte = bits.readBits(8);
            if (firstByte === 254) { // Unlatch codeword
                return;
            }
            this.parseTwoBytes(firstByte, bits.readBits(8), cValues);
            for (var i = 0; i < 3; i++) {
                var cValue = cValues[i];
                switch (cValue) {
                    case 0: // X12 segment terminator <CR>
                        result.append('\r');
                        break;
                    case 1: // X12 segment separator *
                        result.append('*');
                        break;
                    case 2: // X12 sub-element separator >
                        result.append('>');
                        break;
                    case 3: // space
                        result.append(' ');
                        break;
                    default:
                        if (cValue < 14) { // 0 - 9
                            result.append(String.fromCharCode(cValue + 44));
                        }
                        else if (cValue < 40) { // A - Z
                            result.append(String.fromCharCode(cValue + 51));
                        }
                        else {
                            throw new FormatException_1.default();
                        }
                        break;
                }
            }
        } while (bits.available() > 0);
    };
    DecodedBitStreamParser.parseTwoBytes = function (firstByte, secondByte, result) {
        var fullBitValue = (firstByte << 8) + secondByte - 1;
        var temp = Math.floor(fullBitValue / 1600);
        result[0] = temp;
        fullBitValue -= temp * 1600;
        temp = Math.floor(fullBitValue / 40);
        result[1] = temp;
        result[2] = fullBitValue - temp * 40;
    };
    /**
     * See ISO 16022:2006, 5.2.8 and Annex C Table C.3
     */
    DecodedBitStreamParser.decodeEdifactSegment = function (bits, result) {
        do {
            // If there is only two or less bytes left then it will be encoded as ASCII
            if (bits.available() <= 16) {
                return;
            }
            for (var i = 0; i < 4; i++) {
                var edifactValue = bits.readBits(6);
                // Check for the unlatch character
                if (edifactValue === 0x1F) { // 011111
                    // Read rest of byte, which should be 0, and stop
                    var bitsLeft = 8 - bits.getBitOffset();
                    if (bitsLeft !== 8) {
                        bits.readBits(bitsLeft);
                    }
                    return;
                }
                if ((edifactValue & 0x20) === 0) { // no 1 in the leading (6th) bit
                    edifactValue |= 0x40; // Add a leading 01 to the 6 bit binary value
                }
                result.append(String.fromCharCode(edifactValue));
            }
        } while (bits.available() > 0);
    };
    /**
     * See ISO 16022:2006, 5.2.9 and Annex B, B.2
     */
    DecodedBitStreamParser.decodeBase256Segment = function (bits, result, byteSegments) {
        // Figure out how long the Base 256 Segment is.
        var codewordPosition = 1 + bits.getByteOffset(); // position is 1-indexed
        var d1 = this.unrandomize255State(bits.readBits(8), codewordPosition++);
        var count;
        if (d1 === 0) { // Read the remainder of the symbol
            count = bits.available() / 8 | 0;
        }
        else if (d1 < 250) {
            count = d1;
        }
        else {
            count = 250 * (d1 - 249) + this.unrandomize255State(bits.readBits(8), codewordPosition++);
        }
        // We're seeing NegativeArraySizeException errors from users.
        if (count < 0) {
            throw new FormatException_1.default();
        }
        var bytes = new Uint8Array(count);
        for (var i = 0; i < count; i++) {
            // Have seen this particular error in the wild, such as at
            // http://www.bcgen.com/demo/IDAutomationStreamingDataMatrix.aspx?MODE=3&D=Fred&PFMT=3&PT=F&X=0.3&O=0&LM=0.2
            if (bits.available() < 8) {
                throw new FormatException_1.default();
            }
            bytes[i] = this.unrandomize255State(bits.readBits(8), codewordPosition++);
        }
        byteSegments.push(bytes);
        try {
            result.append(StringEncoding_1.default.decode(bytes, StringUtils_1.default.ISO88591));
        }
        catch (uee) {
            throw new IllegalStateException_1.default('Platform does not support required encoding: ' + uee.message);
        }
    };
    /**
     * See ISO 16022:2006, Annex B, B.2
     */
    DecodedBitStreamParser.unrandomize255State = function (randomizedBase256Codeword, base256CodewordPosition) {
        var pseudoRandomNumber = ((149 * base256CodewordPosition) % 255) + 1;
        var tempVariable = randomizedBase256Codeword - pseudoRandomNumber;
        return tempVariable >= 0 ? tempVariable : tempVariable + 256;
    };
    /**
     * See ISO 16022:2006, Annex C Table C.1
     * The C40 Basic Character Set (*'s used for placeholders for the shift values)
     */
    DecodedBitStreamParser.C40_BASIC_SET_CHARS = [
        '*', '*', '*', ' ', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
        'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N',
        'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'
    ];
    DecodedBitStreamParser.C40_SHIFT2_SET_CHARS = [
        '!', '"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.',
        '/', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '^', '_'
    ];
    /**
     * See ISO 16022:2006, Annex C Table C.2
     * The Text Basic Character Set (*'s used for placeholders for the shift values)
     */
    DecodedBitStreamParser.TEXT_BASIC_SET_CHARS = [
        '*', '*', '*', ' ', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
        'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n',
        'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'
    ];
    // Shift 2 for Text is the same encoding as C40
    DecodedBitStreamParser.TEXT_SHIFT2_SET_CHARS = DecodedBitStreamParser.C40_SHIFT2_SET_CHARS;
    DecodedBitStreamParser.TEXT_SHIFT3_SET_CHARS = [
        '`', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N',
        'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '{', '|', '}', '~', String.fromCharCode(127)
    ];
    return DecodedBitStreamParser;
}());
exports.default = DecodedBitStreamParser;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\decoder\\DecodedBitStreamParser.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\decoder\\Decoder.js", {"../../ChecksumException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\ChecksumException.js","../../common/reedsolomon/GenericGF":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\reedsolomon\\GenericGF.js","../../common/reedsolomon/ReedSolomonDecoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\reedsolomon\\ReedSolomonDecoder.js","./BitMatrixParser":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\decoder\\BitMatrixParser.js","./DataBlock":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\decoder\\DataBlock.js","./DecodedBitStreamParser":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\decoder\\DecodedBitStreamParser.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cdatamatrix%5Cdecoder%5CDecoder.js
      return function (require, module, exports) {
"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
var ChecksumException_1 = require("../../ChecksumException");
var GenericGF_1 = require("../../common/reedsolomon/GenericGF");
var ReedSolomonDecoder_1 = require("../../common/reedsolomon/ReedSolomonDecoder");
var BitMatrixParser_1 = require("./BitMatrixParser");
var DataBlock_1 = require("./DataBlock");
var DecodedBitStreamParser_1 = require("./DecodedBitStreamParser");
/*
 * Copyright 2007 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * <p>The main class which implements Data Matrix Code decoding -- as opposed to locating and extracting
 * the Data Matrix Code from an image.</p>
 *
 * @author bbrown@google.com (Brian Brown)
 */
var Decoder = /** @class */ (function () {
    function Decoder() {
        this.rsDecoder = new ReedSolomonDecoder_1.default(GenericGF_1.default.DATA_MATRIX_FIELD_256);
    }
    /**
     * <p>Decodes a Data Matrix Code represented as a {@link BitMatrix}. A 1 or "true" is taken
     * to mean a black module.</p>
     *
     * @param bits booleans representing white/black Data Matrix Code modules
     * @return text and bytes encoded within the Data Matrix Code
     * @throws FormatException if the Data Matrix Code cannot be decoded
     * @throws ChecksumException if error correction fails
     */
    Decoder.prototype.decode = function (bits) {
        var e_1, _a;
        // Construct a parser and read version, error-correction level
        var parser = new BitMatrixParser_1.default(bits);
        var version = parser.getVersion();
        // Read codewords
        var codewords = parser.readCodewords();
        // Separate into data blocks
        var dataBlocks = DataBlock_1.default.getDataBlocks(codewords, version);
        // Count total number of data bytes
        var totalBytes = 0;
        try {
            for (var dataBlocks_1 = __values(dataBlocks), dataBlocks_1_1 = dataBlocks_1.next(); !dataBlocks_1_1.done; dataBlocks_1_1 = dataBlocks_1.next()) {
                var db = dataBlocks_1_1.value;
                totalBytes += db.getNumDataCodewords();
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (dataBlocks_1_1 && !dataBlocks_1_1.done && (_a = dataBlocks_1.return)) _a.call(dataBlocks_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        var resultBytes = new Uint8Array(totalBytes);
        var dataBlocksCount = dataBlocks.length;
        // Error-correct and copy data blocks together into a stream of bytes
        for (var j = 0; j < dataBlocksCount; j++) {
            var dataBlock = dataBlocks[j];
            var codewordBytes = dataBlock.getCodewords();
            var numDataCodewords = dataBlock.getNumDataCodewords();
            this.correctErrors(codewordBytes, numDataCodewords);
            for (var i = 0; i < numDataCodewords; i++) {
                // De-interlace data blocks.
                resultBytes[i * dataBlocksCount + j] = codewordBytes[i];
            }
        }
        // Decode the contents of that stream of bytes
        return DecodedBitStreamParser_1.default.decode(resultBytes);
    };
    /**
     * <p>Given data and error-correction codewords received, possibly corrupted by errors, attempts to
     * correct the errors in-place using Reed-Solomon error correction.</p>
     *
     * @param codewordBytes data and error correction codewords
     * @param numDataCodewords number of codewords that are data bytes
     * @throws ChecksumException if error correction fails
     */
    Decoder.prototype.correctErrors = function (codewordBytes, numDataCodewords) {
        // const numCodewords = codewordBytes.length;
        // First read into an array of ints
        var codewordsInts = new Int32Array(codewordBytes);
        // for (let i = 0; i < numCodewords; i++) {
        //   codewordsInts[i] = codewordBytes[i] & 0xFF;
        // }
        try {
            this.rsDecoder.decode(codewordsInts, codewordBytes.length - numDataCodewords);
        }
        catch (ignored /* ReedSolomonException */) {
            throw new ChecksumException_1.default();
        }
        // Copy back into array of bytes -- only need to worry about the bytes that were data
        // We don't care about errors in the error-correction codewords
        for (var i = 0; i < numDataCodewords; i++) {
            codewordBytes[i] = codewordsInts[i];
        }
    };
    return Decoder;
}());
exports.default = Decoder;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\decoder\\Decoder.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\decoder\\Version.js", {"../../FormatException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\FormatException.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cdatamatrix%5Cdecoder%5CVersion.js
      return function (require, module, exports) {
"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ECB = exports.ECBlocks = void 0;
var FormatException_1 = require("../../FormatException");
/*
 * Copyright 2007 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * <p>Encapsulates a set of error-correction blocks in one symbol version. Most versions will
 * use blocks of differing sizes within one version, so, this encapsulates the parameters for
 * each set of blocks. It also holds the number of error-correction codewords per block since it
 * will be the same across all blocks within one version.</p>
 */
var ECBlocks = /** @class */ (function () {
    function ECBlocks(ecCodewords, ecBlocks1, ecBlocks2) {
        this.ecCodewords = ecCodewords;
        this.ecBlocks = [ecBlocks1];
        ecBlocks2 && this.ecBlocks.push(ecBlocks2);
    }
    ECBlocks.prototype.getECCodewords = function () {
        return this.ecCodewords;
    };
    ECBlocks.prototype.getECBlocks = function () {
        return this.ecBlocks;
    };
    return ECBlocks;
}());
exports.ECBlocks = ECBlocks;
/**
 * <p>Encapsulates the parameters for one error-correction block in one symbol version.
 * This includes the number of data codewords, and the number of times a block with these
 * parameters is used consecutively in the Data Matrix code version's format.</p>
 */
var ECB = /** @class */ (function () {
    function ECB(count, dataCodewords) {
        this.count = count;
        this.dataCodewords = dataCodewords;
    }
    ECB.prototype.getCount = function () {
        return this.count;
    };
    ECB.prototype.getDataCodewords = function () {
        return this.dataCodewords;
    };
    return ECB;
}());
exports.ECB = ECB;
/**
 * The Version object encapsulates attributes about a particular
 * size Data Matrix Code.
 *
 * @author bbrown@google.com (Brian Brown)
 */
var Version = /** @class */ (function () {
    function Version(versionNumber, symbolSizeRows, symbolSizeColumns, dataRegionSizeRows, dataRegionSizeColumns, ecBlocks) {
        var e_1, _a;
        this.versionNumber = versionNumber;
        this.symbolSizeRows = symbolSizeRows;
        this.symbolSizeColumns = symbolSizeColumns;
        this.dataRegionSizeRows = dataRegionSizeRows;
        this.dataRegionSizeColumns = dataRegionSizeColumns;
        this.ecBlocks = ecBlocks;
        // Calculate the total number of codewords
        var total = 0;
        var ecCodewords = ecBlocks.getECCodewords();
        var ecbArray = ecBlocks.getECBlocks();
        try {
            for (var ecbArray_1 = __values(ecbArray), ecbArray_1_1 = ecbArray_1.next(); !ecbArray_1_1.done; ecbArray_1_1 = ecbArray_1.next()) {
                var ecBlock = ecbArray_1_1.value;
                total += ecBlock.getCount() * (ecBlock.getDataCodewords() + ecCodewords);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (ecbArray_1_1 && !ecbArray_1_1.done && (_a = ecbArray_1.return)) _a.call(ecbArray_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        this.totalCodewords = total;
    }
    Version.prototype.getVersionNumber = function () {
        return this.versionNumber;
    };
    Version.prototype.getSymbolSizeRows = function () {
        return this.symbolSizeRows;
    };
    Version.prototype.getSymbolSizeColumns = function () {
        return this.symbolSizeColumns;
    };
    Version.prototype.getDataRegionSizeRows = function () {
        return this.dataRegionSizeRows;
    };
    Version.prototype.getDataRegionSizeColumns = function () {
        return this.dataRegionSizeColumns;
    };
    Version.prototype.getTotalCodewords = function () {
        return this.totalCodewords;
    };
    Version.prototype.getECBlocks = function () {
        return this.ecBlocks;
    };
    /**
     * <p>Deduces version information from Data Matrix dimensions.</p>
     *
     * @param numRows Number of rows in modules
     * @param numColumns Number of columns in modules
     * @return Version for a Data Matrix Code of those dimensions
     * @throws FormatException if dimensions do correspond to a valid Data Matrix size
     */
    Version.getVersionForDimensions = function (numRows, numColumns) {
        var e_2, _a;
        if ((numRows & 0x01) !== 0 || (numColumns & 0x01) !== 0) {
            throw new FormatException_1.default();
        }
        try {
            for (var _b = __values(Version.VERSIONS), _c = _b.next(); !_c.done; _c = _b.next()) {
                var version = _c.value;
                if (version.symbolSizeRows === numRows && version.symbolSizeColumns === numColumns) {
                    return version;
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
        throw new FormatException_1.default();
    };
    //  @Override
    Version.prototype.toString = function () {
        return '' + this.versionNumber;
    };
    /**
     * See ISO 16022:2006 5.5.1 Table 7
     */
    Version.buildVersions = function () {
        return [
            new Version(1, 10, 10, 8, 8, new ECBlocks(5, new ECB(1, 3))),
            new Version(2, 12, 12, 10, 10, new ECBlocks(7, new ECB(1, 5))),
            new Version(3, 14, 14, 12, 12, new ECBlocks(10, new ECB(1, 8))),
            new Version(4, 16, 16, 14, 14, new ECBlocks(12, new ECB(1, 12))),
            new Version(5, 18, 18, 16, 16, new ECBlocks(14, new ECB(1, 18))),
            new Version(6, 20, 20, 18, 18, new ECBlocks(18, new ECB(1, 22))),
            new Version(7, 22, 22, 20, 20, new ECBlocks(20, new ECB(1, 30))),
            new Version(8, 24, 24, 22, 22, new ECBlocks(24, new ECB(1, 36))),
            new Version(9, 26, 26, 24, 24, new ECBlocks(28, new ECB(1, 44))),
            new Version(10, 32, 32, 14, 14, new ECBlocks(36, new ECB(1, 62))),
            new Version(11, 36, 36, 16, 16, new ECBlocks(42, new ECB(1, 86))),
            new Version(12, 40, 40, 18, 18, new ECBlocks(48, new ECB(1, 114))),
            new Version(13, 44, 44, 20, 20, new ECBlocks(56, new ECB(1, 144))),
            new Version(14, 48, 48, 22, 22, new ECBlocks(68, new ECB(1, 174))),
            new Version(15, 52, 52, 24, 24, new ECBlocks(42, new ECB(2, 102))),
            new Version(16, 64, 64, 14, 14, new ECBlocks(56, new ECB(2, 140))),
            new Version(17, 72, 72, 16, 16, new ECBlocks(36, new ECB(4, 92))),
            new Version(18, 80, 80, 18, 18, new ECBlocks(48, new ECB(4, 114))),
            new Version(19, 88, 88, 20, 20, new ECBlocks(56, new ECB(4, 144))),
            new Version(20, 96, 96, 22, 22, new ECBlocks(68, new ECB(4, 174))),
            new Version(21, 104, 104, 24, 24, new ECBlocks(56, new ECB(6, 136))),
            new Version(22, 120, 120, 18, 18, new ECBlocks(68, new ECB(6, 175))),
            new Version(23, 132, 132, 20, 20, new ECBlocks(62, new ECB(8, 163))),
            new Version(24, 144, 144, 22, 22, new ECBlocks(62, new ECB(8, 156), new ECB(2, 155))),
            new Version(25, 8, 18, 6, 16, new ECBlocks(7, new ECB(1, 5))),
            new Version(26, 8, 32, 6, 14, new ECBlocks(11, new ECB(1, 10))),
            new Version(27, 12, 26, 10, 24, new ECBlocks(14, new ECB(1, 16))),
            new Version(28, 12, 36, 10, 16, new ECBlocks(18, new ECB(1, 22))),
            new Version(29, 16, 36, 14, 16, new ECBlocks(24, new ECB(1, 32))),
            new Version(30, 16, 48, 14, 22, new ECBlocks(28, new ECB(1, 49)))
        ];
    };
    Version.VERSIONS = Version.buildVersions();
    return Version;
}());
exports.default = Version;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\decoder\\Version.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\detector\\Detector.js", {"../../NotFoundException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\NotFoundException.js","../../ResultPoint":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\ResultPoint.js","../../common/DetectorResult":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\DetectorResult.js","../../common/GridSamplerInstance":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\GridSamplerInstance.js","../../common/detector/WhiteRectangleDetector":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\detector\\WhiteRectangleDetector.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cdatamatrix%5Cdetector%5CDetector.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var WhiteRectangleDetector_1 = require("../../common/detector/WhiteRectangleDetector");
var DetectorResult_1 = require("../../common/DetectorResult");
var GridSamplerInstance_1 = require("../../common/GridSamplerInstance");
var NotFoundException_1 = require("../../NotFoundException");
var ResultPoint_1 = require("../../ResultPoint");
/*
 * Copyright 2008 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * <p>Encapsulates logic that can detect a Data Matrix Code in an image, even if the Data Matrix Code
 * is rotated or skewed, or partially obscured.</p>
 *
 * @author Sean Owen
 */
var Detector = /** @class */ (function () {
    function Detector(image) {
        this.image = image;
        this.rectangleDetector = new WhiteRectangleDetector_1.default(this.image);
    }
    /**
     * <p>Detects a Data Matrix Code in an image.</p>
     *
     * @return {@link DetectorResult} encapsulating results of detecting a Data Matrix Code
     * @throws NotFoundException if no Data Matrix Code can be found
     */
    Detector.prototype.detect = function () {
        var cornerPoints = this.rectangleDetector.detect();
        var points = this.detectSolid1(cornerPoints);
        points = this.detectSolid2(points);
        points[3] = this.correctTopRight(points);
        if (!points[3]) {
            throw new NotFoundException_1.default();
        }
        points = this.shiftToModuleCenter(points);
        var topLeft = points[0];
        var bottomLeft = points[1];
        var bottomRight = points[2];
        var topRight = points[3];
        var dimensionTop = this.transitionsBetween(topLeft, topRight) + 1;
        var dimensionRight = this.transitionsBetween(bottomRight, topRight) + 1;
        if ((dimensionTop & 0x01) === 1) {
            dimensionTop += 1;
        }
        if ((dimensionRight & 0x01) === 1) {
            dimensionRight += 1;
        }
        if (4 * dimensionTop < 7 * dimensionRight && 4 * dimensionRight < 7 * dimensionTop) {
            // The matrix is square
            dimensionTop = dimensionRight = Math.max(dimensionTop, dimensionRight);
        }
        var bits = Detector.sampleGrid(this.image, topLeft, bottomLeft, bottomRight, topRight, dimensionTop, dimensionRight);
        return new DetectorResult_1.default(bits, [topLeft, bottomLeft, bottomRight, topRight]);
    };
    Detector.shiftPoint = function (point, to, div) {
        var x = (to.getX() - point.getX()) / (div + 1);
        var y = (to.getY() - point.getY()) / (div + 1);
        return new ResultPoint_1.default(point.getX() + x, point.getY() + y);
    };
    Detector.moveAway = function (point, fromX, fromY) {
        var x = point.getX();
        var y = point.getY();
        if (x < fromX) {
            x -= 1;
        }
        else {
            x += 1;
        }
        if (y < fromY) {
            y -= 1;
        }
        else {
            y += 1;
        }
        return new ResultPoint_1.default(x, y);
    };
    /**
     * Detect a solid side which has minimum transition.
     */
    Detector.prototype.detectSolid1 = function (cornerPoints) {
        // 0  2
        // 1  3
        var pointA = cornerPoints[0];
        var pointB = cornerPoints[1];
        var pointC = cornerPoints[3];
        var pointD = cornerPoints[2];
        var trAB = this.transitionsBetween(pointA, pointB);
        var trBC = this.transitionsBetween(pointB, pointC);
        var trCD = this.transitionsBetween(pointC, pointD);
        var trDA = this.transitionsBetween(pointD, pointA);
        // 0..3
        // :  :
        // 1--2
        var min = trAB;
        var points = [pointD, pointA, pointB, pointC];
        if (min > trBC) {
            min = trBC;
            points[0] = pointA;
            points[1] = pointB;
            points[2] = pointC;
            points[3] = pointD;
        }
        if (min > trCD) {
            min = trCD;
            points[0] = pointB;
            points[1] = pointC;
            points[2] = pointD;
            points[3] = pointA;
        }
        if (min > trDA) {
            points[0] = pointC;
            points[1] = pointD;
            points[2] = pointA;
            points[3] = pointB;
        }
        return points;
    };
    /**
     * Detect a second solid side next to first solid side.
     */
    Detector.prototype.detectSolid2 = function (points) {
        // A..D
        // :  :
        // B--C
        var pointA = points[0];
        var pointB = points[1];
        var pointC = points[2];
        var pointD = points[3];
        // Transition detection on the edge is not stable.
        // To safely detect, shift the points to the module center.
        var tr = this.transitionsBetween(pointA, pointD);
        var pointBs = Detector.shiftPoint(pointB, pointC, (tr + 1) * 4);
        var pointCs = Detector.shiftPoint(pointC, pointB, (tr + 1) * 4);
        var trBA = this.transitionsBetween(pointBs, pointA);
        var trCD = this.transitionsBetween(pointCs, pointD);
        // 0..3
        // |  :
        // 1--2
        if (trBA < trCD) {
            // solid sides: A-B-C
            points[0] = pointA;
            points[1] = pointB;
            points[2] = pointC;
            points[3] = pointD;
        }
        else {
            // solid sides: B-C-D
            points[0] = pointB;
            points[1] = pointC;
            points[2] = pointD;
            points[3] = pointA;
        }
        return points;
    };
    /**
     * Calculates the corner position of the white top right module.
     */
    Detector.prototype.correctTopRight = function (points) {
        // A..D
        // |  :
        // B--C
        var pointA = points[0];
        var pointB = points[1];
        var pointC = points[2];
        var pointD = points[3];
        // shift points for safe transition detection.
        var trTop = this.transitionsBetween(pointA, pointD);
        var trRight = this.transitionsBetween(pointB, pointD);
        var pointAs = Detector.shiftPoint(pointA, pointB, (trRight + 1) * 4);
        var pointCs = Detector.shiftPoint(pointC, pointB, (trTop + 1) * 4);
        trTop = this.transitionsBetween(pointAs, pointD);
        trRight = this.transitionsBetween(pointCs, pointD);
        var candidate1 = new ResultPoint_1.default(pointD.getX() + (pointC.getX() - pointB.getX()) / (trTop + 1), pointD.getY() + (pointC.getY() - pointB.getY()) / (trTop + 1));
        var candidate2 = new ResultPoint_1.default(pointD.getX() + (pointA.getX() - pointB.getX()) / (trRight + 1), pointD.getY() + (pointA.getY() - pointB.getY()) / (trRight + 1));
        if (!this.isValid(candidate1)) {
            if (this.isValid(candidate2)) {
                return candidate2;
            }
            return null;
        }
        if (!this.isValid(candidate2)) {
            return candidate1;
        }
        var sumc1 = this.transitionsBetween(pointAs, candidate1) + this.transitionsBetween(pointCs, candidate1);
        var sumc2 = this.transitionsBetween(pointAs, candidate2) + this.transitionsBetween(pointCs, candidate2);
        if (sumc1 > sumc2) {
            return candidate1;
        }
        else {
            return candidate2;
        }
    };
    /**
     * Shift the edge points to the module center.
     */
    Detector.prototype.shiftToModuleCenter = function (points) {
        // A..D
        // |  :
        // B--C
        var pointA = points[0];
        var pointB = points[1];
        var pointC = points[2];
        var pointD = points[3];
        // calculate pseudo dimensions
        var dimH = this.transitionsBetween(pointA, pointD) + 1;
        var dimV = this.transitionsBetween(pointC, pointD) + 1;
        // shift points for safe dimension detection
        var pointAs = Detector.shiftPoint(pointA, pointB, dimV * 4);
        var pointCs = Detector.shiftPoint(pointC, pointB, dimH * 4);
        //  calculate more precise dimensions
        dimH = this.transitionsBetween(pointAs, pointD) + 1;
        dimV = this.transitionsBetween(pointCs, pointD) + 1;
        if ((dimH & 0x01) === 1) {
            dimH += 1;
        }
        if ((dimV & 0x01) === 1) {
            dimV += 1;
        }
        // WhiteRectangleDetector returns points inside of the rectangle.
        // I want points on the edges.
        var centerX = (pointA.getX() + pointB.getX() + pointC.getX() + pointD.getX()) / 4;
        var centerY = (pointA.getY() + pointB.getY() + pointC.getY() + pointD.getY()) / 4;
        pointA = Detector.moveAway(pointA, centerX, centerY);
        pointB = Detector.moveAway(pointB, centerX, centerY);
        pointC = Detector.moveAway(pointC, centerX, centerY);
        pointD = Detector.moveAway(pointD, centerX, centerY);
        var pointBs;
        var pointDs;
        // shift points to the center of each modules
        pointAs = Detector.shiftPoint(pointA, pointB, dimV * 4);
        pointAs = Detector.shiftPoint(pointAs, pointD, dimH * 4);
        pointBs = Detector.shiftPoint(pointB, pointA, dimV * 4);
        pointBs = Detector.shiftPoint(pointBs, pointC, dimH * 4);
        pointCs = Detector.shiftPoint(pointC, pointD, dimV * 4);
        pointCs = Detector.shiftPoint(pointCs, pointB, dimH * 4);
        pointDs = Detector.shiftPoint(pointD, pointC, dimV * 4);
        pointDs = Detector.shiftPoint(pointDs, pointA, dimH * 4);
        return [pointAs, pointBs, pointCs, pointDs];
    };
    Detector.prototype.isValid = function (p) {
        return p.getX() >= 0 && p.getX() < this.image.getWidth() && p.getY() > 0 && p.getY() < this.image.getHeight();
    };
    Detector.sampleGrid = function (image, topLeft, bottomLeft, bottomRight, topRight, dimensionX, dimensionY) {
        var sampler = GridSamplerInstance_1.default.getInstance();
        return sampler.sampleGrid(image, dimensionX, dimensionY, 0.5, 0.5, dimensionX - 0.5, 0.5, dimensionX - 0.5, dimensionY - 0.5, 0.5, dimensionY - 0.5, topLeft.getX(), topLeft.getY(), topRight.getX(), topRight.getY(), bottomRight.getX(), bottomRight.getY(), bottomLeft.getX(), bottomLeft.getY());
    };
    /**
     * Counts the number of black/white transitions between two points, using something like Bresenham's algorithm.
     */
    Detector.prototype.transitionsBetween = function (from, to) {
        // See QR Code Detector, sizeOfBlackWhiteBlackRun()
        var fromX = Math.trunc(from.getX());
        var fromY = Math.trunc(from.getY());
        var toX = Math.trunc(to.getX());
        var toY = Math.trunc(to.getY());
        var steep = Math.abs(toY - fromY) > Math.abs(toX - fromX);
        if (steep) {
            var temp = fromX;
            fromX = fromY;
            fromY = temp;
            temp = toX;
            toX = toY;
            toY = temp;
        }
        var dx = Math.abs(toX - fromX);
        var dy = Math.abs(toY - fromY);
        var error = -dx / 2;
        var ystep = fromY < toY ? 1 : -1;
        var xstep = fromX < toX ? 1 : -1;
        var transitions = 0;
        var inBlack = this.image.get(steep ? fromY : fromX, steep ? fromX : fromY);
        for (var x = fromX, y = fromY; x !== toX; x += xstep) {
            var isBlack = this.image.get(steep ? y : x, steep ? x : y);
            if (isBlack !== inBlack) {
                transitions++;
                inBlack = isBlack;
            }
            error += dy;
            if (error > 0) {
                if (y === toY) {
                    break;
                }
                y += ystep;
                error -= dx;
            }
        }
        return transitions;
    };
    return Detector;
}());
exports.default = Detector;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\detector\\Detector.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\ASCIIEncoder.js", {"./HighLevelEncoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\HighLevelEncoder.js","./constants":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\constants.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cdatamatrix%5Cencoder%5CASCIIEncoder.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ASCIIEncoder = void 0;
var constants_1 = require("./constants");
// tslint:disable-next-line:no-circular-imports
var HighLevelEncoder_1 = require("./HighLevelEncoder");
var ASCIIEncoder = /** @class */ (function () {
    function ASCIIEncoder() {
    }
    ASCIIEncoder.prototype.getEncodingMode = function () {
        return constants_1.ASCII_ENCODATION;
    };
    ASCIIEncoder.prototype.encode = function (context) {
        // step B
        var n = HighLevelEncoder_1.default.determineConsecutiveDigitCount(context.getMessage(), context.pos);
        if (n >= 2) {
            context.writeCodeword(this.encodeASCIIDigits(context.getMessage().charCodeAt(context.pos), context.getMessage().charCodeAt(context.pos + 1)));
            context.pos += 2;
        }
        else {
            var c = context.getCurrentChar();
            var newMode = HighLevelEncoder_1.default.lookAheadTest(context.getMessage(), context.pos, this.getEncodingMode());
            if (newMode !== this.getEncodingMode()) {
                switch (newMode) {
                    case constants_1.BASE256_ENCODATION:
                        context.writeCodeword(constants_1.LATCH_TO_BASE256);
                        context.signalEncoderChange(constants_1.BASE256_ENCODATION);
                        return;
                    case constants_1.C40_ENCODATION:
                        context.writeCodeword(constants_1.LATCH_TO_C40);
                        context.signalEncoderChange(constants_1.C40_ENCODATION);
                        return;
                    case constants_1.X12_ENCODATION:
                        context.writeCodeword(constants_1.LATCH_TO_ANSIX12);
                        context.signalEncoderChange(constants_1.X12_ENCODATION);
                        break;
                    case constants_1.TEXT_ENCODATION:
                        context.writeCodeword(constants_1.LATCH_TO_TEXT);
                        context.signalEncoderChange(constants_1.TEXT_ENCODATION);
                        break;
                    case constants_1.EDIFACT_ENCODATION:
                        context.writeCodeword(constants_1.LATCH_TO_EDIFACT);
                        context.signalEncoderChange(constants_1.EDIFACT_ENCODATION);
                        break;
                    default:
                        throw new Error('Illegal mode: ' + newMode);
                }
            }
            else if (HighLevelEncoder_1.default.isExtendedASCII(c)) {
                context.writeCodeword(constants_1.UPPER_SHIFT);
                context.writeCodeword(c - 128 + 1);
                context.pos++;
            }
            else {
                context.writeCodeword(c + 1);
                context.pos++;
            }
        }
    };
    ASCIIEncoder.prototype.encodeASCIIDigits = function (digit1, digit2) {
        if (HighLevelEncoder_1.default.isDigit(digit1) && HighLevelEncoder_1.default.isDigit(digit2)) {
            var num = (digit1 - 48) * 10 + (digit2 - 48);
            return num + 130;
        }
        throw new Error('not digits: ' + digit1 + digit2);
    };
    return ASCIIEncoder;
}());
exports.ASCIIEncoder = ASCIIEncoder;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\ASCIIEncoder.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\Base256Encoder.js", {"../../common/StringUtils":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\StringUtils.js","../../util/StringBuilder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\StringBuilder.js","./HighLevelEncoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\HighLevelEncoder.js","./constants":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\constants.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cdatamatrix%5Cencoder%5CBase256Encoder.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Base256Encoder = void 0;
var StringUtils_1 = require("../../common/StringUtils");
var StringBuilder_1 = require("../../util/StringBuilder");
var HighLevelEncoder_1 = require("./HighLevelEncoder");
var constants_1 = require("./constants");
var Base256Encoder = /** @class */ (function () {
    function Base256Encoder() {
    }
    Base256Encoder.prototype.getEncodingMode = function () {
        return constants_1.BASE256_ENCODATION;
    };
    Base256Encoder.prototype.encode = function (context) {
        var buffer = new StringBuilder_1.default();
        buffer.append(0); // Initialize length field
        while (context.hasMoreCharacters()) {
            var c = context.getCurrentChar();
            buffer.append(c);
            context.pos++;
            var newMode = HighLevelEncoder_1.default.lookAheadTest(context.getMessage(), context.pos, this.getEncodingMode());
            if (newMode !== this.getEncodingMode()) {
                // Return to ASCII encodation, which will actually handle latch to new mode
                context.signalEncoderChange(constants_1.ASCII_ENCODATION);
                break;
            }
        }
        var dataCount = buffer.length() - 1;
        var lengthFieldSize = 1;
        var currentSize = context.getCodewordCount() + dataCount + lengthFieldSize;
        context.updateSymbolInfo(currentSize);
        var mustPad = context.getSymbolInfo().getDataCapacity() - currentSize > 0;
        if (context.hasMoreCharacters() || mustPad) {
            if (dataCount <= 249) {
                buffer.setCharAt(0, StringUtils_1.default.getCharAt(dataCount));
            }
            else if (dataCount <= 1555) {
                buffer.setCharAt(0, StringUtils_1.default.getCharAt(Math.floor(dataCount / 250) + 249));
                buffer.insert(1, StringUtils_1.default.getCharAt(dataCount % 250));
            }
            else {
                throw new Error('Message length not in valid ranges: ' + dataCount);
            }
        }
        for (var i = 0, c = buffer.length(); i < c; i++) {
            context.writeCodeword(this.randomize255State(buffer.charAt(i).charCodeAt(0), context.getCodewordCount() + 1));
        }
    };
    Base256Encoder.prototype.randomize255State = function (ch, codewordPosition) {
        var pseudoRandom = ((149 * codewordPosition) % 255) + 1;
        var tempVariable = ch + pseudoRandom;
        if (tempVariable <= 255) {
            return tempVariable;
        }
        else {
            return tempVariable - 256;
        }
    };
    return Base256Encoder;
}());
exports.Base256Encoder = Base256Encoder;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\Base256Encoder.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\C40Encoder.js", {"../../util/StringBuilder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\StringBuilder.js","./HighLevelEncoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\HighLevelEncoder.js","./constants":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\constants.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cdatamatrix%5Cencoder%5CC40Encoder.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.C40Encoder = void 0;
var StringBuilder_1 = require("../../util/StringBuilder");
var HighLevelEncoder_1 = require("./HighLevelEncoder");
var constants_1 = require("./constants");
var C40Encoder = /** @class */ (function () {
    function C40Encoder() {
    }
    C40Encoder.prototype.getEncodingMode = function () {
        return constants_1.C40_ENCODATION;
    };
    C40Encoder.prototype.encodeMaximal = function (context) {
        var buffer = new StringBuilder_1.default();
        var lastCharSize = 0;
        var backtrackStartPosition = context.pos;
        var backtrackBufferLength = 0;
        while (context.hasMoreCharacters()) {
            var c = context.getCurrentChar();
            context.pos++;
            lastCharSize = this.encodeChar(c, buffer);
            if (buffer.length() % 3 === 0) {
                backtrackStartPosition = context.pos;
                backtrackBufferLength = buffer.length();
            }
        }
        if (backtrackBufferLength !== buffer.length()) {
            var unwritten = Math.floor((buffer.length() / 3) * 2);
            var curCodewordCount = Math.floor(context.getCodewordCount() + unwritten + 1); // +1 for the latch to C40
            context.updateSymbolInfo(curCodewordCount);
            var available = context.getSymbolInfo().getDataCapacity() - curCodewordCount;
            var rest = Math.floor(buffer.length() % 3);
            if ((rest === 2 && available !== 2) ||
                (rest === 1 && (lastCharSize > 3 || available !== 1))) {
                // buffer.setLength(backtrackBufferLength);
                context.pos = backtrackStartPosition;
            }
        }
        if (buffer.length() > 0) {
            context.writeCodeword(constants_1.LATCH_TO_C40);
        }
        this.handleEOD(context, buffer);
    };
    C40Encoder.prototype.encode = function (context) {
        // step C
        var buffer = new StringBuilder_1.default();
        while (context.hasMoreCharacters()) {
            var c = context.getCurrentChar();
            context.pos++;
            var lastCharSize = this.encodeChar(c, buffer);
            var unwritten = Math.floor(buffer.length() / 3) * 2;
            var curCodewordCount = context.getCodewordCount() + unwritten;
            context.updateSymbolInfo(curCodewordCount);
            var available = context.getSymbolInfo().getDataCapacity() - curCodewordCount;
            if (!context.hasMoreCharacters()) {
                // Avoid having a single C40 value in the last triplet
                var removed = new StringBuilder_1.default();
                if (buffer.length() % 3 === 2 && available !== 2) {
                    lastCharSize = this.backtrackOneCharacter(context, buffer, removed, lastCharSize);
                }
                while (buffer.length() % 3 === 1 &&
                    (lastCharSize > 3 || available !== 1)) {
                    lastCharSize = this.backtrackOneCharacter(context, buffer, removed, lastCharSize);
                }
                break;
            }
            var count = buffer.length();
            if (count % 3 === 0) {
                var newMode = HighLevelEncoder_1.default.lookAheadTest(context.getMessage(), context.pos, this.getEncodingMode());
                if (newMode !== this.getEncodingMode()) {
                    // Return to ASCII encodation, which will actually handle latch to new mode
                    context.signalEncoderChange(constants_1.ASCII_ENCODATION);
                    break;
                }
            }
        }
        this.handleEOD(context, buffer);
    };
    C40Encoder.prototype.backtrackOneCharacter = function (context, buffer, removed, lastCharSize) {
        var count = buffer.length();
        var test = buffer.toString().substring(0, count - lastCharSize);
        buffer.setLengthToZero();
        buffer.append(test);
        // buffer.delete(count - lastCharSize, count);
        /*for (let i = count - lastCharSize; i < count; i++) {
          buffer.deleteCharAt(i);
        }*/
        context.pos--;
        var c = context.getCurrentChar();
        lastCharSize = this.encodeChar(c, removed);
        context.resetSymbolInfo(); // Deal with possible reduction in symbol size
        return lastCharSize;
    };
    C40Encoder.prototype.writeNextTriplet = function (context, buffer) {
        context.writeCodewords(this.encodeToCodewords(buffer.toString()));
        var test = buffer.toString().substring(3);
        buffer.setLengthToZero();
        buffer.append(test);
        // buffer.delete(0, 3);
        /*for (let i = 0; i < 3; i++) {
          buffer.deleteCharAt(i);
        }*/
    };
    /**
     * Handle "end of data" situations
     *
     * @param context the encoder context
     * @param buffer  the buffer with the remaining encoded characters
     */
    C40Encoder.prototype.handleEOD = function (context, buffer) {
        var unwritten = Math.floor((buffer.length() / 3) * 2);
        var rest = buffer.length() % 3;
        var curCodewordCount = context.getCodewordCount() + unwritten;
        context.updateSymbolInfo(curCodewordCount);
        var available = context.getSymbolInfo().getDataCapacity() - curCodewordCount;
        if (rest === 2) {
            buffer.append('\0'); // Shift 1
            while (buffer.length() >= 3) {
                this.writeNextTriplet(context, buffer);
            }
            if (context.hasMoreCharacters()) {
                context.writeCodeword(constants_1.C40_UNLATCH);
            }
        }
        else if (available === 1 && rest === 1) {
            while (buffer.length() >= 3) {
                this.writeNextTriplet(context, buffer);
            }
            if (context.hasMoreCharacters()) {
                context.writeCodeword(constants_1.C40_UNLATCH);
            }
            // else no unlatch
            context.pos--;
        }
        else if (rest === 0) {
            while (buffer.length() >= 3) {
                this.writeNextTriplet(context, buffer);
            }
            if (available > 0 || context.hasMoreCharacters()) {
                context.writeCodeword(constants_1.C40_UNLATCH);
            }
        }
        else {
            throw new Error('Unexpected case. Please report!');
        }
        context.signalEncoderChange(constants_1.ASCII_ENCODATION);
    };
    C40Encoder.prototype.encodeChar = function (c, sb) {
        if (c === ' '.charCodeAt(0)) {
            sb.append(3);
            return 1;
        }
        if (c >= '0'.charCodeAt(0) && c <= '9'.charCodeAt(0)) {
            sb.append(c - 48 + 4);
            return 1;
        }
        if (c >= 'A'.charCodeAt(0) && c <= 'Z'.charCodeAt(0)) {
            sb.append(c - 65 + 14);
            return 1;
        }
        if (c < ' '.charCodeAt(0)) {
            sb.append(0); // Shift 1 Set
            sb.append(c);
            return 2;
        }
        if (c <= '/'.charCodeAt(0)) {
            sb.append(1); // Shift 2 Set
            sb.append(c - 33);
            return 2;
        }
        if (c <= '@'.charCodeAt(0)) {
            sb.append(1); // Shift 2 Set
            sb.append(c - 58 + 15);
            return 2;
        }
        if (c <= '_'.charCodeAt(0)) {
            sb.append(1); // Shift 2 Set
            sb.append(c - 91 + 22);
            return 2;
        }
        if (c <= 127) {
            sb.append(2); // Shift 3 Set
            sb.append(c - 96);
            return 2;
        }
        sb.append(1 + "\u001E"); // Shift 2, Upper Shift
        var len = 2;
        len += this.encodeChar(c - 128, sb);
        return len;
    };
    C40Encoder.prototype.encodeToCodewords = function (sb) {
        var v = 1600 * sb.charCodeAt(0) + 40 * sb.charCodeAt(1) + sb.charCodeAt(2) + 1;
        var cw1 = v / 256;
        var cw2 = v % 256;
        var result = new StringBuilder_1.default();
        result.append(cw1);
        result.append(cw2);
        return result.toString();
    };
    return C40Encoder;
}());
exports.C40Encoder = C40Encoder;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\C40Encoder.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\DefaultPlacement.js", {"../../util/Arrays":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\Arrays.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cdatamatrix%5Cencoder%5CDefaultPlacement.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var Arrays_1 = require("../../util/Arrays");
/**
 * Symbol Character Placement Program. Adapted from Annex M.1 in ISO/IEC 16022:2000(E).
 */
var DefaultPlacement = /** @class */ (function () {
    /**
     * Main constructor
     *
     * @param codewords the codewords to place
     * @param numcols   the number of columns
     * @param numrows   the number of rows
     */
    function DefaultPlacement(codewords, numcols, numrows) {
        this.codewords = codewords;
        this.numcols = numcols;
        this.numrows = numrows;
        this.bits = new Uint8Array(numcols * numrows);
        Arrays_1.default.fill(this.bits, 2); // Initialize with "not set" value
    }
    DefaultPlacement.prototype.getNumrows = function () {
        return this.numrows;
    };
    DefaultPlacement.prototype.getNumcols = function () {
        return this.numcols;
    };
    DefaultPlacement.prototype.getBits = function () {
        return this.bits;
    };
    DefaultPlacement.prototype.getBit = function (col, row) {
        return this.bits[row * this.numcols + col] === 1;
    };
    DefaultPlacement.prototype.setBit = function (col, row, bit) {
        this.bits[row * this.numcols + col] = bit ? 1 : 0;
    };
    DefaultPlacement.prototype.noBit = function (col, row) {
        return this.bits[row * this.numcols + col] === 2;
    };
    DefaultPlacement.prototype.place = function () {
        var pos = 0;
        var row = 4;
        var col = 0;
        do {
            // repeatedly first check for one of the special corner cases, then...
            if (row === this.numrows && col === 0) {
                this.corner1(pos++);
            }
            if (row === this.numrows - 2 && col === 0 && this.numcols % 4 !== 0) {
                this.corner2(pos++);
            }
            if (row === this.numrows - 2 && col === 0 && this.numcols % 8 === 4) {
                this.corner3(pos++);
            }
            if (row === this.numrows + 4 && col === 2 && this.numcols % 8 === 0) {
                this.corner4(pos++);
            }
            // sweep upward diagonally, inserting successive characters...
            do {
                if (row < this.numrows && col >= 0 && this.noBit(col, row)) {
                    this.utah(row, col, pos++);
                }
                row -= 2;
                col += 2;
            } while (row >= 0 && col < this.numcols);
            row++;
            col += 3;
            // and then sweep downward diagonally, inserting successive characters, ...
            do {
                if (row >= 0 && col < this.numcols && this.noBit(col, row)) {
                    this.utah(row, col, pos++);
                }
                row += 2;
                col -= 2;
            } while (row < this.numrows && col >= 0);
            row += 3;
            col++;
            // ...until the entire array is scanned
        } while (row < this.numrows || col < this.numcols);
        // Lastly, if the lower right-hand corner is untouched, fill in fixed pattern
        if (this.noBit(this.numcols - 1, this.numrows - 1)) {
            this.setBit(this.numcols - 1, this.numrows - 1, true);
            this.setBit(this.numcols - 2, this.numrows - 2, true);
        }
    };
    DefaultPlacement.prototype.module = function (row, col, pos, bit) {
        if (row < 0) {
            row += this.numrows;
            col += 4 - ((this.numrows + 4) % 8);
        }
        if (col < 0) {
            col += this.numcols;
            row += 4 - ((this.numcols + 4) % 8);
        }
        // Note the conversion:
        var v = this.codewords.charCodeAt(pos);
        v &= 1 << (8 - bit);
        this.setBit(col, row, v !== 0);
    };
    /**
     * Places the 8 bits of a utah-shaped symbol character in ECC200.
     *
     * @param row the row
     * @param col the column
     * @param pos character position
     */
    DefaultPlacement.prototype.utah = function (row, col, pos) {
        this.module(row - 2, col - 2, pos, 1);
        this.module(row - 2, col - 1, pos, 2);
        this.module(row - 1, col - 2, pos, 3);
        this.module(row - 1, col - 1, pos, 4);
        this.module(row - 1, col, pos, 5);
        this.module(row, col - 2, pos, 6);
        this.module(row, col - 1, pos, 7);
        this.module(row, col, pos, 8);
    };
    DefaultPlacement.prototype.corner1 = function (pos) {
        this.module(this.numrows - 1, 0, pos, 1);
        this.module(this.numrows - 1, 1, pos, 2);
        this.module(this.numrows - 1, 2, pos, 3);
        this.module(0, this.numcols - 2, pos, 4);
        this.module(0, this.numcols - 1, pos, 5);
        this.module(1, this.numcols - 1, pos, 6);
        this.module(2, this.numcols - 1, pos, 7);
        this.module(3, this.numcols - 1, pos, 8);
    };
    DefaultPlacement.prototype.corner2 = function (pos) {
        this.module(this.numrows - 3, 0, pos, 1);
        this.module(this.numrows - 2, 0, pos, 2);
        this.module(this.numrows - 1, 0, pos, 3);
        this.module(0, this.numcols - 4, pos, 4);
        this.module(0, this.numcols - 3, pos, 5);
        this.module(0, this.numcols - 2, pos, 6);
        this.module(0, this.numcols - 1, pos, 7);
        this.module(1, this.numcols - 1, pos, 8);
    };
    DefaultPlacement.prototype.corner3 = function (pos) {
        this.module(this.numrows - 3, 0, pos, 1);
        this.module(this.numrows - 2, 0, pos, 2);
        this.module(this.numrows - 1, 0, pos, 3);
        this.module(0, this.numcols - 2, pos, 4);
        this.module(0, this.numcols - 1, pos, 5);
        this.module(1, this.numcols - 1, pos, 6);
        this.module(2, this.numcols - 1, pos, 7);
        this.module(3, this.numcols - 1, pos, 8);
    };
    DefaultPlacement.prototype.corner4 = function (pos) {
        this.module(this.numrows - 1, 0, pos, 1);
        this.module(this.numrows - 1, this.numcols - 1, pos, 2);
        this.module(0, this.numcols - 3, pos, 3);
        this.module(0, this.numcols - 2, pos, 4);
        this.module(0, this.numcols - 1, pos, 5);
        this.module(1, this.numcols - 3, pos, 6);
        this.module(1, this.numcols - 2, pos, 7);
        this.module(1, this.numcols - 1, pos, 8);
    };
    return DefaultPlacement;
}());
exports.default = DefaultPlacement;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\DefaultPlacement.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\EdifactEncoder.js", {"../../common/StringUtils":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\StringUtils.js","../../util/StringBuilder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\StringBuilder.js","./HighLevelEncoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\HighLevelEncoder.js","./constants":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\constants.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cdatamatrix%5Cencoder%5CEdifactEncoder.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EdifactEncoder = void 0;
var StringUtils_1 = require("../../common/StringUtils");
var StringBuilder_1 = require("../../util/StringBuilder");
var constants_1 = require("./constants");
var HighLevelEncoder_1 = require("./HighLevelEncoder");
var EdifactEncoder = /** @class */ (function () {
    function EdifactEncoder() {
    }
    EdifactEncoder.prototype.getEncodingMode = function () {
        return constants_1.EDIFACT_ENCODATION;
    };
    EdifactEncoder.prototype.encode = function (context) {
        // step F
        var buffer = new StringBuilder_1.default();
        while (context.hasMoreCharacters()) {
            var c = context.getCurrentChar();
            this.encodeChar(c, buffer);
            context.pos++;
            var count = buffer.length();
            if (count >= 4) {
                context.writeCodewords(this.encodeToCodewords(buffer.toString()));
                var test_1 = buffer.toString().substring(4);
                buffer.setLengthToZero();
                buffer.append(test_1);
                // buffer.delete(0, 4);
                // for (let i = 0; i < 4; i++) {
                //  buffer.deleteCharAt(i);
                // }
                var newMode = HighLevelEncoder_1.default.lookAheadTest(context.getMessage(), context.pos, this.getEncodingMode());
                if (newMode !== this.getEncodingMode()) {
                    // Return to ASCII encodation, which will actually handle latch to new mode
                    context.signalEncoderChange(constants_1.ASCII_ENCODATION);
                    break;
                }
            }
        }
        buffer.append(StringUtils_1.default.getCharAt(31)); // Unlatch
        this.handleEOD(context, buffer);
    };
    /**
     * Handle "end of data" situations
     *
     * @param context the encoder context
     * @param buffer  the buffer with the remaining encoded characters
     */
    EdifactEncoder.prototype.handleEOD = function (context, buffer) {
        try {
            var count = buffer.length();
            if (count === 0) {
                return; // Already finished
            }
            if (count === 1) {
                // Only an unlatch at the end
                context.updateSymbolInfo();
                var available = context.getSymbolInfo().getDataCapacity() -
                    context.getCodewordCount();
                var remaining = context.getRemainingCharacters();
                // The following two lines are a hack inspired by the 'fix' from https://sourceforge.net/p/barcode4j/svn/221/
                if (remaining > available) {
                    context.updateSymbolInfo(context.getCodewordCount() + 1);
                    available =
                        context.getSymbolInfo().getDataCapacity() -
                            context.getCodewordCount();
                }
                if (remaining <= available && available <= 2) {
                    return; // No unlatch
                }
            }
            if (count > 4) {
                throw new Error('Count must not exceed 4');
            }
            var restChars = count - 1;
            var encoded = this.encodeToCodewords(buffer.toString());
            var endOfSymbolReached = !context.hasMoreCharacters();
            var restInAscii = endOfSymbolReached && restChars <= 2;
            if (restChars <= 2) {
                context.updateSymbolInfo(context.getCodewordCount() + restChars);
                var available = context.getSymbolInfo().getDataCapacity() -
                    context.getCodewordCount();
                if (available >= 3) {
                    restInAscii = false;
                    context.updateSymbolInfo(context.getCodewordCount() + encoded.length);
                    // available = context.symbolInfo.dataCapacity - context.getCodewordCount();
                }
            }
            if (restInAscii) {
                context.resetSymbolInfo();
                context.pos -= restChars;
            }
            else {
                context.writeCodewords(encoded);
            }
        }
        finally {
            context.signalEncoderChange(constants_1.ASCII_ENCODATION);
        }
    };
    EdifactEncoder.prototype.encodeChar = function (c, sb) {
        if (c >= ' '.charCodeAt(0) && c <= '?'.charCodeAt(0)) {
            sb.append(c);
        }
        else if (c >= '@'.charCodeAt(0) && c <= '^'.charCodeAt(0)) {
            sb.append(StringUtils_1.default.getCharAt(c - 64));
        }
        else {
            HighLevelEncoder_1.default.illegalCharacter(StringUtils_1.default.getCharAt(c));
        }
    };
    EdifactEncoder.prototype.encodeToCodewords = function (sb) {
        var len = sb.length;
        if (len === 0) {
            throw new Error('StringBuilder must not be empty');
        }
        var c1 = sb.charAt(0).charCodeAt(0);
        var c2 = len >= 2 ? sb.charAt(1).charCodeAt(0) : 0;
        var c3 = len >= 3 ? sb.charAt(2).charCodeAt(0) : 0;
        var c4 = len >= 4 ? sb.charAt(3).charCodeAt(0) : 0;
        var v = (c1 << 18) + (c2 << 12) + (c3 << 6) + c4;
        var cw1 = (v >> 16) & 255;
        var cw2 = (v >> 8) & 255;
        var cw3 = v & 255;
        var res = new StringBuilder_1.default();
        res.append(cw1);
        if (len >= 2) {
            res.append(cw2);
        }
        if (len >= 3) {
            res.append(cw3);
        }
        return res.toString();
    };
    return EdifactEncoder;
}());
exports.EdifactEncoder = EdifactEncoder;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\EdifactEncoder.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\EncoderContext.js", {"../../util/StringBuilder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\StringBuilder.js","./SymbolInfo":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\SymbolInfo.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cdatamatrix%5Cencoder%5CEncoderContext.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EncoderContext = void 0;
var StringBuilder_1 = require("../../util/StringBuilder");
var SymbolInfo_1 = require("./SymbolInfo");
var EncoderContext = /** @class */ (function () {
    function EncoderContext(msg) {
        this.msg = msg;
        this.pos = 0;
        this.skipAtEnd = 0;
        // From this point on Strings are not Unicode anymore!
        var msgBinary = msg.split('').map(function (c) { return c.charCodeAt(0); });
        var sb = new StringBuilder_1.default();
        for (var i = 0, c = msgBinary.length; i < c; i++) {
            var ch = String.fromCharCode(msgBinary[i] & 0xff);
            if (ch === '?' && msg.charAt(i) !== '?') {
                throw new Error('Message contains characters outside ISO-8859-1 encoding.');
            }
            sb.append(ch);
        }
        this.msg = sb.toString(); // Not Unicode here!
        this.shape = 0 /* FORCE_NONE */;
        this.codewords = new StringBuilder_1.default();
        this.newEncoding = -1;
    }
    EncoderContext.prototype.setSymbolShape = function (shape) {
        this.shape = shape;
    };
    EncoderContext.prototype.setSizeConstraints = function (minSize, maxSize) {
        this.minSize = minSize;
        this.maxSize = maxSize;
    };
    EncoderContext.prototype.getMessage = function () {
        return this.msg;
    };
    EncoderContext.prototype.setSkipAtEnd = function (count) {
        this.skipAtEnd = count;
    };
    EncoderContext.prototype.getCurrentChar = function () {
        return this.msg.charCodeAt(this.pos);
    };
    EncoderContext.prototype.getCurrent = function () {
        return this.msg.charCodeAt(this.pos);
    };
    EncoderContext.prototype.getCodewords = function () {
        return this.codewords;
    };
    EncoderContext.prototype.writeCodewords = function (codewords) {
        this.codewords.append(codewords);
    };
    EncoderContext.prototype.writeCodeword = function (codeword) {
        this.codewords.append(codeword);
    };
    EncoderContext.prototype.getCodewordCount = function () {
        return this.codewords.length();
    };
    EncoderContext.prototype.getNewEncoding = function () {
        return this.newEncoding;
    };
    EncoderContext.prototype.signalEncoderChange = function (encoding) {
        this.newEncoding = encoding;
    };
    EncoderContext.prototype.resetEncoderSignal = function () {
        this.newEncoding = -1;
    };
    EncoderContext.prototype.hasMoreCharacters = function () {
        return this.pos < this.getTotalMessageCharCount();
    };
    EncoderContext.prototype.getTotalMessageCharCount = function () {
        return this.msg.length - this.skipAtEnd;
    };
    EncoderContext.prototype.getRemainingCharacters = function () {
        return this.getTotalMessageCharCount() - this.pos;
    };
    EncoderContext.prototype.getSymbolInfo = function () {
        return this.symbolInfo;
    };
    EncoderContext.prototype.updateSymbolInfo = function (len) {
        if (len === void 0) { len = this.getCodewordCount(); }
        if (this.symbolInfo == null || len > this.symbolInfo.getDataCapacity()) {
            this.symbolInfo = SymbolInfo_1.default.lookup(len, this.shape, this.minSize, this.maxSize, true);
        }
    };
    EncoderContext.prototype.resetSymbolInfo = function () {
        this.symbolInfo = null;
    };
    return EncoderContext;
}());
exports.EncoderContext = EncoderContext;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\EncoderContext.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\ErrorCorrection.js", {"../../util/StringBuilder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\StringBuilder.js","./constants":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\constants.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cdatamatrix%5Cencoder%5CErrorCorrection.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var StringBuilder_1 = require("../../util/StringBuilder");
var constants_1 = require("./constants");
/**
 * Error Correction Code for ECC200.
 */
var ErrorCorrection = /** @class */ (function () {
    function ErrorCorrection() {
    }
    /**
     * Creates the ECC200 error correction for an encoded message.
     *
     * @param codewords  the codewords
     * @param symbolInfo information about the symbol to be encoded
     * @return the codewords with interleaved error correction.
     */
    ErrorCorrection.encodeECC200 = function (codewords, symbolInfo) {
        if (codewords.length !== symbolInfo.getDataCapacity()) {
            throw new Error('The number of codewords does not match the selected symbol');
        }
        var sb = new StringBuilder_1.default();
        sb.append(codewords);
        var blockCount = symbolInfo.getInterleavedBlockCount();
        if (blockCount === 1) {
            var ecc = this.createECCBlock(codewords, symbolInfo.getErrorCodewords());
            sb.append(ecc);
        }
        else {
            // sb.setLength(sb.capacity());
            var dataSizes = [];
            var errorSizes = [];
            for (var i = 0; i < blockCount; i++) {
                dataSizes[i] = symbolInfo.getDataLengthForInterleavedBlock(i + 1);
                errorSizes[i] = symbolInfo.getErrorLengthForInterleavedBlock(i + 1);
            }
            for (var block = 0; block < blockCount; block++) {
                var temp = new StringBuilder_1.default();
                for (var d = block; d < symbolInfo.getDataCapacity(); d += blockCount) {
                    temp.append(codewords.charAt(d));
                }
                var ecc = this.createECCBlock(temp.toString(), errorSizes[block]);
                var pos = 0;
                for (var e = block; e < errorSizes[block] * blockCount; e += blockCount) {
                    sb.setCharAt(symbolInfo.getDataCapacity() + e, ecc.charAt(pos++));
                }
            }
        }
        return sb.toString();
    };
    ErrorCorrection.createECCBlock = function (codewords, numECWords) {
        var table = -1;
        for (var i = 0; i < constants_1.FACTOR_SETS.length; i++) {
            if (constants_1.FACTOR_SETS[i] === numECWords) {
                table = i;
                break;
            }
        }
        if (table < 0) {
            throw new Error('Illegal number of error correction codewords specified: ' + numECWords);
        }
        var poly = constants_1.FACTORS[table];
        var ecc = [];
        for (var i = 0; i < numECWords; i++) {
            ecc[i] = 0;
        }
        for (var i = 0; i < codewords.length; i++) {
            var m = ecc[numECWords - 1] ^ codewords.charAt(i).charCodeAt(0);
            for (var k = numECWords - 1; k > 0; k--) {
                if (m !== 0 && poly[k] !== 0) {
                    ecc[k] = ecc[k - 1] ^ constants_1.ALOG[(constants_1.LOG[m] + constants_1.LOG[poly[k]]) % 255];
                }
                else {
                    ecc[k] = ecc[k - 1];
                }
            }
            if (m !== 0 && poly[0] !== 0) {
                ecc[0] = constants_1.ALOG[(constants_1.LOG[m] + constants_1.LOG[poly[0]]) % 255];
            }
            else {
                ecc[0] = 0;
            }
        }
        var eccReversed = [];
        for (var i = 0; i < numECWords; i++) {
            eccReversed[i] = ecc[numECWords - i - 1];
        }
        return eccReversed.map(function (c) { return String.fromCharCode(c); }).join('');
    };
    return ErrorCorrection;
}());
exports.default = ErrorCorrection;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\ErrorCorrection.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\HighLevelEncoder.js", {"../../util/Arrays":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\Arrays.js","../../util/Integer":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\Integer.js","./ASCIIEncoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\ASCIIEncoder.js","./Base256Encoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\Base256Encoder.js","./C40Encoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\C40Encoder.js","./EdifactEncoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\EdifactEncoder.js","./EncoderContext":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\EncoderContext.js","./TextEncoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\TextEncoder.js","./X12Encoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\X12Encoder.js","./constants":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\constants.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cdatamatrix%5Cencoder%5CHighLevelEncoder.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// tslint:disable-next-line:no-circular-imports
var ASCIIEncoder_1 = require("./ASCIIEncoder");
// tslint:disable-next-line:no-circular-imports
var Base256Encoder_1 = require("./Base256Encoder");
// tslint:disable-next-line:no-circular-imports
var C40Encoder_1 = require("./C40Encoder");
var constants_1 = require("./constants");
// tslint:disable-next-line:no-circular-imports
var EdifactEncoder_1 = require("./EdifactEncoder");
var EncoderContext_1 = require("./EncoderContext");
// tslint:disable-next-line:no-circular-imports
var X12Encoder_1 = require("./X12Encoder");
// tslint:disable-next-line:no-circular-imports
var TextEncoder_1 = require("./TextEncoder");
var Arrays_1 = require("../../util/Arrays");
var Integer_1 = require("../../util/Integer");
/**
 * DataMatrix ECC 200 data encoder following the algorithm described in ISO/IEC 16022:200(E) in
 * annex S.
 */
var HighLevelEncoder = /** @class */ (function () {
    function HighLevelEncoder() {
    }
    HighLevelEncoder.randomize253State = function (codewordPosition) {
        var pseudoRandom = ((149 * codewordPosition) % 253) + 1;
        var tempVariable = constants_1.PAD + pseudoRandom;
        return tempVariable <= 254 ? tempVariable : tempVariable - 254;
    };
    /**
     * Performs message encoding of a DataMatrix message using the algorithm described in annex P
     * of ISO/IEC 16022:2000(E).
     *
     * @param msg     the message
     * @param shape   requested shape. May be {@code SymbolShapeHint.FORCE_NONE},
     *                {@code SymbolShapeHint.FORCE_SQUARE} or {@code SymbolShapeHint.FORCE_RECTANGLE}.
     * @param minSize the minimum symbol size constraint or null for no constraint
     * @param maxSize the maximum symbol size constraint or null for no constraint
     * @param forceC40 enforce C40 encoding
     * @return the encoded message (the char values range from 0 to 255)
     */
    HighLevelEncoder.encodeHighLevel = function (msg, shape, minSize, maxSize, forceC40) {
        if (shape === void 0) { shape = 0 /* FORCE_NONE */; }
        if (minSize === void 0) { minSize = null; }
        if (maxSize === void 0) { maxSize = null; }
        if (forceC40 === void 0) { forceC40 = false; }
        // the codewords 0..255 are encoded as Unicode characters
        var c40Encoder = new C40Encoder_1.C40Encoder();
        var encoders = [
            new ASCIIEncoder_1.ASCIIEncoder(),
            c40Encoder,
            new TextEncoder_1.TextEncoder(),
            new X12Encoder_1.X12Encoder(),
            new EdifactEncoder_1.EdifactEncoder(),
            new Base256Encoder_1.Base256Encoder(),
        ];
        var context = new EncoderContext_1.EncoderContext(msg);
        context.setSymbolShape(shape);
        context.setSizeConstraints(minSize, maxSize);
        if (msg.startsWith(constants_1.MACRO_05_HEADER) && msg.endsWith(constants_1.MACRO_TRAILER)) {
            context.writeCodeword(constants_1.MACRO_05);
            context.setSkipAtEnd(2);
            context.pos += constants_1.MACRO_05_HEADER.length;
        }
        else if (msg.startsWith(constants_1.MACRO_06_HEADER) && msg.endsWith(constants_1.MACRO_TRAILER)) {
            context.writeCodeword(constants_1.MACRO_06);
            context.setSkipAtEnd(2);
            context.pos += constants_1.MACRO_06_HEADER.length;
        }
        var encodingMode = constants_1.ASCII_ENCODATION; // Default mode
        if (forceC40) {
            c40Encoder.encodeMaximal(context);
            encodingMode = context.getNewEncoding();
            context.resetEncoderSignal();
        }
        while (context.hasMoreCharacters()) {
            encoders[encodingMode].encode(context);
            if (context.getNewEncoding() >= 0) {
                encodingMode = context.getNewEncoding();
                context.resetEncoderSignal();
            }
        }
        var len = context.getCodewordCount();
        context.updateSymbolInfo();
        var capacity = context.getSymbolInfo().getDataCapacity();
        if (len < capacity &&
            encodingMode !== constants_1.ASCII_ENCODATION &&
            encodingMode !== constants_1.BASE256_ENCODATION &&
            encodingMode !== constants_1.EDIFACT_ENCODATION) {
            context.writeCodeword('\u00fe'); // Unlatch (254)
        }
        // Padding
        var codewords = context.getCodewords();
        if (codewords.length() < capacity) {
            codewords.append(constants_1.PAD);
        }
        while (codewords.length() < capacity) {
            codewords.append(this.randomize253State(codewords.length() + 1));
        }
        return context.getCodewords().toString();
    };
    HighLevelEncoder.lookAheadTest = function (msg, startpos, currentMode) {
        var newMode = this.lookAheadTestIntern(msg, startpos, currentMode);
        if (currentMode === constants_1.X12_ENCODATION && newMode === constants_1.X12_ENCODATION) {
            var endpos = Math.min(startpos + 3, msg.length);
            for (var i = startpos; i < endpos; i++) {
                if (!this.isNativeX12(msg.charCodeAt(i))) {
                    return constants_1.ASCII_ENCODATION;
                }
            }
        }
        else if (currentMode === constants_1.EDIFACT_ENCODATION &&
            newMode === constants_1.EDIFACT_ENCODATION) {
            var endpos = Math.min(startpos + 4, msg.length);
            for (var i = startpos; i < endpos; i++) {
                if (!this.isNativeEDIFACT(msg.charCodeAt(i))) {
                    return constants_1.ASCII_ENCODATION;
                }
            }
        }
        return newMode;
    };
    HighLevelEncoder.lookAheadTestIntern = function (msg, startpos, currentMode) {
        if (startpos >= msg.length) {
            return currentMode;
        }
        var charCounts;
        // step J
        if (currentMode === constants_1.ASCII_ENCODATION) {
            charCounts = [0, 1, 1, 1, 1, 1.25];
        }
        else {
            charCounts = [1, 2, 2, 2, 2, 2.25];
            charCounts[currentMode] = 0;
        }
        var charsProcessed = 0;
        var mins = new Uint8Array(6);
        var intCharCounts = [];
        while (true) {
            // step K
            if (startpos + charsProcessed === msg.length) {
                Arrays_1.default.fill(mins, 0);
                Arrays_1.default.fill(intCharCounts, 0);
                var min = this.findMinimums(charCounts, intCharCounts, Integer_1.default.MAX_VALUE, mins);
                var minCount = this.getMinimumCount(mins);
                if (intCharCounts[constants_1.ASCII_ENCODATION] === min) {
                    return constants_1.ASCII_ENCODATION;
                }
                if (minCount === 1) {
                    if (mins[constants_1.BASE256_ENCODATION] > 0) {
                        return constants_1.BASE256_ENCODATION;
                    }
                    if (mins[constants_1.EDIFACT_ENCODATION] > 0) {
                        return constants_1.EDIFACT_ENCODATION;
                    }
                    if (mins[constants_1.TEXT_ENCODATION] > 0) {
                        return constants_1.TEXT_ENCODATION;
                    }
                    if (mins[constants_1.X12_ENCODATION] > 0) {
                        return constants_1.X12_ENCODATION;
                    }
                }
                return constants_1.C40_ENCODATION;
            }
            var c = msg.charCodeAt(startpos + charsProcessed);
            charsProcessed++;
            // step L
            if (this.isDigit(c)) {
                charCounts[constants_1.ASCII_ENCODATION] += 0.5;
            }
            else if (this.isExtendedASCII(c)) {
                charCounts[constants_1.ASCII_ENCODATION] = Math.ceil(charCounts[constants_1.ASCII_ENCODATION]);
                charCounts[constants_1.ASCII_ENCODATION] += 2.0;
            }
            else {
                charCounts[constants_1.ASCII_ENCODATION] = Math.ceil(charCounts[constants_1.ASCII_ENCODATION]);
                charCounts[constants_1.ASCII_ENCODATION]++;
            }
            // step M
            if (this.isNativeC40(c)) {
                charCounts[constants_1.C40_ENCODATION] += 2.0 / 3.0;
            }
            else if (this.isExtendedASCII(c)) {
                charCounts[constants_1.C40_ENCODATION] += 8.0 / 3.0;
            }
            else {
                charCounts[constants_1.C40_ENCODATION] += 4.0 / 3.0;
            }
            // step N
            if (this.isNativeText(c)) {
                charCounts[constants_1.TEXT_ENCODATION] += 2.0 / 3.0;
            }
            else if (this.isExtendedASCII(c)) {
                charCounts[constants_1.TEXT_ENCODATION] += 8.0 / 3.0;
            }
            else {
                charCounts[constants_1.TEXT_ENCODATION] += 4.0 / 3.0;
            }
            // step O
            if (this.isNativeX12(c)) {
                charCounts[constants_1.X12_ENCODATION] += 2.0 / 3.0;
            }
            else if (this.isExtendedASCII(c)) {
                charCounts[constants_1.X12_ENCODATION] += 13.0 / 3.0;
            }
            else {
                charCounts[constants_1.X12_ENCODATION] += 10.0 / 3.0;
            }
            // step P
            if (this.isNativeEDIFACT(c)) {
                charCounts[constants_1.EDIFACT_ENCODATION] += 3.0 / 4.0;
            }
            else if (this.isExtendedASCII(c)) {
                charCounts[constants_1.EDIFACT_ENCODATION] += 17.0 / 4.0;
            }
            else {
                charCounts[constants_1.EDIFACT_ENCODATION] += 13.0 / 4.0;
            }
            // step Q
            if (this.isSpecialB256(c)) {
                charCounts[constants_1.BASE256_ENCODATION] += 4.0;
            }
            else {
                charCounts[constants_1.BASE256_ENCODATION]++;
            }
            // step R
            if (charsProcessed >= 4) {
                Arrays_1.default.fill(mins, 0);
                Arrays_1.default.fill(intCharCounts, 0);
                this.findMinimums(charCounts, intCharCounts, Integer_1.default.MAX_VALUE, mins);
                if (intCharCounts[constants_1.ASCII_ENCODATION] <
                    this.min(intCharCounts[constants_1.BASE256_ENCODATION], intCharCounts[constants_1.C40_ENCODATION], intCharCounts[constants_1.TEXT_ENCODATION], intCharCounts[constants_1.X12_ENCODATION], intCharCounts[constants_1.EDIFACT_ENCODATION])) {
                    return constants_1.ASCII_ENCODATION;
                }
                if (intCharCounts[constants_1.BASE256_ENCODATION] < intCharCounts[constants_1.ASCII_ENCODATION] ||
                    intCharCounts[constants_1.BASE256_ENCODATION] + 1 <
                        this.min(intCharCounts[constants_1.C40_ENCODATION], intCharCounts[constants_1.TEXT_ENCODATION], intCharCounts[constants_1.X12_ENCODATION], intCharCounts[constants_1.EDIFACT_ENCODATION])) {
                    return constants_1.BASE256_ENCODATION;
                }
                if (intCharCounts[constants_1.EDIFACT_ENCODATION] + 1 <
                    this.min(intCharCounts[constants_1.BASE256_ENCODATION], intCharCounts[constants_1.C40_ENCODATION], intCharCounts[constants_1.TEXT_ENCODATION], intCharCounts[constants_1.X12_ENCODATION], intCharCounts[constants_1.ASCII_ENCODATION])) {
                    return constants_1.EDIFACT_ENCODATION;
                }
                if (intCharCounts[constants_1.TEXT_ENCODATION] + 1 <
                    this.min(intCharCounts[constants_1.BASE256_ENCODATION], intCharCounts[constants_1.C40_ENCODATION], intCharCounts[constants_1.EDIFACT_ENCODATION], intCharCounts[constants_1.X12_ENCODATION], intCharCounts[constants_1.ASCII_ENCODATION])) {
                    return constants_1.TEXT_ENCODATION;
                }
                if (intCharCounts[constants_1.X12_ENCODATION] + 1 <
                    this.min(intCharCounts[constants_1.BASE256_ENCODATION], intCharCounts[constants_1.C40_ENCODATION], intCharCounts[constants_1.EDIFACT_ENCODATION], intCharCounts[constants_1.TEXT_ENCODATION], intCharCounts[constants_1.ASCII_ENCODATION])) {
                    return constants_1.X12_ENCODATION;
                }
                if (intCharCounts[constants_1.C40_ENCODATION] + 1 <
                    this.min(intCharCounts[constants_1.ASCII_ENCODATION], intCharCounts[constants_1.BASE256_ENCODATION], intCharCounts[constants_1.EDIFACT_ENCODATION], intCharCounts[constants_1.TEXT_ENCODATION])) {
                    if (intCharCounts[constants_1.C40_ENCODATION] < intCharCounts[constants_1.X12_ENCODATION]) {
                        return constants_1.C40_ENCODATION;
                    }
                    if (intCharCounts[constants_1.C40_ENCODATION] === intCharCounts[constants_1.X12_ENCODATION]) {
                        var p = startpos + charsProcessed + 1;
                        while (p < msg.length) {
                            var tc = msg.charCodeAt(p);
                            if (this.isX12TermSep(tc)) {
                                return constants_1.X12_ENCODATION;
                            }
                            if (!this.isNativeX12(tc)) {
                                break;
                            }
                            p++;
                        }
                        return constants_1.C40_ENCODATION;
                    }
                }
            }
        }
    };
    HighLevelEncoder.min = function (f1, f2, f3, f4, f5) {
        var val = Math.min(f1, Math.min(f2, Math.min(f3, f4)));
        if (f5 === undefined) {
            return val;
        }
        else {
            return Math.min(val, f5);
        }
    };
    HighLevelEncoder.findMinimums = function (charCounts, intCharCounts, min, mins) {
        for (var i = 0; i < 6; i++) {
            var current = (intCharCounts[i] = Math.ceil(charCounts[i]));
            if (min > current) {
                min = current;
                Arrays_1.default.fill(mins, 0);
            }
            if (min === current) {
                mins[i] = mins[i] + 1;
            }
        }
        return min;
    };
    HighLevelEncoder.getMinimumCount = function (mins) {
        var minCount = 0;
        for (var i = 0; i < 6; i++) {
            minCount += mins[i];
        }
        return minCount || 0;
    };
    HighLevelEncoder.isDigit = function (ch) {
        return ch >= '0'.charCodeAt(0) && ch <= '9'.charCodeAt(0);
    };
    HighLevelEncoder.isExtendedASCII = function (ch) {
        return ch >= 128 && ch <= 255;
    };
    HighLevelEncoder.isNativeC40 = function (ch) {
        return (ch === ' '.charCodeAt(0) ||
            (ch >= '0'.charCodeAt(0) && ch <= '9'.charCodeAt(0)) ||
            (ch >= 'A'.charCodeAt(0) && ch <= 'Z'.charCodeAt(0)));
    };
    HighLevelEncoder.isNativeText = function (ch) {
        return (ch === ' '.charCodeAt(0) ||
            (ch >= '0'.charCodeAt(0) && ch <= '9'.charCodeAt(0)) ||
            (ch >= 'a'.charCodeAt(0) && ch <= 'z'.charCodeAt(0)));
    };
    HighLevelEncoder.isNativeX12 = function (ch) {
        return (this.isX12TermSep(ch) ||
            ch === ' '.charCodeAt(0) ||
            (ch >= '0'.charCodeAt(0) && ch <= '9'.charCodeAt(0)) ||
            (ch >= 'A'.charCodeAt(0) && ch <= 'Z'.charCodeAt(0)));
    };
    HighLevelEncoder.isX12TermSep = function (ch) {
        return (ch === 13 || // CR
            ch === '*'.charCodeAt(0) ||
            ch === '>'.charCodeAt(0));
    };
    HighLevelEncoder.isNativeEDIFACT = function (ch) {
        return ch >= ' '.charCodeAt(0) && ch <= '^'.charCodeAt(0);
    };
    HighLevelEncoder.isSpecialB256 = function (ch) {
        return false; // TODO NOT IMPLEMENTED YET!!!
    };
    /**
     * Determines the number of consecutive characters that are encodable using numeric compaction.
     *
     * @param msg      the message
     * @param startpos the start position within the message
     * @return the requested character count
     */
    HighLevelEncoder.determineConsecutiveDigitCount = function (msg, startpos) {
        if (startpos === void 0) { startpos = 0; }
        var len = msg.length;
        var idx = startpos;
        while (idx < len && this.isDigit(msg.charCodeAt(idx))) {
            idx++;
        }
        return idx - startpos;
    };
    HighLevelEncoder.illegalCharacter = function (singleCharacter) {
        var hex = Integer_1.default.toHexString(singleCharacter.charCodeAt(0));
        hex = '0000'.substring(0, 4 - hex.length) + hex;
        throw new Error('Illegal character: ' + singleCharacter + ' (0x' + hex + ')');
    };
    return HighLevelEncoder;
}());
exports.default = HighLevelEncoder;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\HighLevelEncoder.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\MinimalEncoder.js", {"../../common/MinimalECIInput":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\MinimalECIInput.js","../../util/Integer":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\Integer.js","./HighLevelEncoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\HighLevelEncoder.js","./constants":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\constants.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cdatamatrix%5Cencoder%5CMinimalEncoder.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MinimalEncoder = void 0;
var constants_1 = require("./constants");
var HighLevelEncoder_1 = require("./HighLevelEncoder");
var MinimalECIInput_1 = require("../../common/MinimalECIInput");
var Integer_1 = require("../../util/Integer");
var Mode;
(function (Mode) {
    Mode[Mode["ASCII"] = 0] = "ASCII";
    Mode[Mode["C40"] = 1] = "C40";
    Mode[Mode["TEXT"] = 2] = "TEXT";
    Mode[Mode["X12"] = 3] = "X12";
    Mode[Mode["EDF"] = 4] = "EDF";
    Mode[Mode["B256"] = 5] = "B256";
})(Mode || (Mode = {}));
var C40_SHIFT2_CHARS = [
    '!',
    '"',
    '#',
    '$',
    '%',
    '&',
    "'",
    '(',
    ')',
    '*',
    '+',
    ',',
    '-',
    '.',
    '/',
    ':',
    ';',
    '<',
    '=',
    '>',
    '?',
    '@',
    '[',
    '\\',
    ']',
    '^',
    '_',
];
var MinimalEncoder = /** @class */ (function () {
    function MinimalEncoder() {
    }
    MinimalEncoder.isExtendedASCII = function (ch, fnc1) {
        return ch !== fnc1 && ch >= 128 && ch <= 255;
    };
    MinimalEncoder.isInC40Shift1Set = function (ch) {
        return ch <= 31;
    };
    MinimalEncoder.isInC40Shift2Set = function (ch, fnc1) {
        var e_1, _a;
        try {
            for (var C40_SHIFT2_CHARS_1 = __values(C40_SHIFT2_CHARS), C40_SHIFT2_CHARS_1_1 = C40_SHIFT2_CHARS_1.next(); !C40_SHIFT2_CHARS_1_1.done; C40_SHIFT2_CHARS_1_1 = C40_SHIFT2_CHARS_1.next()) {
                var c40Shift2Char = C40_SHIFT2_CHARS_1_1.value;
                if (c40Shift2Char.charCodeAt(0) === ch) {
                    return true;
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (C40_SHIFT2_CHARS_1_1 && !C40_SHIFT2_CHARS_1_1.done && (_a = C40_SHIFT2_CHARS_1.return)) _a.call(C40_SHIFT2_CHARS_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return ch === fnc1;
    };
    MinimalEncoder.isInTextShift1Set = function (ch) {
        return this.isInC40Shift1Set(ch);
    };
    MinimalEncoder.isInTextShift2Set = function (ch, fnc1) {
        return this.isInC40Shift2Set(ch, fnc1);
    };
    /**
     * Performs message encoding of a DataMatrix message
     *
     * @param msg the message
     * @param priorityCharset The preferred {@link Charset}. When the value of the argument is null, the algorithm
     *   chooses charsets that leads to a minimal representation. Otherwise the algorithm will use the priority
     *   charset to encode any character in the input that can be encoded by it if the charset is among the
     *   supported charsets.
     * @param fnc1 denotes the character in the input that represents the FNC1 character or -1 if this is not a GS1
     *   bar code. If the value is not -1 then a FNC1 is also prepended.
     * @param shape requested shape.
     * @return the encoded message (the char values range from 0 to 255)
     */
    MinimalEncoder.encodeHighLevel = function (msg, priorityCharset, fnc1, shape) {
        if (priorityCharset === void 0) { priorityCharset = null; }
        if (fnc1 === void 0) { fnc1 = -1; }
        if (shape === void 0) { shape = 0 /* FORCE_NONE */; }
        var macroId = 0;
        if (msg.startsWith(constants_1.MACRO_05_HEADER) && msg.endsWith(constants_1.MACRO_TRAILER)) {
            macroId = 5;
            msg = msg.substring(constants_1.MACRO_05_HEADER.length, msg.length - 2);
        }
        else if (msg.startsWith(constants_1.MACRO_06_HEADER) && msg.endsWith(constants_1.MACRO_TRAILER)) {
            macroId = 6;
            msg = msg.substring(constants_1.MACRO_06_HEADER.length, msg.length - 2);
        }
        return decodeURIComponent(escape(String.fromCharCode.apply(String, __spread(this.encode(msg, priorityCharset, fnc1, shape, macroId)))));
    };
    /**
     * Encodes input minimally and returns an array of the codewords
     *
     * @param input The string to encode
     * @param priorityCharset The preferred {@link Charset}. When the value of the argument is null, the algorithm
     *   chooses charsets that leads to a minimal representation. Otherwise the algorithm will use the priority
     *   charset to encode any character in the input that can be encoded by it if the charset is among the
     *   supported charsets.
     * @param fnc1 denotes the character in the input that represents the FNC1 character or -1 if this is not a GS1
     *   bar code. If the value is not -1 then a FNC1 is also prepended.
     * @param shape requested shape.
     * @param macroId Prepends the specified macro function in case that a value of 5 or 6 is specified.
     * @return An array of bytes representing the codewords of a minimal encoding.
     */
    MinimalEncoder.encode = function (input, priorityCharset, fnc1, shape, macroId) {
        return this.encodeMinimally(new Input(input, priorityCharset, fnc1, shape, macroId)).getBytes();
    };
    MinimalEncoder.addEdge = function (edges, edge) {
        var vertexIndex = edge.fromPosition + edge.characterLength;
        if (edges[vertexIndex][edge.getEndMode()] === null ||
            edges[vertexIndex][edge.getEndMode()].cachedTotalSize >
                edge.cachedTotalSize) {
            edges[vertexIndex][edge.getEndMode()] = edge;
        }
    };
    /** @return the number of words in which the string starting at from can be encoded in c40 or text mode.
     *  The number of characters encoded is returned in characterLength.
     *  The number of characters encoded is also minimal in the sense that the algorithm stops as soon
     *  as a character encoding fills a C40 word competely (three C40 values). An exception is at the
     *  end of the string where two C40 values are allowed (according to the spec the third c40 value
     *  is filled  with 0 (Shift 1) in this case).
     */
    MinimalEncoder.getNumberOfC40Words = function (input, from, c40, characterLength) {
        var thirdsCount = 0;
        for (var i = from; i < input.length(); i++) {
            if (input.isECI(i)) {
                characterLength[0] = 0;
                return 0;
            }
            var ci = input.charAt(i);
            if ((c40 && HighLevelEncoder_1.default.isNativeC40(ci)) ||
                (!c40 && HighLevelEncoder_1.default.isNativeText(ci))) {
                thirdsCount++; // native
            }
            else if (!MinimalEncoder.isExtendedASCII(ci, input.getFNC1Character())) {
                thirdsCount += 2; // shift
            }
            else {
                var asciiValue = ci & 0xff;
                if (asciiValue >= 128 &&
                    ((c40 && HighLevelEncoder_1.default.isNativeC40(asciiValue - 128)) ||
                        (!c40 && HighLevelEncoder_1.default.isNativeText(asciiValue - 128)))) {
                    thirdsCount += 3; // shift, Upper shift
                }
                else {
                    thirdsCount += 4; // shift, Upper shift, shift
                }
            }
            if (thirdsCount % 3 === 0 ||
                ((thirdsCount - 2) % 3 === 0 && i + 1 === input.length())) {
                characterLength[0] = i - from + 1;
                return Math.ceil(thirdsCount / 3.0);
            }
        }
        characterLength[0] = 0;
        return 0;
    };
    MinimalEncoder.addEdges = function (input, edges, from, previous) {
        var e_2, _a;
        if (input.isECI(from)) {
            this.addEdge(edges, new Edge(input, Mode.ASCII, from, 1, previous));
            return;
        }
        var ch = input.charAt(from);
        if (previous === null || previous.getEndMode() !== Mode.EDF) {
            // not possible to unlatch a full EDF edge to something
            // else
            if (HighLevelEncoder_1.default.isDigit(ch) &&
                input.haveNCharacters(from, 2) &&
                HighLevelEncoder_1.default.isDigit(input.charAt(from + 1))) {
                // two digits ASCII encoded
                this.addEdge(edges, new Edge(input, Mode.ASCII, from, 2, previous));
            }
            else {
                // one ASCII encoded character or an extended character via Upper Shift
                this.addEdge(edges, new Edge(input, Mode.ASCII, from, 1, previous));
            }
            var modes = [Mode.C40, Mode.TEXT];
            try {
                for (var modes_1 = __values(modes), modes_1_1 = modes_1.next(); !modes_1_1.done; modes_1_1 = modes_1.next()) {
                    var mode = modes_1_1.value;
                    var characterLength = [];
                    if (MinimalEncoder.getNumberOfC40Words(input, from, mode === Mode.C40, characterLength) > 0) {
                        this.addEdge(edges, new Edge(input, mode, from, characterLength[0], previous));
                    }
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (modes_1_1 && !modes_1_1.done && (_a = modes_1.return)) _a.call(modes_1);
                }
                finally { if (e_2) throw e_2.error; }
            }
            if (input.haveNCharacters(from, 3) &&
                HighLevelEncoder_1.default.isNativeX12(input.charAt(from)) &&
                HighLevelEncoder_1.default.isNativeX12(input.charAt(from + 1)) &&
                HighLevelEncoder_1.default.isNativeX12(input.charAt(from + 2))) {
                this.addEdge(edges, new Edge(input, Mode.X12, from, 3, previous));
            }
            this.addEdge(edges, new Edge(input, Mode.B256, from, 1, previous));
        }
        // We create 4 EDF edges,  with 1, 2 3 or 4 characters length. The fourth normally doesn't have a latch to ASCII
        // unless it is 2 characters away from the end of the input.
        var i;
        for (i = 0; i < 3; i++) {
            var pos = from + i;
            if (input.haveNCharacters(pos, 1) &&
                HighLevelEncoder_1.default.isNativeEDIFACT(input.charAt(pos))) {
                this.addEdge(edges, new Edge(input, Mode.EDF, from, i + 1, previous));
            }
            else {
                break;
            }
        }
        if (i === 3 &&
            input.haveNCharacters(from, 4) &&
            HighLevelEncoder_1.default.isNativeEDIFACT(input.charAt(from + 3))) {
            this.addEdge(edges, new Edge(input, Mode.EDF, from, 4, previous));
        }
    };
    MinimalEncoder.encodeMinimally = function (input) {
        /* The minimal encoding is computed by Dijkstra. The acyclic graph is modeled as follows:
         * A vertex represents a combination of a position in the input and an encoding mode where position 0
         * denotes the position left of the first character, 1 the position left of the second character and so on.
         * Likewise the end vertices are located after the last character at position input.length().
         * For any position there might be up to six vertices, one for each of the encoding types ASCII, C40, TEXT, X12,
         * EDF and B256.
         *
         * As an example consider the input string "ABC123" then at position 0 there is only one vertex with the default
         * ASCII encodation. At position 3 there might be vertices for the types ASCII, C40, X12, EDF and B256.
         *
         * An edge leading to such a vertex encodes one or more of the characters left of the position that the vertex
         * represents. It encodes the characters in the encoding mode of the vertex that it ends on. In other words,
         * all edges leading to a particular vertex encode the same characters (the length of the suffix can vary) using the same
         * encoding mode.
         * As an example consider the input string "ABC123" and the vertex (4,EDF). Possible edges leading to this vertex
         * are:
         *   (0,ASCII)  --EDF(ABC1)-- > (4,EDF)
         *   (1,ASCII)  --EDF(BC1)-- >  (4,EDF)
         *   (1,B256)   --EDF(BC1)-- >  (4,EDF)
         *   (1,EDF)    --EDF(BC1)-- >  (4,EDF)
         *   (2,ASCII)  --EDF(C1)-- >   (4,EDF)
         *   (2,B256)   --EDF(C1)-- >   (4,EDF)
         *   (2,EDF)    --EDF(C1)-- >   (4,EDF)
         *   (3,ASCII)  --EDF(1)-- >    (4,EDF)
         *   (3,B256)   --EDF(1)-- >    (4,EDF)
         *   (3,EDF)    --EDF(1)-- >    (4,EDF)
         *   (3,C40)    --EDF(1)-- >    (4,EDF)
         *   (3,X12)    --EDF(1)-- >    (4,EDF)
         *
         * The edges leading to a vertex are stored in such a way that there is a fast way to enumerate the edges ending
         * on a particular vertex.
         *
         * The algorithm processes the vertices in order of their position thereby performing the following:
         *
         * For every vertex at position i the algorithm enumerates the edges ending on the vertex and removes all but the
         * shortest from that list.
         * Then it processes the vertices for the position i+1. If i+1 == input.length() then the algorithm ends
         * and chooses the the edge with the smallest size from any of the edges leading to vertices at this position.
         * Otherwise the algorithm computes all possible outgoing edges for the vertices at the position i+1
         *
         * Examples:
         * The process is illustrated by showing the graph (edges) after each iteration from left to right over the input:
         * An edge is drawn as follows "(" + fromVertex + ") -- " + encodingMode + "(" + encodedInput + ") (" +
         * accumulatedSize + ") -- > (" + toVertex + ")"
         *
         * Example 1 encoding the string "ABCDEFG":
         *
         *
         * Situation after adding edges to the start vertex (0,ASCII)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII)
         * (0,ASCII) B256(A) (3) -- > (1,B256)
         * (0,ASCII) EDF(AB) (4) -- > (2,EDF)
         * (0,ASCII) C40(ABC) (3) -- > (3,C40)
         * (0,ASCII) TEXT(ABC) (5) -- > (3,TEXT)
         * (0,ASCII) X12(ABC) (3) -- > (3,X12)
         * (0,ASCII) EDF(ABC) (4) -- > (3,EDF)
         * (0,ASCII) EDF(ABCD) (4) -- > (4,EDF)
         *
         * Situation after adding edges to vertices at position 1
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII)
         * (0,ASCII) B256(A) (3) -- > (1,B256)
         * (0,ASCII) EDF(AB) (4) -- > (2,EDF)
         * (0,ASCII) C40(ABC) (3) -- > (3,C40)
         * (0,ASCII) TEXT(ABC) (5) -- > (3,TEXT)
         * (0,ASCII) X12(ABC) (3) -- > (3,X12)
         * (0,ASCII) EDF(ABC) (4) -- > (3,EDF)
         * (0,ASCII) EDF(ABCD) (4) -- > (4,EDF)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) ASCII(B) (2) -- > (2,ASCII)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) B256(B) (4) -- > (2,B256)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) EDF(BC) (5) -- > (3,EDF)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) C40(BCD) (4) -- > (4,C40)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) TEXT(BCD) (6) -- > (4,TEXT)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) X12(BCD) (4) -- > (4,X12)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) EDF(BCD) (5) -- > (4,EDF)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) EDF(BCDE) (5) -- > (5,EDF)
         * (0,ASCII) B256(A) (3) -- > (1,B256) ASCII(B) (4) -- > (2,ASCII)
         * (0,ASCII) B256(A) (3) -- > (1,B256) B256(B) (3) -- > (2,B256)
         * (0,ASCII) B256(A) (3) -- > (1,B256) EDF(BC) (6) -- > (3,EDF)
         * (0,ASCII) B256(A) (3) -- > (1,B256) C40(BCD) (5) -- > (4,C40)
         * (0,ASCII) B256(A) (3) -- > (1,B256) TEXT(BCD) (7) -- > (4,TEXT)
         * (0,ASCII) B256(A) (3) -- > (1,B256) X12(BCD) (5) -- > (4,X12)
         * (0,ASCII) B256(A) (3) -- > (1,B256) EDF(BCD) (6) -- > (4,EDF)
         * (0,ASCII) B256(A) (3) -- > (1,B256) EDF(BCDE) (6) -- > (5,EDF)
         *
         * Edge "(1,ASCII) ASCII(B) (2) -- > (2,ASCII)" is minimal for the vertex (2,ASCII) so that edge "(1,B256) ASCII(B) (4) -- > (2,ASCII)" is removed.
         * Edge "(1,B256) B256(B) (3) -- > (2,B256)" is minimal for the vertext (2,B256) so that the edge "(1,ASCII) B256(B) (4) -- > (2,B256)" is removed.
         *
         * Situation after adding edges to vertices at position 2
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII)
         * (0,ASCII) B256(A) (3) -- > (1,B256)
         * (0,ASCII) EDF(AB) (4) -- > (2,EDF)
         * (0,ASCII) C40(ABC) (3) -- > (3,C40)
         * (0,ASCII) TEXT(ABC) (5) -- > (3,TEXT)
         * (0,ASCII) X12(ABC) (3) -- > (3,X12)
         * (0,ASCII) EDF(ABC) (4) -- > (3,EDF)
         * (0,ASCII) EDF(ABCD) (4) -- > (4,EDF)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) ASCII(B) (2) -- > (2,ASCII)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) EDF(BC) (5) -- > (3,EDF)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) C40(BCD) (4) -- > (4,C40)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) TEXT(BCD) (6) -- > (4,TEXT)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) X12(BCD) (4) -- > (4,X12)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) EDF(BCD) (5) -- > (4,EDF)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) EDF(BCDE) (5) -- > (5,EDF)
         * (0,ASCII) B256(A) (3) -- > (1,B256) B256(B) (3) -- > (2,B256)
         * (0,ASCII) B256(A) (3) -- > (1,B256) EDF(BC) (6) -- > (3,EDF)
         * (0,ASCII) B256(A) (3) -- > (1,B256) C40(BCD) (5) -- > (4,C40)
         * (0,ASCII) B256(A) (3) -- > (1,B256) TEXT(BCD) (7) -- > (4,TEXT)
         * (0,ASCII) B256(A) (3) -- > (1,B256) X12(BCD) (5) -- > (4,X12)
         * (0,ASCII) B256(A) (3) -- > (1,B256) EDF(BCD) (6) -- > (4,EDF)
         * (0,ASCII) B256(A) (3) -- > (1,B256) EDF(BCDE) (6) -- > (5,EDF)
         * (0,ASCII) EDF(AB) (4) -- > (2,EDF) ASCII(C) (5) -- > (3,ASCII)
         * (0,ASCII) EDF(AB) (4) -- > (2,EDF) B256(C) (6) -- > (3,B256)
         * (0,ASCII) EDF(AB) (4) -- > (2,EDF) EDF(CD) (7) -- > (4,EDF)
         * (0,ASCII) EDF(AB) (4) -- > (2,EDF) C40(CDE) (6) -- > (5,C40)
         * (0,ASCII) EDF(AB) (4) -- > (2,EDF) TEXT(CDE) (8) -- > (5,TEXT)
         * (0,ASCII) EDF(AB) (4) -- > (2,EDF) X12(CDE) (6) -- > (5,X12)
         * (0,ASCII) EDF(AB) (4) -- > (2,EDF) EDF(CDE) (7) -- > (5,EDF)
         * (0,ASCII) EDF(AB) (4) -- > (2,EDF) EDF(CDEF) (7) -- > (6,EDF)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) ASCII(B) (2) -- > (2,ASCII) ASCII(C) (3) -- > (3,ASCII)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) ASCII(B) (2) -- > (2,ASCII) B256(C) (5) -- > (3,B256)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) ASCII(B) (2) -- > (2,ASCII) EDF(CD) (6) -- > (4,EDF)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) ASCII(B) (2) -- > (2,ASCII) C40(CDE) (5) -- > (5,C40)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) ASCII(B) (2) -- > (2,ASCII) TEXT(CDE) (7) -- > (5,TEXT)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) ASCII(B) (2) -- > (2,ASCII) X12(CDE) (5) -- > (5,X12)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) ASCII(B) (2) -- > (2,ASCII) EDF(CDE) (6) -- > (5,EDF)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) ASCII(B) (2) -- > (2,ASCII) EDF(CDEF) (6) -- > (6,EDF)
         * (0,ASCII) B256(A) (3) -- > (1,B256) B256(B) (3) -- > (2,B256) ASCII(C) (4) -- > (3,ASCII)
         * (0,ASCII) B256(A) (3) -- > (1,B256) B256(B) (3) -- > (2,B256) B256(C) (4) -- > (3,B256)
         * (0,ASCII) B256(A) (3) -- > (1,B256) B256(B) (3) -- > (2,B256) EDF(CD) (6) -- > (4,EDF)
         * (0,ASCII) B256(A) (3) -- > (1,B256) B256(B) (3) -- > (2,B256) C40(CDE) (5) -- > (5,C40)
         * (0,ASCII) B256(A) (3) -- > (1,B256) B256(B) (3) -- > (2,B256) TEXT(CDE) (7) -- > (5,TEXT)
         * (0,ASCII) B256(A) (3) -- > (1,B256) B256(B) (3) -- > (2,B256) X12(CDE) (5) -- > (5,X12)
         * (0,ASCII) B256(A) (3) -- > (1,B256) B256(B) (3) -- > (2,B256) EDF(CDE) (6) -- > (5,EDF)
         * (0,ASCII) B256(A) (3) -- > (1,B256) B256(B) (3) -- > (2,B256) EDF(CDEF) (6) -- > (6,EDF)
         *
         * Edge "(2,ASCII) ASCII(C) (3) -- > (3,ASCII)" is minimal for the vertex (3,ASCII) so that edges "(2,EDF) ASCII(C) (5) -- > (3,ASCII)"
         * and "(2,B256) ASCII(C) (4) -- > (3,ASCII)" can be removed.
         * Edge "(0,ASCII) EDF(ABC) (4) -- > (3,EDF)" is minimal for the vertex (3,EDF) so that edges "(1,ASCII) EDF(BC) (5) -- > (3,EDF)"
         * and "(1,B256) EDF(BC) (6) -- > (3,EDF)" can be removed.
         * Edge "(2,B256) B256(C) (4) -- > (3,B256)" is minimal for the vertex (3,B256) so that edges "(2,ASCII) B256(C) (5) -- > (3,B256)"
         * and "(2,EDF) B256(C) (6) -- > (3,B256)" can be removed.
         *
         * This continues for vertices 3 thru 7
         *
         * Situation after adding edges to vertices at position 7
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII)
         * (0,ASCII) B256(A) (3) -- > (1,B256)
         * (0,ASCII) EDF(AB) (4) -- > (2,EDF)
         * (0,ASCII) C40(ABC) (3) -- > (3,C40)
         * (0,ASCII) TEXT(ABC) (5) -- > (3,TEXT)
         * (0,ASCII) X12(ABC) (3) -- > (3,X12)
         * (0,ASCII) EDF(ABC) (4) -- > (3,EDF)
         * (0,ASCII) EDF(ABCD) (4) -- > (4,EDF)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) ASCII(B) (2) -- > (2,ASCII)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) C40(BCD) (4) -- > (4,C40)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) TEXT(BCD) (6) -- > (4,TEXT)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) X12(BCD) (4) -- > (4,X12)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) EDF(BCDE) (5) -- > (5,EDF)
         * (0,ASCII) B256(A) (3) -- > (1,B256) B256(B) (3) -- > (2,B256)
         * (0,ASCII) C40(ABC) (3) -- > (3,C40) C40(DEF) (5) -- > (6,C40)
         * (0,ASCII) X12(ABC) (3) -- > (3,X12) X12(DEF) (5) -- > (6,X12)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) ASCII(B) (2) -- > (2,ASCII) ASCII(C) (3) -- > (3,ASCII)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) ASCII(B) (2) -- > (2,ASCII) C40(CDE) (5) -- > (5,C40)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) ASCII(B) (2) -- > (2,ASCII) TEXT(CDE) (7) -- > (5,TEXT)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) ASCII(B) (2) -- > (2,ASCII) X12(CDE) (5) -- > (5,X12)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) ASCII(B) (2) -- > (2,ASCII) EDF(CDEF) (6) -- > (6,EDF)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) C40(BCD) (4) -- > (4,C40) C40(EFG) (6) -- > (7,C40)    //Solution 1
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) X12(BCD) (4) -- > (4,X12) X12(EFG) (6) -- > (7,X12)    //Solution 2
         * (0,ASCII) B256(A) (3) -- > (1,B256) B256(B) (3) -- > (2,B256) B256(C) (4) -- > (3,B256)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) ASCII(B) (2) -- > (2,ASCII) ASCII(C) (3) -- > (3,ASCII) ASCII(D) (4) -- > (4,ASCII)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) ASCII(B) (2) -- > (2,ASCII) ASCII(C) (3) -- > (3,ASCII) TEXT(DEF) (8) -- > (6,TEXT)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) ASCII(B) (2) -- > (2,ASCII) ASCII(C) (3) -- > (3,ASCII) EDF(DEFG) (7) -- > (7,EDF)
         * (0,ASCII) B256(A) (3) -- > (1,B256) B256(B) (3) -- > (2,B256) B256(C) (4) -- > (3,B256) B256(D) (5) -- > (4,B256)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) ASCII(B) (2) -- > (2,ASCII) ASCII(C) (3) -- > (3,ASCII) ASCII(D) (4) -- > (4,ASCII) ASCII(E) (5) -- > (5,ASCII)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) ASCII(B) (2) -- > (2,ASCII) ASCII(C) (3) -- > (3,ASCII) ASCII(D) (4) -- > (4,ASCII) TEXT(EFG) (9) -- > (7,TEXT)
         * (0,ASCII) B256(A) (3) -- > (1,B256) B256(B) (3) -- > (2,B256) B256(C) (4) -- > (3,B256) B256(D) (5) -- > (4,B256) B256(E) (6) -- > (5,B256)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) ASCII(B) (2) -- > (2,ASCII) ASCII(C) (3) -- > (3,ASCII) ASCII(D) (4) -- > (4,ASCII) ASCII(E) (5) -- > (5,ASCII) ASCII(F) (6) -- > (6,ASCII)
         * (0,ASCII) B256(A) (3) -- > (1,B256) B256(B) (3) -- > (2,B256) B256(C) (4) -- > (3,B256) B256(D) (5) -- > (4,B256) B256(E) (6) -- > (5,B256) B256(F) (7) -- > (6,B256)
         * (0,ASCII) ASCII(A) (1) -- > (1,ASCII) ASCII(B) (2) -- > (2,ASCII) ASCII(C) (3) -- > (3,ASCII) ASCII(D) (4) -- > (4,ASCII) ASCII(E) (5) -- > (5,ASCII) ASCII(F) (6) -- > (6,ASCII) ASCII(G) (7) -- > (7,ASCII)
         * (0,ASCII) B256(A) (3) -- > (1,B256) B256(B) (3) -- > (2,B256) B256(C) (4) -- > (3,B256) B256(D) (5) -- > (4,B256) B256(E) (6) -- > (5,B256) B256(F) (7) -- > (6,B256) B256(G) (8) -- > (7,B256)
         *
         * Hence a minimal encoding of "ABCDEFG" is either ASCII(A),C40(BCDEFG) or ASCII(A), X12(BCDEFG) with a size of 5 bytes.
         */
        var inputLength = input.length();
        // Array that represents vertices. There is a vertex for every character and mode.
        // The last dimension in the array below encodes the 6 modes ASCII, C40, TEXT, X12, EDF and B256
        var edges = Array(inputLength + 1)
            .fill(null)
            .map(function () { return Array(6).fill(0); });
        this.addEdges(input, edges, 0, null);
        for (var i = 1; i <= inputLength; i++) {
            for (var j = 0; j < 6; j++) {
                if (edges[i][j] !== null && i < inputLength) {
                    this.addEdges(input, edges, i, edges[i][j]);
                }
            }
            // optimize memory by removing edges that have been passed.
            for (var j = 0; j < 6; j++) {
                edges[i - 1][j] = null;
            }
        }
        var minimalJ = -1;
        var minimalSize = Integer_1.default.MAX_VALUE;
        for (var j = 0; j < 6; j++) {
            if (edges[inputLength][j] !== null) {
                var edge = edges[inputLength][j];
                var size = j >= 1 && j <= 3 ? edge.cachedTotalSize + 1 : edge.cachedTotalSize; // C40, TEXT and X12 need an
                // extra unlatch at the end
                if (size < minimalSize) {
                    minimalSize = size;
                    minimalJ = j;
                }
            }
        }
        if (minimalJ < 0) {
            throw new Error('Failed to encode "' + input + '"');
        }
        return new Result(edges[inputLength][minimalJ]);
    };
    return MinimalEncoder;
}());
exports.MinimalEncoder = MinimalEncoder;
var Result = /** @class */ (function () {
    function Result(solution) {
        var input = solution.input;
        var size = 0;
        var bytesAL = [];
        var randomizePostfixLength = [];
        var randomizeLengths = [];
        if ((solution.mode === Mode.C40 ||
            solution.mode === Mode.TEXT ||
            solution.mode === Mode.X12) &&
            solution.getEndMode() !== Mode.ASCII) {
            size += this.prepend(Edge.getBytes(254), bytesAL);
        }
        var current = solution;
        while (current !== null) {
            size += this.prepend(current.getDataBytes(), bytesAL);
            if (current.previous === null ||
                current.getPreviousStartMode() !== current.getMode()) {
                if (current.getMode() === Mode.B256) {
                    if (size <= 249) {
                        bytesAL.unshift(size);
                        size++;
                    }
                    else {
                        bytesAL.unshift(size % 250);
                        bytesAL.unshift(size / 250 + 249);
                        size += 2;
                    }
                    randomizePostfixLength.push(bytesAL.length);
                    randomizeLengths.push(size);
                }
                this.prepend(current.getLatchBytes(), bytesAL);
                size = 0;
            }
            current = current.previous;
        }
        if (input.getMacroId() === 5) {
            size += this.prepend(Edge.getBytes(236), bytesAL);
        }
        else if (input.getMacroId() === 6) {
            size += this.prepend(Edge.getBytes(237), bytesAL);
        }
        if (input.getFNC1Character() > 0) {
            size += this.prepend(Edge.getBytes(232), bytesAL);
        }
        for (var i = 0; i < randomizePostfixLength.length; i++) {
            this.applyRandomPattern(bytesAL, bytesAL.length - randomizePostfixLength[i], randomizeLengths[i]);
        }
        // add padding
        var capacity = solution.getMinSymbolSize(bytesAL.length);
        if (bytesAL.length < capacity) {
            bytesAL.push(129);
        }
        while (bytesAL.length < capacity) {
            bytesAL.push(this.randomize253State(bytesAL.length + 1));
        }
        this.bytes = new Uint8Array(bytesAL.length);
        for (var i = 0; i < this.bytes.length; i++) {
            this.bytes[i] = bytesAL[i];
        }
    }
    Result.prototype.prepend = function (bytes, into) {
        for (var i = bytes.length - 1; i >= 0; i--) {
            into.unshift(bytes[i]);
        }
        return bytes.length;
    };
    Result.prototype.randomize253State = function (codewordPosition) {
        var pseudoRandom = ((149 * codewordPosition) % 253) + 1;
        var tempVariable = 129 + pseudoRandom;
        return tempVariable <= 254 ? tempVariable : tempVariable - 254;
    };
    Result.prototype.applyRandomPattern = function (bytesAL, startPosition, length) {
        for (var i = 0; i < length; i++) {
            // See "B.1 253-state algorithm
            var Pad_codeword_position = startPosition + i;
            var Pad_codeword_value = bytesAL[Pad_codeword_position] & 0xff;
            var pseudo_random_number = ((149 * (Pad_codeword_position + 1)) % 255) + 1;
            var temp_variable = Pad_codeword_value + pseudo_random_number;
            bytesAL[Pad_codeword_position] =
                temp_variable <= 255 ? temp_variable : temp_variable - 256;
        }
    };
    Result.prototype.getBytes = function () {
        return this.bytes;
    };
    return Result;
}());
var Edge = /** @class */ (function () {
    function Edge(input, mode, fromPosition, characterLength, previous) {
        this.input = input;
        this.mode = mode;
        this.fromPosition = fromPosition;
        this.characterLength = characterLength;
        this.previous = previous;
        this.allCodewordCapacities = [
            3, 5, 8, 10, 12, 16, 18, 22, 30, 32, 36, 44, 49, 62, 86, 114, 144, 174, 204,
            280, 368, 456, 576, 696, 816, 1050, 1304, 1558,
        ];
        this.squareCodewordCapacities = [
            3, 5, 8, 12, 18, 22, 30, 36, 44, 62, 86, 114, 144, 174, 204, 280, 368, 456,
            576, 696, 816, 1050, 1304, 1558,
        ];
        this.rectangularCodewordCapacities = [5, 10, 16, 33, 32, 49];
        if (!(fromPosition + characterLength <= input.length())) {
            throw new Error('Invalid edge');
        }
        var size = previous !== null ? previous.cachedTotalSize : 0;
        var previousMode = this.getPreviousMode();
        /*
         * Switching modes
         * ASCII -> C40: latch 230
         * ASCII -> TEXT: latch 239
         * ASCII -> X12: latch 238
         * ASCII -> EDF: latch 240
         * ASCII -> B256: latch 231
         * C40 -> ASCII: word(c1,c2,c3), 254
         * TEXT -> ASCII: word(c1,c2,c3), 254
         * X12 -> ASCII: word(c1,c2,c3), 254
         * EDIFACT -> ASCII: Unlatch character,0,0,0 or c1,Unlatch character,0,0 or c1,c2,Unlatch character,0 or
         * c1,c2,c3,Unlatch character
         * B256 -> ASCII: without latch after n bytes
         */
        switch (mode) {
            case Mode.ASCII:
                size++;
                if (input.isECI(fromPosition) ||
                    MinimalEncoder.isExtendedASCII(input.charAt(fromPosition), input.getFNC1Character())) {
                    size++;
                }
                if (previousMode === Mode.C40 ||
                    previousMode === Mode.TEXT ||
                    previousMode === Mode.X12) {
                    size++; // unlatch 254 to ASCII
                }
                break;
            case Mode.B256:
                size++;
                if (previousMode !== Mode.B256) {
                    size++; // byte count
                }
                else if (this.getB256Size() === 250) {
                    size++; // extra byte count
                }
                if (previousMode === Mode.ASCII) {
                    size++; // latch to B256
                }
                else if (previousMode === Mode.C40 ||
                    previousMode === Mode.TEXT ||
                    previousMode === Mode.X12) {
                    size += 2; // unlatch to ASCII, latch to B256
                }
                break;
            case Mode.C40:
            case Mode.TEXT:
            case Mode.X12:
                if (mode === Mode.X12) {
                    size += 2;
                }
                else {
                    var charLen = [];
                    size +=
                        MinimalEncoder.getNumberOfC40Words(input, fromPosition, mode === Mode.C40, charLen) * 2;
                }
                if (previousMode === Mode.ASCII || previousMode === Mode.B256) {
                    size++; // additional byte for latch from ASCII to this mode
                }
                else if (previousMode !== mode &&
                    (previousMode === Mode.C40 ||
                        previousMode === Mode.TEXT ||
                        previousMode === Mode.X12)) {
                    size += 2; // unlatch 254 to ASCII followed by latch to this mode
                }
                break;
            case Mode.EDF:
                size += 3;
                if (previousMode === Mode.ASCII || previousMode === Mode.B256) {
                    size++; // additional byte for latch from ASCII to this mode
                }
                else if (previousMode === Mode.C40 ||
                    previousMode === Mode.TEXT ||
                    previousMode === Mode.X12) {
                    size += 2; // unlatch 254 to ASCII followed by latch to this mode
                }
                break;
        }
        this.cachedTotalSize = size;
    }
    // does not count beyond 250
    Edge.prototype.getB256Size = function () {
        var cnt = 0;
        var current = this;
        while (current !== null && current.mode === Mode.B256 && cnt <= 250) {
            cnt++;
            current = current.previous;
        }
        return cnt;
    };
    Edge.prototype.getPreviousStartMode = function () {
        return this.previous === null ? Mode.ASCII : this.previous.mode;
    };
    Edge.prototype.getPreviousMode = function () {
        return this.previous === null ? Mode.ASCII : this.previous.getEndMode();
    };
    /** Returns Mode.ASCII in case that:
     *  - Mode is EDIFACT and characterLength is less than 4 or the remaining characters can be encoded in at most 2
     *    ASCII bytes.
     *  - Mode is C40, TEXT or X12 and the remaining characters can be encoded in at most 1 ASCII byte.
     *  Returns mode in all other cases.
     * */
    Edge.prototype.getEndMode = function () {
        if (this.mode === Mode.EDF) {
            if (this.characterLength < 4) {
                return Mode.ASCII;
            }
            var lastASCII = this.getLastASCII(); // see 5.2.8.2 EDIFACT encodation Rules
            if (lastASCII > 0 &&
                this.getCodewordsRemaining(this.cachedTotalSize + lastASCII) <=
                    2 - lastASCII) {
                return Mode.ASCII;
            }
        }
        if (this.mode === Mode.C40 ||
            this.mode === Mode.TEXT ||
            this.mode === Mode.X12) {
            // see 5.2.5.2 C40 encodation rules and 5.2.7.2 ANSI X12 encodation rules
            if (this.fromPosition + this.characterLength >= this.input.length() &&
                this.getCodewordsRemaining(this.cachedTotalSize) === 0) {
                return Mode.ASCII;
            }
            var lastASCII = this.getLastASCII();
            if (lastASCII === 1 &&
                this.getCodewordsRemaining(this.cachedTotalSize + 1) === 0) {
                return Mode.ASCII;
            }
        }
        return this.mode;
    };
    Edge.prototype.getMode = function () {
        return this.mode;
    };
    /** Peeks ahead and returns 1 if the postfix consists of exactly two digits, 2 if the postfix consists of exactly
     *  two consecutive digits and a non extended character or of 4 digits.
     *  Returns 0 in any other case
     **/
    Edge.prototype.getLastASCII = function () {
        var length = this.input.length();
        var from = this.fromPosition + this.characterLength;
        if (length - from > 4 || from >= length) {
            return 0;
        }
        if (length - from === 1) {
            if (MinimalEncoder.isExtendedASCII(this.input.charAt(from), this.input.getFNC1Character())) {
                return 0;
            }
            return 1;
        }
        if (length - from === 2) {
            if (MinimalEncoder.isExtendedASCII(this.input.charAt(from), this.input.getFNC1Character()) ||
                MinimalEncoder.isExtendedASCII(this.input.charAt(from + 1), this.input.getFNC1Character())) {
                return 0;
            }
            if (HighLevelEncoder_1.default.isDigit(this.input.charAt(from)) &&
                HighLevelEncoder_1.default.isDigit(this.input.charAt(from + 1))) {
                return 1;
            }
            return 2;
        }
        if (length - from === 3) {
            if (HighLevelEncoder_1.default.isDigit(this.input.charAt(from)) &&
                HighLevelEncoder_1.default.isDigit(this.input.charAt(from + 1)) &&
                !MinimalEncoder.isExtendedASCII(this.input.charAt(from + 2), this.input.getFNC1Character())) {
                return 2;
            }
            if (HighLevelEncoder_1.default.isDigit(this.input.charAt(from + 1)) &&
                HighLevelEncoder_1.default.isDigit(this.input.charAt(from + 2)) &&
                !MinimalEncoder.isExtendedASCII(this.input.charAt(from), this.input.getFNC1Character())) {
                return 2;
            }
            return 0;
        }
        if (HighLevelEncoder_1.default.isDigit(this.input.charAt(from)) &&
            HighLevelEncoder_1.default.isDigit(this.input.charAt(from + 1)) &&
            HighLevelEncoder_1.default.isDigit(this.input.charAt(from + 2)) &&
            HighLevelEncoder_1.default.isDigit(this.input.charAt(from + 3))) {
            return 2;
        }
        return 0;
    };
    /** Returns the capacity in codewords of the smallest symbol that has enough capacity to fit the given minimal
     * number of codewords.
     **/
    Edge.prototype.getMinSymbolSize = function (minimum) {
        var e_3, _a, e_4, _b, e_5, _c;
        switch (this.input.getShapeHint()) {
            case 1 /* FORCE_SQUARE */:
                try {
                    for (var _d = __values(this.squareCodewordCapacities), _e = _d.next(); !_e.done; _e = _d.next()) {
                        var capacity = _e.value;
                        if (capacity >= minimum) {
                            return capacity;
                        }
                    }
                }
                catch (e_3_1) { e_3 = { error: e_3_1 }; }
                finally {
                    try {
                        if (_e && !_e.done && (_a = _d.return)) _a.call(_d);
                    }
                    finally { if (e_3) throw e_3.error; }
                }
                break;
            case 2 /* FORCE_RECTANGLE */:
                try {
                    for (var _f = __values(this.rectangularCodewordCapacities), _g = _f.next(); !_g.done; _g = _f.next()) {
                        var capacity = _g.value;
                        if (capacity >= minimum) {
                            return capacity;
                        }
                    }
                }
                catch (e_4_1) { e_4 = { error: e_4_1 }; }
                finally {
                    try {
                        if (_g && !_g.done && (_b = _f.return)) _b.call(_f);
                    }
                    finally { if (e_4) throw e_4.error; }
                }
                break;
        }
        try {
            for (var _h = __values(this.allCodewordCapacities), _j = _h.next(); !_j.done; _j = _h.next()) {
                var capacity = _j.value;
                if (capacity >= minimum) {
                    return capacity;
                }
            }
        }
        catch (e_5_1) { e_5 = { error: e_5_1 }; }
        finally {
            try {
                if (_j && !_j.done && (_c = _h.return)) _c.call(_h);
            }
            finally { if (e_5) throw e_5.error; }
        }
        return this.allCodewordCapacities[this.allCodewordCapacities.length - 1];
    };
    /** Returns the remaining capacity in codewords of the smallest symbol that has enough capacity to fit the given
     * minimal number of codewords.
     **/
    Edge.prototype.getCodewordsRemaining = function (minimum) {
        return this.getMinSymbolSize(minimum) - minimum;
    };
    Edge.getBytes = function (c1, c2) {
        var result = new Uint8Array(c2 ? 2 : 1);
        result[0] = c1;
        if (c2) {
            result[1] = c2;
        }
        return result;
    };
    Edge.prototype.setC40Word = function (bytes, offset, c1, c2, c3) {
        var val16 = 1600 * (c1 & 0xff) + 40 * (c2 & 0xff) + (c3 & 0xff) + 1;
        bytes[offset] = val16 / 256;
        bytes[offset + 1] = val16 % 256;
    };
    Edge.prototype.getX12Value = function (c) {
        return c === 13
            ? 0
            : c === 42
                ? 1
                : c === 62
                    ? 2
                    : c === 32
                        ? 3
                        : c >= 48 && c <= 57
                            ? c - 44
                            : c >= 65 && c <= 90
                                ? c - 51
                                : c;
    };
    Edge.prototype.getX12Words = function () {
        if (!(this.characterLength % 3 === 0)) {
            throw new Error('X12 words must be a multiple of 3');
        }
        var result = new Uint8Array((this.characterLength / 3) * 2);
        for (var i = 0; i < result.length; i += 2) {
            this.setC40Word(result, i, this.getX12Value(this.input.charAt(this.fromPosition + (i / 2) * 3)), this.getX12Value(this.input.charAt(this.fromPosition + (i / 2) * 3 + 1)), this.getX12Value(this.input.charAt(this.fromPosition + (i / 2) * 3 + 2)));
        }
        return result;
    };
    Edge.prototype.getShiftValue = function (c, c40, fnc1) {
        return (c40 && MinimalEncoder.isInC40Shift1Set(c)) ||
            (!c40 && MinimalEncoder.isInTextShift1Set(c))
            ? 0
            : (c40 && MinimalEncoder.isInC40Shift2Set(c, fnc1)) ||
                (!c40 && MinimalEncoder.isInTextShift2Set(c, fnc1))
                ? 1
                : 2;
    };
    Edge.prototype.getC40Value = function (c40, setIndex, c, fnc1) {
        if (c === fnc1) {
            if (!(setIndex === 2)) {
                throw new Error('FNC1 cannot be used in C40 shift 2');
            }
            return 27;
        }
        if (c40) {
            return c <= 31
                ? c
                : c === 32
                    ? 3
                    : c <= 47
                        ? c - 33
                        : c <= 57
                            ? c - 44
                            : c <= 64
                                ? c - 43
                                : c <= 90
                                    ? c - 51
                                    : c <= 95
                                        ? c - 69
                                        : c <= 127
                                            ? c - 96
                                            : c;
        }
        else {
            return c === 0
                ? 0
                : setIndex === 0 && c <= 3
                    ? c - 1 // is this a bug in the spec?
                    : setIndex === 1 && c <= 31
                        ? c
                        : c === 32
                            ? 3
                            : c >= 33 && c <= 47
                                ? c - 33
                                : c >= 48 && c <= 57
                                    ? c - 44
                                    : c >= 58 && c <= 64
                                        ? c - 43
                                        : c >= 65 && c <= 90
                                            ? c - 64
                                            : c >= 91 && c <= 95
                                                ? c - 69
                                                : c === 96
                                                    ? 0
                                                    : c >= 97 && c <= 122
                                                        ? c - 83
                                                        : c >= 123 && c <= 127
                                                            ? c - 96
                                                            : c;
        }
    };
    Edge.prototype.getC40Words = function (c40, fnc1) {
        var c40Values = [];
        for (var i = 0; i < this.characterLength; i++) {
            var ci = this.input.charAt(this.fromPosition + i);
            if ((c40 && HighLevelEncoder_1.default.isNativeC40(ci)) ||
                (!c40 && HighLevelEncoder_1.default.isNativeText(ci))) {
                c40Values.push(this.getC40Value(c40, 0, ci, fnc1));
            }
            else if (!MinimalEncoder.isExtendedASCII(ci, fnc1)) {
                var shiftValue = this.getShiftValue(ci, c40, fnc1);
                c40Values.push(shiftValue); // Shift[123]
                c40Values.push(this.getC40Value(c40, shiftValue, ci, fnc1));
            }
            else {
                var asciiValue = (ci & 0xff) - 128;
                if ((c40 && HighLevelEncoder_1.default.isNativeC40(asciiValue)) ||
                    (!c40 && HighLevelEncoder_1.default.isNativeText(asciiValue))) {
                    c40Values.push(1); // Shift 2
                    c40Values.push(30); // Upper Shift
                    c40Values.push(this.getC40Value(c40, 0, asciiValue, fnc1));
                }
                else {
                    c40Values.push(1); // Shift 2
                    c40Values.push(30); // Upper Shift
                    var shiftValue = this.getShiftValue(asciiValue, c40, fnc1);
                    c40Values.push(shiftValue); // Shift[123]
                    c40Values.push(this.getC40Value(c40, shiftValue, asciiValue, fnc1));
                }
            }
        }
        if (c40Values.length % 3 !== 0) {
            if (!((c40Values.length - 2) % 3 === 0 &&
                this.fromPosition + this.characterLength === this.input.length())) {
                throw new Error('C40 words must be a multiple of 3');
            }
            c40Values.push(0); // pad with 0 (Shift 1)
        }
        var result = new Uint8Array((c40Values.length / 3) * 2);
        var byteIndex = 0;
        for (var i = 0; i < c40Values.length; i += 3) {
            this.setC40Word(result, byteIndex, c40Values[i] & 0xff, c40Values[i + 1] & 0xff, c40Values[i + 2] & 0xff);
            byteIndex += 2;
        }
        return result;
    };
    Edge.prototype.getEDFBytes = function () {
        var numberOfThirds = Math.ceil(this.characterLength / 4.0);
        var result = new Uint8Array(numberOfThirds * 3);
        var pos = this.fromPosition;
        var endPos = Math.min(this.fromPosition + this.characterLength - 1, this.input.length() - 1);
        for (var i = 0; i < numberOfThirds; i += 3) {
            var edfValues = [];
            for (var j = 0; j < 4; j++) {
                if (pos <= endPos) {
                    edfValues[j] = this.input.charAt(pos++) & 0x3f;
                }
                else {
                    edfValues[j] = pos === endPos + 1 ? 0x1f : 0;
                }
            }
            var val24 = edfValues[0] << 18;
            val24 |= edfValues[1] << 12;
            val24 |= edfValues[2] << 6;
            val24 |= edfValues[3];
            result[i] = (val24 >> 16) & 0xff;
            result[i + 1] = (val24 >> 8) & 0xff;
            result[i + 2] = val24 & 0xff;
        }
        return result;
    };
    Edge.prototype.getLatchBytes = function () {
        switch (this.getPreviousMode()) {
            case Mode.ASCII:
            case Mode.B256: // after B256 ends (via length) we are back to ASCII
                switch (this.mode) {
                    case Mode.B256:
                        return Edge.getBytes(231);
                    case Mode.C40:
                        return Edge.getBytes(230);
                    case Mode.TEXT:
                        return Edge.getBytes(239);
                    case Mode.X12:
                        return Edge.getBytes(238);
                    case Mode.EDF:
                        return Edge.getBytes(240);
                }
                break;
            case Mode.C40:
            case Mode.TEXT:
            case Mode.X12:
                if (this.mode !== this.getPreviousMode()) {
                    switch (this.mode) {
                        case Mode.ASCII:
                            return Edge.getBytes(254);
                        case Mode.B256:
                            return Edge.getBytes(254, 231);
                        case Mode.C40:
                            return Edge.getBytes(254, 230);
                        case Mode.TEXT:
                            return Edge.getBytes(254, 239);
                        case Mode.X12:
                            return Edge.getBytes(254, 238);
                        case Mode.EDF:
                            return Edge.getBytes(254, 240);
                    }
                }
                break;
            case Mode.EDF:
                // The rightmost EDIFACT edge always contains an unlatch character
                if (this.mode !== Mode.EDF) {
                    throw new Error('Cannot switch from EDF to ' + this.mode);
                }
                break;
        }
        return new Uint8Array(0);
    };
    // Important: The function does not return the length bytes (one or two) in case of B256 encoding
    Edge.prototype.getDataBytes = function () {
        switch (this.mode) {
            case Mode.ASCII:
                if (this.input.isECI(this.fromPosition)) {
                    return Edge.getBytes(241, this.input.getECIValue(this.fromPosition) + 1);
                }
                else if (MinimalEncoder.isExtendedASCII(this.input.charAt(this.fromPosition), this.input.getFNC1Character())) {
                    return Edge.getBytes(235, this.input.charAt(this.fromPosition) - 127);
                }
                else if (this.characterLength === 2) {
                    return Edge.getBytes(this.input.charAt(this.fromPosition) * 10 +
                        this.input.charAt(this.fromPosition + 1) +
                        130);
                }
                else if (this.input.isFNC1(this.fromPosition)) {
                    return Edge.getBytes(232);
                }
                else {
                    return Edge.getBytes(this.input.charAt(this.fromPosition) + 1);
                }
            case Mode.B256:
                return Edge.getBytes(this.input.charAt(this.fromPosition));
            case Mode.C40:
                return this.getC40Words(true, this.input.getFNC1Character());
            case Mode.TEXT:
                return this.getC40Words(false, this.input.getFNC1Character());
            case Mode.X12:
                return this.getX12Words();
            case Mode.EDF:
                return this.getEDFBytes();
        }
    };
    return Edge;
}());
var Input = /** @class */ (function (_super) {
    __extends(Input, _super);
    function Input(stringToEncode, priorityCharset, fnc1, shape, macroId) {
        var _this = _super.call(this, stringToEncode, priorityCharset, fnc1) || this;
        _this.shape = shape;
        _this.macroId = macroId;
        return _this;
    }
    Input.prototype.getMacroId = function () {
        return this.macroId;
    };
    Input.prototype.getShapeHint = function () {
        return this.shape;
    };
    return Input;
}(MinimalECIInput_1.MinimalECIInput));

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\MinimalEncoder.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\SymbolInfo.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cdatamatrix%5Cencoder%5CSymbolInfo.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PROD_SYMBOLS = void 0;
/**
 * Symbol info table for DataMatrix.
 */
var SymbolInfo = /** @class */ (function () {
    function SymbolInfo(rectangular, dataCapacity, errorCodewords, matrixWidth, matrixHeight, dataRegions, rsBlockData, rsBlockError) {
        if (rsBlockData === void 0) { rsBlockData = 0; }
        if (rsBlockError === void 0) { rsBlockError = 0; }
        this.rectangular = rectangular;
        this.dataCapacity = dataCapacity;
        this.errorCodewords = errorCodewords;
        this.matrixWidth = matrixWidth;
        this.matrixHeight = matrixHeight;
        this.dataRegions = dataRegions;
        this.rsBlockData = rsBlockData;
        this.rsBlockError = rsBlockError;
    }
    SymbolInfo.lookup = function (dataCodewords, shape, minSize, maxSize, fail) {
        var e_1, _a;
        if (shape === void 0) { shape = 0 /* FORCE_NONE */; }
        if (minSize === void 0) { minSize = null; }
        if (maxSize === void 0) { maxSize = null; }
        if (fail === void 0) { fail = true; }
        try {
            for (var PROD_SYMBOLS_1 = __values(exports.PROD_SYMBOLS), PROD_SYMBOLS_1_1 = PROD_SYMBOLS_1.next(); !PROD_SYMBOLS_1_1.done; PROD_SYMBOLS_1_1 = PROD_SYMBOLS_1.next()) {
                var symbol = PROD_SYMBOLS_1_1.value;
                if (shape === 1 /* FORCE_SQUARE */ && symbol.rectangular) {
                    continue;
                }
                if (shape === 2 /* FORCE_RECTANGLE */ && !symbol.rectangular) {
                    continue;
                }
                if (minSize != null &&
                    (symbol.getSymbolWidth() < minSize.getWidth() ||
                        symbol.getSymbolHeight() < minSize.getHeight())) {
                    continue;
                }
                if (maxSize != null &&
                    (symbol.getSymbolWidth() > maxSize.getWidth() ||
                        symbol.getSymbolHeight() > maxSize.getHeight())) {
                    continue;
                }
                if (dataCodewords <= symbol.dataCapacity) {
                    return symbol;
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (PROD_SYMBOLS_1_1 && !PROD_SYMBOLS_1_1.done && (_a = PROD_SYMBOLS_1.return)) _a.call(PROD_SYMBOLS_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        if (fail) {
            throw new Error("Can't find a symbol arrangement that matches the message. Data codewords: " +
                dataCodewords);
        }
        return null;
    };
    SymbolInfo.prototype.getHorizontalDataRegions = function () {
        switch (this.dataRegions) {
            case 1:
                return 1;
            case 2:
            case 4:
                return 2;
            case 16:
                return 4;
            case 36:
                return 6;
            default:
                throw new Error('Cannot handle this number of data regions');
        }
    };
    SymbolInfo.prototype.getVerticalDataRegions = function () {
        switch (this.dataRegions) {
            case 1:
            case 2:
                return 1;
            case 4:
                return 2;
            case 16:
                return 4;
            case 36:
                return 6;
            default:
                throw new Error('Cannot handle this number of data regions');
        }
    };
    SymbolInfo.prototype.getSymbolDataWidth = function () {
        return this.getHorizontalDataRegions() * this.matrixWidth;
    };
    SymbolInfo.prototype.getSymbolDataHeight = function () {
        return this.getVerticalDataRegions() * this.matrixHeight;
    };
    SymbolInfo.prototype.getSymbolWidth = function () {
        return this.getSymbolDataWidth() + this.getHorizontalDataRegions() * 2;
    };
    SymbolInfo.prototype.getSymbolHeight = function () {
        return this.getSymbolDataHeight() + this.getVerticalDataRegions() * 2;
    };
    SymbolInfo.prototype.getCodewordCount = function () {
        return this.dataCapacity + this.errorCodewords;
    };
    SymbolInfo.prototype.getInterleavedBlockCount = function () {
        if (!this.rsBlockData)
            return 1;
        return this.dataCapacity / this.rsBlockData;
    };
    SymbolInfo.prototype.getDataCapacity = function () {
        return this.dataCapacity;
    };
    SymbolInfo.prototype.getErrorCodewords = function () {
        return this.errorCodewords;
    };
    SymbolInfo.prototype.getDataLengthForInterleavedBlock = function (index) {
        return this.rsBlockData;
    };
    SymbolInfo.prototype.getErrorLengthForInterleavedBlock = function (index) {
        return this.rsBlockError;
    };
    return SymbolInfo;
}());
exports.default = SymbolInfo;
var DataMatrixSymbolInfo144 = /** @class */ (function (_super) {
    __extends(DataMatrixSymbolInfo144, _super);
    function DataMatrixSymbolInfo144() {
        return _super.call(this, false, 1558, 620, 22, 22, 36, -1, 62) || this;
    }
    DataMatrixSymbolInfo144.prototype.getInterleavedBlockCount = function () {
        return 10;
    };
    DataMatrixSymbolInfo144.prototype.getDataLengthForInterleavedBlock = function (index) {
        return index <= 8 ? 156 : 155;
    };
    return DataMatrixSymbolInfo144;
}(SymbolInfo));
exports.PROD_SYMBOLS = [
    new SymbolInfo(false, 3, 5, 8, 8, 1),
    new SymbolInfo(false, 5, 7, 10, 10, 1),
    /*rect*/ new SymbolInfo(true, 5, 7, 16, 6, 1),
    new SymbolInfo(false, 8, 10, 12, 12, 1),
    /*rect*/ new SymbolInfo(true, 10, 11, 14, 6, 2),
    new SymbolInfo(false, 12, 12, 14, 14, 1),
    /*rect*/ new SymbolInfo(true, 16, 14, 24, 10, 1),
    new SymbolInfo(false, 18, 14, 16, 16, 1),
    new SymbolInfo(false, 22, 18, 18, 18, 1),
    /*rect*/ new SymbolInfo(true, 22, 18, 16, 10, 2),
    new SymbolInfo(false, 30, 20, 20, 20, 1),
    /*rect*/ new SymbolInfo(true, 32, 24, 16, 14, 2),
    new SymbolInfo(false, 36, 24, 22, 22, 1),
    new SymbolInfo(false, 44, 28, 24, 24, 1),
    /*rect*/ new SymbolInfo(true, 49, 28, 22, 14, 2),
    new SymbolInfo(false, 62, 36, 14, 14, 4),
    new SymbolInfo(false, 86, 42, 16, 16, 4),
    new SymbolInfo(false, 114, 48, 18, 18, 4),
    new SymbolInfo(false, 144, 56, 20, 20, 4),
    new SymbolInfo(false, 174, 68, 22, 22, 4),
    new SymbolInfo(false, 204, 84, 24, 24, 4, 102, 42),
    new SymbolInfo(false, 280, 112, 14, 14, 16, 140, 56),
    new SymbolInfo(false, 368, 144, 16, 16, 16, 92, 36),
    new SymbolInfo(false, 456, 192, 18, 18, 16, 114, 48),
    new SymbolInfo(false, 576, 224, 20, 20, 16, 144, 56),
    new SymbolInfo(false, 696, 272, 22, 22, 16, 174, 68),
    new SymbolInfo(false, 816, 336, 24, 24, 16, 136, 56),
    new SymbolInfo(false, 1050, 408, 18, 18, 36, 175, 68),
    new SymbolInfo(false, 1304, 496, 20, 20, 36, 163, 62),
    new DataMatrixSymbolInfo144(),
];

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\SymbolInfo.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\TextEncoder.js", {"./C40Encoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\C40Encoder.js","./constants":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\constants.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cdatamatrix%5Cencoder%5CTextEncoder.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.TextEncoder = void 0;
var C40Encoder_1 = require("./C40Encoder");
var constants_1 = require("./constants");
var TextEncoder = /** @class */ (function (_super) {
    __extends(TextEncoder, _super);
    function TextEncoder() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    TextEncoder.prototype.getEncodingMode = function () {
        return constants_1.TEXT_ENCODATION;
    };
    TextEncoder.prototype.encodeChar = function (c, sb) {
        if (c === ' '.charCodeAt(0)) {
            sb.append(3);
            return 1;
        }
        if (c >= '0'.charCodeAt(0) && c <= '9'.charCodeAt(0)) {
            sb.append(c - 48 + 4);
            return 1;
        }
        if (c >= 'a'.charCodeAt(0) && c <= 'z'.charCodeAt(0)) {
            sb.append(c - 97 + 14);
            return 1;
        }
        if (c < ' '.charCodeAt(0)) {
            sb.append(0); // Shift 1 Set
            sb.append(c);
            return 2;
        }
        if (c <= '/'.charCodeAt(0)) {
            sb.append(1); // Shift 2 Set
            sb.append(c - 33);
            return 2;
        }
        if (c <= '@'.charCodeAt(0)) {
            sb.append(1); // Shift 2 Set
            sb.append(c - 58 + 15);
            return 2;
        }
        if (c >= '['.charCodeAt(0) && c <= '_'.charCodeAt(0)) {
            sb.append(1); // Shift 2 Set
            sb.append(c - 91 + 22);
            return 2;
        }
        if (c === '`'.charCodeAt(0)) {
            sb.append(2); // Shift 3 Set
            sb.append(0); // '`' - 96 == 0
            return 2;
        }
        if (c <= 'Z'.charCodeAt(0)) {
            sb.append(2); // Shift 3 Set
            sb.append(c - 65 + 1);
            return 2;
        }
        if (c <= 127) {
            sb.append(2); // Shift 3 Set
            sb.append(c - 123 + 27);
            return 2;
        }
        sb.append(1 + "\u001E"); // Shift 2, Upper Shift
        var len = 2;
        len += this.encodeChar(c - 128, sb);
        return len;
    };
    return TextEncoder;
}(C40Encoder_1.C40Encoder));
exports.TextEncoder = TextEncoder;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\TextEncoder.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\X12Encoder.js", {"../../common/StringUtils":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\StringUtils.js","../../util/StringBuilder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\StringBuilder.js","./C40Encoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\C40Encoder.js","./HighLevelEncoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\HighLevelEncoder.js","./constants":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\constants.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cdatamatrix%5Cencoder%5CX12Encoder.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.X12Encoder = void 0;
var StringUtils_1 = require("../../common/StringUtils");
var StringBuilder_1 = require("../../util/StringBuilder");
var C40Encoder_1 = require("./C40Encoder");
var HighLevelEncoder_1 = require("./HighLevelEncoder");
var constants_1 = require("./constants");
var X12Encoder = /** @class */ (function (_super) {
    __extends(X12Encoder, _super);
    function X12Encoder() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    X12Encoder.prototype.getEncodingMode = function () {
        return constants_1.X12_ENCODATION;
    };
    X12Encoder.prototype.encode = function (context) {
        // step C
        var buffer = new StringBuilder_1.default();
        while (context.hasMoreCharacters()) {
            var c = context.getCurrentChar();
            context.pos++;
            this.encodeChar(c, buffer);
            var count = buffer.length();
            if (count % 3 === 0) {
                this.writeNextTriplet(context, buffer);
                var newMode = HighLevelEncoder_1.default.lookAheadTest(context.getMessage(), context.pos, this.getEncodingMode());
                if (newMode !== this.getEncodingMode()) {
                    // Return to ASCII encodation, which will actually handle latch to new mode
                    context.signalEncoderChange(constants_1.ASCII_ENCODATION);
                    break;
                }
            }
        }
        this.handleEOD(context, buffer);
    };
    X12Encoder.prototype.encodeChar = function (c, sb) {
        switch (c) {
            case 13: // CR (Carriage return)
                sb.append(0);
                break;
            case '*'.charCodeAt(0):
                sb.append(1);
                break;
            case '>'.charCodeAt(0):
                sb.append(2);
                break;
            case ' '.charCodeAt(0):
                sb.append(3);
                break;
            default:
                if (c >= '0'.charCodeAt(0) && c <= '9'.charCodeAt(0)) {
                    sb.append(c - 48 + 4);
                }
                else if (c >= 'A'.charCodeAt(0) && c <= 'Z'.charCodeAt(0)) {
                    sb.append(c - 65 + 14);
                }
                else {
                    HighLevelEncoder_1.default.illegalCharacter(StringUtils_1.default.getCharAt(c));
                }
                break;
        }
        return 1;
    };
    X12Encoder.prototype.handleEOD = function (context, buffer) {
        context.updateSymbolInfo();
        var available = context.getSymbolInfo().getDataCapacity() - context.getCodewordCount();
        var count = buffer.length();
        context.pos -= count;
        if (context.getRemainingCharacters() > 1 ||
            available > 1 ||
            context.getRemainingCharacters() !== available) {
            context.writeCodeword(constants_1.X12_UNLATCH);
        }
        if (context.getNewEncoding() < 0) {
            context.signalEncoderChange(constants_1.ASCII_ENCODATION);
        }
    };
    return X12Encoder;
}(C40Encoder_1.C40Encoder));
exports.X12Encoder = X12Encoder;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\X12Encoder.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\constants.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cdatamatrix%5Cencoder%5Cconstants.js
      return function (require, module, exports) {
"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BASE256_ENCODATION = exports.EDIFACT_ENCODATION = exports.X12_ENCODATION = exports.TEXT_ENCODATION = exports.C40_ENCODATION = exports.ASCII_ENCODATION = exports.MACRO_TRAILER = exports.MACRO_06_HEADER = exports.MACRO_05_HEADER = exports.X12_UNLATCH = exports.C40_UNLATCH = exports.LATCH_TO_EDIFACT = exports.LATCH_TO_TEXT = exports.LATCH_TO_ANSIX12 = exports.MACRO_06 = exports.MACRO_05 = exports.UPPER_SHIFT = exports.LATCH_TO_BASE256 = exports.LATCH_TO_C40 = exports.PAD = exports.SymbolShapeHint = exports.ALOG = exports.LOG = exports.MODULO_VALUE = exports.FACTORS = exports.FACTOR_SETS = void 0;
/**
 * Lookup table which factors to use for which number of error correction codewords.
 * See FACTORS.
 */
exports.FACTOR_SETS = [
    5, 7, 10, 11, 12, 14, 18, 20, 24, 28, 36, 42, 48, 56, 62, 68,
];
/**
 * Precomputed polynomial factors for ECC 200.
 */
exports.FACTORS = [
    [228, 48, 15, 111, 62],
    [23, 68, 144, 134, 240, 92, 254],
    [28, 24, 185, 166, 223, 248, 116, 255, 110, 61],
    [175, 138, 205, 12, 194, 168, 39, 245, 60, 97, 120],
    [41, 153, 158, 91, 61, 42, 142, 213, 97, 178, 100, 242],
    [156, 97, 192, 252, 95, 9, 157, 119, 138, 45, 18, 186, 83, 185],
    [
        83, 195, 100, 39, 188, 75, 66, 61, 241, 213, 109, 129, 94, 254, 225, 48, 90,
        188,
    ],
    [
        15, 195, 244, 9, 233, 71, 168, 2, 188, 160, 153, 145, 253, 79, 108, 82, 27,
        174, 186, 172,
    ],
    [
        52, 190, 88, 205, 109, 39, 176, 21, 155, 197, 251, 223, 155, 21, 5, 172,
        254, 124, 12, 181, 184, 96, 50, 193,
    ],
    [
        211, 231, 43, 97, 71, 96, 103, 174, 37, 151, 170, 53, 75, 34, 249, 121, 17,
        138, 110, 213, 141, 136, 120, 151, 233, 168, 93, 255,
    ],
    [
        245, 127, 242, 218, 130, 250, 162, 181, 102, 120, 84, 179, 220, 251, 80,
        182, 229, 18, 2, 4, 68, 33, 101, 137, 95, 119, 115, 44, 175, 184, 59, 25,
        225, 98, 81, 112,
    ],
    [
        77, 193, 137, 31, 19, 38, 22, 153, 247, 105, 122, 2, 245, 133, 242, 8, 175,
        95, 100, 9, 167, 105, 214, 111, 57, 121, 21, 1, 253, 57, 54, 101, 248, 202,
        69, 50, 150, 177, 226, 5, 9, 5,
    ],
    [
        245, 132, 172, 223, 96, 32, 117, 22, 238, 133, 238, 231, 205, 188, 237, 87,
        191, 106, 16, 147, 118, 23, 37, 90, 170, 205, 131, 88, 120, 100, 66, 138,
        186, 240, 82, 44, 176, 87, 187, 147, 160, 175, 69, 213, 92, 253, 225, 19,
    ],
    [
        175, 9, 223, 238, 12, 17, 220, 208, 100, 29, 175, 170, 230, 192, 215, 235,
        150, 159, 36, 223, 38, 200, 132, 54, 228, 146, 218, 234, 117, 203, 29, 232,
        144, 238, 22, 150, 201, 117, 62, 207, 164, 13, 137, 245, 127, 67, 247, 28,
        155, 43, 203, 107, 233, 53, 143, 46,
    ],
    [
        242, 93, 169, 50, 144, 210, 39, 118, 202, 188, 201, 189, 143, 108, 196, 37,
        185, 112, 134, 230, 245, 63, 197, 190, 250, 106, 185, 221, 175, 64, 114, 71,
        161, 44, 147, 6, 27, 218, 51, 63, 87, 10, 40, 130, 188, 17, 163, 31, 176,
        170, 4, 107, 232, 7, 94, 166, 224, 124, 86, 47, 11, 204,
    ],
    [
        220, 228, 173, 89, 251, 149, 159, 56, 89, 33, 147, 244, 154, 36, 73, 127,
        213, 136, 248, 180, 234, 197, 158, 177, 68, 122, 93, 213, 15, 160, 227, 236,
        66, 139, 153, 185, 202, 167, 179, 25, 220, 232, 96, 210, 231, 136, 223, 239,
        181, 241, 59, 52, 172, 25, 49, 232, 211, 189, 64, 54, 108, 153, 132, 63, 96,
        103, 82, 186,
    ],
];
exports.MODULO_VALUE = 0x12d;
var static_LOG = function (LOG, ALOG) {
    var p = 1;
    for (var i = 0; i < 255; i++) {
        ALOG[i] = p;
        LOG[p] = i;
        p *= 2;
        if (p >= 256) {
            p ^= exports.MODULO_VALUE;
        }
    }
    return {
        LOG: LOG,
        ALOG: ALOG,
    };
};
exports.LOG = (_a = static_LOG([], []), _a.LOG), exports.ALOG = _a.ALOG;
var SymbolShapeHint;
(function (SymbolShapeHint) {
    SymbolShapeHint[SymbolShapeHint["FORCE_NONE"] = 0] = "FORCE_NONE";
    SymbolShapeHint[SymbolShapeHint["FORCE_SQUARE"] = 1] = "FORCE_SQUARE";
    SymbolShapeHint[SymbolShapeHint["FORCE_RECTANGLE"] = 2] = "FORCE_RECTANGLE";
})(SymbolShapeHint = exports.SymbolShapeHint || (exports.SymbolShapeHint = {}));
/**
 * Padding character
 */
exports.PAD = 129;
/**
 * mode latch to C40 encodation mode
 */
exports.LATCH_TO_C40 = 230;
/**
 * mode latch to Base 256 encodation mode
 */
exports.LATCH_TO_BASE256 = 231;
/**
 * FNC1 Codeword
 */
// private static FNC1 = 232;
/**
 * Structured Append Codeword
 */
// private static STRUCTURED_APPEND = 233;
/**
 * Reader Programming
 */
// private static READER_PROGRAMMING = 234;
/**
 * Upper Shift
 */
exports.UPPER_SHIFT = 235;
/**
 * 05 Macro
 */
exports.MACRO_05 = 236;
/**
 * 06 Macro
 */
exports.MACRO_06 = 237;
/**
 * mode latch to ANSI X.12 encodation mode
 */
exports.LATCH_TO_ANSIX12 = 238;
/**
 * mode latch to Text encodation mode
 */
exports.LATCH_TO_TEXT = 239;
/**
 * mode latch to EDIFACT encodation mode
 */
exports.LATCH_TO_EDIFACT = 240;
/**
 * ECI character (Extended Channel Interpretation)
 */
// private export const ECI = 241;
/**
 * Unlatch from C40 encodation
 */
exports.C40_UNLATCH = 254;
/**
 * Unlatch from X12 encodation
 */
exports.X12_UNLATCH = 254;
/**
 * 05 Macro header
 */
exports.MACRO_05_HEADER = '[)>\u001E05\u001D';
/**
 * 06 Macro header
 */
exports.MACRO_06_HEADER = '[)>\u001E06\u001D';
/**
 * Macro trailer
 */
exports.MACRO_TRAILER = '\u001E\u0004';
exports.ASCII_ENCODATION = 0;
exports.C40_ENCODATION = 1;
exports.TEXT_ENCODATION = 2;
exports.X12_ENCODATION = 3;
exports.EDIFACT_ENCODATION = 4;
exports.BASE256_ENCODATION = 5;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\constants.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\index.js", {"./ASCIIEncoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\ASCIIEncoder.js","./Base256Encoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\Base256Encoder.js","./C40Encoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\C40Encoder.js","./DefaultPlacement":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\DefaultPlacement.js","./EdifactEncoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\EdifactEncoder.js","./EncoderContext":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\EncoderContext.js","./ErrorCorrection":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\ErrorCorrection.js","./HighLevelEncoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\HighLevelEncoder.js","./MinimalEncoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\MinimalEncoder.js","./SymbolInfo":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\SymbolInfo.js","./TextEncoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\TextEncoder.js","./X12Encoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\X12Encoder.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cdatamatrix%5Cencoder%5Cindex.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.X12Encoder = exports.TextEncoder = exports.SymbolInfo = exports.MinimalEncoder = exports.HighLevelEncoder = exports.DefaultPlacement = exports.ErrorCorrection = exports.EncoderContext = exports.EdifactEncoder = exports.C40Encoder = exports.Base256Encoder = exports.ASCIIEncoder = void 0;
var ASCIIEncoder_1 = require("./ASCIIEncoder");
Object.defineProperty(exports, "ASCIIEncoder", { enumerable: true, get: function () { return ASCIIEncoder_1.ASCIIEncoder; } });
var Base256Encoder_1 = require("./Base256Encoder");
Object.defineProperty(exports, "Base256Encoder", { enumerable: true, get: function () { return Base256Encoder_1.Base256Encoder; } });
var C40Encoder_1 = require("./C40Encoder");
Object.defineProperty(exports, "C40Encoder", { enumerable: true, get: function () { return C40Encoder_1.C40Encoder; } });
var DefaultPlacement_1 = require("./DefaultPlacement");
exports.DefaultPlacement = DefaultPlacement_1.default;
var EdifactEncoder_1 = require("./EdifactEncoder");
Object.defineProperty(exports, "EdifactEncoder", { enumerable: true, get: function () { return EdifactEncoder_1.EdifactEncoder; } });
var EncoderContext_1 = require("./EncoderContext");
Object.defineProperty(exports, "EncoderContext", { enumerable: true, get: function () { return EncoderContext_1.EncoderContext; } });
var ErrorCorrection_1 = require("./ErrorCorrection");
exports.ErrorCorrection = ErrorCorrection_1.default;
var HighLevelEncoder_1 = require("./HighLevelEncoder");
exports.HighLevelEncoder = HighLevelEncoder_1.default;
var MinimalEncoder_1 = require("./MinimalEncoder");
Object.defineProperty(exports, "MinimalEncoder", { enumerable: true, get: function () { return MinimalEncoder_1.MinimalEncoder; } });
var SymbolInfo_1 = require("./SymbolInfo");
exports.SymbolInfo = SymbolInfo_1.default;
var TextEncoder_1 = require("./TextEncoder");
Object.defineProperty(exports, "TextEncoder", { enumerable: true, get: function () { return TextEncoder_1.TextEncoder; } });
var X12Encoder_1 = require("./X12Encoder");
Object.defineProperty(exports, "X12Encoder", { enumerable: true, get: function () { return X12Encoder_1.X12Encoder; } });

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\datamatrix\\encoder\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\AbstractUPCEANReader.js", {"../FormatException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\FormatException.js","../NotFoundException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\NotFoundException.js","./OneDReader":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\OneDReader.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5CAbstractUPCEANReader.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2008 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var OneDReader_1 = require("./OneDReader");
var NotFoundException_1 = require("../NotFoundException");
var FormatException_1 = require("../FormatException");
/**
 * <p>Encapsulates functionality and implementation that is common to UPC and EAN families
 * of one-dimensional barcodes.</p>
 *
 * @author dswitkin@google.com (Daniel Switkin)
 * @author Sean Owen
 * @author alasdair@google.com (Alasdair Mackintosh)
 */
var AbstractUPCEANReader = /** @class */ (function (_super) {
    __extends(AbstractUPCEANReader, _super);
    function AbstractUPCEANReader() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.decodeRowStringBuffer = '';
        return _this;
    }
    // private final UPCEANExtensionSupport extensionReader;
    // private final EANManufacturerOrgSupport eanManSupport;
    /*
    protected UPCEANReader() {
        decodeRowStringBuffer = new StringBuilder(20);
        extensionReader = new UPCEANExtensionSupport();
        eanManSupport = new EANManufacturerOrgSupport();
    }
    */
    AbstractUPCEANReader.findStartGuardPattern = function (row) {
        var foundStart = false;
        var startRange;
        var nextStart = 0;
        var counters = Int32Array.from([0, 0, 0]);
        while (!foundStart) {
            counters = Int32Array.from([0, 0, 0]);
            startRange = AbstractUPCEANReader.findGuardPattern(row, nextStart, false, this.START_END_PATTERN, counters);
            var start = startRange[0];
            nextStart = startRange[1];
            var quietStart = start - (nextStart - start);
            if (quietStart >= 0) {
                foundStart = row.isRange(quietStart, start, false);
            }
        }
        return startRange;
    };
    AbstractUPCEANReader.checkChecksum = function (s) {
        return AbstractUPCEANReader.checkStandardUPCEANChecksum(s);
    };
    AbstractUPCEANReader.checkStandardUPCEANChecksum = function (s) {
        var length = s.length;
        if (length === 0)
            return false;
        var check = parseInt(s.charAt(length - 1), 10);
        return AbstractUPCEANReader.getStandardUPCEANChecksum(s.substring(0, length - 1)) === check;
    };
    AbstractUPCEANReader.getStandardUPCEANChecksum = function (s) {
        var length = s.length;
        var sum = 0;
        for (var i = length - 1; i >= 0; i -= 2) {
            var digit = s.charAt(i).charCodeAt(0) - '0'.charCodeAt(0);
            if (digit < 0 || digit > 9) {
                throw new FormatException_1.default();
            }
            sum += digit;
        }
        sum *= 3;
        for (var i = length - 2; i >= 0; i -= 2) {
            var digit = s.charAt(i).charCodeAt(0) - '0'.charCodeAt(0);
            if (digit < 0 || digit > 9) {
                throw new FormatException_1.default();
            }
            sum += digit;
        }
        return (1000 - sum) % 10;
    };
    AbstractUPCEANReader.decodeEnd = function (row, endStart) {
        return AbstractUPCEANReader.findGuardPattern(row, endStart, false, AbstractUPCEANReader.START_END_PATTERN, new Int32Array(AbstractUPCEANReader.START_END_PATTERN.length).fill(0));
    };
    /**
     * @throws NotFoundException
     */
    AbstractUPCEANReader.findGuardPatternWithoutCounters = function (row, rowOffset, whiteFirst, pattern) {
        return this.findGuardPattern(row, rowOffset, whiteFirst, pattern, new Int32Array(pattern.length));
    };
    /**
     * @param row row of black/white values to search
     * @param rowOffset position to start search
     * @param whiteFirst if true, indicates that the pattern specifies white/black/white/...
     * pixel counts, otherwise, it is interpreted as black/white/black/...
     * @param pattern pattern of counts of number of black and white pixels that are being
     * searched for as a pattern
     * @param counters array of counters, as long as pattern, to re-use
     * @return start/end horizontal offset of guard pattern, as an array of two ints
     * @throws NotFoundException if pattern is not found
     */
    AbstractUPCEANReader.findGuardPattern = function (row, rowOffset, whiteFirst, pattern, counters) {
        var width = row.getSize();
        rowOffset = whiteFirst ? row.getNextUnset(rowOffset) : row.getNextSet(rowOffset);
        var counterPosition = 0;
        var patternStart = rowOffset;
        var patternLength = pattern.length;
        var isWhite = whiteFirst;
        for (var x = rowOffset; x < width; x++) {
            if (row.get(x) !== isWhite) {
                counters[counterPosition]++;
            }
            else {
                if (counterPosition === patternLength - 1) {
                    if (OneDReader_1.default.patternMatchVariance(counters, pattern, AbstractUPCEANReader.MAX_INDIVIDUAL_VARIANCE) < AbstractUPCEANReader.MAX_AVG_VARIANCE) {
                        return Int32Array.from([patternStart, x]);
                    }
                    patternStart += counters[0] + counters[1];
                    var slice = counters.slice(2, counters.length);
                    for (var i = 0; i < counterPosition - 1; i++) {
                        counters[i] = slice[i];
                    }
                    counters[counterPosition - 1] = 0;
                    counters[counterPosition] = 0;
                    counterPosition--;
                }
                else {
                    counterPosition++;
                }
                counters[counterPosition] = 1;
                isWhite = !isWhite;
            }
        }
        throw new NotFoundException_1.default();
    };
    AbstractUPCEANReader.decodeDigit = function (row, counters, rowOffset, patterns) {
        this.recordPattern(row, rowOffset, counters);
        var bestVariance = this.MAX_AVG_VARIANCE;
        var bestMatch = -1;
        var max = patterns.length;
        for (var i = 0; i < max; i++) {
            var pattern = patterns[i];
            var variance = OneDReader_1.default.patternMatchVariance(counters, pattern, AbstractUPCEANReader.MAX_INDIVIDUAL_VARIANCE);
            if (variance < bestVariance) {
                bestVariance = variance;
                bestMatch = i;
            }
        }
        if (bestMatch >= 0) {
            return bestMatch;
        }
        else {
            throw new NotFoundException_1.default();
        }
    };
    // These two values are critical for determining how permissive the decoding will be.
    // We've arrived at these values through a lot of trial and error. Setting them any higher
    // lets false positives creep in quickly.
    AbstractUPCEANReader.MAX_AVG_VARIANCE = 0.48;
    AbstractUPCEANReader.MAX_INDIVIDUAL_VARIANCE = 0.7;
    /**
     * Start/end guard pattern.
     */
    AbstractUPCEANReader.START_END_PATTERN = Int32Array.from([1, 1, 1]);
    /**
     * Pattern marking the middle of a UPC/EAN pattern, separating the two halves.
     */
    AbstractUPCEANReader.MIDDLE_PATTERN = Int32Array.from([1, 1, 1, 1, 1]);
    /**
     * end guard pattern.
     */
    AbstractUPCEANReader.END_PATTERN = Int32Array.from([1, 1, 1, 1, 1, 1]);
    /**
     * "Odd", or "L" patterns used to encode UPC/EAN digits.
     */
    AbstractUPCEANReader.L_PATTERNS = [
        Int32Array.from([3, 2, 1, 1]),
        Int32Array.from([2, 2, 2, 1]),
        Int32Array.from([2, 1, 2, 2]),
        Int32Array.from([1, 4, 1, 1]),
        Int32Array.from([1, 1, 3, 2]),
        Int32Array.from([1, 2, 3, 1]),
        Int32Array.from([1, 1, 1, 4]),
        Int32Array.from([1, 3, 1, 2]),
        Int32Array.from([1, 2, 1, 3]),
        Int32Array.from([3, 1, 1, 2]),
    ];
    return AbstractUPCEANReader;
}(OneDReader_1.default));
exports.default = AbstractUPCEANReader;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\AbstractUPCEANReader.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\CodaBarReader.js", {"../BarcodeFormat":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\BarcodeFormat.js","../NotFoundException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\NotFoundException.js","../Result":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\Result.js","../ResultPoint":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\ResultPoint.js","./OneDReader":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\OneDReader.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5CCodaBarReader.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2008 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
/*namespace com.google.zxing.oned {*/
var BarcodeFormat_1 = require("../BarcodeFormat");
var NotFoundException_1 = require("../NotFoundException");
var OneDReader_1 = require("./OneDReader");
var Result_1 = require("../Result");
var ResultPoint_1 = require("../ResultPoint");
/**
 * <p>Decodes CodaBar barcodes. </p>
 *
 * @author Evan @dodobelieve
 * @see CodaBarReader
 */
var CodaBarReader = /** @class */ (function (_super) {
    __extends(CodaBarReader, _super);
    function CodaBarReader() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.CODA_BAR_CHAR_SET = {
            nnnnnww: '0',
            nnnnwwn: '1',
            nnnwnnw: '2',
            wwnnnnn: '3',
            nnwnnwn: '4',
            wnnnnwn: '5',
            nwnnnnw: '6',
            nwnnwnn: '7',
            nwwnnnn: '8',
            wnnwnnn: '9',
            nnnwwnn: '-',
            nnwwnnn: '$',
            wnnnwnw: ':',
            wnwnnnw: '/',
            wnwnwnn: '.',
            nnwwwww: '+',
            nnwwnwn: 'A',
            nwnwnnw: 'B',
            nnnwnww: 'C',
            nnnwwwn: 'D'
        };
        return _this;
    }
    CodaBarReader.prototype.decodeRow = function (rowNumber, row, hints) {
        var validRowData = this.getValidRowData(row);
        if (!validRowData)
            throw new NotFoundException_1.default();
        var retStr = this.codaBarDecodeRow(validRowData.row);
        if (!retStr)
            throw new NotFoundException_1.default();
        return new Result_1.default(retStr, null, 0, [new ResultPoint_1.default(validRowData.left, rowNumber), new ResultPoint_1.default(validRowData.right, rowNumber)], BarcodeFormat_1.default.CODABAR, new Date().getTime());
    };
    /**
     * converts bit array to valid data array(lengths of black bits and white bits)
     * @param row bit array to convert
     */
    CodaBarReader.prototype.getValidRowData = function (row) {
        var booleanArr = row.toArray();
        var startIndex = booleanArr.indexOf(true);
        if (startIndex === -1)
            return null;
        var lastIndex = booleanArr.lastIndexOf(true);
        if (lastIndex <= startIndex)
            return null;
        booleanArr = booleanArr.slice(startIndex, lastIndex + 1);
        var result = [];
        var lastBit = booleanArr[0];
        var bitLength = 1;
        for (var i = 1; i < booleanArr.length; i++) {
            if (booleanArr[i] === lastBit) {
                bitLength++;
            }
            else {
                lastBit = booleanArr[i];
                result.push(bitLength);
                bitLength = 1;
            }
        }
        result.push(bitLength);
        // CodaBar code data valid
        if (result.length < 23 && (result.length + 1) % 8 !== 0)
            return null;
        return { row: result, left: startIndex, right: lastIndex };
    };
    /**
     * decode codabar code
     * @param row row to cecode
     */
    CodaBarReader.prototype.codaBarDecodeRow = function (row) {
        var code = [];
        var barThreshold = Math.ceil(row.reduce(function (pre, item) { return (pre + item) / 2; }, 0));
        // Read one encoded character at a time.
        while (row.length > 0) {
            var seg = row.splice(0, 8).splice(0, 7);
            var key = seg.map(function (len) { return (len < barThreshold ? 'n' : 'w'); }).join('');
            if (this.CODA_BAR_CHAR_SET[key] === undefined)
                return null;
            code.push(this.CODA_BAR_CHAR_SET[key]);
        }
        var strCode = code.join('');
        if (this.validCodaBarString(strCode))
            return strCode;
        return null;
    };
    /**
     * check if the string is a CodaBar string
     * @param src string to determine
     */
    CodaBarReader.prototype.validCodaBarString = function (src) {
        var reg = /^[A-D].{1,}[A-D]$/;
        return reg.test(src);
    };
    return CodaBarReader;
}(OneDReader_1.default));
exports.default = CodaBarReader;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\CodaBarReader.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\Code128Reader.js", {"../BarcodeFormat":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\BarcodeFormat.js","../ChecksumException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\ChecksumException.js","../DecodeHintType":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\DecodeHintType.js","../FormatException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\FormatException.js","../NotFoundException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\NotFoundException.js","../Result":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\Result.js","../ResultPoint":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\ResultPoint.js","./OneDReader":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\OneDReader.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5CCode128Reader.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2008 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
/*namespace com.google.zxing.oned {*/
var BarcodeFormat_1 = require("../BarcodeFormat");
var ChecksumException_1 = require("../ChecksumException");
var DecodeHintType_1 = require("../DecodeHintType");
var FormatException_1 = require("../FormatException");
var NotFoundException_1 = require("../NotFoundException");
// import Reader from '../Reader';
var Result_1 = require("../Result");
// import ResultMetadataType from '../ResultMetadataType';
var ResultPoint_1 = require("../ResultPoint");
var OneDReader_1 = require("./OneDReader");
/**
 * <p>Decodes Code 128 barcodes.</p>
 *
 * @author Sean Owen
 */
var Code128Reader = /** @class */ (function (_super) {
    __extends(Code128Reader, _super);
    function Code128Reader() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Code128Reader.findStartPattern = function (row) {
        var width = row.getSize();
        var rowOffset = row.getNextSet(0);
        var counterPosition = 0;
        var counters = Int32Array.from([0, 0, 0, 0, 0, 0]);
        var patternStart = rowOffset;
        var isWhite = false;
        var patternLength = 6;
        for (var i = rowOffset; i < width; i++) {
            if (row.get(i) !== isWhite) {
                counters[counterPosition]++;
            }
            else {
                if (counterPosition === (patternLength - 1)) {
                    var bestVariance = Code128Reader.MAX_AVG_VARIANCE;
                    var bestMatch = -1;
                    for (var startCode = Code128Reader.CODE_START_A; startCode <= Code128Reader.CODE_START_C; startCode++) {
                        var variance = OneDReader_1.default.patternMatchVariance(counters, Code128Reader.CODE_PATTERNS[startCode], Code128Reader.MAX_INDIVIDUAL_VARIANCE);
                        if (variance < bestVariance) {
                            bestVariance = variance;
                            bestMatch = startCode;
                        }
                    }
                    // Look for whitespace before start pattern, >= 50% of width of start pattern
                    if (bestMatch >= 0 &&
                        row.isRange(Math.max(0, patternStart - (i - patternStart) / 2), patternStart, false)) {
                        return Int32Array.from([patternStart, i, bestMatch]);
                    }
                    patternStart += counters[0] + counters[1];
                    counters = counters.slice(2, counters.length);
                    counters[counterPosition - 1] = 0;
                    counters[counterPosition] = 0;
                    counterPosition--;
                }
                else {
                    counterPosition++;
                }
                counters[counterPosition] = 1;
                isWhite = !isWhite;
            }
        }
        throw new NotFoundException_1.default();
    };
    Code128Reader.decodeCode = function (row, counters, rowOffset) {
        OneDReader_1.default.recordPattern(row, rowOffset, counters);
        var bestVariance = Code128Reader.MAX_AVG_VARIANCE; // worst variance we'll accept
        var bestMatch = -1;
        for (var d = 0; d < Code128Reader.CODE_PATTERNS.length; d++) {
            var pattern = Code128Reader.CODE_PATTERNS[d];
            var variance = this.patternMatchVariance(counters, pattern, Code128Reader.MAX_INDIVIDUAL_VARIANCE);
            if (variance < bestVariance) {
                bestVariance = variance;
                bestMatch = d;
            }
        }
        // TODO We're overlooking the fact that the STOP pattern has 7 values, not 6.
        if (bestMatch >= 0) {
            return bestMatch;
        }
        else {
            throw new NotFoundException_1.default();
        }
    };
    Code128Reader.prototype.decodeRow = function (rowNumber, row, hints) {
        var convertFNC1 = hints && (hints.get(DecodeHintType_1.default.ASSUME_GS1) === true);
        var startPatternInfo = Code128Reader.findStartPattern(row);
        var startCode = startPatternInfo[2];
        var currentRawCodesIndex = 0;
        var rawCodes = new Uint8Array(20);
        rawCodes[currentRawCodesIndex++] = startCode;
        var codeSet;
        switch (startCode) {
            case Code128Reader.CODE_START_A:
                codeSet = Code128Reader.CODE_CODE_A;
                break;
            case Code128Reader.CODE_START_B:
                codeSet = Code128Reader.CODE_CODE_B;
                break;
            case Code128Reader.CODE_START_C:
                codeSet = Code128Reader.CODE_CODE_C;
                break;
            default:
                throw new FormatException_1.default();
        }
        var done = false;
        var isNextShifted = false;
        var result = '';
        var lastStart = startPatternInfo[0];
        var nextStart = startPatternInfo[1];
        var counters = Int32Array.from([0, 0, 0, 0, 0, 0]);
        var lastCode = 0;
        var code = 0;
        var checksumTotal = startCode;
        var multiplier = 0;
        var lastCharacterWasPrintable = true;
        var upperMode = false;
        var shiftUpperMode = false;
        while (!done) {
            var unshift = isNextShifted;
            isNextShifted = false;
            // Save off last code
            lastCode = code;
            // Decode another code from image
            code = Code128Reader.decodeCode(row, counters, nextStart);
            rawCodes[currentRawCodesIndex++] = code;
            // Remember whether the last code was printable or not (excluding CODE_STOP)
            if (code !== Code128Reader.CODE_STOP) {
                lastCharacterWasPrintable = true;
            }
            // Add to checksum computation (if not CODE_STOP of course)
            if (code !== Code128Reader.CODE_STOP) {
                multiplier++;
                checksumTotal += multiplier * code;
            }
            // Advance to where the next code will to start
            lastStart = nextStart;
            nextStart += counters.reduce(function (previous, current) { return previous + current; }, 0);
            // Take care of illegal start codes
            switch (code) {
                case Code128Reader.CODE_START_A:
                case Code128Reader.CODE_START_B:
                case Code128Reader.CODE_START_C:
                    throw new FormatException_1.default();
            }
            switch (codeSet) {
                case Code128Reader.CODE_CODE_A:
                    if (code < 64) {
                        if (shiftUpperMode === upperMode) {
                            result += String.fromCharCode((' '.charCodeAt(0) + code));
                        }
                        else {
                            result += String.fromCharCode((' '.charCodeAt(0) + code + 128));
                        }
                        shiftUpperMode = false;
                    }
                    else if (code < 96) {
                        if (shiftUpperMode === upperMode) {
                            result += String.fromCharCode((code - 64));
                        }
                        else {
                            result += String.fromCharCode((code + 64));
                        }
                        shiftUpperMode = false;
                    }
                    else {
                        // Don't let CODE_STOP, which always appears, affect whether whether we think the last
                        // code was printable or not.
                        if (code !== Code128Reader.CODE_STOP) {
                            lastCharacterWasPrintable = false;
                        }
                        switch (code) {
                            case Code128Reader.CODE_FNC_1:
                                if (convertFNC1) {
                                    if (result.length === 0) {
                                        // GS1 specification 5.4.3.7. and 5.4.6.4. If the first char after the start code
                                        // is FNC1 then this is GS1-128. We add the symbology identifier.
                                        result += ']C1';
                                    }
                                    else {
                                        // GS1 specification 5.4.7.5. Every subsequent FNC1 is returned as ASCII 29 (GS)
                                        result += String.fromCharCode(29);
                                    }
                                }
                                break;
                            case Code128Reader.CODE_FNC_2:
                            case Code128Reader.CODE_FNC_3:
                                // do nothing?
                                break;
                            case Code128Reader.CODE_FNC_4_A:
                                if (!upperMode && shiftUpperMode) {
                                    upperMode = true;
                                    shiftUpperMode = false;
                                }
                                else if (upperMode && shiftUpperMode) {
                                    upperMode = false;
                                    shiftUpperMode = false;
                                }
                                else {
                                    shiftUpperMode = true;
                                }
                                break;
                            case Code128Reader.CODE_SHIFT:
                                isNextShifted = true;
                                codeSet = Code128Reader.CODE_CODE_B;
                                break;
                            case Code128Reader.CODE_CODE_B:
                                codeSet = Code128Reader.CODE_CODE_B;
                                break;
                            case Code128Reader.CODE_CODE_C:
                                codeSet = Code128Reader.CODE_CODE_C;
                                break;
                            case Code128Reader.CODE_STOP:
                                done = true;
                                break;
                        }
                    }
                    break;
                case Code128Reader.CODE_CODE_B:
                    if (code < 96) {
                        if (shiftUpperMode === upperMode) {
                            result += String.fromCharCode((' '.charCodeAt(0) + code));
                        }
                        else {
                            result += String.fromCharCode((' '.charCodeAt(0) + code + 128));
                        }
                        shiftUpperMode = false;
                    }
                    else {
                        if (code !== Code128Reader.CODE_STOP) {
                            lastCharacterWasPrintable = false;
                        }
                        switch (code) {
                            case Code128Reader.CODE_FNC_1:
                                if (convertFNC1) {
                                    if (result.length === 0) {
                                        // GS1 specification 5.4.3.7. and 5.4.6.4. If the first char after the start code
                                        // is FNC1 then this is GS1-128. We add the symbology identifier.
                                        result += ']C1';
                                    }
                                    else {
                                        // GS1 specification 5.4.7.5. Every subsequent FNC1 is returned as ASCII 29 (GS)
                                        result += String.fromCharCode(29);
                                    }
                                }
                                break;
                            case Code128Reader.CODE_FNC_2:
                            case Code128Reader.CODE_FNC_3:
                                // do nothing?
                                break;
                            case Code128Reader.CODE_FNC_4_B:
                                if (!upperMode && shiftUpperMode) {
                                    upperMode = true;
                                    shiftUpperMode = false;
                                }
                                else if (upperMode && shiftUpperMode) {
                                    upperMode = false;
                                    shiftUpperMode = false;
                                }
                                else {
                                    shiftUpperMode = true;
                                }
                                break;
                            case Code128Reader.CODE_SHIFT:
                                isNextShifted = true;
                                codeSet = Code128Reader.CODE_CODE_A;
                                break;
                            case Code128Reader.CODE_CODE_A:
                                codeSet = Code128Reader.CODE_CODE_A;
                                break;
                            case Code128Reader.CODE_CODE_C:
                                codeSet = Code128Reader.CODE_CODE_C;
                                break;
                            case Code128Reader.CODE_STOP:
                                done = true;
                                break;
                        }
                    }
                    break;
                case Code128Reader.CODE_CODE_C:
                    if (code < 100) {
                        if (code < 10) {
                            result += '0';
                        }
                        result += code;
                    }
                    else {
                        if (code !== Code128Reader.CODE_STOP) {
                            lastCharacterWasPrintable = false;
                        }
                        switch (code) {
                            case Code128Reader.CODE_FNC_1:
                                if (convertFNC1) {
                                    if (result.length === 0) {
                                        // GS1 specification 5.4.3.7. and 5.4.6.4. If the first char after the start code
                                        // is FNC1 then this is GS1-128. We add the symbology identifier.
                                        result += ']C1';
                                    }
                                    else {
                                        // GS1 specification 5.4.7.5. Every subsequent FNC1 is returned as ASCII 29 (GS)
                                        result += String.fromCharCode(29);
                                    }
                                }
                                break;
                            case Code128Reader.CODE_CODE_A:
                                codeSet = Code128Reader.CODE_CODE_A;
                                break;
                            case Code128Reader.CODE_CODE_B:
                                codeSet = Code128Reader.CODE_CODE_B;
                                break;
                            case Code128Reader.CODE_STOP:
                                done = true;
                                break;
                        }
                    }
                    break;
            }
            // Unshift back to another code set if we were shifted
            if (unshift) {
                codeSet = codeSet === Code128Reader.CODE_CODE_A ? Code128Reader.CODE_CODE_B : Code128Reader.CODE_CODE_A;
            }
        }
        var lastPatternSize = nextStart - lastStart;
        // Check for ample whitespace following pattern, but, to do this we first need to remember that
        // we fudged decoding CODE_STOP since it actually has 7 bars, not 6. There is a black bar left
        // to read off. Would be slightly better to properly read. Here we just skip it:
        nextStart = row.getNextUnset(nextStart);
        if (!row.isRange(nextStart, Math.min(row.getSize(), nextStart + (nextStart - lastStart) / 2), false)) {
            throw new NotFoundException_1.default();
        }
        // Pull out from sum the value of the penultimate check code
        checksumTotal -= multiplier * lastCode;
        // lastCode is the checksum then:
        if (checksumTotal % 103 !== lastCode) {
            throw new ChecksumException_1.default();
        }
        // Need to pull out the check digits from string
        var resultLength = result.length;
        if (resultLength === 0) {
            // false positive
            throw new NotFoundException_1.default();
        }
        // Only bother if the result had at least one character, and if the checksum digit happened to
        // be a printable character. If it was just interpreted as a control code, nothing to remove.
        if (resultLength > 0 && lastCharacterWasPrintable) {
            if (codeSet === Code128Reader.CODE_CODE_C) {
                result = result.substring(0, resultLength - 2);
            }
            else {
                result = result.substring(0, resultLength - 1);
            }
        }
        var left = (startPatternInfo[1] + startPatternInfo[0]) / 2.0;
        var right = lastStart + lastPatternSize / 2.0;
        var rawCodesSize = rawCodes.length;
        var rawBytes = new Uint8Array(rawCodesSize);
        for (var i = 0; i < rawCodesSize; i++) {
            rawBytes[i] = rawCodes[i];
        }
        var points = [new ResultPoint_1.default(left, rowNumber), new ResultPoint_1.default(right, rowNumber)];
        return new Result_1.default(result, rawBytes, 0, points, BarcodeFormat_1.default.CODE_128, new Date().getTime());
    };
    Code128Reader.CODE_PATTERNS = [
        Int32Array.from([2, 1, 2, 2, 2, 2]),
        Int32Array.from([2, 2, 2, 1, 2, 2]),
        Int32Array.from([2, 2, 2, 2, 2, 1]),
        Int32Array.from([1, 2, 1, 2, 2, 3]),
        Int32Array.from([1, 2, 1, 3, 2, 2]),
        Int32Array.from([1, 3, 1, 2, 2, 2]),
        Int32Array.from([1, 2, 2, 2, 1, 3]),
        Int32Array.from([1, 2, 2, 3, 1, 2]),
        Int32Array.from([1, 3, 2, 2, 1, 2]),
        Int32Array.from([2, 2, 1, 2, 1, 3]),
        Int32Array.from([2, 2, 1, 3, 1, 2]),
        Int32Array.from([2, 3, 1, 2, 1, 2]),
        Int32Array.from([1, 1, 2, 2, 3, 2]),
        Int32Array.from([1, 2, 2, 1, 3, 2]),
        Int32Array.from([1, 2, 2, 2, 3, 1]),
        Int32Array.from([1, 1, 3, 2, 2, 2]),
        Int32Array.from([1, 2, 3, 1, 2, 2]),
        Int32Array.from([1, 2, 3, 2, 2, 1]),
        Int32Array.from([2, 2, 3, 2, 1, 1]),
        Int32Array.from([2, 2, 1, 1, 3, 2]),
        Int32Array.from([2, 2, 1, 2, 3, 1]),
        Int32Array.from([2, 1, 3, 2, 1, 2]),
        Int32Array.from([2, 2, 3, 1, 1, 2]),
        Int32Array.from([3, 1, 2, 1, 3, 1]),
        Int32Array.from([3, 1, 1, 2, 2, 2]),
        Int32Array.from([3, 2, 1, 1, 2, 2]),
        Int32Array.from([3, 2, 1, 2, 2, 1]),
        Int32Array.from([3, 1, 2, 2, 1, 2]),
        Int32Array.from([3, 2, 2, 1, 1, 2]),
        Int32Array.from([3, 2, 2, 2, 1, 1]),
        Int32Array.from([2, 1, 2, 1, 2, 3]),
        Int32Array.from([2, 1, 2, 3, 2, 1]),
        Int32Array.from([2, 3, 2, 1, 2, 1]),
        Int32Array.from([1, 1, 1, 3, 2, 3]),
        Int32Array.from([1, 3, 1, 1, 2, 3]),
        Int32Array.from([1, 3, 1, 3, 2, 1]),
        Int32Array.from([1, 1, 2, 3, 1, 3]),
        Int32Array.from([1, 3, 2, 1, 1, 3]),
        Int32Array.from([1, 3, 2, 3, 1, 1]),
        Int32Array.from([2, 1, 1, 3, 1, 3]),
        Int32Array.from([2, 3, 1, 1, 1, 3]),
        Int32Array.from([2, 3, 1, 3, 1, 1]),
        Int32Array.from([1, 1, 2, 1, 3, 3]),
        Int32Array.from([1, 1, 2, 3, 3, 1]),
        Int32Array.from([1, 3, 2, 1, 3, 1]),
        Int32Array.from([1, 1, 3, 1, 2, 3]),
        Int32Array.from([1, 1, 3, 3, 2, 1]),
        Int32Array.from([1, 3, 3, 1, 2, 1]),
        Int32Array.from([3, 1, 3, 1, 2, 1]),
        Int32Array.from([2, 1, 1, 3, 3, 1]),
        Int32Array.from([2, 3, 1, 1, 3, 1]),
        Int32Array.from([2, 1, 3, 1, 1, 3]),
        Int32Array.from([2, 1, 3, 3, 1, 1]),
        Int32Array.from([2, 1, 3, 1, 3, 1]),
        Int32Array.from([3, 1, 1, 1, 2, 3]),
        Int32Array.from([3, 1, 1, 3, 2, 1]),
        Int32Array.from([3, 3, 1, 1, 2, 1]),
        Int32Array.from([3, 1, 2, 1, 1, 3]),
        Int32Array.from([3, 1, 2, 3, 1, 1]),
        Int32Array.from([3, 3, 2, 1, 1, 1]),
        Int32Array.from([3, 1, 4, 1, 1, 1]),
        Int32Array.from([2, 2, 1, 4, 1, 1]),
        Int32Array.from([4, 3, 1, 1, 1, 1]),
        Int32Array.from([1, 1, 1, 2, 2, 4]),
        Int32Array.from([1, 1, 1, 4, 2, 2]),
        Int32Array.from([1, 2, 1, 1, 2, 4]),
        Int32Array.from([1, 2, 1, 4, 2, 1]),
        Int32Array.from([1, 4, 1, 1, 2, 2]),
        Int32Array.from([1, 4, 1, 2, 2, 1]),
        Int32Array.from([1, 1, 2, 2, 1, 4]),
        Int32Array.from([1, 1, 2, 4, 1, 2]),
        Int32Array.from([1, 2, 2, 1, 1, 4]),
        Int32Array.from([1, 2, 2, 4, 1, 1]),
        Int32Array.from([1, 4, 2, 1, 1, 2]),
        Int32Array.from([1, 4, 2, 2, 1, 1]),
        Int32Array.from([2, 4, 1, 2, 1, 1]),
        Int32Array.from([2, 2, 1, 1, 1, 4]),
        Int32Array.from([4, 1, 3, 1, 1, 1]),
        Int32Array.from([2, 4, 1, 1, 1, 2]),
        Int32Array.from([1, 3, 4, 1, 1, 1]),
        Int32Array.from([1, 1, 1, 2, 4, 2]),
        Int32Array.from([1, 2, 1, 1, 4, 2]),
        Int32Array.from([1, 2, 1, 2, 4, 1]),
        Int32Array.from([1, 1, 4, 2, 1, 2]),
        Int32Array.from([1, 2, 4, 1, 1, 2]),
        Int32Array.from([1, 2, 4, 2, 1, 1]),
        Int32Array.from([4, 1, 1, 2, 1, 2]),
        Int32Array.from([4, 2, 1, 1, 1, 2]),
        Int32Array.from([4, 2, 1, 2, 1, 1]),
        Int32Array.from([2, 1, 2, 1, 4, 1]),
        Int32Array.from([2, 1, 4, 1, 2, 1]),
        Int32Array.from([4, 1, 2, 1, 2, 1]),
        Int32Array.from([1, 1, 1, 1, 4, 3]),
        Int32Array.from([1, 1, 1, 3, 4, 1]),
        Int32Array.from([1, 3, 1, 1, 4, 1]),
        Int32Array.from([1, 1, 4, 1, 1, 3]),
        Int32Array.from([1, 1, 4, 3, 1, 1]),
        Int32Array.from([4, 1, 1, 1, 1, 3]),
        Int32Array.from([4, 1, 1, 3, 1, 1]),
        Int32Array.from([1, 1, 3, 1, 4, 1]),
        Int32Array.from([1, 1, 4, 1, 3, 1]),
        Int32Array.from([3, 1, 1, 1, 4, 1]),
        Int32Array.from([4, 1, 1, 1, 3, 1]),
        Int32Array.from([2, 1, 1, 4, 1, 2]),
        Int32Array.from([2, 1, 1, 2, 1, 4]),
        Int32Array.from([2, 1, 1, 2, 3, 2]),
        Int32Array.from([2, 3, 3, 1, 1, 1, 2]),
    ];
    Code128Reader.MAX_AVG_VARIANCE = 0.25;
    Code128Reader.MAX_INDIVIDUAL_VARIANCE = 0.7;
    Code128Reader.CODE_SHIFT = 98;
    Code128Reader.CODE_CODE_C = 99;
    Code128Reader.CODE_CODE_B = 100;
    Code128Reader.CODE_CODE_A = 101;
    Code128Reader.CODE_FNC_1 = 102;
    Code128Reader.CODE_FNC_2 = 97;
    Code128Reader.CODE_FNC_3 = 96;
    Code128Reader.CODE_FNC_4_A = 101;
    Code128Reader.CODE_FNC_4_B = 100;
    Code128Reader.CODE_START_A = 103;
    Code128Reader.CODE_START_B = 104;
    Code128Reader.CODE_START_C = 105;
    Code128Reader.CODE_STOP = 106;
    return Code128Reader;
}(OneDReader_1.default));
exports.default = Code128Reader;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\Code128Reader.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\Code39Reader.js", {"../BarcodeFormat":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\BarcodeFormat.js","../ChecksumException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\ChecksumException.js","../FormatException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\FormatException.js","../NotFoundException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\NotFoundException.js","../Result":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\Result.js","../ResultPoint":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\ResultPoint.js","./OneDReader":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\OneDReader.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5CCode39Reader.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2008 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
/*namespace com.google.zxing.oned {*/
var BarcodeFormat_1 = require("../BarcodeFormat");
var ChecksumException_1 = require("../ChecksumException");
var FormatException_1 = require("../FormatException");
var NotFoundException_1 = require("../NotFoundException");
var OneDReader_1 = require("./OneDReader");
var Result_1 = require("../Result");
var ResultPoint_1 = require("../ResultPoint");
/**
 * <p>Decodes Code 39 barcodes. Supports "Full ASCII Code 39" if USE_CODE_39_EXTENDED_MODE is set.</p>
 *
 * @author Sean Owen
 * @see Code93Reader
 */
var Code39Reader = /** @class */ (function (_super) {
    __extends(Code39Reader, _super);
    /**
     * Creates a reader that assumes all encoded data is data, and does not treat the final
     * character as a check digit. It will not decoded "extended Code 39" sequences.
     */
    // public Code39Reader() {
    //   this(false);
    // }
    /**
     * Creates a reader that can be configured to check the last character as a check digit.
     * It will not decoded "extended Code 39" sequences.
     *
     * @param usingCheckDigit if true, treat the last data character as a check digit, not
     * data, and verify that the checksum passes.
     */
    // public Code39Reader(boolean usingCheckDigit) {
    //   this(usingCheckDigit, false);
    // }
    /**
     * Creates a reader that can be configured to check the last character as a check digit,
     * or optionally attempt to decode "extended Code 39" sequences that are used to encode
     * the full ASCII character set.
     *
     * @param usingCheckDigit if true, treat the last data character as a check digit, not
     * data, and verify that the checksum passes.
     * @param extendedMode if true, will attempt to decode extended Code 39 sequences in the
     * text.
     */
    function Code39Reader(usingCheckDigit, extendedMode) {
        if (usingCheckDigit === void 0) { usingCheckDigit = false; }
        if (extendedMode === void 0) { extendedMode = false; }
        var _this = _super.call(this) || this;
        _this.usingCheckDigit = usingCheckDigit;
        _this.extendedMode = extendedMode;
        _this.decodeRowResult = '';
        _this.counters = new Int32Array(9);
        return _this;
    }
    Code39Reader.prototype.decodeRow = function (rowNumber, row, hints) {
        var e_1, _a, e_2, _b;
        var theCounters = this.counters;
        theCounters.fill(0);
        this.decodeRowResult = '';
        var start = Code39Reader.findAsteriskPattern(row, theCounters);
        // Read off white space
        var nextStart = row.getNextSet(start[1]);
        var end = row.getSize();
        var decodedChar;
        var lastStart;
        do {
            Code39Reader.recordPattern(row, nextStart, theCounters);
            var pattern = Code39Reader.toNarrowWidePattern(theCounters);
            if (pattern < 0) {
                throw new NotFoundException_1.default();
            }
            decodedChar = Code39Reader.patternToChar(pattern);
            this.decodeRowResult += decodedChar;
            lastStart = nextStart;
            try {
                for (var theCounters_1 = (e_1 = void 0, __values(theCounters)), theCounters_1_1 = theCounters_1.next(); !theCounters_1_1.done; theCounters_1_1 = theCounters_1.next()) {
                    var counter = theCounters_1_1.value;
                    nextStart += counter;
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (theCounters_1_1 && !theCounters_1_1.done && (_a = theCounters_1.return)) _a.call(theCounters_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            // Read off white space
            nextStart = row.getNextSet(nextStart);
        } while (decodedChar !== '*');
        this.decodeRowResult = this.decodeRowResult.substring(0, this.decodeRowResult.length - 1); // remove asterisk
        // Look for whitespace after pattern:
        var lastPatternSize = 0;
        try {
            for (var theCounters_2 = __values(theCounters), theCounters_2_1 = theCounters_2.next(); !theCounters_2_1.done; theCounters_2_1 = theCounters_2.next()) {
                var counter = theCounters_2_1.value;
                lastPatternSize += counter;
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (theCounters_2_1 && !theCounters_2_1.done && (_b = theCounters_2.return)) _b.call(theCounters_2);
            }
            finally { if (e_2) throw e_2.error; }
        }
        var whiteSpaceAfterEnd = nextStart - lastStart - lastPatternSize;
        // If 50% of last pattern size, following last pattern, is not whitespace, fail
        // (but if it's whitespace to the very end of the image, that's OK)
        if (nextStart !== end && (whiteSpaceAfterEnd * 2) < lastPatternSize) {
            throw new NotFoundException_1.default();
        }
        if (this.usingCheckDigit) {
            var max = this.decodeRowResult.length - 1;
            var total = 0;
            for (var i = 0; i < max; i++) {
                total += Code39Reader.ALPHABET_STRING.indexOf(this.decodeRowResult.charAt(i));
            }
            if (this.decodeRowResult.charAt(max) !== Code39Reader.ALPHABET_STRING.charAt(total % 43)) {
                throw new ChecksumException_1.default();
            }
            this.decodeRowResult = this.decodeRowResult.substring(0, max);
        }
        if (this.decodeRowResult.length === 0) {
            // false positive
            throw new NotFoundException_1.default();
        }
        var resultString;
        if (this.extendedMode) {
            resultString = Code39Reader.decodeExtended(this.decodeRowResult);
        }
        else {
            resultString = this.decodeRowResult;
        }
        var left = (start[1] + start[0]) / 2.0;
        var right = lastStart + lastPatternSize / 2.0;
        return new Result_1.default(resultString, null, 0, [new ResultPoint_1.default(left, rowNumber), new ResultPoint_1.default(right, rowNumber)], BarcodeFormat_1.default.CODE_39, new Date().getTime());
    };
    Code39Reader.findAsteriskPattern = function (row, counters) {
        var width = row.getSize();
        var rowOffset = row.getNextSet(0);
        var counterPosition = 0;
        var patternStart = rowOffset;
        var isWhite = false;
        var patternLength = counters.length;
        for (var i = rowOffset; i < width; i++) {
            if (row.get(i) !== isWhite) {
                counters[counterPosition]++;
            }
            else {
                if (counterPosition === patternLength - 1) {
                    // Look for whitespace before start pattern, >= 50% of width of start pattern
                    if (this.toNarrowWidePattern(counters) === Code39Reader.ASTERISK_ENCODING &&
                        row.isRange(Math.max(0, patternStart - Math.floor((i - patternStart) / 2)), patternStart, false)) {
                        return [patternStart, i];
                    }
                    patternStart += counters[0] + counters[1];
                    counters.copyWithin(0, 2, 2 + counterPosition - 1);
                    counters[counterPosition - 1] = 0;
                    counters[counterPosition] = 0;
                    counterPosition--;
                }
                else {
                    counterPosition++;
                }
                counters[counterPosition] = 1;
                isWhite = !isWhite;
            }
        }
        throw new NotFoundException_1.default();
    };
    // For efficiency, returns -1 on failure. Not throwing here saved as many as 700 exceptions
    // per image when using some of our blackbox images.
    Code39Reader.toNarrowWidePattern = function (counters) {
        var e_3, _a;
        var numCounters = counters.length;
        var maxNarrowCounter = 0;
        var wideCounters;
        do {
            var minCounter = 0x7fffffff;
            try {
                for (var counters_1 = (e_3 = void 0, __values(counters)), counters_1_1 = counters_1.next(); !counters_1_1.done; counters_1_1 = counters_1.next()) {
                    var counter = counters_1_1.value;
                    if (counter < minCounter && counter > maxNarrowCounter) {
                        minCounter = counter;
                    }
                }
            }
            catch (e_3_1) { e_3 = { error: e_3_1 }; }
            finally {
                try {
                    if (counters_1_1 && !counters_1_1.done && (_a = counters_1.return)) _a.call(counters_1);
                }
                finally { if (e_3) throw e_3.error; }
            }
            maxNarrowCounter = minCounter;
            wideCounters = 0;
            var totalWideCountersWidth = 0;
            var pattern = 0;
            for (var i = 0; i < numCounters; i++) {
                var counter = counters[i];
                if (counter > maxNarrowCounter) {
                    pattern |= 1 << (numCounters - 1 - i);
                    wideCounters++;
                    totalWideCountersWidth += counter;
                }
            }
            if (wideCounters === 3) {
                // Found 3 wide counters, but are they close enough in width?
                // We can perform a cheap, conservative check to see if any individual
                // counter is more than 1.5 times the average:
                for (var i = 0; i < numCounters && wideCounters > 0; i++) {
                    var counter = counters[i];
                    if (counter > maxNarrowCounter) {
                        wideCounters--;
                        // totalWideCountersWidth = 3 * average, so this checks if counter >= 3/2 * average
                        if ((counter * 2) >= totalWideCountersWidth) {
                            return -1;
                        }
                    }
                }
                return pattern;
            }
        } while (wideCounters > 3);
        return -1;
    };
    Code39Reader.patternToChar = function (pattern) {
        for (var i = 0; i < Code39Reader.CHARACTER_ENCODINGS.length; i++) {
            if (Code39Reader.CHARACTER_ENCODINGS[i] === pattern) {
                return Code39Reader.ALPHABET_STRING.charAt(i);
            }
        }
        if (pattern === Code39Reader.ASTERISK_ENCODING) {
            return '*';
        }
        throw new NotFoundException_1.default();
    };
    Code39Reader.decodeExtended = function (encoded) {
        var length = encoded.length;
        var decoded = '';
        for (var i = 0; i < length; i++) {
            var c = encoded.charAt(i);
            if (c === '+' || c === '$' || c === '%' || c === '/') {
                var next = encoded.charAt(i + 1);
                var decodedChar = '\0';
                switch (c) {
                    case '+':
                        // +A to +Z map to a to z
                        if (next >= 'A' && next <= 'Z') {
                            decodedChar = String.fromCharCode(next.charCodeAt(0) + 32);
                        }
                        else {
                            throw new FormatException_1.default();
                        }
                        break;
                    case '$':
                        // $A to $Z map to control codes SH to SB
                        if (next >= 'A' && next <= 'Z') {
                            decodedChar = String.fromCharCode(next.charCodeAt(0) - 64);
                        }
                        else {
                            throw new FormatException_1.default();
                        }
                        break;
                    case '%':
                        // %A to %E map to control codes ESC to US
                        if (next >= 'A' && next <= 'E') {
                            decodedChar = String.fromCharCode(next.charCodeAt(0) - 38);
                        }
                        else if (next >= 'F' && next <= 'J') {
                            decodedChar = String.fromCharCode(next.charCodeAt(0) - 11);
                        }
                        else if (next >= 'K' && next <= 'O') {
                            decodedChar = String.fromCharCode(next.charCodeAt(0) + 16);
                        }
                        else if (next >= 'P' && next <= 'T') {
                            decodedChar = String.fromCharCode(next.charCodeAt(0) + 43);
                        }
                        else if (next === 'U') {
                            decodedChar = '\0';
                        }
                        else if (next === 'V') {
                            decodedChar = '@';
                        }
                        else if (next === 'W') {
                            decodedChar = '`';
                        }
                        else if (next === 'X' || next === 'Y' || next === 'Z') {
                            decodedChar = '\x7f';
                        }
                        else {
                            throw new FormatException_1.default();
                        }
                        break;
                    case '/':
                        // /A to /O map to ! to , and /Z maps to :
                        if (next >= 'A' && next <= 'O') {
                            decodedChar = String.fromCharCode(next.charCodeAt(0) - 32);
                        }
                        else if (next === 'Z') {
                            decodedChar = ':';
                        }
                        else {
                            throw new FormatException_1.default();
                        }
                        break;
                }
                decoded += decodedChar;
                // bump up i again since we read two characters
                i++;
            }
            else {
                decoded += c;
            }
        }
        return decoded;
    };
    Code39Reader.ALPHABET_STRING = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%';
    /**
     * These represent the encodings of characters, as patterns of wide and narrow bars.
     * The 9 least-significant bits of each int correspond to the pattern of wide and narrow,
     * with 1s representing "wide" and 0s representing narrow.
     */
    Code39Reader.CHARACTER_ENCODINGS = [
        0x034, 0x121, 0x061, 0x160, 0x031, 0x130, 0x070, 0x025, 0x124, 0x064,
        0x109, 0x049, 0x148, 0x019, 0x118, 0x058, 0x00D, 0x10C, 0x04C, 0x01C,
        0x103, 0x043, 0x142, 0x013, 0x112, 0x052, 0x007, 0x106, 0x046, 0x016,
        0x181, 0x0C1, 0x1C0, 0x091, 0x190, 0x0D0, 0x085, 0x184, 0x0C4, 0x0A8,
        0x0A2, 0x08A, 0x02A // /-%
    ];
    Code39Reader.ASTERISK_ENCODING = 0x094;
    return Code39Reader;
}(OneDReader_1.default));
exports.default = Code39Reader;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\Code39Reader.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\Code93Reader.js", {"../BarcodeFormat":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\BarcodeFormat.js","../ChecksumException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\ChecksumException.js","../FormatException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\FormatException.js","../NotFoundException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\NotFoundException.js","../Result":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\Result.js","../ResultPoint":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\ResultPoint.js","./OneDReader":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\OneDReader.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5CCode93Reader.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2010 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
/*namespace com.google.zxing.oned {*/
var BarcodeFormat_1 = require("../BarcodeFormat");
var ChecksumException_1 = require("../ChecksumException");
var FormatException_1 = require("../FormatException");
var NotFoundException_1 = require("../NotFoundException");
var OneDReader_1 = require("./OneDReader");
var Result_1 = require("../Result");
//import com.google.zxing.ResultMetadataType;
var ResultPoint_1 = require("../ResultPoint");
/**
 * <p>Decodes Code 93 barcodes.</p>
 *
 * @author Sean Owen
 * @see Code39Reader
 */
var Code93Reader = /** @class */ (function (_super) {
    __extends(Code93Reader, _super);
    //public Code93Reader() {
    //  decodeRowResult = new StringBuilder(20);
    //  counters = new int[6];
    //}
    function Code93Reader() {
        var _this = _super.call(this) || this;
        _this.decodeRowResult = '';
        _this.counters = new Int32Array(6);
        return _this;
    }
    Code93Reader.prototype.decodeRow = function (rowNumber, row, hints) {
        var e_1, _a, e_2, _b;
        var start = this.findAsteriskPattern(row);
        // Read off white space
        var nextStart = row.getNextSet(start[1]);
        var end = row.getSize();
        var theCounters = this.counters;
        theCounters.fill(0);
        this.decodeRowResult = '';
        var decodedChar;
        var lastStart;
        do {
            Code93Reader.recordPattern(row, nextStart, theCounters);
            var pattern = this.toPattern(theCounters);
            if (pattern < 0) {
                throw new NotFoundException_1.default();
            }
            decodedChar = this.patternToChar(pattern);
            this.decodeRowResult += decodedChar;
            lastStart = nextStart;
            try {
                for (var theCounters_1 = (e_1 = void 0, __values(theCounters)), theCounters_1_1 = theCounters_1.next(); !theCounters_1_1.done; theCounters_1_1 = theCounters_1.next()) {
                    var counter = theCounters_1_1.value;
                    nextStart += counter;
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (theCounters_1_1 && !theCounters_1_1.done && (_a = theCounters_1.return)) _a.call(theCounters_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            // Read off white space
            nextStart = row.getNextSet(nextStart);
        } while (decodedChar !== '*');
        this.decodeRowResult = this.decodeRowResult.substring(0, this.decodeRowResult.length - 1); // remove asterisk
        var lastPatternSize = 0;
        try {
            for (var theCounters_2 = __values(theCounters), theCounters_2_1 = theCounters_2.next(); !theCounters_2_1.done; theCounters_2_1 = theCounters_2.next()) {
                var counter = theCounters_2_1.value;
                lastPatternSize += counter;
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (theCounters_2_1 && !theCounters_2_1.done && (_b = theCounters_2.return)) _b.call(theCounters_2);
            }
            finally { if (e_2) throw e_2.error; }
        }
        // Should be at least one more black module
        if (nextStart === end || !row.get(nextStart)) {
            throw new NotFoundException_1.default();
        }
        if (this.decodeRowResult.length < 2) {
            // false positive -- need at least 2 checksum digits
            throw new NotFoundException_1.default();
        }
        this.checkChecksums(this.decodeRowResult);
        // Remove checksum digits
        this.decodeRowResult = this.decodeRowResult.substring(0, this.decodeRowResult.length - 2);
        var resultString = this.decodeExtended(this.decodeRowResult);
        var left = (start[1] + start[0]) / 2.0;
        var right = lastStart + lastPatternSize / 2.0;
        return new Result_1.default(resultString, null, 0, [new ResultPoint_1.default(left, rowNumber), new ResultPoint_1.default(right, rowNumber)], BarcodeFormat_1.default.CODE_93, new Date().getTime());
    };
    Code93Reader.prototype.findAsteriskPattern = function (row) {
        var width = row.getSize();
        var rowOffset = row.getNextSet(0);
        this.counters.fill(0);
        var theCounters = this.counters;
        var patternStart = rowOffset;
        var isWhite = false;
        var patternLength = theCounters.length;
        var counterPosition = 0;
        for (var i = rowOffset; i < width; i++) {
            if (row.get(i) !== isWhite) {
                theCounters[counterPosition]++;
            }
            else {
                if (counterPosition === patternLength - 1) {
                    if (this.toPattern(theCounters) === Code93Reader.ASTERISK_ENCODING) {
                        return new Int32Array([patternStart, i]);
                    }
                    patternStart += theCounters[0] + theCounters[1];
                    theCounters.copyWithin(0, 2, 2 + counterPosition - 1);
                    theCounters[counterPosition - 1] = 0;
                    theCounters[counterPosition] = 0;
                    counterPosition--;
                }
                else {
                    counterPosition++;
                }
                theCounters[counterPosition] = 1;
                isWhite = !isWhite;
            }
        }
        throw new NotFoundException_1.default;
    };
    Code93Reader.prototype.toPattern = function (counters) {
        var e_3, _a;
        var sum = 0;
        try {
            for (var counters_1 = __values(counters), counters_1_1 = counters_1.next(); !counters_1_1.done; counters_1_1 = counters_1.next()) {
                var counter = counters_1_1.value;
                sum += counter;
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (counters_1_1 && !counters_1_1.done && (_a = counters_1.return)) _a.call(counters_1);
            }
            finally { if (e_3) throw e_3.error; }
        }
        var pattern = 0;
        var max = counters.length;
        for (var i = 0; i < max; i++) {
            var scaled = Math.round(counters[i] * 9.0 / sum);
            if (scaled < 1 || scaled > 4) {
                return -1;
            }
            if ((i & 0x01) === 0) {
                for (var j = 0; j < scaled; j++) {
                    pattern = (pattern << 1) | 0x01;
                }
            }
            else {
                pattern <<= scaled;
            }
        }
        return pattern;
    };
    Code93Reader.prototype.patternToChar = function (pattern) {
        for (var i = 0; i < Code93Reader.CHARACTER_ENCODINGS.length; i++) {
            if (Code93Reader.CHARACTER_ENCODINGS[i] === pattern) {
                return Code93Reader.ALPHABET_STRING.charAt(i);
            }
        }
        throw new NotFoundException_1.default();
    };
    Code93Reader.prototype.decodeExtended = function (encoded) {
        var length = encoded.length;
        var decoded = '';
        for (var i = 0; i < length; i++) {
            var c = encoded.charAt(i);
            if (c >= 'a' && c <= 'd') {
                if (i >= length - 1) {
                    throw new FormatException_1.default();
                }
                var next = encoded.charAt(i + 1);
                var decodedChar = '\0';
                switch (c) {
                    case 'd':
                        // +A to +Z map to a to z
                        if (next >= 'A' && next <= 'Z') {
                            decodedChar = String.fromCharCode(next.charCodeAt(0) + 32);
                        }
                        else {
                            throw new FormatException_1.default();
                        }
                        break;
                    case 'a':
                        // $A to $Z map to control codes SH to SB
                        if (next >= 'A' && next <= 'Z') {
                            decodedChar = String.fromCharCode(next.charCodeAt(0) - 64);
                        }
                        else {
                            throw new FormatException_1.default();
                        }
                        break;
                    case 'b':
                        if (next >= 'A' && next <= 'E') {
                            // %A to %E map to control codes ESC to USep
                            decodedChar = String.fromCharCode(next.charCodeAt(0) - 38);
                        }
                        else if (next >= 'F' && next <= 'J') {
                            // %F to %J map to ; < = > ?
                            decodedChar = String.fromCharCode(next.charCodeAt(0) - 11);
                        }
                        else if (next >= 'K' && next <= 'O') {
                            // %K to %O map to [ \ ] ^ _
                            decodedChar = String.fromCharCode(next.charCodeAt(0) + 16);
                        }
                        else if (next >= 'P' && next <= 'T') {
                            // %P to %T map to { | } ~ DEL
                            decodedChar = String.fromCharCode(next.charCodeAt(0) + 43);
                        }
                        else if (next === 'U') {
                            // %U map to NUL
                            decodedChar = '\0';
                        }
                        else if (next === 'V') {
                            // %V map to @
                            decodedChar = '@';
                        }
                        else if (next === 'W') {
                            // %W map to `
                            decodedChar = '`';
                        }
                        else if (next >= 'X' && next <= 'Z') {
                            // %X to %Z all map to DEL (127)
                            decodedChar = String.fromCharCode(127);
                        }
                        else {
                            throw new FormatException_1.default();
                        }
                        break;
                    case 'c':
                        // /A to /O map to ! to , and /Z maps to :
                        if (next >= 'A' && next <= 'O') {
                            decodedChar = String.fromCharCode(next.charCodeAt(0) - 32);
                        }
                        else if (next === 'Z') {
                            decodedChar = ':';
                        }
                        else {
                            throw new FormatException_1.default();
                        }
                        break;
                }
                decoded += decodedChar;
                // bump up i again since we read two characters
                i++;
            }
            else {
                decoded += c;
            }
        }
        return decoded;
    };
    Code93Reader.prototype.checkChecksums = function (result) {
        var length = result.length;
        this.checkOneChecksum(result, length - 2, 20);
        this.checkOneChecksum(result, length - 1, 15);
    };
    Code93Reader.prototype.checkOneChecksum = function (result, checkPosition, weightMax) {
        var weight = 1;
        var total = 0;
        for (var i = checkPosition - 1; i >= 0; i--) {
            total += weight * Code93Reader.ALPHABET_STRING.indexOf(result.charAt(i));
            if (++weight > weightMax) {
                weight = 1;
            }
        }
        if (result.charAt(checkPosition) !== Code93Reader.ALPHABET_STRING[total % 47]) {
            throw new ChecksumException_1.default;
        }
    };
    // Note that 'abcd' are dummy characters in place of control characters.
    Code93Reader.ALPHABET_STRING = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*";
    /**
     * These represent the encodings of characters, as patterns of wide and narrow bars.
     * The 9 least-significant bits of each int correspond to the pattern of wide and narrow.
     */
    Code93Reader.CHARACTER_ENCODINGS = [
        0x114, 0x148, 0x144, 0x142, 0x128, 0x124, 0x122, 0x150, 0x112, 0x10A,
        0x1A8, 0x1A4, 0x1A2, 0x194, 0x192, 0x18A, 0x168, 0x164, 0x162, 0x134,
        0x11A, 0x158, 0x14C, 0x146, 0x12C, 0x116, 0x1B4, 0x1B2, 0x1AC, 0x1A6,
        0x196, 0x19A, 0x16C, 0x166, 0x136, 0x13A,
        0x12E, 0x1D4, 0x1D2, 0x1CA, 0x16E, 0x176, 0x1AE,
        0x126, 0x1DA, 0x1D6, 0x132, 0x15E,
    ];
    Code93Reader.ASTERISK_ENCODING = Code93Reader.CHARACTER_ENCODINGS[47];
    return Code93Reader;
}(OneDReader_1.default));
exports.default = Code93Reader;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\Code93Reader.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\EAN13Reader.js", {"../BarcodeFormat":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\BarcodeFormat.js","../NotFoundException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\NotFoundException.js","./UPCEANReader":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\UPCEANReader.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5CEAN13Reader.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2008 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
var BarcodeFormat_1 = require("../BarcodeFormat");
var UPCEANReader_1 = require("./UPCEANReader");
var NotFoundException_1 = require("../NotFoundException");
/**
 * <p>Implements decoding of the EAN-13 format.</p>
 *
 * @author dswitkin@google.com (Daniel Switkin)
 * @author Sean Owen
 * @author alasdair@google.com (Alasdair Mackintosh)
 */
var EAN13Reader = /** @class */ (function (_super) {
    __extends(EAN13Reader, _super);
    function EAN13Reader() {
        var _this = _super.call(this) || this;
        _this.decodeMiddleCounters = Int32Array.from([0, 0, 0, 0]);
        return _this;
    }
    EAN13Reader.prototype.decodeMiddle = function (row, startRange, resultString) {
        var e_1, _a, e_2, _b;
        var counters = this.decodeMiddleCounters;
        counters[0] = 0;
        counters[1] = 0;
        counters[2] = 0;
        counters[3] = 0;
        var end = row.getSize();
        var rowOffset = startRange[1];
        var lgPatternFound = 0;
        for (var x = 0; x < 6 && rowOffset < end; x++) {
            var bestMatch = UPCEANReader_1.default.decodeDigit(row, counters, rowOffset, UPCEANReader_1.default.L_AND_G_PATTERNS);
            resultString += String.fromCharCode(('0'.charCodeAt(0) + bestMatch % 10));
            try {
                for (var counters_1 = (e_1 = void 0, __values(counters)), counters_1_1 = counters_1.next(); !counters_1_1.done; counters_1_1 = counters_1.next()) {
                    var counter = counters_1_1.value;
                    rowOffset += counter;
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (counters_1_1 && !counters_1_1.done && (_a = counters_1.return)) _a.call(counters_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            if (bestMatch >= 10) {
                lgPatternFound |= 1 << (5 - x);
            }
        }
        resultString = EAN13Reader.determineFirstDigit(resultString, lgPatternFound);
        var middleRange = UPCEANReader_1.default.findGuardPattern(row, rowOffset, true, UPCEANReader_1.default.MIDDLE_PATTERN, new Int32Array(UPCEANReader_1.default.MIDDLE_PATTERN.length).fill(0));
        rowOffset = middleRange[1];
        for (var x = 0; x < 6 && rowOffset < end; x++) {
            var bestMatch = UPCEANReader_1.default.decodeDigit(row, counters, rowOffset, UPCEANReader_1.default.L_PATTERNS);
            resultString += String.fromCharCode(('0'.charCodeAt(0) + bestMatch));
            try {
                for (var counters_2 = (e_2 = void 0, __values(counters)), counters_2_1 = counters_2.next(); !counters_2_1.done; counters_2_1 = counters_2.next()) {
                    var counter = counters_2_1.value;
                    rowOffset += counter;
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (counters_2_1 && !counters_2_1.done && (_b = counters_2.return)) _b.call(counters_2);
                }
                finally { if (e_2) throw e_2.error; }
            }
        }
        return { rowOffset: rowOffset, resultString: resultString };
    };
    EAN13Reader.prototype.getBarcodeFormat = function () {
        return BarcodeFormat_1.default.EAN_13;
    };
    EAN13Reader.determineFirstDigit = function (resultString, lgPatternFound) {
        for (var d = 0; d < 10; d++) {
            if (lgPatternFound === this.FIRST_DIGIT_ENCODINGS[d]) {
                resultString = String.fromCharCode(('0'.charCodeAt(0) + d)) + resultString;
                return resultString;
            }
        }
        throw new NotFoundException_1.default();
    };
    EAN13Reader.FIRST_DIGIT_ENCODINGS = [0x00, 0x0B, 0x0D, 0xE, 0x13, 0x19, 0x1C, 0x15, 0x16, 0x1A];
    return EAN13Reader;
}(UPCEANReader_1.default));
exports.default = EAN13Reader;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\EAN13Reader.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\EAN8Reader.js", {"../BarcodeFormat":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\BarcodeFormat.js","./UPCEANReader":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\UPCEANReader.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5CEAN8Reader.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2008 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
var BarcodeFormat_1 = require("../BarcodeFormat");
var UPCEANReader_1 = require("./UPCEANReader");
/**
 * <p>Implements decoding of the EAN-8 format.</p>
 *
 * @author Sean Owen
 */
var EAN8Reader = /** @class */ (function (_super) {
    __extends(EAN8Reader, _super);
    function EAN8Reader() {
        var _this = _super.call(this) || this;
        _this.decodeMiddleCounters = Int32Array.from([0, 0, 0, 0]);
        return _this;
    }
    EAN8Reader.prototype.decodeMiddle = function (row, startRange, resultString) {
        var e_1, _a, e_2, _b;
        var counters = this.decodeMiddleCounters;
        counters[0] = 0;
        counters[1] = 0;
        counters[2] = 0;
        counters[3] = 0;
        var end = row.getSize();
        var rowOffset = startRange[1];
        for (var x = 0; x < 4 && rowOffset < end; x++) {
            var bestMatch = UPCEANReader_1.default.decodeDigit(row, counters, rowOffset, UPCEANReader_1.default.L_PATTERNS);
            resultString += String.fromCharCode(('0'.charCodeAt(0) + bestMatch));
            try {
                for (var counters_1 = (e_1 = void 0, __values(counters)), counters_1_1 = counters_1.next(); !counters_1_1.done; counters_1_1 = counters_1.next()) {
                    var counter = counters_1_1.value;
                    rowOffset += counter;
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (counters_1_1 && !counters_1_1.done && (_a = counters_1.return)) _a.call(counters_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
        }
        var middleRange = UPCEANReader_1.default.findGuardPattern(row, rowOffset, true, UPCEANReader_1.default.MIDDLE_PATTERN, new Int32Array(UPCEANReader_1.default.MIDDLE_PATTERN.length).fill(0));
        rowOffset = middleRange[1];
        for (var x = 0; x < 4 && rowOffset < end; x++) {
            var bestMatch = UPCEANReader_1.default.decodeDigit(row, counters, rowOffset, UPCEANReader_1.default.L_PATTERNS);
            resultString += String.fromCharCode(('0'.charCodeAt(0) + bestMatch));
            try {
                for (var counters_2 = (e_2 = void 0, __values(counters)), counters_2_1 = counters_2.next(); !counters_2_1.done; counters_2_1 = counters_2.next()) {
                    var counter = counters_2_1.value;
                    rowOffset += counter;
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (counters_2_1 && !counters_2_1.done && (_b = counters_2.return)) _b.call(counters_2);
                }
                finally { if (e_2) throw e_2.error; }
            }
        }
        return { rowOffset: rowOffset, resultString: resultString };
    };
    EAN8Reader.prototype.getBarcodeFormat = function () {
        return BarcodeFormat_1.default.EAN_8;
    };
    return EAN8Reader;
}(UPCEANReader_1.default));
exports.default = EAN8Reader;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\EAN8Reader.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\ITFReader.js", {"../BarcodeFormat":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\BarcodeFormat.js","../DecodeHintType":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\DecodeHintType.js","../FormatException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\FormatException.js","../NotFoundException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\NotFoundException.js","../Result":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\Result.js","../ResultPoint":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\ResultPoint.js","../util/StringBuilder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\StringBuilder.js","../util/System":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\System.js","./OneDReader":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\OneDReader.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5CITFReader.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2008 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
/*namespace com.google.zxing.oned {*/
var BarcodeFormat_1 = require("../BarcodeFormat");
var DecodeHintType_1 = require("../DecodeHintType");
var FormatException_1 = require("../FormatException");
var NotFoundException_1 = require("../NotFoundException");
var Result_1 = require("../Result");
var ResultPoint_1 = require("../ResultPoint");
var StringBuilder_1 = require("../util/StringBuilder");
var System_1 = require("../util/System");
var OneDReader_1 = require("./OneDReader");
/**
 * <p>Decodes ITF barcodes.</p>
 *
 * @author Tjieco
 */
var ITFReader = /** @class */ (function (_super) {
    __extends(ITFReader, _super);
    function ITFReader() {
        // private static W = 3; // Pixel width of a 3x wide line
        // private static w = 2; // Pixel width of a 2x wide line
        // private static N = 1; // Pixed width of a narrow line
        var _this = _super !== null && _super.apply(this, arguments) || this;
        // Stores the actual narrow line width of the image being decoded.
        _this.narrowLineWidth = -1;
        return _this;
    }
    // See ITFWriter.PATTERNS
    /*
  
    /!**
     * Patterns of Wide / Narrow lines to indicate each digit
     *!/
    */
    ITFReader.prototype.decodeRow = function (rowNumber, row, hints) {
        var e_1, _a;
        // Find out where the Middle section (payload) starts & ends
        var startRange = this.decodeStart(row);
        var endRange = this.decodeEnd(row);
        var result = new StringBuilder_1.default();
        ITFReader.decodeMiddle(row, startRange[1], endRange[0], result);
        var resultString = result.toString();
        var allowedLengths = null;
        if (hints != null) {
            allowedLengths = hints.get(DecodeHintType_1.default.ALLOWED_LENGTHS);
        }
        if (allowedLengths == null) {
            allowedLengths = ITFReader.DEFAULT_ALLOWED_LENGTHS;
        }
        // To avoid false positives with 2D barcodes (and other patterns), make
        // an assumption that the decoded string must be a 'standard' length if it's short
        var length = resultString.length;
        var lengthOK = false;
        var maxAllowedLength = 0;
        try {
            for (var allowedLengths_1 = __values(allowedLengths), allowedLengths_1_1 = allowedLengths_1.next(); !allowedLengths_1_1.done; allowedLengths_1_1 = allowedLengths_1.next()) {
                var value = allowedLengths_1_1.value;
                if (length === value) {
                    lengthOK = true;
                    break;
                }
                if (value > maxAllowedLength) {
                    maxAllowedLength = value;
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (allowedLengths_1_1 && !allowedLengths_1_1.done && (_a = allowedLengths_1.return)) _a.call(allowedLengths_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        if (!lengthOK && length > maxAllowedLength) {
            lengthOK = true;
        }
        if (!lengthOK) {
            throw new FormatException_1.default();
        }
        var points = [new ResultPoint_1.default(startRange[1], rowNumber), new ResultPoint_1.default(endRange[0], rowNumber)];
        var resultReturn = new Result_1.default(resultString, null, // no natural byte representation for these barcodes
        0, points, BarcodeFormat_1.default.ITF, new Date().getTime());
        return resultReturn;
    };
    /*
    /!**
     * @param row          row of black/white values to search
     * @param payloadStart offset of start pattern
     * @param resultString {@link StringBuilder} to append decoded chars to
     * @throws NotFoundException if decoding could not complete successfully
     *!/*/
    ITFReader.decodeMiddle = function (row, payloadStart, payloadEnd, resultString) {
        // Digits are interleaved in pairs - 5 black lines for one digit, and the
        // 5
        // interleaved white lines for the second digit.
        // Therefore, need to scan 10 lines and then
        // split these into two arrays
        var counterDigitPair = new Int32Array(10); // 10
        var counterBlack = new Int32Array(5); // 5
        var counterWhite = new Int32Array(5); // 5
        counterDigitPair.fill(0);
        counterBlack.fill(0);
        counterWhite.fill(0);
        while (payloadStart < payloadEnd) {
            // Get 10 runs of black/white.
            OneDReader_1.default.recordPattern(row, payloadStart, counterDigitPair);
            // Split them into each array
            for (var k = 0; k < 5; k++) {
                var twoK = 2 * k;
                counterBlack[k] = counterDigitPair[twoK];
                counterWhite[k] = counterDigitPair[twoK + 1];
            }
            var bestMatch = ITFReader.decodeDigit(counterBlack);
            resultString.append(bestMatch.toString());
            bestMatch = this.decodeDigit(counterWhite);
            resultString.append(bestMatch.toString());
            counterDigitPair.forEach(function (counterDigit) {
                payloadStart += counterDigit;
            });
        }
    };
    /*/!**
     * Identify where the start of the middle / payload section starts.
     *
     * @param row row of black/white values to search
     * @return Array, containing index of start of 'start block' and end of
     *         'start block'
     *!/*/
    ITFReader.prototype.decodeStart = function (row) {
        var endStart = ITFReader.skipWhiteSpace(row);
        var startPattern = ITFReader.findGuardPattern(row, endStart, ITFReader.START_PATTERN);
        // Determine the width of a narrow line in pixels. We can do this by
        // getting the width of the start pattern and dividing by 4 because its
        // made up of 4 narrow lines.
        this.narrowLineWidth = (startPattern[1] - startPattern[0]) / 4;
        this.validateQuietZone(row, startPattern[0]);
        return startPattern;
    };
    /*/!**
     * The start & end patterns must be pre/post fixed by a quiet zone. This
     * zone must be at least 10 times the width of a narrow line.  Scan back until
     * we either get to the start of the barcode or match the necessary number of
     * quiet zone pixels.
     *
     * Note: Its assumed the row is reversed when using this method to find
     * quiet zone after the end pattern.
     *
     * ref: http://www.barcode-1.net/i25code.html
     *
     * @param row bit array representing the scanned barcode.
     * @param startPattern index into row of the start or end pattern.
     * @throws NotFoundException if the quiet zone cannot be found
     *!/*/
    ITFReader.prototype.validateQuietZone = function (row, startPattern) {
        var quietCount = this.narrowLineWidth * 10; // expect to find this many pixels of quiet zone
        // if there are not so many pixel at all let's try as many as possible
        quietCount = quietCount < startPattern ? quietCount : startPattern;
        for (var i = startPattern - 1; quietCount > 0 && i >= 0; i--) {
            if (row.get(i)) {
                break;
            }
            quietCount--;
        }
        if (quietCount !== 0) {
            // Unable to find the necessary number of quiet zone pixels.
            throw new NotFoundException_1.default();
        }
    };
    /*
    /!**
     * Skip all whitespace until we get to the first black line.
     *
     * @param row row of black/white values to search
     * @return index of the first black line.
     * @throws NotFoundException Throws exception if no black lines are found in the row
     *!/*/
    ITFReader.skipWhiteSpace = function (row) {
        var width = row.getSize();
        var endStart = row.getNextSet(0);
        if (endStart === width) {
            throw new NotFoundException_1.default();
        }
        return endStart;
    };
    /*/!**
     * Identify where the end of the middle / payload section ends.
     *
     * @param row row of black/white values to search
     * @return Array, containing index of start of 'end block' and end of 'end
     *         block'
     *!/*/
    ITFReader.prototype.decodeEnd = function (row) {
        // For convenience, reverse the row and then
        // search from 'the start' for the end block
        row.reverse();
        try {
            var endStart = ITFReader.skipWhiteSpace(row);
            var endPattern = void 0;
            try {
                endPattern = ITFReader.findGuardPattern(row, endStart, ITFReader.END_PATTERN_REVERSED[0]);
            }
            catch (error) {
                if (error instanceof NotFoundException_1.default) {
                    endPattern = ITFReader.findGuardPattern(row, endStart, ITFReader.END_PATTERN_REVERSED[1]);
                }
            }
            // The start & end patterns must be pre/post fixed by a quiet zone. This
            // zone must be at least 10 times the width of a narrow line.
            // ref: http://www.barcode-1.net/i25code.html
            this.validateQuietZone(row, endPattern[0]);
            // Now recalculate the indices of where the 'endblock' starts & stops to
            // accommodate
            // the reversed nature of the search
            var temp = endPattern[0];
            endPattern[0] = row.getSize() - endPattern[1];
            endPattern[1] = row.getSize() - temp;
            return endPattern;
        }
        finally {
            // Put the row back the right way.
            row.reverse();
        }
    };
    /*
    /!**
     * @param row       row of black/white values to search
     * @param rowOffset position to start search
     * @param pattern   pattern of counts of number of black and white pixels that are
     *                  being searched for as a pattern
     * @return start/end horizontal offset of guard pattern, as an array of two
     *         ints
     * @throws NotFoundException if pattern is not found
     *!/*/
    ITFReader.findGuardPattern = function (row, rowOffset, pattern) {
        var patternLength = pattern.length;
        var counters = new Int32Array(patternLength);
        var width = row.getSize();
        var isWhite = false;
        var counterPosition = 0;
        var patternStart = rowOffset;
        counters.fill(0);
        for (var x = rowOffset; x < width; x++) {
            if (row.get(x) !== isWhite) {
                counters[counterPosition]++;
            }
            else {
                if (counterPosition === patternLength - 1) {
                    if (OneDReader_1.default.patternMatchVariance(counters, pattern, ITFReader.MAX_INDIVIDUAL_VARIANCE) < ITFReader.MAX_AVG_VARIANCE) {
                        return [patternStart, x];
                    }
                    patternStart += counters[0] + counters[1];
                    System_1.default.arraycopy(counters, 2, counters, 0, counterPosition - 1);
                    counters[counterPosition - 1] = 0;
                    counters[counterPosition] = 0;
                    counterPosition--;
                }
                else {
                    counterPosition++;
                }
                counters[counterPosition] = 1;
                isWhite = !isWhite;
            }
        }
        throw new NotFoundException_1.default();
    };
    /*/!**
     * Attempts to decode a sequence of ITF black/white lines into single
     * digit.
     *
     * @param counters the counts of runs of observed black/white/black/... values
     * @return The decoded digit
     * @throws NotFoundException if digit cannot be decoded
     *!/*/
    ITFReader.decodeDigit = function (counters) {
        var bestVariance = ITFReader.MAX_AVG_VARIANCE; // worst variance we'll accept
        var bestMatch = -1;
        var max = ITFReader.PATTERNS.length;
        for (var i = 0; i < max; i++) {
            var pattern = ITFReader.PATTERNS[i];
            var variance = OneDReader_1.default.patternMatchVariance(counters, pattern, ITFReader.MAX_INDIVIDUAL_VARIANCE);
            if (variance < bestVariance) {
                bestVariance = variance;
                bestMatch = i;
            }
            else if (variance === bestVariance) {
                // if we find a second 'best match' with the same variance, we can not reliably report to have a suitable match
                bestMatch = -1;
            }
        }
        if (bestMatch >= 0) {
            return bestMatch % 10;
        }
        else {
            throw new NotFoundException_1.default();
        }
    };
    ITFReader.PATTERNS = [
        Int32Array.from([1, 1, 2, 2, 1]),
        Int32Array.from([2, 1, 1, 1, 2]),
        Int32Array.from([1, 2, 1, 1, 2]),
        Int32Array.from([2, 2, 1, 1, 1]),
        Int32Array.from([1, 1, 2, 1, 2]),
        Int32Array.from([2, 1, 2, 1, 1]),
        Int32Array.from([1, 2, 2, 1, 1]),
        Int32Array.from([1, 1, 1, 2, 2]),
        Int32Array.from([2, 1, 1, 2, 1]),
        Int32Array.from([1, 2, 1, 2, 1]),
        Int32Array.from([1, 1, 3, 3, 1]),
        Int32Array.from([3, 1, 1, 1, 3]),
        Int32Array.from([1, 3, 1, 1, 3]),
        Int32Array.from([3, 3, 1, 1, 1]),
        Int32Array.from([1, 1, 3, 1, 3]),
        Int32Array.from([3, 1, 3, 1, 1]),
        Int32Array.from([1, 3, 3, 1, 1]),
        Int32Array.from([1, 1, 1, 3, 3]),
        Int32Array.from([3, 1, 1, 3, 1]),
        Int32Array.from([1, 3, 1, 3, 1]) // 9
    ];
    ITFReader.MAX_AVG_VARIANCE = 0.38;
    ITFReader.MAX_INDIVIDUAL_VARIANCE = 0.5;
    /* /!** Valid ITF lengths. Anything longer than the largest value is also allowed. *!/*/
    ITFReader.DEFAULT_ALLOWED_LENGTHS = [6, 8, 10, 12, 14];
    /*/!**
     * Start/end guard pattern.
     *
     * Note: The end pattern is reversed because the row is reversed before
     * searching for the END_PATTERN
     *!/*/
    ITFReader.START_PATTERN = Int32Array.from([1, 1, 1, 1]);
    ITFReader.END_PATTERN_REVERSED = [
        Int32Array.from([1, 1, 2]),
        Int32Array.from([1, 1, 3]) // 3x
    ];
    return ITFReader;
}(OneDReader_1.default));
exports.default = ITFReader;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\ITFReader.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\MultiFormatOneDReader.js", {"../BarcodeFormat":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\BarcodeFormat.js","../DecodeHintType":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\DecodeHintType.js","../NotFoundException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\NotFoundException.js","./CodaBarReader":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\CodaBarReader.js","./Code128Reader":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\Code128Reader.js","./Code39Reader":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\Code39Reader.js","./Code93Reader":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\Code93Reader.js","./ITFReader":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\ITFReader.js","./MultiFormatUPCEANReader":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\MultiFormatUPCEANReader.js","./OneDReader":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\OneDReader.js","./rss/RSS14Reader":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\RSS14Reader.js","./rss/expanded/RSSExpandedReader":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\RSSExpandedReader.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5CMultiFormatOneDReader.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2008 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
/*namespace com.google.zxing.oned {*/
var BarcodeFormat_1 = require("../BarcodeFormat");
var DecodeHintType_1 = require("../DecodeHintType");
var NotFoundException_1 = require("../NotFoundException");
var Code128Reader_1 = require("./Code128Reader");
var Code39Reader_1 = require("./Code39Reader");
var Code93Reader_1 = require("./Code93Reader");
var ITFReader_1 = require("./ITFReader");
var MultiFormatUPCEANReader_1 = require("./MultiFormatUPCEANReader");
var OneDReader_1 = require("./OneDReader");
var CodaBarReader_1 = require("./CodaBarReader");
var RSSExpandedReader_1 = require("./rss/expanded/RSSExpandedReader");
var RSS14Reader_1 = require("./rss/RSS14Reader");
/**
 * @author Daniel Switkin <dswitkin@google.com>
 * @author Sean Owen
 */
var MultiFormatOneDReader = /** @class */ (function (_super) {
    __extends(MultiFormatOneDReader, _super);
    function MultiFormatOneDReader(hints) {
        var _this = _super.call(this) || this;
        _this.readers = [];
        var possibleFormats = !hints ? null : hints.get(DecodeHintType_1.default.POSSIBLE_FORMATS);
        var useCode39CheckDigit = hints && hints.get(DecodeHintType_1.default.ASSUME_CODE_39_CHECK_DIGIT) !== undefined;
        var useCode39ExtendedMode = hints && hints.get(DecodeHintType_1.default.ENABLE_CODE_39_EXTENDED_MODE) !== undefined;
        if (possibleFormats) {
            if (possibleFormats.includes(BarcodeFormat_1.default.EAN_13) ||
                possibleFormats.includes(BarcodeFormat_1.default.UPC_A) ||
                possibleFormats.includes(BarcodeFormat_1.default.EAN_8) ||
                possibleFormats.includes(BarcodeFormat_1.default.UPC_E)) {
                _this.readers.push(new MultiFormatUPCEANReader_1.default(hints));
            }
            if (possibleFormats.includes(BarcodeFormat_1.default.CODE_39)) {
                _this.readers.push(new Code39Reader_1.default(useCode39CheckDigit, useCode39ExtendedMode));
            }
            if (possibleFormats.includes(BarcodeFormat_1.default.CODE_93)) {
                _this.readers.push(new Code93Reader_1.default());
            }
            if (possibleFormats.includes(BarcodeFormat_1.default.CODE_128)) {
                _this.readers.push(new Code128Reader_1.default());
            }
            if (possibleFormats.includes(BarcodeFormat_1.default.ITF)) {
                _this.readers.push(new ITFReader_1.default());
            }
            if (possibleFormats.includes(BarcodeFormat_1.default.CODABAR)) {
                _this.readers.push(new CodaBarReader_1.default());
            }
            if (possibleFormats.includes(BarcodeFormat_1.default.RSS_14)) {
                _this.readers.push(new RSS14Reader_1.default());
            }
            if (possibleFormats.includes(BarcodeFormat_1.default.RSS_EXPANDED)) {
                console.warn('RSS Expanded reader IS NOT ready for production yet! use at your own risk.');
                _this.readers.push(new RSSExpandedReader_1.default());
            }
        }
        if (_this.readers.length === 0) {
            _this.readers.push(new MultiFormatUPCEANReader_1.default(hints));
            _this.readers.push(new Code39Reader_1.default());
            // this.readers.push(new CodaBarReader());
            _this.readers.push(new Code93Reader_1.default());
            _this.readers.push(new MultiFormatUPCEANReader_1.default(hints));
            _this.readers.push(new Code128Reader_1.default());
            _this.readers.push(new ITFReader_1.default());
            _this.readers.push(new RSS14Reader_1.default());
            // this.readers.push(new RSSExpandedReader());
        }
        return _this;
    }
    // @Override
    MultiFormatOneDReader.prototype.decodeRow = function (rowNumber, row, hints) {
        for (var i = 0; i < this.readers.length; i++) {
            try {
                return this.readers[i].decodeRow(rowNumber, row, hints);
            }
            catch (re) {
                // continue
            }
        }
        throw new NotFoundException_1.default();
    };
    // @Override
    MultiFormatOneDReader.prototype.reset = function () {
        this.readers.forEach(function (reader) { return reader.reset(); });
    };
    return MultiFormatOneDReader;
}(OneDReader_1.default));
exports.default = MultiFormatOneDReader;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\MultiFormatOneDReader.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\MultiFormatUPCEANReader.js", {"../BarcodeFormat":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\BarcodeFormat.js","../DecodeHintType":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\DecodeHintType.js","../NotFoundException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\NotFoundException.js","../Result":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\Result.js","./EAN13Reader":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\EAN13Reader.js","./EAN8Reader":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\EAN8Reader.js","./OneDReader":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\OneDReader.js","./UPCAReader":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\UPCAReader.js","./UPCEReader":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\UPCEReader.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5CMultiFormatUPCEANReader.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2008 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
var BarcodeFormat_1 = require("../BarcodeFormat");
var DecodeHintType_1 = require("../DecodeHintType");
var Result_1 = require("../Result");
var OneDReader_1 = require("./OneDReader");
var EAN13Reader_1 = require("./EAN13Reader");
var EAN8Reader_1 = require("./EAN8Reader");
var UPCAReader_1 = require("./UPCAReader");
var NotFoundException_1 = require("../NotFoundException");
var UPCEReader_1 = require("./UPCEReader");
/**
 * <p>A reader that can read all available UPC/EAN formats. If a caller wants to try to
 * read all such formats, it is most efficient to use this implementation rather than invoke
 * individual readers.</p>
 *
 * @author Sean Owen
 */
var MultiFormatUPCEANReader = /** @class */ (function (_super) {
    __extends(MultiFormatUPCEANReader, _super);
    function MultiFormatUPCEANReader(hints) {
        var _this = _super.call(this) || this;
        var possibleFormats = hints == null ? null : hints.get(DecodeHintType_1.default.POSSIBLE_FORMATS);
        var readers = [];
        if (possibleFormats != null) {
            if (possibleFormats.indexOf(BarcodeFormat_1.default.EAN_13) > -1) {
                readers.push(new EAN13Reader_1.default());
            }
            if (possibleFormats.indexOf(BarcodeFormat_1.default.UPC_A) > -1) {
                readers.push(new UPCAReader_1.default());
            }
            if (possibleFormats.indexOf(BarcodeFormat_1.default.EAN_8) > -1) {
                readers.push(new EAN8Reader_1.default());
            }
            if (possibleFormats.indexOf(BarcodeFormat_1.default.UPC_E) > -1) {
                readers.push(new UPCEReader_1.default());
            }
        }
        if (readers.length === 0) {
            readers.push(new EAN13Reader_1.default());
            readers.push(new UPCAReader_1.default());
            readers.push(new EAN8Reader_1.default());
            readers.push(new UPCEReader_1.default());
        }
        _this.readers = readers;
        return _this;
    }
    MultiFormatUPCEANReader.prototype.decodeRow = function (rowNumber, row, hints) {
        var e_1, _a;
        try {
            for (var _b = __values(this.readers), _c = _b.next(); !_c.done; _c = _b.next()) {
                var reader = _c.value;
                try {
                    // const result: Result = reader.decodeRow(rowNumber, row, startGuardPattern, hints);
                    var result = reader.decodeRow(rowNumber, row, hints);
                    // Special case: a 12-digit code encoded in UPC-A is identical to a "0"
                    // followed by those 12 digits encoded as EAN-13. Each will recognize such a code,
                    // UPC-A as a 12-digit string and EAN-13 as a 13-digit string starting with "0".
                    // Individually these are correct and their readers will both read such a code
                    // and correctly call it EAN-13, or UPC-A, respectively.
                    //
                    // In this case, if we've been looking for both types, we'd like to call it
                    // a UPC-A code. But for efficiency we only run the EAN-13 decoder to also read
                    // UPC-A. So we special case it here, and convert an EAN-13 result to a UPC-A
                    // result if appropriate.
                    //
                    // But, don't return UPC-A if UPC-A was not a requested format!
                    var ean13MayBeUPCA = result.getBarcodeFormat() === BarcodeFormat_1.default.EAN_13 &&
                        result.getText().charAt(0) === '0';
                    // @SuppressWarnings("unchecked")
                    var possibleFormats = hints == null ? null : hints.get(DecodeHintType_1.default.POSSIBLE_FORMATS);
                    var canReturnUPCA = possibleFormats == null || possibleFormats.includes(BarcodeFormat_1.default.UPC_A);
                    if (ean13MayBeUPCA && canReturnUPCA) {
                        var rawBytes = result.getRawBytes();
                        // Transfer the metadata across
                        var resultUPCA = new Result_1.default(result.getText().substring(1), rawBytes, (rawBytes ? rawBytes.length : null), result.getResultPoints(), BarcodeFormat_1.default.UPC_A);
                        resultUPCA.putAllMetadata(result.getResultMetadata());
                        return resultUPCA;
                    }
                    return result;
                }
                catch (err) {
                    // continue;
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        throw new NotFoundException_1.default();
    };
    MultiFormatUPCEANReader.prototype.reset = function () {
        var e_2, _a;
        try {
            for (var _b = __values(this.readers), _c = _b.next(); !_c.done; _c = _b.next()) {
                var reader = _c.value;
                reader.reset();
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
    };
    return MultiFormatUPCEANReader;
}(OneDReader_1.default));
exports.default = MultiFormatUPCEANReader;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\MultiFormatUPCEANReader.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\OneDReader.js", {"../DecodeHintType":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\DecodeHintType.js","../NotFoundException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\NotFoundException.js","../ResultMetadataType":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\ResultMetadataType.js","../ResultPoint":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\ResultPoint.js","../common/BitArray":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\BitArray.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5COneDReader.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2008 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
var BitArray_1 = require("../common/BitArray");
var DecodeHintType_1 = require("../DecodeHintType");
var ResultMetadataType_1 = require("../ResultMetadataType");
var ResultPoint_1 = require("../ResultPoint");
var NotFoundException_1 = require("../NotFoundException");
/**
 * Encapsulates functionality and implementation that is common to all families
 * of one-dimensional barcodes.
 *
 * @author dswitkin@google.com (Daniel Switkin)
 * @author Sean Owen
 */
var OneDReader = /** @class */ (function () {
    function OneDReader() {
    }
    /*
    @Override
    public Result decode(BinaryBitmap image) throws NotFoundException, FormatException {
      return decode(image, null);
    }
    */
    // Note that we don't try rotation without the try harder flag, even if rotation was supported.
    // @Override
    OneDReader.prototype.decode = function (image, hints) {
        try {
            return this.doDecode(image, hints);
        }
        catch (nfe) {
            var tryHarder = hints && (hints.get(DecodeHintType_1.default.TRY_HARDER) === true);
            if (tryHarder && image.isRotateSupported()) {
                var rotatedImage = image.rotateCounterClockwise();
                var result = this.doDecode(rotatedImage, hints);
                // Record that we found it rotated 90 degrees CCW / 270 degrees CW
                var metadata = result.getResultMetadata();
                var orientation_1 = 270;
                if (metadata !== null && (metadata.get(ResultMetadataType_1.default.ORIENTATION) === true)) {
                    // But if we found it reversed in doDecode(), add in that result here:
                    orientation_1 = (orientation_1 + metadata.get(ResultMetadataType_1.default.ORIENTATION) % 360);
                }
                result.putMetadata(ResultMetadataType_1.default.ORIENTATION, orientation_1);
                // Update result points
                var points = result.getResultPoints();
                if (points !== null) {
                    var height = rotatedImage.getHeight();
                    for (var i = 0; i < points.length; i++) {
                        points[i] = new ResultPoint_1.default(height - points[i].getY() - 1, points[i].getX());
                    }
                }
                return result;
            }
            else {
                throw new NotFoundException_1.default();
            }
        }
    };
    // @Override
    OneDReader.prototype.reset = function () {
        // do nothing
    };
    /**
     * We're going to examine rows from the middle outward, searching alternately above and below the
     * middle, and farther out each time. rowStep is the number of rows between each successive
     * attempt above and below the middle. So we'd scan row middle, then middle - rowStep, then
     * middle + rowStep, then middle - (2 * rowStep), etc.
     * rowStep is bigger as the image is taller, but is always at least 1. We've somewhat arbitrarily
     * decided that moving up and down by about 1/16 of the image is pretty good; we try more of the
     * image if "trying harder".
     *
     * @param image The image to decode
     * @param hints Any hints that were requested
     * @return The contents of the decoded barcode
     * @throws NotFoundException Any spontaneous errors which occur
     */
    OneDReader.prototype.doDecode = function (image, hints) {
        var width = image.getWidth();
        var height = image.getHeight();
        var row = new BitArray_1.default(width);
        var tryHarder = hints && (hints.get(DecodeHintType_1.default.TRY_HARDER) === true);
        var rowStep = Math.max(1, height >> (tryHarder ? 8 : 5));
        var maxLines;
        if (tryHarder) {
            maxLines = height; // Look at the whole image, not just the center
        }
        else {
            maxLines = 15; // 15 rows spaced 1/32 apart is roughly the middle half of the image
        }
        var middle = Math.trunc(height / 2);
        for (var x = 0; x < maxLines; x++) {
            // Scanning from the middle out. Determine which row we're looking at next:
            var rowStepsAboveOrBelow = Math.trunc((x + 1) / 2);
            var isAbove = (x & 0x01) === 0; // i.e. is x even?
            var rowNumber = middle + rowStep * (isAbove ? rowStepsAboveOrBelow : -rowStepsAboveOrBelow);
            if (rowNumber < 0 || rowNumber >= height) {
                // Oops, if we run off the top or bottom, stop
                break;
            }
            // Estimate black point for this row and load it:
            try {
                row = image.getBlackRow(rowNumber, row);
            }
            catch (ignored) {
                continue;
            }
            var _loop_1 = function (attempt) {
                if (attempt === 1) { // trying again?
                    row.reverse(); // reverse the row and continue
                    // This means we will only ever draw result points *once* in the life of this method
                    // since we want to avoid drawing the wrong points after flipping the row, and,
                    // don't want to clutter with noise from every single row scan -- just the scans
                    // that start on the center line.
                    if (hints && (hints.get(DecodeHintType_1.default.NEED_RESULT_POINT_CALLBACK) === true)) {
                        var newHints_1 = new Map();
                        hints.forEach(function (hint, key) { return newHints_1.set(key, hint); });
                        newHints_1.delete(DecodeHintType_1.default.NEED_RESULT_POINT_CALLBACK);
                        hints = newHints_1;
                    }
                }
                try {
                    // Look for a barcode
                    var result = this_1.decodeRow(rowNumber, row, hints);
                    // We found our barcode
                    if (attempt === 1) {
                        // But it was upside down, so note that
                        result.putMetadata(ResultMetadataType_1.default.ORIENTATION, 180);
                        // And remember to flip the result points horizontally.
                        var points = result.getResultPoints();
                        if (points !== null) {
                            points[0] = new ResultPoint_1.default(width - points[0].getX() - 1, points[0].getY());
                            points[1] = new ResultPoint_1.default(width - points[1].getX() - 1, points[1].getY());
                        }
                    }
                    return { value: result };
                }
                catch (re) {
                    // continue -- just couldn't decode this row
                }
            };
            var this_1 = this;
            // While we have the image data in a BitArray, it's fairly cheap to reverse it in place to
            // handle decoding upside down barcodes.
            for (var attempt = 0; attempt < 2; attempt++) {
                var state_1 = _loop_1(attempt);
                if (typeof state_1 === "object")
                    return state_1.value;
            }
        }
        throw new NotFoundException_1.default();
    };
    /**
     * Records the size of successive runs of white and black pixels in a row, starting at a given point.
     * The values are recorded in the given array, and the number of runs recorded is equal to the size
     * of the array. If the row starts on a white pixel at the given start point, then the first count
     * recorded is the run of white pixels starting from that point; likewise it is the count of a run
     * of black pixels if the row begin on a black pixels at that point.
     *
     * @param row row to count from
     * @param start offset into row to start at
     * @param counters array into which to record counts
     * @throws NotFoundException if counters cannot be filled entirely from row before running out
     *  of pixels
     */
    OneDReader.recordPattern = function (row, start, counters) {
        var numCounters = counters.length;
        for (var index = 0; index < numCounters; index++)
            counters[index] = 0;
        var end = row.getSize();
        if (start >= end) {
            throw new NotFoundException_1.default();
        }
        var isWhite = !row.get(start);
        var counterPosition = 0;
        var i = start;
        while (i < end) {
            if (row.get(i) !== isWhite) {
                counters[counterPosition]++;
            }
            else {
                if (++counterPosition === numCounters) {
                    break;
                }
                else {
                    counters[counterPosition] = 1;
                    isWhite = !isWhite;
                }
            }
            i++;
        }
        // If we read fully the last section of pixels and filled up our counters -- or filled
        // the last counter but ran off the side of the image, OK. Otherwise, a problem.
        if (!(counterPosition === numCounters || (counterPosition === numCounters - 1 && i === end))) {
            throw new NotFoundException_1.default();
        }
    };
    OneDReader.recordPatternInReverse = function (row, start, counters) {
        // This could be more efficient I guess
        var numTransitionsLeft = counters.length;
        var last = row.get(start);
        while (start > 0 && numTransitionsLeft >= 0) {
            if (row.get(--start) !== last) {
                numTransitionsLeft--;
                last = !last;
            }
        }
        if (numTransitionsLeft >= 0) {
            throw new NotFoundException_1.default();
        }
        OneDReader.recordPattern(row, start + 1, counters);
    };
    /**
     * Determines how closely a set of observed counts of runs of black/white values matches a given
     * target pattern. This is reported as the ratio of the total variance from the expected pattern
     * proportions across all pattern elements, to the length of the pattern.
     *
     * @param counters observed counters
     * @param pattern expected pattern
     * @param maxIndividualVariance The most any counter can differ before we give up
     * @return ratio of total variance between counters and pattern compared to total pattern size
     */
    OneDReader.patternMatchVariance = function (counters, pattern, maxIndividualVariance) {
        var numCounters = counters.length;
        var total = 0;
        var patternLength = 0;
        for (var i = 0; i < numCounters; i++) {
            total += counters[i];
            patternLength += pattern[i];
        }
        if (total < patternLength) {
            // If we don't even have one pixel per unit of bar width, assume this is too small
            // to reliably match, so fail:
            return Number.POSITIVE_INFINITY;
        }
        var unitBarWidth = total / patternLength;
        maxIndividualVariance *= unitBarWidth;
        var totalVariance = 0.0;
        for (var x = 0; x < numCounters; x++) {
            var counter = counters[x];
            var scaledPattern = pattern[x] * unitBarWidth;
            var variance = counter > scaledPattern ? counter - scaledPattern : scaledPattern - counter;
            if (variance > maxIndividualVariance) {
                return Number.POSITIVE_INFINITY;
            }
            totalVariance += variance;
        }
        return totalVariance / total;
    };
    return OneDReader;
}());
exports.default = OneDReader;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\OneDReader.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\UPCAReader.js", {"../BarcodeFormat":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\BarcodeFormat.js","../NotFoundException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\NotFoundException.js","../Result":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\Result.js","./EAN13Reader":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\EAN13Reader.js","./UPCEANReader":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\UPCEANReader.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5CUPCAReader.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2008 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
/*namespace com.google.zxing.oned {*/
var BarcodeFormat_1 = require("../BarcodeFormat");
var Result_1 = require("../Result");
var NotFoundException_1 = require("../NotFoundException");
var EAN13Reader_1 = require("./EAN13Reader");
var UPCEANReader_1 = require("./UPCEANReader");
/**
 * Encapsulates functionality and implementation that is common to all families
 * of one-dimensional barcodes.
 *
 * @author dswitkin@google.com (Daniel Switkin)
 * @author Sean Owen
 * @author sam2332 (Sam Rudloff)
 *
 * @source https://github.com/zxing/zxing/blob/3c96923276dd5785d58eb970b6ba3f80d36a9505/core/src/main/java/com/google/zxing/oned/UPCAReader.java
 *
 * @experimental
 */
var UPCAReader = /** @class */ (function (_super) {
    __extends(UPCAReader, _super);
    function UPCAReader() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.ean13Reader = new EAN13Reader_1.default();
        return _this;
    }
    // @Override
    UPCAReader.prototype.getBarcodeFormat = function () {
        return BarcodeFormat_1.default.UPC_A;
    };
    // Note that we don't try rotation without the try harder flag, even if rotation was supported.
    // @Override
    UPCAReader.prototype.decode = function (image, hints) {
        return this.maybeReturnResult(this.ean13Reader.decode(image));
    };
    // @Override
    UPCAReader.prototype.decodeRow = function (rowNumber, row, hints) {
        return this.maybeReturnResult(this.ean13Reader.decodeRow(rowNumber, row, hints));
    };
    // @Override
    UPCAReader.prototype.decodeMiddle = function (row, startRange, resultString) {
        return this.ean13Reader.decodeMiddle(row, startRange, resultString);
    };
    UPCAReader.prototype.maybeReturnResult = function (result) {
        var text = result.getText();
        if (text.charAt(0) === '0') {
            var upcaResult = new Result_1.default(text.substring(1), null, null, result.getResultPoints(), BarcodeFormat_1.default.UPC_A);
            if (result.getResultMetadata() != null) {
                upcaResult.putAllMetadata(result.getResultMetadata());
            }
            return upcaResult;
        }
        else {
            throw new NotFoundException_1.default();
        }
    };
    UPCAReader.prototype.reset = function () {
        this.ean13Reader.reset();
    };
    return UPCAReader;
}(UPCEANReader_1.default));
exports.default = UPCAReader;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\UPCAReader.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\UPCEANExtension2Support.js", {"../BarcodeFormat":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\BarcodeFormat.js","../NotFoundException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\NotFoundException.js","../Result":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\Result.js","../ResultMetadataType":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\ResultMetadataType.js","../ResultPoint":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\ResultPoint.js","./AbstractUPCEANReader":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\AbstractUPCEANReader.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5CUPCEANExtension2Support.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright (C) 2012 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
var BarcodeFormat_1 = require("../BarcodeFormat");
var AbstractUPCEANReader_1 = require("./AbstractUPCEANReader");
var Result_1 = require("../Result");
var ResultPoint_1 = require("../ResultPoint");
var ResultMetadataType_1 = require("../ResultMetadataType");
var NotFoundException_1 = require("../NotFoundException");
/**
 * @see UPCEANExtension5Support
 */
var UPCEANExtension2Support = /** @class */ (function () {
    function UPCEANExtension2Support() {
        this.decodeMiddleCounters = Int32Array.from([0, 0, 0, 0]);
        this.decodeRowStringBuffer = '';
    }
    UPCEANExtension2Support.prototype.decodeRow = function (rowNumber, row, extensionStartRange) {
        var result = this.decodeRowStringBuffer;
        var end = this.decodeMiddle(row, extensionStartRange, result);
        var resultString = result.toString();
        var extensionData = UPCEANExtension2Support.parseExtensionString(resultString);
        var resultPoints = [
            new ResultPoint_1.default((extensionStartRange[0] + extensionStartRange[1]) / 2.0, rowNumber),
            new ResultPoint_1.default(end, rowNumber)
        ];
        var extensionResult = new Result_1.default(resultString, null, 0, resultPoints, BarcodeFormat_1.default.UPC_EAN_EXTENSION, new Date().getTime());
        if (extensionData != null) {
            extensionResult.putAllMetadata(extensionData);
        }
        return extensionResult;
    };
    UPCEANExtension2Support.prototype.decodeMiddle = function (row, startRange, resultString) {
        var e_1, _a;
        var counters = this.decodeMiddleCounters;
        counters[0] = 0;
        counters[1] = 0;
        counters[2] = 0;
        counters[3] = 0;
        var end = row.getSize();
        var rowOffset = startRange[1];
        var checkParity = 0;
        for (var x = 0; x < 2 && rowOffset < end; x++) {
            var bestMatch = AbstractUPCEANReader_1.default.decodeDigit(row, counters, rowOffset, AbstractUPCEANReader_1.default.L_AND_G_PATTERNS);
            resultString += String.fromCharCode(('0'.charCodeAt(0) + bestMatch % 10));
            try {
                for (var counters_1 = (e_1 = void 0, __values(counters)), counters_1_1 = counters_1.next(); !counters_1_1.done; counters_1_1 = counters_1.next()) {
                    var counter = counters_1_1.value;
                    rowOffset += counter;
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (counters_1_1 && !counters_1_1.done && (_a = counters_1.return)) _a.call(counters_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            if (bestMatch >= 10) {
                checkParity |= 1 << (1 - x);
            }
            if (x !== 1) {
                // Read off separator if not last
                rowOffset = row.getNextSet(rowOffset);
                rowOffset = row.getNextUnset(rowOffset);
            }
        }
        if (resultString.length !== 2) {
            throw new NotFoundException_1.default();
        }
        if (parseInt(resultString.toString()) % 4 !== checkParity) {
            throw new NotFoundException_1.default();
        }
        return rowOffset;
    };
    UPCEANExtension2Support.parseExtensionString = function (raw) {
        if (raw.length !== 2) {
            return null;
        }
        return new Map([[ResultMetadataType_1.default.ISSUE_NUMBER, parseInt(raw)]]);
    };
    return UPCEANExtension2Support;
}());
exports.default = UPCEANExtension2Support;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\UPCEANExtension2Support.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\UPCEANExtension5Support.js", {"../BarcodeFormat":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\BarcodeFormat.js","../NotFoundException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\NotFoundException.js","../Result":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\Result.js","../ResultMetadataType":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\ResultMetadataType.js","../ResultPoint":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\ResultPoint.js","./AbstractUPCEANReader":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\AbstractUPCEANReader.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5CUPCEANExtension5Support.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright (C) 2010 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
var BarcodeFormat_1 = require("../BarcodeFormat");
// import UPCEANReader from './UPCEANReader';
var AbstractUPCEANReader_1 = require("./AbstractUPCEANReader");
var Result_1 = require("../Result");
var ResultPoint_1 = require("../ResultPoint");
var ResultMetadataType_1 = require("../ResultMetadataType");
var NotFoundException_1 = require("../NotFoundException");
/**
 * @see UPCEANExtension2Support
 */
var UPCEANExtension5Support = /** @class */ (function () {
    function UPCEANExtension5Support() {
        this.CHECK_DIGIT_ENCODINGS = [0x18, 0x14, 0x12, 0x11, 0x0C, 0x06, 0x03, 0x0A, 0x09, 0x05];
        this.decodeMiddleCounters = Int32Array.from([0, 0, 0, 0]);
        this.decodeRowStringBuffer = '';
    }
    UPCEANExtension5Support.prototype.decodeRow = function (rowNumber, row, extensionStartRange) {
        var result = this.decodeRowStringBuffer;
        var end = this.decodeMiddle(row, extensionStartRange, result);
        var resultString = result.toString();
        var extensionData = UPCEANExtension5Support.parseExtensionString(resultString);
        var resultPoints = [
            new ResultPoint_1.default((extensionStartRange[0] + extensionStartRange[1]) / 2.0, rowNumber),
            new ResultPoint_1.default(end, rowNumber)
        ];
        var extensionResult = new Result_1.default(resultString, null, 0, resultPoints, BarcodeFormat_1.default.UPC_EAN_EXTENSION, new Date().getTime());
        if (extensionData != null) {
            extensionResult.putAllMetadata(extensionData);
        }
        return extensionResult;
    };
    UPCEANExtension5Support.prototype.decodeMiddle = function (row, startRange, resultString) {
        var e_1, _a;
        var counters = this.decodeMiddleCounters;
        counters[0] = 0;
        counters[1] = 0;
        counters[2] = 0;
        counters[3] = 0;
        var end = row.getSize();
        var rowOffset = startRange[1];
        var lgPatternFound = 0;
        for (var x = 0; x < 5 && rowOffset < end; x++) {
            var bestMatch = AbstractUPCEANReader_1.default.decodeDigit(row, counters, rowOffset, AbstractUPCEANReader_1.default.L_AND_G_PATTERNS);
            resultString += String.fromCharCode(('0'.charCodeAt(0) + bestMatch % 10));
            try {
                for (var counters_1 = (e_1 = void 0, __values(counters)), counters_1_1 = counters_1.next(); !counters_1_1.done; counters_1_1 = counters_1.next()) {
                    var counter = counters_1_1.value;
                    rowOffset += counter;
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (counters_1_1 && !counters_1_1.done && (_a = counters_1.return)) _a.call(counters_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            if (bestMatch >= 10) {
                lgPatternFound |= 1 << (4 - x);
            }
            if (x !== 4) {
                // Read off separator if not last
                rowOffset = row.getNextSet(rowOffset);
                rowOffset = row.getNextUnset(rowOffset);
            }
        }
        if (resultString.length !== 5) {
            throw new NotFoundException_1.default();
        }
        var checkDigit = this.determineCheckDigit(lgPatternFound);
        if (UPCEANExtension5Support.extensionChecksum(resultString.toString()) !== checkDigit) {
            throw new NotFoundException_1.default();
        }
        return rowOffset;
    };
    UPCEANExtension5Support.extensionChecksum = function (s) {
        var length = s.length;
        var sum = 0;
        for (var i = length - 2; i >= 0; i -= 2) {
            sum += s.charAt(i).charCodeAt(0) - '0'.charCodeAt(0);
        }
        sum *= 3;
        for (var i = length - 1; i >= 0; i -= 2) {
            sum += s.charAt(i).charCodeAt(0) - '0'.charCodeAt(0);
        }
        sum *= 3;
        return sum % 10;
    };
    UPCEANExtension5Support.prototype.determineCheckDigit = function (lgPatternFound) {
        for (var d = 0; d < 10; d++) {
            if (lgPatternFound === this.CHECK_DIGIT_ENCODINGS[d]) {
                return d;
            }
        }
        throw new NotFoundException_1.default();
    };
    UPCEANExtension5Support.parseExtensionString = function (raw) {
        if (raw.length !== 5) {
            return null;
        }
        var value = UPCEANExtension5Support.parseExtension5String(raw);
        if (value == null) {
            return null;
        }
        return new Map([[ResultMetadataType_1.default.SUGGESTED_PRICE, value]]);
    };
    UPCEANExtension5Support.parseExtension5String = function (raw) {
        var currency;
        switch (raw.charAt(0)) {
            case '0':
                currency = '£';
                break;
            case '5':
                currency = '$';
                break;
            case '9':
                // Reference: http://www.jollytech.com
                switch (raw) {
                    case '90000':
                        // No suggested retail price
                        return null;
                    case '99991':
                        // Complementary
                        return '0.00';
                    case '99990':
                        return 'Used';
                }
                // Otherwise... unknown currency?
                currency = '';
                break;
            default:
                currency = '';
                break;
        }
        var rawAmount = parseInt(raw.substring(1));
        var unitsString = (rawAmount / 100).toString();
        var hundredths = rawAmount % 100;
        var hundredthsString = hundredths < 10 ? '0' + hundredths : hundredths.toString(); // fixme
        return currency + unitsString + '.' + hundredthsString;
    };
    return UPCEANExtension5Support;
}());
exports.default = UPCEANExtension5Support;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\UPCEANExtension5Support.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\UPCEANExtensionSupport.js", {"./AbstractUPCEANReader":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\AbstractUPCEANReader.js","./UPCEANExtension2Support":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\UPCEANExtension2Support.js","./UPCEANExtension5Support":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\UPCEANExtension5Support.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5CUPCEANExtensionSupport.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright (C) 2010 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
var AbstractUPCEANReader_1 = require("./AbstractUPCEANReader");
var UPCEANExtension5Support_1 = require("./UPCEANExtension5Support");
var UPCEANExtension2Support_1 = require("./UPCEANExtension2Support");
var UPCEANExtensionSupport = /** @class */ (function () {
    function UPCEANExtensionSupport() {
    }
    UPCEANExtensionSupport.decodeRow = function (rowNumber, row, rowOffset) {
        var extensionStartRange = AbstractUPCEANReader_1.default.findGuardPattern(row, rowOffset, false, this.EXTENSION_START_PATTERN, new Int32Array(this.EXTENSION_START_PATTERN.length).fill(0));
        try {
            // return null;
            var fiveSupport = new UPCEANExtension5Support_1.default();
            return fiveSupport.decodeRow(rowNumber, row, extensionStartRange);
        }
        catch (err) {
            // return null;
            var twoSupport = new UPCEANExtension2Support_1.default();
            return twoSupport.decodeRow(rowNumber, row, extensionStartRange);
        }
    };
    UPCEANExtensionSupport.EXTENSION_START_PATTERN = Int32Array.from([1, 1, 2]);
    return UPCEANExtensionSupport;
}());
exports.default = UPCEANExtensionSupport;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\UPCEANExtensionSupport.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\UPCEANReader.js", {"../BarcodeFormat":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\BarcodeFormat.js","../ChecksumException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\ChecksumException.js","../DecodeHintType":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\DecodeHintType.js","../FormatException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\FormatException.js","../NotFoundException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\NotFoundException.js","../Result":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\Result.js","../ResultMetadataType":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\ResultMetadataType.js","../ResultPoint":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\ResultPoint.js","./AbstractUPCEANReader":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\AbstractUPCEANReader.js","./UPCEANExtensionSupport":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\UPCEANExtensionSupport.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5CUPCEANReader.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2008 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var BarcodeFormat_1 = require("../BarcodeFormat");
var DecodeHintType_1 = require("../DecodeHintType");
var Result_1 = require("../Result");
var ResultMetadataType_1 = require("../ResultMetadataType");
var ResultPoint_1 = require("../ResultPoint");
var UPCEANExtensionSupport_1 = require("./UPCEANExtensionSupport");
var AbstractUPCEANReader_1 = require("./AbstractUPCEANReader");
var NotFoundException_1 = require("../NotFoundException");
var FormatException_1 = require("../FormatException");
var ChecksumException_1 = require("../ChecksumException");
/**
 * <p>Encapsulates functionality and implementation that is common to UPC and EAN families
 * of one-dimensional barcodes.</p>
 *
 * @author dswitkin@google.com (Daniel Switkin)
 * @author Sean Owen
 * @author alasdair@google.com (Alasdair Mackintosh)
 */
var UPCEANReader = /** @class */ (function (_super) {
    __extends(UPCEANReader, _super);
    function UPCEANReader() {
        var _this = _super.call(this) || this;
        _this.decodeRowStringBuffer = '';
        UPCEANReader.L_AND_G_PATTERNS = UPCEANReader.L_PATTERNS.map(function (arr) { return Int32Array.from(arr); });
        for (var i = 10; i < 20; i++) {
            var widths = UPCEANReader.L_PATTERNS[i - 10];
            var reversedWidths = new Int32Array(widths.length);
            for (var j = 0; j < widths.length; j++) {
                reversedWidths[j] = widths[widths.length - j - 1];
            }
            UPCEANReader.L_AND_G_PATTERNS[i] = reversedWidths;
        }
        return _this;
    }
    UPCEANReader.prototype.decodeRow = function (rowNumber, row, hints) {
        var startGuardRange = UPCEANReader.findStartGuardPattern(row);
        var resultPointCallback = hints == null ? null : hints.get(DecodeHintType_1.default.NEED_RESULT_POINT_CALLBACK);
        if (resultPointCallback != null) {
            var resultPoint_1 = new ResultPoint_1.default((startGuardRange[0] + startGuardRange[1]) / 2.0, rowNumber);
            resultPointCallback.foundPossibleResultPoint(resultPoint_1);
        }
        var budello = this.decodeMiddle(row, startGuardRange, this.decodeRowStringBuffer);
        var endStart = budello.rowOffset;
        var result = budello.resultString;
        if (resultPointCallback != null) {
            var resultPoint_2 = new ResultPoint_1.default(endStart, rowNumber);
            resultPointCallback.foundPossibleResultPoint(resultPoint_2);
        }
        var endRange = UPCEANReader.decodeEnd(row, endStart);
        if (resultPointCallback != null) {
            var resultPoint_3 = new ResultPoint_1.default((endRange[0] + endRange[1]) / 2.0, rowNumber);
            resultPointCallback.foundPossibleResultPoint(resultPoint_3);
        }
        // Make sure there is a quiet zone at least as big as the end pattern after the barcode. The
        // spec might want more whitespace, but in practice this is the maximum we can count on.
        var end = endRange[1];
        var quietEnd = end + (end - endRange[0]);
        if (quietEnd >= row.getSize() || !row.isRange(end, quietEnd, false)) {
            throw new NotFoundException_1.default();
        }
        var resultString = result.toString();
        // UPC/EAN should never be less than 8 chars anyway
        if (resultString.length < 8) {
            throw new FormatException_1.default();
        }
        if (!UPCEANReader.checkChecksum(resultString)) {
            throw new ChecksumException_1.default();
        }
        var left = (startGuardRange[1] + startGuardRange[0]) / 2.0;
        var right = (endRange[1] + endRange[0]) / 2.0;
        var format = this.getBarcodeFormat();
        var resultPoint = [new ResultPoint_1.default(left, rowNumber), new ResultPoint_1.default(right, rowNumber)];
        var decodeResult = new Result_1.default(resultString, null, 0, resultPoint, format, new Date().getTime());
        var extensionLength = 0;
        try {
            var extensionResult = UPCEANExtensionSupport_1.default.decodeRow(rowNumber, row, endRange[1]);
            decodeResult.putMetadata(ResultMetadataType_1.default.UPC_EAN_EXTENSION, extensionResult.getText());
            decodeResult.putAllMetadata(extensionResult.getResultMetadata());
            decodeResult.addResultPoints(extensionResult.getResultPoints());
            extensionLength = extensionResult.getText().length;
        }
        catch (err) {
        }
        var allowedExtensions = hints == null ? null : hints.get(DecodeHintType_1.default.ALLOWED_EAN_EXTENSIONS);
        if (allowedExtensions != null) {
            var valid = false;
            for (var length_1 in allowedExtensions) {
                if (extensionLength.toString() === length_1) { // check me
                    valid = true;
                    break;
                }
            }
            if (!valid) {
                throw new NotFoundException_1.default();
            }
        }
        if (format === BarcodeFormat_1.default.EAN_13 || format === BarcodeFormat_1.default.UPC_A) {
            // let countryID = eanManSupport.lookupContryIdentifier(resultString); todo
            // if (countryID != null) {
            //     decodeResult.putMetadata(ResultMetadataType.POSSIBLE_COUNTRY, countryID);
            // }
        }
        return decodeResult;
    };
    UPCEANReader.checkChecksum = function (s) {
        return UPCEANReader.checkStandardUPCEANChecksum(s);
    };
    UPCEANReader.checkStandardUPCEANChecksum = function (s) {
        var length = s.length;
        if (length === 0)
            return false;
        var check = parseInt(s.charAt(length - 1), 10);
        return UPCEANReader.getStandardUPCEANChecksum(s.substring(0, length - 1)) === check;
    };
    UPCEANReader.getStandardUPCEANChecksum = function (s) {
        var length = s.length;
        var sum = 0;
        for (var i = length - 1; i >= 0; i -= 2) {
            var digit = s.charAt(i).charCodeAt(0) - '0'.charCodeAt(0);
            if (digit < 0 || digit > 9) {
                throw new FormatException_1.default();
            }
            sum += digit;
        }
        sum *= 3;
        for (var i = length - 2; i >= 0; i -= 2) {
            var digit = s.charAt(i).charCodeAt(0) - '0'.charCodeAt(0);
            if (digit < 0 || digit > 9) {
                throw new FormatException_1.default();
            }
            sum += digit;
        }
        return (1000 - sum) % 10;
    };
    UPCEANReader.decodeEnd = function (row, endStart) {
        return UPCEANReader.findGuardPattern(row, endStart, false, UPCEANReader.START_END_PATTERN, new Int32Array(UPCEANReader.START_END_PATTERN.length).fill(0));
    };
    return UPCEANReader;
}(AbstractUPCEANReader_1.default));
exports.default = UPCEANReader;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\UPCEANReader.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\UPCEReader.js", {"../BarcodeFormat":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\BarcodeFormat.js","../NotFoundException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\NotFoundException.js","../util/StringBuilder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\StringBuilder.js","./UPCEANReader":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\UPCEANReader.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5CUPCEReader.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2008 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
var UPCEANReader_1 = require("./UPCEANReader");
var StringBuilder_1 = require("../util/StringBuilder");
var NotFoundException_1 = require("../NotFoundException");
var BarcodeFormat_1 = require("../BarcodeFormat");
// package com.google.zxing.oned;
// import com.google.zxing.BarcodeFormat;
// import com.google.zxing.FormatException;
// import com.google.zxing.NotFoundException;
// import com.google.zxing.common.BitArray;
/**
 * <p>Implements decoding of the UPC-E format.</p>
 * <p><a href="http://www.barcodeisland.com/upce.phtml">This</a> is a great reference for
 * UPC-E information.</p>
 *
 * @author Sean Owen
 *
 * @source https://github.com/zxing/zxing/blob/3c96923276dd5785d58eb970b6ba3f80d36a9505/core/src/main/java/com/google/zxing/oned/UPCEReader.java
 *
 * @experimental
 */
var UPCEReader = /** @class */ (function (_super) {
    __extends(UPCEReader, _super);
    function UPCEReader() {
        var _this = _super.call(this) || this;
        _this.decodeMiddleCounters = new Int32Array(4);
        return _this;
    }
    /**
     * @throws NotFoundException
     */
    // @Override
    UPCEReader.prototype.decodeMiddle = function (row, startRange, result) {
        var e_1, _a;
        var counters = this.decodeMiddleCounters.map(function (x) { return x; });
        counters[0] = 0;
        counters[1] = 0;
        counters[2] = 0;
        counters[3] = 0;
        var end = row.getSize();
        var rowOffset = startRange[1];
        var lgPatternFound = 0;
        for (var x = 0; x < 6 && rowOffset < end; x++) {
            var bestMatch = UPCEReader.decodeDigit(row, counters, rowOffset, UPCEReader.L_AND_G_PATTERNS);
            result += String.fromCharCode(('0'.charCodeAt(0) + bestMatch % 10));
            try {
                for (var counters_1 = (e_1 = void 0, __values(counters)), counters_1_1 = counters_1.next(); !counters_1_1.done; counters_1_1 = counters_1.next()) {
                    var counter = counters_1_1.value;
                    rowOffset += counter;
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (counters_1_1 && !counters_1_1.done && (_a = counters_1.return)) _a.call(counters_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            if (bestMatch >= 10) {
                lgPatternFound |= 1 << (5 - x);
            }
        }
        UPCEReader.determineNumSysAndCheckDigit(new StringBuilder_1.default(result), lgPatternFound);
        return rowOffset;
    };
    /**
     * @throws NotFoundException
     */
    // @Override
    UPCEReader.prototype.decodeEnd = function (row, endStart) {
        return UPCEReader.findGuardPatternWithoutCounters(row, endStart, true, UPCEReader.MIDDLE_END_PATTERN);
    };
    /**
     * @throws FormatException
     */
    // @Override
    UPCEReader.prototype.checkChecksum = function (s) {
        return UPCEANReader_1.default.checkChecksum(UPCEReader.convertUPCEtoUPCA(s));
    };
    /**
     * @throws NotFoundException
     */
    UPCEReader.determineNumSysAndCheckDigit = function (resultString, lgPatternFound) {
        for (var numSys = 0; numSys <= 1; numSys++) {
            for (var d = 0; d < 10; d++) {
                if (lgPatternFound === this.NUMSYS_AND_CHECK_DIGIT_PATTERNS[numSys][d]) {
                    resultString.insert(0, /*(char)*/ ('0' + numSys));
                    resultString.append(/*(char)*/ ('0' + d));
                    return;
                }
            }
        }
        throw NotFoundException_1.default.getNotFoundInstance();
    };
    // @Override
    UPCEReader.prototype.getBarcodeFormat = function () {
        return BarcodeFormat_1.default.UPC_E;
    };
    /**
     * Expands a UPC-E value back into its full, equivalent UPC-A code value.
     *
     * @param upce UPC-E code as string of digits
     * @return equivalent UPC-A code as string of digits
     */
    UPCEReader.convertUPCEtoUPCA = function (upce) {
        // the following line is equivalent to upce.getChars(1, 7, upceChars, 0);
        var upceChars = upce.slice(1, 7).split('').map(function (x) { return x.charCodeAt(0); });
        var result = new StringBuilder_1.default( /*12*/);
        result.append(upce.charAt(0));
        var lastChar = upceChars[5];
        switch (lastChar) {
            case 0:
            case 1:
            case 2:
                result.appendChars(upceChars, 0, 2);
                result.append(lastChar);
                result.append('0000');
                result.appendChars(upceChars, 2, 3);
                break;
            case 3:
                result.appendChars(upceChars, 0, 3);
                result.append('00000');
                result.appendChars(upceChars, 3, 2);
                break;
            case 4:
                result.appendChars(upceChars, 0, 4);
                result.append('00000');
                result.append(upceChars[4]);
                break;
            default:
                result.appendChars(upceChars, 0, 5);
                result.append('0000');
                result.append(lastChar);
                break;
        }
        // Only append check digit in conversion if supplied
        if (upce.length >= 8) {
            result.append(upce.charAt(7));
        }
        return result.toString();
    };
    /**
     * The pattern that marks the middle, and end, of a UPC-E pattern.
     * There is no "second half" to a UPC-E barcode.
     */
    UPCEReader.MIDDLE_END_PATTERN = Int32Array.from([1, 1, 1, 1, 1, 1]);
    // For an UPC-E barcode, the final digit is represented by the parities used
    // to encode the middle six digits, according to the table below.
    //
    //                Parity of next 6 digits
    //    Digit   0     1     2     3     4     5
    //       0    Even   Even  Even Odd  Odd   Odd
    //       1    Even   Even  Odd  Even Odd   Odd
    //       2    Even   Even  Odd  Odd  Even  Odd
    //       3    Even   Even  Odd  Odd  Odd   Even
    //       4    Even   Odd   Even Even Odd   Odd
    //       5    Even   Odd   Odd  Even Even  Odd
    //       6    Even   Odd   Odd  Odd  Even  Even
    //       7    Even   Odd   Even Odd  Even  Odd
    //       8    Even   Odd   Even Odd  Odd   Even
    //       9    Even   Odd   Odd  Even Odd   Even
    //
    // The encoding is represented by the following array, which is a bit pattern
    // using Odd = 0 and Even = 1. For example, 5 is represented by:
    //
    //              Odd Even Even Odd Odd Even
    // in binary:
    //                0    1    1   0   0    1   == 0x19
    //
    /**
     * See {@link #L_AND_G_PATTERNS}; these values similarly represent patterns of
     * even-odd parity encodings of digits that imply both the number system (0 or 1)
     * used, and the check digit.
     */
    UPCEReader.NUMSYS_AND_CHECK_DIGIT_PATTERNS = [
        Int32Array.from([0x38, 0x34, 0x32, 0x31, 0x2C, 0x26, 0x23, 0x2A, 0x29, 0x25]),
        Int32Array.from([0x07, 0x0B, 0x0D, 0x0E, 0x13, 0x19, 0x1C, 0x15, 0x16, 0x1]),
    ];
    return UPCEReader;
}(UPCEANReader_1.default));
exports.default = UPCEReader;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\UPCEReader.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\AbstractRSSReader.js", {"../../NotFoundException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\NotFoundException.js","../../common/detector/MathUtils":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\detector\\MathUtils.js","../OneDReader":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\OneDReader.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5Crss%5CAbstractRSSReader.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
var MathUtils_1 = require("../../common/detector/MathUtils");
var NotFoundException_1 = require("../../NotFoundException");
var OneDReader_1 = require("../OneDReader");
// import Integer from '../../util/Integer';
// import Float from '../../util/Float';
var AbstractRSSReader = /** @class */ (function (_super) {
    __extends(AbstractRSSReader, _super);
    function AbstractRSSReader() {
        var _this = _super.call(this) || this;
        _this.decodeFinderCounters = new Int32Array(4);
        _this.dataCharacterCounters = new Int32Array(8);
        _this.oddRoundingErrors = new Array(4);
        _this.evenRoundingErrors = new Array(4);
        _this.oddCounts = new Array(_this.dataCharacterCounters.length / 2);
        _this.evenCounts = new Array(_this.dataCharacterCounters.length / 2);
        return _this;
    }
    AbstractRSSReader.prototype.getDecodeFinderCounters = function () {
        return this.decodeFinderCounters;
    };
    AbstractRSSReader.prototype.getDataCharacterCounters = function () {
        return this.dataCharacterCounters;
    };
    AbstractRSSReader.prototype.getOddRoundingErrors = function () {
        return this.oddRoundingErrors;
    };
    AbstractRSSReader.prototype.getEvenRoundingErrors = function () {
        return this.evenRoundingErrors;
    };
    AbstractRSSReader.prototype.getOddCounts = function () {
        return this.oddCounts;
    };
    AbstractRSSReader.prototype.getEvenCounts = function () {
        return this.evenCounts;
    };
    AbstractRSSReader.prototype.parseFinderValue = function (counters, finderPatterns) {
        for (var value = 0; value < finderPatterns.length; value++) {
            if (OneDReader_1.default.patternMatchVariance(counters, finderPatterns[value], AbstractRSSReader.MAX_INDIVIDUAL_VARIANCE) < AbstractRSSReader.MAX_AVG_VARIANCE) {
                return value;
            }
        }
        throw new NotFoundException_1.default();
    };
    /**
     * @param array values to sum
     * @return sum of values
     * @deprecated call {@link MathUtils#sum(int[])}
     */
    AbstractRSSReader.count = function (array) {
        return MathUtils_1.default.sum(new Int32Array(array));
    };
    AbstractRSSReader.increment = function (array, errors) {
        var index = 0;
        var biggestError = errors[0];
        for (var i = 1; i < array.length; i++) {
            if (errors[i] > biggestError) {
                biggestError = errors[i];
                index = i;
            }
        }
        array[index]++;
    };
    AbstractRSSReader.decrement = function (array, errors) {
        var index = 0;
        var biggestError = errors[0];
        for (var i = 1; i < array.length; i++) {
            if (errors[i] < biggestError) {
                biggestError = errors[i];
                index = i;
            }
        }
        array[index]--;
    };
    AbstractRSSReader.isFinderPattern = function (counters) {
        var e_1, _a;
        var firstTwoSum = counters[0] + counters[1];
        var sum = firstTwoSum + counters[2] + counters[3];
        var ratio = firstTwoSum / sum;
        if (ratio >= AbstractRSSReader.MIN_FINDER_PATTERN_RATIO && ratio <= AbstractRSSReader.MAX_FINDER_PATTERN_RATIO) {
            // passes ratio test in spec, but see if the counts are unreasonable
            var minCounter = Number.MAX_SAFE_INTEGER;
            var maxCounter = Number.MIN_SAFE_INTEGER;
            try {
                for (var counters_1 = __values(counters), counters_1_1 = counters_1.next(); !counters_1_1.done; counters_1_1 = counters_1.next()) {
                    var counter = counters_1_1.value;
                    if (counter > maxCounter) {
                        maxCounter = counter;
                    }
                    if (counter < minCounter) {
                        minCounter = counter;
                    }
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (counters_1_1 && !counters_1_1.done && (_a = counters_1.return)) _a.call(counters_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            return maxCounter < 10 * minCounter;
        }
        return false;
    };
    AbstractRSSReader.MAX_AVG_VARIANCE = 0.2;
    AbstractRSSReader.MAX_INDIVIDUAL_VARIANCE = 0.45;
    AbstractRSSReader.MIN_FINDER_PATTERN_RATIO = 9.5 / 12.0;
    AbstractRSSReader.MAX_FINDER_PATTERN_RATIO = 12.5 / 14.0;
    return AbstractRSSReader;
}(OneDReader_1.default));
exports.default = AbstractRSSReader;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\AbstractRSSReader.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\DataCharacter.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5Crss%5CDataCharacter.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var DataCharacter = /** @class */ (function () {
    function DataCharacter(value, checksumPortion) {
        this.value = value;
        this.checksumPortion = checksumPortion;
    }
    DataCharacter.prototype.getValue = function () {
        return this.value;
    };
    DataCharacter.prototype.getChecksumPortion = function () {
        return this.checksumPortion;
    };
    DataCharacter.prototype.toString = function () {
        return this.value + '(' + this.checksumPortion + ')';
    };
    DataCharacter.prototype.equals = function (o) {
        if (!(o instanceof DataCharacter)) {
            return false;
        }
        var that = o;
        return this.value === that.value && this.checksumPortion === that.checksumPortion;
    };
    DataCharacter.prototype.hashCode = function () {
        return this.value ^ this.checksumPortion;
    };
    return DataCharacter;
}());
exports.default = DataCharacter;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\DataCharacter.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\FinderPattern.js", {"../../ResultPoint":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\ResultPoint.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5Crss%5CFinderPattern.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ResultPoint_1 = require("../../ResultPoint");
var FinderPattern = /** @class */ (function () {
    function FinderPattern(value, startEnd, start, end, rowNumber) {
        this.value = value;
        this.startEnd = startEnd;
        this.value = value;
        this.startEnd = startEnd;
        this.resultPoints = new Array();
        this.resultPoints.push(new ResultPoint_1.default(start, rowNumber));
        this.resultPoints.push(new ResultPoint_1.default(end, rowNumber));
    }
    FinderPattern.prototype.getValue = function () {
        return this.value;
    };
    FinderPattern.prototype.getStartEnd = function () {
        return this.startEnd;
    };
    FinderPattern.prototype.getResultPoints = function () {
        return this.resultPoints;
    };
    FinderPattern.prototype.equals = function (o) {
        if (!(o instanceof FinderPattern)) {
            return false;
        }
        var that = o;
        return this.value === that.value;
    };
    FinderPattern.prototype.hashCode = function () {
        return this.value;
    };
    return FinderPattern;
}());
exports.default = FinderPattern;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\FinderPattern.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\Pair.js", {"./DataCharacter":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\DataCharacter.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5Crss%5CPair.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var DataCharacter_1 = require("./DataCharacter");
var Pair = /** @class */ (function (_super) {
    __extends(Pair, _super);
    function Pair(value, checksumPortion, finderPattern) {
        var _this = _super.call(this, value, checksumPortion) || this;
        _this.count = 0;
        _this.finderPattern = finderPattern;
        return _this;
    }
    Pair.prototype.getFinderPattern = function () {
        return this.finderPattern;
    };
    Pair.prototype.getCount = function () {
        return this.count;
    };
    Pair.prototype.incrementCount = function () {
        this.count++;
    };
    return Pair;
}(DataCharacter_1.default));
exports.default = Pair;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\Pair.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\RSS14Reader.js", {"../../BarcodeFormat":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\BarcodeFormat.js","../../DecodeHintType":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\DecodeHintType.js","../../NotFoundException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\NotFoundException.js","../../Result":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\Result.js","../../ResultPoint":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\ResultPoint.js","../../common/detector/MathUtils":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\detector\\MathUtils.js","../../util/StringBuilder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\StringBuilder.js","../../util/System":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\System.js","../OneDReader":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\OneDReader.js","./AbstractRSSReader":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\AbstractRSSReader.js","./DataCharacter":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\DataCharacter.js","./FinderPattern":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\FinderPattern.js","./Pair":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\Pair.js","./RSSUtils":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\RSSUtils.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5Crss%5CRSS14Reader.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
var AbstractRSSReader_1 = require("./AbstractRSSReader");
var Pair_1 = require("./Pair");
var Result_1 = require("../../Result");
var DecodeHintType_1 = require("../../DecodeHintType");
var NotFoundException_1 = require("../../NotFoundException");
var StringBuilder_1 = require("../../util/StringBuilder");
var BarcodeFormat_1 = require("../../BarcodeFormat");
var ResultPoint_1 = require("../../ResultPoint");
var FinderPattern_1 = require("./FinderPattern");
var DataCharacter_1 = require("./DataCharacter");
var MathUtils_1 = require("../../common/detector/MathUtils");
var RSSUtils_1 = require("./RSSUtils");
var System_1 = require("../../util/System");
var OneDReader_1 = require("../OneDReader");
var RSS14Reader = /** @class */ (function (_super) {
    __extends(RSS14Reader, _super);
    function RSS14Reader() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.possibleLeftPairs = [];
        _this.possibleRightPairs = [];
        return _this;
    }
    RSS14Reader.prototype.decodeRow = function (rowNumber, row, hints) {
        var e_1, _a, e_2, _b;
        var leftPair = this.decodePair(row, false, rowNumber, hints);
        RSS14Reader.addOrTally(this.possibleLeftPairs, leftPair);
        row.reverse();
        var rightPair = this.decodePair(row, true, rowNumber, hints);
        RSS14Reader.addOrTally(this.possibleRightPairs, rightPair);
        row.reverse();
        try {
            for (var _c = __values(this.possibleLeftPairs), _d = _c.next(); !_d.done; _d = _c.next()) {
                var left = _d.value;
                if (left.getCount() > 1) {
                    try {
                        for (var _e = (e_2 = void 0, __values(this.possibleRightPairs)), _f = _e.next(); !_f.done; _f = _e.next()) {
                            var right = _f.value;
                            if (right.getCount() > 1 && RSS14Reader.checkChecksum(left, right)) {
                                return RSS14Reader.constructResult(left, right);
                            }
                        }
                    }
                    catch (e_2_1) { e_2 = { error: e_2_1 }; }
                    finally {
                        try {
                            if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
                        }
                        finally { if (e_2) throw e_2.error; }
                    }
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
            }
            finally { if (e_1) throw e_1.error; }
        }
        throw new NotFoundException_1.default();
    };
    RSS14Reader.addOrTally = function (possiblePairs, pair) {
        var e_3, _a;
        if (pair == null) {
            return;
        }
        var found = false;
        try {
            for (var possiblePairs_1 = __values(possiblePairs), possiblePairs_1_1 = possiblePairs_1.next(); !possiblePairs_1_1.done; possiblePairs_1_1 = possiblePairs_1.next()) {
                var other = possiblePairs_1_1.value;
                if (other.getValue() === pair.getValue()) {
                    other.incrementCount();
                    found = true;
                    break;
                }
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (possiblePairs_1_1 && !possiblePairs_1_1.done && (_a = possiblePairs_1.return)) _a.call(possiblePairs_1);
            }
            finally { if (e_3) throw e_3.error; }
        }
        if (!found) {
            possiblePairs.push(pair);
        }
    };
    RSS14Reader.prototype.reset = function () {
        this.possibleLeftPairs.length = 0;
        this.possibleRightPairs.length = 0;
    };
    RSS14Reader.constructResult = function (leftPair, rightPair) {
        var symbolValue = 4537077 * leftPair.getValue() + rightPair.getValue();
        var text = new String(symbolValue).toString();
        var buffer = new StringBuilder_1.default();
        for (var i = 13 - text.length; i > 0; i--) {
            buffer.append('0');
        }
        buffer.append(text);
        var checkDigit = 0;
        for (var i = 0; i < 13; i++) {
            var digit = buffer.charAt(i).charCodeAt(0) - '0'.charCodeAt(0);
            checkDigit += ((i & 0x01) === 0) ? 3 * digit : digit;
        }
        checkDigit = 10 - (checkDigit % 10);
        if (checkDigit === 10) {
            checkDigit = 0;
        }
        buffer.append(checkDigit.toString());
        var leftPoints = leftPair.getFinderPattern().getResultPoints();
        var rightPoints = rightPair.getFinderPattern().getResultPoints();
        return new Result_1.default(buffer.toString(), null, 0, [leftPoints[0], leftPoints[1], rightPoints[0], rightPoints[1]], BarcodeFormat_1.default.RSS_14, new Date().getTime());
    };
    RSS14Reader.checkChecksum = function (leftPair, rightPair) {
        var checkValue = (leftPair.getChecksumPortion() + 16 * rightPair.getChecksumPortion()) % 79;
        var targetCheckValue = 9 * leftPair.getFinderPattern().getValue() + rightPair.getFinderPattern().getValue();
        if (targetCheckValue > 72) {
            targetCheckValue--;
        }
        if (targetCheckValue > 8) {
            targetCheckValue--;
        }
        return checkValue === targetCheckValue;
    };
    RSS14Reader.prototype.decodePair = function (row, right, rowNumber, hints) {
        try {
            var startEnd = this.findFinderPattern(row, right);
            var pattern = this.parseFoundFinderPattern(row, rowNumber, right, startEnd);
            var resultPointCallback = hints == null ? null : hints.get(DecodeHintType_1.default.NEED_RESULT_POINT_CALLBACK);
            if (resultPointCallback != null) {
                var center = (startEnd[0] + startEnd[1]) / 2.0;
                if (right) {
                    // row is actually reversed
                    center = row.getSize() - 1 - center;
                }
                resultPointCallback.foundPossibleResultPoint(new ResultPoint_1.default(center, rowNumber));
            }
            var outside = this.decodeDataCharacter(row, pattern, true);
            var inside = this.decodeDataCharacter(row, pattern, false);
            return new Pair_1.default(1597 * outside.getValue() + inside.getValue(), outside.getChecksumPortion() + 4 * inside.getChecksumPortion(), pattern);
        }
        catch (err) {
            return null;
        }
    };
    RSS14Reader.prototype.decodeDataCharacter = function (row, pattern, outsideChar) {
        var counters = this.getDataCharacterCounters();
        for (var x = 0; x < counters.length; x++) {
            counters[x] = 0;
        }
        if (outsideChar) {
            OneDReader_1.default.recordPatternInReverse(row, pattern.getStartEnd()[0], counters);
        }
        else {
            OneDReader_1.default.recordPattern(row, pattern.getStartEnd()[1] + 1, counters);
            // reverse it
            for (var i = 0, j = counters.length - 1; i < j; i++, j--) {
                var temp = counters[i];
                counters[i] = counters[j];
                counters[j] = temp;
            }
        }
        var numModules = outsideChar ? 16 : 15;
        var elementWidth = MathUtils_1.default.sum(new Int32Array(counters)) / numModules;
        var oddCounts = this.getOddCounts();
        var evenCounts = this.getEvenCounts();
        var oddRoundingErrors = this.getOddRoundingErrors();
        var evenRoundingErrors = this.getEvenRoundingErrors();
        for (var i = 0; i < counters.length; i++) {
            var value = counters[i] / elementWidth;
            var count = Math.floor(value + 0.5);
            if (count < 1) {
                count = 1;
            }
            else if (count > 8) {
                count = 8;
            }
            var offset = Math.floor(i / 2);
            if ((i & 0x01) === 0) {
                oddCounts[offset] = count;
                oddRoundingErrors[offset] = value - count;
            }
            else {
                evenCounts[offset] = count;
                evenRoundingErrors[offset] = value - count;
            }
        }
        this.adjustOddEvenCounts(outsideChar, numModules);
        var oddSum = 0;
        var oddChecksumPortion = 0;
        for (var i = oddCounts.length - 1; i >= 0; i--) {
            oddChecksumPortion *= 9;
            oddChecksumPortion += oddCounts[i];
            oddSum += oddCounts[i];
        }
        var evenChecksumPortion = 0;
        var evenSum = 0;
        for (var i = evenCounts.length - 1; i >= 0; i--) {
            evenChecksumPortion *= 9;
            evenChecksumPortion += evenCounts[i];
            evenSum += evenCounts[i];
        }
        var checksumPortion = oddChecksumPortion + 3 * evenChecksumPortion;
        if (outsideChar) {
            if ((oddSum & 0x01) !== 0 || oddSum > 12 || oddSum < 4) {
                throw new NotFoundException_1.default();
            }
            var group = (12 - oddSum) / 2;
            var oddWidest = RSS14Reader.OUTSIDE_ODD_WIDEST[group];
            var evenWidest = 9 - oddWidest;
            var vOdd = RSSUtils_1.default.getRSSvalue(oddCounts, oddWidest, false);
            var vEven = RSSUtils_1.default.getRSSvalue(evenCounts, evenWidest, true);
            var tEven = RSS14Reader.OUTSIDE_EVEN_TOTAL_SUBSET[group];
            var gSum = RSS14Reader.OUTSIDE_GSUM[group];
            return new DataCharacter_1.default(vOdd * tEven + vEven + gSum, checksumPortion);
        }
        else {
            if ((evenSum & 0x01) !== 0 || evenSum > 10 || evenSum < 4) {
                throw new NotFoundException_1.default();
            }
            var group = (10 - evenSum) / 2;
            var oddWidest = RSS14Reader.INSIDE_ODD_WIDEST[group];
            var evenWidest = 9 - oddWidest;
            var vOdd = RSSUtils_1.default.getRSSvalue(oddCounts, oddWidest, true);
            var vEven = RSSUtils_1.default.getRSSvalue(evenCounts, evenWidest, false);
            var tOdd = RSS14Reader.INSIDE_ODD_TOTAL_SUBSET[group];
            var gSum = RSS14Reader.INSIDE_GSUM[group];
            return new DataCharacter_1.default(vEven * tOdd + vOdd + gSum, checksumPortion);
        }
    };
    RSS14Reader.prototype.findFinderPattern = function (row, rightFinderPattern) {
        var counters = this.getDecodeFinderCounters();
        counters[0] = 0;
        counters[1] = 0;
        counters[2] = 0;
        counters[3] = 0;
        var width = row.getSize();
        var isWhite = false;
        var rowOffset = 0;
        while (rowOffset < width) {
            isWhite = !row.get(rowOffset);
            if (rightFinderPattern === isWhite) {
                // Will encounter white first when searching for right finder pattern
                break;
            }
            rowOffset++;
        }
        var counterPosition = 0;
        var patternStart = rowOffset;
        for (var x = rowOffset; x < width; x++) {
            if (row.get(x) !== isWhite) {
                counters[counterPosition]++;
            }
            else {
                if (counterPosition === 3) {
                    if (AbstractRSSReader_1.default.isFinderPattern(counters)) {
                        return [patternStart, x];
                    }
                    patternStart += counters[0] + counters[1];
                    counters[0] = counters[2];
                    counters[1] = counters[3];
                    counters[2] = 0;
                    counters[3] = 0;
                    counterPosition--;
                }
                else {
                    counterPosition++;
                }
                counters[counterPosition] = 1;
                isWhite = !isWhite;
            }
        }
        throw new NotFoundException_1.default();
    };
    RSS14Reader.prototype.parseFoundFinderPattern = function (row, rowNumber, right, startEnd) {
        // Actually we found elements 2-5
        var firstIsBlack = row.get(startEnd[0]);
        var firstElementStart = startEnd[0] - 1;
        // Locate element 1
        while (firstElementStart >= 0 && firstIsBlack !== row.get(firstElementStart)) {
            firstElementStart--;
        }
        firstElementStart++;
        var firstCounter = startEnd[0] - firstElementStart;
        // Make 'counters' hold 1-4
        var counters = this.getDecodeFinderCounters();
        var copy = new Int32Array(counters.length);
        System_1.default.arraycopy(counters, 0, copy, 1, counters.length - 1);
        copy[0] = firstCounter;
        var value = this.parseFinderValue(copy, RSS14Reader.FINDER_PATTERNS);
        var start = firstElementStart;
        var end = startEnd[1];
        if (right) {
            // row is actually reversed
            start = row.getSize() - 1 - start;
            end = row.getSize() - 1 - end;
        }
        return new FinderPattern_1.default(value, [firstElementStart, startEnd[1]], start, end, rowNumber);
    };
    RSS14Reader.prototype.adjustOddEvenCounts = function (outsideChar, numModules) {
        var oddSum = MathUtils_1.default.sum(new Int32Array(this.getOddCounts()));
        var evenSum = MathUtils_1.default.sum(new Int32Array(this.getEvenCounts()));
        var incrementOdd = false;
        var decrementOdd = false;
        var incrementEven = false;
        var decrementEven = false;
        if (outsideChar) {
            if (oddSum > 12) {
                decrementOdd = true;
            }
            else if (oddSum < 4) {
                incrementOdd = true;
            }
            if (evenSum > 12) {
                decrementEven = true;
            }
            else if (evenSum < 4) {
                incrementEven = true;
            }
        }
        else {
            if (oddSum > 11) {
                decrementOdd = true;
            }
            else if (oddSum < 5) {
                incrementOdd = true;
            }
            if (evenSum > 10) {
                decrementEven = true;
            }
            else if (evenSum < 4) {
                incrementEven = true;
            }
        }
        var mismatch = oddSum + evenSum - numModules;
        var oddParityBad = (oddSum & 0x01) === (outsideChar ? 1 : 0);
        var evenParityBad = (evenSum & 0x01) === 1;
        if (mismatch === 1) {
            if (oddParityBad) {
                if (evenParityBad) {
                    throw new NotFoundException_1.default();
                }
                decrementOdd = true;
            }
            else {
                if (!evenParityBad) {
                    throw new NotFoundException_1.default();
                }
                decrementEven = true;
            }
        }
        else if (mismatch === -1) {
            if (oddParityBad) {
                if (evenParityBad) {
                    throw new NotFoundException_1.default();
                }
                incrementOdd = true;
            }
            else {
                if (!evenParityBad) {
                    throw new NotFoundException_1.default();
                }
                incrementEven = true;
            }
        }
        else if (mismatch === 0) {
            if (oddParityBad) {
                if (!evenParityBad) {
                    throw new NotFoundException_1.default();
                }
                // Both bad
                if (oddSum < evenSum) {
                    incrementOdd = true;
                    decrementEven = true;
                }
                else {
                    decrementOdd = true;
                    incrementEven = true;
                }
            }
            else {
                if (evenParityBad) {
                    throw new NotFoundException_1.default();
                }
                // Nothing to do!
            }
        }
        else {
            throw new NotFoundException_1.default();
        }
        if (incrementOdd) {
            if (decrementOdd) {
                throw new NotFoundException_1.default();
            }
            AbstractRSSReader_1.default.increment(this.getOddCounts(), this.getOddRoundingErrors());
        }
        if (decrementOdd) {
            AbstractRSSReader_1.default.decrement(this.getOddCounts(), this.getOddRoundingErrors());
        }
        if (incrementEven) {
            if (decrementEven) {
                throw new NotFoundException_1.default();
            }
            AbstractRSSReader_1.default.increment(this.getEvenCounts(), this.getOddRoundingErrors());
        }
        if (decrementEven) {
            AbstractRSSReader_1.default.decrement(this.getEvenCounts(), this.getEvenRoundingErrors());
        }
    };
    RSS14Reader.OUTSIDE_EVEN_TOTAL_SUBSET = [1, 10, 34, 70, 126];
    RSS14Reader.INSIDE_ODD_TOTAL_SUBSET = [4, 20, 48, 81];
    RSS14Reader.OUTSIDE_GSUM = [0, 161, 961, 2015, 2715];
    RSS14Reader.INSIDE_GSUM = [0, 336, 1036, 1516];
    RSS14Reader.OUTSIDE_ODD_WIDEST = [8, 6, 4, 3, 1];
    RSS14Reader.INSIDE_ODD_WIDEST = [2, 4, 6, 8];
    RSS14Reader.FINDER_PATTERNS = [
        Int32Array.from([3, 8, 2, 1]),
        Int32Array.from([3, 5, 5, 1]),
        Int32Array.from([3, 3, 7, 1]),
        Int32Array.from([3, 1, 9, 1]),
        Int32Array.from([2, 7, 4, 1]),
        Int32Array.from([2, 5, 6, 1]),
        Int32Array.from([2, 3, 8, 1]),
        Int32Array.from([1, 5, 7, 1]),
        Int32Array.from([1, 3, 9, 1]),
    ];
    return RSS14Reader;
}(AbstractRSSReader_1.default));
exports.default = RSS14Reader;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\RSS14Reader.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\RSSUtils.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5Crss%5CRSSUtils.js
      return function (require, module, exports) {
"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * RSS util functions.
 */
var RSSUtils = /** @class */ (function () {
    function RSSUtils() {
    }
    RSSUtils.getRSSvalue = function (widths, maxWidth, noNarrow) {
        var e_1, _a;
        var n = 0;
        try {
            for (var widths_1 = __values(widths), widths_1_1 = widths_1.next(); !widths_1_1.done; widths_1_1 = widths_1.next()) {
                var width = widths_1_1.value;
                n += width;
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (widths_1_1 && !widths_1_1.done && (_a = widths_1.return)) _a.call(widths_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        var val = 0;
        var narrowMask = 0;
        var elements = widths.length;
        for (var bar = 0; bar < elements - 1; bar++) {
            var elmWidth = void 0;
            for (elmWidth = 1, narrowMask |= 1 << bar; elmWidth < widths[bar]; elmWidth++, narrowMask &= ~(1 << bar)) {
                var subVal = RSSUtils.combins(n - elmWidth - 1, elements - bar - 2);
                if (noNarrow && (narrowMask === 0) && (n - elmWidth - (elements - bar - 1) >= elements - bar - 1)) {
                    subVal -= RSSUtils.combins(n - elmWidth - (elements - bar), elements - bar - 2);
                }
                if (elements - bar - 1 > 1) {
                    var lessVal = 0;
                    for (var mxwElement = n - elmWidth - (elements - bar - 2); mxwElement > maxWidth; mxwElement--) {
                        lessVal += RSSUtils.combins(n - elmWidth - mxwElement - 1, elements - bar - 3);
                    }
                    subVal -= lessVal * (elements - 1 - bar);
                }
                else if (n - elmWidth > maxWidth) {
                    subVal--;
                }
                val += subVal;
            }
            n -= elmWidth;
        }
        return val;
    };
    RSSUtils.combins = function (n, r) {
        var maxDenom;
        var minDenom;
        if (n - r > r) {
            minDenom = r;
            maxDenom = n - r;
        }
        else {
            minDenom = n - r;
            maxDenom = r;
        }
        var val = 1;
        var j = 1;
        for (var i = n; i > maxDenom; i--) {
            val *= i;
            if (j <= minDenom) {
                val /= j;
                j++;
            }
        }
        while ((j <= minDenom)) {
            val /= j;
            j++;
        }
        return val;
    };
    return RSSUtils;
}());
exports.default = RSSUtils;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\RSSUtils.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\BitArrayBuilder.js", {"../../../common/BitArray":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\BitArray.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5Crss%5Cexpanded%5CBitArrayBuilder.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var BitArray_1 = require("../../../common/BitArray");
var BitArrayBuilder = /** @class */ (function () {
    function BitArrayBuilder() {
    }
    BitArrayBuilder.buildBitArray = function (pairs) {
        var charNumber = pairs.length * 2 - 1;
        if (pairs[pairs.length - 1].getRightChar() == null) {
            charNumber -= 1;
        }
        var size = 12 * charNumber;
        var binary = new BitArray_1.default(size);
        var accPos = 0;
        var firstPair = pairs[0];
        var firstValue = firstPair.getRightChar().getValue();
        for (var i = 11; i >= 0; --i) {
            if ((firstValue & (1 << i)) !== 0) {
                binary.set(accPos);
            }
            accPos++;
        }
        for (var i = 1; i < pairs.length; ++i) {
            var currentPair = pairs[i];
            var leftValue = currentPair.getLeftChar().getValue();
            for (var j = 11; j >= 0; --j) {
                if ((leftValue & (1 << j)) !== 0) {
                    binary.set(accPos);
                }
                accPos++;
            }
            if (currentPair.getRightChar() !== null) {
                var rightValue = currentPair.getRightChar().getValue();
                for (var j = 11; j >= 0; --j) {
                    if ((rightValue & (1 << j)) !== 0) {
                        binary.set(accPos);
                    }
                    accPos++;
                }
            }
        }
        return binary;
    };
    return BitArrayBuilder;
}());
exports.default = BitArrayBuilder;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\BitArrayBuilder.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\ExpandedPair.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5Crss%5Cexpanded%5CExpandedPair.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ExpandedPair = /** @class */ (function () {
    function ExpandedPair(leftChar, rightChar, finderPatter, mayBeLast) {
        this.leftchar = leftChar;
        this.rightchar = rightChar;
        this.finderpattern = finderPatter;
        this.maybeLast = mayBeLast;
    }
    ExpandedPair.prototype.mayBeLast = function () {
        return this.maybeLast;
    };
    ExpandedPair.prototype.getLeftChar = function () {
        return this.leftchar;
    };
    ExpandedPair.prototype.getRightChar = function () {
        return this.rightchar;
    };
    ExpandedPair.prototype.getFinderPattern = function () {
        return this.finderpattern;
    };
    ExpandedPair.prototype.mustBeLast = function () {
        return this.rightchar == null;
    };
    ExpandedPair.prototype.toString = function () {
        return '[ ' + this.leftchar + ', ' + this.rightchar + ' : ' + (this.finderpattern == null ? 'null' : this.finderpattern.getValue()) + ' ]';
    };
    ExpandedPair.equals = function (o1, o2) {
        if (!(o1 instanceof ExpandedPair)) {
            return false;
        }
        return ExpandedPair.equalsOrNull(o1.leftchar, o2.leftchar) &&
            ExpandedPair.equalsOrNull(o1.rightchar, o2.rightchar) &&
            ExpandedPair.equalsOrNull(o1.finderpattern, o2.finderpattern);
    };
    ExpandedPair.equalsOrNull = function (o1, o2) {
        return o1 === null ? o2 === null : ExpandedPair.equals(o1, o2);
    };
    ExpandedPair.prototype.hashCode = function () {
        // return ExpandedPair.hashNotNull(leftChar) ^ hashNotNull(rightChar) ^ hashNotNull(finderPattern);
        var value = this.leftchar.getValue() ^ this.rightchar.getValue() ^ this.finderpattern.getValue();
        return value;
    };
    return ExpandedPair;
}());
exports.default = ExpandedPair;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\ExpandedPair.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\ExpandedRow.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5Crss%5Cexpanded%5CExpandedRow.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ExpandedRow = /** @class */ (function () {
    function ExpandedRow(pairs, rowNumber, wasReversed) {
        this.pairs = pairs;
        this.rowNumber = rowNumber;
        this.wasReversed = wasReversed;
    }
    ExpandedRow.prototype.getPairs = function () {
        return this.pairs;
    };
    ExpandedRow.prototype.getRowNumber = function () {
        return this.rowNumber;
    };
    ExpandedRow.prototype.isReversed = function () {
        return this.wasReversed;
    };
    // check implementation
    ExpandedRow.prototype.isEquivalent = function (otherPairs) {
        return this.checkEqualitity(this, otherPairs);
    };
    // @Override
    ExpandedRow.prototype.toString = function () {
        return '{ ' + this.pairs + ' }';
    };
    /**
     * Two rows are equal if they contain the same pairs in the same order.
     */
    // @Override
    // check implementation
    ExpandedRow.prototype.equals = function (o1, o2) {
        if (!(o1 instanceof ExpandedRow)) {
            return false;
        }
        return this.checkEqualitity(o1, o2) && o1.wasReversed === o2.wasReversed;
    };
    ExpandedRow.prototype.checkEqualitity = function (pair1, pair2) {
        if (!pair1 || !pair2)
            return;
        var result;
        pair1.forEach(function (e1, i) {
            pair2.forEach(function (e2) {
                if (e1.getLeftChar().getValue() === e2.getLeftChar().getValue() && e1.getRightChar().getValue() === e2.getRightChar().getValue() && e1.getFinderPatter().getValue() === e2.getFinderPatter().getValue()) {
                    result = true;
                }
            });
        });
        return result;
    };
    return ExpandedRow;
}());
exports.default = ExpandedRow;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\ExpandedRow.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\RSSExpandedReader.js", {"../../../BarcodeFormat":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\BarcodeFormat.js","../../../NotFoundException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\NotFoundException.js","../../../Result":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\Result.js","../../../common/detector/MathUtils":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\detector\\MathUtils.js","../../../util/System":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\System.js","../../rss/AbstractRSSReader":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\AbstractRSSReader.js","../../rss/DataCharacter":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\DataCharacter.js","../../rss/FinderPattern":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\FinderPattern.js","../../rss/RSSUtils":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\RSSUtils.js","./BitArrayBuilder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\BitArrayBuilder.js","./ExpandedPair":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\ExpandedPair.js","./ExpandedRow":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\ExpandedRow.js","./decoders/AbstractExpandedDecoderComplement":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AbstractExpandedDecoderComplement.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5Crss%5Cexpanded%5CRSSExpandedReader.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
var BarcodeFormat_1 = require("../../../BarcodeFormat");
var MathUtils_1 = require("../../../common/detector/MathUtils");
// import FormatException from '../../../FormatException';
var NotFoundException_1 = require("../../../NotFoundException");
var Result_1 = require("../../../Result");
var System_1 = require("../../../util/System");
var AbstractRSSReader_1 = require("../../rss/AbstractRSSReader");
var DataCharacter_1 = require("../../rss/DataCharacter");
var FinderPattern_1 = require("../../rss/FinderPattern");
var RSSUtils_1 = require("../../rss/RSSUtils");
var BitArrayBuilder_1 = require("./BitArrayBuilder");
var AbstractExpandedDecoderComplement_1 = require("./decoders/AbstractExpandedDecoderComplement");
var ExpandedPair_1 = require("./ExpandedPair");
var ExpandedRow_1 = require("./ExpandedRow");
// import java.util.ArrayList;
// import java.util.Iterator;
// import java.util.List;
// import java.util.Map;
// import java.util.Collections;
/** @experimental */
var RSSExpandedReader = /** @class */ (function (_super) {
    __extends(RSSExpandedReader, _super);
    function RSSExpandedReader() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.pairs = new Array(RSSExpandedReader.MAX_PAIRS);
        _this.rows = new Array();
        _this.startEnd = [2];
        return _this;
    }
    RSSExpandedReader.prototype.decodeRow = function (rowNumber, row, hints) {
        // Rows can start with even pattern in case in prev rows there where odd number of patters.
        // So lets try twice
        // this.pairs.clear();
        this.pairs.length = 0;
        this.startFromEven = false;
        try {
            return RSSExpandedReader.constructResult(this.decodeRow2pairs(rowNumber, row));
        }
        catch (e) {
            // OK
            // console.log(e);
        }
        this.pairs.length = 0;
        this.startFromEven = true;
        return RSSExpandedReader.constructResult(this.decodeRow2pairs(rowNumber, row));
    };
    RSSExpandedReader.prototype.reset = function () {
        this.pairs.length = 0;
        this.rows.length = 0;
    };
    // Not private for testing
    RSSExpandedReader.prototype.decodeRow2pairs = function (rowNumber, row) {
        var done = false;
        while (!done) {
            try {
                this.pairs.push(this.retrieveNextPair(row, this.pairs, rowNumber));
            }
            catch (error) {
                if (error instanceof NotFoundException_1.default) {
                    if (!this.pairs.length) {
                        throw new NotFoundException_1.default();
                    }
                    // exit this loop when retrieveNextPair() fails and throws
                    done = true;
                }
            }
        }
        // TODO: verify sequence of finder patterns as in checkPairSequence()
        if (this.checkChecksum()) {
            return this.pairs;
        }
        var tryStackedDecode;
        if (this.rows.length) {
            tryStackedDecode = true;
        }
        else {
            tryStackedDecode = false;
        }
        // let tryStackedDecode = !this.rows.isEmpty();
        this.storeRow(rowNumber, false); // TODO: deal with reversed rows
        if (tryStackedDecode) {
            // When the image is 180-rotated, then rows are sorted in wrong direction.
            // Try twice with both the directions.
            var ps = this.checkRowsBoolean(false);
            if (ps != null) {
                return ps;
            }
            ps = this.checkRowsBoolean(true);
            if (ps != null) {
                return ps;
            }
        }
        throw new NotFoundException_1.default();
    };
    // Need to Verify
    RSSExpandedReader.prototype.checkRowsBoolean = function (reverse) {
        // Limit number of rows we are checking
        // We use recursive algorithm with pure complexity and don't want it to take forever
        // Stacked barcode can have up to 11 rows, so 25 seems reasonable enough
        if (this.rows.length > 25) {
            this.rows.length = 0; // We will never have a chance to get result, so clear it
            return null;
        }
        this.pairs.length = 0;
        if (reverse) {
            this.rows = this.rows.reverse();
            // Collections.reverse(this.rows);
        }
        var ps = null;
        try {
            ps = this.checkRows(new Array(), 0);
        }
        catch (e) {
            // OK
            console.log(e);
        }
        if (reverse) {
            this.rows = this.rows.reverse();
            // Collections.reverse(this.rows);
        }
        return ps;
    };
    // Try to construct a valid rows sequence
    // Recursion is used to implement backtracking
    RSSExpandedReader.prototype.checkRows = function (collectedRows, currentRow) {
        var e_1, _a;
        for (var i = currentRow; i < this.rows.length; i++) {
            var row = this.rows[i];
            this.pairs.length = 0;
            try {
                for (var collectedRows_1 = (e_1 = void 0, __values(collectedRows)), collectedRows_1_1 = collectedRows_1.next(); !collectedRows_1_1.done; collectedRows_1_1 = collectedRows_1.next()) {
                    var collectedRow = collectedRows_1_1.value;
                    this.pairs.push(collectedRow.getPairs());
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (collectedRows_1_1 && !collectedRows_1_1.done && (_a = collectedRows_1.return)) _a.call(collectedRows_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            this.pairs.push(row.getPairs());
            if (!RSSExpandedReader.isValidSequence(this.pairs)) {
                continue;
            }
            if (this.checkChecksum()) {
                return this.pairs;
            }
            var rs = new Array(collectedRows);
            rs.push(row);
            try {
                // Recursion: try to add more rows
                return this.checkRows(rs, i + 1);
            }
            catch (e) {
                // We failed, try the next candidate
                console.log(e);
            }
        }
        throw new NotFoundException_1.default();
    };
    // Whether the pairs form a valid find pattern sequence,
    // either complete or a prefix
    RSSExpandedReader.isValidSequence = function (pairs) {
        var e_2, _a;
        try {
            for (var _b = __values(RSSExpandedReader.FINDER_PATTERN_SEQUENCES), _c = _b.next(); !_c.done; _c = _b.next()) {
                var sequence = _c.value;
                if (pairs.length > sequence.length) {
                    continue;
                }
                var stop_1 = true;
                for (var j = 0; j < pairs.length; j++) {
                    if (pairs[j].getFinderPattern().getValue() !== sequence[j]) {
                        stop_1 = false;
                        break;
                    }
                }
                if (stop_1) {
                    return true;
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
        return false;
    };
    RSSExpandedReader.prototype.storeRow = function (rowNumber, wasReversed) {
        // Discard if duplicate above or below; otherwise insert in order by row number.
        var insertPos = 0;
        var prevIsSame = false;
        var nextIsSame = false;
        while (insertPos < this.rows.length) {
            var erow = this.rows[insertPos];
            if (erow.getRowNumber() > rowNumber) {
                nextIsSame = erow.isEquivalent(this.pairs);
                break;
            }
            prevIsSame = erow.isEquivalent(this.pairs);
            insertPos++;
        }
        if (nextIsSame || prevIsSame) {
            return;
        }
        // When the row was partially decoded (e.g. 2 pairs found instead of 3),
        // it will prevent us from detecting the barcode.
        // Try to merge partial rows
        // Check whether the row is part of an allready detected row
        if (RSSExpandedReader.isPartialRow(this.pairs, this.rows)) {
            return;
        }
        this.rows.push(insertPos, new ExpandedRow_1.default(this.pairs, rowNumber, wasReversed));
        this.removePartialRows(this.pairs, this.rows);
    };
    // Remove all the rows that contains only specified pairs
    RSSExpandedReader.prototype.removePartialRows = function (pairs, rows) {
        var e_3, _a, e_4, _b, e_5, _c;
        try {
            // for (Iterator<ExpandedRow> iterator = rows.iterator(); iterator.hasNext();) {
            //   ExpandedRow r = iterator.next();
            //   if (r.getPairs().size() == pairs.size()) {
            //     continue;
            //   }
            //   boolean allFound = true;
            //   for (ExpandedPair p : r.getPairs()) {
            //     boolean found = false;
            //     for (ExpandedPair pp : pairs) {
            //       if (p.equals(pp)) {
            //         found = true;
            //         break;
            //       }
            //     }
            //     if (!found) {
            //       allFound = false;
            //       break;
            //     }
            //   }
            //   if (allFound) {
            //     // 'pairs' contains all the pairs from the row 'r'
            //     iterator.remove();
            //   }
            // }
            for (var rows_1 = __values(rows), rows_1_1 = rows_1.next(); !rows_1_1.done; rows_1_1 = rows_1.next()) {
                var row = rows_1_1.value;
                if (row.getPairs().length === pairs.length) {
                    continue;
                }
                var allFound = true;
                try {
                    for (var _d = (e_4 = void 0, __values(row.getPairs())), _e = _d.next(); !_e.done; _e = _d.next()) {
                        var p = _e.value;
                        var found = false;
                        try {
                            for (var pairs_1 = (e_5 = void 0, __values(pairs)), pairs_1_1 = pairs_1.next(); !pairs_1_1.done; pairs_1_1 = pairs_1.next()) {
                                var pp = pairs_1_1.value;
                                if (ExpandedPair_1.default.equals(p, pp)) {
                                    found = true;
                                    break;
                                }
                            }
                        }
                        catch (e_5_1) { e_5 = { error: e_5_1 }; }
                        finally {
                            try {
                                if (pairs_1_1 && !pairs_1_1.done && (_c = pairs_1.return)) _c.call(pairs_1);
                            }
                            finally { if (e_5) throw e_5.error; }
                        }
                        if (!found) {
                            allFound = false;
                        }
                    }
                }
                catch (e_4_1) { e_4 = { error: e_4_1 }; }
                finally {
                    try {
                        if (_e && !_e.done && (_b = _d.return)) _b.call(_d);
                    }
                    finally { if (e_4) throw e_4.error; }
                }
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (rows_1_1 && !rows_1_1.done && (_a = rows_1.return)) _a.call(rows_1);
            }
            finally { if (e_3) throw e_3.error; }
        }
    };
    // Returns true when one of the rows already contains all the pairs
    RSSExpandedReader.isPartialRow = function (pairs, rows) {
        var e_6, _a, e_7, _b, e_8, _c;
        try {
            for (var rows_2 = __values(rows), rows_2_1 = rows_2.next(); !rows_2_1.done; rows_2_1 = rows_2.next()) {
                var r = rows_2_1.value;
                var allFound = true;
                try {
                    for (var pairs_2 = (e_7 = void 0, __values(pairs)), pairs_2_1 = pairs_2.next(); !pairs_2_1.done; pairs_2_1 = pairs_2.next()) {
                        var p = pairs_2_1.value;
                        var found = false;
                        try {
                            for (var _d = (e_8 = void 0, __values(r.getPairs())), _e = _d.next(); !_e.done; _e = _d.next()) {
                                var pp = _e.value;
                                if (p.equals(pp)) {
                                    found = true;
                                    break;
                                }
                            }
                        }
                        catch (e_8_1) { e_8 = { error: e_8_1 }; }
                        finally {
                            try {
                                if (_e && !_e.done && (_c = _d.return)) _c.call(_d);
                            }
                            finally { if (e_8) throw e_8.error; }
                        }
                        if (!found) {
                            allFound = false;
                            break;
                        }
                    }
                }
                catch (e_7_1) { e_7 = { error: e_7_1 }; }
                finally {
                    try {
                        if (pairs_2_1 && !pairs_2_1.done && (_b = pairs_2.return)) _b.call(pairs_2);
                    }
                    finally { if (e_7) throw e_7.error; }
                }
                if (allFound) {
                    // the row 'r' contain all the pairs from 'pairs'
                    return true;
                }
            }
        }
        catch (e_6_1) { e_6 = { error: e_6_1 }; }
        finally {
            try {
                if (rows_2_1 && !rows_2_1.done && (_a = rows_2.return)) _a.call(rows_2);
            }
            finally { if (e_6) throw e_6.error; }
        }
        return false;
    };
    // Only used for unit testing
    RSSExpandedReader.prototype.getRows = function () {
        return this.rows;
    };
    // Not private for unit testing
    RSSExpandedReader.constructResult = function (pairs) {
        var binary = BitArrayBuilder_1.default.buildBitArray(pairs);
        var decoder = AbstractExpandedDecoderComplement_1.createDecoder(binary);
        var resultingString = decoder.parseInformation();
        var firstPoints = pairs[0].getFinderPattern().getResultPoints();
        var lastPoints = pairs[pairs.length - 1]
            .getFinderPattern()
            .getResultPoints();
        var points = [firstPoints[0], firstPoints[1], lastPoints[0], lastPoints[1]];
        return new Result_1.default(resultingString, null, null, points, BarcodeFormat_1.default.RSS_EXPANDED, null);
    };
    RSSExpandedReader.prototype.checkChecksum = function () {
        var firstPair = this.pairs.get(0);
        var checkCharacter = firstPair.getLeftChar();
        var firstCharacter = firstPair.getRightChar();
        if (firstCharacter === null) {
            return false;
        }
        var checksum = firstCharacter.getChecksumPortion();
        var s = 2;
        for (var i = 1; i < this.pairs.size(); ++i) {
            var currentPair = this.pairs.get(i);
            checksum += currentPair.getLeftChar().getChecksumPortion();
            s++;
            var currentRightChar = currentPair.getRightChar();
            if (currentRightChar != null) {
                checksum += currentRightChar.getChecksumPortion();
                s++;
            }
        }
        checksum %= 211;
        var checkCharacterValue = 211 * (s - 4) + checksum;
        return checkCharacterValue === checkCharacter.getValue();
    };
    RSSExpandedReader.getNextSecondBar = function (row, initialPos) {
        var currentPos;
        if (row.get(initialPos)) {
            currentPos = row.getNextUnset(initialPos);
            currentPos = row.getNextSet(currentPos);
        }
        else {
            currentPos = row.getNextSet(initialPos);
            currentPos = row.getNextUnset(currentPos);
        }
        return currentPos;
    };
    // not private for testing
    RSSExpandedReader.prototype.retrieveNextPair = function (row, previousPairs, rowNumber) {
        var isOddPattern = previousPairs.length % 2 === 0;
        if (this.startFromEven) {
            isOddPattern = !isOddPattern;
        }
        var pattern;
        var keepFinding = true;
        var forcedOffset = -1;
        do {
            this.findNextPair(row, previousPairs, forcedOffset);
            pattern = this.parseFoundFinderPattern(row, rowNumber, isOddPattern);
            if (pattern === null) {
                forcedOffset = RSSExpandedReader.getNextSecondBar(row, this.startEnd[0]);
            }
            else {
                keepFinding = false;
            }
        } while (keepFinding);
        // When stacked symbol is split over multiple rows, there's no way to guess if this pair can be last or not.
        // boolean mayBeLast = checkPairSequence(previousPairs, pattern);
        var leftChar = this.decodeDataCharacter(row, pattern, isOddPattern, true);
        if (!this.isEmptyPair(previousPairs) &&
            previousPairs[previousPairs.length - 1].mustBeLast()) {
            throw new NotFoundException_1.default();
        }
        var rightChar;
        try {
            rightChar = this.decodeDataCharacter(row, pattern, isOddPattern, false);
        }
        catch (e) {
            rightChar = null;
            console.log(e);
        }
        return new ExpandedPair_1.default(leftChar, rightChar, pattern, true);
    };
    RSSExpandedReader.prototype.isEmptyPair = function (pairs) {
        if (pairs.length === 0) {
            return true;
        }
        return false;
    };
    RSSExpandedReader.prototype.findNextPair = function (row, previousPairs, forcedOffset) {
        var counters = this.getDecodeFinderCounters();
        counters[0] = 0;
        counters[1] = 0;
        counters[2] = 0;
        counters[3] = 0;
        var width = row.getSize();
        var rowOffset;
        if (forcedOffset >= 0) {
            rowOffset = forcedOffset;
        }
        else if (this.isEmptyPair(previousPairs)) {
            rowOffset = 0;
        }
        else {
            var lastPair = previousPairs[previousPairs.length - 1];
            rowOffset = lastPair.getFinderPattern().getStartEnd()[1];
        }
        var searchingEvenPair = previousPairs.length % 2 !== 0;
        if (this.startFromEven) {
            searchingEvenPair = !searchingEvenPair;
        }
        var isWhite = false;
        while (rowOffset < width) {
            isWhite = !row.get(rowOffset);
            if (!isWhite) {
                break;
            }
            rowOffset++;
        }
        var counterPosition = 0;
        var patternStart = rowOffset;
        for (var x = rowOffset; x < width; x++) {
            if (row.get(x) !== isWhite) {
                counters[counterPosition]++;
            }
            else {
                if (counterPosition === 3) {
                    if (searchingEvenPair) {
                        RSSExpandedReader.reverseCounters(counters);
                    }
                    if (RSSExpandedReader.isFinderPattern(counters)) {
                        this.startEnd[0] = patternStart;
                        this.startEnd[1] = x;
                        return;
                    }
                    if (searchingEvenPair) {
                        RSSExpandedReader.reverseCounters(counters);
                    }
                    patternStart += counters[0] + counters[1];
                    counters[0] = counters[2];
                    counters[1] = counters[3];
                    counters[2] = 0;
                    counters[3] = 0;
                    counterPosition--;
                }
                else {
                    counterPosition++;
                }
                counters[counterPosition] = 1;
                isWhite = !isWhite;
            }
        }
        throw new NotFoundException_1.default();
    };
    RSSExpandedReader.reverseCounters = function (counters) {
        var length = counters.length;
        for (var i = 0; i < length / 2; ++i) {
            var tmp = counters[i];
            counters[i] = counters[length - i - 1];
            counters[length - i - 1] = tmp;
        }
    };
    RSSExpandedReader.prototype.parseFoundFinderPattern = function (row, rowNumber, oddPattern) {
        // Actually we found elements 2-5.
        var firstCounter;
        var start;
        var end;
        if (oddPattern) {
            // If pattern number is odd, we need to locate element 1 *before* the current block.
            var firstElementStart = this.startEnd[0] - 1;
            // Locate element 1
            while (firstElementStart >= 0 && !row.get(firstElementStart)) {
                firstElementStart--;
            }
            firstElementStart++;
            firstCounter = this.startEnd[0] - firstElementStart;
            start = firstElementStart;
            end = this.startEnd[1];
        }
        else {
            // If pattern number is even, the pattern is reversed, so we need to locate element 1 *after* the current block.
            start = this.startEnd[0];
            end = row.getNextUnset(this.startEnd[1] + 1);
            firstCounter = end - this.startEnd[1];
        }
        // Make 'counters' hold 1-4
        var counters = this.getDecodeFinderCounters();
        System_1.default.arraycopy(counters, 0, counters, 1, counters.length - 1);
        counters[0] = firstCounter;
        var value;
        try {
            value = this.parseFinderValue(counters, RSSExpandedReader.FINDER_PATTERNS);
        }
        catch (e) {
            return null;
        }
        // return new FinderPattern(value, new int[] { start, end }, start, end, rowNumber});
        return new FinderPattern_1.default(value, [start, end], start, end, rowNumber);
    };
    RSSExpandedReader.prototype.decodeDataCharacter = function (row, pattern, isOddPattern, leftChar) {
        var counters = this.getDataCharacterCounters();
        for (var x = 0; x < counters.length; x++) {
            counters[x] = 0;
        }
        if (leftChar) {
            RSSExpandedReader.recordPatternInReverse(row, pattern.getStartEnd()[0], counters);
        }
        else {
            RSSExpandedReader.recordPattern(row, pattern.getStartEnd()[1], counters);
            // reverse it
            for (var i = 0, j = counters.length - 1; i < j; i++, j--) {
                var temp = counters[i];
                counters[i] = counters[j];
                counters[j] = temp;
            }
        } // counters[] has the pixels of the module
        var numModules = 17; // left and right data characters have all the same length
        var elementWidth = MathUtils_1.default.sum(new Int32Array(counters)) / numModules;
        // Sanity check: element width for pattern and the character should match
        var expectedElementWidth = (pattern.getStartEnd()[1] - pattern.getStartEnd()[0]) / 15.0;
        if (Math.abs(elementWidth - expectedElementWidth) / expectedElementWidth >
            0.3) {
            throw new NotFoundException_1.default();
        }
        var oddCounts = this.getOddCounts();
        var evenCounts = this.getEvenCounts();
        var oddRoundingErrors = this.getOddRoundingErrors();
        var evenRoundingErrors = this.getEvenRoundingErrors();
        for (var i = 0; i < counters.length; i++) {
            var value_1 = (1.0 * counters[i]) / elementWidth;
            var count = value_1 + 0.5; // Round
            if (count < 1) {
                if (value_1 < 0.3) {
                    throw new NotFoundException_1.default();
                }
                count = 1;
            }
            else if (count > 8) {
                if (value_1 > 8.7) {
                    throw new NotFoundException_1.default();
                }
                count = 8;
            }
            var offset = i / 2;
            if ((i & 0x01) === 0) {
                oddCounts[offset] = count;
                oddRoundingErrors[offset] = value_1 - count;
            }
            else {
                evenCounts[offset] = count;
                evenRoundingErrors[offset] = value_1 - count;
            }
        }
        this.adjustOddEvenCounts(numModules);
        var weightRowNumber = 4 * pattern.getValue() + (isOddPattern ? 0 : 2) + (leftChar ? 0 : 1) - 1;
        var oddSum = 0;
        var oddChecksumPortion = 0;
        for (var i = oddCounts.length - 1; i >= 0; i--) {
            if (RSSExpandedReader.isNotA1left(pattern, isOddPattern, leftChar)) {
                var weight = RSSExpandedReader.WEIGHTS[weightRowNumber][2 * i];
                oddChecksumPortion += oddCounts[i] * weight;
            }
            oddSum += oddCounts[i];
        }
        var evenChecksumPortion = 0;
        // int evenSum = 0;
        for (var i = evenCounts.length - 1; i >= 0; i--) {
            if (RSSExpandedReader.isNotA1left(pattern, isOddPattern, leftChar)) {
                var weight = RSSExpandedReader.WEIGHTS[weightRowNumber][2 * i + 1];
                evenChecksumPortion += evenCounts[i] * weight;
            }
            // evenSum += evenCounts[i];
        }
        var checksumPortion = oddChecksumPortion + evenChecksumPortion;
        if ((oddSum & 0x01) !== 0 || oddSum > 13 || oddSum < 4) {
            throw new NotFoundException_1.default();
        }
        var group = (13 - oddSum) / 2;
        var oddWidest = RSSExpandedReader.SYMBOL_WIDEST[group];
        var evenWidest = 9 - oddWidest;
        var vOdd = RSSUtils_1.default.getRSSvalue(oddCounts, oddWidest, true);
        var vEven = RSSUtils_1.default.getRSSvalue(evenCounts, evenWidest, false);
        var tEven = RSSExpandedReader.EVEN_TOTAL_SUBSET[group];
        var gSum = RSSExpandedReader.GSUM[group];
        var value = vOdd * tEven + vEven + gSum;
        return new DataCharacter_1.default(value, checksumPortion);
    };
    RSSExpandedReader.isNotA1left = function (pattern, isOddPattern, leftChar) {
        // A1: pattern.getValue is 0 (A), and it's an oddPattern, and it is a left char
        return !(pattern.getValue() === 0 && isOddPattern && leftChar);
    };
    RSSExpandedReader.prototype.adjustOddEvenCounts = function (numModules) {
        var oddSum = MathUtils_1.default.sum(new Int32Array(this.getOddCounts()));
        var evenSum = MathUtils_1.default.sum(new Int32Array(this.getEvenCounts()));
        var incrementOdd = false;
        var decrementOdd = false;
        if (oddSum > 13) {
            decrementOdd = true;
        }
        else if (oddSum < 4) {
            incrementOdd = true;
        }
        var incrementEven = false;
        var decrementEven = false;
        if (evenSum > 13) {
            decrementEven = true;
        }
        else if (evenSum < 4) {
            incrementEven = true;
        }
        var mismatch = oddSum + evenSum - numModules;
        var oddParityBad = (oddSum & 0x01) === 1;
        var evenParityBad = (evenSum & 0x01) === 0;
        if (mismatch === 1) {
            if (oddParityBad) {
                if (evenParityBad) {
                    throw new NotFoundException_1.default();
                }
                decrementOdd = true;
            }
            else {
                if (!evenParityBad) {
                    throw new NotFoundException_1.default();
                }
                decrementEven = true;
            }
        }
        else if (mismatch === -1) {
            if (oddParityBad) {
                if (evenParityBad) {
                    throw new NotFoundException_1.default();
                }
                incrementOdd = true;
            }
            else {
                if (!evenParityBad) {
                    throw new NotFoundException_1.default();
                }
                incrementEven = true;
            }
        }
        else if (mismatch === 0) {
            if (oddParityBad) {
                if (!evenParityBad) {
                    throw new NotFoundException_1.default();
                }
                // Both bad
                if (oddSum < evenSum) {
                    incrementOdd = true;
                    decrementEven = true;
                }
                else {
                    decrementOdd = true;
                    incrementEven = true;
                }
            }
            else {
                if (evenParityBad) {
                    throw new NotFoundException_1.default();
                }
                // Nothing to do!
            }
        }
        else {
            throw new NotFoundException_1.default();
        }
        if (incrementOdd) {
            if (decrementOdd) {
                throw new NotFoundException_1.default();
            }
            RSSExpandedReader.increment(this.getOddCounts(), this.getOddRoundingErrors());
        }
        if (decrementOdd) {
            RSSExpandedReader.decrement(this.getOddCounts(), this.getOddRoundingErrors());
        }
        if (incrementEven) {
            if (decrementEven) {
                throw new NotFoundException_1.default();
            }
            RSSExpandedReader.increment(this.getEvenCounts(), this.getOddRoundingErrors());
        }
        if (decrementEven) {
            RSSExpandedReader.decrement(this.getEvenCounts(), this.getEvenRoundingErrors());
        }
    };
    RSSExpandedReader.SYMBOL_WIDEST = [7, 5, 4, 3, 1];
    RSSExpandedReader.EVEN_TOTAL_SUBSET = [4, 20, 52, 104, 204];
    RSSExpandedReader.GSUM = [0, 348, 1388, 2948, 3988];
    RSSExpandedReader.FINDER_PATTERNS = [
        Int32Array.from([1, 8, 4, 1]),
        Int32Array.from([3, 6, 4, 1]),
        Int32Array.from([3, 4, 6, 1]),
        Int32Array.from([3, 2, 8, 1]),
        Int32Array.from([2, 6, 5, 1]),
        Int32Array.from([2, 2, 9, 1]),
    ];
    RSSExpandedReader.WEIGHTS = [
        [1, 3, 9, 27, 81, 32, 96, 77],
        [20, 60, 180, 118, 143, 7, 21, 63],
        [189, 145, 13, 39, 117, 140, 209, 205],
        [193, 157, 49, 147, 19, 57, 171, 91],
        [62, 186, 136, 197, 169, 85, 44, 132],
        [185, 133, 188, 142, 4, 12, 36, 108],
        [113, 128, 173, 97, 80, 29, 87, 50],
        [150, 28, 84, 41, 123, 158, 52, 156],
        [46, 138, 203, 187, 139, 206, 196, 166],
        [76, 17, 51, 153, 37, 111, 122, 155],
        [43, 129, 176, 106, 107, 110, 119, 146],
        [16, 48, 144, 10, 30, 90, 59, 177],
        [109, 116, 137, 200, 178, 112, 125, 164],
        [70, 210, 208, 202, 184, 130, 179, 115],
        [134, 191, 151, 31, 93, 68, 204, 190],
        [148, 22, 66, 198, 172, 94, 71, 2],
        [6, 18, 54, 162, 64, 192, 154, 40],
        [120, 149, 25, 75, 14, 42, 126, 167],
        [79, 26, 78, 23, 69, 207, 199, 175],
        [103, 98, 83, 38, 114, 131, 182, 124],
        [161, 61, 183, 127, 170, 88, 53, 159],
        [55, 165, 73, 8, 24, 72, 5, 15],
        [45, 135, 194, 160, 58, 174, 100, 89],
    ];
    RSSExpandedReader.FINDER_PAT_A = 0;
    RSSExpandedReader.FINDER_PAT_B = 1;
    RSSExpandedReader.FINDER_PAT_C = 2;
    RSSExpandedReader.FINDER_PAT_D = 3;
    RSSExpandedReader.FINDER_PAT_E = 4;
    RSSExpandedReader.FINDER_PAT_F = 5;
    RSSExpandedReader.FINDER_PATTERN_SEQUENCES = [
        [RSSExpandedReader.FINDER_PAT_A, RSSExpandedReader.FINDER_PAT_A],
        [
            RSSExpandedReader.FINDER_PAT_A,
            RSSExpandedReader.FINDER_PAT_B,
            RSSExpandedReader.FINDER_PAT_B,
        ],
        [
            RSSExpandedReader.FINDER_PAT_A,
            RSSExpandedReader.FINDER_PAT_C,
            RSSExpandedReader.FINDER_PAT_B,
            RSSExpandedReader.FINDER_PAT_D,
        ],
        [
            RSSExpandedReader.FINDER_PAT_A,
            RSSExpandedReader.FINDER_PAT_E,
            RSSExpandedReader.FINDER_PAT_B,
            RSSExpandedReader.FINDER_PAT_D,
            RSSExpandedReader.FINDER_PAT_C,
        ],
        [
            RSSExpandedReader.FINDER_PAT_A,
            RSSExpandedReader.FINDER_PAT_E,
            RSSExpandedReader.FINDER_PAT_B,
            RSSExpandedReader.FINDER_PAT_D,
            RSSExpandedReader.FINDER_PAT_D,
            RSSExpandedReader.FINDER_PAT_F,
        ],
        [
            RSSExpandedReader.FINDER_PAT_A,
            RSSExpandedReader.FINDER_PAT_E,
            RSSExpandedReader.FINDER_PAT_B,
            RSSExpandedReader.FINDER_PAT_D,
            RSSExpandedReader.FINDER_PAT_E,
            RSSExpandedReader.FINDER_PAT_F,
            RSSExpandedReader.FINDER_PAT_F,
        ],
        [
            RSSExpandedReader.FINDER_PAT_A,
            RSSExpandedReader.FINDER_PAT_A,
            RSSExpandedReader.FINDER_PAT_B,
            RSSExpandedReader.FINDER_PAT_B,
            RSSExpandedReader.FINDER_PAT_C,
            RSSExpandedReader.FINDER_PAT_C,
            RSSExpandedReader.FINDER_PAT_D,
            RSSExpandedReader.FINDER_PAT_D,
        ],
        [
            RSSExpandedReader.FINDER_PAT_A,
            RSSExpandedReader.FINDER_PAT_A,
            RSSExpandedReader.FINDER_PAT_B,
            RSSExpandedReader.FINDER_PAT_B,
            RSSExpandedReader.FINDER_PAT_C,
            RSSExpandedReader.FINDER_PAT_C,
            RSSExpandedReader.FINDER_PAT_D,
            RSSExpandedReader.FINDER_PAT_E,
            RSSExpandedReader.FINDER_PAT_E,
        ],
        [
            RSSExpandedReader.FINDER_PAT_A,
            RSSExpandedReader.FINDER_PAT_A,
            RSSExpandedReader.FINDER_PAT_B,
            RSSExpandedReader.FINDER_PAT_B,
            RSSExpandedReader.FINDER_PAT_C,
            RSSExpandedReader.FINDER_PAT_C,
            RSSExpandedReader.FINDER_PAT_D,
            RSSExpandedReader.FINDER_PAT_E,
            RSSExpandedReader.FINDER_PAT_F,
            RSSExpandedReader.FINDER_PAT_F,
        ],
        [
            RSSExpandedReader.FINDER_PAT_A,
            RSSExpandedReader.FINDER_PAT_A,
            RSSExpandedReader.FINDER_PAT_B,
            RSSExpandedReader.FINDER_PAT_B,
            RSSExpandedReader.FINDER_PAT_C,
            RSSExpandedReader.FINDER_PAT_D,
            RSSExpandedReader.FINDER_PAT_D,
            RSSExpandedReader.FINDER_PAT_E,
            RSSExpandedReader.FINDER_PAT_E,
            RSSExpandedReader.FINDER_PAT_F,
            RSSExpandedReader.FINDER_PAT_F,
        ],
    ];
    RSSExpandedReader.MAX_PAIRS = 11;
    return RSSExpandedReader;
}(AbstractRSSReader_1.default));
exports.default = RSSExpandedReader;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\RSSExpandedReader.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AI013103decoder.js", {"./AI013x0xDecoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AI013x0xDecoder.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5Crss%5Cexpanded%5Cdecoders%5CAI013103decoder.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var AI013x0xDecoder_1 = require("./AI013x0xDecoder");
var AI013103decoder = /** @class */ (function (_super) {
    __extends(AI013103decoder, _super);
    function AI013103decoder(information) {
        return _super.call(this, information) || this;
    }
    AI013103decoder.prototype.addWeightCode = function (buf, weight) {
        buf.append('(3103)');
    };
    AI013103decoder.prototype.checkWeight = function (weight) {
        return weight;
    };
    return AI013103decoder;
}(AI013x0xDecoder_1.default));
exports.default = AI013103decoder;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AI013103decoder.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AI01320xDecoder.js", {"./AI013x0xDecoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AI013x0xDecoder.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5Crss%5Cexpanded%5Cdecoders%5CAI01320xDecoder.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var AI013x0xDecoder_1 = require("./AI013x0xDecoder");
var AI01320xDecoder = /** @class */ (function (_super) {
    __extends(AI01320xDecoder, _super);
    function AI01320xDecoder(information) {
        return _super.call(this, information) || this;
    }
    AI01320xDecoder.prototype.addWeightCode = function (buf, weight) {
        if (weight < 10000) {
            buf.append('(3202)');
        }
        else {
            buf.append('(3203)');
        }
    };
    AI01320xDecoder.prototype.checkWeight = function (weight) {
        if (weight < 10000) {
            return weight;
        }
        return weight - 10000;
    };
    return AI01320xDecoder;
}(AI013x0xDecoder_1.default));
exports.default = AI01320xDecoder;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AI01320xDecoder.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AI01392xDecoder.js", {"../../../../NotFoundException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\NotFoundException.js","../../../../util/StringBuilder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\StringBuilder.js","./AI01decoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AI01decoder.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5Crss%5Cexpanded%5Cdecoders%5CAI01392xDecoder.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var AI01decoder_1 = require("./AI01decoder");
var NotFoundException_1 = require("../../../../NotFoundException");
var StringBuilder_1 = require("../../../../util/StringBuilder");
var AI01392xDecoder = /** @class */ (function (_super) {
    __extends(AI01392xDecoder, _super);
    function AI01392xDecoder(information) {
        return _super.call(this, information) || this;
    }
    AI01392xDecoder.prototype.parseInformation = function () {
        if (this.getInformation().getSize() < AI01392xDecoder.HEADER_SIZE + AI01decoder_1.default.GTIN_SIZE) {
            throw new NotFoundException_1.default();
        }
        var buf = new StringBuilder_1.default();
        this.encodeCompressedGtin(buf, AI01392xDecoder.HEADER_SIZE);
        var lastAIdigit = this.getGeneralDecoder().extractNumericValueFromBitArray(AI01392xDecoder.HEADER_SIZE + AI01decoder_1.default.GTIN_SIZE, AI01392xDecoder.LAST_DIGIT_SIZE);
        buf.append('(392');
        buf.append(lastAIdigit);
        buf.append(')');
        var decodedInformation = this.getGeneralDecoder().decodeGeneralPurposeField(AI01392xDecoder.HEADER_SIZE + AI01decoder_1.default.GTIN_SIZE + AI01392xDecoder.LAST_DIGIT_SIZE, null);
        buf.append(decodedInformation.getNewString());
        return buf.toString();
    };
    AI01392xDecoder.HEADER_SIZE = 5 + 1 + 2;
    AI01392xDecoder.LAST_DIGIT_SIZE = 2;
    return AI01392xDecoder;
}(AI01decoder_1.default));
exports.default = AI01392xDecoder;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AI01392xDecoder.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AI01393xDecoder.js", {"../../../../NotFoundException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\NotFoundException.js","../../../../util/StringBuilder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\StringBuilder.js","./AI01decoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AI01decoder.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5Crss%5Cexpanded%5Cdecoders%5CAI01393xDecoder.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var AI01decoder_1 = require("./AI01decoder");
var NotFoundException_1 = require("../../../../NotFoundException");
var StringBuilder_1 = require("../../../../util/StringBuilder");
var AI01393xDecoder = /** @class */ (function (_super) {
    __extends(AI01393xDecoder, _super);
    function AI01393xDecoder(information) {
        return _super.call(this, information) || this;
    }
    AI01393xDecoder.prototype.parseInformation = function () {
        if (this.getInformation().getSize() <
            AI01393xDecoder.HEADER_SIZE + AI01decoder_1.default.GTIN_SIZE) {
            throw new NotFoundException_1.default();
        }
        var buf = new StringBuilder_1.default();
        this.encodeCompressedGtin(buf, AI01393xDecoder.HEADER_SIZE);
        var lastAIdigit = this.getGeneralDecoder().extractNumericValueFromBitArray(AI01393xDecoder.HEADER_SIZE + AI01decoder_1.default.GTIN_SIZE, AI01393xDecoder.LAST_DIGIT_SIZE);
        buf.append('(393');
        buf.append(lastAIdigit);
        buf.append(')');
        var firstThreeDigits = this.getGeneralDecoder().extractNumericValueFromBitArray(AI01393xDecoder.HEADER_SIZE +
            AI01decoder_1.default.GTIN_SIZE +
            AI01393xDecoder.LAST_DIGIT_SIZE, AI01393xDecoder.FIRST_THREE_DIGITS_SIZE);
        if (firstThreeDigits / 100 === 0) {
            buf.append('0');
        }
        if (firstThreeDigits / 10 === 0) {
            buf.append('0');
        }
        buf.append(firstThreeDigits);
        var generalInformation = this.getGeneralDecoder().decodeGeneralPurposeField(AI01393xDecoder.HEADER_SIZE +
            AI01decoder_1.default.GTIN_SIZE +
            AI01393xDecoder.LAST_DIGIT_SIZE +
            AI01393xDecoder.FIRST_THREE_DIGITS_SIZE, null);
        buf.append(generalInformation.getNewString());
        return buf.toString();
    };
    AI01393xDecoder.HEADER_SIZE = 5 + 1 + 2;
    AI01393xDecoder.LAST_DIGIT_SIZE = 2;
    AI01393xDecoder.FIRST_THREE_DIGITS_SIZE = 10;
    return AI01393xDecoder;
}(AI01decoder_1.default));
exports.default = AI01393xDecoder;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AI01393xDecoder.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AI013x0x1xDecoder.js", {"../../../../NotFoundException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\NotFoundException.js","../../../../util/StringBuilder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\StringBuilder.js","./AI01weightDecoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AI01weightDecoder.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5Crss%5Cexpanded%5Cdecoders%5CAI013x0x1xDecoder.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var AI01weightDecoder_1 = require("./AI01weightDecoder");
var NotFoundException_1 = require("../../../../NotFoundException");
var StringBuilder_1 = require("../../../../util/StringBuilder");
var AI013x0x1xDecoder = /** @class */ (function (_super) {
    __extends(AI013x0x1xDecoder, _super);
    function AI013x0x1xDecoder(information, firstAIdigits, dateCode) {
        var _this = _super.call(this, information) || this;
        _this.dateCode = dateCode;
        _this.firstAIdigits = firstAIdigits;
        return _this;
    }
    AI013x0x1xDecoder.prototype.parseInformation = function () {
        if (this.getInformation().getSize() !==
            AI013x0x1xDecoder.HEADER_SIZE +
                AI013x0x1xDecoder.GTIN_SIZE +
                AI013x0x1xDecoder.WEIGHT_SIZE +
                AI013x0x1xDecoder.DATE_SIZE) {
            throw new NotFoundException_1.default();
        }
        var buf = new StringBuilder_1.default();
        this.encodeCompressedGtin(buf, AI013x0x1xDecoder.HEADER_SIZE);
        this.encodeCompressedWeight(buf, AI013x0x1xDecoder.HEADER_SIZE + AI013x0x1xDecoder.GTIN_SIZE, AI013x0x1xDecoder.WEIGHT_SIZE);
        this.encodeCompressedDate(buf, AI013x0x1xDecoder.HEADER_SIZE +
            AI013x0x1xDecoder.GTIN_SIZE +
            AI013x0x1xDecoder.WEIGHT_SIZE);
        return buf.toString();
    };
    AI013x0x1xDecoder.prototype.encodeCompressedDate = function (buf, currentPos) {
        var numericDate = this.getGeneralDecoder().extractNumericValueFromBitArray(currentPos, AI013x0x1xDecoder.DATE_SIZE);
        if (numericDate === 38400) {
            return;
        }
        buf.append('(');
        buf.append(this.dateCode);
        buf.append(')');
        var day = numericDate % 32;
        numericDate /= 32;
        var month = (numericDate % 12) + 1;
        numericDate /= 12;
        var year = numericDate;
        if (year / 10 === 0) {
            buf.append('0');
        }
        buf.append(year);
        if (month / 10 === 0) {
            buf.append('0');
        }
        buf.append(month);
        if (day / 10 === 0) {
            buf.append('0');
        }
        buf.append(day);
    };
    AI013x0x1xDecoder.prototype.addWeightCode = function (buf, weight) {
        buf.append('(');
        buf.append(this.firstAIdigits);
        buf.append(weight / 100000);
        buf.append(')');
    };
    AI013x0x1xDecoder.prototype.checkWeight = function (weight) {
        return weight % 100000;
    };
    AI013x0x1xDecoder.HEADER_SIZE = 7 + 1;
    AI013x0x1xDecoder.WEIGHT_SIZE = 20;
    AI013x0x1xDecoder.DATE_SIZE = 16;
    return AI013x0x1xDecoder;
}(AI01weightDecoder_1.default));
exports.default = AI013x0x1xDecoder;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AI013x0x1xDecoder.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AI013x0xDecoder.js", {"../../../../NotFoundException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\NotFoundException.js","../../../../util/StringBuilder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\StringBuilder.js","./AI01weightDecoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AI01weightDecoder.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5Crss%5Cexpanded%5Cdecoders%5CAI013x0xDecoder.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var AI01weightDecoder_1 = require("./AI01weightDecoder");
var StringBuilder_1 = require("../../../../util/StringBuilder");
var NotFoundException_1 = require("../../../../NotFoundException");
var AI013x0xDecoder = /** @class */ (function (_super) {
    __extends(AI013x0xDecoder, _super);
    function AI013x0xDecoder(information) {
        return _super.call(this, information) || this;
    }
    AI013x0xDecoder.prototype.parseInformation = function () {
        if (this.getInformation().getSize() !==
            AI013x0xDecoder.HEADER_SIZE +
                AI01weightDecoder_1.default.GTIN_SIZE +
                AI013x0xDecoder.WEIGHT_SIZE) {
            throw new NotFoundException_1.default();
        }
        var buf = new StringBuilder_1.default();
        this.encodeCompressedGtin(buf, AI013x0xDecoder.HEADER_SIZE);
        this.encodeCompressedWeight(buf, AI013x0xDecoder.HEADER_SIZE + AI01weightDecoder_1.default.GTIN_SIZE, AI013x0xDecoder.WEIGHT_SIZE);
        return buf.toString();
    };
    AI013x0xDecoder.HEADER_SIZE = 4 + 1;
    AI013x0xDecoder.WEIGHT_SIZE = 15;
    return AI013x0xDecoder;
}(AI01weightDecoder_1.default));
exports.default = AI013x0xDecoder;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AI013x0xDecoder.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AI01AndOtherAIs.js", {"../../../../util/StringBuilder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\StringBuilder.js","./AI01decoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AI01decoder.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5Crss%5Cexpanded%5Cdecoders%5CAI01AndOtherAIs.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var AI01decoder_1 = require("./AI01decoder");
var StringBuilder_1 = require("../../../../util/StringBuilder");
var AI01AndOtherAIs = /** @class */ (function (_super) {
    __extends(AI01AndOtherAIs, _super);
    // the second one is the encodation method, and the other two are for the variable length
    function AI01AndOtherAIs(information) {
        return _super.call(this, information) || this;
    }
    AI01AndOtherAIs.prototype.parseInformation = function () {
        var buff = new StringBuilder_1.default();
        buff.append('(01)');
        var initialGtinPosition = buff.length();
        var firstGtinDigit = this.getGeneralDecoder().extractNumericValueFromBitArray(AI01AndOtherAIs.HEADER_SIZE, 4);
        buff.append(firstGtinDigit);
        this.encodeCompressedGtinWithoutAI(buff, AI01AndOtherAIs.HEADER_SIZE + 4, initialGtinPosition);
        return this.getGeneralDecoder().decodeAllCodes(buff, AI01AndOtherAIs.HEADER_SIZE + 44);
    };
    AI01AndOtherAIs.HEADER_SIZE = 1 + 1 + 2; // first bit encodes the linkage flag,
    return AI01AndOtherAIs;
}(AI01decoder_1.default));
exports.default = AI01AndOtherAIs;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AI01AndOtherAIs.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AI01decoder.js", {"./AbstractExpandedDecoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AbstractExpandedDecoder.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5Crss%5Cexpanded%5Cdecoders%5CAI01decoder.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var AbstractExpandedDecoder_1 = require("./AbstractExpandedDecoder");
var AI01decoder = /** @class */ (function (_super) {
    __extends(AI01decoder, _super);
    function AI01decoder(information) {
        return _super.call(this, information) || this;
    }
    AI01decoder.prototype.encodeCompressedGtin = function (buf, currentPos) {
        buf.append('(01)');
        var initialPosition = buf.length();
        buf.append('9');
        this.encodeCompressedGtinWithoutAI(buf, currentPos, initialPosition);
    };
    AI01decoder.prototype.encodeCompressedGtinWithoutAI = function (buf, currentPos, initialBufferPosition) {
        for (var i = 0; i < 4; ++i) {
            var currentBlock = this.getGeneralDecoder().extractNumericValueFromBitArray(currentPos + 10 * i, 10);
            if (currentBlock / 100 === 0) {
                buf.append('0');
            }
            if (currentBlock / 10 === 0) {
                buf.append('0');
            }
            buf.append(currentBlock);
        }
        AI01decoder.appendCheckDigit(buf, initialBufferPosition);
    };
    AI01decoder.appendCheckDigit = function (buf, currentPos) {
        var checkDigit = 0;
        for (var i = 0; i < 13; i++) {
            // let digit = buf.charAt(i + currentPos) - '0';
            // To be checked
            var digit = buf.charAt(i + currentPos).charCodeAt(0) - '0'.charCodeAt(0);
            checkDigit += (i & 0x01) === 0 ? 3 * digit : digit;
        }
        checkDigit = 10 - (checkDigit % 10);
        if (checkDigit === 10) {
            checkDigit = 0;
        }
        buf.append(checkDigit);
    };
    AI01decoder.GTIN_SIZE = 40;
    return AI01decoder;
}(AbstractExpandedDecoder_1.default));
exports.default = AI01decoder;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AI01decoder.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AI01weightDecoder.js", {"./AI01decoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AI01decoder.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5Crss%5Cexpanded%5Cdecoders%5CAI01weightDecoder.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var AI01decoder_1 = require("./AI01decoder");
var AI01weightDecoder = /** @class */ (function (_super) {
    __extends(AI01weightDecoder, _super);
    function AI01weightDecoder(information) {
        return _super.call(this, information) || this;
    }
    AI01weightDecoder.prototype.encodeCompressedWeight = function (buf, currentPos, weightSize) {
        var originalWeightNumeric = this.getGeneralDecoder().extractNumericValueFromBitArray(currentPos, weightSize);
        this.addWeightCode(buf, originalWeightNumeric);
        var weightNumeric = this.checkWeight(originalWeightNumeric);
        var currentDivisor = 100000;
        for (var i = 0; i < 5; ++i) {
            if (weightNumeric / currentDivisor === 0) {
                buf.append('0');
            }
            currentDivisor /= 10;
        }
        buf.append(weightNumeric);
    };
    return AI01weightDecoder;
}(AI01decoder_1.default));
exports.default = AI01weightDecoder;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AI01weightDecoder.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AbstractExpandedDecoder.js", {"./GeneralAppIdDecoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\GeneralAppIdDecoder.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5Crss%5Cexpanded%5Cdecoders%5CAbstractExpandedDecoder.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var GeneralAppIdDecoder_1 = require("./GeneralAppIdDecoder");
var AbstractExpandedDecoder = /** @class */ (function () {
    function AbstractExpandedDecoder(information) {
        this.information = information;
        this.generalDecoder = new GeneralAppIdDecoder_1.default(information);
    }
    AbstractExpandedDecoder.prototype.getInformation = function () {
        return this.information;
    };
    AbstractExpandedDecoder.prototype.getGeneralDecoder = function () {
        return this.generalDecoder;
    };
    return AbstractExpandedDecoder;
}());
exports.default = AbstractExpandedDecoder;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AbstractExpandedDecoder.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AbstractExpandedDecoderComplement.js", {"../../../../IllegalStateException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\IllegalStateException.js","./AI013103decoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AI013103decoder.js","./AI01320xDecoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AI01320xDecoder.js","./AI01392xDecoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AI01392xDecoder.js","./AI01393xDecoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AI01393xDecoder.js","./AI013x0x1xDecoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AI013x0x1xDecoder.js","./AI01AndOtherAIs":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AI01AndOtherAIs.js","./AnyAIDecoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AnyAIDecoder.js","./GeneralAppIdDecoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\GeneralAppIdDecoder.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5Crss%5Cexpanded%5Cdecoders%5CAbstractExpandedDecoderComplement.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDecoder = void 0;
var IllegalStateException_1 = require("../../../../IllegalStateException");
var GeneralAppIdDecoder_1 = require("./GeneralAppIdDecoder");
var AI01AndOtherAIs_1 = require("./AI01AndOtherAIs");
var AnyAIDecoder_1 = require("./AnyAIDecoder");
var AI013103decoder_1 = require("./AI013103decoder");
var AI01320xDecoder_1 = require("./AI01320xDecoder");
var AI01392xDecoder_1 = require("./AI01392xDecoder");
var AI01393xDecoder_1 = require("./AI01393xDecoder");
var AI013x0x1xDecoder_1 = require("./AI013x0x1xDecoder");
function createDecoder(information) {
    try {
        if (information.get(1)) {
            return new AI01AndOtherAIs_1.default(information);
        }
        if (!information.get(2)) {
            return new AnyAIDecoder_1.default(information);
        }
        var fourBitEncodationMethod = GeneralAppIdDecoder_1.default.extractNumericValueFromBitArray(information, 1, 4);
        switch (fourBitEncodationMethod) {
            case 4: return new AI013103decoder_1.default(information);
            case 5: return new AI01320xDecoder_1.default(information);
        }
        var fiveBitEncodationMethod = GeneralAppIdDecoder_1.default.extractNumericValueFromBitArray(information, 1, 5);
        switch (fiveBitEncodationMethod) {
            case 12: return new AI01392xDecoder_1.default(information);
            case 13: return new AI01393xDecoder_1.default(information);
        }
        var sevenBitEncodationMethod = GeneralAppIdDecoder_1.default.extractNumericValueFromBitArray(information, 1, 7);
        switch (sevenBitEncodationMethod) {
            case 56: return new AI013x0x1xDecoder_1.default(information, '310', '11');
            case 57: return new AI013x0x1xDecoder_1.default(information, '320', '11');
            case 58: return new AI013x0x1xDecoder_1.default(information, '310', '13');
            case 59: return new AI013x0x1xDecoder_1.default(information, '320', '13');
            case 60: return new AI013x0x1xDecoder_1.default(information, '310', '15');
            case 61: return new AI013x0x1xDecoder_1.default(information, '320', '15');
            case 62: return new AI013x0x1xDecoder_1.default(information, '310', '17');
            case 63: return new AI013x0x1xDecoder_1.default(information, '320', '17');
        }
    }
    catch (e) {
        console.log(e);
        throw new IllegalStateException_1.default('unknown decoder: ' + information);
    }
}
exports.createDecoder = createDecoder;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AbstractExpandedDecoderComplement.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AnyAIDecoder.js", {"../../../../util/StringBuilder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\StringBuilder.js","./AbstractExpandedDecoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AbstractExpandedDecoder.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5Crss%5Cexpanded%5Cdecoders%5CAnyAIDecoder.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var StringBuilder_1 = require("../../../../util/StringBuilder");
var AbstractExpandedDecoder_1 = require("./AbstractExpandedDecoder");
var AnyAIDecoder = /** @class */ (function (_super) {
    __extends(AnyAIDecoder, _super);
    function AnyAIDecoder(information) {
        return _super.call(this, information) || this;
    }
    AnyAIDecoder.prototype.parseInformation = function () {
        var buf = new StringBuilder_1.default();
        return this.getGeneralDecoder().decodeAllCodes(buf, AnyAIDecoder.HEADER_SIZE);
    };
    AnyAIDecoder.HEADER_SIZE = 2 + 1 + 2;
    return AnyAIDecoder;
}(AbstractExpandedDecoder_1.default));
exports.default = AnyAIDecoder;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\AnyAIDecoder.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\BlockParsedResult.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5Crss%5Cexpanded%5Cdecoders%5CBlockParsedResult.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var BlockParsedResult = /** @class */ (function () {
    function BlockParsedResult(finished, decodedInformation) {
        if (decodedInformation) {
            this.decodedInformation = null;
        }
        else {
            this.finished = finished;
            this.decodedInformation = decodedInformation;
        }
    }
    BlockParsedResult.prototype.getDecodedInformation = function () {
        return this.decodedInformation;
    };
    BlockParsedResult.prototype.isFinished = function () {
        return this.finished;
    };
    return BlockParsedResult;
}());
exports.default = BlockParsedResult;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\BlockParsedResult.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\DecodedChar.js", {"./DecodedObject":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\DecodedObject.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5Crss%5Cexpanded%5Cdecoders%5CDecodedChar.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var DecodedObject_1 = require("./DecodedObject");
var DecodedChar = /** @class */ (function (_super) {
    __extends(DecodedChar, _super);
    function DecodedChar(newPosition, value) {
        var _this = _super.call(this, newPosition) || this;
        _this.value = value;
        return _this;
    }
    DecodedChar.prototype.getValue = function () {
        return this.value;
    };
    DecodedChar.prototype.isFNC1 = function () {
        return this.value === DecodedChar.FNC1;
    };
    DecodedChar.FNC1 = '$';
    return DecodedChar;
}(DecodedObject_1.default));
exports.default = DecodedChar;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\DecodedChar.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\DecodedInformation.js", {"./DecodedObject":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\DecodedObject.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5Crss%5Cexpanded%5Cdecoders%5CDecodedInformation.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var DecodedObject_1 = require("./DecodedObject");
var DecodedInformation = /** @class */ (function (_super) {
    __extends(DecodedInformation, _super);
    function DecodedInformation(newPosition, newString, remainingValue) {
        var _this = _super.call(this, newPosition) || this;
        if (remainingValue) {
            _this.remaining = true;
            _this.remainingValue = _this.remainingValue;
        }
        else {
            _this.remaining = false;
            _this.remainingValue = 0;
        }
        _this.newString = newString;
        return _this;
    }
    DecodedInformation.prototype.getNewString = function () {
        return this.newString;
    };
    DecodedInformation.prototype.isRemaining = function () {
        return this.remaining;
    };
    DecodedInformation.prototype.getRemainingValue = function () {
        return this.remainingValue;
    };
    return DecodedInformation;
}(DecodedObject_1.default));
exports.default = DecodedInformation;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\DecodedInformation.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\DecodedNumeric.js", {"../../../../FormatException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\FormatException.js","./DecodedObject":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\DecodedObject.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5Crss%5Cexpanded%5Cdecoders%5CDecodedNumeric.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var FormatException_1 = require("../../../../FormatException");
var DecodedObject_1 = require("./DecodedObject");
var DecodedNumeric = /** @class */ (function (_super) {
    __extends(DecodedNumeric, _super);
    function DecodedNumeric(newPosition, firstDigit, secondDigit) {
        var _this = _super.call(this, newPosition) || this;
        if (firstDigit < 0 || firstDigit > 10 || secondDigit < 0 || secondDigit > 10) {
            throw new FormatException_1.default();
        }
        _this.firstDigit = firstDigit;
        _this.secondDigit = secondDigit;
        return _this;
    }
    DecodedNumeric.prototype.getFirstDigit = function () {
        return this.firstDigit;
    };
    DecodedNumeric.prototype.getSecondDigit = function () {
        return this.secondDigit;
    };
    DecodedNumeric.prototype.getValue = function () {
        return this.firstDigit * 10 + this.secondDigit;
    };
    DecodedNumeric.prototype.isFirstDigitFNC1 = function () {
        return this.firstDigit === DecodedNumeric.FNC1;
    };
    DecodedNumeric.prototype.isSecondDigitFNC1 = function () {
        return this.secondDigit === DecodedNumeric.FNC1;
    };
    DecodedNumeric.prototype.isAnyFNC1 = function () {
        return this.firstDigit === DecodedNumeric.FNC1 || this.secondDigit === DecodedNumeric.FNC1;
    };
    DecodedNumeric.FNC1 = 10;
    return DecodedNumeric;
}(DecodedObject_1.default));
exports.default = DecodedNumeric;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\DecodedNumeric.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\DecodedObject.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5Crss%5Cexpanded%5Cdecoders%5CDecodedObject.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var DecodedObject = /** @class */ (function () {
    function DecodedObject(newPosition) {
        this.newPosition = newPosition;
    }
    DecodedObject.prototype.getNewPosition = function () {
        return this.newPosition;
    };
    return DecodedObject;
}());
exports.default = DecodedObject;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\DecodedObject.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\FieldParser.js", {"../../../../NotFoundException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\NotFoundException.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5Crss%5Cexpanded%5Cdecoders%5CFieldParser.js
      return function (require, module, exports) {
"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
var NotFoundException_1 = require("../../../../NotFoundException");
var FieldParser = /** @class */ (function () {
    function FieldParser() {
    }
    FieldParser.parseFieldsInGeneralPurpose = function (rawInformation) {
        var e_1, _a, e_2, _b, e_3, _c, e_4, _d;
        if (!rawInformation) {
            return null;
        }
        // Processing 2-digit AIs
        if (rawInformation.length < 2) {
            throw new NotFoundException_1.default();
        }
        var firstTwoDigits = rawInformation.substring(0, 2);
        try {
            for (var _e = __values(FieldParser.TWO_DIGIT_DATA_LENGTH), _f = _e.next(); !_f.done; _f = _e.next()) {
                var dataLength = _f.value;
                if (dataLength[0] === firstTwoDigits) {
                    if (dataLength[1] === FieldParser.VARIABLE_LENGTH) {
                        return FieldParser.processVariableAI(2, dataLength[2], rawInformation);
                    }
                    return FieldParser.processFixedAI(2, dataLength[1], rawInformation);
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_f && !_f.done && (_a = _e.return)) _a.call(_e);
            }
            finally { if (e_1) throw e_1.error; }
        }
        if (rawInformation.length < 3) {
            throw new NotFoundException_1.default();
        }
        var firstThreeDigits = rawInformation.substring(0, 3);
        try {
            for (var _g = __values(FieldParser.THREE_DIGIT_DATA_LENGTH), _h = _g.next(); !_h.done; _h = _g.next()) {
                var dataLength = _h.value;
                if (dataLength[0] === firstThreeDigits) {
                    if (dataLength[1] === FieldParser.VARIABLE_LENGTH) {
                        return FieldParser.processVariableAI(3, dataLength[2], rawInformation);
                    }
                    return FieldParser.processFixedAI(3, dataLength[1], rawInformation);
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_h && !_h.done && (_b = _g.return)) _b.call(_g);
            }
            finally { if (e_2) throw e_2.error; }
        }
        try {
            for (var _j = __values(FieldParser.THREE_DIGIT_PLUS_DIGIT_DATA_LENGTH), _k = _j.next(); !_k.done; _k = _j.next()) {
                var dataLength = _k.value;
                if (dataLength[0] === firstThreeDigits) {
                    if (dataLength[1] === FieldParser.VARIABLE_LENGTH) {
                        return FieldParser.processVariableAI(4, dataLength[2], rawInformation);
                    }
                    return FieldParser.processFixedAI(4, dataLength[1], rawInformation);
                }
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (_k && !_k.done && (_c = _j.return)) _c.call(_j);
            }
            finally { if (e_3) throw e_3.error; }
        }
        if (rawInformation.length < 4) {
            throw new NotFoundException_1.default();
        }
        var firstFourDigits = rawInformation.substring(0, 4);
        try {
            for (var _l = __values(FieldParser.FOUR_DIGIT_DATA_LENGTH), _m = _l.next(); !_m.done; _m = _l.next()) {
                var dataLength = _m.value;
                if (dataLength[0] === firstFourDigits) {
                    if (dataLength[1] === FieldParser.VARIABLE_LENGTH) {
                        return FieldParser.processVariableAI(4, dataLength[2], rawInformation);
                    }
                    return FieldParser.processFixedAI(4, dataLength[1], rawInformation);
                }
            }
        }
        catch (e_4_1) { e_4 = { error: e_4_1 }; }
        finally {
            try {
                if (_m && !_m.done && (_d = _l.return)) _d.call(_l);
            }
            finally { if (e_4) throw e_4.error; }
        }
        throw new NotFoundException_1.default();
    };
    FieldParser.processFixedAI = function (aiSize, fieldSize, rawInformation) {
        if (rawInformation.length < aiSize) {
            throw new NotFoundException_1.default();
        }
        var ai = rawInformation.substring(0, aiSize);
        if (rawInformation.length < aiSize + fieldSize) {
            throw new NotFoundException_1.default();
        }
        var field = rawInformation.substring(aiSize, aiSize + fieldSize);
        var remaining = rawInformation.substring(aiSize + fieldSize);
        var result = '(' + ai + ')' + field;
        var parsedAI = FieldParser.parseFieldsInGeneralPurpose(remaining);
        return parsedAI == null ? result : result + parsedAI;
    };
    FieldParser.processVariableAI = function (aiSize, variableFieldSize, rawInformation) {
        var ai = rawInformation.substring(0, aiSize);
        var maxSize;
        if (rawInformation.length < aiSize + variableFieldSize) {
            maxSize = rawInformation.length;
        }
        else {
            maxSize = aiSize + variableFieldSize;
        }
        var field = rawInformation.substring(aiSize, maxSize);
        var remaining = rawInformation.substring(maxSize);
        var result = '(' + ai + ')' + field;
        var parsedAI = FieldParser.parseFieldsInGeneralPurpose(remaining);
        return parsedAI == null ? result : result + parsedAI;
    };
    FieldParser.VARIABLE_LENGTH = [];
    FieldParser.TWO_DIGIT_DATA_LENGTH = [
        ['00', 18],
        ['01', 14],
        ['02', 14],
        ['10', FieldParser.VARIABLE_LENGTH, 20],
        ['11', 6],
        ['12', 6],
        ['13', 6],
        ['15', 6],
        ['17', 6],
        ['20', 2],
        ['21', FieldParser.VARIABLE_LENGTH, 20],
        ['22', FieldParser.VARIABLE_LENGTH, 29],
        ['30', FieldParser.VARIABLE_LENGTH, 8],
        ['37', FieldParser.VARIABLE_LENGTH, 8],
        // internal company codes
        ['90', FieldParser.VARIABLE_LENGTH, 30],
        ['91', FieldParser.VARIABLE_LENGTH, 30],
        ['92', FieldParser.VARIABLE_LENGTH, 30],
        ['93', FieldParser.VARIABLE_LENGTH, 30],
        ['94', FieldParser.VARIABLE_LENGTH, 30],
        ['95', FieldParser.VARIABLE_LENGTH, 30],
        ['96', FieldParser.VARIABLE_LENGTH, 30],
        ['97', FieldParser.VARIABLE_LENGTH, 3],
        ['98', FieldParser.VARIABLE_LENGTH, 30],
        ['99', FieldParser.VARIABLE_LENGTH, 30],
    ];
    FieldParser.THREE_DIGIT_DATA_LENGTH = [
        // Same format as above
        ['240', FieldParser.VARIABLE_LENGTH, 30],
        ['241', FieldParser.VARIABLE_LENGTH, 30],
        ['242', FieldParser.VARIABLE_LENGTH, 6],
        ['250', FieldParser.VARIABLE_LENGTH, 30],
        ['251', FieldParser.VARIABLE_LENGTH, 30],
        ['253', FieldParser.VARIABLE_LENGTH, 17],
        ['254', FieldParser.VARIABLE_LENGTH, 20],
        ['400', FieldParser.VARIABLE_LENGTH, 30],
        ['401', FieldParser.VARIABLE_LENGTH, 30],
        ['402', 17],
        ['403', FieldParser.VARIABLE_LENGTH, 30],
        ['410', 13],
        ['411', 13],
        ['412', 13],
        ['413', 13],
        ['414', 13],
        ['420', FieldParser.VARIABLE_LENGTH, 20],
        ['421', FieldParser.VARIABLE_LENGTH, 15],
        ['422', 3],
        ['423', FieldParser.VARIABLE_LENGTH, 15],
        ['424', 3],
        ['425', 3],
        ['426', 3],
    ];
    FieldParser.THREE_DIGIT_PLUS_DIGIT_DATA_LENGTH = [
        // Same format as above
        ['310', 6],
        ['311', 6],
        ['312', 6],
        ['313', 6],
        ['314', 6],
        ['315', 6],
        ['316', 6],
        ['320', 6],
        ['321', 6],
        ['322', 6],
        ['323', 6],
        ['324', 6],
        ['325', 6],
        ['326', 6],
        ['327', 6],
        ['328', 6],
        ['329', 6],
        ['330', 6],
        ['331', 6],
        ['332', 6],
        ['333', 6],
        ['334', 6],
        ['335', 6],
        ['336', 6],
        ['340', 6],
        ['341', 6],
        ['342', 6],
        ['343', 6],
        ['344', 6],
        ['345', 6],
        ['346', 6],
        ['347', 6],
        ['348', 6],
        ['349', 6],
        ['350', 6],
        ['351', 6],
        ['352', 6],
        ['353', 6],
        ['354', 6],
        ['355', 6],
        ['356', 6],
        ['357', 6],
        ['360', 6],
        ['361', 6],
        ['362', 6],
        ['363', 6],
        ['364', 6],
        ['365', 6],
        ['366', 6],
        ['367', 6],
        ['368', 6],
        ['369', 6],
        ['390', FieldParser.VARIABLE_LENGTH, 15],
        ['391', FieldParser.VARIABLE_LENGTH, 18],
        ['392', FieldParser.VARIABLE_LENGTH, 15],
        ['393', FieldParser.VARIABLE_LENGTH, 18],
        ['703', FieldParser.VARIABLE_LENGTH, 30],
    ];
    FieldParser.FOUR_DIGIT_DATA_LENGTH = [
        // Same format as above
        ['7001', 13],
        ['7002', FieldParser.VARIABLE_LENGTH, 30],
        ['7003', 10],
        ['8001', 14],
        ['8002', FieldParser.VARIABLE_LENGTH, 20],
        ['8003', FieldParser.VARIABLE_LENGTH, 30],
        ['8004', FieldParser.VARIABLE_LENGTH, 30],
        ['8005', 6],
        ['8006', 18],
        ['8007', FieldParser.VARIABLE_LENGTH, 30],
        ['8008', FieldParser.VARIABLE_LENGTH, 12],
        ['8018', 18],
        ['8020', FieldParser.VARIABLE_LENGTH, 25],
        ['8100', 6],
        ['8101', 10],
        ['8102', 2],
        ['8110', FieldParser.VARIABLE_LENGTH, 70],
        ['8200', FieldParser.VARIABLE_LENGTH, 70],
    ];
    return FieldParser;
}());
exports.default = FieldParser;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\FieldParser.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\GeneralAppIdDecoder.js", {"../../../../FormatException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\FormatException.js","../../../../IllegalStateException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\IllegalStateException.js","../../../../util/StringBuilder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\StringBuilder.js","./BlockParsedResult":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\BlockParsedResult.js","./DecodedChar":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\DecodedChar.js","./DecodedInformation":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\DecodedInformation.js","./DecodedNumeric":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\DecodedNumeric.js","./FieldParser":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\FieldParser.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Coned%5Crss%5Cexpanded%5Cdecoders%5CGeneralAppIdDecoder.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var FormatException_1 = require("../../../../FormatException");
var IllegalStateException_1 = require("../../../../IllegalStateException");
var StringBuilder_1 = require("../../../../util/StringBuilder");
var BlockParsedResult_1 = require("./BlockParsedResult");
var DecodedChar_1 = require("./DecodedChar");
var DecodedInformation_1 = require("./DecodedInformation");
var DecodedNumeric_1 = require("./DecodedNumeric");
var FieldParser_1 = require("./FieldParser");
var GeneralAppIdDecoder = /** @class */ (function () {
    function GeneralAppIdDecoder(information) {
        this.buffer = new StringBuilder_1.default();
        this.information = information;
    }
    GeneralAppIdDecoder.prototype.decodeAllCodes = function (buff, initialPosition) {
        var currentPosition = initialPosition;
        var remaining = null;
        do {
            var info = this.decodeGeneralPurposeField(currentPosition, remaining);
            var parsedFields = FieldParser_1.default.parseFieldsInGeneralPurpose(info.getNewString());
            if (parsedFields != null) {
                buff.append(parsedFields);
            }
            if (info.isRemaining()) {
                remaining = '' + info.getRemainingValue();
            }
            else {
                remaining = null;
            }
            if (currentPosition === info.getNewPosition()) { // No step forward!
                break;
            }
            currentPosition = info.getNewPosition();
        } while (true);
        return buff.toString();
    };
    GeneralAppIdDecoder.prototype.isStillNumeric = function (pos) {
        // It's numeric if it still has 7 positions
        // and one of the first 4 bits is "1".
        if (pos + 7 > this.information.getSize()) {
            return pos + 4 <= this.information.getSize();
        }
        for (var i = pos; i < pos + 3; ++i) {
            if (this.information.get(i)) {
                return true;
            }
        }
        return this.information.get(pos + 3);
    };
    GeneralAppIdDecoder.prototype.decodeNumeric = function (pos) {
        if (pos + 7 > this.information.getSize()) {
            var numeric_1 = this.extractNumericValueFromBitArray(pos, 4);
            if (numeric_1 === 0) {
                return new DecodedNumeric_1.default(this.information.getSize(), DecodedNumeric_1.default.FNC1, DecodedNumeric_1.default.FNC1);
            }
            return new DecodedNumeric_1.default(this.information.getSize(), numeric_1 - 1, DecodedNumeric_1.default.FNC1);
        }
        var numeric = this.extractNumericValueFromBitArray(pos, 7);
        var digit1 = (numeric - 8) / 11;
        var digit2 = (numeric - 8) % 11;
        return new DecodedNumeric_1.default(pos + 7, digit1, digit2);
    };
    GeneralAppIdDecoder.prototype.extractNumericValueFromBitArray = function (pos, bits) {
        return GeneralAppIdDecoder.extractNumericValueFromBitArray(this.information, pos, bits);
    };
    GeneralAppIdDecoder.extractNumericValueFromBitArray = function (information, pos, bits) {
        var value = 0;
        for (var i = 0; i < bits; ++i) {
            if (information.get(pos + i)) {
                value |= 1 << (bits - i - 1);
            }
        }
        return value;
    };
    GeneralAppIdDecoder.prototype.decodeGeneralPurposeField = function (pos, remaining) {
        // this.buffer.setLength(0);
        this.buffer.setLengthToZero();
        if (remaining != null) {
            this.buffer.append(remaining);
        }
        this.current.setPosition(pos);
        var lastDecoded = this.parseBlocks();
        if (lastDecoded != null && lastDecoded.isRemaining()) {
            return new DecodedInformation_1.default(this.current.getPosition(), this.buffer.toString(), lastDecoded.getRemainingValue());
        }
        return new DecodedInformation_1.default(this.current.getPosition(), this.buffer.toString());
    };
    GeneralAppIdDecoder.prototype.parseBlocks = function () {
        var isFinished;
        var result;
        do {
            var initialPosition = this.current.getPosition();
            if (this.current.isAlpha()) {
                result = this.parseAlphaBlock();
                isFinished = result.isFinished();
            }
            else if (this.current.isIsoIec646()) {
                result = this.parseIsoIec646Block();
                isFinished = result.isFinished();
            }
            else { // it must be numeric
                result = this.parseNumericBlock();
                isFinished = result.isFinished();
            }
            var positionChanged = initialPosition !== this.current.getPosition();
            if (!positionChanged && !isFinished) {
                break;
            }
        } while (!isFinished);
        return result.getDecodedInformation();
    };
    GeneralAppIdDecoder.prototype.parseNumericBlock = function () {
        while (this.isStillNumeric(this.current.getPosition())) {
            var numeric = this.decodeNumeric(this.current.getPosition());
            this.current.setPosition(numeric.getNewPosition());
            if (numeric.isFirstDigitFNC1()) {
                var information = void 0;
                if (numeric.isSecondDigitFNC1()) {
                    information = new DecodedInformation_1.default(this.current.getPosition(), this.buffer.toString());
                }
                else {
                    information = new DecodedInformation_1.default(this.current.getPosition(), this.buffer.toString(), numeric.getSecondDigit());
                }
                return new BlockParsedResult_1.default(true, information);
            }
            this.buffer.append(numeric.getFirstDigit());
            if (numeric.isSecondDigitFNC1()) {
                var information = new DecodedInformation_1.default(this.current.getPosition(), this.buffer.toString());
                return new BlockParsedResult_1.default(true, information);
            }
            this.buffer.append(numeric.getSecondDigit());
        }
        if (this.isNumericToAlphaNumericLatch(this.current.getPosition())) {
            this.current.setAlpha();
            this.current.incrementPosition(4);
        }
        return new BlockParsedResult_1.default(false);
    };
    GeneralAppIdDecoder.prototype.parseIsoIec646Block = function () {
        while (this.isStillIsoIec646(this.current.getPosition())) {
            var iso = this.decodeIsoIec646(this.current.getPosition());
            this.current.setPosition(iso.getNewPosition());
            if (iso.isFNC1()) {
                var information = new DecodedInformation_1.default(this.current.getPosition(), this.buffer.toString());
                return new BlockParsedResult_1.default(true, information);
            }
            this.buffer.append(iso.getValue());
        }
        if (this.isAlphaOr646ToNumericLatch(this.current.getPosition())) {
            this.current.incrementPosition(3);
            this.current.setNumeric();
        }
        else if (this.isAlphaTo646ToAlphaLatch(this.current.getPosition())) {
            if (this.current.getPosition() + 5 < this.information.getSize()) {
                this.current.incrementPosition(5);
            }
            else {
                this.current.setPosition(this.information.getSize());
            }
            this.current.setAlpha();
        }
        return new BlockParsedResult_1.default(false);
    };
    GeneralAppIdDecoder.prototype.parseAlphaBlock = function () {
        while (this.isStillAlpha(this.current.getPosition())) {
            var alpha = this.decodeAlphanumeric(this.current.getPosition());
            this.current.setPosition(alpha.getNewPosition());
            if (alpha.isFNC1()) {
                var information = new DecodedInformation_1.default(this.current.getPosition(), this.buffer.toString());
                return new BlockParsedResult_1.default(true, information); // end of the char block
            }
            this.buffer.append(alpha.getValue());
        }
        if (this.isAlphaOr646ToNumericLatch(this.current.getPosition())) {
            this.current.incrementPosition(3);
            this.current.setNumeric();
        }
        else if (this.isAlphaTo646ToAlphaLatch(this.current.getPosition())) {
            if (this.current.getPosition() + 5 < this.information.getSize()) {
                this.current.incrementPosition(5);
            }
            else {
                this.current.setPosition(this.information.getSize());
            }
            this.current.setIsoIec646();
        }
        return new BlockParsedResult_1.default(false);
    };
    GeneralAppIdDecoder.prototype.isStillIsoIec646 = function (pos) {
        if (pos + 5 > this.information.getSize()) {
            return false;
        }
        var fiveBitValue = this.extractNumericValueFromBitArray(pos, 5);
        if (fiveBitValue >= 5 && fiveBitValue < 16) {
            return true;
        }
        if (pos + 7 > this.information.getSize()) {
            return false;
        }
        var sevenBitValue = this.extractNumericValueFromBitArray(pos, 7);
        if (sevenBitValue >= 64 && sevenBitValue < 116) {
            return true;
        }
        if (pos + 8 > this.information.getSize()) {
            return false;
        }
        var eightBitValue = this.extractNumericValueFromBitArray(pos, 8);
        return eightBitValue >= 232 && eightBitValue < 253;
    };
    GeneralAppIdDecoder.prototype.decodeIsoIec646 = function (pos) {
        var fiveBitValue = this.extractNumericValueFromBitArray(pos, 5);
        if (fiveBitValue === 15) {
            return new DecodedChar_1.default(pos + 5, DecodedChar_1.default.FNC1);
        }
        if (fiveBitValue >= 5 && fiveBitValue < 15) {
            return new DecodedChar_1.default(pos + 5, ('0' + (fiveBitValue - 5)));
        }
        var sevenBitValue = this.extractNumericValueFromBitArray(pos, 7);
        if (sevenBitValue >= 64 && sevenBitValue < 90) {
            return new DecodedChar_1.default(pos + 7, ('' + (sevenBitValue + 1)));
        }
        if (sevenBitValue >= 90 && sevenBitValue < 116) {
            return new DecodedChar_1.default(pos + 7, ('' + (sevenBitValue + 7)));
        }
        var eightBitValue = this.extractNumericValueFromBitArray(pos, 8);
        var c;
        switch (eightBitValue) {
            case 232:
                c = '!';
                break;
            case 233:
                c = '"';
                break;
            case 234:
                c = '%';
                break;
            case 235:
                c = '&';
                break;
            case 236:
                c = '\'';
                break;
            case 237:
                c = '(';
                break;
            case 238:
                c = ')';
                break;
            case 239:
                c = '*';
                break;
            case 240:
                c = '+';
                break;
            case 241:
                c = ',';
                break;
            case 242:
                c = '-';
                break;
            case 243:
                c = '.';
                break;
            case 244:
                c = '/';
                break;
            case 245:
                c = ':';
                break;
            case 246:
                c = ';';
                break;
            case 247:
                c = '<';
                break;
            case 248:
                c = '=';
                break;
            case 249:
                c = '>';
                break;
            case 250:
                c = '?';
                break;
            case 251:
                c = '_';
                break;
            case 252:
                c = ' ';
                break;
            default:
                throw new FormatException_1.default();
        }
        return new DecodedChar_1.default(pos + 8, c);
    };
    GeneralAppIdDecoder.prototype.isStillAlpha = function (pos) {
        if (pos + 5 > this.information.getSize()) {
            return false;
        }
        // We now check if it's a valid 5-bit value (0..9 and FNC1)
        var fiveBitValue = this.extractNumericValueFromBitArray(pos, 5);
        if (fiveBitValue >= 5 && fiveBitValue < 16) {
            return true;
        }
        if (pos + 6 > this.information.getSize()) {
            return false;
        }
        var sixBitValue = this.extractNumericValueFromBitArray(pos, 6);
        return sixBitValue >= 16 && sixBitValue < 63; // 63 not included
    };
    GeneralAppIdDecoder.prototype.decodeAlphanumeric = function (pos) {
        var fiveBitValue = this.extractNumericValueFromBitArray(pos, 5);
        if (fiveBitValue === 15) {
            return new DecodedChar_1.default(pos + 5, DecodedChar_1.default.FNC1);
        }
        if (fiveBitValue >= 5 && fiveBitValue < 15) {
            return new DecodedChar_1.default(pos + 5, ('0' + (fiveBitValue - 5)));
        }
        var sixBitValue = this.extractNumericValueFromBitArray(pos, 6);
        if (sixBitValue >= 32 && sixBitValue < 58) {
            return new DecodedChar_1.default(pos + 6, ('' + (sixBitValue + 33)));
        }
        var c;
        switch (sixBitValue) {
            case 58:
                c = '*';
                break;
            case 59:
                c = ',';
                break;
            case 60:
                c = '-';
                break;
            case 61:
                c = '.';
                break;
            case 62:
                c = '/';
                break;
            default:
                throw new IllegalStateException_1.default('Decoding invalid alphanumeric value: ' + sixBitValue);
        }
        return new DecodedChar_1.default(pos + 6, c);
    };
    GeneralAppIdDecoder.prototype.isAlphaTo646ToAlphaLatch = function (pos) {
        if (pos + 1 > this.information.getSize()) {
            return false;
        }
        for (var i = 0; i < 5 && i + pos < this.information.getSize(); ++i) {
            if (i === 2) {
                if (!this.information.get(pos + 2)) {
                    return false;
                }
            }
            else if (this.information.get(pos + i)) {
                return false;
            }
        }
        return true;
    };
    GeneralAppIdDecoder.prototype.isAlphaOr646ToNumericLatch = function (pos) {
        // Next is alphanumeric if there are 3 positions and they are all zeros
        if (pos + 3 > this.information.getSize()) {
            return false;
        }
        for (var i = pos; i < pos + 3; ++i) {
            if (this.information.get(i)) {
                return false;
            }
        }
        return true;
    };
    GeneralAppIdDecoder.prototype.isNumericToAlphaNumericLatch = function (pos) {
        // Next is alphanumeric if there are 4 positions and they are all zeros, or
        // if there is a subset of this just before the end of the symbol
        if (pos + 1 > this.information.getSize()) {
            return false;
        }
        for (var i = 0; i < 4 && i + pos < this.information.getSize(); ++i) {
            if (this.information.get(pos + i)) {
                return false;
            }
        }
        return true;
    };
    return GeneralAppIdDecoder;
}());
exports.default = GeneralAppIdDecoder;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\oned\\rss\\expanded\\decoders\\GeneralAppIdDecoder.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\PDF417Common.js", {"../common/detector/MathUtils":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\detector\\MathUtils.js","../util/Arrays":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\Arrays.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cpdf417%5CPDF417Common.js
      return function (require, module, exports) {
"use strict";
/*
* Copyright 2009 ZXing authors
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
// package com.google.zxing.pdf417;
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
// import java.util.Arrays;
var Arrays_1 = require("../util/Arrays");
// import java.util.Collection;
// import com.google.zxing.common.detector.MathUtils;
var MathUtils_1 = require("../common/detector/MathUtils");
/**
 * @author SITA Lab (kevin.osullivan@sita.aero)
 * @author Guenther Grau
 */
var PDF417Common = /** @class */ (function () {
    function PDF417Common() {
    }
    PDF417Common.prototype.PDF417Common = function () {
    };
    /**
     * @param moduleBitCount values to sum
     * @return sum of values
     * @deprecated call {@link MathUtils#sum(int[])}
     */
    // @Deprecated
    PDF417Common.getBitCountSum = function (moduleBitCount) {
        return MathUtils_1.default.sum(moduleBitCount);
    };
    PDF417Common.toIntArray = function (list) {
        var e_1, _a;
        if (list == null || !list.length) {
            return PDF417Common.EMPTY_INT_ARRAY;
        }
        var result = new Int32Array(list.length);
        var i = 0;
        try {
            for (var list_1 = __values(list), list_1_1 = list_1.next(); !list_1_1.done; list_1_1 = list_1.next()) {
                var integer = list_1_1.value;
                result[i++] = integer;
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (list_1_1 && !list_1_1.done && (_a = list_1.return)) _a.call(list_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return result;
    };
    /**
     * @param symbol encoded symbol to translate to a codeword
     * @return the codeword corresponding to the symbol.
     */
    PDF417Common.getCodeword = function (symbol /*int*/) {
        var i = Arrays_1.default.binarySearch(PDF417Common.SYMBOL_TABLE, symbol & 0x3FFFF);
        if (i < 0) {
            return -1;
        }
        return (PDF417Common.CODEWORD_TABLE[i] - 1) % PDF417Common.NUMBER_OF_CODEWORDS;
    };
    PDF417Common.NUMBER_OF_CODEWORDS = 929;
    // Maximum Codewords (Data + Error).
    PDF417Common.MAX_CODEWORDS_IN_BARCODE = PDF417Common.NUMBER_OF_CODEWORDS - 1;
    PDF417Common.MIN_ROWS_IN_BARCODE = 3;
    PDF417Common.MAX_ROWS_IN_BARCODE = 90;
    // One left row indication column + max 30 data columns + one right row indicator column
    // public static /*final*/ MAX_CODEWORDS_IN_ROW: /*int*/ number = 32;
    PDF417Common.MODULES_IN_CODEWORD = 17;
    PDF417Common.MODULES_IN_STOP_PATTERN = 18;
    PDF417Common.BARS_IN_MODULE = 8;
    PDF417Common.EMPTY_INT_ARRAY = new Int32Array([]);
    /**
     * The sorted table of all possible symbols. Extracted from the PDF417
     * specification. The index of a symbol in this table corresponds to the
     * index into the codeword table.
     */
    PDF417Common.SYMBOL_TABLE = Int32Array.from([
        0x1025e, 0x1027a, 0x1029e, 0x102bc, 0x102f2, 0x102f4, 0x1032e, 0x1034e, 0x1035c, 0x10396, 0x103a6, 0x103ac,
        0x10422, 0x10428, 0x10436, 0x10442, 0x10444, 0x10448, 0x10450, 0x1045e, 0x10466, 0x1046c, 0x1047a, 0x10482,
        0x1049e, 0x104a0, 0x104bc, 0x104c6, 0x104d8, 0x104ee, 0x104f2, 0x104f4, 0x10504, 0x10508, 0x10510, 0x1051e,
        0x10520, 0x1053c, 0x10540, 0x10578, 0x10586, 0x1058c, 0x10598, 0x105b0, 0x105be, 0x105ce, 0x105dc, 0x105e2,
        0x105e4, 0x105e8, 0x105f6, 0x1062e, 0x1064e, 0x1065c, 0x1068e, 0x1069c, 0x106b8, 0x106de, 0x106fa, 0x10716,
        0x10726, 0x1072c, 0x10746, 0x1074c, 0x10758, 0x1076e, 0x10792, 0x10794, 0x107a2, 0x107a4, 0x107a8, 0x107b6,
        0x10822, 0x10828, 0x10842, 0x10848, 0x10850, 0x1085e, 0x10866, 0x1086c, 0x1087a, 0x10882, 0x10884, 0x10890,
        0x1089e, 0x108a0, 0x108bc, 0x108c6, 0x108cc, 0x108d8, 0x108ee, 0x108f2, 0x108f4, 0x10902, 0x10908, 0x1091e,
        0x10920, 0x1093c, 0x10940, 0x10978, 0x10986, 0x10998, 0x109b0, 0x109be, 0x109ce, 0x109dc, 0x109e2, 0x109e4,
        0x109e8, 0x109f6, 0x10a08, 0x10a10, 0x10a1e, 0x10a20, 0x10a3c, 0x10a40, 0x10a78, 0x10af0, 0x10b06, 0x10b0c,
        0x10b18, 0x10b30, 0x10b3e, 0x10b60, 0x10b7c, 0x10b8e, 0x10b9c, 0x10bb8, 0x10bc2, 0x10bc4, 0x10bc8, 0x10bd0,
        0x10bde, 0x10be6, 0x10bec, 0x10c2e, 0x10c4e, 0x10c5c, 0x10c62, 0x10c64, 0x10c68, 0x10c76, 0x10c8e, 0x10c9c,
        0x10cb8, 0x10cc2, 0x10cc4, 0x10cc8, 0x10cd0, 0x10cde, 0x10ce6, 0x10cec, 0x10cfa, 0x10d0e, 0x10d1c, 0x10d38,
        0x10d70, 0x10d7e, 0x10d82, 0x10d84, 0x10d88, 0x10d90, 0x10d9e, 0x10da0, 0x10dbc, 0x10dc6, 0x10dcc, 0x10dd8,
        0x10dee, 0x10df2, 0x10df4, 0x10e16, 0x10e26, 0x10e2c, 0x10e46, 0x10e58, 0x10e6e, 0x10e86, 0x10e8c, 0x10e98,
        0x10eb0, 0x10ebe, 0x10ece, 0x10edc, 0x10f0a, 0x10f12, 0x10f14, 0x10f22, 0x10f28, 0x10f36, 0x10f42, 0x10f44,
        0x10f48, 0x10f50, 0x10f5e, 0x10f66, 0x10f6c, 0x10fb2, 0x10fb4, 0x11022, 0x11028, 0x11042, 0x11048, 0x11050,
        0x1105e, 0x1107a, 0x11082, 0x11084, 0x11090, 0x1109e, 0x110a0, 0x110bc, 0x110c6, 0x110cc, 0x110d8, 0x110ee,
        0x110f2, 0x110f4, 0x11102, 0x1111e, 0x11120, 0x1113c, 0x11140, 0x11178, 0x11186, 0x11198, 0x111b0, 0x111be,
        0x111ce, 0x111dc, 0x111e2, 0x111e4, 0x111e8, 0x111f6, 0x11208, 0x1121e, 0x11220, 0x11278, 0x112f0, 0x1130c,
        0x11330, 0x1133e, 0x11360, 0x1137c, 0x1138e, 0x1139c, 0x113b8, 0x113c2, 0x113c8, 0x113d0, 0x113de, 0x113e6,
        0x113ec, 0x11408, 0x11410, 0x1141e, 0x11420, 0x1143c, 0x11440, 0x11478, 0x114f0, 0x115e0, 0x1160c, 0x11618,
        0x11630, 0x1163e, 0x11660, 0x1167c, 0x116c0, 0x116f8, 0x1171c, 0x11738, 0x11770, 0x1177e, 0x11782, 0x11784,
        0x11788, 0x11790, 0x1179e, 0x117a0, 0x117bc, 0x117c6, 0x117cc, 0x117d8, 0x117ee, 0x1182e, 0x11834, 0x1184e,
        0x1185c, 0x11862, 0x11864, 0x11868, 0x11876, 0x1188e, 0x1189c, 0x118b8, 0x118c2, 0x118c8, 0x118d0, 0x118de,
        0x118e6, 0x118ec, 0x118fa, 0x1190e, 0x1191c, 0x11938, 0x11970, 0x1197e, 0x11982, 0x11984, 0x11990, 0x1199e,
        0x119a0, 0x119bc, 0x119c6, 0x119cc, 0x119d8, 0x119ee, 0x119f2, 0x119f4, 0x11a0e, 0x11a1c, 0x11a38, 0x11a70,
        0x11a7e, 0x11ae0, 0x11afc, 0x11b08, 0x11b10, 0x11b1e, 0x11b20, 0x11b3c, 0x11b40, 0x11b78, 0x11b8c, 0x11b98,
        0x11bb0, 0x11bbe, 0x11bce, 0x11bdc, 0x11be2, 0x11be4, 0x11be8, 0x11bf6, 0x11c16, 0x11c26, 0x11c2c, 0x11c46,
        0x11c4c, 0x11c58, 0x11c6e, 0x11c86, 0x11c98, 0x11cb0, 0x11cbe, 0x11cce, 0x11cdc, 0x11ce2, 0x11ce4, 0x11ce8,
        0x11cf6, 0x11d06, 0x11d0c, 0x11d18, 0x11d30, 0x11d3e, 0x11d60, 0x11d7c, 0x11d8e, 0x11d9c, 0x11db8, 0x11dc4,
        0x11dc8, 0x11dd0, 0x11dde, 0x11de6, 0x11dec, 0x11dfa, 0x11e0a, 0x11e12, 0x11e14, 0x11e22, 0x11e24, 0x11e28,
        0x11e36, 0x11e42, 0x11e44, 0x11e50, 0x11e5e, 0x11e66, 0x11e6c, 0x11e82, 0x11e84, 0x11e88, 0x11e90, 0x11e9e,
        0x11ea0, 0x11ebc, 0x11ec6, 0x11ecc, 0x11ed8, 0x11eee, 0x11f1a, 0x11f2e, 0x11f32, 0x11f34, 0x11f4e, 0x11f5c,
        0x11f62, 0x11f64, 0x11f68, 0x11f76, 0x12048, 0x1205e, 0x12082, 0x12084, 0x12090, 0x1209e, 0x120a0, 0x120bc,
        0x120d8, 0x120f2, 0x120f4, 0x12108, 0x1211e, 0x12120, 0x1213c, 0x12140, 0x12178, 0x12186, 0x12198, 0x121b0,
        0x121be, 0x121e2, 0x121e4, 0x121e8, 0x121f6, 0x12204, 0x12210, 0x1221e, 0x12220, 0x12278, 0x122f0, 0x12306,
        0x1230c, 0x12330, 0x1233e, 0x12360, 0x1237c, 0x1238e, 0x1239c, 0x123b8, 0x123c2, 0x123c8, 0x123d0, 0x123e6,
        0x123ec, 0x1241e, 0x12420, 0x1243c, 0x124f0, 0x125e0, 0x12618, 0x1263e, 0x12660, 0x1267c, 0x126c0, 0x126f8,
        0x12738, 0x12770, 0x1277e, 0x12782, 0x12784, 0x12790, 0x1279e, 0x127a0, 0x127bc, 0x127c6, 0x127cc, 0x127d8,
        0x127ee, 0x12820, 0x1283c, 0x12840, 0x12878, 0x128f0, 0x129e0, 0x12bc0, 0x12c18, 0x12c30, 0x12c3e, 0x12c60,
        0x12c7c, 0x12cc0, 0x12cf8, 0x12df0, 0x12e1c, 0x12e38, 0x12e70, 0x12e7e, 0x12ee0, 0x12efc, 0x12f04, 0x12f08,
        0x12f10, 0x12f20, 0x12f3c, 0x12f40, 0x12f78, 0x12f86, 0x12f8c, 0x12f98, 0x12fb0, 0x12fbe, 0x12fce, 0x12fdc,
        0x1302e, 0x1304e, 0x1305c, 0x13062, 0x13068, 0x1308e, 0x1309c, 0x130b8, 0x130c2, 0x130c8, 0x130d0, 0x130de,
        0x130ec, 0x130fa, 0x1310e, 0x13138, 0x13170, 0x1317e, 0x13182, 0x13184, 0x13190, 0x1319e, 0x131a0, 0x131bc,
        0x131c6, 0x131cc, 0x131d8, 0x131f2, 0x131f4, 0x1320e, 0x1321c, 0x13270, 0x1327e, 0x132e0, 0x132fc, 0x13308,
        0x1331e, 0x13320, 0x1333c, 0x13340, 0x13378, 0x13386, 0x13398, 0x133b0, 0x133be, 0x133ce, 0x133dc, 0x133e2,
        0x133e4, 0x133e8, 0x133f6, 0x1340e, 0x1341c, 0x13438, 0x13470, 0x1347e, 0x134e0, 0x134fc, 0x135c0, 0x135f8,
        0x13608, 0x13610, 0x1361e, 0x13620, 0x1363c, 0x13640, 0x13678, 0x136f0, 0x1370c, 0x13718, 0x13730, 0x1373e,
        0x13760, 0x1377c, 0x1379c, 0x137b8, 0x137c2, 0x137c4, 0x137c8, 0x137d0, 0x137de, 0x137e6, 0x137ec, 0x13816,
        0x13826, 0x1382c, 0x13846, 0x1384c, 0x13858, 0x1386e, 0x13874, 0x13886, 0x13898, 0x138b0, 0x138be, 0x138ce,
        0x138dc, 0x138e2, 0x138e4, 0x138e8, 0x13906, 0x1390c, 0x13930, 0x1393e, 0x13960, 0x1397c, 0x1398e, 0x1399c,
        0x139b8, 0x139c8, 0x139d0, 0x139de, 0x139e6, 0x139ec, 0x139fa, 0x13a06, 0x13a0c, 0x13a18, 0x13a30, 0x13a3e,
        0x13a60, 0x13a7c, 0x13ac0, 0x13af8, 0x13b0e, 0x13b1c, 0x13b38, 0x13b70, 0x13b7e, 0x13b88, 0x13b90, 0x13b9e,
        0x13ba0, 0x13bbc, 0x13bcc, 0x13bd8, 0x13bee, 0x13bf2, 0x13bf4, 0x13c12, 0x13c14, 0x13c22, 0x13c24, 0x13c28,
        0x13c36, 0x13c42, 0x13c48, 0x13c50, 0x13c5e, 0x13c66, 0x13c6c, 0x13c82, 0x13c84, 0x13c90, 0x13c9e, 0x13ca0,
        0x13cbc, 0x13cc6, 0x13ccc, 0x13cd8, 0x13cee, 0x13d02, 0x13d04, 0x13d08, 0x13d10, 0x13d1e, 0x13d20, 0x13d3c,
        0x13d40, 0x13d78, 0x13d86, 0x13d8c, 0x13d98, 0x13db0, 0x13dbe, 0x13dce, 0x13ddc, 0x13de4, 0x13de8, 0x13df6,
        0x13e1a, 0x13e2e, 0x13e32, 0x13e34, 0x13e4e, 0x13e5c, 0x13e62, 0x13e64, 0x13e68, 0x13e76, 0x13e8e, 0x13e9c,
        0x13eb8, 0x13ec2, 0x13ec4, 0x13ec8, 0x13ed0, 0x13ede, 0x13ee6, 0x13eec, 0x13f26, 0x13f2c, 0x13f3a, 0x13f46,
        0x13f4c, 0x13f58, 0x13f6e, 0x13f72, 0x13f74, 0x14082, 0x1409e, 0x140a0, 0x140bc, 0x14104, 0x14108, 0x14110,
        0x1411e, 0x14120, 0x1413c, 0x14140, 0x14178, 0x1418c, 0x14198, 0x141b0, 0x141be, 0x141e2, 0x141e4, 0x141e8,
        0x14208, 0x14210, 0x1421e, 0x14220, 0x1423c, 0x14240, 0x14278, 0x142f0, 0x14306, 0x1430c, 0x14318, 0x14330,
        0x1433e, 0x14360, 0x1437c, 0x1438e, 0x143c2, 0x143c4, 0x143c8, 0x143d0, 0x143e6, 0x143ec, 0x14408, 0x14410,
        0x1441e, 0x14420, 0x1443c, 0x14440, 0x14478, 0x144f0, 0x145e0, 0x1460c, 0x14618, 0x14630, 0x1463e, 0x14660,
        0x1467c, 0x146c0, 0x146f8, 0x1471c, 0x14738, 0x14770, 0x1477e, 0x14782, 0x14784, 0x14788, 0x14790, 0x147a0,
        0x147bc, 0x147c6, 0x147cc, 0x147d8, 0x147ee, 0x14810, 0x14820, 0x1483c, 0x14840, 0x14878, 0x148f0, 0x149e0,
        0x14bc0, 0x14c30, 0x14c3e, 0x14c60, 0x14c7c, 0x14cc0, 0x14cf8, 0x14df0, 0x14e38, 0x14e70, 0x14e7e, 0x14ee0,
        0x14efc, 0x14f04, 0x14f08, 0x14f10, 0x14f1e, 0x14f20, 0x14f3c, 0x14f40, 0x14f78, 0x14f86, 0x14f8c, 0x14f98,
        0x14fb0, 0x14fce, 0x14fdc, 0x15020, 0x15040, 0x15078, 0x150f0, 0x151e0, 0x153c0, 0x15860, 0x1587c, 0x158c0,
        0x158f8, 0x159f0, 0x15be0, 0x15c70, 0x15c7e, 0x15ce0, 0x15cfc, 0x15dc0, 0x15df8, 0x15e08, 0x15e10, 0x15e20,
        0x15e40, 0x15e78, 0x15ef0, 0x15f0c, 0x15f18, 0x15f30, 0x15f60, 0x15f7c, 0x15f8e, 0x15f9c, 0x15fb8, 0x1604e,
        0x1605c, 0x1608e, 0x1609c, 0x160b8, 0x160c2, 0x160c4, 0x160c8, 0x160de, 0x1610e, 0x1611c, 0x16138, 0x16170,
        0x1617e, 0x16184, 0x16188, 0x16190, 0x1619e, 0x161a0, 0x161bc, 0x161c6, 0x161cc, 0x161d8, 0x161f2, 0x161f4,
        0x1620e, 0x1621c, 0x16238, 0x16270, 0x1627e, 0x162e0, 0x162fc, 0x16304, 0x16308, 0x16310, 0x1631e, 0x16320,
        0x1633c, 0x16340, 0x16378, 0x16386, 0x1638c, 0x16398, 0x163b0, 0x163be, 0x163ce, 0x163dc, 0x163e2, 0x163e4,
        0x163e8, 0x163f6, 0x1640e, 0x1641c, 0x16438, 0x16470, 0x1647e, 0x164e0, 0x164fc, 0x165c0, 0x165f8, 0x16610,
        0x1661e, 0x16620, 0x1663c, 0x16640, 0x16678, 0x166f0, 0x16718, 0x16730, 0x1673e, 0x16760, 0x1677c, 0x1678e,
        0x1679c, 0x167b8, 0x167c2, 0x167c4, 0x167c8, 0x167d0, 0x167de, 0x167e6, 0x167ec, 0x1681c, 0x16838, 0x16870,
        0x168e0, 0x168fc, 0x169c0, 0x169f8, 0x16bf0, 0x16c10, 0x16c1e, 0x16c20, 0x16c3c, 0x16c40, 0x16c78, 0x16cf0,
        0x16de0, 0x16e18, 0x16e30, 0x16e3e, 0x16e60, 0x16e7c, 0x16ec0, 0x16ef8, 0x16f1c, 0x16f38, 0x16f70, 0x16f7e,
        0x16f84, 0x16f88, 0x16f90, 0x16f9e, 0x16fa0, 0x16fbc, 0x16fc6, 0x16fcc, 0x16fd8, 0x17026, 0x1702c, 0x17046,
        0x1704c, 0x17058, 0x1706e, 0x17086, 0x1708c, 0x17098, 0x170b0, 0x170be, 0x170ce, 0x170dc, 0x170e8, 0x17106,
        0x1710c, 0x17118, 0x17130, 0x1713e, 0x17160, 0x1717c, 0x1718e, 0x1719c, 0x171b8, 0x171c2, 0x171c4, 0x171c8,
        0x171d0, 0x171de, 0x171e6, 0x171ec, 0x171fa, 0x17206, 0x1720c, 0x17218, 0x17230, 0x1723e, 0x17260, 0x1727c,
        0x172c0, 0x172f8, 0x1730e, 0x1731c, 0x17338, 0x17370, 0x1737e, 0x17388, 0x17390, 0x1739e, 0x173a0, 0x173bc,
        0x173cc, 0x173d8, 0x173ee, 0x173f2, 0x173f4, 0x1740c, 0x17418, 0x17430, 0x1743e, 0x17460, 0x1747c, 0x174c0,
        0x174f8, 0x175f0, 0x1760e, 0x1761c, 0x17638, 0x17670, 0x1767e, 0x176e0, 0x176fc, 0x17708, 0x17710, 0x1771e,
        0x17720, 0x1773c, 0x17740, 0x17778, 0x17798, 0x177b0, 0x177be, 0x177dc, 0x177e2, 0x177e4, 0x177e8, 0x17822,
        0x17824, 0x17828, 0x17836, 0x17842, 0x17844, 0x17848, 0x17850, 0x1785e, 0x17866, 0x1786c, 0x17882, 0x17884,
        0x17888, 0x17890, 0x1789e, 0x178a0, 0x178bc, 0x178c6, 0x178cc, 0x178d8, 0x178ee, 0x178f2, 0x178f4, 0x17902,
        0x17904, 0x17908, 0x17910, 0x1791e, 0x17920, 0x1793c, 0x17940, 0x17978, 0x17986, 0x1798c, 0x17998, 0x179b0,
        0x179be, 0x179ce, 0x179dc, 0x179e2, 0x179e4, 0x179e8, 0x179f6, 0x17a04, 0x17a08, 0x17a10, 0x17a1e, 0x17a20,
        0x17a3c, 0x17a40, 0x17a78, 0x17af0, 0x17b06, 0x17b0c, 0x17b18, 0x17b30, 0x17b3e, 0x17b60, 0x17b7c, 0x17b8e,
        0x17b9c, 0x17bb8, 0x17bc4, 0x17bc8, 0x17bd0, 0x17bde, 0x17be6, 0x17bec, 0x17c2e, 0x17c32, 0x17c34, 0x17c4e,
        0x17c5c, 0x17c62, 0x17c64, 0x17c68, 0x17c76, 0x17c8e, 0x17c9c, 0x17cb8, 0x17cc2, 0x17cc4, 0x17cc8, 0x17cd0,
        0x17cde, 0x17ce6, 0x17cec, 0x17d0e, 0x17d1c, 0x17d38, 0x17d70, 0x17d82, 0x17d84, 0x17d88, 0x17d90, 0x17d9e,
        0x17da0, 0x17dbc, 0x17dc6, 0x17dcc, 0x17dd8, 0x17dee, 0x17e26, 0x17e2c, 0x17e3a, 0x17e46, 0x17e4c, 0x17e58,
        0x17e6e, 0x17e72, 0x17e74, 0x17e86, 0x17e8c, 0x17e98, 0x17eb0, 0x17ece, 0x17edc, 0x17ee2, 0x17ee4, 0x17ee8,
        0x17ef6, 0x1813a, 0x18172, 0x18174, 0x18216, 0x18226, 0x1823a, 0x1824c, 0x18258, 0x1826e, 0x18272, 0x18274,
        0x18298, 0x182be, 0x182e2, 0x182e4, 0x182e8, 0x182f6, 0x1835e, 0x1837a, 0x183ae, 0x183d6, 0x18416, 0x18426,
        0x1842c, 0x1843a, 0x18446, 0x18458, 0x1846e, 0x18472, 0x18474, 0x18486, 0x184b0, 0x184be, 0x184ce, 0x184dc,
        0x184e2, 0x184e4, 0x184e8, 0x184f6, 0x18506, 0x1850c, 0x18518, 0x18530, 0x1853e, 0x18560, 0x1857c, 0x1858e,
        0x1859c, 0x185b8, 0x185c2, 0x185c4, 0x185c8, 0x185d0, 0x185de, 0x185e6, 0x185ec, 0x185fa, 0x18612, 0x18614,
        0x18622, 0x18628, 0x18636, 0x18642, 0x18650, 0x1865e, 0x1867a, 0x18682, 0x18684, 0x18688, 0x18690, 0x1869e,
        0x186a0, 0x186bc, 0x186c6, 0x186cc, 0x186d8, 0x186ee, 0x186f2, 0x186f4, 0x1872e, 0x1874e, 0x1875c, 0x18796,
        0x187a6, 0x187ac, 0x187d2, 0x187d4, 0x18826, 0x1882c, 0x1883a, 0x18846, 0x1884c, 0x18858, 0x1886e, 0x18872,
        0x18874, 0x18886, 0x18898, 0x188b0, 0x188be, 0x188ce, 0x188dc, 0x188e2, 0x188e4, 0x188e8, 0x188f6, 0x1890c,
        0x18930, 0x1893e, 0x18960, 0x1897c, 0x1898e, 0x189b8, 0x189c2, 0x189c8, 0x189d0, 0x189de, 0x189e6, 0x189ec,
        0x189fa, 0x18a18, 0x18a30, 0x18a3e, 0x18a60, 0x18a7c, 0x18ac0, 0x18af8, 0x18b1c, 0x18b38, 0x18b70, 0x18b7e,
        0x18b82, 0x18b84, 0x18b88, 0x18b90, 0x18b9e, 0x18ba0, 0x18bbc, 0x18bc6, 0x18bcc, 0x18bd8, 0x18bee, 0x18bf2,
        0x18bf4, 0x18c22, 0x18c24, 0x18c28, 0x18c36, 0x18c42, 0x18c48, 0x18c50, 0x18c5e, 0x18c66, 0x18c7a, 0x18c82,
        0x18c84, 0x18c90, 0x18c9e, 0x18ca0, 0x18cbc, 0x18ccc, 0x18cf2, 0x18cf4, 0x18d04, 0x18d08, 0x18d10, 0x18d1e,
        0x18d20, 0x18d3c, 0x18d40, 0x18d78, 0x18d86, 0x18d98, 0x18dce, 0x18de2, 0x18de4, 0x18de8, 0x18e2e, 0x18e32,
        0x18e34, 0x18e4e, 0x18e5c, 0x18e62, 0x18e64, 0x18e68, 0x18e8e, 0x18e9c, 0x18eb8, 0x18ec2, 0x18ec4, 0x18ec8,
        0x18ed0, 0x18efa, 0x18f16, 0x18f26, 0x18f2c, 0x18f46, 0x18f4c, 0x18f58, 0x18f6e, 0x18f8a, 0x18f92, 0x18f94,
        0x18fa2, 0x18fa4, 0x18fa8, 0x18fb6, 0x1902c, 0x1903a, 0x19046, 0x1904c, 0x19058, 0x19072, 0x19074, 0x19086,
        0x19098, 0x190b0, 0x190be, 0x190ce, 0x190dc, 0x190e2, 0x190e8, 0x190f6, 0x19106, 0x1910c, 0x19130, 0x1913e,
        0x19160, 0x1917c, 0x1918e, 0x1919c, 0x191b8, 0x191c2, 0x191c8, 0x191d0, 0x191de, 0x191e6, 0x191ec, 0x191fa,
        0x19218, 0x1923e, 0x19260, 0x1927c, 0x192c0, 0x192f8, 0x19338, 0x19370, 0x1937e, 0x19382, 0x19384, 0x19390,
        0x1939e, 0x193a0, 0x193bc, 0x193c6, 0x193cc, 0x193d8, 0x193ee, 0x193f2, 0x193f4, 0x19430, 0x1943e, 0x19460,
        0x1947c, 0x194c0, 0x194f8, 0x195f0, 0x19638, 0x19670, 0x1967e, 0x196e0, 0x196fc, 0x19702, 0x19704, 0x19708,
        0x19710, 0x19720, 0x1973c, 0x19740, 0x19778, 0x19786, 0x1978c, 0x19798, 0x197b0, 0x197be, 0x197ce, 0x197dc,
        0x197e2, 0x197e4, 0x197e8, 0x19822, 0x19824, 0x19842, 0x19848, 0x19850, 0x1985e, 0x19866, 0x1987a, 0x19882,
        0x19884, 0x19890, 0x1989e, 0x198a0, 0x198bc, 0x198cc, 0x198f2, 0x198f4, 0x19902, 0x19908, 0x1991e, 0x19920,
        0x1993c, 0x19940, 0x19978, 0x19986, 0x19998, 0x199ce, 0x199e2, 0x199e4, 0x199e8, 0x19a08, 0x19a10, 0x19a1e,
        0x19a20, 0x19a3c, 0x19a40, 0x19a78, 0x19af0, 0x19b18, 0x19b3e, 0x19b60, 0x19b9c, 0x19bc2, 0x19bc4, 0x19bc8,
        0x19bd0, 0x19be6, 0x19c2e, 0x19c34, 0x19c4e, 0x19c5c, 0x19c62, 0x19c64, 0x19c68, 0x19c8e, 0x19c9c, 0x19cb8,
        0x19cc2, 0x19cc8, 0x19cd0, 0x19ce6, 0x19cfa, 0x19d0e, 0x19d1c, 0x19d38, 0x19d70, 0x19d7e, 0x19d82, 0x19d84,
        0x19d88, 0x19d90, 0x19da0, 0x19dcc, 0x19df2, 0x19df4, 0x19e16, 0x19e26, 0x19e2c, 0x19e46, 0x19e4c, 0x19e58,
        0x19e74, 0x19e86, 0x19e8c, 0x19e98, 0x19eb0, 0x19ebe, 0x19ece, 0x19ee2, 0x19ee4, 0x19ee8, 0x19f0a, 0x19f12,
        0x19f14, 0x19f22, 0x19f24, 0x19f28, 0x19f42, 0x19f44, 0x19f48, 0x19f50, 0x19f5e, 0x19f6c, 0x19f9a, 0x19fae,
        0x19fb2, 0x19fb4, 0x1a046, 0x1a04c, 0x1a072, 0x1a074, 0x1a086, 0x1a08c, 0x1a098, 0x1a0b0, 0x1a0be, 0x1a0e2,
        0x1a0e4, 0x1a0e8, 0x1a0f6, 0x1a106, 0x1a10c, 0x1a118, 0x1a130, 0x1a13e, 0x1a160, 0x1a17c, 0x1a18e, 0x1a19c,
        0x1a1b8, 0x1a1c2, 0x1a1c4, 0x1a1c8, 0x1a1d0, 0x1a1de, 0x1a1e6, 0x1a1ec, 0x1a218, 0x1a230, 0x1a23e, 0x1a260,
        0x1a27c, 0x1a2c0, 0x1a2f8, 0x1a31c, 0x1a338, 0x1a370, 0x1a37e, 0x1a382, 0x1a384, 0x1a388, 0x1a390, 0x1a39e,
        0x1a3a0, 0x1a3bc, 0x1a3c6, 0x1a3cc, 0x1a3d8, 0x1a3ee, 0x1a3f2, 0x1a3f4, 0x1a418, 0x1a430, 0x1a43e, 0x1a460,
        0x1a47c, 0x1a4c0, 0x1a4f8, 0x1a5f0, 0x1a61c, 0x1a638, 0x1a670, 0x1a67e, 0x1a6e0, 0x1a6fc, 0x1a702, 0x1a704,
        0x1a708, 0x1a710, 0x1a71e, 0x1a720, 0x1a73c, 0x1a740, 0x1a778, 0x1a786, 0x1a78c, 0x1a798, 0x1a7b0, 0x1a7be,
        0x1a7ce, 0x1a7dc, 0x1a7e2, 0x1a7e4, 0x1a7e8, 0x1a830, 0x1a860, 0x1a87c, 0x1a8c0, 0x1a8f8, 0x1a9f0, 0x1abe0,
        0x1ac70, 0x1ac7e, 0x1ace0, 0x1acfc, 0x1adc0, 0x1adf8, 0x1ae04, 0x1ae08, 0x1ae10, 0x1ae20, 0x1ae3c, 0x1ae40,
        0x1ae78, 0x1aef0, 0x1af06, 0x1af0c, 0x1af18, 0x1af30, 0x1af3e, 0x1af60, 0x1af7c, 0x1af8e, 0x1af9c, 0x1afb8,
        0x1afc4, 0x1afc8, 0x1afd0, 0x1afde, 0x1b042, 0x1b05e, 0x1b07a, 0x1b082, 0x1b084, 0x1b088, 0x1b090, 0x1b09e,
        0x1b0a0, 0x1b0bc, 0x1b0cc, 0x1b0f2, 0x1b0f4, 0x1b102, 0x1b104, 0x1b108, 0x1b110, 0x1b11e, 0x1b120, 0x1b13c,
        0x1b140, 0x1b178, 0x1b186, 0x1b198, 0x1b1ce, 0x1b1e2, 0x1b1e4, 0x1b1e8, 0x1b204, 0x1b208, 0x1b210, 0x1b21e,
        0x1b220, 0x1b23c, 0x1b240, 0x1b278, 0x1b2f0, 0x1b30c, 0x1b33e, 0x1b360, 0x1b39c, 0x1b3c2, 0x1b3c4, 0x1b3c8,
        0x1b3d0, 0x1b3e6, 0x1b410, 0x1b41e, 0x1b420, 0x1b43c, 0x1b440, 0x1b478, 0x1b4f0, 0x1b5e0, 0x1b618, 0x1b660,
        0x1b67c, 0x1b6c0, 0x1b738, 0x1b782, 0x1b784, 0x1b788, 0x1b790, 0x1b79e, 0x1b7a0, 0x1b7cc, 0x1b82e, 0x1b84e,
        0x1b85c, 0x1b88e, 0x1b89c, 0x1b8b8, 0x1b8c2, 0x1b8c4, 0x1b8c8, 0x1b8d0, 0x1b8e6, 0x1b8fa, 0x1b90e, 0x1b91c,
        0x1b938, 0x1b970, 0x1b97e, 0x1b982, 0x1b984, 0x1b988, 0x1b990, 0x1b99e, 0x1b9a0, 0x1b9cc, 0x1b9f2, 0x1b9f4,
        0x1ba0e, 0x1ba1c, 0x1ba38, 0x1ba70, 0x1ba7e, 0x1bae0, 0x1bafc, 0x1bb08, 0x1bb10, 0x1bb20, 0x1bb3c, 0x1bb40,
        0x1bb98, 0x1bbce, 0x1bbe2, 0x1bbe4, 0x1bbe8, 0x1bc16, 0x1bc26, 0x1bc2c, 0x1bc46, 0x1bc4c, 0x1bc58, 0x1bc72,
        0x1bc74, 0x1bc86, 0x1bc8c, 0x1bc98, 0x1bcb0, 0x1bcbe, 0x1bcce, 0x1bce2, 0x1bce4, 0x1bce8, 0x1bd06, 0x1bd0c,
        0x1bd18, 0x1bd30, 0x1bd3e, 0x1bd60, 0x1bd7c, 0x1bd9c, 0x1bdc2, 0x1bdc4, 0x1bdc8, 0x1bdd0, 0x1bde6, 0x1bdfa,
        0x1be12, 0x1be14, 0x1be22, 0x1be24, 0x1be28, 0x1be42, 0x1be44, 0x1be48, 0x1be50, 0x1be5e, 0x1be66, 0x1be82,
        0x1be84, 0x1be88, 0x1be90, 0x1be9e, 0x1bea0, 0x1bebc, 0x1becc, 0x1bef4, 0x1bf1a, 0x1bf2e, 0x1bf32, 0x1bf34,
        0x1bf4e, 0x1bf5c, 0x1bf62, 0x1bf64, 0x1bf68, 0x1c09a, 0x1c0b2, 0x1c0b4, 0x1c11a, 0x1c132, 0x1c134, 0x1c162,
        0x1c164, 0x1c168, 0x1c176, 0x1c1ba, 0x1c21a, 0x1c232, 0x1c234, 0x1c24e, 0x1c25c, 0x1c262, 0x1c264, 0x1c268,
        0x1c276, 0x1c28e, 0x1c2c2, 0x1c2c4, 0x1c2c8, 0x1c2d0, 0x1c2de, 0x1c2e6, 0x1c2ec, 0x1c2fa, 0x1c316, 0x1c326,
        0x1c33a, 0x1c346, 0x1c34c, 0x1c372, 0x1c374, 0x1c41a, 0x1c42e, 0x1c432, 0x1c434, 0x1c44e, 0x1c45c, 0x1c462,
        0x1c464, 0x1c468, 0x1c476, 0x1c48e, 0x1c49c, 0x1c4b8, 0x1c4c2, 0x1c4c8, 0x1c4d0, 0x1c4de, 0x1c4e6, 0x1c4ec,
        0x1c4fa, 0x1c51c, 0x1c538, 0x1c570, 0x1c57e, 0x1c582, 0x1c584, 0x1c588, 0x1c590, 0x1c59e, 0x1c5a0, 0x1c5bc,
        0x1c5c6, 0x1c5cc, 0x1c5d8, 0x1c5ee, 0x1c5f2, 0x1c5f4, 0x1c616, 0x1c626, 0x1c62c, 0x1c63a, 0x1c646, 0x1c64c,
        0x1c658, 0x1c66e, 0x1c672, 0x1c674, 0x1c686, 0x1c68c, 0x1c698, 0x1c6b0, 0x1c6be, 0x1c6ce, 0x1c6dc, 0x1c6e2,
        0x1c6e4, 0x1c6e8, 0x1c712, 0x1c714, 0x1c722, 0x1c728, 0x1c736, 0x1c742, 0x1c744, 0x1c748, 0x1c750, 0x1c75e,
        0x1c766, 0x1c76c, 0x1c77a, 0x1c7ae, 0x1c7d6, 0x1c7ea, 0x1c81a, 0x1c82e, 0x1c832, 0x1c834, 0x1c84e, 0x1c85c,
        0x1c862, 0x1c864, 0x1c868, 0x1c876, 0x1c88e, 0x1c89c, 0x1c8b8, 0x1c8c2, 0x1c8c8, 0x1c8d0, 0x1c8de, 0x1c8e6,
        0x1c8ec, 0x1c8fa, 0x1c90e, 0x1c938, 0x1c970, 0x1c97e, 0x1c982, 0x1c984, 0x1c990, 0x1c99e, 0x1c9a0, 0x1c9bc,
        0x1c9c6, 0x1c9cc, 0x1c9d8, 0x1c9ee, 0x1c9f2, 0x1c9f4, 0x1ca38, 0x1ca70, 0x1ca7e, 0x1cae0, 0x1cafc, 0x1cb02,
        0x1cb04, 0x1cb08, 0x1cb10, 0x1cb20, 0x1cb3c, 0x1cb40, 0x1cb78, 0x1cb86, 0x1cb8c, 0x1cb98, 0x1cbb0, 0x1cbbe,
        0x1cbce, 0x1cbdc, 0x1cbe2, 0x1cbe4, 0x1cbe8, 0x1cbf6, 0x1cc16, 0x1cc26, 0x1cc2c, 0x1cc3a, 0x1cc46, 0x1cc58,
        0x1cc72, 0x1cc74, 0x1cc86, 0x1ccb0, 0x1ccbe, 0x1ccce, 0x1cce2, 0x1cce4, 0x1cce8, 0x1cd06, 0x1cd0c, 0x1cd18,
        0x1cd30, 0x1cd3e, 0x1cd60, 0x1cd7c, 0x1cd9c, 0x1cdc2, 0x1cdc4, 0x1cdc8, 0x1cdd0, 0x1cdde, 0x1cde6, 0x1cdfa,
        0x1ce22, 0x1ce28, 0x1ce42, 0x1ce50, 0x1ce5e, 0x1ce66, 0x1ce7a, 0x1ce82, 0x1ce84, 0x1ce88, 0x1ce90, 0x1ce9e,
        0x1cea0, 0x1cebc, 0x1cecc, 0x1cef2, 0x1cef4, 0x1cf2e, 0x1cf32, 0x1cf34, 0x1cf4e, 0x1cf5c, 0x1cf62, 0x1cf64,
        0x1cf68, 0x1cf96, 0x1cfa6, 0x1cfac, 0x1cfca, 0x1cfd2, 0x1cfd4, 0x1d02e, 0x1d032, 0x1d034, 0x1d04e, 0x1d05c,
        0x1d062, 0x1d064, 0x1d068, 0x1d076, 0x1d08e, 0x1d09c, 0x1d0b8, 0x1d0c2, 0x1d0c4, 0x1d0c8, 0x1d0d0, 0x1d0de,
        0x1d0e6, 0x1d0ec, 0x1d0fa, 0x1d11c, 0x1d138, 0x1d170, 0x1d17e, 0x1d182, 0x1d184, 0x1d188, 0x1d190, 0x1d19e,
        0x1d1a0, 0x1d1bc, 0x1d1c6, 0x1d1cc, 0x1d1d8, 0x1d1ee, 0x1d1f2, 0x1d1f4, 0x1d21c, 0x1d238, 0x1d270, 0x1d27e,
        0x1d2e0, 0x1d2fc, 0x1d302, 0x1d304, 0x1d308, 0x1d310, 0x1d31e, 0x1d320, 0x1d33c, 0x1d340, 0x1d378, 0x1d386,
        0x1d38c, 0x1d398, 0x1d3b0, 0x1d3be, 0x1d3ce, 0x1d3dc, 0x1d3e2, 0x1d3e4, 0x1d3e8, 0x1d3f6, 0x1d470, 0x1d47e,
        0x1d4e0, 0x1d4fc, 0x1d5c0, 0x1d5f8, 0x1d604, 0x1d608, 0x1d610, 0x1d620, 0x1d640, 0x1d678, 0x1d6f0, 0x1d706,
        0x1d70c, 0x1d718, 0x1d730, 0x1d73e, 0x1d760, 0x1d77c, 0x1d78e, 0x1d79c, 0x1d7b8, 0x1d7c2, 0x1d7c4, 0x1d7c8,
        0x1d7d0, 0x1d7de, 0x1d7e6, 0x1d7ec, 0x1d826, 0x1d82c, 0x1d83a, 0x1d846, 0x1d84c, 0x1d858, 0x1d872, 0x1d874,
        0x1d886, 0x1d88c, 0x1d898, 0x1d8b0, 0x1d8be, 0x1d8ce, 0x1d8e2, 0x1d8e4, 0x1d8e8, 0x1d8f6, 0x1d90c, 0x1d918,
        0x1d930, 0x1d93e, 0x1d960, 0x1d97c, 0x1d99c, 0x1d9c2, 0x1d9c4, 0x1d9c8, 0x1d9d0, 0x1d9e6, 0x1d9fa, 0x1da0c,
        0x1da18, 0x1da30, 0x1da3e, 0x1da60, 0x1da7c, 0x1dac0, 0x1daf8, 0x1db38, 0x1db82, 0x1db84, 0x1db88, 0x1db90,
        0x1db9e, 0x1dba0, 0x1dbcc, 0x1dbf2, 0x1dbf4, 0x1dc22, 0x1dc42, 0x1dc44, 0x1dc48, 0x1dc50, 0x1dc5e, 0x1dc66,
        0x1dc7a, 0x1dc82, 0x1dc84, 0x1dc88, 0x1dc90, 0x1dc9e, 0x1dca0, 0x1dcbc, 0x1dccc, 0x1dcf2, 0x1dcf4, 0x1dd04,
        0x1dd08, 0x1dd10, 0x1dd1e, 0x1dd20, 0x1dd3c, 0x1dd40, 0x1dd78, 0x1dd86, 0x1dd98, 0x1ddce, 0x1dde2, 0x1dde4,
        0x1dde8, 0x1de2e, 0x1de32, 0x1de34, 0x1de4e, 0x1de5c, 0x1de62, 0x1de64, 0x1de68, 0x1de8e, 0x1de9c, 0x1deb8,
        0x1dec2, 0x1dec4, 0x1dec8, 0x1ded0, 0x1dee6, 0x1defa, 0x1df16, 0x1df26, 0x1df2c, 0x1df46, 0x1df4c, 0x1df58,
        0x1df72, 0x1df74, 0x1df8a, 0x1df92, 0x1df94, 0x1dfa2, 0x1dfa4, 0x1dfa8, 0x1e08a, 0x1e092, 0x1e094, 0x1e0a2,
        0x1e0a4, 0x1e0a8, 0x1e0b6, 0x1e0da, 0x1e10a, 0x1e112, 0x1e114, 0x1e122, 0x1e124, 0x1e128, 0x1e136, 0x1e142,
        0x1e144, 0x1e148, 0x1e150, 0x1e166, 0x1e16c, 0x1e17a, 0x1e19a, 0x1e1b2, 0x1e1b4, 0x1e20a, 0x1e212, 0x1e214,
        0x1e222, 0x1e224, 0x1e228, 0x1e236, 0x1e242, 0x1e248, 0x1e250, 0x1e25e, 0x1e266, 0x1e26c, 0x1e27a, 0x1e282,
        0x1e284, 0x1e288, 0x1e290, 0x1e2a0, 0x1e2bc, 0x1e2c6, 0x1e2cc, 0x1e2d8, 0x1e2ee, 0x1e2f2, 0x1e2f4, 0x1e31a,
        0x1e332, 0x1e334, 0x1e35c, 0x1e362, 0x1e364, 0x1e368, 0x1e3ba, 0x1e40a, 0x1e412, 0x1e414, 0x1e422, 0x1e428,
        0x1e436, 0x1e442, 0x1e448, 0x1e450, 0x1e45e, 0x1e466, 0x1e46c, 0x1e47a, 0x1e482, 0x1e484, 0x1e490, 0x1e49e,
        0x1e4a0, 0x1e4bc, 0x1e4c6, 0x1e4cc, 0x1e4d8, 0x1e4ee, 0x1e4f2, 0x1e4f4, 0x1e502, 0x1e504, 0x1e508, 0x1e510,
        0x1e51e, 0x1e520, 0x1e53c, 0x1e540, 0x1e578, 0x1e586, 0x1e58c, 0x1e598, 0x1e5b0, 0x1e5be, 0x1e5ce, 0x1e5dc,
        0x1e5e2, 0x1e5e4, 0x1e5e8, 0x1e5f6, 0x1e61a, 0x1e62e, 0x1e632, 0x1e634, 0x1e64e, 0x1e65c, 0x1e662, 0x1e668,
        0x1e68e, 0x1e69c, 0x1e6b8, 0x1e6c2, 0x1e6c4, 0x1e6c8, 0x1e6d0, 0x1e6e6, 0x1e6fa, 0x1e716, 0x1e726, 0x1e72c,
        0x1e73a, 0x1e746, 0x1e74c, 0x1e758, 0x1e772, 0x1e774, 0x1e792, 0x1e794, 0x1e7a2, 0x1e7a4, 0x1e7a8, 0x1e7b6,
        0x1e812, 0x1e814, 0x1e822, 0x1e824, 0x1e828, 0x1e836, 0x1e842, 0x1e844, 0x1e848, 0x1e850, 0x1e85e, 0x1e866,
        0x1e86c, 0x1e87a, 0x1e882, 0x1e884, 0x1e888, 0x1e890, 0x1e89e, 0x1e8a0, 0x1e8bc, 0x1e8c6, 0x1e8cc, 0x1e8d8,
        0x1e8ee, 0x1e8f2, 0x1e8f4, 0x1e902, 0x1e904, 0x1e908, 0x1e910, 0x1e920, 0x1e93c, 0x1e940, 0x1e978, 0x1e986,
        0x1e98c, 0x1e998, 0x1e9b0, 0x1e9be, 0x1e9ce, 0x1e9dc, 0x1e9e2, 0x1e9e4, 0x1e9e8, 0x1e9f6, 0x1ea04, 0x1ea08,
        0x1ea10, 0x1ea20, 0x1ea40, 0x1ea78, 0x1eaf0, 0x1eb06, 0x1eb0c, 0x1eb18, 0x1eb30, 0x1eb3e, 0x1eb60, 0x1eb7c,
        0x1eb8e, 0x1eb9c, 0x1ebb8, 0x1ebc2, 0x1ebc4, 0x1ebc8, 0x1ebd0, 0x1ebde, 0x1ebe6, 0x1ebec, 0x1ec1a, 0x1ec2e,
        0x1ec32, 0x1ec34, 0x1ec4e, 0x1ec5c, 0x1ec62, 0x1ec64, 0x1ec68, 0x1ec8e, 0x1ec9c, 0x1ecb8, 0x1ecc2, 0x1ecc4,
        0x1ecc8, 0x1ecd0, 0x1ece6, 0x1ecfa, 0x1ed0e, 0x1ed1c, 0x1ed38, 0x1ed70, 0x1ed7e, 0x1ed82, 0x1ed84, 0x1ed88,
        0x1ed90, 0x1ed9e, 0x1eda0, 0x1edcc, 0x1edf2, 0x1edf4, 0x1ee16, 0x1ee26, 0x1ee2c, 0x1ee3a, 0x1ee46, 0x1ee4c,
        0x1ee58, 0x1ee6e, 0x1ee72, 0x1ee74, 0x1ee86, 0x1ee8c, 0x1ee98, 0x1eeb0, 0x1eebe, 0x1eece, 0x1eedc, 0x1eee2,
        0x1eee4, 0x1eee8, 0x1ef12, 0x1ef22, 0x1ef24, 0x1ef28, 0x1ef36, 0x1ef42, 0x1ef44, 0x1ef48, 0x1ef50, 0x1ef5e,
        0x1ef66, 0x1ef6c, 0x1ef7a, 0x1efae, 0x1efb2, 0x1efb4, 0x1efd6, 0x1f096, 0x1f0a6, 0x1f0ac, 0x1f0ba, 0x1f0ca,
        0x1f0d2, 0x1f0d4, 0x1f116, 0x1f126, 0x1f12c, 0x1f13a, 0x1f146, 0x1f14c, 0x1f158, 0x1f16e, 0x1f172, 0x1f174,
        0x1f18a, 0x1f192, 0x1f194, 0x1f1a2, 0x1f1a4, 0x1f1a8, 0x1f1da, 0x1f216, 0x1f226, 0x1f22c, 0x1f23a, 0x1f246,
        0x1f258, 0x1f26e, 0x1f272, 0x1f274, 0x1f286, 0x1f28c, 0x1f298, 0x1f2b0, 0x1f2be, 0x1f2ce, 0x1f2dc, 0x1f2e2,
        0x1f2e4, 0x1f2e8, 0x1f2f6, 0x1f30a, 0x1f312, 0x1f314, 0x1f322, 0x1f328, 0x1f342, 0x1f344, 0x1f348, 0x1f350,
        0x1f35e, 0x1f366, 0x1f37a, 0x1f39a, 0x1f3ae, 0x1f3b2, 0x1f3b4, 0x1f416, 0x1f426, 0x1f42c, 0x1f43a, 0x1f446,
        0x1f44c, 0x1f458, 0x1f46e, 0x1f472, 0x1f474, 0x1f486, 0x1f48c, 0x1f498, 0x1f4b0, 0x1f4be, 0x1f4ce, 0x1f4dc,
        0x1f4e2, 0x1f4e4, 0x1f4e8, 0x1f4f6, 0x1f506, 0x1f50c, 0x1f518, 0x1f530, 0x1f53e, 0x1f560, 0x1f57c, 0x1f58e,
        0x1f59c, 0x1f5b8, 0x1f5c2, 0x1f5c4, 0x1f5c8, 0x1f5d0, 0x1f5de, 0x1f5e6, 0x1f5ec, 0x1f5fa, 0x1f60a, 0x1f612,
        0x1f614, 0x1f622, 0x1f624, 0x1f628, 0x1f636, 0x1f642, 0x1f644, 0x1f648, 0x1f650, 0x1f65e, 0x1f666, 0x1f67a,
        0x1f682, 0x1f684, 0x1f688, 0x1f690, 0x1f69e, 0x1f6a0, 0x1f6bc, 0x1f6cc, 0x1f6f2, 0x1f6f4, 0x1f71a, 0x1f72e,
        0x1f732, 0x1f734, 0x1f74e, 0x1f75c, 0x1f762, 0x1f764, 0x1f768, 0x1f776, 0x1f796, 0x1f7a6, 0x1f7ac, 0x1f7ba,
        0x1f7d2, 0x1f7d4, 0x1f89a, 0x1f8ae, 0x1f8b2, 0x1f8b4, 0x1f8d6, 0x1f8ea, 0x1f91a, 0x1f92e, 0x1f932, 0x1f934,
        0x1f94e, 0x1f95c, 0x1f962, 0x1f964, 0x1f968, 0x1f976, 0x1f996, 0x1f9a6, 0x1f9ac, 0x1f9ba, 0x1f9ca, 0x1f9d2,
        0x1f9d4, 0x1fa1a, 0x1fa2e, 0x1fa32, 0x1fa34, 0x1fa4e, 0x1fa5c, 0x1fa62, 0x1fa64, 0x1fa68, 0x1fa76, 0x1fa8e,
        0x1fa9c, 0x1fab8, 0x1fac2, 0x1fac4, 0x1fac8, 0x1fad0, 0x1fade, 0x1fae6, 0x1faec, 0x1fb16, 0x1fb26, 0x1fb2c,
        0x1fb3a, 0x1fb46, 0x1fb4c, 0x1fb58, 0x1fb6e, 0x1fb72, 0x1fb74, 0x1fb8a, 0x1fb92, 0x1fb94, 0x1fba2, 0x1fba4,
        0x1fba8, 0x1fbb6, 0x1fbda
    ]);
    /**
     * This table contains to codewords for all symbols.
     */
    PDF417Common.CODEWORD_TABLE = Int32Array.from([
        2627, 1819, 2622, 2621, 1813, 1812, 2729, 2724, 2723, 2779, 2774, 2773, 902, 896, 908, 868, 865, 861, 859, 2511,
        873, 871, 1780, 835, 2493, 825, 2491, 842, 837, 844, 1764, 1762, 811, 810, 809, 2483, 807, 2482, 806, 2480, 815,
        814, 813, 812, 2484, 817, 816, 1745, 1744, 1742, 1746, 2655, 2637, 2635, 2626, 2625, 2623, 2628, 1820, 2752,
        2739, 2737, 2728, 2727, 2725, 2730, 2785, 2783, 2778, 2777, 2775, 2780, 787, 781, 747, 739, 736, 2413, 754, 752,
        1719, 692, 689, 681, 2371, 678, 2369, 700, 697, 694, 703, 1688, 1686, 642, 638, 2343, 631, 2341, 627, 2338, 651,
        646, 643, 2345, 654, 652, 1652, 1650, 1647, 1654, 601, 599, 2322, 596, 2321, 594, 2319, 2317, 611, 610, 608, 606,
        2324, 603, 2323, 615, 614, 612, 1617, 1616, 1614, 1612, 616, 1619, 1618, 2575, 2538, 2536, 905, 901, 898, 909,
        2509, 2507, 2504, 870, 867, 864, 860, 2512, 875, 872, 1781, 2490, 2489, 2487, 2485, 1748, 836, 834, 832, 830,
        2494, 827, 2492, 843, 841, 839, 845, 1765, 1763, 2701, 2676, 2674, 2653, 2648, 2656, 2634, 2633, 2631, 2629,
        1821, 2638, 2636, 2770, 2763, 2761, 2750, 2745, 2753, 2736, 2735, 2733, 2731, 1848, 2740, 2738, 2786, 2784, 591,
        588, 576, 569, 566, 2296, 1590, 537, 534, 526, 2276, 522, 2274, 545, 542, 539, 548, 1572, 1570, 481, 2245, 466,
        2242, 462, 2239, 492, 485, 482, 2249, 496, 494, 1534, 1531, 1528, 1538, 413, 2196, 406, 2191, 2188, 425, 419,
        2202, 415, 2199, 432, 430, 427, 1472, 1467, 1464, 433, 1476, 1474, 368, 367, 2160, 365, 2159, 362, 2157, 2155,
        2152, 378, 377, 375, 2166, 372, 2165, 369, 2162, 383, 381, 379, 2168, 1419, 1418, 1416, 1414, 385, 1411, 384,
        1423, 1422, 1420, 1424, 2461, 802, 2441, 2439, 790, 786, 783, 794, 2409, 2406, 2403, 750, 742, 738, 2414, 756,
        753, 1720, 2367, 2365, 2362, 2359, 1663, 693, 691, 684, 2373, 680, 2370, 702, 699, 696, 704, 1690, 1687, 2337,
        2336, 2334, 2332, 1624, 2329, 1622, 640, 637, 2344, 634, 2342, 630, 2340, 650, 648, 645, 2346, 655, 653, 1653,
        1651, 1649, 1655, 2612, 2597, 2595, 2571, 2568, 2565, 2576, 2534, 2529, 2526, 1787, 2540, 2537, 907, 904, 900,
        910, 2503, 2502, 2500, 2498, 1768, 2495, 1767, 2510, 2508, 2506, 869, 866, 863, 2513, 876, 874, 1782, 2720, 2713,
        2711, 2697, 2694, 2691, 2702, 2672, 2670, 2664, 1828, 2678, 2675, 2647, 2646, 2644, 2642, 1823, 2639, 1822, 2654,
        2652, 2650, 2657, 2771, 1855, 2765, 2762, 1850, 1849, 2751, 2749, 2747, 2754, 353, 2148, 344, 342, 336, 2142,
        332, 2140, 345, 1375, 1373, 306, 2130, 299, 2128, 295, 2125, 319, 314, 311, 2132, 1354, 1352, 1349, 1356, 262,
        257, 2101, 253, 2096, 2093, 274, 273, 267, 2107, 263, 2104, 280, 278, 275, 1316, 1311, 1308, 1320, 1318, 2052,
        202, 2050, 2044, 2040, 219, 2063, 212, 2060, 208, 2055, 224, 221, 2066, 1260, 1258, 1252, 231, 1248, 229, 1266,
        1264, 1261, 1268, 155, 1998, 153, 1996, 1994, 1991, 1988, 165, 164, 2007, 162, 2006, 159, 2003, 2000, 172, 171,
        169, 2012, 166, 2010, 1186, 1184, 1182, 1179, 175, 1176, 173, 1192, 1191, 1189, 1187, 176, 1194, 1193, 2313,
        2307, 2305, 592, 589, 2294, 2292, 2289, 578, 572, 568, 2297, 580, 1591, 2272, 2267, 2264, 1547, 538, 536, 529,
        2278, 525, 2275, 547, 544, 541, 1574, 1571, 2237, 2235, 2229, 1493, 2225, 1489, 478, 2247, 470, 2244, 465, 2241,
        493, 488, 484, 2250, 498, 495, 1536, 1533, 1530, 1539, 2187, 2186, 2184, 2182, 1432, 2179, 1430, 2176, 1427, 414,
        412, 2197, 409, 2195, 405, 2193, 2190, 426, 424, 421, 2203, 418, 2201, 431, 429, 1473, 1471, 1469, 1466, 434,
        1477, 1475, 2478, 2472, 2470, 2459, 2457, 2454, 2462, 803, 2437, 2432, 2429, 1726, 2443, 2440, 792, 789, 785,
        2401, 2399, 2393, 1702, 2389, 1699, 2411, 2408, 2405, 745, 741, 2415, 758, 755, 1721, 2358, 2357, 2355, 2353,
        1661, 2350, 1660, 2347, 1657, 2368, 2366, 2364, 2361, 1666, 690, 687, 2374, 683, 2372, 701, 698, 705, 1691, 1689,
        2619, 2617, 2610, 2608, 2605, 2613, 2593, 2588, 2585, 1803, 2599, 2596, 2563, 2561, 2555, 1797, 2551, 1795, 2573,
        2570, 2567, 2577, 2525, 2524, 2522, 2520, 1786, 2517, 1785, 2514, 1783, 2535, 2533, 2531, 2528, 1788, 2541, 2539,
        906, 903, 911, 2721, 1844, 2715, 2712, 1838, 1836, 2699, 2696, 2693, 2703, 1827, 1826, 1824, 2673, 2671, 2669,
        2666, 1829, 2679, 2677, 1858, 1857, 2772, 1854, 1853, 1851, 1856, 2766, 2764, 143, 1987, 139, 1986, 135, 133,
        131, 1984, 128, 1983, 125, 1981, 138, 137, 136, 1985, 1133, 1132, 1130, 112, 110, 1974, 107, 1973, 104, 1971,
        1969, 122, 121, 119, 117, 1977, 114, 1976, 124, 1115, 1114, 1112, 1110, 1117, 1116, 84, 83, 1953, 81, 1952, 78,
        1950, 1948, 1945, 94, 93, 91, 1959, 88, 1958, 85, 1955, 99, 97, 95, 1961, 1086, 1085, 1083, 1081, 1078, 100,
        1090, 1089, 1087, 1091, 49, 47, 1917, 44, 1915, 1913, 1910, 1907, 59, 1926, 56, 1925, 53, 1922, 1919, 66, 64,
        1931, 61, 1929, 1042, 1040, 1038, 71, 1035, 70, 1032, 68, 1048, 1047, 1045, 1043, 1050, 1049, 12, 10, 1869, 1867,
        1864, 1861, 21, 1880, 19, 1877, 1874, 1871, 28, 1888, 25, 1886, 22, 1883, 982, 980, 977, 974, 32, 30, 991, 989,
        987, 984, 34, 995, 994, 992, 2151, 2150, 2147, 2146, 2144, 356, 355, 354, 2149, 2139, 2138, 2136, 2134, 1359,
        343, 341, 338, 2143, 335, 2141, 348, 347, 346, 1376, 1374, 2124, 2123, 2121, 2119, 1326, 2116, 1324, 310, 308,
        305, 2131, 302, 2129, 298, 2127, 320, 318, 316, 313, 2133, 322, 321, 1355, 1353, 1351, 1357, 2092, 2091, 2089,
        2087, 1276, 2084, 1274, 2081, 1271, 259, 2102, 256, 2100, 252, 2098, 2095, 272, 269, 2108, 266, 2106, 281, 279,
        277, 1317, 1315, 1313, 1310, 282, 1321, 1319, 2039, 2037, 2035, 2032, 1203, 2029, 1200, 1197, 207, 2053, 205,
        2051, 201, 2049, 2046, 2043, 220, 218, 2064, 215, 2062, 211, 2059, 228, 226, 223, 2069, 1259, 1257, 1254, 232,
        1251, 230, 1267, 1265, 1263, 2316, 2315, 2312, 2311, 2309, 2314, 2304, 2303, 2301, 2299, 1593, 2308, 2306, 590,
        2288, 2287, 2285, 2283, 1578, 2280, 1577, 2295, 2293, 2291, 579, 577, 574, 571, 2298, 582, 581, 1592, 2263, 2262,
        2260, 2258, 1545, 2255, 1544, 2252, 1541, 2273, 2271, 2269, 2266, 1550, 535, 532, 2279, 528, 2277, 546, 543, 549,
        1575, 1573, 2224, 2222, 2220, 1486, 2217, 1485, 2214, 1482, 1479, 2238, 2236, 2234, 2231, 1496, 2228, 1492, 480,
        477, 2248, 473, 2246, 469, 2243, 490, 487, 2251, 497, 1537, 1535, 1532, 2477, 2476, 2474, 2479, 2469, 2468, 2466,
        2464, 1730, 2473, 2471, 2453, 2452, 2450, 2448, 1729, 2445, 1728, 2460, 2458, 2456, 2463, 805, 804, 2428, 2427,
        2425, 2423, 1725, 2420, 1724, 2417, 1722, 2438, 2436, 2434, 2431, 1727, 2444, 2442, 793, 791, 788, 795, 2388,
        2386, 2384, 1697, 2381, 1696, 2378, 1694, 1692, 2402, 2400, 2398, 2395, 1703, 2392, 1701, 2412, 2410, 2407, 751,
        748, 744, 2416, 759, 757, 1807, 2620, 2618, 1806, 1805, 2611, 2609, 2607, 2614, 1802, 1801, 1799, 2594, 2592,
        2590, 2587, 1804, 2600, 2598, 1794, 1793, 1791, 1789, 2564, 2562, 2560, 2557, 1798, 2554, 1796, 2574, 2572, 2569,
        2578, 1847, 1846, 2722, 1843, 1842, 1840, 1845, 2716, 2714, 1835, 1834, 1832, 1830, 1839, 1837, 2700, 2698, 2695,
        2704, 1817, 1811, 1810, 897, 862, 1777, 829, 826, 838, 1760, 1758, 808, 2481, 1741, 1740, 1738, 1743, 2624, 1818,
        2726, 2776, 782, 740, 737, 1715, 686, 679, 695, 1682, 1680, 639, 628, 2339, 647, 644, 1645, 1643, 1640, 1648,
        602, 600, 597, 595, 2320, 593, 2318, 609, 607, 604, 1611, 1610, 1608, 1606, 613, 1615, 1613, 2328, 926, 924, 892,
        886, 899, 857, 850, 2505, 1778, 824, 823, 821, 819, 2488, 818, 2486, 833, 831, 828, 840, 1761, 1759, 2649, 2632,
        2630, 2746, 2734, 2732, 2782, 2781, 570, 567, 1587, 531, 527, 523, 540, 1566, 1564, 476, 467, 463, 2240, 486,
        483, 1524, 1521, 1518, 1529, 411, 403, 2192, 399, 2189, 423, 416, 1462, 1457, 1454, 428, 1468, 1465, 2210, 366,
        363, 2158, 360, 2156, 357, 2153, 376, 373, 370, 2163, 1410, 1409, 1407, 1405, 382, 1402, 380, 1417, 1415, 1412,
        1421, 2175, 2174, 777, 774, 771, 784, 732, 725, 722, 2404, 743, 1716, 676, 674, 668, 2363, 665, 2360, 685, 1684,
        1681, 626, 624, 622, 2335, 620, 2333, 617, 2330, 641, 635, 649, 1646, 1644, 1642, 2566, 928, 925, 2530, 2527,
        894, 891, 888, 2501, 2499, 2496, 858, 856, 854, 851, 1779, 2692, 2668, 2665, 2645, 2643, 2640, 2651, 2768, 2759,
        2757, 2744, 2743, 2741, 2748, 352, 1382, 340, 337, 333, 1371, 1369, 307, 300, 296, 2126, 315, 312, 1347, 1342,
        1350, 261, 258, 250, 2097, 246, 2094, 271, 268, 264, 1306, 1301, 1298, 276, 1312, 1309, 2115, 203, 2048, 195,
        2045, 191, 2041, 213, 209, 2056, 1246, 1244, 1238, 225, 1234, 222, 1256, 1253, 1249, 1262, 2080, 2079, 154, 1997,
        150, 1995, 147, 1992, 1989, 163, 160, 2004, 156, 2001, 1175, 1174, 1172, 1170, 1167, 170, 1164, 167, 1185, 1183,
        1180, 1177, 174, 1190, 1188, 2025, 2024, 2022, 587, 586, 564, 559, 556, 2290, 573, 1588, 520, 518, 512, 2268,
        508, 2265, 530, 1568, 1565, 461, 457, 2233, 450, 2230, 446, 2226, 479, 471, 489, 1526, 1523, 1520, 397, 395,
        2185, 392, 2183, 389, 2180, 2177, 410, 2194, 402, 422, 1463, 1461, 1459, 1456, 1470, 2455, 799, 2433, 2430, 779,
        776, 773, 2397, 2394, 2390, 734, 728, 724, 746, 1717, 2356, 2354, 2351, 2348, 1658, 677, 675, 673, 670, 667, 688,
        1685, 1683, 2606, 2589, 2586, 2559, 2556, 2552, 927, 2523, 2521, 2518, 2515, 1784, 2532, 895, 893, 890, 2718,
        2709, 2707, 2689, 2687, 2684, 2663, 2662, 2660, 2658, 1825, 2667, 2769, 1852, 2760, 2758, 142, 141, 1139, 1138,
        134, 132, 129, 126, 1982, 1129, 1128, 1126, 1131, 113, 111, 108, 105, 1972, 101, 1970, 120, 118, 115, 1109, 1108,
        1106, 1104, 123, 1113, 1111, 82, 79, 1951, 75, 1949, 72, 1946, 92, 89, 86, 1956, 1077, 1076, 1074, 1072, 98,
        1069, 96, 1084, 1082, 1079, 1088, 1968, 1967, 48, 45, 1916, 42, 1914, 39, 1911, 1908, 60, 57, 54, 1923, 50, 1920,
        1031, 1030, 1028, 1026, 67, 1023, 65, 1020, 62, 1041, 1039, 1036, 1033, 69, 1046, 1044, 1944, 1943, 1941, 11, 9,
        1868, 7, 1865, 1862, 1859, 20, 1878, 16, 1875, 13, 1872, 970, 968, 966, 963, 29, 960, 26, 23, 983, 981, 978, 975,
        33, 971, 31, 990, 988, 985, 1906, 1904, 1902, 993, 351, 2145, 1383, 331, 330, 328, 326, 2137, 323, 2135, 339,
        1372, 1370, 294, 293, 291, 289, 2122, 286, 2120, 283, 2117, 309, 303, 317, 1348, 1346, 1344, 245, 244, 242, 2090,
        239, 2088, 236, 2085, 2082, 260, 2099, 249, 270, 1307, 1305, 1303, 1300, 1314, 189, 2038, 186, 2036, 183, 2033,
        2030, 2026, 206, 198, 2047, 194, 216, 1247, 1245, 1243, 1240, 227, 1237, 1255, 2310, 2302, 2300, 2286, 2284,
        2281, 565, 563, 561, 558, 575, 1589, 2261, 2259, 2256, 2253, 1542, 521, 519, 517, 514, 2270, 511, 533, 1569,
        1567, 2223, 2221, 2218, 2215, 1483, 2211, 1480, 459, 456, 453, 2232, 449, 474, 491, 1527, 1525, 1522, 2475, 2467,
        2465, 2451, 2449, 2446, 801, 800, 2426, 2424, 2421, 2418, 1723, 2435, 780, 778, 775, 2387, 2385, 2382, 2379,
        1695, 2375, 1693, 2396, 735, 733, 730, 727, 749, 1718, 2616, 2615, 2604, 2603, 2601, 2584, 2583, 2581, 2579,
        1800, 2591, 2550, 2549, 2547, 2545, 1792, 2542, 1790, 2558, 929, 2719, 1841, 2710, 2708, 1833, 1831, 2690, 2688,
        2686, 1815, 1809, 1808, 1774, 1756, 1754, 1737, 1736, 1734, 1739, 1816, 1711, 1676, 1674, 633, 629, 1638, 1636,
        1633, 1641, 598, 1605, 1604, 1602, 1600, 605, 1609, 1607, 2327, 887, 853, 1775, 822, 820, 1757, 1755, 1584, 524,
        1560, 1558, 468, 464, 1514, 1511, 1508, 1519, 408, 404, 400, 1452, 1447, 1444, 417, 1458, 1455, 2208, 364, 361,
        358, 2154, 1401, 1400, 1398, 1396, 374, 1393, 371, 1408, 1406, 1403, 1413, 2173, 2172, 772, 726, 723, 1712, 672,
        669, 666, 682, 1678, 1675, 625, 623, 621, 618, 2331, 636, 632, 1639, 1637, 1635, 920, 918, 884, 880, 889, 849,
        848, 847, 846, 2497, 855, 852, 1776, 2641, 2742, 2787, 1380, 334, 1367, 1365, 301, 297, 1340, 1338, 1335, 1343,
        255, 251, 247, 1296, 1291, 1288, 265, 1302, 1299, 2113, 204, 196, 192, 2042, 1232, 1230, 1224, 214, 1220, 210,
        1242, 1239, 1235, 1250, 2077, 2075, 151, 148, 1993, 144, 1990, 1163, 1162, 1160, 1158, 1155, 161, 1152, 157,
        1173, 1171, 1168, 1165, 168, 1181, 1178, 2021, 2020, 2018, 2023, 585, 560, 557, 1585, 516, 509, 1562, 1559, 458,
        447, 2227, 472, 1516, 1513, 1510, 398, 396, 393, 390, 2181, 386, 2178, 407, 1453, 1451, 1449, 1446, 420, 1460,
        2209, 769, 764, 720, 712, 2391, 729, 1713, 664, 663, 661, 659, 2352, 656, 2349, 671, 1679, 1677, 2553, 922, 919,
        2519, 2516, 885, 883, 881, 2685, 2661, 2659, 2767, 2756, 2755, 140, 1137, 1136, 130, 127, 1125, 1124, 1122, 1127,
        109, 106, 102, 1103, 1102, 1100, 1098, 116, 1107, 1105, 1980, 80, 76, 73, 1947, 1068, 1067, 1065, 1063, 90, 1060,
        87, 1075, 1073, 1070, 1080, 1966, 1965, 46, 43, 40, 1912, 36, 1909, 1019, 1018, 1016, 1014, 58, 1011, 55, 1008,
        51, 1029, 1027, 1024, 1021, 63, 1037, 1034, 1940, 1939, 1937, 1942, 8, 1866, 4, 1863, 1, 1860, 956, 954, 952,
        949, 946, 17, 14, 969, 967, 964, 961, 27, 957, 24, 979, 976, 972, 1901, 1900, 1898, 1896, 986, 1905, 1903, 350,
        349, 1381, 329, 327, 324, 1368, 1366, 292, 290, 287, 284, 2118, 304, 1341, 1339, 1337, 1345, 243, 240, 237, 2086,
        233, 2083, 254, 1297, 1295, 1293, 1290, 1304, 2114, 190, 187, 184, 2034, 180, 2031, 177, 2027, 199, 1233, 1231,
        1229, 1226, 217, 1223, 1241, 2078, 2076, 584, 555, 554, 552, 550, 2282, 562, 1586, 507, 506, 504, 502, 2257, 499,
        2254, 515, 1563, 1561, 445, 443, 441, 2219, 438, 2216, 435, 2212, 460, 454, 475, 1517, 1515, 1512, 2447, 798,
        797, 2422, 2419, 770, 768, 766, 2383, 2380, 2376, 721, 719, 717, 714, 731, 1714, 2602, 2582, 2580, 2548, 2546,
        2543, 923, 921, 2717, 2706, 2705, 2683, 2682, 2680, 1771, 1752, 1750, 1733, 1732, 1731, 1735, 1814, 1707, 1670,
        1668, 1631, 1629, 1626, 1634, 1599, 1598, 1596, 1594, 1603, 1601, 2326, 1772, 1753, 1751, 1581, 1554, 1552, 1504,
        1501, 1498, 1509, 1442, 1437, 1434, 401, 1448, 1445, 2206, 1392, 1391, 1389, 1387, 1384, 359, 1399, 1397, 1394,
        1404, 2171, 2170, 1708, 1672, 1669, 619, 1632, 1630, 1628, 1773, 1378, 1363, 1361, 1333, 1328, 1336, 1286, 1281,
        1278, 248, 1292, 1289, 2111, 1218, 1216, 1210, 197, 1206, 193, 1228, 1225, 1221, 1236, 2073, 2071, 1151, 1150,
        1148, 1146, 152, 1143, 149, 1140, 145, 1161, 1159, 1156, 1153, 158, 1169, 1166, 2017, 2016, 2014, 2019, 1582,
        510, 1556, 1553, 452, 448, 1506, 1500, 394, 391, 387, 1443, 1441, 1439, 1436, 1450, 2207, 765, 716, 713, 1709,
        662, 660, 657, 1673, 1671, 916, 914, 879, 878, 877, 882, 1135, 1134, 1121, 1120, 1118, 1123, 1097, 1096, 1094,
        1092, 103, 1101, 1099, 1979, 1059, 1058, 1056, 1054, 77, 1051, 74, 1066, 1064, 1061, 1071, 1964, 1963, 1007,
        1006, 1004, 1002, 999, 41, 996, 37, 1017, 1015, 1012, 1009, 52, 1025, 1022, 1936, 1935, 1933, 1938, 942, 940,
        938, 935, 932, 5, 2, 955, 953, 950, 947, 18, 943, 15, 965, 962, 958, 1895, 1894, 1892, 1890, 973, 1899, 1897,
        1379, 325, 1364, 1362, 288, 285, 1334, 1332, 1330, 241, 238, 234, 1287, 1285, 1283, 1280, 1294, 2112, 188, 185,
        181, 178, 2028, 1219, 1217, 1215, 1212, 200, 1209, 1227, 2074, 2072, 583, 553, 551, 1583, 505, 503, 500, 513,
        1557, 1555, 444, 442, 439, 436, 2213, 455, 451, 1507, 1505, 1502, 796, 763, 762, 760, 767, 711, 710, 708, 706,
        2377, 718, 715, 1710, 2544, 917, 915, 2681, 1627, 1597, 1595, 2325, 1769, 1749, 1747, 1499, 1438, 1435, 2204,
        1390, 1388, 1385, 1395, 2169, 2167, 1704, 1665, 1662, 1625, 1623, 1620, 1770, 1329, 1282, 1279, 2109, 1214, 1207,
        1222, 2068, 2065, 1149, 1147, 1144, 1141, 146, 1157, 1154, 2013, 2011, 2008, 2015, 1579, 1549, 1546, 1495, 1487,
        1433, 1431, 1428, 1425, 388, 1440, 2205, 1705, 658, 1667, 1664, 1119, 1095, 1093, 1978, 1057, 1055, 1052, 1062,
        1962, 1960, 1005, 1003, 1000, 997, 38, 1013, 1010, 1932, 1930, 1927, 1934, 941, 939, 936, 933, 6, 930, 3, 951,
        948, 944, 1889, 1887, 1884, 1881, 959, 1893, 1891, 35, 1377, 1360, 1358, 1327, 1325, 1322, 1331, 1277, 1275,
        1272, 1269, 235, 1284, 2110, 1205, 1204, 1201, 1198, 182, 1195, 179, 1213, 2070, 2067, 1580, 501, 1551, 1548,
        440, 437, 1497, 1494, 1490, 1503, 761, 709, 707, 1706, 913, 912, 2198, 1386, 2164, 2161, 1621, 1766, 2103, 1208,
        2058, 2054, 1145, 1142, 2005, 2002, 1999, 2009, 1488, 1429, 1426, 2200, 1698, 1659, 1656, 1975, 1053, 1957, 1954,
        1001, 998, 1924, 1921, 1918, 1928, 937, 934, 931, 1879, 1876, 1873, 1870, 945, 1885, 1882, 1323, 1273, 1270,
        2105, 1202, 1199, 1196, 1211, 2061, 2057, 1576, 1543, 1540, 1484, 1481, 1478, 1491, 1700
    ]);
    return PDF417Common;
}());
exports.default = PDF417Common;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\pdf417\\PDF417Common.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\PDF417Reader.js", {"../BarcodeFormat":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\BarcodeFormat.js","../ChecksumException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\ChecksumException.js","../FormatException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\FormatException.js","../NotFoundException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\NotFoundException.js","../Result":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\Result.js","../ResultMetadataType":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\ResultMetadataType.js","../util/Integer":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\Integer.js","./PDF417Common":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\PDF417Common.js","./decoder/PDF417ScanningDecoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\PDF417ScanningDecoder.js","./detector/Detector":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\detector\\Detector.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cpdf417%5CPDF417Reader.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2009 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
// package com.google.zxing.pdf417;
// import com.google.zxing.BarcodeFormat;
var BarcodeFormat_1 = require("../BarcodeFormat");
// import com.google.zxing.ChecksumException;
var ChecksumException_1 = require("../ChecksumException");
// import com.google.zxing.FormatException;
var FormatException_1 = require("../FormatException");
// import com.google.zxing.NotFoundException;
var NotFoundException_1 = require("../NotFoundException");
// import com.google.zxing.Result;
var Result_1 = require("../Result");
// import com.google.zxing.common.DecoderResult;
// import com.google.zxing.multi.MultipleBarcodeReader;
// import com.google.zxing.pdf417.decoder.PDF417ScanningDecoder;
// import com.google.zxing.pdf417.detector.Detector;
// import com.google.zxing.pdf417.detector.PDF417DetectorResult;
var PDF417Common_1 = require("./PDF417Common");
var Integer_1 = require("../util/Integer");
var ResultMetadataType_1 = require("../ResultMetadataType");
var Detector_1 = require("./detector/Detector");
var PDF417ScanningDecoder_1 = require("./decoder/PDF417ScanningDecoder");
// import java.util.ArrayList;
// import java.util.List;
// import java.util.Map;
/**
 * This implementation can detect and decode PDF417 codes in an image.
 *
 * @author Guenther Grau
 */
var PDF417Reader = /** @class */ (function () {
    function PDF417Reader() {
    }
    // private static /*final Result[]*/ EMPTY_RESULT_ARRAY: Result[] = new Result([0]);
    /**
     * Locates and decodes a PDF417 code in an image.
     *
     * @return a String representing the content encoded by the PDF417 code
     * @throws NotFoundException if a PDF417 code cannot be found,
     * @throws FormatException if a PDF417 cannot be decoded
     * @throws ChecksumException
     */
    // @Override
    PDF417Reader.prototype.decode = function (image, hints) {
        if (hints === void 0) { hints = null; }
        var result = PDF417Reader.decode(image, hints, false);
        if (result == null || result.length === 0 || result[0] == null) {
            throw NotFoundException_1.default.getNotFoundInstance();
        }
        return result[0];
    };
    /**
     *
     * @param BinaryBitmap
     * @param image
     * @throws NotFoundException
     */
    //   @Override
    PDF417Reader.prototype.decodeMultiple = function (image, hints) {
        if (hints === void 0) { hints = null; }
        try {
            return PDF417Reader.decode(image, hints, true);
        }
        catch (ignored) {
            if (ignored instanceof FormatException_1.default || ignored instanceof ChecksumException_1.default) {
                throw NotFoundException_1.default.getNotFoundInstance();
            }
            throw ignored;
        }
    };
    /**
     *
     * @param image
     * @param hints
     * @param multiple
     *
     * @throws NotFoundException
     * @throws FormatExceptionß
     * @throws ChecksumException
     */
    PDF417Reader.decode = function (image, hints, multiple) {
        var e_1, _a;
        var results = new Array();
        var detectorResult = Detector_1.default.detectMultiple(image, hints, multiple);
        try {
            for (var _b = __values(detectorResult.getPoints()), _c = _b.next(); !_c.done; _c = _b.next()) {
                var points = _c.value;
                var decoderResult = PDF417ScanningDecoder_1.default.decode(detectorResult.getBits(), points[4], points[5], points[6], points[7], PDF417Reader.getMinCodewordWidth(points), PDF417Reader.getMaxCodewordWidth(points));
                var result = new Result_1.default(decoderResult.getText(), decoderResult.getRawBytes(), undefined, points, BarcodeFormat_1.default.PDF_417);
                result.putMetadata(ResultMetadataType_1.default.ERROR_CORRECTION_LEVEL, decoderResult.getECLevel());
                var pdf417ResultMetadata = decoderResult.getOther();
                if (pdf417ResultMetadata != null) {
                    result.putMetadata(ResultMetadataType_1.default.PDF417_EXTRA_METADATA, pdf417ResultMetadata);
                }
                results.push(result);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return results.map(function (x) { return x; });
    };
    PDF417Reader.getMaxWidth = function (p1, p2) {
        if (p1 == null || p2 == null) {
            return 0;
        }
        return Math.trunc(Math.abs(p1.getX() - p2.getX()));
    };
    PDF417Reader.getMinWidth = function (p1, p2) {
        if (p1 == null || p2 == null) {
            return Integer_1.default.MAX_VALUE;
        }
        return Math.trunc(Math.abs(p1.getX() - p2.getX()));
    };
    PDF417Reader.getMaxCodewordWidth = function (p) {
        return Math.floor(Math.max(Math.max(PDF417Reader.getMaxWidth(p[0], p[4]), PDF417Reader.getMaxWidth(p[6], p[2]) * PDF417Common_1.default.MODULES_IN_CODEWORD /
            PDF417Common_1.default.MODULES_IN_STOP_PATTERN), Math.max(PDF417Reader.getMaxWidth(p[1], p[5]), PDF417Reader.getMaxWidth(p[7], p[3]) * PDF417Common_1.default.MODULES_IN_CODEWORD /
            PDF417Common_1.default.MODULES_IN_STOP_PATTERN)));
    };
    PDF417Reader.getMinCodewordWidth = function (p) {
        return Math.floor(Math.min(Math.min(PDF417Reader.getMinWidth(p[0], p[4]), PDF417Reader.getMinWidth(p[6], p[2]) * PDF417Common_1.default.MODULES_IN_CODEWORD /
            PDF417Common_1.default.MODULES_IN_STOP_PATTERN), Math.min(PDF417Reader.getMinWidth(p[1], p[5]), PDF417Reader.getMinWidth(p[7], p[3]) * PDF417Common_1.default.MODULES_IN_CODEWORD /
            PDF417Common_1.default.MODULES_IN_STOP_PATTERN)));
    };
    // @Override
    PDF417Reader.prototype.reset = function () {
        // nothing needs to be reset
    };
    return PDF417Reader;
}());
exports.default = PDF417Reader;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\pdf417\\PDF417Reader.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\PDF417ResultMetadata.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cpdf417%5CPDF417ResultMetadata.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2013 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// package com.google.zxing.pdf417;
/**
 * @author Guenther Grau
 */
var PDF417ResultMetadata = /** @class */ (function () {
    function PDF417ResultMetadata() {
        this.segmentCount = -1;
        this.fileSize = -1;
        this.timestamp = -1;
        this.checksum = -1;
    }
    /**
     * The Segment ID represents the segment of the whole file distributed over different symbols.
     *
     * @return File segment index
     */
    PDF417ResultMetadata.prototype.getSegmentIndex = function () {
        return this.segmentIndex;
    };
    PDF417ResultMetadata.prototype.setSegmentIndex = function (segmentIndex) {
        this.segmentIndex = segmentIndex;
    };
    /**
     * Is the same for each related PDF417 symbol
     *
     * @return File ID
     */
    PDF417ResultMetadata.prototype.getFileId = function () {
        return this.fileId;
    };
    PDF417ResultMetadata.prototype.setFileId = function (fileId) {
        this.fileId = fileId;
    };
    /**
     * @return always null
     * @deprecated use dedicated already parsed fields
     */
    //   @Deprecated
    PDF417ResultMetadata.prototype.getOptionalData = function () {
        return this.optionalData;
    };
    /**
     * @param optionalData old optional data format as int array
     * @deprecated parse and use new fields
     */
    //   @Deprecated
    PDF417ResultMetadata.prototype.setOptionalData = function (optionalData) {
        this.optionalData = optionalData;
    };
    /**
     * @return true if it is the last segment
     */
    PDF417ResultMetadata.prototype.isLastSegment = function () {
        return this.lastSegment;
    };
    PDF417ResultMetadata.prototype.setLastSegment = function (lastSegment) {
        this.lastSegment = lastSegment;
    };
    /**
     * @return count of segments, -1 if not set
     */
    PDF417ResultMetadata.prototype.getSegmentCount = function () {
        return this.segmentCount;
    };
    PDF417ResultMetadata.prototype.setSegmentCount = function (segmentCount /*int*/) {
        this.segmentCount = segmentCount;
    };
    PDF417ResultMetadata.prototype.getSender = function () {
        return this.sender || null;
    };
    PDF417ResultMetadata.prototype.setSender = function (sender) {
        this.sender = sender;
    };
    PDF417ResultMetadata.prototype.getAddressee = function () {
        return this.addressee || null;
    };
    PDF417ResultMetadata.prototype.setAddressee = function (addressee) {
        this.addressee = addressee;
    };
    /**
     * Filename of the encoded file
     *
     * @return filename
     */
    PDF417ResultMetadata.prototype.getFileName = function () {
        return this.fileName;
    };
    PDF417ResultMetadata.prototype.setFileName = function (fileName) {
        this.fileName = fileName;
    };
    /**
     * filesize in bytes of the encoded file
     *
     * @return filesize in bytes, -1 if not set
     */
    PDF417ResultMetadata.prototype.getFileSize = function () {
        return this.fileSize;
    };
    PDF417ResultMetadata.prototype.setFileSize = function (fileSize /*long*/) {
        this.fileSize = fileSize;
    };
    /**
     * 16-bit CRC checksum using CCITT-16
     *
     * @return crc checksum, -1 if not set
     */
    PDF417ResultMetadata.prototype.getChecksum = function () {
        return this.checksum;
    };
    PDF417ResultMetadata.prototype.setChecksum = function (checksum /*int*/) {
        this.checksum = checksum;
    };
    /**
     * unix epock timestamp, elapsed seconds since 1970-01-01
     *
     * @return elapsed seconds, -1 if not set
     */
    PDF417ResultMetadata.prototype.getTimestamp = function () {
        return this.timestamp;
    };
    PDF417ResultMetadata.prototype.setTimestamp = function (timestamp /*long*/) {
        this.timestamp = timestamp;
    };
    return PDF417ResultMetadata;
}());
exports.default = PDF417ResultMetadata;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\pdf417\\PDF417ResultMetadata.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\BarcodeMetadata.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cpdf417%5Cdecoder%5CBarcodeMetadata.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2013 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// package com.google.zxing.pdf417.decoder;
/**
 * @author Guenther Grau
 */
var BarcodeMetadata = /** @class */ (function () {
    function BarcodeMetadata(columnCount, rowCountUpperPart, rowCountLowerPart, errorCorrectionLevel) {
        this.columnCount = columnCount;
        this.errorCorrectionLevel = errorCorrectionLevel;
        this.rowCountUpperPart = rowCountUpperPart;
        this.rowCountLowerPart = rowCountLowerPart;
        this.rowCount = rowCountUpperPart + rowCountLowerPart;
    }
    BarcodeMetadata.prototype.getColumnCount = function () {
        return this.columnCount;
    };
    BarcodeMetadata.prototype.getErrorCorrectionLevel = function () {
        return this.errorCorrectionLevel;
    };
    BarcodeMetadata.prototype.getRowCount = function () {
        return this.rowCount;
    };
    BarcodeMetadata.prototype.getRowCountUpperPart = function () {
        return this.rowCountUpperPart;
    };
    BarcodeMetadata.prototype.getRowCountLowerPart = function () {
        return this.rowCountLowerPart;
    };
    return BarcodeMetadata;
}());
exports.default = BarcodeMetadata;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\BarcodeMetadata.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\BarcodeValue.js", {"../PDF417Common":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\PDF417Common.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cpdf417%5Cdecoder%5CBarcodeValue.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2013 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
// package com.google.zxing.pdf417.decoder;
// import com.google.zxing.pdf417.PDF417Common;
var PDF417Common_1 = require("../PDF417Common");
// import java.util.ArrayList;
// import java.util.Collection;
// import java.util.HashMap;
// import java.util.Map;
// import java.util.Map.Entry;
/**
 * @author Guenther Grau
 */
var BarcodeValue = /** @class */ (function () {
    function BarcodeValue() {
        this.values = new Map();
    }
    /**
     * Add an occurrence of a value
     */
    BarcodeValue.prototype.setValue = function (value) {
        value = Math.trunc(value);
        var confidence = this.values.get(value);
        if (confidence == null) {
            confidence = 0;
        }
        confidence++;
        this.values.set(value, confidence);
    };
    /**
     * Determines the maximum occurrence of a set value and returns all values which were set with this occurrence.
     * @return an array of int, containing the values with the highest occurrence, or null, if no value was set
     */
    BarcodeValue.prototype.getValue = function () {
        var e_1, _a;
        var maxConfidence = -1;
        var result = new Array();
        var _loop_1 = function (key, value) {
            var entry = {
                getKey: function () { return key; },
                getValue: function () { return value; },
            };
            if (entry.getValue() > maxConfidence) {
                maxConfidence = entry.getValue();
                result = [];
                result.push(entry.getKey());
            }
            else if (entry.getValue() === maxConfidence) {
                result.push(entry.getKey());
            }
        };
        try {
            for (var _b = __values(this.values.entries()), _c = _b.next(); !_c.done; _c = _b.next()) {
                var _d = __read(_c.value, 2), key = _d[0], value = _d[1];
                _loop_1(key, value);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return PDF417Common_1.default.toIntArray(result);
    };
    BarcodeValue.prototype.getConfidence = function (value) {
        return this.values.get(value);
    };
    return BarcodeValue;
}());
exports.default = BarcodeValue;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\BarcodeValue.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\BoundingBox.js", {"../../NotFoundException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\NotFoundException.js","../../ResultPoint":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\ResultPoint.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cpdf417%5Cdecoder%5CBoundingBox.js
      return function (require, module, exports) {
"use strict";
/*
* Copyright 2013 ZXing authors
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
Object.defineProperty(exports, "__esModule", { value: true });
// package com.google.zxing.pdf417.decoder;
// import com.google.zxing.NotFoundException;
var NotFoundException_1 = require("../../NotFoundException");
// import com.google.zxing.ResultPoint;
var ResultPoint_1 = require("../../ResultPoint");
/**
 * @author Guenther Grau
 */
var BoundingBox = /** @class */ (function () {
    function BoundingBox(image, topLeft, bottomLeft, topRight, bottomRight) {
        if (image instanceof BoundingBox) {
            this.constructor_2(image);
        }
        else {
            this.constructor_1(image, topLeft, bottomLeft, topRight, bottomRight);
        }
    }
    /**
     *
     * @param image
     * @param topLeft
     * @param bottomLeft
     * @param topRight
     * @param bottomRight
     *
     * @throws NotFoundException
     */
    BoundingBox.prototype.constructor_1 = function (image, topLeft, bottomLeft, topRight, bottomRight) {
        var leftUnspecified = topLeft == null || bottomLeft == null;
        var rightUnspecified = topRight == null || bottomRight == null;
        if (leftUnspecified && rightUnspecified) {
            throw new NotFoundException_1.default();
        }
        if (leftUnspecified) {
            topLeft = new ResultPoint_1.default(0, topRight.getY());
            bottomLeft = new ResultPoint_1.default(0, bottomRight.getY());
        }
        else if (rightUnspecified) {
            topRight = new ResultPoint_1.default(image.getWidth() - 1, topLeft.getY());
            bottomRight = new ResultPoint_1.default(image.getWidth() - 1, bottomLeft.getY());
        }
        this.image = image;
        this.topLeft = topLeft;
        this.bottomLeft = bottomLeft;
        this.topRight = topRight;
        this.bottomRight = bottomRight;
        this.minX = Math.trunc(Math.min(topLeft.getX(), bottomLeft.getX()));
        this.maxX = Math.trunc(Math.max(topRight.getX(), bottomRight.getX()));
        this.minY = Math.trunc(Math.min(topLeft.getY(), topRight.getY()));
        this.maxY = Math.trunc(Math.max(bottomLeft.getY(), bottomRight.getY()));
    };
    BoundingBox.prototype.constructor_2 = function (boundingBox) {
        this.image = boundingBox.image;
        this.topLeft = boundingBox.getTopLeft();
        this.bottomLeft = boundingBox.getBottomLeft();
        this.topRight = boundingBox.getTopRight();
        this.bottomRight = boundingBox.getBottomRight();
        this.minX = boundingBox.getMinX();
        this.maxX = boundingBox.getMaxX();
        this.minY = boundingBox.getMinY();
        this.maxY = boundingBox.getMaxY();
    };
    /**
     * @throws NotFoundException
     */
    BoundingBox.merge = function (leftBox, rightBox) {
        if (leftBox == null) {
            return rightBox;
        }
        if (rightBox == null) {
            return leftBox;
        }
        return new BoundingBox(leftBox.image, leftBox.topLeft, leftBox.bottomLeft, rightBox.topRight, rightBox.bottomRight);
    };
    /**
     * @throws NotFoundException
     */
    BoundingBox.prototype.addMissingRows = function (missingStartRows, missingEndRows, isLeft) {
        var newTopLeft = this.topLeft;
        var newBottomLeft = this.bottomLeft;
        var newTopRight = this.topRight;
        var newBottomRight = this.bottomRight;
        if (missingStartRows > 0) {
            var top_1 = isLeft ? this.topLeft : this.topRight;
            var newMinY = Math.trunc(top_1.getY() - missingStartRows);
            if (newMinY < 0) {
                newMinY = 0;
            }
            var newTop = new ResultPoint_1.default(top_1.getX(), newMinY);
            if (isLeft) {
                newTopLeft = newTop;
            }
            else {
                newTopRight = newTop;
            }
        }
        if (missingEndRows > 0) {
            var bottom = isLeft ? this.bottomLeft : this.bottomRight;
            var newMaxY = Math.trunc(bottom.getY() + missingEndRows);
            if (newMaxY >= this.image.getHeight()) {
                newMaxY = this.image.getHeight() - 1;
            }
            var newBottom = new ResultPoint_1.default(bottom.getX(), newMaxY);
            if (isLeft) {
                newBottomLeft = newBottom;
            }
            else {
                newBottomRight = newBottom;
            }
        }
        return new BoundingBox(this.image, newTopLeft, newBottomLeft, newTopRight, newBottomRight);
    };
    BoundingBox.prototype.getMinX = function () {
        return this.minX;
    };
    BoundingBox.prototype.getMaxX = function () {
        return this.maxX;
    };
    BoundingBox.prototype.getMinY = function () {
        return this.minY;
    };
    BoundingBox.prototype.getMaxY = function () {
        return this.maxY;
    };
    BoundingBox.prototype.getTopLeft = function () {
        return this.topLeft;
    };
    BoundingBox.prototype.getTopRight = function () {
        return this.topRight;
    };
    BoundingBox.prototype.getBottomLeft = function () {
        return this.bottomLeft;
    };
    BoundingBox.prototype.getBottomRight = function () {
        return this.bottomRight;
    };
    return BoundingBox;
}());
exports.default = BoundingBox;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\BoundingBox.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\Codeword.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cpdf417%5Cdecoder%5CCodeword.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2013 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// package com.google.zxing.pdf417.decoder;
/**
 * @author Guenther Grau
 */
var Codeword = /** @class */ (function () {
    function Codeword(startX, endX, bucket, value) {
        this.rowNumber = Codeword.BARCODE_ROW_UNKNOWN;
        this.startX = Math.trunc(startX);
        this.endX = Math.trunc(endX);
        this.bucket = Math.trunc(bucket);
        this.value = Math.trunc(value);
    }
    Codeword.prototype.hasValidRowNumber = function () {
        return this.isValidRowNumber(this.rowNumber);
    };
    Codeword.prototype.isValidRowNumber = function (rowNumber) {
        return rowNumber !== Codeword.BARCODE_ROW_UNKNOWN && this.bucket === (rowNumber % 3) * 3;
    };
    Codeword.prototype.setRowNumberAsRowIndicatorColumn = function () {
        this.rowNumber = Math.trunc((Math.trunc(this.value / 30)) * 3 + Math.trunc(this.bucket / 3));
    };
    Codeword.prototype.getWidth = function () {
        return this.endX - this.startX;
    };
    Codeword.prototype.getStartX = function () {
        return this.startX;
    };
    Codeword.prototype.getEndX = function () {
        return this.endX;
    };
    Codeword.prototype.getBucket = function () {
        return this.bucket;
    };
    Codeword.prototype.getValue = function () {
        return this.value;
    };
    Codeword.prototype.getRowNumber = function () {
        return this.rowNumber;
    };
    Codeword.prototype.setRowNumber = function (rowNumber) {
        this.rowNumber = rowNumber;
    };
    //   @Override
    Codeword.prototype.toString = function () {
        return this.rowNumber + '|' + this.value;
    };
    Codeword.BARCODE_ROW_UNKNOWN = -1;
    return Codeword;
}());
exports.default = Codeword;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\Codeword.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\DecodedBitStreamParser.js", {"../../FormatException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\FormatException.js","../../common/CharacterSetECI":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\CharacterSetECI.js","../../common/DecoderResult":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\DecoderResult.js","../../util/Arrays":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\Arrays.js","../../util/ByteArrayOutputStream":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\ByteArrayOutputStream.js","../../util/Integer":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\Integer.js","../../util/Long":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\Long.js","../../util/StringBuilder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\StringBuilder.js","../../util/StringEncoding":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\StringEncoding.js","../PDF417ResultMetadata":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\PDF417ResultMetadata.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cpdf417%5Cdecoder%5CDecodedBitStreamParser.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2009 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// package com.google.zxing.pdf417.decoder;
// import com.google.zxing.FormatException;
var FormatException_1 = require("../../FormatException");
// import com.google.zxing.common.CharacterSetECI;
var CharacterSetECI_1 = require("../../common/CharacterSetECI");
// import com.google.zxing.common.DecoderResult;
var DecoderResult_1 = require("../../common/DecoderResult");
// import com.google.zxing.pdf417.PDF417ResultMetadata;
var PDF417ResultMetadata_1 = require("../PDF417ResultMetadata");
// import java.io.ByteArrayOutputStream;
// import java.math.BigInteger;
// import java.nio.charset.Charset;
// import java.nio.charset.StandardCharsets;
// import java.util.Arrays;
var Arrays_1 = require("../../util/Arrays");
var StringBuilder_1 = require("../../util/StringBuilder");
var Integer_1 = require("../../util/Integer");
var Long_1 = require("../../util/Long");
var ByteArrayOutputStream_1 = require("../../util/ByteArrayOutputStream");
var StringEncoding_1 = require("../../util/StringEncoding");
/*private*/ var Mode;
(function (Mode) {
    Mode[Mode["ALPHA"] = 0] = "ALPHA";
    Mode[Mode["LOWER"] = 1] = "LOWER";
    Mode[Mode["MIXED"] = 2] = "MIXED";
    Mode[Mode["PUNCT"] = 3] = "PUNCT";
    Mode[Mode["ALPHA_SHIFT"] = 4] = "ALPHA_SHIFT";
    Mode[Mode["PUNCT_SHIFT"] = 5] = "PUNCT_SHIFT";
})(Mode || (Mode = {}));
/**
 * Indirectly access the global BigInt constructor, it
 * allows browsers that doesn't support BigInt to run
 * the library without breaking due to "undefined BigInt"
 * errors.
 */
function getBigIntConstructor() {
    if (typeof window !== 'undefined') {
        return window['BigInt'] || null;
    }
    if (typeof global !== 'undefined') {
        return global['BigInt'] || null;
    }
    if (typeof self !== 'undefined') {
        return self['BigInt'] || null;
    }
    throw new Error('Can\'t search globals for BigInt!');
}
/**
 * Used to store the BigInt constructor.
 */
var BigInteger;
/**
 * This function creates a bigint value. It allows browsers
 * that doesn't support BigInt to run the rest of the library
 * by not directly accessing the BigInt constructor.
 */
function createBigInt(num) {
    if (typeof BigInteger === 'undefined') {
        BigInteger = getBigIntConstructor();
    }
    if (BigInteger === null) {
        throw new Error('BigInt is not supported!');
    }
    return BigInteger(num);
}
function getEXP900() {
    // in Java - array with length = 16
    var EXP900 = [];
    EXP900[0] = createBigInt(1);
    var nineHundred = createBigInt(900);
    EXP900[1] = nineHundred;
    // in Java - array with length = 16
    for (var i /*int*/ = 2; i < 16; i++) {
        EXP900[i] = EXP900[i - 1] * nineHundred;
    }
    return EXP900;
}
/**
 * <p>This class contains the methods for decoding the PDF417 codewords.</p>
 *
 * @author SITA Lab (kevin.osullivan@sita.aero)
 * @author Guenther Grau
 */
var DecodedBitStreamParser = /** @class */ (function () {
    function DecodedBitStreamParser() {
    }
    //   private DecodedBitStreamParser() {
    // }
    /**
     *
     * @param codewords
     * @param ecLevel
     *
     * @throws FormatException
     */
    DecodedBitStreamParser.decode = function (codewords, ecLevel) {
        // pass encoding to result (will be used for decode symbols in byte mode)
        var result = new StringBuilder_1.default('');
        // let encoding: Charset = StandardCharsets.ISO_8859_1;
        var encoding = CharacterSetECI_1.default.ISO8859_1;
        /**
         * @note the next command is specific from this TypeScript library
         * because TS can't properly cast some values to char and
         * convert it to string later correctly due to encoding
         * differences from Java version. As reported here:
         * https://github.com/zxing-js/library/pull/264/files#r382831593
         */
        result.enableDecoding(encoding);
        // Get compaction mode
        var codeIndex = 1;
        var code = codewords[codeIndex++];
        var resultMetadata = new PDF417ResultMetadata_1.default();
        while (codeIndex < codewords[0]) {
            switch (code) {
                case DecodedBitStreamParser.TEXT_COMPACTION_MODE_LATCH:
                    codeIndex = DecodedBitStreamParser.textCompaction(codewords, codeIndex, result);
                    break;
                case DecodedBitStreamParser.BYTE_COMPACTION_MODE_LATCH:
                case DecodedBitStreamParser.BYTE_COMPACTION_MODE_LATCH_6:
                    codeIndex = DecodedBitStreamParser.byteCompaction(code, codewords, encoding, codeIndex, result);
                    break;
                case DecodedBitStreamParser.MODE_SHIFT_TO_BYTE_COMPACTION_MODE:
                    result.append(/*(char)*/ codewords[codeIndex++]);
                    break;
                case DecodedBitStreamParser.NUMERIC_COMPACTION_MODE_LATCH:
                    codeIndex = DecodedBitStreamParser.numericCompaction(codewords, codeIndex, result);
                    break;
                case DecodedBitStreamParser.ECI_CHARSET:
                    var charsetECI = CharacterSetECI_1.default.getCharacterSetECIByValue(codewords[codeIndex++]);
                    // encoding = Charset.forName(charsetECI.getName());
                    break;
                case DecodedBitStreamParser.ECI_GENERAL_PURPOSE:
                    // Can't do anything with generic ECI; skip its 2 characters
                    codeIndex += 2;
                    break;
                case DecodedBitStreamParser.ECI_USER_DEFINED:
                    // Can't do anything with user ECI; skip its 1 character
                    codeIndex++;
                    break;
                case DecodedBitStreamParser.BEGIN_MACRO_PDF417_CONTROL_BLOCK:
                    codeIndex = DecodedBitStreamParser.decodeMacroBlock(codewords, codeIndex, resultMetadata);
                    break;
                case DecodedBitStreamParser.BEGIN_MACRO_PDF417_OPTIONAL_FIELD:
                case DecodedBitStreamParser.MACRO_PDF417_TERMINATOR:
                    // Should not see these outside a macro block
                    throw new FormatException_1.default();
                default:
                    // Default to text compaction. During testing numerous barcodes
                    // appeared to be missing the starting mode. In these cases defaulting
                    // to text compaction seems to work.
                    codeIndex--;
                    codeIndex = DecodedBitStreamParser.textCompaction(codewords, codeIndex, result);
                    break;
            }
            if (codeIndex < codewords.length) {
                code = codewords[codeIndex++];
            }
            else {
                throw FormatException_1.default.getFormatInstance();
            }
        }
        if (result.length() === 0) {
            throw FormatException_1.default.getFormatInstance();
        }
        var decoderResult = new DecoderResult_1.default(null, result.toString(), null, ecLevel);
        decoderResult.setOther(resultMetadata);
        return decoderResult;
    };
    /**
     *
     * @param int
     * @param param1
     * @param codewords
     * @param int
     * @param codeIndex
     * @param PDF417ResultMetadata
     * @param resultMetadata
     *
     * @throws FormatException
     */
    // @SuppressWarnings("deprecation")
    DecodedBitStreamParser.decodeMacroBlock = function (codewords, codeIndex, resultMetadata) {
        if (codeIndex + DecodedBitStreamParser.NUMBER_OF_SEQUENCE_CODEWORDS > codewords[0]) {
            // we must have at least two bytes left for the segment index
            throw FormatException_1.default.getFormatInstance();
        }
        var segmentIndexArray = new Int32Array(DecodedBitStreamParser.NUMBER_OF_SEQUENCE_CODEWORDS);
        for (var i /*int*/ = 0; i < DecodedBitStreamParser.NUMBER_OF_SEQUENCE_CODEWORDS; i++, codeIndex++) {
            segmentIndexArray[i] = codewords[codeIndex];
        }
        resultMetadata.setSegmentIndex(Integer_1.default.parseInt(DecodedBitStreamParser.decodeBase900toBase10(segmentIndexArray, DecodedBitStreamParser.NUMBER_OF_SEQUENCE_CODEWORDS)));
        var fileId = new StringBuilder_1.default();
        codeIndex = DecodedBitStreamParser.textCompaction(codewords, codeIndex, fileId);
        resultMetadata.setFileId(fileId.toString());
        var optionalFieldsStart = -1;
        if (codewords[codeIndex] === DecodedBitStreamParser.BEGIN_MACRO_PDF417_OPTIONAL_FIELD) {
            optionalFieldsStart = codeIndex + 1;
        }
        while (codeIndex < codewords[0]) {
            switch (codewords[codeIndex]) {
                case DecodedBitStreamParser.BEGIN_MACRO_PDF417_OPTIONAL_FIELD:
                    codeIndex++;
                    switch (codewords[codeIndex]) {
                        case DecodedBitStreamParser.MACRO_PDF417_OPTIONAL_FIELD_FILE_NAME:
                            var fileName = new StringBuilder_1.default();
                            codeIndex = DecodedBitStreamParser.textCompaction(codewords, codeIndex + 1, fileName);
                            resultMetadata.setFileName(fileName.toString());
                            break;
                        case DecodedBitStreamParser.MACRO_PDF417_OPTIONAL_FIELD_SENDER:
                            var sender = new StringBuilder_1.default();
                            codeIndex = DecodedBitStreamParser.textCompaction(codewords, codeIndex + 1, sender);
                            resultMetadata.setSender(sender.toString());
                            break;
                        case DecodedBitStreamParser.MACRO_PDF417_OPTIONAL_FIELD_ADDRESSEE:
                            var addressee = new StringBuilder_1.default();
                            codeIndex = DecodedBitStreamParser.textCompaction(codewords, codeIndex + 1, addressee);
                            resultMetadata.setAddressee(addressee.toString());
                            break;
                        case DecodedBitStreamParser.MACRO_PDF417_OPTIONAL_FIELD_SEGMENT_COUNT:
                            var segmentCount = new StringBuilder_1.default();
                            codeIndex = DecodedBitStreamParser.numericCompaction(codewords, codeIndex + 1, segmentCount);
                            resultMetadata.setSegmentCount(Integer_1.default.parseInt(segmentCount.toString()));
                            break;
                        case DecodedBitStreamParser.MACRO_PDF417_OPTIONAL_FIELD_TIME_STAMP:
                            var timestamp = new StringBuilder_1.default();
                            codeIndex = DecodedBitStreamParser.numericCompaction(codewords, codeIndex + 1, timestamp);
                            resultMetadata.setTimestamp(Long_1.default.parseLong(timestamp.toString()));
                            break;
                        case DecodedBitStreamParser.MACRO_PDF417_OPTIONAL_FIELD_CHECKSUM:
                            var checksum = new StringBuilder_1.default();
                            codeIndex = DecodedBitStreamParser.numericCompaction(codewords, codeIndex + 1, checksum);
                            resultMetadata.setChecksum(Integer_1.default.parseInt(checksum.toString()));
                            break;
                        case DecodedBitStreamParser.MACRO_PDF417_OPTIONAL_FIELD_FILE_SIZE:
                            var fileSize = new StringBuilder_1.default();
                            codeIndex = DecodedBitStreamParser.numericCompaction(codewords, codeIndex + 1, fileSize);
                            resultMetadata.setFileSize(Long_1.default.parseLong(fileSize.toString()));
                            break;
                        default:
                            throw FormatException_1.default.getFormatInstance();
                    }
                    break;
                case DecodedBitStreamParser.MACRO_PDF417_TERMINATOR:
                    codeIndex++;
                    resultMetadata.setLastSegment(true);
                    break;
                default:
                    throw FormatException_1.default.getFormatInstance();
            }
        }
        // copy optional fields to additional options
        if (optionalFieldsStart !== -1) {
            var optionalFieldsLength = codeIndex - optionalFieldsStart;
            if (resultMetadata.isLastSegment()) {
                // do not include terminator
                optionalFieldsLength--;
            }
            resultMetadata.setOptionalData(Arrays_1.default.copyOfRange(codewords, optionalFieldsStart, optionalFieldsStart + optionalFieldsLength));
        }
        return codeIndex;
    };
    /**
     * Text Compaction mode (see 5.4.1.5) permits all printable ASCII characters to be
     * encoded, i.e. values 32 - 126 inclusive in accordance with ISO/IEC 646 (IRV), as
     * well as selected control characters.
     *
     * @param codewords The array of codewords (data + error)
     * @param codeIndex The current index into the codeword array.
     * @param result    The decoded data is appended to the result.
     * @return The next index into the codeword array.
     */
    DecodedBitStreamParser.textCompaction = function (codewords, codeIndex, result) {
        // 2 character per codeword
        var textCompactionData = new Int32Array((codewords[0] - codeIndex) * 2);
        // Used to hold the byte compaction value if there is a mode shift
        var byteCompactionData = new Int32Array((codewords[0] - codeIndex) * 2);
        var index = 0;
        var end = false;
        while ((codeIndex < codewords[0]) && !end) {
            var code = codewords[codeIndex++];
            if (code < DecodedBitStreamParser.TEXT_COMPACTION_MODE_LATCH) {
                textCompactionData[index] = code / 30;
                textCompactionData[index + 1] = code % 30;
                index += 2;
            }
            else {
                switch (code) {
                    case DecodedBitStreamParser.TEXT_COMPACTION_MODE_LATCH:
                        // reinitialize text compaction mode to alpha sub mode
                        textCompactionData[index++] = DecodedBitStreamParser.TEXT_COMPACTION_MODE_LATCH;
                        break;
                    case DecodedBitStreamParser.BYTE_COMPACTION_MODE_LATCH:
                    case DecodedBitStreamParser.BYTE_COMPACTION_MODE_LATCH_6:
                    case DecodedBitStreamParser.NUMERIC_COMPACTION_MODE_LATCH:
                    case DecodedBitStreamParser.BEGIN_MACRO_PDF417_CONTROL_BLOCK:
                    case DecodedBitStreamParser.BEGIN_MACRO_PDF417_OPTIONAL_FIELD:
                    case DecodedBitStreamParser.MACRO_PDF417_TERMINATOR:
                        codeIndex--;
                        end = true;
                        break;
                    case DecodedBitStreamParser.MODE_SHIFT_TO_BYTE_COMPACTION_MODE:
                        // The Mode Shift codeword 913 shall cause a temporary
                        // switch from Text Compaction mode to Byte Compaction mode.
                        // This switch shall be in effect for only the next codeword,
                        // after which the mode shall revert to the prevailing sub-mode
                        // of the Text Compaction mode. Codeword 913 is only available
                        // in Text Compaction mode; its use is described in 5.4.2.4.
                        textCompactionData[index] = DecodedBitStreamParser.MODE_SHIFT_TO_BYTE_COMPACTION_MODE;
                        code = codewords[codeIndex++];
                        byteCompactionData[index] = code;
                        index++;
                        break;
                }
            }
        }
        DecodedBitStreamParser.decodeTextCompaction(textCompactionData, byteCompactionData, index, result);
        return codeIndex;
    };
    /**
     * The Text Compaction mode includes all the printable ASCII characters
     * (i.e. values from 32 to 126) and three ASCII control characters: HT or tab
     * (9: e), LF or line feed (10: e), and CR or carriage
     * return (13: e). The Text Compaction mode also includes various latch
     * and shift characters which are used exclusively within the mode. The Text
     * Compaction mode encodes up to 2 characters per codeword. The compaction rules
     * for converting data into PDF417 codewords are defined in 5.4.2.2. The sub-mode
     * switches are defined in 5.4.2.3.
     *
     * @param textCompactionData The text compaction data.
     * @param byteCompactionData The byte compaction data if there
     *                           was a mode shift.
     * @param length             The size of the text compaction and byte compaction data.
     * @param result             The decoded data is appended to the result.
     */
    DecodedBitStreamParser.decodeTextCompaction = function (textCompactionData, byteCompactionData, length, result) {
        // Beginning from an initial state of the Alpha sub-mode
        // The default compaction mode for PDF417 in effect at the start of each symbol shall always be Text
        // Compaction mode Alpha sub-mode (alphabetic: uppercase). A latch codeword from another mode to the Text
        // Compaction mode shall always switch to the Text Compaction Alpha sub-mode.
        var subMode = Mode.ALPHA;
        var priorToShiftMode = Mode.ALPHA;
        var i = 0;
        while (i < length) {
            var subModeCh = textCompactionData[i];
            var ch = /*char*/ '';
            switch (subMode) {
                case Mode.ALPHA:
                    // Alpha (alphabetic: uppercase)
                    if (subModeCh < 26) {
                        // Upper case Alpha Character
                        // Note: 65 = 'A' ASCII -> there is byte code of symbol
                        ch = /*(char)('A' + subModeCh) */ String.fromCharCode(65 + subModeCh);
                    }
                    else {
                        switch (subModeCh) {
                            case 26:
                                ch = ' ';
                                break;
                            case DecodedBitStreamParser.LL:
                                subMode = Mode.LOWER;
                                break;
                            case DecodedBitStreamParser.ML:
                                subMode = Mode.MIXED;
                                break;
                            case DecodedBitStreamParser.PS:
                                // Shift to punctuation
                                priorToShiftMode = subMode;
                                subMode = Mode.PUNCT_SHIFT;
                                break;
                            case DecodedBitStreamParser.MODE_SHIFT_TO_BYTE_COMPACTION_MODE:
                                result.append(/*(char)*/ byteCompactionData[i]);
                                break;
                            case DecodedBitStreamParser.TEXT_COMPACTION_MODE_LATCH:
                                subMode = Mode.ALPHA;
                                break;
                        }
                    }
                    break;
                case Mode.LOWER:
                    // Lower (alphabetic: lowercase)
                    if (subModeCh < 26) {
                        ch = /*(char)('a' + subModeCh)*/ String.fromCharCode(97 + subModeCh);
                    }
                    else {
                        switch (subModeCh) {
                            case 26:
                                ch = ' ';
                                break;
                            case DecodedBitStreamParser.AS:
                                // Shift to alpha
                                priorToShiftMode = subMode;
                                subMode = Mode.ALPHA_SHIFT;
                                break;
                            case DecodedBitStreamParser.ML:
                                subMode = Mode.MIXED;
                                break;
                            case DecodedBitStreamParser.PS:
                                // Shift to punctuation
                                priorToShiftMode = subMode;
                                subMode = Mode.PUNCT_SHIFT;
                                break;
                            case DecodedBitStreamParser.MODE_SHIFT_TO_BYTE_COMPACTION_MODE:
                                // TODO Does this need to use the current character encoding? See other occurrences below
                                result.append(/*(char)*/ byteCompactionData[i]);
                                break;
                            case DecodedBitStreamParser.TEXT_COMPACTION_MODE_LATCH:
                                subMode = Mode.ALPHA;
                                break;
                        }
                    }
                    break;
                case Mode.MIXED:
                    // Mixed (punctuation: e)
                    if (subModeCh < DecodedBitStreamParser.PL) {
                        ch = DecodedBitStreamParser.MIXED_CHARS[subModeCh];
                    }
                    else {
                        switch (subModeCh) {
                            case DecodedBitStreamParser.PL:
                                subMode = Mode.PUNCT;
                                break;
                            case 26:
                                ch = ' ';
                                break;
                            case DecodedBitStreamParser.LL:
                                subMode = Mode.LOWER;
                                break;
                            case DecodedBitStreamParser.AL:
                                subMode = Mode.ALPHA;
                                break;
                            case DecodedBitStreamParser.PS:
                                // Shift to punctuation
                                priorToShiftMode = subMode;
                                subMode = Mode.PUNCT_SHIFT;
                                break;
                            case DecodedBitStreamParser.MODE_SHIFT_TO_BYTE_COMPACTION_MODE:
                                result.append(/*(char)*/ byteCompactionData[i]);
                                break;
                            case DecodedBitStreamParser.TEXT_COMPACTION_MODE_LATCH:
                                subMode = Mode.ALPHA;
                                break;
                        }
                    }
                    break;
                case Mode.PUNCT:
                    // Punctuation
                    if (subModeCh < DecodedBitStreamParser.PAL) {
                        ch = DecodedBitStreamParser.PUNCT_CHARS[subModeCh];
                    }
                    else {
                        switch (subModeCh) {
                            case DecodedBitStreamParser.PAL:
                                subMode = Mode.ALPHA;
                                break;
                            case DecodedBitStreamParser.MODE_SHIFT_TO_BYTE_COMPACTION_MODE:
                                result.append(/*(char)*/ byteCompactionData[i]);
                                break;
                            case DecodedBitStreamParser.TEXT_COMPACTION_MODE_LATCH:
                                subMode = Mode.ALPHA;
                                break;
                        }
                    }
                    break;
                case Mode.ALPHA_SHIFT:
                    // Restore sub-mode
                    subMode = priorToShiftMode;
                    if (subModeCh < 26) {
                        ch = /*(char)('A' + subModeCh)*/ String.fromCharCode(65 + subModeCh);
                    }
                    else {
                        switch (subModeCh) {
                            case 26:
                                ch = ' ';
                                break;
                            case DecodedBitStreamParser.TEXT_COMPACTION_MODE_LATCH:
                                subMode = Mode.ALPHA;
                                break;
                        }
                    }
                    break;
                case Mode.PUNCT_SHIFT:
                    // Restore sub-mode
                    subMode = priorToShiftMode;
                    if (subModeCh < DecodedBitStreamParser.PAL) {
                        ch = DecodedBitStreamParser.PUNCT_CHARS[subModeCh];
                    }
                    else {
                        switch (subModeCh) {
                            case DecodedBitStreamParser.PAL:
                                subMode = Mode.ALPHA;
                                break;
                            case DecodedBitStreamParser.MODE_SHIFT_TO_BYTE_COMPACTION_MODE:
                                // PS before Shift-to-Byte is used as a padding character,
                                // see 5.4.2.4 of the specification
                                result.append(/*(char)*/ byteCompactionData[i]);
                                break;
                            case DecodedBitStreamParser.TEXT_COMPACTION_MODE_LATCH:
                                subMode = Mode.ALPHA;
                                break;
                        }
                    }
                    break;
            }
            // if (ch !== 0) {
            if (ch !== '') {
                // Append decoded character to result
                result.append(ch);
            }
            i++;
        }
    };
    /**
     * Byte Compaction mode (see 5.4.3) permits all 256 possible 8-bit byte values to be encoded.
     * This includes all ASCII characters value 0 to 127 inclusive and provides for international
     * character set support.
     *
     * @param mode      The byte compaction mode i.e. 901 or 924
     * @param codewords The array of codewords (data + error)
     * @param encoding  Currently active character encoding
     * @param codeIndex The current index into the codeword array.
     * @param result    The decoded data is appended to the result.
     * @return The next index into the codeword array.
     */
    DecodedBitStreamParser.byteCompaction = function (mode, codewords, encoding, codeIndex, result) {
        var decodedBytes = new ByteArrayOutputStream_1.default();
        var count = 0;
        var value = /*long*/ 0;
        var end = false;
        switch (mode) {
            case DecodedBitStreamParser.BYTE_COMPACTION_MODE_LATCH:
                // Total number of Byte Compaction characters to be encoded
                // is not a multiple of 6
                var byteCompactedCodewords = new Int32Array(6);
                var nextCode = codewords[codeIndex++];
                while ((codeIndex < codewords[0]) && !end) {
                    byteCompactedCodewords[count++] = nextCode;
                    // Base 900
                    value = 900 * value + nextCode;
                    nextCode = codewords[codeIndex++];
                    // perhaps it should be ok to check only nextCode >= TEXT_COMPACTION_MODE_LATCH
                    switch (nextCode) {
                        case DecodedBitStreamParser.TEXT_COMPACTION_MODE_LATCH:
                        case DecodedBitStreamParser.BYTE_COMPACTION_MODE_LATCH:
                        case DecodedBitStreamParser.NUMERIC_COMPACTION_MODE_LATCH:
                        case DecodedBitStreamParser.BYTE_COMPACTION_MODE_LATCH_6:
                        case DecodedBitStreamParser.BEGIN_MACRO_PDF417_CONTROL_BLOCK:
                        case DecodedBitStreamParser.BEGIN_MACRO_PDF417_OPTIONAL_FIELD:
                        case DecodedBitStreamParser.MACRO_PDF417_TERMINATOR:
                            codeIndex--;
                            end = true;
                            break;
                        default:
                            if ((count % 5 === 0) && (count > 0)) {
                                // Decode every 5 codewords
                                // Convert to Base 256
                                for (var j /*int*/ = 0; j < 6; ++j) {
                                    /* @note
                                     * JavaScript stores numbers as 64 bits floating point numbers, but all bitwise operations are performed on 32 bits binary numbers.
                                     * So the next bitwise operation could not be done with simple numbers
                                     */
                                    decodedBytes.write(/*(byte)*/ Number(createBigInt(value) >> createBigInt(8 * (5 - j))));
                                }
                                value = 0;
                                count = 0;
                            }
                            break;
                    }
                }
                // if the end of all codewords is reached the last codeword needs to be added
                if (codeIndex === codewords[0] && nextCode < DecodedBitStreamParser.TEXT_COMPACTION_MODE_LATCH) {
                    byteCompactedCodewords[count++] = nextCode;
                }
                // If Byte Compaction mode is invoked with codeword 901,
                // the last group of codewords is interpreted directly
                // as one byte per codeword, without compaction.
                for (var i /*int*/ = 0; i < count; i++) {
                    decodedBytes.write(/*(byte)*/ byteCompactedCodewords[i]);
                }
                break;
            case DecodedBitStreamParser.BYTE_COMPACTION_MODE_LATCH_6:
                // Total number of Byte Compaction characters to be encoded
                // is an integer multiple of 6
                while (codeIndex < codewords[0] && !end) {
                    var code = codewords[codeIndex++];
                    if (code < DecodedBitStreamParser.TEXT_COMPACTION_MODE_LATCH) {
                        count++;
                        // Base 900
                        value = 900 * value + code;
                    }
                    else {
                        switch (code) {
                            case DecodedBitStreamParser.TEXT_COMPACTION_MODE_LATCH:
                            case DecodedBitStreamParser.BYTE_COMPACTION_MODE_LATCH:
                            case DecodedBitStreamParser.NUMERIC_COMPACTION_MODE_LATCH:
                            case DecodedBitStreamParser.BYTE_COMPACTION_MODE_LATCH_6:
                            case DecodedBitStreamParser.BEGIN_MACRO_PDF417_CONTROL_BLOCK:
                            case DecodedBitStreamParser.BEGIN_MACRO_PDF417_OPTIONAL_FIELD:
                            case DecodedBitStreamParser.MACRO_PDF417_TERMINATOR:
                                codeIndex--;
                                end = true;
                                break;
                        }
                    }
                    if ((count % 5 === 0) && (count > 0)) {
                        // Decode every 5 codewords
                        // Convert to Base 256
                        /* @note
                         * JavaScript stores numbers as 64 bits floating point numbers, but all bitwise operations are performed on 32 bits binary numbers.
                         * So the next bitwise operation could not be done with simple numbers
                        */
                        for (var j /*int*/ = 0; j < 6; ++j) {
                            decodedBytes.write(/*(byte)*/ Number(createBigInt(value) >> createBigInt(8 * (5 - j))));
                        }
                        value = 0;
                        count = 0;
                    }
                }
                break;
        }
        result.append(StringEncoding_1.default.decode(decodedBytes.toByteArray(), encoding));
        return codeIndex;
    };
    /**
     * Numeric Compaction mode (see 5.4.4) permits efficient encoding of numeric data strings.
     *
     * @param codewords The array of codewords (data + error)
     * @param codeIndex The current index into the codeword array.
     * @param result    The decoded data is appended to the result.
     * @return The next index into the codeword array.
     *
     * @throws FormatException
     */
    DecodedBitStreamParser.numericCompaction = function (codewords, codeIndex /*int*/, result) {
        var count = 0;
        var end = false;
        var numericCodewords = new Int32Array(DecodedBitStreamParser.MAX_NUMERIC_CODEWORDS);
        while (codeIndex < codewords[0] && !end) {
            var code = codewords[codeIndex++];
            if (codeIndex === codewords[0]) {
                end = true;
            }
            if (code < DecodedBitStreamParser.TEXT_COMPACTION_MODE_LATCH) {
                numericCodewords[count] = code;
                count++;
            }
            else {
                switch (code) {
                    case DecodedBitStreamParser.TEXT_COMPACTION_MODE_LATCH:
                    case DecodedBitStreamParser.BYTE_COMPACTION_MODE_LATCH:
                    case DecodedBitStreamParser.BYTE_COMPACTION_MODE_LATCH_6:
                    case DecodedBitStreamParser.BEGIN_MACRO_PDF417_CONTROL_BLOCK:
                    case DecodedBitStreamParser.BEGIN_MACRO_PDF417_OPTIONAL_FIELD:
                    case DecodedBitStreamParser.MACRO_PDF417_TERMINATOR:
                        codeIndex--;
                        end = true;
                        break;
                }
            }
            if ((count % DecodedBitStreamParser.MAX_NUMERIC_CODEWORDS === 0 || code === DecodedBitStreamParser.NUMERIC_COMPACTION_MODE_LATCH || end) && count > 0) {
                // Re-invoking Numeric Compaction mode (by using codeword 902
                // while in Numeric Compaction mode) serves  to terminate the
                // current Numeric Compaction mode grouping as described in 5.4.4.2,
                // and then to start a new one grouping.
                result.append(DecodedBitStreamParser.decodeBase900toBase10(numericCodewords, count));
                count = 0;
            }
        }
        return codeIndex;
    };
    /**
     * Convert a list of Numeric Compacted codewords from Base 900 to Base 10.
     *
     * @param codewords The array of codewords
     * @param count     The number of codewords
     * @return The decoded string representing the Numeric data.
     *
     * EXAMPLE
     * Encode the fifteen digit numeric string 000213298174000
     * Prefix the numeric string with a 1 and set the initial value of
     * t = 1 000 213 298 174 000
     * Calculate codeword 0
     * d0 = 1 000 213 298 174 000 mod 900 = 200
     *
     * t = 1 000 213 298 174 000 div 900 = 1 111 348 109 082
     * Calculate codeword 1
     * d1 = 1 111 348 109 082 mod 900 = 282
     *
     * t = 1 111 348 109 082 div 900 = 1 234 831 232
     * Calculate codeword 2
     * d2 = 1 234 831 232 mod 900 = 632
     *
     * t = 1 234 831 232 div 900 = 1 372 034
     * Calculate codeword 3
     * d3 = 1 372 034 mod 900 = 434
     *
     * t = 1 372 034 div 900 = 1 524
     * Calculate codeword 4
     * d4 = 1 524 mod 900 = 624
     *
     * t = 1 524 div 900 = 1
     * Calculate codeword 5
     * d5 = 1 mod 900 = 1
     * t = 1 div 900 = 0
     * Codeword sequence is: 1, 624, 434, 632, 282, 200
     *
     * Decode the above codewords involves
     *   1 x 900 power of 5 + 624 x 900 power of 4 + 434 x 900 power of 3 +
     * 632 x 900 power of 2 + 282 x 900 power of 1 + 200 x 900 power of 0 = 1000213298174000
     *
     * Remove leading 1 =>  Result is 000213298174000
     *
     * @throws FormatException
     */
    DecodedBitStreamParser.decodeBase900toBase10 = function (codewords, count) {
        var result = createBigInt(0);
        for (var i /*int*/ = 0; i < count; i++) {
            result += DecodedBitStreamParser.EXP900[count - i - 1] * createBigInt(codewords[i]);
        }
        var resultString = result.toString();
        if (resultString.charAt(0) !== '1') {
            throw new FormatException_1.default();
        }
        return resultString.substring(1);
    };
    DecodedBitStreamParser.TEXT_COMPACTION_MODE_LATCH = 900;
    DecodedBitStreamParser.BYTE_COMPACTION_MODE_LATCH = 901;
    DecodedBitStreamParser.NUMERIC_COMPACTION_MODE_LATCH = 902;
    DecodedBitStreamParser.BYTE_COMPACTION_MODE_LATCH_6 = 924;
    DecodedBitStreamParser.ECI_USER_DEFINED = 925;
    DecodedBitStreamParser.ECI_GENERAL_PURPOSE = 926;
    DecodedBitStreamParser.ECI_CHARSET = 927;
    DecodedBitStreamParser.BEGIN_MACRO_PDF417_CONTROL_BLOCK = 928;
    DecodedBitStreamParser.BEGIN_MACRO_PDF417_OPTIONAL_FIELD = 923;
    DecodedBitStreamParser.MACRO_PDF417_TERMINATOR = 922;
    DecodedBitStreamParser.MODE_SHIFT_TO_BYTE_COMPACTION_MODE = 913;
    DecodedBitStreamParser.MAX_NUMERIC_CODEWORDS = 15;
    DecodedBitStreamParser.MACRO_PDF417_OPTIONAL_FIELD_FILE_NAME = 0;
    DecodedBitStreamParser.MACRO_PDF417_OPTIONAL_FIELD_SEGMENT_COUNT = 1;
    DecodedBitStreamParser.MACRO_PDF417_OPTIONAL_FIELD_TIME_STAMP = 2;
    DecodedBitStreamParser.MACRO_PDF417_OPTIONAL_FIELD_SENDER = 3;
    DecodedBitStreamParser.MACRO_PDF417_OPTIONAL_FIELD_ADDRESSEE = 4;
    DecodedBitStreamParser.MACRO_PDF417_OPTIONAL_FIELD_FILE_SIZE = 5;
    DecodedBitStreamParser.MACRO_PDF417_OPTIONAL_FIELD_CHECKSUM = 6;
    DecodedBitStreamParser.PL = 25;
    DecodedBitStreamParser.LL = 27;
    DecodedBitStreamParser.AS = 27;
    DecodedBitStreamParser.ML = 28;
    DecodedBitStreamParser.AL = 28;
    DecodedBitStreamParser.PS = 29;
    DecodedBitStreamParser.PAL = 29;
    DecodedBitStreamParser.PUNCT_CHARS = ';<>@[\\]_`~!\r\t,:\n-.$/"|*()?{}\'';
    DecodedBitStreamParser.MIXED_CHARS = '0123456789&\r\t,:#-.$/+%*=^';
    /**
     * Table containing values for the exponent of 900.
     * This is used in the numeric compaction decode algorithm.
     */
    DecodedBitStreamParser.EXP900 = getBigIntConstructor() ? getEXP900() : [];
    DecodedBitStreamParser.NUMBER_OF_SEQUENCE_CODEWORDS = 2;
    return DecodedBitStreamParser;
}());
exports.default = DecodedBitStreamParser;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\DecodedBitStreamParser.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\DetectionResult.js", {"../../util/Formatter":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\Formatter.js","../PDF417Common":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\PDF417Common.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cpdf417%5Cdecoder%5CDetectionResult.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2013 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
// package com.google.zxing.pdf417.decoder;
// import com.google.zxing.pdf417.PDF417Common;
var PDF417Common_1 = require("../PDF417Common");
var Formatter_1 = require("../../util/Formatter");
/**
 * @author Guenther Grau
 */
var DetectionResult = /** @class */ (function () {
    function DetectionResult(barcodeMetadata, boundingBox) {
        /*final*/ this.ADJUST_ROW_NUMBER_SKIP = 2;
        this.barcodeMetadata = barcodeMetadata;
        this.barcodeColumnCount = barcodeMetadata.getColumnCount();
        this.boundingBox = boundingBox;
        // this.detectionResultColumns = new DetectionResultColumn[this.barcodeColumnCount + 2];
        this.detectionResultColumns = new Array(this.barcodeColumnCount + 2);
    }
    DetectionResult.prototype.getDetectionResultColumns = function () {
        this.adjustIndicatorColumnRowNumbers(this.detectionResultColumns[0]);
        this.adjustIndicatorColumnRowNumbers(this.detectionResultColumns[this.barcodeColumnCount + 1]);
        var unadjustedCodewordCount = PDF417Common_1.default.MAX_CODEWORDS_IN_BARCODE;
        var previousUnadjustedCount;
        do {
            previousUnadjustedCount = unadjustedCodewordCount;
            unadjustedCodewordCount = this.adjustRowNumbersAndGetCount();
        } while (unadjustedCodewordCount > 0 && unadjustedCodewordCount < previousUnadjustedCount);
        return this.detectionResultColumns;
    };
    DetectionResult.prototype.adjustIndicatorColumnRowNumbers = function (detectionResultColumn) {
        if (detectionResultColumn != null) {
            detectionResultColumn
                .adjustCompleteIndicatorColumnRowNumbers(this.barcodeMetadata);
        }
    };
    // TODO ensure that no detected codewords with unknown row number are left
    // we should be able to estimate the row height and use it as a hint for the row number
    // we should also fill the rows top to bottom and bottom to top
    /**
     * @return number of codewords which don't have a valid row number. Note that the count is not accurate as codewords
     * will be counted several times. It just serves as an indicator to see when we can stop adjusting row numbers
     */
    DetectionResult.prototype.adjustRowNumbersAndGetCount = function () {
        var unadjustedCount = this.adjustRowNumbersByRow();
        if (unadjustedCount === 0) {
            return 0;
        }
        for (var barcodeColumn /*int*/ = 1; barcodeColumn < this.barcodeColumnCount + 1; barcodeColumn++) {
            var codewords = this.detectionResultColumns[barcodeColumn].getCodewords();
            for (var codewordsRow /*int*/ = 0; codewordsRow < codewords.length; codewordsRow++) {
                if (codewords[codewordsRow] == null) {
                    continue;
                }
                if (!codewords[codewordsRow].hasValidRowNumber()) {
                    this.adjustRowNumbers(barcodeColumn, codewordsRow, codewords);
                }
            }
        }
        return unadjustedCount;
    };
    DetectionResult.prototype.adjustRowNumbersByRow = function () {
        this.adjustRowNumbersFromBothRI();
        // TODO we should only do full row adjustments if row numbers of left and right row indicator column match.
        // Maybe it's even better to calculated the height (rows: d) and divide it by the number of barcode
        // rows. This, together with the LRI and RRI row numbers should allow us to get a good estimate where a row
        // number starts and ends.
        var unadjustedCount = this.adjustRowNumbersFromLRI();
        return unadjustedCount + this.adjustRowNumbersFromRRI();
    };
    DetectionResult.prototype.adjustRowNumbersFromBothRI = function () {
        if (this.detectionResultColumns[0] == null || this.detectionResultColumns[this.barcodeColumnCount + 1] == null) {
            return;
        }
        var LRIcodewords = this.detectionResultColumns[0].getCodewords();
        var RRIcodewords = this.detectionResultColumns[this.barcodeColumnCount + 1].getCodewords();
        for (var codewordsRow /*int*/ = 0; codewordsRow < LRIcodewords.length; codewordsRow++) {
            if (LRIcodewords[codewordsRow] != null &&
                RRIcodewords[codewordsRow] != null &&
                LRIcodewords[codewordsRow].getRowNumber() === RRIcodewords[codewordsRow].getRowNumber()) {
                for (var barcodeColumn /*int*/ = 1; barcodeColumn <= this.barcodeColumnCount; barcodeColumn++) {
                    var codeword = this.detectionResultColumns[barcodeColumn].getCodewords()[codewordsRow];
                    if (codeword == null) {
                        continue;
                    }
                    codeword.setRowNumber(LRIcodewords[codewordsRow].getRowNumber());
                    if (!codeword.hasValidRowNumber()) {
                        this.detectionResultColumns[barcodeColumn].getCodewords()[codewordsRow] = null;
                    }
                }
            }
        }
    };
    DetectionResult.prototype.adjustRowNumbersFromRRI = function () {
        if (this.detectionResultColumns[this.barcodeColumnCount + 1] == null) {
            return 0;
        }
        var unadjustedCount = 0;
        var codewords = this.detectionResultColumns[this.barcodeColumnCount + 1].getCodewords();
        for (var codewordsRow /*int*/ = 0; codewordsRow < codewords.length; codewordsRow++) {
            if (codewords[codewordsRow] == null) {
                continue;
            }
            var rowIndicatorRowNumber = codewords[codewordsRow].getRowNumber();
            var invalidRowCounts = 0;
            for (var barcodeColumn /*int*/ = this.barcodeColumnCount + 1; barcodeColumn > 0 && invalidRowCounts < this.ADJUST_ROW_NUMBER_SKIP; barcodeColumn--) {
                var codeword = this.detectionResultColumns[barcodeColumn].getCodewords()[codewordsRow];
                if (codeword != null) {
                    invalidRowCounts = DetectionResult.adjustRowNumberIfValid(rowIndicatorRowNumber, invalidRowCounts, codeword);
                    if (!codeword.hasValidRowNumber()) {
                        unadjustedCount++;
                    }
                }
            }
        }
        return unadjustedCount;
    };
    DetectionResult.prototype.adjustRowNumbersFromLRI = function () {
        if (this.detectionResultColumns[0] == null) {
            return 0;
        }
        var unadjustedCount = 0;
        var codewords = this.detectionResultColumns[0].getCodewords();
        for (var codewordsRow /*int*/ = 0; codewordsRow < codewords.length; codewordsRow++) {
            if (codewords[codewordsRow] == null) {
                continue;
            }
            var rowIndicatorRowNumber = codewords[codewordsRow].getRowNumber();
            var invalidRowCounts = 0;
            for (var barcodeColumn /*int*/ = 1; barcodeColumn < this.barcodeColumnCount + 1 && invalidRowCounts < this.ADJUST_ROW_NUMBER_SKIP; barcodeColumn++) {
                var codeword = this.detectionResultColumns[barcodeColumn].getCodewords()[codewordsRow];
                if (codeword != null) {
                    invalidRowCounts = DetectionResult.adjustRowNumberIfValid(rowIndicatorRowNumber, invalidRowCounts, codeword);
                    if (!codeword.hasValidRowNumber()) {
                        unadjustedCount++;
                    }
                }
            }
        }
        return unadjustedCount;
    };
    DetectionResult.adjustRowNumberIfValid = function (rowIndicatorRowNumber, invalidRowCounts, codeword) {
        if (codeword == null) {
            return invalidRowCounts;
        }
        if (!codeword.hasValidRowNumber()) {
            if (codeword.isValidRowNumber(rowIndicatorRowNumber)) {
                codeword.setRowNumber(rowIndicatorRowNumber);
                invalidRowCounts = 0;
            }
            else {
                ++invalidRowCounts;
            }
        }
        return invalidRowCounts;
    };
    DetectionResult.prototype.adjustRowNumbers = function (barcodeColumn, codewordsRow, codewords) {
        var e_1, _a;
        if (this.detectionResultColumns[barcodeColumn - 1] == null) {
            return;
        }
        var codeword = codewords[codewordsRow];
        var previousColumnCodewords = this.detectionResultColumns[barcodeColumn - 1].getCodewords();
        var nextColumnCodewords = previousColumnCodewords;
        if (this.detectionResultColumns[barcodeColumn + 1] != null) {
            nextColumnCodewords = this.detectionResultColumns[barcodeColumn + 1].getCodewords();
        }
        // let otherCodewords: Codeword[] = new Codeword[14];
        var otherCodewords = new Array(14);
        otherCodewords[2] = previousColumnCodewords[codewordsRow];
        otherCodewords[3] = nextColumnCodewords[codewordsRow];
        if (codewordsRow > 0) {
            otherCodewords[0] = codewords[codewordsRow - 1];
            otherCodewords[4] = previousColumnCodewords[codewordsRow - 1];
            otherCodewords[5] = nextColumnCodewords[codewordsRow - 1];
        }
        if (codewordsRow > 1) {
            otherCodewords[8] = codewords[codewordsRow - 2];
            otherCodewords[10] = previousColumnCodewords[codewordsRow - 2];
            otherCodewords[11] = nextColumnCodewords[codewordsRow - 2];
        }
        if (codewordsRow < codewords.length - 1) {
            otherCodewords[1] = codewords[codewordsRow + 1];
            otherCodewords[6] = previousColumnCodewords[codewordsRow + 1];
            otherCodewords[7] = nextColumnCodewords[codewordsRow + 1];
        }
        if (codewordsRow < codewords.length - 2) {
            otherCodewords[9] = codewords[codewordsRow + 2];
            otherCodewords[12] = previousColumnCodewords[codewordsRow + 2];
            otherCodewords[13] = nextColumnCodewords[codewordsRow + 2];
        }
        try {
            for (var otherCodewords_1 = __values(otherCodewords), otherCodewords_1_1 = otherCodewords_1.next(); !otherCodewords_1_1.done; otherCodewords_1_1 = otherCodewords_1.next()) {
                var otherCodeword = otherCodewords_1_1.value;
                if (DetectionResult.adjustRowNumber(codeword, otherCodeword)) {
                    return;
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (otherCodewords_1_1 && !otherCodewords_1_1.done && (_a = otherCodewords_1.return)) _a.call(otherCodewords_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
    };
    /**
     * @return true, if row number was adjusted, false otherwise
     */
    DetectionResult.adjustRowNumber = function (codeword, otherCodeword) {
        if (otherCodeword == null) {
            return false;
        }
        if (otherCodeword.hasValidRowNumber() && otherCodeword.getBucket() === codeword.getBucket()) {
            codeword.setRowNumber(otherCodeword.getRowNumber());
            return true;
        }
        return false;
    };
    DetectionResult.prototype.getBarcodeColumnCount = function () {
        return this.barcodeColumnCount;
    };
    DetectionResult.prototype.getBarcodeRowCount = function () {
        return this.barcodeMetadata.getRowCount();
    };
    DetectionResult.prototype.getBarcodeECLevel = function () {
        return this.barcodeMetadata.getErrorCorrectionLevel();
    };
    DetectionResult.prototype.setBoundingBox = function (boundingBox) {
        this.boundingBox = boundingBox;
    };
    DetectionResult.prototype.getBoundingBox = function () {
        return this.boundingBox;
    };
    DetectionResult.prototype.setDetectionResultColumn = function (barcodeColumn, detectionResultColumn) {
        this.detectionResultColumns[barcodeColumn] = detectionResultColumn;
    };
    DetectionResult.prototype.getDetectionResultColumn = function (barcodeColumn) {
        return this.detectionResultColumns[barcodeColumn];
    };
    // @Override
    DetectionResult.prototype.toString = function () {
        var rowIndicatorColumn = this.detectionResultColumns[0];
        if (rowIndicatorColumn == null) {
            rowIndicatorColumn = this.detectionResultColumns[this.barcodeColumnCount + 1];
        }
        // try (
        var formatter = new Formatter_1.default();
        // ) {
        for (var codewordsRow /*int*/ = 0; codewordsRow < rowIndicatorColumn.getCodewords().length; codewordsRow++) {
            formatter.format('CW %3d:', codewordsRow);
            for (var barcodeColumn /*int*/ = 0; barcodeColumn < this.barcodeColumnCount + 2; barcodeColumn++) {
                if (this.detectionResultColumns[barcodeColumn] == null) {
                    formatter.format('    |   ');
                    continue;
                }
                var codeword = this.detectionResultColumns[barcodeColumn].getCodewords()[codewordsRow];
                if (codeword == null) {
                    formatter.format('    |   ');
                    continue;
                }
                formatter.format(' %3d|%3d', codeword.getRowNumber(), codeword.getValue());
            }
            formatter.format('%n');
        }
        return formatter.toString();
        // }
    };
    return DetectionResult;
}());
exports.default = DetectionResult;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\DetectionResult.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\DetectionResultColumn.js", {"../../util/Formatter":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\Formatter.js","./BoundingBox":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\BoundingBox.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cpdf417%5Cdecoder%5CDetectionResultColumn.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2013 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
// package com.google.zxing.pdf417.decoder;
// import java.util.Formatter;
var Formatter_1 = require("../../util/Formatter");
var BoundingBox_1 = require("./BoundingBox");
/**
 * @author Guenther Grau
 */
var DetectionResultColumn = /** @class */ (function () {
    function DetectionResultColumn(boundingBox) {
        this.boundingBox = new BoundingBox_1.default(boundingBox);
        // this.codewords = new Codeword[boundingBox.getMaxY() - boundingBox.getMinY() + 1];
        this.codewords = new Array(boundingBox.getMaxY() - boundingBox.getMinY() + 1);
    }
    /*final*/ DetectionResultColumn.prototype.getCodewordNearby = function (imageRow) {
        var codeword = this.getCodeword(imageRow);
        if (codeword != null) {
            return codeword;
        }
        for (var i = 1; i < DetectionResultColumn.MAX_NEARBY_DISTANCE; i++) {
            var nearImageRow = this.imageRowToCodewordIndex(imageRow) - i;
            if (nearImageRow >= 0) {
                codeword = this.codewords[nearImageRow];
                if (codeword != null) {
                    return codeword;
                }
            }
            nearImageRow = this.imageRowToCodewordIndex(imageRow) + i;
            if (nearImageRow < this.codewords.length) {
                codeword = this.codewords[nearImageRow];
                if (codeword != null) {
                    return codeword;
                }
            }
        }
        return null;
    };
    /*final int*/ DetectionResultColumn.prototype.imageRowToCodewordIndex = function (imageRow) {
        return imageRow - this.boundingBox.getMinY();
    };
    /*final void*/ DetectionResultColumn.prototype.setCodeword = function (imageRow, codeword) {
        this.codewords[this.imageRowToCodewordIndex(imageRow)] = codeword;
    };
    /*final*/ DetectionResultColumn.prototype.getCodeword = function (imageRow) {
        return this.codewords[this.imageRowToCodewordIndex(imageRow)];
    };
    /*final*/ DetectionResultColumn.prototype.getBoundingBox = function () {
        return this.boundingBox;
    };
    /*final*/ DetectionResultColumn.prototype.getCodewords = function () {
        return this.codewords;
    };
    // @Override
    DetectionResultColumn.prototype.toString = function () {
        var e_1, _a;
        var formatter = new Formatter_1.default();
        var row = 0;
        try {
            for (var _b = __values(this.codewords), _c = _b.next(); !_c.done; _c = _b.next()) {
                var codeword = _c.value;
                if (codeword == null) {
                    formatter.format('%3d:    |   %n', row++);
                    continue;
                }
                formatter.format('%3d: %3d|%3d%n', row++, codeword.getRowNumber(), codeword.getValue());
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return formatter.toString();
    };
    DetectionResultColumn.MAX_NEARBY_DISTANCE = 5;
    return DetectionResultColumn;
}());
exports.default = DetectionResultColumn;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\DetectionResultColumn.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\DetectionResultRowIndicatorColumn.js", {"../PDF417Common":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\PDF417Common.js","./BarcodeMetadata":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\BarcodeMetadata.js","./BarcodeValue":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\BarcodeValue.js","./DetectionResultColumn":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\DetectionResultColumn.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cpdf417%5Cdecoder%5CDetectionResultRowIndicatorColumn.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2013 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
// import com.google.zxing.pdf417.PDF417Common;
var PDF417Common_1 = require("../PDF417Common");
var BarcodeMetadata_1 = require("./BarcodeMetadata");
var DetectionResultColumn_1 = require("./DetectionResultColumn");
var BarcodeValue_1 = require("./BarcodeValue");
/**
 * @author Guenther Grau
 */
var DetectionResultRowIndicatorColumn = /** @class */ (function (_super) {
    __extends(DetectionResultRowIndicatorColumn, _super);
    function DetectionResultRowIndicatorColumn(boundingBox, isLeft) {
        var _this = _super.call(this, boundingBox) || this;
        _this._isLeft = isLeft;
        return _this;
    }
    DetectionResultRowIndicatorColumn.prototype.setRowNumbers = function () {
        var e_1, _a;
        try {
            for (var _b = __values(this.getCodewords()), _c = _b.next(); !_c.done; _c = _b.next()) {
                var codeword = _c.value /*Codeword*/;
                if (codeword != null) {
                    codeword.setRowNumberAsRowIndicatorColumn();
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
    };
    // TODO implement properly
    // TODO maybe we should add missing codewords to store the correct row number to make
    // finding row numbers for other columns easier
    // use row height count to make detection of invalid row numbers more reliable
    DetectionResultRowIndicatorColumn.prototype.adjustCompleteIndicatorColumnRowNumbers = function (barcodeMetadata) {
        var codewords = this.getCodewords();
        this.setRowNumbers();
        this.removeIncorrectCodewords(codewords, barcodeMetadata);
        var boundingBox = this.getBoundingBox();
        var top = this._isLeft ? boundingBox.getTopLeft() : boundingBox.getTopRight();
        var bottom = this._isLeft ? boundingBox.getBottomLeft() : boundingBox.getBottomRight();
        var firstRow = this.imageRowToCodewordIndex(Math.trunc(top.getY()));
        var lastRow = this.imageRowToCodewordIndex(Math.trunc(bottom.getY()));
        // We need to be careful using the average row height. Barcode could be skewed so that we have smaller and
        // taller rows
        // float averageRowHeight = (lastRow - firstRow) / /*(float)*/ barcodeMetadata.getRowCount();
        var barcodeRow = -1;
        var maxRowHeight = 1;
        var currentRowHeight = 0;
        for (var codewordsRow /*int*/ = firstRow; codewordsRow < lastRow; codewordsRow++) {
            if (codewords[codewordsRow] == null) {
                continue;
            }
            var codeword = codewords[codewordsRow];
            //      float expectedRowNumber = (codewordsRow - firstRow) / averageRowHeight;
            //      if (Math.abs(codeword.getRowNumber() - expectedRowNumber) > 2) {
            //        SimpleLog.log(LEVEL.WARNING,
            //            "Removing codeword, rowNumberSkew too high, codeword[" + codewordsRow + "]: Expected Row: " +
            //                expectedRowNumber + ", RealRow: " + codeword.getRowNumber() + ", value: " + codeword.getValue());
            //        codewords[codewordsRow] = null;
            //      }
            var rowDifference = codeword.getRowNumber() - barcodeRow;
            // TODO improve handling with case where first row indicator doesn't start with 0
            if (rowDifference === 0) {
                currentRowHeight++;
            }
            else if (rowDifference === 1) {
                maxRowHeight = Math.max(maxRowHeight, currentRowHeight);
                currentRowHeight = 1;
                barcodeRow = codeword.getRowNumber();
            }
            else if (rowDifference < 0 ||
                codeword.getRowNumber() >= barcodeMetadata.getRowCount() ||
                rowDifference > codewordsRow) {
                codewords[codewordsRow] = null;
            }
            else {
                var checkedRows = void 0;
                if (maxRowHeight > 2) {
                    checkedRows = (maxRowHeight - 2) * rowDifference;
                }
                else {
                    checkedRows = rowDifference;
                }
                var closePreviousCodewordFound = checkedRows >= codewordsRow;
                for (var i /*int*/ = 1; i <= checkedRows && !closePreviousCodewordFound; i++) {
                    // there must be (height * rowDifference) number of codewords missing. For now we assume height = 1.
                    // This should hopefully get rid of most problems already.
                    closePreviousCodewordFound = codewords[codewordsRow - i] != null;
                }
                if (closePreviousCodewordFound) {
                    codewords[codewordsRow] = null;
                }
                else {
                    barcodeRow = codeword.getRowNumber();
                    currentRowHeight = 1;
                }
            }
        }
        // return (int) (averageRowHeight + 0.5);
    };
    DetectionResultRowIndicatorColumn.prototype.getRowHeights = function () {
        var e_2, _a;
        var barcodeMetadata = this.getBarcodeMetadata();
        if (barcodeMetadata == null) {
            return null;
        }
        this.adjustIncompleteIndicatorColumnRowNumbers(barcodeMetadata);
        var result = new Int32Array(barcodeMetadata.getRowCount());
        try {
            for (var _b = __values(this.getCodewords()), _c = _b.next(); !_c.done; _c = _b.next()) {
                var codeword = _c.value /*Codeword*/;
                if (codeword != null) {
                    var rowNumber = codeword.getRowNumber();
                    if (rowNumber >= result.length) {
                        // We have more rows than the barcode metadata allows for, ignore them.
                        continue;
                    }
                    result[rowNumber]++;
                } // else throw exception?
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
        return result;
    };
    // TODO maybe we should add missing codewords to store the correct row number to make
    // finding row numbers for other columns easier
    // use row height count to make detection of invalid row numbers more reliable
    DetectionResultRowIndicatorColumn.prototype.adjustIncompleteIndicatorColumnRowNumbers = function (barcodeMetadata) {
        var boundingBox = this.getBoundingBox();
        var top = this._isLeft ? boundingBox.getTopLeft() : boundingBox.getTopRight();
        var bottom = this._isLeft ? boundingBox.getBottomLeft() : boundingBox.getBottomRight();
        var firstRow = this.imageRowToCodewordIndex(Math.trunc(top.getY()));
        var lastRow = this.imageRowToCodewordIndex(Math.trunc(bottom.getY()));
        // float averageRowHeight = (lastRow - firstRow) / /*(float)*/ barcodeMetadata.getRowCount();
        var codewords = this.getCodewords();
        var barcodeRow = -1;
        var maxRowHeight = 1;
        var currentRowHeight = 0;
        for (var codewordsRow /*int*/ = firstRow; codewordsRow < lastRow; codewordsRow++) {
            if (codewords[codewordsRow] == null) {
                continue;
            }
            var codeword = codewords[codewordsRow];
            codeword.setRowNumberAsRowIndicatorColumn();
            var rowDifference = codeword.getRowNumber() - barcodeRow;
            // TODO improve handling with case where first row indicator doesn't start with 0
            if (rowDifference === 0) {
                currentRowHeight++;
            }
            else if (rowDifference === 1) {
                maxRowHeight = Math.max(maxRowHeight, currentRowHeight);
                currentRowHeight = 1;
                barcodeRow = codeword.getRowNumber();
            }
            else if (codeword.getRowNumber() >= barcodeMetadata.getRowCount()) {
                codewords[codewordsRow] = null;
            }
            else {
                barcodeRow = codeword.getRowNumber();
                currentRowHeight = 1;
            }
        }
        // return (int) (averageRowHeight + 0.5);
    };
    DetectionResultRowIndicatorColumn.prototype.getBarcodeMetadata = function () {
        var e_3, _a;
        var codewords = this.getCodewords();
        var barcodeColumnCount = new BarcodeValue_1.default();
        var barcodeRowCountUpperPart = new BarcodeValue_1.default();
        var barcodeRowCountLowerPart = new BarcodeValue_1.default();
        var barcodeECLevel = new BarcodeValue_1.default();
        try {
            for (var codewords_1 = __values(codewords), codewords_1_1 = codewords_1.next(); !codewords_1_1.done; codewords_1_1 = codewords_1.next()) {
                var codeword = codewords_1_1.value /*Codeword*/;
                if (codeword == null) {
                    continue;
                }
                codeword.setRowNumberAsRowIndicatorColumn();
                var rowIndicatorValue = codeword.getValue() % 30;
                var codewordRowNumber = codeword.getRowNumber();
                if (!this._isLeft) {
                    codewordRowNumber += 2;
                }
                switch (codewordRowNumber % 3) {
                    case 0:
                        barcodeRowCountUpperPart.setValue(rowIndicatorValue * 3 + 1);
                        break;
                    case 1:
                        barcodeECLevel.setValue(rowIndicatorValue / 3);
                        barcodeRowCountLowerPart.setValue(rowIndicatorValue % 3);
                        break;
                    case 2:
                        barcodeColumnCount.setValue(rowIndicatorValue + 1);
                        break;
                }
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (codewords_1_1 && !codewords_1_1.done && (_a = codewords_1.return)) _a.call(codewords_1);
            }
            finally { if (e_3) throw e_3.error; }
        }
        // Maybe we should check if we have ambiguous values?
        if ((barcodeColumnCount.getValue().length === 0) ||
            (barcodeRowCountUpperPart.getValue().length === 0) ||
            (barcodeRowCountLowerPart.getValue().length === 0) ||
            (barcodeECLevel.getValue().length === 0) ||
            barcodeColumnCount.getValue()[0] < 1 ||
            barcodeRowCountUpperPart.getValue()[0] + barcodeRowCountLowerPart.getValue()[0] < PDF417Common_1.default.MIN_ROWS_IN_BARCODE ||
            barcodeRowCountUpperPart.getValue()[0] + barcodeRowCountLowerPart.getValue()[0] > PDF417Common_1.default.MAX_ROWS_IN_BARCODE) {
            return null;
        }
        var barcodeMetadata = new BarcodeMetadata_1.default(barcodeColumnCount.getValue()[0], barcodeRowCountUpperPart.getValue()[0], barcodeRowCountLowerPart.getValue()[0], barcodeECLevel.getValue()[0]);
        this.removeIncorrectCodewords(codewords, barcodeMetadata);
        return barcodeMetadata;
    };
    DetectionResultRowIndicatorColumn.prototype.removeIncorrectCodewords = function (codewords, barcodeMetadata) {
        // Remove codewords which do not match the metadata
        // TODO Maybe we should keep the incorrect codewords for the start and end positions?
        for (var codewordRow /*int*/ = 0; codewordRow < codewords.length; codewordRow++) {
            var codeword = codewords[codewordRow];
            if (codewords[codewordRow] == null) {
                continue;
            }
            var rowIndicatorValue = codeword.getValue() % 30;
            var codewordRowNumber = codeword.getRowNumber();
            if (codewordRowNumber > barcodeMetadata.getRowCount()) {
                codewords[codewordRow] = null;
                continue;
            }
            if (!this._isLeft) {
                codewordRowNumber += 2;
            }
            switch (codewordRowNumber % 3) {
                case 0:
                    if (rowIndicatorValue * 3 + 1 !== barcodeMetadata.getRowCountUpperPart()) {
                        codewords[codewordRow] = null;
                    }
                    break;
                case 1:
                    if (Math.trunc(rowIndicatorValue / 3) !== barcodeMetadata.getErrorCorrectionLevel() ||
                        rowIndicatorValue % 3 !== barcodeMetadata.getRowCountLowerPart()) {
                        codewords[codewordRow] = null;
                    }
                    break;
                case 2:
                    if (rowIndicatorValue + 1 !== barcodeMetadata.getColumnCount()) {
                        codewords[codewordRow] = null;
                    }
                    break;
            }
        }
    };
    DetectionResultRowIndicatorColumn.prototype.isLeft = function () {
        return this._isLeft;
    };
    // @Override
    DetectionResultRowIndicatorColumn.prototype.toString = function () {
        return 'IsLeft: ' + this._isLeft + '\n' + _super.prototype.toString.call(this);
    };
    return DetectionResultRowIndicatorColumn;
}(DetectionResultColumn_1.default));
exports.default = DetectionResultRowIndicatorColumn;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\DetectionResultRowIndicatorColumn.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\PDF417CodewordDecoder.js", {"../../common/detector/MathUtils":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\detector\\MathUtils.js","../../util/Float":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\Float.js","../PDF417Common":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\PDF417Common.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cpdf417%5Cdecoder%5CPDF417CodewordDecoder.js
      return function (require, module, exports) {
"use strict";
/*
* Copyright 2013 ZXing authors
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
Object.defineProperty(exports, "__esModule", { value: true });
// package com.google.zxing.pdf417.decoder;
// import com.google.zxing.common.detector.MathUtils;
var MathUtils_1 = require("../../common/detector/MathUtils");
// import com.google.zxing.pdf417.PDF417Common;
var PDF417Common_1 = require("../PDF417Common");
var Float_1 = require("../../util/Float");
/**
 * @author Guenther Grau
 * @author creatale GmbH (christoph.schulz@creatale.de)
 */
var PDF417CodewordDecoder = /** @class */ (function () {
    function PDF417CodewordDecoder() {
    }
    /* @note
     * this action have to be performed before first use of class
     * - static constructor
     * working with 32bit float (based from Java logic)
    */
    PDF417CodewordDecoder.initialize = function () {
        // Pre-computes the symbol ratio table.
        for ( /*int*/var i = 0; i < PDF417Common_1.default.SYMBOL_TABLE.length; i++) {
            var currentSymbol = PDF417Common_1.default.SYMBOL_TABLE[i];
            var currentBit = currentSymbol & 0x1;
            for ( /*int*/var j = 0; j < PDF417Common_1.default.BARS_IN_MODULE; j++) {
                var size = 0.0;
                while ((currentSymbol & 0x1) === currentBit) {
                    size += 1.0;
                    currentSymbol >>= 1;
                }
                currentBit = currentSymbol & 0x1;
                if (!PDF417CodewordDecoder.RATIOS_TABLE[i]) {
                    PDF417CodewordDecoder.RATIOS_TABLE[i] = new Array(PDF417Common_1.default.BARS_IN_MODULE);
                }
                PDF417CodewordDecoder.RATIOS_TABLE[i][PDF417Common_1.default.BARS_IN_MODULE - j - 1] = Math.fround(size / PDF417Common_1.default.MODULES_IN_CODEWORD);
            }
        }
        this.bSymbolTableReady = true;
    };
    PDF417CodewordDecoder.getDecodedValue = function (moduleBitCount) {
        var decodedValue = PDF417CodewordDecoder.getDecodedCodewordValue(PDF417CodewordDecoder.sampleBitCounts(moduleBitCount));
        if (decodedValue !== -1) {
            return decodedValue;
        }
        return PDF417CodewordDecoder.getClosestDecodedValue(moduleBitCount);
    };
    PDF417CodewordDecoder.sampleBitCounts = function (moduleBitCount) {
        var bitCountSum = MathUtils_1.default.sum(moduleBitCount);
        var result = new Int32Array(PDF417Common_1.default.BARS_IN_MODULE);
        var bitCountIndex = 0;
        var sumPreviousBits = 0;
        for ( /*int*/var i = 0; i < PDF417Common_1.default.MODULES_IN_CODEWORD; i++) {
            var sampleIndex = bitCountSum / (2 * PDF417Common_1.default.MODULES_IN_CODEWORD) +
                (i * bitCountSum) / PDF417Common_1.default.MODULES_IN_CODEWORD;
            if (sumPreviousBits + moduleBitCount[bitCountIndex] <= sampleIndex) {
                sumPreviousBits += moduleBitCount[bitCountIndex];
                bitCountIndex++;
            }
            result[bitCountIndex]++;
        }
        return result;
    };
    PDF417CodewordDecoder.getDecodedCodewordValue = function (moduleBitCount) {
        var decodedValue = PDF417CodewordDecoder.getBitValue(moduleBitCount);
        return PDF417Common_1.default.getCodeword(decodedValue) === -1 ? -1 : decodedValue;
    };
    PDF417CodewordDecoder.getBitValue = function (moduleBitCount) {
        var result = /*long*/ 0;
        for (var /*int*/ i = 0; i < moduleBitCount.length; i++) {
            for ( /*int*/var bit = 0; bit < moduleBitCount[i]; bit++) {
                result = (result << 1) | (i % 2 === 0 ? 1 : 0);
            }
        }
        return Math.trunc(result);
    };
    // working with 32bit float (as in Java)
    PDF417CodewordDecoder.getClosestDecodedValue = function (moduleBitCount) {
        var bitCountSum = MathUtils_1.default.sum(moduleBitCount);
        var bitCountRatios = new Array(PDF417Common_1.default.BARS_IN_MODULE);
        if (bitCountSum > 1) {
            for (var /*int*/ i = 0; i < bitCountRatios.length; i++) {
                bitCountRatios[i] = Math.fround(moduleBitCount[i] / bitCountSum);
            }
        }
        var bestMatchError = Float_1.default.MAX_VALUE;
        var bestMatch = -1;
        if (!this.bSymbolTableReady) {
            PDF417CodewordDecoder.initialize();
        }
        for ( /*int*/var j = 0; j < PDF417CodewordDecoder.RATIOS_TABLE.length; j++) {
            var error = 0.0;
            var ratioTableRow = PDF417CodewordDecoder.RATIOS_TABLE[j];
            for ( /*int*/var k = 0; k < PDF417Common_1.default.BARS_IN_MODULE; k++) {
                var diff = Math.fround(ratioTableRow[k] - bitCountRatios[k]);
                error += Math.fround(diff * diff);
                if (error >= bestMatchError) {
                    break;
                }
            }
            if (error < bestMatchError) {
                bestMatchError = error;
                bestMatch = PDF417Common_1.default.SYMBOL_TABLE[j];
            }
        }
        return bestMatch;
    };
    // flag that the table is ready for use
    PDF417CodewordDecoder.bSymbolTableReady = false;
    PDF417CodewordDecoder.RATIOS_TABLE = new Array(PDF417Common_1.default.SYMBOL_TABLE.length).map(function (x) { return x = new Array(PDF417Common_1.default.BARS_IN_MODULE); });
    return PDF417CodewordDecoder;
}());
exports.default = PDF417CodewordDecoder;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\PDF417CodewordDecoder.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\PDF417ScanningDecoder.js", {"../../ChecksumException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\ChecksumException.js","../../FormatException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\FormatException.js","../../NotFoundException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\NotFoundException.js","../../common/detector/MathUtils":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\detector\\MathUtils.js","../../util/Formatter":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\Formatter.js","../PDF417Common":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\PDF417Common.js","./BarcodeValue":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\BarcodeValue.js","./BoundingBox":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\BoundingBox.js","./Codeword":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\Codeword.js","./DecodedBitStreamParser":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\DecodedBitStreamParser.js","./DetectionResult":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\DetectionResult.js","./DetectionResultColumn":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\DetectionResultColumn.js","./DetectionResultRowIndicatorColumn":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\DetectionResultRowIndicatorColumn.js","./PDF417CodewordDecoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\PDF417CodewordDecoder.js","./ec/ErrorCorrection":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\ec\\ErrorCorrection.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cpdf417%5Cdecoder%5CPDF417ScanningDecoder.js
      return function (require, module, exports) {
"use strict";
/*
* Copyright 2013 ZXing authors
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
// package com.google.zxing.pdf417.decoder;
// import com.google.zxing.ChecksumException;
var ChecksumException_1 = require("../../ChecksumException");
// import com.google.zxing.FormatException;
var FormatException_1 = require("../../FormatException");
// import com.google.zxing.NotFoundException;
var NotFoundException_1 = require("../../NotFoundException");
// import com.google.zxing.common.detector.MathUtils;
var MathUtils_1 = require("../../common/detector/MathUtils");
// import com.google.zxing.pdf417.PDF417Common;
var PDF417Common_1 = require("../PDF417Common");
// import com.google.zxing.pdf417.decoder.ec.ErrorCorrection;
var ErrorCorrection_1 = require("./ec/ErrorCorrection");
// local
var BoundingBox_1 = require("./BoundingBox");
var DetectionResultRowIndicatorColumn_1 = require("./DetectionResultRowIndicatorColumn");
var DetectionResult_1 = require("./DetectionResult");
var DetectionResultColumn_1 = require("./DetectionResultColumn");
var Codeword_1 = require("./Codeword");
var BarcodeValue_1 = require("./BarcodeValue");
var PDF417CodewordDecoder_1 = require("./PDF417CodewordDecoder");
var DecodedBitStreamParser_1 = require("./DecodedBitStreamParser");
// utils
var Formatter_1 = require("../../util/Formatter");
// import java.util.ArrayList;
// import java.util.Collection;
// import java.util.Formatter;
// import java.util.List;
/**
 * @author Guenther Grau
 */
var PDF417ScanningDecoder = /** @class */ (function () {
    function PDF417ScanningDecoder() {
    }
    /**
     * @TODO don't pass in minCodewordWidth and maxCodewordWidth, pass in barcode columns for start and stop pattern
     *
     * columns. That way width can be deducted from the pattern column.
     * This approach also allows to detect more details about the barcode, e.g. if a bar type (white or black) is wider
     * than it should be. This can happen if the scanner used a bad blackpoint.
     *
     * @param BitMatrix
     * @param image
     * @param ResultPoint
     * @param imageTopLeft
     * @param ResultPoint
     * @param imageBottomLeft
     * @param ResultPoint
     * @param imageTopRight
     * @param ResultPoint
     * @param imageBottomRight
     * @param int
     * @param minCodewordWidth
     * @param int
     * @param maxCodewordWidth
     *
     * @throws NotFoundException
     * @throws FormatException
     * @throws ChecksumException
     */
    PDF417ScanningDecoder.decode = function (image, imageTopLeft, imageBottomLeft, imageTopRight, imageBottomRight, minCodewordWidth, maxCodewordWidth) {
        var boundingBox = new BoundingBox_1.default(image, imageTopLeft, imageBottomLeft, imageTopRight, imageBottomRight);
        var leftRowIndicatorColumn = null;
        var rightRowIndicatorColumn = null;
        var detectionResult;
        for (var firstPass /*boolean*/ = true;; firstPass = false) {
            if (imageTopLeft != null) {
                leftRowIndicatorColumn = PDF417ScanningDecoder.getRowIndicatorColumn(image, boundingBox, imageTopLeft, true, minCodewordWidth, maxCodewordWidth);
            }
            if (imageTopRight != null) {
                rightRowIndicatorColumn = PDF417ScanningDecoder.getRowIndicatorColumn(image, boundingBox, imageTopRight, false, minCodewordWidth, maxCodewordWidth);
            }
            detectionResult = PDF417ScanningDecoder.merge(leftRowIndicatorColumn, rightRowIndicatorColumn);
            if (detectionResult == null) {
                throw NotFoundException_1.default.getNotFoundInstance();
            }
            var resultBox = detectionResult.getBoundingBox();
            if (firstPass && resultBox != null &&
                (resultBox.getMinY() < boundingBox.getMinY() || resultBox.getMaxY() > boundingBox.getMaxY())) {
                boundingBox = resultBox;
            }
            else {
                break;
            }
        }
        detectionResult.setBoundingBox(boundingBox);
        var maxBarcodeColumn = detectionResult.getBarcodeColumnCount() + 1;
        detectionResult.setDetectionResultColumn(0, leftRowIndicatorColumn);
        detectionResult.setDetectionResultColumn(maxBarcodeColumn, rightRowIndicatorColumn);
        var leftToRight = leftRowIndicatorColumn != null;
        for (var barcodeColumnCount /*int*/ = 1; barcodeColumnCount <= maxBarcodeColumn; barcodeColumnCount++) {
            var barcodeColumn = leftToRight ? barcodeColumnCount : maxBarcodeColumn - barcodeColumnCount;
            if (detectionResult.getDetectionResultColumn(barcodeColumn) !== /* null */ undefined) {
                // This will be the case for the opposite row indicator column, which doesn't need to be decoded again.
                continue;
            }
            var detectionResultColumn = void 0;
            if (barcodeColumn === 0 || barcodeColumn === maxBarcodeColumn) {
                detectionResultColumn = new DetectionResultRowIndicatorColumn_1.default(boundingBox, barcodeColumn === 0);
            }
            else {
                detectionResultColumn = new DetectionResultColumn_1.default(boundingBox);
            }
            detectionResult.setDetectionResultColumn(barcodeColumn, detectionResultColumn);
            var startColumn = -1;
            var previousStartColumn = startColumn;
            // TODO start at a row for which we know the start position, then detect upwards and downwards from there.
            for (var imageRow /*int*/ = boundingBox.getMinY(); imageRow <= boundingBox.getMaxY(); imageRow++) {
                startColumn = PDF417ScanningDecoder.getStartColumn(detectionResult, barcodeColumn, imageRow, leftToRight);
                if (startColumn < 0 || startColumn > boundingBox.getMaxX()) {
                    if (previousStartColumn === -1) {
                        continue;
                    }
                    startColumn = previousStartColumn;
                }
                var codeword = PDF417ScanningDecoder.detectCodeword(image, boundingBox.getMinX(), boundingBox.getMaxX(), leftToRight, startColumn, imageRow, minCodewordWidth, maxCodewordWidth);
                if (codeword != null) {
                    detectionResultColumn.setCodeword(imageRow, codeword);
                    previousStartColumn = startColumn;
                    minCodewordWidth = Math.min(minCodewordWidth, codeword.getWidth());
                    maxCodewordWidth = Math.max(maxCodewordWidth, codeword.getWidth());
                }
            }
        }
        return PDF417ScanningDecoder.createDecoderResult(detectionResult);
    };
    /**
     *
     * @param leftRowIndicatorColumn
     * @param rightRowIndicatorColumn
     *
     * @throws NotFoundException
     */
    PDF417ScanningDecoder.merge = function (leftRowIndicatorColumn, rightRowIndicatorColumn) {
        if (leftRowIndicatorColumn == null && rightRowIndicatorColumn == null) {
            return null;
        }
        var barcodeMetadata = PDF417ScanningDecoder.getBarcodeMetadata(leftRowIndicatorColumn, rightRowIndicatorColumn);
        if (barcodeMetadata == null) {
            return null;
        }
        var boundingBox = BoundingBox_1.default.merge(PDF417ScanningDecoder.adjustBoundingBox(leftRowIndicatorColumn), PDF417ScanningDecoder.adjustBoundingBox(rightRowIndicatorColumn));
        return new DetectionResult_1.default(barcodeMetadata, boundingBox);
    };
    /**
     *
     * @param rowIndicatorColumn
     *
     * @throws NotFoundException
     */
    PDF417ScanningDecoder.adjustBoundingBox = function (rowIndicatorColumn) {
        var e_1, _a;
        if (rowIndicatorColumn == null) {
            return null;
        }
        var rowHeights = rowIndicatorColumn.getRowHeights();
        if (rowHeights == null) {
            return null;
        }
        var maxRowHeight = PDF417ScanningDecoder.getMax(rowHeights);
        var missingStartRows = 0;
        try {
            for (var rowHeights_1 = __values(rowHeights), rowHeights_1_1 = rowHeights_1.next(); !rowHeights_1_1.done; rowHeights_1_1 = rowHeights_1.next()) {
                var rowHeight = rowHeights_1_1.value /*int*/;
                missingStartRows += maxRowHeight - rowHeight;
                if (rowHeight > 0) {
                    break;
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (rowHeights_1_1 && !rowHeights_1_1.done && (_a = rowHeights_1.return)) _a.call(rowHeights_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        var codewords = rowIndicatorColumn.getCodewords();
        for (var row /*int*/ = 0; missingStartRows > 0 && codewords[row] == null; row++) {
            missingStartRows--;
        }
        var missingEndRows = 0;
        for (var row /*int*/ = rowHeights.length - 1; row >= 0; row--) {
            missingEndRows += maxRowHeight - rowHeights[row];
            if (rowHeights[row] > 0) {
                break;
            }
        }
        for (var row /*int*/ = codewords.length - 1; missingEndRows > 0 && codewords[row] == null; row--) {
            missingEndRows--;
        }
        return rowIndicatorColumn.getBoundingBox().addMissingRows(missingStartRows, missingEndRows, rowIndicatorColumn.isLeft());
    };
    PDF417ScanningDecoder.getMax = function (values) {
        var e_2, _a;
        var maxValue = -1;
        try {
            for (var values_1 = __values(values), values_1_1 = values_1.next(); !values_1_1.done; values_1_1 = values_1.next()) {
                var value = values_1_1.value /*int*/;
                maxValue = Math.max(maxValue, value);
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (values_1_1 && !values_1_1.done && (_a = values_1.return)) _a.call(values_1);
            }
            finally { if (e_2) throw e_2.error; }
        }
        return maxValue;
    };
    PDF417ScanningDecoder.getBarcodeMetadata = function (leftRowIndicatorColumn, rightRowIndicatorColumn) {
        var leftBarcodeMetadata;
        if (leftRowIndicatorColumn == null ||
            (leftBarcodeMetadata = leftRowIndicatorColumn.getBarcodeMetadata()) == null) {
            return rightRowIndicatorColumn == null ? null : rightRowIndicatorColumn.getBarcodeMetadata();
        }
        var rightBarcodeMetadata;
        if (rightRowIndicatorColumn == null ||
            (rightBarcodeMetadata = rightRowIndicatorColumn.getBarcodeMetadata()) == null) {
            return leftBarcodeMetadata;
        }
        if (leftBarcodeMetadata.getColumnCount() !== rightBarcodeMetadata.getColumnCount() &&
            leftBarcodeMetadata.getErrorCorrectionLevel() !== rightBarcodeMetadata.getErrorCorrectionLevel() &&
            leftBarcodeMetadata.getRowCount() !== rightBarcodeMetadata.getRowCount()) {
            return null;
        }
        return leftBarcodeMetadata;
    };
    PDF417ScanningDecoder.getRowIndicatorColumn = function (image, boundingBox, startPoint, leftToRight, minCodewordWidth, maxCodewordWidth) {
        var rowIndicatorColumn = new DetectionResultRowIndicatorColumn_1.default(boundingBox, leftToRight);
        for (var i /*int*/ = 0; i < 2; i++) {
            var increment = i === 0 ? 1 : -1;
            var startColumn = Math.trunc(Math.trunc(startPoint.getX()));
            for (var imageRow /*int*/ = Math.trunc(Math.trunc(startPoint.getY())); imageRow <= boundingBox.getMaxY() &&
                imageRow >= boundingBox.getMinY(); imageRow += increment) {
                var codeword = PDF417ScanningDecoder.detectCodeword(image, 0, image.getWidth(), leftToRight, startColumn, imageRow, minCodewordWidth, maxCodewordWidth);
                if (codeword != null) {
                    rowIndicatorColumn.setCodeword(imageRow, codeword);
                    if (leftToRight) {
                        startColumn = codeword.getStartX();
                    }
                    else {
                        startColumn = codeword.getEndX();
                    }
                }
            }
        }
        return rowIndicatorColumn;
    };
    /**
     *
     * @param detectionResult
     * @param BarcodeValue
     * @param param2
     * @param param3
     * @param barcodeMatrix
     *
     * @throws NotFoundException
     */
    PDF417ScanningDecoder.adjustCodewordCount = function (detectionResult, barcodeMatrix) {
        var barcodeMatrix01 = barcodeMatrix[0][1];
        var numberOfCodewords = barcodeMatrix01.getValue();
        var calculatedNumberOfCodewords = detectionResult.getBarcodeColumnCount() *
            detectionResult.getBarcodeRowCount() -
            PDF417ScanningDecoder.getNumberOfECCodeWords(detectionResult.getBarcodeECLevel());
        if (numberOfCodewords.length === 0) {
            if (calculatedNumberOfCodewords < 1 || calculatedNumberOfCodewords > PDF417Common_1.default.MAX_CODEWORDS_IN_BARCODE) {
                throw NotFoundException_1.default.getNotFoundInstance();
            }
            barcodeMatrix01.setValue(calculatedNumberOfCodewords);
        }
        else if (numberOfCodewords[0] !== calculatedNumberOfCodewords) {
            // The calculated one is more reliable as it is derived from the row indicator columns
            barcodeMatrix01.setValue(calculatedNumberOfCodewords);
        }
    };
    /**
     *
     * @param detectionResult
     *
     * @throws FormatException
     * @throws ChecksumException
     * @throws NotFoundException
     */
    PDF417ScanningDecoder.createDecoderResult = function (detectionResult) {
        var barcodeMatrix = PDF417ScanningDecoder.createBarcodeMatrix(detectionResult);
        PDF417ScanningDecoder.adjustCodewordCount(detectionResult, barcodeMatrix);
        var erasures /*Collection<Integer>*/ = new Array();
        var codewords = new Int32Array(detectionResult.getBarcodeRowCount() * detectionResult.getBarcodeColumnCount());
        var ambiguousIndexValuesList = /*List<int[]>*/ [];
        var ambiguousIndexesList = /*Collection<Integer>*/ new Array();
        for (var row /*int*/ = 0; row < detectionResult.getBarcodeRowCount(); row++) {
            for (var column /*int*/ = 0; column < detectionResult.getBarcodeColumnCount(); column++) {
                var values = barcodeMatrix[row][column + 1].getValue();
                var codewordIndex = row * detectionResult.getBarcodeColumnCount() + column;
                if (values.length === 0) {
                    erasures.push(codewordIndex);
                }
                else if (values.length === 1) {
                    codewords[codewordIndex] = values[0];
                }
                else {
                    ambiguousIndexesList.push(codewordIndex);
                    ambiguousIndexValuesList.push(values);
                }
            }
        }
        var ambiguousIndexValues = new Array(ambiguousIndexValuesList.length);
        for (var i /*int*/ = 0; i < ambiguousIndexValues.length; i++) {
            ambiguousIndexValues[i] = ambiguousIndexValuesList[i];
        }
        return PDF417ScanningDecoder.createDecoderResultFromAmbiguousValues(detectionResult.getBarcodeECLevel(), codewords, PDF417Common_1.default.toIntArray(erasures), PDF417Common_1.default.toIntArray(ambiguousIndexesList), ambiguousIndexValues);
    };
    /**
     * This method deals with the fact, that the decoding process doesn't always yield a single most likely value. The
     * current error correction implementation doesn't deal with erasures very well, so it's better to provide a value
     * for these ambiguous codewords instead of treating it as an erasure. The problem is that we don't know which of
     * the ambiguous values to choose. We try decode using the first value, and if that fails, we use another of the
     * ambiguous values and try to decode again. This usually only happens on very hard to read and decode barcodes,
     * so decoding the normal barcodes is not affected by this.
     *
     * @param erasureArray contains the indexes of erasures
     * @param ambiguousIndexes array with the indexes that have more than one most likely value
     * @param ambiguousIndexValues two dimensional array that contains the ambiguous values. The first dimension must
     * be the same length as the ambiguousIndexes array
     *
     * @throws FormatException
     * @throws ChecksumException
     */
    PDF417ScanningDecoder.createDecoderResultFromAmbiguousValues = function (ecLevel, codewords, erasureArray, ambiguousIndexes, ambiguousIndexValues) {
        var ambiguousIndexCount = new Int32Array(ambiguousIndexes.length);
        var tries = 100;
        while (tries-- > 0) {
            for (var i /*int*/ = 0; i < ambiguousIndexCount.length; i++) {
                codewords[ambiguousIndexes[i]] = ambiguousIndexValues[i][ambiguousIndexCount[i]];
            }
            try {
                return PDF417ScanningDecoder.decodeCodewords(codewords, ecLevel, erasureArray);
            }
            catch (err) {
                var ignored = err instanceof ChecksumException_1.default;
                if (!ignored) {
                    throw err;
                }
            }
            if (ambiguousIndexCount.length === 0) {
                throw ChecksumException_1.default.getChecksumInstance();
            }
            for (var i /*int*/ = 0; i < ambiguousIndexCount.length; i++) {
                if (ambiguousIndexCount[i] < ambiguousIndexValues[i].length - 1) {
                    ambiguousIndexCount[i]++;
                    break;
                }
                else {
                    ambiguousIndexCount[i] = 0;
                    if (i === ambiguousIndexCount.length - 1) {
                        throw ChecksumException_1.default.getChecksumInstance();
                    }
                }
            }
        }
        throw ChecksumException_1.default.getChecksumInstance();
    };
    PDF417ScanningDecoder.createBarcodeMatrix = function (detectionResult) {
        var e_3, _a, e_4, _b;
        // let barcodeMatrix: BarcodeValue[][] =
        // new BarcodeValue[detectionResult.getBarcodeRowCount()][detectionResult.getBarcodeColumnCount() + 2];
        var barcodeMatrix = Array.from({ length: detectionResult.getBarcodeRowCount() }, function () { return new Array(detectionResult.getBarcodeColumnCount() + 2); });
        for (var row /*int*/ = 0; row < barcodeMatrix.length; row++) {
            for (var column_1 /*int*/ = 0; column_1 < barcodeMatrix[row].length; column_1++) {
                barcodeMatrix[row][column_1] = new BarcodeValue_1.default();
            }
        }
        var column = 0;
        try {
            for (var _c = __values(detectionResult.getDetectionResultColumns()), _d = _c.next(); !_d.done; _d = _c.next()) {
                var detectionResultColumn = _d.value /*DetectionResultColumn*/;
                if (detectionResultColumn != null) {
                    try {
                        for (var _e = (e_4 = void 0, __values(detectionResultColumn.getCodewords())), _f = _e.next(); !_f.done; _f = _e.next()) {
                            var codeword = _f.value /*Codeword*/;
                            if (codeword != null) {
                                var rowNumber = codeword.getRowNumber();
                                if (rowNumber >= 0) {
                                    if (rowNumber >= barcodeMatrix.length) {
                                        // We have more rows than the barcode metadata allows for, ignore them.
                                        continue;
                                    }
                                    barcodeMatrix[rowNumber][column].setValue(codeword.getValue());
                                }
                            }
                        }
                    }
                    catch (e_4_1) { e_4 = { error: e_4_1 }; }
                    finally {
                        try {
                            if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
                        }
                        finally { if (e_4) throw e_4.error; }
                    }
                }
                column++;
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
            }
            finally { if (e_3) throw e_3.error; }
        }
        return barcodeMatrix;
    };
    PDF417ScanningDecoder.isValidBarcodeColumn = function (detectionResult, barcodeColumn) {
        return barcodeColumn >= 0 && barcodeColumn <= detectionResult.getBarcodeColumnCount() + 1;
    };
    PDF417ScanningDecoder.getStartColumn = function (detectionResult, barcodeColumn, imageRow, leftToRight) {
        var e_5, _a;
        var offset = leftToRight ? 1 : -1;
        var codeword = null;
        if (PDF417ScanningDecoder.isValidBarcodeColumn(detectionResult, barcodeColumn - offset)) {
            codeword = detectionResult.getDetectionResultColumn(barcodeColumn - offset).getCodeword(imageRow);
        }
        if (codeword != null) {
            return leftToRight ? codeword.getEndX() : codeword.getStartX();
        }
        codeword = detectionResult.getDetectionResultColumn(barcodeColumn).getCodewordNearby(imageRow);
        if (codeword != null) {
            return leftToRight ? codeword.getStartX() : codeword.getEndX();
        }
        if (PDF417ScanningDecoder.isValidBarcodeColumn(detectionResult, barcodeColumn - offset)) {
            codeword = detectionResult.getDetectionResultColumn(barcodeColumn - offset).getCodewordNearby(imageRow);
        }
        if (codeword != null) {
            return leftToRight ? codeword.getEndX() : codeword.getStartX();
        }
        var skippedColumns = 0;
        while (PDF417ScanningDecoder.isValidBarcodeColumn(detectionResult, barcodeColumn - offset)) {
            barcodeColumn -= offset;
            try {
                for (var _b = (e_5 = void 0, __values(detectionResult.getDetectionResultColumn(barcodeColumn).getCodewords())), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var previousRowCodeword = _c.value /*Codeword*/;
                    if (previousRowCodeword != null) {
                        return (leftToRight ? previousRowCodeword.getEndX() : previousRowCodeword.getStartX()) +
                            offset *
                                skippedColumns *
                                (previousRowCodeword.getEndX() - previousRowCodeword.getStartX());
                    }
                }
            }
            catch (e_5_1) { e_5 = { error: e_5_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_5) throw e_5.error; }
            }
            skippedColumns++;
        }
        return leftToRight ? detectionResult.getBoundingBox().getMinX() : detectionResult.getBoundingBox().getMaxX();
    };
    PDF417ScanningDecoder.detectCodeword = function (image, minColumn, maxColumn, leftToRight, startColumn, imageRow, minCodewordWidth, maxCodewordWidth) {
        startColumn = PDF417ScanningDecoder.adjustCodewordStartColumn(image, minColumn, maxColumn, leftToRight, startColumn, imageRow);
        // we usually know fairly exact now how long a codeword is. We should provide minimum and maximum expected length
        // and try to adjust the read pixels, e.g. remove single pixel errors or try to cut off exceeding pixels.
        // min and maxCodewordWidth should not be used as they are calculated for the whole barcode an can be inaccurate
        // for the current position
        var moduleBitCount = PDF417ScanningDecoder.getModuleBitCount(image, minColumn, maxColumn, leftToRight, startColumn, imageRow);
        if (moduleBitCount == null) {
            return null;
        }
        var endColumn;
        var codewordBitCount = MathUtils_1.default.sum(moduleBitCount);
        if (leftToRight) {
            endColumn = startColumn + codewordBitCount;
        }
        else {
            for (var i /*int*/ = 0; i < moduleBitCount.length / 2; i++) {
                var tmpCount = moduleBitCount[i];
                moduleBitCount[i] = moduleBitCount[moduleBitCount.length - 1 - i];
                moduleBitCount[moduleBitCount.length - 1 - i] = tmpCount;
            }
            endColumn = startColumn;
            startColumn = endColumn - codewordBitCount;
        }
        // TODO implement check for width and correction of black and white bars
        // use start (and maybe stop pattern) to determine if black bars are wider than white bars. If so, adjust.
        // should probably done only for codewords with a lot more than 17 bits.
        // The following fixes 10-1.png, which has wide black bars and small white bars
        //    for (let i /*int*/ = 0; i < moduleBitCount.length; i++) {
        //      if (i % 2 === 0) {
        //        moduleBitCount[i]--;
        //      } else {
        //        moduleBitCount[i]++;
        //      }
        //    }
        // We could also use the width of surrounding codewords for more accurate results, but this seems
        // sufficient for now
        if (!PDF417ScanningDecoder.checkCodewordSkew(codewordBitCount, minCodewordWidth, maxCodewordWidth)) {
            // We could try to use the startX and endX position of the codeword in the same column in the previous row,
            // create the bit count from it and normalize it to 8. This would help with single pixel errors.
            return null;
        }
        var decodedValue = PDF417CodewordDecoder_1.default.getDecodedValue(moduleBitCount);
        var codeword = PDF417Common_1.default.getCodeword(decodedValue);
        if (codeword === -1) {
            return null;
        }
        return new Codeword_1.default(startColumn, endColumn, PDF417ScanningDecoder.getCodewordBucketNumber(decodedValue), codeword);
    };
    PDF417ScanningDecoder.getModuleBitCount = function (image, minColumn, maxColumn, leftToRight, startColumn, imageRow) {
        var imageColumn = startColumn;
        var moduleBitCount = new Int32Array(8);
        var moduleNumber = 0;
        var increment = leftToRight ? 1 : -1;
        var previousPixelValue = leftToRight;
        while ((leftToRight ? imageColumn < maxColumn : imageColumn >= minColumn) &&
            moduleNumber < moduleBitCount.length) {
            if (image.get(imageColumn, imageRow) === previousPixelValue) {
                moduleBitCount[moduleNumber]++;
                imageColumn += increment;
            }
            else {
                moduleNumber++;
                previousPixelValue = !previousPixelValue;
            }
        }
        if (moduleNumber === moduleBitCount.length ||
            ((imageColumn === (leftToRight ? maxColumn : minColumn)) &&
                moduleNumber === moduleBitCount.length - 1)) {
            return moduleBitCount;
        }
        return null;
    };
    PDF417ScanningDecoder.getNumberOfECCodeWords = function (barcodeECLevel) {
        return 2 << barcodeECLevel;
    };
    PDF417ScanningDecoder.adjustCodewordStartColumn = function (image, minColumn, maxColumn, leftToRight, codewordStartColumn, imageRow) {
        var correctedStartColumn = codewordStartColumn;
        var increment = leftToRight ? -1 : 1;
        // there should be no black pixels before the start column. If there are, then we need to start earlier.
        for (var i /*int*/ = 0; i < 2; i++) {
            while ((leftToRight ? correctedStartColumn >= minColumn : correctedStartColumn < maxColumn) &&
                leftToRight === image.get(correctedStartColumn, imageRow)) {
                if (Math.abs(codewordStartColumn - correctedStartColumn) > PDF417ScanningDecoder.CODEWORD_SKEW_SIZE) {
                    return codewordStartColumn;
                }
                correctedStartColumn += increment;
            }
            increment = -increment;
            leftToRight = !leftToRight;
        }
        return correctedStartColumn;
    };
    PDF417ScanningDecoder.checkCodewordSkew = function (codewordSize, minCodewordWidth, maxCodewordWidth) {
        return minCodewordWidth - PDF417ScanningDecoder.CODEWORD_SKEW_SIZE <= codewordSize &&
            codewordSize <= maxCodewordWidth + PDF417ScanningDecoder.CODEWORD_SKEW_SIZE;
    };
    /**
     * @throws FormatException,
     * @throws ChecksumException
     */
    PDF417ScanningDecoder.decodeCodewords = function (codewords, ecLevel, erasures) {
        if (codewords.length === 0) {
            throw FormatException_1.default.getFormatInstance();
        }
        var numECCodewords = 1 << (ecLevel + 1);
        var correctedErrorsCount = PDF417ScanningDecoder.correctErrors(codewords, erasures, numECCodewords);
        PDF417ScanningDecoder.verifyCodewordCount(codewords, numECCodewords);
        // Decode the codewords
        var decoderResult = DecodedBitStreamParser_1.default.decode(codewords, '' + ecLevel);
        decoderResult.setErrorsCorrected(correctedErrorsCount);
        decoderResult.setErasures(erasures.length);
        return decoderResult;
    };
    /**
     * <p>Given data and error-correction codewords received, possibly corrupted by errors, attempts to
     * correct the errors in-place.</p>
     *
     * @param codewords   data and error correction codewords
     * @param erasures positions of any known erasures
     * @param numECCodewords number of error correction codewords that are available in codewords
     * @throws ChecksumException if error correction fails
     */
    PDF417ScanningDecoder.correctErrors = function (codewords, erasures, numECCodewords) {
        if (erasures != null &&
            erasures.length > numECCodewords / 2 + PDF417ScanningDecoder.MAX_ERRORS ||
            numECCodewords < 0 ||
            numECCodewords > PDF417ScanningDecoder.MAX_EC_CODEWORDS) {
            // Too many errors or EC Codewords is corrupted
            throw ChecksumException_1.default.getChecksumInstance();
        }
        return PDF417ScanningDecoder.errorCorrection.decode(codewords, numECCodewords, erasures);
    };
    /**
     * Verify that all is OK with the codeword array.
     * @throws FormatException
     */
    PDF417ScanningDecoder.verifyCodewordCount = function (codewords, numECCodewords) {
        if (codewords.length < 4) {
            // Codeword array size should be at least 4 allowing for
            // Count CW, At least one Data CW, Error Correction CW, Error Correction CW
            throw FormatException_1.default.getFormatInstance();
        }
        // The first codeword, the Symbol Length Descriptor, shall always encode the total number of data
        // codewords in the symbol, including the Symbol Length Descriptor itself, data codewords and pad
        // codewords, but excluding the number of error correction codewords.
        var numberOfCodewords = codewords[0];
        if (numberOfCodewords > codewords.length) {
            throw FormatException_1.default.getFormatInstance();
        }
        if (numberOfCodewords === 0) {
            // Reset to the length of the array - 8 (Allow for at least level 3 Error Correction (8 Error Codewords)
            if (numECCodewords < codewords.length) {
                codewords[0] = codewords.length - numECCodewords;
            }
            else {
                throw FormatException_1.default.getFormatInstance();
            }
        }
    };
    PDF417ScanningDecoder.getBitCountForCodeword = function (codeword) {
        var result = new Int32Array(8);
        var previousValue = 0;
        var i = result.length - 1;
        while (true) {
            if ((codeword & 0x1) !== previousValue) {
                previousValue = codeword & 0x1;
                i--;
                if (i < 0) {
                    break;
                }
            }
            result[i]++;
            codeword >>= 1;
        }
        return result;
    };
    PDF417ScanningDecoder.getCodewordBucketNumber = function (codeword) {
        if (codeword instanceof Int32Array) {
            return this.getCodewordBucketNumber_Int32Array(codeword);
        }
        return this.getCodewordBucketNumber_number(codeword);
    };
    PDF417ScanningDecoder.getCodewordBucketNumber_number = function (codeword) {
        return PDF417ScanningDecoder.getCodewordBucketNumber(PDF417ScanningDecoder.getBitCountForCodeword(codeword));
    };
    PDF417ScanningDecoder.getCodewordBucketNumber_Int32Array = function (moduleBitCount) {
        return (moduleBitCount[0] - moduleBitCount[2] + moduleBitCount[4] - moduleBitCount[6] + 9) % 9;
    };
    PDF417ScanningDecoder.toString = function (barcodeMatrix) {
        var formatter = new Formatter_1.default();
        // try (let formatter = new Formatter()) {
        for (var row /*int*/ = 0; row < barcodeMatrix.length; row++) {
            formatter.format('Row %2d: ', row);
            for (var column /*int*/ = 0; column < barcodeMatrix[row].length; column++) {
                var barcodeValue = barcodeMatrix[row][column];
                if (barcodeValue.getValue().length === 0) {
                    formatter.format('        ', null);
                }
                else {
                    formatter.format('%4d(%2d)', barcodeValue.getValue()[0], barcodeValue.getConfidence(barcodeValue.getValue()[0]));
                }
            }
            formatter.format('%n');
        }
        return formatter.toString();
        // }
    };
    /*final*/ PDF417ScanningDecoder.CODEWORD_SKEW_SIZE = 2;
    /*final*/ PDF417ScanningDecoder.MAX_ERRORS = 3;
    /*final*/ PDF417ScanningDecoder.MAX_EC_CODEWORDS = 512;
    /*final*/ PDF417ScanningDecoder.errorCorrection = new ErrorCorrection_1.default();
    return PDF417ScanningDecoder;
}());
exports.default = PDF417ScanningDecoder;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\PDF417ScanningDecoder.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\ec\\ErrorCorrection.js", {"../../../ChecksumException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\ChecksumException.js","./ModulusGF":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\ec\\ModulusGF.js","./ModulusPoly":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\ec\\ModulusPoly.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cpdf417%5Cdecoder%5Cec%5CErrorCorrection.js
      return function (require, module, exports) {
"use strict";
/*
* Copyright 2012 ZXing authors
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
// package com.google.zxing.pdf417.decoder.ec;
// import com.google.zxing.ChecksumException;
var ChecksumException_1 = require("../../../ChecksumException");
var ModulusPoly_1 = require("./ModulusPoly");
var ModulusGF_1 = require("./ModulusGF");
/**
 * <p>PDF417 error correction implementation.</p>
 *
 * <p>This <a href="http://en.wikipedia.org/wiki/Reed%E2%80%93Solomon_error_correction#Example">example</a>
 * is quite useful in understanding the algorithm.</p>
 *
 * @author Sean Owen
 * @see com.google.zxing.common.reedsolomon.ReedSolomonDecoder
 */
var ErrorCorrection = /** @class */ (function () {
    function ErrorCorrection() {
        this.field = ModulusGF_1.default.PDF417_GF;
    }
    /**
     * @param received received codewords
     * @param numECCodewords number of those codewords used for EC
     * @param erasures location of erasures
     * @return number of errors
     * @throws ChecksumException if errors cannot be corrected, maybe because of too many errors
     */
    ErrorCorrection.prototype.decode = function (received, numECCodewords, erasures) {
        var e_1, _a;
        var poly = new ModulusPoly_1.default(this.field, received);
        var S = new Int32Array(numECCodewords);
        var error = false;
        for (var i /*int*/ = numECCodewords; i > 0; i--) {
            var evaluation = poly.evaluateAt(this.field.exp(i));
            S[numECCodewords - i] = evaluation;
            if (evaluation !== 0) {
                error = true;
            }
        }
        if (!error) {
            return 0;
        }
        var knownErrors = this.field.getOne();
        if (erasures != null) {
            try {
                for (var erasures_1 = __values(erasures), erasures_1_1 = erasures_1.next(); !erasures_1_1.done; erasures_1_1 = erasures_1.next()) {
                    var erasure = erasures_1_1.value;
                    var b = this.field.exp(received.length - 1 - erasure);
                    // Add (1 - bx) term:
                    var term = new ModulusPoly_1.default(this.field, new Int32Array([this.field.subtract(0, b), 1]));
                    knownErrors = knownErrors.multiply(term);
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (erasures_1_1 && !erasures_1_1.done && (_a = erasures_1.return)) _a.call(erasures_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
        }
        var syndrome = new ModulusPoly_1.default(this.field, S);
        // syndrome = syndrome.multiply(knownErrors);
        var sigmaOmega = this.runEuclideanAlgorithm(this.field.buildMonomial(numECCodewords, 1), syndrome, numECCodewords);
        var sigma = sigmaOmega[0];
        var omega = sigmaOmega[1];
        // sigma = sigma.multiply(knownErrors);
        var errorLocations = this.findErrorLocations(sigma);
        var errorMagnitudes = this.findErrorMagnitudes(omega, sigma, errorLocations);
        for (var i /*int*/ = 0; i < errorLocations.length; i++) {
            var position = received.length - 1 - this.field.log(errorLocations[i]);
            if (position < 0) {
                throw ChecksumException_1.default.getChecksumInstance();
            }
            received[position] = this.field.subtract(received[position], errorMagnitudes[i]);
        }
        return errorLocations.length;
    };
    /**
     *
     * @param ModulusPoly
     * @param a
     * @param ModulusPoly
     * @param b
     * @param int
     * @param R
     * @throws ChecksumException
     */
    ErrorCorrection.prototype.runEuclideanAlgorithm = function (a, b, R) {
        // Assume a's degree is >= b's
        if (a.getDegree() < b.getDegree()) {
            var temp = a;
            a = b;
            b = temp;
        }
        var rLast = a;
        var r = b;
        var tLast = this.field.getZero();
        var t = this.field.getOne();
        // Run Euclidean algorithm until r's degree is less than R/2
        while (r.getDegree() >= Math.round(R / 2)) {
            var rLastLast = rLast;
            var tLastLast = tLast;
            rLast = r;
            tLast = t;
            // Divide rLastLast by rLast, with quotient in q and remainder in r
            if (rLast.isZero()) {
                // Oops, Euclidean algorithm already terminated?
                throw ChecksumException_1.default.getChecksumInstance();
            }
            r = rLastLast;
            var q = this.field.getZero();
            var denominatorLeadingTerm = rLast.getCoefficient(rLast.getDegree());
            var dltInverse = this.field.inverse(denominatorLeadingTerm);
            while (r.getDegree() >= rLast.getDegree() && !r.isZero()) {
                var degreeDiff = r.getDegree() - rLast.getDegree();
                var scale = this.field.multiply(r.getCoefficient(r.getDegree()), dltInverse);
                q = q.add(this.field.buildMonomial(degreeDiff, scale));
                r = r.subtract(rLast.multiplyByMonomial(degreeDiff, scale));
            }
            t = q.multiply(tLast).subtract(tLastLast).negative();
        }
        var sigmaTildeAtZero = t.getCoefficient(0);
        if (sigmaTildeAtZero === 0) {
            throw ChecksumException_1.default.getChecksumInstance();
        }
        var inverse = this.field.inverse(sigmaTildeAtZero);
        var sigma = t.multiply(inverse);
        var omega = r.multiply(inverse);
        return [sigma, omega];
    };
    /**
     *
     * @param errorLocator
     * @throws ChecksumException
     */
    ErrorCorrection.prototype.findErrorLocations = function (errorLocator) {
        // This is a direct application of Chien's search
        var numErrors = errorLocator.getDegree();
        var result = new Int32Array(numErrors);
        var e = 0;
        for (var i /*int*/ = 1; i < this.field.getSize() && e < numErrors; i++) {
            if (errorLocator.evaluateAt(i) === 0) {
                result[e] = this.field.inverse(i);
                e++;
            }
        }
        if (e !== numErrors) {
            throw ChecksumException_1.default.getChecksumInstance();
        }
        return result;
    };
    ErrorCorrection.prototype.findErrorMagnitudes = function (errorEvaluator, errorLocator, errorLocations) {
        var errorLocatorDegree = errorLocator.getDegree();
        var formalDerivativeCoefficients = new Int32Array(errorLocatorDegree);
        for (var i /*int*/ = 1; i <= errorLocatorDegree; i++) {
            formalDerivativeCoefficients[errorLocatorDegree - i] =
                this.field.multiply(i, errorLocator.getCoefficient(i));
        }
        var formalDerivative = new ModulusPoly_1.default(this.field, formalDerivativeCoefficients);
        // This is directly applying Forney's Formula
        var s = errorLocations.length;
        var result = new Int32Array(s);
        for (var i /*int*/ = 0; i < s; i++) {
            var xiInverse = this.field.inverse(errorLocations[i]);
            var numerator = this.field.subtract(0, errorEvaluator.evaluateAt(xiInverse));
            var denominator = this.field.inverse(formalDerivative.evaluateAt(xiInverse));
            result[i] = this.field.multiply(numerator, denominator);
        }
        return result;
    };
    return ErrorCorrection;
}());
exports.default = ErrorCorrection;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\ec\\ErrorCorrection.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\ec\\ModulusBase.js", {"../../../ArithmeticException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\ArithmeticException.js","../../../IllegalArgumentException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\IllegalArgumentException.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cpdf417%5Cdecoder%5Cec%5CModulusBase.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var IllegalArgumentException_1 = require("../../../IllegalArgumentException");
var ArithmeticException_1 = require("../../../ArithmeticException");
var ModulusBase = /** @class */ (function () {
    function ModulusBase() {
    }
    ModulusBase.prototype.add = function (a, b) {
        return (a + b) % this.modulus;
    };
    ModulusBase.prototype.subtract = function (a, b) {
        return (this.modulus + a - b) % this.modulus;
    };
    ModulusBase.prototype.exp = function (a) {
        return this.expTable[a];
    };
    ModulusBase.prototype.log = function (a) {
        if (a === 0) {
            throw new IllegalArgumentException_1.default();
        }
        return this.logTable[a];
    };
    ModulusBase.prototype.inverse = function (a) {
        if (a === 0) {
            throw new ArithmeticException_1.default();
        }
        return this.expTable[this.modulus - this.logTable[a] - 1];
    };
    ModulusBase.prototype.multiply = function (a, b) {
        if (a === 0 || b === 0) {
            return 0;
        }
        return this.expTable[(this.logTable[a] + this.logTable[b]) % (this.modulus - 1)];
    };
    ModulusBase.prototype.getSize = function () {
        return this.modulus;
    };
    ModulusBase.prototype.equals = function (o) {
        return o === this;
    };
    return ModulusBase;
}());
exports.default = ModulusBase;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\ec\\ModulusBase.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\ec\\ModulusGF.js", {"../../../IllegalArgumentException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\IllegalArgumentException.js","../../PDF417Common":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\PDF417Common.js","./ModulusBase":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\ec\\ModulusBase.js","./ModulusPoly":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\ec\\ModulusPoly.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cpdf417%5Cdecoder%5Cec%5CModulusGF.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2012 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
// package com.google.zxing.pdf417.decoder.ec;
// import com.google.zxing.pdf417.PDF417Common;
var PDF417Common_1 = require("../../PDF417Common");
var ModulusPoly_1 = require("./ModulusPoly");
var IllegalArgumentException_1 = require("../../../IllegalArgumentException");
var ModulusBase_1 = require("./ModulusBase");
/**
 * <p>A field based on powers of a generator integer, modulo some modulus.</p>
 *
 * @author Sean Owen
 * @see com.google.zxing.common.reedsolomon.GenericGF
 */
var ModulusGF = /** @class */ (function (_super) {
    __extends(ModulusGF, _super);
    // private /*final*/ modulus: /*int*/ number;
    function ModulusGF(modulus, generator) {
        var _this = _super.call(this) || this;
        _this.modulus = modulus;
        _this.expTable = new Int32Array(modulus);
        _this.logTable = new Int32Array(modulus);
        var x = /*int*/ 1;
        for (var i /*int*/ = 0; i < modulus; i++) {
            _this.expTable[i] = x;
            x = (x * generator) % modulus;
        }
        for (var i /*int*/ = 0; i < modulus - 1; i++) {
            _this.logTable[_this.expTable[i]] = i;
        }
        // logTable[0] == 0 but this should never be used
        _this.zero = new ModulusPoly_1.default(_this, new Int32Array([0]));
        _this.one = new ModulusPoly_1.default(_this, new Int32Array([1]));
        return _this;
    }
    ModulusGF.prototype.getZero = function () {
        return this.zero;
    };
    ModulusGF.prototype.getOne = function () {
        return this.one;
    };
    ModulusGF.prototype.buildMonomial = function (degree, coefficient) {
        if (degree < 0) {
            throw new IllegalArgumentException_1.default();
        }
        if (coefficient === 0) {
            return this.zero;
        }
        var coefficients = new Int32Array(degree + 1);
        coefficients[0] = coefficient;
        return new ModulusPoly_1.default(this, coefficients);
    };
    ModulusGF.PDF417_GF = new ModulusGF(PDF417Common_1.default.NUMBER_OF_CODEWORDS, 3);
    return ModulusGF;
}(ModulusBase_1.default));
exports.default = ModulusGF;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\ec\\ModulusGF.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\ec\\ModulusPoly.js", {"../../../IllegalArgumentException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\IllegalArgumentException.js","../../../util/StringBuilder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\StringBuilder.js","../../../util/System":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\System.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cpdf417%5Cdecoder%5Cec%5CModulusPoly.js
      return function (require, module, exports) {
"use strict";
/*
* Copyright 2012 ZXing authors
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
// package com.google.zxing.pdf417.decoder.ec;
var IllegalArgumentException_1 = require("../../../IllegalArgumentException");
var System_1 = require("../../../util/System");
var StringBuilder_1 = require("../../../util/StringBuilder");
/**
 * @author Sean Owen
 * @see com.google.zxing.common.reedsolomon.GenericGFPoly
 */
var ModulusPoly = /** @class */ (function () {
    function ModulusPoly(field, coefficients) {
        if (coefficients.length === 0) {
            throw new IllegalArgumentException_1.default();
        }
        this.field = field;
        var coefficientsLength = /*int*/ coefficients.length;
        if (coefficientsLength > 1 && coefficients[0] === 0) {
            // Leading term must be non-zero for anything except the constant polynomial "0"
            var firstNonZero = /*int*/ 1;
            while (firstNonZero < coefficientsLength && coefficients[firstNonZero] === 0) {
                firstNonZero++;
            }
            if (firstNonZero === coefficientsLength) {
                this.coefficients = new Int32Array([0]);
            }
            else {
                this.coefficients = new Int32Array(coefficientsLength - firstNonZero);
                System_1.default.arraycopy(coefficients, firstNonZero, this.coefficients, 0, this.coefficients.length);
            }
        }
        else {
            this.coefficients = coefficients;
        }
    }
    ModulusPoly.prototype.getCoefficients = function () {
        return this.coefficients;
    };
    /**
     * @return degree of this polynomial
     */
    ModulusPoly.prototype.getDegree = function () {
        return this.coefficients.length - 1;
    };
    /**
     * @return true iff this polynomial is the monomial "0"
     */
    ModulusPoly.prototype.isZero = function () {
        return this.coefficients[0] === 0;
    };
    /**
     * @return coefficient of x^degree term in this polynomial
     */
    ModulusPoly.prototype.getCoefficient = function (degree) {
        return this.coefficients[this.coefficients.length - 1 - degree];
    };
    /**
     * @return evaluation of this polynomial at a given point
     */
    ModulusPoly.prototype.evaluateAt = function (a) {
        var e_1, _a;
        if (a === 0) {
            // Just return the x^0 coefficient
            return this.getCoefficient(0);
        }
        if (a === 1) {
            // Just the sum of the coefficients
            var sum = /*int*/ 0;
            try {
                for (var _b = __values(this.coefficients), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var coefficient = _c.value /*int*/;
                    sum = this.field.add(sum, coefficient);
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_1) throw e_1.error; }
            }
            return sum;
        }
        var result = /*int*/ this.coefficients[0];
        var size = /*int*/ this.coefficients.length;
        for (var i /*int*/ = 1; i < size; i++) {
            result = this.field.add(this.field.multiply(a, result), this.coefficients[i]);
        }
        return result;
    };
    ModulusPoly.prototype.add = function (other) {
        if (!this.field.equals(other.field)) {
            throw new IllegalArgumentException_1.default('ModulusPolys do not have same ModulusGF field');
        }
        if (this.isZero()) {
            return other;
        }
        if (other.isZero()) {
            return this;
        }
        var smallerCoefficients = this.coefficients;
        var largerCoefficients = other.coefficients;
        if (smallerCoefficients.length > largerCoefficients.length) {
            var temp = smallerCoefficients;
            smallerCoefficients = largerCoefficients;
            largerCoefficients = temp;
        }
        var sumDiff = new Int32Array(largerCoefficients.length);
        var lengthDiff = /*int*/ largerCoefficients.length - smallerCoefficients.length;
        // Copy high-order terms only found in higher-degree polynomial's coefficients
        System_1.default.arraycopy(largerCoefficients, 0, sumDiff, 0, lengthDiff);
        for (var i /*int*/ = lengthDiff; i < largerCoefficients.length; i++) {
            sumDiff[i] = this.field.add(smallerCoefficients[i - lengthDiff], largerCoefficients[i]);
        }
        return new ModulusPoly(this.field, sumDiff);
    };
    ModulusPoly.prototype.subtract = function (other) {
        if (!this.field.equals(other.field)) {
            throw new IllegalArgumentException_1.default('ModulusPolys do not have same ModulusGF field');
        }
        if (other.isZero()) {
            return this;
        }
        return this.add(other.negative());
    };
    ModulusPoly.prototype.multiply = function (other) {
        if (other instanceof ModulusPoly) {
            return this.multiplyOther(other);
        }
        return this.multiplyScalar(other);
    };
    ModulusPoly.prototype.multiplyOther = function (other) {
        if (!this.field.equals(other.field)) {
            throw new IllegalArgumentException_1.default('ModulusPolys do not have same ModulusGF field');
        }
        if (this.isZero() || other.isZero()) {
            // return this.field.getZero();
            return new ModulusPoly(this.field, new Int32Array([0]));
        }
        var aCoefficients = this.coefficients;
        var aLength = /*int*/ aCoefficients.length;
        var bCoefficients = other.coefficients;
        var bLength = /*int*/ bCoefficients.length;
        var product = new Int32Array(aLength + bLength - 1);
        for (var i /*int*/ = 0; i < aLength; i++) {
            var aCoeff = /*int*/ aCoefficients[i];
            for (var j /*int*/ = 0; j < bLength; j++) {
                product[i + j] = this.field.add(product[i + j], this.field.multiply(aCoeff, bCoefficients[j]));
            }
        }
        return new ModulusPoly(this.field, product);
    };
    ModulusPoly.prototype.negative = function () {
        var size = /*int*/ this.coefficients.length;
        var negativeCoefficients = new Int32Array(size);
        for (var i /*int*/ = 0; i < size; i++) {
            negativeCoefficients[i] = this.field.subtract(0, this.coefficients[i]);
        }
        return new ModulusPoly(this.field, negativeCoefficients);
    };
    ModulusPoly.prototype.multiplyScalar = function (scalar) {
        if (scalar === 0) {
            return new ModulusPoly(this.field, new Int32Array([0]));
        }
        if (scalar === 1) {
            return this;
        }
        var size = /*int*/ this.coefficients.length;
        var product = new Int32Array(size);
        for (var i /*int*/ = 0; i < size; i++) {
            product[i] = this.field.multiply(this.coefficients[i], scalar);
        }
        return new ModulusPoly(this.field, product);
    };
    ModulusPoly.prototype.multiplyByMonomial = function (degree, coefficient) {
        if (degree < 0) {
            throw new IllegalArgumentException_1.default();
        }
        if (coefficient === 0) {
            return new ModulusPoly(this.field, new Int32Array([0]));
        }
        var size = /*int*/ this.coefficients.length;
        var product = new Int32Array(size + degree);
        for (var i /*int*/ = 0; i < size; i++) {
            product[i] = this.field.multiply(this.coefficients[i], coefficient);
        }
        return new ModulusPoly(this.field, product);
    };
    /*
    ModulusPoly[] divide(other: ModulusPoly) {
      if (!field.equals(other.field)) {
        throw new IllegalArgumentException("ModulusPolys do not have same ModulusGF field");
      }
      if (other.isZero()) {
        throw new IllegalArgumentException("Divide by 0");
      }
  
      let quotient: ModulusPoly = field.getZero();
      let remainder: ModulusPoly = this;
  
      let denominatorLeadingTerm: /*int/ number = other.getCoefficient(other.getDegree());
      let inverseDenominatorLeadingTerm: /*int/ number = field.inverse(denominatorLeadingTerm);
  
      while (remainder.getDegree() >= other.getDegree() && !remainder.isZero()) {
        let degreeDifference: /*int/ number = remainder.getDegree() - other.getDegree();
        let scale: /*int/ number = field.multiply(remainder.getCoefficient(remainder.getDegree()), inverseDenominatorLeadingTerm);
        let term: ModulusPoly = other.multiplyByMonomial(degreeDifference, scale);
        let iterationQuotient: ModulusPoly = field.buildMonomial(degreeDifference, scale);
        quotient = quotient.add(iterationQuotient);
        remainder = remainder.subtract(term);
      }
  
      return new ModulusPoly[] { quotient, remainder };
    }
    */
    // @Override
    ModulusPoly.prototype.toString = function () {
        var result = new StringBuilder_1.default( /*8 * this.getDegree()*/); // dynamic string size in JS
        for (var degree /*int*/ = this.getDegree(); degree >= 0; degree--) {
            var coefficient = /*int*/ this.getCoefficient(degree);
            if (coefficient !== 0) {
                if (coefficient < 0) {
                    result.append(' - ');
                    coefficient = -coefficient;
                }
                else {
                    if (result.length() > 0) {
                        result.append(' + ');
                    }
                }
                if (degree === 0 || coefficient !== 1) {
                    result.append(coefficient);
                }
                if (degree !== 0) {
                    if (degree === 1) {
                        result.append('x');
                    }
                    else {
                        result.append('x^');
                        result.append(degree);
                    }
                }
            }
        }
        return result.toString();
    };
    return ModulusPoly;
}());
exports.default = ModulusPoly;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\pdf417\\decoder\\ec\\ModulusPoly.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\detector\\Detector.js", {"../../ResultPoint":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\ResultPoint.js","../../util/Arrays":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\Arrays.js","../../util/System":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\System.js","./PDF417DetectorResult":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\detector\\PDF417DetectorResult.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cpdf417%5Cdetector%5CDetector.js
      return function (require, module, exports) {
"use strict";
/*
* Copyright 2009 ZXing authors
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
// import com.google.zxing.NotFoundException;
// import com.google.zxing.ResultPoint;
var ResultPoint_1 = require("../../ResultPoint");
var System_1 = require("../../util/System");
var Arrays_1 = require("../../util/Arrays");
var PDF417DetectorResult_1 = require("./PDF417DetectorResult");
// import java.util.ArrayList;
// import java.util.Arrays;
// import java.util.List;
// import java.util.Map;
/**
 * <p>Encapsulates logic that can detect a PDF417 Code in an image, even if the
 * PDF417 Code is rotated or skewed, or partially obscured.</p>
 *
 * @author SITA Lab (kevin.osullivan@sita.aero)
 * @author dswitkin@google.com (Daniel Switkin)
 * @author Guenther Grau
 */
var Detector = /** @class */ (function () {
    function Detector() {
    }
    /**
     * <p>Detects a PDF417 Code in an image. Only checks 0 and 180 degree rotations.</p>
     *
     * @param image barcode image to decode
     * @param hints optional hints to detector
     * @param multiple if true, then the image is searched for multiple codes. If false, then at most one code will
     * be found and returned
     * @return {@link PDF417DetectorResult} encapsulating results of detecting a PDF417 code
     * @throws NotFoundException if no PDF417 Code can be found
     */
    Detector.detectMultiple = function (image, hints, multiple) {
        // TODO detection improvement, tryHarder could try several different luminance thresholds/blackpoints or even
        // different binarizers
        // boolean tryHarder = hints != null && hints.containsKey(DecodeHintType.TRY_HARDER);
        var bitMatrix = image.getBlackMatrix();
        var barcodeCoordinates = Detector.detect(multiple, bitMatrix);
        if (!barcodeCoordinates.length) {
            bitMatrix = bitMatrix.clone();
            bitMatrix.rotate180();
            barcodeCoordinates = Detector.detect(multiple, bitMatrix);
        }
        return new PDF417DetectorResult_1.default(bitMatrix, barcodeCoordinates);
    };
    /**
     * Detects PDF417 codes in an image. Only checks 0 degree rotation
     * @param multiple if true, then the image is searched for multiple codes. If false, then at most one code will
     * be found and returned
     * @param bitMatrix bit matrix to detect barcodes in
     * @return List of ResultPoint arrays containing the coordinates of found barcodes
     */
    Detector.detect = function (multiple, bitMatrix) {
        var e_1, _a;
        var barcodeCoordinates = new Array();
        var row = 0;
        var column = 0;
        var foundBarcodeInRow = false;
        while (row < bitMatrix.getHeight()) {
            var vertices = Detector.findVertices(bitMatrix, row, column);
            if (vertices[0] == null && vertices[3] == null) {
                if (!foundBarcodeInRow) {
                    // we didn't find any barcode so that's the end of searching
                    break;
                }
                // we didn't find a barcode starting at the given column and row. Try again from the first column and slightly
                // below the lowest barcode we found so far.
                foundBarcodeInRow = false;
                column = 0;
                try {
                    for (var barcodeCoordinates_1 = (e_1 = void 0, __values(barcodeCoordinates)), barcodeCoordinates_1_1 = barcodeCoordinates_1.next(); !barcodeCoordinates_1_1.done; barcodeCoordinates_1_1 = barcodeCoordinates_1.next()) {
                        var barcodeCoordinate = barcodeCoordinates_1_1.value;
                        if (barcodeCoordinate[1] != null) {
                            row = Math.trunc(Math.max(row, barcodeCoordinate[1].getY()));
                        }
                        if (barcodeCoordinate[3] != null) {
                            row = Math.max(row, Math.trunc(barcodeCoordinate[3].getY()));
                        }
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (barcodeCoordinates_1_1 && !barcodeCoordinates_1_1.done && (_a = barcodeCoordinates_1.return)) _a.call(barcodeCoordinates_1);
                    }
                    finally { if (e_1) throw e_1.error; }
                }
                row += Detector.ROW_STEP;
                continue;
            }
            foundBarcodeInRow = true;
            barcodeCoordinates.push(vertices);
            if (!multiple) {
                break;
            }
            // if we didn't find a right row indicator column, then continue the search for the next barcode after the
            // start pattern of the barcode just found.
            if (vertices[2] != null) {
                column = Math.trunc(vertices[2].getX());
                row = Math.trunc(vertices[2].getY());
            }
            else {
                column = Math.trunc(vertices[4].getX());
                row = Math.trunc(vertices[4].getY());
            }
        }
        return barcodeCoordinates;
    };
    /**
     * Locate the vertices and the codewords area of a black blob using the Start
     * and Stop patterns as locators.
     *
     * @param matrix the scanned barcode image.
     * @return an array containing the vertices:
     *           vertices[0] x, y top left barcode
     *           vertices[1] x, y bottom left barcode
     *           vertices[2] x, y top right barcode
     *           vertices[3] x, y bottom right barcode
     *           vertices[4] x, y top left codeword area
     *           vertices[5] x, y bottom left codeword area
     *           vertices[6] x, y top right codeword area
     *           vertices[7] x, y bottom right codeword area
     */
    Detector.findVertices = function (matrix, startRow, startColumn) {
        var height = matrix.getHeight();
        var width = matrix.getWidth();
        // const result = new ResultPoint[8];
        var result = new Array(8);
        Detector.copyToResult(result, Detector.findRowsWithPattern(matrix, height, width, startRow, startColumn, Detector.START_PATTERN), Detector.INDEXES_START_PATTERN);
        if (result[4] != null) {
            startColumn = Math.trunc(result[4].getX());
            startRow = Math.trunc(result[4].getY());
        }
        Detector.copyToResult(result, Detector.findRowsWithPattern(matrix, height, width, startRow, startColumn, Detector.STOP_PATTERN), Detector.INDEXES_STOP_PATTERN);
        return result;
    };
    Detector.copyToResult = function (result, tmpResult, destinationIndexes) {
        for (var i = 0; i < destinationIndexes.length; i++) {
            result[destinationIndexes[i]] = tmpResult[i];
        }
    };
    Detector.findRowsWithPattern = function (matrix, height, width, startRow, startColumn, pattern) {
        // const result = new ResultPoint[4];
        var result = new Array(4);
        var found = false;
        var counters = new Int32Array(pattern.length);
        for (; startRow < height; startRow += Detector.ROW_STEP) {
            var loc = Detector.findGuardPattern(matrix, startColumn, startRow, width, false, pattern, counters);
            if (loc != null) {
                while (startRow > 0) {
                    var previousRowLoc = Detector.findGuardPattern(matrix, startColumn, --startRow, width, false, pattern, counters);
                    if (previousRowLoc != null) {
                        loc = previousRowLoc;
                    }
                    else {
                        startRow++;
                        break;
                    }
                }
                result[0] = new ResultPoint_1.default(loc[0], startRow);
                result[1] = new ResultPoint_1.default(loc[1], startRow);
                found = true;
                break;
            }
        }
        var stopRow = startRow + 1;
        // Last row of the current symbol that contains pattern
        if (found) {
            var skippedRowCount = 0;
            var previousRowLoc = Int32Array.from([Math.trunc(result[0].getX()), Math.trunc(result[1].getX())]);
            for (; stopRow < height; stopRow++) {
                var loc = Detector.findGuardPattern(matrix, previousRowLoc[0], stopRow, width, false, pattern, counters);
                // a found pattern is only considered to belong to the same barcode if the start and end positions
                // don't differ too much. Pattern drift should be not bigger than two for consecutive rows. With
                // a higher number of skipped rows drift could be larger. To keep it simple for now, we allow a slightly
                // larger drift and don't check for skipped rows.
                if (loc != null &&
                    Math.abs(previousRowLoc[0] - loc[0]) < Detector.MAX_PATTERN_DRIFT &&
                    Math.abs(previousRowLoc[1] - loc[1]) < Detector.MAX_PATTERN_DRIFT) {
                    previousRowLoc = loc;
                    skippedRowCount = 0;
                }
                else {
                    if (skippedRowCount > Detector.SKIPPED_ROW_COUNT_MAX) {
                        break;
                    }
                    else {
                        skippedRowCount++;
                    }
                }
            }
            stopRow -= skippedRowCount + 1;
            result[2] = new ResultPoint_1.default(previousRowLoc[0], stopRow);
            result[3] = new ResultPoint_1.default(previousRowLoc[1], stopRow);
        }
        if (stopRow - startRow < Detector.BARCODE_MIN_HEIGHT) {
            Arrays_1.default.fill(result, null);
        }
        return result;
    };
    /**
     * @param matrix row of black/white values to search
     * @param column x position to start search
     * @param row y position to start search
     * @param width the number of pixels to search on this row
     * @param pattern pattern of counts of number of black and white pixels that are
     *                 being searched for as a pattern
     * @param counters array of counters, as long as pattern, to re-use
     * @return start/end horizontal offset of guard pattern, as an array of two ints.
     */
    Detector.findGuardPattern = function (matrix, column, row, width, whiteFirst, pattern, counters) {
        Arrays_1.default.fillWithin(counters, 0, counters.length, 0);
        var patternStart = column;
        var pixelDrift = 0;
        // if there are black pixels left of the current pixel shift to the left, but only for MAX_PIXEL_DRIFT pixels
        while (matrix.get(patternStart, row) && patternStart > 0 && pixelDrift++ < Detector.MAX_PIXEL_DRIFT) {
            patternStart--;
        }
        var x = patternStart;
        var counterPosition = 0;
        var patternLength = pattern.length;
        for (var isWhite = whiteFirst; x < width; x++) {
            var pixel = matrix.get(x, row);
            if (pixel !== isWhite) {
                counters[counterPosition]++;
            }
            else {
                if (counterPosition === patternLength - 1) {
                    if (Detector.patternMatchVariance(counters, pattern, Detector.MAX_INDIVIDUAL_VARIANCE) < Detector.MAX_AVG_VARIANCE) {
                        return new Int32Array([patternStart, x]);
                    }
                    patternStart += counters[0] + counters[1];
                    System_1.default.arraycopy(counters, 2, counters, 0, counterPosition - 1);
                    counters[counterPosition - 1] = 0;
                    counters[counterPosition] = 0;
                    counterPosition--;
                }
                else {
                    counterPosition++;
                }
                counters[counterPosition] = 1;
                isWhite = !isWhite;
            }
        }
        if (counterPosition === patternLength - 1 &&
            Detector.patternMatchVariance(counters, pattern, Detector.MAX_INDIVIDUAL_VARIANCE) < Detector.MAX_AVG_VARIANCE) {
            return new Int32Array([patternStart, x - 1]);
        }
        return null;
    };
    /**
     * Determines how closely a set of observed counts of runs of black/white
     * values matches a given target pattern. This is reported as the ratio of
     * the total variance from the expected pattern proportions across all
     * pattern elements, to the length of the pattern.
     *
     * @param counters observed counters
     * @param pattern expected pattern
     * @param maxIndividualVariance The most any counter can differ before we give up
     * @return ratio of total variance between counters and pattern compared to total pattern size
     */
    Detector.patternMatchVariance = function (counters, pattern, maxIndividualVariance) {
        var numCounters = counters.length;
        var total = 0;
        var patternLength = 0;
        for (var i = 0; i < numCounters; i++) {
            total += counters[i];
            patternLength += pattern[i];
        }
        if (total < patternLength) {
            // If we don't even have one pixel per unit of bar width, assume this
            // is too small to reliably match, so fail:
            return /*Float.POSITIVE_INFINITY*/ Infinity;
        }
        // We're going to fake floating-point math in integers. We just need to use more bits.
        // Scale up patternLength so that intermediate values below like scaledCounter will have
        // more "significant digits".
        var unitBarWidth = total / patternLength;
        maxIndividualVariance *= unitBarWidth;
        var totalVariance = 0.0;
        for (var x = 0; x < numCounters; x++) {
            var counter = counters[x];
            var scaledPattern = pattern[x] * unitBarWidth;
            var variance = counter > scaledPattern ? counter - scaledPattern : scaledPattern - counter;
            if (variance > maxIndividualVariance) {
                return /*Float.POSITIVE_INFINITY*/ Infinity;
            }
            totalVariance += variance;
        }
        return totalVariance / total;
    };
    Detector.INDEXES_START_PATTERN = Int32Array.from([0, 4, 1, 5]);
    Detector.INDEXES_STOP_PATTERN = Int32Array.from([6, 2, 7, 3]);
    Detector.MAX_AVG_VARIANCE = 0.42;
    Detector.MAX_INDIVIDUAL_VARIANCE = 0.8;
    // B S B S B S B S Bar/Space pattern
    // 11111111 0 1 0 1 0 1 000
    Detector.START_PATTERN = Int32Array.from([8, 1, 1, 1, 1, 1, 1, 3]);
    // 1111111 0 1 000 1 0 1 00 1
    Detector.STOP_PATTERN = Int32Array.from([7, 1, 1, 3, 1, 1, 1, 2, 1]);
    Detector.MAX_PIXEL_DRIFT = 3;
    Detector.MAX_PATTERN_DRIFT = 5;
    // if we set the value too low, then we don't detect the correct height of the bar if the start patterns are damaged.
    // if we set the value too high, then we might detect the start pattern from a neighbor barcode.
    Detector.SKIPPED_ROW_COUNT_MAX = 25;
    // A PDF471 barcode should have at least 3 rows, with each row being >= 3 times the module width. Therefore it should be at least
    // 9 pixels tall. To be conservative, we use about half the size to ensure we don't miss it.
    Detector.ROW_STEP = 5;
    Detector.BARCODE_MIN_HEIGHT = 10;
    return Detector;
}());
exports.default = Detector;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\pdf417\\detector\\Detector.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\pdf417\\detector\\PDF417DetectorResult.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cpdf417%5Cdetector%5CPDF417DetectorResult.js
      return function (require, module, exports) {
"use strict";
/*
* Copyright 2007 ZXing authors
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
Object.defineProperty(exports, "__esModule", { value: true });
// import java.util.List;
/**
 * @author Guenther Grau
 */
var PDF417DetectorResult = /** @class */ (function () {
    function PDF417DetectorResult(bits, points) {
        this.bits = bits;
        this.points = points;
    }
    PDF417DetectorResult.prototype.getBits = function () {
        return this.bits;
    };
    PDF417DetectorResult.prototype.getPoints = function () {
        return this.points;
    };
    return PDF417DetectorResult;
}());
exports.default = PDF417DetectorResult;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\pdf417\\detector\\PDF417DetectorResult.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\QRCodeReader.js", {"../BarcodeFormat":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\BarcodeFormat.js","../DecodeHintType":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\DecodeHintType.js","../NotFoundException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\NotFoundException.js","../Result":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\Result.js","../ResultMetadataType":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\ResultMetadataType.js","../common/BitMatrix":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\BitMatrix.js","./decoder/Decoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\Decoder.js","./decoder/QRCodeDecoderMetaData":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\QRCodeDecoderMetaData.js","./detector/Detector":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\detector\\Detector.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cqrcode%5CQRCodeReader.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2007 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
/*namespace com.google.zxing.qrcode {*/
var BarcodeFormat_1 = require("../BarcodeFormat");
var BitMatrix_1 = require("../common/BitMatrix");
var DecodeHintType_1 = require("../DecodeHintType");
var NotFoundException_1 = require("../NotFoundException");
var Result_1 = require("../Result");
var ResultMetadataType_1 = require("../ResultMetadataType");
// import DetectorResult from '../common/DetectorResult';
var Decoder_1 = require("./decoder/Decoder");
var QRCodeDecoderMetaData_1 = require("./decoder/QRCodeDecoderMetaData");
var Detector_1 = require("./detector/Detector");
/*import java.util.List;*/
/*import java.util.Map;*/
/**
 * This implementation can detect and decode QR Codes in an image.
 *
 * @author Sean Owen
 */
var QRCodeReader = /** @class */ (function () {
    function QRCodeReader() {
        this.decoder = new Decoder_1.default();
    }
    QRCodeReader.prototype.getDecoder = function () {
        return this.decoder;
    };
    /**
     * Locates and decodes a QR code in an image.
     *
     * @return a representing: string the content encoded by the QR code
     * @throws NotFoundException if a QR code cannot be found
     * @throws FormatException if a QR code cannot be decoded
     * @throws ChecksumException if error correction fails
     */
    /*@Override*/
    // public decode(image: BinaryBitmap): Result /*throws NotFoundException, ChecksumException, FormatException */ {
    //   return this.decode(image, null)
    // }
    /*@Override*/
    QRCodeReader.prototype.decode = function (image, hints) {
        var decoderResult;
        var points;
        if (hints !== undefined && hints !== null && undefined !== hints.get(DecodeHintType_1.default.PURE_BARCODE)) {
            var bits = QRCodeReader.extractPureBits(image.getBlackMatrix());
            decoderResult = this.decoder.decodeBitMatrix(bits, hints);
            points = QRCodeReader.NO_POINTS;
        }
        else {
            var detectorResult = new Detector_1.default(image.getBlackMatrix()).detect(hints);
            decoderResult = this.decoder.decodeBitMatrix(detectorResult.getBits(), hints);
            points = detectorResult.getPoints();
        }
        // If the code was mirrored: swap the bottom-left and the top-right points.
        if (decoderResult.getOther() instanceof QRCodeDecoderMetaData_1.default) {
            decoderResult.getOther().applyMirroredCorrection(points);
        }
        var result = new Result_1.default(decoderResult.getText(), decoderResult.getRawBytes(), undefined, points, BarcodeFormat_1.default.QR_CODE, undefined);
        var byteSegments = decoderResult.getByteSegments();
        if (byteSegments !== null) {
            result.putMetadata(ResultMetadataType_1.default.BYTE_SEGMENTS, byteSegments);
        }
        var ecLevel = decoderResult.getECLevel();
        if (ecLevel !== null) {
            result.putMetadata(ResultMetadataType_1.default.ERROR_CORRECTION_LEVEL, ecLevel);
        }
        if (decoderResult.hasStructuredAppend()) {
            result.putMetadata(ResultMetadataType_1.default.STRUCTURED_APPEND_SEQUENCE, decoderResult.getStructuredAppendSequenceNumber());
            result.putMetadata(ResultMetadataType_1.default.STRUCTURED_APPEND_PARITY, decoderResult.getStructuredAppendParity());
        }
        return result;
    };
    /*@Override*/
    QRCodeReader.prototype.reset = function () {
        // do nothing
    };
    /**
     * This method detects a code in a "pure" image -- that is, pure monochrome image
     * which contains only an unrotated, unskewed, image of a code, with some white border
     * around it. This is a specialized method that works exceptionally fast in this special
     * case.
     *
     * @see com.google.zxing.datamatrix.DataMatrixReader#extractPureBits(BitMatrix)
     */
    QRCodeReader.extractPureBits = function (image) {
        var leftTopBlack = image.getTopLeftOnBit();
        var rightBottomBlack = image.getBottomRightOnBit();
        if (leftTopBlack === null || rightBottomBlack === null) {
            throw new NotFoundException_1.default();
        }
        var moduleSize = this.moduleSize(leftTopBlack, image);
        var top = leftTopBlack[1];
        var bottom = rightBottomBlack[1];
        var left = leftTopBlack[0];
        var right = rightBottomBlack[0];
        // Sanity check!
        if (left >= right || top >= bottom) {
            throw new NotFoundException_1.default();
        }
        if (bottom - top !== right - left) {
            // Special case, where bottom-right module wasn't black so we found something else in the last row
            // Assume it's a square, so use height as the width
            right = left + (bottom - top);
            if (right >= image.getWidth()) {
                // Abort if that would not make sense -- off image
                throw new NotFoundException_1.default();
            }
        }
        var matrixWidth = Math.round((right - left + 1) / moduleSize);
        var matrixHeight = Math.round((bottom - top + 1) / moduleSize);
        if (matrixWidth <= 0 || matrixHeight <= 0) {
            throw new NotFoundException_1.default();
        }
        if (matrixHeight !== matrixWidth) {
            // Only possibly decode square regions
            throw new NotFoundException_1.default();
        }
        // Push in the "border" by half the module width so that we start
        // sampling in the middle of the module. Just in case the image is a
        // little off, this will help recover.
        var nudge = /*(int) */ Math.floor(moduleSize / 2.0);
        top += nudge;
        left += nudge;
        // But careful that this does not sample off the edge
        // "right" is the farthest-right valid pixel location -- right+1 is not necessarily
        // This is positive by how much the inner x loop below would be too large
        var nudgedTooFarRight = left + /*(int) */ Math.floor((matrixWidth - 1) * moduleSize) - right;
        if (nudgedTooFarRight > 0) {
            if (nudgedTooFarRight > nudge) {
                // Neither way fits; abort
                throw new NotFoundException_1.default();
            }
            left -= nudgedTooFarRight;
        }
        // See logic above
        var nudgedTooFarDown = top + /*(int) */ Math.floor((matrixHeight - 1) * moduleSize) - bottom;
        if (nudgedTooFarDown > 0) {
            if (nudgedTooFarDown > nudge) {
                // Neither way fits; abort
                throw new NotFoundException_1.default();
            }
            top -= nudgedTooFarDown;
        }
        // Now just read off the bits
        var bits = new BitMatrix_1.default(matrixWidth, matrixHeight);
        for (var y = 0; y < matrixHeight; y++) {
            var iOffset = top + /*(int) */ Math.floor(y * moduleSize);
            for (var x = 0; x < matrixWidth; x++) {
                if (image.get(left + /*(int) */ Math.floor(x * moduleSize), iOffset)) {
                    bits.set(x, y);
                }
            }
        }
        return bits;
    };
    QRCodeReader.moduleSize = function (leftTopBlack, image) {
        var height = image.getHeight();
        var width = image.getWidth();
        var x = leftTopBlack[0];
        var y = leftTopBlack[1];
        var inBlack = true;
        var transitions = 0;
        while (x < width && y < height) {
            if (inBlack !== image.get(x, y)) {
                if (++transitions === 5) {
                    break;
                }
                inBlack = !inBlack;
            }
            x++;
            y++;
        }
        if (x === width || y === height) {
            throw new NotFoundException_1.default();
        }
        return (x - leftTopBlack[0]) / 7.0;
    };
    QRCodeReader.NO_POINTS = new Array();
    return QRCodeReader;
}());
exports.default = QRCodeReader;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\qrcode\\QRCodeReader.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\QRCodeWriter.js", {"../BarcodeFormat":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\BarcodeFormat.js","../EncodeHintType":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\EncodeHintType.js","../IllegalArgumentException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\IllegalArgumentException.js","../IllegalStateException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\IllegalStateException.js","../common/BitMatrix":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\BitMatrix.js","./decoder/ErrorCorrectionLevel":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\ErrorCorrectionLevel.js","./encoder/Encoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\encoder\\Encoder.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cqrcode%5CQRCodeWriter.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2008 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
/*namespace com.google.zxing.qrcode {*/
var BarcodeFormat_1 = require("../BarcodeFormat");
var EncodeHintType_1 = require("../EncodeHintType");
var BitMatrix_1 = require("../common/BitMatrix");
var ErrorCorrectionLevel_1 = require("./decoder/ErrorCorrectionLevel");
var Encoder_1 = require("./encoder/Encoder");
var IllegalArgumentException_1 = require("../IllegalArgumentException");
var IllegalStateException_1 = require("../IllegalStateException");
/*import java.util.Map;*/
/**
 * This object renders a QR Code as a BitMatrix 2D array of greyscale values.
 *
 * @author dswitkin@google.com (Daniel Switkin)
 */
var QRCodeWriter = /** @class */ (function () {
    function QRCodeWriter() {
    }
    /*@Override*/
    // public encode(contents: string, format: BarcodeFormat, width: number /*int*/, height: number /*int*/): BitMatrix
    //     /*throws WriterException */ {
    //   return encode(contents, format, width, height, null)
    // }
    /*@Override*/
    QRCodeWriter.prototype.encode = function (contents, format, width /*int*/, height /*int*/, hints) {
        if (contents.length === 0) {
            throw new IllegalArgumentException_1.default('Found empty contents');
        }
        if (format !== BarcodeFormat_1.default.QR_CODE) {
            throw new IllegalArgumentException_1.default('Can only encode QR_CODE, but got ' + format);
        }
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException_1.default("Requested dimensions are too small: " + width + "x" + height);
        }
        var errorCorrectionLevel = ErrorCorrectionLevel_1.default.L;
        var quietZone = QRCodeWriter.QUIET_ZONE_SIZE;
        if (hints !== null) {
            if (undefined !== hints.get(EncodeHintType_1.default.ERROR_CORRECTION)) {
                errorCorrectionLevel = ErrorCorrectionLevel_1.default.fromString(hints.get(EncodeHintType_1.default.ERROR_CORRECTION).toString());
            }
            if (undefined !== hints.get(EncodeHintType_1.default.MARGIN)) {
                quietZone = Number.parseInt(hints.get(EncodeHintType_1.default.MARGIN).toString(), 10);
            }
        }
        var code = Encoder_1.default.encode(contents, errorCorrectionLevel, hints);
        return QRCodeWriter.renderResult(code, width, height, quietZone);
    };
    // Note that the input matrix uses 0 == white, 1 == black, while the output matrix uses
    // 0 == black, 255 == white (i.e. an 8 bit greyscale bitmap).
    QRCodeWriter.renderResult = function (code, width /*int*/, height /*int*/, quietZone /*int*/) {
        var input = code.getMatrix();
        if (input === null) {
            throw new IllegalStateException_1.default();
        }
        var inputWidth = input.getWidth();
        var inputHeight = input.getHeight();
        var qrWidth = inputWidth + (quietZone * 2);
        var qrHeight = inputHeight + (quietZone * 2);
        var outputWidth = Math.max(width, qrWidth);
        var outputHeight = Math.max(height, qrHeight);
        var multiple = Math.min(Math.floor(outputWidth / qrWidth), Math.floor(outputHeight / qrHeight));
        // Padding includes both the quiet zone and the extra white pixels to accommodate the requested
        // dimensions. For example, if input is 25x25 the QR will be 33x33 including the quiet zone.
        // If the requested size is 200x160, the multiple will be 4, for a QR of 132x132. These will
        // handle all the padding from 100x100 (the actual QR) up to 200x160.
        var leftPadding = Math.floor((outputWidth - (inputWidth * multiple)) / 2);
        var topPadding = Math.floor((outputHeight - (inputHeight * multiple)) / 2);
        var output = new BitMatrix_1.default(outputWidth, outputHeight);
        for (var inputY = 0, outputY = topPadding; inputY < inputHeight; inputY++, outputY += multiple) {
            // Write the contents of this row of the barcode
            for (var inputX = 0, outputX = leftPadding; inputX < inputWidth; inputX++, outputX += multiple) {
                if (input.get(inputX, inputY) === 1) {
                    output.setRegion(outputX, outputY, multiple, multiple);
                }
            }
        }
        return output;
    };
    QRCodeWriter.QUIET_ZONE_SIZE = 4;
    return QRCodeWriter;
}());
exports.default = QRCodeWriter;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\qrcode\\QRCodeWriter.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\BitMatrixParser.js", {"../../FormatException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\FormatException.js","./DataMask":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\DataMask.js","./FormatInformation":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\FormatInformation.js","./Version":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\Version.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cqrcode%5Cdecoder%5CBitMatrixParser.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2007 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
var Version_1 = require("./Version");
var FormatInformation_1 = require("./FormatInformation");
var DataMask_1 = require("./DataMask");
var FormatException_1 = require("../../FormatException");
/**
 * @author Sean Owen
 */
var BitMatrixParser = /** @class */ (function () {
    /**
     * @param bitMatrix {@link BitMatrix} to parse
     * @throws FormatException if dimension is not >= 21 and 1 mod 4
     */
    function BitMatrixParser(bitMatrix) {
        var dimension = bitMatrix.getHeight();
        if (dimension < 21 || (dimension & 0x03) !== 1) {
            throw new FormatException_1.default();
        }
        this.bitMatrix = bitMatrix;
    }
    /**
     * <p>Reads format information from one of its two locations within the QR Code.</p>
     *
     * @return {@link FormatInformation} encapsulating the QR Code's format info
     * @throws FormatException if both format information locations cannot be parsed as
     * the valid encoding of format information
     */
    BitMatrixParser.prototype.readFormatInformation = function () {
        if (this.parsedFormatInfo !== null && this.parsedFormatInfo !== undefined) {
            return this.parsedFormatInfo;
        }
        // Read top-left format info bits
        var formatInfoBits1 = 0;
        for (var i = 0; i < 6; i++) {
            formatInfoBits1 = this.copyBit(i, 8, formatInfoBits1);
        }
        // .. and skip a bit in the timing pattern ...
        formatInfoBits1 = this.copyBit(7, 8, formatInfoBits1);
        formatInfoBits1 = this.copyBit(8, 8, formatInfoBits1);
        formatInfoBits1 = this.copyBit(8, 7, formatInfoBits1);
        // .. and skip a bit in the timing pattern ...
        for (var j = 5; j >= 0; j--) {
            formatInfoBits1 = this.copyBit(8, j, formatInfoBits1);
        }
        // Read the top-right/bottom-left pattern too
        var dimension = this.bitMatrix.getHeight();
        var formatInfoBits2 = 0;
        var jMin = dimension - 7;
        for (var j = dimension - 1; j >= jMin; j--) {
            formatInfoBits2 = this.copyBit(8, j, formatInfoBits2);
        }
        for (var i = dimension - 8; i < dimension; i++) {
            formatInfoBits2 = this.copyBit(i, 8, formatInfoBits2);
        }
        this.parsedFormatInfo = FormatInformation_1.default.decodeFormatInformation(formatInfoBits1, formatInfoBits2);
        if (this.parsedFormatInfo !== null) {
            return this.parsedFormatInfo;
        }
        throw new FormatException_1.default();
    };
    /**
     * <p>Reads version information from one of its two locations within the QR Code.</p>
     *
     * @return {@link Version} encapsulating the QR Code's version
     * @throws FormatException if both version information locations cannot be parsed as
     * the valid encoding of version information
     */
    BitMatrixParser.prototype.readVersion = function () {
        if (this.parsedVersion !== null && this.parsedVersion !== undefined) {
            return this.parsedVersion;
        }
        var dimension = this.bitMatrix.getHeight();
        var provisionalVersion = Math.floor((dimension - 17) / 4);
        if (provisionalVersion <= 6) {
            return Version_1.default.getVersionForNumber(provisionalVersion);
        }
        // Read top-right version info: 3 wide by 6 tall
        var versionBits = 0;
        var ijMin = dimension - 11;
        for (var j = 5; j >= 0; j--) {
            for (var i = dimension - 9; i >= ijMin; i--) {
                versionBits = this.copyBit(i, j, versionBits);
            }
        }
        var theParsedVersion = Version_1.default.decodeVersionInformation(versionBits);
        if (theParsedVersion !== null && theParsedVersion.getDimensionForVersion() === dimension) {
            this.parsedVersion = theParsedVersion;
            return theParsedVersion;
        }
        // Hmm, failed. Try bottom left: 6 wide by 3 tall
        versionBits = 0;
        for (var i = 5; i >= 0; i--) {
            for (var j = dimension - 9; j >= ijMin; j--) {
                versionBits = this.copyBit(i, j, versionBits);
            }
        }
        theParsedVersion = Version_1.default.decodeVersionInformation(versionBits);
        if (theParsedVersion !== null && theParsedVersion.getDimensionForVersion() === dimension) {
            this.parsedVersion = theParsedVersion;
            return theParsedVersion;
        }
        throw new FormatException_1.default();
    };
    BitMatrixParser.prototype.copyBit = function (i /*int*/, j /*int*/, versionBits /*int*/) {
        var bit = this.isMirror ? this.bitMatrix.get(j, i) : this.bitMatrix.get(i, j);
        return bit ? (versionBits << 1) | 0x1 : versionBits << 1;
    };
    /**
     * <p>Reads the bits in the {@link BitMatrix} representing the finder pattern in the
     * correct order in order to reconstruct the codewords bytes contained within the
     * QR Code.</p>
     *
     * @return bytes encoded within the QR Code
     * @throws FormatException if the exact number of bytes expected is not read
     */
    BitMatrixParser.prototype.readCodewords = function () {
        var formatInfo = this.readFormatInformation();
        var version = this.readVersion();
        // Get the data mask for the format used in this QR Code. This will exclude
        // some bits from reading as we wind through the bit matrix.
        var dataMask = DataMask_1.default.values.get(formatInfo.getDataMask());
        var dimension = this.bitMatrix.getHeight();
        dataMask.unmaskBitMatrix(this.bitMatrix, dimension);
        var functionPattern = version.buildFunctionPattern();
        var readingUp = true;
        var result = new Uint8Array(version.getTotalCodewords());
        var resultOffset = 0;
        var currentByte = 0;
        var bitsRead = 0;
        // Read columns in pairs, from right to left
        for (var j = dimension - 1; j > 0; j -= 2) {
            if (j === 6) {
                // Skip whole column with vertical alignment pattern
                // saves time and makes the other code proceed more cleanly
                j--;
            }
            // Read alternatingly from bottom to top then top to bottom
            for (var count = 0; count < dimension; count++) {
                var i = readingUp ? dimension - 1 - count : count;
                for (var col = 0; col < 2; col++) {
                    // Ignore bits covered by the function pattern
                    if (!functionPattern.get(j - col, i)) {
                        // Read a bit
                        bitsRead++;
                        currentByte <<= 1;
                        if (this.bitMatrix.get(j - col, i)) {
                            currentByte |= 1;
                        }
                        // If we've made a whole byte, save it off
                        if (bitsRead === 8) {
                            result[resultOffset++] = /*(byte) */ currentByte;
                            bitsRead = 0;
                            currentByte = 0;
                        }
                    }
                }
            }
            readingUp = !readingUp; // readingUp ^= true; // readingUp = !readingUp; // switch directions
        }
        if (resultOffset !== version.getTotalCodewords()) {
            throw new FormatException_1.default();
        }
        return result;
    };
    /**
     * Revert the mask removal done while reading the code words. The bit matrix should revert to its original state.
     */
    BitMatrixParser.prototype.remask = function () {
        if (this.parsedFormatInfo === null) {
            return; // We have no format information, and have no data mask
        }
        var dataMask = DataMask_1.default.values.get(this.parsedFormatInfo.getDataMask());
        var dimension = this.bitMatrix.getHeight();
        dataMask.unmaskBitMatrix(this.bitMatrix, dimension);
    };
    /**
     * Prepare the parser for a mirrored operation.
     * This flag has effect only on the {@link #readFormatInformation()} and the
     * {@link #readVersion()}. Before proceeding with {@link #readCodewords()} the
     * {@link #mirror()} method should be called.
     *
     * @param mirror Whether to read version and format information mirrored.
     */
    BitMatrixParser.prototype.setMirror = function (isMirror) {
        this.parsedVersion = null;
        this.parsedFormatInfo = null;
        this.isMirror = isMirror;
    };
    /** Mirror the bit matrix in order to attempt a second reading. */
    BitMatrixParser.prototype.mirror = function () {
        var bitMatrix = this.bitMatrix;
        for (var x = 0, width = bitMatrix.getWidth(); x < width; x++) {
            for (var y = x + 1, height = bitMatrix.getHeight(); y < height; y++) {
                if (bitMatrix.get(x, y) !== bitMatrix.get(y, x)) {
                    bitMatrix.flip(y, x);
                    bitMatrix.flip(x, y);
                }
            }
        }
    };
    return BitMatrixParser;
}());
exports.default = BitMatrixParser;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\BitMatrixParser.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\DataBlock.js", {"../../IllegalArgumentException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\IllegalArgumentException.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cqrcode%5Cdecoder%5CDataBlock.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2007 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
var IllegalArgumentException_1 = require("../../IllegalArgumentException");
/**
 * <p>Encapsulates a block of data within a QR Code. QR Codes may split their data into
 * multiple blocks, each of which is a unit of data and error-correction codewords. Each
 * is represented by an instance of this class.</p>
 *
 * @author Sean Owen
 */
var DataBlock = /** @class */ (function () {
    function DataBlock(numDataCodewords /*int*/, codewords) {
        this.numDataCodewords = numDataCodewords;
        this.codewords = codewords;
    }
    /**
     * <p>When QR Codes use multiple data blocks, they are actually interleaved.
     * That is, the first byte of data block 1 to n is written, then the second bytes, and so on. This
     * method will separate the data into original blocks.</p>
     *
     * @param rawCodewords bytes as read directly from the QR Code
     * @param version version of the QR Code
     * @param ecLevel error-correction level of the QR Code
     * @return DataBlocks containing original bytes, "de-interleaved" from representation in the
     *         QR Code
     */
    DataBlock.getDataBlocks = function (rawCodewords, version, ecLevel) {
        var e_1, _a, e_2, _b;
        if (rawCodewords.length !== version.getTotalCodewords()) {
            throw new IllegalArgumentException_1.default();
        }
        // Figure out the number and size of data blocks used by this version and
        // error correction level
        var ecBlocks = version.getECBlocksForLevel(ecLevel);
        // First count the total number of data blocks
        var totalBlocks = 0;
        var ecBlockArray = ecBlocks.getECBlocks();
        try {
            for (var ecBlockArray_1 = __values(ecBlockArray), ecBlockArray_1_1 = ecBlockArray_1.next(); !ecBlockArray_1_1.done; ecBlockArray_1_1 = ecBlockArray_1.next()) {
                var ecBlock = ecBlockArray_1_1.value;
                totalBlocks += ecBlock.getCount();
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (ecBlockArray_1_1 && !ecBlockArray_1_1.done && (_a = ecBlockArray_1.return)) _a.call(ecBlockArray_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        // Now establish DataBlocks of the appropriate size and number of data codewords
        var result = new Array(totalBlocks);
        var numResultBlocks = 0;
        try {
            for (var ecBlockArray_2 = __values(ecBlockArray), ecBlockArray_2_1 = ecBlockArray_2.next(); !ecBlockArray_2_1.done; ecBlockArray_2_1 = ecBlockArray_2.next()) {
                var ecBlock = ecBlockArray_2_1.value;
                for (var i = 0; i < ecBlock.getCount(); i++) {
                    var numDataCodewords = ecBlock.getDataCodewords();
                    var numBlockCodewords = ecBlocks.getECCodewordsPerBlock() + numDataCodewords;
                    result[numResultBlocks++] = new DataBlock(numDataCodewords, new Uint8Array(numBlockCodewords));
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (ecBlockArray_2_1 && !ecBlockArray_2_1.done && (_b = ecBlockArray_2.return)) _b.call(ecBlockArray_2);
            }
            finally { if (e_2) throw e_2.error; }
        }
        // All blocks have the same amount of data, except that the last n
        // (where n may be 0) have 1 more byte. Figure out where these start.
        var shorterBlocksTotalCodewords = result[0].codewords.length;
        var longerBlocksStartAt = result.length - 1;
        // TYPESCRIPTPORT: check length is correct here
        while (longerBlocksStartAt >= 0) {
            var numCodewords = result[longerBlocksStartAt].codewords.length;
            if (numCodewords === shorterBlocksTotalCodewords) {
                break;
            }
            longerBlocksStartAt--;
        }
        longerBlocksStartAt++;
        var shorterBlocksNumDataCodewords = shorterBlocksTotalCodewords - ecBlocks.getECCodewordsPerBlock();
        // The last elements of result may be 1 element longer
        // first fill out as many elements as all of them have
        var rawCodewordsOffset = 0;
        for (var i = 0; i < shorterBlocksNumDataCodewords; i++) {
            for (var j = 0; j < numResultBlocks; j++) {
                result[j].codewords[i] = rawCodewords[rawCodewordsOffset++];
            }
        }
        // Fill out the last data block in the longer ones
        for (var j = longerBlocksStartAt; j < numResultBlocks; j++) {
            result[j].codewords[shorterBlocksNumDataCodewords] = rawCodewords[rawCodewordsOffset++];
        }
        // Now add in error correction blocks
        var max = result[0].codewords.length;
        for (var i = shorterBlocksNumDataCodewords; i < max; i++) {
            for (var j = 0; j < numResultBlocks; j++) {
                var iOffset = j < longerBlocksStartAt ? i : i + 1;
                result[j].codewords[iOffset] = rawCodewords[rawCodewordsOffset++];
            }
        }
        return result;
    };
    DataBlock.prototype.getNumDataCodewords = function () {
        return this.numDataCodewords;
    };
    DataBlock.prototype.getCodewords = function () {
        return this.codewords;
    };
    return DataBlock;
}());
exports.default = DataBlock;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\DataBlock.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\DataMask.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cqrcode%5Cdecoder%5CDataMask.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2007 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataMaskValues = void 0;
var DataMaskValues;
(function (DataMaskValues) {
    DataMaskValues[DataMaskValues["DATA_MASK_000"] = 0] = "DATA_MASK_000";
    DataMaskValues[DataMaskValues["DATA_MASK_001"] = 1] = "DATA_MASK_001";
    DataMaskValues[DataMaskValues["DATA_MASK_010"] = 2] = "DATA_MASK_010";
    DataMaskValues[DataMaskValues["DATA_MASK_011"] = 3] = "DATA_MASK_011";
    DataMaskValues[DataMaskValues["DATA_MASK_100"] = 4] = "DATA_MASK_100";
    DataMaskValues[DataMaskValues["DATA_MASK_101"] = 5] = "DATA_MASK_101";
    DataMaskValues[DataMaskValues["DATA_MASK_110"] = 6] = "DATA_MASK_110";
    DataMaskValues[DataMaskValues["DATA_MASK_111"] = 7] = "DATA_MASK_111";
})(DataMaskValues = exports.DataMaskValues || (exports.DataMaskValues = {}));
/**
 * <p>Encapsulates data masks for the data bits in a QR code, per ISO 18004:2006 6.8. Implementations
 * of this class can un-mask a raw BitMatrix. For simplicity, they will unmask the entire BitMatrix,
 * including areas used for finder patterns, timing patterns, etc. These areas should be unused
 * after the point they are unmasked anyway.</p>
 *
 * <p>Note that the diagram in section 6.8.1 is misleading since it indicates that i is column position
 * and j is row position. In fact, as the text says, i is row position and j is column position.</p>
 *
 * @author Sean Owen
 */
var DataMask = /** @class */ (function () {
    // See ISO 18004:2006 6.8.1
    function DataMask(value, isMasked) {
        this.value = value;
        this.isMasked = isMasked;
    }
    // End of enum constants.
    /**
     * <p>Implementations of this method reverse the data masking process applied to a QR Code and
     * make its bits ready to read.</p>
     *
     * @param bits representation of QR Code bits
     * @param dimension dimension of QR Code, represented by bits, being unmasked
     */
    DataMask.prototype.unmaskBitMatrix = function (bits, dimension /*int*/) {
        for (var i = 0; i < dimension; i++) {
            for (var j = 0; j < dimension; j++) {
                if (this.isMasked(i, j)) {
                    bits.flip(j, i);
                }
            }
        }
    };
    DataMask.values = new Map([
        /**
         * 000: mask bits for which (x + y) mod 2 == 0
         */
        [DataMaskValues.DATA_MASK_000, new DataMask(DataMaskValues.DATA_MASK_000, function (i /*int*/, j /*int*/) { return ((i + j) & 0x01) === 0; })],
        /**
         * 001: mask bits for which x mod 2 == 0
         */
        [DataMaskValues.DATA_MASK_001, new DataMask(DataMaskValues.DATA_MASK_001, function (i /*int*/, j /*int*/) { return (i & 0x01) === 0; })],
        /**
         * 010: mask bits for which y mod 3 == 0
         */
        [DataMaskValues.DATA_MASK_010, new DataMask(DataMaskValues.DATA_MASK_010, function (i /*int*/, j /*int*/) { return j % 3 === 0; })],
        /**
         * 011: mask bits for which (x + y) mod 3 == 0
         */
        [DataMaskValues.DATA_MASK_011, new DataMask(DataMaskValues.DATA_MASK_011, function (i /*int*/, j /*int*/) { return (i + j) % 3 === 0; })],
        /**
         * 100: mask bits for which (x/2 + y/3) mod 2 == 0
         */
        [DataMaskValues.DATA_MASK_100, new DataMask(DataMaskValues.DATA_MASK_100, function (i /*int*/, j /*int*/) { return ((Math.floor(i / 2) + Math.floor(j / 3)) & 0x01) === 0; })],
        /**
         * 101: mask bits for which xy mod 2 + xy mod 3 == 0
         * equivalently, such that xy mod 6 == 0
         */
        [DataMaskValues.DATA_MASK_101, new DataMask(DataMaskValues.DATA_MASK_101, function (i /*int*/, j /*int*/) { return (i * j) % 6 === 0; })],
        /**
         * 110: mask bits for which (xy mod 2 + xy mod 3) mod 2 == 0
         * equivalently, such that xy mod 6 < 3
         */
        [DataMaskValues.DATA_MASK_110, new DataMask(DataMaskValues.DATA_MASK_110, function (i /*int*/, j /*int*/) { return ((i * j) % 6) < 3; })],
        /**
         * 111: mask bits for which ((x+y)mod 2 + xy mod 3) mod 2 == 0
         * equivalently, such that (x + y + xy mod 3) mod 2 == 0
         */
        [DataMaskValues.DATA_MASK_111, new DataMask(DataMaskValues.DATA_MASK_111, function (i /*int*/, j /*int*/) { return ((i + j + ((i * j) % 3)) & 0x01) === 0; })],
    ]);
    return DataMask;
}());
exports.default = DataMask;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\DataMask.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\DecodedBitStreamParser.js", {"../../FormatException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\FormatException.js","../../common/BitSource":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\BitSource.js","../../common/CharacterSetECI":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\CharacterSetECI.js","../../common/DecoderResult":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\DecoderResult.js","../../common/StringUtils":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\StringUtils.js","../../util/StringBuilder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\StringBuilder.js","../../util/StringEncoding":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\StringEncoding.js","./Mode":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\Mode.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cqrcode%5Cdecoder%5CDecodedBitStreamParser.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2007 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
/*namespace com.google.zxing.qrcode.decoder {*/
var BitSource_1 = require("../../common/BitSource");
var CharacterSetECI_1 = require("../../common/CharacterSetECI");
var DecoderResult_1 = require("../../common/DecoderResult");
var StringUtils_1 = require("../../common/StringUtils");
var FormatException_1 = require("../../FormatException");
var StringBuilder_1 = require("../../util/StringBuilder");
var StringEncoding_1 = require("../../util/StringEncoding");
var Mode_1 = require("./Mode");
/*import java.io.UnsupportedEncodingException;*/
/*import java.util.ArrayList;*/
/*import java.util.Collection;*/
/*import java.util.List;*/
/*import java.util.Map;*/
/**
 * <p>QR Codes can encode text as bits in one of several modes, and can use multiple modes
 * in one QR Code. This class decodes the bits back into text.</p>
 *
 * <p>See ISO 18004:2006, 6.4.3 - 6.4.7</p>
 *
 * @author Sean Owen
 */
var DecodedBitStreamParser = /** @class */ (function () {
    function DecodedBitStreamParser() {
    }
    DecodedBitStreamParser.decode = function (bytes, version, ecLevel, hints) {
        var bits = new BitSource_1.default(bytes);
        var result = new StringBuilder_1.default();
        var byteSegments = new Array(); // 1
        // TYPESCRIPTPORT: I do not use constructor with size 1 as in original Java means capacity and the array length is checked below
        var symbolSequence = -1;
        var parityData = -1;
        try {
            var currentCharacterSetECI = null;
            var fc1InEffect = false;
            var mode = void 0;
            do {
                // While still another segment to read...
                if (bits.available() < 4) {
                    // OK, assume we're done. Really, a TERMINATOR mode should have been recorded here
                    mode = Mode_1.default.TERMINATOR;
                }
                else {
                    var modeBits = bits.readBits(4);
                    mode = Mode_1.default.forBits(modeBits); // mode is encoded by 4 bits
                }
                switch (mode) {
                    case Mode_1.default.TERMINATOR:
                        break;
                    case Mode_1.default.FNC1_FIRST_POSITION:
                    case Mode_1.default.FNC1_SECOND_POSITION:
                        // We do little with FNC1 except alter the parsed result a bit according to the spec
                        fc1InEffect = true;
                        break;
                    case Mode_1.default.STRUCTURED_APPEND:
                        if (bits.available() < 16) {
                            throw new FormatException_1.default();
                        }
                        // sequence number and parity is added later to the result metadata
                        // Read next 8 bits (symbol sequence #) and 8 bits (data: parity), then continue
                        symbolSequence = bits.readBits(8);
                        parityData = bits.readBits(8);
                        break;
                    case Mode_1.default.ECI:
                        // Count doesn't apply to ECI
                        var value = DecodedBitStreamParser.parseECIValue(bits);
                        currentCharacterSetECI = CharacterSetECI_1.default.getCharacterSetECIByValue(value);
                        if (currentCharacterSetECI === null) {
                            throw new FormatException_1.default();
                        }
                        break;
                    case Mode_1.default.HANZI:
                        // First handle Hanzi mode which does not start with character count
                        // Chinese mode contains a sub set indicator right after mode indicator
                        var subset = bits.readBits(4);
                        var countHanzi = bits.readBits(mode.getCharacterCountBits(version));
                        if (subset === DecodedBitStreamParser.GB2312_SUBSET) {
                            DecodedBitStreamParser.decodeHanziSegment(bits, result, countHanzi);
                        }
                        break;
                    default:
                        // "Normal" QR code modes:
                        // How many characters will follow, encoded in this mode?
                        var count = bits.readBits(mode.getCharacterCountBits(version));
                        switch (mode) {
                            case Mode_1.default.NUMERIC:
                                DecodedBitStreamParser.decodeNumericSegment(bits, result, count);
                                break;
                            case Mode_1.default.ALPHANUMERIC:
                                DecodedBitStreamParser.decodeAlphanumericSegment(bits, result, count, fc1InEffect);
                                break;
                            case Mode_1.default.BYTE:
                                DecodedBitStreamParser.decodeByteSegment(bits, result, count, currentCharacterSetECI, byteSegments, hints);
                                break;
                            case Mode_1.default.KANJI:
                                DecodedBitStreamParser.decodeKanjiSegment(bits, result, count);
                                break;
                            default:
                                throw new FormatException_1.default();
                        }
                        break;
                }
            } while (mode !== Mode_1.default.TERMINATOR);
        }
        catch (iae /*: IllegalArgumentException*/) {
            // from readBits() calls
            throw new FormatException_1.default();
        }
        return new DecoderResult_1.default(bytes, result.toString(), byteSegments.length === 0 ? null : byteSegments, ecLevel === null ? null : ecLevel.toString(), symbolSequence, parityData);
    };
    /**
     * See specification GBT 18284-2000
     */
    DecodedBitStreamParser.decodeHanziSegment = function (bits, result, count /*int*/) {
        // Don't crash trying to read more bits than we have available.
        if (count * 13 > bits.available()) {
            throw new FormatException_1.default();
        }
        // Each character will require 2 bytes. Read the characters as 2-byte pairs
        // and decode as GB2312 afterwards
        var buffer = new Uint8Array(2 * count);
        var offset = 0;
        while (count > 0) {
            // Each 13 bits encodes a 2-byte character
            var twoBytes = bits.readBits(13);
            var assembledTwoBytes = (((twoBytes / 0x060) << 8) & 0xFFFFFFFF) | (twoBytes % 0x060);
            if (assembledTwoBytes < 0x003BF) {
                // In the 0xA1A1 to 0xAAFE range
                assembledTwoBytes += 0x0A1A1;
            }
            else {
                // In the 0xB0A1 to 0xFAFE range
                assembledTwoBytes += 0x0A6A1;
            }
            buffer[offset] = /*(byte) */ ((assembledTwoBytes >> 8) & 0xFF);
            buffer[offset + 1] = /*(byte) */ (assembledTwoBytes & 0xFF);
            offset += 2;
            count--;
        }
        try {
            result.append(StringEncoding_1.default.decode(buffer, StringUtils_1.default.GB2312));
            // TYPESCRIPTPORT: TODO: implement GB2312 decode. StringView from MDN could be a starting point
        }
        catch (ignored /*: UnsupportedEncodingException*/) {
            throw new FormatException_1.default(ignored);
        }
    };
    DecodedBitStreamParser.decodeKanjiSegment = function (bits, result, count /*int*/) {
        // Don't crash trying to read more bits than we have available.
        if (count * 13 > bits.available()) {
            throw new FormatException_1.default();
        }
        // Each character will require 2 bytes. Read the characters as 2-byte pairs
        // and decode as Shift_JIS afterwards
        var buffer = new Uint8Array(2 * count);
        var offset = 0;
        while (count > 0) {
            // Each 13 bits encodes a 2-byte character
            var twoBytes = bits.readBits(13);
            var assembledTwoBytes = (((twoBytes / 0x0C0) << 8) & 0xFFFFFFFF) | (twoBytes % 0x0C0);
            if (assembledTwoBytes < 0x01F00) {
                // In the 0x8140 to 0x9FFC range
                assembledTwoBytes += 0x08140;
            }
            else {
                // In the 0xE040 to 0xEBBF range
                assembledTwoBytes += 0x0C140;
            }
            buffer[offset] = /*(byte) */ (assembledTwoBytes >> 8);
            buffer[offset + 1] = /*(byte) */ assembledTwoBytes;
            offset += 2;
            count--;
        }
        // Shift_JIS may not be supported in some environments:
        try {
            result.append(StringEncoding_1.default.decode(buffer, StringUtils_1.default.SHIFT_JIS));
            // TYPESCRIPTPORT: TODO: implement SHIFT_JIS decode. StringView from MDN could be a starting point
        }
        catch (ignored /*: UnsupportedEncodingException*/) {
            throw new FormatException_1.default(ignored);
        }
    };
    DecodedBitStreamParser.decodeByteSegment = function (bits, result, count /*int*/, currentCharacterSetECI, byteSegments, hints) {
        // Don't crash trying to read more bits than we have available.
        if (8 * count > bits.available()) {
            throw new FormatException_1.default();
        }
        var readBytes = new Uint8Array(count);
        for (var i = 0; i < count; i++) {
            readBytes[i] = /*(byte) */ bits.readBits(8);
        }
        var encoding;
        if (currentCharacterSetECI === null) {
            // The spec isn't clear on this mode; see
            // section 6.4.5: t does not say which encoding to assuming
            // upon decoding. I have seen ISO-8859-1 used as well as
            // Shift_JIS -- without anything like an ECI designator to
            // give a hint.
            encoding = StringUtils_1.default.guessEncoding(readBytes, hints);
        }
        else {
            encoding = currentCharacterSetECI.getName();
        }
        try {
            result.append(StringEncoding_1.default.decode(readBytes, encoding));
        }
        catch (ignored /*: UnsupportedEncodingException*/) {
            throw new FormatException_1.default(ignored);
        }
        byteSegments.push(readBytes);
    };
    DecodedBitStreamParser.toAlphaNumericChar = function (value /*int*/) {
        if (value >= DecodedBitStreamParser.ALPHANUMERIC_CHARS.length) {
            throw new FormatException_1.default();
        }
        return DecodedBitStreamParser.ALPHANUMERIC_CHARS[value];
    };
    DecodedBitStreamParser.decodeAlphanumericSegment = function (bits, result, count /*int*/, fc1InEffect) {
        // Read two characters at a time
        var start = result.length();
        while (count > 1) {
            if (bits.available() < 11) {
                throw new FormatException_1.default();
            }
            var nextTwoCharsBits = bits.readBits(11);
            result.append(DecodedBitStreamParser.toAlphaNumericChar(Math.floor(nextTwoCharsBits / 45)));
            result.append(DecodedBitStreamParser.toAlphaNumericChar(nextTwoCharsBits % 45));
            count -= 2;
        }
        if (count === 1) {
            // special case: one character left
            if (bits.available() < 6) {
                throw new FormatException_1.default();
            }
            result.append(DecodedBitStreamParser.toAlphaNumericChar(bits.readBits(6)));
        }
        // See section 6.4.8.1, 6.4.8.2
        if (fc1InEffect) {
            // We need to massage the result a bit if in an FNC1 mode:
            for (var i = start; i < result.length(); i++) {
                if (result.charAt(i) === '%') {
                    if (i < result.length() - 1 && result.charAt(i + 1) === '%') {
                        // %% is rendered as %
                        result.deleteCharAt(i + 1);
                    }
                    else {
                        // In alpha mode, % should be converted to FNC1 separator 0x1D
                        result.setCharAt(i, String.fromCharCode(0x1D));
                    }
                }
            }
        }
    };
    DecodedBitStreamParser.decodeNumericSegment = function (bits, result, count /*int*/) {
        // Read three digits at a time
        while (count >= 3) {
            // Each 10 bits encodes three digits
            if (bits.available() < 10) {
                throw new FormatException_1.default();
            }
            var threeDigitsBits = bits.readBits(10);
            if (threeDigitsBits >= 1000) {
                throw new FormatException_1.default();
            }
            result.append(DecodedBitStreamParser.toAlphaNumericChar(Math.floor(threeDigitsBits / 100)));
            result.append(DecodedBitStreamParser.toAlphaNumericChar(Math.floor(threeDigitsBits / 10) % 10));
            result.append(DecodedBitStreamParser.toAlphaNumericChar(threeDigitsBits % 10));
            count -= 3;
        }
        if (count === 2) {
            // Two digits left over to read, encoded in 7 bits
            if (bits.available() < 7) {
                throw new FormatException_1.default();
            }
            var twoDigitsBits = bits.readBits(7);
            if (twoDigitsBits >= 100) {
                throw new FormatException_1.default();
            }
            result.append(DecodedBitStreamParser.toAlphaNumericChar(Math.floor(twoDigitsBits / 10)));
            result.append(DecodedBitStreamParser.toAlphaNumericChar(twoDigitsBits % 10));
        }
        else if (count === 1) {
            // One digit left over to read
            if (bits.available() < 4) {
                throw new FormatException_1.default();
            }
            var digitBits = bits.readBits(4);
            if (digitBits >= 10) {
                throw new FormatException_1.default();
            }
            result.append(DecodedBitStreamParser.toAlphaNumericChar(digitBits));
        }
    };
    DecodedBitStreamParser.parseECIValue = function (bits) {
        var firstByte = bits.readBits(8);
        if ((firstByte & 0x80) === 0) {
            // just one byte
            return firstByte & 0x7F;
        }
        if ((firstByte & 0xC0) === 0x80) {
            // two bytes
            var secondByte = bits.readBits(8);
            return (((firstByte & 0x3F) << 8) & 0xFFFFFFFF) | secondByte;
        }
        if ((firstByte & 0xE0) === 0xC0) {
            // three bytes
            var secondThirdBytes = bits.readBits(16);
            return (((firstByte & 0x1F) << 16) & 0xFFFFFFFF) | secondThirdBytes;
        }
        throw new FormatException_1.default();
    };
    /**
     * See ISO 18004:2006, 6.4.4 Table 5
     */
    DecodedBitStreamParser.ALPHANUMERIC_CHARS = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ $%*+-./:';
    DecodedBitStreamParser.GB2312_SUBSET = 1;
    return DecodedBitStreamParser;
}());
exports.default = DecodedBitStreamParser;
// function Uint8ArrayToString(a: Uint8Array): string {
//     const CHUNK_SZ = 0x8000;
//     const c = new StringBuilder();
//     for (let i = 0, length = a.length; i < length; i += CHUNK_SZ) {
//         c.append(String.fromCharCode.apply(null, a.subarray(i, i + CHUNK_SZ)));
//     }
//     return c.toString();
// }

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\DecodedBitStreamParser.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\Decoder.js", {"../../ChecksumException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\ChecksumException.js","../../common/BitMatrix":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\BitMatrix.js","../../common/reedsolomon/GenericGF":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\reedsolomon\\GenericGF.js","../../common/reedsolomon/ReedSolomonDecoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\reedsolomon\\ReedSolomonDecoder.js","./BitMatrixParser":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\BitMatrixParser.js","./DataBlock":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\DataBlock.js","./DecodedBitStreamParser":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\DecodedBitStreamParser.js","./QRCodeDecoderMetaData":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\QRCodeDecoderMetaData.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cqrcode%5Cdecoder%5CDecoder.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2007 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
/*namespace com.google.zxing.qrcode.decoder {*/
var ChecksumException_1 = require("../../ChecksumException");
var BitMatrix_1 = require("../../common/BitMatrix");
var GenericGF_1 = require("../../common/reedsolomon/GenericGF");
var ReedSolomonDecoder_1 = require("../../common/reedsolomon/ReedSolomonDecoder");
var BitMatrixParser_1 = require("./BitMatrixParser");
var DataBlock_1 = require("./DataBlock");
var DecodedBitStreamParser_1 = require("./DecodedBitStreamParser");
var QRCodeDecoderMetaData_1 = require("./QRCodeDecoderMetaData");
/*import java.util.Map;*/
/**
 * <p>The main class which implements QR Code decoding -- as opposed to locating and extracting
 * the QR Code from an image.</p>
 *
 * @author Sean Owen
 */
var Decoder = /** @class */ (function () {
    function Decoder() {
        this.rsDecoder = new ReedSolomonDecoder_1.default(GenericGF_1.default.QR_CODE_FIELD_256);
    }
    // public decode(image: boolean[][]): DecoderResult /*throws ChecksumException, FormatException*/ {
    //   return decode(image, null)
    // }
    /**
     * <p>Convenience method that can decode a QR Code represented as a 2D array of booleans.
     * "true" is taken to mean a black module.</p>
     *
     * @param image booleans representing white/black QR Code modules
     * @param hints decoding hints that should be used to influence decoding
     * @return text and bytes encoded within the QR Code
     * @throws FormatException if the QR Code cannot be decoded
     * @throws ChecksumException if error correction fails
     */
    Decoder.prototype.decodeBooleanArray = function (image, hints) {
        return this.decodeBitMatrix(BitMatrix_1.default.parseFromBooleanArray(image), hints);
    };
    // public decodeBitMatrix(bits: BitMatrix): DecoderResult /*throws ChecksumException, FormatException*/ {
    //   return decode(bits, null)
    // }
    /**
     * <p>Decodes a QR Code represented as a {@link BitMatrix}. A 1 or "true" is taken to mean a black module.</p>
     *
     * @param bits booleans representing white/black QR Code modules
     * @param hints decoding hints that should be used to influence decoding
     * @return text and bytes encoded within the QR Code
     * @throws FormatException if the QR Code cannot be decoded
     * @throws ChecksumException if error correction fails
     */
    Decoder.prototype.decodeBitMatrix = function (bits, hints) {
        // Construct a parser and read version, error-correction level
        var parser = new BitMatrixParser_1.default(bits);
        var ex = null;
        try {
            return this.decodeBitMatrixParser(parser, hints);
        }
        catch (e /*: FormatException, ChecksumException*/) {
            ex = e;
        }
        try {
            // Revert the bit matrix
            parser.remask();
            // Will be attempting a mirrored reading of the version and format info.
            parser.setMirror(true);
            // Preemptively read the version.
            parser.readVersion();
            // Preemptively read the format information.
            parser.readFormatInformation();
            /*
             * Since we're here, this means we have successfully detected some kind
             * of version and format information when mirrored. This is a good sign,
             * that the QR code may be mirrored, and we should try once more with a
             * mirrored content.
             */
            // Prepare for a mirrored reading.
            parser.mirror();
            var result = this.decodeBitMatrixParser(parser, hints);
            // Success! Notify the caller that the code was mirrored.
            result.setOther(new QRCodeDecoderMetaData_1.default(true));
            return result;
        }
        catch (e /*FormatException | ChecksumException*/) {
            // Throw the exception from the original reading
            if (ex !== null) {
                throw ex;
            }
            throw e;
        }
    };
    Decoder.prototype.decodeBitMatrixParser = function (parser, hints) {
        var e_1, _a, e_2, _b;
        var version = parser.readVersion();
        var ecLevel = parser.readFormatInformation().getErrorCorrectionLevel();
        // Read codewords
        var codewords = parser.readCodewords();
        // Separate into data blocks
        var dataBlocks = DataBlock_1.default.getDataBlocks(codewords, version, ecLevel);
        // Count total number of data bytes
        var totalBytes = 0;
        try {
            for (var dataBlocks_1 = __values(dataBlocks), dataBlocks_1_1 = dataBlocks_1.next(); !dataBlocks_1_1.done; dataBlocks_1_1 = dataBlocks_1.next()) {
                var dataBlock = dataBlocks_1_1.value;
                totalBytes += dataBlock.getNumDataCodewords();
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (dataBlocks_1_1 && !dataBlocks_1_1.done && (_a = dataBlocks_1.return)) _a.call(dataBlocks_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        var resultBytes = new Uint8Array(totalBytes);
        var resultOffset = 0;
        try {
            // Error-correct and copy data blocks together into a stream of bytes
            for (var dataBlocks_2 = __values(dataBlocks), dataBlocks_2_1 = dataBlocks_2.next(); !dataBlocks_2_1.done; dataBlocks_2_1 = dataBlocks_2.next()) {
                var dataBlock = dataBlocks_2_1.value;
                var codewordBytes = dataBlock.getCodewords();
                var numDataCodewords = dataBlock.getNumDataCodewords();
                this.correctErrors(codewordBytes, numDataCodewords);
                for (var i = 0; i < numDataCodewords; i++) {
                    resultBytes[resultOffset++] = codewordBytes[i];
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (dataBlocks_2_1 && !dataBlocks_2_1.done && (_b = dataBlocks_2.return)) _b.call(dataBlocks_2);
            }
            finally { if (e_2) throw e_2.error; }
        }
        // Decode the contents of that stream of bytes
        return DecodedBitStreamParser_1.default.decode(resultBytes, version, ecLevel, hints);
    };
    /**
     * <p>Given data and error-correction codewords received, possibly corrupted by errors, attempts to
     * correct the errors in-place using Reed-Solomon error correction.</p>
     *
     * @param codewordBytes data and error correction codewords
     * @param numDataCodewords number of codewords that are data bytes
     * @throws ChecksumException if error correction fails
     */
    Decoder.prototype.correctErrors = function (codewordBytes, numDataCodewords /*int*/) {
        // const numCodewords = codewordBytes.length;
        // First read into an array of ints
        var codewordsInts = new Int32Array(codewordBytes);
        // TYPESCRIPTPORT: not realy necessary to transform to ints? could redesign everything to work with unsigned bytes?
        // const codewordsInts = new Int32Array(numCodewords)
        // for (let i = 0; i < numCodewords; i++) {
        //   codewordsInts[i] = codewordBytes[i] & 0xFF
        // }
        try {
            this.rsDecoder.decode(codewordsInts, codewordBytes.length - numDataCodewords);
        }
        catch (ignored /*: ReedSolomonException*/) {
            throw new ChecksumException_1.default();
        }
        // Copy back into array of bytes -- only need to worry about the bytes that were data
        // We don't care about errors in the error-correction codewords
        for (var i = 0; i < numDataCodewords; i++) {
            codewordBytes[i] = /*(byte) */ codewordsInts[i];
        }
    };
    return Decoder;
}());
exports.default = Decoder;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\Decoder.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\ECB.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cqrcode%5Cdecoder%5CECB.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * <p>Encapsulates the parameters for one error-correction block in one symbol version.
 * This includes the number of data codewords, and the number of times a block with these
 * parameters is used consecutively in the QR code version's format.</p>
 */
var ECB = /** @class */ (function () {
    function ECB(count /*int*/, dataCodewords /*int*/) {
        this.count = count;
        this.dataCodewords = dataCodewords;
    }
    ECB.prototype.getCount = function () {
        return this.count;
    };
    ECB.prototype.getDataCodewords = function () {
        return this.dataCodewords;
    };
    return ECB;
}());
exports.default = ECB;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\ECB.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\ECBlocks.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cqrcode%5Cdecoder%5CECBlocks.js
      return function (require, module, exports) {
"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * <p>Encapsulates a set of error-correction blocks in one symbol version. Most versions will
 * use blocks of differing sizes within one version, so, this encapsulates the parameters for
 * each set of blocks. It also holds the number of error-correction codewords per block since it
 * will be the same across all blocks within one version.</p>
 */
var ECBlocks = /** @class */ (function () {
    function ECBlocks(ecCodewordsPerBlock /*int*/) {
        var ecBlocks = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            ecBlocks[_i - 1] = arguments[_i];
        }
        this.ecCodewordsPerBlock = ecCodewordsPerBlock;
        this.ecBlocks = ecBlocks;
    }
    ECBlocks.prototype.getECCodewordsPerBlock = function () {
        return this.ecCodewordsPerBlock;
    };
    ECBlocks.prototype.getNumBlocks = function () {
        var e_1, _a;
        var total = 0;
        var ecBlocks = this.ecBlocks;
        try {
            for (var ecBlocks_1 = __values(ecBlocks), ecBlocks_1_1 = ecBlocks_1.next(); !ecBlocks_1_1.done; ecBlocks_1_1 = ecBlocks_1.next()) {
                var ecBlock = ecBlocks_1_1.value;
                total += ecBlock.getCount();
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (ecBlocks_1_1 && !ecBlocks_1_1.done && (_a = ecBlocks_1.return)) _a.call(ecBlocks_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return total;
    };
    ECBlocks.prototype.getTotalECCodewords = function () {
        return this.ecCodewordsPerBlock * this.getNumBlocks();
    };
    ECBlocks.prototype.getECBlocks = function () {
        return this.ecBlocks;
    };
    return ECBlocks;
}());
exports.default = ECBlocks;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\ECBlocks.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\ErrorCorrectionLevel.js", {"../../ArgumentException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\ArgumentException.js","../../IllegalArgumentException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\IllegalArgumentException.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cqrcode%5Cdecoder%5CErrorCorrectionLevel.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2007 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ErrorCorrectionLevelValues = void 0;
/*namespace com.google.zxing.qrcode.decoder {*/
var ArgumentException_1 = require("../../ArgumentException");
var IllegalArgumentException_1 = require("../../IllegalArgumentException");
var ErrorCorrectionLevelValues;
(function (ErrorCorrectionLevelValues) {
    ErrorCorrectionLevelValues[ErrorCorrectionLevelValues["L"] = 0] = "L";
    ErrorCorrectionLevelValues[ErrorCorrectionLevelValues["M"] = 1] = "M";
    ErrorCorrectionLevelValues[ErrorCorrectionLevelValues["Q"] = 2] = "Q";
    ErrorCorrectionLevelValues[ErrorCorrectionLevelValues["H"] = 3] = "H";
})(ErrorCorrectionLevelValues = exports.ErrorCorrectionLevelValues || (exports.ErrorCorrectionLevelValues = {}));
/**
 * <p>See ISO 18004:2006, 6.5.1. This enum encapsulates the four error correction levels
 * defined by the QR code standard.</p>
 *
 * @author Sean Owen
 */
var ErrorCorrectionLevel = /** @class */ (function () {
    function ErrorCorrectionLevel(value, stringValue, bits /*int*/) {
        this.value = value;
        this.stringValue = stringValue;
        this.bits = bits;
        ErrorCorrectionLevel.FOR_BITS.set(bits, this);
        ErrorCorrectionLevel.FOR_VALUE.set(value, this);
    }
    ErrorCorrectionLevel.prototype.getValue = function () {
        return this.value;
    };
    ErrorCorrectionLevel.prototype.getBits = function () {
        return this.bits;
    };
    ErrorCorrectionLevel.fromString = function (s) {
        switch (s) {
            case 'L': return ErrorCorrectionLevel.L;
            case 'M': return ErrorCorrectionLevel.M;
            case 'Q': return ErrorCorrectionLevel.Q;
            case 'H': return ErrorCorrectionLevel.H;
            default: throw new ArgumentException_1.default(s + 'not available');
        }
    };
    ErrorCorrectionLevel.prototype.toString = function () {
        return this.stringValue;
    };
    ErrorCorrectionLevel.prototype.equals = function (o) {
        if (!(o instanceof ErrorCorrectionLevel)) {
            return false;
        }
        var other = o;
        return this.value === other.value;
    };
    /**
     * @param bits int containing the two bits encoding a QR Code's error correction level
     * @return ErrorCorrectionLevel representing the encoded error correction level
     */
    ErrorCorrectionLevel.forBits = function (bits /*int*/) {
        if (bits < 0 || bits >= ErrorCorrectionLevel.FOR_BITS.size) {
            throw new IllegalArgumentException_1.default();
        }
        return ErrorCorrectionLevel.FOR_BITS.get(bits);
    };
    ErrorCorrectionLevel.FOR_BITS = new Map();
    ErrorCorrectionLevel.FOR_VALUE = new Map();
    /** L = ~7% correction */
    ErrorCorrectionLevel.L = new ErrorCorrectionLevel(ErrorCorrectionLevelValues.L, 'L', 0x01);
    /** M = ~15% correction */
    ErrorCorrectionLevel.M = new ErrorCorrectionLevel(ErrorCorrectionLevelValues.M, 'M', 0x00);
    /** Q = ~25% correction */
    ErrorCorrectionLevel.Q = new ErrorCorrectionLevel(ErrorCorrectionLevelValues.Q, 'Q', 0x03);
    /** H = ~30% correction */
    ErrorCorrectionLevel.H = new ErrorCorrectionLevel(ErrorCorrectionLevelValues.H, 'H', 0x02);
    return ErrorCorrectionLevel;
}());
exports.default = ErrorCorrectionLevel;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\ErrorCorrectionLevel.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\FormatInformation.js", {"../../util/Integer":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\Integer.js","./ErrorCorrectionLevel":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\ErrorCorrectionLevel.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cqrcode%5Cdecoder%5CFormatInformation.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2007 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
/*namespace com.google.zxing.qrcode.decoder {*/
var ErrorCorrectionLevel_1 = require("./ErrorCorrectionLevel");
var Integer_1 = require("../../util/Integer");
/**
 * <p>Encapsulates a QR Code's format information, including the data mask used and
 * error correction level.</p>
 *
 * @author Sean Owen
 * @see DataMask
 * @see ErrorCorrectionLevel
 */
var FormatInformation = /** @class */ (function () {
    function FormatInformation(formatInfo /*int*/) {
        // Bits 3,4
        this.errorCorrectionLevel = ErrorCorrectionLevel_1.default.forBits((formatInfo >> 3) & 0x03);
        // Bottom 3 bits
        this.dataMask = /*(byte) */ (formatInfo & 0x07);
    }
    FormatInformation.numBitsDiffering = function (a /*int*/, b /*int*/) {
        return Integer_1.default.bitCount(a ^ b);
    };
    /**
     * @param maskedFormatInfo1 format info indicator, with mask still applied
     * @param maskedFormatInfo2 second copy of same info; both are checked at the same time
     *  to establish best match
     * @return information about the format it specifies, or {@code null}
     *  if doesn't seem to match any known pattern
     */
    FormatInformation.decodeFormatInformation = function (maskedFormatInfo1 /*int*/, maskedFormatInfo2 /*int*/) {
        var formatInfo = FormatInformation.doDecodeFormatInformation(maskedFormatInfo1, maskedFormatInfo2);
        if (formatInfo !== null) {
            return formatInfo;
        }
        // Should return null, but, some QR codes apparently
        // do not mask this info. Try again by actually masking the pattern
        // first
        return FormatInformation.doDecodeFormatInformation(maskedFormatInfo1 ^ FormatInformation.FORMAT_INFO_MASK_QR, maskedFormatInfo2 ^ FormatInformation.FORMAT_INFO_MASK_QR);
    };
    FormatInformation.doDecodeFormatInformation = function (maskedFormatInfo1 /*int*/, maskedFormatInfo2 /*int*/) {
        var e_1, _a;
        // Find the int in FORMAT_INFO_DECODE_LOOKUP with fewest bits differing
        var bestDifference = Number.MAX_SAFE_INTEGER;
        var bestFormatInfo = 0;
        try {
            for (var _b = __values(FormatInformation.FORMAT_INFO_DECODE_LOOKUP), _c = _b.next(); !_c.done; _c = _b.next()) {
                var decodeInfo = _c.value;
                var targetInfo = decodeInfo[0];
                if (targetInfo === maskedFormatInfo1 || targetInfo === maskedFormatInfo2) {
                    // Found an exact match
                    return new FormatInformation(decodeInfo[1]);
                }
                var bitsDifference = FormatInformation.numBitsDiffering(maskedFormatInfo1, targetInfo);
                if (bitsDifference < bestDifference) {
                    bestFormatInfo = decodeInfo[1];
                    bestDifference = bitsDifference;
                }
                if (maskedFormatInfo1 !== maskedFormatInfo2) {
                    // also try the other option
                    bitsDifference = FormatInformation.numBitsDiffering(maskedFormatInfo2, targetInfo);
                    if (bitsDifference < bestDifference) {
                        bestFormatInfo = decodeInfo[1];
                        bestDifference = bitsDifference;
                    }
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        // Hamming distance of the 32 masked codes is 7, by construction, so <= 3 bits
        // differing means we found a match
        if (bestDifference <= 3) {
            return new FormatInformation(bestFormatInfo);
        }
        return null;
    };
    FormatInformation.prototype.getErrorCorrectionLevel = function () {
        return this.errorCorrectionLevel;
    };
    FormatInformation.prototype.getDataMask = function () {
        return this.dataMask;
    };
    /*@Override*/
    FormatInformation.prototype.hashCode = function () {
        return (this.errorCorrectionLevel.getBits() << 3) | this.dataMask;
    };
    /*@Override*/
    FormatInformation.prototype.equals = function (o) {
        if (!(o instanceof FormatInformation)) {
            return false;
        }
        var other = o;
        return this.errorCorrectionLevel === other.errorCorrectionLevel &&
            this.dataMask === other.dataMask;
    };
    FormatInformation.FORMAT_INFO_MASK_QR = 0x5412;
    /**
     * See ISO 18004:2006, Annex C, Table C.1
     */
    FormatInformation.FORMAT_INFO_DECODE_LOOKUP = [
        Int32Array.from([0x5412, 0x00]),
        Int32Array.from([0x5125, 0x01]),
        Int32Array.from([0x5E7C, 0x02]),
        Int32Array.from([0x5B4B, 0x03]),
        Int32Array.from([0x45F9, 0x04]),
        Int32Array.from([0x40CE, 0x05]),
        Int32Array.from([0x4F97, 0x06]),
        Int32Array.from([0x4AA0, 0x07]),
        Int32Array.from([0x77C4, 0x08]),
        Int32Array.from([0x72F3, 0x09]),
        Int32Array.from([0x7DAA, 0x0A]),
        Int32Array.from([0x789D, 0x0B]),
        Int32Array.from([0x662F, 0x0C]),
        Int32Array.from([0x6318, 0x0D]),
        Int32Array.from([0x6C41, 0x0E]),
        Int32Array.from([0x6976, 0x0F]),
        Int32Array.from([0x1689, 0x10]),
        Int32Array.from([0x13BE, 0x11]),
        Int32Array.from([0x1CE7, 0x12]),
        Int32Array.from([0x19D0, 0x13]),
        Int32Array.from([0x0762, 0x14]),
        Int32Array.from([0x0255, 0x15]),
        Int32Array.from([0x0D0C, 0x16]),
        Int32Array.from([0x083B, 0x17]),
        Int32Array.from([0x355F, 0x18]),
        Int32Array.from([0x3068, 0x19]),
        Int32Array.from([0x3F31, 0x1A]),
        Int32Array.from([0x3A06, 0x1B]),
        Int32Array.from([0x24B4, 0x1C]),
        Int32Array.from([0x2183, 0x1D]),
        Int32Array.from([0x2EDA, 0x1E]),
        Int32Array.from([0x2BED, 0x1F]),
    ];
    return FormatInformation;
}());
exports.default = FormatInformation;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\FormatInformation.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\Mode.js", {"../../IllegalArgumentException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\IllegalArgumentException.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cqrcode%5Cdecoder%5CMode.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2007 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ModeValues = void 0;
var IllegalArgumentException_1 = require("../../IllegalArgumentException");
var ModeValues;
(function (ModeValues) {
    ModeValues[ModeValues["TERMINATOR"] = 0] = "TERMINATOR";
    ModeValues[ModeValues["NUMERIC"] = 1] = "NUMERIC";
    ModeValues[ModeValues["ALPHANUMERIC"] = 2] = "ALPHANUMERIC";
    ModeValues[ModeValues["STRUCTURED_APPEND"] = 3] = "STRUCTURED_APPEND";
    ModeValues[ModeValues["BYTE"] = 4] = "BYTE";
    ModeValues[ModeValues["ECI"] = 5] = "ECI";
    ModeValues[ModeValues["KANJI"] = 6] = "KANJI";
    ModeValues[ModeValues["FNC1_FIRST_POSITION"] = 7] = "FNC1_FIRST_POSITION";
    ModeValues[ModeValues["FNC1_SECOND_POSITION"] = 8] = "FNC1_SECOND_POSITION";
    /** See GBT 18284-2000; "Hanzi" is a transliteration of this mode name. */
    ModeValues[ModeValues["HANZI"] = 9] = "HANZI";
})(ModeValues = exports.ModeValues || (exports.ModeValues = {}));
/**
 * <p>See ISO 18004:2006, 6.4.1, Tables 2 and 3. This enum encapsulates the various modes in which
 * data can be encoded to bits in the QR code standard.</p>
 *
 * @author Sean Owen
 */
var Mode = /** @class */ (function () {
    function Mode(value, stringValue, characterCountBitsForVersions, bits /*int*/) {
        this.value = value;
        this.stringValue = stringValue;
        this.characterCountBitsForVersions = characterCountBitsForVersions;
        this.bits = bits;
        Mode.FOR_BITS.set(bits, this);
        Mode.FOR_VALUE.set(value, this);
    }
    /**
     * @param bits four bits encoding a QR Code data mode
     * @return Mode encoded by these bits
     * @throws IllegalArgumentException if bits do not correspond to a known mode
     */
    Mode.forBits = function (bits /*int*/) {
        var mode = Mode.FOR_BITS.get(bits);
        if (undefined === mode) {
            throw new IllegalArgumentException_1.default();
        }
        return mode;
    };
    /**
     * @param version version in question
     * @return number of bits used, in this QR Code symbol {@link Version}, to encode the
     *         count of characters that will follow encoded in this Mode
     */
    Mode.prototype.getCharacterCountBits = function (version) {
        var versionNumber = version.getVersionNumber();
        var offset;
        if (versionNumber <= 9) {
            offset = 0;
        }
        else if (versionNumber <= 26) {
            offset = 1;
        }
        else {
            offset = 2;
        }
        return this.characterCountBitsForVersions[offset];
    };
    Mode.prototype.getValue = function () {
        return this.value;
    };
    Mode.prototype.getBits = function () {
        return this.bits;
    };
    Mode.prototype.equals = function (o) {
        if (!(o instanceof Mode)) {
            return false;
        }
        var other = o;
        return this.value === other.value;
    };
    Mode.prototype.toString = function () {
        return this.stringValue;
    };
    Mode.FOR_BITS = new Map();
    Mode.FOR_VALUE = new Map();
    Mode.TERMINATOR = new Mode(ModeValues.TERMINATOR, 'TERMINATOR', Int32Array.from([0, 0, 0]), 0x00); // Not really a mode...
    Mode.NUMERIC = new Mode(ModeValues.NUMERIC, 'NUMERIC', Int32Array.from([10, 12, 14]), 0x01);
    Mode.ALPHANUMERIC = new Mode(ModeValues.ALPHANUMERIC, 'ALPHANUMERIC', Int32Array.from([9, 11, 13]), 0x02);
    Mode.STRUCTURED_APPEND = new Mode(ModeValues.STRUCTURED_APPEND, 'STRUCTURED_APPEND', Int32Array.from([0, 0, 0]), 0x03); // Not supported
    Mode.BYTE = new Mode(ModeValues.BYTE, 'BYTE', Int32Array.from([8, 16, 16]), 0x04);
    Mode.ECI = new Mode(ModeValues.ECI, 'ECI', Int32Array.from([0, 0, 0]), 0x07); // character counts don't apply
    Mode.KANJI = new Mode(ModeValues.KANJI, 'KANJI', Int32Array.from([8, 10, 12]), 0x08);
    Mode.FNC1_FIRST_POSITION = new Mode(ModeValues.FNC1_FIRST_POSITION, 'FNC1_FIRST_POSITION', Int32Array.from([0, 0, 0]), 0x05);
    Mode.FNC1_SECOND_POSITION = new Mode(ModeValues.FNC1_SECOND_POSITION, 'FNC1_SECOND_POSITION', Int32Array.from([0, 0, 0]), 0x09);
    /** See GBT 18284-2000; "Hanzi" is a transliteration of this mode name. */
    Mode.HANZI = new Mode(ModeValues.HANZI, 'HANZI', Int32Array.from([8, 10, 12]), 0x0D);
    return Mode;
}());
exports.default = Mode;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\Mode.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\QRCodeDecoderMetaData.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cqrcode%5Cdecoder%5CQRCodeDecoderMetaData.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2013 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Meta-data container for QR Code decoding. Instances of this class may be used to convey information back to the
 * decoding caller. Callers are expected to process this.
 *
 * @see com.google.zxing.common.DecoderResult#getOther()
 */
var QRCodeDecoderMetaData = /** @class */ (function () {
    function QRCodeDecoderMetaData(mirrored) {
        this.mirrored = mirrored;
    }
    /**
     * @return true if the QR Code was mirrored.
     */
    QRCodeDecoderMetaData.prototype.isMirrored = function () {
        return this.mirrored;
    };
    /**
     * Apply the result points' order correction due to mirroring.
     *
     * @param points Array of points to apply mirror correction to.
     */
    QRCodeDecoderMetaData.prototype.applyMirroredCorrection = function (points) {
        if (!this.mirrored || points === null || points.length < 3) {
            return;
        }
        var bottomLeft = points[0];
        points[0] = points[2];
        points[2] = bottomLeft;
        // No need to 'fix' top-left and alignment pattern.
    };
    return QRCodeDecoderMetaData;
}());
exports.default = QRCodeDecoderMetaData;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\QRCodeDecoderMetaData.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\Version.js", {"../../FormatException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\FormatException.js","../../IllegalArgumentException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\IllegalArgumentException.js","../../common/BitMatrix":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\BitMatrix.js","./ECB":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\ECB.js","./ECBlocks":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\ECBlocks.js","./FormatInformation":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\FormatInformation.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cqrcode%5Cdecoder%5CVersion.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2007 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
/*namespace com.google.zxing.qrcode.decoder {*/
var BitMatrix_1 = require("../../common/BitMatrix");
var FormatInformation_1 = require("./FormatInformation");
var ECBlocks_1 = require("./ECBlocks");
var ECB_1 = require("./ECB");
var FormatException_1 = require("../../FormatException");
var IllegalArgumentException_1 = require("../../IllegalArgumentException");
/**
 * See ISO 18004:2006 Annex D
 *
 * @author Sean Owen
 */
var Version = /** @class */ (function () {
    function Version(versionNumber /*int*/, alignmentPatternCenters) {
        var e_1, _a;
        var ecBlocks = [];
        for (var _i = 2; _i < arguments.length; _i++) {
            ecBlocks[_i - 2] = arguments[_i];
        }
        this.versionNumber = versionNumber;
        this.alignmentPatternCenters = alignmentPatternCenters;
        this.ecBlocks = ecBlocks;
        var total = 0;
        var ecCodewords = ecBlocks[0].getECCodewordsPerBlock();
        var ecbArray = ecBlocks[0].getECBlocks();
        try {
            for (var ecbArray_1 = __values(ecbArray), ecbArray_1_1 = ecbArray_1.next(); !ecbArray_1_1.done; ecbArray_1_1 = ecbArray_1.next()) {
                var ecBlock = ecbArray_1_1.value;
                total += ecBlock.getCount() * (ecBlock.getDataCodewords() + ecCodewords);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (ecbArray_1_1 && !ecbArray_1_1.done && (_a = ecbArray_1.return)) _a.call(ecbArray_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        this.totalCodewords = total;
    }
    Version.prototype.getVersionNumber = function () {
        return this.versionNumber;
    };
    Version.prototype.getAlignmentPatternCenters = function () {
        return this.alignmentPatternCenters;
    };
    Version.prototype.getTotalCodewords = function () {
        return this.totalCodewords;
    };
    Version.prototype.getDimensionForVersion = function () {
        return 17 + 4 * this.versionNumber;
    };
    Version.prototype.getECBlocksForLevel = function (ecLevel) {
        return this.ecBlocks[ecLevel.getValue()];
        // TYPESCRIPTPORT: original was using ordinal, and using the order of levels as defined in ErrorCorrectionLevel enum (LMQH)
        // I will use the direct value from ErrorCorrectionLevelValues enum which in typescript goes to a number
    };
    /**
     * <p>Deduces version information purely from QR Code dimensions.</p>
     *
     * @param dimension dimension in modules
     * @return Version for a QR Code of that dimension
     * @throws FormatException if dimension is not 1 mod 4
     */
    Version.getProvisionalVersionForDimension = function (dimension /*int*/) {
        if (dimension % 4 !== 1) {
            throw new FormatException_1.default();
        }
        try {
            return this.getVersionForNumber((dimension - 17) / 4);
        }
        catch (ignored /*: IllegalArgumentException*/) {
            throw new FormatException_1.default();
        }
    };
    Version.getVersionForNumber = function (versionNumber /*int*/) {
        if (versionNumber < 1 || versionNumber > 40) {
            throw new IllegalArgumentException_1.default();
        }
        return Version.VERSIONS[versionNumber - 1];
    };
    Version.decodeVersionInformation = function (versionBits /*int*/) {
        var bestDifference = Number.MAX_SAFE_INTEGER;
        var bestVersion = 0;
        for (var i = 0; i < Version.VERSION_DECODE_INFO.length; i++) {
            var targetVersion = Version.VERSION_DECODE_INFO[i];
            // Do the version info bits match exactly? done.
            if (targetVersion === versionBits) {
                return Version.getVersionForNumber(i + 7);
            }
            // Otherwise see if this is the closest to a real version info bit string
            // we have seen so far
            var bitsDifference = FormatInformation_1.default.numBitsDiffering(versionBits, targetVersion);
            if (bitsDifference < bestDifference) {
                bestVersion = i + 7;
                bestDifference = bitsDifference;
            }
        }
        // We can tolerate up to 3 bits of error since no two version info codewords will
        // differ in less than 8 bits.
        if (bestDifference <= 3) {
            return Version.getVersionForNumber(bestVersion);
        }
        // If we didn't find a close enough match, fail
        return null;
    };
    /**
     * See ISO 18004:2006 Annex E
     */
    Version.prototype.buildFunctionPattern = function () {
        var dimension = this.getDimensionForVersion();
        var bitMatrix = new BitMatrix_1.default(dimension);
        // Top left finder pattern + separator + format
        bitMatrix.setRegion(0, 0, 9, 9);
        // Top right finder pattern + separator + format
        bitMatrix.setRegion(dimension - 8, 0, 8, 9);
        // Bottom left finder pattern + separator + format
        bitMatrix.setRegion(0, dimension - 8, 9, 8);
        // Alignment patterns
        var max = this.alignmentPatternCenters.length;
        for (var x = 0; x < max; x++) {
            var i = this.alignmentPatternCenters[x] - 2;
            for (var y = 0; y < max; y++) {
                if ((x === 0 && (y === 0 || y === max - 1)) || (x === max - 1 && y === 0)) {
                    // No alignment patterns near the three finder patterns
                    continue;
                }
                bitMatrix.setRegion(this.alignmentPatternCenters[y] - 2, i, 5, 5);
            }
        }
        // Vertical timing pattern
        bitMatrix.setRegion(6, 9, 1, dimension - 17);
        // Horizontal timing pattern
        bitMatrix.setRegion(9, 6, dimension - 17, 1);
        if (this.versionNumber > 6) {
            // Version info, top right
            bitMatrix.setRegion(dimension - 11, 0, 3, 6);
            // Version info, bottom left
            bitMatrix.setRegion(0, dimension - 11, 6, 3);
        }
        return bitMatrix;
    };
    /*@Override*/
    Version.prototype.toString = function () {
        return '' + this.versionNumber;
    };
    /**
       * See ISO 18004:2006 Annex D.
       * Element i represents the raw version bits that specify version i + 7
       */
    Version.VERSION_DECODE_INFO = Int32Array.from([
        0x07C94, 0x085BC, 0x09A99, 0x0A4D3, 0x0BBF6,
        0x0C762, 0x0D847, 0x0E60D, 0x0F928, 0x10B78,
        0x1145D, 0x12A17, 0x13532, 0x149A6, 0x15683,
        0x168C9, 0x177EC, 0x18EC4, 0x191E1, 0x1AFAB,
        0x1B08E, 0x1CC1A, 0x1D33F, 0x1ED75, 0x1F250,
        0x209D5, 0x216F0, 0x228BA, 0x2379F, 0x24B0B,
        0x2542E, 0x26A64, 0x27541, 0x28C69
    ]);
    /**
       * See ISO 18004:2006 6.5.1 Table 9
       */
    Version.VERSIONS = [
        new Version(1, new Int32Array(0), new ECBlocks_1.default(7, new ECB_1.default(1, 19)), new ECBlocks_1.default(10, new ECB_1.default(1, 16)), new ECBlocks_1.default(13, new ECB_1.default(1, 13)), new ECBlocks_1.default(17, new ECB_1.default(1, 9))),
        new Version(2, Int32Array.from([6, 18]), new ECBlocks_1.default(10, new ECB_1.default(1, 34)), new ECBlocks_1.default(16, new ECB_1.default(1, 28)), new ECBlocks_1.default(22, new ECB_1.default(1, 22)), new ECBlocks_1.default(28, new ECB_1.default(1, 16))),
        new Version(3, Int32Array.from([6, 22]), new ECBlocks_1.default(15, new ECB_1.default(1, 55)), new ECBlocks_1.default(26, new ECB_1.default(1, 44)), new ECBlocks_1.default(18, new ECB_1.default(2, 17)), new ECBlocks_1.default(22, new ECB_1.default(2, 13))),
        new Version(4, Int32Array.from([6, 26]), new ECBlocks_1.default(20, new ECB_1.default(1, 80)), new ECBlocks_1.default(18, new ECB_1.default(2, 32)), new ECBlocks_1.default(26, new ECB_1.default(2, 24)), new ECBlocks_1.default(16, new ECB_1.default(4, 9))),
        new Version(5, Int32Array.from([6, 30]), new ECBlocks_1.default(26, new ECB_1.default(1, 108)), new ECBlocks_1.default(24, new ECB_1.default(2, 43)), new ECBlocks_1.default(18, new ECB_1.default(2, 15), new ECB_1.default(2, 16)), new ECBlocks_1.default(22, new ECB_1.default(2, 11), new ECB_1.default(2, 12))),
        new Version(6, Int32Array.from([6, 34]), new ECBlocks_1.default(18, new ECB_1.default(2, 68)), new ECBlocks_1.default(16, new ECB_1.default(4, 27)), new ECBlocks_1.default(24, new ECB_1.default(4, 19)), new ECBlocks_1.default(28, new ECB_1.default(4, 15))),
        new Version(7, Int32Array.from([6, 22, 38]), new ECBlocks_1.default(20, new ECB_1.default(2, 78)), new ECBlocks_1.default(18, new ECB_1.default(4, 31)), new ECBlocks_1.default(18, new ECB_1.default(2, 14), new ECB_1.default(4, 15)), new ECBlocks_1.default(26, new ECB_1.default(4, 13), new ECB_1.default(1, 14))),
        new Version(8, Int32Array.from([6, 24, 42]), new ECBlocks_1.default(24, new ECB_1.default(2, 97)), new ECBlocks_1.default(22, new ECB_1.default(2, 38), new ECB_1.default(2, 39)), new ECBlocks_1.default(22, new ECB_1.default(4, 18), new ECB_1.default(2, 19)), new ECBlocks_1.default(26, new ECB_1.default(4, 14), new ECB_1.default(2, 15))),
        new Version(9, Int32Array.from([6, 26, 46]), new ECBlocks_1.default(30, new ECB_1.default(2, 116)), new ECBlocks_1.default(22, new ECB_1.default(3, 36), new ECB_1.default(2, 37)), new ECBlocks_1.default(20, new ECB_1.default(4, 16), new ECB_1.default(4, 17)), new ECBlocks_1.default(24, new ECB_1.default(4, 12), new ECB_1.default(4, 13))),
        new Version(10, Int32Array.from([6, 28, 50]), new ECBlocks_1.default(18, new ECB_1.default(2, 68), new ECB_1.default(2, 69)), new ECBlocks_1.default(26, new ECB_1.default(4, 43), new ECB_1.default(1, 44)), new ECBlocks_1.default(24, new ECB_1.default(6, 19), new ECB_1.default(2, 20)), new ECBlocks_1.default(28, new ECB_1.default(6, 15), new ECB_1.default(2, 16))),
        new Version(11, Int32Array.from([6, 30, 54]), new ECBlocks_1.default(20, new ECB_1.default(4, 81)), new ECBlocks_1.default(30, new ECB_1.default(1, 50), new ECB_1.default(4, 51)), new ECBlocks_1.default(28, new ECB_1.default(4, 22), new ECB_1.default(4, 23)), new ECBlocks_1.default(24, new ECB_1.default(3, 12), new ECB_1.default(8, 13))),
        new Version(12, Int32Array.from([6, 32, 58]), new ECBlocks_1.default(24, new ECB_1.default(2, 92), new ECB_1.default(2, 93)), new ECBlocks_1.default(22, new ECB_1.default(6, 36), new ECB_1.default(2, 37)), new ECBlocks_1.default(26, new ECB_1.default(4, 20), new ECB_1.default(6, 21)), new ECBlocks_1.default(28, new ECB_1.default(7, 14), new ECB_1.default(4, 15))),
        new Version(13, Int32Array.from([6, 34, 62]), new ECBlocks_1.default(26, new ECB_1.default(4, 107)), new ECBlocks_1.default(22, new ECB_1.default(8, 37), new ECB_1.default(1, 38)), new ECBlocks_1.default(24, new ECB_1.default(8, 20), new ECB_1.default(4, 21)), new ECBlocks_1.default(22, new ECB_1.default(12, 11), new ECB_1.default(4, 12))),
        new Version(14, Int32Array.from([6, 26, 46, 66]), new ECBlocks_1.default(30, new ECB_1.default(3, 115), new ECB_1.default(1, 116)), new ECBlocks_1.default(24, new ECB_1.default(4, 40), new ECB_1.default(5, 41)), new ECBlocks_1.default(20, new ECB_1.default(11, 16), new ECB_1.default(5, 17)), new ECBlocks_1.default(24, new ECB_1.default(11, 12), new ECB_1.default(5, 13))),
        new Version(15, Int32Array.from([6, 26, 48, 70]), new ECBlocks_1.default(22, new ECB_1.default(5, 87), new ECB_1.default(1, 88)), new ECBlocks_1.default(24, new ECB_1.default(5, 41), new ECB_1.default(5, 42)), new ECBlocks_1.default(30, new ECB_1.default(5, 24), new ECB_1.default(7, 25)), new ECBlocks_1.default(24, new ECB_1.default(11, 12), new ECB_1.default(7, 13))),
        new Version(16, Int32Array.from([6, 26, 50, 74]), new ECBlocks_1.default(24, new ECB_1.default(5, 98), new ECB_1.default(1, 99)), new ECBlocks_1.default(28, new ECB_1.default(7, 45), new ECB_1.default(3, 46)), new ECBlocks_1.default(24, new ECB_1.default(15, 19), new ECB_1.default(2, 20)), new ECBlocks_1.default(30, new ECB_1.default(3, 15), new ECB_1.default(13, 16))),
        new Version(17, Int32Array.from([6, 30, 54, 78]), new ECBlocks_1.default(28, new ECB_1.default(1, 107), new ECB_1.default(5, 108)), new ECBlocks_1.default(28, new ECB_1.default(10, 46), new ECB_1.default(1, 47)), new ECBlocks_1.default(28, new ECB_1.default(1, 22), new ECB_1.default(15, 23)), new ECBlocks_1.default(28, new ECB_1.default(2, 14), new ECB_1.default(17, 15))),
        new Version(18, Int32Array.from([6, 30, 56, 82]), new ECBlocks_1.default(30, new ECB_1.default(5, 120), new ECB_1.default(1, 121)), new ECBlocks_1.default(26, new ECB_1.default(9, 43), new ECB_1.default(4, 44)), new ECBlocks_1.default(28, new ECB_1.default(17, 22), new ECB_1.default(1, 23)), new ECBlocks_1.default(28, new ECB_1.default(2, 14), new ECB_1.default(19, 15))),
        new Version(19, Int32Array.from([6, 30, 58, 86]), new ECBlocks_1.default(28, new ECB_1.default(3, 113), new ECB_1.default(4, 114)), new ECBlocks_1.default(26, new ECB_1.default(3, 44), new ECB_1.default(11, 45)), new ECBlocks_1.default(26, new ECB_1.default(17, 21), new ECB_1.default(4, 22)), new ECBlocks_1.default(26, new ECB_1.default(9, 13), new ECB_1.default(16, 14))),
        new Version(20, Int32Array.from([6, 34, 62, 90]), new ECBlocks_1.default(28, new ECB_1.default(3, 107), new ECB_1.default(5, 108)), new ECBlocks_1.default(26, new ECB_1.default(3, 41), new ECB_1.default(13, 42)), new ECBlocks_1.default(30, new ECB_1.default(15, 24), new ECB_1.default(5, 25)), new ECBlocks_1.default(28, new ECB_1.default(15, 15), new ECB_1.default(10, 16))),
        new Version(21, Int32Array.from([6, 28, 50, 72, 94]), new ECBlocks_1.default(28, new ECB_1.default(4, 116), new ECB_1.default(4, 117)), new ECBlocks_1.default(26, new ECB_1.default(17, 42)), new ECBlocks_1.default(28, new ECB_1.default(17, 22), new ECB_1.default(6, 23)), new ECBlocks_1.default(30, new ECB_1.default(19, 16), new ECB_1.default(6, 17))),
        new Version(22, Int32Array.from([6, 26, 50, 74, 98]), new ECBlocks_1.default(28, new ECB_1.default(2, 111), new ECB_1.default(7, 112)), new ECBlocks_1.default(28, new ECB_1.default(17, 46)), new ECBlocks_1.default(30, new ECB_1.default(7, 24), new ECB_1.default(16, 25)), new ECBlocks_1.default(24, new ECB_1.default(34, 13))),
        new Version(23, Int32Array.from([6, 30, 54, 78, 102]), new ECBlocks_1.default(30, new ECB_1.default(4, 121), new ECB_1.default(5, 122)), new ECBlocks_1.default(28, new ECB_1.default(4, 47), new ECB_1.default(14, 48)), new ECBlocks_1.default(30, new ECB_1.default(11, 24), new ECB_1.default(14, 25)), new ECBlocks_1.default(30, new ECB_1.default(16, 15), new ECB_1.default(14, 16))),
        new Version(24, Int32Array.from([6, 28, 54, 80, 106]), new ECBlocks_1.default(30, new ECB_1.default(6, 117), new ECB_1.default(4, 118)), new ECBlocks_1.default(28, new ECB_1.default(6, 45), new ECB_1.default(14, 46)), new ECBlocks_1.default(30, new ECB_1.default(11, 24), new ECB_1.default(16, 25)), new ECBlocks_1.default(30, new ECB_1.default(30, 16), new ECB_1.default(2, 17))),
        new Version(25, Int32Array.from([6, 32, 58, 84, 110]), new ECBlocks_1.default(26, new ECB_1.default(8, 106), new ECB_1.default(4, 107)), new ECBlocks_1.default(28, new ECB_1.default(8, 47), new ECB_1.default(13, 48)), new ECBlocks_1.default(30, new ECB_1.default(7, 24), new ECB_1.default(22, 25)), new ECBlocks_1.default(30, new ECB_1.default(22, 15), new ECB_1.default(13, 16))),
        new Version(26, Int32Array.from([6, 30, 58, 86, 114]), new ECBlocks_1.default(28, new ECB_1.default(10, 114), new ECB_1.default(2, 115)), new ECBlocks_1.default(28, new ECB_1.default(19, 46), new ECB_1.default(4, 47)), new ECBlocks_1.default(28, new ECB_1.default(28, 22), new ECB_1.default(6, 23)), new ECBlocks_1.default(30, new ECB_1.default(33, 16), new ECB_1.default(4, 17))),
        new Version(27, Int32Array.from([6, 34, 62, 90, 118]), new ECBlocks_1.default(30, new ECB_1.default(8, 122), new ECB_1.default(4, 123)), new ECBlocks_1.default(28, new ECB_1.default(22, 45), new ECB_1.default(3, 46)), new ECBlocks_1.default(30, new ECB_1.default(8, 23), new ECB_1.default(26, 24)), new ECBlocks_1.default(30, new ECB_1.default(12, 15), new ECB_1.default(28, 16))),
        new Version(28, Int32Array.from([6, 26, 50, 74, 98, 122]), new ECBlocks_1.default(30, new ECB_1.default(3, 117), new ECB_1.default(10, 118)), new ECBlocks_1.default(28, new ECB_1.default(3, 45), new ECB_1.default(23, 46)), new ECBlocks_1.default(30, new ECB_1.default(4, 24), new ECB_1.default(31, 25)), new ECBlocks_1.default(30, new ECB_1.default(11, 15), new ECB_1.default(31, 16))),
        new Version(29, Int32Array.from([6, 30, 54, 78, 102, 126]), new ECBlocks_1.default(30, new ECB_1.default(7, 116), new ECB_1.default(7, 117)), new ECBlocks_1.default(28, new ECB_1.default(21, 45), new ECB_1.default(7, 46)), new ECBlocks_1.default(30, new ECB_1.default(1, 23), new ECB_1.default(37, 24)), new ECBlocks_1.default(30, new ECB_1.default(19, 15), new ECB_1.default(26, 16))),
        new Version(30, Int32Array.from([6, 26, 52, 78, 104, 130]), new ECBlocks_1.default(30, new ECB_1.default(5, 115), new ECB_1.default(10, 116)), new ECBlocks_1.default(28, new ECB_1.default(19, 47), new ECB_1.default(10, 48)), new ECBlocks_1.default(30, new ECB_1.default(15, 24), new ECB_1.default(25, 25)), new ECBlocks_1.default(30, new ECB_1.default(23, 15), new ECB_1.default(25, 16))),
        new Version(31, Int32Array.from([6, 30, 56, 82, 108, 134]), new ECBlocks_1.default(30, new ECB_1.default(13, 115), new ECB_1.default(3, 116)), new ECBlocks_1.default(28, new ECB_1.default(2, 46), new ECB_1.default(29, 47)), new ECBlocks_1.default(30, new ECB_1.default(42, 24), new ECB_1.default(1, 25)), new ECBlocks_1.default(30, new ECB_1.default(23, 15), new ECB_1.default(28, 16))),
        new Version(32, Int32Array.from([6, 34, 60, 86, 112, 138]), new ECBlocks_1.default(30, new ECB_1.default(17, 115)), new ECBlocks_1.default(28, new ECB_1.default(10, 46), new ECB_1.default(23, 47)), new ECBlocks_1.default(30, new ECB_1.default(10, 24), new ECB_1.default(35, 25)), new ECBlocks_1.default(30, new ECB_1.default(19, 15), new ECB_1.default(35, 16))),
        new Version(33, Int32Array.from([6, 30, 58, 86, 114, 142]), new ECBlocks_1.default(30, new ECB_1.default(17, 115), new ECB_1.default(1, 116)), new ECBlocks_1.default(28, new ECB_1.default(14, 46), new ECB_1.default(21, 47)), new ECBlocks_1.default(30, new ECB_1.default(29, 24), new ECB_1.default(19, 25)), new ECBlocks_1.default(30, new ECB_1.default(11, 15), new ECB_1.default(46, 16))),
        new Version(34, Int32Array.from([6, 34, 62, 90, 118, 146]), new ECBlocks_1.default(30, new ECB_1.default(13, 115), new ECB_1.default(6, 116)), new ECBlocks_1.default(28, new ECB_1.default(14, 46), new ECB_1.default(23, 47)), new ECBlocks_1.default(30, new ECB_1.default(44, 24), new ECB_1.default(7, 25)), new ECBlocks_1.default(30, new ECB_1.default(59, 16), new ECB_1.default(1, 17))),
        new Version(35, Int32Array.from([6, 30, 54, 78, 102, 126, 150]), new ECBlocks_1.default(30, new ECB_1.default(12, 121), new ECB_1.default(7, 122)), new ECBlocks_1.default(28, new ECB_1.default(12, 47), new ECB_1.default(26, 48)), new ECBlocks_1.default(30, new ECB_1.default(39, 24), new ECB_1.default(14, 25)), new ECBlocks_1.default(30, new ECB_1.default(22, 15), new ECB_1.default(41, 16))),
        new Version(36, Int32Array.from([6, 24, 50, 76, 102, 128, 154]), new ECBlocks_1.default(30, new ECB_1.default(6, 121), new ECB_1.default(14, 122)), new ECBlocks_1.default(28, new ECB_1.default(6, 47), new ECB_1.default(34, 48)), new ECBlocks_1.default(30, new ECB_1.default(46, 24), new ECB_1.default(10, 25)), new ECBlocks_1.default(30, new ECB_1.default(2, 15), new ECB_1.default(64, 16))),
        new Version(37, Int32Array.from([6, 28, 54, 80, 106, 132, 158]), new ECBlocks_1.default(30, new ECB_1.default(17, 122), new ECB_1.default(4, 123)), new ECBlocks_1.default(28, new ECB_1.default(29, 46), new ECB_1.default(14, 47)), new ECBlocks_1.default(30, new ECB_1.default(49, 24), new ECB_1.default(10, 25)), new ECBlocks_1.default(30, new ECB_1.default(24, 15), new ECB_1.default(46, 16))),
        new Version(38, Int32Array.from([6, 32, 58, 84, 110, 136, 162]), new ECBlocks_1.default(30, new ECB_1.default(4, 122), new ECB_1.default(18, 123)), new ECBlocks_1.default(28, new ECB_1.default(13, 46), new ECB_1.default(32, 47)), new ECBlocks_1.default(30, new ECB_1.default(48, 24), new ECB_1.default(14, 25)), new ECBlocks_1.default(30, new ECB_1.default(42, 15), new ECB_1.default(32, 16))),
        new Version(39, Int32Array.from([6, 26, 54, 82, 110, 138, 166]), new ECBlocks_1.default(30, new ECB_1.default(20, 117), new ECB_1.default(4, 118)), new ECBlocks_1.default(28, new ECB_1.default(40, 47), new ECB_1.default(7, 48)), new ECBlocks_1.default(30, new ECB_1.default(43, 24), new ECB_1.default(22, 25)), new ECBlocks_1.default(30, new ECB_1.default(10, 15), new ECB_1.default(67, 16))),
        new Version(40, Int32Array.from([6, 30, 58, 86, 114, 142, 170]), new ECBlocks_1.default(30, new ECB_1.default(19, 118), new ECB_1.default(6, 119)), new ECBlocks_1.default(28, new ECB_1.default(18, 47), new ECB_1.default(31, 48)), new ECBlocks_1.default(30, new ECB_1.default(34, 24), new ECB_1.default(34, 25)), new ECBlocks_1.default(30, new ECB_1.default(20, 15), new ECB_1.default(61, 16)))
    ];
    return Version;
}());
exports.default = Version;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\Version.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\detector\\AlignmentPattern.js", {"../../ResultPoint":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\ResultPoint.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cqrcode%5Cdetector%5CAlignmentPattern.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2007 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
/*namespace com.google.zxing.qrcode.detector {*/
var ResultPoint_1 = require("../../ResultPoint");
/**
 * <p>Encapsulates an alignment pattern, which are the smaller square patterns found in
 * all but the simplest QR Codes.</p>
 *
 * @author Sean Owen
 */
var AlignmentPattern = /** @class */ (function (_super) {
    __extends(AlignmentPattern, _super);
    function AlignmentPattern(posX /*float*/, posY /*float*/, estimatedModuleSize /*float*/) {
        var _this = _super.call(this, posX, posY) || this;
        _this.estimatedModuleSize = estimatedModuleSize;
        return _this;
    }
    /**
     * <p>Determines if this alignment pattern "about equals" an alignment pattern at the stated
     * position and size -- meaning, it is at nearly the same center with nearly the same size.</p>
     */
    AlignmentPattern.prototype.aboutEquals = function (moduleSize /*float*/, i /*float*/, j /*float*/) {
        if (Math.abs(i - this.getY()) <= moduleSize && Math.abs(j - this.getX()) <= moduleSize) {
            var moduleSizeDiff = Math.abs(moduleSize - this.estimatedModuleSize);
            return moduleSizeDiff <= 1.0 || moduleSizeDiff <= this.estimatedModuleSize;
        }
        return false;
    };
    /**
     * Combines this object's current estimate of a finder pattern position and module size
     * with a new estimate. It returns a new {@code FinderPattern} containing an average of the two.
     */
    AlignmentPattern.prototype.combineEstimate = function (i /*float*/, j /*float*/, newModuleSize /*float*/) {
        var combinedX = (this.getX() + j) / 2.0;
        var combinedY = (this.getY() + i) / 2.0;
        var combinedModuleSize = (this.estimatedModuleSize + newModuleSize) / 2.0;
        return new AlignmentPattern(combinedX, combinedY, combinedModuleSize);
    };
    return AlignmentPattern;
}(ResultPoint_1.default));
exports.default = AlignmentPattern;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\qrcode\\detector\\AlignmentPattern.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\detector\\AlignmentPatternFinder.js", {"../../NotFoundException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\NotFoundException.js","./AlignmentPattern":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\detector\\AlignmentPattern.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cqrcode%5Cdetector%5CAlignmentPatternFinder.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2007 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
var AlignmentPattern_1 = require("./AlignmentPattern");
var NotFoundException_1 = require("../../NotFoundException");
/*import java.util.ArrayList;*/
/*import java.util.List;*/
/**
 * <p>This class attempts to find alignment patterns in a QR Code. Alignment patterns look like finder
 * patterns but are smaller and appear at regular intervals throughout the image.</p>
 *
 * <p>At the moment this only looks for the bottom-right alignment pattern.</p>
 *
 * <p>This is mostly a simplified copy of {@link FinderPatternFinder}. It is copied,
 * pasted and stripped down here for maximum performance but does unfortunately duplicate
 * some code.</p>
 *
 * <p>This class is thread-safe but not reentrant. Each thread must allocate its own object.</p>
 *
 * @author Sean Owen
 */
var AlignmentPatternFinder = /** @class */ (function () {
    /**
     * <p>Creates a finder that will look in a portion of the whole image.</p>
     *
     * @param image image to search
     * @param startX left column from which to start searching
     * @param startY top row from which to start searching
     * @param width width of region to search
     * @param height height of region to search
     * @param moduleSize estimated module size so far
     */
    function AlignmentPatternFinder(image, startX /*int*/, startY /*int*/, width /*int*/, height /*int*/, moduleSize /*float*/, resultPointCallback) {
        this.image = image;
        this.startX = startX;
        this.startY = startY;
        this.width = width;
        this.height = height;
        this.moduleSize = moduleSize;
        this.resultPointCallback = resultPointCallback;
        this.possibleCenters = []; // new Array<any>(5))
        // TYPESCRIPTPORT: array initialization without size as the length is checked below
        this.crossCheckStateCount = new Int32Array(3);
    }
    /**
     * <p>This method attempts to find the bottom-right alignment pattern in the image. It is a bit messy since
     * it's pretty performance-critical and so is written to be fast foremost.</p>
     *
     * @return {@link AlignmentPattern} if found
     * @throws NotFoundException if not found
     */
    AlignmentPatternFinder.prototype.find = function () {
        var startX = this.startX;
        var height = this.height;
        var width = this.width;
        var maxJ = startX + width;
        var middleI = this.startY + (height / 2);
        // We are looking for black/white/black modules in 1:1:1 ratio
        // this tracks the number of black/white/black modules seen so far
        var stateCount = new Int32Array(3);
        var image = this.image;
        for (var iGen = 0; iGen < height; iGen++) {
            // Search from middle outwards
            var i = middleI + ((iGen & 0x01) === 0 ? Math.floor((iGen + 1) / 2) : -Math.floor((iGen + 1) / 2));
            stateCount[0] = 0;
            stateCount[1] = 0;
            stateCount[2] = 0;
            var j = startX;
            // Burn off leading white pixels before anything else; if we start in the middle of
            // a white run, it doesn't make sense to count its length, since we don't know if the
            // white run continued to the left of the start point
            while (j < maxJ && !image.get(j, i)) {
                j++;
            }
            var currentState = 0;
            while (j < maxJ) {
                if (image.get(j, i)) {
                    // Black pixel
                    if (currentState === 1) { // Counting black pixels
                        stateCount[1]++;
                    }
                    else { // Counting white pixels
                        if (currentState === 2) { // A winner?
                            if (this.foundPatternCross(stateCount)) { // Yes
                                var confirmed = this.handlePossibleCenter(stateCount, i, j);
                                if (confirmed !== null) {
                                    return confirmed;
                                }
                            }
                            stateCount[0] = stateCount[2];
                            stateCount[1] = 1;
                            stateCount[2] = 0;
                            currentState = 1;
                        }
                        else {
                            stateCount[++currentState]++;
                        }
                    }
                }
                else { // White pixel
                    if (currentState === 1) { // Counting black pixels
                        currentState++;
                    }
                    stateCount[currentState]++;
                }
                j++;
            }
            if (this.foundPatternCross(stateCount)) {
                var confirmed = this.handlePossibleCenter(stateCount, i, maxJ);
                if (confirmed !== null) {
                    return confirmed;
                }
            }
        }
        // Hmm, nothing we saw was observed and confirmed twice. If we had
        // any guess at all, return it.
        if (this.possibleCenters.length !== 0) {
            return this.possibleCenters[0];
        }
        throw new NotFoundException_1.default();
    };
    /**
     * Given a count of black/white/black pixels just seen and an end position,
     * figures the location of the center of this black/white/black run.
     */
    AlignmentPatternFinder.centerFromEnd = function (stateCount, end /*int*/) {
        return (end - stateCount[2]) - stateCount[1] / 2.0;
    };
    /**
     * @param stateCount count of black/white/black pixels just read
     * @return true iff the proportions of the counts is close enough to the 1/1/1 ratios
     *         used by alignment patterns to be considered a match
     */
    AlignmentPatternFinder.prototype.foundPatternCross = function (stateCount) {
        var moduleSize = this.moduleSize;
        var maxVariance = moduleSize / 2.0;
        for (var i = 0; i < 3; i++) {
            if (Math.abs(moduleSize - stateCount[i]) >= maxVariance) {
                return false;
            }
        }
        return true;
    };
    /**
     * <p>After a horizontal scan finds a potential alignment pattern, this method
     * "cross-checks" by scanning down vertically through the center of the possible
     * alignment pattern to see if the same proportion is detected.</p>
     *
     * @param startI row where an alignment pattern was detected
     * @param centerJ center of the section that appears to cross an alignment pattern
     * @param maxCount maximum reasonable number of modules that should be
     * observed in any reading state, based on the results of the horizontal scan
     * @return vertical center of alignment pattern, or {@link Float#NaN} if not found
     */
    AlignmentPatternFinder.prototype.crossCheckVertical = function (startI /*int*/, centerJ /*int*/, maxCount /*int*/, originalStateCountTotal /*int*/) {
        var image = this.image;
        var maxI = image.getHeight();
        var stateCount = this.crossCheckStateCount;
        stateCount[0] = 0;
        stateCount[1] = 0;
        stateCount[2] = 0;
        // Start counting up from center
        var i = startI;
        while (i >= 0 && image.get(centerJ, i) && stateCount[1] <= maxCount) {
            stateCount[1]++;
            i--;
        }
        // If already too many modules in this state or ran off the edge:
        if (i < 0 || stateCount[1] > maxCount) {
            return NaN;
        }
        while (i >= 0 && !image.get(centerJ, i) && stateCount[0] <= maxCount) {
            stateCount[0]++;
            i--;
        }
        if (stateCount[0] > maxCount) {
            return NaN;
        }
        // Now also count down from center
        i = startI + 1;
        while (i < maxI && image.get(centerJ, i) && stateCount[1] <= maxCount) {
            stateCount[1]++;
            i++;
        }
        if (i === maxI || stateCount[1] > maxCount) {
            return NaN;
        }
        while (i < maxI && !image.get(centerJ, i) && stateCount[2] <= maxCount) {
            stateCount[2]++;
            i++;
        }
        if (stateCount[2] > maxCount) {
            return NaN;
        }
        var stateCountTotal = stateCount[0] + stateCount[1] + stateCount[2];
        if (5 * Math.abs(stateCountTotal - originalStateCountTotal) >= 2 * originalStateCountTotal) {
            return NaN;
        }
        return this.foundPatternCross(stateCount) ? AlignmentPatternFinder.centerFromEnd(stateCount, i) : NaN;
    };
    /**
     * <p>This is called when a horizontal scan finds a possible alignment pattern. It will
     * cross check with a vertical scan, and if successful, will see if this pattern had been
     * found on a previous horizontal scan. If so, we consider it confirmed and conclude we have
     * found the alignment pattern.</p>
     *
     * @param stateCount reading state module counts from horizontal scan
     * @param i row where alignment pattern may be found
     * @param j end of possible alignment pattern in row
     * @return {@link AlignmentPattern} if we have found the same pattern twice, or null if not
     */
    AlignmentPatternFinder.prototype.handlePossibleCenter = function (stateCount, i /*int*/, j /*int*/) {
        var e_1, _a;
        var stateCountTotal = stateCount[0] + stateCount[1] + stateCount[2];
        var centerJ = AlignmentPatternFinder.centerFromEnd(stateCount, j);
        var centerI = this.crossCheckVertical(i, /*(int) */ centerJ, 2 * stateCount[1], stateCountTotal);
        if (!isNaN(centerI)) {
            var estimatedModuleSize = (stateCount[0] + stateCount[1] + stateCount[2]) / 3.0;
            try {
                for (var _b = __values(this.possibleCenters), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var center = _c.value;
                    // Look for about the same center and module size:
                    if (center.aboutEquals(estimatedModuleSize, centerI, centerJ)) {
                        return center.combineEstimate(centerI, centerJ, estimatedModuleSize);
                    }
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_1) throw e_1.error; }
            }
            // Hadn't found this before; save it
            var point = new AlignmentPattern_1.default(centerJ, centerI, estimatedModuleSize);
            this.possibleCenters.push(point);
            if (this.resultPointCallback !== null && this.resultPointCallback !== undefined) {
                this.resultPointCallback.foundPossibleResultPoint(point);
            }
        }
        return null;
    };
    return AlignmentPatternFinder;
}());
exports.default = AlignmentPatternFinder;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\qrcode\\detector\\AlignmentPatternFinder.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\detector\\Detector.js", {"../../DecodeHintType":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\DecodeHintType.js","../../NotFoundException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\NotFoundException.js","../../ResultPoint":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\ResultPoint.js","../../common/DetectorResult":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\DetectorResult.js","../../common/GridSamplerInstance":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\GridSamplerInstance.js","../../common/PerspectiveTransform":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\PerspectiveTransform.js","../../common/detector/MathUtils":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\detector\\MathUtils.js","../decoder/Version":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\Version.js","./AlignmentPatternFinder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\detector\\AlignmentPatternFinder.js","./FinderPatternFinder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\detector\\FinderPatternFinder.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cqrcode%5Cdetector%5CDetector.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2007 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
var MathUtils_1 = require("../../common/detector/MathUtils");
var DetectorResult_1 = require("../../common/DetectorResult");
// import GridSampler from '../../common/GridSampler';
var GridSamplerInstance_1 = require("../../common/GridSamplerInstance");
var PerspectiveTransform_1 = require("../../common/PerspectiveTransform");
var DecodeHintType_1 = require("../../DecodeHintType");
var NotFoundException_1 = require("../../NotFoundException");
var ResultPoint_1 = require("../../ResultPoint");
var Version_1 = require("../decoder/Version");
var AlignmentPatternFinder_1 = require("./AlignmentPatternFinder");
var FinderPatternFinder_1 = require("./FinderPatternFinder");
/*import java.util.Map;*/
/**
 * <p>Encapsulates logic that can detect a QR Code in an image, even if the QR Code
 * is rotated or skewed, or partially obscured.</p>
 *
 * @author Sean Owen
 */
var Detector = /** @class */ (function () {
    function Detector(image) {
        this.image = image;
    }
    Detector.prototype.getImage = function () {
        return this.image;
    };
    Detector.prototype.getResultPointCallback = function () {
        return this.resultPointCallback;
    };
    /**
     * <p>Detects a QR Code in an image.</p>
     *
     * @return {@link DetectorResult} encapsulating results of detecting a QR Code
     * @throws NotFoundException if QR Code cannot be found
     * @throws FormatException if a QR Code cannot be decoded
     */
    // public detect(): DetectorResult /*throws NotFoundException, FormatException*/ {
    //   return detect(null)
    // }
    /**
     * <p>Detects a QR Code in an image.</p>
     *
     * @param hints optional hints to detector
     * @return {@link DetectorResult} encapsulating results of detecting a QR Code
     * @throws NotFoundException if QR Code cannot be found
     * @throws FormatException if a QR Code cannot be decoded
     */
    Detector.prototype.detect = function (hints) {
        this.resultPointCallback = (hints === null || hints === undefined) ? null :
            /*(ResultPointCallback) */ hints.get(DecodeHintType_1.default.NEED_RESULT_POINT_CALLBACK);
        var finder = new FinderPatternFinder_1.default(this.image, this.resultPointCallback);
        var info = finder.find(hints);
        return this.processFinderPatternInfo(info);
    };
    Detector.prototype.processFinderPatternInfo = function (info) {
        var topLeft = info.getTopLeft();
        var topRight = info.getTopRight();
        var bottomLeft = info.getBottomLeft();
        var moduleSize = this.calculateModuleSize(topLeft, topRight, bottomLeft);
        if (moduleSize < 1.0) {
            throw new NotFoundException_1.default('No pattern found in proccess finder.');
        }
        var dimension = Detector.computeDimension(topLeft, topRight, bottomLeft, moduleSize);
        var provisionalVersion = Version_1.default.getProvisionalVersionForDimension(dimension);
        var modulesBetweenFPCenters = provisionalVersion.getDimensionForVersion() - 7;
        var alignmentPattern = null;
        // Anything above version 1 has an alignment pattern
        if (provisionalVersion.getAlignmentPatternCenters().length > 0) {
            // Guess where a "bottom right" finder pattern would have been
            var bottomRightX = topRight.getX() - topLeft.getX() + bottomLeft.getX();
            var bottomRightY = topRight.getY() - topLeft.getY() + bottomLeft.getY();
            // Estimate that alignment pattern is closer by 3 modules
            // from "bottom right" to known top left location
            var correctionToTopLeft = 1.0 - 3.0 / modulesBetweenFPCenters;
            var estAlignmentX = /*(int) */ Math.floor(topLeft.getX() + correctionToTopLeft * (bottomRightX - topLeft.getX()));
            var estAlignmentY = /*(int) */ Math.floor(topLeft.getY() + correctionToTopLeft * (bottomRightY - topLeft.getY()));
            // Kind of arbitrary -- expand search radius before giving up
            for (var i = 4; i <= 16; i <<= 1) {
                try {
                    alignmentPattern = this.findAlignmentInRegion(moduleSize, estAlignmentX, estAlignmentY, i);
                    break;
                }
                catch (re /*NotFoundException*/) {
                    if (!(re instanceof NotFoundException_1.default)) {
                        throw re;
                    }
                    // try next round
                }
            }
            // If we didn't find alignment pattern... well try anyway without it
        }
        var transform = Detector.createTransform(topLeft, topRight, bottomLeft, alignmentPattern, dimension);
        var bits = Detector.sampleGrid(this.image, transform, dimension);
        var points;
        if (alignmentPattern === null) {
            points = [bottomLeft, topLeft, topRight];
        }
        else {
            points = [bottomLeft, topLeft, topRight, alignmentPattern];
        }
        return new DetectorResult_1.default(bits, points);
    };
    Detector.createTransform = function (topLeft, topRight, bottomLeft, alignmentPattern, dimension /*int*/) {
        var dimMinusThree = dimension - 3.5;
        var bottomRightX; /*float*/
        var bottomRightY; /*float*/
        var sourceBottomRightX; /*float*/
        var sourceBottomRightY; /*float*/
        if (alignmentPattern !== null) {
            bottomRightX = alignmentPattern.getX();
            bottomRightY = alignmentPattern.getY();
            sourceBottomRightX = dimMinusThree - 3.0;
            sourceBottomRightY = sourceBottomRightX;
        }
        else {
            // Don't have an alignment pattern, just make up the bottom-right point
            bottomRightX = (topRight.getX() - topLeft.getX()) + bottomLeft.getX();
            bottomRightY = (topRight.getY() - topLeft.getY()) + bottomLeft.getY();
            sourceBottomRightX = dimMinusThree;
            sourceBottomRightY = dimMinusThree;
        }
        return PerspectiveTransform_1.default.quadrilateralToQuadrilateral(3.5, 3.5, dimMinusThree, 3.5, sourceBottomRightX, sourceBottomRightY, 3.5, dimMinusThree, topLeft.getX(), topLeft.getY(), topRight.getX(), topRight.getY(), bottomRightX, bottomRightY, bottomLeft.getX(), bottomLeft.getY());
    };
    Detector.sampleGrid = function (image, transform, dimension /*int*/) {
        var sampler = GridSamplerInstance_1.default.getInstance();
        return sampler.sampleGridWithTransform(image, dimension, dimension, transform);
    };
    /**
     * <p>Computes the dimension (number of modules on a size) of the QR Code based on the position
     * of the finder patterns and estimated module size.</p>
     */
    Detector.computeDimension = function (topLeft, topRight, bottomLeft, moduleSize /*float*/) {
        var tltrCentersDimension = MathUtils_1.default.round(ResultPoint_1.default.distance(topLeft, topRight) / moduleSize);
        var tlblCentersDimension = MathUtils_1.default.round(ResultPoint_1.default.distance(topLeft, bottomLeft) / moduleSize);
        var dimension = Math.floor((tltrCentersDimension + tlblCentersDimension) / 2) + 7;
        switch (dimension & 0x03) { // mod 4
            case 0:
                dimension++;
                break;
            // 1? do nothing
            case 2:
                dimension--;
                break;
            case 3:
                throw new NotFoundException_1.default('Dimensions could be not found.');
        }
        return dimension;
    };
    /**
     * <p>Computes an average estimated module size based on estimated derived from the positions
     * of the three finder patterns.</p>
     *
     * @param topLeft detected top-left finder pattern center
     * @param topRight detected top-right finder pattern center
     * @param bottomLeft detected bottom-left finder pattern center
     * @return estimated module size
     */
    Detector.prototype.calculateModuleSize = function (topLeft, topRight, bottomLeft) {
        // Take the average
        return (this.calculateModuleSizeOneWay(topLeft, topRight) +
            this.calculateModuleSizeOneWay(topLeft, bottomLeft)) / 2.0;
    };
    /**
     * <p>Estimates module size based on two finder patterns -- it uses
     * {@link #sizeOfBlackWhiteBlackRunBothWays(int, int, int, int)} to figure the
     * width of each, measuring along the axis between their centers.</p>
     */
    Detector.prototype.calculateModuleSizeOneWay = function (pattern, otherPattern) {
        var moduleSizeEst1 = this.sizeOfBlackWhiteBlackRunBothWays(/*(int) */ Math.floor(pattern.getX()), 
        /*(int) */ Math.floor(pattern.getY()), 
        /*(int) */ Math.floor(otherPattern.getX()), 
        /*(int) */ Math.floor(otherPattern.getY()));
        var moduleSizeEst2 = this.sizeOfBlackWhiteBlackRunBothWays(/*(int) */ Math.floor(otherPattern.getX()), 
        /*(int) */ Math.floor(otherPattern.getY()), 
        /*(int) */ Math.floor(pattern.getX()), 
        /*(int) */ Math.floor(pattern.getY()));
        if (isNaN(moduleSizeEst1)) {
            return moduleSizeEst2 / 7.0;
        }
        if (isNaN(moduleSizeEst2)) {
            return moduleSizeEst1 / 7.0;
        }
        // Average them, and divide by 7 since we've counted the width of 3 black modules,
        // and 1 white and 1 black module on either side. Ergo, divide sum by 14.
        return (moduleSizeEst1 + moduleSizeEst2) / 14.0;
    };
    /**
     * See {@link #sizeOfBlackWhiteBlackRun(int, int, int, int)}; computes the total width of
     * a finder pattern by looking for a black-white-black run from the center in the direction
     * of another point (another finder pattern center), and in the opposite direction too.
     */
    Detector.prototype.sizeOfBlackWhiteBlackRunBothWays = function (fromX /*int*/, fromY /*int*/, toX /*int*/, toY /*int*/) {
        var result = this.sizeOfBlackWhiteBlackRun(fromX, fromY, toX, toY);
        // Now count other way -- don't run off image though of course
        var scale = 1.0;
        var otherToX = fromX - (toX - fromX);
        if (otherToX < 0) {
            scale = fromX / /*(float) */ (fromX - otherToX);
            otherToX = 0;
        }
        else if (otherToX >= this.image.getWidth()) {
            scale = (this.image.getWidth() - 1 - fromX) / /*(float) */ (otherToX - fromX);
            otherToX = this.image.getWidth() - 1;
        }
        var otherToY = /*(int) */ Math.floor(fromY - (toY - fromY) * scale);
        scale = 1.0;
        if (otherToY < 0) {
            scale = fromY / /*(float) */ (fromY - otherToY);
            otherToY = 0;
        }
        else if (otherToY >= this.image.getHeight()) {
            scale = (this.image.getHeight() - 1 - fromY) / /*(float) */ (otherToY - fromY);
            otherToY = this.image.getHeight() - 1;
        }
        otherToX = /*(int) */ Math.floor(fromX + (otherToX - fromX) * scale);
        result += this.sizeOfBlackWhiteBlackRun(fromX, fromY, otherToX, otherToY);
        // Middle pixel is double-counted this way; subtract 1
        return result - 1.0;
    };
    /**
     * <p>This method traces a line from a point in the image, in the direction towards another point.
     * It begins in a black region, and keeps going until it finds white, then black, then white again.
     * It reports the distance from the start to this point.</p>
     *
     * <p>This is used when figuring out how wide a finder pattern is, when the finder pattern
     * may be skewed or rotated.</p>
     */
    Detector.prototype.sizeOfBlackWhiteBlackRun = function (fromX /*int*/, fromY /*int*/, toX /*int*/, toY /*int*/) {
        // Mild variant of Bresenham's algorithm
        // see http://en.wikipedia.org/wiki/Bresenham's_line_algorithm
        var steep = Math.abs(toY - fromY) > Math.abs(toX - fromX);
        if (steep) {
            var temp = fromX;
            fromX = fromY;
            fromY = temp;
            temp = toX;
            toX = toY;
            toY = temp;
        }
        var dx = Math.abs(toX - fromX);
        var dy = Math.abs(toY - fromY);
        var error = -dx / 2;
        var xstep = fromX < toX ? 1 : -1;
        var ystep = fromY < toY ? 1 : -1;
        // In black pixels, looking for white, first or second time.
        var state = 0;
        // Loop up until x == toX, but not beyond
        var xLimit = toX + xstep;
        for (var x = fromX, y = fromY; x !== xLimit; x += xstep) {
            var realX = steep ? y : x;
            var realY = steep ? x : y;
            // Does current pixel mean we have moved white to black or vice versa?
            // Scanning black in state 0,2 and white in state 1, so if we find the wrong
            // color, advance to next state or end if we are in state 2 already
            if ((state === 1) === this.image.get(realX, realY)) {
                if (state === 2) {
                    return MathUtils_1.default.distance(x, y, fromX, fromY);
                }
                state++;
            }
            error += dy;
            if (error > 0) {
                if (y === toY) {
                    break;
                }
                y += ystep;
                error -= dx;
            }
        }
        // Found black-white-black; give the benefit of the doubt that the next pixel outside the image
        // is "white" so this last point at (toX+xStep,toY) is the right ending. This is really a
        // small approximation; (toX+xStep,toY+yStep) might be really correct. Ignore this.
        if (state === 2) {
            return MathUtils_1.default.distance(toX + xstep, toY, fromX, fromY);
        }
        // else we didn't find even black-white-black; no estimate is really possible
        return NaN;
    };
    /**
     * <p>Attempts to locate an alignment pattern in a limited region of the image, which is
     * guessed to contain it. This method uses {@link AlignmentPattern}.</p>
     *
     * @param overallEstModuleSize estimated module size so far
     * @param estAlignmentX x coordinate of center of area probably containing alignment pattern
     * @param estAlignmentY y coordinate of above
     * @param allowanceFactor number of pixels in all directions to search from the center
     * @return {@link AlignmentPattern} if found, or null otherwise
     * @throws NotFoundException if an unexpected error occurs during detection
     */
    Detector.prototype.findAlignmentInRegion = function (overallEstModuleSize /*float*/, estAlignmentX /*int*/, estAlignmentY /*int*/, allowanceFactor /*float*/) {
        // Look for an alignment pattern (3 modules in size) around where it
        // should be
        var allowance = /*(int) */ Math.floor(allowanceFactor * overallEstModuleSize);
        var alignmentAreaLeftX = Math.max(0, estAlignmentX - allowance);
        var alignmentAreaRightX = Math.min(this.image.getWidth() - 1, estAlignmentX + allowance);
        if (alignmentAreaRightX - alignmentAreaLeftX < overallEstModuleSize * 3) {
            throw new NotFoundException_1.default('Alignment top exceeds estimated module size.');
        }
        var alignmentAreaTopY = Math.max(0, estAlignmentY - allowance);
        var alignmentAreaBottomY = Math.min(this.image.getHeight() - 1, estAlignmentY + allowance);
        if (alignmentAreaBottomY - alignmentAreaTopY < overallEstModuleSize * 3) {
            throw new NotFoundException_1.default('Alignment bottom exceeds estimated module size.');
        }
        var alignmentFinder = new AlignmentPatternFinder_1.default(this.image, alignmentAreaLeftX, alignmentAreaTopY, alignmentAreaRightX - alignmentAreaLeftX, alignmentAreaBottomY - alignmentAreaTopY, overallEstModuleSize, this.resultPointCallback);
        return alignmentFinder.find();
    };
    return Detector;
}());
exports.default = Detector;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\qrcode\\detector\\Detector.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\detector\\FinderPattern.js", {"../../ResultPoint":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\ResultPoint.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cqrcode%5Cdetector%5CFinderPattern.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2007 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
/*namespace com.google.zxing.qrcode.detector {*/
var ResultPoint_1 = require("../../ResultPoint");
/**
 * <p>Encapsulates a finder pattern, which are the three square patterns found in
 * the corners of QR Codes. It also encapsulates a count of similar finder patterns,
 * as a convenience to the finder's bookkeeping.</p>
 *
 * @author Sean Owen
 */
var FinderPattern = /** @class */ (function (_super) {
    __extends(FinderPattern, _super);
    // FinderPattern(posX: number/*float*/, posY: number/*float*/, estimatedModuleSize: number/*float*/) {
    //   this(posX, posY, estimatedModuleSize, 1)
    // }
    function FinderPattern(posX /*float*/, posY /*float*/, estimatedModuleSize /*float*/, count /*int*/) {
        var _this = _super.call(this, posX, posY) || this;
        _this.estimatedModuleSize = estimatedModuleSize;
        _this.count = count;
        if (undefined === count) {
            _this.count = 1;
        }
        return _this;
    }
    FinderPattern.prototype.getEstimatedModuleSize = function () {
        return this.estimatedModuleSize;
    };
    FinderPattern.prototype.getCount = function () {
        return this.count;
    };
    /*
    void incrementCount() {
      this.count++
    }
     */
    /**
     * <p>Determines if this finder pattern "about equals" a finder pattern at the stated
     * position and size -- meaning, it is at nearly the same center with nearly the same size.</p>
     */
    FinderPattern.prototype.aboutEquals = function (moduleSize /*float*/, i /*float*/, j /*float*/) {
        if (Math.abs(i - this.getY()) <= moduleSize && Math.abs(j - this.getX()) <= moduleSize) {
            var moduleSizeDiff = Math.abs(moduleSize - this.estimatedModuleSize);
            return moduleSizeDiff <= 1.0 || moduleSizeDiff <= this.estimatedModuleSize;
        }
        return false;
    };
    /**
     * Combines this object's current estimate of a finder pattern position and module size
     * with a new estimate. It returns a new {@code FinderPattern} containing a weighted average
     * based on count.
     */
    FinderPattern.prototype.combineEstimate = function (i /*float*/, j /*float*/, newModuleSize /*float*/) {
        var combinedCount = this.count + 1;
        var combinedX = (this.count * this.getX() + j) / combinedCount;
        var combinedY = (this.count * this.getY() + i) / combinedCount;
        var combinedModuleSize = (this.count * this.estimatedModuleSize + newModuleSize) / combinedCount;
        return new FinderPattern(combinedX, combinedY, combinedModuleSize, combinedCount);
    };
    return FinderPattern;
}(ResultPoint_1.default));
exports.default = FinderPattern;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\qrcode\\detector\\FinderPattern.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\detector\\FinderPatternFinder.js", {"../../DecodeHintType":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\DecodeHintType.js","../../NotFoundException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\NotFoundException.js","../../ResultPoint":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\ResultPoint.js","./FinderPattern":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\detector\\FinderPattern.js","./FinderPatternInfo":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\detector\\FinderPatternInfo.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cqrcode%5Cdetector%5CFinderPatternFinder.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2007 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
/*namespace com.google.zxing.qrcode.detector {*/
var DecodeHintType_1 = require("../../DecodeHintType");
var ResultPoint_1 = require("../../ResultPoint");
var FinderPattern_1 = require("./FinderPattern");
var FinderPatternInfo_1 = require("./FinderPatternInfo");
var NotFoundException_1 = require("../../NotFoundException");
/*import java.io.Serializable;*/
/*import java.util.ArrayList;*/
/*import java.util.Collections;*/
/*import java.util.Comparator;*/
/*import java.util.List;*/
/*import java.util.Map;*/
/**
 * <p>This class attempts to find finder patterns in a QR Code. Finder patterns are the square
 * markers at three corners of a QR Code.</p>
 *
 * <p>This class is thread-safe but not reentrant. Each thread must allocate its own object.
 *
 * @author Sean Owen
 */
var FinderPatternFinder = /** @class */ (function () {
    /**
     * <p>Creates a finder that will search the image for three finder patterns.</p>
     *
     * @param image image to search
     */
    // public constructor(image: BitMatrix) {
    //   this(image, null)
    // }
    function FinderPatternFinder(image, resultPointCallback) {
        this.image = image;
        this.resultPointCallback = resultPointCallback;
        this.possibleCenters = [];
        this.crossCheckStateCount = new Int32Array(5);
        this.resultPointCallback = resultPointCallback;
    }
    FinderPatternFinder.prototype.getImage = function () {
        return this.image;
    };
    FinderPatternFinder.prototype.getPossibleCenters = function () {
        return this.possibleCenters;
    };
    FinderPatternFinder.prototype.find = function (hints) {
        var tryHarder = (hints !== null && hints !== undefined) && undefined !== hints.get(DecodeHintType_1.default.TRY_HARDER);
        var pureBarcode = (hints !== null && hints !== undefined) && undefined !== hints.get(DecodeHintType_1.default.PURE_BARCODE);
        var image = this.image;
        var maxI = image.getHeight();
        var maxJ = image.getWidth();
        // We are looking for black/white/black/white/black modules in
        // 1:1:3:1:1 ratio; this tracks the number of such modules seen so far
        // Let's assume that the maximum version QR Code we support takes up 1/4 the height of the
        // image, and then account for the center being 3 modules in size. This gives the smallest
        // number of pixels the center could be, so skip this often. When trying harder, look for all
        // QR versions regardless of how dense they are.
        var iSkip = Math.floor((3 * maxI) / (4 * FinderPatternFinder.MAX_MODULES));
        if (iSkip < FinderPatternFinder.MIN_SKIP || tryHarder) {
            iSkip = FinderPatternFinder.MIN_SKIP;
        }
        var done = false;
        var stateCount = new Int32Array(5);
        for (var i = iSkip - 1; i < maxI && !done; i += iSkip) {
            // Get a row of black/white values
            stateCount[0] = 0;
            stateCount[1] = 0;
            stateCount[2] = 0;
            stateCount[3] = 0;
            stateCount[4] = 0;
            var currentState = 0;
            for (var j = 0; j < maxJ; j++) {
                if (image.get(j, i)) {
                    // Black pixel
                    if ((currentState & 1) === 1) { // Counting white pixels
                        currentState++;
                    }
                    stateCount[currentState]++;
                }
                else { // White pixel
                    if ((currentState & 1) === 0) { // Counting black pixels
                        if (currentState === 4) { // A winner?
                            if (FinderPatternFinder.foundPatternCross(stateCount)) { // Yes
                                var confirmed = this.handlePossibleCenter(stateCount, i, j, pureBarcode);
                                if (confirmed === true) {
                                    // Start examining every other line. Checking each line turned out to be too
                                    // expensive and didn't improve performance.
                                    iSkip = 2;
                                    if (this.hasSkipped === true) {
                                        done = this.haveMultiplyConfirmedCenters();
                                    }
                                    else {
                                        var rowSkip = this.findRowSkip();
                                        if (rowSkip > stateCount[2]) {
                                            // Skip rows between row of lower confirmed center
                                            // and top of presumed third confirmed center
                                            // but back up a bit to get a full chance of detecting
                                            // it, entire width of center of finder pattern
                                            // Skip by rowSkip, but back off by stateCount[2] (size of last center
                                            // of pattern we saw) to be conservative, and also back off by iSkip which
                                            // is about to be re-added
                                            i += rowSkip - stateCount[2] - iSkip;
                                            j = maxJ - 1;
                                        }
                                    }
                                }
                                else {
                                    stateCount[0] = stateCount[2];
                                    stateCount[1] = stateCount[3];
                                    stateCount[2] = stateCount[4];
                                    stateCount[3] = 1;
                                    stateCount[4] = 0;
                                    currentState = 3;
                                    continue;
                                }
                                // Clear state to start looking again
                                currentState = 0;
                                stateCount[0] = 0;
                                stateCount[1] = 0;
                                stateCount[2] = 0;
                                stateCount[3] = 0;
                                stateCount[4] = 0;
                            }
                            else { // No, shift counts back by two
                                stateCount[0] = stateCount[2];
                                stateCount[1] = stateCount[3];
                                stateCount[2] = stateCount[4];
                                stateCount[3] = 1;
                                stateCount[4] = 0;
                                currentState = 3;
                            }
                        }
                        else {
                            stateCount[++currentState]++;
                        }
                    }
                    else { // Counting white pixels
                        stateCount[currentState]++;
                    }
                }
            }
            if (FinderPatternFinder.foundPatternCross(stateCount)) {
                var confirmed = this.handlePossibleCenter(stateCount, i, maxJ, pureBarcode);
                if (confirmed === true) {
                    iSkip = stateCount[0];
                    if (this.hasSkipped) {
                        // Found a third one
                        done = this.haveMultiplyConfirmedCenters();
                    }
                }
            }
        }
        var patternInfo = this.selectBestPatterns();
        ResultPoint_1.default.orderBestPatterns(patternInfo);
        return new FinderPatternInfo_1.default(patternInfo);
    };
    /**
     * Given a count of black/white/black/white/black pixels just seen and an end position,
     * figures the location of the center of this run.
     */
    FinderPatternFinder.centerFromEnd = function (stateCount, end /*int*/) {
        return (end - stateCount[4] - stateCount[3]) - stateCount[2] / 2.0;
    };
    /**
     * @param stateCount count of black/white/black/white/black pixels just read
     * @return true iff the proportions of the counts is close enough to the 1/1/3/1/1 ratios
     *         used by finder patterns to be considered a match
     */
    FinderPatternFinder.foundPatternCross = function (stateCount) {
        var totalModuleSize = 0;
        for (var i = 0; i < 5; i++) {
            var count = stateCount[i];
            if (count === 0) {
                return false;
            }
            totalModuleSize += count;
        }
        if (totalModuleSize < 7) {
            return false;
        }
        var moduleSize = totalModuleSize / 7.0;
        var maxVariance = moduleSize / 2.0;
        // Allow less than 50% variance from 1-1-3-1-1 proportions
        return Math.abs(moduleSize - stateCount[0]) < maxVariance &&
            Math.abs(moduleSize - stateCount[1]) < maxVariance &&
            Math.abs(3.0 * moduleSize - stateCount[2]) < 3 * maxVariance &&
            Math.abs(moduleSize - stateCount[3]) < maxVariance &&
            Math.abs(moduleSize - stateCount[4]) < maxVariance;
    };
    FinderPatternFinder.prototype.getCrossCheckStateCount = function () {
        var crossCheckStateCount = this.crossCheckStateCount;
        crossCheckStateCount[0] = 0;
        crossCheckStateCount[1] = 0;
        crossCheckStateCount[2] = 0;
        crossCheckStateCount[3] = 0;
        crossCheckStateCount[4] = 0;
        return crossCheckStateCount;
    };
    /**
     * After a vertical and horizontal scan finds a potential finder pattern, this method
     * "cross-cross-cross-checks" by scanning down diagonally through the center of the possible
     * finder pattern to see if the same proportion is detected.
     *
     * @param startI row where a finder pattern was detected
     * @param centerJ center of the section that appears to cross a finder pattern
     * @param maxCount maximum reasonable number of modules that should be
     *  observed in any reading state, based on the results of the horizontal scan
     * @param originalStateCountTotal The original state count total.
     * @return true if proportions are withing expected limits
     */
    FinderPatternFinder.prototype.crossCheckDiagonal = function (startI /*int*/, centerJ /*int*/, maxCount /*int*/, originalStateCountTotal /*int*/) {
        var stateCount = this.getCrossCheckStateCount();
        // Start counting up, left from center finding black center mass
        var i = 0;
        var image = this.image;
        while (startI >= i && centerJ >= i && image.get(centerJ - i, startI - i)) {
            stateCount[2]++;
            i++;
        }
        if (startI < i || centerJ < i) {
            return false;
        }
        // Continue up, left finding white space
        while (startI >= i && centerJ >= i && !image.get(centerJ - i, startI - i) &&
            stateCount[1] <= maxCount) {
            stateCount[1]++;
            i++;
        }
        // If already too many modules in this state or ran off the edge:
        if (startI < i || centerJ < i || stateCount[1] > maxCount) {
            return false;
        }
        // Continue up, left finding black border
        while (startI >= i && centerJ >= i && image.get(centerJ - i, startI - i) &&
            stateCount[0] <= maxCount) {
            stateCount[0]++;
            i++;
        }
        if (stateCount[0] > maxCount) {
            return false;
        }
        var maxI = image.getHeight();
        var maxJ = image.getWidth();
        // Now also count down, right from center
        i = 1;
        while (startI + i < maxI && centerJ + i < maxJ && image.get(centerJ + i, startI + i)) {
            stateCount[2]++;
            i++;
        }
        // Ran off the edge?
        if (startI + i >= maxI || centerJ + i >= maxJ) {
            return false;
        }
        while (startI + i < maxI && centerJ + i < maxJ && !image.get(centerJ + i, startI + i) &&
            stateCount[3] < maxCount) {
            stateCount[3]++;
            i++;
        }
        if (startI + i >= maxI || centerJ + i >= maxJ || stateCount[3] >= maxCount) {
            return false;
        }
        while (startI + i < maxI && centerJ + i < maxJ && image.get(centerJ + i, startI + i) &&
            stateCount[4] < maxCount) {
            stateCount[4]++;
            i++;
        }
        if (stateCount[4] >= maxCount) {
            return false;
        }
        // If we found a finder-pattern-like section, but its size is more than 100% different than
        // the original, assume it's a false positive
        var stateCountTotal = stateCount[0] + stateCount[1] + stateCount[2] + stateCount[3] + stateCount[4];
        return Math.abs(stateCountTotal - originalStateCountTotal) < 2 * originalStateCountTotal &&
            FinderPatternFinder.foundPatternCross(stateCount);
    };
    /**
     * <p>After a horizontal scan finds a potential finder pattern, this method
     * "cross-checks" by scanning down vertically through the center of the possible
     * finder pattern to see if the same proportion is detected.</p>
     *
     * @param startI row where a finder pattern was detected
     * @param centerJ center of the section that appears to cross a finder pattern
     * @param maxCount maximum reasonable number of modules that should be
     * observed in any reading state, based on the results of the horizontal scan
     * @return vertical center of finder pattern, or {@link Float#NaN} if not found
     */
    FinderPatternFinder.prototype.crossCheckVertical = function (startI /*int*/, centerJ /*int*/, maxCount /*int*/, originalStateCountTotal /*int*/) {
        var image = this.image;
        var maxI = image.getHeight();
        var stateCount = this.getCrossCheckStateCount();
        // Start counting up from center
        var i = startI;
        while (i >= 0 && image.get(centerJ, i)) {
            stateCount[2]++;
            i--;
        }
        if (i < 0) {
            return NaN;
        }
        while (i >= 0 && !image.get(centerJ, i) && stateCount[1] <= maxCount) {
            stateCount[1]++;
            i--;
        }
        // If already too many modules in this state or ran off the edge:
        if (i < 0 || stateCount[1] > maxCount) {
            return NaN;
        }
        while (i >= 0 && image.get(centerJ, i) && stateCount[0] <= maxCount) {
            stateCount[0]++;
            i--;
        }
        if (stateCount[0] > maxCount) {
            return NaN;
        }
        // Now also count down from center
        i = startI + 1;
        while (i < maxI && image.get(centerJ, i)) {
            stateCount[2]++;
            i++;
        }
        if (i === maxI) {
            return NaN;
        }
        while (i < maxI && !image.get(centerJ, i) && stateCount[3] < maxCount) {
            stateCount[3]++;
            i++;
        }
        if (i === maxI || stateCount[3] >= maxCount) {
            return NaN;
        }
        while (i < maxI && image.get(centerJ, i) && stateCount[4] < maxCount) {
            stateCount[4]++;
            i++;
        }
        if (stateCount[4] >= maxCount) {
            return NaN;
        }
        // If we found a finder-pattern-like section, but its size is more than 40% different than
        // the original, assume it's a false positive
        var stateCountTotal = stateCount[0] + stateCount[1] + stateCount[2] + stateCount[3] +
            stateCount[4];
        if (5 * Math.abs(stateCountTotal - originalStateCountTotal) >= 2 * originalStateCountTotal) {
            return NaN;
        }
        return FinderPatternFinder.foundPatternCross(stateCount) ? FinderPatternFinder.centerFromEnd(stateCount, i) : NaN;
    };
    /**
     * <p>Like {@link #crossCheckVertical(int, int, int, int)}, and in fact is basically identical,
     * except it reads horizontally instead of vertically. This is used to cross-cross
     * check a vertical cross check and locate the real center of the alignment pattern.</p>
     */
    FinderPatternFinder.prototype.crossCheckHorizontal = function (startJ /*int*/, centerI /*int*/, maxCount /*int*/, originalStateCountTotal /*int*/) {
        var image = this.image;
        var maxJ = image.getWidth();
        var stateCount = this.getCrossCheckStateCount();
        var j = startJ;
        while (j >= 0 && image.get(j, centerI)) {
            stateCount[2]++;
            j--;
        }
        if (j < 0) {
            return NaN;
        }
        while (j >= 0 && !image.get(j, centerI) && stateCount[1] <= maxCount) {
            stateCount[1]++;
            j--;
        }
        if (j < 0 || stateCount[1] > maxCount) {
            return NaN;
        }
        while (j >= 0 && image.get(j, centerI) && stateCount[0] <= maxCount) {
            stateCount[0]++;
            j--;
        }
        if (stateCount[0] > maxCount) {
            return NaN;
        }
        j = startJ + 1;
        while (j < maxJ && image.get(j, centerI)) {
            stateCount[2]++;
            j++;
        }
        if (j === maxJ) {
            return NaN;
        }
        while (j < maxJ && !image.get(j, centerI) && stateCount[3] < maxCount) {
            stateCount[3]++;
            j++;
        }
        if (j === maxJ || stateCount[3] >= maxCount) {
            return NaN;
        }
        while (j < maxJ && image.get(j, centerI) && stateCount[4] < maxCount) {
            stateCount[4]++;
            j++;
        }
        if (stateCount[4] >= maxCount) {
            return NaN;
        }
        // If we found a finder-pattern-like section, but its size is significantly different than
        // the original, assume it's a false positive
        var stateCountTotal = stateCount[0] + stateCount[1] + stateCount[2] + stateCount[3] +
            stateCount[4];
        if (5 * Math.abs(stateCountTotal - originalStateCountTotal) >= originalStateCountTotal) {
            return NaN;
        }
        return FinderPatternFinder.foundPatternCross(stateCount) ? FinderPatternFinder.centerFromEnd(stateCount, j) : NaN;
    };
    /**
     * <p>This is called when a horizontal scan finds a possible alignment pattern. It will
     * cross check with a vertical scan, and if successful, will, ah, cross-cross-check
     * with another horizontal scan. This is needed primarily to locate the real horizontal
     * center of the pattern in cases of extreme skew.
     * And then we cross-cross-cross check with another diagonal scan.</p>
     *
     * <p>If that succeeds the finder pattern location is added to a list that tracks
     * the number of times each location has been nearly-matched as a finder pattern.
     * Each additional find is more evidence that the location is in fact a finder
     * pattern center
     *
     * @param stateCount reading state module counts from horizontal scan
     * @param i row where finder pattern may be found
     * @param j end of possible finder pattern in row
     * @param pureBarcode true if in "pure barcode" mode
     * @return true if a finder pattern candidate was found this time
     */
    FinderPatternFinder.prototype.handlePossibleCenter = function (stateCount, i /*int*/, j /*int*/, pureBarcode) {
        var stateCountTotal = stateCount[0] + stateCount[1] + stateCount[2] + stateCount[3] +
            stateCount[4];
        var centerJ = FinderPatternFinder.centerFromEnd(stateCount, j);
        var centerI = this.crossCheckVertical(i, /*(int) */ Math.floor(centerJ), stateCount[2], stateCountTotal);
        if (!isNaN(centerI)) {
            // Re-cross check
            centerJ = this.crossCheckHorizontal(/*(int) */ Math.floor(centerJ), /*(int) */ Math.floor(centerI), stateCount[2], stateCountTotal);
            if (!isNaN(centerJ) &&
                (!pureBarcode || this.crossCheckDiagonal(/*(int) */ Math.floor(centerI), /*(int) */ Math.floor(centerJ), stateCount[2], stateCountTotal))) {
                var estimatedModuleSize = stateCountTotal / 7.0;
                var found = false;
                var possibleCenters = this.possibleCenters;
                for (var index = 0, length_1 = possibleCenters.length; index < length_1; index++) {
                    var center = possibleCenters[index];
                    // Look for about the same center and module size:
                    if (center.aboutEquals(estimatedModuleSize, centerI, centerJ)) {
                        possibleCenters[index] = center.combineEstimate(centerI, centerJ, estimatedModuleSize);
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    var point = new FinderPattern_1.default(centerJ, centerI, estimatedModuleSize);
                    possibleCenters.push(point);
                    if (this.resultPointCallback !== null && this.resultPointCallback !== undefined) {
                        this.resultPointCallback.foundPossibleResultPoint(point);
                    }
                }
                return true;
            }
        }
        return false;
    };
    /**
     * @return number of rows we could safely skip during scanning, based on the first
     *         two finder patterns that have been located. In some cases their position will
     *         allow us to infer that the third pattern must lie below a certain point farther
     *         down in the image.
     */
    FinderPatternFinder.prototype.findRowSkip = function () {
        var e_1, _a;
        var max = this.possibleCenters.length;
        if (max <= 1) {
            return 0;
        }
        var firstConfirmedCenter = null;
        try {
            for (var _b = __values(this.possibleCenters), _c = _b.next(); !_c.done; _c = _b.next()) {
                var center = _c.value;
                if (center.getCount() >= FinderPatternFinder.CENTER_QUORUM) {
                    if (firstConfirmedCenter == null) {
                        firstConfirmedCenter = center;
                    }
                    else {
                        // We have two confirmed centers
                        // How far down can we skip before resuming looking for the next
                        // pattern? In the worst case, only the difference between the
                        // difference in the x / y coordinates of the two centers.
                        // This is the case where you find top left last.
                        this.hasSkipped = true;
                        return /*(int) */ Math.floor((Math.abs(firstConfirmedCenter.getX() - center.getX()) -
                            Math.abs(firstConfirmedCenter.getY() - center.getY())) / 2);
                    }
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return 0;
    };
    /**
     * @return true iff we have found at least 3 finder patterns that have been detected
     *         at least {@link #CENTER_QUORUM} times each, and, the estimated module size of the
     *         candidates is "pretty similar"
     */
    FinderPatternFinder.prototype.haveMultiplyConfirmedCenters = function () {
        var e_2, _a, e_3, _b;
        var confirmedCount = 0;
        var totalModuleSize = 0.0;
        var max = this.possibleCenters.length;
        try {
            for (var _c = __values(this.possibleCenters), _d = _c.next(); !_d.done; _d = _c.next()) {
                var pattern = _d.value;
                if (pattern.getCount() >= FinderPatternFinder.CENTER_QUORUM) {
                    confirmedCount++;
                    totalModuleSize += pattern.getEstimatedModuleSize();
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
            }
            finally { if (e_2) throw e_2.error; }
        }
        if (confirmedCount < 3) {
            return false;
        }
        // OK, we have at least 3 confirmed centers, but, it's possible that one is a "false positive"
        // and that we need to keep looking. We detect this by asking if the estimated module sizes
        // vary too much. We arbitrarily say that when the total deviation from average exceeds
        // 5% of the total module size estimates, it's too much.
        var average = totalModuleSize / max;
        var totalDeviation = 0.0;
        try {
            for (var _e = __values(this.possibleCenters), _f = _e.next(); !_f.done; _f = _e.next()) {
                var pattern = _f.value;
                totalDeviation += Math.abs(pattern.getEstimatedModuleSize() - average);
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
            }
            finally { if (e_3) throw e_3.error; }
        }
        return totalDeviation <= 0.05 * totalModuleSize;
    };
    /**
     * @return the 3 best {@link FinderPattern}s from our list of candidates. The "best" are
     *         those that have been detected at least {@link #CENTER_QUORUM} times, and whose module
     *         size differs from the average among those patterns the least
     * @throws NotFoundException if 3 such finder patterns do not exist
     */
    FinderPatternFinder.prototype.selectBestPatterns = function () {
        var e_4, _a, e_5, _b;
        var startSize = this.possibleCenters.length;
        if (startSize < 3) {
            // Couldn't find enough finder patterns
            throw new NotFoundException_1.default();
        }
        var possibleCenters = this.possibleCenters;
        var average;
        // Filter outlier possibilities whose module size is too different
        if (startSize > 3) {
            // But we can only afford to do so if we have at least 4 possibilities to choose from
            var totalModuleSize = 0.0;
            var square = 0.0;
            try {
                for (var _c = __values(this.possibleCenters), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var center = _d.value;
                    var size = center.getEstimatedModuleSize();
                    totalModuleSize += size;
                    square += size * size;
                }
            }
            catch (e_4_1) { e_4 = { error: e_4_1 }; }
            finally {
                try {
                    if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
                }
                finally { if (e_4) throw e_4.error; }
            }
            average = totalModuleSize / startSize;
            var stdDev = Math.sqrt(square / startSize - average * average);
            possibleCenters.sort(
            /**
             * <p>Orders by furthest from average</p>
             */
            // FurthestFromAverageComparator implements Comparator<FinderPattern>
            function (center1, center2) {
                var dA = Math.abs(center2.getEstimatedModuleSize() - average);
                var dB = Math.abs(center1.getEstimatedModuleSize() - average);
                return dA < dB ? -1 : dA > dB ? 1 : 0;
            });
            var limit = Math.max(0.2 * average, stdDev);
            for (var i = 0; i < possibleCenters.length && possibleCenters.length > 3; i++) {
                var pattern = possibleCenters[i];
                if (Math.abs(pattern.getEstimatedModuleSize() - average) > limit) {
                    possibleCenters.splice(i, 1);
                    i--;
                }
            }
        }
        if (possibleCenters.length > 3) {
            // Throw away all but those first size candidate points we found.
            var totalModuleSize = 0.0;
            try {
                for (var possibleCenters_1 = __values(possibleCenters), possibleCenters_1_1 = possibleCenters_1.next(); !possibleCenters_1_1.done; possibleCenters_1_1 = possibleCenters_1.next()) {
                    var possibleCenter = possibleCenters_1_1.value;
                    totalModuleSize += possibleCenter.getEstimatedModuleSize();
                }
            }
            catch (e_5_1) { e_5 = { error: e_5_1 }; }
            finally {
                try {
                    if (possibleCenters_1_1 && !possibleCenters_1_1.done && (_b = possibleCenters_1.return)) _b.call(possibleCenters_1);
                }
                finally { if (e_5) throw e_5.error; }
            }
            average = totalModuleSize / possibleCenters.length;
            possibleCenters.sort(
            /**
             * <p>Orders by {@link FinderPattern#getCount()}, descending.</p>
             */
            // CenterComparator implements Comparator<FinderPattern>
            function (center1, center2) {
                if (center2.getCount() === center1.getCount()) {
                    var dA = Math.abs(center2.getEstimatedModuleSize() - average);
                    var dB = Math.abs(center1.getEstimatedModuleSize() - average);
                    return dA < dB ? 1 : dA > dB ? -1 : 0;
                }
                else {
                    return center2.getCount() - center1.getCount();
                }
            });
            possibleCenters.splice(3); // this is not realy necessary as we only return first 3 anyway
        }
        return [
            possibleCenters[0],
            possibleCenters[1],
            possibleCenters[2]
        ];
    };
    FinderPatternFinder.CENTER_QUORUM = 2;
    FinderPatternFinder.MIN_SKIP = 3; // 1 pixel/module times 3 modules/center
    FinderPatternFinder.MAX_MODULES = 57; // support up to version 10 for mobile clients
    return FinderPatternFinder;
}());
exports.default = FinderPatternFinder;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\qrcode\\detector\\FinderPatternFinder.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\detector\\FinderPatternInfo.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cqrcode%5Cdetector%5CFinderPatternInfo.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2007 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * <p>Encapsulates information about finder patterns in an image, including the location of
 * the three finder patterns, and their estimated module size.</p>
 *
 * @author Sean Owen
 */
var FinderPatternInfo = /** @class */ (function () {
    function FinderPatternInfo(patternCenters) {
        this.bottomLeft = patternCenters[0];
        this.topLeft = patternCenters[1];
        this.topRight = patternCenters[2];
    }
    FinderPatternInfo.prototype.getBottomLeft = function () {
        return this.bottomLeft;
    };
    FinderPatternInfo.prototype.getTopLeft = function () {
        return this.topLeft;
    };
    FinderPatternInfo.prototype.getTopRight = function () {
        return this.topRight;
    };
    return FinderPatternInfo;
}());
exports.default = FinderPatternInfo;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\qrcode\\detector\\FinderPatternInfo.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\encoder\\BlockPair.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cqrcode%5Cencoder%5CBlockPair.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2008 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
/*namespace com.google.zxing.qrcode.encoder {*/
var BlockPair = /** @class */ (function () {
    function BlockPair(dataBytes, errorCorrectionBytes) {
        this.dataBytes = dataBytes;
        this.errorCorrectionBytes = errorCorrectionBytes;
    }
    BlockPair.prototype.getDataBytes = function () {
        return this.dataBytes;
    };
    BlockPair.prototype.getErrorCorrectionBytes = function () {
        return this.errorCorrectionBytes;
    };
    return BlockPair;
}());
exports.default = BlockPair;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\qrcode\\encoder\\BlockPair.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\encoder\\ByteMatrix.js", {"../../util/Arrays":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\Arrays.js","../../util/StringBuilder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\StringBuilder.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cqrcode%5Cencoder%5CByteMatrix.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2008 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
/*namespace com.google.zxing.qrcode.encoder {*/
/*import java.util.Arrays;*/
var Arrays_1 = require("../../util/Arrays");
var StringBuilder_1 = require("../../util/StringBuilder");
/**
 * JAVAPORT: The original code was a 2D array of ints, but since it only ever gets assigned
 * -1, 0, and 1, I'm going to use less memory and go with bytes.
 *
 * @author dswitkin@google.com (Daniel Switkin)
 */
var ByteMatrix = /** @class */ (function () {
    function ByteMatrix(width /*int*/, height /*int*/) {
        this.width = width;
        this.height = height;
        var bytes = new Array(height); // [height][width]
        for (var i = 0; i !== height; i++) {
            bytes[i] = new Uint8Array(width);
        }
        this.bytes = bytes;
    }
    ByteMatrix.prototype.getHeight = function () {
        return this.height;
    };
    ByteMatrix.prototype.getWidth = function () {
        return this.width;
    };
    ByteMatrix.prototype.get = function (x /*int*/, y /*int*/) {
        return this.bytes[y][x];
    };
    /**
     * @return an internal representation as bytes, in row-major order. array[y][x] represents point (x,y)
     */
    ByteMatrix.prototype.getArray = function () {
        return this.bytes;
    };
    // TYPESCRIPTPORT: preffer to let two methods instead of override to avoid type comparison inside
    ByteMatrix.prototype.setNumber = function (x /*int*/, y /*int*/, value /*byte|int*/) {
        this.bytes[y][x] = value;
    };
    // public set(x: number /*int*/, y: number /*int*/, value: number /*int*/): void {
    //   bytes[y][x] = (byte) value
    // }
    ByteMatrix.prototype.setBoolean = function (x /*int*/, y /*int*/, value) {
        this.bytes[y][x] = /*(byte) */ (value ? 1 : 0);
    };
    ByteMatrix.prototype.clear = function (value /*byte*/) {
        var e_1, _a;
        try {
            for (var _b = __values(this.bytes), _c = _b.next(); !_c.done; _c = _b.next()) {
                var aByte = _c.value;
                Arrays_1.default.fill(aByte, value);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
    };
    ByteMatrix.prototype.equals = function (o) {
        if (!(o instanceof ByteMatrix)) {
            return false;
        }
        var other = o;
        if (this.width !== other.width) {
            return false;
        }
        if (this.height !== other.height) {
            return false;
        }
        for (var y = 0, height = this.height; y < height; ++y) {
            var bytesY = this.bytes[y];
            var otherBytesY = other.bytes[y];
            for (var x = 0, width = this.width; x < width; ++x) {
                if (bytesY[x] !== otherBytesY[x]) {
                    return false;
                }
            }
        }
        return true;
    };
    /*@Override*/
    ByteMatrix.prototype.toString = function () {
        var result = new StringBuilder_1.default(); // (2 * width * height + 2)
        for (var y = 0, height = this.height; y < height; ++y) {
            var bytesY = this.bytes[y];
            for (var x = 0, width = this.width; x < width; ++x) {
                switch (bytesY[x]) {
                    case 0:
                        result.append(' 0');
                        break;
                    case 1:
                        result.append(' 1');
                        break;
                    default:
                        result.append('  ');
                        break;
                }
            }
            result.append('\n');
        }
        return result.toString();
    };
    return ByteMatrix;
}());
exports.default = ByteMatrix;

      };
    };
  }
  }
}, {package:"@zxing/library",file:"node_modules\\@zxing\\library\\cjs\\core\\qrcode\\encoder\\ByteMatrix.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\encoder\\Encoder.js", {"../../EncodeHintType":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\EncodeHintType.js","../../WriterException":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\WriterException.js","../../common/BitArray":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\BitArray.js","../../common/CharacterSetECI":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\CharacterSetECI.js","../../common/reedsolomon/GenericGF":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\reedsolomon\\GenericGF.js","../../common/reedsolomon/ReedSolomonEncoder":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\common\\reedsolomon\\ReedSolomonEncoder.js","../../util/StringEncoding":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\util\\StringEncoding.js","../decoder/Mode":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\Mode.js","../decoder/Version":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\decoder\\Version.js","./BlockPair":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\encoder\\BlockPair.js","./ByteMatrix":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\encoder\\ByteMatrix.js","./MaskUtil":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\encoder\\MaskUtil.js","./MatrixUtil":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\encoder\\MatrixUtil.js","./QRCode":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\core\\qrcode\\encoder\\QRCode.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@zxing%5Clibrary%5Ccjs%5Ccore%5Cqrcode%5Cencoder%5CEncoder.js
      return function (require, module, exports) {
"use strict";
/*
 * Copyright 2008 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
/*namespace com.google.zxing.qrcode.encoder {*/
var EncodeHintType_1 = require("../../EncodeHintType");
var BitArray_1 = require("../../common/BitArray");
var CharacterSetECI_1 = require("../../common/CharacterSetECI");
var GenericGF_1 = require("../../common/reedsolomon/GenericGF");
var ReedSolomonEncoder_1 = require("../../common/reedsolomon/ReedSolomonEncoder");
var Mode_1 = require("../decoder/Mode");
var Version_1 = require("../decoder/Version");
var MaskUtil_1 = require("./MaskUtil");
var ByteMatrix_1 = require("./ByteMatrix");
var QRCode_1 = require("./QRCode");
var MatrixUtil_1 = require("./MatrixUtil");
var StringEncoding_1 = require("../../util/StringEncoding");
var BlockPair_1 = require("./BlockPair");
var WriterException_1 = require("../../WriterException");
/*import java.io.UnsupportedEncodingException;*/
/*import java.util.ArrayList;*/
/*import java.util.Collection;*/
/*import java.util.Map;*/
/**
 * @author satorux@google.com (Satoru Takabayashi) - creator
 * @author dswitkin@google.com (Daniel Switkin) - ported from C++
 */
var Encoder = /** @class */ (function () {
    // TYPESCRIPTPORT: changed to UTF8, the default for js
    function Encoder() {
    }
    // The mask penalty calculation is complicated.  See Table 21 of JISX0510:2004 (p.45) for details.
    // Basically it applies four rules and summate all penalties.
    Encoder.calculateMaskPenalty = function (matrix) {
        return MaskUtil_1.default.applyMaskPenaltyRule1(matrix)
            + MaskUtil_1.default.applyMaskPenaltyRule2(matrix)
            + MaskUtil_1.default.applyMaskPenaltyRule3(matrix)
            + MaskUtil_1.default.applyMaskPenaltyRule4(matrix);
    };
    /**
     * @param content text to encode
     * @param ecLevel error correction level to use
     * @return {@link QRCode} representing the encoded QR code
     * @throws WriterException if encoding can't succeed, because of for example invalid content
     *   or configuration
     */
    // public static encode(content: string, ecLevel: ErrorCorrectionLevel): QRCode /*throws WriterException*/ {
    //   return encode(content, ecLevel, null)
    // }
    Encoder.encode = function (content, ecLevel, hints) {
        if (hints === void 0) { hints = null; }
        // Determine what character encoding has been specified by the caller, if any
        var encoding = Encoder.DEFAULT_BYTE_MODE_ENCODING;
        var hasEncodingHint = hints !== null && undefined !== hints.get(EncodeHintType_1.default.CHARACTER_SET);
        if (hasEncodingHint) {
            encoding = hints.get(EncodeHintType_1.default.CHARACTER_SET).toString();
        }
        // Pick an encoding mode appropriate for the content. Note that this will not attempt to use
        // multiple modes / segments even if that were more efficient. Twould be nice.
        var mode = this.chooseMode(content, encoding);
        // This will store the header information, like mode and
        // length, as well as "header" segments like an ECI segment.
        var headerBits = new BitArray_1.default();
        // Append ECI segment if applicable
        if (mode === Mode_1.default.BYTE && (hasEncodingHint || Encoder.DEFAULT_BYTE_MODE_ENCODING !== encoding)) {
            var eci = CharacterSetECI_1.default.getCharacterSetECIByName(encoding);
            if (eci !== undefined) {
                this.appendECI(eci, headerBits);
            }
        }
        // (With ECI in place,) Write the mode marker
        this.appendModeInfo(mode, headerBits);
        // Collect data within the main segment, separately, to count its size if needed. Don't add it to
        // main payload yet.
        var dataBits = new BitArray_1.default();
        this.appendBytes(content, mode, dataBits, encoding);
        var version;
        if (hints !== null && undefined !== hints.get(EncodeHintType_1.default.QR_VERSION)) {
            var versionNumber = Number.parseInt(hints.get(EncodeHintType_1.default.QR_VERSION).toString(), 10);
            version = Version_1.default.getVersionForNumber(versionNumber);
            var bitsNeeded = this.calculateBitsNeeded(mode, headerBits, dataBits, version);
            if (!this.willFit(bitsNeeded, version, ecLevel)) {
                throw new WriterException_1.default('Data too big for requested version');
            }
        }
        else {
            version = this.recommendVersion(ecLevel, mode, headerBits, dataBits);
        }
        var headerAndDataBits = new BitArray_1.default();
        headerAndDataBits.appendBitArray(headerBits);
        // Find "length" of main segment and write it
        var numLetters = mode === Mode_1.default.BYTE ? dataBits.getSizeInBytes() : content.length;
        this.appendLengthInfo(numLetters, version, mode, headerAndDataBits);
        // Put data together into the overall payload
        headerAndDataBits.appendBitArray(dataBits);
        var ecBlocks = version.getECBlocksForLevel(ecLevel);
        var numDataBytes = version.getTotalCodewords() - ecBlocks.getTotalECCodewords();
        // Terminate the bits properly.
        this.terminateBits(numDataBytes, headerAndDataBits);
        // Interleave data bits with error correction code.
        var finalBits = this.interleaveWithECBytes(headerAndDataBits, version.getTotalCodewords(), numDataBytes, ecBlocks.getNumBlocks());
        var qrCode = new QRCode_1.default();
        qrCode.setECLevel(ecLevel);
        qrCode.setMode(mode);
        qrCode.setVersion(version);
        //  Choose the mask pattern and set to "qrCode".
        var dimension = version.getDimensionForVersion();
        var matrix = new ByteMatrix_1.default(dimension, dimension);
        var maskPattern = this.chooseMaskPattern(finalBits, ecLevel, version, matrix);
        qrCode.setMaskPattern(maskPattern);
        // Build the matrix and set it to "qrCode".
        MatrixUtil_1.default.buildMatrix(finalBits, ecLevel, version, maskPattern, matrix);
        qrCode.setMatrix(matrix);
        return qrCode;
    };
    /**
     * Decides the smallest version of QR code that will contain all of the provided data.
     *
     * @throws WriterException if the data cannot fit in any version
     */
    Encoder.recommendVersion = function (ecLevel, mode, headerBits, dataBits) {
        // Hard part: need to know version to know how many bits length takes. But need to know how many
        // bits it takes to know version. First we take a guess at version by assuming version will be
        // the minimum, 1:
        var provisionalBitsNeeded = this.calculateBitsNeeded(mode, headerBits, dataBits, Version_1.default.getVersionForNumber(1));
        var provisionalVersion = this.chooseVersion(provisionalBitsNeeded, ecLevel);
        // Use that guess to calculate the right version. I am still not sure this works in 100% of cases.
        var bitsNeeded = this.calculateBitsNeeded(mode, headerBits, dataBits, provisionalVersion);
        return this.chooseVersion(bitsNeeded, ecLevel);
    };
    Encoder.calculateBitsNeeded = function (mode, headerBits, dataBits, version) {
        return headerBits.getSize() + mode.getCharacterCountBits(version) + dataBits.getSize();
    };
    /**
     * @return the code point of the table used in alphanumeric mode or
     *  -1 if there is no corresponding code in the table.
     */
    Encoder.getAlphanumericCode = function (code /*int*/) {
        if (code < Encoder.ALPHANUMERIC_TABLE.length) {
            return Encoder.ALPHANUMERIC_TABLE[code];
        }
        return -1;
    };
    // public static chooseMode(content: string): Mode {
    //   return chooseMode(content, null);
    // }
    /**
     * Choose the best mode by examining the content. Note that 'encoding' is used as a hint;
     * if it is Shift_JIS, and the input is only double-byte Kanji, then we return {@link Mode#KANJI}.
     */
    Encoder.chooseMode = function (content, encoding) {
        if (encoding === void 0) { encoding = null; }
        if (CharacterSetECI_1.default.SJIS.getName() === encoding && this.isOnlyDoubleByteKanji(content)) {
            // Choose Kanji mode if all input are double-byte characters
            return Mode_1.default.KANJI;
        }
        var hasNumeric = false;
        var hasAlphanumeric = false;
        for (var i = 0, length_1 = content.length; i < length_1; ++i) {
            var c = content.charAt(i);
            if (Encoder.isDigit(c)) {
                hasNumeric = true;
            }
            else if (this.getAlphanumericCode(c.charCodeAt(0)) !== -1) {
                hasAlphanumeric = true;
            }
            else {
                return Mode_1.default.BYTE;
            }
        }
        if (hasAlphanumeric) {
            return Mode_1.default.ALPHANUMERIC;
        }
        if (hasNumeric) {
            return Mode_1.default.NUMERIC;
        }
        return Mode_1.default.BYTE;
    };
    Encoder.isOnlyDoubleByteKanji = function (content) {
        var bytes;
        try {
            bytes = StringEncoding_1.default.encode(content, CharacterSetECI_1.default.SJIS); // content.getBytes("Shift_JIS"))
        }
        catch (ignored /*: UnsupportedEncodingException*/) {
            return false;
        }
        var length = bytes.length;
        if (length % 2 !== 0) {
            return false;
        }
        for (var i = 0; i < length; i += 2) {
            var byte1 = bytes[i] & 0xFF;
            if ((byte1 < 0x81 || byte1 > 0x9F) && (byte1 < 0xE0 || byte1 > 0xEB)) {
                return false;
            }
        }
        return true;
    };
    Encoder.chooseMaskPattern = function (bits, ecLevel, version, matrix) {
        var minPenalty = Number.MAX_SAFE_INTEGER; // Lower penalty is better.
        var bestMaskPattern = -1;
        // We try all mask patterns to choose the best one.
        for (var maskPattern = 0; maskPattern < QRCode_1.default.NUM_MASK_PATTERNS; maskPattern++) {
            MatrixUtil_1.default.buildMatrix(bits, ecLevel, version, maskPattern, matrix);
            var penalty = this.calculateMaskPenalty(matrix);
            if (penalty < minPenalty) {
                minPenalty = penalty;
                bestMaskPattern = maskPattern;
            }
        }
        return bestMaskPattern;
    };
    Encoder.chooseVersion = function (numInputBits /*int*/, ecLevel) {
        for (var versionNum = 1; versionNum <= 40; versionNum++) {
            var version = Version_1.default.getVersionForNumber(versionNum);
            if (Encoder.willFit(numInputBits, version, ecLevel)) {
                return version;
            }
        }
        throw new WriterException_1.default('Data too big');
    };
    /**
     * @return true if the number of input bits will fit in a code with the specified version and
     * error correction level.
     */
    Encoder.willFit = function (numInputBits /*int*/, version, ecLevel) {
        // In the following comments, we use numbers of Version 7-H.
        // numBytes = 196
        var numBytes = version.getTotalCodewords();
        // getNumECBytes = 130
        var ecBlocks = version.getECBlocksForLevel(ecLevel);
        var numEcBytes = ecBlocks.getTotalECCodewords();
        // getNumDataBytes = 196 - 130 = 66
        var numDataBytes = numBytes - numEcBytes;
        var totalInputBytes = (numInputBits + 7) / 8;
        return numDataBytes >= totalInputBytes;
    };
    /**
     * Terminate bits as described in 8.4.8 and 8.4.9 of JISX0510:2004 (p.24).
     */
    Encoder.terminateBits = function (numDataBytes /*int*/, bits) {
        var capacity = numDataBytes * 8;
        if (bits.getSize() > capacity) {
            throw new WriterException_1.default('data bits cannot fit in the QR Code' + bits.getSize() + ' > ' +
                capacity);
        }
        for (var i = 0; i < 4 && bits.getSize() < capacity; ++i) {
            bits.appendBit(false);
        }
        // Append termination bits. See 8.4.8 of JISX0510:2004 (p.24) for details.
        // If the last byte isn't 8-bit aligned, we'll add padding bits.
        var numBitsInLastByte = bits.getSize() & 0x07;
        if (numBitsInLastByte > 0) {
            for (var i = numBitsInLastByte; i < 8; i++) {
                bits.appendBit(false);
            }
        }
        // If we have more space, we'll fill the space with padding patterns defined in 8.4.9 (p.24).
        var numPaddingBytes = numDataBytes - bits.getSizeInBytes();
        for (var i = 0; i < numPaddingBytes; ++i) {
            bits.appendBits((i & 0x01) === 0 ? 0xEC : 0x11, 8);
        }
        if (bits.getSize() !== capacity) {
            throw new WriterException_1.default('Bits size does not equal capacity');
        }
    };
    /**
     * Get number of data bytes and number of error correction bytes for block id "blockID". Store
     * the result in "numDataBytesInBlock", and "numECBytesInBlock". See table 12 in 8.5.1 of
     * JISX0510:2004 (p.30)
     */
    Encoder.getNumDataBytesAndNumECBytesForBlockID = function (numTotalBytes /*int*/, numDataBytes /*int*/, numRSBlocks /*int*/, blockID /*int*/, numDataBytesInBlock, numECBytesInBlock) {
        if (blockID >= numRSBlocks) {
            throw new WriterException_1.default('Block ID too large');
        }
        // numRsBlocksInGroup2 = 196 % 5 = 1
        var numRsBlocksInGroup2 = numTotalBytes % numRSBlocks;
        // numRsBlocksInGroup1 = 5 - 1 = 4
        var numRsBlocksInGroup1 = numRSBlocks - numRsBlocksInGroup2;
        // numTotalBytesInGroup1 = 196 / 5 = 39
        var numTotalBytesInGroup1 = Math.floor(numTotalBytes / numRSBlocks);
        // numTotalBytesInGroup2 = 39 + 1 = 40
        var numTotalBytesInGroup2 = numTotalBytesInGroup1 + 1;
        // numDataBytesInGroup1 = 66 / 5 = 13
        var numDataBytesInGroup1 = Math.floor(numDataBytes / numRSBlocks);
        // numDataBytesInGroup2 = 13 + 1 = 14
        var numDataBytesInGroup2 = numDataBytesInGroup1 + 1;
        // numEcBytesInGroup1 = 39 - 13 = 26
        var numEcBytesInGroup1 = numTotalBytesInGroup1 - numDataBytesInGroup1;
        // numEcBytesInGroup2 = 40 - 14 = 26
        var numEcBytesInGroup2 = numTotalBytesInGroup2 - numDataBytesInGroup2;
        // Sanity checks.
        // 26 = 26
        if (numEcBytesInGroup1 !== numEcBytesInGroup2) {
            throw new WriterException_1.default('EC bytes mismatch');
        }
        // 5 = 4 + 1.
        if (numRSBlocks !== numRsBlocksInGroup1 + numRsBlocksInGroup2) {
            throw new WriterException_1.default('RS blocks mismatch');
        }
        // 196 = (13 + 26) * 4 + (14 + 26) * 1
        if (numTotalBytes !==
            ((numDataBytesInGroup1 + numEcBytesInGroup1) *
                numRsBlocksInGroup1) +
                ((numDataBytesInGroup2 + numEcBytesInGroup2) *
                    numRsBlocksInGroup2)) {
            throw new WriterException_1.default('Total bytes mismatch');
        }
        if (blockID < numRsBlocksInGroup1) {
            numDataBytesInBlock[0] = numDataBytesInGroup1;
            numECBytesInBlock[0] = numEcBytesInGroup1;
        }
        else {
            numDataBytesInBlock[0] = numDataBytesInGroup2;
            numECBytesInBlock[0] = numEcBytesInGroup2;
        }
    };
    /**
     * Interleave "bits" with corresponding error correction bytes. On success, store the result in
     * "result". The interleave rule is complicated. See 8.6 of JISX0510:2004 (p.37) for details.
     */
    Encoder.interleaveWithECBytes = function (bits, numTotalBytes /*int*/, numDataBytes /*int*/, numRSBlocks /*int*/) {
        var e_1, _a, e_2, _b;
        // "bits" must have "getNumDataBytes" bytes of data.
        if (bits.getSizeInBytes() !== numDataBytes) {
            throw new WriterException_1.default('Number of bits and data bytes does not match');
        }
        // Step 1.  Divide data bytes into blocks and generate error correction bytes for them. We'll
        // store the divided data bytes blocks and error correction bytes blocks into "blocks".
        var dataBytesOffset = 0;
        var maxNumDataBytes = 0;
        var maxNumEcBytes = 0;
        // Since, we know the number of reedsolmon blocks, we can initialize the vector with the number.
        var blocks = new Array(); // new Array<BlockPair>(numRSBlocks)
        for (var i = 0; i < numRSBlocks; ++i) {
            var numDataBytesInBlock = new Int32Array(1);
            var numEcBytesInBlock = new Int32Array(1);
            Encoder.getNumDataBytesAndNumECBytesForBlockID(numTotalBytes, numDataBytes, numRSBlocks, i, numDataBytesInBlock, numEcBytesInBlock);
            var size = numDataBytesInBlock[0];
            var dataBytes = new Uint8Array(size);
            bits.toBytes(8 * dataBytesOffset, dataBytes, 0, size);
            var ecBytes = Encoder.generateECBytes(dataBytes, numEcBytesInBlock[0]);
            blocks.push(new BlockPair_1.default(dataBytes, ecBytes));
            maxNumDataBytes = Math.max(maxNumDataBytes, size);
            maxNumEcBytes = Math.max(maxNumEcBytes, ecBytes.length);
            dataBytesOffset += numDataBytesInBlock[0];
        }
        if (numDataBytes !== dataBytesOffset) {
            throw new WriterException_1.default('Data bytes does not match offset');
        }
        var result = new BitArray_1.default();
        // First, place data blocks.
        for (var i = 0; i < maxNumDataBytes; ++i) {
            try {
                for (var blocks_1 = (e_1 = void 0, __values(blocks)), blocks_1_1 = blocks_1.next(); !blocks_1_1.done; blocks_1_1 = blocks_1.next()) {
                    var block = blocks_1_1.value;
                    var dataBytes = block.getDataBytes();
                    if (i < dataBytes.length) {
                        result.appendBits(dataBytes[i], 8);
                    }
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (blocks_1_1 && !blocks_1_1.done && (_a = blocks_1.return)) _a.call(blocks_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
        }
        // Then, place error correction blocks.
        for (var i = 0; i < maxNumEcBytes; ++i) {
            try {
                for (var blocks_2 = (e_2 = void 0, __values(blocks)), blocks_2_1 = blocks_2.next(); !blocks_2_1.done; blocks_2_1 = blocks_2.next()) {
                    var block = blocks_2_1.value;
                    var ecBytes = block.getErrorCorrectionBytes();
                    if (i < ecBytes.length) {
                        result.appendBits(ecBytes[i], 8);
                    }
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (blocks_2_1 && !blocks_2_1.done && (_b = blocks_2.return)) _b.call(blocks_2);
                }
                finally { if (e_2) throw e_2.error; }
            }
        }
        if (numTotalBytes !== result.getSizeInBytes()) { // Should be same.
            throw new WriterException_1.default('Interleaving error: ' + numTotalBytes + ' and ' +
                result.getSizeInBytes() + ' differ.');
        }
        return result;
    };
    Encoder.generateECBytes = function (dataBytes, numEcBytesInBlock /*int*/) {
        var numDataBytes = dataBytes.length;
        var toEncode = new Int32Array(numDataBytes + numEcBytesInBlock); // int[numDataBytes + numEcBytesInBlock]
        for (var i = 0; i < numDataBytes; i++) {
            toEncode[i] = dataBytes[i] & 0xFF;
        }
        new ReedSolomonEncoder_1.default(GenericGF_1.default.QR_CODE_FIELD_256).encode(toEncode, numEcBytesInBlock);
        var ecBytes = new Uint8Array(numEcBytesInBlock);
        for (var i = 0; i < numEcBytesInBlock; i++) {
            ecBytes[i] = /*(byte) */ toEncode[numDataBytes + i];
        }
        return ecBytes;
    };
    /**
     * Append mode info. On success, store the result in "bits".
     */
    Encoder.appendModeInfo = function (mode, bits) {
        bits.appendBits(mode.getBits(), 4);
    };
    /**
     * Append length info. On success, store the result in "bits".
     */
    Encoder.appendLengthInfo = function (numLetters /*int*/, version, mode, bits) {
        var numBits = mode.getCharacterCountBits(version);
        if (numLetters >= (1 << numBits)) {
            throw new WriterException_1.default(numLetters + ' is bigger than ' + ((1 << numBits) - 1));
        }
        bits.appendBits(numLetters, numBits);
    };
    /**
     * Append "bytes" in "mode" mode (encoding) into "bits". On success, store the result in "bits".
     */
    Encoder.appendBytes = function (content, mode, bits, encoding) {
        switch (mode) {
            case Mode_1.default.NUMERIC:
                Encoder.appendNumericBytes(content, bits);
                break;
            case Mode_1.default.ALPHANUMERIC:
                Encoder.appendAlphanumericBytes(content, bits);
                break;
            case Mode_1.default.BYTE:
                Encoder.append8BitBytes(content, bits, encoding);
                break;
            case Mode_1.default.KANJI:
                Encoder.appendKanjiBytes(content, bits);
                break;
            default:
                throw new WriterException_1.default('Invalid mode: ' + mode);
        }
    };
    Encoder.getDigit = function (singleCharacter) {
        return singleCharacter.charCodeAt(0) - 48;
    };
    Encoder.isDigit = function (singleCharacter) {
        var cn = Encoder.getDigit(singleCharacter);
        return cn >= 0 && cn <= 9;
    };
    Encoder.appendNumericBytes = function (content, bits) {
        var length = content.length;
        var i = 0;
        while (i < length) {
            var num1 = Encoder.getDigit(content.charAt(i));
            if (i + 2 < length) {
                // Encode three numeric letters in ten bits.
                var num2 = Encoder.getDigit(content.charAt(i + 1));
                var num3 = Encoder.getDigit(content.charAt(i + 2));
                bits.appendBits(num1 * 100 + num2 * 10 + num3, 10);
                i += 3;
            }
            else if (i + 1 < length) {
                // Encode two numeric letters in seven bits.
                var num2 = Encoder.getDigit(content.charAt(i + 1));
                bits.appendBits(num1 * 10 + num2, 7);
                i += 2;
            }
            else {
                // Encode one numeric letter in four bits.
                bits.appendBits(num1, 4);
                i++;
            }
        }
    };
    Encoder.appendAlphanumericBytes = function (content, bits) {
        var length = content.length;
        var i = 0;
        while (i < length) {
            var code1 = Encoder.getAlphanumericCode(content.charCodeAt(i));
            if (code1 === -1) {
                throw new WriterException_1.default();
            }
            if (i + 1 < length) {
                var code2 = Encoder.getAlphanumericCode(content.charCodeAt(i + 1));
                if (code2 === -1) {
                    throw new WriterException_1.default();
                }
                // Encode two alphanumeric letters in 11 bits.
                bits.appendBits(code1 * 45 + code2, 11);
                i += 2;
            }
            else {
                // Encode one alphanumeric letter in six bits.
                bits.appendBits(code1, 6);
                i++;
            }
        }
    };
    Encoder.append8BitBytes = function (content, bits, encoding) {
        var bytes;
        try {
            bytes = StringEncoding_1.default.encode(content, encoding);
        }
        catch (uee /*: UnsupportedEncodingException*/) {
            throw new WriterException_1.default(uee);
        }
        for (var i = 0, length_2 = bytes.length; i !== length_2; i++) {
            var b = bytes[i];
            bits.appendBits(b, 8);
        }
    };
    /**
     * @throws WriterException
     */
    Encoder.appendKanjiBytes = function (content, bits) {
        var bytes;
        try {
            bytes = StringEncoding_1.default.encode(content, CharacterSetECI_1.default.SJIS);
        }
        catch (uee /*: UnsupportedEncodingException*/) {
            throw new WriterException_1.default(uee);
        }
        var length = bytes.length;
        for (var i = 0; i < length; i += 2) {
            var byte1 = bytes[i] & 0xFF;
            var byte2 = bytes[i + 1] & 0xFF;
            var code = ((byte1 << 8) & 0xFFFFFFFF) | byte2;
            var subtracted = -1;
            if (code >= 0x8140 && code <= 0x9ffc) {
                subtracted = code - 0x8140;
            }
            else if (code >= 0xe040 && code <= 0xebbf) {
                subtracted = code - 0xc140;
            }
            if (subtracted === -1) {
                throw new WriterException_1.default('Invalid byte sequence');
            }
            var encoded = ((subtracted >> 8) * 0xc0) +