LavaPack.loadBundle([
["D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\components\\asset-options.js", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/ui/menu":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\menu\\index.ts","../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Casset%5Ccomponents%5Casset-options.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _i18n = require("../../../contexts/i18n");
var _menu = require("../../../components/ui/menu");
var _selectors = require("../../../selectors");
var _routes = require("../../../helpers/constants/routes");
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AssetOptions = ({
  onRemove,
  onClickBlockExplorer,
  onViewTokenDetails,
  tokenSymbol,
  isNativeAsset,
  isEvm
}) => {
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const [assetOptionsOpen, setAssetOptionsOpen] = (0, _react.useState)(false);
  const history = (0, _reactRouterDom.useHistory)();
  const blockExplorerLinkText = (0, _reactRedux.useSelector)(_selectors.getBlockExplorerLinkText);
  const ref = (0, _react.useRef)(false);
  const routeToAddBlockExplorerUrl = () => {
    history.push(`${_routes.NETWORKS_ROUTE}#blockExplorerUrl`);
  };
  const openBlockExplorer = () => {
    setAssetOptionsOpen(false);
    onClickBlockExplorer();
  };
  const shouldShowHideTokenButton = isEvm && !isNativeAsset;
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: ref
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    className: "asset-options__button",
    "data-testid": "asset-options__button",
    onClick: () => setAssetOptionsOpen(true),
    ariaLabel: t('assetOptions'),
    iconName: _componentLibrary.IconName.MoreVertical,
    color: _designSystem.Color.textDefault,
    size: _componentLibrary.ButtonIconSize.Sm
  }), assetOptionsOpen ? /*#__PURE__*/_react.default.createElement(_menu.Menu, {
    anchorElement: ref.current,
    onHide: () => setAssetOptionsOpen(false)
  }, /*#__PURE__*/_react.default.createElement(_menu.MenuItem, {
    iconName: _componentLibrary.IconName.Export,
    "data-testid": "asset-options__etherscan",
    onClick: blockExplorerLinkText.firstPart === 'addBlockExplorer' ? routeToAddBlockExplorerUrl : openBlockExplorer
  }, t(blockExplorerLinkText.firstPart, blockExplorerLinkText.secondPart === '' ? null : [t('blockExplorerAssetAction')])), shouldShowHideTokenButton && /*#__PURE__*/_react.default.createElement(_menu.MenuItem, {
    iconName: _componentLibrary.IconName.Trash,
    "data-testid": "asset-options__hide",
    onClick: () => {
      setAssetOptionsOpen(false);
      onRemove();
    }
  }, t('hideTokenSymbol', [tokenSymbol])), isNativeAsset || !onViewTokenDetails ? null : /*#__PURE__*/_react.default.createElement(_menu.MenuItem, {
    iconName: _componentLibrary.IconName.Info,
    "data-testid": "asset-options__token-details",
    onClick: () => {
      setAssetOptionsOpen(false);
      onViewTokenDetails();
    }
  }, t('tokenDetails'))) : null);
};
const isNotFunc = p => {
  return typeof p !== 'function';
};
AssetOptions.propTypes = {
  isNativeAsset: _propTypes.default.bool,
  isEvm: _propTypes.default.bool,
  onClickBlockExplorer: _propTypes.default.func.isRequired,
  onRemove: props => {
    if (props.isNativeAsset === false && isNotFunc(props.onRemove)) {
      throw new Error('When isNativeAsset is true, onRemove is a required prop');
    }
  },
  onViewTokenDetails: _propTypes.default.func,
  tokenSymbol: props => {
    if (props.isNativeAsset === false && typeof props.tokenSymbol !== 'string') {
      throw new Error('When isNativeAsset is true, tokenSymbol is a required prop');
    }
  }
};
var _default = exports.default = AssetOptions;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\asset\\components\\asset-options.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\components\\asset-page.tsx", {"../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../../shared/lib/asset-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\asset-utils.ts","../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../../../shared/modules/hexstring-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\hexstring-utils.ts","../../../components/app/assets/hooks/useMultichainAssets":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\hooks\\useMultichainAssets.tsx","../../../components/app/assets/token-cell":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\token-cell\\index.ts","../../../components/app/assets/util/calculateTokenBalance":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\util\\calculateTokenBalance.ts","../../../components/app/transaction-list":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\transaction-list\\index.js","../../../components/app/transaction-list/unified-transaction-list.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\transaction-list\\unified-transaction-list.component.js","../../../components/app/wallet-overview/coin-buttons":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\wallet-overview\\coin-buttons.tsx","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/multichain":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../ducks/ramps":"D:\\code\\v\\metamask-extension\\ui\\ducks\\ramps\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../helpers/utils/portfolio":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\portfolio.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../hooks/useMultichainSelector":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainSelector.ts","../../../hooks/useTokenBalances":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTokenBalances.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/assets":"D:\\code\\v\\metamask-extension\\ui\\selectors\\assets.ts","../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","../../settings/networks-tab/networks-form/use-safe-chains":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\networks-tab\\networks-form\\use-safe-chains.ts","../hooks/useCurrentPrice":"D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\hooks\\useCurrentPrice.ts","./asset-market-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\components\\asset-market-details.tsx","./chart/asset-chart":"D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\components\\chart\\asset-chart.tsx","./token-buttons":"D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\components\\token-buttons.tsx","@metamask/assets-controllers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\index.cjs","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Casset%5Ccomponents%5Casset-page.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _assetsControllers = require("@metamask/assets-controllers");
var _bridgeController = require("@metamask/bridge-controller");
var _keyringApi = require("@metamask/keyring-api");
var _utils = require("@metamask/utils");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _transaction = require("../../../../shared/constants/transaction");
var _assetUtils = require("../../../../shared/lib/asset-utils");
var _trace = require("../../../../shared/lib/trace");
var _conversion = require("../../../../shared/modules/conversion.utils");
var _hexstringUtils = require("../../../../shared/modules/hexstring-utils");
var _useMultichainAssets = _interopRequireDefault(require("../../../components/app/assets/hooks/useMultichainAssets"));
var _tokenCell = _interopRequireDefault(require("../../../components/app/assets/token-cell"));
var _calculateTokenBalance = require("../../../components/app/assets/util/calculateTokenBalance");
var _transactionList = _interopRequireDefault(require("../../../components/app/transaction-list"));
var _unifiedTransactionList = _interopRequireDefault(require("../../../components/app/transaction-list/unified-transaction-list.component"));
var _coinButtons = _interopRequireDefault(require("../../../components/app/wallet-overview/coin-buttons"));
var _componentLibrary = require("../../../components/component-library");
var _multichain = require("../../../components/multichain");
var _metamask = require("../../../ducks/metamask/metamask");
var _ramps = require("../../../ducks/ramps");
var _designSystem = require("../../../helpers/constants/design-system");
var _routes = require("../../../helpers/constants/routes");
var _portfolio = require("../../../helpers/utils/portfolio");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _useMultichainSelector = require("../../../hooks/useMultichainSelector");
var _useTokenBalances = require("../../../hooks/useTokenBalances");
var _selectors = require("../../../selectors");
var _assets = require("../../../selectors/assets");
var _multichain2 = require("../../../selectors/multichain");
var _accountTree = require("../../../selectors/multichain-accounts/account-tree");
var _useSafeChains = require("../../settings/networks-tab/networks-form/use-safe-chains");
var _useCurrentPrice = require("../hooks/useCurrentPrice");
var _assetMarketDetails = require("./asset-market-details");
var _assetChart = _interopRequireDefault(require("./chart/asset-chart"));
var _tokenButtons = _interopRequireDefault(require("./token-buttons"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO BIP44 Refactor: This page needs a significant refactor after BIP44 is enabled to remove confusing branching logic
// A page representing a native or token asset
const AssetPage = ({
  asset,
  optionsButton
}) => {
  var _networkConfiguration;
  const t = (0, _useI18nContext.useI18nContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const currency = (0, _reactRedux.useSelector)(_metamask.getCurrentCurrency);
  const isBuyableChain = (0, _reactRedux.useSelector)(_ramps.getIsNativeTokenBuyable);
  const isEvm = (0, _assetUtils.isEvmChainId)(asset.chainId);
  // TODO BIP44 Refactor: This selector does not work with BIP44 enabled, pass the information in the asset object
  const nativeAssetType = (0, _reactRedux.useSelector)(_assets.getMultichainNativeAssetType);
  const isMultichainAccountsState2Enabled = (0, _reactRedux.useSelector)(_selectors.getIsMultichainAccountsState2Enabled);
  const accountGroupIdAssets = (0, _reactRedux.useSelector)(_assets.getAssetsBySelectedAccountGroup);
  const caipChainId = (0, _utils.isCaipChainId)(asset.chainId) ? asset.chainId : (0, _bridgeController.formatChainIdToCaip)(asset.chainId);
  const selectedAccount = (0, _reactRedux.useSelector)(state => (0, _accountTree.getInternalAccountBySelectedAccountGroupAndCaip)(state, caipChainId));
  (0, _react.useEffect)(() => {
    (0, _trace.endTrace)({
      name: _trace.TraceName.AssetDetails
    });
  }, []);
  const {
    chainId,
    type,
    symbol,
    name,
    image,
    decimals
  } = asset;
  const isNative = type === _transaction.AssetType.native;
  const isSwapsChain = (0, _reactRedux.useSelector)(state => (0, _selectors.getIsSwapsChain)(state, chainId));
  const isBridgeChain = (0, _reactRedux.useSelector)(state => (0, _selectors.getIsBridgeChain)(state, chainId));
  const isSigningEnabled = selectedAccount.methods.includes(_keyringApi.EthMethod.SignTransaction) || selectedAccount.methods.includes(_keyringApi.EthMethod.SignUserOperation) || selectedAccount.methods.includes(_keyringApi.SolMethod.SignTransaction) || selectedAccount.methods.includes(_keyringApi.BtcMethod.SignPsbt);
  const isTestnet = (0, _useMultichainSelector.useMultichainSelector)(_multichain2.getMultichainIsTestnet);
  const shouldShowFiat = (0, _useMultichainSelector.useMultichainSelector)(_multichain2.getMultichainShouldShowFiat);
  const isMainnet = !isTestnet;
  // Check if show conversion is enabled
  const showFiatInTestnets = (0, _reactRedux.useSelector)(_selectors.getShowFiatInTestnets);
  const showFiat = shouldShowFiat && (isMainnet || isTestnet && showFiatInTestnets);
  const nativeBalances = (0, _reactRedux.useSelector)(_selectors.getSelectedAccountNativeTokenCachedBalanceByChainId);
  const {
    tokenBalances
  } = (0, _useTokenBalances.useTokenBalances)({
    chainIds: [chainId]
  });
  const selectedAccountTokenBalancesAcrossChains = tokenBalances[selectedAccount.address];
  const multiChainAssets = (0, _useMultichainAssets.default)();
  const mutichainTokenWithFiatAmount = multiChainAssets.filter(item => item.chainId === chainId && item.address !== undefined).find(item => {
    switch (type) {
      case _transaction.AssetType.native:
        return item.isNative;
      case _transaction.AssetType.token:
        return item.address === asset.address;
      default:
        return false;
    }
  }) ?? {
    // TODO: remve the fallback case where the mutichainTokenWithFiatAmount is undefined
    // Root cause: There is a race condition where when switching from a non-EVM network
    // to an EVM network, the mutichainTokenWithFiatAmount is undefined
    // This is a workaround to avoid the error
    // Look into the isEvm selector
    // We might be switching network before account.
    address: '',
    chainId: '',
    symbol: '',
    title: '',
    image: '',
    tokenFiatAmount: 0,
    string: '',
    decimals: 0,
    aggregators: [],
    isNative: false,
    balance: 0,
    secondary: 0
  };
  const isMetaMetricsEnabled = (0, _reactRedux.useSelector)(_selectors.getParticipateInMetaMetrics);
  const isMarketingEnabled = (0, _reactRedux.useSelector)(_selectors.getDataCollectionForMarketing);
  const metaMetricsId = (0, _reactRedux.useSelector)(_selectors.getMetaMetricsId);
  let address = (() => {
    if (type === _transaction.AssetType.token) {
      return isEvm ? (0, _hexstringUtils.toChecksumHexAddress)(asset.address) : asset.address;
    }
    return isEvm ? (0, _assetsControllers.getNativeTokenAddress)(chainId) : nativeAssetType;
  })() ?? '';
  const shouldShowContractAddress = type === _transaction.AssetType.token;
  const contractAddress = (() => {
    if (shouldShowContractAddress) {
      return isEvm ? (0, _hexstringUtils.toChecksumHexAddress)(asset.address) : (0, _utils.parseCaipAssetType)(address).assetReference;
    }
    return '';
  })();
  const {
    currentPrice
  } = (0, _useCurrentPrice.useCurrentPrice)(asset);
  let balance, tokenFiatAmount, assetId;
  if (isMultichainAccountsState2Enabled) {
    var _accountGroupIdAssets, _assetWithBalance$fia;
    const assetWithBalance = (_accountGroupIdAssets = accountGroupIdAssets[chainId]) === null || _accountGroupIdAssets === void 0 ? void 0 : _accountGroupIdAssets.find(item => item.assetId.toLowerCase() === address.toLowerCase() ||
    // TODO: This is a workaround for non-evm native assets, as the address that is received here is blank
    !address && !isEvm && item.isNative);
    assetId = (assetWithBalance === null || assetWithBalance === void 0 ? void 0 : assetWithBalance.assetId) || '';
    address = (assetWithBalance === null || assetWithBalance === void 0 ? void 0 : assetWithBalance.assetId) || '';
    balance = (assetWithBalance === null || assetWithBalance === void 0 ? void 0 : assetWithBalance.balance) ?? '0';
    tokenFiatAmount = (assetWithBalance === null || assetWithBalance === void 0 || (_assetWithBalance$fia = assetWithBalance.fiat) === null || _assetWithBalance$fia === void 0 ? void 0 : _assetWithBalance$fia.balance) ?? 0;
    const tokenHexBalance = assetWithBalance === null || assetWithBalance === void 0 ? void 0 : assetWithBalance.rawBalance;
    asset.balance = {
      value: (0, _conversion.hexToDecimal)(tokenHexBalance),
      display: balance,
      fiat: String(tokenFiatAmount)
    };
  } else {
    var _selectedAccountToken;
    const tokenHexBalance = selectedAccountTokenBalancesAcrossChains === null || selectedAccountTokenBalancesAcrossChains === void 0 || (_selectedAccountToken = selectedAccountTokenBalancesAcrossChains[chainId]) === null || _selectedAccountToken === void 0 ? void 0 : _selectedAccountToken[address];
    balance = (0, _calculateTokenBalance.calculateTokenBalance)({
      isNative,
      chainId,
      address: address,
      decimals,
      nativeBalances,
      selectedAccountTokenBalancesAcrossChains
    });
    tokenFiatAmount = currentPrice ? currentPrice * parseFloat(String(balance)) : 0;

    // this is needed in order to assign the correct balances to TokenButtons before navigating to send/swap screens
    asset.balance = {
      value: (0, _conversion.hexToDecimal)(tokenHexBalance),
      display: String(balance),
      fiat: String(tokenFiatAmount)
    };
  }
  const shouldShowSpendingCaps = isEvm;
  const portfolioSpendingCapsUrl = (0, _react.useMemo)(() => (0, _portfolio.getPortfolioUrl)('', 'asset_page', metaMetricsId, isMetaMetricsEnabled, isMarketingEnabled, selectedAccount.address, 'spending-caps'), [selectedAccount.address, isMarketingEnabled, isMetaMetricsEnabled, metaMetricsId]);
  const networkConfigurationsByChainId = (0, _reactRedux.useSelector)(_multichain2.getMultichainNetworkConfigurationsByChainId);
  const networkName = (_networkConfiguration = networkConfigurationsByChainId[chainId]) === null || _networkConfiguration === void 0 ? void 0 : _networkConfiguration.name;
  const tokenChainImage = (0, _multichain2.getImageForChainId)(chainId);
  const tokenWithFiatAmount = isEvm || isMultichainAccountsState2Enabled ? {
    address: isEvm ? address : assetId,
    chainId,
    symbol,
    image,
    title: name ?? symbol,
    tokenFiatAmount: showFiat ? tokenFiatAmount : null,
    string: balance ? balance.toString() : '',
    decimals: asset.decimals,
    aggregators: type === _transaction.AssetType.token && asset.aggregators ? asset.aggregators : [],
    isNative: type === _transaction.AssetType.native,
    balance,
    secondary: balance ? Number(balance) : 0
  } : mutichainTokenWithFiatAmount;
  const {
    safeChains
  } = (0, _useSafeChains.useSafeChains)();
  const isBIP44FeatureFlagEnabled = (0, _reactRedux.useSelector)(_selectors.getIsMultichainAccountsState2Enabled);
  const showUnifiedTransactionList = isBIP44FeatureFlagEnabled;
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginLeft: "auto",
    marginRight: "auto",
    marginTop: 4,
    className: "asset__content"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    paddingTop: 1,
    paddingBottom: 3,
    paddingLeft: 2,
    paddingRight: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    color: _designSystem.IconColor.iconAlternative,
    marginRight: 1,
    size: _componentLibrary.ButtonIconSize.Sm,
    ariaLabel: t('back'),
    iconName: _componentLibrary.IconName.ArrowLeft,
    onClick: () => history.push(_routes.DEFAULT_ROUTE)
  })), optionsButton), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    "data-testid": "asset-name",
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: _designSystem.TextColor.textAlternative
  }, name && symbol && name !== symbol ? `${name} (${symbol})` : name ?? symbol)), /*#__PURE__*/_react.default.createElement(_assetChart.default, {
    chainId: chainId,
    address: address,
    currentPrice: currentPrice,
    currency: currency,
    asset: tokenWithFiatAmount
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginTop: 4,
    paddingLeft: 4,
    paddingRight: 4
  }, type === _transaction.AssetType.native ? /*#__PURE__*/_react.default.createElement(_coinButtons.default, {
    account: selectedAccount,
    trackingLocation: 'asset-page',
    isBuyableChain,
    isSigningEnabled,
    isSwapsChain,
    isBridgeChain,
    chainId
  }) : /*#__PURE__*/_react.default.createElement(_tokenButtons.default, {
    token: asset,
    account: selectedAccount
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    paddingTop: 3
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingSm,
    paddingBottom: 1,
    paddingTop: 1,
    paddingLeft: 4
  }, t('yourBalance')), [_transaction.AssetType.token, _transaction.AssetType.native].includes(type) && /*#__PURE__*/_react.default.createElement(_tokenCell.default, {
    key: `${symbol}-${address}`,
    token: tokenWithFiatAmount,
    disableHover: true,
    safeChains: safeChains
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginTop: 2,
    marginBottom: 2,
    borderColor: _designSystem.BorderColor.borderMuted,
    marginInline: 4,
    style: {
      height: '1px',
      borderBottomWidth: 0
    }
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginTop: 2,
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 4
  }, [_transaction.AssetType.token, _transaction.AssetType.native].includes(type) && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    paddingLeft: 4,
    paddingRight: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingSm,
    paddingBottom: 2
  }, t('tokenDetails')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 2
  }, renderRow(t('network'), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    gap: 2,
    "data-testid": "asset-network"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
    src: tokenChainImage,
    name: networkName,
    size: _componentLibrary.AvatarNetworkSize.Xs
  }), networkName)), shouldShowContractAddress && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, renderRow(t('contractAddress'), /*#__PURE__*/_react.default.createElement(_multichain.AddressCopyButton, {
    address: contractAddress,
    shorten: true
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 2
  }, asset.decimals !== undefined && renderRow(t('tokenDecimal'), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium
  }, asset.decimals)), asset.aggregators && asset.aggregators.length > 0 && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: _designSystem.TextColor.textAlternative
  }, t('tokenList')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium
  }, asset.aggregators.map(agg => agg.replace(/^metamask$/iu, 'MetaMask')).join(', '))))), shouldShowSpendingCaps && renderRow(t('spendingCaps'), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    className: "asset-page__spending-caps mm-text--body-md-medium",
    href: portfolioSpendingCapsUrl,
    target: "_blank",
    rel: "noopener noreferrer"
  }, t('editInPortfolio'))))), /*#__PURE__*/_react.default.createElement(_assetMarketDetails.AssetMarketDetails, {
    asset: asset,
    address: address
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    borderColor: _designSystem.BorderColor.borderMuted,
    marginInline: 4,
    style: {
      height: '1px',
      borderBottomWidth: 0
    }
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginBottom: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    paddingInline: 4,
    variant: _designSystem.TextVariant.headingSm
  }, t('yourActivity')), showUnifiedTransactionList ? /*#__PURE__*/_react.default.createElement(_unifiedTransactionList.default, {
    tokenAddress: address,
    hideNetworkFilter: true,
    tokenChainIdOverride: chainId
  }) : /*#__PURE__*/_react.default.createElement(_transactionList.default, {
    tokenAddress: address,
    hideNetworkFilter: true,
    overrideFilterForCurrentChain: type === _transaction.AssetType.native
  })))));
};
function renderRow(leftColumn, rightColumn) {
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textAlternative,
    variant: _designSystem.TextVariant.bodyMdMedium
  }, leftColumn), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium
  }, rightColumn));
}
var _default = exports.default = AssetPage;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\asset\\components\\asset-page.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\components\\chart\\asset-chart-empty-state.tsx", {"../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Casset%5Ccomponents%5Cchart%5Casset-chart-empty-state.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetChartEmptyState = void 0;
var React = _interopRequireWildcard(require("react"));
var _componentLibrary = require("../../../../components/component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../hooks/useI18nContext");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AssetChartEmptyState = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/React.createElement(_componentLibrary.Box, {
    className: "asset-chart__empty-or-loading-state-container"
  }, /*#__PURE__*/React.createElement(_componentLibrary.Box, {
    className: "asset-chart__empty-state-content"
  }, /*#__PURE__*/React.createElement("img", {
    src: "./images/asset-chart-empty-state-illustration.png",
    className: "asset-chart__empty-state-illustration"
  }), /*#__PURE__*/React.createElement(_componentLibrary.Text, {
    textAlign: _designSystem.TextAlign.Center,
    variant: _designSystem.TextVariant.bodySmMedium,
    color: _designSystem.TextColor.textAlternative,
    fontWeight: _designSystem.FontWeight.Medium,
    paddingTop: 4,
    paddingRight: 2,
    paddingBottom: 4,
    paddingLeft: 2,
    width: _designSystem.BlockSize.Full
  }, t('assetChartNoHistoricalPrices'))));
};
exports.AssetChartEmptyState = AssetChartEmptyState;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\asset\\components\\chart\\asset-chart-empty-state.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\components\\chart\\asset-chart-loading.tsx", {"../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../components/component-library/skeleton":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\skeleton\\index.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Casset%5Ccomponents%5Cchart%5Casset-chart-loading.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetChartLoading = void 0;
var React = _interopRequireWildcard(require("react"));
var _skeleton = require("../../../../components/component-library/skeleton");
var _componentLibrary = require("../../../../components/component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AssetChartLoading = () => {
  return /*#__PURE__*/React.createElement(_componentLibrary.Box, {
    className: "asset-chart__empty-or-loading-state-container",
    "data-testid": "asset-chart-loading"
  }, /*#__PURE__*/React.createElement(_skeleton.Skeleton, {
    className: "asset-chart__skeleton",
    borderRadius: _designSystem.BorderRadius.LG
  }));
};
exports.AssetChartLoading = AssetChartLoading;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\asset\\components\\chart\\asset-chart-loading.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\components\\chart\\asset-chart-price.tsx", {"../../../../components/app/assets/token-cell/cells":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\token-cell\\cells\\index.ts","../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../components/component-library/skeleton":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\skeleton\\index.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useFormatters":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useFormatters.ts","../../util":"D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\util.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Casset%5Ccomponents%5Cchart%5Casset-chart-price.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _designSystem = require("../../../../helpers/constants/design-system");
var _componentLibrary = require("../../../../components/component-library");
var _util = require("../../util");
var _useFormatters = require("../../../../hooks/useFormatters");
var _skeleton = require("../../../../components/component-library/skeleton");
var _cells = require("../../../../components/app/assets/token-cell/cells");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * A component that shows a skeleton loading state in place of the the main price
 * of an asset. It occupies the same space as the main price would, so the layout
 * does not shift when switching from price-loading to price-available.
 */
const AssetChartMainPriceLoading = () => /*#__PURE__*/_react.default.createElement(_skeleton.Skeleton, {
  width: "25%",
  marginBottom: 1,
  borderRadius: _designSystem.BorderRadius.LG
}, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
  variant: _designSystem.TextVariant.displayMd
}, '\u00A0'));

/**
 * Empty state that replaces the main price when it's not available. It occupies
 * the same space as the main price would, so the layout does not shift when
 * switching from price-unavailable to price-available.
 */
const AssetChartMainPriceEmptyState = () => /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
  variant: _designSystem.TextVariant.displayMd,
  marginBottom: 1
}, '\u00A0');

/**
 * A component that shows a skeleton loading state in place of the the price
 * delta of an asset. It occupies the same space as the price delta would, so
 * the layout does not shift when switching from price-delta-loading to
 * price-delta-available.
 */
const AssetChartDeltaLoading = () => /*#__PURE__*/_react.default.createElement(_skeleton.Skeleton, {
  width: "33%",
  borderRadius: _designSystem.BorderRadius.LG
}, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
  variant: _designSystem.TextVariant.bodyMdMedium
}, '\u00A0'));

/**
 * A component that shows an empty state in place of the the price delta of an
 * asset. It occupies the same space as the price delta would, so the layout
 * does not shift when switching from price-delta-unavailable to
 * price-delta-available.
 */
const AssetChartPriceDeltaEmptyState = () => /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
  variant: _designSystem.TextVariant.bodyMdMedium
}, '\u00A0');

// A component that shows the price of an asset at a
// certain time, along with the delta from a previous price.
const AssetChartPrice = /*#__PURE__*/(0, _react.forwardRef)((props, ref) => {
  const [{
    price,
    date
  }, setPrice] = (0, _react.useState)({
    price: props.price,
    date: props.date
  });
  (0, _react.useImperativeHandle)(ref, () => ({
    setPrice
  }));
  const {
    formatCurrencyTokenPrice
  } = (0, _useFormatters.useFormatters)();
  const {
    loading,
    currency,
    comparePrice
  } = props;
  const priceDelta = price !== undefined && comparePrice !== undefined ? price - comparePrice : undefined;

  // The cases below are intentionally mutually exclusive, in order to flatten the render logic
  const shouldShowMainPriceLoading = loading && price === undefined;
  const shouldShowMainPriceEmptyState = !loading && price === undefined;
  const shouldShowMainPriceMuted = loading && price !== undefined;
  const shouldShowMainPrice = !loading && price !== undefined;

  // Same as above
  const shouldShowDeltaLoading = loading && priceDelta === undefined;
  const shouldShowDeltaEmptyState = !loading && priceDelta === undefined;
  const shouldShowDeltaMuted = loading && priceDelta !== undefined && comparePrice !== undefined;
  const shouldShowDelta = !loading && priceDelta !== undefined && comparePrice !== undefined;
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginLeft: 4,
    marginRight: 4
  }, shouldShowMainPriceLoading && /*#__PURE__*/_react.default.createElement(AssetChartMainPriceLoading, null), shouldShowMainPriceEmptyState && /*#__PURE__*/_react.default.createElement(AssetChartMainPriceEmptyState, null), (shouldShowMainPrice || shouldShowMainPriceMuted) && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    "data-testid": "asset-hovered-price",
    variant: _designSystem.TextVariant.displayMd,
    fontWeight: _designSystem.FontWeight.Medium,
    borderRadius: _designSystem.BorderRadius.LG,
    marginBottom: 1,
    style: {
      opacity: shouldShowMainPriceMuted ? _util.loadingOpacity : 1
    }
  }, formatCurrencyTokenPrice(price, currency)), shouldShowDeltaLoading && /*#__PURE__*/_react.default.createElement(AssetChartDeltaLoading, null), shouldShowDeltaEmptyState && /*#__PURE__*/_react.default.createElement(AssetChartPriceDeltaEmptyState, null), (shouldShowDelta || shouldShowDeltaMuted) && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    style: {
      opacity: loading ? _util.loadingOpacity : 1
    },
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row
  }, props.asset && /*#__PURE__*/_react.default.createElement(_cells.TokenCellPercentChange, {
    token: props.asset,
    price: price,
    comparePrice: comparePrice
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    display: _designSystem.Display.InlineBlock,
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: _designSystem.TextColor.textAlternative,
    marginLeft: 2
  }, (0, _util.getShortDateFormatter)().format(date))));
});
var _default = exports.default = AssetChartPrice;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\asset\\components\\chart\\asset-chart-price.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\components\\chart\\asset-chart.tsx", {"../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../hooks/useTheme":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTheme.ts","../../hooks/useChartTimeRanges":"D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\hooks\\useChartTimeRanges.ts","../../hooks/useHistoricalPrices":"D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\hooks\\useHistoricalPrices.ts","../../util":"D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\util.ts","./asset-chart-empty-state":"D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\components\\chart\\asset-chart-empty-state.tsx","./asset-chart-loading":"D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\components\\chart\\asset-chart-loading.tsx","./asset-chart-price":"D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\components\\chart\\asset-chart-price.tsx","./chart-tooltip":"D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\components\\chart\\chart-tooltip.tsx","./crosshair-plugin":"D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\components\\chart\\crosshair-plugin.ts","@metamask/design-tokens":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\index.cjs","chart.js":"D:\\code\\v\\metamask-extension\\node_modules\\chart.js\\dist\\chart.cjs","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","luxon":"D:\\code\\v\\metamask-extension\\node_modules\\luxon\\build\\cjs-browser\\luxon.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-chartjs-2":"D:\\code\\v\\metamask-extension\\node_modules\\react-chartjs-2\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Casset%5Ccomponents%5Cchart%5Casset-chart.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _chart = require("chart.js");
var _reactChartjs = require("react-chartjs-2");
var _classnames = _interopRequireDefault(require("classnames"));
var _designTokens = require("@metamask/design-tokens");
var _lodash = require("lodash");
var _luxon = require("luxon");
var _useTheme = require("../../../../hooks/useTheme");
var _designSystem = require("../../../../helpers/constants/design-system");
var _componentLibrary = require("../../../../components/component-library");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _useHistoricalPrices = require("../../hooks/useHistoricalPrices");
var _util = require("../../util");
var _useChartTimeRanges = require("../../hooks/useChartTimeRanges");
var _chartTooltip = _interopRequireDefault(require("./chart-tooltip"));
var _crosshairPlugin = require("./crosshair-plugin");
var _assetChartEmptyState = require("./asset-chart-empty-state");
var _assetChartLoading = require("./asset-chart-loading");
var _assetChartPrice = _interopRequireDefault(require("./asset-chart-price"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// @ts-expect-error suppress CommonJS vs ECMAScript error

_chart.Chart.register(_chart.LinearScale, _chart.PointElement, _chart.LineElement, _chart.Filler, _chart.Decimation, _crosshairPlugin.CrosshairPlugin);
const initialChartOptions = {
  normalized: true,
  parsing: false,
  aspectRatio: 2.6,
  layout: {
    autoPadding: false,
    padding: 0
  },
  animation: {
    duration: 0
  },
  fill: true,
  backgroundColor: ({
    chart
  }) => {
    const gradient = chart.ctx.createLinearGradient(0, 0, 0, chart.height);
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31893
    // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
    gradient.addColorStop(0, `${chart.options.borderColor}60`);
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31893
    // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
    gradient.addColorStop(1, `${chart.options.borderColor}00`);
    return gradient;
  },
  elements: {
    line: {
      borderWidth: 1.5
    },
    point: {
      pointStyle: false
    }
  },
  plugins: {
    // Downsample to a maximum number of points
    decimation: {
      algorithm: 'lttb',
      samples: 150,
      threshold: 150,
      enabled: true
    }
  }
};

/**
 * Returns a translated time range label for a given ISO 8601 duration string.
 * The passed duration is normalized and rescaled to get the cleanest, most human-friendly representation.
 *
 * Any passed duration string that is greater than 100 years will be translated to "All".
 *
 * [Normalized](https://moment.github.io/luxon/api-docs/index.html#durationnormalize).
 * It's reduced to its canonical representation in its current units, for instance:
 * - "P2YT5000D" (2 years and 5000 days) becomes "P15YT255D" (15 years and 255 days)
 * - "PT12H-45M" (12 hours and -45 minutes) becomes "P1DT11H15M" (11 hours and 15 minutes)
 *
 * [Rescaled](https://moment.github.io/luxon/api-docs/index.html#durationrescale)
 * Converts to the largest possible unit, for instance:
 * - "PT9000S" (9000 seconds) becomes "P2H30M" (2 hours and 30 minutes)
 *
 * @param translator - A function that translates a key to a string.
 * @param iso8601Duration - The ISO 8601 duration string, e.g. "P1D", "P1M", "P1Y", "P3YT45S", ...
 * @returns The translated time range label, e.g. if locale is 'en': "1D", "1M", "1Y", "3Y 45S", ...
 */
const getTranslatedTimeRangeLabel = (translator, iso8601Duration) => {
  const {
    years,
    months,
    weeks,
    days,
    hours,
    minutes,
    seconds,
    milliseconds
  } = _luxon.Duration.fromISO(iso8601Duration, {
    locale: 'en'
  }).normalize().rescale().toObject();
  if (years && years > 100) {
    return `${translator('all')}`;
  }
  return (0, _lodash.trim)(`${years ? `${years}${translator('durationSuffixYear')} ` : ''}${months ? `${months}${translator('durationSuffixMonth')} ` : ''}${weeks ? `${weeks}${translator('durationSuffixWeek')} ` : ''}${days ? `${days}${translator('durationSuffixDay')} ` : ''}${hours ? `${hours}${translator('durationSuffixHour')} ` : ''}${minutes ? `${minutes}${translator('durationSuffixMinute')} ` : ''}${seconds ? `${seconds}${translator('durationSuffixSecond')} ` : ''}${milliseconds ? `${milliseconds}${translator('durationSuffixMillisecond')}` : ''}`);
};

// A chart showing historic prices for a native or token asset
const AssetChart = ({
  chainId,
  address,
  currentPrice,
  currency,
  asset
}) => {
  var _prices$;
  const t = (0, _useI18nContext.useI18nContext)();
  const theme = (0, _useTheme.useTheme)();
  const timeRanges = (0, _useChartTimeRanges.useChartTimeRanges)(address, currency);
  const [selectedTimeRange, setSelectedTimeRange] = (0, _react.useState)(timeRanges[0] ?? 'P1D');
  const {
    loading,
    data: {
      prices,
      metadata: {
        minPricePoint,
        maxPricePoint,
        xMin,
        xMax,
        yMin,
        yMax
      }
    }
  } = (0, _useHistoricalPrices.useHistoricalPrices)({
    chainId,
    address,
    currency,
    timeRange: selectedTimeRange
  });

  // The cases below are intentionally mutually exclusive, in order to flatten the render logic
  const shouldShowChartLoading = loading && prices.length === 0;
  const shouldShowChartEmptyState = !loading && prices.length === 0; // When the chart is not loading anymore and there are no prices, show an empty state
  const shouldShowChartMuted = loading && prices.length > 0;
  const shouldShowChart = !loading && prices.length > 0;
  const options = {
    ...initialChartOptions,
    borderColor: theme === 'dark' ? _designTokens.brandColor.blue400 : _designTokens.brandColor.blue500,
    scales: {
      x: {
        min: xMin,
        max: xMax,
        display: false,
        type: 'linear'
      },
      y: {
        min: yMin,
        max: yMax,
        display: false
      }
    }
  };
  const chartRef = (0, _react.useRef)();
  const priceRef = (0, _react.useRef)();

  // Init the price ref with the current price
  (0, _react.useEffect)(() => {
    var _priceRef$current;
    priceRef === null || priceRef === void 0 || (_priceRef$current = priceRef.current) === null || _priceRef$current === void 0 || _priceRef$current.setPrice({
      price: currentPrice,
      date: Date.now()
    });
  }, [currentPrice]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    borderRadius: _designSystem.BorderRadius.LG,
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column
  }, /*#__PURE__*/_react.default.createElement(_assetChartPrice.default, {
    ref: priceRef,
    loading: loading,
    currency: currency,
    price: currentPrice,
    date: Date.now(),
    comparePrice: prices === null || prices === void 0 || (_prices$ = prices[0]) === null || _prices$ === void 0 ? void 0 : _prices$.y,
    asset: asset
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    "data-testid": "asset-price-chart",
    marginTop: 4,
    backgroundColor: loading && !prices ? _designSystem.BackgroundColor.backgroundSection : _designSystem.BackgroundColor.transparent,
    borderRadius: _designSystem.BorderRadius.LG,
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column
  }, shouldShowChartLoading && /*#__PURE__*/_react.default.createElement(_assetChartLoading.AssetChartLoading, null), shouldShowChartEmptyState && /*#__PURE__*/_react.default.createElement(_assetChartEmptyState.AssetChartEmptyState, null), (shouldShowChart || shouldShowChartMuted) && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    style: {
      opacity: shouldShowChartMuted ? _util.loadingOpacity : 1
    }
  }, /*#__PURE__*/_react.default.createElement(_chartTooltip.default, {
    point: maxPricePoint,
    xMin: xMin,
    xMax: xMax,
    currency: currency
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    style: {
      aspectRatio: `${options.aspectRatio}`
    },
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: currentPrice ? _designSystem.JustifyContent.flexEnd : _designSystem.JustifyContent.flexStart
  }, /*#__PURE__*/_react.default.createElement(_reactChartjs.Line, {
    ref: chartRef,
    data: {
      datasets: [{
        data: prices
      }]
    },
    options: options,
    updateMode: "none"
    // Update the price display on chart hover
    ,
    onMouseMove: event => {
      var _chartRef$current;
      const data = chartRef === null || chartRef === void 0 || (_chartRef$current = chartRef.current) === null || _chartRef$current === void 0 || (_chartRef$current = _chartRef$current.data) === null || _chartRef$current === void 0 || (_chartRef$current = _chartRef$current.datasets) === null || _chartRef$current === void 0 || (_chartRef$current = _chartRef$current[0]) === null || _chartRef$current === void 0 ? void 0 : _chartRef$current.data;
      if (data) {
        const target = event.target;
        const index = Math.max(0, Math.min(data.length - 1, Math.round(event.nativeEvent.offsetX / target.clientWidth * data.length)));
        const point = data[index];
        if (point) {
          var _priceRef$current2;
          priceRef === null || priceRef === void 0 || (_priceRef$current2 = priceRef.current) === null || _priceRef$current2 === void 0 || _priceRef$current2.setPrice({
            price: point.y,
            date: point.x
          });
        }
      }
    }
    // Revert to current price when not hovering
    ,
    onMouseOut: () => {
      var _priceRef$current3;
      priceRef === null || priceRef === void 0 || (_priceRef$current3 = priceRef.current) === null || _priceRef$current3 === void 0 || _priceRef$current3.setPrice({
        price: currentPrice,
        date: Date.now()
      });
    }
  })), /*#__PURE__*/_react.default.createElement(_chartTooltip.default, {
    point: minPricePoint,
    xMin: xMin,
    xMax: xMax,
    currency: currency
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    style: prices ? undefined : {
      visibility: `hidden`
    },
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    marginTop: 2,
    marginLeft: 3,
    marginRight: 3
  }, timeRanges.map(timeRange => /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonBase, {
    key: timeRange,
    className: (0, _classnames.default)('time-range-button', {
      'time-range-button__selected': timeRange === selectedTimeRange
    }),
    onClick: () => setSelectedTimeRange(timeRange),
    variant: _designSystem.TextVariant.bodyXsMedium,
    size: _componentLibrary.ButtonBaseSize.Sm,
    paddingLeft: 2,
    paddingRight: 2,
    backgroundColor: _designSystem.BackgroundColor.transparent,
    color: _designSystem.TextColor.textAlternative
  }, getTranslatedTimeRangeLabel(t, timeRange))))));
};
var _default = exports.default = AssetChart;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\asset\\components\\chart\\asset-chart.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\components\\chart\\chart-tooltip.tsx", {"../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useFormatters":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useFormatters.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Casset%5Ccomponents%5Cchart%5Cchart-tooltip.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../../../components/component-library");
var _useFormatters = require("../../../../hooks/useFormatters");
var _designSystem = require("../../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// @ts-expect-error suppress CommonJS vs ECMAScript error

// A label indicating the minimum or maximum price on the chart
const ChartTooltip = ({
  point,
  xMin,
  xMax,
  currency
}) => {
  const {
    formatCurrencyTokenPrice
  } = (0, _useFormatters.useFormatters)();
  const xAxisPercent = point && xMin && xMax ? (point.x - xMin) / (xMax - xMin) : 0;
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    style: {
      ...(xAxisPercent < 0.5 ? {
        paddingRight: `${100 - 2 * 100 * xAxisPercent}%`
      } : {
        paddingLeft: `${100 - 2 * (100 - 100 * xAxisPercent)}%`
      }),
      direction: xAxisPercent < 0.5 ? _componentLibrary.TextDirection.LeftToRight : _componentLibrary.TextDirection.RightToLeft
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    marginLeft: 4,
    marginRight: 4,
    marginBottom: 1,
    marginTop: 1,
    variant: _designSystem.TextVariant.bodyXsMedium,
    color: _designSystem.TextColor.textAlternative,
    textAlign: _designSystem.TextAlign.Center
  }, (point === null || point === void 0 ? void 0 : point.y) === undefined ? '\u00A0' : formatCurrencyTokenPrice(point === null || point === void 0 ? void 0 : point.y, currency)));
};
var _default = exports.default = ChartTooltip;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\asset\\components\\chart\\chart-tooltip.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\components\\chart\\crosshair-plugin.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Casset%5Ccomponents%5Cchart%5Ccrosshair-plugin.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrosshairPlugin = void 0;
// @ts-expect-error suppress CommonJS vs ECMAScript error

/** A Chart.js plugin that draws a vertical crosshair on hover */
const CrosshairPlugin = exports.CrosshairPlugin = {
  id: 'crosshair',
  afterEvent(chart, {
    event
  }) {
    chart.crosshairX = event.type === 'mouseout' ? undefined : event.x ?? undefined;
    chart.draw();
  },
  afterDraw(chart) {
    if (chart.crosshairX !== undefined) {
      const data = chart.data.datasets[0].data;
      const index = Math.max(0, Math.min(data.length - 1, Math.round(chart.crosshairX / chart.width * data.length)));
      const point = data[index];
      if (point) {
        const {
          x: xAxis,
          y: yAxis
        } = chart.scales;
        const x = xAxis.getPixelForValue(point.x);
        const y = yAxis.getPixelForValue(point.y);
        chart.ctx.lineWidth = 1;
        // TODO: Replace with design token @MetaMask/metamask-assets - Chart crosshair color should use design system token
        // eslint-disable-next-line @metamask/design-tokens/color-no-hex -- TODO: Needs design token replacement
        chart.ctx.strokeStyle = '#BBC0C5';
        chart.ctx.beginPath();
        chart.ctx.moveTo(x, 0);
        chart.ctx.lineTo(x, chart.height);
        chart.ctx.stroke();
        chart.ctx.beginPath();
        chart.ctx.arc(x, y, 3, 0, 2 * Math.PI);
        chart.ctx.fillStyle = chart.options.borderColor;
        chart.ctx.fill();
      }
    }
  }
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\asset\\components\\chart\\crosshair-plugin.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\components\\native-asset.tsx", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../../shared/lib/asset-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\asset-utils.ts","../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/utils/multichain/blockExplorer":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\multichain\\blockExplorer.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../hooks/useIsOriginalNativeTokenSymbol":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useIsOriginalNativeTokenSymbol.ts","../../../hooks/useMultichainSelector":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainSelector.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","./asset-options":"D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\components\\asset-options.js","./asset-page":"D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\components\\asset-page.tsx","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","@metamask/etherscan-link":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\etherscan-link\\dist\\index.js","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Casset%5Ccomponents%5Cnative-asset.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _etherscanLink = require("@metamask/etherscan-link");
var _utils = require("@metamask/utils");
var _bridgeController = require("@metamask/bridge-controller");
var _selectors = require("../../../selectors");
var _networks = require("../../../../shared/modules/selectors/networks");
var _transaction = require("../../../../shared/constants/transaction");
var _useIsOriginalNativeTokenSymbol = require("../../../hooks/useIsOriginalNativeTokenSymbol");
var _metametrics = require("../../../../shared/constants/metametrics");
var _util = require("../../../helpers/utils/util");
var _metametrics2 = require("../../../contexts/metametrics");
var _blockExplorer = require("../../../helpers/utils/multichain/blockExplorer");
var _useMultichainSelector = require("../../../hooks/useMultichainSelector");
var _multichain = require("../../../selectors/multichain");
var _assetUtils = require("../../../../shared/lib/asset-utils");
var _accountTree = require("../../../selectors/multichain-accounts/account-tree");
var _assetOptions = _interopRequireDefault(require("./asset-options"));
var _assetPage = _interopRequireDefault(require("./asset-page"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NativeAsset = ({
  token,
  chainId
}) => {
  const {
    symbol
  } = token;
  const image = (0, _selectors.getNativeCurrencyForChain)(chainId);
  const {
    type
  } = (0, _reactRedux.useSelector)(_networks.getProviderConfig) ?? {};
  const {
    address
  } = (0, _reactRedux.useSelector)(_selectors.getSelectedInternalAccount);
  const rpcPrefs = (0, _reactRedux.useSelector)(_selectors.getRpcPrefsForCurrentProvider);
  const caipChainId = (0, _utils.isCaipChainId)(chainId) ? chainId : (0, _bridgeController.formatChainIdToCaip)(chainId);
  // TODO BIP44: The new selector returns the accountId, when BIP44 is fully enabled we can fetch the asset higher up and ensure it's passed here
  const selectedAccount = (0, _reactRedux.useSelector)(state => (0, _accountTree.getInternalAccountBySelectedAccountGroupAndCaip)(state, caipChainId));
  const multichainNetworkForSelectedAccount = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainNetwork, selectedAccount);
  const isEvm = (0, _assetUtils.isEvmChainId)(chainId);
  const addressLink = (0, _blockExplorer.getMultichainAccountUrl)(selectedAccount.address, multichainNetworkForSelectedAccount);
  const accountLink = isEvm ? (0, _etherscanLink.getAccountLink)(address, chainId, rpcPrefs) : addressLink;
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const isOriginalNativeSymbol = (0, _useIsOriginalNativeTokenSymbol.useIsOriginalNativeTokenSymbol)(chainId, symbol, type);
  return /*#__PURE__*/_react.default.createElement(_assetPage.default, {
    asset: {
      chainId,
      type: _transaction.AssetType.native,
      symbol,
      image,
      decimals: token.decimals,
      isOriginalNativeSymbol: isOriginalNativeSymbol === true
    },
    optionsButton: /*#__PURE__*/_react.default.createElement(_assetOptions.default, {
      isNativeAsset: true,
      isEvm: isEvm,
      onClickBlockExplorer: () => {
        trackEvent({
          event: 'Clicked Block Explorer Link',
          category: _metametrics.MetaMetricsEventCategory.Navigation,
          properties: {
            // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
            // eslint-disable-next-line @typescript-eslint/naming-convention
            link_type: 'Account Tracker',
            action: 'Asset Options',
            // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
            // eslint-disable-next-line @typescript-eslint/naming-convention
            block_explorer_domain: (0, _util.getURLHostName)(accountLink)
          }
        });
        global.platform.openTab({
          url: accountLink
        });
      }
    })
  });
};
var _default = exports.default = NativeAsset;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\asset\\components\\native-asset.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\components\\token-asset.tsx", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../../shared/lib/asset-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\asset-utils.ts","../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../../shared/modules/string-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\string-utils.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/utils/multichain/blockExplorer":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\multichain\\blockExplorer.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../hooks/useMultichainSelector":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainSelector.ts","../../../hooks/useTokenFiatAmount":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTokenFiatAmount.js","../../../hooks/useTokenTracker":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTokenTracker.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./asset-options":"D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\components\\asset-options.js","./asset-page":"D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\components\\asset-page.tsx","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","@metamask/etherscan-link":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\etherscan-link\\dist\\index.js","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Casset%5Ccomponents%5Ctoken-asset.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _etherscanLink = require("@metamask/etherscan-link");
var _utils = require("@metamask/utils");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _bridgeController = require("@metamask/bridge-controller");
var _metametrics = require("../../../../shared/constants/metametrics");
var _transaction = require("../../../../shared/constants/transaction");
var _networks = require("../../../../shared/modules/selectors/networks");
var _stringUtils = require("../../../../shared/modules/string-utils");
var _metametrics2 = require("../../../contexts/metametrics");
var _util = require("../../../helpers/utils/util");
var _useTokenFiatAmount = require("../../../hooks/useTokenFiatAmount");
var _useTokenTracker = require("../../../hooks/useTokenTracker");
var _selectors = require("../../../selectors");
var _actions = require("../../../store/actions");
var _blockExplorer = require("../../../helpers/utils/multichain/blockExplorer");
var _useMultichainSelector = require("../../../hooks/useMultichainSelector");
var _multichain = require("../../../selectors/multichain");
var _accountTree = require("../../../selectors/multichain-accounts/account-tree");
var _assetUtils = require("../../../../shared/lib/asset-utils");
var _assetOptions = _interopRequireDefault(require("./asset-options"));
var _assetPage = _interopRequireDefault(require("./asset-page"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TokenAsset = ({
  token,
  chainId
}) => {
  var _allNetworks$chainId, _allNetworks$chainId2, _erc20TokensByChain$c;
  const {
    address,
    symbol,
    decimals,
    isERC721,
    image
  } = token;
  const tokenList = (0, _reactRedux.useSelector)(_selectors.getTokenList);
  const allNetworks = (0, _reactRedux.useSelector)(_networks.getNetworkConfigurationsByChainId);
  // get the correct rpc url for the current token
  const defaultIdx = (_allNetworks$chainId = allNetworks[chainId]) === null || _allNetworks$chainId === void 0 ? void 0 : _allNetworks$chainId.defaultBlockExplorerUrlIndex;
  const currentTokenBlockExplorer = defaultIdx === undefined ? null : (_allNetworks$chainId2 = allNetworks[chainId]) === null || _allNetworks$chainId2 === void 0 ? void 0 : _allNetworks$chainId2.blockExplorerUrls[defaultIdx];
  const caipChainId = (0, _utils.isCaipChainId)(chainId) ? chainId : (0, _bridgeController.formatChainIdToCaip)(chainId);
  const selectedAccount = (0, _reactRedux.useSelector)(state => (0, _accountTree.getInternalAccountBySelectedAccountGroupAndCaip)(state, caipChainId));
  const {
    address: walletAddress
  } = selectedAccount;
  const erc20TokensByChain = (0, _reactRedux.useSelector)(_selectors.selectERC20TokensByChain);
  const multichainNetwork = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainNetwork, selectedAccount);
  const isEvm = (0, _assetUtils.isEvmChainId)(chainId);
  const history = (0, _reactRouterDom.useHistory)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);

  // Fetch token data from tokenList
  const tokenData = Object.values(tokenList).find(t => (0, _stringUtils.isEqualCaseInsensitive)(t.symbol, symbol) && (0, _stringUtils.isEqualCaseInsensitive)(t.address, address));

  // If not found in tokenList, try erc20TokensByChain
  const tokenDataFromChain = erc20TokensByChain === null || erc20TokensByChain === void 0 || (_erc20TokensByChain$c = erc20TokensByChain[chainId]) === null || _erc20TokensByChain$c === void 0 || (_erc20TokensByChain$c = _erc20TokensByChain$c.data) === null || _erc20TokensByChain$c === void 0 ? void 0 : _erc20TokensByChain$c[address.toLowerCase()];
  const name = (tokenData === null || tokenData === void 0 ? void 0 : tokenData.name) || (tokenDataFromChain === null || tokenDataFromChain === void 0 ? void 0 : tokenDataFromChain.name) || symbol;
  const iconUrl = (tokenData === null || tokenData === void 0 ? void 0 : tokenData.iconUrl) || (tokenDataFromChain === null || tokenDataFromChain === void 0 ? void 0 : tokenDataFromChain.iconUrl) || image || '';
  const aggregators = tokenData === null || tokenData === void 0 ? void 0 : tokenData.aggregators;
  const {
    tokensWithBalances
  } = (0, _useTokenTracker.useTokenTracker)({
    tokens: [{
      address,
      symbol,
      decimals
    }],
    address: undefined
  });
  const balance = tokensWithBalances === null || tokensWithBalances === void 0 ? void 0 : tokensWithBalances[0];
  const fiat = (0, _useTokenFiatAmount.useTokenFiatAmount)(address, balance === null || balance === void 0 ? void 0 : balance.string, symbol, {}, false);
  const tokenTrackerLink = (0, _etherscanLink.getTokenTrackerLink)(token.address, chainId, '', walletAddress, {
    blockExplorerUrl: currentTokenBlockExplorer ?? ''
  });
  const blockExplorerLink = isEvm ? tokenTrackerLink : (0, _blockExplorer.getMultichainAccountUrl)((0, _utils.parseCaipAssetType)(address).assetReference, multichainNetwork);
  return /*#__PURE__*/_react.default.createElement(_assetPage.default, {
    asset: {
      chainId,
      type: _transaction.AssetType.token,
      address,
      symbol,
      name,
      decimals: token.decimals,
      image: iconUrl,
      aggregators,
      balance: {
        value: balance === null || balance === void 0 ? void 0 : balance.balance,
        display: `${(0, _util.roundToDecimalPlacesRemovingExtraZeroes)(balance === null || balance === void 0 ? void 0 : balance.string, 5)}`,
        fiat
      },
      isERC721
    },
    optionsButton: /*#__PURE__*/_react.default.createElement(_assetOptions.default, {
      isNativeAsset: false,
      isEvm: isEvm,
      onRemove: () => dispatch((0, _actions.showModal)({
        name: 'HIDE_TOKEN_CONFIRMATION',
        token,
        history
      })),
      onClickBlockExplorer: () => {
        trackEvent({
          event: 'Clicked Block Explorer Link',
          category: _metametrics.MetaMetricsEventCategory.Navigation,
          properties: {
            // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
            // eslint-disable-next-line @typescript-eslint/naming-convention
            link_type: 'Token Tracker',
            action: 'Token Options',
            // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
            // eslint-disable-next-line @typescript-eslint/naming-convention
            block_explorer_domain: (0, _util.getURLHostName)(tokenTrackerLink)
          }
        });
        global.platform.openTab({
          url: blockExplorerLink
        });
      },
      tokenSymbol: token.symbol
    })
  });
};
var _default = exports.default = TokenAsset;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\asset\\components\\token-asset.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\components\\token-buttons.tsx", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../../shared/lib/asset-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\asset-utils.ts","../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../components/app/wallet-overview/hooks/useHandleSendNonEvm":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\wallet-overview\\hooks\\useHandleSendNonEvm.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/ui/icon-button/icon-button":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\icon-button\\icon-button.tsx","../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../ducks/ramps":"D:\\code\\v\\metamask-extension\\ui\\ducks\\ramps\\index.ts","../../../ducks/send":"D:\\code\\v\\metamask-extension\\ui\\ducks\\send\\index.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/error-keys":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\error-keys.js","../../../hooks/bridge/useBridging":"D:\\code\\v\\metamask-extension\\ui\\hooks\\bridge\\useBridging.ts","../../../hooks/ramps/useRamps/useRamps":"D:\\code\\v\\metamask-extension\\ui\\hooks\\ramps\\useRamps\\useRamps.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../confirmations/hooks/useRedesignedSendFlow":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useRedesignedSendFlow.ts","../../confirmations/utils/send":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\utils\\send.ts","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Casset%5Ccomponents%5Ctoken-buttons.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _keyringApi = require("@metamask/keyring-api");
var _i18n = require("../../../contexts/i18n");
var _send = require("../../../ducks/send");
var _useRamps = _interopRequireDefault(require("../../../hooks/ramps/useRamps/useRamps"));
var _selectors = require("../../../selectors");
var _useBridging = _interopRequireDefault(require("../../../hooks/bridge/useBridging"));
var _errorKeys = require("../../../helpers/constants/error-keys");
var _actions = require("../../../store/actions");
var _metametrics = require("../../../contexts/metametrics");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _transaction = require("../../../../shared/constants/transaction");
var _designSystem = require("../../../helpers/constants/design-system");
var _iconButton = _interopRequireDefault(require("../../../components/ui/icon-button/icon-button"));
var _componentLibrary = require("../../../components/component-library");
var _ramps = require("../../../ducks/ramps");
var _useHandleSendNonEvm = require("../../../components/app/wallet-overview/hooks/useHandleSendNonEvm");
var _networks = require("../../../../shared/modules/selectors/networks");
var _send2 = require("../../confirmations/utils/send");
var _assetUtils = require("../../../../shared/lib/asset-utils");
var _useRedesignedSendFlow = require("../../confirmations/hooks/useRedesignedSendFlow");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
///: BEGIN:ONLY_INCLUDE_IF(multichain)

///: END:ONLY_INCLUDE_IF

///: BEGIN:ONLY_INCLUDE_IF(multichain)

///: END:ONLY_INCLUDE_IF

const TokenButtons = ({
  token,
  account
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const history = (0, _reactRouterDom.useHistory)();
  const isExternalServicesEnabled = (0, _reactRedux.useSelector)(_selectors.getUseExternalServices);
  const isEvm = (0, _assetUtils.isEvmChainId)(token.chainId);
  const isMultichainAccountsState2Enabled = (0, _reactRedux.useSelector)(_selectors.getIsMultichainAccountsState2Enabled);
  const {
    enabled: isSendRedesignEnabled
  } = (0, _useRedesignedSendFlow.useRedesignedSendFlow)();
  const {
    chainId: multichainChainId
  } = (0, _reactRedux.useSelector)(_selectors.getSelectedMultichainNetworkConfiguration);
  const currentEvmChainId = (0, _reactRedux.useSelector)(_networks.getCurrentChainId);
  const currentChainId = (() => {
    if (isMultichainAccountsState2Enabled) {
      return token.chainId;
    }
    return isEvm ? currentEvmChainId : multichainChainId;
  })();
  const networks = (0, _reactRedux.useSelector)(_selectors.getNetworkConfigurationIdByChainId);
  const isBuyableChain = (0, _reactRedux.useSelector)(_ramps.getIsNativeTokenBuyable);
  const {
    openBuyCryptoInPdapp
  } = (0, _useRamps.default)();
  const {
    openBridgeExperience
  } = (0, _useBridging.default)();

  ///: BEGIN:ONLY_INCLUDE_IF(multichain)
  const handleSendNonEvm = (0, _useHandleSendNonEvm.useHandleSendNonEvm)(token.address);
  ///: END:ONLY_INCLUDE_IF

  (0, _react.useEffect)(() => {
    if (token.isERC721) {
      dispatch((0, _actions.showModal)({
        name: 'CONVERT_TOKEN_TO_NFT',
        tokenAddress: token.address
      }));
    }
  }, [token.isERC721, token.address, dispatch]);

  // TODO BIP 44 Refactor: Remove this code
  const setCorrectChain = (0, _react.useCallback)(async () => {
    // If we aren't presently on the chain of the asset, change to it
    if (currentEvmChainId !== token.chainId && multichainChainId !== token.chainId && !isMultichainAccountsState2Enabled) {
      try {
        const networkConfigurationId = networks[token.chainId];
        await dispatch((0, _actions.setActiveNetworkWithError)(networkConfigurationId));
      } catch (err) {
        console.error(`Failed to switch chains.
        Target chainId: ${token.chainId}, Current chainId: ${currentEvmChainId}.
        ${
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31893
        // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
        err}`);
        throw err;
      }
    }
  }, [isMultichainAccountsState2Enabled, currentEvmChainId, multichainChainId, networks, token.chainId, dispatch]);
  const handleBuyAndSellOnClick = (0, _react.useCallback)(() => {
    openBuyCryptoInPdapp();
    trackEvent({
      event: _metametrics2.MetaMetricsEventName.NavBuyButtonClicked,
      category: _metametrics2.MetaMetricsEventCategory.Navigation,
      properties: {
        location: 'Token Overview',
        text: 'Buy',
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        chain_id: currentChainId,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        token_symbol: token.symbol
      }
    });
  }, [currentChainId, token.symbol, trackEvent, openBuyCryptoInPdapp]);
  const handleSendOnClick = (0, _react.useCallback)(async () => {
    trackEvent({
      event: _metametrics2.MetaMetricsEventName.SendStarted,
      category: _metametrics2.MetaMetricsEventCategory.Navigation,
      properties: {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        token_symbol: token.symbol,
        location: _metametrics2.MetaMetricsSwapsEventSource.TokenView,
        text: 'Send',
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        chain_id: token.chainId
      }
    }, {
      excludeMetaMetricsId: false
    });

    ///: BEGIN:ONLY_INCLUDE_IF(multichain)
    if (!(0, _keyringApi.isEvmAccountType)(account.type) && !isSendRedesignEnabled) {
      await handleSendNonEvm();
      // Early return, not to let the non-EVM flow slip into the native send flow.
      return;
    }
    ///: END:ONLY_INCLUDE_IF

    try {
      await setCorrectChain();
      await dispatch((0, _send.startNewDraftTransaction)({
        type: _transaction.AssetType.token,
        details: token
      }));
      (0, _send2.navigateToSendRoute)(history, isSendRedesignEnabled, {
        address: token.address,
        chainId: token.chainId
      });

      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
    } catch (err) {
      if (!err.message.includes(_errorKeys.INVALID_ASSET_TYPE)) {
        throw err;
      }
    }
  }, [trackEvent, dispatch, history, token, setCorrectChain, account,
  ///: BEGIN:ONLY_INCLUDE_IF(multichain)
  handleSendNonEvm,
  ///: END:ONLY_INCLUDE_IF
  isSendRedesignEnabled]);
  const handleSwapOnClick = (0, _react.useCallback)(async () => {
    await setCorrectChain();
    // Handle clicking from the asset details page
    openBridgeExperience(_metametrics2.MetaMetricsSwapsEventSource.TokenView, token);
  }, [token, setCorrectChain, openBridgeExperience]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    gap: 3,
    justifyContent: _designSystem.JustifyContent.spaceEvenly
  }, /*#__PURE__*/_react.default.createElement(_iconButton.default, {
    className: "token-overview__button",
    Icon: /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
      name: _componentLibrary.IconName.Dollar,
      color: _designSystem.IconColor.iconAlternative,
      size: _componentLibrary.IconSize.Md
    }),
    label: t('buy'),
    "data-testid": "token-overview-buy",
    onClick: handleBuyAndSellOnClick
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    ,
    disabled: token.isERC721 || !isBuyableChain
  }), /*#__PURE__*/_react.default.createElement(_iconButton.default, {
    className: "token-overview__button",
    onClick: handleSendOnClick,
    Icon: /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
      name: _componentLibrary.IconName.Send,
      color: _designSystem.IconColor.iconAlternative,
      size: _componentLibrary.IconSize.Md
    }),
    label: t('send'),
    "data-testid": "eth-overview-send",
    disabled: token.isERC721
  }), /*#__PURE__*/_react.default.createElement(_iconButton.default, {
    className: "token-overview__button",
    Icon: /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
      name: _componentLibrary.IconName.SwapVertical,
      color: _designSystem.IconColor.iconAlternative,
      size: _componentLibrary.IconSize.Md
    }),
    onClick: handleSwapOnClick,
    "data-testid": "token-overview-swap",
    label: t('swap'),
    disabled: !isExternalServicesEnabled
  }));
};
var _default = exports.default = TokenButtons;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\asset\\components\\token-buttons.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\hooks\\useChartTimeRanges.ts", {"../../../selectors/assets":"D:\\code\\v\\metamask-extension\\ui\\selectors\\assets.ts","../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","luxon":"D:\\code\\v\\metamask-extension\\node_modules\\luxon\\build\\cjs-browser\\luxon.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Casset%5Chooks%5CuseChartTimeRanges.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useChartTimeRanges = void 0;
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
var _luxon = require("luxon");
var _reactRedux = require("react-redux");
var _assets = require("../../../selectors/assets");
var _multichain = require("../../../selectors/multichain");
/**
 * Returns the list of time ranges (as ISO 8601 durations) to display in the historical prices chart for a given asset.
 *
 * On EVM, time ranges are hardcoded.
 * On non-EVM, time ranges are dynamically read from the historicalPrices object.
 *
 * @param caipAssetType - The caipAssetType of the asset. Only used on non-EVM chains.
 * @param currency - The currency of the asset. Only used on non-EVM chains.
 * @returns The time ranges available for the given asset, for instance: `['P1D', 'P7D', 'P1M', 'P3M', 'P1Y', 'P1000Y']`
 */
const useChartTimeRanges = (caipAssetType, currency) => {
  var _historicalPricesNonE;
  const DEFAULT_TIME_RANGES = ['P1D', 'P1W', 'P1M', 'P3M', 'P1Y', 'P1000Y'];
  const isEvm = (0, _reactRedux.useSelector)(_multichain.getMultichainIsEvm);
  const historicalPricesNonEvm = (0, _reactRedux.useSelector)(_assets.getHistoricalPrices);
  if (isEvm) {
    // On EVM, time ranges are hardcoded
    return DEFAULT_TIME_RANGES;
  }
  (0, _utils.assert)(caipAssetType, 'caipAssetType is required on non-EVM chains');
  (0, _utils.assert)(currency, 'currency is required on non-EVM chains');

  // On non-EVM, time ranges are the intervals defined in the the historicalPrices state
  const intervals = (_historicalPricesNonE = historicalPricesNonEvm[caipAssetType]) === null || _historicalPricesNonE === void 0 || (_historicalPricesNonE = _historicalPricesNonE[currency]) === null || _historicalPricesNonE === void 0 ? void 0 : _historicalPricesNonE.intervals;
  if (!intervals) {
    return DEFAULT_TIME_RANGES;
  }
  return (0, _lodash.chain)(intervals).keys().map(iso8601String => _luxon.Duration.fromISO(iso8601String)) // Convert to Duration object
  .filter(duration => duration.isValid) // Filter out invalid durations
  .sortBy(duration => duration.toMillis()) // Sort from shortest to longest
  .map(duration => duration.toISO()) // Convert back to ISO string
  .filter(iso8601String => iso8601String !== null) // Filter out nulls
  .uniq() // Remove duplicates
  .value();
};
exports.useChartTimeRanges = useChartTimeRanges;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\asset\\hooks\\useChartTimeRanges.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\hooks\\useCurrentPrice.ts", {"../../../../shared/lib/asset-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\asset-utils.ts","../../../../shared/modules/hexstring-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\hexstring-utils.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/assets":"D:\\code\\v\\metamask-extension\\ui\\selectors\\assets.ts","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Casset%5Chooks%5CuseCurrentPrice.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCurrentPrice = void 0;
var _bridgeController = require("@metamask/bridge-controller");
var _reactRedux = require("react-redux");
var _hexstringUtils = require("../../../../shared/modules/hexstring-utils");
var _selectors = require("../../../selectors");
var _assets = require("../../../selectors/assets");
var _assetUtils = require("../../../../shared/lib/asset-utils");
/**
 * Get the current price of an asset.
 *
 * @param asset - The asset to get the current price of
 * @returns The current price of the asset. If the asset is not found, or the price is not found, returns null.
 */
const useCurrentPrice = asset => {
  var _nonEvmConversionRate;
  const isEvm = (0, _assetUtils.isEvmChainId)(asset.chainId);
  const evmMarketData = (0, _reactRedux.useSelector)(_selectors.getMarketData);
  const evmCurrencyRates = (0, _reactRedux.useSelector)(_selectors.getCurrencyRates);
  const nonEvmConversionRates = (0, _reactRedux.useSelector)(_assets.getAssetsRates);
  const {
    chainId,
    type
  } = asset;
  if (isEvm) {
    var _evmMarketData$chainI, _evmMarketData$chainI2, _evmCurrencyRates$bas;
    if (type === _bridgeController.AssetType.native) {
      var _evmCurrencyRates$ass;
      return {
        currentPrice: (_evmCurrencyRates$ass = evmCurrencyRates[asset.symbol]) === null || _evmCurrencyRates$ass === void 0 ? void 0 : _evmCurrencyRates$ass.conversionRate
      };
    }

    // Market and conversion rate data
    const address = (0, _hexstringUtils.toChecksumHexAddress)(asset.address);
    const tokenMarketPrice = (_evmMarketData$chainI = evmMarketData[chainId]) === null || _evmMarketData$chainI === void 0 || (_evmMarketData$chainI = _evmMarketData$chainI[address]) === null || _evmMarketData$chainI === void 0 ? void 0 : _evmMarketData$chainI.price;
    const baseCurrency = (_evmMarketData$chainI2 = evmMarketData[chainId]) === null || _evmMarketData$chainI2 === void 0 || (_evmMarketData$chainI2 = _evmMarketData$chainI2[address]) === null || _evmMarketData$chainI2 === void 0 ? void 0 : _evmMarketData$chainI2.currency;
    const tokenExchangeRate = (_evmCurrencyRates$bas = evmCurrencyRates[baseCurrency]) === null || _evmCurrencyRates$bas === void 0 ? void 0 : _evmCurrencyRates$bas.conversionRate;
    const currentPrice = tokenExchangeRate !== undefined && tokenMarketPrice !== undefined ? tokenExchangeRate * tokenMarketPrice : undefined;
    return {
      currentPrice
    };
  }
  const assetId = type === _bridgeController.AssetType.token ? asset.address : (0, _bridgeController.getNativeAssetForChainId)(chainId).assetId;
  const currentPriceAsString = nonEvmConversionRates === null || nonEvmConversionRates === void 0 || (_nonEvmConversionRate = nonEvmConversionRates[assetId]) === null || _nonEvmConversionRate === void 0 ? void 0 : _nonEvmConversionRate.rate;
  const currentPrice = currentPriceAsString ? parseFloat(currentPriceAsString) : undefined;
  return {
    currentPrice
  };
};
exports.useCurrentPrice = useCurrentPrice;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\asset\\hooks\\useCurrentPrice.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\hooks\\useHistoricalPrices.ts", {"../../../../shared/constants/time":"D:\\code\\v\\metamask-extension\\shared\\constants\\time.ts","../../../../shared/lib/asset-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\asset-utils.ts","../../../../shared/lib/fetch-with-cache":"D:\\code\\v\\metamask-extension\\shared\\lib\\fetch-with-cache.ts","../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/assets":"D:\\code\\v\\metamask-extension\\ui\\selectors\\assets.ts","../../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../util":"D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\util.ts","@metamask/multichain-network-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-network-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Casset%5Chooks%5CuseHistoricalPrices.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHistoricalPrices = exports.DEFAULT_USE_HISTORICAL_PRICES_METADATA = void 0;
var _react = require("react");
var _multichainNetworkController = require("@metamask/multichain-network-controller");
var _utils = require("@metamask/utils");
var _reactRedux = require("react-redux");
var _time = require("../../../../shared/constants/time");
var _fetchWithCache = _interopRequireDefault(require("../../../../shared/lib/fetch-with-cache"));
var _selectors = require("../../../selectors");
var _assets = require("../../../selectors/assets");
var _util = require("../util");
var _actions = require("../../../store/actions");
var _trace = require("../../../../shared/lib/trace");
var _assetUtils = require("../../../../shared/lib/asset-utils");
var _accountTree = require("../../../selectors/multichain-accounts/account-tree");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// @ts-expect-error suppress CommonJS vs ECMAScript error

const DEFAULT_USE_HISTORICAL_PRICES_METADATA = exports.DEFAULT_USE_HISTORICAL_PRICES_METADATA = {
  minPricePoint: {
    x: -Infinity,
    y: -Infinity
  },
  maxPricePoint: {
    x: Infinity,
    y: Infinity
  },
  xMin: Infinity,
  xMax: -Infinity,
  yMin: Infinity,
  yMax: -Infinity
};
/**
 * Derives some metadata from the prices.
 *
 * @param prices - The prices to derive the metadata from.
 * @returns The metadata derived from the prices.
 */
const deriveMetadata = prices => {
  const xMin = Math.min(...prices.map(p => p.x));
  const xMax = Math.max(...prices.map(p => p.x));
  const yMin = Math.min(...prices.map(p => p.y));
  const yMax = Math.max(...prices.map(p => p.y));
  const minPricePoint = prices.find(p => p.y === yMin) ?? DEFAULT_USE_HISTORICAL_PRICES_METADATA.minPricePoint;
  const maxPricePoint = prices.find(p => p.y === yMax) ?? DEFAULT_USE_HISTORICAL_PRICES_METADATA.maxPricePoint;
  return {
    minPricePoint,
    maxPricePoint,
    xMin,
    xMax,
    yMin,
    yMax
  };
};

/**
 * Internal hook that fetches the historical prices for EVM chains. Returns default values otherwise.
 *
 * @param param0 - The parameters for the useHistoricalPrices hook.
 * @param param0.chainId - The chain ID of the asset.
 * @param param0.address - The address of the asset.
 * @param param0.currency - The currency of the asset.
 * @param param0.timeRange - The chart time range, as an ISO 8601 duration string ("P1D", "P1M", "P1Y", "P3YT45S", ...)
 * @returns The historical prices for the given asset and time range.
 */
const useHistoricalPricesEvm = ({
  chainId,
  address,
  currency,
  timeRange
}) => {
  const isEvm = (0, _assetUtils.isEvmChainId)(chainId);
  const showFiat = (0, _reactRedux.useSelector)(_selectors.getShouldShowFiat);
  const [loading, setLoading] = (0, _react.useState)(false);
  const [prices, setPrices] = (0, _react.useState)([]);
  const [metadata, setMetadata] = (0, _react.useState)(DEFAULT_USE_HISTORICAL_PRICES_METADATA);

  // Fetch the prices, and set them locally as a result of the fetch
  (0, _react.useEffect)(() => {
    if (!isEvm) {
      return;
    }
    const chainSupported = showFiat && (0, _util.chainSupportsPricing)(chainId);
    if (!chainSupported) {
      return;
    }
    const startTime = performance.now();
    const traceContext = (0, _trace.trace)({
      name: _trace.TraceName.GetAssetHistoricalPrices,
      startTime
    });
    (0, _trace.trace)({
      name: _trace.TraceName.GetAssetHistoricalPrices,
      startTime,
      parentContext: traceContext
    });
    setLoading(true);
    const timePeriod = (0, _util.fromIso8601DurationToPriceApiTimePeriod)(timeRange);
    (0, _fetchWithCache.default)({
      url: `https://price.api.cx.metamask.io/v1/chains/${chainId}/historical-prices/${address}?vsCurrency=${currency}&timePeriod=${timePeriod}`,
      cacheOptions: {
        cacheRefreshTime: 5 * _time.MINUTE
      },
      functionName: 'GetAssetHistoricalPrices',
      fetchOptions: {
        headers: {
          'X-Client-Id': 'extension'
        }
      }
    }).catch(() => ({})).then(resp => {
      var _resp$prices;
      const pricesToSet = (resp === null || resp === void 0 || (_resp$prices = resp.prices) === null || _resp$prices === void 0 ? void 0 : _resp$prices.map(p => ({
        x: p === null || p === void 0 ? void 0 : p[0],
        y: p === null || p === void 0 ? void 0 : p[1]
      }))) ?? [];
      setPrices(pricesToSet);
    }).finally(() => {
      (0, _trace.endTrace)({
        name: _trace.TraceName.GetAssetHistoricalPrices,
        timestamp: performance.timeOrigin + startTime
      });
      setLoading(false);
    });
  }, [isEvm, chainId, address, currency, timeRange, showFiat]);

  // Compute the metadata
  (0, _react.useEffect)(() => {
    if (!isEvm) {
      return;
    }
    const metadataToSet = deriveMetadata(prices);
    setMetadata(metadataToSet);
  }, [isEvm, prices]);
  return {
    loading,
    data: {
      prices,
      metadata
    }
  };
};

/**
 * Internal hook that fetches the historical prices for non-EVM chains. Returns default values otherwise.
 *
 * @param param0 - The parameters for the useHistoricalPrices hook.
 * @param param0.chainId - The chain ID of the asset.
 * @param param0.address - The address of the asset.
 * @param param0.currency - The currency of the asset.
 * @param param0.timeRange - The chart time range, as an ISO 8601 duration string ("P1D", "P1M", "P1Y", "P3YT45S", ...)
 * @returns The historical prices for the given asset and time range.
 */
const useHistoricalPricesNonEvm = ({
  chainId,
  address,
  currency,
  timeRange
}) => {
  const isEvm = (0, _assetUtils.isEvmChainId)(chainId);
  const [loading, setLoading] = (0, _react.useState)(false);
  const [prices, setPrices] = (0, _react.useState)([]);
  const [metadata, setMetadata] = (0, _react.useState)(DEFAULT_USE_HISTORICAL_PRICES_METADATA);
  const historicalPricesNonEvm = (0, _reactRedux.useSelector)(_assets.getHistoricalPrices);
  const dispatch = (0, _reactRedux.useDispatch)();
  const internalAccount = (0, _reactRedux.useSelector)(state => (0, _accountTree.getInternalAccountBySelectedAccountGroupAndCaip)(state, (0, _utils.isCaipChainId)(chainId) ? chainId : (0, _multichainNetworkController.toEvmCaipChainId)(chainId)));

  /**
   * Fetch the prices by dispatching an action and then updating the redux state.
   * So we follow up with an other effect that will respond on the redux state update and set the prices locally in this hook.
   */
  (0, _react.useEffect)(() => {
    if (isEvm) {
      return () => {
        // No clean up needed
      };
    }

    // On non-EVM, we fetch the prices from the snap, then store them in the redux state, and grab them from the redux state
    const fetchPrices = async () => {
      setLoading(true);
      try {
        await dispatch((0, _actions.fetchHistoricalPricesForAsset)(address, internalAccount));
      } catch (error) {
        console.error('Error fetching historical prices for %s on %s', address, chainId, error);
      } finally {
        setLoading(false);
      }
    };
    fetchPrices();
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    const intervalId = setInterval(fetchPrices, 60000); // Refresh every minute
    return () => clearInterval(intervalId); // Cleanup on unmount
  }, [isEvm, chainId, address, internalAccount, dispatch]);

  // Retrieve the prices from the state
  (0, _react.useEffect)(() => {
    var _historicalPricesNonE;
    if (isEvm) {
      return;
    }
    const historicalPricesNonEvmThisTokenAndPeriod = (historicalPricesNonEvm === null || historicalPricesNonEvm === void 0 || (_historicalPricesNonE = historicalPricesNonEvm[address]) === null || _historicalPricesNonE === void 0 || (_historicalPricesNonE = _historicalPricesNonE[currency]) === null || _historicalPricesNonE === void 0 ? void 0 : _historicalPricesNonE.intervals[timeRange]) ?? [];
    const pricesToSet = historicalPricesNonEvmThisTokenAndPeriod.map(([x, y]) => ({
      x,
      y: Number(y)
    }));
    setPrices(pricesToSet);
  }, [isEvm, historicalPricesNonEvm, address, currency, timeRange]);

  // Compute the metadata
  (0, _react.useEffect)(() => {
    if (isEvm) {
      return;
    }
    const metadataToSet = deriveMetadata(prices);
    setMetadata(metadataToSet);
  }, [isEvm, prices]);
  return {
    loading,
    data: {
      prices,
      metadata
    }
  };
};

/**
 * Exposed hook that fetches the historical prices for a given asset and over a given duration.
 * Uses the correct internal hook based on the chain type.
 *
 * @param param0 - The parameters for the useHistoricalPrices hook.
 * @param param0.chainId - The chain ID of the asset.
 * @param param0.address - The address of the asset.
 * @param param0.currency - The currency of the asset.
 * @param param0.timeRange - The chart time range, as an ISO 8601 duration string ("P1D", "P1M", "P1Y", "P3YT45S", ...)
 * @returns The historical prices for the given asset and time range.
 */
const useHistoricalPrices = ({
  chainId,
  address,
  currency,
  timeRange
}) => {
  const isEvm = (0, _assetUtils.isEvmChainId)(chainId);
  const historicalPricesEvm = useHistoricalPricesEvm({
    chainId,
    address,
    currency,
    timeRange
  });
  const historicalPricesNonEvm = useHistoricalPricesNonEvm({
    chainId,
    address,
    currency,
    timeRange
  });
  if (isEvm) {
    return historicalPricesEvm;
  }
  return historicalPricesNonEvm;
};
exports.useHistoricalPrices = useHistoricalPrices;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\asset\\hooks\\useHistoricalPrices.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\index.js", {"./asset":"D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\asset.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Casset%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _asset.default;
  }
});
var _asset = _interopRequireDefault(require("./asset"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\asset\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\util.ts", {"@metamask/assets-controllers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","luxon":"D:\\code\\v\\metamask-extension\\node_modules\\luxon\\build\\cjs-browser\\luxon.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Casset%5Cutil.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadingOpacity = exports.getShortDateFormatterV2 = exports.getShortDateFormatter = exports.getPricePrecision = exports.fromIso8601DurationToPriceApiTimePeriod = exports.findAssetByAddress = exports.chainSupportsPricing = void 0;
var _assetsControllers = require("@metamask/assets-controllers");
var _utils = require("@metamask/utils");
var _luxon = require("luxon");
/** Formats a datetime in a short human readable format like 'Feb 8, 12:11 PM' */
const getShortDateFormatter = () => Intl.DateTimeFormat(navigator.language, {
  month: 'short',
  day: 'numeric',
  hour: 'numeric',
  minute: 'numeric'
});

/** Formats a datetime in a short human readable format like 'Feb 8, 2030' */
exports.getShortDateFormatter = getShortDateFormatter;
const getShortDateFormatterV2 = () => Intl.DateTimeFormat(navigator.language, {
  year: 'numeric',
  month: 'short',
  day: 'numeric'
});

/**
 * Returns the number of decimals the fiat price should be formatted to.
 * This tells `currency-formatter` to render prices < 1 cent like $0.00001234
 *
 * @param price - The fiat price to determine formatting precision.
 */
exports.getShortDateFormatterV2 = getShortDateFormatterV2;
const getPricePrecision = price => {
  if (price === 0) {
    return 1;
  }
  let precision = 2;
  for (let p = Math.abs(price); p < 1; precision++) {
    p *= 10;
  }
  return precision;
};

/**
 * Returns true if the price api supports the chain id.
 *
 * @param chainId - The hexadecimal chain id.
 */
exports.getPricePrecision = getPricePrecision;
const chainSupportsPricing = chainId => _assetsControllers.SUPPORTED_CHAIN_IDS.includes(chainId);

/** The opacity components should set during transition */
exports.chainSupportsPricing = chainSupportsPricing;
const loadingOpacity = exports.loadingOpacity = 0.2;
const findAssetByAddress = (data, address, chainId) => {
  if (!chainId) {
    console.error('Chain ID is required.');
    return null;
  }
  const tokens = data[chainId];
  if (!tokens) {
    console.warn(`No tokens found for chainId: ${chainId}`);
    return null;
  }
  if (!address) {
    return tokens.find(token => !token.address);
  }
  return tokens.find(token => token.address && token.address.toLowerCase() === address.toLowerCase());
};

/**
 * Maps an ISO 8601 duration string to a Price API time period string.
 *
 * @param duration - The ISO 8601 duration string, e.g. "P1D", "P1M", "P1Y", "P3YT45S", ...
 * @returns The corresponding Price API time period string.
 */
exports.findAssetByAddress = findAssetByAddress;
const fromIso8601DurationToPriceApiTimePeriod = duration => {
  (0, _utils.assert)(_luxon.Duration.fromISO(duration, {
    locale: 'en'
  }).isValid, `Invalid ISO 8601 duration: ${duration}`);
  const SUPPORTED_MAPPINGS = {
    P1D: '1D',
    P7D: '7D',
    P1W: '7D',
    P1M: '1M',
    P3M: '3M',
    P1Y: '1Y',
    P1000Y: '1000Y'
  };
  const timePeriod = SUPPORTED_MAPPINGS[duration];
  if (!timePeriod) {
    throw new Error(`No Price API timePeriod matching the ISO 8601 duration: ${duration}`);
  }
  return timePeriod;
};
exports.fromIso8601DurationToPriceApiTimePeriod = fromIso8601DurationToPriceApiTimePeriod;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\asset\\util.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\awaiting-signatures\\awaiting-signatures-cancel-button.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Cawaiting-signatures%5Cawaiting-signatures-cancel-button.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _routes = require("../../../helpers/constants/routes");
var _componentLibrary = require("../../../components/component-library");
var _i18n = require("../../../contexts/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AwaitingSignaturesCancelButton = () => {
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const history = (0, _reactRouterDom.useHistory)();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    onClick: () => {
      history.push(`${_routes.CROSS_CHAIN_SWAP_ROUTE}${_routes.PREPARE_SWAP_ROUTE}`);
    }
  }, t('cancel'));
};
var _default = exports.default = AwaitingSignaturesCancelButton;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\awaiting-signatures\\awaiting-signatures-cancel-button.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\awaiting-signatures\\awaiting-signatures.tsx", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/ui/pulse-loader":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\pulse-loader\\index.js","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../ducks/bridge/selectors":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\selectors.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","lodash/isEqual":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\isEqual.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Cawaiting-signatures%5Cawaiting-signatures.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = AwaitingSignatures;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _isEqual = _interopRequireDefault(require("lodash/isEqual"));
var _bridgeController = require("@metamask/bridge-controller");
var _selectors = require("../../../selectors/selectors");
var _pulseLoader = _interopRequireDefault(require("../../../components/ui/pulse-loader"));
var _designSystem = require("../../../helpers/constants/design-system");
var _metametrics = require("../../../contexts/metametrics");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _componentLibrary = require("../../../components/component-library");
var _selectors2 = require("../../../ducks/bridge/selectors");
var _useI18nContext = require("../../../hooks/useI18nContext");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function AwaitingSignatures() {
  var _activeQuote$sentAmou, _activeQuote$sentAmou2;
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    activeQuote
  } = (0, _reactRedux.useSelector)(_selectors2.getBridgeQuotes, _reactRedux.shallowEqual);
  const fromAmount = activeQuote === null || activeQuote === void 0 || (_activeQuote$sentAmou = activeQuote.sentAmount) === null || _activeQuote$sentAmou === void 0 ? void 0 : _activeQuote$sentAmou.amount;
  const fromToken = (0, _reactRedux.useSelector)(_selectors2.getFromToken, _isEqual.default);
  const toToken = (0, _reactRedux.useSelector)(_selectors2.getToToken, _isEqual.default);
  const fromChain = (0, _reactRedux.useSelector)(_selectors2.getFromChain, _isEqual.default);
  const toChain = (0, _reactRedux.useSelector)(_selectors2.getToChain, _isEqual.default);
  const hardwareWalletUsed = (0, _reactRedux.useSelector)(_selectors.isHardwareWallet);
  const hardwareWalletType = (0, _reactRedux.useSelector)(_selectors.getHardwareWalletType);
  const needsTwoConfirmations = Boolean(activeQuote === null || activeQuote === void 0 ? void 0 : activeQuote.approval);
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  (0, _react.useEffect)(() => {
    var _activeQuote$quote, _activeQuote$quote2;
    trackEvent({
      event: 'Awaiting Signature(s) on a HW wallet',
      category: _metametrics2.MetaMetricsEventCategory.Swaps,
      properties: {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        needs_two_confirmations: needsTwoConfirmations,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        token_from: (fromToken === null || fromToken === void 0 ? void 0 : fromToken.symbol) ?? '',
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        token_to: (toToken === null || toToken === void 0 ? void 0 : toToken.symbol) ?? '',
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        is_hardware_wallet: hardwareWalletUsed,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        hardware_wallet_type: hardwareWalletType ?? ''
      },
      sensitiveProperties: {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        token_from_amount: (activeQuote === null || activeQuote === void 0 || (_activeQuote$quote = activeQuote.quote) === null || _activeQuote$quote === void 0 ? void 0 : _activeQuote$quote.srcTokenAmount) ?? '',
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        token_to_amount: (activeQuote === null || activeQuote === void 0 || (_activeQuote$quote2 = activeQuote.quote) === null || _activeQuote$quote2 === void 0 ? void 0 : _activeQuote$quote2.destTokenAmount) ?? ''
      }
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const isSwap = fromChain && !(0, _bridgeController.isCrossChain)(fromChain.chainId, toChain === null || toChain === void 0 ? void 0 : toChain.chainId);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "awaiting-bridge-signatures"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 6,
    paddingRight: 6,
    height: _designSystem.BlockSize.Full,
    justifyContent: _designSystem.JustifyContent.center,
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginTop: 3,
    marginBottom: 4
  }, /*#__PURE__*/_react.default.createElement(_pulseLoader.default, null)), !needsTwoConfirmations && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textDefault,
    variant: _designSystem.TextVariant.headingMd,
    as: "h3"
  }, t('swapConfirmWithHwWallet')), needsTwoConfirmations && activeQuote && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdBold,
    marginTop: 2
  }, t('bridgeConfirmTwoTransactions')), /*#__PURE__*/_react.default.createElement("ul", {
    className: "awaiting-bridge-signatures__steps"
  }, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarBase, {
    size: _componentLibrary.AvatarBaseSize.Sm,
    backgroundColor: _designSystem.BackgroundColor.primaryMuted,
    color: _designSystem.TextColor.primaryDefault,
    marginRight: 2
  }, "1"), t(isSwap ? 'unifiedSwapAllowSwappingOf' : 'bridgeAllowSwappingOf', [(_activeQuote$sentAmou2 = activeQuote.sentAmount) === null || _activeQuote$sentAmou2 === void 0 ? void 0 : _activeQuote$sentAmou2.amount, fromToken === null || fromToken === void 0 ? void 0 : fromToken.symbol, fromChain === null || fromChain === void 0 ? void 0 : fromChain.name])), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarBase, {
    size: _componentLibrary.AvatarBaseSize.Sm,
    backgroundColor: _designSystem.BackgroundColor.primaryMuted,
    color: _designSystem.TextColor.primaryDefault,
    marginRight: 2
  }, "2"), t(isSwap ? 'unifiedSwapFromTo' : 'bridgeFromTo', [fromAmount, fromToken === null || fromToken === void 0 ? void 0 : fromToken.symbol, isSwap ? toToken === null || toToken === void 0 ? void 0 : toToken.symbol : toChain === null || toChain === void 0 ? void 0 : toChain.name]))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyXs
  }, t('bridgeGasFeesSplit')))));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\awaiting-signatures\\awaiting-signatures.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\hooks\\useBridgeTokenDisplayData.ts", {"../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../ducks/bridge-status/selectors":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge-status\\selectors.ts","../../../hooks/useTokenFiatAmount":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTokenFiatAmount.js","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Chooks%5CuseBridgeTokenDisplayData.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBridgeTokenDisplayData = useBridgeTokenDisplayData;
var _reactRedux = require("react-redux");
var _transactionController = require("@metamask/transaction-controller");
var _useTokenFiatAmount = require("../../../hooks/useTokenFiatAmount");
var _transaction = require("../../../../shared/constants/transaction");
var _selectors = require("../../../ducks/bridge-status/selectors");
/**
 * A Bridge transaction group's primaryTransaction contains details of the swap,
 * including the source (from) and destination (to) token type (ETH, DAI, etc..)
 *
 * @param transactionGroup - A Bridge transaction group
 */
function useBridgeTokenDisplayData(transactionGroup) {
  var _bridgeHistoryItem$pr, _bridgeHistoryItem$pr2;
  const {
    primaryTransaction
  } = transactionGroup;

  // If the primary transaction is a bridge transaction, use the bridge history item for the primary transaction id
  // Otherwise, assume that the primary transaction is an approval transaction and use the bridge history item that has the approvalTxId
  const bridgeHistoryItemForPrimaryTxId = (0, _reactRedux.useSelector)(state => (0, _selectors.selectBridgeHistoryItemForTxMetaId)(state, primaryTransaction.id));
  const bridgeHistoryItemWithApprovalTxId = (0, _reactRedux.useSelector)(state => (0, _selectors.selectBridgeHistoryForApprovalTxId)(state, primaryTransaction.id));
  const bridgeHistoryItem = bridgeHistoryItemForPrimaryTxId ?? bridgeHistoryItemWithApprovalTxId;

  // Display currency can be fiat or a token
  const displayCurrencyAmount = (0, _useTokenFiatAmount.useTokenFiatAmount)((bridgeHistoryItem === null || bridgeHistoryItem === void 0 ? void 0 : bridgeHistoryItem.quote.srcAsset.address) ?? primaryTransaction.sourceTokenAddress, (bridgeHistoryItem === null || bridgeHistoryItem === void 0 || (_bridgeHistoryItem$pr = bridgeHistoryItem.pricingData) === null || _bridgeHistoryItem$pr === void 0 ? void 0 : _bridgeHistoryItem$pr.amountSent) ?? primaryTransaction.sourceTokenAmount, (bridgeHistoryItem === null || bridgeHistoryItem === void 0 ? void 0 : bridgeHistoryItem.quote.srcAsset.symbol) ?? primaryTransaction.sourceTokenSymbol, {}, true, primaryTransaction.chainId);
  return {
    category: primaryTransaction.type === _transactionController.TransactionType.bridge ? _transaction.TransactionGroupCategory.bridge : _transaction.TransactionGroupCategory.swap,
    displayCurrencyAmount,
    sourceTokenSymbol: (bridgeHistoryItem === null || bridgeHistoryItem === void 0 ? void 0 : bridgeHistoryItem.quote.srcAsset.symbol) ?? primaryTransaction.sourceTokenSymbol,
    sourceTokenAmountSent: (bridgeHistoryItem === null || bridgeHistoryItem === void 0 || (_bridgeHistoryItem$pr2 = bridgeHistoryItem.pricingData) === null || _bridgeHistoryItem$pr2 === void 0 ? void 0 : _bridgeHistoryItem$pr2.amountSent) ?? primaryTransaction.sourceTokenAmount,
    destinationTokenSymbol: (bridgeHistoryItem === null || bridgeHistoryItem === void 0 ? void 0 : bridgeHistoryItem.quote.destAsset.symbol) ?? primaryTransaction.destinationTokenSymbol
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\hooks\\useBridgeTokenDisplayData.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\hooks\\useDestinationAccount.ts", {"../../../ducks/bridge/selectors":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\selectors.ts","../../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Chooks%5CuseDestinationAccount.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDestinationAccount = void 0;
var _reactRedux = require("react-redux");
var _react = require("react");
var _bridgeController = require("@metamask/bridge-controller");
var _selectors = require("../../../ducks/bridge/selectors");
var _accountTree = require("../../../selectors/multichain-accounts/account-tree");
/**
 * Hook to provide the default internal destination account for a bridge quote, and the state for the destination account picker modal
 *
 * @returns The default destination account and its setter, and the state for the
 * destination account picker modal and its setter.
 */
const useDestinationAccount = () => {
  const [selectedDestinationAccount, setSelectedDestinationAccount] = (0, _react.useState)(null);
  const [isDestinationAccountPickerOpen, setIsDestinationAccountPickerOpen] = (0, _react.useState)(false);
  const toChain = (0, _reactRedux.useSelector)(_selectors.getToChain);

  // For bridges, use the appropriate account type for the destination chain
  const defaultInternalDestinationAccount = (0, _reactRedux.useSelector)(state => toChain !== null && toChain !== void 0 && toChain.chainId ? (0, _accountTree.getInternalAccountBySelectedAccountGroupAndCaip)(state, (0, _bridgeController.formatChainIdToCaip)(toChain.chainId)) : null);
  const displayName = (0, _reactRedux.useSelector)(state => (0, _selectors.getAccountGroupNameByInternalAccount)(state, defaultInternalDestinationAccount));
  (0, _react.useEffect)(() => {
    if (defaultInternalDestinationAccount) {
      setSelectedDestinationAccount({
        ...defaultInternalDestinationAccount,
        isExternal: false,
        displayName: displayName ?? ''
      });
      setIsDestinationAccountPickerOpen(false);
    } else {
      // Open account picker when bridging between non-EVM and EVM chains and there is no matching account (edge case)
      // Cases: non-EVM -> EVM, EVM -> non-EVM, or switching between different non-EVM chains
      setSelectedDestinationAccount(null);
      setIsDestinationAccountPickerOpen(true);
    }
  }, [defaultInternalDestinationAccount, displayName]);
  return {
    selectedDestinationAccount,
    setSelectedDestinationAccount,
    isDestinationAccountPickerOpen,
    setIsDestinationAccountPickerOpen
  };
};
exports.useDestinationAccount = useDestinationAccount;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\hooks\\useDestinationAccount.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\hooks\\useExternalAccountResolution.ts", {"../../../../app/scripts/lib/multichain/address":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\multichain\\address.ts","../../../../shared/lib/multichain/accounts":"D:\\code\\v\\metamask-extension\\shared\\lib\\multichain\\accounts.ts","../../../ducks/domains":"D:\\code\\v\\metamask-extension\\ui\\ducks\\domains.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Chooks%5CuseExternalAccountResolution.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useExternalAccountResolution = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _address = require("../../../../app/scripts/lib/multichain/address");
var _domains = require("../../../ducks/domains");
var _accounts = require("../../../../shared/lib/multichain/accounts");
var _selectors = require("../../../selectors/selectors");
var _useI18nContext = require("../../../hooks/useI18nContext");
// eslint-disable-next-line import/no-restricted-paths

const useExternalAccountResolution = ({
  searchQuery,
  isDestinationSolana,
  isDestinationBitcoin = false
}) => {
  var _domainResolutionsFro;
  const dispatch = (0, _reactRedux.useDispatch)();
  const t = (0, _useI18nContext.useI18nContext)();
  const domainResolutionsFromStore = (0, _reactRedux.useSelector)(_domains.getDomainResolutions);
  const trimmedQuery = searchQuery.trim();
  const validAddress = (0, _react.useMemo)(() => {
    if (!trimmedQuery) {
      return null;
    }
    // Check for Bitcoin addresses
    if (isDestinationBitcoin) {
      if ((0, _accounts.isBtcMainnetAddress)(trimmedQuery) || (0, _accounts.isBtcTestnetAddress)(trimmedQuery)) {
        return trimmedQuery;
      }
      return null;
    }

    // Check for Solana addresses
    if (isDestinationSolana) {
      if ((0, _accounts.isSolanaAddress)(trimmedQuery)) {
        return trimmedQuery;
      }
      return null;
    }

    // Default to checking for Ethereum addresses
    if ((0, _address.isEthAddress)(trimmedQuery)) {
      return trimmedQuery;
    }
    return null;
  }, [trimmedQuery, isDestinationSolana, isDestinationBitcoin]);
  const validEnsName = !isDestinationSolana && !isDestinationBitcoin && trimmedQuery.endsWith('.eth') ? trimmedQuery : null;

  // Lookup ENS name when we detect a valid ENS name
  (0, _react.useEffect)(() => {
    if (validEnsName) {
      dispatch((0, _domains.initializeDomainSlice)());
      dispatch((0, _domains.lookupDomainName)(validEnsName));
    }
  }, [validEnsName]);
  const resolvedAddress = validAddress ?? (domainResolutionsFromStore === null || domainResolutionsFromStore === void 0 || (_domainResolutionsFro = domainResolutionsFromStore[0]) === null || _domainResolutionsFro === void 0 ? void 0 : _domainResolutionsFro.resolvedAddress);
  const internalAccount = (0, _reactRedux.useSelector)(state => (0, _selectors.getInternalAccountByAddress)(state, resolvedAddress));

  // Build an external account object if resolved address is not an internal account
  return (0, _react.useMemo)(() => {
    if (!resolvedAddress || internalAccount) {
      return null;
    }
    return {
      address: resolvedAddress,
      isExternal: true,
      type: 'any:account',
      displayName: validEnsName ?? t('externalAccount')
    };
  }, [validEnsName, resolvedAddress, internalAccount]);
};
exports.useExternalAccountResolution = useExternalAccountResolution;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\hooks\\useExternalAccountResolution.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\hooks\\useGasIncluded7702.ts", {"../../../../shared/modules/selectors":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\index.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../../store/controller-actions/transaction-controller":"D:\\code\\v\\metamask-extension\\ui\\store\\controller-actions\\transaction-controller.ts","../../confirmations/selectors/preferences":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\selectors\\preferences.ts","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Chooks%5CuseGasIncluded7702.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGasIncluded7702 = useGasIncluded7702;
var _bridgeController = require("@metamask/bridge-controller");
var _react = require("react");
var _reactRedux = require("react-redux");
var _selectors = require("../../../../shared/modules/selectors");
var _actions = require("../../../store/actions");
var _transactionController = require("../../../store/controller-actions/transaction-controller");
var _preferences = require("../../confirmations/selectors/preferences");
/**
 * Custom hook to check if gasless 7702 is supported for Smart Accounts
 *
 * @param params - Configuration object
 * @param params.isSwap - Whether this is a swap transaction
 * @param params.selectedAccount - The selected account
 * @param params.fromChain - The source chain
 * @param params.isSendBundleSupportedForChain - Whether send bundle is supported for the chain
 * @returns Whether gasless 7702 is supported
 */
function useGasIncluded7702({
  isSwap,
  selectedAccount,
  fromChain,
  isSendBundleSupportedForChain
}) {
  const [isGasIncluded7702Supported, setIsGasIncluded7702Supported] = (0, _react.useState)(false);
  const isSmartTransaction = (0, _reactRedux.useSelector)(state => (0, _selectors.getIsSmartTransaction)(state, fromChain === null || fromChain === void 0 ? void 0 : fromChain.chainId));
  const smartAccountOptedIn = (0, _reactRedux.useSelector)(_preferences.getUseSmartAccount);
  (0, _react.useEffect)(() => {
    let isCancelled = false;
    const checkGasIncluded7702Support = async () => {
      if (isSendBundleSupportedForChain && isSmartTransaction || !smartAccountOptedIn || !isSwap || !(selectedAccount !== null && selectedAccount !== void 0 && selectedAccount.address) || !(fromChain !== null && fromChain !== void 0 && fromChain.chainId)) {
        if (!isCancelled) {
          setIsGasIncluded7702Supported(false);
        }
        return;
      }
      if ((0, _bridgeController.isSolanaChainId)(fromChain.chainId)) {
        setIsGasIncluded7702Supported(false);
        return;
      }
      try {
        const chainIdInHex = (0, _bridgeController.formatChainIdToHex)(fromChain.chainId);
        const atomicBatchResult = await (0, _transactionController.isAtomicBatchSupported)({
          address: selectedAccount.address,
          chainIds: [chainIdInHex]
        });
        if (isCancelled) {
          return;
        }
        const atomicBatchChainSupport = atomicBatchResult === null || atomicBatchResult === void 0 ? void 0 : atomicBatchResult.find(result => result.chainId.toLowerCase() === fromChain.chainId.toLowerCase());
        const relaySupportsChain = await (0, _actions.isRelaySupported)(chainIdInHex);
        const is7702Supported = Boolean((atomicBatchChainSupport === null || atomicBatchChainSupport === void 0 ? void 0 : atomicBatchChainSupport.isSupported) && relaySupportsChain);
        if (!isCancelled) {
          setIsGasIncluded7702Supported(is7702Supported);
        }
      } catch (error) {
        if (!isCancelled) {
          console.error('Error checking gasless 7702 support:', error);
          setIsGasIncluded7702Supported(false);
        }
      }
    };
    checkGasIncluded7702Support();
    return () => {
      isCancelled = true;
    };
  }, [smartAccountOptedIn, fromChain === null || fromChain === void 0 ? void 0 : fromChain.chainId, isSendBundleSupportedForChain, isSmartTransaction, isSwap, selectedAccount === null || selectedAccount === void 0 ? void 0 : selectedAccount.address]);
  return isGasIncluded7702Supported;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\hooks\\useGasIncluded7702.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\hooks\\useIsSendBundleSupported.ts", {"../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Chooks%5CuseIsSendBundleSupported.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsSendBundleSupported = useIsSendBundleSupported;
var _react = require("react");
var _bridgeController = require("@metamask/bridge-controller");
var _actions = require("../../../store/actions");
/**
 * Custom hook to check if send bundle is supported for a chain
 *
 * @param fromChain - The source chain to check support for
 * @returns Whether send bundle is supported for the chain
 */
function useIsSendBundleSupported(fromChain) {
  const [isSendBundleSupportedForChain, setIsSendBundleSupportedForChain] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    let isCancelled = false;
    const checkSendBundleSupport = async () => {
      if (!(fromChain !== null && fromChain !== void 0 && fromChain.chainId)) {
        if (!isCancelled) {
          setIsSendBundleSupportedForChain(false);
        }
        return;
      }
      if ((0, _bridgeController.isSolanaChainId)(fromChain.chainId)) {
        setIsSendBundleSupportedForChain(false);
        return;
      }
      try {
        const isSupported = await (0, _actions.isSendBundleSupported)((0, _bridgeController.formatChainIdToHex)(fromChain.chainId));
        if (!isCancelled) {
          setIsSendBundleSupportedForChain(isSupported);
        }
      } catch (error) {
        if (!isCancelled) {
          console.error('Error checking send bundle support:', error);
          setIsSendBundleSupportedForChain(false);
        }
      }
    };
    checkSendBundleSupport();
    return () => {
      isCancelled = true;
    };
  }, [fromChain === null || fromChain === void 0 ? void 0 : fromChain.chainId]);
  return isSendBundleSupportedForChain;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\hooks\\useIsSendBundleSupported.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\hooks\\useSubmitBridgeTransaction.ts", {"../../../../shared/lib/sentry":"D:\\code\\v\\metamask-extension\\shared\\lib\\sentry.ts","../../../../shared/modules/selectors":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\index.ts","../../../ducks/bridge-status/actions":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge-status\\actions.ts","../../../ducks/bridge/actions":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\actions.ts","../../../ducks/bridge/selectors":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\selectors.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Chooks%5CuseSubmitBridgeTransaction.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useSubmitBridgeTransaction;
exports.isApprovalTxError = exports.isAllowanceResetError = void 0;
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _bridgeController = require("@metamask/bridge-controller");
var _routes = require("../../../helpers/constants/routes");
var _actions = require("../../../store/actions");
var _actions2 = require("../../../ducks/bridge-status/actions");
var _actions3 = require("../../../ducks/bridge/actions");
var _selectors = require("../../../../shared/modules/selectors");
var _selectors2 = require("../../../ducks/bridge/selectors");
var _sentry = require("../../../../shared/lib/sentry");
const ALLOWANCE_RESET_ERROR = 'Eth USDT allowance reset failed';
const APPROVAL_TX_ERROR = 'Approve transaction failed';
const isAllowanceResetError = error => {
  const errorMessage = error.message ?? '';
  return errorMessage.includes(ALLOWANCE_RESET_ERROR);
};
exports.isAllowanceResetError = isAllowanceResetError;
const isApprovalTxError = error => {
  const errorMessage = error.message ?? '';
  return errorMessage.includes(APPROVAL_TX_ERROR);
};
exports.isApprovalTxError = isApprovalTxError;
const isHardwareWalletUserRejection = error => {
  var _message;
  const errorMessage = ((_message = error.message) === null || _message === void 0 ? void 0 : _message.toLowerCase()) ?? '';
  return (
    // Ledger rejection
    errorMessage.includes('ledger') && (errorMessage.includes('rejected') || errorMessage.includes('denied') || errorMessage.includes('error while signing')) ||
    // Trezor rejection
    errorMessage.includes('trezor') && (errorMessage.includes('cancelled') || errorMessage.includes('rejected')) ||
    // Lattice rejection
    errorMessage.includes('lattice') && errorMessage.includes('rejected') ||
    // Generic hardware wallet rejections
    errorMessage.includes('user rejected') || errorMessage.includes('user cancelled')
  );
};
function useSubmitBridgeTransaction() {
  const history = (0, _reactRouterDom.useHistory)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const hardwareWalletUsed = (0, _reactRedux.useSelector)(_selectors.isHardwareWallet);
  const smartTransactionsEnabled = (0, _reactRedux.useSelector)(_selectors2.getIsStxEnabled);
  const fromAccount = (0, _reactRedux.useSelector)(_selectors2.getFromAccount);
  const submitBridgeTransaction = async quoteResponse => {
    if (!fromAccount) {
      throw new Error('Failed to submit bridge transaction: No selected account');
    }
    if (hardwareWalletUsed) {
      history.push(`${_routes.CROSS_CHAIN_SWAP_ROUTE}${_routes.AWAITING_SIGNATURES_ROUTE}`);
    }

    // Execute transaction(s)
    try {
      // Handle non-EVM source chains (Solana, Bitcoin)
      const isNonEvmSource = (0, _bridgeController.isSolanaChainId)(quoteResponse.quote.srcChainId) || (0, _bridgeController.isBitcoinChainId)(quoteResponse.quote.srcChainId);
      if (isNonEvmSource) {
        // Submit the transaction first, THEN navigate
        await dispatch((0, _actions2.submitBridgeTx)(fromAccount.address, quoteResponse, false));
        await dispatch((0, _actions.setDefaultHomeActiveTabName)('activity'));
        history.push({
          pathname: _routes.DEFAULT_ROUTE,
          state: {
            stayOnHomePage: true
          }
        });
        return;
      }
      await dispatch((0, _actions2.submitBridgeTx)(fromAccount.address, quoteResponse, smartTransactionsEnabled));
    } catch (e) {
      (0, _sentry.captureException)(e);
      if (hardwareWalletUsed && isHardwareWalletUserRejection(e)) {
        dispatch((0, _actions3.setWasTxDeclined)(true));
        history.push(`${_routes.CROSS_CHAIN_SWAP_ROUTE}${_routes.PREPARE_SWAP_ROUTE}`);
      } else {
        await dispatch((0, _actions.setDefaultHomeActiveTabName)('activity'));
        history.push(_routes.DEFAULT_ROUTE);
      }
      return;
    }
    // Route user to activity tab on Home page
    await dispatch((0, _actions.setDefaultHomeActiveTabName)('activity'));
    history.push({
      pathname: _routes.DEFAULT_ROUTE,
      state: {
        stayOnHomePage: true
      }
    });
  };
  return {
    submitBridgeTransaction
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\hooks\\useSubmitBridgeTransaction.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\index.tsx", {"../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../components/multichain/pages/page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\index.ts","../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../ducks/bridge/actions":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\actions.ts","../../ducks/bridge/selectors":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\selectors.ts","../../ducks/swaps/swaps":"D:\\code\\v\\metamask-extension\\ui\\ducks\\swaps\\swaps.js","../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../hooks/bridge/useBridgeExchangeRates":"D:\\code\\v\\metamask-extension\\ui\\hooks\\bridge\\useBridgeExchangeRates.ts","../../hooks/bridge/useBridging":"D:\\code\\v\\metamask-extension\\ui\\hooks\\bridge\\useBridging.ts","../../hooks/bridge/useQuoteFetchEvents":"D:\\code\\v\\metamask-extension\\ui\\hooks\\bridge\\useQuoteFetchEvents.ts","../../hooks/bridge/useTxAlerts":"D:\\code\\v\\metamask-extension\\ui\\hooks\\bridge\\useTxAlerts.ts","../../hooks/useGasFeeEstimates":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useGasFeeEstimates.js","../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../swaps/hooks/useSwapsFeatureFlags":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\hooks\\useSwapsFeatureFlags.ts","./awaiting-signatures/awaiting-signatures":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\awaiting-signatures\\awaiting-signatures.tsx","./awaiting-signatures/awaiting-signatures-cancel-button":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\awaiting-signatures\\awaiting-signatures-cancel-button.tsx","./prepare/bridge-transaction-settings-modal":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\prepare\\bridge-transaction-settings-modal.tsx","./prepare/prepare-bridge-page":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\prepare\\prepare-bridge-page.tsx","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Cindex.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _bridgeController = require("@metamask/bridge-controller");
var _i18n = require("../../contexts/i18n");
var _swaps = require("../../ducks/swaps/swaps");
var _routes = require("../../helpers/constants/routes");
var _actions = require("../../store/actions");
var _componentLibrary = require("../../components/component-library");
var _networks = require("../../../shared/modules/selectors/networks");
var _useBridging = _interopRequireDefault(require("../../hooks/bridge/useBridging"));
var _page = require("../../components/multichain/pages/page");
var _useSwapsFeatureFlags = require("../swaps/hooks/useSwapsFeatureFlags");
var _actions2 = require("../../ducks/bridge/actions");
var _useGasFeeEstimates = require("../../hooks/useGasFeeEstimates");
var _useBridgeExchangeRates = require("../../hooks/bridge/useBridgeExchangeRates");
var _useQuoteFetchEvents = require("../../hooks/bridge/useQuoteFetchEvents");
var _designSystem = require("../../helpers/constants/design-system");
var _useTxAlerts = require("../../hooks/bridge/useTxAlerts");
var _selectors = require("../../ducks/bridge/selectors");
var _prepareBridgePage = _interopRequireDefault(require("./prepare/prepare-bridge-page"));
var _awaitingSignaturesCancelButton = _interopRequireDefault(require("./awaiting-signatures/awaiting-signatures-cancel-button"));
var _awaitingSignatures = _interopRequireDefault(require("./awaiting-signatures/awaiting-signatures"));
var _bridgeTransactionSettingsModal = require("./prepare/bridge-transaction-settings-modal");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CrossChainSwap = () => {
  const t = (0, _react.useContext)(_i18n.I18nContext);

  // Load swaps feature flags so that we can use smart transactions
  (0, _useSwapsFeatureFlags.useSwapsFeatureFlags)();
  (0, _useBridging.default)();
  const history = (0, _reactRouterDom.useHistory)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const isFromTransactionShield = new URLSearchParams(search).get('isFromTransactionShield');
  const selectedNetworkClientId = (0, _reactRedux.useSelector)(_networks.getSelectedNetworkClientId);
  const resetControllerAndInputStates = async () => {
    await dispatch((0, _actions2.resetBridgeState)());
  };
  const {
    activeQuote
  } = (0, _reactRedux.useSelector)(_selectors.getBridgeQuotes);

  // Get chain information to determine if we need gas estimates
  const fromChain = (0, _reactRedux.useSelector)(_selectors.getFromChain);
  // Only fetch gas estimates if the source chain is EVM (not Solana)
  const shouldFetchGasEstimates =
  // TODO: update this with all non-EVM chains when bitcoin added.
  (fromChain === null || fromChain === void 0 ? void 0 : fromChain.chainId) && !(0, _bridgeController.isSolanaChainId)(fromChain.chainId);
  (0, _react.useEffect)(() => {
    dispatch((0, _actions2.trackUnifiedSwapBridgeEvent)(_bridgeController.UnifiedSwapBridgeEventName.PageViewed, {}));
    if (activeQuote) {
      dispatch((0, _actions2.restoreQuoteRequestFromState)(activeQuote.quote));
    }

    // Reset controller and inputs before unloading the page
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    window.addEventListener('beforeunload', resetControllerAndInputStates);
    return () => {
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
      // eslint-disable-next-line @typescript-eslint/no-misused-promises
      window.removeEventListener('beforeunload', resetControllerAndInputStates);
      resetControllerAndInputStates();
    };
  }, []);

  // Needed for refreshing gas estimates (only for EVM chains)
  (0, _useGasFeeEstimates.useGasFeeEstimates)(selectedNetworkClientId, shouldFetchGasEstimates);
  // Needed for fetching exchange rates for tokens that have not been imported
  (0, _useBridgeExchangeRates.useBridgeExchangeRates)();
  // Emits events related to quote-fetching
  (0, _useQuoteFetchEvents.useQuoteFetchEvents)();
  // Sets tx alerts for the active quote
  (0, _useTxAlerts.useTxAlerts)();
  const redirectToDefaultRoute = async () => {
    await resetControllerAndInputStates();
    if (isFromTransactionShield) {
      history.push({
        pathname: _routes.TRANSACTION_SHIELD_ROUTE
      });
    } else {
      history.push({
        pathname: _routes.DEFAULT_ROUTE,
        state: {
          stayOnHomePage: true
        }
      });
    }
    dispatch((0, _swaps.clearSwapsState)());
    await dispatch((0, _actions.resetBackgroundSwapsState)());
  };
  const [isSettingsModalOpen, setIsSettingsModalOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_page.Page, {
    className: "bridge__container"
  }, /*#__PURE__*/_react.default.createElement(_page.Header, {
    textProps: {
      variant: _designSystem.TextVariant.headingSm
    },
    startAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      iconName: _componentLibrary.IconName.ArrowLeft,
      size: _componentLibrary.ButtonIconSize.Sm,
      ariaLabel: t('back')
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
      // eslint-disable-next-line @typescript-eslint/no-misused-promises
      ,
      onClick: redirectToDefaultRoute
    }),
    endAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      iconName: _componentLibrary.IconName.Setting,
      size: _componentLibrary.ButtonIconSize.Sm,
      ariaLabel: t('settings'),
      onClick: () => {
        setIsSettingsModalOpen(true);
      }
    })
  }, t('swap')), /*#__PURE__*/_react.default.createElement(_page.Content, {
    padding: 0
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Route, {
    path: _routes.CROSS_CHAIN_SWAP_ROUTE + _routes.PREPARE_SWAP_ROUTE
  }, /*#__PURE__*/_react.default.createElement(_bridgeTransactionSettingsModal.BridgeTransactionSettingsModal, {
    isOpen: isSettingsModalOpen,
    onClose: () => {
      setIsSettingsModalOpen(false);
    }
  }), /*#__PURE__*/_react.default.createElement(_prepareBridgePage.default, {
    onOpenSettings: () => setIsSettingsModalOpen(true)
  })), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Route, {
    path: _routes.CROSS_CHAIN_SWAP_ROUTE + _routes.AWAITING_SIGNATURES_ROUTE
  }, /*#__PURE__*/_react.default.createElement(_page.Content, null, /*#__PURE__*/_react.default.createElement(_awaitingSignatures.default, null)), /*#__PURE__*/_react.default.createElement(_page.Footer, null, /*#__PURE__*/_react.default.createElement(_awaitingSignaturesCancelButton.default, null))))));
};
var _default = exports.default = CrossChainSwap;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\index.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\layout\\column.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Clayout%5Ccolumn.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const Column = props => {
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Container, _extends({
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    width: _designSystem.BlockSize.Full
  }, props));
};
var _default = exports.default = Column;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\layout\\column.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\layout\\index.tsx", {"./column":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\layout\\column.tsx","./row":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\layout\\row.tsx","./tooltip":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\layout\\tooltip.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Clayout%5Cindex.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "Column", {
  enumerable: true,
  get: function () {
    return _column.default;
  }
});
Object.defineProperty(exports, "Row", {
  enumerable: true,
  get: function () {
    return _row.default;
  }
});
Object.defineProperty(exports, "Tooltip", {
  enumerable: true,
  get: function () {
    return _tooltip.default;
  }
});
var _column = _interopRequireDefault(require("./column"));
var _row = _interopRequireDefault(require("./row"));
var _tooltip = _interopRequireDefault(require("./tooltip"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\layout\\index.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\layout\\row.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Clayout%5Crow.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const Row = props => {
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Container, _extends({
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    flexWrap: _designSystem.FlexWrap.NoWrap,
    alignItems: _designSystem.AlignItems.center
  }, props));
};
var _default = exports.default = Row;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\layout\\row.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\layout\\tooltip.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","./column":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\layout\\column.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Clayout%5Ctooltip.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _column = _interopRequireDefault(require("./column"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const Tooltip = /*#__PURE__*/_react.default.forwardRef(({
  children,
  title,
  triggerElement,
  disabled = false,
  onClose,
  iconName,
  style,
  ...props
}, ref) => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const [referenceElement, setReferenceElement] = (0, _react.useState)(null);
  const handleMouseEnter = () => setIsOpen(true);
  const handleMouseLeave = () => setIsOpen(false);
  const setBoxRef = newRef => setReferenceElement(newRef);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    ref: ref
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    ref: setBoxRef,
    onMouseEnter: handleMouseEnter,
    onMouseLeave: handleMouseLeave,
    display: _designSystem.Display.Flex
  }, triggerElement ?? (iconName && /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    color: _designSystem.IconColor.iconAlternative,
    name: iconName,
    size: _componentLibrary.IconSize.Sm
  })) ?? /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.Info,
    color: _designSystem.IconColor.iconAlternative,
    size: _componentLibrary.IconSize.Sm
  })), !disabled && /*#__PURE__*/_react.default.createElement(_componentLibrary.Popover, _extends({
    position: _componentLibrary.PopoverPosition.Auto,
    referenceElement: referenceElement,
    isOpen: isOpen,
    onClickOutside: handleMouseLeave,
    style: {
      maxWidth: '264px',
      backgroundColor: 'var(--color-text-default)',
      paddingInline: '12px',
      paddingTop: '12px',
      paddingBottom: '12px',
      transitionTimingFunction: 'linear',
      display: 'inherit',
      ...style
    },
    preventOverflow: true,
    flip: true,
    hasArrow: true,
    isPortal: true
  }, props), /*#__PURE__*/_react.default.createElement(_column.default, {
    gap: 2
  }, title && /*#__PURE__*/_react.default.createElement(_componentLibrary.PopoverHeader, {
    color: _designSystem.TextColor.infoInverse,
    textAlign: _designSystem.TextAlign.Center,
    justifyContent: onClose ? _designSystem.JustifyContent.spaceBetween : _designSystem.JustifyContent.center,
    onClose: onClose,
    childrenWrapperProps: {
      style: {
        whiteSpace: 'nowrap'
      }
    }
  }, title), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    justifyContent: _designSystem.JustifyContent.center,
    color: _designSystem.TextColor.infoInverse,
    variant: _designSystem.TextVariant.bodySm
  }, children))));
});
var _default = exports.default = Tooltip;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\layout\\tooltip.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\prepare\\bridge-cta-button.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../ducks/bridge/selectors":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\selectors.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/bridge/useIsTxSubmittable":"D:\\code\\v\\metamask-extension\\ui\\hooks\\bridge\\useIsTxSubmittable.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../hooks/useSubmitBridgeTransaction":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\hooks\\useSubmitBridgeTransaction.ts","../layout":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\layout\\index.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Cprepare%5Cbridge-cta-button.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BridgeCTAButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _componentLibrary = require("../../../components/component-library");
var _selectors = require("../../../ducks/bridge/selectors");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _useSubmitBridgeTransaction = _interopRequireDefault(require("../hooks/useSubmitBridgeTransaction"));
var _designSystem = require("../../../helpers/constants/design-system");
var _useIsTxSubmittable = require("../../../hooks/bridge/useIsTxSubmittable");
var _layout = require("../layout");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BridgeCTAButton = ({
  onFetchNewQuotes,
  needsDestinationAddress = false
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const toToken = (0, _reactRedux.useSelector)(_selectors.getToToken);
  const fromAmount = (0, _reactRedux.useSelector)(_selectors.getFromAmount);
  const {
    isLoading,
    activeQuote
  } = (0, _reactRedux.useSelector)(_selectors.getBridgeQuotes);
  const isQuoteExpired = (0, _reactRedux.useSelector)(state => (0, _selectors.getIsQuoteExpired)(state, Date.now()));
  const {
    submitBridgeTransaction
  } = (0, _useSubmitBridgeTransaction.default)();
  const [isSubmitting, setIsSubmitting] = (0, _react.useState)(false);
  const {
    isNoQuotesAvailable,
    isInsufficientBalance,
    isInsufficientGasBalance,
    isInsufficientGasForQuote,
    isTxAlertPresent
  } = (0, _reactRedux.useSelector)(_selectors.getValidationErrors);
  const wasTxDeclined = (0, _reactRedux.useSelector)(_selectors.getWasTxDeclined);
  const isTxSubmittable = (0, _useIsTxSubmittable.useIsTxSubmittable)();
  const label = (0, _react.useMemo)(() => {
    if (wasTxDeclined) {
      return 'youDeclinedTheTransaction';
    }
    if (isQuoteExpired && !isLoading) {
      return 'bridgeQuoteExpired';
    }
    if (isLoading && !isTxSubmittable && !activeQuote) {
      return undefined;
    }
    if (isInsufficientGasBalance || isNoQuotesAvailable) {
      return undefined;
    }
    if (isInsufficientBalance || isInsufficientGasForQuote) {
      return 'alertReasonInsufficientBalance';
    }
    if (!fromAmount) {
      if (!toToken) {
        return needsDestinationAddress ? 'bridgeSelectTokenAmountAndAccount' : 'bridgeSelectTokenAndAmount';
      }
      return needsDestinationAddress ? 'bridgeEnterAmountAndSelectAccount' : 'bridgeEnterAmount';
    }
    if (needsDestinationAddress) {
      return 'bridgeSelectDestinationAccount';
    }
    if (isTxSubmittable || isTxAlertPresent) {
      return 'swap';
    }
    return 'swapSelectToken';
  }, [isLoading, isTxAlertPresent, fromAmount, toToken, isTxSubmittable, isInsufficientBalance, isInsufficientGasBalance, isInsufficientGasForQuote, wasTxDeclined, isQuoteExpired, needsDestinationAddress, activeQuote, isNoQuotesAvailable]);

  // Label for the secondary button that re-starts quote fetching
  const secondaryButtonLabel = (0, _react.useMemo)(() => {
    if (wasTxDeclined || isQuoteExpired) {
      return 'bridgeFetchNewQuotes';
    }
    return undefined;
  }, [wasTxDeclined, isQuoteExpired]);
  return activeQuote && !secondaryButtonLabel ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    width: _designSystem.BlockSize.Full,
    size: _componentLibrary.ButtonSize.Lg,
    variant: _componentLibrary.ButtonVariant.Primary,
    "data-testid": "bridge-cta-button",
    style: {
      boxShadow: 'none'
    }
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    ,
    onClick: async () => {
      if (activeQuote && isTxSubmittable && !isSubmitting) {
        try {
          // We don't need to worry about setting to false if the tx submission succeeds
          // because we route immediately to Activity list page
          setIsSubmitting(true);
          await submitBridgeTransaction(activeQuote);
        } finally {
          setIsSubmitting(false);
        }
      }
    },
    loading: isSubmitting,
    disabled: !isTxSubmittable || isTxAlertPresent || isQuoteExpired || isSubmitting || needsDestinationAddress
  }, label ? t(label) : '') : /*#__PURE__*/_react.default.createElement(_layout.Row, {
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    gap: 1
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    textAlign: _designSystem.TextAlign.Center,
    color: _designSystem.TextColor.textAlternative
  }, label ? t(label) : ''), secondaryButtonLabel && /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    as: "a",
    variant: _designSystem.TextVariant.bodyMd,
    style: {
      whiteSpace: 'nowrap'
    },
    onClick: onFetchNewQuotes
  }, t(secondaryButtonLabel)));
};
exports.BridgeCTAButton = BridgeCTAButton;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\prepare\\bridge-cta-button.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\prepare\\bridge-cta-info-text.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../ducks/bridge/selectors":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\selectors.ts","../../../ducks/bridge/utils":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\utils.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/hardware":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\hardware.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","../layout":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\layout\\index.tsx","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","bignumber.js":"D:\\code\\v\\metamask-extension\\node_modules\\bignumber.js\\bignumber.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Cprepare%5Cbridge-cta-info-text.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BridgeCTAInfoText = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _bridgeController = require("@metamask/bridge-controller");
var _bignumber = require("bignumber.js");
var _componentLibrary = require("../../../components/component-library");
var _selectors = require("../../../ducks/bridge/selectors");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _designSystem = require("../../../helpers/constants/design-system");
var _layout = require("../layout");
var _selectors2 = require("../../../selectors/selectors");
var _hardware = require("../../../helpers/utils/hardware");
var _utils = require("../../../ducks/bridge/utils");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const BridgeCTAInfoText = () => {
  var _activeQuote$quote$fe;
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    activeQuote
  } = (0, _reactRedux.useSelector)(_selectors.getBridgeQuotes);
  const isQuoteExpired = (0, _reactRedux.useSelector)(state => (0, _selectors.getIsQuoteExpired)(state, Date.now()));
  const keyring = (0, _reactRedux.useSelector)(_selectors2.getCurrentKeyring);
  const isUsingHardwareWallet = (0, _hardware.isHardwareKeyring)(keyring === null || keyring === void 0 ? void 0 : keyring.type);
  const hasMMFee = new _bignumber.BigNumber((activeQuote === null || activeQuote === void 0 ? void 0 : activeQuote.quote.feeData.metabridge.amount) ?? '0').gt(0);
  const hasApproval = activeQuote === null || activeQuote === void 0 ? void 0 : activeQuote.approval;
  if (!activeQuote) {
    return null;
  }
  if (!hasMMFee && !hasApproval) {
    return null;
  }
  if (isQuoteExpired) {
    return null;
  }

  // Get the fee percentage from the quote or fallback to default
  // @ts-expect-error: controller types are not up to date yet
  const quoteBpsFee = (_activeQuote$quote$fe = activeQuote.quote.feeData) === null || _activeQuote$quote$fe === void 0 || (_activeQuote$quote$fe = _activeQuote$quote$fe.metabridge) === null || _activeQuote$quote$fe === void 0 ? void 0 : _activeQuote$quote$fe.quoteBpsFee;
  const feePercentage = (0, _utils.bpsToPercentage)(quoteBpsFee) ?? _bridgeController.BRIDGE_MM_FEE_RATE;
  return hasMMFee || hasApproval ? /*#__PURE__*/_react.default.createElement(_layout.Row, {
    gap: 1,
    justifyContent: _designSystem.JustifyContent.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyXs,
    color: _designSystem.TextColor.textAlternative
  }, [hasMMFee ? t('rateIncludesMMFee', [feePercentage]) : null, hasApproval && ((0, _bridgeController.isCrossChain)(activeQuote.quote.srcChainId, activeQuote.quote.destChainId) ? t('willApproveAmountForBridging') : t('willApproveAmountForSwapping'))].filter(Boolean).join(' ')), hasApproval ? /*#__PURE__*/_react.default.createElement(_layout.Tooltip, {
    display: _designSystem.Display.InlineBlock,
    position: _componentLibrary.PopoverPosition.Top,
    offset: [-48, 8],
    title: t('grantExactAccess')
  }, isUsingHardwareWallet ? t('bridgeApprovalWarningForHardware', [activeQuote.sentAmount.amount, activeQuote.quote.srcAsset.symbol]) : t('bridgeApprovalWarning', [activeQuote.sentAmount.amount, activeQuote.quote.srcAsset.symbol])) : null) : null;
};
exports.BridgeCTAInfoText = BridgeCTAInfoText;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\prepare\\bridge-cta-info-text.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\prepare\\bridge-input-group.tsx", {"../../../../shared/constants/multichain/networks":"D:\\code\\v\\metamask-extension\\shared\\constants\\multichain\\networks.ts","../../../../shared/constants/time":"D:\\code\\v\\metamask-extension\\shared\\constants\\time.ts","../../../../shared/lib/multichain/networks":"D:\\code\\v\\metamask-extension\\shared\\lib\\multichain\\networks.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/multichain/asset-picker-amount/asset-picker":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\asset-picker\\index.ts","../../../components/multichain/asset-picker-amount/asset-picker-modal/asset-picker-modal-tabs":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\asset-picker-modal\\asset-picker-modal-tabs.tsx","../../../ducks/bridge/selectors":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\selectors.ts","../../../ducks/locale/locale":"D:\\code\\v\\metamask-extension\\ui\\ducks\\locale\\locale.ts","../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../hooks/useCopyToClipboard":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useCopyToClipboard.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../layout":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\layout\\index.tsx","../utils/quote":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\utils\\quote.ts","./components/bridge-asset-picker-button":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\prepare\\components\\bridge-asset-picker-button.tsx","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","@metamask/etherscan-link":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\etherscan-link\\dist\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Cprepare%5Cbridge-input-group.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BridgeInputGroup = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _bridgeController = require("@metamask/bridge-controller");
var _etherscanLink = require("@metamask/etherscan-link");
var _componentLibrary = require("../../../components/component-library");
var _assetPicker = require("../../../components/multichain/asset-picker-amount/asset-picker");
var _assetPickerModalTabs = require("../../../components/multichain/asset-picker-amount/asset-picker-modal/asset-picker-modal-tabs");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _metamask = require("../../../ducks/metamask/metamask");
var _quote = require("../utils/quote");
var _layout = require("../layout");
var _designSystem = require("../../../helpers/constants/design-system");
var _selectors = require("../../../ducks/bridge/selectors");
var _util = require("../../../helpers/utils/util");
var _useCopyToClipboard = require("../../../hooks/useCopyToClipboard");
var _time = require("../../../../shared/constants/time");
var _locale = require("../../../ducks/locale/locale");
var _networks = require("../../../../shared/constants/multichain/networks");
var _networks2 = require("../../../../shared/lib/multichain/networks");
var _multichain = require("../../../selectors/multichain");
var _bridgeAssetPickerButton = require("./components/bridge-asset-picker-button");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const sanitizeAmountInput = textToSanitize => {
  // Remove characters that are not numbers or decimal points if rendering a controlled or pasted value
  return textToSanitize.replace(/[^\d.]+/gu, '')
  // Only allow one decimal point, ignore digits after second decimal point
  .split('.', 2).join('.');
};
const BridgeInputGroup = ({
  header,
  token,
  onAssetChange,
  onAmountChange,
  networkProps,
  isTokenListLoading,
  customTokenListGenerator,
  amountFieldProps,
  amountInFiat,
  onMaxButtonClick,
  isMultiselectEnabled,
  onBlockExplorerClick,
  buttonProps,
  containerProps = {},
  isDestinationToken = false
}) => {
  var _networkProps$network;
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    isLoading
  } = (0, _reactRedux.useSelector)(_selectors.getBridgeQuotes);
  const {
    isInsufficientBalance,
    isEstimatedReturnLow
  } = (0, _reactRedux.useSelector)(_selectors.getValidationErrors);
  const currency = (0, _reactRedux.useSelector)(_metamask.getCurrentCurrency);
  const locale = (0, _reactRedux.useSelector)(_locale.getIntlLocale);
  const currentChainId = (0, _reactRedux.useSelector)(_multichain.getMultichainCurrentChainId);
  const selectedChainId = (networkProps === null || networkProps === void 0 || (_networkProps$network = networkProps.network) === null || _networkProps$network === void 0 ? void 0 : _networkProps$network.chainId) ?? currentChainId;
  const [, handleCopy] = (0, _useCopyToClipboard.useCopyToClipboard)(_time.MINUTE);
  const inputRef = (0, _react.useRef)(null);
  const balanceAmount = (0, _reactRedux.useSelector)(_selectors.getFromTokenBalance);
  const isAmountReadOnly =
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  (amountFieldProps === null || amountFieldProps === void 0 ? void 0 : amountFieldProps.readOnly) || (amountFieldProps === null || amountFieldProps === void 0 ? void 0 : amountFieldProps.disabled);
  (0, _react.useEffect)(() => {
    if (!isAmountReadOnly && inputRef.current) {
      var _amountFieldProps$val;
      inputRef.current.value = (amountFieldProps === null || amountFieldProps === void 0 || (_amountFieldProps$val = amountFieldProps.value) === null || _amountFieldProps$val === void 0 ? void 0 : _amountFieldProps$val.toString()) ?? '';
      inputRef.current.focus();
    }
  }, [amountFieldProps === null || amountFieldProps === void 0 ? void 0 : amountFieldProps.value, isAmountReadOnly, token]);
  (0, _react.useEffect)(() => {
    return () => {
      inputRef.current = null;
    };
  }, []);
  const handleAddressClick = () => {
    if (token && selectedChainId) {
      const caipChainId = (0, _bridgeController.formatChainIdToCaip)(selectedChainId);
      const isSolana = caipChainId === _networks.MultichainNetworks.SOLANA;
      let blockExplorerUrl = '';
      if (isSolana) {
        const blockExplorerUrls = _networks.MULTICHAIN_NETWORK_BLOCK_EXPLORER_FORMAT_URLS_MAP[caipChainId];
        if (blockExplorerUrls) {
          blockExplorerUrl = (0, _networks2.formatBlockExplorerAddressUrl)(blockExplorerUrls, token.address);
        }
      } else {
        var _networkProps$network2, _networkProps$network3;
        const explorerUrl = networkProps === null || networkProps === void 0 || (_networkProps$network2 = networkProps.network) === null || _networkProps$network2 === void 0 || (_networkProps$network2 = _networkProps$network2.blockExplorerUrls) === null || _networkProps$network2 === void 0 ? void 0 : _networkProps$network2[(networkProps === null || networkProps === void 0 || (_networkProps$network3 = networkProps.network) === null || _networkProps$network3 === void 0 ? void 0 : _networkProps$network3.defaultBlockExplorerUrlIndex) ?? 0];
        if (explorerUrl) {
          blockExplorerUrl = (0, _etherscanLink.getAccountLink)(token.address, selectedChainId, {
            blockExplorerUrl: explorerUrl
          }, undefined);
        }
      }
      if (blockExplorerUrl) {
        handleCopy(blockExplorerUrl);
        onBlockExplorerClick === null || onBlockExplorerClick === void 0 || onBlockExplorerClick(token);
      }
    }
  };
  return /*#__PURE__*/_react.default.createElement(_layout.Column, _extends({
    gap: 1
  }, containerProps), /*#__PURE__*/_react.default.createElement(_layout.Row, {
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.TextField, _extends({
    inputProps: {
      disableStateStyles: true,
      textAlign: _designSystem.TextAlign.Start,
      style: {
        fontWeight: 400,
        fontSize: Math.max(14,
        // Minimum font size
        36 * (
        // Maximum font size
        // Up to 9 characters, use 36px
        9 /
         // Otherwise, shrink the font size down to 14
        Math.max(9, ((amountFieldProps === null || amountFieldProps === void 0 ? void 0 : amountFieldProps.value) ?? '').toString().length))),
        transition: 'font-size 0.1s',
        padding: 0
      }
    },
    style: {
      minWidth: 96,
      maxWidth: 190,
      opacity: isAmountReadOnly && amountFieldProps !== null && amountFieldProps !== void 0 && amountFieldProps.value ? 1 : undefined
    },
    display: _designSystem.Display.Flex,
    inputRef: inputRef,
    type: _componentLibrary.TextFieldType.Text,
    className: "amount-input",
    placeholder: "0",
    onKeyPress: e => {
      if (e) {
        var _amountFieldProps$val2;
        // Only allow numbers and at most one decimal point
        if (e.key === '.' && (_amountFieldProps$val2 = amountFieldProps.value) !== null && _amountFieldProps$val2 !== void 0 && _amountFieldProps$val2.toString().includes('.')) {
          e.preventDefault();
        } else if (!/^[\d.]{1}$/u.test(e.key)) {
          e.preventDefault();
        }
      }
    },
    onPaste: e => {
      e.preventDefault();
      const cleanedValue = sanitizeAmountInput(e.clipboardData.getData('text'));
      onAmountChange === null || onAmountChange === void 0 || onAmountChange(cleanedValue ?? '');
    },
    onChange: e => {
      e.preventDefault();
      e.stopPropagation();
      const cleanedValue = sanitizeAmountInput(e.target.value);
      onAmountChange === null || onAmountChange === void 0 || onAmountChange(cleanedValue ?? '');
    }
  }, amountFieldProps)), /*#__PURE__*/_react.default.createElement(_assetPicker.AssetPicker, {
    header: header,
    visibleTabs: [_assetPickerModalTabs.TabName.TOKENS],
    asset: token ?? undefined,
    onAssetChange: onAssetChange,
    networkProps: networkProps,
    customTokenListGenerator: customTokenListGenerator,
    isTokenListLoading: isTokenListLoading,
    isMultiselectEnabled: isMultiselectEnabled,
    isDestinationToken: isDestinationToken
  }, (onClickHandler, networkImageSrc) => isAmountReadOnly && !token ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    "data-testid": buttonProps.testId,
    onClick: onClickHandler,
    size: _componentLibrary.ButtonSize.Lg,
    paddingLeft: 6,
    paddingRight: 6,
    fontWeight: _designSystem.FontWeight.Normal,
    style: {
      whiteSpace: 'nowrap'
    }
  }, t('swapSwapTo')) : /*#__PURE__*/_react.default.createElement(_bridgeAssetPickerButton.BridgeAssetPickerButton, {
    onClick: onClickHandler,
    networkImageSrc: networkImageSrc,
    asset: token ?? undefined,
    networkProps: networkProps,
    "data-testid": buttonProps.testId
  }))), /*#__PURE__*/_react.default.createElement(_layout.Row, {
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    style: {
      height: 24
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    fontWeight: _designSystem.FontWeight.Normal,
    color: isAmountReadOnly && isEstimatedReturnLow ? _designSystem.TextColor.warningDefault : _designSystem.TextColor.textAlternative,
    textAlign: _designSystem.TextAlign.End,
    ellipsis: true
  }, isAmountReadOnly && isLoading && amountFieldProps.value === '0' ? t('bridgeCalculatingAmount') : undefined, amountInFiat && (0, _quote.formatCurrencyAmount)(amountInFiat, currency, 2)), !isAmountReadOnly && balanceAmount && token && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    display: _designSystem.Display.Flex,
    gap: 1,
    variant: _designSystem.TextVariant.bodyMd,
    color: isInsufficientBalance ? _designSystem.TextColor.errorDefault : _designSystem.TextColor.textAlternative,
    style: {
      cursor: 'default',
      textDecoration: 'none'
    }
  }, (0, _quote.formatTokenAmount)(locale, balanceAmount, token.symbol), onMaxButtonClick && /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    variant: _designSystem.TextVariant.bodyMd,
    onClick: () => onMaxButtonClick(balanceAmount)
  }, t('max'))), isAmountReadOnly && token && selectedChainId && !(0, _bridgeController.isNativeAddress)(token.address) && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    display: _designSystem.Display.Flex,
    gap: 1,
    variant: _designSystem.TextVariant.bodyMd,
    color: _designSystem.TextColor.textAlternative,
    onClick: () => {
      handleAddressClick();
    },
    as: 'a',
    style: {
      cursor: isAmountReadOnly ? 'pointer' : 'default',
      textDecoration: isAmountReadOnly ? 'underline' : 'none'
    }
  }, (0, _util.shortenString)(token.address, {
    truncatedCharLimit: 11,
    truncatedStartChars: 4,
    truncatedEndChars: 4,
    skipCharacterInEnd: false
  }))));
};
exports.BridgeInputGroup = BridgeInputGroup;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\prepare\\bridge-input-group.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\prepare\\bridge-no-fee-message.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../ducks/bridge/selectors":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\selectors.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../layout":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\layout\\index.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Cprepare%5Cbridge-no-fee-message.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BridgeNoFeeMessage = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _componentLibrary = require("../../../components/component-library");
var _selectors = require("../../../ducks/bridge/selectors");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _designSystem = require("../../../helpers/constants/design-system");
var _layout = require("../layout");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const BridgeNoFeeMessage = () => {
  var _activeQuote$quote$de, _activeQuote$quote$de2;
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    activeQuote
  } = (0, _reactRedux.useSelector)(_selectors.getBridgeQuotes);
  const noFeeAssets = (0, _reactRedux.useSelector)(state => {
    var _activeQuote$quote;
    return (0, _selectors.selectNoFeeAssets)(state, activeQuote === null || activeQuote === void 0 || (_activeQuote$quote = activeQuote.quote) === null || _activeQuote$quote === void 0 || (_activeQuote$quote = _activeQuote$quote.destChainId) === null || _activeQuote$quote === void 0 ? void 0 : _activeQuote$quote.toString());
  });
  if (!activeQuote) {
    return null;
  }
  const isNoFeeAsset = noFeeAssets.includes(((_activeQuote$quote$de = activeQuote.quote.destAsset.address) === null || _activeQuote$quote$de === void 0 ? void 0 : _activeQuote$quote$de.toLowerCase()) ?? '');
  if (!isNoFeeAsset) {
    return null;
  }
  const destSymbol = ((_activeQuote$quote$de2 = activeQuote.quote.destAsset) === null || _activeQuote$quote$de2 === void 0 ? void 0 : _activeQuote$quote$de2.symbol) || 'token';
  return /*#__PURE__*/_react.default.createElement(_layout.Row, {
    gap: 1,
    justifyContent: _designSystem.JustifyContent.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyXs,
    color: _designSystem.TextColor.textAlternative
  }, t('noMMFeeSwapping', [destSymbol])));
};
exports.BridgeNoFeeMessage = BridgeNoFeeMessage;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\prepare\\bridge-no-fee-message.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\prepare\\bridge-transaction-settings-modal.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../ducks/bridge/actions":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\actions.ts","../../../ducks/bridge/selectors":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\selectors.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../layout":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\layout\\index.tsx","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Cprepare%5Cbridge-transaction-settings-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BridgeTransactionSettingsModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _bridgeController = require("@metamask/bridge-controller");
var _componentLibrary = require("../../../components/component-library");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _designSystem = require("../../../helpers/constants/design-system");
var _selectors = require("../../../ducks/bridge/selectors");
var _actions = require("../../../ducks/bridge/actions");
var _layout = require("../layout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HARDCODED_SLIPPAGE_OPTIONS = [_bridgeController.BRIDGE_DEFAULT_SLIPPAGE, 2];
const BridgeTransactionSettingsModal = ({
  onClose,
  isOpen
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const isSolanaSwap = (0, _reactRedux.useSelector)(_selectors.getIsSolanaSwap);
  const slippage = (0, _reactRedux.useSelector)(_selectors.getSlippage);

  // AUTO option should only show for Solana-to-Solana swaps
  const shouldShowAutoOption = isSolanaSwap;
  const [localSlippage, setLocalSlippage] = (0, _react.useState)(undefined);
  const [customSlippage, setCustomSlippage] = (0, _react.useState)(undefined);
  const [showCustomButton, setShowCustomButton] = (0, _react.useState)(true);
  const [isAutoSelected, setIsAutoSelected] = (0, _react.useState)(false);

  // Initialize state when modal opens
  (0, _react.useEffect)(() => {
    if (isOpen) {
      // Simply display what's in the state
      if (shouldShowAutoOption && slippage === undefined) {
        setIsAutoSelected(true);
        setLocalSlippage(undefined);
        setCustomSlippage(undefined);
      } else {
        setIsAutoSelected(false);
        if (!slippage || slippage === 0) {
          // Default to first option if no slippage set, null, or 0
          // This handles undefined, null, 0, and other falsy values
          setLocalSlippage(_bridgeController.BRIDGE_DEFAULT_SLIPPAGE);
          setCustomSlippage(undefined);
        } else if (HARDCODED_SLIPPAGE_OPTIONS.includes(slippage)) {
          setLocalSlippage(slippage);
          setCustomSlippage(undefined);
        } else {
          setLocalSlippage(undefined);
          setCustomSlippage(slippage.toString());
        }
      }
    }
  }, [slippage, shouldShowAutoOption, isOpen]);
  const getNotificationConfig = () => {
    if (!customSlippage) {
      return null;
    }
    const slippageValue = Number(customSlippage.replace(',', '.'));
    if (slippageValue < 0.5) {
      return {
        severity: _designSystem.SEVERITIES.WARNING,
        text: t('swapSlippageLowDescription', [slippageValue]),
        title: t('swapSlippageLowTitle')
      };
    }
    return null;
  };
  const notificationConfig = getNotificationConfig();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: isOpen,
    onClose: onClose,
    className: "bridge-settings-modal"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onClose: onClose
  }, t('transactionSettings')), /*#__PURE__*/_react.default.createElement(_layout.Column, {
    gap: 3,
    padding: 4
  }, /*#__PURE__*/_react.default.createElement(_layout.Row, {
    gap: 1,
    justifyContent: _designSystem.JustifyContent.flexStart
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, null, t('swapsMaxSlippage')), /*#__PURE__*/_react.default.createElement(_layout.Tooltip, {
    position: _componentLibrary.PopoverPosition.Top,
    style: {
      zIndex: 1051
    }
  }, t('swapSlippageTooltip'))), /*#__PURE__*/_react.default.createElement(_layout.Row, {
    gap: 2,
    justifyContent: _designSystem.JustifyContent.flexStart
  }, shouldShowAutoOption && /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    size: _componentLibrary.ButtonSize.Sm,
    onClick: e => {
      e.preventDefault();
      e.stopPropagation();
      setLocalSlippage(undefined);
      setCustomSlippage(undefined);
      setIsAutoSelected(true);
    },
    variant: _componentLibrary.ButtonVariant.Secondary,
    borderColor: isAutoSelected ? _designSystem.BorderColor.primaryDefault : _designSystem.BorderColor.borderDefault,
    borderWidth: isAutoSelected ? 2 : 1,
    backgroundColor: isAutoSelected ? _designSystem.BackgroundColor.primaryMuted : _designSystem.BackgroundColor.backgroundDefault
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: isAutoSelected ? _designSystem.TextColor.primaryDefault : _designSystem.TextColor.textDefault
  }, t('swapSlippageAutoDescription'))), HARDCODED_SLIPPAGE_OPTIONS.map(hardcodedSlippage => {
    const isSelected = !isAutoSelected && localSlippage === hardcodedSlippage;
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
      key: hardcodedSlippage,
      size: _componentLibrary.ButtonSize.Sm,
      onClick: e => {
        e.preventDefault();
        e.stopPropagation();
        setLocalSlippage(hardcodedSlippage);
        setCustomSlippage(undefined);
        setIsAutoSelected(false);
      },
      variant: _componentLibrary.ButtonVariant.Secondary,
      borderColor: isSelected ? _designSystem.BorderColor.primaryDefault : _designSystem.BorderColor.borderDefault,
      borderWidth: isSelected ? 2 : 1,
      backgroundColor: isSelected ? _designSystem.BackgroundColor.primaryMuted : _designSystem.BackgroundColor.backgroundDefault
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      color: isSelected ? _designSystem.TextColor.primaryDefault : _designSystem.TextColor.textDefault
    }, hardcodedSlippage, "%"));
  }), showCustomButton && /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    size: _componentLibrary.ButtonSize.Sm,
    variant: _componentLibrary.ButtonVariant.Secondary,
    borderColor: customSlippage === undefined ? _designSystem.BorderColor.borderDefault : _designSystem.BorderColor.primaryDefault,
    borderWidth: customSlippage === undefined ? 1 : 2,
    backgroundColor: customSlippage === undefined ? _designSystem.BackgroundColor.backgroundDefault : _designSystem.BackgroundColor.primaryMuted,
    onClick: e => {
      e.preventDefault();
      e.stopPropagation();
      setShowCustomButton(false);
      setIsAutoSelected(false);
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: customSlippage === undefined ? _designSystem.TextColor.textDefault : _designSystem.TextColor.primaryDefault
  }, customSlippage === undefined ? t('customSlippage') : `${customSlippage}%`)), !showCustomButton && /*#__PURE__*/_react.default.createElement(_componentLibrary.TextField, {
    borderColor: _designSystem.BorderColor.primaryDefault,
    borderWidth: 2,
    borderRadius: _designSystem.BorderRadius.pill,
    type: _componentLibrary.TextFieldType.Text,
    value: customSlippage,
    onChange: e => {
      const {
        value
      } = e.target;
      if (value === '' || /^\d*[.,]?\d*$/u.test(value)) {
        setLocalSlippage(undefined);
        setCustomSlippage(value);
        setIsAutoSelected(false);
      }
    },
    autoFocus: true,
    onBlur: () => {
      setShowCustomButton(true);
    },
    onFocus: () => {
      setShowCustomButton(false);
    },
    endAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMd
    }, "%")
  })), notificationConfig && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginTop: 5
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerAlert, {
    severity: notificationConfig.severity,
    title: notificationConfig.title,
    titleProps: {
      'data-testid': 'swaps-banner-title'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, null, notificationConfig.text)))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalFooter, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonPrimary, {
    width: _designSystem.BlockSize.Full,
    size: _componentLibrary.ButtonPrimarySize.Md,
    variant: _designSystem.TextVariant.bodyMd,
    disabled: (() => {
      // Calculate what the new slippage would be
      const newSlippage = isAutoSelected ? undefined : localSlippage ?? (customSlippage ? Number(customSlippage.replace(',', '.')) : undefined);

      // Button is disabled if nothing has changed
      return newSlippage === slippage;
    })(),
    onClick: () => {
      const newSlippage = isAutoSelected ? undefined : localSlippage ?? Number(customSlippage === null || customSlippage === void 0 ? void 0 : customSlippage.replace(',', '.'));
      if (newSlippage !== slippage) {
        dispatch((0, _actions.setSlippage)(newSlippage));
        onClose();
      }
    }
  }, t('submit')))));
};
exports.BridgeTransactionSettingsModal = BridgeTransactionSettingsModal;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\prepare\\bridge-transaction-settings-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\prepare\\components\\bridge-asset-picker-button.tsx", {"../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../components/component-library/select-button/select-button.types":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\select-button\\select-button.types.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/utils/nfts":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\nfts.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Cprepare%5Ccomponents%5Cbridge-asset-picker-button.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BridgeAssetPickerButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _selectButton = require("../../../../components/component-library/select-button/select-button.types");
var _componentLibrary = require("../../../../components/component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _nfts = require("../../../../helpers/utils/nfts");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const BridgeAssetPickerButton = ({
  asset,
  networkProps,
  networkImageSrc,
  ...props
}) => {
  var _networkProps$network;
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.SelectButton, _extends({
    borderRadius: _designSystem.BorderRadius.pill,
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    borderColor: _designSystem.BorderColor.borderMuted,
    style: {
      padding: 8,
      paddingRight: 11,
      paddingInline: asset ? undefined : 24,
      minWidth: 'fit-content'
    },
    gap: 0,
    size: _selectButton.SelectButtonSize.Lg,
    alignItems: _designSystem.AlignItems.center,
    descriptionProps: {
      variant: _designSystem.TextVariant.bodyMd,
      overflowWrap: _designSystem.OverflowWrap.BreakWord,
      ellipsis: false
    },
    caretIconProps: {
      name: _componentLibrary.IconName.Arrow2Down,
      style: {
        display: _designSystem.Display.None
      }
    },
    label: /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyLgMedium,
      ellipsis: true
    }, (asset === null || asset === void 0 ? void 0 : asset.symbol) ?? t('bridgeTo')),
    startAccessory: asset ? /*#__PURE__*/_react.default.createElement(_componentLibrary.BadgeWrapper, {
      marginRight: 2,
      badge: asset ? /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
        name: (networkProps === null || networkProps === void 0 || (_networkProps$network = networkProps.network) === null || _networkProps$network === void 0 ? void 0 : _networkProps$network.name) ?? '',
        src: networkImageSrc,
        size: _componentLibrary.AvatarNetworkSize.Xs
      }) : undefined
    }, asset ? /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarToken
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    , {
      src: (0, _nfts.getNftImage)(asset.image) || undefined,
      backgroundColor: _designSystem.BackgroundColor.backgroundHover,
      name: asset.symbol
    }) : undefined) : undefined
  }, props));
};
exports.BridgeAssetPickerButton = BridgeAssetPickerButton;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\prepare\\components\\bridge-asset-picker-button.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\prepare\\components\\destination-account-list-item.tsx", {"../../../../../app/scripts/lib/multichain/address":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\multichain\\address.ts","../../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../components/app/preferred-avatar":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\preferred-avatar\\index.ts","../../../../components/app/user-preferenced-currency-display/user-preferenced-currency-display.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\user-preferenced-currency-display\\user-preferenced-currency-display.component.js","../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../ducks/bridge/selectors":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\selectors.ts","../../../../helpers/constants/common":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\common.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../../hooks/useAccountTotalCrossChainFiatBalance":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAccountTotalCrossChainFiatBalance.ts","../../../../hooks/useGetFormattedTokensPerChain":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useGetFormattedTokensPerChain.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../hooks/useMultichainBalances":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainBalances.ts","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../layout":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\layout\\index.tsx","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Cprepare%5Ccomponents%5Cdestination-account-list-item.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _bridgeController = require("@metamask/bridge-controller");
var _designSystemReact = require("@metamask/design-system-react");
var _keyringApi = require("@metamask/keyring-api");
var _util = require("../../../../helpers/utils/util");
var _componentLibrary = require("../../../../components/component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _selectors = require("../../../../selectors");
var _address = require("../../../../../app/scripts/lib/multichain/address");
var _useGetFormattedTokensPerChain = require("../../../../hooks/useGetFormattedTokensPerChain");
var _useAccountTotalCrossChainFiatBalance = require("../../../../hooks/useAccountTotalCrossChainFiatBalance");
var _userPreferencedCurrencyDisplay = _interopRequireDefault(require("../../../../components/app/user-preferenced-currency-display/user-preferenced-currency-display.component"));
var _common = require("../../../../helpers/constants/common");
var _preferredAvatar = require("../../../../components/app/preferred-avatar");
var _layout = require("../../layout");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _network = require("../../../../../shared/constants/network");
var _selectors2 = require("../../../../ducks/bridge/selectors");
var _useMultichainBalances = require("../../../../hooks/useMultichainBalances");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// eslint-disable-next-line import/no-restricted-paths

const MAXIMUM_CURRENCY_DECIMALS = 3;
const DestinationAccountListItem = ({
  account,
  selected = false,
  onClick,
  isExternal = false
}) => {
  const shouldHideZeroBalanceTokens = (0, _reactRedux.useSelector)(_selectors.getShouldHideZeroBalanceTokens);
  const isTokenNetworkFilterEqualCurrentNetwork = (0, _reactRedux.useSelector)(_selectors.getIsTokenNetworkFilterEqualCurrentNetwork);
  const allChainIDs = (0, _reactRedux.useSelector)(_selectors.getChainIdsToPoll);
  const isEvmNetwork = (0, _keyringApi.isEvmAccountType)(account.type);
  const toChain = (0, _reactRedux.useSelector)(_selectors2.getToChain);
  const {
    balanceByChainId
  } = (0, _useMultichainBalances.useMultichainBalances)(account.address);
  const {
    formattedTokensWithBalancesPerChain
  } = (0, _useGetFormattedTokensPerChain.useGetFormattedTokensPerChain)(account, shouldHideZeroBalanceTokens, isTokenNetworkFilterEqualCurrentNetwork, allChainIDs);
  const {
    totalFiatBalance
  } = (0, _useAccountTotalCrossChainFiatBalance.useAccountTotalCrossChainFiatBalance)(account, formattedTokensWithBalancesPerChain);
  let balanceToTranslate;
  if (isEvmNetwork) {
    balanceToTranslate = totalFiatBalance;
  } else {
    var _balanceByChainId$cha;
    const chainIdInHexOrCaip = (toChain === null || toChain === void 0 ? void 0 : toChain.chainId) && ((0, _bridgeController.isSolanaChainId)(toChain === null || toChain === void 0 ? void 0 : toChain.chainId) || (0, _bridgeController.isBitcoinChainId)(toChain === null || toChain === void 0 ? void 0 : toChain.chainId) ? toChain.chainId : (0, _bridgeController.formatChainIdToHex)(toChain === null || toChain === void 0 ? void 0 : toChain.chainId));
    balanceToTranslate = chainIdInHexOrCaip ? (_balanceByChainId$cha = balanceByChainId[chainIdInHexOrCaip]) === null || _balanceByChainId$cha === void 0 ? void 0 : _balanceByChainId$cha.toString() : '0';
  }
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_layout.Row, {
    gap: 4,
    padding: 2,
    paddingInline: 4,
    onClick: onClick,
    className: selected ? 'multichain-account-list-item--selected' : 'multichain-account-list-item'
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    style: {
      borderRadius: 12,
      // eslint-disable-next-line @metamask/design-tokens/color-no-hex
      borderColor: '#8b99ff',
      borderWidth: selected ? 2 : 0,
      padding: selected ? 1 : 3,
      height: 38
    }
  }, /*#__PURE__*/_react.default.createElement(_preferredAvatar.PreferredAvatar, {
    style: {
      minWidth: 'max-content',
      borderRadius: 8
    },
    address: account.address
  })), /*#__PURE__*/_react.default.createElement(_layout.Column, {
    gap: 1,
    "data-testid": selected ? 'selected-to-account' : undefined
  }, /*#__PURE__*/_react.default.createElement(_layout.Row, {
    gap: 1,
    style: {
      maxWidth: 'min-content'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    ellipsis: true
  }, account.displayName), selected && /*#__PURE__*/_react.default.createElement(_designSystemReact.Icon, {
    name: _designSystemReact.IconName.CheckBold,
    size: _designSystemReact.IconSize.Md,
    color: _designSystemReact.IconColor.PrimaryDefault
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative,
    "data-testid": "account-list-address"
  }, (0, _util.shortenAddress)((0, _address.normalizeSafeAddress)(account.address)))), isExternal ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Tag, {
    label: t('externalAccount'),
    labelProps: {
      variant: _designSystem.TextVariant.bodyXs
    },
    style: {
      whiteSpace: 'nowrap'
    }
  }) : /*#__PURE__*/_react.default.createElement(_layout.Column, {
    alignItems: _designSystem.AlignItems.flexEnd,
    width: _designSystem.BlockSize.Max,
    gap: 1
  }, /*#__PURE__*/_react.default.createElement(_userPreferencedCurrencyDisplay.default, {
    ethNumberOfDecimals: MAXIMUM_CURRENCY_DECIMALS,
    value: balanceToTranslate,
    type: _common.PRIMARY,
    showFiat: true,
    isAggregatedFiatOverviewBalance: true,
    hideLabel: true,
    "data-testid": "first-currency-display"
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
    src: _network.CHAIN_ID_TO_NETWORK_IMAGE_URL_MAP[toChain !== null && toChain !== void 0 && toChain.chainId && !(0, _bridgeController.isSolanaChainId)(toChain === null || toChain === void 0 ? void 0 : toChain.chainId) && !(0, _bridgeController.isBitcoinChainId)(toChain === null || toChain === void 0 ? void 0 : toChain.chainId) ? (0, _bridgeController.formatChainIdToHex)(toChain === null || toChain === void 0 ? void 0 : toChain.chainId) : (toChain === null || toChain === void 0 ? void 0 : toChain.chainId) ?? ''],
    name: (toChain === null || toChain === void 0 ? void 0 : toChain.name) ?? '',
    size: _componentLibrary.AvatarNetworkSize.Xs
  })));
};
var _default = exports.default = /*#__PURE__*/_react.default.memo(DestinationAccountListItem);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\prepare\\components\\destination-account-list-item.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\prepare\\components\\destination-account-picker-modal.tsx", {"../../../../../shared/lib/translate":"D:\\code\\v\\metamask-extension\\shared\\lib\\translate.ts","../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../ducks/bridge/selectors":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\selectors.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../hooks/useExternalAccountResolution":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\hooks\\useExternalAccountResolution.ts","./destination-account-list-item":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\prepare\\components\\destination-account-list-item.tsx","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Cprepare%5Ccomponents%5Cdestination-account-picker-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DestinationAccountPickerModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _bridgeController = require("@metamask/bridge-controller");
var _designSystemReact = require("@metamask/design-system-react");
var _componentLibrary = require("../../../../components/component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _translate = require("../../../../../shared/lib/translate");
var _selectors = require("../../../../ducks/bridge/selectors");
var _useExternalAccountResolution = require("../../hooks/useExternalAccountResolution");
var _destinationAccountListItem = _interopRequireDefault(require("./destination-account-list-item"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DestinationAccountPickerModal = ({
  onAccountSelect,
  selectedAccount,
  isOpen,
  onClose
}) => {
  const [searchQuery, setSearchQuery] = (0, _react.useState)('');
  const accounts = (0, _reactRedux.useSelector)(_selectors.getToAccounts);
  const toChain = (0, _reactRedux.useSelector)(_selectors.getToChain);
  const isDestinationSolana = toChain !== null && toChain !== void 0 && toChain.chainId ? (0, _bridgeController.isSolanaChainId)(toChain.chainId) : false;
  const isDestinationBitcoin = toChain !== null && toChain !== void 0 && toChain.chainId ? (0, _bridgeController.isBitcoinChainId)(toChain.chainId) : false;
  const externalAccount = (0, _useExternalAccountResolution.useExternalAccountResolution)({
    searchQuery,
    isDestinationSolana,
    isDestinationBitcoin
  });
  const filteredAccounts = (0, _react.useMemo)(() => accounts.filter(account => {
    const matchesSearchByName = account.displayName.toLowerCase().includes(searchQuery.trim().toLowerCase());
    const matchesSearchByAddress = account.address.toLowerCase().includes(searchQuery.trim().toLowerCase());
    const matchesSearch = matchesSearchByName || matchesSearchByAddress;
    return matchesSearch;
  }), [accounts, searchQuery]);
  const isToOrFromNonEvm = (0, _reactRedux.useSelector)(_selectors.getIsToOrFromNonEvm);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: isOpen || isToOrFromNonEvm && !selectedAccount,
    onClose: () => {
      setSearchQuery('');
      onClose();
    },
    "data-testid": "destination-account-picker-modal"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, {
    paddingTop: 4,
    paddingBottom: 4,
    gap: 3
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onClose: onClose
  }, (0, _translate.t)('recipient')), /*#__PURE__*/_react.default.createElement(_componentLibrary.TextField, {
    autoFocus: true,
    "data-testid": "destination-account-picker-modal-search-input",
    placeholder: (isDestinationSolana ? (0, _translate.t)('destinationAccountPickerSearchPlaceholderToSolana') : (0, _translate.t)('destinationAccountPickerSearchPlaceholderToMainnet')) ?? undefined,
    marginInline: 4,
    value: searchQuery,
    onChange: e => setSearchQuery(e.target.value),
    backgroundColor: _designSystem.BackgroundColor.backgroundSubsection,
    borderRadius: _designSystem.BorderRadius.XL,
    borderWidth: 0,
    color: _designSystem.TextColor.textAlternative,
    inputProps: {
      disableStateStyles: true
    },
    style: {
      minHeight: 48,
      marginBottom: 12,
      outline: 'none'
    },
    startAccessory: /*#__PURE__*/_react.default.createElement(_designSystemReact.Icon, {
      name: _designSystemReact.IconName.Search,
      size: _designSystemReact.IconSize.Md
    })
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, {
    paddingRight: 0,
    paddingLeft: 0,
    "data-testid": "destination-account-picker-modal-body"
  }, filteredAccounts.map(account => /*#__PURE__*/_react.default.createElement(_destinationAccountListItem.default, {
    key: account.id + account.address + account.displayName,
    account: account,
    onClick: () => {
      onAccountSelect(account);
    },
    selected: selectedAccount ? account.address.toLowerCase() === selectedAccount.address.toLowerCase() : false,
    isExternal: false
  })), externalAccount && /*#__PURE__*/_react.default.createElement(_destinationAccountListItem.default, {
    key: "external-account",
    account: externalAccount,
    onClick: () => {
      onAccountSelect(externalAccount);
    },
    selected: selectedAccount ? externalAccount.address.toLowerCase() === selectedAccount.address.toLowerCase() : false,
    isExternal: true
  }), filteredAccounts.length === 0 && !externalAccount && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    textAlign: _designSystem.TextAlign.Center
  }, searchQuery ? (0, _translate.t)('destinationAccountPickerNoMatching') : (0, _translate.t)('destinationAccountPickerNoEligible')))));
};
exports.DestinationAccountPickerModal = DestinationAccountPickerModal;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\prepare\\components\\destination-account-picker-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\prepare\\prepare-bridge-page-footer.tsx", {"./bridge-cta-button":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\prepare\\bridge-cta-button.tsx","./bridge-cta-info-text":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\prepare\\bridge-cta-info-text.tsx","./bridge-no-fee-message":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\prepare\\bridge-no-fee-message.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Cprepare%5Cprepare-bridge-page-footer.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrepareBridgePageFooter = void 0;
var _react = _interopRequireDefault(require("react"));
var _bridgeCtaButton = require("./bridge-cta-button");
var _bridgeCtaInfoText = require("./bridge-cta-info-text");
var _bridgeNoFeeMessage = require("./bridge-no-fee-message");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const PrepareBridgePageFooter = props => {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: 'contents'
    }
  }, /*#__PURE__*/_react.default.createElement(_bridgeCtaInfoText.BridgeCTAInfoText, null), /*#__PURE__*/_react.default.createElement(_bridgeCtaButton.BridgeCTAButton, props), /*#__PURE__*/_react.default.createElement(_bridgeNoFeeMessage.BridgeNoFeeMessage, null));
};
exports.PrepareBridgePageFooter = PrepareBridgePageFooter;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\prepare\\prepare-bridge-page-footer.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\prepare\\prepare-bridge-page.tsx", {"../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../shared/constants/time":"D:\\code\\v\\metamask-extension\\shared\\constants\\time.ts","../../../../shared/lib/asset-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\asset-utils.ts","../../../../shared/lib/swaps-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\swaps-utils.js","../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../../shared/types/security-alerts-api":"D:\\code\\v\\metamask-extension\\shared\\types\\security-alerts-api.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/multichain":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../../ducks/bridge/actions":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\actions.ts","../../../ducks/bridge/selectors":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\selectors.ts","../../../ducks/bridge/utils":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\utils.ts","../../../ducks/locale/locale":"D:\\code\\v\\metamask-extension\\ui\\ducks\\locale\\locale.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/hardware":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\hardware.js","../../../hooks/bridge/useBridgeQueryParams":"D:\\code\\v\\metamask-extension\\ui\\hooks\\bridge\\useBridgeQueryParams.ts","../../../hooks/bridge/useIsTxSubmittable":"D:\\code\\v\\metamask-extension\\ui\\hooks\\bridge\\useIsTxSubmittable.ts","../../../hooks/bridge/useSmartSlippage":"D:\\code\\v\\metamask-extension\\ui\\hooks\\bridge\\useSmartSlippage.ts","../../../hooks/bridge/useTokenAlerts":"D:\\code\\v\\metamask-extension\\ui\\hooks\\bridge\\useTokenAlerts.ts","../../../hooks/bridge/useTokensWithFiltering":"D:\\code\\v\\metamask-extension\\ui\\hooks\\bridge\\useTokensWithFiltering.ts","../../../hooks/ramps/useRamps/useRamps":"D:\\code\\v\\metamask-extension\\ui\\hooks\\ramps\\useRamps\\useRamps.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../hooks/useMultichainSelector":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainSelector.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../swaps/mascot-background-animation/mascot-background-animation":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\mascot-background-animation\\mascot-background-animation.js","../hooks/useDestinationAccount":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\hooks\\useDestinationAccount.ts","../hooks/useGasIncluded7702":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\hooks\\useGasIncluded7702.ts","../hooks/useIsSendBundleSupported":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\hooks\\useIsSendBundleSupported.ts","../layout":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\layout\\index.tsx","../quotes/multichain-bridge-quote-card":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\quotes\\multichain-bridge-quote-card.tsx","../utils/quote":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\utils\\quote.ts","./bridge-input-group":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\prepare\\bridge-input-group.tsx","./components/destination-account-picker-modal":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\prepare\\components\\destination-account-picker-modal.tsx","./prepare-bridge-page-footer":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\prepare\\prepare-bridge-page-footer.tsx","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","ethereumjs-util":"D:\\code\\v\\metamask-extension\\node_modules\\ethereumjs-util\\dist.browser\\index.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Cprepare%5Cprepare-bridge-page.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEnableMissingNetwork = exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _classnames = _interopRequireDefault(require("classnames"));
var _lodash = require("lodash");
var _ethereumjsUtil = require("ethereumjs-util");
var _bridgeController = require("@metamask/bridge-controller");
var _utils = require("@metamask/utils");
var _actions = require("../../../ducks/bridge/actions");
var _selectors = require("../../../ducks/bridge/selectors");
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _useTokensWithFiltering = require("../../../hooks/bridge/useTokensWithFiltering");
var _swapsUtils = require("../../../../shared/lib/swaps-utils");
var _quote = require("../utils/quote");
var _utils2 = require("../../../ducks/bridge/utils");
var _mascotBackgroundAnimation = _interopRequireDefault(require("../../swaps/mascot-background-animation/mascot-background-animation"));
var _layout = require("../layout");
var _useRamps = _interopRequireDefault(require("../../../hooks/ramps/useRamps/useRamps"));
var _selectors2 = require("../../../selectors");
var _hardware = require("../../../helpers/utils/hardware");
var _time = require("../../../../shared/constants/time");
var _locale = require("../../../ducks/locale/locale");
var _useMultichainSelector = require("../../../hooks/useMultichainSelector");
var _multichain = require("../../../selectors/multichain");
var _actions2 = require("../../../store/actions");
var _multichainBridgeQuoteCard = require("../quotes/multichain-bridge-quote-card");
var _securityAlertsApi = require("../../../../shared/types/security-alerts-api");
var _useTokenAlerts = require("../../../hooks/bridge/useTokenAlerts");
var _useDestinationAccount = require("../hooks/useDestinationAccount");
var _multichain2 = require("../../../components/multichain");
var _useIsTxSubmittable = require("../../../hooks/bridge/useIsTxSubmittable");
var _assetUtils = require("../../../../shared/lib/asset-utils");
var _trace = require("../../../../shared/lib/trace");
var _network = require("../../../../shared/constants/network");
var _useBridgeQueryParams = require("../../../hooks/bridge/useBridgeQueryParams");
var _useSmartSlippage = require("../../../hooks/bridge/useSmartSlippage");
var _useGasIncluded = require("../hooks/useGasIncluded7702");
var _useIsSendBundleSupported = require("../hooks/useIsSendBundleSupported");
var _bridgeInputGroup = require("./bridge-input-group");
var _prepareBridgePageFooter = require("./prepare-bridge-page-footer");
var _destinationAccountPickerModal = require("./components/destination-account-picker-modal");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Ensures that any missing network gets added to the NetworkEnabledMap (which handles network polling)
 *
 * @returns callback to enable a network config.
 */
const useEnableMissingNetwork = () => {
  const enabledNetworksByNamespace = (0, _reactRedux.useSelector)(_selectors2.getEnabledNetworksByNamespace);
  const dispatch = (0, _reactRedux.useDispatch)();
  const enableMissingNetwork = (0, _react.useCallback)(chainId => {
    const enabledNetworkKeys = Object.keys(enabledNetworksByNamespace ?? {});
    const caipChainId = (0, _bridgeController.formatChainIdToCaip)(chainId);
    const {
      namespace
    } = (0, _utils.parseCaipChainId)(caipChainId);
    if (namespace) {
      const isPopularNetwork = _network.FEATURED_NETWORK_CHAIN_IDS.includes(chainId);
      if (isPopularNetwork) {
        const isNetworkEnabled = enabledNetworkKeys.includes(chainId);
        if (!isNetworkEnabled) {
          // Bridging between popular networks indicates we want the 'select all' enabled
          // This way users can see their full bridging tx activity
          dispatch((0, _actions2.setEnabledAllPopularNetworks)());
        }
      }
    }
  }, [dispatch, enabledNetworksByNamespace]);
  return enableMissingNetwork;
};
exports.useEnableMissingNetwork = useEnableMissingNetwork;
const PrepareBridgePage = ({
  onOpenSettings
}) => {
  var _toToken$aggregators, _activeQuote$toTokenA, _activeQuote$toTokenA2, _activeQuote$toTokenA3;
  const dispatch = (0, _reactRedux.useDispatch)();
  const enableMissingNetwork = useEnableMissingNetwork();
  const t = (0, _useI18nContext.useI18nContext)();
  const fromChain = (0, _reactRedux.useSelector)(_selectors.getFromChain);
  const isSwap = (0, _reactRedux.useSelector)(_selectors.getIsSwap);
  const isSendBundleSupportedForChain = (0, _useIsSendBundleSupported.useIsSendBundleSupported)(fromChain);
  const gasIncluded = (0, _reactRedux.useSelector)(state => (0, _selectors.getIsGasIncluded)(state, isSendBundleSupportedForChain));
  const fromToken = (0, _reactRedux.useSelector)(_selectors.getFromToken);
  const fromTokens = (0, _reactRedux.useSelector)(_selectors2.getTokenList);
  const toToken = (0, _reactRedux.useSelector)(_selectors.getToToken);
  const fromChains = (0, _reactRedux.useSelector)(_selectors.getFromChains);
  const toChains = (0, _reactRedux.useSelector)(_selectors.getToChains);
  const toChain = (0, _reactRedux.useSelector)(_selectors.getToChain);
  const isFromTokensLoading = (0, _react.useMemo)(() => {
    // Non-EVM chains (Solana, Bitcoin) don't use the EVM token list
    if (fromChain && ((0, _bridgeController.isSolanaChainId)(fromChain.chainId) || (0, _bridgeController.isBitcoinChainId)(fromChain.chainId))) {
      return false;
    }
    return Object.keys(fromTokens).length === 0;
  }, [fromTokens, fromChain]);
  const fromAmount = (0, _reactRedux.useSelector)(_selectors.getFromAmount);
  const fromAmountInCurrency = (0, _reactRedux.useSelector)(_selectors.getFromAmountInCurrency);
  const smartTransactionsEnabled = (0, _reactRedux.useSelector)(_selectors.getIsStxEnabled);
  const providerConfig = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainProviderConfig);
  const slippage = (0, _reactRedux.useSelector)(_selectors.getSlippage);
  const quoteRequest = (0, _reactRedux.useSelector)(_selectors.getQuoteRequest);
  const {
    isLoading,
    // This quote may be older than the refresh rate, but we keep it for display purposes
    activeQuote: unvalidatedQuote,
    quotesRefreshCount
  } = (0, _reactRedux.useSelector)(_selectors.getBridgeQuotes);
  const isQuoteExpired = (0, _reactRedux.useSelector)(state => (0, _selectors.getIsQuoteExpired)(state, Date.now()));
  const wasTxDeclined = (0, _reactRedux.useSelector)(_selectors.getWasTxDeclined);

  // Determine if the current quote is expired or does not match the currently
  // selected destination asset/chain.
  const isQuoteExpiredOrInvalid = (0, _quote.isQuoteExpiredOrInvalid)({
    activeQuote: unvalidatedQuote,
    toToken,
    toChain,
    fromChain,
    isQuoteExpired,
    insufficientBal: quoteRequest.insufficientBal
  });
  const activeQuote = isQuoteExpiredOrInvalid ? undefined : unvalidatedQuote;
  const selectedAccount = (0, _reactRedux.useSelector)(_selectors.getFromAccount);
  const gasIncluded7702 = (0, _useGasIncluded.useGasIncluded7702)({
    isSwap,
    isSendBundleSupportedForChain,
    selectedAccount,
    fromChain
  });
  const shouldShowMaxButton = fromToken && (0, _bridgeController.isNativeAddress)(fromToken.address) ? gasIncluded || gasIncluded7702 : true;
  const keyring = (0, _reactRedux.useSelector)(_selectors2.getCurrentKeyring);
  const isUsingHardwareWallet = (0, _hardware.isHardwareKeyring)(keyring === null || keyring === void 0 ? void 0 : keyring.type);
  const hardwareWalletName = (0, _reactRedux.useSelector)(_selectors.getHardwareWalletName);
  const isTxSubmittable = (0, _useIsTxSubmittable.useIsTxSubmittable)();
  const locale = (0, _reactRedux.useSelector)(_locale.getIntlLocale);
  const ticker = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainNativeCurrency);
  const {
    isEstimatedReturnLow,
    isNoQuotesAvailable,
    isInsufficientGasForQuote,
    isInsufficientBalance
  } = (0, _reactRedux.useSelector)(_selectors.getValidationErrors);
  const txAlert = (0, _reactRedux.useSelector)(_selectors.getTxAlerts);
  const {
    openBuyCryptoInPdapp
  } = (0, _useRamps.default)();
  const {
    tokenAlert
  } = (0, _useTokenAlerts.useTokenAlerts)();
  const {
    selectedDestinationAccount,
    setSelectedDestinationAccount,
    isDestinationAccountPickerOpen,
    setIsDestinationAccountPickerOpen
  } = (0, _useDestinationAccount.useDestinationAccount)();
  const {
    filteredTokenListGenerator: toTokenListGenerator,
    isLoading: isToTokensLoading
  } = (0, _useTokensWithFiltering.useTokensWithFiltering)((toChain === null || toChain === void 0 ? void 0 : toChain.chainId) ?? (fromChain === null || fromChain === void 0 ? void 0 : fromChain.chainId), toToken, (fromChain === null || fromChain === void 0 ? void 0 : fromChain.chainId) === (toChain === null || toChain === void 0 ? void 0 : toChain.chainId) && fromToken && fromChain ? (() => {
    // Determine the address format based on chain type
    // We need to make evm tokens lowercase for comparison as sometimes they are checksummed
    let address = '';
    if ((0, _bridgeController.isNativeAddress)(fromToken.address)) {
      address = '';
    } else if ((0, _bridgeController.isSolanaChainId)(fromChain.chainId) || (0, _bridgeController.isBitcoinChainId)(fromChain.chainId)) {
      address = fromToken.address || '';
    } else {
      var _fromToken$address;
      address = ((_fromToken$address = fromToken.address) === null || _fromToken$address === void 0 ? void 0 : _fromToken$address.toLowerCase()) || '';
    }
    return {
      ...fromToken,
      address,
      // Ensure chainId is in CAIP format for proper comparison
      chainId: (0, _bridgeController.formatChainIdToCaip)(fromChain.chainId)
    };
  })() : null, selectedDestinationAccount === null || selectedDestinationAccount === void 0 ? void 0 : selectedDestinationAccount.address);
  const [rotateSwitchTokens, setRotateSwitchTokens] = (0, _react.useState)(false);

  // Resets the banner visibility when the estimated return is low
  const [isLowReturnBannerOpen, setIsLowReturnBannerOpen] = (0, _react.useState)(true);
  (0, _react.useEffect)(() => setIsLowReturnBannerOpen(true), [quotesRefreshCount]);

  // Resets the banner visibility when new alerts found
  const [isTokenAlertBannerOpen, setIsTokenAlertBannerOpen] = (0, _react.useState)(true);
  (0, _react.useEffect)(() => setIsTokenAlertBannerOpen(true), [tokenAlert]);

  // Resets the banner visibility when toToken is changed
  const [isCannotVerifyTokenBannerOpen, setIsCannotVerifyTokenBannerOpen] = (0, _react.useState)(true);
  (0, _react.useEffect)(() => setIsCannotVerifyTokenBannerOpen(true), [toToken === null || toToken === void 0 ? void 0 : toToken.address]);

  // Background updates are debounced when the switch button is clicked
  // To prevent putting the frontend in an unexpected state, prevent the user
  // from switching tokens within the debounce period
  const [isSwitchingTemporarilyDisabled, setIsSwitchingTemporarilyDisabled] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    setIsSwitchingTemporarilyDisabled(true);
    const switchButtonTimer = setTimeout(() => {
      setIsSwitchingTemporarilyDisabled(false);
    }, _time.SECOND);
    return () => {
      clearTimeout(switchButtonTimer);
    };
  }, [rotateSwitchTokens]);

  // Scroll to bottom of the page when banners are shown
  const alertBannersRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    if (isEstimatedReturnLow || isInsufficientGasForQuote || isLowReturnBannerOpen || tokenAlert || txAlert || isUsingHardwareWallet) {
      var _alertBannersRef$curr;
      (_alertBannersRef$curr = alertBannersRef.current) === null || _alertBannersRef$curr === void 0 || _alertBannersRef$curr.scrollIntoView({
        behavior: 'smooth',
        block: 'end'
      });
    }
  }, [isEstimatedReturnLow, isInsufficientGasForQuote, isLowReturnBannerOpen, tokenAlert, txAlert, isUsingHardwareWallet]);
  const isToOrFromNonEvm = (0, _reactRedux.useSelector)(_selectors.getIsToOrFromNonEvm);
  const quoteParams = (0, _react.useMemo)(() => {
    var _providerConfig$rpcUr;
    return selectedAccount !== null && selectedAccount !== void 0 && selectedAccount.address ? {
      srcTokenAddress: fromToken === null || fromToken === void 0 ? void 0 : fromToken.address,
      destTokenAddress: toToken === null || toToken === void 0 ? void 0 : toToken.address,
      srcTokenAmount: fromAmount && fromToken !== null && fromToken !== void 0 && fromToken.decimals ? (0, _swapsUtils.calcTokenValue)(
      // Treat empty or incomplete amount as 0 to reject NaN
      ['', '.'].includes(fromAmount) ? '0' : fromAmount, fromToken.decimals).toFixed()
      // Length of decimal part cannot exceed token.decimals
      .split('.')[0] : undefined,
      srcChainId: fromChain === null || fromChain === void 0 ? void 0 : fromChain.chainId,
      destChainId: toChain === null || toChain === void 0 ? void 0 : toChain.chainId,
      // This override allows quotes to be returned when the rpcUrl is a forked network
      // Otherwise quotes get filtered out by the bridge-api when the wallet's real
      // balance is less than the tenderly balance
      insufficientBal: providerConfig !== null && providerConfig !== void 0 && (_providerConfig$rpcUr = providerConfig.rpcUrl) !== null && _providerConfig$rpcUr !== void 0 && _providerConfig$rpcUr.includes('localhost') ? true : undefined,
      slippage,
      walletAddress: selectedAccount.address,
      destWalletAddress: selectedDestinationAccount === null || selectedDestinationAccount === void 0 ? void 0 : selectedDestinationAccount.address,
      gasIncluded: gasIncluded || gasIncluded7702,
      gasIncluded7702
    } : undefined;
  }, [fromToken === null || fromToken === void 0 ? void 0 : fromToken.address, fromToken === null || fromToken === void 0 ? void 0 : fromToken.decimals, toToken === null || toToken === void 0 ? void 0 : toToken.address, fromAmount, fromChain === null || fromChain === void 0 ? void 0 : fromChain.chainId, toChain === null || toChain === void 0 ? void 0 : toChain.chainId, slippage, selectedAccount === null || selectedAccount === void 0 ? void 0 : selectedAccount.address, selectedDestinationAccount === null || selectedDestinationAccount === void 0 ? void 0 : selectedDestinationAccount.address, providerConfig === null || providerConfig === void 0 ? void 0 : providerConfig.rpcUrl, gasIncluded, gasIncluded7702]);
  const debouncedUpdateQuoteRequestInController = (0, _react.useCallback)((0, _lodash.debounce)((...args) => {
    dispatch((0, _actions.updateQuoteRequestParams)(...args));
  }, 300), [dispatch]);
  (0, _react.useEffect)(() => {
    return () => {
      debouncedUpdateQuoteRequestInController.cancel();
    };
  }, []);
  (0, _react.useEffect)(() => {
    dispatch((0, _actions.setSelectedQuote)(null));
    if (!quoteParams) {
      return;
    }
    const eventProperties = {
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      stx_enabled: smartTransactionsEnabled,
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      token_symbol_source: (fromToken === null || fromToken === void 0 ? void 0 : fromToken.symbol) ?? '',
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      token_symbol_destination: (toToken === null || toToken === void 0 ? void 0 : toToken.symbol) ?? '',
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      security_warnings: [txAlert === null || txAlert === void 0 ? void 0 : txAlert.descriptionId, tokenAlert === null || tokenAlert === void 0 ? void 0 : tokenAlert.titleId].filter(Boolean)
    };
    debouncedUpdateQuoteRequestInController(quoteParams, eventProperties);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [quoteParams]);

  // Use smart slippage defaults
  (0, _useSmartSlippage.useSmartSlippage)({
    fromChain,
    toChain,
    fromToken,
    toToken,
    isSwap
  });

  // Trace swap/bridge view loaded
  (0, _react.useEffect)(() => {
    (0, _trace.endTrace)({
      name: _trace.TraceName.SwapViewLoaded,
      timestamp: Date.now()
    });
    if (!activeQuote) {
      // Reset controller and inputs on load if there's no restored active quote
      dispatch((0, _actions.resetBridgeState)());
    }
  }, []);
  (0, _useBridgeQueryParams.useBridgeQueryParams)();
  const occurrences = (toToken === null || toToken === void 0 ? void 0 : toToken.occurrences) ?? (toToken === null || toToken === void 0 || (_toToken$aggregators = toToken.aggregators) === null || _toToken$aggregators === void 0 ? void 0 : _toToken$aggregators.length);
  const toTokenIsNotNative = (toToken === null || toToken === void 0 ? void 0 : toToken.address) && !(0, _bridgeController.isNativeAddress)(toToken === null || toToken === void 0 ? void 0 : toToken.address);
  const [showBlockExplorerToast, setShowBlockExplorerToast] = (0, _react.useState)(false);
  const [blockExplorerToken, setBlockExplorerToken] = (0, _react.useState)(null);
  const [toastTriggerCounter, setToastTriggerCounter] = (0, _react.useState)(0);
  const getFromInputHeader = () => {
    return t('swapSelectToken');
  };
  const getToInputHeader = () => {
    return t('swapSelectToken');
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_destinationAccountPickerModal.DestinationAccountPickerModal, {
    isOpen: isDestinationAccountPickerOpen,
    onAccountSelect: account => {
      setSelectedDestinationAccount(account);
      setIsDestinationAccountPickerOpen(false);
    },
    selectedAccount: selectedDestinationAccount,
    onClose: () => setIsDestinationAccountPickerOpen(false)
  }), /*#__PURE__*/_react.default.createElement(_layout.Column, {
    className: "prepare-bridge-page",
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_bridgeInputGroup.BridgeInputGroup, {
    header: getFromInputHeader(),
    token: fromToken,
    onAmountChange: e => {
      dispatch((0, _actions.setFromTokenInputValue)(e));
    },
    onAssetChange: token => {
      const bridgeToken = {
        ...token,
        address: token.address ?? (0, _ethereumjsUtil.zeroAddress)()
      };
      dispatch((0, _actions.setFromToken)(bridgeToken));
      dispatch((0, _actions.setFromTokenInputValue)(null));
      if (token.address === (toToken === null || toToken === void 0 ? void 0 : toToken.address)) {
        dispatch((0, _actions.setToToken)(null));
      }
    },
    networkProps: {
      network: fromChain,
      networks: fromChains,
      onNetworkChange: networkConfig => {
        if ((0, _utils2.isNetworkAdded)(networkConfig)) {
          enableMissingNetwork(networkConfig.chainId);
        }
        dispatch((0, _actions.setFromChain)({
          networkConfig,
          selectedAccount
        }));
      },
      header: t('yourNetworks')
    },
    isMultiselectEnabled: true,
    onMaxButtonClick: shouldShowMaxButton ? value => {
      dispatch((0, _actions.setFromTokenInputValue)(value));
    } : undefined
    // Hides fiat amount string before a token quantity is entered.
    ,
    amountInFiat: fromAmountInCurrency.valueInCurrency.gt(0) ? fromAmountInCurrency.valueInCurrency.toString() : undefined,
    amountFieldProps: {
      testId: 'from-amount',
      autoFocus: true,
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
      // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
      value: fromAmount || undefined
    },
    containerProps: {
      paddingInline: 4
    },
    isTokenListLoading: isFromTokensLoading,
    buttonProps: {
      testId: 'bridge-source-button'
    },
    onBlockExplorerClick: token => {
      setBlockExplorerToken(token);
      setShowBlockExplorerToast(true);
      setToastTriggerCounter(prev => prev + 1);
    }
  }), /*#__PURE__*/_react.default.createElement(_layout.Column, {
    height: _designSystem.BlockSize.Full,
    padding: 4,
    gap: 4,
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    style: {
      position: 'relative'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "prepare-bridge-page__switch-tokens",
    display: _designSystem.Display.Flex,
    backgroundColor: _designSystem.BackgroundColor.backgroundSection,
    style: {
      position: 'absolute',
      top: '-20px',
      right: 'calc(50% - 20px)',
      border: '2px solid var(--color-background-default)',
      borderRadius: '100%',
      opacity: 1,
      width: 40,
      height: 40,
      justifyContent: _designSystem.JustifyContent.center
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    iconProps: {
      className: (0, _classnames.default)({
        rotate: rotateSwitchTokens
      })
    },
    style: {
      alignSelf: 'center',
      borderRadius: '100%',
      width: '100%',
      height: '100%'
    },
    "data-testid": "switch-tokens",
    ariaLabel: "switch-tokens",
    iconName: _componentLibrary.IconName.SwapVertical,
    color: _designSystem.IconColor.iconAlternative,
    disabled: isSwitchingTemporarilyDisabled || !(0, _bridgeController.isValidQuoteRequest)(quoteRequest, false) || toChain && !(0, _utils2.isNetworkAdded)(toChain),
    onClick: () => {
      var _getNativeAssetForCha;
      dispatch((0, _actions.setSelectedQuote)(null));
      // Track the flip event
      (toChain === null || toChain === void 0 ? void 0 : toChain.chainId) && fromToken && toToken && dispatch((0, _actions.trackUnifiedSwapBridgeEvent)(_bridgeController.UnifiedSwapBridgeEventName.InputSourceDestinationSwitched, {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        token_symbol_source: (toToken === null || toToken === void 0 ? void 0 : toToken.symbol) ?? null,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        token_symbol_destination: (fromToken === null || fromToken === void 0 ? void 0 : fromToken.symbol) ?? null,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        token_address_source: (0, _assetUtils.toAssetId)(toToken.address ?? '', (0, _bridgeController.formatChainIdToCaip)(toToken.chainId ?? '')) ?? ((_getNativeAssetForCha = (0, _bridgeController.getNativeAssetForChainId)(toChain.chainId)) === null || _getNativeAssetForCha === void 0 ? void 0 : _getNativeAssetForCha.assetId),
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        token_address_destination: (0, _assetUtils.toAssetId)(fromToken.address ?? '', (0, _bridgeController.formatChainIdToCaip)(fromToken.chainId ?? '')) ?? null,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        chain_id_source: (0, _bridgeController.formatChainIdToCaip)(toChain.chainId),
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        chain_id_destination: fromChain !== null && fromChain !== void 0 && fromChain.chainId ? (0, _bridgeController.formatChainIdToCaip)(fromChain === null || fromChain === void 0 ? void 0 : fromChain.chainId) : null,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        security_warnings: []
      }));
      setRotateSwitchTokens(!rotateSwitchTokens);
      if (isSwap) {
        dispatch((0, _actions.setFromToken)(toToken));
      } else {
        // Handle account switching for Solana
        dispatch((0, _actions.setFromChain)({
          networkConfig: toChain,
          token: toToken,
          selectedAccount
        }));
      }
      dispatch((0, _actions.setToToken)(fromToken));
    }
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingInline: 4,
    style: {
      borderTop: '1px solid var(--color-border-muted)',
      marginTop: '-16px'
    }
  }), /*#__PURE__*/_react.default.createElement(_bridgeInputGroup.BridgeInputGroup, {
    header: getToInputHeader(),
    token: toToken,
    onAssetChange: token => {
      const bridgeToken = {
        ...token,
        address: token.address ?? (0, _ethereumjsUtil.zeroAddress)()
      };
      dispatch((0, _actions.setToToken)(bridgeToken));
    },
    networkProps: {
      network: toChain,
      networks: toChains,
      onNetworkChange: networkConfig => {
        if ((0, _utils2.isNetworkAdded)(networkConfig)) {
          enableMissingNetwork(networkConfig.chainId);
        }
        dispatch((0, _actions.setToChainId)(networkConfig.chainId));
      },
      header: t('yourNetworks')
    },
    customTokenListGenerator: toTokenListGenerator,
    amountInFiat:
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    (activeQuote === null || activeQuote === void 0 || (_activeQuote$toTokenA = activeQuote.toTokenAmount) === null || _activeQuote$toTokenA === void 0 ? void 0 : _activeQuote$toTokenA.valueInCurrency) || undefined,
    amountFieldProps: {
      testId: 'to-amount',
      readOnly: true,
      disabled: true,
      value: activeQuote !== null && activeQuote !== void 0 && (_activeQuote$toTokenA2 = activeQuote.toTokenAmount) !== null && _activeQuote$toTokenA2 !== void 0 && _activeQuote$toTokenA2.amount ? (0, _quote.formatTokenAmount)(locale, activeQuote.toTokenAmount.amount) : '0',
      autoFocus: false,
      className: activeQuote !== null && activeQuote !== void 0 && (_activeQuote$toTokenA3 = activeQuote.toTokenAmount) !== null && _activeQuote$toTokenA3 !== void 0 && _activeQuote$toTokenA3.amount ? 'amount-input defined' : 'amount-input'
    },
    isTokenListLoading: isToTokensLoading,
    buttonProps: {
      testId: 'bridge-destination-button'
    },
    onBlockExplorerClick: token => {
      setBlockExplorerToken(token);
      setShowBlockExplorerToast(true);
      setToastTriggerCounter(prev => prev + 1);
    },
    isDestinationToken: true
  }), /*#__PURE__*/_react.default.createElement(_layout.Column, {
    justifyContent: isLoading && !unvalidatedQuote ? _designSystem.JustifyContent.center : _designSystem.JustifyContent.flexEnd,
    width: _designSystem.BlockSize.Full,
    height: _designSystem.BlockSize.Full,
    gap: 3
  }, !wasTxDeclined && unvalidatedQuote && /*#__PURE__*/_react.default.createElement(_multichainBridgeQuoteCard.MultichainBridgeQuoteCard, {
    onOpenRecipientModal: () => setIsDestinationAccountPickerOpen(true),
    onOpenSlippageModal: onOpenSettings,
    selectedDestinationAccount: selectedDestinationAccount
  }), isNoQuotesAvailable && !isQuoteExpired && /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerAlert, {
    severity: _componentLibrary.BannerAlertSeverity.Danger,
    description: t('noOptionsAvailableMessage'),
    textAlign: _designSystem.TextAlign.Left
  }), isLoading && !unvalidatedQuote ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    textAlign: _designSystem.TextAlign.Center,
    color: _designSystem.TextColor.textAlternative
  }, t('swapFetchingQuotes')), /*#__PURE__*/_react.default.createElement(_mascotBackgroundAnimation.default, {
    height: "64",
    width: "64"
  })) : /*#__PURE__*/_react.default.createElement(_prepareBridgePageFooter.PrepareBridgePageFooter, {
    onFetchNewQuotes: () => {
      if (!quoteParams) {
        return;
      }
      debouncedUpdateQuoteRequestInController(quoteParams, {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        stx_enabled: smartTransactionsEnabled,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        token_symbol_source: (fromToken === null || fromToken === void 0 ? void 0 : fromToken.symbol) ?? '',
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        token_symbol_destination: (toToken === null || toToken === void 0 ? void 0 : toToken.symbol) ?? '',
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        security_warnings: [] // TODO populate security warnings
      });
    },
    needsDestinationAddress: isToOrFromNonEvm && !selectedDestinationAccount
  })))), /*#__PURE__*/_react.default.createElement(_layout.Column, {
    paddingInline: 4,
    gap: 4,
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault
  }, isUsingHardwareWallet && isTxSubmittable && hardwareWalletName && activeQuote && /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerAlert, {
    title: t('hardwareWalletSubmissionWarningTitle'),
    textAlign: _designSystem.TextAlign.Left
  }, /*#__PURE__*/_react.default.createElement("ul", {
    style: {
      listStyle: 'disc'
    }
  }, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd
  }, t('hardwareWalletSubmissionWarningStep1', [hardwareWalletName]))), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd
  }, t('hardwareWalletSubmissionWarningStep2', [hardwareWalletName]))))), txAlert && activeQuote && /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerAlert, {
    severity: _componentLibrary.BannerAlertSeverity.Danger,
    title: t(txAlert.titleId),
    description: `${txAlert.description} ${t(txAlert.descriptionId)}`,
    textAlign: _designSystem.TextAlign.Left
  }), isCannotVerifyTokenBannerOpen && toToken && toTokenIsNotNative && Boolean(occurrences) && Number(occurrences) < 2 && /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerAlert, {
    severity: _componentLibrary.BannerAlertSeverity.Warning,
    title: t('bridgeTokenCannotVerifyTitle'),
    description: t('bridgeTokenCannotVerifyDescription'),
    textAlign: _designSystem.TextAlign.Left,
    onClose: () => setIsCannotVerifyTokenBannerOpen(false)
  }), tokenAlert && isTokenAlertBannerOpen && /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerAlert, {
    title: tokenAlert.titleId ? t(tokenAlert.titleId) : '',
    severity: tokenAlert.type === _securityAlertsApi.TokenFeatureType.MALICIOUS ? _componentLibrary.BannerAlertSeverity.Danger : _componentLibrary.BannerAlertSeverity.Warning,
    description: tokenAlert.descriptionId ? t(tokenAlert.descriptionId) : tokenAlert.description,
    textAlign: _designSystem.TextAlign.Left,
    onClose: () => setIsTokenAlertBannerOpen(false)
  }), !isLoading && activeQuote && !isInsufficientBalance && isInsufficientGasForQuote && /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerAlert, {
    title: t('bridgeValidationInsufficientGasTitle', [ticker]),
    severity: _componentLibrary.BannerAlertSeverity.Danger,
    description: t(isSwap ? 'swapValidationInsufficientGasMessage' : 'bridgeValidationInsufficientGasMessage', [ticker]),
    textAlign: _designSystem.TextAlign.Left,
    actionButtonLabel: t('buyMoreAsset', [ticker]),
    actionButtonOnClick: () => openBuyCryptoInPdapp()
  }), isEstimatedReturnLow && isLowReturnBannerOpen && activeQuote && /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerAlert, {
    title: t('lowEstimatedReturnTooltipTitle'),
    severity: _componentLibrary.BannerAlertSeverity.Warning,
    description: t('lowEstimatedReturnTooltipMessage', [_bridgeController.BRIDGE_QUOTE_MAX_RETURN_DIFFERENCE_PERCENTAGE * 100]),
    textAlign: _designSystem.TextAlign.Left,
    onClose: () => setIsLowReturnBannerOpen(false)
  }), /*#__PURE__*/_react.default.createElement("div", {
    ref: alertBannersRef
  })), showBlockExplorerToast && blockExplorerToken && /*#__PURE__*/_react.default.createElement("div", {
    style: {
      position: 'absolute',
      bottom: 50,
      left: '50%',
      transform: 'translateX(-50%)',
      zIndex: 1000,
      width: '100%',
      display: 'flex',
      justifyContent: 'center'
    }
  }, /*#__PURE__*/_react.default.createElement(_multichain2.ToastContainer, null, /*#__PURE__*/_react.default.createElement(_multichain2.Toast, {
    key: toastTriggerCounter,
    text: t('bridgeBlockExplorerLinkCopied'),
    onClose: () => setShowBlockExplorerToast(false),
    autoHideTime: 2500,
    startAdornment: /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarFavicon, {
      name: blockExplorerToken.symbol,
      size: _componentLibrary.AvatarFaviconSize.Sm,
      src: blockExplorerToken.image
    })
  }))));
};
var _default = exports.default = PrepareBridgePage;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\prepare\\prepare-bridge-page.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\quotes\\bridge-quotes-modal.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../ducks/bridge/actions":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\actions.ts","../../../ducks/bridge/selectors":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\selectors.ts","../../../ducks/locale/locale":"D:\\code\\v\\metamask-extension\\ui\\ducks\\locale\\locale.ts","../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../hooks/useMultichainSelector":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainSelector.ts","../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../layout":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\layout\\index.tsx","../utils/quote":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\utils\\quote.ts","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","@metamask/snaps-sdk/jsx":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\jsx.js","bignumber.js":"D:\\code\\v\\metamask-extension\\node_modules\\bignumber.js\\bignumber.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Cquotes%5Cbridge-quotes-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BridgeQuotesModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _jsx = require("@metamask/snaps-sdk/jsx");
var _reactRedux = require("react-redux");
var _lodash = require("lodash");
var _bridgeController = require("@metamask/bridge-controller");
var _bignumber = require("bignumber.js");
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _quote = require("../utils/quote");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _actions = require("../../../ducks/bridge/actions");
var _selectors = require("../../../ducks/bridge/selectors");
var _layout = require("../layout");
var _metamask = require("../../../ducks/metamask/metamask");
var _locale = require("../../../ducks/locale/locale");
var _multichain = require("../../../selectors/multichain");
var _useMultichainSelector = require("../../../hooks/useMultichainSelector");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const BridgeQuotesModal = ({
  onClose,
  ...modalProps
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const fromToken = (0, _reactRedux.useSelector)(_selectors.getFromToken);
  const toToken = (0, _reactRedux.useSelector)(_selectors.getToToken);
  const fromChain = (0, _reactRedux.useSelector)(_selectors.getFromChain);
  const {
    insufficientBal
  } = (0, _reactRedux.useSelector)(_selectors.getQuoteRequest);
  const isStxEnabled = (0, _reactRedux.useSelector)(_selectors.getIsStxEnabled);
  const {
    sortedQuotes,
    activeQuote,
    recommendedQuote
  } = (0, _reactRedux.useSelector)(_selectors.getBridgeQuotes);
  const sortOrder = (0, _reactRedux.useSelector)(_selectors.getBridgeSortOrder);
  const currency = (0, _reactRedux.useSelector)(_metamask.getCurrentCurrency);
  const nativeCurrency = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainNativeCurrency);
  const locale = (0, _reactRedux.useSelector)(_locale.getIntlLocale);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, _extends({
    className: "quotes-modal",
    onClose: onClose
  }, modalProps), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, {
    modalDialogProps: {
      padding: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onBack: onClose
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingSm,
    textAlign: _designSystem.TextAlign.Center
  }, t('swapSelectAQuote'))), /*#__PURE__*/_react.default.createElement(_layout.Row, {
    paddingTop: 3,
    paddingBottom: 1,
    paddingInline: 4
  }, [[_bridgeController.SortOrder.COST_ASC, t('bridgeNetCost'), _jsx.IconName.Arrow2Up], [_bridgeController.SortOrder.ETA_ASC, t('time'), _jsx.IconName.Arrow2Down]].map(([sortOrderOption, label, icon]) => /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    key: label,
    onClick: () => {
      var _recommendedQuote$quo, _recommendedQuote$quo2, _recommendedQuote$quo3;
      dispatch((0, _actions.setSortOrder)(sortOrderOption));
      fromChain && recommendedQuote && dispatch((0, _actions.trackUnifiedSwapBridgeEvent)(_bridgeController.UnifiedSwapBridgeEventName.AllQuotesSorted, {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        can_submit: !insufficientBal,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        sort_order: sortOrder,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        price_impact: Number(((_recommendedQuote$quo = recommendedQuote.quote) === null || _recommendedQuote$quo === void 0 || (_recommendedQuote$quo = _recommendedQuote$quo.priceData) === null || _recommendedQuote$quo === void 0 ? void 0 : _recommendedQuote$quo.priceImpact) ?? '0'),
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        gas_included: Boolean(recommendedQuote === null || recommendedQuote === void 0 || (_recommendedQuote$quo2 = recommendedQuote.quote) === null || _recommendedQuote$quo2 === void 0 ? void 0 : _recommendedQuote$quo2.gasIncluded),
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // @ts-expect-error gas_included_7702 needs to be added to bridge-controller types
        // eslint-disable-next-line @typescript-eslint/naming-convention
        gas_included_7702: Boolean(recommendedQuote === null || recommendedQuote === void 0 || (_recommendedQuote$quo3 = recommendedQuote.quote) === null || _recommendedQuote$quo3 === void 0 ? void 0 : _recommendedQuote$quo3.gasIncluded7702),
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        token_symbol_source: (fromToken === null || fromToken === void 0 ? void 0 : fromToken.symbol) ?? (0, _bridgeController.getNativeAssetForChainId)(fromChain.chainId).symbol,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        token_symbol_destination: (toToken === null || toToken === void 0 ? void 0 : toToken.symbol) ?? null,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        stx_enabled: isStxEnabled,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        best_quote_provider: (0, _bridgeController.formatProviderLabel)(recommendedQuote.quote)
      }));
    },
    startIconName: sortOrder === sortOrderOption && sortOrder === _bridgeController.SortOrder.ETA_ASC ? icon : undefined,
    startIconProps: {
      size: _componentLibrary.IconSize.Xs
    },
    endIconName: sortOrder === sortOrderOption && sortOrder === _bridgeController.SortOrder.COST_ASC ? icon : undefined,
    endIconProps: {
      size: _componentLibrary.IconSize.Xs
    },
    color: sortOrder === sortOrderOption ? _designSystem.TextColor.primaryDefault : _designSystem.TextColor.textAlternative
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: sortOrder === sortOrderOption ? _designSystem.TextVariant.bodySmMedium : _designSystem.TextVariant.bodySm,
    color: sortOrder === sortOrderOption ? _designSystem.TextColor.primaryDefault : _designSystem.TextColor.textAlternative
  }, label)))), /*#__PURE__*/_react.default.createElement(_layout.Column, {
    style: {
      overflow: 'scroll'
    }
  }, sortedQuotes.map((quote, index) => {
    const {
      totalNetworkFee,
      estimatedProcessingTimeInSeconds,
      toTokenAmount,
      cost,
      sentAmount,
      quote: {
        destAsset,
        bridges,
        requestId,
        gasIncluded,
        gasIncluded7702
      }
    } = quote;
    const isGasless = gasIncluded7702 || gasIncluded;
    const isQuoteActive = requestId === (activeQuote === null || activeQuote === void 0 ? void 0 : activeQuote.quote.requestId);
    const isRecommendedQuote = requestId === (recommendedQuote === null || recommendedQuote === void 0 ? void 0 : recommendedQuote.quote.requestId);
    return /*#__PURE__*/_react.default.createElement(_layout.Row, {
      alignItems: _designSystem.AlignItems.flexStart,
      key: index,
      backgroundColor: isQuoteActive ? _designSystem.BackgroundColor.primaryMuted : undefined,
      onClick: () => {
        var _quote$gasFee, _quote$quote, _quote$quote2, _quote$quote3;
        dispatch((0, _actions.setSelectedQuote)(quote));
        dispatch((0, _actions.trackUnifiedSwapBridgeEvent)(_bridgeController.UnifiedSwapBridgeEventName.QuoteSelected, {
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          can_submit: !insufficientBal,
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          is_best_quote: isRecommendedQuote,
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          best_quote_provider: (0, _bridgeController.formatProviderLabel)(quote === null || quote === void 0 ? void 0 : quote.quote),
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          usd_quoted_gas: Number(((_quote$gasFee = quote.gasFee) === null || _quote$gasFee === void 0 || (_quote$gasFee = _quote$gasFee.effective) === null || _quote$gasFee === void 0 ? void 0 : _quote$gasFee.usd) ?? 0),
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          quoted_time_minutes: quote.estimatedProcessingTimeInSeconds / 60,
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          usd_quoted_return: Number(quote.toTokenAmount.usd),
          provider: (0, _bridgeController.formatProviderLabel)(quote.quote),
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          price_impact: Number(((_quote$quote = quote.quote) === null || _quote$quote === void 0 || (_quote$quote = _quote$quote.priceData) === null || _quote$quote === void 0 ? void 0 : _quote$quote.priceImpact) ?? '0'),
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          gas_included: Boolean((_quote$quote2 = quote.quote) === null || _quote$quote2 === void 0 ? void 0 : _quote$quote2.gasIncluded),
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          gas_included_7702: Boolean((_quote$quote3 = quote.quote) === null || _quote$quote3 === void 0 ? void 0 : _quote$quote3.gasIncluded7702)
        }));
        onClose();
      },
      paddingInline: 4,
      paddingTop: 3,
      paddingBottom: 3,
      style: {
        position: 'relative'
      }
    }, isQuoteActive && /*#__PURE__*/_react.default.createElement(_layout.Column, {
      style: {
        position: 'absolute',
        left: 4,
        top: 4,
        height: 'calc(100% - 8px)',
        width: 4,
        borderRadius: 8
      },
      backgroundColor: _designSystem.BackgroundColor.primaryDefault
    }), /*#__PURE__*/_react.default.createElement(_layout.Column, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMd
    }, isGasless ? (0, _quote.formatCurrencyAmount)(new _bignumber.BigNumber(sentAmount.valueInCurrency ?? 0).minus(toTokenAmount.valueInCurrency ?? 0).toString(), currency, 2) : (0, _quote.formatCurrencyAmount)(cost.valueInCurrency, currency, 2)), [isGasless && sentAmount !== null && sentAmount !== void 0 && sentAmount.valueInCurrency ? t('quotedTotalCost', [(0, _quote.formatCurrencyAmount)(sentAmount.valueInCurrency, currency, 2)]) : undefined, !isGasless && (totalNetworkFee !== null && totalNetworkFee !== void 0 && totalNetworkFee.valueInCurrency && sentAmount !== null && sentAmount !== void 0 && sentAmount.valueInCurrency ? t('quotedTotalCost', [(0, _quote.formatCurrencyAmount)(new _bignumber.BigNumber(totalNetworkFee.valueInCurrency).plus(sentAmount.valueInCurrency).toString(), currency, 2)]) : t('quotedTotalCost', [(0, _quote.formatTokenAmount)(locale, totalNetworkFee.amount, nativeCurrency)])), t('quotedReceiveAmount', [(0, _quote.formatCurrencyAmount)(toTokenAmount.valueInCurrency, currency, 2) ?? (0, _quote.formatTokenAmount)(locale, toTokenAmount.amount, destAsset.symbol)])].filter(Boolean).map(content => /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      key: content,
      variant: _designSystem.TextVariant.bodyXsMedium,
      color: _designSystem.TextColor.textAlternative
    }, content))), /*#__PURE__*/_react.default.createElement(_layout.Column, {
      alignItems: _designSystem.AlignItems.flexEnd
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMd
    }, t('bridgeTimingMinutes', [(0, _bridgeController.formatEtaInMinutes)(estimatedProcessingTimeInSeconds)])), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyXsMedium,
      color: _designSystem.TextColor.textAlternative
    }, (0, _lodash.startCase)(bridges[0]))));
  }))));
};
exports.BridgeQuotesModal = BridgeQuotesModal;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\quotes\\bridge-quotes-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\quotes\\multichain-bridge-quote-card.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../ducks/bridge/actions":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\actions.ts","../../../ducks/bridge/selectors":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\selectors.ts","../../../ducks/bridge/utils":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\utils.ts","../../../ducks/locale/locale":"D:\\code\\v\\metamask-extension\\ui\\ducks\\locale\\locale.ts","../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/bridge/useCountdownTimer":"D:\\code\\v\\metamask-extension\\ui\\hooks\\bridge\\useCountdownTimer.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../layout":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\layout\\index.tsx","../utils/price-impact":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\utils\\price-impact.ts","../utils/quote":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\utils\\quote.ts","./bridge-quotes-modal":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\quotes\\bridge-quotes-modal.tsx","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","bignumber.js":"D:\\code\\v\\metamask-extension\\node_modules\\bignumber.js\\bignumber.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Cquotes%5Cmultichain-bridge-quote-card.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultichainBridgeQuoteCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _bignumber = require("bignumber.js");
var _bridgeController = require("@metamask/bridge-controller");
var _utils = require("../../../ducks/bridge/utils");
var _componentLibrary = require("../../../components/component-library");
var _selectors = require("../../../ducks/bridge/selectors");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _quote = require("../utils/quote");
var _metamask = require("../../../ducks/metamask/metamask");
var _designSystem = require("../../../helpers/constants/design-system");
var _layout = require("../layout");
var _actions = require("../../../ducks/bridge/actions");
var _locale = require("../../../ducks/locale/locale");
var _useCountdownTimer = require("../../../hooks/bridge/useCountdownTimer");
var _priceImpact = require("../utils/price-impact");
var _bridgeQuotesModal = require("./bridge-quotes-modal");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getTimerColor = timeInSeconds => {
  if (timeInSeconds <= 3) {
    return _designSystem.TextColor.errorDefault;
  }
  if (timeInSeconds <= 5) {
    return _designSystem.TextColor.warningDefault;
  }
  return _designSystem.TextColor.textAlternative;
};
const MultichainBridgeQuoteCard = ({
  onOpenSlippageModal,
  onOpenRecipientModal,
  selectedDestinationAccount
}) => {
  var _activeQuote$quote, _activeQuote$quote2, _activeQuote$quote3, _activeQuote$included, _activeQuote$totalNet, _activeQuote$totalNet2;
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    activeQuote,
    isQuoteGoingToRefresh
  } = (0, _reactRedux.useSelector)(_selectors.getBridgeQuotes);
  const currency = (0, _reactRedux.useSelector)(_metamask.getCurrentCurrency);
  const {
    insufficientBal
  } = (0, _reactRedux.useSelector)(_selectors.getQuoteRequest);
  const fromChain = (0, _reactRedux.useSelector)(_selectors.getFromChain);
  const locale = (0, _reactRedux.useSelector)(_locale.getIntlLocale);
  const isStxEnabled = (0, _reactRedux.useSelector)(_selectors.getIsStxEnabled);
  const fromToken = (0, _reactRedux.useSelector)(_selectors.getFromToken);
  const toToken = (0, _reactRedux.useSelector)(_selectors.getToToken);
  const slippage = (0, _reactRedux.useSelector)(_selectors.getSlippage);
  const isSolanaSwap = (0, _reactRedux.useSelector)(_selectors.getIsSolanaSwap);
  const dispatch = (0, _reactRedux.useDispatch)();
  const isToOrFromNonEvm = (0, _reactRedux.useSelector)(_selectors.getIsToOrFromNonEvm);
  const [showAllQuotes, setShowAllQuotes] = (0, _react.useState)(false);
  const priceImpactThresholds = (0, _reactRedux.useSelector)(_selectors.getPriceImpactThresholds);

  // Calculate if price impact warning should show
  const priceImpact = activeQuote === null || activeQuote === void 0 || (_activeQuote$quote = activeQuote.quote) === null || _activeQuote$quote === void 0 || (_activeQuote$quote = _activeQuote$quote.priceData) === null || _activeQuote$quote === void 0 ? void 0 : _activeQuote$quote.priceImpact;
  const gasIncluded = (activeQuote === null || activeQuote === void 0 || (_activeQuote$quote2 = activeQuote.quote) === null || _activeQuote$quote2 === void 0 ? void 0 : _activeQuote$quote2.gasIncluded) ?? false;
  const gasIncluded7702 = (activeQuote === null || activeQuote === void 0 || (_activeQuote$quote3 = activeQuote.quote) === null || _activeQuote$quote3 === void 0 ? void 0 : _activeQuote$quote3.gasIncluded7702) ?? false;
  const isGasless = gasIncluded7702 || gasIncluded;
  const shouldRenderPriceImpactRow = (0, _react.useMemo)(() => {
    const priceImpactThreshold = priceImpactThresholds;
    return priceImpactThreshold && priceImpact !== undefined && priceImpact !== null;
  }, [priceImpactThresholds, priceImpact]);

  // Red state if above threshold
  const shouldShowPriceImpactWarning = _react.default.useMemo(() => {
    if (!shouldRenderPriceImpactRow) {
      return false;
    }
    const threshold = isGasless ? priceImpactThresholds === null || priceImpactThresholds === void 0 ? void 0 : priceImpactThresholds.gasless : priceImpactThresholds === null || priceImpactThresholds === void 0 ? void 0 : priceImpactThresholds.normal;
    if (threshold === null || threshold === undefined) {
      return false;
    }
    return Number(priceImpact) >= Number(threshold);
  }, [isGasless, priceImpact, shouldRenderPriceImpactRow, priceImpactThresholds]);
  const secondsUntilNextRefresh = (0, _useCountdownTimer.useCountdownTimer)();
  if (!activeQuote) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_bridgeQuotesModal.BridgeQuotesModal, {
    isOpen: showAllQuotes,
    onClose: () => setShowAllQuotes(false)
  }), /*#__PURE__*/_react.default.createElement(_layout.Column, {
    gap: 2
  }, /*#__PURE__*/_react.default.createElement(_layout.Row, {
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, /*#__PURE__*/_react.default.createElement(_layout.Row, {
    gap: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative
  }, t('multichainQuoteCardRateLabel')), isQuoteGoingToRefresh && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: getTimerColor(secondsUntilNextRefresh)
  }, `(0:${secondsUntilNextRefresh < 10 ? '0' : ''}${secondsUntilNextRefresh})`), /*#__PURE__*/_react.default.createElement(_layout.Tooltip, {
    title: t('multichainQuoteCardRateLabel'),
    position: _componentLibrary.PopoverPosition.TopStart,
    offset: [-16, 16]
  }, t('multichainQuoteCardRateExplanation', [new _bignumber.BigNumber(activeQuote.quote.feeData.metabridge.amount).gt(0) ? (0, _utils.bpsToPercentage)(
  // @ts-expect-error: controller types are not up to date yet
  activeQuote.quote.feeData.metabridge.quoteBpsFee) ?? _bridgeController.BRIDGE_MM_FEE_RATE : '0']))), /*#__PURE__*/_react.default.createElement(_layout.Row, {
    gap: 1
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative
  }, `1 ${activeQuote.quote.srcAsset.symbol} = ${(0, _quote.formatTokenAmount)(locale, activeQuote.swapRate)} ${activeQuote.quote.destAsset.symbol}`), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    iconName: _componentLibrary.IconName.ArrowRight,
    size: _componentLibrary.ButtonIconSize.Sm,
    color: _designSystem.IconColor.iconAlternative,
    onClick: () => {
      var _activeQuote$quote4, _activeQuote$quote5, _activeQuote$quote6;
      (fromChain === null || fromChain === void 0 ? void 0 : fromChain.chainId) && activeQuote && dispatch((0, _actions.trackUnifiedSwapBridgeEvent)(_bridgeController.UnifiedSwapBridgeEventName.AllQuotesOpened, {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        can_submit: !insufficientBal,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        stx_enabled: isStxEnabled,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        token_symbol_source: (fromToken === null || fromToken === void 0 ? void 0 : fromToken.symbol) ?? (0, _bridgeController.getNativeAssetForChainId)(fromChain.chainId).symbol,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        token_symbol_destination: (toToken === null || toToken === void 0 ? void 0 : toToken.symbol) ?? null,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        price_impact: Number(((_activeQuote$quote4 = activeQuote.quote) === null || _activeQuote$quote4 === void 0 || (_activeQuote$quote4 = _activeQuote$quote4.priceData) === null || _activeQuote$quote4 === void 0 ? void 0 : _activeQuote$quote4.priceImpact) ?? '0'),
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        gas_included: Boolean((_activeQuote$quote5 = activeQuote.quote) === null || _activeQuote$quote5 === void 0 ? void 0 : _activeQuote$quote5.gasIncluded),
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // @ts-expect-error gas_included_7702 needs to be added to bridge-controller types
        // eslint-disable-next-line @typescript-eslint/naming-convention
        gas_included_7702: Boolean((_activeQuote$quote6 = activeQuote.quote) === null || _activeQuote$quote6 === void 0 ? void 0 : _activeQuote$quote6.gasIncluded7702)
      }));
      setShowAllQuotes(true);
    },
    ariaLabel: t('moreQuotes')
  }))), /*#__PURE__*/_react.default.createElement(_layout.Row, {
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, /*#__PURE__*/_react.default.createElement(_layout.Row, {
    gap: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative
  }, t('networkFee')), /*#__PURE__*/_react.default.createElement(_layout.Tooltip, {
    title: t('networkFeeExplanationTitle'),
    position: _componentLibrary.PopoverPosition.TopStart,
    offset: [-16, 16]
  }, t('networkFeeExplanation'))), activeQuote.quote.gasIncluded && /*#__PURE__*/_react.default.createElement(_layout.Row, {
    gap: 1,
    "data-testid": "network-fees-included"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative,
    style: {
      textDecoration: 'line-through'
    }
  }, (_activeQuote$included = activeQuote.includedTxFees) !== null && _activeQuote$included !== void 0 && _activeQuote$included.valueInCurrency ? (0, _quote.formatCurrencyAmount)(activeQuote.includedTxFees.valueInCurrency, currency, 2) : (0, _quote.formatCurrencyAmount)((_activeQuote$totalNet = activeQuote.totalNetworkFee) === null || _activeQuote$totalNet === void 0 ? void 0 : _activeQuote$totalNet.valueInCurrency, currency, 2)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative
  }, t('swapGasFeesIncluded'))), !activeQuote.quote.gasIncluded && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative,
    "data-testid": "network-fees"
  }, (0, _quote.formatCurrencyAmount)((_activeQuote$totalNet2 = activeQuote.totalNetworkFee) === null || _activeQuote$totalNet2 === void 0 ? void 0 : _activeQuote$totalNet2.valueInCurrency, currency, 2))), /*#__PURE__*/_react.default.createElement(_layout.Row, {
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, /*#__PURE__*/_react.default.createElement(_layout.Row, {
    gap: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative
  }, t('slippage')), /*#__PURE__*/_react.default.createElement(_layout.Tooltip, {
    title: t('slippage'),
    position: _componentLibrary.PopoverPosition.TopStart,
    offset: [-16, 16]
  }, t('slippageExplanation'))), /*#__PURE__*/_react.default.createElement(_layout.Row, {
    gap: 1
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative
  }, slippage === undefined && isSolanaSwap ? t('slippageAuto') : `${slippage}%`), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    iconName: _componentLibrary.IconName.Edit,
    size: _componentLibrary.ButtonIconSize.Sm,
    color: _designSystem.IconColor.iconAlternative,
    onClick: onOpenSlippageModal,
    ariaLabel: t('slippageEditAriaLabel'),
    "data-testid": "slippage-edit-button"
  }))), /*#__PURE__*/_react.default.createElement(_layout.Row, {
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, /*#__PURE__*/_react.default.createElement(_layout.Row, {
    gap: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative
  }, t('minimumReceivedLabel')), /*#__PURE__*/_react.default.createElement(_layout.Tooltip, {
    style: {
      width: 350
    },
    title: t('minimumReceivedExplanationTitle'),
    position: _componentLibrary.PopoverPosition.TopStart,
    offset: [-48, 16]
  }, t('minimumReceivedExplanation'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative,
    "data-testid": "minimum-received"
  }, (0, _quote.formatCurrencyAmount)(activeQuote.minToTokenAmount.valueInCurrency, currency, 2))), shouldRenderPriceImpactRow && shouldShowPriceImpactWarning && /*#__PURE__*/_react.default.createElement(_layout.Row, {
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, /*#__PURE__*/_react.default.createElement(_layout.Row, {
    gap: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative
  }, t('bridgePriceImpact')), /*#__PURE__*/_react.default.createElement(_layout.Tooltip, {
    title: shouldShowPriceImpactWarning ? t('bridgePriceImpactWarningTitle') : t('bridgePriceImpactTooltipTitle'),
    position: _componentLibrary.PopoverPosition.TopStart,
    offset: [-16, 16]
  }, t('bridgePriceImpactNormalWarning'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: shouldShowPriceImpactWarning ? _designSystem.TextColor.errorDefault : _designSystem.TextColor.textAlternative
  }, (0, _priceImpact.formatPriceImpact)(priceImpact))), isToOrFromNonEvm && selectedDestinationAccount && /*#__PURE__*/_react.default.createElement(_layout.Row, {
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative
  }, t('recipient')), /*#__PURE__*/_react.default.createElement(_layout.Row, {
    gap: 1
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative
  }, selectedDestinationAccount.displayName), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    iconName: _componentLibrary.IconName.Edit,
    size: _componentLibrary.ButtonIconSize.Sm,
    color: _designSystem.IconColor.iconAlternative,
    onClick: onOpenRecipientModal,
    ariaLabel: t('recipientEditAriaLabel'),
    "data-testid": "recipient-edit-button"
  })))));
};
exports.MultichainBridgeQuoteCard = MultichainBridgeQuoteCard;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\quotes\\multichain-bridge-quote-card.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\transaction-details\\bridge-activity-item-tx-segments.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","./segment":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\transaction-details\\segment.tsx","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Ctransaction-details%5Cbridge-activity-item-tx-segments.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = BridgeActivityItemTxSegments;
var _react = _interopRequireDefault(require("react"));
var _transactionController = require("@metamask/transaction-controller");
var _bridgeController = require("@metamask/bridge-controller");
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _segment = _interopRequireDefault(require("./segment"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const getTxIndex = srcTxStatus => {
  if (srcTxStatus === _bridgeController.StatusTypes.PENDING) {
    return 1;
  }
  if (srcTxStatus === _bridgeController.StatusTypes.COMPLETE) {
    return 2;
  }
  throw new Error('No more possible states for srcTxStatus');
};
const getSrcTxStatus = initialTransaction => {
  return initialTransaction.status === _transactionController.TransactionStatus.confirmed ? _bridgeController.StatusTypes.COMPLETE : _bridgeController.StatusTypes.PENDING;
};
const getDestTxStatus = ({
  bridgeTxHistoryItem,
  srcTxStatus
}) => {
  var _bridgeTxHistoryItem$;
  if (srcTxStatus !== _bridgeController.StatusTypes.COMPLETE) {
    return null;
  }
  return bridgeTxHistoryItem !== null && bridgeTxHistoryItem !== void 0 && (_bridgeTxHistoryItem$ = bridgeTxHistoryItem.status.destChain) !== null && _bridgeTxHistoryItem$ !== void 0 && _bridgeTxHistoryItem$.txHash && bridgeTxHistoryItem.status.status === _bridgeController.StatusTypes.COMPLETE ? _bridgeController.StatusTypes.COMPLETE : _bridgeController.StatusTypes.PENDING;
};

/**
 * Renders the 2 transaction segments for a bridge activity item
 *
 * @param options
 * @param options.bridgeTxHistoryItem - The bridge history item for the transaction
 * @param options.transactionGroup - The transaction group for the transaction
 */
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function BridgeActivityItemTxSegments({
  bridgeTxHistoryItem,
  transactionGroup
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    initialTransaction
  } = transactionGroup;
  const srcTxStatus = getSrcTxStatus(initialTransaction);
  const destTxStatus = getDestTxStatus({
    bridgeTxHistoryItem,
    srcTxStatus
  });
  const txIndex = getTxIndex(srcTxStatus);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textAlternative
  }, t('bridgeTransactionProgress', [txIndex])), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    gap: 2,
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_segment.default, {
    type: srcTxStatus
  }), /*#__PURE__*/_react.default.createElement(_segment.default, {
    type: destTxStatus
  })));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\transaction-details\\bridge-activity-item-tx-segments.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\transaction-details\\bridge-explorer-links.tsx", {"../../../../shared/constants/common":"D:\\code\\v\\metamask-extension\\shared\\constants\\common.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/multichain/menu-items/view-explorer-menu-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\menu-items\\view-explorer-menu-item.tsx","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Ctransaction-details%5Cbridge-explorer-links.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = BridgeExplorerLinks;
var _react = _interopRequireWildcard(require("react"));
var _bridgeController = require("@metamask/bridge-controller");
var _common = require("../../../../shared/constants/common");
var _componentLibrary = require("../../../components/component-library");
var _viewExplorerMenuItem = require("../../../components/multichain/menu-items/view-explorer-menu-item");
var _metametrics = require("../../../contexts/metametrics");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getBlockExplorerName = (chainId, blockExplorerUrl) => {
  const hexChainId = chainId && !(0, _bridgeController.isNonEvmChainId)(chainId) ? (0, _bridgeController.formatChainIdToHex)(chainId) : undefined;
  const humanReadableUrl = hexChainId ? _common.CHAINID_DEFAULT_BLOCK_EXPLORER_HUMAN_READABLE_URL_MAP[hexChainId] : undefined;
  if (humanReadableUrl) {
    return humanReadableUrl;
  }
  if (!blockExplorerUrl) {
    return undefined;
  }
  return blockExplorerUrl.split('/')[2];
};
const METRICS_LOCATION = 'Activity Tab';
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function BridgeExplorerLinks({
  srcChainId,
  destChainId,
  srcBlockExplorerUrl,
  destBlockExplorerUrl
}) {
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const t = (0, _useI18nContext.useI18nContext)();

  // Not sure why but the text is not being changed to white on hover, unless it's put into a variable before the render
  const srcButtonText = t('bridgeExplorerLinkViewOn', [getBlockExplorerName(srcChainId, srcBlockExplorerUrl)]);
  const destButtonText = destBlockExplorerUrl ? t('bridgeExplorerLinkViewOn', [getBlockExplorerName(destChainId, destBlockExplorerUrl)]) : undefined;
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 4
  }, srcBlockExplorerUrl && /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonSecondary, {
    endIconName: _componentLibrary.IconName.Export,
    onClick: () => {
      if (srcBlockExplorerUrl) {
        (0, _viewExplorerMenuItem.openBlockExplorer)(srcBlockExplorerUrl, METRICS_LOCATION, trackEvent);
      }
    }
  }, srcButtonText), destBlockExplorerUrl && /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonSecondary, {
    endIconName: _componentLibrary.IconName.Export,
    onClick: () => {
      if (destBlockExplorerUrl) {
        (0, _viewExplorerMenuItem.openBlockExplorer)(destBlockExplorerUrl, METRICS_LOCATION, trackEvent);
      }
    }
  }, destButtonText));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\transaction-details\\bridge-explorer-links.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\transaction-details\\bridge-step-description.tsx", {"../../../../shared/constants/bridge":"D:\\code\\v\\metamask-extension\\shared\\constants\\bridge.ts","../../../../shared/modules/Numeric":"D:\\code\\v\\metamask-extension\\shared\\modules\\Numeric.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Ctransaction-details%5Cbridge-step-description.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = BridgeStepDescription;
exports.getStepStatus = void 0;
var React = _interopRequireWildcard(require("react"));
var _transactionController = require("@metamask/transaction-controller");
var _bridgeController = require("@metamask/bridge-controller");
var _componentLibrary = require("../../../components/component-library");
var _Numeric = require("../../../../shared/modules/Numeric");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _bridge = require("../../../../shared/constants/bridge");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * bridge actions will have step.srcChainId !== step.destChainId
 * We cannot infer the status of the bridge action since 2 different chains are involved
 * The best we can do is the bridgeHistoryItem.estimatedProcessingTimeInSeconds
 *
 * @param t - The i18n context return value to get translations
 * @param stepStatus - The status of the step
 * @param step - The step to be rendered
 */
const getBridgeActionText = (t, stepStatus, step) => {
  var _step$destAsset;
  const hexDestChainId = step.destChainId ? new _Numeric.Numeric(step.destChainId, 10).toPrefixedHexString() : undefined;
  const destChainName = hexDestChainId ? _bridge.NETWORK_TO_SHORT_NETWORK_NAME_MAP[hexDestChainId] : '';
  const destSymbol = (_step$destAsset = step.destAsset) === null || _step$destAsset === void 0 ? void 0 : _step$destAsset.symbol;
  if (!destSymbol) {
    return null;
  }
  return stepStatus === _bridgeController.StatusTypes.COMPLETE ? t('bridgeStepActionBridgeComplete', [destSymbol, destChainName]) : t('bridgeStepActionBridgePending', [destSymbol, destChainName]);
};
const getBridgeActionStatus = bridgeHistoryItem => {
  return bridgeHistoryItem.status ? bridgeHistoryItem.status.status : null;
};

/**
 * swap actions can have step.srcChainId === step.destChainId, and can occur on
 * EITHER the quote.srcChainId or the quote.destChainId
 * Despite not having any actual timestamp,we can infer the status of the swap action
 * based on the status of the source chain tx if srcChainId and destChainId are the same*
 *
 * @param bridgeHistoryItem
 * @param step
 * @param srcChainTxMeta
 */
const getSwapActionStatus = (bridgeHistoryItem, step, srcChainTxMeta) => {
  const isSrcAndDestChainSame = step.srcChainId === step.destChainId;
  const isSwapOnSrcChain = step.srcChainId === bridgeHistoryItem.quote.srcChainId;
  if (isSrcAndDestChainSame && isSwapOnSrcChain) {
    // if the swap action is on the src chain (i.e. step.srcChainId === step.destChainId === bridgeHistoryItem.quote.srcChainId),
    // we check the source chain tx status, since we know when it's confirmed
    const isSrcChainTxConfirmed = (srcChainTxMeta === null || srcChainTxMeta === void 0 ? void 0 : srcChainTxMeta.status) === _transactionController.TransactionStatus.confirmed;
    return isSrcChainTxConfirmed ? _bridgeController.StatusTypes.COMPLETE : _bridgeController.StatusTypes.PENDING;
  }
  // if the swap action is on the dest chain, we check the bridgeHistoryItem.status,
  // since we don't know when the dest tx is confirmed
  if ((srcChainTxMeta === null || srcChainTxMeta === void 0 ? void 0 : srcChainTxMeta.status) === _transactionController.TransactionStatus.confirmed) {
    return bridgeHistoryItem.status ? bridgeHistoryItem.status.status : null;
  }

  // If the source chain tx is not confirmed, we know the swap hasn't started
  // use null to represent this as we don't have an equivalent in StatusTypes
  return null;
};
const getSwapActionText = (t, status, step) => {
  var _step$srcAsset, _step$destAsset2;
  const srcSymbol = (_step$srcAsset = step.srcAsset) === null || _step$srcAsset === void 0 ? void 0 : _step$srcAsset.symbol;
  const destSymbol = (_step$destAsset2 = step.destAsset) === null || _step$destAsset2 === void 0 ? void 0 : _step$destAsset2.symbol;
  if (!srcSymbol || !destSymbol) {
    return null;
  }
  return status === _bridgeController.StatusTypes.COMPLETE ? t('bridgeStepActionSwapComplete', [srcSymbol, destSymbol]) : t('bridgeStepActionSwapPending', [srcSymbol, destSymbol]);
};
const getStepStatus = ({
  bridgeHistoryItem,
  step,
  srcChainTxMeta
}) => {
  if (!bridgeHistoryItem) {
    return _bridgeController.StatusTypes.UNKNOWN;
  }
  if (step.action === _bridgeController.ActionTypes.SWAP) {
    return getSwapActionStatus(bridgeHistoryItem, step, srcChainTxMeta);
  } else if (step.action === _bridgeController.ActionTypes.BRIDGE) {
    return getBridgeActionStatus(bridgeHistoryItem);
  }
  return _bridgeController.StatusTypes.UNKNOWN;
};
exports.getStepStatus = getStepStatus;
// You can have the following cases:
// 1. Bridge: usually for cases like Optimism ETH to Arbitrum ETH
// 2. Swap > Bridge
// 3. Swap > Bridge > Swap: e.g. Optimism ETH to Avalanche USDC
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function BridgeStepDescription({
  step,
  time,
  stepStatus
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/React.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    gap: 2,
    className: "bridge-transaction-details__step-grid--desc"
  }, time && /*#__PURE__*/React.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textDefault
  }, time), /*#__PURE__*/React.createElement(_componentLibrary.Text, {
    color: stepStatus === _bridgeController.StatusTypes.PENDING || stepStatus === _bridgeController.StatusTypes.COMPLETE ? _designSystem.TextColor.textDefault : _designSystem.TextColor.textAlternative,
    fontWeight: stepStatus === _bridgeController.StatusTypes.PENDING ? _designSystem.FontWeight.Medium : _designSystem.FontWeight.Normal
  }, step.action === _bridgeController.ActionTypes.BRIDGE && getBridgeActionText(t, stepStatus, step), step.action === _bridgeController.ActionTypes.SWAP && getSwapActionText(t, stepStatus, step)));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\transaction-details\\bridge-step-description.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\transaction-details\\bridge-step-list.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","./bridge-step-description":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\transaction-details\\bridge-step-description.tsx","./step-progress-bar-item":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\transaction-details\\step-progress-bar-item.tsx","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Ctransaction-details%5Cbridge-step-list.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = BridgeStepList;
var _react = _interopRequireDefault(require("react"));
var _bridgeController = require("@metamask/bridge-controller");
var _componentLibrary = require("../../../components/component-library");
var _util = require("../../../helpers/utils/util");
var _bridgeStepDescription = _interopRequireWildcard(require("./bridge-step-description"));
var _stepProgressBarItem = _interopRequireDefault(require("./step-progress-bar-item"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const getTime = (index, isLastIndex, startTime, estimatedProcessingTimeInSeconds) => {
  if (index === 0) {
    return startTime;
  }
  return isLastIndex && startTime && estimatedProcessingTimeInSeconds ? startTime + estimatedProcessingTimeInSeconds * 1000 : undefined;
};
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function BridgeStepList({
  bridgeHistoryItem,
  srcChainTxMeta
}) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  const steps = (bridgeHistoryItem === null || bridgeHistoryItem === void 0 ? void 0 : bridgeHistoryItem.quote.steps) || [];
  const stepStatuses = steps.map(step => (0, _bridgeStepDescription.getStepStatus)({
    bridgeHistoryItem,
    step,
    srcChainTxMeta
  }));
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "bridge-transaction-details__step-grid"
  }, steps.map((step, i) => {
    const prevStepStatus = i > 0 ? stepStatuses[i - 1] : null;
    const stepStatus = stepStatuses[i];
    const nextStepStatus = i < stepStatuses.length - 1 ? stepStatuses[i + 1] : null;
    const isEdgeComplete = stepStatus === _bridgeController.StatusTypes.COMPLETE && (nextStepStatus === _bridgeController.StatusTypes.PENDING || nextStepStatus === _bridgeController.StatusTypes.COMPLETE);

    // Making a distinction betweeen displayedStepStatus and stepStatus
    // stepStatus is determined independently of other steps
    // So despite both being technically PENDING,
    // We only want a single spinner animation at a time, so we need to take into account other steps
    const displayedStepStatus = prevStepStatus === _bridgeController.StatusTypes.PENDING && stepStatus === _bridgeController.StatusTypes.PENDING ? null : stepStatus;
    const time = (0, _util.formatDate)(getTime(i, i === steps.length - 1,
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    (bridgeHistoryItem === null || bridgeHistoryItem === void 0 ? void 0 : bridgeHistoryItem.startTime) || (srcChainTxMeta === null || srcChainTxMeta === void 0 ? void 0 : srcChainTxMeta.time),
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    (bridgeHistoryItem === null || bridgeHistoryItem === void 0 ? void 0 : bridgeHistoryItem.estimatedProcessingTimeInSeconds) || 0), 'hh:mm a');
    return /*#__PURE__*/_react.default.createElement(_stepProgressBarItem.default, {
      key: `progress-${step.action}-${step.srcChainId}-${step.destChainId}`,
      stepStatus: displayedStepStatus,
      isLastItem: i === steps.length - 1,
      isEdgeComplete: isEdgeComplete
    }, /*#__PURE__*/_react.default.createElement(_bridgeStepDescription.default, {
      step: step,
      stepStatus: displayedStepStatus,
      time: time
    }));
  }));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\transaction-details\\bridge-step-list.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\transaction-details\\hollow-circle.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Ctransaction-details%5Chollow-circle.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var React = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HollowCircle = /*#__PURE__*/React.forwardRef(({
  size = _componentLibrary.IconSize.Md,
  color,
  className = '',
  style
}, ref) => {
  return /*#__PURE__*/React.createElement(_componentLibrary.Box, {
    className: (0, _classnames.default)(className, 'mm-icon', `mm-icon--size-${size}`),
    ref: ref,
    as: "span",
    display: _designSystem.Display.InlineBlock,
    style: {
      height: '12px',
      width: '12px',
      border: `1px solid var(--color-${color})`,
      borderRadius: '50%',
      backgroundColor: `var(--color-${_designSystem.BackgroundColor.backgroundDefault})`,
      zIndex: 1,
      ...style
    }
  });
});
var _default = exports.default = HollowCircle;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\transaction-details\\hollow-circle.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\transaction-details\\pulsing-circle.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","./hollow-circle":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\transaction-details\\hollow-circle.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Ctransaction-details%5Cpulsing-circle.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = PulsingCircle;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _hollowCircle = _interopRequireDefault(require("./hollow-circle"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * Renders the steps in the Bridge Transaction Details page
 *
 * @param options
 * @param options.iconSize - The size of the icon
 * @param options.color - The color of the icon
 */
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function PulsingCircle({
  iconSize,
  color
}) {
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    style: {
      position: 'relative'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "bridge-transaction-details__icon-loading" // Needed for animation
    ,
    backgroundColor: _designSystem.BackgroundColor.primaryMuted,
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.center,
    borderRadius: _designSystem.BorderRadius.full,
    style: {
      width: '2rem',
      height: '2rem'
    }
  }), /*#__PURE__*/_react.default.createElement(_hollowCircle.default, {
    size: iconSize,
    color: color,
    style: {
      position: 'absolute',
      left: '50%',
      top: '50%',
      transform: 'translate(-50%, -50%)',
      borderWidth: '2px'
    }
  }));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\transaction-details\\pulsing-circle.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\transaction-details\\segment.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Ctransaction-details%5Csegment.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Segment;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _bridgeController = require("@metamask/bridge-controller");
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function Segment({
  type
}) {
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    width: _designSystem.BlockSize.Full,
    backgroundColor: _designSystem.BackgroundColor.backgroundAlternative,
    borderRadius: _designSystem.BorderRadius.pill
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    width: _designSystem.BlockSize.Full,
    backgroundColor: _designSystem.BackgroundColor.primaryDefault,
    borderRadius: _designSystem.BorderRadius.pill,
    className: (0, _classnames.default)({
      'bridge-transaction-details__segment': true,
      'bridge-transaction-details__segment--pending': type === _bridgeController.StatusTypes.PENDING,
      'bridge-transaction-details__segment--complete': type === _bridgeController.StatusTypes.COMPLETE
    })
  }));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\transaction-details\\segment.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\transaction-details\\step-progress-bar-item.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","./hollow-circle":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\transaction-details\\hollow-circle.tsx","./pulsing-circle":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\transaction-details\\pulsing-circle.tsx","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Ctransaction-details%5Cstep-progress-bar-item.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = StepProgressBarItem;
var _react = _interopRequireDefault(require("react"));
var _bridgeController = require("@metamask/bridge-controller");
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _hollowCircle = _interopRequireDefault(require("./hollow-circle"));
var _pulsingCircle = _interopRequireDefault(require("./pulsing-circle"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const ICON_SIZE = _componentLibrary.IconSize.Xs;
const VerticalLine = ({
  color
}) => /*#__PURE__*/_react.default.createElement("div", {
  style: {
    height: '60px',
    marginTop: '-1rem',
    marginBottom: '-1rem',
    width: '1px',
    backgroundColor: `var(--color-${color})`,
    zIndex: 0.1
  }
});
/**
 * Renders the steps in the Bridge Transaction Details page
 *
 * @param options
 * @param options.stepStatus - The status of the step
 * @param options.isLastItem - Whether the step is the last item
 * @param options.isEdgeComplete - Whether the edge is complete
 * @param options.children - The description of the step to be rendered
 */
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function StepProgressBarItem({
  stepStatus,
  isLastItem,
  isEdgeComplete,
  children
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (stepStatus === null || stepStatus === _bridgeController.StatusTypes.UNKNOWN) && /*#__PURE__*/_react.default.createElement(_hollowCircle.default, {
    size: ICON_SIZE,
    color: _designSystem.IconColor.iconMuted
  }), stepStatus === _bridgeController.StatusTypes.PENDING && /*#__PURE__*/_react.default.createElement(_pulsingCircle.default, {
    iconSize: ICON_SIZE,
    color: _designSystem.IconColor.primaryDefault
  }), stepStatus === _bridgeController.StatusTypes.COMPLETE && /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.FullCircle,
    color: _designSystem.IconColor.primaryDefault,
    size: ICON_SIZE
  }), children, !isLastItem && /*#__PURE__*/_react.default.createElement(VerticalLine, {
    color: isEdgeComplete ? _designSystem.IconColor.primaryDefault : _designSystem.IconColor.iconMuted
  }), !isLastItem && /*#__PURE__*/_react.default.createElement("div", null));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\transaction-details\\step-progress-bar-item.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\transaction-details\\transaction-detail-row.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Ctransaction-details%5Ctransaction-detail-row.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = TransactionDetailRow;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function TransactionDetailRow({
  title,
  value
}) {
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    "data-testid": "transaction-detail-row",
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    minWidth: _designSystem.BlockSize.Max,
    paddingRight: 1,
    variant: _designSystem.TextVariant.bodyMd
  }, title), value);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\transaction-details\\transaction-detail-row.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\transaction-details\\transaction-details.tsx", {"../../../../shared/constants/bridge":"D:\\code\\v\\metamask-extension\\shared\\constants\\bridge.ts","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/modules/Numeric":"D:\\code\\v\\metamask-extension\\shared\\modules\\Numeric.ts","../../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../../components/app/confirm/info/row":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\index.ts","../../../components/app/transaction-activity-log":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\transaction-activity-log\\index.js","../../../components/app/transaction-breakdown/transaction-breakdown-utils":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\transaction-breakdown\\transaction-breakdown-utils.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/multichain/pages/page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\index.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../ducks/bridge-status/selectors":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge-status\\selectors.ts","../../../ducks/locale/locale":"D:\\code\\v\\metamask-extension\\ui\\ducks\\locale\\locale.ts","../../../helpers/constants/common":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\common.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../hooks/bridge/useBridgeChainInfo":"D:\\code\\v\\metamask-extension\\ui\\hooks\\bridge\\useBridgeChainInfo.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../utils/quote":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\utils\\quote.ts","../utils/tx-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\utils\\tx-details.ts","./bridge-explorer-links":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\transaction-details\\bridge-explorer-links.tsx","./bridge-step-list":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\transaction-details\\bridge-step-list.tsx","./transaction-detail-row":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\transaction-details\\transaction-detail-row.tsx","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Ctransaction-details%5Ctransaction-details.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _transactionController = require("@metamask/transaction-controller");
var _bridgeController = require("@metamask/bridge-controller");
var _componentLibrary = require("../../../components/component-library");
var _page = require("../../../components/multichain/pages/page");
var _selectors = require("../../../ducks/bridge-status/selectors");
var _useBridgeChainInfo = _interopRequireDefault(require("../../../hooks/bridge/useBridgeChainInfo"));
var _transactionBreakdownUtils = require("../../../components/app/transaction-breakdown/transaction-breakdown-utils");
var _conversion = require("../../../../shared/modules/conversion.utils");
var _common = require("../../../helpers/constants/common");
var _designSystem = require("../../../helpers/constants/design-system");
var _util = require("../../../helpers/utils/util");
var _row = require("../../../components/app/confirm/info/row");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _selectors2 = require("../../../selectors");
var _metametrics = require("../../../../shared/constants/metametrics");
var _metametrics2 = require("../../../contexts/metametrics");
var _locale = require("../../../ducks/locale/locale");
var _transactionActivityLog = _interopRequireDefault(require("../../../components/app/transaction-activity-log"));
var _bridge = require("../../../../shared/constants/bridge");
var _Numeric = require("../../../../shared/modules/Numeric");
var _multichain = require("../../../selectors/multichain");
var _quote = require("../utils/quote");
var _txDetails = require("../utils/tx-details");
var _transactionDetailRow = _interopRequireDefault(require("./transaction-detail-row"));
var _bridgeExplorerLinks = _interopRequireDefault(require("./bridge-explorer-links"));
var _bridgeStepList = _interopRequireDefault(require("./bridge-step-list"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CrossChainSwapTxDetails = () => {
  var _location$state, _location$state2, _bridgeHistoryItem$st;
  const t = (0, _useI18nContext.useI18nContext)();
  const locale = (0, _reactRedux.useSelector)(_locale.getIntlLocale);
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const rootState = (0, _reactRedux.useSelector)(state => state);
  const history = (0, _reactRouterDom.useHistory)();
  const location = (0, _reactRouterDom.useLocation)();
  const {
    srcTxMetaId
  } = (0, _reactRouterDom.useParams)();
  const selectedAddressTxList = (0, _reactRedux.useSelector)(_selectors2.selectedAddressTxListSelectorAllChain);
  const transactionGroup = ((_location$state = location.state) === null || _location$state === void 0 ? void 0 : _location$state.transactionGroup) || null;
  const isEarliestNonce = ((_location$state2 = location.state) === null || _location$state2 === void 0 ? void 0 : _location$state2.isEarliestNonce) || null;
  const srcChainTxMeta = selectedAddressTxList.find(tx => tx.id === srcTxMetaId);
  // Even if user is still on /tx-details/txMetaId, we want to be able to show the bridge history item
  const bridgeHistoryItem = (0, _reactRedux.useSelector)(state => (0, _selectors.selectBridgeHistoryItemForTxMetaId)(state, srcTxMetaId));
  const approvalTxMeta = selectedAddressTxList.find(tx => tx.id === (bridgeHistoryItem === null || bridgeHistoryItem === void 0 ? void 0 : bridgeHistoryItem.approvalTxId));
  const {
    srcNetwork,
    destNetwork
  } = (0, _useBridgeChainInfo.default)({
    bridgeHistoryItem,
    srcTxMeta: srcChainTxMeta
  });
  const srcTxHash = srcChainTxMeta === null || srcChainTxMeta === void 0 ? void 0 : srcChainTxMeta.hash;
  const srcBlockExplorerUrl = (0, _txDetails.getBlockExplorerUrl)(srcNetwork, srcTxHash);
  const destTxHash = bridgeHistoryItem === null || bridgeHistoryItem === void 0 || (_bridgeHistoryItem$st = bridgeHistoryItem.status.destChain) === null || _bridgeHistoryItem$st === void 0 ? void 0 : _bridgeHistoryItem$st.txHash;
  const destBlockExplorerUrl = (0, _txDetails.getBlockExplorerUrl)(destNetwork, destTxHash);
  const bridgeStatus = bridgeHistoryItem ? bridgeHistoryItem === null || bridgeHistoryItem === void 0 ? void 0 : bridgeHistoryItem.status.status : _bridgeController.StatusTypes.PENDING;
  // Show src tx status for swaps
  const status = (srcChainTxMeta === null || srcChainTxMeta === void 0 ? void 0 : srcChainTxMeta.type) === _transactionController.TransactionType.bridge ? bridgeStatus : srcChainTxMeta === null || srcChainTxMeta === void 0 ? void 0 : srcChainTxMeta.status;
  const srcChainIconUrl = srcNetwork ? (0, _multichain.getImageForChainId)(srcNetwork.isEvm ? (0, _bridgeController.formatChainIdToHex)(srcNetwork.chainId) : srcNetwork.chainId) : undefined;
  const destChainIconUrl = destNetwork ? (0, _multichain.getImageForChainId)(destNetwork.isEvm ? (0, _bridgeController.formatChainIdToHex)(destNetwork.chainId) : destNetwork.chainId) : undefined;
  const srcNetworkName = _bridge.NETWORK_TO_SHORT_NETWORK_NAME_MAP[srcNetwork === null || srcNetwork === void 0 ? void 0 : srcNetwork.chainId];
  const destNetworkName = _bridge.NETWORK_TO_SHORT_NETWORK_NAME_MAP[destNetwork === null || destNetwork === void 0 ? void 0 : destNetwork.chainId];
  const data = srcChainTxMeta ? (0, _transactionBreakdownUtils.getTransactionBreakdownData)({
    state: rootState,
    transaction: srcChainTxMeta,
    isTokenApprove: false
  }) : undefined;
  const bridgeAmountSent = (0, _txDetails.getBridgeAmountSentFormatted)({
    bridgeHistoryItem,
    txMeta: srcChainTxMeta
  });
  const swapAmountReceivedFromTxMeta = (0, _reactRedux.useSelector)(state => (0, _selectors.selectReceivedSwapsTokenAmountFromTxMeta)(state, bridgeHistoryItem === null || bridgeHistoryItem === void 0 ? void 0 : bridgeHistoryItem.txMetaId, srcChainTxMeta, approvalTxMeta));
  const amountReceived = (srcChainTxMeta === null || srcChainTxMeta === void 0 ? void 0 : srcChainTxMeta.type) === _transactionController.TransactionType.swap && swapAmountReceivedFromTxMeta || (0, _txDetails.getBridgeAmountReceivedFormatted)({
    locale,
    bridgeHistoryItem,
    txMeta: srcChainTxMeta
  });
  const isDelayed = (srcChainTxMeta === null || srcChainTxMeta === void 0 ? void 0 : srcChainTxMeta.type) === _transactionController.TransactionType.bridge && (0, _txDetails.getIsDelayed)(bridgeStatus, bridgeHistoryItem);

  // TODO set for gasless swaps
  const gasCurrency = (0, _selectors2.getNativeTokenInfo)(rootState, (srcChainTxMeta === null || srcChainTxMeta === void 0 ? void 0 : srcChainTxMeta.chainId) ?? '');
  const srcNetworkIconName = /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    gap: 1,
    alignItems: _designSystem.AlignItems.center
  }, srcNetwork && /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
    size: _componentLibrary.AvatarNetworkSize.Xs,
    src: srcChainIconUrl,
    name: srcNetwork === null || srcNetwork === void 0 ? void 0 : srcNetwork.name
  }), srcNetworkName);
  const destNetworkIconName = /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    gap: 1,
    alignItems: _designSystem.AlignItems.center
  }, destNetwork && /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
    size: _componentLibrary.AvatarNetworkSize.Xs,
    src: destChainIconUrl,
    name: destNetwork === null || destNetwork === void 0 ? void 0 : destNetwork.name
  }), destNetworkName);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "bridge__container"
  }, /*#__PURE__*/_react.default.createElement(_page.Header, {
    className: "bridge__header",
    startAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      iconName: _componentLibrary.IconName.ArrowLeft,
      size: _componentLibrary.ButtonIconSize.Sm,
      ariaLabel: t('back'),
      onClick: () => history.goBack()
    })
  }, t((srcChainTxMeta === null || srcChainTxMeta === void 0 ? void 0 : srcChainTxMeta.type) === _transactionController.TransactionType.bridge ? 'bridgeDetailsTitle' : 'swapDetailsTitle')), /*#__PURE__*/_react.default.createElement(_page.Content, {
    className: "bridge-transaction-details__content"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 4
  }, isDelayed && /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerAlert, {
    title: t('bridgeTxDetailsDelayedTitle'),
    severity: _componentLibrary.BannerAlertSeverity.Warning
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center
  }, t('bridgeTxDetailsDelayedDescription'), "\xA0", /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    externalLink: true,
    href: _common.SUPPORT_REQUEST_LINK,
    onClick: () => {
      trackEvent({
        category: _metametrics.MetaMetricsEventCategory.Home,
        event: _metametrics.MetaMetricsEventName.SupportLinkClicked,
        properties: {
          url: _common.SUPPORT_REQUEST_LINK,
          location: 'Bridge Tx Details'
        }
      }, {
        contextPropsIntoEventProperties: [_metametrics.MetaMetricsContextProp.PageTitle]
      });
    }
  }, t('bridgeTxDetailsDelayedDescriptionSupport')), ".")), status !== _bridgeController.StatusTypes.COMPLETE && (
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  bridgeHistoryItem || srcChainTxMeta) && /*#__PURE__*/_react.default.createElement(_bridgeStepList.default, {
    bridgeHistoryItem: bridgeHistoryItem,
    srcChainTxMeta: srcChainTxMeta
  }), /*#__PURE__*/_react.default.createElement(_bridgeExplorerLinks.default, {
    srcChainId: srcNetwork === null || srcNetwork === void 0 ? void 0 : srcNetwork.chainId,
    destChainId: destNetwork === null || destNetwork === void 0 ? void 0 : destNetwork.chainId,
    srcBlockExplorerUrl: srcBlockExplorerUrl,
    destBlockExplorerUrl: destBlockExplorerUrl
  }), /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRowDivider, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 2
  }, /*#__PURE__*/_react.default.createElement(_transactionDetailRow.default, {
    title: t('bridgeTxDetailsStatus'),
    value: /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      textTransform: _designSystem.TextTransform.Capitalize,
      color: status ? _txDetails.STATUS_TO_COLOR_MAP[status] : undefined
    }, status === null || status === void 0 ? void 0 : status.toLowerCase())
  }), (srcChainTxMeta === null || srcChainTxMeta === void 0 ? void 0 : srcChainTxMeta.type) === _transactionController.TransactionType.bridge && /*#__PURE__*/_react.default.createElement(_transactionDetailRow.default, {
    title: t(status === _bridgeController.StatusTypes.COMPLETE ? 'bridgeTxDetailsBridged' : 'bridgeTxDetailsBridging'),
    value: /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      gap: 1,
      alignItems: _designSystem.AlignItems.center,
      flexWrap: _designSystem.FlexWrap.Wrap,
      justifyContent: _designSystem.JustifyContent.flexEnd
    }, srcNetworkIconName, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
      name: _componentLibrary.IconName.Arrow2Right,
      size: _componentLibrary.IconSize.Sm
    }), destNetworkIconName)
  }), (srcChainTxMeta === null || srcChainTxMeta === void 0 ? void 0 : srcChainTxMeta.type) === _transactionController.TransactionType.swap && /*#__PURE__*/_react.default.createElement(_transactionDetailRow.default, {
    title: t((srcChainTxMeta === null || srcChainTxMeta === void 0 ? void 0 : srcChainTxMeta.status) === _transactionController.TransactionStatus.confirmed ? 'bridgeTxDetailsSwapped' : 'bridgeTxDetailsSwapping'),
    value: /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      gap: 1,
      alignItems: _designSystem.AlignItems.center,
      flexWrap: _designSystem.FlexWrap.Wrap,
      justifyContent: _designSystem.JustifyContent.flexEnd
    }, bridgeHistoryItem && /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarToken, {
      size: _componentLibrary.AvatarTokenSize.Xs,
      src: (bridgeHistoryItem === null || bridgeHistoryItem === void 0 ? void 0 : bridgeHistoryItem.quote.srcAsset.iconUrl) ?? undefined,
      name: bridgeHistoryItem === null || bridgeHistoryItem === void 0 ? void 0 : bridgeHistoryItem.quote.srcAsset.symbol
    }), bridgeHistoryItem === null || bridgeHistoryItem === void 0 ? void 0 : bridgeHistoryItem.quote.srcAsset.symbol, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
      name: _componentLibrary.IconName.Arrow2Right,
      size: _componentLibrary.IconSize.Sm
    }), bridgeHistoryItem && /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarToken, {
      size: _componentLibrary.AvatarTokenSize.Xs,
      src: (bridgeHistoryItem === null || bridgeHistoryItem === void 0 ? void 0 : bridgeHistoryItem.quote.destAsset.iconUrl) ?? undefined,
      name: bridgeHistoryItem === null || bridgeHistoryItem === void 0 ? void 0 : bridgeHistoryItem.quote.destAsset.symbol
    }), bridgeHistoryItem === null || bridgeHistoryItem === void 0 ? void 0 : bridgeHistoryItem.quote.destAsset.symbol)
  }), /*#__PURE__*/_react.default.createElement(_transactionDetailRow.default, {
    title: t('bridgeTxDetailsTimestamp'),
    value: t('bridgeTxDetailsTimestampValue', [(0, _util.formatDate)(srcChainTxMeta === null || srcChainTxMeta === void 0 ? void 0 : srcChainTxMeta.time, 'MMM d, yyyy'), (0, _util.formatDate)(srcChainTxMeta === null || srcChainTxMeta === void 0 ? void 0 : srcChainTxMeta.time, 'hh:mm a')])
  })), /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRowDivider, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 2
  }, /*#__PURE__*/_react.default.createElement(_transactionDetailRow.default, {
    title: t('bridgeTxDetailsYouSent'),
    value: /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      gap: 1,
      alignItems: _designSystem.AlignItems.center,
      flexWrap: _designSystem.FlexWrap.Wrap,
      justifyContent: _designSystem.JustifyContent.flexEnd
    }, t('bridgeTxDetailsTokenAmountOnChain', [bridgeAmountSent ?? '', (bridgeHistoryItem === null || bridgeHistoryItem === void 0 ? void 0 : bridgeHistoryItem.quote.srcAsset.symbol) ?? '']), srcNetworkIconName)
  }), amountReceived && (bridgeHistoryItem === null || bridgeHistoryItem === void 0 ? void 0 : bridgeHistoryItem.quote.destAsset.symbol) && /*#__PURE__*/_react.default.createElement(_transactionDetailRow.default, {
    title: t('bridgeTxDetailsYouReceived'),
    value: /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      gap: 1,
      alignItems: _designSystem.AlignItems.center,
      flexWrap: _designSystem.FlexWrap.Wrap,
      justifyContent: _designSystem.JustifyContent.flexEnd
    }, t('bridgeTxDetailsTokenAmountOnChain', [amountReceived, bridgeHistoryItem === null || bridgeHistoryItem === void 0 ? void 0 : bridgeHistoryItem.quote.destAsset.symbol]), destNetworkIconName)
  }), /*#__PURE__*/_react.default.createElement(_transactionDetailRow.default, {
    title: t('bridgeTxDetailsTotalGasFee'),
    value: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (data === null || data === void 0 ? void 0 : data.hexGasTotal) && (gasCurrency === null || gasCurrency === void 0 ? void 0 : gasCurrency.decimals) && (gasCurrency === null || gasCurrency === void 0 ? void 0 : gasCurrency.symbol) && (0, _quote.formatTokenAmount)(locale, new _Numeric.Numeric(data.hexGasTotal, 16).toBase(10).shiftedBy(gasCurrency.decimals ?? 0).toString(), gasCurrency === null || gasCurrency === void 0 ? void 0 : gasCurrency.symbol))
  })), /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRowDivider, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 2
  }, /*#__PURE__*/_react.default.createElement(_transactionDetailRow.default, {
    title: t('bridgeTxDetailsNonce'),
    value: srcChainTxMeta !== null && srcChainTxMeta !== void 0 && srcChainTxMeta.txParams.nonce ? (0, _conversion.hexToDecimal)(srcChainTxMeta === null || srcChainTxMeta === void 0 ? void 0 : srcChainTxMeta.txParams.nonce) : undefined
  }), transactionGroup && typeof isEarliestNonce !== 'undefined' && /*#__PURE__*/_react.default.createElement(_transactionActivityLog.default, {
    transactionGroup: transactionGroup,
    className: "transaction-list-item-details__transaction-activity-log",
    isEarliestNonce: isEarliestNonce
  })))));
};
var _default = exports.default = CrossChainSwapTxDetails;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\transaction-details\\transaction-details.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\utils\\price-impact.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Cutils%5Cprice-impact.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatPriceImpact = formatPriceImpact;
/**
 * Formats price impact percentage for display.
 *
 * @param priceImpact - The price impact value from the API (in decimal form, e.g., 0.87 = 87%).
 * @returns Formatted price impact string.
 */
function formatPriceImpact(priceImpact) {
  if (priceImpact === undefined || priceImpact === null) {
    return '0%';
  }
  const impact = Number(priceImpact);
  if (isNaN(impact) || !impact) {
    return '0%';
  }

  // Convert from decimal to percentage (0.87 -> 87)
  const percentageImpact = impact * 100;

  // If the impact is very small but not zero, show <0.01%
  if (percentageImpact > 0 && percentageImpact < 0.01) {
    return '<0.01%';
  }

  // If the impact is negative and very small, show <-0.01%
  if (percentageImpact < 0 && percentageImpact > -0.01) {
    return '<-0.01%';
  }

  // For values less than 1%, show with 2 decimal places
  if (Math.abs(percentageImpact) < 1) {
    return `${percentageImpact.toFixed(2)}%`;
  }

  // For values between 1% and 10%, show with 1 decimal place
  if (Math.abs(percentageImpact) < 10) {
    return `${percentageImpact.toFixed(1)}%`;
  }

  // For values 10% and above, show with no decimal places
  return `${Math.round(percentageImpact)}%`;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\utils\\price-impact.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\utils\\quote.ts", {"../../../helpers/utils/confirm-tx.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\confirm-tx.util.ts","../../../hooks/useCurrencyDisplay":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useCurrencyDisplay.js","../../confirmations/components/simulation-details/formatAmount":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\simulation-details\\formatAmount.ts","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","bignumber.js":"D:\\code\\v\\metamask-extension\\node_modules\\bignumber.js\\bignumber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Cutils%5Cquote.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isQuoteExpiredOrInvalid = exports.formatTokenAmount = exports.formatProviderLabel = exports.formatCurrencyAmount = void 0;
var _bignumber = require("bignumber.js");
var _bridgeController = require("@metamask/bridge-controller");
var _confirmTx = require("../../../helpers/utils/confirm-tx.util");
var _useCurrencyDisplay = require("../../../hooks/useCurrencyDisplay");
var _formatAmount = require("../../confirmations/components/simulation-details/formatAmount");
const formatTokenAmount = (locale, amount, symbol = '') => {
  const stringifiedAmount = (0, _formatAmount.formatAmount)(locale, new _bignumber.BigNumber(amount));
  return [stringifiedAmount, symbol].join(' ').trim();
};
exports.formatTokenAmount = formatTokenAmount;
const formatCurrencyAmount = (stringifiedDecAmount, currency, precision = _useCurrencyDisplay.DEFAULT_PRECISION) => {
  if (!stringifiedDecAmount) {
    return undefined;
  }
  const amount = new _bignumber.BigNumber(stringifiedDecAmount);
  if (precision === 0) {
    if (amount.lt(0.01)) {
      return '<$0.01';
    }
    if (amount.lt(1)) {
      return (0, _confirmTx.formatCurrency)(amount.toString(), currency, 2);
    }
  }
  return (0, _confirmTx.formatCurrency)(amount.toString(), currency, precision);
};
exports.formatCurrencyAmount = formatCurrencyAmount;
const formatProviderLabel = args => `${args === null || args === void 0 ? void 0 : args.bridgeId}_${args === null || args === void 0 ? void 0 : args.bridges[0]}`;
exports.formatProviderLabel = formatProviderLabel;
const isQuoteExpiredOrInvalid = ({
  activeQuote,
  toToken,
  toChain,
  fromChain,
  isQuoteExpired,
  insufficientBal
}) => {
  // 1. Ignore quotes that are expired (unless the only reason is an `insufficientBal` override for non-EVM chains)
  if (isQuoteExpired && (!insufficientBal ||
  // `insufficientBal` is always true for non-EVM chains (Solana, Bitcoin)
  fromChain && (0, _bridgeController.isNonEvmChainId)(fromChain.chainId))) {
    return true;
  }

  // 2. Ensure the quote still matches the currently selected destination asset / chain
  if (activeQuote && toToken) {
    var _activeQuote$quote, _toToken$address, _activeQuote$quote2;
    const quoteDestAddress = ((_activeQuote$quote = activeQuote.quote) === null || _activeQuote$quote === void 0 || (_activeQuote$quote = _activeQuote$quote.destAsset) === null || _activeQuote$quote === void 0 || (_activeQuote$quote = _activeQuote$quote.address) === null || _activeQuote$quote === void 0 ? void 0 : _activeQuote$quote.toLowerCase()) || '';
    const selectedDestAddress = ((_toToken$address = toToken.address) === null || _toToken$address === void 0 ? void 0 : _toToken$address.toLowerCase()) || '';
    const quoteDestChainIdCaip = (_activeQuote$quote2 = activeQuote.quote) !== null && _activeQuote$quote2 !== void 0 && _activeQuote$quote2.destChainId ? (0, _bridgeController.formatChainIdToCaip)(activeQuote.quote.destChainId) : '';
    const selectedDestChainIdCaip = toChain !== null && toChain !== void 0 && toChain.chainId ? (0, _bridgeController.formatChainIdToCaip)(toChain.chainId) : '';
    return !((quoteDestAddress === selectedDestAddress ||
    // Extension's native asset address may be different from bridge-api's native
    // asset address so if both assets are native, we should still return true
    (0, _bridgeController.isNativeAddress)(quoteDestAddress) && (0, _bridgeController.isNativeAddress)(selectedDestAddress)) && quoteDestChainIdCaip === selectedDestChainIdCaip);
  }
  return false;
};
exports.isQuoteExpiredOrInvalid = isQuoteExpiredOrInvalid;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\utils\\quote.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\utils\\slippage-service.ts", {"./stablecoins":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\utils\\stablecoins.ts","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Cutils%5Cslippage-service.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SlippageValue = void 0;
exports.calculateSlippage = calculateSlippage;
exports.getSlippageReason = getSlippageReason;
var _bridgeController = require("@metamask/bridge-controller");
var _stablecoins = require("./stablecoins");
/**
 * Slippage values for different scenarios
 */
let SlippageValue = exports.SlippageValue = /*#__PURE__*/function (SlippageValue) {
  SlippageValue[SlippageValue["EvmStablecoin"] = 0.5] = "EvmStablecoin";
  SlippageValue[SlippageValue["EvmDefault"] = 2] = "EvmDefault";
  SlippageValue[SlippageValue["BridgeDefault"] = 0.5] = "BridgeDefault";
  return SlippageValue;
}({});
/**
 * Context for calculating slippage
 */
/**
 * Checks if a token address is a stablecoin on the given chain
 *
 * @param chainId
 * @param tokenAddress
 */
function isStablecoin(chainId, tokenAddress) {
  if (!tokenAddress) {
    return false;
  }
  const stablecoins = _stablecoins.STABLECOINS_BY_CHAIN_ID[chainId];
  if (!stablecoins) {
    return false;
  }
  return stablecoins.has(tokenAddress.toLowerCase());
}

/**
 * Checks if both tokens in a pair are stablecoins
 *
 * @param chainId
 * @param fromToken
 * @param toToken
 */
function isStablecoinPair(chainId, fromToken, toToken) {
  if (!fromToken || !toToken) {
    return false;
  }
  return isStablecoin(chainId, fromToken.address) && isStablecoin(chainId, toToken.address);
}

/**
 * Calculates the appropriate slippage based on the transaction context
 *
 * Rules:
 * - Bridge (cross-chain): Always 0.5%
 * - Swap on Solana: Always undefined (AUTO mode)
 * - Swap on EVM stablecoin pairs (same chain only): 0.5%
 * - Swap on EVM other pairs: 2%
 *
 * @param context
 */
function calculateSlippage(context) {
  const {
    fromChain,
    toChain,
    fromToken,
    toToken,
    isSwap
  } = context;

  // If no source chain, we can't determine the type
  if (!(fromChain !== null && fromChain !== void 0 && fromChain.chainId) || !(toChain !== null && toChain !== void 0 && toChain.chainId)) {
    return SlippageValue.BridgeDefault;
  }

  // 1. Cross-chain (bridge) → 0.5%
  if (!isSwap || fromChain.chainId !== toChain.chainId) {
    return SlippageValue.BridgeDefault;
  }

  // 2. Solana swap → undefined (AUTO mode)
  if ((0, _bridgeController.isSolanaChainId)(fromChain.chainId)) {
    return undefined;
  }

  // 3. EVM swap → check for stablecoin pair
  if (isStablecoinPair(fromChain.chainId, fromToken, toToken)) {
    return SlippageValue.EvmStablecoin; // 0.5%
  }

  // Default EVM swap → 2%
  return SlippageValue.EvmDefault;
}

/**
 * Gets a human-readable description of why a certain slippage was chosen
 * Useful for debugging and logging
 *
 * @param context
 */
function getSlippageReason(context) {
  const {
    fromChain,
    toChain,
    fromToken,
    toToken,
    isSwap
  } = context;
  if (!(fromChain !== null && fromChain !== void 0 && fromChain.chainId) || !(toChain !== null && toChain !== void 0 && toChain.chainId)) {
    return 'Incomplete chain setup - using bridge default';
  }
  if (!isSwap || fromChain.chainId !== toChain.chainId) {
    return 'Cross-chain transaction';
  }
  if ((0, _bridgeController.isSolanaChainId)(fromChain.chainId)) {
    return 'Solana swap (AUTO mode)';
  }
  if (isStablecoinPair(fromChain.chainId, fromToken, toToken)) {
    return 'EVM stablecoin pair';
  }
  return 'EVM token swap';
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\utils\\slippage-service.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\utils\\stablecoins.ts", {"../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Cutils%5Cstablecoins.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.STABLECOINS_BY_CHAIN_ID = void 0;
var _network = require("../../../../shared/constants/network");
/**
 * Used for determining optimal slippage in swaps
 * Only includes USDC and USDT for now
 */

/**
 * A map of chain IDs to sets of known stablecoin contract addresses with deep liquidity.
 * Used to determine if a pair qualifies for lower default slippage to avoid frontrunning.
 * Just using USDC and USDT for now, but can add more as needed.
 */
const STABLECOINS_BY_CHAIN_ID = exports.STABLECOINS_BY_CHAIN_ID = {
  [_network.CHAIN_IDS.MAINNET]: new Set(['0xa0b86991c6218b36c1d19d4a2e9eb0ce3606eb48',
  // USDC
  '0xdac17f958d2ee523a2206206994597c13d831ec7' // USDT
  ]),
  [_network.CHAIN_IDS.LINEA_MAINNET]: new Set(['0x176211869cA2b568f2A7D4EE941E073a821EE1ff',
  // USDC
  '0xA219439258ca9da29E9Cc4cE5596924745e12B93' // USDT
  ]),
  [_network.CHAIN_IDS.POLYGON]: new Set(['0x3c499c542cEF5E3811e1192ce70d8cC03d5c3359',
  // USDC
  '0x2791bca1f2de4661ed88a30c99a7a9449aa84174',
  // USDC.e
  '0xc2132d05d31c914a87c6611c10748aeb04b58e8f' // USDT
  ]),
  [_network.CHAIN_IDS.ARBITRUM]: new Set(['0xaf88d065e77c8cC2239327C5EDb3A432268e5831',
  // USDC
  '0xFF970A61A04b1cA14834A43f5dE4533eBDDB5CC8',
  // USDC.e
  '0xFd086bC7CD5C481DCC9C85ebE478A1C0b69FCbb9' // USDT
  ]),
  [_network.CHAIN_IDS.BASE]: new Set(['0x833589fCD6eDb6E08f4c7C32D4f71b54bdA02913' // USDC
  ]),
  [_network.CHAIN_IDS.OPTIMISM]: new Set(['0x0b2C639c533813f4Aa9D7837CAf62653d097Ff85',
  // USDC
  '0x7F5c764cBc14f9669B88837ca1490cCa17c31607',
  // USDC.e
  '0x94b008aA00579c1307B0EF2c499aD98a8ce58e58' // USDT
  ]),
  [_network.CHAIN_IDS.BSC]: new Set(['0x8ac76a51cc950d9822d68b83fe1ad97b32cd580d',
  // USDC
  '0x55d398326f99059ff775485246999027b3197955' // USDT
  ]),
  [_network.CHAIN_IDS.AVALANCHE]: new Set(['0xb97ef9ef8734c71904d8002f8b6bc66dd9c48a6e',
  // USDC
  '0xa7d7079b0fead91f3e65f86e8915cb59c1a4c664',
  // USDC.e
  '0x9702230a8ea53601f5cd2dc00fdbc13d4df4a8c7',
  // USDT
  '0xc7198437980c041c805a1edcba50c1ce5db95118' // USDT.e
  ]),
  [_network.CHAIN_IDS.ZKSYNC_ERA]: new Set(['0x1d17CBcF0D6D143135aE902365D2E5e2A16538D4',
  // USDC
  '0x3355df6D4c9C3035724Fd0e3914dE96A5a83aaf4',
  // USDC.e
  '0x493257fD37EDB34451f62EDf8D2a0C418852bA4C' // USDT
  ]),
  [_network.CHAIN_IDS.SEI]: new Set(['0x3894085Ef7Ff0f0aeDf52E2A2704928d1Ec074F1' // USDC
  ])
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\utils\\stablecoins.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\utils\\tx-details.ts", {"../../../../shared/constants/time":"D:\\code\\v\\metamask-extension\\shared\\constants\\time.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../confirmations/components/simulation-details/formatAmount":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\simulation-details\\formatAmount.ts","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","bignumber.js":"D:\\code\\v\\metamask-extension\\node_modules\\bignumber.js\\bignumber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cbridge%5Cutils%5Ctx-details.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIsDelayed = exports.getBridgeAmountSentFormatted = exports.getBridgeAmountReceivedFormatted = exports.getBlockExplorerUrl = exports.STATUS_TO_COLOR_MAP = void 0;
var _transactionController = require("@metamask/transaction-controller");
var _bignumber = require("bignumber.js");
var _bridgeController = require("@metamask/bridge-controller");
var _time = require("../../../../shared/constants/time");
var _designSystem = require("../../../helpers/constants/design-system");
var _formatAmount = require("../../confirmations/components/simulation-details/formatAmount");
const getBlockExploreTxUrl = (blockExplorerUrl, txHash) => {
  if (blockExplorerUrl && txHash) {
    return `${blockExplorerUrl}/tx/${txHash}`;
  }
  return undefined;
};
const getBlockExplorerUrl = (chainInfo, txHash) => {
  var _chainInfo$blockExplo;
  if (!chainInfo || !txHash) {
    return undefined;
  }
  if (!chainInfo.isEvm) {
    return getBlockExploreTxUrl(chainInfo.blockExplorerUrl, txHash);
  }
  const index = chainInfo.defaultBlockExplorerUrlIndex;
  if (index === undefined) {
    return undefined;
  }
  const rootUrl = (_chainInfo$blockExplo = chainInfo.blockExplorerUrls[index]) === null || _chainInfo$blockExplo === void 0 ? void 0 : _chainInfo$blockExplo.replace(/\/$/u, '');
  return getBlockExploreTxUrl(rootUrl, txHash);
};
exports.getBlockExplorerUrl = getBlockExplorerUrl;
const getBridgeAmountSentFormatted = ({
  bridgeHistoryItem,
  txMeta
}) => {
  var _bridgeHistoryItem$pr;
  if (!txMeta) {
    return undefined;
  }
  const sentAmount = bridgeHistoryItem === null || bridgeHistoryItem === void 0 || (_bridgeHistoryItem$pr = bridgeHistoryItem.pricingData) === null || _bridgeHistoryItem$pr === void 0 ? void 0 : _bridgeHistoryItem$pr.amountSent;
  const srcAssetDecimals = bridgeHistoryItem === null || bridgeHistoryItem === void 0 ? void 0 : bridgeHistoryItem.quote.srcAsset.decimals;
  if (!sentAmount || !srcAssetDecimals) {
    return undefined;
  }
  return sentAmount;
};
exports.getBridgeAmountSentFormatted = getBridgeAmountSentFormatted;
const getBridgeAmountReceivedFormatted = ({
  locale,
  bridgeHistoryItem,
  txMeta
}) => {
  var _txMeta$swapMetaData, _bridgeHistoryItem$st, _txMeta$swapMetaData2;
  if (!txMeta) {
    return undefined;
  }
  const isTxComplete = txMeta.type === _transactionController.TransactionType.bridge && bridgeHistoryItem ? bridgeHistoryItem.status.status === _bridgeController.StatusTypes.COMPLETE : txMeta.status === _transactionController.TransactionStatus.confirmed;
  if (!isTxComplete) {
    return undefined;
  }
  const destAmount = ((_txMeta$swapMetaData = txMeta.swapMetaData) === null || _txMeta$swapMetaData === void 0 ? void 0 : _txMeta$swapMetaData.token_to_amount) ?? (bridgeHistoryItem === null || bridgeHistoryItem === void 0 || (_bridgeHistoryItem$st = bridgeHistoryItem.status.destChain) === null || _bridgeHistoryItem$st === void 0 ? void 0 : _bridgeHistoryItem$st.amount) ?? (bridgeHistoryItem === null || bridgeHistoryItem === void 0 ? void 0 : bridgeHistoryItem.quote.destTokenAmount);
  const destAssetDecimals = ((_txMeta$swapMetaData2 = txMeta.swapMetaData) === null || _txMeta$swapMetaData2 === void 0 ? void 0 : _txMeta$swapMetaData2.token_to_decimals) ?? txMeta.destinationTokenDecimals ?? (bridgeHistoryItem === null || bridgeHistoryItem === void 0 ? void 0 : bridgeHistoryItem.quote.destAsset.decimals);
  if (!destAmount || !destAssetDecimals) {
    return undefined;
  }
  return (0, _formatAmount.formatAmount)(locale, new _bignumber.BigNumber(destAmount).dividedBy(10 ** destAssetDecimals));
};

/**
 * @param status - The status of the bridge history item
 * @param bridgeHistoryItem - The bridge history item
 * @returns Whether the bridge history item is delayed
 */
exports.getBridgeAmountReceivedFormatted = getBridgeAmountReceivedFormatted;
const getIsDelayed = (status, bridgeHistoryItem) => {
  const tenMinutesInMs = 10 * _time.MINUTE;
  return Boolean(status === _bridgeController.StatusTypes.PENDING && (bridgeHistoryItem === null || bridgeHistoryItem === void 0 ? void 0 : bridgeHistoryItem.startTime) && Date.now() > bridgeHistoryItem.startTime + tenMinutesInMs + bridgeHistoryItem.estimatedProcessingTimeInSeconds * 1000);
};
exports.getIsDelayed = getIsDelayed;
const STATUS_TO_COLOR_MAP = exports.STATUS_TO_COLOR_MAP = {
  [_bridgeController.StatusTypes.PENDING]: _designSystem.TextColor.warningDefault,
  [_bridgeController.StatusTypes.COMPLETE]: _designSystem.TextColor.successDefault,
  [_bridgeController.StatusTypes.FAILED]: _designSystem.TextColor.errorDefault,
  [_bridgeController.StatusTypes.UNKNOWN]: _designSystem.TextColor.errorDefault,
  [_transactionController.TransactionStatus.unapproved]: _designSystem.TextColor.warningDefault,
  [_transactionController.TransactionStatus.confirmed]: _designSystem.TextColor.successDefault,
  [_transactionController.TransactionStatus.rejected]: _designSystem.TextColor.errorDefault,
  [_transactionController.TransactionStatus.cancelled]: _designSystem.TextColor.errorDefault,
  [_transactionController.TransactionStatus.failed]: _designSystem.TextColor.errorDefault,
  [_transactionController.TransactionStatus.submitted]: _designSystem.TextColor.warningDefault,
  [_transactionController.TransactionStatus.approved]: _designSystem.TextColor.warningDefault,
  [_transactionController.TransactionStatus.signed]: _designSystem.TextColor.warningDefault,
  [_transactionController.TransactionStatus.dropped]: _designSystem.TextColor.errorDefault
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\bridge\\utils\\tx-details.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirm-add-suggested-nft\\confirm-add-suggested-nft.js", {"../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../shared/modules/string-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\string-utils.ts","../../components/app/assets/nfts/nft-default-image/nft-default-image":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\nfts\\nft-default-image\\nft-default-image.tsx","../../components/app/network-account-balance-header/network-account-balance-header":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\network-account-balance-header\\network-account-balance-header.js","../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../components/ui/page-container":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\page-container\\index.js","../../components/ui/site-origin/site-origin":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\site-origin\\site-origin.js","../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../ducks/history/history":"D:\\code\\v\\metamask-extension\\ui\\ducks\\history\\history.js","../../helpers/constants/common":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\common.ts","../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../hooks/useCurrencyDisplay":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useCurrencyDisplay.js","../../hooks/useOriginMetadata":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useOriginMetadata.js","../../hooks/useUserPreferencedCurrency":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useUserPreferencedCurrency.js","../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../confirmations/components/confirm/nav":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\nav\\index.tsx","../routes/utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\routes\\utils.js","@metamask/etherscan-link":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\etherscan-link\\dist\\index.js","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirm-add-suggested-nft%5Cconfirm-add-suggested-nft.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _rpcErrors = require("@metamask/rpc-errors");
var _etherscanLink = require("@metamask/etherscan-link");
var _classnames = _interopRequireDefault(require("classnames"));
var _pageContainer = require("../../components/ui/page-container");
var _i18n = require("../../contexts/i18n");
var _metametrics = require("../../contexts/metametrics");
var _history = require("../../ducks/history/history");
var _actions = require("../../store/actions");
var _metametrics2 = require("../../../shared/constants/metametrics");
var _transaction = require("../../../shared/constants/transaction");
var _componentLibrary = require("../../components/component-library");
var _networks = require("../../../shared/modules/selectors/networks");
var _selectors = require("../../selectors");
var _nftDefaultImage = _interopRequireDefault(require("../../components/app/assets/nfts/nft-default-image/nft-default-image"));
var _util = require("../../helpers/utils/util");
var _designSystem = require("../../helpers/constants/design-system");
var _networkAccountBalanceHeader = _interopRequireDefault(require("../../components/app/network-account-balance-header/network-account-balance-header"));
var _network = require("../../../shared/constants/network");
var _siteOrigin = _interopRequireDefault(require("../../components/ui/site-origin/site-origin"));
var _common = require("../../helpers/constants/common");
var _useUserPreferencedCurrency = require("../../hooks/useUserPreferencedCurrency");
var _useCurrencyDisplay = require("../../hooks/useCurrencyDisplay");
var _useOriginMetadata = require("../../hooks/useOriginMetadata");
var _stringUtils = require("../../../shared/modules/string-utils");
var _nav = require("../confirmations/components/confirm/nav");
var _utils = require("../routes/utils");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConfirmAddSuggestedNFT = () => {
  var _suggestedNfts$, _suggestedNfts$2;
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const dispatch = (0, _reactRedux.useDispatch)();
  const history = (0, _reactRouterDom.useHistory)();
  const location = (0, _reactRouterDom.useLocation)();
  const hasAppHeader = location !== null && location !== void 0 && location.pathname ? !(0, _utils.hideAppHeader)({
    location
  }) : true;
  const classNames = (0, _classnames.default)('confirm-add-suggested-nft page-container', {
    'confirm-add-suggested-nft--has-app-header-multichain': hasAppHeader
  });
  const mostRecentOverviewPage = (0, _reactRedux.useSelector)(_history.getMostRecentOverviewPage);
  const suggestedNftsNotSorted = (0, _reactRedux.useSelector)(_selectors.getSuggestedNfts);
  const suggestedNfts = suggestedNftsNotSorted.sort((a, b) => a.requestData.asset.tokenId - b.requestData.asset.tokenId);
  const rpcPrefs = (0, _reactRedux.useSelector)(_selectors.getRpcPrefsForCurrentProvider);
  const chainId = (0, _reactRedux.useSelector)(_networks.getCurrentChainId);
  const ipfsGateway = (0, _reactRedux.useSelector)(_selectors.getIpfsGateway);
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const networkIdentifier = (0, _reactRedux.useSelector)(_selectors.getNetworkIdentifier);
  const {
    address: selectedAddress
  } = (0, _reactRedux.useSelector)(_selectors.getSelectedInternalAccount);
  const selectedAccountBalance = (0, _reactRedux.useSelector)(_selectors.getSelectedAccountCachedBalance);
  const accountName = (0, _reactRedux.useSelector)(state => (0, _selectors.getAddressBookEntryOrAccountName)(state, selectedAddress));
  const [suggestedNftsWithImages, setSuggestedNftsWithImages] = (0, _react.useState)([]);
  const networkName = _network.NETWORK_TO_NAME_MAP[chainId] || networkIdentifier;
  const {
    currency: primaryCurrency,
    numberOfDecimals: primaryNumberOfDecimals
  } = (0, _useUserPreferencedCurrency.useUserPreferencedCurrency)(_common.PRIMARY, {
    ethNumberOfDecimals: 4
  });
  const [primaryCurrencyValue] = (0, _useCurrencyDisplay.useCurrencyDisplay)(selectedAccountBalance, {
    numberOfDecimals: primaryNumberOfDecimals,
    currency: primaryCurrency
  });
  const originMetadata = (0, _useOriginMetadata.useOriginMetadata)((_suggestedNfts$ = suggestedNfts[0]) === null || _suggestedNfts$ === void 0 ? void 0 : _suggestedNfts$.origin) || {};
  const approvalId = (_suggestedNfts$2 = suggestedNfts[0]) === null || _suggestedNfts$2 === void 0 ? void 0 : _suggestedNfts$2.id;
  const handleAddNftsClick = (0, _react.useCallback)(async () => {
    await Promise.all(suggestedNfts.map(async ({
      requestData: {
        asset
      },
      id
    }) => {
      await dispatch((0, _actions.resolvePendingApproval)(id, null));
      trackEvent({
        event: _metametrics2.MetaMetricsEventName.NftAdded,
        category: _metametrics2.MetaMetricsEventCategory.Wallet,
        sensitiveProperties: {
          token_contract_address: asset.address,
          token_symbol: asset.symbol,
          token_id: asset.tokenId,
          token_standard: asset.standard,
          asset_type: _transaction.AssetType.NFT,
          source: _metametrics2.MetaMetricsTokenEventSource.Dapp
        }
      });
    }));
    history.push(mostRecentOverviewPage);
  }, [dispatch, history, trackEvent, mostRecentOverviewPage, suggestedNfts]);
  const handleCancelNftClick = (0, _react.useCallback)(async () => {
    await Promise.all(suggestedNfts.map(async ({
      id
    }) => {
      return dispatch((0, _actions.rejectPendingApproval)(id, (0, _rpcErrors.serializeError)(_rpcErrors.providerErrors.userRejectedRequest())));
    }));
    history.push(mostRecentOverviewPage);
  }, [dispatch, history, mostRecentOverviewPage, suggestedNfts]);
  (0, _react.useEffect)(() => {
    const goBackIfNoSuggestedNftsOnFirstRender = () => {
      if (!suggestedNfts.length) {
        history.push(mostRecentOverviewPage);
      }
    };
    goBackIfNoSuggestedNftsOnFirstRender();
  }, [history, mostRecentOverviewPage, suggestedNfts]);
  let origin;
  let link;
  if (suggestedNfts.length) {
    try {
      const url = new URL(suggestedNfts[0].origin);
      origin = url.host;
      link = url.href;
    } catch {
      origin = 'dapp';
    }
  }
  (0, _react.useEffect)(() => {
    const addImageUrlToSuggestedNFTs = async () => {
      const suggestedNftWithImages = await Promise.all(suggestedNfts.map(async item => {
        const imgUrl = await (0, _util.getAssetImageURL)(item.requestData.asset.image, ipfsGateway);
        return {
          ...item,
          requestData: {
            ...item.requestData,
            asset: {
              ...item.requestData.asset,
              assetImageUrl: imgUrl
            }
          }
        };
      }));
      setSuggestedNftsWithImages(suggestedNftWithImages);
    };
    addImageUrlToSuggestedNFTs();
  }, [suggestedNfts]); // rerender when suggestedNfts changes

  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: classNames,
    height: _designSystem.BlockSize.Full,
    width: _designSystem.BlockSize.Full,
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column
  }, /*#__PURE__*/_react.default.createElement(_nav.Nav, {
    confirmationId: approvalId
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingBottom: 2,
    className: "confirm-add-suggested-nft__header"
  }, /*#__PURE__*/_react.default.createElement(_networkAccountBalanceHeader.default, {
    accountName: accountName,
    accountBalance: primaryCurrencyValue,
    accountAddress: selectedAddress,
    networkName: networkName,
    chainId: chainId
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingTop: 4,
    paddingRight: 4,
    paddingLeft: 4,
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center
  }, /*#__PURE__*/_react.default.createElement(_siteOrigin.default, {
    chip: true,
    siteOrigin: originMetadata.origin,
    title: originMetadata.origin,
    iconSrc: originMetadata.iconUrl,
    iconName: originMetadata.hostname
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingLg,
    textAlign: _designSystem.TextAlign.Center,
    margin: 2
  }, t('addSuggestedNFTs')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    textAlign: _designSystem.TextAlign.Center
  }, t('wantsToAddThisAsset', [origin === 'dapp' ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    key: origin,
    variant: _designSystem.TextVariant.bodyMd,
    fontWeight: "bold"
  }, origin) : /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    key: origin,
    size: _componentLibrary.BUTTON_SIZES.INHERIT,
    href: link,
    target: "_blank"
  }, origin)]))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "page-container__content confirm-add-suggested-nft__content"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "confirm-add-suggested-nft__card",
    padding: 2,
    borderRadius: _designSystem.BorderRadius.MD
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: (0, _classnames.default)({
      'confirm-add-suggested-nft__nft-list': suggestedNfts.length > 1
    })
  }, suggestedNfts.map(({
    id,
    requestData: {
      asset: {
        address,
        tokenId,
        symbol,
        name
      }
    }
  }) => {
    const found = suggestedNftsWithImages.find(elm => elm.requestData.asset.tokenId === tokenId && (0, _stringUtils.isEqualCaseInsensitive)(elm.requestData.asset.address, address));
    const nftImageURL = found ? found.requestData.asset.assetImageUrl : '';
    const blockExplorerLink = (0, _etherscanLink.getTokenTrackerLink)(address, chainId, null, null, {
      blockExplorerUrl: (rpcPrefs === null || rpcPrefs === void 0 ? void 0 : rpcPrefs.blockExplorerUrl) ?? null
    });
    if (suggestedNfts.length === 1) {
      return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        className: "confirm-add-suggested-nft__nft-single",
        key: `confirm-add-suggested-nft__nft-single-${id}`,
        borderRadius: _designSystem.BorderRadius.MD,
        margin: 0,
        padding: 0
      }, nftImageURL ? /*#__PURE__*/_react.default.createElement("img", {
        className: "confirm-add-suggested-nft__nft-single-image",
        src: nftImageURL,
        alt: name || tokenId
      }) : /*#__PURE__*/_react.default.createElement(_nftDefaultImage.default, {
        className: "confirm-add-suggested-nft__nft-single-image-default",
        tokenId: tokenId,
        name: name || symbol || (0, _util.shortenAddress)(address)
      }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        padding: 1,
        display: _designSystem.Display.Flex,
        flexDirection: _designSystem.FlexDirection.Row,
        justifyContent: _designSystem.JustifyContent.spaceBetween,
        alignItems: _designSystem.AlignItems.Center
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        display: _designSystem.Display.Flex,
        flexDirection: _designSystem.FlexDirection.Column,
        justifyContent: _designSystem.JustifyContent.spaceEvenly,
        flexWrap: _designSystem.FlexWrap.NoWrap,
        width: _designSystem.BlockSize.Full,
        className: "confirm-add-suggested-nft__nft-single-sub-details"
      }, rpcPrefs.blockExplorerUrl ? /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
        className: "confirm-add-suggested-nft__nft-name",
        href: blockExplorerLink,
        title: address,
        target: "_blank",
        size: _componentLibrary.BUTTON_SIZES.INHERIT
      }, name || symbol || (0, _util.shortenAddress)(address)) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        variant: _designSystem.TextVariant.bodyMd,
        className: "confirm-add-suggested-nft__nft-name",
        title: address
      }, name || symbol || (0, _util.shortenAddress)(address)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        variant: _designSystem.TextVariant.bodyMd,
        color: _designSystem.TextColor.textAlternative,
        className: "confirm-add-suggested-nft__nft-tokenId"
      }, "#", tokenId))));
    }
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      flexWrap: _designSystem.FlexWrap.NoWrap,
      alignItems: _designSystem.AlignItems.Center,
      justifyContent: _designSystem.JustifyContent.spaceBetween,
      marginBottom: 4,
      className: "confirm-add-suggested-nft__nft-list-item",
      key: `${address}-${tokenId}`
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      flexWrap: _designSystem.FlexWrap.NoWrap,
      alignItems: _designSystem.AlignItems.Center,
      justifyContent: _designSystem.JustifyContent.spaceBetween
    }, nftImageURL ? /*#__PURE__*/_react.default.createElement("img", {
      className: "confirm-add-suggested-nft__nft-image",
      src: nftImageURL,
      alt: name || tokenId
    }) : /*#__PURE__*/_react.default.createElement(_nftDefaultImage.default, {
      className: "confirm-add-suggested-nft__nft-image-default"
    }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      justifyContent: _designSystem.JustifyContent.spaceEvenly,
      flexWrap: _designSystem.FlexWrap.NoWrap,
      width: _designSystem.BlockSize.Full,
      className: "confirm-add-suggested-nft__nft-sub-details"
    }, rpcPrefs.blockExplorerUrl ? /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
      className: "confirm-add-suggested-nft__nft-name",
      href: blockExplorerLink,
      title: address,
      target: "_blank",
      size: _componentLibrary.BUTTON_SIZES.INHERIT
    }, name || symbol || (0, _util.shortenAddress)(address)) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodySm,
      className: "confirm-add-suggested-nft__nft-name",
      title: address
    }, name || symbol || (0, _util.shortenAddress)(address)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodySm,
      color: _designSystem.TextColor.textAlternative,
      className: "confirm-add-suggested-nft__nft-tokenId"
    }, "#", tokenId))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      className: "confirm-add-suggested-nft__nft-remove",
      "data-testid": `confirm-add-suggested-nft__nft-remove-${id}`,
      iconName: _componentLibrary.IconName.Close,
      size: _componentLibrary.ButtonIconSize.Sm,
      color: _designSystem.IconColor.iconMuted,
      onClick: e => {
        e.preventDefault();
        e.stopPropagation();
        dispatch((0, _actions.rejectPendingApproval)(id, (0, _rpcErrors.serializeError)(_rpcErrors.providerErrors.userRejectedRequest())));
      }
    }));
  })))), /*#__PURE__*/_react.default.createElement(_pageContainer.PageContainerFooter, {
    cancelText: t('cancel'),
    submitText: suggestedNfts.length === 1 ? t('addNft') : t('addNfts'),
    onCancel: handleCancelNftClick,
    onSubmit: handleAddNftsClick
  }));
};
var _default = exports.default = ConfirmAddSuggestedNFT;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirm-add-suggested-nft\\confirm-add-suggested-nft.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirm-add-suggested-nft\\index.js", {"./confirm-add-suggested-nft":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirm-add-suggested-nft\\confirm-add-suggested-nft.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirm-add-suggested-nft%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _confirmAddSuggestedNft.default;
  }
});
var _confirmAddSuggestedNft = _interopRequireDefault(require("./confirm-add-suggested-nft"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirm-add-suggested-nft\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirm-add-suggested-token\\confirm-add-suggested-token.js", {"../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../shared/modules/string-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\string-utils.ts","../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../components/ui/identicon":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\identicon\\index.js","../../components/ui/page-container":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\page-container\\index.js","../../components/ui/token-balance":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\token-balance\\index.js","../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../ducks/history/history":"D:\\code\\v\\metamask-extension\\ui\\ducks\\history\\history.js","../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../helpers/constants/zendesk-url":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\zendesk-url.js","../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../confirmations/components/confirm/nav":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\nav\\index.tsx","../routes/utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\routes\\utils.js","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirm-add-suggested-token%5Cconfirm-add-suggested-token.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _classnames = _interopRequireDefault(require("classnames"));
var _rpcErrors = require("@metamask/rpc-errors");
var _componentLibrary = require("../../components/component-library");
var _designSystem = require("../../helpers/constants/design-system");
var _identicon = _interopRequireDefault(require("../../components/ui/identicon"));
var _tokenBalance = _interopRequireDefault(require("../../components/ui/token-balance"));
var _pageContainer = require("../../components/ui/page-container");
var _i18n = require("../../contexts/i18n");
var _metametrics = require("../../contexts/metametrics");
var _history = require("../../ducks/history/history");
var _metamask = require("../../ducks/metamask/metamask");
var _zendeskUrl = _interopRequireDefault(require("../../helpers/constants/zendesk-url"));
var _stringUtils = require("../../../shared/modules/string-utils");
var _actions = require("../../store/actions");
var _metametrics2 = require("../../../shared/constants/metametrics");
var _transaction = require("../../../shared/constants/transaction");
var _selectors = require("../../selectors");
var _nav = require("../confirmations/components/confirm/nav");
var _utils = require("../routes/utils");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getTokenName(name, symbol) {
  return name === undefined ? symbol : `${name} (${symbol})`;
}

/**
 * @param {Array} suggestedTokens - an array of assets suggested to add to the user's wallet
 * via the RPC method `wallet_watchAsset`
 * @param {Array} tokens - the list of tokens currently tracked in state
 * @returns {boolean} Returns true when the list of suggestedTokens contains an entry with
 *          an address that matches an existing token.
 */
function hasDuplicateAddress(suggestedTokens, tokens) {
  const duplicate = suggestedTokens.find(({
    requestData: {
      asset
    }
  }) => {
    const dupe = tokens.find(({
      address
    }) => {
      return (0, _stringUtils.isEqualCaseInsensitive)(address, asset === null || asset === void 0 ? void 0 : asset.address);
    });
    return Boolean(dupe);
  });
  return Boolean(duplicate);
}

/**
 * @param {Array} suggestedTokens - a list of assets suggested to add to the user's wallet
 * via RPC method `wallet_watchAsset`
 * @param {Array} tokens - the list of tokens currently tracked in state
 * @returns {boolean} Returns true when the list of suggestedTokens contains an entry with both
 *          1. a symbol that matches an existing token
 *          2. an address that does not match an existing token
 */
function hasDuplicateSymbolAndDiffAddress(suggestedTokens, tokens) {
  const duplicate = suggestedTokens.find(({
    requestData: {
      asset
    }
  }) => {
    const dupe = tokens.find(token => {
      return (0, _stringUtils.isEqualCaseInsensitive)(token.symbol, asset === null || asset === void 0 ? void 0 : asset.symbol) && !(0, _stringUtils.isEqualCaseInsensitive)(token.address, asset === null || asset === void 0 ? void 0 : asset.address);
    });
    return Boolean(dupe);
  });
  return Boolean(duplicate);
}
const ConfirmAddSuggestedToken = () => {
  var _suggestedTokens$;
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const dispatch = (0, _reactRedux.useDispatch)();
  const history = (0, _reactRouterDom.useHistory)();
  const location = (0, _reactRouterDom.useLocation)();
  const hasAppHeader = location !== null && location !== void 0 && location.pathname ? !(0, _utils.hideAppHeader)({
    location
  }) : true;
  const classNames = (0, _classnames.default)('confirm-add-suggested-token page-container', {
    'confirm-add-suggested-token--has-app-header-multichain': hasAppHeader
  });
  const mostRecentOverviewPage = (0, _reactRedux.useSelector)(_history.getMostRecentOverviewPage);
  const suggestedTokens = (0, _reactRedux.useSelector)(_selectors.getSuggestedTokens);
  const tokens = (0, _reactRedux.useSelector)(_metamask.getTokens);
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const approvalId = (_suggestedTokens$ = suggestedTokens[0]) === null || _suggestedTokens$ === void 0 ? void 0 : _suggestedTokens$.id;
  const knownTokenBannerAlert = (0, _react.useMemo)(() => {
    return hasDuplicateAddress(suggestedTokens, tokens) && /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerAlert, {
      severity: _designSystem.Severity.Warning,
      marginTop: 4
    }, t('knownTokenWarning', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
      variant: _componentLibrary.ButtonVariant.Link,
      key: "confirm-add-suggested-token-duplicate-warning",
      className: "confirm-add-suggested-token__link",
      externalLink: true,
      size: _componentLibrary.ButtonLinkSize.Inherit,
      href: _zendeskUrl.default.TOKEN_SAFETY_PRACTICES
    }, t('learnScamRisk'))]));
  }, [suggestedTokens, tokens, t]);
  const reusedTokenNameBannerAlert = (0, _react.useMemo)(() => {
    return hasDuplicateSymbolAndDiffAddress(suggestedTokens, tokens) && /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerAlert, {
      marginTop: 4,
      severity: _designSystem.Severity.Warning,
      description: t('reusedTokenNameWarning')
    });
  }, [suggestedTokens, tokens, t]);
  const handleAddTokensClick = (0, _react.useCallback)(async () => {
    await Promise.all(suggestedTokens.map(async ({
      requestData: {
        asset
      },
      id
    }) => {
      await dispatch((0, _actions.resolvePendingApproval)(id, null));
      trackEvent({
        event: _metametrics2.MetaMetricsEventName.TokenAdded,
        category: _metametrics2.MetaMetricsEventCategory.Wallet,
        sensitiveProperties: {
          token_symbol: asset.symbol,
          token_contract_address: asset.address,
          token_decimal_precision: asset.decimals,
          unlisted: asset.unlisted,
          source: _metametrics2.MetaMetricsTokenEventSource.Dapp,
          token_standard: _transaction.TokenStandard.ERC20,
          asset_type: _transaction.AssetType.token
        }
      });
    }));
    history.push(mostRecentOverviewPage);
  }, [dispatch, history, trackEvent, mostRecentOverviewPage, suggestedTokens]);
  const handleCancelTokenClick = (0, _react.useCallback)(async () => {
    await Promise.all(suggestedTokens.map(({
      id
    }) => dispatch((0, _actions.rejectPendingApproval)(id, (0, _rpcErrors.serializeError)(_rpcErrors.providerErrors.userRejectedRequest())))));
    history.push(mostRecentOverviewPage);
  }, [dispatch, history, mostRecentOverviewPage, suggestedTokens]);
  const goBackIfNoSuggestedTokensOnFirstRender = () => {
    if (!suggestedTokens.length) {
      history.push(mostRecentOverviewPage);
    }
  };
  (0, _react.useEffect)(() => {
    goBackIfNoSuggestedTokensOnFirstRender();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: classNames
  }, /*#__PURE__*/_react.default.createElement(_nav.Nav, {
    confirmationId: approvalId
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "page-container__header"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "page-container__title"
  }, t('addSuggestedTokens')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    textAlign: _designSystem.TextAlign.Center
  }, t('likeToImportTokens')), knownTokenBannerAlert, reusedTokenNameBannerAlert), /*#__PURE__*/_react.default.createElement("div", {
    className: "page-container__content"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "confirm-add-suggested-token__header"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "confirm-add-suggested-token__token"
  }, t('token')), /*#__PURE__*/_react.default.createElement("div", {
    className: "confirm-add-suggested-token__balance"
  }, t('balance'))), /*#__PURE__*/_react.default.createElement("div", {
    className: "confirm-add-suggested-token__token-list"
  }, suggestedTokens.map(({
    requestData: {
      asset
    }
  }) => {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "confirm-add-suggested-token__token-list-item",
      key: asset.address
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "confirm-add-suggested-token__token confirm-add-suggested-token__data"
    }, /*#__PURE__*/_react.default.createElement(_identicon.default, {
      className: "confirm-add-suggested-token__token-icon",
      diameter: 48,
      address: asset.address,
      image: asset.image
    }), /*#__PURE__*/_react.default.createElement("div", {
      className: "confirm-add-suggested-token__name"
    }, getTokenName(asset.name, asset.symbol))), /*#__PURE__*/_react.default.createElement("div", {
      className: "confirm-add-suggested-token__balance"
    }, /*#__PURE__*/_react.default.createElement(_tokenBalance.default, {
      token: asset
    })));
  }))), /*#__PURE__*/_react.default.createElement(_pageContainer.PageContainerFooter, {
    cancelText: t('cancel'),
    submitText: t('addToken'),
    onCancel: handleCancelTokenClick,
    onSubmit: handleAddTokensClick,
    disabled: suggestedTokens.length === 0
  }));
};
var _default = exports.default = ConfirmAddSuggestedToken;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirm-add-suggested-token\\confirm-add-suggested-token.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirm-add-suggested-token\\index.js", {"./confirm-add-suggested-token":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirm-add-suggested-token\\confirm-add-suggested-token.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirm-add-suggested-token%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _confirmAddSuggestedToken.default;
  }
});
var _confirmAddSuggestedToken = _interopRequireDefault(require("./confirm-add-suggested-token"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirm-add-suggested-token\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirm-decrypt-message\\confirm-decrypt-message.component.js", {"../../../shared/constants/common":"D:\\code\\v\\metamask-extension\\shared\\constants\\common.ts","../../../shared/constants/copy":"D:\\code\\v\\metamask-extension\\shared\\constants\\copy.ts","../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../shared/constants/time":"D:\\code\\v\\metamask-extension\\shared\\constants\\time.ts","../../../shared/modules/Numeric":"D:\\code\\v\\metamask-extension\\shared\\modules\\Numeric.ts","../../components/app/account-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\account-list-item\\index.js","../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../components/ui/page-container":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\page-container\\index.js","../../components/ui/tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\index.js","../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../ducks/confirm-transaction/confirm-transaction.duck":"D:\\code\\v\\metamask-extension\\ui\\ducks\\confirm-transaction\\confirm-transaction.duck.js","../../ducks/history/history":"D:\\code\\v\\metamask-extension\\ui\\ducks\\history\\history.js","../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../hooks/useScrollRequired":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useScrollRequired.js","../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../confirmations/components/confirm/nav":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\nav\\index.tsx","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","copy-to-clipboard":"D:\\code\\v\\metamask-extension\\node_modules\\copy-to-clipboard\\index.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirm-decrypt-message%5Cconfirm-decrypt-message.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _copyToClipboard = _interopRequireDefault(require("copy-to-clipboard"));
var _classnames = _interopRequireDefault(require("classnames"));
var _loglevel = _interopRequireDefault(require("loglevel"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _lodash = require("lodash");
var _accountListItem = _interopRequireDefault(require("../../components/app/account-list-item"));
var _tooltip = _interopRequireDefault(require("../../components/ui/tooltip"));
var _pageContainer = require("../../components/ui/page-container");
var _history = require("../../ducks/history/history");
var _metamask = require("../../ducks/metamask/metamask");
var _metametrics = require("../../../shared/constants/metametrics");
var _time = require("../../../shared/constants/time");
var _Numeric = require("../../../shared/modules/Numeric");
var _common = require("../../../shared/constants/common");
var _componentLibrary = require("../../components/component-library");
var _copy = require("../../../shared/constants/copy");
var _useI18nContext = require("../../hooks/useI18nContext");
var _useScrollRequired = require("../../hooks/useScrollRequired");
var _metametrics2 = require("../../contexts/metametrics");
var _designSystem = require("../../helpers/constants/design-system");
var _confirmTransaction = require("../../ducks/confirm-transaction/confirm-transaction.duck");
var _actions = require("../../store/actions");
var _selectors = require("../../selectors");
var _nav = require("../confirmations/components/confirm/nav");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/* eslint-disable react/prop-types */

const Header = ({
  approvalId
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_nav.Nav, {
    confirmationId: approvalId
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "request-decrypt-message__header"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "request-decrypt-message__header-background"
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "request-decrypt-message__header__text"
  }, t('decryptRequest')), /*#__PURE__*/_react.default.createElement("div", {
    className: "request-decrypt-message__header__tip-container"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "request-decrypt-message__header__tip"
  }))));
};
const Account = ({
  fromAccount,
  nativeCurrency
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const nativeCurrencyBalance = new _Numeric.Numeric(fromAccount.balance, 16, _common.EtherDenomination.WEI).toDenomination(_common.EtherDenomination.ETH).round(6).toBase(10).toString();
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "request-decrypt-message__account-info"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "request-decrypt-message__account"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "request-decrypt-message__account-text"
  }, `${t('account')}:`), /*#__PURE__*/_react.default.createElement("div", {
    className: "request-decrypt-message__account-item"
  }, /*#__PURE__*/_react.default.createElement(_accountListItem.default, {
    account: fromAccount
  }))), /*#__PURE__*/_react.default.createElement("div", {
    className: "request-decrypt-message__balance"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "request-decrypt-message__balance-text"
  }, `${t('balance')}:`), /*#__PURE__*/_react.default.createElement("div", {
    className: "request-decrypt-message__balance-value"
  }, `${nativeCurrencyBalance} ${nativeCurrency}`)));
};
Account.propTypes = {
  fromAccount: _propTypes.default.shape({
    balance: _propTypes.default.string.isRequired
  }).isRequired,
  nativeCurrency: _propTypes.default.string.isRequired
};
const VisualSection = ({
  name,
  notice,
  targetSubjectMetadata
}) => /*#__PURE__*/_react.default.createElement("div", {
  className: "request-decrypt-message__visual"
}, /*#__PURE__*/_react.default.createElement("section", null, targetSubjectMetadata !== null && targetSubjectMetadata !== void 0 && targetSubjectMetadata.iconUrl ? /*#__PURE__*/_react.default.createElement("img", {
  className: "request-decrypt-message__visual-identicon",
  src: targetSubjectMetadata.iconUrl,
  alt: ""
}) : /*#__PURE__*/_react.default.createElement("i", {
  className: "request-decrypt-message__visual-identicon--default"
}, name.charAt(0).toUpperCase()), /*#__PURE__*/_react.default.createElement("div", {
  className: "request-decrypt-message__notice"
}, notice)));
VisualSection.propTypes = {
  name: _propTypes.default.string.isRequired,
  notice: _propTypes.default.string.isRequired,
  targetSubjectMetadata: _propTypes.default.shape({
    iconUrl: _propTypes.default.string
  })
};
const ScrollToBottomButton = ({
  isScrollable,
  isScrolledToBottom,
  hasDecrypted,
  hasError,
  scrollToBottom
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const isScrollToBottomVisible = hasDecrypted && !hasError && isScrollable && !isScrolledToBottom;
  if (!isScrollToBottomVisible) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    ariaLabel: t('scrollDown'),
    backgroundColor: _designSystem.BackgroundColor.primaryDefault,
    borderRadius: _designSystem.BorderRadius.full,
    className: "scroll-to-bottom__button",
    color: _designSystem.IconColor.primaryInverse,
    "data-testid": "scroll-to-bottom",
    display: _designSystem.Display.Flex,
    iconName: _componentLibrary.IconName.Arrow2Down,
    onClick: scrollToBottom,
    size: _componentLibrary.ButtonIconSize.Md
  });
};
ScrollToBottomButton.propTypes = {
  isScrollable: _propTypes.default.bool.isRequired,
  isScrolledToBottom: _propTypes.default.bool.isRequired,
  hasDecrypted: _propTypes.default.bool.isRequired,
  hasError: _propTypes.default.bool.isRequired,
  scrollToBottom: _propTypes.default.func.isRequired
};
const MessageBody = /*#__PURE__*/(0, _react.forwardRef)(({
  isScrollable,
  isScrolledToBottom,
  onScroll,
  rawMessage,
  scrollToBottom,
  setRawMessage,
  messageData
}, ref) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const t = (0, _useI18nContext.useI18nContext)();
  const [copyToClipboardPressed, setCopyToClipboardPressed] = (0, _react.useState)(false);
  const [hasCopied, setHasCopied] = (0, _react.useState)(false);
  const [hasDecrypted, setHasDecrypted] = (0, _react.useState)(false);
  const [hasError, setHasError] = (0, _react.useState)(false);
  const [errorMessage, setErrorMessage] = (0, _react.useState)('');
  const copyMessage = () => {
    (0, _copyToClipboard.default)(rawMessage, _copy.COPY_OPTIONS);
    trackEvent({
      category: _metametrics.MetaMetricsEventCategory.Messages,
      event: 'Copy',
      properties: {
        action: 'Decrypt Message Copy',
        legacy_event: true
      }
    });
    setHasCopied(true);
    setTimeout(() => setHasCopied(false), _time.SECOND * 3);
  };
  const onDecryptMessage = async event => {
    event.stopPropagation(event);
    const params = messageData.msgParams;
    params.metamaskId = messageData.id;
    const result = await dispatch((0, _actions.decryptMsgInline)(params));
    if (result.error) {
      setHasError(true);
      setErrorMessage(t('decryptInlineError', [result.error]));
    } else {
      setHasDecrypted(true);
      setRawMessage(result.rawSig);
    }
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "request-decrypt-message__message-container"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "request-decrypt-message__message"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "request-decrypt-message__message-text",
    ref: ref,
    onScroll: onScroll
  }, !hasDecrypted && !hasError ? messageData.msgParams.data : rawMessage, hasError ? errorMessage : ''), /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('request-decrypt-message__message-cover', {
      'request-decrypt-message__message-lock--pressed': hasDecrypted || hasError
    })
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('request-decrypt-message__message-lock', {
      'request-decrypt-message__message-lock--pressed': hasDecrypted || hasError
    }),
    "data-testid": "message-lock",
    onClick: onDecryptMessage
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "request-decrypt-message__message-lock__container"
  }, /*#__PURE__*/_react.default.createElement("i", {
    className: "fa fa-lock fa-lg request-decrypt-message__message-lock__container__icon"
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "request-decrypt-message__message-lock__container__text"
  }, t('decryptMetamask'))))), /*#__PURE__*/_react.default.createElement(ScrollToBottomButton, {
    isScrollable: isScrollable,
    hasError: hasError,
    hasDecrypted: hasDecrypted,
    isScrolledToBottom: isScrolledToBottom,
    scrollToBottom: scrollToBottom
  }), hasDecrypted ? /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)({
      'request-decrypt-message__message-copy': true,
      'request-decrypt-message__message-copy--pressed': copyToClipboardPressed
    }),
    onClick: copyMessage,
    onMouseDown: () => setCopyToClipboardPressed(true),
    onMouseUp: () => setCopyToClipboardPressed(false),
    "data-testid": "message-copy"
  }, /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    position: "bottom",
    title: hasCopied ? t('copiedExclamation') : t('copyToClipboard'),
    wrapperClassName: "request-decrypt-message__message-copy-tooltip",
    style: {
      display: 'flex',
      alignItems: 'center'
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "request-decrypt-message__message-copy-text"
  }, t('decryptCopy')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: hasCopied ? _componentLibrary.IconName.CopySuccess : _componentLibrary.IconName.Copy,
    color: _designSystem.IconColor.primaryDefault
  }))) : /*#__PURE__*/_react.default.createElement("div", null));
});
MessageBody.displayName = 'MessageBody';
MessageBody.propTypes = {
  isScrollable: _propTypes.default.bool.isRequired,
  isScrolledToBottom: _propTypes.default.bool.isRequired,
  onScroll: _propTypes.default.func.isRequired,
  rawMessage: _propTypes.default.string.isRequired,
  scrollToBottom: _propTypes.default.func.isRequired,
  setRawMessage: _propTypes.default.func.isRequired,
  messageData: _propTypes.default.shape({
    msgParams: _propTypes.default.shape({
      data: _propTypes.default.string.isRequired,
      from: _propTypes.default.string.isRequired,
      origin: _propTypes.default.string.isRequired
    }).isRequired,
    id: _propTypes.default.string.isRequired
  }).isRequired
};
const Footer = ({
  hasScrolledToBottom,
  isScrollable,
  mostRecentOverviewPage,
  messageData
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const history = (0, _reactRouterDom.useHistory)();
  const t = (0, _useI18nContext.useI18nContext)();
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const onCancelClick = async event => {
    event.stopPropagation(event);
    await dispatch((0, _actions.cancelDecryptMsg)(messageData));
    trackEvent({
      category: _metametrics.MetaMetricsEventCategory.Messages,
      event: 'Cancel',
      properties: {
        action: 'Decrypt Message Request',
        legacy_event: true
      }
    });
    dispatch((0, _confirmTransaction.clearConfirmTransaction)());
    history.push(mostRecentOverviewPage);
  };
  const onSubmitClick = async event => {
    event.stopPropagation(event);
    const params = messageData.msgParams;
    params.metamaskId = messageData.id;
    await dispatch((0, _actions.decryptMsg)(params));
    trackEvent({
      category: _metametrics.MetaMetricsEventCategory.Messages,
      event: 'Confirm',
      properties: {
        action: 'Decrypt Message Request',
        legacy_event: true
      }
    });
    dispatch((0, _confirmTransaction.clearConfirmTransaction)());
    history.push(mostRecentOverviewPage);
  };
  return /*#__PURE__*/_react.default.createElement(_pageContainer.PageContainerFooter, {
    cancelText: t('cancel'),
    submitText: t('decrypt'),
    disabled: isScrollable && !hasScrolledToBottom,
    onCancel: onCancelClick,
    onSubmit: onSubmitClick
  });
};
Footer.propTypes = {
  hasScrolledToBottom: _propTypes.default.bool.isRequired,
  isScrollable: _propTypes.default.bool.isRequired,
  mostRecentOverviewPage: _propTypes.default.string.isRequired,
  messageData: _propTypes.default.shape({
    msgParams: _propTypes.default.shape({
      data: _propTypes.default.string.isRequired,
      from: _propTypes.default.string.isRequired,
      origin: _propTypes.default.string.isRequired
    }).isRequired,
    id: _propTypes.default.string.isRequired
  }).isRequired
};
const ConfirmDecryptMessage = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  const [rawMessage, setRawMessage] = (0, _react.useState)('');
  const mostRecentOverviewPage = (0, _reactRedux.useSelector)(_history.getMostRecentOverviewPage);
  const nativeCurrency = (0, _reactRedux.useSelector)(_metamask.getNativeCurrency);
  const {
    id: approvalId
  } = (0, _reactRouterDom.useParams)();
  const unconfirmedTransactions = (0, _reactRedux.useSelector)(_selectors.unconfirmedTransactionsListSelector);
  const messageData = (0, _lodash.cloneDeep)(unconfirmedTransactions.find(tx => tx.id === approvalId));
  const fromAccount = (0, _reactRedux.useSelector)(state => {
    var _messageData$msgParam;
    return (0, _selectors.getTargetAccountWithSendEtherInfo)(state, messageData === null || messageData === void 0 || (_messageData$msgParam = messageData.msgParams) === null || _messageData$msgParam === void 0 ? void 0 : _messageData$msgParam.from);
  });
  const subjectMetadata = (0, _reactRedux.useSelector)(state => state.metamask.subjectMetadata || {});
  const {
    hasScrolledToBottom,
    isScrollable,
    isScrolledToBottom,
    onScroll,
    scrollToBottom,
    ref
  } = (0, _useScrollRequired.useScrollRequired)([rawMessage], {
    offsetPxFromBottom: 0
  });
  if (!messageData) {
    _loglevel.default.warn('ConfirmDecryptMessage Page: Missing messageData prop.');
    return null;
  }
  const targetSubjectMetadata = subjectMetadata[messageData.msgParams.origin];
  const name = (targetSubjectMetadata === null || targetSubjectMetadata === void 0 ? void 0 : targetSubjectMetadata.name) || messageData.msgParams.origin;
  const notice = t('decryptMessageNotice', [messageData.msgParams.origin]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "request-decrypt-message__container"
  }, /*#__PURE__*/_react.default.createElement(Header, {
    approvalId: approvalId
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "request-decrypt-message__body"
  }, /*#__PURE__*/_react.default.createElement(Account, {
    fromAccount: fromAccount,
    nativeCurrency: nativeCurrency
  }), /*#__PURE__*/_react.default.createElement(VisualSection, {
    name: name,
    notice: notice,
    targetSubjectMetadata: targetSubjectMetadata
  }), /*#__PURE__*/_react.default.createElement(MessageBody, {
    isScrollable: isScrollable,
    isScrolledToBottom: isScrolledToBottom,
    onScroll: onScroll,
    rawMessage: rawMessage,
    ref: ref,
    scrollToBottom: scrollToBottom,
    setRawMessage: setRawMessage,
    messageData: messageData
  })), /*#__PURE__*/_react.default.createElement(Footer, {
    hasScrolledToBottom: hasScrolledToBottom,
    isScrollable: isScrollable,
    mostRecentOverviewPage: mostRecentOverviewPage,
    messageData: messageData
  }));
};
var _default = exports.default = ConfirmDecryptMessage;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirm-decrypt-message\\confirm-decrypt-message.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirm-decrypt-message\\index.js", {"./confirm-decrypt-message.component":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirm-decrypt-message\\confirm-decrypt-message.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirm-decrypt-message%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _confirmDecryptMessage.default;
  }
});
var _confirmDecryptMessage = _interopRequireDefault(require("./confirm-decrypt-message.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirm-decrypt-message\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirm-encryption-public-key\\confirm-encryption-public-key.component.js", {"../../../shared/constants/common":"D:\\code\\v\\metamask-extension\\shared\\constants\\common.ts","../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../shared/modules/Numeric":"D:\\code\\v\\metamask-extension\\shared\\modules\\Numeric.ts","../../components/app/account-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\account-list-item\\index.js","../../components/app/preferred-avatar":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\preferred-avatar\\index.ts","../../components/ui/page-container":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\page-container\\index.js","../../components/ui/site-origin":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\site-origin\\index.js","../confirmations/components/confirm/nav":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\nav\\index.tsx","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirm-encryption-public-key%5Cconfirm-encryption-public-key.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _loglevel = _interopRequireDefault(require("loglevel"));
var _designSystemReact = require("@metamask/design-system-react");
var _accountListItem = _interopRequireDefault(require("../../components/app/account-list-item"));
var _preferredAvatar = require("../../components/app/preferred-avatar");
var _pageContainer = require("../../components/ui/page-container");
var _metametrics = require("../../../shared/constants/metametrics");
var _siteOrigin = _interopRequireDefault(require("../../components/ui/site-origin"));
var _Numeric = require("../../../shared/modules/Numeric");
var _common = require("../../../shared/constants/common");
var _nav = require("../confirmations/components/confirm/nav");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class ConfirmEncryptionPublicKey extends _react.Component {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "renderHeader", () => {
      var _this$props$txData;
      const approvalId = (_this$props$txData = this.props.txData) === null || _this$props$txData === void 0 ? void 0 : _this$props$txData.id;
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_nav.Nav, {
        confirmationId: approvalId
      }), /*#__PURE__*/_react.default.createElement("div", {
        className: "request-encryption-public-key__header"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "request-encryption-public-key__header-background"
      }), /*#__PURE__*/_react.default.createElement("div", {
        className: "request-encryption-public-key__header__text"
      }, this.context.t('encryptionPublicKeyRequest')), /*#__PURE__*/_react.default.createElement("div", {
        className: "request-encryption-public-key__header__tip-container"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "request-encryption-public-key__header__tip"
      }))));
    });
    _defineProperty(this, "renderAccount", () => {
      const {
        fromAccount
      } = this.props;
      const {
        t
      } = this.context;
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "request-encryption-public-key__account"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "request-encryption-public-key__account-text"
      }, `${t('account')}:`), /*#__PURE__*/_react.default.createElement("div", {
        className: "request-encryption-public-key__account-item"
      }, /*#__PURE__*/_react.default.createElement(_accountListItem.default, {
        account: fromAccount
      })));
    });
    _defineProperty(this, "renderBalance", () => {
      const {
        nativeCurrency,
        fromAccount: {
          balance
        }
      } = this.props;
      const {
        t
      } = this.context;
      const nativeCurrencyBalance = new _Numeric.Numeric(balance, 16, _common.EtherDenomination.WEI).toDenomination(_common.EtherDenomination.ETH).round(6).toBase(10).toString();
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "request-encryption-public-key__balance"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "request-encryption-public-key__balance-text"
      }, `${t('balance')}:`), /*#__PURE__*/_react.default.createElement("div", {
        className: "request-encryption-public-key__balance-value"
      }, `${nativeCurrencyBalance} ${nativeCurrency}`));
    });
    _defineProperty(this, "renderRequestIcon", () => {
      const {
        requesterAddress
      } = this.props;
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "request-encryption-public-key__request-icon"
      }, /*#__PURE__*/_react.default.createElement(_preferredAvatar.PreferredAvatar, {
        size: _designSystemReact.AvatarAccountSize.Lg,
        address: requesterAddress
      }));
    });
    _defineProperty(this, "renderAccountInfo", () => {
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "request-encryption-public-key__account-info"
      }, this.renderAccount(), this.renderRequestIcon(), this.renderBalance());
    });
    _defineProperty(this, "renderBody", () => {
      const {
        subjectMetadata,
        txData
      } = this.props;
      const {
        t
      } = this.context;
      const targetSubjectMetadata = subjectMetadata[txData.origin];
      const notice = t('encryptionPublicKeyNotice', [/*#__PURE__*/_react.default.createElement(_siteOrigin.default, {
        siteOrigin: txData.origin,
        key: txData.origin
      })]);
      const name = (targetSubjectMetadata === null || targetSubjectMetadata === void 0 ? void 0 : targetSubjectMetadata.hostname) || txData.origin;
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "request-encryption-public-key__body"
      }, this.renderAccountInfo(), /*#__PURE__*/_react.default.createElement("div", {
        className: "request-encryption-public-key__visual"
      }, /*#__PURE__*/_react.default.createElement("section", null, targetSubjectMetadata !== null && targetSubjectMetadata !== void 0 && targetSubjectMetadata.iconUrl ? /*#__PURE__*/_react.default.createElement("img", {
        className: "request-encryption-public-key__visual-identicon",
        src: targetSubjectMetadata.iconUrl,
        alt: ""
      }) : /*#__PURE__*/_react.default.createElement("i", {
        className: "request-encryption-public-key__visual-identicon--default"
      }, name.charAt(0).toUpperCase()), /*#__PURE__*/_react.default.createElement("div", {
        className: "request-encryption-public-key__notice"
      }, notice))));
    });
    _defineProperty(this, "renderFooter", () => {
      const {
        cancelEncryptionPublicKey,
        clearConfirmTransaction,
        encryptionPublicKey,
        history,
        mostRecentOverviewPage,
        txData
      } = this.props;
      const {
        t,
        trackEvent
      } = this.context;
      return /*#__PURE__*/_react.default.createElement(_pageContainer.PageContainerFooter, {
        cancelText: t('cancel'),
        submitText: t('provide'),
        onCancel: async event => {
          await cancelEncryptionPublicKey(txData, event);
          trackEvent({
            category: _metametrics.MetaMetricsEventCategory.Messages,
            event: 'Cancel',
            properties: {
              action: 'Encryption public key Request',
              legacy_event: true
            }
          });
          clearConfirmTransaction();
          history.push(mostRecentOverviewPage);
        },
        onSubmit: async event => {
          await encryptionPublicKey(txData, event);
          this.context.trackEvent({
            category: _metametrics.MetaMetricsEventCategory.Messages,
            event: 'Confirm',
            properties: {
              action: 'Encryption public key Request',
              legacy_event: true
            }
          });
          clearConfirmTransaction();
          history.push(mostRecentOverviewPage);
        }
      });
    });
    _defineProperty(this, "render", () => {
      if (!this.props.txData) {
        _loglevel.default.warn('ConfirmEncryptionPublicKey Page: Missing txData prop.');
        return null;
      }
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "request-encryption-public-key__container"
      }, this.renderHeader(), this.renderBody(), this.renderFooter());
    });
  }
}
exports.default = ConfirmEncryptionPublicKey;
_defineProperty(ConfirmEncryptionPublicKey, "contextTypes", {
  t: _propTypes.default.func.isRequired,
  trackEvent: _propTypes.default.func.isRequired
});
_defineProperty(ConfirmEncryptionPublicKey, "propTypes", {
  fromAccount: _propTypes.default.shape({
    address: _propTypes.default.string.isRequired,
    balance: _propTypes.default.string,
    name: _propTypes.default.string
  }).isRequired,
  clearConfirmTransaction: _propTypes.default.func.isRequired,
  cancelEncryptionPublicKey: _propTypes.default.func.isRequired,
  encryptionPublicKey: _propTypes.default.func.isRequired,
  history: _propTypes.default.object.isRequired,
  requesterAddress: _propTypes.default.string,
  txData: _propTypes.default.object,
  subjectMetadata: _propTypes.default.object,
  mostRecentOverviewPage: _propTypes.default.string.isRequired,
  nativeCurrency: _propTypes.default.string.isRequired
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirm-encryption-public-key\\confirm-encryption-public-key.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirm-encryption-public-key\\confirm-encryption-public-key.container.js", {"../../ducks/confirm-transaction/confirm-transaction.duck":"D:\\code\\v\\metamask-extension\\ui\\ducks\\confirm-transaction\\confirm-transaction.duck.js","../../ducks/history/history":"D:\\code\\v\\metamask-extension\\ui\\ducks\\history\\history.js","../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./confirm-encryption-public-key.component":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirm-encryption-public-key\\confirm-encryption-public-key.component.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js","redux":"D:\\code\\v\\metamask-extension\\node_modules\\redux\\lib\\redux.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirm-encryption-public-key%5Cconfirm-encryption-public-key.container.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactRedux = require("react-redux");
var _redux = require("redux");
var _reactRouterDom = require("react-router-dom");
var _actions = require("../../store/actions");
var _selectors = require("../../selectors");
var _confirmTransaction = require("../../ducks/confirm-transaction/confirm-transaction.duck");
var _history = require("../../ducks/history/history");
var _metamask = require("../../ducks/metamask/metamask");
var _confirmEncryptionPublicKey = _interopRequireDefault(require("./confirm-encryption-public-key.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function mapStateToProps(state, ownProps) {
  const {
    metamask: {
      subjectMetadata = {}
    }
  } = state;
  const unconfirmedTransactions = (0, _selectors.unconfirmedTransactionsListSelector)(state);
  const {
    match: {
      params: {
        id: approvalId
      }
    }
  } = ownProps;
  const txData = unconfirmedTransactions.find(tx => tx.id === approvalId);
  const fromAccount = (0, _selectors.getTargetAccountWithSendEtherInfo)(state, txData === null || txData === void 0 ? void 0 : txData.msgParams);
  return {
    txData,
    subjectMetadata,
    fromAccount,
    requester: null,
    requesterAddress: null,
    mostRecentOverviewPage: (0, _history.getMostRecentOverviewPage)(state),
    nativeCurrency: (0, _metamask.getNativeCurrency)(state)
  };
}
function mapDispatchToProps(dispatch) {
  return {
    goHome: () => dispatch((0, _actions.goHome)()),
    clearConfirmTransaction: () => dispatch((0, _confirmTransaction.clearConfirmTransaction)()),
    encryptionPublicKey: (msgData, event) => {
      const params = {
        data: msgData.msgParams,
        metamaskId: msgData.id
      };
      event.stopPropagation();
      return dispatch((0, _actions.encryptionPublicKeyMsg)(params));
    },
    cancelEncryptionPublicKey: (msgData, event) => {
      event.stopPropagation();
      return dispatch((0, _actions.cancelEncryptionPublicKeyMsg)(msgData));
    }
  };
}
var _default = exports.default = (0, _redux.compose)(_reactRouterDom.withRouter, (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps))(_confirmEncryptionPublicKey.default);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirm-encryption-public-key\\confirm-encryption-public-key.container.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirm-encryption-public-key\\index.js", {"./confirm-encryption-public-key.container":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirm-encryption-public-key\\confirm-encryption-public-key.container.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirm-encryption-public-key%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _confirmEncryptionPublicKey.default;
  }
});
var _confirmEncryptionPublicKey = _interopRequireDefault(require("./confirm-encryption-public-key.container"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirm-encryption-public-key\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\UI\\asset\\asset.tsx", {"../../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../hooks/useFormatters":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useFormatters.ts","../../../hooks/useNftImageUrl":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useNftImageUrl.ts","../../../types/send":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\types\\send.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5CUI%5Casset%5Casset.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Asset = void 0;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../../../../components/component-library");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _send = require("../../../types/send");
var _useNftImageUrl = require("../../../hooks/useNftImageUrl");
var _useFormatters = require("../../../../../hooks/useFormatters");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const NftAsset = ({
  asset,
  onClick,
  isSelected
}) => {
  const nftData = asset;
  const {
    collection,
    name,
    tokenId,
    image,
    standard,
    balance
  } = nftData;
  const nftItemSrc = (0, _useNftImageUrl.useNftImageUrl)(image);

  // Calculate ERC1155 display text
  let erc1155Text = null;
  if (standard === _send.AssetStandard.ERC1155) {
    erc1155Text = name ? `(${balance === null || balance === void 0 ? void 0 : balance.toString()}) ${name} - #${tokenId}` : `(${balance === null || balance === void 0 ? void 0 : balance.toString()}) #${tokenId}`;
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    alignItems: _designSystem.AlignItems.center,
    backgroundColor: isSelected ? _designSystem.BackgroundColor.backgroundHover : _designSystem.BackgroundColor.transparent,
    className: "send-asset",
    "data-testid": "nft-asset",
    display: _designSystem.Display.Flex,
    onClick: onClick,
    paddingTop: 3,
    paddingBottom: 3,
    paddingLeft: 4,
    paddingRight: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginRight: 4,
    style: {
      minWidth: 32
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.BadgeWrapper, {
    badge: nftData.chainId ? /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
      size: _componentLibrary.AvatarNetworkSize.Xs,
      name: nftData.networkName ?? '',
      src: nftData.networkImage
    }) : null
  }, image || collection !== null && collection !== void 0 && collection.imageUrl ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    as: "img",
    src: nftItemSrc || (collection === null || collection === void 0 ? void 0 : collection.imageUrl),
    alt: name,
    style: {
      width: 32,
      height: 32,
      borderRadius: 8,
      objectFit: 'cover'
    }
  }) : null)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    style: {
      flex: 1,
      overflow: 'hidden'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: _designSystem.TextColor.textDefault,
    ellipsis: true
  }, collection === null || collection === void 0 ? void 0 : collection.name), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySmMedium,
    color: _designSystem.TextColor.textAlternative,
    ellipsis: true
  }, standard === _send.AssetStandard.ERC721 && name, standard === _send.AssetStandard.ERC1155 && erc1155Text)));
};
const TokenAsset = ({
  asset,
  onClick,
  isSelected
}) => {
  const tokenData = asset;
  const {
    chainId,
    image,
    name,
    balance,
    symbol = '',
    fiat
  } = tokenData;
  const {
    formatCurrencyWithMinThreshold,
    formatTokenQuantity
  } = (0, _useFormatters.useFormatters)();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    alignItems: _designSystem.AlignItems.center,
    backgroundColor: isSelected ? _designSystem.BackgroundColor.backgroundHover : _designSystem.BackgroundColor.transparent,
    className: "send-asset",
    "data-testid": `token-asset-${chainId}-${symbol}`,
    display: _designSystem.Display.Flex,
    onClick: onClick,
    paddingTop: 3,
    paddingBottom: 3,
    paddingLeft: 4,
    paddingRight: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginRight: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.BadgeWrapper, {
    badge: chainId ? /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
      size: _componentLibrary.AvatarNetworkSize.Xs,
      name: tokenData.networkName ?? '',
      src: tokenData.networkImage
    }) : null
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarToken, {
    size: _componentLibrary.AvatarTokenSize.Md,
    src: image,
    name: symbol,
    showHalo: false
  }))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    style: {
      flex: 1,
      overflow: 'hidden'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: _designSystem.TextColor.textDefault
  }, name), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySmMedium,
    color: _designSystem.TextColor.textAlternative,
    ellipsis: true
  }, symbol)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.flexEnd,
    marginLeft: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium
  }, formatCurrencyWithMinThreshold((fiat === null || fiat === void 0 ? void 0 : fiat.balance) ?? 0, (fiat === null || fiat === void 0 ? void 0 : fiat.currency) || '')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySmMedium,
    color: _designSystem.TextColor.textAlternative
  }, formatTokenQuantity(Number(balance ?? 0), symbol))));
};
const Asset = ({
  asset,
  onClick,
  isSelected
}) => {
  if (_send.NFT_STANDARDS.includes(asset.standard)) {
    return /*#__PURE__*/_react.default.createElement(NftAsset, {
      asset: asset,
      onClick: onClick,
      isSelected: isSelected
    });
  }
  return /*#__PURE__*/_react.default.createElement(TokenAsset, {
    asset: asset,
    onClick: onClick,
    isSelected: isSelected
  });
};
exports.Asset = Asset;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\UI\\asset\\asset.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\UI\\asset\\index.ts", {"./asset":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\UI\\asset\\asset.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5CUI%5Casset%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _asset = require("./asset");
Object.keys(_asset).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _asset[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _asset[key];
    }
  });
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\UI\\asset\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\UI\\recipient\\index.ts", {"./recipient":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\UI\\recipient\\recipient.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5CUI%5Crecipient%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _recipient = require("./recipient");
Object.keys(_recipient).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _recipient[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _recipient[key];
    }
  });
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\UI\\recipient\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\UI\\recipient\\recipient.tsx", {"../../../../../components/app/preferred-avatar":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\preferred-avatar\\index.ts","../../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5CUI%5Crecipient%5Crecipient.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Recipient = void 0;
var _react = _interopRequireDefault(require("react"));
var _designSystemReact = require("@metamask/design-system-react");
var _preferredAvatar = require("../../../../../components/app/preferred-avatar");
var _componentLibrary = require("../../../../../components/component-library");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _util = require("../../../../../helpers/utils/util");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const Recipient = ({
  isAccount,
  isSelected,
  recipient,
  onClick
}) => {
  const {
    address,
    seedIcon
  } = recipient;
  const recipientName = isAccount ? recipient.accountGroupName : recipient.contactName;
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    alignItems: _designSystem.AlignItems.center,
    backgroundColor: isSelected ? _designSystem.BackgroundColor.backgroundHover : _designSystem.BackgroundColor.transparent,
    className: "send-recipient",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    paddingTop: 3,
    paddingBottom: 3,
    paddingLeft: 4,
    paddingRight: 4,
    gap: 4,
    onClick: () => onClick(recipient)
  }, /*#__PURE__*/_react.default.createElement(_preferredAvatar.PreferredAvatar, {
    address: seedIcon ?? address,
    size: _designSystemReact.AvatarAccountSize.Lg,
    "data-testid": "avatar"
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium
  }, recipientName), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySmMedium,
    color: _designSystem.TextColor.textAlternative
  }, (0, _util.shortenAddress)(address))));
};
exports.Recipient = Recipient;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\UI\\recipient\\recipient.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\UI\\send-hero\\index.ts", {"./send-hero":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\UI\\send-hero\\send-hero.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5CUI%5Csend-hero%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _sendHero = require("./send-hero");
Object.keys(_sendHero).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _sendHero[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _sendHero[key];
    }
  });
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\UI\\send-hero\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\UI\\send-hero\\send-hero.tsx", {"../../../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useChainNetworkNameAndImage":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useChainNetworkNameAndImage.ts","../../../hooks/useNftImageUrl":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useNftImageUrl.ts","../../../types/send":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\types\\send.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5CUI%5Csend-hero%5Csend-hero.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SendHero = void 0;
var _react = _interopRequireDefault(require("react"));
var _network = require("../../../../../../shared/constants/network");
var _componentLibrary = require("../../../../../components/component-library");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _send = require("../../../types/send");
var _useNftImageUrl = require("../../../hooks/useNftImageUrl");
var _useChainNetworkNameAndImage = require("../../../hooks/useChainNetworkNameAndImage");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const NFTHero = ({
  asset
}) => {
  var _asset$collection;
  const nftData = asset;
  const {
    collection,
    name,
    image
  } = nftData;
  const nftItemSrc = (0, _useNftImageUrl.useNftImageUrl)(image);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.center,
    marginTop: 6,
    marginBottom: 9
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.BadgeWrapper, {
    style: {
      alignSelf: 'center'
    },
    badge: nftData.chainId ? /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
      size: _componentLibrary.AvatarNetworkSize.Sm,
      name: nftData.networkName ?? '',
      src: nftData.networkImage,
      style: {
        width: 20,
        height: 20,
        borderWidth: 2
      }
    }) : null
  }, image || collection !== null && collection !== void 0 && collection.imageUrl ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    as: "img",
    src: nftItemSrc || (collection === null || collection === void 0 ? void 0 : collection.imageUrl),
    alt: name,
    style: {
      width: 48,
      height: 48,
      borderRadius: 12,
      objectFit: 'cover'
    },
    onError: e => {
      var _target$nextElementSi;
      const target = e.target;
      target.style.display = 'none';
      (_target$nextElementSi = target.nextElementSibling) === null || _target$nextElementSi === void 0 || _target$nextElementSi.classList.remove('hidden');
    }
  }) : null), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingSm,
    color: _designSystem.TextColor.textDefault,
    marginTop: 4
  }, asset.name || ((_asset$collection = asset.collection) === null || _asset$collection === void 0 ? void 0 : _asset$collection.name)));
};
const TokenHero = ({
  asset
}) => {
  const chainNetworkNameAndImageMap = (0, _useChainNetworkNameAndImage.useChainNetworkNameAndImageMap)();
  const {
    chainId,
    image,
    symbol,
    isNative,
    networkImage,
    networkName
  } = asset ?? {};
  const nativeTokenImage = isNative ? _network.CHAIN_ID_TOKEN_IMAGE_MAP[chainId] ?? _network.CHAIN_ID_TO_NETWORK_IMAGE_URL_MAP[chainId] : undefined;
  const chainNetworkNameAndImage = chainNetworkNameAndImageMap.get(chainId);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.center,
    marginTop: 6,
    marginBottom: 9
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.BadgeWrapper, {
    style: {
      alignSelf: 'center'
    },
    badge: chainId ? /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
      size: _componentLibrary.AvatarNetworkSize.Sm,
      name: networkName || (chainNetworkNameAndImage === null || chainNetworkNameAndImage === void 0 ? void 0 : chainNetworkNameAndImage.networkName) || '',
      src: networkImage || (chainNetworkNameAndImage === null || chainNetworkNameAndImage === void 0 ? void 0 : chainNetworkNameAndImage.networkImage),
      style: {
        width: 20,
        height: 20,
        borderWidth: 2
      }
    }) : null
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarToken, {
    size: _componentLibrary.AvatarTokenSize.Xl,
    src: image || nativeTokenImage,
    name: symbol,
    showHalo: false
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingSm,
    color: _designSystem.TextColor.textDefault,
    marginTop: 4
  }, symbol));
};
const SendHero = ({
  asset
}) => {
  if (asset !== null && asset !== void 0 && asset.standard && _send.NFT_STANDARDS.includes(asset.standard)) {
    return /*#__PURE__*/_react.default.createElement(NFTHero, {
      asset: asset
    });
  }
  return /*#__PURE__*/_react.default.createElement(TokenHero, {
    asset: asset
  });
};
exports.SendHero = SendHero;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\UI\\send-hero\\send-hero.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-controls\\advanced-gas-controls.component.js", {"../../../../components/ui/form-field":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\form-field\\index.js","../../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../../helpers/constants/gas":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\gas.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cadvanced-gas-controls%5Cadvanced-gas-controls.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = AdvancedGasControls;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18n = require("../../../../contexts/i18n");
var _formField = _interopRequireDefault(require("../../../../components/ui/form-field"));
var _gas = require("../../../../helpers/constants/gas");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function AdvancedGasControls({
  onManualChange,
  gasLimit,
  setGasLimit,
  gasPrice,
  setGasPrice,
  gasErrors,
  minimumGasLimit
}) {
  const t = (0, _react.useContext)(_i18n.I18nContext);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "advanced-gas-controls"
  }, /*#__PURE__*/_react.default.createElement(_formField.default, {
    titleText: t('gasLimit'),
    error: gasErrors !== null && gasErrors !== void 0 && gasErrors.gasLimit ? (0, _gas.getGasFormErrorText)(gasErrors.gasLimit, t, {
      minimumGasLimit
    }) : null,
    onChange: value => {
      onManualChange === null || onManualChange === void 0 || onManualChange();
      setGasLimit(value);
    },
    tooltipText: t('editGasLimitTooltip'),
    value: gasLimit,
    allowDecimals: false,
    numeric: true
  }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_formField.default, {
    titleText: t('advancedGasPriceTitle'),
    titleUnit: "(GWEI)",
    onChange: value => {
      onManualChange === null || onManualChange === void 0 || onManualChange();
      setGasPrice(value);
    },
    tooltipText: t('editGasPriceTooltip'),
    value: gasPrice,
    numeric: true,
    allowDecimals: true,
    error: gasErrors !== null && gasErrors !== void 0 && gasErrors.gasPrice ? (0, _gas.getGasFormErrorText)(gasErrors.gasPrice, t) : null
  })));
}
AdvancedGasControls.propTypes = {
  onManualChange: _propTypes.default.func,
  gasLimit: _propTypes.default.number,
  setGasLimit: _propTypes.default.func,
  gasPrice: _propTypes.default.string,
  setGasPrice: _propTypes.default.func,
  minimumGasLimit: _propTypes.default.string,
  gasErrors: _propTypes.default.object
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\advanced-gas-controls\\advanced-gas-controls.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-defaults\\advanced-gas-fee-defaults.js", {"../../../../../../shared/constants/gas":"D:\\code\\v\\metamask-extension\\shared\\constants\\gas.ts","../../../../../../shared/modules/Numeric":"D:\\code\\v\\metamask-extension\\shared\\modules\\Numeric.ts","../../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../../contexts/gasFee":"D:\\code\\v\\metamask-extension\\ui\\contexts\\gasFee.js","../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../../hooks/useTransactionEventFragment":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useTransactionEventFragment.js","../context":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\context\\index.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cadvanced-gas-fee-popover%5Cadvanced-gas-fee-defaults%5Cadvanced-gas-fee-defaults.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _lodash = require("lodash");
var _useTransactionEventFragment = require("../../../hooks/useTransactionEventFragment");
var _gas = require("../../../../../../shared/constants/gas");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _selectors = require("../../../../../selectors");
var _actions = require("../../../../../store/actions");
var _gasFee = require("../../../../../contexts/gasFee");
var _context = require("../context");
var _useI18nContext = require("../../../../../hooks/useI18nContext");
var _componentLibrary = require("../../../../../components/component-library");
var _Numeric = require("../../../../../../shared/modules/Numeric");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AdvancedGasFeeDefaults = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    gasErrors,
    maxBaseFee: maxBaseFeeNumber,
    maxPriorityFeePerGas: maxPriorityFeePerGasNumber
  } = (0, _context.useAdvancedGasFeePopoverContext)();
  const maxBaseFee = new _Numeric.Numeric(maxBaseFeeNumber, 10).toString();
  const maxPriorityFeePerGas = new _Numeric.Numeric(maxPriorityFeePerGasNumber, 10).toString();
  const advancedGasFeeValues = (0, _reactRedux.useSelector)(_selectors.getAdvancedGasFeeValues);
  const {
    updateTransactionEventFragment
  } = (0, _useTransactionEventFragment.useTransactionEventFragment)();
  const {
    editGasMode,
    transaction
  } = (0, _gasFee.useGasFeeContext)();
  const {
    chainId
  } = transaction;
  const networkIdentifier = (0, _reactRedux.useSelector)(state => (0, _selectors.selectNetworkIdentifierByChainId)(state, chainId));
  const [isDefaultSettingsSelected, setDefaultSettingsSelected] = (0, _react.useState)(Boolean(advancedGasFeeValues) && advancedGasFeeValues.maxBaseFee === maxBaseFee && advancedGasFeeValues.priorityFee === maxPriorityFeePerGas);
  (0, _react.useEffect)(() => {
    setDefaultSettingsSelected(Boolean(advancedGasFeeValues) && advancedGasFeeValues.maxBaseFee === maxBaseFee && advancedGasFeeValues.priorityFee === maxPriorityFeePerGas);
  }, [advancedGasFeeValues, maxBaseFee, maxPriorityFeePerGas]);
  const handleUpdateDefaultSettings = () => {
    if (isDefaultSettingsSelected) {
      dispatch((0, _actions.setAdvancedGasFee)({
        chainId,
        gasFeePreferences: undefined
      }));
      setDefaultSettingsSelected(false);
      updateTransactionEventFragment({
        properties: {
          advanced_gas_defaults_updated_maxbasefee: null,
          advanced_gas_defaults_updated_priorityfee: null
        }
      });
    } else {
      dispatch((0, _actions.setAdvancedGasFee)({
        chainId,
        gasFeePreferences: {
          maxBaseFee,
          priorityFee: maxPriorityFeePerGas
        }
      }));
      updateTransactionEventFragment({
        properties: {
          advanced_gas_defaults_updated_maxbasefee: maxBaseFee,
          advanced_gas_defaults_updated_priorityfee: maxPriorityFeePerGas
        }
      });
    }
  };
  if (editGasMode === _gas.EditGasModes.swaps) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    marginTop: 4,
    marginLeft: 2,
    marginRight: 2,
    paddingTop: 4,
    paddingBottom: 4,
    className: "advanced-gas-fee-defaults"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Checkbox, {
    isChecked: isDefaultSettingsSelected,
    onChange: handleUpdateDefaultSettings,
    isDisabled: gasErrors.maxFeePerGas || gasErrors.maxPriorityFeePerGas,
    label: t('advancedGasFeeDefaultOptIn', [(0, _lodash.capitalize)(networkIdentifier)])
  }));
};
var _default = exports.default = AdvancedGasFeeDefaults;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-defaults\\advanced-gas-fee-defaults.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-defaults\\index.js", {"./advanced-gas-fee-defaults":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-defaults\\advanced-gas-fee-defaults.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cadvanced-gas-fee-popover%5Cadvanced-gas-fee-defaults%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _advancedGasFeeDefaults.default;
  }
});
var _advancedGasFeeDefaults = _interopRequireDefault(require("./advanced-gas-fee-defaults"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-defaults\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-gas-limit\\advanced-gas-fee-gas-limit.js", {"../../../../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../../components/ui/form-field":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\form-field\\index.js","../../../../../contexts/gasFee":"D:\\code\\v\\metamask-extension\\ui\\contexts\\gasFee.js","../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../constants":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\constants\\index.ts","../../../send-legacy/send.constants":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\send-legacy\\send.constants.js","../context":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\context\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cadvanced-gas-fee-popover%5Cadvanced-gas-fee-gas-limit%5Cadvanced-gas-fee-gas-limit.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _gasFee = require("../../../../../contexts/gasFee");
var _util = require("../../../../../helpers/utils/util");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../../hooks/useI18nContext");
var _send = require("../../../send-legacy/send.constants");
var _formField = _interopRequireDefault(require("../../../../../components/ui/form-field"));
var _context = require("../context");
var _componentLibrary = require("../../../../../components/component-library");
var _constants = require("../../../constants");
var _conversion = require("../../../../../../shared/modules/conversion.utils");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const validateGasLimit = (gasLimit, minGasLimit, maxGasLimit) => (0, _util.bnLessThan)(gasLimit, minGasLimit) || (0, _util.bnGreaterThan)(gasLimit, maxGasLimit) ? 'editGasLimitOutOfBoundsV2' : null;
const AdvancedGasFeeGasLimit = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    setGasLimit: setGasLimitInContext,
    setErrorValue
  } = (0, _context.useAdvancedGasFeePopoverContext)();
  const {
    gasLimit: gasLimitInTransaction,
    minimumGasLimitDec,
    transaction: {
      chainId,
      originalGasEstimate
    }
  } = (0, _gasFee.useGasFeeContext)();
  const originalGasEstimateDec = originalGasEstimate !== undefined && (0, _conversion.hexToDecimal)(originalGasEstimate);
  const [maxGasLimit, setMaxGasLimit] = (0, _react.useState)(originalGasEstimateDec ? Math.max(_send.MAX_GAS_LIMIT_DEC, originalGasEstimateDec) : _send.MAX_GAS_LIMIT_DEC);
  const [isEditing, setEditing] = (0, _react.useState)(false);
  const [gasLimit, setGasLimit] = (0, _react.useState)(gasLimitInTransaction);
  const [gasLimitError, setGasLimitError] = (0, _react.useState)();
  const updateGasLimit = value => {
    setGasLimit(value || 0);
  };
  (0, _react.useEffect)(() => {
    setGasLimitInContext(gasLimit);
    if (_constants.IGNORE_GAS_LIMIT_CHAIN_IDS.includes(chainId)) {
      return;
    }
    const error = validateGasLimit(gasLimit, minimumGasLimitDec, maxGasLimit);
    setGasLimitError(error);
    setEditing(isEditing === true ? isEditing : error !== null);
    setErrorValue('gasLimit', error === 'editGasLimitOutOfBoundsV2');
  }, [chainId, gasLimit, minimumGasLimitDec, setGasLimitInContext, setErrorValue, maxGasLimit, isEditing, t]);
  (0, _react.useEffect)(() => {
    if (originalGasEstimateDec) {
      setMaxGasLimit(Math.max(_send.MAX_GAS_LIMIT_DEC, originalGasEstimateDec));
    }
  }, [minimumGasLimitDec, originalGasEstimateDec, setMaxGasLimit]);
  if (isEditing) {
    return /*#__PURE__*/_react.default.createElement(_formField.default, {
      dataTestId: "gas-limit-input",
      error: gasLimitError ? t(gasLimitError, [minimumGasLimitDec - 1, maxGasLimit]) : '',
      onChange: updateGasLimit,
      titleText: t('gasLimitV2'),
      value: gasLimit,
      allowDecimals: false,
      numeric: true
    });
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    tag: _designSystem.TextVariant.bodyMd,
    variant: _designSystem.TextVariant.bodySm,
    as: "h6",
    className: "advanced-gas-fee-gas-limit",
    marginTop: 4,
    marginLeft: 2,
    marginRight: 2
  }, /*#__PURE__*/_react.default.createElement("strong", null, t('gasLimitV2')), /*#__PURE__*/_react.default.createElement("span", null, gasLimit), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    "data-testid": "advanced-gas-fee-edit",
    className: "advanced-gas-fee-gas-limit__edit-link",
    onClick: () => setEditing(true),
    variant: _componentLibrary.ButtonVariant.Link,
    size: _componentLibrary.ButtonSize.Inherit
  }, t('edit')));
};
var _default = exports.default = AdvancedGasFeeGasLimit;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-gas-limit\\advanced-gas-fee-gas-limit.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-gas-limit\\index.js", {"./advanced-gas-fee-gas-limit":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-gas-limit\\advanced-gas-fee-gas-limit.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cadvanced-gas-fee-popover%5Cadvanced-gas-fee-gas-limit%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _advancedGasFeeGasLimit.default;
  }
});
var _advancedGasFeeGasLimit = _interopRequireDefault(require("./advanced-gas-fee-gas-limit"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-gas-limit\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-input-subtext\\advanced-gas-fee-input-subtext.js", {"../../../../../components/ui/box":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\box\\index.js","../../../../../components/ui/loading-heartbeat":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\loading-heartbeat\\index.js","../../../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../../../helpers/utils/gas":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\gas.js","../../../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cadvanced-gas-fee-popover%5Cadvanced-gas-fee-input-subtext%5Cadvanced-gas-fee-input-subtext.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _util = require("../../../../../helpers/utils/util");
var _gas = require("../../../../../helpers/utils/gas");
var _i18n = require("../../../../../contexts/i18n");
var _box = _interopRequireDefault(require("../../../../../components/ui/box"));
var _loadingHeartbeat = _interopRequireDefault(require("../../../../../components/ui/loading-heartbeat"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function determineTrendInfo(trend, t) {
  switch (trend) {
    case 'up':
      return {
        className: 'fa-arrow-up advanced-gas-fee-input-subtext__up',
        color: 'var(--color-success-default)',
        title: t('upArrow')
      };
    case 'down':
      return {
        className: 'fa-arrow-down advanced-gas-fee-input-subtext__down',
        color: 'var(--color-error-default)',
        title: t('downArrow')
      };
    case 'level':
      return {
        className: 'fa-arrow-right advanced-gas-fee-input-subtext__level',
        color: 'var(--color-icon-alternative)',
        title: t('levelArrow')
      };
    default:
      return null;
  }
}
const AdvancedGasFeeInputSubtext = ({
  latest,
  historical,
  trend
}) => {
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const trendInfo = determineTrendInfo(trend, t);
  return /*#__PURE__*/_react.default.createElement(_box.default, {
    display: "flex",
    alignItems: "center",
    gap: 4,
    className: "advanced-gas-fee-input-subtext"
  }, (0, _util.isNullish)(latest) ? null : /*#__PURE__*/_react.default.createElement(_box.default, {
    display: "flex",
    alignItems: "center",
    "data-testid": "latest"
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "advanced-gas-fee-input-subtext__label"
  }, t('currentTitle')), /*#__PURE__*/_react.default.createElement("span", {
    className: "advanced-gas-fee-input-subtext__value"
  }, /*#__PURE__*/_react.default.createElement(_loadingHeartbeat.default, null), (0, _gas.formatGasFeeOrFeeRange)(latest)), trendInfo === null ? null : /*#__PURE__*/_react.default.createElement("span", {
    className: "advanced-gas-fee-input-subtext__icon"
  }, /*#__PURE__*/_react.default.createElement("i", {
    className: (0, _classnames.default)('fa', trendInfo.className),
    style: {
      color: trendInfo.color
    },
    title: trendInfo.title,
    "data-testid": "fee-arrow"
  }))), (0, _util.isNullish)(historical) ? null : /*#__PURE__*/_react.default.createElement(_box.default, null, /*#__PURE__*/_react.default.createElement("span", {
    className: "advanced-gas-fee-input-subtext__label",
    "data-testid": "historical"
  }, t('twelveHrTitle')), /*#__PURE__*/_react.default.createElement("span", {
    className: "advanced-gas-fee-input-subtext__value"
  }, /*#__PURE__*/_react.default.createElement(_loadingHeartbeat.default, null), (0, _gas.formatGasFeeOrFeeRange)(historical))));
};
AdvancedGasFeeInputSubtext.propTypes = {
  latest: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.arrayOf(_propTypes.default.string)]),
  historical: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.arrayOf(_propTypes.default.string)]),
  trend: _propTypes.default.oneOf(['up', 'down', 'level'])
};
var _default = exports.default = AdvancedGasFeeInputSubtext;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-input-subtext\\advanced-gas-fee-input-subtext.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-input-subtext\\index.js", {"./advanced-gas-fee-input-subtext":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-input-subtext\\advanced-gas-fee-input-subtext.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cadvanced-gas-fee-popover%5Cadvanced-gas-fee-input-subtext%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _advancedGasFeeInputSubtext.default;
  }
});
var _advancedGasFeeInputSubtext = _interopRequireDefault(require("./advanced-gas-fee-input-subtext"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-input-subtext\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-inputs\\advanced-gas-fee-inputs.js", {"../../../../../components/ui/box":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\box\\index.js","./base-fee-input":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-inputs\\base-fee-input\\index.js","./priority-fee-input":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-inputs\\priority-fee-input\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cadvanced-gas-fee-popover%5Cadvanced-gas-fee-inputs%5Cadvanced-gas-fee-inputs.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _box = _interopRequireDefault(require("../../../../../components/ui/box"));
var _baseFeeInput = _interopRequireDefault(require("./base-fee-input"));
var _priorityFeeInput = _interopRequireDefault(require("./priority-fee-input"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const AdvancedGasFeeInputs = () => {
  return /*#__PURE__*/_react.default.createElement(_box.default, {
    className: "advanced-gas-fee-inputs"
  }, /*#__PURE__*/_react.default.createElement(_baseFeeInput.default, null), /*#__PURE__*/_react.default.createElement(_priorityFeeInput.default, null));
};
var _default = exports.default = AdvancedGasFeeInputs;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-inputs\\advanced-gas-fee-inputs.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-inputs\\base-fee-input\\base-fee-input.js", {"../../../../../../../shared/constants/gas":"D:\\code\\v\\metamask-extension\\shared\\constants\\gas.ts","../../../../../../../shared/modules/Numeric":"D:\\code\\v\\metamask-extension\\shared\\modules\\Numeric.ts","../../../../../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../../../../../components/ui/box":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\box\\index.js","../../../../../../components/ui/form-field":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\form-field\\index.js","../../../../../../contexts/gasFee":"D:\\code\\v\\metamask-extension\\ui\\contexts\\gasFee.js","../../../../../../helpers/constants/common":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\common.ts","../../../../../../hooks/useCurrencyDisplay":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useCurrencyDisplay.js","../../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../../../hooks/useUserPreferencedCurrency":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useUserPreferencedCurrency.js","../../../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../constants":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\constants\\index.ts","../../../../send-legacy/send.constants":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\send-legacy\\send.constants.js","../../advanced-gas-fee-input-subtext":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-input-subtext\\index.js","../../context":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\context\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cadvanced-gas-fee-popover%5Cadvanced-gas-fee-inputs%5Cbase-fee-input%5Cbase-fee-input.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _send = require("../../../../send-legacy/send.constants");
var _gas = require("../../../../../../../shared/constants/gas");
var _common = require("../../../../../../helpers/constants/common");
var _selectors = require("../../../../../../selectors");
var _gasFee = require("../../../../../../contexts/gasFee");
var _useI18nContext = require("../../../../../../hooks/useI18nContext");
var _useUserPreferencedCurrency = require("../../../../../../hooks/useUserPreferencedCurrency");
var _useCurrencyDisplay = require("../../../../../../hooks/useCurrencyDisplay");
var _box = _interopRequireDefault(require("../../../../../../components/ui/box"));
var _formField = _interopRequireDefault(require("../../../../../../components/ui/form-field"));
var _context = require("../../context");
var _advancedGasFeeInputSubtext = _interopRequireDefault(require("../../advanced-gas-fee-input-subtext"));
var _conversion = require("../../../../../../../shared/modules/conversion.utils");
var _Numeric = require("../../../../../../../shared/modules/Numeric");
var _constants = require("../../../../constants");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const validateBaseFee = (value, gasFeeEstimates, maxPriorityFeePerGas, chainId) => {
  const baseFeeValue = new _Numeric.Numeric(value, 10);
  if (new _Numeric.Numeric(maxPriorityFeePerGas, 10).greaterThan(baseFeeValue)) {
    return 'editGasMaxBaseFeeGWEIImbalance';
  }
  if (gasFeeEstimates !== null && gasFeeEstimates !== void 0 && gasFeeEstimates.low && baseFeeValue.lessThan(gasFeeEstimates.low.suggestedMaxFeePerGas, 10) && _constants.IGNORE_GAS_LIMIT_CHAIN_IDS.includes(chainId)) {
    return 'editGasMaxBaseFeeLow';
  }
  if (gasFeeEstimates !== null && gasFeeEstimates !== void 0 && gasFeeEstimates.high && baseFeeValue.greaterThan(gasFeeEstimates.high.suggestedMaxFeePerGas * _send.HIGH_FEE_WARNING_MULTIPLIER, 10)) {
    return 'editGasMaxBaseFeeHigh';
  }
  return null;
};
const BaseFeeInput = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    gasFeeEstimates,
    estimateUsed,
    maxFeePerGas: maxBaseFeeNumber,
    editGasMode,
    transaction: {
      chainId
    }
  } = (0, _gasFee.useGasFeeContext)();
  const maxFeePerGas = new _Numeric.Numeric(maxBaseFeeNumber, 10).toString();
  const {
    gasLimit,
    maxPriorityFeePerGas,
    setErrorValue,
    setMaxFeePerGas,
    setMaxBaseFee
  } = (0, _context.useAdvancedGasFeePopoverContext)();
  const {
    estimatedBaseFee,
    historicalBaseFeeRange,
    baseFeeTrend
  } = gasFeeEstimates ?? {};
  const [baseFeeError, setBaseFeeError] = (0, _react.useState)();
  const {
    currency,
    numberOfDecimals
  } = (0, _useUserPreferencedCurrency.useUserPreferencedCurrency)(_common.PRIMARY);
  const advancedGasFeeValues = (0, _reactRedux.useSelector)(_selectors.getAdvancedGasFeeValues);
  const defaultBaseFee = estimateUsed !== _gas.PriorityLevels.custom && advancedGasFeeValues !== null && advancedGasFeeValues !== void 0 && advancedGasFeeValues.maxBaseFee && editGasMode !== _gas.EditGasModes.swaps ? advancedGasFeeValues.maxBaseFee : maxFeePerGas;
  const [baseFee, setBaseFee] = (0, _react.useState)(defaultBaseFee > 0 ? defaultBaseFee : undefined);
  (0, _react.useEffect)(() => {
    if (baseFee === undefined && defaultBaseFee > 0) {
      setBaseFee(defaultBaseFee);
    }
  }, [baseFee, defaultBaseFee, setBaseFee]);
  const [baseFeeInPrimaryCurrency] = (0, _useCurrencyDisplay.useCurrencyDisplay)((0, _conversion.decGWEIToHexWEI)(baseFee * gasLimit), {
    currency,
    numberOfDecimals
  });
  const updateBaseFee = (0, _react.useCallback)(value => {
    setBaseFee(value);
  }, [setBaseFee]);
  (0, _react.useEffect)(() => {
    setMaxFeePerGas(baseFee);
    const error = validateBaseFee(baseFee, gasFeeEstimates, maxPriorityFeePerGas, chainId);
    setBaseFeeError(error);
    setErrorValue('maxFeePerGas', error === 'editGasMaxBaseFeeGWEIImbalance');
    setMaxBaseFee(baseFee);
  }, [baseFee, chainId, gasFeeEstimates, maxPriorityFeePerGas, setBaseFeeError, setErrorValue, setMaxFeePerGas, setMaxBaseFee]);
  return /*#__PURE__*/_react.default.createElement(_box.default, {
    className: "base-fee-input",
    marginLeft: 2,
    marginRight: 2
  }, /*#__PURE__*/_react.default.createElement(_formField.default, {
    dataTestId: "base-fee-input",
    error: baseFeeError ? t(baseFeeError) : '',
    onChange: updateBaseFee,
    titleText: t('maxBaseFee'),
    titleUnit: `(${t('gwei')})`,
    tooltipText: t('advancedBaseGasFeeToolTip'),
    value: baseFee,
    detailText: `≈ ${baseFeeInPrimaryCurrency}`,
    allowDecimals: true,
    numeric: true
  }), /*#__PURE__*/_react.default.createElement(_advancedGasFeeInputSubtext.default, {
    latest: estimatedBaseFee,
    historical: historicalBaseFeeRange,
    trend: baseFeeTrend
  }));
};
var _default = exports.default = BaseFeeInput;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-inputs\\base-fee-input\\base-fee-input.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-inputs\\base-fee-input\\index.js", {"./base-fee-input":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-inputs\\base-fee-input\\base-fee-input.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cadvanced-gas-fee-popover%5Cadvanced-gas-fee-inputs%5Cbase-fee-input%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _baseFeeInput.default;
  }
});
var _baseFeeInput = _interopRequireDefault(require("./base-fee-input"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-inputs\\base-fee-input\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-inputs\\index.js", {"./advanced-gas-fee-inputs":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-inputs\\advanced-gas-fee-inputs.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cadvanced-gas-fee-popover%5Cadvanced-gas-fee-inputs%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _advancedGasFeeInputs.default;
  }
});
var _advancedGasFeeInputs = _interopRequireDefault(require("./advanced-gas-fee-inputs"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-inputs\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-inputs\\priority-fee-input\\index.js", {"./priority-fee-input":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-inputs\\priority-fee-input\\priority-fee-input.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cadvanced-gas-fee-popover%5Cadvanced-gas-fee-inputs%5Cpriority-fee-input%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _priorityFeeInput.default;
  }
});
var _priorityFeeInput = _interopRequireDefault(require("./priority-fee-input"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-inputs\\priority-fee-input\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-inputs\\priority-fee-input\\priority-fee-input.js", {"../../../../../../../shared/constants/gas":"D:\\code\\v\\metamask-extension\\shared\\constants\\gas.ts","../../../../../../../shared/modules/Numeric":"D:\\code\\v\\metamask-extension\\shared\\modules\\Numeric.ts","../../../../../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../../../../../components/ui/box":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\box\\index.js","../../../../../../components/ui/form-field":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\form-field\\index.js","../../../../../../contexts/gasFee":"D:\\code\\v\\metamask-extension\\ui\\contexts\\gasFee.js","../../../../../../helpers/constants/common":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\common.ts","../../../../../../hooks/useCurrencyDisplay":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useCurrencyDisplay.js","../../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../../../hooks/useUserPreferencedCurrency":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useUserPreferencedCurrency.js","../../../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../constants":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\constants\\index.ts","../../../../send-legacy/send.constants":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\send-legacy\\send.constants.js","../../advanced-gas-fee-input-subtext":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-input-subtext\\index.js","../../context":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\context\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cadvanced-gas-fee-popover%5Cadvanced-gas-fee-inputs%5Cpriority-fee-input%5Cpriority-fee-input.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _send = require("../../../../send-legacy/send.constants");
var _gas = require("../../../../../../../shared/constants/gas");
var _common = require("../../../../../../helpers/constants/common");
var _selectors = require("../../../../../../selectors");
var _useCurrencyDisplay = require("../../../../../../hooks/useCurrencyDisplay");
var _gasFee = require("../../../../../../contexts/gasFee");
var _useI18nContext = require("../../../../../../hooks/useI18nContext");
var _useUserPreferencedCurrency = require("../../../../../../hooks/useUserPreferencedCurrency");
var _formField = _interopRequireDefault(require("../../../../../../components/ui/form-field"));
var _box = _interopRequireDefault(require("../../../../../../components/ui/box"));
var _context = require("../../context");
var _advancedGasFeeInputSubtext = _interopRequireDefault(require("../../advanced-gas-fee-input-subtext"));
var _conversion = require("../../../../../../../shared/modules/conversion.utils");
var _Numeric = require("../../../../../../../shared/modules/Numeric");
var _constants = require("../../../../constants");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const validatePriorityFee = (value, gasFeeEstimates, chainId) => {
  const priorityFeeValue = new _Numeric.Numeric(value, 10);
  if (priorityFeeValue.lessThan(0, 10)) {
    return 'editGasMaxPriorityFeeBelowMinimumV2';
  }
  if (gasFeeEstimates !== null && gasFeeEstimates !== void 0 && gasFeeEstimates.low && priorityFeeValue.lessThan(gasFeeEstimates.low.suggestedMaxPriorityFeePerGas, 10) && _constants.IGNORE_GAS_LIMIT_CHAIN_IDS.includes(chainId)) {
    return 'editGasMaxPriorityFeeLowV2';
  }
  if (gasFeeEstimates !== null && gasFeeEstimates !== void 0 && gasFeeEstimates.high && priorityFeeValue.greaterThan(gasFeeEstimates.high.suggestedMaxPriorityFeePerGas * _send.HIGH_FEE_WARNING_MULTIPLIER, 10)) {
    return 'editGasMaxPriorityFeeHighV2';
  }
  return null;
};
const PriorityFeeInput = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  const advancedGasFeeValues = (0, _reactRedux.useSelector)(_selectors.getAdvancedGasFeeValues);
  const {
    gasLimit,
    setErrorValue,
    setMaxPriorityFeePerGas
  } = (0, _context.useAdvancedGasFeePopoverContext)();
  const {
    editGasMode,
    estimateUsed,
    gasFeeEstimates,
    maxPriorityFeePerGas: maxPriorityFeePerGasNumber,
    transaction: {
      chainId
    }
  } = (0, _gasFee.useGasFeeContext)();
  const maxPriorityFeePerGas = new _Numeric.Numeric(maxPriorityFeePerGasNumber, 10).toString();
  const {
    latestPriorityFeeRange,
    historicalPriorityFeeRange,
    priorityFeeTrend
  } = gasFeeEstimates ?? {};
  const [priorityFeeError, setPriorityFeeError] = (0, _react.useState)();
  const defaultPriorityFee = estimateUsed !== _gas.PriorityLevels.custom && advancedGasFeeValues !== null && advancedGasFeeValues !== void 0 && advancedGasFeeValues.priorityFee && editGasMode !== _gas.EditGasModes.swaps ? advancedGasFeeValues.priorityFee : maxPriorityFeePerGas;
  const [priorityFee, setPriorityFee] = (0, _react.useState)(defaultPriorityFee > 0 ? defaultPriorityFee : undefined);
  (0, _react.useEffect)(() => {
    if (priorityFee === undefined && defaultPriorityFee > 0) {
      setPriorityFee(defaultPriorityFee);
    }
  }, [priorityFee, defaultPriorityFee, setPriorityFee]);
  const {
    currency,
    numberOfDecimals
  } = (0, _useUserPreferencedCurrency.useUserPreferencedCurrency)(_common.PRIMARY);
  const [priorityFeeInPrimaryCurrency] = (0, _useCurrencyDisplay.useCurrencyDisplay)((0, _conversion.decGWEIToHexWEI)(priorityFee * gasLimit), {
    currency,
    numberOfDecimals
  });
  const updatePriorityFee = value => {
    setPriorityFee(value);
  };
  (0, _react.useEffect)(() => {
    setMaxPriorityFeePerGas(priorityFee);
    const error = validatePriorityFee(priorityFee, gasFeeEstimates, chainId);
    setErrorValue('maxPriorityFeePerGas', error === 'editGasMaxPriorityFeeBelowMinimumV2');
    setPriorityFeeError(error);
  }, [chainId, gasFeeEstimates, priorityFee, setErrorValue, setMaxPriorityFeePerGas, setPriorityFeeError]);
  return /*#__PURE__*/_react.default.createElement(_box.default, {
    marginTop: 4,
    marginLeft: 2,
    marginRight: 2,
    className: "priority-fee-input"
  }, /*#__PURE__*/_react.default.createElement(_formField.default, {
    dataTestId: "priority-fee-input",
    error: priorityFeeError ? t(priorityFeeError) : '',
    onChange: updatePriorityFee,
    titleText: t('priorityFeeProperCase'),
    titleUnit: `(${t('gwei')})`,
    tooltipText: t('advancedPriorityFeeToolTip'),
    value: priorityFee,
    detailText: `≈ ${priorityFeeInPrimaryCurrency}`,
    allowDecimals: true,
    numeric: true
  }), /*#__PURE__*/_react.default.createElement(_advancedGasFeeInputSubtext.default, {
    latest: latestPriorityFeeRange,
    historical: historicalPriorityFeeRange,
    trend: priorityFeeTrend
  }));
};
var _default = exports.default = PriorityFeeInput;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-inputs\\priority-fee-input\\priority-fee-input.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-popover.js", {"../../../../components/ui/box":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\box\\index.js","../../../../components/ui/popover":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\popover\\index.js","../../../../contexts/transaction-modal":"D:\\code\\v\\metamask-extension\\ui\\contexts\\transaction-modal.js","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","./advanced-gas-fee-defaults":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-defaults\\index.js","./advanced-gas-fee-gas-limit":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-gas-limit\\index.js","./advanced-gas-fee-inputs":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-inputs\\index.js","./advanced-gas-fee-save":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-save\\index.js","./context":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\context\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cadvanced-gas-fee-popover%5Cadvanced-gas-fee-popover.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _transactionModal = require("../../../../contexts/transaction-modal");
var _box = _interopRequireDefault(require("../../../../components/ui/box"));
var _popover = _interopRequireDefault(require("../../../../components/ui/popover"));
var _context = require("./context");
var _advancedGasFeeInputs = _interopRequireDefault(require("./advanced-gas-fee-inputs"));
var _advancedGasFeeGasLimit = _interopRequireDefault(require("./advanced-gas-fee-gas-limit"));
var _advancedGasFeeSave = _interopRequireDefault(require("./advanced-gas-fee-save"));
var _advancedGasFeeDefaults = _interopRequireDefault(require("./advanced-gas-fee-defaults"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const AdvancedGasFeePopover = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    closeAllModals,
    currentModal
  } = (0, _transactionModal.useTransactionModalContext)();
  if (currentModal !== 'advancedGasFee') {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_context.AdvancedGasFeePopoverContextProvider, null, /*#__PURE__*/_react.default.createElement(_popover.default, {
    className: "advanced-gas-fee-popover",
    title: t('advancedGasFeeModalTitle'),
    onClose: closeAllModals,
    footer: /*#__PURE__*/_react.default.createElement(_advancedGasFeeSave.default, null)
  }, /*#__PURE__*/_react.default.createElement(_box.default, {
    margin: 4
  }, /*#__PURE__*/_react.default.createElement(_advancedGasFeeInputs.default, null), /*#__PURE__*/_react.default.createElement(_advancedGasFeeDefaults.default, null), /*#__PURE__*/_react.default.createElement(_advancedGasFeeGasLimit.default, null))));
};
var _default = exports.default = AdvancedGasFeePopover;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-popover.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-save\\advanced-gas-fee-save.js", {"../../../../../../shared/constants/gas":"D:\\code\\v\\metamask-extension\\shared\\constants\\gas.ts","../../../../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../../contexts/gasFee":"D:\\code\\v\\metamask-extension\\ui\\contexts\\gasFee.js","../../../../../contexts/transaction-modal":"D:\\code\\v\\metamask-extension\\ui\\contexts\\transaction-modal.js","../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../hooks/useTransactionEventFragment":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useTransactionEventFragment.js","../context":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\context\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cadvanced-gas-fee-popover%5Cadvanced-gas-fee-save%5Cadvanced-gas-fee-save.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _gas = require("../../../../../../shared/constants/gas");
var _conversion = require("../../../../../../shared/modules/conversion.utils");
var _transactionModal = require("../../../../../contexts/transaction-modal");
var _gasFee = require("../../../../../contexts/gasFee");
var _useTransactionEventFragment = require("../../../hooks/useTransactionEventFragment");
var _useI18nContext = require("../../../../../hooks/useI18nContext");
var _componentLibrary = require("../../../../../components/component-library");
var _context = require("../context");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const AdvancedGasFeeSaveButton = () => {
  const {
    closeModal
  } = (0, _transactionModal.useTransactionModalContext)();
  const {
    updateTransactionEventFragment
  } = (0, _useTransactionEventFragment.useTransactionEventFragment)();
  const {
    updateTransaction
  } = (0, _gasFee.useGasFeeContext)();
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    gasLimit,
    hasErrors,
    maxFeePerGas,
    maxPriorityFeePerGas
  } = (0, _context.useAdvancedGasFeePopoverContext)();
  const onSave = () => {
    updateTransaction({
      estimateUsed: _gas.PriorityLevels.custom,
      maxFeePerGas: (0, _conversion.decGWEIToHexWEI)(maxFeePerGas),
      maxPriorityFeePerGas: (0, _conversion.decGWEIToHexWEI)(maxPriorityFeePerGas),
      gasLimit
    });
    updateTransactionEventFragment({
      properties: {
        gas_edit_type: 'advanced'
      }
    });
    closeModal(['advancedGasFee', 'editGasFee']);
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    variant: _componentLibrary.ButtonVariant.Primary,
    disabled: hasErrors,
    onClick: onSave,
    block: true
  }, t('save'));
};
var _default = exports.default = AdvancedGasFeeSaveButton;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-save\\advanced-gas-fee-save.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-save\\index.js", {"./advanced-gas-fee-save":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-save\\advanced-gas-fee-save.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cadvanced-gas-fee-popover%5Cadvanced-gas-fee-save%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _advancedGasFeeSave.default;
  }
});
var _advancedGasFeeSave = _interopRequireDefault(require("./advanced-gas-fee-save"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-save\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\context\\advancedGasFeePopover.js", {"prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cadvanced-gas-fee-popover%5Ccontext%5CadvancedGasFeePopover.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedGasFeePopoverContextProvider = exports.AdvancedGasFeePopoverContext = void 0;
exports.useAdvancedGasFeePopoverContext = useAdvancedGasFeePopoverContext;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AdvancedGasFeePopoverContext = exports.AdvancedGasFeePopoverContext = /*#__PURE__*/(0, _react.createContext)({});
const AdvancedGasFeePopoverContextProvider = ({
  children
}) => {
  const [gasLimit, setGasLimit] = (0, _react.useState)();
  const [maxFeePerGas, setMaxFeePerGas] = (0, _react.useState)();
  const [maxPriorityFeePerGas, setMaxPriorityFeePerGas] = (0, _react.useState)();
  const [errors, setErrors] = (0, _react.useState)({
    maxFeePerGas: false,
    maxPriorityFeePerGas: false,
    gasLimit: false
  });
  const setErrorValue = (0, _react.useCallback)((field, value) => {
    if (errors[field] !== value) {
      setErrors({
        ...errors,
        [field]: value
      });
    }
  }, [errors, setErrors]);
  const [maxBaseFee, setMaxBaseFee] = (0, _react.useState)();
  return /*#__PURE__*/_react.default.createElement(AdvancedGasFeePopoverContext.Provider, {
    value: {
      gasLimit,
      hasErrors: errors.maxFeePerGas || errors.maxPriorityFeePerGas || errors.gasLimit,
      gasErrors: errors,
      maxFeePerGas,
      maxPriorityFeePerGas,
      setErrorValue,
      maxBaseFee,
      setGasLimit,
      setMaxPriorityFeePerGas,
      setMaxFeePerGas,
      setMaxBaseFee
    }
  }, children);
};
exports.AdvancedGasFeePopoverContextProvider = AdvancedGasFeePopoverContextProvider;
function useAdvancedGasFeePopoverContext() {
  return (0, _react.useContext)(AdvancedGasFeePopoverContext);
}
AdvancedGasFeePopoverContextProvider.propTypes = {
  children: _propTypes.default.node.isRequired
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\context\\advancedGasFeePopover.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\context\\index.js", {"./advancedGasFeePopover":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\context\\advancedGasFeePopover.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cadvanced-gas-fee-popover%5Ccontext%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _advancedGasFeePopover = require("./advancedGasFeePopover");
Object.keys(_advancedGasFeePopover).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _advancedGasFeePopover[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _advancedGasFeePopover[key];
    }
  });
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\context\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\index.js", {"./advanced-gas-fee-popover":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\advanced-gas-fee-popover.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cadvanced-gas-fee-popover%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _advancedGasFeePopover.default;
  }
});
var _advancedGasFeePopover = _interopRequireDefault(require("./advanced-gas-fee-popover"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\advanced-gas-fee-popover\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\blockaid-loading-indicator\\blockaid-loading-indicator.tsx", {"../../../../../../shared/constants/security-provider":"D:\\code\\v\\metamask-extension\\shared\\constants\\security-provider.ts","../../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../../components/ui/icon/preloader":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\icon\\preloader\\index.js","../../../hooks/useCurrentSignatureSecurityAlertResponse":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useCurrentSignatureSecurityAlertResponse.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cblockaid-loading-indicator%5Cblockaid-loading-indicator.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _preloader = _interopRequireDefault(require("../../../../../components/ui/icon/preloader"));
var _securityProvider = require("../../../../../../shared/constants/security-provider");
var _componentLibrary = require("../../../../../components/component-library");
var _useCurrentSignatureSecurityAlertResponse = _interopRequireDefault(require("../../../hooks/useCurrentSignatureSecurityAlertResponse"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const BlockaidLoadingIndicator = () => {
  const signatureSecurityAlertResponse = (0, _useCurrentSignatureSecurityAlertResponse.default)();
  if ((signatureSecurityAlertResponse === null || signatureSecurityAlertResponse === void 0 ? void 0 : signatureSecurityAlertResponse.result_type) !== _securityProvider.BlockaidResultType.Loading) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginInline: 'auto',
    marginTop: 4
  }, /*#__PURE__*/_react.default.createElement(_preloader.default, {
    size: 18
  }));
};
var _default = exports.default = BlockaidLoadingIndicator;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\blockaid-loading-indicator\\blockaid-loading-indicator.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\blockaid-loading-indicator\\index.ts", {"./blockaid-loading-indicator":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\blockaid-loading-indicator\\blockaid-loading-indicator.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cblockaid-loading-indicator%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "BlockaidLoadingIndicator", {
  enumerable: true,
  get: function () {
    return _blockaidLoadingIndicator.default;
  }
});
var _blockaidLoadingIndicator = _interopRequireDefault(require("./blockaid-loading-indicator"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\blockaid-loading-indicator\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\confirm-alerts\\confirm-alerts.tsx", {"../../../../../components/app/alert-system/contexts/alertActionHandler":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\alert-system\\contexts\\alertActionHandler.tsx","../../../../../components/app/alert-system/contexts/alertMetricsContext":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\alert-system\\contexts\\alertMetricsContext.tsx","../../../hooks/setConfirmationAlerts":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\setConfirmationAlerts.ts","../../../hooks/useConfirmationAlertActions":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useConfirmationAlertActions.ts","../../../hooks/useConfirmationAlertMetrics":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useConfirmationAlertMetrics.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cconfirm-alerts%5Cconfirm-alerts.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _alertActionHandler = require("../../../../../components/app/alert-system/contexts/alertActionHandler");
var _useConfirmationAlertActions = _interopRequireDefault(require("../../../hooks/useConfirmationAlertActions"));
var _setConfirmationAlerts = _interopRequireDefault(require("../../../hooks/setConfirmationAlerts"));
var _alertMetricsContext = require("../../../../../components/app/alert-system/contexts/alertMetricsContext");
var _useConfirmationAlertMetrics = require("../../../hooks/useConfirmationAlertMetrics");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const ConfirmAlerts = ({
  children
}) => {
  const {
    trackAlertActionClicked,
    trackAlertRender,
    trackInlineAlertClicked
  } = (0, _useConfirmationAlertMetrics.useConfirmationAlertMetrics)();
  const processAction = (0, _useConfirmationAlertActions.default)();
  (0, _setConfirmationAlerts.default)();
  return /*#__PURE__*/_react.default.createElement(_alertMetricsContext.AlertMetricsProvider, {
    metrics: {
      trackAlertActionClicked,
      trackAlertRender,
      trackInlineAlertClicked
    }
  }, /*#__PURE__*/_react.default.createElement(_alertActionHandler.AlertActionHandlerProvider, {
    onProcessAction: processAction
  }, children));
};
var _default = exports.default = ConfirmAlerts;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\confirm-alerts\\confirm-alerts.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\confirm-alerts\\index.tsx", {"./confirm-alerts":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\confirm-alerts\\confirm-alerts.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cconfirm-alerts%5Cindex.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ConfirmAlerts", {
  enumerable: true,
  get: function () {
    return _confirmAlerts.default;
  }
});
var _confirmAlerts = _interopRequireDefault(require("./confirm-alerts"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\confirm-alerts\\index.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\footer\\footer.tsx", {"../../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../../../shared/lib/confirmation.utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\confirmation.utils.ts","../../../../../components/app/alert-system/confirm-alert-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\alert-system\\confirm-alert-modal\\index.tsx","../../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../../components/multichain/pages/page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\index.ts","../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../hooks/useAlerts":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAlerts.ts","../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","../../../hooks/gas/useIsGaslessLoading":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\gas\\useIsGaslessLoading.ts","../../../hooks/transactions/useEnableShieldCoverageChecks":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\transactions\\useEnableShieldCoverageChecks.ts","../../../hooks/transactions/useTransactionConfirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\transactions\\useTransactionConfirm.ts","../../../hooks/useConfirmActions":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useConfirmActions.ts","../../../hooks/useOriginThrottling":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useOriginThrottling.ts","../../../utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\utils\\index.ts","../utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\utils.ts","./origin-throttle-modal":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\footer\\origin-throttle-modal.tsx","./shield-footer-agreement":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\footer\\shield-footer-agreement.tsx","./shield-footer-coverage-indicator/shield-footer-coverage-indicator":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\footer\\shield-footer-coverage-indicator\\shield-footer-coverage-indicator.tsx","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cfooter%5Cfooter.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _transactionController = require("@metamask/transaction-controller");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _metametrics = require("../../../../../../shared/constants/metametrics");
var _confirmation = require("../../../../../../shared/lib/confirmation.utils");
var _confirmAlertModal = require("../../../../../components/app/alert-system/confirm-alert-modal");
var _componentLibrary = require("../../../../../components/component-library");
var _page = require("../../../../../components/multichain/pages/page");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _useAlerts = _interopRequireDefault(require("../../../../../hooks/useAlerts"));
var _useI18nContext = require("../../../../../hooks/useI18nContext");
var _selectors = require("../../../../../selectors");
var _actions = require("../../../../../store/actions");
var _confirm = require("../../../context/confirm");
var _useIsGaslessLoading = require("../../../hooks/gas/useIsGaslessLoading");
var _useEnableShieldCoverageChecks = require("../../../hooks/transactions/useEnableShieldCoverageChecks");
var _useTransactionConfirm = require("../../../hooks/transactions/useTransactionConfirm");
var _useConfirmActions = require("../../../hooks/useConfirmActions");
var _useOriginThrottling = require("../../../hooks/useOriginThrottling");
var _utils = require("../../../utils");
var _utils2 = require("../utils");
var _originThrottleModal = _interopRequireDefault(require("./origin-throttle-modal"));
var _shieldFooterAgreement = _interopRequireDefault(require("./shield-footer-agreement"));
var _shieldFooterCoverageIndicator = _interopRequireDefault(require("./shield-footer-coverage-indicator/shield-footer-coverage-indicator"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function reviewAlertButtonText(unconfirmedDangerAlerts, t) {
  if (unconfirmedDangerAlerts.length === 1) {
    return t('reviewAlert');
  }
  if (unconfirmedDangerAlerts.length > 1) {
    return t('reviewAlerts');
  }
  return t('confirm');
}
function getButtonDisabledState(hasUnconfirmedDangerAlerts, hasBlockingAlerts, disabled) {
  if (hasBlockingAlerts) {
    return true;
  }
  if (hasUnconfirmedDangerAlerts) {
    return false;
  }
  return disabled;
}
const ConfirmButton = ({
  alertOwnerId = '',
  disabled,
  onSubmit,
  onCancel
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const [confirmModalVisible, setConfirmModalVisible] = (0, _react.useState)(false);
  const {
    alerts,
    hasDangerAlerts,
    hasUnconfirmedDangerAlerts,
    hasUnconfirmedFieldDangerAlerts,
    unconfirmedFieldDangerAlerts
  } = (0, _useAlerts.default)(alertOwnerId);
  const hasDangerBlockingAlerts = alerts.some(alert => alert.severity === _designSystem.Severity.Danger && alert.isBlocking);
  const handleCloseConfirmModal = (0, _react.useCallback)(() => {
    setConfirmModalVisible(false);
  }, []);
  const handleOpenConfirmModal = (0, _react.useCallback)(() => {
    setConfirmModalVisible(true);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, confirmModalVisible && /*#__PURE__*/_react.default.createElement(_confirmAlertModal.ConfirmAlertModal, {
    ownerId: alertOwnerId,
    onClose: handleCloseConfirmModal,
    onCancel: onCancel,
    onSubmit: onSubmit
  }), hasDangerAlerts ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    block: true,
    danger: true,
    "data-testid": "confirm-footer-button",
    disabled: getButtonDisabledState(hasUnconfirmedDangerAlerts, hasDangerBlockingAlerts, disabled),
    onClick: handleOpenConfirmModal,
    size: _componentLibrary.ButtonSize.Lg,
    startIconName: hasUnconfirmedFieldDangerAlerts ? _componentLibrary.IconName.SecuritySearch : _componentLibrary.IconName.Danger
  }, reviewAlertButtonText(unconfirmedFieldDangerAlerts, t)) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    block: true,
    "data-testid": "confirm-footer-button",
    disabled: disabled,
    onClick: onSubmit,
    size: _componentLibrary.ButtonSize.Lg
  }, Boolean(currentConfirmation === null || currentConfirmation === void 0 ? void 0 : currentConfirmation.offlineSign) ? t('sign') : (currentConfirmation === null || currentConfirmation === void 0 ? void 0 : currentConfirmation.type) === _transactionController.TransactionType.shieldSubscriptionApprove ? t('shieldStartNowCTA') : t('confirm')));
};
const CancelButton = ({
  handleFooterCancel
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  if ((currentConfirmation === null || currentConfirmation === void 0 ? void 0 : currentConfirmation.type) === _transactionController.TransactionType.shieldSubscriptionApprove) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    block: true,
    "data-testid": "confirm-footer-cancel-button",
    onClick: handleFooterCancel,
    size: _componentLibrary.ButtonSize.Lg,
    variant: _componentLibrary.ButtonVariant.Secondary
  }, t('cancel'));
};
const Footer = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    onTransactionConfirm
  } = (0, _useTransactionConfirm.useTransactionConfirm)();
  const {
    currentConfirmation,
    isScrollToBottomCompleted
  } = (0, _confirm.useConfirmContext)();
  const isOfflineSign = Boolean(currentConfirmation === null || currentConfirmation === void 0 ? void 0 : currentConfirmation.offlineSign);
  const {
    isGaslessLoading
  } = (0, _useIsGaslessLoading.useIsGaslessLoading)();
  const {
    from
  } = (0, _utils2.getConfirmationSender)(currentConfirmation);
  const {
    shouldThrottleOrigin
  } = (0, _useOriginThrottling.useOriginThrottling)();
  const [showOriginThrottleModal, setShowOriginThrottleModal] = (0, _react.useState)(false);
  const {
    onCancel,
    resetTransactionState
  } = (0, _useConfirmActions.useConfirmActions)();
  const hardwareWalletRequiresConnection = (0, _reactRedux.useSelector)(state => {
    if (from) {
      const inE2e = false && "undefined" === 'undefined';
      return inE2e ? false : (0, _selectors.doesAddressRequireLedgerHidConnection)(state, from);
    }
    return false;
  });
  const isSignature = (0, _utils.isSignatureTransactionType)(currentConfirmation);
  const isConfirmDisabled = !isScrollToBottomCompleted && !isSignature || hardwareWalletRequiresConnection || isGaslessLoading;
  const onSubmit = (0, _react.useCallback)(() => {
    if (!currentConfirmation) {
      return;
    }
    const isTransactionConfirmation = (0, _confirmation.isCorrectDeveloperTransactionType)(currentConfirmation === null || currentConfirmation === void 0 ? void 0 : currentConfirmation.type);
    if (isTransactionConfirmation) {
      onTransactionConfirm();
    } else {
      dispatch((0, _actions.resolvePendingApproval)(currentConfirmation.id, undefined));
    }
    resetTransactionState();
    if (isOfflineSign) {
      dispatch(_actions.closeCurrentNotificationWindow === null || _actions.closeCurrentNotificationWindow === void 0 ? void 0 : (0, _actions.closeCurrentNotificationWindow)());
    }
  }, [currentConfirmation, dispatch, onTransactionConfirm, resetTransactionState, isOfflineSign]);
  const handleFooterCancel = (0, _react.useCallback)(() => {
    if (shouldThrottleOrigin) {
      setShowOriginThrottleModal(true);
      return;
    }
    onCancel({
      location: _metametrics.MetaMetricsEventLocation.Confirmation
    });
  }, [onCancel, shouldThrottleOrigin]);
  const isShowShieldFooterCoverageIndicator = (0, _useEnableShieldCoverageChecks.useEnableShieldCoverageChecks)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shieldFooterCoverageIndicator.default, null), /*#__PURE__*/_react.default.createElement(_page.Footer, {
    className: "confirm-footer_page-footer",
    flexDirection: _designSystem.FlexDirection.Column
    // box shadow to match the original var(--shadow-size-md) on the footer,
    // but only applied to the bottom of the box, so it doesn't overlap with
    // the shield footer coverage indicator
    ,
    style: isShowShieldFooterCoverageIndicator ? {
      boxShadow: '0 4px 16px -8px var(--color-shadow-default)'
    } : undefined
  }, /*#__PURE__*/_react.default.createElement(_originThrottleModal.default, {
    isOpen: showOriginThrottleModal,
    onConfirmationCancel: onCancel
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(CancelButton, {
    handleFooterCancel: handleFooterCancel
  }), /*#__PURE__*/_react.default.createElement(ConfirmButton, {
    alertOwnerId: currentConfirmation === null || currentConfirmation === void 0 ? void 0 : currentConfirmation.id,
    onSubmit: onSubmit,
    disabled: isConfirmDisabled,
    onCancel: onCancel
  })), /*#__PURE__*/_react.default.createElement(_shieldFooterAgreement.default, null)));
};
var _default = exports.default = Footer;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\footer\\footer.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\footer\\index.tsx", {"./footer":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\footer\\footer.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cfooter%5Cindex.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "Footer", {
  enumerable: true,
  get: function () {
    return _footer.default;
  }
});
var _footer = _interopRequireDefault(require("./footer"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\footer\\index.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\footer\\origin-throttle-modal.tsx", {"../../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../../components/ui/origin-pill/origin-pill":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\origin-pill\\origin-pill.tsx","../../../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../hooks/useModalProps":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useModalProps.ts","../../../hooks/useOriginThrottling":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useOriginThrottling.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cfooter%5Corigin-throttle-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = OriginThrottleModal;
var _react = _interopRequireWildcard(require("react"));
var _useModalProps = require("../../../../../hooks/useModalProps");
var _componentLibrary = require("../../../../../components/component-library");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _i18n = require("../../../../../contexts/i18n");
var _useOriginThrottling = require("../../../hooks/useOriginThrottling");
var _originPill = _interopRequireDefault(require("../../../../../components/ui/origin-pill/origin-pill"));
var _metametrics = require("../../../../../../shared/constants/metametrics");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MultipleRequestContent = ({
  onConfirmationCancel,
  setIsTemporaryBlock
}) => {
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const {
    origin,
    resetOrigin
  } = (0, _useOriginThrottling.useOriginThrottling)();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, {
    size: _componentLibrary.ModalContentSize.Md
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    justifyContent: _designSystem.JustifyContent.center,
    display: _designSystem.Display.Flex,
    marginBottom: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.Warning,
    size: _componentLibrary.IconSize.Xl,
    color: _designSystem.IconColor.warningDefault
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    endAccessory: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null)
  }, t('spamModalTitle')), /*#__PURE__*/_react.default.createElement(_originPill.default, {
    style: {
      marginTop: 0,
      marginBottom: 20
    },
    origin: origin,
    dataTestId: "origin-pill"
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    textAlign: _designSystem.TextAlign.Center,
    as: "p",
    "data-testid": "confirmation-text"
  }, t('spamModalDescription'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalFooter, {
    paddingTop: 4,
    onSubmit: () => {
      // Order of operations is important here to ensure the origin is reset after the confirmation is cancelled
      onConfirmationCancel({
        location: _metametrics.MetaMetricsEventLocation.OriginThrottleModal
      });
      resetOrigin();
    },
    onCancel: () => {
      setIsTemporaryBlock(true);
    },
    containerProps: {
      alignItems: _designSystem.AlignItems.stretch,
      flexDirection: _designSystem.FlexDirection.Column
    },
    submitButtonProps: {
      children: t('cancel'),
      size: _componentLibrary.ButtonSize.Lg
    },
    cancelButtonProps: {
      children: t('spamModalTemporaryBlockButton'),
      size: _componentLibrary.ButtonSize.Lg
    }
  }));
};
const OriginBlockedContent = ({
  onConfirmationCancel
}) => {
  const t = (0, _react.useContext)(_i18n.I18nContext);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, {
    size: _componentLibrary.ModalContentSize.Md
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    justifyContent: _designSystem.JustifyContent.center,
    display: _designSystem.Display.Flex,
    marginBottom: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.Confirmation,
    size: _componentLibrary.IconSize.Xl,
    color: _designSystem.IconColor.successDefault
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    endAccessory: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null)
  }, t('spamModalBlockedTitle')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    textAlign: _designSystem.TextAlign.Center,
    as: "p",
    "data-testid": "confirmation-text"
  }, t('spamModalBlockedDescription'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalFooter, {
    paddingTop: 4,
    onSubmit: () => onConfirmationCancel({
      location: _metametrics.MetaMetricsEventLocation.OriginThrottleModal
    }),
    submitButtonProps: {
      children: t('gotIt'),
      size: _componentLibrary.ButtonSize.Lg
    }
  }));
};

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function OriginThrottleModal({
  isOpen,
  onConfirmationCancel
}) {
  const {
    hideModal
  } = (0, _useModalProps.useModalProps)();
  const [isTemporaryBlock, setIsTemporaryBlock] = (0, _react.useState)(false);
  const handleHideModal = () => {
    hideModal();
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: isOpen,
    onClose: handleHideModal,
    isClosedOnOutsideClick: false,
    isClosedOnEscapeKey: false
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, {
    "data-testid": "modal-overlay"
  }), isTemporaryBlock ? /*#__PURE__*/_react.default.createElement(OriginBlockedContent, {
    onConfirmationCancel: onConfirmationCancel
  }) : /*#__PURE__*/_react.default.createElement(MultipleRequestContent, {
    onConfirmationCancel: onConfirmationCancel,
    setIsTemporaryBlock: setIsTemporaryBlock
  }));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\footer\\origin-throttle-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\footer\\shield-footer-agreement.tsx", {"../../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cfooter%5Cshield-footer-agreement.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _transactionController = require("@metamask/transaction-controller");
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../../../../components/component-library");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../../hooks/useI18nContext");
var _confirm = require("../../../context/confirm");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: change to the correct URL
const SHIELD_TERMS_OF_USE_URL = 'https://consensys.io/terms-of-use';
const ShieldFooterAgreement = () => {
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const t = (0, _useI18nContext.useI18nContext)();
  if ((currentConfirmation === null || currentConfirmation === void 0 ? void 0 : currentConfirmation.type) !== _transactionController.TransactionType.shieldSubscriptionApprove) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative
  }, t('shieldFooterAgreement', [/*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    href: SHIELD_TERMS_OF_USE_URL,
    color: _designSystem.TextColor.textAlternative,
    size: _componentLibrary.ButtonLinkSize.Inherit,
    externalLink: true,
    key: "shield-footer-agreement-button"
  }, t('snapsTermsOfUse'))])));
};
var _default = exports.default = ShieldFooterAgreement;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\footer\\shield-footer-agreement.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\footer\\shield-footer-coverage-indicator\\shield-footer-coverage-indicator.tsx", {"../../../../../../components/app/confirm/info/row/alert-row/alert-row":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\alert-row\\alert-row.tsx","../../../../../../components/app/confirm/info/row/constants":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\constants.ts","../../../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","../../../../hooks/transactions/useEnableShieldCoverageChecks":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\transactions\\useEnableShieldCoverageChecks.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cfooter%5Cshield-footer-coverage-indicator%5Cshield-footer-coverage-indicator.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _alertRow = require("../../../../../../components/app/confirm/info/row/alert-row/alert-row");
var _constants = require("../../../../../../components/app/confirm/info/row/constants");
var _componentLibrary = require("../../../../../../components/component-library");
var _designSystem = require("../../../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../../../hooks/useI18nContext");
var _confirm = require("../../../../context/confirm");
var _useEnableShieldCoverageChecks = require("../../../../hooks/transactions/useEnableShieldCoverageChecks");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const ShieldFooterCoverageIndicator = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const isShowShieldFooterCoverageIndicator = (0, _useEnableShieldCoverageChecks.useEnableShieldCoverageChecks)();
  if (!isShowShieldFooterCoverageIndicator) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 4,
    paddingRight: 4
    // box shadow to match the original var(--shadow-size-md) on the footer,
    // but only applied to the top of the box, so it doesn't overlap with
    // the existing
    ,
    style: {
      boxShadow: '0 -4px 16px -8px var(--color-shadow-default)'
    }
  }, /*#__PURE__*/_react.default.createElement(_alertRow.ConfirmInfoAlertRow, {
    alertKey: _constants.RowAlertKey.ShieldFooterCoverageIndicator,
    ownerId: currentConfirmation.id,
    label: "",
    labelChildren: /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMdMedium,
      color: _designSystem.TextColor.inherit
    }, t('transactionShield')),
    style: {
      marginBottom: 0,
      alignItems: _designSystem.AlignItems.center
    },
    showAlertLoader: true
  }));
};
var _default = exports.default = ShieldFooterCoverageIndicator;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\footer\\shield-footer-coverage-indicator\\shield-footer-coverage-indicator.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\header\\advanced-details-button.tsx", {"../../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../../components/ui/tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\index.js","../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","../../../selectors/preferences":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\selectors\\preferences.ts","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cheader%5Cadvanced-details-button.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedDetailsButton = void 0;
var _transactionController = require("@metamask/transaction-controller");
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _componentLibrary = require("../../../../../components/component-library");
var _tooltip = _interopRequireDefault(require("../../../../../components/ui/tooltip"));
var _designSystem = require("../../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../../hooks/useI18nContext");
var _actions = require("../../../../../store/actions");
var _confirm = require("../../../context/confirm");
var _preferences = require("../../../selectors/preferences");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const AdvancedDetailsButton = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const showAdvancedDetails = (0, _reactRedux.useSelector)(_preferences.selectConfirmationAdvancedDetailsOpen);
  const setShowAdvancedDetails = value => {
    dispatch((0, _actions.setConfirmationAdvancedDetailsOpen)(value));
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    backgroundColor: showAdvancedDetails ? _designSystem.BackgroundColor.infoMuted : _designSystem.BackgroundColor.transparent,
    borderRadius: _designSystem.BorderRadius.MD,
    marginRight: 1
    // hiding through visibility instead of rendering conditionally so the
    // header layout is not affected
    ,
    style: (currentConfirmation === null || currentConfirmation === void 0 ? void 0 : currentConfirmation.type) === _transactionController.TransactionType.shieldSubscriptionApprove ? {
      visibility: 'hidden'
    } : {}
  }, /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    title: showAdvancedDetails ? t('hideAdvancedDetails') : t('showAdvancedDetails')
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    ariaLabel: "Advanced tx details",
    color: _designSystem.IconColor.iconDefault,
    iconName: _componentLibrary.IconName.Customize,
    "data-testid": "header-advanced-details-button",
    size: _componentLibrary.ButtonIconSize.Md,
    onClick: () => {
      setShowAdvancedDetails(!showAdvancedDetails);
    }
  })));
};
exports.AdvancedDetailsButton = AdvancedDetailsButton;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\header\\advanced-details-button.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\header\\dapp-initiated-header.tsx", {"../../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","./advanced-details-button":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\header\\advanced-details-button.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cheader%5Cdapp-initiated-header.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DAppInitiatedHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../../../../components/component-library");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../../hooks/useI18nContext");
var _advancedDetailsButton = require("./advanced-details-button");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const DAppInitiatedHeader = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.center,
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    paddingInline: 3,
    paddingTop: 4,
    paddingBottom: 4,
    style: {
      zIndex: 2,
      position: 'relative'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingSm,
    color: _designSystem.TextColor.inherit
  }, t('transferRequest')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingRight: 3,
    style: {
      marginLeft: 'auto',
      position: 'absolute',
      right: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_advancedDetailsButton.AdvancedDetailsButton, null)));
};
exports.DAppInitiatedHeader = DAppInitiatedHeader;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\header\\dapp-initiated-header.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\header\\header-info.tsx", {"../../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../../../shared/lib/confirmation.utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\confirmation.utils.ts","../../../../../components/app/confirm/info/row":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\index.ts","../../../../../components/app/confirm/info/row/currency":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\currency.tsx","../../../../../components/app/preferred-avatar":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\preferred-avatar\\index.ts","../../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../../components/multichain":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../../../../components/ui/tooltip/tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\tooltip.js","../../../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","../../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","../../../hooks/useBalance":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useBalance.js","../../../hooks/useConfirmationRecipientInfo":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useConfirmationRecipientInfo.ts","../../../utils/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\utils\\confirm.ts","./advanced-details-button":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\header\\advanced-details-button.tsx","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cheader%5Cheader-info.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _designSystemReact = require("@metamask/design-system-react");
var _metametrics = require("../../../../../../shared/constants/metametrics");
var _row = require("../../../../../components/app/confirm/info/row");
var _currency = require("../../../../../components/app/confirm/info/row/currency");
var _componentLibrary = require("../../../../../components/component-library");
var _multichain = require("../../../../../components/multichain");
var _tooltip = _interopRequireDefault(require("../../../../../components/ui/tooltip/tooltip"));
var _metametrics2 = require("../../../../../contexts/metametrics");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../../hooks/useI18nContext");
var _confirm = require("../../../context/confirm");
var _useBalance = require("../../../hooks/useBalance");
var _useConfirmationRecipientInfo = _interopRequireDefault(require("../../../hooks/useConfirmationRecipientInfo"));
var _confirm2 = require("../../../utils/confirm");
var _confirmation = require("../../../../../../shared/lib/confirmation.utils");
var _preferredAvatar = require("../../../../../components/app/preferred-avatar");
var _selectors = require("../../../../../selectors/selectors");
var _advancedDetailsButton = require("./advanced-details-button");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HeaderInfo = () => {
  var _msgParams;
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const hdEntropyIndex = (0, _reactRedux.useSelector)(_selectors.getHDEntropyIndex);
  const [showAccountInfo, setShowAccountInfo] = _react.default.useState(false);
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const {
    senderAddress: fromAddress,
    senderName: fromName,
    walletName,
    isBIP44,
    hasMoreThanOneWallet
  } = (0, _useConfirmationRecipientInfo.default)();
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    balance: balanceToUse
  } = (0, _useBalance.useBalance)(fromAddress);
  const isSignature = (0, _confirm2.isSignatureTransactionType)(currentConfirmation);
  const eventProps = isSignature ? {
    location: _metametrics.MetaMetricsEventLocation.SignatureConfirmation,
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
    // eslint-disable-next-line @typescript-eslint/naming-convention
    signature_type: currentConfirmation === null || currentConfirmation === void 0 || (_msgParams = currentConfirmation.msgParams) === null || _msgParams === void 0 ? void 0 : _msgParams.signatureMethod,
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
    // eslint-disable-next-line @typescript-eslint/naming-convention
    hd_entropy_index: hdEntropyIndex
  } : {
    location: _metametrics.MetaMetricsEventLocation.Transaction,
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
    // eslint-disable-next-line @typescript-eslint/naming-convention
    transaction_type: currentConfirmation === null || currentConfirmation === void 0 ? void 0 : currentConfirmation.type,
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
    // eslint-disable-next-line @typescript-eslint/naming-convention
    hd_entropy_index: hdEntropyIndex
  };
  function trackAccountModalOpened() {
    const event = {
      category: _metametrics.MetaMetricsEventCategory.Confirmations,
      event: _metametrics.MetaMetricsEventName.AccountDetailsOpened,
      properties: {
        action: 'Confirm Screen',
        ...eventProps
      }
    };
    trackEvent(event);
  }
  const isShowAdvancedDetailsToggle = (0, _confirmation.isCorrectDeveloperTransactionType)(currentConfirmation === null || currentConfirmation === void 0 ? void 0 : currentConfirmation.type);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.flexEnd,
    style: {
      alignSelf: 'flex-end'
    }
  }, /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    position: "bottom",
    title: t('accountDetails'),
    interactive: true
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    ariaLabel: t('accountDetails'),
    color: _designSystem.IconColor.iconDefault,
    iconName: _componentLibrary.IconName.Info,
    size: _componentLibrary.ButtonIconSize.Md,
    onClick: () => {
      trackAccountModalOpened();
      setShowAccountInfo(true);
    },
    "data-testid": "header-info__account-details-button"
  })), isShowAdvancedDetailsToggle && /*#__PURE__*/_react.default.createElement(_advancedDetailsButton.AdvancedDetailsButton, null)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: showAccountInfo,
    onClose: () => setShowAccountInfo(false),
    "data-testid": "account-details-modal",
    isClosedOnEscapeKey: false,
    isClosedOnOutsideClick: false
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center,
    style: {
      position: 'relative'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    style: {
      margin: '0 auto'
    },
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_preferredAvatar.PreferredAvatar, {
    address: fromAddress,
    size: _designSystemReact.AvatarAccountSize.Lg
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    fontWeight: _designSystem.FontWeight.Bold,
    variant: _designSystem.TextVariant.bodyMd,
    color: _designSystem.TextColor.textDefault,
    marginTop: 2,
    "data-testid": 'confirmation-account-details-modal__account-name'
  }, fromName), isBIP44 && hasMoreThanOneWallet && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative,
    marginTop: 1
  }, walletName)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    style: {
      position: 'absolute',
      right: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    ariaLabel: t('close'),
    iconName: _componentLibrary.IconName.Close,
    size: _componentLibrary.ButtonIconSize.Sm,
    className: "confirm_header__close-button",
    onClick: () => setShowAccountInfo(false),
    "data-testid": "confirmation-account-details-modal__close-button"
  })))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, null, /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRow, {
    label: "Account address"
  }, /*#__PURE__*/_react.default.createElement(_multichain.AddressCopyButton, {
    address: fromAddress,
    shorten: true
  })), /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRow, {
    label: "Balance"
  }, /*#__PURE__*/_react.default.createElement(_currency.ConfirmInfoRowCurrency, {
    value: balanceToUse ?? 0,
    "data-testid": "confirmation-account-details-modal__account-balance"
  }))))));
};
var _default = exports.default = HeaderInfo;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\header\\header-info.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\header\\header.tsx", {"../../../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../../../components/app/preferred-avatar":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\preferred-avatar\\index.ts","../../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../helpers/utils/accounts":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\accounts.js","../../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","../../../hooks/useConfirmationNetworkInfo":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useConfirmationNetworkInfo.ts","../../../hooks/useConfirmationRecipientInfo":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useConfirmationRecipientInfo.ts","./dapp-initiated-header":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\header\\dapp-initiated-header.tsx","./header-info":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\header\\header-info.tsx","./wallet-initiated-header":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\header\\wallet-initiated-header.tsx","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cheader%5Cheader.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _transactionController = require("@metamask/transaction-controller");
var _react = _interopRequireDefault(require("react"));
var _app = require("../../../../../../shared/constants/app");
var _componentLibrary = require("../../../../../components/component-library");
var _preferredAvatar = require("../../../../../components/app/preferred-avatar");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _accounts = require("../../../../../helpers/utils/accounts");
var _confirm = require("../../../context/confirm");
var _useConfirmationNetworkInfo = _interopRequireDefault(require("../../../hooks/useConfirmationNetworkInfo"));
var _useConfirmationRecipientInfo = _interopRequireDefault(require("../../../hooks/useConfirmationRecipientInfo"));
var _dappInitiatedHeader = require("./dapp-initiated-header");
var _headerInfo = _interopRequireDefault(require("./header-info"));
var _walletInitiatedHeader = require("./wallet-initiated-header");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const CONFIRMATIONS_WITH_ALT_HEADER = [_transactionController.TransactionType.simpleSend, _transactionController.TransactionType.shieldSubscriptionApprove, _transactionController.TransactionType.tokenMethodSafeTransferFrom, _transactionController.TransactionType.tokenMethodTransfer, _transactionController.TransactionType.tokenMethodTransferFrom];
const Header = () => {
  const {
    networkImageUrl,
    networkDisplayName
  } = (0, _useConfirmationNetworkInfo.default)();
  const {
    senderAddress: fromAddress,
    senderName: fromName,
    walletName,
    isBIP44,
    hasMoreThanOneWallet
  } = (0, _useConfirmationRecipientInfo.default)();
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  let secondaryText;
  if (isBIP44) {
    if (hasMoreThanOneWallet) {
      secondaryText = walletName;
    }
  } else {
    secondaryText = networkDisplayName;
  }
  const DefaultHeader = /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    className: "confirm_header__wrapper",
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    "data-testid": "confirm-header"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    alignItems: _designSystem.AlignItems.flexStart,
    display: _designSystem.Display.Flex,
    padding: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    marginTop: 2
  }, /*#__PURE__*/_react.default.createElement(_preferredAvatar.PreferredAvatar, {
    address: fromAddress
  }), !isBIP44 && /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
    src: networkImageUrl,
    name: networkDisplayName,
    size: _componentLibrary.AvatarNetworkSize.Xs,
    backgroundColor: (0, _accounts.getAvatarNetworkColor)(networkDisplayName),
    className: "confirm_header__avatar-network"
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginInlineStart: 4,
    marginTop: secondaryText ? 0 : 3
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textDefault,
    variant: _designSystem.TextVariant.bodyMdMedium,
    "data-testid": "header-account-name"
  }, fromName), secondaryText && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textAlternative,
    "data-testid": "header-network-display-name"
  }, secondaryText))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    alignItems: _designSystem.AlignItems.flexEnd,
    display: _designSystem.Display.Flex,
    padding: 4
  }, /*#__PURE__*/_react.default.createElement(_headerInfo.default, null)));

  // The new header includes only a heading, the advanced details toggle, and a
  // back button if it's a wallet initiated confirmation. The default header is
  // the original header for the redesigns and includes the sender and recipient
  // addresses as well.
  const isConfirmationWithNewHeader = (currentConfirmation === null || currentConfirmation === void 0 ? void 0 : currentConfirmation.type) && CONFIRMATIONS_WITH_ALT_HEADER.includes(currentConfirmation.type);
  const isWalletInitiated = (currentConfirmation === null || currentConfirmation === void 0 ? void 0 : currentConfirmation.origin) === _app.ORIGIN_METAMASK;
  if (isConfirmationWithNewHeader && isWalletInitiated) {
    return /*#__PURE__*/_react.default.createElement(_walletInitiatedHeader.WalletInitiatedHeader, null);
  } else if (isConfirmationWithNewHeader && !isWalletInitiated) {
    return /*#__PURE__*/_react.default.createElement(_dappInitiatedHeader.DAppInitiatedHeader, null);
  }
  return DefaultHeader;
};
var _default = exports.default = Header;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\header\\header.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\header\\index.tsx", {"./header":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\header\\header.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cheader%5Cindex.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "Header", {
  enumerable: true,
  get: function () {
    return _header.default;
  }
});
var _header = _interopRequireDefault(require("./header"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\header\\index.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\header\\wallet-initiated-header.tsx", {"../../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../../ducks/confirm-transaction/confirm-transaction.duck":"D:\\code\\v\\metamask-extension\\ui\\ducks\\confirm-transaction\\confirm-transaction.duck.js","../../../../../ducks/send":"D:\\code\\v\\metamask-extension\\ui\\ducks\\send\\index.js","../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","../../../hooks/useConfirmActions":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useConfirmActions.ts","../../../hooks/useRedesignedSendFlow":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useRedesignedSendFlow.ts","../../../utils/send":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\utils\\send.ts","./advanced-details-button":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\header\\advanced-details-button.tsx","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cheader%5Cwallet-initiated-header.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WalletInitiatedHeader = void 0;
var _transactionController = require("@metamask/transaction-controller");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _metametrics = require("../../../../../../shared/constants/metametrics");
var _transaction = require("../../../../../../shared/constants/transaction");
var _componentLibrary = require("../../../../../components/component-library");
var _confirmTransaction = require("../../../../../ducks/confirm-transaction/confirm-transaction.duck");
var _send = require("../../../../../ducks/send");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _routes = require("../../../../../helpers/constants/routes");
var _useI18nContext = require("../../../../../hooks/useI18nContext");
var _actions = require("../../../../../store/actions");
var _confirm = require("../../../context/confirm");
var _useConfirmActions = require("../../../hooks/useConfirmActions");
var _useRedesignedSendFlow = require("../../../hooks/useRedesignedSendFlow");
var _send2 = require("../../../utils/send");
var _advancedDetailsButton = require("./advanced-details-button");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WalletInitiatedHeader = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    enabled: isSendRedesignEnabled
  } = (0, _useRedesignedSendFlow.useRedesignedSendFlow)();
  const {
    onCancel
  } = (0, _useConfirmActions.useConfirmActions)();
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const navigate = (0, _reactRouterDomV5Compat.useNavigate)();
  const handleBackButtonClick = (0, _react.useCallback)(async () => {
    if (currentConfirmation.type === _transactionController.TransactionType.shieldSubscriptionApprove) {
      onCancel({
        location: _metametrics.MetaMetricsEventLocation.Confirmation
      });
      navigate(_routes.SHIELD_PLAN_ROUTE);
      return;
    }
    const {
      id
    } = currentConfirmation;
    const isNativeSend = currentConfirmation.type === _transactionController.TransactionType.simpleSend;
    const isERC20TokenSend = currentConfirmation.type === _transactionController.TransactionType.tokenMethodTransfer;
    const isNFTTokenSend = currentConfirmation.type === _transactionController.TransactionType.tokenMethodTransferFrom || currentConfirmation.type === _transactionController.TransactionType.tokenMethodSafeTransferFrom;
    if (isSendRedesignEnabled && (isNativeSend || isERC20TokenSend || isNFTTokenSend)) {
      onCancel({
        location: _metametrics.MetaMetricsEventLocation.Confirmation,
        navigateBackForSend: true
      });
      return;
    }
    let assetType;
    if (isNativeSend) {
      assetType = _transaction.AssetType.native;
    } else if (isERC20TokenSend) {
      assetType = _transaction.AssetType.token;
    } else if (isNFTTokenSend) {
      assetType = _transaction.AssetType.NFT;
    } else {
      assetType = _transaction.AssetType.unknown;
    }
    await dispatch((0, _send.editExistingTransaction)(assetType, id.toString()));
    dispatch((0, _confirmTransaction.clearConfirmTransaction)());
    dispatch((0, _actions.showSendTokenPage)());
    (0, _send2.navigateToSendRoute)(history, isSendRedesignEnabled);
  }, [currentConfirmation, dispatch, history, isSendRedesignEnabled, navigate, onCancel]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    alignItems: _designSystem.AlignItems.center,
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    paddingInline: 3,
    paddingTop: 4,
    paddingBottom: 4,
    style: {
      zIndex: 2
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    iconName: _componentLibrary.IconName.ArrowLeft,
    ariaLabel: t('back'),
    size: _componentLibrary.ButtonIconSize.Md
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    ,
    onClick: handleBackButtonClick,
    "data-testid": "wallet-initiated-header-back-button",
    color: _designSystem.IconColor.iconDefault
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingSm,
    color: _designSystem.TextColor.inherit
  }, currentConfirmation.type === _transactionController.TransactionType.shieldSubscriptionApprove ? t('shieldConfirmMembership') : t('review')), /*#__PURE__*/_react.default.createElement(_advancedDetailsButton.AdvancedDetailsButton, null));
};
exports.WalletInitiatedHeader = WalletInitiatedHeader;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\header\\wallet-initiated-header.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\approve\\approve-details\\approve-details.tsx", {"../../../../../../../components/app/confirm/info/row":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\index.ts","../../../../../../../components/app/confirm/info/row/section":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\section.tsx","../../../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","../../../../../hooks/useIsBIP44":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useIsBIP44.ts","../../../../../selectors/preferences":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\selectors\\preferences.ts","../../hooks/useTokenTransactionData":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useTokenTransactionData.ts","../../shared/network-row/network-row":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\shared\\network-row\\network-row.tsx","../../shared/sign-in-with-row/sign-in-with-row":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\shared\\sign-in-with-row\\sign-in-with-row.tsx","../../shared/transaction-details/transaction-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\shared\\transaction-details\\transaction-details.tsx","../../utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\utils.ts","../hooks/use-is-nft":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\approve\\hooks\\use-is-nft.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Capprove%5Capprove-details%5Capprove-details.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApproveDetails = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _row = require("../../../../../../../components/app/confirm/info/row");
var _section = require("../../../../../../../components/app/confirm/info/row/section");
var _useI18nContext = require("../../../../../../../hooks/useI18nContext");
var _confirm = require("../../../../../context/confirm");
var _preferences = require("../../../../../selectors/preferences");
var _signInWithRow = require("../../shared/sign-in-with-row/sign-in-with-row");
var _transactionDetails = require("../../shared/transaction-details/transaction-details");
var _utils = require("../../utils");
var _useIsNft = require("../hooks/use-is-nft");
var _useTokenTransactionData = require("../../hooks/useTokenTransactionData");
var _networkRow = require("../../shared/network-row/network-row");
var _useIsBIP = require("../../../../../hooks/useIsBIP44");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const Spender = ({
  isSetApprovalForAll = false
}) => {
  var _parsedTransactionDat, _parsedTransactionDat2, _parsedTransactionDat3;
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    currentConfirmation: transactionMeta
  } = (0, _confirm.useConfirmContext)();
  const {
    isNFT
  } = (0, _useIsNft.useIsNFT)(transactionMeta);
  const parsedTransactionData = (0, _useTokenTransactionData.useTokenTransactionData)();
  if (!parsedTransactionData) {
    return null;
  }
  const spender = ((_parsedTransactionDat = parsedTransactionData.args) === null || _parsedTransactionDat === void 0 ? void 0 : _parsedTransactionDat._spender) ?? (// ERC-20 - approve
  (_parsedTransactionDat2 = parsedTransactionData.args) === null || _parsedTransactionDat2 === void 0 ? void 0 : _parsedTransactionDat2._operator) ?? (// ERC-721 - setApprovalForAll
  (_parsedTransactionDat3 = parsedTransactionData.args) === null || _parsedTransactionDat3 === void 0 ? void 0 : _parsedTransactionDat3.spender); //  Fiat Token V2 - increaseAllowance

  const {
    chainId
  } = transactionMeta;
  if ((0, _utils.getIsRevokeSetApprovalForAll)(parsedTransactionData)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRow, {
    label: t(isSetApprovalForAll ? 'permissionFor' : 'spender'),
    tooltip: t(isNFT ? 'spenderTooltipDesc' : 'spenderTooltipERC20ApproveDesc'),
    "data-testid": "confirmation__approve-spender"
  }, /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRowAddress, {
    address: spender,
    chainId: chainId
  })), /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRowDivider, null));
};
const ApproveDetails = ({
  isSetApprovalForAll = false
}) => {
  const showAdvancedDetails = (0, _reactRedux.useSelector)(_preferences.selectConfirmationAdvancedDetailsOpen);
  const isBIP44 = (0, _useIsBIP.useIsBIP44)();
  return /*#__PURE__*/_react.default.createElement(_section.ConfirmInfoSection, {
    "data-testid": "confirmation__approve-details"
  }, /*#__PURE__*/_react.default.createElement(Spender, {
    isSetApprovalForAll: isSetApprovalForAll
  }), /*#__PURE__*/_react.default.createElement(_networkRow.NetworkRow, {
    isShownWithAlertsOnly: !isBIP44
  }), /*#__PURE__*/_react.default.createElement(_transactionDetails.OriginRow, null), /*#__PURE__*/_react.default.createElement(_signInWithRow.SigningInWithRow, null), showAdvancedDetails && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_transactionDetails.RecipientRow, null), /*#__PURE__*/_react.default.createElement(_transactionDetails.MethodDataRow, null)));
};
exports.ApproveDetails = ApproveDetails;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\approve\\approve-details\\approve-details.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\approve\\approve-static-simulation\\approve-static-simulation.tsx", {"../../../../../../../components/app/confirm/info/row":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\index.ts","../../../../../../../components/app/name":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\name\\index.ts","../../../../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../../../../components/ui/tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\index.js","../../../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","../../../../../hooks/useAssetDetails":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useAssetDetails.js","../../shared/static-simulation/static-simulation":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\shared\\static-simulation\\static-simulation.tsx","../../shared/transaction-data/transaction-data":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\shared\\transaction-data\\transaction-data.tsx","../hooks/use-approve-token-simulation":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\approve\\hooks\\use-approve-token-simulation.ts","../hooks/use-is-nft":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\approve\\hooks\\use-is-nft.ts","@metamask/name-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\name-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Capprove%5Capprove-static-simulation%5Capprove-static-simulation.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApproveStaticSimulation = void 0;
var _nameController = require("@metamask/name-controller");
var _react = _interopRequireDefault(require("react"));
var _row = require("../../../../../../../components/app/confirm/info/row");
var _name = _interopRequireDefault(require("../../../../../../../components/app/name"));
var _componentLibrary = require("../../../../../../../components/component-library");
var _tooltip = _interopRequireDefault(require("../../../../../../../components/ui/tooltip"));
var _designSystem = require("../../../../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../../../../hooks/useI18nContext");
var _confirm = require("../../../../../context/confirm");
var _useAssetDetails = require("../../../../../hooks/useAssetDetails");
var _staticSimulation = _interopRequireDefault(require("../../shared/static-simulation/static-simulation"));
var _transactionData = require("../../shared/transaction-data/transaction-data");
var _useApproveTokenSimulation = require("../hooks/use-approve-token-simulation");
var _useIsNft = require("../hooks/use-is-nft");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const ApproveStaticSimulation = ({
  setIsOpenEditSpendingCapModal
}) => {
  var _transactionMeta$txPa, _transactionMeta$txPa2, _transactionMeta$txPa3;
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    currentConfirmation: transactionMeta
  } = (0, _confirm.useConfirmContext)();
  const {
    decimals
  } = (0, _useAssetDetails.useAssetDetails)(transactionMeta === null || transactionMeta === void 0 || (_transactionMeta$txPa = transactionMeta.txParams) === null || _transactionMeta$txPa === void 0 ? void 0 : _transactionMeta$txPa.to, transactionMeta === null || transactionMeta === void 0 || (_transactionMeta$txPa2 = transactionMeta.txParams) === null || _transactionMeta$txPa2 === void 0 ? void 0 : _transactionMeta$txPa2.from, transactionMeta === null || transactionMeta === void 0 || (_transactionMeta$txPa3 = transactionMeta.txParams) === null || _transactionMeta$txPa3 === void 0 ? void 0 : _transactionMeta$txPa3.data, transactionMeta === null || transactionMeta === void 0 ? void 0 : transactionMeta.chainId);
  const {
    spendingCap,
    isUnlimitedSpendingCap,
    formattedSpendingCap,
    value,
    pending
  } = (0, _useApproveTokenSimulation.useApproveTokenSimulation)(transactionMeta, decimals);
  const {
    isNFT
  } = (0, _useIsNft.useIsNFT)(transactionMeta);
  if (pending) {
    return /*#__PURE__*/_react.default.createElement(_transactionData.Container, {
      isLoading: true
    });
  }
  if (!value) {
    return null;
  }
  const {
    chainId
  } = transactionMeta;
  const formattedTokenText = /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    "data-testid": "simulation-token-value",
    backgroundColor: _designSystem.BackgroundColor.backgroundAlternative,
    borderRadius: _designSystem.BorderRadius.XL,
    paddingInline: 2,
    textAlign: _designSystem.TextAlign.Center,
    alignItems: _designSystem.AlignItems.center
  }, isUnlimitedSpendingCap ? t('unlimited') : formattedSpendingCap);
  const SpendingCapRow = /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRow, {
    label: t(isNFT ? 'simulationApproveHeading' : 'spendingCap')
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    style: {
      marginLeft: 'auto',
      maxWidth: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center
  }, !isNFT && /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    color: _designSystem.IconColor.primaryDefault,
    ariaLabel: t('edit'),
    iconName: _componentLibrary.IconName.Edit,
    onClick: () => setIsOpenEditSpendingCapModal(true),
    size: _componentLibrary.ButtonIconSize.Sm,
    "data-testid": "edit-spending-cap-icon"
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Inline,
    marginInlineEnd: 1,
    minWidth: _designSystem.BlockSize.Zero
  }, Boolean(isUnlimitedSpendingCap) || spendingCap !== formattedSpendingCap ? /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    title: spendingCap
  }, formattedTokenText) : formattedTokenText), /*#__PURE__*/_react.default.createElement(_name.default, {
    value: transactionMeta.txParams.to,
    type: _nameController.NameType.ETHEREUM_ADDRESS,
    preferContractSymbol: true,
    variation: chainId
  }))));
  const simulationElements = SpendingCapRow;
  return /*#__PURE__*/_react.default.createElement(_staticSimulation.default, {
    title: t('simulationDetailsTitle'),
    titleTooltip: t('simulationDetailsTitleTooltip'),
    description: t(isNFT ? 'simulationDetailsApproveDesc' : 'simulationDetailsERC20ApproveDesc'),
    simulationElements: simulationElements
  });
};
exports.ApproveStaticSimulation = ApproveStaticSimulation;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\approve\\approve-static-simulation\\approve-static-simulation.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\approve\\approve.tsx", {"../../../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","../../../../hooks/useAssetDetails":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useAssetDetails.js","../shared/advanced-details/advanced-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\shared\\advanced-details\\advanced-details.tsx","../shared/confirm-loader/confirm-loader":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\shared\\confirm-loader\\confirm-loader.tsx","../shared/gas-fees-section/gas-fees-section":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\shared\\gas-fees-section\\gas-fees-section.tsx","./approve-details/approve-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\approve\\approve-details\\approve-details.tsx","./approve-static-simulation/approve-static-simulation":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\approve\\approve-static-simulation\\approve-static-simulation.tsx","./edit-spending-cap-modal/edit-spending-cap-modal":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\approve\\edit-spending-cap-modal\\edit-spending-cap-modal.tsx","./hooks/use-approve-token-simulation":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\approve\\hooks\\use-approve-token-simulation.ts","./hooks/use-is-nft":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\approve\\hooks\\use-is-nft.ts","./revoke-details/revoke-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\approve\\revoke-details\\revoke-details.tsx","./revoke-static-simulation/revoke-static-simulation":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\approve\\revoke-static-simulation\\revoke-static-simulation.tsx","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Capprove%5Capprove.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _transactionController = require("@metamask/transaction-controller");
var _react = _interopRequireWildcard(require("react"));
var _confirm = require("../../../../context/confirm");
var _useAssetDetails = require("../../../../hooks/useAssetDetails");
var _advancedDetails = require("../shared/advanced-details/advanced-details");
var _confirmLoader = require("../shared/confirm-loader/confirm-loader");
var _gasFeesSection = require("../shared/gas-fees-section/gas-fees-section");
var _approveDetails = require("./approve-details/approve-details");
var _approveStaticSimulation = require("./approve-static-simulation/approve-static-simulation");
var _editSpendingCapModal = require("./edit-spending-cap-modal/edit-spending-cap-modal");
var _useApproveTokenSimulation = require("./hooks/use-approve-token-simulation");
var _useIsNft = require("./hooks/use-is-nft");
var _revokeDetails = require("./revoke-details/revoke-details");
var _revokeStaticSimulation = require("./revoke-static-simulation/revoke-static-simulation");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ApproveInfo = () => {
  const {
    currentConfirmation: transactionMeta
  } = (0, _confirm.useConfirmContext)();
  const {
    isNFT
  } = (0, _useIsNft.useIsNFT)(transactionMeta);
  const [isOpenEditSpendingCapModal, setIsOpenEditSpendingCapModal] = (0, _react.useState)(false);
  const {
    decimals
  } = (0, _useAssetDetails.useAssetDetails)(transactionMeta.txParams.to, transactionMeta.txParams.from, transactionMeta.txParams.data, transactionMeta.chainId);
  const {
    spendingCap,
    pending
  } = (0, _useApproveTokenSimulation.useApproveTokenSimulation)(transactionMeta, decimals);
  const showRevokeVariant = spendingCap === '0' && transactionMeta.type === _transactionController.TransactionType.tokenMethodApprove;
  if (!(transactionMeta !== null && transactionMeta !== void 0 && transactionMeta.txParams)) {
    return null;
  }
  if (pending || !isNFT && !decimals) {
    return /*#__PURE__*/_react.default.createElement(_confirmLoader.ConfirmLoader, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showRevokeVariant ? /*#__PURE__*/_react.default.createElement(_revokeStaticSimulation.RevokeStaticSimulation, null) : /*#__PURE__*/_react.default.createElement(_approveStaticSimulation.ApproveStaticSimulation, {
    setIsOpenEditSpendingCapModal: setIsOpenEditSpendingCapModal
  }), showRevokeVariant ? /*#__PURE__*/_react.default.createElement(_revokeDetails.RevokeDetails, null) : /*#__PURE__*/_react.default.createElement(_approveDetails.ApproveDetails, null), /*#__PURE__*/_react.default.createElement(_gasFeesSection.GasFeesSection, null), /*#__PURE__*/_react.default.createElement(_advancedDetails.AdvancedDetails, null), /*#__PURE__*/_react.default.createElement(_editSpendingCapModal.EditSpendingCapModal, {
    isOpenEditSpendingCapModal: isOpenEditSpendingCapModal,
    setIsOpenEditSpendingCapModal: setIsOpenEditSpendingCapModal
  }));
};
var _default = exports.default = ApproveInfo;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\approve\\approve.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\approve\\edit-spending-cap-modal\\edit-spending-cap-modal.tsx", {"../../../../../../../../shared/lib/transactions-controller-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\transactions-controller-utils.js","../../../../../../../../shared/lib/transactions/approvals":"D:\\code\\v\\metamask-extension\\shared\\lib\\transactions\\approvals.ts","../../../../../../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../../../../../../../shared/modules/transaction.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\transaction.utils.ts","../../../../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../../../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","../../../../../hooks/useAssetDetails":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useAssetDetails.js","../../shared/confirm-loader/confirm-loader":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\shared\\confirm-loader\\confirm-loader.tsx","../hooks/use-approve-token-simulation":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\approve\\hooks\\use-approve-token-simulation.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Capprove%5Cedit-spending-cap-modal%5Cedit-spending-cap-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditSpendingCapModal = void 0;
exports.countDecimalDigits = countDecimalDigits;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _transactionsControllerUtils = require("../../../../../../../../shared/lib/transactions-controller-utils");
var _conversion = require("../../../../../../../../shared/modules/conversion.utils");
var _componentLibrary = require("../../../../../../../components/component-library");
var _designSystem = require("../../../../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../../../../hooks/useI18nContext");
var _actions = require("../../../../../../../store/actions");
var _confirm = require("../../../../../context/confirm");
var _useAssetDetails = require("../../../../../hooks/useAssetDetails");
var _useApproveTokenSimulation = require("../hooks/use-approve-token-simulation");
var _confirmLoader = require("../../shared/confirm-loader/confirm-loader");
var _transaction = require("../../../../../../../../shared/modules/transaction.utils");
var _approvals = require("../../../../../../../../shared/lib/transactions/approvals");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function countDecimalDigits(numberString) {
  var _numberString$split$;
  return ((_numberString$split$ = numberString.split('.')[1]) === null || _numberString$split$ === void 0 ? void 0 : _numberString$split$.length) || 0;
}
const EditSpendingCapModal = ({
  data,
  isOpenEditSpendingCapModal,
  onSubmit,
  setIsOpenEditSpendingCapModal,
  to
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    currentConfirmation: transactionMeta
  } = (0, _confirm.useConfirmContext)();
  const currentTo = transactionMeta.txParams.to;
  const currentFrom = transactionMeta.txParams.from;
  const currentData = transactionMeta.txParams.data;
  const transactionTo = to ?? currentTo;
  const transactionData = data ?? currentData;
  const {
    tokenAddress
  } = (0, _transaction.parseApprovalTransactionData)(transactionData ?? '0x') ?? {};
  const {
    userBalance,
    tokenSymbol,
    decimals
  } = (0, _useAssetDetails.useAssetDetails)(tokenAddress ?? transactionTo, currentFrom, transactionData, transactionMeta.chainId);
  const accountBalance = (0, _transactionsControllerUtils.calcTokenAmount)(userBalance ?? '0', Number(decimals ?? '0')).toFixed();
  const finalTransactionMeta = (0, _react.useMemo)(() => ({
    ...transactionMeta,
    txParams: {
      ...transactionMeta.txParams,
      to: transactionTo,
      from: currentFrom,
      data: transactionData
    }
  }), [currentFrom, transactionData, transactionMeta, transactionTo]);
  const {
    formattedSpendingCap,
    pending,
    spendingCap
  } = (0, _useApproveTokenSimulation.useApproveTokenSimulation)(finalTransactionMeta, decimals);
  const [customSpendingCapInputValue, setCustomSpendingCapInputValue] = (0, _react.useState)(spendingCap);
  (0, _react.useEffect)(() => {
    if (spendingCap) {
      setCustomSpendingCapInputValue(spendingCap);
    }
  }, [spendingCap]);
  const handleCancel = (0, _react.useCallback)(() => {
    setIsOpenEditSpendingCapModal(false);
    setCustomSpendingCapInputValue(spendingCap);
  }, [setIsOpenEditSpendingCapModal, setCustomSpendingCapInputValue, spendingCap]);
  const [isModalSaving, setIsModalSaving] = (0, _react.useState)(false);
  const handleSubmit = (0, _react.useCallback)(async () => {
    setIsModalSaving(true);
    const customTxParamsData = (0, _approvals.updateApprovalAmount)(transactionData, (customSpendingCapInputValue || '0').replace('#', ''), Number(decimals || 0));
    if (onSubmit) {
      onSubmit(customTxParamsData);
    } else {
      const estimatedGasLimit = await (0, _actions.estimateGas)({
        from: finalTransactionMeta.txParams.from,
        to: finalTransactionMeta.txParams.to,
        value: finalTransactionMeta.txParams.value,
        data: customTxParamsData
      });
      dispatch((0, _actions.updateEditableParams)(transactionMeta.id, {
        data: customTxParamsData,
        gas: (0, _conversion.hexToDecimal)(estimatedGasLimit)
      }));
    }
    setIsModalSaving(false);
    setIsOpenEditSpendingCapModal(false);
    setCustomSpendingCapInputValue(spendingCap);
  }, [customSpendingCapInputValue, decimals, dispatch, finalTransactionMeta, onSubmit, setIsOpenEditSpendingCapModal, spendingCap, transactionData, transactionMeta.id]);
  const showDecimalError = decimals && parseInt(decimals, 10) < countDecimalDigits(customSpendingCapInputValue);
  const showSpecialCharacterError = /[-+e]/u.test(customSpendingCapInputValue);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: isOpenEditSpendingCapModal,
    onClose: handleCancel,
    isClosedOnEscapeKey: true,
    isClosedOnOutsideClick: true,
    className: "edit-spending-cap-modal"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    justifyContent: _designSystem.JustifyContent.center,
    childrenWrapperProps: {
      alignItems: _designSystem.AlignItems.center,
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingMd
  }, t('editSpendingCap'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    color: _designSystem.TextColor.textAlternative,
    paddingBottom: 4
  }, t('editSpendingCapDesc')), pending ? /*#__PURE__*/_react.default.createElement(_confirmLoader.ConfirmLoader, null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.TextField, {
    type: _componentLibrary.TextFieldType.Number,
    value: customSpendingCapInputValue,
    onChange: event => setCustomSpendingCapInputValue(event.target.value),
    placeholder: `${formattedSpendingCap} ${tokenSymbol}`,
    style: {
      width: '100%'
    },
    inputProps: {
      'data-testid': 'custom-spending-cap-input'
    }
  }), showDecimalError && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.errorDefault,
    paddingTop: 1
  }, t('editSpendingCapError', [decimals])), showSpecialCharacterError && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.errorDefault,
    paddingTop: 1
  }, t('editSpendingCapSpecialCharError')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative,
    paddingTop: 1
  }, t('editSpendingCapAccountBalance', [accountBalance,
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  tokenSymbol || ''])))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalFooter
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  , {
    onSubmit: handleSubmit,
    onCancel: handleCancel,
    submitButtonProps: {
      children: t('save'),
      loading: pending || isModalSaving,
      disabled:
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
      // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
      showDecimalError || showSpecialCharacterError || customSpendingCapInputValue === ''
    }
  })));
};
exports.EditSpendingCapModal = EditSpendingCapModal;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\approve\\edit-spending-cap-modal\\edit-spending-cap-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\approve\\hooks\\use-approve-token-simulation.ts", {"../../../../../../../../shared/lib/transactions-controller-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\transactions-controller-utils.js","../../../../../../../../shared/modules/transaction.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\transaction.utils.ts","../../../../../../../ducks/locale/locale":"D:\\code\\v\\metamask-extension\\ui\\ducks\\locale\\locale.ts","../../../../simulation-details/formatAmount":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\simulation-details\\formatAmount.ts","../../shared/constants":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\shared\\constants.ts","./use-is-nft":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\approve\\hooks\\use-is-nft.ts","bignumber.js":"D:\\code\\v\\metamask-extension\\node_modules\\bignumber.js\\bignumber.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Capprove%5Chooks%5Cuse-approve-token-simulation.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isSpendingCapUnlimited = isSpendingCapUnlimited;
exports.useApproveTokenSimulation = void 0;
var _bignumber = require("bignumber.js");
var _react = require("react");
var _reactRedux = require("react-redux");
var _transactionsControllerUtils = require("../../../../../../../../shared/lib/transactions-controller-utils");
var _locale = require("../../../../../../../ducks/locale/locale");
var _formatAmount = require("../../../../simulation-details/formatAmount");
var _constants = require("../../shared/constants");
var _transaction = require("../../../../../../../../shared/modules/transaction.utils");
var _useIsNft = require("./use-is-nft");
function isSpendingCapUnlimited(value, decimals = 0) {
  const finalValue = (0, _transactionsControllerUtils.calcTokenAmount)(value, decimals);
  return finalValue.gte(_constants.TOKEN_VALUE_UNLIMITED_THRESHOLD);
}
const useApproveTokenSimulation = (transactionMeta, decimals) => {
  var _transactionMeta$txPa;
  const locale = (0, _reactRedux.useSelector)(_locale.getIntlLocale);
  const {
    isNFT: isToNFT,
    pending: isNFTPending
  } = (0, _useIsNft.useIsNFT)(transactionMeta);
  const transactionData = transactionMeta === null || transactionMeta === void 0 || (_transactionMeta$txPa = transactionMeta.txParams) === null || _transactionMeta$txPa === void 0 ? void 0 : _transactionMeta$txPa.data;
  const {
    amountOrTokenId: parsedValue,
    tokenAddress
  } = (0, _transaction.parseApprovalTransactionData)(transactionData ?? '0x') ?? {};
  const isNFT = isToNFT && !tokenAddress;
  const value = parsedValue ?? new _bignumber.BigNumber(0);
  const decodedSpendingCap = (0, _transactionsControllerUtils.calcTokenAmount)(value, Number(decimals ?? '0')).toFixed();
  const tokenPrefix = isNFT ? '#' : '';
  const formattedSpendingCap = (0, _react.useMemo)(() => {
    return isNFT ? `${tokenPrefix}${decodedSpendingCap}` : (0, _formatAmount.formatAmount)(locale, new _bignumber.BigNumber(decodedSpendingCap));
  }, [decodedSpendingCap, isNFT, locale, tokenPrefix]);
  const {
    spendingCap,
    isUnlimitedSpendingCap
  } = (0, _react.useMemo)(() => {
    if (!isNFT && isSpendingCapUnlimited(parseInt(decodedSpendingCap, 10))) {
      return {
        spendingCap: decodedSpendingCap,
        isUnlimitedSpendingCap: true
      };
    }
    return {
      spendingCap: `${tokenPrefix}${decodedSpendingCap}`,
      isUnlimitedSpendingCap: false
    };
  }, [decodedSpendingCap, isNFT, tokenPrefix]);
  return {
    isUnlimitedSpendingCap,
    spendingCap,
    formattedSpendingCap,
    value,
    pending: isNFTPending
  };
};
exports.useApproveTokenSimulation = useApproveTokenSimulation;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\approve\\hooks\\use-approve-token-simulation.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\approve\\hooks\\use-is-nft.ts", {"../../../../../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../../../../../hooks/useAsync":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAsync.ts","../../../../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Capprove%5Chooks%5Cuse-is-nft.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsNFT = void 0;
var _transaction = require("../../../../../../../../shared/constants/transaction");
var _useAsync = require("../../../../../../../hooks/useAsync");
var _actions = require("../../../../../../../store/actions");
const useIsNFT = transactionMeta => {
  var _transactionMeta$txPa3;
  const {
    value,
    pending
  } = (0, _useAsync.useAsyncResult)(async () => {
    var _transactionMeta$txPa, _transactionMeta$txPa2;
    return await (0, _actions.getTokenStandardAndDetailsByChain)(transactionMeta === null || transactionMeta === void 0 || (_transactionMeta$txPa = transactionMeta.txParams) === null || _transactionMeta$txPa === void 0 ? void 0 : _transactionMeta$txPa.to, transactionMeta === null || transactionMeta === void 0 || (_transactionMeta$txPa2 = transactionMeta.txParams) === null || _transactionMeta$txPa2 === void 0 ? void 0 : _transactionMeta$txPa2.from, undefined, transactionMeta === null || transactionMeta === void 0 ? void 0 : transactionMeta.chainId);
  }, [transactionMeta === null || transactionMeta === void 0 || (_transactionMeta$txPa3 = transactionMeta.txParams) === null || _transactionMeta$txPa3 === void 0 ? void 0 : _transactionMeta$txPa3.to]);
  const isNFT = (value === null || value === void 0 ? void 0 : value.standard) !== _transaction.TokenStandard.ERC20;
  return {
    pending,
    isNFT
  };
};
exports.useIsNFT = useIsNFT;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\approve\\hooks\\use-is-nft.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\approve\\revoke-details\\revoke-details.tsx", {"../../../../../../../components/app/confirm/info/row/section":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\section.tsx","../../../../../hooks/useIsBIP44":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useIsBIP44.ts","../../shared/network-row/network-row":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\shared\\network-row\\network-row.tsx","../../shared/sign-in-with-row/sign-in-with-row":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\shared\\sign-in-with-row\\sign-in-with-row.tsx","../../shared/transaction-details/transaction-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\shared\\transaction-details\\transaction-details.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Capprove%5Crevoke-details%5Crevoke-details.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RevokeDetails = void 0;
var _react = _interopRequireDefault(require("react"));
var _section = require("../../../../../../../components/app/confirm/info/row/section");
var _networkRow = require("../../shared/network-row/network-row");
var _transactionDetails = require("../../shared/transaction-details/transaction-details");
var _signInWithRow = require("../../shared/sign-in-with-row/sign-in-with-row");
var _useIsBIP = require("../../../../../hooks/useIsBIP44");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const RevokeDetails = () => {
  const isBIP44 = (0, _useIsBIP.useIsBIP44)();
  return /*#__PURE__*/_react.default.createElement(_section.ConfirmInfoSection, null, /*#__PURE__*/_react.default.createElement(_networkRow.NetworkRow, {
    isShownWithAlertsOnly: !isBIP44
  }), /*#__PURE__*/_react.default.createElement(_transactionDetails.OriginRow, null), /*#__PURE__*/_react.default.createElement(_signInWithRow.SigningInWithRow, null));
};
exports.RevokeDetails = RevokeDetails;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\approve\\revoke-details\\revoke-details.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\approve\\revoke-static-simulation\\revoke-static-simulation.tsx", {"../../../../../../../components/app/confirm/info/row":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\index.ts","../../../../../../../components/app/name":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\name\\index.ts","../../../../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","../../shared/static-simulation/static-simulation":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\shared\\static-simulation\\static-simulation.tsx","@metamask/name-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\name-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Capprove%5Crevoke-static-simulation%5Crevoke-static-simulation.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RevokeStaticSimulation = void 0;
var _nameController = require("@metamask/name-controller");
var _react = _interopRequireDefault(require("react"));
var _row = require("../../../../../../../components/app/confirm/info/row");
var _name = _interopRequireDefault(require("../../../../../../../components/app/name"));
var _componentLibrary = require("../../../../../../../components/component-library");
var _designSystem = require("../../../../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../../../../hooks/useI18nContext");
var _confirm = require("../../../../../context/confirm");
var _staticSimulation = _interopRequireDefault(require("../../shared/static-simulation/static-simulation"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const RevokeStaticSimulation = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    currentConfirmation: transactionMeta
  } = (0, _confirm.useConfirmContext)();
  const {
    chainId
  } = transactionMeta;
  const TokenContractRow = /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRow, {
    label: t('spendingCap')
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    style: {
      marginLeft: 'auto',
      maxWidth: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex
  }, /*#__PURE__*/_react.default.createElement(_name.default, {
    value: transactionMeta.txParams.to,
    type: _nameController.NameType.ETHEREUM_ADDRESS,
    preferContractSymbol: true,
    variation: chainId
  }))));
  const SpenderRow = /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRow, {
    label: t('spender')
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    style: {
      marginLeft: 'auto',
      maxWidth: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex
  }, /*#__PURE__*/_react.default.createElement(_name.default, {
    value: transactionMeta.txParams.from,
    type: _nameController.NameType.ETHEREUM_ADDRESS,
    preferContractSymbol: true,
    variation: chainId
  }))));
  const simulationElements = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, TokenContractRow, SpenderRow);
  return /*#__PURE__*/_react.default.createElement(_staticSimulation.default, {
    title: t('simulationDetailsTitle'),
    titleTooltip: t('simulationDetailsTitleTooltip'),
    description: t('revokeSimulationDetailsDesc'),
    simulationElements: simulationElements
  });
};
exports.RevokeStaticSimulation = RevokeStaticSimulation;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\approve\\revoke-static-simulation\\revoke-static-simulation.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\base-transaction-info\\base-transaction-info.tsx", {"../../../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","../batch/batch-simulation-details/batch-simulation-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\batch\\batch-simulation-details\\batch-simulation-details.tsx","../batch/transaction-account-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\batch\\transaction-account-details\\index.ts","../shared/advanced-details/advanced-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\shared\\advanced-details\\advanced-details.tsx","../shared/gas-fees-section/gas-fees-section":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\shared\\gas-fees-section\\gas-fees-section.tsx","../shared/transaction-details/transaction-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\shared\\transaction-details\\transaction-details.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Cbase-transaction-info%5Cbase-transaction-info.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _confirm = require("../../../../context/confirm");
var _advancedDetails = require("../shared/advanced-details/advanced-details");
var _gasFeesSection = require("../shared/gas-fees-section/gas-fees-section");
var _transactionDetails = require("../shared/transaction-details/transaction-details");
var _transactionAccountDetails = require("../batch/transaction-account-details");
var _batchSimulationDetails = require("../batch/batch-simulation-details/batch-simulation-details");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const BaseTransactionInfo = () => {
  const {
    currentConfirmation: transactionMeta
  } = (0, _confirm.useConfirmContext)();
  if (!(transactionMeta !== null && transactionMeta !== void 0 && transactionMeta.txParams)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_transactionAccountDetails.TransactionAccountDetails, null), /*#__PURE__*/_react.default.createElement(_batchSimulationDetails.BatchSimulationDetails, null), /*#__PURE__*/_react.default.createElement(_transactionDetails.TransactionDetails, null), /*#__PURE__*/_react.default.createElement(_gasFeesSection.GasFeesSection, null), /*#__PURE__*/_react.default.createElement(_advancedDetails.AdvancedDetails, null));
};
var _default = exports.default = BaseTransactionInfo;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\base-transaction-info\\base-transaction-info.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\batch\\batch-simulation-details\\batch-simulation-details.tsx", {"../../../../../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../../../../store/controller-actions/transaction-controller":"D:\\code\\v\\metamask-extension\\ui\\store\\controller-actions\\transaction-controller.ts","../../../../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","../../../../simulation-details/simulation-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\simulation-details\\simulation-details.tsx","../../approve/edit-spending-cap-modal/edit-spending-cap-modal":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\approve\\edit-spending-cap-modal\\edit-spending-cap-modal.tsx","../../hooks/useBatchApproveBalanceChanges":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useBatchApproveBalanceChanges.ts","../../hooks/useIsUpgradeTransaction":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useIsUpgradeTransaction.ts","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Cbatch%5Cbatch-simulation-details%5Cbatch-simulation-details.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BatchSimulationDetails = BatchSimulationDetails;
var _react = _interopRequireWildcard(require("react"));
var _transactionController = require("@metamask/transaction-controller");
var _simulationDetails = require("../../../../simulation-details/simulation-details");
var _useBatchApproveBalanceChanges = require("../../hooks/useBatchApproveBalanceChanges");
var _confirm = require("../../../../../context/confirm");
var _editSpendingCapModal = require("../../approve/edit-spending-cap-modal/edit-spending-cap-modal");
var _transaction = require("../../../../../../../../shared/constants/transaction");
var _useI18nContext = require("../../../../../../../hooks/useI18nContext");
var _transactionController2 = require("../../../../../../../store/controller-actions/transaction-controller");
var _useIsUpgradeTransaction = require("../../hooks/useIsUpgradeTransaction");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function BatchSimulationDetails() {
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    isUpgradeOnly
  } = (0, _useIsUpgradeTransaction.useIsUpgradeTransaction)();
  const {
    currentConfirmation: transactionMeta
  } = (0, _confirm.useConfirmContext)();
  const {
    id,
    nestedTransactions
  } = transactionMeta;
  const {
    value: approveBalanceChanges
  } = (0, _useBatchApproveBalanceChanges.useBatchApproveBalanceChanges)() ?? {};
  const [isEditApproveModalOpen, setIsEditApproveModalOpen] = (0, _react.useState)(false);
  const [nestedTransactionIndexToEdit, setNestedTransactionIndexToEdit] = (0, _react.useState)();
  const handleEdit = (0, _react.useCallback)(balanceChange => {
    setNestedTransactionIndexToEdit(balanceChange.nestedTransactionIndex);
    setIsEditApproveModalOpen(true);
  }, []);
  const handleEditSubmit = (0, _react.useCallback)(async data => {
    if (nestedTransactionIndexToEdit === undefined) {
      return;
    }
    await (0, _transactionController2.updateAtomicBatchData)({
      transactionId: id,
      transactionData: data,
      transactionIndex: nestedTransactionIndexToEdit
    });
  }, [id, nestedTransactionIndexToEdit]);
  if ((transactionMeta === null || transactionMeta === void 0 ? void 0 : transactionMeta.type) === _transactionController.TransactionType.revokeDelegation || isUpgradeOnly) {
    return null;
  }
  const approveRows = (0, _react.useMemo)(() => {
    const finalBalanceChanges = approveBalanceChanges === null || approveBalanceChanges === void 0 ? void 0 : approveBalanceChanges.map(change => ({
      ...change,
      onEdit: change.asset.standard === _transaction.TokenStandard.ERC20 ? () => handleEdit(change) : undefined
    }));
    return [{
      label: t('confirmSimulationApprove'),
      balanceChanges: finalBalanceChanges ?? []
    }];
  }, [approveBalanceChanges, handleEdit]);
  const nestedTransactionToEdit = nestedTransactionIndexToEdit === undefined ? undefined : nestedTransactions === null || nestedTransactions === void 0 ? void 0 : nestedTransactions[nestedTransactionIndexToEdit];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isEditApproveModalOpen && /*#__PURE__*/_react.default.createElement(_editSpendingCapModal.EditSpendingCapModal, {
    data: nestedTransactionToEdit === null || nestedTransactionToEdit === void 0 ? void 0 : nestedTransactionToEdit.data,
    isOpenEditSpendingCapModal: true
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    ,
    onSubmit: handleEditSubmit,
    setIsOpenEditSpendingCapModal: setIsEditApproveModalOpen,
    to: nestedTransactionToEdit === null || nestedTransactionToEdit === void 0 ? void 0 : nestedTransactionToEdit.to
  }), /*#__PURE__*/_react.default.createElement(_simulationDetails.SimulationDetails, {
    transaction: transactionMeta,
    staticRows: approveRows,
    isTransactionsRedesign: true,
    enableMetrics: true
  }));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\batch\\batch-simulation-details\\batch-simulation-details.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\batch\\nested-transaction-data\\nested-transaction-data.tsx", {"../../../../../../../components/app/confirm/info/row":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\index.ts","../../../../../../../components/app/confirm/info/row/currency":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\currency.tsx","../../../../../../../components/app/confirm/info/row/expandable-row":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\expandable-row.tsx","../../../../../../../components/app/confirm/info/row/section":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\section.tsx","../../../../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","../../hooks/useNestedTransactionLabels":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useNestedTransactionLabels.ts","../../shared/transaction-data/transaction-data":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\shared\\transaction-data\\transaction-data.tsx","../../shared/transaction-details/transaction-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\shared\\transaction-details\\transaction-details.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Cbatch%5Cnested-transaction-data%5Cnested-transaction-data.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NestedTransactionData = NestedTransactionData;
var _react = _interopRequireDefault(require("react"));
var _confirm = require("../../../../../context/confirm");
var _componentLibrary = require("../../../../../../../components/component-library");
var _section = require("../../../../../../../components/app/confirm/info/row/section");
var _expandableRow = require("../../../../../../../components/app/confirm/info/row/expandable-row");
var _transactionDetails = require("../../shared/transaction-details/transaction-details");
var _transactionData = require("../../shared/transaction-data/transaction-data");
var _row = require("../../../../../../../components/app/confirm/info/row");
var _currency = require("../../../../../../../components/app/confirm/info/row/currency");
var _useI18nContext = require("../../../../../../../hooks/useI18nContext");
var _useNestedTransactionLabels = require("../../hooks/useNestedTransactionLabels");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function NestedTransactionData() {
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const {
    nestedTransactions
  } = currentConfirmation ?? {};
  if (!(nestedTransactions !== null && nestedTransactions !== void 0 && nestedTransactions.length)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    "data-testid": "batch-txs"
  }, nestedTransactions.map((nestedTransaction, index) => /*#__PURE__*/_react.default.createElement(NestedTransaction, {
    key: index,
    index: index,
    nestedTransaction: nestedTransaction
  })));
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function NestedTransaction({
  index,
  nestedTransaction
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    data,
    to,
    value
  } = nestedTransaction;
  const label = (0, _useNestedTransactionLabels.useNestedTransactionLabels)({
    nestedTransactions: [nestedTransaction],
    useIndex: index
  })[0];
  return /*#__PURE__*/_react.default.createElement(_section.ConfirmInfoSection, null, /*#__PURE__*/_react.default.createElement(_expandableRow.ConfirmInfoExpandableRow, {
    label: label,
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, to && /*#__PURE__*/_react.default.createElement(_transactionDetails.RecipientRow, {
      recipient: to
    }), value && /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRow, {
      label: t('amount')
    }, /*#__PURE__*/_react.default.createElement(_currency.ConfirmInfoRowCurrency, {
      value: value
    })), data && to && /*#__PURE__*/_react.default.createElement(_transactionData.TransactionData, {
      data: data,
      to: to,
      noPadding: true,
      nestedTransactionIndex: index
    }))
  }, /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRowText, {
    text: ""
  })));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\batch\\nested-transaction-data\\nested-transaction-data.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\batch\\transaction-account-details\\index.ts", {"./transaction-account-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\batch\\transaction-account-details\\transaction-account-details.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Cbatch%5Ctransaction-account-details%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "TransactionAccountDetails", {
  enumerable: true,
  get: function () {
    return _transactionAccountDetails.TransactionAccountDetails;
  }
});
var _transactionAccountDetails = require("./transaction-account-details");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\batch\\transaction-account-details\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\batch\\transaction-account-details\\transaction-account-details.tsx", {"../../../../../../../../shared/lib/transactions.utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\transactions.utils.ts","../../../../../../../components/app/confirm/info/row":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\index.ts","../../../../../../../components/app/confirm/info/row/alert-row/alert-row":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\alert-row\\alert-row.tsx","../../../../../../../components/app/confirm/info/row/constants":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\constants.ts","../../../../../../../components/app/confirm/info/row/section":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\section.tsx","../../../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","../../hooks/useIsUpgradeTransaction":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useIsUpgradeTransaction.ts","../../shared/transaction-details/transaction-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\shared\\transaction-details\\transaction-details.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Cbatch%5Ctransaction-account-details%5Ctransaction-account-details.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionAccountDetails = TransactionAccountDetails;
var _react = _interopRequireDefault(require("react"));
var _transactions = require("../../../../../../../../shared/lib/transactions.utils");
var _row = require("../../../../../../../components/app/confirm/info/row");
var _section = require("../../../../../../../components/app/confirm/info/row/section");
var _useI18nContext = require("../../../../../../../hooks/useI18nContext");
var _confirm = require("../../../../../context/confirm");
var _alertRow = require("../../../../../../../components/app/confirm/info/row/alert-row/alert-row");
var _constants = require("../../../../../../../components/app/confirm/info/row/constants");
var _useIsUpgradeTransaction = require("../../hooks/useIsUpgradeTransaction");
var _transactionDetails = require("../../shared/transaction-details/transaction-details");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function TransactionAccountDetails() {
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const {
    isUpgrade,
    isUpgradeOnly
  } = (0, _useIsUpgradeTransaction.useIsUpgradeTransaction)();
  const isDowngrade = (0, _useIsUpgradeTransaction.useIsDowngradeTransaction)();
  const {
    chainId,
    nestedTransactions,
    txParams,
    id
  } = currentConfirmation;
  const {
    from
  } = txParams;
  const isBatch = (0, _transactions.isBatchTransaction)(nestedTransactions);
  if (!isUpgrade && !isDowngrade) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_section.ConfirmInfoSection, null, (isUpgradeOnly || isDowngrade) && /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRow, {
    label: t('account')
  }, /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRowAddress, {
    chainId: chainId,
    address: from
  })), isUpgradeOnly && /*#__PURE__*/_react.default.createElement(_alertRow.ConfirmInfoAlertRow, {
    alertKey: _constants.RowAlertKey.AccountTypeUpgrade,
    label: t('confirmInfoAccountNow'),
    ownerId: id
  }, /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRowText, {
    text: t('confirmAccountTypeStandard'),
    "data-testid": "tx-type"
  })), isUpgrade && /*#__PURE__*/_react.default.createElement(_alertRow.ConfirmInfoAlertRow, {
    alertKey: isUpgradeOnly ? '' : _constants.RowAlertKey.AccountTypeUpgrade,
    label: t('confirmInfoSwitchingTo'),
    ownerId: isUpgradeOnly ? '' : id
  }, /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRowText, {
    text: t('confirmAccountTypeSmartContract')
  })), isDowngrade && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRow, {
    label: t('confirmInfoAccountNow')
  }, /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRowText, {
    text: t('confirmAccountTypeSmartContract')
  })), /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRow, {
    label: t('confirmInfoSwitchingTo')
  }, /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRowText, {
    text: t('confirmAccountTypeStandard')
  }))), (isBatch || isUpgrade) && /*#__PURE__*/_react.default.createElement(_transactionDetails.RecipientRow, null));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\batch\\transaction-account-details\\transaction-account-details.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\use-token-values.ts", {"../../../../../../../shared/lib/transactions-controller-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\transactions-controller-utils.js","../../../../../../components/app/currency-input/hooks/useTokenExchangeRate":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\currency-input\\hooks\\useTokenExchangeRate.tsx","../../../../../../ducks/locale/locale":"D:\\code\\v\\metamask-extension\\ui\\ducks\\locale\\locale.ts","../../../../../../hooks/useFiatFormatter":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useFiatFormatter.ts","../../../../hooks/useAssetDetails":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useAssetDetails.js","../../../simulation-details/formatAmount":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\simulation-details\\formatAmount.ts","./useTokenTransactionData":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useTokenTransactionData.ts","bignumber.js":"D:\\code\\v\\metamask-extension\\node_modules\\bignumber.js\\bignumber.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Chooks%5Cuse-token-values.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTokenValues = void 0;
var _bignumber = require("bignumber.js");
var _reactRedux = require("react-redux");
var _transactionsControllerUtils = require("../../../../../../../shared/lib/transactions-controller-utils");
var _useTokenExchangeRate = _interopRequireDefault(require("../../../../../../components/app/currency-input/hooks/useTokenExchangeRate"));
var _locale = require("../../../../../../ducks/locale/locale");
var _useFiatFormatter = require("../../../../../../hooks/useFiatFormatter");
var _useAssetDetails = require("../../../../hooks/useAssetDetails");
var _formatAmount = require("../../../simulation-details/formatAmount");
var _useTokenTransactionData = require("./useTokenTransactionData");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const useTokenValues = transactionMeta => {
  var _transactionMeta$txPa, _parsedTransactionDat;
  const locale = (0, _reactRedux.useSelector)(_locale.getIntlLocale);
  const parsedTransactionData = (0, _useTokenTransactionData.useTokenTransactionData)();
  const exchangeRate = (0, _useTokenExchangeRate.default)(transactionMeta === null || transactionMeta === void 0 || (_transactionMeta$txPa = transactionMeta.txParams) === null || _transactionMeta$txPa === void 0 ? void 0 : _transactionMeta$txPa.to);
  const fiatFormatter = (0, _useFiatFormatter.useFiatFormatter)();
  const {
    decimals
  } = (0, _useAssetDetails.useAssetDetails)(transactionMeta.txParams.to, transactionMeta.txParams.from, transactionMeta.txParams.data, transactionMeta.chainId);
  const value = parsedTransactionData === null || parsedTransactionData === void 0 || (_parsedTransactionDat = parsedTransactionData.args) === null || _parsedTransactionDat === void 0 ? void 0 : _parsedTransactionDat._value;
  const decodedTransferValue = decimals !== undefined && value ? (0, _transactionsControllerUtils.calcTokenAmount)(value, Number(decimals)).toFixed() : '0';
  const fiatValue = exchangeRate && decodedTransferValue && exchangeRate.times(decodedTransferValue, 10).toNumber();
  const isNonZeroSmallValue = fiatValue && new _bignumber.BigNumber(String(fiatValue)).greaterThan(new _bignumber.BigNumber(0)) && new _bignumber.BigNumber(String(fiatValue)).lt(new _bignumber.BigNumber(0.01));
  const fiatDisplayValue = isNonZeroSmallValue ? `< ${fiatFormatter(0.01, {
    shorten: true
  })}` : fiatValue && fiatFormatter(fiatValue, {
    shorten: true
  });
  const displayTransferValue = (0, _formatAmount.formatAmount)(locale, new _bignumber.BigNumber(decodedTransferValue));
  return {
    decodedTransferValue,
    displayTransferValue,
    fiatDisplayValue,
    fiatValue
  };
};
exports.useTokenValues = useTokenValues;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\use-token-values.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useBatchApproveBalanceChanges.ts", {"../../../../../../../shared/modules/transaction.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\transaction.utils.ts","../../../../../../hooks/useAsync":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAsync.ts","../../../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","../../../simulation-details/useBalanceChanges":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\simulation-details\\useBalanceChanges.ts","../approve/hooks/use-approve-token-simulation":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\approve\\hooks\\use-approve-token-simulation.ts","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Chooks%5CuseBatchApproveBalanceChanges.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBatchApproveBalanceChanges = useBatchApproveBalanceChanges;
var _transactionController = require("@metamask/transaction-controller");
var _utils = require("@metamask/utils");
var _react = require("react");
var _confirm = require("../../../../context/confirm");
var _useAsync = require("../../../../../../hooks/useAsync");
var _actions = require("../../../../../../store/actions");
var _transaction = require("../../../../../../../shared/modules/transaction.utils");
var _useBalanceChanges = require("../../../simulation-details/useBalanceChanges");
var _useApproveTokenSimulation = require("../approve/hooks/use-approve-token-simulation");
function useBatchApproveBalanceChanges() {
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const {
    chainId,
    nestedTransactions
  } = currentConfirmation ?? {};
  const {
    value: simulationBalanceChanges,
    pending: pendingSimulationChanges
  } = useBatchApproveSimulationBalanceChanges({
    nestedTransactions
  });
  const {
    value: balanceChanges,
    pending: pendingBalanceChanges
  } = (0, _useBalanceChanges.useBalanceChanges)({
    chainId,
    simulationData: {
      tokenBalanceChanges: simulationBalanceChanges ?? []
    }
  });
  const finalBalanceChanges = (0, _react.useMemo)(() => (balanceChanges ?? []).map((change, index) => {
    const simulation = simulationBalanceChanges === null || simulationBalanceChanges === void 0 ? void 0 : simulationBalanceChanges[index];
    return {
      ...change,
      isApproval: true,
      isAllApproval: (simulation === null || simulation === void 0 ? void 0 : simulation.isAll) ?? false,
      isUnlimitedApproval: (simulation === null || simulation === void 0 ? void 0 : simulation.isUnlimited) ?? false,
      nestedTransactionIndex: (simulation === null || simulation === void 0 ? void 0 : simulation.nestedTransactionIndex) ?? -1
    };
  }), [balanceChanges, simulationBalanceChanges]);
  const pending = pendingSimulationChanges || pendingBalanceChanges;
  return {
    pending,
    value: finalBalanceChanges
  };
}
function useBatchApproveSimulationBalanceChanges({
  nestedTransactions
}) {
  return (0, _useAsync.useAsyncResult)(async () => buildSimulationTokenBalanceChanges({
    nestedTransactions
  }), [JSON.stringify(nestedTransactions)]);
}
async function buildSimulationTokenBalanceChanges({
  nestedTransactions
}) {
  const balanceChanges = [];
  if (!nestedTransactions) {
    return balanceChanges;
  }
  for (let i = 0; i < nestedTransactions.length; i++) {
    var _tokenData$standard;
    const transaction = nestedTransactions[i];
    const {
      data,
      to
    } = transaction;
    if (!data || !to) {
      continue;
    }
    const parseResult = (0, _transaction.parseApprovalTransactionData)(data);
    if (!parseResult) {
      continue;
    }
    const {
      amountOrTokenId,
      isApproveAll: isAll,
      tokenAddress: token
    } = parseResult;
    const tokenAddress = token ?? to;
    const tokenData = await (0, _actions.getTokenStandardAndDetails)(tokenAddress);
    if (!(tokenData !== null && tokenData !== void 0 && tokenData.standard)) {
      continue;
    }
    const standard = tokenData === null || tokenData === void 0 || (_tokenData$standard = tokenData.standard) === null || _tokenData$standard === void 0 ? void 0 : _tokenData$standard.toLowerCase();
    const isNFT = standard !== _transactionController.SimulationTokenStandard.erc20;
    const amountOrTokenIdHex = (0, _utils.add0x)((amountOrTokenId === null || amountOrTokenId === void 0 ? void 0 : amountOrTokenId.toString(16)) ?? '0x0');
    const difference = isNFT || amountOrTokenId === undefined ? '0x1' : amountOrTokenIdHex;
    const tokenId = isNFT && amountOrTokenId ? amountOrTokenIdHex : undefined;
    const isUnlimited = !isNFT && (0, _useApproveTokenSimulation.isSpendingCapUnlimited)((amountOrTokenId === null || amountOrTokenId === void 0 ? void 0 : amountOrTokenId.toNumber()) ?? 0, Number((tokenData === null || tokenData === void 0 ? void 0 : tokenData.decimals) ?? 0));
    const balanceChange = {
      address: tokenAddress,
      difference,
      id: tokenId,
      isAll: isAll ?? false,
      isDecrease: true,
      isUnlimited,
      newBalance: '0x0',
      nestedTransactionIndex: i,
      previousBalance: '0x0',
      standard
    };
    balanceChanges.push(balanceChange);
  }
  return balanceChanges;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useBatchApproveBalanceChanges.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useDecodedTransactionData.ts", {"../../../../../../../shared/modules/transaction.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\transaction.utils.ts","../../../../../../hooks/useAsync":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAsync.ts","../../../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Chooks%5CuseDecodedTransactionData.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDecodedTransactionData = useDecodedTransactionData;
var _reactRedux = require("react-redux");
var _useAsync = require("../../../../../../hooks/useAsync");
var _actions = require("../../../../../../store/actions");
var _confirm = require("../../../../context/confirm");
var _transaction = require("../../../../../../../shared/modules/transaction.utils");
var _selectors = require("../../../../../../selectors");
function useDecodedTransactionData({
  data,
  to,
  transactionTypeFilter
} = {}) {
  var _currentConfirmation$, _currentConfirmation$2;
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const isDecodeEnabled = (0, _reactRedux.useSelector)(_selectors.use4ByteResolutionSelector);
  const currentTransactionType = currentConfirmation === null || currentConfirmation === void 0 ? void 0 : currentConfirmation.type;
  const chainId = currentConfirmation === null || currentConfirmation === void 0 ? void 0 : currentConfirmation.chainId;
  const currentTransactionData = currentConfirmation === null || currentConfirmation === void 0 || (_currentConfirmation$ = currentConfirmation.txParams) === null || _currentConfirmation$ === void 0 ? void 0 : _currentConfirmation$.data;
  const currentTransactionTo = currentConfirmation === null || currentConfirmation === void 0 || (_currentConfirmation$2 = currentConfirmation.txParams) === null || _currentConfirmation$2 === void 0 ? void 0 : _currentConfirmation$2.to;
  const transactionData = data ?? currentTransactionData;
  const transactionTo = to ?? currentTransactionTo;
  return (0, _useAsync.useAsyncResult)(async () => {
    if (!isDecodeEnabled || !(0, _transaction.hasTransactionData)(transactionData) || !transactionTo || transactionTypeFilter && currentTransactionType !== transactionTypeFilter) {
      return undefined;
    }
    return await (0, _actions.decodeTransactionData)({
      transactionData,
      chainId,
      contractAddress: transactionTo
    });
  }, [isDecodeEnabled, transactionData, transactionTo, chainId]);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useDecodedTransactionData.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useEIP1559TxFees.ts", {"../../../../../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Chooks%5CuseEIP1559TxFees.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEIP1559TxFees = void 0;
var _react = require("react");
var _conversion = require("../../../../../../../shared/modules/conversion.utils");
const useEIP1559TxFees = transactionMeta => {
  var _transactionMeta$txPa, _transactionMeta$txPa2;
  const hexMaxFeePerGas = transactionMeta === null || transactionMeta === void 0 || (_transactionMeta$txPa = transactionMeta.txParams) === null || _transactionMeta$txPa === void 0 ? void 0 : _transactionMeta$txPa.maxFeePerGas;
  const hexMaxPriorityFeePerGas = transactionMeta === null || transactionMeta === void 0 || (_transactionMeta$txPa2 = transactionMeta.txParams) === null || _transactionMeta$txPa2 === void 0 ? void 0 : _transactionMeta$txPa2.maxPriorityFeePerGas;
  return (0, _react.useMemo)(() => {
    const maxFeePerGas = hexMaxFeePerGas ? (0, _conversion.hexToDecimal)(hexMaxFeePerGas) : '0';
    const maxPriorityFeePerGas = hexMaxPriorityFeePerGas ? (0, _conversion.hexToDecimal)(hexMaxPriorityFeePerGas) : '0';
    return {
      maxFeePerGas,
      maxPriorityFeePerGas
    };
  }, [hexMaxFeePerGas, hexMaxPriorityFeePerGas]);
};
exports.useEIP1559TxFees = useEIP1559TxFees;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useEIP1559TxFees.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useFeeCalculations.ts", {"../../../../../../../shared/constants/common":"D:\\code\\v\\metamask-extension\\shared\\constants\\common.ts","../../../../../../../shared/modules/Numeric":"D:\\code\\v\\metamask-extension\\shared\\modules\\Numeric.ts","../../../../../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../../../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../../../../hooks/useFiatFormatter":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useFiatFormatter.ts","../../../../../../hooks/useGasFeeEstimates":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useGasFeeEstimates.js","../../../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../shared/constants":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\shared\\constants.ts","./useEIP1559TxFees":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useEIP1559TxFees.ts","./useSupportsEIP1559":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useSupportsEIP1559.ts","./useTransactionGasFeeEstimate":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useTransactionGasFeeEstimate.ts","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Chooks%5CuseFeeCalculations.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFeeCalculations = useFeeCalculations;
var _utils = require("@metamask/utils");
var _react = require("react");
var _reactRedux = require("react-redux");
var _common = require("../../../../../../../shared/constants/common");
var _conversion = require("../../../../../../../shared/modules/conversion.utils");
var _Numeric = require("../../../../../../../shared/modules/Numeric");
var _metamask = require("../../../../../../ducks/metamask/metamask");
var _useFiatFormatter = require("../../../../../../hooks/useFiatFormatter");
var _useGasFeeEstimates = require("../../../../../../hooks/useGasFeeEstimates");
var _selectors = require("../../../../../../selectors");
var _constants = require("../shared/constants");
var _useEIP1559TxFees = require("./useEIP1559TxFees");
var _useSupportsEIP = require("./useSupportsEIP1559");
var _useTransactionGasFeeEstimate = require("./useTransactionGasFeeEstimate");
const EMPTY_FEE = '';
const EMPTY_FEES = {
  currentCurrencyFee: EMPTY_FEE,
  currentCurrencyFeeWith18SignificantDigits: EMPTY_FEE,
  nativeCurrencyFee: EMPTY_FEE
};
function useFeeCalculations(transactionMeta) {
  var _transactionMeta$txPa, _transactionMeta$txPa2;
  const currentCurrency = (0, _reactRedux.useSelector)(_metamask.getCurrentCurrency);
  const {
    chainId
  } = transactionMeta;
  const fiatFormatter = (0, _useFiatFormatter.useFiatFormatter)();
  const conversionRate = (0, _reactRedux.useSelector)(state => (0, _selectors.selectConversionRateByChainId)(state, chainId));

  // `gasUsed` is the gas limit actually used by the transaction in the
  // simulation environment.
  const optimizedGasLimit = (transactionMeta === null || transactionMeta === void 0 ? void 0 : transactionMeta.gasUsed) || (// While estimating gas for the transaction we add 50% gas limit buffer.
  // With `gasLimitNoBuffer` that buffer is removed. see PR
  // https://github.com/MetaMask/metamask-extension/pull/29502 for more
  // details.
  transactionMeta === null || transactionMeta === void 0 ? void 0 : transactionMeta.gasLimitNoBuffer) || (transactionMeta === null || transactionMeta === void 0 || (_transactionMeta$txPa = transactionMeta.txParams) === null || _transactionMeta$txPa === void 0 ? void 0 : _transactionMeta$txPa.gas) || _constants.HEX_ZERO;
  const getFeesFromHex = (0, _react.useCallback)(hexFee => {
    const nativeCurrencyFee = `${(0, _conversion.getValueFromWeiHex)({
      value: hexFee,
      fromCurrency: _common.EtherDenomination.GWEI,
      numberOfDecimals: 4
    }) || 0}`;
    const decimalCurrentCurrencyFee = Number((0, _conversion.getValueFromWeiHex)({
      value: hexFee,
      conversionRate,
      fromCurrency: _common.EtherDenomination.GWEI,
      toCurrency: currentCurrency,
      numberOfDecimals: 2
    }));
    let currentCurrencyFee, currentCurrencyFeeWith18SignificantDigits;
    if (decimalCurrentCurrencyFee === 0) {
      currentCurrencyFee = `< ${fiatFormatter(0.01)}`;
      currentCurrencyFeeWith18SignificantDigits = (0, _conversion.getValueFromWeiHex)({
        value: hexFee,
        conversionRate,
        fromCurrency: _common.EtherDenomination.GWEI,
        toCurrency: currentCurrency,
        numberOfDecimals: 18
      });
    } else {
      currentCurrencyFee = fiatFormatter(decimalCurrentCurrencyFee);
      currentCurrencyFeeWith18SignificantDigits = null;
    }
    return {
      currentCurrencyFee,
      currentCurrencyFeeWith18SignificantDigits,
      hexFee,
      nativeCurrencyFee
    };
  }, [conversionRate, currentCurrency, fiatFormatter]);
  const {
    maxFeePerGas,
    maxPriorityFeePerGas
  } = (0, _useEIP1559TxFees.useEIP1559TxFees)(transactionMeta);
  const {
    supportsEIP1559
  } = (0, _useSupportsEIP.useSupportsEIP1559)(transactionMeta);
  const gasFeeEstimate = (0, _useTransactionGasFeeEstimate.useTransactionGasFeeEstimate)(transactionMeta, supportsEIP1559);
  const {
    gasFeeEstimates
  } = (0, _useGasFeeEstimates.useGasFeeEstimates)(transactionMeta.networkClientId);
  const estimatedBaseFee = gasFeeEstimates === null || gasFeeEstimates === void 0 ? void 0 : gasFeeEstimates.estimatedBaseFee;
  const layer1GasFee = transactionMeta === null || transactionMeta === void 0 ? void 0 : transactionMeta.layer1GasFee;
  const hasLayer1GasFee = Boolean(layer1GasFee);

  // L1 fee
  const feesL1 = (0, _react.useMemo)(() => hasLayer1GasFee ? getFeesFromHex(layer1GasFee) : EMPTY_FEES, [getFeesFromHex, layer1GasFee, hasLayer1GasFee]);

  // L2 fee
  const feesL2 = (0, _react.useMemo)(() => hasLayer1GasFee ? getFeesFromHex(gasFeeEstimate) : EMPTY_FEES, [gasFeeEstimate, getFeesFromHex, hasLayer1GasFee]);

  // Max fee
  const gasPrice = (transactionMeta === null || transactionMeta === void 0 || (_transactionMeta$txPa2 = transactionMeta.txParams) === null || _transactionMeta$txPa2 === void 0 ? void 0 : _transactionMeta$txPa2.gasPrice) ?? _constants.HEX_ZERO;
  const maxFee = (0, _react.useMemo)(() => {
    return (0, _conversion.addHexes)(layer1GasFee ?? _constants.HEX_ZERO, (0, _conversion.multiplyHexes)(supportsEIP1559 ? (0, _conversion.decimalToHex)(maxFeePerGas) : gasPrice, optimizedGasLimit));
  }, [gasPrice, layer1GasFee, maxFeePerGas, optimizedGasLimit, supportsEIP1559]);
  const {
    currentCurrencyFee: maxFeeFiat,
    currentCurrencyFeeWith18SignificantDigits: maxFeeFiatWith18SignificantDigits,
    nativeCurrencyFee: maxFeeNative
  } = getFeesFromHex(maxFee);

  // Estimated fee
  const estimatedFees = (0, _react.useMemo)(() => {
    if (hasLayer1GasFee) {
      // Logic for L2 transactions with L1 and L2 fee components
      const estimatedTotalFeesForL2 = (0, _conversion.addHexes)(gasFeeEstimate, layer1GasFee);
      return getFeesFromHex(estimatedTotalFeesForL2);
    }

    // Logic for any network without L1 and L2 fee components
    let minimumFeePerGas = (0, _conversion.addHexes)((0, _conversion.decGWEIToHexWEI)(estimatedBaseFee) || _constants.HEX_ZERO, (0, _conversion.decimalToHex)(maxPriorityFeePerGas));

    // `minimumFeePerGas` should never be higher than the `maxFeePerGas`
    if (new _Numeric.Numeric(minimumFeePerGas, 16).greaterThan((0, _conversion.decimalToHex)(maxFeePerGas), 16)) {
      minimumFeePerGas = (0, _conversion.decimalToHex)(maxFeePerGas);
    }
    const estimatedFee = (0, _conversion.multiplyHexes)(supportsEIP1559 ? minimumFeePerGas : gasPrice, optimizedGasLimit);
    return getFeesFromHex(estimatedFee);
  }, [estimatedBaseFee, gasFeeEstimate, gasPrice, getFeesFromHex, hasLayer1GasFee, layer1GasFee, maxFeePerGas, maxPriorityFeePerGas, supportsEIP1559, transactionMeta]);
  return {
    estimatedFeeFiat: estimatedFees.currentCurrencyFee,
    estimatedFeeFiatWith18SignificantDigits: estimatedFees.currentCurrencyFeeWith18SignificantDigits,
    estimatedFeeNative: estimatedFees.nativeCurrencyFee,
    estimatedFeeNativeHex: (0, _utils.add0x)(estimatedFees.hexFee),
    l1FeeFiat: feesL1.currentCurrencyFee,
    l1FeeFiatWith18SignificantDigits: feesL1.currentCurrencyFeeWith18SignificantDigits,
    l1FeeNative: feesL1.nativeCurrencyFee,
    l2FeeFiat: feesL2.currentCurrencyFee,
    l2FeeFiatWith18SignificantDigits: feesL2.currentCurrencyFeeWith18SignificantDigits,
    l2FeeNative: feesL2.nativeCurrencyFee,
    maxFeeFiat,
    maxFeeFiatWith18SignificantDigits,
    maxFeeNative
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useFeeCalculations.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useFourByte.ts", {"../../../../../../../shared/modules/transaction.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\transaction.utils.ts","../../../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Chooks%5CuseFourByte.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFourByte = void 0;
var _reactRedux = require("react-redux");
var _react = require("react");
var _selectors = require("../../../../../../selectors");
var _actions = require("../../../../../../store/actions");
var _transaction = require("../../../../../../../shared/modules/transaction.utils");
const useFourByte = ({
  to,
  data
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const isFourByteEnabled = (0, _reactRedux.useSelector)(_selectors.use4ByteResolutionSelector);
  const transactionTo = to;
  const transactionData = data;
  (0, _react.useEffect)(() => {
    if (!isFourByteEnabled || !(0, _transaction.hasTransactionData)(transactionData) || !transactionTo) {
      return;
    }
    dispatch((0, _actions.getContractMethodData)(transactionData));
  }, [isFourByteEnabled, transactionData, transactionTo, dispatch]);
  const methodData = (0, _reactRedux.useSelector)(state => (0, _selectors.getKnownMethodData)(state, transactionData));
  if (!transactionTo) {
    return null;
  }
  return methodData;
};
exports.useFourByte = useFourByte;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useFourByte.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useGasFeeToken.ts", {"../../../../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../../../../ducks/locale/locale":"D:\\code\\v\\metamask-extension\\ui\\ducks\\locale\\locale.ts","../../../../../../hooks/useEthFiatAmount":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useEthFiatAmount.js","../../../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","../../../simulation-details/formatAmount":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\simulation-details\\formatAmount.ts","./useFeeCalculations":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useFeeCalculations.ts","@ethersproject/abi":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\abi\\lib\\index.js","@metamask/metamask-eth-abis":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\metamask-eth-abis\\dist\\index.js","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","bignumber.js":"D:\\code\\v\\metamask-extension\\node_modules\\bignumber.js\\bignumber.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Chooks%5CuseGasFeeToken.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RATE_WEI_NATIVE = exports.METAMASK_FEE_PERCENTAGE = void 0;
exports.useGasFeeToken = useGasFeeToken;
exports.useSelectedGasFeeToken = useSelectedGasFeeToken;
var _utils = require("@metamask/utils");
var _bignumber = require("bignumber.js");
var _reactRedux = require("react-redux");
var _abi = require("@ethersproject/abi");
var _metamaskEthAbis = require("@metamask/metamask-eth-abis");
var _transaction = require("../../../../../../../shared/constants/transaction");
var _confirm = require("../../../../context/confirm");
var _useEthFiatAmount = require("../../../../../../hooks/useEthFiatAmount");
var _formatAmount = require("../../../simulation-details/formatAmount");
var _locale = require("../../../../../../ducks/locale/locale");
var _selectors = require("../../../../../../selectors");
var _useFeeCalculations = require("./useFeeCalculations");
const RATE_WEI_NATIVE = exports.RATE_WEI_NATIVE = '0xDE0B6B3A7640000'; // 1x10^18
const METAMASK_FEE_PERCENTAGE = exports.METAMASK_FEE_PERCENTAGE = 0.35;
function useGasFeeToken({
  tokenAddress
}) {
  var _gasFeeToken, _gasFeeToken2;
  const {
    currentConfirmation: transactionMeta
  } = (0, _confirm.useConfirmContext)();
  const locale = (0, _reactRedux.useSelector)(_locale.getIntlLocale);
  const nativeFeeToken = useNativeGasFeeToken();
  const {
    gasFeeTokens
  } = transactionMeta ?? {};
  let gasFeeToken = gasFeeTokens === null || gasFeeTokens === void 0 ? void 0 : gasFeeTokens.find(token => token.tokenAddress.toLowerCase() === (tokenAddress === null || tokenAddress === void 0 ? void 0 : tokenAddress.toLowerCase()));
  if (!gasFeeToken) {
    gasFeeToken = nativeFeeToken;
  }
  const {
    amount,
    decimals
  } = gasFeeToken ?? {
    amount: '0x0',
    decimals: 0
  };
  const metaMaskFee = (0, _utils.add0x)(new _bignumber.BigNumber(amount).times(METAMASK_FEE_PERCENTAGE).toString(16));
  const amountFormatted = (0, _formatAmount.formatAmount)(locale, new _bignumber.BigNumber(amount).shift(-decimals));
  const amountFiat = useFiatTokenValue(gasFeeToken, (_gasFeeToken = gasFeeToken) === null || _gasFeeToken === void 0 ? void 0 : _gasFeeToken.amount);
  const balanceFiat = useFiatTokenValue(gasFeeToken, (_gasFeeToken2 = gasFeeToken) === null || _gasFeeToken2 === void 0 ? void 0 : _gasFeeToken2.balance);
  const metamaskFeeFiat = useFiatTokenValue(gasFeeToken, metaMaskFee);
  const transferTransaction = tokenAddress === _transaction.NATIVE_TOKEN_ADDRESS ? getNativeTransferTransaction(gasFeeToken) : getTokenTransferTransaction(gasFeeToken);
  return {
    ...gasFeeToken,
    amountFormatted,
    amountFiat,
    balanceFiat,
    metaMaskFee,
    metamaskFeeFiat,
    transferTransaction
  };
}
function useSelectedGasFeeToken() {
  const {
    currentConfirmation: transactionMeta
  } = (0, _confirm.useConfirmContext)();
  const {
    selectedGasFeeToken: tokenAddress
  } = transactionMeta ?? {};
  const selectedToken = useGasFeeToken({
    tokenAddress
  });
  return tokenAddress ? selectedToken : undefined;
}
function useNativeGasFeeToken() {
  const {
    currentConfirmation: transactionMeta
  } = (0, _confirm.useConfirmContext)();
  const {
    id: transactionId,
    txParams
  } = transactionMeta ?? {};
  const {
    estimatedFeeNativeHex
  } = (0, _useFeeCalculations.useFeeCalculations)(transactionMeta !== null && transactionMeta !== void 0 && transactionMeta.txParams ? transactionMeta : {
    txParams: {}
  });
  const networkConfiguration = (0, _reactRedux.useSelector)(state => (0, _selectors.selectNetworkConfigurationByChainId)(state, transactionMeta === null || transactionMeta === void 0 ? void 0 : transactionMeta.chainId));
  const balance = (0, _reactRedux.useSelector)(state => (0, _selectors.selectTransactionAvailableBalance)(state, transactionId));
  const {
    nativeCurrency
  } = networkConfiguration ?? {};
  const {
    gas,
    maxFeePerGas,
    maxPriorityFeePerGas
  } = txParams ?? {};
  return {
    amount: estimatedFeeNativeHex,
    balance,
    decimals: 18,
    gas: gas,
    gasTransfer: '0x0',
    maxFeePerGas: maxFeePerGas,
    maxPriorityFeePerGas: maxPriorityFeePerGas,
    rateWei: RATE_WEI_NATIVE,
    recipient: _transaction.NATIVE_TOKEN_ADDRESS,
    symbol: nativeCurrency,
    tokenAddress: _transaction.NATIVE_TOKEN_ADDRESS
  };
}
function useFiatTokenValue(gasFeeToken, tokenValue) {
  const {
    decimals,
    rateWei
  } = gasFeeToken ?? {
    decimals: 0,
    rateWei: '0x0'
  };
  const nativeWei = new _bignumber.BigNumber(tokenValue ?? '0x0').shift(-decimals).mul(new _bignumber.BigNumber(rateWei));
  const nativeEth = nativeWei.shift(-18);
  const fiatValue = (0, _useEthFiatAmount.useEthFiatAmount)(nativeEth, {}, true);
  return gasFeeToken ? fiatValue : '';
}
function getTokenTransferTransaction(gasFeeToken) {
  const data = new _abi.Interface(_metamaskEthAbis.abiERC20).encodeFunctionData('transfer', [gasFeeToken.recipient, gasFeeToken.amount]);
  return {
    data,
    gas: gasFeeToken.gasTransfer,
    maxFeePerGas: gasFeeToken.maxFeePerGas,
    maxPriorityFeePerGas: gasFeeToken.maxPriorityFeePerGas,
    to: gasFeeToken.tokenAddress
  };
}
function getNativeTransferTransaction(gasFeeToken) {
  return {
    gas: gasFeeToken.gasTransfer,
    maxFeePerGas: gasFeeToken.maxFeePerGas,
    maxPriorityFeePerGas: gasFeeToken.maxPriorityFeePerGas,
    to: gasFeeToken.recipient,
    value: gasFeeToken.amount
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useGasFeeToken.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useIsUpgradeTransaction.ts", {"../../../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","../../../../hooks/useEIP7702Account":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useEIP7702Account.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Chooks%5CuseIsUpgradeTransaction.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsDowngradeTransaction = useIsDowngradeTransaction;
exports.useIsUpgradeTransaction = useIsUpgradeTransaction;
var _confirm = require("../../../../context/confirm");
var _useEIP7702Account = require("../../../../hooks/useEIP7702Account");
function useIsUpgradeTransaction() {
  const authorizationAddress = useTransactionAuthorizationAddress();
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const {
    txParams
  } = currentConfirmation ?? {
    txParams: {}
  };
  const {
    data
  } = txParams ?? {};
  const isUpgrade = Boolean(authorizationAddress) && authorizationAddress !== _useEIP7702Account.EIP_7702_REVOKE_ADDRESS;
  return {
    isUpgrade,
    isUpgradeOnly: isUpgrade && (!data || data === '0x')
  };
}
function useIsDowngradeTransaction() {
  const authorizationAddress = useTransactionAuthorizationAddress();
  return Boolean(authorizationAddress) && authorizationAddress === _useEIP7702Account.EIP_7702_REVOKE_ADDRESS;
}
function useTransactionAuthorizationAddress() {
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const {
    txParams
  } = currentConfirmation ?? {};
  const {
    authorizationList
  } = txParams ?? {};
  const authorization = authorizationList === null || authorizationList === void 0 ? void 0 : authorizationList[0];
  return authorization === null || authorization === void 0 ? void 0 : authorization.address;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useIsUpgradeTransaction.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useMaxValueRefresher.ts", {"../../../../../../../shared/modules/Numeric":"D:\\code\\v\\metamask-extension\\shared\\modules\\Numeric.ts","../../../../../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","../../../../hooks/useTransactionEventFragment":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useTransactionEventFragment.js","../shared/constants":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\shared\\constants.ts","./useSupportsEIP1559":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useSupportsEIP1559.ts","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Chooks%5CuseMaxValueRefresher.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMaxValueRefresher = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _transactionController = require("@metamask/transaction-controller");
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _selectors = require("../../../../../../selectors");
var _conversion = require("../../../../../../../shared/modules/conversion.utils");
var _Numeric = require("../../../../../../../shared/modules/Numeric");
var _actions = require("../../../../../../store/actions");
var _confirm = require("../../../../context/confirm");
var _constants = require("../shared/constants");
var _useTransactionEventFragment = require("../../../../hooks/useTransactionEventFragment");
var _useSupportsEIP = require("./useSupportsEIP1559");
/**
 * A hook that automatically refreshes the transaction value when the user is in "max amount" mode.
 *
 * This hook monitors the transaction state and recalculates the maximum sendable amount by subtracting
 * the estimated gas fees from the account balance. It only operates on `simpleSend` transaction types
 * when max amount mode is enabled.
 *
 * - Only affects transactions of type `TransactionType.simpleSend`
 * - Supports both legacy gas pricing and EIP-1559 fee structures
 * - Handles Layer 1 gas fees for Layer 2 network transactions
 * - Does not update the value if the remaining balance would be negative or zero
 *
 * @requires useConfirmContext - Must be used within a confirmation context
 * @requires Redux store - Requires access to account balance and transaction state
 */
const useMaxValueRefresher = () => {
  var _crossChainNativeBala;
  const {
    currentConfirmation: transactionMeta
  } = (0, _confirm.useConfirmContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    chainId,
    id: transactionId,
    txParams: {
      from
    }
  } = transactionMeta;
  const isMaxAmountMode = (0, _reactRedux.useSelector)(state => (0, _selectors.selectMaxValueModeForTransaction)(state, transactionMeta === null || transactionMeta === void 0 ? void 0 : transactionMeta.id));
  const {
    updateTransactionEventFragment
  } = (0, _useTransactionEventFragment.useTransactionEventFragment)();
  const [searchParams] = (0, _reactRouterDomV5Compat.useSearchParams)();
  const paramMaxValueMode = searchParams.get('maxValueMode') === 'true';
  const isMaxValueMode = isMaxAmountMode || paramMaxValueMode;
  const crossChainNativeBalances = (0, _reactRedux.useSelector)(_selectors.getCrossChainMetaMaskCachedBalances);
  const balance = (crossChainNativeBalances === null || crossChainNativeBalances === void 0 || (_crossChainNativeBala = crossChainNativeBalances[chainId]) === null || _crossChainNativeBala === void 0 ? void 0 : _crossChainNativeBala[from]) ?? _constants.HEX_ZERO;
  const {
    supportsEIP1559
  } = (0, _useSupportsEIP.useSupportsEIP1559)(transactionMeta);
  const gas = transactionMeta.txParams.gas || _constants.HEX_ZERO;
  const gasPrice = transactionMeta.txParams.gasPrice || _constants.HEX_ZERO;
  const maxFeePerGas = transactionMeta.txParams.maxFeePerGas || _constants.HEX_ZERO;
  const layer1GasFee = transactionMeta.layer1GasFee;
  (0, _react.useEffect)(() => {
    updateTransactionEventFragment({
      properties: {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        is_send_max: isMaxValueMode
      }
    }, transactionId);
  }, [isMaxValueMode, transactionId]);
  (0, _react.useEffect)(() => {
    if (!isMaxValueMode || transactionMeta.type !== _transactionController.TransactionType.simpleSend) {
      return;
    }
    let gasFeeInHex = (0, _conversion.multiplyHexes)(gas, supportsEIP1559 ? maxFeePerGas : gasPrice);
    if (layer1GasFee) {
      gasFeeInHex = (0, _conversion.addHexes)(gasFeeInHex, layer1GasFee);
    }
    const remainingBalance = new _Numeric.Numeric(balance || _constants.HEX_ZERO, 16).minus(new _Numeric.Numeric(gasFeeInHex, 16));

    // If the remaining balance is negative or zero, do nothing
    if (remainingBalance.isNegative() || remainingBalance.isZero()) {
      return;
    }
    dispatch((0, _actions.updateEditableParams)(transactionMeta.id, {
      value: remainingBalance.toPrefixedHexString()
    }));
  }, [isMaxValueMode, balance, gas, gasPrice, maxFeePerGas, supportsEIP1559, layer1GasFee, dispatch, transactionMeta]);
};
exports.useMaxValueRefresher = useMaxValueRefresher;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useMaxValueRefresher.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useNestedTransactionLabels.ts", {"../../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","./useFourByte":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useFourByte.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Chooks%5CuseNestedTransactionLabels.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNestedTransactionLabels = useNestedTransactionLabels;
var _useI18nContext = require("../../../../../../hooks/useI18nContext");
var _useFourByte = require("./useFourByte");
function useNestedTransactionLabels({
  nestedTransactions = [],
  useIndex
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  return nestedTransactions === null || nestedTransactions === void 0 ? void 0 : nestedTransactions.map((nestedTransaction, index) => {
    const {
      data,
      to
    } = nestedTransaction;
    // It's safe to call useFourByte here because the length of nestedTransactions
    // remains stable throughout the component's lifecycle.
    const methodData = (0, _useFourByte.useFourByte)({
      data,
      to
    });
    const functionName = methodData === null || methodData === void 0 ? void 0 : methodData.name;
    return functionName ?? t('confirmNestedTransactionTitle', [String((useIndex ?? index) + 1)]);
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useNestedTransactionLabels.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useSendingValueMetric.ts", {"../../../../hooks/useTransactionEventFragment":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useTransactionEventFragment.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Chooks%5CuseSendingValueMetric.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSendingValueMetric = void 0;
var _react = require("react");
var _useTransactionEventFragment = require("../../../../hooks/useTransactionEventFragment");
const useSendingValueMetric = ({
  transactionMeta,
  fiatValue
}) => {
  const {
    updateTransactionEventFragment
  } = (0, _useTransactionEventFragment.useTransactionEventFragment)();
  const transactionId = transactionMeta.id;
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
  // eslint-disable-next-line @typescript-eslint/naming-convention
  const properties = {
    sending_value: fiatValue
  };
  const sensitiveProperties = {};
  const params = {
    properties,
    sensitiveProperties
  };
  (0, _react.useEffect)(() => {
    if (fiatValue !== undefined && fiatValue !== '') {
      updateTransactionEventFragment(params, transactionId);
    }
  }, [updateTransactionEventFragment, transactionId, JSON.stringify(params)]);
};
exports.useSendingValueMetric = useSendingValueMetric;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useSendingValueMetric.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useSupportsEIP1559.ts", {"../../../../../../helpers/utils/transactions.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\transactions.util.js","../../../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Chooks%5CuseSupportsEIP1559.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSupportsEIP1559 = useSupportsEIP1559;
var _transactionController = require("@metamask/transaction-controller");
var _reactRedux = require("react-redux");
var _transactions = require("../../../../../../helpers/utils/transactions.util");
var _selectors = require("../../../../../../selectors");
function useSupportsEIP1559(transactionMeta) {
  const {
    networkClientId,
    txParams
  } = transactionMeta ?? {};
  const isLegacyTxn = (txParams === null || txParams === void 0 ? void 0 : txParams.type) === _transactionController.TransactionEnvelopeType.legacy || (0, _transactions.isLegacyTransaction)(transactionMeta);
  const networkAndAccountSupports1559 = (0, _reactRedux.useSelector)(state => (0, _selectors.checkNetworkAndAccountSupports1559)(state, networkClientId));
  const supportsEIP1559 = networkAndAccountSupports1559 && !isLegacyTxn;
  return {
    supportsEIP1559
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useSupportsEIP1559.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useTokenDetails.ts", {"../../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Chooks%5CuseTokenDetails.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTokenDetails = void 0;
var _reactRedux = require("react-redux");
var _useI18nContext = require("../../../../../../hooks/useI18nContext");
var _selectors = require("../../../../../../selectors");
const useTokenDetails = transactionMeta => {
  var _tokenList, _transactionMeta$txPa, _tokenList2, _transactionMeta$txPa2;
  const t = (0, _useI18nContext.useI18nContext)();
  const selectedToken = (0, _reactRedux.useSelector)(state => (0, _selectors.getWatchedToken)(transactionMeta)(state));
  const tokenList = (0, _reactRedux.useSelector)(_selectors.getTokenList);
  const tokenImage = (selectedToken === null || selectedToken === void 0 ? void 0 : selectedToken.iconUrl) || (selectedToken === null || selectedToken === void 0 ? void 0 : selectedToken.image) || ((_tokenList = tokenList[transactionMeta === null || transactionMeta === void 0 || (_transactionMeta$txPa = transactionMeta.txParams) === null || _transactionMeta$txPa === void 0 ? void 0 : _transactionMeta$txPa.to]) === null || _tokenList === void 0 ? void 0 : _tokenList.iconUrl);
  const tokenSymbol = (selectedToken === null || selectedToken === void 0 ? void 0 : selectedToken.symbol) || ((_tokenList2 = tokenList[transactionMeta === null || transactionMeta === void 0 || (_transactionMeta$txPa2 = transactionMeta.txParams) === null || _transactionMeta$txPa2 === void 0 ? void 0 : _transactionMeta$txPa2.to]) === null || _tokenList2 === void 0 ? void 0 : _tokenList2.symbol) || t('unknown');
  return {
    tokenImage,
    tokenSymbol
  };
};
exports.useTokenDetails = useTokenDetails;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useTokenDetails.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useTokenTransactionData.ts", {"../../../../../../../shared/modules/transaction.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\transaction.utils.ts","../../../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Chooks%5CuseTokenTransactionData.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTokenTransactionData = useTokenTransactionData;
var _confirm = require("../../../../context/confirm");
var _transaction = require("../../../../../../../shared/modules/transaction.utils");
function useTokenTransactionData() {
  var _currentConfirmation$;
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const transactionData = currentConfirmation === null || currentConfirmation === void 0 || (_currentConfirmation$ = currentConfirmation.txParams) === null || _currentConfirmation$ === void 0 ? void 0 : _currentConfirmation$.data;
  if (!transactionData) {
    return undefined;
  }
  return (0, _transaction.parseStandardTokenTransactionData)(transactionData);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useTokenTransactionData.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useTransactionGasFeeEstimate.ts", {"../../../../../../../shared/modules/Numeric":"D:\\code\\v\\metamask-extension\\shared\\modules\\Numeric.ts","../../../../../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../../../../../hooks/useGasFeeEstimates":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useGasFeeEstimates.js","../shared/constants":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\shared\\constants.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Chooks%5CuseTransactionGasFeeEstimate.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTransactionGasFeeEstimate = useTransactionGasFeeEstimate;
var _conversion = require("../../../../../../../shared/modules/conversion.utils");
var _Numeric = require("../../../../../../../shared/modules/Numeric");
var _useGasFeeEstimates = require("../../../../../../hooks/useGasFeeEstimates");
var _constants = require("../shared/constants");
function useTransactionGasFeeEstimate(transactionMeta, supportsEIP1559) {
  var _transactionMeta$txPa, _transactionMeta$txPa2;
  let {
    gas: gasLimit,
    gasPrice
  } = transactionMeta.txParams;
  const {
    gasFeeEstimates
  } = (0, _useGasFeeEstimates.useGasFeeEstimates)(transactionMeta.networkClientId);
  const estimatedBaseFee = gasFeeEstimates === null || gasFeeEstimates === void 0 ? void 0 : gasFeeEstimates.estimatedBaseFee;

  // override with values from `dappSuggestedGasFees` if they exist
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  gasLimit = gasLimit || _constants.HEX_ZERO;
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  gasPrice = gasPrice || _constants.HEX_ZERO;
  const maxPriorityFeePerGas =
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  ((_transactionMeta$txPa = transactionMeta.txParams) === null || _transactionMeta$txPa === void 0 ? void 0 : _transactionMeta$txPa.maxPriorityFeePerGas) || _constants.HEX_ZERO;
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  const maxFeePerGas = ((_transactionMeta$txPa2 = transactionMeta.txParams) === null || _transactionMeta$txPa2 === void 0 ? void 0 : _transactionMeta$txPa2.maxFeePerGas) || _constants.HEX_ZERO;
  let gasEstimate;
  if (supportsEIP1559) {
    const estimatedBaseFeeWeiHex = (0, _conversion.decGWEIToHexWEI)(estimatedBaseFee);

    // Minimum Total Fee = (estimatedBaseFee + maxPriorityFeePerGas) * gasLimit
    let minimumFeePerGas = (0, _conversion.addHexes)(estimatedBaseFeeWeiHex || _constants.HEX_ZERO, maxPriorityFeePerGas);

    // `minimumFeePerGas` should never be higher than the `maxFeePerGas`
    if (new _Numeric.Numeric(minimumFeePerGas, 16).greaterThan(maxFeePerGas, 16)) {
      minimumFeePerGas = maxFeePerGas;
    }
    gasEstimate = (0, _conversion.multiplyHexes)(minimumFeePerGas, gasLimit);
  } else {
    gasEstimate = (0, _conversion.multiplyHexes)(gasPrice, gasLimit);
  }
  return gasEstimate;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useTransactionGasFeeEstimate.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useTransferRecipient.ts", {"../../../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","./useTokenTransactionData":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useTokenTransactionData.ts","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Chooks%5CuseTransferRecipient.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTransferRecipient = useTransferRecipient;
var _transactionController = require("@metamask/transaction-controller");
var _confirm = require("../../../../context/confirm");
var _useTokenTransactionData = require("./useTokenTransactionData");
function useTransferRecipient() {
  var _transactionMetadata$, _transactionData$args, _transactionData$args2;
  const {
    currentConfirmation: transactionMetadata
  } = (0, _confirm.useConfirmContext)();
  const transactionData = (0, _useTokenTransactionData.useTokenTransactionData)();
  const transactionType = transactionMetadata === null || transactionMetadata === void 0 ? void 0 : transactionMetadata.type;
  const transactionTo = transactionMetadata === null || transactionMetadata === void 0 || (_transactionMetadata$ = transactionMetadata.txParams) === null || _transactionMetadata$ === void 0 ? void 0 : _transactionMetadata$.to;
  const transferTo =
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  (transactionData === null || transactionData === void 0 || (_transactionData$args = transactionData.args) === null || _transactionData$args === void 0 ? void 0 : _transactionData$args._to) || (transactionData === null || transactionData === void 0 || (_transactionData$args2 = transactionData.args) === null || _transactionData$args2 === void 0 ? void 0 : _transactionData$args2.to);
  return transactionType === _transactionController.TransactionType.simpleSend ? transactionTo : transferTo;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useTransferRecipient.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\index.ts", {"./info":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\info.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "Info", {
  enumerable: true,
  get: function () {
    return _info.default;
  }
});
var _info = _interopRequireDefault(require("./info"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\info.tsx", {"../../../../../../shared/modules/environment":"D:\\code\\v\\metamask-extension\\shared\\modules\\environment.ts","../../../../trust-signals/hooks/useTrustSignalMetrics":"D:\\code\\v\\metamask-extension\\ui\\pages\\trust-signals\\hooks\\useTrustSignalMetrics.ts","../../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","../../../hooks/useSmartTransactionFeatureFlags":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useSmartTransactionFeatureFlags.ts","../../../hooks/useTransactionFocusEffect":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useTransactionFocusEffect.ts","./approve/approve":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\approve\\approve.tsx","./base-transaction-info/base-transaction-info":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\base-transaction-info\\base-transaction-info.tsx","./native-transfer/native-transfer":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\native-transfer\\native-transfer.tsx","./nft-token-transfer/nft-token-transfer":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\nft-token-transfer\\nft-token-transfer.tsx","./personal-sign/personal-sign":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\personal-sign\\personal-sign.tsx","./set-approval-for-all-info/set-approval-for-all-info":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\set-approval-for-all-info\\set-approval-for-all-info.tsx","./shield-subscription-approve/shield-subscription-approve":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\shield-subscription-approve\\shield-subscription-approve.tsx","./token-transfer/token-transfer":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\token-transfer\\token-transfer.tsx","./typed-sign-v1/typed-sign-v1":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\typed-sign-v1\\typed-sign-v1.tsx","./typed-sign/typed-sign":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\typed-sign\\typed-sign.tsx","./typed-sign/typed-sign-permission":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\typed-sign\\typed-sign-permission.tsx","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Cinfo.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _transactionController = require("@metamask/transaction-controller");
var _react = _interopRequireWildcard(require("react"));
var _environment = require("../../../../../../shared/modules/environment");
var _useTrustSignalMetrics = require("../../../../trust-signals/hooks/useTrustSignalMetrics");
var _confirm = require("../../../context/confirm");
var _useSmartTransactionFeatureFlags = require("../../../hooks/useSmartTransactionFeatureFlags");
var _useTransactionFocusEffect = require("../../../hooks/useTransactionFocusEffect");
var _approve = _interopRequireDefault(require("./approve/approve"));
var _baseTransactionInfo = _interopRequireDefault(require("./base-transaction-info/base-transaction-info"));
var _nativeTransfer = _interopRequireDefault(require("./native-transfer/native-transfer"));
var _nftTokenTransfer = _interopRequireDefault(require("./nft-token-transfer/nft-token-transfer"));
var _personalSign = _interopRequireDefault(require("./personal-sign/personal-sign"));
var _setApprovalForAllInfo = _interopRequireDefault(require("./set-approval-for-all-info/set-approval-for-all-info"));
var _shieldSubscriptionApprove = _interopRequireDefault(require("./shield-subscription-approve/shield-subscription-approve"));
var _tokenTransfer = _interopRequireDefault(require("./token-transfer/token-transfer"));
var _typedSignV = _interopRequireDefault(require("./typed-sign-v1/typed-sign-v1"));
var _typedSign = _interopRequireDefault(require("./typed-sign/typed-sign"));
var _typedSignPermission = _interopRequireDefault(require("./typed-sign/typed-sign-permission"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Info = () => {
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();

  // TODO: Create TransactionInfo and SignatureInfo components.
  (0, _useSmartTransactionFeatureFlags.useSmartTransactionFeatureFlags)();
  (0, _useTransactionFocusEffect.useTransactionFocusEffect)();
  (0, _useTrustSignalMetrics.useTrustSignalMetrics)();
  const ConfirmationInfoComponentMap = (0, _react.useMemo)(() => ({
    [_transactionController.TransactionType.batch]: () => _baseTransactionInfo.default,
    [_transactionController.TransactionType.contractInteraction]: () => _baseTransactionInfo.default,
    [_transactionController.TransactionType.deployContract]: () => _baseTransactionInfo.default,
    [_transactionController.TransactionType.personalSign]: () => _personalSign.default,
    [_transactionController.TransactionType.revokeDelegation]: () => _baseTransactionInfo.default,
    [_transactionController.TransactionType.simpleSend]: () => _nativeTransfer.default,
    [_transactionController.TransactionType.shieldSubscriptionApprove]: () => _shieldSubscriptionApprove.default,
    [_transactionController.TransactionType.signTypedData]: () => {
      const signatureRequest = currentConfirmation;
      const {
        version
      } = (signatureRequest === null || signatureRequest === void 0 ? void 0 : signatureRequest.msgParams) ?? {};
      if (version === 'V1') {
        return _typedSignV.default;
      }
      if (signatureRequest !== null && signatureRequest !== void 0 && signatureRequest.decodedPermission) {
        if (!(0, _environment.isGatorPermissionsFeatureEnabled)()) {
          throw new Error('Gator permissions feature is not enabled');
        }
        return _typedSignPermission.default;
      }
      return _typedSign.default;
    },
    [_transactionController.TransactionType.tokenMethodApprove]: () => _approve.default,
    [_transactionController.TransactionType.tokenMethodIncreaseAllowance]: () => _approve.default,
    [_transactionController.TransactionType.tokenMethodSafeTransferFrom]: () => _nftTokenTransfer.default,
    [_transactionController.TransactionType.tokenMethodSetApprovalForAll]: () => _setApprovalForAllInfo.default,
    [_transactionController.TransactionType.tokenMethodTransfer]: () => _tokenTransfer.default,
    [_transactionController.TransactionType.tokenMethodTransferFrom]: () => _nftTokenTransfer.default
  }), [currentConfirmation]);
  if (!(currentConfirmation !== null && currentConfirmation !== void 0 && currentConfirmation.type)) {
    return null;
  }
  const InfoComponent = ConfirmationInfoComponentMap[currentConfirmation === null || currentConfirmation === void 0 ? void 0 : currentConfirmation.type]();
  return /*#__PURE__*/_react.default.createElement(InfoComponent, null);
};
var _default = exports.default = Info;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\info.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\native-transfer\\native-transfer.tsx", {"../../../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","../../../simulation-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\simulation-details\\index.ts","../hooks/useMaxValueRefresher":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useMaxValueRefresher.ts","../shared/advanced-details/advanced-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\shared\\advanced-details\\advanced-details.tsx","../shared/gas-fees-section/gas-fees-section":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\shared\\gas-fees-section\\gas-fees-section.tsx","../shared/native-send-heading/native-send-heading":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\shared\\native-send-heading\\native-send-heading.tsx","../token-transfer/token-details-section":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\token-transfer\\token-details-section.tsx","../token-transfer/transaction-flow-section":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\token-transfer\\transaction-flow-section.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Cnative-transfer%5Cnative-transfer.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _confirm = require("../../../../context/confirm");
var _simulationDetails = require("../../../simulation-details");
var _advancedDetails = require("../shared/advanced-details/advanced-details");
var _gasFeesSection = require("../shared/gas-fees-section/gas-fees-section");
var _nativeSendHeading = _interopRequireDefault(require("../shared/native-send-heading/native-send-heading"));
var _tokenDetailsSection = require("../token-transfer/token-details-section");
var _transactionFlowSection = require("../token-transfer/transaction-flow-section");
var _useMaxValueRefresher = require("../hooks/useMaxValueRefresher");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const NativeTransferInfo = () => {
  const {
    currentConfirmation: transactionMeta
  } = (0, _confirm.useConfirmContext)();
  (0, _useMaxValueRefresher.useMaxValueRefresher)();
  const isWalletInitiated = transactionMeta.origin === 'metamask';
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_nativeSendHeading.default, null), /*#__PURE__*/_react.default.createElement(_transactionFlowSection.TransactionFlowSection, null), /*#__PURE__*/_react.default.createElement(_simulationDetails.SimulationDetails, {
    transaction: transactionMeta,
    isTransactionsRedesign: true,
    enableMetrics: true,
    metricsOnly: isWalletInitiated
  }), /*#__PURE__*/_react.default.createElement(_tokenDetailsSection.TokenDetailsSection, null), /*#__PURE__*/_react.default.createElement(_gasFeesSection.GasFeesSection, null), /*#__PURE__*/_react.default.createElement(_advancedDetails.AdvancedDetails, null));
};
var _default = exports.default = NativeTransferInfo;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\native-transfer\\native-transfer.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\nft-token-transfer\\nft-token-transfer.tsx", {"../../../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","../../../simulation-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\simulation-details\\index.ts","../shared/advanced-details/advanced-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\shared\\advanced-details\\advanced-details.tsx","../shared/gas-fees-section/gas-fees-section":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\shared\\gas-fees-section\\gas-fees-section.tsx","../shared/nft-send-heading/nft-send-heading":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\shared\\nft-send-heading\\nft-send-heading.tsx","../token-transfer/token-details-section":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\token-transfer\\token-details-section.tsx","../token-transfer/transaction-flow-section":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\token-transfer\\transaction-flow-section.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Cnft-token-transfer%5Cnft-token-transfer.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _confirm = require("../../../../context/confirm");
var _simulationDetails = require("../../../simulation-details");
var _advancedDetails = require("../shared/advanced-details/advanced-details");
var _gasFeesSection = require("../shared/gas-fees-section/gas-fees-section");
var _nftSendHeading = _interopRequireDefault(require("../shared/nft-send-heading/nft-send-heading"));
var _tokenDetailsSection = require("../token-transfer/token-details-section");
var _transactionFlowSection = require("../token-transfer/transaction-flow-section");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const NFTTokenTransferInfo = () => {
  const {
    currentConfirmation: transactionMeta
  } = (0, _confirm.useConfirmContext)();
  const isWalletInitiated = transactionMeta.origin === 'metamask';
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_nftSendHeading.default, null), /*#__PURE__*/_react.default.createElement(_transactionFlowSection.TransactionFlowSection, null), /*#__PURE__*/_react.default.createElement(_simulationDetails.SimulationDetails, {
    transaction: transactionMeta,
    isTransactionsRedesign: true,
    enableMetrics: true,
    metricsOnly: isWalletInitiated
  }), /*#__PURE__*/_react.default.createElement(_tokenDetailsSection.TokenDetailsSection, null), /*#__PURE__*/_react.default.createElement(_gasFeesSection.GasFeesSection, null), /*#__PURE__*/_react.default.createElement(_advancedDetails.AdvancedDetails, null));
};
var _default = exports.default = NFTTokenTransferInfo;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\nft-token-transfer\\nft-token-transfer.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\personal-sign\\personal-sign.tsx", {"../../../../../../components/app/confirm/info/row":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\index.ts","../../../../../../components/app/confirm/info/row/alert-row/alert-row":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\alert-row\\alert-row.tsx","../../../../../../components/app/confirm/info/row/constants":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\constants.ts","../../../../../../components/app/confirm/info/row/section":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\section.tsx","../../../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../../../components/ui/tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\index.js","../../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","../../../../hooks/useIsBIP44":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useIsBIP44.ts","../../../../selectors/preferences":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\selectors\\preferences.ts","../../../../utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\utils\\index.ts","../shared/network-row/network-row":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\shared\\network-row\\network-row.tsx","../shared/sign-in-with-row/sign-in-with-row":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\shared\\sign-in-with-row\\sign-in-with-row.tsx","../utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\utils.ts","./siwe-sign":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\personal-sign\\siwe-sign\\index.ts","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Cpersonal-sign%5Cpersonal-sign.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _snapsUtils = require("@metamask/snaps-utils");
var _row = require("../../../../../../components/app/confirm/info/row");
var _alertRow = require("../../../../../../components/app/confirm/info/row/alert-row/alert-row");
var _constants = require("../../../../../../components/app/confirm/info/row/constants");
var _section = require("../../../../../../components/app/confirm/info/row/section");
var _componentLibrary = require("../../../../../../components/component-library");
var _tooltip = _interopRequireDefault(require("../../../../../../components/ui/tooltip"));
var _designSystem = require("../../../../../../helpers/constants/design-system");
var _util = require("../../../../../../helpers/utils/util");
var _useI18nContext = require("../../../../../../hooks/useI18nContext");
var _confirm = require("../../../../context/confirm");
var _preferences = require("../../../../selectors/preferences");
var _utils = require("../../../../utils");
var _useIsBIP = require("../../../../hooks/useIsBIP44");
var _networkRow = require("../shared/network-row/network-row");
var _signInWithRow = require("../shared/sign-in-with-row/sign-in-with-row");
var _utils2 = require("../utils");
var _siweSign = require("./siwe-sign");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const getMessageText = hexString => {
  if (!hexString) {
    return hexString;
  }
  const messageText = (0, _util.sanitizeString)((0, _util.hexToText)(hexString));
  return (0, _utils2.isValidUTF8)(messageText) ? messageText : hexString;
};
const PersonalSignInfo = () => {
  var _currentConfirmation$;
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const useTransactionSimulations = (0, _reactRedux.useSelector)(_preferences.selectUseTransactionSimulations);
  const isBIP44 = (0, _useIsBIP.useIsBIP44)();
  if (!(currentConfirmation !== null && currentConfirmation !== void 0 && currentConfirmation.msgParams)) {
    return null;
  }
  const isSIWE = (0, _utils.isSIWESignatureRequest)(currentConfirmation);
  const messageText = getMessageText((_currentConfirmation$ = currentConfirmation.msgParams) === null || _currentConfirmation$ === void 0 ? void 0 : _currentConfirmation$.data);
  let toolTipMessage;
  if (!isSIWE) {
    if ((0, _snapsUtils.isSnapId)(currentConfirmation.msgParams.origin)) {
      toolTipMessage = t('requestFromInfoSnap');
    } else {
      toolTipMessage = t('requestFromInfo');
    }
  }
  const SimulationDetailsKey = /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    alignItems: _designSystem.AlignItems.center,
    gap: 1
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium
  }, t('simulationDetailsTitle')), /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    interactive: true,
    position: "top",
    containerClassName: "info-tooltip__tooltip-container",
    tooltipInnerClassName: "info-tooltip__tooltip-content",
    tooltipArrowClassName: "info-tooltip__top-tooltip-arrow",
    html: t('simulationDetailsTitleTooltip'),
    theme: "tippy-tooltip-info",
    style: {
      display: _designSystem.Display.Flex
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.Question,
    marginLeft: 1,
    color: _designSystem.IconColor.iconMuted,
    size: _componentLibrary.IconSize.Sm
  })));
  const SimulationDetailsValue = /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textAlternative,
    variant: _designSystem.TextVariant.bodyMd
  }, t('simulationDetailsNoChanges'));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isSIWE && useTransactionSimulations && /*#__PURE__*/_react.default.createElement(_section.ConfirmInfoSection, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    "data-testid": "simulation-details-layout",
    className: "simulation-details-layout",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    borderRadius: _designSystem.BorderRadius.LG,
    borderColor: _designSystem.BorderColor.transparent,
    padding: 2,
    gap: 3
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, SimulationDetailsKey, SimulationDetailsValue))), /*#__PURE__*/_react.default.createElement(_section.ConfirmInfoSection, null, /*#__PURE__*/_react.default.createElement(_networkRow.NetworkRow, {
    isShownWithAlertsOnly: !isBIP44
  }), /*#__PURE__*/_react.default.createElement(_alertRow.ConfirmInfoAlertRow, {
    alertKey: _constants.RowAlertKey.RequestFrom,
    ownerId: currentConfirmation.id,
    label: t('requestFrom'),
    tooltip: toolTipMessage
  }, /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRowUrl, {
    url: currentConfirmation.msgParams.origin
  })), /*#__PURE__*/_react.default.createElement(_signInWithRow.SigningInWithRow, null)), /*#__PURE__*/_react.default.createElement(_section.ConfirmInfoSection, null, isSIWE ? /*#__PURE__*/_react.default.createElement(_siweSign.SIWESignInfo, null) : /*#__PURE__*/_react.default.createElement(_alertRow.ConfirmInfoAlertRow, {
    alertKey: "message",
    ownerId: currentConfirmation.id,
    label: t('message'),
    collapsed: false,
    copyEnabled: true,
    copyText: messageText
  }, /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRowText, {
    text: messageText
  }))));
};
var _default = exports.default = PersonalSignInfo;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\personal-sign\\personal-sign.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\personal-sign\\siwe-sign\\index.ts", {"./siwe-sign":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\personal-sign\\siwe-sign\\siwe-sign.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Cpersonal-sign%5Csiwe-sign%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "SIWESignInfo", {
  enumerable: true,
  get: function () {
    return _siweSign.default;
  }
});
var _siweSign = _interopRequireDefault(require("./siwe-sign"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\personal-sign\\siwe-sign\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\personal-sign\\siwe-sign\\siwe-sign.tsx", {"../../../../../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../../../../components/app/confirm/info/row":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\index.ts","../../../../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","luxon":"D:\\code\\v\\metamask-extension\\node_modules\\luxon\\build\\cjs-browser\\luxon.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Cpersonal-sign%5Csiwe-sign%5Csiwe-sign.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _luxon = require("luxon");
var _controllerUtils = require("@metamask/controller-utils");
var _network = require("../../../../../../../../shared/constants/network");
var _useI18nContext = require("../../../../../../../hooks/useI18nContext");
var _row = require("../../../../../../../components/app/confirm/info/row");
var _componentLibrary = require("../../../../../../../components/component-library");
var _designSystem = require("../../../../../../../helpers/constants/design-system");
var _confirm = require("../../../../../context/confirm");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const SIWESignInfo = () => {
  var _currentConfirmation$;
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const siweMessage = currentConfirmation === null || currentConfirmation === void 0 || (_currentConfirmation$ = currentConfirmation.msgParams) === null || _currentConfirmation$ === void 0 || (_currentConfirmation$ = _currentConfirmation$.siwe) === null || _currentConfirmation$ === void 0 ? void 0 : _currentConfirmation$.parsedMessage;
  if (!siweMessage) {
    return null;
  }
  const {
    address,
    chainId,
    issuedAt,
    nonce,
    requestId,
    statement,
    resources,
    uri,
    version
  } = siweMessage;
  const hexChainId = (0, _controllerUtils.toHex)(chainId);
  const network = _network.NETWORK_TO_NAME_MAP[hexChainId] ?? hexChainId;
  return /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRow, {
    label: t('message'),
    collapsed: false,
    copyEnabled: true,
    copyText: JSON.stringify(siweMessage)
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    width: _designSystem.BlockSize.Full,
    className: "siwe-sign__message-rows"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.inherit,
    style: {
      whiteSpace: 'pre-wrap'
    }
  }, statement ?? ''), /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRow, {
    label: t('siweURI')
  }, /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRowText, {
    text: uri
  })), /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRow, {
    label: t('siweNetwork')
  }, /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRowText, {
    text: network
  })), /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRow, {
    label: t('account')
  }, /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRowAddress, {
    address: address,
    chainId: hexChainId
  })), /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRow, {
    label: t('version')
  }, /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRowText, {
    text: version
  })), /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRow, {
    label: t('chainId')
  }, /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRowText, {
    text: `${chainId}`
  })), /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRow, {
    label: t('nonce')
  }, /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRowText, {
    text: nonce
  })), /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRow, {
    label: t('siweIssued')
  }, /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRowDate, {
    unixTimestamp: _luxon.DateTime.fromISO(issuedAt, {
      zone: 'utc'
    }).toUnixInteger()
  })), requestId && /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRow, {
    label: t('siweRequestId')
  }, /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRowText, {
    text: requestId
  })), resources && /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRow, {
    label: t('siweResources')
  }, resources.map((resource, index) => /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRowText, {
    key: `resource-${index}`,
    text: resource
  })))));
};
var _default = exports.default = SIWESignInfo;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\personal-sign\\siwe-sign\\siwe-sign.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\set-approval-for-all-info\\revoke-set-approval-for-all-static-simulation\\revoke-set-approval-for-all-static-simulation.tsx", {"../../../../../../../components/app/confirm/info/row":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\index.ts","../../../../../../../components/app/name":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\name\\index.ts","../../../../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","../../shared/static-simulation/static-simulation":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\shared\\static-simulation\\static-simulation.tsx","@metamask/name-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\name-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ccomponents%5Cconfirm%5Cinfo%5Cset-approval-for-all-info%5Crevoke-set-approval-for-all-static-simulation%5Crevoke-set-approval-for-all-static-simulation.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RevokeSetApprovalForAllStaticSimulation = void 0;
var _nameController = require("@metamask/name-controller");
var _react = _interopRequireDefault(require("react"));
var _row = require("../../../../../../../components/app/confirm/info/row");
var _name = _interopRequireDefault(require("../../../../../../../components/app/name"));
var _componentLibrary = require("../../../../../../../components/component-library");
var _designSystem = require("../../../../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../../../../hooks/useI18nContext");
var _confirm = require("../../../../../context/confirm");
var _staticSimulation = _interopRequireDefault(require("../../shared/static-simulation/static-simulation"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const RevokeSetApprovalForAllStaticSimulation = ({
  spender
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    currentConfirmation: transactionMeta
  } = (0, _confirm.useConfirmContext)();
  const {
    chainId
  } = transactionMeta;
  const nftsRow = /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRow, {
    label: t('nfts')
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    style: {
      marginLeft: 'auto',
      maxWidth: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_name.default, {
    value: transactionMeta.txParams.to,
    type: _nameController.NameType.ETHEREUM_ADDRESS,
    preferContractSymbol: true,
    variation: chainId
  }))));
  const permissionFromRow = /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRow, {
    label: t('permissionFrom')
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    style: {
      marginLeft: 'auto',
      maxWidth: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_name.default, {
    value: spender,
    type: _nameController.NameType.ETHEREUM_ADDRESS,
    preferContractSymbol: true,
    variation: chainId
  }))));
  const RevokeSetApprovalForAllRows = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, nftsRow, permissionFromRow);
  const simulationElements = RevokeSetApprovalForAllRows;
  return /*#__PURE__*/_react.default.createElement(_staticSimulation.default, {
    title: t('simulationDetailsTitle'),
    titleTooltip: t('simulationDetailsTitleTooltip'),
    description: t('simulationDetailsRevokeSetApprovalForAllDesc'),
    simulationElements: simulationElements
  });
};
exports.RevokeSetApprovalForAllStaticSimulation = RevokeSetApprovalForAllStaticSimulation;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\components\\confirm\\info\\set-approval-for-all-info\\revoke-set-approval-for-all-static-simulation\\revoke-set-approval-for-all-static-simulation.tsx",}]],[],{})

//# sourceMappingURL=data:application/json;charset=utf8;base64,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