LavaPack.loadBundle([
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\transactions\\useMultipleApprovalsAlerts.ts", {"../../../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../../../../shared/modules/transaction.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\transaction.utils.ts","../../../../../components/app/confirm/info/row/constants":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\constants.ts","../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../hooks/useAsync":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAsync.ts","../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../../components/confirm/info/hooks/useBatchApproveBalanceChanges":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useBatchApproveBalanceChanges.ts","../../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","bignumber.js":"D:\\code\\v\\metamask-extension\\node_modules\\bignumber.js\\bignumber.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Calerts%5Ctransactions%5CuseMultipleApprovalsAlerts.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMultipleApprovalsAlerts = useMultipleApprovalsAlerts;
var _transactionController = require("@metamask/transaction-controller");
var _bignumber = require("bignumber.js");
var _react = require("react");
var _reactRedux = require("react-redux");
var _transaction = require("../../../../../../shared/constants/transaction");
var _transaction2 = require("../../../../../../shared/modules/transaction.utils");
var _constants = require("../../../../../components/app/confirm/info/row/constants");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _useAsync = require("../../../../../hooks/useAsync");
var _useI18nContext = require("../../../../../hooks/useI18nContext");
var _actions = require("../../../../../store/actions");
var _useBatchApproveBalanceChanges = require("../../../components/confirm/info/hooks/useBatchApproveBalanceChanges");
var _confirm = require("../../../context/confirm");
var _selectors = require("../../../../../selectors");
function getUniqueTokenAddresses(nestedTransactions) {
  const addresses = new Set();
  nestedTransactions.forEach(transaction => {
    const {
      data,
      to
    } = transaction;
    if (!data || !to) {
      return;
    }
    const parseResult = (0, _transaction2.parseApprovalTransactionData)(data);
    if (!parseResult) {
      return;
    }
    const {
      name,
      tokenAddress
    } = parseResult;
    let actualTokenAddress;
    switch (name) {
      case 'approve':
        actualTokenAddress = tokenAddress || to;
        break;
      case 'increaseAllowance':
      case 'setApprovalForAll':
        actualTokenAddress = to;
        break;
      default:
        return;
    }
    addresses.add(actualTokenAddress);
  });
  return Array.from(addresses);
}
function shouldSkipApproval(parseResult, tokenStandards, tokenAddress) {
  var _parseResult$amountOr;
  if (!parseResult) {
    return true;
  }

  // Skip setApprovalForAll revocations
  if (parseResult.isRevokeAll) {
    return true;
  }

  // Check if this is a revocation based on token standard
  if ((_parseResult$amountOr = parseResult.amountOrTokenId) !== null && _parseResult$amountOr !== void 0 && _parseResult$amountOr.isZero()) {
    const tokenStandard = tokenStandards[tokenAddress];

    // Only skip zero amounts for ERC20 tokens (revocations)
    // For ERC721/ERC1155, token ID 0 is valid and should not be skipped
    if (tokenStandard === _transaction.TokenStandard.ERC20) {
      return true;
    }
    // For unknown token standards or NFTs, we don't skip to avoid false negatives
  }
  return false;
}
function extractApprovals(nestedTransactions, tokenStandards) {
  const approvalsList = [];
  nestedTransactions.forEach(transaction => {
    const {
      data,
      to
    } = transaction;
    if (!data || !to) {
      return;
    }
    const parseResult = (0, _transaction2.parseApprovalTransactionData)(data);
    if (!parseResult) {
      return;
    }
    const {
      name,
      amountOrTokenId,
      tokenAddress
    } = parseResult;
    let actualTokenAddress;
    let spenderAddress;
    switch (name) {
      case 'approve':
        if (tokenAddress) {
          // Permit2 approve
          actualTokenAddress = tokenAddress;
          spenderAddress = to;
        } else {
          // Regular ERC20/ERC721 approve
          actualTokenAddress = to;
        }
        break;
      case 'increaseAllowance':
      case 'setApprovalForAll':
        actualTokenAddress = to;
        break;
      default:
        return;
    }
    if (shouldSkipApproval(parseResult, tokenStandards, actualTokenAddress)) {
      return;
    }
    approvalsList.push({
      tokenAddress: actualTokenAddress,
      spenderAddress,
      amount: amountOrTokenId
    });
  });
  return approvalsList;
}
function getTokensWithDecrease(simulationDataArray) {
  return (simulationDataArray === null || simulationDataArray === void 0 ? void 0 : simulationDataArray.filter(change => change.isDecrease).map(change => ({
    tokenAddress: change.address.toLowerCase(),
    amount: new _bignumber.BigNumber(change.difference, 16),
    isDecrease: change.isDecrease
  }))) ?? [];
}
function findUnusedApprovals(approvals, tokenOutflows) {
  if (approvals.length === 0) {
    return [];
  }
  return approvals.filter(approval => {
    const tokenOutflow = tokenOutflows.find(outflow => outflow.tokenAddress.toLowerCase() === approval.tokenAddress.toLowerCase());
    if (!tokenOutflow) {
      return true;
    }

    // If there's an outflow but the approval amount is much larger than needed,
    // we might still want to flag it, but for now we'll only flag completely unused approvals
    return false;
  });
}

// Utility function to fetch token standards for addresses
async function fetchTokenStandards(tokenAddresses, chainId, fromAddress) {
  if (!tokenAddresses.length || !chainId || !fromAddress) {
    return {};
  }
  const standards = {};
  await Promise.all(tokenAddresses.map(async address => {
    try {
      const details = await (0, _actions.getTokenStandardAndDetailsByChain)(address, fromAddress, undefined, chainId);
      // Safely cast the string to TokenStandard enum
      const standard = details === null || details === void 0 ? void 0 : details.standard;
      standards[address] = Object.values(_transaction.TokenStandard).includes(standard) ? standard : _transaction.TokenStandard.none;
    } catch (error) {
      console.warn(`Failed to get token standard for ${address}:`, error);
      standards[address] = _transaction.TokenStandard.none;
    }
  }));
  return standards;
}
function useMultipleApprovalsAlerts() {
  var _simulationData$error, _currentConfirmation$2;
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const {
    value: approveBalanceChanges
  } = (0, _useBatchApproveBalanceChanges.useBatchApproveBalanceChanges)() ?? {};
  const isSimulationEnabled = (0, _reactRedux.useSelector)(_selectors.getUseTransactionSimulations);
  const nonZeroUnusedApprovalsAllowList = (0, _reactRedux.useSelector)(_selectors.selectNonZeroUnusedApprovalsAllowList);
  const nestedTransactions = currentConfirmation === null || currentConfirmation === void 0 ? void 0 : currentConfirmation.nestedTransactions;
  const simulationData = currentConfirmation === null || currentConfirmation === void 0 ? void 0 : currentConfirmation.simulationData;
  const simulationDataArray = simulationData === null || simulationData === void 0 ? void 0 : simulationData.tokenBalanceChanges;
  const isSimulationSupported = isSimulationEnabled && ![_transactionController.SimulationErrorCode.ChainNotSupported, _transactionController.SimulationErrorCode.Disabled].includes(simulationData === null || simulationData === void 0 || (_simulationData$error = simulationData.error) === null || _simulationData$error === void 0 ? void 0 : _simulationData$error.code);
  const skipAlertOriginAllowed = nonZeroUnusedApprovalsAllowList === null || nonZeroUnusedApprovalsAllowList === void 0 ? void 0 : nonZeroUnusedApprovalsAllowList.includes((currentConfirmation === null || currentConfirmation === void 0 ? void 0 : currentConfirmation.origin) ?? '');
  const tokenAddresses = (0, _react.useMemo)(() => {
    if (!(nestedTransactions !== null && nestedTransactions !== void 0 && nestedTransactions.length)) {
      return [];
    }
    return getUniqueTokenAddresses(nestedTransactions);
  }, [nestedTransactions]);
  const {
    value: tokenStandards
  } = (0, _useAsync.useAsyncResult)(async () => {
    var _currentConfirmation$;
    return fetchTokenStandards(tokenAddresses, currentConfirmation === null || currentConfirmation === void 0 ? void 0 : currentConfirmation.chainId, currentConfirmation === null || currentConfirmation === void 0 || (_currentConfirmation$ = currentConfirmation.txParams) === null || _currentConfirmation$ === void 0 ? void 0 : _currentConfirmation$.from);
  }, [tokenAddresses, currentConfirmation === null || currentConfirmation === void 0 ? void 0 : currentConfirmation.chainId, currentConfirmation === null || currentConfirmation === void 0 || (_currentConfirmation$2 = currentConfirmation.txParams) === null || _currentConfirmation$2 === void 0 ? void 0 : _currentConfirmation$2.from]);
  const approvals = (0, _react.useMemo)(() => {
    if (!(nestedTransactions !== null && nestedTransactions !== void 0 && nestedTransactions.length) || !(approveBalanceChanges !== null && approveBalanceChanges !== void 0 && approveBalanceChanges.length) || !tokenStandards) {
      return [];
    }
    const approvalsList = extractApprovals(nestedTransactions, tokenStandards);
    return approvalsList;
  }, [approveBalanceChanges, nestedTransactions, tokenStandards]);
  const tokenOutflows = (0, _react.useMemo)(() => {
    if (!simulationDataArray) {
      return [];
    }
    return getTokensWithDecrease(simulationDataArray);
  }, [simulationDataArray]);
  const unusedApprovals = (0, _react.useMemo)(() => {
    return findUnusedApprovals(approvals, tokenOutflows);
  }, [approvals, tokenOutflows]);
  const shouldShowAlert = unusedApprovals.length > 0 && Boolean(currentConfirmation === null || currentConfirmation === void 0 ? void 0 : currentConfirmation.simulationData) && isSimulationSupported && !skipAlertOriginAllowed;
  return (0, _react.useMemo)(() => {
    if (!shouldShowAlert) {
      return [];
    }
    return [{
      field: _constants.RowAlertKey.EstimatedChangesStatic,
      isBlocking: false,
      key: 'multipleApprovals',
      reason: t('alertReasonMultipleApprovals'),
      content: t('alertContentMultipleApprovals'),
      severity: _designSystem.Severity.Danger
    }];
  }, [shouldShowAlert, t]);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\alerts\\transactions\\useMultipleApprovalsAlerts.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\transactions\\useNoGasPriceAlerts.ts", {"../../../../../../shared/modules/transaction.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\transaction.utils.ts","../../../../../components/app/confirm/info/row/constants":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\constants.ts","../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Calerts%5Ctransactions%5CuseNoGasPriceAlerts.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNoGasPriceAlerts = useNoGasPriceAlerts;
var _reactRedux = require("react-redux");
var _transactionController = require("@metamask/transaction-controller");
var _react = require("react");
var _transaction = require("../../../../../../shared/modules/transaction.utils");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _constants = require("../../../../../components/app/confirm/info/row/constants");
var _selectors = require("../../../../../selectors");
var _useI18nContext = require("../../../../../hooks/useI18nContext");
var _confirm = require("../../../context/confirm");
function useNoGasPriceAlerts() {
  const t = (0, _useI18nContext.useI18nContext)();
  const isNoGasPriceFetched = (0, _reactRedux.useSelector)(_selectors.getNoGasPriceFetched);
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const isNotCustomGasPrice = (currentConfirmation === null || currentConfirmation === void 0 ? void 0 : currentConfirmation.userFeeLevel) && currentConfirmation.userFeeLevel !== _transactionController.UserFeeLevel.CUSTOM && !(0, _transaction.txParamsAreDappSuggested)(currentConfirmation);
  const noGasPrice = isNotCustomGasPrice && isNoGasPriceFetched;
  return (0, _react.useMemo)(() => {
    if (!noGasPrice) {
      return [];
    }
    return [{
      actions: [{
        key: _constants.AlertActionKey.ShowAdvancedGasFeeModal,
        label: t('alertActionUpdateGasFee')
      }],
      field: _constants.RowAlertKey.EstimatedFee,
      isBlocking: true,
      key: 'noGasPrice',
      message: t('alertMessageNoGasPrice'),
      reason: t('alertReasonNoGasPrice'),
      severity: _designSystem.Severity.Warning
    }];
  }, [noGasPrice]);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\alerts\\transactions\\useNoGasPriceAlerts.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\transactions\\useNonContractAddressAlerts.ts", {"../../../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../../../components/app/confirm/info/row/constants":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\constants.ts","../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../components/confirm/info/hooks/useIsUpgradeTransaction":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useIsUpgradeTransaction.ts","../../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","./NonContractAddressAlertMessage":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\transactions\\NonContractAddressAlertMessage.tsx","./useContractCode":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\transactions\\useContractCode.ts","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Calerts%5Ctransactions%5CuseNonContractAddressAlerts.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNonContractAddressAlerts = useNonContractAddressAlerts;
var _transactionController = require("@metamask/transaction-controller");
var _react = require("react");
var _reactRedux = require("react-redux");
var _networks = require("../../../../../../shared/modules/selectors/networks");
var _constants = require("../../../../../components/app/confirm/info/row/constants");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../../hooks/useI18nContext");
var _confirm = require("../../../context/confirm");
var _useIsUpgradeTransaction = require("../../../components/confirm/info/hooks/useIsUpgradeTransaction");
var _NonContractAddressAlertMessage = require("./NonContractAddressAlertMessage");
var _useContractCode = require("./useContractCode");
function useNonContractAddressAlerts() {
  var _currentConfirmation$, _currentConfirmation$2, _currentConfirmation$3;
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const networkConfigurations = (0, _reactRedux.useSelector)(_networks.getNetworkConfigurationsByChainId);
  const {
    isUpgrade
  } = (0, _useIsUpgradeTransaction.useIsUpgradeTransaction)();
  const {
    pending,
    value
  } = (0, _useContractCode.useContractCode)(currentConfirmation === null || currentConfirmation === void 0 || (_currentConfirmation$ = currentConfirmation.txParams) === null || _currentConfirmation$ === void 0 ? void 0 : _currentConfirmation$.to, currentConfirmation === null || currentConfirmation === void 0 ? void 0 : currentConfirmation.networkClientId);
  const isSendingHexData = (currentConfirmation === null || currentConfirmation === void 0 || (_currentConfirmation$2 = currentConfirmation.txParams) === null || _currentConfirmation$2 === void 0 ? void 0 : _currentConfirmation$2.data) !== undefined && (currentConfirmation === null || currentConfirmation === void 0 || (_currentConfirmation$3 = currentConfirmation.txParams) === null || _currentConfirmation$3 === void 0 ? void 0 : _currentConfirmation$3.data) !== '0x';
  const isReadContractFailure = (value === null || value === void 0 ? void 0 : value.contractCode) === null;
  const isInteractingWithNonContractAddress = !pending && !isReadContractFailure && (value === null || value === void 0 ? void 0 : value.isContractAddress) === false;
  const isContractDeploymentTx = (currentConfirmation === null || currentConfirmation === void 0 ? void 0 : currentConfirmation.type) === _transactionController.TransactionType.deployContract;
  const isSendingHexDataWhileInteractingWithNonContractAddress = isSendingHexData && isInteractingWithNonContractAddress && !isContractDeploymentTx;
  return (0, _react.useMemo)(() => {
    if (!isSendingHexDataWhileInteractingWithNonContractAddress || isUpgrade) {
      return [];
    }
    return [{
      field: _constants.RowAlertKey.InteractingWith,
      isBlocking: false,
      key: 'hexDataWhileInteractingWithNonContractAddress',
      reason: t('nonContractAddressAlertTitle'),
      content: (0, _NonContractAddressAlertMessage.NonContractAddressAlertMessage)(networkConfigurations),
      severity: _designSystem.Severity.Warning
    }];
  }, [isSendingHexDataWhileInteractingWithNonContractAddress, isUpgrade, networkConfigurations]);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\alerts\\transactions\\useNonContractAddressAlerts.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\transactions\\usePendingTransactionAlerts.ts", {"../../../../../../shared/lib/confirmation.utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\confirmation.utils.ts","../../../../../components/app/confirm/info/row/constants":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\constants.ts","../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","./PendingTransactionAlertMessage":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\transactions\\PendingTransactionAlertMessage.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Calerts%5Ctransactions%5CusePendingTransactionAlerts.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePendingTransactionAlerts = usePendingTransactionAlerts;
var _react = require("react");
var _reactRedux = require("react-redux");
var _confirmation = require("../../../../../../shared/lib/confirmation.utils");
var _constants = require("../../../../../components/app/confirm/info/row/constants");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../../hooks/useI18nContext");
var _selectors = require("../../../../../selectors");
var _confirm = require("../../../context/confirm");
var _PendingTransactionAlertMessage = require("./PendingTransactionAlertMessage");
function usePendingTransactionAlerts() {
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const {
    type
  } = currentConfirmation ?? {};
  const pendingTransactions = (0, _reactRedux.useSelector)(_selectors.submittedPendingTransactionsSelector);
  const isValidType = (0, _confirmation.isCorrectDeveloperTransactionType)(type);
  const hasPendingTransactions = isValidType && Boolean(pendingTransactions.length);
  return (0, _react.useMemo)(() => {
    if (!hasPendingTransactions) {
      return [];
    }
    return [{
      field: _constants.RowAlertKey.Speed,
      key: 'pendingTransactions',
      content: (0, _PendingTransactionAlertMessage.PendingTransactionAlertMessage)(),
      reason: t('alertReasonPendingTransactions'),
      severity: _designSystem.Severity.Warning
    }];
  }, [hasPendingTransactions]);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\alerts\\transactions\\usePendingTransactionAlerts.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\transactions\\useResimulationAlert.ts", {"../../../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../../../components/app/confirm/info/row/constants":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\constants.ts","../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Calerts%5Ctransactions%5CuseResimulationAlert.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useResimulationAlert = useResimulationAlert;
var _react = require("react");
var _app = require("../../../../../../shared/constants/app");
var _useI18nContext = require("../../../../../hooks/useI18nContext");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _constants = require("../../../../../components/app/confirm/info/row/constants");
var _confirm = require("../../../context/confirm");
function useResimulationAlert() {
  var _transactionMeta$simu;
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const transactionMeta = currentConfirmation;
  const isUpdatedAfterSecurityCheck = transactionMeta === null || transactionMeta === void 0 || (_transactionMeta$simu = transactionMeta.simulationData) === null || _transactionMeta$simu === void 0 ? void 0 : _transactionMeta$simu.isUpdatedAfterSecurityCheck;
  const isWalletInitiated = (transactionMeta === null || transactionMeta === void 0 ? void 0 : transactionMeta.origin) === _app.ORIGIN_METAMASK;
  return (0, _react.useMemo)(() => {
    if (!isUpdatedAfterSecurityCheck || isWalletInitiated) {
      return [];
    }
    return [{
      actions: [],
      field: _constants.RowAlertKey.Resimulation,
      isBlocking: false,
      key: 'simulationDetailsTitle',
      message: t('alertMessageChangeInSimulationResults'),
      reason: t('alertReasonChangeInSimulationResults'),
      severity: _designSystem.Severity.Danger
    }];
  }, [isUpdatedAfterSecurityCheck, isWalletInitiated, t]);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\alerts\\transactions\\useResimulationAlert.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\transactions\\useSigningOrSubmittingAlerts.ts", {"../../../../../../shared/lib/confirmation.utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\confirmation.utils.ts","../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Calerts%5Ctransactions%5CuseSigningOrSubmittingAlerts.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSigningOrSubmittingAlerts = useSigningOrSubmittingAlerts;
var _react = require("react");
var _reactRedux = require("react-redux");
var _selectors = require("../../../../../selectors");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../../hooks/useI18nContext");
var _confirm = require("../../../context/confirm");
var _confirmation = require("../../../../../../shared/lib/confirmation.utils");
function useSigningOrSubmittingAlerts() {
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const {
    type
  } = currentConfirmation ?? {};
  const signingOrSubmittingTransactions = (0, _reactRedux.useSelector)(_selectors.getApprovedAndSignedTransactions);
  const isValidType = (0, _confirmation.isCorrectDeveloperTransactionType)(type);
  const isSigningOrSubmitting = isValidType && signingOrSubmittingTransactions.length > 0;
  return (0, _react.useMemo)(() => {
    if (!isSigningOrSubmitting) {
      return [];
    }
    return [{
      isBlocking: true,
      key: 'signingOrSubmitting',
      message: t('isSigningOrSubmitting'),
      severity: _designSystem.Severity.Danger
    }];
  }, [isSigningOrSubmitting]);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\alerts\\transactions\\useSigningOrSubmittingAlerts.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\useAddressTrustSignalAlerts.ts", {"../../../../../app/scripts/lib/ppom/security-alerts-api":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\ppom\\security-alerts-api.ts","../../../../components/app/confirm/info/row/constants":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\constants.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../hooks/useTrustSignals":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTrustSignals.ts","../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","@metamask/name-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\name-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Calerts%5CuseAddressTrustSignalAlerts.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAddressTrustSignalAlerts = useAddressTrustSignalAlerts;
var _react = require("react");
var _nameController = require("@metamask/name-controller");
var _designSystem = require("../../../../helpers/constants/design-system");
var _constants = require("../../../../components/app/confirm/info/row/constants");
var _confirm = require("../../context/confirm");
var _useTrustSignals = require("../../../../hooks/useTrustSignals");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _securityAlertsApi = require("../../../../../app/scripts/lib/ppom/security-alerts-api");
// eslint-disable-next-line import/no-restricted-paths

function useAddressTrustSignalAlerts() {
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const t = (0, _useI18nContext.useI18nContext)();
  const addressToCheck = (0, _react.useMemo)(() => {
    var _txParams, _msgParams;
    if (!currentConfirmation) {
      return null;
    }

    // For transactions, check the 'to' address
    if (currentConfirmation !== null && currentConfirmation !== void 0 && (_txParams = currentConfirmation.txParams) !== null && _txParams !== void 0 && _txParams.to) {
      return currentConfirmation.txParams.to;
    }

    // For signatures, check the verifying contract if available
    if (currentConfirmation !== null && currentConfirmation !== void 0 && (_msgParams = currentConfirmation.msgParams) !== null && _msgParams !== void 0 && _msgParams.data) {
      try {
        var _msgParams2, _parsedData$domain;
        const data = currentConfirmation === null || currentConfirmation === void 0 || (_msgParams2 = currentConfirmation.msgParams) === null || _msgParams2 === void 0 ? void 0 : _msgParams2.data;
        const parsedData = typeof data === 'string' ? JSON.parse(data) : data;
        if (parsedData !== null && parsedData !== void 0 && (_parsedData$domain = parsedData.domain) !== null && _parsedData$domain !== void 0 && _parsedData$domain.verifyingContract) {
          return parsedData.domain.verifyingContract;
        }
      } catch (e) {
        // Ignore parsing errors
      }
    }
    return null;
  }, [currentConfirmation]);
  const {
    state: trustSignalDisplayState
  } = (0, _useTrustSignals.useTrustSignal)(addressToCheck || '', _nameController.NameType.ETHEREUM_ADDRESS);
  return (0, _react.useMemo)(() => {
    if (!addressToCheck || !(0, _securityAlertsApi.isSecurityAlertsAPIEnabled)()) {
      return [];
    }
    const alerts = [];
    if (trustSignalDisplayState === _useTrustSignals.TrustSignalDisplayState.Malicious) {
      alerts.push({
        actions: [],
        field: _constants.RowAlertKey.InteractingWith,
        isBlocking: false,
        key: 'trustSignalMalicious',
        message: t('alertMessageAddressTrustSignalMalicious'),
        reason: t('nameModalTitleMalicious'),
        severity: _designSystem.Severity.Danger
      });
    } else if (trustSignalDisplayState === _useTrustSignals.TrustSignalDisplayState.Warning) {
      alerts.push({
        actions: [],
        field: _constants.RowAlertKey.InteractingWith,
        isBlocking: false,
        key: 'trustSignalWarning',
        message: t('alertMessageAddressTrustSignal'),
        reason: t('nameModalTitleWarning'),
        severity: _designSystem.Severity.Warning
      });
    }
    return alerts;
  }, [addressToCheck, trustSignalDisplayState, t]);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\alerts\\useAddressTrustSignalAlerts.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\useBlockaidAlerts.ts", {"../../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../../shared/constants/security-provider":"D:\\code\\v\\metamask-extension\\shared\\constants\\security-provider.ts","../../../../../shared/lib/confirmation.utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\confirmation.utils.ts","../../../../helpers/constants/zendesk-url":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\zendesk-url.js","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","../../utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\utils\\index.ts","../useCurrentSignatureSecurityAlertResponse":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useCurrentSignatureSecurityAlertResponse.ts","./utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\utils.ts","@blockaid/ppom_release/package.json":"D:\\code\\v\\metamask-extension\\node_modules\\@blockaid\\ppom_release\\package.json","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","zlib":"D:\\code\\v\\metamask-extension\\node_modules\\browserify-zlib\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Calerts%5CuseBlockaidAlerts.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _package = _interopRequireDefault(require("@blockaid/ppom_release/package.json"));
var _react = require("react");
var _reactRedux = require("react-redux");
var _network = require("../../../../../shared/constants/network");
var _securityProvider = require("../../../../../shared/constants/security-provider");
var _zendeskUrl = _interopRequireDefault(require("../../../../helpers/constants/zendesk-url"));
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _utils = require("../../utils");
var _confirmation = require("../../../../../shared/lib/confirmation.utils");
var _confirm = require("../../context/confirm");
var _useCurrentSignatureSecurityAlertResponse = _interopRequireDefault(require("../useCurrentSignatureSecurityAlertResponse"));
var _utils2 = require("./utils");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// eslint-disable-next-line @typescript-eslint/no-require-imports, @typescript-eslint/no-var-requires
const zlib = require('zlib');
const IGNORED_RESULT_TYPES = [_securityProvider.BlockaidResultType.Benign, _securityProvider.BlockaidResultType.Loading];
const useBlockaidAlerts = () => {
  var _currentConfirmation$;
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const securityAlertId = currentConfirmation === null || currentConfirmation === void 0 || (_currentConfirmation$ = currentConfirmation.securityAlertResponse) === null || _currentConfirmation$ === void 0 ? void 0 : _currentConfirmation$.securityAlertId;
  const transactionType = currentConfirmation === null || currentConfirmation === void 0 ? void 0 : currentConfirmation.type;
  const signatureSecurityAlertResponse = (0, _useCurrentSignatureSecurityAlertResponse.default)();
  const transactionSecurityAlertResponse = (0, _reactRedux.useSelector)(state => {
    var _state$metamask$trans;
    return (_state$metamask$trans = state.metamask.transactions.find(transaction => {
      var _transaction$security;
      return (
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        ((_transaction$security = transaction.securityAlertResponse) === null || _transaction$security === void 0 ? void 0 : _transaction$security.securityAlertId) === securityAlertId
      );
    })) === null || _state$metamask$trans === void 0 ? void 0 : _state$metamask$trans.securityAlertResponse;
  });
  const securityAlertResponse =
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  signatureSecurityAlertResponse || transactionSecurityAlertResponse;
  const isTransactionTypeSupported = (0, _confirmation.isCorrectDeveloperTransactionType)(transactionType) || _utils.SIGNATURE_TRANSACTION_TYPES.includes(transactionType);
  const isResultTypeIgnored = IGNORED_RESULT_TYPES.includes(securityAlertResponse === null || securityAlertResponse === void 0 ? void 0 : securityAlertResponse.result_type);
  let stringifiedJSONData;
  if (securityAlertResponse && currentConfirmation) {
    const {
      block,
      features,
      reason,
      result_type: resultType
    } = securityAlertResponse;
    const {
      chainId,
      msgParams,
      origin,
      type,
      txParams
    } = currentConfirmation;
    const isFailedResultType = resultType === _securityProvider.BlockaidResultType.Errored;
    const reportData = {
      blockNumber: block,
      blockaidVersion: _package.default.version,
      chain: _network.NETWORK_TO_NAME_MAP[chainId],
      classification: isFailedResultType ? 'error' : reason,
      domain: origin ?? (msgParams === null || msgParams === void 0 ? void 0 : msgParams.origin) ?? origin,
      jsonRpcMethod: type,
      jsonRpcParams: JSON.stringify(txParams ?? msgParams),
      resultType: isFailedResultType ? _securityProvider.BlockaidResultType.Errored : resultType,
      reproduce: JSON.stringify(features)
    };
    stringifiedJSONData = JSON.stringify(reportData);
  }
  return (0, _react.useMemo)(() => {
    if (!isTransactionTypeSupported || isResultTypeIgnored || !securityAlertResponse) {
      return [];
    }
    let reportUrl = _zendeskUrl.default.SUPPORT_URL;
    if (stringifiedJSONData) {
      var _zlib$gzipSync;
      const encodedData = (zlib === null || zlib === void 0 || (_zlib$gzipSync = zlib.gzipSync) === null || _zlib$gzipSync === void 0 ? void 0 : _zlib$gzipSync.call(zlib, stringifiedJSONData)) ?? stringifiedJSONData;
      reportUrl = `${_securityProvider.FALSE_POSITIVE_REPORT_BASE_URL}?data=${encodeURIComponent(encodedData.toString('base64'))}&utm_source=${_securityProvider.SECURITY_PROVIDER_UTM_SOURCE}`;
    }
    return [(0, _utils2.normalizeProviderAlert)(securityAlertResponse, t, reportUrl)];
  }, [isTransactionTypeSupported, isResultTypeIgnored, securityAlertResponse, stringifiedJSONData, t]);
};
var _default = exports.default = useBlockaidAlerts;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\alerts\\useBlockaidAlerts.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\useConfirmationOriginAlerts.ts", {"../../../../components/app/confirm/info/row/constants":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\constants.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","../../utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\utils\\index.ts","../../utils/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\utils\\confirm.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Calerts%5CuseConfirmationOriginAlerts.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("react");
var _constants = require("../../../../components/app/confirm/info/row/constants");
var _designSystem = require("../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _confirm = require("../../utils/confirm");
var _utils = require("../../utils");
var _confirm2 = require("../../context/confirm");
const useConfirmationOriginAlerts = () => {
  var _msgParams;
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    currentConfirmation
  } = (0, _confirm2.useConfirmContext)();
  const origin = (0, _utils.isSignatureTransactionType)(currentConfirmation) ? currentConfirmation === null || currentConfirmation === void 0 || (_msgParams = currentConfirmation.msgParams) === null || _msgParams === void 0 ? void 0 : _msgParams.origin : currentConfirmation === null || currentConfirmation === void 0 ? void 0 : currentConfirmation.origin;
  const originUndefinedOrValid = origin === undefined || origin === 'metamask' || (0, _confirm.isValidASCIIURL)(origin);
  return (0, _react.useMemo)(() => {
    if (originUndefinedOrValid) {
      return [];
    }
    return [{
      key: 'originSpecialCharacterWarning',
      reason: t('addressMismatch'),
      field: _constants.RowAlertKey.RequestFrom,
      severity: _designSystem.Severity.Warning,
      message: t('alertMessageAddressMismatchWarning'),
      alertDetails: [t('addressMismatchOriginal', [origin]), t('addressMismatchPunycode', [origin ? (0, _confirm.toPunycodeURL)(origin) : ''])]
    }];
  }, [origin, originUndefinedOrValid, t]);
};
var _default = exports.default = useConfirmationOriginAlerts;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\alerts\\useConfirmationOriginAlerts.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\useNetworkAndOriginSwitchingAlerts.ts", {"../../../../components/app/confirm/info/row/constants":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\constants.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Calerts%5CuseNetworkAndOriginSwitchingAlerts.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNetworkAndOriginSwitchingAlerts = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _constants = require("../../../../components/app/confirm/info/row/constants");
var _designSystem = require("../../../../helpers/constants/design-system");
var _actions = require("../../../../store/actions");
var _selectors = require("../../../../selectors");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _confirm = require("../../context/confirm");
const CHANGE_THRESHOLD_MS = 60 * 1000; // 1 Minute

const useNetworkAndOriginSwitchingAlerts = () => {
  var _msgParams;
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const {
    chainId: newChainId = '',
    id: currentConfirmationId
  } = currentConfirmation ?? {};
  const newOrigin = (currentConfirmation === null || currentConfirmation === void 0 ? void 0 : currentConfirmation.origin) ?? (currentConfirmation === null || currentConfirmation === void 0 || (_msgParams = currentConfirmation.msgParams) === null || _msgParams === void 0 ? void 0 : _msgParams.origin) ?? '';
  const newNetwork = (0, _reactRedux.useSelector)(state => (0, _selectors.selectNetworkConfigurationByChainId)(state, newChainId));
  const [lastInteractedConfirmationInfo, updateLastInteractedConfirmationInfo] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    let isMounted = true;
    (async () => {
      const lastConfirmation = await (0, _actions.getLastInteractedConfirmationInfo)();
      if (!isMounted) {
        return;
      }
      updateLastInteractedConfirmationInfo(lastConfirmation);
      const isNewId = !lastConfirmation || (lastConfirmation === null || lastConfirmation === void 0 ? void 0 : lastConfirmation.id) !== currentConfirmationId;
      if (!isNewId) {
        return;
      }
      (0, _actions.setLastInteractedConfirmationInfo)({
        id: currentConfirmationId,
        chainId: newChainId,
        origin: newOrigin,
        timestamp: new Date().getTime()
      });
    })();
    return () => {
      isMounted = false;
    };
  }, [currentConfirmationId, newChainId, newOrigin, updateLastInteractedConfirmationInfo]);
  const networkAndOriginSwitchingAlerts = (0, _react.useMemo)(() => {
    if (!currentConfirmationId || !lastInteractedConfirmationInfo) {
      return [];
    }
    const alerts = [];
    const currentTimestamp = new Date().getTime();
    const timeSinceLastConfirmation = currentTimestamp - lastInteractedConfirmationInfo.timestamp;
    const recentlyViewedOtherConfirmation = timeSinceLastConfirmation <= CHANGE_THRESHOLD_MS;
    if (!recentlyViewedOtherConfirmation) {
      return [];
    }
    const {
      chainId,
      origin
    } = lastInteractedConfirmationInfo;
    if (chainId !== newChainId) {
      alerts.push({
        key: 'networkSwitchInfo',
        reason: t('networkChanged'),
        field: _constants.RowAlertKey.Network,
        severity: _designSystem.Severity.Info,
        message: t('networkChangedMessage', [(newNetwork === null || newNetwork === void 0 ? void 0 : newNetwork.name) ?? ''])
      });
    }
    if (origin !== newOrigin) {
      alerts.push({
        key: 'originSwitchInfo',
        reason: t('originChanged'),
        field: _constants.RowAlertKey.RequestFrom,
        severity: _designSystem.Severity.Info,
        message: t('originChangedMessage', [newOrigin ?? ''])
      });
    }
    return alerts;
  }, [currentConfirmationId, lastInteractedConfirmationInfo, newNetwork === null || newNetwork === void 0 ? void 0 : newNetwork.name, newChainId, newOrigin, t]);
  return networkAndOriginSwitchingAlerts;
};
exports.useNetworkAndOriginSwitchingAlerts = useNetworkAndOriginSwitchingAlerts;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\alerts\\useNetworkAndOriginSwitchingAlerts.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\useOriginTrustSignalAlerts.ts", {"../../../../components/app/confirm/info/row/constants":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\constants.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../hooks/useOriginTrustSignals":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useOriginTrustSignals.ts","../../../../hooks/useTrustSignals":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTrustSignals.ts","../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Calerts%5CuseOriginTrustSignalAlerts.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOriginTrustSignalAlerts = useOriginTrustSignalAlerts;
var _react = require("react");
var _constants = require("../../../../components/app/confirm/info/row/constants");
var _designSystem = require("../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _confirm = require("../../context/confirm");
var _useTrustSignals = require("../../../../hooks/useTrustSignals");
var _useOriginTrustSignals = require("../../../../hooks/useOriginTrustSignals");
function useOriginTrustSignalAlerts() {
  var _msgParams;
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const origin = (currentConfirmation === null || currentConfirmation === void 0 ? void 0 : currentConfirmation.origin) ?? (currentConfirmation === null || currentConfirmation === void 0 || (_msgParams = currentConfirmation.msgParams) === null || _msgParams === void 0 ? void 0 : _msgParams.origin) ?? '';
  const {
    state: trustSignalState
  } = (0, _useOriginTrustSignals.useOriginTrustSignals)(origin);
  return (0, _react.useMemo)(() => {
    if (!origin) {
      return [];
    }
    const alerts = [];
    if (trustSignalState === _useTrustSignals.TrustSignalDisplayState.Malicious) {
      alerts.push({
        key: 'originTrustSignalMalicious',
        reason: t('alertReasonOriginTrustSignalMalicious'),
        field: _constants.RowAlertKey.RequestFrom,
        severity: _designSystem.Severity.Danger,
        message: t('alertMessageOriginTrustSignalMalicious')
      });
    } else if (trustSignalState === _useTrustSignals.TrustSignalDisplayState.Warning) {
      alerts.push({
        key: 'originTrustSignalWarning',
        reason: t('alertReasonOriginTrustSignalWarning'),
        field: _constants.RowAlertKey.RequestFrom,
        severity: _designSystem.Severity.Warning,
        message: t('alertMessageOriginTrustSignalWarning')
      });
    }
    return alerts;
  }, [origin, trustSignalState, t]);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\alerts\\useOriginTrustSignalAlerts.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\useSelectedAccountAlerts.ts", {"../../../../components/app/confirm/info/row/constants":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\constants.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Calerts%5CuseSelectedAccountAlerts.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSelectedAccountAlerts = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _accountTree = require("../../../../selectors/multichain-accounts/account-tree");
var _constants = require("../../../../components/app/confirm/info/row/constants");
var _designSystem = require("../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _confirm = require("../../context/confirm");
const useSelectedAccountAlerts = () => {
  var _accountGroupWithInte, _msgParams, _txParams;
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const selectedAccountGroupId = (0, _reactRedux.useSelector)(_accountTree.getSelectedAccountGroup);
  const accountGroupWithInternalAccounts = (0, _reactRedux.useSelector)(_accountTree.getAccountGroupWithInternalAccounts);
  const selectedAccountGroupWithInternalAccounts = (_accountGroupWithInte = accountGroupWithInternalAccounts.find(accountGroup => accountGroup.id === selectedAccountGroupId)) === null || _accountGroupWithInte === void 0 ? void 0 : _accountGroupWithInte.accounts;
  const fromAccount = (currentConfirmation === null || currentConfirmation === void 0 || (_msgParams = currentConfirmation.msgParams) === null || _msgParams === void 0 ? void 0 : _msgParams.from) ?? (currentConfirmation === null || currentConfirmation === void 0 || (_txParams = currentConfirmation.txParams) === null || _txParams === void 0 ? void 0 : _txParams.from);
  const isAccountFromSelectedAccountGroup = selectedAccountGroupWithInternalAccounts === null || selectedAccountGroupWithInternalAccounts === void 0 ? void 0 : selectedAccountGroupWithInternalAccounts.find(account => account.address.toLowerCase() === (fromAccount === null || fromAccount === void 0 ? void 0 : fromAccount.toLowerCase()));
  const confirmationAccountSameAsSelectedAccount = !fromAccount || isAccountFromSelectedAccountGroup;
  return (0, _react.useMemo)(() => {
    if (confirmationAccountSameAsSelectedAccount) {
      return [];
    }
    return [{
      key: 'selectedAccountWarning',
      reason: t('selectedAccountMismatch'),
      field: _constants.RowAlertKey.SigningInWith,
      severity: _designSystem.Severity.Info,
      message: t('alertSelectedAccountWarning')
    }];
  }, [confirmationAccountSameAsSelectedAccount, t]);
};
exports.useSelectedAccountAlerts = useSelectedAccountAlerts;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\alerts\\useSelectedAccountAlerts.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\useShieldCoverageAlert.ts", {"../../../../components/app/confirm/info/row/constants":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\constants.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../selectors/shield/coverage":"D:\\code\\v\\metamask-extension\\ui\\selectors\\shield\\coverage.ts","../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","../transactions/useEnableShieldCoverageChecks":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\transactions\\useEnableShieldCoverageChecks.ts","./transactions/ShieldCoverageAlertMessage":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\transactions\\ShieldCoverageAlertMessage.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Calerts%5CuseShieldCoverageAlert.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useShieldCoverageAlert = useShieldCoverageAlert;
var _react = require("react");
var _reactRedux = require("react-redux");
var _constants = require("../../../../components/app/confirm/info/row/constants");
var _designSystem = require("../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _coverage = require("../../../../selectors/shield/coverage");
var _confirm = require("../../context/confirm");
var _useEnableShieldCoverageChecks = require("../transactions/useEnableShieldCoverageChecks");
var _ShieldCoverageAlertMessage = require("./transactions/ShieldCoverageAlertMessage");
const getModalBodyStr = reasonCode => {
  // grouping codes with a fallthrough pattern is not allowed by the linter
  let modalBodyStr;
  switch (reasonCode) {
    // Local setup
    case 'E104':
      modalBodyStr = 'shieldCoverageAlertMessageTxTypeNotSupported';
      break;
    // Sender type not supported
    case 'E200':
      modalBodyStr = 'shieldCoverageAlertMessageTxTypeNotSupported';
      break;
    // Receiver type not supported
    case 'E300':
      modalBodyStr = 'shieldCoverageAlertMessageTxTypeNotSupported';
      break;
    // Transaction type not supported
    case 'E400':
      modalBodyStr = 'shieldCoverageAlertMessageTxTypeNotSupported';
      break;
    // Transaction to not supported
    case 'E401':
      modalBodyStr = 'shieldCoverageAlertMessageTxTypeNotSupported';
      break;
    // Malicious domain
    case 'E101':
      modalBodyStr = 'shieldCoverageAlertMessagePotentialRisks';
      break;
    // Risky domain
    case 'E102':
      modalBodyStr = 'shieldCoverageAlertMessagePotentialRisks';
      break;
    // Scan origin error
    case 'E103':
      modalBodyStr = 'shieldCoverageAlertMessagePotentialRisks';
      break;
    // Receiver contract malicious
    case 'E301':
      modalBodyStr = 'shieldCoverageAlertMessagePotentialRisks';
      break;
    // Receiver contract risky
    case 'E302':
      modalBodyStr = 'shieldCoverageAlertMessagePotentialRisks';
      break;
    // Method params contract malicious
    case 'E500':
      modalBodyStr = 'shieldCoverageAlertMessagePotentialRisks';
      break;
    // Method params contract unknown
    case 'E501':
      modalBodyStr = 'shieldCoverageAlertMessagePotentialRisks';
      break;
    // Malicious token contract
    case 'E600':
      modalBodyStr = 'shieldCoverageAlertMessagePotentialRisks';
      break;
    // Risky token contract
    case 'E601':
      modalBodyStr = 'shieldCoverageAlertMessagePotentialRisks';
      break;
    // Invalid blockaid result
    case 'E001':
      modalBodyStr = 'shieldCoverageAlertMessagePotentialRisks';
      break;
    // Invalid sentinel result
    case 'E002':
      modalBodyStr = 'shieldCoverageAlertMessagePotentialRisks';
      break;
    // Malicious blockaid result
    case 'E003':
      modalBodyStr = 'shieldCoverageAlertMessagePotentialRisks';
      break;
    // Unknown blockaid result
    case 'E004':
      modalBodyStr = 'shieldCoverageAlertMessagePotentialRisks';
      break;
    // Malicious sentinel result
    case 'E005':
      modalBodyStr = 'shieldCoverageAlertMessagePotentialRisks';
      break;
    // Invalid coverage result
    case 'E006':
      modalBodyStr = 'shieldCoverageAlertMessagePotentialRisks';
      break;
    // Unknown error
    case 'E007':
      modalBodyStr = 'shieldCoverageAlertMessagePotentialRisks';
      break;
    // Unsupported chain id
    case 'E008':
      modalBodyStr = 'shieldCoverageAlertMessageChainNotSupported';
      break;
    // Signature method not supported
    case 'E700':
      modalBodyStr = 'shieldCoverageAlertMessageSignatureNotSupported';
      break;
    // Signature decoding failed
    case 'E701':
      modalBodyStr = 'shieldCoverageAlertMessageSignatureNotSupported';
      break;
    // SIWE domain not matching
    case 'E702':
      modalBodyStr = 'shieldCoverageAlertMessageSignatureNotSupported';
      break;
    // SIWE account mismatch
    case 'E703':
      modalBodyStr = 'shieldCoverageAlertMessageSignatureNotSupported';
      break;
    default:
      modalBodyStr = 'shieldCoverageAlertMessageUnknown';
  }
  return modalBodyStr;
};
function useShieldCoverageAlert() {
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const {
    reasonCode,
    status
  } = (0, _reactRedux.useSelector)(state => (0, _coverage.getCoverageStatus)(state, currentConfirmation === null || currentConfirmation === void 0 ? void 0 : currentConfirmation.id));
  const modalBodyStr = getModalBodyStr(reasonCode);
  const isEnableShieldCoverageChecks = (0, _useEnableShieldCoverageChecks.useEnableShieldCoverageChecks)();
  const showAlert = isEnableShieldCoverageChecks;
  return (0, _react.useMemo)(() => {
    if (!showAlert) {
      return [];
    }
    let severity = _designSystem.Severity.Info;
    let inlineAlertText = t('shieldNotCovered');
    switch (status) {
      case 'covered':
        severity = _designSystem.Severity.Success;
        inlineAlertText = t('shieldCovered');
        break;
      case 'malicious':
        severity = _designSystem.Severity.Danger;
        break;
      default:
    }
    return [{
      key: 'shieldCoverageAlert',
      reason: t('shieldCoverageAlertMessageTitle'),
      field: _constants.RowAlertKey.ShieldFooterCoverageIndicator,
      severity,
      content: (0, _ShieldCoverageAlertMessage.ShieldCoverageAlertMessage)(modalBodyStr),
      isBlocking: false,
      inlineAlertText,
      showArrow: false,
      isOpenModalOnClick: status !== 'covered'
    }];
  }, [status, modalBodyStr, showAlert, t]);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\alerts\\useShieldCoverageAlert.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\useTokenTrustSignalAlerts.ts", {"../../../../components/app/confirm/info/row/constants":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\constants.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../hooks/useTokenTrustSignals":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTokenTrustSignals.ts","../../../../hooks/useTrustSignals":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTrustSignals.ts","../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Calerts%5CuseTokenTrustSignalAlerts.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTokenTrustSignalAlerts = useTokenTrustSignalAlerts;
var _react = require("react");
var _transactionController = require("@metamask/transaction-controller");
var _designSystem = require("../../../../helpers/constants/design-system");
var _constants = require("../../../../components/app/confirm/info/row/constants");
var _confirm = require("../../context/confirm");
var _useTrustSignals = require("../../../../hooks/useTrustSignals");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _useTokenTrustSignals = require("../../../../hooks/useTokenTrustSignals");
const EMPTY_ALERTS = [];
const EMPTY_ACTIONS = [];
function useTokenTrustSignalAlerts() {
  var _txMeta$simulationDat;
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const txMeta = currentConfirmation;
  const chainId = txMeta === null || txMeta === void 0 ? void 0 : txMeta.chainId;
  const tokenBalanceChanges = txMeta === null || txMeta === void 0 || (_txMeta$simulationDat = txMeta.simulationData) === null || _txMeta$simulationDat === void 0 ? void 0 : _txMeta$simulationDat.tokenBalanceChanges;
  const incomingTokenAddresses = (0, _react.useMemo)(() => {
    if (!(tokenBalanceChanges !== null && tokenBalanceChanges !== void 0 && tokenBalanceChanges.length)) {
      return undefined;
    }
    const addresses = tokenBalanceChanges.filter(change => !change.isDecrease && change.standard === _transactionController.SimulationTokenStandard.erc20 && change.address).map(change => change.address.toLowerCase());
    return addresses.length ? addresses : undefined;
  }, [tokenBalanceChanges]);
  const tokenTrustSignals = (0, _useTokenTrustSignals.useTokenTrustSignalsForAddresses)(chainId, incomingTokenAddresses);
  return (0, _react.useMemo)(() => {
    if (!(incomingTokenAddresses !== null && incomingTokenAddresses !== void 0 && incomingTokenAddresses.length)) {
      return EMPTY_ALERTS;
    }
    const hasMaliciousToken = tokenTrustSignals === null || tokenTrustSignals === void 0 ? void 0 : tokenTrustSignals.some(s => s.state === _useTrustSignals.TrustSignalDisplayState.Malicious);
    const hasWarningToken = tokenTrustSignals === null || tokenTrustSignals === void 0 ? void 0 : tokenTrustSignals.some(s => s.state === _useTrustSignals.TrustSignalDisplayState.Warning);
    if (hasMaliciousToken) {
      return [{
        actions: EMPTY_ACTIONS,
        field: _constants.RowAlertKey.IncomingTokens,
        isBlocking: false,
        key: 'tokenTrustSignalMalicious',
        message: t('alertMessageTokenTrustSignalMalicious'),
        reason: t('alertReasonTokenTrustSignalMalicious'),
        severity: _designSystem.Severity.Danger
      }];
    }
    if (hasWarningToken) {
      return [{
        actions: EMPTY_ACTIONS,
        field: _constants.RowAlertKey.IncomingTokens,
        isBlocking: false,
        key: 'tokenTrustSignalWarning',
        message: t('alertMessageTokenTrustSignalWarning'),
        reason: t('alertReasonTokenTrustSignalWarning'),
        severity: _designSystem.Severity.Warning
      }];
    }
    return EMPTY_ALERTS;
  }, [incomingTokenAddresses, tokenTrustSignals, t]);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\alerts\\useTokenTrustSignalAlerts.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\utils.ts", {"../../../../../shared/constants/security-provider":"D:\\code\\v\\metamask-extension\\shared\\constants\\security-provider.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Calerts%5Cutils.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.REASON_TO_TITLE_TKEY = exports.REASON_TO_DESCRIPTION_TKEY = void 0;
exports.getProviderAlertSeverity = getProviderAlertSeverity;
exports.normalizeProviderAlert = normalizeProviderAlert;
var _securityProvider = require("../../../../../shared/constants/security-provider");
var _designSystem = require("../../../../helpers/constants/design-system");
/** Reason to description translation key mapping. Grouped by translations. */
const REASON_TO_DESCRIPTION_TKEY = exports.REASON_TO_DESCRIPTION_TKEY = Object.freeze({
  [_securityProvider.BlockaidReason.approvalFarming]: 'blockaidDescriptionApproveFarming',
  [_securityProvider.BlockaidReason.permitFarming]: 'blockaidDescriptionApproveFarming',
  [_securityProvider.BlockaidReason.setApprovalForAll]: 'blockaidDescriptionApproveFarming',
  [_securityProvider.BlockaidReason.blurFarming]: 'blockaidDescriptionBlurFarming',
  [_securityProvider.BlockaidReason.errored]: 'blockaidDescriptionErrored',
  // TODO: change in i8n

  [_securityProvider.BlockaidReason.seaportFarming]: 'blockaidDescriptionSeaportFarming',
  [_securityProvider.BlockaidReason.maliciousDomain]: 'blockaidDescriptionMaliciousDomain',
  [_securityProvider.BlockaidReason.rawSignatureFarming]: 'blockaidDescriptionMightLoseAssets',
  [_securityProvider.BlockaidReason.tradeOrderFarming]: 'blockaidDescriptionMightLoseAssets',
  [_securityProvider.BlockaidReason.rawNativeTokenTransfer]: 'blockaidDescriptionTransferFarming',
  [_securityProvider.BlockaidReason.transferFarming]: 'blockaidDescriptionTransferFarming',
  [_securityProvider.BlockaidReason.transferFromFarming]: 'blockaidDescriptionTransferFarming',
  [_securityProvider.BlockaidReason.other]: 'blockaidDescriptionMightLoseAssets'
});

/** Reason to title translation key mapping. */
const REASON_TO_TITLE_TKEY = exports.REASON_TO_TITLE_TKEY = Object.freeze({
  [_securityProvider.BlockaidReason.errored]: 'blockaidTitleMayNotBeSafe',
  [_securityProvider.BlockaidReason.rawSignatureFarming]: 'blockaidTitleSuspicious'
});

/**
 * Returns the corresponding AlertSeverity based on the provided BlockaidResultType.
 *
 * @param severity - The BlockaidResultType to determine the AlertSeverity for.
 * @returns The AlertSeverity corresponding to the provided BlockaidResultType.
 */
function getProviderAlertSeverity(severity) {
  switch (severity) {
    case _securityProvider.BlockaidResultType.Malicious:
      return _designSystem.Severity.Danger;
    case _securityProvider.BlockaidResultType.Warning:
      return _designSystem.Severity.Warning;
    default:
      return _designSystem.Severity.Info;
  }
}

/**
 * Normalizes a security alert response into an Alert object.
 *
 * @param securityAlertResponse - The security alert response to normalize.
 * @param t - The translation function.
 * @param reportUrl - URL to report.
 * @returns The normalized Alert object.
 */
function normalizeProviderAlert(securityAlertResponse, t, reportUrl) {
  return {
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    key: securityAlertResponse.securityAlertId || '',
    reason: t(REASON_TO_TITLE_TKEY[securityAlertResponse.reason] || 'blockaidTitleDeceptive'),
    severity: getProviderAlertSeverity(securityAlertResponse.result_type),
    alertDetails: securityAlertResponse.features,
    message: t(REASON_TO_DESCRIPTION_TKEY[securityAlertResponse.reason] || REASON_TO_DESCRIPTION_TKEY.other),
    provider: _securityProvider.SecurityProvider.Blockaid,
    // TODO: Remove this once we support more providers and implement a way to determine it.
    reportUrl
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\alerts\\utils.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\gas\\useIsGaslessLoading.ts", {"../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","../useIsInsufficientBalance":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useIsInsufficientBalance.ts","./useIsGaslessSupported":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\gas\\useIsGaslessSupported.ts","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Cgas%5CuseIsGaslessLoading.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsGaslessLoading = useIsGaslessLoading;
var _reactRedux = require("react-redux");
var _confirm = require("../../context/confirm");
var _selectors = require("../../../../selectors");
var _useIsInsufficientBalance = require("../useIsInsufficientBalance");
var _useIsGaslessSupported = require("./useIsGaslessSupported");
function useIsGaslessLoading() {
  const {
    currentConfirmation: transactionMeta
  } = (0, _confirm.useConfirmContext)();
  const {
    gasFeeTokens
  } = transactionMeta ?? {};
  const {
    isSupported: isGaslessSupported
  } = (0, _useIsGaslessSupported.useIsGaslessSupported)();
  const isSimulationEnabled = (0, _reactRedux.useSelector)(_selectors.getUseTransactionSimulations);
  const hasInsufficientNative = (0, _useIsInsufficientBalance.useIsInsufficientBalance)();
  const isGaslessLoading = isSimulationEnabled && isGaslessSupported && hasInsufficientNative && !gasFeeTokens;
  return {
    isGaslessLoading
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\gas\\useIsGaslessLoading.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\gas\\useIsGaslessSupported.ts", {"../../../../../shared/modules/selectors":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\index.ts","../../../../hooks/useAsync":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAsync.ts","../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../../../store/controller-actions/transaction-controller":"D:\\code\\v\\metamask-extension\\ui\\store\\controller-actions\\transaction-controller.ts","../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Cgas%5CuseIsGaslessSupported.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsGaslessSupported = useIsGaslessSupported;
var _reactRedux = require("react-redux");
var _selectors = require("../../../../../shared/modules/selectors");
var _useAsync = require("../../../../hooks/useAsync");
var _transactionController = require("../../../../store/controller-actions/transaction-controller");
var _confirm = require("../../context/confirm");
var _actions = require("../../../../store/actions");
function useIsGaslessSupported() {
  const {
    currentConfirmation: transactionMeta
  } = (0, _confirm.useConfirmContext)();
  const {
    chainId,
    txParams
  } = transactionMeta ?? {};
  const {
    from
  } = txParams ?? {};
  const isSmartTransaction = (0, _reactRedux.useSelector)(state => (0, _selectors.getIsSmartTransaction)(state, chainId));
  const {
    value: atomicBatchSupportResult
  } = (0, _useAsync.useAsyncResult)(async () => {
    if (isSmartTransaction) {
      return undefined;
    }
    return (0, _transactionController.isAtomicBatchSupported)({
      address: from,
      chainIds: [chainId]
    });
  }, [chainId, from, isSmartTransaction]);
  const {
    value: relaySupportsChain
  } = (0, _useAsync.useAsyncResult)(async () => {
    if (isSmartTransaction) {
      return undefined;
    }
    return (0, _actions.isRelaySupported)(chainId);
  }, [chainId, isSmartTransaction]);
  const {
    value: sendBundleSupportsChain
  } = (0, _useAsync.useAsyncResult)(async () => {
    return (0, _actions.isSendBundleSupported)(chainId);
  }, [chainId]);
  const atomicBatchChainSupport = atomicBatchSupportResult === null || atomicBatchSupportResult === void 0 ? void 0 : atomicBatchSupportResult.find(result => result.chainId.toLowerCase() === chainId.toLowerCase());

  // Currently requires upgraded account, can also support no `delegationAddress` in future.
  const is7702Supported = Boolean((atomicBatchChainSupport === null || atomicBatchChainSupport === void 0 ? void 0 : atomicBatchChainSupport.isSupported) && relaySupportsChain &&
  // contract deployments can't be delegated
  (transactionMeta === null || transactionMeta === void 0 ? void 0 : transactionMeta.txParams.to) !== undefined);
  const isSupported = Boolean(isSmartTransaction && sendBundleSupportsChain || is7702Supported);
  return {
    isSupported,
    isSmartTransaction
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\gas\\useIsGaslessSupported.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\metrics\\useAmountSelectionMetrics.ts", {"../../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../context/send":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\send\\index.tsx","../../../context/send-metrics":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\send-metrics\\index.tsx","../useSendType":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useSendType.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Csend%5Cmetrics%5CuseAmountSelectionMetrics.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAmountSelectionMetrics = void 0;
var _react = require("react");
var _metametrics = require("../../../../../../shared/constants/metametrics");
var _metametrics2 = require("../../../../../contexts/metametrics");
var _send = require("../../../context/send");
var _sendMetrics = require("../../../context/send-metrics");
var _useSendType = require("../useSendType");
const useAmountSelectionMetrics = () => {
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const {
    chainId
  } = (0, _send.useSendContext)();
  const {
    isEvmSendType
  } = (0, _useSendType.useSendType)();
  const {
    accountType,
    amountInputMethod,
    amountInputType,
    setAmountInputMethod,
    setAmountInputType
  } = (0, _sendMetrics.useSendMetricsContext)();
  const setAmountInputMethodManual = (0, _react.useCallback)(() => {
    setAmountInputMethod(_sendMetrics.AmountInputMethod.Manual);
  }, [setAmountInputMethod]);
  const setAmountInputMethodPasted = (0, _react.useCallback)(() => {
    setAmountInputMethod(_sendMetrics.AmountInputMethod.Pasted);
  }, [setAmountInputMethod]);
  const setAmountInputMethodPressedMax = (0, _react.useCallback)(() => {
    setAmountInputMethod(_sendMetrics.AmountInputMethod.PressedMax);
  }, [setAmountInputMethod]);
  const setAmountInputTypeFiat = (0, _react.useCallback)(() => {
    setAmountInputType(_sendMetrics.AmountInputType.Fiat);
  }, [setAmountInputType]);
  const setAmountInputTypeToken = (0, _react.useCallback)(() => {
    setAmountInputType(_sendMetrics.AmountInputType.Token);
  }, [setAmountInputType]);
  const captureAmountSelected = (0, _react.useCallback)(() => {
    trackEvent({
      event: _metametrics.MetaMetricsEventName.SendAmountSelected,
      category: _metametrics.MetaMetricsEventCategory.Send,
      properties: {
        // eslint-disable-next-line @typescript-eslint/naming-convention
        account_type: accountType,
        // eslint-disable-next-line @typescript-eslint/naming-convention
        input_method: amountInputMethod,
        // eslint-disable-next-line @typescript-eslint/naming-convention
        input_type: amountInputType,
        // eslint-disable-next-line @typescript-eslint/naming-convention
        chain_id: isEvmSendType ? chainId : undefined,
        // eslint-disable-next-line @typescript-eslint/naming-convention
        chain_id_caip: isEvmSendType ? undefined : chainId
      }
    }, {
      excludeMetaMetricsId: false
    });
  }, [accountType, amountInputMethod, amountInputType, chainId, isEvmSendType, trackEvent]);
  return {
    captureAmountSelected,
    setAmountInputMethodManual,
    setAmountInputMethodPasted,
    setAmountInputMethodPressedMax,
    setAmountInputTypeFiat,
    setAmountInputTypeToken
  };
};
exports.useAmountSelectionMetrics = useAmountSelectionMetrics;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\send\\metrics\\useAmountSelectionMetrics.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\metrics\\useAssetSelectionMetrics.ts", {"../../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../context/send-metrics":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\send-metrics\\index.tsx","../useSendAssets":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useSendAssets.ts","ethers/lib/utils":"D:\\code\\v\\metamask-extension\\node_modules\\ethers\\lib\\utils.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Csend%5Cmetrics%5CuseAssetSelectionMetrics.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAssetSelectionMetrics = void 0;
var _react = require("react");
var _utils = require("ethers/lib/utils");
var _metametrics = require("../../../../../../shared/constants/metametrics");
var _metametrics2 = require("../../../../../contexts/metametrics");
var _sendMetrics = require("../../../context/send-metrics");
var _useSendAssets = require("../useSendAssets");
/* eslint-disable @typescript-eslint/naming-convention */

const ASSET_TYPE = {
  NFT: 'nft',
  NATIVE: 'native',
  TOKEN: 'token'
};
const useAssetSelectionMetrics = () => {
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const {
    tokens,
    nfts
  } = (0, _useSendAssets.useSendAssets)();
  const {
    accountType,
    assetFilterMethod,
    assetListSize,
    setAssetFilterMethod,
    setAssetListSize
  } = (0, _sendMetrics.useSendMetricsContext)();
  const addAssetFilterMethod = (0, _react.useCallback)(filterMethod => {
    const methods = new Set([...assetFilterMethod, filterMethod]);
    const methodsArray = Array.from(methods).filter(method => method !== _sendMetrics.AssetFilterMethod.None);
    setAssetFilterMethod(methodsArray);
  }, [setAssetFilterMethod, assetFilterMethod]);
  const removeAssetFilterMethod = (0, _react.useCallback)(filterMethod => {
    const methodsArray = assetFilterMethod.filter(method => method !== filterMethod);
    if (methodsArray.length === 0) {
      methodsArray.push(_sendMetrics.AssetFilterMethod.None);
    }
    setAssetFilterMethod(methodsArray);
  }, [setAssetFilterMethod, assetFilterMethod]);
  const captureAssetSelected = (0, _react.useCallback)(sendAsset => {
    let assetType = ASSET_TYPE.TOKEN;
    if (sendAsset !== null && sendAsset !== void 0 && sendAsset.tokenId) {
      assetType = ASSET_TYPE.NFT;
    } else if ('isNative' in sendAsset && sendAsset !== null && sendAsset !== void 0 && sendAsset.isNative) {
      assetType = ASSET_TYPE.NATIVE;
    }
    const tokenAddress = (sendAsset === null || sendAsset === void 0 ? void 0 : sendAsset.address) || (sendAsset === null || sendAsset === void 0 ? void 0 : sendAsset.assetId);
    const isEvmSend = (0, _utils.isAddress)(tokenAddress);
    const allAssets = [...tokens, ...nfts];
    const position = allAssets.findIndex(asset => {
      if (sendAsset.tokenId) {
        // NFT comparison: address + chainId + tokenId
        return asset.address === sendAsset.address && asset.chainId === sendAsset.chainId && asset.tokenId === sendAsset.tokenId;
      } else if (sendAsset.isNative) {
        // Native token comparison: isNative + chainId
        return asset.isNative === sendAsset.isNative && asset.chainId === sendAsset.chainId;
      }
      // ERC20 token comparison: address + chainId
      return asset.address === sendAsset.address && asset.chainId === sendAsset.chainId;
    }) + 1;
    trackEvent({
      event: _metametrics.MetaMetricsEventName.SendAssetSelected,
      category: _metametrics.MetaMetricsEventCategory.Send,
      properties: {
        account_type: accountType,
        asset_type: assetType,
        asset_list_position: position,
        asset_list_size: assetListSize,
        chain_id: sendAsset === null || sendAsset === void 0 ? void 0 : sendAsset.chainId,
        chain_id_caip: isEvmSend ? `eip155:${parseInt(sendAsset === null || sendAsset === void 0 ? void 0 : sendAsset.chainId, 16)}` : sendAsset === null || sendAsset === void 0 ? void 0 : sendAsset.chainId,
        filter_method: assetFilterMethod
      }
    }, {
      excludeMetaMetricsId: false
    });
  }, [accountType, assetFilterMethod, assetListSize, trackEvent, tokens, nfts]);
  return {
    addAssetFilterMethod,
    captureAssetSelected,
    removeAssetFilterMethod,
    setAssetListSize
  };
};
exports.useAssetSelectionMetrics = useAssetSelectionMetrics;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\send\\metrics\\useAssetSelectionMetrics.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\metrics\\useRecipientSelectionMetrics.ts", {"../../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../context/send":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\send\\index.tsx","../../../context/send-metrics":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\send-metrics\\index.tsx","../useSendType":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useSendType.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Csend%5Cmetrics%5CuseRecipientSelectionMetrics.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRecipientSelectionMetrics = void 0;
var _react = require("react");
var _metametrics = require("../../../../../../shared/constants/metametrics");
var _metametrics2 = require("../../../../../contexts/metametrics");
var _sendMetrics = require("../../../context/send-metrics");
var _send = require("../../../context/send");
var _useSendType = require("../useSendType");
/* eslint-disable @typescript-eslint/naming-convention */

const useRecipientSelectionMetrics = () => {
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const {
    chainId
  } = (0, _send.useSendContext)();
  const {
    isEvmSendType
  } = (0, _useSendType.useSendType)();
  const {
    accountType,
    recipientInputMethod,
    setRecipientInputMethod
  } = (0, _sendMetrics.useSendMetricsContext)();
  const setRecipientInputMethodManual = (0, _react.useCallback)(() => {
    setRecipientInputMethod(_sendMetrics.RecipientInputMethod.Manual);
  }, [setRecipientInputMethod]);
  const setRecipientInputMethodPasted = (0, _react.useCallback)(() => {
    setRecipientInputMethod(_sendMetrics.RecipientInputMethod.Pasted);
  }, [setRecipientInputMethod]);
  const setRecipientInputMethodSelectAccount = (0, _react.useCallback)(() => {
    setRecipientInputMethod(_sendMetrics.RecipientInputMethod.SelectAccount);
  }, [setRecipientInputMethod]);
  const setRecipientInputMethodSelectContact = (0, _react.useCallback)(() => {
    setRecipientInputMethod(_sendMetrics.RecipientInputMethod.SelectContact);
  }, [setRecipientInputMethod]);
  const captureRecipientSelected = (0, _react.useCallback)(async () => {
    trackEvent({
      event: _metametrics.MetaMetricsEventName.SendRecipientSelected,
      category: _metametrics.MetaMetricsEventCategory.Send,
      properties: {
        account_type: accountType,
        input_method: recipientInputMethod,
        chain_id: chainId,
        chain_id_caip: isEvmSendType ? `eip155:${parseInt(chainId, 16)}` : chainId
      }
    }, {
      excludeMetaMetricsId: false
    });
  }, [accountType, chainId, isEvmSendType, recipientInputMethod, trackEvent]);
  return {
    captureRecipientSelected,
    setRecipientInputMethodManual,
    setRecipientInputMethodPasted,
    setRecipientInputMethodSelectAccount,
    setRecipientInputMethodSelectContact
  };
};
exports.useRecipientSelectionMetrics = useRecipientSelectionMetrics;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\send\\metrics\\useRecipientSelectionMetrics.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useAccountAddressSeedIconMap.ts", {"../../../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Csend%5CuseAccountAddressSeedIconMap.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAccountAddressSeedIconMap = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _accountTree = require("../../../../selectors/multichain-accounts/account-tree");
const useAccountAddressSeedIconMap = () => {
  const accountGroupsWithAddresses = (0, _reactRedux.useSelector)(_accountTree.getAccountGroupWithInternalAccounts);
  const accountAddressSeedIconMap = (0, _react.useMemo)(() => {
    const map = new Map();
    accountGroupsWithAddresses.forEach(accountGroup => {
      const {
        accounts
      } = accountGroup;
      if (accounts.length === 0) {
        return;
      }
      const seedAddress = accounts[0].address;
      accounts.forEach(account => {
        map.set(account.address.toLowerCase(), seedAddress);
      });
    });
    return map;
  }, [accountGroupsWithAddresses]);
  return {
    accountAddressSeedIconMap
  };
};
exports.useAccountAddressSeedIconMap = useAccountAddressSeedIconMap;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\send\\useAccountAddressSeedIconMap.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useAccountRecipients.ts", {"../../../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","../../context/send":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\send\\index.tsx","../../utils/account":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\utils\\account.ts","./useAccountAddressSeedIconMap":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useAccountAddressSeedIconMap.ts","./useSendType":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useSendType.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Csend%5CuseAccountRecipients.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAccountRecipients = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _accountTree = require("../../../../selectors/multichain-accounts/account-tree");
var _account = require("../../utils/account");
var _send = require("../../context/send");
var _useSendType = require("./useSendType");
var _useAccountAddressSeedIconMap = require("./useAccountAddressSeedIconMap");
const useAccountRecipients = () => {
  const {
    isEvmSendType,
    isSolanaSendType,
    isBitcoinSendType
  } = (0, _useSendType.useSendType)();
  const {
    from
  } = (0, _send.useSendContext)();
  const {
    accountAddressSeedIconMap
  } = (0, _useAccountAddressSeedIconMap.useAccountAddressSeedIconMap)();
  const walletsWithAccounts = (0, _reactRedux.useSelector)(_accountTree.getWalletsWithAccounts);
  return (0, _react.useMemo)(() => {
    const recipients = [];
    Object.values(walletsWithAccounts).forEach(wallet => {
      var _wallet$metadata;
      const walletName = (_wallet$metadata = wallet.metadata) === null || _wallet$metadata === void 0 ? void 0 : _wallet$metadata.name;
      Object.values(wallet.groups).forEach(group => {
        var _group$metadata;
        const accountGroupName = (_group$metadata = group.metadata) === null || _group$metadata === void 0 ? void 0 : _group$metadata.name;
        group.accounts.forEach(account => {
          if (account.address === from) {
            return;
          }
          const shouldInclude = isEvmSendType && (0, _account.isEVMAccountForSend)(account) || isSolanaSendType && (0, _account.isSolanaAccountForSend)(account) || isBitcoinSendType && (0, _account.isBitcoinAccountForSend)(account);
          if (shouldInclude) {
            recipients.push({
              seedIcon: accountAddressSeedIconMap.get(account.address.toLowerCase()),
              accountGroupName,
              address: account.address,
              walletName
            });
          }
        });
      });
    });
    return recipients;
  }, [from, isEvmSendType, isSolanaSendType, isBitcoinSendType, accountAddressSeedIconMap, walletsWithAccounts]);
};
exports.useAccountRecipients = useAccountRecipients;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\send\\useAccountRecipients.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useAmountValidation.ts", {"../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../context/send":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\send\\index.tsx","../../utils/send":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\utils\\send.ts","./useBalance":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useBalance.ts","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Csend%5CuseAmountValidation.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateTokenBalance = exports.validateERC1155Balance = exports.useAmountValidation = void 0;
var _controllerUtils = require("@metamask/controller-utils");
var _react = require("react");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _send = require("../../utils/send");
var _send2 = require("../../context/send");
var _useBalance = require("./useBalance");
const validateERC1155Balance = (asset, value, t) => {
  if (asset !== null && asset !== void 0 && asset.balance && value) {
    if (parseInt(value, 10) > parseInt(asset.balance.toString(), 10)) {
      return t('insufficientFundsSend');
    }
  }
  return undefined;
};
exports.validateERC1155Balance = validateERC1155Balance;
const validateTokenBalance = (amount, rawBalanceNumeric, t, decimals) => {
  const amountInputNumeric = (0, _send.fromTokenMinUnitsNumeric)(amount, 10, decimals);
  if (rawBalanceNumeric.lessThan(amountInputNumeric)) {
    return t('insufficientFundsSend');
  }
  return undefined;
};
exports.validateTokenBalance = validateTokenBalance;
const useAmountValidation = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    asset,
    value
  } = (0, _send2.useSendContext)();
  const {
    rawBalanceNumeric
  } = (0, _useBalance.useBalance)();
  const amountError = (0, _react.useMemo)(() => {
    if (value === undefined || value === null || value === '') {
      return undefined;
    }
    if (!(0, _send.isValidPositiveNumericString)(value)) {
      return t('invalidValue');
    }
    if ((asset === null || asset === void 0 ? void 0 : asset.standard) === _controllerUtils.ERC1155) {
      return validateERC1155Balance(asset, value, t);
    }
    return validateTokenBalance(value, rawBalanceNumeric, t, asset === null || asset === void 0 ? void 0 : asset.decimals);
  }, [asset, rawBalanceNumeric, t, value]);
  return {
    amountError
  };
};
exports.useAmountValidation = useAmountValidation;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\send\\useAmountValidation.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useBalance.ts", {"../../../../../shared/modules/Numeric":"D:\\code\\v\\metamask-extension\\shared\\modules\\Numeric.ts","../../context/send":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\send\\index.tsx","../../utils/send":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\utils\\send.ts","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Csend%5CuseBalance.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBalance = void 0;
var _controllerUtils = require("@metamask/controller-utils");
var _react = require("react");
var _Numeric = require("../../../../../shared/modules/Numeric");
var _send = require("../../utils/send");
var _send2 = require("../../context/send");
const getBalance = asset => {
  if (!asset) {
    return {
      balance: '0',
      decimals: 0,
      rawBalanceNumeric: new _Numeric.Numeric('0', 10)
    };
  }
  const rawBalanceHex = (asset === null || asset === void 0 ? void 0 : asset.rawBalance) ?? '0x0';
  return {
    balance: (0, _send.formatToFixedDecimals)((0, _send.toTokenMinimalUnit)(rawBalanceHex, asset.decimals), asset.decimals),
    decimals: asset.decimals,
    rawBalanceNumeric: new _Numeric.Numeric(rawBalanceHex, 16).toBase(10)
  };
};
const useBalance = () => {
  const {
    asset
  } = (0, _send2.useSendContext)();
  const {
    balance,
    decimals,
    rawBalanceNumeric
  } = (0, _react.useMemo)(() => {
    if ((asset === null || asset === void 0 ? void 0 : asset.standard) === _controllerUtils.ERC1155) {
      const bal = (asset === null || asset === void 0 ? void 0 : asset.balance) ?? '0';
      return {
        balance: bal,
        decimals: 0,
        rawBalanceNumeric: new _Numeric.Numeric(bal, 10)
      };
    }
    return getBalance(asset);
  }, [asset]);
  return {
    balance,
    decimals,
    rawBalanceNumeric
  };
};
exports.useBalance = useBalance;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\send\\useBalance.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useContactRecipients.ts", {"../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","./useAccountAddressSeedIconMap":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useAccountAddressSeedIconMap.ts","./useSendType":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useSendType.ts","ethers/lib/utils":"D:\\code\\v\\metamask-extension\\node_modules\\ethers\\lib\\utils.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Csend%5CuseContactRecipients.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useContactRecipients = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _utils = require("ethers/lib/utils");
var _selectors = require("../../../../selectors");
var _useSendType = require("./useSendType");
var _useAccountAddressSeedIconMap = require("./useAccountAddressSeedIconMap");
const useContactRecipients = () => {
  const {
    isEvmSendType
  } = (0, _useSendType.useSendType)();
  const addressBook = (0, _reactRedux.useSelector)(_selectors.getCompleteAddressBook);
  const {
    accountAddressSeedIconMap
  } = (0, _useAccountAddressSeedIconMap.useAccountAddressSeedIconMap)();
  const processContacts = (0, _react.useCallback)(contact => {
    return {
      address: contact.address,
      contactName: contact.name,
      isContact: true,
      seedIcon: accountAddressSeedIconMap.get(contact.address.toLowerCase())
    };
  }, [accountAddressSeedIconMap]);

  // Contacts are only supported for EVM chains today - hence we only return contacts for EVM chains
  if (isEvmSendType) {
    return addressBook.filter(contact => (0, _utils.isAddress)(contact.address)).map(processContacts);
  }
  return [];
};
exports.useContactRecipients = useContactRecipients;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\send\\useContactRecipients.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useCurrencyConversions.ts", {"../../../../helpers/utils/common.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\common.util.js","../../../../hooks/useMultichainSelector":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainSelector.ts","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../context/send":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\send\\index.tsx","../../utils/send":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\utils\\send.ts","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Csend%5CuseCurrencyConversions.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCurrencyConversions = void 0;
var _controllerUtils = require("@metamask/controller-utils");
var _react = require("react");
var _reactRedux = require("react-redux");
var _selectors = require("../../../../selectors");
var _common = require("../../../../helpers/utils/common.util");
var _multichain = require("../../../../selectors/multichain");
var _useMultichainSelector = require("../../../../hooks/useMultichainSelector");
var _send = require("../../utils/send");
var _send2 = require("../../context/send");
const getFiatValueFn = ({
  amount,
  conversionRate
}) => {
  if (!amount) {
    return '0';
  }
  return (0, _send.convertedCurrency)(amount, conversionRate, 2) ?? '0';
};
const getFiatDisplayValueFn = ({
  amount,
  conversionRate,
  currentCurrency
}) => {
  if (!amount) {
    return `${(0, _common.getCurrencySymbol)(currentCurrency)} 0.00`;
  }
  const amt = amount ? (0, _send.formatToFixedDecimals)(getFiatValueFn({
    amount,
    conversionRate
  }), 2, false) : '0.00';
  return `${(0, _common.getCurrencySymbol)(currentCurrency)} ${amt}`;
};
const getNativeValueFn = ({
  asset,
  amount,
  conversionRate
}) => {
  if (!amount) {
    return '0';
  }
  return (0, _send.convertedCurrency)(amount, conversionRate === 0 ? 0 : 1 / conversionRate, asset === null || asset === void 0 ? void 0 : asset.decimals) ?? '0';
};
const useCurrencyConversions = () => {
  const {
    asset,
    fromAccount
  } = (0, _send2.useSendContext)();
  const currentCurrency = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainCurrentCurrency, fromAccount);
  const contractExchangeRates = (0, _reactRedux.useSelector)(_selectors.getCrossChainTokenExchangeRates);
  const exchangeRate = (0, _react.useMemo)(() => {
    var _Object$values$find;
    if (!asset) {
      return 1;
    }
    return ((_Object$values$find = Object.values(contractExchangeRates).find(rate => rate[asset.address] !== undefined)) === null || _Object$values$find === void 0 ? void 0 : _Object$values$find[asset.address]) ?? 1;
  }, [asset, contractExchangeRates]);
  const conversionRate = (0, _react.useMemo)(() => {
    var _fiat;
    const assetAddress = (asset === null || asset === void 0 ? void 0 : asset.address) ?? (asset === null || asset === void 0 ? void 0 : asset.assetId);
    if (!asset || !assetAddress || asset.standard === _controllerUtils.ERC1155 || asset.standard === _controllerUtils.ERC721) {
      return 0;
    }
    return ((asset === null || asset === void 0 || (_fiat = asset.fiat) === null || _fiat === void 0 ? void 0 : _fiat.conversionRate) ?? 0) * exchangeRate;
  }, [asset, exchangeRate]);
  const getFiatValue = (0, _react.useCallback)(amount => getFiatValueFn({
    amount,
    conversionRate
  }), [conversionRate]);
  const getFiatDisplayValue = (0, _react.useCallback)(amount => getFiatDisplayValueFn({
    amount,
    conversionRate,
    currentCurrency
  }), [conversionRate, currentCurrency]);
  const getNativeValue = (0, _react.useCallback)(amount => getNativeValueFn({
    asset,
    amount,
    conversionRate
  }), [asset, conversionRate]);
  return {
    conversionSupportedForAsset: conversionRate !== 0 && (asset === null || asset === void 0 ? void 0 : asset.standard) !== _controllerUtils.ERC1155 && (asset === null || asset === void 0 ? void 0 : asset.standard) !== _controllerUtils.ERC721,
    fiatCurrencySymbol: (0, _common.getCurrencySymbol)(currentCurrency),
    fiatCurrencyName: currentCurrency,
    getFiatValue,
    getFiatDisplayValue,
    getNativeValue
  };
};
exports.useCurrencyConversions = useCurrencyConversions;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\send\\useCurrencyConversions.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useERC1155BalanceChecker.ts", {"../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../types/send":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\types\\send.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Csend%5CuseERC1155BalanceChecker.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useERC1155BalanceChecker = void 0;
var _react = require("react");
var _actions = require("../../../../store/actions");
var _send = require("../../types/send");
const useERC1155BalanceChecker = () => {
  const fetchBalanceForNft = (0, _react.useCallback)(async nft => {
    if (nft.standard !== _send.AssetStandard.ERC1155) {
      return null;
    }
    try {
      const networkClientId = await (0, _actions.findNetworkClientIdByChainId)(nft.chainId);
      const balance = await (0, _actions.getERC1155BalanceOf)(nft.accountAddress, nft.address, nft.tokenId, networkClientId);
      return {
        nft,
        balance: Number(balance)
      };
    } catch (error) {
      console.error('Error fetching ERC1155 balance:', error);
      return null;
    }
  }, []);
  return {
    fetchBalanceForNft
  };
};
exports.useERC1155BalanceChecker = useERC1155BalanceChecker;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\send\\useERC1155BalanceChecker.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useMaxAmount.ts", {"../../../../../shared/modules/Numeric":"D:\\code\\v\\metamask-extension\\shared\\modules\\Numeric.ts","../../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../../hooks/useAsync":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAsync.ts","../../context/send":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\send\\index.tsx","../../utils/send":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\utils\\send.ts","./useBalance":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useBalance.ts","./useSendType":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useSendType.ts","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Csend%5CuseMaxAmount.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMaxAmount = exports.getEstimatedTotalGas = void 0;
var _transactionController = require("@metamask/transaction-controller");
var _react = require("react");
var _reactRedux = require("react-redux");
var _Numeric = require("../../../../../shared/modules/Numeric");
var _metamask = require("../../../../ducks/metamask/metamask");
var _useAsync = require("../../../../hooks/useAsync");
var _send = require("../../utils/send");
var _send2 = require("../../context/send");
var _useBalance = require("./useBalance");
var _useSendType = require("./useSendType");
const NATIVE_TRANSFER_GAS_LIMIT = 21000;
const GWEI_TO_WEI_CONVERSION_RATE = 1e9;
const getEstimatedTotalGas = (layer1GasFees, gasFeeEstimates) => {
  if (!gasFeeEstimates) {
    return new _Numeric.Numeric('0', 10);
  }
  const {
    medium: {
      suggestedMaxFeePerGas
    } = {
      suggestedMaxFeePerGas: 0
    }
  } = gasFeeEstimates;
  const totalGas = new _Numeric.Numeric(suggestedMaxFeePerGas * NATIVE_TRANSFER_GAS_LIMIT, 10);
  const conversionrate = new _Numeric.Numeric(GWEI_TO_WEI_CONVERSION_RATE, 10);
  return totalGas.times(conversionrate).add(new _Numeric.Numeric(layer1GasFees, 16));
};
exports.getEstimatedTotalGas = getEstimatedTotalGas;
const getMaxAmountFn = ({
  asset,
  layer1GasFees,
  gasFeeEstimates,
  isEvmNativeSendType,
  rawBalanceNumeric
}) => {
  if (!asset) {
    return '0';
  }
  let estimatedTotalGas = new _Numeric.Numeric('0', 10);
  if (isEvmNativeSendType) {
    estimatedTotalGas = getEstimatedTotalGas(layer1GasFees, gasFeeEstimates);
  }
  const balance = rawBalanceNumeric.minus(estimatedTotalGas);
  return balance.isZero() || balance.isNegative() ? '0' : (0, _send.toTokenMinimalUnit)(balance.toString(), asset.decimals, 10);
};
const useMaxAmount = () => {
  const {
    asset,
    chainId,
    from,
    value
  } = (0, _send2.useSendContext)();
  const {
    isEvmSendType,
    isEvmNativeSendType
  } = (0, _useSendType.useSendType)();
  const {
    rawBalanceNumeric
  } = (0, _useBalance.useBalance)();
  const gasFeeEstimates = (0, _reactRedux.useSelector)(state => {
    if (chainId && isEvmSendType) {
      return (0, _metamask.getGasFeeEstimatesByChainId)(state, chainId);
    }
    return undefined;
  });
  const {
    value: layer1GasFees
  } = (0, _useAsync.useAsyncResult)(async () => {
    if (!isEvmNativeSendType || (asset === null || asset === void 0 ? void 0 : asset.chainId) === _transactionController.CHAIN_IDS.MAINNET || !from) {
      return '0x0';
    }
    return await (0, _send.getLayer1GasFees)({
      asset: asset,
      chainId: chainId,
      from: from,
      value: value ?? '0'
    });
  }, [asset, chainId, from, value]);
  const getMaxAmount = (0, _react.useCallback)(() => {
    return getMaxAmountFn({
      asset,
      gasFeeEstimates,
      isEvmNativeSendType,
      layer1GasFees: layer1GasFees ?? '0x0',
      rawBalanceNumeric
    });
  }, [asset, gasFeeEstimates, isEvmNativeSendType, layer1GasFees, rawBalanceNumeric]);
  return {
    getMaxAmount
  };
};
exports.useMaxAmount = useMaxAmount;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\send\\useMaxAmount.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useNameValidation.ts", {"../../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../../hooks/snaps/useSnapNameResolution":"D:\\code\\v\\metamask-extension\\ui\\hooks\\snaps\\useSnapNameResolution.ts","../../utils/sendValidations":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\utils\\sendValidations.ts","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Csend%5CuseNameValidation.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNameValidation = void 0;
var _bridgeController = require("@metamask/bridge-controller");
var _react = require("react");
var _util = require("../../../../helpers/utils/util");
var _useSnapNameResolution = require("../../../../hooks/snaps/useSnapNameResolution");
var _sendValidations = require("../../utils/sendValidations");
const useNameValidation = () => {
  const {
    fetchResolutions
  } = (0, _useSnapNameResolution.useSnapNameResolution)();
  const validateName = (0, _react.useCallback)(async (chainId, to) => {
    if ((0, _util.isValidDomainName)(to)) {
      var _resolutions$, _resolutions$2;
      const resolutions = await fetchResolutions((0, _bridgeController.formatChainIdToCaip)(chainId), to);
      if (resolutions.length === 0) {
        return {
          error: 'nameResolutionFailedError'
        };
      }
      const resolvedLookup = (_resolutions$ = resolutions[0]) === null || _resolutions$ === void 0 ? void 0 : _resolutions$.resolvedAddress;
      const protocol = (_resolutions$2 = resolutions[0]) === null || _resolutions$2 === void 0 ? void 0 : _resolutions$2.protocol;
      return {
        resolvedLookup,
        protocol,
        ...(0, _sendValidations.findConfusablesInRecipient)(to)
      };
    }
    return {
      error: 'nameResolutionFailedError'
    };
  }, [fetchResolutions]);
  return {
    validateName
  };
};
exports.useNameValidation = useNameValidation;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\send\\useNameValidation.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useNavigateSendPage.ts", {"../../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../constants/send":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\constants\\send.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Csend%5CuseNavigateSendPage.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNavigateSendPage = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _routes = require("../../../../helpers/constants/routes");
var _send = require("../../constants/send");
const useNavigateSendPage = () => {
  const history = (0, _reactRouterDom.useHistory)();
  const [searchParams] = (0, _reactRouterDomV5Compat.useSearchParams)();
  const goToAmountRecipientPage = (0, _react.useCallback)(() => {
    history.push(`${_routes.SEND_ROUTE}/${_send.SendPages.AMOUNTRECIPIENT}?${searchParams.toString()}`);
  }, [searchParams, history]);
  const goToPreviousPage = (0, _react.useCallback)(() => {
    history.goBack();
  }, [history]);
  return {
    goToAmountRecipientPage,
    goToPreviousPage
  };
};
exports.useNavigateSendPage = useNavigateSendPage;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\send\\useNavigateSendPage.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useRecipientValidation.ts", {"../../../../../shared/lib/multichain/accounts":"D:\\code\\v\\metamask-extension\\shared\\lib\\multichain\\accounts.ts","../../../../../shared/modules/hexstring-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\hexstring-utils.ts","../../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../context/send":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\send\\index.tsx","../../utils/sendValidations":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\utils\\sendValidations.ts","./useNameValidation":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useNameValidation.ts","./useSendType":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useSendType.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Csend%5CuseRecipientValidation.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRecipientValidation = void 0;
var _react = require("react");
var _accounts = require("../../../../../shared/lib/multichain/accounts");
var _hexstringUtils = require("../../../../../shared/modules/hexstring-utils");
var _util = require("../../../../helpers/utils/util");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _sendValidations = require("../../utils/sendValidations");
var _send = require("../../context/send");
var _useSendType = require("./useSendType");
var _useNameValidation = require("./useNameValidation");
// Avoid creating multiple instance of this hook in send flow,
// as ens validation is very expensive operation. And result can slow-down
// and result in bugs if multiple instances are created.
const useRecipientValidation = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    asset,
    chainId,
    to
  } = (0, _send.useSendContext)();
  const {
    isEvmSendType,
    isSolanaSendType,
    isBitcoinSendType
  } = (0, _useSendType.useSendType)();
  const {
    validateName
  } = (0, _useNameValidation.useNameValidation)();
  const [result, setResult] = (0, _react.useState)({});
  const prevAddressValidated = (0, _react.useRef)();
  const unmountedRef = (0, _react.useRef)(false);
  (0, _react.useEffect)(() => {
    return () => {
      unmountedRef.current = true;
    };
  }, []);
  const validateRecipient = (0, _react.useCallback)(async toAddress => {
    if (!toAddress || !chainId) {
      return {};
    }
    if (isEvmSendType && (0, _hexstringUtils.isValidHexAddress)(toAddress)) {
      return await (0, _sendValidations.validateEvmHexAddress)(toAddress, chainId, asset === null || asset === void 0 ? void 0 : asset.address);
    }
    if (isSolanaSendType && (0, _accounts.isSolanaAddress)(toAddress)) {
      return (0, _sendValidations.validateSolanaAddress)(toAddress);
    }
    if (isBitcoinSendType && (0, _accounts.isBtcMainnetAddress)(toAddress)) {
      return (0, _sendValidations.validateBtcAddress)(toAddress);
    }
    if ((0, _util.isValidDomainName)(toAddress)) {
      return await validateName(chainId, toAddress);
    }
    return {
      error: 'invalidAddress'
    };
  }, [asset, chainId, isEvmSendType, isSolanaSendType, isBitcoinSendType, validateName]);
  (0, _react.useEffect)(() => {
    if (prevAddressValidated.current === to) {
      return;
    }
    (async () => {
      prevAddressValidated.current = to;
      const validationResult = await validateRecipient(to);
      if (!unmountedRef.current && prevAddressValidated.current === to) {
        setResult({
          ...validationResult,
          toAddressValidated: to
        });
      }
    })();
  }, [setResult, to, validateRecipient]);
  return {
    recipientConfusableCharacters: result === null || result === void 0 ? void 0 : result.confusableCharacters,
    recipientError: result !== null && result !== void 0 && result.error ? t(result === null || result === void 0 ? void 0 : result.error) : undefined,
    recipientResolvedLookup: result === null || result === void 0 ? void 0 : result.resolvedLookup,
    recipientWarning: result !== null && result !== void 0 && result.warning ? t(result === null || result === void 0 ? void 0 : result.warning) : undefined,
    resolutionProtocol: result === null || result === void 0 ? void 0 : result.protocol,
    toAddressValidated: result === null || result === void 0 ? void 0 : result.toAddressValidated
  };
};
exports.useRecipientValidation = useRecipientValidation;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\send\\useRecipientValidation.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useRecipients.ts", {"./useAccountRecipients":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useAccountRecipients.ts","./useContactRecipients":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useContactRecipients.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Csend%5CuseRecipients.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRecipients = void 0;
var _useContactRecipients = require("./useContactRecipients");
var _useAccountRecipients = require("./useAccountRecipients");
const useRecipients = () => {
  const accountRecipients = (0, _useAccountRecipients.useAccountRecipients)();
  const contactRecipients = (0, _useContactRecipients.useContactRecipients)();
  const recipients = [...accountRecipients];
  contactRecipients.forEach(recipient => {
    if (!recipients.some(r => r.address.toLowerCase() === recipient.address.toLowerCase())) {
      recipients.push(recipient);
    }
  });
  return recipients;
};
exports.useRecipients = useRecipients;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\send\\useRecipients.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useSendActions.ts", {"../../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../constants/send":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\constants\\send.ts","../../context/send":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\send\\index.tsx","../../utils/multichain-snaps":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\utils\\multichain-snaps.ts","../../utils/send":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\utils\\send.ts","./useSendType":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useSendType.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Csend%5CuseSendActions.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSendActions = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _routes = require("../../../../helpers/constants/routes");
var _actions = require("../../../../store/actions");
var _send = require("../../constants/send");
var _multichainSnaps = require("../../utils/multichain-snaps");
var _send2 = require("../../utils/send");
var _send3 = require("../../context/send");
var _useSendType = require("./useSendType");
const useSendActions = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    asset,
    chainId,
    from,
    fromAccount,
    hexData,
    maxValueMode,
    toResolved: to,
    value
  } = (0, _send3.useSendContext)();
  const {
    isEvmSendType
  } = (0, _useSendType.useSendType)();
  const handleSubmit = (0, _react.useCallback)(async () => {
    if (!asset) {
      return;
    }
    const toAddress = to;
    if (isEvmSendType) {
      dispatch(await (0, _send2.submitEvmTransaction)({
        asset,
        chainId: chainId,
        from: from,
        hexData: hexData,
        to: toAddress,
        value: value
      }));
      const route = maxValueMode ? `${_routes.CONFIRM_TRANSACTION_ROUTE}?maxValueMode=${maxValueMode}` : _routes.CONFIRM_TRANSACTION_ROUTE;
      history.push(route);
    } else {
      history.push(`${_routes.SEND_ROUTE}/${_send.SendPages.LOADER}`);
      await dispatch((0, _actions.setDefaultHomeActiveTabName)('activity'));
      try {
        await (0, _multichainSnaps.sendMultichainTransactionForReview)(fromAccount, {
          fromAccountId: fromAccount === null || fromAccount === void 0 ? void 0 : fromAccount.id,
          toAddress: toAddress,
          assetId: asset.assetId,
          amount: (0, _send2.addLeadingZeroIfNeeded)(value)
        });
        history.push(_routes.DEFAULT_ROUTE);
      } catch (error) {
        // intentional empty catch
      }
    }
  }, [asset, chainId, dispatch, from, fromAccount, hexData, history, isEvmSendType, maxValueMode, to, value]);
  const handleBack = (0, _react.useCallback)(() => {
    history.goBack();
  }, [history]);
  const handleCancel = (0, _react.useCallback)(() => {
    history.push(_routes.DEFAULT_ROUTE);
  }, [history]);
  return {
    handleSubmit,
    handleCancel,
    handleBack
  };
};
exports.useSendActions = useSendActions;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\send\\useSendActions.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useSendAssetFilter.ts", {"react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Csend%5CuseSendAssetFilter.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSendAssetFilter = void 0;
var _react = require("react");
const useSendAssetFilter = ({
  tokens,
  nfts,
  selectedChainId,
  searchQuery = ''
}) => {
  return (0, _react.useMemo)(() => {
    let networkFilteredTokens = tokens;
    let networkFilteredNfts = nfts;
    if (selectedChainId !== null) {
      networkFilteredTokens = tokens.filter(token => token.chainId === selectedChainId);
      networkFilteredNfts = nfts.filter(nft => nft.chainId === selectedChainId);
    }
    const filteredTokens = networkFilteredTokens.filter(token => matchesSearchQuery(token, searchQuery));
    const filteredNfts = networkFilteredNfts.filter(nft => matchesSearchQuery(nft, searchQuery));
    return {
      filteredTokens,
      filteredNfts
    };
  }, [tokens, nfts, selectedChainId, searchQuery]);
};
exports.useSendAssetFilter = useSendAssetFilter;
function matchesSearchQuery(asset, query) {
  var _asset$name, _asset$symbol, _asset$collection;
  if (!query.trim()) {
    return true;
  }
  const searchTerm = query.toLowerCase().trim();
  if ((_asset$name = asset.name) !== null && _asset$name !== void 0 && _asset$name.toLowerCase().includes(searchTerm)) {
    return true;
  }
  if ((_asset$symbol = asset.symbol) !== null && _asset$symbol !== void 0 && _asset$symbol.toLowerCase().includes(searchTerm)) {
    return true;
  }
  if ((_asset$collection = asset.collection) !== null && _asset$collection !== void 0 && (_asset$collection = _asset$collection.name) !== null && _asset$collection !== void 0 && _asset$collection.toLowerCase().includes(searchTerm)) {
    return true;
  }
  return false;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\send\\useSendAssetFilter.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useSendAssets.ts", {"./useSendNfts":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useSendNfts.ts","./useSendTokens":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useSendTokens.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Csend%5CuseSendAssets.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSendAssets = void 0;
var _react = require("react");
var _useSendTokens = require("./useSendTokens");
var _useSendNfts = require("./useSendNfts");
const useSendAssets = () => {
  const tokens = (0, _useSendTokens.useSendTokens)();
  const nfts = (0, _useSendNfts.useSendNfts)();
  return (0, _react.useMemo)(() => ({
    tokens,
    nfts
  }), [tokens, nfts]);
};
exports.useSendAssets = useSendAssets;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\send\\useSendAssets.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useSendNfts.ts", {"../../../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","../../../../selectors/nft":"D:\\code\\v\\metamask-extension\\ui\\selectors\\nft.ts","../../types/send":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\types\\send.ts","../useChainNetworkNameAndImage":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useChainNetworkNameAndImage.ts","./useERC1155BalanceChecker":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useERC1155BalanceChecker.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Csend%5CuseSendNfts.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSendNfts = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _nft = require("../../../../selectors/nft");
var _accountTree = require("../../../../selectors/multichain-accounts/account-tree");
var _send = require("../../types/send");
var _useChainNetworkNameAndImage = require("../useChainNetworkNameAndImage");
var _useERC1155BalanceChecker = require("./useERC1155BalanceChecker");
// This is fine to use it in send flow - might be removed in the future
// eslint-disable-next-line no-restricted-syntax

const useSendNfts = () => {
  const chainNetworkNAmeAndImageMap = (0, _useChainNetworkNameAndImage.useChainNetworkNameAndImageMap)();
  const nftsOwnedByAccounts = (0, _reactRedux.useSelector)(_nft.getNftsByChainByAccount);
  const [nfts, setNfts] = (0, _react.useState)([]);
  const {
    fetchBalanceForNft
  } = (0, _useERC1155BalanceChecker.useERC1155BalanceChecker)();
  const selectedAccountGroup = (0, _reactRedux.useSelector)(_accountTree.getSelectedAccountGroup);
  const accountGroupWithInternalAccounts = (0, _reactRedux.useSelector)(_accountTree.getAccountGroupWithInternalAccounts);

  // Memoize the transformed NFTs to prevent unnecessary recalculations
  const transformedNfts = (0, _react.useMemo)(() => {
    var _accountGroupWithInte;
    const selectedAccountGroupWithInternalAccounts = accountGroupWithInternalAccounts === null || accountGroupWithInternalAccounts === void 0 || (_accountGroupWithInte = accountGroupWithInternalAccounts.find(accountGroup => accountGroup.id === selectedAccountGroup)) === null || _accountGroupWithInte === void 0 ? void 0 : _accountGroupWithInte.accounts;
    return transformNftsToAssets(nftsOwnedByAccounts, selectedAccountGroupWithInternalAccounts, chainNetworkNAmeAndImageMap);
  }, [// using accountGroupWithInternalAccounts as dependency is somehow causing repeated renders
  accountGroupWithInternalAccounts === null || accountGroupWithInternalAccounts === void 0 ? void 0 : accountGroupWithInternalAccounts.length, chainNetworkNAmeAndImageMap, nftsOwnedByAccounts, selectedAccountGroup]);

  // Memoize the balance fetching function
  const fetchNftsWithBalances = (0, _react.useCallback)(async nftsArray => {
    const erc1155Nfts = nftsArray.filter(nft => nft.standard === _send.AssetStandard.ERC1155);
    if (erc1155Nfts.length === 0) {
      return nftsArray;
    }
    const balancePromises = erc1155Nfts.map(fetchBalanceForNft);
    const balanceResults = await Promise.allSettled(balancePromises);
    const nftsWithBalances = [...nftsArray];
    balanceResults.forEach(result => {
      if (result.status === 'fulfilled' && result.value) {
        const {
          nft,
          balance
        } = result.value;
        const index = nftsWithBalances.findIndex(prevNft => prevNft.address === nft.address && prevNft.tokenId === nft.tokenId && prevNft.chainId === nft.chainId && prevNft.accountId === nft.accountId);
        if (index !== -1) {
          nftsWithBalances[index] = {
            ...nftsWithBalances[index],
            balance
          };
        }
      }
    });
    return nftsWithBalances;
  }, [fetchBalanceForNft]);
  (0, _react.useEffect)(() => {
    let isCancelled = false;
    const updateNfts = async () => {
      const nftsWithBalances = await fetchNftsWithBalances(transformedNfts);
      if (!isCancelled) {
        setNfts(nftsWithBalances);
      }
    };
    updateNfts();
    return () => {
      isCancelled = true;
    };
  }, [transformedNfts, fetchNftsWithBalances]);
  return nfts;
};
exports.useSendNfts = useSendNfts;
function transformNftsToAssets(nftsOwnedByAccounts, internalAccounts, chainNetworkNAmeAndImageMap) {
  const nftsArray = [];
  Object.keys(nftsOwnedByAccounts).forEach(accountAddress => {
    const account = internalAccounts === null || internalAccounts === void 0 ? void 0 : internalAccounts.find(acc => acc.address === accountAddress);
    if (account) {
      Object.keys(nftsOwnedByAccounts[accountAddress]).forEach(chainId => {
        nftsOwnedByAccounts[accountAddress][chainId].forEach(nft => {
          const chainNetworkNameAndImage = chainNetworkNAmeAndImageMap.get(chainId);
          nftsArray.push({
            ...nft,
            accountId: account.id,
            accountAddress: account.address,
            chainId,
            networkImage: chainNetworkNameAndImage === null || chainNetworkNameAndImage === void 0 ? void 0 : chainNetworkNameAndImage.networkImage,
            networkName: chainNetworkNameAndImage === null || chainNetworkNameAndImage === void 0 ? void 0 : chainNetworkNameAndImage.networkName
          });
        });
      });
    }
  });
  return nftsArray;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\send\\useSendNfts.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useSendQueryParams.ts", {"../../../../../shared/lib/delegation/utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\delegation\\utils.ts","../../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../../selectors/assets":"D:\\code\\v\\metamask-extension\\ui\\selectors\\assets.ts","../../constants/send":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\constants\\send.ts","../../context/send":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\send\\index.tsx","./useSendNfts":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useSendNfts.ts","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Csend%5CuseSendQueryParams.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSendQueryParams = void 0;
var _utils = require("@metamask/utils");
var _bridgeController = require("@metamask/bridge-controller");
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _reactRedux = require("react-redux");
var _utils2 = require("../../../../../shared/lib/delegation/utils");
var _routes = require("../../../../helpers/constants/routes");
var _assets = require("../../../../selectors/assets");
var _send = require("../../constants/send");
var _send2 = require("../../context/send");
var _useSendNfts = require("./useSendNfts");
const useSendQueryParams = () => {
  const {
    asset,
    currentPage,
    hexData,
    maxValueMode,
    to,
    updateValue,
    updateCurrentPage,
    updateAsset,
    updateHexData,
    updateTo,
    value
  } = (0, _send2.useSendContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    pathname
  } = (0, _reactRouterDomV5Compat.useLocation)();
  const [searchParams] = (0, _reactRouterDomV5Compat.useSearchParams)();
  const nfts = (0, _useSendNfts.useSendNfts)();
  const assets = (0, _reactRedux.useSelector)(_assets.getAssetsBySelectedAccountGroup);
  const flatAssets = (0, _react.useMemo)(() => Object.values(assets).flat(), [assets]);
  const subPath = (0, _react.useMemo)(() => {
    const path = pathname.split('/').filter(Boolean)[1];
    if (Object.values(_send.SendPages).includes(path)) {
      return path;
    }
    return undefined;
  }, [pathname]);
  const paramAsset = searchParams.get('asset');
  const paramAmount = searchParams.get('amount');
  const paramChainId = searchParams.get('chainId');
  const paramHexData = searchParams.get('hexData');
  const paramRecipient = searchParams.get('recipient');
  const paramMaxValueMode = searchParams.get('maxValueMode');
  (0, _react.useEffect)(() => {
    if (currentPage === subPath) {
      return;
    }
    updateCurrentPage(subPath ?? _send.SendPages.ASSET);
  }, [currentPage, subPath, updateCurrentPage]);

  // syncing with url params is done to be able to navigate back to send from
  // other pages remembering state
  (0, _react.useEffect)(() => {
    if (!subPath) {
      return;
    }
    const queryParams = new URLSearchParams(searchParams);
    if (value !== undefined && paramAmount !== value) {
      queryParams.set('amount', value);
    }
    if ((asset === null || asset === void 0 ? void 0 : asset.address) !== undefined && paramAsset !== asset.address) {
      queryParams.set('asset', asset.assetId ?? asset.address);
    }
    if ((asset === null || asset === void 0 ? void 0 : asset.chainId) !== undefined && paramChainId !== asset.chainId) {
      queryParams.set('chainId', asset.chainId.toString());
    }
    if (maxValueMode !== undefined && paramMaxValueMode !== `${maxValueMode}`) {
      queryParams.set('maxValueMode', maxValueMode.toString());
    }
    if (hexData !== undefined && paramHexData !== hexData) {
      queryParams.set('hexData', hexData.toString());
    }
    if (to !== undefined && paramRecipient !== to) {
      queryParams.set('recipient', to);
    }
    history.replace(`${_routes.SEND_ROUTE}/${subPath}?${queryParams.toString()}`);
  }, [asset, history, hexData, maxValueMode, paramAmount, paramAsset, paramChainId, paramMaxValueMode, paramRecipient, searchParams, subPath, to, value]);
  (0, _react.useEffect)(() => {
    if (to === undefined && paramRecipient) {
      updateTo(paramRecipient);
    }
  }, [to, paramRecipient, updateTo]);
  (0, _react.useEffect)(() => {
    if (hexData === undefined && paramHexData) {
      updateHexData(paramHexData);
    }
  }, [hexData, paramHexData, updateHexData]);
  (0, _react.useEffect)(() => {
    if (value === undefined && paramAmount) {
      updateValue(paramAmount, paramMaxValueMode === 'true');
    }
  }, [paramAmount, paramMaxValueMode, updateValue, value]);
  (0, _react.useEffect)(() => {
    if (asset || !paramChainId) {
      return;
    }
    const chainId = !(0, _bridgeController.isSolanaChainId)(paramChainId) && !(0, _utils.isHexString)(paramChainId) ? (0, _utils2.toHex)(paramChainId) : paramChainId;
    let newAsset = flatAssets === null || flatAssets === void 0 ? void 0 : flatAssets.find(({
      assetId,
      chainId: tokenChainId,
      isNative
    }) => chainId === tokenChainId && (paramAsset && (assetId === null || assetId === void 0 ? void 0 : assetId.toLowerCase()) === paramAsset.toLowerCase() || !paramAsset && isNative));
    if (!newAsset) {
      newAsset = nfts === null || nfts === void 0 ? void 0 : nfts.find(({
        address,
        chainId: tokenChainId,
        isNative
      }) => chainId === tokenChainId && (paramAsset && (address === null || address === void 0 ? void 0 : address.toLowerCase()) === paramAsset.toLowerCase() || !paramAsset && isNative));
    }
    if (newAsset) {
      updateAsset(newAsset);
    }
  }, [asset, flatAssets, paramAsset, paramChainId, nfts, updateAsset]);
};
exports.useSendQueryParams = useSendQueryParams;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\send\\useSendQueryParams.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useSendRecipientFilter.ts", {"react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Csend%5CuseSendRecipientFilter.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSendRecipientFilter = void 0;
var _react = require("react");
const useSendRecipientFilter = ({
  contactRecipients,
  accountRecipients,
  searchQuery = ''
}) => {
  return (0, _react.useMemo)(() => {
    const networkFilteredContactRecipients = contactRecipients;
    const networkFilteredAccountRecipients = accountRecipients;
    const filteredContactRecipients = networkFilteredContactRecipients.filter(recipient => matchesSearchQuery(recipient, searchQuery));
    const filteredAccountRecipients = networkFilteredAccountRecipients.filter(recipient => matchesSearchQuery(recipient, searchQuery));
    return {
      filteredContactRecipients,
      filteredAccountRecipients
    };
  }, [accountRecipients, contactRecipients, searchQuery]);
};
exports.useSendRecipientFilter = useSendRecipientFilter;
function matchesSearchQuery(recipient, query) {
  var _recipient$contactNam, _recipient$accountGro, _recipient$walletName, _recipient$address;
  if (!query.trim()) {
    return true;
  }
  const searchTerm = query.toLowerCase().trim();
  if ((_recipient$contactNam = recipient.contactName) !== null && _recipient$contactNam !== void 0 && _recipient$contactNam.toLowerCase().includes(searchTerm)) {
    return true;
  }
  if ((_recipient$accountGro = recipient.accountGroupName) !== null && _recipient$accountGro !== void 0 && _recipient$accountGro.toLowerCase().includes(searchTerm)) {
    return true;
  }
  if ((_recipient$walletName = recipient.walletName) !== null && _recipient$walletName !== void 0 && _recipient$walletName.toLowerCase().includes(searchTerm)) {
    return true;
  }
  if ((_recipient$address = recipient.address) !== null && _recipient$address !== void 0 && _recipient$address.toLowerCase().includes(searchTerm)) {
    return true;
  }
  return false;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\send\\useSendRecipientFilter.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useSendTokens.ts", {"../../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../selectors/assets":"D:\\code\\v\\metamask-extension\\ui\\selectors\\assets.ts","../../types/send":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\types\\send.ts","../useChainNetworkNameAndImage":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useChainNetworkNameAndImage.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Csend%5CuseSendTokens.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSendTokens = void 0;
var _reactRedux = require("react-redux");
var _react = require("react");
var _network = require("../../../../../shared/constants/network");
var _assets = require("../../../../selectors/assets");
var _send = require("../../types/send");
var _useChainNetworkNameAndImage = require("../useChainNetworkNameAndImage");
const useSendTokens = () => {
  const chainNetworkNAmeAndImageMap = (0, _useChainNetworkNameAndImage.useChainNetworkNameAndImageMap)();
  const assets = (0, _reactRedux.useSelector)(_assets.getAssetsBySelectedAccountGroup);
  const flatAssets = (0, _react.useMemo)(() => Object.values(assets).flat(), [assets]);
  const assetsWithBalance = (0, _react.useMemo)(() => {
    return flatAssets.filter(asset => {
      const haveBalance = asset.rawBalance !== '0x0';
      return haveBalance;
    });
  }, [flatAssets]);
  const processedAssets = (0, _react.useMemo)(() => {
    return assetsWithBalance.map(asset => {
      const chainNetworkNameAndImage = chainNetworkNAmeAndImageMap.get(asset.chainId);
      let imageSource;
      if (asset.isNative) {
        // Try chain-specific token image first, then fall back to network image
        imageSource = _network.CHAIN_ID_TOKEN_IMAGE_MAP[asset.chainId] ?? _network.CHAIN_ID_TO_NETWORK_IMAGE_URL_MAP[asset.chainId];
      } else {
        imageSource = asset.image;
      }
      return {
        ...asset,
        image: imageSource,
        networkImage: chainNetworkNameAndImage === null || chainNetworkNameAndImage === void 0 ? void 0 : chainNetworkNameAndImage.networkImage,
        networkName: chainNetworkNameAndImage === null || chainNetworkNameAndImage === void 0 ? void 0 : chainNetworkNameAndImage.networkName,
        shortenedBalance: asset.balance,
        standard: asset.isNative ? _send.AssetStandard.Native : _send.AssetStandard.ERC20
      };
    });
  }, [assetsWithBalance, chainNetworkNAmeAndImageMap]);
  return (0, _react.useMemo)(() => {
    return processedAssets.sort((a, b) => {
      var _b$fiat, _a$fiat;
      return (((_b$fiat = b.fiat) === null || _b$fiat === void 0 ? void 0 : _b$fiat.balance) ?? 0) - (((_a$fiat = a.fiat) === null || _a$fiat === void 0 ? void 0 : _a$fiat.balance) ?? 0);
    });
  }, [processedAssets]);
};
exports.useSendTokens = useSendTokens;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\send\\useSendTokens.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useSendType.ts", {"../../context/send":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\send\\index.tsx","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","ethers/lib/utils":"D:\\code\\v\\metamask-extension\\node_modules\\ethers\\lib\\utils.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Csend%5CuseSendType.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSendType = void 0;
var _utils = require("ethers/lib/utils");
var _bridgeController = require("@metamask/bridge-controller");
var _react = require("react");
var _send = require("../../context/send");
const useSendType = () => {
  const {
    asset,
    chainId
  } = (0, _send.useSendContext)();
  const address = (asset === null || asset === void 0 ? void 0 : asset.address) || (asset === null || asset === void 0 ? void 0 : asset.assetId);

  // isSolanaChainId is added here for evmCheck as native sol token has valid evm address in extension
  const isEvmSendType = (0, _react.useMemo)(() => address && asset !== null && asset !== void 0 && asset.chainId ? (0, _utils.isAddress)(address) && !(0, _bridgeController.isSolanaChainId)(asset === null || asset === void 0 ? void 0 : asset.chainId) : undefined, [address, asset === null || asset === void 0 ? void 0 : asset.chainId]);
  const isSolanaSendType = (0, _react.useMemo)(() => chainId ? (0, _bridgeController.isSolanaChainId)(chainId) : undefined, [chainId]);
  const isBitcoinSendType = (0, _react.useMemo)(() => chainId ? (0, _bridgeController.isBitcoinChainId)(chainId) : undefined, [chainId]);
  const assetIsNative = asset ? (asset === null || asset === void 0 ? void 0 : asset.isNative) === true : undefined;
  return (0, _react.useMemo)(() => ({
    isEvmSendType,
    isEvmNativeSendType: isEvmSendType && assetIsNative,
    isNonEvmSendType: isSolanaSendType || isBitcoinSendType,
    isNonEvmNativeSendType: isSolanaSendType && assetIsNative || isBitcoinSendType && assetIsNative,
    isSolanaSendType,
    isBitcoinSendType
  }), [isEvmSendType, isSolanaSendType, assetIsNative, isBitcoinSendType]);
};
exports.useSendType = useSendType;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\send\\useSendType.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\setConfirmationAlerts.ts", {"../../../ducks/confirm-alerts/confirm-alerts":"D:\\code\\v\\metamask-extension\\ui\\ducks\\confirm-alerts\\confirm-alerts.ts","../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","./useConfirmationAlerts":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useConfirmationAlerts.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CsetConfirmationAlerts.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _confirmAlerts = require("../../../ducks/confirm-alerts/confirm-alerts");
var _confirm = require("../context/confirm");
var _useConfirmationAlerts = _interopRequireDefault(require("./useConfirmationAlerts"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const setConfirmationAlerts = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const alerts = (0, _useConfirmationAlerts.default)();
  const ownerId = currentConfirmation === null || currentConfirmation === void 0 ? void 0 : currentConfirmation.id;
  (0, _react.useEffect)(() => {
    dispatch((0, _confirmAlerts.updateAlerts)(ownerId, alerts));
  }, [alerts, ownerId]);
  (0, _react.useEffect)(() => {
    return () => {
      dispatch((0, _confirmAlerts.clearAlerts)(ownerId));
    };
  }, []);
};
var _default = exports.default = setConfirmationAlerts;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\setConfirmationAlerts.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\syncConfirmPath.ts", {"./useConfirmationNavigation":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useConfirmationNavigation.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CsyncConfirmPath.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _useConfirmationNavigation = require("./useConfirmationNavigation");
const syncConfirmPath = currentConfirmation => {
  const {
    navigateToId
  } = (0, _useConfirmationNavigation.useConfirmationNavigation)();
  const {
    id: paramId
  } = (0, _reactRouterDom.useParams)();
  const confirmationId = currentConfirmation === null || currentConfirmation === void 0 ? void 0 : currentConfirmation.id;
  (0, _react.useEffect)(() => {
    if (!confirmationId) {
      return;
    }
    if (!paramId) {
      navigateToId(confirmationId);
    }
  }, [confirmationId, paramId, navigateToId]);
};
var _default = exports.default = syncConfirmPath;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\syncConfirmPath.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\transactions\\useEnableShieldCoverageChecks.ts", {"../../../../../shared/lib/shield":"D:\\code\\v\\metamask-extension\\shared\\lib\\shield.ts","../../../../hooks/subscription/useSubscription":"D:\\code\\v\\metamask-extension\\ui\\hooks\\subscription\\useSubscription.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Ctransactions%5CuseEnableShieldCoverageChecks.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEnableShieldCoverageChecks = void 0;
var _react = require("react");
var _useSubscription = require("../../../../hooks/subscription/useSubscription");
var _shield = require("../../../../../shared/lib/shield");
const useEnableShieldCoverageChecks = () => {
  const {
    subscriptions
  } = (0, _useSubscription.useUserSubscriptions)();
  const hasUserSubscribedToShield = (0, _react.useMemo)(() => {
    return (0, _shield.getIsShieldSubscriptionActive)(subscriptions);
  }, [subscriptions]);
  return hasUserSubscribedToShield;
};
exports.useEnableShieldCoverageChecks = useEnableShieldCoverageChecks;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\transactions\\useEnableShieldCoverageChecks.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\transactions\\useIsEnforcedSimulationsSupported.ts", {"../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Ctransactions%5CuseIsEnforcedSimulationsSupported.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsEnforcedSimulationsSupported = useIsEnforcedSimulationsSupported;
var _controllerUtils = require("@metamask/controller-utils");
var _confirm = require("../../context/confirm");
function useIsEnforcedSimulationsSupported() {
  var _simulationData$token;
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const {
    delegationAddress,
    origin,
    simulationData
  } = currentConfirmation;
  const isInternalOrigin = !origin || origin === _controllerUtils.ORIGIN_METAMASK;
  const isUpgraded = Boolean(delegationAddress);
  const hasBalanceChanges = Boolean(simulationData === null || simulationData === void 0 ? void 0 : simulationData.nativeBalanceChange) || Boolean(simulationData === null || simulationData === void 0 || (_simulationData$token = simulationData.tokenBalanceChanges) === null || _simulationData$token === void 0 ? void 0 : _simulationData$token.length);
  return false && !isInternalOrigin && isUpgraded && hasBalanceChanges;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\transactions\\useIsEnforcedSimulationsSupported.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\transactions\\useTransactionConfirm.ts", {"../../../../../shared/modules/selectors":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\index.ts","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../components/confirm/info/hooks/useGasFeeToken":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\info\\hooks\\useGasFeeToken.ts","../../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Ctransactions%5CuseTransactionConfirm.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTransactionConfirm = useTransactionConfirm;
var _transactionController = require("@metamask/transaction-controller");
var _reactRedux = require("react-redux");
var _lodash = require("lodash");
var _react = require("react");
var _selectors = require("../../../../selectors");
var _confirm = require("../../context/confirm");
var _useGasFeeToken = require("../../components/confirm/info/hooks/useGasFeeToken");
var _actions = require("../../../../store/actions");
var _selectors2 = require("../../../../../shared/modules/selectors");
function useTransactionConfirm() {
  const dispatch = (0, _reactRedux.useDispatch)();
  const customNonceValue = (0, _reactRedux.useSelector)(_selectors.getCustomNonceValue);
  const selectedGasFeeToken = (0, _useGasFeeToken.useSelectedGasFeeToken)();
  const {
    currentConfirmation: transactionMeta
  } = (0, _confirm.useConfirmContext)();
  const isSmartTransaction = (0, _reactRedux.useSelector)(state => (0, _selectors2.getIsSmartTransaction)(state, transactionMeta === null || transactionMeta === void 0 ? void 0 : transactionMeta.chainId));
  const newTransactionMeta = (0, _react.useMemo)(() => (0, _lodash.cloneDeep)(transactionMeta), [transactionMeta]);
  const handleSmartTransaction = (0, _react.useCallback)(() => {
    if (!selectedGasFeeToken) {
      return;
    }
    newTransactionMeta.batchTransactions = [{
      ...selectedGasFeeToken.transferTransaction,
      type: _transactionController.TransactionType.gasPayment
    }];
    newTransactionMeta.txParams.gas = selectedGasFeeToken.gas;
    newTransactionMeta.txParams.maxFeePerGas = selectedGasFeeToken.maxFeePerGas;
    newTransactionMeta.txParams.maxPriorityFeePerGas = selectedGasFeeToken.maxPriorityFeePerGas;
  }, [selectedGasFeeToken, newTransactionMeta]);
  const handleGasless7702 = (0, _react.useCallback)(() => {
    newTransactionMeta.isExternalSign = true;
  }, [newTransactionMeta]);
  const onTransactionConfirm = (0, _react.useCallback)(async () => {
    newTransactionMeta.customNonceValue = customNonceValue;
    if (isSmartTransaction) {
      handleSmartTransaction();
    } else if (selectedGasFeeToken) {
      handleGasless7702();
    }
    await dispatch((0, _actions.updateAndApproveTx)(newTransactionMeta, true, ''));
  }, [customNonceValue, dispatch, handleGasless7702, handleSmartTransaction, isSmartTransaction, newTransactionMeta, selectedGasFeeToken]);
  return {
    onTransactionConfirm
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\transactions\\useTransactionConfirm.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useAssetDetails.js", {"../../../../shared/modules/string-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\string-utils.ts","../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../helpers/utils/token-util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\token-util.js","../../../hooks/usePrevious":"D:\\code\\v\\metamask-extension\\ui\\hooks\\usePrevious.ts","../../../hooks/useTokenTracker":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTokenTracker.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseAssetDetails.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAssetDetails = useAssetDetails;
var _lodash = require("lodash");
var _react = require("react");
var _reactRedux = require("react-redux");
var _metamask = require("../../../ducks/metamask/metamask");
var _tokenUtil = require("../../../helpers/utils/token-util");
var _actions = require("../../../store/actions");
var _stringUtils = require("../../../../shared/modules/string-utils");
var _usePrevious = require("../../../hooks/usePrevious");
var _useTokenTracker = require("../../../hooks/useTokenTracker");
var _selectors = require("../../../selectors");
function useAssetDetails(tokenAddress, userAddress, transactionData, chainId) {
  const dispatch = (0, _reactRedux.useDispatch)();

  // state selectors
  const nfts = (0, _reactRedux.useSelector)(state => (0, _selectors.selectNftsByChainId)(state, chainId));
  const tokens = (0, _reactRedux.useSelector)(state => (0, _metamask.getTokensByChainId)(state, chainId), _lodash.isEqual);
  const currentToken = tokens.find(token => (0, _stringUtils.isEqualCaseInsensitive)(token.address, tokenAddress));

  // in-hook state
  const [currentAsset, setCurrentAsset] = (0, _react.useState)(null);
  const {
    tokensWithBalances
  } = (0, _useTokenTracker.useTokenTracker)({
    tokens: currentToken ? [currentToken] : []
  });

  // previous state checkers
  const prevTokenAddress = (0, _usePrevious.usePrevious)(tokenAddress);
  const prevUserAddress = (0, _usePrevious.usePrevious)(userAddress);
  const prevTransactionData = (0, _usePrevious.usePrevious)(transactionData);
  const prevTokenBalance = (0, _usePrevious.usePrevious)(tokensWithBalances);
  (0, _react.useEffect)(() => {
    if (!tokenAddress && !userAddress && !transactionData) {
      return;
    }
    async function getAndSetAssetDetails() {
      dispatch((0, _actions.showLoadingIndication)());
      try {
        const assetDetails = await (0, _tokenUtil.getAssetDetails)(tokenAddress, userAddress, transactionData, nfts, chainId);
        setCurrentAsset(assetDetails);
      } catch (e) {
        console.warn('Unable to set asset details', {
          error: e,
          transactionData
        });
      }
      dispatch((0, _actions.hideLoadingIndication)());
    }
    if (tokenAddress !== prevTokenAddress || userAddress !== prevUserAddress || transactionData !== prevTransactionData || prevTokenBalance && prevTokenBalance !== tokensWithBalances) {
      getAndSetAssetDetails();
    }
  }, [chainId, dispatch, prevTokenAddress, prevTransactionData, prevUserAddress, tokenAddress, userAddress, transactionData, nfts, tokensWithBalances, prevTokenBalance]);
  if (!tokenAddress && !userAddress && !transactionData) {
    return {};
  }
  if (currentAsset) {
    const {
      standard,
      symbol,
      image,
      name,
      balance,
      tokenId,
      toAddress,
      tokenAmount,
      decimals,
      tokenURI
    } = currentAsset;
    return {
      toAddress,
      tokenId,
      decimals,
      tokenAmount,
      assetAddress: tokenAddress,
      assetStandard: standard,
      tokenSymbol: symbol ?? '',
      tokenImage: image,
      userBalance: balance,
      assetName: name,
      tokenURI
    };
  }
  return {};
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useAssetDetails.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useAutomaticGasFeeTokenSelect.ts", {"../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../hooks/useAsync":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAsync.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../../store/controller-actions/transaction-controller":"D:\\code\\v\\metamask-extension\\ui\\store\\controller-actions\\transaction-controller.ts","../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","./alerts/transactions/useInsufficientBalanceAlerts":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\transactions\\useInsufficientBalanceAlerts.ts","./gas/useIsGaslessSupported":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\gas\\useIsGaslessSupported.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseAutomaticGasFeeTokenSelect.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAutomaticGasFeeTokenSelect = useAutomaticGasFeeTokenSelect;
var _react = require("react");
var _reactRedux = require("react-redux");
var _transaction = require("../../../../shared/constants/transaction");
var _useAsync = require("../../../hooks/useAsync");
var _actions = require("../../../store/actions");
var _transactionController = require("../../../store/controller-actions/transaction-controller");
var _confirm = require("../context/confirm");
var _useInsufficientBalanceAlerts = require("./alerts/transactions/useInsufficientBalanceAlerts");
var _useIsGaslessSupported = require("./gas/useIsGaslessSupported");
function useAutomaticGasFeeTokenSelect() {
  var _useInsufficientBalan, _gasFeeTokens$;
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    isSupported: isGaslessSupported,
    isSmartTransaction
  } = (0, _useIsGaslessSupported.useIsGaslessSupported)();
  const [firstCheck, setFirstCheck] = (0, _react.useState)(true);
  const {
    currentConfirmation: transactionMeta
  } = (0, _confirm.useConfirmContext)();
  const hasInsufficientBalance = Boolean((_useInsufficientBalan = (0, _useInsufficientBalanceAlerts.useInsufficientBalanceAlerts)()) === null || _useInsufficientBalan === void 0 ? void 0 : _useInsufficientBalan.length);
  const {
    gasFeeTokens,
    id: transactionId,
    selectedGasFeeToken
  } = transactionMeta;
  let firstGasFeeTokenAddress = gasFeeTokens === null || gasFeeTokens === void 0 || (_gasFeeTokens$ = gasFeeTokens[0]) === null || _gasFeeTokens$ === void 0 ? void 0 : _gasFeeTokens$.tokenAddress;
  if (!isSmartTransaction && firstGasFeeTokenAddress === _transaction.NATIVE_TOKEN_ADDRESS) {
    var _gasFeeTokens$2;
    firstGasFeeTokenAddress = gasFeeTokens === null || gasFeeTokens === void 0 || (_gasFeeTokens$2 = gasFeeTokens[1]) === null || _gasFeeTokens$2 === void 0 ? void 0 : _gasFeeTokens$2.tokenAddress;
  }
  const selectFirstToken = (0, _react.useCallback)(async () => {
    await (0, _transactionController.updateSelectedGasFeeToken)(transactionId, firstGasFeeTokenAddress);
    await (0, _actions.forceUpdateMetamaskState)(dispatch);
  }, [dispatch, transactionId, firstGasFeeTokenAddress]);
  const shouldSelect = isGaslessSupported && hasInsufficientBalance && !selectedGasFeeToken && Boolean(firstGasFeeTokenAddress);
  (0, _useAsync.useAsyncResult)(async () => {
    if (!gasFeeTokens || !transactionId || !firstCheck) {
      return;
    }
    setFirstCheck(false);
    if (shouldSelect) {
      await selectFirstToken();
    }
  }, [shouldSelect, selectFirstToken, firstCheck, gasFeeTokens, transactionId]);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useAutomaticGasFeeTokenSelect.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useBalance.js", {"../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../hooks/useAccountTotalFiatBalance":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAccountTotalFiatBalance.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseBalance.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBalance = void 0;
var _reactRedux = require("react-redux");
var _selectors = require("../../../selectors");
var _network = require("../../../../shared/constants/network");
var _useAccountTotalFiatBalance = require("../../../hooks/useAccountTotalFiatBalance");
const useBalance = fromAddress => {
  const shouldHideZeroBalanceTokens = (0, _reactRedux.useSelector)(_selectors.getShouldHideZeroBalanceTokens);
  const fromAccount = (0, _reactRedux.useSelector)(state => (0, _selectors.getInternalAccountByAddress)(state, fromAddress));
  const {
    totalWeiBalance
  } = (0, _useAccountTotalFiatBalance.useAccountTotalFiatBalance)(fromAccount, shouldHideZeroBalanceTokens);
  const currentNetwork = (0, _reactRedux.useSelector)(_selectors.getCurrentNetwork);
  const showFiatInTestnets = (0, _reactRedux.useSelector)(_selectors.getShowFiatInTestnets);
  const showFiat = _network.TEST_NETWORKS.includes(currentNetwork === null || currentNetwork === void 0 ? void 0 : currentNetwork.nickname) && !showFiatInTestnets;
  let balanceToUse = totalWeiBalance;
  const balance = (0, _reactRedux.useSelector)(_selectors.getSelectedAccountCachedBalance);
  if (!fromAddress) {
    return {};
  }
  if (showFiat) {
    balanceToUse = balance;
  }
  return {
    balance: balanceToUse
  };
};
exports.useBalance = useBalance;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useBalance.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useBatchAuthorizationRequests.ts", {"../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseBatchAuthorizationRequests.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBatchAuthorizationRequests = void 0;
var _reactRedux = require("react-redux");
var _selectors = require("../../../selectors");
var _transaction = require("../../../../shared/constants/transaction");
const useBatchAuthorizationRequests = (from, chainId) => {
  const transactions = (0, _reactRedux.useSelector)(_selectors.getTransactions);
  const pendingRequestsOfChain = transactions.filter(transaction => {
    var _transaction$txParams;
    return transaction.chainId === chainId && _transaction.IN_PROGRESS_TRANSACTION_STATUSES.includes(transaction.status) && (((_transaction$txParams = transaction.txParams.authorizationList) === null || _transaction$txParams === void 0 ? void 0 : _transaction$txParams.length) ?? 0) > 0 && transaction.txParams.from === from;
  });
  return {
    hasPendingRequests: pendingRequestsOfChain.length > 0
  };
};
exports.useBatchAuthorizationRequests = useBatchAuthorizationRequests;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useBatchAuthorizationRequests.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useChainNetworkNameAndImage.ts", {"../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseChainNetworkNameAndImage.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useChainNetworkNameAndImageMap = void 0;
var _reactRedux = require("react-redux");
var _react = require("react");
var _multichain = require("../../../selectors/multichain");
var _networks = require("../../../../shared/modules/selectors/networks");
/**
 * Returns a map of chain IDs to their network name and image.
 *
 * @returns A map of chain IDs to their network name and image.
 */
const useChainNetworkNameAndImageMap = () => {
  const allNetworkConfigurationsByCaipChainId = (0, _reactRedux.useSelector)(_networks.getAllNetworkConfigurationsByCaipChainId);
  const chainNetworkNAmeAndImageMap = (0, _react.useMemo)(() => {
    const map = new Map();
    Object.values(allNetworkConfigurationsByCaipChainId).forEach(network => {
      const chainId = network.chainId;
      const chainNetworkImage = (0, _multichain.getImageForChainId)(chainId);
      const chainNetworkName = network === null || network === void 0 ? void 0 : network.name;
      map.set(chainId, {
        networkName: chainNetworkName ?? '',
        networkImage: chainNetworkImage ?? ''
      });
    });
    return map;
  }, [allNetworkConfigurationsByCaipChainId]);
  return chainNetworkNAmeAndImageMap;
};
exports.useChainNetworkNameAndImageMap = useChainNetworkNameAndImageMap;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useChainNetworkNameAndImage.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useConfirmActions.ts", {"../../../ducks/confirm-transaction/confirm-transaction.duck":"D:\\code\\v\\metamask-extension\\ui\\ducks\\confirm-transaction\\confirm-transaction.duck.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","./useConfirmSendNavigation":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useConfirmSendNavigation.ts","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseConfirmActions.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useConfirmActions = void 0;
var _rpcErrors = require("@metamask/rpc-errors");
var _react = require("react");
var _reactRedux = require("react-redux");
var _confirmTransaction = require("../../../ducks/confirm-transaction/confirm-transaction.duck");
var _actions = require("../../../store/actions");
var _confirm = require("../context/confirm");
var _useConfirmSendNavigation = require("./useConfirmSendNavigation");
const useConfirmActions = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const {
    navigateBackIfSend
  } = (0, _useConfirmSendNavigation.useConfirmSendNavigation)();
  const {
    id: currentConfirmationId
  } = currentConfirmation || {};
  const rejectApproval = (0, _react.useCallback)(({
    location
  } = {}) => {
    if (!currentConfirmationId) {
      return;
    }
    const error = _rpcErrors.providerErrors.userRejectedRequest();
    error.data = {
      location
    };
    const serializedError = (0, _rpcErrors.serializeError)(error);
    dispatch((0, _actions.rejectPendingApproval)(currentConfirmationId, serializedError));
  }, [currentConfirmationId, dispatch]);
  const resetTransactionState = (0, _react.useCallback)(() => {
    dispatch((0, _actions.updateCustomNonce)(''));
    dispatch((0, _actions.setNextNonce)(''));
    dispatch((0, _confirmTransaction.clearConfirmTransaction)());
  }, [dispatch]);
  const onCancel = (0, _react.useCallback)(({
    location,
    navigateBackForSend = false
  }) => {
    if (!currentConfirmation) {
      return;
    }
    if (navigateBackForSend) {
      navigateBackIfSend();
    }
    rejectApproval({
      location
    });
    resetTransactionState();
  }, [currentConfirmation, navigateBackIfSend, rejectApproval, resetTransactionState]);
  return {
    onCancel,
    resetTransactionState
  };
};
exports.useConfirmActions = useConfirmActions;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useConfirmActions.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useConfirmSendNavigation.ts", {"../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","./useRedesignedSendFlow":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useRedesignedSendFlow.ts","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseConfirmSendNavigation.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useConfirmSendNavigation = void 0;
var _transactionController = require("@metamask/transaction-controller");
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _confirm = require("../context/confirm");
var _useRedesignedSendFlow = require("./useRedesignedSendFlow");
const SendTransactionTypes = [_transactionController.TransactionType.simpleSend, _transactionController.TransactionType.tokenMethodTransfer, _transactionController.TransactionType.tokenMethodTransferFrom, _transactionController.TransactionType.tokenMethodSafeTransferFrom];
const useConfirmSendNavigation = () => {
  const history = (0, _reactRouterDom.useHistory)();
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const {
    enabled: isSendRedesignEnabled
  } = (0, _useRedesignedSendFlow.useRedesignedSendFlow)();
  const navigateBackIfSend = (0, _react.useCallback)(() => {
    if (!isSendRedesignEnabled) {
      return;
    }
    const {
      origin,
      type
    } = currentConfirmation;
    if (origin === 'metamask' && type && SendTransactionTypes.includes(type)) {
      history.goBack();
    }
  }, [currentConfirmation, history, isSendRedesignEnabled]);
  return {
    navigateBackIfSend
  };
};
exports.useConfirmSendNavigation = useConfirmSendNavigation;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useConfirmSendNavigation.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useConfirmationAlertActions.ts", {"../../../components/app/confirm/info/row/constants":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\constants.ts","../../../contexts/transaction-modal":"D:\\code\\v\\metamask-extension\\ui\\contexts\\transaction-modal.js","../../../hooks/ramps/useRamps/useRamps":"D:\\code\\v\\metamask-extension\\ui\\hooks\\ramps\\useRamps\\useRamps.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseConfirmationAlertActions.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("react");
var _constants = require("../../../components/app/confirm/info/row/constants");
var _useRamps = _interopRequireDefault(require("../../../hooks/ramps/useRamps/useRamps"));
var _transactionModal = require("../../../contexts/transaction-modal");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const useConfirmationAlertActions = () => {
  const {
    openBuyCryptoInPdapp
  } = (0, _useRamps.default)();
  const {
    openModal
  } = (0, _transactionModal.useTransactionModalContext)();
  const processAction = (0, _react.useCallback)(actionKey => {
    switch (actionKey) {
      case _constants.AlertActionKey.Buy:
        openBuyCryptoInPdapp();
        break;
      case _constants.AlertActionKey.ShowAdvancedGasFeeModal:
        openModal('advancedGasFee');
        break;
      case _constants.AlertActionKey.ShowGasFeeModal:
        openModal('editGasFee');
        break;
      default:
        console.error('Unknown alert action key:', actionKey);
        break;
    }
  }, [openBuyCryptoInPdapp]);
  return processAction;
};
var _default = exports.default = useConfirmationAlertActions;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useConfirmationAlertActions.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useConfirmationAlertMetrics.ts", {"../../../hooks/useAlerts":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAlerts.ts","../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","../utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\utils\\index.ts","./alerts/constants":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\constants.ts","./useSignatureEventFragment":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useSignatureEventFragment.ts","./useTransactionEventFragment":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useTransactionEventFragment.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","uuid":"D:\\code\\v\\metamask-extension\\node_modules\\uuid\\dist\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseConfirmationAlertMetrics.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ALERTS_NAME_METRICS = void 0;
exports.useConfirmationAlertMetrics = useConfirmationAlertMetrics;
var _react = require("react");
var _uuid = require("uuid");
var _useAlerts = _interopRequireDefault(require("../../../hooks/useAlerts"));
var _utils = require("../utils");
var _confirm = require("../context/confirm");
var _constants = require("./alerts/constants");
var _useSignatureEventFragment = require("./useSignatureEventFragment");
var _useTransactionEventFragment = require("./useTransactionEventFragment");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const ALERTS_NAME_METRICS = exports.ALERTS_NAME_METRICS = {
  [_constants.AlertsName.GasEstimateFailed]: 'gas_estimate_failed',
  [_constants.AlertsName.GasFeeLow]: 'gas_fee_low',
  [_constants.AlertsName.GasTooLow]: 'gas_too_low',
  [_constants.AlertsName.InsufficientBalance]: 'insufficient_balance',
  [_constants.AlertsName.NetworkBusy]: 'network_busy',
  [_constants.AlertsName.NoGasPrice]: 'no_gas_price',
  [_constants.AlertsName.PendingTransaction]: 'pending_transaction',
  [_constants.AlertsName.SigningOrSubmitting]: 'signing_or_submitting',
  [_constants.AlertsName.Blockaid]: 'blockaid'
};

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function uniqueFreshArrayPush(array, value) {
  return [...new Set([...array, value])];
}
function getAlertNames(alerts) {
  return alerts.map(alert => getAlertName(alert.key));
}
function getAlertName(alertKey) {
  return (0, _uuid.validate)(alertKey) ? ALERTS_NAME_METRICS[_constants.AlertsName.Blockaid] : ALERTS_NAME_METRICS[alertKey] ?? alertKey;
}
function useConfirmationAlertMetrics() {
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const ownerId = (currentConfirmation === null || currentConfirmation === void 0 ? void 0 : currentConfirmation.id) ?? '';
  const {
    alerts,
    isAlertConfirmed
  } = (0, _useAlerts.default)(ownerId);
  const {
    updateSignatureEventFragment
  } = (0, _useSignatureEventFragment.useSignatureEventFragment)();
  const {
    updateTransactionEventFragment
  } = (0, _useTransactionEventFragment.useTransactionEventFragment)();
  const [metricsProperties, setMetricsProperties] = (0, _react.useState)({
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
    // eslint-disable-next-line @typescript-eslint/naming-convention
    alert_visualized: [],
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
    // eslint-disable-next-line @typescript-eslint/naming-convention
    alert_visualized_count: 0,
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
    // eslint-disable-next-line @typescript-eslint/naming-convention
    alert_key_clicked: [],
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
    // eslint-disable-next-line @typescript-eslint/naming-convention
    alert_action_clicked: []
  });
  const properties = alerts.length > 0 ? {
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
    // eslint-disable-next-line @typescript-eslint/naming-convention
    alert_triggered_count: alerts.length,
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
    // eslint-disable-next-line @typescript-eslint/naming-convention
    alert_triggered: getAlertNames(alerts),
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
    // eslint-disable-next-line @typescript-eslint/naming-convention
    alert_resolved_count: alerts.filter(alert => isAlertConfirmed(alert.key)).length,
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
    // eslint-disable-next-line @typescript-eslint/naming-convention
    alert_resolved: getAlertNames(alerts.filter(alert => isAlertConfirmed(alert.key))),
    ...metricsProperties
  } : undefined;
  const trackAlertRender = (0, _react.useCallback)(alertKey => {
    setMetricsProperties(prevState => {
      const newState = {
        ...prevState
      };
      const alertName = getAlertName(alertKey);
      newState.alert_visualized = uniqueFreshArrayPush(prevState.alert_visualized, alertName);
      newState.alert_visualized_count = newState.alert_visualized.length;
      return newState;
    });
  }, []);
  const trackInlineAlertClicked = (0, _react.useCallback)(alertKey => {
    setMetricsProperties(prevState => {
      const newState = {
        ...prevState
      };
      const alertName = getAlertName(alertKey);
      newState.alert_key_clicked = uniqueFreshArrayPush(prevState.alert_key_clicked, alertName);
      return newState;
    });
  }, []);
  const trackAlertActionClicked = (0, _react.useCallback)(alertKey => {
    setMetricsProperties(prevState => {
      const newState = {
        ...prevState
      };
      const alertName = getAlertName(alertKey);
      newState.alert_action_clicked = uniqueFreshArrayPush(prevState.alert_action_clicked, alertName);
      return newState;
    });
  }, []);
  const updateAlertMetrics = (0, _react.useCallback)(() => {
    if (!properties) {
      return;
    }
    if ((0, _utils.isSignatureTransactionType)(currentConfirmation)) {
      updateSignatureEventFragment({
        properties
      });
    } else {
      updateTransactionEventFragment({
        properties
      }, ownerId);
    }
  }, [JSON.stringify(properties), updateTransactionEventFragment, ownerId]);
  (0, _react.useEffect)(() => {
    updateAlertMetrics();
  }, [updateAlertMetrics]);
  return {
    trackAlertRender,
    trackInlineAlertClicked,
    trackAlertActionClicked
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useConfirmationAlertMetrics.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useConfirmationAlerts.ts", {"./alerts/signatures/useAccountMismatchAlerts":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\signatures\\useAccountMismatchAlerts.ts","./alerts/signatures/useDomainMismatchAlerts":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\signatures\\useDomainMismatchAlerts.ts","./alerts/transactions/useAccountTypeUpgrade":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\transactions\\useAccountTypeUpgrade.ts","./alerts/transactions/useFirstTimeInteractionAlert":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\transactions\\useFirstTimeInteractionAlert.ts","./alerts/transactions/useGasEstimateFailedAlerts":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\transactions\\useGasEstimateFailedAlerts.ts","./alerts/transactions/useGasFeeLowAlerts":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\transactions\\useGasFeeLowAlerts.ts","./alerts/transactions/useGasTooLowAlerts":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\transactions\\useGasTooLowAlerts.ts","./alerts/transactions/useInsufficientBalanceAlerts":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\transactions\\useInsufficientBalanceAlerts.ts","./alerts/transactions/useMultipleApprovalsAlerts":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\transactions\\useMultipleApprovalsAlerts.ts","./alerts/transactions/useNoGasPriceAlerts":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\transactions\\useNoGasPriceAlerts.ts","./alerts/transactions/useNonContractAddressAlerts":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\transactions\\useNonContractAddressAlerts.ts","./alerts/transactions/usePendingTransactionAlerts":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\transactions\\usePendingTransactionAlerts.ts","./alerts/transactions/useResimulationAlert":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\transactions\\useResimulationAlert.ts","./alerts/transactions/useSigningOrSubmittingAlerts":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\transactions\\useSigningOrSubmittingAlerts.ts","./alerts/useAddressTrustSignalAlerts":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\useAddressTrustSignalAlerts.ts","./alerts/useBlockaidAlerts":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\useBlockaidAlerts.ts","./alerts/useConfirmationOriginAlerts":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\useConfirmationOriginAlerts.ts","./alerts/useNetworkAndOriginSwitchingAlerts":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\useNetworkAndOriginSwitchingAlerts.ts","./alerts/useOriginTrustSignalAlerts":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\useOriginTrustSignalAlerts.ts","./alerts/useSelectedAccountAlerts":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\useSelectedAccountAlerts.ts","./alerts/useShieldCoverageAlert":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\useShieldCoverageAlert.ts","./alerts/useTokenTrustSignalAlerts":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\useTokenTrustSignalAlerts.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseConfirmationAlerts.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useConfirmationAlerts;
var _react = require("react");
var _useAccountMismatchAlerts = _interopRequireDefault(require("./alerts/signatures/useAccountMismatchAlerts"));
var _useDomainMismatchAlerts = _interopRequireDefault(require("./alerts/signatures/useDomainMismatchAlerts"));
var _useAccountTypeUpgrade = require("./alerts/transactions/useAccountTypeUpgrade");
var _useFirstTimeInteractionAlert = require("./alerts/transactions/useFirstTimeInteractionAlert");
var _useGasEstimateFailedAlerts = require("./alerts/transactions/useGasEstimateFailedAlerts");
var _useGasFeeLowAlerts = require("./alerts/transactions/useGasFeeLowAlerts");
var _useGasTooLowAlerts = require("./alerts/transactions/useGasTooLowAlerts");
var _useInsufficientBalanceAlerts = require("./alerts/transactions/useInsufficientBalanceAlerts");
var _useMultipleApprovalsAlerts = require("./alerts/transactions/useMultipleApprovalsAlerts");
var _useNoGasPriceAlerts = require("./alerts/transactions/useNoGasPriceAlerts");
var _useNonContractAddressAlerts = require("./alerts/transactions/useNonContractAddressAlerts");
var _usePendingTransactionAlerts = require("./alerts/transactions/usePendingTransactionAlerts");
var _useResimulationAlert = require("./alerts/transactions/useResimulationAlert");
var _useSigningOrSubmittingAlerts = require("./alerts/transactions/useSigningOrSubmittingAlerts");
var _useBlockaidAlerts = _interopRequireDefault(require("./alerts/useBlockaidAlerts"));
var _useConfirmationOriginAlerts = _interopRequireDefault(require("./alerts/useConfirmationOriginAlerts"));
var _useNetworkAndOriginSwitchingAlerts = require("./alerts/useNetworkAndOriginSwitchingAlerts");
var _useSelectedAccountAlerts = require("./alerts/useSelectedAccountAlerts");
var _useAddressTrustSignalAlerts = require("./alerts/useAddressTrustSignalAlerts");
var _useOriginTrustSignalAlerts = require("./alerts/useOriginTrustSignalAlerts");
var _useTokenTrustSignalAlerts = require("./alerts/useTokenTrustSignalAlerts");
var _useShieldCoverageAlert = require("./alerts/useShieldCoverageAlert");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function useSignatureAlerts() {
  const accountMismatchAlerts = (0, _useAccountMismatchAlerts.default)();
  const domainMismatchAlerts = (0, _useDomainMismatchAlerts.default)();
  return (0, _react.useMemo)(() => [...accountMismatchAlerts, ...domainMismatchAlerts], [accountMismatchAlerts, domainMismatchAlerts]);
}
function useTransactionAlerts() {
  const accountTypeUpgradeAlerts = (0, _useAccountTypeUpgrade.useAccountTypeUpgrade)();
  const firstTimeInteractionAlert = (0, _useFirstTimeInteractionAlert.useFirstTimeInteractionAlert)();
  const gasEstimateFailedAlerts = (0, _useGasEstimateFailedAlerts.useGasEstimateFailedAlerts)();
  const gasFeeLowAlerts = (0, _useGasFeeLowAlerts.useGasFeeLowAlerts)();
  const gasTooLowAlerts = (0, _useGasTooLowAlerts.useGasTooLowAlerts)();
  const insufficientBalanceAlerts = (0, _useInsufficientBalanceAlerts.useInsufficientBalanceAlerts)();
  const multipleApprovalAlerts = (0, _useMultipleApprovalsAlerts.useMultipleApprovalsAlerts)();
  const noGasPriceAlerts = (0, _useNoGasPriceAlerts.useNoGasPriceAlerts)();
  const nonContractAddressAlerts = (0, _useNonContractAddressAlerts.useNonContractAddressAlerts)();
  const pendingTransactionAlerts = (0, _usePendingTransactionAlerts.usePendingTransactionAlerts)();
  const resimulationAlert = (0, _useResimulationAlert.useResimulationAlert)();
  const shieldCoverageAlert = (0, _useShieldCoverageAlert.useShieldCoverageAlert)();
  const signingOrSubmittingAlerts = (0, _useSigningOrSubmittingAlerts.useSigningOrSubmittingAlerts)();
  const tokenTrustSignalAlerts = (0, _useTokenTrustSignalAlerts.useTokenTrustSignalAlerts)();
  return (0, _react.useMemo)(() => [...accountTypeUpgradeAlerts, ...firstTimeInteractionAlert, ...gasEstimateFailedAlerts, ...gasFeeLowAlerts, ...gasTooLowAlerts, ...insufficientBalanceAlerts, ...multipleApprovalAlerts, ...noGasPriceAlerts, ...nonContractAddressAlerts, ...pendingTransactionAlerts, ...resimulationAlert, ...shieldCoverageAlert, ...signingOrSubmittingAlerts, ...tokenTrustSignalAlerts], [accountTypeUpgradeAlerts, firstTimeInteractionAlert, gasEstimateFailedAlerts, gasFeeLowAlerts, gasTooLowAlerts, insufficientBalanceAlerts, multipleApprovalAlerts, noGasPriceAlerts, nonContractAddressAlerts, pendingTransactionAlerts, resimulationAlert, shieldCoverageAlert, signingOrSubmittingAlerts, tokenTrustSignalAlerts]);
}
function useConfirmationAlerts() {
  const blockaidAlerts = (0, _useBlockaidAlerts.default)();
  const confirmationOriginAlerts = (0, _useConfirmationOriginAlerts.default)();
  const signatureAlerts = useSignatureAlerts();
  const transactionAlerts = useTransactionAlerts();
  const selectedAccountAlerts = (0, _useSelectedAccountAlerts.useSelectedAccountAlerts)();
  const networkAndOriginSwitchingAlerts = (0, _useNetworkAndOriginSwitchingAlerts.useNetworkAndOriginSwitchingAlerts)();
  const addressTrustSignalAlerts = (0, _useAddressTrustSignalAlerts.useAddressTrustSignalAlerts)();
  const originTrustSignalAlerts = (0, _useOriginTrustSignalAlerts.useOriginTrustSignalAlerts)();
  return (0, _react.useMemo)(() => [...blockaidAlerts, ...confirmationOriginAlerts, ...signatureAlerts, ...transactionAlerts, ...selectedAccountAlerts, ...networkAndOriginSwitchingAlerts, ...addressTrustSignalAlerts, ...originTrustSignalAlerts], [blockaidAlerts, confirmationOriginAlerts, signatureAlerts, transactionAlerts, selectedAccountAlerts, networkAndOriginSwitchingAlerts, addressTrustSignalAlerts, originTrustSignalAlerts]);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useConfirmationAlerts.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useConfirmationNavigation.ts", {"../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../confirmation/templates":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\templates\\index.js","../utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\utils\\index.ts","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseConfirmationNavigation.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.navigateToConfirmation = navigateToConfirmation;
exports.useConfirmationNavigation = useConfirmationNavigation;
var _react = require("react");
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _controllerUtils = require("@metamask/controller-utils");
var _lodash = require("lodash");
var _templates = require("../confirmation/templates");
var _routes = require("../../../helpers/constants/routes");
var _utils = require("../utils");
var _selectors = require("../../../selectors");
const CONNECT_APPROVAL_TYPES = [_controllerUtils.ApprovalType.WalletRequestPermissions, 'wallet_installSnap', 'wallet_updateSnap', 'wallet_installSnapResult'];
function useConfirmationNavigation() {
  const confirmations = (0, _reactRedux.useSelector)(_selectors.selectPendingApprovalsForNavigation);
  const approvalFlows = (0, _reactRedux.useSelector)(_selectors.getApprovalFlows, _lodash.isEqual);
  const history = (0, _reactRouterDom.useHistory)();
  const {
    search: queryString
  } = (0, _reactRouterDom.useLocation)();
  const getIndex = (0, _react.useCallback)(confirmationId => {
    if (!confirmationId) {
      return 0;
    }
    return confirmations.findIndex(({
      id
    }) => id === confirmationId);
  }, [confirmations]);
  const navigateToId = (0, _react.useCallback)(confirmationId => {
    navigateToConfirmation(confirmationId, confirmations, Boolean(approvalFlows === null || approvalFlows === void 0 ? void 0 : approvalFlows.length), history, queryString);
  }, [confirmations, history, queryString]);
  const navigateToIndex = (0, _react.useCallback)(index => {
    const nextConfirmation = confirmations[index];
    navigateToId(nextConfirmation === null || nextConfirmation === void 0 ? void 0 : nextConfirmation.id);
  }, [confirmations, navigateToId]);
  const count = confirmations.length;
  return {
    confirmations,
    count,
    getIndex,
    navigateToId,
    navigateToIndex
  };
}
function navigateToConfirmation(confirmationId, confirmations, hasApprovalFlows, history, queryString = '') {
  var _nextConfirmation$req;
  const hasNoConfirmations = (confirmations === null || confirmations === void 0 ? void 0 : confirmations.length) <= 0 || !confirmationId;
  if (hasApprovalFlows && hasNoConfirmations) {
    history.replace(`${_routes.CONFIRMATION_V_NEXT_ROUTE}`);
    return;
  }
  if (hasNoConfirmations) {
    return;
  }
  const nextConfirmation = confirmations.find(confirmation => confirmation.id === confirmationId);
  if (!nextConfirmation) {
    return;
  }
  const type = nextConfirmation.type;
  if (_templates.TEMPLATED_CONFIRMATION_APPROVAL_TYPES.includes(type)) {
    history.replace(`${_routes.CONFIRMATION_V_NEXT_ROUTE}/${confirmationId}`);
    return;
  }
  if ((0, _utils.isSignatureTransactionType)(nextConfirmation)) {
    history.replace(`${_routes.CONFIRM_TRANSACTION_ROUTE}/${confirmationId}${_routes.SIGNATURE_REQUEST_PATH}`);
    return;
  }
  if (type === _controllerUtils.ApprovalType.Transaction) {
    let url = `${_routes.CONFIRM_TRANSACTION_ROUTE}/${confirmationId}`;
    if (queryString.length) {
      url = `${url}${queryString}`;
    }
    history.replace(url);
    return;
  }
  if (type === _controllerUtils.ApprovalType.EthDecrypt) {
    history.replace(`${_routes.CONFIRM_TRANSACTION_ROUTE}/${confirmationId}${_routes.DECRYPT_MESSAGE_REQUEST_PATH}`);
    return;
  }
  if (type === _controllerUtils.ApprovalType.EthGetEncryptionPublicKey) {
    history.replace(`${_routes.CONFIRM_TRANSACTION_ROUTE}/${confirmationId}${_routes.ENCRYPTION_PUBLIC_KEY_REQUEST_PATH}`);
    return;
  }
  if (CONNECT_APPROVAL_TYPES.includes(type)) {
    history.replace(`${_routes.CONNECT_ROUTE}/${confirmationId}`);
    return;
  }
  const tokenId = nextConfirmation === null || nextConfirmation === void 0 || (_nextConfirmation$req = nextConfirmation.requestData) === null || _nextConfirmation$req === void 0 || (_nextConfirmation$req = _nextConfirmation$req.asset) === null || _nextConfirmation$req === void 0 ? void 0 : _nextConfirmation$req.tokenId;
  if (type === _controllerUtils.ApprovalType.WatchAsset && !tokenId) {
    history.replace(`${_routes.CONFIRM_ADD_SUGGESTED_TOKEN_ROUTE}`);
    return;
  }
  if (type === _controllerUtils.ApprovalType.WatchAsset && tokenId) {
    history.replace(`${_routes.CONFIRM_ADD_SUGGESTED_NFT_ROUTE}`);
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useConfirmationNavigation.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useConfirmationNetworkInfo.ts", {"../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseConfirmationNetworkInfo.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactRedux = require("react-redux");
var _network = require("../../../../shared/constants/network");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _confirm = require("../context/confirm");
var _selectors = require("../../../selectors");
function useConfirmationNetworkInfo() {
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const chainId = currentConfirmation === null || currentConfirmation === void 0 ? void 0 : currentConfirmation.chainId;
  const networkConfiguration = (0, _reactRedux.useSelector)(state => (0, _selectors.selectNetworkConfigurationByChainId)(state, chainId));
  let networkDisplayName = '';
  let networkImageUrl = '';
  if (currentConfirmation) {
    networkDisplayName = (networkConfiguration === null || networkConfiguration === void 0 ? void 0 : networkConfiguration.name) ?? _network.NETWORK_TO_NAME_MAP[chainId] ?? t('privateNetwork');
    networkImageUrl = _network.CHAIN_ID_TO_NETWORK_IMAGE_URL_MAP[chainId];
  }
  return {
    networkImageUrl,
    networkDisplayName
  };
}
var _default = exports.default = useConfirmationNetworkInfo;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useConfirmationNetworkInfo.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useConfirmationRecipientInfo.ts", {"../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","../components/confirm/utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\utils.ts","../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","../selectors/accounts":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\selectors\\accounts.ts","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseConfirmationRecipientInfo.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactRedux = require("react-redux");
var _selectors = require("../../../selectors");
var _utils = require("../components/confirm/utils");
var _confirm = require("../context/confirm");
var _accounts = require("../selectors/accounts");
var _accountTree = require("../../../selectors/multichain-accounts/account-tree");
function useConfirmationRecipientInfo() {
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const isMultichainAccountsState2Enabled = (0, _reactRedux.useSelector)(_selectors.getIsMultichainAccountsState2Enabled);
  const {
    from
  } = (0, _utils.getConfirmationSender)(currentConfirmation);
  const senderAddress = from ?? '';
  const accountGroupName = (0, _reactRedux.useSelector)(state => (0, _accounts.selectAccountGroupNameByInternalAccount)(state, senderAddress));
  const internalAccountName = (0, _reactRedux.useSelector)(state => (0, _accounts.selectInternalAccountNameByAddress)(state, senderAddress));
  const walletInfo = (0, _reactRedux.useSelector)(state => (0, _accountTree.getWalletIdAndNameByAccountAddress)(state, senderAddress));
  const walletsWithAccounts = (0, _reactRedux.useSelector)(_accountTree.getWalletsWithAccounts);
  const senderName = isMultichainAccountsState2Enabled ? accountGroupName : internalAccountName;
  const hasMoreThanOneWallet = Object.keys(walletsWithAccounts).length > 1;
  return {
    hasMoreThanOneWallet,
    isBIP44: isMultichainAccountsState2Enabled,
    senderAddress,
    senderName: senderName ?? '',
    walletName: (walletInfo === null || walletInfo === void 0 ? void 0 : walletInfo.name) ?? ''
  };
}
var _default = exports.default = useConfirmationRecipientInfo;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useConfirmationRecipientInfo.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useCurrentConfirmation.ts", {"../../../../shared/lib/confirmation.utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\confirmation.utils.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/signatures":"D:\\code\\v\\metamask-extension\\ui\\selectors\\signatures.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseCurrentConfirmation.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _selectors = require("../../../selectors");
var _signatures = require("../../../selectors/signatures");
var _confirmation = require("../../../../shared/lib/confirmation.utils");
/**
 * Determine the current confirmation based on the pending approvals and controller state.
 *
 * DO NOT USE within a redesigned confirmation.
 * Instead use ConfirmContext to read the current confirmation.
 *
 * @returns The current confirmation data.
 */
const useCurrentConfirmation = () => {
  const {
    id: paramsConfirmationId
  } = (0, _reactRouterDom.useParams)();
  const oldestPendingApproval = (0, _reactRedux.useSelector)(_selectors.oldestPendingConfirmationSelector);
  const confirmationId = paramsConfirmationId ?? (oldestPendingApproval === null || oldestPendingApproval === void 0 ? void 0 : oldestPendingApproval.id);
  const pendingApproval = (0, _reactRedux.useSelector)(state => (0, _selectors.selectPendingApproval)(state, confirmationId));
  const transactionMetadata = (0, _reactRedux.useSelector)(state =>
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  (0, _selectors.getUnapprovedTransaction)(state, confirmationId));
  const signatureMessage = (0, _reactRedux.useSelector)(state => (0, _signatures.selectUnapprovedMessage)(state, confirmationId));
  const useRedesignedForSignatures = (0, _confirmation.shouldUseRedesignForSignatures)({
    approvalType: pendingApproval === null || pendingApproval === void 0 ? void 0 : pendingApproval.type
  });
  const useRedesignedForTransaction = (0, _confirmation.shouldUseRedesignForTransactions)({
    transactionMetadataType: transactionMetadata === null || transactionMetadata === void 0 ? void 0 : transactionMetadata.type
  });
  const shouldUseRedesign = useRedesignedForSignatures || useRedesignedForTransaction;
  return (0, _react.useMemo)(() => {
    if (!shouldUseRedesign) {
      return {
        currentConfirmation: undefined
      };
    }
    const currentConfirmation = transactionMetadata ?? signatureMessage ?? undefined;
    return {
      currentConfirmation
    };
  }, [transactionMetadata, signatureMessage, shouldUseRedesign]);
};
var _default = exports.default = useCurrentConfirmation;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useCurrentConfirmation.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useCurrentSignatureSecurityAlertResponse.ts", {"../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseCurrentSignatureSecurityAlertResponse.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactRedux = require("react-redux");
var _confirm = require("../context/confirm");
const useCurrentSignatureSecurityAlertResponse = () => {
  var _currentConfirmation$;
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const securityAlertId = currentConfirmation === null || currentConfirmation === void 0 || (_currentConfirmation$ = currentConfirmation.securityAlertResponse) === null || _currentConfirmation$ === void 0 ? void 0 : _currentConfirmation$.securityAlertId;
  const signatureSecurityAlertResponse = (0, _reactRedux.useSelector)(state => {
    var _state$metamask$signa;
    if (securityAlertId === undefined) {
      return undefined;
    }
    return (_state$metamask$signa = state.metamask.signatureSecurityAlertResponses) === null || _state$metamask$signa === void 0 ? void 0 : _state$metamask$signa[securityAlertId];
  });
  return signatureSecurityAlertResponse;
};
var _default = exports.default = useCurrentSignatureSecurityAlertResponse;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useCurrentSignatureSecurityAlertResponse.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useDecodedSignatureMetrics.ts", {"../components/simulation-details/useLoadingTime":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\simulation-details\\useLoadingTime.ts","../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","./useSignatureEventFragment":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useSignatureEventFragment.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseDecodedSignatureMetrics.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDecodedSignatureMetrics = useDecodedSignatureMetrics;
var _react = require("react");
var _confirm = require("../context/confirm");
var _useLoadingTime = require("../components/simulation-details/useLoadingTime");
var _useSignatureEventFragment = require("./useSignatureEventFragment");
var DecodingResponseType = /*#__PURE__*/function (DecodingResponseType) {
  DecodingResponseType["Change"] = "CHANGE";
  DecodingResponseType["NoChange"] = "NO_CHANGE";
  DecodingResponseType["InProgress"] = "decoding_in_progress";
  return DecodingResponseType;
}(DecodingResponseType || {});
function useDecodedSignatureMetrics(supportedByDecodingAPI) {
  var _decodingData$error;
  const {
    updateSignatureEventFragment
  } = (0, _useSignatureEventFragment.useSignatureEventFragment)();
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const {
    loadingTime,
    setLoadingComplete
  } = (0, _useLoadingTime.useLoadingTime)();
  const {
    decodingLoading,
    decodingData
  } = currentConfirmation;
  if (decodingLoading === false) {
    setLoadingComplete();
  }
  const decodingChangeTypes = (0, _react.useMemo)(() => ((decodingData === null || decodingData === void 0 ? void 0 : decodingData.stateChanges) ?? []).map(change => change.changeType), [decodingData]);
  const decodingResponse = (decodingData === null || decodingData === void 0 || (_decodingData$error = decodingData.error) === null || _decodingData$error === void 0 ? void 0 : _decodingData$error.type) ?? (decodingChangeTypes.length ? DecodingResponseType.Change : DecodingResponseType.NoChange);
  (0, _react.useEffect)(() => {
    var _decodingData$error2;
    if (!supportedByDecodingAPI) {
      return;
    }
    if (decodingLoading) {
      updateSignatureEventFragment({
        properties: {
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          decoding_response: DecodingResponseType.InProgress
        }
      });
      return;
    }
    updateSignatureEventFragment({
      properties: {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        decoding_change_types: decodingChangeTypes,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        decoding_description: (decodingData === null || decodingData === void 0 || (_decodingData$error2 = decodingData.error) === null || _decodingData$error2 === void 0 ? void 0 : _decodingData$error2.message) ?? null,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        decoding_latency: loadingTime ?? null,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        decoding_response: decodingResponse
      }
    });
  }, [decodingResponse, decodingLoading, decodingChangeTypes, loadingTime, updateSignatureEventFragment]);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useDecodedSignatureMetrics.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useDraftTransactionWithTxParams.js", {"../../../ducks/send":"D:\\code\\v\\metamask-extension\\ui\\ducks\\send\\index.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseDraftTransactionWithTxParams.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDraftTransactionWithTxParams = void 0;
var _reactRedux = require("react-redux");
var _send = require("../../../ducks/send");
var _selectors = require("../../../selectors");
/**
 * Returns an object that resembles the txData.txParams from the Transactions state.
 * While processing gas details for send transaction and edit transaction,
 * the gas data from draftTransaction and unapprovedTx has to be reorganized
 * to mimic the txdata.txParam from a confirmTransaction
 *
 * @returns {object} The transaction data
 */
const useDraftTransactionWithTxParams = () => {
  const draftTransaction = (0, _reactRedux.useSelector)(_send.getCurrentDraftTransaction);
  const unapprovedTxs = (0, _reactRedux.useSelector)(_selectors.getUnapprovedTransactions);
  let transactionData = {};
  if (Object.keys(draftTransaction).length !== 0) {
    var _draftTransaction$gas, _editingTransaction$t, _draftTransaction$gas2, _editingTransaction$t2, _editingTransaction$t3, _draftTransaction$gas3, _editingTransaction$t4, _editingTransaction$t5, _draftTransaction$gas4, _draftTransaction$amo;
    const editingTransaction = unapprovedTxs[draftTransaction.id];
    transactionData = {
      txParams: {
        gasPrice: (_draftTransaction$gas = draftTransaction.gas) === null || _draftTransaction$gas === void 0 ? void 0 : _draftTransaction$gas.gasPrice,
        gas: editingTransaction !== null && editingTransaction !== void 0 && editingTransaction.userEditedGasLimit ? editingTransaction === null || editingTransaction === void 0 || (_editingTransaction$t = editingTransaction.txParams) === null || _editingTransaction$t === void 0 ? void 0 : _editingTransaction$t.gas : (_draftTransaction$gas2 = draftTransaction.gas) === null || _draftTransaction$gas2 === void 0 ? void 0 : _draftTransaction$gas2.gasLimit,
        maxFeePerGas: editingTransaction !== null && editingTransaction !== void 0 && (_editingTransaction$t2 = editingTransaction.txParams) !== null && _editingTransaction$t2 !== void 0 && _editingTransaction$t2.maxFeePerGas ? editingTransaction === null || editingTransaction === void 0 || (_editingTransaction$t3 = editingTransaction.txParams) === null || _editingTransaction$t3 === void 0 ? void 0 : _editingTransaction$t3.maxFeePerGas : (_draftTransaction$gas3 = draftTransaction.gas) === null || _draftTransaction$gas3 === void 0 ? void 0 : _draftTransaction$gas3.maxFeePerGas,
        maxPriorityFeePerGas: editingTransaction !== null && editingTransaction !== void 0 && (_editingTransaction$t4 = editingTransaction.txParams) !== null && _editingTransaction$t4 !== void 0 && _editingTransaction$t4.maxPriorityFeePerGas ? editingTransaction === null || editingTransaction === void 0 || (_editingTransaction$t5 = editingTransaction.txParams) === null || _editingTransaction$t5 === void 0 ? void 0 : _editingTransaction$t5.maxPriorityFeePerGas : (_draftTransaction$gas4 = draftTransaction.gas) === null || _draftTransaction$gas4 === void 0 ? void 0 : _draftTransaction$gas4.maxPriorityFeePerGas,
        value: (_draftTransaction$amo = draftTransaction.amount) === null || _draftTransaction$amo === void 0 ? void 0 : _draftTransaction$amo.value,
        type: draftTransaction.transactionType
      },
      userFeeLevel: editingTransaction === null || editingTransaction === void 0 ? void 0 : editingTransaction.userFeeLevel
    };
  }
  return transactionData;
};
exports.useDraftTransactionWithTxParams = useDraftTransactionWithTxParams;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useDraftTransactionWithTxParams.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useEIP7702Account.ts", {"../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./useConfirmationNavigation":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useConfirmationNavigation.ts","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseEIP7702Account.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EIP_7702_REVOKE_ADDRESS = void 0;
exports.useEIP7702Account = useEIP7702Account;
var _react = require("react");
var _reactRedux = require("react-redux");
var _transactionController = require("@metamask/transaction-controller");
var _actions = require("../../../store/actions");
var _selectors = require("../../../selectors");
var _useConfirmationNavigation = require("./useConfirmationNavigation");
const EIP_7702_REVOKE_ADDRESS = exports.EIP_7702_REVOKE_ADDRESS = '0x0000000000000000000000000000000000000000';
function useEIP7702Account({
  chainId,
  onRedirect
} = {
  chainId: '0x'
}) {
  const dispatch = (0, _reactRedux.useDispatch)();
  const [transactionId, setTransactionId] = (0, _react.useState)();
  const {
    confirmations,
    navigateToId
  } = (0, _useConfirmationNavigation.useConfirmationNavigation)();
  const defaultRpcEndpoint = (0, _reactRedux.useSelector)(state => (0, _selectors.selectDefaultRpcEndpointByChainId)(state, chainId)) ?? {
    defaultRpcEndpoint: {}
  };
  const {
    networkClientId
  } = defaultRpcEndpoint;
  const isRedirectPending = confirmations.some(conf => conf.id === transactionId);
  const downgradeAccount = (0, _react.useCallback)(async address => {
    const transactionMeta = await dispatch((0, _actions.addTransactionAndRouteToConfirmationPage)({
      authorizationList: [{
        address: EIP_7702_REVOKE_ADDRESS
      }],
      from: address,
      to: address,
      type: _transactionController.TransactionEnvelopeType.setCode
    }, {
      networkClientId,
      type: _transactionController.TransactionType.revokeDelegation
    }));
    setTransactionId(transactionMeta === null || transactionMeta === void 0 ? void 0 : transactionMeta.id);
  }, [dispatch, networkClientId]);
  const upgradeAccount = (0, _react.useCallback)(async (address, upgradeContractAddress) => {
    const transactionMeta = await dispatch((0, _actions.addTransactionAndRouteToConfirmationPage)({
      authorizationList: [{
        address: upgradeContractAddress
      }],
      from: address,
      to: address,
      type: _transactionController.TransactionEnvelopeType.setCode
    }, {
      networkClientId,
      type: _transactionController.TransactionType.batch
    }));
    setTransactionId(transactionMeta === null || transactionMeta === void 0 ? void 0 : transactionMeta.id);
  }, [dispatch, networkClientId]);
  const isUpgraded = (0, _react.useCallback)(async address => {
    const code = await (0, _actions.getCode)(address, networkClientId);
    return (code === null || code === void 0 ? void 0 : code.length) > 2;
  }, [networkClientId]);
  (0, _react.useEffect)(() => {
    if (isRedirectPending) {
      navigateToId(transactionId);
      onRedirect === null || onRedirect === void 0 || onRedirect();
    }
  }, [isRedirectPending, navigateToId, transactionId, onRedirect]);
  return {
    isUpgraded,
    downgradeAccount,
    upgradeAccount
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useEIP7702Account.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useEIP7702Networks.ts", {"../../../../shared/constants/keyring":"D:\\code\\v\\metamask-extension\\shared\\constants\\keyring.ts","../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../shared/modules/network.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\network.utils.ts","../../../hooks/useAsync":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAsync.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/controller-actions/transaction-controller":"D:\\code\\v\\metamask-extension\\ui\\store\\controller-actions\\transaction-controller.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseEIP7702Networks.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEIP7702Networks = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _keyring = require("../../../../shared/constants/keyring");
var _network = require("../../../../shared/constants/network");
var _network2 = require("../../../../shared/modules/network.utils");
var _selectors = require("../../../selectors");
var _useAsync = require("../../../hooks/useAsync");
var _transactionController = require("../../../store/controller-actions/transaction-controller");
const useEIP7702Networks = address => {
  var _account$metadata;
  const account = (0, _reactRedux.useSelector)(state => (0, _selectors.getMemoizedInternalAccountByAddress)(state, address));
  const keyringType = account === null || account === void 0 || (_account$metadata = account.metadata) === null || _account$metadata === void 0 || (_account$metadata = _account$metadata.keyring) === null || _account$metadata === void 0 ? void 0 : _account$metadata.type;
  const isSupportedKeyringType = keyringType && _keyring.KEYRING_TYPES_SUPPORTING_7702.includes(keyringType);
  const [multichainNetworks] = (0, _reactRedux.useSelector)(_selectors.getMultichainNetworkConfigurationsByChainId);
  const [nonTestNetworks = {}, testNetworks = {}] = (0, _react.useMemo)(() => {
    if (!isSupportedKeyringType) {
      // We return empty objects for unsupported keyring types
      return [{}, {}];
    }
    return Object.entries(multichainNetworks).reduce(([nonTestnetsList, testnetsList], [id, network]) => {
      try {
        const chainId = network.isEvm ? (0, _network2.convertCaipToHexChainId)(id) : id;
        // This is type casted to string since chainId could be
        // Hex or CaipChainId.
        const isTest = _network.TEST_CHAINS.includes(chainId);
        (isTest ? testnetsList : nonTestnetsList)[chainId] = network;
      } catch (err) {
        // console.log(err);
      }
      return [nonTestnetsList, testnetsList];
    }, [{}, {}]);
  }, [isSupportedKeyringType, multichainNetworks]);
  const networkList = (0, _react.useMemo)(() => ({
    ...nonTestNetworks,
    ...testNetworks
  }), [nonTestNetworks, testNetworks]);
  const {
    pending,
    value
  } = (0, _useAsync.useAsyncResult)(async () => {
    if (!isSupportedKeyringType) {
      return [];
    }
    const chainIds = Object.keys(networkList);
    return await (0, _transactionController.isAtomicBatchSupported)({
      address: address,
      chainIds
    });
  }, [address, isSupportedKeyringType, networkList]);
  const network7702List = (0, _react.useMemo)(() => {
    if (!value || !isSupportedKeyringType) {
      return [];
    }
    const networksSupporting7702 = [];
    Object.values(networkList).forEach(network => {
      try {
        const chainIdHex = (0, _network2.convertCaipToHexChainId)(network.chainId);
        const atomicBatchResult = value.find(({
          chainId
        }) => chainId === chainIdHex);
        if (atomicBatchResult) {
          networksSupporting7702.push({
            ...atomicBatchResult,
            ...network,
            chainIdHex
          });
        }
      } catch (err) {
        // console.log(err);
      }
    });

    // Sort by chainIdHex to ensure consistent ordering for comparison
    networksSupporting7702.sort((a, b) => {
      const aChainIdNum = parseInt(a.chainIdHex, 16);
      const bChainIdNum = parseInt(b.chainIdHex, 16);
      return aChainIdNum - bChainIdNum;
    });
    return networksSupporting7702;
  }, [isSupportedKeyringType, networkList, value]);
  return {
    network7702List,
    networkSupporting7702Present: (network7702List === null || network7702List === void 0 ? void 0 : network7702List.length) > 0,
    pending: pending && isSupportedKeyringType
  };
};
exports.useEIP7702Networks = useEIP7702Networks;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useEIP7702Networks.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useGasEstimates.js", {"../../../../shared/constants/gas":"D:\\code\\v\\metamask-extension\\shared\\constants\\gas.ts","../../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../../../shared/modules/gas.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\gas.utils.js","../../../helpers/constants/common":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\common.ts","../../../helpers/utils/transactions.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\transactions.util.js","../../../hooks/useCurrencyDisplay":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useCurrencyDisplay.js","../../../hooks/useUserPreferencedCurrency":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useUserPreferencedCurrency.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseGasEstimates.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGasEstimates = useGasEstimates;
var _reactRedux = require("react-redux");
var _gas = require("../../../../shared/constants/gas");
var _gas2 = require("../../../../shared/modules/gas.utils");
var _common = require("../../../helpers/constants/common");
var _selectors = require("../../../selectors");
var _transactions = require("../../../helpers/utils/transactions.util");
var _useCurrencyDisplay = require("../../../hooks/useCurrencyDisplay");
var _useUserPreferencedCurrency = require("../../../hooks/useUserPreferencedCurrency");
var _conversion = require("../../../../shared/modules/conversion.utils");
/**
 * @typedef {object} GasEstimatesReturnType
 * @property {string} [estimatedMinimumNative] - the maximum amount estimated to be paid if the
 *  current network transaction volume increases. Expressed in the network's native currency.
 * @property {HexWeiString} [maximumCostInHexWei] - the maximum amount this transaction will cost.
 * @property {HexWeiString} [minimumCostInHexWei] - the minimum amount this transaction will cost.
 */

/**
 * @param options
 * @param options.editGasMode
 * @param options.gasEstimateType
 * @param options.gasFeeEstimates
 * @param options.gasLimit
 * @param options.gasPrice
 * @param options.maxFeePerGas
 * @param options.maxPriorityFeePerGas
 * @param options.minimumGasLimit
 * @param options.transaction
 * @returns {GasEstimatesReturnType} The gas estimates.
 */
function useGasEstimates({
  editGasMode,
  gasEstimateType,
  gasFeeEstimates,
  gasLimit,
  gasPrice,
  maxFeePerGas,
  maxPriorityFeePerGas,
  minimumGasLimit,
  transaction
}) {
  const supportsEIP1559 = (0, _reactRedux.useSelector)(state => (0, _selectors.checkNetworkAndAccountSupports1559)(state, transaction === null || transaction === void 0 ? void 0 : transaction.networkClientId)) && !(0, _transactions.isLegacyTransaction)(transaction === null || transaction === void 0 ? void 0 : transaction.txParams);
  const {
    currency: primaryCurrency,
    numberOfDecimals: primaryNumberOfDecimals
  } = (0, _useUserPreferencedCurrency.useUserPreferencedCurrency)(_common.PRIMARY);

  // We have two helper methods that take an object that can have either
  // gasPrice OR the EIP-1559 fields on it, plus gasLimit. This object is
  // conditionally set to the appropriate fields to compute the minimum
  // and maximum cost of a transaction given the current estimates or selected
  // gas fees.
  let gasSettings = {
    gasLimit: (0, _conversion.decimalToHex)(gasLimit),
    gasLimitNoBuffer: transaction === null || transaction === void 0 ? void 0 : transaction.gasLimitNoBuffer
  };
  if (supportsEIP1559) {
    gasSettings = {
      ...gasSettings,
      maxFeePerGas: (0, _conversion.decGWEIToHexWEI)(maxFeePerGas || gasPrice || '0'),
      maxPriorityFeePerGas: (0, _conversion.decGWEIToHexWEI)(maxPriorityFeePerGas || maxFeePerGas || gasPrice || '0'),
      baseFeePerGas: (0, _conversion.decGWEIToHexWEI)((gasFeeEstimates === null || gasFeeEstimates === void 0 ? void 0 : gasFeeEstimates.estimatedBaseFee) ?? '0')
    };
  } else {
    gasSettings = {
      ...gasSettings,
      gasPrice: gasEstimateType === _gas.GasEstimateTypes.none ? '0x0' : (0, _conversion.decGWEIToHexWEI)(gasPrice)
    };
  }

  // The maximum amount this transaction will cost
  const maximumCostInHexWei = (0, _gas2.getMaximumGasTotalInHexWei)(gasSettings);
  if (editGasMode === _gas.EditGasModes.swaps) {
    gasSettings = {
      ...gasSettings,
      gasLimit: minimumGasLimit
    };
  }

  // The minimum amount this transaction will cost
  const minimumCostInHexWei = (0, _gas2.getMinimumGasTotalInHexWei)(gasSettings);
  const [estimatedMinimumNative] = (0, _useCurrencyDisplay.useCurrencyDisplay)(minimumCostInHexWei, {
    numberOfDecimals: primaryNumberOfDecimals,
    currency: primaryCurrency
  });
  return {
    estimatedMinimumNative,
    maximumCostInHexWei,
    minimumCostInHexWei
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useGasEstimates.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useGasFeeErrors.js", {"../../../../shared/constants/gas":"D:\\code\\v\\metamask-extension\\shared\\constants\\gas.ts","../../../../shared/modules/Numeric":"D:\\code\\v\\metamask-extension\\shared\\modules\\Numeric.ts","../../../helpers/constants/gas":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\gas.js","../../../helpers/constants/transactions":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\transactions.js","../../../helpers/utils/transactions.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\transactions.util.js","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseGasFeeErrors.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGasFeeErrors = useGasFeeErrors;
var _react = require("react");
var _reactRedux = require("react-redux");
var _transactionController = require("@metamask/transaction-controller");
var _gas = require("../../../../shared/constants/gas");
var _selectors = require("../../../selectors");
var _transactions = require("../../../helpers/utils/transactions.util");
var _util = require("../../../helpers/utils/util");
var _gas2 = require("../../../helpers/constants/gas");
var _Numeric = require("../../../../shared/modules/Numeric");
var _transactions2 = require("../../../helpers/constants/transactions");
const HIGH_FEE_WARNING_MULTIPLIER = 1.5;
const validateGasLimit = (gasLimit, minimumGasLimit) => {
  const gasLimitTooLow = new _Numeric.Numeric(gasLimit, 10).lessThan(new _Numeric.Numeric(minimumGasLimit || _gas.GAS_LIMITS.SIMPLE, 16));
  if (gasLimitTooLow) {
    return _gas2.GAS_FORM_ERRORS.GAS_LIMIT_OUT_OF_BOUNDS;
  }
  return undefined;
};
const validateMaxPriorityFee = (maxPriorityFeePerGas, supportsEIP1559) => {
  if (!supportsEIP1559) {
    return undefined;
  }
  if ((0, _util.bnLessThan)(maxPriorityFeePerGas, 0)) {
    return _gas2.GAS_FORM_ERRORS.MAX_PRIORITY_FEE_BELOW_MINIMUM;
  }
  return undefined;
};
const validateMaxFee = (maxFeePerGas, maxPriorityFeeError, maxPriorityFeePerGas, supportsEIP1559) => {
  if (maxPriorityFeeError || !supportsEIP1559) {
    return undefined;
  }
  if ((0, _util.bnGreaterThan)(maxPriorityFeePerGas, maxFeePerGas)) {
    return _gas2.GAS_FORM_ERRORS.MAX_FEE_IMBALANCE;
  }
  return undefined;
};
const validateGasPrice = (isFeeMarketGasEstimate, gasPrice, supportsEIP1559, transaction) => {
  var _transaction$txParams;
  if (supportsEIP1559 && isFeeMarketGasEstimate) {
    return undefined;
  }
  if ((!supportsEIP1559 || transaction !== null && transaction !== void 0 && (_transaction$txParams = transaction.txParams) !== null && _transaction$txParams !== void 0 && _transaction$txParams.gasPrice) && (0, _util.bnLessThan)(gasPrice || 0, 0)) {
    return _gas2.GAS_FORM_ERRORS.GAS_PRICE_TOO_LOW;
  }
  return undefined;
};
const getMaxPriorityFeeWarning = (gasFeeEstimates, isFeeMarketGasEstimate, isGasEstimatesLoading, maxPriorityFeePerGas, supportsEIP1559) => {
  var _gasFeeEstimates$low;
  if (!supportsEIP1559 || !isFeeMarketGasEstimate || isGasEstimatesLoading) {
    return undefined;
  }
  if ((0, _util.bnLessThan)(maxPriorityFeePerGas, gasFeeEstimates === null || gasFeeEstimates === void 0 || (_gasFeeEstimates$low = gasFeeEstimates.low) === null || _gasFeeEstimates$low === void 0 ? void 0 : _gasFeeEstimates$low.suggestedMaxPriorityFeePerGas)) {
    return _gas2.GAS_FORM_ERRORS.MAX_PRIORITY_FEE_TOO_LOW;
  }
  if (gasFeeEstimates !== null && gasFeeEstimates !== void 0 && gasFeeEstimates.high && (0, _util.bnGreaterThan)(maxPriorityFeePerGas, gasFeeEstimates.high.suggestedMaxPriorityFeePerGas * HIGH_FEE_WARNING_MULTIPLIER)) {
    return _gas2.GAS_FORM_ERRORS.MAX_PRIORITY_FEE_HIGH_WARNING;
  }
  return undefined;
};
const getMaxFeeWarning = (gasFeeEstimates, isGasEstimatesLoading, isFeeMarketGasEstimate, maxFeeError, maxPriorityFeeError, maxFeePerGas, supportsEIP1559) => {
  var _gasFeeEstimates$low2;
  if (maxPriorityFeeError || maxFeeError || !isFeeMarketGasEstimate || !supportsEIP1559 || isGasEstimatesLoading) {
    return undefined;
  }
  if ((0, _util.bnLessThan)(maxFeePerGas, gasFeeEstimates === null || gasFeeEstimates === void 0 || (_gasFeeEstimates$low2 = gasFeeEstimates.low) === null || _gasFeeEstimates$low2 === void 0 ? void 0 : _gasFeeEstimates$low2.suggestedMaxFeePerGas)) {
    return _gas2.GAS_FORM_ERRORS.MAX_FEE_TOO_LOW;
  }
  if (gasFeeEstimates !== null && gasFeeEstimates !== void 0 && gasFeeEstimates.high && (0, _util.bnGreaterThan)(maxFeePerGas, gasFeeEstimates.high.suggestedMaxFeePerGas * HIGH_FEE_WARNING_MULTIPLIER)) {
    return _gas2.GAS_FORM_ERRORS.MAX_FEE_HIGH_WARNING;
  }
  return undefined;
};
const hasBalanceError = (minimumCostInHexWei, transaction, ethBalance) => {
  var _transaction$txParams2;
  if (minimumCostInHexWei === undefined || ethBalance === undefined) {
    return false;
  }
  const minimumTxCostInHexWei = new _Numeric.Numeric(minimumCostInHexWei, 16).add(new _Numeric.Numeric((transaction === null || transaction === void 0 || (_transaction$txParams2 = transaction.txParams) === null || _transaction$txParams2 === void 0 ? void 0 : _transaction$txParams2.value) || '0x0', 16));
  const ethBalanceInHexWei = new _Numeric.Numeric(ethBalance, 16);
  return minimumTxCostInHexWei.greaterThan(ethBalanceInHexWei);
};

/**
 * @typedef {object} GasFeeErrorsReturnType
 * @property {object} [gasErrors] - combined map of errors and warnings.
 * @property {boolean} [hasGasErrors] - true if there are errors that can block submission.
 * @property {boolean} [balanceError] - true if user balance is less than transaction value.
 * @property {boolean} [hasSimulationError] - true if simulation error exists.
 */

/**
 * @param options
 * @param options.gasEstimateType
 * @param options.gasFeeEstimates
 * @param options.isGasEstimatesLoading
 * @param options.gasLimit
 * @param options.gasPrice
 * @param options.maxPriorityFeePerGas
 * @param options.maxFeePerGas
 * @param options.minimumCostInHexWei
 * @param options.minimumGasLimit
 * @param options.transaction
 * @returns {GasFeeErrorsReturnType}
 */
function useGasFeeErrors({
  gasEstimateType,
  gasFeeEstimates,
  isGasEstimatesLoading,
  gasLimit,
  gasPrice,
  maxPriorityFeePerGas,
  maxFeePerGas,
  minimumCostInHexWei,
  minimumGasLimit,
  transaction
}) {
  const supportsEIP1559 = (0, _reactRedux.useSelector)(_selectors.checkNetworkAndAccountSupports1559) && !(0, _transactions.isLegacyTransaction)(transaction === null || transaction === void 0 ? void 0 : transaction.txParams);
  const isFeeMarketGasEstimate = gasEstimateType === _gas.GasEstimateTypes.feeMarket;

  // Get all errors
  const gasLimitError = validateGasLimit(gasLimit, minimumGasLimit);
  const maxPriorityFeeError = validateMaxPriorityFee(maxPriorityFeePerGas, supportsEIP1559);
  const maxFeeError = validateMaxFee(maxFeePerGas, maxPriorityFeeError, maxPriorityFeePerGas, supportsEIP1559);
  const gasPriceError = validateGasPrice(isFeeMarketGasEstimate, gasPrice, supportsEIP1559, transaction);

  // Get all warnings
  const maxPriorityFeeWarning = getMaxPriorityFeeWarning(gasFeeEstimates, isFeeMarketGasEstimate, isGasEstimatesLoading, maxPriorityFeePerGas, supportsEIP1559);
  const maxFeeWarning = getMaxFeeWarning(gasFeeEstimates, isGasEstimatesLoading, isFeeMarketGasEstimate, maxFeeError, maxPriorityFeeError, maxFeePerGas, supportsEIP1559);

  // Separating errors from warnings so we can know which value problems
  // are blocking or simply useful information for the users

  const gasErrors = (0, _react.useMemo)(() => {
    const errors = {};
    if (gasLimitError) {
      errors.gasLimit = gasLimitError;
    }
    if (maxPriorityFeeError) {
      errors.maxPriorityFee = maxPriorityFeeError;
    }
    if (maxFeeError) {
      errors.maxFee = maxFeeError;
    }
    if (gasPriceError) {
      errors.gasPrice = gasPriceError;
    }
    return errors;
  }, [gasLimitError, maxPriorityFeeError, maxFeeError, gasPriceError]);
  const gasWarnings = (0, _react.useMemo)(() => {
    const warnings = {};
    if (maxPriorityFeeWarning) {
      warnings.maxPriorityFee = maxPriorityFeeWarning;
    }
    if (maxFeeWarning) {
      warnings.maxFee = maxFeeWarning;
    }
    return warnings;
  }, [maxPriorityFeeWarning, maxFeeWarning]);

  // Determine if we have any errors which should block submission
  const hasGasErrors = Boolean(Object.keys(gasErrors).length);

  // Combine the warnings and errors into one object for easier use within the UI.
  // This object should have no effect on whether or not the user can submit the form
  const errorsAndWarnings = (0, _react.useMemo)(() => ({
    ...gasWarnings,
    ...gasErrors
  }), [gasErrors, gasWarnings]);
  const account = (0, _reactRedux.useSelector)(state => {
    var _transaction$txParams3;
    return (0, _selectors.getTargetAccount)(state, transaction === null || transaction === void 0 || (_transaction$txParams3 = transaction.txParams) === null || _transaction$txParams3 === void 0 ? void 0 : _transaction$txParams3.from);
  }, _reactRedux.shallowEqual);

  // Balance check is only relevant for outgoing + pending transactions
  const balanceError = account !== undefined && (transaction === null || transaction === void 0 ? void 0 : transaction.type) !== _transactionController.TransactionType.incoming && (transaction === null || transaction === void 0 ? void 0 : transaction.status) in _transactions2.PENDING_STATUS_HASH ? hasBalanceError(minimumCostInHexWei, transaction, account.balance) : false;
  return {
    gasErrors: errorsAndWarnings,
    hasGasErrors,
    balanceError,
    hasSimulationError: Boolean(transaction === null || transaction === void 0 ? void 0 : transaction.simulationFails)
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useGasFeeErrors.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useGasFeeInputs.js", {"../../../../shared/constants/common":"D:\\code\\v\\metamask-extension\\shared\\constants\\common.ts","../../../../shared/constants/gas":"D:\\code\\v\\metamask-extension\\shared\\constants\\gas.ts","../../../../shared/modules/Numeric":"D:\\code\\v\\metamask-extension\\shared\\modules\\Numeric.ts","../../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../../helpers/constants/gas":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\gas.js","../../../helpers/utils/gas":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\gas.js","../../../helpers/utils/transactions.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\transactions.util.js","../../../hooks/useGasFeeEstimates":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useGasFeeEstimates.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","./useGasEstimates":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useGasEstimates.js","./useGasFeeErrors":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useGasFeeErrors.js","./useGasPriceInput":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useGasPriceInput.js","./useMaxFeePerGasInput":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useMaxFeePerGasInput.js","./useMaxPriorityFeePerGasInput":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useMaxPriorityFeePerGasInput.js","./useTransactionFunctions":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useTransactionFunctions.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseGasFeeInputs.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGasFeeInputs = useGasFeeInputs;
var _react = require("react");
var _reactRedux = require("react-redux");
var _gas = require("../../../../shared/constants/gas");
var _gas2 = require("../../../helpers/constants/gas");
var _selectors = require("../../../selectors");
var _transactions = require("../../../helpers/utils/transactions.util");
var _useGasFeeEstimates = require("../../../hooks/useGasFeeEstimates");
var _gas3 = require("../../../helpers/utils/gas");
var _conversion = require("../../../../shared/modules/conversion.utils");
var _Numeric = require("../../../../shared/modules/Numeric");
var _common = require("../../../../shared/constants/common");
var _useGasFeeErrors = require("./useGasFeeErrors");
var _useGasPriceInput = require("./useGasPriceInput");
var _useMaxFeePerGasInput = require("./useMaxFeePerGasInput");
var _useMaxPriorityFeePerGasInput = require("./useMaxPriorityFeePerGasInput");
var _useGasEstimates = require("./useGasEstimates");
var _useTransactionFunctions = require("./useTransactionFunctions");
/**
 * In EIP_1559_V2 implementation as used by useGasfeeInputContext() the use of this hook is evolved.
 * It is no longer used to keep transient state of advance gas fee inputs.
 * Transient state of inputs is maintained locally in /ui/components/app/advance-gas-fee-popover component.
 *
 * This hook is used now as source of shared data about transaction, it shares details of gas fee in transaction,
 * estimate used, is EIP-1559 supported and other details. It also  have methods to update transaction.
 *
 * Transaction is used as single source of truth and as transaction is updated the fields shared by hook are
 * also updated using useEffect hook.
 *
 * It will be useful to plan a task to create a new hook of this shared information from this hook.
 * Methods like setEstimateToUse, onManualChange are deprecated in context of EIP_1559_V2 implementation.
 */

/**
 * @typedef {object} GasFeeInputReturnType
 * @property {object} [transaction] - .
 * @property {DecGweiString} [maxFeePerGas] - the maxFeePerGas input value.
 * @property {DecGweiString} [maxPriorityFeePerGas] - the maxPriorityFeePerGas
 *  input value.
 * @property {DecGweiString} [gasPrice] - the gasPrice input value.
 * @property {(DecGweiString) => void} setGasPrice - state setter method to
 *  update the gasPrice.
 * @property {DecGweiString} gasLimit - the gasLimit input value.
 * @property {(DecGweiString) => void} setGasLimit - state setter method to
 *  update the gasLimit.
 * @property {DecGweiString} [properGasLimit] - proper gas limit.
 * @property {string} [editGasMode] - one of CANCEL, SPEED-UP, MODIFY_IN_PLACE, SWAPS.
 * @property {EstimateLevel} [estimateToUse] - the estimate level currently
 *  selected. This will be null if the user has ejected from using the estimates.
 * @property {boolean} [isGasEstimatesLoading] - true if gas estimate is loading.
 * @property {DecGweiString} [maximumCostInHexWei] - maximum cost of transaction in HexWei.
 * @property {DecGweiString} [minimumCostInHexWei] - minimum cost of transaction in HexWei.
 * @property {string} [estimateUsed] - estimate used in the transaction.
 * @property {boolean} [isNetworkBusy] - true if network is busy.
 * @property {() => void} [onManualChange] - function to call when transaction is manually changed.
 * @property {boolean} [balanceError] - true if user balance is less than transaction value.
 * @property {object} [gasErrors] - object of gas errors.
 * @property {boolean} [hasGasErrors] - true if there are gas errors.
 * @property {boolean} [hasSimulationError] - true if simulation error exists.
 * @property {number} [minimumGasLimitDec] - minimum gas limit in decimals.
 * @property {boolean} [supportsEIP1559] - true if EIP1559 is cupported.
 * @property {() => void} cancelTransaction - cancel the transaction.
 * @property {() => void} speedUpTransaction - speed up the transaction.
 * @property {(string, number, number, number, string) => void} updateTransaction - update the transaction.
 * @property {(boolean) => void} updateTransactionToTenPercentIncreasedGasFee - update the cancel / speed transaction to
 * gas fee which is equal to current gas fee +10 percent.
 * @property {(string) => void} updateTransactionUsingDAPPSuggestedValues - update the transaction to DAPP suggested gas value.
 * @property {(string) => void} updateTransactionUsingEstimate - update the transaction using the estimate passed.
 */

/**
 * Uses gasFeeEstimates and state to keep track of user gas fee inputs.
 * Will update the gas fee state when estimates update if the user has not yet
 * modified the fields.
 *
 * @param {GasRecommendations} [defaultEstimateToUse] - which estimate
 *  level to default the 'estimateToUse' state variable to.
 * @param {object} [_transaction]
 * @param {string} [minimumGasLimit]
 * @param {EditGasModes[keyof EditGasModes]} editGasMode
 * @returns {GasFeeInputReturnType & __import__(
 *  '../../../hooks/useGasFeeEstimates'
 * ).GasEstimates} gas fee input state and the GasFeeEstimates object
 */

const GAS_LIMIT_TOO_HIGH_IN_ETH = '1';
function useGasFeeInputs(defaultEstimateToUse = _gas.GasRecommendations.medium, _transaction, minimumGasLimit = '0x5208', editGasMode = _gas.EditGasModes.modifyInPlace) {
  var _network$rpcEndpoints;
  const initialRetryTxMeta = {
    txParams: _transaction === null || _transaction === void 0 ? void 0 : _transaction.txParams,
    id: _transaction === null || _transaction === void 0 ? void 0 : _transaction.id,
    userFeeLevel: _transaction === null || _transaction === void 0 ? void 0 : _transaction.userFeeLevel,
    originalGasEstimate: _transaction === null || _transaction === void 0 ? void 0 : _transaction.originalGasEstimate,
    userEditedGasLimit: _transaction === null || _transaction === void 0 ? void 0 : _transaction.userEditedGasLimit
  };
  if (_transaction !== null && _transaction !== void 0 && _transaction.previousGas) {
    initialRetryTxMeta.previousGas = _transaction === null || _transaction === void 0 ? void 0 : _transaction.previousGas;
  }
  const [retryTxMeta, setRetryTxMeta] = (0, _react.useState)(initialRetryTxMeta);
  const transaction = (0, _gas3.editGasModeIsSpeedUpOrCancel)(editGasMode) ? retryTxMeta : _transaction;
  const network = (0, _reactRedux.useSelector)(state => (0, _selectors.selectNetworkConfigurationByChainId)(state, transaction === null || transaction === void 0 ? void 0 : transaction.chainId));
  const networkClientId = network === null || network === void 0 || (_network$rpcEndpoints = network.rpcEndpoints) === null || _network$rpcEndpoints === void 0 || (_network$rpcEndpoints = _network$rpcEndpoints[network === null || network === void 0 ? void 0 : network.defaultRpcEndpointIndex]) === null || _network$rpcEndpoints === void 0 ? void 0 : _network$rpcEndpoints.networkClientId;
  const supportsEIP1559 = (0, _reactRedux.useSelector)(_selectors.checkNetworkAndAccountSupports1559) && !(0, _transactions.isLegacyTransaction)(transaction === null || transaction === void 0 ? void 0 : transaction.txParams);

  // We need the gas estimates from the GasFeeController in the background.
  // Calling this hooks initiates polling for new gas estimates and returns the
  // current estimate.
  const {
    gasEstimateType,
    gasFeeEstimates,
    isGasEstimatesLoading,
    isNetworkBusy
  } = (0, _useGasFeeEstimates.useGasFeeEstimates)(networkClientId);
  const userPrefersAdvancedGas = (0, _reactRedux.useSelector)(_selectors.getAdvancedInlineGasShown);
  const [estimateToUse, setInternalEstimateToUse] = (0, _react.useState)(() => {
    var _transaction$txParams, _transaction$txParams2;
    if (userPrefersAdvancedGas && transaction !== null && transaction !== void 0 && (_transaction$txParams = transaction.txParams) !== null && _transaction$txParams !== void 0 && _transaction$txParams.maxPriorityFeePerGas && transaction !== null && transaction !== void 0 && (_transaction$txParams2 = transaction.txParams) !== null && _transaction$txParams2 !== void 0 && _transaction$txParams2.maxFeePerGas) {
      return null;
    }
    if (transaction) {
      return (transaction === null || transaction === void 0 ? void 0 : transaction.userFeeLevel) || null;
    }
    return defaultEstimateToUse;
  });
  const [estimateUsed, setEstimateUsed] = (0, _react.useState)(() => {
    if (estimateToUse) {
      return estimateToUse;
    }
    return _gas.PriorityLevels.custom;
  });
  const [gasLimit, setGasLimit] = (0, _react.useState)(() => {
    var _transaction$txParams3, _transaction$txParams4;
    return Number((0, _conversion.hexToDecimal)((transaction === null || transaction === void 0 || (_transaction$txParams3 = transaction.txParams) === null || _transaction$txParams3 === void 0 ? void 0 : _transaction$txParams3.gasLimit) ?? (transaction === null || transaction === void 0 || (_transaction$txParams4 = transaction.txParams) === null || _transaction$txParams4 === void 0 ? void 0 : _transaction$txParams4.gas) ?? '0x0'));
  });
  const properGasLimit = Number((0, _conversion.hexToDecimal)(transaction === null || transaction === void 0 ? void 0 : transaction.originalGasEstimate));

  /**
   * In EIP-1559 V2 designs change to gas estimate is always updated to transaction
   * Thus callback setEstimateToUse can be deprecate in favor of this useEffect
   * so that transaction is source of truth whenever possible.
   */
  (0, _react.useEffect)(() => {
    if (supportsEIP1559) {
      var _transaction$txParams5, _transaction$txParams6, _transaction$txParams7, _transaction$txParams8;
      if (transaction !== null && transaction !== void 0 && transaction.userFeeLevel) {
        setInternalEstimateToUse(transaction === null || transaction === void 0 ? void 0 : transaction.userFeeLevel);
      }
      const maximumGas = new _Numeric.Numeric((transaction === null || transaction === void 0 || (_transaction$txParams5 = transaction.txParams) === null || _transaction$txParams5 === void 0 ? void 0 : _transaction$txParams5.gas) ?? '0x0', 16).times(new _Numeric.Numeric((transaction === null || transaction === void 0 || (_transaction$txParams6 = transaction.txParams) === null || _transaction$txParams6 === void 0 ? void 0 : _transaction$txParams6.maxFeePerGas) ?? '0x0', 16)).toPrefixedHexString();
      const fee = new _Numeric.Numeric(maximumGas, 16, _common.EtherDenomination.WEI).toDenomination(_common.EtherDenomination.ETH).toBase(10).toString();
      if (Number(fee) > Number(GAS_LIMIT_TOO_HIGH_IN_ETH)) {
        setEstimateUsed(_gas.PriorityLevels.dappSuggestedHigh);
      } else if (transaction !== null && transaction !== void 0 && transaction.userFeeLevel) {
        setEstimateUsed(transaction === null || transaction === void 0 ? void 0 : transaction.userFeeLevel);
      }
      setGasLimit(Number((0, _conversion.hexToDecimal)((transaction === null || transaction === void 0 || (_transaction$txParams7 = transaction.txParams) === null || _transaction$txParams7 === void 0 ? void 0 : _transaction$txParams7.gasLimit) ?? (transaction === null || transaction === void 0 || (_transaction$txParams8 = transaction.txParams) === null || _transaction$txParams8 === void 0 ? void 0 : _transaction$txParams8.gas) ?? '0x0')));
    }
  }, [setEstimateUsed, setGasLimit, setInternalEstimateToUse, supportsEIP1559, transaction]);
  const {
    gasPrice,
    setGasPrice,
    setGasPriceHasBeenManuallySet
  } = (0, _useGasPriceInput.useGasPriceInput)({
    estimateToUse,
    gasEstimateType,
    gasFeeEstimates,
    transaction
  });
  const {
    maxFeePerGas,
    setMaxFeePerGas
  } = (0, _useMaxFeePerGasInput.useMaxFeePerGasInput)({
    estimateToUse,
    gasEstimateType,
    gasFeeEstimates,
    transaction
  });
  const {
    maxPriorityFeePerGas,
    setMaxPriorityFeePerGas
  } = (0, _useMaxPriorityFeePerGasInput.useMaxPriorityFeePerGasInput)({
    estimateToUse,
    gasEstimateType,
    gasFeeEstimates,
    transaction
  });
  const {
    estimatedMinimumNative,
    maximumCostInHexWei,
    minimumCostInHexWei
  } = (0, _useGasEstimates.useGasEstimates)({
    editGasMode,
    gasEstimateType,
    gasFeeEstimates,
    gasLimit,
    gasPrice,
    maxFeePerGas,
    maxPriorityFeePerGas,
    minimumGasLimit,
    transaction
  });
  const {
    balanceError,
    gasErrors,
    hasGasErrors,
    hasSimulationError
  } = (0, _useGasFeeErrors.useGasFeeErrors)({
    gasEstimateType,
    gasFeeEstimates,
    isGasEstimatesLoading,
    gasLimit,
    gasPrice,
    maxPriorityFeePerGas,
    maxFeePerGas,
    minimumCostInHexWei,
    minimumGasLimit,
    transaction
  });
  const handleGasLimitOutOfBoundError = (0, _react.useCallback)(() => {
    if (gasErrors.gasLimit === _gas2.GAS_FORM_ERRORS.GAS_LIMIT_OUT_OF_BOUNDS) {
      var _transaction$txParams9;
      const transactionGasLimitDec = (0, _conversion.hexToDecimal)(transaction === null || transaction === void 0 || (_transaction$txParams9 = transaction.txParams) === null || _transaction$txParams9 === void 0 ? void 0 : _transaction$txParams9.gas);
      const minimumGasLimitDec = (0, _conversion.hexToDecimal)(minimumGasLimit);
      setGasLimit(transactionGasLimitDec > minimumGasLimitDec ? transactionGasLimitDec : minimumGasLimitDec);
    }
  }, [minimumGasLimit, gasErrors.gasLimit, transaction]);
  const {
    cancelTransaction,
    speedUpTransaction,
    updateTransaction,
    updateTransactionToTenPercentIncreasedGasFee,
    updateTransactionUsingDAPPSuggestedValues,
    updateTransactionUsingEstimate
  } = (0, _useTransactionFunctions.useTransactionFunctions)({
    defaultEstimateToUse,
    editGasMode,
    gasFeeEstimates,
    gasLimit,
    maxPriorityFeePerGas,
    minimumGasLimit,
    transaction,
    setRetryTxMeta
  });
  const onManualChange = (0, _react.useCallback)(() => {
    setInternalEstimateToUse(_gas.CUSTOM_GAS_ESTIMATE);
    handleGasLimitOutOfBoundError();
    // Restore existing values
    setGasPrice(gasPrice);
    setGasLimit(gasLimit);
    setMaxFeePerGas(maxFeePerGas);
    setMaxPriorityFeePerGas(maxPriorityFeePerGas);
    setGasPriceHasBeenManuallySet(true);
    setEstimateUsed('custom');
  }, [setInternalEstimateToUse, handleGasLimitOutOfBoundError, setGasPrice, gasPrice, setGasLimit, gasLimit, setMaxFeePerGas, maxFeePerGas, setMaxPriorityFeePerGas, maxPriorityFeePerGas, setGasPriceHasBeenManuallySet]);
  return {
    transaction,
    maxFeePerGas,
    maxPriorityFeePerGas,
    gasPrice,
    setGasPrice,
    gasLimit,
    setGasLimit,
    properGasLimit,
    editGasMode,
    estimateToUse,
    estimatedMinimumNative,
    maximumCostInHexWei,
    minimumCostInHexWei,
    estimateUsed,
    gasFeeEstimates,
    isNetworkBusy,
    onManualChange,
    // error and warnings
    balanceError,
    gasErrors,
    hasGasErrors,
    hasSimulationError,
    minimumGasLimitDec: (0, _conversion.hexToDecimal)(minimumGasLimit),
    supportsEIP1559,
    cancelTransaction,
    speedUpTransaction,
    updateTransaction,
    updateTransactionToTenPercentIncreasedGasFee,
    updateTransactionUsingDAPPSuggestedValues,
    updateTransactionUsingEstimate
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useGasFeeInputs.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useGasPriceInput.js", {"../../../../shared/constants/gas":"D:\\code\\v\\metamask-extension\\shared\\constants\\gas.ts","../../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../../helpers/utils/transactions.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\transactions.util.js","./utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\utils.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseGasPriceInput.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGasPriceInput = useGasPriceInput;
var _react = require("react");
var _lodash = require("lodash");
var _gas = require("../../../../shared/constants/gas");
var _transactions = require("../../../helpers/utils/transactions.util");
var _conversion = require("../../../../shared/modules/conversion.utils");
var _utils = require("./utils");
function getGasPriceEstimate(gasFeeEstimates, gasEstimateType, estimateToUse) {
  if (gasEstimateType === _gas.GasEstimateTypes.legacy) {
    return (gasFeeEstimates === null || gasFeeEstimates === void 0 ? void 0 : gasFeeEstimates[estimateToUse]) ?? '0';
  } else if (gasEstimateType === _gas.GasEstimateTypes.ethGasPrice) {
    return (gasFeeEstimates === null || gasFeeEstimates === void 0 ? void 0 : gasFeeEstimates.gasPrice) ?? '0';
  }
  return '0';
}

/**
 * @typedef {object} GasPriceInputsReturnType
 * @property {DecGweiString} [gasPrice] - the gasPrice input value.
 * @property {(DecGweiString) => void} setGasPrice - state setter method to update the gasPrice.
 * @property {(boolean) => true} setGasPriceHasBeenManuallySet - state setter method to update gasPriceHasBeenManuallySet
 * field gasPriceHasBeenManuallySet is used in gasPrice calculations.
 */

/**
 * @param options
 * @param options.estimateToUse
 * @param options.gasEstimateType
 * @param options.gasFeeEstimates
 * @param options.transaction
 * @returns {GasPriceInputsReturnType}
 */
function useGasPriceInput({
  estimateToUse,
  gasEstimateType,
  gasFeeEstimates,
  transaction
}) {
  const [gasPriceHasBeenManuallySet, setGasPriceHasBeenManuallySet] = (0, _react.useState)((transaction === null || transaction === void 0 ? void 0 : transaction.userFeeLevel) === _gas.CUSTOM_GAS_ESTIMATE);
  const [gasPrice, setGasPrice] = (0, _react.useState)(() => {
    const {
      gasPrice: txGasPrice
    } = (transaction === null || transaction === void 0 ? void 0 : transaction.txParams) || {};
    return txGasPrice && (0, _utils.feeParamsAreCustom)(transaction) ? Number((0, _conversion.hexWEIToDecGWEI)(txGasPrice)) : null;
  });
  const [initialGasPriceEstimates] = (0, _react.useState)(gasFeeEstimates);
  const gasPriceEstimatesHaveNotChanged = (0, _lodash.isEqual)(initialGasPriceEstimates, gasFeeEstimates);
  const gasPriceToUse = gasPrice !== null && (gasPriceHasBeenManuallySet || gasPriceEstimatesHaveNotChanged || (0, _transactions.isLegacyTransaction)(transaction === null || transaction === void 0 ? void 0 : transaction.txParams)) ? gasPrice : getGasPriceEstimate(gasFeeEstimates, gasEstimateType, estimateToUse);
  return {
    gasPrice: gasPriceToUse,
    setGasPrice,
    setGasPriceHasBeenManuallySet
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useGasPriceInput.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useGetTokenStandardAndDetails.ts", {"../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../hooks/useAsync":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAsync.ts","../utils/token":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\utils\\token.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseGetTokenStandardAndDetails.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetTokenStandardAndDetails = void 0;
var _transaction = require("../../../../shared/constants/transaction");
var _useAsync = require("../../../hooks/useAsync");
var _token = require("../utils/token");
/**
 * Returns token details for a given token contract
 *
 * @param tokenAddress
 * @returns
 */
const useGetTokenStandardAndDetails = tokenAddress => {
  const {
    value: details
  } = (0, _useAsync.useAsyncResult)(async () => {
    if (!tokenAddress) {
      return Promise.resolve(null);
    }
    return await (0, _token.memoizedGetTokenStandardAndDetails)(tokenAddress);
  }, [tokenAddress]);
  if (!details) {
    return {
      decimalsNumber: undefined
    };
  }
  const {
    decimals,
    standard
  } = details || {};
  if (standard === _transaction.TokenStandard.ERC20) {
    const parsedDecimals = (0, _token.parseTokenDetailDecimals)(decimals) ?? _token.ERC20_DEFAULT_DECIMALS;
    details.decimalsNumber = parsedDecimals;
  }
  return details;
};
exports.useGetTokenStandardAndDetails = useGetTokenStandardAndDetails;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useGetTokenStandardAndDetails.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useIncrementedGasFees.js", {"../../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../../../shared/modules/transaction.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\transaction.utils.ts","../../../helpers/utils/gas":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\gas.js","../../../hooks/useGasFeeEstimates":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useGasFeeEstimates.js","bignumber.js":"D:\\code\\v\\metamask-extension\\node_modules\\bignumber.js\\bignumber.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseIncrementedGasFees.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIncrementedGasFees = useIncrementedGasFees;
var _bignumber = _interopRequireDefault(require("bignumber.js"));
var _react = require("react");
var _conversion = require("../../../../shared/modules/conversion.utils");
var _transaction = require("../../../../shared/modules/transaction.utils");
var _gas = require("../../../helpers/utils/gas");
var _useGasFeeEstimates = require("../../../hooks/useGasFeeEstimates");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * Helper that returns the higher of two options for a new gas fee:
 * The original fee + 10% or
 * the current medium suggested fee from our gas estimation api
 *
 * @param {string} originalFee - hexWei vale of the original fee (maxFee or maxPriority)
 * @param {string} currentEstimate - decGwei value of the current medium gasFee estimate (maxFee or maxPriorityfee)
 * @returns {string} hexWei value of the higher of the two inputs.
 */
function getHighestIncrementedFee(originalFee, currentEstimate) {
  const buffedOriginalHexWei = (0, _gas.addTenPercentAndRound)(originalFee);
  const currentEstimateHexWei = (0, _conversion.decGWEIToHexWEI)(currentEstimate);
  return new _bignumber.default(buffedOriginalHexWei, 16).greaterThan(new _bignumber.default(currentEstimateHexWei, 16)) ? buffedOriginalHexWei : currentEstimateHexWei;
}

/**
 * When initializing cancellations or speed ups we need to set the baseline
 * gas fees to be 10% higher, which is the bare minimum that the network will
 * accept for transactions of the same nonce. Anything lower than this will be
 * discarded by the network to avoid DoS attacks. This hook returns an object
 * that either has gasPrice or maxFeePerGas/maxPriorityFeePerGas specified. In
 * addition the gasLimit will also be included.
 *
 * @param {} transaction
 * @returns {__import__(
 *   '../../app/scripts/controllers/transactions'
 * ).CustomGasSettings} Gas settings for cancellations/speed ups
 */
function useIncrementedGasFees(transaction) {
  const {
    gasFeeEstimates = {}
  } = (0, _useGasFeeEstimates.useGasFeeEstimates)(transaction.networkClientId);

  // We memoize this value so that it can be relied upon in other hooks.
  const customGasSettings = (0, _react.useMemo)(() => {
    var _transaction$txParams, _transaction$txParams2, _gasFeeEstimates$medi, _gasFeeEstimates$medi2;
    // This hook is called indiscriminantly on all transactions appearing in
    // the activity list. This includes transitional items such as signature
    // requests. These types of "transactions" are not really transactions and
    // do not have txParams. This is why we use optional chaining on the
    // txParams object in this hook.
    const temporaryGasSettings = {
      gasLimit: (_transaction$txParams = transaction.txParams) === null || _transaction$txParams === void 0 ? void 0 : _transaction$txParams.gas,
      gas: (_transaction$txParams2 = transaction.txParams) === null || _transaction$txParams2 === void 0 ? void 0 : _transaction$txParams2.gas
    };
    const suggestedMaxFeePerGas = (gasFeeEstimates === null || gasFeeEstimates === void 0 || (_gasFeeEstimates$medi = gasFeeEstimates.medium) === null || _gasFeeEstimates$medi === void 0 ? void 0 : _gasFeeEstimates$medi.suggestedMaxFeePerGas) ?? '0';
    const suggestedMaxPriorityFeePerGas = (gasFeeEstimates === null || gasFeeEstimates === void 0 || (_gasFeeEstimates$medi2 = gasFeeEstimates.medium) === null || _gasFeeEstimates$medi2 === void 0 ? void 0 : _gasFeeEstimates$medi2.suggestedMaxPriorityFeePerGas) ?? '0';
    if ((0, _transaction.isEIP1559Transaction)(transaction)) {
      var _transaction$txParams3, _transaction$txParams4;
      const transactionMaxFeePerGas = (_transaction$txParams3 = transaction.txParams) === null || _transaction$txParams3 === void 0 ? void 0 : _transaction$txParams3.maxFeePerGas;
      const transactionMaxPriorityFeePerGas = (_transaction$txParams4 = transaction.txParams) === null || _transaction$txParams4 === void 0 ? void 0 : _transaction$txParams4.maxPriorityFeePerGas;
      temporaryGasSettings.maxFeePerGas = transactionMaxFeePerGas === undefined || transactionMaxFeePerGas.startsWith('-') ? '0x0' : getHighestIncrementedFee(transactionMaxFeePerGas, suggestedMaxFeePerGas);
      temporaryGasSettings.maxPriorityFeePerGas = transactionMaxPriorityFeePerGas === undefined || transactionMaxPriorityFeePerGas.startsWith('-') ? '0x0' : getHighestIncrementedFee(transactionMaxPriorityFeePerGas, suggestedMaxPriorityFeePerGas);
    } else {
      var _transaction$txParams5;
      const transactionGasPrice = (_transaction$txParams5 = transaction.txParams) === null || _transaction$txParams5 === void 0 ? void 0 : _transaction$txParams5.gasPrice;
      temporaryGasSettings.gasPrice = transactionGasPrice === undefined || transactionGasPrice.startsWith('-') ? '0x0' : getHighestIncrementedFee(transactionGasPrice, suggestedMaxFeePerGas);
    }
    return temporaryGasSettings;
  }, [transaction, gasFeeEstimates]);
  return customGasSettings;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useIncrementedGasFees.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useIsBIP44.ts", {"../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseIsBIP44.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsBIP44 = void 0;
var _reactRedux = require("react-redux");
var _selectors = require("../../../selectors");
const useIsBIP44 = () => {
  return (0, _reactRedux.useSelector)(_selectors.getIsMultichainAccountsState2Enabled);
};
exports.useIsBIP44 = useIsBIP44;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useIsBIP44.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useIsInsufficientBalance.ts", {"./alerts/transactions/useInsufficientBalanceAlerts":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\alerts\\transactions\\useInsufficientBalanceAlerts.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseIsInsufficientBalance.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsInsufficientBalance = useIsInsufficientBalance;
var _useInsufficientBalanceAlerts = require("./alerts/transactions/useInsufficientBalanceAlerts");
function useIsInsufficientBalance() {
  return Boolean((0, _useInsufficientBalanceAlerts.useInsufficientBalanceAlerts)({
    ignoreGasFeeToken: true
  }).length);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useIsInsufficientBalance.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useLedgerConnection.ts", {"../../../../shared/constants/hardware-wallets":"D:\\code\\v\\metamask-extension\\shared\\constants\\hardware-wallets.ts","../../../ducks/app/app":"D:\\code\\v\\metamask-extension\\ui\\ducks\\app\\app.ts","../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseLedgerConnection.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _hardwareWallets = require("../../../../shared/constants/hardware-wallets");
var _app = require("../../../ducks/app/app");
var _metamask = require("../../../ducks/metamask/metamask");
var _actions = require("../../../store/actions");
var _confirm = require("../context/confirm");
const useLedgerConnection = () => {
  var _currentConfirmation$, _currentConfirmation$2;
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const ledgerTransportType = (0, _reactRedux.useSelector)(_metamask.getLedgerTransportType);
  const transportStatus = (0, _reactRedux.useSelector)(_app.getLedgerTransportStatus);
  const webHidConnectedStatus = (0, _reactRedux.useSelector)(_app.getLedgerWebHidConnectedStatus);
  const from = (currentConfirmation === null || currentConfirmation === void 0 || (_currentConfirmation$ = currentConfirmation.msgParams) === null || _currentConfirmation$ === void 0 ? void 0 : _currentConfirmation$.from) ?? (currentConfirmation === null || currentConfirmation === void 0 || (_currentConfirmation$2 = currentConfirmation.txParams) === null || _currentConfirmation$2 === void 0 ? void 0 : _currentConfirmation$2.from);
  const isLedgerWallet = (0, _reactRedux.useSelector)(state => from && (0, _metamask.isAddressLedger)(state, from));
  (0, _react.useEffect)(() => {
    if (!isLedgerWallet) {
      return;
    }
    const initialConnectedDeviceCheck = async () => {
      if (ledgerTransportType === _hardwareWallets.LedgerTransportTypes.webhid && webHidConnectedStatus !== _hardwareWallets.WebHIDConnectedStatuses.connected) {
        var _window$navigator;
        const devices = await ((_window$navigator = window.navigator) === null || _window$navigator === void 0 || (_window$navigator = _window$navigator.hid) === null || _window$navigator === void 0 ? void 0 : _window$navigator.getDevices());
        const webHidIsConnected = devices === null || devices === void 0 ? void 0 : devices.some(device => device.vendorId === Number(_hardwareWallets.LEDGER_USB_VENDOR_ID));
        dispatch((0, _app.setLedgerWebHidConnectedStatus)(webHidIsConnected ? _hardwareWallets.WebHIDConnectedStatuses.connected : _hardwareWallets.WebHIDConnectedStatuses.notConnected));
      }
    };
    const determineTransportStatus = async () => {
      if (ledgerTransportType === _hardwareWallets.LedgerTransportTypes.webhid && webHidConnectedStatus === _hardwareWallets.WebHIDConnectedStatuses.connected && transportStatus === _hardwareWallets.HardwareTransportStates.none) {
        try {
          const transportedCreated = await (0, _actions.attemptLedgerTransportCreation)();
          dispatch((0, _app.setLedgerTransportStatus)(transportedCreated ? _hardwareWallets.HardwareTransportStates.verified : _hardwareWallets.HardwareTransportStates.unknownFailure));
        } catch (e) {
          if (e.message.match('Failed to open the device')) {
            dispatch((0, _app.setLedgerTransportStatus)(_hardwareWallets.HardwareTransportStates.deviceOpenFailure));
          } else if (e.message.match('the device is already open')) {
            dispatch((0, _app.setLedgerTransportStatus)(_hardwareWallets.HardwareTransportStates.verified));
          } else {
            dispatch((0, _app.setLedgerTransportStatus)(_hardwareWallets.HardwareTransportStates.unknownFailure));
          }
        }
      }
    };
    determineTransportStatus();
    initialConnectedDeviceCheck();
  }, [dispatch, ledgerTransportType, isLedgerWallet, webHidConnectedStatus, transportStatus]);
  (0, _react.useEffect)(() => {
    if (!isLedgerWallet) {
      return undefined;
    }
    return () => {
      dispatch((0, _app.setLedgerTransportStatus)(_hardwareWallets.HardwareTransportStates.none));
    };
  }, [dispatch]);
  return {
    isLedgerWallet
  };
};
var _default = exports.default = useLedgerConnection;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useLedgerConnection.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useMaxFeePerGasInput.js", {"../../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../../helpers/utils/transactions.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\transactions.util.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","./utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\utils.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseMaxFeePerGasInput.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMaxFeePerGasInput = useMaxFeePerGasInput;
var _react = require("react");
var _reactRedux = require("react-redux");
var _selectors = require("../../../selectors");
var _transactions = require("../../../helpers/utils/transactions.util");
var _conversion = require("../../../../shared/modules/conversion.utils");
var _utils = require("./utils");
const getMaxFeePerGasFromTransaction = (transaction, gasFeeEstimates) => {
  if (gasFeeEstimates !== null && gasFeeEstimates !== void 0 && gasFeeEstimates[transaction === null || transaction === void 0 ? void 0 : transaction.userFeeLevel]) {
    return gasFeeEstimates[transaction.userFeeLevel].suggestedMaxFeePerGas;
  }
  const {
    maxFeePerGas,
    gasPrice
  } = (transaction === null || transaction === void 0 ? void 0 : transaction.txParams) || {};
  return Number((0, _conversion.hexWEIToDecGWEI)(maxFeePerGas || gasPrice));
};

/**
 * @typedef {object} MaxFeePerGasInputReturnType
 * @property {(DecGweiString) => void} setMaxFeePerGas - state setter method to update the maxFeePerGas.
 * @property {string} [maxFeePerGas] - getter method for maxFeePerGas.
 */

/**
 * @param options
 * @param options.estimateToUse
 * @param options.gasEstimateType
 * @param options.gasFeeEstimates
 * @param options.transaction
 * @returns {MaxFeePerGasInputReturnType}
 */
function useMaxFeePerGasInput({
  estimateToUse,
  gasEstimateType,
  gasFeeEstimates,
  transaction
}) {
  const supportsEIP1559 = (0, _reactRedux.useSelector)(_selectors.checkNetworkAndAccountSupports1559) && !(0, _transactions.isLegacyTransaction)(transaction === null || transaction === void 0 ? void 0 : transaction.txParams);
  const initialMaxFeePerGas = supportsEIP1559 ? getMaxFeePerGasFromTransaction(transaction, gasFeeEstimates) : 0;

  // This hook keeps track of a few pieces of transitional state. It is
  // transitional because it is only used to modify a transaction in the
  // metamask (background) state tree.
  const [maxFeePerGas, setMaxFeePerGas] = (0, _react.useState)(() => {
    if (initialMaxFeePerGas && (0, _utils.feeParamsAreCustom)(transaction)) {
      return initialMaxFeePerGas;
    }
    return null;
  });
  (0, _react.useEffect)(() => {
    if (supportsEIP1559 && initialMaxFeePerGas) {
      setMaxFeePerGas(initialMaxFeePerGas);
    }
  }, [initialMaxFeePerGas, setMaxFeePerGas, supportsEIP1559]);

  // We specify whether to use the estimate value by checking if the state
  // value has been set. The state value is only set by user input and is wiped
  // when the user selects an estimate. Default here is '0' to avoid bignumber
  // errors in later calculations for nullish values.
  const maxFeePerGasToUse = maxFeePerGas ?? (0, _utils.getGasFeeEstimate)('suggestedMaxFeePerGas', gasFeeEstimates, gasEstimateType, estimateToUse, initialMaxFeePerGas || 0);
  return {
    maxFeePerGas: maxFeePerGasToUse,
    setMaxFeePerGas
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useMaxFeePerGasInput.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useMaxPriorityFeePerGasInput.js", {"../../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../../helpers/utils/transactions.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\transactions.util.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","./utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\utils.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseMaxPriorityFeePerGasInput.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMaxPriorityFeePerGasInput = useMaxPriorityFeePerGasInput;
var _reactRedux = require("react-redux");
var _react = require("react");
var _selectors = require("../../../selectors");
var _transactions = require("../../../helpers/utils/transactions.util");
var _conversion = require("../../../../shared/modules/conversion.utils");
var _utils = require("./utils");
const isNullOrUndefined = value => value === null || value === undefined;
const getMaxPriorityFeePerGasFromTransaction = (transaction, gasFeeEstimates) => {
  if (gasFeeEstimates !== null && gasFeeEstimates !== void 0 && gasFeeEstimates[transaction === null || transaction === void 0 ? void 0 : transaction.userFeeLevel]) {
    return gasFeeEstimates[transaction.userFeeLevel].suggestedMaxPriorityFeePerGas;
  }
  const {
    maxPriorityFeePerGas,
    maxFeePerGas,
    gasPrice
  } = (transaction === null || transaction === void 0 ? void 0 : transaction.txParams) || {};
  const feeInHexWei = maxPriorityFeePerGas || maxFeePerGas || gasPrice;
  return feeInHexWei ? Number((0, _conversion.hexWEIToDecGWEI)(feeInHexWei)) : null;
};

/**
 * @typedef {object} MaxPriorityFeePerGasInputReturnType
 * @property {DecGweiString} [maxPriorityFeePerGas] - the maxPriorityFeePerGas
 *  input value.
 * @property {(DecGweiString) => void} setMaxPriorityFeePerGas - state setter
 *  method to update the maxPriorityFeePerGas.
 */

/**
 * @param options
 * @param options.estimateToUse
 * @param options.gasEstimateType
 * @param options.gasFeeEstimates
 * @param options.transaction
 * @returns {MaxPriorityFeePerGasInputReturnType}
 */
function useMaxPriorityFeePerGasInput({
  estimateToUse,
  gasEstimateType,
  gasFeeEstimates,
  transaction
}) {
  const supportsEIP1559 = (0, _reactRedux.useSelector)(_selectors.checkNetworkAndAccountSupports1559) && !(0, _transactions.isLegacyTransaction)(transaction === null || transaction === void 0 ? void 0 : transaction.txParams);
  const initialMaxPriorityFeePerGas = supportsEIP1559 ? getMaxPriorityFeePerGasFromTransaction(transaction, gasFeeEstimates) : null;
  const [maxPriorityFeePerGas, setMaxPriorityFeePerGas] = (0, _react.useState)(() => {
    if (!isNullOrUndefined(initialMaxPriorityFeePerGas) && (0, _utils.feeParamsAreCustom)(transaction)) {
      return initialMaxPriorityFeePerGas;
    }
    return null;
  });
  (0, _react.useEffect)(() => {
    if (supportsEIP1559 && !isNullOrUndefined(initialMaxPriorityFeePerGas)) {
      setMaxPriorityFeePerGas(initialMaxPriorityFeePerGas);
    }
  }, [initialMaxPriorityFeePerGas, setMaxPriorityFeePerGas, supportsEIP1559]);
  const maxPriorityFeePerGasToUse = maxPriorityFeePerGas ?? (0, _utils.getGasFeeEstimate)('suggestedMaxPriorityFeePerGas', gasFeeEstimates, gasEstimateType, estimateToUse, initialMaxPriorityFeePerGas || 0);
  return {
    maxPriorityFeePerGas: maxPriorityFeePerGasToUse,
    setMaxPriorityFeePerGas
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useMaxPriorityFeePerGasInput.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useNftImageUrl.ts", {"../../../hooks/useGetAssetImageUrl":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useGetAssetImageUrl.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseNftImageUrl.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNftImageUrl = useNftImageUrl;
var _reactRedux = require("react-redux");
var _selectors = require("../../../selectors");
var _useGetAssetImageUrl = _interopRequireDefault(require("../../../hooks/useGetAssetImageUrl"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function useNftImageUrl(imageUrl) {
  const ipfsGateway = (0, _reactRedux.useSelector)(_selectors.getIpfsGateway);
  const nftImageURL = (0, _useGetAssetImageUrl.default)(imageUrl, ipfsGateway);
  const isImageHosted = imageUrl && !imageUrl.startsWith('ipfs:');
  const nftItemSrc = isImageHosted ? imageUrl : nftImageURL;
  return nftItemSrc;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useNftImageUrl.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useOriginThrottling.ts", {"../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./useCurrentConfirmation":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useCurrentConfirmation.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseOriginThrottling.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOriginThrottling = useOriginThrottling;
var _react = require("react");
var _reactRedux = require("react-redux");
var _actions = require("../../../store/actions");
var _selectors = require("../../../selectors");
var _useCurrentConfirmation = _interopRequireDefault(require("./useCurrentConfirmation"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const NUMBER_OF_REJECTIONS_THRESHOLD = 3;
const REJECTION_THRESHOLD_IN_MS = 30000;
const willNextRejectionReachThreshold = originState => {
  if (!originState) {
    return false;
  }
  const currentTime = Date.now();
  const {
    rejections,
    lastRejection
  } = originState;
  return rejections + 1 >= NUMBER_OF_REJECTIONS_THRESHOLD && currentTime - lastRejection <= REJECTION_THRESHOLD_IN_MS;
};
function useOriginThrottling() {
  var _currentConfirmation$;
  const dispatch = (0, _reactRedux.useDispatch)();
  const throttledOrigins = (0, _reactRedux.useSelector)(_selectors.selectThrottledOrigins);
  const {
    currentConfirmation
  } = (0, _useCurrentConfirmation.default)();
  const origin = (currentConfirmation === null || currentConfirmation === void 0 ? void 0 : currentConfirmation.origin) || (currentConfirmation === null || currentConfirmation === void 0 || (_currentConfirmation$ = currentConfirmation.messageParams) === null || _currentConfirmation$ === void 0 ? void 0 : _currentConfirmation$.origin);
  const originState = throttledOrigins[origin];
  const shouldThrottleOrigin = willNextRejectionReachThreshold(originState);
  const resetOrigin = (0, _react.useCallback)(() => {
    dispatch((0, _actions.updateThrottledOriginState)(origin, {
      rejections: 0,
      lastRejection: 0
    }));
  }, [dispatch, origin]);
  return {
    origin,
    resetOrigin,
    shouldThrottleOrigin
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useOriginThrottling.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useRedesignedSendFlow.ts", {"../../../selectors/remote-feature-flags":"D:\\code\\v\\metamask-extension\\ui\\selectors\\remote-feature-flags.ts","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseRedesignedSendFlow.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRedesignedSendFlow = void 0;
var _reactRedux = require("react-redux");
var _remoteFeatureFlags = require("../../../selectors/remote-feature-flags");
const useRedesignedSendFlow = () => {
  const {
    sendRedesign: sendRedesignFeatureFlag
  } = (0, _reactRedux.useSelector)(_remoteFeatureFlags.getRemoteFeatureFlags);
  const {
    enabled: isSendRedesignEnabled
  } = sendRedesignFeatureFlag ?? {};
  if (isSendRedesignEnabled === false) {
    return {
      enabled: false
    };
  }
  return {
    enabled: true
  };
};
exports.useRedesignedSendFlow = useRedesignedSendFlow;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useRedesignedSendFlow.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useSignatureEventFragment.ts", {"../../../helpers/utils/metrics":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\metrics.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","../utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\utils\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseSignatureEventFragment.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSignatureEventFragment = void 0;
var _react = require("react");
var _metrics = require("../../../helpers/utils/metrics");
var _actions = require("../../../store/actions");
var _confirm = require("../context/confirm");
var _utils = require("../utils");
/**
 * When a signature has been requested, there should be an event fragment created for it in
 * {@see {@link app/scripts/lib/createRPCMethodTrackingMiddleware.js}.
 * This hook method is used to update an existing signature event fragment for a signature confirmation.
 */
const useSignatureEventFragment = () => {
  var _msgParams;
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const requestId = (0, _utils.isSignatureTransactionType)(currentConfirmation) && (currentConfirmation === null || currentConfirmation === void 0 || (_msgParams = currentConfirmation.msgParams) === null || _msgParams === void 0 ? void 0 : _msgParams.requestId);
  const fragmentId = requestId ? (0, _metrics.generateSignatureUniqueId)(requestId) : null;
  const updateSignatureEventFragment = (0, _react.useCallback)(async fragmentPayload => {
    if (!fragmentId) {
      return;
    }
    (0, _actions.updateEventFragment)(fragmentId, fragmentPayload);
  }, [fragmentId]);
  return {
    updateSignatureEventFragment
  };
};
exports.useSignatureEventFragment = useSignatureEventFragment;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useSignatureEventFragment.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useSmartAccountActions.ts", {"../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseSmartAccountActions.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSmartAccountActions = useSmartAccountActions;
var _rpcErrors = require("@metamask/rpc-errors");
var _react = require("react");
var _reactRedux = require("react-redux");
var _actions = require("../../../store/actions");
var _confirm = require("../context/confirm");
var _transaction = require("../../../../shared/constants/transaction");
function useSmartAccountActions() {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const {
    id: confirmationId,
    chainId,
    txParams
  } = currentConfirmation ?? {};
  const {
    from
  } = txParams ?? {};
  const handleRejectUpgrade = (0, _react.useCallback)(async () => {
    if (!chainId || !from) {
      return;
    }
    const error = new _rpcErrors.JsonRpcError(_transaction.EIP5792ErrorCode.RejectedUpgrade, 'User rejected account upgrade');
    const serializedError = (0, _rpcErrors.serializeError)(error);
    dispatch((0, _actions.rejectPendingApproval)(confirmationId, serializedError));
  }, [dispatch, confirmationId, chainId, from]);
  return {
    handleRejectUpgrade
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useSmartAccountActions.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useSmartTransactionFeatureFlags.ts", {"../../../../shared/modules/selectors":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\index.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../swaps/swaps.util":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\swaps.util.ts","../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseSmartTransactionFeatureFlags.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSmartTransactionFeatureFlags = useSmartTransactionFeatureFlags;
var _reactRedux = require("react-redux");
var _react = require("react");
var _loglevel = _interopRequireDefault(require("loglevel"));
var _selectors = require("../../../../shared/modules/selectors");
var _swaps = require("../../swaps/swaps.util");
var _actions = require("../../../store/actions");
var _confirm = require("../context/confirm");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function useSmartTransactionFeatureFlags() {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const {
    id: transactionId,
    txParams,
    networkClientId
  } = currentConfirmation ?? {};
  const isTransaction = Boolean(txParams);
  const smartTransactionsPreferenceEnabled = (0, _reactRedux.useSelector)(_selectors.getSmartTransactionsPreferenceEnabled);
  const currentChainSupportsSmartTransactions = (0, _reactRedux.useSelector)(_selectors.getChainSupportsSmartTransactions);
  (0, _react.useEffect)(() => {
    if (!isTransaction || !transactionId || !smartTransactionsPreferenceEnabled || !currentChainSupportsSmartTransactions) {
      return;
    }
    Promise.all([(0, _swaps.fetchSwapsFeatureFlags)(), (0, _actions.fetchSmartTransactionsLiveness)({
      networkClientId
    })()]).then(([swapsFeatureFlags]) => {
      var _swapsFeatureFlags$sm;
      dispatch((0, _actions.setSwapsFeatureFlags)(swapsFeatureFlags));
      dispatch((0, _actions.setSmartTransactionsRefreshInterval)((_swapsFeatureFlags$sm = swapsFeatureFlags.smartTransactions) === null || _swapsFeatureFlags$sm === void 0 ? void 0 : _swapsFeatureFlags$sm.batchStatusPollingInterval));
    }).catch(error => {
      _loglevel.default.debug('Error updating smart transaction feature flags', error);
    });
  }, [isTransaction, transactionId, smartTransactionsPreferenceEnabled, currentChainSupportsSmartTransactions, networkClientId]);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useSmartTransactionFeatureFlags.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useTrackERC20WithoutDecimalInformation.ts", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../utils/token":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\utils\\token.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseTrackERC20WithoutDecimalInformation.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("react");
var _metametrics = require("../../../../shared/constants/metametrics");
var _transaction = require("../../../../shared/constants/transaction");
var _metametrics2 = require("../../../contexts/metametrics");
var _token = require("../utils/token");
/**
 * Track event that number of decimals in ERC20 is not obtained
 *
 * @param chainId
 * @param tokenAddress
 * @param tokenDetails
 * @param metricLocation
 */
const useTrackERC20WithoutDecimalInformation = (chainId, tokenAddress, tokenDetails, metricLocation = _metametrics.MetaMetricsEventLocation.SignatureConfirmation) => {
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const hasTracked = (0, _react.useRef)(false);
  (0, _react.useEffect)(() => {
    if (chainId === undefined || tokenDetails === undefined || hasTracked.current) {
      return;
    }
    const {
      decimals,
      standard
    } = tokenDetails || {};
    if (standard !== _transaction.TokenStandard.ERC20) {
      return;
    }
    const parsedDecimals = (0, _token.parseTokenDetailDecimals)(decimals);
    if (parsedDecimals === undefined) {
      trackEvent({
        event: _metametrics.MetaMetricsEventName.SimulationIncompleteAssetDisplayed,
        category: _metametrics.MetaMetricsEventCategory.Confirmations,
        properties: {
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          token_decimals_available: 'not_available',
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          asset_address: tokenAddress,
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          asset_type: _transaction.TokenStandard.ERC20,
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          chain_id: chainId,
          location: metricLocation,
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          ui_customizations: [_metametrics.MetaMetricsEventUiCustomization.RedesignedConfirmation]
        }
      });
      hasTracked.current = true;
    }
  }, [tokenDetails, chainId, metricLocation, tokenAddress, trackEvent]);
};
var _default = exports.default = useTrackERC20WithoutDecimalInformation;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useTrackERC20WithoutDecimalInformation.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useTransactionEventFragment.js", {"../../../contexts/gasFee":"D:\\code\\v\\metamask-extension\\ui\\contexts\\gasFee.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseTransactionEventFragment.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTransactionEventFragment = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _gasFee = require("../../../contexts/gasFee");
var _actions = require("../../../store/actions");
var _selectors = require("../../../selectors");
const useTransactionEventFragment = () => {
  const {
    transaction
  } = (0, _gasFee.useGasFeeContext)();
  const fragment = (0, _reactRedux.useSelector)(state => (0, _selectors.selectMatchingFragment)(state, {
    fragmentOptions: {},
    existingId: `transaction-added-${transaction === null || transaction === void 0 ? void 0 : transaction.id}`
  }));
  const fragmentExists = Boolean(fragment);
  const gasTransactionId = transaction === null || transaction === void 0 ? void 0 : transaction.id;
  const updateTransactionEventFragment = (0, _react.useCallback)(async (params, _transactionId) => {
    const transactionId = _transactionId || gasTransactionId;
    if (!transactionId) {
      return;
    }
    if (!fragmentExists) {
      await (0, _actions.createTransactionEventFragment)(transactionId);
    }
    (0, _actions.updateEventFragment)(`transaction-added-${transactionId}`, params);
    (0, _actions.updateEventFragment)(`transaction-submitted-${transactionId}`, params);
  }, [fragmentExists, gasTransactionId]);
  return {
    updateTransactionEventFragment
  };
};
exports.useTransactionEventFragment = useTransactionEventFragment;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useTransactionEventFragment.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useTransactionFocusEffect.ts", {"../../../hooks/useWindowFocus":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useWindowFocus.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseTransactionFocusEffect.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTransactionFocusEffect = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _transactionController = require("@metamask/transaction-controller");
var _actions = require("../../../store/actions");
var _useWindowFocus = require("../../../hooks/useWindowFocus");
var _confirm = require("../context/confirm");
const FOCUSABLE_TYPES = new Set([_transactionController.TransactionType.contractInteraction, _transactionController.TransactionType.deployContract, _transactionController.TransactionType.simpleSend, _transactionController.TransactionType.smart, _transactionController.TransactionType.tokenMethodTransfer, _transactionController.TransactionType.tokenMethodTransferFrom, _transactionController.TransactionType.tokenMethodSafeTransferFrom]);
const useTransactionFocusEffect = () => {
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const {
    id,
    type
  } = currentConfirmation ?? {};
  const isWindowFocused = (0, _useWindowFocus.useWindowFocus)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const [focusedConfirmationId, setFocusedConfirmationId] = (0, _react.useState)(null);
  const setTransactionFocus = (0, _react.useCallback)(async (transactionId, isFocused) => {
    await dispatch((0, _actions.setTransactionActive)(transactionId, isFocused));
  }, [dispatch]);
  (0, _react.useEffect)(() => {
    const isFocusable = FOCUSABLE_TYPES.has(type);
    if (!isFocusable) {
      // If the transaction type is not one of the types that should be focused,
      // we need to unfocus the previous focused confirmation and reset the focused confirmation
      if (focusedConfirmationId) {
        setTransactionFocus(focusedConfirmationId, false);
        setFocusedConfirmationId(null);
      }
      return;
    }
    if (isWindowFocused && focusedConfirmationId !== id) {
      // If the window is focused and the focused confirmation is not the current one,
      // we need to unfocus the previous focused confirmation and focus the current one
      if (focusedConfirmationId) {
        setTransactionFocus(focusedConfirmationId, false);
      }
      // Set the focused confirmation to the current one
      setFocusedConfirmationId(id);
      setTransactionFocus(id, true);
    } else if (!isWindowFocused && focusedConfirmationId) {
      // If the window is not focused and there is a focused confirmation,
      // we need to unfocus the focused confirmation
      setTransactionFocus(focusedConfirmationId, false);
      setFocusedConfirmationId(null);
    }
  }, [focusedConfirmationId, id, isWindowFocused, setTransactionFocus, type]);
};
exports.useTransactionFocusEffect = useTransactionFocusEffect;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useTransactionFocusEffect.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useTransactionFunctions.js", {"../../../../shared/constants/gas":"D:\\code\\v\\metamask-extension\\shared\\constants\\gas.ts","../../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../../helpers/utils/gas":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\gas.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","bignumber.js":"D:\\code\\v\\metamask-extension\\node_modules\\bignumber.js\\bignumber.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseTransactionFunctions.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTransactionFunctions = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _bignumber = _interopRequireDefault(require("bignumber.js"));
var _gas = require("../../../../shared/constants/gas");
var _gas2 = require("../../../helpers/utils/gas");
var _actions = require("../../../store/actions");
var _conversion = require("../../../../shared/modules/conversion.utils");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * @typedef {object} TransactionFunctionsReturnType
 * @property {() => void} cancelTransaction - cancel the transaction.
 * @property {() => void} speedUpTransaction - speed up the transaction.
 * @property {(string, number, number, number, string) => void} updateTransaction - update the transaction.
 * @property {(boolean) => void} updateTransactionToTenPercentIncreasedGasFee - update the cancel / speed transaction to
 * gas fee which is equal to current gas fee +10 percent.
 * @property {(string) => void} updateTransactionUsingDAPPSuggestedValues - update the transaction to DAPP suggested gas value.
 * @property {(string) => void} updateTransactionUsingEstimate - update the transaction using the estimate passed.
 */

/**
 * @param options
 * @param options.defaultEstimateToUse
 * @param options.editGasMode
 * @param options.estimatedBaseFee
 * @param options.gasFeeEstimates
 * @param options.gasLimit
 * @param options.maxPriorityFeePerGas
 * @param options.transaction
 * @param options.setRetryTxMeta
 * @returns {TransactionFunctionsReturnType}
 */
const useTransactionFunctions = ({
  defaultEstimateToUse,
  editGasMode,
  estimatedBaseFee,
  gasFeeEstimates,
  gasLimit: gasLimitValue,
  maxPriorityFeePerGas: maxPriorityFeePerGasValue,
  transaction,
  setRetryTxMeta
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const getTxMeta = (0, _react.useCallback)(() => {
    if (editGasMode !== _gas.EditGasModes.cancel && editGasMode !== _gas.EditGasModes.speedUp || transaction.previousGas) {
      return {};
    }
    const {
      maxFeePerGas,
      maxPriorityFeePerGas,
      gasLimit
    } = (transaction === null || transaction === void 0 ? void 0 : transaction.txParams) ?? {};
    return {
      previousGas: {
        maxFeePerGas,
        maxPriorityFeePerGas,
        gasLimit
      }
    };
  }, [editGasMode, transaction === null || transaction === void 0 ? void 0 : transaction.previousGas, transaction === null || transaction === void 0 ? void 0 : transaction.txParams]);
  const updateTransaction = (0, _react.useCallback)(async ({
    estimateUsed,
    gasLimit,
    maxFeePerGas,
    maxPriorityFeePerGas,
    estimateSuggested
  }) => {
    const newGasSettings = {
      gas: (0, _conversion.decimalToHex)(gasLimit || gasLimitValue),
      gasLimit: (0, _conversion.decimalToHex)(gasLimit || gasLimitValue),
      estimateSuggested: estimateSuggested || defaultEstimateToUse,
      estimateUsed
    };
    if (maxFeePerGas) {
      newGasSettings.maxFeePerGas = maxFeePerGas;
    }
    if (maxPriorityFeePerGas) {
      newGasSettings.maxPriorityFeePerGas = maxPriorityFeePerGas || (0, _conversion.decGWEIToHexWEI)(maxPriorityFeePerGasValue);
    }
    const txMeta = getTxMeta();
    const updatedTxMeta = {
      ...transaction,
      userFeeLevel: estimateUsed || _gas.PriorityLevels.custom,
      txParams: {
        ...transaction.txParams,
        ...newGasSettings
      },
      ...txMeta
    };
    if (editGasMode === _gas.EditGasModes.swaps) {
      dispatch((0, _actions.updateSwapsUserFeeLevel)(estimateUsed || _gas.PriorityLevels.custom));
      dispatch((0, _actions.updateCustomSwapsEIP1559GasParams)(newGasSettings));
    } else if ((0, _gas2.editGasModeIsSpeedUpOrCancel)(editGasMode)) {
      setRetryTxMeta(updatedTxMeta);
    } else {
      newGasSettings.userEditedGasLimit = updatedTxMeta.userEditedGasLimit;
      newGasSettings.userFeeLevel = updatedTxMeta.userFeeLevel;
      if (txMeta && txMeta.previousGas) {
        await dispatch((0, _actions.updatePreviousGasParams)(updatedTxMeta.id, txMeta.previousGas));
      }
      await dispatch((0, _actions.updateTransactionGasFees)(updatedTxMeta.id, newGasSettings));
    }
  }, [defaultEstimateToUse, dispatch, editGasMode, gasLimitValue, getTxMeta, maxPriorityFeePerGasValue, transaction, setRetryTxMeta]);
  const cancelTransaction = (0, _react.useCallback)(() => {
    dispatch((0, _actions.createCancelTransaction)(transaction.id, transaction.txParams, {
      estimatedBaseFee
    }));
  }, [dispatch, estimatedBaseFee, transaction]);
  const speedUpTransaction = (0, _react.useCallback)(() => {
    dispatch((0, _actions.createSpeedUpTransaction)(transaction.id, transaction.txParams, {
      estimatedBaseFee
    }));
  }, [dispatch, estimatedBaseFee, transaction]);
  const updateTransactionToTenPercentIncreasedGasFee = (0, _react.useCallback)((initTransaction = false) => {
    const {
      gas: gasLimit,
      maxFeePerGas,
      maxPriorityFeePerGas
    } = transaction.previousGas || transaction.txParams;
    const newMaxPriorityFeePerGas = new _bignumber.default(maxPriorityFeePerGas, 16).isZero() ? (0, _conversion.decGWEIToHexWEI)(gasFeeEstimates[defaultEstimateToUse].suggestedMaxPriorityFeePerGas) : maxPriorityFeePerGas;
    const estimateUsed = maxPriorityFeePerGas === '0x0' ? _gas.CUSTOM_GAS_ESTIMATE : _gas.PriorityLevels.tenPercentIncreased;
    if (!gasFeeEstimates) {
      return;
    }
    updateTransaction({
      estimateSuggested: initTransaction ? defaultEstimateToUse : _gas.PriorityLevels.tenPercentIncreased,
      estimateUsed,
      gasLimit,
      maxFeePerGas: (0, _gas2.addTenPercentAndRound)(maxFeePerGas),
      maxPriorityFeePerGas: (0, _gas2.addTenPercentAndRound)(newMaxPriorityFeePerGas)
    });
  }, [defaultEstimateToUse, gasFeeEstimates, transaction, updateTransaction]);
  const updateTransactionUsingEstimate = (0, _react.useCallback)(gasFeeEstimateToUse => {
    if (!(gasFeeEstimates !== null && gasFeeEstimates !== void 0 && gasFeeEstimates[gasFeeEstimateToUse])) {
      return;
    }
    const {
      suggestedMaxFeePerGas,
      suggestedMaxPriorityFeePerGas
    } = gasFeeEstimates[gasFeeEstimateToUse];
    updateTransaction({
      estimateUsed: gasFeeEstimateToUse,
      maxFeePerGas: (0, _conversion.decGWEIToHexWEI)(suggestedMaxFeePerGas),
      maxPriorityFeePerGas: (0, _conversion.decGWEIToHexWEI)(suggestedMaxPriorityFeePerGas)
    });
  }, [gasFeeEstimates, updateTransaction]);
  const updateTransactionUsingDAPPSuggestedValues = (0, _react.useCallback)(() => {
    const {
      maxFeePerGas,
      maxPriorityFeePerGas
    } = (transaction === null || transaction === void 0 ? void 0 : transaction.dappSuggestedGasFees) ?? {};
    updateTransaction({
      estimateUsed: _gas.PriorityLevels.dAppSuggested,
      maxFeePerGas,
      maxPriorityFeePerGas
    });
  }, [transaction, updateTransaction]);
  return {
    cancelTransaction,
    speedUpTransaction,
    updateTransaction,
    updateTransactionToTenPercentIncreasedGasFee,
    updateTransactionUsingDAPPSuggestedValues,
    updateTransactionUsingEstimate
  };
};
exports.useTransactionFunctions = useTransactionFunctions;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useTransactionFunctions.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useTypedSignSignatureInfo.ts", {"../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../../shared/modules/transaction.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\transaction.utils.ts","../constants":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\constants\\index.ts","../utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\utils\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseTypedSignSignatureInfo.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTypedSignSignatureInfo = void 0;
var _react = require("react");
var _utils = require("../utils");
var _transaction = require("../../../../shared/modules/transaction.utils");
var _transaction2 = require("../../../../shared/constants/transaction");
var _app = require("../../../../shared/constants/app");
var _constants = require("../constants");
const useTypedSignSignatureInfo = confirmation => {
  const primaryType = (0, _react.useMemo)(() => {
    if (!confirmation || !(0, _utils.isSignatureTransactionType)(confirmation) || (confirmation === null || confirmation === void 0 ? void 0 : confirmation.type) !== _app.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA) {
      return undefined;
    }
    if ((0, _utils.isPermitSignatureRequest)(confirmation)) {
      return _constants.TypedSignSignaturePrimaryTypes.PERMIT;
    } else if ((0, _utils.isOrderSignatureRequest)(confirmation)) {
      return _constants.TypedSignSignaturePrimaryTypes.ORDER;
    }
    return undefined;
  }, [confirmation]);

  // here we are using presence of tokenId in typed message data to know if its NFT permit
  // we can get contract details for verifyingContract but that is async process taking longer
  // and result in confirmation page content loading late
  const tokenStandard = (0, _react.useMemo)(() => {
    var _confirmation$msgPara;
    if (primaryType !== _constants.TypedSignSignaturePrimaryTypes.PERMIT) {
      return undefined;
    }
    const {
      message: {
        tokenId
      }
    } = (0, _transaction.parseTypedDataMessage)(confirmation === null || confirmation === void 0 || (_confirmation$msgPara = confirmation.msgParams) === null || _confirmation$msgPara === void 0 ? void 0 : _confirmation$msgPara.data);
    if (tokenId !== undefined) {
      return _transaction2.TokenStandard.ERC721;
    }
    return undefined;
  }, [confirmation, primaryType]);
  return {
    primaryType: primaryType,
    tokenStandard
  };
};
exports.useTypedSignSignatureInfo = useTypedSignSignatureInfo;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useTypedSignSignatureInfo.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useTypesSignSimulationEnabledInfo.ts", {"../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../../shared/modules/transaction.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\transaction.utils.ts","../context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","../selectors/preferences":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\selectors\\preferences.ts","../utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\utils\\index.ts","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5CuseTypesSignSimulationEnabledInfo.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTypesSignSimulationEnabledInfo = useTypesSignSimulationEnabledInfo;
var _reactRedux = require("react-redux");
var _app = require("../../../../shared/constants/app");
var _transaction = require("../../../../shared/modules/transaction.utils");
var _utils = require("../utils");
var _preferences = require("../selectors/preferences");
var _confirm = require("../context/confirm");
const NON_PERMIT_SUPPORTED_TYPES_SIGNS = [{
  domainName: 'Seaport',
  primaryTypeList: ['BulkOrder'],
  versionList: ['1.4', '1.5', '1.6']
}, {
  domainName: 'Seaport',
  primaryTypeList: ['OrderComponents']
}];
const isNonPermitSupportedByDecodingAPI = signatureRequest => {
  var _msgParams;
  const data = (_msgParams = signatureRequest.msgParams) === null || _msgParams === void 0 ? void 0 : _msgParams.data;
  if (!data) {
    return false;
  }
  const {
    domain: {
      name,
      version
    },
    primaryType
  } = (0, _transaction.parseTypedDataMessage)(data);
  return NON_PERMIT_SUPPORTED_TYPES_SIGNS.some(({
    domainName,
    primaryTypeList,
    versionList
  }) => name === domainName && primaryTypeList.includes(primaryType) && (!versionList || versionList.includes(version)));
};
function useTypesSignSimulationEnabledInfo() {
  var _currentConfirmation$;
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const useTransactionSimulations = (0, _reactRedux.useSelector)(_preferences.selectUseTransactionSimulations);
  const signatureMethod = currentConfirmation === null || currentConfirmation === void 0 || (_currentConfirmation$ = currentConfirmation.msgParams) === null || _currentConfirmation$ === void 0 ? void 0 : _currentConfirmation$.signatureMethod;
  const isTypedSignV3V4 = signatureMethod === _app.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V4 || signatureMethod === _app.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V3;
  const isPermit = (0, _utils.isPermitSignatureRequest)(currentConfirmation);
  const nonPermitSupportedByDecodingAPI = isTypedSignV3V4 && isNonPermitSupportedByDecodingAPI(currentConfirmation);
  if (!currentConfirmation) {
    return undefined;
  }
  return useTransactionSimulations && isTypedSignV3V4 && (isPermit || nonPermitSupportedByDecodingAPI);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\useTypesSignSimulationEnabledInfo.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\utils.js", {"../../../../shared/constants/gas":"D:\\code\\v\\metamask-extension\\shared\\constants\\gas.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Chooks%5Cutils.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.feeParamsAreCustom = void 0;
exports.getGasFeeEstimate = getGasFeeEstimate;
var _gas = require("../../../../shared/constants/gas");
function getGasFeeEstimate(field, gasFeeEstimates, gasEstimateType, estimateToUse, fallback = '0') {
  if (gasEstimateType === _gas.GasEstimateTypes.feeMarket) {
    var _gasFeeEstimates$esti;
    return (gasFeeEstimates === null || gasFeeEstimates === void 0 || (_gasFeeEstimates$esti = gasFeeEstimates[estimateToUse]) === null || _gasFeeEstimates$esti === void 0 ? void 0 : _gasFeeEstimates$esti[field]) ?? String(fallback);
  }
  return String(fallback);
}
const feeParamsAreCustom = transaction => !(transaction !== null && transaction !== void 0 && transaction.userFeeLevel) || (transaction === null || transaction === void 0 ? void 0 : transaction.userFeeLevel) === _gas.CUSTOM_GAS_ESTIMATE;
exports.feeParamsAreCustom = feeParamsAreCustom;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\hooks\\utils.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\selectors\\accounts.ts", {"../../../../shared/modules/selectors/util":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\util.js","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Cselectors%5Caccounts.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectInternalAccountNameByAddress = exports.selectAccountGroupNameByInternalAccount = void 0;
var _util = require("../../../../shared/modules/selectors/util");
var _util2 = require("../../../helpers/utils/util");
var _accountTree = require("../../../selectors/multichain-accounts/account-tree");
var _selectors = require("../../../selectors");
const selectAccountGroupNameByInternalAccount = exports.selectAccountGroupNameByInternalAccount = (0, _util.createDeepEqualSelector)([(state, internalAccount) => {
  if (!internalAccount) {
    return {
      groups: [],
      address: null
    };
  }
  return {
    groups: (0, _accountTree.getAccountGroupsByAddress)(state, [internalAccount]),
    address: internalAccount === null || internalAccount === void 0 ? void 0 : internalAccount.toLowerCase()
  };
}], ({
  groups,
  address
}) => {
  var _group$metadata;
  if (!address || !groups.length) {
    return null;
  }
  const group = groups.find(g => g.accounts.some(a => {
    var _a$address;
    return ((_a$address = a.address) === null || _a$address === void 0 ? void 0 : _a$address.toLowerCase()) === address;
  }));
  return (group === null || group === void 0 || (_group$metadata = group.metadata) === null || _group$metadata === void 0 ? void 0 : _group$metadata.name) ?? null;
});
const selectInternalAccountNameByAddress = exports.selectInternalAccountNameByAddress = (0, _util.createDeepEqualSelector)([(state, address) => ({
  accounts: (0, _selectors.accountsWithSendEtherInfoSelector)(state),
  address
})], ({
  accounts,
  address
}) => {
  var _fromAccount$metadata;
  if (!address || !(accounts !== null && accounts !== void 0 && accounts.length)) {
    return null;
  }
  const fromAccount = (0, _util2.getAccountByAddress)(accounts, address);
  return (fromAccount === null || fromAccount === void 0 || (_fromAccount$metadata = fromAccount.metadata) === null || _fromAccount$metadata === void 0 ? void 0 : _fromAccount$metadata.name) ?? null;
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\selectors\\accounts.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\selectors\\index.ts", {"./confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\selectors\\confirm.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Cselectors%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _confirm = require("./confirm");
Object.keys(_confirm).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _confirm[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _confirm[key];
    }
  });
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\selectors\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\send-legacy\\send-content\\add-recipient\\domain-input.component.js", {"../../../../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../../../../../shared/modules/hexstring-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\hexstring-utils.ts","../../../../../components/app/preferred-avatar":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\preferred-avatar\\index.ts","../../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Csend-legacy%5Csend-content%5Cadd-recipient%5Cdomain-input.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _utils = require("@metamask/utils");
var _util = require("../../../../../../app/scripts/lib/util");
var _util2 = require("../../../../../helpers/utils/util");
var _hexstringUtils = require("../../../../../../shared/modules/hexstring-utils");
var _componentLibrary = require("../../../../../components/component-library");
var _preferredAvatar = require("../../../../../components/app/preferred-avatar");
var _designSystem = require("../../../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } // TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths
class DomainInput extends _react.Component {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "onPaste", event => {
      var _event$clipboardData$;
      if ((_event$clipboardData$ = event.clipboardData.items) !== null && _event$clipboardData$ !== void 0 && _event$clipboardData$.length) {
        const clipboardItem = event.clipboardData.items[0];
        clipboardItem === null || clipboardItem === void 0 || clipboardItem.getAsString(text => {
          const input = text.trim();
          if (!(0, _hexstringUtils.isBurnAddress)(input) && (0, _hexstringUtils.isValidHexAddress)(input, {
            mixedCaseUseChecksum: true
          })) {
            this.props.onPaste((0, _util.addHexPrefix)(input));
          }
        });
      }
    });
    _defineProperty(this, "onChange", ({
      target: {
        value
      }
    }) => {
      const {
        onValidAddressTyped,
        internalSearch,
        onChange,
        lookupDomainName,
        resetDomainResolution
      } = this.props;
      const input = value.trim();
      if (internalSearch) {
        onChange(input);
        return null;
      }
      if ((0, _utils.isHexString)(input)) {
        resetDomainResolution();
        if (onValidAddressTyped && !(0, _hexstringUtils.isBurnAddress)(input) && (0, _hexstringUtils.isValidHexAddress)(input, {
          mixedCaseUseChecksum: true
        })) {
          const hexInput = (0, _util.addHexPrefix)(input);
          onChange(hexInput);
          onValidAddressTyped(hexInput);
        } else {
          onChange(input);
        }
      } else {
        onChange(input);
        lookupDomainName(input);
      }
      return null;
    });
  }
  componentDidMount() {
    this.props.initializeDomainSlice();
  }
  render() {
    const {
      t
    } = this.context;
    const {
      className,
      selectedAddress,
      selectedName,
      userInput
    } = this.props;
    const hasSelectedAddress = Boolean(selectedAddress);
    const shortenedAddress = selectedName && selectedAddress ? (0, _util2.shortenAddress)((0, _hexstringUtils.toChecksumHexAddress)(selectedAddress)) : undefined;
    return /*#__PURE__*/_react.default.createElement("div", {
      className: (0, _classnames.default)('ens-input', className)
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: (0, _classnames.default)('ens-input__wrapper', {
        'ens-input__wrapper__status-icon--error': false,
        'ens-input__wrapper__status-icon--valid': false,
        'ens-input__wrapper--valid': hasSelectedAddress
      })
    }, hasSelectedAddress ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
      className: "ens-input__wrapper__input ens-input__wrapper__input--selected",
      "data-testid": "ens-input-selected"
    }, /*#__PURE__*/_react.default.createElement(_preferredAvatar.PreferredAvatar, {
      address: selectedAddress
    }), /*#__PURE__*/_react.default.createElement("div", {
      className: "ens-input__selected-input__title"
    }, selectedName || selectedAddress, shortenedAddress ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      color: _designSystem.TextColor.textAlternative,
      variant: _designSystem.TextVariant.bodySm,
      ellipsis: true
    }, shortenedAddress) : null)), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      iconName: _componentLibrary.IconName.Close,
      ariaLabel: t('close'),
      onClick: this.props.onReset,
      className: "ens-input__wrapper__action-icon-button",
      size: _componentLibrary.IconSize.Sm
    })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("input", {
      className: "ens-input__wrapper__input",
      type: "text",
      dir: "auto",
      placeholder: t('recipientAddressPlaceholderNew'),
      onChange: this.onChange,
      onPaste: this.onPaste,
      spellCheck: "false",
      value: selectedAddress || userInput,
      autoFocus: true,
      "data-testid": "ens-input"
    }), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      className: "ens-input__wrapper__action-icon-button",
      onClick: () => {
        if ((userInput === null || userInput === void 0 ? void 0 : userInput.length) > 0) {
          this.props.onReset();
        } else {
          this.props.scanQrCode();
        }
      },
      iconName: userInput ? _componentLibrary.IconName.Close : _componentLibrary.IconName.Scan,
      ariaLabel: t(userInput ? 'close' : 'scanQrCode'),
      color: userInput ? _designSystem.IconColor.iconDefault : _designSystem.IconColor.primaryDefault,
      "data-testid": "ens-qr-scan-button"
    }))));
  }
}
exports.default = DomainInput;
_defineProperty(DomainInput, "contextTypes", {
  t: _propTypes.default.func,
  metricsEvent: _propTypes.default.func
});
_defineProperty(DomainInput, "propTypes", {
  className: _propTypes.default.string,
  selectedAddress: _propTypes.default.string,
  selectedName: _propTypes.default.string,
  scanQrCode: _propTypes.default.func,
  onPaste: _propTypes.default.func,
  onValidAddressTyped: _propTypes.default.func,
  internalSearch: _propTypes.default.bool,
  userInput: _propTypes.default.string,
  onChange: _propTypes.default.func.isRequired,
  onReset: _propTypes.default.func.isRequired,
  lookupDomainName: _propTypes.default.func.isRequired,
  initializeDomainSlice: _propTypes.default.func.isRequired,
  resetDomainResolution: _propTypes.default.func.isRequired
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\send-legacy\\send-content\\add-recipient\\domain-input.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\send-legacy\\send-content\\add-recipient\\domain-input.container.js", {"../../../../../ducks/domains":"D:\\code\\v\\metamask-extension\\ui\\ducks\\domains.js","../../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","./domain-input.component":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\send-legacy\\send-content\\add-recipient\\domain-input.component.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Csend-legacy%5Csend-content%5Cadd-recipient%5Cdomain-input.container.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _lodash = require("lodash");
var _reactRedux = require("react-redux");
var _domains = require("../../../../../ducks/domains");
var _selectors = require("../../../../../selectors");
var _domainInput = _interopRequireDefault(require("./domain-input.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// Trigger onChange when chainId changes using MapStateToProps
function mapStateToProps(state) {
  return {
    useBlockie: (0, _selectors.getUseBlockie)(state)
  };
}
function mapDispatchToProps(dispatch) {
  return {
    lookupDomainName: (0, _lodash.debounce)(domainName => dispatch((0, _domains.lookupDomainName)(domainName)), 150),
    initializeDomainSlice: () => dispatch((0, _domains.initializeDomainSlice)()),
    resetDomainResolution: (0, _lodash.debounce)(() => dispatch((0, _domains.resetDomainResolution)()), 300)
  };
}
var _default = exports.default = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_domainInput.default);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\send-legacy\\send-content\\add-recipient\\domain-input.container.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\send-legacy\\send-content\\add-recipient\\domain-input.js", {"./domain-input.container":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\send-legacy\\send-content\\add-recipient\\domain-input.container.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Csend-legacy%5Csend-content%5Cadd-recipient%5Cdomain-input.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _domainInput.default;
  }
});
var _domainInput = _interopRequireDefault(require("./domain-input.container"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\send-legacy\\send-content\\add-recipient\\domain-input.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\send\\index.ts", {"./send":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\send\\send.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Csend%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "Send", {
  enumerable: true,
  get: function () {
    return _send.Send;
  }
});
var _send = require("./send");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\send\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\send\\send-inner.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../components/send/amount-recipient":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\send\\amount-recipient\\index.ts","../components/send/asset":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\send\\asset\\index.ts","../components/send/header":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\send\\header\\index.ts","../components/send/loader":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\send\\loader\\index.ts","../constants/send":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\constants\\send.ts","../context/send":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\send\\index.tsx","../hooks/send/useSendQueryParams":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\send\\useSendQueryParams.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Csend%5Csend-inner.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SendInner = void 0;
var _react = _interopRequireDefault(require("react"));
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../../components/component-library");
var _amountRecipient = require("../components/send/amount-recipient");
var _header = require("../components/send/header");
var _asset = require("../components/send/asset");
var _loader = require("../components/send/loader");
var _send = require("../constants/send");
var _send2 = require("../context/send");
var _useSendQueryParams = require("../hooks/send/useSendQueryParams");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const SendContainer = ({
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    alignItems: _designSystem.AlignItems.center,
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    className: "redesigned__send__container",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    height: _designSystem.BlockSize.Full,
    justifyContent: _designSystem.JustifyContent.center,
    style: {
      flex: '1 0 auto',
      minHeight: 0
    },
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    backgroundColor: _designSystem.BackgroundColor.backgroundSection,
    className: "redesigned__send__wrapper",
    display: _designSystem.Display.Flex,
    height: _designSystem.BlockSize.Full,
    justifyContent: _designSystem.JustifyContent.center,
    width: _designSystem.BlockSize.Full,
    borderRadius: _designSystem.BorderRadius.LG
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "redesigned__send__content",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    height: _designSystem.BlockSize.Full,
    style: {
      maxWidth: '650px'
    },
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_header.Header, null), children)));
};
const SendInner = () => {
  (0, _useSendQueryParams.useSendQueryParams)();
  const {
    currentPage
  } = (0, _send2.useSendContext)();
  if (currentPage === _send.SendPages.LOADER) {
    return /*#__PURE__*/_react.default.createElement(_loader.Loader, null);
  }
  if (currentPage === _send.SendPages.ASSET) {
    return /*#__PURE__*/_react.default.createElement(SendContainer, null, /*#__PURE__*/_react.default.createElement(_asset.Asset, null));
  }
  if (currentPage === _send.SendPages.AMOUNTRECIPIENT) {
    return /*#__PURE__*/_react.default.createElement(SendContainer, null, /*#__PURE__*/_react.default.createElement(_amountRecipient.AmountRecipient, null));
  }
  return null;
};
exports.SendInner = SendInner;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\send\\send-inner.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\send\\send.tsx", {"../../../components/multichain/pages/send":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\index.js","../context/send":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\send\\index.tsx","../context/send-metrics":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\send-metrics\\index.tsx","../hooks/useRedesignedSendFlow":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useRedesignedSendFlow.ts","./send-inner":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\send\\send-inner.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Csend%5Csend.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Send = void 0;
var _react = _interopRequireDefault(require("react"));
var _send = require("../../../components/multichain/pages/send");
var _send2 = require("../context/send");
var _sendMetrics = require("../context/send-metrics");
var _useRedesignedSendFlow = require("../hooks/useRedesignedSendFlow");
var _sendInner = require("./send-inner");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const Send = () => {
  const {
    enabled: isSendRedesignEnabled
  } = (0, _useRedesignedSendFlow.useRedesignedSendFlow)();
  if (isSendRedesignEnabled) {
    return /*#__PURE__*/_react.default.createElement(_send2.SendContextProvider, null, /*#__PURE__*/_react.default.createElement(_sendMetrics.SendMetricsContextProvider, null, /*#__PURE__*/_react.default.createElement(_sendInner.SendInner, null)));
  }
  return /*#__PURE__*/_react.default.createElement(_send.SendPage, null);
};
exports.Send = Send;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\send\\send.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\types\\send.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Ctypes%5Csend.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NFT_STANDARDS = exports.AssetStandard = void 0;
let AssetStandard = exports.AssetStandard = /*#__PURE__*/function (AssetStandard) {
  AssetStandard["Native"] = "native";
  AssetStandard["ERC20"] = "ERC20";
  AssetStandard["ERC721"] = "ERC721";
  AssetStandard["ERC1155"] = "ERC1155";
  return AssetStandard;
}({});
const NFT_STANDARDS = exports.NFT_STANDARDS = [AssetStandard.ERC721, AssetStandard.ERC1155];

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\types\\send.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\utils\\account.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Cutils%5Caccount.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isSolanaAccountForSend = exports.isEVMAccountForSend = exports.isBitcoinAccountForSend = void 0;
/**
 * Checks if an account is EVM-compatible for send operations.
 * This includes regular EVM accounts, hardware wallets, and private key accounts.
 *
 * @param account - The internal account object to check
 * @returns true if the account can be used for EVM transactions
 */
const isEVMAccountForSend = account => {
  var _account$scopes;
  if (!account) {
    return false;
  }
  if (account.type.startsWith('eip155:')) {
    return true;
  }
  if ((_account$scopes = account.scopes) !== null && _account$scopes !== void 0 && _account$scopes.some(scope => scope.startsWith('eip155:'))) {
    return true;
  }
  return false;
};

/**
 * Checks if an account is Solana-compatible for send operations.
 *
 * @param account - The internal account object to check
 * @returns true if the account can be used for Solana transactions
 */
exports.isEVMAccountForSend = isEVMAccountForSend;
const isSolanaAccountForSend = account => {
  var _account$scopes2;
  if (!account) {
    return false;
  }
  if (account.type.startsWith('solana:')) {
    return true;
  }
  if ((_account$scopes2 = account.scopes) !== null && _account$scopes2 !== void 0 && _account$scopes2.some(scope => scope.startsWith('solana:'))) {
    return true;
  }
  return false;
};

/**
 * Checks if an account is Bitcoin-compatible for send operations.
 *
 * @param account - The internal account object to check
 * @returns true if the account can be used for Bitcoin transactions
 */
exports.isSolanaAccountForSend = isSolanaAccountForSend;
const isBitcoinAccountForSend = account => {
  var _account$scopes3;
  if (!account) {
    return false;
  }
  if (account.type.startsWith('bip122:')) {
    return true;
  }
  if ((_account$scopes3 = account.scopes) !== null && _account$scopes3 !== void 0 && _account$scopes3.some(scope => scope.startsWith('bip122:'))) {
    return true;
  }
  return false;
};
exports.isBitcoinAccountForSend = isBitcoinAccountForSend;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\utils\\account.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\utils\\index.ts", {"./confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\utils\\confirm.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Cutils%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _confirm = require("./confirm");
Object.keys(_confirm).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _confirm[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _confirm[key];
    }
  });
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\utils\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\utils\\multichain-snaps.ts", {"../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Cutils%5Cmultichain-snaps.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sendMultichainTransactionForReview = sendMultichainTransactionForReview;
exports.validateAmountMultichain = validateAmountMultichain;
var _snapsUtils = require("@metamask/snaps-utils");
var _actions = require("../../../store/actions");
async function sendMultichainTransactionForReview(fromAccount, params) {
  var _fromAccount$metadata;
  return await (0, _actions.handleSnapRequest)({
    snapId: (_fromAccount$metadata = fromAccount.metadata) === null || _fromAccount$metadata === void 0 || (_fromAccount$metadata = _fromAccount$metadata.snap) === null || _fromAccount$metadata === void 0 ? void 0 : _fromAccount$metadata.id,
    origin: 'metamask',
    handler: _snapsUtils.HandlerType.OnClientRequest,
    request: {
      method: 'confirmSend',
      params
    }
  });
}
async function validateAmountMultichain(fromAccount, params) {
  var _fromAccount$metadata2;
  return await (0, _actions.handleSnapRequest)({
    snapId: (_fromAccount$metadata2 = fromAccount.metadata) === null || _fromAccount$metadata2 === void 0 || (_fromAccount$metadata2 = _fromAccount$metadata2.snap) === null || _fromAccount$metadata2 === void 0 ? void 0 : _fromAccount$metadata2.id,
    origin: 'metamask',
    handler: _snapsUtils.HandlerType.OnClientRequest,
    request: {
      method: 'onAmountInput',
      params
    }
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\utils\\multichain-snaps.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\utils\\send.ts", {"../../../../shared/modules/Numeric":"D:\\code\\v\\metamask-extension\\shared\\modules\\Numeric.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../send-legacy/send.utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\send-legacy\\send.utils.js","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","ethereumjs-util":"D:\\code\\v\\metamask-extension\\node_modules\\ethereumjs-util\\dist.browser\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Cutils%5Csend.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addLeadingZeroIfNeeded = void 0;
exports.convertedCurrency = convertedCurrency;
exports.formatToFixedDecimals = formatToFixedDecimals;
exports.getLayer1GasFees = exports.getFractionLength = exports.fromTokenMinimalUnitsNumeric = exports.fromTokenMinimalUnitsHexNumeric = exports.fromTokenMinimalUnits = exports.fromTokenMinUnitsNumeric = void 0;
exports.isValidPositiveNumericString = isValidPositiveNumericString;
exports.trimTrailingZeros = exports.toTokenMinimalUnitNumeric = exports.toTokenMinimalUnit = exports.submitEvmTransaction = exports.removeAdditionalDecimalPlaces = exports.prepareEVMTransaction = exports.navigateToSendRoute = void 0;
var _controllerUtils = require("@metamask/controller-utils");
var _transactionController = require("@metamask/transaction-controller");
var _ethereumjsUtil = require("ethereumjs-util");
var _Numeric = require("../../../../shared/modules/Numeric");
var _actions = require("../../../store/actions");
var _send = require("../send-legacy/send.utils");
var _routes = require("../../../helpers/constants/routes");
const trimTrailingZeros = numStr => {
  return numStr.replace(/(\.\d*?[1-9])0+$/gu, '$1').replace(/\.0*$/u, '');
};
exports.trimTrailingZeros = trimTrailingZeros;
const removeAdditionalDecimalPlaces = (value, decimals) => {
  if (!value) {
    return undefined;
  }
  const decimalValue = parseInt((decimals === null || decimals === void 0 ? void 0 : decimals.toString()) ?? '0', 10);
  const result = value.replace(/^-/u, '').split('.');
  const intPart = result[0];
  let fracPart = result[1] ?? '';
  if (fracPart.length > decimalValue) {
    fracPart = fracPart.slice(0, decimalValue);
  }
  return fracPart ? `${intPart}.${fracPart}` : intPart;
};
exports.removeAdditionalDecimalPlaces = removeAdditionalDecimalPlaces;
const fromTokenMinUnitsNumeric = (value, base, decimals) => {
  const decimalValue = parseInt((decimals === null || decimals === void 0 ? void 0 : decimals.toString()) ?? '0', 10);
  const multiplier = Math.pow(10, Number(decimalValue));
  return new _Numeric.Numeric(value, base).times(multiplier, 10);
};
exports.fromTokenMinUnitsNumeric = fromTokenMinUnitsNumeric;
const fromTokenMinimalUnitsNumeric = (value, decimals) => fromTokenMinUnitsNumeric(value, 10, decimals);
exports.fromTokenMinimalUnitsNumeric = fromTokenMinimalUnitsNumeric;
const fromTokenMinimalUnits = (value, decimals) => (0, _ethereumjsUtil.addHexPrefix)(fromTokenMinimalUnitsNumeric(value, decimals).toBase(16).toString());
exports.fromTokenMinimalUnits = fromTokenMinimalUnits;
const fromTokenMinimalUnitsHexNumeric = (value, decimals) => fromTokenMinUnitsNumeric(value, 16, decimals);
exports.fromTokenMinimalUnitsHexNumeric = fromTokenMinimalUnitsHexNumeric;
const toTokenMinimalUnitNumeric = (value, decimals = 0, base) => {
  const decimalValue = parseInt((decimals === null || decimals === void 0 ? void 0 : decimals.toString()) ?? '0', 10);
  const multiplier = Math.pow(10, Number(decimalValue));
  return new _Numeric.Numeric(value, base ?? 16).divide(multiplier, 10);
};
exports.toTokenMinimalUnitNumeric = toTokenMinimalUnitNumeric;
const toTokenMinimalUnit = (value, decimals = 0, base) => {
  return removeAdditionalDecimalPlaces(toTokenMinimalUnitNumeric(value, decimals, base).toBase(10).toString(), decimals);
};
exports.toTokenMinimalUnit = toTokenMinimalUnit;
function formatToFixedDecimals(value, decimalsToShow = 5, trimTrailingZerosEnabled = true) {
  if (!value || !isValidPositiveNumericString(value)) {
    return '0';
  }
  const val = new _Numeric.Numeric(value, 10);
  if (val.isZero()) {
    return '0';
  }
  let decimals = parseInt(decimalsToShow === null || decimalsToShow === void 0 ? void 0 : decimalsToShow.toString(), 10);
  decimals = decimals < 5 ? decimals : 5;
  const minVal = 1 / Math.pow(10, decimals);
  if (val.lessThan(new _Numeric.Numeric(minVal, 10))) {
    return `< ${minVal}`;
  }
  const strValueArr = val.toString().split('.');
  const intPart = strValueArr[0];
  let fracPart = strValueArr[1] ?? '';
  if (fracPart.length > decimals) {
    fracPart = fracPart.slice(0, decimals);
  } else {
    fracPart = fracPart.padEnd(decimals, '0');
  }
  if (!fracPart) {
    return intPart;
  }
  return trimTrailingZerosEnabled ? trimTrailingZeros(`${intPart}.${fracPart}`) : `${intPart}.${fracPart}`;
}
const prepareEVMTransaction = (asset, transactionParams, hexData = '0x') => {
  const {
    from,
    to,
    value
  } = transactionParams;
  const trxnParams = {
    from
  };
  const tokenValue = asset.tokenId ? value : fromTokenMinimalUnits(value ?? '0', asset.decimals);

  // Native token
  if (asset.isNative) {
    trxnParams.data = hexData;
    trxnParams.to = to;
    trxnParams.value = tokenValue;
    return trxnParams;
  }

  // ERC1155 token
  if (asset.standard === _controllerUtils.ERC1155) {
    trxnParams.data = (0, _send.generateERC1155TransferData)({
      fromAddress: from,
      toAddress: to,
      tokenId: asset.tokenId,
      amount: tokenValue
    });
    trxnParams.to = asset.address;
    trxnParams.value = '0x0';
    return trxnParams;
  }

  // ERC721 token
  if (asset.standard === _controllerUtils.ERC721) {
    trxnParams.data = (0, _send.generateERC721TransferData)({
      fromAddress: from,
      toAddress: to,
      tokenId: asset.tokenId
    });
    trxnParams.to = asset.address;
    trxnParams.value = '0x0';
    return trxnParams;
  }

  // ERC20 token
  trxnParams.data = (0, _send.generateERC20TransferData)({
    toAddress: to,
    amount: tokenValue,
    sendToken: asset
  });
  trxnParams.to = asset.address;
  trxnParams.value = '0x0';
  return trxnParams;
};
exports.prepareEVMTransaction = prepareEVMTransaction;
const submitEvmTransaction = async ({
  asset,
  chainId,
  from,
  hexData,
  to,
  value
}) => {
  const trxnParams = prepareEVMTransaction(asset, {
    from,
    to,
    value
  }, hexData);
  const networkClientId = await (0, _actions.findNetworkClientIdByChainId)(chainId);
  let transactionType;
  if (asset.isNative) {
    transactionType = _transactionController.TransactionType.simpleSend;
  } else if (asset.standard === _controllerUtils.ERC20) {
    transactionType = _transactionController.TransactionType.tokenMethodTransfer;
  } else if (asset.standard === _controllerUtils.ERC721) {
    transactionType = _transactionController.TransactionType.tokenMethodTransferFrom;
  } else if (asset.standard === _controllerUtils.ERC1155) {
    transactionType = _transactionController.TransactionType.tokenMethodSafeTransferFrom;
  }
  return (0, _actions.addTransactionAndRouteToConfirmationPage)(trxnParams, {
    networkClientId,
    type: transactionType
  });
};
exports.submitEvmTransaction = submitEvmTransaction;
const getLayer1GasFees = async ({
  asset,
  chainId,
  from,
  value
}) => {
  return await (0, _actions.getLayer1GasFeeValue)({
    chainId,
    transactionParams: {
      value: fromTokenMinimalUnits(value, asset.decimals),
      from
    }
  });
};
exports.getLayer1GasFees = getLayer1GasFees;
function isValidPositiveNumericString(str) {
  const decimalRegex = /^(\d+(\.\d+)?|\.\d+)$/u;
  if (!decimalRegex.test(str)) {
    return false;
  }
  try {
    const num = new _Numeric.Numeric(str, 10);
    return num.greaterThanOrEqualTo(new _Numeric.Numeric('0', 10));
  } catch (err) {
    return false;
  }
}
function convertedCurrency(value, conversionRate, decimals) {
  if (!isValidPositiveNumericString(value)) {
    return undefined;
  }
  return trimTrailingZeros(removeAdditionalDecimalPlaces(new _Numeric.Numeric(value, 10).applyConversionRate(conversionRate).toString(), decimals) ?? '');
}
const navigateToSendRoute = (history, isSendRedesignEnabled, params) => {
  if (isSendRedesignEnabled) {
    if (params) {
      const queryParams = new URLSearchParams();
      const {
        address,
        chainId
      } = params;
      if (address) {
        queryParams.append('asset', address);
      }
      if (chainId) {
        queryParams.append('chainId', chainId);
      }
      history.push(`${_routes.SEND_ROUTE}/amount-recipient?${queryParams.toString()}`);
    } else {
      history.push(`${_routes.SEND_ROUTE}/asset`);
    }
  } else {
    history.push(_routes.SEND_ROUTE);
  }
};
exports.navigateToSendRoute = navigateToSendRoute;
const getFractionLength = value => {
  const result = value.replace(/^-/u, '').split('.');
  const fracPart = result[1] ?? '';
  return fracPart.length;
};
exports.getFractionLength = getFractionLength;
const addLeadingZeroIfNeeded = value => {
  if (!value) {
    return value;
  }
  const result = value.replace(/^-/u, '').split('.');
  const wholePart = result[0];
  const fracPart = result[1] ?? '';
  if (!wholePart.length) {
    return `0.${fracPart}`;
  }
  return value;
};
exports.addLeadingZeroIfNeeded = addLeadingZeroIfNeeded;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\utils\\send.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\utils\\sendValidations.ts", {"../../../../shared/lib/multichain/accounts":"D:\\code\\v\\metamask-extension\\shared\\lib\\multichain\\accounts.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","unicode-confusables":"D:\\code\\v\\metamask-extension\\node_modules\\unicode-confusables\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Cutils%5CsendValidations.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateSolanaAddress = exports.validateEvmHexAddress = exports.validateBtcAddress = exports.findConfusablesInRecipient = void 0;
var _unicodeConfusables = require("unicode-confusables");
var _accounts = require("../../../../shared/lib/multichain/accounts");
var _actions = require("../../../store/actions");
// Unicode confusables is not typed
// eslint-disable-next-line @typescript-eslint/ban-ts-comment
// @ts-ignore

const findConfusablesInRecipient = address => {
  const confusableCollection = (0, _unicodeConfusables.confusables)(address);

  // First filter out duplicate points, then filter by similarTo
  const uniquePoints = new Set();
  const confusableCharacters = confusableCollection.filter(({
    point
  }) => {
    if (uniquePoints.has(point)) {
      return false;
    }
    uniquePoints.add(point);
    return true;
  }).filter(({
    similarTo
  }) => similarTo !== undefined);
  if (confusableCharacters.length) {
    const hasZeroWidthCharacters = confusableCharacters.some(({
      similarTo
    }) => similarTo === '');
    if (hasZeroWidthCharacters) {
      return {
        error: 'invalidAddress',
        warning: 'confusableZeroWidthUnicode'
      };
    }
    return {
      confusableCharacters
    };
  }
  return {};
};
exports.findConfusablesInRecipient = findConfusablesInRecipient;
const LOWER_CASED_BURN_ADDRESSES = ['0x0000000000000000000000000000000000000000', '0x000000000000000000000000000000000000dead'];
const validateEvmHexAddress = async (address, chainId, assetAddress) => {
  if (LOWER_CASED_BURN_ADDRESSES.includes(address.toLowerCase())) {
    return {
      error: 'invalidAddress'
    };
  }
  if ((address === null || address === void 0 ? void 0 : address.toLowerCase()) === (assetAddress === null || assetAddress === void 0 ? void 0 : assetAddress.toLowerCase())) {
    return {
      error: 'contractAddressError'
    };
  }
  if (chainId) {
    const tokenDetails = await (0, _actions.getTokenStandardAndDetailsByChain)(address, undefined, undefined, chainId);
    if (tokenDetails !== null && tokenDetails !== void 0 && tokenDetails.standard) {
      return {
        error: 'tokenContractError'
      };
    }
  }
  return {};
};

// Common Solana burn addresses - addresses commonly used as burn destinations
exports.validateEvmHexAddress = validateEvmHexAddress;
const SOLANA_BURN_ADDRESSES = ['1nc1nerator11111111111111111111111111111111', 'So11111111111111111111111111111111111111112'];
const validateSolanaAddress = address => {
  if (SOLANA_BURN_ADDRESSES.includes(address)) {
    return {
      error: 'invalidAddress'
    };
  }
  if (!(0, _accounts.isSolanaAddress)(address)) {
    return {
      error: 'invalidAddress'
    };
  }
  return {};
};
exports.validateSolanaAddress = validateSolanaAddress;
const validateBtcAddress = address => {
  if (!(0, _accounts.isBtcMainnetAddress)(address)) {
    return {
      error: 'invalidAddress'
    };
  }
  return {};
};
exports.validateBtcAddress = validateBtcAddress;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\utils\\sendValidations.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\utils\\token.ts", {"../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Cutils%5Ctoken.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseTokenDetailDecimals = exports.memoizedGetTokenStandardAndDetails = exports.fetchErc20Decimals = exports.ERC20_DEFAULT_DECIMALS = void 0;
var _lodash = require("lodash");
var _actions = require("../../../store/actions");
const ERC20_DEFAULT_DECIMALS = exports.ERC20_DEFAULT_DECIMALS = 18;
const parseTokenDetailDecimals = decStr => {
  if (!decStr) {
    return undefined;
  }
  for (const radix of [10, 16]) {
    const parsedDec = parseInt(decStr, radix);
    if (isFinite(parsedDec)) {
      return parsedDec;
    }
  }
  return undefined;
};
exports.parseTokenDetailDecimals = parseTokenDetailDecimals;
const memoizedGetTokenStandardAndDetails = exports.memoizedGetTokenStandardAndDetails = (0, _lodash.memoize)(async (tokenAddress, userAddress, tokenId) => {
  try {
    if (!tokenAddress) {
      return {};
    }
    return await (0, _actions.getTokenStandardAndDetails)(tokenAddress, userAddress, tokenId);
  } catch {
    return {};
  }
});

/**
 * Fetches the decimals for the given token address.
 *
 * @param address - The ethereum token contract address. It is expected to be in hex format.
 * @param chainId - ChainId on which we need to check token. It is expected to be in hex format.
 * We currently accept strings since we have a patch that accepts a custom string
 * {@see .yarn/patches/@metamask-eth-json-rpc-middleware-npm-14.0.1-b6c2ccbe8c.patch}
 */
const fetchErc20Decimals = async (address, chainId) => {
  try {
    const result = await (0, _actions.getTokenStandardAndDetailsByChain)(address, undefined, undefined, chainId);
    const {
      decimals: decStr
    } = result;
    const decimals = parseTokenDetailDecimals(decStr);
    return decimals ?? ERC20_DEFAULT_DECIMALS;
  } catch {
    return ERC20_DEFAULT_DECIMALS;
  }
};
exports.fetchErc20Decimals = fetchErc20Decimals;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\utils\\token.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\connected-accounts\\connected-accounts.component.js", {"../../components/app/connected-accounts-list":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\connected-accounts-list\\index.js","../../components/app/connected-accounts-permissions":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\connected-accounts-permissions\\index.js","../../components/app/connected-sites-list/connected-snaps":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\connected-sites-list\\connected-snaps.js","../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../components/ui/popover":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\popover\\index.js","../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconnected-accounts%5Cconnected-accounts.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ConnectedAccounts;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _snapsUtils = require("@metamask/snaps-utils");
var _popover = _interopRequireDefault(require("../../components/ui/popover"));
var _connectedAccountsList = _interopRequireDefault(require("../../components/app/connected-accounts-list"));
var _connectedAccountsPermissions = _interopRequireDefault(require("../../components/app/connected-accounts-permissions"));
var _util = require("../../helpers/utils/util");
var _useI18nContext = require("../../hooks/useI18nContext");
var _connectedSnaps = _interopRequireDefault(require("../../components/app/connected-sites-list/connected-snaps"));
var _designSystem = require("../../helpers/constants/design-system");
var _componentLibrary = require("../../components/component-library");
var _selectors = require("../../selectors");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function ConnectedAccounts({
  accountToConnect = null,
  activeTabOrigin,
  isActiveTabExtension,
  connectAccount,
  connectedAccounts,
  history,
  mostRecentOverviewPage,
  permissions = undefined,
  selectedAddress,
  removePermittedAccount,
  setSelectedAccount,
  subjectMetadata,
  originOfActiveTab,
  permissionSubjects
}) {
  var _permissionSubjects$o, _permissionSubjects$o2, _permissionSubjects$o3;
  const t = (0, _useI18nContext.useI18nContext)();
  const internalAccounts = (0, _reactRedux.useSelector)(_selectors.getInternalAccounts);
  const connectedSubjectsMetadata = subjectMetadata[originOfActiveTab];
  const subjectHasSnaps = ((_permissionSubjects$o = permissionSubjects[originOfActiveTab]) === null || _permissionSubjects$o === void 0 ? void 0 : _permissionSubjects$o.origin) === (connectedSubjectsMetadata === null || connectedSubjectsMetadata === void 0 ? void 0 : connectedSubjectsMetadata.origin) && ((_permissionSubjects$o2 = permissionSubjects[originOfActiveTab]) === null || _permissionSubjects$o2 === void 0 ? void 0 : _permissionSubjects$o2.permissions[_snapsUtils.WALLET_SNAP_PERMISSION_KEY]);
  const connectedSnaps = subjectHasSnaps && Object.keys((_permissionSubjects$o3 = permissionSubjects[originOfActiveTab]) === null || _permissionSubjects$o3 === void 0 || (_permissionSubjects$o3 = _permissionSubjects$o3.permissions) === null || _permissionSubjects$o3 === void 0 || (_permissionSubjects$o3 = _permissionSubjects$o3.wallet_snap) === null || _permissionSubjects$o3 === void 0 || (_permissionSubjects$o3 = _permissionSubjects$o3.caveats[0]) === null || _permissionSubjects$o3 === void 0 ? void 0 : _permissionSubjects$o3.value);
  const connectedSnapsMetaData = subjectHasSnaps && (connectedSnaps === null || connectedSnaps === void 0 ? void 0 : connectedSnaps.map(sub => subjectMetadata[sub]));
  const connectedAccountsDescription = connectedAccounts.length > 0 ? t('connectedAccountsDescriptionPlural', [connectedAccounts.length]) : t('connectedAccountsDescriptionSingular');
  let subtitle;
  if (connectedAccounts.length && !subjectHasSnaps) {
    subtitle = connectedAccountsDescription;
  } else if (subjectHasSnaps && !connectedAccounts.length) {
    subtitle = t('connectedSnapAndNoAccountDescription');
  } else if (connectedAccounts && subjectHasSnaps) {
    subtitle = null;
  } else {
    subtitle = t('connectedAccountsEmptyDescription');
  }
  return /*#__PURE__*/_react.default.createElement(_popover.default, {
    title: isActiveTabExtension ? t('currentExtension') : (0, _util.getURLHost)(activeTabOrigin),
    headerProps: {
      paddingLeft: 4,
      paddingRight: 4
    },
    subtitle: subtitle,
    onClose: () => history.push(mostRecentOverviewPage),
    footerClassName: "connected-accounts__footer",
    ConnectedAccountsPermissions: {},
    footer: connectedAccounts.length > 0 &&
    /*#__PURE__*/
    // show permissions only for connected accounts not snaps
    _react.default.createElement(_connectedAccountsPermissions.default, {
      permissions: permissions
    })
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, connectedAccounts.length > 0 ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginLeft: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: _designSystem.TextColor.textAlternative
  }, t('accountsConnected'), "\xA0(", connectedAccounts.length, ")")) : null, /*#__PURE__*/_react.default.createElement(_connectedAccountsList.default, {
    accountToConnect: accountToConnect,
    connectAccount: connectAccount,
    connectedAccounts: connectedAccounts,
    selectedAddress: selectedAddress,
    removePermittedAccount: removePermittedAccount,
    setSelectedAddress: address => {
      const {
        id: accountId
      } = internalAccounts.find(internalAccount => internalAccount.address === address);
      setSelectedAccount(accountId);
    },
    shouldRenderListOptions: true
  })), subjectHasSnaps && connectedSnapsMetaData.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginLeft: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: _designSystem.TextColor.textAlternative
  }, t('snapsConnected'), "\xA0(", connectedSnaps.length, ")")), /*#__PURE__*/_react.default.createElement(_connectedSnaps.default, {
    connectedSubjects: connectedSnapsMetaData
  })));
}
ConnectedAccounts.propTypes = {
  accountToConnect: _propTypes.default.object,
  activeTabOrigin: _propTypes.default.string.isRequired,
  connectAccount: _propTypes.default.func.isRequired,
  connectedAccounts: _propTypes.default.array.isRequired,
  mostRecentOverviewPage: _propTypes.default.string.isRequired,
  permissions: _propTypes.default.array,
  isActiveTabExtension: _propTypes.default.bool.isRequired,
  selectedAddress: _propTypes.default.string.isRequired,
  removePermittedAccount: _propTypes.default.func.isRequired,
  setSelectedAccount: _propTypes.default.func.isRequired,
  history: _propTypes.default.object.isRequired,
  subjectMetadata: _propTypes.default.arrayOf(_propTypes.default.object).isRequired,
  originOfActiveTab: _propTypes.default.string,
  permissionSubjects: _propTypes.default.object
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\connected-accounts\\connected-accounts.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\connected-accounts\\connected-accounts.container.js", {"../../ducks/history/history":"D:\\code\\v\\metamask-extension\\ui\\ducks\\history\\history.js","../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./connected-accounts.component":"D:\\code\\v\\metamask-extension\\ui\\pages\\connected-accounts\\connected-accounts.component.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconnected-accounts%5Cconnected-accounts.container.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactRedux = require("react-redux");
var _selectors = require("../../selectors");
var _util = require("../../helpers/utils/util");
var _actions = require("../../store/actions");
var _history = require("../../ducks/history/history");
var _connectedAccounts = _interopRequireDefault(require("./connected-accounts.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const mapStateToProps = state => {
  var _internalAccounts$fin;
  const {
    activeTab
  } = state;
  const accountToConnect = (0, _selectors.getAccountToConnectToActiveTab)(state);
  const connectedAccounts = (0, _selectors.getOrderedConnectedAccountsForActiveTab)(state);
  const internalAccounts = (0, _selectors.getInternalAccounts)(state);
  // Temporary fix until https://github.com/MetaMask/metamask-extension/pull/21553
  const internalAccountsMap = new Map(internalAccounts.map(acc => [acc.address, acc]));
  const connectedAccountsWithName = connectedAccounts.map(account => {
    var _internalAccountsMap$;
    return {
      ...account,
      name: (_internalAccountsMap$ = internalAccountsMap.get(account.address)) === null || _internalAccountsMap$ === void 0 ? void 0 : _internalAccountsMap$.metadata.name
    };
  });
  const accountToConnectWithName = accountToConnect && {
    ...accountToConnect,
    name: (_internalAccounts$fin = internalAccounts.find(internalAccount => internalAccount.address === (accountToConnect === null || accountToConnect === void 0 ? void 0 : accountToConnect.address))) === null || _internalAccounts$fin === void 0 ? void 0 : _internalAccounts$fin.metadata.name
  };
  const permissions = (0, _selectors.getPermissionsForActiveTab)(state);
  const {
    address: selectedAddress
  } = (0, _selectors.getSelectedInternalAccount)(state);
  const subjectMetadata = (0, _selectors.getSubjectMetadata)(state);
  const originOfActiveTab = (0, _selectors.getOriginOfCurrentTab)(state);
  const permissionSubjects = (0, _selectors.getPermissionSubjects)(state);
  const isActiveTabExtension = (0, _util.isExtensionUrl)(activeTab);
  return {
    accountToConnect: accountToConnectWithName,
    isActiveTabExtension,
    activeTabOrigin: activeTab.origin,
    connectedAccounts: connectedAccountsWithName,
    mostRecentOverviewPage: (0, _history.getMostRecentOverviewPage)(state),
    permissions,
    selectedAddress,
    subjectMetadata,
    originOfActiveTab,
    permissionSubjects
  };
};
const mapDispatchToProps = dispatch => {
  return {
    addPermittedAccount: (origin, address) => dispatch((0, _actions.addPermittedAccount)(origin, address)),
    removePermittedAccount: (origin, address) => dispatch((0, _actions.removePermittedAccount)(origin, address)),
    setSelectedAccount: accountId => dispatch((0, _actions.setSelectedInternalAccount)(accountId))
  };
};
const mergeProps = (stateProps, dispatchProps, ownProps) => {
  const {
    activeTabOrigin
  } = stateProps;
  return {
    ...ownProps,
    ...stateProps,
    ...dispatchProps,
    connectAccount: address => dispatchProps.addPermittedAccount(activeTabOrigin, address),
    removePermittedAccount: address => dispatchProps.removePermittedAccount(activeTabOrigin, address)
  };
};
var _default = exports.default = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps, mergeProps)(_connectedAccounts.default);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\connected-accounts\\connected-accounts.container.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\connected-accounts\\index.js", {"./connected-accounts.container":"D:\\code\\v\\metamask-extension\\ui\\pages\\connected-accounts\\connected-accounts.container.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconnected-accounts%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _connectedAccounts.default;
  }
});
var _connectedAccounts = _interopRequireDefault(require("./connected-accounts.container"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\connected-accounts\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\connected-sites\\connected-sites.component.js", {"../../components/app/connected-sites-list":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\connected-sites-list\\index.js","../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../components/ui/popover/popover.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\popover\\popover.component.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconnected-sites%5Cconnected-sites.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _connectedSitesList = _interopRequireDefault(require("../../components/app/connected-sites-list"));
var _popover = _interopRequireDefault(require("../../components/ui/popover/popover.component"));
var _componentLibrary = require("../../components/component-library");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class ConnectedSites extends _react.Component {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "state", {
      sitePendingDisconnect: null
    });
    _defineProperty(this, "setPendingDisconnect", subjectKey => {
      this.setState({
        sitePendingDisconnect: {
          subjectKey
        }
      });
    });
    _defineProperty(this, "clearPendingDisconnect", () => {
      this.setState({
        sitePendingDisconnect: null
      });
    });
    _defineProperty(this, "disconnectAccount", () => {
      const {
        disconnectAccount
      } = this.props;
      const {
        sitePendingDisconnect
      } = this.state;
      disconnectAccount(sitePendingDisconnect.subjectKey);
      this.clearPendingDisconnect();
    });
    _defineProperty(this, "disconnectAllAccounts", () => {
      const {
        disconnectAllAccounts
      } = this.props;
      const {
        sitePendingDisconnect
      } = this.state;
      disconnectAllAccounts(sitePendingDisconnect.subjectKey);
      this.clearPendingDisconnect();
    });
  }
  componentDidMount() {
    const {
      getOpenMetamaskTabsIds
    } = this.props;
    getOpenMetamaskTabsIds();
  }
  renderConnectedSitesList() {
    return /*#__PURE__*/_react.default.createElement(_connectedSitesList.default, {
      connectedSubjects: this.props.connectedSubjects,
      onDisconnect: this.setPendingDisconnect
    });
  }
  renderConnectedSitesPopover() {
    const {
      accountLabel,
      closePopover,
      connectedSubjects,
      tabToConnect,
      requestAccountsPermission
    } = this.props;
    const {
      t
    } = this.context;
    return /*#__PURE__*/_react.default.createElement(_popover.default, {
      className: "connected-sites",
      title: t('connectedSites'),
      subtitle: connectedSubjects.length ? t('connectedSitesDescription', [accountLabel]) : t('connectedSitesEmptyDescription', [accountLabel]),
      onClose: closePopover,
      footer: tabToConnect ? /*#__PURE__*/_react.default.createElement("a", {
        className: "connected-sites__text-button",
        onClick: requestAccountsPermission
      }, t('connectManually')) : null,
      footerClassName: "connected-sites__add-site-manually"
    }, this.renderConnectedSitesList());
  }
  renderDisconnectPopover() {
    const {
      closePopover,
      permittedAccountsByOrigin
    } = this.props;
    const {
      t
    } = this.context;
    const {
      sitePendingDisconnect: {
        subjectKey
      }
    } = this.state;
    const numPermittedAccounts = permittedAccountsByOrigin[subjectKey].length;
    return /*#__PURE__*/_react.default.createElement(_popover.default, {
      className: "connected-sites",
      title: t('disconnectPrompt', [subjectKey]),
      subtitle: t('disconnectAllAccountsConfirmationDescription'),
      onClose: closePopover,
      footer: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
        className: "connected-sites__footer-row"
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
        variant: _componentLibrary.ButtonVariant.Secondary,
        onClick: this.clearPendingDisconnect,
        block: true
      }, t('cancel')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
        variant: _componentLibrary.ButtonVariant.Primary,
        onClick: this.disconnectAccount,
        block: true
      }, t('disconnect'))), numPermittedAccounts > 1 ? /*#__PURE__*/_react.default.createElement("div", {
        className: "connected-sites__footer-row"
      }, /*#__PURE__*/_react.default.createElement("a", {
        className: "connected-sites__text-button",
        onClick: this.disconnectAllAccounts
      }, t('disconnectAllAccounts'))) : null),
      footerClassName: "connected-sites__confirmation"
    });
  }
  render() {
    const {
      sitePendingDisconnect
    } = this.state;
    return sitePendingDisconnect ? this.renderDisconnectPopover() : this.renderConnectedSitesPopover();
  }
}
exports.default = ConnectedSites;
_defineProperty(ConnectedSites, "contextTypes", {
  t: _propTypes.default.func
});
_defineProperty(ConnectedSites, "defaultProps", {
  tabToConnect: null
});
_defineProperty(ConnectedSites, "propTypes", {
  accountLabel: _propTypes.default.string.isRequired,
  closePopover: _propTypes.default.func.isRequired,
  connectedSubjects: _propTypes.default.arrayOf(_propTypes.default.object).isRequired,
  disconnectAllAccounts: _propTypes.default.func.isRequired,
  disconnectAccount: _propTypes.default.func.isRequired,
  getOpenMetamaskTabsIds: _propTypes.default.func.isRequired,
  permittedAccountsByOrigin: _propTypes.default.objectOf(_propTypes.default.arrayOf(_propTypes.default.string)).isRequired,
  tabToConnect: _propTypes.default.object,
  requestAccountsPermission: _propTypes.default.func.isRequired
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\connected-sites\\connected-sites.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\connected-sites\\connected-sites.container.js", {"../../ducks/history/history":"D:\\code\\v\\metamask-extension\\ui\\ducks\\history\\history.js","../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./connected-sites.component":"D:\\code\\v\\metamask-extension\\ui\\pages\\connected-sites\\connected-sites.component.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconnected-sites%5Cconnected-sites.container.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactRedux = require("react-redux");
var _actions = require("../../store/actions");
var _selectors = require("../../selectors");
var _routes = require("../../helpers/constants/routes");
var _history = require("../../ducks/history/history");
var _connectedSites = _interopRequireDefault(require("./connected-sites.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const mapStateToProps = state => {
  var _permittedAccountsByO;
  const {
    openMetaMaskTabs
  } = state.appState;
  const {
    id
  } = state.activeTab;
  const connectedSubjects = (0, _selectors.getConnectedSubjectsForSelectedAddress)(state);
  const originOfCurrentTab = (0, _selectors.getOriginOfCurrentTab)(state);
  const permittedAccountsByOrigin = (0, _selectors.getPermittedAccountsByOrigin)(state);
  const {
    address: selectedAddress
  } = (0, _selectors.getSelectedInternalAccount)(state);
  const currentTabHasNoAccounts = !((_permittedAccountsByO = permittedAccountsByOrigin[originOfCurrentTab]) !== null && _permittedAccountsByO !== void 0 && _permittedAccountsByO.length);
  let tabToConnect;
  if (originOfCurrentTab && currentTabHasNoAccounts && !openMetaMaskTabs[id]) {
    tabToConnect = {
      origin: originOfCurrentTab
    };
  }
  return {
    accountLabel: (0, _selectors.getSelectedInternalAccount)(state).metadata.name,
    connectedSubjects,
    subjects: (0, _selectors.getPermissionSubjects)(state),
    mostRecentOverviewPage: (0, _history.getMostRecentOverviewPage)(state),
    permittedAccountsByOrigin,
    selectedAddress,
    tabToConnect
  };
};
const mapDispatchToProps = dispatch => {
  return {
    getOpenMetamaskTabsIds: () => dispatch((0, _actions.getOpenMetamaskTabsIds)()),
    disconnectAccount: (subjectKey, address) => {
      dispatch((0, _actions.removePermittedAccount)(subjectKey, address));
    },
    disconnectAllAccounts: (subjectKey, subject) => {
      const permissionMethodNames = Object.values(subject.permissions).map(({
        parentCapability
      }) => parentCapability);
      dispatch((0, _actions.removePermissionsFor)({
        [subjectKey]: permissionMethodNames
      }));
    },
    requestAccountsAndChainPermissionsWithId: origin => dispatch((0, _actions.requestAccountsAndChainPermissionsWithId)(origin))
  };
};
const mergeProps = (stateProps, dispatchProps, ownProps) => {
  const {
    connectedSubjects,
    subjects,
    mostRecentOverviewPage,
    selectedAddress,
    tabToConnect
  } = stateProps;
  const {
    disconnectAccount,
    disconnectAllAccounts,
    // eslint-disable-next-line no-shadow
    requestAccountsAndChainPermissionsWithId
  } = dispatchProps;
  const {
    history
  } = ownProps;
  const closePopover = () => history.push(mostRecentOverviewPage);
  return {
    ...ownProps,
    ...stateProps,
    ...dispatchProps,
    closePopover,
    disconnectAccount: subjectKey => {
      disconnectAccount(subjectKey, selectedAddress);
      if (connectedSubjects.length === 1) {
        closePopover();
      }
    },
    disconnectAllAccounts: subjectKey => {
      disconnectAllAccounts(subjectKey, subjects[subjectKey]);
      if (connectedSubjects.length === 1) {
        closePopover();
      }
    },
    requestAccountsPermission: async () => {
      const id = await requestAccountsAndChainPermissionsWithId(tabToConnect.origin);
      history.push(`${_routes.CONNECT_ROUTE}/${id}`);
    }
  };
};
var _default = exports.default = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps, mergeProps)(_connectedSites.default);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\connected-sites\\connected-sites.container.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\connected-sites\\index.js", {"./connected-sites.container":"D:\\code\\v\\metamask-extension\\ui\\pages\\connected-sites\\connected-sites.container.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconnected-sites%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _connectedSites.default;
  }
});
var _connectedSites = _interopRequireDefault(require("./connected-sites.container"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\connected-sites\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\core\\hyperliquid-referral-consent\\hyperliquid-referral-consent.tsx", {"../../../../shared/lib/ui-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\ui-utils.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Ccore%5Chyperliquid-referral-consent%5Chyperliquid-referral-consent.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HyperliquidReferralConsent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _designSystemReact = require("@metamask/design-system-react");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _uiUtils = require("../../../../shared/lib/ui-utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HyperliquidLink = ({
  text
}) => {
  return /*#__PURE__*/_react.default.createElement("a", {
    href: _uiUtils.HYPERLIQUID_REFERRAL_LEARN_MORE_URL,
    target: "_blank",
    rel: "noopener noreferrer",
    style: {
      color: 'var(--color-primary-default)',
      cursor: 'pointer'
    }
  }, text);
};
const HyperliquidImage = () => {
  return /*#__PURE__*/_react.default.createElement("img", {
    src: "./images/hyperliquid-referral.png",
    alt: "Hyperliquid referral",
    width: "full"
  });
};
const HyperliquidReferralConsent = ({
  onActionComplete,
  selectedAddress
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const [isChecked, setIsChecked] = (0, _react.useState)(true);
  const handleSubmit = () => {
    onActionComplete({
      approved: isChecked,
      selectedAddress
    });
  };
  const handleCheckboxClick = () => {
    setIsChecked(!isChecked);
  };
  return /*#__PURE__*/_react.default.createElement(_designSystemReact.Box, {
    flexDirection: _designSystemReact.BoxFlexDirection.Column,
    className: "h-full"
  }, /*#__PURE__*/_react.default.createElement(_designSystemReact.Box, {
    flexDirection: _designSystemReact.BoxFlexDirection.Column,
    alignItems: _designSystemReact.BoxAlignItems.Center,
    gap: 4,
    className: "mb-6"
  }, /*#__PURE__*/_react.default.createElement(_designSystemReact.Text, {
    textAlign: _designSystemReact.TextAlign.Center,
    variant: _designSystemReact.TextVariant.HeadingMd,
    fontWeight: _designSystemReact.FontWeight.Bold
  }, t('hyperliquidReferralTitle')), /*#__PURE__*/_react.default.createElement(_designSystemReact.Text, {
    variant: _designSystemReact.TextVariant.BodyMd,
    color: _designSystemReact.TextColor.TextAlternative
  }, t('hyperliquidReferralSubtitle'), ' ', /*#__PURE__*/_react.default.createElement(HyperliquidLink, {
    text: t('learnMoreUpperCase')
  }))), /*#__PURE__*/_react.default.createElement(_designSystemReact.Box, {
    flexDirection: _designSystemReact.BoxFlexDirection.Column,
    justifyContent: _designSystemReact.BoxJustifyContent.Between,
    alignItems: _designSystemReact.BoxAlignItems.Center,
    className: "h-full"
  }, /*#__PURE__*/_react.default.createElement(_designSystemReact.Box, {
    paddingBottom: 6,
    paddingHorizontal: 4
  }, /*#__PURE__*/_react.default.createElement(HyperliquidImage, null)), /*#__PURE__*/_react.default.createElement(_designSystemReact.Box, {
    flexDirection: _designSystemReact.BoxFlexDirection.Column,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_designSystemReact.Box, {
    backgroundColor: _designSystemReact.BoxBackgroundColor.BackgroundSection,
    padding: 3,
    className: "rounded-lg"
  }, /*#__PURE__*/_react.default.createElement(_designSystemReact.Checkbox, {
    id: "hyperliquid-referral-consent-checkbox",
    isSelected: isChecked,
    onChange: handleCheckboxClick,
    label: t('hyperliquidReferralCheckboxLabel'),
    labelProps: {
      variant: _designSystemReact.TextVariant.BodySm,
      color: _designSystemReact.TextColor.TextAlternative
    },
    className: "items-start cursor-pointer"
  })), /*#__PURE__*/_react.default.createElement(_designSystemReact.Button, {
    onClick: handleSubmit
  }, t('confirm')))));
};
exports.HyperliquidReferralConsent = HyperliquidReferralConsent;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\core\\hyperliquid-referral-consent\\hyperliquid-referral-consent.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\core\\hyperliquid-referral-consent\\index.ts", {"./hyperliquid-referral-consent":"D:\\code\\v\\metamask-extension\\ui\\pages\\core\\hyperliquid-referral-consent\\hyperliquid-referral-consent.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Ccore%5Chyperliquid-referral-consent%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "HyperliquidReferralConsent", {
  enumerable: true,
  get: function () {
    return _hyperliquidReferralConsent.HyperliquidReferralConsent;
  }
});
var _hyperliquidReferralConsent = require("./hyperliquid-referral-consent");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\core\\hyperliquid-referral-consent\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\create-account\\connect-hardware\\account-list.js", {"../../../../shared/constants/hardware-wallets":"D:\\code\\v\\metamask-extension\\shared\\constants\\hardware-wallets.ts","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/ui/check-box":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\check-box\\index.js","../../../components/ui/dropdown":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\dropdown\\index.js","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","@metamask/etherscan-link":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\etherscan-link\\dist\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Ccreate-account%5Cconnect-hardware%5Caccount-list.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _etherscanLink = require("@metamask/etherscan-link");
var _componentLibrary = require("../../../components/component-library");
var _checkBox = _interopRequireDefault(require("../../../components/ui/check-box"));
var _dropdown = _interopRequireDefault(require("../../../components/ui/dropdown"));
var _util = require("../../../helpers/utils/util");
var _hardwareWallets = require("../../../../shared/constants/hardware-wallets");
var _metametrics = require("../../../../shared/constants/metametrics");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class AccountList extends _react.Component {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "state", {
      pathValue: null
    });
    _defineProperty(this, "goToNextPage", () => {
      // If we have < 5 accounts, it's restricted by BIP-44
      if (this.props.accounts.length === 5) {
        this.props.getPage(this.props.device, 1, this.props.selectedPath, false);
      } else {
        this.props.onAccountRestriction();
      }
    });
    _defineProperty(this, "goToPreviousPage", () => {
      this.props.getPage(this.props.device, -1, this.props.selectedPath, false);
    });
  }
  setPath(pathValue) {
    this.setState({
      pathValue
    });
  }
  isFirstPage() {
    var _this$props$accounts$;
    return ((_this$props$accounts$ = this.props.accounts[0]) === null || _this$props$accounts$ === void 0 ? void 0 : _this$props$accounts$.index) === 0;
  }
  renderHdPathSelector() {
    const {
      device,
      selectedPath,
      hdPaths,
      onPathChange
    } = this.props;
    const {
      pathValue
    } = this.state;
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("h3", {
      className: "hw-connect__hdPath__title"
    }, this.context.t('selectHdPath')), /*#__PURE__*/_react.default.createElement("p", {
      className: "hw-connect__msg"
    }, this.context.t('selectPathHelp')), /*#__PURE__*/_react.default.createElement("div", {
      className: "hw-connect__hdPath"
    }, /*#__PURE__*/_react.default.createElement(_dropdown.default, {
      className: "hw-connect__hdPath__select",
      options: hdPaths[device],
      selectedOption: pathValue || selectedPath,
      onChange: value => {
        this.setPath(value);
        onPathChange(value);
      }
    })));
  }
  capitalizeDevice(device) {
    return device.slice(0, 1).toUpperCase() + device.slice(1);
  }
  renderHeader() {
    const {
      device
    } = this.props;
    const shouldShowHDPaths = [_hardwareWallets.HardwareDeviceNames.ledger, _hardwareWallets.HardwareDeviceNames.lattice, _hardwareWallets.HardwareDeviceNames.trezor, _hardwareWallets.HardwareDeviceNames.oneKey].includes(device);
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "hw-connect"
    }, /*#__PURE__*/_react.default.createElement("h3", {
      className: "hw-connect__unlock-title"
    }, this.context.t('selectAnAccount')), shouldShowHDPaths ? this.renderHdPathSelector() : null, /*#__PURE__*/_react.default.createElement("h3", {
      className: "hw-connect__hdPath__title"
    }, this.context.t('selectAnAccount')));
  }
  renderAccounts() {
    const {
      accounts,
      connectedAccounts,
      rpcPrefs,
      chainId
    } = this.props;
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "hw-account-list"
    }, accounts.map((account, idx) => {
      const accountAlreadyConnected = connectedAccounts.includes(account.address.toLowerCase());
      const value = account.index;
      const checked = this.props.selectedAccounts.includes(account.index) || accountAlreadyConnected;
      const accountLink = (0, _etherscanLink.getAccountLink)(account.address, chainId, rpcPrefs);
      const blockExplorerDomain = (0, _util.getURLHostName)(accountLink);
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "hw-account-list__item",
        key: account.address,
        "data-testid": "hw-account-list__item",
        title: accountAlreadyConnected ? this.context.t('selectAnAccountAlreadyConnected') : ''
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "hw-account-list__item__checkbox"
      }, /*#__PURE__*/_react.default.createElement(_checkBox.default, {
        id: `address-${idx}`,
        checked: checked,
        disabled: accountAlreadyConnected,
        onClick: () => {
          this.props.onAccountChange(value);
        }
      }), /*#__PURE__*/_react.default.createElement("label", {
        className: "hw-account-list__item__label",
        htmlFor: `address-${idx}`
      }, /*#__PURE__*/_react.default.createElement("span", {
        className: "hw-account-list__item__index"
      }, account.index + 1), `${account.address.slice(0, 4)}...${account.address.slice(-4)}`, /*#__PURE__*/_react.default.createElement("span", {
        className: "hw-account-list__item__balance"
      }, `${account.balance}`))), /*#__PURE__*/_react.default.createElement("a", {
        className: "hw-account-list__item__link",
        onClick: () => {
          this.context.trackEvent({
            category: _metametrics.MetaMetricsEventCategory.Accounts,
            event: 'Clicked Block Explorer Link',
            properties: {
              actions: 'Hardware Connect',
              link_type: 'Account Tracker',
              block_explorer_domain: blockExplorerDomain
            }
          });
          global.platform.openTab({
            url: accountLink
          });
        },
        target: "_blank",
        rel: "noopener noreferrer",
        title: this.context.t('genericExplorerView', [blockExplorerDomain])
      }, /*#__PURE__*/_react.default.createElement("i", {
        className: "fa fa-share-square",
        style: {
          color: 'var(--color-icon-default)'
        }
      })));
    }));
  }
  renderPagination() {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "hw-list-pagination"
    }, /*#__PURE__*/_react.default.createElement("button", {
      className: "hw-list-pagination__button",
      disabled: this.isFirstPage(),
      onClick: this.goToPreviousPage,
      "data-testid": "hw-list-pagination__prev-button"
    }, `< ${this.context.t('prev')}`), /*#__PURE__*/_react.default.createElement("button", {
      className: "hw-list-pagination__button",
      onClick: this.goToNextPage
    }, `${this.context.t('next')} >`));
  }
  renderButtons() {
    const disabled = this.props.selectedAccounts.length === 0;
    const buttonProps = {};
    if (disabled) {
      buttonProps.disabled = true;
    }
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "new-external-account-form__buttons"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
      variant: _componentLibrary.ButtonVariant.Secondary,
      size: _componentLibrary.ButtonSize.Lg,
      block: true,
      onClick: this.props.onCancel.bind(this)
    }, this.context.t('cancel')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
      variant: _componentLibrary.ButtonVariant.Primary,
      size: _componentLibrary.ButtonSize.Lg,
      block: true,
      className: "new-external-account-form__button unlock",
      disabled: disabled,
      onClick: this.props.onUnlockAccounts.bind(this, this.props.device, this.props.selectedPath)
    }, this.context.t('unlock')));
  }
  renderForgetDevice() {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "hw-forget-device-container"
    }, /*#__PURE__*/_react.default.createElement("a", {
      onClick: this.props.onForgetDevice.bind(this, this.props.device)
    }, this.context.t('forgetDevice')));
  }
  render() {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "new-external-account-form account-list"
    }, this.renderHeader(), this.renderAccounts(), this.renderPagination(), this.renderButtons(), this.renderForgetDevice());
  }
}
AccountList.propTypes = {
  onPathChange: _propTypes.default.func.isRequired,
  selectedPath: _propTypes.default.string.isRequired,
  device: _propTypes.default.string.isRequired,
  accounts: _propTypes.default.array.isRequired,
  connectedAccounts: _propTypes.default.array.isRequired,
  onAccountChange: _propTypes.default.func.isRequired,
  onForgetDevice: _propTypes.default.func.isRequired,
  getPage: _propTypes.default.func.isRequired,
  chainId: _propTypes.default.string,
  rpcPrefs: _propTypes.default.object,
  selectedAccounts: _propTypes.default.array.isRequired,
  onUnlockAccounts: _propTypes.default.func,
  onCancel: _propTypes.default.func,
  onAccountRestriction: _propTypes.default.func,
  hdPaths: _propTypes.default.object.isRequired
};
AccountList.contextTypes = {
  t: _propTypes.default.func,
  trackEvent: _propTypes.default.func
};
var _default = exports.default = AccountList;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\create-account\\connect-hardware\\account-list.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\create-account\\connect-hardware\\index.js", {"../../../../shared/constants/hardware-wallets":"D:\\code\\v\\metamask-extension\\shared\\constants\\hardware-wallets.ts","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/time":"D:\\code\\v\\metamask-extension\\shared\\constants\\time.ts","../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../ducks/history/history":"D:\\code\\v\\metamask-extension\\ui\\ducks\\history\\history.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/zendesk-url":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\zendesk-url.js","../../../helpers/higher-order-components/with-router-hooks/with-router-hooks":"D:\\code\\v\\metamask-extension\\ui\\helpers\\higher-order-components\\with-router-hooks\\with-router-hooks.tsx","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./account-list":"D:\\code\\v\\metamask-extension\\ui\\pages\\create-account\\connect-hardware\\account-list.js","./select-hardware":"D:\\code\\v\\metamask-extension\\ui\\pages\\create-account\\connect-hardware\\select-hardware.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","redux":"D:\\code\\v\\metamask-extension\\node_modules\\redux\\lib\\redux.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Ccreate-account%5Cconnect-hardware%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.TREZOR_HD_PATHS = exports.LEDGER_HD_PATHS = exports.LATTICE_HD_PATHS = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRedux = require("react-redux");
var _redux = require("redux");
var actions = _interopRequireWildcard(require("../../../store/actions"));
var _networks = require("../../../../shared/modules/selectors/networks");
var _selectors = require("../../../selectors");
var _util = require("../../../helpers/utils/util");
var _history = require("../../../ducks/history/history");
var _metametrics = require("../../../../shared/constants/metametrics");
var _time = require("../../../../shared/constants/time");
var _hardwareWallets = require("../../../../shared/constants/hardware-wallets");
var _componentLibrary = require("../../../components/component-library");
var _zendeskUrl = _interopRequireDefault(require("../../../helpers/constants/zendesk-url"));
var _designSystem = require("../../../helpers/constants/design-system");
var _selectors2 = require("../../../selectors/selectors");
var _withRouterHooks = _interopRequireDefault(require("../../../helpers/higher-order-components/with-router-hooks/with-router-hooks"));
var _accountList = _interopRequireDefault(require("./account-list"));
var _selectHardware = _interopRequireDefault(require("./select-hardware"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
const U2F_ERROR = 'U2F';
const LEDGER_ERRORS_CODES = {
  '0x650f': 'ledgerErrorConnectionIssue',
  '0x5515': 'ledgerErrorDevicedLocked',
  '0x6501': 'ledgerErrorEthAppNotOpen',
  '0x6a80': 'ledgerErrorTransactionDataNotPadded'
};
const LEDGER_LIVE_PATH = `m/44'/60'/0'/0/0`;
const MEW_PATH = `m/44'/60'/0'`;
const BIP44_PATH = `m/44'/60'/0'/0`;
const LEDGER_HD_PATHS = exports.LEDGER_HD_PATHS = [{
  name: 'Ledger Live',
  value: LEDGER_LIVE_PATH
}, {
  name: 'Legacy (MEW / MyCrypto)',
  value: MEW_PATH
}, {
  name: `BIP44 Standard (e.g. MetaMask, Trezor)`,
  value: BIP44_PATH
}];
const LATTICE_STANDARD_BIP44_PATH = `m/44'/60'/0'/0/x`;
const LATTICE_LEDGER_LIVE_PATH = `m/44'/60'/x'/0/0`;
const LATTICE_MEW_PATH = `m/44'/60'/0'/x`;
const LATTICE_HD_PATHS = exports.LATTICE_HD_PATHS = [{
  name: `Standard (${LATTICE_STANDARD_BIP44_PATH})`,
  value: LATTICE_STANDARD_BIP44_PATH
}, {
  name: `Ledger Live (${LATTICE_LEDGER_LIVE_PATH})`,
  value: LATTICE_LEDGER_LIVE_PATH
}, {
  name: `Ledger Legacy (${LATTICE_MEW_PATH})`,
  value: LATTICE_MEW_PATH
}];
const TREZOR_TESTNET_PATH = `m/44'/1'/0'/0`;
const TREZOR_HD_PATHS = exports.TREZOR_HD_PATHS = [{
  name: `BIP44 Standard (e.g. MetaMask, Trezor)`,
  value: BIP44_PATH
}, {
  name: `Legacy (Ledger / MEW / MyCrypto)`,
  value: MEW_PATH
}, {
  name: `Trezor Testnets`,
  value: TREZOR_TESTNET_PATH
}];
const HD_PATHS = {
  ledger: LEDGER_HD_PATHS,
  lattice: LATTICE_HD_PATHS,
  trezor: TREZOR_HD_PATHS,
  oneKey: TREZOR_HD_PATHS
};
const getErrorMessage = (errorCode, t) => {
  switch (errorCode) {
    case '0x650f':
      return t('ledgerErrorConnectionIssue');
    case '0x5515':
      return t('ledgerErrorDevicedLocked');
    case '0x6501':
      return t('ledgerErrorEthAppNotOpen');
    case '0x6a80':
      return t('ledgerErrorTransactionDataNotPadded');
    default:
      return errorCode;
  }
};
class ConnectHardwareForm extends _react.Component {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "state", {
      error: null,
      selectedAccounts: [],
      accounts: [],
      browserSupported: true,
      unlocked: false,
      device: null,
      isFirefox: false
    });
    _defineProperty(this, "connectToHardwareWallet", device => {
      this.setState({
        device
      });
      if (this.state.accounts.length) {
        return;
      }

      // Default values
      this.getPage(device, 0, this.props.defaultHdPaths[device], true);
    });
    _defineProperty(this, "onPathChange", path => {
      this.props.setHardwareWalletDefaultHdPath({
        device: this.state.device,
        path
      });
      this.setState({
        selectedAccounts: []
      });
      this.getPage(this.state.device, 0, path);
    });
    _defineProperty(this, "onAccountChange", account => {
      let {
        selectedAccounts
      } = this.state;
      if (selectedAccounts.includes(account)) {
        selectedAccounts = selectedAccounts.filter(acc => account !== acc);
      } else {
        selectedAccounts.push(account);
      }
      this.setState({
        selectedAccounts,
        error: null
      });
    });
    _defineProperty(this, "onAccountRestriction", () => {
      this.setState({
        error: this.context.t('ledgerAccountRestriction')
      });
    });
    _defineProperty(this, "getPage", (device, page, hdPath, loadHid) => {
      this.props.connectHardware(device, page, hdPath, loadHid, this.context.t).then(accounts => {
        if (accounts.length) {
          // If we just loaded the accounts for the first time
          // (device previously locked) show the global alert
          if (this.state.accounts.length === 0 && !this.state.unlocked) {
            this.showTemporaryAlert();
          }

          // Map accounts with balances
          const newAccounts = accounts.map(account => {
            var _this$props$accounts$;
            const normalizedAddress = account.address.toLowerCase();
            const balanceValue = ((_this$props$accounts$ = this.props.accounts[normalizedAddress]) === null || _this$props$accounts$ === void 0 ? void 0 : _this$props$accounts$.balance) || null;
            account.balance = balanceValue ? (0, _util.formatBalance)(balanceValue, 6) : '...';
            return account;
          });
          this.setState({
            accounts: newAccounts,
            unlocked: true,
            device,
            error: null
          });
        }
      }).catch(e => {
        const errorMessage = typeof e === 'string' ? e : e.message;
        const ledgerErrorCode = Object.keys(LEDGER_ERRORS_CODES).find(errorCode => errorMessage.includes(errorCode));
        if (errorMessage === 'Window blocked') {
          this.setState({
            browserSupported: false,
            error: null
          });
        } else if (errorMessage.includes(U2F_ERROR)) {
          this.setState({
            error: U2F_ERROR
          });
        } else if (errorMessage === 'LEDGER_LOCKED' || errorMessage === 'LEDGER_WRONG_APP') {
          this.setState({
            error: this.context.t('ledgerLocked')
          });
        } else if (errorMessage.includes('timeout')) {
          this.setState({
            error: this.context.t('ledgerTimeout')
          });
        } else if (ledgerErrorCode) {
          this.setState({
            error: `${errorMessage} - ${getErrorMessage(ledgerErrorCode)}`
          });
        } else if (errorMessage.toLowerCase().includes('KeystoneError#pubkey_account.no_expected_account'.toLowerCase())) {
          this.setState({
            error: this.context.t('QRHardwarePubkeyAccountOutOfRange')
          });
        } else if (errorMessage !== 'Window closed' && errorMessage !== 'Popup closed' && errorMessage.toLowerCase().includes('KeystoneError#sync_cancel'.toLowerCase()) === false) {
          this.setState({
            error: errorMessage
          });
        }
      });
    });
    _defineProperty(this, "onForgetDevice", device => {
      this.props.forgetDevice(device).then(_ => {
        this.setState({
          error: null,
          selectedAccounts: [],
          accounts: [],
          unlocked: false
        });
      }).catch(e => {
        this.setState({
          error: e.message
        });
      });
    });
    _defineProperty(this, "onUnlockAccounts", async (deviceName, path) => {
      const {
        navigate,
        mostRecentOverviewPage,
        unlockHardwareWalletAccounts,
        hdEntropyIndex
      } = this.props;
      const {
        selectedAccounts
      } = this.state;
      if (selectedAccounts.length === 0) {
        this.setState({
          error: this.context.t('accountSelectionRequired')
        });
      }
      const description = MEW_PATH === path ? this.context.t('hardwareWalletLegacyDescription') : '';
      return unlockHardwareWalletAccounts(selectedAccounts, deviceName, path || null, description).then(_ => {
        this.context.trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Accounts,
          event: _metametrics.MetaMetricsEventName.AccountAdded,
          properties: {
            account_type: _metametrics.MetaMetricsEventAccountType.Hardware,
            // For now we keep using the device name to avoid any discrepancies with our current metrics.
            // TODO: This will be addressed later, see: https://github.com/MetaMask/metamask-extension/issues/29777
            account_hardware_type: deviceName,
            is_suggested_name: true
          }
        });
        navigate(mostRecentOverviewPage);
      }).catch(e => {
        this.context.trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Accounts,
          event: _metametrics.MetaMetricsEventName.AccountAddFailed,
          properties: {
            account_type: _metametrics.MetaMetricsEventAccountType.Hardware,
            // See comment above about `account_hardware_type`.
            account_hardware_type: deviceName,
            error: e.message,
            hd_entropy_index: hdEntropyIndex
          }
        });
        this.setState({
          error: e.message
        });
      });
    });
    _defineProperty(this, "onCancel", () => {
      const {
        navigate,
        mostRecentOverviewPage
      } = this.props;
      navigate(mostRecentOverviewPage);
    });
  }
  UNSAFE_componentWillReceiveProps(nextProps) {
    const {
      accounts
    } = nextProps;
    const newAccounts = this.state.accounts.map(a => {
      var _accounts$normalizedA;
      const normalizedAddress = a.address.toLowerCase();
      const balanceValue = ((_accounts$normalizedA = accounts[normalizedAddress]) === null || _accounts$normalizedA === void 0 ? void 0 : _accounts$normalizedA.balance) || null;
      a.balance = balanceValue ? (0, _util.formatBalance)(balanceValue, 6) : '...';
      return a;
    });
    this.setState({
      accounts: newAccounts
    });
  }
  componentDidMount() {
    this.checkIfUnlocked();
    const useAgent = window.navigator.userAgent;
    if (/Firefox/u.test(useAgent)) {
      this.setState({
        isFirefox: true
      });
    }
  }
  async checkIfUnlocked() {
    for (const device of [_hardwareWallets.HardwareDeviceNames.trezor, _hardwareWallets.HardwareDeviceNames.oneKey, _hardwareWallets.HardwareDeviceNames.ledger, _hardwareWallets.HardwareDeviceNames.lattice]) {
      const path = this.props.defaultHdPaths[device];
      const unlocked = await this.props.checkHardwareStatus(device, path);
      if (unlocked && this.state.device) {
        this.setState({
          unlocked: true
        });
        this.getPage(device, 0, path);
      }
    }
  }
  showTemporaryAlert() {
    this.props.showAlert(this.context.t('hardwareWalletConnected'));
    // Autohide the alert after 5 seconds
    setTimeout(_ => {
      this.props.hideAlert();
    }, _time.SECOND * 5);
  }
  renderError() {
    if (this.state.error === U2F_ERROR) {
      if (this.state.device === 'ledger' && this.state.isFirefox) {
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
          color: _designSystem.TextColor.warningDefault,
          margin: [5, 5, 2]
        }, this.context.t('troubleConnectingToLedgerU2FOnFirefox', [
        /*#__PURE__*/
        // eslint-disable-next-line react/jsx-key
        _react.default.createElement(_componentLibrary.Button, {
          variant: _componentLibrary.BUTTON_VARIANT.LINK,
          href: _zendeskUrl.default.HARDWARE_CONNECTION,
          size: _componentLibrary.BUTTON_SIZES.INHERIT,
          key: "u2f-error-1",
          as: "a",
          block: false,
          target: "_blank",
          rel: "noopener noreferrer"
        }, this.context.t('troubleConnectingToLedgerU2FOnFirefox2'))])), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
          color: _designSystem.TextColor.warningDefault,
          margin: [5, 5, 2]
        }, this.context.t('troubleConnectingToLedgerU2FOnFirefoxLedgerSolution', [
        /*#__PURE__*/
        // eslint-disable-next-line react/jsx-key
        _react.default.createElement(_componentLibrary.Button, {
          variant: _componentLibrary.BUTTON_VARIANT.LINK,
          href: _zendeskUrl.default.LEDGER_FIREFOX_U2F_GUIDE,
          size: _componentLibrary.BUTTON_SIZES.INHERIT,
          key: "u2f-error-1",
          as: "a",
          target: "_blank",
          rel: "noopener noreferrer"
        }, this.context.t('troubleConnectingToLedgerU2FOnFirefoxLedgerSolution2'))])));
      }
      return /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        color: _designSystem.TextColor.warningDefault,
        margin: [5, 5, 2]
      }, this.context.t('troubleConnectingToWallet', [this.state.device,
      /*#__PURE__*/
      // eslint-disable-next-line react/jsx-key
      _react.default.createElement(_componentLibrary.Button, {
        variant: _componentLibrary.BUTTON_VARIANT.LINK,
        href: _zendeskUrl.default.HARDWARE_CONNECTION,
        key: "u2f-error-1"
      }, this.context.t('walletConnectionGuide'))]));
    }
    return this.state.error ? /*#__PURE__*/_react.default.createElement("span", {
      className: "hw-connect__error"
    }, this.state.error) : null;
  }
  renderContent() {
    if (!this.state.accounts.length) {
      return /*#__PURE__*/_react.default.createElement(_selectHardware.default, {
        connectToHardwareWallet: this.connectToHardwareWallet,
        browserSupported: this.state.browserSupported,
        ledgerTransportType: this.props.ledgerTransportType,
        onCancel: this.onCancel
      });
    }
    return /*#__PURE__*/_react.default.createElement(_accountList.default, {
      onPathChange: this.onPathChange,
      selectedPath: this.props.defaultHdPaths[this.state.device],
      device: this.state.device,
      accounts: this.state.accounts,
      connectedAccounts: this.props.connectedAccounts,
      selectedAccounts: this.state.selectedAccounts,
      onAccountChange: this.onAccountChange,
      chainId: this.props.chainId,
      rpcPrefs: this.props.rpcPrefs,
      getPage: this.getPage,
      onUnlockAccounts: this.onUnlockAccounts,
      onForgetDevice: this.onForgetDevice,
      onCancel: this.onCancel,
      onAccountRestriction: this.onAccountRestriction,
      hdPaths: HD_PATHS
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, this.renderError(), this.renderContent());
  }
}
_defineProperty(ConnectHardwareForm, "contextTypes", {
  t: _propTypes.default.func
});
ConnectHardwareForm.propTypes = {
  connectHardware: _propTypes.default.func,
  checkHardwareStatus: _propTypes.default.func,
  forgetDevice: _propTypes.default.func,
  showAlert: _propTypes.default.func,
  hideAlert: _propTypes.default.func,
  unlockHardwareWalletAccounts: _propTypes.default.func,
  setHardwareWalletDefaultHdPath: _propTypes.default.func,
  navigate: _propTypes.default.func,
  chainId: _propTypes.default.string,
  rpcPrefs: _propTypes.default.object,
  accounts: _propTypes.default.object,
  connectedAccounts: _propTypes.default.array.isRequired,
  defaultHdPaths: _propTypes.default.object,
  mostRecentOverviewPage: _propTypes.default.string.isRequired,
  ledgerTransportType: _propTypes.default.oneOf(Object.values(_hardwareWallets.LedgerTransportTypes)),
  hdEntropyIndex: _propTypes.default.number
};
const mapStateToProps = state => ({
  chainId: (0, _networks.getCurrentChainId)(state),
  rpcPrefs: (0, _selectors.getRpcPrefsForCurrentProvider)(state),
  accounts: (0, _selectors.getMetaMaskAccounts)(state),
  connectedAccounts: (0, _selectors.getMetaMaskAccountsConnected)(state),
  defaultHdPaths: state.appState.defaultHdPaths,
  mostRecentOverviewPage: (0, _history.getMostRecentOverviewPage)(state),
  ledgerTransportType: state.metamask.ledgerTransportType,
  hdEntropyIndex: (0, _selectors2.getHDEntropyIndex)(state)
});
const mapDispatchToProps = dispatch => {
  return {
    setHardwareWalletDefaultHdPath: ({
      device,
      path
    }) => {
      return dispatch(actions.setHardwareWalletDefaultHdPath({
        device,
        path
      }));
    },
    connectHardware: (deviceName, page, hdPath, loadHid, t) => {
      return dispatch(actions.connectHardware(deviceName, page, hdPath, loadHid, t));
    },
    checkHardwareStatus: (deviceName, hdPath) => {
      return dispatch(actions.checkHardwareStatus(deviceName, hdPath));
    },
    forgetDevice: deviceName => {
      return dispatch(actions.forgetDevice(deviceName));
    },
    unlockHardwareWalletAccounts: (indexes, deviceName, hdPath, hdPathDescription) => {
      return dispatch(actions.unlockHardwareWalletAccounts(indexes, deviceName, hdPath, hdPathDescription));
    },
    showAlert: msg => dispatch(actions.showAlert(msg)),
    hideAlert: () => dispatch(actions.hideAlert())
  };
};
ConnectHardwareForm.contextTypes = {
  t: _propTypes.default.func,
  trackEvent: _propTypes.default.func
};
var _default = exports.default = (0, _redux.compose)(_withRouterHooks.default, (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps))(ConnectHardwareForm);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\create-account\\connect-hardware\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\create-account\\connect-hardware\\select-hardware.js", {"../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../../shared/constants/hardware-wallets":"D:\\code\\v\\metamask-extension\\shared\\constants\\hardware-wallets.ts","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/modules/browser-runtime.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\browser-runtime.utils.js","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/ui/logo/logo-lattice":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\logo\\logo-lattice.js","../../../components/ui/logo/logo-ledger":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\logo\\logo-ledger.js","../../../components/ui/logo/logo-qr-based":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\logo\\logo-qr-based.js","../../../components/ui/logo/logo-trezor":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\logo\\logo-trezor.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/zendesk-url":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\zendesk-url.js","../../../helpers/utils/window":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\window.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Ccreate-account%5Cconnect-hardware%5Cselect-hardware.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _componentLibrary = require("../../../components/component-library");
var _logoLedger = _interopRequireDefault(require("../../../components/ui/logo/logo-ledger"));
var _logoQrBased = _interopRequireDefault(require("../../../components/ui/logo/logo-qr-based"));
var _logoTrezor = _interopRequireDefault(require("../../../components/ui/logo/logo-trezor"));
var _logoLattice = _interopRequireDefault(require("../../../components/ui/logo/logo-lattice"));
var _hardwareWallets = require("../../../../shared/constants/hardware-wallets");
var _zendeskUrl = _interopRequireDefault(require("../../../helpers/constants/zendesk-url"));
var _metametrics = require("../../../../shared/constants/metametrics");
var _window = require("../../../helpers/utils/window");
var _browserRuntime = require("../../../../shared/modules/browser-runtime.utils");
var _designSystem = require("../../../helpers/constants/design-system");
var _app = require("../../../../shared/constants/app");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
// Not all browsers have usb support. In particular, Firefox does
// not support usb. More information on that can be found here:
// https://mozilla.github.io/standards-positions/#webusb
//
// The below `&& window.navigator.usb` condition ensures that we
// only attempt to connect Trezor via usb if we are in a browser
// that supports usb. If not, the connection of the hardware wallet
// to the browser will be handled by the Trezor connect screen. In
// the case of Firefox, this will depend on the Trezor bridge software
const isUSBSupported = !false && window.navigator.usb;
const isFirefox = (0, _browserRuntime.getBrowserName)() === _app.PLATFORM_FIREFOX;
const LEDGER_FIREFOX_NOT_SUPPORTED_URL = 'https://support.metamask.io/more-web3/wallets/how-to-connect-a-trezor-or-ledger-hardware-wallet/';
class SelectHardware extends _react.Component {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "state", {
      selectedDevice: null,
      trezorRequestDevicePending: false
    });
    _defineProperty(this, "connect", async () => {
      const {
        selectedDevice
      } = this.state;
      if (selectedDevice) {
        if (selectedDevice === _hardwareWallets.HardwareDeviceNames.trezor && isUSBSupported) {
          this.setState({
            trezorRequestDevicePending: true
          });
          try {
            await window.navigator.usb.requestDevice({
              filters: [{
                vendorId: 0x534c,
                productId: 0x0001
              }, {
                vendorId: 0x1209,
                productId: 0x53c0
              }, {
                vendorId: 0x1209,
                productId: 0x53c1
              }]
            });
          } catch (e) {
            if (!e.message.match('No device selected')) {
              throw e;
            }
          } finally {
            this.setState({
              trezorRequestDevicePending: false
            });
          }
        }
        this.props.connectToHardwareWallet(selectedDevice);
      }
      return null;
    });
  }
  renderConnectToTrezorButton() {
    return /*#__PURE__*/_react.default.createElement("button", {
      "data-testid": "connect-trezor-btn",
      className: (0, _classnames.default)('hw-connect__btn', {
        selected: this.state.selectedDevice === _hardwareWallets.HardwareDeviceNames.trezor
      }),
      onClick: _ => this.setState({
        selectedDevice: _hardwareWallets.HardwareDeviceNames.trezor
      })
    }, /*#__PURE__*/_react.default.createElement(_logoTrezor.default, {
      className: "hw-connect__btn__img",
      ariaLabel: "Trezor"
    }));
  }
  renderConnectToLatticeButton() {
    return /*#__PURE__*/_react.default.createElement("button", {
      "data-testid": "connect-lattice-btn",
      className: (0, _classnames.default)('hw-connect__btn', {
        selected: this.state.selectedDevice === _hardwareWallets.HardwareDeviceNames.lattice
      }),
      onClick: _ => this.setState({
        selectedDevice: _hardwareWallets.HardwareDeviceNames.lattice
      })
    }, /*#__PURE__*/_react.default.createElement(_logoLattice.default, {
      className: "hw-connect__btn__img",
      ariaLabel: "Lattice"
    }));
  }
  renderConnectToLedgerButton() {
    return /*#__PURE__*/_react.default.createElement("button", {
      "data-testid": "connect-ledger-btn",
      className: (0, _classnames.default)('hw-connect__btn', {
        selected: this.state.selectedDevice === _hardwareWallets.HardwareDeviceNames.ledger
      }),
      onClick: _ => this.setState({
        selectedDevice: _hardwareWallets.HardwareDeviceNames.ledger
      })
    }, /*#__PURE__*/_react.default.createElement(_logoLedger.default, {
      className: "hw-connect__btn__img",
      ariaLabel: "Ledger"
    }));
  }
  renderConnectToQRButton() {
    return /*#__PURE__*/_react.default.createElement("button", {
      "data-testid": "connect-qr-btn",
      className: (0, _classnames.default)('hw-connect__btn', {
        selected: this.state.selectedDevice === _hardwareWallets.HardwareDeviceNames.qr
      }),
      onClick: _ => this.setState({
        selectedDevice: _hardwareWallets.HardwareDeviceNames.qr
      })
    }, /*#__PURE__*/_react.default.createElement(_logoQrBased.default, {
      className: "hw-connect__btn__img",
      ariaLabel: "QRCode"
    }));
  }
  renderButtons() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
      className: "hw-connect__btn-wrapper"
    }, this.renderConnectToLedgerButton(), this.renderConnectToTrezorButton()), /*#__PURE__*/_react.default.createElement("div", {
      className: "hw-connect__btn-wrapper",
      style: {
        margin: '10px 0 0 0'
      }
    }, this.renderConnectToLatticeButton(), this.renderConnectToQRButton()));
  }
  renderContinueButton() {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
      variant: _componentLibrary.BUTTON_VARIANT.PRIMARY,
      size: _componentLibrary.BUTTON_SIZES.LG,
      className: "hw-connect__connect-btn",
      onClick: this.connect,
      disabled: !this.state.selectedDevice || this.state.trezorRequestDevicePending || this.state.selectedDevice === _hardwareWallets.HardwareDeviceNames.ledger && isFirefox
    }, this.context.t('continue'));
  }
  renderFooter() {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      color: _designSystem.TextColor.textAlternative,
      variant: _designSystem.TextVariant.bodySm,
      textAlign: _designSystem.TextAlign.Center,
      as: "h6",
      marginTop: 4,
      className: "new-external-account-form footer"
    }, this.context.t('hardwareWalletsInfo'));
  }
  renderUnsupportedBrowser() {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      justifyContent: _designSystem.JustifyContent.center,
      alignItems: _designSystem.AlignItems.center,
      className: "new-external-account-form unsupported-browser"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      className: "hw-connect",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      alignItems: _designSystem.AlignItems.center
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      className: "hw-connect__title",
      variant: _designSystem.TextVariant.headingMd,
      as: "h3",
      fontWeight: _designSystem.FontWeight.Bold,
      marginTop: 6,
      marginBottom: 3
    }, this.context.t('browserNotSupported')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      className: "hw-connect__msg",
      variant: _designSystem.TextVariant.bodyMd,
      as: "h5",
      marginTop: 3,
      marginBottom: 5
    }, this.context.t('chromeRequiredForHardwareWallets'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
      variant: _componentLibrary.BUTTON_VARIANT.PRIMARY,
      size: _componentLibrary.BUTTON_SIZES.LG,
      onClick: () => global.platform.openTab({
        url: 'https://google.com/chrome'
      })
    }, this.context.t('downloadGoogleChrome')));
  }
  renderHeader() {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      className: "hw-connect__header",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      alignItems: _designSystem.AlignItems.center
    }, this.state.selectedDevice === _hardwareWallets.HardwareDeviceNames.ledger && !isFirefox && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerAlert, {
      marginTop: 6,
      title: this.context.t('ledgerMultipleDevicesUnsupportedInfoTitle')
    }, this.context.t('ledgerMultipleDevicesUnsupportedInfoDescription'))), this.state.selectedDevice === _hardwareWallets.HardwareDeviceNames.ledger && isFirefox && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerAlert, {
      marginTop: 6,
      severity: "warning",
      title: this.context.t('ledgerFirefoxNotSupportedTitle')
    }, this.context.t('ledgerFirefoxNotSupportedDescription1'), /*#__PURE__*/_react.default.createElement("a", {
      className: "hw-connect__href-link",
      href: LEDGER_FIREFOX_NOT_SUPPORTED_URL,
      target: "_blank",
      rel: "noreferrer"
    }, this.context.t('ledgerFirefoxNotSupportedLink')), this.context.t('ledgerFirefoxNotSupportedDescription2'), /*#__PURE__*/_react.default.createElement("br", null), this.context.t('ledgerFirefoxNotSupportedDescription3'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      justifyContent: _designSystem.JustifyContent.center,
      alignItems: _designSystem.AlignItems.center,
      className: "hw-connect__header__title-wrapper",
      marginTop: 6
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.headingMd,
      as: "h3",
      fontWeight: _designSystem.FontWeight.Bold,
      marginLeft: "auto"
    }, this.context.t('hardwareWallets')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      iconName: _componentLibrary.IconName.Close,
      ariaLabel: this.context.t('close'),
      onClick: this.props.onCancel,
      size: _componentLibrary.ButtonIconSize.Sm,
      marginLeft: "auto",
      "data-testid": "hardware-connect-close-btn"
    })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      className: "hw-connect__header__msg",
      variant: _designSystem.TextVariant.bodyMd,
      as: "h5",
      marginTop: 5,
      marginBottom: 3
    }, this.context.t('hardwareWalletsMsg')));
  }
  renderTutorialSteps() {
    switch (this.state.selectedDevice) {
      case _hardwareWallets.HardwareDeviceNames.ledger:
        return this.renderLedgerTutorialSteps();
      case _hardwareWallets.HardwareDeviceNames.trezor:
        return this.renderTrezorTutorialSteps();
      case _hardwareWallets.HardwareDeviceNames.lattice:
        return this.renderLatticeTutorialSteps();
      case _hardwareWallets.HardwareDeviceNames.qr:
        return this.renderQRHardwareWalletSteps();
      default:
        return '';
    }
  }
  renderLedgerTutorialSteps() {
    const steps = [];
    if (this.props.ledgerTransportType === _hardwareWallets.LedgerTransportTypes.live) {
      steps.push({
        renderButtons: false,
        title: this.context.t('step1LedgerWallet'),
        message: this.context.t('step1LedgerWalletMsg', [/*#__PURE__*/_react.default.createElement("a", {
          className: "hw-connect__msg-link",
          href: "https://www.ledger.com/ledger-live",
          rel: "noopener noreferrer",
          target: "_blank",
          key: "ledger-live-app-link"
        }, this.context.t('ledgerLiveApp'))])
      });
    }
    steps.push({
      renderButtons: true,
      asset: 'plug-in-wallet',
      dimensions: {
        width: '225px',
        height: '75px'
      },
      title: this.context.t('step2LedgerWallet'),
      message: this.context.t('step2LedgerWalletMsg', [/*#__PURE__*/_react.default.createElement("a", {
        className: "hw-connect__msg-link",
        href: _zendeskUrl.default.HARDWARE_CONNECTION,
        rel: "noopener noreferrer",
        target: "_blank",
        key: "ledger-support-link"
      }, this.context.t('hardwareWalletSupportLinkConversion'))])
    });
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "hw-tutorial"
    }, steps.map((step, index) => /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      alignItems: _designSystem.AlignItems.center,
      className: "hw-connect",
      key: index
    }, /*#__PURE__*/_react.default.createElement("h3", {
      className: "hw-connect__title"
    }, step.title), step.renderButtons ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      justifyContent: _designSystem.JustifyContent.center,
      marginBottom: 2
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
      className: "hw-connect__external-btn-first",
      variant: _componentLibrary.BUTTON_VARIANT.SECONDARY,
      onClick: () => {
        this.context.trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Navigation,
          event: 'Clicked Ledger Buy Now'
        });
        (0, _window.openWindow)(_hardwareWallets.HardwareAffiliateLinks.ledger);
      }
    }, this.context.t('buyNow')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
      className: "hw-connect__external-btn",
      variant: _componentLibrary.BUTTON_VARIANT.SECONDARY,
      onClick: () => {
        this.context.trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Navigation,
          event: 'Clicked Ledger Tutorial'
        });
        (0, _window.openWindow)(_hardwareWallets.HardwareAffiliateTutorialLinks.ledger);
      }
    }, this.context.t('tutorial'))) : null, /*#__PURE__*/_react.default.createElement("p", {
      className: "hw-connect__msg"
    }, step.message), step.asset && /*#__PURE__*/_react.default.createElement("img", _extends({
      className: "hw-connect__step-asset",
      src: `images/${step.asset}.svg`
    }, step.dimensions, {
      alt: ""
    })))));
  }
  renderLatticeTutorialSteps() {
    const steps = [{
      asset: 'connect-lattice',
      dimensions: {
        width: '225px',
        height: '75px'
      },
      title: this.context.t('step1LatticeWallet'),
      message: this.context.t('step1LatticeWalletMsg', [/*#__PURE__*/_react.default.createElement("a", {
        className: "hw-connect__msg-link",
        href: _zendeskUrl.default.HARDWARE_CONNECTION,
        rel: "noopener noreferrer",
        target: "_blank",
        key: "lattice-setup-link"
      }, this.context.t('hardwareWalletSupportLinkConversion'))])
    }];
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "hw-tutorial"
    }, steps.map((step, index) => /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      alignItems: _designSystem.AlignItems.center,
      className: "hw-connect",
      key: index
    }, /*#__PURE__*/_react.default.createElement("h3", {
      className: "hw-connect__title"
    }, step.title), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      justifyContent: _designSystem.JustifyContent.center,
      marginBottom: 2
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
      className: "hw-connect__external-btn-first",
      variant: _componentLibrary.BUTTON_VARIANT.SECONDARY,
      onClick: () => {
        this.context.trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Navigation,
          event: 'Clicked GridPlus Buy Now'
        });
        (0, _window.openWindow)(_hardwareWallets.HardwareAffiliateLinks.gridplus);
      }
    }, this.context.t('buyNow')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
      className: "hw-connect__external-btn",
      variant: _componentLibrary.BUTTON_VARIANT.SECONDARY,
      onClick: () => {
        this.context.trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Navigation,
          event: 'Clicked GidPlus Tutorial'
        });
        (0, _window.openWindow)(_hardwareWallets.HardwareAffiliateTutorialLinks.gridplus);
      }
    }, this.context.t('tutorial'))), /*#__PURE__*/_react.default.createElement("p", {
      className: "hw-connect__msg"
    }, step.message), step.asset && /*#__PURE__*/_react.default.createElement("img", _extends({
      className: "hw-connect__step-asset",
      src: `images/${step.asset}.svg`
    }, step.dimensions, {
      alt: ""
    })))));
  }
  renderTrezorTutorialSteps() {
    const steps = [{
      asset: 'plug-in-wallet',
      dimensions: {
        width: '225px',
        height: '75px'
      },
      title: this.context.t('step1TrezorWallet'),
      message: this.context.t('step1TrezorWalletMsg', [/*#__PURE__*/_react.default.createElement("a", {
        className: "hw-connect__msg-link",
        href: _zendeskUrl.default.HARDWARE_CONNECTION,
        rel: "noopener noreferrer",
        target: "_blank",
        key: "trezor-support-link"
      }, this.context.t('hardwareWalletSupportLinkConversion'))])
    }];
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "hw-tutorial"
    }, steps.map((step, index) => /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      alignItems: _designSystem.AlignItems.center,
      className: "hw-connect",
      key: index
    }, /*#__PURE__*/_react.default.createElement("h3", {
      className: "hw-connect__title"
    }, step.title), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      justifyContent: _designSystem.JustifyContent.center,
      marginBottom: 2
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
      className: "hw-connect__external-btn-first",
      variant: _componentLibrary.BUTTON_VARIANT.SECONDARY,
      onClick: () => {
        this.context.trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Navigation,
          event: 'Clicked Trezor Buy Now'
        });
        (0, _window.openWindow)(_hardwareWallets.HardwareAffiliateLinks.trezor);
      }
    }, this.context.t('buyNow')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
      className: "hw-connect__external-btn",
      variant: _componentLibrary.BUTTON_VARIANT.SECONDARY,
      onClick: () => {
        this.context.trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Navigation,
          event: 'Clicked Trezor Tutorial'
        });
        (0, _window.openWindow)(_hardwareWallets.HardwareAffiliateTutorialLinks.trezor);
      }
    }, this.context.t('tutorial'))), /*#__PURE__*/_react.default.createElement("p", {
      className: "hw-connect__msg"
    }, step.message), step.asset && /*#__PURE__*/_react.default.createElement("img", _extends({
      className: "hw-connect__step-asset",
      src: `images/${step.asset}.svg`
    }, step.dimensions, {
      alt: ""
    })))));
  }
  renderQRHardwareWalletSteps() {
    const steps = [];
    steps.push({
      title: this.context.t('QRHardwareWalletSteps1Title'),
      message: this.context.t('QRHardwareWalletSteps1Description')
    }, {
      message: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
        className: "hw-connect__QR-subtitle"
      }, this.context.t('keystone')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
        className: "hw-connect__external-btn-first",
        variant: _componentLibrary.BUTTON_VARIANT.SECONDARY,
        onClick: () => {
          this.context.trackEvent({
            category: _metametrics.MetaMetricsEventCategory.Navigation,
            event: 'Clicked Keystone Learn More'
          });
          (0, _window.openWindow)(_hardwareWallets.HardwareAffiliateLinks.keystone);
        }
      }, this.context.t('learnMoreKeystone')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
        className: "hw-connect__external-btn",
        variant: _componentLibrary.BUTTON_VARIANT.SECONDARY,
        onClick: () => {
          this.context.trackEvent({
            category: _metametrics.MetaMetricsEventCategory.Navigation,
            event: 'Clicked Keystone Tutorial'
          });
          (0, _window.openWindow)(_hardwareWallets.HardwareAffiliateTutorialLinks.keystone);
        }
      }, this.context.t('tutorial')))
    }, {
      message: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
        className: "hw-connect__QR-subtitle"
      }, this.context.t('airgapVault')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
        className: "hw-connect__external-btn-first",
        variant: _componentLibrary.BUTTON_VARIANT.SECONDARY,
        onClick: () => {
          this.context.trackEvent({
            category: _metametrics.MetaMetricsEventCategory.Navigation,
            event: 'Clicked AirGap Vault Buy Now'
          });
          (0, _window.openWindow)(_hardwareWallets.HardwareAffiliateLinks.airgap);
        }
      }, this.context.t('downloadNow')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
        className: "hw-connect__external-btn",
        variant: _componentLibrary.BUTTON_VARIANT.SECONDARY,
        onClick: () => {
          this.context.trackEvent({
            category: _metametrics.MetaMetricsEventCategory.Navigation,
            event: 'Clicked AirGap Vault Tutorial'
          });
          (0, _window.openWindow)(_hardwareWallets.HardwareAffiliateTutorialLinks.airgap);
        }
      }, this.context.t('tutorial')))
    }, {
      message: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
        className: "hw-connect__QR-subtitle"
      }, this.context.t('coolWallet')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
        className: "hw-connect__external-btn-first",
        variant: _componentLibrary.BUTTON_VARIANT.SECONDARY,
        onClick: () => {
          this.context.trackEvent({
            category: _metametrics.MetaMetricsEventCategory.Navigation,
            event: 'Clicked CoolWallet Buy Now'
          });
          (0, _window.openWindow)(_hardwareWallets.HardwareAffiliateLinks.coolwallet);
        }
      }, this.context.t('buyNow')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
        className: "hw-connect__external-btn",
        variant: _componentLibrary.BUTTON_VARIANT.SECONDARY,
        onClick: () => {
          this.context.trackEvent({
            category: _metametrics.MetaMetricsEventCategory.Navigation,
            event: 'Clicked CoolWallet Tutorial'
          });
          (0, _window.openWindow)(_hardwareWallets.HardwareAffiliateTutorialLinks.coolwallet);
        }
      }, this.context.t('tutorial')))
    }, {
      message: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
        className: "hw-connect__QR-subtitle"
      }, this.context.t('dcent')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
        className: "hw-connect__external-btn-first",
        variant: _componentLibrary.BUTTON_VARIANT.SECONDARY,
        onClick: () => {
          this.context.trackEvent({
            category: _metametrics.MetaMetricsEventCategory.Navigation,
            event: 'Clicked DCent Buy Now'
          });
          (0, _window.openWindow)(_hardwareWallets.HardwareAffiliateLinks.dcent);
        }
      }, this.context.t('buyNow')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
        className: "hw-connect__external-btn",
        variant: _componentLibrary.BUTTON_VARIANT.SECONDARY,
        onClick: () => {
          this.context.trackEvent({
            category: _metametrics.MetaMetricsEventCategory.Navigation,
            event: 'Clicked DCent Tutorial'
          });
          (0, _window.openWindow)(_hardwareWallets.HardwareAffiliateTutorialLinks.dcent);
        }
      }, this.context.t('tutorial')))
    }, {
      message: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
        className: "hw-connect__QR-subtitle"
      }, this.context.t('imToken')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
        className: "hw-connect__external-btn-first",
        variant: _componentLibrary.BUTTON_VARIANT.SECONDARY,
        onClick: () => {
          this.context.trackEvent({
            category: _metametrics.MetaMetricsEventCategory.Navigation,
            event: 'Clicked imToken Learn More'
          });
          (0, _window.openWindow)(_hardwareWallets.HardwareAffiliateLinks.imtoken);
        }
      }, this.context.t('downloadNow')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
        className: "hw-connect__external-btn",
        variant: _componentLibrary.BUTTON_VARIANT.SECONDARY,
        onClick: () => {
          this.context.trackEvent({
            category: _metametrics.MetaMetricsEventCategory.Navigation,
            event: 'Clicked imToken Tutorial'
          });
          (0, _window.openWindow)(_hardwareWallets.HardwareAffiliateTutorialLinks.imtoken);
        }
      }, this.context.t('tutorial')))
    }, {
      message: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
        className: "hw-connect__QR-subtitle"
      }, this.context.t('onekey')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
        className: "hw-connect__external-btn-first",
        variant: _componentLibrary.BUTTON_VARIANT.SECONDARY,
        onClick: () => {
          this.context.trackEvent({
            category: _metametrics.MetaMetricsEventCategory.Navigation,
            event: 'Clicked OneKey Learn More'
          });
          (0, _window.openWindow)(_hardwareWallets.HardwareAffiliateLinks.onekey);
        }
      }, this.context.t('buyNow')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
        className: "hw-connect__external-btn",
        variant: _componentLibrary.BUTTON_VARIANT.SECONDARY,
        onClick: () => {
          this.context.trackEvent({
            category: _metametrics.MetaMetricsEventCategory.Navigation,
            event: 'Clicked OneKey Tutorial'
          });
          (0, _window.openWindow)(_hardwareWallets.HardwareAffiliateTutorialLinks.onekey);
        }
      }, this.context.t('tutorial')))
    }, {
      message: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
        className: "hw-connect__QR-subtitle"
      }, this.context.t('QRHardwareWalletSteps2Description')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
        className: "hw-connect__external-btn-first",
        variant: _componentLibrary.BUTTON_VARIANT.SECONDARY,
        onClick: () => {
          this.context.trackEvent({
            category: _metametrics.MetaMetricsEventCategory.Navigation,
            event: 'Clicked Ngrave Buy Now'
          });
          (0, _window.openWindow)(_hardwareWallets.HardwareAffiliateLinks.ngrave);
        },
        "data-testid": "ngrave-brand-buy-now-btn"
      }, this.context.t('buyNow')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
        className: "hw-connect__external-btn",
        variant: _componentLibrary.BUTTON_VARIANT.SECONDARY,
        onClick: () => {
          this.context.trackEvent({
            category: _metametrics.MetaMetricsEventCategory.Navigation,
            event: 'Clicked Ngrave Learn more'
          });
          (0, _window.openWindow)(_hardwareWallets.HardwareAffiliateTutorialLinks.ngrave);
        },
        "data-testid": "ngrave-brand-learn-more-btn"
      }, this.context.t('learnMoreUpperCase')))
    });
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "hw-tutorial"
    }, steps.map((step, index) => /*#__PURE__*/_react.default.createElement("div", {
      className: "hw-connect",
      key: index
    }, step.title && /*#__PURE__*/_react.default.createElement("h3", {
      className: "hw-connect__title"
    }, step.title), /*#__PURE__*/_react.default.createElement("div", {
      className: "hw-connect__msg"
    }, step.message), step.asset && /*#__PURE__*/_react.default.createElement("img", _extends({
      className: "hw-connect__step-asset",
      src: `images/${step.asset}.svg`
    }, step.dimensions, {
      alt: ""
    })))));
  }
  renderConnectScreen() {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      className: "new-external-account-form",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      alignItems: _designSystem.AlignItems.center,
      justifyContent: _designSystem.JustifyContent.center
    }, this.renderHeader(), this.renderButtons(), this.state.selectedDevice ? this.renderTutorialSteps() : null, this.renderContinueButton(), this.renderFooter());
  }
  render() {
    if (this.props.browserSupported) {
      return this.renderConnectScreen();
    }
    return this.renderUnsupportedBrowser();
  }
}
exports.default = SelectHardware;
_defineProperty(SelectHardware, "contextTypes", {
  t: _propTypes.default.func,
  trackEvent: _propTypes.default.func
});
_defineProperty(SelectHardware, "propTypes", {
  onCancel: _propTypes.default.func.isRequired,
  connectToHardwareWallet: _propTypes.default.func.isRequired,
  browserSupported: _propTypes.default.bool.isRequired,
  ledgerTransportType: _propTypes.default.oneOf(Object.values(_hardwareWallets.LedgerTransportTypes))
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\create-account\\connect-hardware\\select-hardware.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\create-account\\create-account.component.js", {"../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","./connect-hardware":"D:\\code\\v\\metamask-extension\\ui\\pages\\create-account\\connect-hardware\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Ccreate-account%5Ccreate-account.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = CreateAccountPage;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _componentLibrary = require("../../components/component-library");
var _routes = require("../../helpers/constants/routes");
var _connectHardware = _interopRequireDefault(require("./connect-hardware"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function CreateAccountPage() {
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "new-account-wrapper"
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Routes, null, /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
    path: _routes.CONNECT_HARDWARE_ROUTE,
    element: /*#__PURE__*/_react.default.createElement(_connectHardware.default, null)
  })));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\create-account\\create-account.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\create-snap-account\\create-snap-account.tsx", {"../../components/app/snaps/snap-authorship-header":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-authorship-header\\index.js","../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Ccreate-snap-account%5Ccreate-snap-account.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../components/component-library");
var _designSystem = require("../../helpers/constants/design-system");
var _snapAuthorshipHeader = _interopRequireDefault(require("../../components/app/snaps/snap-authorship-header"));
var _useI18nContext = require("../../hooks/useI18nContext");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const CreateSnapAccount = ({
  snapId,
  snapName,
  onCancel
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "create-snap-account-page",
    height: _designSystem.BlockSize.Full,
    width: _designSystem.BlockSize.Full,
    display: _designSystem.Display.Flex,
    borderStyle: _designSystem.BorderStyle.none,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.center,
    marginBottom: 0
  }, /*#__PURE__*/_react.default.createElement(_snapAuthorshipHeader.default, {
    snapId: snapId,
    onCancel: onCancel
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    padding: 4,
    style: {
      flexGrow: 1
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingBottom: 6
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarIcon, {
    iconName: _componentLibrary.IconName.UserCircleAdd,
    size: _componentLibrary.AvatarIconSize.Xl
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    "data-testid": "create-snap-account-content-title",
    textAlign: _designSystem.TextAlign.Center,
    variant: _designSystem.TextVariant.headingLg,
    paddingBottom: 2
  }, t('createSnapAccountTitle')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    textAlign: _designSystem.TextAlign.Center,
    overflowWrap: _designSystem.OverflowWrap.Anywhere,
    "data-testid": "create-snap-account-content-description"
  }, t('createSnapAccountDescription', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.inherit,
    variant: _designSystem.TextVariant.inherit,
    fontWeight: _designSystem.FontWeight.Medium,
    key: "1"
  }, snapName)])))));
};
var _default = exports.default = CreateSnapAccount;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\create-snap-account\\create-snap-account.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\create-snap-account\\index.ts", {"./create-snap-account":"D:\\code\\v\\metamask-extension\\ui\\pages\\create-snap-account\\create-snap-account.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Ccreate-snap-account%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "CreateSnapAccount", {
  enumerable: true,
  get: function () {
    return _createSnapAccount.default;
  }
});
var _createSnapAccount = _interopRequireDefault(require("./create-snap-account"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\create-snap-account\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\deep-link\\deep-link.tsx", {"../../../shared/lib/deep-links/constants":"D:\\code\\v\\metamask-extension\\shared\\lib\\deep-links\\constants.ts","../../../shared/lib/deep-links/parse":"D:\\code\\v\\metamask-extension\\shared\\lib\\deep-links\\parse.ts","../../../shared/lib/deep-links/verify":"D:\\code\\v\\metamask-extension\\shared\\lib\\deep-links\\verify.ts","../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../components/component-library/box/box":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\box\\box.tsx","../../components/component-library/button":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\button\\index.ts","../../components/component-library/checkbox/checkbox":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\checkbox\\checkbox.tsx","../../components/component-library/container/container":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\container\\container.tsx","../../components/component-library/text/text":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\text\\text.tsx","../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cdeep-link%5Cdeep-link.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeepLink = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _loglevel = _interopRequireDefault(require("loglevel"));
var _reactRedux = require("react-redux");
var _button = require("../../components/component-library/button");
var _parse = require("../../../shared/lib/deep-links/parse");
var _constants = require("../../../shared/lib/deep-links/constants");
var _useI18nContext = require("../../hooks/useI18nContext");
var _designSystem = require("../../helpers/constants/design-system");
var _text = require("../../components/component-library/text/text");
var _box = require("../../components/component-library/box/box");
var _container = require("../../components/component-library/container/container");
var _componentLibrary = require("../../components/component-library");
var _checkbox = require("../../components/component-library/checkbox/checkbox");
var _actions = require("../../store/actions");
var _selectors = require("../../selectors/selectors");
var _verify = require("../../../shared/lib/deep-links/verify");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  getExtensionURL
} = globalThis.platform;

/**
 * Sets the description and title state for a 404 error.
 *
 * @param setDescription - The function to call to set the description state.
 * @param setTitle - The function to call to set the title state.
 * @param t - The translation function.
 */
function set404(setDescription, setTitle, t) {
  setDescription(t('deepLink_Error404Description'));
  setTitle(t('deepLink_Error404Title'));
}

/**
 * Updates the state based on the URL path and query. This function parses the
 * URL, retrieves the route, and sets the route and error state accordingly.
 *
 * @param urlPathAndQuery - The URL path and query string to parse. (relative to its origin, i.e., /home?utm_source=foo)
 * @param setDescription - The function to call to set the description state.
 * @param setExtraDescription - The function to call to set the extra description state.
 * @param setIsLoading - The function to call to set the loading state.
 * @param setRoute - The function to call to set the route state.
 * @param setTitle - The function to call to set the title state.
 * @param setCta - The function to call to set the call-to-action state.
 * @param t - The translation function.
 * @param abortController
 */
async function updateStateFromUrl(urlPathAndQuery, setDescription, setExtraDescription, setIsLoading, setRoute, setTitle, setCta, t, abortController) {
  try {
    const fullUrlStr = `https://${_constants.DEEP_LINK_HOST}${urlPathAndQuery}`;
    const url = new URL(fullUrlStr);
    setIsLoading(true);
    const parsed = await (0, _parse.parse)(url);
    if (abortController.signal.aborted) {
      return;
    }
    if (parsed) {
      const {
        destination
      } = parsed;
      if ('redirectTo' in destination) {
        window.location.href = destination.redirectTo.toString();
        return;
      }
      const {
        path,
        query
      } = destination;
      const href = getExtensionURL(path, query.toString() ?? null);
      const title = parsed.route.getTitle(url.searchParams);
      const signed = parsed.signature === _verify.VALID;
      const continueMessage = t('deepLink_ContinueDescription', [t(title)]);
      const description = signed ? continueMessage : t('deepLink_ThirdPartyDescription', [continueMessage]);
      setDescription(description);
      setExtraDescription(null);
      setRoute({
        href,
        signed
      });
      setTitle(signed ? t('deepLink_RedirectingToMetaMask') : t('deepLink_Caution'));
      setCta(t('deepLink_Continue', [t(title)]));
    } else {
      setRoute(null);
      set404(setDescription, setTitle, t);
      setCta(t('deepLink_GoToTheHomePageButton'));
      const signature = await (0, _verify.verify)(url);
      if (abortController.signal.aborted) {
        return;
      }
      if (signature === _verify.VALID) {
        setExtraDescription(t('deepLink_Error404_CTA', [/*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
          key: "update-metamask-link",
          as: "a",
          href: "https://support.metamask.io/configure/wallet/how-to-update-the-version-of-metamask/"
        }, t('deepLink_Error404_CTA_LinkText'))]));
      }
    }
  } catch (e) {
    _loglevel.default.error('Error parsing deep link:', e);
    setDescription(t('deepLink_ErrorOtherDescription'));
    setExtraDescription(null);
    setRoute(null);
    setTitle(t('deepLink_ErrorOtherTitle'));
    setCta(t('deepLink_GoToTheHomePageButton'));
  } finally {
    setIsLoading(false);
  }
}
const DeepLink = () => {
  const location = (0, _reactRouterDom.useLocation)();
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  // it's technically not possible for a natural flow to reach this page
  // when `skipDeepLinkInterstitial` is true, but if a user manually navigates
  // to this "interstitial" page, or uses their back button, we should show
  // their previously selected preference.
  const skipDeepLinkInterstitial = (0, _reactRedux.useSelector)(state => (0, _selectors.getPreferences)(state).skipDeepLinkInterstitial);
  const [description, setDescription] = (0, _react.useState)(null);
  const [extraDescription, setExtraDescription] = (0, _react.useState)(null);
  const [route, setRoute] = (0, _react.useState)(null);
  const [title, setTitle] = (0, _react.useState)(null);
  const [cta, setCta] = (0, _react.useState)(null);
  const [skipDeepLinkInterstitialChecked, setSkipDeepLinkInterstitialChecked] = (0, _react.useState)(skipDeepLinkInterstitial);
  const [isLoading, setIsLoading] = (0, _react.useState)(true);

  // Use ref to track current abort controller
  const abortControllerRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    var _abortControllerRef$c;
    // Cancel any previous operation
    (_abortControllerRef$c = abortControllerRef.current) === null || _abortControllerRef$c === void 0 || _abortControllerRef$c.abort();

    // Create new abort controller for this operation
    const abortController = new AbortController();
    abortControllerRef.current = abortController;
    const processDeepLink = async () => {
      const params = new URLSearchParams(location.search);
      const urlStr = params.get('u');
      const errorCode = params.get('errorCode');
      if (!urlStr || errorCode) {
        setRoute(null);
        setIsLoading(false);
        if (errorCode === '404') {
          set404(setDescription, setTitle, t);
          if (urlStr) {
            try {
              const fullUrlStr = `https://${_constants.DEEP_LINK_HOST}${urlStr}`;
              const url = new URL(fullUrlStr);
              const signature = await (0, _verify.verify)(url);

              // Check if aborted after async operation
              if (abortController.signal.aborted) {
                return;
              }
              if (signature === _verify.VALID) {
                setExtraDescription(t('deepLink_Error404_CTA', [/*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
                  key: "update-metamask-link",
                  as: "a",
                  href: "https://support.metamask.io/configure/wallet/how-to-update-the-version-of-metamask/"
                }, t('deepLink_Error404_CTA_LinkText'))]));
              } else {
                setExtraDescription(null);
              }
            } catch (e) {
              // probably a gibberish url, ignore
              if (abortController.signal.aborted) {
                return;
              }
              setExtraDescription(null);
            }
          } else {
            setExtraDescription(null);
          }
        } else {
          setDescription(null);
          setExtraDescription(null);
          setTitle(t('deepLink_ErrorMissingUrl'));
        }
        setCta(t('deepLink_GoToTheHomePageButton'));
        return;
      }
      await updateStateFromUrl(urlStr, setDescription, setExtraDescription, setIsLoading, setRoute, setTitle, setCta, t, abortController);
    };
    processDeepLink();

    // Cleanup function
    return () => abortController.abort();
  }, [location.search, t]);

  // Cleanup on unmount
  (0, _react.useEffect)(() => () => {
    var _abortControllerRef$c2;
    return (_abortControllerRef$c2 = abortControllerRef.current) === null || _abortControllerRef$c2 === void 0 ? void 0 : _abortControllerRef$c2.abort();
  }, []);
  function onRemindMeStateChanged() {
    const newValue = !skipDeepLinkInterstitialChecked;
    setSkipDeepLinkInterstitialChecked(newValue);
    dispatch((0, _actions.setSkipDeepLinkInterstitial)(newValue));
  }
  return /*#__PURE__*/_react.default.createElement(_container.Container, {
    maxWidth: _componentLibrary.ContainerMaxWidth.Sm,
    textAlign: _designSystem.TextAlign.Center,
    marginLeft: 6,
    marginRight: 6,
    marginBottom: 8
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_box.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column
  }, /*#__PURE__*/_react.default.createElement("img", {
    className: "loading-logo",
    src: "./images/logo/metamask-fox.svg"
  }), isLoading && /*#__PURE__*/_react.default.createElement("img", {
    "data-testid": "loading-indicator",
    className: "loading-spinner",
    src: "./images/spinner.gif",
    alt: ""
  })), !isLoading && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, title && /*#__PURE__*/_react.default.createElement(_text.Text, {
    as: "h1",
    variant: _designSystem.TextVariant.headingLg,
    fontWeight: _designSystem.FontWeight.Medium,
    marginTop: 12,
    marginBottom: 8
  }, title), description && /*#__PURE__*/_react.default.createElement(_box.Box, {
    as: "div",
    "data-testid": "deep-link-description",
    paddingBottom: 12
  }, /*#__PURE__*/_react.default.createElement(_box.Box, {
    as: "div",
    key: "description"
  }, description), extraDescription ? /*#__PURE__*/_react.default.createElement(_box.Box, {
    key: "extra-description",
    paddingTop: 4
  }, extraDescription) : ''), /*#__PURE__*/_react.default.createElement(_box.Box, {
    marginTop: 12
  }, route !== null && route !== void 0 && route.signed ? /*#__PURE__*/_react.default.createElement(_box.Box, {
    display: _designSystem.Display.Flex,
    textAlign: _designSystem.TextAlign.Left,
    gap: 2,
    padding: 3,
    marginBottom: 6,
    borderRadius: _designSystem.BorderRadius.XL,
    backgroundColor: _designSystem.BackgroundColor.backgroundMuted
  }, /*#__PURE__*/_react.default.createElement(_checkbox.Checkbox, {
    id: "dont-remind-me-checkbox",
    "data-testid": "deep-link-checkbox",
    isChecked: skipDeepLinkInterstitialChecked,
    onChange: onRemindMeStateChanged
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Label, {
    htmlFor: "dont-remind-me-checkbox",
    fontWeight: _designSystem.FontWeight.Normal,
    variant: _designSystem.TextVariant.bodySm
  }, t('deepLink_DontRemindMeAgain'))) : '', /*#__PURE__*/_react.default.createElement(_button.Button, {
    width: _designSystem.BlockSize.Full,
    variant: _button.ButtonVariant.Primary,
    href: (route === null || route === void 0 ? void 0 : route.href) ?? getExtensionURL('/'),
    size: _button.ButtonSize.Lg,
    "data-testid": "deep-link-continue-button"
  }, cta)))));
};
exports.DeepLink = DeepLink;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\deep-link\\deep-link.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\defi\\components\\defi-details-list.tsx", {"../../../components/app/assets/token-cell":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\token-cell\\index.ts","../../../components/app/assets/util/getTokenAvatarUrl":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\util\\getTokenAvatarUrl.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../settings/networks-tab/networks-form/use-safe-chains":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\networks-tab\\networks-form\\use-safe-chains.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cdefi%5Ccomponents%5Cdefi-details-list.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.PositionTypeLabels = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../../components/component-library");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _tokenCell = _interopRequireDefault(require("../../../components/app/assets/token-cell"));
var _selectors = require("../../../selectors");
var _useSafeChains = require("../../settings/networks-tab/networks-form/use-safe-chains");
var _getTokenAvatarUrl = require("../../../components/app/assets/util/getTokenAvatarUrl");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PositionTypeLabels = exports.PositionTypeLabels = {
  supply: 'supplied',
  stake: 'staked',
  borrow: 'borrowed',
  reward: 'rewards'
};
const DefiDetailsList = /*#__PURE__*/_react.default.memo(({
  tokens,
  positionType,
  chainId
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    privacyMode
  } = (0, _reactRedux.useSelector)(_selectors.getPreferences);
  const groupedTokens = (0, _react.useMemo)(() => {
    return tokens.map(tokenGroup => {
      return tokenGroup.reduce((acc, token) => {
        if (token.type === 'underlying') {
          acc.underlying.push(token);
        } else if (token.type === 'underlying-claimable') {
          acc.underlyingRewards.push(token);
        }
        return acc;
      }, {
        underlying: [],
        underlyingRewards: []
      });
    });
  }, [tokens]);
  const mapTokenToCell = token => {
    return {
      address: token.address,
      title: token.symbol,
      symbol: token.name,
      tokenFiatAmount: token.marketValue,
      image: (0, _getTokenAvatarUrl.getTokenAvatarUrl)(token),
      balance: token.balance.toString(),
      secondary: token.balance,
      string: token.balance.toString(),
      decimals: 10,
      chainId
    };
  };
  const {
    safeChains
  } = (0, _useSafeChains.useSafeChains)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, groupedTokens.map(({
    underlying,
    underlyingRewards
  }, index) => {
    const tokenGroups = [{
      type: 'underlying',
      tokenGroup: underlying
    }, {
      type: 'underlyingRewards',
      tokenGroup: underlyingRewards
    }];
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      key: index
    }, tokenGroups.map(({
      type,
      tokenGroup
    }) => {
      if (!tokenGroup || tokenGroup.length === 0) {
        return null;
      }
      const label = type === 'underlying' ? t(PositionTypeLabels[positionType] || positionType) : t('reward');
      return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        key: type
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        variant: _designSystem.TextVariant.bodyMdMedium,
        paddingLeft: 4,
        color: _designSystem.TextColor.textAlternative,
        "data-testid": `defi-details-list-${positionType}-position`
      }, label), tokenGroup.map(token => /*#__PURE__*/_react.default.createElement(_tokenCell.default, {
        key: `${chainId}-${token.address}`,
        token: mapTokenToCell(token),
        privacyMode: privacyMode,
        onClick: undefined,
        fixCurrencyToUSD: true,
        safeChains: safeChains
      })));
    }), index !== groupedTokens.length - 1 && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      paddingLeft: 4,
      paddingBottom: 4,
      paddingRight: 4
    }, /*#__PURE__*/_react.default.createElement("hr", {
      style: {
        border: '1px solid var(--border-muted, #858B9A33)'
      }
    })));
  }));
});
var _default = exports.default = DefiDetailsList;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\defi\\components\\defi-details-list.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\defi\\components\\defi-details-page.tsx", {"../../../components/app/assets/asset-list/cells/asset-cell-badge":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\asset-list\\cells\\asset-cell-badge.tsx","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../hooks/useFormatters":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useFormatters.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/assets":"D:\\code\\v\\metamask-extension\\ui\\selectors\\assets.ts","./defi-details-list":"D:\\code\\v\\metamask-extension\\ui\\pages\\defi\\components\\defi-details-list.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cdefi%5Ccomponents%5Cdefi-details-page.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../../components/component-library");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _routes = require("../../../helpers/constants/routes");
var _selectors = require("../../../selectors");
var _useFormatters = require("../../../hooks/useFormatters");
var _assetCellBadge = require("../../../components/app/assets/asset-list/cells/asset-cell-badge");
var _assets = require("../../../selectors/assets");
var _defiDetailsList = _interopRequireWildcard(require("./defi-details-list"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useExtractUnderlyingTokens = positions => (0, _react.useMemo)(() => {
  if (!positions) {
    return [[]];
  }
  return positions.map(group => group.flatMap(position => position.tokens.map(token => token)));
}, [positions]);
const DeFiPage = () => {
  var _defiPositions$select;
  const {
    chainId,
    protocolId
  } = (0, _reactRouterDom.useParams)();
  const {
    formatCurrencyWithMinThreshold
  } = (0, _useFormatters.useFormatters)();
  const defiPositions = (0, _reactRedux.useSelector)(_assets.getDefiPositions);
  const selectedAccount = (0, _reactRedux.useSelector)(_selectors.getSelectedAccount);
  const history = (0, _reactRouterDom.useHistory)();
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    privacyMode
  } = (0, _reactRedux.useSelector)(_selectors.getPreferences);

  // TODO: Get value in user's preferred currency
  const protocolPosition = (_defiPositions$select = defiPositions[selectedAccount.address]) === null || _defiPositions$select === void 0 || (_defiPositions$select = _defiPositions$select[chainId]) === null || _defiPositions$select === void 0 ? void 0 : _defiPositions$select.protocols[protocolId];
  const extractedTokens = (0, _react.useMemo)(() => {
    return Object.keys((protocolPosition === null || protocolPosition === void 0 ? void 0 : protocolPosition.positionTypes) || {}).reduce((acc, positionType) => {
      var _protocolPosition$pos;
      acc[positionType] = (protocolPosition === null || protocolPosition === void 0 || (_protocolPosition$pos = protocolPosition.positionTypes[positionType]) === null || _protocolPosition$pos === void 0 ? void 0 : _protocolPosition$pos.positions) || [];
      return acc;
    }, {});
  }, [protocolPosition]);
  const underlyingDefiTokens = {
    supply: useExtractUnderlyingTokens(extractedTokens.supply),
    borrow: useExtractUnderlyingTokens(extractedTokens.borrow),
    stake: useExtractUnderlyingTokens(extractedTokens.stake),
    reward: useExtractUnderlyingTokens(extractedTokens.reward)
  };
  if (!protocolPosition) {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: {
        pathname: _routes.DEFAULT_ROUTE
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "main-container asset__container"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 2,
    display: _designSystem.Display.Flex,
    paddingBottom: 4,
    paddingTop: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    "data-testid": "defi-details-page-back-button",
    color: _designSystem.IconColor.iconAlternative,
    marginRight: 1,
    size: _componentLibrary.ButtonIconSize.Sm,
    ariaLabel: t('back'),
    iconName: _componentLibrary.IconName.ArrowLeft,
    onClick: () => history.push(_routes.DEFAULT_ROUTE)
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    paddingRight: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingLg,
    paddingLeft: 4,
    paddingBottom: 2,
    "data-testid": "defi-details-page-title"
  }, protocolPosition.protocolDetails.name), /*#__PURE__*/_react.default.createElement(_assetCellBadge.AssetCellBadge, {
    chainId: chainId,
    tokenImage: protocolPosition.protocolDetails.iconUrl,
    symbol: protocolPosition.protocolDetails.name,
    "data-testid": "defi-details-page-protocol-badge"
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 4,
    paddingBottom: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.SensitiveText, {
    "data-testid": "defi-details-page-market-value",
    className: "mm-box--color-text-alternative",
    ellipsis: true,
    variant: _designSystem.TextVariant.inherit,
    isHidden: privacyMode,
    length: _componentLibrary.SensitiveTextLength.Medium
  }, formatCurrencyWithMinThreshold(protocolPosition.aggregatedMarketValue, 'USD'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 4,
    paddingBottom: 4,
    paddingRight: 4
  }, /*#__PURE__*/_react.default.createElement("hr", {
    style: {
      border: '1px solid var(--border-muted, #858B9A33)'
    }
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column
  }, Object.keys(_defiDetailsList.PositionTypeLabels).map(positionType => protocolPosition.positionTypes[positionType] ? /*#__PURE__*/_react.default.createElement(_defiDetailsList.default, {
    key: positionType,
    tokens: underlyingDefiTokens[positionType],
    positionType: positionType,
    chainId: chainId
  }) : null)));
};
var _default = exports.default = DeFiPage;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\defi\\components\\defi-details-page.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\defi\\index.ts", {"./components/defi-details-page":"D:\\code\\v\\metamask-extension\\ui\\pages\\defi\\components\\defi-details-page.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cdefi%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _defiDetailsPage.default;
  }
});
var _defiDetailsPage = _interopRequireDefault(require("./components/defi-details-page"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\defi\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\error-page\\error-page.component.tsx", {"../../components/app/modals/visit-support-data-consent-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\visit-support-data-consent-modal\\index.ts","../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../components/component-library/button/button.types":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\button\\button.types.ts","../../components/component-library/textarea/textarea":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\textarea\\textarea.tsx","../../components/component-library/textarea/textarea.types":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\textarea\\textarea.types.ts","../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","webextension-polyfill":"D:\\code\\v\\metamask-extension\\node_modules\\webextension-polyfill\\dist\\browser-polyfill.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cerror-page%5Cerror-page.component.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _webextensionPolyfill = _interopRequireDefault(require("webextension-polyfill"));
var _selectors = require("../../selectors");
var _useI18nContext = require("../../hooks/useI18nContext");
var _componentLibrary = require("../../components/component-library");
var _designSystem = require("../../helpers/constants/design-system");
var _textarea = require("../../components/component-library/textarea/textarea");
var _textarea2 = require("../../components/component-library/textarea/textarea.types");
var _button = require("../../components/component-library/button/button.types");
var _visitSupportDataConsentModal = _interopRequireDefault(require("../../components/app/modals/visit-support-data-consent-modal"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ErrorPage = ({
  error
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const isMetaMetricsEnabled = (0, _reactRedux.useSelector)(_selectors.getParticipateInMetaMetrics);
  const [feedbackMessage, setFeedbackMessage] = (0, _react.useState)('');
  const [isFeedbackModalOpen, setIsFeedbackModalOpen] = (0, _react.useState)(false);
  const [isSuccessModalShown, setIsSuccessModalShown] = (0, _react.useState)(false);
  const [isSupportDataConsentModalOpen, setIsSupportDataConsentModalOpen] = (0, _react.useState)(false);
  const handleClickDescribeButton = () => {
    setIsFeedbackModalOpen(true);
  };
  const handleCloseDescribeModal = () => {
    setIsFeedbackModalOpen(false);
  };
  const handleSubmitFeedback = e => {
    var _globalThis$sentry, _globalThis$sentry$la, _globalThis$sentry2, _globalThis$sentry2$c;
    e.preventDefault();
    const eventId = globalThis === null || globalThis === void 0 || (_globalThis$sentry = globalThis.sentry) === null || _globalThis$sentry === void 0 || (_globalThis$sentry$la = _globalThis$sentry.lastEventId) === null || _globalThis$sentry$la === void 0 ? void 0 : _globalThis$sentry$la.call(_globalThis$sentry);
    globalThis === null || globalThis === void 0 || (_globalThis$sentry2 = globalThis.sentry) === null || _globalThis$sentry2 === void 0 || (_globalThis$sentry2$c = _globalThis$sentry2.captureFeedback) === null || _globalThis$sentry2$c === void 0 || _globalThis$sentry2$c.call(_globalThis$sentry2, {
      message: feedbackMessage,
      associatedEventId: eventId
    });
    handleCloseDescribeModal();
    setIsSuccessModalShown(true);
  };
  (0, _react.useEffect)(() => {
    if (isSuccessModalShown) {
      const timeoutId = setTimeout(() => {
        setIsSuccessModalShown(false); // Close the modal after 5 seconds
      }, 5000);

      // Cleanup function to clear timeout if the component unmounts or state changes
      return () => clearTimeout(timeoutId);
    }
    return undefined;
  }, [isSuccessModalShown]);
  return /*#__PURE__*/_react.default.createElement("section", {
    className: "error-page"
  }, /*#__PURE__*/_react.default.createElement("section", {
    className: "error-page__inner-wrapper"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "error-page__header",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.Danger,
    size: _componentLibrary.IconSize.Xl,
    color: _designSystem.IconColor.warningDefault
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.inherit,
    variant: _designSystem.TextVariant.headingMd,
    marginBottom: 4
  }, t('errorPageTitle'))), /*#__PURE__*/_react.default.createElement("div", {
    className: "error-page__banner-wrapper"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerAlert, {
    childrenWrapperProps: {
      color: _designSystem.TextColor.inherit
    },
    marginBottom: 4
  }, t('errorPageInfo'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.inherit,
    variant: _designSystem.TextVariant.bodyMd
  }, t('errorPageMessageTitle')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    borderRadius: _designSystem.BorderRadius.LG,
    marginBottom: 2,
    marginTop: 2,
    backgroundColor: _designSystem.BackgroundColor.errorMuted,
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    padding: 2,
    className: "error-page__error-message-wrapper"
  }, error.message ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyXs,
    marginBottom: 2,
    "data-testid": "error-page-error-message",
    color: _designSystem.TextColor.inherit
  }, t('errorMessage', [error.message])) : null, error.code ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyXs,
    marginBottom: 2,
    "data-testid": "error-page-error-code",
    color: _designSystem.TextColor.inherit
  }, t('errorCode', [error.code])) : null, error.name ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyXs,
    marginBottom: 2,
    "data-testid": "error-page-error-name",
    color: _designSystem.TextColor.inherit
  }, t('errorName', [error.name])) : null, error.stack ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.inherit,
    variant: _designSystem.TextVariant.bodyXs,
    marginBottom: 2
  }, t('errorStack')), /*#__PURE__*/_react.default.createElement("pre", {
    className: "error-page__stack",
    "data-testid": "error-page-error-stack"
  }, error.stack)) : null), isFeedbackModalOpen && /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: isFeedbackModalOpen,
    onClose: handleCloseDescribeModal,
    "data-testid": "error-page-sentry-feedback-modal"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onClose: handleCloseDescribeModal
  }, t('errorPageSentryFormTitle')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, null, /*#__PURE__*/_react.default.createElement(_textarea.Textarea, {
    resize: _textarea2.TextareaResize.Vertical,
    required: true,
    autoFocus: true,
    cols: 32,
    rows: 6,
    placeholder: t('errorPageSentryMessagePlaceholder'),
    onChange: e => setFeedbackMessage(e.target.value),
    "data-testid": "error-page-sentry-feedback-textarea"
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalFooter, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    variant: _componentLibrary.ButtonVariant.Secondary,
    width: _designSystem.BlockSize.Half,
    onClick: handleCloseDescribeModal,
    size: _button.ButtonSize.Md
  }, t('cancel')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    variant: _componentLibrary.ButtonVariant.Primary,
    width: _designSystem.BlockSize.Half,
    onClick: handleSubmitFeedback,
    size: _button.ButtonSize.Md,
    "data-testid": "error-page-sentry-feedback-submit-button"
  }, t('submit')))))), isSuccessModalShown && /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: isSuccessModalShown,
    onClose: () => setIsSuccessModalShown(false),
    "data-testid": "error-page-sentry-feedback-success-modal"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.CheckBold,
    color: _designSystem.IconColor.successDefault,
    size: _componentLibrary.IconSize.Md,
    marginRight: 2
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: _designSystem.TextColor.successDefault
  }, t('errorPageSentrySuccessMessageText'))))), isSupportDataConsentModalOpen && /*#__PURE__*/_react.default.createElement(_visitSupportDataConsentModal.default, {
    isOpen: isSupportDataConsentModalOpen,
    onClose: () => setIsSupportDataConsentModalOpen(false)
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    width: _designSystem.BlockSize.Full,
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    marginTop: 4
  }, isMetaMetricsEnabled && /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    className: "error-page__report-to-sentry-button",
    marginBottom: 2,
    block: true,
    "data-testid": "error-page-describe-what-happened-button",
    onClick: handleClickDescribeButton
  }, t('errorPageDescribeUsWhatHappened')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    marginBottom: 2,
    variant: _componentLibrary.ButtonVariant.Secondary,
    block: true,
    "data-testid": "error-page-contact-support-button",
    onClick: () => setIsSupportDataConsentModalOpen(true)
  }, t('errorPageContactSupport')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    variant: _componentLibrary.ButtonVariant.Secondary,
    block: true,
    "data-testid": "error-page-try-again-button"
    // TODO: should this be a safe reload via the `WriteManager`?
    ,
    onClick: () => _webextensionPolyfill.default.runtime.reload()
  }, t('errorPageTryAgain')))));
};
var _default = exports.default = ErrorPage;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\error-page\\error-page.component.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\home\\home.component.js", {"../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../shared/constants/onboarding":"D:\\code\\v\\metamask-extension\\shared\\constants\\onboarding.ts","../../../shared/constants/time":"D:\\code\\v\\metamask-extension\\shared\\constants\\time.ts","../../../shared/lib/ui-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\ui-utils.js","../../../shared/modules/mv3.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\mv3.utils.js","../../components/app/connections-removed-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\connections-removed-modal\\index.ts","../../components/app/home-notification":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\home-notification\\index.js","../../components/app/multi-rpc-edit-modal/multi-rpc-edit-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\multi-rpc-edit-modal\\multi-rpc-edit-modal.tsx","../../components/app/multiple-notifications":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\multiple-notifications\\index.js","../../components/app/password-outdated-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\password-outdated-modal\\index.ts","../../components/app/recovery-phrase-reminder":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\recovery-phrase-reminder\\index.js","../../components/app/shield-entry-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\shield-entry-modal\\index.ts","../../components/app/terms-of-use-popup":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\terms-of-use-popup\\index.js","../../components/app/update-modal/update-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\update-modal\\update-modal.tsx","../../components/app/whats-new-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\whats-new-modal\\index.ts","../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../components/multichain/account-overview":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-overview\\index.js","../../components/ui/actionable-message/actionable-message":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\actionable-message\\actionable-message.js","../../components/ui/button":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\button\\index.js","../../components/ui/popover":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\popover\\index.js","../../components/ui/typography/typography":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\typography\\typography.js","../../helpers/constants/common":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\common.ts","../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../helpers/constants/zendesk-url":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\zendesk-url.js","../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../confirmations/hooks/useConfirmationNavigation":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useConfirmationNavigation.ts","../connected-accounts":"D:\\code\\v\\metamask-extension\\ui\\pages\\connected-accounts\\index.js","../connected-sites":"D:\\code\\v\\metamask-extension\\ui\\pages\\connected-sites\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Chome%5Chome.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRouterDom = require("react-router-dom");
var _metametrics = require("../../../shared/constants/metametrics");
var _termsOfUsePopup = _interopRequireDefault(require("../../components/app/terms-of-use-popup"));
var _recoveryPhraseReminder = _interopRequireDefault(require("../../components/app/recovery-phrase-reminder"));
var _whatsNewModal = _interopRequireDefault(require("../../components/app/whats-new-modal"));
var _onboarding = require("../../../shared/constants/onboarding");
var _homeNotification = _interopRequireDefault(require("../../components/app/home-notification"));
var _multipleNotifications = _interopRequireDefault(require("../../components/app/multiple-notifications"));
var _typography = _interopRequireDefault(require("../../components/ui/typography/typography"));
var _button = _interopRequireDefault(require("../../components/ui/button"));
var _popover = _interopRequireDefault(require("../../components/ui/popover"));
var _connectedSites = _interopRequireDefault(require("../connected-sites"));
var _connectedAccounts = _interopRequireDefault(require("../connected-accounts"));
var _mv = require("../../../shared/modules/mv3.utils");
var _actionableMessage = _interopRequireDefault(require("../../components/ui/actionable-message/actionable-message"));
var _designSystem = require("../../helpers/constants/design-system");
var _time = require("../../../shared/constants/time");
var _componentLibrary = require("../../components/component-library");
var _multiRpcEditModal = _interopRequireDefault(require("../../components/app/multi-rpc-edit-modal/multi-rpc-edit-modal"));
var _updateModal = _interopRequireDefault(require("../../components/app/update-modal/update-modal"));
var _routes = require("../../helpers/constants/routes");
var _zendeskUrl = _interopRequireDefault(require("../../helpers/constants/zendesk-url"));
var _common = require("../../helpers/constants/common");
var _uiUtils = require("../../../shared/lib/ui-utils");
var _accountOverview = require("../../components/multichain/account-overview");
var _actions = require("../../store/actions");
var _useConfirmationNavigation = require("../confirmations/hooks/useConfirmationNavigation");
var _passwordOutdatedModal = _interopRequireDefault(require("../../components/app/password-outdated-modal"));
var _connectionsRemovedModal = _interopRequireDefault(require("../../components/app/connections-removed-modal"));
var _shieldEntryModal = _interopRequireDefault(require("../../components/app/shield-entry-modal"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function shouldCloseNotificationPopup({
  isNotification,
  totalUnapprovedCount,
  hasApprovalFlows,
  isSigningQRHardwareTransaction
}) {
  const shouldClose = isNotification && totalUnapprovedCount === 0 && !hasApprovalFlows && !isSigningQRHardwareTransaction;
  return shouldClose;
}
class Home extends _react.PureComponent {
  constructor(props) {
    var _location$state;
    super(props);
    _defineProperty(this, "state", {
      canShowBlockageNotification: true,
      notificationClosing: false,
      redirecting: false
    });
    _defineProperty(this, "onRecoveryPhraseReminderClose", () => {
      const {
        setRecoveryPhraseReminderHasBeenShown,
        setRecoveryPhraseReminderLastShown
      } = this.props;
      setRecoveryPhraseReminderHasBeenShown(true);
      setRecoveryPhraseReminderLastShown(new Date().getTime());
    });
    _defineProperty(this, "onAcceptTermsOfUse", () => {
      const {
        setTermsOfUseLastAgreed
      } = this.props;
      setTermsOfUseLastAgreed(new Date().getTime());
      this.context.trackEvent({
        category: _metametrics.MetaMetricsEventCategory.Onboarding,
        event: _metametrics.MetaMetricsEventName.TermsOfUseAccepted,
        properties: {
          location: 'Terms Of Use Popover'
        }
      });
    });
    ///: BEGIN:ONLY_INCLUDE_IF(build-main)
    _defineProperty(this, "onSupportLinkClick", () => {
      this.context.trackEvent({
        category: _metametrics.MetaMetricsEventCategory.Home,
        event: _metametrics.MetaMetricsEventName.SupportLinkClicked,
        properties: {
          url: _uiUtils.SUPPORT_LINK
        }
      }, {
        contextPropsIntoEventProperties: [_metametrics.MetaMetricsContextProp.PageTitle]
      });
    });
    ///: END:ONLY_INCLUDE_IF
    _defineProperty(this, "onOutdatedBrowserWarningClose", () => {
      const {
        setOutdatedBrowserWarningLastShown
      } = this.props;
      setOutdatedBrowserWarningLastShown(new Date().getTime());
    });
    _defineProperty(this, "renderOnboardingPopover", () => {
      const {
        t
      } = this.context;
      const {
        setDataCollectionForMarketing
      } = this.props;
      const handleClose = () => {
        setDataCollectionForMarketing(false);
        this.context.trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Home,
          event: _metametrics.MetaMetricsEventName.AnalyticsPreferenceSelected,
          properties: {
            has_marketing_consent: false,
            location: 'marketing_consent_modal'
          }
        });
      };
      const handleConsent = consent => {
        setDataCollectionForMarketing(consent);
        this.context.trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Home,
          event: _metametrics.MetaMetricsEventName.AnalyticsPreferenceSelected,
          properties: {
            has_marketing_consent: consent,
            location: 'marketing_consent_modal'
          }
        });
      };
      return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
        isOpen: true,
        onClose: handleClose
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
        onClose: handleClose,
        display: _designSystem.Display.Flex,
        flexDirection: _designSystem.FlexDirection.Row,
        fontWeight: _designSystem.FontWeight.Bold,
        alignItems: _designSystem.AlignItems.center,
        justifyContent: _designSystem.JustifyContent.center,
        gap: 4,
        size: 18,
        paddingBottom: 0
      }, t('onboardedMetametricsTitle')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        display: _designSystem.Display.Flex,
        flexDirection: _designSystem.FlexDirection.Column,
        gap: 2,
        margin: 4
      }, /*#__PURE__*/_react.default.createElement(_typography.default, null, t('onboardedMetametricsParagraph1', [/*#__PURE__*/_react.default.createElement("a", {
        href: _common.METAMETRICS_SETTINGS_LINK,
        target: "_blank",
        rel: "noopener noreferrer",
        key: "retention-link"
      }, t('onboardedMetametricsLink'))])), /*#__PURE__*/_react.default.createElement(_typography.default, null, t('onboardedMetametricsParagraph2')), /*#__PURE__*/_react.default.createElement("ul", {
        className: "home__onboarding_list"
      }, /*#__PURE__*/_react.default.createElement("li", null, t('onboardedMetametricsKey1')), /*#__PURE__*/_react.default.createElement("li", null, t('onboardedMetametricsKey2')), /*#__PURE__*/_react.default.createElement("li", null, t('onboardedMetametricsKey3'))), /*#__PURE__*/_react.default.createElement(_typography.default, null, t('onboardedMetametricsParagraph3')))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalFooter, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        display: _designSystem.Display.Flex,
        flexDirection: _designSystem.FlexDirection.Row,
        gap: 2,
        width: _designSystem.BlockSize.Full
      }, /*#__PURE__*/_react.default.createElement(_button.default, {
        type: "secondary",
        onClick: () => handleConsent(false)
      }, t('onboardedMetametricsDisagree')), /*#__PURE__*/_react.default.createElement(_button.default, {
        type: "primary",
        onClick: () => handleConsent(true)
      }, t('onboardedMetametricsAccept'))))));
    });
    _defineProperty(this, "renderPopover", () => {
      const {
        setConnectedStatusPopoverHasBeenShown
      } = this.props;
      const {
        t
      } = this.context;
      return /*#__PURE__*/_react.default.createElement(_popover.default, {
        title: t('whatsThis'),
        onClose: setConnectedStatusPopoverHasBeenShown,
        className: "home__connected-status-popover",
        showArrow: true,
        CustomBackground: ({
          onClose
        }) => {
          return /*#__PURE__*/_react.default.createElement("div", {
            className: "home__connected-status-popover-bg-container",
            onClick: onClose
          }, /*#__PURE__*/_react.default.createElement("div", {
            className: "home__connected-status-popover-bg"
          }));
        },
        footer: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("a", {
          href: _zendeskUrl.default.USER_GUIDE_DAPPS,
          target: "_blank",
          rel: "noopener noreferrer"
        }, t('learnMoreUpperCase')), /*#__PURE__*/_react.default.createElement(_button.default, {
          type: "primary",
          onClick: setConnectedStatusPopoverHasBeenShown
        }, t('dismiss')))
      }, /*#__PURE__*/_react.default.createElement("main", {
        className: "home__connect-status-text"
      }, /*#__PURE__*/_react.default.createElement("div", null, t('metaMaskConnectStatusParagraphOne')), /*#__PURE__*/_react.default.createElement("div", null, t('metaMaskConnectStatusParagraphTwo')), /*#__PURE__*/_react.default.createElement("div", null, t('metaMaskConnectStatusParagraphThree'))));
    });
    const {
      attemptCloseNotificationPopup,
      haveSwapsQuotes,
      haveBridgeQuotes,
      isNotification,
      pendingApprovals,
      showAwaitingSwapScreen,
      swapsFetchParams,
      location
    } = this.props;
    const stayOnHomePage = Boolean(location === null || location === void 0 || (_location$state = location.state) === null || _location$state === void 0 ? void 0 : _location$state.stayOnHomePage);
    if (shouldCloseNotificationPopup(props)) {
      this.state.notificationClosing = true;
      attemptCloseNotificationPopup();
    } else if (pendingApprovals.length || !isNotification && !stayOnHomePage && (showAwaitingSwapScreen || haveSwapsQuotes || swapsFetchParams || haveBridgeQuotes)) {
      this.state.redirecting = true;
    }
  }
  checkStatusAndNavigate() {
    var _location$state2;
    const {
      history,
      isNotification,
      haveSwapsQuotes,
      haveBridgeQuotes,
      showAwaitingSwapScreen,
      swapsFetchParams,
      location,
      pendingApprovals,
      hasApprovalFlows
    } = this.props;
    const stayOnHomePage = Boolean(location === null || location === void 0 || (_location$state2 = location.state) === null || _location$state2 === void 0 ? void 0 : _location$state2.stayOnHomePage);
    const canRedirect = !isNotification && !stayOnHomePage;
    if (canRedirect && showAwaitingSwapScreen) {
      history.push(_routes.AWAITING_SWAP_ROUTE);
    } else if (canRedirect && (haveSwapsQuotes || swapsFetchParams)) {
      history.push(_routes.PREPARE_SWAP_ROUTE);
    } else if (canRedirect && haveBridgeQuotes) {
      history.push(_routes.CROSS_CHAIN_SWAP_ROUTE + _routes.PREPARE_SWAP_ROUTE);
    } else if (pendingApprovals.length || hasApprovalFlows) {
      var _pendingApprovals$;
      (0, _useConfirmationNavigation.navigateToConfirmation)(pendingApprovals === null || pendingApprovals === void 0 || (_pendingApprovals$ = pendingApprovals[0]) === null || _pendingApprovals$ === void 0 ? void 0 : _pendingApprovals$.id, pendingApprovals, hasApprovalFlows, history);
    }
  }
  checkRedirectAfterDefaultPage() {
    const {
      redirectAfterDefaultPage,
      history,
      clearRedirectAfterDefaultPage,
      setAccountDetailsAddress
    } = this.props;
    if (redirectAfterDefaultPage !== null && redirectAfterDefaultPage !== void 0 && redirectAfterDefaultPage.shouldRedirect && redirectAfterDefaultPage !== null && redirectAfterDefaultPage !== void 0 && redirectAfterDefaultPage.path) {
      // Set the account details address if provided
      if (redirectAfterDefaultPage !== null && redirectAfterDefaultPage !== void 0 && redirectAfterDefaultPage.address) {
        setAccountDetailsAddress(redirectAfterDefaultPage.address);
      }
      history.push(redirectAfterDefaultPage.path);
      clearRedirectAfterDefaultPage();
    }
  }
  componentDidMount() {
    this.checkStatusAndNavigate();
    this.props.fetchBuyableChains();

    // Check for redirect after default page
    this.checkRedirectAfterDefaultPage();

    // Ensure we have up-to-date connectivity statuses for all enabled networks
    this.props.lookupSelectedNetworks();
  }
  static getDerivedStateFromProps(props) {
    if (shouldCloseNotificationPopup(props)) {
      return {
        notificationClosing: true
      };
    }
    return null;
  }
  componentDidUpdate(_prevProps, prevState) {
    const {
      attemptCloseNotificationPopup,
      isNotification,
      hasAllowedPopupRedirectApprovals,
      newNetworkAddedConfigurationId,
      setActiveNetwork,
      clearNewNetworkAdded
    } = this.props;
    const {
      newNetworkAddedConfigurationId: prevNewNetworkAddedConfigurationId
    } = _prevProps;
    const {
      notificationClosing
    } = this.state;
    if (newNetworkAddedConfigurationId && prevNewNetworkAddedConfigurationId !== newNetworkAddedConfigurationId) {
      setActiveNetwork(newNetworkAddedConfigurationId);
      clearNewNetworkAdded();
    }
    if (notificationClosing && !prevState.notificationClosing) {
      attemptCloseNotificationPopup();
    } else if (isNotification || hasAllowedPopupRedirectApprovals) {
      this.checkStatusAndNavigate();
    }

    // Check for redirect after default page on updates
    this.checkRedirectAfterDefaultPage();
  }
  renderNotifications() {
    const {
      t
    } = this.context;
    const {
      history,
      shouldShowSeedPhraseReminder,
      isPopup,
      shouldShowWeb3ShimUsageNotification,
      setWeb3ShimUsageAlertDismissed,
      originOfCurrentTab,
      disableWeb3ShimUsageAlert,
      infuraBlocked,
      showOutdatedBrowserWarning,
      newNftAddedMessage,
      setNewNftAddedMessage,
      newNetworkAddedName,
      editedNetwork,
      removeNftMessage,
      setRemoveNftMessage,
      newTokensImported,
      newTokensImportedError,
      setNewTokensImported,
      setNewTokensImportedError,
      clearNewNetworkAdded,
      clearEditedNetwork,
      isPrimarySeedPhraseBackedUp
    } = this.props;
    const onAutoHide = () => {
      setNewNftAddedMessage('');
      setRemoveNftMessage('');
      setNewTokensImported(''); // Added this so we dnt see the notif if user does not close it
      setNewTokensImportedError('');
      (0, _actions.setEditedNetwork)();
    };
    const autoHideDelay = 5 * _time.SECOND;
    const outdatedBrowserNotificationDescriptionText = _mv.isMv3ButOffscreenDocIsMissing ? /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, null, t('outdatedBrowserNotification')), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      fontWeight: _designSystem.FontWeight.Bold,
      color: _designSystem.TextColor.warningDefault
    }, t('noHardwareWalletOrSnapsSupport'))) : t('outdatedBrowserNotification');
    const items = [newNftAddedMessage === 'success' ? /*#__PURE__*/_react.default.createElement(_actionableMessage.default, {
      key: "new-nft-added",
      type: "success",
      className: "home__new-network-notification",
      autoHideTime: autoHideDelay,
      onAutoHide: onAutoHide,
      message: /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        display: _designSystem.Display.InlineFlex
      }, /*#__PURE__*/_react.default.createElement("i", {
        className: "fa fa-check-circle home__new-nft-notification-icon"
      }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        variant: _designSystem.TextVariant.bodySm,
        as: "h6"
      }, t('newNftAddedMessage')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
        iconName: _componentLibrary.IconName.Close,
        size: _componentLibrary.ButtonIconSize.Sm,
        ariaLabel: t('close'),
        onClick: onAutoHide
      }))
    }) : null, removeNftMessage === 'success' ? /*#__PURE__*/_react.default.createElement(_actionableMessage.default, {
      key: "remove-nft",
      type: "success",
      className: "home__new-network-notification",
      autoHideTime: autoHideDelay,
      onAutoHide: onAutoHide,
      message: /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        display: _designSystem.Display.InlineFlex
      }, /*#__PURE__*/_react.default.createElement("i", {
        className: "fa fa-check-circle home__new-nft-notification-icon"
      }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        variant: _designSystem.TextVariant.bodySm,
        as: "h6"
      }, t('removeNftMessage')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
        iconName: _componentLibrary.IconName.Close,
        size: _componentLibrary.ButtonIconSize.Sm,
        ariaLabel: t('close'),
        onClick: onAutoHide
      }))
    }) : null, removeNftMessage === 'error' ? /*#__PURE__*/_react.default.createElement(_actionableMessage.default, {
      key: "remove-nft-error",
      type: "danger",
      className: "home__new-network-notification",
      autoHideTime: autoHideDelay,
      onAutoHide: onAutoHide,
      message: /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        display: _designSystem.Display.InlineFlex
      }, /*#__PURE__*/_react.default.createElement("i", {
        className: "fa fa-check-circle home__new-nft-notification-icon"
      }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        variant: _designSystem.TextVariant.bodySm,
        as: "h6"
      }, t('removeNftErrorMessage')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
        iconName: _componentLibrary.IconName.Close,
        size: _componentLibrary.ButtonIconSize.Sm,
        ariaLabel: t('close'),
        onClick: onAutoHide
      }))
    }) : null, newNetworkAddedName ? /*#__PURE__*/_react.default.createElement(_actionableMessage.default, {
      key: "new-network-added",
      type: "success",
      className: "home__new-network-notification",
      message: /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        display: _designSystem.Display.InlineFlex
      }, /*#__PURE__*/_react.default.createElement("i", {
        className: "fa fa-check-circle home__new-network-notification-icon"
      }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        variant: _designSystem.TextVariant.bodySm,
        as: "h6"
      }, t('newNetworkAdded', [newNetworkAddedName])), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
        iconName: _componentLibrary.IconName.Close,
        size: _componentLibrary.ButtonIconSize.Sm,
        ariaLabel: t('close'),
        onClick: () => clearNewNetworkAdded(),
        className: "home__new-network-notification-close"
      }))
    }) : null, editedNetwork !== null && editedNetwork !== void 0 && editedNetwork.editCompleted ? /*#__PURE__*/_react.default.createElement(_actionableMessage.default, {
      key: "edited-network",
      type: "success",
      className: "home__new-tokens-imported-notification",
      autoHideTime: autoHideDelay,
      onAutoHide: onAutoHide,
      message: /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        display: _designSystem.Display.InlineFlex
      }, /*#__PURE__*/_react.default.createElement("i", {
        className: "fa fa-check-circle home__new-network-notification-icon"
      }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        variant: _designSystem.TextVariant.bodySm,
        as: "h6"
      }, editedNetwork.newNetwork ? t('newNetworkAdded', [editedNetwork.nickname]) : t('newNetworkEdited', [editedNetwork.nickname])), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
        iconName: _componentLibrary.IconName.Close,
        size: _componentLibrary.ButtonIconSize.Sm,
        ariaLabel: t('close'),
        onClick: () => clearEditedNetwork(),
        className: "home__new-network-notification-close"
      }))
    }) : null, newTokensImported ? /*#__PURE__*/_react.default.createElement(_actionableMessage.default, {
      key: "new-tokens-imported",
      type: "success",
      autoHideTime: autoHideDelay,
      onAutoHide: onAutoHide,
      className: "home__new-tokens-imported-notification",
      message: /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        display: _designSystem.Display.InlineFlex
      }, /*#__PURE__*/_react.default.createElement("i", {
        className: "fa fa-check-circle home__new-tokens-imported-notification-icon"
      }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        className: "home__new-tokens-imported-notification-title",
        variant: _designSystem.TextVariant.bodySmBold,
        as: "h6"
      }, t('newTokensImportedTitle')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        className: "home__new-tokens-imported-notification-message",
        variant: _designSystem.TextVariant.bodySm,
        as: "h6"
      }, t('newTokensImportedMessage', [newTokensImported]))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
        iconName: _componentLibrary.IconName.Close,
        size: _componentLibrary.ButtonIconSize.Sm,
        ariaLabel: t('close'),
        onClick: () => setNewTokensImported(''),
        className: "home__new-tokens-imported-notification-close"
      }))
    }) : null, newTokensImportedError ? /*#__PURE__*/_react.default.createElement(_actionableMessage.default, {
      key: "new-tokens-imported-error",
      type: "danger",
      className: "home__new-tokens-imported-notification",
      autoHideTime: autoHideDelay,
      onAutoHide: onAutoHide,
      message: /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        display: _designSystem.Display.InlineFlex
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
        name: _componentLibrary.IconName.Danger
      }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        variant: _designSystem.TextVariant.bodySm,
        as: "h6"
      }, t('importTokensError')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
        iconName: _componentLibrary.IconName.Close,
        size: _componentLibrary.ButtonIconSize.Sm,
        ariaLabel: t('close'),
        onClick: onAutoHide
      }))
    }) : null, shouldShowWeb3ShimUsageNotification ? /*#__PURE__*/_react.default.createElement(_homeNotification.default, {
      key: "show-web3-shim",
      descriptionText: t('web3ShimUsageNotification', [/*#__PURE__*/_react.default.createElement("span", {
        key: "web3ShimUsageNotificationLink",
        className: "home-notification__text-link",
        onClick: () => global.platform.openTab({
          url: _zendeskUrl.default.LEGACY_WEB3
        })
      }, t('here'))]),
      ignoreText: t('dismiss'),
      onIgnore: disable => {
        setWeb3ShimUsageAlertDismissed(originOfCurrentTab);
        if (disable) {
          disableWeb3ShimUsageAlert();
        }
      },
      checkboxText: t('dontShowThisAgain'),
      checkboxTooltipText: t('canToggleInSettings')
    }) : null, !isPrimarySeedPhraseBackedUp && shouldShowSeedPhraseReminder ? /*#__PURE__*/_react.default.createElement(_homeNotification.default, {
      key: "show-seed-phrase-reminder",
      descriptionText: t('backupApprovalNotice'),
      acceptText: t('backupNow'),
      onAccept: () => {
        const backUpSRPRoute = `${_routes.ONBOARDING_REVIEW_SRP_ROUTE}/?isFromReminder=true`;
        if (isPopup) {
          global.platform.openExtensionInBrowser(backUpSRPRoute);
        } else {
          history.push(backUpSRPRoute);
        }
      },
      infoText: t('backupApprovalInfo')
    }) : null, infuraBlocked && this.state.canShowBlockageNotification ? /*#__PURE__*/_react.default.createElement(_homeNotification.default, {
      key: "infura-blocked",
      descriptionText: t('infuraBlockedNotification', [/*#__PURE__*/_react.default.createElement("span", {
        key: "infuraBlockedNotificationLink",
        className: "home-notification__text-link",
        onClick: () => global.platform.openTab({
          url: _zendeskUrl.default.INFURA_BLOCKAGE
        })
      }, t('here'))]),
      ignoreText: t('dismiss'),
      onIgnore: () => {
        this.setState({
          canShowBlockageNotification: false
        });
      }
    }) : null, showOutdatedBrowserWarning ? /*#__PURE__*/_react.default.createElement(_homeNotification.default, {
      key: "outdated-browser-notification",
      descriptionText: outdatedBrowserNotificationDescriptionText,
      acceptText: t('gotIt'),
      onAccept: this.onOutdatedBrowserWarningClose
    }) : null].filter(Boolean);
    return items.length ? /*#__PURE__*/_react.default.createElement(_multipleNotifications.default, null, items) : null;
  }
  render() {
    const {
      defaultHomeActiveTabName,
      onTabClick,
      useExternalServices,
      setBasicFunctionalityModalOpen,
      forgottenPassword,
      participateInMetaMetrics,
      dataCollectionForMarketing,
      connectedStatusPopoverHasBeenShown,
      isPopup,
      showRecoveryPhraseReminder,
      showTermsOfUsePopup,
      showWhatsNewPopup,
      hideWhatsNewPopup,
      completedOnboarding,
      onboardedInThisUISession,
      announcementsToShow,
      firstTimeFlowType,
      newNetworkAddedConfigurationId,
      showMultiRpcModal,
      showUpdateModal,
      isSeedlessPasswordOutdated,
      isPrimarySeedPhraseBackedUp,
      showConnectionsRemovedModal,
      showShieldEntryModal,
      isSocialLoginFlow
    } = this.props;
    if (forgottenPassword) {
      return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
        to: {
          pathname: _routes.RESTORE_VAULT_ROUTE
        }
      });
    } else if (this.state.notificationClosing || this.state.redirecting) {
      return null;
    }
    const canSeeModals = completedOnboarding && (!onboardedInThisUISession || firstTimeFlowType === _onboarding.FirstTimeFlowType.import) && !newNetworkAddedConfigurationId;
    const showWhatsNew = canSeeModals && announcementsToShow && showWhatsNewPopup && !false;
    const showMultiRpcEditModal = canSeeModals && showMultiRpcModal && !showWhatsNew && !false;
    const displayUpdateModal = canSeeModals && showUpdateModal && !showWhatsNew && !showMultiRpcEditModal;
    const showTermsOfUse = completedOnboarding && !onboardedInThisUISession && showTermsOfUsePopup && !isSocialLoginFlow;
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "main-container main-container--has-shadow"
    }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Route, {
      path: _routes.CONNECTED_ROUTE,
      component: _connectedSites.default,
      exact: true
    }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Route, {
      path: _routes.CONNECTED_ACCOUNTS_ROUTE,
      component: _connectedAccounts.default,
      exact: true
    }), /*#__PURE__*/_react.default.createElement("div", {
      className: "home__container"
    }, dataCollectionForMarketing === null && participateInMetaMetrics === true ? this.renderOnboardingPopover() : null, isSeedlessPasswordOutdated && /*#__PURE__*/_react.default.createElement(_passwordOutdatedModal.default, null), showMultiRpcEditModal && /*#__PURE__*/_react.default.createElement(_multiRpcEditModal.default, null), displayUpdateModal && /*#__PURE__*/_react.default.createElement(_updateModal.default, null), showWhatsNew ? /*#__PURE__*/_react.default.createElement(_whatsNewModal.default, {
      onClose: hideWhatsNewPopup
    }) : null, !showWhatsNew && showRecoveryPhraseReminder && !isPrimarySeedPhraseBackedUp ? /*#__PURE__*/_react.default.createElement(_recoveryPhraseReminder.default, {
      onConfirm: this.onRecoveryPhraseReminderClose
    }) : null, showTermsOfUse ? /*#__PURE__*/_react.default.createElement(_termsOfUsePopup.default, {
      onAccept: this.onAcceptTermsOfUse
    }) : null, showConnectionsRemovedModal && /*#__PURE__*/_react.default.createElement(_connectionsRemovedModal.default, null), showShieldEntryModal && /*#__PURE__*/_react.default.createElement(_shieldEntryModal.default, null), isPopup && !connectedStatusPopoverHasBeenShown ? this.renderPopover() : null, /*#__PURE__*/_react.default.createElement("div", {
      className: "home__main-view"
    }, /*#__PURE__*/_react.default.createElement(_accountOverview.AccountOverview, {
      onTabClick: onTabClick
      ///: BEGIN:ONLY_INCLUDE_IF(build-main)
      ,
      onSupportLinkClick: this.onSupportLinkClick
      ///: END:ONLY_INCLUDE_IF
      ,
      defaultHomeActiveTabName: defaultHomeActiveTabName,
      useExternalServices: useExternalServices,
      setBasicFunctionalityModalOpen: setBasicFunctionalityModalOpen
    })), this.renderNotifications()));
  }
}
exports.default = Home;
_defineProperty(Home, "contextTypes", {
  t: _propTypes.default.func,
  trackEvent: _propTypes.default.func
});
_defineProperty(Home, "propTypes", {
  history: _propTypes.default.object,
  forgottenPassword: _propTypes.default.bool,
  setConnectedStatusPopoverHasBeenShown: _propTypes.default.func,
  shouldShowSeedPhraseReminder: _propTypes.default.bool.isRequired,
  isPopup: _propTypes.default.bool,
  connectedStatusPopoverHasBeenShown: _propTypes.default.bool,
  showRecoveryPhraseReminder: _propTypes.default.bool.isRequired,
  showTermsOfUsePopup: _propTypes.default.bool.isRequired,
  firstTimeFlowType: _propTypes.default.string,
  completedOnboarding: _propTypes.default.bool,
  showWhatsNewPopup: _propTypes.default.bool.isRequired,
  hideWhatsNewPopup: _propTypes.default.func.isRequired,
  announcementsToShow: _propTypes.default.bool.isRequired,
  onboardedInThisUISession: _propTypes.default.bool,
  showMultiRpcModal: _propTypes.default.bool.isRequired,
  showUpdateModal: _propTypes.default.bool.isRequired,
  newNetworkAddedConfigurationId: _propTypes.default.string,
  isNotification: _propTypes.default.bool.isRequired,
  // This prop is used in the `shouldCloseNotificationPopup` function
  // eslint-disable-next-line react/no-unused-prop-types
  totalUnapprovedCount: _propTypes.default.number.isRequired,
  defaultHomeActiveTabName: _propTypes.default.string,
  participateInMetaMetrics: _propTypes.default.bool.isRequired,
  onTabClick: _propTypes.default.func.isRequired,
  haveSwapsQuotes: _propTypes.default.bool.isRequired,
  showAwaitingSwapScreen: _propTypes.default.bool.isRequired,
  haveBridgeQuotes: _propTypes.default.bool.isRequired,
  setDataCollectionForMarketing: _propTypes.default.func.isRequired,
  dataCollectionForMarketing: _propTypes.default.bool,
  swapsFetchParams: _propTypes.default.object,
  location: _propTypes.default.object,
  shouldShowWeb3ShimUsageNotification: _propTypes.default.bool.isRequired,
  setWeb3ShimUsageAlertDismissed: _propTypes.default.func.isRequired,
  originOfCurrentTab: _propTypes.default.string,
  disableWeb3ShimUsageAlert: _propTypes.default.func.isRequired,
  pendingApprovals: _propTypes.default.arrayOf(_propTypes.default.object).isRequired,
  hasApprovalFlows: _propTypes.default.bool.isRequired,
  infuraBlocked: _propTypes.default.bool.isRequired,
  setRecoveryPhraseReminderHasBeenShown: _propTypes.default.func.isRequired,
  setRecoveryPhraseReminderLastShown: _propTypes.default.func.isRequired,
  setTermsOfUseLastAgreed: _propTypes.default.func.isRequired,
  showOutdatedBrowserWarning: _propTypes.default.bool.isRequired,
  setOutdatedBrowserWarningLastShown: _propTypes.default.func.isRequired,
  newNetworkAddedName: _propTypes.default.string,
  editedNetwork: _propTypes.default.object,
  // This prop is used in the `shouldCloseNotificationPopup` function
  // eslint-disable-next-line react/no-unused-prop-types
  isSigningQRHardwareTransaction: _propTypes.default.bool,
  newNftAddedMessage: _propTypes.default.string,
  setNewNftAddedMessage: _propTypes.default.func.isRequired,
  removeNftMessage: _propTypes.default.string,
  setRemoveNftMessage: _propTypes.default.func.isRequired,
  attemptCloseNotificationPopup: _propTypes.default.func.isRequired,
  newTokensImported: _propTypes.default.string,
  newTokensImportedError: _propTypes.default.string,
  setNewTokensImported: _propTypes.default.func.isRequired,
  setNewTokensImportedError: _propTypes.default.func.isRequired,
  clearNewNetworkAdded: _propTypes.default.func,
  clearEditedNetwork: _propTypes.default.func,
  setActiveNetwork: _propTypes.default.func,
  hasAllowedPopupRedirectApprovals: _propTypes.default.bool.isRequired,
  useExternalServices: _propTypes.default.bool,
  setBasicFunctionalityModalOpen: _propTypes.default.func,
  fetchBuyableChains: _propTypes.default.func.isRequired,
  redirectAfterDefaultPage: _propTypes.default.object,
  clearRedirectAfterDefaultPage: _propTypes.default.func,
  setAccountDetailsAddress: _propTypes.default.func,
  isSeedlessPasswordOutdated: _propTypes.default.bool,
  isPrimarySeedPhraseBackedUp: _propTypes.default.bool,
  showConnectionsRemovedModal: _propTypes.default.bool,
  showShieldEntryModal: _propTypes.default.bool,
  isSocialLoginFlow: _propTypes.default.bool,
  lookupSelectedNetworks: _propTypes.default.func.isRequired
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\home\\home.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\home\\home.container.js", {"../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../../shared/constants/alerts":"D:\\code\\v\\metamask-extension\\shared\\constants\\alerts.ts","../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../ducks/app/app":"D:\\code\\v\\metamask-extension\\ui\\ducks\\app\\app.ts","../../ducks/history/history":"D:\\code\\v\\metamask-extension\\ui\\ducks\\history\\history.js","../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../ducks/ramps":"D:\\code\\v\\metamask-extension\\ui\\ducks\\ramps\\index.ts","../../ducks/swaps/swaps":"D:\\code\\v\\metamask-extension\\ui\\ducks\\swaps\\swaps.js","../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../selectors/multi-srp/multi-srp":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multi-srp\\multi-srp.ts","../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./home.component":"D:\\code\\v\\metamask-extension\\ui\\pages\\home\\home.component.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js","redux":"D:\\code\\v\\metamask-extension\\node_modules\\redux\\lib\\redux.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Chome%5Chome.container.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _redux = require("redux");
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _selectors = require("../../selectors");
var _networks = require("../../../shared/modules/selectors/networks");
var _actions = require("../../store/actions");
var _app = require("../../ducks/app/app");
var _metamask = require("../../ducks/metamask/metamask");
var _swaps = require("../../ducks/swaps/swaps");
var _ramps = require("../../ducks/ramps");
var _util = require("../../../app/scripts/lib/util");
var _util2 = require("../../helpers/utils/util");
var _app2 = require("../../../shared/constants/app");
var _alerts = require("../../../shared/constants/alerts");
var _multiSrp = require("../../selectors/multi-srp/multi-srp");
var _history = require("../../ducks/history/history");
var _home = _interopRequireDefault(require("./home.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

const mapStateToProps = state => {
  var _getApprovalFlows;
  const {
    metamask,
    appState
  } = state;
  const {
    seedPhraseBackedUp,
    connectedStatusPopoverHasBeenShown,
    defaultHomeActiveTabName,
    swapsState,
    quotes,
    dataCollectionForMarketing,
    participateInMetaMetrics,
    firstTimeFlowType,
    completedOnboarding,
    forgottenPassword
  } = metamask;
  const selectedAccount = (0, _selectors.getSelectedInternalAccount)(state);
  const {
    address: selectedAddress
  } = selectedAccount;
  const totalUnapprovedCount = (0, _selectors.getTotalUnapprovedCount)(state);
  const swapsEnabled = (0, _swaps.getSwapsFeatureIsLive)(state);
  const pendingApprovals = (0, _selectors.selectPendingApprovalsForNavigation)(state);
  const redirectAfterDefaultPage = (0, _history.getRedirectAfterDefaultPage)(state);
  const envType = (0, _util.getEnvironmentType)();
  const isPopup = envType === _app2.ENVIRONMENT_TYPE_POPUP;
  const isNotification = envType === _app2.ENVIRONMENT_TYPE_NOTIFICATION;
  const originOfCurrentTab = (0, _selectors.getOriginOfCurrentTab)(state);
  const shouldShowWeb3ShimUsageNotification = isPopup && (0, _metamask.getWeb3ShimUsageAlertEnabledness)(state) && (0, _selectors.activeTabHasPermissions)(state) && (0, _selectors.getWeb3ShimUsageStateForOrigin)(state, originOfCurrentTab) === _alerts.Web3ShimUsageAlertStates.recorded;
  const hasAllowedPopupRedirectApprovals = (0, _selectors.hasPendingApprovals)(state, [
  ///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
  _app2.SNAP_MANAGE_ACCOUNTS_CONFIRMATION_TYPES.confirmAccountCreation, _app2.SNAP_MANAGE_ACCOUNTS_CONFIRMATION_TYPES.confirmAccountRemoval, _app2.SNAP_MANAGE_ACCOUNTS_CONFIRMATION_TYPES.showNameSnapAccount, _app2.SNAP_MANAGE_ACCOUNTS_CONFIRMATION_TYPES.showSnapAccountRedirect
  ///: END:ONLY_INCLUDE_IF
  ]);
  const TEMPORARY_DISABLE_WHATS_NEW = true;
  const showWhatsNewPopup = TEMPORARY_DISABLE_WHATS_NEW ? false : (0, _selectors.getShowWhatsNewPopup)(state);
  const shouldShowSeedPhraseReminder = selectedAccount && (0, _multiSrp.getShouldShowSeedPhraseReminder)(state, selectedAccount);
  return {
    useExternalServices: (0, _selectors.getUseExternalServices)(state),
    isBasicConfigurationModalOpen: appState.showBasicFunctionalityModal,
    forgottenPassword,
    swapsEnabled,
    shouldShowSeedPhraseReminder,
    isPopup,
    isNotification,
    dataCollectionForMarketing,
    selectedAddress,
    totalUnapprovedCount,
    participateInMetaMetrics,
    hasApprovalFlows: ((_getApprovalFlows = (0, _selectors.getApprovalFlows)(state)) === null || _getApprovalFlows === void 0 ? void 0 : _getApprovalFlows.length) > 0,
    connectedStatusPopoverHasBeenShown,
    defaultHomeActiveTabName,
    firstTimeFlowType,
    completedOnboarding,
    haveSwapsQuotes: Boolean(Object.values(swapsState.quotes || {}).length),
    swapsFetchParams: swapsState.fetchParams,
    showAwaitingSwapScreen: swapsState.routeState === 'awaiting',
    haveBridgeQuotes: Boolean(Object.values(quotes || {}).length),
    isMainnet: (0, _selectors.getIsMainnet)(state),
    originOfCurrentTab,
    shouldShowWeb3ShimUsageNotification,
    pendingApprovals,
    infuraBlocked: (0, _networks.getInfuraBlocked)(state),
    announcementsToShow: (0, _selectors.getSortedAnnouncementsToShow)(state).length > 0,
    showWhatsNewPopup,
    showRecoveryPhraseReminder: (0, _selectors.getShowRecoveryPhraseReminder)(state),
    showTermsOfUsePopup: (0, _selectors.getShowTermsOfUse)(state),
    showOutdatedBrowserWarning: (0, _util2.getIsBrowserDeprecated)() && (0, _selectors.getShowOutdatedBrowserWarning)(state),
    seedPhraseBackedUp,
    newNetworkAddedName: (0, _selectors.getNewNetworkAdded)(state),
    editedNetwork: (0, _selectors.getEditedNetwork)(state),
    isSigningQRHardwareTransaction: (0, _selectors.getIsSigningQRHardwareTransaction)(state),
    newNftAddedMessage: (0, _selectors.getNewNftAddedMessage)(state),
    removeNftMessage: (0, _selectors.getRemoveNftMessage)(state),
    newTokensImported: (0, _selectors.getNewTokensImported)(state),
    newTokensImportedError: (0, _selectors.getNewTokensImportedError)(state),
    newNetworkAddedConfigurationId: appState.newNetworkAddedConfigurationId,
    onboardedInThisUISession: appState.onboardedInThisUISession,
    hasAllowedPopupRedirectApprovals,
    showMultiRpcModal: state.metamask.preferences.showMultiRpcModal,
    showUpdateModal: (0, _selectors.getShowUpdateModal)(state),
    redirectAfterDefaultPage,
    isSeedlessPasswordOutdated: (0, _metamask.getIsSeedlessPasswordOutdated)(state),
    isPrimarySeedPhraseBackedUp: (0, _metamask.getIsPrimarySeedPhraseBackedUp)(state),
    showConnectionsRemovedModal: (0, _selectors.getShowConnectionsRemovedModal)(state),
    showShieldEntryModal: (0, _selectors.getShowShieldEntryModal)(state),
    isSocialLoginFlow: (0, _selectors.getIsSocialLoginFlow)(state)
  };
};
const mapDispatchToProps = dispatch => {
  return {
    setDataCollectionForMarketing: val => dispatch((0, _actions.setDataCollectionForMarketing)(val)),
    attemptCloseNotificationPopup: () => (0, _actions.attemptCloseNotificationPopup)(),
    setConnectedStatusPopoverHasBeenShown: () => dispatch((0, _actions.setConnectedStatusPopoverHasBeenShown)()),
    onTabClick: name => dispatch((0, _actions.setDefaultHomeActiveTabName)(name)),
    setWeb3ShimUsageAlertDismissed: origin => (0, _actions.setWeb3ShimUsageAlertDismissed)(origin),
    disableWeb3ShimUsageAlert: () => (0, _actions.setAlertEnabledness)(_alerts.AlertTypes.web3ShimUsage, false),
    hideWhatsNewPopup: () => dispatch((0, _app.hideWhatsNewPopup)()),
    setRecoveryPhraseReminderHasBeenShown: () => dispatch((0, _actions.setRecoveryPhraseReminderHasBeenShown)()),
    setRecoveryPhraseReminderLastShown: lastShown => dispatch((0, _actions.setRecoveryPhraseReminderLastShown)(lastShown)),
    setTermsOfUseLastAgreed: lastAgreed => {
      dispatch((0, _actions.setTermsOfUseLastAgreed)(lastAgreed));
    },
    setOutdatedBrowserWarningLastShown: lastShown => {
      dispatch((0, _actions.setOutdatedBrowserWarningLastShown)(lastShown));
    },
    setNewNftAddedMessage: message => {
      dispatch((0, _actions.setRemoveNftMessage)(''));
      dispatch((0, _actions.setNewNftAddedMessage)(message));
    },
    setRemoveNftMessage: message => {
      dispatch((0, _actions.setNewNftAddedMessage)(''));
      dispatch((0, _actions.setRemoveNftMessage)(message));
    },
    setNewTokensImported: newTokens => {
      dispatch((0, _actions.setNewTokensImported)(newTokens));
    },
    setNewTokensImportedError: msg => {
      dispatch((0, _actions.setNewTokensImportedError)(msg));
    },
    clearNewNetworkAdded: () => {
      dispatch((0, _actions.setNewNetworkAdded)({}));
    },
    clearEditedNetwork: () => {
      dispatch((0, _actions.setEditedNetwork)());
    },
    setActiveNetwork: networkConfigurationId => {
      dispatch((0, _actions.setActiveNetwork)(networkConfigurationId));
    },
    setBasicFunctionalityModalOpen: () => dispatch((0, _app.openBasicFunctionalityModal)()),
    fetchBuyableChains: () => dispatch((0, _ramps.fetchBuyableChains)()),
    clearRedirectAfterDefaultPage: () => dispatch((0, _history.clearRedirectAfterDefaultPage)()),
    setAccountDetailsAddress: address => dispatch((0, _actions.setAccountDetailsAddress)(address)),
    lookupSelectedNetworks: () => dispatch((0, _actions.lookupSelectedNetworks)())
  };
};
var _default = exports.default = (0, _redux.compose)(_reactRouterDom.withRouter, (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps))(_home.default);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\home\\home.container.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\home\\index.js", {"./home.container":"D:\\code\\v\\metamask-extension\\ui\\pages\\home\\home.container.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Chome%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _home.default;
  }
});
var _home = _interopRequireDefault(require("./home.container"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\home\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\index.js", {"../../shared/lib/sentry":"D:\\code\\v\\metamask-extension\\shared\\lib\\sentry.ts","../contexts/assetPolling":"D:\\code\\v\\metamask-extension\\ui\\contexts\\assetPolling.tsx","../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../contexts/identity":"D:\\code\\v\\metamask-extension\\ui\\contexts\\identity\\index.tsx","../contexts/metamask-notifications":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metamask-notifications\\index.tsx","../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../contexts/shield/shield-subscription":"D:\\code\\v\\metamask-extension\\ui\\contexts\\shield\\shield-subscription.tsx","./error-page/error-page.component":"D:\\code\\v\\metamask-extension\\ui\\pages\\error-page\\error-page.component.tsx","./routes":"D:\\code\\v\\metamask-extension\\ui\\pages\\routes\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _sentry = require("../../shared/lib/sentry");
var _i18n = require("../contexts/i18n");
var _metametrics = require("../contexts/metametrics");
var _metamaskNotifications = require("../contexts/metamask-notifications");
var _assetPolling = require("../contexts/assetPolling");
var _identity = require("../contexts/identity");
var _shieldSubscription = require("../contexts/shield/shield-subscription");
var _errorPage = _interopRequireDefault(require("./error-page/error-page.component"));
var _routes = _interopRequireDefault(require("./routes"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class Index extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "state", {});
  }
  static getDerivedStateFromError(error) {
    return {
      error
    };
  }
  componentDidCatch(error) {
    (0, _sentry.captureException)(error);
  }
  render() {
    const {
      error
    } = this.state;
    const {
      store
    } = this.props;
    if (error) {
      return /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
        store: store
      }, /*#__PURE__*/_react.default.createElement(_i18n.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_i18n.LegacyI18nProvider, null, /*#__PURE__*/_react.default.createElement(_errorPage.default, {
        error: error
      }))));
    }
    return /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
      store: store
    }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.HashRouter, {
      hashType: "noslash"
    }, /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.CompatRouter, null, /*#__PURE__*/_react.default.createElement(_metametrics.MetaMetricsProvider, null, /*#__PURE__*/_react.default.createElement(_metametrics.LegacyMetaMetricsProvider, null, /*#__PURE__*/_react.default.createElement(_i18n.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_i18n.LegacyI18nProvider, null, /*#__PURE__*/_react.default.createElement(_assetPolling.AssetPollingProvider, null, /*#__PURE__*/_react.default.createElement(_identity.MetamaskIdentityProvider, null, /*#__PURE__*/_react.default.createElement(_metamaskNotifications.MetamaskNotificationsProvider, null, /*#__PURE__*/_react.default.createElement(_shieldSubscription.ShieldSubscriptionProvider, null, /*#__PURE__*/_react.default.createElement(_routes.default, null))))))))))));
  }
}
Index.propTypes = {
  store: _propTypes.default.object
};
var _default = exports.default = Index;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\keychains\\restore-vault.js", {"../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../shared/constants/onboarding":"D:\\code\\v\\metamask-extension\\shared\\constants\\onboarding.ts","../../components/app/create-new-vault":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\create-new-vault\\index.js","../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../components/ui/box":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\box\\index.js","../../components/ui/button":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\button\\index.js","../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../helpers/constants/zendesk-url":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\zendesk-url.js","../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Ckeychains%5Crestore-vault.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRedux = require("react-redux");
var _actions = require("../../store/actions");
var _routes = require("../../helpers/constants/routes");
var _createNewVault = _interopRequireDefault(require("../../components/app/create-new-vault"));
var _button = _interopRequireDefault(require("../../components/ui/button"));
var _box = _interopRequireDefault(require("../../components/ui/box"));
var _componentLibrary = require("../../components/component-library");
var _designSystem = require("../../helpers/constants/design-system");
var _zendeskUrl = _interopRequireDefault(require("../../helpers/constants/zendesk-url"));
var _metametrics = require("../../../shared/constants/metametrics");
var _selectors = require("../../selectors");
var _onboarding = require("../../../shared/constants/onboarding");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class RestoreVaultPage extends _react.Component {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "handleImport", async (password, seedPhrase) => {
      const {
        createNewVaultAndRestore: propsCreateNewVaultAndRestore,
        setFirstTimeFlowType: propsSetFirstTimeFlowType,
        resetOAuthLoginState: propsResetOAuthLoginState,
        leaveImportSeedScreenState,
        history,
        isSocialLoginFlow: propsIsSocialLoginFlow
      } = this.props;
      leaveImportSeedScreenState();
      if (propsIsSocialLoginFlow) {
        // reset oauth and onboarding state
        await propsResetOAuthLoginState();
      }

      // update the first time flow type to restore
      await propsSetFirstTimeFlowType(_onboarding.FirstTimeFlowType.restore);

      // import the seed phrase and create a new vault
      await propsCreateNewVaultAndRestore(password, seedPhrase);
      this.context.trackEvent({
        category: _metametrics.MetaMetricsEventCategory.Retention,
        event: _metametrics.MetaMetricsEventName.WalletRestored
      });
      history.push(_routes.DEFAULT_ROUTE);
    });
  }
  render() {
    const {
      t
    } = this.context;
    const {
      isLoading,
      isSocialLoginFlow
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_box.default, {
      className: "first-view-main-wrapper"
    }, /*#__PURE__*/_react.default.createElement(_box.default, {
      className: "first-view-main"
    }, /*#__PURE__*/_react.default.createElement(_box.default, {
      className: "import-account"
    }, /*#__PURE__*/_react.default.createElement("a", {
      className: "import-account__back-button",
      onClick: e => {
        e.preventDefault();
        this.props.leaveImportSeedScreenState();
        this.props.history.push(_routes.DEFAULT_ROUTE);
      },
      href: "#"
    }, `< ${t('back')}`), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.displayMd,
      color: _designSystem.TextColor.textDefault
    }, t('resetWallet')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      color: _designSystem.TextColor.textDefault
    }, isSocialLoginFlow ? t('resetWalletSubHeaderSocial') : t('resetWalletSubHeader')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      color: _designSystem.TextColor.textDefault,
      marginTop: 4,
      marginBottom: 4
    }, isSocialLoginFlow ? t('resetWalletUsingSRPSocial', [/*#__PURE__*/_react.default.createElement(_button.default, {
      type: "link",
      target: "_blank",
      rel: "noopener noreferrer",
      href: _zendeskUrl.default.RESET_IMPORT_AN_ACCOUNT,
      key: "import-an-account",
      className: "import-account__link"
    }, t('resetWalletUsingSRPSocialAccounts')), /*#__PURE__*/_react.default.createElement(_button.default, {
      type: "link",
      target: "_blank",
      rel: "noopener noreferrer",
      href: _zendeskUrl.default.RESET_ADD_MISSING_ACCOUNT,
      key: "add-missing-account",
      className: "import-account__link"
    }, t('resetWalletUsingSRPSocialCustomAccounts')), /*#__PURE__*/_react.default.createElement(_button.default, {
      type: "link",
      target: "_blank",
      rel: "noopener noreferrer",
      href: _zendeskUrl.default.RESET_DISPLAY_TOKENS,
      key: "display-tokens",
      className: "import-account__link"
    }, t('resetWalletUsingSRPSocialCustomTokens'))]) : t('resetWalletUsingSRP', [/*#__PURE__*/_react.default.createElement(_button.default, {
      type: "link",
      target: "_blank",
      rel: "noopener noreferrer",
      href: _zendeskUrl.default.ADD_MISSING_ACCOUNTS,
      key: "import-account-secretphase",
      className: "import-account__link"
    }, t('reAddAccounts')), /*#__PURE__*/_react.default.createElement(_button.default, {
      type: "link",
      target: "_blank",
      rel: "noopener noreferrer",
      href: _zendeskUrl.default.IMPORT_ACCOUNTS,
      key: "import-account-reimport-accounts",
      className: "import-account__link"
    }, t('reAdded')), /*#__PURE__*/_react.default.createElement(_button.default, {
      type: "link",
      target: "_blank",
      rel: "noopener noreferrer",
      href: _zendeskUrl.default.ADD_CUSTOM_TOKENS,
      key: "import-account-readd-tokens",
      className: "import-account__link"
    }, t('reAdded'))])), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      color: _designSystem.TextColor.textDefault,
      margin: 0,
      marginBottom: 4
    }, isSocialLoginFlow ? t('resetWalletWarningSocial') : t('resetWalletWarning')), /*#__PURE__*/_react.default.createElement(_createNewVault.default, {
      disabled: isLoading,
      onSubmit: this.handleImport,
      submitText: t('restore')
    }))));
  }
}
_defineProperty(RestoreVaultPage, "contextTypes", {
  t: _propTypes.default.func,
  trackEvent: _propTypes.default.func
});
_defineProperty(RestoreVaultPage, "propTypes", {
  createNewVaultAndRestore: _propTypes.default.func.isRequired,
  leaveImportSeedScreenState: _propTypes.default.func,
  setFirstTimeFlowType: _propTypes.default.func,
  resetOAuthLoginState: _propTypes.default.func,
  history: _propTypes.default.object,
  isLoading: _propTypes.default.bool,
  isSocialLoginFlow: _propTypes.default.bool
});
var _default = exports.default = (0, _reactRedux.connect)(state => {
  return {
    isLoading: state.appState.isLoading,
    isSocialLoginFlow: (0, _selectors.getIsSocialLoginFlow)(state)
  };
}, dispatch => ({
  leaveImportSeedScreenState: () => {
    dispatch((0, _actions.unMarkPasswordForgotten)());
  },
  createNewVaultAndRestore: (pw, seed) => dispatch((0, _actions.createNewVaultAndRestore)(pw, seed)),
  setFirstTimeFlowType: type => dispatch((0, _actions.setFirstTimeFlowType)(type)),
  resetOAuthLoginState: () => dispatch((0, _actions.resetOAuthLoginState)())
}))(RestoreVaultPage);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\keychains\\restore-vault.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\keychains\\reveal-seed.js", {"../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../shared/modules/error":"D:\\code\\v\\metamask-extension\\shared\\modules\\error.ts","../../components/app/modals/hold-to-reveal-modal/hold-to-reveal-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\hold-to-reveal-modal\\hold-to-reveal-modal.tsx","../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../components/ui/box":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\box\\index.js","../../components/ui/export-text-container":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\export-text-container\\index.js","../../components/ui/tabs":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tabs\\index.ts","../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../helpers/constants/zendesk-url":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\zendesk-url.js","../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","qrcode-generator":"D:\\code\\v\\metamask-extension\\node_modules\\qrcode-generator\\qrcode.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Ckeychains%5Creveal-seed.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = RevealSeedPage;
var _qrcodeGenerator = _interopRequireDefault(require("qrcode-generator"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _error = require("../../../shared/modules/error");
var _metametrics = require("../../../shared/constants/metametrics");
var _holdToRevealModal = _interopRequireDefault(require("../../components/app/modals/hold-to-reveal-modal/hold-to-reveal-modal"));
var _componentLibrary = require("../../components/component-library");
var _box = _interopRequireDefault(require("../../components/ui/box"));
var _exportTextContainer = _interopRequireDefault(require("../../components/ui/export-text-container"));
var _tabs = require("../../components/ui/tabs");
var _metametrics2 = require("../../contexts/metametrics");
var _designSystem = require("../../helpers/constants/design-system");
var _zendeskUrl = _interopRequireDefault(require("../../helpers/constants/zendesk-url"));
var _useI18nContext = require("../../hooks/useI18nContext");
var _actions = require("../../store/actions");
var _selectors = require("../../selectors/selectors");
var _trace = require("../../../shared/lib/trace");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const PASSWORD_PROMPT_SCREEN = 'PASSWORD_PROMPT_SCREEN';
const REVEAL_SEED_SCREEN = 'REVEAL_SEED_SCREEN';
function RevealSeedPage() {
  const history = (0, _reactRouterDom.useHistory)();
  const {
    keyringId
  } = (0, _reactRouterDom.useParams)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const t = (0, _useI18nContext.useI18nContext)();
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const hdEntropyIndex = (0, _reactRedux.useSelector)(_selectors.getHDEntropyIndex);
  const [screen, setScreen] = (0, _react.useState)(PASSWORD_PROMPT_SCREEN);
  const [password, setPassword] = (0, _react.useState)('');
  const [seedWords, setSeedWords] = (0, _react.useState)(null);
  const [completedLongPress, setCompletedLongPress] = (0, _react.useState)(false);
  const [error, setError] = (0, _react.useState)(null);
  const [isShowingHoldModal, setIsShowingHoldModal] = (0, _react.useState)(false);
  const [srpViewEventTracked, setSrpViewEventTracked] = (0, _react.useState)(false);
  const onClickCopy = (0, _react.useCallback)(() => {
    trackEvent({
      category: _metametrics.MetaMetricsEventCategory.Keys,
      event: _metametrics.MetaMetricsEventName.KeyExportCopied,
      properties: {
        key_type: _metametrics.MetaMetricsEventKeyType.Srp,
        copy_method: 'clipboard',
        hd_entropy_index: hdEntropyIndex
      }
    });
    trackEvent({
      category: _metametrics.MetaMetricsEventCategory.Keys,
      event: _metametrics.MetaMetricsEventName.SrpCopiedToClipboard,
      properties: {
        key_type: _metametrics.MetaMetricsEventKeyType.Srp,
        copy_method: 'clipboard',
        hd_entropy_index: hdEntropyIndex
      }
    });
  }, [trackEvent, hdEntropyIndex]);
  (0, _react.useEffect)(() => {
    const passwordBox = document.getElementById('password-box');
    if (passwordBox) {
      passwordBox.focus();
    }
  }, []);
  const renderQR = () => {
    const qrImage = (0, _qrcodeGenerator.default)(0, 'L');
    qrImage.addData(seedWords);
    qrImage.make();
    return qrImage;
  };
  const handleSubmit = event => {
    event.preventDefault();
    (0, _trace.trace)({
      name: _trace.TraceName.RevealSeed
    });
    setSeedWords(null);
    setCompletedLongPress(false);
    setError(null);
    dispatch((0, _actions.requestRevealSeedWords)(password, keyringId)).then(revealedSeedWords => {
      trackEvent({
        category: _metametrics.MetaMetricsEventCategory.Keys,
        event: _metametrics.MetaMetricsEventName.KeyExportRevealed,
        properties: {
          key_type: _metametrics.MetaMetricsEventKeyType.Srp,
          hd_entropy_index: hdEntropyIndex
        }
      });
      setSeedWords(revealedSeedWords);
      setIsShowingHoldModal(true);
    }).catch(e => {
      trackEvent({
        category: _metametrics.MetaMetricsEventCategory.Keys,
        event: _metametrics.MetaMetricsEventName.KeyExportFailed,
        properties: {
          key_type: _metametrics.MetaMetricsEventKeyType.Srp,
          reason: e.message,
          // 'incorrect_password',
          hd_entropy_index: hdEntropyIndex
        }
      });
      setError((0, _error.getErrorMessage)(e));
    }).finally(() => {
      (0, _trace.endTrace)({
        name: _trace.TraceName.RevealSeed
      });
    });
  };
  const renderWarning = () => {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerAlert, {
      severity: _designSystem.Severity.Danger
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMd
    }, t('revealSeedWordsWarning', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      key: "reveal-seed-words-warning-2",
      variant: _designSystem.TextVariant.bodyMdBold,
      as: "strong"
    }, t('revealSeedWordsWarning2'))])));
  };
  const renderPasswordPromptContent = () => {
    return /*#__PURE__*/_react.default.createElement("form", {
      onSubmit: handleSubmit
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Label, {
      htmlFor: "password-box"
    }, t('enterPasswordContinue')), /*#__PURE__*/_react.default.createElement(_componentLibrary.TextField, {
      inputProps: {
        'data-testid': 'input-password'
      },
      type: _componentLibrary.TextFieldType.Password,
      placeholder: t('makeSureNoOneWatching'),
      id: "password-box",
      size: _componentLibrary.TextFieldSize.Large,
      value: password,
      onChange: event => setPassword(event.target.value),
      error: Boolean(error),
      width: _designSystem.BlockSize.Full
    }), error && /*#__PURE__*/_react.default.createElement(_componentLibrary.HelpText, {
      severity: _componentLibrary.HelpTextSeverity.Danger
    }, error));
  };
  const renderRevealSeedContent = () => {
    // default for SRP_VIEW_SRP_TEXT event because this is the first thing shown after rendering
    if (!srpViewEventTracked) {
      trackEvent({
        category: _metametrics.MetaMetricsEventCategory.Keys,
        event: _metametrics.MetaMetricsEventName.SrpViewSrpText,
        properties: {
          key_type: _metametrics.MetaMetricsEventKeyType.Srp
        }
      });
      setSrpViewEventTracked(true);
    }
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_tabs.Tabs, {
      defaultActiveTabName: t('revealSeedWordsText'),
      onTabClick: tabName => {
        if (tabName === 'text-seed') {
          trackEvent({
            category: _metametrics.MetaMetricsEventCategory.Keys,
            event: _metametrics.MetaMetricsEventName.SrpViewSrpText,
            properties: {
              key_type: _metametrics.MetaMetricsEventKeyType.Srp
            }
          });
        } else if (tabName === 'qr-srp') {
          trackEvent({
            category: _metametrics.MetaMetricsEventCategory.Keys,
            event: _metametrics.MetaMetricsEventName.SrpViewsSrpQR,
            properties: {
              key_type: _metametrics.MetaMetricsEventKeyType.Srp
            }
          });
        }
      }
    }, /*#__PURE__*/_react.default.createElement(_tabs.Tab, {
      name: t('revealSeedWordsText'),
      tabKey: "text-seed"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Label, {
      marginTop: 4
    }, t('yourPrivateSeedPhrase')), /*#__PURE__*/_react.default.createElement(_exportTextContainer.default, {
      text: seedWords,
      onClickCopy: onClickCopy
    })), /*#__PURE__*/_react.default.createElement(_tabs.Tab, {
      name: t('revealSeedWordsQR'),
      tabKey: "qr-srp"
    }, /*#__PURE__*/_react.default.createElement(_box.default, {
      display: _designSystem.Display.Flex,
      justifyContent: _designSystem.JustifyContent.center,
      alignItems: _designSystem.AlignItems.center,
      paddingTop: 4,
      "data-testid": "qr-srp"
    }, /*#__PURE__*/_react.default.createElement("div", {
      dangerouslySetInnerHTML: {
        __html: renderQR().createTableTag(5, 15)
      }
    })))));
  };
  const renderPasswordPromptFooter = () => {
    return /*#__PURE__*/_react.default.createElement(_box.default, {
      display: _designSystem.Display.Flex,
      marginTop: "auto",
      gap: 4
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
      width: _designSystem.BlockSize.Full,
      size: _designSystem.Size.LG,
      variant: _componentLibrary.BUTTON_VARIANT.SECONDARY,
      onClick: () => {
        trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Keys,
          event: _metametrics.MetaMetricsEventName.KeyExportCanceled,
          properties: {
            key_type: _metametrics.MetaMetricsEventKeyType.Srp,
            hd_entropy_index: hdEntropyIndex
          }
        });
        trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Keys,
          event: _metametrics.MetaMetricsEventName.SrpRevealCancelled,
          properties: {
            key_type: _metametrics.MetaMetricsEventKeyType.Srp,
            hd_entropy_index: hdEntropyIndex
          }
        });
        history.goBack();
      }
    }, t('cancel')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
      width: _designSystem.BlockSize.Full,
      size: _designSystem.Size.LG,
      onClick: event => {
        trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Keys,
          event: _metametrics.MetaMetricsEventName.KeyExportRequested,
          properties: {
            key_type: _metametrics.MetaMetricsEventKeyType.Srp,
            hd_entropy_index: hdEntropyIndex
          }
        });
        trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Keys,
          event: _metametrics.MetaMetricsEventName.SrpRevealNextClicked,
          properties: {
            key_type: _metametrics.MetaMetricsEventKeyType.Srp
          }
        });
        handleSubmit(event);
      },
      disabled: password === ''
    }, t('next')));
  };
  const renderRevealSeedFooter = () => {
    return /*#__PURE__*/_react.default.createElement(_box.default, {
      marginTop: "auto"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
      variant: _componentLibrary.BUTTON_VARIANT.SECONDARY,
      width: _designSystem.BlockSize.Full,
      size: _designSystem.Size.LG,
      onClick: () => {
        trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Keys,
          event: _metametrics.MetaMetricsEventName.SrpRevealCloseClicked,
          properties: {
            key_type: _metametrics.MetaMetricsEventKeyType.Srp
          }
        });
        history.goBack();
      }
    }, t('close')));
  };
  const renderContent = () => {
    return screen === PASSWORD_PROMPT_SCREEN || !completedLongPress ? renderPasswordPromptContent() : renderRevealSeedContent();
  };
  const renderFooter = () => {
    return screen === PASSWORD_PROMPT_SCREEN || !completedLongPress ? renderPasswordPromptFooter() : renderRevealSeedFooter();
  };
  return /*#__PURE__*/_react.default.createElement(_box.default, {
    className: "page-container",
    paddingTop: 8,
    paddingBottom: 8,
    paddingLeft: 4,
    paddingRight: 4,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingLg
  }, t('secretRecoveryPhrase')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd
  }, t('revealSeedWordsDescription1', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    key: "srp-learn-srp",
    variant: _componentLibrary.BUTTON_VARIANT.LINK,
    size: _componentLibrary.BUTTON_SIZES.INHERIT,
    as: "a",
    href: _zendeskUrl.default.SECRET_RECOVERY_PHRASE,
    target: "_blank",
    rel: "noopener noreferrer"
  }, t('revealSeedWordsSRPName')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    key: "reveal-seed-word-part-3",
    variant: _designSystem.TextVariant.bodyMdBold,
    as: "strong"
  }, t('revealSeedWordsDescription3'))])), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd
  }, t('revealSeedWordsDescription2', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    key: "srp-learn-more-non-custodial",
    variant: _componentLibrary.BUTTON_VARIANT.LINK,
    size: _componentLibrary.BUTTON_SIZES.INHERIT,
    as: "a",
    href: _zendeskUrl.default.NON_CUSTODIAL_WALLET,
    target: "_blank",
    rel: "noopener noreferrer"
  }, t('revealSeedWordsNonCustodialWallet'))])), renderWarning(), renderContent(), renderFooter(), /*#__PURE__*/_react.default.createElement(_holdToRevealModal.default, {
    isOpen: isShowingHoldModal,
    onClose: () => {
      trackEvent({
        category: _metametrics.MetaMetricsEventCategory.Keys,
        event: _metametrics.MetaMetricsEventName.SrpHoldToRevealCloseClicked,
        properties: {
          key_type: _metametrics.MetaMetricsEventKeyType.Srp
        }
      });
      setIsShowingHoldModal(false);
    },
    onLongPressed: () => {
      setCompletedLongPress(true);
      setIsShowingHoldModal(false);
      setScreen(REVEAL_SEED_SCREEN);
    },
    holdToRevealType: "SRP"
  }));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\keychains\\reveal-seed.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\lock\\index.js", {"./lock.container":"D:\\code\\v\\metamask-extension\\ui\\pages\\lock\\lock.container.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Clock%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _lock.default;
  }
});
var _lock = _interopRequireDefault(require("./lock.container"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\lock\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\lock\\lock.component.js", {"../../components/ui/loading-screen":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\loading-screen\\index.js","../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Clock%5Clock.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _loadingScreen = _interopRequireDefault(require("../../components/ui/loading-screen"));
var _routes = require("../../helpers/constants/routes");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class Lock extends _react.PureComponent {
  componentDidMount() {
    const {
      lockMetamask,
      isUnlocked,
      history
    } = this.props;
    if (isUnlocked) {
      lockMetamask().then(() => history.push(_routes.DEFAULT_ROUTE));
    } else {
      history.replace(_routes.DEFAULT_ROUTE);
    }
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_loadingScreen.default, null);
  }
}
exports.default = Lock;
_defineProperty(Lock, "propTypes", {
  history: _propTypes.default.object,
  isUnlocked: _propTypes.default.bool,
  lockMetamask: _propTypes.default.func
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\lock\\lock.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\lock\\lock.container.js", {"../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./lock.component":"D:\\code\\v\\metamask-extension\\ui\\pages\\lock\\lock.component.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js","redux":"D:\\code\\v\\metamask-extension\\node_modules\\redux\\lib\\redux.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Clock%5Clock.container.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _redux = require("redux");
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _actions = require("../../store/actions");
var _lock = _interopRequireDefault(require("./lock.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const mapStateToProps = state => {
  const {
    metamask: {
      isUnlocked
    }
  } = state;
  return {
    isUnlocked
  };
};
const mapDispatchToProps = dispatch => {
  return {
    lockMetamask: () => dispatch((0, _actions.lockMetamask)())
  };
};
var _default = exports.default = (0, _redux.compose)(_reactRouterDom.withRouter, (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps))(_lock.default);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\lock\\lock.container.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\multi-srp\\import-srp\\import-srp.tsx", {"../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../components/app/password-outdated-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\password-outdated-modal\\index.ts","../../../components/app/srp-input/parse-secret-recovery-phrase":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\srp-input\\parse-secret-recovery-phrase.js","../../../components/app/toast-master/utils":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\toast-master\\utils.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/multichain/pages/page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\index.ts","../../../components/ui/show-hide-toggle":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\show-hide-toggle\\index.js","../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","@ethersproject/hdnode":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\hdnode\\lib\\index.js","@metamask/scure-bip39/dist/wordlists/english":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\scure-bip39\\dist\\wordlists\\english.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cmulti-srp%5Cimport-srp%5Cimport-srp.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImportSrp = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _hdnode = require("@ethersproject/hdnode");
var _english = require("@metamask/scure-bip39/dist/wordlists/english");
var _reactRouterDom = require("react-router-dom");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _actions = require("../../../store/actions");
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _utils = require("../../../components/app/toast-master/utils");
var _parseSecretRecoveryPhrase = require("../../../components/app/srp-input/parse-secret-recovery-phrase");
var _util = require("../../../helpers/utils/util");
var _routes = require("../../../helpers/constants/routes");
var _page = require("../../../components/multichain/pages/page");
var _showHideToggle = _interopRequireDefault(require("../../../components/ui/show-hide-toggle"));
var _selectors = require("../../../selectors");
var _trace = require("../../../../shared/lib/trace");
var _metamask = require("../../../ducks/metamask/metamask");
var _passwordOutdatedModal = _interopRequireDefault(require("../../../components/app/password-outdated-modal"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const hasUpperCase = draftSrp => {
  return draftSrp !== draftSrp.toLowerCase();
};
const defaultNumberOfWords = 12;
const ImportSrp = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const [srpError, setSrpError] = (0, _react.useState)('');
  const [pasteFailed, setPasteFailed] = (0, _react.useState)(false);
  const [secretRecoveryPhrase, setSecretRecoveryPhrase] = (0, _react.useState)(Array(defaultNumberOfWords).fill(''));
  const [numberOfWords, setNumberOfWords] = (0, _react.useState)(defaultNumberOfWords);
  const [invalidSrpWords, setInvalidSrpWords] = (0, _react.useState)(Array(defaultNumberOfWords).fill(false));
  const [showSrp, setShowSrp] = (0, _react.useState)(new Array(defaultNumberOfWords).fill(false));
  const isSocialLoginEnabled = (0, _reactRedux.useSelector)(_selectors.getIsSocialLoginFlow);
  const isSeedlessPasswordOutdated = (0, _reactRedux.useSelector)(_metamask.getIsSeedlessPasswordOutdated);
  const [loading, setLoading] = (0, _react.useState)(false);

  // Providing duplicate SRP throws an error in metamask-controller, which results in a warning in the UI
  // We want to hide the warning when the component unmounts
  (0, _react.useEffect)(() => {
    return () => {
      dispatch((0, _actions.hideWarning)());
    };
  }, [dispatch]);
  async function importWallet() {
    if (isSocialLoginEnabled) {
      const isPasswordOutdated = await dispatch((0, _actions.checkIsSeedlessPasswordOutdated)(true));
      if (isPasswordOutdated) {
        return;
      }
    }
    const joinedSrp = secretRecoveryPhrase.join(' ');
    if (joinedSrp) {
      await dispatch((0, _actions.importMnemonicToVault)(joinedSrp));

      // Clear the secret recovery phrase after importing
      setSecretRecoveryPhrase(Array(defaultNumberOfWords).fill(''));
    }
    history.push(_routes.DEFAULT_ROUTE);
    dispatch((0, _utils.setShowNewSrpAddedToast)(true));
  }
  const isValidSrp = (0, _react.useMemo)(() => {
    return (0, _hdnode.isValidMnemonic)(secretRecoveryPhrase.join(' '));
  }, [secretRecoveryPhrase]);
  const hasEmptyWordsOrIncorrectLength = (0, _react.useMemo)(() => {
    return secretRecoveryPhrase.some(word => word === '') || secretRecoveryPhrase.length !== numberOfWords;
  }, [secretRecoveryPhrase, numberOfWords]);
  const onSrpChange = (0, _react.useCallback)(newDraftSrp => {
    const validateSrp = (phrase, words) => {
      if (!phrase.some(word => word !== '')) {
        return {
          error: '',
          words
        };
      }
      const state = {
        error: '',
        words: phrase.map(word => !_english.wordlist.includes(word))
      };
      return state;
    };
    const validateCompleteness = (state, phrase) => {
      if (state.error) {
        return state;
      }
      if (phrase.some(word => word === '')) {
        return {
          ...state,
          error: t('importSRPNumberOfWordsError')
        };
      }
      return state;
    };
    const validateCase = (state, phrase) => {
      if (state.error) {
        return state;
      }
      if (hasUpperCase(phrase)) {
        return {
          ...state,
          error: t('invalidSeedPhraseCaseSensitive')
        };
      }
      return state;
    };
    const validateWords = state => {
      if (state.error) {
        return state;
      }
      const invalidWordIndices = state.words.map((invalid, index) => invalid ? index + 1 : 0).filter(index => index !== 0);
      if (invalidWordIndices.length === 0) {
        return state;
      }
      if (invalidWordIndices.length === 1) {
        return {
          ...state,
          error: t('importSRPWordError', [invalidWordIndices[0]])
        };
      }
      const lastIndex = invalidWordIndices.pop();
      const firstPart = invalidWordIndices.join(', ');
      return {
        ...state,
        error: t('importSRPWordErrorAlternative', [firstPart, lastIndex])
      };
    };
    const validateMnemonic = (state, phrase) => {
      if (state.error) {
        return state;
      }
      if (!(0, _hdnode.isValidMnemonic)(phrase)) {
        return {
          ...state,
          error: t('invalidSeedPhrase')
        };
      }
      return state;
    };
    if (newDraftSrp.filter(word => word !== '').length === numberOfWords) {
      const joinedDraftSrp = newDraftSrp.join(' ').trim();
      const invalidWords = Array(newDraftSrp.length).fill(false);
      let validationResult = validateSrp(newDraftSrp, invalidWords);
      validationResult = validateCase(validationResult, joinedDraftSrp);
      validationResult = validateCompleteness(validationResult, newDraftSrp);
      validationResult = validateWords(validationResult);
      validationResult = validateMnemonic(validationResult, joinedDraftSrp);
      setSrpError(validationResult.error);
      setInvalidSrpWords(validationResult.words);
    }
    setSecretRecoveryPhrase(newDraftSrp);
  }, [t, setSrpError, setSecretRecoveryPhrase, numberOfWords]);
  const toggleShowSrp = (0, _react.useCallback)(index => {
    setShowSrp(currentShowSrp => {
      const newShowSrp = currentShowSrp.slice();
      if (newShowSrp[index]) {
        newShowSrp[index] = false;
      } else {
        newShowSrp.fill(false);
        newShowSrp[index] = true;
      }
      return newShowSrp;
    });
  }, []);
  const onSrpPaste = (0, _react.useCallback)(rawSrp => {
    const parsedSrp = (0, _parseSecretRecoveryPhrase.parseSecretRecoveryPhrase)(rawSrp);
    let newDraftSrp = parsedSrp.split(' ');
    if (newDraftSrp.length > 24) {
      setPasteFailed(true);
      return;
    } else if (pasteFailed) {
      setPasteFailed(false);
    }
    let newNumberOfWords = numberOfWords;
    if (newDraftSrp.length !== numberOfWords) {
      if (newDraftSrp.length < 12) {
        newNumberOfWords = 12;
      } else if (newDraftSrp.length % 3 === 0) {
        newNumberOfWords = newDraftSrp.length;
      } else {
        newNumberOfWords = newDraftSrp.length + (3 - newDraftSrp.length % 3);
      }
      setNumberOfWords(newNumberOfWords);
    }
    if (newDraftSrp.length < newNumberOfWords) {
      newDraftSrp = newDraftSrp.concat(new Array(newNumberOfWords - newDraftSrp.length).fill(''));
    }
    setShowSrp(new Array(newNumberOfWords).fill(false));
    onSrpChange(newDraftSrp);
    (0, _util.clearClipboard)();
  }, [numberOfWords, onSrpChange, pasteFailed, setPasteFailed]);
  const onSrpWordChange = (0, _react.useCallback)((index, newWord) => {
    if (pasteFailed) {
      setPasteFailed(false);
    }
    const newSrp = secretRecoveryPhrase.slice();
    newSrp[index] = newWord.trim();
    onSrpChange(newSrp);
  }, [secretRecoveryPhrase, onSrpChange, pasteFailed]);
  (0, _react.useEffect)(() => {
    if (isSeedlessPasswordOutdated) {
      setLoading(false);
    }
  }, [isSeedlessPasswordOutdated]);
  return /*#__PURE__*/_react.default.createElement(_page.Page, {
    className: "import-srp__multi-srp"
  }, /*#__PURE__*/_react.default.createElement(_page.Header, {
    startAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      ariaLabel: "back",
      iconName: _componentLibrary.IconName.ArrowLeft,
      onClick: () => {
        history.push(_routes.DEFAULT_ROUTE);
      }
    }),
    endAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      ariaLabel: "close",
      iconName: _componentLibrary.IconName.Close,
      onClick: () => {
        history.push(_routes.DEFAULT_ROUTE);
      }
    }),
    paddingLeft: 0,
    paddingRight: 0
  }, t('importSecretRecoveryPhrase')), isSeedlessPasswordOutdated && /*#__PURE__*/_react.default.createElement(_passwordOutdatedModal.default, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    height: _designSystem.BlockSize.Max,
    "data-testid": "import-srp-container"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    marginTop: 2
  }, t('importSRPDescription')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "import-srp__multi-srp__srp-inner-container"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    width: _designSystem.BlockSize.Full,
    marginTop: 4,
    className: "import-srp__multi-srp__srp"
  }, Array.from({
    length: numberOfWords
  }).map((_, index) => {
    const id = `import-srp__multi-srp__srp-word-${index}`;
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      key: index,
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      alignItems: _designSystem.AlignItems.center,
      width: _designSystem.BlockSize.Full,
      marginBottom: 4
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Label, {
      className: "import-srp__multi-srp__label",
      variant: _designSystem.TextVariant.bodyMdMedium,
      marginRight: 4
    }, index + 1, "."), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      className: "import-srp__multi-srp__srp-word",
      flexDirection: _designSystem.FlexDirection.Row,
      alignItems: _designSystem.AlignItems.center,
      width: _designSystem.BlockSize.Full,
      paddingRight: 2
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.TextField, {
      id: id,
      "data-testid": id,
      width: _designSystem.BlockSize.Full,
      borderRadius: _designSystem.BorderRadius.LG,
      error: invalidSrpWords[index],
      type: showSrp[index] ? _componentLibrary.TextFieldType.Text : _componentLibrary.TextFieldType.Password,
      onChange: e => {
        e.preventDefault();
        onSrpWordChange(index, e.target.value);
      },
      value: secretRecoveryPhrase[index],
      autoComplete: false,
      onPaste: event => {
        const newSrp = event.clipboardData.getData('text');
        if (newSrp.trim().match(/\s/u)) {
          event.preventDefault();
          onSrpPaste(newSrp);
        }
      }
    })), /*#__PURE__*/_react.default.createElement(_showHideToggle.default, {
      id: `${id}-checkbox`,
      ariaLabelHidden: t('srpWordHidden'),
      ariaLabelShown: t('srpWordShown'),
      shown: showSrp[index],
      "data-testid": `${id}-checkbox`,
      onChange: () => toggleShowSrp(index),
      title: t('srpToggleShow')
    }));
  })), srpError ? /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerAlert, {
    severity: _componentLibrary.BannerAlertSeverity.Danger,
    description: srpError,
    actionButtonLabel: t('clear'),
    actionButtonOnClick: () => {
      onSrpChange(Array(numberOfWords).fill(''));
      setSrpError('');
    },
    "data-testid": "bannerAlert"
  }) : null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    width: _designSystem.BlockSize.Full,
    marginTop: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    width: _designSystem.BlockSize.Full,
    onClick: async () => {
      setNumberOfWords(numberOfWords === 12 ? 24 : 12);
      setSrpError('');
      setInvalidSrpWords(Array(numberOfWords === 12 ? 24 : 12).fill(false));
      setShowSrp(new Array(numberOfWords === 12 ? 24 : 12).fill(false));
    },
    "data-testid": "import-srp__multi-srp__switch-word-count-button"
  }, t('importNWordSRP', [numberOfWords === 12 ? '24' : '12'])))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "import-srp__multi-srp__import-button",
    marginTop: 4,
    paddingBottom: 6,
    paddingTop: 2,
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonPrimary, {
    width: _designSystem.BlockSize.Full,
    disabled: !isValidSrp || hasEmptyWordsOrIncorrectLength,
    loading: loading,
    onClick: async () => {
      (0, _trace.trace)({
        name: _trace.TraceName.ImportSrp
      });
      try {
        setLoading(true);
        await importWallet();
      } catch (e) {
        setSrpError(e instanceof Error ? e.message : t('importSecretRecoveryPhraseUnknownError'));
      } finally {
        setLoading(false);
        (0, _trace.endTrace)({
          name: _trace.TraceName.ImportSrp
        });
      }
    }
  }, t('importWallet')))));
};
exports.ImportSrp = ImportSrp;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\multi-srp\\import-srp\\import-srp.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\multi-srp\\import-srp\\index.ts", {"./import-srp":"D:\\code\\v\\metamask-extension\\ui\\pages\\multi-srp\\import-srp\\import-srp.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cmulti-srp%5Cimport-srp%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ImportSrp", {
  enumerable: true,
  get: function () {
    return _importSrp.ImportSrp;
  }
});
var _importSrp = require("./import-srp");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\multi-srp\\import-srp\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\account-details\\account-type-utils.ts", {"@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/keyring-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cmultichain-accounts%5Caccount-details%5Caccount-type-utils.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isSolanaAccount = exports.isPrivateKeyAccount = exports.isInstitutionalEVMAccount = exports.isHardwareAccount = exports.isEVMAccount = exports.isBitcoinAccount = exports.getAccountTypeCategory = void 0;
var _keyringApi = require("@metamask/keyring-api");
var _keyringController = require("@metamask/keyring-controller");
/**
 * Determines the account type category based on the account's type and keyring information
 *
 * @param account
 */
const getAccountTypeCategory = account => {
  var _metadata$keyring, _metadata$snap;
  if (!account) {
    return 'unknown';
  }
  const {
    type,
    metadata
  } = account;
  const keyringType = metadata === null || metadata === void 0 || (_metadata$keyring = metadata.keyring) === null || _metadata$keyring === void 0 ? void 0 : _metadata$keyring.type;
  const snapId = metadata === null || metadata === void 0 || (_metadata$snap = metadata.snap) === null || _metadata$snap === void 0 ? void 0 : _metadata$snap.id;

  // Hardware accounts (must be checked before EVM check)
  if (keyringType && [_keyringController.KeyringTypes.ledger, _keyringController.KeyringTypes.trezor, _keyringController.KeyringTypes.oneKey, _keyringController.KeyringTypes.lattice, _keyringController.KeyringTypes.qr].includes(keyringType)) {
    return 'hardware';
  }

  // Private key accounts (must be checked before EVM check)
  if (keyringType === _keyringController.KeyringTypes.simple) {
    return 'private-key';
  }

  // Institutional-EVM accounts (must be checked before EVM check)
  if (keyringType === _keyringController.KeyringTypes.snap && snapId === 'npm:@metamask/institutional-wallet-snap') {
    return 'institutional-evm';
  }

  // EVM accounts (EOA and ERC-4337) - general fallback
  if ((0, _keyringApi.isEvmAccountType)(type)) {
    return 'evm';
  }

  // Solana accounts
  if (type === _keyringApi.SolAccountType.DataAccount) {
    return 'solana';
  }

  // Bitcoin accounts
  if (Object.values(_keyringApi.BtcAccountType).includes(type)) {
    return 'bitcoin';
  }
  return 'unknown';
};

/**
 * Checks if an account is an EVM account (EOA or ERC-4337)
 *
 * @param account - The internal account object to check.
 */
exports.getAccountTypeCategory = getAccountTypeCategory;
const isEVMAccount = account => {
  return getAccountTypeCategory(account) === 'evm';
};

/**
 * Checks if an account is a Solana account
 *
 * @param account - The internal account object to check.
 */
exports.isEVMAccount = isEVMAccount;
const isSolanaAccount = account => {
  return getAccountTypeCategory(account) === 'solana';
};

/**
 * Checks if an account is a hardware wallet account
 *
 * @param account - The internal account object to check.
 */
exports.isSolanaAccount = isSolanaAccount;
const isHardwareAccount = account => {
  return getAccountTypeCategory(account) === 'hardware';
};

/**
 * Checks if an account is a private key account
 *
 * @param account - The internal account object to check.
 */
exports.isHardwareAccount = isHardwareAccount;
const isPrivateKeyAccount = account => {
  return getAccountTypeCategory(account) === 'private-key';
};

/**
 * Checks if an account is an institutional EVM account
 *
 * @param account - The internal account object to check.
 */
exports.isPrivateKeyAccount = isPrivateKeyAccount;
const isInstitutionalEVMAccount = account => {
  return getAccountTypeCategory(account) === 'institutional-evm';
};

/**
 * Checks if an account is a Bitcoin account
 *
 * @param account - The internal account object to check.
 */
exports.isInstitutionalEVMAccount = isInstitutionalEVMAccount;
const isBitcoinAccount = account => {
  return getAccountTypeCategory(account) === 'bitcoin';
};
exports.isBitcoinAccount = isBitcoinAccount;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\multichain-accounts\\account-details\\account-type-utils.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\account-details\\btc-account-details.tsx", {"../base-account-details/base-account-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\base-account-details\\base-account-details.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cmultichain-accounts%5Caccount-details%5Cbtc-account-details.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BitcoinAccountDetails = void 0;
var _react = _interopRequireDefault(require("react"));
var _baseAccountDetails = require("../base-account-details/base-account-details");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const BitcoinAccountDetails = ({
  address,
  account
}) => {
  return /*#__PURE__*/_react.default.createElement(_baseAccountDetails.BaseAccountDetails, {
    address: address,
    account: account
  });
};
exports.BitcoinAccountDetails = BitcoinAccountDetails;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\multichain-accounts\\account-details\\btc-account-details.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\account-details\\evm-account-details.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/multichain-accounts/account-show-private-key-row/account-show-private-key-row":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\account-show-private-key-row\\account-show-private-key-row.tsx","../../../components/multichain-accounts/account-show-srp-row/account-show-srp-row":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\account-show-srp-row\\account-show-srp-row.tsx","../../../components/multichain-accounts/smart-contract-account-toggle-section":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\smart-contract-account-toggle-section\\index.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../base-account-details/base-account-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\base-account-details\\base-account-details.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cmultichain-accounts%5Caccount-details%5Cevm-account-details.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EVMAccountDetails = void 0;
var _react = _interopRequireDefault(require("react"));
var _baseAccountDetails = require("../base-account-details/base-account-details");
var _smartContractAccountToggleSection = require("../../../components/multichain-accounts/smart-contract-account-toggle-section");
var _routes = require("../../../helpers/constants/routes");
var _accountShowSrpRow = require("../../../components/multichain-accounts/account-show-srp-row/account-show-srp-row");
var _componentLibrary = require("../../../components/component-library");
var _accountShowPrivateKeyRow = require("../../../components/multichain-accounts/account-show-private-key-row/account-show-private-key-row");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const EVMAccountDetails = ({
  address,
  account
}) => {
  return /*#__PURE__*/_react.default.createElement(_baseAccountDetails.BaseAccountDetails, {
    address: address,
    account: account
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "multichain-account-details__section"
  }, /*#__PURE__*/_react.default.createElement(_accountShowSrpRow.AccountShowSrpRow, {
    account: account
  }), /*#__PURE__*/_react.default.createElement(_accountShowPrivateKeyRow.AccountShowPrivateKeyRow, {
    account: account
  })), /*#__PURE__*/_react.default.createElement(_smartContractAccountToggleSection.SmartContractAccountToggleSection, {
    address: address,
    returnToPage: _routes.ACCOUNT_DETAILS_ROUTE
  }));
};
exports.EVMAccountDetails = EVMAccountDetails;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\multichain-accounts\\account-details\\evm-account-details.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\account-details\\hardware-account-details.tsx", {"../../../components/multichain-accounts/smart-contract-account-toggle-section":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\smart-contract-account-toggle-section\\index.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../base-account-details/base-account-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\base-account-details\\base-account-details.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cmultichain-accounts%5Caccount-details%5Chardware-account-details.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HardwareAccountDetails = void 0;
var _react = _interopRequireDefault(require("react"));
var _baseAccountDetails = require("../base-account-details/base-account-details");
var _smartContractAccountToggleSection = require("../../../components/multichain-accounts/smart-contract-account-toggle-section");
var _routes = require("../../../helpers/constants/routes");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const HardwareAccountDetails = ({
  address,
  account
}) => {
  return /*#__PURE__*/_react.default.createElement(_baseAccountDetails.BaseAccountDetails, {
    address: address,
    account: account
  }, /*#__PURE__*/_react.default.createElement(_smartContractAccountToggleSection.SmartContractAccountToggleSection, {
    address: address,
    returnToPage: _routes.ACCOUNT_DETAILS_ROUTE
  }));
};
exports.HardwareAccountDetails = HardwareAccountDetails;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\multichain-accounts\\account-details\\hardware-account-details.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\account-details\\index.ts", {"./account-type-utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\account-details\\account-type-utils.ts","./btc-account-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\account-details\\btc-account-details.tsx","./evm-account-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\account-details\\evm-account-details.tsx","./hardware-account-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\account-details\\hardware-account-details.tsx","./institutional-evm-account-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\account-details\\institutional-evm-account-details.tsx","./multichain-account-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\account-details\\multichain-account-details.tsx","./private-key-account-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\account-details\\private-key-account-details.tsx","./solana-account-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\account-details\\solana-account-details.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cmultichain-accounts%5Caccount-details%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  MultichainAccountDetails: true,
  EVMAccountDetails: true,
  SolanaAccountDetails: true,
  HardwareAccountDetails: true,
  PrivateKeyAccountDetails: true,
  InstitutionalEVMAccountDetails: true,
  BitcoinAccountDetails: true
};
Object.defineProperty(exports, "BitcoinAccountDetails", {
  enumerable: true,
  get: function () {
    return _btcAccountDetails.BitcoinAccountDetails;
  }
});
Object.defineProperty(exports, "EVMAccountDetails", {
  enumerable: true,
  get: function () {
    return _evmAccountDetails.EVMAccountDetails;
  }
});
Object.defineProperty(exports, "HardwareAccountDetails", {
  enumerable: true,
  get: function () {
    return _hardwareAccountDetails.HardwareAccountDetails;
  }
});
Object.defineProperty(exports, "InstitutionalEVMAccountDetails", {
  enumerable: true,
  get: function () {
    return _institutionalEvmAccountDetails.InstitutionalEVMAccountDetails;
  }
});
Object.defineProperty(exports, "MultichainAccountDetails", {
  enumerable: true,
  get: function () {
    return _multichainAccountDetails.MultichainAccountDetails;
  }
});
Object.defineProperty(exports, "PrivateKeyAccountDetails", {
  enumerable: true,
  get: function () {
    return _privateKeyAccountDetails.PrivateKeyAccountDetails;
  }
});
Object.defineProperty(exports, "SolanaAccountDetails", {
  enumerable: true,
  get: function () {
    return _solanaAccountDetails.SolanaAccountDetails;
  }
});
var _multichainAccountDetails = require("./multichain-account-details");
var _evmAccountDetails = require("./evm-account-details");
var _solanaAccountDetails = require("./solana-account-details");
var _hardwareAccountDetails = require("./hardware-account-details");
var _privateKeyAccountDetails = require("./private-key-account-details");
var _institutionalEvmAccountDetails = require("./institutional-evm-account-details");
var _btcAccountDetails = require("./btc-account-details");
var _accountTypeUtils = require("./account-type-utils");
Object.keys(_accountTypeUtils).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _accountTypeUtils[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _accountTypeUtils[key];
    }
  });
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\multichain-accounts\\account-details\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\account-details\\institutional-evm-account-details.tsx", {"../base-account-details/base-account-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\base-account-details\\base-account-details.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cmultichain-accounts%5Caccount-details%5Cinstitutional-evm-account-details.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstitutionalEVMAccountDetails = void 0;
var _react = _interopRequireDefault(require("react"));
var _baseAccountDetails = require("../base-account-details/base-account-details");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const InstitutionalEVMAccountDetails = ({
  address,
  account
}) => {
  return /*#__PURE__*/_react.default.createElement(_baseAccountDetails.BaseAccountDetails, {
    address: address,
    account: account
  });
};
exports.InstitutionalEVMAccountDetails = InstitutionalEVMAccountDetails;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\multichain-accounts\\account-details\\institutional-evm-account-details.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\account-details\\multichain-account-details.tsx", {"../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","./account-type-utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\account-details\\account-type-utils.ts","./btc-account-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\account-details\\btc-account-details.tsx","./evm-account-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\account-details\\evm-account-details.tsx","./hardware-account-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\account-details\\hardware-account-details.tsx","./institutional-evm-account-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\account-details\\institutional-evm-account-details.tsx","./private-key-account-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\account-details\\private-key-account-details.tsx","./solana-account-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\account-details\\solana-account-details.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cmultichain-accounts%5Caccount-details%5Cmultichain-account-details.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultichainAccountDetails = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _selectors = require("../../../selectors");
var _evmAccountDetails = require("./evm-account-details");
var _accountTypeUtils = require("./account-type-utils");
var _solanaAccountDetails = require("./solana-account-details");
var _hardwareAccountDetails = require("./hardware-account-details");
var _privateKeyAccountDetails = require("./private-key-account-details");
var _institutionalEvmAccountDetails = require("./institutional-evm-account-details");
var _btcAccountDetails = require("./btc-account-details");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const MultichainAccountDetails = () => {
  const {
    address
  } = (0, _reactRouterDom.useParams)();
  const account = (0, _reactRedux.useSelector)(state => (0, _selectors.getInternalAccountByAddress)(state, address));
  const accountTypeCategory = (0, _accountTypeUtils.getAccountTypeCategory)(account);
  const renderAccountDetailsByType = () => {
    switch (accountTypeCategory) {
      case 'evm':
        return /*#__PURE__*/_react.default.createElement(_evmAccountDetails.EVMAccountDetails, {
          address: address,
          account: account
        });
      case 'solana':
        return /*#__PURE__*/_react.default.createElement(_solanaAccountDetails.SolanaAccountDetails, {
          address: address,
          account: account
        });
      case 'hardware':
        return /*#__PURE__*/_react.default.createElement(_hardwareAccountDetails.HardwareAccountDetails, {
          address: address,
          account: account
        });
      case 'private-key':
        return /*#__PURE__*/_react.default.createElement(_privateKeyAccountDetails.PrivateKeyAccountDetails, {
          address: address,
          account: account
        });
      case 'institutional-evm':
        return /*#__PURE__*/_react.default.createElement(_institutionalEvmAccountDetails.InstitutionalEVMAccountDetails, {
          address: address,
          account: account
        });
      case 'bitcoin':
        return /*#__PURE__*/_react.default.createElement(_btcAccountDetails.BitcoinAccountDetails, {
          address: address,
          account: account
        });
      default:
        return null;
    }
  };
  return renderAccountDetailsByType();
};
exports.MultichainAccountDetails = MultichainAccountDetails;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\multichain-accounts\\account-details\\multichain-account-details.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\account-details\\private-key-account-details.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/multichain-accounts/account-show-private-key-row/account-show-private-key-row":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\account-show-private-key-row\\account-show-private-key-row.tsx","../../../components/multichain-accounts/smart-contract-account-toggle-section":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\smart-contract-account-toggle-section\\index.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../base-account-details/base-account-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\base-account-details\\base-account-details.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cmultichain-accounts%5Caccount-details%5Cprivate-key-account-details.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivateKeyAccountDetails = void 0;
var _react = _interopRequireDefault(require("react"));
var _baseAccountDetails = require("../base-account-details/base-account-details");
var _smartContractAccountToggleSection = require("../../../components/multichain-accounts/smart-contract-account-toggle-section");
var _routes = require("../../../helpers/constants/routes");
var _accountShowPrivateKeyRow = require("../../../components/multichain-accounts/account-show-private-key-row/account-show-private-key-row");
var _componentLibrary = require("../../../components/component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const PrivateKeyAccountDetails = ({
  address,
  account
}) => {
  return /*#__PURE__*/_react.default.createElement(_baseAccountDetails.BaseAccountDetails, {
    address: address,
    account: account
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "multichain-account-details__section"
  }, /*#__PURE__*/_react.default.createElement(_accountShowPrivateKeyRow.AccountShowPrivateKeyRow, {
    account: account
  })), /*#__PURE__*/_react.default.createElement(_smartContractAccountToggleSection.SmartContractAccountToggleSection, {
    address: address,
    returnToPage: _routes.ACCOUNT_DETAILS_ROUTE
  }));
};
exports.PrivateKeyAccountDetails = PrivateKeyAccountDetails;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\multichain-accounts\\account-details\\private-key-account-details.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\account-details\\solana-account-details.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/multichain-accounts/account-show-srp-row/account-show-srp-row":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\account-show-srp-row\\account-show-srp-row.tsx","../base-account-details/base-account-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\base-account-details\\base-account-details.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cmultichain-accounts%5Caccount-details%5Csolana-account-details.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SolanaAccountDetails = void 0;
var _react = _interopRequireDefault(require("react"));
var _baseAccountDetails = require("../base-account-details/base-account-details");
var _accountShowSrpRow = require("../../../components/multichain-accounts/account-show-srp-row/account-show-srp-row");
var _componentLibrary = require("../../../components/component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const SolanaAccountDetails = ({
  address,
  account
}) => {
  return /*#__PURE__*/_react.default.createElement(_baseAccountDetails.BaseAccountDetails, {
    address: address,
    account: account
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "multichain-account-details__section"
  }, /*#__PURE__*/_react.default.createElement(_accountShowSrpRow.AccountShowSrpRow, {
    account: account
  })));
};
exports.SolanaAccountDetails = SolanaAccountDetails;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\multichain-accounts\\account-details\\solana-account-details.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\account-list\\account-list.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/multichain-accounts/add-wallet-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\add-wallet-modal\\index.ts","../../../components/multichain-accounts/multichain-account-list":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-account-list\\index.ts","../../../components/multichain/pages/page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/accounts/useAccountsOperationsLoadingStates":"D:\\code\\v\\metamask-extension\\ui\\hooks\\accounts\\useAccountsOperationsLoadingStates.ts","../../../hooks/social-sync/useSyncSRPs":"D:\\code\\v\\metamask-extension\\ui\\hooks\\social-sync\\useSyncSRPs.ts","../../../hooks/useAssetsUpdateAllAccountBalances":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAssetsUpdateAllAccountBalances.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","./utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\account-list\\utils.ts","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cmultichain-accounts%5Caccount-list%5Caccount-list.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _designSystemReact = require("@metamask/design-system-react");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _multichainAccountList = require("../../../components/multichain-accounts/multichain-account-list");
var _accountTree = require("../../../selectors/multichain-accounts/account-tree");
var _addWalletModal = require("../../../components/multichain-accounts/add-wallet-modal");
var _useAccountsOperationsLoadingStates = require("../../../hooks/accounts/useAccountsOperationsLoadingStates");
var _componentLibrary = require("../../../components/component-library");
var _page = require("../../../components/multichain/pages/page");
var _useAssetsUpdateAllAccountBalances = require("../../../hooks/useAssetsUpdateAllAccountBalances");
var _useSyncSRPs = require("../../../hooks/social-sync/useSyncSRPs");
var _utils = require("./utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AccountList = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const accountTree = (0, _reactRedux.useSelector)(_accountTree.getAccountTree);
  const {
    wallets
  } = accountTree;
  const {
    selectedAccountGroup
  } = accountTree;
  const [searchPattern, setSearchPattern] = (0, _react.useState)('');
  const groupsMetadata = (0, _reactRedux.useSelector)(_accountTree.getNormalizedGroupsMetadata);
  const {
    isAccountTreeSyncingInProgress,
    loadingMessage: accountOperationLoadingMessage
  } = (0, _useAccountsOperationsLoadingStates.useAccountsOperationsLoadingStates)();
  const addWalletButtonLabel = (0, _react.useMemo)(() => {
    if (isAccountTreeSyncingInProgress) {
      return accountOperationLoadingMessage;
    }
    return t('addWallet');
  }, [isAccountTreeSyncingInProgress, accountOperationLoadingMessage, t]);
  // Update balances for all accounts when component mounts
  // This ensures all account balances are visible without requiring user interaction
  (0, _useAssetsUpdateAllAccountBalances.useAssetsUpdateAllAccountBalances)();

  // Sync SRPs for social login flow
  // TODO: Move this logic on the background side, so we don't trigger this sync
  // every time the account list is being opened.
  // See: https://github.com/MetaMask/metamask-extension/issues/36639
  (0, _useSyncSRPs.useSyncSRPs)();
  const hasMultipleWallets = (0, _react.useMemo)(() => Object.keys(wallets).length > 1, [wallets]);
  const onSearchBarChange = (0, _react.useCallback)(e => setSearchPattern(e.target.value), []);
  const filteredWallets = (0, _react.useMemo)(() => {
    return (0, _utils.filterWalletsByGroupNameOrAddress)(wallets, searchPattern, groupsMetadata);
  }, [wallets, searchPattern, groupsMetadata]);
  const hasFilteredWallets = (0, _react.useMemo)(() => Object.keys(filteredWallets).length > 0, [filteredWallets]);
  const [isAddWalletModalOpen, setIsAddWalletModalOpen] = (0, _react.useState)(false);
  const handleOpenAddWalletModal = (0, _react.useCallback)(() => {
    setIsAddWalletModalOpen(true);
  }, [setIsAddWalletModalOpen]);
  const handleCloseAddWalletModal = (0, _react.useCallback)(() => {
    setIsAddWalletModalOpen(false);
  }, [setIsAddWalletModalOpen]);
  return /*#__PURE__*/_react.default.createElement(_page.Page, {
    className: "account-list-page"
  }, /*#__PURE__*/_react.default.createElement(_page.Header, {
    textProps: {
      variant: _designSystem.TextVariant.headingSm
    },
    startAccessory: /*#__PURE__*/_react.default.createElement(_designSystemReact.ButtonIcon, {
      size: _designSystemReact.ButtonIconSize.Md,
      ariaLabel: t('back'),
      iconName: _designSystemReact.IconName.ArrowLeft,
      onClick: () => history.goBack()
    })
  }, t('accounts')), /*#__PURE__*/_react.default.createElement(_page.Content, {
    className: "account-list-page__content"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    flexDirection: _designSystem.FlexDirection.Column,
    paddingTop: 1,
    paddingLeft: 4,
    paddingRight: 4,
    paddingBottom: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.TextFieldSearch, {
    size: _componentLibrary.TextFieldSearchSize.Lg,
    placeholder: t('searchYourAccounts'),
    value: searchPattern,
    onChange: onSearchBarChange,
    clearButtonOnClick: () => setSearchPattern(''),
    width: _designSystem.BlockSize.Full,
    borderWidth: 0,
    backgroundColor: _designSystem.BackgroundColor.backgroundMuted,
    borderRadius: _designSystem.BorderRadius.LG,
    "data-testid": "multichain-account-list-search"
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    height: _designSystem.BlockSize.Full,
    flexDirection: _designSystem.FlexDirection.Column,
    className: "multichain-account-menu-popover__list"
  }, hasFilteredWallets ? /*#__PURE__*/_react.default.createElement(_multichainAccountList.MultichainAccountList, {
    wallets: filteredWallets,
    selectedAccountGroups: [selectedAccountGroup],
    isInSearchMode: Boolean(searchPattern),
    displayWalletHeader: hasMultipleWallets
  }) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.center,
    width: _designSystem.BlockSize.Full,
    height: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textAlternative,
    variant: _designSystem.TextVariant.bodyMdMedium
  }, t('noAccountsFound'))))), /*#__PURE__*/_react.default.createElement(_page.Footer, {
    className: "shadow-sm"
  }, /*#__PURE__*/_react.default.createElement(_designSystemReact.Button, {
    variant: _designSystemReact.ButtonVariant.Secondary,
    size: _designSystemReact.ButtonSize.Lg,
    onClick: handleOpenAddWalletModal,
    isDisabled: isAccountTreeSyncingInProgress,
    isFullWidth: true,
    "data-testid": "account-list-add-wallet-button"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    gap: 2,
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center
  }, isAccountTreeSyncingInProgress && /*#__PURE__*/_react.default.createElement(_designSystemReact.Icon, {
    className: "add-multichain-account__icon-box__icon-loading",
    name: _designSystemReact.IconName.Loading,
    color: _designSystemReact.IconColor.IconMuted,
    size: _designSystemReact.IconSize.Lg
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium
  }, addWalletButtonLabel)))), /*#__PURE__*/_react.default.createElement(_addWalletModal.AddWalletModal, {
    isOpen: isAddWalletModalOpen,
    onClose: handleCloseAddWalletModal
  }));
};
exports.AccountList = AccountList;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\multichain-accounts\\account-list\\account-list.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\account-list\\index.ts", {"./account-list":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\account-list\\account-list.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cmultichain-accounts%5Caccount-list%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "AccountList", {
  enumerable: true,
  get: function () {
    return _accountList.AccountList;
  }
});
var _accountList = require("./account-list");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\multichain-accounts\\account-list\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\account-list\\utils.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cmultichain-accounts%5Caccount-list%5Cutils.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.filterWalletsByGroupNameOrAddress = filterWalletsByGroupNameOrAddress;
/**
 * Filter wallets based on a search pattern, returning only wallets that have groups
 * with account names matching the search pattern.
 *
 * @param wallets - The wallets collection to filter.
 * @param searchPattern - The search pattern to match group names against.
 * @param groupsMetadata - The groups metadata.
 * @returns Filtered wallets containing only groups that match the search pattern.
 */
function filterWalletsByGroupNameOrAddress(wallets, searchPattern, groupsMetadata) {
  const normalizedSearchPattern = searchPattern.trim().toLowerCase();
  if (!normalizedSearchPattern) {
    return wallets;
  }
  return Object.entries(wallets).reduce((result, [walletId, wallet]) => {
    let hasGroups = false;
    const filteredGroups = Object.entries(wallet.groups || {}).reduce((groupsResult, [groupId, group]) => {
      const metadata = groupsMetadata[groupId];
      const matchesName = metadata === null || metadata === void 0 ? void 0 : metadata.name.includes(normalizedSearchPattern);
      const matchesAddress = metadata === null || metadata === void 0 ? void 0 : metadata.accounts.some(account => account.includes(normalizedSearchPattern));
      if (matchesName || matchesAddress) {
        groupsResult[groupId] = group;
        hasGroups = true;
      }
      return groupsResult;
    }, {});

    // Only include the wallet if it has any matching groups
    if (hasGroups) {
      result[walletId] = {
        ...wallet,
        groups: filteredGroups
      };
    }
    return result;
  }, {});
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\multichain-accounts\\account-list\\utils.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\add-wallet-page\\add-wallet-page.tsx", {"../../../components/multichain/import-account/import-account":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\import-account\\import-account.js","../../../components/multichain/pages/page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cmultichain-accounts%5Cadd-wallet-page%5Cadd-wallet-page.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddWalletPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _designSystemReact = require("@metamask/design-system-react");
var _page = require("../../../components/multichain/pages/page");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _importAccount = require("../../../components/multichain/import-account/import-account");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 *
 * TODO: This page will eventually handle both SRP and Private Key account imports
 * For now, it only handles Private Key account imports
 */
const AddWalletPage = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const onActionComplete = (0, _react.useCallback)(async confirmed => {
    if (confirmed) {
      history.goBack();
    }
  }, [history]);
  return /*#__PURE__*/_react.default.createElement(_page.Page, {
    className: "max-w-[600px]"
  }, /*#__PURE__*/_react.default.createElement(_page.Header, {
    textProps: {
      variant: _designSystem.TextVariant.headingSm
    },
    startAccessory: /*#__PURE__*/_react.default.createElement(_designSystemReact.ButtonIcon, {
      size: _designSystemReact.ButtonIconSize.Md,
      ariaLabel: t('back'),
      iconName: _designSystemReact.IconName.ArrowLeft,
      onClick: () => history.goBack(),
      "data-testid": "add-wallet-page-back-button"
    })
  }, t('addWallet')), /*#__PURE__*/_react.default.createElement(_page.Content, null, /*#__PURE__*/_react.default.createElement(_designSystemReact.Text, {
    variant: _designSystemReact.TextVariant.HeadingSm
  }, t('privateKey')), /*#__PURE__*/_react.default.createElement(_importAccount.ImportAccount, {
    onActionComplete: onActionComplete
  })));
};
exports.AddWalletPage = AddWalletPage;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\multichain-accounts\\add-wallet-page\\add-wallet-page.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\add-wallet-page\\index.ts", {"./add-wallet-page":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\add-wallet-page\\add-wallet-page.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cmultichain-accounts%5Cadd-wallet-page%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "AddWalletPage", {
  enumerable: true,
  get: function () {
    return _addWalletPage.AddWalletPage;
  }
});
var _addWalletPage = require("./add-wallet-page");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\multichain-accounts\\add-wallet-page\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\address-qr-code\\address-qr-code.tsx", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/multichain/menu-items/view-explorer-menu-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\menu-items\\view-explorer-menu-item.tsx","../../../components/multichain/pages/page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\index.ts","../../../components/ui/qr-code-view":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\qr-code-view\\index.js","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/multichain/blockExplorer":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\multichain\\blockExplorer.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../hooks/useMultichainSelector":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainSelector.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../account-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\account-details\\index.ts","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cmultichain-accounts%5Caddress-qr-code%5Caddress-qr-code.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddressQRCode = void 0;
var _react = _interopRequireWildcard(require("react"));
var _utils = require("@metamask/utils");
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _page = require("../../../components/multichain/pages/page");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _qrCodeView = _interopRequireDefault(require("../../../components/ui/qr-code-view"));
var _selectors = require("../../../selectors");
var _multichain = require("../../../selectors/multichain");
var _useMultichainSelector = require("../../../hooks/useMultichainSelector");
var _blockExplorer = require("../../../helpers/utils/multichain/blockExplorer");
var _viewExplorerMenuItem = require("../../../components/multichain/menu-items/view-explorer-menu-item");
var _metametrics = require("../../../contexts/metametrics");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _accountDetails = require("../account-details");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AddressQRCode = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    address
  } = (0, _reactRouterDom.useParams)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const account = (0, _reactRedux.useSelector)(state => (0, _selectors.getInternalAccountByAddress)(state, address));
  const multichainNetwork = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainNetwork, account);
  const addressLink = (0, _blockExplorer.getMultichainAccountUrl)(account.address, multichainNetwork);
  const chainId = (0, _utils.parseCaipChainId)(multichainNetwork.chainId).reference;
  const metricsLocation = 'Account Details QR Code Page';
  const handleNavigation = (0, _react.useCallback)(() => {
    trackEvent({
      event: _metametrics2.MetaMetricsEventName.BlockExplorerLinkClicked,
      category: _metametrics2.MetaMetricsEventCategory.Accounts,
      properties: {
        location: metricsLocation,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        chain_id: chainId
      }
    });
    (0, _viewExplorerMenuItem.openBlockExplorer)(addressLink, metricsLocation, trackEvent);
  }, [chainId, trackEvent, addressLink]);
  const getExplorerButtonText = () => {
    switch ((0, _accountDetails.getAccountTypeCategory)(account)) {
      case 'evm':
        return t('viewAddressOnExplorer', ['Etherscan']);
      case 'solana':
        return t('viewAddressOnExplorer', ['Solscan']);
      default:
        return t('viewOnExplorer');
    }
  };
  return /*#__PURE__*/_react.default.createElement(_page.Page, {
    className: "address-qr-code-page"
  }, /*#__PURE__*/_react.default.createElement(_page.Header, {
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    startAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      ariaLabel: "Back",
      iconName: _componentLibrary.IconName.ArrowLeft,
      size: _componentLibrary.ButtonIconSize.Sm,
      onClick: () => history.goBack()
    })
  }, t('address')), /*#__PURE__*/_react.default.createElement(_page.Content, {
    paddingTop: 0
  }, /*#__PURE__*/_react.default.createElement(_qrCodeView.default, {
    Qr: {
      data: address
    },
    location: "Account Details Page",
    accountName: account.metadata.name
  })), /*#__PURE__*/_react.default.createElement(_page.Footer, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonSecondary, {
    onClick: handleNavigation,
    size: _componentLibrary.ButtonSecondarySize.Lg,
    "data-testid": addressLink,
    textProps: {
      variant: _designSystem.TextVariant.bodyMdMedium
    },
    style: {
      width: '100%'
    }
  }, getExplorerButtonText())));
};
exports.AddressQRCode = AddressQRCode;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\multichain-accounts\\address-qr-code\\address-qr-code.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\address-qr-code\\index.ts", {"./address-qr-code":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\address-qr-code\\address-qr-code.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cmultichain-accounts%5Caddress-qr-code%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _addressQrCode = require("./address-qr-code");
Object.keys(_addressQrCode).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _addressQrCode[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _addressQrCode[key];
    }
  });
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\multichain-accounts\\address-qr-code\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\base-account-details\\base-account-details.tsx", {"../../../../shared/constants/keyring":"D:\\code\\v\\metamask-extension\\shared\\constants\\keyring.ts","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/modules/hexstring-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\hexstring-utils.ts","../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../components/app/preferred-avatar":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\preferred-avatar\\index.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/component-library/icon":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\icon\\index.ts","../../../components/multichain-accounts/account-details-row":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\account-details-row\\index.ts","../../../components/multichain-accounts/account-remove-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\account-remove-modal\\index.ts","../../../components/multichain-accounts/edit-account-name-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\edit-account-name-modal\\index.ts","../../../components/multichain/pages/page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\index.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../helpers/utils/metrics":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\metrics.js","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cmultichain-accounts%5Cbase-account-details%5Cbase-account-details.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BaseAccountDetails = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _keyringApi = require("@metamask/keyring-api");
var _bridgeController = require("@metamask/bridge-controller");
var _designSystemReact = require("@metamask/design-system-react");
var _selectors = require("../../../selectors");
var _componentLibrary = require("../../../components/component-library");
var _page = require("../../../components/multichain/pages/page");
var _designSystem = require("../../../helpers/constants/design-system");
var _routes = require("../../../helpers/constants/routes");
var _icon = require("../../../components/component-library/icon");
var _hexstringUtils = require("../../../../shared/modules/hexstring-utils");
var _util = require("../../../helpers/utils/util");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _accountDetailsRow = require("../../../components/multichain-accounts/account-details-row");
var _editAccountNameModal = require("../../../components/multichain-accounts/edit-account-name-modal");
var _actions = require("../../../store/actions");
var _accountTree = require("../../../selectors/multichain-accounts/account-tree");
var _keyring = require("../../../../shared/constants/keyring");
var _accountRemoveModal = require("../../../components/multichain-accounts/account-remove-modal");
var _metametrics = require("../../../../shared/constants/metametrics");
var _metametrics2 = require("../../../contexts/metametrics");
var _networks = require("../../../../shared/modules/selectors/networks");
var _metrics = require("../../../helpers/utils/metrics");
var _preferredAvatar = require("../../../components/app/preferred-avatar");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BaseAccountDetails = ({
  children,
  account,
  address
}) => {
  var _toChecksumHexAddress;
  const history = (0, _reactRouterDom.useHistory)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const t = (0, _useI18nContext.useI18nContext)();
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const chainId = (0, _reactRedux.useSelector)(_networks.getCurrentChainId);
  const hdEntropyIndex = (0, _reactRedux.useSelector)(_selectors.getHDEntropyIndex);
  const deviceName = (0, _reactRedux.useSelector)(_selectors.getHardwareWalletType);
  const socialLoginFlow = (0, _reactRedux.useSelector)(_selectors.getIsSocialLoginFlow);
  const {
    metadata: {
      name
    },
    type
  } = account;
  const formattedAddress = (0, _keyringApi.isEvmAccountType)(type) ? (_toChecksumHexAddress = (0, _hexstringUtils.toChecksumHexAddress)(address)) === null || _toChecksumHexAddress === void 0 ? void 0 : _toChecksumHexAddress.toLowerCase() : address;
  const shortenedAddress = (0, _util.shortenAddress)(formattedAddress);
  const [isEditingAccountName, setIsEditingAccountName] = (0, _react.useState)(false);
  const handleShowAddress = () => {
    history.push(`${_routes.ACCOUNT_DETAILS_QR_CODE_ROUTE}/${address}`);
  };
  const {
    keyring
  } = account.metadata;
  const accountType = (0, _metrics.formatAccountType)((0, _selectors.getAccountTypeForKeyring)(keyring));
  const handleNavigation = (0, _react.useCallback)(() => {
    dispatch((0, _actions.setAccountDetailsAddress)(''));
    history.goBack();
  }, [history, dispatch]);

  // we can never have a scenario where an account is not associated with a wallet.
  const {
    id: walletId,
    name: walletName
  } = (0, _reactRedux.useSelector)(state => (0, _accountTree.getWalletIdAndNameByAccountAddress)(state, address));
  const walletRoute = `/wallet-details/${encodeURIComponent(walletId)}`;
  const isRemovable = account.metadata.keyring.type !== _keyring.KeyringType.hdKeyTree && !(0, _selectors.isSolanaAccount)(account) && !socialLoginFlow; // social login accounts are not removable

  const [showAccountRemoveModal, setShowAccountRemoveModal] = (0, _react.useState)(false);
  const handleAccountRemoveAction = (0, _react.useCallback)(() => {
    dispatch((0, _actions.removeAccount)(account.address));
    trackEvent({
      event: _metametrics.MetaMetricsEventName.AccountRemoved,
      category: _metametrics.MetaMetricsEventCategory.Accounts,
      properties: {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        account_hardware_type: deviceName,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        chain_id: chainId,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        account_type: accountType,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        hd_entropy_index: hdEntropyIndex,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        caip_chain_id: (0, _bridgeController.formatChainIdToCaip)(chainId)
      }
    });
    dispatch((0, _actions.setAccountDetailsAddress)(''));
    history.push(_routes.DEFAULT_ROUTE);
  }, [dispatch, account.address, trackEvent, deviceName, chainId, accountType, hdEntropyIndex, history]);
  return /*#__PURE__*/_react.default.createElement(_page.Page, {
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    className: "multichain-account-details-page"
  }, /*#__PURE__*/_react.default.createElement(_page.Header, {
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    startAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      ariaLabel: "Back",
      iconName: _icon.IconName.ArrowLeft,
      size: _componentLibrary.ButtonIconSize.Sm,
      onClick: handleNavigation
    })
  }, name), /*#__PURE__*/_react.default.createElement(_page.Content, {
    paddingTop: 3,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "flex justify-center"
  }, /*#__PURE__*/_react.default.createElement(_preferredAvatar.PreferredAvatar, {
    address: address,
    size: _designSystemReact.AvatarAccountSize.Xl,
    "data-testid": "avatar"
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "multichain-account-details__section"
  }, /*#__PURE__*/_react.default.createElement(_accountDetailsRow.AccountDetailsRow, {
    label: t('accountName'),
    value: name,
    endAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      iconName: _icon.IconName.Edit,
      color: _designSystem.IconColor.iconAlternative,
      size: _componentLibrary.ButtonIconSize.Md,
      ariaLabel: t('edit'),
      marginLeft: 2
    }),
    onClick: () => setIsEditingAccountName(true)
  }), /*#__PURE__*/_react.default.createElement(_accountDetailsRow.AccountDetailsRow, {
    label: t('address'),
    value: shortenedAddress,
    endAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      iconName: _icon.IconName.ArrowRight,
      color: _designSystem.IconColor.iconAlternative,
      size: _componentLibrary.ButtonIconSize.Md,
      ariaLabel: t('next'),
      marginLeft: 2,
      "data-testid": "account-address-navigation-button"
    }),
    onClick: handleShowAddress
  }), /*#__PURE__*/_react.default.createElement(_accountDetailsRow.AccountDetailsRow, {
    label: t('wallet'),
    value: walletName,
    endAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      iconName: _icon.IconName.ArrowRight,
      color: _designSystem.IconColor.iconAlternative,
      size: _componentLibrary.ButtonIconSize.Md,
      ariaLabel: t('next'),
      marginLeft: 2,
      "data-testid": "wallet-details-link"
    }),
    onClick: () => {
      history.push(walletRoute);
    }
  })), children, isRemovable && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "multichain-account-details__remove_account_section"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    size: _componentLibrary.ButtonSize.Lg,
    width: _designSystem.BlockSize.Full,
    variant: _componentLibrary.ButtonVariant.Secondary,
    danger: true,
    onClick: () => setShowAccountRemoveModal(true)
  }, t('removeAccount'))), isEditingAccountName && /*#__PURE__*/_react.default.createElement(_editAccountNameModal.EditAccountNameModal, {
    isOpen: isEditingAccountName,
    onClose: () => setIsEditingAccountName(false),
    currentAccountName: name,
    address: address
  }), showAccountRemoveModal && /*#__PURE__*/_react.default.createElement(_accountRemoveModal.AccountRemoveModal, {
    isOpen: showAccountRemoveModal,
    onClose: () => setShowAccountRemoveModal(false),
    onSubmit: handleAccountRemoveAction,
    accountName: account.metadata.name,
    accountAddress: account.address
  })));
};
exports.BaseAccountDetails = BaseAccountDetails;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\multichain-accounts\\base-account-details\\base-account-details.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\multichain-account-address-list-page\\index.ts", {"./multichain-account-address-list-page":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\multichain-account-address-list-page\\multichain-account-address-list-page.tsx","./multichain-account-address-list-page.types":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\multichain-account-address-list-page\\multichain-account-address-list-page.types.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cmultichain-accounts%5Cmultichain-account-address-list-page%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "AddressListQueryParams", {
  enumerable: true,
  get: function () {
    return _multichainAccountAddressListPage2.AddressListQueryParams;
  }
});
Object.defineProperty(exports, "AddressListSource", {
  enumerable: true,
  get: function () {
    return _multichainAccountAddressListPage2.AddressListSource;
  }
});
Object.defineProperty(exports, "MultichainAccountAddressListPage", {
  enumerable: true,
  get: function () {
    return _multichainAccountAddressListPage.MultichainAccountAddressListPage;
  }
});
var _multichainAccountAddressListPage = require("./multichain-account-address-list-page");
var _multichainAccountAddressListPage2 = require("./multichain-account-address-list-page.types");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\multichain-accounts\\multichain-account-address-list-page\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\multichain-account-address-list-page\\multichain-account-address-list-page.tsx", {"../../../components/multichain-accounts/address-qr-code-modal/address-qr-code-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\address-qr-code-modal\\address-qr-code-modal.tsx","../../../components/multichain-accounts/multichain-address-rows-list":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-address-rows-list\\index.ts","../../../components/multichain/pages/page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","./multichain-account-address-list-page.types":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\multichain-account-address-list-page\\multichain-account-address-list-page.types.ts","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cmultichain-accounts%5Cmultichain-account-address-list-page%5Cmultichain-account-address-list-page.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultichainAccountAddressListPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _designSystemReact = require("@metamask/design-system-react");
var _page = require("../../../components/multichain/pages/page");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _multichainAddressRowsList = require("../../../components/multichain-accounts/multichain-address-rows-list");
var _accountTree = require("../../../selectors/multichain-accounts/account-tree");
var _addressQrCodeModal = require("../../../components/multichain-accounts/address-qr-code-modal/address-qr-code-modal");
var _multichainAccountAddressListPage = require("./multichain-account-address-list-page.types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MultichainAccountAddressListPage = () => {
  var _accountGroup$metadat, _accountGroup$metadat2;
  const t = (0, _useI18nContext.useI18nContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const location = (0, _reactRouterDom.useLocation)();
  const {
    accountGroupId
  } = (0, _reactRouterDom.useParams)();
  const decodedAccountGroupId = accountGroupId ? decodeURIComponent(accountGroupId) : null;
  const accountGroup = (0, _reactRedux.useSelector)(state => decodedAccountGroupId ? (0, _accountTree.getMultichainAccountGroupById)(state, decodedAccountGroupId) : null);
  const searchParams = new URLSearchParams(location.search);
  const isReceiveMode = searchParams.get(_multichainAccountAddressListPage.AddressListQueryParams.Source) === _multichainAccountAddressListPage.AddressListSource.Receive;
  const pageTitle = isReceiveMode ? t('receivingAddress') : `${(accountGroup === null || accountGroup === void 0 || (_accountGroup$metadat = accountGroup.metadata) === null || _accountGroup$metadat === void 0 ? void 0 : _accountGroup$metadat.name) || t('account')} / ${t('addresses')}`;

  // QR Modal state
  const [isQRModalOpen, setIsQRModalOpen] = (0, _react.useState)(false);
  const [selectedQRData, setSelectedQRData] = (0, _react.useState)(null);

  // QR Modal handlers
  const handleShowQR = (0, _react.useCallback)((address, networkName, chainId, networkImageSrc) => {
    setSelectedQRData({
      address,
      networkName,
      chainId,
      networkImageSrc
    });
    setIsQRModalOpen(true);
  }, []);
  const handleCloseQR = (0, _react.useCallback)(() => {
    setIsQRModalOpen(false);
    setSelectedQRData(null);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_page.Page, {
    className: "max-w-[600px]"
  }, /*#__PURE__*/_react.default.createElement(_page.Header, {
    textProps: {
      variant: _designSystem.TextVariant.headingSm
    },
    startAccessory: /*#__PURE__*/_react.default.createElement(_designSystemReact.ButtonIcon, {
      size: _designSystemReact.ButtonIconSize.Md,
      ariaLabel: t('back'),
      iconName: _designSystemReact.IconName.ArrowLeft,
      onClick: () => history.goBack(),
      "data-testid": "multichain-account-address-list-page-back-button"
    })
  }, pageTitle), /*#__PURE__*/_react.default.createElement(_page.Content, {
    padding: 0
  }, /*#__PURE__*/_react.default.createElement(_designSystemReact.Box, {
    flexDirection: _designSystemReact.BoxFlexDirection.Column
  }, decodedAccountGroupId ? /*#__PURE__*/_react.default.createElement(_multichainAddressRowsList.MultichainAddressRowsList, {
    groupId: decodedAccountGroupId,
    onQrClick: handleShowQR
  }) : null)), selectedQRData && /*#__PURE__*/_react.default.createElement(_addressQrCodeModal.AddressQRCodeModal, {
    isOpen: isQRModalOpen,
    onClose: handleCloseQR,
    address: selectedQRData.address,
    accountName: (accountGroup === null || accountGroup === void 0 || (_accountGroup$metadat2 = accountGroup.metadata) === null || _accountGroup$metadat2 === void 0 ? void 0 : _accountGroup$metadat2.name) || t('account'),
    networkName: selectedQRData.networkName,
    chainId: selectedQRData.chainId,
    networkImageSrc: selectedQRData.networkImageSrc
  }));
};
exports.MultichainAccountAddressListPage = MultichainAccountAddressListPage;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\multichain-accounts\\multichain-account-address-list-page\\multichain-account-address-list-page.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\multichain-account-address-list-page\\multichain-account-address-list-page.types.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cmultichain-accounts%5Cmultichain-account-address-list-page%5Cmultichain-account-address-list-page.types.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddressListSource = exports.AddressListQueryParams = void 0;
/**
 * Query parameter names for the multichain account address list page
 */
let AddressListQueryParams = exports.AddressListQueryParams = /*#__PURE__*/function (AddressListQueryParams) {
  AddressListQueryParams["Source"] = "source";
  return AddressListQueryParams;
}({});
/**
 * Source values for the multichain account address list page
 * Used to determine the context/mode of the page
 */
let AddressListSource = exports.AddressListSource = /*#__PURE__*/function (AddressListSource) {
  AddressListSource["Receive"] = "receive";
  return AddressListSource;
}({});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\multichain-accounts\\multichain-account-address-list-page\\multichain-account-address-list-page.types.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\multichain-account-details-page\\index.ts", {"./multichain-account-details-page":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\multichain-account-details-page\\multichain-account-details-page.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cmultichain-accounts%5Cmultichain-account-details-page%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "MultichainAccountDetailsPage", {
  enumerable: true,
  get: function () {
    return _multichainAccountDetailsPage.MultichainAccountDetailsPage;
  }
});
var _multichainAccountDetailsPage = require("./multichain-account-details-page");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\multichain-accounts\\multichain-account-details-page\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\multichain-account-details-page\\multichain-account-details-page.tsx", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../components/app/preferred-avatar":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\preferred-avatar\\index.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/multichain-accounts/account-details-row":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\account-details-row\\index.ts","../../../components/multichain-accounts/account-remove-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\account-remove-modal\\index.ts","../../../components/multichain-accounts/multichain-account-edit-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-account-edit-modal\\index.ts","../../../components/multichain-accounts/multichain-srp-backup":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-srp-backup\\index.ts","../../../components/multichain/pages/page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\index.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../hooks/multichain-accounts/useWalletInfo":"D:\\code\\v\\metamask-extension\\ui\\hooks\\multichain-accounts\\useWalletInfo.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","../../../selectors/multichain-accounts/utils":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\utils.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","@metamask/account-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\index.cjs","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","@metamask/keyring-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-controller\\dist\\index.cjs","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cmultichain-accounts%5Cmultichain-account-details-page%5Cmultichain-account-details-page.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultichainAccountDetailsPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _accountApi = require("@metamask/account-api");
var _classnames = _interopRequireDefault(require("classnames"));
var _designSystemReact = require("@metamask/design-system-react");
var _keyringController = require("@metamask/keyring-controller");
var _componentLibrary = require("../../../components/component-library");
var _preferredAvatar = require("../../../components/app/preferred-avatar");
var _page = require("../../../components/multichain/pages/page");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _accountDetailsRow = require("../../../components/multichain-accounts/account-details-row");
var _accountTree = require("../../../selectors/multichain-accounts/account-tree");
var _utils = require("../../../selectors/multichain-accounts/utils");
var _routes = require("../../../helpers/constants/routes");
var _multichainSrpBackup = require("../../../components/multichain-accounts/multichain-srp-backup");
var _useWalletInfo = require("../../../hooks/multichain-accounts/useWalletInfo");
var _multichainAccountEditModal = require("../../../components/multichain-accounts/multichain-account-edit-modal");
var _accountRemoveModal = require("../../../components/multichain-accounts/account-remove-modal");
var _actions = require("../../../store/actions");
var _metametrics = require("../../../../shared/constants/metametrics");
var _metametrics2 = require("../../../contexts/metametrics");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MultichainAccountDetailsPage = () => {
  var _accountsWithAddresse2;
  const t = (0, _useI18nContext.useI18nContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const {
    id
  } = (0, _reactRouterDom.useParams)();
  const accountGroupId = decodeURIComponent(id);
  const multichainAccount = (0, _reactRedux.useSelector)(state => (0, _accountTree.getMultichainAccountGroupById)(state, accountGroupId));
  const walletId = (0, _utils.extractWalletIdFromGroupId)(accountGroupId);
  const wallet = (0, _reactRedux.useSelector)(state => (0, _accountTree.getWallet)(state, walletId));
  const {
    keyringId,
    isSRPBackedUp
  } = (0, _useWalletInfo.useWalletInfo)(walletId);
  const walletRoute = `${_routes.MULTICHAIN_WALLET_DETAILS_PAGE_ROUTE}/${encodeURIComponent(walletId)}`;
  const isRemovable = (wallet === null || wallet === void 0 ? void 0 : wallet.type) !== _accountApi.AccountWalletType.Entropy && (wallet === null || wallet === void 0 ? void 0 : wallet.type) !== _accountApi.AccountWalletType.Snap;
  const addressCount = (0, _reactRedux.useSelector)(state => (0, _accountTree.getNetworkAddressCount)(state, accountGroupId));
  const accountsWithAddresses = (0, _reactRedux.useSelector)(state => (0, _accountTree.getInternalAccountsFromGroupById)(state, accountGroupId));
  const evmInternalAccount = (0, _reactRedux.useSelector)(state => (0, _accountTree.getInternalAccountByGroupAndCaip)(state, accountGroupId, 'eip155:1'));
  const seedAddressIcon = (0, _reactRedux.useSelector)(state => (0, _accountTree.getIconSeedAddressByAccountGroupId)(state, accountGroupId));
  const [isAccountRenameModalOpen, setIsAccountRenameModalOpen] = (0, _react.useState)(false);
  const [isAccountRemoveModalOpen, setIsAccountRemoveModalOpen] = (0, _react.useState)(false);
  const isEntropyWallet = (wallet === null || wallet === void 0 ? void 0 : wallet.type) === _accountApi.AccountWalletType.Entropy;
  const isPrivateKeyWallet = accountsWithAddresses.some(account => account.metadata.keyring.type === _keyringController.KeyringTypes.simple);
  const shouldShowBackupReminder = isSRPBackedUp === false;
  const handleAddressesClick = () => {
    history.push(`${_routes.MULTICHAIN_ACCOUNT_ADDRESS_LIST_PAGE_ROUTE}/${encodeURIComponent(accountGroupId)}`);
  };
  const handlePrivateKeysClick = () => {
    history.push(`${_routes.MULTICHAIN_ACCOUNT_PRIVATE_KEY_LIST_PAGE_ROUTE}/${encodeURIComponent(accountGroupId)}`);
  };
  const handleSmartAccountClick = () => {
    const evmAccountAddress = evmInternalAccount === null || evmInternalAccount === void 0 ? void 0 : evmInternalAccount.address;
    if (evmAccountAddress) {
      history.push(`${_routes.MULTICHAIN_SMART_ACCOUNT_PAGE_ROUTE}/${encodeURIComponent(evmAccountAddress)}`);
    }
  };
  const handleAccountNameAction = () => {
    setIsAccountRenameModalOpen(true);
  };
  const handleAccountRemoveAction = (0, _react.useCallback)(() => {
    var _accountsWithAddresse;
    const firstAccountAddress = (_accountsWithAddresse = accountsWithAddresses[0]) === null || _accountsWithAddresse === void 0 ? void 0 : _accountsWithAddresse.address;
    if (firstAccountAddress) {
      // Don't want to blindly call removeAccount without an invalid or empty parameter
      dispatch((0, _actions.removeAccount)(firstAccountAddress));
      trackEvent({
        event: _metametrics.MetaMetricsEventName.AccountRemoved,
        category: _metametrics.MetaMetricsEventCategory.Accounts,
        properties: {
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          account_type: wallet === null || wallet === void 0 ? void 0 : wallet.type
        }
      });
      dispatch((0, _actions.setAccountDetailsAddress)(''));
      history.push(_routes.DEFAULT_ROUTE);
    }
  }, [dispatch, trackEvent, history, wallet === null || wallet === void 0 ? void 0 : wallet.type, accountsWithAddresses]);
  const handleWalletAction = () => {
    history.push(walletRoute);
  };
  return /*#__PURE__*/_react.default.createElement(_page.Page, {
    className: "multichain-account-details-page"
  }, /*#__PURE__*/_react.default.createElement(_page.Header, {
    textProps: {
      variant: _designSystem.TextVariant.headingSm
    },
    startAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      size: _componentLibrary.ButtonIconSize.Md,
      ariaLabel: t('back'),
      iconName: _componentLibrary.IconName.ArrowLeft,
      onClick: () => history.goBack(),
      "data-testid": "back-button"
    })
  }, multichainAccount.metadata.name), /*#__PURE__*/_react.default.createElement(_page.Content, {
    className: "multichain-account-details-page__content",
    paddingTop: 3,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "flex justify-center",
    paddingBottom: 6
  }, /*#__PURE__*/_react.default.createElement(_preferredAvatar.PreferredAvatar, {
    address: seedAddressIcon,
    size: _designSystemReact.AvatarAccountSize.Xl,
    "data-testid": "avatar"
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "multichain-account-details-page__section"
  }, /*#__PURE__*/_react.default.createElement(_accountDetailsRow.AccountDetailsRow, {
    label: t('accountName'),
    value: multichainAccount.metadata.name,
    onClick: handleAccountNameAction,
    endAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      iconName: _componentLibrary.IconName.ArrowRight,
      color: _designSystem.IconColor.iconAlternative,
      size: _componentLibrary.ButtonIconSize.Sm,
      ariaLabel: t('accountName'),
      marginLeft: 2,
      "data-testid": "account-name-action"
    })
  }), /*#__PURE__*/_react.default.createElement(_accountDetailsRow.AccountDetailsRow, {
    label: t('networks'),
    value: `${addressCount} ${addressCount > 1 ? t('addressesLabel') : t('addressLabel')}`,
    onClick: handleAddressesClick,
    endAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      iconName: _componentLibrary.IconName.ArrowRight,
      color: _designSystem.IconColor.iconAlternative,
      size: _componentLibrary.ButtonIconSize.Sm,
      ariaLabel: t('addresses'),
      marginLeft: 2,
      "data-testid": "network-addresses-link"
    })
  }), (isEntropyWallet || isPrivateKeyWallet) && /*#__PURE__*/_react.default.createElement(_accountDetailsRow.AccountDetailsRow, {
    label: t('privateKeys'),
    value: t('unlockToReveal'),
    onClick: handlePrivateKeysClick,
    endAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      iconName: _componentLibrary.IconName.ArrowRight,
      color: _designSystem.IconColor.iconAlternative,
      size: _componentLibrary.ButtonIconSize.Sm,
      ariaLabel: t('privateKeys'),
      marginLeft: 2,
      "data-testid": "private-keys-action"
    })
  }), /*#__PURE__*/_react.default.createElement(_accountDetailsRow.AccountDetailsRow, {
    label: t('smartAccountLabel'),
    value: t('setUp'),
    onClick: handleSmartAccountClick,
    endAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      iconName: _componentLibrary.IconName.ArrowRight,
      color: _designSystem.IconColor.iconAlternative,
      size: _componentLibrary.ButtonIconSize.Sm,
      ariaLabel: t('smartAccountLabel'),
      marginLeft: 2,
      "data-testid": "smart-account-action"
    })
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "multichain-account-details-page__section"
  }, /*#__PURE__*/_react.default.createElement(_accountDetailsRow.AccountDetailsRow, {
    label: t('wallet'),
    value: wallet.metadata.name,
    onClick: handleWalletAction,
    endAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      iconName: _componentLibrary.IconName.ArrowRight,
      color: _designSystem.IconColor.iconAlternative,
      size: _componentLibrary.ButtonIconSize.Sm,
      ariaLabel: t('wallet'),
      marginLeft: 2,
      "data-testid": "wallet-details-link"
    })
  }), isEntropyWallet ? /*#__PURE__*/_react.default.createElement(_multichainSrpBackup.MultichainSrpBackup, {
    className: (0, _classnames.default)('multichain-account-details__row', 'multichain-account-details-page__srp-button'),
    shouldShowBackupReminder: shouldShowBackupReminder,
    keyringId: keyringId
  }) : null), isRemovable && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "multichain-account-details-page__section"
  }, /*#__PURE__*/_react.default.createElement(_accountDetailsRow.AccountDetailsRow, {
    label: t('removeAccount'),
    labelColor: _designSystem.TextColor.errorDefault,
    value: '',
    onClick: () => setIsAccountRemoveModalOpen(true),
    endAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      iconName: _componentLibrary.IconName.ArrowRight,
      color: _designSystem.IconColor.iconAlternative,
      size: _componentLibrary.ButtonIconSize.Md,
      ariaLabel: t('removeAccount'),
      marginLeft: 2,
      "data-testid": "account-remove-action"
    })
  })), isAccountRenameModalOpen && /*#__PURE__*/_react.default.createElement(_multichainAccountEditModal.MultichainAccountEditModal, {
    isOpen: isAccountRenameModalOpen,
    onClose: () => setIsAccountRenameModalOpen(false),
    accountGroupId: multichainAccount.id
  }), isAccountRemoveModalOpen && /*#__PURE__*/_react.default.createElement(_accountRemoveModal.AccountRemoveModal, {
    isOpen: isAccountRemoveModalOpen,
    onClose: () => setIsAccountRemoveModalOpen(false),
    onSubmit: handleAccountRemoveAction,
    accountName: multichainAccount.metadata.name,
    accountAddress: (_accountsWithAddresse2 = accountsWithAddresses[0]) === null || _accountsWithAddresse2 === void 0 ? void 0 : _accountsWithAddresse2.address
  })));
};
exports.MultichainAccountDetailsPage = MultichainAccountDetailsPage;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\multichain-accounts\\multichain-account-details-page\\multichain-account-details-page.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\multichain-account-private-key-list-page\\index.ts", {"./multichain-account-private-key-list-page":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\multichain-account-private-key-list-page\\multichain-account-private-key-list-page.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cmultichain-accounts%5Cmultichain-account-private-key-list-page%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "MultichainAccountPrivateKeyListPage", {
  enumerable: true,
  get: function () {
    return _multichainAccountPrivateKeyListPage.MultichainAccountPrivateKeyListPage;
  }
});
var _multichainAccountPrivateKeyListPage = require("./multichain-account-private-key-list-page");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\multichain-accounts\\multichain-account-private-key-list-page\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\multichain-account-private-key-list-page\\multichain-account-private-key-list-page.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/multichain-accounts/multichain-private-key-list":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-private-key-list\\index.ts","../../../components/multichain/pages/page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/zendesk-url":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\zendesk-url.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cmultichain-accounts%5Cmultichain-account-private-key-list-page%5Cmultichain-account-private-key-list-page.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultichainAccountPrivateKeyListPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _designSystemReact = require("@metamask/design-system-react");
var _page = require("../../../components/multichain/pages/page");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _multichainPrivateKeyList = require("../../../components/multichain-accounts/multichain-private-key-list");
var _componentLibrary = require("../../../components/component-library");
var _accountTree = require("../../../selectors/multichain-accounts/account-tree");
var _zendeskUrl = _interopRequireDefault(require("../../../helpers/constants/zendesk-url"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MultichainAccountPrivateKeyListPage = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    accountGroupId
  } = (0, _reactRouterDom.useParams)();
  const decodedAccountGroupId = accountGroupId ? decodeURIComponent(accountGroupId) : null;
  const account = (0, _reactRedux.useSelector)(state => decodedAccountGroupId ? (0, _accountTree.getMultichainAccountGroupById)(state, decodedAccountGroupId) : null);

  // Compute the account group name using `useMemo`
  const accountGroupName = (0, _react.useMemo)(() => {
    return account ? account.metadata.name : t('account');
  }, [account, t]);
  const learnMoreLink = /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    size: _componentLibrary.ButtonLinkSize.Inherit,
    textProps: {
      variant: _designSystem.TextVariant.bodyMd,
      alignItems: _designSystem.AlignItems.flexStart
    },
    as: "a",
    href: _zendeskUrl.default.PRIVATE_KEY_GUIDE,
    target: "_blank",
    rel: "noopener noreferrer"
  }, t('learnMoreUpperCase'));
  return /*#__PURE__*/_react.default.createElement(_page.Page, {
    className: "max-w-[600px]"
  }, /*#__PURE__*/_react.default.createElement(_page.Header, {
    textProps: {
      variant: _designSystem.TextVariant.headingSm
    },
    startAccessory: /*#__PURE__*/_react.default.createElement(_designSystemReact.ButtonIcon, {
      size: _designSystemReact.ButtonIconSize.Md,
      ariaLabel: t('back'),
      iconName: _designSystemReact.IconName.ArrowLeft,
      onClick: () => history.goBack(),
      "data-testid": "multichain-account-address-list-page-back-button"
    })
  }, accountGroupName, " / ", t('privateKeys')), /*#__PURE__*/_react.default.createElement(_page.Content, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerAlert, {
    "data-testid": "backup-state-banner-alert",
    title: t('revealMultichainPrivateKeysBannerTitle'),
    paddingTop: 2,
    paddingBottom: 2,
    severity: _componentLibrary.BannerAlertSeverity.Danger
  }, t('revealMultichainPrivateKeysBannerDescription', [learnMoreLink])), /*#__PURE__*/_react.default.createElement(_designSystemReact.Box, {
    flexDirection: _designSystemReact.BoxFlexDirection.Column
  }, decodedAccountGroupId ? /*#__PURE__*/_react.default.createElement(_multichainPrivateKeyList.MultichainPrivateKeyList, {
    groupId: decodedAccountGroupId,
    goBack: history.goBack,
    "data-testid": "multichain-account-private-key-list"
  }) : null)));
};
exports.MultichainAccountPrivateKeyListPage = MultichainAccountPrivateKeyListPage;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\multichain-accounts\\multichain-account-private-key-list-page\\multichain-account-private-key-list-page.tsx",}]],[],{})

//# sourceMappingURL=data:application/json;charset=utf8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvaG9va3MvYWxlcnRzL3RyYW5zYWN0aW9ucy91c2VNdWx0aXBsZUFwcHJvdmFsc0FsZXJ0cy50cyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvaG9va3MvYWxlcnRzL3RyYW5zYWN0aW9ucy91c2VOb0dhc1ByaWNlQWxlcnRzLnRzIiwidWkvcGFnZXMvY29uZmlybWF0aW9ucy9ob29rcy9hbGVydHMvdHJhbnNhY3Rpb25zL3VzZU5vbkNvbnRyYWN0QWRkcmVzc0FsZXJ0cy50cyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvaG9va3MvYWxlcnRzL3RyYW5zYWN0aW9ucy91c2VQZW5kaW5nVHJhbnNhY3Rpb25BbGVydHMudHMiLCJ1aS9wYWdlcy9jb25maXJtYXRpb25zL2hvb2tzL2FsZXJ0cy90cmFuc2FjdGlvbnMvdXNlUmVzaW11bGF0aW9uQWxlcnQudHMiLCJ1aS9wYWdlcy9jb25maXJtYXRpb25zL2hvb2tzL2FsZXJ0cy90cmFuc2FjdGlvbnMvdXNlU2lnbmluZ09yU3VibWl0dGluZ0FsZXJ0cy50cyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvaG9va3MvYWxlcnRzL3VzZUFkZHJlc3NUcnVzdFNpZ25hbEFsZXJ0cy50cyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvaG9va3MvYWxlcnRzL3VzZUJsb2NrYWlkQWxlcnRzLnRzIiwidWkvcGFnZXMvY29uZmlybWF0aW9ucy9ob29rcy9hbGVydHMvdXNlQ29uZmlybWF0aW9uT3JpZ2luQWxlcnRzLnRzIiwidWkvcGFnZXMvY29uZmlybWF0aW9ucy9ob29rcy9hbGVydHMvdXNlTmV0d29ya0FuZE9yaWdpblN3aXRjaGluZ0FsZXJ0cy50cyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvaG9va3MvYWxlcnRzL3VzZU9yaWdpblRydXN0U2lnbmFsQWxlcnRzLnRzIiwidWkvcGFnZXMvY29uZmlybWF0aW9ucy9ob29rcy9hbGVydHMvdXNlU2VsZWN0ZWRBY2NvdW50QWxlcnRzLnRzIiwidWkvcGFnZXMvY29uZmlybWF0aW9ucy9ob29rcy9hbGVydHMvdXNlU2hpZWxkQ292ZXJhZ2VBbGVydC50cyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvaG9va3MvYWxlcnRzL3VzZVRva2VuVHJ1c3RTaWduYWxBbGVydHMudHMiLCJ1aS9wYWdlcy9jb25maXJtYXRpb25zL2hvb2tzL2FsZXJ0cy91dGlscy50cyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvaG9va3MvZ2FzL3VzZUlzR2FzbGVzc0xvYWRpbmcudHMiLCJ1aS9wYWdlcy9jb25maXJtYXRpb25zL2hvb2tzL2dhcy91c2VJc0dhc2xlc3NTdXBwb3J0ZWQudHMiLCJ1aS9wYWdlcy9jb25maXJtYXRpb25zL2hvb2tzL3NlbmQvbWV0cmljcy91c2VBbW91bnRTZWxlY3Rpb25NZXRyaWNzLnRzIiwidWkvcGFnZXMvY29uZmlybWF0aW9ucy9ob29rcy9zZW5kL21ldHJpY3MvdXNlQXNzZXRTZWxlY3Rpb25NZXRyaWNzLnRzIiwidWkvcGFnZXMvY29uZmlybWF0aW9ucy9ob29rcy9zZW5kL21ldHJpY3MvdXNlUmVjaXBpZW50U2VsZWN0aW9uTWV0cmljcy50cyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvaG9va3Mvc2VuZC91c2VBY2NvdW50QWRkcmVzc1NlZWRJY29uTWFwLnRzIiwidWkvcGFnZXMvY29uZmlybWF0aW9ucy9ob29rcy9zZW5kL3VzZUFjY291bnRSZWNpcGllbnRzLnRzIiwidWkvcGFnZXMvY29uZmlybWF0aW9ucy9ob29rcy9zZW5kL3VzZUFtb3VudFZhbGlkYXRpb24udHMiLCJ1aS9wYWdlcy9jb25maXJtYXRpb25zL2hvb2tzL3NlbmQvdXNlQmFsYW5jZS50cyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvaG9va3Mvc2VuZC91c2VDb250YWN0UmVjaXBpZW50cy50cyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvaG9va3Mvc2VuZC91c2VDdXJyZW5jeUNvbnZlcnNpb25zLnRzIiwidWkvcGFnZXMvY29uZmlybWF0aW9ucy9ob29rcy9zZW5kL3VzZUVSQzExNTVCYWxhbmNlQ2hlY2tlci50cyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvaG9va3Mvc2VuZC91c2VNYXhBbW91bnQudHMiLCJ1aS9wYWdlcy9jb25maXJtYXRpb25zL2hvb2tzL3NlbmQvdXNlTmFtZVZhbGlkYXRpb24udHMiLCJ1aS9wYWdlcy9jb25maXJtYXRpb25zL2hvb2tzL3NlbmQvdXNlTmF2aWdhdGVTZW5kUGFnZS50cyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvaG9va3Mvc2VuZC91c2VSZWNpcGllbnRWYWxpZGF0aW9uLnRzIiwidWkvcGFnZXMvY29uZmlybWF0aW9ucy9ob29rcy9zZW5kL3VzZVJlY2lwaWVudHMudHMiLCJ1aS9wYWdlcy9jb25maXJtYXRpb25zL2hvb2tzL3NlbmQvdXNlU2VuZEFjdGlvbnMudHMiLCJ1aS9wYWdlcy9jb25maXJtYXRpb25zL2hvb2tzL3NlbmQvdXNlU2VuZEFzc2V0RmlsdGVyLnRzIiwidWkvcGFnZXMvY29uZmlybWF0aW9ucy9ob29rcy9zZW5kL3VzZVNlbmRBc3NldHMudHMiLCJ1aS9wYWdlcy9jb25maXJtYXRpb25zL2hvb2tzL3NlbmQvdXNlU2VuZE5mdHMudHMiLCJ1aS9wYWdlcy9jb25maXJtYXRpb25zL2hvb2tzL3NlbmQvdXNlU2VuZFF1ZXJ5UGFyYW1zLnRzIiwidWkvcGFnZXMvY29uZmlybWF0aW9ucy9ob29rcy9zZW5kL3VzZVNlbmRSZWNpcGllbnRGaWx0ZXIudHMiLCJ1aS9wYWdlcy9jb25maXJtYXRpb25zL2hvb2tzL3NlbmQvdXNlU2VuZFRva2Vucy50cyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvaG9va3Mvc2VuZC91c2VTZW5kVHlwZS50cyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvaG9va3Mvc2V0Q29uZmlybWF0aW9uQWxlcnRzLnRzIiwidWkvcGFnZXMvY29uZmlybWF0aW9ucy9ob29rcy9zeW5jQ29uZmlybVBhdGgudHMiLCJ1aS9wYWdlcy9jb25maXJtYXRpb25zL2hvb2tzL3RyYW5zYWN0aW9ucy91c2VFbmFibGVTaGllbGRDb3ZlcmFnZUNoZWNrcy50cyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvaG9va3MvdHJhbnNhY3Rpb25zL3VzZUlzRW5mb3JjZWRTaW11bGF0aW9uc1N1cHBvcnRlZC50cyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvaG9va3MvdHJhbnNhY3Rpb25zL3VzZVRyYW5zYWN0aW9uQ29uZmlybS50cyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvaG9va3MvdXNlQXNzZXREZXRhaWxzLmpzIiwidWkvcGFnZXMvY29uZmlybWF0aW9ucy9ob29rcy91c2VBdXRvbWF0aWNHYXNGZWVUb2tlblNlbGVjdC50cyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvaG9va3MvdXNlQmFsYW5jZS5qcyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvaG9va3MvdXNlQmF0Y2hBdXRob3JpemF0aW9uUmVxdWVzdHMudHMiLCJ1aS9wYWdlcy9jb25maXJtYXRpb25zL2hvb2tzL3VzZUNoYWluTmV0d29ya05hbWVBbmRJbWFnZS50cyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvaG9va3MvdXNlQ29uZmlybUFjdGlvbnMudHMiLCJ1aS9wYWdlcy9jb25maXJtYXRpb25zL2hvb2tzL3VzZUNvbmZpcm1TZW5kTmF2aWdhdGlvbi50cyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvaG9va3MvdXNlQ29uZmlybWF0aW9uQWxlcnRBY3Rpb25zLnRzIiwidWkvcGFnZXMvY29uZmlybWF0aW9ucy9ob29rcy91c2VDb25maXJtYXRpb25BbGVydE1ldHJpY3MudHMiLCJ1aS9wYWdlcy9jb25maXJtYXRpb25zL2hvb2tzL3VzZUNvbmZpcm1hdGlvbkFsZXJ0cy50cyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvaG9va3MvdXNlQ29uZmlybWF0aW9uTmF2aWdhdGlvbi50cyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvaG9va3MvdXNlQ29uZmlybWF0aW9uTmV0d29ya0luZm8udHMiLCJ1aS9wYWdlcy9jb25maXJtYXRpb25zL2hvb2tzL3VzZUNvbmZpcm1hdGlvblJlY2lwaWVudEluZm8udHMiLCJ1aS9wYWdlcy9jb25maXJtYXRpb25zL2hvb2tzL3VzZUN1cnJlbnRDb25maXJtYXRpb24udHMiLCJ1aS9wYWdlcy9jb25maXJtYXRpb25zL2hvb2tzL3VzZUN1cnJlbnRTaWduYXR1cmVTZWN1cml0eUFsZXJ0UmVzcG9uc2UudHMiLCJ1aS9wYWdlcy9jb25maXJtYXRpb25zL2hvb2tzL3VzZURlY29kZWRTaWduYXR1cmVNZXRyaWNzLnRzIiwidWkvcGFnZXMvY29uZmlybWF0aW9ucy9ob29rcy91c2VEcmFmdFRyYW5zYWN0aW9uV2l0aFR4UGFyYW1zLmpzIiwidWkvcGFnZXMvY29uZmlybWF0aW9ucy9ob29rcy91c2VFSVA3NzAyQWNjb3VudC50cyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvaG9va3MvdXNlRUlQNzcwMk5ldHdvcmtzLnRzIiwidWkvcGFnZXMvY29uZmlybWF0aW9ucy9ob29rcy91c2VHYXNFc3RpbWF0ZXMuanMiLCJ1aS9wYWdlcy9jb25maXJtYXRpb25zL2hvb2tzL3VzZUdhc0ZlZUVycm9ycy5qcyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvaG9va3MvdXNlR2FzRmVlSW5wdXRzLmpzIiwidWkvcGFnZXMvY29uZmlybWF0aW9ucy9ob29rcy91c2VHYXNQcmljZUlucHV0LmpzIiwidWkvcGFnZXMvY29uZmlybWF0aW9ucy9ob29rcy91c2VHZXRUb2tlblN0YW5kYXJkQW5kRGV0YWlscy50cyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvaG9va3MvdXNlSW5jcmVtZW50ZWRHYXNGZWVzLmpzIiwidWkvcGFnZXMvY29uZmlybWF0aW9ucy9ob29rcy91c2VJc0JJUDQ0LnRzIiwidWkvcGFnZXMvY29uZmlybWF0aW9ucy9ob29rcy91c2VJc0luc3VmZmljaWVudEJhbGFuY2UudHMiLCJ1aS9wYWdlcy9jb25maXJtYXRpb25zL2hvb2tzL3VzZUxlZGdlckNvbm5lY3Rpb24udHMiLCJ1aS9wYWdlcy9jb25maXJtYXRpb25zL2hvb2tzL3VzZU1heEZlZVBlckdhc0lucHV0LmpzIiwidWkvcGFnZXMvY29uZmlybWF0aW9ucy9ob29rcy91c2VNYXhQcmlvcml0eUZlZVBlckdhc0lucHV0LmpzIiwidWkvcGFnZXMvY29uZmlybWF0aW9ucy9ob29rcy91c2VOZnRJbWFnZVVybC50cyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvaG9va3MvdXNlT3JpZ2luVGhyb3R0bGluZy50cyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvaG9va3MvdXNlUmVkZXNpZ25lZFNlbmRGbG93LnRzIiwidWkvcGFnZXMvY29uZmlybWF0aW9ucy9ob29rcy91c2VTaWduYXR1cmVFdmVudEZyYWdtZW50LnRzIiwidWkvcGFnZXMvY29uZmlybWF0aW9ucy9ob29rcy91c2VTbWFydEFjY291bnRBY3Rpb25zLnRzIiwidWkvcGFnZXMvY29uZmlybWF0aW9ucy9ob29rcy91c2VTbWFydFRyYW5zYWN0aW9uRmVhdHVyZUZsYWdzLnRzIiwidWkvcGFnZXMvY29uZmlybWF0aW9ucy9ob29rcy91c2VUcmFja0VSQzIwV2l0aG91dERlY2ltYWxJbmZvcm1hdGlvbi50cyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvaG9va3MvdXNlVHJhbnNhY3Rpb25FdmVudEZyYWdtZW50LmpzIiwidWkvcGFnZXMvY29uZmlybWF0aW9ucy9ob29rcy91c2VUcmFuc2FjdGlvbkZvY3VzRWZmZWN0LnRzIiwidWkvcGFnZXMvY29uZmlybWF0aW9ucy9ob29rcy91c2VUcmFuc2FjdGlvbkZ1bmN0aW9ucy5qcyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvaG9va3MvdXNlVHlwZWRTaWduU2lnbmF0dXJlSW5mby50cyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvaG9va3MvdXNlVHlwZXNTaWduU2ltdWxhdGlvbkVuYWJsZWRJbmZvLnRzIiwidWkvcGFnZXMvY29uZmlybWF0aW9ucy9ob29rcy91dGlscy5qcyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvc2VsZWN0b3JzL2FjY291bnRzLnRzIiwidWkvcGFnZXMvY29uZmlybWF0aW9ucy9zZWxlY3RvcnMvaW5kZXgudHMiLCJ1aS9wYWdlcy9jb25maXJtYXRpb25zL3NlbmQtbGVnYWN5L3NlbmQtY29udGVudC9hZGQtcmVjaXBpZW50L2RvbWFpbi1pbnB1dC5jb21wb25lbnQuanMiLCJ1aS9wYWdlcy9jb25maXJtYXRpb25zL3NlbmQtbGVnYWN5L3NlbmQtY29udGVudC9hZGQtcmVjaXBpZW50L2RvbWFpbi1pbnB1dC5jb250YWluZXIuanMiLCJ1aS9wYWdlcy9jb25maXJtYXRpb25zL3NlbmQtbGVnYWN5L3NlbmQtY29udGVudC9hZGQtcmVjaXBpZW50L2RvbWFpbi1pbnB1dC5qcyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvc2VuZC9pbmRleC50cyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvc2VuZC9zZW5kLWlubmVyLnRzeCIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvc2VuZC9zZW5kLnRzeCIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvdHlwZXMvc2VuZC50cyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvdXRpbHMvYWNjb3VudC50cyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvdXRpbHMvaW5kZXgudHMiLCJ1aS9wYWdlcy9jb25maXJtYXRpb25zL3V0aWxzL211bHRpY2hhaW4tc25hcHMudHMiLCJ1aS9wYWdlcy9jb25maXJtYXRpb25zL3V0aWxzL3NlbmQudHMiLCJ1aS9wYWdlcy9jb25maXJtYXRpb25zL3V0aWxzL3NlbmRWYWxpZGF0aW9ucy50cyIsInVpL3BhZ2VzL2NvbmZpcm1hdGlvbnMvdXRpbHMvdG9rZW4udHMiLCJ1aS9wYWdlcy9jb25uZWN0ZWQtYWNjb3VudHMvY29ubmVjdGVkLWFjY291bnRzLmNvbXBvbmVudC5qcyIsInVpL3BhZ2VzL2Nvbm5lY3RlZC1hY2NvdW50cy9jb25uZWN0ZWQtYWNjb3VudHMuY29udGFpbmVyLmpzIiwidWkvcGFnZXMvY29ubmVjdGVkLWFjY291bnRzL2luZGV4LmpzIiwidWkvcGFnZXMvY29ubmVjdGVkLXNpdGVzL2Nvbm5lY3RlZC1zaXRlcy5jb21wb25lbnQuanMiLCJ1aS9wYWdlcy9jb25uZWN0ZWQtc2l0ZXMvY29ubmVjdGVkLXNpdGVzLmNvbnRhaW5lci5qcyIsInVpL3BhZ2VzL2Nvbm5lY3RlZC1zaXRlcy9pbmRleC5qcyIsInVpL3BhZ2VzL2NvcmUvaHlwZXJsaXF1aWQtcmVmZXJyYWwtY29uc2VudC9oeXBlcmxpcXVpZC1yZWZlcnJhbC1jb25zZW50LnRzeCIsInVpL3BhZ2VzL2NvcmUvaHlwZXJsaXF1aWQtcmVmZXJyYWwtY29uc2VudC9pbmRleC50cyIsInVpL3BhZ2VzL2NyZWF0ZS1hY2NvdW50L2Nvbm5lY3QtaGFyZHdhcmUvYWNjb3VudC1saXN0LmpzIiwidWkvcGFnZXMvY3JlYXRlLWFjY291bnQvY29ubmVjdC1oYXJkd2FyZS9pbmRleC5qcyIsInVpL3BhZ2VzL2NyZWF0ZS1hY2NvdW50L2Nvbm5lY3QtaGFyZHdhcmUvc2VsZWN0LWhhcmR3YXJlLmpzIiwidWkvcGFnZXMvY3JlYXRlLWFjY291bnQvY3JlYXRlLWFjY291bnQuY29tcG9uZW50LmpzIiwidWkvcGFnZXMvY3JlYXRlLXNuYXAtYWNjb3VudC9jcmVhdGUtc25hcC1hY2NvdW50LnRzeCIsInVpL3BhZ2VzL2NyZWF0ZS1zbmFwLWFjY291bnQvaW5kZXgudHMiLCJ1aS9wYWdlcy9kZWVwLWxpbmsvZGVlcC1saW5rLnRzeCIsInVpL3BhZ2VzL2RlZmkvY29tcG9uZW50cy9kZWZpLWRldGFpbHMtbGlzdC50c3giLCJ1aS9wYWdlcy9kZWZpL2NvbXBvbmVudHMvZGVmaS1kZXRhaWxzLXBhZ2UudHN4IiwidWkvcGFnZXMvZGVmaS9pbmRleC50cyIsInVpL3BhZ2VzL2Vycm9yLXBhZ2UvZXJyb3ItcGFnZS5jb21wb25lbnQudHN4IiwidWkvcGFnZXMvaG9tZS9ob21lLmNvbXBvbmVudC5qcyIsInVpL3BhZ2VzL2hvbWUvaG9tZS5jb250YWluZXIuanMiLCJ1aS9wYWdlcy9ob21lL2luZGV4LmpzIiwidWkvcGFnZXMvaW5kZXguanMiLCJ1aS9wYWdlcy9rZXljaGFpbnMvcmVzdG9yZS12YXVsdC5qcyIsInVpL3BhZ2VzL2tleWNoYWlucy9yZXZlYWwtc2VlZC5qcyIsInVpL3BhZ2VzL2xvY2svaW5kZXguanMiLCJ1aS9wYWdlcy9sb2NrL2xvY2suY29tcG9uZW50LmpzIiwidWkvcGFnZXMvbG9jay9sb2NrLmNvbnRhaW5lci5qcyIsInVpL3BhZ2VzL211bHRpLXNycC9pbXBvcnQtc3JwL2ltcG9ydC1zcnAudHN4IiwidWkvcGFnZXMvbXVsdGktc3JwL2ltcG9ydC1zcnAvaW5kZXgudHMiLCJ1aS9wYWdlcy9tdWx0aWNoYWluLWFjY291bnRzL2FjY291bnQtZGV0YWlscy9hY2NvdW50LXR5cGUtdXRpbHMudHMiLCJ1aS9wYWdlcy9tdWx0aWNoYWluLWFjY291bnRzL2FjY291bnQtZGV0YWlscy9idGMtYWNjb3VudC1kZXRhaWxzLnRzeCIsInVpL3BhZ2VzL211bHRpY2hhaW4tYWNjb3VudHMvYWNjb3VudC1kZXRhaWxzL2V2bS1hY2NvdW50LWRldGFpbHMudHN4IiwidWkvcGFnZXMvbXVsdGljaGFpbi1hY2NvdW50cy9hY2NvdW50LWRldGFpbHMvaGFyZHdhcmUtYWNjb3VudC1kZXRhaWxzLnRzeCIsInVpL3BhZ2VzL211bHRpY2hhaW4tYWNjb3VudHMvYWNjb3VudC1kZXRhaWxzL2luZGV4LnRzIiwidWkvcGFnZXMvbXVsdGljaGFpbi1hY2NvdW50cy9hY2NvdW50LWRldGFpbHMvaW5zdGl0dXRpb25hbC1ldm0tYWNjb3VudC1kZXRhaWxzLnRzeCIsInVpL3BhZ2VzL211bHRpY2hhaW4tYWNjb3VudHMvYWNjb3VudC1kZXRhaWxzL211bHRpY2hhaW4tYWNjb3VudC1kZXRhaWxzLnRzeCIsInVpL3BhZ2VzL211bHRpY2hhaW4tYWNjb3VudHMvYWNjb3VudC1kZXRhaWxzL3ByaXZhdGUta2V5LWFjY291bnQtZGV0YWlscy50c3giLCJ1aS9wYWdlcy9tdWx0aWNoYWluLWFjY291bnRzL2FjY291bnQtZGV0YWlscy9zb2xhbmEtYWNjb3VudC1kZXRhaWxzLnRzeCIsInVpL3BhZ2VzL211bHRpY2hhaW4tYWNjb3VudHMvYWNjb3VudC1saXN0L2FjY291bnQtbGlzdC50c3giLCJ1aS9wYWdlcy9tdWx0aWNoYWluLWFjY291bnRzL2FjY291bnQtbGlzdC9pbmRleC50cyIsInVpL3BhZ2VzL211bHRpY2hhaW4tYWNjb3VudHMvYWNjb3VudC1saXN0L3V0aWxzLnRzIiwidWkvcGFnZXMvbXVsdGljaGFpbi1hY2NvdW50cy9hZGQtd2FsbGV0LXBhZ2UvYWRkLXdhbGxldC1wYWdlLnRzeCIsInVpL3BhZ2VzL211bHRpY2hhaW4tYWNjb3VudHMvYWRkLXdhbGxldC1wYWdlL2luZGV4LnRzIiwidWkvcGFnZXMvbXVsdGljaGFpbi1hY2NvdW50cy9hZGRyZXNzLXFyLWNvZGUvYWRkcmVzcy1xci1jb2RlLnRzeCIsInVpL3BhZ2VzL211bHRpY2hhaW4tYWNjb3VudHMvYWRkcmVzcy1xci1jb2RlL2luZGV4LnRzIiwidWkvcGFnZXMvbXVsdGljaGFpbi1hY2NvdW50cy9iYXNlLWFjY291bnQtZGV0YWlscy9iYXNlLWFjY291bnQtZGV0YWlscy50c3giLCJ1aS9wYWdlcy9tdWx0aWNoYWluLWFjY291bnRzL211bHRpY2hhaW4tYWNjb3VudC1hZGRyZXNzLWxpc3QtcGFnZS9pbmRleC50cyIsInVpL3BhZ2VzL211bHRpY2hhaW4tYWNjb3VudHMvbXVsdGljaGFpbi1hY2NvdW50LWFkZHJlc3MtbGlzdC1wYWdlL211bHRpY2hhaW4tYWNjb3VudC1hZGRyZXNzLWxpc3QtcGFnZS50c3giLCJ1aS9wYWdlcy9tdWx0aWNoYWluLWFjY291bnRzL211bHRpY2hhaW4tYWNjb3VudC1hZGRyZXNzLWxpc3QtcGFnZS9tdWx0aWNoYWluLWFjY291bnQtYWRkcmVzcy1saXN0LXBhZ2UudHlwZXMudHMiLCJ1aS9wYWdlcy9tdWx0aWNoYWluLWFjY291bnRzL211bHRpY2hhaW4tYWNjb3VudC1kZXRhaWxzLXBhZ2UvaW5kZXgudHMiLCJ1aS9wYWdlcy9tdWx0aWNoYWluLWFjY291bnRzL211bHRpY2hhaW4tYWNjb3VudC1kZXRhaWxzLXBhZ2UvbXVsdGljaGFpbi1hY2NvdW50LWRldGFpbHMtcGFnZS50c3giLCJ1aS9wYWdlcy9tdWx0aWNoYWluLWFjY291bnRzL211bHRpY2hhaW4tYWNjb3VudC1wcml2YXRlLWtleS1saXN0LXBhZ2UvaW5kZXgudHMiLCJ1aS9wYWdlcy9tdWx0aWNoYWluLWFjY291bnRzL211bHRpY2hhaW4tYWNjb3VudC1wcml2YXRlLWtleS1saXN0LXBhZ2UvbXVsdGljaGFpbi1hY2NvdW50LXByaXZhdGUta2V5LWxpc3QtcGFnZS50c3giXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7QUFBQSxJQUFBLHNCQUFBLEdBQUEsT0FBQTtBQU9BLElBQUEsVUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxXQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsWUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLGFBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxVQUFBLEdBQUEsT0FBQTtBQUVBLElBQUEsYUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFNBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxlQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsUUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLDhCQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsUUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFVBQUEsR0FBQSxPQUFBO0FBaUJBLFNBQVMsdUJBQXVCLENBQzlCLGtCQUErQyxFQUN4QztFQUNQLE1BQU0sU0FBUyxHQUFHLElBQUksR0FBRyxDQUFNLENBQUM7RUFFaEMsa0JBQWtCLENBQUMsT0FBTyxDQUFFLFdBQVcsSUFBSztJQUMxQyxNQUFNO01BQUUsSUFBSTtNQUFFO0lBQUcsQ0FBQyxHQUFHLFdBQVc7SUFDaEMsSUFBSSxDQUFDLElBQUksSUFBSSxDQUFDLEVBQUUsRUFBRTtNQUNoQjtJQUNGO0lBRUEsTUFBTSxXQUFXLEdBQUcsSUFBQSwwQ0FBNEIsRUFBQyxJQUFJLENBQUM7SUFDdEQsSUFBSSxDQUFDLFdBQVcsRUFBRTtNQUNoQjtJQUNGO0lBRUEsTUFBTTtNQUFFLElBQUk7TUFBRTtJQUFhLENBQUMsR0FBRyxXQUFXO0lBRTFDLElBQUksa0JBQXVCO0lBQzNCLFFBQVEsSUFBSTtNQUNWLEtBQUssU0FBUztRQUNaLGtCQUFrQixHQUFHLFlBQVksSUFBSSxFQUFFO1FBQ3ZDO01BQ0YsS0FBSyxtQkFBbUI7TUFDeEIsS0FBSyxtQkFBbUI7UUFDdEIsa0JBQWtCLEdBQUcsRUFBRTtRQUN2QjtNQUNGO1FBQ0U7SUFDSjtJQUVBLFNBQVMsQ0FBQyxHQUFHLENBQUMsa0JBQWtCLENBQUM7RUFDbkMsQ0FBQyxDQUFDO0VBRUYsT0FBTyxLQUFLLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQztBQUM5QjtBQUVBLFNBQVMsa0JBQWtCLENBQ3pCLFdBQTRELEVBQzVELGNBQTBDLEVBQzFDLFlBQWlCLEVBQ1I7RUFBQSxJQUFBLHFCQUFBO0VBQ1QsSUFBSSxDQUFDLFdBQVcsRUFBRTtJQUNoQixPQUFPLElBQUk7RUFDYjs7RUFFQTtFQUNBLElBQUksV0FBVyxDQUFDLFdBQVcsRUFBRTtJQUMzQixPQUFPLElBQUk7RUFDYjs7RUFFQTtFQUNBLEtBQUEscUJBQUEsR0FBSSxXQUFXLENBQUMsZUFBZSxjQUFBLHFCQUFBLGVBQTNCLHFCQUFBLENBQTZCLE1BQU0sQ0FBQyxDQUFDLEVBQUU7SUFDekMsTUFBTSxhQUFhLEdBQUcsY0FBYyxDQUFDLFlBQVksQ0FBQzs7SUFFbEQ7SUFDQTtJQUNBLElBQUksYUFBYSxLQUFLLDBCQUFhLENBQUMsS0FBSyxFQUFFO01BQ3pDLE9BQU8sSUFBSTtJQUNiO0lBQ0E7RUFDRjtFQUVBLE9BQU8sS0FBSztBQUNkO0FBRUEsU0FBUyxnQkFBZ0IsQ0FDdkIsa0JBQStDLEVBQy9DLGNBQTBDLEVBQzFCO0VBQ2hCLE1BQU0sYUFBNkIsR0FBRyxFQUFFO0VBRXhDLGtCQUFrQixDQUFDLE9BQU8sQ0FBRSxXQUFXLElBQUs7SUFDMUMsTUFBTTtNQUFFLElBQUk7TUFBRTtJQUFHLENBQUMsR0FBRyxXQUFXO0lBQ2hDLElBQUksQ0FBQyxJQUFJLElBQUksQ0FBQyxFQUFFLEVBQUU7TUFDaEI7SUFDRjtJQUVBLE1BQU0sV0FBVyxHQUFHLElBQUEsMENBQTRCLEVBQUMsSUFBSSxDQUFDO0lBQ3RELElBQUksQ0FBQyxXQUFXLEVBQUU7TUFDaEI7SUFDRjtJQUVBLE1BQU07TUFBRSxJQUFJO01BQUUsZUFBZTtNQUFFO0lBQWEsQ0FBQyxHQUFHLFdBQVc7SUFFM0QsSUFBSSxrQkFBdUI7SUFDM0IsSUFBSSxjQUErQjtJQUVuQyxRQUFRLElBQUk7TUFDVixLQUFLLFNBQVM7UUFDWixJQUFJLFlBQVksRUFBRTtVQUNoQjtVQUNBLGtCQUFrQixHQUFHLFlBQVk7VUFDakMsY0FBYyxHQUFHLEVBQUU7UUFDckIsQ0FBQyxNQUFNO1VBQ0w7VUFDQSxrQkFBa0IsR0FBRyxFQUFFO1FBQ3pCO1FBQ0E7TUFDRixLQUFLLG1CQUFtQjtNQUN4QixLQUFLLG1CQUFtQjtRQUN0QixrQkFBa0IsR0FBRyxFQUFFO1FBQ3ZCO01BQ0Y7UUFDRTtJQUNKO0lBRUEsSUFBSSxrQkFBa0IsQ0FBQyxXQUFXLEVBQUUsY0FBYyxFQUFFLGtCQUFrQixDQUFDLEVBQUU7TUFDdkU7SUFDRjtJQUVBLGFBQWEsQ0FBQyxJQUFJLENBQUM7TUFDakIsWUFBWSxFQUFFLGtCQUFrQjtNQUNoQyxjQUFjO01BQ2QsTUFBTSxFQUFFO0lBQ1YsQ0FBQyxDQUFDO0VBQ0osQ0FBQyxDQUFDO0VBRUYsT0FBTyxhQUFhO0FBQ3RCO0FBRUEsU0FBUyxxQkFBcUIsQ0FDNUIsbUJBQW1ELEVBQ25DO0VBQ2hCLE9BQ0UsQ0FBQSxtQkFBbUIsYUFBbkIsbUJBQW1CLHVCQUFuQixtQkFBbUIsQ0FDZixNQUFNLENBQUUsTUFBTSxJQUFLLE1BQU0sQ0FBQyxVQUFVLENBQUMsQ0FDdEMsR0FBRyxDQUFFLE1BQU0sS0FBTTtJQUNoQixZQUFZLEVBQUUsTUFBTSxDQUFDLE9BQU8sQ0FBQyxXQUFXLENBQUMsQ0FBUTtJQUNqRCxNQUFNLEVBQUUsSUFBSSxvQkFBUyxDQUFDLE1BQU0sQ0FBQyxVQUFVLEVBQUUsRUFBRSxDQUFDO0lBQzVDLFVBQVUsRUFBRSxNQUFNLENBQUM7RUFDckIsQ0FBQyxDQUFDLENBQUMsS0FBSSxFQUFFO0FBRWY7QUFFQSxTQUFTLG1CQUFtQixDQUMxQixTQUF5QixFQUN6QixhQUE2QixFQUNiO0VBQ2hCLElBQUksU0FBUyxDQUFDLE1BQU0sS0FBSyxDQUFDLEVBQUU7SUFDMUIsT0FBTyxFQUFFO0VBQ1g7RUFFQSxPQUFPLFNBQVMsQ0FBQyxNQUFNLENBQUUsUUFBUSxJQUFLO0lBQ3BDLE1BQU0sWUFBWSxHQUFHLGFBQWEsQ0FBQyxJQUFJLENBQ3BDLE9BQU8sSUFDTixPQUFPLENBQUMsWUFBWSxDQUFDLFdBQVcsQ0FBQyxDQUFDLEtBQ2xDLFFBQVEsQ0FBQyxZQUFZLENBQUMsV0FBVyxDQUFDLENBQ3RDLENBQUM7SUFFRCxJQUFJLENBQUMsWUFBWSxFQUFFO01BQ2pCLE9BQU8sSUFBSTtJQUNiOztJQUVBO0lBQ0E7SUFDQSxPQUFPLEtBQUs7RUFDZCxDQUFDLENBQUM7QUFDSjs7QUFFQTtBQUNBLGVBQWUsbUJBQW1CLENBQ2hDLGNBQXFCLEVBQ3JCLE9BQTJCLEVBQzNCLFdBQTRCLEVBQ1M7RUFDckMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxNQUFNLElBQUksQ0FBQyxPQUFPLElBQUksQ0FBQyxXQUFXLEVBQUU7SUFDdEQsT0FBTyxDQUFDLENBQUM7RUFDWDtFQUVBLE1BQU0sU0FBcUMsR0FBRyxDQUFDLENBQUM7RUFDaEQsTUFBTSxPQUFPLENBQUMsR0FBRyxDQUNmLGNBQWMsQ0FBQyxHQUFHLENBQUMsTUFBTyxPQUFPLElBQUs7SUFDcEMsSUFBSTtNQUNGLE1BQU0sT0FBTyxHQUFHLE1BQU0sSUFBQSwwQ0FBaUMsRUFDckQsT0FBTyxFQUNQLFdBQVcsRUFDWCxTQUFTLEVBQ1QsT0FDRixDQUFDO01BQ0Q7TUFDQSxNQUFNLFFBQVEsR0FBRyxPQUFPLGFBQVAsT0FBTyx1QkFBUCxPQUFPLENBQUUsUUFBeUI7TUFDbkQsU0FBUyxDQUFDLE9BQU8sQ0FBQyxHQUFHLE1BQU0sQ0FBQyxNQUFNLENBQUMsMEJBQWEsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUMsR0FDaEUsUUFBUSxHQUNSLDBCQUFhLENBQUMsSUFBSTtJQUN4QixDQUFDLENBQUMsT0FBTyxLQUFLLEVBQUU7TUFDZCxPQUFPLENBQUMsSUFBSSxDQUFDLG9DQUFvQyxPQUFPLEdBQUcsRUFBRSxLQUFLLENBQUM7TUFDbkUsU0FBUyxDQUFDLE9BQU8sQ0FBQyxHQUFHLDBCQUFhLENBQUMsSUFBSTtJQUN6QztFQUNGLENBQUMsQ0FDSCxDQUFDO0VBRUQsT0FBTyxTQUFTO0FBQ2xCO0FBRU8sU0FBUywwQkFBMEIsQ0FBQSxFQUFZO0VBQUEsSUFBQSxxQkFBQSxFQUFBLHNCQUFBO0VBQ3BELE1BQU0sQ0FBQyxHQUFHLElBQUEsOEJBQWMsRUFBQyxDQUFDO0VBQzFCLE1BQU07SUFBRTtFQUFvQixDQUFDLEdBQUcsSUFBQSwwQkFBaUIsRUFBa0IsQ0FBQztFQUNwRSxNQUFNO0lBQUUsS0FBSyxFQUFFO0VBQXNCLENBQUMsR0FDcEMsSUFBQSw0REFBNkIsRUFBQyxDQUFDLElBQUksQ0FBQyxDQUFDO0VBRXZDLE1BQU0sbUJBQW1CLEdBQUcsSUFBQSx1QkFBVyxFQUFDLHVDQUE0QixDQUFDO0VBQ3JFLE1BQU0sK0JBQStCLEdBQUcsSUFBQSx1QkFBVyxFQUNqRCxnREFDRixDQUF5QjtFQUV6QixNQUFNLGtCQUFrQixHQUFHLG1CQUFtQixhQUFuQixtQkFBbUIsdUJBQW5CLG1CQUFtQixDQUFFLGtCQUFrQjtFQUNsRSxNQUFNLGNBQWMsR0FBRyxtQkFBbUIsYUFBbkIsbUJBQW1CLHVCQUFuQixtQkFBbUIsQ0FBRSxjQUFjO0VBQzFELE1BQU0sbUJBQW1CLEdBQUcsY0FBYyxhQUFkLGNBQWMsdUJBQWQsY0FBYyxDQUFFLG1CQUFtQjtFQUMvRCxNQUFNLHFCQUFxQixHQUN6QixtQkFBbUIsSUFDbkIsQ0FBQyxDQUNDLDBDQUFtQixDQUFDLGlCQUFpQixFQUNyQywwQ0FBbUIsQ0FBQyxRQUFRLENBQzdCLENBQUMsUUFBUSxDQUFDLGNBQWMsYUFBZCxjQUFjLGdCQUFBLHFCQUFBLEdBQWQsY0FBYyxDQUFFLEtBQUssY0FBQSxxQkFBQSx1QkFBckIscUJBQUEsQ0FBdUIsSUFBMkIsQ0FBQztFQUNoRSxNQUFNLHNCQUFzQixHQUFHLCtCQUErQixhQUEvQiwrQkFBK0IsdUJBQS9CLCtCQUErQixDQUFFLFFBQVEsQ0FDdEUsQ0FBQSxtQkFBbUIsYUFBbkIsbUJBQW1CLHVCQUFuQixtQkFBbUIsQ0FBRSxNQUFNLEtBQUksRUFDakMsQ0FBQztFQUVELE1BQU0sY0FBYyxHQUFHLElBQUEsY0FBTyxFQUFDLE1BQU07SUFDbkMsSUFBSSxFQUFDLGtCQUFrQixhQUFsQixrQkFBa0IsZUFBbEIsa0JBQWtCLENBQUUsTUFBTSxHQUFFO01BQy9CLE9BQU8sRUFBRTtJQUNYO0lBQ0EsT0FBTyx1QkFBdUIsQ0FBQyxrQkFBa0IsQ0FBQztFQUNwRCxDQUFDLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO0VBRXhCLE1BQU07SUFBRSxLQUFLLEVBQUU7RUFBZSxDQUFDLEdBQUcsSUFBQSx3QkFBYyxFQUFDLFlBQVk7SUFBQSxJQUFBLHFCQUFBO0lBQzNELE9BQU8sbUJBQW1CLENBQ3hCLGNBQWMsRUFDZCxtQkFBbUIsYUFBbkIsbUJBQW1CLHVCQUFuQixtQkFBbUIsQ0FBRSxPQUFPLEVBQzVCLG1CQUFtQixhQUFuQixtQkFBbUIsZ0JBQUEscUJBQUEsR0FBbkIsbUJBQW1CLENBQUUsUUFBUSxjQUFBLHFCQUFBLHVCQUE3QixxQkFBQSxDQUErQixJQUNqQyxDQUFDO0VBQ0gsQ0FBQyxFQUFFLENBQ0QsY0FBYyxFQUNkLG1CQUFtQixhQUFuQixtQkFBbUIsdUJBQW5CLG1CQUFtQixDQUFFLE9BQU8sRUFDNUIsbUJBQW1CLGFBQW5CLG1CQUFtQixnQkFBQSxzQkFBQSxHQUFuQixtQkFBbUIsQ0FBRSxRQUFRLGNBQUEsc0JBQUEsdUJBQTdCLHNCQUFBLENBQStCLElBQUksQ0FDcEMsQ0FBQztFQUVGLE1BQU0sU0FBUyxHQUFHLElBQUEsY0FBTyxFQUFDLE1BQXNCO0lBQzlDLElBQ0UsRUFBQyxrQkFBa0IsYUFBbEIsa0JBQWtCLGVBQWxCLGtCQUFrQixDQUFFLE1BQU0sS0FDM0IsRUFBQyxxQkFBcUIsYUFBckIscUJBQXFCLGVBQXJCLHFCQUFxQixDQUFFLE1BQU0sS0FDOUIsQ0FBQyxjQUFjLEVBQ2Y7TUFDQSxPQUFPLEVBQUU7SUFDWDtJQUVBLE1BQU0sYUFBYSxHQUFHLGdCQUFnQixDQUFDLGtCQUFrQixFQUFFLGNBQWMsQ0FBQztJQUUxRSxPQUFPLGFBQWE7RUFDdEIsQ0FBQyxFQUFFLENBQUMscUJBQXFCLEVBQUUsa0JBQWtCLEVBQUUsY0FBYyxDQUFDLENBQUM7RUFFL0QsTUFBTSxhQUFhLEdBQUcsSUFBQSxjQUFPLEVBQUMsTUFBTTtJQUNsQyxJQUFJLENBQUMsbUJBQW1CLEVBQUU7TUFDeEIsT0FBTyxFQUFFO0lBQ1g7SUFDQSxPQUFPLHFCQUFxQixDQUFDLG1CQUFtQixDQUFDO0VBQ25ELENBQUMsRUFBRSxDQUFDLG1CQUFtQixDQUFDLENBQUM7RUFFekIsTUFBTSxlQUFlLEdBQUcsSUFBQSxjQUFPLEVBQUMsTUFBTTtJQUNwQyxPQUFPLG1CQUFtQixDQUFDLFNBQVMsRUFBRSxhQUFhLENBQUM7RUFDdEQsQ0FBQyxFQUFFLENBQUMsU0FBUyxFQUFFLGFBQWEsQ0FBQyxDQUFDO0VBRTlCLE1BQU0sZUFBZSxHQUNuQixlQUFlLENBQUMsTUFBTSxHQUFHLENBQUMsSUFDMUIsT0FBTyxDQUFDLG1CQUFtQixhQUFuQixtQkFBbUIsdUJBQW5CLG1CQUFtQixDQUFFLGNBQWMsQ0FBQyxJQUM1QyxxQkFBcUIsSUFDckIsQ0FBQyxzQkFBc0I7RUFFekIsT0FBTyxJQUFBLGNBQU8sRUFBQyxNQUFNO0lBQ25CLElBQUksQ0FBQyxlQUFlLEVBQUU7TUFDcEIsT0FBTyxFQUFFO0lBQ1g7SUFFQSxPQUFPLENBQ0w7TUFDRSxLQUFLLEVBQUUsc0JBQVcsQ0FBQyxzQkFBc0I7TUFDekMsVUFBVSxFQUFFLEtBQUs7TUFDakIsR0FBRyxFQUFFLG1CQUFtQjtNQUN4QixNQUFNLEVBQUUsQ0FBQyxDQUFDLDhCQUE4QixDQUFDO01BQ3pDLE9BQU8sRUFBRSxDQUFDLENBQUMsK0JBQStCLENBQUM7TUFDM0MsUUFBUSxFQUFFLHNCQUFRLENBQUM7SUFDckIsQ0FBQyxDQUNGO0VBQ0gsQ0FBQyxFQUFFLENBQUMsZUFBZSxFQUFFLENBQUMsQ0FBQyxDQUFDO0FBQzFCOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ2xVQSxJQUFBLFdBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxzQkFBQSxHQUFBLE9BQUE7QUFJQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBRUEsSUFBQSxZQUFBLEdBQUEsT0FBQTtBQUVBLElBQUEsYUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFVBQUEsR0FBQSxPQUFBO0FBSUEsSUFBQSxVQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsZUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFFBQUEsR0FBQSxPQUFBO0FBRU8sU0FBUyxtQkFBbUIsQ0FBQSxFQUFZO0VBQzdDLE1BQU0sQ0FBQyxHQUFHLElBQUEsOEJBQWMsRUFBQyxDQUFDO0VBQzFCLE1BQU0sbUJBQW1CLEdBQUcsSUFBQSx1QkFBVyxFQUFDLCtCQUFvQixDQUFDO0VBQzdELE1BQU07SUFBRTtFQUFvQixDQUFDLEdBQUcsSUFBQSwwQkFBaUIsRUFBa0IsQ0FBQztFQUVwRSxNQUFNLG1CQUFtQixHQUN2QixDQUFBLG1CQUFtQixhQUFuQixtQkFBbUIsdUJBQW5CLG1CQUFtQixDQUFFLFlBQVksS0FDakMsbUJBQW1CLENBQUMsWUFBWSxLQUFLLG1DQUFZLENBQUMsTUFBTSxJQUN4RCxDQUFDLElBQUEscUNBQXdCLEVBQUMsbUJBQW1CLENBQUM7RUFFaEQsTUFBTSxVQUFVLEdBQUcsbUJBQW1CLElBQUksbUJBQW1CO0VBRTdELE9BQU8sSUFBQSxjQUFPLEVBQUMsTUFBTTtJQUNuQixJQUFJLENBQUMsVUFBVSxFQUFFO01BQ2YsT0FBTyxFQUFFO0lBQ1g7SUFFQSxPQUFPLENBQ0w7TUFDRSxPQUFPLEVBQUUsQ0FDUDtRQUNFLEdBQUcsRUFBRSx5QkFBYyxDQUFDLHVCQUF1QjtRQUMzQyxLQUFLLEVBQUUsQ0FBQyxDQUFDLHlCQUF5QjtNQUNwQyxDQUFDLENBQ0Y7TUFDRCxLQUFLLEVBQUUsc0JBQVcsQ0FBQyxZQUFZO01BQy9CLFVBQVUsRUFBRSxJQUFJO01BQ2hCLEdBQUcsRUFBRSxZQUFZO01BQ2pCLE9BQU8sRUFBRSxDQUFDLENBQUMsd0JBQXdCLENBQUM7TUFDcEMsTUFBTSxFQUFFLENBQUMsQ0FBQyx1QkFBdUIsQ0FBQztNQUNsQyxRQUFRLEVBQUUsc0JBQVEsQ0FBQztJQUNyQixDQUFDLENBQ0Y7RUFDSCxDQUFDLEVBQUUsQ0FBQyxVQUFVLENBQUMsQ0FBQztBQUNsQjs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNwREEsSUFBQSxzQkFBQSxHQUFBLE9BQUE7QUFJQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxXQUFBLEdBQUEsT0FBQTtBQUdBLElBQUEsU0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFVBQUEsR0FBQSxPQUFBO0FBRUEsSUFBQSxhQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsZUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFFBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSx3QkFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLCtCQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsZ0JBQUEsR0FBQSxPQUFBO0FBRU8sU0FBUywyQkFBMkIsQ0FBQSxFQUFZO0VBQUEsSUFBQSxxQkFBQSxFQUFBLHNCQUFBLEVBQUEsc0JBQUE7RUFDckQsTUFBTSxDQUFDLEdBQUcsSUFBQSw4QkFBYyxFQUFDLENBQUM7RUFDMUIsTUFBTTtJQUFFO0VBQW9CLENBQUMsR0FBRyxJQUFBLDBCQUFpQixFQUFrQixDQUFDO0VBQ3BFLE1BQU0scUJBQXFCLEdBQUcsSUFBQSx1QkFBVyxFQUFDLDJDQUFpQyxDQUFDO0VBQzVFLE1BQU07SUFBRTtFQUFVLENBQUMsR0FBRyxJQUFBLGdEQUF1QixFQUFDLENBQUM7RUFDL0MsTUFBTTtJQUFFLE9BQU87SUFBRTtFQUFNLENBQUMsR0FBRyxJQUFBLGdDQUFlLEVBQ3hDLG1CQUFtQixhQUFuQixtQkFBbUIsZ0JBQUEscUJBQUEsR0FBbkIsbUJBQW1CLENBQUUsUUFBUSxjQUFBLHFCQUFBLHVCQUE3QixxQkFBQSxDQUErQixFQUFFLEVBQ2pDLG1CQUFtQixhQUFuQixtQkFBbUIsdUJBQW5CLG1CQUFtQixDQUFFLGVBQ3ZCLENBQUM7RUFFRCxNQUFNLGdCQUFnQixHQUNwQixDQUFBLG1CQUFtQixhQUFuQixtQkFBbUIsZ0JBQUEsc0JBQUEsR0FBbkIsbUJBQW1CLENBQUUsUUFBUSxjQUFBLHNCQUFBLHVCQUE3QixzQkFBQSxDQUErQixJQUFJLE1BQUssU0FBUyxJQUNqRCxDQUFBLG1CQUFtQixhQUFuQixtQkFBbUIsZ0JBQUEsc0JBQUEsR0FBbkIsbUJBQW1CLENBQUUsUUFBUSxjQUFBLHNCQUFBLHVCQUE3QixzQkFBQSxDQUErQixJQUFJLE1BQUssSUFBSTtFQUU5QyxNQUFNLHFCQUFxQixHQUFHLENBQUEsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLFlBQVksTUFBSyxJQUFJO0VBRTFELE1BQU0sbUNBQW1DLEdBQ3ZDLENBQUMsT0FBTyxJQUFJLENBQUMscUJBQXFCLElBQUksQ0FBQSxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsaUJBQWlCLE1BQUssS0FBSztFQUUxRSxNQUFNLHNCQUFzQixHQUMxQixDQUFBLG1CQUFtQixhQUFuQixtQkFBbUIsdUJBQW5CLG1CQUFtQixDQUFFLElBQUksTUFBSyxzQ0FBZSxDQUFDLGNBQWM7RUFFOUQsTUFBTSxzREFBc0QsR0FDMUQsZ0JBQWdCLElBQ2hCLG1DQUFtQyxJQUNuQyxDQUFDLHNCQUFzQjtFQUV6QixPQUFPLElBQUEsY0FBTyxFQUFDLE1BQU07SUFDbkIsSUFBSSxDQUFDLHNEQUFzRCxJQUFJLFNBQVMsRUFBRTtNQUN4RSxPQUFPLEVBQUU7SUFDWDtJQUVBLE9BQU8sQ0FDTDtNQUNFLEtBQUssRUFBRSxzQkFBVyxDQUFDLGVBQWU7TUFDbEMsVUFBVSxFQUFFLEtBQUs7TUFDakIsR0FBRyxFQUFFLCtDQUErQztNQUNwRCxNQUFNLEVBQUUsQ0FBQyxDQUFDLDhCQUE4QixDQUFDO01BQ3pDLE9BQU8sRUFBRSxJQUFBLDhEQUE4QixFQUFDLHFCQUFxQixDQUFDO01BQzlELFFBQVEsRUFBRSxzQkFBUSxDQUFDO0lBQ3JCLENBQUMsQ0FDRjtFQUNILENBQUMsRUFBRSxDQUNELHNEQUFzRCxFQUN0RCxTQUFTLEVBQ1QscUJBQXFCLENBQ3RCLENBQUM7QUFDSjs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNoRUEsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsV0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLGFBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxVQUFBLEdBQUEsT0FBQTtBQUVBLElBQUEsYUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLGVBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxVQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsUUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLCtCQUFBLEdBQUEsT0FBQTtBQUVPLFNBQVMsMkJBQTJCLENBQUEsRUFBWTtFQUNyRCxNQUFNLENBQUMsR0FBRyxJQUFBLDhCQUFjLEVBQUMsQ0FBQztFQUMxQixNQUFNO0lBQUU7RUFBb0IsQ0FBQyxHQUFHLElBQUEsMEJBQWlCLEVBQUMsQ0FBQztFQUNuRCxNQUFNO0lBQUU7RUFBSyxDQUFDLEdBQUcsbUJBQW1CLElBQUssQ0FBQyxDQUFxQjtFQUMvRCxNQUFNLG1CQUFtQixHQUFHLElBQUEsdUJBQVcsRUFBQywrQ0FBb0MsQ0FBQztFQUU3RSxNQUFNLFdBQVcsR0FBRyxJQUFBLCtDQUFpQyxFQUFDLElBQUksQ0FBQztFQUUzRCxNQUFNLHNCQUFzQixHQUMxQixXQUFXLElBQUksT0FBTyxDQUFDLG1CQUFtQixDQUFDLE1BQU0sQ0FBQztFQUVwRCxPQUFPLElBQUEsY0FBTyxFQUFDLE1BQU07SUFDbkIsSUFBSSxDQUFDLHNCQUFzQixFQUFFO01BQzNCLE9BQU8sRUFBRTtJQUNYO0lBRUEsT0FBTyxDQUNMO01BQ0UsS0FBSyxFQUFFLHNCQUFXLENBQUMsS0FBSztNQUN4QixHQUFHLEVBQUUscUJBQXFCO01BQzFCLE9BQU8sRUFBRSxJQUFBLDhEQUE4QixFQUFDLENBQUM7TUFDekMsTUFBTSxFQUFFLENBQUMsQ0FBQyxnQ0FBZ0MsQ0FBQztNQUMzQyxRQUFRLEVBQUUsc0JBQVEsQ0FBQztJQUNyQixDQUFDLENBQ0Y7RUFDSCxDQUFDLEVBQUUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO0FBQzlCOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ3RDQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBR0EsSUFBQSxJQUFBLEdBQUEsT0FBQTtBQUVBLElBQUEsZUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLGFBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxVQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsUUFBQSxHQUFBLE9BQUE7QUFFTyxTQUFTLG9CQUFvQixDQUFBLEVBQVk7RUFBQSxJQUFBLHFCQUFBO0VBQzlDLE1BQU0sQ0FBQyxHQUFHLElBQUEsOEJBQWMsRUFBQyxDQUFDO0VBQzFCLE1BQU07SUFBRTtFQUFvQixDQUFDLEdBQUcsSUFBQSwwQkFBaUIsRUFBQyxDQUFDO0VBRW5ELE1BQU0sZUFBZSxHQUFHLG1CQUFzQztFQUU5RCxNQUFNLDJCQUEyQixHQUMvQixlQUFlLGFBQWYsZUFBZSxnQkFBQSxxQkFBQSxHQUFmLGVBQWUsQ0FBRSxjQUFjLGNBQUEscUJBQUEsdUJBQS9CLHFCQUFBLENBQWlDLDJCQUEyQjtFQUM5RCxNQUFNLGlCQUFpQixHQUFHLENBQUEsZUFBZSxhQUFmLGVBQWUsdUJBQWYsZUFBZSxDQUFFLE1BQU0sTUFBSyxvQkFBZTtFQUVyRSxPQUFPLElBQUEsY0FBTyxFQUFDLE1BQU07SUFDbkIsSUFBSSxDQUFDLDJCQUEyQixJQUFJLGlCQUFpQixFQUFFO01BQ3JELE9BQU8sRUFBRTtJQUNYO0lBRUEsT0FBTyxDQUNMO01BQ0UsT0FBTyxFQUFFLEVBQUU7TUFDWCxLQUFLLEVBQUUsc0JBQVcsQ0FBQyxZQUFZO01BQy9CLFVBQVUsRUFBRSxLQUFLO01BQ2pCLEdBQUcsRUFBRSx3QkFBd0I7TUFDN0IsT0FBTyxFQUFFLENBQUMsQ0FBQyx1Q0FBdUMsQ0FBQztNQUNuRCxNQUFNLEVBQUUsQ0FBQyxDQUFDLHNDQUFzQyxDQUFDO01BQ2pELFFBQVEsRUFBRSxzQkFBUSxDQUFDO0lBQ3JCLENBQUMsQ0FDRjtFQUNILENBQUMsRUFBRSxDQUFDLDJCQUEyQixFQUFFLGlCQUFpQixFQUFFLENBQUMsQ0FBQyxDQUFDO0FBQ3pEOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ3BDQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxXQUFBLEdBQUEsT0FBQTtBQUVBLElBQUEsVUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLGFBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxlQUFBLEdBQUEsT0FBQTtBQUVBLElBQUEsUUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLGFBQUEsR0FBQSxPQUFBO0FBRU8sU0FBUyw0QkFBNEIsQ0FBQSxFQUFZO0VBQ3RELE1BQU0sQ0FBQyxHQUFHLElBQUEsOEJBQWMsRUFBQyxDQUFDO0VBQzFCLE1BQU07SUFBRTtFQUFvQixDQUFDLEdBQUcsSUFBQSwwQkFBaUIsRUFBQyxDQUFDO0VBQ25ELE1BQU07SUFBRTtFQUFLLENBQUMsR0FBSSxtQkFBbUIsSUFBSSxDQUFDLENBQXFCO0VBRS9ELE1BQU0sK0JBQStCLEdBQUcsSUFBQSx1QkFBVyxFQUNqRCwyQ0FDRixDQUFDO0VBRUQsTUFBTSxXQUFXLEdBQUcsSUFBQSwrQ0FBaUMsRUFBQyxJQUFJLENBQUM7RUFFM0QsTUFBTSxxQkFBcUIsR0FDekIsV0FBVyxJQUFJLCtCQUErQixDQUFDLE1BQU0sR0FBRyxDQUFDO0VBRTNELE9BQU8sSUFBQSxjQUFPLEVBQUMsTUFBTTtJQUNuQixJQUFJLENBQUMscUJBQXFCLEVBQUU7TUFDMUIsT0FBTyxFQUFFO0lBQ1g7SUFFQSxPQUFPLENBQ0w7TUFDRSxVQUFVLEVBQUUsSUFBSTtNQUNoQixHQUFHLEVBQUUscUJBQXFCO01BQzFCLE9BQU8sRUFBRSxDQUFDLENBQUMsdUJBQXVCLENBQUM7TUFDbkMsUUFBUSxFQUFFLHNCQUFRLENBQUM7SUFDckIsQ0FBQyxDQUNGO0VBQ0gsQ0FBQyxFQUFFLENBQUMscUJBQXFCLENBQUMsQ0FBQztBQUM3Qjs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUN2Q0EsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUVBLElBQUEsZUFBQSxHQUFBLE9BQUE7QUFFQSxJQUFBLGFBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxVQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsUUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLGdCQUFBLEdBQUEsT0FBQTtBQUtBLElBQUEsZUFBQSxHQUFBLE9BQUE7QUFFQSxJQUFBLGtCQUFBLEdBQUEsT0FBQTtBQURBOztBQUdPLFNBQVMsMkJBQTJCLENBQUEsRUFBWTtFQUNyRCxNQUFNO0lBQUU7RUFBb0IsQ0FBQyxHQUFHLElBQUEsMEJBQWlCLEVBQUMsQ0FBQztFQUNuRCxNQUFNLENBQUMsR0FBRyxJQUFBLDhCQUFjLEVBQUMsQ0FBQztFQUUxQixNQUFNLGNBQWMsR0FBRyxJQUFBLGNBQU8sRUFBQyxNQUFNO0lBQUEsSUFBQSxTQUFBLEVBQUEsVUFBQTtJQUNuQyxJQUFJLENBQUMsbUJBQW1CLEVBQUU7TUFDeEIsT0FBTyxJQUFJO0lBQ2I7O0lBRUE7SUFDQSxJQUFLLG1CQUFtQixhQUFuQixtQkFBbUIsZ0JBQUEsU0FBQSxHQUFuQixtQkFBbUIsQ0FBc0IsUUFBUSxjQUFBLFNBQUEsZUFBbEQsU0FBQSxDQUFvRCxFQUFFLEVBQUU7TUFDMUQsT0FBUSxtQkFBbUIsQ0FBcUIsUUFBUSxDQUFDLEVBQUU7SUFDN0Q7O0lBRUE7SUFDQSxJQUFLLG1CQUFtQixhQUFuQixtQkFBbUIsZ0JBQUEsVUFBQSxHQUFuQixtQkFBbUIsQ0FBMkIsU0FBUyxjQUFBLFVBQUEsZUFBeEQsVUFBQSxDQUEwRCxJQUFJLEVBQUU7TUFDbEUsSUFBSTtRQUFBLElBQUEsV0FBQSxFQUFBLGtCQUFBO1FBQ0YsTUFBTSxJQUFJLEdBQUksbUJBQW1CLGFBQW5CLG1CQUFtQixnQkFBQSxXQUFBLEdBQW5CLG1CQUFtQixDQUEyQixTQUFTLGNBQUEsV0FBQSx1QkFBeEQsV0FBQSxDQUNULElBQUk7UUFDUixNQUFNLFVBQVUsR0FBRyxPQUFPLElBQUksS0FBSyxRQUFRLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsR0FBRyxJQUFJO1FBQ3JFLElBQUksVUFBVSxhQUFWLFVBQVUsZ0JBQUEsa0JBQUEsR0FBVixVQUFVLENBQUUsTUFBTSxjQUFBLGtCQUFBLGVBQWxCLGtCQUFBLENBQW9CLGlCQUFpQixFQUFFO1VBQ3pDLE9BQU8sVUFBVSxDQUFDLE1BQU0sQ0FBQyxpQkFBaUI7UUFDNUM7TUFDRixDQUFDLENBQUMsT0FBTyxDQUFDLEVBQUU7UUFDVjtNQUFBO0lBRUo7SUFFQSxPQUFPLElBQUk7RUFDYixDQUFDLEVBQUUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO0VBRXpCLE1BQU07SUFBRSxLQUFLLEVBQUU7RUFBd0IsQ0FBQyxHQUFHLElBQUEsK0JBQWMsRUFDdkQsY0FBYyxJQUFJLEVBQUUsRUFDcEIsd0JBQVEsQ0FBQyxnQkFDWCxDQUFDO0VBRUQsT0FBTyxJQUFBLGNBQU8sRUFBQyxNQUFNO0lBQ25CLElBQUksQ0FBQyxjQUFjLElBQUksQ0FBQyxJQUFBLDZDQUEwQixFQUFDLENBQUMsRUFBRTtNQUNwRCxPQUFPLEVBQUU7SUFDWDtJQUVBLE1BQU0sTUFBZSxHQUFHLEVBQUU7SUFFMUIsSUFBSSx1QkFBdUIsS0FBSyx3Q0FBdUIsQ0FBQyxTQUFTLEVBQUU7TUFDakUsTUFBTSxDQUFDLElBQUksQ0FBQztRQUNWLE9BQU8sRUFBRSxFQUFFO1FBQ1gsS0FBSyxFQUFFLHNCQUFXLENBQUMsZUFBZTtRQUNsQyxVQUFVLEVBQUUsS0FBSztRQUNqQixHQUFHLEVBQUUsc0JBQXNCO1FBQzNCLE9BQU8sRUFBRSxDQUFDLENBQUMseUNBQXlDLENBQUM7UUFDckQsTUFBTSxFQUFFLENBQUMsQ0FBQyx5QkFBeUIsQ0FBQztRQUNwQyxRQUFRLEVBQUUsc0JBQVEsQ0FBQztNQUNyQixDQUFDLENBQUM7SUFDSixDQUFDLE1BQU0sSUFBSSx1QkFBdUIsS0FBSyx3Q0FBdUIsQ0FBQyxPQUFPLEVBQUU7TUFDdEUsTUFBTSxDQUFDLElBQUksQ0FBQztRQUNWLE9BQU8sRUFBRSxFQUFFO1FBQ1gsS0FBSyxFQUFFLHNCQUFXLENBQUMsZUFBZTtRQUNsQyxVQUFVLEVBQUUsS0FBSztRQUNqQixHQUFHLEVBQUUsb0JBQW9CO1FBQ3pCLE9BQU8sRUFBRSxDQUFDLENBQUMsZ0NBQWdDLENBQUM7UUFDNUMsTUFBTSxFQUFFLENBQUMsQ0FBQyx1QkFBdUIsQ0FBQztRQUNsQyxRQUFRLEVBQUUsc0JBQVEsQ0FBQztNQUNyQixDQUFDLENBQUM7SUFDSjtJQUVBLE9BQU8sTUFBTTtFQUNmLENBQUMsRUFBRSxDQUFDLGNBQWMsRUFBRSx1QkFBdUIsRUFBRSxDQUFDLENBQUMsQ0FBQztBQUNsRDs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNuRkEsSUFBQSxRQUFBLEdBQUEsc0JBQUEsQ0FBQSxPQUFBO0FBQ0EsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsV0FBQSxHQUFBLE9BQUE7QUFNQSxJQUFBLFFBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxpQkFBQSxHQUFBLE9BQUE7QUFNQSxJQUFBLFdBQUEsR0FBQSxzQkFBQSxDQUFBLE9BQUE7QUFDQSxJQUFBLGVBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsYUFBQSxHQUFBLE9BQUE7QUFLQSxJQUFBLFFBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSx5Q0FBQSxHQUFBLHNCQUFBLENBQUEsT0FBQTtBQUNBLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFBaUQsU0FBQSx1QkFBQSxDQUFBLFdBQUEsQ0FBQSxJQUFBLENBQUEsQ0FBQSxVQUFBLEdBQUEsQ0FBQSxLQUFBLE9BQUEsRUFBQSxDQUFBO0FBRWpEO0FBQ0EsTUFBTSxJQUFJLEdBQUcsT0FBTyxDQUFDLE1BQU0sQ0FBQztBQUU1QixNQUFNLG9CQUFvQixHQUFHLENBQzNCLG9DQUFrQixDQUFDLE1BQU0sRUFDekIsb0NBQWtCLENBQUMsT0FBTyxDQUMzQjtBQVNELE1BQU0saUJBQWlCLEdBQUcsQ0FBQSxLQUFlO0VBQUEsSUFBQSxxQkFBQTtFQUN2QyxNQUFNLENBQUMsR0FBRyxJQUFBLDhCQUFjLEVBQUMsQ0FBQztFQUMxQixNQUFNO0lBQUU7RUFBb0IsQ0FBQyxHQUFHLElBQUEsMEJBQWlCLEVBQUMsQ0FBQztFQUVuRCxNQUFNLGVBQWUsR0FDbkIsbUJBQW1CLGFBQW5CLG1CQUFtQixnQkFBQSxxQkFBQSxHQUFuQixtQkFBbUIsQ0FBRSxxQkFBcUIsY0FBQSxxQkFBQSx1QkFEcEIscUJBQUEsQ0FFckIsZUFBeUI7RUFFNUIsTUFBTSxlQUFlLEdBQUcsbUJBQW1CLGFBQW5CLG1CQUFtQix1QkFBbkIsbUJBQW1CLENBQUUsSUFBdUI7RUFFcEUsTUFBTSw4QkFBOEIsR0FDbEMsSUFBQSxpREFBd0MsRUFBQyxDQUFDO0VBRTVDLE1BQU0sZ0NBQWdDLEdBQUcsSUFBQSx1QkFBVyxFQUNqRCxLQUFrQztJQUFBLElBQUEscUJBQUE7SUFBQSxRQUFBLHFCQUFBLEdBQ2pDLEtBQUssQ0FBQyxRQUFRLENBQUMsWUFBWSxDQUFDLElBQUksQ0FDN0IsV0FBVztNQUFBLElBQUEscUJBQUE7TUFBQTtRQUNWO1FBQ0E7UUFDQSxFQUFBLHFCQUFBLEdBQUMsV0FBVyxDQUFDLHFCQUFxQixjQUFBLHFCQUFBLHVCQUFsQyxxQkFBQSxDQUE0QyxlQUFlLE1BQzNEO01BQWU7SUFBQSxDQUNuQixDQUFDLGNBQUEscUJBQUEsdUJBTkQscUJBQUEsQ0FNRyxxQkFBcUI7RUFBQSxDQUM1QixDQUFDO0VBRUQsTUFBTSxxQkFBcUI7RUFDekI7RUFDQTtFQUNBLDhCQUE4QixJQUFJLGdDQUFnQztFQUVwRSxNQUFNLDBCQUEwQixHQUM5QixJQUFBLCtDQUFpQyxFQUFDLGVBQWUsQ0FBQyxJQUNsRCxrQ0FBMkIsQ0FBQyxRQUFRLENBQUMsZUFBZSxDQUFDO0VBRXZELE1BQU0sbUJBQW1CLEdBQUcsb0JBQW9CLENBQUMsUUFBUSxDQUN2RCxxQkFBcUIsYUFBckIscUJBQXFCLHVCQUFyQixxQkFBcUIsQ0FBRSxXQUN6QixDQUFDO0VBRUQsSUFBSSxtQkFBdUM7RUFFM0MsSUFBSSxxQkFBcUIsSUFBSSxtQkFBbUIsRUFBRTtJQUNoRCxNQUFNO01BQ0osS0FBSztNQUNMLFFBQVE7TUFDUixNQUFNO01BQ04sV0FBVyxFQUFFO0lBQ2YsQ0FBQyxHQUFHLHFCQUE4QztJQUNsRCxNQUFNO01BQUUsT0FBTztNQUFFLFNBQVM7TUFBRSxNQUFNO01BQUUsSUFBSTtNQUFFO0lBQVMsQ0FBQyxHQUNsRCxtQkFBNkQ7SUFFL0QsTUFBTSxrQkFBa0IsR0FBRyxVQUFVLEtBQUssb0NBQWtCLENBQUMsT0FBTztJQUVwRSxNQUFNLFVBQVUsR0FBRztNQUNqQixXQUFXLEVBQUUsS0FBSztNQUNsQixlQUFlLEVBQUUsZ0JBQWUsQ0FBQyxPQUFPO01BQ3hDLEtBQUssRUFBRyw0QkFBbUIsQ0FBNEIsT0FBTyxDQUFDO01BQy9ELGNBQWMsRUFBRSxrQkFBa0IsR0FBRyxPQUFPLEdBQUcsTUFBTTtNQUNyRCxNQUFNLEVBQUUsTUFBTSxLQUFJLFNBQVMsYUFBVCxTQUFTLHVCQUFULFNBQVMsQ0FBRSxNQUFNLEtBQUksTUFBTTtNQUM3QyxhQUFhLEVBQUUsSUFBSTtNQUNuQixhQUFhLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxRQUFRLElBQUksU0FBUyxDQUFDO01BQ3BELFVBQVUsRUFBRSxrQkFBa0IsR0FBRyxvQ0FBa0IsQ0FBQyxPQUFPLEdBQUcsVUFBVTtNQUN4RSxTQUFTLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxRQUFRO0lBQ3BDLENBQUM7SUFFRCxtQkFBbUIsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQztFQUNsRDtFQUVBLE9BQU8sSUFBQSxjQUFPLEVBQVUsTUFBTTtJQUM1QixJQUNFLENBQUMsMEJBQTBCLElBQzNCLG1CQUFtQixJQUNuQixDQUFDLHFCQUFxQixFQUN0QjtNQUNBLE9BQU8sRUFBRTtJQUNYO0lBRUEsSUFBSSxTQUFTLEdBQUcsbUJBQVksQ0FBQyxXQUFXO0lBQ3hDLElBQUksbUJBQW1CLEVBQUU7TUFBQSxJQUFBLGNBQUE7TUFDdkIsTUFBTSxXQUFXLEdBQ2YsQ0FBQSxJQUFJLGFBQUosSUFBSSxnQkFBQSxjQUFBLEdBQUosSUFBSSxDQUFFLFFBQVEsY0FBQSxjQUFBLHVCQUFkLGNBQUEsQ0FBQSxJQUFBLENBQUEsSUFBSSxFQUFhLG1CQUFtQixDQUFDLEtBQUksbUJBQW1CO01BRTlELFNBQVMsR0FBRyxHQUFHLGdEQUE4QixTQUFTLGtCQUFrQixDQUN0RSxXQUFXLENBQUMsUUFBUSxDQUFDLFFBQVEsQ0FDL0IsQ0FBQyxlQUFlLDhDQUE0QixFQUFFO0lBQ2hEO0lBRUEsT0FBTyxDQUFDLElBQUEsOEJBQXNCLEVBQUMscUJBQXFCLEVBQUUsQ0FBQyxFQUFFLFNBQVMsQ0FBQyxDQUFDO0VBQ3RFLENBQUMsRUFBRSxDQUNELDBCQUEwQixFQUMxQixtQkFBbUIsRUFDbkIscUJBQXFCLEVBQ3JCLG1CQUFtQixFQUNuQixDQUFDLENBQ0YsQ0FBQztBQUNKLENBQUM7QUFBQyxJQUFBLFFBQUEsR0FBQSxPQUFBLENBQUEsT0FBQSxHQUVhLGlCQUFpQjs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUN6SWhDLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFJQSxJQUFBLFVBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxhQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsZUFBQSxHQUFBLE9BQUE7QUFFQSxJQUFBLFFBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsU0FBQSxHQUFBLE9BQUE7QUFFQSxNQUFNLDJCQUEyQixHQUFHLENBQUEsS0FBZTtFQUFBLElBQUEsVUFBQTtFQUNqRCxNQUFNLENBQUMsR0FBRyxJQUFBLDhCQUFjLEVBQUMsQ0FBQztFQUUxQixNQUFNO0lBQUU7RUFBb0IsQ0FBQyxHQUFHLElBQUEsMkJBQWlCLEVBQUMsQ0FBQztFQUVuRCxNQUFNLE1BQU0sR0FBRyxJQUFBLGlDQUEwQixFQUFDLG1CQUFtQixDQUFDLEdBQ3pELG1CQUFtQixhQUFuQixtQkFBbUIsZ0JBQUEsVUFBQSxHQUFuQixtQkFBbUIsQ0FBMkIsU0FBUyxjQUFBLFVBQUEsdUJBQXhELFVBQUEsQ0FBMEQsTUFBTSxHQUMvRCxtQkFBbUIsYUFBbkIsbUJBQW1CLHVCQUFuQixtQkFBbUIsQ0FBc0IsTUFBTTtFQUVwRCxNQUFNLHNCQUFzQixHQUMxQixNQUFNLEtBQUssU0FBUyxJQUFJLE1BQU0sS0FBSyxVQUFVLElBQUksSUFBQSx3QkFBZSxFQUFDLE1BQU0sQ0FBQztFQUUxRSxPQUFPLElBQUEsY0FBTyxFQUFVLE1BQWU7SUFDckMsSUFBSSxzQkFBc0IsRUFBRTtNQUMxQixPQUFPLEVBQUU7SUFDWDtJQUVBLE9BQU8sQ0FDTDtNQUNFLEdBQUcsRUFBRSwrQkFBK0I7TUFDcEMsTUFBTSxFQUFFLENBQUMsQ0FBQyxpQkFBaUIsQ0FBQztNQUM1QixLQUFLLEVBQUUsc0JBQVcsQ0FBQyxXQUFXO01BQzlCLFFBQVEsRUFBRSxzQkFBUSxDQUFDLE9BQU87TUFDMUIsT0FBTyxFQUFFLENBQUMsQ0FBQyxvQ0FBb0MsQ0FBQztNQUNoRCxZQUFZLEVBQUUsQ0FDWixDQUFDLENBQUMseUJBQXlCLEVBQUUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxFQUN0QyxDQUFDLENBQUMseUJBQXlCLEVBQUUsQ0FBQyxNQUFNLEdBQUcsSUFBQSxzQkFBYSxFQUFDLE1BQU0sQ0FBQyxHQUFHLEVBQUUsQ0FBQyxDQUFDO0lBRXZFLENBQUMsQ0FDRjtFQUNILENBQUMsRUFBRSxDQUFDLE1BQU0sRUFBRSxzQkFBc0IsRUFBRSxDQUFDLENBQUMsQ0FBQztBQUN6QyxDQUFDO0FBQUMsSUFBQSxRQUFBLEdBQUEsT0FBQSxDQUFBLE9BQUEsR0FFYSwyQkFBMkI7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDN0MxQyxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxXQUFBLEdBQUEsT0FBQTtBQUtBLElBQUEsVUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLGFBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxRQUFBLEdBQUEsT0FBQTtBQUlBLElBQUEsVUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLGVBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxRQUFBLEdBQUEsT0FBQTtBQUdBLE1BQU0sbUJBQW1CLEdBQUcsRUFBRSxHQUFHLElBQUksQ0FBQyxDQUFDOztBQUVoQyxNQUFNLGtDQUFrQyxHQUFHLENBQUEsS0FBZTtFQUFBLElBQUEsVUFBQTtFQUMvRCxNQUFNLENBQUMsR0FBRyxJQUFBLDhCQUFjLEVBQUMsQ0FBQztFQUUxQixNQUFNO0lBQUU7RUFBb0IsQ0FBQyxHQUFHLElBQUEsMEJBQWlCLEVBQUMsQ0FBQztFQUNuRCxNQUFNO0lBQUUsT0FBTyxFQUFFLFVBQVUsR0FBRyxFQUFFO0lBQUUsRUFBRSxFQUFFO0VBQXNCLENBQUMsR0FDM0QsbUJBQW1CLElBQUksQ0FBQyxDQUFDO0VBQzNCLE1BQU0sU0FBUyxHQUNiLENBQUMsbUJBQW1CLGFBQW5CLG1CQUFtQix1QkFBbkIsbUJBQW1CLENBQXNCLE1BQU0sTUFDL0MsbUJBQW1CLGFBQW5CLG1CQUFtQixnQkFBQSxVQUFBLEdBQW5CLG1CQUFtQixDQUEyQixTQUFTLGNBQUEsVUFBQSx1QkFBeEQsVUFBQSxDQUEwRCxNQUFNLEtBQ2hFLEVBQUU7RUFDSixNQUFNLFVBQVUsR0FBRyxJQUFBLHVCQUFXLEVBQUUsS0FBSyxJQUNuQyxJQUFBLDhDQUFtQyxFQUFDLEtBQUssRUFBRSxVQUFVLENBQ3ZELENBQUM7RUFDRCxNQUFNLENBQUMsOEJBQThCLEVBQUUsb0NBQW9DLENBQUMsR0FDMUUsSUFBQSxlQUFRLEVBQWlDLENBQUM7RUFFNUMsSUFBQSxnQkFBUyxFQUFDLE1BQU07SUFDZCxJQUFJLFNBQVMsR0FBRyxJQUFJO0lBQ3BCLENBQUMsWUFBWTtNQUNYLE1BQU0sZ0JBQWdCLEdBQUcsTUFBTSxJQUFBLDBDQUFpQyxFQUFDLENBQUM7TUFFbEUsSUFBSSxDQUFDLFNBQVMsRUFBRTtRQUNkO01BQ0Y7TUFFQSxvQ0FBb0MsQ0FBQyxnQkFBZ0IsQ0FBQztNQUV0RCxNQUFNLE9BQU8sR0FDWCxDQUFDLGdCQUFnQixJQUFJLENBQUEsZ0JBQWdCLGFBQWhCLGdCQUFnQix1QkFBaEIsZ0JBQWdCLENBQUUsRUFBRSxNQUFLLHFCQUFxQjtNQUNyRSxJQUFJLENBQUMsT0FBTyxFQUFFO1FBQ1o7TUFDRjtNQUVBLElBQUEsMENBQWlDLEVBQUM7UUFDaEMsRUFBRSxFQUFFLHFCQUFxQjtRQUN6QixPQUFPLEVBQUUsVUFBVTtRQUNuQixNQUFNLEVBQUUsU0FBUztRQUNqQixTQUFTLEVBQUUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQztNQUNoQyxDQUFDLENBQUM7SUFDSixDQUFDLEVBQUUsQ0FBQztJQUNKLE9BQU8sTUFBTTtNQUNYLFNBQVMsR0FBRyxLQUFLO0lBQ25CLENBQUM7RUFDSCxDQUFDLEVBQUUsQ0FDRCxxQkFBcUIsRUFDckIsVUFBVSxFQUNWLFNBQVMsRUFDVCxvQ0FBb0MsQ0FDckMsQ0FBQztFQUVGLE1BQU0sK0JBQStCLEdBQUcsSUFBQSxjQUFPLEVBQVUsTUFBZTtJQUN0RSxJQUFJLENBQUMscUJBQXFCLElBQUksQ0FBQyw4QkFBOEIsRUFBRTtNQUM3RCxPQUFPLEVBQUU7SUFDWDtJQUVBLE1BQU0sTUFBZSxHQUFHLEVBQUU7SUFDMUIsTUFBTSxnQkFBZ0IsR0FBRyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDLENBQUM7SUFFN0MsTUFBTSx5QkFBeUIsR0FDN0IsZ0JBQWdCLEdBQUcsOEJBQThCLENBQUMsU0FBUztJQUU3RCxNQUFNLCtCQUErQixHQUNuQyx5QkFBeUIsSUFBSSxtQkFBbUI7SUFFbEQsSUFBSSxDQUFDLCtCQUErQixFQUFFO01BQ3BDLE9BQU8sRUFBRTtJQUNYO0lBRUEsTUFBTTtNQUFFLE9BQU87TUFBRTtJQUFPLENBQUMsR0FBRyw4QkFBOEI7SUFFMUQsSUFBSSxPQUFPLEtBQUssVUFBVSxFQUFFO01BQzFCLE1BQU0sQ0FBQyxJQUFJLENBQUM7UUFDVixHQUFHLEVBQUUsbUJBQW1CO1FBQ3hCLE1BQU0sRUFBRSxDQUFDLENBQUMsZ0JBQWdCLENBQUM7UUFDM0IsS0FBSyxFQUFFLHNCQUFXLENBQUMsT0FBTztRQUMxQixRQUFRLEVBQUUsc0JBQVEsQ0FBQyxJQUFJO1FBQ3ZCLE9BQU8sRUFBRSxDQUFDLENBQUMsdUJBQXVCLEVBQUUsQ0FBQyxDQUFBLFVBQVUsYUFBVixVQUFVLHVCQUFWLFVBQVUsQ0FBRSxJQUFJLEtBQUksRUFBRSxDQUFDO01BQzlELENBQUMsQ0FBQztJQUNKO0lBRUEsSUFBSSxNQUFNLEtBQUssU0FBUyxFQUFFO01BQ3hCLE1BQU0sQ0FBQyxJQUFJLENBQUM7UUFDVixHQUFHLEVBQUUsa0JBQWtCO1FBQ3ZCLE1BQU0sRUFBRSxDQUFDLENBQUMsZUFBZSxDQUFDO1FBQzFCLEtBQUssRUFBRSxzQkFBVyxDQUFDLFdBQVc7UUFDOUIsUUFBUSxFQUFFLHNCQUFRLENBQUMsSUFBSTtRQUN2QixPQUFPLEVBQUUsQ0FBQyxDQUFDLHNCQUFzQixFQUFFLENBQUMsU0FBUyxJQUFJLEVBQUUsQ0FBQztNQUN0RCxDQUFDLENBQUM7SUFDSjtJQUVBLE9BQU8sTUFBTTtFQUNmLENBQUMsRUFBRSxDQUNELHFCQUFxQixFQUNyQiw4QkFBOEIsRUFDOUIsVUFBVSxhQUFWLFVBQVUsdUJBQVYsVUFBVSxDQUFFLElBQUksRUFDaEIsVUFBVSxFQUNWLFNBQVMsRUFDVCxDQUFDLENBQ0YsQ0FBQztFQUVGLE9BQU8sK0JBQStCO0FBQ3hDLENBQUM7QUFBQyxPQUFBLENBQUEsa0NBQUEsR0FBQSxrQ0FBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUN4SEYsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUdBLElBQUEsVUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLGFBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxlQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsUUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLGdCQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsc0JBQUEsR0FBQSxPQUFBO0FBR08sU0FBUywwQkFBMEIsQ0FBQSxFQUFZO0VBQUEsSUFBQSxVQUFBO0VBQ3BELE1BQU0sQ0FBQyxHQUFHLElBQUEsOEJBQWMsRUFBQyxDQUFDO0VBQzFCLE1BQU07SUFBRTtFQUFvQixDQUFDLEdBQUcsSUFBQSwwQkFBaUIsRUFBQyxDQUFDO0VBRW5ELE1BQU0sTUFBTSxHQUNWLENBQUMsbUJBQW1CLGFBQW5CLG1CQUFtQix1QkFBbkIsbUJBQW1CLENBQXNCLE1BQU0sTUFDL0MsbUJBQW1CLGFBQW5CLG1CQUFtQixnQkFBQSxVQUFBLEdBQW5CLG1CQUFtQixDQUEyQixTQUFTLGNBQUEsVUFBQSx1QkFBeEQsVUFBQSxDQUEwRCxNQUFNLEtBQ2hFLEVBQUU7RUFFSixNQUFNO0lBQUUsS0FBSyxFQUFFO0VBQWlCLENBQUMsR0FBRyxJQUFBLDRDQUFxQixFQUFDLE1BQU0sQ0FBQztFQUVqRSxPQUFPLElBQUEsY0FBTyxFQUFDLE1BQU07SUFDbkIsSUFBSSxDQUFDLE1BQU0sRUFBRTtNQUNYLE9BQU8sRUFBRTtJQUNYO0lBRUEsTUFBTSxNQUFlLEdBQUcsRUFBRTtJQUUxQixJQUFJLGdCQUFnQixLQUFLLHdDQUF1QixDQUFDLFNBQVMsRUFBRTtNQUMxRCxNQUFNLENBQUMsSUFBSSxDQUFDO1FBQ1YsR0FBRyxFQUFFLDRCQUE0QjtRQUNqQyxNQUFNLEVBQUUsQ0FBQyxDQUFDLHVDQUF1QyxDQUFDO1FBQ2xELEtBQUssRUFBRSxzQkFBVyxDQUFDLFdBQVc7UUFDOUIsUUFBUSxFQUFFLHNCQUFRLENBQUMsTUFBTTtRQUN6QixPQUFPLEVBQUUsQ0FBQyxDQUFDLHdDQUF3QztNQUNyRCxDQUFDLENBQUM7SUFDSixDQUFDLE1BQU0sSUFBSSxnQkFBZ0IsS0FBSyx3Q0FBdUIsQ0FBQyxPQUFPLEVBQUU7TUFDL0QsTUFBTSxDQUFDLElBQUksQ0FBQztRQUNWLEdBQUcsRUFBRSwwQkFBMEI7UUFDL0IsTUFBTSxFQUFFLENBQUMsQ0FBQyxxQ0FBcUMsQ0FBQztRQUNoRCxLQUFLLEVBQUUsc0JBQVcsQ0FBQyxXQUFXO1FBQzlCLFFBQVEsRUFBRSxzQkFBUSxDQUFDLE9BQU87UUFDMUIsT0FBTyxFQUFFLENBQUMsQ0FBQyxzQ0FBc0M7TUFDbkQsQ0FBQyxDQUFDO0lBQ0o7SUFFQSxPQUFPLE1BQU07RUFDZixDQUFDLEVBQUUsQ0FBQyxNQUFNLEVBQUUsZ0JBQWdCLEVBQUUsQ0FBQyxDQUFDLENBQUM7QUFDbkM7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDaERBLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFdBQUEsR0FBQSxPQUFBO0FBRUEsSUFBQSxZQUFBLEdBQUEsT0FBQTtBQUtBLElBQUEsVUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLGFBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxlQUFBLEdBQUEsT0FBQTtBQUVBLElBQUEsUUFBQSxHQUFBLE9BQUE7QUFFTyxNQUFNLHdCQUF3QixHQUFHLENBQUEsS0FBZTtFQUFBLElBQUEscUJBQUEsRUFBQSxVQUFBLEVBQUEsU0FBQTtFQUNyRCxNQUFNLENBQUMsR0FBRyxJQUFBLDhCQUFjLEVBQUMsQ0FBQztFQUUxQixNQUFNO0lBQUU7RUFBb0IsQ0FBQyxHQUFHLElBQUEsMEJBQWlCLEVBQUMsQ0FBQztFQUNuRCxNQUFNLHNCQUFzQixHQUFHLElBQUEsdUJBQVcsRUFBQyxvQ0FBdUIsQ0FBQztFQUNuRSxNQUFNLGdDQUFnQyxHQUFHLElBQUEsdUJBQVcsRUFDbEQsZ0RBQ0YsQ0FBQztFQUNELE1BQU0sd0NBQXdDLElBQUEscUJBQUEsR0FDNUMsZ0NBQWdDLENBQUMsSUFBSSxDQUNsQyxZQUFZLElBQUssWUFBWSxDQUFDLEVBQUUsS0FBSyxzQkFDeEMsQ0FBQyxjQUFBLHFCQUFBLHVCQUZELHFCQUFBLENBRUcsUUFBUTtFQUViLE1BQU0sV0FBVyxHQUNmLENBQUMsbUJBQW1CLGFBQW5CLG1CQUFtQixnQkFBQSxVQUFBLEdBQW5CLG1CQUFtQixDQUEyQixTQUFTLGNBQUEsVUFBQSx1QkFBeEQsVUFBQSxDQUEwRCxJQUFJLE1BQzdELG1CQUFtQixhQUFuQixtQkFBbUIsZ0JBQUEsU0FBQSxHQUFuQixtQkFBbUIsQ0FBc0IsUUFBUSxjQUFBLFNBQUEsdUJBQWxELFNBQUEsQ0FBb0QsSUFBSTtFQUUxRCxNQUFNLGlDQUFpQyxHQUNyQyx3Q0FBd0MsYUFBeEMsd0NBQXdDLHVCQUF4Qyx3Q0FBd0MsQ0FBRSxJQUFJLENBQzNDLE9BQU8sSUFBSyxPQUFPLENBQUMsT0FBTyxDQUFDLFdBQVcsQ0FBQyxDQUFDLE1BQUssV0FBVyxhQUFYLFdBQVcsdUJBQVgsV0FBVyxDQUFFLFdBQVcsQ0FBQyxDQUFDLENBQzNFLENBQUM7RUFFSCxNQUFNLHdDQUF3QyxHQUM1QyxDQUFDLFdBQVcsSUFBSSxpQ0FBaUM7RUFFbkQsT0FBTyxJQUFBLGNBQU8sRUFBVSxNQUFlO0lBQ3JDLElBQUksd0NBQXdDLEVBQUU7TUFDNUMsT0FBTyxFQUFFO0lBQ1g7SUFFQSxPQUFPLENBQ0w7TUFDRSxHQUFHLEVBQUUsd0JBQXdCO01BQzdCLE1BQU0sRUFBRSxDQUFDLENBQUMseUJBQXlCLENBQUM7TUFDcEMsS0FBSyxFQUFFLHNCQUFXLENBQUMsYUFBYTtNQUNoQyxRQUFRLEVBQUUsc0JBQVEsQ0FBQyxJQUFJO01BQ3ZCLE9BQU8sRUFBRSxDQUFDLENBQUMsNkJBQTZCO0lBQzFDLENBQUMsQ0FDRjtFQUNILENBQUMsRUFBRSxDQUFDLHdDQUF3QyxFQUFFLENBQUMsQ0FBQyxDQUFDO0FBQ25ELENBQUM7QUFBQyxPQUFBLENBQUEsd0JBQUEsR0FBQSx3QkFBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNyREYsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsV0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFVBQUEsR0FBQSxPQUFBO0FBRUEsSUFBQSxhQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsZUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFNBQUEsR0FBQSxPQUFBO0FBSUEsSUFBQSxRQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsOEJBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSwyQkFBQSxHQUFBLE9BQUE7QUFFQSxNQUFNLGVBQWUsR0FBSSxVQUE4QixJQUFLO0VBQzFEO0VBQ0EsSUFBSSxZQUFvQjtFQUN4QixRQUFRLFVBQVU7SUFDaEI7SUFDQSxLQUFLLE1BQU07TUFDVCxZQUFZLEdBQUcsOENBQThDO01BQzdEO0lBQ0Y7SUFDQSxLQUFLLE1BQU07TUFDVCxZQUFZLEdBQUcsOENBQThDO01BQzdEO0lBQ0Y7SUFDQSxLQUFLLE1BQU07TUFDVCxZQUFZLEdBQUcsOENBQThDO01BQzdEO0lBQ0Y7SUFDQSxLQUFLLE1BQU07TUFDVCxZQUFZLEdBQUcsOENBQThDO01BQzdEO0lBQ0Y7SUFDQSxLQUFLLE1BQU07TUFDVCxZQUFZLEdBQUcsOENBQThDO01BQzdEO0lBQ0Y7SUFDQSxLQUFLLE1BQU07TUFDVCxZQUFZLEdBQUcsMENBQTBDO01BQ3pEO0lBQ0Y7SUFDQSxLQUFLLE1BQU07TUFDVCxZQUFZLEdBQUcsMENBQTBDO01BQ3pEO0lBQ0Y7SUFDQSxLQUFLLE1BQU07TUFDVCxZQUFZLEdBQUcsMENBQTBDO01BQ3pEO0lBQ0Y7SUFDQSxLQUFLLE1BQU07TUFDVCxZQUFZLEdBQUcsMENBQTBDO01BQ3pEO0lBQ0Y7SUFDQSxLQUFLLE1BQU07TUFDVCxZQUFZLEdBQUcsMENBQTBDO01BQ3pEO0lBQ0Y7SUFDQSxLQUFLLE1BQU07TUFDVCxZQUFZLEdBQUcsMENBQTBDO01BQ3pEO0lBQ0Y7SUFDQSxLQUFLLE1BQU07TUFDVCxZQUFZLEdBQUcsMENBQTBDO01BQ3pEO0lBQ0Y7SUFDQSxLQUFLLE1BQU07TUFDVCxZQUFZLEdBQUcsMENBQTBDO01BQ3pEO0lBQ0Y7SUFDQSxLQUFLLE1BQU07TUFDVCxZQUFZLEdBQUcsMENBQTBDO01BQ3pEO0lBQ0Y7SUFDQSxLQUFLLE1BQU07TUFDVCxZQUFZLEdBQUcsMENBQTBDO01BQ3pEO0lBQ0Y7SUFDQSxLQUFLLE1BQU07TUFDVCxZQUFZLEdBQUcsMENBQTBDO01BQ3pEO0lBQ0Y7SUFDQSxLQUFLLE1BQU07TUFDVCxZQUFZLEdBQUcsMENBQTBDO01BQ3pEO0lBQ0Y7SUFDQSxLQUFLLE1BQU07TUFDVCxZQUFZLEdBQUcsMENBQTBDO01BQ3pEO0lBQ0Y7SUFDQSxLQUFLLE1BQU07TUFDVCxZQUFZLEdBQUcsMENBQTBDO01BQ3pEO0lBQ0Y7SUFDQSxLQUFLLE1BQU07TUFDVCxZQUFZLEdBQUcsMENBQTBDO01BQ3pEO0lBQ0Y7SUFDQSxLQUFLLE1BQU07TUFDVCxZQUFZLEdBQUcsMENBQTBDO01BQ3pEO0lBQ0Y7SUFDQSxLQUFLLE1BQU07TUFDVCxZQUFZLEdBQUcsNkNBQTZDO01BQzVEO0lBQ0Y7SUFDQSxLQUFLLE1BQU07TUFDVCxZQUFZLEdBQUcsaURBQWlEO01BQ2hFO0lBQ0Y7SUFDQSxLQUFLLE1BQU07TUFDVCxZQUFZLEdBQUcsaURBQWlEO01BQ2hFO0lBQ0Y7SUFDQSxLQUFLLE1BQU07TUFDVCxZQUFZLEdBQUcsaURBQWlEO01BQ2hFO0lBQ0Y7SUFDQSxLQUFLLE1BQU07TUFDVCxZQUFZLEdBQUcsaURBQWlEO01BQ2hFO0lBQ0Y7TUFDRSxZQUFZLEdBQUcsbUNBQW1DO0VBQ3REO0VBRUEsT0FBTyxZQUFZO0FBQ3JCLENBQUM7QUFFTSxTQUFTLHNCQUFzQixDQUFBLEVBQVk7RUFDaEQsTUFBTSxDQUFDLEdBQUcsSUFBQSw4QkFBYyxFQUFDLENBQUM7RUFDMUIsTUFBTTtJQUFFO0VBQW9CLENBQUMsR0FBRyxJQUFBLDBCQUFpQixFQUUvQyxDQUFDO0VBQ0gsTUFBTTtJQUFFLFVBQVU7SUFBRTtFQUFPLENBQUMsR0FBRyxJQUFBLHVCQUFXLEVBQUUsS0FBSyxJQUMvQyxJQUFBLDJCQUFpQixFQUFDLEtBQUssRUFBaUIsbUJBQW1CLGFBQW5CLG1CQUFtQix1QkFBbkIsbUJBQW1CLENBQUUsRUFBRSxDQUNqRSxDQUFDO0VBQ0QsTUFBTSxZQUFZLEdBQUcsZUFBZSxDQUFDLFVBQVUsQ0FBQztFQUVoRCxNQUFNLDRCQUE0QixHQUFHLElBQUEsNERBQTZCLEVBQUMsQ0FBQztFQUNwRSxNQUFNLFNBQVMsR0FBRyw0QkFBNEI7RUFFOUMsT0FBTyxJQUFBLGNBQU8sRUFBVSxNQUFlO0lBQ3JDLElBQUksQ0FBQyxTQUFTLEVBQUU7TUFDZCxPQUFPLEVBQUU7SUFDWDtJQUVBLElBQUksUUFBUSxHQUFHLHNCQUFRLENBQUMsSUFBSTtJQUM1QixJQUFJLGVBQWUsR0FBRyxDQUFDLENBQUMsa0JBQWtCLENBQUM7SUFDM0MsUUFBUSxNQUFNO01BQ1osS0FBSyxTQUFTO1FBQ1osUUFBUSxHQUFHLHNCQUFRLENBQUMsT0FBTztRQUMzQixlQUFlLEdBQUcsQ0FBQyxDQUFDLGVBQWUsQ0FBQztRQUNwQztNQUNGLEtBQUssV0FBVztRQUNkLFFBQVEsR0FBRyxzQkFBUSxDQUFDLE1BQU07UUFDMUI7TUFDRjtJQUNGO0lBRUEsT0FBTyxDQUNMO01BQ0UsR0FBRyxFQUFFLHFCQUFxQjtNQUMxQixNQUFNLEVBQUUsQ0FBQyxDQUFDLGlDQUFpQyxDQUFDO01BQzVDLEtBQUssRUFBRSxzQkFBVyxDQUFDLDZCQUE2QjtNQUNoRCxRQUFRO01BQ1IsT0FBTyxFQUFFLElBQUEsc0RBQTBCLEVBQUMsWUFBWSxDQUFDO01BQ2pELFVBQVUsRUFBRSxLQUFLO01BQ2pCLGVBQWU7TUFDZixTQUFTLEVBQUUsS0FBSztNQUNoQixrQkFBa0IsRUFBRSxNQUFNLEtBQUs7SUFDakMsQ0FBQyxDQUNGO0VBQ0gsQ0FBQyxFQUFFLENBQUMsTUFBTSxFQUFFLFlBQVksRUFBRSxTQUFTLEVBQUUsQ0FBQyxDQUFDLENBQUM7QUFDMUM7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDaExBLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLHNCQUFBLEdBQUEsT0FBQTtBQUtBLElBQUEsYUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFVBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxRQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsZ0JBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxlQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEscUJBQUEsR0FBQSxPQUFBO0FBRUEsTUFBTSxZQUFxQixHQUFHLEVBQUU7QUFDaEMsTUFBTSxhQUErQixHQUFHLEVBQUU7QUFFbkMsU0FBUyx5QkFBeUIsQ0FBQSxFQUFZO0VBQUEsSUFBQSxxQkFBQTtFQUNuRCxNQUFNLENBQUMsR0FBRyxJQUFBLDhCQUFjLEVBQUMsQ0FBQztFQUMxQixNQUFNO0lBQUU7RUFBb0IsQ0FBQyxHQUFHLElBQUEsMEJBQWlCLEVBQUMsQ0FBQztFQUVuRCxNQUFNLE1BQU0sR0FBRyxtQkFBa0Q7RUFDakUsTUFBTSxPQUFPLEdBQUcsTUFBTSxhQUFOLE1BQU0sdUJBQU4sTUFBTSxDQUFFLE9BQU87RUFDL0IsTUFBTSxtQkFBbUIsR0FBRyxNQUFNLGFBQU4sTUFBTSxnQkFBQSxxQkFBQSxHQUFOLE1BQU0sQ0FBRSxjQUFjLGNBQUEscUJBQUEsdUJBQXRCLHFCQUFBLENBQXdCLG1CQUFtQjtFQUV2RSxNQUFNLHNCQUFzQixHQUFHLElBQUEsY0FBTyxFQUF1QixNQUFNO0lBQ2pFLElBQUksRUFBQyxtQkFBbUIsYUFBbkIsbUJBQW1CLGVBQW5CLG1CQUFtQixDQUFFLE1BQU0sR0FBRTtNQUNoQyxPQUFPLFNBQVM7SUFDbEI7SUFDQSxNQUFNLFNBQVMsR0FBRyxtQkFBbUIsQ0FDbEMsTUFBTSxDQUNKLE1BQU0sSUFDTCxDQUFDLE1BQU0sQ0FBQyxVQUFVLElBQ2xCLE1BQU0sQ0FBQyxRQUFRLEtBQUssOENBQXVCLENBQUMsS0FBSyxJQUNqRCxNQUFNLENBQUMsT0FDWCxDQUFDLENBQ0EsR0FBRyxDQUFFLE1BQU0sSUFBSyxNQUFNLENBQUMsT0FBTyxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUM7SUFDaEQsT0FBTyxTQUFTLENBQUMsTUFBTSxHQUFHLFNBQVMsR0FBRyxTQUFTO0VBQ2pELENBQUMsRUFBRSxDQUFDLG1CQUFtQixDQUFDLENBQUM7RUFFekIsTUFBTSxpQkFBaUIsR0FBRyxJQUFBLHNEQUFnQyxFQUN4RCxPQUFPLEVBQ1Asc0JBQ0YsQ0FBQztFQUVELE9BQU8sSUFBQSxjQUFPLEVBQUMsTUFBTTtJQUNuQixJQUFJLEVBQUMsc0JBQXNCLGFBQXRCLHNCQUFzQixlQUF0QixzQkFBc0IsQ0FBRSxNQUFNLEdBQUU7TUFDbkMsT0FBTyxZQUFZO0lBQ3JCO0lBRUEsTUFBTSxpQkFBaUIsR0FBRyxpQkFBaUIsYUFBakIsaUJBQWlCLHVCQUFqQixpQkFBaUIsQ0FBRSxJQUFJLENBQzlDLENBQUMsSUFBSyxDQUFDLENBQUMsS0FBSyxLQUFLLHdDQUF1QixDQUFDLFNBQzdDLENBQUM7SUFDRCxNQUFNLGVBQWUsR0FBRyxpQkFBaUIsYUFBakIsaUJBQWlCLHVCQUFqQixpQkFBaUIsQ0FBRSxJQUFJLENBQzVDLENBQUMsSUFBSyxDQUFDLENBQUMsS0FBSyxLQUFLLHdDQUF1QixDQUFDLE9BQzdDLENBQUM7SUFFRCxJQUFJLGlCQUFpQixFQUFFO01BQ3JCLE9BQU8sQ0FDTDtRQUNFLE9BQU8sRUFBRSxhQUFhO1FBQ3RCLEtBQUssRUFBRSxzQkFBVyxDQUFDLGNBQWM7UUFDakMsVUFBVSxFQUFFLEtBQUs7UUFDakIsR0FBRyxFQUFFLDJCQUEyQjtRQUNoQyxPQUFPLEVBQUUsQ0FBQyxDQUFDLHVDQUF1QyxDQUFDO1FBQ25ELE1BQU0sRUFBRSxDQUFDLENBQUMsc0NBQXNDLENBQUM7UUFDakQsUUFBUSxFQUFFLHNCQUFRLENBQUM7TUFDckIsQ0FBQyxDQUNGO0lBQ0g7SUFDQSxJQUFJLGVBQWUsRUFBRTtNQUNuQixPQUFPLENBQ0w7UUFDRSxPQUFPLEVBQUUsYUFBYTtRQUN0QixLQUFLLEVBQUUsc0JBQVcsQ0FBQyxjQUFjO1FBQ2pDLFVBQVUsRUFBRSxLQUFLO1FBQ2pCLEdBQUcsRUFBRSx5QkFBeUI7UUFDOUIsT0FBTyxFQUFFLENBQUMsQ0FBQyxxQ0FBcUMsQ0FBQztRQUNqRCxNQUFNLEVBQUUsQ0FBQyxDQUFDLG9DQUFvQyxDQUFDO1FBQy9DLFFBQVEsRUFBRSxzQkFBUSxDQUFDO01BQ3JCLENBQUMsQ0FDRjtJQUNIO0lBRUEsT0FBTyxZQUFZO0VBQ3JCLENBQUMsRUFBRSxDQUFDLHNCQUFzQixFQUFFLGlCQUFpQixFQUFFLENBQUMsQ0FBQyxDQUFDO0FBQ3BEOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDckZBLElBQUEsaUJBQUEsR0FBQSxPQUFBO0FBS0EsSUFBQSxhQUFBLEdBQUEsT0FBQTtBQVFBO0FBQ08sTUFBTSwwQkFBMEIsR0FBQSxPQUFBLENBQUEsMEJBQUEsR0FBRyxNQUFNLENBQUMsTUFBTSxDQUFDO0VBQ3RELENBQUMsZ0NBQWMsQ0FBQyxlQUFlLEdBQUcsbUNBQW1DO0VBQ3JFLENBQUMsZ0NBQWMsQ0FBQyxhQUFhLEdBQUcsbUNBQW1DO0VBQ25FLENBQUMsZ0NBQWMsQ0FBQyxpQkFBaUIsR0FBRyxtQ0FBbUM7RUFFdkUsQ0FBQyxnQ0FBYyxDQUFDLFdBQVcsR0FBRyxnQ0FBZ0M7RUFFOUQsQ0FBQyxnQ0FBYyxDQUFDLE9BQU8sR0FBRyw0QkFBNEI7RUFBRTs7RUFFeEQsQ0FBQyxnQ0FBYyxDQUFDLGNBQWMsR0FBRyxtQ0FBbUM7RUFFcEUsQ0FBQyxnQ0FBYyxDQUFDLGVBQWUsR0FBRyxvQ0FBb0M7RUFFdEUsQ0FBQyxnQ0FBYyxDQUFDLG1CQUFtQixHQUFHLG9DQUFvQztFQUMxRSxDQUFDLGdDQUFjLENBQUMsaUJBQWlCLEdBQUcsb0NBQW9DO0VBRXhFLENBQUMsZ0NBQWMsQ0FBQyxzQkFBc0IsR0FBRyxvQ0FBb0M7RUFDN0UsQ0FBQyxnQ0FBYyxDQUFDLGVBQWUsR0FBRyxvQ0FBb0M7RUFDdEUsQ0FBQyxnQ0FBYyxDQUFDLG1CQUFtQixHQUFHLG9DQUFvQztFQUUxRSxDQUFDLGdDQUFjLENBQUMsS0FBSyxHQUFHO0FBQzFCLENBQUMsQ0FBQzs7QUFFRjtBQUNPLE1BQU0sb0JBQW9CLEdBQUEsT0FBQSxDQUFBLG9CQUFBLEdBQUcsTUFBTSxDQUFDLE1BQU0sQ0FBQztFQUNoRCxDQUFDLGdDQUFjLENBQUMsT0FBTyxHQUFHLDJCQUEyQjtFQUNyRCxDQUFDLGdDQUFjLENBQUMsbUJBQW1CLEdBQUc7QUFDeEMsQ0FBQyxDQUFDOztBQUVGO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLFNBQVMsd0JBQXdCLENBQ3RDLFFBQTRCLEVBQ2I7RUFDZixRQUFRLFFBQVE7SUFDZCxLQUFLLG9DQUFrQixDQUFDLFNBQVM7TUFDL0IsT0FBTyxzQkFBUSxDQUFDLE1BQU07SUFDeEIsS0FBSyxvQ0FBa0IsQ0FBQyxPQUFPO01BQzdCLE9BQU8sc0JBQVEsQ0FBQyxPQUFPO0lBQ3pCO01BQ0UsT0FBTyxzQkFBUSxDQUFDLElBQUk7RUFDeEI7QUFDRjs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ08sU0FBUyxzQkFBc0IsQ0FDcEMscUJBQTRDLEVBQzVDLENBQW9DLEVBQ3BDLFNBQWtCLEVBQ1g7RUFDUCxPQUFPO0lBQ0w7SUFDQTtJQUNBLEdBQUcsRUFBRSxxQkFBcUIsQ0FBQyxlQUFlLElBQUksRUFBRTtJQUNoRCxNQUFNLEVBQUUsQ0FBQyxDQUNQLG9CQUFvQixDQUNsQixxQkFBcUIsQ0FBQyxNQUFNLENBQzdCLElBQUksd0JBQ1AsQ0FBQztJQUNELFFBQVEsRUFBRSx3QkFBd0IsQ0FDaEMscUJBQXFCLENBQUMsV0FDeEIsQ0FBQztJQUNELFlBQVksRUFBRSxxQkFBcUIsQ0FBQyxRQUFRO0lBQzVDLE9BQU8sRUFBRSxDQUFDLENBQ1IsMEJBQTBCLENBQ3hCLHFCQUFxQixDQUFDLE1BQU0sQ0FDN0IsSUFBSSwwQkFBMEIsQ0FBQyxLQUNsQyxDQUFDO0lBQ0QsUUFBUSxFQUFFLGtDQUFnQixDQUFDLFFBQVE7SUFBRTtJQUNyQztFQUNGLENBQUM7QUFDSDs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNoR0EsSUFBQSxXQUFBLEdBQUEsT0FBQTtBQUVBLElBQUEsUUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFVBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSx5QkFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLHNCQUFBLEdBQUEsT0FBQTtBQUVPLFNBQVMsbUJBQW1CLENBQUEsRUFBRztFQUNwQyxNQUFNO0lBQUUsbUJBQW1CLEVBQUU7RUFBZ0IsQ0FBQyxHQUM1QyxJQUFBLDBCQUFpQixFQUFrQixDQUFDO0VBRXRDLE1BQU07SUFBRTtFQUFhLENBQUMsR0FBRyxlQUFlLElBQUksQ0FBQyxDQUFDO0VBRTlDLE1BQU07SUFBRSxXQUFXLEVBQUU7RUFBbUIsQ0FBQyxHQUFHLElBQUEsNENBQXFCLEVBQUMsQ0FBQztFQUNuRSxNQUFNLG1CQUFtQixHQUFHLElBQUEsdUJBQVcsRUFBQyx1Q0FBNEIsQ0FBQztFQUVyRSxNQUFNLHFCQUFxQixHQUFHLElBQUEsa0RBQXdCLEVBQUMsQ0FBQztFQUV4RCxNQUFNLGdCQUFnQixHQUNwQixtQkFBbUIsSUFDbkIsa0JBQWtCLElBQ2xCLHFCQUFxQixJQUNyQixDQUFDLFlBQVk7RUFFZixPQUFPO0lBQUU7RUFBaUIsQ0FBQztBQUM3Qjs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUN6QkEsSUFBQSxXQUFBLEdBQUEsT0FBQTtBQUdBLElBQUEsVUFBQSxHQUFBLE9BQUE7QUFJQSxJQUFBLFNBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxzQkFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFFBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxRQUFBLEdBQUEsT0FBQTtBQUtPLFNBQVMscUJBQXFCLENBQUEsRUFBRztFQUN0QyxNQUFNO0lBQUUsbUJBQW1CLEVBQUU7RUFBZ0IsQ0FBQyxHQUM1QyxJQUFBLDBCQUFpQixFQUFrQixDQUFDO0VBRXRDLE1BQU07SUFBRSxPQUFPO0lBQUU7RUFBUyxDQUFDLEdBQUcsZUFBZSxJQUFJLENBQUMsQ0FBQztFQUNuRCxNQUFNO0lBQUU7RUFBSyxDQUFDLEdBQUcsUUFBUSxJQUFJLENBQUMsQ0FBQztFQUUvQixNQUFNLGtCQUFrQixHQUFHLElBQUEsdUJBQVcsRUFBRSxLQUE2QixJQUNuRSxJQUFBLGdDQUFxQixFQUFDLEtBQUssRUFBRSxPQUFPLENBQ3RDLENBQUM7RUFFRCxNQUFNO0lBQUUsS0FBSyxFQUFFO0VBQXlCLENBQUMsR0FBRyxJQUFBLHdCQUFjLEVBQUMsWUFBWTtJQUNyRSxJQUFJLGtCQUFrQixFQUFFO01BQ3RCLE9BQU8sU0FBUztJQUNsQjtJQUVBLE9BQU8sSUFBQSw2Q0FBc0IsRUFBQztNQUM1QixPQUFPLEVBQUUsSUFBVztNQUNwQixRQUFRLEVBQUUsQ0FBQyxPQUFPO0lBQ3BCLENBQUMsQ0FBQztFQUNKLENBQUMsRUFBRSxDQUFDLE9BQU8sRUFBRSxJQUFJLEVBQUUsa0JBQWtCLENBQUMsQ0FBQztFQUV2QyxNQUFNO0lBQUUsS0FBSyxFQUFFO0VBQW1CLENBQUMsR0FBRyxJQUFBLHdCQUFjLEVBQUMsWUFBWTtJQUMvRCxJQUFJLGtCQUFrQixFQUFFO01BQ3RCLE9BQU8sU0FBUztJQUNsQjtJQUVBLE9BQU8sSUFBQSx5QkFBZ0IsRUFBQyxPQUFPLENBQUM7RUFDbEMsQ0FBQyxFQUFFLENBQUMsT0FBTyxFQUFFLGtCQUFrQixDQUFDLENBQUM7RUFFakMsTUFBTTtJQUFFLEtBQUssRUFBRTtFQUF3QixDQUFDLEdBQUcsSUFBQSx3QkFBYyxFQUFDLFlBQVk7SUFDcEUsT0FBTyxJQUFBLDhCQUFxQixFQUFDLE9BQU8sQ0FBQztFQUN2QyxDQUFDLEVBQUUsQ0FBQyxPQUFPLENBQUMsQ0FBQztFQUViLE1BQU0sdUJBQXVCLEdBQUcsd0JBQXdCLGFBQXhCLHdCQUF3Qix1QkFBeEIsd0JBQXdCLENBQUUsSUFBSSxDQUMzRCxNQUFNLElBQUssTUFBTSxDQUFDLE9BQU8sQ0FBQyxXQUFXLENBQUMsQ0FBQyxLQUFLLE9BQU8sQ0FBQyxXQUFXLENBQUMsQ0FDbkUsQ0FBQzs7RUFFRDtFQUNBLE1BQU0sZUFBZSxHQUFHLE9BQU8sQ0FDN0IsQ0FBQSx1QkFBdUIsYUFBdkIsdUJBQXVCLHVCQUF2Qix1QkFBdUIsQ0FBRSxXQUFXLEtBQ2xDLGtCQUFrQjtFQUNsQjtFQUNBLENBQUEsZUFBZSxhQUFmLGVBQWUsdUJBQWYsZUFBZSxDQUFFLFFBQVEsQ0FBQyxFQUFFLE1BQUssU0FDckMsQ0FBQztFQUVELE1BQU0sV0FBVyxHQUFHLE9BQU8sQ0FDeEIsa0JBQWtCLElBQUksdUJBQXVCLElBQUssZUFDckQsQ0FBQztFQUVELE9BQU87SUFDTCxXQUFXO0lBQ1g7RUFDRixDQUFDO0FBQ0g7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDckVBLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFFQSxJQUFBLFlBQUEsR0FBQSxPQUFBO0FBSUEsSUFBQSxhQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsS0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFlBQUEsR0FBQSxPQUFBO0FBS0EsSUFBQSxZQUFBLEdBQUEsT0FBQTtBQUVPLE1BQU0seUJBQXlCLEdBQUcsQ0FBQSxLQUFNO0VBQzdDLE1BQU0sVUFBVSxHQUFHLElBQUEsaUJBQVUsRUFBQyxnQ0FBa0IsQ0FBQztFQUNqRCxNQUFNO0lBQUU7RUFBUSxDQUFDLEdBQUcsSUFBQSxvQkFBYyxFQUFDLENBQUM7RUFDcEMsTUFBTTtJQUFFO0VBQWMsQ0FBQyxHQUFHLElBQUEsd0JBQVcsRUFBQyxDQUFDO0VBQ3ZDLE1BQU07SUFDSixXQUFXO0lBQ1gsaUJBQWlCO0lBQ2pCLGVBQWU7SUFDZixvQkFBb0I7SUFDcEI7RUFDRixDQUFDLEdBQUcsSUFBQSxrQ0FBcUIsRUFBQyxDQUFDO0VBRTNCLE1BQU0sMEJBQTBCLEdBQUcsSUFBQSxrQkFBVyxFQUFDLE1BQU07SUFDbkQsb0JBQW9CLENBQUMsOEJBQWlCLENBQUMsTUFBTSxDQUFDO0VBQ2hELENBQUMsRUFBRSxDQUFDLG9CQUFvQixDQUFDLENBQUM7RUFFMUIsTUFBTSwwQkFBMEIsR0FBRyxJQUFBLGtCQUFXLEVBQUMsTUFBTTtJQUNuRCxvQkFBb0IsQ0FBQyw4QkFBaUIsQ0FBQyxNQUFNLENBQUM7RUFDaEQsQ0FBQyxFQUFFLENBQUMsb0JBQW9CLENBQUMsQ0FBQztFQUUxQixNQUFNLDhCQUE4QixHQUFHLElBQUEsa0JBQVcsRUFBQyxNQUFNO0lBQ3ZELG9CQUFvQixDQUFDLDhCQUFpQixDQUFDLFVBQVUsQ0FBQztFQUNwRCxDQUFDLEVBQUUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO0VBRTFCLE1BQU0sc0JBQXNCLEdBQUcsSUFBQSxrQkFBVyxFQUFDLE1BQU07SUFDL0Msa0JBQWtCLENBQUMsNEJBQWUsQ0FBQyxJQUFJLENBQUM7RUFDMUMsQ0FBQyxFQUFFLENBQUMsa0JBQWtCLENBQUMsQ0FBQztFQUV4QixNQUFNLHVCQUF1QixHQUFHLElBQUEsa0JBQVcsRUFBQyxNQUFNO0lBQ2hELGtCQUFrQixDQUFDLDRCQUFlLENBQUMsS0FBSyxDQUFDO0VBQzNDLENBQUMsRUFBRSxDQUFDLGtCQUFrQixDQUFDLENBQUM7RUFFeEIsTUFBTSxxQkFBcUIsR0FBRyxJQUFBLGtCQUFXLEVBQUMsTUFBTTtJQUM5QyxVQUFVLENBQ1I7TUFDRSxLQUFLLEVBQUUsaUNBQW9CLENBQUMsa0JBQWtCO01BQzlDLFFBQVEsRUFBRSxxQ0FBd0IsQ0FBQyxJQUFJO01BQ3ZDLFVBQVUsRUFBRTtRQUNWO1FBQ0EsWUFBWSxFQUFFLFdBQVc7UUFDekI7UUFDQSxZQUFZLEVBQUUsaUJBQWlCO1FBQy9CO1FBQ0EsVUFBVSxFQUFFLGVBQWU7UUFDM0I7UUFDQSxRQUFRLEVBQUUsYUFBYSxHQUFHLE9BQU8sR0FBRyxTQUFTO1FBQzdDO1FBQ0EsYUFBYSxFQUFFLGFBQWEsR0FBRyxTQUFTLEdBQUc7TUFDN0M7SUFDRixDQUFDLEVBQ0Q7TUFDRSxvQkFBb0IsRUFBRTtJQUN4QixDQUNGLENBQUM7RUFDSCxDQUFDLEVBQUUsQ0FDRCxXQUFXLEVBQ1gsaUJBQWlCLEVBQ2pCLGVBQWUsRUFDZixPQUFPLEVBQ1AsYUFBYSxFQUNiLFVBQVUsQ0FDWCxDQUFDO0VBRUYsT0FBTztJQUNMLHFCQUFxQjtJQUNyQiwwQkFBMEI7SUFDMUIsMEJBQTBCO0lBQzFCLDhCQUE4QjtJQUM5QixzQkFBc0I7SUFDdEI7RUFDRixDQUFDO0FBQ0gsQ0FBQztBQUFDLE9BQUEsQ0FBQSx5QkFBQSxHQUFBLHlCQUFBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ3JGRixJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUVBLElBQUEsWUFBQSxHQUFBLE9BQUE7QUFJQSxJQUFBLGFBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxZQUFBLEdBQUEsT0FBQTtBQUtBLElBQUEsY0FBQSxHQUFBLE9BQUE7QUFkQTs7QUFnQkEsTUFBTSxVQUFVLEdBQUc7RUFDakIsR0FBRyxFQUFFLEtBQUs7RUFDVixNQUFNLEVBQUUsUUFBUTtFQUNoQixLQUFLLEVBQUU7QUFDVCxDQUFDO0FBRU0sTUFBTSx3QkFBd0IsR0FBRyxDQUFBLEtBQU07RUFDNUMsTUFBTSxVQUFVLEdBQUcsSUFBQSxpQkFBVSxFQUFDLGdDQUFrQixDQUFDO0VBQ2pELE1BQU07SUFBRSxNQUFNO0lBQUU7RUFBSyxDQUFDLEdBQUcsSUFBQSw0QkFBYSxFQUFDLENBQUM7RUFDeEMsTUFBTTtJQUNKLFdBQVc7SUFDWCxpQkFBaUI7SUFDakIsYUFBYTtJQUNiLG9CQUFvQjtJQUNwQjtFQUNGLENBQUMsR0FBRyxJQUFBLGtDQUFxQixFQUFDLENBQUM7RUFFM0IsTUFBTSxvQkFBb0IsR0FBRyxJQUFBLGtCQUFXLEVBQ3JDLFlBQW9CLElBQUs7SUFDeEIsTUFBTSxPQUFPLEdBQUcsSUFBSSxHQUFHLENBQUMsQ0FBQyxHQUFHLGlCQUFpQixFQUFFLFlBQVksQ0FBQyxDQUFDO0lBQzdELE1BQU0sWUFBWSxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLENBQUMsTUFBTSxDQUM1QyxNQUFNLElBQUssTUFBTSxLQUFLLDhCQUFpQixDQUFDLElBQzNDLENBQUM7SUFDRCxvQkFBb0IsQ0FBQyxZQUFZLENBQUM7RUFDcEMsQ0FBQyxFQUNELENBQUMsb0JBQW9CLEVBQUUsaUJBQWlCLENBQzFDLENBQUM7RUFFRCxNQUFNLHVCQUF1QixHQUFHLElBQUEsa0JBQVcsRUFDeEMsWUFBb0IsSUFBSztJQUN4QixNQUFNLFlBQVksR0FBRyxpQkFBaUIsQ0FBQyxNQUFNLENBQzFDLE1BQU0sSUFBSyxNQUFNLEtBQUssWUFDekIsQ0FBQztJQUVELElBQUksWUFBWSxDQUFDLE1BQU0sS0FBSyxDQUFDLEVBQUU7TUFDN0IsWUFBWSxDQUFDLElBQUksQ0FBQyw4QkFBaUIsQ0FBQyxJQUFJLENBQUM7SUFDM0M7SUFFQSxvQkFBb0IsQ0FBQyxZQUFZLENBQUM7RUFDcEMsQ0FBQyxFQUNELENBQUMsb0JBQW9CLEVBQUUsaUJBQWlCLENBQzFDLENBQUM7RUFFRCxNQUFNLG9CQUFvQixHQUFHLElBQUEsa0JBQVcsRUFDckMsU0FBZ0IsSUFBSztJQUNwQixJQUFJLFNBQVMsR0FBRyxVQUFVLENBQUMsS0FBSztJQUNoQyxJQUFJLFNBQVMsYUFBVCxTQUFTLGVBQVQsU0FBUyxDQUFFLE9BQU8sRUFBRTtNQUN0QixTQUFTLEdBQUcsVUFBVSxDQUFDLEdBQUc7SUFDNUIsQ0FBQyxNQUFNLElBQUksVUFBVSxJQUFJLFNBQVMsSUFBSSxTQUFTLGFBQVQsU0FBUyxlQUFULFNBQVMsQ0FBRSxRQUFRLEVBQUU7TUFDekQsU0FBUyxHQUFHLFVBQVUsQ0FBQyxNQUFNO0lBQy9CO0lBRUEsTUFBTSxZQUFZLEdBQUcsQ0FBQSxTQUFTLGFBQVQsU0FBUyx1QkFBVCxTQUFTLENBQUUsT0FBTyxNQUFJLFNBQVMsYUFBVCxTQUFTLHVCQUFULFNBQVMsQ0FBRSxPQUFPO0lBQzdELE1BQU0sU0FBUyxHQUFHLElBQUEsZ0JBQVksRUFBQyxZQUFzQixDQUFDO0lBRXRELE1BQU0sU0FBUyxHQUFHLENBQUMsR0FBRyxNQUFNLEVBQUUsR0FBRyxJQUFJLENBQUM7SUFDdEMsTUFBTSxRQUFRLEdBQ1osU0FBUyxDQUFDLFNBQVMsQ0FBRSxLQUFLLElBQUs7TUFDN0IsSUFBSSxTQUFTLENBQUMsT0FBTyxFQUFFO1FBQ3JCO1FBQ0EsT0FDRSxLQUFLLENBQUMsT0FBTyxLQUFLLFNBQVMsQ0FBQyxPQUFPLElBQ25DLEtBQUssQ0FBQyxPQUFPLEtBQUssU0FBUyxDQUFDLE9BQU8sSUFDbkMsS0FBSyxDQUFDLE9BQU8sS0FBSyxTQUFTLENBQUMsT0FBTztNQUV2QyxDQUFDLE1BQU0sSUFBSSxTQUFTLENBQUMsUUFBUSxFQUFFO1FBQzdCO1FBQ0EsT0FDRSxLQUFLLENBQUMsUUFBUSxLQUFLLFNBQVMsQ0FBQyxRQUFRLElBQ3JDLEtBQUssQ0FBQyxPQUFPLEtBQUssU0FBUyxDQUFDLE9BQU87TUFFdkM7TUFDQTtNQUNBLE9BQ0UsS0FBSyxDQUFDLE9BQU8sS0FBSyxTQUFTLENBQUMsT0FBTyxJQUNuQyxLQUFLLENBQUMsT0FBTyxLQUFLLFNBQVMsQ0FBQyxPQUFPO0lBRXZDLENBQUMsQ0FBQyxHQUFHLENBQUM7SUFFUixVQUFVLENBQ1I7TUFDRSxLQUFLLEVBQUUsaUNBQW9CLENBQUMsaUJBQWlCO01BQzdDLFFBQVEsRUFBRSxxQ0FBd0IsQ0FBQyxJQUFJO01BQ3ZDLFVBQVUsRUFBRTtRQUNWLFlBQVksRUFBRSxXQUFXO1FBQ3pCLFVBQVUsRUFBRSxTQUFTO1FBQ3JCLG1CQUFtQixFQUFFLFFBQVE7UUFDN0IsZUFBZSxFQUFFLGFBQWE7UUFDOUIsUUFBUSxFQUFFLFNBQVMsYUFBVCxTQUFTLHVCQUFULFNBQVMsQ0FBRSxPQUFPO1FBQzVCLGFBQWEsRUFBRSxTQUFTLEdBQ3BCLFVBQVUsUUFBUSxDQUFDLFNBQVMsYUFBVCxTQUFTLHVCQUFULFNBQVMsQ0FBRSxPQUFPLEVBQVksRUFBRSxDQUFDLEVBQUUsR0FDdEQsU0FBUyxhQUFULFNBQVMsdUJBQVQsU0FBUyxDQUFFLE9BQU87UUFDdEIsYUFBYSxFQUFFO01BQ2pCO0lBQ0YsQ0FBQyxFQUNEO01BQ0Usb0JBQW9CLEVBQUU7SUFDeEIsQ0FDRixDQUFDO0VBQ0gsQ0FBQyxFQUNELENBQUMsV0FBVyxFQUFFLGlCQUFpQixFQUFFLGFBQWEsRUFBRSxVQUFVLEVBQUUsTUFBTSxFQUFFLElBQUksQ0FDMUUsQ0FBQztFQUVELE9BQU87SUFDTCxvQkFBb0I7SUFDcEIsb0JBQW9CO0lBQ3BCLHVCQUF1QjtJQUN2QjtFQUNGLENBQUM7QUFDSCxDQUFDO0FBQUMsT0FBQSxDQUFBLHdCQUFBLEdBQUEsd0JBQUE7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDNUhGLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFFQSxJQUFBLFlBQUEsR0FBQSxPQUFBO0FBSUEsSUFBQSxhQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsWUFBQSxHQUFBLE9BQUE7QUFJQSxJQUFBLEtBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxZQUFBLEdBQUEsT0FBQTtBQWJBOztBQWVPLE1BQU0sNEJBQTRCLEdBQUcsQ0FBQSxLQUFNO0VBQ2hELE1BQU0sVUFBVSxHQUFHLElBQUEsaUJBQVUsRUFBQyxnQ0FBa0IsQ0FBQztFQUNqRCxNQUFNO0lBQUU7RUFBUSxDQUFDLEdBQUcsSUFBQSxvQkFBYyxFQUFDLENBQUM7RUFDcEMsTUFBTTtJQUFFO0VBQWMsQ0FBQyxHQUFHLElBQUEsd0JBQVcsRUFBQyxDQUFDO0VBQ3ZDLE1BQU07SUFBRSxXQUFXO0lBQUUsb0JBQW9CO0lBQUU7RUFBd0IsQ0FBQyxHQUNsRSxJQUFBLGtDQUFxQixFQUFDLENBQUM7RUFFekIsTUFBTSw2QkFBNkIsR0FBRyxJQUFBLGtCQUFXLEVBQUMsTUFBTTtJQUN0RCx1QkFBdUIsQ0FBQyxpQ0FBb0IsQ0FBQyxNQUFNLENBQUM7RUFDdEQsQ0FBQyxFQUFFLENBQUMsdUJBQXVCLENBQUMsQ0FBQztFQUU3QixNQUFNLDZCQUE2QixHQUFHLElBQUEsa0JBQVcsRUFBQyxNQUFNO0lBQ3RELHVCQUF1QixDQUFDLGlDQUFvQixDQUFDLE1BQU0sQ0FBQztFQUN0RCxDQUFDLEVBQUUsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDO0VBRTdCLE1BQU0sb0NBQW9DLEdBQUcsSUFBQSxrQkFBVyxFQUFDLE1BQU07SUFDN0QsdUJBQXVCLENBQUMsaUNBQW9CLENBQUMsYUFBYSxDQUFDO0VBQzdELENBQUMsRUFBRSxDQUFDLHVCQUF1QixDQUFDLENBQUM7RUFFN0IsTUFBTSxvQ0FBb0MsR0FBRyxJQUFBLGtCQUFXLEVBQUMsTUFBTTtJQUM3RCx1QkFBdUIsQ0FBQyxpQ0FBb0IsQ0FBQyxhQUFhLENBQUM7RUFDN0QsQ0FBQyxFQUFFLENBQUMsdUJBQXVCLENBQUMsQ0FBQztFQUU3QixNQUFNLHdCQUF3QixHQUFHLElBQUEsa0JBQVcsRUFBQyxZQUFZO0lBQ3ZELFVBQVUsQ0FDUjtNQUNFLEtBQUssRUFBRSxpQ0FBb0IsQ0FBQyxxQkFBcUI7TUFDakQsUUFBUSxFQUFFLHFDQUF3QixDQUFDLElBQUk7TUFDdkMsVUFBVSxFQUFFO1FBQ1YsWUFBWSxFQUFFLFdBQVc7UUFDekIsWUFBWSxFQUFFLG9CQUFvQjtRQUNsQyxRQUFRLEVBQUUsT0FBTztRQUNqQixhQUFhLEVBQUUsYUFBYSxHQUN4QixVQUFVLFFBQVEsQ0FBQyxPQUFPLEVBQVksRUFBRSxDQUFDLEVBQUUsR0FDM0M7TUFDTjtJQUNGLENBQUMsRUFDRDtNQUNFLG9CQUFvQixFQUFFO0lBQ3hCLENBQ0YsQ0FBQztFQUNILENBQUMsRUFBRSxDQUFDLFdBQVcsRUFBRSxPQUFPLEVBQUUsYUFBYSxFQUFFLG9CQUFvQixFQUFFLFVBQVUsQ0FBQyxDQUFDO0VBRTNFLE9BQU87SUFDTCx3QkFBd0I7SUFDeEIsNkJBQTZCO0lBQzdCLDZCQUE2QjtJQUM3QixvQ0FBb0M7SUFDcEM7RUFDRixDQUFDO0FBQ0gsQ0FBQztBQUFDLE9BQUEsQ0FBQSw0QkFBQSxHQUFBLDRCQUFBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ2pFRixJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxXQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsWUFBQSxHQUFBLE9BQUE7QUFFTyxNQUFNLDRCQUE0QixHQUFHLENBQUEsS0FBTTtFQUNoRCxNQUFNLDBCQUEwQixHQUFHLElBQUEsdUJBQVcsRUFDNUMsZ0RBQ0YsQ0FBQztFQUVELE1BQU0seUJBQXlCLEdBQUcsSUFBQSxjQUFPLEVBQUMsTUFBTTtJQUM5QyxNQUFNLEdBQUcsR0FBRyxJQUFJLEdBQUcsQ0FBaUIsQ0FBQztJQUVyQywwQkFBMEIsQ0FBQyxPQUFPLENBQUUsWUFBWSxJQUFLO01BQ25ELE1BQU07UUFBRTtNQUFTLENBQUMsR0FBRyxZQUFZO01BRWpDLElBQUksUUFBUSxDQUFDLE1BQU0sS0FBSyxDQUFDLEVBQUU7UUFDekI7TUFDRjtNQUVBLE1BQU0sV0FBVyxHQUFHLFFBQVEsQ0FBQyxDQUFDLENBQUMsQ0FBQyxPQUFPO01BRXZDLFFBQVEsQ0FBQyxPQUFPLENBQUUsT0FBTyxJQUFLO1FBQzVCLEdBQUcsQ0FBQyxHQUFHLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxXQUFXLENBQUMsQ0FBQyxFQUFFLFdBQVcsQ0FBQztNQUNyRCxDQUFDLENBQUM7SUFDSixDQUFDLENBQUM7SUFFRixPQUFPLEdBQUc7RUFDWixDQUFDLEVBQUUsQ0FBQywwQkFBMEIsQ0FBQyxDQUFDO0VBRWhDLE9BQU87SUFBRTtFQUEwQixDQUFDO0FBQ3RDLENBQUM7QUFBQyxPQUFBLENBQUEsNEJBQUEsR0FBQSw0QkFBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUM5QkYsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsV0FBQSxHQUFBLE9BQUE7QUFFQSxJQUFBLFlBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxRQUFBLEdBQUEsT0FBQTtBQUtBLElBQUEsS0FBQSxHQUFBLE9BQUE7QUFFQSxJQUFBLFlBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSw2QkFBQSxHQUFBLE9BQUE7QUFFTyxNQUFNLG9CQUFvQixHQUFHLENBQUEsS0FBbUI7RUFDckQsTUFBTTtJQUFFLGFBQWE7SUFBRSxnQkFBZ0I7SUFBRTtFQUFrQixDQUFDLEdBQUcsSUFBQSx3QkFBVyxFQUFDLENBQUM7RUFDNUUsTUFBTTtJQUFFO0VBQUssQ0FBQyxHQUFHLElBQUEsb0JBQWMsRUFBQyxDQUFDO0VBQ2pDLE1BQU07SUFBRTtFQUEwQixDQUFDLEdBQUcsSUFBQSwwREFBNEIsRUFBQyxDQUFDO0VBRXBFLE1BQU0sbUJBQW1CLEdBQUcsSUFBQSx1QkFBVyxFQUFDLG1DQUFzQixDQUFDO0VBRS9ELE9BQU8sSUFBQSxjQUFPLEVBQUMsTUFBTTtJQUNuQixNQUFNLFVBQXVCLEdBQUcsRUFBRTtJQUVsQyxNQUFNLENBQUMsTUFBTSxDQUFDLG1CQUFtQixDQUFDLENBQUMsT0FBTyxDQUFFLE1BQU0sSUFBSztNQUFBLElBQUEsZ0JBQUE7TUFDckQsTUFBTSxVQUFVLElBQUEsZ0JBQUEsR0FBRyxNQUFNLENBQUMsUUFBUSxjQUFBLGdCQUFBLHVCQUFmLGdCQUFBLENBQWlCLElBQUk7TUFFeEMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDLENBQUMsT0FBTyxDQUFFLEtBQUssSUFBSztRQUFBLElBQUEsZUFBQTtRQUM5QyxNQUFNLGdCQUFnQixJQUFBLGVBQUEsR0FBRyxLQUFLLENBQUMsUUFBUSxjQUFBLGVBQUEsdUJBQWQsZUFBQSxDQUFnQixJQUFJO1FBRTdDLEtBQUssQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFFLE9BQU8sSUFBSztVQUNsQyxJQUFJLE9BQU8sQ0FBQyxPQUFPLEtBQUssSUFBSSxFQUFFO1lBQzVCO1VBQ0Y7VUFFQSxNQUFNLGFBQWEsR0FDaEIsYUFBYSxJQUFJLElBQUEsNEJBQW1CLEVBQUMsT0FBTyxDQUFDLElBQzdDLGdCQUFnQixJQUFJLElBQUEsK0JBQXNCLEVBQUMsT0FBTyxDQUFFLElBQ3BELGlCQUFpQixJQUFJLElBQUEsZ0NBQXVCLEVBQUMsT0FBTyxDQUFFO1VBRXpELElBQUksYUFBYSxFQUFFO1lBQ2pCLFVBQVUsQ0FBQyxJQUFJLENBQUM7Y0FDZCxRQUFRLEVBQUUseUJBQXlCLENBQUMsR0FBRyxDQUNyQyxPQUFPLENBQUMsT0FBTyxDQUFDLFdBQVcsQ0FBQyxDQUM5QixDQUFDO2NBQ0QsZ0JBQWdCO2NBQ2hCLE9BQU8sRUFBRSxPQUFPLENBQUMsT0FBTztjQUN4QjtZQUNGLENBQUMsQ0FBQztVQUNKO1FBQ0YsQ0FBQyxDQUFDO01BQ0osQ0FBQyxDQUFDO0lBQ0osQ0FBQyxDQUFDO0lBRUYsT0FBTyxVQUFVO0VBQ25CLENBQUMsRUFBRSxDQUNELElBQUksRUFDSixhQUFhLEVBQ2IsZ0JBQWdCLEVBQ2hCLGlCQUFpQixFQUNqQix5QkFBeUIsRUFDekIsbUJBQW1CLENBQ3BCLENBQUM7QUFDSixDQUFDO0FBQUMsT0FBQSxDQUFBLG9CQUFBLEdBQUEsb0JBQUE7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDL0RGLElBQUEsZ0JBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUdBLElBQUEsZUFBQSxHQUFBLE9BQUE7QUFFQSxJQUFBLEtBQUEsR0FBQSxPQUFBO0FBSUEsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsV0FBQSxHQUFBLE9BQUE7QUFFTyxNQUFNLHNCQUFzQixHQUFHLENBQ3BDLEtBQVksRUFDWixLQUF5QixFQUN6QixDQUFvQyxLQUNqQztFQUNILElBQUksS0FBSyxhQUFMLEtBQUssZUFBTCxLQUFLLENBQUUsT0FBTyxJQUFJLEtBQUssRUFBRTtJQUMzQixJQUFJLFFBQVEsQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLEdBQUcsUUFBUSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsUUFBUSxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsRUFBRTtNQUNoRSxPQUFPLENBQUMsQ0FBQyx1QkFBdUIsQ0FBQztJQUNuQztFQUNGO0VBQ0EsT0FBTyxTQUFTO0FBQ2xCLENBQUM7QUFBQyxPQUFBLENBQUEsc0JBQUEsR0FBQSxzQkFBQTtBQUVLLE1BQU0sb0JBQW9CLEdBQUcsQ0FDbEMsTUFBYyxFQUNkLGlCQUEwQixFQUMxQixDQUFvQyxFQUNwQyxRQUFpQixLQUNkO0VBQ0gsTUFBTSxrQkFBa0IsR0FBRyxJQUFBLDhCQUF3QixFQUFDLE1BQU0sRUFBRSxFQUFFLEVBQUUsUUFBUSxDQUFDO0VBQ3pFLElBQUksaUJBQWlCLENBQUMsUUFBUSxDQUFDLGtCQUFrQixDQUFDLEVBQUU7SUFDbEQsT0FBTyxDQUFDLENBQUMsdUJBQXVCLENBQUM7RUFDbkM7RUFDQSxPQUFPLFNBQVM7QUFDbEIsQ0FBQztBQUFDLE9BQUEsQ0FBQSxvQkFBQSxHQUFBLG9CQUFBO0FBRUssTUFBTSxtQkFBbUIsR0FBRyxDQUFBLEtBQU07RUFDdkMsTUFBTSxDQUFDLEdBQUcsSUFBQSw4QkFBYyxFQUFDLENBQUM7RUFDMUIsTUFBTTtJQUFFLEtBQUs7SUFBRTtFQUFNLENBQUMsR0FBRyxJQUFBLHFCQUFjLEVBQUMsQ0FBQztFQUN6QyxNQUFNO0lBQUU7RUFBa0IsQ0FBQyxHQUFHLElBQUEsc0JBQVUsRUFBQyxDQUFDO0VBRTFDLE1BQU0sV0FBVyxHQUFHLElBQUEsY0FBTyxFQUFDLE1BQU07SUFDaEMsSUFBSSxLQUFLLEtBQUssU0FBUyxJQUFJLEtBQUssS0FBSyxJQUFJLElBQUksS0FBSyxLQUFLLEVBQUUsRUFBRTtNQUN6RCxPQUFPLFNBQVM7SUFDbEI7SUFDQSxJQUFJLENBQUMsSUFBQSxrQ0FBNEIsRUFBQyxLQUFLLENBQUMsRUFBRTtNQUN4QyxPQUFPLENBQUMsQ0FBQyxjQUFjLENBQUM7SUFDMUI7SUFDQSxJQUFJLENBQUEsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLFFBQVEsTUFBSyx3QkFBTyxFQUFFO01BQy9CLE9BQU8sc0JBQXNCLENBQUMsS0FBSyxFQUFFLEtBQUssRUFBRSxDQUFDLENBQUM7SUFDaEQ7SUFDQSxPQUFPLG9CQUFvQixDQUFDLEtBQUssRUFBRSxpQkFBaUIsRUFBRSxDQUFDLEVBQUUsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLFFBQVEsQ0FBQztFQUMzRSxDQUFDLEVBQUUsQ0FBQyxLQUFLLEVBQUUsaUJBQWlCLEVBQUUsQ0FBQyxFQUFFLEtBQUssQ0FBQyxDQUFDO0VBRXhDLE9BQU87SUFBRTtFQUFZLENBQUM7QUFDeEIsQ0FBQztBQUFDLE9BQUEsQ0FBQSxtQkFBQSxHQUFBLG1CQUFBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQzFERixJQUFBLGdCQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFFQSxJQUFBLFFBQUEsR0FBQSxPQUFBO0FBRUEsSUFBQSxLQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFFQSxNQUFNLFVBQVUsR0FBSSxLQUFhLElBQUs7RUFDcEMsSUFBSSxDQUFDLEtBQUssRUFBRTtJQUNWLE9BQU87TUFDTCxPQUFPLEVBQUUsR0FBRztNQUNaLFFBQVEsRUFBRSxDQUFDO01BQ1gsaUJBQWlCLEVBQUUsSUFBSSxnQkFBTyxDQUFDLEdBQUcsRUFBRSxFQUFFO0lBQ3hDLENBQUM7RUFDSDtFQUVBLE1BQU0sYUFBYSxHQUFHLENBQUEsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLFVBQVUsS0FBSSxLQUFLO0VBRWhELE9BQU87SUFDTCxPQUFPLEVBQUUsSUFBQSwyQkFBcUIsRUFDNUIsSUFBQSx3QkFBa0IsRUFBQyxhQUFhLEVBQUUsS0FBSyxDQUFDLFFBQVEsQ0FBQyxFQUNqRCxLQUFLLENBQUMsUUFDUixDQUFDO0lBQ0QsUUFBUSxFQUFFLEtBQUssQ0FBQyxRQUFRO0lBQ3hCLGlCQUFpQixFQUFFLElBQUksZ0JBQU8sQ0FBQyxhQUFhLEVBQUUsRUFBRSxDQUFDLENBQUMsTUFBTSxDQUFDLEVBQUU7RUFDN0QsQ0FBQztBQUNILENBQUM7QUFFTSxNQUFNLFVBQVUsR0FBRyxDQUFBLEtBQU07RUFDOUIsTUFBTTtJQUFFO0VBQU0sQ0FBQyxHQUFHLElBQUEscUJBQWMsRUFBQyxDQUFDO0VBRWxDLE1BQU07SUFBRSxPQUFPO0lBQUUsUUFBUTtJQUFFO0VBQWtCLENBQUMsR0FBRyxJQUFBLGNBQU8sRUFBQyxNQUFNO0lBQzdELElBQUksQ0FBQSxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsUUFBUSxNQUFLLHdCQUFPLEVBQUU7TUFDL0IsTUFBTSxHQUFHLEdBQUcsQ0FBQSxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsT0FBTyxLQUFJLEdBQUc7TUFDakMsT0FBTztRQUNMLE9BQU8sRUFBRSxHQUFHO1FBQ1osUUFBUSxFQUFFLENBQUM7UUFDWCxpQkFBaUIsRUFBRSxJQUFJLGdCQUFPLENBQUMsR0FBRyxFQUFFLEVBQUU7TUFDeEMsQ0FBQztJQUNIO0lBQ0EsT0FBTyxVQUFVLENBQUMsS0FBSyxDQUFDO0VBQzFCLENBQUMsRUFBRSxDQUFDLEtBQUssQ0FBQyxDQUFDO0VBRVgsT0FBTztJQUNMLE9BQU87SUFDUCxRQUFRO0lBQ1I7RUFDRixDQUFDO0FBQ0gsQ0FBQztBQUFDLE9BQUEsQ0FBQSxVQUFBLEdBQUEsVUFBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNqREYsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsV0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBR0EsSUFBQSxVQUFBLEdBQUEsT0FBQTtBQUVBLElBQUEsWUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLDZCQUFBLEdBQUEsT0FBQTtBQUVPLE1BQU0sb0JBQW9CLEdBQUcsQ0FBQSxLQUFtQjtFQUNyRCxNQUFNO0lBQUU7RUFBYyxDQUFDLEdBQUcsSUFBQSx3QkFBVyxFQUFDLENBQUM7RUFDdkMsTUFBTSxXQUFXLEdBQUcsSUFBQSx1QkFBVyxFQUFDLGlDQUFzQixDQUFDO0VBQ3ZELE1BQU07SUFBRTtFQUEwQixDQUFDLEdBQUcsSUFBQSwwREFBNEIsRUFBQyxDQUFDO0VBRXBFLE1BQU0sZUFBZSxHQUFHLElBQUEsa0JBQVcsRUFDaEMsT0FBeUIsSUFBSztJQUM3QixPQUFPO01BQ0wsT0FBTyxFQUFFLE9BQU8sQ0FBQyxPQUFPO01BQ3hCLFdBQVcsRUFBRSxPQUFPLENBQUMsSUFBSTtNQUN6QixTQUFTLEVBQUUsSUFBSTtNQUNmLFFBQVEsRUFBRSx5QkFBeUIsQ0FBQyxHQUFHLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxXQUFXLENBQUMsQ0FBQztJQUN2RSxDQUFDO0VBQ0gsQ0FBQyxFQUNELENBQUMseUJBQXlCLENBQzVCLENBQUM7O0VBRUQ7RUFDQSxJQUFJLGFBQWEsRUFBRTtJQUNqQixPQUFPLFdBQVcsQ0FDZixNQUFNLENBQUUsT0FBTyxJQUFLLElBQUEsZ0JBQVksRUFBQyxPQUFPLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FDbEQsR0FBRyxDQUFDLGVBQWUsQ0FBQztFQUN6QjtFQUVBLE9BQU8sRUFBRTtBQUNYLENBQUM7QUFBQyxPQUFBLENBQUEsb0JBQUEsR0FBQSxvQkFBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNsQ0YsSUFBQSxnQkFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxXQUFBLEdBQUEsT0FBQTtBQUVBLElBQUEsVUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE9BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxXQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsc0JBQUEsR0FBQSxPQUFBO0FBRUEsSUFBQSxLQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFTQSxNQUFNLGNBQWMsR0FBRyxDQUFDO0VBQUUsTUFBTTtFQUFFO0FBQStCLENBQUMsS0FBSztFQUNyRSxJQUFJLENBQUMsTUFBTSxFQUFFO0lBQ1gsT0FBTyxHQUFHO0VBQ1o7RUFDQSxPQUFPLElBQUEsdUJBQWlCLEVBQUMsTUFBTSxFQUFFLGNBQWMsRUFBRSxDQUFDLENBQUMsSUFBSSxHQUFHO0FBQzVELENBQUM7QUFFRCxNQUFNLHFCQUFxQixHQUFHLENBQUM7RUFDN0IsTUFBTTtFQUNOLGNBQWM7RUFDZDtBQUNjLENBQUMsS0FBSztFQUNwQixJQUFJLENBQUMsTUFBTSxFQUFFO0lBQ1gsT0FBTyxHQUFHLElBQUEseUJBQWlCLEVBQUMsZUFBZSxDQUFDLE9BQU87RUFDckQ7RUFDQSxNQUFNLEdBQUcsR0FBRyxNQUFNLEdBQ2QsSUFBQSwyQkFBcUIsRUFDbkIsY0FBYyxDQUFDO0lBQUUsTUFBTTtJQUFFO0VBQWUsQ0FBQyxDQUFDLEVBQzFDLENBQUMsRUFDRCxLQUNGLENBQUMsR0FDRCxNQUFNO0VBQ1YsT0FBTyxHQUFHLElBQUEseUJBQWlCLEVBQUMsZUFBZSxDQUFDLElBQUksR0FBRyxFQUFFO0FBQ3ZELENBQUM7QUFFRCxNQUFNLGdCQUFnQixHQUFHLENBQUM7RUFDeEIsS0FBSztFQUNMLE1BQU07RUFDTjtBQUNjLENBQUMsS0FBSztFQUNwQixJQUFJLENBQUMsTUFBTSxFQUFFO0lBQ1gsT0FBTyxHQUFHO0VBQ1o7RUFDQSxPQUNFLElBQUEsdUJBQWlCLEVBQ2YsTUFBTSxFQUNOLGNBQWMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxHQUFHLENBQUMsR0FBRyxjQUFjLEVBQzdDLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxRQUNULENBQUMsSUFBSSxHQUFHO0FBRVosQ0FBQztBQUVNLE1BQU0sc0JBQXNCLEdBQUcsQ0FBQSxLQUFNO0VBQzFDLE1BQU07SUFBRSxLQUFLO0lBQUU7RUFBWSxDQUFDLEdBQUcsSUFBQSxxQkFBYyxFQUFDLENBQUM7RUFDL0MsTUFBTSxlQUFlLEdBQUcsSUFBQSw0Q0FBcUIsRUFDM0Msd0NBQTRCLEVBQzVCLFdBQ0YsQ0FBQztFQUVELE1BQU0scUJBQXFCLEdBQUcsSUFBQSx1QkFBVyxFQUN2QywwQ0FDRixDQUFxQztFQUVyQyxNQUFNLFlBQVksR0FBRyxJQUFBLGNBQU8sRUFBQyxNQUFNO0lBQUEsSUFBQSxtQkFBQTtJQUNqQyxJQUFJLENBQUMsS0FBSyxFQUFFO01BQ1YsT0FBTyxDQUFDO0lBQ1Y7SUFDQSxPQUNFLEVBQUEsbUJBQUEsR0FDRSxNQUFNLENBQUMsTUFBTSxDQUFDLHFCQUFxQixDQUFDLENBQUMsSUFBSSxDQUN0QyxJQUFJLElBQUssSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQVEsS0FBSyxTQUMzQyxDQUFDLGNBQUEsbUJBQUEsdUJBSEgsbUJBQUEsQ0FJSSxLQUFLLENBQUMsT0FBTyxDQUFRLEtBQUksQ0FBQztFQUVsQyxDQUFDLEVBQUUsQ0FBQyxLQUFLLEVBQUUscUJBQXFCLENBQUMsQ0FBQztFQUVsQyxNQUFNLGNBQWMsR0FBRyxJQUFBLGNBQU8sRUFBQyxNQUFNO0lBQUEsSUFBQSxLQUFBO0lBQ25DLE1BQU0sWUFBWSxHQUFHLENBQUEsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLE9BQU8sTUFBSSxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsT0FBTztJQUNyRCxJQUNFLENBQUMsS0FBSyxJQUNOLENBQUMsWUFBWSxJQUNiLEtBQUssQ0FBQyxRQUFRLEtBQUssd0JBQU8sSUFDMUIsS0FBSyxDQUFDLFFBQVEsS0FBSyx1QkFBTSxFQUN6QjtNQUNBLE9BQU8sQ0FBQztJQUNWO0lBQ0EsT0FBTyxDQUFDLENBQUMsS0FBSyxhQUFMLEtBQUssZ0JBQUEsS0FBQSxHQUFMLEtBQUssQ0FBWSxJQUFJLGNBQUEsS0FBQSx1QkFBdEIsS0FBQSxDQUF3QixjQUFjLEtBQUksQ0FBQyxJQUFJLFlBQVk7RUFDckUsQ0FBQyxFQUFFLENBQUMsS0FBSyxFQUFFLFlBQVksQ0FBQyxDQUFDO0VBRXpCLE1BQU0sWUFBWSxHQUFHLElBQUEsa0JBQVcsRUFDN0IsTUFBYyxJQUNiLGNBQWMsQ0FBQztJQUNiLE1BQU07SUFDTjtFQUNGLENBQUMsQ0FBQyxFQUNKLENBQUMsY0FBYyxDQUNqQixDQUFDO0VBRUQsTUFBTSxtQkFBbUIsR0FBRyxJQUFBLGtCQUFXLEVBQ3BDLE1BQWMsSUFDYixxQkFBcUIsQ0FBQztJQUNwQixNQUFNO0lBQ04sY0FBYztJQUNkO0VBQ0YsQ0FBQyxDQUFDLEVBQ0osQ0FBQyxjQUFjLEVBQUUsZUFBZSxDQUNsQyxDQUFDO0VBRUQsTUFBTSxjQUFjLEdBQUcsSUFBQSxrQkFBVyxFQUMvQixNQUFjLElBQ2IsZ0JBQWdCLENBQUM7SUFDZixLQUFLO0lBQ0wsTUFBTTtJQUNOO0VBQ0YsQ0FBQyxDQUFDLEVBQ0osQ0FBQyxLQUFLLEVBQUUsY0FBYyxDQUN4QixDQUFDO0VBRUQsT0FBTztJQUNMLDJCQUEyQixFQUN6QixjQUFjLEtBQUssQ0FBQyxJQUNwQixDQUFBLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxRQUFRLE1BQUssd0JBQU8sSUFDM0IsQ0FBQSxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsUUFBUSxNQUFLLHVCQUFNO0lBQzVCLGtCQUFrQixFQUFFLElBQUEseUJBQWlCLEVBQUMsZUFBZSxDQUFDO0lBQ3RELGdCQUFnQixFQUFFLGVBQWU7SUFDakMsWUFBWTtJQUNaLG1CQUFtQjtJQUNuQjtFQUNGLENBQUM7QUFDSCxDQUFDO0FBQUMsT0FBQSxDQUFBLHNCQUFBLEdBQUEsc0JBQUE7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDM0lGLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFFQSxJQUFBLFFBQUEsR0FBQSxPQUFBO0FBSUEsSUFBQSxLQUFBLEdBQUEsT0FBQTtBQUVPLE1BQU0sd0JBQXdCLEdBQUcsQ0FBQSxLQUFNO0VBQzVDLE1BQU0sa0JBQWtCLEdBQUcsSUFBQSxrQkFBVyxFQUFDLE1BQU8sR0FBVSxJQUFLO0lBQzNELElBQUksR0FBRyxDQUFDLFFBQVEsS0FBSyxtQkFBYSxDQUFDLE9BQU8sRUFBRTtNQUMxQyxPQUFPLElBQUk7SUFDYjtJQUVBLElBQUk7TUFDRixNQUFNLGVBQWUsR0FBRyxNQUFNLElBQUEscUNBQTRCLEVBQ3hELEdBQUcsQ0FBQyxPQUNOLENBQUM7TUFFRCxNQUFNLE9BQU8sR0FBRyxNQUFNLElBQUEsNEJBQW1CLEVBQ3ZDLEdBQUcsQ0FBQyxjQUFjLEVBQ2xCLEdBQUcsQ0FBQyxPQUFPLEVBQ1gsR0FBRyxDQUFDLE9BQU8sRUFDWCxlQUNGLENBQUM7TUFFRCxPQUFPO1FBQUUsR0FBRztRQUFFLE9BQU8sRUFBRSxNQUFNLENBQUMsT0FBTztNQUFFLENBQUM7SUFDMUMsQ0FBQyxDQUFDLE9BQU8sS0FBSyxFQUFFO01BQ2QsT0FBTyxDQUFDLEtBQUssQ0FBQyxpQ0FBaUMsRUFBRSxLQUFLLENBQUM7TUFDdkQsT0FBTyxJQUFJO0lBQ2I7RUFDRixDQUFDLEVBQUUsRUFBRSxDQUFDO0VBRU4sT0FBTztJQUFFO0VBQW1CLENBQUM7QUFDL0IsQ0FBQztBQUFDLE9BQUEsQ0FBQSx3QkFBQSxHQUFBLHdCQUFBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ2xDRixJQUFBLHNCQUFBLEdBQUEsT0FBQTtBQUVBLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFdBQUEsR0FBQSxPQUFBO0FBRUEsSUFBQSxRQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsU0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFNBQUEsR0FBQSxPQUFBO0FBRUEsSUFBQSxLQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFdBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxZQUFBLEdBQUEsT0FBQTtBQUVBLE1BQU0seUJBQXlCLEdBQUcsS0FBSztBQUN2QyxNQUFNLDJCQUEyQixHQUFHLEdBQUc7QUFRaEMsTUFBTSxvQkFBb0IsR0FBRyxDQUNsQyxhQUFrQixFQUNsQixlQUFxQyxLQUNsQztFQUNILElBQUksQ0FBQyxlQUFlLEVBQUU7SUFDcEIsT0FBTyxJQUFJLGdCQUFPLENBQUMsR0FBRyxFQUFFLEVBQUUsQ0FBQztFQUM3QjtFQUNBLE1BQU07SUFBRSxNQUFNLEVBQUU7TUFBRTtJQUFzQixDQUFDLEdBQUc7TUFBRSxxQkFBcUIsRUFBRTtJQUFFO0VBQUUsQ0FBQyxHQUN4RSxlQUFlO0VBQ2pCLE1BQU0sUUFBUSxHQUFHLElBQUksZ0JBQU8sQ0FDMUIscUJBQXFCLEdBQUcseUJBQXlCLEVBQ2pELEVBQ0YsQ0FBQztFQUNELE1BQU0sY0FBYyxHQUFHLElBQUksZ0JBQU8sQ0FBQywyQkFBMkIsRUFBRSxFQUFFLENBQUM7RUFDbkUsT0FBTyxRQUFRLENBQUMsS0FBSyxDQUFDLGNBQWMsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxJQUFJLGdCQUFPLENBQUMsYUFBYSxFQUFFLEVBQUUsQ0FBQyxDQUFDO0FBQzNFLENBQUM7QUFBQyxPQUFBLENBQUEsb0JBQUEsR0FBQSxvQkFBQTtBQVVGLE1BQU0sY0FBYyxHQUFHLENBQUM7RUFDdEIsS0FBSztFQUNMLGFBQWE7RUFDYixlQUFlO0VBQ2YsbUJBQW1CO0VBQ25CO0FBQ2dCLENBQUMsS0FBSztFQUN0QixJQUFJLENBQUMsS0FBSyxFQUFFO0lBQ1YsT0FBTyxHQUFHO0VBQ1o7RUFFQSxJQUFJLGlCQUFpQixHQUFHLElBQUksZ0JBQU8sQ0FBQyxHQUFHLEVBQUUsRUFBRSxDQUFDO0VBRTVDLElBQUksbUJBQW1CLEVBQUU7SUFDdkIsaUJBQWlCLEdBQUcsb0JBQW9CLENBQUMsYUFBYSxFQUFFLGVBQWUsQ0FBQztFQUMxRTtFQUVBLE1BQU0sT0FBTyxHQUFHLGlCQUFpQixDQUFDLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQztFQUUxRCxPQUFPLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQyxJQUFJLE9BQU8sQ0FBQyxVQUFVLENBQUMsQ0FBQyxHQUMzQyxHQUFHLEdBQ0gsSUFBQSx3QkFBa0IsRUFBQyxPQUFPLENBQUMsUUFBUSxDQUFDLENBQUMsRUFBRSxLQUFLLENBQUMsUUFBUSxFQUFFLEVBQUUsQ0FBQztBQUNoRSxDQUFDO0FBRU0sTUFBTSxZQUFZLEdBQUcsQ0FBQSxLQUFNO0VBQ2hDLE1BQU07SUFBRSxLQUFLO0lBQUUsT0FBTztJQUFFLElBQUk7SUFBRTtFQUFNLENBQUMsR0FBRyxJQUFBLHFCQUFjLEVBQUMsQ0FBQztFQUN4RCxNQUFNO0lBQUUsYUFBYTtJQUFFO0VBQW9CLENBQUMsR0FBRyxJQUFBLHdCQUFXLEVBQUMsQ0FBQztFQUM1RCxNQUFNO0lBQUU7RUFBa0IsQ0FBQyxHQUFHLElBQUEsc0JBQVUsRUFBQyxDQUFDO0VBRTFDLE1BQU0sZUFBZSxHQUFHLElBQUEsdUJBQVcsRUFBRSxLQUFLLElBQUs7SUFDN0MsSUFBSSxPQUFPLElBQUksYUFBYSxFQUFFO01BQzVCLE9BQU8sSUFDTCxxQ0FBMkIsRUFJM0IsS0FBSyxFQUFFLE9BQWMsQ0FBQztJQUMxQjtJQUNBLE9BQU8sU0FBUztFQUNsQixDQUFDLENBQUM7RUFFRixNQUFNO0lBQUUsS0FBSyxFQUFFO0VBQWMsQ0FBQyxHQUFHLElBQUEsd0JBQWMsRUFBQyxZQUFZO0lBQzFELElBQUksQ0FBQyxtQkFBbUIsSUFBSSxDQUFBLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxPQUFPLE1BQUssZ0NBQVMsQ0FBQyxPQUFPLElBQUksQ0FBQyxJQUFJLEVBQUU7TUFDekUsT0FBTyxLQUFLO0lBQ2Q7SUFDQSxPQUFPLE1BQU0sSUFBQSxzQkFBZ0IsRUFBQztNQUM1QixLQUFLLEVBQUUsS0FBYztNQUNyQixPQUFPLEVBQUUsT0FBYztNQUN2QixJQUFJLEVBQUUsSUFBVztNQUNqQixLQUFLLEVBQUcsS0FBSyxJQUFJO0lBQ25CLENBQUMsQ0FBQztFQUNKLENBQUMsRUFBRSxDQUFDLEtBQUssRUFBRSxPQUFPLEVBQUUsSUFBSSxFQUFFLEtBQUssQ0FBQyxDQUFDO0VBRWpDLE1BQU0sWUFBWSxHQUFHLElBQUEsa0JBQVcsRUFBQyxNQUFNO0lBQ3JDLE9BQU8sY0FBYyxDQUFDO01BQ3BCLEtBQUs7TUFDTCxlQUFlO01BQ2YsbUJBQW1CO01BQ25CLGFBQWEsRUFBRSxhQUFhLElBQUksS0FBSztNQUNyQztJQUNGLENBQUMsQ0FBQztFQUNKLENBQUMsRUFBRSxDQUNELEtBQUssRUFDTCxlQUFlLEVBQ2YsbUJBQW1CLEVBQ25CLGFBQWEsRUFDYixpQkFBaUIsQ0FDbEIsQ0FBQztFQUVGLE9BQU87SUFDTDtFQUNGLENBQUM7QUFDSCxDQUFDO0FBQUMsT0FBQSxDQUFBLFlBQUEsR0FBQSxZQUFBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ3hIRixJQUFBLGlCQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFFQSxJQUFBLEtBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxzQkFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLGdCQUFBLEdBQUEsT0FBQTtBQUVPLE1BQU0saUJBQWlCLEdBQUcsQ0FBQSxLQUFNO0VBQ3JDLE1BQU07SUFBRTtFQUFpQixDQUFDLEdBQUcsSUFBQSw0Q0FBcUIsRUFBQyxDQUFDO0VBRXBELE1BQU0sWUFBWSxHQUFHLElBQUEsa0JBQVcsRUFDOUIsT0FBTyxPQUFlLEVBQUUsRUFBVSxLQUFLO0lBQ3JDLElBQUksSUFBQSx1QkFBaUIsRUFBQyxFQUFFLENBQUMsRUFBRTtNQUFBLElBQUEsYUFBQSxFQUFBLGNBQUE7TUFDekIsTUFBTSxXQUFXLEdBQUcsTUFBTSxnQkFBZ0IsQ0FDeEMsSUFBQSxxQ0FBbUIsRUFBQyxPQUFPLENBQUMsRUFDNUIsRUFDRixDQUFDO01BRUQsSUFBSSxXQUFXLENBQUMsTUFBTSxLQUFLLENBQUMsRUFBRTtRQUM1QixPQUFPO1VBQ0wsS0FBSyxFQUFFO1FBQ1QsQ0FBQztNQUNIO01BRUEsTUFBTSxjQUFjLElBQUEsYUFBQSxHQUFHLFdBQVcsQ0FBQyxDQUFDLENBQUMsY0FBQSxhQUFBLHVCQUFkLGFBQUEsQ0FBZ0IsZUFBZTtNQUN0RCxNQUFNLFFBQVEsSUFBQSxjQUFBLEdBQUcsV0FBVyxDQUFDLENBQUMsQ0FBQyxjQUFBLGNBQUEsdUJBQWQsY0FBQSxDQUFnQixRQUFRO01BRXpDLE9BQU87UUFDTCxjQUFjO1FBQ2QsUUFBUTtRQUNSLEdBQUcsSUFBQSwyQ0FBMEIsRUFBQyxFQUFFO01BQ2xDLENBQUM7SUFDSDtJQUVBLE9BQU87TUFDTCxLQUFLLEVBQUU7SUFDVCxDQUFDO0VBQ0gsQ0FBQyxFQUNELENBQUMsZ0JBQWdCLENBQ25CLENBQUM7RUFFRCxPQUFPO0lBQ0w7RUFDRixDQUFDO0FBQ0gsQ0FBQztBQUFDLE9BQUEsQ0FBQSxpQkFBQSxHQUFBLGlCQUFBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQzVDRixJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxlQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsdUJBQUEsR0FBQSxPQUFBO0FBRUEsSUFBQSxPQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsS0FBQSxHQUFBLE9BQUE7QUFFTyxNQUFNLG1CQUFtQixHQUFHLENBQUEsS0FBTTtFQUN2QyxNQUFNLE9BQU8sR0FBRyxJQUFBLDBCQUFVLEVBQUMsQ0FBQztFQUM1QixNQUFNLENBQUMsWUFBWSxDQUFDLEdBQUcsSUFBQSx1Q0FBZSxFQUFDLENBQUM7RUFFeEMsTUFBTSx1QkFBdUIsR0FBRyxJQUFBLGtCQUFXLEVBQUMsTUFBTTtJQUNoRCxPQUFPLENBQUMsSUFBSSxDQUNWLEdBQUcsa0JBQVUsSUFBSSxlQUFTLENBQUMsZUFBZSxJQUFJLFlBQVksQ0FBQyxRQUFRLENBQUMsQ0FBQyxFQUN2RSxDQUFDO0VBQ0gsQ0FBQyxFQUFFLENBQUMsWUFBWSxFQUFFLE9BQU8sQ0FBQyxDQUFDO0VBRTNCLE1BQU0sZ0JBQWdCLEdBQUcsSUFBQSxrQkFBVyxFQUFDLE1BQU07SUFDekMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxDQUFDO0VBQ2xCLENBQUMsRUFBRSxDQUFDLE9BQU8sQ0FBQyxDQUFDO0VBRWIsT0FBTztJQUFFLHVCQUF1QjtJQUFFO0VBQWlCLENBQUM7QUFDdEQsQ0FBQztBQUFDLE9BQUEsQ0FBQSxtQkFBQSxHQUFBLG1CQUFBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ3RCRixJQUFBLE1BQUEsR0FBQSxPQUFBO0FBRUEsSUFBQSxTQUFBLEdBQUEsT0FBQTtBQUlBLElBQUEsZUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLEtBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxlQUFBLEdBQUEsT0FBQTtBQUVBLElBQUEsZ0JBQUEsR0FBQSxPQUFBO0FBS0EsSUFBQSxLQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsWUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLGtCQUFBLEdBQUEsT0FBQTtBQUVBO0FBQ0E7QUFDQTtBQUNPLE1BQU0sc0JBQXNCLEdBQUcsQ0FBQSxLQUFNO0VBQzFDLE1BQU0sQ0FBQyxHQUFHLElBQUEsOEJBQWMsRUFBQyxDQUFDO0VBQzFCLE1BQU07SUFBRSxLQUFLO0lBQUUsT0FBTztJQUFFO0VBQUcsQ0FBQyxHQUFHLElBQUEsb0JBQWMsRUFBQyxDQUFDO0VBQy9DLE1BQU07SUFBRSxhQUFhO0lBQUUsZ0JBQWdCO0lBQUU7RUFBa0IsQ0FBQyxHQUFHLElBQUEsd0JBQVcsRUFBQyxDQUFDO0VBQzVFLE1BQU07SUFBRTtFQUFhLENBQUMsR0FBRyxJQUFBLG9DQUFpQixFQUFDLENBQUM7RUFDNUMsTUFBTSxDQUFDLE1BQU0sRUFBRSxTQUFTLENBQUMsR0FBRyxJQUFBLGVBQVEsRUFBNEIsQ0FBQyxDQUFDLENBQUM7RUFDbkUsTUFBTSxvQkFBb0IsR0FBRyxJQUFBLGFBQU0sRUFBUyxDQUFDO0VBQzdDLE1BQU0sWUFBWSxHQUFHLElBQUEsYUFBTSxFQUFDLEtBQUssQ0FBQztFQUVsQyxJQUFBLGdCQUFTLEVBQUMsTUFBTTtJQUNkLE9BQU8sTUFBTTtNQUNYLFlBQVksQ0FBQyxPQUFPLEdBQUcsSUFBSTtJQUM3QixDQUFDO0VBQ0gsQ0FBQyxFQUFFLEVBQUUsQ0FBQztFQUVOLE1BQU0saUJBQWlCLEdBQUcsSUFBQSxrQkFBVyxFQUNuQyxNQUFPLFNBQVMsSUFBeUM7SUFDdkQsSUFBSSxDQUFDLFNBQVMsSUFBSSxDQUFDLE9BQU8sRUFBRTtNQUMxQixPQUFPLENBQUMsQ0FBQztJQUNYO0lBRUEsSUFBSSxhQUFhLElBQUksSUFBQSxpQ0FBaUIsRUFBQyxTQUFTLENBQUMsRUFBRTtNQUNqRCxPQUFPLE1BQU0sSUFBQSxzQ0FBcUIsRUFBQyxTQUFTLEVBQUUsT0FBTyxFQUFFLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxPQUFPLENBQUM7SUFDeEU7SUFFQSxJQUFJLGdCQUFnQixJQUFJLElBQUEseUJBQWUsRUFBQyxTQUFTLENBQUMsRUFBRTtNQUNsRCxPQUFPLElBQUEsc0NBQXFCLEVBQUMsU0FBUyxDQUFDO0lBQ3pDO0lBRUEsSUFBSSxpQkFBaUIsSUFBSSxJQUFBLDZCQUFtQixFQUFDLFNBQVMsQ0FBQyxFQUFFO01BQ3ZELE9BQU8sSUFBQSxtQ0FBa0IsRUFBQyxTQUFTLENBQUM7SUFDdEM7SUFFQSxJQUFJLElBQUEsdUJBQWlCLEVBQUMsU0FBUyxDQUFDLEVBQUU7TUFDaEMsT0FBTyxNQUFNLFlBQVksQ0FBQyxPQUFPLEVBQUUsU0FBUyxDQUFDO0lBQy9DO0lBRUEsT0FBTztNQUNMLEtBQUssRUFBRTtJQUNULENBQUM7RUFDSCxDQUFDLEVBQ0QsQ0FDRSxLQUFLLEVBQ0wsT0FBTyxFQUNQLGFBQWEsRUFDYixnQkFBZ0IsRUFDaEIsaUJBQWlCLEVBQ2pCLFlBQVksQ0FFaEIsQ0FBQztFQUVELElBQUEsZ0JBQVMsRUFBQyxNQUFNO0lBQ2QsSUFBSSxvQkFBb0IsQ0FBQyxPQUFPLEtBQUssRUFBRSxFQUFFO01BQ3ZDO0lBQ0Y7SUFFQSxDQUFDLFlBQVk7TUFDWCxvQkFBb0IsQ0FBQyxPQUFPLEdBQUcsRUFBRTtNQUNqQyxNQUFNLGdCQUFnQixHQUFHLE1BQU0saUJBQWlCLENBQUMsRUFBRSxDQUFDO01BRXBELElBQUksQ0FBQyxZQUFZLENBQUMsT0FBTyxJQUFJLG9CQUFvQixDQUFDLE9BQU8sS0FBSyxFQUFFLEVBQUU7UUFDaEUsU0FBUyxDQUFDO1VBQ1IsR0FBRyxnQkFBZ0I7VUFDbkIsa0JBQWtCLEVBQUU7UUFDdEIsQ0FBQyxDQUFDO01BQ0o7SUFDRixDQUFDLEVBQUUsQ0FBQztFQUNOLENBQUMsRUFBRSxDQUFDLFNBQVMsRUFBRSxFQUFFLEVBQUUsaUJBQWlCLENBQUMsQ0FBQztFQUV0QyxPQUFPO0lBQ0wsNkJBQTZCLEVBQUUsTUFBTSxhQUFOLE1BQU0sdUJBQU4sTUFBTSxDQUFFLG9CQUFvQjtJQUMzRCxjQUFjLEVBQUUsTUFBTSxhQUFOLE1BQU0sZUFBTixNQUFNLENBQUUsS0FBSyxHQUFHLENBQUMsQ0FBQyxNQUFNLGFBQU4sTUFBTSx1QkFBTixNQUFNLENBQUUsS0FBSyxDQUFDLEdBQUcsU0FBUztJQUM1RCx1QkFBdUIsRUFBRSxNQUFNLGFBQU4sTUFBTSx1QkFBTixNQUFNLENBQUUsY0FBYztJQUMvQyxnQkFBZ0IsRUFBRSxNQUFNLGFBQU4sTUFBTSxlQUFOLE1BQU0sQ0FBRSxPQUFPLEdBQUcsQ0FBQyxDQUFDLE1BQU0sYUFBTixNQUFNLHVCQUFOLE1BQU0sQ0FBRSxPQUFPLENBQUMsR0FBRyxTQUFTO0lBQ2xFLGtCQUFrQixFQUFFLE1BQU0sYUFBTixNQUFNLHVCQUFOLE1BQU0sQ0FBRSxRQUFRO0lBQ3BDLGtCQUFrQixFQUFFLE1BQU0sYUFBTixNQUFNLHVCQUFOLE1BQU0sQ0FBRTtFQUM5QixDQUFDO0FBQ0gsQ0FBQztBQUFDLE9BQUEsQ0FBQSxzQkFBQSxHQUFBLHNCQUFBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ25HRixJQUFBLHFCQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEscUJBQUEsR0FBQSxPQUFBO0FBV08sTUFBTSxhQUFhLEdBQUcsQ0FBQSxLQUFtQjtFQUM5QyxNQUFNLGlCQUFpQixHQUFHLElBQUEsMENBQW9CLEVBQUMsQ0FBQztFQUNoRCxNQUFNLGlCQUFpQixHQUFHLElBQUEsMENBQW9CLEVBQUMsQ0FBQztFQUVoRCxNQUFNLFVBQVUsR0FBRyxDQUFDLEdBQUcsaUJBQWlCLENBQUM7RUFFekMsaUJBQWlCLENBQUMsT0FBTyxDQUFFLFNBQVMsSUFBSztJQUN2QyxJQUNFLENBQUMsVUFBVSxDQUFDLElBQUksQ0FDYixDQUFDLElBQUssQ0FBQyxDQUFDLE9BQU8sQ0FBQyxXQUFXLENBQUMsQ0FBQyxLQUFLLFNBQVMsQ0FBQyxPQUFPLENBQUMsV0FBVyxDQUFDLENBQ25FLENBQUMsRUFDRDtNQUNBLFVBQVUsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDO0lBQzVCO0VBQ0YsQ0FBQyxDQUFDO0VBRUYsT0FBTyxVQUFVO0FBQ25CLENBQUM7QUFBQyxPQUFBLENBQUEsYUFBQSxHQUFBLGFBQUE7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDM0JGLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFdBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxlQUFBLEdBQUEsT0FBQTtBQUVBLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFLQSxJQUFBLFFBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxLQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsZ0JBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFlBQUEsR0FBQSxPQUFBO0FBRU8sTUFBTSxjQUFjLEdBQUcsQ0FBQSxLQUFNO0VBQ2xDLE1BQU0sUUFBUSxHQUFHLElBQUEsdUJBQVcsRUFBQyxDQUFDO0VBQzlCLE1BQU0sT0FBTyxHQUFHLElBQUEsMEJBQVUsRUFBQyxDQUFDO0VBQzVCLE1BQU07SUFDSixLQUFLO0lBQ0wsT0FBTztJQUNQLElBQUk7SUFDSixXQUFXO0lBQ1gsT0FBTztJQUNQLFlBQVk7SUFDWixVQUFVLEVBQUUsRUFBRTtJQUNkO0VBQ0YsQ0FBQyxHQUFHLElBQUEscUJBQWMsRUFBQyxDQUFDO0VBQ3BCLE1BQU07SUFBRTtFQUFjLENBQUMsR0FBRyxJQUFBLHdCQUFXLEVBQUMsQ0FBQztFQUV2QyxNQUFNLFlBQVksR0FBRyxJQUFBLGtCQUFXLEVBQUMsWUFBWTtJQUMzQyxJQUFJLENBQUMsS0FBSyxFQUFFO01BQ1Y7SUFDRjtJQUNBLE1BQU0sU0FBUyxHQUFHLEVBQUU7SUFDcEIsSUFBSSxhQUFhLEVBQUU7TUFDakIsUUFBUSxDQUNOLE1BQU0sSUFBQSwyQkFBb0IsRUFBQztRQUN6QixLQUFLO1FBQ0wsT0FBTyxFQUFFLE9BQWM7UUFDdkIsSUFBSSxFQUFFLElBQVc7UUFDakIsT0FBTyxFQUFFLE9BQWM7UUFDdkIsRUFBRSxFQUFFLFNBQWdCO1FBQ3BCLEtBQUssRUFBRTtNQUNULENBQUMsQ0FDSCxDQUFDO01BQ0QsTUFBTSxLQUFLLEdBQUcsWUFBWSxHQUN0QixHQUFHLGlDQUF5QixpQkFBaUIsWUFBWSxFQUFFLEdBQzNELGlDQUF5QjtNQUM3QixPQUFPLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQztJQUNyQixDQUFDLE1BQU07TUFDTCxPQUFPLENBQUMsSUFBSSxDQUFDLEdBQUcsa0JBQVUsSUFBSSxlQUFTLENBQUMsTUFBTSxFQUFFLENBQUM7TUFDakQsTUFBTSxRQUFRLENBQUMsSUFBQSxvQ0FBMkIsRUFBQyxVQUFVLENBQUMsQ0FBQztNQUN2RCxJQUFJO1FBQ0YsTUFBTSxJQUFBLG1EQUFrQyxFQUN0QyxXQUFXLEVBQ1g7VUFDRSxhQUFhLEVBQUUsV0FBVyxhQUFYLFdBQVcsdUJBQVgsV0FBVyxDQUFFLEVBQVk7VUFDeEMsU0FBUyxFQUFFLFNBQW1CO1VBQzlCLE9BQU8sRUFBRSxLQUFLLENBQUMsT0FBd0I7VUFDdkMsTUFBTSxFQUFFLElBQUEsNkJBQXNCLEVBQUMsS0FBSztRQUN0QyxDQUNGLENBQUM7UUFDRCxPQUFPLENBQUMsSUFBSSxDQUFDLHFCQUFhLENBQUM7TUFDN0IsQ0FBQyxDQUFDLE9BQU8sS0FBSyxFQUFFO1FBQ2Q7TUFBQTtJQUVKO0VBQ0YsQ0FBQyxFQUFFLENBQ0QsS0FBSyxFQUNMLE9BQU8sRUFDUCxRQUFRLEVBQ1IsSUFBSSxFQUNKLFdBQVcsRUFDWCxPQUFPLEVBQ1AsT0FBTyxFQUNQLGFBQWEsRUFDYixZQUFZLEVBQ1osRUFBRSxFQUNGLEtBQUssQ0FDTixDQUFDO0VBRUYsTUFBTSxVQUFVLEdBQUcsSUFBQSxrQkFBVyxFQUFDLE1BQU07SUFDbkMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxDQUFDO0VBQ2xCLENBQUMsRUFBRSxDQUFDLE9BQU8sQ0FBQyxDQUFDO0VBRWIsTUFBTSxZQUFZLEdBQUcsSUFBQSxrQkFBVyxFQUFDLE1BQU07SUFDckMsT0FBTyxDQUFDLElBQUksQ0FBQyxxQkFBYSxDQUFDO0VBQzdCLENBQUMsRUFBRSxDQUFDLE9BQU8sQ0FBQyxDQUFDO0VBRWIsT0FBTztJQUFFLFlBQVk7SUFBRSxZQUFZO0lBQUU7RUFBVyxDQUFDO0FBQ25ELENBQUM7QUFBQyxPQUFBLENBQUEsY0FBQSxHQUFBLGNBQUE7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDOUZGLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFnQk8sTUFBTSxrQkFBa0IsR0FBRyxDQUFDO0VBQ2pDLE1BQU07RUFDTixJQUFJO0VBQ0osZUFBZTtFQUNmLFdBQVcsR0FBRztBQUNTLENBQUMsS0FBcUI7RUFDN0MsT0FBTyxJQUFBLGNBQU8sRUFBQyxNQUFNO0lBQ25CLElBQUkscUJBQXFCLEdBQUcsTUFBTTtJQUNsQyxJQUFJLG1CQUFtQixHQUFHLElBQUk7SUFFOUIsSUFBSSxlQUFlLEtBQUssSUFBSSxFQUFFO01BQzVCLHFCQUFxQixHQUFHLE1BQU0sQ0FBQyxNQUFNLENBQ2xDLEtBQUssSUFBSyxLQUFLLENBQUMsT0FBTyxLQUFLLGVBQy9CLENBQUM7TUFDRCxtQkFBbUIsR0FBRyxJQUFJLENBQUMsTUFBTSxDQUM5QixHQUFHLElBQUssR0FBRyxDQUFDLE9BQU8sS0FBSyxlQUMzQixDQUFDO0lBQ0g7SUFFQSxNQUFNLGNBQWMsR0FBRyxxQkFBcUIsQ0FBQyxNQUFNLENBQUUsS0FBSyxJQUN4RCxrQkFBa0IsQ0FBQyxLQUFLLEVBQUUsV0FBVyxDQUN2QyxDQUFDO0lBRUQsTUFBTSxZQUFZLEdBQUcsbUJBQW1CLENBQUMsTUFBTSxDQUFFLEdBQUcsSUFDbEQsa0JBQWtCLENBQUMsR0FBRyxFQUFFLFdBQVcsQ0FDckMsQ0FBQztJQUVELE9BQU87TUFDTCxjQUFjO01BQ2Q7SUFDRixDQUFDO0VBQ0gsQ0FBQyxFQUFFLENBQUMsTUFBTSxFQUFFLElBQUksRUFBRSxlQUFlLEVBQUUsV0FBVyxDQUFDLENBQUM7QUFDbEQsQ0FBQztBQUFDLE9BQUEsQ0FBQSxrQkFBQSxHQUFBLGtCQUFBO0FBRUYsU0FBUyxrQkFBa0IsQ0FBQyxLQUFZLEVBQUUsS0FBYSxFQUFXO0VBQUEsSUFBQSxXQUFBLEVBQUEsYUFBQSxFQUFBLGlCQUFBO0VBQ2hFLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLENBQUMsRUFBRTtJQUNqQixPQUFPLElBQUk7RUFDYjtFQUVBLE1BQU0sVUFBVSxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxDQUFDO0VBRTdDLEtBQUEsV0FBQSxHQUFJLEtBQUssQ0FBQyxJQUFJLGNBQUEsV0FBQSxlQUFWLFdBQUEsQ0FBWSxXQUFXLENBQUMsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxVQUFVLENBQUMsRUFBRTtJQUNsRCxPQUFPLElBQUk7RUFDYjtFQUNBLEtBQUEsYUFBQSxHQUFJLEtBQUssQ0FBQyxNQUFNLGNBQUEsYUFBQSxlQUFaLGFBQUEsQ0FBYyxXQUFXLENBQUMsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxVQUFVLENBQUMsRUFBRTtJQUNwRCxPQUFPLElBQUk7RUFDYjtFQUNBLEtBQUEsaUJBQUEsR0FBSSxLQUFLLENBQUMsVUFBVSxjQUFBLGlCQUFBLGdCQUFBLGlCQUFBLEdBQWhCLGlCQUFBLENBQWtCLElBQUksY0FBQSxpQkFBQSxlQUF0QixpQkFBQSxDQUF3QixXQUFXLENBQUMsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxVQUFVLENBQUMsRUFBRTtJQUM5RCxPQUFPLElBQUk7RUFDYjtFQUVBLE9BQU8sS0FBSztBQUNkOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ3BFQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBRUEsSUFBQSxjQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsWUFBQSxHQUFBLE9BQUE7QUFPTyxNQUFNLGFBQWEsR0FBRyxDQUFBLEtBQWtCO0VBQzdDLE1BQU0sTUFBTSxHQUFHLElBQUEsNEJBQWEsRUFBQyxDQUFDO0VBQzlCLE1BQU0sSUFBSSxHQUFHLElBQUEsd0JBQVcsRUFBQyxDQUFDO0VBRTFCLE9BQU8sSUFBQSxjQUFPLEVBQ1osT0FBTztJQUNMLE1BQU07SUFDTjtFQUNGLENBQUMsQ0FBQyxFQUNGLENBQUMsTUFBTSxFQUFFLElBQUksQ0FDZixDQUFDO0FBQ0gsQ0FBQztBQUFDLE9BQUEsQ0FBQSxhQUFBLEdBQUEsYUFBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNuQkYsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsV0FBQSxHQUFBLE9BQUE7QUFJQSxJQUFBLElBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxZQUFBLEdBQUEsT0FBQTtBQUtBLElBQUEsS0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLDRCQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEseUJBQUEsR0FBQSxPQUFBO0FBVkE7QUFDQTs7QUFXTyxNQUFNLFdBQVcsR0FBRyxDQUFBLEtBQU07RUFDL0IsTUFBTSwyQkFBMkIsR0FBRyxJQUFBLDJEQUE4QixFQUFDLENBQUM7RUFDcEUsTUFBTSxtQkFBbUIsR0FBRyxJQUFBLHVCQUFXLEVBQUMsNEJBQXVCLENBQUM7RUFDaEUsTUFBTSxDQUFDLElBQUksRUFBRSxPQUFPLENBQUMsR0FBRyxJQUFBLGVBQVEsRUFBVSxFQUFFLENBQUM7RUFDN0MsTUFBTTtJQUFFO0VBQW1CLENBQUMsR0FBRyxJQUFBLGtEQUF3QixFQUFDLENBQUM7RUFDekQsTUFBTSxvQkFBb0IsR0FBRyxJQUFBLHVCQUFXLEVBQUMsb0NBQXVCLENBQUM7RUFDakUsTUFBTSxnQ0FBZ0MsR0FBRyxJQUFBLHVCQUFXLEVBQ2xELGdEQUNGLENBQUM7O0VBRUQ7RUFDQSxNQUFNLGVBQWUsR0FBRyxJQUFBLGNBQU8sRUFBQyxNQUFNO0lBQUEsSUFBQSxxQkFBQTtJQUNwQyxNQUFNLHdDQUF3QyxHQUM1QyxnQ0FBZ0MsYUFBaEMsZ0NBQWdDLGdCQUFBLHFCQUFBLEdBQWhDLGdDQUFnQyxDQUFFLElBQUksQ0FDbkMsWUFBWSxJQUFLLFlBQVksQ0FBQyxFQUFFLEtBQUssb0JBQ3hDLENBQUMsY0FBQSxxQkFBQSx1QkFGRCxxQkFBQSxDQUVHLFFBQVE7SUFFYixPQUFPLHFCQUFxQixDQUMxQixtQkFBbUIsRUFDbkIsd0NBQXdDLEVBQ3hDLDJCQUNGLENBQUM7RUFDSCxDQUFDLEVBQUUsQ0FDRDtFQUNBLGdDQUFnQyxhQUFoQyxnQ0FBZ0MsdUJBQWhDLGdDQUFnQyxDQUFFLE1BQU0sRUFDeEMsMkJBQTJCLEVBQzNCLG1CQUFtQixFQUNuQixvQkFBb0IsQ0FDckIsQ0FBQzs7RUFFRjtFQUNBLE1BQU0scUJBQXFCLEdBQUcsSUFBQSxrQkFBVyxFQUN2QyxNQUFPLFNBQWtCLElBQUs7SUFDNUIsTUFBTSxXQUFXLEdBQUcsU0FBUyxDQUFDLE1BQU0sQ0FDakMsR0FBRyxJQUFLLEdBQUcsQ0FBQyxRQUFRLEtBQUssbUJBQWEsQ0FBQyxPQUMxQyxDQUFDO0lBRUQsSUFBSSxXQUFXLENBQUMsTUFBTSxLQUFLLENBQUMsRUFBRTtNQUM1QixPQUFPLFNBQVM7SUFDbEI7SUFFQSxNQUFNLGVBQWUsR0FBRyxXQUFXLENBQUMsR0FBRyxDQUFDLGtCQUFrQixDQUFDO0lBQzNELE1BQU0sY0FBYyxHQUFHLE1BQU0sT0FBTyxDQUFDLFVBQVUsQ0FBQyxlQUFlLENBQUM7SUFFaEUsTUFBTSxnQkFBZ0IsR0FBRyxDQUFDLEdBQUcsU0FBUyxDQUFDO0lBQ3ZDLGNBQWMsQ0FBQyxPQUFPLENBQUUsTUFBTSxJQUFLO01BQ2pDLElBQUksTUFBTSxDQUFDLE1BQU0sS0FBSyxXQUFXLElBQUksTUFBTSxDQUFDLEtBQUssRUFBRTtRQUNqRCxNQUFNO1VBQUUsR0FBRztVQUFFO1FBQVEsQ0FBQyxHQUFHLE1BQU0sQ0FBQyxLQUFLO1FBQ3JDLE1BQU0sS0FBSyxHQUFHLGdCQUFnQixDQUFDLFNBQVMsQ0FDckMsT0FBTyxJQUNOLE9BQU8sQ0FBQyxPQUFPLEtBQUssR0FBRyxDQUFDLE9BQU8sSUFDL0IsT0FBTyxDQUFDLE9BQU8sS0FBSyxHQUFHLENBQUMsT0FBTyxJQUMvQixPQUFPLENBQUMsT0FBTyxLQUFLLEdBQUcsQ0FBQyxPQUFPLElBQy9CLE9BQU8sQ0FBQyxTQUFTLEtBQUssR0FBRyxDQUFDLFNBQzlCLENBQUM7UUFDRCxJQUFJLEtBQUssS0FBSyxDQUFDLENBQUMsRUFBRTtVQUNoQixnQkFBZ0IsQ0FBQyxLQUFLLENBQUMsR0FBRztZQUFFLEdBQUcsZ0JBQWdCLENBQUMsS0FBSyxDQUFDO1lBQUU7VUFBUSxDQUFDO1FBQ25FO01BQ0Y7SUFDRixDQUFDLENBQUM7SUFFRixPQUFPLGdCQUFnQjtFQUN6QixDQUFDLEVBQ0QsQ0FBQyxrQkFBa0IsQ0FDckIsQ0FBQztFQUVELElBQUEsZ0JBQVMsRUFBQyxNQUFNO0lBQ2QsSUFBSSxXQUFXLEdBQUcsS0FBSztJQUV2QixNQUFNLFVBQVUsR0FBRyxNQUFBLENBQUEsS0FBWTtNQUM3QixNQUFNLGdCQUFnQixHQUFHLE1BQU0scUJBQXFCLENBQUMsZUFBZSxDQUFDO01BRXJFLElBQUksQ0FBQyxXQUFXLEVBQUU7UUFDaEIsT0FBTyxDQUFDLGdCQUFnQixDQUFDO01BQzNCO0lBQ0YsQ0FBQztJQUVELFVBQVUsQ0FBQyxDQUFDO0lBRVosT0FBTyxNQUFNO01BQ1gsV0FBVyxHQUFHLElBQUk7SUFDcEIsQ0FBQztFQUNILENBQUMsRUFBRSxDQUFDLGVBQWUsRUFBRSxxQkFBcUIsQ0FBQyxDQUFDO0VBRTVDLE9BQU8sSUFBSTtBQUNiLENBQUM7QUFBQyxPQUFBLENBQUEsV0FBQSxHQUFBLFdBQUE7QUFFRixTQUFTLHFCQUFxQixDQUM1QixtQkFBK0QsRUFDL0QsZ0JBQXdELEVBQ3hELDJCQUVDLEVBQ1E7RUFDVCxNQUFNLFNBQWtCLEdBQUcsRUFBRTtFQUU3QixNQUFNLENBQUMsSUFBSSxDQUFDLG1CQUFtQixDQUFDLENBQUMsT0FBTyxDQUFFLGNBQWMsSUFBSztJQUMzRCxNQUFNLE9BQU8sR0FBRyxnQkFBZ0IsYUFBaEIsZ0JBQWdCLHVCQUFoQixnQkFBZ0IsQ0FBRSxJQUFJLENBQ25DLEdBQUcsSUFBSyxHQUFHLENBQUMsT0FBTyxLQUFLLGNBQzNCLENBQUM7SUFFRCxJQUFJLE9BQU8sRUFBRTtNQUNYLE1BQU0sQ0FBQyxJQUFJLENBQUMsbUJBQW1CLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUUsT0FBTyxJQUFLO1FBQ3BFLG1CQUFtQixDQUFDLGNBQWMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sQ0FBRSxHQUFRLElBQUs7VUFDakUsTUFBTSx3QkFBd0IsR0FDNUIsMkJBQTJCLENBQUMsR0FBRyxDQUFDLE9BQU8sQ0FBQztVQUMxQyxTQUFTLENBQUMsSUFBSSxDQUFDO1lBQ2IsR0FBRyxHQUFHO1lBQ04sU0FBUyxFQUFFLE9BQU8sQ0FBQyxFQUFFO1lBQ3JCLGNBQWMsRUFBRSxPQUFPLENBQUMsT0FBTztZQUMvQixPQUFPO1lBQ1AsWUFBWSxFQUFFLHdCQUF3QixhQUF4Qix3QkFBd0IsdUJBQXhCLHdCQUF3QixDQUFFLFlBQVk7WUFDcEQsV0FBVyxFQUFFLHdCQUF3QixhQUF4Qix3QkFBd0IsdUJBQXhCLHdCQUF3QixDQUFFO1VBQ3pDLENBQVUsQ0FBQztRQUNiLENBQUMsQ0FBQztNQUNKLENBQUMsQ0FBQztJQUNKO0VBQ0YsQ0FBQyxDQUFDO0VBRUYsT0FBTyxTQUFTO0FBQ2xCOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ3pJQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxpQkFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxlQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsdUJBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxXQUFBLEdBQUEsT0FBQTtBQUVBLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE9BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxPQUFBLEdBQUEsT0FBQTtBQUVBLElBQUEsS0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxZQUFBLEdBQUEsT0FBQTtBQUVPLE1BQU0sa0JBQWtCLEdBQUcsQ0FBQSxLQUFNO0VBQ3RDLE1BQU07SUFDSixLQUFLO0lBQ0wsV0FBVztJQUNYLE9BQU87SUFDUCxZQUFZO0lBQ1osRUFBRTtJQUNGLFdBQVc7SUFDWCxpQkFBaUI7SUFDakIsV0FBVztJQUNYLGFBQWE7SUFDYixRQUFRO0lBQ1I7RUFDRixDQUFDLEdBQUcsSUFBQSxxQkFBYyxFQUFDLENBQUM7RUFDcEIsTUFBTSxPQUFPLEdBQUcsSUFBQSwwQkFBVSxFQUFDLENBQUM7RUFDNUIsTUFBTTtJQUFFO0VBQVMsQ0FBQyxHQUFHLElBQUEsbUNBQVcsRUFBQyxDQUFDO0VBQ2xDLE1BQU0sQ0FBQyxZQUFZLENBQUMsR0FBRyxJQUFBLHVDQUFlLEVBQUMsQ0FBQztFQUN4QyxNQUFNLElBQUksR0FBRyxJQUFBLHdCQUFXLEVBQUMsQ0FBQztFQUMxQixNQUFNLE1BQU0sR0FBRyxJQUFBLHVCQUFXLEVBQUMsdUNBQStCLENBQUM7RUFDM0QsTUFBTSxVQUFVLEdBQUcsSUFBQSxjQUFPLEVBQUMsTUFBTSxNQUFNLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxDQUFDLElBQUksQ0FBQyxDQUFDLEVBQUUsQ0FBQyxNQUFNLENBQUMsQ0FBQztFQUV4RSxNQUFNLE9BQU8sR0FBRyxJQUFBLGNBQU8sRUFBQyxNQUFNO0lBQzVCLE1BQU0sSUFBSSxHQUFHLFFBQVEsQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUNuRCxJQUFJLE1BQU0sQ0FBQyxNQUFNLENBQUMsZUFBUyxDQUFDLENBQUMsUUFBUSxDQUFDLElBQWlCLENBQUMsRUFBRTtNQUN4RCxPQUFPLElBQUk7SUFDYjtJQUNBLE9BQU8sU0FBUztFQUNsQixDQUFDLEVBQUUsQ0FBQyxRQUFRLENBQUMsQ0FBQztFQUVkLE1BQU0sVUFBVSxHQUFHLFlBQVksQ0FBQyxHQUFHLENBQUMsT0FBTyxDQUFDO0VBQzVDLE1BQU0sV0FBVyxHQUFHLFlBQVksQ0FBQyxHQUFHLENBQUMsUUFBUSxDQUFDO0VBQzlDLE1BQU0sWUFBWSxHQUFHLFlBQVksQ0FBQyxHQUFHLENBQUMsU0FBUyxDQUFDO0VBQ2hELE1BQU0sWUFBWSxHQUFHLFlBQVksQ0FBQyxHQUFHLENBQUMsU0FBUyxDQUFDO0VBQ2hELE1BQU0sY0FBYyxHQUFHLFlBQVksQ0FBQyxHQUFHLENBQUMsV0FBVyxDQUFDO0VBQ3BELE1BQU0saUJBQWlCLEdBQUcsWUFBWSxDQUFDLEdBQUcsQ0FBQyxjQUFjLENBQUM7RUFFMUQsSUFBQSxnQkFBUyxFQUFDLE1BQU07SUFDZCxJQUFJLFdBQVcsS0FBSyxPQUFPLEVBQUU7TUFDM0I7SUFDRjtJQUNBLGlCQUFpQixDQUFFLE9BQU8sSUFBa0IsZUFBUyxDQUFDLEtBQUssQ0FBQztFQUM5RCxDQUFDLEVBQUUsQ0FBQyxXQUFXLEVBQUUsT0FBTyxFQUFFLGlCQUFpQixDQUFDLENBQUM7O0VBRTdDO0VBQ0E7RUFDQSxJQUFBLGdCQUFTLEVBQUMsTUFBTTtJQUNkLElBQUksQ0FBQyxPQUFPLEVBQUU7TUFDWjtJQUNGO0lBQ0EsTUFBTSxXQUFXLEdBQUcsSUFBSSxlQUFlLENBQUMsWUFBWSxDQUFDO0lBQ3JELElBQUksS0FBSyxLQUFLLFNBQVMsSUFBSSxXQUFXLEtBQUssS0FBSyxFQUFFO01BQ2hELFdBQVcsQ0FBQyxHQUFHLENBQUMsUUFBUSxFQUFFLEtBQUssQ0FBQztJQUNsQztJQUNBLElBQUksQ0FBQSxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsT0FBTyxNQUFLLFNBQVMsSUFBSSxVQUFVLEtBQUssS0FBSyxDQUFDLE9BQU8sRUFBRTtNQUNoRSxXQUFXLENBQUMsR0FBRyxDQUFDLE9BQU8sRUFBRSxLQUFLLENBQUMsT0FBTyxJQUFJLEtBQUssQ0FBQyxPQUFPLENBQUM7SUFDMUQ7SUFDQSxJQUFJLENBQUEsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLE9BQU8sTUFBSyxTQUFTLElBQUksWUFBWSxLQUFLLEtBQUssQ0FBQyxPQUFPLEVBQUU7TUFDbEUsV0FBVyxDQUFDLEdBQUcsQ0FBQyxTQUFTLEVBQUUsS0FBSyxDQUFDLE9BQU8sQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDO0lBQ3REO0lBQ0EsSUFBSSxZQUFZLEtBQUssU0FBUyxJQUFJLGlCQUFpQixLQUFLLEdBQUcsWUFBWSxFQUFFLEVBQUU7TUFDekUsV0FBVyxDQUFDLEdBQUcsQ0FBQyxjQUFjLEVBQUUsWUFBWSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDMUQ7SUFDQSxJQUFJLE9BQU8sS0FBSyxTQUFTLElBQUksWUFBWSxLQUFLLE9BQU8sRUFBRTtNQUNyRCxXQUFXLENBQUMsR0FBRyxDQUFDLFNBQVMsRUFBRSxPQUFPLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztJQUNoRDtJQUNBLElBQUksRUFBRSxLQUFLLFNBQVMsSUFBSSxjQUFjLEtBQUssRUFBRSxFQUFFO01BQzdDLFdBQVcsQ0FBQyxHQUFHLENBQUMsV0FBVyxFQUFFLEVBQUUsQ0FBQztJQUNsQztJQUNBLE9BQU8sQ0FBQyxPQUFPLENBQUMsR0FBRyxrQkFBVSxJQUFJLE9BQU8sSUFBSSxXQUFXLENBQUMsUUFBUSxDQUFDLENBQUMsRUFBRSxDQUFDO0VBQ3ZFLENBQUMsRUFBRSxDQUNELEtBQUssRUFDTCxPQUFPLEVBQ1AsT0FBTyxFQUNQLFlBQVksRUFDWixXQUFXLEVBQ1gsVUFBVSxFQUNWLFlBQVksRUFDWixpQkFBaUIsRUFDakIsY0FBYyxFQUNkLFlBQVksRUFDWixPQUFPLEVBQ1AsRUFBRSxFQUNGLEtBQUssQ0FDTixDQUFDO0VBRUYsSUFBQSxnQkFBUyxFQUFDLE1BQU07SUFDZCxJQUFJLEVBQUUsS0FBSyxTQUFTLElBQUksY0FBYyxFQUFFO01BQ3RDLFFBQVEsQ0FBQyxjQUFjLENBQUM7SUFDMUI7RUFDRixDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsY0FBYyxFQUFFLFFBQVEsQ0FBQyxDQUFDO0VBRWxDLElBQUEsZ0JBQVMsRUFBQyxNQUFNO0lBQ2QsSUFBSSxPQUFPLEtBQUssU0FBUyxJQUFJLFlBQVksRUFBRTtNQUN6QyxhQUFhLENBQUMsWUFBbUIsQ0FBQztJQUNwQztFQUNGLENBQUMsRUFBRSxDQUFDLE9BQU8sRUFBRSxZQUFZLEVBQUUsYUFBYSxDQUFDLENBQUM7RUFFMUMsSUFBQSxnQkFBUyxFQUFDLE1BQU07SUFDZCxJQUFJLEtBQUssS0FBSyxTQUFTLElBQUksV0FBVyxFQUFFO01BQ3RDLFdBQVcsQ0FBQyxXQUFXLEVBQUUsaUJBQWlCLEtBQUssTUFBTSxDQUFDO0lBQ3hEO0VBQ0YsQ0FBQyxFQUFFLENBQUMsV0FBVyxFQUFFLGlCQUFpQixFQUFFLFdBQVcsRUFBRSxLQUFLLENBQUMsQ0FBQztFQUV4RCxJQUFBLGdCQUFTLEVBQUMsTUFBTTtJQUNkLElBQUksS0FBSyxJQUFJLENBQUMsWUFBWSxFQUFFO01BQzFCO0lBQ0Y7SUFDQSxNQUFNLE9BQU8sR0FDWCxDQUFDLElBQUEsaUNBQWUsRUFBQyxZQUFZLENBQUMsSUFBSSxDQUFDLElBQUEsa0JBQVcsRUFBQyxZQUFZLENBQUMsR0FDeEQsSUFBQSxhQUFLLEVBQUMsWUFBWSxDQUFDLEdBQ25CLFlBQVk7SUFFbEIsSUFBSSxRQUEyQixHQUFHLFVBQVUsYUFBVixVQUFVLHVCQUFWLFVBQVUsQ0FBRSxJQUFJLENBQ2hELENBQUM7TUFBRSxPQUFPO01BQUUsT0FBTyxFQUFFLFlBQVk7TUFBRTtJQUFTLENBQUMsS0FDM0MsT0FBTyxLQUFLLFlBQVksS0FDdEIsVUFBVSxJQUFJLENBQUEsT0FBTyxhQUFQLE9BQU8sdUJBQVAsT0FBTyxDQUFFLFdBQVcsQ0FBQyxDQUFDLE1BQUssVUFBVSxDQUFDLFdBQVcsQ0FBQyxDQUFDLElBQ2hFLENBQUMsVUFBVSxJQUFJLFFBQVMsQ0FDL0IsQ0FBQztJQUVELElBQUksQ0FBQyxRQUFRLEVBQUU7TUFDYixRQUFRLEdBQUcsSUFBSSxhQUFKLElBQUksdUJBQUosSUFBSSxDQUFFLElBQUksQ0FDbkIsQ0FBQztRQUFFLE9BQU87UUFBRSxPQUFPLEVBQUUsWUFBWTtRQUFFO01BQVMsQ0FBQyxLQUMzQyxPQUFPLEtBQUssWUFBWSxLQUN0QixVQUFVLElBQ1YsQ0FBQSxPQUFPLGFBQVAsT0FBTyx1QkFBUCxPQUFPLENBQUUsV0FBVyxDQUFDLENBQUMsTUFBSyxVQUFVLENBQUMsV0FBVyxDQUFDLENBQUMsSUFDbEQsQ0FBQyxVQUFVLElBQUksUUFBUyxDQUMvQixDQUFDO0lBQ0g7SUFFQSxJQUFJLFFBQVEsRUFBRTtNQUNaLFdBQVcsQ0FBQyxRQUFRLENBQUM7SUFDdkI7RUFDRixDQUFDLEVBQUUsQ0FBQyxLQUFLLEVBQUUsVUFBVSxFQUFFLFVBQVUsRUFBRSxZQUFZLEVBQUUsSUFBSSxFQUFFLFdBQVcsQ0FBQyxDQUFDO0FBQ3RFLENBQUM7QUFBQyxPQUFBLENBQUEsa0JBQUEsR0FBQSxrQkFBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNwSkYsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQWVPLE1BQU0sc0JBQXNCLEdBQUcsQ0FBQztFQUNyQyxpQkFBaUI7RUFDakIsaUJBQWlCO0VBQ2pCLFdBQVcsR0FBRztBQUNTLENBQUMsS0FBcUI7RUFDN0MsT0FBTyxJQUFBLGNBQU8sRUFBQyxNQUFNO0lBQ25CLE1BQU0sZ0NBQWdDLEdBQUcsaUJBQWlCO0lBQzFELE1BQU0sZ0NBQWdDLEdBQUcsaUJBQWlCO0lBRTFELE1BQU0seUJBQXlCLEdBQUcsZ0NBQWdDLENBQUMsTUFBTSxDQUN0RSxTQUFTLElBQUssa0JBQWtCLENBQUMsU0FBUyxFQUFFLFdBQVcsQ0FDMUQsQ0FBQztJQUVELE1BQU0seUJBQXlCLEdBQUcsZ0NBQWdDLENBQUMsTUFBTSxDQUN0RSxTQUFTLElBQUssa0JBQWtCLENBQUMsU0FBUyxFQUFFLFdBQVcsQ0FDMUQsQ0FBQztJQUVELE9BQU87TUFDTCx5QkFBeUI7TUFDekI7SUFDRixDQUFDO0VBQ0gsQ0FBQyxFQUFFLENBQUMsaUJBQWlCLEVBQUUsaUJBQWlCLEVBQUUsV0FBVyxDQUFDLENBQUM7QUFDekQsQ0FBQztBQUFDLE9BQUEsQ0FBQSxzQkFBQSxHQUFBLHNCQUFBO0FBRUYsU0FBUyxrQkFBa0IsQ0FBQyxTQUFvQixFQUFFLEtBQWEsRUFBVztFQUFBLElBQUEscUJBQUEsRUFBQSxxQkFBQSxFQUFBLHFCQUFBLEVBQUEsa0JBQUE7RUFDeEUsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQyxFQUFFO0lBQ2pCLE9BQU8sSUFBSTtFQUNiO0VBRUEsTUFBTSxVQUFVLEdBQUcsS0FBSyxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLENBQUM7RUFFN0MsS0FBQSxxQkFBQSxHQUFJLFNBQVMsQ0FBQyxXQUFXLGNBQUEscUJBQUEsZUFBckIscUJBQUEsQ0FBdUIsV0FBVyxDQUFDLENBQUMsQ0FBQyxRQUFRLENBQUMsVUFBVSxDQUFDLEVBQUU7SUFDN0QsT0FBTyxJQUFJO0VBQ2I7RUFDQSxLQUFBLHFCQUFBLEdBQUksU0FBUyxDQUFDLGdCQUFnQixjQUFBLHFCQUFBLGVBQTFCLHFCQUFBLENBQTRCLFdBQVcsQ0FBQyxDQUFDLENBQUMsUUFBUSxDQUFDLFVBQVUsQ0FBQyxFQUFFO0lBQ2xFLE9BQU8sSUFBSTtFQUNiO0VBQ0EsS0FBQSxxQkFBQSxHQUFJLFNBQVMsQ0FBQyxVQUFVLGNBQUEscUJBQUEsZUFBcEIscUJBQUEsQ0FBc0IsV0FBVyxDQUFDLENBQUMsQ0FBQyxRQUFRLENBQUMsVUFBVSxDQUFDLEVBQUU7SUFDNUQsT0FBTyxJQUFJO0VBQ2I7RUFDQSxLQUFBLGtCQUFBLEdBQUksU0FBUyxDQUFDLE9BQU8sY0FBQSxrQkFBQSxlQUFqQixrQkFBQSxDQUFtQixXQUFXLENBQUMsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxVQUFVLENBQUMsRUFBRTtJQUN6RCxPQUFPLElBQUk7RUFDYjtFQUVBLE9BQU8sS0FBSztBQUNkOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQzVEQSxJQUFBLFdBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUdBLElBQUEsUUFBQSxHQUFBLE9BQUE7QUFJQSxJQUFBLE9BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxLQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsNEJBQUEsR0FBQSxPQUFBO0FBRU8sTUFBTSxhQUFhLEdBQUcsQ0FBQSxLQUFlO0VBQzFDLE1BQU0sMkJBQTJCLEdBQUcsSUFBQSwyREFBOEIsRUFBQyxDQUFDO0VBQ3BFLE1BQU0sTUFBTSxHQUFHLElBQUEsdUJBQVcsRUFBQyx1Q0FBK0IsQ0FBQztFQUUzRCxNQUFNLFVBQVUsR0FBRyxJQUFBLGNBQU8sRUFBQyxNQUFNLE1BQU0sQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDLENBQUMsSUFBSSxDQUFDLENBQUMsRUFBRSxDQUFDLE1BQU0sQ0FBQyxDQUFDO0VBRXhFLE1BQU0saUJBQWlCLEdBQUcsSUFBQSxjQUFPLEVBQUMsTUFBTTtJQUN0QyxPQUFPLFVBQVUsQ0FBQyxNQUFNLENBQUUsS0FBSyxJQUFLO01BQ2xDLE1BQU0sV0FBVyxHQUFHLEtBQUssQ0FBQyxVQUFVLEtBQUssS0FBSztNQUM5QyxPQUFPLFdBQVc7SUFDcEIsQ0FBQyxDQUFDO0VBQ0osQ0FBQyxFQUFFLENBQUMsVUFBVSxDQUFDLENBQUM7RUFFaEIsTUFBTSxlQUFlLEdBQUcsSUFBQSxjQUFPLEVBQUMsTUFBTTtJQUNwQyxPQUFPLGlCQUFpQixDQUFDLEdBQUcsQ0FBRSxLQUFLLElBQUs7TUFDdEMsTUFBTSx3QkFBd0IsR0FBRywyQkFBMkIsQ0FBQyxHQUFHLENBQzlELEtBQUssQ0FBQyxPQUNSLENBQUM7TUFFRCxJQUFJLFdBQStCO01BQ25DLElBQUksS0FBSyxDQUFDLFFBQVEsRUFBRTtRQUNsQjtRQUNBLFdBQVcsR0FDVCxpQ0FBd0IsQ0FDdEIsS0FBSyxDQUFDLE9BQU8sQ0FDZCxJQUFJLDBDQUFpQyxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQVE7TUFDaEUsQ0FBQyxNQUFNO1FBQ0wsV0FBVyxHQUFHLEtBQUssQ0FBQyxLQUFLO01BQzNCO01BRUEsT0FBTztRQUNMLEdBQUcsS0FBSztRQUNSLEtBQUssRUFBRSxXQUFXO1FBQ2xCLFlBQVksRUFBRSx3QkFBd0IsYUFBeEIsd0JBQXdCLHVCQUF4Qix3QkFBd0IsQ0FBRSxZQUFZO1FBQ3BELFdBQVcsRUFBRSx3QkFBd0IsYUFBeEIsd0JBQXdCLHVCQUF4Qix3QkFBd0IsQ0FBRSxXQUFXO1FBQ2xELGdCQUFnQixFQUFFLEtBQUssQ0FBQyxPQUFPO1FBQy9CLFFBQVEsRUFBRSxLQUFLLENBQUMsUUFBUSxHQUFHLG1CQUFhLENBQUMsTUFBTSxHQUFHLG1CQUFhLENBQUM7TUFDbEUsQ0FBQztJQUNILENBQUMsQ0FBQztFQUNKLENBQUMsRUFBRSxDQUFDLGlCQUFpQixFQUFFLDJCQUEyQixDQUFDLENBQUM7RUFFcEQsT0FBTyxJQUFBLGNBQU8sRUFBQyxNQUFNO0lBQ25CLE9BQU8sZUFBZSxDQUFDLElBQUksQ0FDekIsQ0FBQyxDQUFDLEVBQUUsQ0FBQztNQUFBLElBQUEsT0FBQSxFQUFBLE9BQUE7TUFBQSxPQUFLLENBQUMsRUFBQSxPQUFBLEdBQUEsQ0FBQyxDQUFDLElBQUksY0FBQSxPQUFBLHVCQUFOLE9BQUEsQ0FBUSxPQUFPLEtBQUksQ0FBQyxLQUFLLEVBQUEsT0FBQSxHQUFBLENBQUMsQ0FBQyxJQUFJLGNBQUEsT0FBQSx1QkFBTixPQUFBLENBQVEsT0FBTyxLQUFJLENBQUMsQ0FBQztJQUFBLENBQzNELENBQUM7RUFDSCxDQUFDLEVBQUUsQ0FBQyxlQUFlLENBQUMsQ0FBQztBQUN2QixDQUFDO0FBQUMsT0FBQSxDQUFBLGFBQUEsR0FBQSxhQUFBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQzFERixJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxpQkFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBRUEsSUFBQSxLQUFBLEdBQUEsT0FBQTtBQUVPLE1BQU0sV0FBVyxHQUFHLENBQUEsS0FBTTtFQUMvQixNQUFNO0lBQUUsS0FBSztJQUFFO0VBQVEsQ0FBQyxHQUFHLElBQUEsb0JBQWMsRUFBQyxDQUFDO0VBQzNDLE1BQU0sT0FBTyxHQUFHLENBQUEsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLE9BQU8sTUFBSSxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsT0FBTzs7RUFFaEQ7RUFDQSxNQUFNLGFBQWEsR0FBRyxJQUFBLGNBQU8sRUFDM0IsTUFDRSxPQUFPLElBQUksS0FBSyxhQUFMLEtBQUssZUFBTCxLQUFLLENBQUUsT0FBTyxHQUNyQixJQUFBLGdCQUFZLEVBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxJQUFBLGlDQUFlLEVBQUMsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLE9BQU8sQ0FBQyxHQUN6RCxTQUFTLEVBQ2YsQ0FBQyxPQUFPLEVBQUUsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLE9BQU8sQ0FDMUIsQ0FBQztFQUNELE1BQU0sZ0JBQWdCLEdBQUcsSUFBQSxjQUFPLEVBQzlCLE1BQU8sT0FBTyxHQUFHLElBQUEsaUNBQWUsRUFBQyxPQUFPLENBQUMsR0FBRyxTQUFVLEVBQ3RELENBQUMsT0FBTyxDQUNWLENBQUM7RUFDRCxNQUFNLGlCQUFpQixHQUFHLElBQUEsY0FBTyxFQUMvQixNQUFPLE9BQU8sR0FBRyxJQUFBLGtDQUFnQixFQUFDLE9BQU8sQ0FBQyxHQUFHLFNBQVUsRUFDdkQsQ0FBQyxPQUFPLENBQ1YsQ0FBQztFQUNELE1BQU0sYUFBYSxHQUFHLEtBQUssR0FBRyxDQUFBLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxRQUFRLE1BQUssSUFBSSxHQUFHLFNBQVM7RUFFbEUsT0FBTyxJQUFBLGNBQU8sRUFDWixPQUFPO0lBQ0wsYUFBYTtJQUNiLG1CQUFtQixFQUFFLGFBQWEsSUFBSSxhQUFhO0lBQ25ELGdCQUFnQixFQUFFLGdCQUFnQixJQUFJLGlCQUFpQjtJQUN2RCxzQkFBc0IsRUFDbkIsZ0JBQWdCLElBQUksYUFBYSxJQUNqQyxpQkFBaUIsSUFBSSxhQUFjO0lBQ3RDLGdCQUFnQjtJQUNoQjtFQUNGLENBQUMsQ0FBQyxFQUNGLENBQUMsYUFBYSxFQUFFLGdCQUFnQixFQUFFLGFBQWEsRUFBRSxpQkFBaUIsQ0FDcEUsQ0FBQztBQUNILENBQUM7QUFBQyxPQUFBLENBQUEsV0FBQSxHQUFBLFdBQUE7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDekNGLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFdBQUEsR0FBQSxPQUFBO0FBRUEsSUFBQSxjQUFBLEdBQUEsT0FBQTtBQUlBLElBQUEsUUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLHNCQUFBLEdBQUEsc0JBQUEsQ0FBQSxPQUFBO0FBQTRELFNBQUEsdUJBQUEsQ0FBQSxXQUFBLENBQUEsSUFBQSxDQUFBLENBQUEsVUFBQSxHQUFBLENBQUEsS0FBQSxPQUFBLEVBQUEsQ0FBQTtBQUU1RCxNQUFNLHFCQUFxQixHQUFHLENBQUEsS0FBTTtFQUNsQyxNQUFNLFFBQVEsR0FBRyxJQUFBLHVCQUFXLEVBQUMsQ0FBQztFQUM5QixNQUFNO0lBQUU7RUFBb0IsQ0FBQyxHQUFHLElBQUEsMEJBQWlCLEVBQUMsQ0FBQztFQUNuRCxNQUFNLE1BQU0sR0FBRyxJQUFBLDhCQUFxQixFQUFDLENBQUM7RUFDdEMsTUFBTSxPQUFPLEdBQUcsbUJBQW1CLGFBQW5CLG1CQUFtQix1QkFBbkIsbUJBQW1CLENBQUUsRUFBWTtFQUVqRCxJQUFBLGdCQUFTLEVBQUMsTUFBTTtJQUNkLFFBQVEsQ0FBQyxJQUFBLDJCQUFZLEVBQUMsT0FBTyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0VBQ3pDLENBQUMsRUFBRSxDQUFDLE1BQU0sRUFBRSxPQUFPLENBQUMsQ0FBQztFQUVyQixJQUFBLGdCQUFTLEVBQUMsTUFBTTtJQUNkLE9BQU8sTUFBTTtNQUNYLFFBQVEsQ0FBQyxJQUFBLDBCQUFXLEVBQUMsT0FBTyxDQUFDLENBQUM7SUFDaEMsQ0FBQztFQUNILENBQUMsRUFBRSxFQUFFLENBQUM7QUFDUixDQUFDO0FBQUMsSUFBQSxRQUFBLEdBQUEsT0FBQSxDQUFBLE9BQUEsR0FFYSxxQkFBcUI7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDM0JwQyxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxlQUFBLEdBQUEsT0FBQTtBQUdBLElBQUEsMEJBQUEsR0FBQSxPQUFBO0FBRUEsTUFBTSxlQUFlLEdBQUksbUJBQWtDLElBQUs7RUFDOUQsTUFBTTtJQUFFO0VBQWEsQ0FBQyxHQUFHLElBQUEsb0RBQXlCLEVBQUMsQ0FBQztFQUNwRCxNQUFNO0lBQUUsRUFBRSxFQUFFO0VBQVEsQ0FBQyxHQUFHLElBQUEseUJBQVMsRUFBaUIsQ0FBQztFQUNuRCxNQUFNLGNBQWMsR0FBRyxtQkFBbUIsYUFBbkIsbUJBQW1CLHVCQUFuQixtQkFBbUIsQ0FBRSxFQUFFO0VBRTlDLElBQUEsZ0JBQVMsRUFBQyxNQUFNO0lBQ2QsSUFBSSxDQUFDLGNBQWMsRUFBRTtNQUNuQjtJQUNGO0lBRUEsSUFBSSxDQUFDLE9BQU8sRUFBRTtNQUNaLFlBQVksQ0FBQyxjQUFjLENBQUM7SUFDOUI7RUFDRixDQUFDLEVBQUUsQ0FBQyxjQUFjLEVBQUUsT0FBTyxFQUFFLFlBQVksQ0FBQyxDQUFDO0FBQzdDLENBQUM7QUFBQyxJQUFBLFFBQUEsR0FBQSxPQUFBLENBQUEsT0FBQSxHQUVhLGVBQWU7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDdEI5QixJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxnQkFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE9BQUEsR0FBQSxPQUFBO0FBRU8sTUFBTSw2QkFBNkIsR0FBRyxDQUFBLEtBQU07RUFDakQsTUFBTTtJQUFFO0VBQWMsQ0FBQyxHQUFHLElBQUEscUNBQW9CLEVBQUMsQ0FBQztFQUVoRCxNQUFNLHlCQUF5QixHQUFHLElBQUEsY0FBTyxFQUFDLE1BQU07SUFDOUMsT0FBTyxJQUFBLHFDQUE2QixFQUFDLGFBQWEsQ0FBQztFQUNyRCxDQUFDLEVBQUUsQ0FBQyxhQUFhLENBQUMsQ0FBQztFQUVuQixPQUFPLHlCQUF5QjtBQUNsQyxDQUFDO0FBQUMsT0FBQSxDQUFBLDZCQUFBLEdBQUEsNkJBQUE7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDWEYsSUFBQSxnQkFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFFBQUEsR0FBQSxPQUFBO0FBRU8sU0FBUyxpQ0FBaUMsQ0FBQSxFQUFHO0VBQUEsSUFBQSxxQkFBQTtFQUNsRCxNQUFNO0lBQUU7RUFBb0IsQ0FBQyxHQUFHLElBQUEsMEJBQWlCLEVBQWtCLENBQUM7RUFDcEUsTUFBTTtJQUFFLGlCQUFpQjtJQUFFLE1BQU07SUFBRTtFQUFlLENBQUMsR0FBRyxtQkFBbUI7RUFFekUsTUFBTSxnQkFBZ0IsR0FBRyxDQUFDLE1BQU0sSUFBSSxNQUFNLEtBQUssZ0NBQWU7RUFDOUQsTUFBTSxVQUFVLEdBQUcsT0FBTyxDQUFDLGlCQUFpQixDQUFDO0VBRTdDLE1BQU0saUJBQWlCLEdBQ3JCLE9BQU8sQ0FBQyxjQUFjLGFBQWQsY0FBYyx1QkFBZCxjQUFjLENBQUUsbUJBQW1CLENBQUMsSUFDNUMsT0FBTyxDQUFDLGNBQWMsYUFBZCxjQUFjLGdCQUFBLHFCQUFBLEdBQWQsY0FBYyxDQUFFLG1CQUFtQixjQUFBLHFCQUFBLHVCQUFuQyxxQkFBQSxDQUFxQyxNQUFNLENBQUM7RUFFdEQsT0FDRSxPQUFPLENBQUMsR0FBRyxDQUFDLDJCQUEyQixJQUN2QyxDQUFDLGdCQUFnQixJQUNqQixVQUFVLElBQ1YsaUJBQWlCO0FBRXJCOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ3JCQSxJQUFBLHNCQUFBLEdBQUEsT0FBQTtBQUlBLElBQUEsV0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE9BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsVUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFFBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxlQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsUUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFdBQUEsR0FBQSxPQUFBO0FBS08sU0FBUyxxQkFBcUIsQ0FBQSxFQUFHO0VBQ3RDLE1BQU0sUUFBUSxHQUFHLElBQUEsdUJBQVcsRUFBQyxDQUFDO0VBQzlCLE1BQU0sZ0JBQWdCLEdBQUcsSUFBQSx1QkFBVyxFQUFDLDhCQUFtQixDQUFDO0VBQ3pELE1BQU0sbUJBQW1CLEdBQUcsSUFBQSxzQ0FBc0IsRUFBQyxDQUFDO0VBQ3BELE1BQU07SUFBRSxtQkFBbUIsRUFBRTtFQUFnQixDQUFDLEdBQzVDLElBQUEsMEJBQWlCLEVBQWtCLENBQUM7RUFDdEMsTUFBTSxrQkFBa0IsR0FBRyxJQUFBLHVCQUFXLEVBQUUsS0FBNkIsSUFDbkUsSUFBQSxpQ0FBcUIsRUFBQyxLQUFLLEVBQUUsZUFBZSxhQUFmLGVBQWUsdUJBQWYsZUFBZSxDQUFFLE9BQU8sQ0FDdkQsQ0FBQztFQUVELE1BQU0sa0JBQWtCLEdBQUcsSUFBQSxjQUFPLEVBQ2hDLE1BQU0sSUFBQSxpQkFBUyxFQUFDLGVBQWUsQ0FBQyxFQUNoQyxDQUFDLGVBQWUsQ0FDbEIsQ0FBQztFQUVELE1BQU0sc0JBQXNCLEdBQUcsSUFBQSxrQkFBVyxFQUFDLE1BQU07SUFDL0MsSUFBSSxDQUFDLG1CQUFtQixFQUFFO01BQ3hCO0lBQ0Y7SUFFQSxrQkFBa0IsQ0FBQyxpQkFBaUIsR0FBRyxDQUNyQztNQUNFLEdBQUcsbUJBQW1CLENBQUMsbUJBQW1CO01BQzFDLElBQUksRUFBRSxzQ0FBZSxDQUFDO0lBQ3hCLENBQUMsQ0FDRjtJQUVELGtCQUFrQixDQUFDLFFBQVEsQ0FBQyxHQUFHLEdBQUcsbUJBQW1CLENBQUMsR0FBRztJQUN6RCxrQkFBa0IsQ0FBQyxRQUFRLENBQUMsWUFBWSxHQUFHLG1CQUFtQixDQUFDLFlBQVk7SUFFM0Usa0JBQWtCLENBQUMsUUFBUSxDQUFDLG9CQUFvQixHQUM5QyxtQkFBbUIsQ0FBQyxvQkFBb0I7RUFDNUMsQ0FBQyxFQUFFLENBQUMsbUJBQW1CLEVBQUUsa0JBQWtCLENBQUMsQ0FBQztFQUU3QyxNQUFNLGlCQUFpQixHQUFHLElBQUEsa0JBQVcsRUFBQyxNQUFNO0lBQzFDLGtCQUFrQixDQUFDLGNBQWMsR0FBRyxJQUFJO0VBQzFDLENBQUMsRUFBRSxDQUFDLGtCQUFrQixDQUFDLENBQUM7RUFFeEIsTUFBTSxvQkFBb0IsR0FBRyxJQUFBLGtCQUFXLEVBQUMsWUFBWTtJQUNuRCxrQkFBa0IsQ0FBQyxnQkFBZ0IsR0FBRyxnQkFBZ0I7SUFFdEQsSUFBSSxrQkFBa0IsRUFBRTtNQUN0QixzQkFBc0IsQ0FBQyxDQUFDO0lBQzFCLENBQUMsTUFBTSxJQUFJLG1CQUFtQixFQUFFO01BQzlCLGlCQUFpQixDQUFDLENBQUM7SUFDckI7SUFFQSxNQUFNLFFBQVEsQ0FBQyxJQUFBLDJCQUFrQixFQUFDLGtCQUFrQixFQUFFLElBQUksRUFBRSxFQUFFLENBQUMsQ0FBQztFQUNsRSxDQUFDLEVBQUUsQ0FDRCxnQkFBZ0IsRUFDaEIsUUFBUSxFQUNSLGlCQUFpQixFQUNqQixzQkFBc0IsRUFDdEIsa0JBQWtCLEVBQ2xCLGtCQUFrQixFQUNsQixtQkFBbUIsQ0FDcEIsQ0FBQztFQUVGLE9BQU87SUFDTDtFQUNGLENBQUM7QUFDSDs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUM3RUEsSUFBQSxPQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFdBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxTQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsVUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFFBQUEsR0FBQSxPQUFBO0FBSUEsSUFBQSxZQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsWUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLGdCQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsVUFBQSxHQUFBLE9BQUE7QUFFTyxTQUFTLGVBQWUsQ0FDN0IsWUFBWSxFQUNaLFdBQVcsRUFDWCxlQUFlLEVBQ2YsT0FBTyxFQUNQO0VBQ0EsTUFBTSxRQUFRLEdBQUcsSUFBQSx1QkFBVyxFQUFDLENBQUM7O0VBRTlCO0VBQ0EsTUFBTSxJQUFJLEdBQUcsSUFBQSx1QkFBVyxFQUFFLEtBQUssSUFBSyxJQUFBLDhCQUFtQixFQUFDLEtBQUssRUFBRSxPQUFPLENBQUMsQ0FBQztFQUN4RSxNQUFNLE1BQU0sR0FBRyxJQUFBLHVCQUFXLEVBQ3ZCLEtBQUssSUFBSyxJQUFBLDRCQUFrQixFQUFDLEtBQUssRUFBRSxPQUFPLENBQUMsRUFDN0MsZUFDRixDQUFDO0VBQ0QsTUFBTSxZQUFZLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBRSxLQUFLLElBQ3JDLElBQUEsbUNBQXNCLEVBQUMsS0FBSyxDQUFDLE9BQU8sRUFBRSxZQUFZLENBQ3BELENBQUM7O0VBRUQ7RUFDQSxNQUFNLENBQUMsWUFBWSxFQUFFLGVBQWUsQ0FBQyxHQUFHLElBQUEsZUFBUSxFQUFDLElBQUksQ0FBQztFQUN0RCxNQUFNO0lBQUU7RUFBbUIsQ0FBQyxHQUFHLElBQUEsZ0NBQWUsRUFBQztJQUM3QyxNQUFNLEVBQUUsWUFBWSxHQUFHLENBQUMsWUFBWSxDQUFDLEdBQUc7RUFDMUMsQ0FBQyxDQUFDOztFQUVGO0VBQ0EsTUFBTSxnQkFBZ0IsR0FBRyxJQUFBLHdCQUFXLEVBQUMsWUFBWSxDQUFDO0VBQ2xELE1BQU0sZUFBZSxHQUFHLElBQUEsd0JBQVcsRUFBQyxXQUFXLENBQUM7RUFDaEQsTUFBTSxtQkFBbUIsR0FBRyxJQUFBLHdCQUFXLEVBQUMsZUFBZSxDQUFDO0VBQ3hELE1BQU0sZ0JBQWdCLEdBQUcsSUFBQSx3QkFBVyxFQUFDLGtCQUFrQixDQUFDO0VBRXhELElBQUEsZ0JBQVMsRUFBQyxNQUFNO0lBQ2QsSUFBSSxDQUFDLFlBQVksSUFBSSxDQUFDLFdBQVcsSUFBSSxDQUFDLGVBQWUsRUFBRTtNQUNyRDtJQUNGO0lBRUEsZUFBZSxxQkFBcUIsQ0FBQSxFQUFHO01BQ3JDLFFBQVEsQ0FBQyxJQUFBLDhCQUFxQixFQUFDLENBQUMsQ0FBQztNQUNqQyxJQUFJO1FBQ0YsTUFBTSxZQUFZLEdBQUcsTUFBTSxJQUFBLDBCQUFlLEVBQ3hDLFlBQVksRUFDWixXQUFXLEVBQ1gsZUFBZSxFQUNmLElBQUksRUFDSixPQUNGLENBQUM7UUFDRCxlQUFlLENBQUMsWUFBWSxDQUFDO01BQy9CLENBQUMsQ0FBQyxPQUFPLENBQUMsRUFBRTtRQUNWLE9BQU8sQ0FBQyxJQUFJLENBQUMsNkJBQTZCLEVBQUU7VUFDMUMsS0FBSyxFQUFFLENBQUM7VUFDUjtRQUNGLENBQUMsQ0FBQztNQUNKO01BQ0EsUUFBUSxDQUFDLElBQUEsOEJBQXFCLEVBQUMsQ0FBQyxDQUFDO0lBQ25DO0lBQ0EsSUFDRSxZQUFZLEtBQUssZ0JBQWdCLElBQ2pDLFdBQVcsS0FBSyxlQUFlLElBQy9CLGVBQWUsS0FBSyxtQkFBbUIsSUFDdEMsZ0JBQWdCLElBQUksZ0JBQWdCLEtBQUssa0JBQW1CLEVBQzdEO01BQ0EscUJBQXFCLENBQUMsQ0FBQztJQUN6QjtFQUNGLENBQUMsRUFBRSxDQUNELE9BQU8sRUFDUCxRQUFRLEVBQ1IsZ0JBQWdCLEVBQ2hCLG1CQUFtQixFQUNuQixlQUFlLEVBQ2YsWUFBWSxFQUNaLFdBQVcsRUFDWCxlQUFlLEVBQ2YsSUFBSSxFQUNKLGtCQUFrQixFQUNsQixnQkFBZ0IsQ0FDakIsQ0FBQztFQUVGLElBQUksQ0FBQyxZQUFZLElBQUksQ0FBQyxXQUFXLElBQUksQ0FBQyxlQUFlLEVBQUU7SUFDckQsT0FBTyxDQUFDLENBQUM7RUFDWDtFQUVBLElBQUksWUFBWSxFQUFFO0lBQ2hCLE1BQU07TUFDSixRQUFRO01BQ1IsTUFBTTtNQUNOLEtBQUs7TUFDTCxJQUFJO01BQ0osT0FBTztNQUNQLE9BQU87TUFDUCxTQUFTO01BQ1QsV0FBVztNQUNYLFFBQVE7TUFDUjtJQUNGLENBQUMsR0FBRyxZQUFZO0lBRWhCLE9BQU87TUFDTCxTQUFTO01BQ1QsT0FBTztNQUNQLFFBQVE7TUFDUixXQUFXO01BQ1gsWUFBWSxFQUFFLFlBQVk7TUFDMUIsYUFBYSxFQUFFLFFBQVE7TUFDdkIsV0FBVyxFQUFFLE1BQU0sSUFBSSxFQUFFO01BQ3pCLFVBQVUsRUFBRSxLQUFLO01BQ2pCLFdBQVcsRUFBRSxPQUFPO01BQ3BCLFNBQVMsRUFBRSxJQUFJO01BQ2Y7SUFDRixDQUFDO0VBQ0g7RUFFQSxPQUFPLENBQUMsQ0FBQztBQUNYOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQzNIQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxXQUFBLEdBQUEsT0FBQTtBQUVBLElBQUEsWUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFNBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxRQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsc0JBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxRQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsNkJBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxzQkFBQSxHQUFBLE9BQUE7QUFFTyxTQUFTLDZCQUE2QixDQUFBLEVBQUc7RUFBQSxJQUFBLHFCQUFBLEVBQUEsY0FBQTtFQUM5QyxNQUFNLFFBQVEsR0FBRyxJQUFBLHVCQUFXLEVBQUMsQ0FBQztFQUM5QixNQUFNO0lBQUUsV0FBVyxFQUFFLGtCQUFrQjtJQUFFO0VBQW1CLENBQUMsR0FDM0QsSUFBQSw0Q0FBcUIsRUFBQyxDQUFDO0VBQ3pCLE1BQU0sQ0FBQyxVQUFVLEVBQUUsYUFBYSxDQUFDLEdBQUcsSUFBQSxlQUFRLEVBQUMsSUFBSSxDQUFDO0VBRWxELE1BQU07SUFBRSxtQkFBbUIsRUFBRTtFQUFnQixDQUFDLEdBQzVDLElBQUEsMEJBQWlCLEVBQWtCLENBQUM7RUFFdEMsTUFBTSxzQkFBc0IsR0FBRyxPQUFPLEVBQUEscUJBQUEsR0FDcEMsSUFBQSwwREFBNEIsRUFBQyxDQUFDLGNBQUEscUJBQUEsdUJBQTlCLHFCQUFBLENBQWdDLE1BQ2xDLENBQUM7RUFFRCxNQUFNO0lBQ0osWUFBWTtJQUNaLEVBQUUsRUFBRSxhQUFhO0lBQ2pCO0VBQ0YsQ0FBQyxHQUFHLGVBQWU7RUFFbkIsSUFBSSx1QkFBdUIsR0FBRyxZQUFZLGFBQVosWUFBWSxnQkFBQSxjQUFBLEdBQVosWUFBWSxDQUFHLENBQUMsQ0FBQyxjQUFBLGNBQUEsdUJBQWpCLGNBQUEsQ0FBbUIsWUFBWTtFQUU3RCxJQUFJLENBQUMsa0JBQWtCLElBQUksdUJBQXVCLEtBQUssaUNBQW9CLEVBQUU7SUFBQSxJQUFBLGVBQUE7SUFDM0UsdUJBQXVCLEdBQUcsWUFBWSxhQUFaLFlBQVksZ0JBQUEsZUFBQSxHQUFaLFlBQVksQ0FBRyxDQUFDLENBQUMsY0FBQSxlQUFBLHVCQUFqQixlQUFBLENBQW1CLFlBQVk7RUFDM0Q7RUFFQSxNQUFNLGdCQUFnQixHQUFHLElBQUEsa0JBQVcsRUFBQyxZQUFZO0lBQy9DLE1BQU0sSUFBQSxnREFBeUIsRUFBQyxhQUFhLEVBQUUsdUJBQXVCLENBQUM7SUFDdkUsTUFBTSxJQUFBLGlDQUF3QixFQUFDLFFBQVEsQ0FBQztFQUMxQyxDQUFDLEVBQUUsQ0FBQyxRQUFRLEVBQUUsYUFBYSxFQUFFLHVCQUF1QixDQUFDLENBQUM7RUFFdEQsTUFBTSxZQUFZLEdBQ2hCLGtCQUFrQixJQUNsQixzQkFBc0IsSUFDdEIsQ0FBQyxtQkFBbUIsSUFDcEIsT0FBTyxDQUFDLHVCQUF1QixDQUFDO0VBRWxDLElBQUEsd0JBQWMsRUFBQyxZQUFZO0lBQ3pCLElBQUksQ0FBQyxZQUFZLElBQUksQ0FBQyxhQUFhLElBQUksQ0FBQyxVQUFVLEVBQUU7TUFDbEQ7SUFDRjtJQUVBLGFBQWEsQ0FBQyxLQUFLLENBQUM7SUFFcEIsSUFBSSxZQUFZLEVBQUU7TUFDaEIsTUFBTSxnQkFBZ0IsQ0FBQyxDQUFDO0lBQzFCO0VBQ0YsQ0FBQyxFQUFFLENBQUMsWUFBWSxFQUFFLGdCQUFnQixFQUFFLFVBQVUsRUFBRSxZQUFZLEVBQUUsYUFBYSxDQUFDLENBQUM7QUFDL0U7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDM0RBLElBQUEsV0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFVBQUEsR0FBQSxPQUFBO0FBT0EsSUFBQSxRQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsMkJBQUEsR0FBQSxPQUFBO0FBRU8sTUFBTSxVQUFVLEdBQUksV0FBVyxJQUFLO0VBQ3pDLE1BQU0sMkJBQTJCLEdBQUcsSUFBQSx1QkFBVyxFQUM3Qyx5Q0FDRixDQUFDO0VBRUQsTUFBTSxXQUFXLEdBQUcsSUFBQSx1QkFBVyxFQUFFLEtBQUssSUFDcEMsSUFBQSxzQ0FBMkIsRUFBQyxLQUFLLEVBQUUsV0FBVyxDQUNoRCxDQUFDO0VBRUQsTUFBTTtJQUFFO0VBQWdCLENBQUMsR0FBRyxJQUFBLHNEQUEwQixFQUNwRCxXQUFXLEVBQ1gsMkJBQ0YsQ0FBQztFQUVELE1BQU0sY0FBYyxHQUFHLElBQUEsdUJBQVcsRUFBQyw0QkFBaUIsQ0FBQztFQUVyRCxNQUFNLGtCQUFrQixHQUFHLElBQUEsdUJBQVcsRUFBQyxnQ0FBcUIsQ0FBQztFQUM3RCxNQUFNLFFBQVEsR0FDWixzQkFBYSxDQUFDLFFBQVEsQ0FBQyxjQUFjLGFBQWQsY0FBYyx1QkFBZCxjQUFjLENBQUUsUUFBUSxDQUFDLElBQUksQ0FBQyxrQkFBa0I7RUFFekUsSUFBSSxZQUFZLEdBQUcsZUFBZTtFQUVsQyxNQUFNLE9BQU8sR0FBRyxJQUFBLHVCQUFXLEVBQUMsMENBQStCLENBQUM7RUFFNUQsSUFBSSxDQUFDLFdBQVcsRUFBRTtJQUNoQixPQUFPLENBQUMsQ0FBQztFQUNYO0VBRUEsSUFBSSxRQUFRLEVBQUU7SUFDWixZQUFZLEdBQUcsT0FBTztFQUN4QjtFQUVBLE9BQU87SUFBRSxPQUFPLEVBQUU7RUFBYSxDQUFDO0FBQ2xDLENBQUM7QUFBQyxPQUFBLENBQUEsVUFBQSxHQUFBLFVBQUE7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDekNGLElBQUEsV0FBQSxHQUFBLE9BQUE7QUFFQSxJQUFBLFVBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxZQUFBLEdBQUEsT0FBQTtBQVFPLE1BQU0sNkJBQTZCLEdBQUcsQ0FBQyxJQUFTLEVBQUUsT0FBWSxLQUFLO0VBQ3hFLE1BQU0sWUFBWSxHQUFHLElBQUEsdUJBQVcsRUFBQywwQkFBZSxDQUFDO0VBRWpELE1BQU0sc0JBQXNCLEdBQUcsWUFBWSxDQUFDLE1BQU0sQ0FDL0MsV0FBNEIsSUFBSztJQUFBLElBQUEscUJBQUE7SUFDaEMsT0FDRSxXQUFXLENBQUMsT0FBTyxLQUFLLE9BQU8sSUFDL0IsNkNBQWdDLENBQUMsUUFBUSxDQUFDLFdBQVcsQ0FBQyxNQUFNLENBQUMsSUFDN0QsQ0FBQyxFQUFBLHFCQUFBLEdBQUEsV0FBVyxDQUFDLFFBQVEsQ0FBQyxpQkFBaUIsY0FBQSxxQkFBQSx1QkFBdEMscUJBQUEsQ0FBd0MsTUFBTSxLQUFJLENBQUMsSUFBSSxDQUFDLElBQ3pELFdBQVcsQ0FBQyxRQUFRLENBQUMsSUFBSSxLQUFLLElBQUk7RUFFdEMsQ0FDRixDQUFDO0VBRUQsT0FBTztJQUFFLGtCQUFrQixFQUFFLHNCQUFzQixDQUFDLE1BQU0sR0FBRztFQUFFLENBQUM7QUFDbEUsQ0FBQztBQUFDLE9BQUEsQ0FBQSw2QkFBQSxHQUFBLDZCQUFBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQzdCRixJQUFBLFdBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUVBLElBQUEsV0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFNBQUEsR0FBQSxPQUFBO0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLE1BQU0sOEJBQThCLEdBQUcsQ0FBQSxLQUFNO0VBQ2xELE1BQU0scUNBQXFDLEdBQUcsSUFBQSx1QkFBVyxFQUN2RCxrREFDRixDQUFDO0VBRUQsTUFBTSwyQkFBMkIsR0FBRyxJQUFBLGNBQU8sRUFBQyxNQUFNO0lBQ2hELE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUdqQixDQUFDO0lBRUgsTUFBTSxDQUFDLE1BQU0sQ0FBQyxxQ0FBcUMsQ0FBQyxDQUFDLE9BQU8sQ0FBRSxPQUFPLElBQUs7TUFDeEUsTUFBTSxPQUFPLEdBQUcsT0FBTyxDQUFDLE9BQWM7TUFDdEMsTUFBTSxpQkFBaUIsR0FBRyxJQUFBLDhCQUFrQixFQUFDLE9BQU8sQ0FBQztNQUNyRCxNQUFNLGdCQUFnQixHQUFHLE9BQU8sYUFBUCxPQUFPLHVCQUFQLE9BQU8sQ0FBRSxJQUFJO01BRXRDLEdBQUcsQ0FBQyxHQUFHLENBQUMsT0FBTyxFQUFFO1FBQ2YsV0FBVyxFQUFFLGdCQUFnQixJQUFJLEVBQUU7UUFDbkMsWUFBWSxFQUFFLGlCQUFpQixJQUFJO01BQ3JDLENBQUMsQ0FBQztJQUNKLENBQUMsQ0FBQztJQUVGLE9BQU8sR0FBRztFQUNaLENBQUMsRUFBRSxDQUFDLHFDQUFxQyxDQUFDLENBQUM7RUFFM0MsT0FBTywyQkFBMkI7QUFDcEMsQ0FBQztBQUFDLE9BQUEsQ0FBQSw4QkFBQSxHQUFBLDhCQUFBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ3BDRixJQUFBLFVBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsV0FBQSxHQUFBLE9BQUE7QUFHQSxJQUFBLG1CQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsUUFBQSxHQUFBLE9BQUE7QUFLQSxJQUFBLFFBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSx5QkFBQSxHQUFBLE9BQUE7QUFFTyxNQUFNLGlCQUFpQixHQUFHLENBQUEsS0FBTTtFQUNyQyxNQUFNLFFBQVEsR0FBRyxJQUFBLHVCQUFXLEVBQUMsQ0FBQztFQUM5QixNQUFNO0lBQUU7RUFBb0IsQ0FBQyxHQUFHLElBQUEsMEJBQWlCLEVBQWtCLENBQUM7RUFDcEUsTUFBTTtJQUFFO0VBQW1CLENBQUMsR0FBRyxJQUFBLGtEQUF3QixFQUFDLENBQUM7RUFDekQsTUFBTTtJQUFFLEVBQUUsRUFBRTtFQUFzQixDQUFDLEdBQUcsbUJBQW1CLElBQUksQ0FBQyxDQUFDO0VBRS9ELE1BQU0sY0FBYyxHQUFHLElBQUEsa0JBQVcsRUFDaEMsQ0FBQztJQUFFO0VBQWtELENBQUMsR0FBRyxDQUFDLENBQUMsS0FBSztJQUM5RCxJQUFJLENBQUMscUJBQXFCLEVBQUU7TUFDMUI7SUFDRjtJQUVBLE1BQU0sS0FBSyxHQUFHLHlCQUFjLENBQUMsbUJBQW1CLENBQUMsQ0FBQztJQUNsRCxLQUFLLENBQUMsSUFBSSxHQUFHO01BQUU7SUFBUyxDQUFDO0lBRXpCLE1BQU0sZUFBZSxHQUFHLElBQUEseUJBQWMsRUFBQyxLQUFLLENBQUM7SUFDN0MsUUFBUSxDQUFDLElBQUEsOEJBQXFCLEVBQUMscUJBQXFCLEVBQUUsZUFBZSxDQUFDLENBQUM7RUFDekUsQ0FBQyxFQUNELENBQUMscUJBQXFCLEVBQUUsUUFBUSxDQUNsQyxDQUFDO0VBRUQsTUFBTSxxQkFBcUIsR0FBRyxJQUFBLGtCQUFXLEVBQUMsTUFBTTtJQUM5QyxRQUFRLENBQUMsSUFBQSwwQkFBaUIsRUFBQyxFQUFFLENBQUMsQ0FBQztJQUMvQixRQUFRLENBQUMsSUFBQSxxQkFBWSxFQUFDLEVBQUUsQ0FBQyxDQUFDO0lBQzFCLFFBQVEsQ0FBQyxJQUFBLDJDQUF1QixFQUFDLENBQUMsQ0FBQztFQUNyQyxDQUFDLEVBQUUsQ0FBQyxRQUFRLENBQUMsQ0FBQztFQUVkLE1BQU0sUUFBUSxHQUFHLElBQUEsa0JBQVcsRUFDMUIsQ0FBQztJQUNDLFFBQVE7SUFDUixtQkFBbUIsR0FBRztFQUl4QixDQUFDLEtBQUs7SUFDSixJQUFJLENBQUMsbUJBQW1CLEVBQUU7TUFDeEI7SUFDRjtJQUNBLElBQUksbUJBQW1CLEVBQUU7TUFDdkIsa0JBQWtCLENBQUMsQ0FBQztJQUN0QjtJQUNBLGNBQWMsQ0FBQztNQUFFO0lBQVMsQ0FBQyxDQUFDO0lBQzVCLHFCQUFxQixDQUFDLENBQUM7RUFDekIsQ0FBQyxFQUNELENBQ0UsbUJBQW1CLEVBQ25CLGtCQUFrQixFQUNsQixjQUFjLEVBQ2QscUJBQXFCLENBRXpCLENBQUM7RUFFRCxPQUFPO0lBQUUsUUFBUTtJQUFFO0VBQXNCLENBQUM7QUFDNUMsQ0FBQztBQUFDLE9BQUEsQ0FBQSxpQkFBQSxHQUFBLGlCQUFBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ3BFRixJQUFBLHNCQUFBLEdBQUEsT0FBQTtBQUlBLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLGVBQUEsR0FBQSxPQUFBO0FBRUEsSUFBQSxRQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsc0JBQUEsR0FBQSxPQUFBO0FBRUEsTUFBTSxvQkFBb0IsR0FBRyxDQUMzQixzQ0FBZSxDQUFDLFVBQVUsRUFDMUIsc0NBQWUsQ0FBQyxtQkFBbUIsRUFDbkMsc0NBQWUsQ0FBQyx1QkFBdUIsRUFDdkMsc0NBQWUsQ0FBQywyQkFBMkIsQ0FDNUM7QUFFTSxNQUFNLHdCQUF3QixHQUFHLENBQUEsS0FBTTtFQUM1QyxNQUFNLE9BQU8sR0FBRyxJQUFBLDBCQUFVLEVBQUMsQ0FBQztFQUM1QixNQUFNO0lBQUU7RUFBb0IsQ0FBQyxHQUFHLElBQUEsMEJBQWlCLEVBQWtCLENBQUM7RUFDcEUsTUFBTTtJQUFFLE9BQU8sRUFBRTtFQUFzQixDQUFDLEdBQUcsSUFBQSw0Q0FBcUIsRUFBQyxDQUFDO0VBRWxFLE1BQU0sa0JBQWtCLEdBQUcsSUFBQSxrQkFBVyxFQUFDLE1BQU07SUFDM0MsSUFBSSxDQUFDLHFCQUFxQixFQUFFO01BQzFCO0lBQ0Y7SUFDQSxNQUFNO01BQUUsTUFBTTtNQUFFO0lBQUssQ0FBQyxHQUFHLG1CQUFtQjtJQUM1QyxJQUFJLE1BQU0sS0FBSyxVQUFVLElBQUksSUFBSSxJQUFJLG9CQUFvQixDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsRUFBRTtNQUN4RSxPQUFPLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDbEI7RUFDRixDQUFDLEVBQUUsQ0FBQyxtQkFBbUIsRUFBRSxPQUFPLEVBQUUscUJBQXFCLENBQUMsQ0FBQztFQUV6RCxPQUFPO0lBQUU7RUFBbUIsQ0FBQztBQUMvQixDQUFDO0FBQUMsT0FBQSxDQUFBLHdCQUFBLEdBQUEsd0JBQUE7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDakNGLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFVBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxTQUFBLEdBQUEsc0JBQUEsQ0FBQSxPQUFBO0FBQ0EsSUFBQSxpQkFBQSxHQUFBLE9BQUE7QUFBaUYsU0FBQSx1QkFBQSxDQUFBLFdBQUEsQ0FBQSxJQUFBLENBQUEsQ0FBQSxVQUFBLEdBQUEsQ0FBQSxLQUFBLE9BQUEsRUFBQSxDQUFBO0FBRWpGLE1BQU0sMkJBQTJCLEdBQUcsQ0FBQSxLQUFNO0VBQ3hDLE1BQU07SUFBRTtFQUFxQixDQUFDLEdBQUcsSUFBQSxpQkFBUSxFQUFDLENBQUM7RUFDM0MsTUFBTTtJQUFFO0VBQVUsQ0FBQyxHQUFHLElBQUEsNENBQTBCLEVBQUMsQ0FBQztFQUVsRCxNQUFNLGFBQWEsR0FBRyxJQUFBLGtCQUFXLEVBQzlCLFNBQWlCLElBQUs7SUFDckIsUUFBUSxTQUFTO01BQ2YsS0FBSyx5QkFBYyxDQUFDLEdBQUc7UUFDckIsb0JBQW9CLENBQUMsQ0FBQztRQUN0QjtNQUVGLEtBQUsseUJBQWMsQ0FBQyx1QkFBdUI7UUFDekMsU0FBUyxDQUFDLGdCQUFnQixDQUFDO1FBQzNCO01BRUYsS0FBSyx5QkFBYyxDQUFDLGVBQWU7UUFDakMsU0FBUyxDQUFDLFlBQVksQ0FBQztRQUN2QjtNQUVGO1FBQ0UsT0FBTyxDQUFDLEtBQUssQ0FBQywyQkFBMkIsRUFBRSxTQUFTLENBQUM7UUFDckQ7SUFDSjtFQUNGLENBQUMsRUFDRCxDQUFDLG9CQUFvQixDQUN2QixDQUFDO0VBRUQsT0FBTyxhQUFhO0FBQ3RCLENBQUM7QUFBQyxJQUFBLFFBQUEsR0FBQSxPQUFBLENBQUEsT0FBQSxHQUVhLDJCQUEyQjs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDbkMxQyxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxLQUFBLEdBQUEsT0FBQTtBQUVBLElBQUEsVUFBQSxHQUFBLHNCQUFBLENBQUEsT0FBQTtBQUNBLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFFQSxJQUFBLFFBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxVQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsMEJBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSw0QkFBQSxHQUFBLE9BQUE7QUFBNEUsU0FBQSx1QkFBQSxDQUFBLFdBQUEsQ0FBQSxJQUFBLENBQUEsQ0FBQSxVQUFBLEdBQUEsQ0FBQSxLQUFBLE9BQUEsRUFBQSxDQUFBO0FBaUJyRSxNQUFNLG1CQUF3RCxHQUFBLE9BQUEsQ0FBQSxtQkFBQSxHQUFHO0VBQ3RFLENBQUMscUJBQVUsQ0FBQyxpQkFBaUIsR0FBRyxxQkFBcUI7RUFDckQsQ0FBQyxxQkFBVSxDQUFDLFNBQVMsR0FBRyxhQUFhO0VBQ3JDLENBQUMscUJBQVUsQ0FBQyxTQUFTLEdBQUcsYUFBYTtFQUNyQyxDQUFDLHFCQUFVLENBQUMsbUJBQW1CLEdBQUcsc0JBQXNCO0VBQ3hELENBQUMscUJBQVUsQ0FBQyxXQUFXLEdBQUcsY0FBYztFQUN4QyxDQUFDLHFCQUFVLENBQUMsVUFBVSxHQUFHLGNBQWM7RUFDdkMsQ0FBQyxxQkFBVSxDQUFDLGtCQUFrQixHQUFHLHFCQUFxQjtFQUN0RCxDQUFDLHFCQUFVLENBQUMsbUJBQW1CLEdBQUcsdUJBQXVCO0VBQ3pELENBQUMscUJBQVUsQ0FBQyxRQUFRLEdBQUc7QUFDekIsQ0FBQzs7QUFFRDtBQUNBO0FBQ0EsU0FBUyxvQkFBb0IsQ0FBSSxLQUFVLEVBQUUsS0FBUSxFQUFPO0VBQzFELE9BQU8sQ0FBQyxHQUFHLElBQUksR0FBRyxDQUFDLENBQUMsR0FBRyxLQUFLLEVBQUUsS0FBSyxDQUFDLENBQUMsQ0FBQztBQUN4QztBQUVBLFNBQVMsYUFBYSxDQUFDLE1BQWUsRUFBWTtFQUNoRCxPQUFPLE1BQU0sQ0FBQyxHQUFHLENBQUUsS0FBSyxJQUFLLFlBQVksQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7QUFDdkQ7QUFFQSxTQUFTLFlBQVksQ0FBQyxRQUFnQixFQUFVO0VBQzlDLE9BQU8sSUFBQSxjQUFNLEVBQUMsUUFBUSxDQUFDLEdBQ25CLG1CQUFtQixDQUFDLHFCQUFVLENBQUMsUUFBUSxDQUFDLEdBQ3ZDLG1CQUFtQixDQUFDLFFBQVEsQ0FBQyxJQUFJLFFBQVM7QUFDakQ7QUFFTyxTQUFTLDJCQUEyQixDQUFBLEVBQUc7RUFDNUMsTUFBTTtJQUFFO0VBQW9CLENBQUMsR0FBRyxJQUFBLDBCQUFpQixFQUFDLENBQUM7RUFDbkQsTUFBTSxPQUFPLEdBQUcsQ0FBQSxtQkFBbUIsYUFBbkIsbUJBQW1CLHVCQUFuQixtQkFBbUIsQ0FBRSxFQUFFLEtBQUksRUFBRTtFQUM3QyxNQUFNO0lBQUUsTUFBTTtJQUFFO0VBQWlCLENBQUMsR0FBRyxJQUFBLGtCQUFTLEVBQUMsT0FBTyxDQUFDO0VBQ3ZELE1BQU07SUFBRTtFQUE2QixDQUFDLEdBQUcsSUFBQSxvREFBeUIsRUFBQyxDQUFDO0VBQ3BFLE1BQU07SUFBRTtFQUErQixDQUFDLEdBQUcsSUFBQSx3REFBMkIsRUFBQyxDQUFDO0VBRXhFLE1BQU0sQ0FBQyxpQkFBaUIsRUFBRSxvQkFBb0IsQ0FBQyxHQUM3QyxJQUFBLGVBQVEsRUFBeUI7SUFDL0I7SUFDQTtJQUNBLGdCQUFnQixFQUFFLEVBQUU7SUFDcEI7SUFDQTtJQUNBLHNCQUFzQixFQUFFLENBQUM7SUFDekI7SUFDQTtJQUNBLGlCQUFpQixFQUFFLEVBQUU7SUFDckI7SUFDQTtJQUNBLG9CQUFvQixFQUFFO0VBQ3hCLENBQUMsQ0FBQztFQUVKLE1BQU0sVUFBVSxHQUNkLE1BQU0sQ0FBQyxNQUFNLEdBQUcsQ0FBQyxHQUNiO0lBQ0U7SUFDQTtJQUNBLHFCQUFxQixFQUFFLE1BQU0sQ0FBQyxNQUFNO0lBQ3BDO0lBQ0E7SUFDQSxlQUFlLEVBQUUsYUFBYSxDQUFDLE1BQU0sQ0FBQztJQUN0QztJQUNBO0lBQ0Esb0JBQW9CLEVBQUUsTUFBTSxDQUFDLE1BQU0sQ0FBRSxLQUFLLElBQ3hDLGdCQUFnQixDQUFDLEtBQUssQ0FBQyxHQUFHLENBQzVCLENBQUMsQ0FBQyxNQUFNO0lBQ1I7SUFDQTtJQUNBLGNBQWMsRUFBRSxhQUFhLENBQzNCLE1BQU0sQ0FBQyxNQUFNLENBQUUsS0FBSyxJQUFLLGdCQUFnQixDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FDdEQsQ0FBQztJQUNELEdBQUc7RUFDTCxDQUFDLEdBQ0QsU0FBUztFQUVmLE1BQU0sZ0JBQWdCLEdBQUcsSUFBQSxrQkFBVyxFQUFFLFFBQWdCLElBQUs7SUFDekQsb0JBQW9CLENBQUUsU0FBUyxJQUFLO01BQ2xDLE1BQU0sUUFBUSxHQUFHO1FBQUUsR0FBRztNQUFVLENBQUM7TUFDakMsTUFBTSxTQUFTLEdBQUcsWUFBWSxDQUFDLFFBQVEsQ0FBQztNQUN4QyxRQUFRLENBQUMsZ0JBQWdCLEdBQUcsb0JBQW9CLENBQzlDLFNBQVMsQ0FBQyxnQkFBZ0IsRUFDMUIsU0FDRixDQUFDO01BQ0QsUUFBUSxDQUFDLHNCQUFzQixHQUFHLFFBQVEsQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNO01BQ2xFLE9BQU8sUUFBUTtJQUNqQixDQUFDLENBQUM7RUFDSixDQUFDLEVBQUUsRUFBRSxDQUFDO0VBRU4sTUFBTSx1QkFBdUIsR0FBRyxJQUFBLGtCQUFXLEVBQUUsUUFBZ0IsSUFBSztJQUNoRSxvQkFBb0IsQ0FBRSxTQUFTLElBQUs7TUFDbEMsTUFBTSxRQUFRLEdBQUc7UUFBRSxHQUFHO01BQVUsQ0FBQztNQUNqQyxNQUFNLFNBQVMsR0FBRyxZQUFZLENBQUMsUUFBUSxDQUFDO01BQ3hDLFFBQVEsQ0FBQyxpQkFBaUIsR0FBRyxvQkFBb0IsQ0FDL0MsU0FBUyxDQUFDLGlCQUFpQixFQUMzQixTQUNGLENBQUM7TUFDRCxPQUFPLFFBQVE7SUFDakIsQ0FBQyxDQUFDO0VBQ0osQ0FBQyxFQUFFLEVBQUUsQ0FBQztFQUVOLE1BQU0sdUJBQXVCLEdBQUcsSUFBQSxrQkFBVyxFQUFFLFFBQWdCLElBQUs7SUFDaEUsb0JBQW9CLENBQUUsU0FBUyxJQUFLO01BQ2xDLE1BQU0sUUFBUSxHQUFHO1FBQUUsR0FBRztNQUFVLENBQUM7TUFDakMsTUFBTSxTQUFTLEdBQUcsWUFBWSxDQUFDLFFBQVEsQ0FBQztNQUN4QyxRQUFRLENBQUMsb0JBQW9CLEdBQUcsb0JBQW9CLENBQ2xELFNBQVMsQ0FBQyxvQkFBb0IsRUFDOUIsU0FDRixDQUFDO01BQ0QsT0FBTyxRQUFRO0lBQ2pCLENBQUMsQ0FBQztFQUNKLENBQUMsRUFBRSxFQUFFLENBQUM7RUFFTixNQUFNLGtCQUFrQixHQUFHLElBQUEsa0JBQVcsRUFBQyxNQUFNO0lBQzNDLElBQUksQ0FBQyxVQUFVLEVBQUU7TUFDZjtJQUNGO0lBRUEsSUFBSSxJQUFBLGlDQUEwQixFQUFDLG1CQUFtQixDQUFDLEVBQUU7TUFDbkQsNEJBQTRCLENBQUM7UUFBRTtNQUFXLENBQUMsQ0FBQztJQUM5QyxDQUFDLE1BQU07TUFDTCw4QkFBOEIsQ0FBQztRQUFFO01BQVcsQ0FBQyxFQUFFLE9BQU8sQ0FBQztJQUN6RDtFQUNGLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLEVBQUUsOEJBQThCLEVBQUUsT0FBTyxDQUFDLENBQUM7RUFFekUsSUFBQSxnQkFBUyxFQUFDLE1BQU07SUFDZCxrQkFBa0IsQ0FBQyxDQUFDO0VBQ3RCLENBQUMsRUFBRSxDQUFDLGtCQUFrQixDQUFDLENBQUM7RUFFeEIsT0FBTztJQUNMLGdCQUFnQjtJQUNoQix1QkFBdUI7SUFDdkI7RUFDRixDQUFDO0FBQ0g7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDOUpBLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFFQSxJQUFBLHlCQUFBLEdBQUEsc0JBQUEsQ0FBQSxPQUFBO0FBQ0EsSUFBQSx3QkFBQSxHQUFBLHNCQUFBLENBQUEsT0FBQTtBQUNBLElBQUEsc0JBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSw2QkFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLDJCQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsbUJBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxtQkFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLDZCQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsMkJBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxvQkFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLDRCQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsNEJBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxxQkFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLDZCQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsa0JBQUEsR0FBQSxzQkFBQSxDQUFBLE9BQUE7QUFDQSxJQUFBLDRCQUFBLEdBQUEsc0JBQUEsQ0FBQSxPQUFBO0FBQ0EsSUFBQSxtQ0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLHlCQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsNEJBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSwyQkFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLDBCQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsdUJBQUEsR0FBQSxPQUFBO0FBQXlFLFNBQUEsdUJBQUEsQ0FBQSxXQUFBLENBQUEsSUFBQSxDQUFBLENBQUEsVUFBQSxHQUFBLENBQUEsS0FBQSxPQUFBLEVBQUEsQ0FBQTtBQUV6RSxTQUFTLGtCQUFrQixDQUFBLEVBQVk7RUFDckMsTUFBTSxxQkFBcUIsR0FBRyxJQUFBLGlDQUF3QixFQUFDLENBQUM7RUFDeEQsTUFBTSxvQkFBb0IsR0FBRyxJQUFBLGdDQUF1QixFQUFDLENBQUM7RUFFdEQsT0FBTyxJQUFBLGNBQU8sRUFDWixNQUFNLENBQUMsR0FBRyxxQkFBcUIsRUFBRSxHQUFHLG9CQUFvQixDQUFDLEVBQ3pELENBQUMscUJBQXFCLEVBQUUsb0JBQW9CLENBQzlDLENBQUM7QUFDSDtBQUVBLFNBQVMsb0JBQW9CLENBQUEsRUFBWTtFQUN2QyxNQUFNLHdCQUF3QixHQUFHLElBQUEsNENBQXFCLEVBQUMsQ0FBQztFQUN4RCxNQUFNLHlCQUF5QixHQUFHLElBQUEsMERBQTRCLEVBQUMsQ0FBQztFQUNoRSxNQUFNLHVCQUF1QixHQUFHLElBQUEsc0RBQTBCLEVBQUMsQ0FBQztFQUM1RCxNQUFNLGVBQWUsR0FBRyxJQUFBLHNDQUFrQixFQUFDLENBQUM7RUFDNUMsTUFBTSxlQUFlLEdBQUcsSUFBQSxzQ0FBa0IsRUFBQyxDQUFDO0VBQzVDLE1BQU0seUJBQXlCLEdBQUcsSUFBQSwwREFBNEIsRUFBQyxDQUFDO0VBQ2hFLE1BQU0sc0JBQXNCLEdBQUcsSUFBQSxzREFBMEIsRUFBQyxDQUFDO0VBQzNELE1BQU0sZ0JBQWdCLEdBQUcsSUFBQSx3Q0FBbUIsRUFBQyxDQUFDO0VBQzlDLE1BQU0sd0JBQXdCLEdBQUcsSUFBQSx3REFBMkIsRUFBQyxDQUFDO0VBQzlELE1BQU0sd0JBQXdCLEdBQUcsSUFBQSx3REFBMkIsRUFBQyxDQUFDO0VBQzlELE1BQU0saUJBQWlCLEdBQUcsSUFBQSwwQ0FBb0IsRUFBQyxDQUFDO0VBQ2hELE1BQU0sbUJBQW1CLEdBQUcsSUFBQSw4Q0FBc0IsRUFBQyxDQUFDO0VBQ3BELE1BQU0seUJBQXlCLEdBQUcsSUFBQSwwREFBNEIsRUFBQyxDQUFDO0VBQ2hFLE1BQU0sc0JBQXNCLEdBQUcsSUFBQSxvREFBeUIsRUFBQyxDQUFDO0VBRTFELE9BQU8sSUFBQSxjQUFPLEVBQ1osTUFBTSxDQUNKLEdBQUcsd0JBQXdCLEVBQzNCLEdBQUcseUJBQXlCLEVBQzVCLEdBQUcsdUJBQXVCLEVBQzFCLEdBQUcsZUFBZSxFQUNsQixHQUFHLGVBQWUsRUFDbEIsR0FBRyx5QkFBeUIsRUFDNUIsR0FBRyxzQkFBc0IsRUFDekIsR0FBRyxnQkFBZ0IsRUFDbkIsR0FBRyx3QkFBd0IsRUFDM0IsR0FBRyx3QkFBd0IsRUFDM0IsR0FBRyxpQkFBaUIsRUFDcEIsR0FBRyxtQkFBbUIsRUFDdEIsR0FBRyx5QkFBeUIsRUFDNUIsR0FBRyxzQkFBc0IsQ0FDMUIsRUFDRCxDQUNFLHdCQUF3QixFQUN4Qix5QkFBeUIsRUFDekIsdUJBQXVCLEVBQ3ZCLGVBQWUsRUFDZixlQUFlLEVBQ2YseUJBQXlCLEVBQ3pCLHNCQUFzQixFQUN0QixnQkFBZ0IsRUFDaEIsd0JBQXdCLEVBQ3hCLHdCQUF3QixFQUN4QixpQkFBaUIsRUFDakIsbUJBQW1CLEVBQ25CLHlCQUF5QixFQUN6QixzQkFBc0IsQ0FFMUIsQ0FBQztBQUNIO0FBRWUsU0FBUyxxQkFBcUIsQ0FBQSxFQUFZO0VBQ3ZELE1BQU0sY0FBYyxHQUFHLElBQUEsMEJBQWlCLEVBQUMsQ0FBQztFQUMxQyxNQUFNLHdCQUF3QixHQUFHLElBQUEsb0NBQTJCLEVBQUMsQ0FBQztFQUM5RCxNQUFNLGVBQWUsR0FBRyxrQkFBa0IsQ0FBQyxDQUFDO0VBQzVDLE1BQU0saUJBQWlCLEdBQUcsb0JBQW9CLENBQUMsQ0FBQztFQUNoRCxNQUFNLHFCQUFxQixHQUFHLElBQUEsa0RBQXdCLEVBQUMsQ0FBQztFQUN4RCxNQUFNLCtCQUErQixHQUFHLElBQUEsc0VBQWtDLEVBQUMsQ0FBQztFQUM1RSxNQUFNLHdCQUF3QixHQUFHLElBQUEsd0RBQTJCLEVBQUMsQ0FBQztFQUM5RCxNQUFNLHVCQUF1QixHQUFHLElBQUEsc0RBQTBCLEVBQUMsQ0FBQztFQUU1RCxPQUFPLElBQUEsY0FBTyxFQUNaLE1BQU0sQ0FDSixHQUFHLGNBQWMsRUFDakIsR0FBRyx3QkFBd0IsRUFDM0IsR0FBRyxlQUFlLEVBQ2xCLEdBQUcsaUJBQWlCLEVBQ3BCLEdBQUcscUJBQXFCLEVBQ3hCLEdBQUcsK0JBQStCLEVBQ2xDLEdBQUcsd0JBQXdCLEVBQzNCLEdBQUcsdUJBQXVCLENBQzNCLEVBQ0QsQ0FDRSxjQUFjLEVBQ2Qsd0JBQXdCLEVBQ3hCLGVBQWUsRUFDZixpQkFBaUIsRUFDakIscUJBQXFCLEVBQ3JCLCtCQUErQixFQUMvQix3QkFBd0IsRUFDeEIsdUJBQXVCLENBRTNCLENBQUM7QUFDSDs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDdkhBLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFdBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxlQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsZ0JBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxPQUFBLEdBQUEsT0FBQTtBQUlBLElBQUEsVUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE9BQUEsR0FBQSxPQUFBO0FBVUEsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsVUFBQSxHQUFBLE9BQUE7QUFLQSxNQUFNLHNCQUFzQixHQUFHLENBQzdCLDZCQUFZLENBQUMsd0JBQXdCLEVBQ3JDLG9CQUFvQixFQUNwQixtQkFBbUIsRUFDbkIsMEJBQTBCLENBQzNCO0FBRU0sU0FBUyx5QkFBeUIsQ0FBQSxFQUFHO0VBQzFDLE1BQU0sYUFBYSxHQUFHLElBQUEsdUJBQVcsRUFBQyw4Q0FBbUMsQ0FBQztFQUN0RSxNQUFNLGFBQWEsR0FBRyxJQUFBLHVCQUFXLEVBQUMsMkJBQWdCLEVBQUUsZUFBTyxDQUFDO0VBQzVELE1BQU0sT0FBTyxHQUFHLElBQUEsMEJBQVUsRUFBQyxDQUFDO0VBQzVCLE1BQU07SUFBRSxNQUFNLEVBQUU7RUFBWSxDQUFDLEdBQUcsSUFBQSwyQkFBVyxFQUFDLENBQUM7RUFFN0MsTUFBTSxRQUFRLEdBQUcsSUFBQSxrQkFBVyxFQUN6QixjQUF1QixJQUFLO0lBQzNCLElBQUksQ0FBQyxjQUFjLEVBQUU7TUFDbkIsT0FBTyxDQUFDO0lBQ1Y7SUFFQSxPQUFPLGFBQWEsQ0FBQyxTQUFTLENBQUMsQ0FBQztNQUFFO0lBQUcsQ0FBQyxLQUFLLEVBQUUsS0FBSyxjQUFjLENBQUM7RUFDbkUsQ0FBQyxFQUNELENBQUMsYUFBYSxDQUNoQixDQUFDO0VBRUQsTUFBTSxZQUFZLEdBQUcsSUFBQSxrQkFBVyxFQUM3QixjQUF1QixJQUFLO0lBQzNCLHNCQUFzQixDQUNwQixjQUFjLEVBQ2QsYUFBYSxFQUNiLE9BQU8sQ0FBQyxhQUFhLGFBQWIsYUFBYSx1QkFBYixhQUFhLENBQUUsTUFBTSxDQUFDLEVBQzlCLE9BQU8sRUFDUCxXQUNGLENBQUM7RUFDSCxDQUFDLEVBQ0QsQ0FBQyxhQUFhLEVBQUUsT0FBTyxFQUFFLFdBQVcsQ0FDdEMsQ0FBQztFQUVELE1BQU0sZUFBZSxHQUFHLElBQUEsa0JBQVcsRUFDaEMsS0FBYSxJQUFLO0lBQ2pCLE1BQU0sZ0JBQWdCLEdBQUcsYUFBYSxDQUFDLEtBQUssQ0FBQztJQUM3QyxZQUFZLENBQUMsZ0JBQWdCLGFBQWhCLGdCQUFnQix1QkFBaEIsZ0JBQWdCLENBQUUsRUFBRSxDQUFDO0VBQ3BDLENBQUMsRUFDRCxDQUFDLGFBQWEsRUFBRSxZQUFZLENBQzlCLENBQUM7RUFFRCxNQUFNLEtBQUssR0FBRyxhQUFhLENBQUMsTUFBTTtFQUVsQyxPQUFPO0lBQUUsYUFBYTtJQUFFLEtBQUs7SUFBRSxRQUFRO0lBQUUsWUFBWTtJQUFFO0VBQWdCLENBQUM7QUFDMUU7QUFFTyxTQUFTLHNCQUFzQixDQUNwQyxjQUFrQyxFQUNsQyxhQUFzRCxFQUN0RCxnQkFBeUIsRUFDekIsT0FBc0MsRUFDdEMsV0FBbUIsR0FBRyxFQUFFLEVBQ3hCO0VBQUEsSUFBQSxxQkFBQTtFQUNBLE1BQU0sa0JBQWtCLEdBQUcsQ0FBQSxhQUFhLGFBQWIsYUFBYSx1QkFBYixhQUFhLENBQUUsTUFBTSxLQUFJLENBQUMsSUFBSSxDQUFDLGNBQWM7RUFFeEUsSUFBSSxnQkFBZ0IsSUFBSSxrQkFBa0IsRUFBRTtJQUMxQyxPQUFPLENBQUMsT0FBTyxDQUFDLEdBQUcsaUNBQXlCLEVBQUUsQ0FBQztJQUMvQztFQUNGO0VBRUEsSUFBSSxrQkFBa0IsRUFBRTtJQUN0QjtFQUNGO0VBRUEsTUFBTSxnQkFBZ0IsR0FBRyxhQUFhLENBQUMsSUFBSSxDQUN4QyxZQUFZLElBQUssWUFBWSxDQUFDLEVBQUUsS0FBSyxjQUN4QyxDQUFDO0VBRUQsSUFBSSxDQUFDLGdCQUFnQixFQUFFO0lBQ3JCO0VBQ0Y7RUFFQSxNQUFNLElBQUksR0FBRyxnQkFBZ0IsQ0FBQyxJQUFvQjtFQUVsRCxJQUFJLGdEQUFxQyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsRUFBRTtJQUN4RCxPQUFPLENBQUMsT0FBTyxDQUFDLEdBQUcsaUNBQXlCLElBQUksY0FBYyxFQUFFLENBQUM7SUFDakU7RUFDRjtFQUVBLElBQUksSUFBQSxpQ0FBMEIsRUFBQyxnQkFBZ0IsQ0FBQyxFQUFFO0lBQ2hELE9BQU8sQ0FBQyxPQUFPLENBQ2IsR0FBRyxpQ0FBeUIsSUFBSSxjQUFjLEdBQUcsOEJBQXNCLEVBQ3pFLENBQUM7SUFDRDtFQUNGO0VBRUEsSUFBSSxJQUFJLEtBQUssNkJBQVksQ0FBQyxXQUFXLEVBQUU7SUFDckMsSUFBSSxHQUFHLEdBQUcsR0FBRyxpQ0FBeUIsSUFBSSxjQUFjLEVBQUU7SUFDMUQsSUFBSSxXQUFXLENBQUMsTUFBTSxFQUFFO01BQ3RCLEdBQUcsR0FBRyxHQUFHLEdBQUcsR0FBRyxXQUFXLEVBQUU7SUFDOUI7SUFDQSxPQUFPLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQztJQUNwQjtFQUNGO0VBRUEsSUFBSSxJQUFJLEtBQUssNkJBQVksQ0FBQyxVQUFVLEVBQUU7SUFDcEMsT0FBTyxDQUFDLE9BQU8sQ0FDYixHQUFHLGlDQUF5QixJQUFJLGNBQWMsR0FBRyxvQ0FBNEIsRUFDL0UsQ0FBQztJQUNEO0VBQ0Y7RUFFQSxJQUFJLElBQUksS0FBSyw2QkFBWSxDQUFDLHlCQUF5QixFQUFFO0lBQ25ELE9BQU8sQ0FBQyxPQUFPLENBQ2IsR0FBRyxpQ0FBeUIsSUFBSSxjQUFjLEdBQUcsMENBQWtDLEVBQ3JGLENBQUM7SUFDRDtFQUNGO0VBRUEsSUFBSSxzQkFBc0IsQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLEVBQUU7SUFDekMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxHQUFHLHFCQUFhLElBQUksY0FBYyxFQUFFLENBQUM7SUFDckQ7RUFDRjtFQUVBLE1BQU0sT0FBTyxHQUNYLGdCQUFnQixhQUFoQixnQkFBZ0IsZ0JBQUEscUJBQUEsR0FBaEIsZ0JBQWdCLENBQUUsV0FBVyxjQUFBLHFCQUFBLGdCQUFBLHFCQUFBLEdBQTdCLHFCQUFBLENBQStCLEtBQUssY0FBQSxxQkFBQSx1QkFEdEIscUJBQUEsQ0FFYixPQUFpQjtFQUVwQixJQUFJLElBQUksS0FBSyw2QkFBWSxDQUFDLFVBQVUsSUFBSSxDQUFDLE9BQU8sRUFBRTtJQUNoRCxPQUFPLENBQUMsT0FBTyxDQUFDLEdBQUcseUNBQWlDLEVBQUUsQ0FBQztJQUN2RDtFQUNGO0VBRUEsSUFBSSxJQUFJLEtBQUssNkJBQVksQ0FBQyxVQUFVLElBQUksT0FBTyxFQUFFO0lBQy9DLE9BQU8sQ0FBQyxPQUFPLENBQUMsR0FBRyx1Q0FBK0IsRUFBRSxDQUFDO0VBQ3ZEO0FBQ0Y7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDM0pBLElBQUEsV0FBQSxHQUFBLE9BQUE7QUFHQSxJQUFBLFFBQUEsR0FBQSxPQUFBO0FBS0EsSUFBQSxlQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsUUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFVBQUEsR0FBQSxPQUFBO0FBRUEsU0FBUywwQkFBMEIsQ0FBQSxFQUFHO0VBQ3BDLE1BQU0sQ0FBQyxHQUFHLElBQUEsOEJBQWMsRUFBQyxDQUFDO0VBQzFCLE1BQU07SUFBRTtFQUFvQixDQUFDLEdBQUcsSUFBQSwwQkFBaUIsRUFBQyxDQUFDO0VBQ25ELE1BQU0sT0FBTyxHQUFHLG1CQUFtQixhQUFuQixtQkFBbUIsdUJBQW5CLG1CQUFtQixDQUFFLE9BQWM7RUFFbkQsTUFBTSxvQkFBb0IsR0FBRyxJQUFBLHVCQUFXLEVBQUUsS0FBSyxJQUM3QyxJQUFBLDhDQUFtQyxFQUFDLEtBQUssRUFBRSxPQUFPLENBQ3BELENBQUM7RUFFRCxJQUFJLGtCQUFrQixHQUFHLEVBQUU7RUFDM0IsSUFBSSxlQUFlLEdBQUcsRUFBRTtFQUV4QixJQUFJLG1CQUFtQixFQUFFO0lBQ3ZCLGtCQUFrQixHQUNoQixDQUFBLG9CQUFvQixhQUFwQixvQkFBb0IsdUJBQXBCLG9CQUFvQixDQUFFLElBQUksS0FDMUIsNEJBQW1CLENBQUMsT0FBTyxDQUFxQyxJQUNoRSxDQUFDLENBQUMsZ0JBQWdCLENBQUM7SUFFckIsZUFBZSxHQUNiLDBDQUFpQyxDQUMvQixPQUFPLENBQ1I7RUFDTDtFQUVBLE9BQU87SUFDTCxlQUFlO0lBQ2Y7RUFDRixDQUFDO0FBQ0g7QUFBQyxJQUFBLFFBQUEsR0FBQSxPQUFBLENBQUEsT0FBQSxHQUVjLDBCQUEwQjs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUMxQ3pDLElBQUEsV0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFVBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsUUFBQSxHQUFBLE9BQUE7QUFFQSxJQUFBLFNBQUEsR0FBQSxPQUFBO0FBS0EsSUFBQSxZQUFBLEdBQUEsT0FBQTtBQUtBLFNBQVMsNEJBQTRCLENBQUEsRUFBRztFQUN0QyxNQUFNO0lBQUU7RUFBb0IsQ0FBQyxHQUFHLElBQUEsMEJBQWlCLEVBQUMsQ0FBQztFQUNuRCxNQUFNLGlDQUFpQyxHQUFHLElBQUEsdUJBQVcsRUFDbkQsK0NBQ0YsQ0FBQztFQUVELE1BQU07SUFBRTtFQUFLLENBQUMsR0FBRyxJQUFBLDRCQUFxQixFQUFDLG1CQUFtQixDQUFDO0VBQzNELE1BQU0sYUFBYSxHQUFHLElBQUksSUFBSSxFQUFFO0VBRWhDLE1BQU0sZ0JBQWdCLEdBQUcsSUFBQSx1QkFBVyxFQUFFLEtBQThCLElBQ2xFLElBQUEsaURBQXVDLEVBQUMsS0FBSyxFQUFFLGFBQWEsQ0FDOUQsQ0FBQztFQUVELE1BQU0sbUJBQW1CLEdBQUcsSUFBQSx1QkFBVyxFQUFFLEtBQWdCLElBQ3ZELElBQUEsNENBQWtDLEVBQUMsS0FBSyxFQUFFLGFBQWEsQ0FDekQsQ0FBQztFQUVELE1BQU0sVUFBVSxHQUFHLElBQUEsdUJBQVcsRUFBRSxLQUFnQixJQUM5QyxJQUFBLCtDQUFrQyxFQUFDLEtBQUssRUFBRSxhQUFhLENBQ3pELENBQUM7RUFFRCxNQUFNLG1CQUFtQixHQUFHLElBQUEsdUJBQVcsRUFBQyxtQ0FBc0IsQ0FBQztFQUUvRCxNQUFNLFVBQVUsR0FBRyxpQ0FBaUMsR0FDaEQsZ0JBQWdCLEdBQ2hCLG1CQUFtQjtFQUV2QixNQUFNLG9CQUFvQixHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxNQUFNLEdBQUcsQ0FBQztFQUV4RSxPQUFPO0lBQ0wsb0JBQW9CO0lBQ3BCLE9BQU8sRUFBRSxpQ0FBaUM7SUFDMUMsYUFBYTtJQUNiLFVBQVUsRUFBRSxVQUFVLElBQUksRUFBRTtJQUM1QixVQUFVLEVBQUUsQ0FBQSxVQUFVLGFBQVYsVUFBVSx1QkFBVixVQUFVLENBQUUsSUFBSSxLQUFJO0VBQ2xDLENBQUM7QUFDSDtBQUFDLElBQUEsUUFBQSxHQUFBLE9BQUEsQ0FBQSxPQUFBLEdBRWMsNEJBQTRCOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ25EM0MsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsV0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLGVBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxVQUFBLEdBQUEsT0FBQTtBQU1BLElBQUEsV0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLGFBQUEsR0FBQSxPQUFBO0FBS0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLE1BQU0sc0JBQXNCLEdBQUcsQ0FBQSxLQUFNO0VBQ25DLE1BQU07SUFBRSxFQUFFLEVBQUU7RUFBcUIsQ0FBQyxHQUFHLElBQUEseUJBQVMsRUFBaUIsQ0FBQztFQUNoRSxNQUFNLHFCQUFxQixHQUFHLElBQUEsdUJBQVcsRUFBQyw0Q0FBaUMsQ0FBQztFQUM1RSxNQUFNLGNBQWMsR0FBRyxvQkFBb0IsS0FBSSxxQkFBcUIsYUFBckIscUJBQXFCLHVCQUFyQixxQkFBcUIsQ0FBRSxFQUFFO0VBRXhFLE1BQU0sZUFBZSxHQUFHLElBQUEsdUJBQVcsRUFBRSxLQUFLLElBQ3hDLElBQUEsZ0NBQXFCLEVBQUMsS0FBSyxFQUE0QixjQUFjLENBQ3ZFLENBQUM7RUFFRCxNQUFNLG1CQUFtQixHQUFHLElBQUEsdUJBQVcsRUFBRSxLQUFLO0VBQzVDO0VBQ0E7RUFDQSxJQUFDLG1DQUF3QixFQUFTLEtBQUssRUFBRSxjQUFjLENBQ3pELENBQWdDO0VBRWhDLE1BQU0sZ0JBQWdCLEdBQUcsSUFBQSx1QkFBVyxFQUFFLEtBQUssSUFDekMsSUFBQSxtQ0FBdUIsRUFBQyxLQUFLLEVBQUUsY0FBYyxDQUMvQyxDQUFDO0VBRUQsTUFBTSwwQkFBMEIsR0FBRyxJQUFBLDRDQUE4QixFQUFDO0lBQ2hFLFlBQVksRUFBRSxlQUFlLGFBQWYsZUFBZSx1QkFBZixlQUFlLENBQUU7RUFDakMsQ0FBQyxDQUFDO0VBRUYsTUFBTSwyQkFBMkIsR0FBRyxJQUFBLDhDQUFnQyxFQUFDO0lBQ25FLHVCQUF1QixFQUFFLG1CQUFtQixhQUFuQixtQkFBbUIsdUJBQW5CLG1CQUFtQixDQUFFO0VBQ2hELENBQUMsQ0FBQztFQUVGLE1BQU0saUJBQWlCLEdBQ3JCLDBCQUEwQixJQUFJLDJCQUEyQjtFQUUzRCxPQUFPLElBQUEsY0FBTyxFQUFDLE1BQU07SUFDbkIsSUFBSSxDQUFDLGlCQUFpQixFQUFFO01BQ3RCLE9BQU87UUFBRSxtQkFBbUIsRUFBRTtNQUFVLENBQUM7SUFDM0M7SUFFQSxNQUFNLG1CQUFtQixHQUN2QixtQkFBbUIsSUFBSSxnQkFBZ0IsSUFBSSxTQUFTO0lBRXRELE9BQU87TUFBRTtJQUFvQixDQUFDO0VBQ2hDLENBQUMsRUFBRSxDQUFDLG1CQUFtQixFQUFFLGdCQUFnQixFQUFFLGlCQUFpQixDQUFDLENBQUM7QUFDaEUsQ0FBQztBQUFDLElBQUEsUUFBQSxHQUFBLE9BQUEsQ0FBQSxPQUFBLEdBRWEsc0JBQXNCOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ25FckMsSUFBQSxXQUFBLEdBQUEsT0FBQTtBQUlBLElBQUEsUUFBQSxHQUFBLE9BQUE7QUFTQSxNQUFNLHdDQUF3QyxHQUFHLENBQUEsS0FFaEM7RUFBQSxJQUFBLHFCQUFBO0VBQ2YsTUFBTTtJQUFFO0VBQW9CLENBQUMsR0FBRyxJQUFBLDBCQUFpQixFQUFDLENBQUM7RUFFbkQsTUFBTSxlQUFlLEdBQ25CLG1CQUFtQixhQUFuQixtQkFBbUIsZ0JBQUEscUJBQUEsR0FBbkIsbUJBQW1CLENBQUUscUJBQXFCLGNBQUEscUJBQUEsdUJBRHBCLHFCQUFBLENBRXJCLGVBQXlCO0VBRTVCLE1BQU0sOEJBQThCLEdBQUcsSUFBQSx1QkFBVyxFQUMvQyxLQUFrQyxJQUFLO0lBQUEsSUFBQSxxQkFBQTtJQUN0QyxJQUFJLGVBQWUsS0FBSyxTQUFTLEVBQUU7TUFDakMsT0FBTyxTQUFTO0lBQ2xCO0lBQ0EsUUFBQSxxQkFBQSxHQUFPLEtBQUssQ0FBQyxRQUFRLENBQUMsK0JBQStCLGNBQUEscUJBQUEsdUJBQTlDLHFCQUFBLENBQ0wsZUFBZSxDQUNoQjtFQUNILENBQ0YsQ0FBQztFQUVELE9BQU8sOEJBQThCO0FBQ3ZDLENBQUM7QUFBQyxJQUFBLFFBQUEsR0FBQSxPQUFBLENBQUEsT0FBQSxHQUVhLHdDQUF3Qzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNuQ3ZELElBQUEsTUFBQSxHQUFBLE9BQUE7QUFHQSxJQUFBLFFBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxlQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsMEJBQUEsR0FBQSxPQUFBO0FBQXdFLElBRW5FLG9CQUFvQiwwQkFBcEIsb0JBQW9CO0VBQXBCLG9CQUFvQjtFQUFwQixvQkFBb0I7RUFBcEIsb0JBQW9CO0VBQUEsT0FBcEIsb0JBQW9CO0FBQUEsRUFBcEIsb0JBQW9CO0FBTWxCLFNBQVMsMEJBQTBCLENBQUMsc0JBQStCLEVBQUU7RUFBQSxJQUFBLG1CQUFBO0VBQzFFLE1BQU07SUFBRTtFQUE2QixDQUFDLEdBQUcsSUFBQSxvREFBeUIsRUFBQyxDQUFDO0VBQ3BFLE1BQU07SUFBRTtFQUFvQixDQUFDLEdBQUcsSUFBQSwwQkFBaUIsRUFBdUIsQ0FBQztFQUN6RSxNQUFNO0lBQUUsV0FBVztJQUFFO0VBQW1CLENBQUMsR0FBRyxJQUFBLDhCQUFjLEVBQUMsQ0FBQztFQUM1RCxNQUFNO0lBQUUsZUFBZTtJQUFFO0VBQWEsQ0FBQyxHQUFHLG1CQUFtQjtFQUU3RCxJQUFJLGVBQWUsS0FBSyxLQUFLLEVBQUU7SUFDN0Isa0JBQWtCLENBQUMsQ0FBQztFQUN0QjtFQUVBLE1BQU0sbUJBQW1CLEdBQUcsSUFBQSxjQUFPLEVBQ2pDLE1BQ0UsQ0FBQyxDQUFBLFlBQVksYUFBWixZQUFZLHVCQUFaLFlBQVksQ0FBRSxZQUFZLEtBQUksRUFBRSxFQUFFLEdBQUcsQ0FDbkMsTUFBK0IsSUFBSyxNQUFNLENBQUMsVUFDOUMsQ0FBQyxFQUNILENBQUMsWUFBWSxDQUNmLENBQUM7RUFFRCxNQUFNLGdCQUFnQixHQUNwQixDQUFBLFlBQVksYUFBWixZQUFZLGdCQUFBLG1CQUFBLEdBQVosWUFBWSxDQUFFLEtBQUssY0FBQSxtQkFBQSx1QkFBbkIsbUJBQUEsQ0FBcUIsSUFBSSxNQUN4QixtQkFBbUIsQ0FBQyxNQUFNLEdBQ3ZCLG9CQUFvQixDQUFDLE1BQU0sR0FDM0Isb0JBQW9CLENBQUMsUUFBUSxDQUFDO0VBRXBDLElBQUEsZ0JBQVMsRUFBQyxNQUFNO0lBQUEsSUFBQSxvQkFBQTtJQUNkLElBQUksQ0FBQyxzQkFBc0IsRUFBRTtNQUMzQjtJQUNGO0lBQ0EsSUFBSSxlQUFlLEVBQUU7TUFDbkIsNEJBQTRCLENBQUM7UUFDM0IsVUFBVSxFQUFFO1VBQ1Y7VUFDQTtVQUNBLGlCQUFpQixFQUFFLG9CQUFvQixDQUFDO1FBQzFDO01BQ0YsQ0FBQyxDQUFDO01BRUY7SUFDRjtJQUVBLDRCQUE0QixDQUFDO01BQzNCLFVBQVUsRUFBRTtRQUNWO1FBQ0E7UUFDQSxxQkFBcUIsRUFBRSxtQkFBbUI7UUFDMUM7UUFDQTtRQUNBLG9CQUFvQixFQUFFLENBQUEsWUFBWSxhQUFaLFlBQVksZ0JBQUEsb0JBQUEsR0FBWixZQUFZLENBQUUsS0FBSyxjQUFBLG9CQUFBLHVCQUFuQixvQkFBQSxDQUFxQixPQUFPLEtBQUksSUFBSTtRQUMxRDtRQUNBO1FBQ0EsZ0JBQWdCLEVBQUUsV0FBVyxJQUFJLElBQUk7UUFDckM7UUFDQTtRQUNBLGlCQUFpQixFQUFFO01BQ3JCO0lBQ0YsQ0FBQyxDQUFDO0VBQ0osQ0FBQyxFQUFFLENBQ0QsZ0JBQWdCLEVBQ2hCLGVBQWUsRUFDZixtQkFBbUIsRUFDbkIsV0FBVyxFQUNYLDRCQUE0QixDQUM3QixDQUFDO0FBQ0o7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDN0VBLElBQUEsV0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLEtBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxVQUFBLEdBQUEsT0FBQTtBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTyxNQUFNLCtCQUErQixHQUFHLENBQUEsS0FBTTtFQUNuRCxNQUFNLGdCQUFnQixHQUFHLElBQUEsdUJBQVcsRUFBQyxnQ0FBMEIsQ0FBQztFQUVoRSxNQUFNLGFBQWEsR0FBRyxJQUFBLHVCQUFXLEVBQUMsb0NBQXlCLENBQUM7RUFFNUQsSUFBSSxlQUFlLEdBQUcsQ0FBQyxDQUFDO0VBRXhCLElBQUksTUFBTSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLE1BQU0sS0FBSyxDQUFDLEVBQUU7SUFBQSxJQUFBLHFCQUFBLEVBQUEscUJBQUEsRUFBQSxzQkFBQSxFQUFBLHNCQUFBLEVBQUEsc0JBQUEsRUFBQSxzQkFBQSxFQUFBLHNCQUFBLEVBQUEsc0JBQUEsRUFBQSxzQkFBQSxFQUFBLHFCQUFBO0lBQzlDLE1BQU0sa0JBQWtCLEdBQUcsYUFBYSxDQUFDLGdCQUFnQixDQUFDLEVBQUUsQ0FBQztJQUM3RCxlQUFlLEdBQUc7TUFDaEIsUUFBUSxFQUFFO1FBQ1IsUUFBUSxHQUFBLHFCQUFBLEdBQUUsZ0JBQWdCLENBQUMsR0FBRyxjQUFBLHFCQUFBLHVCQUFwQixxQkFBQSxDQUFzQixRQUFRO1FBQ3hDLEdBQUcsRUFBRSxrQkFBa0IsYUFBbEIsa0JBQWtCLGVBQWxCLGtCQUFrQixDQUFFLGtCQUFrQixHQUN2QyxrQkFBa0IsYUFBbEIsa0JBQWtCLGdCQUFBLHFCQUFBLEdBQWxCLGtCQUFrQixDQUFFLFFBQVEsY0FBQSxxQkFBQSx1QkFBNUIscUJBQUEsQ0FBOEIsR0FBRyxJQUFBLHNCQUFBLEdBQ2pDLGdCQUFnQixDQUFDLEdBQUcsY0FBQSxzQkFBQSx1QkFBcEIsc0JBQUEsQ0FBc0IsUUFBUTtRQUNsQyxZQUFZLEVBQUUsa0JBQWtCLGFBQWxCLGtCQUFrQixnQkFBQSxzQkFBQSxHQUFsQixrQkFBa0IsQ0FBRSxRQUFRLGNBQUEsc0JBQUEsZUFBNUIsc0JBQUEsQ0FBOEIsWUFBWSxHQUNwRCxrQkFBa0IsYUFBbEIsa0JBQWtCLGdCQUFBLHNCQUFBLEdBQWxCLGtCQUFrQixDQUFFLFFBQVEsY0FBQSxzQkFBQSx1QkFBNUIsc0JBQUEsQ0FBOEIsWUFBWSxJQUFBLHNCQUFBLEdBQzFDLGdCQUFnQixDQUFDLEdBQUcsY0FBQSxzQkFBQSx1QkFBcEIsc0JBQUEsQ0FBc0IsWUFBWTtRQUN0QyxvQkFBb0IsRUFBRSxrQkFBa0IsYUFBbEIsa0JBQWtCLGdCQUFBLHNCQUFBLEdBQWxCLGtCQUFrQixDQUFFLFFBQVEsY0FBQSxzQkFBQSxlQUE1QixzQkFBQSxDQUE4QixvQkFBb0IsR0FDcEUsa0JBQWtCLGFBQWxCLGtCQUFrQixnQkFBQSxzQkFBQSxHQUFsQixrQkFBa0IsQ0FBRSxRQUFRLGNBQUEsc0JBQUEsdUJBQTVCLHNCQUFBLENBQThCLG9CQUFvQixJQUFBLHNCQUFBLEdBQ2xELGdCQUFnQixDQUFDLEdBQUcsY0FBQSxzQkFBQSx1QkFBcEIsc0JBQUEsQ0FBc0Isb0JBQW9CO1FBQzlDLEtBQUssR0FBQSxxQkFBQSxHQUFFLGdCQUFnQixDQUFDLE1BQU0sY0FBQSxxQkFBQSx1QkFBdkIscUJBQUEsQ0FBeUIsS0FBSztRQUNyQyxJQUFJLEVBQUUsZ0JBQWdCLENBQUM7TUFDekIsQ0FBQztNQUNELFlBQVksRUFBRSxrQkFBa0IsYUFBbEIsa0JBQWtCLHVCQUFsQixrQkFBa0IsQ0FBRTtJQUNwQyxDQUFDO0VBQ0g7RUFFQSxPQUFPLGVBQWU7QUFDeEIsQ0FBQztBQUFDLE9BQUEsQ0FBQSwrQkFBQSxHQUFBLCtCQUFBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUN6Q0YsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsV0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLHNCQUFBLEdBQUEsT0FBQTtBQU1BLElBQUEsUUFBQSxHQUFBLE9BQUE7QUFJQSxJQUFBLFVBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSwwQkFBQSxHQUFBLE9BQUE7QUFFTyxNQUFNLHVCQUF1QixHQUFBLE9BQUEsQ0FBQSx1QkFBQSxHQUNsQyw0Q0FBNEM7QUFFdkMsU0FBUyxpQkFBaUIsQ0FDL0I7RUFBRSxPQUFPO0VBQUU7QUFBc0QsQ0FBQyxHQUFHO0VBQ25FLE9BQU8sRUFBRTtBQUNYLENBQUMsRUFDRDtFQUNBLE1BQU0sUUFBUSxHQUFHLElBQUEsdUJBQVcsRUFBQyxDQUFDO0VBQzlCLE1BQU0sQ0FBQyxhQUFhLEVBQUUsZ0JBQWdCLENBQUMsR0FBRyxJQUFBLGVBQVEsRUFBcUIsQ0FBQztFQUN4RSxNQUFNO0lBQUUsYUFBYTtJQUFFO0VBQWEsQ0FBQyxHQUFHLElBQUEsb0RBQXlCLEVBQUMsQ0FBQztFQUNuRSxNQUFNLGtCQUFrQixHQUFHLElBQUEsdUJBQVcsRUFBRSxLQUFLLElBQzNDLElBQUEsNENBQWlDLEVBQUMsS0FBSyxFQUFFLE9BQU8sQ0FDbEQsQ0FBQyxJQUFJO0lBQUUsa0JBQWtCLEVBQUUsQ0FBQztFQUFFLENBQUM7RUFDL0IsTUFBTTtJQUFFO0VBQWdCLENBQUMsR0FBRyxrQkFBaUQ7RUFFN0UsTUFBTSxpQkFBaUIsR0FBRyxhQUFhLENBQUMsSUFBSSxDQUN6QyxJQUFJLElBQUssSUFBSSxDQUFDLEVBQUUsS0FBSyxhQUN4QixDQUFDO0VBRUQsTUFBTSxnQkFBZ0IsR0FBRyxJQUFBLGtCQUFXLEVBQ2xDLE1BQU8sT0FBWSxJQUFLO0lBQ3RCLE1BQU0sZUFBZSxHQUFJLE1BQU0sUUFBUSxDQUNyQyxJQUFBLGlEQUF3QyxFQUN0QztNQUNFLGlCQUFpQixFQUFFLENBQ2pCO1FBQ0UsT0FBTyxFQUFFO01BQ1gsQ0FBQyxDQUNGO01BQ0QsSUFBSSxFQUFFLE9BQU87TUFDYixFQUFFLEVBQUUsT0FBTztNQUNYLElBQUksRUFBRSw4Q0FBdUIsQ0FBQztJQUNoQyxDQUFDLEVBQ0Q7TUFDRSxlQUFlO01BQ2YsSUFBSSxFQUFFLHNDQUFlLENBQUM7SUFDeEIsQ0FDRixDQUNGLENBQWdDO0lBRWhDLGdCQUFnQixDQUFDLGVBQWUsYUFBZixlQUFlLHVCQUFmLGVBQWUsQ0FBRSxFQUFFLENBQUM7RUFDdkMsQ0FBQyxFQUNELENBQUMsUUFBUSxFQUFFLGVBQWUsQ0FDNUIsQ0FBQztFQUVELE1BQU0sY0FBYyxHQUFHLElBQUEsa0JBQVcsRUFDaEMsT0FBTyxPQUFZLEVBQUUsc0JBQTJCLEtBQUs7SUFDbkQsTUFBTSxlQUFlLEdBQUksTUFBTSxRQUFRLENBQ3JDLElBQUEsaURBQXdDLEVBQ3RDO01BQ0UsaUJBQWlCLEVBQUUsQ0FDakI7UUFDRSxPQUFPLEVBQUU7TUFDWCxDQUFDLENBQ0Y7TUFDRCxJQUFJLEVBQUUsT0FBTztNQUNiLEVBQUUsRUFBRSxPQUFPO01BQ1gsSUFBSSxFQUFFLDhDQUF1QixDQUFDO0lBQ2hDLENBQUMsRUFDRDtNQUNFLGVBQWU7TUFDZixJQUFJLEVBQUUsc0NBQWUsQ0FBQztJQUN4QixDQUNGLENBQ0YsQ0FBZ0M7SUFFaEMsZ0JBQWdCLENBQUMsZUFBZSxhQUFmLGVBQWUsdUJBQWYsZUFBZSxDQUFFLEVBQUUsQ0FBQztFQUN2QyxDQUFDLEVBQ0QsQ0FBQyxRQUFRLEVBQUUsZUFBZSxDQUM1QixDQUFDO0VBRUQsTUFBTSxVQUFVLEdBQUcsSUFBQSxrQkFBVyxFQUM1QixNQUFPLE9BQVksSUFBSztJQUN0QixNQUFNLElBQUksR0FBRyxNQUFNLElBQUEsZ0JBQU8sRUFBQyxPQUFPLEVBQUUsZUFBZSxDQUFDO0lBQ3BELE9BQU8sQ0FBQSxJQUFJLGFBQUosSUFBSSx1QkFBSixJQUFJLENBQUUsTUFBTSxJQUFHLENBQUM7RUFDekIsQ0FBQyxFQUNELENBQUMsZUFBZSxDQUNsQixDQUFDO0VBRUQsSUFBQSxnQkFBUyxFQUFDLE1BQU07SUFDZCxJQUFJLGlCQUFpQixFQUFFO01BQ3JCLFlBQVksQ0FBQyxhQUFhLENBQUM7TUFDM0IsVUFBVSxhQUFWLFVBQVUsZUFBVixVQUFVLENBQUcsQ0FBQztJQUNoQjtFQUNGLENBQUMsRUFBRSxDQUFDLGlCQUFpQixFQUFFLFlBQVksRUFBRSxhQUFhLEVBQUUsVUFBVSxDQUFDLENBQUM7RUFFaEUsT0FBTztJQUFFLFVBQVU7SUFBRSxnQkFBZ0I7SUFBRTtFQUFlLENBQUM7QUFDekQ7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDcEdBLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFdBQUEsR0FBQSxPQUFBO0FBRUEsSUFBQSxRQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsUUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFNBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxVQUFBLEdBQUEsT0FBQTtBQUtBLElBQUEsU0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLHNCQUFBLEdBQUEsT0FBQTtBQVFPLE1BQU0sa0JBQWtCLEdBQUksT0FBZSxJQUFLO0VBQUEsSUFBQSxpQkFBQTtFQUNyRCxNQUFNLE9BQU8sR0FBRyxJQUFBLHVCQUFXLEVBQUUsS0FBb0IsSUFDL0MsSUFBQSw4Q0FBbUMsRUFBQyxLQUFLLEVBQW1CLE9BQU8sQ0FDckUsQ0FBQztFQUNELE1BQU0sV0FBVyxHQUFHLE9BQU8sYUFBUCxPQUFPLGdCQUFBLGlCQUFBLEdBQVAsT0FBTyxDQUFFLFFBQVEsY0FBQSxpQkFBQSxnQkFBQSxpQkFBQSxHQUFqQixpQkFBQSxDQUFtQixPQUFPLGNBQUEsaUJBQUEsdUJBQTFCLGlCQUFBLENBQTRCLElBQUk7RUFDcEQsTUFBTSxzQkFBc0IsR0FDMUIsV0FBVyxJQUNYLHNDQUE2QixDQUFDLFFBQVEsQ0FBQyxXQUEyQixDQUFDO0VBRXJFLE1BQU0sQ0FBQyxrQkFBa0IsQ0FBQyxHQUFHLElBQUEsdUJBQVcsRUFDdEMsc0RBQ0YsQ0FBQztFQUVELE1BQU0sQ0FBQyxlQUFlLEdBQUcsQ0FBQyxDQUFDLEVBQUUsWUFBWSxHQUFHLENBQUMsQ0FBQyxDQUFDLEdBQUcsSUFBQSxjQUFPLEVBQUMsTUFBTTtJQUM5RCxJQUFJLENBQUMsc0JBQXNCLEVBQUU7TUFDM0I7TUFDQSxPQUFPLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7SUFDakI7SUFDQSxPQUFPLE1BQU0sQ0FBQyxPQUFPLENBQUMsa0JBQWtCLENBQUMsQ0FBQyxNQUFNLENBQzlDLENBQUMsQ0FBQyxlQUFlLEVBQUUsWUFBWSxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsT0FBTyxDQUFDLEtBQUs7TUFDbEQsSUFBSTtRQUNGLE1BQU0sT0FBTyxHQUFHLE9BQU8sQ0FBQyxLQUFLLEdBQ3pCLElBQUEsaUNBQXVCLEVBQUMsRUFBaUIsQ0FBQyxHQUMxQyxFQUFFO1FBQ047UUFDQTtRQUNBLE1BQU0sTUFBTSxHQUFJLG9CQUFXLENBQWMsUUFBUSxDQUFDLE9BQU8sQ0FBQztRQUMxRCxDQUFDLE1BQU0sR0FBRyxZQUFZLEdBQUcsZUFBZSxFQUFFLE9BQU8sQ0FBQyxHQUFHLE9BQU87TUFDOUQsQ0FBQyxDQUFDLE9BQU8sR0FBWSxFQUFFO1FBQ3JCO01BQUE7TUFFRixPQUFPLENBQUMsZUFBZSxFQUFFLFlBQVksQ0FBQztJQUN4QyxDQUFDLEVBQ0QsQ0FDRSxDQUFDLENBQUMsRUFDRixDQUFDLENBQUMsQ0FFTixDQUFDO0VBQ0gsQ0FBQyxFQUFFLENBQUMsc0JBQXNCLEVBQUUsa0JBQWtCLENBQUMsQ0FBQztFQUVoRCxNQUFNLFdBQVcsR0FBRyxJQUFBLGNBQU8sRUFDekIsT0FBTztJQUFFLEdBQUcsZUFBZTtJQUFFLEdBQUc7RUFBYSxDQUFDLENBQUMsRUFDL0MsQ0FBQyxlQUFlLEVBQUUsWUFBWSxDQUNoQyxDQUFDO0VBRUQsTUFBTTtJQUFFLE9BQU87SUFBRTtFQUFNLENBQUMsR0FBRyxJQUFBLHdCQUFjLEVBQUMsWUFBWTtJQUNwRCxJQUFJLENBQUMsc0JBQXNCLEVBQUU7TUFDM0IsT0FBTyxFQUFFO0lBQ1g7SUFFQSxNQUFNLFFBQVEsR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBVTtJQUVsRCxPQUFPLE1BQU0sSUFBQSw2Q0FBc0IsRUFBQztNQUNsQyxPQUFPLEVBQUUsT0FBYztNQUN2QjtJQUNGLENBQUMsQ0FBQztFQUNKLENBQUMsRUFBRSxDQUFDLE9BQU8sRUFBRSxzQkFBc0IsRUFBRSxXQUFXLENBQUMsQ0FBQztFQUVsRCxNQUFNLGVBQTBELEdBQzlELElBQUEsY0FBTyxFQUFDLE1BQU07SUFDWixJQUFJLENBQUMsS0FBSyxJQUFJLENBQUMsc0JBQXNCLEVBQUU7TUFDckMsT0FBTyxFQUFFO0lBQ1g7SUFFQSxNQUFNLHNCQUFxRCxHQUFHLEVBQUU7SUFDaEUsTUFBTSxDQUFDLE1BQU0sQ0FBQyxXQUFXLENBQUMsQ0FBQyxPQUFPLENBQUUsT0FBTyxJQUFLO01BQzlDLElBQUk7UUFDRixNQUFNLFVBQVUsR0FBRyxJQUFBLGlDQUF1QixFQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUM7UUFDM0QsTUFBTSxpQkFBaUIsR0FBRyxLQUFLLENBQUMsSUFBSSxDQUNsQyxDQUFDO1VBQUU7UUFBUSxDQUFDLEtBQUssT0FBTyxLQUFLLFVBQy9CLENBQUM7UUFDRCxJQUFJLGlCQUFpQixFQUFFO1VBQ3JCLHNCQUFzQixDQUFDLElBQUksQ0FBQztZQUMxQixHQUFHLGlCQUFpQjtZQUNwQixHQUFHLE9BQU87WUFDVjtVQUNGLENBQUMsQ0FBQztRQUNKO01BQ0YsQ0FBQyxDQUFDLE9BQU8sR0FBWSxFQUFFO1FBQ3JCO01BQUE7SUFFSixDQUFDLENBQUM7O0lBRUY7SUFDQSxzQkFBc0IsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxLQUFLO01BQ3BDLE1BQU0sV0FBVyxHQUFHLFFBQVEsQ0FBQyxDQUFDLENBQUMsVUFBVSxFQUFFLEVBQUUsQ0FBQztNQUM5QyxNQUFNLFdBQVcsR0FBRyxRQUFRLENBQUMsQ0FBQyxDQUFDLFVBQVUsRUFBRSxFQUFFLENBQUM7TUFDOUMsT0FBTyxXQUFXLEdBQUcsV0FBVztJQUNsQyxDQUFDLENBQUM7SUFFRixPQUFPLHNCQUFzQjtFQUMvQixDQUFDLEVBQUUsQ0FBQyxzQkFBc0IsRUFBRSxXQUFXLEVBQUUsS0FBSyxDQUFDLENBQUM7RUFFbEQsT0FBTztJQUNMLGVBQWU7SUFDZiw0QkFBNEIsRUFBRSxDQUFBLGVBQWUsYUFBZixlQUFlLHVCQUFmLGVBQWUsQ0FBRSxNQUFNLElBQUcsQ0FBQztJQUN6RCxPQUFPLEVBQUUsT0FBTyxJQUFJO0VBQ3RCLENBQUM7QUFDSCxDQUFDO0FBQUMsT0FBQSxDQUFBLGtCQUFBLEdBQUEsa0JBQUE7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDekhGLElBQUEsV0FBQSxHQUFBLE9BQUE7QUFFQSxJQUFBLElBQUEsR0FBQSxPQUFBO0FBSUEsSUFBQSxLQUFBLEdBQUEsT0FBQTtBQUtBLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFVBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxhQUFBLEdBQUEsT0FBQTtBQUVBLElBQUEsbUJBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSwyQkFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFdBQUEsR0FBQSxPQUFBO0FBS0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTyxTQUFTLGVBQWUsQ0FBQztFQUM5QixXQUFXO0VBQ1gsZUFBZTtFQUNmLGVBQWU7RUFDZixRQUFRO0VBQ1IsUUFBUTtFQUNSLFlBQVk7RUFDWixvQkFBb0I7RUFDcEIsZUFBZTtFQUNmO0FBQ0YsQ0FBQyxFQUFFO0VBQ0QsTUFBTSxlQUFlLEdBQ25CLElBQUEsdUJBQVcsRUFBRSxLQUFLLElBQ2hCLElBQUEsNkNBQWtDLEVBQUMsS0FBSyxFQUFFLFdBQVcsYUFBWCxXQUFXLHVCQUFYLFdBQVcsQ0FBRSxlQUFlLENBQ3hFLENBQUMsSUFBSSxDQUFDLElBQUEsaUNBQW1CLEVBQUMsV0FBVyxhQUFYLFdBQVcsdUJBQVgsV0FBVyxDQUFFLFFBQVEsQ0FBQztFQUVsRCxNQUFNO0lBQ0osUUFBUSxFQUFFLGVBQWU7SUFDekIsZ0JBQWdCLEVBQUU7RUFDcEIsQ0FBQyxHQUFHLElBQUEsc0RBQTBCLEVBQUMsZUFBTyxDQUFDOztFQUV2QztFQUNBO0VBQ0E7RUFDQTtFQUNBO0VBQ0EsSUFBSSxXQUFXLEdBQUc7SUFDaEIsUUFBUSxFQUFFLElBQUEsd0JBQVksRUFBQyxRQUFRLENBQUM7SUFDaEMsZ0JBQWdCLEVBQUUsV0FBVyxhQUFYLFdBQVcsdUJBQVgsV0FBVyxDQUFFO0VBQ2pDLENBQUM7RUFDRCxJQUFJLGVBQWUsRUFBRTtJQUNuQixXQUFXLEdBQUc7TUFDWixHQUFHLFdBQVc7TUFDZCxZQUFZLEVBQUUsSUFBQSwyQkFBZSxFQUFDLFlBQVksSUFBSSxRQUFRLElBQUksR0FBRyxDQUFDO01BQzlELG9CQUFvQixFQUFFLElBQUEsMkJBQWUsRUFDbkMsb0JBQW9CLElBQUksWUFBWSxJQUFJLFFBQVEsSUFBSSxHQUN0RCxDQUFDO01BQ0QsYUFBYSxFQUFFLElBQUEsMkJBQWUsRUFBQyxDQUFBLGVBQWUsYUFBZixlQUFlLHVCQUFmLGVBQWUsQ0FBRSxnQkFBZ0IsS0FBSSxHQUFHO0lBQ3pFLENBQUM7RUFDSCxDQUFDLE1BQU07SUFDTCxXQUFXLEdBQUc7TUFDWixHQUFHLFdBQVc7TUFDZCxRQUFRLEVBQ04sZUFBZSxLQUFLLHFCQUFnQixDQUFDLElBQUksR0FDckMsS0FBSyxHQUNMLElBQUEsMkJBQWUsRUFBQyxRQUFRO0lBQ2hDLENBQUM7RUFDSDs7RUFFQTtFQUNBLE1BQU0sbUJBQW1CLEdBQUcsSUFBQSxnQ0FBMEIsRUFBQyxXQUFXLENBQUM7RUFFbkUsSUFBSSxXQUFXLEtBQUssaUJBQVksQ0FBQyxLQUFLLEVBQUU7SUFDdEMsV0FBVyxHQUFHO01BQUUsR0FBRyxXQUFXO01BQUUsUUFBUSxFQUFFO0lBQWdCLENBQUM7RUFDN0Q7O0VBRUE7RUFDQSxNQUFNLG1CQUFtQixHQUFHLElBQUEsZ0NBQTBCLEVBQUMsV0FBVyxDQUFDO0VBRW5FLE1BQU0sQ0FBQyxzQkFBc0IsQ0FBQyxHQUFHLElBQUEsc0NBQWtCLEVBQUMsbUJBQW1CLEVBQUU7SUFDdkUsZ0JBQWdCLEVBQUUsdUJBQXVCO0lBQ3pDLFFBQVEsRUFBRTtFQUNaLENBQUMsQ0FBQztFQUVGLE9BQU87SUFDTCxzQkFBc0I7SUFDdEIsbUJBQW1CO0lBQ25CO0VBQ0YsQ0FBQztBQUNIOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ2hIQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxXQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsc0JBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxJQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsVUFBQSxHQUFBLE9BQUE7QUFJQSxJQUFBLGFBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxLQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsS0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFFBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxjQUFBLEdBQUEsT0FBQTtBQUVBLE1BQU0sMkJBQTJCLEdBQUcsR0FBRztBQUV2QyxNQUFNLGdCQUFnQixHQUFHLENBQUMsUUFBUSxFQUFFLGVBQWUsS0FBSztFQUN0RCxNQUFNLGNBQWMsR0FBRyxJQUFJLGdCQUFPLENBQUMsUUFBUSxFQUFFLEVBQUUsQ0FBQyxDQUFDLFFBQVEsQ0FDdkQsSUFBSSxnQkFBTyxDQUFDLGVBQWUsSUFBSSxlQUFVLENBQUMsTUFBTSxFQUFFLEVBQUUsQ0FDdEQsQ0FBQztFQUVELElBQUksY0FBYyxFQUFFO0lBQ2xCLE9BQU8scUJBQWUsQ0FBQyx1QkFBdUI7RUFDaEQ7RUFDQSxPQUFPLFNBQVM7QUFDbEIsQ0FBQztBQUVELE1BQU0sc0JBQXNCLEdBQUcsQ0FBQyxvQkFBb0IsRUFBRSxlQUFlLEtBQUs7RUFDeEUsSUFBSSxDQUFDLGVBQWUsRUFBRTtJQUNwQixPQUFPLFNBQVM7RUFDbEI7RUFDQSxJQUFJLElBQUEsZ0JBQVUsRUFBQyxvQkFBb0IsRUFBRSxDQUFDLENBQUMsRUFBRTtJQUN2QyxPQUFPLHFCQUFlLENBQUMsOEJBQThCO0VBQ3ZEO0VBQ0EsT0FBTyxTQUFTO0FBQ2xCLENBQUM7QUFFRCxNQUFNLGNBQWMsR0FBRyxDQUNyQixZQUFZLEVBQ1osbUJBQW1CLEVBQ25CLG9CQUFvQixFQUNwQixlQUFlLEtBQ1o7RUFDSCxJQUFJLG1CQUFtQixJQUFJLENBQUMsZUFBZSxFQUFFO0lBQzNDLE9BQU8sU0FBUztFQUNsQjtFQUNBLElBQUksSUFBQSxtQkFBYSxFQUFDLG9CQUFvQixFQUFFLFlBQVksQ0FBQyxFQUFFO0lBQ3JELE9BQU8scUJBQWUsQ0FBQyxpQkFBaUI7RUFDMUM7RUFDQSxPQUFPLFNBQVM7QUFDbEIsQ0FBQztBQUVELE1BQU0sZ0JBQWdCLEdBQUcsQ0FDdkIsc0JBQXNCLEVBQ3RCLFFBQVEsRUFDUixlQUFlLEVBQ2YsV0FBVyxLQUNSO0VBQUEsSUFBQSxxQkFBQTtFQUNILElBQUksZUFBZSxJQUFJLHNCQUFzQixFQUFFO0lBQzdDLE9BQU8sU0FBUztFQUNsQjtFQUNBLElBQ0UsQ0FBQyxDQUFDLGVBQWUsSUFBSSxXQUFXLGFBQVgsV0FBVyxnQkFBQSxxQkFBQSxHQUFYLFdBQVcsQ0FBRSxRQUFRLGNBQUEscUJBQUEsZUFBckIscUJBQUEsQ0FBdUIsUUFBUSxLQUNwRCxJQUFBLGdCQUFVLEVBQUMsUUFBUSxJQUFJLENBQUMsRUFBRSxDQUFDLENBQUMsRUFDNUI7SUFDQSxPQUFPLHFCQUFlLENBQUMsaUJBQWlCO0VBQzFDO0VBQ0EsT0FBTyxTQUFTO0FBQ2xCLENBQUM7QUFFRCxNQUFNLHdCQUF3QixHQUFHLENBQy9CLGVBQWUsRUFDZixzQkFBc0IsRUFDdEIscUJBQXFCLEVBQ3JCLG9CQUFvQixFQUNwQixlQUFlLEtBQ1o7RUFBQSxJQUFBLG9CQUFBO0VBQ0gsSUFBSSxDQUFDLGVBQWUsSUFBSSxDQUFDLHNCQUFzQixJQUFJLHFCQUFxQixFQUFFO0lBQ3hFLE9BQU8sU0FBUztFQUNsQjtFQUNBLElBQ0UsSUFBQSxnQkFBVSxFQUNSLG9CQUFvQixFQUNwQixlQUFlLGFBQWYsZUFBZSxnQkFBQSxvQkFBQSxHQUFmLGVBQWUsQ0FBRSxHQUFHLGNBQUEsb0JBQUEsdUJBQXBCLG9CQUFBLENBQXNCLDZCQUN4QixDQUFDLEVBQ0Q7SUFDQSxPQUFPLHFCQUFlLENBQUMsd0JBQXdCO0VBQ2pEO0VBQ0EsSUFDRSxlQUFlLGFBQWYsZUFBZSxlQUFmLGVBQWUsQ0FBRSxJQUFJLElBQ3JCLElBQUEsbUJBQWEsRUFDWCxvQkFBb0IsRUFDcEIsZUFBZSxDQUFDLElBQUksQ0FBQyw2QkFBNkIsR0FDaEQsMkJBQ0osQ0FBQyxFQUNEO0lBQ0EsT0FBTyxxQkFBZSxDQUFDLDZCQUE2QjtFQUN0RDtFQUNBLE9BQU8sU0FBUztBQUNsQixDQUFDO0FBRUQsTUFBTSxnQkFBZ0IsR0FBRyxDQUN2QixlQUFlLEVBQ2YscUJBQXFCLEVBQ3JCLHNCQUFzQixFQUN0QixXQUFXLEVBQ1gsbUJBQW1CLEVBQ25CLFlBQVksRUFDWixlQUFlLEtBQ1o7RUFBQSxJQUFBLHFCQUFBO0VBQ0gsSUFDRSxtQkFBbUIsSUFDbkIsV0FBVyxJQUNYLENBQUMsc0JBQXNCLElBQ3ZCLENBQUMsZUFBZSxJQUNoQixxQkFBcUIsRUFDckI7SUFDQSxPQUFPLFNBQVM7RUFDbEI7RUFDQSxJQUFJLElBQUEsZ0JBQVUsRUFBQyxZQUFZLEVBQUUsZUFBZSxhQUFmLGVBQWUsZ0JBQUEscUJBQUEsR0FBZixlQUFlLENBQUUsR0FBRyxjQUFBLHFCQUFBLHVCQUFwQixxQkFBQSxDQUFzQixxQkFBcUIsQ0FBQyxFQUFFO0lBQ3pFLE9BQU8scUJBQWUsQ0FBQyxlQUFlO0VBQ3hDO0VBQ0EsSUFDRSxlQUFlLGFBQWYsZUFBZSxlQUFmLGVBQWUsQ0FBRSxJQUFJLElBQ3JCLElBQUEsbUJBQWEsRUFDWCxZQUFZLEVBQ1osZUFBZSxDQUFDLElBQUksQ0FBQyxxQkFBcUIsR0FBRywyQkFDL0MsQ0FBQyxFQUNEO0lBQ0EsT0FBTyxxQkFBZSxDQUFDLG9CQUFvQjtFQUM3QztFQUNBLE9BQU8sU0FBUztBQUNsQixDQUFDO0FBRUQsTUFBTSxlQUFlLEdBQUcsQ0FBQyxtQkFBbUIsRUFBRSxXQUFXLEVBQUUsVUFBVSxLQUFLO0VBQUEsSUFBQSxzQkFBQTtFQUN4RSxJQUFJLG1CQUFtQixLQUFLLFNBQVMsSUFBSSxVQUFVLEtBQUssU0FBUyxFQUFFO0lBQ2pFLE9BQU8sS0FBSztFQUNkO0VBQ0EsTUFBTSxxQkFBcUIsR0FBRyxJQUFJLGdCQUFPLENBQUMsbUJBQW1CLEVBQUUsRUFBRSxDQUFDLENBQUMsR0FBRyxDQUNwRSxJQUFJLGdCQUFPLENBQUMsQ0FBQSxXQUFXLGFBQVgsV0FBVyxnQkFBQSxzQkFBQSxHQUFYLFdBQVcsQ0FBRSxRQUFRLGNBQUEsc0JBQUEsdUJBQXJCLHNCQUFBLENBQXVCLEtBQUssS0FBSSxLQUFLLEVBQUUsRUFBRSxDQUN2RCxDQUFDO0VBQ0QsTUFBTSxrQkFBa0IsR0FBRyxJQUFJLGdCQUFPLENBQUMsVUFBVSxFQUFFLEVBQUUsQ0FBQztFQUV0RCxPQUFPLHFCQUFxQixDQUFDLFdBQVcsQ0FBQyxrQkFBa0IsQ0FBQztBQUM5RCxDQUFDOztBQUVEO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTyxTQUFTLGVBQWUsQ0FBQztFQUM5QixlQUFlO0VBQ2YsZUFBZTtFQUNmLHFCQUFxQjtFQUNyQixRQUFRO0VBQ1IsUUFBUTtFQUNSLG9CQUFvQjtFQUNwQixZQUFZO0VBQ1osbUJBQW1CO0VBQ25CLGVBQWU7RUFDZjtBQUNGLENBQUMsRUFBRTtFQUNELE1BQU0sZUFBZSxHQUNuQixJQUFBLHVCQUFXLEVBQUMsNkNBQWtDLENBQUMsSUFDL0MsQ0FBQyxJQUFBLGlDQUFtQixFQUFDLFdBQVcsYUFBWCxXQUFXLHVCQUFYLFdBQVcsQ0FBRSxRQUFRLENBQUM7RUFFN0MsTUFBTSxzQkFBc0IsR0FBRyxlQUFlLEtBQUsscUJBQWdCLENBQUMsU0FBUzs7RUFFN0U7RUFDQSxNQUFNLGFBQWEsR0FBRyxnQkFBZ0IsQ0FBQyxRQUFRLEVBQUUsZUFBZSxDQUFDO0VBRWpFLE1BQU0sbUJBQW1CLEdBQUcsc0JBQXNCLENBQ2hELG9CQUFvQixFQUNwQixlQUNGLENBQUM7RUFFRCxNQUFNLFdBQVcsR0FBRyxjQUFjLENBQ2hDLFlBQVksRUFDWixtQkFBbUIsRUFDbkIsb0JBQW9CLEVBQ3BCLGVBQ0YsQ0FBQztFQUVELE1BQU0sYUFBYSxHQUFHLGdCQUFnQixDQUNwQyxzQkFBc0IsRUFDdEIsUUFBUSxFQUNSLGVBQWUsRUFDZixXQUNGLENBQUM7O0VBRUQ7RUFDQSxNQUFNLHFCQUFxQixHQUFHLHdCQUF3QixDQUNwRCxlQUFlLEVBQ2Ysc0JBQXNCLEVBQ3RCLHFCQUFxQixFQUNyQixvQkFBb0IsRUFDcEIsZUFDRixDQUFDO0VBRUQsTUFBTSxhQUFhLEdBQUcsZ0JBQWdCLENBQ3BDLGVBQWUsRUFDZixxQkFBcUIsRUFDckIsc0JBQXNCLEVBQ3RCLFdBQVcsRUFDWCxtQkFBbUIsRUFDbkIsWUFBWSxFQUNaLGVBQ0YsQ0FBQzs7RUFFRDtFQUNBOztFQUVBLE1BQU0sU0FBUyxHQUFHLElBQUEsY0FBTyxFQUFDLE1BQU07SUFDOUIsTUFBTSxNQUFNLEdBQUcsQ0FBQyxDQUFDO0lBQ2pCLElBQUksYUFBYSxFQUFFO01BQ2pCLE1BQU0sQ0FBQyxRQUFRLEdBQUcsYUFBYTtJQUNqQztJQUNBLElBQUksbUJBQW1CLEVBQUU7TUFDdkIsTUFBTSxDQUFDLGNBQWMsR0FBRyxtQkFBbUI7SUFDN0M7SUFDQSxJQUFJLFdBQVcsRUFBRTtNQUNmLE1BQU0sQ0FBQyxNQUFNLEdBQUcsV0FBVztJQUM3QjtJQUNBLElBQUksYUFBYSxFQUFFO01BQ2pCLE1BQU0sQ0FBQyxRQUFRLEdBQUcsYUFBYTtJQUNqQztJQUNBLE9BQU8sTUFBTTtFQUNmLENBQUMsRUFBRSxDQUFDLGFBQWEsRUFBRSxtQkFBbUIsRUFBRSxXQUFXLEVBQUUsYUFBYSxDQUFDLENBQUM7RUFFcEUsTUFBTSxXQUFXLEdBQUcsSUFBQSxjQUFPLEVBQUMsTUFBTTtJQUNoQyxNQUFNLFFBQVEsR0FBRyxDQUFDLENBQUM7SUFDbkIsSUFBSSxxQkFBcUIsRUFBRTtNQUN6QixRQUFRLENBQUMsY0FBYyxHQUFHLHFCQUFxQjtJQUNqRDtJQUNBLElBQUksYUFBYSxFQUFFO01BQ2pCLFFBQVEsQ0FBQyxNQUFNLEdBQUcsYUFBYTtJQUNqQztJQUNBLE9BQU8sUUFBUTtFQUNqQixDQUFDLEVBQUUsQ0FBQyxxQkFBcUIsRUFBRSxhQUFhLENBQUMsQ0FBQzs7RUFFMUM7RUFDQSxNQUFNLFlBQVksR0FBRyxPQUFPLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsQ0FBQyxNQUFNLENBQUM7O0VBRTNEO0VBQ0E7RUFDQSxNQUFNLGlCQUFpQixHQUFHLElBQUEsY0FBTyxFQUMvQixPQUFPO0lBQ0wsR0FBRyxXQUFXO0lBQ2QsR0FBRztFQUNMLENBQUMsQ0FBQyxFQUNGLENBQUMsU0FBUyxFQUFFLFdBQVcsQ0FDekIsQ0FBQztFQUVELE1BQU0sT0FBTyxHQUFHLElBQUEsdUJBQVcsRUFDeEIsS0FBSztJQUFBLElBQUEsc0JBQUE7SUFBQSxPQUFLLElBQUEsMkJBQWdCLEVBQUMsS0FBSyxFQUFFLFdBQVcsYUFBWCxXQUFXLGdCQUFBLHNCQUFBLEdBQVgsV0FBVyxDQUFFLFFBQVEsY0FBQSxzQkFBQSx1QkFBckIsc0JBQUEsQ0FBdUIsSUFBSSxDQUFDO0VBQUEsR0FDL0Qsd0JBQ0YsQ0FBQzs7RUFFRDtFQUNBLE1BQU0sWUFBWSxHQUNoQixPQUFPLEtBQUssU0FBUyxJQUNyQixDQUFBLFdBQVcsYUFBWCxXQUFXLHVCQUFYLFdBQVcsQ0FBRSxJQUFJLE1BQUssc0NBQWUsQ0FBQyxRQUFRLElBQzlDLENBQUEsV0FBVyxhQUFYLFdBQVcsdUJBQVgsV0FBVyxDQUFFLE1BQU0sS0FBSSxrQ0FBbUIsR0FDdEMsZUFBZSxDQUFDLG1CQUFtQixFQUFFLFdBQVcsRUFBRSxPQUFPLENBQUMsT0FBTyxDQUFDLEdBQ2xFLEtBQUs7RUFFWCxPQUFPO0lBQ0wsU0FBUyxFQUFFLGlCQUFpQjtJQUM1QixZQUFZO0lBQ1osWUFBWTtJQUNaLGtCQUFrQixFQUFFLE9BQU8sQ0FBQyxXQUFXLGFBQVgsV0FBVyx1QkFBWCxXQUFXLENBQUUsZUFBZTtFQUMxRCxDQUFDO0FBQ0g7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDbFNBLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFdBQUEsR0FBQSxPQUFBO0FBRUEsSUFBQSxJQUFBLEdBQUEsT0FBQTtBQU1BLElBQUEsS0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFVBQUEsR0FBQSxPQUFBO0FBS0EsSUFBQSxhQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsbUJBQUEsR0FBQSxPQUFBO0FBRUEsSUFBQSxLQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsV0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFFBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxPQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsZ0JBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxpQkFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLHFCQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsNkJBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxnQkFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLHdCQUFBLEdBQUEsT0FBQTtBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUEsTUFBTSx5QkFBeUIsR0FBRyxHQUFHO0FBQzlCLFNBQVMsZUFBZSxDQUM3QixvQkFBb0IsR0FBRyx1QkFBa0IsQ0FBQyxNQUFNLEVBQ2hELFlBQVksRUFDWixlQUFlLEdBQUcsUUFBUSxFQUMxQixXQUFXLEdBQUcsaUJBQVksQ0FBQyxhQUFhLEVBQ3hDO0VBQUEsSUFBQSxxQkFBQTtFQUNBLE1BQU0sa0JBQWtCLEdBQUc7SUFDekIsUUFBUSxFQUFFLFlBQVksYUFBWixZQUFZLHVCQUFaLFlBQVksQ0FBRSxRQUFRO0lBQ2hDLEVBQUUsRUFBRSxZQUFZLGFBQVosWUFBWSx1QkFBWixZQUFZLENBQUUsRUFBRTtJQUNwQixZQUFZLEVBQUUsWUFBWSxhQUFaLFlBQVksdUJBQVosWUFBWSxDQUFFLFlBQVk7SUFDeEMsbUJBQW1CLEVBQUUsWUFBWSxhQUFaLFlBQVksdUJBQVosWUFBWSxDQUFFLG1CQUFtQjtJQUN0RCxrQkFBa0IsRUFBRSxZQUFZLGFBQVosWUFBWSx1QkFBWixZQUFZLENBQUU7RUFDcEMsQ0FBQztFQUVELElBQUksWUFBWSxhQUFaLFlBQVksZUFBWixZQUFZLENBQUUsV0FBVyxFQUFFO0lBQzdCLGtCQUFrQixDQUFDLFdBQVcsR0FBRyxZQUFZLGFBQVosWUFBWSx1QkFBWixZQUFZLENBQUUsV0FBVztFQUM1RDtFQUVBLE1BQU0sQ0FBQyxXQUFXLEVBQUUsY0FBYyxDQUFDLEdBQUcsSUFBQSxlQUFRLEVBQUMsa0JBQWtCLENBQUM7RUFFbEUsTUFBTSxXQUFXLEdBQUcsSUFBQSxrQ0FBNEIsRUFBQyxXQUFXLENBQUMsR0FDekQsV0FBVyxHQUNYLFlBQVk7RUFFaEIsTUFBTSxPQUFPLEdBQUcsSUFBQSx1QkFBVyxFQUFFLEtBQUssSUFDaEMsSUFBQSw4Q0FBbUMsRUFBQyxLQUFLLEVBQUUsV0FBVyxhQUFYLFdBQVcsdUJBQVgsV0FBVyxDQUFFLE9BQU8sQ0FDakUsQ0FBQztFQUVELE1BQU0sZUFBZSxHQUNuQixPQUFPLGFBQVAsT0FBTyxnQkFBQSxxQkFBQSxHQUFQLE9BQU8sQ0FBRSxZQUFZLGNBQUEscUJBQUEsZ0JBQUEscUJBQUEsR0FBckIscUJBQUEsQ0FBd0IsT0FBTyxhQUFQLE9BQU8sdUJBQVAsT0FBTyxDQUFFLHVCQUF1QixDQUFDLGNBQUEscUJBQUEsdUJBQXpELHFCQUFBLENBQTJELGVBQWU7RUFFNUUsTUFBTSxlQUFlLEdBQ25CLElBQUEsdUJBQVcsRUFBQyw2Q0FBa0MsQ0FBQyxJQUMvQyxDQUFDLElBQUEsaUNBQW1CLEVBQUMsV0FBVyxhQUFYLFdBQVcsdUJBQVgsV0FBVyxDQUFFLFFBQVEsQ0FBQzs7RUFFN0M7RUFDQTtFQUNBO0VBQ0EsTUFBTTtJQUNKLGVBQWU7SUFDZixlQUFlO0lBQ2YscUJBQXFCO0lBQ3JCO0VBQ0YsQ0FBQyxHQUFHLElBQUEsc0NBQWtCLEVBQUMsZUFBZSxDQUFDO0VBRXZDLE1BQU0sc0JBQXNCLEdBQUcsSUFBQSx1QkFBVyxFQUFDLG9DQUF5QixDQUFDO0VBRXJFLE1BQU0sQ0FBQyxhQUFhLEVBQUUsd0JBQXdCLENBQUMsR0FBRyxJQUFBLGVBQVEsRUFBQyxNQUFNO0lBQUEsSUFBQSxxQkFBQSxFQUFBLHNCQUFBO0lBQy9ELElBQ0Usc0JBQXNCLElBQ3RCLFdBQVcsYUFBWCxXQUFXLGdCQUFBLHFCQUFBLEdBQVgsV0FBVyxDQUFFLFFBQVEsY0FBQSxxQkFBQSxlQUFyQixxQkFBQSxDQUF1QixvQkFBb0IsSUFDM0MsV0FBVyxhQUFYLFdBQVcsZ0JBQUEsc0JBQUEsR0FBWCxXQUFXLENBQUUsUUFBUSxjQUFBLHNCQUFBLGVBQXJCLHNCQUFBLENBQXVCLFlBQVksRUFDbkM7TUFDQSxPQUFPLElBQUk7SUFDYjtJQUNBLElBQUksV0FBVyxFQUFFO01BQ2YsT0FBTyxDQUFBLFdBQVcsYUFBWCxXQUFXLHVCQUFYLFdBQVcsQ0FBRSxZQUFZLEtBQUksSUFBSTtJQUMxQztJQUNBLE9BQU8sb0JBQW9CO0VBQzdCLENBQUMsQ0FBQztFQUVGLE1BQU0sQ0FBQyxZQUFZLEVBQUUsZUFBZSxDQUFDLEdBQUcsSUFBQSxlQUFRLEVBQUMsTUFBTTtJQUNyRCxJQUFJLGFBQWEsRUFBRTtNQUNqQixPQUFPLGFBQWE7SUFDdEI7SUFDQSxPQUFPLG1CQUFjLENBQUMsTUFBTTtFQUM5QixDQUFDLENBQUM7RUFFRixNQUFNLENBQUMsUUFBUSxFQUFFLFdBQVcsQ0FBQyxHQUFHLElBQUEsZUFBUSxFQUFDO0lBQUEsSUFBQSxzQkFBQSxFQUFBLHNCQUFBO0lBQUEsT0FDdkMsTUFBTSxDQUNKLElBQUEsd0JBQVksRUFDVixDQUFBLFdBQVcsYUFBWCxXQUFXLGdCQUFBLHNCQUFBLEdBQVgsV0FBVyxDQUFFLFFBQVEsY0FBQSxzQkFBQSx1QkFBckIsc0JBQUEsQ0FBdUIsUUFBUSxNQUFJLFdBQVcsYUFBWCxXQUFXLGdCQUFBLHNCQUFBLEdBQVgsV0FBVyxDQUFFLFFBQVEsY0FBQSxzQkFBQSx1QkFBckIsc0JBQUEsQ0FBdUIsR0FBRyxLQUFJLEtBQ25FLENBQ0YsQ0FBQztFQUFBLENBQ0gsQ0FBQztFQUVELE1BQU0sY0FBYyxHQUFHLE1BQU0sQ0FBQyxJQUFBLHdCQUFZLEVBQUMsV0FBVyxhQUFYLFdBQVcsdUJBQVgsV0FBVyxDQUFFLG1CQUFtQixDQUFDLENBQUM7O0VBRTdFO0FBQ0Y7QUFDQTtBQUNBO0FBQ0E7RUFDRSxJQUFBLGdCQUFTLEVBQUMsTUFBTTtJQUNkLElBQUksZUFBZSxFQUFFO01BQUEsSUFBQSxzQkFBQSxFQUFBLHNCQUFBLEVBQUEsc0JBQUEsRUFBQSxzQkFBQTtNQUNuQixJQUFJLFdBQVcsYUFBWCxXQUFXLGVBQVgsV0FBVyxDQUFFLFlBQVksRUFBRTtRQUM3Qix3QkFBd0IsQ0FBQyxXQUFXLGFBQVgsV0FBVyx1QkFBWCxXQUFXLENBQUUsWUFBWSxDQUFDO01BQ3JEO01BRUEsTUFBTSxVQUFVLEdBQUcsSUFBSSxnQkFBTyxDQUFDLENBQUEsV0FBVyxhQUFYLFdBQVcsZ0JBQUEsc0JBQUEsR0FBWCxXQUFXLENBQUUsUUFBUSxjQUFBLHNCQUFBLHVCQUFyQixzQkFBQSxDQUF1QixHQUFHLEtBQUksS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUNwRSxLQUFLLENBQUMsSUFBSSxnQkFBTyxDQUFDLENBQUEsV0FBVyxhQUFYLFdBQVcsZ0JBQUEsc0JBQUEsR0FBWCxXQUFXLENBQUUsUUFBUSxjQUFBLHNCQUFBLHVCQUFyQixzQkFBQSxDQUF1QixZQUFZLEtBQUksS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQ3BFLG1CQUFtQixDQUFDLENBQUM7TUFFeEIsTUFBTSxHQUFHLEdBQUcsSUFBSSxnQkFBTyxDQUFDLFVBQVUsRUFBRSxFQUFFLEVBQUUseUJBQWlCLENBQUMsR0FBRyxDQUFDLENBQzNELGNBQWMsQ0FBQyx5QkFBaUIsQ0FBQyxHQUFHLENBQUMsQ0FDckMsTUFBTSxDQUFDLEVBQUUsQ0FBQyxDQUNWLFFBQVEsQ0FBQyxDQUFDO01BRWIsSUFBSSxNQUFNLENBQUMsR0FBRyxDQUFDLEdBQUcsTUFBTSxDQUFDLHlCQUF5QixDQUFDLEVBQUU7UUFDbkQsZUFBZSxDQUFDLG1CQUFjLENBQUMsaUJBQWlCLENBQUM7TUFDbkQsQ0FBQyxNQUFNLElBQUksV0FBVyxhQUFYLFdBQVcsZUFBWCxXQUFXLENBQUUsWUFBWSxFQUFFO1FBQ3BDLGVBQWUsQ0FBQyxXQUFXLGFBQVgsV0FBVyx1QkFBWCxXQUFXLENBQUUsWUFBWSxDQUFDO01BQzVDO01BRUEsV0FBVyxDQUNULE1BQU0sQ0FDSixJQUFBLHdCQUFZLEVBQ1YsQ0FBQSxXQUFXLGFBQVgsV0FBVyxnQkFBQSxzQkFBQSxHQUFYLFdBQVcsQ0FBRSxRQUFRLGNBQUEsc0JBQUEsdUJBQXJCLHNCQUFBLENBQXVCLFFBQVEsTUFDN0IsV0FBVyxhQUFYLFdBQVcsZ0JBQUEsc0JBQUEsR0FBWCxXQUFXLENBQUUsUUFBUSxjQUFBLHNCQUFBLHVCQUFyQixzQkFBQSxDQUF1QixHQUFHLEtBQzFCLEtBQ0osQ0FDRixDQUNGLENBQUM7SUFDSDtFQUNGLENBQUMsRUFBRSxDQUNELGVBQWUsRUFDZixXQUFXLEVBQ1gsd0JBQXdCLEVBQ3hCLGVBQWUsRUFDZixXQUFXLENBQ1osQ0FBQztFQUVGLE1BQU07SUFBRSxRQUFRO0lBQUUsV0FBVztJQUFFO0VBQThCLENBQUMsR0FDNUQsSUFBQSxrQ0FBZ0IsRUFBQztJQUNmLGFBQWE7SUFDYixlQUFlO0lBQ2YsZUFBZTtJQUNmO0VBQ0YsQ0FBQyxDQUFDO0VBRUosTUFBTTtJQUFFLFlBQVk7SUFBRTtFQUFnQixDQUFDLEdBQUcsSUFBQSwwQ0FBb0IsRUFBQztJQUM3RCxhQUFhO0lBQ2IsZUFBZTtJQUNmLGVBQWU7SUFDZjtFQUNGLENBQUMsQ0FBQztFQUVGLE1BQU07SUFBRSxvQkFBb0I7SUFBRTtFQUF3QixDQUFDLEdBQ3JELElBQUEsMERBQTRCLEVBQUM7SUFDM0IsYUFBYTtJQUNiLGVBQWU7SUFDZixlQUFlO0lBQ2Y7RUFDRixDQUFDLENBQUM7RUFFSixNQUFNO0lBQUUsc0JBQXNCO0lBQUUsbUJBQW1CO0lBQUU7RUFBb0IsQ0FBQyxHQUN4RSxJQUFBLGdDQUFlLEVBQUM7SUFDZCxXQUFXO0lBQ1gsZUFBZTtJQUNmLGVBQWU7SUFDZixRQUFRO0lBQ1IsUUFBUTtJQUNSLFlBQVk7SUFDWixvQkFBb0I7SUFDcEIsZUFBZTtJQUNmO0VBQ0YsQ0FBQyxDQUFDO0VBRUosTUFBTTtJQUFFLFlBQVk7SUFBRSxTQUFTO0lBQUUsWUFBWTtJQUFFO0VBQW1CLENBQUMsR0FDakUsSUFBQSxnQ0FBZSxFQUFDO0lBQ2QsZUFBZTtJQUNmLGVBQWU7SUFDZixxQkFBcUI7SUFDckIsUUFBUTtJQUNSLFFBQVE7SUFDUixvQkFBb0I7SUFDcEIsWUFBWTtJQUNaLG1CQUFtQjtJQUNuQixlQUFlO0lBQ2Y7RUFDRixDQUFDLENBQUM7RUFFSixNQUFNLDZCQUE2QixHQUFHLElBQUEsa0JBQVcsRUFBQyxNQUFNO0lBQ3RELElBQUksU0FBUyxDQUFDLFFBQVEsS0FBSyxxQkFBZSxDQUFDLHVCQUF1QixFQUFFO01BQUEsSUFBQSxzQkFBQTtNQUNsRSxNQUFNLHNCQUFzQixHQUFHLElBQUEsd0JBQVksRUFBQyxXQUFXLGFBQVgsV0FBVyxnQkFBQSxzQkFBQSxHQUFYLFdBQVcsQ0FBRSxRQUFRLGNBQUEsc0JBQUEsdUJBQXJCLHNCQUFBLENBQXVCLEdBQUcsQ0FBQztNQUN2RSxNQUFNLGtCQUFrQixHQUFHLElBQUEsd0JBQVksRUFBQyxlQUFlLENBQUM7TUFDeEQsV0FBVyxDQUNULHNCQUFzQixHQUFHLGtCQUFrQixHQUN2QyxzQkFBc0IsR0FDdEIsa0JBQ04sQ0FBQztJQUNIO0VBQ0YsQ0FBQyxFQUFFLENBQUMsZUFBZSxFQUFFLFNBQVMsQ0FBQyxRQUFRLEVBQUUsV0FBVyxDQUFDLENBQUM7RUFFdEQsTUFBTTtJQUNKLGlCQUFpQjtJQUNqQixrQkFBa0I7SUFDbEIsaUJBQWlCO0lBQ2pCLDRDQUE0QztJQUM1Qyx5Q0FBeUM7SUFDekM7RUFDRixDQUFDLEdBQUcsSUFBQSxnREFBdUIsRUFBQztJQUMxQixvQkFBb0I7SUFDcEIsV0FBVztJQUNYLGVBQWU7SUFDZixRQUFRO0lBQ1Isb0JBQW9CO0lBQ3BCLGVBQWU7SUFDZixXQUFXO0lBQ1g7RUFDRixDQUFDLENBQUM7RUFFRixNQUFNLGNBQWMsR0FBRyxJQUFBLGtCQUFXLEVBQUMsTUFBTTtJQUN2Qyx3QkFBd0IsQ0FBQyx3QkFBbUIsQ0FBQztJQUM3Qyw2QkFBNkIsQ0FBQyxDQUFDO0lBQy9CO0lBQ0EsV0FBVyxDQUFDLFFBQVEsQ0FBQztJQUNyQixXQUFXLENBQUMsUUFBUSxDQUFDO0lBQ3JCLGVBQWUsQ0FBQyxZQUFZLENBQUM7SUFDN0IsdUJBQXVCLENBQUMsb0JBQW9CLENBQUM7SUFDN0MsNkJBQTZCLENBQUMsSUFBSSxDQUFDO0lBQ25DLGVBQWUsQ0FBQyxRQUFRLENBQUM7RUFDM0IsQ0FBQyxFQUFFLENBQ0Qsd0JBQXdCLEVBQ3hCLDZCQUE2QixFQUM3QixXQUFXLEVBQ1gsUUFBUSxFQUNSLFdBQVcsRUFDWCxRQUFRLEVBQ1IsZUFBZSxFQUNmLFlBQVksRUFDWix1QkFBdUIsRUFDdkIsb0JBQW9CLEVBQ3BCLDZCQUE2QixDQUM5QixDQUFDO0VBRUYsT0FBTztJQUNMLFdBQVc7SUFDWCxZQUFZO0lBQ1osb0JBQW9CO0lBQ3BCLFFBQVE7SUFDUixXQUFXO0lBQ1gsUUFBUTtJQUNSLFdBQVc7SUFDWCxjQUFjO0lBQ2QsV0FBVztJQUNYLGFBQWE7SUFDYixzQkFBc0I7SUFDdEIsbUJBQW1CO0lBQ25CLG1CQUFtQjtJQUNuQixZQUFZO0lBQ1osZUFBZTtJQUNmLGFBQWE7SUFDYixjQUFjO0lBQ2Q7SUFDQSxZQUFZO0lBQ1osU0FBUztJQUNULFlBQVk7SUFDWixrQkFBa0I7SUFDbEIsa0JBQWtCLEVBQUUsSUFBQSx3QkFBWSxFQUFDLGVBQWUsQ0FBQztJQUNqRCxlQUFlO0lBQ2YsaUJBQWlCO0lBQ2pCLGtCQUFrQjtJQUNsQixpQkFBaUI7SUFDakIsNENBQTRDO0lBQzVDLHlDQUF5QztJQUN6QztFQUNGLENBQUM7QUFDSDs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNuV0EsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFFQSxJQUFBLElBQUEsR0FBQSxPQUFBO0FBSUEsSUFBQSxhQUFBLEdBQUEsT0FBQTtBQUVBLElBQUEsV0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBRUEsU0FBUyxtQkFBbUIsQ0FBQyxlQUFlLEVBQUUsZUFBZSxFQUFFLGFBQWEsRUFBRTtFQUM1RSxJQUFJLGVBQWUsS0FBSyxxQkFBZ0IsQ0FBQyxNQUFNLEVBQUU7SUFDL0MsT0FBTyxDQUFBLGVBQWUsYUFBZixlQUFlLHVCQUFmLGVBQWUsQ0FBRyxhQUFhLENBQUMsS0FBSSxHQUFHO0VBQ2hELENBQUMsTUFBTSxJQUFJLGVBQWUsS0FBSyxxQkFBZ0IsQ0FBQyxXQUFXLEVBQUU7SUFDM0QsT0FBTyxDQUFBLGVBQWUsYUFBZixlQUFlLHVCQUFmLGVBQWUsQ0FBRSxRQUFRLEtBQUksR0FBRztFQUN6QztFQUNBLE9BQU8sR0FBRztBQUNaOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTyxTQUFTLGdCQUFnQixDQUFDO0VBQy9CLGFBQWE7RUFDYixlQUFlO0VBQ2YsZUFBZTtFQUNmO0FBQ0YsQ0FBQyxFQUFFO0VBQ0QsTUFBTSxDQUFDLDBCQUEwQixFQUFFLDZCQUE2QixDQUFDLEdBQUcsSUFBQSxlQUFRLEVBQzFFLENBQUEsV0FBVyxhQUFYLFdBQVcsdUJBQVgsV0FBVyxDQUFFLFlBQVksTUFBSyx3QkFDaEMsQ0FBQztFQUVELE1BQU0sQ0FBQyxRQUFRLEVBQUUsV0FBVyxDQUFDLEdBQUcsSUFBQSxlQUFRLEVBQUMsTUFBTTtJQUM3QyxNQUFNO01BQUUsUUFBUSxFQUFFO0lBQVcsQ0FBQyxHQUFHLENBQUEsV0FBVyxhQUFYLFdBQVcsdUJBQVgsV0FBVyxDQUFFLFFBQVEsS0FBSSxDQUFDLENBQUM7SUFDNUQsT0FBTyxVQUFVLElBQUksSUFBQSx5QkFBa0IsRUFBQyxXQUFXLENBQUMsR0FDaEQsTUFBTSxDQUFDLElBQUEsMkJBQWUsRUFBQyxVQUFVLENBQUMsQ0FBQyxHQUNuQyxJQUFJO0VBQ1YsQ0FBQyxDQUFDO0VBRUYsTUFBTSxDQUFDLHdCQUF3QixDQUFDLEdBQUcsSUFBQSxlQUFRLEVBQUMsZUFBZSxDQUFDO0VBQzVELE1BQU0sK0JBQStCLEdBQUcsSUFBQSxlQUFPLEVBQzdDLHdCQUF3QixFQUN4QixlQUNGLENBQUM7RUFFRCxNQUFNLGFBQWEsR0FDakIsUUFBUSxLQUFLLElBQUksS0FDaEIsMEJBQTBCLElBQ3pCLCtCQUErQixJQUMvQixJQUFBLGlDQUFtQixFQUFDLFdBQVcsYUFBWCxXQUFXLHVCQUFYLFdBQVcsQ0FBRSxRQUFRLENBQUMsQ0FBQyxHQUN6QyxRQUFRLEdBQ1IsbUJBQW1CLENBQUMsZUFBZSxFQUFFLGVBQWUsRUFBRSxhQUFhLENBQUM7RUFFMUUsT0FBTztJQUNMLFFBQVEsRUFBRSxhQUFhO0lBQ3ZCLFdBQVc7SUFDWDtFQUNGLENBQUM7QUFDSDs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUN2RUEsSUFBQSxZQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsU0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBT0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ08sTUFBTSw2QkFBNkIsR0FDeEMsWUFBdUMsSUFDcEM7RUFDSCxNQUFNO0lBQUUsS0FBSyxFQUFFO0VBQVEsQ0FBQyxHQUN0QixJQUFBLHdCQUFjLEVBQTJCLFlBQVk7SUFDbkQsSUFBSSxDQUFDLFlBQVksRUFBRTtNQUNqQixPQUFPLE9BQU8sQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDO0lBQzlCO0lBRUEsT0FBUSxNQUFNLElBQUEseUNBQWtDLEVBQzlDLFlBQ0YsQ0FBQztFQUNILENBQUMsRUFBRSxDQUFDLFlBQVksQ0FBQyxDQUFDO0VBRXBCLElBQUksQ0FBQyxPQUFPLEVBQUU7SUFDWixPQUFPO01BQUUsY0FBYyxFQUFFO0lBQVUsQ0FBQztFQUN0QztFQUVBLE1BQU07SUFBRSxRQUFRO0lBQUU7RUFBUyxDQUFDLEdBQUcsT0FBTyxJQUFJLENBQUMsQ0FBQztFQUU1QyxJQUFJLFFBQVEsS0FBSywwQkFBYSxDQUFDLEtBQUssRUFBRTtJQUNwQyxNQUFNLGNBQWMsR0FDbEIsSUFBQSwrQkFBd0IsRUFBQyxRQUFRLENBQUMsSUFBSSw2QkFBc0I7SUFDOUQsT0FBTyxDQUFDLGNBQWMsR0FBRyxjQUFjO0VBQ3pDO0VBRUEsT0FBTyxPQUFPO0FBQ2hCLENBQUM7QUFBQyxPQUFBLENBQUEsNkJBQUEsR0FBQSw2QkFBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUM1Q0YsSUFBQSxVQUFBLEdBQUEsc0JBQUEsQ0FBQSxPQUFBO0FBQ0EsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsV0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFlBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxJQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsbUJBQUEsR0FBQSxPQUFBO0FBQXVFLFNBQUEsdUJBQUEsQ0FBQSxXQUFBLENBQUEsSUFBQSxDQUFBLENBQUEsVUFBQSxHQUFBLENBQUEsS0FBQSxPQUFBLEVBQUEsQ0FBQTtBQUV2RTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTLHdCQUF3QixDQUFDLFdBQVcsRUFBRSxlQUFlLEVBQUU7RUFDOUQsTUFBTSxvQkFBb0IsR0FBRyxJQUFBLDBCQUFxQixFQUFDLFdBQVcsQ0FBQztFQUMvRCxNQUFNLHFCQUFxQixHQUFHLElBQUEsMkJBQWUsRUFBQyxlQUFlLENBQUM7RUFFOUQsT0FBTyxJQUFJLGtCQUFTLENBQUMsb0JBQW9CLEVBQUUsRUFBRSxDQUFDLENBQUMsV0FBVyxDQUN4RCxJQUFJLGtCQUFTLENBQUMscUJBQXFCLEVBQUUsRUFBRSxDQUN6QyxDQUFDLEdBQ0csb0JBQW9CLEdBQ3BCLHFCQUFxQjtBQUMzQjs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLFNBQVMscUJBQXFCLENBQUMsV0FBVyxFQUFFO0VBQ2pELE1BQU07SUFBRSxlQUFlLEdBQUcsQ0FBQztFQUFFLENBQUMsR0FBRyxJQUFBLHNDQUFrQixFQUNqRCxXQUFXLENBQUMsZUFDZCxDQUFDOztFQUVEO0VBQ0EsTUFBTSxpQkFBaUIsR0FBRyxJQUFBLGNBQU8sRUFBQyxNQUFNO0lBQUEsSUFBQSxxQkFBQSxFQUFBLHNCQUFBLEVBQUEscUJBQUEsRUFBQSxzQkFBQTtJQUN0QztJQUNBO0lBQ0E7SUFDQTtJQUNBO0lBQ0EsTUFBTSxvQkFBb0IsR0FBRztNQUMzQixRQUFRLEdBQUEscUJBQUEsR0FBRSxXQUFXLENBQUMsUUFBUSxjQUFBLHFCQUFBLHVCQUFwQixxQkFBQSxDQUFzQixHQUFHO01BQ25DLEdBQUcsR0FBQSxzQkFBQSxHQUFFLFdBQVcsQ0FBQyxRQUFRLGNBQUEsc0JBQUEsdUJBQXBCLHNCQUFBLENBQXNCO0lBQzdCLENBQUM7SUFFRCxNQUFNLHFCQUFxQixHQUN6QixDQUFBLGVBQWUsYUFBZixlQUFlLGdCQUFBLHFCQUFBLEdBQWYsZUFBZSxDQUFFLE1BQU0sY0FBQSxxQkFBQSx1QkFBdkIscUJBQUEsQ0FBeUIscUJBQXFCLEtBQUksR0FBRztJQUN2RCxNQUFNLDZCQUE2QixHQUNqQyxDQUFBLGVBQWUsYUFBZixlQUFlLGdCQUFBLHNCQUFBLEdBQWYsZUFBZSxDQUFFLE1BQU0sY0FBQSxzQkFBQSx1QkFBdkIsc0JBQUEsQ0FBeUIsNkJBQTZCLEtBQUksR0FBRztJQUUvRCxJQUFJLElBQUEsaUNBQW9CLEVBQUMsV0FBVyxDQUFDLEVBQUU7TUFBQSxJQUFBLHNCQUFBLEVBQUEsc0JBQUE7TUFDckMsTUFBTSx1QkFBdUIsSUFBQSxzQkFBQSxHQUFHLFdBQVcsQ0FBQyxRQUFRLGNBQUEsc0JBQUEsdUJBQXBCLHNCQUFBLENBQXNCLFlBQVk7TUFDbEUsTUFBTSwrQkFBK0IsSUFBQSxzQkFBQSxHQUNuQyxXQUFXLENBQUMsUUFBUSxjQUFBLHNCQUFBLHVCQUFwQixzQkFBQSxDQUFzQixvQkFBb0I7TUFFNUMsb0JBQW9CLENBQUMsWUFBWSxHQUMvQix1QkFBdUIsS0FBSyxTQUFTLElBQ3JDLHVCQUF1QixDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsR0FDbkMsS0FBSyxHQUNMLHdCQUF3QixDQUN0Qix1QkFBdUIsRUFDdkIscUJBQ0YsQ0FBQztNQUNQLG9CQUFvQixDQUFDLG9CQUFvQixHQUN2QywrQkFBK0IsS0FBSyxTQUFTLElBQzdDLCtCQUErQixDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsR0FDM0MsS0FBSyxHQUNMLHdCQUF3QixDQUN0QiwrQkFBK0IsRUFDL0IsNkJBQ0YsQ0FBQztJQUNULENBQUMsTUFBTTtNQUFBLElBQUEsc0JBQUE7TUFDTCxNQUFNLG1CQUFtQixJQUFBLHNCQUFBLEdBQUcsV0FBVyxDQUFDLFFBQVEsY0FBQSxzQkFBQSx1QkFBcEIsc0JBQUEsQ0FBc0IsUUFBUTtNQUMxRCxvQkFBb0IsQ0FBQyxRQUFRLEdBQzNCLG1CQUFtQixLQUFLLFNBQVMsSUFBSSxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLEdBQ3BFLEtBQUssR0FDTCx3QkFBd0IsQ0FDdEIsbUJBQW1CLEVBQ25CLHFCQUNGLENBQUM7SUFDVDtJQUNBLE9BQU8sb0JBQW9CO0VBQzdCLENBQUMsRUFBRSxDQUFDLFdBQVcsRUFBRSxlQUFlLENBQUMsQ0FBQztFQUVsQyxPQUFPLGlCQUFpQjtBQUMxQjs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNqR0EsSUFBQSxXQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsVUFBQSxHQUFBLE9BQUE7QUFFTyxNQUFNLFVBQVUsR0FBRyxDQUFBLEtBQU07RUFDOUIsT0FBTyxJQUFBLHVCQUFXLEVBQUMsK0NBQW9DLENBQUM7QUFDMUQsQ0FBQztBQUFDLE9BQUEsQ0FBQSxVQUFBLEdBQUEsVUFBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNMRixJQUFBLDZCQUFBLEdBQUEsT0FBQTtBQUVPLFNBQVMsd0JBQXdCLENBQUEsRUFBRztFQUN6QyxPQUFPLE9BQU8sQ0FDWixJQUFBLDBEQUE0QixFQUFDO0lBQUUsaUJBQWlCLEVBQUU7RUFBSyxDQUFDLENBQUMsQ0FBQyxNQUM1RCxDQUFDO0FBQ0g7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDTkEsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsV0FBQSxHQUFBLE9BQUE7QUFFQSxJQUFBLGdCQUFBLEdBQUEsT0FBQTtBQU1BLElBQUEsSUFBQSxHQUFBLE9BQUE7QUFNQSxJQUFBLFNBQUEsR0FBQSxPQUFBO0FBSUEsSUFBQSxRQUFBLEdBQUEsT0FBQTtBQUVBLElBQUEsUUFBQSxHQUFBLE9BQUE7QUFFQSxNQUFNLG1CQUFtQixHQUFHLENBQUEsS0FBTTtFQUFBLElBQUEscUJBQUEsRUFBQSxzQkFBQTtFQUNoQyxNQUFNLFFBQVEsR0FBRyxJQUFBLHVCQUFXLEVBQUMsQ0FBQztFQUM5QixNQUFNO0lBQUU7RUFBb0IsQ0FBQyxHQUFHLElBQUEsMEJBQWlCLEVBRS9DLENBQUM7RUFDSCxNQUFNLG1CQUFtQixHQUFHLElBQUEsdUJBQVcsRUFBQyxnQ0FBc0IsQ0FBQztFQUMvRCxNQUFNLGVBQWUsR0FBRyxJQUFBLHVCQUFXLEVBQUMsNkJBQXdCLENBQUM7RUFDN0QsTUFBTSxxQkFBcUIsR0FBRyxJQUFBLHVCQUFXLEVBQUMsbUNBQThCLENBQUM7RUFFekUsTUFBTSxJQUFJLEdBQ1IsQ0FBQSxtQkFBbUIsYUFBbkIsbUJBQW1CLGdCQUFBLHFCQUFBLEdBQW5CLG1CQUFtQixDQUFFLFNBQVMsY0FBQSxxQkFBQSx1QkFBOUIscUJBQUEsQ0FBZ0MsSUFBSSxNQUFJLG1CQUFtQixhQUFuQixtQkFBbUIsZ0JBQUEsc0JBQUEsR0FBbkIsbUJBQW1CLENBQUUsUUFBUSxjQUFBLHNCQUFBLHVCQUE3QixzQkFBQSxDQUErQixJQUFJO0VBRTdFLE1BQU0sY0FBYyxHQUFHLElBQUEsdUJBQVcsRUFDL0IsS0FBSyxJQUFLLElBQUksSUFBSSxJQUFBLHlCQUFlLEVBQUMsS0FBSyxFQUFFLElBQUksQ0FDaEQsQ0FBQztFQUVELElBQUEsZ0JBQVMsRUFBQyxNQUFNO0lBQ2QsSUFBSSxDQUFDLGNBQWMsRUFBRTtNQUNuQjtJQUNGO0lBQ0EsTUFBTSwyQkFBMkIsR0FBRyxNQUFBLENBQUEsS0FBWTtNQUM5QyxJQUNFLG1CQUFtQixLQUFLLHFDQUFvQixDQUFDLE1BQU0sSUFDbkQscUJBQXFCLEtBQUssd0NBQXVCLENBQUMsU0FBUyxFQUMzRDtRQUFBLElBQUEsaUJBQUE7UUFDQSxNQUFNLE9BQU8sR0FBRyxRQUFBLGlCQUFBLEdBQU0sTUFBTSxDQUFDLFNBQVMsY0FBQSxpQkFBQSxnQkFBQSxpQkFBQSxHQUFoQixpQkFBQSxDQUFrQixHQUFHLGNBQUEsaUJBQUEsdUJBQXJCLGlCQUFBLENBQXVCLFVBQVUsQ0FBQyxDQUFDO1FBQ3pELE1BQU0saUJBQWlCLEdBQUcsT0FBTyxhQUFQLE9BQU8sdUJBQVAsT0FBTyxDQUFFLElBQUksQ0FDcEMsTUFBTSxJQUFLLE1BQU0sQ0FBQyxRQUFRLEtBQUssTUFBTSxDQUFDLHFDQUFvQixDQUM3RCxDQUFDO1FBQ0QsUUFBUSxDQUNOLElBQUEsbUNBQThCLEVBQzVCLGlCQUFpQixHQUNiLHdDQUF1QixDQUFDLFNBQVMsR0FDakMsd0NBQXVCLENBQUMsWUFDOUIsQ0FDRixDQUFDO01BQ0g7SUFDRixDQUFDO0lBQ0QsTUFBTSx3QkFBd0IsR0FBRyxNQUFBLENBQUEsS0FBWTtNQUMzQyxJQUNFLG1CQUFtQixLQUFLLHFDQUFvQixDQUFDLE1BQU0sSUFDbkQscUJBQXFCLEtBQUssd0NBQXVCLENBQUMsU0FBUyxJQUMzRCxlQUFlLEtBQUssd0NBQXVCLENBQUMsSUFBSSxFQUNoRDtRQUNBLElBQUk7VUFDRixNQUFNLGtCQUFrQixHQUFHLE1BQU0sSUFBQSx1Q0FBOEIsRUFBQyxDQUFDO1VBQ2pFLFFBQVEsQ0FDTixJQUFBLDZCQUF3QixFQUN0QixrQkFBa0IsR0FDZCx3Q0FBdUIsQ0FBQyxRQUFRLEdBQ2hDLHdDQUF1QixDQUFDLGNBQzlCLENBQ0YsQ0FBQztRQUNILENBQUMsQ0FBQyxPQUFPLENBQVUsRUFBRTtVQUNuQixJQUFLLENBQUMsQ0FBVyxPQUFPLENBQUMsS0FBSyxDQUFDLDJCQUEyQixDQUFDLEVBQUU7WUFDM0QsUUFBUSxDQUNOLElBQUEsNkJBQXdCLEVBQ3RCLHdDQUF1QixDQUFDLGlCQUMxQixDQUNGLENBQUM7VUFDSCxDQUFDLE1BQU0sSUFBSyxDQUFDLENBQVcsT0FBTyxDQUFDLEtBQUssQ0FBQyw0QkFBNEIsQ0FBQyxFQUFFO1lBQ25FLFFBQVEsQ0FDTixJQUFBLDZCQUF3QixFQUFDLHdDQUF1QixDQUFDLFFBQVEsQ0FDM0QsQ0FBQztVQUNILENBQUMsTUFBTTtZQUNMLFFBQVEsQ0FDTixJQUFBLDZCQUF3QixFQUFDLHdDQUF1QixDQUFDLGNBQWMsQ0FDakUsQ0FBQztVQUNIO1FBQ0Y7TUFDRjtJQUNGLENBQUM7SUFDRCx3QkFBd0IsQ0FBQyxDQUFDO0lBQzFCLDJCQUEyQixDQUFDLENBQUM7RUFDL0IsQ0FBQyxFQUFFLENBQ0QsUUFBUSxFQUNSLG1CQUFtQixFQUNuQixjQUFjLEVBQ2QscUJBQXFCLEVBQ3JCLGVBQWUsQ0FDaEIsQ0FBQztFQUVGLElBQUEsZ0JBQVMsRUFBQyxNQUFNO0lBQ2QsSUFBSSxDQUFDLGNBQWMsRUFBRTtNQUNuQixPQUFPLFNBQVM7SUFDbEI7SUFDQSxPQUFPLE1BQU07TUFDWCxRQUFRLENBQUMsSUFBQSw2QkFBd0IsRUFBQyx3Q0FBdUIsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUNsRSxDQUFDO0VBQ0gsQ0FBQyxFQUFFLENBQUMsUUFBUSxDQUFDLENBQUM7RUFFZCxPQUFPO0lBQUU7RUFBZSxDQUFDO0FBQzNCLENBQUM7QUFBQyxJQUFBLFFBQUEsR0FBQSxPQUFBLENBQUEsT0FBQSxHQUVhLG1CQUFtQjs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNySGxDLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFdBQUEsR0FBQSxPQUFBO0FBRUEsSUFBQSxVQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsYUFBQSxHQUFBLE9BQUE7QUFFQSxJQUFBLFdBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUVBLE1BQU0sOEJBQThCLEdBQUcsQ0FBQyxXQUFXLEVBQUUsZUFBZSxLQUFLO0VBQ3ZFLElBQUksZUFBZSxhQUFmLGVBQWUsZUFBZixlQUFlLENBQUcsV0FBVyxhQUFYLFdBQVcsdUJBQVgsV0FBVyxDQUFFLFlBQVksQ0FBQyxFQUFFO0lBQ2hELE9BQU8sZUFBZSxDQUFDLFdBQVcsQ0FBQyxZQUFZLENBQUMsQ0FBQyxxQkFBcUI7RUFDeEU7RUFDQSxNQUFNO0lBQUUsWUFBWTtJQUFFO0VBQVMsQ0FBQyxHQUFHLENBQUEsV0FBVyxhQUFYLFdBQVcsdUJBQVgsV0FBVyxDQUFFLFFBQVEsS0FBSSxDQUFDLENBQUM7RUFDOUQsT0FBTyxNQUFNLENBQUMsSUFBQSwyQkFBZSxFQUFDLFlBQVksSUFBSSxRQUFRLENBQUMsQ0FBQztBQUMxRCxDQUFDOztBQUVEO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLFNBQVMsb0JBQW9CLENBQUM7RUFDbkMsYUFBYTtFQUNiLGVBQWU7RUFDZixlQUFlO0VBQ2Y7QUFDRixDQUFDLEVBQUU7RUFDRCxNQUFNLGVBQWUsR0FDbkIsSUFBQSx1QkFBVyxFQUFDLDZDQUFrQyxDQUFDLElBQy9DLENBQUMsSUFBQSxpQ0FBbUIsRUFBQyxXQUFXLGFBQVgsV0FBVyx1QkFBWCxXQUFXLENBQUUsUUFBUSxDQUFDO0VBRTdDLE1BQU0sbUJBQW1CLEdBQUcsZUFBZSxHQUN2Qyw4QkFBOEIsQ0FBQyxXQUFXLEVBQUUsZUFBZSxDQUFDLEdBQzVELENBQUM7O0VBRUw7RUFDQTtFQUNBO0VBQ0EsTUFBTSxDQUFDLFlBQVksRUFBRSxlQUFlLENBQUMsR0FBRyxJQUFBLGVBQVEsRUFBQyxNQUFNO0lBQ3JELElBQUksbUJBQW1CLElBQUksSUFBQSx5QkFBa0IsRUFBQyxXQUFXLENBQUMsRUFBRTtNQUMxRCxPQUFPLG1CQUFtQjtJQUM1QjtJQUNBLE9BQU8sSUFBSTtFQUNiLENBQUMsQ0FBQztFQUVGLElBQUEsZ0JBQVMsRUFBQyxNQUFNO0lBQ2QsSUFBSSxlQUFlLElBQUksbUJBQW1CLEVBQUU7TUFDMUMsZUFBZSxDQUFDLG1CQUFtQixDQUFDO0lBQ3RDO0VBQ0YsQ0FBQyxFQUFFLENBQUMsbUJBQW1CLEVBQUUsZUFBZSxFQUFFLGVBQWUsQ0FBQyxDQUFDOztFQUUzRDtFQUNBO0VBQ0E7RUFDQTtFQUNBLE1BQU0saUJBQWlCLEdBQ3JCLFlBQVksSUFDWixJQUFBLHdCQUFpQixFQUNmLHVCQUF1QixFQUN2QixlQUFlLEVBQ2YsZUFBZSxFQUNmLGFBQWEsRUFDYixtQkFBbUIsSUFBSSxDQUN6QixDQUFDO0VBRUgsT0FBTztJQUNMLFlBQVksRUFBRSxpQkFBaUI7SUFDL0I7RUFDRixDQUFDO0FBQ0g7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDL0VBLElBQUEsV0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBRUEsSUFBQSxVQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsYUFBQSxHQUFBLE9BQUE7QUFFQSxJQUFBLFdBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUVBLE1BQU0saUJBQWlCLEdBQUksS0FBSyxJQUFLLEtBQUssS0FBSyxJQUFJLElBQUksS0FBSyxLQUFLLFNBQVM7QUFFMUUsTUFBTSxzQ0FBc0MsR0FBRyxDQUM3QyxXQUFXLEVBQ1gsZUFBZSxLQUNaO0VBQ0gsSUFBSSxlQUFlLGFBQWYsZUFBZSxlQUFmLGVBQWUsQ0FBRyxXQUFXLGFBQVgsV0FBVyx1QkFBWCxXQUFXLENBQUUsWUFBWSxDQUFDLEVBQUU7SUFDaEQsT0FBTyxlQUFlLENBQUMsV0FBVyxDQUFDLFlBQVksQ0FBQyxDQUM3Qyw2QkFBNkI7RUFDbEM7RUFDQSxNQUFNO0lBQUUsb0JBQW9CO0lBQUUsWUFBWTtJQUFFO0VBQVMsQ0FBQyxHQUNwRCxDQUFBLFdBQVcsYUFBWCxXQUFXLHVCQUFYLFdBQVcsQ0FBRSxRQUFRLEtBQUksQ0FBQyxDQUFDO0VBQzdCLE1BQU0sV0FBVyxHQUFHLG9CQUFvQixJQUFJLFlBQVksSUFBSSxRQUFRO0VBQ3BFLE9BQU8sV0FBVyxHQUFHLE1BQU0sQ0FBQyxJQUFBLDJCQUFlLEVBQUMsV0FBVyxDQUFDLENBQUMsR0FBRyxJQUFJO0FBQ2xFLENBQUM7O0FBRUQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLFNBQVMsNEJBQTRCLENBQUM7RUFDM0MsYUFBYTtFQUNiLGVBQWU7RUFDZixlQUFlO0VBQ2Y7QUFDRixDQUFDLEVBQUU7RUFDRCxNQUFNLGVBQWUsR0FDbkIsSUFBQSx1QkFBVyxFQUFDLDZDQUFrQyxDQUFDLElBQy9DLENBQUMsSUFBQSxpQ0FBbUIsRUFBQyxXQUFXLGFBQVgsV0FBVyx1QkFBWCxXQUFXLENBQUUsUUFBUSxDQUFDO0VBRTdDLE1BQU0sMkJBQTJCLEdBQUcsZUFBZSxHQUMvQyxzQ0FBc0MsQ0FBQyxXQUFXLEVBQUUsZUFBZSxDQUFDLEdBQ3BFLElBQUk7RUFFUixNQUFNLENBQUMsb0JBQW9CLEVBQUUsdUJBQXVCLENBQUMsR0FBRyxJQUFBLGVBQVEsRUFBQyxNQUFNO0lBQ3JFLElBQ0UsQ0FBQyxpQkFBaUIsQ0FBQywyQkFBMkIsQ0FBQyxJQUMvQyxJQUFBLHlCQUFrQixFQUFDLFdBQVcsQ0FBQyxFQUMvQjtNQUNBLE9BQU8sMkJBQTJCO0lBQ3BDO0lBQ0EsT0FBTyxJQUFJO0VBQ2IsQ0FBQyxDQUFDO0VBRUYsSUFBQSxnQkFBUyxFQUFDLE1BQU07SUFDZCxJQUFJLGVBQWUsSUFBSSxDQUFDLGlCQUFpQixDQUFDLDJCQUEyQixDQUFDLEVBQUU7TUFDdEUsdUJBQXVCLENBQUMsMkJBQTJCLENBQUM7SUFDdEQ7RUFDRixDQUFDLEVBQUUsQ0FBQywyQkFBMkIsRUFBRSx1QkFBdUIsRUFBRSxlQUFlLENBQUMsQ0FBQztFQUUzRSxNQUFNLHlCQUF5QixHQUM3QixvQkFBb0IsSUFDcEIsSUFBQSx3QkFBaUIsRUFDZiwrQkFBK0IsRUFDL0IsZUFBZSxFQUNmLGVBQWUsRUFDZixhQUFhLEVBQ2IsMkJBQTJCLElBQUksQ0FDakMsQ0FBQztFQUVILE9BQU87SUFDTCxvQkFBb0IsRUFBRSx5QkFBeUI7SUFDL0M7RUFDRixDQUFDO0FBQ0g7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDckZBLElBQUEsV0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFVBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxvQkFBQSxHQUFBLHNCQUFBLENBQUEsT0FBQTtBQUFxRSxTQUFBLHVCQUFBLENBQUEsV0FBQSxDQUFBLElBQUEsQ0FBQSxDQUFBLFVBQUEsR0FBQSxDQUFBLEtBQUEsT0FBQSxFQUFBLENBQUE7QUFFOUQsU0FBUyxjQUFjLENBQUMsUUFBZ0IsRUFBRTtFQUMvQyxNQUFNLFdBQVcsR0FBRyxJQUFBLHVCQUFXLEVBQUMseUJBQWMsQ0FBQztFQUMvQyxNQUFNLFdBQVcsR0FBRyxJQUFBLDRCQUFtQixFQUFDLFFBQVEsRUFBRSxXQUFXLENBQUM7RUFFOUQsTUFBTSxhQUFhLEdBQUcsUUFBUSxJQUFJLENBQUMsUUFBUSxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUM7RUFDL0QsTUFBTSxVQUFVLEdBQUcsYUFBYSxHQUFHLFFBQVEsR0FBRyxXQUFXO0VBRXpELE9BQU8sVUFBVTtBQUNuQjs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNaQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxXQUFBLEdBQUEsT0FBQTtBQUdBLElBQUEsUUFBQSxHQUFBLE9BQUE7QUFFQSxJQUFBLFVBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSx1QkFBQSxHQUFBLHNCQUFBLENBQUEsT0FBQTtBQUE4RCxTQUFBLHVCQUFBLENBQUEsV0FBQSxDQUFBLElBQUEsQ0FBQSxDQUFBLFVBQUEsR0FBQSxDQUFBLEtBQUEsT0FBQSxFQUFBLENBQUE7QUFFOUQsTUFBTSw4QkFBOEIsR0FBRyxDQUFDO0FBQ3hDLE1BQU0seUJBQXlCLEdBQUcsS0FBSztBQUV2QyxNQUFNLCtCQUErQixHQUNuQyxXQUE0QixJQUNoQjtFQUNaLElBQUksQ0FBQyxXQUFXLEVBQUU7SUFDaEIsT0FBTyxLQUFLO0VBQ2Q7RUFDQSxNQUFNLFdBQVcsR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7RUFDOUIsTUFBTTtJQUFFLFVBQVU7SUFBRTtFQUFjLENBQUMsR0FBRyxXQUFXO0VBQ2pELE9BQ0UsVUFBVSxHQUFHLENBQUMsSUFBSSw4QkFBOEIsSUFDaEQsV0FBVyxHQUFHLGFBQWEsSUFBSSx5QkFBeUI7QUFFNUQsQ0FBQztBQUVNLFNBQVMsbUJBQW1CLENBQUEsRUFBRztFQUFBLElBQUEscUJBQUE7RUFDcEMsTUFBTSxRQUFRLEdBQUcsSUFBQSx1QkFBVyxFQUFDLENBQUM7RUFDOUIsTUFBTSxnQkFBZ0IsR0FBRyxJQUFBLHVCQUFXLEVBQUMsaUNBQXNCLENBQUM7RUFDNUQsTUFBTTtJQUFFO0VBQW9CLENBQUMsR0FBRyxJQUFBLCtCQUFzQixFQUFDLENBQUM7RUFDeEQsTUFBTSxNQUFNLEdBQ1YsQ0FBQSxtQkFBbUIsYUFBbkIsbUJBQW1CLHVCQUFuQixtQkFBbUIsQ0FBRSxNQUFNLE1BQUksbUJBQW1CLGFBQW5CLG1CQUFtQixnQkFBQSxxQkFBQSxHQUFuQixtQkFBbUIsQ0FBRSxhQUFhLGNBQUEscUJBQUEsdUJBQWxDLHFCQUFBLENBQW9DLE1BQU07RUFDM0UsTUFBTSxXQUFXLEdBQUcsZ0JBQWdCLENBQUMsTUFBTSxDQUFDO0VBQzVDLE1BQU0sb0JBQW9CLEdBQUcsK0JBQStCLENBQUMsV0FBVyxDQUFDO0VBRXpFLE1BQU0sV0FBVyxHQUFHLElBQUEsa0JBQVcsRUFBQyxNQUFNO0lBQ3BDLFFBQVEsQ0FDTixJQUFBLG1DQUEwQixFQUFDLE1BQU0sRUFBRTtNQUNqQyxVQUFVLEVBQUUsQ0FBQztNQUNiLGFBQWEsRUFBRTtJQUNqQixDQUFDLENBQ0gsQ0FBQztFQUNILENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRSxNQUFNLENBQUMsQ0FBQztFQUV0QixPQUFPO0lBQ0wsTUFBTTtJQUNOLFdBQVc7SUFDWDtFQUNGLENBQUM7QUFDSDs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNqREEsSUFBQSxXQUFBLEdBQUEsT0FBQTtBQUVBLElBQUEsbUJBQUEsR0FBQSxPQUFBO0FBTU8sTUFBTSxxQkFBcUIsR0FBRyxDQUFBLEtBQU07RUFDekMsTUFBTTtJQUFFLFlBQVksRUFBRTtFQUF3QixDQUFDLEdBQUcsSUFBQSx1QkFBVyxFQUMzRCx5Q0FDRixDQUFDO0VBQ0QsTUFBTTtJQUFFLE9BQU8sRUFBRTtFQUFzQixDQUFDLEdBQUksdUJBQXVCLElBQ2pFLENBQUMsQ0FBNkI7RUFFaEMsSUFBSSxxQkFBcUIsS0FBSyxLQUFLLEVBQUU7SUFDbkMsT0FBTztNQUNMLE9BQU8sRUFBRTtJQUNYLENBQUM7RUFDSDtFQUVBLE9BQU87SUFDTCxPQUFPLEVBQUU7RUFDWCxDQUFDO0FBQ0gsQ0FBQztBQUFDLE9BQUEsQ0FBQSxxQkFBQSxHQUFBLHFCQUFBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ3hCRixJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxRQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsUUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFFBQUEsR0FBQSxPQUFBO0FBRUEsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUlBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTyxNQUFNLHlCQUF5QixHQUFHLENBQUEsS0FBTTtFQUFBLElBQUEsVUFBQTtFQUM3QyxNQUFNO0lBQUU7RUFBb0IsQ0FBQyxHQUFHLElBQUEsMEJBQWlCLEVBQUMsQ0FBQztFQUVuRCxNQUFNLFNBQVMsR0FDYixJQUFBLGlDQUEwQixFQUFDLG1CQUFtQixDQUFDLEtBQzdDLG1CQUFtQixhQUFuQixtQkFBbUIsZ0JBQUEsVUFBQSxHQUFuQixtQkFBbUIsQ0FBMkIsU0FBUyxjQUFBLFVBQUEsdUJBQXhELFVBQUEsQ0FDRyxTQUFTLENBQVc7RUFDMUIsTUFBTSxVQUFVLEdBQUcsU0FBUyxHQUFHLElBQUEsa0NBQXlCLEVBQUMsU0FBUyxDQUFDLEdBQUcsSUFBSTtFQUUxRSxNQUFNLDRCQUE0QixHQUFHLElBQUEsa0JBQVcsRUFDOUMsTUFBTyxlQUFrRCxJQUFLO0lBQzVELElBQUksQ0FBQyxVQUFVLEVBQUU7TUFDZjtJQUNGO0lBRUEsSUFBQSw0QkFBbUIsRUFBQyxVQUFVLEVBQUUsZUFBZSxDQUFDO0VBQ2xELENBQUMsRUFDRCxDQUFDLFVBQVUsQ0FDYixDQUFDO0VBRUQsT0FBTztJQUFFO0VBQTZCLENBQUM7QUFDekMsQ0FBQztBQUFDLE9BQUEsQ0FBQSx5QkFBQSxHQUFBLHlCQUFBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ2xDRixJQUFBLFVBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsV0FBQSxHQUFBLE9BQUE7QUFFQSxJQUFBLFFBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxRQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsWUFBQSxHQUFBLE9BQUE7QUFFTyxTQUFTLHNCQUFzQixDQUFBLEVBQUc7RUFDdkMsTUFBTSxRQUFRLEdBQUcsSUFBQSx1QkFBVyxFQUFDLENBQUM7RUFDOUIsTUFBTTtJQUFFO0VBQW9CLENBQUMsR0FBRyxJQUFBLDBCQUFpQixFQUFrQixDQUFDO0VBQ3BFLE1BQU07SUFBRSxFQUFFLEVBQUUsY0FBYztJQUFFLE9BQU87SUFBRTtFQUFTLENBQUMsR0FBRyxtQkFBbUIsSUFBSSxDQUFDLENBQUM7RUFDM0UsTUFBTTtJQUFFO0VBQUssQ0FBQyxHQUFHLFFBQVEsSUFBSSxDQUFDLENBQUM7RUFFL0IsTUFBTSxtQkFBbUIsR0FBRyxJQUFBLGtCQUFXLEVBQUMsWUFBWTtJQUNsRCxJQUFJLENBQUMsT0FBTyxJQUFJLENBQUMsSUFBSSxFQUFFO01BQ3JCO0lBQ0Y7SUFFQSxNQUFNLEtBQUssR0FBRyxJQUFJLHVCQUFZLENBQzVCLDZCQUFnQixDQUFDLGVBQWUsRUFDaEMsK0JBQ0YsQ0FBQztJQUVELE1BQU0sZUFBZSxHQUFHLElBQUEseUJBQWMsRUFBQyxLQUFLLENBQUM7SUFFN0MsUUFBUSxDQUFDLElBQUEsOEJBQXFCLEVBQUMsY0FBYyxFQUFFLGVBQWUsQ0FBQyxDQUFDO0VBQ2xFLENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRSxjQUFjLEVBQUUsT0FBTyxFQUFFLElBQUksQ0FBQyxDQUFDO0VBRTdDLE9BQU87SUFBRTtFQUFvQixDQUFDO0FBQ2hDOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQy9CQSxJQUFBLFdBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUVBLElBQUEsU0FBQSxHQUFBLHNCQUFBLENBQUEsT0FBQTtBQUNBLElBQUEsVUFBQSxHQUFBLE9BQUE7QUFJQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxRQUFBLEdBQUEsT0FBQTtBQUtBLElBQUEsUUFBQSxHQUFBLE9BQUE7QUFBdUQsU0FBQSx1QkFBQSxDQUFBLFdBQUEsQ0FBQSxJQUFBLENBQUEsQ0FBQSxVQUFBLEdBQUEsQ0FBQSxLQUFBLE9BQUEsRUFBQSxDQUFBO0FBRWhELFNBQVMsK0JBQStCLENBQUEsRUFBRztFQUNoRCxNQUFNLFFBQVEsR0FBRyxJQUFBLHVCQUFXLEVBQUMsQ0FBQztFQUM5QixNQUFNO0lBQUU7RUFBb0IsQ0FBQyxHQUFHLElBQUEsMEJBQWlCLEVBQWtCLENBQUM7RUFDcEUsTUFBTTtJQUNKLEVBQUUsRUFBRSxhQUFhO0lBQ2pCLFFBQVE7SUFDUjtFQUNGLENBQUMsR0FBRyxtQkFBbUIsSUFBSSxDQUFDLENBQUM7RUFDN0IsTUFBTSxhQUFhLEdBQUcsT0FBTyxDQUFDLFFBQVEsQ0FBQztFQUV2QyxNQUFNLGtDQUFrQyxHQUFHLElBQUEsdUJBQVcsRUFDcEQsZ0RBQ0YsQ0FBQztFQUVELE1BQU0scUNBQXFDLEdBQUcsSUFBQSx1QkFBVyxFQUN2RCw0Q0FDRixDQUFDO0VBRUQsSUFBQSxnQkFBUyxFQUFDLE1BQU07SUFDZCxJQUNFLENBQUMsYUFBYSxJQUNkLENBQUMsYUFBYSxJQUNkLENBQUMsa0NBQWtDLElBQ25DLENBQUMscUNBQXFDLEVBQ3RDO01BQ0E7SUFDRjtJQUVBLE9BQU8sQ0FBQyxHQUFHLENBQUMsQ0FDVixJQUFBLDZCQUFzQixFQUFDLENBQUMsRUFDeEIsSUFBQSx1Q0FBOEIsRUFBQztNQUFFO0lBQWdCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FDdEQsQ0FBQyxDQUNDLElBQUksQ0FBQyxDQUFDLENBQUMsaUJBQWlCLENBQUMsS0FBSztNQUFBLElBQUEscUJBQUE7TUFDN0IsUUFBUSxDQUFDLElBQUEsNkJBQW9CLEVBQUMsaUJBQWlCLENBQUMsQ0FBQztNQUNqRCxRQUFRLENBQ04sSUFBQSw0Q0FBbUMsR0FBQSxxQkFBQSxHQUNqQyxpQkFBaUIsQ0FBQyxpQkFBaUIsY0FBQSxxQkFBQSx1QkFBbkMscUJBQUEsQ0FBcUMsMEJBQ3ZDLENBQ0YsQ0FBQztJQUNILENBQUMsQ0FBQyxDQUNELEtBQUssQ0FBRSxLQUFLLElBQUs7TUFDaEIsaUJBQUcsQ0FBQyxLQUFLLENBQUMsZ0RBQWdELEVBQUUsS0FBSyxDQUFDO0lBQ3BFLENBQUMsQ0FBQztFQUNOLENBQUMsRUFBRSxDQUNELGFBQWEsRUFDYixhQUFhLEVBQ2Isa0NBQWtDLEVBQ2xDLHFDQUFxQyxFQUNyQyxlQUFlLENBQ2hCLENBQUM7QUFDSjs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNsRUEsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUdBLElBQUEsWUFBQSxHQUFBLE9BQUE7QUFNQSxJQUFBLFlBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxhQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsTUFBTSxzQ0FBc0MsR0FBRyxDQUM3QyxPQUFZLEVBQ1osWUFBc0MsRUFDdEMsWUFBZ0MsRUFDaEMsY0FBYyxHQUFHLHFDQUF3QixDQUFDLHFCQUFxQixLQUM1RDtFQUNILE1BQU0sVUFBVSxHQUFHLElBQUEsaUJBQVUsRUFBQyxnQ0FBa0IsQ0FBQztFQUNqRCxNQUFNLFVBQVUsR0FBRyxJQUFBLGFBQU0sRUFBQyxLQUFLLENBQUM7RUFFaEMsSUFBQSxnQkFBUyxFQUFDLE1BQU07SUFDZCxJQUNFLE9BQU8sS0FBSyxTQUFTLElBQ3JCLFlBQVksS0FBSyxTQUFTLElBQzFCLFVBQVUsQ0FBQyxPQUFPLEVBQ2xCO01BQ0E7SUFDRjtJQUVBLE1BQU07TUFBRSxRQUFRO01BQUU7SUFBUyxDQUFDLEdBQUcsWUFBWSxJQUFJLENBQUMsQ0FBQztJQUNqRCxJQUFJLFFBQVEsS0FBSywwQkFBYSxDQUFDLEtBQUssRUFBRTtNQUNwQztJQUNGO0lBRUEsTUFBTSxjQUFjLEdBQUcsSUFBQSwrQkFBd0IsRUFBQyxRQUFRLENBQUM7SUFDekQsSUFBSSxjQUFjLEtBQUssU0FBUyxFQUFFO01BQ2hDLFVBQVUsQ0FBQztRQUNULEtBQUssRUFBRSxpQ0FBb0IsQ0FBQyxrQ0FBa0M7UUFDOUQsUUFBUSxFQUFFLHFDQUF3QixDQUFDLGFBQWE7UUFDaEQsVUFBVSxFQUFFO1VBQ1Y7VUFDQTtVQUNBLHdCQUF3QixFQUFFLGVBQWU7VUFDekM7VUFDQTtVQUNBLGFBQWEsRUFBRSxZQUFZO1VBQzNCO1VBQ0E7VUFDQSxVQUFVLEVBQUUsMEJBQWEsQ0FBQyxLQUFLO1VBQy9CO1VBQ0E7VUFDQSxRQUFRLEVBQUUsT0FBTztVQUNqQixRQUFRLEVBQUUsY0FBYztVQUN4QjtVQUNBO1VBQ0EsaUJBQWlCLEVBQUUsQ0FDakIsNENBQStCLENBQUMsc0JBQXNCO1FBRTFEO01BQ0YsQ0FBQyxDQUFDO01BQ0YsVUFBVSxDQUFDLE9BQU8sR0FBRyxJQUFJO0lBQzNCO0VBQ0YsQ0FBQyxFQUFFLENBQUMsWUFBWSxFQUFFLE9BQU8sRUFBRSxjQUFjLEVBQUUsWUFBWSxFQUFFLFVBQVUsQ0FBQyxDQUFDO0FBQ3ZFLENBQUM7QUFBQyxJQUFBLFFBQUEsR0FBQSxPQUFBLENBQUEsT0FBQSxHQUVhLHNDQUFzQzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUMzRXJELElBQUEsTUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFdBQUEsR0FBQSxPQUFBO0FBRUEsSUFBQSxPQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsUUFBQSxHQUFBLE9BQUE7QUFJQSxJQUFBLFVBQUEsR0FBQSxPQUFBO0FBRU8sTUFBTSwyQkFBMkIsR0FBRyxDQUFBLEtBQU07RUFDL0MsTUFBTTtJQUFFO0VBQVksQ0FBQyxHQUFHLElBQUEsd0JBQWdCLEVBQUMsQ0FBQztFQUMxQyxNQUFNLFFBQVEsR0FBRyxJQUFBLHVCQUFXLEVBQUUsS0FBSyxJQUNqQyxJQUFBLGlDQUFzQixFQUFDLEtBQUssRUFBRTtJQUM1QixlQUFlLEVBQUUsQ0FBQyxDQUFDO0lBQ25CLFVBQVUsRUFBRSxxQkFBcUIsV0FBVyxhQUFYLFdBQVcsdUJBQVgsV0FBVyxDQUFFLEVBQUU7RUFDbEQsQ0FBQyxDQUNILENBQUM7RUFFRCxNQUFNLGNBQWMsR0FBRyxPQUFPLENBQUMsUUFBUSxDQUFDO0VBQ3hDLE1BQU0sZ0JBQWdCLEdBQUcsV0FBVyxhQUFYLFdBQVcsdUJBQVgsV0FBVyxDQUFFLEVBQUU7RUFFeEMsTUFBTSw4QkFBOEIsR0FBRyxJQUFBLGtCQUFXLEVBQ2hELE9BQU8sTUFBTSxFQUFFLGNBQWMsS0FBSztJQUNoQyxNQUFNLGFBQWEsR0FBRyxjQUFjLElBQUksZ0JBQWdCO0lBRXhELElBQUksQ0FBQyxhQUFhLEVBQUU7TUFDbEI7SUFDRjtJQUNBLElBQUksQ0FBQyxjQUFjLEVBQUU7TUFDbkIsTUFBTSxJQUFBLHVDQUE4QixFQUFDLGFBQWEsQ0FBQztJQUNyRDtJQUNBLElBQUEsNEJBQW1CLEVBQUMscUJBQXFCLGFBQWEsRUFBRSxFQUFFLE1BQU0sQ0FBQztJQUNqRSxJQUFBLDRCQUFtQixFQUFDLHlCQUF5QixhQUFhLEVBQUUsRUFBRSxNQUFNLENBQUM7RUFDdkUsQ0FBQyxFQUNELENBQUMsY0FBYyxFQUFFLGdCQUFnQixDQUNuQyxDQUFDO0VBRUQsT0FBTztJQUFFO0VBQStCLENBQUM7QUFDM0MsQ0FBQztBQUFDLE9BQUEsQ0FBQSwyQkFBQSxHQUFBLDJCQUFBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ3ZDRixJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxXQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsc0JBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxRQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsZUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFFBQUEsR0FBQSxPQUFBO0FBRUEsTUFBTSxlQUFxQyxHQUFHLElBQUksR0FBRyxDQUFDLENBQ3BELHNDQUFlLENBQUMsbUJBQW1CLEVBQ25DLHNDQUFlLENBQUMsY0FBYyxFQUM5QixzQ0FBZSxDQUFDLFVBQVUsRUFDMUIsc0NBQWUsQ0FBQyxLQUFLLEVBQ3JCLHNDQUFlLENBQUMsbUJBQW1CLEVBQ25DLHNDQUFlLENBQUMsdUJBQXVCLEVBQ3ZDLHNDQUFlLENBQUMsMkJBQTJCLENBQzVDLENBQUM7QUFFSyxNQUFNLHlCQUF5QixHQUFHLENBQUEsS0FBTTtFQUM3QyxNQUFNO0lBQUU7RUFBb0IsQ0FBQyxHQUFHLElBQUEsMEJBQWlCLEVBQUMsQ0FBQztFQUNuRCxNQUFNO0lBQUUsRUFBRTtJQUFFO0VBQUssQ0FBQyxHQUFHLG1CQUFtQixJQUFJLENBQUMsQ0FBQztFQUM5QyxNQUFNLGVBQWUsR0FBRyxJQUFBLDhCQUFjLEVBQUMsQ0FBQztFQUN4QyxNQUFNLFFBQVEsR0FBRyxJQUFBLHVCQUFXLEVBQUMsQ0FBQztFQUM5QixNQUFNLENBQUMscUJBQXFCLEVBQUUsd0JBQXdCLENBQUMsR0FBRyxJQUFBLGVBQVEsRUFFaEUsSUFBSSxDQUFDO0VBRVAsTUFBTSxtQkFBbUIsR0FBRyxJQUFBLGtCQUFXLEVBQ3JDLE9BQU8sYUFBcUIsRUFBRSxTQUFrQixLQUFLO0lBQ25ELE1BQU0sUUFBUSxDQUFDLElBQUEsNkJBQW9CLEVBQUMsYUFBYSxFQUFFLFNBQVMsQ0FBQyxDQUFDO0VBQ2hFLENBQUMsRUFDRCxDQUFDLFFBQVEsQ0FDWCxDQUFDO0VBRUQsSUFBQSxnQkFBUyxFQUFDLE1BQU07SUFDZCxNQUFNLFdBQVcsR0FBRyxlQUFlLENBQUMsR0FBRyxDQUFDLElBQXVCLENBQUM7SUFFaEUsSUFBSSxDQUFDLFdBQVcsRUFBRTtNQUNoQjtNQUNBO01BQ0EsSUFBSSxxQkFBcUIsRUFBRTtRQUN6QixtQkFBbUIsQ0FBQyxxQkFBcUIsRUFBRSxLQUFLLENBQUM7UUFDakQsd0JBQXdCLENBQUMsSUFBSSxDQUFDO01BQ2hDO01BQ0E7SUFDRjtJQUVBLElBQUksZUFBZSxJQUFJLHFCQUFxQixLQUFLLEVBQUUsRUFBRTtNQUNuRDtNQUNBO01BQ0EsSUFBSSxxQkFBcUIsRUFBRTtRQUN6QixtQkFBbUIsQ0FBQyxxQkFBcUIsRUFBRSxLQUFLLENBQUM7TUFDbkQ7TUFDQTtNQUNBLHdCQUF3QixDQUFDLEVBQUUsQ0FBQztNQUM1QixtQkFBbUIsQ0FBQyxFQUFFLEVBQUUsSUFBSSxDQUFDO0lBQy9CLENBQUMsTUFBTSxJQUFJLENBQUMsZUFBZSxJQUFJLHFCQUFxQixFQUFFO01BQ3BEO01BQ0E7TUFDQSxtQkFBbUIsQ0FBQyxxQkFBcUIsRUFBRSxLQUFLLENBQUM7TUFDakQsd0JBQXdCLENBQUMsSUFBSSxDQUFDO0lBQ2hDO0VBQ0YsQ0FBQyxFQUFFLENBQUMscUJBQXFCLEVBQUUsRUFBRSxFQUFFLGVBQWUsRUFBRSxtQkFBbUIsRUFBRSxJQUFJLENBQUMsQ0FBQztBQUM3RSxDQUFDO0FBQUMsT0FBQSxDQUFBLHlCQUFBLEdBQUEseUJBQUE7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDOURGLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFdBQUEsR0FBQSxPQUFBO0FBRUEsSUFBQSxVQUFBLEdBQUEsc0JBQUEsQ0FBQSxPQUFBO0FBQ0EsSUFBQSxJQUFBLEdBQUEsT0FBQTtBQUtBLElBQUEsS0FBQSxHQUFBLE9BQUE7QUFJQSxJQUFBLFFBQUEsR0FBQSxPQUFBO0FBUUEsSUFBQSxXQUFBLEdBQUEsT0FBQTtBQUdxRCxTQUFBLHVCQUFBLENBQUEsV0FBQSxDQUFBLElBQUEsQ0FBQSxDQUFBLFVBQUEsR0FBQSxDQUFBLEtBQUEsT0FBQSxFQUFBLENBQUE7QUFFckQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ08sTUFBTSx1QkFBdUIsR0FBRyxDQUFDO0VBQ3RDLG9CQUFvQjtFQUNwQixXQUFXO0VBQ1gsZ0JBQWdCO0VBQ2hCLGVBQWU7RUFDZixRQUFRLEVBQUUsYUFBYTtFQUN2QixvQkFBb0IsRUFBRSx5QkFBeUI7RUFDL0MsV0FBVztFQUNYO0FBQ0YsQ0FBQyxLQUFLO0VBQ0osTUFBTSxRQUFRLEdBQUcsSUFBQSx1QkFBVyxFQUFDLENBQUM7RUFFOUIsTUFBTSxTQUFTLEdBQUcsSUFBQSxrQkFBVyxFQUFDLE1BQU07SUFDbEMsSUFDRyxXQUFXLEtBQUssaUJBQVksQ0FBQyxNQUFNLElBQ2xDLFdBQVcsS0FBSyxpQkFBWSxDQUFDLE9BQU8sSUFDdEMsV0FBVyxDQUFDLFdBQVcsRUFDdkI7TUFDQSxPQUFPLENBQUMsQ0FBQztJQUNYO0lBQ0EsTUFBTTtNQUFFLFlBQVk7TUFBRSxvQkFBb0I7TUFBRTtJQUFTLENBQUMsR0FDcEQsQ0FBQSxXQUFXLGFBQVgsV0FBVyx1QkFBWCxXQUFXLENBQUUsUUFBUSxLQUFJLENBQUMsQ0FBQztJQUM3QixPQUFPO01BQ0wsV0FBVyxFQUFFO1FBQ1gsWUFBWTtRQUNaLG9CQUFvQjtRQUNwQjtNQUNGO0lBQ0YsQ0FBQztFQUNILENBQUMsRUFBRSxDQUFDLFdBQVcsRUFBRSxXQUFXLGFBQVgsV0FBVyx1QkFBWCxXQUFXLENBQUUsV0FBVyxFQUFFLFdBQVcsYUFBWCxXQUFXLHVCQUFYLFdBQVcsQ0FBRSxRQUFRLENBQUMsQ0FBQztFQUVsRSxNQUFNLGlCQUFpQixHQUFHLElBQUEsa0JBQVcsRUFDbkMsT0FBTztJQUNMLFlBQVk7SUFDWixRQUFRO0lBQ1IsWUFBWTtJQUNaLG9CQUFvQjtJQUNwQjtFQUNGLENBQUMsS0FBSztJQUNKLE1BQU0sY0FBYyxHQUFHO01BQ3JCLEdBQUcsRUFBRSxJQUFBLHdCQUFZLEVBQUMsUUFBUSxJQUFJLGFBQWEsQ0FBQztNQUM1QyxRQUFRLEVBQUUsSUFBQSx3QkFBWSxFQUFDLFFBQVEsSUFBSSxhQUFhLENBQUM7TUFDakQsaUJBQWlCLEVBQUUsaUJBQWlCLElBQUksb0JBQW9CO01BQzVEO0lBQ0YsQ0FBQztJQUNELElBQUksWUFBWSxFQUFFO01BQ2hCLGNBQWMsQ0FBQyxZQUFZLEdBQUcsWUFBWTtJQUM1QztJQUNBLElBQUksb0JBQW9CLEVBQUU7TUFDeEIsY0FBYyxDQUFDLG9CQUFvQixHQUNqQyxvQkFBb0IsSUFBSSxJQUFBLDJCQUFlLEVBQUMseUJBQXlCLENBQUM7SUFDdEU7SUFDQSxNQUFNLE1BQU0sR0FBRyxTQUFTLENBQUMsQ0FBQztJQUUxQixNQUFNLGFBQWEsR0FBRztNQUNwQixHQUFHLFdBQVc7TUFDZCxZQUFZLEVBQUUsWUFBWSxJQUFJLG1CQUFjLENBQUMsTUFBTTtNQUNuRCxRQUFRLEVBQUU7UUFDUixHQUFHLFdBQVcsQ0FBQyxRQUFRO1FBQ3ZCLEdBQUc7TUFDTCxDQUFDO01BQ0QsR0FBRztJQUNMLENBQUM7SUFFRCxJQUFJLFdBQVcsS0FBSyxpQkFBWSxDQUFDLEtBQUssRUFBRTtNQUN0QyxRQUFRLENBQ04sSUFBQSxnQ0FBdUIsRUFBQyxZQUFZLElBQUksbUJBQWMsQ0FBQyxNQUFNLENBQy9ELENBQUM7TUFDRCxRQUFRLENBQUMsSUFBQSwwQ0FBaUMsRUFBQyxjQUFjLENBQUMsQ0FBQztJQUM3RCxDQUFDLE1BQU0sSUFBSSxJQUFBLGtDQUE0QixFQUFDLFdBQVcsQ0FBQyxFQUFFO01BQ3BELGNBQWMsQ0FBQyxhQUFhLENBQUM7SUFDL0IsQ0FBQyxNQUFNO01BQ0wsY0FBYyxDQUFDLGtCQUFrQixHQUFHLGFBQWEsQ0FBQyxrQkFBa0I7TUFDcEUsY0FBYyxDQUFDLFlBQVksR0FBRyxhQUFhLENBQUMsWUFBWTtNQUV4RCxJQUFJLE1BQU0sSUFBSSxNQUFNLENBQUMsV0FBVyxFQUFFO1FBQ2hDLE1BQU0sUUFBUSxDQUNaLElBQUEsZ0NBQXVCLEVBQUMsYUFBYSxDQUFDLEVBQUUsRUFBRSxNQUFNLENBQUMsV0FBVyxDQUM5RCxDQUFDO01BQ0g7TUFFQSxNQUFNLFFBQVEsQ0FDWixJQUFBLGlDQUF3QixFQUFDLGFBQWEsQ0FBQyxFQUFFLEVBQUUsY0FBYyxDQUMzRCxDQUFDO0lBQ0g7RUFDRixDQUFDLEVBQ0QsQ0FDRSxvQkFBb0IsRUFDcEIsUUFBUSxFQUNSLFdBQVcsRUFDWCxhQUFhLEVBQ2IsU0FBUyxFQUNULHlCQUF5QixFQUN6QixXQUFXLEVBQ1gsY0FBYyxDQUVsQixDQUFDO0VBRUQsTUFBTSxpQkFBaUIsR0FBRyxJQUFBLGtCQUFXLEVBQUMsTUFBTTtJQUMxQyxRQUFRLENBQ04sSUFBQSxnQ0FBdUIsRUFBQyxXQUFXLENBQUMsRUFBRSxFQUFFLFdBQVcsQ0FBQyxRQUFRLEVBQUU7TUFDNUQ7SUFDRixDQUFDLENBQ0gsQ0FBQztFQUNILENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRSxnQkFBZ0IsRUFBRSxXQUFXLENBQUMsQ0FBQztFQUU3QyxNQUFNLGtCQUFrQixHQUFHLElBQUEsa0JBQVcsRUFBQyxNQUFNO0lBQzNDLFFBQVEsQ0FDTixJQUFBLGlDQUF3QixFQUFDLFdBQVcsQ0FBQyxFQUFFLEVBQUUsV0FBVyxDQUFDLFFBQVEsRUFBRTtNQUM3RDtJQUNGLENBQUMsQ0FDSCxDQUFDO0VBQ0gsQ0FBQyxFQUFFLENBQUMsUUFBUSxFQUFFLGdCQUFnQixFQUFFLFdBQVcsQ0FBQyxDQUFDO0VBRTdDLE1BQU0sNENBQTRDLEdBQUcsSUFBQSxrQkFBVyxFQUM5RCxDQUFDLGVBQWUsR0FBRyxLQUFLLEtBQUs7SUFDM0IsTUFBTTtNQUNKLEdBQUcsRUFBRSxRQUFRO01BQ2IsWUFBWTtNQUNaO0lBQ0YsQ0FBQyxHQUFHLFdBQVcsQ0FBQyxXQUFXLElBQUksV0FBVyxDQUFDLFFBQVE7SUFFbkQsTUFBTSx1QkFBdUIsR0FBRyxJQUFJLGtCQUFTLENBQzNDLG9CQUFvQixFQUNwQixFQUNGLENBQUMsQ0FBQyxNQUFNLENBQUMsQ0FBQyxHQUNOLElBQUEsMkJBQWUsRUFDYixlQUFlLENBQUMsb0JBQW9CLENBQUMsQ0FBQyw2QkFDeEMsQ0FBQyxHQUNELG9CQUFvQjtJQUV4QixNQUFNLFlBQVksR0FDaEIsb0JBQW9CLEtBQUssS0FBSyxHQUMxQix3QkFBbUIsR0FDbkIsbUJBQWMsQ0FBQyxtQkFBbUI7SUFFeEMsSUFBSSxDQUFDLGVBQWUsRUFBRTtNQUNwQjtJQUNGO0lBQ0EsaUJBQWlCLENBQUM7TUFDaEIsaUJBQWlCLEVBQUUsZUFBZSxHQUM5QixvQkFBb0IsR0FDcEIsbUJBQWMsQ0FBQyxtQkFBbUI7TUFDdEMsWUFBWTtNQUNaLFFBQVE7TUFDUixZQUFZLEVBQUUsSUFBQSwyQkFBcUIsRUFBQyxZQUFZLENBQUM7TUFDakQsb0JBQW9CLEVBQUUsSUFBQSwyQkFBcUIsRUFBQyx1QkFBdUI7SUFDckUsQ0FBQyxDQUFDO0VBQ0osQ0FBQyxFQUNELENBQUMsb0JBQW9CLEVBQUUsZUFBZSxFQUFFLFdBQVcsRUFBRSxpQkFBaUIsQ0FDeEUsQ0FBQztFQUVELE1BQU0sOEJBQThCLEdBQUcsSUFBQSxrQkFBVyxFQUMvQyxtQkFBbUIsSUFBSztJQUN2QixJQUFJLEVBQUMsZUFBZSxhQUFmLGVBQWUsZUFBZixlQUFlLENBQUcsbUJBQW1CLENBQUMsR0FBRTtNQUMzQztJQUNGO0lBRUEsTUFBTTtNQUFFLHFCQUFxQjtNQUFFO0lBQThCLENBQUMsR0FDNUQsZUFBZSxDQUFDLG1CQUFtQixDQUFDO0lBQ3RDLGlCQUFpQixDQUFDO01BQ2hCLFlBQVksRUFBRSxtQkFBbUI7TUFDakMsWUFBWSxFQUFFLElBQUEsMkJBQWUsRUFBQyxxQkFBcUIsQ0FBQztNQUNwRCxvQkFBb0IsRUFBRSxJQUFBLDJCQUFlLEVBQUMsNkJBQTZCO0lBQ3JFLENBQUMsQ0FBQztFQUNKLENBQUMsRUFDRCxDQUFDLGVBQWUsRUFBRSxpQkFBaUIsQ0FDckMsQ0FBQztFQUVELE1BQU0seUNBQXlDLEdBQUcsSUFBQSxrQkFBVyxFQUFDLE1BQU07SUFDbEUsTUFBTTtNQUFFLFlBQVk7TUFBRTtJQUFxQixDQUFDLEdBQzFDLENBQUEsV0FBVyxhQUFYLFdBQVcsdUJBQVgsV0FBVyxDQUFFLG9CQUFvQixLQUFJLENBQUMsQ0FBQztJQUN6QyxpQkFBaUIsQ0FBQztNQUNoQixZQUFZLEVBQUUsbUJBQWMsQ0FBQyxhQUFhO01BQzFDLFlBQVk7TUFDWjtJQUNGLENBQUMsQ0FBQztFQUNKLENBQUMsRUFBRSxDQUFDLFdBQVcsRUFBRSxpQkFBaUIsQ0FBQyxDQUFDO0VBRXBDLE9BQU87SUFDTCxpQkFBaUI7SUFDakIsa0JBQWtCO0lBQ2xCLGlCQUFpQjtJQUNqQiw0Q0FBNEM7SUFDNUMseUNBQXlDO0lBQ3pDO0VBQ0YsQ0FBQztBQUNILENBQUM7QUFBQyxPQUFBLENBQUEsdUJBQUEsR0FBQSx1QkFBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUM1T0YsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUVBLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFNQSxJQUFBLFlBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxhQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsSUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFVBQUEsR0FBQSxPQUFBO0FBRU8sTUFBTSx5QkFBeUIsR0FDcEMsWUFBa0MsSUFDL0I7RUFDSCxNQUFNLFdBQVcsR0FBRyxJQUFBLGNBQU8sRUFBQyxNQUFNO0lBQ2hDLElBQ0UsQ0FBQyxZQUFZLElBQ2IsQ0FBQyxJQUFBLGlDQUEwQixFQUFDLFlBQVksQ0FBQyxJQUN6QyxDQUFBLFlBQVksYUFBWixZQUFZLHVCQUFaLFlBQVksQ0FBRSxJQUFJLE1BQUssaUJBQVksQ0FBQyxtQkFBbUIsRUFDdkQ7TUFDQSxPQUFPLFNBQVM7SUFDbEI7SUFDQSxJQUFJLElBQUEsK0JBQXdCLEVBQUMsWUFBWSxDQUFDLEVBQUU7TUFDMUMsT0FBTyx5Q0FBOEIsQ0FBQyxNQUFNO0lBQzlDLENBQUMsTUFBTSxJQUFJLElBQUEsOEJBQXVCLEVBQUMsWUFBWSxDQUFDLEVBQUU7TUFDaEQsT0FBTyx5Q0FBOEIsQ0FBQyxLQUFLO0lBQzdDO0lBQ0EsT0FBTyxTQUFTO0VBQ2xCLENBQUMsRUFBRSxDQUFDLFlBQVksQ0FBQyxDQUFDOztFQUVsQjtFQUNBO0VBQ0E7RUFDQSxNQUFNLGFBQWEsR0FBRyxJQUFBLGNBQU8sRUFBQyxNQUFNO0lBQUEsSUFBQSxxQkFBQTtJQUNsQyxJQUFJLFdBQVcsS0FBSyx5Q0FBOEIsQ0FBQyxNQUFNLEVBQUU7TUFDekQsT0FBTyxTQUFTO0lBQ2xCO0lBQ0EsTUFBTTtNQUNKLE9BQU8sRUFBRTtRQUFFO01BQVE7SUFDckIsQ0FBQyxHQUFHLElBQUEsa0NBQXFCLEVBQUMsWUFBWSxhQUFaLFlBQVksZ0JBQUEscUJBQUEsR0FBWixZQUFZLENBQUUsU0FBUyxjQUFBLHFCQUFBLHVCQUF2QixxQkFBQSxDQUF5QixJQUFjLENBQUM7SUFDbEUsSUFBSSxPQUFPLEtBQUssU0FBUyxFQUFFO01BQ3pCLE9BQU8sMkJBQWEsQ0FBQyxNQUFNO0lBQzdCO0lBQ0EsT0FBTyxTQUFTO0VBQ2xCLENBQUMsRUFBRSxDQUFDLFlBQVksRUFBRSxXQUFXLENBQUMsQ0FBQztFQUUvQixPQUFPO0lBQ0wsV0FBVyxFQUFFLFdBQTBEO0lBQ3ZFO0VBQ0YsQ0FBQztBQUNILENBQUM7QUFBQyxPQUFBLENBQUEseUJBQUEsR0FBQSx5QkFBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNwREYsSUFBQSxXQUFBLEdBQUEsT0FBQTtBQUVBLElBQUEsSUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFlBQUEsR0FBQSxPQUFBO0FBRUEsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsWUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFFBQUEsR0FBQSxPQUFBO0FBRUEsTUFBTSxnQ0FBZ0MsR0FBRyxDQUN2QztFQUNFLFVBQVUsRUFBRSxTQUFTO0VBQ3JCLGVBQWUsRUFBRSxDQUFDLFdBQVcsQ0FBQztFQUM5QixXQUFXLEVBQUUsQ0FBQyxLQUFLLEVBQUUsS0FBSyxFQUFFLEtBQUs7QUFDbkMsQ0FBQyxFQUNEO0VBQ0UsVUFBVSxFQUFFLFNBQVM7RUFDckIsZUFBZSxFQUFFLENBQUMsaUJBQWlCO0FBQ3JDLENBQUMsQ0FDRjtBQUVELE1BQU0saUNBQWlDLEdBQ3JDLGdCQUFzQyxJQUNuQztFQUFBLElBQUEsVUFBQTtFQUNILE1BQU0sSUFBSSxJQUFBLFVBQUEsR0FBSSxnQkFBZ0IsQ0FBMEIsU0FBUyxjQUFBLFVBQUEsdUJBQXBELFVBQUEsQ0FDVCxJQUFjO0VBQ2xCLElBQUksQ0FBQyxJQUFJLEVBQUU7SUFDVCxPQUFPLEtBQUs7RUFDZDtFQUNBLE1BQU07SUFDSixNQUFNLEVBQUU7TUFBRSxJQUFJO01BQUU7SUFBUSxDQUFDO0lBQ3pCO0VBQ0YsQ0FBQyxHQUFHLElBQUEsa0NBQXFCLEVBQUMsSUFBSSxDQUFDO0VBQy9CLE9BQU8sZ0NBQWdDLENBQUMsSUFBSSxDQUMxQyxDQUFDO0lBQUUsVUFBVTtJQUFFLGVBQWU7SUFBRTtFQUFZLENBQUMsS0FDM0MsSUFBSSxLQUFLLFVBQVUsSUFDbkIsZUFBZSxDQUFDLFFBQVEsQ0FBQyxXQUFXLENBQUMsS0FDcEMsQ0FBQyxXQUFXLElBQUksV0FBVyxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsQ0FDbEQsQ0FBQztBQUNILENBQUM7QUFFTSxTQUFTLGlDQUFpQyxDQUFBLEVBQUc7RUFBQSxJQUFBLHFCQUFBO0VBQ2xELE1BQU07SUFBRTtFQUFvQixDQUFDLEdBQUcsSUFBQSwwQkFBaUIsRUFBdUIsQ0FBQztFQUN6RSxNQUFNLHlCQUF5QixHQUFHLElBQUEsdUJBQVcsRUFDM0MsNENBQ0YsQ0FBQztFQUVELE1BQU0sZUFBZSxHQUFHLG1CQUFtQixhQUFuQixtQkFBbUIsZ0JBQUEscUJBQUEsR0FBbkIsbUJBQW1CLENBQUUsU0FBUyxjQUFBLHFCQUFBLHVCQUE5QixxQkFBQSxDQUFnQyxlQUFlO0VBQ3ZFLE1BQU0sZUFBZSxHQUNuQixlQUFlLEtBQUssaUJBQVksQ0FBQyxzQkFBc0IsSUFDdkQsZUFBZSxLQUFLLGlCQUFZLENBQUMsc0JBQXNCO0VBQ3pELE1BQU0sUUFBUSxHQUFHLElBQUEsK0JBQXdCLEVBQUMsbUJBQW1CLENBQUM7RUFDOUQsTUFBTSwrQkFBK0IsR0FDbkMsZUFBZSxJQUFJLGlDQUFpQyxDQUFDLG1CQUFtQixDQUFDO0VBRTNFLElBQUksQ0FBQyxtQkFBbUIsRUFBRTtJQUN4QixPQUFPLFNBQVM7RUFDbEI7RUFFQSxPQUNFLHlCQUF5QixJQUN6QixlQUFlLEtBQ2QsUUFBUSxJQUFJLCtCQUErQixDQUFDO0FBRWpEOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNoRUEsSUFBQSxJQUFBLEdBQUEsT0FBQTtBQUtPLFNBQVMsaUJBQWlCLENBQy9CLEtBQUssRUFDTCxlQUFlLEVBQ2YsZUFBZSxFQUNmLGFBQWEsRUFDYixRQUFRLEdBQUcsR0FBRyxFQUNkO0VBQ0EsSUFBSSxlQUFlLEtBQUsscUJBQWdCLENBQUMsU0FBUyxFQUFFO0lBQUEsSUFBQSxxQkFBQTtJQUNsRCxPQUFPLENBQUEsZUFBZSxhQUFmLGVBQWUsZ0JBQUEscUJBQUEsR0FBZixlQUFlLENBQUcsYUFBYSxDQUFDLGNBQUEscUJBQUEsdUJBQWhDLHFCQUFBLENBQW1DLEtBQUssQ0FBQyxLQUFJLE1BQU0sQ0FBQyxRQUFRLENBQUM7RUFDdEU7RUFDQSxPQUFPLE1BQU0sQ0FBQyxRQUFRLENBQUM7QUFDekI7QUFFTyxNQUFNLGtCQUFrQixHQUFJLFdBQVcsSUFDNUMsRUFBQyxXQUFXLGFBQVgsV0FBVyxlQUFYLFdBQVcsQ0FBRSxZQUFZLEtBQzFCLENBQUEsV0FBVyxhQUFYLFdBQVcsdUJBQVgsV0FBVyxDQUFFLFlBQVksTUFBSyx3QkFBbUI7QUFBQyxPQUFBLENBQUEsa0JBQUEsR0FBQSxrQkFBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNuQnBELElBQUEsS0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxZQUFBLEdBQUEsT0FBQTtBQUtBLElBQUEsVUFBQSxHQUFBLE9BQUE7QUFHTyxNQUFNLHVDQUF1QyxHQUFBLE9BQUEsQ0FBQSx1Q0FBQSxHQUFHLElBQUEsNkJBQXVCLEVBQzVFLENBQ0UsQ0FBQyxLQUE4QixFQUFFLGVBQW1DLEtBQUs7RUFDdkUsSUFBSSxDQUFDLGVBQWUsRUFBRTtJQUNwQixPQUFPO01BQUUsTUFBTSxFQUFFLEVBQUU7TUFBRSxPQUFPLEVBQUU7SUFBSyxDQUFDO0VBQ3RDO0VBRUEsT0FBTztJQUNMLE1BQU0sRUFBRSxJQUFBLHNDQUF5QixFQUFDLEtBQUssRUFBRSxDQUFDLGVBQWUsQ0FBQyxDQUFDO0lBQzNELE9BQU8sRUFBRSxlQUFlLGFBQWYsZUFBZSx1QkFBZixlQUFlLENBQUUsV0FBVyxDQUFDO0VBQ3hDLENBQUM7QUFDSCxDQUFDLENBQ0YsRUFDRCxDQUFDO0VBQUUsTUFBTTtFQUFFO0FBQVEsQ0FBQyxLQUFvQjtFQUFBLElBQUEsZUFBQTtFQUN0QyxJQUFJLENBQUMsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDLE1BQU0sRUFBRTtJQUM5QixPQUFPLElBQUk7RUFDYjtFQUVBLE1BQU0sS0FBSyxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUUsQ0FBbUMsSUFDNUQsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQ1osQ0FBa0I7SUFBQSxJQUFBLFVBQUE7SUFBQSxPQUFLLEVBQUEsVUFBQSxHQUFBLENBQUMsQ0FBQyxPQUFPLGNBQUEsVUFBQSx1QkFBVCxVQUFBLENBQVcsV0FBVyxDQUFDLENBQUMsTUFBSyxPQUFPO0VBQUEsQ0FDOUQsQ0FDRixDQUFDO0VBRUQsT0FBTyxDQUFBLEtBQUssYUFBTCxLQUFLLGdCQUFBLGVBQUEsR0FBTCxLQUFLLENBQUUsUUFBUSxjQUFBLGVBQUEsdUJBQWYsZUFBQSxDQUFpQixJQUFJLEtBQUksSUFBSTtBQUN0QyxDQUNGLENBQUM7QUFFTSxNQUFNLGtDQUFrQyxHQUFBLE9BQUEsQ0FBQSxrQ0FBQSxHQUFHLElBQUEsNkJBQXVCLEVBQ3ZFLENBQ0UsQ0FBQyxLQUFnQixFQUFFLE9BQTJCLE1BQU07RUFDbEQsUUFBUSxFQUFFLElBQUEsNENBQWlDLEVBQUMsS0FBSyxDQUFDO0VBQ2xEO0FBQ0YsQ0FBQyxDQUFDLENBQ0gsRUFDRCxDQUFDO0VBQUUsUUFBUTtFQUFFO0FBQVEsQ0FBQyxLQUFvQjtFQUFBLElBQUEscUJBQUE7RUFDeEMsSUFBSSxDQUFDLE9BQU8sSUFBSSxFQUFDLFFBQVEsYUFBUixRQUFRLGVBQVIsUUFBUSxDQUFFLE1BQU0sR0FBRTtJQUNqQyxPQUFPLElBQUk7RUFDYjtFQUVBLE1BQU0sV0FBVyxHQUFHLElBQUEsMEJBQW1CLEVBQUMsUUFBUSxFQUFFLE9BQU8sQ0FBQztFQUUxRCxPQUFPLENBQUEsV0FBVyxhQUFYLFdBQVcsZ0JBQUEscUJBQUEsR0FBWCxXQUFXLENBQUUsUUFBUSxjQUFBLHFCQUFBLHVCQUFyQixxQkFBQSxDQUF1QixJQUFJLEtBQUksSUFBSTtBQUM1QyxDQUNGLENBQUM7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUN2REQsSUFBQSxRQUFBLEdBQUEsT0FBQTtBQUFBLE1BQUEsQ0FBQSxJQUFBLENBQUEsUUFBQSxFQUFBLE9BQUEsV0FBQSxHQUFBO0VBQUEsSUFBQSxHQUFBLGtCQUFBLEdBQUE7RUFBQSxJQUFBLEdBQUEsSUFBQSxPQUFBLElBQUEsT0FBQSxDQUFBLEdBQUEsTUFBQSxRQUFBLENBQUEsR0FBQTtFQUFBLE1BQUEsQ0FBQSxjQUFBLENBQUEsT0FBQSxFQUFBLEdBQUE7SUFBQSxVQUFBO0lBQUEsR0FBQSxXQUFBLENBQUE7TUFBQSxPQUFBLFFBQUEsQ0FBQSxHQUFBO0lBQUE7RUFBQTtBQUFBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ0FBLElBQUEsTUFBQSxHQUFBLHVCQUFBLENBQUEsT0FBQTtBQUNBLElBQUEsVUFBQSxHQUFBLHNCQUFBLENBQUEsT0FBQTtBQUNBLElBQUEsV0FBQSxHQUFBLHNCQUFBLENBQUEsT0FBQTtBQUVBLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFHQSxJQUFBLEtBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsZUFBQSxHQUFBLE9BQUE7QUFLQSxJQUFBLGlCQUFBLEdBQUEsT0FBQTtBQU1BLElBQUEsZ0JBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxhQUFBLEdBQUEsT0FBQTtBQUl3RCxTQUFBLHVCQUFBLENBQUEsV0FBQSxDQUFBLElBQUEsQ0FBQSxDQUFBLFVBQUEsR0FBQSxDQUFBLEtBQUEsT0FBQSxFQUFBLENBQUE7QUFBQSxTQUFBLHlCQUFBLENBQUEsNkJBQUEsT0FBQSxtQkFBQSxDQUFBLE9BQUEsT0FBQSxJQUFBLENBQUEsT0FBQSxPQUFBLFlBQUEsd0JBQUEsWUFBQSxDQUFBLENBQUEsV0FBQSxDQUFBLEdBQUEsQ0FBQSxHQUFBLENBQUEsS0FBQSxDQUFBO0FBQUEsU0FBQSx3QkFBQSxDQUFBLEVBQUEsQ0FBQSxTQUFBLENBQUEsSUFBQSxDQUFBLElBQUEsQ0FBQSxDQUFBLFVBQUEsU0FBQSxDQUFBLGVBQUEsQ0FBQSx1QkFBQSxDQUFBLHlCQUFBLENBQUEsV0FBQSxPQUFBLEVBQUEsQ0FBQSxRQUFBLENBQUEsR0FBQSx3QkFBQSxDQUFBLENBQUEsT0FBQSxDQUFBLElBQUEsQ0FBQSxDQUFBLEdBQUEsQ0FBQSxDQUFBLFVBQUEsQ0FBQSxDQUFBLEdBQUEsQ0FBQSxDQUFBLE9BQUEsQ0FBQSxLQUFBLFNBQUEsVUFBQSxDQUFBLEdBQUEsTUFBQSxDQUFBLGNBQUEsSUFBQSxNQUFBLENBQUEsd0JBQUEsV0FBQSxDQUFBLElBQUEsQ0FBQSxvQkFBQSxDQUFBLE9BQUEsY0FBQSxDQUFBLElBQUEsQ0FBQSxDQUFBLEVBQUEsQ0FBQSxTQUFBLENBQUEsR0FBQSxDQUFBLEdBQUEsTUFBQSxDQUFBLHdCQUFBLENBQUEsQ0FBQSxFQUFBLENBQUEsVUFBQSxDQUFBLEtBQUEsQ0FBQSxDQUFBLEdBQUEsSUFBQSxDQUFBLENBQUEsR0FBQSxJQUFBLE1BQUEsQ0FBQSxjQUFBLENBQUEsQ0FBQSxFQUFBLENBQUEsRUFBQSxDQUFBLElBQUEsQ0FBQSxDQUFBLENBQUEsSUFBQSxDQUFBLENBQUEsQ0FBQSxZQUFBLENBQUEsQ0FBQSxPQUFBLEdBQUEsQ0FBQSxFQUFBLENBQUEsSUFBQSxDQUFBLENBQUEsR0FBQSxDQUFBLENBQUEsRUFBQSxDQUFBLEdBQUEsQ0FBQTtBQUFBLFNBQUEsZ0JBQUEsQ0FBQSxFQUFBLENBQUEsRUFBQSxDQUFBLFlBQUEsQ0FBQSxHQUFBLGNBQUEsQ0FBQSxDQUFBLE1BQUEsQ0FBQSxHQUFBLE1BQUEsQ0FBQSxjQUFBLENBQUEsQ0FBQSxFQUFBLENBQUEsSUFBQSxLQUFBLEVBQUEsQ0FBQSxFQUFBLFVBQUEsTUFBQSxZQUFBLE1BQUEsUUFBQSxVQUFBLENBQUEsQ0FBQSxDQUFBLElBQUEsQ0FBQSxFQUFBLENBQUE7QUFBQSxTQUFBLGVBQUEsQ0FBQSxRQUFBLENBQUEsR0FBQSxZQUFBLENBQUEsQ0FBQSx1Q0FBQSxDQUFBLEdBQUEsQ0FBQSxHQUFBLENBQUE7QUFBQSxTQUFBLGFBQUEsQ0FBQSxFQUFBLENBQUEsMkJBQUEsQ0FBQSxLQUFBLENBQUEsU0FBQSxDQUFBLE1BQUEsQ0FBQSxHQUFBLENBQUEsQ0FBQSxNQUFBLENBQUEsV0FBQSxrQkFBQSxDQUFBLFFBQUEsQ0FBQSxHQUFBLENBQUEsQ0FBQSxJQUFBLENBQUEsQ0FBQSxFQUFBLENBQUEsdUNBQUEsQ0FBQSxTQUFBLENBQUEsWUFBQSxTQUFBLHlFQUFBLENBQUEsR0FBQSxNQUFBLEdBQUEsTUFBQSxFQUFBLENBQUEsS0FwQnhEO0FBQ0E7QUFxQmUsTUFBTSxXQUFXLFNBQVMsZ0JBQVMsQ0FBQztFQUFBLFlBQUEsR0FBQSxJQUFBO0lBQUEsU0FBQSxJQUFBO0lBQUEsZUFBQSxrQkEwQnRDLEtBQUssSUFBSztNQUFBLElBQUEscUJBQUE7TUFDbkIsS0FBQSxxQkFBQSxHQUFJLEtBQUssQ0FBQyxhQUFhLENBQUMsS0FBSyxjQUFBLHFCQUFBLGVBQXpCLHFCQUFBLENBQTJCLE1BQU0sRUFBRTtRQUNyQyxNQUFNLGFBQWEsR0FBRyxLQUFLLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUM7UUFDbEQsYUFBYSxhQUFiLGFBQWEsZUFBYixhQUFhLENBQUUsV0FBVyxDQUFFLElBQUksSUFBSztVQUNuQyxNQUFNLEtBQUssR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7VUFDekIsSUFDRSxDQUFDLElBQUEsNkJBQWEsRUFBQyxLQUFLLENBQUMsSUFDckIsSUFBQSxpQ0FBaUIsRUFBQyxLQUFLLEVBQUU7WUFBRSxvQkFBb0IsRUFBRTtVQUFLLENBQUMsQ0FBQyxFQUN4RDtZQUNBLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLElBQUEsa0JBQVksRUFBQyxLQUFLLENBQUMsQ0FBQztVQUN6QztRQUNGLENBQUMsQ0FBQztNQUNKO0lBQ0YsQ0FBQztJQUFBLGVBQUEsbUJBRVUsQ0FBQztNQUFFLE1BQU0sRUFBRTtRQUFFO01BQU07SUFBRSxDQUFDLEtBQUs7TUFDcEMsTUFBTTtRQUNKLG1CQUFtQjtRQUNuQixjQUFjO1FBQ2QsUUFBUTtRQUNSLGdCQUFnQjtRQUNoQjtNQUNGLENBQUMsR0FBRyxJQUFJLENBQUMsS0FBSztNQUNkLE1BQU0sS0FBSyxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQztNQUUxQixJQUFJLGNBQWMsRUFBRTtRQUNsQixRQUFRLENBQUMsS0FBSyxDQUFDO1FBQ2YsT0FBTyxJQUFJO01BQ2I7TUFFQSxJQUFJLElBQUEsa0JBQVcsRUFBQyxLQUFLLENBQUMsRUFBRTtRQUN0QixxQkFBcUIsQ0FBQyxDQUFDO1FBQ3ZCLElBQ0UsbUJBQW1CLElBQ25CLENBQUMsSUFBQSw2QkFBYSxFQUFDLEtBQUssQ0FBQyxJQUNyQixJQUFBLGlDQUFpQixFQUFDLEtBQUssRUFBRTtVQUFFLG9CQUFvQixFQUFFO1FBQUssQ0FBQyxDQUFDLEVBQ3hEO1VBQ0EsTUFBTSxRQUFRLEdBQUcsSUFBQSxrQkFBWSxFQUFDLEtBQUssQ0FBQztVQUNwQyxRQUFRLENBQUMsUUFBUSxDQUFDO1VBQ2xCLG1CQUFtQixDQUFDLFFBQVEsQ0FBQztRQUMvQixDQUFDLE1BQU07VUFDTCxRQUFRLENBQUMsS0FBSyxDQUFDO1FBQ2pCO01BQ0YsQ0FBQyxNQUFNO1FBQ0wsUUFBUSxDQUFDLEtBQUssQ0FBQztRQUNmLGdCQUFnQixDQUFDLEtBQUssQ0FBQztNQUN6QjtNQUVBLE9BQU8sSUFBSTtJQUNiLENBQUM7RUFBQTtFQXJERCxpQkFBaUIsQ0FBQSxFQUFHO0lBQ2xCLElBQUksQ0FBQyxLQUFLLENBQUMscUJBQXFCLENBQUMsQ0FBQztFQUNwQztFQXFEQSxNQUFNLENBQUEsRUFBRztJQUNQLE1BQU07TUFBRTtJQUFFLENBQUMsR0FBRyxJQUFJLENBQUMsT0FBTztJQUMxQixNQUFNO01BQUUsU0FBUztNQUFFLGVBQWU7TUFBRSxZQUFZO01BQUU7SUFBVSxDQUFDLEdBQUcsSUFBSSxDQUFDLEtBQUs7SUFFMUUsTUFBTSxrQkFBa0IsR0FBRyxPQUFPLENBQUMsZUFBZSxDQUFDO0lBRW5ELE1BQU0sZ0JBQWdCLEdBQ3BCLFlBQVksSUFBSSxlQUFlLEdBQzNCLElBQUEscUJBQWMsRUFBQyxJQUFBLG9DQUFvQixFQUFDLGVBQWUsQ0FBQyxDQUFDLEdBQ3JELFNBQVM7SUFFZixvQkFDRSxNQUFBLENBQUEsT0FBQSxDQUFBLGFBQUE7TUFBSyxTQUFTLEVBQUUsSUFBQSxtQkFBVSxFQUFDLFdBQVcsRUFBRSxTQUFTO0lBQUUsZ0JBQ2pELE1BQUEsQ0FBQSxPQUFBLENBQUEsYUFBQTtNQUNFLFNBQVMsRUFBRSxJQUFBLG1CQUFVLEVBQUMsb0JBQW9CLEVBQUU7UUFDMUMsd0NBQXdDLEVBQUUsS0FBSztRQUMvQyx3Q0FBd0MsRUFBRSxLQUFLO1FBQy9DLDJCQUEyQixFQUFFO01BQy9CLENBQUM7SUFBRSxHQUVGLGtCQUFrQixnQkFDakIsTUFBQSxDQUFBLE9BQUEsQ0FBQSxhQUFBLENBQUEsTUFBQSxDQUFBLE9BQUEsQ0FBQSxRQUFBLHFCQUNFLE1BQUEsQ0FBQSxPQUFBLENBQUEsYUFBQTtNQUNFLFNBQVMsRUFBQywrREFBK0Q7TUFDekUsZUFBWTtJQUFvQixnQkFFaEMsTUFBQSxDQUFBLE9BQUEsQ0FBQSxhQUFBLENBQUMsZ0JBQUEsQ0FBQSxlQUFlO01BQUMsT0FBTyxFQUFFO0lBQWdCLENBQUUsQ0FBQyxlQUU3QyxNQUFBLENBQUEsT0FBQSxDQUFBLGFBQUE7TUFBSyxTQUFTLEVBQUM7SUFBa0MsR0FDOUMsWUFBWSxJQUFJLGVBQWUsRUFDL0IsZ0JBQWdCLGdCQUNmLE1BQUEsQ0FBQSxPQUFBLENBQUEsYUFBQSxDQUFDLGlCQUFBLENBQUEsSUFBSTtNQUNILEtBQUssRUFBRSx1QkFBUyxDQUFDLGVBQWdCO01BQ2pDLE9BQU8sRUFBRSx5QkFBVyxDQUFDLE1BQU87TUFDNUIsUUFBUTtJQUFBLEdBRVAsZ0JBQ0csQ0FBQyxHQUNMLElBQ0QsQ0FDRixDQUFDLGVBQ04sTUFBQSxDQUFBLE9BQUEsQ0FBQSxhQUFBLENBQUMsaUJBQUEsQ0FBQSxVQUFVO01BQ1QsUUFBUSxFQUFFLDBCQUFRLENBQUMsS0FBTTtNQUN6QixTQUFTLEVBQUUsQ0FBQyxDQUFDLE9BQU8sQ0FBRTtNQUN0QixPQUFPLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFRO01BQzVCLFNBQVMsRUFBQyx3Q0FBd0M7TUFDbEQsSUFBSSxFQUFFLDBCQUFRLENBQUM7SUFBRyxDQUNuQixDQUNELENBQUMsZ0JBRUgsTUFBQSxDQUFBLE9BQUEsQ0FBQSxhQUFBLENBQUEsTUFBQSxDQUFBLE9BQUEsQ0FBQSxRQUFBLHFCQUNFLE1BQUEsQ0FBQSxPQUFBLENBQUEsYUFBQTtNQUNFLFNBQVMsRUFBQywyQkFBMkI7TUFDckMsSUFBSSxFQUFDLE1BQU07TUFDWCxHQUFHLEVBQUMsTUFBTTtNQUNWLFdBQVcsRUFBRSxDQUFDLENBQUMsZ0NBQWdDLENBQUU7TUFDakQsUUFBUSxFQUFFLElBQUksQ0FBQyxRQUFTO01BQ3hCLE9BQU8sRUFBRSxJQUFJLENBQUMsT0FBUTtNQUN0QixVQUFVLEVBQUMsT0FBTztNQUNsQixLQUFLLEVBQUUsZUFBZSxJQUFJLFNBQVU7TUFDcEMsU0FBUztNQUNULGVBQVk7SUFBVyxDQUN4QixDQUFDLGVBQ0YsTUFBQSxDQUFBLE9BQUEsQ0FBQSxhQUFBLENBQUMsaUJBQUEsQ0FBQSxVQUFVO01BQ1QsU0FBUyxFQUFDLHdDQUF3QztNQUNsRCxPQUFPLEVBQUUsQ0FBQSxLQUFNO1FBQ2IsSUFBSSxDQUFBLFNBQVMsYUFBVCxTQUFTLHVCQUFULFNBQVMsQ0FBRSxNQUFNLElBQUcsQ0FBQyxFQUFFO1VBQ3pCLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUM7UUFDdEIsQ0FBQyxNQUFNO1VBQ0wsSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsQ0FBQztRQUN6QjtNQUNGLENBQUU7TUFDRixRQUFRLEVBQUUsU0FBUyxHQUFHLDBCQUFRLENBQUMsS0FBSyxHQUFHLDBCQUFRLENBQUMsSUFBSztNQUNyRCxTQUFTLEVBQUUsQ0FBQyxDQUFDLFNBQVMsR0FBRyxPQUFPLEdBQUcsWUFBWSxDQUFFO01BQ2pELEtBQUssRUFDSCxTQUFTLEdBQUcsdUJBQVMsQ0FBQyxXQUFXLEdBQUcsdUJBQVMsQ0FBQyxjQUMvQztNQUNELGVBQVk7SUFBb0IsQ0FDakMsQ0FDRCxDQUVELENBQ0YsQ0FBQztFQUVWO0FBQ0Y7QUFBQyxPQUFBLENBQUEsT0FBQSxHQUFBLFdBQUE7QUFBQSxlQUFBLENBbEtvQixXQUFXLGtCQUNSO0VBQ3BCLENBQUMsRUFBRSxrQkFBUyxDQUFDLElBQUk7RUFDakIsWUFBWSxFQUFFLGtCQUFTLENBQUM7QUFDMUIsQ0FBQztBQUFBLGVBQUEsQ0FKa0IsV0FBVyxlQU1YO0VBQ2pCLFNBQVMsRUFBRSxrQkFBUyxDQUFDLE1BQU07RUFDM0IsZUFBZSxFQUFFLGtCQUFTLENBQUMsTUFBTTtFQUNqQyxZQUFZLEVBQUUsa0JBQVMsQ0FBQyxNQUFNO0VBQzlCLFVBQVUsRUFBRSxrQkFBUyxDQUFDLElBQUk7RUFDMUIsT0FBTyxFQUFFLGtCQUFTLENBQUMsSUFBSTtFQUN2QixtQkFBbUIsRUFBRSxrQkFBUyxDQUFDLElBQUk7RUFDbkMsY0FBYyxFQUFFLGtCQUFTLENBQUMsSUFBSTtFQUM5QixTQUFTLEVBQUUsa0JBQVMsQ0FBQyxNQUFNO0VBQzNCLFFBQVEsRUFBRSxrQkFBUyxDQUFDLElBQUksQ0FBQyxVQUFVO0VBQ25DLE9BQU8sRUFBRSxrQkFBUyxDQUFDLElBQUksQ0FBQyxVQUFVO0VBQ2xDLGdCQUFnQixFQUFFLGtCQUFTLENBQUMsSUFBSSxDQUFDLFVBQVU7RUFDM0MscUJBQXFCLEVBQUUsa0JBQVMsQ0FBQyxJQUFJLENBQUMsVUFBVTtFQUNoRCxxQkFBcUIsRUFBRSxrQkFBUyxDQUFDLElBQUksQ0FBQztBQUN4QyxDQUFDOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQy9DSCxJQUFBLE9BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxXQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsUUFBQSxHQUFBLE9BQUE7QUFLQSxJQUFBLFVBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxZQUFBLEdBQUEsc0JBQUEsQ0FBQSxPQUFBO0FBQW1ELFNBQUEsdUJBQUEsQ0FBQSxXQUFBLENBQUEsSUFBQSxDQUFBLENBQUEsVUFBQSxHQUFBLENBQUEsS0FBQSxPQUFBLEVBQUEsQ0FBQTtBQUVuRDtBQUNBLFNBQVMsZUFBZSxDQUFDLEtBQUssRUFBRTtFQUM5QixPQUFPO0lBQUUsVUFBVSxFQUFFLElBQUEsd0JBQWEsRUFBQyxLQUFLO0VBQUUsQ0FBQztBQUM3QztBQUVBLFNBQVMsa0JBQWtCLENBQUMsUUFBUSxFQUFFO0VBQ3BDLE9BQU87SUFDTCxnQkFBZ0IsRUFBRSxJQUFBLGdCQUFRLEVBQ3ZCLFVBQVUsSUFBSyxRQUFRLENBQUMsSUFBQSx5QkFBZ0IsRUFBQyxVQUFVLENBQUMsQ0FBQyxFQUN0RCxHQUNGLENBQUM7SUFDRCxxQkFBcUIsRUFBRSxDQUFBLEtBQU0sUUFBUSxDQUFDLElBQUEsOEJBQXFCLEVBQUMsQ0FBQyxDQUFDO0lBQzlELHFCQUFxQixFQUFFLElBQUEsZ0JBQVEsRUFDN0IsTUFBTSxRQUFRLENBQUMsSUFBQSw4QkFBcUIsRUFBQyxDQUFDLENBQUMsRUFDdkMsR0FDRjtFQUNGLENBQUM7QUFDSDtBQUFDLElBQUEsUUFBQSxHQUFBLE9BQUEsQ0FBQSxPQUFBLEdBRWMsSUFBQSxtQkFBTyxFQUFDLGVBQWUsRUFBRSxrQkFBa0IsQ0FBQyxDQUFDLG9CQUFXLENBQUM7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUM3QnhFLElBQUEsWUFBQSxHQUFBLHNCQUFBLENBQUEsT0FBQTtBQUFtRCxTQUFBLHVCQUFBLENBQUEsV0FBQSxDQUFBLElBQUEsQ0FBQSxDQUFBLFVBQUEsR0FBQSxDQUFBLEtBQUEsT0FBQSxFQUFBLENBQUE7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNBbkQsSUFBQSxLQUFBLEdBQUEsT0FBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNBQSxJQUFBLE1BQUEsR0FBQSxzQkFBQSxDQUFBLE9BQUE7QUFFQSxJQUFBLGFBQUEsR0FBQSxPQUFBO0FBU0EsSUFBQSxpQkFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLGdCQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxPQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsS0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxtQkFBQSxHQUFBLE9BQUE7QUFBc0UsU0FBQSx1QkFBQSxDQUFBLFdBQUEsQ0FBQSxJQUFBLENBQUEsQ0FBQSxVQUFBLEdBQUEsQ0FBQSxLQUFBLE9BQUEsRUFBQSxDQUFBO0FBRXRFLE1BQU0sYUFBYSxHQUFHLENBQUM7RUFBRTtBQUF3QyxDQUFDLEtBQUs7RUFDckUsb0JBQ0UsTUFBQSxDQUFBLE9BQUEsQ0FBQSxhQUFBLENBQUMsaUJBQUEsQ0FBQSxHQUFHO0lBQ0YsVUFBVSxFQUFFLHdCQUFVLENBQUMsTUFBTztJQUM5QixlQUFlLEVBQUUsNkJBQWUsQ0FBQyxpQkFBa0I7SUFDbkQsU0FBUyxFQUFDLDZCQUE2QjtJQUN2QyxPQUFPLEVBQUUscUJBQU8sQ0FBQyxJQUFLO0lBQ3RCLGFBQWEsRUFBRSwyQkFBYSxDQUFDLE1BQU87SUFDcEMsTUFBTSxFQUFFLHVCQUFTLENBQUMsSUFBSztJQUN2QixjQUFjLEVBQUUsNEJBQWMsQ0FBQyxNQUFPO0lBQ3RDLEtBQUssRUFBRTtNQUFFLElBQUksRUFBRSxVQUFVO01BQUUsU0FBUyxFQUFFO0lBQUUsQ0FBRTtJQUMxQyxLQUFLLEVBQUUsdUJBQVMsQ0FBQztFQUFLLGdCQUV0QixNQUFBLENBQUEsT0FBQSxDQUFBLGFBQUEsQ0FBQyxpQkFBQSxDQUFBLEdBQUc7SUFDRixlQUFlLEVBQUUsNkJBQWUsQ0FBQyxpQkFBa0I7SUFDbkQsU0FBUyxFQUFDLDJCQUEyQjtJQUNyQyxPQUFPLEVBQUUscUJBQU8sQ0FBQyxJQUFLO0lBQ3RCLE1BQU0sRUFBRSx1QkFBUyxDQUFDLElBQUs7SUFDdkIsY0FBYyxFQUFFLDRCQUFjLENBQUMsTUFBTztJQUN0QyxLQUFLLEVBQUUsdUJBQVMsQ0FBQyxJQUFLO0lBQ3RCLFlBQVksRUFBRSwwQkFBWSxDQUFDO0VBQUcsZ0JBRTlCLE1BQUEsQ0FBQSxPQUFBLENBQUEsYUFBQSxDQUFDLGlCQUFBLENBQUEsR0FBRztJQUNGLFNBQVMsRUFBQywyQkFBMkI7SUFDckMsT0FBTyxFQUFFLHFCQUFPLENBQUMsSUFBSztJQUN0QixhQUFhLEVBQUUsMkJBQWEsQ0FBQyxNQUFPO0lBQ3BDLE1BQU0sRUFBRSx1QkFBUyxDQUFDLElBQUs7SUFDdkIsS0FBSyxFQUFFO01BQUUsUUFBUSxFQUFFO0lBQVEsQ0FBRTtJQUM3QixLQUFLLEVBQUUsdUJBQVMsQ0FBQztFQUFLLGdCQUV0QixNQUFBLENBQUEsT0FBQSxDQUFBLGFBQUEsQ0FBQyxPQUFBLENBQUEsTUFBTSxNQUFFLENBQUMsRUFDVCxRQUNFLENBQ0YsQ0FDRixDQUFDO0FBRVYsQ0FBQztBQUVNLE1BQU0sU0FBUyxHQUFHLENBQUEsS0FBTTtFQUM3QixJQUFBLHNDQUFrQixFQUFDLENBQUM7RUFDcEIsTUFBTTtJQUFFO0VBQVksQ0FBQyxHQUFHLElBQUEscUJBQWMsRUFBQyxDQUFDO0VBRXhDLElBQUksV0FBVyxLQUFLLGVBQVMsQ0FBQyxNQUFNLEVBQUU7SUFDcEMsb0JBQU8sTUFBQSxDQUFBLE9BQUEsQ0FBQSxhQUFBLENBQUMsT0FBQSxDQUFBLE1BQU0sTUFBRSxDQUFDO0VBQ25CO0VBQ0EsSUFBSSxXQUFXLEtBQUssZUFBUyxDQUFDLEtBQUssRUFBRTtJQUNuQyxvQkFDRSxNQUFBLENBQUEsT0FBQSxDQUFBLGFBQUEsQ0FBQyxhQUFhLHFCQUNaLE1BQUEsQ0FBQSxPQUFBLENBQUEsYUFBQSxDQUFDLE1BQUEsQ0FBQSxLQUFLLE1BQUUsQ0FDSyxDQUFDO0VBRXBCO0VBQ0EsSUFBSSxXQUFXLEtBQUssZUFBUyxDQUFDLGVBQWUsRUFBRTtJQUM3QyxvQkFDRSxNQUFBLENBQUEsT0FBQSxDQUFBLGFBQUEsQ0FBQyxhQUFhLHFCQUNaLE1BQUEsQ0FBQSxPQUFBLENBQUEsYUFBQSxDQUFDLGdCQUFBLENBQUEsZUFBZSxNQUFFLENBQ0wsQ0FBQztFQUVwQjtFQUVBLE9BQU8sSUFBSTtBQUNiLENBQUM7QUFBQyxPQUFBLENBQUEsU0FBQSxHQUFBLFNBQUE7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDakZGLElBQUEsTUFBQSxHQUFBLHNCQUFBLENBQUEsT0FBQTtBQUVBLElBQUEsS0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxZQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsc0JBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxVQUFBLEdBQUEsT0FBQTtBQUF5QyxTQUFBLHVCQUFBLENBQUEsV0FBQSxDQUFBLElBQUEsQ0FBQSxDQUFBLFVBQUEsR0FBQSxDQUFBLEtBQUEsT0FBQSxFQUFBLENBQUE7QUFFbEMsTUFBTSxJQUFJLEdBQUcsQ0FBQSxLQUFNO0VBQ3hCLE1BQU07SUFBRSxPQUFPLEVBQUU7RUFBc0IsQ0FBQyxHQUFHLElBQUEsNENBQXFCLEVBQUMsQ0FBQztFQUVsRSxJQUFJLHFCQUFxQixFQUFFO0lBQ3pCLG9CQUNFLE1BQUEsQ0FBQSxPQUFBLENBQUEsYUFBQSxDQUFDLE1BQUEsQ0FBQSxtQkFBbUIscUJBQ2xCLE1BQUEsQ0FBQSxPQUFBLENBQUEsYUFBQSxDQUFDLFlBQUEsQ0FBQSwwQkFBMEIscUJBQ3pCLE1BQUEsQ0FBQSxPQUFBLENBQUEsYUFBQSxDQUFDLFVBQUEsQ0FBQSxTQUFTLE1BQUUsQ0FDYyxDQUNULENBQUM7RUFFMUI7RUFFQSxvQkFBTyxNQUFBLENBQUEsT0FBQSxDQUFBLGFBQUEsQ0FBQyxLQUFBLENBQUEsUUFBUSxNQUFFLENBQUM7QUFDckIsQ0FBQztBQUFDLE9BQUEsQ0FBQSxJQUFBLEdBQUEsSUFBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7SUNwQlUsYUFBYSxHQUFBLE9BQUEsQ0FBQSxhQUFBLDBCQUFiLGFBQWE7RUFBYixhQUFhO0VBQWIsYUFBYTtFQUFiLGFBQWE7RUFBYixhQUFhO0VBQUEsT0FBYixhQUFhO0FBQUE7QUFPbEIsTUFBTSxhQUFhLEdBQUEsT0FBQSxDQUFBLGFBQUEsR0FBRyxDQUFDLGFBQWEsQ0FBQyxNQUFNLEVBQUUsYUFBYSxDQUFDLE9BQU8sQ0FBQzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNQMUU7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTyxNQUFNLG1CQUFtQixHQUFJLE9BQXdCLElBQWM7RUFBQSxJQUFBLGVBQUE7RUFDeEUsSUFBSSxDQUFDLE9BQU8sRUFBRTtJQUNaLE9BQU8sS0FBSztFQUNkO0VBRUEsSUFBSSxPQUFPLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsRUFBRTtJQUN0QyxPQUFPLElBQUk7RUFDYjtFQUVBLEtBQUEsZUFBQSxHQUFJLE9BQU8sQ0FBQyxNQUFNLGNBQUEsZUFBQSxlQUFkLGVBQUEsQ0FBZ0IsSUFBSSxDQUFFLEtBQUssSUFBSyxLQUFLLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDLEVBQUU7SUFDaEUsT0FBTyxJQUFJO0VBQ2I7RUFFQSxPQUFPLEtBQUs7QUFDZCxDQUFDOztBQUVEO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUxBLE9BQUEsQ0FBQSxtQkFBQSxHQUFBLG1CQUFBO0FBTU8sTUFBTSxzQkFBc0IsR0FBSSxPQUF3QixJQUFjO0VBQUEsSUFBQSxnQkFBQTtFQUMzRSxJQUFJLENBQUMsT0FBTyxFQUFFO0lBQ1osT0FBTyxLQUFLO0VBQ2Q7RUFFQSxJQUFJLE9BQU8sQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxFQUFFO0lBQ3RDLE9BQU8sSUFBSTtFQUNiO0VBRUEsS0FBQSxnQkFBQSxHQUFJLE9BQU8sQ0FBQyxNQUFNLGNBQUEsZ0JBQUEsZUFBZCxnQkFBQSxDQUFnQixJQUFJLENBQUUsS0FBSyxJQUFLLEtBQUssQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsRUFBRTtJQUNoRSxPQUFPLElBQUk7RUFDYjtFQUVBLE9BQU8sS0FBSztBQUNkLENBQUM7O0FBRUQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBTEEsT0FBQSxDQUFBLHNCQUFBLEdBQUEsc0JBQUE7QUFNTyxNQUFNLHVCQUF1QixHQUFJLE9BQXdCLElBQWM7RUFBQSxJQUFBLGdCQUFBO0VBQzVFLElBQUksQ0FBQyxPQUFPLEVBQUU7SUFDWixPQUFPLEtBQUs7RUFDZDtFQUVBLElBQUksT0FBTyxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLEVBQUU7SUFDdEMsT0FBTyxJQUFJO0VBQ2I7RUFFQSxLQUFBLGdCQUFBLEdBQUksT0FBTyxDQUFDLE1BQU0sY0FBQSxnQkFBQSxlQUFkLGdCQUFBLENBQWdCLElBQUksQ0FBRSxLQUFLLElBQUssS0FBSyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxFQUFFO0lBQ2hFLE9BQU8sSUFBSTtFQUNiO0VBRUEsT0FBTyxLQUFLO0FBQ2QsQ0FBQztBQUFDLE9BQUEsQ0FBQSx1QkFBQSxHQUFBLHVCQUFBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDbkVGLElBQUEsUUFBQSxHQUFBLE9BQUE7QUFBQSxNQUFBLENBQUEsSUFBQSxDQUFBLFFBQUEsRUFBQSxPQUFBLFdBQUEsR0FBQTtFQUFBLElBQUEsR0FBQSxrQkFBQSxHQUFBO0VBQUEsSUFBQSxHQUFBLElBQUEsT0FBQSxJQUFBLE9BQUEsQ0FBQSxHQUFBLE1BQUEsUUFBQSxDQUFBLEdBQUE7RUFBQSxNQUFBLENBQUEsY0FBQSxDQUFBLE9BQUEsRUFBQSxHQUFBO0lBQUEsVUFBQTtJQUFBLEdBQUEsV0FBQSxDQUFBO01BQUEsT0FBQSxRQUFBLENBQUEsR0FBQTtJQUFBO0VBQUE7QUFBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDQUEsSUFBQSxXQUFBLEdBQUEsT0FBQTtBQUlBLElBQUEsUUFBQSxHQUFBLE9BQUE7QUFFTyxlQUFlLGtDQUFrQyxDQUN0RCxXQUE0QixFQUM1QixNQUtDLEVBQ0Q7RUFBQSxJQUFBLHFCQUFBO0VBQ0EsT0FBTyxNQUFNLElBQUEsMEJBQWlCLEVBQUM7SUFDN0IsTUFBTSxHQUFBLHFCQUFBLEdBQUUsV0FBVyxDQUFDLFFBQVEsY0FBQSxxQkFBQSxnQkFBQSxxQkFBQSxHQUFwQixxQkFBQSxDQUFzQixJQUFJLGNBQUEscUJBQUEsdUJBQTFCLHFCQUFBLENBQTRCLEVBQVk7SUFDaEQsTUFBTSxFQUFFLFVBQVU7SUFDbEIsT0FBTyxFQUFFLHVCQUFXLENBQUMsZUFBZTtJQUNwQyxPQUFPLEVBQUU7TUFDUCxNQUFNLEVBQUUsYUFBYTtNQUNyQjtJQUNGO0VBQ0YsQ0FBQyxDQUFDO0FBQ0o7QUFFTyxlQUFlLHdCQUF3QixDQUM1QyxXQUE0QixFQUM1QixNQUlDLEVBQ0Q7RUFBQSxJQUFBLHNCQUFBO0VBQ0EsT0FBTyxNQUFNLElBQUEsMEJBQWlCLEVBQUM7SUFDN0IsTUFBTSxHQUFBLHNCQUFBLEdBQUUsV0FBVyxDQUFDLFFBQVEsY0FBQSxzQkFBQSxnQkFBQSxzQkFBQSxHQUFwQixzQkFBQSxDQUFzQixJQUFJLGNBQUEsc0JBQUEsdUJBQTFCLHNCQUFBLENBQTRCLEVBQVk7SUFDaEQsTUFBTSxFQUFFLFVBQVU7SUFDbEIsT0FBTyxFQUFFLHVCQUFXLENBQUMsZUFBZTtJQUNwQyxPQUFPLEVBQUU7TUFDUCxNQUFNLEVBQUUsZUFBZTtNQUN2QjtJQUNGO0VBQ0YsQ0FBQyxDQUFDO0FBQ0o7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUMzQ0EsSUFBQSxnQkFBQSxHQUFBLE9BQUE7QUFFQSxJQUFBLHNCQUFBLEdBQUEsT0FBQTtBQUlBLElBQUEsZUFBQSxHQUFBLE9BQUE7QUFHQSxJQUFBLFFBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxRQUFBLEdBQUEsT0FBQTtBQU1BLElBQUEsS0FBQSxHQUFBLE9BQUE7QUFLQSxJQUFBLE9BQUEsR0FBQSxPQUFBO0FBRU8sTUFBTSxpQkFBaUIsR0FBSSxNQUFjLElBQUs7RUFDbkQsT0FBTyxNQUFNLENBQUMsT0FBTyxDQUFDLG9CQUFvQixFQUFFLElBQUksQ0FBQyxDQUFDLE9BQU8sQ0FBQyxRQUFRLEVBQUUsRUFBRSxDQUFDO0FBQ3pFLENBQUM7QUFBQyxPQUFBLENBQUEsaUJBQUEsR0FBQSxpQkFBQTtBQUVLLE1BQU0sNkJBQTZCLEdBQUcsQ0FDM0MsS0FBYSxFQUNiLFFBQXFDLEtBQ2xDO0VBQ0gsSUFBSSxDQUFDLEtBQUssRUFBRTtJQUNWLE9BQU8sU0FBUztFQUNsQjtFQUNBLE1BQU0sWUFBWSxHQUFHLFFBQVEsQ0FBQyxDQUFBLFFBQVEsYUFBUixRQUFRLHVCQUFSLFFBQVEsQ0FBRSxRQUFRLENBQUMsQ0FBQyxLQUFJLEdBQUcsRUFBRSxFQUFFLENBQUM7RUFDOUQsTUFBTSxNQUFNLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQztFQUNsRCxNQUFNLE9BQU8sR0FBRyxNQUFNLENBQUMsQ0FBQyxDQUFDO0VBQ3pCLElBQUksUUFBUSxHQUFHLE1BQU0sQ0FBQyxDQUFDLENBQUMsSUFBSSxFQUFFO0VBRTlCLElBQUksUUFBUSxDQUFDLE1BQU0sR0FBRyxZQUFZLEVBQUU7SUFDbEMsUUFBUSxHQUFHLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQyxFQUFFLFlBQVksQ0FBQztFQUM1QztFQUVBLE9BQU8sUUFBUSxHQUFHLEdBQUcsT0FBTyxJQUFJLFFBQVEsRUFBRSxHQUFHLE9BQU87QUFDdEQsQ0FBQztBQUFDLE9BQUEsQ0FBQSw2QkFBQSxHQUFBLDZCQUFBO0FBRUssTUFBTSx3QkFBd0IsR0FBRyxDQUN0QyxLQUFhLEVBQ2IsSUFBaUIsRUFDakIsUUFBMEIsS0FDdkI7RUFDSCxNQUFNLFlBQVksR0FBRyxRQUFRLENBQUMsQ0FBQSxRQUFRLGFBQVIsUUFBUSx1QkFBUixRQUFRLENBQUUsUUFBUSxDQUFDLENBQUMsS0FBSSxHQUFHLEVBQUUsRUFBRSxDQUFDO0VBQzlELE1BQU0sVUFBVSxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsQ0FBQztFQUNyRCxPQUFPLElBQUksZ0JBQU8sQ0FBQyxLQUFLLEVBQUUsSUFBSSxDQUFDLENBQUMsS0FBSyxDQUFDLFVBQVUsRUFBRSxFQUFFLENBQUM7QUFDdkQsQ0FBQztBQUFDLE9BQUEsQ0FBQSx3QkFBQSxHQUFBLHdCQUFBO0FBRUssTUFBTSw0QkFBNEIsR0FBRyxDQUMxQyxLQUFhLEVBQ2IsUUFBMEIsS0FDdkIsd0JBQXdCLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxRQUFRLENBQUM7QUFBQyxPQUFBLENBQUEsNEJBQUEsR0FBQSw0QkFBQTtBQUU1QyxNQUFNLHFCQUFxQixHQUFHLENBQ25DLEtBQWEsRUFDYixRQUEwQixLQUUxQixJQUFBLDRCQUFZLEVBQ1YsNEJBQTRCLENBQUMsS0FBSyxFQUFFLFFBQVEsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxFQUFFLENBQUMsQ0FBQyxRQUFRLENBQUMsQ0FDcEUsQ0FBQztBQUFDLE9BQUEsQ0FBQSxxQkFBQSxHQUFBLHFCQUFBO0FBRUcsTUFBTSwrQkFBK0IsR0FBRyxDQUM3QyxLQUFhLEVBQ2IsUUFBMEIsS0FDdkIsd0JBQXdCLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxRQUFRLENBQUM7QUFBQyxPQUFBLENBQUEsK0JBQUEsR0FBQSwrQkFBQTtBQUU1QyxNQUFNLHlCQUF5QixHQUFHLENBQ3ZDLEtBQWEsRUFDYixRQUF5QixHQUFHLENBQUMsRUFDN0IsSUFBa0IsS0FDZjtFQUNILE1BQU0sWUFBWSxHQUFHLFFBQVEsQ0FBQyxDQUFBLFFBQVEsYUFBUixRQUFRLHVCQUFSLFFBQVEsQ0FBRSxRQUFRLENBQUMsQ0FBQyxLQUFJLEdBQUcsRUFBRSxFQUFFLENBQUM7RUFDOUQsTUFBTSxVQUFVLEdBQUcsSUFBSSxDQUFDLEdBQUcsQ0FBQyxFQUFFLEVBQUUsTUFBTSxDQUFDLFlBQVksQ0FBQyxDQUFDO0VBQ3JELE9BQU8sSUFBSSxnQkFBTyxDQUFDLEtBQUssRUFBRSxJQUFJLElBQUksRUFBRSxDQUFDLENBQUMsTUFBTSxDQUFDLFVBQVUsRUFBRSxFQUFFLENBQUM7QUFDOUQsQ0FBQztBQUFDLE9BQUEsQ0FBQSx5QkFBQSxHQUFBLHlCQUFBO0FBRUssTUFBTSxrQkFBa0IsR0FBRyxDQUNoQyxLQUFhLEVBQ2IsUUFBeUIsR0FBRyxDQUFDLEVBQzdCLElBQWtCLEtBQ2Y7RUFDSCxPQUFPLDZCQUE2QixDQUNsQyx5QkFBeUIsQ0FBQyxLQUFLLEVBQUUsUUFBUSxFQUFFLElBQUksQ0FBQyxDQUFDLE1BQU0sQ0FBQyxFQUFFLENBQUMsQ0FBQyxRQUFRLENBQUMsQ0FBQyxFQUN0RSxRQUNGLENBQUM7QUFDSCxDQUFDO0FBQUMsT0FBQSxDQUFBLGtCQUFBLEdBQUEsa0JBQUE7QUFFSyxTQUFTLHFCQUFxQixDQUNuQyxLQUF5QixFQUN6QixjQUErQixHQUFHLENBQUMsRUFDbkMsd0JBQXdCLEdBQUcsSUFBSSxFQUMvQjtFQUNBLElBQUksQ0FBQyxLQUFLLElBQUksQ0FBQyw0QkFBNEIsQ0FBQyxLQUFLLENBQUMsRUFBRTtJQUNsRCxPQUFPLEdBQUc7RUFDWjtFQUVBLE1BQU0sR0FBRyxHQUFHLElBQUksZ0JBQU8sQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDO0VBQ2xDLElBQUksR0FBRyxDQUFDLE1BQU0sQ0FBQyxDQUFDLEVBQUU7SUFDaEIsT0FBTyxHQUFHO0VBQ1o7RUFDQSxJQUFJLFFBQVEsR0FBRyxRQUFRLENBQUMsY0FBYyxhQUFkLGNBQWMsdUJBQWQsY0FBYyxDQUFFLFFBQVEsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDO0VBQ3ZELFFBQVEsR0FBRyxRQUFRLEdBQUcsQ0FBQyxHQUFHLFFBQVEsR0FBRyxDQUFDO0VBRXRDLE1BQU0sTUFBTSxHQUFHLENBQUMsR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLEVBQUUsRUFBRSxRQUFRLENBQUM7RUFDekMsSUFBSSxHQUFHLENBQUMsUUFBUSxDQUFDLElBQUksZ0JBQU8sQ0FBQyxNQUFNLEVBQUUsRUFBRSxDQUFDLENBQUMsRUFBRTtJQUN6QyxPQUFPLEtBQUssTUFBTSxFQUFFO0VBQ3RCO0VBRUEsTUFBTSxXQUFXLEdBQUcsR0FBRyxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQztFQUM3QyxNQUFNLE9BQU8sR0FBRyxXQUFXLENBQUMsQ0FBQyxDQUFDO0VBQzlCLElBQUksUUFBUSxHQUFHLFdBQVcsQ0FBQyxDQUFDLENBQUMsSUFBSSxFQUFFO0VBRW5DLElBQUksUUFBUSxDQUFDLE1BQU0sR0FBRyxRQUFRLEVBQUU7SUFDOUIsUUFBUSxHQUFHLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQyxFQUFFLFFBQVEsQ0FBQztFQUN4QyxDQUFDLE1BQU07SUFDTCxRQUFRLEdBQUcsUUFBUSxDQUFDLE1BQU0sQ0FBQyxRQUFRLEVBQUUsR0FBRyxDQUFDO0VBQzNDO0VBRUEsSUFBSSxDQUFDLFFBQVEsRUFBRTtJQUNiLE9BQU8sT0FBTztFQUNoQjtFQUVBLE9BQU8sd0JBQXdCLEdBQzNCLGlCQUFpQixDQUFDLEdBQUcsT0FBTyxJQUFJLFFBQVEsRUFBRSxDQUFDLEdBQzNDLEdBQUcsT0FBTyxJQUFJLFFBQVEsRUFBRTtBQUM5QjtBQUVPLE1BQU0scUJBQXFCLEdBQUcsQ0FDbkMsS0FBWSxFQUNaLGlCQUFvQyxFQUNwQyxPQUFZLEdBQUcsSUFBSSxLQUNoQjtFQUNILE1BQU07SUFBRSxJQUFJO0lBQUUsRUFBRTtJQUFFO0VBQU0sQ0FBQyxHQUFHLGlCQUFpQjtFQUM3QyxNQUFNLFVBQTZCLEdBQUc7SUFBRTtFQUFLLENBQUM7RUFFOUMsTUFBTSxVQUFVLEdBQUcsS0FBSyxDQUFDLE9BQU8sR0FDNUIsS0FBSyxHQUNMLHFCQUFxQixDQUFDLEtBQUssSUFBSSxHQUFHLEVBQUUsS0FBSyxDQUFDLFFBQVEsQ0FBQzs7RUFFdkQ7RUFDQSxJQUFJLEtBQUssQ0FBQyxRQUFRLEVBQUU7SUFDbEIsVUFBVSxDQUFDLElBQUksR0FBRyxPQUFPO0lBQ3pCLFVBQVUsQ0FBQyxFQUFFLEdBQUcsRUFBRTtJQUNsQixVQUFVLENBQUMsS0FBSyxHQUFHLFVBQVU7SUFDN0IsT0FBTyxVQUFVO0VBQ25COztFQUVBO0VBQ0EsSUFBSSxLQUFLLENBQUMsUUFBUSxLQUFLLHdCQUFPLEVBQUU7SUFDOUIsVUFBVSxDQUFDLElBQUksR0FBRyxJQUFBLGlDQUEyQixFQUFDO01BQzVDLFdBQVcsRUFBRSxJQUFJO01BQ2pCLFNBQVMsRUFBRSxFQUFFO01BQ2IsT0FBTyxFQUFFLEtBQUssQ0FBQyxPQUFPO01BQ3RCLE1BQU0sRUFBRTtJQUNWLENBQUMsQ0FBQztJQUNGLFVBQVUsQ0FBQyxFQUFFLEdBQUcsS0FBSyxDQUFDLE9BQU87SUFDN0IsVUFBVSxDQUFDLEtBQUssR0FBRyxLQUFLO0lBQ3hCLE9BQU8sVUFBVTtFQUNuQjs7RUFFQTtFQUNBLElBQUksS0FBSyxDQUFDLFFBQVEsS0FBSyx1QkFBTSxFQUFFO0lBQzdCLFVBQVUsQ0FBQyxJQUFJLEdBQUcsSUFBQSxnQ0FBMEIsRUFBQztNQUMzQyxXQUFXLEVBQUUsSUFBSTtNQUNqQixTQUFTLEVBQUUsRUFBRTtNQUNiLE9BQU8sRUFBRSxLQUFLLENBQUM7SUFDakIsQ0FBQyxDQUFDO0lBQ0YsVUFBVSxDQUFDLEVBQUUsR0FBRyxLQUFLLENBQUMsT0FBTztJQUM3QixVQUFVLENBQUMsS0FBSyxHQUFHLEtBQUs7SUFDeEIsT0FBTyxVQUFVO0VBQ25COztFQUVBO0VBQ0EsVUFBVSxDQUFDLElBQUksR0FBRyxJQUFBLCtCQUF5QixFQUFDO0lBQzFDLFNBQVMsRUFBRSxFQUFFO0lBQ2IsTUFBTSxFQUFFLFVBQVU7SUFDbEIsU0FBUyxFQUFFO0VBQ2IsQ0FBQyxDQUFDO0VBQ0YsVUFBVSxDQUFDLEVBQUUsR0FBRyxLQUFLLENBQUMsT0FBTztFQUM3QixVQUFVLENBQUMsS0FBSyxHQUFHLEtBQUs7RUFDeEIsT0FBTyxVQUFVO0FBQ25CLENBQUM7QUFBQyxPQUFBLENBQUEscUJBQUEsR0FBQSxxQkFBQTtBQUVLLE1BQU0sb0JBQW9CLEdBQUcsTUFBQSxDQUFPO0VBQ3pDLEtBQUs7RUFDTCxPQUFPO0VBQ1AsSUFBSTtFQUNKLE9BQU87RUFDUCxFQUFFO0VBQ0Y7QUFRRixDQUFDLEtBQUs7RUFDSixNQUFNLFVBQVUsR0FBRyxxQkFBcUIsQ0FBQyxLQUFLLEVBQUU7SUFBRSxJQUFJO0lBQUUsRUFBRTtJQUFFO0VBQU0sQ0FBQyxFQUFFLE9BQU8sQ0FBQztFQUM3RSxNQUFNLGVBQWUsR0FBRyxNQUFNLElBQUEscUNBQTRCLEVBQUMsT0FBTyxDQUFDO0VBRW5FLElBQUksZUFBZTtFQUNuQixJQUFJLEtBQUssQ0FBQyxRQUFRLEVBQUU7SUFDbEIsZUFBZSxHQUFHLHNDQUFlLENBQUMsVUFBVTtFQUM5QyxDQUFDLE1BQU0sSUFBSSxLQUFLLENBQUMsUUFBUSxLQUFLLHNCQUFLLEVBQUU7SUFDbkMsZUFBZSxHQUFHLHNDQUFlLENBQUMsbUJBQW1CO0VBQ3ZELENBQUMsTUFBTSxJQUFJLEtBQUssQ0FBQyxRQUFRLEtBQUssdUJBQU0sRUFBRTtJQUNwQyxlQUFlLEdBQUcsc0NBQWUsQ0FBQyx1QkFBdUI7RUFDM0QsQ0FBQyxNQUFNLElBQUksS0FBSyxDQUFDLFFBQVEsS0FBSyx3QkFBTyxFQUFFO0lBQ3JDLGVBQWUsR0FBRyxzQ0FBZSxDQUFDLDJCQUEyQjtFQUMvRDtFQUVBLE9BQU8sSUFBQSxpREFBd0MsRUFBQyxVQUFVLEVBQUU7SUFDMUQsZUFBZTtJQUNmLElBQUksRUFBRTtFQUNSLENBQUMsQ0FBQztBQUNKLENBQUM7QUFBQyxPQUFBLENBQUEsb0JBQUEsR0FBQSxvQkFBQTtBQUVLLE1BQU0sZ0JBQWdCLEdBQUcsTUFBQSxDQUFPO0VBQ3JDLEtBQUs7RUFDTCxPQUFPO0VBQ1AsSUFBSTtFQUNKO0FBTUYsQ0FBQyxLQUErQjtFQUM5QixPQUFRLE1BQU0sSUFBQSw2QkFBb0IsRUFBQztJQUNqQyxPQUFPO0lBQ1AsaUJBQWlCLEVBQUU7TUFDakIsS0FBSyxFQUFFLHFCQUFxQixDQUFDLEtBQUssRUFBRSxLQUFLLENBQUMsUUFBUSxDQUFDO01BQ25EO0lBQ0Y7RUFDRixDQUFDLENBQUM7QUFDSixDQUFDO0FBQUMsT0FBQSxDQUFBLGdCQUFBLEdBQUEsZ0JBQUE7QUFFSyxTQUFTLDRCQUE0QixDQUFDLEdBQVcsRUFBRTtFQUN4RCxNQUFNLFlBQVksR0FBRyx3QkFBd0I7RUFFN0MsSUFBSSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLEVBQUU7SUFDM0IsT0FBTyxLQUFLO0VBQ2Q7RUFFQSxJQUFJO0lBQ0YsTUFBTSxHQUFHLEdBQUcsSUFBSSxnQkFBTyxDQUFDLEdBQUcsRUFBRSxFQUFFLENBQUM7SUFDaEMsT0FBTyxHQUFHLENBQUMsb0JBQW9CLENBQUMsSUFBSSxnQkFBTyxDQUFDLEdBQUcsRUFBRSxFQUFFLENBQUMsQ0FBQztFQUN2RCxDQUFDLENBQUMsT0FBTyxHQUFHLEVBQUU7SUFDWixPQUFPLEtBQUs7RUFDZDtBQUNGO0FBRU8sU0FBUyxpQkFBaUIsQ0FDL0IsS0FBYSxFQUNiLGNBQXVCLEVBQ3ZCLFFBQTBCLEVBQzFCO0VBQ0EsSUFBSSxDQUFDLDRCQUE0QixDQUFDLEtBQUssQ0FBQyxFQUFFO0lBQ3hDLE9BQU8sU0FBUztFQUNsQjtFQUVBLE9BQU8saUJBQWlCLENBQ3RCLDZCQUE2QixDQUMzQixJQUFJLGdCQUFPLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDLG1CQUFtQixDQUFDLGNBQWMsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxDQUFDLEVBQ3JFLFFBQ0YsQ0FBQyxJQUFJLEVBQ1AsQ0FBQztBQUNIO0FBRU8sTUFBTSxtQkFBbUIsR0FBRyxDQUNqQyxPQUFzQyxFQUN0QyxxQkFBOEIsRUFDOUIsTUFHQyxLQUNFO0VBQ0gsSUFBSSxxQkFBcUIsRUFBRTtJQUN6QixJQUFJLE1BQU0sRUFBRTtNQUNWLE1BQU0sV0FBVyxHQUFHLElBQUksZUFBZSxDQUFDLENBQUM7TUFDekMsTUFBTTtRQUFFLE9BQU87UUFBRTtNQUFRLENBQUMsR0FBRyxNQUFNO01BQ25DLElBQUksT0FBTyxFQUFFO1FBQ1gsV0FBVyxDQUFDLE1BQU0sQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDO01BQ3RDO01BQ0EsSUFBSSxPQUFPLEVBQUU7UUFDWCxXQUFXLENBQUMsTUFBTSxDQUFDLFNBQVMsRUFBRSxPQUFPLENBQUM7TUFDeEM7TUFDQSxPQUFPLENBQUMsSUFBSSxDQUFDLEdBQUcsa0JBQVUscUJBQXFCLFdBQVcsQ0FBQyxRQUFRLENBQUMsQ0FBQyxFQUFFLENBQUM7SUFDMUUsQ0FBQyxNQUFNO01BQ0wsT0FBTyxDQUFDLElBQUksQ0FBQyxHQUFHLGtCQUFVLFFBQVEsQ0FBQztJQUNyQztFQUNGLENBQUMsTUFBTTtJQUNMLE9BQU8sQ0FBQyxJQUFJLENBQUMsa0JBQVUsQ0FBQztFQUMxQjtBQUNGLENBQUM7QUFBQyxPQUFBLENBQUEsbUJBQUEsR0FBQSxtQkFBQTtBQUVLLE1BQU0saUJBQWlCLEdBQUksS0FBYSxJQUFLO0VBQ2xELE1BQU0sTUFBTSxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUM7RUFDbEQsTUFBTSxRQUFRLEdBQUcsTUFBTSxDQUFDLENBQUMsQ0FBQyxJQUFJLEVBQUU7RUFDaEMsT0FBTyxRQUFRLENBQUMsTUFBTTtBQUN4QixDQUFDO0FBQUMsT0FBQSxDQUFBLGlCQUFBLEdBQUEsaUJBQUE7QUFFSyxNQUFNLHNCQUFzQixHQUFJLEtBQWMsSUFBSztFQUN4RCxJQUFJLENBQUMsS0FBSyxFQUFFO0lBQ1YsT0FBTyxLQUFLO0VBQ2Q7RUFDQSxNQUFNLE1BQU0sR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDO0VBQ2xELE1BQU0sU0FBUyxHQUFHLE1BQU0sQ0FBQyxDQUFDLENBQUM7RUFDM0IsTUFBTSxRQUFRLEdBQUcsTUFBTSxDQUFDLENBQUMsQ0FBQyxJQUFJLEVBQUU7RUFDaEMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxNQUFNLEVBQUU7SUFDckIsT0FBTyxLQUFLLFFBQVEsRUFBRTtFQUN4QjtFQUNBLE9BQU8sS0FBSztBQUNkLENBQUM7QUFBQyxPQUFBLENBQUEsc0JBQUEsR0FBQSxzQkFBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUMvVEYsSUFBQSxtQkFBQSxHQUFBLE9BQUE7QUFFQSxJQUFBLFNBQUEsR0FBQSxPQUFBO0FBSUEsSUFBQSxRQUFBLEdBQUEsT0FBQTtBQVRBO0FBQ0E7QUFDQTs7QUFVTyxNQUFNLDBCQUEwQixHQUNyQyxPQUFlLElBQ2U7RUFDOUIsTUFBTSxvQkFBb0IsR0FBRyxJQUFBLCtCQUFXLEVBQUMsT0FBTyxDQUc3Qzs7RUFFSDtFQUNBLE1BQU0sWUFBWSxHQUFHLElBQUksR0FBRyxDQUFTLENBQUM7RUFDdEMsTUFBTSxvQkFBb0IsR0FBRyxvQkFBb0IsQ0FDOUMsTUFBTSxDQUFDLENBQUM7SUFBRTtFQUFNLENBQUMsS0FBSztJQUNyQixJQUFJLFlBQVksQ0FBQyxHQUFHLENBQUMsS0FBSyxDQUFDLEVBQUU7TUFDM0IsT0FBTyxLQUFLO0lBQ2Q7SUFDQSxZQUFZLENBQUMsR0FBRyxDQUFDLEtBQUssQ0FBQztJQUN2QixPQUFPLElBQUk7RUFDYixDQUFDLENBQUMsQ0FDRCxNQUFNLENBQUMsQ0FBQztJQUFFO0VBQVUsQ0FBQyxLQUFLLFNBQVMsS0FBSyxTQUFTLENBQUM7RUFFckQsSUFBSSxvQkFBb0IsQ0FBQyxNQUFNLEVBQUU7SUFDL0IsTUFBTSxzQkFBc0IsR0FBRyxvQkFBb0IsQ0FBQyxJQUFJLENBQ3RELENBQUM7TUFBRTtJQUFVLENBQUMsS0FBSyxTQUFTLEtBQUssRUFDbkMsQ0FBQztJQUVELElBQUksc0JBQXNCLEVBQUU7TUFDMUIsT0FBTztRQUNMLEtBQUssRUFBRSxnQkFBZ0I7UUFDdkIsT0FBTyxFQUFFO01BQ1gsQ0FBQztJQUNIO0lBRUEsT0FBTztNQUNMO0lBQ0YsQ0FBQztFQUNIO0VBQ0EsT0FBTyxDQUFDLENBQUM7QUFDWCxDQUFDO0FBQUMsT0FBQSxDQUFBLDBCQUFBLEdBQUEsMEJBQUE7QUFFRixNQUFNLDBCQUEwQixHQUFHLENBQ2pDLDRDQUE0QyxFQUM1Qyw0Q0FBNEMsQ0FDN0M7QUFFTSxNQUFNLHFCQUFxQixHQUFHLE1BQUEsQ0FDbkMsT0FBZSxFQUNmLE9BQWdCLEVBQ2hCLFlBQXFCLEtBQ2xCO0VBQ0gsSUFBSSwwQkFBMEIsQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUMsRUFBRTtJQUM5RCxPQUFPO01BQ0wsS0FBSyxFQUFFO0lBQ1QsQ0FBQztFQUNIO0VBRUEsSUFBSSxDQUFBLE9BQU8sYUFBUCxPQUFPLHVCQUFQLE9BQU8sQ0FBRSxXQUFXLENBQUMsQ0FBQyxPQUFLLFlBQVksYUFBWixZQUFZLHVCQUFaLFlBQVksQ0FBRSxXQUFXLENBQUMsQ0FBQyxHQUFFO0lBQzFELE9BQU87TUFDTCxLQUFLLEVBQUU7SUFDVCxDQUFDO0VBQ0g7RUFFQSxJQUFJLE9BQU8sRUFBRTtJQUNYLE1BQU0sWUFBWSxHQUFHLE1BQU0sSUFBQSwwQ0FBaUMsRUFDMUQsT0FBTyxFQUNQLFNBQVMsRUFDVCxTQUFTLEVBQ1QsT0FDRixDQUFDO0lBQ0QsSUFBSSxZQUFZLGFBQVosWUFBWSxlQUFaLFlBQVksQ0FBRSxRQUFRLEVBQUU7TUFDMUIsT0FBTztRQUNMLEtBQUssRUFBRTtNQUNULENBQUM7SUFDSDtFQUNGO0VBRUEsT0FBTyxDQUFDLENBQUM7QUFDWCxDQUFDOztBQUVEO0FBQUEsT0FBQSxDQUFBLHFCQUFBLEdBQUEscUJBQUE7QUFDQSxNQUFNLHFCQUFxQixHQUFHLENBQzVCLDZDQUE2QyxFQUM3Qyw2Q0FBNkMsQ0FDOUM7QUFFTSxNQUFNLHFCQUFxQixHQUFJLE9BQWUsSUFBSztFQUN4RCxJQUFJLHFCQUFxQixDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsRUFBRTtJQUMzQyxPQUFPO01BQ0wsS0FBSyxFQUFFO0lBQ1QsQ0FBQztFQUNIO0VBRUEsSUFBSSxDQUFDLElBQUEseUJBQWUsRUFBQyxPQUFPLENBQUMsRUFBRTtJQUM3QixPQUFPO01BQ0wsS0FBSyxFQUFFO0lBQ1QsQ0FBQztFQUNIO0VBRUEsT0FBTyxDQUFDLENBQUM7QUFDWCxDQUFDO0FBQUMsT0FBQSxDQUFBLHFCQUFBLEdBQUEscUJBQUE7QUFFSyxNQUFNLGtCQUFrQixHQUFJLE9BQWUsSUFBSztFQUNyRCxJQUFJLENBQUMsSUFBQSw2QkFBbUIsRUFBQyxPQUFPLENBQUMsRUFBRTtJQUNqQyxPQUFPO01BQ0wsS0FBSyxFQUFFO0lBQ1QsQ0FBQztFQUNIO0VBRUEsT0FBTyxDQUFDLENBQUM7QUFDWCxDQUFDO0FBQUMsT0FBQSxDQUFBLGtCQUFBLEdBQUEsa0JBQUE7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDeEhGLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFHQSxJQUFBLFFBQUEsR0FBQSxPQUFBO0FBNEJPLE1BQU0sc0JBQXNCLEdBQUEsT0FBQSxDQUFBLHNCQUFBLEdBQUcsRUFBRTtBQUVqQyxNQUFNLHdCQUF3QixHQUNuQyxNQUFlLElBQ1E7RUFDdkIsSUFBSSxDQUFDLE1BQU0sRUFBRTtJQUNYLE9BQU8sU0FBUztFQUNsQjtFQUVBLEtBQUssTUFBTSxLQUFLLElBQUksQ0FBQyxFQUFFLEVBQUUsRUFBRSxDQUFDLEVBQUU7SUFDNUIsTUFBTSxTQUFTLEdBQUcsUUFBUSxDQUFDLE1BQU0sRUFBRSxLQUFLLENBQUM7SUFDekMsSUFBSSxRQUFRLENBQUMsU0FBUyxDQUFDLEVBQUU7TUFDdkIsT0FBTyxTQUFTO0lBQ2xCO0VBQ0Y7RUFDQSxPQUFPLFNBQVM7QUFDbEIsQ0FBQztBQUFDLE9BQUEsQ0FBQSx3QkFBQSxHQUFBLHdCQUFBO0FBRUssTUFBTSxrQ0FBa0MsR0FBQSxPQUFBLENBQUEsa0NBQUEsR0FBRyxJQUFBLGVBQU8sRUFDdkQsT0FDRSxZQUEyQixFQUMzQixXQUFvQixFQUNwQixPQUFnQixLQUNrQztFQUNsRCxJQUFJO0lBQ0YsSUFBSSxDQUFDLFlBQVksRUFBRTtNQUNqQixPQUFPLENBQUMsQ0FBQztJQUNYO0lBRUEsT0FBUSxNQUFNLElBQUEsbUNBQTBCLEVBQ3RDLFlBQVksRUFDWixXQUFXLEVBQ1gsT0FDRixDQUFDO0VBQ0gsQ0FBQyxDQUFDLE1BQU07SUFDTixPQUFPLENBQUMsQ0FBQztFQUNYO0FBQ0YsQ0FDRixDQUFDOztBQUVEO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTyxNQUFNLGtCQUFrQixHQUFHLE1BQUEsQ0FDaEMsT0FBcUIsRUFDckIsT0FBc0IsS0FDRjtFQUNwQixJQUFJO0lBQ0YsTUFBTSxNQUFNLEdBQUksTUFBTSxJQUFBLDBDQUFpQyxFQUNyRCxPQUFPLEVBQ1AsU0FBUyxFQUNULFNBQVMsRUFDVCxPQUNGLENBQXVCO0lBQ3ZCLE1BQU07TUFBRSxRQUFRLEVBQUU7SUFBTyxDQUFDLEdBQUcsTUFBTTtJQUNuQyxNQUFNLFFBQVEsR0FBRyx3QkFBd0IsQ0FBQyxNQUFNLENBQUM7SUFFakQsT0FBTyxRQUFRLElBQUksc0JBQXNCO0VBQzNDLENBQUMsQ0FBQyxNQUFNO0lBQ04sT0FBTyxzQkFBc0I7RUFDL0I7QUFDRixDQUFDO0FBQUMsT0FBQSxDQUFBLGtCQUFBLEdBQUEsa0JBQUE7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDakdGLElBQUEsVUFBQSxHQUFBLHNCQUFBLENBQUEsT0FBQTtBQUNBLElBQUEsTUFBQSxHQUFBLHNCQUFBLENBQUEsT0FBQTtBQUNBLElBQUEsV0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFdBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxRQUFBLEdBQUEsc0JBQUEsQ0FBQSxPQUFBO0FBQ0EsSUFBQSxzQkFBQSxHQUFBLHNCQUFBLENBQUEsT0FBQTtBQUNBLElBQUEsNkJBQUEsR0FBQSxzQkFBQSxDQUFBLE9BQUE7QUFDQSxJQUFBLEtBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxlQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsZUFBQSxHQUFBLHNCQUFBLENBQUEsT0FBQTtBQUNBLElBQUEsYUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLGlCQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsVUFBQSxHQUFBLE9BQUE7QUFBc0QsU0FBQSx1QkFBQSxDQUFBLFdBQUEsQ0FBQSxJQUFBLENBQUEsQ0FBQSxVQUFBLEdBQUEsQ0FBQSxLQUFBLE9BQUEsRUFBQSxDQUFBO0FBRXZDLFNBQVMsaUJBQWlCLENBQUM7RUFDeEMsZ0JBQWdCLEdBQUcsSUFBSTtFQUN2QixlQUFlO0VBQ2Ysb0JBQW9CO0VBQ3BCLGNBQWM7RUFDZCxpQkFBaUI7RUFDakIsT0FBTztFQUNQLHNCQUFzQjtFQUN0QixXQUFXLEdBQUcsU0FBUztFQUN2QixlQUFlO0VBQ2Ysc0JBQXNCO0VBQ3RCLGtCQUFrQjtFQUNsQixlQUFlO0VBQ2YsaUJBQWlCO0VBQ2pCO0FBQ0YsQ0FBQyxFQUFFO0VBQUEsSUFBQSxxQkFBQSxFQUFBLHNCQUFBLEVBQUEsc0JBQUE7RUFDRCxNQUFNLENBQUMsR0FBRyxJQUFBLDhCQUFjLEVBQUMsQ0FBQztFQUMxQixNQUFNLGdCQUFnQixHQUFHLElBQUEsdUJBQVcsRUFBQyw4QkFBbUIsQ0FBQztFQUN6RCxNQUFNLHlCQUF5QixHQUFHLGVBQWUsQ0FBQyxpQkFBaUIsQ0FBQztFQUNwRSxNQUFNLGVBQWUsR0FDbkIsRUFBQSxxQkFBQSxHQUFBLGtCQUFrQixDQUFDLGlCQUFpQixDQUFDLGNBQUEscUJBQUEsdUJBQXJDLHFCQUFBLENBQXVDLE1BQU0sT0FDM0MseUJBQXlCLGFBQXpCLHlCQUF5Qix1QkFBekIseUJBQXlCLENBQUUsTUFBTSxPQUFBLHNCQUFBLEdBQ25DLGtCQUFrQixDQUFDLGlCQUFpQixDQUFDLGNBQUEsc0JBQUEsdUJBQXJDLHNCQUFBLENBQXVDLFdBQVcsQ0FDaEQsc0NBQTBCLENBQzNCO0VBRUgsTUFBTSxjQUFjLEdBQ2xCLGVBQWUsSUFDZixNQUFNLENBQUMsSUFBSSxFQUFBLHNCQUFBLEdBQ1Qsa0JBQWtCLENBQUMsaUJBQWlCLENBQUMsY0FBQSxzQkFBQSxnQkFBQSxzQkFBQSxHQUFyQyxzQkFBQSxDQUF1QyxXQUFXLGNBQUEsc0JBQUEsZ0JBQUEsc0JBQUEsR0FBbEQsc0JBQUEsQ0FBb0QsV0FBVyxjQUFBLHNCQUFBLGdCQUFBLHNCQUFBLEdBQS9ELHNCQUFBLENBQ0ksT0FBTyxDQUFDLENBQUMsQ0FBQyxjQUFBLHNCQUFBLHVCQURkLHNCQUFBLENBQ2dCLEtBQ2xCLENBQUM7RUFDSCxNQUFNLHNCQUFzQixHQUMxQixlQUFlLEtBQUksY0FBYyxhQUFkLGNBQWMsdUJBQWQsY0FBYyxDQUFFLEdBQUcsQ0FBRSxHQUFHLElBQUssZUFBZSxDQUFDLEdBQUcsQ0FBQyxDQUFDO0VBRXZFLE1BQU0sNEJBQTRCLEdBQ2hDLGlCQUFpQixDQUFDLE1BQU0sR0FBRyxDQUFDLEdBQ3hCLENBQUMsQ0FBQyxvQ0FBb0MsRUFBRSxDQUFDLGlCQUFpQixDQUFDLE1BQU0sQ0FBQyxDQUFDLEdBQ25FLENBQUMsQ0FBQyxzQ0FBc0MsQ0FBQztFQUUvQyxJQUFJLFFBQVE7RUFDWixJQUFJLGlCQUFpQixDQUFDLE1BQU0sSUFBSSxDQUFDLGVBQWUsRUFBRTtJQUNoRCxRQUFRLEdBQUcsNEJBQTRCO0VBQ3pDLENBQUMsTUFBTSxJQUFJLGVBQWUsSUFBSSxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRTtJQUN2RCxRQUFRLEdBQUcsQ0FBQyxDQUFDLHNDQUFzQyxDQUFDO0VBQ3RELENBQUMsTUFBTSxJQUFJLGlCQUFpQixJQUFJLGVBQWUsRUFBRTtJQUMvQyxRQUFRLEdBQUcsSUFBSTtFQUNqQixDQUFDLE1BQU07SUFDTCxRQUFRLEdBQUcsQ0FBQyxDQUFDLG1DQUFtQyxDQUFDO0VBQ25EO0VBRUEsb0JBQ0UsTUFBQSxDQUFBLE9BQUEsQ0FBQSxhQUFBLENBQUMsUUFBQSxDQUFBLE9BQU87SUFDTixLQUFLLEVBQ0gsb0JBQW9CLEdBQ2hCLENBQUMsQ0FBQyxrQkFBa0IsQ0FBQyxHQUNyQixJQUFBLGdCQUFVLEVBQUMsZUFBZSxDQUMvQjtJQUNELFdBQVcsRUFBRTtNQUNYLFdBQVcsRUFBRSxDQUFDO01BQ2QsWUFBWSxFQUFFO0lBQ2hCLENBQUU7SUFDRixRQUFRLEVBQUUsUUFBUztJQUNuQixPQUFPLEVBQUUsQ0FBQSxLQUFNLE9BQU8sQ0FBQyxJQUFJLENBQUMsc0JBQXNCLENBQUU7SUFDcEQsZUFBZSxFQUFDLDRCQUE0QjtJQUM1Qyw0QkFBNEIsRUFBRSxDQUFDLENBQUU7SUFDakMsTUFBTSxFQUNKLGlCQUFpQixDQUFDLE1BQU0sR0FBRyxDQUFDO0lBQUE7SUFBTTtJQUNoQyxNQUFBLENBQUEsT0FBQSxDQUFBLGFBQUEsQ0FBQyw2QkFBQSxDQUFBLE9BQTRCO01BQUMsV0FBVyxFQUFFO0lBQVksQ0FBRTtFQUU1RCxnQkFFRCxNQUFBLENBQUEsT0FBQSxDQUFBLGFBQUEsQ0FBQyxpQkFBQSxDQUFBLEdBQUcsUUFDRCxpQkFBaUIsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxnQkFDM0IsTUFBQSxDQUFBLE9BQUEsQ0FBQSxhQUFBLENBQUMsaUJBQUEsQ0FBQSxHQUFHO0lBQUMsVUFBVSxFQUFFO0VBQUUsZ0JBQ2pCLE1BQUEsQ0FBQSxPQUFBLENBQUEsYUFBQSxDQUFDLGlCQUFBLENBQUEsSUFBSTtJQUNILE9BQU8sRUFBRSx5QkFBVyxDQUFDLFlBQWE7SUFDbEMsS0FBSyxFQUFFLHVCQUFTLENBQUM7RUFBZ0IsR0FFaEMsQ0FBQyxDQUFDLG1CQUFtQixDQUFDLEVBQUMsT0FBTyxFQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBQyxHQUNyRCxDQUNILENBQUMsR0FDSixJQUFJLGVBRVIsTUFBQSxDQUFBLE9BQUEsQ0FBQSxhQUFBLENBQUMsc0JBQUEsQ0FBQSxPQUFxQjtJQUNwQixnQkFBZ0IsRUFBRSxnQkFBaUI7SUFDbkMsY0FBYyxFQUFFLGNBQWU7SUFDL0IsaUJBQWlCLEVBQUUsaUJBQWtCO0lBQ3JDLGVBQWUsRUFBRSxlQUFnQjtJQUNqQyxzQkFBc0IsRUFBRSxzQkFBdUI7SUFDL0Msa0JBQWtCLEVBQUcsT0FBTyxJQUFLO01BQy9CLE1BQU07UUFBRSxFQUFFLEVBQUU7TUFBVSxDQUFDLEdBQUcsZ0JBQWdCLENBQUMsSUFBSSxDQUM1QyxlQUFlLElBQUssZUFBZSxDQUFDLE9BQU8sS0FBSyxPQUNuRCxDQUFDO01BQ0Qsa0JBQWtCLENBQUMsU0FBUyxDQUFDO0lBQy9CLENBQUU7SUFDRix1QkFBdUI7RUFBQSxDQUN4QixDQUNFLENBQUMsRUFDTCxlQUFlLElBQUksc0JBQXNCLENBQUMsTUFBTSxHQUFHLENBQUMsaUJBQ25ELE1BQUEsQ0FBQSxPQUFBLENBQUEsYUFBQSxDQUFBLE1BQUEsQ0FBQSxPQUFBLENBQUEsUUFBQSxxQkFDRSxNQUFBLENBQUEsT0FBQSxDQUFBLGFBQUEsQ0FBQyxpQkFBQSxDQUFBLEdBQUc7SUFBQyxVQUFVLEVBQUU7RUFBRSxnQkFDakIsTUFBQSxDQUFBLE9BQUEsQ0FBQSxhQUFBLENBQUMsaUJBQUEsQ0FBQSxJQUFJO0lBQ0gsT0FBTyxFQUFFLHlCQUFXLENBQUMsWUFBYTtJQUNsQyxLQUFLLEVBQUUsdUJBQVMsQ0FBQztFQUFnQixHQUVoQyxDQUFDLENBQUMsZ0JBQWdCLENBQUMsRUFBQyxPQUFPLEVBQUMsY0FBYyxDQUFDLE1BQU0sRUFBQyxHQUMvQyxDQUNILENBQUMsZUFDTixNQUFBLENBQUEsT0FBQSxDQUFBLGFBQUEsQ0FBQyxlQUFBLENBQUEsT0FBYztJQUFDLGlCQUFpQixFQUFFO0VBQXVCLENBQUUsQ0FDNUQsQ0FFRyxDQUFDO0FBRWQ7QUFFQSxpQkFBaUIsQ0FBQyxTQUFTLEdBQUc7RUFDNUIsZ0JBQWdCLEVBQUUsa0JBQVMsQ0FBQyxNQUFNO0VBQ2xDLGVBQWUsRUFBRSxrQkFBUyxDQUFDLE1BQU0sQ0FBQyxVQUFVO0VBQzVDLGNBQWMsRUFBRSxrQkFBUyxDQUFDLElBQUksQ0FBQyxVQUFVO0VBQ3pDLGlCQUFpQixFQUFFLGtCQUFTLENBQUMsS0FBSyxDQUFDLFVBQVU7RUFDN0Msc0JBQXNCLEVBQUUsa0JBQVMsQ0FBQyxNQUFNLENBQUMsVUFBVTtFQUNuRCxXQUFXLEVBQUUsa0JBQVMsQ0FBQyxLQUFLO0VBQzVCLG9CQUFvQixFQUFFLGtCQUFTLENBQUMsSUFBSSxDQUFDLFVBQVU7RUFDL0MsZUFBZSxFQUFFLGtCQUFTLENBQUMsTUFBTSxDQUFDLFVBQVU7RUFDNUMsc0JBQXNCLEVBQUUsa0JBQVMsQ0FBQyxJQUFJLENBQUMsVUFBVTtFQUNqRCxrQkFBa0IsRUFBRSxrQkFBUyxDQUFDLElBQUksQ0FBQyxVQUFVO0VBQzdDLE9BQU8sRUFBRSxrQkFBUyxDQUFDLE1BQU0sQ0FBQyxVQUFVO0VBQ3BDLGVBQWUsRUFBRSxrQkFBUyxDQUFDLE9BQU8sQ0FBQyxrQkFBUyxDQUFDLE1BQU0sQ0FBQyxDQUFDLFVBQVU7RUFDL0QsaUJBQWlCLEVBQUUsa0JBQVMsQ0FBQyxNQUFNO0VBQ25DLGtCQUFrQixFQUFFLGtCQUFTLENBQUM7QUFDaEMsQ0FBQzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNqSkQsSUFBQSxXQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsVUFBQSxHQUFBLE9BQUE7QUFVQSxJQUFBLEtBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxRQUFBLEdBQUEsT0FBQTtBQUtBLElBQUEsUUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLGtCQUFBLEdBQUEsc0JBQUEsQ0FBQSxPQUFBO0FBQStELFNBQUEsdUJBQUEsQ0FBQSxXQUFBLENBQUEsSUFBQSxDQUFBLENBQUEsVUFBQSxHQUFBLENBQUEsS0FBQSxPQUFBLEVBQUEsQ0FBQTtBQUUvRCxNQUFNLGVBQWUsR0FBSSxLQUFLLElBQUs7RUFBQSxJQUFBLHFCQUFBO0VBQ2pDLE1BQU07SUFBRTtFQUFVLENBQUMsR0FBRyxLQUFLO0VBQzNCLE1BQU0sZ0JBQWdCLEdBQUcsSUFBQSx5Q0FBOEIsRUFBQyxLQUFLLENBQUM7RUFDOUQsTUFBTSxpQkFBaUIsR0FBRyxJQUFBLGtEQUF1QyxFQUFDLEtBQUssQ0FBQztFQUN4RSxNQUFNLGdCQUFnQixHQUFHLElBQUEsOEJBQW1CLEVBQUMsS0FBSyxDQUFDO0VBQ25EO0VBQ0EsTUFBTSxtQkFBbUIsR0FBRyxJQUFJLEdBQUcsQ0FDakMsZ0JBQWdCLENBQUMsR0FBRyxDQUFFLEdBQUcsSUFBSyxDQUFDLEdBQUcsQ0FBQyxPQUFPLEVBQUUsR0FBRyxDQUFDLENBQ2xELENBQUM7RUFFRCxNQUFNLHlCQUF5QixHQUFHLGlCQUFpQixDQUFDLEdBQUcsQ0FBRSxPQUFPO0lBQUEsSUFBQSxxQkFBQTtJQUFBLE9BQU07TUFDcEUsR0FBRyxPQUFPO01BQ1YsSUFBSSxHQUFBLHFCQUFBLEdBQUUsbUJBQW1CLENBQUMsR0FBRyxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsY0FBQSxxQkFBQSx1QkFBeEMscUJBQUEsQ0FBMEMsUUFBUSxDQUFDO0lBQzNELENBQUM7RUFBQSxDQUFDLENBQUM7RUFDSCxNQUFNLHdCQUF3QixHQUFHLGdCQUFnQixJQUFJO0lBQ25ELEdBQUcsZ0JBQWdCO0lBQ25CLElBQUksR0FBQSxxQkFBQSxHQUFFLGdCQUFnQixDQUFDLElBQUksQ0FDeEIsZUFBZSxJQUNkLGVBQWUsQ0FBQyxPQUFPLE1BQUssZ0JBQWdCLGFBQWhCLGdCQUFnQix1QkFBaEIsZ0JBQWdCLENBQUUsT0FBTyxDQUN6RCxDQUFDLGNBQUEscUJBQUEsdUJBSEsscUJBQUEsQ0FHSCxRQUFRLENBQUM7RUFDZCxDQUFDO0VBQ0QsTUFBTSxXQUFXLEdBQUcsSUFBQSxxQ0FBMEIsRUFBQyxLQUFLLENBQUM7RUFDckQsTUFBTTtJQUFFLE9BQU8sRUFBRTtFQUFnQixDQUFDLEdBQUcsSUFBQSxxQ0FBMEIsRUFBQyxLQUFLLENBQUM7RUFDdEUsTUFBTSxlQUFlLEdBQUcsSUFBQSw2QkFBa0IsRUFBQyxLQUFLLENBQUM7RUFDakQsTUFBTSxpQkFBaUIsR0FBRyxJQUFBLGdDQUFxQixFQUFDLEtBQUssQ0FBQztFQUN0RCxNQUFNLGtCQUFrQixHQUFHLElBQUEsZ0NBQXFCLEVBQUMsS0FBSyxDQUFDO0VBRXZELE1BQU0sb0JBQW9CLEdBQUcsSUFBQSxvQkFBYyxFQUFDLFNBQVMsQ0FBQztFQUN0RCxPQUFPO0lBQ0wsZ0JBQWdCLEVBQUUsd0JBQXdCO0lBQzFDLG9CQUFvQjtJQUNwQixlQUFlLEVBQUUsU0FBUyxDQUFDLE1BQU07SUFDakMsaUJBQWlCLEVBQUUseUJBQXlCO0lBQzVDLHNCQUFzQixFQUFFLElBQUEsa0NBQXlCLEVBQUMsS0FBSyxDQUFDO0lBQ3hELFdBQVc7SUFDWCxlQUFlO0lBQ2YsZUFBZTtJQUNmLGlCQUFpQjtJQUNqQjtFQUNGLENBQUM7QUFDSCxDQUFDO0FBRUQsTUFBTSxrQkFBa0IsR0FBSSxRQUFRLElBQUs7RUFDdkMsT0FBTztJQUNMLG1CQUFtQixFQUFFLENBQUMsTUFBTSxFQUFFLE9BQU8sS0FDbkMsUUFBUSxDQUFDLElBQUEsNEJBQW1CLEVBQUMsTUFBTSxFQUFFLE9BQU8sQ0FBQyxDQUFDO0lBQ2hELHNCQUFzQixFQUFFLENBQUMsTUFBTSxFQUFFLE9BQU8sS0FDdEMsUUFBUSxDQUFDLElBQUEsK0JBQXNCLEVBQUMsTUFBTSxFQUFFLE9BQU8sQ0FBQyxDQUFDO0lBQ25ELGtCQUFrQixFQUFHLFNBQVMsSUFDNUIsUUFBUSxDQUFDLElBQUEsbUNBQTBCLEVBQUMsU0FBUyxDQUFDO0VBQ2xELENBQUM7QUFDSCxDQUFDO0FBRUQsTUFBTSxVQUFVLEdBQUcsQ0FBQyxVQUFVLEVBQUUsYUFBYSxFQUFFLFFBQVEsS0FBSztFQUMxRCxNQUFNO0lBQUU7RUFBZ0IsQ0FBQyxHQUFHLFVBQVU7RUFFdEMsT0FBTztJQUNMLEdBQUcsUUFBUTtJQUNYLEdBQUcsVUFBVTtJQUNiLEdBQUcsYUFBYTtJQUNoQixjQUFjLEVBQUcsT0FBTyxJQUN0QixhQUFhLENBQUMsbUJBQW1CLENBQUMsZUFBZSxFQUFFLE9BQU8sQ0FBQztJQUM3RCxzQkFBc0IsRUFBRyxPQUFPLElBQzlCLGFBQWEsQ0FBQyxzQkFBc0IsQ0FBQyxlQUFlLEVBQUUsT0FBTztFQUNqRSxDQUFDO0FBQ0gsQ0FBQztBQUFDLElBQUEsUUFBQSxHQUFBLE9BQUEsQ0FBQSxPQUFBLEdBRWEsSUFBQSxtQkFBTyxFQUNwQixlQUFlLEVBQ2Ysa0JBQWtCLEVBQ2xCLFVBQ0YsQ0FBQyxDQUFDLDBCQUFpQixDQUFDOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDM0ZwQixJQUFBLGtCQUFBLEdBQUEsc0JBQUEsQ0FBQSxPQUFBO0FBQXlELFNBQUEsdUJBQUEsQ0FBQSxXQUFBLENBQUEsSUFBQSxDQUFBLENBQUEsVUFBQSxHQUFBLENBQUEsS0FBQSxPQUFBLEVBQUEsQ0FBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNBekQsSUFBQSxVQUFBLEdBQUEsc0JBQUEsQ0FBQSxPQUFBO0FBQ0EsSUFBQSxNQUFBLEdBQUEsdUJBQUEsQ0FBQSxPQUFBO0FBQ0EsSUFBQSxtQkFBQSxHQUFBLHNCQUFBLENBQUEsT0FBQTtBQUNBLElBQUEsUUFBQSxHQUFBLHNCQUFBLENBQUEsT0FBQTtBQUNBLElBQUEsaUJBQUEsR0FBQSxPQUFBO0FBQTJFLFNBQUEseUJBQUEsQ0FBQSw2QkFBQSxPQUFBLG1CQUFBLENBQUEsT0FBQSxPQUFBLElBQUEsQ0FBQSxPQUFBLE9BQUEsWUFBQSx3QkFBQSxZQUFBLENBQUEsQ0FBQSxXQUFBLENBQUEsR0FBQSxDQUFBLEdBQUEsQ0FBQSxLQUFBLENBQUE7QUFBQSxTQUFBLHdCQUFBLENBQUEsRUFBQSxDQUFBLFNBQUEsQ0FBQSxJQUFBLENBQUEsSUFBQSxDQUFBLENBQUEsVUFBQSxTQUFBLENBQUEsZUFBQSxDQUFBLHVCQUFBLENBQUEseUJBQUEsQ0FBQSxXQUFBLE9BQUEsRUFBQSxDQUFBLFFBQUEsQ0FBQSxHQUFBLHdCQUFBLENBQUEsQ0FBQSxPQUFBLENBQUEsSUFBQSxDQUFBLENBQUEsR0FBQSxDQUFBLENBQUEsVUFBQSxDQUFBLENBQUEsR0FBQSxDQUFBLENBQUEsT0FBQSxDQUFBLEtBQUEsU0FBQSxVQUFBLENBQUEsR0FBQSxNQUFBLENBQUEsY0FBQSxJQUFBLE1BQUEsQ0FBQSx3QkFBQSxXQUFBLENBQUEsSUFBQSxDQUFBLG9CQUFBLENBQUEsT0FBQSxjQUFBLENBQUEsSUFBQSxDQUFBLENBQUEsRUFBQSxDQUFBLFNBQUEsQ0FBQSxHQUFBLENBQUEsR0FBQSxNQUFBLENBQUEsd0JBQUEsQ0FBQSxDQUFBLEVBQUEsQ0FBQSxVQUFBLENBQUEsS0FBQSxDQUFBLENBQUEsR0FBQSxJQUFBLENBQUEsQ0FBQSxHQUFBLElBQUEsTUFBQSxDQUFBLGNBQUEsQ0FBQSxDQUFBLEVBQUEsQ0FBQSxFQUFBLENBQUEsSUFBQSxDQUFBLENBQUEsQ0FBQSxJQUFBLENBQUEsQ0FBQSxDQUFBLFlBQUEsQ0FBQSxDQUFBLE9BQUEsR0FBQSxDQUFBLEVBQUEsQ0FBQSxJQUFBLENBQUEsQ0FBQSxHQUFBLENBQUEsQ0FBQSxFQUFBLENBQUEsR0FBQSxDQUFBO0FBQUEsU0FBQSx1QkFBQSxDQUFBLFdBQUEsQ0FBQSxJQUFBLENBQUEsQ0FBQSxVQUFBLEdBQUEsQ0FBQSxLQUFBLE9BQUEsRUFBQSxDQUFBO0FBQUEsU0FBQSxnQkFBQSxDQUFBLEVBQUEsQ0FBQSxFQUFBLENBQUEsWUFBQSxDQUFBLEdBQUEsY0FBQSxDQUFBLENBQUEsTUFBQSxDQUFBLEdBQUEsTUFBQSxDQUFBLGNBQUEsQ0FBQSxDQUFBLEVBQUEsQ0FBQSxJQUFBLEtBQUEsRUFBQSxDQUFBLEVBQUEsVUFBQSxNQUFBLFlBQUEsTUFBQSxRQUFBLFVBQUEsQ0FBQSxDQUFBLENBQUEsSUFBQSxDQUFBLEVBQUEsQ0FBQTtBQUFBLFNBQUEsZUFBQSxDQUFBLFFBQUEsQ0FBQSxHQUFBLFlBQUEsQ0FBQSxDQUFBLHVDQUFBLENBQUEsR0FBQSxDQUFBLEdBQUEsQ0FBQTtBQUFBLFNBQUEsYUFBQSxDQUFBLEVBQUEsQ0FBQSwyQkFBQSxDQUFBLEtBQUEsQ0FBQSxTQUFBLENBQUEsTUFBQSxDQUFBLEdBQUEsQ0FBQSxDQUFBLE1BQUEsQ0FBQSxXQUFBLGtCQUFBLENBQUEsUUFBQSxDQUFBLEdBQUEsQ0FBQSxDQUFBLElBQUEsQ0FBQSxDQUFBLEVBQUEsQ0FBQSx1Q0FBQSxDQUFBLFNBQUEsQ0FBQSxZQUFBLFNBQUEseUVBQUEsQ0FBQSxHQUFBLE1BQUEsR0FBQSxNQUFBLEVBQUEsQ0FBQTtBQUU1RCxNQUFNLGNBQWMsU0FBUyxnQkFBUyxDQUFDO0VBQUEsWUFBQSxHQUFBLElBQUE7SUFBQSxTQUFBLElBQUE7SUFBQSxlQUFBLGdCQXVCNUM7TUFDTixxQkFBcUIsRUFBRTtJQUN6QixDQUFDO0lBQUEsZUFBQSwrQkFPdUIsVUFBVSxJQUFLO01BQ3JDLElBQUksQ0FBQyxRQUFRLENBQUM7UUFDWixxQkFBcUIsRUFBRTtVQUNyQjtRQUNGO01BQ0YsQ0FBQyxDQUFDO0lBQ0osQ0FBQztJQUFBLGVBQUEsaUNBRXdCLE1BQU07TUFDN0IsSUFBSSxDQUFDLFFBQVEsQ0FBQztRQUNaLHFCQUFxQixFQUFFO01BQ3pCLENBQUMsQ0FBQztJQUNKLENBQUM7SUFBQSxlQUFBLDRCQUVtQixNQUFNO01BQ3hCLE1BQU07UUFBRTtNQUFrQixDQUFDLEdBQUcsSUFBSSxDQUFDLEtBQUs7TUFDeEMsTUFBTTtRQUFFO01BQXNCLENBQUMsR0FBRyxJQUFJLENBQUMsS0FBSztNQUU1QyxpQkFBaUIsQ0FBQyxxQkFBcUIsQ0FBQyxVQUFVLENBQUM7TUFDbkQsSUFBSSxDQUFDLHNCQUFzQixDQUFDLENBQUM7SUFDL0IsQ0FBQztJQUFBLGVBQUEsZ0NBRXVCLE1BQU07TUFDNUIsTUFBTTtRQUFFO01BQXNCLENBQUMsR0FBRyxJQUFJLENBQUMsS0FBSztNQUM1QyxNQUFNO1FBQUU7TUFBc0IsQ0FBQyxHQUFHLElBQUksQ0FBQyxLQUFLO01BRTVDLHFCQUFxQixDQUFDLHFCQUFxQixDQUFDLFVBQVUsQ0FBQztNQUN2RCxJQUFJLENBQUMsc0JBQXNCLENBQUMsQ0FBQztJQUMvQixDQUFDO0VBQUE7RUFqQ0QsaUJBQWlCLENBQUEsRUFBRztJQUNsQixNQUFNO01BQUU7SUFBdUIsQ0FBQyxHQUFHLElBQUksQ0FBQyxLQUFLO0lBQzdDLHNCQUFzQixDQUFDLENBQUM7RUFDMUI7RUFnQ0Esd0JBQXdCLENBQUEsRUFBRztJQUN6QixvQkFDRSxNQUFBLENBQUEsT0FBQSxDQUFBLGFBQUEsQ0FBQyxtQkFBQSxDQUFBLE9BQWtCO01BQ2pCLGlCQUFpQixFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsaUJBQWtCO01BQ2hELFlBQVksRUFBRSxJQUFJLENBQUM7SUFBcUIsQ0FDekMsQ0FBQztFQUVOO0VBRUEsMkJBQTJCLENBQUEsRUFBRztJQUM1QixNQUFNO01BQ0osWUFBWTtNQUNaLFlBQVk7TUFDWixpQkFBaUI7TUFDakIsWUFBWTtNQUNaO0lBQ0YsQ0FBQyxHQUFHLElBQUksQ0FBQyxLQUFLO0lBQ2QsTUFBTTtNQUFFO0lBQUUsQ0FBQyxHQUFHLElBQUksQ0FBQyxPQUFPO0lBRTFCLG9CQUNFLE1BQUEsQ0FBQSxPQUFBLENBQUEsYUFBQSxDQUFDLFFBQUEsQ0FBQSxPQUFPO01BQ04sU0FBUyxFQUFDLGlCQUFpQjtNQUMzQixLQUFLLEVBQUUsQ0FBQyxDQUFDLGdCQUFnQixDQUFFO01BQzNCLFFBQVEsRUFDTixpQkFBaUIsQ0FBQyxNQUFNLEdBQ3BCLENBQUMsQ0FBQywyQkFBMkIsRUFBRSxDQUFDLFlBQVksQ0FBQyxDQUFDLEdBQzlDLENBQUMsQ0FBQyxnQ0FBZ0MsRUFBRSxDQUFDLFlBQVksQ0FBQyxDQUN2RDtNQUNELE9BQU8sRUFBRSxZQUFhO01BQ3RCLE1BQU0sRUFDSixZQUFZLGdCQUNWLE1BQUEsQ0FBQSxPQUFBLENBQUEsYUFBQTtRQUNFLFNBQVMsRUFBQyw4QkFBOEI7UUFDeEMsT0FBTyxFQUFFO01BQTBCLEdBRWxDLENBQUMsQ0FBQyxpQkFBaUIsQ0FDbkIsQ0FBQyxHQUNGLElBQ0w7TUFDRCxlQUFlLEVBQUM7SUFBb0MsR