LavaPack.loadBundle([
["D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\multichain-accounts-connect-page\\multichain-accounts-connect-page.tsx", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../shared/lib/caip25-caveat-merger":"D:\\code\\v\\metamask-extension\\shared\\lib\\caip25-caveat-merger.ts","../../../../shared/lib/multichain/scope-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\multichain\\scope-utils.ts","../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/multichain-accounts/multichain-account-cell":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-account-cell\\index.ts","../../../components/multichain-accounts/multichain-site-cell/multichain-site-cell":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-site-cell\\multichain-site-cell.tsx","../../../components/multichain-accounts/permissions/multichain-edit-accounts-page/multichain-edit-accounts-page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\permissions\\multichain-edit-accounts-page\\multichain-edit-accounts-page.tsx","../../../components/multichain/pages/page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\index.ts","../../../components/ui/tabs":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tabs\\index.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../hooks/useAccountGroupsForPermissions":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAccountGroupsForPermissions.ts","../../../hooks/useFormatters":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useFormatters.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../hooks/useOriginTrustSignals":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useOriginTrustSignals.ts","../../../hooks/useTrustSignals":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTrustSignals.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/assets":"D:\\code\\v\\metamask-extension\\ui\\selectors\\assets.ts","../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../permissions-connect/connect-page/utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\connect-page\\utils.ts","@metamask/chain-agnostic-permission":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\chain-agnostic-permission\\dist\\index.cjs","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-tippy":"D:\\code\\v\\metamask-extension\\node_modules\\react-tippy\\dist\\react-tippy.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cmultichain-accounts%5Cmultichain-accounts-connect-page%5Cmultichain-accounts-connect-page.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultichainAccountsConnectPageMode = exports.MultichainAccountsConnectPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _chainAgnosticPermission = require("@metamask/chain-agnostic-permission");
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
var _designSystemReact = require("@metamask/design-system-react");
var _reactTippy = require("react-tippy");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _selectors = require("../../../selectors");
var _networks = require("../../../../shared/modules/selectors/networks");
var _componentLibrary = require("../../../components/component-library");
var _page = require("../../../components/multichain/pages/page");
var _designSystem = require("../../../helpers/constants/design-system");
var _network = require("../../../../shared/constants/network");
var _tabs = require("../../../components/ui/tabs");
var _util = require("../../../helpers/utils/util");
var _metametrics = require("../../../../shared/constants/metametrics");
var _metametrics2 = require("../../../contexts/metametrics");
var _caip25CaveatMerger = require("../../../../shared/lib/caip25-caveat-merger");
var _multichainAccountCell = require("../../../components/multichain-accounts/multichain-account-cell");
var _useAccountGroupsForPermissions = require("../../../hooks/useAccountGroupsForPermissions");
var _utils2 = require("../../permissions-connect/connect-page/utils");
var _multichainSiteCell = require("../../../components/multichain-accounts/multichain-site-cell/multichain-site-cell");
var _multichainEditAccountsPage = require("../../../components/multichain-accounts/permissions/multichain-edit-accounts-page/multichain-edit-accounts-page");
var _scopeUtils = require("../../../../shared/lib/multichain/scope-utils");
var _assets = require("../../../selectors/assets");
var _useFormatters = require("../../../hooks/useFormatters");
var _multichain = require("../../../selectors/multichain");
var _useTrustSignals = require("../../../hooks/useTrustSignals");
var _useOriginTrustSignals = require("../../../hooks/useOriginTrustSignals");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
let MultichainAccountsConnectPageMode = exports.MultichainAccountsConnectPageMode = /*#__PURE__*/function (MultichainAccountsConnectPageMode) {
  MultichainAccountsConnectPageMode["Summary"] = "summary";
  MultichainAccountsConnectPageMode["EditAccounts"] = "edit-accounts";
  return MultichainAccountsConnectPageMode;
}({});
const MultichainAccountsConnectPage = ({
  request,
  permissionsRequestId,
  rejectPermissionsRequest,
  approveConnection,
  targetSubjectMetadata
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const [pageMode, setPageMode] = (0, _react.useState)(MultichainAccountsConnectPageMode.Summary);
  const {
    isEip1193Request
  } = request.metadata ?? {};
  const {
    formatCurrencyWithMinThreshold
  } = (0, _useFormatters.useFormatters)();
  const allBalances = (0, _reactRedux.useSelector)(_assets.selectBalanceForAllWallets);
  const wallets = allBalances === null || allBalances === void 0 ? void 0 : allBalances.wallets;
  const existingPermissions = (0, _reactRedux.useSelector)(state => {
    var _request$metadata;
    return (0, _selectors.getPermissions)(state, (_request$metadata = request.metadata) === null || _request$metadata === void 0 ? void 0 : _request$metadata.origin);
  });
  const existingCaip25CaveatValue = (0, _react.useMemo)(() => existingPermissions ? (0, _utils2.getCaip25CaveatValueFromPermissions)(existingPermissions) : {
    requiredScopes: {},
    optionalScopes: {},
    sessionProperties: {},
    isMultichainOrigin: true
  }, [existingPermissions]);
  const requestedCaip25CaveatValue = (0, _react.useMemo)(() => (0, _utils2.getCaip25CaveatValueFromPermissions)(request.permissions), [request.permissions]);
  const requestedCaip25CaveatValueWithExistingPermissions = (0, _react.useMemo)(() => existingCaip25CaveatValue ? (0, _caip25CaveatMerger.mergeCaip25CaveatValues)(requestedCaip25CaveatValue, existingCaip25CaveatValue) : requestedCaip25CaveatValue, [existingCaip25CaveatValue, requestedCaip25CaveatValue]);
  const requestedCaipAccountIds = (0, _chainAgnosticPermission.getCaipAccountIdsFromCaip25CaveatValue)(requestedCaip25CaveatValue);
  const requestedNamespaces = (0, _react.useMemo)(() => (0, _chainAgnosticPermission.getAllNamespacesFromCaip25CaveatValue)(requestedCaip25CaveatValueWithExistingPermissions), [requestedCaip25CaveatValueWithExistingPermissions]);
  const requestedNamespacesWithoutWallet = (0, _react.useMemo)(() => requestedNamespaces.filter(namespace => namespace !== _utils.KnownCaipNamespace.Wallet), [requestedNamespaces]);
  const networkConfigurationsByCaipChainId = (0, _reactRedux.useSelector)(_networks.getAllNetworkConfigurationsByCaipChainId);
  const [nonTestNetworkConfigurations, testNetworkConfigurations] = (0, _react.useMemo)(() => Object.entries(networkConfigurationsByCaipChainId).reduce(([nonTestNetworksList, testNetworksList], [chainId, network]) => {
    const caipChainId = chainId;
    const isTestNetwork = _network.CAIP_FORMATTED_EVM_TEST_CHAINS.includes(caipChainId);
    (isTestNetwork ? testNetworksList : nonTestNetworksList).push({
      ...network,
      caipChainId
    });
    return [nonTestNetworksList, testNetworksList];
  }, [[], []]), [networkConfigurationsByCaipChainId]);
  const currentlySelectedNetwork = (0, _reactRedux.useSelector)(_multichain.getMultichainNetwork);
  const alreadyConnectedCaipChainIds = (0, _react.useMemo)(() => (0, _chainAgnosticPermission.getAllScopesFromCaip25CaveatValue)(existingCaip25CaveatValue), [existingCaip25CaveatValue]);
  const requestedCaipChainIds = (0, _react.useMemo)(() => (0, _chainAgnosticPermission.getAllScopesFromCaip25CaveatValue)(requestedCaip25CaveatValue).filter(chainId => {
    const {
      namespace
    } = (0, _utils.parseCaipChainId)(chainId);
    return namespace !== _utils.KnownCaipNamespace.Wallet;
  }), [requestedCaip25CaveatValue]);
  const requestedAndAlreadyConnectedCaipChainIdsOrDefault = (0, _react.useMemo)(() => {
    const allNetworksList = [...nonTestNetworkConfigurations, ...testNetworkConfigurations].map(({
      caipChainId
    }) => caipChainId);
    const walletRequest = requestedCaipChainIds.filter(caipChainId => (0, _utils.parseCaipChainId)(caipChainId).namespace === _utils.KnownCaipNamespace.Wallet).length > 0;
    let additionalChains = [];
    if (walletRequest && isEip1193Request) {
      additionalChains = nonTestNetworkConfigurations.map(({
        caipChainId
      }) => caipChainId).filter(caipChainId => requestedNamespacesWithoutWallet.includes((0, _utils.parseCaipChainId)(caipChainId).namespace));
    }
    const supportedRequestedCaipChainIds = Array.from(new Set([...requestedCaipChainIds.filter(requestedCaipChainId => allNetworksList.includes(requestedCaipChainId)), ...additionalChains]));

    // If globally selected network is a test network, include that in the default selected networks for connection request
    const currentlySelectedNetworkChainId = currentlySelectedNetwork.chainId;
    const selectedNetworkIsTestNetwork = testNetworkConfigurations.find(network => network.caipChainId === currentlySelectedNetworkChainId);
    const defaultSelectedNetworkList = selectedNetworkIsTestNetwork ? [...nonTestNetworkConfigurations, selectedNetworkIsTestNetwork].map(({
      caipChainId
    }) => caipChainId) : nonTestNetworkConfigurations.map(({
      caipChainId
    }) => caipChainId);
    if (supportedRequestedCaipChainIds.length > 0) {
      return Array.from(new Set([...supportedRequestedCaipChainIds, ...alreadyConnectedCaipChainIds]));
    }
    if (requestedNamespaces.length > 0) {
      return Array.from(new Set(defaultSelectedNetworkList.filter(caipChainId => {
        const {
          namespace
        } = (0, _utils.parseCaipChainId)(caipChainId);
        return requestedNamespaces.includes(namespace);
      })));
    }
    return defaultSelectedNetworkList;
  }, [nonTestNetworkConfigurations, testNetworkConfigurations, requestedCaipChainIds, isEip1193Request, currentlySelectedNetwork.chainId, requestedNamespaces, requestedNamespacesWithoutWallet, alreadyConnectedCaipChainIds]);
  const {
    connectedAccountGroups,
    supportedAccountGroups,
    connectedAccountGroupWithRequested,
    caipAccountIdsOfConnectedAndRequestedAccountGroups,
    selectedAndRequestedAccountGroups
  } = (0, _useAccountGroupsForPermissions.useAccountGroupsForPermissions)(existingCaip25CaveatValue, requestedCaipAccountIds, requestedAndAlreadyConnectedCaipChainIdsOrDefault, requestedNamespacesWithoutWallet);
  const [userHasModifiedSelection, setUserHasModifiedSelection] = (0, _react.useState)(false);
  const [selectedChainIds, setSelectedChainIds] = (0, _react.useState)(requestedAndAlreadyConnectedCaipChainIdsOrDefault);
  const handleChainIdsSelected = (0, _react.useCallback)((newSelectedChainIds, {
    isUserModified = true
  } = {}) => {
    if (isUserModified) {
      setUserHasModifiedSelection(true);
    }
    setSelectedChainIds(newSelectedChainIds);
  }, [setUserHasModifiedSelection, setSelectedChainIds]);
  const {
    suggestedAccountGroups,
    suggestedCaipAccountIds
  } = (0, _react.useMemo)(() => {
    if (connectedAccountGroups.length > 0) {
      return {
        suggestedAccountGroups: connectedAccountGroupWithRequested,
        suggestedCaipAccountIds: caipAccountIdsOfConnectedAndRequestedAccountGroups
      };
    }
    if (supportedAccountGroups.length === 0) {
      return {
        suggestedAccountGroups: [],
        suggestedCaipAccountIds: []
      };
    }
    if (requestedCaipAccountIds.length === 0) {
      const [defaultSelectedAccountGroup] = supportedAccountGroups;
      return {
        suggestedAccountGroups: [defaultSelectedAccountGroup],
        suggestedCaipAccountIds: (0, _scopeUtils.getCaip25AccountIdsFromAccountGroupAndScope)([defaultSelectedAccountGroup], requestedAndAlreadyConnectedCaipChainIdsOrDefault)
      };
    }
    return {
      suggestedAccountGroups: selectedAndRequestedAccountGroups,
      suggestedCaipAccountIds: (0, _scopeUtils.getCaip25AccountIdsFromAccountGroupAndScope)(selectedAndRequestedAccountGroups, requestedAndAlreadyConnectedCaipChainIdsOrDefault)
    };
  }, [connectedAccountGroups, supportedAccountGroups, requestedCaipAccountIds, selectedAndRequestedAccountGroups, connectedAccountGroupWithRequested, caipAccountIdsOfConnectedAndRequestedAccountGroups, requestedAndAlreadyConnectedCaipChainIdsOrDefault]);
  const [selectedAccountGroupIds, setSelectedAccountGroupIds] = (0, _react.useState)(suggestedAccountGroups.map(group => group.id));
  const [selectedCaipAccountIds, setSelectedCaipAccountIds] = (0, _react.useState)(suggestedCaipAccountIds);
  const handleAccountGroupIdsSelected = (0, _react.useCallback)((accountGroupIds, {
    isUserModified = true
  } = {}) => {
    if (isUserModified) {
      setUserHasModifiedSelection(true);
    }
    const updatedSelectedChains = [...selectedChainIds];

    // Create lookup sets for selected account group IDs
    const selectedGroupIds = new Set(accountGroupIds);

    // Filter to only selected account groups
    const selectedAccountGroups = supportedAccountGroups.filter(group => selectedGroupIds.has(group.id));
    const caip25AccountIds = (0, _scopeUtils.getCaip25AccountIdsFromAccountGroupAndScope)(selectedAccountGroups, updatedSelectedChains);
    handleChainIdsSelected(updatedSelectedChains, {
      isUserModified
    });
    setSelectedAccountGroupIds(accountGroupIds);
    setSelectedCaipAccountIds(caip25AccountIds);
    setPageMode(MultichainAccountsConnectPageMode.Summary);
  }, [selectedChainIds, supportedAccountGroups, handleChainIdsSelected]);

  // Ensures the selected account state is kept in sync with the default selected account value
  // until the user makes modifications to the selected account/network values.
  (0, _react.useEffect)(() => {
    const defaultAccountGroupIds = suggestedAccountGroups.map(group => group.id);
    if (!userHasModifiedSelection && !(0, _lodash.isEqual)(defaultAccountGroupIds, selectedAccountGroupIds)) {
      handleAccountGroupIdsSelected(defaultAccountGroupIds, {
        isUserModified: false
      });
    }
  }, [userHasModifiedSelection, handleAccountGroupIdsSelected, selectedAccountGroupIds, suggestedAccountGroups]);
  const setModeToEditAccounts = (0, _react.useCallback)(() => {
    trackEvent({
      category: _metametrics.MetaMetricsEventCategory.Navigation,
      event: _metametrics.MetaMetricsEventName.ViewPermissionedAccounts,
      properties: {
        location: 'Connect view (accounts tab), Permissions toast, Permissions (dapp)'
      }
    });
    setPageMode(MultichainAccountsConnectPageMode.EditAccounts);
  }, [trackEvent]);
  const handleCancelConnection = (0, _react.useCallback)(() => {
    rejectPermissionsRequest(permissionsRequestId);
  }, [permissionsRequestId, rejectPermissionsRequest]);
  const onConfirm = (0, _react.useCallback)(() => {
    const _request = {
      ...request,
      permissions: {
        ...request.permissions,
        ...(0, _chainAgnosticPermission.generateCaip25Caveat)(requestedCaip25CaveatValueWithExistingPermissions, selectedCaipAccountIds, selectedChainIds)
      }
    };
    approveConnection(_request);
  }, [request, requestedCaip25CaveatValueWithExistingPermissions, selectedCaipAccountIds, selectedChainIds, approveConnection]);
  const title = (0, _util.transformOriginToTitle)(targetSubjectMetadata.origin);
  const originTrustSignals = (0, _useOriginTrustSignals.useOriginTrustSignals)(targetSubjectMetadata.origin);
  const renderAccountCell = (0, _react.useCallback)(accountGroupId => {
    var _wallets$accountGroup;
    const accountGroup = supportedAccountGroups.find(group => group.id === accountGroupId);
    const account = accountGroup ? wallets === null || wallets === void 0 || (_wallets$accountGroup = wallets[accountGroup.walletId]) === null || _wallets$accountGroup === void 0 || (_wallets$accountGroup = _wallets$accountGroup.groups) === null || _wallets$accountGroup === void 0 ? void 0 : _wallets$accountGroup[accountGroupId] : undefined;
    const balance = (account === null || account === void 0 ? void 0 : account.totalBalanceInUserCurrency) ?? 0;
    const currency = (account === null || account === void 0 ? void 0 : account.userCurrency) ?? '';
    return /*#__PURE__*/_react.default.createElement(_multichainAccountCell.MultichainAccountCell, {
      accountId: accountGroupId,
      accountName: (accountGroup === null || accountGroup === void 0 ? void 0 : accountGroup.metadata.name) || 'Unknown Account',
      balance: formatCurrencyWithMinThreshold(balance, currency),
      key: accountGroupId,
      walletName: accountGroup === null || accountGroup === void 0 ? void 0 : accountGroup.walletName
    });
  }, [supportedAccountGroups, wallets, formatCurrencyWithMinThreshold]);
  return pageMode === MultichainAccountsConnectPageMode.Summary ? /*#__PURE__*/_react.default.createElement(_page.Page, {
    "data-testid": "connect-page",
    className: "main-container multichain-connect-page",
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault
  }, /*#__PURE__*/_react.default.createElement(_page.Header, {
    paddingTop: 8,
    paddingBottom: 0
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center,
    marginBottom: 8
  }, targetSubjectMetadata.iconUrl ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    style: {
      filter: 'blur(16px) brightness(1.1)',
      position: 'absolute'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarFavicon, {
    backgroundColor: _designSystem.BackgroundColor.backgroundMuted,
    size: _componentLibrary.AvatarFaviconSize.Xl,
    src: targetSubjectMetadata.iconUrl,
    name: title
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarFavicon, {
    backgroundColor: _designSystem.BackgroundColor.backgroundMuted,
    size: _componentLibrary.AvatarFaviconSize.Lg,
    src: targetSubjectMetadata.iconUrl,
    name: title,
    style: {
      zIndex: 1,
      background: 'transparent'
    }
  })) : /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarBase, {
    size: _componentLibrary.AvatarBaseSize.Lg,
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    color: _designSystem.TextColor.textAlternative,
    style: {
      borderWidth: '0px'
    },
    backgroundColor: _designSystem.BackgroundColor.backgroundMuted
  }, (0, _util.isIpAddress)(title) ? '?' : (0, _util.getAvatarFallbackLetter)(title))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    gap: 2,
    marginBottom: 1
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingLg,
    style: {
      wordBreak: 'break-word',
      whiteSpace: 'normal'
    }
  }, title), originTrustSignals.state === _useTrustSignals.TrustSignalDisplayState.Verified && /*#__PURE__*/_react.default.createElement(_reactTippy.Tooltip, {
    title: t('alertReasonOriginTrustSignalVerified'),
    position: "bottom",
    style: {
      display: 'flex'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.VerifiedFilled,
    color: _designSystem.IconColor.infoDefault,
    size: _componentLibrary.IconSize.Sm
  }))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textAlternative
  }, t('connectionDescription')))), /*#__PURE__*/_react.default.createElement(_page.Content, {
    paddingLeft: 4,
    paddingRight: 4,
    backgroundColor: _designSystem.BackgroundColor.transparent
  }, /*#__PURE__*/_react.default.createElement(_tabs.Tabs, {
    onTabClick: () => null,
    backgroundColor: _designSystemReact.BoxBackgroundColor.Transparent,
    defaultActiveTabKey: "accounts",
    tabListProps: {
      backgroundColor: _designSystemReact.BoxBackgroundColor.Transparent,
      justifyContent: _designSystemReact.BoxJustifyContent.Center
    }
  }, /*#__PURE__*/_react.default.createElement(_tabs.Tab, {
    className: "multichain-connect-page__tab",
    name: t('accounts'),
    tabKey: "accounts",
    "data-testid": "accounts-tab"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginTop: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    borderRadius: _designSystem.BorderRadius.XL
  }, selectedAccountGroupIds.map(renderAccountCell)), selectedAccountGroupIds.length === 0 && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "connect-page__accounts-empty",
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.flexStart,
    alignItems: _designSystem.AlignItems.center,
    borderRadius: _designSystem.BorderRadius.XL
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    onClick: setModeToEditAccounts,
    "data-testid": "edit"
  }, t('selectAccountToConnect'))), selectedAccountGroupIds.length > 0 && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginTop: 4,
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.flexStart,
    padding: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "connect-page__edit-icon",
    marginRight: 4,
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    backgroundColor: _designSystem.BackgroundColor.infoMuted,
    borderRadius: _designSystem.BorderRadius.MD,
    padding: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.Edit,
    size: _componentLibrary.IconSize.Md,
    color: _designSystem.IconColor.infoDefault
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    color: _designSystem.TextColor.infoDefault,
    onClick: setModeToEditAccounts,
    "data-testid": "edit"
  }, t('editAccounts'))))), /*#__PURE__*/_react.default.createElement(_tabs.Tab, {
    name: t('permissions'),
    className: "multichain-connect-page__tab",
    tabKey: "permissions",
    "data-testid": "permissions-tab",
    disabled: selectedAccountGroupIds.length === 0
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginTop: 4
  }, /*#__PURE__*/_react.default.createElement(_multichainSiteCell.MultichainSiteCell, {
    nonTestNetworks: nonTestNetworkConfigurations,
    testNetworks: testNetworkConfigurations,
    supportedAccountGroups: supportedAccountGroups,
    showEditAccounts: setModeToEditAccounts,
    onSelectChainIds: handleChainIdsSelected,
    selectedAccountGroupIds: selectedAccountGroupIds,
    selectedChainIds: selectedChainIds,
    isConnectFlow: true
  }))))), /*#__PURE__*/_react.default.createElement(_page.Footer, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 4,
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    gap: 4,
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    block: true,
    variant: _componentLibrary.ButtonVariant.Secondary,
    size: _componentLibrary.ButtonSize.Lg,
    "data-testid": "cancel-btn",
    onClick: handleCancelConnection
  }, t('cancel')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    block: true,
    "data-testid": "confirm-btn",
    size: _componentLibrary.ButtonSize.Lg,
    onClick: onConfirm,
    disabled: selectedAccountGroupIds.length === 0 || selectedChainIds.length === 0
  }, t('connect')))))) : /*#__PURE__*/_react.default.createElement(_multichainEditAccountsPage.MultichainEditAccountsPage, {
    supportedAccountGroups: supportedAccountGroups,
    defaultSelectedAccountGroups: selectedAccountGroupIds,
    onSubmit: handleAccountGroupIdsSelected,
    onClose: () => setPageMode(MultichainAccountsConnectPageMode.Summary)
  });
};
exports.MultichainAccountsConnectPage = MultichainAccountsConnectPage;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\multichain-accounts\\multichain-accounts-connect-page\\multichain-accounts-connect-page.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\smart-account-page\\index.ts", {"./smart-account-page":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\smart-account-page\\smart-account-page.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cmultichain-accounts%5Csmart-account-page%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "SmartAccountPage", {
  enumerable: true,
  get: function () {
    return _smartAccountPage.SmartAccountPage;
  }
});
var _smartAccountPage = require("./smart-account-page");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\multichain-accounts\\smart-account-page\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\smart-account-page\\smart-account-page.tsx", {"../../../components/multichain-accounts/smart-contract-account-toggle-section":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\smart-contract-account-toggle-section\\index.ts","../../../components/multichain/pages/page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cmultichain-accounts%5Csmart-account-page%5Csmart-account-page.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SmartAccountPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _designSystemReact = require("@metamask/design-system-react");
var _page = require("../../../components/multichain/pages/page");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _smartContractAccountToggleSection = require("../../../components/multichain-accounts/smart-contract-account-toggle-section");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const SmartAccountPage = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    address
  } = (0, _reactRouterDom.useParams)();
  const decodedAddress = address ? decodeURIComponent(address) : null;
  if (!decodedAddress) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_page.Page, {
    className: "max-w-[600px]"
  }, /*#__PURE__*/_react.default.createElement(_page.Header, {
    textProps: {
      variant: _designSystem.TextVariant.headingSm
    },
    startAccessory: /*#__PURE__*/_react.default.createElement(_designSystemReact.ButtonIcon, {
      size: _designSystemReact.ButtonIconSize.Md,
      ariaLabel: t('back'),
      iconName: _designSystemReact.IconName.ArrowLeft,
      onClick: () => history.goBack(),
      "data-testid": "smart-account-page-back-button"
    })
  }, t('smartAccount')), /*#__PURE__*/_react.default.createElement(_page.Content, null, /*#__PURE__*/_react.default.createElement(_designSystemReact.Box, {
    flexDirection: _designSystemReact.BoxFlexDirection.Column
  }, /*#__PURE__*/_react.default.createElement(_smartContractAccountToggleSection.SmartContractAccountToggleSection, {
    address: decodedAddress
  }))));
};
exports.SmartAccountPage = SmartAccountPage;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\multichain-accounts\\smart-account-page\\smart-account-page.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\wallet-details-page\\index.ts", {"./wallet-details-page":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\wallet-details-page\\wallet-details-page.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cmultichain-accounts%5Cwallet-details-page%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "WalletDetailsPage", {
  enumerable: true,
  get: function () {
    return _walletDetailsPage.WalletDetailsPage;
  }
});
var _walletDetailsPage = require("./wallet-details-page");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\multichain-accounts\\wallet-details-page\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\wallet-details-page\\wallet-details-page.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/multichain-accounts/add-multichain-account":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\add-multichain-account\\index.ts","../../../components/multichain-accounts/multichain-account-cell":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-account-cell\\index.ts","../../../components/multichain-accounts/multichain-srp-backup":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-srp-backup\\index.ts","../../../components/multichain/pages/page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../hooks/multichain-accounts/useWalletBalance":"D:\\code\\v\\metamask-extension\\ui\\hooks\\multichain-accounts\\useWalletBalance.ts","../../../hooks/multichain-accounts/useWalletInfo":"D:\\code\\v\\metamask-extension\\ui\\hooks\\multichain-accounts\\useWalletInfo.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","@metamask/account-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\index.cjs","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cmultichain-accounts%5Cwallet-details-page%5Cwallet-details-page.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WalletDetailsPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _accountApi = require("@metamask/account-api");
var _classnames = _interopRequireDefault(require("classnames"));
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _page = require("../../../components/multichain/pages/page");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _accountTree = require("../../../selectors/multichain-accounts/account-tree");
var _routes = require("../../../helpers/constants/routes");
var _multichainAccountCell = require("../../../components/multichain-accounts/multichain-account-cell");
var _addMultichainAccount = require("../../../components/multichain-accounts/add-multichain-account");
var _useWalletInfo = require("../../../hooks/multichain-accounts/useWalletInfo");
var _multichainSrpBackup = require("../../../components/multichain-accounts/multichain-srp-backup");
var _useWalletBalance = require("../../../hooks/multichain-accounts/useWalletBalance");
var _selectors = require("../../../selectors");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const WalletDetailsPage = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    id
  } = (0, _reactRouterDom.useParams)();
  const walletId = decodeURIComponent(id);
  const walletsWithAccounts = (0, _reactRedux.useSelector)(_accountTree.getWalletsWithAccounts);
  const wallet = walletsWithAccounts[walletId];
  const {
    multichainAccounts,
    keyringId,
    isSRPBackedUp
  } = (0, _useWalletInfo.useWalletInfo)(walletId);
  const walletTotalBalance = (0, _useWalletBalance.useSingleWalletDisplayBalance)(walletId);
  const walletAccountBalance = (0, _useWalletBalance.useSingleWalletAccountsBalanceCallback)(walletId);
  const {
    privacyMode
  } = (0, _reactRedux.useSelector)(_selectors.getPreferences);
  (0, _react.useEffect)(() => {
    if (!wallet) {
      history.push(_routes.ACCOUNT_LIST_PAGE_ROUTE);
    }
  }, [wallet, history]);
  const isEntropyWallet = (wallet === null || wallet === void 0 ? void 0 : wallet.type) === _accountApi.AccountWalletType.Entropy;
  const shouldShowBackupReminder = isSRPBackedUp === false;
  const rowStylesProps = {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    alignItems: _designSystem.AlignItems.center,
    backgroundColor: _designSystem.BackgroundColor.backgroundMuted
  };
  const handleBack = () => {
    history.goBack();
  };
  const multichainAccountCells = (0, _react.useMemo)(() => multichainAccounts.map(group => /*#__PURE__*/_react.default.createElement(_multichainAccountCell.MultichainAccountCell, {
    key: `multichain-account-cell-${group.id}`,
    accountId: group.id,
    accountName: group.metadata.name,
    balance: walletAccountBalance(group.id) ?? '',
    disableHoverEffect: true,
    privacyMode: privacyMode
  })), [multichainAccounts, privacyMode, walletAccountBalance]);
  const walletDetailsTitle = (0, _react.useMemo)(() => {
    return `${wallet === null || wallet === void 0 ? void 0 : wallet.metadata.name} / ${t('accounts')}`;
  }, [wallet === null || wallet === void 0 ? void 0 : wallet.metadata.name, t]);
  return /*#__PURE__*/_react.default.createElement(_page.Page, {
    className: "multichain-wallet-details-page"
  }, /*#__PURE__*/_react.default.createElement(_page.Header, {
    textProps: {
      variant: _designSystem.TextVariant.headingSm
    },
    startAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      size: _componentLibrary.ButtonIconSize.Md,
      ariaLabel: t('back'),
      iconName: _componentLibrary.IconName.ArrowLeft,
      onClick: handleBack,
      "data-testid": "back-button"
    })
  }, walletDetailsTitle), /*#__PURE__*/_react.default.createElement(_page.Content, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginBottom: 4,
    className: "multichain-wallet-details-page__rows-container"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, _extends({
    className: (0, _classnames.default)('multichain-wallet-details-page__row', 'multichain-wallet-details-page__row--first'),
    padding: 4
  }, rowStylesProps), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: _designSystem.TextColor.textDefault
  }, t('walletName')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: _designSystem.TextColor.textAlternative
  }, wallet === null || wallet === void 0 ? void 0 : wallet.metadata.name)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, _extends({
    className: "multichain-wallet-details-page__row",
    padding: 4
  }, rowStylesProps), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: _designSystem.TextColor.textDefault
  }, t('balance')), /*#__PURE__*/_react.default.createElement(_componentLibrary.SensitiveText, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: _designSystem.TextColor.textAlternative,
    isHidden: privacyMode,
    ellipsis: true
  }, walletTotalBalance ?? '$ n/a')), isEntropyWallet ? /*#__PURE__*/_react.default.createElement(_multichainSrpBackup.MultichainSrpBackup, {
    className: (0, _classnames.default)('multichain-wallet-details-page__row', 'multichain-wallet-details-page__row--last', 'multichain-wallet-details-page__srp-button'),
    shouldShowBackupReminder: shouldShowBackupReminder,
    keyringId: keyringId
  }) : null), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    backgroundColor: _designSystem.BackgroundColor.backgroundMuted,
    borderRadius: _designSystem.BorderRadius.XL
  }, multichainAccountCells, isEntropyWallet && /*#__PURE__*/_react.default.createElement(_addMultichainAccount.AddMultichainAccount, {
    walletId: walletId
  }))));
};
exports.WalletDetailsPage = WalletDetailsPage;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\multichain-accounts\\wallet-details-page\\wallet-details-page.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\wallet-details\\index.ts", {"./wallet-details.component":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\wallet-details\\wallet-details.component.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cmultichain-accounts%5Cwallet-details%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _walletDetails = _interopRequireDefault(require("./wallet-details.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
var _default = exports.default = _walletDetails.default;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\multichain-accounts\\wallet-details\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\wallet-details\\wallet-details.component.tsx", {"../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../components/app/srp-quiz-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\srp-quiz-modal\\index.ts","../../../components/app/user-preferenced-currency-display/user-preferenced-currency-display.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\user-preferenced-currency-display\\user-preferenced-currency-display.component.js","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/component-library/modal-content/deprecated":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\modal-content\\deprecated\\index.ts","../../../components/multichain/multichain-accounts/wallet-details-account-item/wallet-details-account-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\multichain-accounts\\wallet-details-account-item\\wallet-details-account-item.tsx","../../../components/multichain/multichain-accounts/wallet-details-account-type-selection":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\multichain-accounts\\wallet-details-account-type-selection\\index.ts","../../../components/multichain/pages/page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\index.ts","../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../hooks/accounts/useMultichainWalletSnapClient":"D:\\code\\v\\metamask-extension\\ui\\hooks\\accounts\\useMultichainWalletSnapClient.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cmultichain-accounts%5Cwallet-details%5Cwallet-details.component.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _keyringApi = require("@metamask/keyring-api");
var _componentLibrary = require("../../../components/component-library");
var _deprecated = require("../../../components/component-library/modal-content/deprecated");
var _designSystem = require("../../../helpers/constants/design-system");
var _page = require("../../../components/multichain/pages/page");
var _selectors = require("../../../selectors");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _accountTree = require("../../../selectors/multichain-accounts/account-tree");
var _metamask = require("../../../ducks/metamask/metamask");
var _walletDetailsAccountItem = _interopRequireDefault(require("../../../components/multichain/multichain-accounts/wallet-details-account-item/wallet-details-account-item"));
var _userPreferencedCurrencyDisplay = _interopRequireDefault(require("../../../components/app/user-preferenced-currency-display/user-preferenced-currency-display.component"));
var _srpQuizModal = _interopRequireDefault(require("../../../components/app/srp-quiz-modal"));
var _walletDetailsAccountTypeSelection = require("../../../components/multichain/multichain-accounts/wallet-details-account-type-selection");
var _actions = require("../../../store/actions");
var _routes = require("../../../helpers/constants/routes");
var _trace = require("../../../../shared/lib/trace");
var _useMultichainWalletSnapClient = require("../../../hooks/accounts/useMultichainWalletSnapClient");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const WalletDetails = () => {
  var _hdKeyrings$;
  const t = (0, _useI18nContext.useI18nContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    id
  } = (0, _reactRouterDom.useParams)();
  const decodedId = decodeURIComponent(id);
  const walletsWithAccounts = (0, _reactRedux.useSelector)(_accountTree.getWalletsWithAccounts);
  const seedPhraseBackedUp = (0, _reactRedux.useSelector)(_metamask.getIsPrimarySeedPhraseBackedUp);
  const hdKeyrings = (0, _reactRedux.useSelector)(_selectors.getMetaMaskHdKeyrings);
  const [srpQuizModalVisible, setSrpQuizModalVisible] = (0, _react.useState)(false);
  const wallet = walletsWithAccounts[decodedId];
  const [accountBalances, setAccountBalances] = (0, _react.useState)({});
  const [isModalOpen, setIsModalOpen] = (0, _react.useState)(false);

  // Initialize wallet snap clients
  const solanaClient = (0, _useMultichainWalletSnapClient.useMultichainWalletSnapClient)(_useMultichainWalletSnapClient.WalletClientType.Solana);
  const totalBalance = (0, _react.useMemo)(() => Object.values(accountBalances).reduce((sum, balance) => sum + Number(balance || 0), 0).toString(), [accountBalances]);
  const handleBalanceUpdate = (0, _react.useCallback)((accountId, balance) => {
    setAccountBalances(prev => ({
      ...prev,
      [accountId]: balance
    }));
  }, []);
  const handleAccountClick = account => {
    dispatch((0, _actions.setAccountDetailsAddress)(account.address));
    history.push(`${_routes.ACCOUNT_DETAILS_ROUTE}/${account.address}`);
  };
  const handleBack = () => {
    history.goBack();
  };
  if (!wallet) {
    return /*#__PURE__*/_react.default.createElement(_page.Page, {
      className: "wallet-details-page"
    }, /*#__PURE__*/_react.default.createElement(_page.Header, {
      textProps: {
        variant: _designSystem.TextVariant.headingSm
      },
      startAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
        size: _componentLibrary.ButtonIconSize.Md,
        ariaLabel: t('back'),
        iconName: _componentLibrary.IconName.ArrowLeft,
        onClick: handleBack
      })
    }, t('walletDetails')), /*#__PURE__*/_react.default.createElement(_page.Content, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerAlert, {
      severity: _componentLibrary.BannerAlertSeverity.Danger,
      title: t('walletNotFoundTitle')
    }, t('walletNotFoundDescription', [id]))));
  }
  const keyringId = wallet.id.split(':')[1];
  const isEntropyWallet = wallet.id.includes('entropy');
  const isFirstHdKeyring = ((_hdKeyrings$ = hdKeyrings[0]) === null || _hdKeyrings$ === void 0 || (_hdKeyrings$ = _hdKeyrings$.metadata) === null || _hdKeyrings$ === void 0 ? void 0 : _hdKeyrings$.id) === keyringId;
  const shouldShowBackupReminder = !seedPhraseBackedUp && isFirstHdKeyring;

  // Now, wallets are composed of multiple groups, so we have to flatten everything.
  const accounts = Object.values(wallet.groups).flatMap(group => group.accounts);
  const handleAddAccount = () => {
    setIsModalOpen(true);
  };
  const handleCloseModal = () => {
    setIsModalOpen(false);
  };
  const handleCreateEthereumAccount = async () => {
    (0, _trace.trace)({
      name: _trace.TraceName.AddAccount
    });
    try {
      await dispatch((0, _actions.addNewAccount)(keyringId, false));
      return true;
    } catch (error) {
      console.error('Error creating Ethereum account:', error);
      return false;
    } finally {
      (0, _trace.endTrace)({
        name: _trace.TraceName.AddAccount
      });
    }
  };
  const handleCreateSnapAccount = async (clientType, chainId) => {
    (0, _trace.trace)({
      name: _trace.TraceName.AddAccount
    });
    try {
      let client;
      if (clientType === _useMultichainWalletSnapClient.WalletClientType.Solana) {
        client = solanaClient;
      } else {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31893
        // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
        console.error(`Unsupported client type: ${clientType}`);
        return false;
      }
      if (!client) {
        console.error(`Client not available for type: ${clientType}`);
        return false;
      }
      await client.createAccount({
        scope: chainId,
        entropySource: keyringId
      }, {
        displayConfirmation: false,
        displayAccountNameSuggestion: false,
        setSelectedAccount: false
      });
      return true;
    } catch (error) {
      console.error(`Error creating ${clientType} account:`, error);
      return false;
    } finally {
      (0, _trace.endTrace)({
        name: _trace.TraceName.AddAccount
      });
    }
  };
  const handleAccountTypeSelect = async accountType => {
    let success = false;
    if (accountType === _useMultichainWalletSnapClient.EVM_WALLET_TYPE) {
      success = await handleCreateEthereumAccount();
    } else if (accountType === _useMultichainWalletSnapClient.WalletClientType.Solana) {
      success = await handleCreateSnapAccount(_useMultichainWalletSnapClient.WalletClientType.Solana, _keyringApi.SolScope.Mainnet);
    }
    if (success) {
      handleCloseModal();
    }
  };
  const rowStylesProps = {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    alignItems: _designSystem.AlignItems.center,
    backgroundColor: _designSystem.BackgroundColor.backgroundAlternative
  };
  return /*#__PURE__*/_react.default.createElement(_page.Page, {
    className: "wallet-details-page"
  }, /*#__PURE__*/_react.default.createElement(_page.Header, {
    textProps: {
      variant: _designSystem.TextVariant.headingSm
    },
    startAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      size: _componentLibrary.ButtonIconSize.Md,
      ariaLabel: t('back'),
      iconName: _componentLibrary.IconName.ArrowLeft,
      onClick: handleBack
    })
  }, t('walletDetails')), /*#__PURE__*/_react.default.createElement(_page.Content, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginBottom: 4,
    className: "wallet-details-page__rows-container"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, _extends({
    className: "wallet-details-page__row",
    padding: 4
  }, rowStylesProps), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: _designSystem.TextColor.textDefault
  }, t('walletName')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: _designSystem.TextColor.textAlternative
  }, wallet.metadata.name)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, _extends({
    className: "wallet-details-page__row",
    padding: 4
  }, rowStylesProps), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: _designSystem.TextColor.textDefault
  }, t('balance')), /*#__PURE__*/_react.default.createElement(_userPreferencedCurrencyDisplay.default, {
    value: totalBalance,
    type: "PRIMARY",
    ethNumberOfDecimals: 4,
    hideTitle: true,
    showFiat: true,
    isAggregatedFiatOverviewBalance: true,
    hideLabel: true,
    textProps: {
      color: _designSystem.TextColor.textAlternative,
      variant: _designSystem.TextVariant.bodyMdMedium
    }
  }))), isEntropyWallet ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginBottom: 4,
    className: "wallet-details-page__rows-container"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, _extends({
    className: "wallet-details-page__row wallet-details-page__srp-button",
    padding: 4,
    marginBottom: 1,
    width: _designSystem.BlockSize.Full,
    textAlign: _designSystem.TextAlign.Left
  }, rowStylesProps, {
    as: "button",
    onClick: () => {
      if (shouldShowBackupReminder) {
        const backUpSRPRoute = `${_routes.ONBOARDING_REVIEW_SRP_ROUTE}/?isFromReminder=true`;
        history.push(backUpSRPRoute);
      } else {
        setSrpQuizModalVisible(true);
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: _designSystem.TextColor.textDefault
  }, t('secretRecoveryPhrase'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    gap: 2
  }, shouldShowBackupReminder ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: _designSystem.TextColor.errorDefault
  }, t('backup')) : null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.ArrowRight,
    size: _componentLibrary.IconSize.Sm,
    color: _designSystem.IconColor.iconAlternative
  })))) : null, accounts.length > 0 && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "wallet-details-page__rows-container"
  }, accounts.map(account => /*#__PURE__*/_react.default.createElement(_walletDetailsAccountItem.default, _extends({
    key: account.id,
    account: account,
    onClick: handleAccountClick,
    onBalanceUpdate: handleBalanceUpdate,
    className: "wallet-details-page__row"
  }, rowStylesProps))), isEntropyWallet ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, _extends({
    className: "wallet-details-page__row wallet-details-page__add-account-button",
    padding: 4,
    width: _designSystem.BlockSize.Full,
    textAlign: _designSystem.TextAlign.Left
  }, rowStylesProps, {
    as: "button",
    onClick: handleAddAccount
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    gap: 3
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.Add,
    size: _componentLibrary.IconSize.Md,
    color: _designSystem.IconColor.primaryDefault
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: _designSystem.TextColor.primaryDefault
  }, t('addAccount')))) : null)), isEntropyWallet && srpQuizModalVisible && /*#__PURE__*/_react.default.createElement(_srpQuizModal.default, {
    keyringId: keyringId,
    isOpen: srpQuizModalVisible,
    onClose: () => setSrpQuizModalVisible(false),
    closeAfterCompleting: true
  }), isModalOpen && /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: true,
    onClose: handleCloseModal
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_deprecated.ModalContent, {
    className: "multichain-account-menu-popover",
    modalDialogProps: {
      className: 'multichain-account-menu-popover__dialog',
      padding: 0,
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column
    }
  }, /*#__PURE__*/_react.default.createElement(_walletDetailsAccountTypeSelection.WalletDetailsAccountTypeSelection, {
    onAccountTypeSelect: handleAccountTypeSelect,
    onClose: handleCloseModal
  }))));
};
WalletDetails.propTypes = {};
var _default = exports.default = WalletDetails;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\multichain-accounts\\wallet-details\\wallet-details.component.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\nonevm-balance-check\\index.tsx", {"../../../shared/constants/urls":"D:\\code\\v\\metamask-extension\\shared\\constants\\urls.ts","../../../shared/lib/deep-links/routes/nonevm":"D:\\code\\v\\metamask-extension\\shared\\lib\\deep-links\\routes\\nonevm.ts","../../../shared/lib/deep-links/routes/route":"D:\\code\\v\\metamask-extension\\shared\\lib\\deep-links\\routes\\route.ts","../../../shared/lib/deep-links/routes/swap":"D:\\code\\v\\metamask-extension\\shared\\lib\\deep-links\\routes\\swap.ts","../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../components/multichain/network-list-menu/add-non-evm-account/add-non-evm-account":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-menu\\add-non-evm-account\\add-non-evm-account.tsx","../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../hooks/ramps/useRamps/useRamps":"D:\\code\\v\\metamask-extension\\ui\\hooks\\ramps\\useRamps\\useRamps.ts","../../hooks/useMultichainBalances":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainBalances.ts","../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cnonevm-balance-check%5Cindex.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NonEvmBalanceCheck = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _componentLibrary = require("../../components/component-library");
var _designSystem = require("../../helpers/constants/design-system");
var _actions = require("../../store/actions");
var _useMultichainBalances = require("../../hooks/useMultichainBalances");
var _nonevm = require("../../../shared/lib/deep-links/routes/nonevm");
var _route = require("../../../shared/lib/deep-links/routes/route");
var _swap = require("../../../shared/lib/deep-links/routes/swap");
var _useRamps = require("../../hooks/ramps/useRamps/useRamps");
var _multichain = require("../../selectors/multichain");
var _selectors = require("../../selectors");
var _urls = require("../../../shared/constants/urls");
var _addNonEvmAccount = _interopRequireDefault(require("../../components/multichain/network-list-menu/add-non-evm-account/add-non-evm-account"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  getExtensionURL
} = globalThis.platform;
const getSwapUrl = chainId => {
  const query = new URLSearchParams();
  query.set('sourceToken', chainId);
  query.set(_swap.BridgeQueryParams.SWAPS, 'true');
  return getExtensionURL(_route.SWAP_ROUTE, query.toString());
};
const getBuyUrl = (chainId, metaMetricsId, isMetaMetricsEnabled, isMarketingEnabled) => {
  const buyParams = new URLSearchParams();
  buyParams.set('metamaskEntry', _useRamps.RampsMetaMaskEntry.BuySellButton);
  buyParams.set('chainId', chainId);
  if (metaMetricsId) {
    buyParams.set('metametricsId', metaMetricsId);
  }
  buyParams.set('metricsEnabled', String(isMetaMetricsEnabled));
  if (isMarketingEnabled) {
    buyParams.set('marketingEnabled', String(isMarketingEnabled));
  }
  const buyUrl = new URL('/buy', _urls.BaseUrl.Portfolio);
  buyUrl.search = buyParams.toString();
  return buyUrl.toString();
};
const NonEvmBalanceCheck = () => {
  const location = (0, _reactRouterDom.useLocation)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const metaMetricsId = (0, _reactRedux.useSelector)(_selectors.getMetaMetricsId);
  const isMetaMetricsEnabled = (0, _reactRedux.useSelector)(_selectors.getParticipateInMetaMetrics);
  const isMarketingEnabled = (0, _reactRedux.useSelector)(_selectors.getDataCollectionForMarketing);
  const accounts = (0, _reactRedux.useSelector)(_selectors.getMetaMaskAccountsOrdered);
  const lastSelectedNonEvmAccount = (0, _reactRedux.useSelector)(_multichain.getLastSelectedNonEvmAccount);
  const params = new URLSearchParams(location.search);
  const chainId = params.get(_nonevm.NonEvmQueryParams.ChainId);
  const {
    assetsWithBalance
  } = (0, _useMultichainBalances.useMultichainBalances)();
  const hasAccountForChain = accounts.some(account => account.scopes.includes(chainId));
  (0, _react.useEffect)(() => {
    if (!chainId) {
      return;
    }
    if (hasAccountForChain) {
      var _lastSelectedNonEvmAc;
      // If we have a "last selected" non-EVM account that matches the chain -> switch to it
      if (lastSelectedNonEvmAccount !== null && lastSelectedNonEvmAccount !== void 0 && (_lastSelectedNonEvmAc = lastSelectedNonEvmAccount.scopes) !== null && _lastSelectedNonEvmAc !== void 0 && _lastSelectedNonEvmAc.includes(chainId)) {
        dispatch((0, _actions.setSelectedAccount)(lastSelectedNonEvmAccount.address));
      }
      const hasPositiveBalance = assetsWithBalance.some(asset => asset.chainId === chainId && asset.balance && asset.balance !== '0');
      window.location.href = hasPositiveBalance ? getSwapUrl(chainId) : getBuyUrl(chainId, metaMetricsId, isMetaMetricsEnabled, isMarketingEnabled);
    }
  }, [chainId, assetsWithBalance, metaMetricsId, isMetaMetricsEnabled, isMarketingEnabled, hasAccountForChain, accounts]);
  if (!hasAccountForChain) {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
      isOpen: true,
      onClose: () => {
        // do nothing
      }
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, {
      modalDialogProps: {
        padding: 0,
        display: _designSystem.Display.Flex,
        flexDirection: _designSystem.FlexDirection.Column
      }
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      justifyContent: _designSystem.JustifyContent.spaceBetween,
      width: _designSystem.BlockSize.Full,
      padding: 2
    }, /*#__PURE__*/_react.default.createElement(_addNonEvmAccount.default, {
      chainId: chainId
    }))));
  }
  return null;
};
exports.NonEvmBalanceCheck = NonEvmBalanceCheck;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\nonevm-balance-check\\index.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\notification-details\\index.js", {"./notification-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\notification-details\\notification-details.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cnotification-details%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _notificationDetails.default;
  }
});
var _notificationDetails = _interopRequireDefault(require("./notification-details"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\notification-details\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\notification-details\\notification-details-body\\notification-details-body.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../notifications/notification-components/types/notifications/notifications":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\types\\notifications\\notifications.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cnotification-details%5Cnotification-details-body%5Cnotification-details-body.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationDetailsBody = void 0;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _notifications = require("../../notifications/notification-components/types/notifications/notifications");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const NotificationDetailsBody = ({
  body,
  notification
}) => {
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    padding: 0
  }, body.type === _notifications.NotificationComponentType.AnnouncementBody && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(body.Image, {
    notification: notification
  }), /*#__PURE__*/_react.default.createElement(body.Description, {
    notification: notification
  })), body.type === _notifications.NotificationComponentType.OnChainBody && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, body.Image && /*#__PURE__*/_react.default.createElement(body.Image, {
    notification: notification
  }), body.From && /*#__PURE__*/_react.default.createElement(body.From, {
    notification: notification
  }), body.To && /*#__PURE__*/_react.default.createElement(body.To, {
    notification: notification
  }), body.Account && /*#__PURE__*/_react.default.createElement(body.Account, {
    notification: notification
  }), body.Asset && /*#__PURE__*/_react.default.createElement(body.Asset, {
    notification: notification
  }), body.AssetReceived && /*#__PURE__*/_react.default.createElement(body.AssetReceived, {
    notification: notification
  }), body.Status && /*#__PURE__*/_react.default.createElement(body.Status, {
    notification: notification
  }), body.Network && /*#__PURE__*/_react.default.createElement(body.Network, {
    notification: notification
  }), body.Rate && /*#__PURE__*/_react.default.createElement(body.Rate, {
    notification: notification
  }), body.Provider && /*#__PURE__*/_react.default.createElement(body.Provider, {
    notification: notification
  }), body.NetworkFee && /*#__PURE__*/_react.default.createElement(body.NetworkFee, {
    notification: notification
  })), body.type === _notifications.NotificationComponentType.SnapBody && /*#__PURE__*/_react.default.createElement(body.Content, {
    notification: notification
  }));
};
exports.NotificationDetailsBody = NotificationDetailsBody;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\notification-details\\notification-details-body\\notification-details-body.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\notification-details\\notification-details-footer\\notification-details-footer.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../notifications/notification-components/types/notifications/notifications":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\types\\notifications\\notifications.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cnotification-details%5Cnotification-details-footer%5Cnotification-details-footer.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationDetailsFooter = void 0;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _notifications = require("../../notifications/notification-components/types/notifications/notifications");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const NotificationDetailsFooter = ({
  footer,
  notification
}) => {
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    width: _designSystem.BlockSize.Full,
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    padding: 4,
    gap: 4
  }, footer.type === _notifications.NotificationComponentType.OnChainFooter && /*#__PURE__*/_react.default.createElement(footer.ScanLink, {
    notification: notification
  }), footer.type === _notifications.NotificationComponentType.AnnouncementFooter && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    gap: 4,
    flexDirection: _designSystem.FlexDirection.Row,
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(footer.ExternalLink, {
    notification: notification
  }), /*#__PURE__*/_react.default.createElement(footer.ExtensionLink, {
    notification: notification
  })), footer.type === _notifications.NotificationComponentType.SnapFooter && /*#__PURE__*/_react.default.createElement(footer.Link, {
    notification: notification
  }));
};
exports.NotificationDetailsFooter = NotificationDetailsFooter;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\notification-details\\notification-details-footer\\notification-details-footer.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\notification-details\\notification-details-header\\notification-details-header.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cnotification-details%5Cnotification-details-header%5Cnotification-details-header.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationDetailsHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../../components/component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const NotificationDetailsHeader = ({
  children,
  onClickBack
}) => {
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.HeaderBase, {
    padding: 4,
    startAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      ariaLabel: "Back",
      iconName: _componentLibrary.IconName.ArrowLeft,
      size: _componentLibrary.ButtonIconSize.Md,
      onClick: onClickBack,
      "data-testid": "notification-details-back-button"
    }),
    endAccessory: null
  }, children);
};
exports.NotificationDetailsHeader = NotificationDetailsHeader;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\notification-details\\notification-details-header\\notification-details-header.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\notification-details\\notification-details.tsx", {"../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../components/multichain":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../components/multichain/pages/page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\index.ts","../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../hooks/metamask-notifications/useNotifications":"D:\\code\\v\\metamask-extension\\ui\\hooks\\metamask-notifications\\useNotifications.ts","../../hooks/useNotificationTimeouts":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useNotificationTimeouts.ts","../../selectors/metamask-notifications/metamask-notifications":"D:\\code\\v\\metamask-extension\\ui\\selectors\\metamask-notifications\\metamask-notifications.ts","../notifications/notification-components":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\index.ts","./notification-details-body/notification-details-body":"D:\\code\\v\\metamask-extension\\ui\\pages\\notification-details\\notification-details-body\\notification-details-body.tsx","./notification-details-footer/notification-details-footer":"D:\\code\\v\\metamask-extension\\ui\\pages\\notification-details\\notification-details-footer\\notification-details-footer.tsx","./notification-details-header/notification-details-header":"D:\\code\\v\\metamask-extension\\ui\\pages\\notification-details\\notification-details-header\\notification-details-header.tsx","./utils/utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\notification-details\\utils\\utils.ts","@metamask/notification-services-controller/notification-services":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\notification-services-controller\\dist\\NotificationServicesController\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cnotification-details%5Cnotification-details.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = NotificationDetails;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _notificationServices = require("@metamask/notification-services-controller/notification-services");
var _componentLibrary = require("../../components/component-library");
var _designSystem = require("../../helpers/constants/design-system");
var _routes = require("../../helpers/constants/routes");
var _multichain = require("../../components/multichain");
var _page = require("../../components/multichain/pages/page");
var _useNotifications = require("../../hooks/metamask-notifications/useNotifications");
var _metamaskNotifications = require("../../selectors/metamask-notifications/metamask-notifications");
var _notificationComponents = require("../notifications/notification-components");
var _useNotificationTimeouts = require("../../hooks/useNotificationTimeouts");
var _utils = require("./utils/utils");
var _notificationDetailsHeader = require("./notification-details-header/notification-details-header");
var _notificationDetailsBody = require("./notification-details-body/notification-details-body");
var _notificationDetailsFooter = require("./notification-details-footer/notification-details-footer");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function useNotificationByPath() {
  const {
    pathname
  } = (0, _reactRouterDomV5Compat.useLocation)();
  const id = (0, _utils.getExtractIdentifier)(pathname);
  const notification = (0, _reactRedux.useSelector)((0, _metamaskNotifications.getMetamaskNotificationById)(id));
  return {
    notification
  };
}
function useEffectOnNotificationView(notificationData) {
  const {
    markNotificationAsRead
  } = (0, _useNotifications.useMarkNotificationAsRead)();
  const {
    setNotificationTimeout
  } = (0, _useNotificationTimeouts.useSnapNotificationTimeouts)();
  (0, _react.useEffect)(() => {
    if (notificationData) {
      markNotificationAsRead([{
        id: notificationData.id,
        type: notificationData.type,
        isRead: notificationData.isRead
      }]);
    }
    return () => {
      if ((notificationData === null || notificationData === void 0 ? void 0 : notificationData.type) === _notificationServices.TRIGGER_TYPES.SNAP) {
        setNotificationTimeout(notificationData.id);
      }
    };
  }, []);
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function NotificationDetails() {
  const navigate = (0, _reactRouterDomV5Compat.useNavigate)();
  const {
    notification
  } = useNotificationByPath();
  useEffectOnNotificationView(notification);

  // No Notification
  if (!notification) {
    navigate(_routes.NOTIFICATIONS_ROUTE);
    return null;
  }

  // Invalid Notification
  if (!(0, _notificationComponents.hasNotificationComponents)(notification.type)) {
    navigate(_routes.NOTIFICATIONS_ROUTE);
    return null;
  }
  const ncs = _notificationComponents.NotificationComponents[notification.type];
  return /*#__PURE__*/_react.default.createElement(_multichain.NotificationsPage, null, /*#__PURE__*/_react.default.createElement(_notificationDetailsHeader.NotificationDetailsHeader, {
    onClickBack: () => navigate(_routes.NOTIFICATIONS_ROUTE)
  }, /*#__PURE__*/_react.default.createElement(ncs.details.title, {
    notification: notification
  })), /*#__PURE__*/_react.default.createElement(_page.Content, {
    padding: 0
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 2,
    width: _designSystem.BlockSize.Full,
    height: _designSystem.BlockSize.Full,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, /*#__PURE__*/_react.default.createElement(_notificationDetailsBody.NotificationDetailsBody, {
    body: ncs.details.body,
    notification: notification
  }), /*#__PURE__*/_react.default.createElement(_notificationDetailsFooter.NotificationDetailsFooter, {
    footer: ncs.footer,
    notification: notification
  }))));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\notification-details\\notification-details.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\notification-details\\utils\\utils.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cnotification-details%5Cutils%5Cutils.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExtractIdentifier = getExtractIdentifier;
/**
 * Custom util to extract a specific identifier from the URL pathname.
 * Assumes the URL hash follows a structure like "#/somePrefix/identifier".
 * Handles undefined or non-string input gracefully by returning an empty string.
 *
 * @param pathname - The URL pathname to extract the identifier from.
 */
function getExtractIdentifier(pathname) {
  if (typeof pathname !== 'string') {
    return '';
  }
  const parts = pathname.split('/');
  return parts.length > 2 ? parts[2] : '';
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\notification-details\\utils\\utils.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\notifications-settings\\index.js", {"./notifications-settings":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications-settings\\notifications-settings.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cnotifications-settings%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _notificationsSettings.default;
  }
});
var _notificationsSettings = _interopRequireDefault(require("./notifications-settings"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\notifications-settings\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\notifications-settings\\notifications-settings-allow-notifications.tsx", {"../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../components/multichain":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../contexts/metamask-notifications/metamask-notifications":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metamask-notifications\\metamask-notifications.tsx","../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../hooks/metamask-notifications/useNotifications":"D:\\code\\v\\metamask-extension\\ui\\hooks\\metamask-notifications\\useNotifications.ts","../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../selectors/identity/backup-and-sync":"D:\\code\\v\\metamask-extension\\ui\\selectors\\identity\\backup-and-sync.ts","../../selectors/metamask-notifications/metamask-notifications":"D:\\code\\v\\metamask-extension\\ui\\selectors\\metamask-notifications\\metamask-notifications.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cnotifications-settings%5Cnotifications-settings-allow-notifications.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationsSettingsAllowNotifications = NotificationsSettingsAllowNotifications;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _useI18nContext = require("../../hooks/useI18nContext");
var _metametrics = require("../../contexts/metametrics");
var _metametrics2 = require("../../../shared/constants/metametrics");
var _useNotifications = require("../../hooks/metamask-notifications/useNotifications");
var _metamaskNotifications = require("../../selectors/metamask-notifications/metamask-notifications");
var _backupAndSync = require("../../selectors/identity/backup-and-sync");
var _metamaskNotifications2 = require("../../contexts/metamask-notifications/metamask-notifications");
var _componentLibrary = require("../../components/component-library");
var _designSystem = require("../../helpers/constants/design-system");
var _multichain = require("../../components/multichain");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function NotificationsSettingsAllowNotifications({
  loading,
  setLoading,
  disabled,
  dataTestId
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const {
    listNotifications
  } = (0, _metamaskNotifications2.useMetamaskNotificationsContext)();
  const isMetamaskNotificationsEnabled = (0, _reactRedux.useSelector)(_metamaskNotifications.selectIsMetamaskNotificationsEnabled);
  const [toggleValue, setToggleValue] = (0, _react.useState)(isMetamaskNotificationsEnabled);
  const isUpdatingMetamaskNotifications = (0, _reactRedux.useSelector)(_metamaskNotifications.getIsUpdatingMetamaskNotifications);
  const isBackupAndSyncEnabled = (0, _reactRedux.useSelector)(_backupAndSync.selectIsBackupAndSyncEnabled);
  const {
    enableNotifications,
    error: errorEnableNotifications
  } = (0, _useNotifications.useEnableNotifications)();
  const {
    disableNotifications,
    error: errorDisableNotifications
  } = (0, _useNotifications.useDisableNotifications)();
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  const error = errorEnableNotifications || errorDisableNotifications;
  (0, _react.useEffect)(() => {
    setLoading(isUpdatingMetamaskNotifications);
  }, [isUpdatingMetamaskNotifications, setLoading]);
  (0, _react.useEffect)(() => {
    setToggleValue(isMetamaskNotificationsEnabled);
  }, [isMetamaskNotificationsEnabled]);
  (0, _react.useEffect)(() => {
    if (!error && isMetamaskNotificationsEnabled) {
      listNotifications();
    }
  }, [isMetamaskNotificationsEnabled, error, listNotifications]);
  const toggleNotifications = (0, _react.useCallback)(async () => {
    setLoading(true);
    if (isMetamaskNotificationsEnabled) {
      trackEvent({
        category: _metametrics2.MetaMetricsEventCategory.NotificationSettings,
        event: _metametrics2.MetaMetricsEventName.NotificationsSettingsUpdated,
        properties: {
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          settings_type: 'notifications',
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          was_profile_syncing_on: isBackupAndSyncEnabled,
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          old_value: true,
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          new_value: false
        }
      });
      await disableNotifications();
    } else {
      trackEvent({
        category: _metametrics2.MetaMetricsEventCategory.NotificationSettings,
        event: _metametrics2.MetaMetricsEventName.NotificationsSettingsUpdated,
        properties: {
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          settings_type: 'notifications',
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          was_profile_syncing_on: isBackupAndSyncEnabled,
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          old_value: false,
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          new_value: true
        }
      });
      await enableNotifications();
    }
    setLoading(false);
    setToggleValue(!toggleValue);
  }, [setLoading, isMetamaskNotificationsEnabled, disableNotifications, enableNotifications, toggleValue, isBackupAndSyncEnabled, trackEvent]);
  const privacyLink = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "a",
    href: "https://support.metamask.io/privacy-and-security/profile-privacy",
    target: "_blank",
    rel: "noopener noreferrer",
    key: "privacy-link",
    color: _designSystem.TextColor.infoDefault
  }, t('notificationsSettingsPageAllowNotificationsLink')), [t]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.flexStart,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.flexStart,
    gap: 4,
    paddingLeft: 8,
    paddingRight: 8,
    paddingBottom: 8
  }, /*#__PURE__*/_react.default.createElement(_multichain.NotificationsSettingsBox, {
    value: toggleValue
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    ,
    onToggle: toggleNotifications,
    disabled: disabled,
    loading: loading,
    dataTestId: dataTestId
  }, /*#__PURE__*/_react.default.createElement(_multichain.NotificationsSettingsType, {
    title: t('allowNotifications')
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    color: _designSystem.TextColor.textAlternative
  }, t('notificationsSettingsPageAllowNotifications', [privacyLink])), error && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "p",
    color: _designSystem.TextColor.errorDefault
  }, isMetamaskNotificationsEnabled ? t('turnOffMetamaskNotificationsError') : t('turnOnMetamaskNotificationsError'))));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\notifications-settings\\notifications-settings-allow-notifications.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\notifications-settings\\notifications-settings-per-account.tsx", {"../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../components/multichain":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../hooks/metamask-notifications/useNotifications":"D:\\code\\v\\metamask-extension\\ui\\hooks\\metamask-notifications\\useNotifications.ts","../../hooks/metamask-notifications/useSwitchNotifications":"D:\\code\\v\\metamask-extension\\ui\\hooks\\metamask-notifications\\useSwitchNotifications.ts","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cnotifications-settings%5Cnotifications-settings-per-account.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationsSettingsPerAccount = void 0;
var _react = _interopRequireWildcard(require("react"));
var _controllerUtils = require("@metamask/controller-utils");
var _metametrics = require("../../contexts/metametrics");
var _metametrics2 = require("../../../shared/constants/metametrics");
var _useSwitchNotifications = require("../../hooks/metamask-notifications/useSwitchNotifications");
var _multichain = require("../../components/multichain");
var _useNotifications = require("../../hooks/metamask-notifications/useNotifications");
var _util = require("../../helpers/utils/util");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function useUpdateAccountSetting(address, refetchAccountSettings) {
  const {
    onChange: switchAccountNotifications,
    error
  } = (0, _useSwitchNotifications.useSwitchAccountNotificationsChange)();
  const {
    listNotifications: refetch
  } = (0, _useNotifications.useListNotifications)();

  // Local states
  const [loading, setLoading] = (0, _react.useState)(false);
  const toggleAccount = (0, _react.useCallback)(async state => {
    setLoading(true);
    try {
      await switchAccountNotifications([address], state);
      await refetchAccountSettings();
      refetch();
    } catch {
      // Do nothing (we don't need to propagate this)
    }
    setLoading(false);
  }, [address, refetch, refetchAccountSettings, switchAccountNotifications]);
  return {
    toggleAccount,
    loading,
    error
  };
}
const NotificationsSettingsPerAccount = ({
  address,
  name,
  isEnabled,
  isLoading,
  disabledSwitch,
  refetchAccountSettings
}) => {
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const {
    toggleAccount,
    loading: isUpdatingAccount,
    error: accountError
  } = useUpdateAccountSetting(address, refetchAccountSettings);

  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  const loading = isLoading || isUpdatingAccount;
  const error = accountError;
  const handleToggleAccountNotifications = (0, _react.useCallback)(async () => {
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.NotificationSettings,
      event: _metametrics2.MetaMetricsEventName.NotificationsSettingsUpdated,
      properties: {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        settings_type: 'account_notifications',
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        old_value: isEnabled,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        new_value: !isEnabled
      }
    });
    await toggleAccount(!isEnabled);
  }, [address, isEnabled, toggleAccount, trackEvent]);
  const checksumAddress = (0, _controllerUtils.toChecksumHexAddress)(address);
  const shortenedAddress = (0, _util.shortenAddress)(checksumAddress);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_multichain.NotificationsSettingsBox, {
    value: isEnabled ?? false
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    ,
    onToggle: handleToggleAccountNotifications,
    key: address,
    disabled: disabledSwitch,
    loading: loading,
    error: error,
    dataTestId: `${shortenedAddress}-notifications-settings`
  }, /*#__PURE__*/_react.default.createElement(_multichain.NotificationsSettingsAccount, {
    address: address,
    name: name
  })));
};
exports.NotificationsSettingsPerAccount = NotificationsSettingsPerAccount;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\notifications-settings\\notifications-settings-per-account.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\notifications-settings\\notifications-settings-types.tsx", {"../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../components/multichain":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../contexts/metamask-notifications/metamask-notifications":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metamask-notifications\\metamask-notifications.tsx","../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../hooks/metamask-notifications/useSwitchNotifications":"D:\\code\\v\\metamask-extension\\ui\\hooks\\metamask-notifications\\useSwitchNotifications.ts","../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../selectors/metamask-notifications/metamask-notifications":"D:\\code\\v\\metamask-extension\\ui\\selectors\\metamask-notifications\\metamask-notifications.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cnotifications-settings%5Cnotifications-settings-types.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationsSettingsTypes = NotificationsSettingsTypes;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _metametrics = require("../../contexts/metametrics");
var _metametrics2 = require("../../../shared/constants/metametrics");
var _useI18nContext = require("../../hooks/useI18nContext");
var _metamaskNotifications = require("../../contexts/metamask-notifications/metamask-notifications");
var _useSwitchNotifications = require("../../hooks/metamask-notifications/useSwitchNotifications");
var _componentLibrary = require("../../components/component-library");
var _designSystem = require("../../helpers/constants/design-system");
var _multichain = require("../../components/multichain");
var _metamaskNotifications2 = require("../../selectors/metamask-notifications/metamask-notifications");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function NotificationsSettingsTypes({
  disabled
}) {
  // Context
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    listNotifications
  } = (0, _metamaskNotifications.useMetamaskNotificationsContext)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);

  // Selectors
  const isFeatureAnnouncementsEnabled = (0, _reactRedux.useSelector)(_metamaskNotifications2.selectIsFeatureAnnouncementsEnabled);

  // Hooks
  const {
    onChange: onChangeFeatureAnnouncements,
    error: errorFeatureAnnouncements
  } = (0, _useSwitchNotifications.useSwitchFeatureAnnouncementsChange)();

  // States
  const [featureAnnouncementsEnabled, setFeatureAnnouncementsEnabled] = (0, _react.useState)(isFeatureAnnouncementsEnabled);
  const onToggleFeatureAnnouncements = async () => {
    setFeatureAnnouncementsEnabled(!featureAnnouncementsEnabled);
    try {
      onChangeFeatureAnnouncements(!featureAnnouncementsEnabled);
      trackEvent({
        category: _metametrics2.MetaMetricsEventCategory.NotificationSettings,
        event: _metametrics2.MetaMetricsEventName.NotificationsSettingsUpdated,
        properties: {
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          settings_type: 'product_announcements',
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          old_value: featureAnnouncementsEnabled,
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          new_value: !featureAnnouncementsEnabled
        }
      });
      listNotifications();
    } catch (error) {
      setFeatureAnnouncementsEnabled(featureAnnouncementsEnabled);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 8,
    paddingRight: 8,
    paddingBottom: 4,
    paddingTop: 4,
    "data-testid": "notifications-settings-per-types"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    color: _designSystem.TextColor.textDefault
  }, t('customizeYourNotifications')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative
  }, t('customizeYourNotificationsText'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.flexStart,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.flexStart,
    gap: 6,
    paddingLeft: 8,
    paddingRight: 8,
    paddingBottom: 4
  }, /*#__PURE__*/_react.default.createElement(_multichain.NotificationsSettingsBox, {
    value: featureAnnouncementsEnabled
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    ,
    onToggle: onToggleFeatureAnnouncements,
    error: errorFeatureAnnouncements,
    disabled: disabled,
    dataTestId: "product-announcements"
  }, /*#__PURE__*/_react.default.createElement(_multichain.NotificationsSettingsType, {
    icon: _componentLibrary.IconName.Star,
    title: t('productAnnouncements')
  }))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    borderColor: _designSystem.BorderColor.borderMuted,
    width: _designSystem.BlockSize.Full,
    style: {
      height: '1px',
      borderBottomWidth: 0
    }
  }));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\notifications-settings\\notifications-settings-types.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\notifications-settings\\notifications-settings.tsx", {"../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../components/multichain":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../components/multichain/pages/page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\index.ts","../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../hooks/metamask-notifications/useSwitchNotifications":"D:\\code\\v\\metamask-extension\\ui\\hooks\\metamask-notifications\\useSwitchNotifications.ts","../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../selectors/metamask-notifications/metamask-notifications":"D:\\code\\v\\metamask-extension\\ui\\selectors\\metamask-notifications\\metamask-notifications.ts","./notifications-settings-allow-notifications":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications-settings\\notifications-settings-allow-notifications.tsx","./notifications-settings-per-account":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications-settings\\notifications-settings-per-account.tsx","./notifications-settings-types":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications-settings\\notifications-settings-types.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cnotifications-settings%5Cnotifications-settings.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = NotificationsSettings;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _useI18nContext = require("../../hooks/useI18nContext");
var _routes = require("../../helpers/constants/routes");
var _componentLibrary = require("../../components/component-library");
var _designSystem = require("../../helpers/constants/design-system");
var _multichain = require("../../components/multichain");
var _page = require("../../components/multichain/pages/page");
var _metamaskNotifications = require("../../selectors/metamask-notifications/metamask-notifications");
var _selectors = require("../../selectors");
var _useSwitchNotifications = require("../../hooks/metamask-notifications/useSwitchNotifications");
var _notificationsSettingsAllowNotifications = require("./notifications-settings-allow-notifications");
var _notificationsSettingsTypes = require("./notifications-settings-types");
var _notificationsSettingsPerAccount = require("./notifications-settings-per-account");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function useNotificationAccounts() {
  const accountAddresses = (0, _reactRedux.useSelector)(_metamaskNotifications.getValidNotificationAccounts);
  const internalAccounts = (0, _reactRedux.useSelector)(_selectors.getInternalAccounts);
  const accounts = (0, _react.useMemo)(() => {
    return accountAddresses.map(addr => {
      const account = internalAccounts.find(a => a.address.toLowerCase() === addr.toLowerCase());
      return account;
    })
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
    // eslint-disable-next-line @typescript-eslint/naming-convention
    .filter(val => Boolean(val));
  }, [accountAddresses, internalAccounts]);
  return accounts;
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function NotificationsSettings() {
  var _location$state;
  const navigate = (0, _reactRouterDomV5Compat.useNavigate)();
  const location = (0, _reactRouterDomV5Compat.useLocation)();
  const t = (0, _useI18nContext.useI18nContext)();

  // Selectors
  const isMetamaskNotificationsEnabled = (0, _reactRedux.useSelector)(_metamaskNotifications.selectIsMetamaskNotificationsEnabled);
  const isUpdatingMetamaskNotifications = (0, _reactRedux.useSelector)(_metamaskNotifications.getIsUpdatingMetamaskNotifications);
  const accounts = useNotificationAccounts();

  // States
  const [loadingAllowNotifications, setLoadingAllowNotifications] = (0, _react.useState)(isUpdatingMetamaskNotifications);
  const accountAddresses = (0, _react.useMemo)(() => accounts.map(a => a.address), [accounts]);

  // Account Settings
  const accountSettingsProps = (0, _useSwitchNotifications.useAccountSettingsProps)(accountAddresses);
  const updatingAccounts = accountSettingsProps.accountsBeingUpdated.length > 0;
  const refetchAccountSettings = async () => {
    await accountSettingsProps.update(accountAddresses);
  };

  // Previous page
  const previousPage = (_location$state = location.state) === null || _location$state === void 0 ? void 0 : _location$state.fromPage;
  return /*#__PURE__*/_react.default.createElement(_multichain.NotificationsPage, null, /*#__PURE__*/_react.default.createElement(_page.Header, {
    startAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      ariaLabel: "Back",
      iconName: _componentLibrary.IconName.ArrowLeft,
      size: _componentLibrary.ButtonIconSize.Md,
      onClick: () => previousPage ? navigate(previousPage) : navigate(_routes.NOTIFICATIONS_ROUTE)
    }),
    endAccessory: null
  }, t('notifications')), /*#__PURE__*/_react.default.createElement(_page.Content, {
    padding: 0
  }, /*#__PURE__*/_react.default.createElement(_notificationsSettingsAllowNotifications.NotificationsSettingsAllowNotifications, {
    loading: loadingAllowNotifications,
    setLoading: setLoadingAllowNotifications,
    dataTestId: "notifications-settings-allow",
    disabled: updatingAccounts
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    borderColor: _designSystem.BorderColor.borderMuted,
    width: _designSystem.BlockSize.Full,
    style: {
      height: '1px',
      borderBottomWidth: 0
    }
  }), isMetamaskNotificationsEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_notificationsSettingsTypes.NotificationsSettingsTypes, {
    disabled: loadingAllowNotifications || updatingAccounts
  }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 8,
    paddingRight: 8,
    paddingBottom: 4,
    paddingTop: 4,
    "data-testid": "notifications-settings-per-account"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    color: _designSystem.TextColor.textDefault
  }, t('accountActivity')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative
  }, t('accountActivityText'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.flexStart,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.flexStart,
    gap: 6,
    paddingLeft: 8,
    paddingRight: 8,
    paddingBottom: 4
  }, accounts.map(account => {
    var _accountSettingsProps;
    return /*#__PURE__*/_react.default.createElement(_notificationsSettingsPerAccount.NotificationsSettingsPerAccount, {
      key: account.id,
      address: account.address,
      name: account.metadata.name,
      disabledSwitch: accountSettingsProps.initialLoading || updatingAccounts,
      isLoading: accountSettingsProps.accountsBeingUpdated.includes(account.address),
      isEnabled: ((_accountSettingsProps = accountSettingsProps.data) === null || _accountSettingsProps === void 0 ? void 0 : _accountSettingsProps[account.address.toLowerCase()]) ?? false,
      refetchAccountSettings: refetchAccountSettings
    });
  }))))));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\notifications-settings\\notifications-settings.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\NewFeatureTag.tsx", {"../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../selectors/metamask-notifications/metamask-notifications":"D:\\code\\v\\metamask-extension\\ui\\selectors\\metamask-notifications\\metamask-notifications.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cnotifications%5CNewFeatureTag.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewFeatureTag = NewFeatureTag;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _metamaskNotifications = require("../../selectors/metamask-notifications/metamask-notifications");
var _componentLibrary = require("../../components/component-library");
var _designSystem = require("../../helpers/constants/design-system");
var _useI18nContext = require("../../hooks/useI18nContext");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function NewFeatureTag() {
  const t = (0, _useI18nContext.useI18nContext)();
  const isMetamaskNotificationsFeatureSeen = (0, _reactRedux.useSelector)(_metamaskNotifications.selectIsMetamaskNotificationsFeatureSeen);
  if (isMetamaskNotificationsFeatureSeen) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Tag, {
    backgroundColor: _designSystem.BackgroundColor.infoMuted,
    borderStyle: _designSystem.BorderStyle.none,
    borderRadius: _designSystem.BorderRadius.MD,
    label: t('new'),
    labelProps: {
      color: _designSystem.TextColor.primaryDefault,
      variant: _designSystem.TextVariant.bodySm
    },
    paddingLeft: 2,
    paddingRight: 2
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\notifications\\NewFeatureTag.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\index.js", {"./notifications":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notifications.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cnotifications%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _notifications.default;
  }
});
var _notifications = _interopRequireDefault(require("./notifications"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\notifications\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\erc1155-sent-received\\erc1155-sent-received.tsx", {"../../../../../shared/lib/translate":"D:\\code\\v\\metamask-extension\\shared\\lib\\translate.ts","../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../components/multichain":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../../../components/multichain/notification-list-item-icon/notification-list-item-icon":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-list-item-icon\\notification-list-item-icon.tsx","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/utils/notification.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\notification.util.ts","../../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../node-guard":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\node-guard.ts","../types/notifications/notifications":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\types\\notifications\\notifications.ts","@metamask/notification-services-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\notification-services-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cnotifications%5Cnotification-components%5Cerc1155-sent-received%5Cerc1155-sent-received.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.components = void 0;
var _react = _interopRequireDefault(require("react"));
var _notificationServicesController = require("@metamask/notification-services-controller");
var _translate = require("../../../../../shared/lib/translate");
var _nodeGuard = require("../node-guard");
var _notifications = require("../types/notifications/notifications");
var _util = require("../../../../helpers/utils/util");
var _notification = require("../../../../helpers/utils/notification.util");
var _designSystem = require("../../../../helpers/constants/design-system");
var _multichain = require("../../../../components/multichain");
var _notificationListItemIcon = require("../../../../components/multichain/notification-list-item-icon/notification-list-item-icon");
var _componentLibrary = require("../../../../components/component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const {
  TRIGGER_TYPES
} = _notificationServicesController.NotificationServicesController.Constants;
const isERC1155Notification = (0, _nodeGuard.isOfTypeNodeGuard)([TRIGGER_TYPES.ERC1155_RECEIVED, TRIGGER_TYPES.ERC1155_SENT]);
const isSent = n => n.type === TRIGGER_TYPES.ERC1155_SENT;
const title = n => isSent(n) ? (0, _translate.t)('notificationItemNFTSentTo') : (0, _translate.t)('notificationItemNFTReceivedFrom');
const getTitle = n => {
  const address = (0, _util.shortenAddress)(isSent(n) ? n.data.to : n.data.from);
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  const items = (0, _notification.createTextItems)([title(n) || '', address], _designSystem.TextVariant.bodySm);
  return items;
};
const getDescription = n => {
  var _n$data$nft;
  const items = (0, _notification.createTextItems)(
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  [((_n$data$nft = n.data.nft) === null || _n$data$nft === void 0 ? void 0 : _n$data$nft.collection.name) || ''], _designSystem.TextVariant.bodyMd);
  return items;
};
const components = exports.components = {
  guardFn: isERC1155Notification,
  item: ({
    notification,
    onClick
  }) => {
    var _notification$data$nf, _notification$data$nf2, _notification$data$nf3;
    return /*#__PURE__*/_react.default.createElement(_multichain.NotificationListItem, {
      id: notification.id,
      isRead: notification.isRead,
      icon: {
        type: (_notification$data$nf = notification.data.nft) !== null && _notification$data$nf !== void 0 && _notification$data$nf.image ? _notificationListItemIcon.NotificationListItemIconType.Nft : _notificationListItemIcon.NotificationListItemIconType.Token,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
        // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
        value: ((_notification$data$nf2 = notification.data.nft) === null || _notification$data$nf2 === void 0 ? void 0 : _notification$data$nf2.image) || 'http://foo.com/bar.png',
        badge: {
          icon: isSent(notification) ? _componentLibrary.IconName.Arrow2UpRight : _componentLibrary.IconName.Received,
          position: _componentLibrary.BadgeWrapperPosition.bottomRight
        }
      },
      title: getTitle(notification),
      description: getDescription(notification),
      createdAt: new Date(notification.createdAt)
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
      // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
      ,
      amount: ((_notification$data$nf3 = notification.data.nft) === null || _notification$data$nf3 === void 0 ? void 0 : _notification$data$nf3.token_id) || '',
      onClick: onClick
    });
  },
  details: {
    title: ({
      notification
    }) => {
      return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailTitle, {
        title: `${isSent(notification) ? (0, _translate.t)('notificationItemSent') : (0, _translate.t)('notificationItemReceived')} NFT`,
        date: (0, _notification.formatIsoDateString)(notification.createdAt)
      });
    },
    body: {
      type: _notifications.NotificationComponentType.OnChainBody,
      Image: ({
        notification
      }) => {
        var _notification$data$nf4, _notification$data$nf5, _notification$data$nf6;
        const {
          nativeCurrencyLogo,
          nativeCurrencyName
        } = (0, _notification.getNetworkDetailsByChainId)(notification.chain_id);
        return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailNft, {
          networkSrc: nativeCurrencyLogo
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
          // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
          ,
          tokenId: ((_notification$data$nf4 = notification.data.nft) === null || _notification$data$nf4 === void 0 ? void 0 : _notification$data$nf4.token_id) || ''
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
          // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
          ,
          tokenName: ((_notification$data$nf5 = notification.data.nft) === null || _notification$data$nf5 === void 0 ? void 0 : _notification$data$nf5.name) || ''
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
          // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
          ,
          tokenSrc: ((_notification$data$nf6 = notification.data.nft) === null || _notification$data$nf6 === void 0 ? void 0 : _notification$data$nf6.image) || '',
          networkName: nativeCurrencyName
        });
      },
      From: ({
        notification
      }) => /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailAddress, {
        side: `${(0, _translate.t)('notificationItemFrom')}${isSent(notification) ? ` (${(0, _translate.t)('you')})` : ''}`,
        address: notification.data.from
      }),
      To: ({
        notification
      }) => /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailAddress, {
        side: `${(0, _translate.t)('notificationItemTo')}${isSent(notification) ? '' : ` (${(0, _translate.t)('you')})`}`,
        address: notification.data.to
      }),
      Status: () => /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailInfo, {
        icon: {
          iconName: _componentLibrary.IconName.Check,
          color: _designSystem.TextColor.successDefault,
          backgroundColor: _designSystem.BackgroundColor.successMuted
        }
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
        // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
        ,
        label: (0, _translate.t)('notificationItemStatus') || ''
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
        // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
        ,
        detail: (0, _translate.t)('notificationItemConfirmed') || ''
      }),
      Asset: ({
        notification
      }) => {
        var _notification$data$nf7, _notification$data$nf8, _notification$data$nf9;
        const {
          nativeCurrencyLogo
        } = (0, _notification.getNetworkDetailsByChainId)(notification.chain_id);
        return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailCollection, {
          icon: {
            // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
            // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
            src: ((_notification$data$nf7 = notification.data.nft) === null || _notification$data$nf7 === void 0 ? void 0 : _notification$data$nf7.image) || '',
            badgeSrc: nativeCurrencyLogo
          }
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
          // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
          ,
          label: (0, _translate.t)('notificationItemCollection') || '',
          collection: `${(_notification$data$nf8 = notification.data.nft) === null || _notification$data$nf8 === void 0 ? void 0 : _notification$data$nf8.collection.name} (${(_notification$data$nf9 = notification.data.nft) === null || _notification$data$nf9 === void 0 ? void 0 : _notification$data$nf9.token_id})`
        });
      },
      Network: ({
        notification
      }) => {
        const {
          nativeCurrencyLogo,
          nativeCurrencyName
        } = (0, _notification.getNetworkDetailsByChainId)(notification.chain_id);
        return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailAsset, {
          icon: {
            src: nativeCurrencyLogo
          }
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
          // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
          ,
          label: (0, _translate.t)('notificationDetailNetwork') || '',
          detail: nativeCurrencyName
        });
      },
      NetworkFee: ({
        notification
      }) => {
        return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailNetworkFee, {
          notification: notification
        });
      }
    }
  },
  footer: {
    type: _notifications.NotificationComponentType.OnChainFooter,
    ScanLink: ({
      notification
    }) => {
      return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailBlockExplorerButton, {
        notification: notification,
        chainId: notification.chain_id,
        txHash: notification.tx_hash
      });
    }
  }
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\notifications\\notification-components\\erc1155-sent-received\\erc1155-sent-received.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\erc20-sent-received\\erc20-sent-received.tsx", {"../../../../../shared/lib/translate":"D:\\code\\v\\metamask-extension\\shared\\lib\\translate.ts","../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../components/multichain":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../../../components/multichain/notification-list-item-icon/notification-list-item-icon":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-list-item-icon\\notification-list-item-icon.tsx","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/utils/notification.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\notification.util.ts","../../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../node-guard":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\node-guard.ts","../types/notifications/notifications":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\types\\notifications\\notifications.ts","@metamask/notification-services-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\notification-services-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cnotifications%5Cnotification-components%5Cerc20-sent-received%5Cerc20-sent-received.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.components = void 0;
var _react = _interopRequireDefault(require("react"));
var _notificationServicesController = require("@metamask/notification-services-controller");
var _translate = require("../../../../../shared/lib/translate");
var _nodeGuard = require("../node-guard");
var _notifications = require("../types/notifications/notifications");
var _notificationListItemIcon = require("../../../../components/multichain/notification-list-item-icon/notification-list-item-icon");
var _util = require("../../../../helpers/utils/util");
var _notification = require("../../../../helpers/utils/notification.util");
var _multichain = require("../../../../components/multichain");
var _designSystem = require("../../../../helpers/constants/design-system");
var _componentLibrary = require("../../../../components/component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const {
  TRIGGER_TYPES
} = _notificationServicesController.NotificationServicesController.Constants;
const isERC20Notification = (0, _nodeGuard.isOfTypeNodeGuard)([TRIGGER_TYPES.ERC20_RECEIVED, TRIGGER_TYPES.ERC20_SENT]);
const isSent = n => n.type === TRIGGER_TYPES.ERC20_SENT;
const title = n => isSent(n) ? (0, _translate.t)('notificationItemSentTo') : (0, _translate.t)('notificationItemReceivedFrom');
const getTitle = n => {
  const address = (0, _util.shortenAddress)(isSent(n) ? n.data.to : n.data.from);
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  const items = (0, _notification.createTextItems)([title(n) || '', address], _designSystem.TextVariant.bodySm);
  return items;
};
const getDescription = n => {
  const items = (0, _notification.createTextItems)([n.data.token.name], _designSystem.TextVariant.bodyMd);
  return items;
};
const components = exports.components = {
  guardFn: isERC20Notification,
  item: ({
    notification,
    onClick
  }) => /*#__PURE__*/_react.default.createElement(_multichain.NotificationListItem, {
    id: notification.id,
    isRead: notification.isRead,
    icon: {
      type: _notificationListItemIcon.NotificationListItemIconType.Token,
      value: notification.data.token.image,
      badge: {
        icon: isSent(notification) ? _componentLibrary.IconName.Arrow2UpRight : _componentLibrary.IconName.Received,
        position: _componentLibrary.BadgeWrapperPosition.bottomRight
      }
    },
    title: getTitle(notification),
    description: getDescription(notification),
    createdAt: new Date(notification.createdAt),
    amount: `${(0, _notification.getAmount)(notification.data.token.amount, notification.data.token.decimals, {
      shouldEllipse: true
    })} ${notification.data.token.symbol}`,
    onClick: onClick
  }),
  details: {
    title: ({
      notification
    }) => /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailTitle, {
      title: `${isSent(notification) ? (0, _translate.t)('notificationItemSent') : (0, _translate.t)('notificationItemReceived')} ${notification.data.token.symbol}`,
      date: (0, _notification.formatIsoDateString)(notification.createdAt)
    }),
    body: {
      type: _notifications.NotificationComponentType.OnChainBody,
      From: ({
        notification
      }) => /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailAddress, {
        side: `${(0, _translate.t)('notificationItemFrom')}${isSent(notification) ? ` (${(0, _translate.t)('you')})` : ''}`,
        address: notification.data.from
      }),
      To: ({
        notification
      }) => /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailAddress, {
        side: `${(0, _translate.t)('notificationItemTo')}${isSent(notification) ? '' : ` (${(0, _translate.t)('you')})`}`,
        address: notification.data.to
      }),
      Status: ({
        notification
      }) => /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailInfo, {
        icon: {
          iconName: _componentLibrary.IconName.Check,
          color: _designSystem.TextColor.successDefault,
          backgroundColor: _designSystem.BackgroundColor.successMuted
        }
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
        // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
        ,
        label: (0, _translate.t)('notificationItemStatus') || ''
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
        // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
        ,
        detail: (0, _translate.t)('notificationItemConfirmed') || '',
        action: /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailCopyButton, {
          notification: notification,
          text: notification.tx_hash
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
          // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
          ,
          displayText: (0, _translate.t)('notificationItemTransactionId') || ''
        })
      }),
      Asset: ({
        notification
      }) => {
        const {
          nativeCurrencyLogo
        } = (0, _notification.getNetworkDetailsByChainId)(notification.chain_id);
        return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailAsset, {
          icon: {
            src: notification.data.token.image,
            badge: {
              src: nativeCurrencyLogo,
              position: _componentLibrary.BadgeWrapperPosition.topRight
            }
          }
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
          // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
          ,
          label: (0, _translate.t)('asset') || '',
          detail: notification.data.token.symbol,
          fiatValue: `$${(0, _notification.getUsdAmount)(notification.data.token.amount, notification.data.token.decimals, notification.data.token.usd)}`,
          value: `${(0, _notification.getAmount)(notification.data.token.amount, notification.data.token.decimals, {
            shouldEllipse: true
          })} ${notification.data.token.symbol}`
        });
      },
      Network: ({
        notification
      }) => {
        const {
          nativeCurrencyLogo,
          nativeCurrencyName
        } = (0, _notification.getNetworkDetailsByChainId)(notification.chain_id);
        return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailAsset, {
          icon: {
            src: nativeCurrencyLogo
          }
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
          // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
          ,
          label: (0, _translate.t)('notificationDetailNetwork') || '',
          detail: nativeCurrencyName
        });
      },
      NetworkFee: ({
        notification
      }) => {
        return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailNetworkFee, {
          notification: notification
        });
      }
    }
  },
  footer: {
    type: _notifications.NotificationComponentType.OnChainFooter,
    ScanLink: ({
      notification
    }) => {
      return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailBlockExplorerButton, {
        notification: notification,
        chainId: notification.chain_id,
        txHash: notification.tx_hash
      });
    }
  }
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\notifications\\notification-components\\erc20-sent-received\\erc20-sent-received.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\erc721-sent-received\\erc721-sent-received.tsx", {"../../../../../shared/lib/translate":"D:\\code\\v\\metamask-extension\\shared\\lib\\translate.ts","../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../components/multichain":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../../../components/multichain/notification-list-item-icon/notification-list-item-icon":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-list-item-icon\\notification-list-item-icon.tsx","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/utils/notification.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\notification.util.ts","../../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../node-guard":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\node-guard.ts","../types/notifications/notifications":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\types\\notifications\\notifications.ts","@metamask/notification-services-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\notification-services-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cnotifications%5Cnotification-components%5Cerc721-sent-received%5Cerc721-sent-received.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.components = void 0;
var _react = _interopRequireDefault(require("react"));
var _notificationServicesController = require("@metamask/notification-services-controller");
var _translate = require("../../../../../shared/lib/translate");
var _nodeGuard = require("../node-guard");
var _notifications = require("../types/notifications/notifications");
var _util = require("../../../../helpers/utils/util");
var _notification = require("../../../../helpers/utils/notification.util");
var _designSystem = require("../../../../helpers/constants/design-system");
var _multichain = require("../../../../components/multichain");
var _notificationListItemIcon = require("../../../../components/multichain/notification-list-item-icon/notification-list-item-icon");
var _componentLibrary = require("../../../../components/component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const {
  TRIGGER_TYPES
} = _notificationServicesController.NotificationServicesController.Constants;
const isERC721Notification = (0, _nodeGuard.isOfTypeNodeGuard)([TRIGGER_TYPES.ERC721_RECEIVED, TRIGGER_TYPES.ERC721_SENT]);
const isSent = n => n.type === TRIGGER_TYPES.ERC721_SENT;
const title = n => isSent(n) ? (0, _translate.t)('notificationItemNFTSentTo') : (0, _translate.t)('notificationItemNFTReceivedFrom');
const getTitle = n => {
  const address = (0, _util.shortenAddress)(isSent(n) ? n.data.to : n.data.from);
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  const items = (0, _notification.createTextItems)([title(n) || '', address], _designSystem.TextVariant.bodySm);
  return items;
};
const getDescription = n => {
  const items = (0, _notification.createTextItems)([n.data.nft.collection.name], _designSystem.TextVariant.bodyMd);
  return items;
};
const components = exports.components = {
  guardFn: isERC721Notification,
  item: ({
    notification,
    onClick
  }) => {
    return /*#__PURE__*/_react.default.createElement(_multichain.NotificationListItem, {
      id: notification.id,
      isRead: notification.isRead,
      icon: {
        type: _notificationListItemIcon.NotificationListItemIconType.Nft,
        value: notification.data.nft.image,
        badge: {
          icon: isSent(notification) ? _componentLibrary.IconName.Arrow2UpRight : _componentLibrary.IconName.Received,
          position: _componentLibrary.BadgeWrapperPosition.bottomRight
        }
      },
      title: getTitle(notification),
      description: getDescription(notification),
      createdAt: new Date(notification.createdAt),
      amount: `#${notification.data.nft.token_id}`,
      onClick: onClick
    });
  },
  details: {
    title: ({
      notification
    }) => {
      return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailTitle, {
        title: `${isSent(notification) ? (0, _translate.t)('notificationItemSent') : (0, _translate.t)('notificationItemReceived')} NFT`,
        date: (0, _notification.formatIsoDateString)(notification.createdAt)
      });
    },
    body: {
      type: _notifications.NotificationComponentType.OnChainBody,
      Image: ({
        notification
      }) => {
        const {
          nativeCurrencyLogo,
          nativeCurrencyName
        } = (0, _notification.getNetworkDetailsByChainId)(notification.chain_id);
        return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailNft, {
          networkSrc: nativeCurrencyLogo,
          tokenId: notification.data.nft.token_id,
          tokenName: notification.data.nft.name,
          tokenSrc: notification.data.nft.image,
          networkName: nativeCurrencyName
        });
      },
      From: ({
        notification
      }) => /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailAddress, {
        side: `${(0, _translate.t)('notificationItemFrom')}${isSent(notification) ? ` (${(0, _translate.t)('you')})` : ''}`,
        address: notification.data.from
      }),
      To: ({
        notification
      }) => /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailAddress, {
        side: `${(0, _translate.t)('notificationItemTo')}${isSent(notification) ? '' : ` (${(0, _translate.t)('you')})`}`,
        address: notification.data.to
      }),
      Status: () => /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailInfo, {
        icon: {
          iconName: _componentLibrary.IconName.Check,
          color: _designSystem.TextColor.successDefault,
          backgroundColor: _designSystem.BackgroundColor.successMuted
        }
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
        // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
        ,
        label: (0, _translate.t)('notificationItemStatus') || ''
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
        // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
        ,
        detail: (0, _translate.t)('notificationItemConfirmed') || ''
      }),
      Asset: ({
        notification
      }) => {
        const {
          nativeCurrencyLogo
        } = (0, _notification.getNetworkDetailsByChainId)(notification.chain_id);
        return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailCollection, {
          icon: {
            src: notification.data.nft.image,
            badgeSrc: nativeCurrencyLogo
          }
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
          // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
          ,
          label: (0, _translate.t)('notificationItemCollection') || '',
          collection: `${notification.data.nft.collection.name} (${notification.data.nft.token_id})`
        });
      },
      Network: ({
        notification
      }) => {
        const {
          nativeCurrencyLogo,
          nativeCurrencyName
        } = (0, _notification.getNetworkDetailsByChainId)(notification.chain_id);
        return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailAsset, {
          icon: {
            src: nativeCurrencyLogo
          }
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
          // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
          ,
          label: (0, _translate.t)('notificationDetailNetwork') || '',
          detail: nativeCurrencyName
        });
      },
      NetworkFee: ({
        notification
      }) => {
        return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailNetworkFee, {
          notification: notification
        });
      }
    }
  },
  footer: {
    type: _notifications.NotificationComponentType.OnChainFooter,
    ScanLink: ({
      notification
    }) => {
      return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailBlockExplorerButton, {
        notification: notification,
        chainId: notification.chain_id,
        txHash: notification.tx_hash
      });
    }
  }
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\notifications\\notification-components\\erc721-sent-received\\erc721-sent-received.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\eth-sent-received\\eth-sent-received.tsx", {"../../../../../shared/lib/translate":"D:\\code\\v\\metamask-extension\\shared\\lib\\translate.ts","../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../components/multichain":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../../../components/multichain/notification-list-item-icon/notification-list-item-icon":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-list-item-icon\\notification-list-item-icon.tsx","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/utils/notification.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\notification.util.ts","../../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../node-guard":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\node-guard.ts","../types/notifications/notifications":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\types\\notifications\\notifications.ts","@metamask/notification-services-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\notification-services-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cnotifications%5Cnotification-components%5Ceth-sent-received%5Ceth-sent-received.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.components = void 0;
var _react = _interopRequireDefault(require("react"));
var _notificationServicesController = require("@metamask/notification-services-controller");
var _translate = require("../../../../../shared/lib/translate");
var _nodeGuard = require("../node-guard");
var _notifications = require("../types/notifications/notifications");
var _util = require("../../../../helpers/utils/util");
var _notification = require("../../../../helpers/utils/notification.util");
var _designSystem = require("../../../../helpers/constants/design-system");
var _multichain = require("../../../../components/multichain");
var _notificationListItemIcon = require("../../../../components/multichain/notification-list-item-icon/notification-list-item-icon");
var _componentLibrary = require("../../../../components/component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const {
  TRIGGER_TYPES
} = _notificationServicesController.NotificationServicesController.Constants;
const isETHNotification = (0, _nodeGuard.isOfTypeNodeGuard)([TRIGGER_TYPES.ETH_RECEIVED, TRIGGER_TYPES.ETH_SENT]);
const isSent = n => n.type === TRIGGER_TYPES.ETH_SENT;
const title = n => isSent(n) ? (0, _translate.t)('notificationItemSentTo') : (0, _translate.t)('notificationItemReceivedFrom');
const getNativeCurrency = n => {
  const nativeCurrency = (0, _notification.getNetworkDetailsByChainId)(n.chain_id);
  return nativeCurrency;
};
const getTitle = n => {
  const address = (0, _util.shortenAddress)(isSent(n) ? n.data.to : n.data.from);
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  const items = (0, _notification.createTextItems)([title(n) || '', address], _designSystem.TextVariant.bodySm);
  return items;
};
const getDescription = n => {
  const {
    nativeCurrencySymbol
  } = getNativeCurrency(n);
  const items = (0, _notification.createTextItems)([nativeCurrencySymbol], _designSystem.TextVariant.bodyMd);
  return items;
};
const components = exports.components = {
  guardFn: isETHNotification,
  item: ({
    notification,
    onClick
  }) => {
    const {
      nativeCurrencySymbol,
      nativeCurrencyLogo
    } = getNativeCurrency(notification);
    return /*#__PURE__*/_react.default.createElement(_multichain.NotificationListItem, {
      id: notification.id,
      isRead: notification.isRead,
      icon: {
        type: _notificationListItemIcon.NotificationListItemIconType.Token,
        value: nativeCurrencyLogo,
        badge: {
          icon: isSent(notification) ? _componentLibrary.IconName.Arrow2UpRight : _componentLibrary.IconName.Received,
          position: _componentLibrary.BadgeWrapperPosition.bottomRight
        }
      },
      title: getTitle(notification),
      description: getDescription(notification),
      createdAt: new Date(notification.createdAt),
      amount: `${(0, _notification.formatAmount)(parseFloat(notification.data.amount.eth), {
        shouldEllipse: true
      })} ${nativeCurrencySymbol}`,
      onClick: onClick
    });
  },
  details: {
    title: ({
      notification
    }) => {
      const {
        nativeCurrencySymbol
      } = (0, _notification.getNetworkDetailsByChainId)(notification.chain_id);
      return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailTitle, {
        title: `${isSent(notification) ? (0, _translate.t)('notificationItemSent') : (0, _translate.t)('notificationItemReceived')} ${nativeCurrencySymbol}`,
        date: (0, _notification.formatIsoDateString)(notification.createdAt)
      });
    },
    body: {
      type: _notifications.NotificationComponentType.OnChainBody,
      From: ({
        notification
      }) => /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailAddress, {
        side: `${(0, _translate.t)('notificationItemFrom')}${isSent(notification) ? ` (${(0, _translate.t)('you')})` : ''}`,
        address: notification.data.from
      }),
      To: ({
        notification
      }) => /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailAddress, {
        side: `${(0, _translate.t)('notificationItemTo')}${isSent(notification) ? '' : ` (${(0, _translate.t)('you')})`}`,
        address: notification.data.to
      }),
      Status: ({
        notification
      }) => /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailInfo, {
        icon: {
          iconName: _componentLibrary.IconName.Check,
          color: _designSystem.TextColor.successDefault,
          backgroundColor: _designSystem.BackgroundColor.successMuted
        }
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
        // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
        ,
        label: (0, _translate.t)('notificationItemStatus') || ''
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
        // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
        ,
        detail: (0, _translate.t)('notificationItemConfirmed') || '',
        action: /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailCopyButton, {
          notification: notification,
          text: notification.tx_hash
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
          // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
          ,
          displayText: (0, _translate.t)('notificationItemTransactionId') || ''
        })
      }),
      Asset: ({
        notification
      }) => {
        const {
          nativeCurrencyLogo,
          nativeCurrencySymbol
        } = (0, _notification.getNetworkDetailsByChainId)(notification.chain_id);
        return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailAsset, {
          icon: {
            src: nativeCurrencyLogo,
            badge: {
              src: nativeCurrencyLogo,
              position: _componentLibrary.BadgeWrapperPosition.topRight
            }
          }
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
          // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
          ,
          label: (0, _translate.t)('asset') || '',
          detail: nativeCurrencySymbol,
          fiatValue: `$${(0, _notification.formatAmount)(parseFloat(notification.data.amount.usd), {
            shouldEllipse: true
          })}`,
          value: `${(0, _notification.formatAmount)(parseFloat(notification.data.amount.eth), {
            shouldEllipse: true
          })} ${nativeCurrencySymbol}`
        });
      },
      Network: ({
        notification
      }) => {
        const {
          nativeCurrencyLogo,
          nativeCurrencyName
        } = (0, _notification.getNetworkDetailsByChainId)(notification.chain_id);
        return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailAsset, {
          icon: {
            src: nativeCurrencyLogo
          }
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
          // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
          ,
          label: (0, _translate.t)('notificationDetailNetwork') || '',
          detail: nativeCurrencyName
        });
      },
      NetworkFee: ({
        notification
      }) => {
        return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailNetworkFee, {
          notification: notification
        });
      }
    }
  },
  footer: {
    type: _notifications.NotificationComponentType.OnChainFooter,
    ScanLink: ({
      notification
    }) => {
      return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailBlockExplorerButton, {
        notification: notification,
        chainId: notification.chain_id,
        txHash: notification.tx_hash
      });
    }
  }
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\notifications\\notification-components\\eth-sent-received\\eth-sent-received.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\feature-announcement\\annonucement-footer-buttons.tsx", {"../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../components/multichain":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cnotifications%5Cnotification-components%5Cfeature-announcement%5Cannonucement-footer-buttons.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExternalLinkButton = exports.ExtensionLinkButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _metametrics = require("../../../../../shared/constants/metametrics");
var _metametrics2 = require("../../../../contexts/metametrics");
var _multichain = require("../../../../components/multichain");
var _componentLibrary = require("../../../../components/component-library");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useAnalyticEventCallback = props => {
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const analyticsEvent = (0, _react.useCallback)(() => {
    trackEvent({
      category: _metametrics.MetaMetricsEventCategory.NotificationInteraction,
      event: _metametrics.MetaMetricsEventName.NotificationDetailClicked,
      properties: {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        notification_id: props.id,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        notification_type: props.type,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        clicked_item: props.clickType
      }
    });
  }, [props.clickType, props.id, props.type, trackEvent]);
  return analyticsEvent;
};
const ExtensionLinkButton = props => {
  const {
    notification
  } = props;
  const onClick = useAnalyticEventCallback({
    id: notification.id,
    type: notification.type,
    clickType: 'internal_link'
  });
  if (!notification.data.extensionLink) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailButton, {
    variant: _componentLibrary.ButtonVariant.Primary,
    text: notification.data.extensionLink.extensionLinkText,
    href: `/${notification.data.extensionLink.extensionLinkRoute}`
    // Even if the link is not external, it will open in a new tab
    // to avoid breaking the popup
    ,
    isExternal: true,
    onClick: onClick
  });
};
exports.ExtensionLinkButton = ExtensionLinkButton;
const ExternalLinkButton = props => {
  const {
    notification
  } = props;
  const onClick = useAnalyticEventCallback({
    id: notification.id,
    type: notification.type,
    clickType: 'external_link'
  });
  if (!notification.data.externalLink) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailButton, {
    variant: _componentLibrary.ButtonVariant.Secondary,
    text: notification.data.externalLink.externalLinkText,
    href: `${notification.data.externalLink.externalLinkUrl}`,
    isExternal: true,
    onClick: onClick
  });
};
exports.ExternalLinkButton = ExternalLinkButton;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\notifications\\notification-components\\feature-announcement\\annonucement-footer-buttons.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\feature-announcement\\feature-announcement.tsx", {"../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../components/multichain":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../../../components/multichain/notification-list-item-icon/notification-list-item-icon":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-list-item-icon\\notification-list-item-icon.tsx","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/utils/notification.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\notification.util.ts","../node-guard":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\node-guard.ts","../types/notifications/notifications":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\types\\notifications\\notifications.ts","./annonucement-footer-buttons":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\feature-announcement\\annonucement-footer-buttons.tsx","@metamask/notification-services-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\notification-services-controller\\dist\\index.cjs","dompurify":"D:\\code\\v\\metamask-extension\\node_modules\\dompurify\\dist\\purify.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cnotifications%5Cnotification-components%5Cfeature-announcement%5Cfeature-announcement.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.components = void 0;
var _react = _interopRequireDefault(require("react"));
var _notificationServicesController = require("@metamask/notification-services-controller");
var _dompurify = _interopRequireDefault(require("dompurify"));
var _nodeGuard = require("../node-guard");
var _notifications = require("../types/notifications/notifications");
var _notificationListItemIcon = require("../../../../components/multichain/notification-list-item-icon/notification-list-item-icon");
var _notification = require("../../../../helpers/utils/notification.util");
var _componentLibrary = require("../../../../components/component-library");
var _multichain = require("../../../../components/multichain");
var _designSystem = require("../../../../helpers/constants/design-system");
var _annonucementFooterButtons = require("./annonucement-footer-buttons");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// eslint-disable-next-line import/no-named-as-default

const purify = (0, _dompurify.default)(window);
const {
  TRIGGER_TYPES
} = _notificationServicesController.NotificationServicesController.Constants;
const isFeatureAnnouncementNotification = (0, _nodeGuard.isOfTypeNodeGuard)([TRIGGER_TYPES.FEATURES_ANNOUNCEMENT]);
const getTitle = n => {
  const items = (0, _notification.createTextItems)([n.data.title], _designSystem.TextVariant.bodySm);
  return items;
};
const getDescription = n => {
  const items = (0, _notification.createTextItems)([n.data.shortDescription], _designSystem.TextVariant.bodyMd);
  return items;
};
const components = exports.components = {
  guardFn: isFeatureAnnouncementNotification,
  item: ({
    notification,
    onClick
  }) => /*#__PURE__*/_react.default.createElement(_multichain.NotificationListItem, {
    id: notification.id,
    isRead: notification.isRead,
    icon: {
      type: _notificationListItemIcon.NotificationListItemIconType.Token,
      value: './images/product-announcement-logo.svg'
    },
    title: getTitle(notification),
    description: getDescription(notification),
    createdAt: new Date(notification.createdAt),
    onClick: onClick
  }),
  details: {
    title: ({
      notification
    }) => /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailTitle, {
      title: notification.data.title,
      date: (0, _notification.formatIsoDateString)(notification.createdAt)
    }),
    body: {
      type: _notifications.NotificationComponentType.AnnouncementBody,
      Image: ({
        notification
      }) => /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        display: _designSystem.Display.Block,
        width: _designSystem.BlockSize.Full,
        paddingLeft: 4,
        paddingRight: 4,
        paddingBottom: 4
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        as: "img",
        src: `https:${notification.data.image.url}?fm=jpg&fl=progressive&w=1000&q=80`,
        alt: notification.data.title,
        title: notification.data.title,
        display: _designSystem.Display.Block,
        justifyContent: _designSystem.JustifyContent.center,
        borderRadius: _designSystem.BorderRadius.XL,
        width: _designSystem.BlockSize.Full
      })),
      Description: ({
        notification
      }) => /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        paddingLeft: 4,
        paddingRight: 4
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        variant: _designSystem.TextVariant.bodyMd,
        as: "div"
        // TODO - we can replace the raw HTML string injection with react components
        ,
        dangerouslySetInnerHTML: {
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          __html: purify.sanitize(notification.data.longDescription)
        }
      }))
    }
  },
  footer: {
    type: _notifications.NotificationComponentType.AnnouncementFooter,
    ExtensionLink: _annonucementFooterButtons.ExtensionLinkButton,
    ExternalLink: _annonucementFooterButtons.ExternalLinkButton
  }
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\notifications\\notification-components\\feature-announcement\\feature-announcement.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\index.ts", {"./erc1155-sent-received/erc1155-sent-received":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\erc1155-sent-received\\erc1155-sent-received.tsx","./erc20-sent-received/erc20-sent-received":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\erc20-sent-received\\erc20-sent-received.tsx","./erc721-sent-received/erc721-sent-received":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\erc721-sent-received\\erc721-sent-received.tsx","./eth-sent-received/eth-sent-received":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\eth-sent-received\\eth-sent-received.tsx","./feature-announcement/feature-announcement":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\feature-announcement\\feature-announcement.tsx","./lido-stake-ready-to-be-withdrawn/lido-stake-ready-to-be-withdrawn":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\lido-stake-ready-to-be-withdrawn\\lido-stake-ready-to-be-withdrawn.tsx","./lido-withdrawal-requested/lido-withdrawal-requested":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\lido-withdrawal-requested\\lido-withdrawal-requested.tsx","./snap/snap":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\snap\\snap.tsx","./stake/stake":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\stake\\stake.tsx","./swap-completed/swap-completed":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\swap-completed\\swap-completed.tsx","@metamask/notification-services-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\notification-services-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cnotifications%5Cnotification-components%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasNotificationComponents = exports.TRIGGER_TYPES = exports.NotificationComponents = void 0;
var _notificationServicesController = require("@metamask/notification-services-controller");
var _erc20SentReceived = require("./erc20-sent-received/erc20-sent-received");
var _erc721SentReceived = require("./erc721-sent-received/erc721-sent-received");
var _erc1155SentReceived = require("./erc1155-sent-received/erc1155-sent-received");
var _ethSentReceived = require("./eth-sent-received/eth-sent-received");
var _featureAnnouncement = require("./feature-announcement/feature-announcement");
var _stake = require("./stake/stake");
var _swapCompleted = require("./swap-completed/swap-completed");
var _lidoWithdrawalRequested = require("./lido-withdrawal-requested/lido-withdrawal-requested");
var _lidoStakeReadyToBeWithdrawn = require("./lido-stake-ready-to-be-withdrawn/lido-stake-ready-to-be-withdrawn");
var _snap = require("./snap/snap");
const {
  TRIGGER_TYPES
} = _notificationServicesController.NotificationServicesController.Constants;

/**
 * Each notification component has a specific shape it follows.
 * however for interface consistency (and prevent intersections that cause `never` parameters), we are widening each notification component to a generic notification
 *
 * This does mean that you MUST check the guardFn before using a specific notification
 *
 * @param components - a specific set of notification components
 * @returns a generic set of notification component
 */

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/no-explicit-any, @typescript-eslint/naming-convention
exports.TRIGGER_TYPES = TRIGGER_TYPES;
const expandComponentsType = components => components;
const NotificationComponents = exports.NotificationComponents = {
  [TRIGGER_TYPES.ERC20_SENT]: expandComponentsType(_erc20SentReceived.components),
  [TRIGGER_TYPES.ERC20_RECEIVED]: expandComponentsType(_erc20SentReceived.components),
  [TRIGGER_TYPES.ERC721_SENT]: expandComponentsType(_erc721SentReceived.components),
  [TRIGGER_TYPES.ERC721_RECEIVED]: expandComponentsType(_erc721SentReceived.components),
  [TRIGGER_TYPES.ERC1155_SENT]: expandComponentsType(_erc1155SentReceived.components),
  [TRIGGER_TYPES.ERC1155_RECEIVED]: expandComponentsType(_erc1155SentReceived.components),
  [TRIGGER_TYPES.ETH_SENT]: expandComponentsType(_ethSentReceived.components),
  [TRIGGER_TYPES.ETH_RECEIVED]: expandComponentsType(_ethSentReceived.components),
  [TRIGGER_TYPES.FEATURES_ANNOUNCEMENT]: expandComponentsType(_featureAnnouncement.components),
  [TRIGGER_TYPES.ROCKETPOOL_STAKE_COMPLETED]: expandComponentsType(_stake.components),
  [TRIGGER_TYPES.ROCKETPOOL_UNSTAKE_COMPLETED]: expandComponentsType(_stake.components),
  [TRIGGER_TYPES.LIDO_STAKE_COMPLETED]: expandComponentsType(_stake.components),
  [TRIGGER_TYPES.LIDO_WITHDRAWAL_COMPLETED]: expandComponentsType(_stake.components),
  [TRIGGER_TYPES.LIDO_WITHDRAWAL_REQUESTED]: expandComponentsType(_lidoWithdrawalRequested.components),
  [TRIGGER_TYPES.METAMASK_SWAP_COMPLETED]: expandComponentsType(_swapCompleted.components),
  [TRIGGER_TYPES.LIDO_STAKE_READY_TO_BE_WITHDRAWN]: expandComponentsType(_lidoStakeReadyToBeWithdrawn.components),
  [TRIGGER_TYPES.SNAP]: expandComponentsType(_snap.components)
};
const hasNotificationComponents = t => t in NotificationComponents;
exports.hasNotificationComponents = hasNotificationComponents;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\notifications\\notification-components\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\lido-stake-ready-to-be-withdrawn\\lido-stake-ready-to-be-withdrawn.tsx", {"../../../../../shared/lib/translate":"D:\\code\\v\\metamask-extension\\shared\\lib\\translate.ts","../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../components/multichain":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../../../components/multichain/notification-list-item-icon/notification-list-item-icon":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-list-item-icon\\notification-list-item-icon.tsx","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/utils/notification.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\notification.util.ts","../node-guard":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\node-guard.ts","../types/notifications/notifications":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\types\\notifications\\notifications.ts","@metamask/notification-services-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\notification-services-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cnotifications%5Cnotification-components%5Clido-stake-ready-to-be-withdrawn%5Clido-stake-ready-to-be-withdrawn.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.components = void 0;
var _react = _interopRequireDefault(require("react"));
var _notificationServicesController = require("@metamask/notification-services-controller");
var _nodeGuard = require("../node-guard");
var _notifications = require("../types/notifications/notifications");
var _multichain = require("../../../../components/multichain");
var _translate = require("../../../../../shared/lib/translate");
var _notification = require("../../../../helpers/utils/notification.util");
var _designSystem = require("../../../../helpers/constants/design-system");
var _notificationListItemIcon = require("../../../../components/multichain/notification-list-item-icon/notification-list-item-icon");
var _componentLibrary = require("../../../../components/component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const {
  TRIGGER_TYPES
} = _notificationServicesController.NotificationServicesController.Constants;
const isLidoReadyWithDrawnNotification = (0, _nodeGuard.isOfTypeNodeGuard)([TRIGGER_TYPES.LIDO_STAKE_READY_TO_BE_WITHDRAWN]);
const getDescription = n => {
  const amount = (0, _notification.formatAmount)(parseFloat(n.data.staked_eth.amount), {
    shouldEllipse: true
  });
  const description =
  // @ts-expect-error: Expected 0-1 arguments, but got an array
  // eslint-disable-next-line @typescript-eslint/ban-ts-comment
  (0, _translate.t)('notificationItemLidoStakeReadyToBeWithdrawnMessage', [`${amount} ${n.data.staked_eth.symbol}`
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  ]) || '';
  const items = (0, _notification.createTextItems)([description], _designSystem.TextVariant.bodyMd);
  return items;
};
const getTitle = () => {
  const items = (0, _notification.createTextItems)(
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  [(0, _translate.t)('notificationItemLidoStakeReadyToBeWithdrawn') || ''], _designSystem.TextVariant.bodySm);
  return items;
};
const components = exports.components = {
  guardFn: isLidoReadyWithDrawnNotification,
  item: ({
    notification,
    onClick
  }) => {
    return /*#__PURE__*/_react.default.createElement(_multichain.NotificationListItem, {
      id: notification.trigger_id,
      isRead: notification.isRead,
      icon: {
        type: _notificationListItemIcon.NotificationListItemIconType.Token,
        value: notification.data.staked_eth.image,
        badge: {
          icon: _componentLibrary.IconName.Stake,
          position: _componentLibrary.BadgeWrapperPosition.bottomRight
        }
      },
      title: getTitle(),
      description: getDescription(notification),
      createdAt: new Date(notification.createdAt),
      onClick: onClick
    });
  },
  details: {
    title: ({
      notification
    }) => /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailTitle
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    , {
      title: (0, _translate.t)('notificationItemLidoStakeReadyToBeWithdrawn') || '',
      date: (0, _notification.formatIsoDateString)(notification.createdAt)
    }),
    body: {
      type: _notifications.NotificationComponentType.OnChainBody,
      Account: ({
        notification
      }) => {
        if (!notification.address) {
          return null;
        }
        return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailAddress
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
        // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
        , {
          side: (0, _translate.t)('account') || '',
          address: notification.address
        });
      },
      Status: () => /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailInfo, {
        icon: {
          iconName: _componentLibrary.IconName.Check,
          color: _designSystem.TextColor.successDefault,
          backgroundColor: _designSystem.BackgroundColor.successMuted
        }
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
        // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
        ,
        label: (0, _translate.t)('notificationItemStatus') || ''
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
        // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
        ,
        detail: (0, _translate.t)('notificationItemConfirmed') || ''
      }),
      Asset: ({
        notification
      }) => {
        const {
          nativeCurrencyLogo
        } = (0, _notification.getNetworkDetailsByChainId)(notification.chain_id);
        return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailAsset, {
          icon: {
            src: notification.data.staked_eth.image,
            badge: {
              src: nativeCurrencyLogo,
              position: _componentLibrary.BadgeWrapperPosition.topRight
            }
          }
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
          // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
          ,
          label: (0, _translate.t)('notificationItemLidoStakeReadyToBeWithdrawn') || '',
          detail: notification.data.staked_eth.symbol,
          fiatValue: `$${(0, _notification.formatAmount)(parseFloat(notification.data.staked_eth.usd), {
            shouldEllipse: true
          })}`,
          value: `${(0, _notification.formatAmount)(parseFloat(notification.data.staked_eth.amount), {
            shouldEllipse: true
          })} ${notification.data.staked_eth.symbol}`
        });
      },
      AssetReceived: ({
        notification
      }) => {
        const {
          nativeCurrencyLogo
        } = (0, _notification.getNetworkDetailsByChainId)(notification.chain_id);
        return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailAsset, {
          icon: {
            src: notification.data.staked_eth.image,
            badge: {
              src: nativeCurrencyLogo,
              position: _componentLibrary.BadgeWrapperPosition.topRight
            }
          }
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
          // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
          ,
          label: (0, _translate.t)('notificationItemStakingProvider') || '',
          detail: notification.data.staked_eth.symbol
        });
      }
    }
  },
  footer: {
    type: _notifications.NotificationComponentType.OnChainFooter,
    ScanLink: ({
      notification
    }) => {
      return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailBlockExplorerButton, {
        notification: notification,
        chainId: notification.chain_id,
        txHash: notification.tx_hash
      });
    }
  }
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\notifications\\notification-components\\lido-stake-ready-to-be-withdrawn\\lido-stake-ready-to-be-withdrawn.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\lido-withdrawal-requested\\lido-withdrawal-requested.tsx", {"../../../../../shared/lib/translate":"D:\\code\\v\\metamask-extension\\shared\\lib\\translate.ts","../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../components/multichain":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../../../components/multichain/notification-list-item-icon/notification-list-item-icon":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-list-item-icon\\notification-list-item-icon.tsx","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/utils/notification.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\notification.util.ts","../node-guard":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\node-guard.ts","../types/notifications/notifications":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\types\\notifications\\notifications.ts","@metamask/notification-services-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\notification-services-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cnotifications%5Cnotification-components%5Clido-withdrawal-requested%5Clido-withdrawal-requested.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.components = void 0;
var _react = _interopRequireDefault(require("react"));
var _notificationServicesController = require("@metamask/notification-services-controller");
var _nodeGuard = require("../node-guard");
var _notifications = require("../types/notifications/notifications");
var _notificationListItemIcon = require("../../../../components/multichain/notification-list-item-icon/notification-list-item-icon");
var _multichain = require("../../../../components/multichain");
var _notification = require("../../../../helpers/utils/notification.util");
var _translate = require("../../../../../shared/lib/translate");
var _designSystem = require("../../../../helpers/constants/design-system");
var _componentLibrary = require("../../../../components/component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const {
  TRIGGER_TYPES
} = _notificationServicesController.NotificationServicesController.Constants;
const isLidoWithdrawalRequestedNotification = (0, _nodeGuard.isOfTypeNodeGuard)([TRIGGER_TYPES.LIDO_WITHDRAWAL_REQUESTED]);
const getTitle = () => {
  const items = (0, _notification.createTextItems)(
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  [(0, _translate.t)('notificationItemUnStakingRequested') || ''], _designSystem.TextVariant.bodySm);
  return items;
};
const getDescription = n => {
  const amount = (0, _notification.getAmount)(n.data.stake_in.amount, n.data.stake_in.decimals, {
    shouldEllipse: true
  });
  const description =
  // @ts-expect-error: Expected 0-1 arguments, but got an array
  // eslint-disable-next-line @typescript-eslint/ban-ts-comment
  (0, _translate.t)('notificationItemLidoWithdrawalRequestedMessage', [`${amount} ${n.data.stake_in.symbol}`
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  ]) || '';
  const items = (0, _notification.createTextItems)([description], _designSystem.TextVariant.bodyMd);
  return items;
};
const components = exports.components = {
  guardFn: isLidoWithdrawalRequestedNotification,
  item: ({
    notification,
    onClick
  }) => {
    return /*#__PURE__*/_react.default.createElement(_multichain.NotificationListItem, {
      id: notification.id,
      isRead: notification.isRead,
      icon: {
        type: _notificationListItemIcon.NotificationListItemIconType.Token,
        value: notification.data.stake_in.image,
        badge: {
          icon: _componentLibrary.IconName.Stake,
          position: _componentLibrary.BadgeWrapperPosition.bottomRight
        }
      },
      title: getTitle(),
      description: getDescription(notification),
      createdAt: new Date(notification.createdAt),
      amount: `${(0, _notification.getAmount)(notification.data.stake_in.amount, notification.data.stake_in.decimals, {
        shouldEllipse: true
      })} ${notification.data.stake_in.symbol}`,
      onClick: onClick
    });
  },
  details: {
    title: ({
      notification
    }) => {
      return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailTitle
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
      // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
      , {
        title: (0, _translate.t)('notificationItemUnStakingRequested') || '',
        date: (0, _notification.formatIsoDateString)(notification.createdAt)
      });
    },
    body: {
      type: _notifications.NotificationComponentType.OnChainBody,
      Account: ({
        notification
      }) => {
        if (!notification.address) {
          return null;
        }
        return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailAddress
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
        // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
        , {
          side: (0, _translate.t)('account') || '',
          address: notification.address
        });
      },
      Status: ({
        notification
      }) => /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailInfo, {
        icon: {
          iconName: _componentLibrary.IconName.Check,
          color: _designSystem.TextColor.successDefault,
          backgroundColor: _designSystem.BackgroundColor.successMuted
        }
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
        // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
        ,
        label: (0, _translate.t)('notificationItemStatus') || ''
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
        // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
        ,
        detail: (0, _translate.t)('notificationItemConfirmed') || '',
        action: /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailCopyButton, {
          notification: notification,
          text: notification.tx_hash
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
          // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
          ,
          displayText: (0, _translate.t)('notificationItemTransactionId') || ''
        })
      }),
      Asset: ({
        notification
      }) => {
        const {
          nativeCurrencyLogo
        } = (0, _notification.getNetworkDetailsByChainId)(notification.chain_id);
        return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailAsset, {
          icon: {
            src: notification.data.stake_in.image,
            badge: {
              src: nativeCurrencyLogo,
              position: _componentLibrary.BadgeWrapperPosition.topRight
            }
          }
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
          // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
          ,
          label: (0, _translate.t)('notificationItemUnStakingRequested') || '',
          detail: notification.data.stake_in.symbol,
          fiatValue: `$${(0, _notification.getUsdAmount)(notification.data.stake_in.amount, notification.data.stake_in.decimals, notification.data.stake_in.usd)}`,
          value: `${(0, _notification.getAmount)(notification.data.stake_in.amount, notification.data.stake_in.decimals, {
            shouldEllipse: true
          })} ${notification.data.stake_in.symbol}`
        });
      },
      AssetReceived: ({
        notification
      }) => {
        const {
          nativeCurrencyLogo
        } = (0, _notification.getNetworkDetailsByChainId)(notification.chain_id);
        return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailAsset, {
          icon: {
            src: notification.data.stake_in.image,
            badge: {
              src: nativeCurrencyLogo,
              position: _componentLibrary.BadgeWrapperPosition.topRight
            }
          }
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
          // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
          ,
          label: (0, _translate.t)('notificationItemStakingProvider') || '',
          detail: "Lido-staked ETH"
        });
      }
    }
  },
  footer: {
    type: _notifications.NotificationComponentType.OnChainFooter,
    ScanLink: ({
      notification
    }) => {
      return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailBlockExplorerButton, {
        notification: notification,
        chainId: notification.chain_id,
        txHash: notification.tx_hash
      });
    }
  }
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\notifications\\notification-components\\lido-withdrawal-requested\\lido-withdrawal-requested.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\node-guard.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cnotifications%5Cnotification-components%5Cnode-guard.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isOfTypeNodeGuard = void 0;
const isOfTypeNodeGuard = types => n => types.includes(n.type);
exports.isOfTypeNodeGuard = isOfTypeNodeGuard;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\notifications\\notification-components\\node-guard.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\snap\\snap-footer-button.tsx", {"../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../components/app/snaps/snap-link-warning":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-link-warning\\index.js","../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../components/multichain":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../../hooks/snaps/useSnapNavigation":"D:\\code\\v\\metamask-extension\\ui\\hooks\\snaps\\useSnapNavigation.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cnotifications%5Cnotification-components%5Csnap%5Csnap-footer-button.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapFooterButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useSnapNavigation = _interopRequireDefault(require("../../../../hooks/snaps/useSnapNavigation"));
var _snapLinkWarning = _interopRequireDefault(require("../../../../components/app/snaps/snap-link-warning"));
var _multichain = require("../../../../components/multichain");
var _componentLibrary = require("../../../../components/component-library");
var _metametrics = require("../../../../contexts/metametrics");
var _metametrics2 = require("../../../../../shared/constants/metametrics");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SnapFooterButton = props => {
  var _data$detailedView;
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const {
    useSnapNavigate
  } = (0, _useSnapNavigation.default)();
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const data = props.notification.data;
  const footer = data === null || data === void 0 || (_data$detailedView = data.detailedView) === null || _data$detailedView === void 0 ? void 0 : _data$detailedView.footerLink;
  const handleModalClose = (0, _react.useCallback)(() => {
    setIsOpen(false);
  }, []);
  const onClick = (0, _react.useCallback)((href, isExternal) => {
    // Analytics
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.NotificationInteraction,
      event: _metametrics2.MetaMetricsEventName.NotificationDetailClicked,
      properties: {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        notification_id: props.notification.id,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        notification_type: props.notification.type,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        clicked_item: isExternal ? 'external_link' : 'internal_link'
      }
    });

    // Warning / Navigation
    if (isExternal) {
      setIsOpen(true);
    } else {
      useSnapNavigate(href);
    }
  }, [useSnapNavigate, props.notification.id, props.notification.type, trackEvent]);
  if (!footer) {
    return null;
  }
  const {
    href,
    text
  } = footer;
  const isMetaMaskUrl = href.startsWith('metamask:');
  const isExternal = !isMetaMaskUrl;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_snapLinkWarning.default, {
    isOpen: isOpen,
    onClose: handleModalClose,
    url: href
  }), /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailButton, {
    variant: _componentLibrary.ButtonVariant.Secondary,
    isExternal: isExternal,
    text: text,
    onClick: () => onClick(href, isExternal)
  }));
};
exports.SnapFooterButton = SnapFooterButton;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\notifications\\notification-components\\snap\\snap-footer-button.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\snap\\snap.tsx", {"../../../../components/app/snaps/snap-icon":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-icon\\index.ts","../../../../components/app/snaps/snap-ui-markdown":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-ui-markdown\\index.js","../../../../components/app/snaps/snap-ui-renderer":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-ui-renderer\\index.js","../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../components/multichain":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/utils/notification.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\notification.util.ts","../../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../../hooks/metamask-notifications/useNotifications":"D:\\code\\v\\metamask-extension\\ui\\hooks\\metamask-notifications\\useNotifications.ts","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../node-guard":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\node-guard.ts","../types/notifications/notifications":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\types\\notifications\\notifications.ts","./snap-footer-button":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\snap\\snap-footer-button.tsx","@metamask/notification-services-controller/notification-services":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\notification-services-controller\\dist\\NotificationServicesController\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cnotifications%5Cnotification-components%5Csnap%5Csnap.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.components = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _notificationServices = require("@metamask/notification-services-controller/notification-services");
var _multichain = require("../../../../components/multichain");
var _selectors = require("../../../../selectors");
var _util = require("../../../../helpers/utils/util");
var _notifications = require("../types/notifications/notifications");
var _notification = require("../../../../helpers/utils/notification.util");
var _snapUiRenderer = require("../../../../components/app/snaps/snap-ui-renderer");
var _designSystem = require("../../../../helpers/constants/design-system");
var _componentLibrary = require("../../../../components/component-library");
var _nodeGuard = require("../node-guard");
var _snapIcon = require("../../../../components/app/snaps/snap-icon");
var _useNotifications = require("../../../../hooks/metamask-notifications/useNotifications");
var _snapUiMarkdown = require("../../../../components/app/snaps/snap-ui-markdown");
var _snapFooterButton = require("./snap-footer-button");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const components = exports.components = {
  guardFn: (0, _nodeGuard.isOfTypeNodeGuard)([_notificationServices.TRIGGER_TYPES.SNAP]),
  item: ({
    notification,
    onClick
  }) => {
    const navigate = (0, _reactRouterDomV5Compat.useNavigate)();
    const snapsMetadata = (0, _reactRedux.useSelector)(_selectors.getSnapsMetadata);
    const snapsNameGetter = (0, _util.getSnapName)(snapsMetadata);
    const {
      markNotificationAsRead
    } = (0, _useNotifications.useMarkNotificationAsRead)();
    const handleSnapButton = () => {
      if (!notification.isRead) {
        markNotificationAsRead([{
          id: notification.id,
          type: notification.type,
          isRead: notification.isRead
        }]);
      }
      navigate((0, _util.getSnapRoute)(notification.data.origin));
    };
    return /*#__PURE__*/_react.default.createElement(_multichain.NotificationListItemSnap, {
      id: notification.id,
      snapId: notification.data.origin,
      isRead: notification.isRead,
      createdAt: new Date(notification.createdAt),
      title: {
        items: [{
          text: snapsNameGetter(notification.data.origin)
        }]
      },
      snapMessage: notification.data.message,
      handleSnapClick: onClick,
      handleSnapButton: handleSnapButton
    });
  },
  details: {
    title: ({
      notification
    }) => /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailTitle, {
      title: notification.data.detailedView.title,
      date: (0, _notification.formatIsoDateString)(notification.createdAt)
    }),
    body: {
      type: _notifications.NotificationComponentType.SnapBody,
      Content: ({
        notification
      }) => {
        const snapsMetadata = (0, _reactRedux.useSelector)(_selectors.getSnapsMetadata);
        const snapsNameGetter = (0, _util.getSnapName)(snapsMetadata);
        const snapId = notification.data.origin;
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
          display: _designSystem.Display.Flex,
          style: {
            borderBottom: '1px solid var(--color-border-muted)'
          },
          flexDirection: _designSystem.FlexDirection.Column,
          padding: [4, 2, 4, 4]
        }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
          display: _designSystem.Display.Flex,
          alignItems: _designSystem.AlignItems.center,
          paddingBottom: 2
        }, /*#__PURE__*/_react.default.createElement(_snapIcon.SnapIcon, {
          snapId: snapId,
          avatarSize: _componentLibrary.IconSize.Xl
        }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
          paddingLeft: 4,
          fontWeight: _designSystem.FontWeight.Medium
        }, snapsNameGetter(snapId))), /*#__PURE__*/_react.default.createElement(_snapUiMarkdown.SnapUIMarkdown, {
          markdown: true
        }, notification.data.message)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
          paddingLeft: 1,
          paddingRight: 1
        }, /*#__PURE__*/_react.default.createElement(_snapUiRenderer.SnapUIRenderer, {
          snapId: notification.data.origin,
          interfaceId: notification.data.detailedView.interfaceId,
          contentBackgroundColor: _designSystem.BackgroundColor.backgroundDefault
        })));
      }
    }
  },
  footer: {
    type: _notifications.NotificationComponentType.SnapFooter,
    Link: _snapFooterButton.SnapFooterButton
  }
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\notifications\\notification-components\\snap\\snap.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\stake\\stake.tsx", {"../../../../../shared/lib/translate":"D:\\code\\v\\metamask-extension\\shared\\lib\\translate.ts","../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../components/multichain":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../../../components/multichain/notification-list-item-icon/notification-list-item-icon":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-list-item-icon\\notification-list-item-icon.tsx","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/utils/notification.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\notification.util.ts","../node-guard":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\node-guard.ts","../types/notifications/notifications":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\types\\notifications\\notifications.ts","@metamask/notification-services-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\notification-services-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cnotifications%5Cnotification-components%5Cstake%5Cstake.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.components = void 0;
var _react = _interopRequireDefault(require("react"));
var _notificationServicesController = require("@metamask/notification-services-controller");
var _translate = require("../../../../../shared/lib/translate");
var _nodeGuard = require("../node-guard");
var _notifications = require("../types/notifications/notifications");
var _multichain = require("../../../../components/multichain");
var _notificationListItemIcon = require("../../../../components/multichain/notification-list-item-icon/notification-list-item-icon");
var _componentLibrary = require("../../../../components/component-library");
var _notification = require("../../../../helpers/utils/notification.util");
var _designSystem = require("../../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const {
  TRIGGER_TYPES
} = _notificationServicesController.NotificationServicesController.Constants;
const isStakeNotification = (0, _nodeGuard.isOfTypeNodeGuard)([TRIGGER_TYPES.ROCKETPOOL_STAKE_COMPLETED, TRIGGER_TYPES.ROCKETPOOL_UNSTAKE_COMPLETED, TRIGGER_TYPES.LIDO_STAKE_COMPLETED, TRIGGER_TYPES.LIDO_WITHDRAWAL_COMPLETED]);
const TITLE_MAP = {
  [TRIGGER_TYPES.LIDO_STAKE_COMPLETED]: (0, _translate.t)('notificationItemStaked'),
  [TRIGGER_TYPES.LIDO_WITHDRAWAL_COMPLETED]: (0, _translate.t)('notificationItemUnStakeCompleted'),
  [TRIGGER_TYPES.ROCKETPOOL_STAKE_COMPLETED]: (0, _translate.t)('notificationItemStakeCompleted'),
  [TRIGGER_TYPES.ROCKETPOOL_UNSTAKE_COMPLETED]: (0, _translate.t)('notificationItemUnStakeCompleted')
};
const DIRECTION_MAP = {
  [TRIGGER_TYPES.ROCKETPOOL_STAKE_COMPLETED]: 'staked',
  [TRIGGER_TYPES.ROCKETPOOL_UNSTAKE_COMPLETED]: 'unstaked',
  [TRIGGER_TYPES.LIDO_STAKE_COMPLETED]: 'staked',
  [TRIGGER_TYPES.LIDO_WITHDRAWAL_COMPLETED]: 'unstaked'
};
const STAKING_PROVIDER_MAP = {
  [TRIGGER_TYPES.LIDO_STAKE_COMPLETED]: 'Lido-staked ETH',
  [TRIGGER_TYPES.LIDO_WITHDRAWAL_COMPLETED]: 'Lido-staked ETH',
  [TRIGGER_TYPES.ROCKETPOOL_STAKE_COMPLETED]: 'Rocket Pool-staked ETH',
  [TRIGGER_TYPES.ROCKETPOOL_UNSTAKE_COMPLETED]: 'Rocket Pool-staked ETH'
};
const getTitle = n => {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  const items = (0, _notification.createTextItems)([TITLE_MAP[n.type] || ''], _designSystem.TextVariant.bodySm);
  return items;
};
const getDescription = n => {
  const direction = DIRECTION_MAP[n.type];
  const items = (0, _notification.createTextItems)([direction === 'staked' ? n.data.stake_out.symbol : n.data.stake_in.symbol], _designSystem.TextVariant.bodyMd);
  return items;
};
const components = exports.components = {
  guardFn: isStakeNotification,
  item: ({
    notification,
    onClick
  }) => {
    const direction = DIRECTION_MAP[notification.type];
    const stakingProp = direction === 'staked' ? notification.data.stake_in : notification.data.stake_out;
    const amount = (0, _notification.getAmount)(stakingProp.amount, stakingProp.decimals, {
      shouldEllipse: true
    });
    return /*#__PURE__*/_react.default.createElement(_multichain.NotificationListItem, {
      id: notification.id,
      isRead: notification.isRead,
      icon: {
        type: _notificationListItemIcon.NotificationListItemIconType.Token,
        value: notification.data.stake_out.image,
        badge: {
          icon: _componentLibrary.IconName.Stake,
          position: _componentLibrary.BadgeWrapperPosition.bottomRight
        }
      },
      title: getTitle(notification),
      description: getDescription(notification),
      createdAt: new Date(notification.createdAt),
      amount: `${amount} ${direction === 'staked' ? notification.data.stake_in.symbol : notification.data.stake_out.symbol}`,
      onClick: onClick
    });
  },
  details: {
    title: ({
      notification
    }) => {
      const direction = DIRECTION_MAP[notification.type];
      const title = direction === 'staked' ? `${(0, _translate.t)('notificationItemStaked')} ${notification.data.stake_in.symbol}` : `${(0, _translate.t)('notificationItemUnStaked')} ${notification.data.stake_in.symbol}`;
      return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailTitle, {
        title: title,
        date: (0, _notification.formatIsoDateString)(notification.createdAt)
      });
    },
    body: {
      type: _notifications.NotificationComponentType.OnChainBody,
      Account: ({
        notification
      }) => {
        if (!notification.address) {
          return null;
        }
        return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailAddress
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
        // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
        , {
          side: (0, _translate.t)('account') || '',
          address: notification.address
        });
      },
      Asset: ({
        notification
      }) => {
        const direction = DIRECTION_MAP[notification.type];
        const {
          nativeCurrencyLogo
        } = (0, _notification.getNetworkDetailsByChainId)(notification.chain_id);
        return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailAsset, {
          icon: {
            src: notification.data.stake_in.image,
            badge: {
              src: nativeCurrencyLogo,
              position: _componentLibrary.BadgeWrapperPosition.topRight
            }
          },
          label: direction === 'staked' ?
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
          // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
          (0, _translate.t)('notificationItemStaked') || '' :
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
          // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
          (0, _translate.t)('notificationItemUnStaked') || '',
          detail: notification.data.stake_in.symbol,
          fiatValue: `$${(0, _notification.getUsdAmount)(notification.data.stake_in.amount, notification.data.stake_in.decimals, notification.data.stake_in.usd)}`,
          value: `${(0, _notification.getAmount)(notification.data.stake_in.amount, notification.data.stake_in.decimals, {
            shouldEllipse: true
          })} ${notification.data.stake_in.symbol}`
        });
      },
      AssetReceived: ({
        notification
      }) => {
        const {
          nativeCurrencyLogo
        } = (0, _notification.getNetworkDetailsByChainId)(notification.chain_id);
        return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailAsset, {
          icon: {
            src: notification.data.stake_out.image,
            badge: {
              src: nativeCurrencyLogo,
              position: _componentLibrary.BadgeWrapperPosition.topRight
            }
          }
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
          // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
          ,
          label: (0, _translate.t)('notificationItemReceived') || '',
          detail: notification.data.stake_out.symbol,
          fiatValue: `$${(0, _notification.getUsdAmount)(notification.data.stake_out.amount, notification.data.stake_out.decimals, notification.data.stake_out.usd)}`,
          value: `${(0, _notification.getAmount)(notification.data.stake_out.amount, notification.data.stake_out.decimals, {
            shouldEllipse: true
          })} ${notification.data.stake_out.symbol}`
        });
      },
      Status: ({
        notification
      }) => /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailInfo, {
        icon: {
          iconName: _componentLibrary.IconName.Check,
          color: _designSystem.TextColor.successDefault,
          backgroundColor: _designSystem.BackgroundColor.successMuted
        }
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
        // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
        ,
        label: (0, _translate.t)('notificationItemStatus') || ''
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
        // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
        ,
        detail: (0, _translate.t)('notificationItemConfirmed') || '',
        action: /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailCopyButton, {
          notification: notification,
          text: notification.tx_hash
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
          // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
          ,
          displayText: (0, _translate.t)('notificationItemTransactionId') || ''
        })
      }),
      Provider: ({
        notification
      }) => {
        const direction = DIRECTION_MAP[notification.type];
        const provider = STAKING_PROVIDER_MAP[notification.type];
        return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailAsset, {
          icon: {
            src: notification.data.stake_out.image,
            badge: {
              src: direction === 'staked' ? notification.data.stake_out.image : notification.data.stake_in.image
            }
          }
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
          // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
          ,
          label: (0, _translate.t)('notificationItemStakingProvider') || '',
          detail: provider
        });
      },
      NetworkFee: ({
        notification
      }) => {
        return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailNetworkFee, {
          notification: notification
        });
      }
    }
  },
  footer: {
    type: _notifications.NotificationComponentType.OnChainFooter,
    ScanLink: ({
      notification
    }) => {
      return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailBlockExplorerButton, {
        notification: notification,
        chainId: notification.chain_id,
        txHash: notification.tx_hash
      });
    }
  }
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\notifications\\notification-components\\stake\\stake.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\swap-completed\\swap-completed.tsx", {"../../../../../shared/lib/translate":"D:\\code\\v\\metamask-extension\\shared\\lib\\translate.ts","../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../components/multichain":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../../../components/multichain/notification-list-item-icon/notification-list-item-icon":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-list-item-icon\\notification-list-item-icon.tsx","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/utils/notification.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\notification.util.ts","../node-guard":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\node-guard.ts","../types/notifications/notifications":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\types\\notifications\\notifications.ts","@metamask/notification-services-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\notification-services-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cnotifications%5Cnotification-components%5Cswap-completed%5Cswap-completed.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.components = void 0;
var _react = _interopRequireDefault(require("react"));
var _notificationServicesController = require("@metamask/notification-services-controller");
var _nodeGuard = require("../node-guard");
var _notifications = require("../types/notifications/notifications");
var _translate = require("../../../../../shared/lib/translate");
var _multichain = require("../../../../components/multichain");
var _notificationListItemIcon = require("../../../../components/multichain/notification-list-item-icon/notification-list-item-icon");
var _componentLibrary = require("../../../../components/component-library");
var _notification = require("../../../../helpers/utils/notification.util");
var _designSystem = require("../../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const {
  TRIGGER_TYPES
} = _notificationServicesController.NotificationServicesController.Constants;
const isSwapCompletedNotification = (0, _nodeGuard.isOfTypeNodeGuard)([TRIGGER_TYPES.METAMASK_SWAP_COMPLETED]);
const getTitle = n => {
  const items = (0, _notification.createTextItems)([
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  (0, _translate.t)('notificationItemSwapped') || '', n.data.token_in.symbol,
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  (0, _translate.t)('notificationItemSwappedFor') || ''], _designSystem.TextVariant.bodySm);
  return items;
};
const getDescription = n => {
  const items = (0, _notification.createTextItems)([n.data.token_out.symbol], _designSystem.TextVariant.bodyMd);
  return items;
};
const components = exports.components = {
  guardFn: isSwapCompletedNotification,
  item: ({
    notification,
    onClick
  }) => {
    return /*#__PURE__*/_react.default.createElement(_multichain.NotificationListItem, {
      id: notification.id,
      isRead: notification.isRead,
      icon: {
        type: _notificationListItemIcon.NotificationListItemIconType.Token,
        value: notification.data.token_out.image,
        badge: {
          icon: _componentLibrary.IconName.SwapHorizontal,
          position: _componentLibrary.BadgeWrapperPosition.bottomRight
        }
      },
      title: getTitle(notification),
      description: getDescription(notification),
      createdAt: new Date(notification.createdAt),
      amount: `${(0, _notification.getAmount)(notification.data.token_out.amount, notification.data.token_out.decimals, {
        shouldEllipse: true
      })} ${notification.data.token_out.symbol}`,
      onClick: onClick
    });
  },
  details: {
    title: ({
      notification
    }) => /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailTitle
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    , {
      title: `${(0, _translate.t)('notificationItemSwapped') || ''} ${notification.data.token_out.symbol}`,
      date: (0, _notification.formatIsoDateString)(notification.createdAt)
    }),
    body: {
      type: _notifications.NotificationComponentType.OnChainBody,
      Account: ({
        notification
      }) => {
        if (!notification.address) {
          return null;
        }
        return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailAddress
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
        // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
        , {
          side: (0, _translate.t)('account') || '',
          address: notification.address
        });
      },
      Asset: ({
        notification
      }) => {
        const {
          nativeCurrencyLogo
        } = (0, _notification.getNetworkDetailsByChainId)(notification.chain_id);
        return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailAsset, {
          icon: {
            src: notification.data.token_in.image,
            badge: {
              src: nativeCurrencyLogo,
              position: _componentLibrary.BadgeWrapperPosition.topRight
            }
          }
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
          // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
          ,
          label: (0, _translate.t)('notificationItemSwapped') || '',
          detail: notification.data.token_in.symbol,
          fiatValue: `$${(0, _notification.getUsdAmount)(notification.data.token_in.amount, notification.data.token_in.decimals, notification.data.token_in.usd)}`,
          value: `${(0, _notification.getAmount)(notification.data.token_in.amount, notification.data.token_in.decimals, {
            shouldEllipse: true
          })} ${notification.data.token_in.symbol}`
        });
      },
      AssetReceived: ({
        notification
      }) => {
        const {
          nativeCurrencyLogo
        } = (0, _notification.getNetworkDetailsByChainId)(notification.chain_id);
        return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailAsset, {
          icon: {
            src: notification.data.token_out.image,
            badge: {
              src: nativeCurrencyLogo,
              position: _componentLibrary.BadgeWrapperPosition.topRight
            }
          }
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
          // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
          ,
          label: (0, _translate.t)('notificationItemTo') || '',
          detail: notification.data.token_out.symbol,
          fiatValue: `$${(0, _notification.getUsdAmount)(notification.data.token_out.amount, notification.data.token_out.decimals, notification.data.token_out.usd)}`,
          value: `${(0, _notification.getAmount)(notification.data.token_out.amount, notification.data.token_out.decimals, {
            shouldEllipse: true
          })} ${notification.data.token_out.symbol}`
        });
      },
      Status: ({
        notification
      }) => /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailInfo, {
        icon: {
          iconName: _componentLibrary.IconName.Check,
          color: _designSystem.TextColor.successDefault,
          backgroundColor: _designSystem.BackgroundColor.successMuted
        }
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
        // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
        ,
        label: (0, _translate.t)('notificationItemStatus') || ''
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
        // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
        ,
        detail: (0, _translate.t)('notificationItemConfirmed') || '',
        action: /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailCopyButton, {
          notification: notification,
          text: notification.tx_hash
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
          // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
          ,
          displayText: (0, _translate.t)('notificationItemTransactionId') || ''
        })
      }),
      Network: ({
        notification
      }) => {
        const {
          nativeCurrencyName,
          nativeCurrencyLogo
        } = (0, _notification.getNetworkDetailsByChainId)(notification.chain_id);
        return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailAsset, {
          icon: {
            src: nativeCurrencyLogo
          }
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
          // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
          ,
          label: (0, _translate.t)('notificationItemNetwork') || '',
          detail: nativeCurrencyName
        });
      },
      Rate: ({
        notification
      }) => {
        return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailInfo, {
          icon: {
            iconName: _componentLibrary.IconName.SwapHorizontal,
            color: _designSystem.TextColor.infoDefault,
            backgroundColor: _designSystem.BackgroundColor.infoMuted
          }
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
          // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
          ,
          label: (0, _translate.t)('notificationItemRate') || '',
          detail: `1 ${notification.data.token_out.symbol} ≈ ${(1 / parseFloat(notification.data.rate)).toFixed(5)} ${notification.data.token_in.symbol}`
        });
      },
      NetworkFee: ({
        notification
      }) => {
        return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailNetworkFee, {
          notification: notification
        });
      }
    }
  },
  footer: {
    type: _notifications.NotificationComponentType.OnChainFooter,
    ScanLink: ({
      notification
    }) => {
      return /*#__PURE__*/_react.default.createElement(_multichain.NotificationDetailBlockExplorerButton, {
        notification: notification,
        chainId: notification.chain_id,
        txHash: notification.tx_hash
      });
    }
  }
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\notifications\\notification-components\\swap-completed\\swap-completed.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\types\\notifications\\notifications.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cnotifications%5Cnotification-components%5Ctypes%5Cnotifications%5Cnotifications.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationComponentType = void 0;
/**
 * NotificationFC is the shared component interface for all notification components
 */
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
let NotificationComponentType = exports.NotificationComponentType = /*#__PURE__*/function (NotificationComponentType) {
  NotificationComponentType["AnnouncementBody"] = "body_feature_announcement";
  NotificationComponentType["AnnouncementFooter"] = "footer_feature_announcement";
  NotificationComponentType["OnChainBody"] = "body_onchain_notification";
  NotificationComponentType["OnChainFooter"] = "footer_onchain_notification";
  NotificationComponentType["SnapBody"] = "body_snap_notification";
  NotificationComponentType["SnapFooter"] = "footer_snap_notification";
  return NotificationComponentType;
}({}); // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
/**
 * This is the object shape that contains all the components of the particular notification.
 * the `guardFn` can be used to narrow a wide notification into the specific notification required.
 */
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\notifications\\notification-components\\types\\notifications\\notifications.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notifications-list-item.tsx", {"../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../hooks/metamask-notifications/useNotifications":"D:\\code\\v\\metamask-extension\\ui\\hooks\\metamask-notifications\\useNotifications.ts","../../hooks/useNotificationTimeouts":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useNotificationTimeouts.ts","./notification-components":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notification-components\\index.ts","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cnotifications%5Cnotifications-list-item.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationsListItem = NotificationsListItem;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _utils = require("@metamask/utils");
var _metametrics = require("../../contexts/metametrics");
var _metametrics2 = require("../../../shared/constants/metametrics");
var _componentLibrary = require("../../components/component-library");
var _designSystem = require("../../helpers/constants/design-system");
var _routes = require("../../helpers/constants/routes");
var _useNotifications = require("../../hooks/metamask-notifications/useNotifications");
var _useNotificationTimeouts = require("../../hooks/useNotificationTimeouts");
var _notificationComponents = require("./notification-components");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function NotificationsListItem({
  notification
}) {
  const navigate = (0, _reactRouterDomV5Compat.useNavigate)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const {
    setNotificationTimeout
  } = (0, _useNotificationTimeouts.useSnapNotificationTimeouts)();
  const {
    markNotificationAsRead
  } = (0, _useNotifications.useMarkNotificationAsRead)();
  const handleNotificationClick = (0, _react.useCallback)(() => {
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.NotificationInteraction,
      event: _metametrics2.MetaMetricsEventName.NotificationClicked,
      properties: {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        notification_id: notification.id,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        notification_type: notification.type,
        ...('chain_id' in notification && {
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          chain_id: notification.chain_id
        }),
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        previously_read: notification.isRead
      }
    });
    markNotificationAsRead([{
      id: notification.id,
      type: notification.type,
      isRead: notification.isRead
    }]);
    if (notification.type === _notificationComponents.TRIGGER_TYPES.SNAP && !(0, _utils.hasProperty)(notification.data, 'detailedView')) {
      setNotificationTimeout(notification.id);
      return;
    }
    navigate(`${_routes.NOTIFICATIONS_ROUTE}/${notification.id}`);
  }, [notification, markNotificationAsRead, navigate]);
  if (!(0, _notificationComponents.hasNotificationComponents)(notification.type)) {
    return null;
  }
  const ncs = _notificationComponents.NotificationComponents[notification.type];
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    width: _designSystem.BlockSize.Full,
    "data-testid": `notification-list-item-${notification.id}`
  }, /*#__PURE__*/_react.default.createElement(ncs.item, {
    notification: notification,
    onClick: handleNotificationClick
  }));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\notifications\\notifications-list-item.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notifications-list-placeholder.tsx", {"../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cnotifications%5Cnotifications-list-placeholder.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationsPlaceholder = NotificationsPlaceholder;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../components/component-library");
var _designSystem = require("../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function NotificationsPlaceholder({
  title,
  text
}) {
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    height: _designSystem.BlockSize.Full,
    width: _designSystem.BlockSize.Full,
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.center,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 2,
    "data-testid": "notifications-list-placeholder"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.Notification,
    size: _componentLibrary.IconSize.Xl
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingSm
  }, title), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    textAlign: _designSystem.TextAlign.Center
  }, text));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\notifications\\notifications-list-placeholder.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notifications-list-read-all-button.tsx", {"../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../hooks/metamask-notifications/useNotifications":"D:\\code\\v\\metamask-extension\\ui\\hooks\\metamask-notifications\\useNotifications.ts","../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../hooks/useNotificationTimeouts":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useNotificationTimeouts.ts","@metamask/notification-services-controller/notification-services":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\notification-services-controller\\dist\\NotificationServicesController\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cnotifications%5Cnotifications-list-read-all-button.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationsListReadAllButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _notificationServices = require("@metamask/notification-services-controller/notification-services");
var _metametrics = require("../../contexts/metametrics");
var _metametrics2 = require("../../../shared/constants/metametrics");
var _useI18nContext = require("../../hooks/useI18nContext");
var _useNotifications = require("../../hooks/metamask-notifications/useNotifications");
var _componentLibrary = require("../../components/component-library");
var _designSystem = require("../../helpers/constants/design-system");
var _useNotificationTimeouts = require("../../hooks/useNotificationTimeouts");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NotificationsListReadAllButton = ({
  notifications
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    markNotificationAsRead
  } = (0, _useNotifications.useMarkNotificationAsRead)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const {
    setNotificationTimeout
  } = (0, _useNotificationTimeouts.useSnapNotificationTimeouts)();
  const handleOnClick = () => {
    let notificationsRead = [];
    if (notifications && notifications.length > 0) {
      notificationsRead = notifications.filter(notification => (notification === null || notification === void 0 ? void 0 : notification.id) !== undefined && !notification.isRead).map(notification => ({
        id: notification.id,
        type: notification.type,
        isRead: notification.isRead
      }));
      notificationsRead.filter(notification => notification.type === _notificationServices.TRIGGER_TYPES.SNAP).forEach(snapNotification => setNotificationTimeout(snapNotification.id));
    }
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.NotificationInteraction,
      event: _metametrics2.MetaMetricsEventName.MarkAllNotificationsRead
    });

    // Mark all metamask notifications as read
    markNotificationAsRead(notificationsRead);
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 4,
    paddingRight: 4,
    paddingTop: 4,
    paddingBottom: 4,
    className: "notifications__list__read__all__button"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    onClick: handleOnClick,
    variant: _componentLibrary.ButtonVariant.Primary,
    width: _designSystem.BlockSize.Full,
    "data-testid": "notifications-list-read-all-button"
  }, t('notificationsMarkAllAsRead')));
};
exports.NotificationsListReadAllButton = NotificationsListReadAllButton;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\notifications\\notifications-list-read-all-button.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notifications-list-turn-on-notifications.tsx", {"../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../contexts/metamask-notifications/metamask-notifications":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metamask-notifications\\metamask-notifications.tsx","../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../hooks/metamask-notifications/useNotifications":"D:\\code\\v\\metamask-extension\\ui\\hooks\\metamask-notifications\\useNotifications.ts","../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../selectors/metamask-notifications/metamask-notifications":"D:\\code\\v\\metamask-extension\\ui\\selectors\\metamask-notifications\\metamask-notifications.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cnotifications%5Cnotifications-list-turn-on-notifications.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationsListTurnOnNotifications = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _useI18nContext = require("../../hooks/useI18nContext");
var _metametrics = require("../../contexts/metametrics");
var _metametrics2 = require("../../../shared/constants/metametrics");
var _useNotifications = require("../../hooks/metamask-notifications/useNotifications");
var _metamaskNotifications = require("../../selectors/metamask-notifications/metamask-notifications");
var _metamaskNotifications2 = require("../../contexts/metamask-notifications/metamask-notifications");
var _componentLibrary = require("../../components/component-library");
var _designSystem = require("../../helpers/constants/design-system");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NotificationsListTurnOnNotifications = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const {
    listNotifications
  } = (0, _metamaskNotifications2.useMetamaskNotificationsContext)();
  const {
    enableNotifications,
    error: errorEnableNotifications
  } = (0, _useNotifications.useEnableNotifications)();
  const error = errorEnableNotifications;
  const isUpdatingMetamaskNotifications = (0, _reactRedux.useSelector)(_metamaskNotifications.getIsUpdatingMetamaskNotifications);
  const [loading, setLoading] = (0, _react.useState)(isUpdatingMetamaskNotifications || false);
  (0, _react.useEffect)(() => {
    setLoading(isUpdatingMetamaskNotifications);
  }, [isUpdatingMetamaskNotifications]);
  const handleTurnOnNotifications = async () => {
    await enableNotifications();
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.NotificationInteraction,
      event: _metametrics2.MetaMetricsEventName.EnablingNotifications
    });
    if (!error && !isUpdatingMetamaskNotifications) {
      listNotifications();
    }
  };
  const privacyLink = /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "a",
    href: "https://metamask.io/privacy.html",
    target: "_blank",
    rel: "noopener noreferrer",
    key: "privacy-link",
    color: _designSystem.TextColor.infoDefault
  }, t('turnOnMetamaskNotificationsMessagePrivacyLink'));
  const strongText = /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "span",
    fontWeight: _designSystem.FontWeight.Bold,
    key: "strong-text"
  }, t('turnOnMetamaskNotificationsMessagePrivacyBold'));
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Container, {
    maxWidth: _componentLibrary.ContainerMaxWidth.Sm,
    height: _designSystem.BlockSize.Full,
    margin: "auto",
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.center,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 4,
    "data-testid": "notifications-list-turn-on-notifications",
    textAlign: _designSystem.TextAlign.Center,
    paddingLeft: 4,
    paddingRight: 4,
    paddingTop: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingSm
  }, t('metamaskNotificationsAreOff')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    as: "img",
    src: "./images/turn-on-metamask-notifications.png",
    width: _designSystem.BlockSize.Full,
    borderRadius: _designSystem.BorderRadius.MD
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "p"
  }, t('turnOnMetamaskNotificationsMessageSecond', [privacyLink])), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "p"
  }, t('turnOnMetamaskNotificationsMessageThird', [strongText])), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  , {
    onClick: () => handleTurnOnNotifications(),
    size: _componentLibrary.ButtonSize.Md,
    disabled: loading,
    loading: loading
  }, t('turnOnMetamaskNotificationsButton')), error && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "p",
    color: _designSystem.TextColor.errorDefault
  }, t('turnOnMetamaskNotificationsError'))));
};
exports.NotificationsListTurnOnNotifications = NotificationsListTurnOnNotifications;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\notifications\\notifications-list-turn-on-notifications.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notifications-list.tsx", {"../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../components/ui/icon/preloader/preloader-icon.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\icon\\preloader\\preloader-icon.component.js","../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../selectors/metamask-notifications/metamask-notifications":"D:\\code\\v\\metamask-extension\\ui\\selectors\\metamask-notifications\\metamask-notifications.ts","./notifications-list-item":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notifications-list-item.tsx","./notifications-list-placeholder":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notifications-list-placeholder.tsx","./notifications-list-read-all-button":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notifications-list-read-all-button.tsx","./notifications-list-turn-on-notifications":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notifications-list-turn-on-notifications.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cnotifications%5Cnotifications-list.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationsList = NotificationsList;
exports.TAB_KEYS = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _componentLibrary = require("../../components/component-library");
var _designSystem = require("../../helpers/constants/design-system");
var _preloaderIcon = _interopRequireDefault(require("../../components/ui/icon/preloader/preloader-icon.component"));
var _metamaskNotifications = require("../../selectors/metamask-notifications/metamask-notifications");
var _useI18nContext = require("../../hooks/useI18nContext");
var _notificationsListPlaceholder = require("./notifications-list-placeholder");
var _notificationsListTurnOnNotifications = require("./notifications-list-turn-on-notifications");
var _notificationsListItem = require("./notifications-list-item");
var _notificationsListReadAllButton = require("./notifications-list-read-all-button");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// NOTE - Tab filters could change once we support more notifications.
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
let TAB_KEYS = exports.TAB_KEYS = /*#__PURE__*/function (TAB_KEYS) {
  TAB_KEYS["ALL"] = "notifications-all-tab";
  TAB_KEYS["WALLET"] = "notifications-wallet-tab";
  TAB_KEYS["WEB3"] = "notifications-other-tab";
  return TAB_KEYS;
}({}); // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function LoadingContent() {
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    height: _designSystem.BlockSize.Full,
    width: _designSystem.BlockSize.Full,
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.center,
    flexDirection: _designSystem.FlexDirection.Column,
    "data-testid": "notifications-list-loading"
  }, /*#__PURE__*/_react.default.createElement(_preloaderIcon.default, {
    size: 36
  }));
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function EmptyContent() {
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_notificationsListPlaceholder.NotificationsPlaceholder, {
    title: t('notificationsPageEmptyTitle'),
    text: t('notificationsPageNoNotificationsContent')
  });
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function ErrorContent() {
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_notificationsListPlaceholder.NotificationsPlaceholder, {
    title: t('notificationsPageErrorTitle'),
    text: t('notificationsPageErrorContent')
  });
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function NotificationItem(props) {
  const {
    notification
  } = props;
  return /*#__PURE__*/_react.default.createElement(_notificationsListItem.NotificationsListItem, {
    notification: notification
  });
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function NotificationsListStates({
  activeTab,
  notifications,
  isLoading,
  isError
}) {
  const isMetamaskNotificationsEnabled = (0, _reactRedux.useSelector)(_metamaskNotifications.selectIsMetamaskNotificationsEnabled);

  // Case when a user has not enabled wallet notifications yet
  if (activeTab === TAB_KEYS.WALLET && !isMetamaskNotificationsEnabled) {
    return /*#__PURE__*/_react.default.createElement(_notificationsListTurnOnNotifications.NotificationsListTurnOnNotifications, null);
  }

  // Loading State
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(LoadingContent, null);
  }

  // Error State
  if (isError) {
    return /*#__PURE__*/_react.default.createElement(ErrorContent, null);
  }
  if (notifications.length === 0) {
    return /*#__PURE__*/_react.default.createElement(EmptyContent, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, notifications.map(notification => /*#__PURE__*/_react.default.createElement(NotificationItem, {
    key: notification.id,
    notification: notification
  })));
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function NotificationsList(props) {
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    "data-testid": "notifications-list",
    height: _designSystem.BlockSize.Full,
    width: _designSystem.BlockSize.Full,
    className: "notifications__list"
  }, /*#__PURE__*/_react.default.createElement(NotificationsListStates, props), props.notifications.length > 0 && props.notificationsCount > 0 ? /*#__PURE__*/_react.default.createElement(_notificationsListReadAllButton.NotificationsListReadAllButton, {
    notifications: props.notifications
  }) : null);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\notifications\\notifications-list.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notifications.tsx", {"../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../components/multichain":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../components/multichain/pages/page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\index.ts","../../components/ui/tabs":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tabs\\index.ts","../../contexts/metamask-notifications/metamask-notifications":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metamask-notifications\\metamask-notifications.tsx","../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../hooks/metamask-notifications/useCounter":"D:\\code\\v\\metamask-extension\\ui\\hooks\\metamask-notifications\\useCounter.tsx","../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../selectors/metamask-notifications/metamask-notifications":"D:\\code\\v\\metamask-extension\\ui\\selectors\\metamask-notifications\\metamask-notifications.ts","../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./NewFeatureTag":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\NewFeatureTag.tsx","./notifications-list":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\notifications-list.tsx","@metamask/notification-services-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\notification-services-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cnotifications%5Cnotifications.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Notifications;
exports.filterNotifications = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _notificationServicesController = require("@metamask/notification-services-controller");
var _useI18nContext = require("../../hooks/useI18nContext");
var _componentLibrary = require("../../components/component-library");
var _tabs = require("../../components/ui/tabs");
var _routes = require("../../helpers/constants/routes");
var _multichain = require("../../components/multichain");
var _page = require("../../components/multichain/pages/page");
var _metamaskNotifications = require("../../contexts/metamask-notifications/metamask-notifications");
var _useCounter = require("../../hooks/metamask-notifications/useCounter");
var _selectors = require("../../selectors");
var _metamaskNotifications2 = require("../../selectors/metamask-notifications/metamask-notifications");
var _designSystem = require("../../helpers/constants/design-system");
var _actions = require("../../store/actions");
var _notificationsList = require("./notifications-list");
var _NewFeatureTag = require("./NewFeatureTag");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  TRIGGER_TYPES,
  TRIGGER_TYPES_WALLET_SET
} = _notificationServicesController.NotificationServicesController.Constants;

// NOTE - these 2 data sources are combined in our controller.
// FUTURE - we could separate these data sources into separate methods.
const useMetaMaskNotifications = () => {
  const isFeatureAnnouncementsEnabled = (0, _reactRedux.useSelector)(_metamaskNotifications2.selectIsFeatureAnnouncementsEnabled);
  const isMetamaskNotificationsEnabled = (0, _reactRedux.useSelector)(_metamaskNotifications2.selectIsMetamaskNotificationsEnabled);
  const notificationsData = (0, _reactRedux.useSelector)(_metamaskNotifications2.getMetamaskNotifications);
  const featureAnnouncementNotifications = (0, _react.useMemo)(() => {
    return isFeatureAnnouncementsEnabled ? (notificationsData ?? []).filter(n => n.type === TRIGGER_TYPES.FEATURES_ANNOUNCEMENT) : [];
  }, [isFeatureAnnouncementsEnabled, notificationsData]);
  const walletNotifications = (0, _react.useMemo)(() => {
    return isMetamaskNotificationsEnabled ? (notificationsData ?? []).filter(n => n.type !== TRIGGER_TYPES.FEATURES_ANNOUNCEMENT && n.type !== TRIGGER_TYPES.SNAP) : [];
  }, [isMetamaskNotificationsEnabled, notificationsData]);
  const snapNotifications = (0, _react.useMemo)(() => {
    return (notificationsData ?? []).filter(n => n.type === TRIGGER_TYPES.SNAP);
  }, [notificationsData]);
  return {
    featureAnnouncementNotifications,
    walletNotifications,
    snapNotifications
  };
};
const useCombinedNotifications = () => {
  const {
    featureAnnouncementNotifications,
    walletNotifications,
    snapNotifications
  } = useMetaMaskNotifications();
  const combinedNotifications = (0, _react.useMemo)(() => {
    const notifications = [...snapNotifications, ...featureAnnouncementNotifications, ...walletNotifications].sort((a, b) => new Date(b.createdAt).getTime() - new Date(a.createdAt).getTime());
    return notifications;
  }, [snapNotifications, featureAnnouncementNotifications, walletNotifications]);
  return combinedNotifications;
};
const filterNotifications = (activeTab, notifications) => {
  if (activeTab === _notificationsList.TAB_KEYS.ALL) {
    return notifications;
  }
  if (activeTab === _notificationsList.TAB_KEYS.WALLET) {
    return notifications.filter(notification => TRIGGER_TYPES_WALLET_SET.has(notification.type) || notification.type === TRIGGER_TYPES.FEATURES_ANNOUNCEMENT);
  }
  if (activeTab === _notificationsList.TAB_KEYS.WEB3) {
    return notifications.filter(notification => notification.type === TRIGGER_TYPES.SNAP);
  }
  return notifications;
};

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
exports.filterNotifications = filterNotifications;
function Notifications() {
  const navigate = (0, _reactRouterDomV5Compat.useNavigate)();
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    isLoading,
    error
  } = (0, _metamaskNotifications.useMetamaskNotificationsContext)();
  const [activeTab, setActiveTab] = (0, _react.useState)(_notificationsList.TAB_KEYS.ALL);
  const combinedNotifications = useCombinedNotifications();
  const {
    notificationsUnreadCount
  } = (0, _useCounter.useUnreadNotificationsCounter)();
  const filteredNotifications = (0, _react.useMemo)(() => filterNotifications(activeTab, combinedNotifications), [activeTab, combinedNotifications]);
  let hasNotifySnaps = false;
  hasNotifySnaps = (0, _reactRedux.useSelector)(_selectors.getNotifySnaps).length > 0;
  (0, _react.useEffect)(() => {
    dispatch((0, _actions.deleteExpiredNotifications)());
  }, [dispatch]);
  return /*#__PURE__*/_react.default.createElement(_multichain.NotificationsPage, null, /*#__PURE__*/_react.default.createElement(_page.Header, {
    startAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      ariaLabel: "Back",
      iconName: _componentLibrary.IconName.ArrowLeft,
      size: _componentLibrary.ButtonIconSize.Md,
      onClick: () => {
        navigate(_routes.DEFAULT_ROUTE);
      },
      "data-testid": "back-button"
    }),
    endAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      ariaLabel: "Notifications Settings",
      iconName: _componentLibrary.IconName.Setting,
      size: _componentLibrary.ButtonIconSize.Md,
      iconProps: {
        size: _componentLibrary.IconSize.Lg
      },
      onClick: () => {
        navigate(_routes.NOTIFICATIONS_SETTINGS_ROUTE);
      },
      "data-testid": "notifications-settings-button"
    }),
    marginBottom: 0
  }, t('notifications')), /*#__PURE__*/_react.default.createElement(_page.Content, {
    padding: 0
  }, hasNotifySnaps && /*#__PURE__*/_react.default.createElement(_tabs.Tabs, {
    defaultActiveTabKey: activeTab,
    onTabClick: tab => setActiveTab(tab),
    tabListProps: {
      className: 'px-4'
    }
  }, /*#__PURE__*/_react.default.createElement(_tabs.Tab, {
    "data-testid": _notificationsList.TAB_KEYS.ALL,
    name: t('all'),
    tabKey: _notificationsList.TAB_KEYS.ALL
  }), /*#__PURE__*/_react.default.createElement(_tabs.Tab, {
    "data-testid": _notificationsList.TAB_KEYS.WALLET,
    name: /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      justifyContent: _designSystem.JustifyContent.center,
      alignItems: _designSystem.AlignItems.center,
      gap: 2
    }, t('wallet'), /*#__PURE__*/_react.default.createElement(_NewFeatureTag.NewFeatureTag, null)),
    tabKey: _notificationsList.TAB_KEYS.WALLET
  }), /*#__PURE__*/_react.default.createElement(_tabs.Tab, {
    "data-testid": _notificationsList.TAB_KEYS.WEB3,
    name: t('web3'),
    tabKey: _notificationsList.TAB_KEYS.WEB3
  })), /*#__PURE__*/_react.default.createElement(_notificationsList.NotificationsList, {
    activeTab: activeTab,
    notifications: filteredNotifications,
    isLoading: isLoading,
    isError: Boolean(error),
    notificationsCount: notificationsUnreadCount
  })));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\notifications\\notifications.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\account-exist\\account-exist.tsx", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/onboarding":"D:\\code\\v\\metamask-extension\\shared\\constants\\onboarding.ts","../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/component-library/button":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\button\\index.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Conboarding-flow%5Caccount-exist%5Caccount-exist.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = AccountExist;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _reactRedux = require("react-redux");
var _button = require("../../../components/component-library/button");
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../../components/component-library");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _routes = require("../../../helpers/constants/routes");
var _selectors = require("../../../selectors");
var _onboarding = require("../../../../shared/constants/onboarding");
var _actions = require("../../../store/actions");
var _metametrics = require("../../../contexts/metametrics");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _trace = require("../../../../shared/lib/trace");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function AccountExist() {
  const navigate = (0, _reactRouterDomV5Compat.useNavigate)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const t = (0, _useI18nContext.useI18nContext)();
  const firstTimeFlowType = (0, _reactRedux.useSelector)(_selectors.getFirstTimeFlowType);
  const userSocialLoginEmail = (0, _reactRedux.useSelector)(_selectors.getSocialLoginEmail);
  const socialLoginType = (0, _reactRedux.useSelector)(_selectors.getSocialLoginType);
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const {
    bufferedTrace,
    bufferedEndTrace,
    onboardingParentContext
  } = trackEvent;
  const onLoginWithDifferentMethod = async e => {
    e.preventDefault();
    // reset onboarding flow
    await dispatch((0, _actions.resetOnboarding)());
    await (0, _actions.forceUpdateMetamaskState)(dispatch);
    navigate(_routes.ONBOARDING_WELCOME_ROUTE, {
      replace: true
    });
  };
  const onDone = async () => {
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.Onboarding,
      event: _metametrics2.MetaMetricsEventName.WalletImportStarted,
      properties: {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        account_type: `${_metametrics2.MetaMetricsEventAccountType.Imported}_${socialLoginType}`
      }
    });
    bufferedTrace === null || bufferedTrace === void 0 || bufferedTrace({
      name: _trace.TraceName.OnboardingExistingSocialLogin,
      op: _trace.TraceOperation.OnboardingUserJourney,
      tags: {
        source: 'account_status_redirect'
      },
      parentContext: onboardingParentContext === null || onboardingParentContext === void 0 ? void 0 : onboardingParentContext.current
    });
    await dispatch((0, _actions.setFirstTimeFlowType)(_onboarding.FirstTimeFlowType.socialImport));
    navigate(_routes.ONBOARDING_UNLOCK_ROUTE, {
      replace: true
    });
  };
  (0, _react.useEffect)(() => {
    if (firstTimeFlowType !== _onboarding.FirstTimeFlowType.socialCreate) {
      navigate(_routes.ONBOARDING_WELCOME_ROUTE, {
        replace: true
      });
    }
    if (firstTimeFlowType === _onboarding.FirstTimeFlowType.socialCreate) {
      // Track page view event for account already exists page
      trackEvent({
        category: _metametrics2.MetaMetricsEventCategory.Onboarding,
        event: _metametrics2.MetaMetricsEventName.AccountAlreadyExistsPageViewed
      });
      bufferedTrace === null || bufferedTrace === void 0 || bufferedTrace({
        name: _trace.TraceName.OnboardingNewSocialAccountExists,
        op: _trace.TraceOperation.OnboardingUserJourney,
        parentContext: onboardingParentContext === null || onboardingParentContext === void 0 ? void 0 : onboardingParentContext.current
      });
    }
    return () => {
      if (firstTimeFlowType === _onboarding.FirstTimeFlowType.socialCreate) {
        bufferedEndTrace === null || bufferedEndTrace === void 0 || bufferedEndTrace({
          name: _trace.TraceName.OnboardingNewSocialAccountExists
        });
      }
    };
  }, [firstTimeFlowType, navigate, onboardingParentContext, bufferedTrace, bufferedEndTrace, trackEvent]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "account-exist",
    "data-testid": "account-exist",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    alignItems: _designSystem.AlignItems.center,
    height: _designSystem.BlockSize.Full,
    gap: 6
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.flexStart
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingLg,
    as: "h2",
    justifyContent: _designSystem.JustifyContent.center,
    style: {
      alignSelf: _designSystem.AlignItems.flexStart
    },
    marginBottom: 4
  }, t('accountAlreadyExistsTitle')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    width: _designSystem.BlockSize.Full,
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.center,
    marginBottom: 6
  }, /*#__PURE__*/_react.default.createElement("img", {
    src: "images/account-status.png",
    width: 276,
    height: 276,
    alt: t('accountAlreadyExistsTitle'),
    style: {
      alignSelf: 'center'
    }
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    marginBottom: 6
  }, t('accountAlreadyExistsLoginDescription', [userSocialLoginEmail || '-'])))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.center,
    width: _designSystem.BlockSize.Full,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_button.Button, {
    "data-testid": "onboarding-complete-done",
    variant: _button.ButtonVariant.Primary,
    size: _button.ButtonSize.Lg,
    width: _designSystem.BlockSize.Full,
    onClick: onDone
  }, t('accountAlreadyExistsLogin')), /*#__PURE__*/_react.default.createElement(_button.Button, {
    "data-testid": "account-exist-login-with-different-method",
    variant: _button.ButtonVariant.Secondary,
    size: _button.ButtonSize.Lg,
    width: _designSystem.BlockSize.Full,
    onClick: onLoginWithDifferentMethod
  }, t('useDifferentLoginMethod'))));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\onboarding-flow\\account-exist\\account-exist.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\account-not-found\\account-not-found.tsx", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/onboarding":"D:\\code\\v\\metamask-extension\\shared\\constants\\onboarding.ts","../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/component-library/button":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\button\\index.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Conboarding-flow%5Caccount-not-found%5Caccount-not-found.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = AccountNotFound;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _reactRedux = require("react-redux");
var _button = require("../../../components/component-library/button");
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../../components/component-library");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _routes = require("../../../helpers/constants/routes");
var _selectors = require("../../../selectors");
var _onboarding = require("../../../../shared/constants/onboarding");
var _actions = require("../../../store/actions");
var _metametrics = require("../../../../shared/constants/metametrics");
var _trace = require("../../../../shared/lib/trace");
var _metametrics2 = require("../../../contexts/metametrics");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function AccountNotFound() {
  const navigate = (0, _reactRouterDomV5Compat.useNavigate)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const t = (0, _useI18nContext.useI18nContext)();
  const firstTimeFlowType = (0, _reactRedux.useSelector)(_selectors.getFirstTimeFlowType);
  const userSocialLoginEmail = (0, _reactRedux.useSelector)(_selectors.getSocialLoginEmail);
  const socialLoginType = (0, _reactRedux.useSelector)(_selectors.getSocialLoginType);
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const {
    bufferedTrace,
    bufferedEndTrace,
    onboardingParentContext
  } = trackEvent;
  const onLoginWithDifferentMethod = async () => {
    await dispatch((0, _actions.resetOnboarding)());
    await (0, _actions.forceUpdateMetamaskState)(dispatch);
    navigate(_routes.ONBOARDING_WELCOME_ROUTE, {
      replace: true
    });
  };
  const onCreateNewAccount = () => {
    trackEvent({
      category: _metametrics.MetaMetricsEventCategory.Onboarding,
      event: _metametrics.MetaMetricsEventName.WalletSetupStarted,
      properties: {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        account_type: `${_metametrics.MetaMetricsEventAccountType.Default}_${socialLoginType}`
      }
    });
    bufferedTrace === null || bufferedTrace === void 0 || bufferedTrace({
      name: _trace.TraceName.OnboardingNewSocialCreateWallet,
      op: _trace.TraceOperation.OnboardingUserJourney,
      tags: {
        source: 'account_status_redirect'
      },
      parentContext: onboardingParentContext === null || onboardingParentContext === void 0 ? void 0 : onboardingParentContext.current
    });
    dispatch((0, _actions.setFirstTimeFlowType)(_onboarding.FirstTimeFlowType.socialCreate));
    navigate(_routes.ONBOARDING_CREATE_PASSWORD_ROUTE, {
      replace: true
    });
  };
  (0, _react.useEffect)(() => {
    if (firstTimeFlowType !== _onboarding.FirstTimeFlowType.socialImport) {
      // if the onboarding flow is not social import, redirect to the welcome page
      navigate(_routes.ONBOARDING_WELCOME_ROUTE, {
        replace: true
      });
    }
    if (firstTimeFlowType === _onboarding.FirstTimeFlowType.socialImport) {
      trackEvent({
        category: _metametrics.MetaMetricsEventCategory.Onboarding,
        event: _metametrics.MetaMetricsEventName.AccountNotFoundPageViewed
      });
      bufferedTrace === null || bufferedTrace === void 0 || bufferedTrace({
        name: _trace.TraceName.OnboardingExistingSocialAccountNotFound,
        op: _trace.TraceOperation.OnboardingUserJourney,
        parentContext: onboardingParentContext === null || onboardingParentContext === void 0 ? void 0 : onboardingParentContext.current
      });
    }
    return () => {
      if (firstTimeFlowType === _onboarding.FirstTimeFlowType.socialImport) {
        bufferedEndTrace === null || bufferedEndTrace === void 0 || bufferedEndTrace({
          name: _trace.TraceName.OnboardingExistingSocialAccountNotFound
        });
      }
    };
  }, [firstTimeFlowType, navigate, onboardingParentContext, bufferedTrace, bufferedEndTrace, trackEvent]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "account-not-found",
    "data-testid": "account-not-found",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    alignItems: _designSystem.AlignItems.center,
    gap: 6,
    height: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.flexStart
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingLg,
    as: "h2",
    justifyContent: _designSystem.JustifyContent.center,
    style: {
      alignSelf: _designSystem.AlignItems.flexStart
    },
    marginBottom: 4
  }, t('accountNotFoundTitle')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    width: _designSystem.BlockSize.Full,
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.center,
    marginBottom: 6
  }, /*#__PURE__*/_react.default.createElement("img", {
    src: "images/account-status.png",
    width: 276,
    height: 276,
    alt: t('accountNotFoundTitle'),
    style: {
      alignSelf: 'center'
    }
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    marginBottom: 6
  }, t('accountNotFoundDescription', [userSocialLoginEmail || '-'])))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.center,
    width: _designSystem.BlockSize.Full,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_button.Button, {
    "data-testid": "onboarding-complete-done",
    variant: _button.ButtonVariant.Primary,
    size: _button.ButtonSize.Lg,
    width: _designSystem.BlockSize.Full,
    onClick: onCreateNewAccount
  }, t('accountNotFoundCreateOne')), /*#__PURE__*/_react.default.createElement(_button.Button, {
    "data-testid": "account-exist-login-with-different-method",
    variant: _button.ButtonVariant.Secondary,
    size: _button.ButtonSize.Lg,
    width: _designSystem.BlockSize.Full,
    onClick: onLoginWithDifferentMethod
  }, t('useDifferentLoginMethod'))));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\onboarding-flow\\account-not-found\\account-not-found.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\create-password\\create-password.js", {"../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/onboarding":"D:\\code\\v\\metamask-extension\\shared\\constants\\onboarding.ts","../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../../shared/modules/browser-runtime.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\browser-runtime.utils.js","../../../components/app/password-form/password-form":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\password-form\\password-form.tsx","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../helpers/constants/zendesk-url":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\zendesk-url.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Conboarding-flow%5Ccreate-password%5Ccreate-password.js
      return function (require, module, exports) {
(function (Buffer){(function (){
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = CreatePassword;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _reactRedux = require("react-redux");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _designSystem = require("../../../helpers/constants/design-system");
var _routes = require("../../../helpers/constants/routes");
var _zendeskUrl = _interopRequireDefault(require("../../../helpers/constants/zendesk-url"));
var _selectors = require("../../../selectors");
var _metametrics = require("../../../contexts/metametrics");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _componentLibrary = require("../../../components/component-library");
var _onboarding = require("../../../../shared/constants/onboarding");
var _passwordForm = _interopRequireDefault(require("../../../components/app/password-form/password-form"));
var _app = require("../../../../shared/constants/app");
var _browserRuntime = require("../../../../shared/modules/browser-runtime.utils");
var _actions = require("../../../store/actions");
var _trace = require("../../../../shared/lib/trace");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const isFirefox = (0, _browserRuntime.getBrowserName)() === _app.PLATFORM_FIREFOX;
function CreatePassword({
  createNewAccount,
  importWithRecoveryPhrase,
  secretRecoveryPhrase
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  const [password, setPassword] = (0, _react.useState)('');
  const [termsChecked, setTermsChecked] = (0, _react.useState)(false);
  const [newAccountCreationInProgress, setNewAccountCreationInProgress] = (0, _react.useState)(false);
  const navigate = (0, _reactRouterDomV5Compat.useNavigate)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const firstTimeFlowType = (0, _reactRedux.useSelector)(_selectors.getFirstTimeFlowType);
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const {
    bufferedTrace,
    bufferedEndTrace,
    onboardingParentContext
  } = trackEvent;
  const currentKeyring = (0, _reactRedux.useSelector)(_selectors.getCurrentKeyring);
  const isSocialLoginFlow = (0, _reactRedux.useSelector)(_selectors.getIsSocialLoginFlow);
  const socialLoginType = (0, _reactRedux.useSelector)(_selectors.getSocialLoginType);
  const participateInMetaMetrics = (0, _reactRedux.useSelector)(_selectors.getParticipateInMetaMetrics);
  const isParticipateInMetaMetricsSet = (0, _reactRedux.useSelector)(_selectors.getIsParticipateInMetaMetricsSet);
  const metametricsId = (0, _reactRedux.useSelector)(_selectors.getMetaMetricsId);
  const base64MetametricsId = Buffer.from(metametricsId ?? '').toString('base64');
  const shouldInjectMetametricsIframe = Boolean(participateInMetaMetrics && base64MetametricsId);
  const analyticsIframeQuery = {
    mmi: base64MetametricsId,
    env: 'production'
  };
  const analyticsIframeUrl = `https://start.metamask.io/?${new URLSearchParams(analyticsIframeQuery)}`;
  (0, _react.useEffect)(() => {
    if (currentKeyring && !newAccountCreationInProgress) {
      if (firstTimeFlowType === _onboarding.FirstTimeFlowType.import || firstTimeFlowType === _onboarding.FirstTimeFlowType.socialImport) {
        if (!isFirefox && firstTimeFlowType === _onboarding.FirstTimeFlowType.socialImport) {
          // we don't display the metametrics screen for social login flows if the user is not on firefox
          navigate(_routes.ONBOARDING_COMPLETION_ROUTE, {
            replace: true
          });
        } else {
          navigate(isParticipateInMetaMetricsSet ? _routes.ONBOARDING_COMPLETION_ROUTE : _routes.ONBOARDING_METAMETRICS, {
            replace: true
          });
        }
      } else if (firstTimeFlowType === _onboarding.FirstTimeFlowType.socialCreate) {
        navigate(_routes.ONBOARDING_COMPLETION_ROUTE, {
          replace: true
        });
      } else {
        navigate(_routes.ONBOARDING_REVIEW_SRP_ROUTE, {
          replace: true
        });
      }
    } else if (firstTimeFlowType === _onboarding.FirstTimeFlowType.import && !secretRecoveryPhrase) {
      navigate(_routes.ONBOARDING_IMPORT_WITH_SRP_ROUTE, {
        replace: true
      });
    }
  }, [currentKeyring, navigate, firstTimeFlowType, newAccountCreationInProgress, secretRecoveryPhrase, isParticipateInMetaMetricsSet]);
  const handleLearnMoreClick = event => {
    event.stopPropagation();
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.Onboarding,
      event: _metametrics2.MetaMetricsEventName.ExternalLinkClicked,
      properties: {
        text: 'Learn More',
        location: 'create_password',
        url: _zendeskUrl.default.PASSWORD_ARTICLE
      }
    });
  };

  // Helper function to determine account type for analytics
  const getAccountType = (baseType, includesSocialLogin = false) => {
    if (includesSocialLogin && socialLoginType) {
      const socialProvider = String(socialLoginType).toLowerCase();
      return `${baseType}_${socialProvider}`;
    }
    return baseType;
  };
  const handleWalletImport = async () => {
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.Onboarding,
      event: _metametrics2.MetaMetricsEventName.WalletImportAttempted
    });
    await importWithRecoveryPhrase(password, secretRecoveryPhrase);
    bufferedEndTrace === null || bufferedEndTrace === void 0 || bufferedEndTrace({
      name: _trace.TraceName.OnboardingExistingSrpImport
    });
    bufferedEndTrace === null || bufferedEndTrace === void 0 || bufferedEndTrace({
      name: _trace.TraceName.OnboardingJourneyOverall
    });
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.Onboarding,
      event: _metametrics2.MetaMetricsEventName.WalletImported,
      properties: {
        biometrics_enabled: false
      }
    });
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.Onboarding,
      event: _metametrics2.MetaMetricsEventName.WalletSetupCompleted,
      properties: {
        wallet_setup_type: 'import',
        new_wallet: false,
        account_type: getAccountType(_metametrics2.MetaMetricsEventAccountType.Imported, isSocialLoginFlow)
      }
    });
    if (isFirefox || isSocialLoginFlow) {
      navigate(_routes.ONBOARDING_COMPLETION_ROUTE, {
        replace: true
      });
    } else {
      navigate(_routes.ONBOARDING_METAMETRICS, {
        replace: true
      });
    }
  };
  const handleCreateNewWallet = async () => {
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.Onboarding,
      event: _metametrics2.MetaMetricsEventName.WalletCreationAttempted,
      properties: {
        account_type: getAccountType(_metametrics2.MetaMetricsEventAccountType.Default, isSocialLoginFlow)
      }
    });
    if (createNewAccount) {
      setNewAccountCreationInProgress(true);
      await createNewAccount(password);
    }
    if (isSocialLoginFlow) {
      bufferedEndTrace === null || bufferedEndTrace === void 0 || bufferedEndTrace({
        name: _trace.TraceName.OnboardingNewSocialCreateWallet
      });
      bufferedEndTrace === null || bufferedEndTrace === void 0 || bufferedEndTrace({
        name: _trace.TraceName.OnboardingJourneyOverall
      });
    }
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.Onboarding,
      event: _metametrics2.MetaMetricsEventName.WalletCreated,
      properties: {
        biometrics_enabled: false,
        account_type: getAccountType(_metametrics2.MetaMetricsEventAccountType.Default, isSocialLoginFlow)
      }
    });
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.Onboarding,
      event: _metametrics2.MetaMetricsEventName.WalletSetupCompleted,
      properties: {
        wallet_setup_type: 'new',
        new_wallet: true,
        account_type: getAccountType(_metametrics2.MetaMetricsEventAccountType.Default, isSocialLoginFlow)
      }
    });
    if (isSocialLoginFlow) {
      if (termsChecked) {
        dispatch((0, _actions.setMarketingConsent)(true));
        dispatch((0, _actions.setDataCollectionForMarketing)(true));
      }
      navigate(_routes.ONBOARDING_DOWNLOAD_APP_ROUTE, {
        replace: true
      });
    } else {
      navigate(_routes.ONBOARDING_REVIEW_SRP_ROUTE, {
        replace: true
      });
    }
  };
  (0, _react.useEffect)(() => {
    bufferedTrace === null || bufferedTrace === void 0 || bufferedTrace({
      name: _trace.TraceName.OnboardingPasswordSetupAttempt,
      op: _trace.TraceOperation.OnboardingUserJourney,
      parentContext: onboardingParentContext === null || onboardingParentContext === void 0 ? void 0 : onboardingParentContext.current
    });
    return () => {
      bufferedEndTrace === null || bufferedEndTrace === void 0 || bufferedEndTrace({
        name: _trace.TraceName.OnboardingPasswordSetupAttempt
      });
    };
  }, [onboardingParentContext, bufferedTrace, bufferedEndTrace]);
  const handleBackClick = async event => {
    event.preventDefault();
    if (firstTimeFlowType === _onboarding.FirstTimeFlowType.import) {
      // for SRP import flow, we will just navigate back to the import SRP page
      navigate(_routes.ONBOARDING_IMPORT_WITH_SRP_ROUTE, {
        replace: true
      });
    } else {
      // reset onboarding flow
      await dispatch((0, _actions.resetOnboarding)());
      await (0, _actions.forceUpdateMetamaskState)(dispatch);
      navigate(_routes.ONBOARDING_WELCOME_ROUTE, {
        replace: true
      });
    }
  };
  const handlePasswordSetupError = error => {
    const errorMessage = error instanceof Error ? error.message : 'Unknown error';
    bufferedTrace === null || bufferedTrace === void 0 || bufferedTrace({
      name: _trace.TraceName.OnboardingPasswordSetupError,
      op: _trace.TraceOperation.OnboardingUserJourney,
      parentContext: onboardingParentContext.current,
      tags: {
        errorMessage
      }
    });
    bufferedEndTrace === null || bufferedEndTrace === void 0 || bufferedEndTrace({
      name: _trace.TraceName.OnboardingPasswordSetupError
    });
    console.error(error);
  };
  const handleCreatePassword = async event => {
    event === null || event === void 0 || event.preventDefault();
    if (!password) {
      return;
    }
    try {
      // If secretRecoveryPhrase is defined we are in import wallet flow
      if (secretRecoveryPhrase && firstTimeFlowType === _onboarding.FirstTimeFlowType.import) {
        await handleWalletImport();
      } else {
        // Otherwise we are in create new wallet flow
        await handleCreateNewWallet();
      }
    } catch (error) {
      handlePasswordSetupError(error);
      trackEvent({
        category: _metametrics2.MetaMetricsEventCategory.Onboarding,
        event: _metametrics2.MetaMetricsEventName.WalletSetupFailure
      });
    }
  };
  const createPasswordLink = /*#__PURE__*/_react.default.createElement("a", {
    onClick: handleLearnMoreClick,
    key: "create-password__link-text",
    href: _zendeskUrl.default.PASSWORD_ARTICLE,
    target: "_blank",
    rel: "noopener noreferrer"
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "create-password__link-text"
  }, t('learnMoreUpperCaseWithDot')));
  const checkboxLabel = isSocialLoginFlow ? t('createPasswordMarketing') : t('passwordTermsWarning');
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    height: _designSystem.BlockSize.Full,
    width: _designSystem.BlockSize.Full,
    gap: 4,
    as: "form",
    className: "create-password",
    "data-testid": "create-password",
    onSubmit: handleCreatePassword
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    justifyContent: _designSystem.JustifyContent.flexStart,
    marginBottom: 4,
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    iconName: _componentLibrary.IconName.ArrowLeft,
    color: _designSystem.IconColor.iconDefault,
    size: _componentLibrary.ButtonIconSize.Md,
    "data-testid": "create-password-back-button",
    type: "button",
    onClick: handleBackClick,
    ariaLabel: t('back')
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    justifyContent: _designSystem.JustifyContent.flexStart,
    marginBottom: 4,
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingLg,
    as: "h2"
  }, t('createPassword')), isSocialLoginFlow ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    color: _designSystem.TextColor.textAlternative,
    as: "h2"
  }, t('createPasswordDetailsSocial'), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    color: _designSystem.TextColor.warningDefault,
    as: "span"
  }, t('createPasswordDetailsSocialReset'))) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    color: _designSystem.TextColor.textAlternative,
    as: "h2"
  }, t('createPasswordDetails'))), /*#__PURE__*/_react.default.createElement(_passwordForm.default, {
    onChange: newPassword => setPassword(newPassword)
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "create-password__terms-container",
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    marginTop: 6,
    backgroundColor: _designSystem.BackgroundColor.backgroundMuted,
    padding: 3,
    borderRadius: _designSystem.BorderRadius.LG
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Checkbox, {
    inputProps: {
      'data-testid': 'create-password-terms'
    },
    alignItems: _designSystem.AlignItems.flexStart,
    isChecked: termsChecked,
    onChange: () => {
      setTermsChecked(!termsChecked);
    },
    label: /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodySm,
      color: _designSystem.TextColor.textDefault
    }, checkboxLabel, !isSocialLoginFlow && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("br", null), createPasswordLink))
  }))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    "data-testid": "create-password-submit",
    variant: _componentLibrary.ButtonVariant.Primary,
    width: _designSystem.BlockSize.Full,
    size: _componentLibrary.ButtonSize.Lg,
    className: "create-password__form--submit-button",
    disabled: !password || !isSocialLoginFlow && !termsChecked
  }, t('createPasswordCreate'))), shouldInjectMetametricsIframe ? /*#__PURE__*/_react.default.createElement("iframe", {
    src: analyticsIframeUrl,
    className: "create-password__analytics-iframe",
    "data-testid": "create-password-iframe"
  }) : null);
}
CreatePassword.propTypes = {
  createNewAccount: _propTypes.default.func,
  importWithRecoveryPhrase: _propTypes.default.func,
  secretRecoveryPhrase: _propTypes.default.string
};

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\onboarding-flow\\create-password\\create-password.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\creation-successful\\creation-successful.js", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/onboarding":"D:\\code\\v\\metamask-extension\\shared\\constants\\onboarding.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/component-library/button":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\button\\index.ts","../../../components/component-library/lottie-animation":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\lottie-animation\\index.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Conboarding-flow%5Ccreation-successful%5Ccreation-successful.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = CreationSuccessful;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _reactRedux = require("react-redux");
var _lodash = require("lodash");
var _button = require("../../../components/component-library/button");
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../../components/component-library");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _routes = require("../../../helpers/constants/routes");
var _selectors = require("../../../selectors");
var _metametrics = require("../../../contexts/metametrics");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _onboarding = require("../../../../shared/constants/onboarding");
var _metamask = require("../../../ducks/metamask/metamask");
var _actions = require("../../../store/actions");
var _lottieAnimation = require("../../../components/component-library/lottie-animation");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function CreationSuccessful() {
  const navigate = (0, _reactRouterDomV5Compat.useNavigate)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    search
  } = (0, _reactRouterDomV5Compat.useLocation)();
  const isWalletReady = (0, _reactRedux.useSelector)(_metamask.getIsPrimarySeedPhraseBackedUp);
  const userSocialLoginType = (0, _reactRedux.useSelector)(_selectors.getSocialLoginType);
  const externalServicesOnboardingToggleState = (0, _reactRedux.useSelector)(_selectors.getExternalServicesOnboardingToggleState);
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const firstTimeFlowType = (0, _reactRedux.useSelector)(_selectors.getFirstTimeFlowType);
  const learnMoreLink = 'https://support.metamask.io/stay-safe/safety-in-web3/basic-safety-and-security-tips-for-metamask/';
  const searchParams = new URLSearchParams(search);
  const isFromReminder = searchParams.get('isFromReminder');
  const isFromSettingsSecurity = searchParams.get('isFromSettingsSecurity');
  const renderTitle = (0, _react.useMemo)(() => {
    if (isWalletReady) {
      return isFromReminder ? t('yourWalletIsReadyFromReminder') : t('yourWalletIsReady');
    }
    return t('yourWalletIsReadyRemind');
  }, [isFromReminder, isWalletReady, t]);
  const renderDetails1 = (0, _react.useMemo)(() => {
    if (userSocialLoginType) {
      return t('walletReadySocialDetails1', [(0, _lodash.capitalize)(userSocialLoginType)]);
    }
    if (isWalletReady) {
      return isFromReminder ? t('walletReadyLoseSrpFromReminder') : t('walletReadyLoseSrp');
    }
    return t('walletReadyLoseSrpRemind');
  }, [userSocialLoginType, isWalletReady, t, isFromReminder]);
  const renderDetails2 = (0, _react.useMemo)(() => {
    if (userSocialLoginType) {
      return t('walletReadySocialDetails2');
    }
    if (isWalletReady || isFromReminder) {
      return t('walletReadyLearn', [/*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
        key: "walletReadyLearn",
        size: _componentLibrary.ButtonLinkSize.Inherit,
        textProps: {
          variant: _designSystem.TextVariant.bodyMd,
          alignItems: _designSystem.AlignItems.flexStart
        },
        as: "a",
        href: learnMoreLink,
        target: "_blank",
        rel: "noopener noreferrer"
      }, t('learnHow'))]);
    }
    return t('walletReadyLearnRemind');
  }, [userSocialLoginType, isWalletReady, isFromReminder, t]);
  const renderFox = (0, _react.useMemo)(() => {
    if (isWalletReady || isFromReminder) {
      return /*#__PURE__*/_react.default.createElement(_lottieAnimation.LottieAnimation, {
        path: "images/animations/fox/celebrating.lottie.json",
        loop: true,
        autoplay: true
      });
    }
    return /*#__PURE__*/_react.default.createElement(_lottieAnimation.LottieAnimation, {
      path: "images/animations/fox/celebrating.lottie.json",
      loop: true,
      autoplay: true
    });
  }, [isWalletReady, isFromReminder]);
  const onDone = (0, _react.useCallback)(async () => {
    if (isWalletReady) {
      trackEvent({
        category: _metametrics2.MetaMetricsEventCategory.Onboarding,
        event: _metametrics2.MetaMetricsEventName.ExtensionPinned,
        properties: {
          // eslint-disable-next-line @typescript-eslint/naming-convention
          wallet_setup_type: firstTimeFlowType === _onboarding.FirstTimeFlowType.import ? 'import' : 'new',
          // eslint-disable-next-line @typescript-eslint/naming-convention
          new_wallet: firstTimeFlowType === _onboarding.FirstTimeFlowType.create
        }
      });
    }
    if (isFromReminder) {
      navigate(isFromSettingsSecurity ? _routes.SECURITY_ROUTE : _routes.DEFAULT_ROUTE);
      return;
    }
    await dispatch((0, _actions.toggleExternalServices)(externalServicesOnboardingToggleState));
    await dispatch((0, _actions.setCompletedOnboarding)());
    navigate(_routes.DEFAULT_ROUTE);
  }, [isWalletReady, isFromReminder, dispatch, externalServicesOnboardingToggleState, navigate, trackEvent, firstTimeFlowType, isFromSettingsSecurity]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    height: _designSystem.BlockSize.Full,
    gap: 6,
    className: "creation-successful",
    "data-testid": "wallet-ready"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.flexStart
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingLg,
    as: "h2",
    justifyContent: _designSystem.JustifyContent.center,
    style: {
      alignSelf: _designSystem.AlignItems.flexStart
    },
    marginBottom: 4
  }, renderTitle), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    width: _designSystem.BlockSize.Full,
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.center,
    marginBottom: 6
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    style: {
      width: '144px',
      height: '144px'
    }
  }, renderFox)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    color: _designSystem.TextColor.textAlternative,
    marginBottom: 6
  }, renderDetails1), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    color: _designSystem.TextColor.textAlternative,
    marginBottom: 6
  }, renderDetails2)), !isFromReminder && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.flexStart,
    className: "creation-successful__settings-actions",
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_button.Button, {
    variant: _button.ButtonVariant.Secondary,
    "data-testid": "manage-default-settings",
    borderRadius: _designSystem.BorderRadius.LG,
    width: _designSystem.BlockSize.Full,
    onClick: () => navigate(_routes.ONBOARDING_PRIVACY_SETTINGS_ROUTE)
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.Setting,
    size: _componentLibrary.IconSize.Md,
    marginInlineEnd: 3
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    fontWeight: _designSystem.FontWeight.Medium
  }, t('manageDefaultSettings'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.ArrowRight,
    color: _designSystem.IconColor.iconAlternative,
    size: _componentLibrary.IconSize.Sm
  })))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_button.Button, {
    "data-testid": "onboarding-complete-done",
    variant: _button.ButtonVariant.Primary,
    size: _button.ButtonSize.Lg,
    width: _designSystem.BlockSize.Full,
    onClick: onDone
  }, t('done'))));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\onboarding-flow\\creation-successful\\creation-successful.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\download-app\\download-app.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Conboarding-flow%5Cdownload-app%5Cdownload-app.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = OnboardingDownloadApp;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _reactRedux = require("react-redux");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _designSystem = require("../../../helpers/constants/design-system");
var _routes = require("../../../helpers/constants/routes");
var _componentLibrary = require("../../../components/component-library");
var _selectors = require("../../../selectors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function OnboardingDownloadApp() {
  const t = (0, _useI18nContext.useI18nContext)();
  const navigate = (0, _reactRouterDomV5Compat.useNavigate)();
  const currentKeyring = (0, _reactRedux.useSelector)(_selectors.getCurrentKeyring);
  const handleClick = async () => {
    navigate(_routes.ONBOARDING_COMPLETION_ROUTE, {
      replace: true
    });
  };
  (0, _react.useEffect)(() => {
    // if the user has not created a wallet, redirect to onboarding welcome route
    if (!currentKeyring) {
      navigate(_routes.ONBOARDING_WELCOME_ROUTE, {
        replace: true
      });
    }
  }, [currentKeyring, navigate]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    height: _designSystem.BlockSize.Full,
    gap: 6,
    className: "onboarding-download-app",
    "data-testid": "onboarding-download-app"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingLg,
    marginBottom: 4
  }, t('downloadAppTitle')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.flexStart,
    justifyContent: _designSystem.JustifyContent.center,
    marginBottom: 4
  }, /*#__PURE__*/_react.default.createElement("img", {
    src: "/images/onboarding-download-app.png",
    alt: "Download the app"
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    color: _designSystem.TextColor.textAlternative
  }, t('downloadAppDescription'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    variant: _componentLibrary.ButtonVariant.Primary,
    size: _componentLibrary.ButtonSize.Lg,
    block: true,
    "data-testid": "download-app-continue",
    onClick: handleClick
  }, t('continue'))));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\onboarding-flow\\download-app\\download-app.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\import-srp\\import-srp.js", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../components/app/srp-details-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\srp-details-modal\\index.ts","../../../components/app/srp-input-import":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\srp-input-import\\index.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","@ethersproject/hdnode":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\hdnode\\lib\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Conboarding-flow%5Cimport-srp%5Cimport-srp.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ImportSRP;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _reactRedux = require("react-redux");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _hdnode = require("@ethersproject/hdnode");
var _designSystem = require("../../../helpers/constants/design-system");
var _routes = require("../../../helpers/constants/routes");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _srpInputImport = _interopRequireDefault(require("../../../components/app/srp-input-import"));
var _selectors = require("../../../selectors");
var _metametrics = require("../../../contexts/metametrics");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _selectors2 = require("../../../selectors/selectors");
var _componentLibrary = require("../../../components/component-library");
var _srpDetailsModal = _interopRequireDefault(require("../../../components/app/srp-details-modal"));
var _actions = require("../../../store/actions");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const hasUpperCase = draftSrp => {
  return draftSrp !== draftSrp.toLowerCase();
};
function ImportSRP({
  submitSecretRecoveryPhrase
}) {
  const dispatch = (0, _reactRedux.useDispatch)();
  const [secretRecoveryPhrase, setSecretRecoveryPhrase] = (0, _react.useState)('');
  const [showSrpDetailsModal, setShowSrpDetailsModal] = (0, _react.useState)(false);
  const [srpError, setSrpError] = (0, _react.useState)('');
  const navigate = (0, _reactRouterDomV5Compat.useNavigate)();
  const hdEntropyIndex = (0, _reactRedux.useSelector)(_selectors2.getHDEntropyIndex);
  const t = (0, _useI18nContext.useI18nContext)();
  const currentKeyring = (0, _reactRedux.useSelector)(_selectors.getCurrentKeyring);
  (0, _react.useEffect)(() => {
    if (currentKeyring) {
      navigate(_routes.ONBOARDING_CREATE_PASSWORD_ROUTE, {
        replace: true
      });
    }
  }, [currentKeyring, navigate]);
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const onShowSrpDetailsModal = (0, _react.useCallback)(() => {
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.Onboarding,
      event: _metametrics2.MetaMetricsEventName.SrpDefinitionClicked,
      properties: {
        location: 'import_srp'
      }
    });
    setShowSrpDetailsModal(true);
  }, [trackEvent]);
  const onBack = async e => {
    e.preventDefault();
    // reset onboarding flow
    await dispatch((0, _actions.resetOnboarding)());
    await (0, _actions.forceUpdateMetamaskState)(dispatch);
    navigate(_routes.ONBOARDING_WELCOME_ROUTE, {
      replace: true
    });
  };
  const onContinue = (0, _react.useCallback)(() => {
    let newSrpError = '';
    if (hasUpperCase(secretRecoveryPhrase) || !(0, _hdnode.isValidMnemonic)(secretRecoveryPhrase)) {
      newSrpError = t('invalidSeedPhraseNotFound');
    }
    setSrpError(newSrpError);
    if (newSrpError) {
      return;
    }
    submitSecretRecoveryPhrase(secretRecoveryPhrase);
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.Onboarding,
      event: _metametrics2.MetaMetricsEventName.OnboardingWalletSecurityPhraseConfirmed,
      properties: {
        hd_entropy_index: hdEntropyIndex
      }
    });
    navigate(_routes.ONBOARDING_CREATE_PASSWORD_ROUTE);
  }, [secretRecoveryPhrase, t, hdEntropyIndex, trackEvent, navigate, submitSecretRecoveryPhrase]);
  (0, _react.useEffect)(() => {
    setSrpError('');
  }, [secretRecoveryPhrase]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    height: _designSystem.BlockSize.Full,
    gap: 4,
    className: "import-srp",
    "data-testid": "import-srp"
  }, showSrpDetailsModal && /*#__PURE__*/_react.default.createElement(_srpDetailsModal.default, {
    onClose: () => setShowSrpDetailsModal(false)
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginBottom: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    iconName: _componentLibrary.IconName.ArrowLeft,
    color: _designSystem.IconColor.iconDefault,
    size: _componentLibrary.ButtonIconSize.Md,
    "data-testid": "import-srp-back-button",
    onClick: onBack,
    ariaLabel: t('back')
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    textAlign: _designSystem.TextAlign.Left,
    marginBottom: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingLg
  }, t('importAWallet'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    marginBottom: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    color: _designSystem.TextColor.textAlternative
  }, t('typeYourSRP')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    iconName: _componentLibrary.IconName.Info,
    size: _componentLibrary.ButtonIconSize.Sm,
    color: _designSystem.IconColor.iconAlternative,
    onClick: onShowSrpDetailsModal,
    ariaLabel: "info"
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement("form", {
    onSubmit: e => e.preventDefault()
  }, /*#__PURE__*/_react.default.createElement(_srpInputImport.default, {
    onChange: setSecretRecoveryPhrase
  }), srpError && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginTop: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    "data-testid": "import-srp-error",
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.errorDefault
  }, srpError))))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.center,
    width: _designSystem.BlockSize.Full,
    textAlign: _designSystem.TextAlign.Left
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    width: _designSystem.BlockSize.Full,
    size: _componentLibrary.ButtonSize.Lg,
    type: "primary",
    "data-testid": "import-srp-confirm",
    onClick: onContinue,
    disabled: !secretRecoveryPhrase.trim() || Boolean(srpError)
  }, t('continue'))));
}
ImportSRP.propTypes = {
  submitSecretRecoveryPhrase: _propTypes.default.func
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\onboarding-flow\\import-srp\\import-srp.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\metametrics\\metametrics.js", {"../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/onboarding":"D:\\code\\v\\metamask-extension\\shared\\constants\\onboarding.ts","../../../../shared/modules/browser-runtime.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\browser-runtime.utils.js","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Conboarding-flow%5Cmetametrics%5Cmetametrics.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = OnboardingMetametrics;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _loglevel = _interopRequireDefault(require("loglevel"));
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _actions = require("../../../store/actions");
var _selectors = require("../../../selectors");
var _metametrics = require("../../../../shared/constants/metametrics");
var _app = require("../../../../shared/constants/app");
var _routes = require("../../../helpers/constants/routes");
var _metametrics2 = require("../../../contexts/metametrics");
var _componentLibrary = require("../../../components/component-library");
var _onboarding = require("../../../../shared/constants/onboarding");
var _browserRuntime = require("../../../../shared/modules/browser-runtime.utils");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const isFirefox = (0, _browserRuntime.getBrowserName)() === _app.PLATFORM_FIREFOX;
function OnboardingMetametrics() {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const navigate = (0, _reactRouterDomV5Compat.useNavigate)();
  const firstTimeFlowType = (0, _reactRedux.useSelector)(_selectors.getFirstTimeFlowType);
  const participateInMetaMetricsSet = (0, _reactRedux.useSelector)(_selectors.getIsParticipateInMetaMetricsSet);
  const participateInMetaMetrics = (0, _reactRedux.useSelector)(_selectors.getParticipateInMetaMetrics);
  const dataCollectionForMarketing = (0, _reactRedux.useSelector)(_selectors.getDataCollectionForMarketing);
  const [isParticipateInMetaMetricsChecked, setIsParticipateInMetaMetricsChecked] = (0, _react.useState)(true);
  const [isDataCollectionForMarketingChecked, setIsDataCollectionForMarketingChecked] = (0, _react.useState)(false);
  const participateCheckboxRef = (0, _react.useRef)(null);
  const marketingCheckboxRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    if (participateInMetaMetricsSet) {
      setIsParticipateInMetaMetricsChecked(participateInMetaMetrics);
    }
    if (dataCollectionForMarketing) {
      setIsDataCollectionForMarketingChecked(dataCollectionForMarketing);
    }
  }, [participateInMetaMetricsSet, participateInMetaMetrics, dataCollectionForMarketing]);
  const currentKeyring = (0, _reactRedux.useSelector)(_selectors.getCurrentKeyring);
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  let nextRouteByBrowser = (0, _reactRedux.useSelector)(_selectors.getFirstTimeFlowTypeRouteAfterMetaMetricsOptIn);
  if (isFirefox && firstTimeFlowType !== _onboarding.FirstTimeFlowType.restore) {
    if (currentKeyring && firstTimeFlowType === _onboarding.FirstTimeFlowType.socialCreate) {
      nextRouteByBrowser = _routes.ONBOARDING_COMPLETION_ROUTE;
    } else {
      nextRouteByBrowser = _routes.ONBOARDING_WELCOME_ROUTE;
    }
  }
  const handleContinue = async e => {
    e.preventDefault();
    try {
      if (isParticipateInMetaMetricsChecked) {
        dispatch((0, _actions.setDataCollectionForMarketing)(isDataCollectionForMarketingChecked));
        dispatch((0, _actions.setParticipateInMetaMetrics)(true));
        await trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Onboarding,
          event: _metametrics.MetaMetricsEventName.AppInstalled
        });
        await trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Onboarding,
          event: _metametrics.MetaMetricsEventName.AnalyticsPreferenceSelected,
          properties: {
            is_metrics_opted_in: true,
            has_marketing_consent: Boolean(isDataCollectionForMarketingChecked),
            location: 'onboarding_metametrics'
          }
        });
      } else {
        dispatch((0, _actions.setParticipateInMetaMetrics)(false));
        dispatch((0, _actions.setDataCollectionForMarketing)(false));
      }
    } catch (error) {
      _loglevel.default.error('onConfirm::error', error);
    } finally {
      navigate(nextRouteByBrowser);
    }
  };
  const handleParticipateInMetaMetricsChange = () => {
    setIsParticipateInMetaMetricsChecked(prev => !prev);
    isParticipateInMetaMetricsChecked && setIsDataCollectionForMarketingChecked(false);
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "onboarding-metametrics",
    "data-testid": "onboarding-metametrics",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingLg,
    textAlign: _designSystem.TextAlign.Left,
    fontWeight: _designSystem.FontWeight.Bold,
    marginBottom: 4
  }, t('onboardingMetametricsTitle')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    width: _designSystem.BlockSize.Full,
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    className: "onboarding-metametrics__user-control"
  }, /*#__PURE__*/_react.default.createElement("img", {
    src: "images/user-control.png",
    alt: "User control",
    height: 200,
    width: 200
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySmMedium,
    color: _designSystem.TextColor.textAlternative,
    textAlign: _designSystem.TextAlign.Left
  }, t('onboardingMetametricsDescription')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 2,
    padding: 3,
    borderRadius: _designSystem.BorderRadius.LG,
    backgroundColor: _designSystem.BackgroundColor.backgroundMuted,
    className: "onboarding-metametrics__checkbox",
    role: "button",
    tabIndex: 0,
    onClick: () => {
      var _participateCheckboxR;
      (_participateCheckboxR = participateCheckboxRef.current) === null || _participateCheckboxR === void 0 || _participateCheckboxR.click();
    },
    onKeyDown: e => {
      if (e.key === ' ' || e.key === 'Enter') {
        var _participateCheckboxR2;
        e.preventDefault();
        (_participateCheckboxR2 = participateCheckboxRef.current) === null || _participateCheckboxR2 === void 0 || _participateCheckboxR2.click();
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Checkbox, {
    id: "metametrics-opt-in",
    "data-testid": "metametrics-checkbox",
    isChecked: isParticipateInMetaMetricsChecked,
    onChange: handleParticipateInMetaMetricsChange,
    inputRef: participateCheckboxRef,
    onClick: e => e.stopPropagation(),
    inputProps: {
      onClick: e => e.stopPropagation()
    },
    label: /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMdMedium
    }, t('onboardingMetametricCheckboxTitleOne')),
    alignItems: _designSystem.AlignItems.center
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative,
    textAlign: _designSystem.TextAlign.Left
  }, t('onboardingMetametricCheckboxDescriptionOne'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 2,
    padding: 3,
    borderRadius: _designSystem.BorderRadius.LG,
    backgroundColor: _designSystem.BackgroundColor.backgroundMuted,
    className: `${isParticipateInMetaMetricsChecked ? 'onboarding-metametrics__checkbox' : 'onboarding-metametrics__checkbox-disabled'}`,
    disabled: !isParticipateInMetaMetricsChecked,
    role: isParticipateInMetaMetricsChecked ? 'button' : undefined,
    tabIndex: isParticipateInMetaMetricsChecked ? 0 : undefined,
    onClick: isParticipateInMetaMetricsChecked ? () => {
      var _marketingCheckboxRef;
      (_marketingCheckboxRef = marketingCheckboxRef.current) === null || _marketingCheckboxRef === void 0 || _marketingCheckboxRef.click();
    } : undefined,
    onKeyDown: isParticipateInMetaMetricsChecked && (e => {
      if (e.key === ' ' || e.key === 'Enter') {
        var _marketingCheckboxRef2;
        e.preventDefault();
        (_marketingCheckboxRef2 = marketingCheckboxRef.current) === null || _marketingCheckboxRef2 === void 0 || _marketingCheckboxRef2.click();
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Checkbox, {
    id: "metametrics-datacollection-opt-in",
    "data-testid": "metametrics-data-collection-checkbox",
    isChecked: isParticipateInMetaMetricsChecked && isDataCollectionForMarketingChecked,
    isDisabled: !isParticipateInMetaMetricsChecked,
    onChange: () => {
      setIsDataCollectionForMarketingChecked(prev => !prev);
    },
    inputRef: marketingCheckboxRef,
    onClick: e => e.stopPropagation(),
    inputProps: {
      onClick: e => e.stopPropagation()
    },
    label: /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMdMedium
    }, t('onboardingMetametricCheckboxTitleTwo')),
    alignItems: _designSystem.AlignItems.center
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative,
    textAlign: _designSystem.TextAlign.Left
  }, t('onboardingMetametricCheckboxDescriptionTwo'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    "data-testid": "metametrics-i-agree",
    size: _componentLibrary.ButtonSize.Lg,
    width: _designSystem.BlockSize.Full,
    onClick: handleContinue
  }, t('onboardingMetametricsContinue'))));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\onboarding-flow\\metametrics\\metametrics.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\onboarding-app-header\\onboarding-app-header.js", {"../../../../app/_locales/index.json":"D:\\code\\v\\metamask-extension\\app\\_locales\\index.json","../../../../shared/constants/preferences":"D:\\code\\v\\metamask-extension\\shared\\constants\\preferences.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/ui/dropdown":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\dropdown\\index.js","../../../components/ui/metafox-logo":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\metafox-logo\\index.js","../../../ducks/locale/locale":"D:\\code\\v\\metamask-extension\\ui\\ducks\\locale\\locale.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Conboarding-flow%5Conboarding-app-header%5Conboarding-app-header.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = OnboardingAppHeader;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRedux = require("react-redux");
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _classnames = _interopRequireDefault(require("classnames"));
var _metafoxLogo = _interopRequireDefault(require("../../../components/ui/metafox-logo"));
var _useI18nContext = require("../../../hooks/useI18nContext");
var _dropdown = _interopRequireDefault(require("../../../components/ui/dropdown"));
var _locale = require("../../../ducks/locale/locale");
var _actions = require("../../../store/actions");
var _index = _interopRequireDefault(require("../../../../app/_locales/index.json"));
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _routes = require("../../../helpers/constants/routes");
var _preferences = require("../../../../shared/constants/preferences");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

function OnboardingAppHeader({
  isWelcomePage
}) {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    pathname
  } = (0, _reactRouterDomV5Compat.useLocation)();
  const t = (0, _useI18nContext.useI18nContext)();
  const currentLocale = (0, _reactRedux.useSelector)(_locale.getCurrentLocale);
  const localeOptions = _index.default.map(locale => {
    return {
      name: locale.name,
      value: locale.code
    };
  });
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    width: _designSystem.BlockSize.Full,
    padding: 4,
    className: (0, _classnames.default)('onboarding-app-header', {
      'onboarding-app-header--welcome': isWelcomePage
    })
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    width: _designSystem.BlockSize.Full,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    className: "onboarding-app-header__contents"
  }, /*#__PURE__*/_react.default.createElement(_metafoxLogo.default, {
    theme: pathname === _routes.ONBOARDING_WELCOME_ROUTE ? _preferences.ThemeType.light : undefined,
    unsetIconHeight: true,
    isOnboarding: true
  }), pathname === _routes.ONBOARDING_COMPLETION_ROUTE ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingTop: 12,
    className: "onboarding-app-header__banner-tip-container"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerTip, {
    borderColor: _designSystem.BorderColor.borderMuted,
    backgroundColor: _designSystem.BackgroundColor.backgroundMuted,
    title: t('pinMetaMask'),
    gap: 4,
    titleProps: {
      color: _designSystem.TextColor.textDefault,
      variant: _designSystem.TextVariant.bodyMdMedium,
      paddingRight: 2
    },
    className: "onboarding-app-header__banner-tip",
    padding: 3,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    alignItems: _designSystem.AlignItems.center,
    color: _designSystem.TextColor.textAlternative,
    paddingRight: 2
  }, t('pinMetaMaskDescription', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.Extension,
    key: "extension",
    color: _designSystem.TextColor.textDefault,
    size: _componentLibrary.IconSize.Md,
    className: "onboarding-app-header__banner-tip-icon"
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.Keep,
    key: "keep",
    color: _designSystem.TextColor.textDefault,
    size: _componentLibrary.IconSize.Md,
    className: "onboarding-app-header__banner-tip-icon"
  })])))) : /*#__PURE__*/_react.default.createElement(_dropdown.default, {
    "data-testid": "select-locale",
    className: (0, _classnames.default)('onboarding-app-header__dropdown', {
      'onboarding-app-header__dropdown--welcome--login': isWelcomePage
    }),
    options: localeOptions,
    selectedOption: currentLocale,
    onChange: async newLocale => dispatch((0, _actions.updateCurrentLocale)(newLocale))
  })));
}
OnboardingAppHeader.propTypes = {
  isWelcomePage: _propTypes.default.bool
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\onboarding-flow\\onboarding-app-header\\onboarding-app-header.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\onboarding-flow-switch\\onboarding-flow-switch.js", {"../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../../shared/constants/onboarding":"D:\\code\\v\\metamask-extension\\shared\\constants\\onboarding.ts","../../../../shared/modules/browser-runtime.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\browser-runtime.utils.js","../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Conboarding-flow%5Conboarding-flow-switch%5Conboarding-flow-switch.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = OnboardingFlowSwitch;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _routes = require("../../../helpers/constants/routes");
var _metamask = require("../../../ducks/metamask/metamask");
var _app = require("../../../../shared/constants/app");
var _browserRuntime = require("../../../../shared/modules/browser-runtime.utils");
var _selectors = require("../../../selectors");
var _onboarding = require("../../../../shared/constants/onboarding");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
///: BEGIN:ONLY_INCLUDE_IF(build-main,build-beta)
// eslint-disable-line no-unused-vars

///: END:ONLY_INCLUDE_IF

function OnboardingFlowSwitch() {
  /* eslint-disable prefer-const */
  const completedOnboarding = (0, _reactRedux.useSelector)(_metamask.getCompletedOnboarding);
  const isInitialized = (0, _reactRedux.useSelector)(_metamask.getIsInitialized);
  const isUserAuthenticatedWithSocialLogin = (0, _reactRedux.useSelector)(_selectors.getIsSocialLoginUserAuthenticated);
  const seedPhraseBackedUp = (0, _reactRedux.useSelector)(_metamask.getSeedPhraseBackedUp);
  const firstTimeFlowType = (0, _reactRedux.useSelector)(_selectors.getFirstTimeFlowType);
  const isSocialLoginFlow = (0, _reactRedux.useSelector)(_selectors.getIsSocialLoginFlow);
  const isUnlocked = (0, _reactRedux.useSelector)(_metamask.getIsUnlocked);
  const isParticipateInMetaMetricsSet = (0, _reactRedux.useSelector)(_selectors.getIsParticipateInMetaMetricsSet);
  if (completedOnboarding) {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Navigate, {
      to: _routes.DEFAULT_ROUTE,
      replace: true
    });
  }
  if (seedPhraseBackedUp !== null || isUnlocked && isSocialLoginFlow) {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Navigate, {
      to: isParticipateInMetaMetricsSet ? _routes.ONBOARDING_COMPLETION_ROUTE : _routes.ONBOARDING_METAMETRICS,
      replace: true
    });
  }
  if (isUnlocked) {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Navigate, {
      to: _routes.LOCK_ROUTE,
      replace: true
    });
  }

  // TODO(ritave): Remove allow-list and only leave experimental_area exception
  if (!isInitialized && !isUserAuthenticatedWithSocialLogin) {
    let redirect;
    ///: BEGIN:ONLY_INCLUDE_IF(build-main,build-beta)
    redirect = (0, _browserRuntime.getBrowserName)() === _app.PLATFORM_FIREFOX ? /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Navigate, {
      to: _routes.ONBOARDING_METAMETRICS,
      replace: true
    }) : /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Navigate, {
      to: _routes.ONBOARDING_WELCOME_ROUTE,
      replace: true
    });
    ///: END:ONLY_INCLUDE_IF
    return redirect;
  }
  if (!isInitialized && isUserAuthenticatedWithSocialLogin && firstTimeFlowType === _onboarding.FirstTimeFlowType.socialCreate) {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Navigate, {
      to: _routes.ONBOARDING_CREATE_PASSWORD_ROUTE,
      replace: true
    });
  }
  return /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Navigate, {
    to: _routes.ONBOARDING_UNLOCK_ROUTE,
    replace: true
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\onboarding-flow\\onboarding-flow-switch\\onboarding-flow-switch.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\onboarding-flow.js", {"../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../shared/constants/onboarding":"D:\\code\\v\\metamask-extension\\shared\\constants\\onboarding.ts","../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../shared/modules/environment":"D:\\code\\v\\metamask-extension\\shared\\modules\\environment.ts","../../components/app/toast-master/utils":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\toast-master\\utils.ts","../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../components/ui/loading-screen":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\loading-screen\\index.js","../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../unlock-page":"D:\\code\\v\\metamask-extension\\ui\\pages\\unlock-page\\index.js","./account-exist/account-exist":"D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\account-exist\\account-exist.tsx","./account-not-found/account-not-found":"D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\account-not-found\\account-not-found.tsx","./create-password/create-password":"D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\create-password\\create-password.js","./creation-successful/creation-successful":"D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\creation-successful\\creation-successful.js","./download-app/download-app":"D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\download-app\\download-app.tsx","./import-srp/import-srp":"D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\import-srp\\import-srp.js","./metametrics/metametrics":"D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\metametrics\\metametrics.js","./onboarding-app-header/onboarding-app-header":"D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\onboarding-app-header\\onboarding-app-header.js","./onboarding-flow-switch/onboarding-flow-switch":"D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\onboarding-flow-switch\\onboarding-flow-switch.js","./pin-extension/pin-extension":"D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\pin-extension\\pin-extension.js","./privacy-settings/privacy-settings":"D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\privacy-settings\\privacy-settings.js","./recovery-phrase/confirm-recovery-phrase":"D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\recovery-phrase\\confirm-recovery-phrase.js","./recovery-phrase/reveal-recovery-phrase":"D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\recovery-phrase\\reveal-recovery-phrase.tsx","./recovery-phrase/review-recovery-phrase":"D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\recovery-phrase\\review-recovery-phrase.js","./welcome/welcome":"D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\welcome\\welcome.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Conboarding-flow%5Conboarding-flow.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = OnboardingFlow;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _reactRedux = require("react-redux");
var _classnames = _interopRequireDefault(require("classnames"));
var _unlockPage = _interopRequireDefault(require("../unlock-page"));
var _routes = require("../../helpers/constants/routes");
var _metamask = require("../../ducks/metamask/metamask");
var _actions = require("../../store/actions");
var _selectors = require("../../selectors");
var _metametrics = require("../../contexts/metametrics");
var _utils = require("../../components/app/toast-master/utils");
var _componentLibrary = require("../../components/component-library");
var _designSystem = require("../../helpers/constants/design-system");
var _util = require("../../../app/scripts/lib/util");
var _app = require("../../../shared/constants/app");
var _onboarding = require("../../../shared/constants/onboarding");
var _environment = require("../../../shared/modules/environment");
var _trace = require("../../../shared/lib/trace");
var _loadingScreen = _interopRequireDefault(require("../../components/ui/loading-screen"));
var _onboardingFlowSwitch = _interopRequireDefault(require("./onboarding-flow-switch/onboarding-flow-switch"));
var _createPassword = _interopRequireDefault(require("./create-password/create-password"));
var _reviewRecoveryPhrase = _interopRequireDefault(require("./recovery-phrase/review-recovery-phrase"));
var _confirmRecoveryPhrase = _interopRequireDefault(require("./recovery-phrase/confirm-recovery-phrase"));
var _privacySettings = _interopRequireDefault(require("./privacy-settings/privacy-settings"));
var _creationSuccessful = _interopRequireDefault(require("./creation-successful/creation-successful"));
var _welcome = _interopRequireDefault(require("./welcome/welcome"));
var _importSrp = _interopRequireDefault(require("./import-srp/import-srp"));
var _pinExtension = _interopRequireDefault(require("./pin-extension/pin-extension"));
var _metametrics2 = _interopRequireDefault(require("./metametrics/metametrics"));
var _onboardingAppHeader = _interopRequireDefault(require("./onboarding-app-header/onboarding-app-header"));
var _accountExist = _interopRequireDefault(require("./account-exist/account-exist"));
var _accountNotFound = _interopRequireDefault(require("./account-not-found/account-not-found"));
var _revealRecoveryPhrase = _interopRequireDefault(require("./recovery-phrase/reveal-recovery-phrase"));
var _downloadApp = _interopRequireDefault(require("./download-app/download-app"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// eslint-disable-next-line import/no-restricted-paths

function OnboardingFlow() {
  const [secretRecoveryPhrase, setSecretRecoveryPhrase] = (0, _react.useState)('');
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    pathname,
    search
  } = (0, _reactRouterDomV5Compat.useLocation)();
  const navigate = (0, _reactRouterDomV5Compat.useNavigate)();
  const completedOnboarding = (0, _reactRedux.useSelector)(_metamask.getCompletedOnboarding);
  const nextRoute = (0, _reactRedux.useSelector)(_selectors.getFirstTimeFlowTypeRouteAfterUnlock);
  const isFromReminder = new URLSearchParams(search).get('isFromReminder');
  const isFromSettingsSecurity = new URLSearchParams(search).get('isFromSettingsSecurity');
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const {
    bufferedTrace,
    onboardingParentContext
  } = trackEvent;
  const isUnlocked = (0, _reactRedux.useSelector)(_metamask.getIsUnlocked);
  const firstTimeFlowType = (0, _reactRedux.useSelector)(_selectors.getFirstTimeFlowType);
  const isSeedlessOnboardingFeatureEnabled = (0, _environment.getIsSeedlessOnboardingFeatureEnabled)();
  const isPrimarySeedPhraseBackedUp = (0, _reactRedux.useSelector)(_metamask.getIsPrimarySeedPhraseBackedUp);
  const envType = (0, _util.getEnvironmentType)();
  const isPopup = envType === _app.ENVIRONMENT_TYPE_POPUP;

  // If the user has not agreed to the terms of use, we show the banner
  // Otherwise, we show the login page
  const isWelcomePage = (0, _react.useMemo)(() => pathname === _routes.ONBOARDING_WELCOME_ROUTE, [pathname]);
  (0, _react.useEffect)(() => {
    setOnboardingDate();
  }, []);
  (0, _react.useEffect)(() => {
    if (completedOnboarding && !isFromReminder) {
      navigate(_routes.DEFAULT_ROUTE);
    }
  }, [navigate, completedOnboarding, isFromReminder]);
  (0, _react.useEffect)(() => {
    const isSRPBackupRoute = [_routes.ONBOARDING_REVIEW_SRP_ROUTE, _routes.ONBOARDING_CONFIRM_SRP_ROUTE].some(route => pathname === null || pathname === void 0 ? void 0 : pathname.startsWith(route));
    if (isUnlocked && !completedOnboarding && !secretRecoveryPhrase) {
      if (isSRPBackupRoute) {
        navigate(_routes.ONBOARDING_UNLOCK_ROUTE);
      }
    }
    if (isPrimarySeedPhraseBackedUp && isSRPBackupRoute && completedOnboarding) {
      navigate(isFromSettingsSecurity ? _routes.SECURITY_ROUTE : _routes.DEFAULT_ROUTE, {
        replace: true
      });
    }
  }, [isUnlocked, completedOnboarding, secretRecoveryPhrase, pathname, navigate, isPrimarySeedPhraseBackedUp, isFromSettingsSecurity]);
  (0, _react.useEffect)(() => {
    const trace = bufferedTrace === null || bufferedTrace === void 0 ? void 0 : bufferedTrace({
      name: _trace.TraceName.OnboardingJourneyOverall,
      op: _trace.TraceOperation.OnboardingUserJourney
    });
    if (onboardingParentContext) {
      onboardingParentContext.current = trace;
    }
  }, [onboardingParentContext, bufferedTrace]);
  const handleCreateNewAccount = async password => {
    try {
      setIsLoading(true);
      let newSecretRecoveryPhrase;
      if (isSeedlessOnboardingFeatureEnabled && firstTimeFlowType === _onboarding.FirstTimeFlowType.socialCreate) {
        newSecretRecoveryPhrase = await dispatch((0, _actions.createNewVaultAndSyncWithSocial)(password));
      } else if (firstTimeFlowType === _onboarding.FirstTimeFlowType.create) {
        newSecretRecoveryPhrase = await dispatch((0, _actions.createNewVaultAndGetSeedPhrase)(password));
      }
      setSecretRecoveryPhrase(newSecretRecoveryPhrase);
    } finally {
      setIsLoading(false);
    }
  };
  const handleUnlock = async password => {
    try {
      setIsLoading(true);
      let retrievedSecretRecoveryPhrase;
      if (isSeedlessOnboardingFeatureEnabled && firstTimeFlowType === _onboarding.FirstTimeFlowType.socialImport) {
        retrievedSecretRecoveryPhrase = await dispatch((0, _actions.restoreSocialBackupAndGetSeedPhrase)(password));
      } else {
        retrievedSecretRecoveryPhrase = await dispatch((0, _actions.unlockAndGetSeedPhrase)(password));
      }
      setSecretRecoveryPhrase(retrievedSecretRecoveryPhrase);
      if (firstTimeFlowType === _onboarding.FirstTimeFlowType.socialImport) {
        await dispatch((0, _actions.setCompletedOnboarding)());
      }
      navigate(nextRoute, {
        replace: true
      });
    } finally {
      setIsLoading(false);
    }
  };
  const handleImportWithRecoveryPhrase = async (password, srp) => {
    return await dispatch((0, _actions.createNewVaultAndRestore)(password, srp));
  };
  let isFullPage = pathname === _routes.ONBOARDING_WELCOME_ROUTE || pathname === _routes.ONBOARDING_UNLOCK_ROUTE;
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    width: _designSystem.BlockSize.Full,
    height: _designSystem.BlockSize.Full,
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: pathname === _routes.ONBOARDING_WELCOME_ROUTE ? _designSystem.AlignItems.flexStart : _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.flexStart,
    className: (0, _classnames.default)('onboarding-flow', {
      'onboarding-flow--welcome-login': isWelcomePage
    })
  }, !isPopup && /*#__PURE__*/_react.default.createElement(_onboardingAppHeader.default, {
    isWelcomePage: isWelcomePage
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: (0, _classnames.default)('onboarding-flow__container', {
      'onboarding-flow__container--full': isFullPage,
      'onboarding-flow__container--popup': isPopup
    }),
    width: _designSystem.BlockSize.Full,
    borderStyle: isFullPage || isPopup ? _designSystem.BorderStyle.none : _designSystem.BorderStyle.solid,
    borderRadius: _designSystem.BorderRadius.LG,
    marginTop: pathname === _routes.ONBOARDING_WELCOME_ROUTE || isPopup ? 0 : 3,
    marginInline: "auto",
    borderColor: _designSystem.BorderColor.borderMuted
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Routes, null, /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
    path: _routes.ONBOARDING_ACCOUNT_EXIST,
    element: /*#__PURE__*/_react.default.createElement(_accountExist.default, null)
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
    path: _routes.ONBOARDING_ACCOUNT_NOT_FOUND,
    element: /*#__PURE__*/_react.default.createElement(_accountNotFound.default, null)
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
    path: _routes.ONBOARDING_CREATE_PASSWORD_ROUTE,
    element: /*#__PURE__*/_react.default.createElement(_createPassword.default, {
      createNewAccount: handleCreateNewAccount,
      importWithRecoveryPhrase: handleImportWithRecoveryPhrase,
      secretRecoveryPhrase: secretRecoveryPhrase
    })
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
    path: _routes.ONBOARDING_REVEAL_SRP_ROUTE,
    element: /*#__PURE__*/_react.default.createElement(_revealRecoveryPhrase.default, {
      setSecretRecoveryPhrase: setSecretRecoveryPhrase
    })
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
    path: _routes.ONBOARDING_REVIEW_SRP_ROUTE,
    element: /*#__PURE__*/_react.default.createElement(_reviewRecoveryPhrase.default, {
      secretRecoveryPhrase: secretRecoveryPhrase
    })
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
    path: _routes.ONBOARDING_CONFIRM_SRP_ROUTE,
    element: /*#__PURE__*/_react.default.createElement(_confirmRecoveryPhrase.default, {
      secretRecoveryPhrase: secretRecoveryPhrase
    })
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
    path: _routes.ONBOARDING_IMPORT_WITH_SRP_ROUTE,
    element: /*#__PURE__*/_react.default.createElement(_importSrp.default, {
      submitSecretRecoveryPhrase: setSecretRecoveryPhrase
    })
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
    path: _routes.ONBOARDING_UNLOCK_ROUTE,
    element: /*#__PURE__*/_react.default.createElement(_unlockPage.default, {
      onSubmit: handleUnlock
    })
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
    path: _routes.ONBOARDING_PRIVACY_SETTINGS_ROUTE,
    element: /*#__PURE__*/_react.default.createElement(_privacySettings.default, null)
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
    path: _routes.ONBOARDING_COMPLETION_ROUTE,
    element: /*#__PURE__*/_react.default.createElement(_creationSuccessful.default, null)
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
    path: _routes.ONBOARDING_WELCOME_ROUTE,
    element: /*#__PURE__*/_react.default.createElement(_welcome.default, null)
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
    path: _routes.ONBOARDING_PIN_EXTENSION_ROUTE,
    element: /*#__PURE__*/_react.default.createElement(_pinExtension.default, null)
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
    path: _routes.ONBOARDING_METAMETRICS,
    element: /*#__PURE__*/_react.default.createElement(_metametrics2.default, null)
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
    path: _routes.ONBOARDING_DOWNLOAD_APP_ROUTE,
    element: /*#__PURE__*/_react.default.createElement(_downloadApp.default, null)
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
    path: "*",
    element: /*#__PURE__*/_react.default.createElement(_onboardingFlowSwitch.default, null)
  }))), isLoading && /*#__PURE__*/_react.default.createElement(_loadingScreen.default, null));
}
function setOnboardingDate() {
  (0, _utils.submitRequestToBackgroundAndCatch)('setOnboardingDate');
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\onboarding-flow\\onboarding-flow.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\pin-extension\\pin-extension.js", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/onboarding":"D:\\code\\v\\metamask-extension\\shared\\constants\\onboarding.ts","../../../../shared/modules/browser-runtime.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\browser-runtime.utils.js","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-responsive-carousel":"D:\\code\\v\\metamask-extension\\node_modules\\react-responsive-carousel\\lib\\js\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Conboarding-flow%5Cpin-extension%5Cpin-extension.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = OnboardingPinExtension;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _reactRedux = require("react-redux");
var _reactResponsiveCarousel = require("react-responsive-carousel");
var _classnames = _interopRequireDefault(require("classnames"));
var _actions = require("../../../store/actions");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _designSystem = require("../../../helpers/constants/design-system");
var _routes = require("../../../helpers/constants/routes");
var _componentLibrary = require("../../../components/component-library");
var _metametrics = require("../../../contexts/metametrics");
var _selectors = require("../../../selectors");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _onboarding = require("../../../../shared/constants/onboarding");
var _browserRuntime = require("../../../../shared/modules/browser-runtime.utils");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function OnboardingPinExtension() {
  const t = (0, _useI18nContext.useI18nContext)();
  const navigate = (0, _reactRouterDomV5Compat.useNavigate)();
  const [selectedIndex, setSelectedIndex] = (0, _react.useState)(0);
  const dispatch = (0, _reactRedux.useDispatch)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const firstTimeFlowType = (0, _reactRedux.useSelector)(_selectors.getFirstTimeFlowType);
  const currentKeyring = (0, _reactRedux.useSelector)(_selectors.getCurrentKeyring);
  const externalServicesOnboardingToggleState = (0, _reactRedux.useSelector)(_selectors.getExternalServicesOnboardingToggleState);
  const handleClick = async () => {
    await dispatch((0, _actions.toggleExternalServices)(externalServicesOnboardingToggleState));
    await dispatch((0, _actions.setCompletedOnboarding)());
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.Onboarding,
      event: _metametrics2.MetaMetricsEventName.ExtensionPinned,
      properties: {
        wallet_setup_type: firstTimeFlowType === _onboarding.FirstTimeFlowType.import ? 'import' : 'new',
        new_wallet: firstTimeFlowType === _onboarding.FirstTimeFlowType.create
      }
    });
    navigate(_routes.DEFAULT_ROUTE);
  };
  (0, _react.useEffect)(() => {
    // if the user has not created a wallet, redirect to onboarding welcome route
    if (!currentKeyring) {
      navigate(_routes.ONBOARDING_WELCOME_ROUTE, {
        replace: true
      });
    }
  }, [currentKeyring, navigate]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    height: _designSystem.BlockSize.Full,
    gap: 6,
    className: "onboarding-pin-extension",
    "data-testid": "onboarding-pin-extension"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_reactResponsiveCarousel.Carousel, {
    selectedItem: selectedIndex,
    showThumbs: false,
    showStatus: false,
    dynamicHeight: true,
    renderArrowPrev: (onClickHandler, hasPrev, label) => /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      iconName: _componentLibrary.IconName.Arrow2Left,
      size: _componentLibrary.ButtonIconSize.Lg,
      borderRadius: _designSystem.BorderRadius.full,
      borderWidth: 2,
      borderColor: _designSystem.IconColor.iconDefault,
      className: (0, _classnames.default)('onboarding-pin-extension__arrow', {
        'onboarding-pin-extension__arrow--disabled': !hasPrev
      }),
      disabled: !hasPrev,
      title: label,
      onClick: onClickHandler,
      ariaLabel: t('prev')
    }),
    renderArrowNext: (onClickHandler, hasNext, label) => /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      iconName: _componentLibrary.IconName.Arrow2Right,
      size: _componentLibrary.ButtonIconSize.Lg,
      borderRadius: _designSystem.BorderRadius.full,
      borderWidth: 2,
      borderColor: _designSystem.IconColor.iconDefault,
      className: (0, _classnames.default)('onboarding-pin-extension__arrow', 'onboarding-pin-extension__arrow--next', {
        'onboarding-pin-extension__arrow--disabled': !hasNext
      }),
      disabled: !hasNext,
      title: label,
      onClick: onClickHandler,
      ariaLabel: t('next'),
      "data-testid": "pin-extension-next"
    }),
    onChange: index => setSelectedIndex(index)
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.flexStart,
    justifyContent: _designSystem.JustifyContent.center,
    className: "onboarding-pin-extension__image-container"
  }, /*#__PURE__*/_react.default.createElement("img", {
    src: "/images/onboarding-extension-pin.svg",
    alt: t('onboardingPinExtensionAltPin')
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.flexStart,
    justifyContent: _designSystem.JustifyContent.center,
    className: "onboarding-pin-extension__image-container"
  }, /*#__PURE__*/_react.default.createElement("img", {
    src: "/images/onboarding-extension-launch.svg",
    alt: t('onboardingPinExtensionAltLaunch')
  }))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: _designSystem.JustifyContent.flexStart,
    width: _designSystem.BlockSize.Full,
    marginTop: 4,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingLg,
    fontWeight: _designSystem.FontWeight.Medium,
    as: "h2"
  }, t('onboardingPinExtensionTitle')), selectedIndex === 0 ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd
  }, t('onboardingPinExtensionDescription'))) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd
  }, t('onboardingPinExtensionDescription2')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd
  }, t('onboardingPinExtensionDescription3', [(0, _browserRuntime.getBrowserName)()]))))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    variant: _componentLibrary.ButtonVariant.Primary,
    size: _componentLibrary.ButtonSize.Lg,
    block: true,
    "data-testid": "pin-extension-done",
    onClick: handleClick
  }, t('done'))));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\onboarding-flow\\pin-extension\\pin-extension.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\privacy-settings\\privacy-settings.js", {"../../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../shared/lib/ui-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\ui-utils.js","../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../components/app/identity/backup-and-sync-toggle/backup-and-sync-toggle":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\identity\\backup-and-sync-toggle\\backup-and-sync-toggle.tsx","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/ui/button":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\button\\index.js","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../ducks/app/app":"D:\\code\\v\\metamask-extension\\ui\\ducks\\app\\app.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../helpers/constants/zendesk-url":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\zendesk-url.js","../../../hooks/identity/useBackupAndSync":"D:\\code\\v\\metamask-extension\\ui\\hooks\\identity\\useBackupAndSync\\index.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/identity/backup-and-sync":"D:\\code\\v\\metamask-extension\\ui\\selectors\\identity\\backup-and-sync.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../settings/security-tab/delete-metametrics-data-button":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\security-tab\\delete-metametrics-data-button\\index.ts","../../settings/security-tab/metametrics-toggle/metametrics-toggle":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\security-tab\\metametrics-toggle\\metametrics-toggle.tsx","./setting":"D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\privacy-settings\\setting.js","@metamask/profile-sync-controller/user-storage":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\profile-sync-controller\\dist\\controllers\\user-storage\\index.cjs","@metamask/snaps-sdk":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\index.cjs","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Conboarding-flow%5Cprivacy-settings%5Cprivacy-settings.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = PrivacySettings;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _classnames = _interopRequireDefault(require("classnames"));
var _snapsSdk = require("@metamask/snaps-sdk");
var _userStorage = require("@metamask/profile-sync-controller/user-storage");
var _loglevel = _interopRequireDefault(require("loglevel"));
var _util = require("../../../../app/scripts/lib/util");
var _useBackupAndSync = require("../../../hooks/identity/useBackupAndSync");
var _metametrics = require("../../../../shared/constants/metametrics");
var _uiUtils = require("../../../../shared/lib/ui-utils");
var _zendeskUrl = _interopRequireDefault(require("../../../helpers/constants/zendesk-url"));
var _button = _interopRequireDefault(require("../../../components/ui/button"));
var _componentLibrary = require("../../../components/component-library");
var _metametrics2 = require("../../../contexts/metametrics");
var _designSystem = require("../../../helpers/constants/design-system");
var _routes = require("../../../helpers/constants/routes");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _selectors = require("../../../selectors");
var _networks = require("../../../../shared/modules/selectors/networks");
var _actions = require("../../../store/actions");
var _app = require("../../../ducks/app/app");
var _network = require("../../../../shared/constants/network");
var _backupAndSync = require("../../../selectors/identity/backup-and-sync");
var _backupAndSyncToggle = require("../../../components/app/identity/backup-and-sync-toggle/backup-and-sync-toggle");
var _deleteMetametricsDataButton = _interopRequireDefault(require("../../settings/security-tab/delete-metametrics-data-button"));
var _metametricsToggle = _interopRequireDefault(require("../../settings/security-tab/metametrics-toggle/metametrics-toggle"));
var _setting = require("./setting");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

const ANIMATION_TIME = 500;
function PrivacySettings() {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const navigate = (0, _reactRouterDomV5Compat.useNavigate)();
  const [showDetail, setShowDetail] = (0, _react.useState)(false);
  const [selectedItem, setSelectedItem] = (0, _react.useState)(null);
  const [hiddenClass, setHiddenClass] = (0, _react.useState)(true);
  const defaultState = (0, _reactRedux.useSelector)(state => state.metamask);
  const {
    use4ByteResolution,
    useTokenDetection,
    useCurrencyRateCheck,
    useMultiAccountBalanceChecker,
    ipfsGateway,
    useAddressBarEnsResolution,
    useTransactionSimulations
  } = defaultState;
  const useExternalNameSources = (0, _reactRedux.useSelector)(_selectors.getUseExternalNameSources);
  const isSocialLoginFlow = (0, _reactRedux.useSelector)(_selectors.getIsSocialLoginFlow);
  const dataCollectionForMarketing = (0, _reactRedux.useSelector)(_selectors.getDataCollectionForMarketing);
  const [turnOn4ByteResolution, setTurnOn4ByteResolution] = (0, _react.useState)(use4ByteResolution);
  const [turnOnTokenDetection, setTurnOnTokenDetection] = (0, _react.useState)(useTokenDetection);
  const [turnOnCurrencyRateCheck, setTurnOnCurrencyRateCheck] = (0, _react.useState)(useCurrencyRateCheck);
  const [isMultiAccountBalanceCheckerEnabled, setMultiAccountBalanceCheckerEnabled] = (0, _react.useState)(useMultiAccountBalanceChecker);
  const [isTransactionSimulationsEnabled, setTransactionSimulationsEnabled] = (0, _react.useState)(useTransactionSimulations);
  const [ipfsURL, setIPFSURL] = (0, _react.useState)(ipfsGateway);
  const [ipfsError, setIPFSError] = (0, _react.useState)(null);
  const [addressBarResolution, setAddressBarResolution] = (0, _react.useState)(useAddressBarEnsResolution);
  const [turnOnExternalNameSources, setTurnOnExternalNameSources] = (0, _react.useState)(useExternalNameSources);
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const networkConfigurations = (0, _reactRedux.useSelector)(_networks.getNetworkConfigurationsByChainId);
  const externalServicesOnboardingToggleState = (0, _reactRedux.useSelector)(_selectors.getExternalServicesOnboardingToggleState);
  const isBackupAndSyncEnabled = (0, _reactRedux.useSelector)(_backupAndSync.selectIsBackupAndSyncEnabled);
  const {
    setIsBackupAndSyncFeatureEnabled,
    error: backupAndSyncError
  } = (0, _useBackupAndSync.useBackupAndSync)();
  (0, _react.useEffect)(() => {
    if (externalServicesOnboardingToggleState) {
      setIsBackupAndSyncFeatureEnabled(_userStorage.BACKUPANDSYNC_FEATURES.main, true);
    } else {
      setIsBackupAndSyncFeatureEnabled(_userStorage.BACKUPANDSYNC_FEATURES.main, false);
    }
  }, [externalServicesOnboardingToggleState, setIsBackupAndSyncFeatureEnabled]);
  const handleSubmit = () => {
    dispatch((0, _actions.setUse4ByteResolution)(turnOn4ByteResolution));
    dispatch((0, _actions.setUseTokenDetection)(turnOnTokenDetection));
    dispatch((0, _actions.setUseMultiAccountBalanceChecker)(isMultiAccountBalanceCheckerEnabled));
    dispatch((0, _actions.setUseCurrencyRateCheck)(turnOnCurrencyRateCheck));
    dispatch((0, _actions.setUseAddressBarEnsResolution)(addressBarResolution));
    (0, _actions.setUseTransactionSimulations)(isTransactionSimulationsEnabled);
    (0, _actions.setUseExternalNameSources)(turnOnExternalNameSources);

    // Backup and sync Setup
    if (!externalServicesOnboardingToggleState) {
      setIsBackupAndSyncFeatureEnabled(_userStorage.BACKUPANDSYNC_FEATURES.main, false);
    }
    if (ipfsURL && !ipfsError) {
      const {
        host
      } = new URL((0, _util.addUrlProtocolPrefix)(ipfsURL));
      dispatch((0, _actions.setIpfsGateway)(host));
    }
    trackEvent({
      category: _metametrics.MetaMetricsEventCategory.Onboarding,
      event: _metametrics.MetaMetricsEventName.OnboardingWalletAdvancedSettings,
      properties: {
        settings_group: 'onboarding_advanced_configuration',
        is_profile_syncing_enabled: isBackupAndSyncEnabled,
        is_basic_functionality_enabled: externalServicesOnboardingToggleState,
        turnon_token_detection: turnOnTokenDetection
      }
    });
    navigate(_routes.ONBOARDING_COMPLETION_ROUTE, {
      replace: true
    });
  };
  const handleIPFSChange = url => {
    setIPFSURL(url);
    try {
      const {
        host
      } = new URL((0, _util.addUrlProtocolPrefix)(url));
      if (!host || host === 'gateway.ipfs.io') {
        throw new Error();
      }
      setIPFSError(null);
    } catch (error) {
      setIPFSError(t('onboardingAdvancedPrivacyIPFSInvalid'));
    }
  };
  const handleItemSelected = item => {
    setSelectedItem(item);
    setShowDetail(true);
    setTimeout(() => {
      setHiddenClass(false);
    }, ANIMATION_TIME);
  };
  const handleBack = () => {
    setShowDetail(false);
    setTimeout(() => {
      setHiddenClass(true);
    }, ANIMATION_TIME);
  };
  const items = [{
    id: 1,
    title: t('general'),
    subtitle: t('generalDescription')
  }, {
    id: 2,
    title: t('assets'),
    subtitle: t('assetsDescription')
  }, {
    id: 3,
    title: isSocialLoginFlow ? t('securityDefaultSettingsSocialLogin') : t('security'),
    subtitle: isSocialLoginFlow ? t('securitySocialLoginDefaultSettingsDescription') : t('securityDescription')
  }];
  const handleDataCollectionForMarketing = async value => {
    try {
      dispatch((0, _actions.setMarketingConsent)(value));
    } catch (error) {
      _loglevel.default.error('Error setting marketing consent in default settings', error);
    }
    dispatch((0, _actions.setDataCollectionForMarketing)(value));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "privacy-settings",
    "data-testid": "privacy-settings"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('container', {
      'show-detail': showDetail,
      'show-list': !showDetail
    })
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "list-view"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "privacy-settings__header",
    marginTop: 6,
    marginBottom: 6,
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: _designSystem.JustifyContent.flexStart
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    flexDirection: _designSystem.FlexDirection.Row,
    justifyContent: _designSystem.JustifyContent.flexStart
  }, /*#__PURE__*/_react.default.createElement(_button.default, {
    type: "inline",
    icon: /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
      name: _componentLibrary.IconName.ArrowLeft,
      size: _componentLibrary.IconSize.Lg,
      color: _designSystem.IconColor.iconDefault
    }),
    "data-testid": "privacy-settings-back-button",
    onClick: handleSubmit
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingLg,
    as: "h2"
  }, t('defaultSettingsTitle')))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyLgMedium,
    marginTop: 5
  }, t('defaultSettingsSubTitle')), /*#__PURE__*/_react.default.createElement("a", {
    href: "https://support.metamask.io/privacy-and-security/privacy-best-practices",
    target: "_blank",
    rel: "noreferrer",
    key: "learnMoreAboutPrivacy",
    style: {
      fontSize: 'var(--font-size-5)'
    }
  }, t('learnMoreAboutPrivacy'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    as: "ul",
    marginTop: 4,
    marginBottom: 4,
    style: {
      listStyleType: 'none'
    },
    className: "privacy-settings__categories-list"
  }, items.map(item => /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginTop: 5,
    marginBottom: 5,
    key: item.id,
    className: "categories-item",
    onClick: () => handleItemSelected(item)
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.flexStart,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    "data-testid": `category-item-${item.title}`
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyLgMedium
  }, item.title), /*#__PURE__*/_react.default.createElement(_button.default, {
    type: "inline",
    icon: /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
      name: _componentLibrary.IconName.ArrowRight,
      color: _designSystem.IconColor.iconDefault
    }),
    onClick: () => handleItemSelected(item)
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    className: "description",
    variant: _designSystem.TextVariant.bodyMd,
    color: _designSystem.TextColor.textAlternative
  }, item.subtitle)))))), /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('detail-view', {
      hidden: !showDetail && hiddenClass
    })
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "privacy-settings__header",
    marginTop: 6,
    marginBottom: 5,
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    justifyContent: _designSystem.JustifyContent.flexStart
  }, /*#__PURE__*/_react.default.createElement(_button.default, {
    "data-testid": "category-back-button",
    type: "inline",
    icon: /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
      name: _componentLibrary.IconName.ArrowLeft,
      size: _componentLibrary.IconSize.Lg,
      color: _designSystem.IconColor.iconDefault
    }),
    onClick: handleBack
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingLg,
    as: "h2"
  }, selectedItem === null || selectedItem === void 0 ? void 0 : selectedItem.title))), /*#__PURE__*/_react.default.createElement("div", {
    className: "privacy-settings__settings",
    "data-testid": "privacy-settings-settings"
  }, (selectedItem === null || selectedItem === void 0 ? void 0 : selectedItem.id) === 1 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_setting.Setting, {
    dataTestId: "basic-functionality-toggle",
    value: externalServicesOnboardingToggleState,
    setValue: toggledValue => {
      if (toggledValue) {
        dispatch((0, _app.onboardingToggleBasicFunctionalityOn)());
        trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Onboarding,
          event: _metametrics.MetaMetricsEventName.SettingsUpdated,
          properties: {
            settings_group: 'onboarding_advanced_configuration',
            settings_type: 'basic_functionality',
            old_value: false,
            new_value: true,
            was_profile_syncing_on: false
          }
        });
      } else {
        dispatch((0, _app.openBasicFunctionalityModal)());
      }
    },
    title: t('basicConfigurationLabel'),
    description: t('basicConfigurationDescription', [/*#__PURE__*/_react.default.createElement("a", {
      href: "https://consensys.io/privacy-policy",
      key: "link",
      target: "_blank",
      rel: "noreferrer noopener"
    }, t('privacyMsg'))])
  }), /*#__PURE__*/_react.default.createElement(_backupAndSyncToggle.BackupAndSyncToggle, null), backupAndSyncError && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingBottom: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "p",
    color: _designSystem.TextColor.errorDefault,
    variant: _designSystem.TextVariant.bodySm
  }, t('notificationsSettingsBoxError'))), /*#__PURE__*/_react.default.createElement(_setting.Setting, {
    title: t('onboardingAdvancedPrivacyNetworkTitle'),
    showToggle: false,
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, t('onboardingAdvancedPrivacyNetworkDescription', [/*#__PURE__*/_react.default.createElement("a", {
      href: "https://consensys.io/privacy-policy/",
      key: "link",
      target: "_blank",
      rel: "noopener noreferrer"
    }, t('privacyMsg')), /*#__PURE__*/_react.default.createElement("a", {
      href: _zendeskUrl.default.ADD_SOLANA_ACCOUNTS,
      key: "link",
      target: "_blank",
      rel: "noopener noreferrer"
    }, t('onboardingAdvancedPrivacyNetworkDescriptionCallToAction'))]), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      paddingTop: 4
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      gap: 5
    }, Object.values(networkConfigurations).filter(({
      chainId
    }) => !_network.TEST_CHAINS.includes(chainId)).map(network => {
      var _URL, _network$rpcEndpoints;
      return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        key: network.chainId,
        className: "privacy-settings__customizable-network",
        onClick: () => {
          dispatch((0, _actions.setEditedNetwork)({
            chainId: network.chainId
          }));
          dispatch((0, _actions.toggleNetworkMenu)());
        },
        display: _designSystem.Display.Flex,
        alignItems: _designSystem.AlignItems.center,
        justifyContent: _designSystem.JustifyContent.spaceBetween
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        display: _designSystem.Display.Flex,
        alignItems: _designSystem.AlignItems.center
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
        src: _network.CHAIN_ID_TO_NETWORK_IMAGE_URL_MAP[network.chainId]
      }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        textAlign: _designSystem.TextAlign.Left,
        marginLeft: 3
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        variant: _designSystem.TextVariant.bodySmMedium
      }, network.name), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        variant: _designSystem.TextVariant.bodyXs,
        color: _designSystem.TextColor.textAlternative
      }, // Get just the protocol + domain, not the infura key in path
      (_URL = new URL(network === null || network === void 0 || (_network$rpcEndpoints = network.rpcEndpoints[network === null || network === void 0 ? void 0 : network.defaultRpcEndpointIndex]) === null || _network$rpcEndpoints === void 0 ? void 0 : _network$rpcEndpoints.url)) === null || _URL === void 0 ? void 0 : _URL.origin))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
        iconName: _componentLibrary.IconName.ArrowRight,
        size: _componentLibrary.IconSize.Md
      }));
    }), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
      onClick: () => {
        dispatch((0, _actions.toggleNetworkMenu)({
          isAddingNewNetwork: true
        }));
      },
      justifyContent: _designSystem.JustifyContent.Left,
      variant: _snapsSdk.ButtonVariant.link
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      alignItems: _designSystem.AlignItems.center
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
      name: _componentLibrary.IconName.Add,
      marginRight: 3
    }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      color: _designSystem.TextColor.primaryDefault
    }, t('addANetwork')))))))
  })) : null, (selectedItem === null || selectedItem === void 0 ? void 0 : selectedItem.id) === 2 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_setting.Setting, {
    value: turnOnTokenDetection,
    setValue: setTurnOnTokenDetection,
    title: t('turnOnTokenDetection'),
    description: t('useTokenDetectionPrivacyDesc')
  }), /*#__PURE__*/_react.default.createElement(_setting.Setting, {
    value: isTransactionSimulationsEnabled,
    setValue: setTransactionSimulationsEnabled,
    title: t('simulationsSettingSubHeader'),
    description: t('simulationsSettingDescription', [/*#__PURE__*/_react.default.createElement("a", {
      key: "learn_more_link",
      href: _uiUtils.TRANSACTION_SIMULATIONS_LEARN_MORE_LINK,
      rel: "noreferrer",
      target: "_blank"
    }, t('learnMoreUpperCase'))])
  }), /*#__PURE__*/_react.default.createElement(_setting.Setting, {
    title: t('onboardingAdvancedPrivacyIPFSTitle'),
    showToggle: false,
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, t('onboardingAdvancedPrivacyIPFSDescription'), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      paddingTop: 2
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.TextField, {
      value: ipfsURL,
      style: {
        width: '100%'
      },
      inputProps: {
        'data-testid': 'ipfs-input'
      },
      onChange: e => {
        handleIPFSChange(e.target.value);
      }
    }), ipfsURL ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodySm,
      color: ipfsError ? _designSystem.TextColor.errorDefault : _designSystem.TextColor.successDefault
    }, ipfsError || t('onboardingAdvancedPrivacyIPFSValid')) : null))
  }), /*#__PURE__*/_react.default.createElement(_setting.Setting, {
    value: turnOnCurrencyRateCheck,
    setValue: setTurnOnCurrencyRateCheck,
    title: t('currencyRateCheckToggle'),
    dataTestId: "currency-rate-check-toggle",
    description: t('currencyRateCheckToggleDescription', [/*#__PURE__*/_react.default.createElement("a", {
      key: "coingecko_link",
      href: _uiUtils.COINGECKO_LINK,
      rel: "noreferrer",
      target: "_blank"
    }, t('coingecko')), /*#__PURE__*/_react.default.createElement("a", {
      key: "cryptocompare_link",
      href: _uiUtils.CRYPTOCOMPARE_LINK,
      rel: "noreferrer",
      target: "_blank"
    }, t('cryptoCompare')), /*#__PURE__*/_react.default.createElement("a", {
      key: "privacy_policy_link",
      href: _uiUtils.PRIVACY_POLICY_LINK,
      rel: "noreferrer",
      target: "_blank"
    }, t('privacyMsg'))])
  }), /*#__PURE__*/_react.default.createElement(_setting.Setting, {
    value: addressBarResolution,
    setValue: setAddressBarResolution,
    title: t('ensDomainsSettingTitle'),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.inherit
    }, t('ensDomainsSettingDescriptionIntroduction')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      as: "ul",
      marginTop: 4,
      marginBottom: 4,
      paddingInlineStart: 4,
      style: {
        listStyleType: 'circle'
      }
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.inherit,
      as: "li"
    }, t('ensDomainsSettingDescriptionPart1')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.inherit,
      as: "li"
    }, t('ensDomainsSettingDescriptionPart2'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.inherit
    }, t('ensDomainsSettingDescriptionOutroduction')))
  }), /*#__PURE__*/_react.default.createElement(_setting.Setting, {
    value: isMultiAccountBalanceCheckerEnabled,
    setValue: setMultiAccountBalanceCheckerEnabled,
    title: t('useMultiAccountBalanceChecker'),
    description: t('useMultiAccountBalanceCheckerSettingDescription')
  })) : null, (selectedItem === null || selectedItem === void 0 ? void 0 : selectedItem.id) === 3 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_setting.Setting, {
    value: turnOn4ByteResolution,
    setValue: setTurnOn4ByteResolution,
    title: t('use4ByteResolution'),
    description: t('toggleDecodeDescription')
  }), /*#__PURE__*/_react.default.createElement(_setting.Setting, {
    value: turnOnExternalNameSources,
    setValue: setTurnOnExternalNameSources,
    title: t('externalNameSourcesSetting'),
    description: t('externalNameSourcesSettingDescription')
  }), isSocialLoginFlow && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_metametricsToggle.default, {
    dataCollectionForMarketing: dataCollectionForMarketing,
    setDataCollectionForMarketing: handleDataCollectionForMarketing,
    fromDefaultSettings: true
  }), /*#__PURE__*/_react.default.createElement(_deleteMetametricsDataButton.default, {
    defaultPrivacySettings: true
  }))) : null)))));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\onboarding-flow\\privacy-settings\\privacy-settings.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\privacy-settings\\setting.js", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/ui/toggle-button":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\toggle-button\\index.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Conboarding-flow%5Cprivacy-settings%5Csetting.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Setting = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _componentLibrary = require("../../../components/component-library");
var _toggleButton = _interopRequireDefault(require("../../../components/ui/toggle-button"));
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const Setting = ({
  value,
  setValue,
  title,
  description,
  showToggle = true,
  dataTestId,
  disabled = false
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    alignItems: _designSystem.AlignItems.flexStart,
    marginTop: 3,
    marginBottom: 3,
    className: "privacy-settings__setting__wrapper",
    "data-testid": dataTestId
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "privacy-settings__setting"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium
  }, title), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative,
    as: "div"
  }, description)), showToggle ? /*#__PURE__*/_react.default.createElement("div", {
    className: "privacy-settings__setting__toggle"
  }, /*#__PURE__*/_react.default.createElement(_toggleButton.default, {
    value: value,
    onToggle: val => setValue(!val),
    offLabel: t('off'),
    onLabel: t('on'),
    disabled: disabled
  })) : null);
};
exports.Setting = Setting;
Setting.propTypes = {
  value: _propTypes.default.bool,
  setValue: _propTypes.default.func,
  title: _propTypes.default.string,
  description: _propTypes.default.oneOfType([_propTypes.default.object, _propTypes.default.string]),
  showToggle: _propTypes.default.bool,
  dataTestId: _propTypes.default.string,
  disabled: _propTypes.default.bool
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\onboarding-flow\\privacy-settings\\setting.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\recovery-phrase\\confirm-recovery-phrase.js", {"../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../../shared/modules/browser-runtime.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\browser-runtime.utils.js","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./confirm-srp-modal":"D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\recovery-phrase\\confirm-srp-modal.tsx","./recovery-phrase-chips":"D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\recovery-phrase\\recovery-phrase-chips.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Conboarding-flow%5Crecovery-phrase%5Cconfirm-recovery-phrase.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ConfirmRecoveryPhrase;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _reactRedux = require("react-redux");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _actions = require("../../../store/actions");
var _metametrics = require("../../../contexts/metametrics");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _selectors = require("../../../selectors/selectors");
var _routes = require("../../../helpers/constants/routes");
var _app = require("../../../../shared/constants/app");
var _trace = require("../../../../shared/lib/trace");
var _browserRuntime = require("../../../../shared/modules/browser-runtime.utils");
var _confirmSrpModal = _interopRequireDefault(require("./confirm-srp-modal"));
var _recoveryPhraseChips = _interopRequireDefault(require("./recovery-phrase-chips"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const QUIZ_WORDS_COUNT = 3;
const generateQuizWords = secretRecoveryPhrase => {
  const randomIndices = new Set();
  const srpLength = secretRecoveryPhrase.length;
  if (srpLength === 0) {
    return [];
  }
  while (randomIndices.size < QUIZ_WORDS_COUNT) {
    const randomIndex = Math.floor(Math.random() * srpLength);
    randomIndices.add(randomIndex);
  }
  const quizWords = Array.from(randomIndices).map(index => {
    return {
      index,
      word: secretRecoveryPhrase[index]
    };
  });
  return quizWords;
};
function ConfirmRecoveryPhrase({
  secretRecoveryPhrase = ''
}) {
  const dispatch = (0, _reactRedux.useDispatch)();
  const navigate = (0, _reactRouterDomV5Compat.useNavigate)();
  const {
    search
  } = (0, _reactRouterDomV5Compat.useLocation)();
  const t = (0, _useI18nContext.useI18nContext)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const {
    bufferedEndTrace
  } = trackEvent;
  const hdEntropyIndex = (0, _reactRedux.useSelector)(_selectors.getHDEntropyIndex);
  const splitSecretRecoveryPhrase = (0, _react.useMemo)(() => secretRecoveryPhrase ? secretRecoveryPhrase.split(' ') : [], [secretRecoveryPhrase]);
  const searchParams = new URLSearchParams(search);
  const isFromReminder = searchParams.get('isFromReminder');
  const isFromSettingsSecurity = searchParams.get('isFromSettingsSecurity');
  const queryParams = new URLSearchParams();
  if (isFromReminder) {
    queryParams.set('isFromReminder', isFromReminder);
  }
  if (isFromSettingsSecurity) {
    queryParams.set('isFromSettingsSecurity', isFromSettingsSecurity);
  }
  const nextRouteQueryString = queryParams.toString();
  const [showConfirmModal, setShowConfirmModal] = (0, _react.useState)(false);
  const [matching, setMatching] = (0, _react.useState)(false);
  const [quizWords, setQuizWords] = (0, _react.useState)(generateQuizWords(splitSecretRecoveryPhrase));
  const [answerSrp, setAnswerSrp] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    if (!secretRecoveryPhrase) {
      navigate(`${_routes.ONBOARDING_REVEAL_SRP_ROUTE}${nextRouteQueryString ? `?${nextRouteQueryString}` : ''}`, {
        replace: true
      });
    }
  }, [navigate, secretRecoveryPhrase, nextRouteQueryString]);
  const resetQuizWords = (0, _react.useCallback)(() => {
    const newQuizWords = generateQuizWords(splitSecretRecoveryPhrase);
    setQuizWords(newQuizWords);
  }, [splitSecretRecoveryPhrase]);
  const handleQuizInput = (0, _react.useCallback)(inputValue => {
    const isNotAnswered = inputValue.some(answer => !answer.word);
    if (isNotAnswered) {
      setAnswerSrp('');
    } else {
      const copySplitSrp = [...splitSecretRecoveryPhrase];
      inputValue.forEach(answer => {
        copySplitSrp[answer.index] = answer.word;
      });
      setAnswerSrp(copySplitSrp.join(' '));
    }
  }, [splitSecretRecoveryPhrase]);
  const onContinue = (0, _react.useCallback)(() => {
    const isMatching = answerSrp === secretRecoveryPhrase;
    setMatching(isMatching);
    setShowConfirmModal(true);
  }, [answerSrp, secretRecoveryPhrase]);
  const handleConfirmedPhrase = (0, _react.useCallback)(() => {
    dispatch((0, _actions.setSeedPhraseBackedUp)(true));
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.Onboarding,
      event: _metametrics2.MetaMetricsEventName.OnboardingWalletSecurityPhraseConfirmed,
      properties: {
        hd_entropy_index: hdEntropyIndex
      }
    });
    bufferedEndTrace === null || bufferedEndTrace === void 0 || bufferedEndTrace({
      name: _trace.TraceName.OnboardingNewSrpCreateWallet
    });
    bufferedEndTrace === null || bufferedEndTrace === void 0 || bufferedEndTrace({
      name: _trace.TraceName.OnboardingJourneyOverall
    });
    const nextRoute = (0, _browserRuntime.getBrowserName)() === _app.PLATFORM_FIREFOX || isFromReminder ? _routes.ONBOARDING_COMPLETION_ROUTE : _routes.ONBOARDING_METAMETRICS;
    navigate(`${nextRoute}${nextRouteQueryString ? `?${nextRouteQueryString}` : ''}`, {
      replace: true
    });
  }, [dispatch, hdEntropyIndex, navigate, trackEvent, isFromReminder, nextRouteQueryString, bufferedEndTrace]);
  const onClose = (0, _react.useCallback)(() => {
    navigate(_routes.REVEAL_SRP_LIST_ROUTE, {
      replace: true
    });
  }, [navigate]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    height: _designSystem.BlockSize.Full,
    gap: 6,
    className: "recovery-phrase recovery-phrase__confirm",
    "data-testid": "confirm-recovery-phrase"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, showConfirmModal && /*#__PURE__*/_react.default.createElement(_confirmSrpModal.default, {
    isError: !matching,
    onContinue: handleConfirmedPhrase,
    onClose: () => {
      resetQuizWords();
      setShowConfirmModal(false);
    }
  }), isFromReminder && isFromSettingsSecurity ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "recovery-phrase__header",
    display: _designSystem.Display.Grid,
    alignItems: _designSystem.AlignItems.center,
    gap: 1,
    marginBottom: 4,
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    iconName: _componentLibrary.IconName.ArrowLeft,
    color: _designSystem.IconColor.iconDefault,
    size: _componentLibrary.ButtonIconSize.Md,
    "data-testid": "reveal-recovery-phrase-confirm-back-button",
    onClick: () => navigate(-1),
    ariaLabel: t('back')
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingSm,
    textAlign: _designSystem.TextAlign.Center
  }, t('confirmRecoveryPhraseTitleSettings')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    iconName: _componentLibrary.IconName.Close,
    color: _designSystem.IconColor.iconDefault,
    size: _componentLibrary.ButtonIconSize.Md,
    "data-testid": "reveal-recovery-phrase-confirm-close-button",
    onClick: onClose,
    ariaLabel: t('close')
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    justifyContent: _designSystem.JustifyContent.flexStart,
    marginBottom: 4,
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    iconName: _componentLibrary.IconName.ArrowLeft,
    color: _designSystem.IconColor.iconDefault,
    size: _componentLibrary.ButtonIconSize.Md,
    "data-testid": "confirm-recovery-phrase-back-button",
    onClick: () => navigate(-1),
    ariaLabel: t('back')
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    justifyContent: _designSystem.JustifyContent.flexStart,
    marginBottom: 4,
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingLg,
    as: "h2"
  }, t('confirmRecoveryPhraseTitle')))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginBottom: 6
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    color: _designSystem.TextColor.textDefault
  }, t('confirmRecoveryPhraseDetails'))), splitSecretRecoveryPhrase.length > 0 && /*#__PURE__*/_react.default.createElement(_recoveryPhraseChips.default, {
    secretRecoveryPhrase: splitSecretRecoveryPhrase,
    quizWords: quizWords,
    confirmPhase: true,
    setInputValue: handleQuizInput
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    variant: _componentLibrary.ButtonVariant.Primary,
    width: _designSystem.BlockSize.Full,
    "data-testid": "recovery-phrase-confirm",
    size: _componentLibrary.ButtonSize.Lg,
    className: "recovery-phrase__footer__confirm--button",
    onClick: () => onContinue(),
    disabled: answerSrp.trim() === ''
  }, t('continue'))));
}
ConfirmRecoveryPhrase.propTypes = {
  secretRecoveryPhrase: _propTypes.default.string
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\onboarding-flow\\recovery-phrase\\confirm-recovery-phrase.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\recovery-phrase\\confirm-srp-modal.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Conboarding-flow%5Crecovery-phrase%5Cconfirm-srp-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ConfirmSrpModal;
var _react = _interopRequireDefault(require("react"));
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _componentLibrary = require("../../../components/component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function ConfirmSrpModal({
  onContinue,
  onClose,
  isError
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  const handleContinue = () => {
    if (isError) {
      onClose();
    } else {
      onContinue();
    }
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: true,
    onClose: () => null,
    className: "confirm-srp-modal",
    "data-testid": "confirm-srp-modal"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, {
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    textAlign: _designSystem.TextAlign.Center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: isError ? _componentLibrary.IconName.CircleX : _componentLibrary.IconName.Confirmation,
    size: _componentLibrary.IconSize.Xl,
    className: "skip-srp-backup-popover__icon",
    color: isError ? _designSystem.IconColor.errorDefault : _designSystem.IconColor.successDefault
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingMd,
    textAlign: _designSystem.TextAlign.Center,
    marginTop: 2,
    as: "h2"
  }, isError ? t('confirmSrpErrorTitle') : t('confirmSrpSuccessTitle')))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 4,
    paddingRight: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd
  }, isError ? t('confirmSrpErrorDescription') : t('confirmSrpSuccessDescription')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginTop: 6
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    "data-testid": "confirm-srp-modal-button",
    variant: _componentLibrary.ButtonVariant.Primary,
    size: _componentLibrary.ButtonSize.Lg,
    onClick: handleContinue,
    block: true
  }, isError ? t('tryAgain') : t('gotIt'))))));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\onboarding-flow\\recovery-phrase\\confirm-srp-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\recovery-phrase\\recovery-phrase-chips.js", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Conboarding-flow%5Crecovery-phrase%5Crecovery-phrase-chips.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = RecoveryPhraseChips;
exports.fakeSeedPhraseWords = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _componentLibrary = require("../../../components/component-library");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// this was Truffle's original dev recovery phrase from ~2017
const fakeSeedPhraseWords = exports.fakeSeedPhraseWords = ['candy', 'maple', 'cake', 'sugar', 'pudding', 'cream', 'honey', 'rich', 'smooth', 'crumble', 'sweet', 'treat'];
function RecoveryPhraseChips({
  secretRecoveryPhrase,
  phraseRevealed = true,
  revealPhrase,
  confirmPhase,
  quizWords = [],
  setInputValue
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  const indicesToCheck = (0, _react.useMemo)(() => quizWords.map(word => word.index), [quizWords]);
  const [quizAnswers, setQuizAnswers] = (0, _react.useState)(indicesToCheck.map(index => ({
    index,
    // the index in the SRP chips UI where the answer is inserted
    word: '',
    // the answer value
    actualIndexInSrp: -1 // the correct index of the answer value in the secret recovery phrase
  })));
  const setNextTargetIndex = newQuizAnswers => {
    const emptyAnswers = newQuizAnswers.reduce((acc, answer) => {
      if (answer.word === '') {
        acc.push(answer.index);
      }
      return acc;
    }, []);
    const firstEmpty = emptyAnswers.length ? Math.min(...emptyAnswers) : -1;
    return firstEmpty;
  };
  const [indexToFocus, setIndexToFocus] = (0, _react.useState)(setNextTargetIndex(quizAnswers));
  const addQuizWord = (0, _react.useCallback)((word, actualIndexInSrp) => {
    const newQuizAnswers = [...quizAnswers];
    const targetIndex = newQuizAnswers.findIndex(answer => answer.index === indexToFocus);
    newQuizAnswers[targetIndex] = {
      index: indexToFocus,
      word,
      actualIndexInSrp
    };
    setQuizAnswers(newQuizAnswers);
    setIndexToFocus(setNextTargetIndex(newQuizAnswers));
  }, [quizAnswers, indexToFocus]);
  const removeQuizWord = (0, _react.useCallback)(answerWord => {
    const newQuizAnswers = [...quizAnswers];
    const targetIndex = newQuizAnswers.findIndex(answer => answer.word === answerWord);
    newQuizAnswers[targetIndex] = {
      ...newQuizAnswers[targetIndex],
      word: '',
      actualIndexInSrp: -1
    };
    setQuizAnswers(newQuizAnswers);
    setIndexToFocus(newQuizAnswers[targetIndex].index);
  }, [quizAnswers]);
  (0, _react.useEffect)(() => {
    setInputValue === null || setInputValue === void 0 || setInputValue(quizAnswers);
  }, [quizAnswers, setInputValue]);
  (0, _react.useEffect)(() => {
    if (quizWords.length) {
      const newQuizAnswers = quizWords.map(word => ({
        index: word.index,
        word: '',
        actualIndexInSrp: -1
      }));
      setQuizAnswers(newQuizAnswers);
      setIndexToFocus(setNextTargetIndex(newQuizAnswers));
    }
  }, [quizWords]);

  // obfuscate the blurred recovery phrase to prevent blur-reversal attacks
  // from revealing the underlying words.
  const phrasesToDisplay = phraseRevealed ? secretRecoveryPhrase : secretRecoveryPhrase.map((_word, index) => {
    return fakeSeedPhraseWords[index % fakeSeedPhraseWords.length];
  });
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    padding: 4,
    borderRadius: _designSystem.BorderRadius.LG,
    display: _designSystem.Display.Grid,
    width: _designSystem.BlockSize.Full,
    backgroundColor: _designSystem.BackgroundColor.backgroundSection,
    className: "recovery-phrase__secret"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    key: "recovery-phrase-chips",
    display: _designSystem.Display.Grid,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.center,
    gap: 2,
    "data-testid": "recovery-phrase-chips",
    "data-recovery-phrase": secretRecoveryPhrase.join(':'),
    "data-quiz-words": JSON.stringify(quizWords),
    className: (0, _classnames.default)('recovery-phrase__chips', {
      'recovery-phrase__chips--hidden': !phraseRevealed
    })
  }, phrasesToDisplay.map((word, index) => {
    var _quizAnswers$find;
    const isQuizWord = indicesToCheck.includes(index);
    const wordToDisplay = isQuizWord ? ((_quizAnswers$find = quizAnswers.find(answer => answer.index === index)) === null || _quizAnswers$find === void 0 ? void 0 : _quizAnswers$find.word) || '' : word;
    const isTargetIndex = index === indexToFocus;
    return isQuizWord || !confirmPhase ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      as: isQuizWord ? 'button' : 'div',
      "data-testid": `recovery-phrase-chip-${index}`,
      className: "recovery-phrase__text",
      display: _designSystem.Display.Flex,
      alignItems: _designSystem.AlignItems.center,
      backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
      borderColor: isTargetIndex ? _designSystem.BorderColor.primaryDefault : _designSystem.BorderColor.borderDefault,
      borderWidth: isTargetIndex ? 2 : 1,
      borderRadius: _designSystem.BorderRadius.LG,
      paddingInline: 2,
      paddingTop: 1,
      paddingBottom: 1,
      gap: 1,
      onClick: () => {
        if (!isQuizWord) {
          return;
        }
        if (wordToDisplay === '') {
          setIndexToFocus(index);
        } else {
          removeQuizWord(wordToDisplay);
        }
      }
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      color: _designSystem.TextColor.textAlternative,
      className: "recovery-phrase__word-index"
    }, index + 1, "."), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, null, isQuizWord ? wordToDisplay : word)) : /*#__PURE__*/_react.default.createElement(_componentLibrary.TextField, {
      testId: `recovery-phrase-chip-${index}`,
      key: index,
      value: wordToDisplay,
      startAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        color: _designSystem.TextColor.textAlternative,
        className: "recovery-phrase__word-index"
      }, index + 1, "."),
      type: "password",
      disabled: true,
      readOnly: true
    });
  })), !phraseRevealed && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    key: "recovery-phrase__secret-blocker-container",
    width: _designSystem.BlockSize.Full,
    height: _designSystem.BlockSize.Full,
    className: "recovery-phrase__secret-blocker-container"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    borderRadius: _designSystem.BorderRadius.SM,
    width: _designSystem.BlockSize.Full,
    height: _designSystem.BlockSize.Full,
    paddingTop: 2,
    paddingBottom: 9,
    paddingInline: 0,
    className: "recovery-phrase__secret-blocker"
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    as: "button",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    backgroundColor: _designSystem.BackgroundColor.transparent,
    height: _designSystem.BlockSize.Full,
    width: _designSystem.BlockSize.Full,
    gap: 2,
    className: "recovery-phrase__secret-blocker-text",
    onClick: () => {
      revealPhrase === null || revealPhrase === void 0 || revealPhrase();
    },
    "data-testid": "recovery-phrase-reveal"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.EyeSlash,
    color: _designSystem.IconColor.iconDefault,
    size: _componentLibrary.IconSize.Md
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    color: _designSystem.TextColor.textDefault,
    fontWeight: _designSystem.FontWeight.Medium
  }, t('tapToReveal')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textDefault
  }, t('tapToRevealNote'))))), quizWords.length === 3 && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    gap: 2,
    width: _designSystem.BlockSize.Full
  }, quizWords.map(quizWord => {
    const actualIdxInSrp = quizWord.index;
    // check if the quiz word has been added to the quizAnswers array
    // here we are checking the answer's actual index in the secret recovery phrase
    // to handle the case where the quiz words has the same value but different indexes
    // e.g. the quiz words are ["one", "two", "one"]
    const isAnswered = quizAnswers.some(answer => answer.actualIndexInSrp === actualIdxInSrp);
    return isAnswered ? /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonBase, {
      "data-testid": `recovery-phrase-quiz-answered-${actualIdxInSrp}`,
      key: quizWord.index,
      color: _designSystem.TextColor.textAlternative,
      borderRadius: _designSystem.BorderRadius.LG,
      block: true,
      onClick: () => {
        removeQuizWord(quizWord.word);
      }
    }, secretRecoveryPhrase[actualIdxInSrp]) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
      "data-testid": `recovery-phrase-quiz-unanswered-${actualIdxInSrp}`,
      key: quizWord.index,
      variant: _componentLibrary.ButtonVariant.Secondary,
      borderRadius: _designSystem.BorderRadius.LG,
      block: true,
      borderColor: _designSystem.BorderColor.primaryDefault,
      color: _designSystem.TextColor.primaryDefault,
      onClick: () => {
        addQuizWord(quizWord.word, actualIdxInSrp);
      }
    }, secretRecoveryPhrase[actualIdxInSrp]);
  })));
}
RecoveryPhraseChips.propTypes = {
  secretRecoveryPhrase: _propTypes.default.array,
  phraseRevealed: _propTypes.default.bool,
  revealPhrase: _propTypes.default.func,
  confirmPhase: _propTypes.default.bool,
  quizWords: _propTypes.default.array,
  setInputValue: _propTypes.default.func
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\onboarding-flow\\recovery-phrase\\recovery-phrase-chips.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\recovery-phrase\\reveal-recovery-phrase.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Conboarding-flow%5Crecovery-phrase%5Creveal-recovery-phrase.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = RevealRecoveryPhrase;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _actions = require("../../../store/actions");
var _routes = require("../../../helpers/constants/routes");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function RevealRecoveryPhrase({
  setSecretRecoveryPhrase
}) {
  const navigate = (0, _reactRouterDomV5Compat.useNavigate)();
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    search
  } = (0, _reactRouterDomV5Compat.useLocation)();
  const searchParams = new URLSearchParams(search);
  const isFromReminder = searchParams.get('isFromReminder');
  const isFromSettingsSecurity = searchParams.get('isFromSettingsSecurity');
  const queryParams = new URLSearchParams();
  if (isFromReminder) {
    queryParams.set('isFromReminder', isFromReminder);
  }
  if (isFromSettingsSecurity) {
    queryParams.set('isFromSettingsSecurity', isFromSettingsSecurity);
  }
  const nextRouteQueryString = queryParams.toString();
  const [password, setPassword] = (0, _react.useState)('');
  const [isIncorrectPasswordError, setIsIncorrectPasswordError] = (0, _react.useState)(false);
  const onSubmit = (0, _react.useCallback)(async _password => {
    try {
      const seedPhrase = await (0, _actions.getSeedPhrase)(_password);
      setSecretRecoveryPhrase(seedPhrase);
      navigate(`${_routes.ONBOARDING_REVIEW_SRP_ROUTE}${nextRouteQueryString ? `?${nextRouteQueryString}` : ''}`, {
        replace: true
      });
    } catch (error) {
      setIsIncorrectPasswordError(true);
    }
  }, [setSecretRecoveryPhrase, navigate, nextRouteQueryString]);
  const returnToPreviousPage = (0, _react.useCallback)(() => {
    if (isFromSettingsSecurity) {
      navigate(_routes.REVEAL_SRP_LIST_ROUTE, {
        replace: true
      });
    } else {
      navigate(_routes.DEFAULT_ROUTE, {
        replace: true
      });
    }
  }, [navigate, isFromSettingsSecurity]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    alignItems: _designSystem.AlignItems.center,
    height: _designSystem.BlockSize.Full,
    gap: 6,
    className: "reveal-recovery-phrase",
    "data-testid": "reveal-recovery-phrase"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "recovery-phrase__header",
    display: _designSystem.Display.Grid,
    alignItems: _designSystem.AlignItems.center,
    gap: 3,
    marginBottom: 4,
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    iconName: _componentLibrary.IconName.ArrowLeft,
    color: _designSystem.IconColor.iconDefault,
    size: _componentLibrary.ButtonIconSize.Md,
    "data-testid": "reveal-recovery-phrase-back-button",
    onClick: returnToPreviousPage,
    ariaLabel: t('back')
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingSm,
    textAlign: _designSystem.TextAlign.Center
  }, t('revealSecretRecoveryPhrase')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    iconName: _componentLibrary.IconName.Close,
    color: _designSystem.IconColor.iconDefault,
    size: _componentLibrary.ButtonIconSize.Md,
    "data-testid": "reveal-recovery-phrase-close-button",
    onClick: returnToPreviousPage,
    ariaLabel: t('close')
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    width: _designSystem.BlockSize.Full,
    as: "form",
    onSubmit: e => {
      e.preventDefault();
      onSubmit(password);
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.FormTextField, {
    size: _componentLibrary.FormTextFieldSize.Lg,
    id: "account-details-authenticate",
    label: t('enterYourPasswordContinue'),
    onChange: e => {
      setPassword(e.target.value);
      setIsIncorrectPasswordError(false);
    },
    value: password,
    error: isIncorrectPasswordError,
    helpText: isIncorrectPasswordError ? t('unlockPageIncorrectPassword') : null,
    type: _componentLibrary.TextFieldType.Password,
    labelProps: {
      fontWeight: _designSystem.FontWeight.Medium
    },
    autoFocus: true
  }))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    width: _designSystem.BlockSize.Full,
    variant: _componentLibrary.ButtonVariant.Primary,
    size: _componentLibrary.ButtonSize.Lg,
    "data-testid": "reveal-recovery-phrase-continue",
    className: "reveal-recovery-phrase__footer--button",
    onClick: () => onSubmit(password)
  }, t('continue'))));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\onboarding-flow\\recovery-phrase\\reveal-recovery-phrase.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\recovery-phrase\\review-recovery-phrase.js", {"../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/onboarding":"D:\\code\\v\\metamask-extension\\shared\\constants\\onboarding.ts","../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../../shared/modules/browser-runtime.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\browser-runtime.utils.js","../../../components/app/srp-details-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\srp-details-modal\\index.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./recovery-phrase-chips":"D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\recovery-phrase\\recovery-phrase-chips.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Conboarding-flow%5Crecovery-phrase%5Creview-recovery-phrase.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = RecoveryPhrase;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _reactRedux = require("react-redux");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _useI18nContext = require("../../../hooks/useI18nContext");
var _routes = require("../../../helpers/constants/routes");
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _metametrics = require("../../../../shared/constants/metametrics");
var _metametrics2 = require("../../../contexts/metametrics");
var _selectors = require("../../../selectors");
var _srpDetailsModal = _interopRequireDefault(require("../../../components/app/srp-details-modal"));
var _actions = require("../../../store/actions");
var _trace = require("../../../../shared/lib/trace");
var _browserRuntime = require("../../../../shared/modules/browser-runtime.utils");
var _app = require("../../../../shared/constants/app");
var _onboarding = require("../../../../shared/constants/onboarding");
var _recoveryPhraseChips = _interopRequireDefault(require("./recovery-phrase-chips"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function RecoveryPhrase({
  secretRecoveryPhrase
}) {
  const navigate = (0, _reactRouterDomV5Compat.useNavigate)();
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    search
  } = (0, _reactRouterDomV5Compat.useLocation)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const firstTimeFlowType = (0, _reactRedux.useSelector)(_selectors.getFirstTimeFlowType);
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const {
    bufferedEndTrace
  } = trackEvent;
  const hdEntropyIndex = (0, _reactRedux.useSelector)(_selectors.getHDEntropyIndex);
  const [phraseRevealed, setPhraseRevealed] = (0, _react.useState)(false);
  const [showSrpDetailsModal, setShowSrpDetailsModal] = (0, _react.useState)(false);
  const searchParams = new URLSearchParams(search);
  const isFromReminder = searchParams.get('isFromReminder');
  const isFromSettingsSecurity = searchParams.get('isFromSettingsSecurity');
  const queryParams = new URLSearchParams();
  if (isFromReminder) {
    queryParams.set('isFromReminder', isFromReminder);
  }
  if (isFromSettingsSecurity) {
    queryParams.set('isFromSettingsSecurity', isFromSettingsSecurity);
  }
  const nextRouteQueryString = queryParams.toString();
  (0, _react.useEffect)(() => {
    if (!secretRecoveryPhrase) {
      navigate({
        pathname: _routes.ONBOARDING_REVEAL_SRP_ROUTE,
        search: nextRouteQueryString ? `?${nextRouteQueryString}` : ''
      }, {
        replace: true
      });
    }
  }, [navigate, secretRecoveryPhrase, nextRouteQueryString]);
  const handleContinue = (0, _react.useCallback)(() => {
    trackEvent({
      category: _metametrics.MetaMetricsEventCategory.Onboarding,
      event: _metametrics.MetaMetricsEventName.OnboardingWalletSecurityPhraseWrittenDown,
      properties: {
        hd_entropy_index: hdEntropyIndex
      }
    });
    navigate({
      pathname: _routes.ONBOARDING_CONFIRM_SRP_ROUTE,
      search: nextRouteQueryString ? `?${nextRouteQueryString}` : ''
    });
  }, [hdEntropyIndex, navigate, trackEvent, nextRouteQueryString]);
  const handleOnShowSrpDetailsModal = (0, _react.useCallback)(() => {
    trackEvent({
      category: _metametrics.MetaMetricsEventCategory.Onboarding,
      event: _metametrics.MetaMetricsEventName.SrpDefinitionClicked,
      properties: {
        location: 'review_recovery_phrase'
      }
    });
    setShowSrpDetailsModal(true);
  }, [trackEvent]);
  const handleRemindLater = (0, _react.useCallback)(async () => {
    await dispatch((0, _actions.setSeedPhraseBackedUp)(false));
    trackEvent({
      category: _metametrics.MetaMetricsEventCategory.Onboarding,
      event: _metametrics.MetaMetricsEventName.OnboardingWalletSecuritySkipConfirmed,
      properties: {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        hd_entropy_index: hdEntropyIndex
      }
    });
    bufferedEndTrace === null || bufferedEndTrace === void 0 || bufferedEndTrace({
      name: _trace.TraceName.OnboardingNewSrpCreateWallet
    });
    bufferedEndTrace === null || bufferedEndTrace === void 0 || bufferedEndTrace({
      name: _trace.TraceName.OnboardingJourneyOverall
    });
    if ((0, _browserRuntime.getBrowserName)() === _app.PLATFORM_FIREFOX || firstTimeFlowType === _onboarding.FirstTimeFlowType.restore) {
      navigate(_routes.ONBOARDING_COMPLETION_ROUTE, {
        replace: true
      });
    } else {
      navigate(_routes.ONBOARDING_METAMETRICS, {
        replace: true
      });
    }
  }, [bufferedEndTrace, dispatch, firstTimeFlowType, hdEntropyIndex, navigate, trackEvent]);
  const handleBack = (0, _react.useCallback)(() => {
    navigate(`${_routes.ONBOARDING_REVEAL_SRP_ROUTE}${nextRouteQueryString ? `?${nextRouteQueryString}` : ''}`, {
      replace: true
    });
  }, [navigate, nextRouteQueryString]);
  const onClose = (0, _react.useCallback)(() => {
    navigate(_routes.REVEAL_SRP_LIST_ROUTE, {
      replace: true
    });
  }, [navigate]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    alignItems: _designSystem.AlignItems.Center,
    height: _designSystem.BlockSize.Full,
    gap: 6,
    className: "recovery-phrase",
    "data-testid": "recovery-phrase"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, showSrpDetailsModal && /*#__PURE__*/_react.default.createElement(_srpDetailsModal.default, {
    onClose: () => setShowSrpDetailsModal(false)
  }), isFromReminder && isFromSettingsSecurity ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "recovery-phrase__header",
    display: _designSystem.Display.Grid,
    alignItems: _designSystem.AlignItems.center,
    gap: 3,
    marginBottom: 4,
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    iconName: _componentLibrary.IconName.ArrowLeft,
    color: _designSystem.IconColor.iconDefault,
    size: _componentLibrary.ButtonIconSize.Md,
    "data-testid": "reveal-recovery-phrase-review-back-button",
    onClick: handleBack,
    ariaLabel: t('back')
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingSm,
    textAlign: _designSystem.TextAlign.Center
  }, t('seedPhraseReviewTitleSettings')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    iconName: _componentLibrary.IconName.Close,
    color: _designSystem.IconColor.iconDefault,
    size: _componentLibrary.ButtonIconSize.Md,
    "data-testid": "reveal-recovery-phrase-review-close-button",
    onClick: onClose,
    ariaLabel: t('close')
  })) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    justifyContent: _designSystem.JustifyContent.flexStart,
    marginBottom: 4,
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingLg,
    as: "h2"
  }, t('seedPhraseReviewTitle'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginBottom: 6
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    color: _designSystem.TextColor.textAlternative,
    marginBottom: 6
  }, t('seedPhraseReviewDetails', [/*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    key: "seedPhraseReviewDetails",
    size: _componentLibrary.ButtonLinkSize.Inherit,
    onClick: handleOnShowSrpDetailsModal
  }, t('secretRecoveryPhrase')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    key: "seedPhraseReviewDetails2",
    fontWeight: _designSystem.FontWeight.Medium,
    color: _designSystem.TextColor.textAlternative
  }, t('seedPhraseReviewDetails2'))]))), /*#__PURE__*/_react.default.createElement(_recoveryPhraseChips.default, {
    secretRecoveryPhrase: secretRecoveryPhrase.split(' '),
    phraseRevealed: phraseRevealed,
    revealPhrase: () => {
      trackEvent({
        category: _metametrics.MetaMetricsEventCategory.Onboarding,
        event: _metametrics.MetaMetricsEventName.OnboardingWalletSecurityPhraseRevealed,
        properties: {
          hd_entropy_index: hdEntropyIndex
        }
      });
      setPhraseRevealed(true);
    }
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    width: _designSystem.BlockSize.Full,
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    width: _designSystem.BlockSize.Full,
    variant: _componentLibrary.ButtonVariant.Primary,
    size: _componentLibrary.ButtonSize.Lg,
    "data-testid": "recovery-phrase-continue",
    className: "recovery-phrase__footer--button",
    disabled: !phraseRevealed,
    onClick: handleContinue
  }, t('continue')), !isFromReminder && /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    width: _designSystem.BlockSize.Full,
    variant: _componentLibrary.ButtonVariant.Link,
    size: _componentLibrary.ButtonSize.Lg,
    onClick: handleRemindLater,
    type: "button",
    "data-testid": "recovery-phrase-remind-later"
  }, t('secureWalletRemindLaterButton'))));
}
RecoveryPhrase.propTypes = {
  secretRecoveryPhrase: _propTypes.default.string
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\onboarding-flow\\recovery-phrase\\review-recovery-phrase.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\welcome\\login-error-modal.tsx", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/common":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\common.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","./types":"D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\welcome\\types.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Conboarding-flow%5Cwelcome%5Clogin-error-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = LoginErrorModal;
var _react = _interopRequireWildcard(require("react"));
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _componentLibrary = require("../../../components/component-library");
var _metametrics = require("../../../../shared/constants/metametrics");
var _common = require("../../../helpers/constants/common");
var _metametrics2 = require("../../../contexts/metametrics");
var _types = require("./types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function LoginErrorModal({
  onClose,
  loginError
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const getTitle = () => {
    if (loginError === _types.LOGIN_ERROR.UNABLE_TO_CONNECT) {
      return t('loginErrorConnectTitle');
    }
    if (loginError === _types.LOGIN_ERROR.SESSION_EXPIRED) {
      return t('loginErrorSessionExpiredTitle');
    }
    return t('loginErrorGenericTitle');
  };
  const getDescription = () => {
    if (loginError === _types.LOGIN_ERROR.UNABLE_TO_CONNECT) {
      return t('loginErrorConnectDescription');
    }
    if (loginError === _types.LOGIN_ERROR.SESSION_EXPIRED) {
      return t('loginErrorSessionExpiredDescription');
    }
    return t('loginErrorGenericDescription', [/*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
      key: "loginErrorGenericDescription",
      size: _componentLibrary.ButtonLinkSize.Inherit,
      externalLink: true,
      href: _common.SUPPORT_LINK,
      onClick: () => {
        trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Onboarding,
          event: _metametrics.MetaMetricsEventName.SupportLinkClicked,
          properties: {
            url: _common.SUPPORT_LINK,
            location: 'Welcome page'
          }
        }, {
          contextPropsIntoEventProperties: [_metametrics.MetaMetricsContextProp.PageTitle]
        });
      }
    }, t('loginErrorGenericSupport'))]);
  };
  const getButtonText = () => {
    if (loginError === _types.LOGIN_ERROR.UNABLE_TO_CONNECT) {
      return t('loginErrorConnectButton');
    }
    if (loginError === _types.LOGIN_ERROR.SESSION_EXPIRED) {
      return t('loginErrorSessionExpiredButton');
    }
    return t('loginErrorGenericButton');
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: true,
    onClose: onClose,
    "data-testid": "login-error-modal"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, {
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onClose: onClose
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    textAlign: _designSystem.TextAlign.Center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.Danger,
    size: _componentLibrary.IconSize.Xl,
    color: _designSystem.IconColor.warningDefault
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingMd,
    textAlign: _designSystem.TextAlign.Center,
    marginTop: 4
  }, getTitle()))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 4,
    paddingRight: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd
  }, getDescription()), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginTop: 6
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    "data-testid": "login-error-modal-button",
    variant: _componentLibrary.ButtonVariant.Primary,
    size: _componentLibrary.ButtonSize.Lg,
    onClick: onClose,
    block: true
  }, getButtonText())))));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\onboarding-flow\\welcome\\login-error-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\welcome\\login-options.tsx", {"../../../../shared/constants/preferences":"D:\\code\\v\\metamask-extension\\shared\\constants\\preferences.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","./types":"D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\welcome\\types.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Conboarding-flow%5Cwelcome%5Clogin-options.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SocialButton = void 0;
exports.default = LoginOptions;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _preferences = require("../../../../shared/constants/preferences");
var _types = require("./types");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const SocialButton = exports.SocialButton = /*#__PURE__*/_react.default.forwardRef(({
  icon,
  label,
  ...props
}, ref) => {
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, _extends({
    ref: ref,
    className: "options-modal__plain-button",
    variant: _componentLibrary.ButtonVariant.Primary,
    size: _componentLibrary.ButtonSize.Lg,
    block: true,
    "data-theme": _preferences.ThemeType.dark
  }, props), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    width: _designSystem.BlockSize.Full,
    gap: 2
  }, icon, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, label)));
});

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function LoginOptions({
  onClose,
  loginOption,
  handleLogin
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: true,
    onClose: onClose,
    className: "options-modal",
    isClosedOnOutsideClick: false,
    "data-theme": _preferences.ThemeType.dark
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, {
    size: _componentLibrary.ModalContentSize.Sm,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onClose: onClose
  }, t('onboardingOptionTitle')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingInline: 4
  }, /*#__PURE__*/_react.default.createElement(SocialButton, {
    "data-testid": loginOption === _types.LOGIN_OPTION.EXISTING ? 'onboarding-import-with-google-button' : 'onboarding-create-with-google-button',
    icon: /*#__PURE__*/_react.default.createElement("img", {
      src: "images/icons/google.svg",
      className: "options-modal__social-icon",
      alt: t('onboardingOptionIcon', ['Google'])
    }),
    label: loginOption === _types.LOGIN_OPTION.EXISTING ? t('onboardingSignInWith', ['Google']) : t('onboardingContinueWith', ['Google']),
    marginBottom: 4,
    onClick: () => handleLogin(_types.LOGIN_TYPE.GOOGLE)
  }), /*#__PURE__*/_react.default.createElement(SocialButton, {
    "data-testid": loginOption === _types.LOGIN_OPTION.EXISTING ? 'onboarding-import-with-apple-button' : 'onboarding-create-with-apple-button',
    icon: /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
      name: _componentLibrary.IconName.Apple,
      color: _designSystem.IconColor.infoInverse,
      size: _componentLibrary.IconSize.Lg
    }),
    label: loginOption === _types.LOGIN_OPTION.EXISTING ? t('onboardingSignInWith', ['Apple']) : t('onboardingContinueWith', ['Apple']),
    marginBottom: 2,
    onClick: () => handleLogin(_types.LOGIN_TYPE.APPLE)
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    alignItems: _designSystem.AlignItems.center,
    marginBottom: 4,
    className: "options-modal__or"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    width: _designSystem.BlockSize.Min,
    variant: _designSystem.TextVariant.bodyMd,
    fontWeight: _designSystem.FontWeight.Medium,
    color: _designSystem.TextColor.textMuted,
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    paddingInline: 2,
    marginInline: "auto",
    textTransform: _designSystem.TextTransform.Lowercase,
    as: "div",
    style: {
      position: 'relative',
      zIndex: 1
    }
  }, t('or'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    "data-testid": loginOption === _types.LOGIN_OPTION.EXISTING ? 'onboarding-import-with-srp-button' : 'onboarding-create-with-srp-button',
    variant: _componentLibrary.ButtonVariant.Secondary,
    width: _designSystem.BlockSize.Full,
    size: _componentLibrary.ButtonSize.Lg,
    onClick: () => handleLogin(_types.LOGIN_TYPE.SRP)
  }, loginOption === _types.LOGIN_OPTION.EXISTING ? t('onboardingSrpImport') : t('onboardingSrpCreate')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    fontWeight: _designSystem.FontWeight.Medium,
    textAlign: _designSystem.TextAlign.Center,
    paddingTop: 8,
    width: _designSystem.BlockSize.Full,
    margin: 'auto'
  }, t('onboardingLoginFooter', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "a",
    href: "https://consensys.io/terms-of-use",
    target: "_blank",
    rel: "noopener noreferrer",
    variant: _designSystem.TextVariant.bodySm,
    fontWeight: _designSystem.FontWeight.Medium,
    color: _designSystem.TextColor.primaryDefault,
    key: "onboardingLoginFooterTermsOfUse"
  }, t('onboardingLoginFooterTermsOfUse')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "a",
    variant: _designSystem.TextVariant.bodySm,
    fontWeight: _designSystem.FontWeight.Medium,
    href: "https://consensys.io/privacy-notice",
    target: "_blank",
    rel: "noopener noreferrer",
    color: _designSystem.TextColor.primaryDefault,
    key: "onboardingLoginFooterPrivacyNotice"
  }, t('onboardingLoginFooterPrivacyNotice'))])))));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\onboarding-flow\\welcome\\login-options.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\welcome\\types.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Conboarding-flow%5Cwelcome%5Ctypes.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LOGIN_TYPE = exports.LOGIN_OPTION = exports.LOGIN_ERROR = void 0;
const LOGIN_TYPE = exports.LOGIN_TYPE = {
  GOOGLE: 'google',
  APPLE: 'apple',
  SRP: 'srp'
};
const LOGIN_OPTION = exports.LOGIN_OPTION = {
  NEW: 'new',
  EXISTING: 'existing'
};
const LOGIN_ERROR = exports.LOGIN_ERROR = {
  UNABLE_TO_CONNECT: 'unable_to_connect',
  GENERIC: 'generic',
  SESSION_EXPIRED: 'session_expired'
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\onboarding-flow\\welcome\\types.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\welcome\\welcome-login.tsx", {"../../../../shared/constants/preferences":"D:\\code\\v\\metamask-extension\\shared\\constants\\preferences.ts","../../../../shared/modules/environment":"D:\\code\\v\\metamask-extension\\shared\\modules\\environment.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/ui/mascot":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\mascot\\index.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/build-types":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\build-types.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./login-options":"D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\welcome\\login-options.tsx","./types":"D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\welcome\\types.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","events":"D:\\code\\v\\metamask-extension\\node_modules\\events\\events.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Conboarding-flow%5Cwelcome%5Cwelcome-login.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = WelcomeLogin;
var _events = _interopRequireDefault(require("events"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _reactRedux = require("react-redux");
var _mascot = _interopRequireDefault(require("../../../components/ui/mascot"));
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _buildTypes = require("../../../helpers/utils/build-types");
var _environment = require("../../../../shared/modules/environment");
var _preferences = require("../../../../shared/constants/preferences");
var _actions = require("../../../store/actions");
var _loginOptions = _interopRequireDefault(require("./login-options"));
var _types = require("./types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function WelcomeLogin({
  onLogin
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  const animationEventEmitter = (0, _react.useRef)(new _events.default());
  const [showLoginOptions, setShowLoginOptions] = (0, _react.useState)(false);
  const [loginOption, setLoginOption] = (0, _react.useState)(null);
  const isSeedlessOnboardingFeatureEnabled = (0, _environment.getIsSeedlessOnboardingFeatureEnabled)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const renderMascot = () => {
    if ((0, _buildTypes.isFlask)()) {
      return /*#__PURE__*/_react.default.createElement("img", {
        src: "./images/logo/metamask-fox.svg",
        width: "178",
        height: "178"
      });
    }
    if ((0, _buildTypes.isBeta)()) {
      return /*#__PURE__*/_react.default.createElement("img", {
        src: "./images/logo/metamask-fox.svg",
        width: "178",
        height: "178"
      });
    }
    return /*#__PURE__*/_react.default.createElement(_mascot.default, {
      animationEventEmitter: animationEventEmitter.current,
      width: "268",
      height: "268"
    });
  };
  const handleLogin = (0, _react.useCallback)(async loginType => {
    if (!loginOption) {
      return;
    }
    setShowLoginOptions(false);
    await dispatch((0, _actions.setTermsOfUseLastAgreed)(new Date().getTime()));
    await onLogin(loginType, loginOption);
  }, [dispatch, loginOption, onLogin]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    gap: 4,
    marginInline: "auto",
    marginTop: 2,
    padding: 6,
    className: "welcome-login",
    "data-testid": "get-started"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    className: "welcome-login__content"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: (0, _classnames.default)('welcome-login__mascot', {
      'welcome-login__mascot--image': (0, _buildTypes.isFlask)() || (0, _buildTypes.isBeta)()
    })
  }, renderMascot()), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    marginInline: 5,
    textAlign: _designSystem.TextAlign.Center,
    as: "h2",
    className: "welcome-login__title",
    "data-testid": "onboarding-welcome"
  }, t('welcomeToMetaMask'), "!")), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    "data-theme": _preferences.ThemeType.light,
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    "data-testid": "onboarding-create-wallet",
    variant: _componentLibrary.ButtonVariant.Primary,
    size: _componentLibrary.ButtonSize.Lg,
    block: true,
    onClick: async () => {
      setShowLoginOptions(true);
      setLoginOption(_types.LOGIN_OPTION.NEW);
      if (!isSeedlessOnboardingFeatureEnabled) {
        await onLogin(_types.LOGIN_TYPE.SRP, _types.LOGIN_OPTION.NEW);
      }
    }
  }, t('onboardingCreateWallet')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    "data-testid": "onboarding-import-wallet",
    variant: _componentLibrary.ButtonVariant.Secondary,
    size: _componentLibrary.ButtonSize.Lg,
    block: true,
    onClick: async () => {
      setShowLoginOptions(true);
      setLoginOption(_types.LOGIN_OPTION.EXISTING);
      if (!isSeedlessOnboardingFeatureEnabled) {
        await onLogin(_types.LOGIN_TYPE.SRP, _types.LOGIN_OPTION.EXISTING);
      }
    }
  }, isSeedlessOnboardingFeatureEnabled ? t('onboardingImportWallet') : t('onboardingSrpImport'))), isSeedlessOnboardingFeatureEnabled && showLoginOptions && loginOption && /*#__PURE__*/_react.default.createElement(_loginOptions.default, {
    loginOption: loginOption,
    onClose: () => {
      setLoginOption(null);
    },
    handleLogin: handleLogin
  }));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\onboarding-flow\\welcome\\welcome-login.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\welcome\\welcome.js", {"../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/onboarding":"D:\\code\\v\\metamask-extension\\shared\\constants\\onboarding.ts","../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../../shared/modules/browser-runtime.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\browser-runtime.utils.js","../../../../shared/modules/environment":"D:\\code\\v\\metamask-extension\\shared\\modules\\environment.ts","../../../../shared/modules/error":"D:\\code\\v\\metamask-extension\\shared\\modules\\error.ts","../../../components/ui/loading-screen":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\loading-screen\\index.js","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./login-error-modal":"D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\welcome\\login-error-modal.tsx","./types":"D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\welcome\\types.ts","./welcome-login":"D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\welcome\\welcome-login.tsx","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Conboarding-flow%5Cwelcome%5Cwelcome.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = OnboardingWelcome;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _loglevel = _interopRequireDefault(require("loglevel"));
var _routes = require("../../../helpers/constants/routes");
var _selectors = require("../../../selectors");
var _onboarding = require("../../../../shared/constants/onboarding");
var _metametrics = require("../../../contexts/metametrics");
var _actions = require("../../../store/actions");
var _loadingScreen = _interopRequireDefault(require("../../../components/ui/loading-screen"));
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _environment = require("../../../../shared/modules/environment");
var _browserRuntime = require("../../../../shared/modules/browser-runtime.utils");
var _app = require("../../../../shared/constants/app");
var _error = require("../../../../shared/modules/error");
var _trace = require("../../../../shared/lib/trace");
var _welcomeLogin = _interopRequireDefault(require("./welcome-login"));
var _types = require("./types");
var _loginErrorModal = _interopRequireDefault(require("./login-error-modal"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function OnboardingWelcome() {
  const dispatch = (0, _reactRedux.useDispatch)();
  const navigate = (0, _reactRouterDomV5Compat.useNavigate)();
  const currentKeyring = (0, _reactRedux.useSelector)(_selectors.getCurrentKeyring);
  const isSeedlessOnboardingFeatureEnabled = (0, _environment.getIsSeedlessOnboardingFeatureEnabled)();
  const firstTimeFlowType = (0, _reactRedux.useSelector)(_selectors.getFirstTimeFlowType);
  const isUserAuthenticatedWithSocialLogin = (0, _reactRedux.useSelector)(_selectors.getIsSocialLoginUserAuthenticated);
  const isParticipateInMetaMetricsSet = (0, _reactRedux.useSelector)(_selectors.getIsParticipateInMetaMetricsSet);
  const [newAccountCreationInProgress, setNewAccountCreationInProgress] = (0, _react.useState)(false);
  const [isLoggingIn, setIsLoggingIn] = (0, _react.useState)(false);
  const [loginError, setLoginError] = (0, _react.useState)(null);
  const isFireFox = (0, _browserRuntime.getBrowserName)() === _app.PLATFORM_FIREFOX;
  // Don't allow users to come back to this screen after they
  // have already imported or created a wallet
  (0, _react.useEffect)(() => {
    if (currentKeyring && !newAccountCreationInProgress) {
      if (firstTimeFlowType === _onboarding.FirstTimeFlowType.import || firstTimeFlowType === _onboarding.FirstTimeFlowType.restore) {
        navigate(isParticipateInMetaMetricsSet ? _routes.ONBOARDING_COMPLETION_ROUTE : _routes.ONBOARDING_METAMETRICS, {
          replace: true
        });
      } else if (firstTimeFlowType === _onboarding.FirstTimeFlowType.socialCreate) {
        navigate(_routes.ONBOARDING_COMPLETION_ROUTE, {
          replace: true
        });
      } else {
        navigate(_routes.ONBOARDING_REVIEW_SRP_ROUTE, {
          replace: true
        });
      }
    } else if (isUserAuthenticatedWithSocialLogin) {
      if (firstTimeFlowType === _onboarding.FirstTimeFlowType.socialCreate) {
        navigate(_routes.ONBOARDING_CREATE_PASSWORD_ROUTE, {
          replace: true
        });
      } else {
        navigate(_routes.ONBOARDING_UNLOCK_ROUTE, {
          replace: true
        });
      }
    }
  }, [currentKeyring, navigate, firstTimeFlowType, newAccountCreationInProgress, isParticipateInMetaMetricsSet, isUserAuthenticatedWithSocialLogin, isFireFox]);
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const {
    bufferedTrace,
    bufferedEndTrace,
    onboardingParentContext
  } = trackEvent;
  const onCreateClick = (0, _react.useCallback)(async () => {
    setIsLoggingIn(true);
    setNewAccountCreationInProgress(true);
    await dispatch((0, _actions.setFirstTimeFlowType)(_onboarding.FirstTimeFlowType.create));
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.Onboarding,
      event: _metametrics2.MetaMetricsEventName.WalletSetupStarted,
      properties: {
        account_type: _metametrics2.MetaMetricsEventAccountType.Default
      }
    });
    bufferedTrace === null || bufferedTrace === void 0 || bufferedTrace({
      name: _trace.TraceName.OnboardingNewSrpCreateWallet,
      op: _trace.TraceOperation.OnboardingUserJourney,
      parentContext: onboardingParentContext === null || onboardingParentContext === void 0 ? void 0 : onboardingParentContext.current
    });
    navigate(_routes.ONBOARDING_CREATE_PASSWORD_ROUTE);
  }, [dispatch, navigate, trackEvent, onboardingParentContext, bufferedTrace]);
  const onImportClick = (0, _react.useCallback)(async () => {
    setIsLoggingIn(true);
    await dispatch((0, _actions.setFirstTimeFlowType)(_onboarding.FirstTimeFlowType.import));
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.Onboarding,
      event: _metametrics2.MetaMetricsEventName.WalletImportStarted,
      properties: {
        account_type: _metametrics2.MetaMetricsEventAccountType.Imported
      }
    });
    bufferedTrace === null || bufferedTrace === void 0 || bufferedTrace({
      name: _trace.TraceName.OnboardingExistingSrpImport,
      op: _trace.TraceOperation.OnboardingUserJourney,
      parentContext: onboardingParentContext === null || onboardingParentContext === void 0 ? void 0 : onboardingParentContext.current
    });
    navigate(_routes.ONBOARDING_IMPORT_WITH_SRP_ROUTE);
  }, [dispatch, navigate, trackEvent, onboardingParentContext, bufferedTrace]);
  const handleSocialLogin = (0, _react.useCallback)(async socialConnectionType => {
    if (isSeedlessOnboardingFeatureEnabled) {
      bufferedTrace === null || bufferedTrace === void 0 || bufferedTrace({
        name: _trace.TraceName.OnboardingSocialLoginAttempt,
        op: _trace.TraceOperation.OnboardingUserJourney,
        tags: {
          provider: socialConnectionType
        },
        parentContext: onboardingParentContext === null || onboardingParentContext === void 0 ? void 0 : onboardingParentContext.current
      });
      const isNewUser = await dispatch((0, _actions.startOAuthLogin)(socialConnectionType, bufferedTrace, bufferedEndTrace));
      bufferedEndTrace === null || bufferedEndTrace === void 0 || bufferedEndTrace({
        name: _trace.TraceName.OnboardingSocialLoginAttempt
      });
      return isNewUser;
    }
    return true;
  }, [dispatch, isSeedlessOnboardingFeatureEnabled, onboardingParentContext, bufferedTrace, bufferedEndTrace]);
  const handleSocialLoginError = (0, _react.useCallback)((error, socialConnectionType) => {
    const errorMessage = error instanceof Error ? error.message : 'Unknown error';

    // Map raw OAuth error messages to UI modal-friendly constants
    if (errorMessage === _error.OAuthErrorMessages.USER_CANCELLED_LOGIN_ERROR) {
      setLoginError(null);
      return;
    }
    bufferedTrace === null || bufferedTrace === void 0 || bufferedTrace({
      name: _trace.TraceName.OnboardingSocialLoginError,
      op: _trace.TraceOperation.OnboardingError,
      tags: {
        provider: socialConnectionType,
        errorMessage
      },
      parentContext: onboardingParentContext.current
    });
    bufferedEndTrace === null || bufferedEndTrace === void 0 || bufferedEndTrace({
      name: _trace.TraceName.OnboardingSocialLoginError
    });
    bufferedEndTrace === null || bufferedEndTrace === void 0 || bufferedEndTrace({
      name: _trace.TraceName.OnboardingSocialLoginAttempt,
      data: {
        success: false
      }
    });
    if (errorMessage === _error.OAuthErrorMessages.INVALID_OAUTH_STATE_ERROR) {
      setLoginError(_types.LOGIN_ERROR.SESSION_EXPIRED);
      return;
    }
    if (errorMessage === _error.OAuthErrorMessages.NO_REDIRECT_URL_FOUND_ERROR || errorMessage === _error.OAuthErrorMessages.NO_AUTH_CODE_FOUND_ERROR) {
      setLoginError(_types.LOGIN_ERROR.UNABLE_TO_CONNECT);
      return;
    }
    setLoginError(_types.LOGIN_ERROR.GENERIC);
  }, [onboardingParentContext, bufferedTrace, bufferedEndTrace]);
  const onSocialLoginCreateClick = (0, _react.useCallback)(async socialConnectionType => {
    setIsLoggingIn(true);
    setNewAccountCreationInProgress(true);
    await dispatch((0, _actions.setFirstTimeFlowType)(_onboarding.FirstTimeFlowType.socialCreate));
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.Onboarding,
      event: _metametrics2.MetaMetricsEventName.WalletSetupStarted,
      properties: {
        account_type: `${_metametrics2.MetaMetricsEventAccountType.Default}_${socialConnectionType}`
      }
    });
    try {
      const isNewUser = await handleSocialLogin(socialConnectionType);

      // Track wallet setup completed for social login users
      trackEvent({
        category: _metametrics2.MetaMetricsEventCategory.Onboarding,
        event: _metametrics2.MetaMetricsEventName.SocialLoginCompleted,
        properties: {
          account_type: `${_metametrics2.MetaMetricsEventAccountType.Default}_${socialConnectionType}`
        }
      });
      if (isNewUser) {
        bufferedTrace === null || bufferedTrace === void 0 || bufferedTrace({
          name: _trace.TraceName.OnboardingNewSocialCreateWallet,
          op: _trace.TraceOperation.OnboardingUserJourney,
          parentContext: onboardingParentContext.current
        });
        navigate(_routes.ONBOARDING_CREATE_PASSWORD_ROUTE, {
          replace: true
        });
      } else {
        navigate(_routes.ONBOARDING_ACCOUNT_EXIST, {
          replace: true
        });
      }
    } catch (error) {
      handleSocialLoginError(error, socialConnectionType);
    } finally {
      setIsLoggingIn(false);
    }
  }, [dispatch, handleSocialLogin, trackEvent, navigate, onboardingParentContext, handleSocialLoginError, bufferedTrace]);
  const onSocialLoginImportClick = (0, _react.useCallback)(async socialConnectionType => {
    setIsLoggingIn(true);
    dispatch((0, _actions.setFirstTimeFlowType)(_onboarding.FirstTimeFlowType.socialImport));
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.Onboarding,
      event: _metametrics2.MetaMetricsEventName.WalletImportStarted,
      properties: {
        account_type: `${_metametrics2.MetaMetricsEventAccountType.Imported}_${socialConnectionType}`
      }
    });
    try {
      const isNewUser = await handleSocialLogin(socialConnectionType);

      // Track wallet login completed for existing social login users
      trackEvent({
        category: _metametrics2.MetaMetricsEventCategory.Onboarding,
        event: _metametrics2.MetaMetricsEventName.SocialLoginCompleted,
        properties: {
          account_type: `${_metametrics2.MetaMetricsEventAccountType.Imported}_${socialConnectionType}`
        }
      });
      if (isNewUser) {
        navigate(_routes.ONBOARDING_ACCOUNT_NOT_FOUND);
      } else {
        bufferedTrace === null || bufferedTrace === void 0 || bufferedTrace({
          name: _trace.TraceName.OnboardingExistingSocialLogin,
          op: _trace.TraceOperation.OnboardingUserJourney,
          parentContext: onboardingParentContext.current
        });
        navigate(_routes.ONBOARDING_UNLOCK_ROUTE);
      }
    } catch (error) {
      handleSocialLoginError(error, socialConnectionType);
    } finally {
      setIsLoggingIn(false);
    }
  }, [dispatch, handleSocialLogin, trackEvent, navigate, onboardingParentContext, handleSocialLoginError, bufferedTrace]);
  const handleLoginError = (0, _react.useCallback)(error => {
    _loglevel.default.error('handleLoginError::error', error);
    const errorMessage = error.message;
    if (errorMessage === _error.OAuthErrorMessages.USER_CANCELLED_LOGIN_ERROR) {
      setLoginError(null);
    } else {
      setLoginError(_types.LOGIN_ERROR.GENERIC);
    }
  }, []);
  const handleLogin = (0, _react.useCallback)(async (loginType, loginOption) => {
    try {
      if (!isFireFox) {
        // reset the participate in meta metrics in case it was set to true from previous login attempts
        // to prevent the queued events from being sent
        dispatch((0, _actions.setParticipateInMetaMetrics)(null));
      }
      if (loginType === _types.LOGIN_TYPE.SRP) {
        if (loginOption === _types.LOGIN_OPTION.NEW) {
          await onCreateClick();
        } else if (loginOption === _types.LOGIN_OPTION.EXISTING) {
          await onImportClick();
        }
        // return here to prevent the social login flow from being enabled
        return;
      }
      if (!isSeedlessOnboardingFeatureEnabled) {
        return;
      }
      if (loginOption === _types.LOGIN_OPTION.NEW) {
        await onSocialLoginCreateClick(loginType);
      } else if (loginOption === _types.LOGIN_OPTION.EXISTING) {
        await onSocialLoginImportClick(loginType);
      }
      if (!isFireFox) {
        // automatically set participate in meta metrics to true for social login users in chrome
        dispatch((0, _actions.setParticipateInMetaMetrics)(true));
      }
    } catch (error) {
      handleLoginError(error);
    }
  }, [isSeedlessOnboardingFeatureEnabled, dispatch, onCreateClick, onImportClick, onSocialLoginCreateClick, isFireFox, onSocialLoginImportClick, handleLoginError]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_welcomeLogin.default, {
    onLogin: handleLogin
  }), isLoggingIn && /*#__PURE__*/_react.default.createElement(_loadingScreen.default, null), loginError !== null && /*#__PURE__*/_react.default.createElement(_loginErrorModal.default, {
    onClose: () => setLoginError(null),
    loginError: loginError
  }));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\onboarding-flow\\welcome\\welcome.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\choose-account\\choose-account.js", {"../../../components/app/permissions-connect-footer":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\permissions-connect-footer\\index.js","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/ui/account-list":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\account-list\\index.js","../../../components/ui/page-container":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\page-container\\index.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cpermissions-connect%5Cchoose-account%5Cchoose-account.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _permissionController = require("@metamask/permission-controller");
var _keyringApi = require("@metamask/keyring-api");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _permissionsConnectFooter = _interopRequireDefault(require("../../../components/app/permissions-connect-footer"));
var _accountList = _interopRequireDefault(require("../../../components/ui/account-list"));
var _pageContainer = require("../../../components/ui/page-container");
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../../components/component-library");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const ChooseAccount = ({
  selectedAccountAddresses,
  addressLastConnectedMap = {},
  accounts,
  selectAccounts,
  selectNewAccountViaModal,
  cancelPermissionsRequest,
  permissionsRequestId,
  targetSubjectMetadata,
  nativeCurrency
}) => {
  const [selectedAccounts, setSelectedAccounts] = (0, _react.useState)(selectedAccountAddresses);
  const evmAccounts = accounts.filter(account => (0, _keyringApi.isEvmAccountType)(account.type));
  const t = (0, _useI18nContext.useI18nContext)();
  const handleAccountClick = address => {
    const newSelectedAccounts = new Set(selectedAccounts);
    if (newSelectedAccounts.has(address)) {
      newSelectedAccounts.delete(address);
    } else {
      newSelectedAccounts.add(address);
    }
    setSelectedAccounts(newSelectedAccounts);
  };
  const selectAll = () => {
    const newSelectedAccounts = new Set(evmAccounts.map(account => account.address));
    setSelectedAccounts(newSelectedAccounts);
  };
  const deselectAll = () => {
    setSelectedAccounts(new Set());
  };
  const allAreSelected = () => {
    return evmAccounts.length === selectedAccounts.size;
  };

  // If lengths are different, this means `accounts` holds some non-EVM accounts
  const hasNonEvmAccounts = Object.keys(selectedAccountAddresses).length > evmAccounts.length;
  const getHeaderText = () => {
    if (accounts.length === 0) {
      return t('connectAccountOrCreate');
    }
    if ((targetSubjectMetadata === null || targetSubjectMetadata === void 0 ? void 0 : targetSubjectMetadata.subjectType) === _permissionController.SubjectType.Snap) {
      return t('selectAccountsForSnap');
    }
    return t('selectAccounts');
  };
  const headerText = getHeaderText();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "permissions-connect-choose-account__content",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    backgroundColor: _designSystem.BackgroundColor.backgroundAlternative,
    width: _designSystem.BlockSize.Full,
    height: _designSystem.BlockSize.Full,
    paddingLeft: 6,
    paddingRight: 6
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.center,
    paddingTop: 4,
    paddingBottom: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingMd
  }, t('connectWithMetaMask')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd
  }, headerText)), /*#__PURE__*/_react.default.createElement(_accountList.default, {
    accounts: accounts,
    selectNewAccountViaModal: selectNewAccountViaModal,
    addressLastConnectedMap: addressLastConnectedMap,
    nativeCurrency: nativeCurrency,
    selectedAccounts: selectedAccounts,
    allAreSelected: allAreSelected,
    deselectAll: deselectAll,
    selectAll: selectAll,
    handleAccountClick: handleAccountClick
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    backgroundColor: _designSystem.BackgroundColor.backgroundAlternative,
    className: "permissions-connect-choose-account__footer",
    paddingTop: 4
  }, (targetSubjectMetadata === null || targetSubjectMetadata === void 0 ? void 0 : targetSubjectMetadata.subjectType) !== _permissionController.SubjectType.Snap && /*#__PURE__*/_react.default.createElement(_permissionsConnectFooter.default, null), /*#__PURE__*/_react.default.createElement(_pageContainer.PageContainerFooter, {
    cancelButtonType: "default",
    onCancel: () => cancelPermissionsRequest(permissionsRequestId),
    cancelText: t('cancel'),
    onSubmit: () => selectAccounts(selectedAccounts),
    submitText: t('next'),
    disabled: hasNonEvmAccounts || selectedAccounts.size === 0
  })));
};
ChooseAccount.propTypes = {
  /**
   * Array of user account objects
   */
  accounts: _propTypes.default.arrayOf(_propTypes.default.shape({
    address: _propTypes.default.string,
    addressLabel: _propTypes.default.string,
    lastConnectedDate: _propTypes.default.string,
    balance: _propTypes.default.string
  })).isRequired,
  /**
   * Function to select an account
   */
  selectAccounts: _propTypes.default.func.isRequired,
  /**
   * Function to select a new account via modal
   */
  selectNewAccountViaModal: _propTypes.default.func.isRequired,
  /**
   * Native currency of current chain
   */
  nativeCurrency: _propTypes.default.string.isRequired,
  /**
   * A map of the last connected addresses
   */
  addressLastConnectedMap: _propTypes.default.object,
  /**
   * Function to cancel permission request
   */
  cancelPermissionsRequest: _propTypes.default.func.isRequired,
  /**
   * Permission request Id
   */
  permissionsRequestId: _propTypes.default.string.isRequired,
  /**
   * Currently selected account addresses
   */
  selectedAccountAddresses: _propTypes.default.object.isRequired,
  /**
   * Domain data used to display site-origin pill
   */
  targetSubjectMetadata: _propTypes.default.shape({
    extensionId: _propTypes.default.string,
    iconUrl: _propTypes.default.string,
    name: _propTypes.default.string,
    origin: _propTypes.default.string.isRequired,
    subjectType: _propTypes.default.string
  })
};
var _default = exports.default = ChooseAccount;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\permissions-connect\\choose-account\\choose-account.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\choose-account\\index.js", {"./choose-account":"D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\choose-account\\choose-account.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cpermissions-connect%5Cchoose-account%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _chooseAccount.default;
  }
});
var _chooseAccount = _interopRequireDefault(require("./choose-account"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\permissions-connect\\choose-account\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\connect-page\\connect-page.tsx", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../shared/lib/caip25-caveat-merger":"D:\\code\\v\\metamask-extension\\shared\\lib\\caip25-caveat-merger.ts","../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/multichain":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../../components/multichain/create-solana-account-modal/create-solana-account-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\create-solana-account-modal\\create-solana-account-modal.tsx","../../../components/multichain/pages/page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\index.ts","../../../components/multichain/pages/review-permissions-page/site-cell/site-cell":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\review-permissions-page\\site-cell\\site-cell.tsx","../../../components/ui/tabs":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tabs\\index.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../hooks/useOriginTrustSignals":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useOriginTrustSignals.ts","../../../hooks/useTrustSignals":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTrustSignals.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","./utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\connect-page\\utils.ts","@metamask/chain-agnostic-permission":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\chain-agnostic-permission\\dist\\index.cjs","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-tippy":"D:\\code\\v\\metamask-extension\\node_modules\\react-tippy\\dist\\react-tippy.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cpermissions-connect%5Cconnect-page%5Cconnect-page.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _chainAgnosticPermission = require("@metamask/chain-agnostic-permission");
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
var _reactTippy = require("react-tippy");
var _designSystemReact = require("@metamask/design-system-react");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _selectors = require("../../../selectors");
var _networks = require("../../../../shared/modules/selectors/networks");
var _componentLibrary = require("../../../components/component-library");
var _page = require("../../../components/multichain/pages/page");
var _siteCell = require("../../../components/multichain/pages/review-permissions-page/site-cell/site-cell");
var _designSystem = require("../../../helpers/constants/design-system");
var _network = require("../../../../shared/constants/network");
var _multichain = require("../../../selectors/multichain");
var _tabs = require("../../../components/ui/tabs");
var _multichain2 = require("../../../components/multichain");
var _util = require("../../../helpers/utils/util");
var _metametrics = require("../../../../shared/constants/metametrics");
var _metametrics2 = require("../../../contexts/metametrics");
var _createSolanaAccountModal = require("../../../components/multichain/create-solana-account-modal/create-solana-account-modal");
var _caip25CaveatMerger = require("../../../../shared/lib/caip25-caveat-merger");
var _useOriginTrustSignals = require("../../../hooks/useOriginTrustSignals");
var _useTrustSignals = require("../../../hooks/useTrustSignals");
var _utils2 = require("./utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConnectPage = ({
  request,
  permissionsRequestId,
  rejectPermissionsRequest,
  approveConnection,
  targetSubjectMetadata
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const existingPermissions = (0, _reactRedux.useSelector)(state => {
    var _request$metadata;
    return (0, _selectors.getPermissions)(state, (_request$metadata = request.metadata) === null || _request$metadata === void 0 ? void 0 : _request$metadata.origin);
  });
  const existingCaip25CaveatValue = (0, _react.useMemo)(() => existingPermissions ? (0, _utils2.getCaip25CaveatValueFromPermissions)(existingPermissions) : null, [existingPermissions]);
  const requestedCaip25CaveatValue = (0, _utils2.getCaip25CaveatValueFromPermissions)(request.permissions);
  const requestedCaip25CaveatValueWithExistingPermissions = existingCaip25CaveatValue ? (0, _caip25CaveatMerger.mergeCaip25CaveatValues)(requestedCaip25CaveatValue, existingCaip25CaveatValue) : requestedCaip25CaveatValue;
  const requestedCaipAccountIds = (0, _chainAgnosticPermission.getCaipAccountIdsFromCaip25CaveatValue)(requestedCaip25CaveatValueWithExistingPermissions);
  const requestedCaipChainIds = (0, _chainAgnosticPermission.getAllScopesFromCaip25CaveatValue)(requestedCaip25CaveatValueWithExistingPermissions);
  const {
    promptToCreateSolanaAccount,
    isEip1193Request
  } = request.metadata ?? {};
  const networkConfigurationsByCaipChainId = (0, _reactRedux.useSelector)(_networks.getAllNetworkConfigurationsByCaipChainId);
  const [nonTestNetworkConfigurations, testNetworkConfigurations] = (0, _react.useMemo)(() => Object.entries(networkConfigurationsByCaipChainId).reduce(([nonTestNetworksList, testNetworksList], [chainId, network]) => {
    const caipChainId = chainId;
    const isTestNetwork = _network.CAIP_FORMATTED_EVM_TEST_CHAINS.includes(caipChainId);
    (isTestNetwork ? testNetworksList : nonTestNetworksList).push({
      ...network,
      caipChainId
    });
    return [nonTestNetworksList, testNetworksList];
  }, [[], []]), [networkConfigurationsByCaipChainId]);
  const allNetworksList = (0, _react.useMemo)(() => [...nonTestNetworkConfigurations, ...testNetworkConfigurations].map(({
    caipChainId
  }) => caipChainId), [nonTestNetworkConfigurations, testNetworkConfigurations]);
  const [userHasModifiedSelection, setUserHasModifiedSelection] = (0, _react.useState)(false);
  const [showEditAccountsModal, setShowEditAccountsModal] = (0, _react.useState)(false);
  const [showCreateSolanaAccountModal, setShowCreateSolanaAccountModal] = (0, _react.useState)(false);

  // By default, if a non test network is the globally selected network. We will only show non test networks as default selected.
  const currentlySelectedNetwork = (0, _reactRedux.useSelector)(_multichain.getMultichainNetwork);
  const currentlySelectedNetworkChainId = currentlySelectedNetwork.chainId;
  // If globally selected network is a test network, include that in the default selected networks for connection request
  const selectedTestNetwork = testNetworkConfigurations.find(network => network.caipChainId === currentlySelectedNetworkChainId);
  let defaultSelectedNetworkList = selectedTestNetwork ? [...nonTestNetworkConfigurations, selectedTestNetwork].map(({
    caipChainId
  }) => caipChainId) : nonTestNetworkConfigurations.map(({
    caipChainId
  }) => caipChainId);
  let supportedRequestedCaipChainIds = requestedCaipChainIds.filter(caipChainId => allNetworksList.includes(caipChainId));

  // Only EVM networks should be selected if this request comes from the EIP-1193 API
  if (isEip1193Request) {
    defaultSelectedNetworkList = defaultSelectedNetworkList.filter(caipChainId => {
      const {
        namespace
      } = (0, _utils.parseCaipChainId)(caipChainId);
      return namespace === _utils.KnownCaipNamespace.Eip155;
    });
    const isRequestingSpecificEvmChains = supportedRequestedCaipChainIds.some(caipChainId => {
      const {
        namespace
      } = (0, _utils.parseCaipChainId)(caipChainId);
      return namespace === _utils.KnownCaipNamespace.Eip155;
    });

    // If the request is for EVM and no specific chains are requested,
    // we merge the default chains with existing permitted chains
    if (!isRequestingSpecificEvmChains && existingCaip25CaveatValue) {
      supportedRequestedCaipChainIds = Array.from(new Set([...defaultSelectedNetworkList, ...supportedRequestedCaipChainIds]));
    }
  }
  const defaultSelectedChainIds = supportedRequestedCaipChainIds.length > 0 ? supportedRequestedCaipChainIds : defaultSelectedNetworkList;
  const [selectedChainIds, setSelectedChainIds] = (0, _react.useState)(defaultSelectedChainIds);
  const handleChainIdsSelected = (0, _react.useCallback)((newSelectedChainIds, {
    isUserModified = true
  } = {}) => {
    if (isUserModified) {
      setUserHasModifiedSelection(true);
    }
    setSelectedChainIds(newSelectedChainIds);
  }, [setUserHasModifiedSelection, setSelectedChainIds]);
  const allAccounts = (0, _reactRedux.useSelector)(_selectors.getUpdatedAndSortedAccountsWithCaipAccountId);
  const requestedNamespaces = (0, _chainAgnosticPermission.getAllNamespacesFromCaip25CaveatValue)(requestedCaip25CaveatValueWithExistingPermissions);
  const requestedNamespacesWithoutWallet = requestedNamespaces.filter(namespace => namespace !== _utils.KnownCaipNamespace.Wallet);

  // all accounts that match the requested namespaces
  const supportedAccountsForRequestedNamespaces = allAccounts.filter(account => {
    const {
      chain: {
        namespace
      }
    } = (0, _utils.parseCaipAccountId)(account.caipAccountId);
    return requestedNamespacesWithoutWallet.includes(namespace);
  });

  // All requested accounts that are found in the wallet
  const supportedRequestedAccounts = supportedAccountsForRequestedNamespaces.filter(account => (0, _chainAgnosticPermission.isCaipAccountIdInPermittedAccountIds)(account.caipAccountId, requestedCaipAccountIds));
  const defaultAccounts = (0, _utils2.getDefaultAccounts)(requestedNamespacesWithoutWallet, supportedRequestedAccounts, supportedAccountsForRequestedNamespaces);
  const defaultCaipAccountAddresses = defaultAccounts.map(({
    caipAccountId
  }) => caipAccountId);
  const [selectedCaipAccountAddresses, setSelectedCaipAccountAddresses] = (0, _react.useState)(defaultCaipAccountAddresses);
  const handleCaipAccountAddressesSelected = (0, _react.useCallback)((caipAccountAddresses, {
    isUserModified = true
  } = {}) => {
    if (isUserModified) {
      setUserHasModifiedSelection(true);
    }
    let updatedSelectedChains = [...selectedChainIds];
    caipAccountAddresses.forEach(caipAccountAddress => {
      const {
        chain: {
          namespace: accountNamespace
        }
      } = (0, _utils.parseCaipAccountId)(caipAccountAddress);
      const existsSelectedChainForNamespace = updatedSelectedChains.some(caipChainId => {
        try {
          const {
            namespace: chainNamespace
          } = (0, _utils.parseCaipChainId)(caipChainId);
          return accountNamespace === chainNamespace;
        } catch (err) {
          return false;
        }
      });
      if (!existsSelectedChainForNamespace) {
        const chainIdsForNamespace = allNetworksList.filter(caipChainId => {
          try {
            const {
              namespace: chainNamespace
            } = (0, _utils.parseCaipChainId)(caipChainId);
            return accountNamespace === chainNamespace;
          } catch (err) {
            return false;
          }
        });
        updatedSelectedChains = Array.from(new Set([...updatedSelectedChains, ...chainIdsForNamespace]));
      }
    });
    handleChainIdsSelected(updatedSelectedChains, {
      isUserModified
    });
    setSelectedCaipAccountAddresses(caipAccountAddresses);
  }, [setUserHasModifiedSelection, setSelectedCaipAccountAddresses, selectedChainIds, handleChainIdsSelected, allNetworksList]);

  // Ensures the selected account state is kept in sync with the default selected account value
  // until the user makes modifications to the selected account/network values.
  (0, _react.useEffect)(() => {
    if (!userHasModifiedSelection && !(0, _lodash.isEqual)(defaultCaipAccountAddresses, selectedCaipAccountAddresses)) {
      handleCaipAccountAddressesSelected(defaultCaipAccountAddresses, {
        isUserModified: false
      });
    }
  }, [userHasModifiedSelection, handleCaipAccountAddressesSelected, selectedCaipAccountAddresses, JSON.stringify(defaultCaipAccountAddresses)]);
  const selectedAccounts = allAccounts.filter(({
    caipAccountId
  }) => {
    return selectedCaipAccountAddresses.some(selectedCaipAccountId => {
      return selectedCaipAccountId === caipAccountId;
    });
  });
  const solanaAccountExistsInWallet = (0, _react.useMemo)(() => {
    return allAccounts.some(({
      caipAccountId
    }) => {
      const {
        chain
      } = (0, _utils.parseCaipAccountId)(caipAccountId);
      return chain.namespace === _utils.KnownCaipNamespace.Solana;
    });
  }, [allAccounts]);
  const handleOpenAccountsModal = (0, _react.useCallback)(() => {
    setShowEditAccountsModal(true);
    trackEvent({
      category: _metametrics.MetaMetricsEventCategory.Navigation,
      event: _metametrics.MetaMetricsEventName.ViewPermissionedAccounts,
      properties: {
        location: 'Connect view (accounts tab), Permissions toast, Permissions (dapp)'
      }
    });
  }, [trackEvent]);
  const handleOpenCreateSolanaAccountModal = (0, _react.useCallback)(() => {
    setShowCreateSolanaAccountModal(true);
  }, []);
  const handleCloseCreateSolanaAccountModal = (0, _react.useCallback)(() => {
    setShowCreateSolanaAccountModal(false);
  }, []);
  const handleCloseEditAccountsModal = (0, _react.useCallback)(() => {
    setShowEditAccountsModal(false);
  }, []);
  const handleCancelConnection = (0, _react.useCallback)(() => {
    rejectPermissionsRequest(permissionsRequestId);
  }, [permissionsRequestId, rejectPermissionsRequest]);
  const onConfirm = (0, _react.useCallback)(() => {
    const _request = {
      ...request,
      permissions: {
        ...request.permissions,
        ...(0, _chainAgnosticPermission.generateCaip25Caveat)(requestedCaip25CaveatValueWithExistingPermissions, selectedCaipAccountAddresses, selectedChainIds)
      }
    };
    approveConnection(_request);
  }, [request, requestedCaip25CaveatValueWithExistingPermissions, selectedCaipAccountAddresses, selectedChainIds, approveConnection]);
  const title = (0, _util.transformOriginToTitle)(targetSubjectMetadata.origin);
  const originTrustSignals = (0, _useOriginTrustSignals.useOriginTrustSignals)(targetSubjectMetadata.origin);
  return /*#__PURE__*/_react.default.createElement(_page.Page, {
    "data-testid": "connect-page",
    className: "main-container connect-page",
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault
  }, /*#__PURE__*/_react.default.createElement(_page.Header, {
    paddingTop: 8,
    paddingBottom: 0
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center,
    marginBottom: 8
  }, targetSubjectMetadata.iconUrl ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    style: {
      filter: 'blur(16px) brightness(1.1)',
      position: 'absolute'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarFavicon, {
    backgroundColor: _designSystem.BackgroundColor.backgroundMuted,
    size: _componentLibrary.AvatarFaviconSize.Xl,
    src: targetSubjectMetadata.iconUrl,
    name: title
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarFavicon, {
    backgroundColor: _designSystem.BackgroundColor.backgroundMuted,
    size: _componentLibrary.AvatarFaviconSize.Lg,
    src: targetSubjectMetadata.iconUrl,
    name: title,
    style: {
      zIndex: 1,
      background: 'transparent'
    }
  })) : /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarBase, {
    size: _componentLibrary.AvatarBaseSize.Lg,
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    color: _designSystem.TextColor.textAlternative,
    style: {
      borderWidth: '0px'
    },
    backgroundColor: _designSystem.BackgroundColor.backgroundMuted
  }, (0, _util.isIpAddress)(title) ? '?' : (0, _util.getAvatarFallbackLetter)(title))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    gap: 2,
    marginBottom: 1
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingLg,
    style: {
      wordBreak: 'break-word',
      whiteSpace: 'normal'
    }
  }, title), originTrustSignals.state === _useTrustSignals.TrustSignalDisplayState.Verified && /*#__PURE__*/_react.default.createElement(_reactTippy.Tooltip, {
    title: t('alertReasonOriginTrustSignalVerified'),
    position: "bottom",
    style: {
      display: 'flex'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.VerifiedFilled,
    color: _designSystem.IconColor.infoDefault,
    size: _componentLibrary.IconSize.Sm
  }))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textAlternative
  }, t('connectionDescription')))), /*#__PURE__*/_react.default.createElement(_page.Content, {
    paddingLeft: 4,
    paddingRight: 4,
    backgroundColor: _designSystem.BackgroundColor.transparent
  }, /*#__PURE__*/_react.default.createElement(_tabs.Tabs, {
    onTabClick: () => null,
    backgroundColor: _designSystemReact.BoxBackgroundColor.Transparent,
    justifyContent: _designSystemReact.BoxJustifyContent.Center,
    defaultActiveTabKey: "accounts",
    tabListProps: {
      backgroundColor: _designSystemReact.BoxBackgroundColor.Transparent
    }
  }, /*#__PURE__*/_react.default.createElement(_tabs.Tab, {
    name: t('accounts'),
    tabKey: "accounts",
    "data-testid": "accounts-tab"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginTop: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    borderRadius: _designSystem.BorderRadius.XL,
    style: {
      overflow: 'auto',
      maxHeight: '268px',
      scrollbarColor: 'var(--color-icon-muted) transparent'
    }
  }, selectedAccounts.map(account => /*#__PURE__*/_react.default.createElement(_multichain2.AccountListItem, {
    showConnectedStatus: false,
    account: account,
    key: account.caipAccountId,
    selected: false
  })), selectedAccounts.length === 0 && !promptToCreateSolanaAccount && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "connect-page__accounts-empty",
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.center,
    borderRadius: _designSystem.BorderRadius.XL
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    onClick: handleOpenAccountsModal,
    "data-testid": "edit"
  }, t('selectAccountToConnect')))), selectedAccounts.length > 0 && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginTop: 4,
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    onClick: handleOpenAccountsModal,
    "data-testid": "edit"
  }, t('editAccounts'))), promptToCreateSolanaAccount && !solanaAccountExistsInWallet && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.center,
    marginTop: 4,
    gap: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    color: _designSystem.TextColor.textAlternative,
    textAlign: _designSystem.TextAlign.Center
  }, selectedAccounts.length === 0 ? t('solanaAccountRequired') : t('solanaAccountRequested')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    variant: _componentLibrary.ButtonVariant.Secondary,
    width: _designSystem.BlockSize.Full,
    size: _componentLibrary.ButtonSize.Lg,
    onClick: handleOpenCreateSolanaAccountModal,
    "data-testid": "create-solana-account"
  }, t('createSolanaAccount'))), showCreateSolanaAccountModal && /*#__PURE__*/_react.default.createElement(_createSolanaAccountModal.CreateSolanaAccountModal, {
    onClose: handleCloseCreateSolanaAccountModal
  }), showEditAccountsModal && /*#__PURE__*/_react.default.createElement(_multichain2.EditAccountsModal, {
    accounts: allAccounts,
    defaultSelectedAccountAddresses: selectedCaipAccountAddresses,
    onClose: handleCloseEditAccountsModal,
    onSubmit: handleCaipAccountAddressesSelected
  }))), /*#__PURE__*/_react.default.createElement(_tabs.Tab, {
    name: t('permissions'),
    tabKey: "permissions",
    "data-testid": "permissions-tab",
    disabled: promptToCreateSolanaAccount && !solanaAccountExistsInWallet && selectedAccounts.length === 0
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginTop: 4
  }, /*#__PURE__*/_react.default.createElement(_siteCell.SiteCell, {
    nonTestNetworks: nonTestNetworkConfigurations,
    testNetworks: testNetworkConfigurations,
    accounts: allAccounts,
    onSelectAccountAddresses: handleCaipAccountAddressesSelected,
    onSelectChainIds: handleChainIdsSelected,
    selectedAccountAddresses: selectedCaipAccountAddresses,
    selectedChainIds: selectedChainIds,
    isConnectFlow: true
  }))))), /*#__PURE__*/_react.default.createElement(_page.Footer, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 4,
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    gap: 4,
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    block: true,
    variant: _componentLibrary.ButtonVariant.Secondary,
    size: _componentLibrary.ButtonSize.Lg,
    "data-testid": "cancel-btn",
    onClick: handleCancelConnection
  }, t('cancel')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    block: true,
    "data-testid": "confirm-btn",
    size: _componentLibrary.ButtonSize.Lg,
    onClick: onConfirm,
    disabled: selectedCaipAccountAddresses.length === 0 || selectedChainIds.length === 0
  }, t('connect'))))));
};
exports.ConnectPage = ConnectPage;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\permissions-connect\\connect-page\\connect-page.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\connect-page\\utils.ts", {"../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","@metamask/chain-agnostic-permission":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\chain-agnostic-permission\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cpermissions-connect%5Cconnect-page%5Cutils.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCaip25CaveatValueFromPermissions = getCaip25CaveatValueFromPermissions;
exports.getCaip25PermissionsResponse = getCaip25PermissionsResponse;
exports.getDefaultAccounts = getDefaultAccounts;
var _utils = require("@metamask/utils");
var _chainAgnosticPermission = require("@metamask/chain-agnostic-permission");
var _util = require("../../../helpers/utils/util");
/**
 * Takes in an incoming {@link PermissionsRequest} and attempts to return the {@link Caip25CaveatValue}.
 *
 * @param permissions - The {@link PermissionsRequest} with the target name of the {@link Caip25EndowmentPermissionName}.
 * @returns The {@link Caip25CaveatValue}.
 */
function getCaip25CaveatValueFromPermissions(permissions) {
  var _permissions$Caip25En;
  return (permissions === null || permissions === void 0 || (_permissions$Caip25En = permissions[_chainAgnosticPermission.Caip25EndowmentPermissionName]) === null || _permissions$Caip25En === void 0 || (_permissions$Caip25En = _permissions$Caip25En.caveats) === null || _permissions$Caip25En === void 0 || (_permissions$Caip25En = _permissions$Caip25En.find(caveat => caveat.type === _chainAgnosticPermission.Caip25CaveatType)) === null || _permissions$Caip25En === void 0 ? void 0 : _permissions$Caip25En.value) ?? {
    optionalScopes: {},
    requiredScopes: {},
    sessionProperties: {},
    isMultichainOrigin: false
  };
}

/**
 * Modifies the requested CAIP-25 permissions object after UI confirmation.
 *
 * @param caip25CaveatValue - The requested CAIP-25 caveat value to modify.
 * @param ethAccountAddresses - The list of permitted eth addresses.
 * @param ethChainIds - The list of permitted eth chainIds.
 */
function getCaip25PermissionsResponse(caip25CaveatValue, ethAccountAddresses, ethChainIds) {
  const caveatValueWithChains = (0, _chainAgnosticPermission.setPermittedEthChainIds)(caip25CaveatValue, ethChainIds);
  const caveatValueWithAccounts = (0, _chainAgnosticPermission.setEthAccounts)(caveatValueWithChains, ethAccountAddresses);
  return {
    [_chainAgnosticPermission.Caip25EndowmentPermissionName]: {
      caveats: [{
        type: _chainAgnosticPermission.Caip25CaveatType,
        value: caveatValueWithAccounts
      }]
    }
  };
}

/**
 * Gets the default accounts for the requested namespaces.
 * We need at least one default per requested namespace
 * if there are more explicitly requested accounts, use those instead
 * for that namespace
 *
 * @param requestedNamespaces - The namespaces requested.
 * @param supportedRequestedAccounts - The supported requested accounts.
 * @param allAccounts - All available accounts.
 */
function getDefaultAccounts(requestedNamespaces, supportedRequestedAccounts, allAccounts) {
  const defaultAccounts = [];
  const satisfiedNamespaces = new Set();
  supportedRequestedAccounts.forEach(account => {
    const {
      chain: {
        namespace
      }
    } = (0, _utils.parseCaipAccountId)(account.caipAccountId);
    if (requestedNamespaces.includes(namespace)) {
      defaultAccounts.push(account);
      satisfiedNamespaces.add(namespace);
    }
  });
  const unsatisfiedNamespaces = requestedNamespaces.filter(namespace => !satisfiedNamespaces.has(namespace));
  if (unsatisfiedNamespaces.length > 0) {
    const allAccountsSortedByLastSelected = (0, _util.sortSelectedInternalAccounts)(allAccounts);
    for (const namespace of unsatisfiedNamespaces) {
      const defaultAccountForNamespace = allAccountsSortedByLastSelected.find(account => {
        const {
          chain: {
            namespace: accountNamespace
          }
        } = (0, _utils.parseCaipAccountId)(account.caipAccountId);
        return accountNamespace === namespace;
      });
      if (defaultAccountForNamespace) {
        defaultAccounts.push(defaultAccountForNamespace);
      }
    }
  }
  return defaultAccounts;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\permissions-connect\\connect-page\\utils.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\index.js", {"./permissions-connect.container":"D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\permissions-connect.container.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cpermissions-connect%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _permissionsConnect.default;
  }
});
var _permissionsConnect = _interopRequireDefault(require("./permissions-connect.container"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\permissions-connect\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\permissions-connect.component.js", {"../../../app/scripts/lib/multichain/address":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\multichain\\address.ts","../../../shared/constants/time":"D:\\code\\v\\metamask-extension\\shared\\constants\\time.ts","../../../shared/lib/multichain/scope-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\multichain\\scope-utils.ts","../../components/app/permission-page-container":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\permission-page-container\\index.js","../../components/app/snaps/snap-authorship-header/snap-authorship-header":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-authorship-header\\snap-authorship-header.js","../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../components/multichain-accounts/permissions/multichain-edit-accounts-page/multichain-edit-account-wrapper":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\permissions\\multichain-edit-accounts-page\\multichain-edit-account-wrapper.tsx","../../components/multichain-accounts/state2-wrapper/state2-wrapper":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\state2-wrapper\\state2-wrapper.tsx","../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../hooks/useAccountGroupsForPermissions":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAccountGroupsForPermissions.ts","../multichain-accounts/multichain-accounts-connect-page/multichain-accounts-connect-page":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\multichain-accounts-connect-page\\multichain-accounts-connect-page.tsx","./choose-account":"D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\choose-account\\index.js","./connect-page/connect-page":"D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\connect-page\\connect-page.tsx","./connect-page/utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\connect-page\\utils.ts","./redirect":"D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\redirect\\index.js","./snaps/snap-install":"D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\snaps\\snap-install\\index.js","./snaps/snap-result":"D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\snaps\\snap-result\\index.js","./snaps/snap-update":"D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\snaps\\snap-update\\index.js","./snaps/snaps-connect":"D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\snaps\\snaps-connect\\index.js","@metamask/chain-agnostic-permission":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\chain-agnostic-permission\\dist\\index.cjs","@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cpermissions-connect%5Cpermissions-connect.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _rpcErrors = require("@metamask/rpc-errors");
var _permissionController = require("@metamask/permission-controller");
var _snapsUtils = require("@metamask/snaps-utils");
var _chainAgnosticPermission = require("@metamask/chain-agnostic-permission");
var _utils = require("@metamask/utils");
var _address = require("../../../app/scripts/lib/multichain/address");
var _time = require("../../../shared/constants/time");
var _routes = require("../../helpers/constants/routes");
var _permissionPageContainer = _interopRequireDefault(require("../../components/app/permission-page-container"));
var _componentLibrary = require("../../components/component-library");
var _snapAuthorshipHeader = _interopRequireDefault(require("../../components/app/snaps/snap-authorship-header/snap-authorship-header"));
var _state2Wrapper = require("../../components/multichain-accounts/state2-wrapper/state2-wrapper");
var _multichainAccountsConnectPage = require("../multichain-accounts/multichain-accounts-connect-page/multichain-accounts-connect-page");
var _useAccountGroupsForPermissions = require("../../hooks/useAccountGroupsForPermissions");
var _scopeUtils = require("../../../shared/lib/multichain/scope-utils");
var _multichainEditAccountWrapper = require("../../components/multichain-accounts/permissions/multichain-edit-accounts-page/multichain-edit-account-wrapper");
var _chooseAccount = _interopRequireDefault(require("./choose-account"));
var _redirect = _interopRequireDefault(require("./redirect"));
var _snapsConnect = _interopRequireDefault(require("./snaps/snaps-connect"));
var _snapInstall = _interopRequireDefault(require("./snaps/snap-install"));
var _snapUpdate = _interopRequireDefault(require("./snaps/snap-update"));
var _snapResult = _interopRequireDefault(require("./snaps/snap-result"));
var _connectPage = require("./connect-page/connect-page");
var _utils2 = require("./connect-page/utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } // TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths
const APPROVE_TIMEOUT = _time.MILLISECOND * 1200;
function getDefaultSelectedAccounts(currentAddress, permissions) {
  const requestedCaip25CaveatValue = (0, _utils2.getCaip25CaveatValueFromPermissions)(permissions);
  const requestedAccounts = (0, _chainAgnosticPermission.getEthAccounts)(requestedCaip25CaveatValue);
  if (requestedAccounts.length > 0) {
    return new Set(requestedAccounts.map(address => address.toLowerCase())
    // We only consider EVM accounts here (used for `eth_requestAccounts` or `eth_accounts`)
    .filter(_address.isEthAddress));
  }

  // We only consider EVM accounts here (used for `eth_requestAccounts` or `eth_accounts`)
  return new Set((0, _address.isEthAddress)(currentAddress) ? [currentAddress] : []);
}
function getRequestedChainIds(permissions) {
  const requestedCaip25CaveatValue = (0, _utils2.getCaip25CaveatValueFromPermissions)(permissions);
  return (0, _chainAgnosticPermission.getPermittedEthChainIds)(requestedCaip25CaveatValue);
}
class PermissionConnect extends _react.Component {
  constructor(..._args) {
    var _this$props$permissio;
    super(..._args);
    _defineProperty(this, "state", {
      redirecting: false,
      selectedAccountAddresses: getDefaultSelectedAccounts(this.props.currentAddress, (_this$props$permissio = this.props.permissionsRequest) === null || _this$props$permissio === void 0 ? void 0 : _this$props$permissio.permissions),
      permissionsApproved: null,
      origin: this.props.origin,
      targetSubjectMetadata: this.props.targetSubjectMetadata || {},
      snapsInstallPrivacyWarningShown: this.props.snapsInstallPrivacyWarningShown
    });
    _defineProperty(this, "selectAccounts", addresses => {
      const {
        confirmPermissionPath,
        requestType,
        snapsConnectPath,
        snapInstallPath,
        snapUpdatePath,
        snapResultPath
      } = this.props;
      this.setState({
        selectedAccountAddresses: addresses
      }, () => {
        switch (requestType) {
          case 'wallet_installSnap':
            this.props.history.push(snapInstallPath);
            break;
          case 'wallet_updateSnap':
            this.props.history.push(snapUpdatePath);
            break;
          case 'wallet_installSnapResult':
            this.props.history.push(snapResultPath);
            break;
          case 'wallet_connectSnaps':
            this.props.history.replace(snapsConnectPath);
            break;
          default:
            this.props.history.push(confirmPermissionPath);
        }
      });
    });
    _defineProperty(this, "cancelPermissionsRequest", async requestId => {
      const {
        rejectPermissionsRequest
      } = this.props;
      if (requestId) {
        await rejectPermissionsRequest(requestId);
        this.redirect(false);
      }
    });
    _defineProperty(this, "renderSnapChooseAccountState1", () => {
      const {
        accounts,
        nativeCurrency,
        showNewAccountModal,
        newAccountNumber,
        addressLastConnectedMap,
        permissionsRequestId,
        targetSubjectMetadata
      } = this.props;
      const {
        selectedAccountAddresses
      } = this.state;
      return /*#__PURE__*/_react.default.createElement(_chooseAccount.default, {
        accounts: accounts,
        nativeCurrency: nativeCurrency,
        selectAccounts: addresses => this.selectAccounts(addresses),
        selectNewAccountViaModal: handleAccountClick => {
          showNewAccountModal({
            onCreateNewAccount: address => handleAccountClick(address),
            newAccountNumber
          });
        },
        addressLastConnectedMap: addressLastConnectedMap,
        cancelPermissionsRequest: requestId => this.cancelPermissionsRequest(requestId),
        permissionsRequestId: permissionsRequestId,
        selectedAccountAddresses: selectedAccountAddresses,
        targetSubjectMetadata: targetSubjectMetadata
      });
    });
    _defineProperty(this, "renderSnapChooseAccountState2", () => {
      const {
        permissionsRequestId,
        accountGroups,
        permissionsRequest
      } = this.props;
      const {
        t
      } = this.context;
      const requestedCaip25CaveatValue = (0, _utils2.getCaip25CaveatValueFromPermissions)(permissionsRequest === null || permissionsRequest === void 0 ? void 0 : permissionsRequest.permissions);
      const caipChainIdsToUse = [];
      const requestedCaipChainIds = (0, _chainAgnosticPermission.getAllScopesFromCaip25CaveatValue)(requestedCaip25CaveatValue).filter(chainId => {
        const {
          namespace
        } = (0, _utils.parseCaipChainId)(chainId);
        return namespace !== _utils.KnownCaipNamespace.Wallet;
      });
      const requestedNamespaces = (0, _chainAgnosticPermission.getAllNamespacesFromCaip25CaveatValue)(requestedCaip25CaveatValue);
      if (requestedCaipChainIds.length > 0) {
        requestedCaipChainIds.forEach(chainId => {
          caipChainIdsToUse.push(chainId);
        });
      }
      if (requestedNamespaces.includes(_utils.KnownCaipNamespace.Eip155)) {
        caipChainIdsToUse.push(`${_utils.KnownCaipNamespace.Eip155}:0`);
      }
      return /*#__PURE__*/_react.default.createElement(_multichainEditAccountWrapper.MultichainEditAccountsPageWrapper, {
        title: t('connectWithMetaMask'),
        permissions: permissionsRequest === null || permissionsRequest === void 0 ? void 0 : permissionsRequest.permissions,
        onSubmit: accountGroupIds => {
          const filteredAccountGroups = accountGroups.filter(group => accountGroupIds.includes(group.id) && (0, _useAccountGroupsForPermissions.supportsChainIds)(group, caipChainIdsToUse));
          const addresses = (0, _scopeUtils.getCaip25AccountIdsFromAccountGroupAndScope)(filteredAccountGroups, caipChainIdsToUse).map(caip25AccountId => (0, _utils.parseCaipAccountId)(caip25AccountId).address);
          this.selectAccounts(new Set(addresses));
        },
        onClose: () => this.cancelPermissionsRequest(permissionsRequestId)
      });
    });
    _defineProperty(this, "renderConnectPageState1", () => {
      const connectPageProps = {
        rejectPermissionsRequest: requestId => this.cancelPermissionsRequest(requestId),
        activeTabOrigin: this.state.origin,
        request: this.props.permissionsRequest || {},
        permissionsRequestId: this.props.permissionsRequestId,
        approveConnection: this.approveConnection,
        targetSubjectMetadata: this.props.targetSubjectMetadata
      };
      return /*#__PURE__*/_react.default.createElement(_connectPage.ConnectPage, connectPageProps);
    });
    _defineProperty(this, "renderConnectPageState2", () => {
      const connectPageProps = {
        rejectPermissionsRequest: requestId => this.cancelPermissionsRequest(requestId),
        activeTabOrigin: this.state.origin,
        request: this.props.permissionsRequest || {},
        permissionsRequestId: this.props.permissionsRequestId,
        approveConnection: this.approveConnection,
        targetSubjectMetadata: this.props.targetSubjectMetadata
      };
      return /*#__PURE__*/_react.default.createElement(_multichainAccountsConnectPage.MultichainAccountsConnectPage, connectPageProps);
    });
    _defineProperty(this, "approveConnection", (...args) => {
      const {
        approvePermissionsRequest
      } = this.props;
      approvePermissionsRequest(...args);
      this.redirect(true);
    });
  }
  componentDidMount() {
    const {
      connectPath,
      confirmPermissionPath,
      snapsConnectPath,
      snapInstallPath,
      snapUpdatePath,
      snapResultPath,
      requestType,
      getRequestAccountTabIds,
      permissionsRequest,
      history,
      isRequestingAccounts
    } = this.props;
    getRequestAccountTabIds();
    if (!permissionsRequest) {
      history.replace(_routes.DEFAULT_ROUTE);
      return;
    }
    if (history.location.pathname === connectPath && !isRequestingAccounts) {
      switch (requestType) {
        case 'wallet_installSnap':
          history.replace(snapInstallPath);
          break;
        case 'wallet_updateSnap':
          history.replace(snapUpdatePath);
          break;
        case 'wallet_installSnapResult':
          history.replace(snapResultPath);
          break;
        case 'wallet_connectSnaps':
          history.replace(snapsConnectPath);
          break;
        default:
          history.replace(confirmPermissionPath);
      }
    }
  }
  componentDidUpdate(prevProps) {
    var _prevProps$targetSubj;
    const {
      permissionsRequest,
      lastConnectedInfo,
      targetSubjectMetadata
    } = this.props;
    const {
      redirecting,
      origin
    } = this.state;

    // We cache the last known good targetSubjectMetadata since it may be null when the approval is cleared
    if (targetSubjectMetadata !== null && targetSubjectMetadata !== void 0 && targetSubjectMetadata.origin && ((_prevProps$targetSubj = prevProps.targetSubjectMetadata) === null || _prevProps$targetSubj === void 0 ? void 0 : _prevProps$targetSubj.origin) !== (targetSubjectMetadata === null || targetSubjectMetadata === void 0 ? void 0 : targetSubjectMetadata.origin)) {
      this.setState({
        targetSubjectMetadata
      });
    }
    if (!permissionsRequest && prevProps.permissionsRequest && !redirecting) {
      var _lastConnectedInfo$or, _prevProps$lastConnec;
      const accountsLastApprovedTime = ((_lastConnectedInfo$or = lastConnectedInfo[origin]) === null || _lastConnectedInfo$or === void 0 ? void 0 : _lastConnectedInfo$or.lastApproved) || 0;
      const initialAccountsLastApprovedTime = ((_prevProps$lastConnec = prevProps.lastConnectedInfo[origin]) === null || _prevProps$lastConnec === void 0 ? void 0 : _prevProps$lastConnec.lastApproved) || 0;
      const approved = accountsLastApprovedTime > initialAccountsLastApprovedTime;
      this.redirect(approved);
    }
  }
  redirect(approved) {
    const {
      history,
      permissionsRequest
    } = this.props;
    let shouldRedirect = true;
    const isRequestingSnap = (permissionsRequest === null || permissionsRequest === void 0 ? void 0 : permissionsRequest.permissions) && Object.keys(permissionsRequest.permissions).includes('wallet_snap');
    shouldRedirect = !isRequestingSnap;
    this.setState({
      redirecting: shouldRedirect,
      permissionsApproved: approved
    });
    if (shouldRedirect && approved) {
      setTimeout(() => history.push(_routes.DEFAULT_ROUTE), APPROVE_TIMEOUT);
      return;
    }
    history.push(_routes.DEFAULT_ROUTE);
  }
  goBack() {
    const {
      history,
      connectPath
    } = this.props;
    history.push(connectPath);
  }
  renderTopBar(permissionsRequestId) {
    const {
      targetSubjectMetadata
    } = this.state;
    const handleCancelFromHeader = () => {
      this.cancelPermissionsRequest(permissionsRequestId);
    };
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      style: {
        boxShadow: targetSubjectMetadata.subjectType === _permissionController.SubjectType.Snap && 'var(--shadow-size-lg) var(--color-shadow-default)'
      }
    }, targetSubjectMetadata.subjectType === _permissionController.SubjectType.Snap && /*#__PURE__*/_react.default.createElement(_snapAuthorshipHeader.default, {
      snapId: targetSubjectMetadata.origin,
      boxShadow: "none",
      onCancel: handleCancelFromHeader
    }));
  }
  render() {
    var _permissionsRequest$m;
    const {
      accounts,
      permissionsRequest,
      permissionsRequestId,
      connectPath,
      confirmPermissionPath,
      hideTopBar,
      targetSubjectMetadata,
      snapsConnectPath,
      snapInstallPath,
      snapUpdatePath,
      snapResultPath,
      requestState,
      approvePendingApproval,
      rejectPendingApproval,
      setSnapsInstallPrivacyWarningShownStatus,
      approvePermissionsRequest,
      history
    } = this.props;
    const {
      selectedAccountAddresses,
      permissionsApproved,
      redirecting,
      snapsInstallPrivacyWarningShown
    } = this.state;
    const isRequestingSnap = (0, _snapsUtils.isSnapId)(permissionsRequest === null || permissionsRequest === void 0 || (_permissionsRequest$m = permissionsRequest.metadata) === null || _permissionsRequest$m === void 0 ? void 0 : _permissionsRequest$m.origin);
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "permissions-connect"
    }, !hideTopBar && this.renderTopBar(permissionsRequestId), redirecting && permissionsApproved ? /*#__PURE__*/_react.default.createElement(_redirect.default, {
      subjectMetadata: targetSubjectMetadata
    }) : /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Route, {
      path: connectPath,
      exact: true,
      render: () => {
        if (isRequestingSnap) {
          return /*#__PURE__*/_react.default.createElement(_state2Wrapper.State2Wrapper, {
            state1Component: this.renderSnapChooseAccountState1,
            state2Component: this.renderSnapChooseAccountState2
          });
        }
        return /*#__PURE__*/_react.default.createElement(_state2Wrapper.State2Wrapper, {
          state1Component: this.renderConnectPageState1,
          state2Component: this.renderConnectPageState2
        });
      }
    }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Route, {
      path: confirmPermissionPath,
      exact: true,
      render: () => /*#__PURE__*/_react.default.createElement(_permissionPageContainer.default, {
        request: permissionsRequest || {},
        approvePermissionsRequest: (...args) => {
          approvePermissionsRequest(...args);
          this.redirect(true);
        },
        rejectPermissionsRequest: requestId => this.cancelPermissionsRequest(requestId),
        selectedAccounts: accounts.filter(account => selectedAccountAddresses.has(account.address)),
        requestedChainIds: getRequestedChainIds(permissionsRequest === null || permissionsRequest === void 0 ? void 0 : permissionsRequest.permissions),
        targetSubjectMetadata: targetSubjectMetadata,
        history: history,
        connectPath: connectPath,
        snapsInstallPrivacyWarningShown: snapsInstallPrivacyWarningShown,
        setSnapsInstallPrivacyWarningShownStatus: setSnapsInstallPrivacyWarningShownStatus
      })
    }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Route, {
      path: snapsConnectPath,
      exact: true,
      render: () => /*#__PURE__*/_react.default.createElement(_snapsConnect.default, {
        request: permissionsRequest || {},
        approveConnection: this.approveConnection,
        rejectConnection: requestId => this.cancelPermissionsRequest(requestId),
        targetSubjectMetadata: targetSubjectMetadata,
        snapsInstallPrivacyWarningShown: snapsInstallPrivacyWarningShown,
        setSnapsInstallPrivacyWarningShownStatus: setSnapsInstallPrivacyWarningShownStatus
      })
    }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Route, {
      path: snapInstallPath,
      exact: true,
      render: () => /*#__PURE__*/_react.default.createElement(_snapInstall.default, {
        request: permissionsRequest || {},
        requestState: requestState || {},
        approveSnapInstall: requestId => {
          approvePendingApproval(requestId, {
            ...permissionsRequest,
            permissions: requestState.permissions,
            approvedAccounts: [...selectedAccountAddresses]
          });
          this.setState({
            permissionsApproved: true
          });
        },
        rejectSnapInstall: requestId => {
          rejectPendingApproval(requestId, (0, _rpcErrors.serializeError)(_rpcErrors.providerErrors.userRejectedRequest()));
          this.setState({
            permissionsApproved: true
          });
        },
        targetSubjectMetadata: targetSubjectMetadata
      })
    }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Route, {
      path: snapUpdatePath,
      exact: true,
      render: () => /*#__PURE__*/_react.default.createElement(_snapUpdate.default, {
        request: permissionsRequest || {},
        requestState: requestState || {},
        approveSnapUpdate: requestId => {
          approvePendingApproval(requestId, {
            ...permissionsRequest,
            permissions: requestState.permissions,
            approvedAccounts: [...selectedAccountAddresses]
          });
          this.setState({
            permissionsApproved: true
          });
        },
        rejectSnapUpdate: requestId => {
          rejectPendingApproval(requestId, (0, _rpcErrors.serializeError)(_rpcErrors.providerErrors.userRejectedRequest()));
          this.setState({
            permissionsApproved: false
          });
        },
        targetSubjectMetadata: targetSubjectMetadata
      })
    }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Route, {
      path: snapResultPath,
      exact: true,
      render: () => /*#__PURE__*/_react.default.createElement(_snapResult.default, {
        request: permissionsRequest || {},
        requestState: requestState || {},
        approveSnapResult: requestId => {
          approvePendingApproval(requestId);
          this.setState({
            permissionsApproved: true
          });
        },
        targetSubjectMetadata: targetSubjectMetadata
      })
    })));
  }
}
exports.default = PermissionConnect;
_defineProperty(PermissionConnect, "propTypes", {
  approvePermissionsRequest: _propTypes.default.func.isRequired,
  rejectPermissionsRequest: _propTypes.default.func.isRequired,
  getRequestAccountTabIds: _propTypes.default.func.isRequired,
  accounts: _propTypes.default.arrayOf(_propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    address: _propTypes.default.string.isRequired,
    metadata: _propTypes.default.shape({
      name: _propTypes.default.string.isRequired,
      snap: _propTypes.default.shape({
        id: _propTypes.default.string.isRequired,
        name: _propTypes.default.string,
        enabled: _propTypes.default.bool
      }),
      keyring: _propTypes.default.shape({
        type: _propTypes.default.string.isRequired
      }).isRequired
    }).isRequired,
    addressLabel: _propTypes.default.string.isRequired,
    label: _propTypes.default.string.isRequired,
    balance: _propTypes.default.string.isRequired
  })).isRequired,
  accountGroups: _propTypes.default.arrayOf(_propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    accounts: _propTypes.default.arrayOf(_propTypes.default.object.isRequired)
  })).isRequired,
  currentAddress: _propTypes.default.string.isRequired,
  origin: _propTypes.default.string,
  showNewAccountModal: _propTypes.default.func.isRequired,
  newAccountNumber: _propTypes.default.number.isRequired,
  nativeCurrency: _propTypes.default.string,
  permissionsRequest: _propTypes.default.object,
  addressLastConnectedMap: _propTypes.default.object.isRequired,
  lastConnectedInfo: _propTypes.default.object.isRequired,
  permissionsRequestId: _propTypes.default.string,
  history: _propTypes.default.object.isRequired,
  connectPath: _propTypes.default.string.isRequired,
  confirmPermissionPath: _propTypes.default.string.isRequired,
  requestType: _propTypes.default.string.isRequired,
  snapsConnectPath: _propTypes.default.string.isRequired,
  snapInstallPath: _propTypes.default.string.isRequired,
  snapUpdatePath: _propTypes.default.string.isRequired,
  snapResultPath: _propTypes.default.string.isRequired,
  requestState: _propTypes.default.object.isRequired,
  approvePendingApproval: _propTypes.default.func.isRequired,
  rejectPendingApproval: _propTypes.default.func.isRequired,
  setSnapsInstallPrivacyWarningShownStatus: _propTypes.default.func.isRequired,
  snapsInstallPrivacyWarningShown: _propTypes.default.bool.isRequired,
  hideTopBar: _propTypes.default.bool,
  targetSubjectMetadata: _propTypes.default.shape({
    extensionId: _propTypes.default.string,
    iconUrl: _propTypes.default.string,
    name: _propTypes.default.string,
    origin: _propTypes.default.string,
    subjectType: _propTypes.default.string
  }),
  isRequestingAccounts: _propTypes.default.bool.isRequired
});
_defineProperty(PermissionConnect, "defaultProps", {
  origin: '',
  nativeCurrency: '',
  permissionsRequest: undefined,
  permissionsRequestId: ''
});
_defineProperty(PermissionConnect, "contextTypes", {
  t: _propTypes.default.func
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\permissions-connect\\permissions-connect.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\permissions-connect.container.js", {"../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./permissions-connect.component":"D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\permissions-connect.component.js","@metamask/chain-agnostic-permission":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\chain-agnostic-permission\\dist\\index.cjs","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs","@metamask/snaps-rpc-methods":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\index.cjs","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cpermissions-connect%5Cpermissions-connect.container.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _permissionController = require("@metamask/permission-controller");
var _snapsRpcMethods = require("@metamask/snaps-rpc-methods");
var _reactRedux = require("react-redux");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _keyringApi = require("@metamask/keyring-api");
var _chainAgnosticPermission = require("@metamask/chain-agnostic-permission");
var _selectors = require("../../selectors");
var _metamask = require("../../ducks/metamask/metamask");
var _util = require("../../helpers/utils/util");
var _actions = require("../../store/actions");
var _routes = require("../../helpers/constants/routes");
var _accountTree = require("../../selectors/multichain-accounts/account-tree");
var _permissionsConnect = _interopRequireDefault(require("./permissions-connect.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const mapStateToProps = (state, ownProps) => {
  var _permissionsRequest$p, _permissionsRequest$p2, _lastConnectedInfo$or;
  const {
    match: {
      params: {
        id: permissionsRequestId
      }
    },
    location: {
      pathname
    }
  } = ownProps;
  let permissionsRequests = (0, _selectors.getPermissionsRequests)(state);
  permissionsRequests = [...permissionsRequests, ...(0, _selectors.getSnapInstallOrUpdateRequests)(state)];
  const {
    address: currentAddress
  } = (0, _selectors.getSelectedInternalAccount)(state);
  const permissionsRequest = permissionsRequests.find(req => req.metadata.id === permissionsRequestId);
  const {
    metadata = {},
    diff = {}
  } = permissionsRequest || {};
  const {
    origin
  } = metadata;
  const nativeCurrency = (0, _metamask.getNativeCurrency)(state);
  const isRequestApprovalPermittedChains = Boolean(diff === null || diff === void 0 ? void 0 : diff.permissionDiffMap);
  const isRequestingAccounts = Boolean((permissionsRequest === null || permissionsRequest === void 0 || (_permissionsRequest$p = permissionsRequest.permissions) === null || _permissionsRequest$p === void 0 ? void 0 : _permissionsRequest$p[_chainAgnosticPermission.Caip25EndowmentPermissionName]) && !isRequestApprovalPermittedChains);
  const targetSubjectMetadata = (0, _selectors.getTargetSubjectMetadata)(state, origin) ?? {
    name: (0, _util.getURLHostName)(origin) || origin,
    origin,
    iconUrl: null,
    extensionId: null,
    subjectType: _permissionController.SubjectType.Unknown
  };
  let requestType = (0, _selectors.getRequestType)(state, permissionsRequestId);

  // We want to only assign the wallet_connectSnaps request type (i.e. only show
  // SnapsConnect) if and only if we get a singular wallet_snap permission request.
  // Any other request gets pushed to the normal permission connect flow.
  if (permissionsRequest && Object.keys(permissionsRequest.permissions || {}).length === 1 && (_permissionsRequest$p2 = permissionsRequest.permissions) !== null && _permissionsRequest$p2 !== void 0 && _permissionsRequest$p2[_snapsRpcMethods.WALLET_SNAP_PERMISSION_KEY]) {
    requestType = 'wallet_connectSnaps';
  }
  const requestState = (0, _selectors.getRequestState)(state, permissionsRequestId) || {};

  // We only consider EVM accounts.
  // Connections with non-EVM accounts (Bitcoin only for now) are used implicitly and handled by the Bitcoin Snap itself.
  const accountsWithLabels = (0, _selectors.getAccountsWithLabels)(state).filter(account => (0, _keyringApi.isEvmAccountType)(account.type));
  const lastConnectedInfo = (0, _selectors.getLastConnectedInfo)(state) || {};
  const addressLastConnectedMap = ((_lastConnectedInfo$or = lastConnectedInfo[origin]) === null || _lastConnectedInfo$or === void 0 ? void 0 : _lastConnectedInfo$or.accounts) || {};
  Object.keys(addressLastConnectedMap).forEach(key => {
    addressLastConnectedMap[key] = (0, _util.formatDate)(addressLastConnectedMap[key], 'yyyy-MM-dd');
  });
  const connectPath = `${_routes.CONNECT_ROUTE}/${permissionsRequestId}`;
  const confirmPermissionPath = `${_routes.CONNECT_ROUTE}/${permissionsRequestId}${_routes.CONNECT_CONFIRM_PERMISSIONS_ROUTE}`;
  const snapsConnectPath = `${_routes.CONNECT_ROUTE}/${permissionsRequestId}${_routes.CONNECT_SNAPS_CONNECT_ROUTE}`;
  const snapInstallPath = `${_routes.CONNECT_ROUTE}/${permissionsRequestId}${_routes.CONNECT_SNAP_INSTALL_ROUTE}`;
  const snapUpdatePath = `${_routes.CONNECT_ROUTE}/${permissionsRequestId}${_routes.CONNECT_SNAP_UPDATE_ROUTE}`;
  const snapResultPath = `${_routes.CONNECT_ROUTE}/${permissionsRequestId}${_routes.CONNECT_SNAP_RESULT_ROUTE}`;
  const isSnapInstallOrUpdateOrResult = pathname === snapInstallPath || pathname === snapUpdatePath || pathname === snapResultPath;
  let totalPages = 1 + isRequestingAccounts;
  totalPages += isSnapInstallOrUpdateOrResult;
  totalPages = totalPages.toString();
  let page = '';
  if (pathname === connectPath) {
    page = '1';
  } else if (pathname === confirmPermissionPath) {
    page = isRequestingAccounts ? '2' : '1';
  } else if (isSnapInstallOrUpdateOrResult) {
    page = isRequestingAccounts ? '3' : '2';
  } else if (pathname === snapsConnectPath) {
    page = 1;
  } else {
    throw new Error('Incorrect path for permissions-connect component');
  }
  return {
    isRequestingAccounts,
    requestType,
    snapsConnectPath,
    snapInstallPath,
    snapUpdatePath,
    snapResultPath,
    requestState,
    hideTopBar: isSnapInstallOrUpdateOrResult,
    snapsInstallPrivacyWarningShown: (0, _selectors.getSnapsInstallPrivacyWarningShown)(state),
    permissionsRequest,
    permissionsRequestId,
    accounts: accountsWithLabels,
    accountGroups: (0, _accountTree.getAccountGroupWithInternalAccounts)(state),
    currentAddress,
    origin,
    newAccountNumber: accountsWithLabels.length + 1,
    nativeCurrency,
    addressLastConnectedMap,
    lastConnectedInfo,
    connectPath,
    confirmPermissionPath,
    totalPages,
    page,
    targetSubjectMetadata
  };
};
const mapDispatchToProps = dispatch => {
  return {
    approvePermissionsRequest: request => dispatch((0, _actions.approvePermissionsRequest)(request)),
    rejectPermissionsRequest: requestId => dispatch((0, _actions.rejectPermissionsRequest)(requestId)),
    approvePendingApproval: (id, value) => dispatch((0, _actions.resolvePendingApproval)(id, value)),
    rejectPendingApproval: (id, error) => dispatch((0, _actions.rejectPendingApproval)(id, error)),
    setSnapsInstallPrivacyWarningShownStatus: shown => {
      dispatch((0, _actions.setSnapsInstallPrivacyWarningShownStatus)(shown));
    },
    showNewAccountModal: ({
      onCreateNewAccount,
      newAccountNumber
    }) => {
      return dispatch((0, _actions.showModal)({
        name: 'NEW_ACCOUNT',
        onCreateNewAccount,
        newAccountNumber
      }));
    },
    getRequestAccountTabIds: () => dispatch((0, _actions.getRequestAccountTabIds)())
  };
};
const PermissionApprovalContainer = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_permissionsConnect.default);
PermissionApprovalContainer.propTypes = {
  history: _propTypes.default.object.isRequired,
  match: _propTypes.default.shape({
    params: _propTypes.default.shape({
      id: _propTypes.default.string
    }).isRequired
  }).isRequired
};
var _default = exports.default = PermissionApprovalContainer;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\permissions-connect\\permissions-connect.container.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\redirect\\index.js", {"./permissions-redirect.component":"D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\redirect\\permissions-redirect.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cpermissions-connect%5Credirect%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _permissionsRedirect.default;
  }
});
var _permissionsRedirect = _interopRequireDefault(require("./permissions-redirect.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\permissions-connect\\redirect\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\redirect\\permissions-redirect.component.js", {"../../../components/app/permissions-connect-footer":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\permissions-connect-footer\\index.js","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cpermissions-connect%5Credirect%5Cpermissions-redirect.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = PermissionsRedirect;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _designSystem = require("../../../helpers/constants/design-system");
var _i18n = require("../../../contexts/i18n");
var _componentLibrary = require("../../../components/component-library");
var _permissionsConnectFooter = _interopRequireDefault(require("../../../components/app/permissions-connect-footer"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function PermissionsRedirect({
  subjectMetadata
}) {
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const [cachedSubjectMetadata, setCachedSubjectMetadata] = (0, _react.useState)(subjectMetadata);

  // While this redirecting screen is showing, the subject metadata will become invalidated
  // for that reason we cache the last seen valid subject metadata and show that.
  (0, _react.useEffect)(() => {
    if (subjectMetadata && subjectMetadata.origin) {
      setCachedSubjectMetadata(subjectMetadata);
    }
  }, [subjectMetadata]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    width: _designSystem.BlockSize.Full,
    height: _designSystem.BlockSize.Full,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    width: _designSystem.BlockSize.Full,
    height: _designSystem.BlockSize.Full,
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    borderRadius: _designSystem.BorderRadius.XS,
    border: `1px solid ${_designSystem.BorderColor.borderMuted}`,
    boxShadow: "var(--shadow-size-lg) var(--color-shadow-default)"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    marginBottom: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingMd
  }, t('connecting'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    backgroundColor: _designSystem.BackgroundColor.infoMuted,
    borderRadius: _designSystem.BorderRadius.pill,
    padding: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarToken, {
    src: cachedSubjectMetadata.iconUrl,
    name: cachedSubjectMetadata.name,
    size: _componentLibrary.AvatarTokenSize.Lg
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    paddingLeft: 4,
    paddingRight: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.Confirmation,
    size: _componentLibrary.IconSize.Xl,
    color: _designSystem.IconColor.infoDefault
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarToken, {
    src: "/images/logo/metamask-fox.svg",
    size: _componentLibrary.AvatarTokenSize.Lg,
    name: "metamask-fox"
  }))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    padding: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column
  }, /*#__PURE__*/_react.default.createElement(_permissionsConnectFooter.default, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    paddingTop: 4,
    width: _designSystem.BlockSize.Full,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    variant: _componentLibrary.ButtonVariant.Secondary,
    size: _componentLibrary.ButtonSize.Lg,
    width: _designSystem.BlockSize.Full,
    marginRight: 2,
    disabled: true
  }, t('back')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    variant: _componentLibrary.ButtonVariant.Primary,
    size: _componentLibrary.ButtonSize.Lg,
    width: _designSystem.BlockSize.Full,
    marginLeft: 2,
    disabled: true,
    loading: true
  })))));
}
PermissionsRedirect.propTypes = {
  subjectMetadata: _propTypes.default.shape({
    extensionId: _propTypes.default.string,
    iconUrl: _propTypes.default.string,
    subjectType: _propTypes.default.string,
    name: _propTypes.default.string.isRequired,
    origin: _propTypes.default.string.isRequired
  })
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\permissions-connect\\redirect\\permissions-redirect.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\snaps\\snap-install\\index.js", {"./snap-install":"D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\snaps\\snap-install\\snap-install.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cpermissions-connect%5Csnaps%5Csnap-install%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _snapInstall.default;
  }
});
var _snapInstall = _interopRequireDefault(require("./snap-install"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\permissions-connect\\snaps\\snap-install\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\snaps\\snap-install\\snap-install.js", {"../../../../components/app/permission-connect-header":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\permission-connect-header\\index.js","../../../../components/app/snaps/install-error/install-error":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\install-error\\install-error.js","../../../../components/app/snaps/snap-authorship-header":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-authorship-header\\index.js","../../../../components/app/snaps/snap-install-warning":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-install-warning\\index.js","../../../../components/app/snaps/snap-permissions-list":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-permissions-list\\index.js","../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../components/ui/page-container":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\page-container\\index.js","../../../../components/ui/pulse-loader/pulse-loader":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\pulse-loader\\pulse-loader.js","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../hooks/useOriginMetadata":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useOriginMetadata.js","../../../../hooks/useScrollRequired":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useScrollRequired.js","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../util":"D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\snaps\\util.js","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cpermissions-connect%5Csnaps%5Csnap-install%5Csnap-install.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = SnapInstall;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _snapsUtils = require("@metamask/snaps-utils");
var _pageContainer = require("../../../../components/ui/page-container");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _snapInstallWarning = _interopRequireDefault(require("../../../../components/app/snaps/snap-install-warning"));
var _designSystem = require("../../../../helpers/constants/design-system");
var _util = require("../util");
var _pulseLoader = _interopRequireDefault(require("../../../../components/ui/pulse-loader/pulse-loader"));
var _snapAuthorshipHeader = _interopRequireDefault(require("../../../../components/app/snaps/snap-authorship-header"));
var _componentLibrary = require("../../../../components/component-library");
var _snapPermissionsList = _interopRequireDefault(require("../../../../components/app/snaps/snap-permissions-list"));
var _useScrollRequired = require("../../../../hooks/useScrollRequired");
var _installError = _interopRequireDefault(require("../../../../components/app/snaps/install-error/install-error"));
var _useOriginMetadata = require("../../../../hooks/useOriginMetadata");
var _selectors = require("../../../../selectors");
var _util2 = require("../../../../helpers/utils/util");
var _permissionConnectHeader = _interopRequireDefault(require("../../../../components/app/permission-connect-header"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function SnapInstall({
  request,
  requestState,
  approveSnapInstall,
  rejectSnapInstall,
  targetSubjectMetadata
}) {
  var _request$metadata, _request$metadata2, _request$metadata3;
  const t = (0, _useI18nContext.useI18nContext)();
  const siteMetadata = (0, _useOriginMetadata.useOriginMetadata)(request === null || request === void 0 || (_request$metadata = request.metadata) === null || _request$metadata === void 0 ? void 0 : _request$metadata.dappOrigin) || {};
  const {
    origin,
    iconUrl
  } = siteMetadata;
  const [isShowingWarning, setIsShowingWarning] = (0, _react.useState)(false);
  const snapsMetadata = (0, _reactRedux.useSelector)(_selectors.getSnapsMetadata);
  const [showAllPermissions, setShowAllPermissions] = (0, _react.useState)(false);
  const {
    isScrollable,
    hasScrolledToBottom,
    scrollToBottom,
    ref,
    onScroll
  } = (0, _useScrollRequired.useScrollRequired)([requestState]);
  const onCancel = (0, _react.useCallback)(() => rejectSnapInstall(request.metadata.id), [request, rejectSnapInstall]);
  const onSubmit = (0, _react.useCallback)(() => approveSnapInstall(request.metadata.id), [request, approveSnapInstall]);
  const {
    name: snapName
  } = (0, _reactRedux.useSelector)(state => (0, _selectors.getSnapMetadata)(state, targetSubjectMetadata.origin));
  const hasError = !requestState.loading && requestState.error;
  const isLoading = requestState.loading;

  // we already have access to the requesting snap's metadata
  const isOriginSnap = (0, _snapsUtils.isSnapId)(request === null || request === void 0 || (_request$metadata2 = request.metadata) === null || _request$metadata2 === void 0 ? void 0 : _request$metadata2.dappOrigin);
  const warnings = (0, _util.getSnapInstallWarnings)((requestState === null || requestState === void 0 ? void 0 : requestState.permissions) ?? {}, t, snapName, (0, _util2.getSnapName)(snapsMetadata));
  const shouldShowWarning = warnings.length > 0;
  const handleSubmit = () => {
    if (!hasError && shouldShowWarning) {
      setIsShowingWarning(true);
    } else if (hasError) {
      onCancel();
    } else {
      onSubmit();
    }
  };
  const getFooterMessage = () => {
    if (hasError) {
      return 'ok';
    } else if (isLoading) {
      return 'connect';
    }
    return 'confirm';
  };
  const onShowAllPermissionsHandler = () => {
    setShowAllPermissions(true);
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "snap-install",
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    height: _designSystem.BlockSize.Full,
    borderStyle: _designSystem.BorderStyle.none,
    flexDirection: _designSystem.FlexDirection.Column,
    backgroundColor: _designSystem.BackgroundColor.backgroundAlternative
  }, (isLoading || hasError) && !isOriginSnap ? /*#__PURE__*/_react.default.createElement(_permissionConnectHeader.default, {
    origin: origin,
    iconUrl: iconUrl
  }) : /*#__PURE__*/_react.default.createElement(_snapAuthorshipHeader.default, {
    snapId: isLoading && isOriginSnap ? request === null || request === void 0 || (_request$metadata3 = request.metadata) === null || _request$metadata3 === void 0 ? void 0 : _request$metadata3.dappOrigin : targetSubjectMetadata.origin,
    onCancel: onCancel
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    ref: !isLoading && !hasError ? ref : undefined,
    onScroll: onScroll,
    className: "snap-install__content",
    style: {
      overflowY: 'auto',
      flex: !isLoading && !hasError && '1'
    },
    paddingLeft: 4,
    paddingRight: 4
  }, isLoading && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    className: "snap-install__content__loader-container",
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center
  }, /*#__PURE__*/_react.default.createElement(_pulseLoader.default, null)), hasError && /*#__PURE__*/_react.default.createElement(_installError.default, {
    iconName: _componentLibrary.IconName.Warning,
    title: t('connectionFailed'),
    description: t('connectionFailedDescription', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      as: "span",
      key: "1",
      fontWeight: _designSystem.FontWeight.Medium
    }, snapName)]),
    error: requestState.error
  }), !hasError && !isLoading && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingMd,
    paddingTop: 4,
    paddingBottom: 2,
    textAlign: "center"
  }, t('installRequest')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    className: "snap-install__content__permission-description",
    paddingBottom: 4,
    paddingLeft: 4,
    paddingRight: 4,
    textAlign: _designSystem.TextAlign.Center
  }, t('snapInstallRequest', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "span",
    key: "2",
    variant: _designSystem.TextVariant.bodyMd,
    fontWeight: _designSystem.FontWeight.Medium
  }, snapName)])), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    paddingLeft: 4,
    paddingRight: 4,
    paddingTop: 2,
    paddingBottom: 2,
    borderRadius: _designSystem.BorderRadius.XL
  }, /*#__PURE__*/_react.default.createElement(_snapPermissionsList.default, {
    snapId: targetSubjectMetadata.origin,
    snapName: snapName,
    permissions: requestState.permissions || {},
    connections: requestState.connections || {},
    onShowAllPermissions: onShowAllPermissionsHandler
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "snap-install__scroll-button-area"
  }, isScrollable && !hasScrolledToBottom && !showAllPermissions ? /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarIcon, {
    className: "snap-install__scroll-button",
    "data-testid": "snap-install-scroll",
    iconName: _componentLibrary.IconName.Arrow2Down,
    backgroundColor: _designSystem.BackgroundColor.infoDefault,
    color: _designSystem.IconColor.primaryInverse,
    onClick: scrollToBottom,
    style: {
      cursor: 'pointer'
    }
  }) : null))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "snap-install__footer",
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    flexDirection: _designSystem.FlexDirection.Column,
    backgroundColor: _designSystem.BackgroundColor.backgroundAlternative
  }, /*#__PURE__*/_react.default.createElement(_pageContainer.PageContainerFooter, {
    cancelButtonType: "default",
    hideCancel: hasError,
    disabled: isLoading || !hasError && isScrollable && !hasScrolledToBottom,
    onCancel: onCancel,
    cancelText: t('cancel'),
    onSubmit: handleSubmit,
    submitText: t(getFooterMessage())
  })), isShowingWarning && /*#__PURE__*/_react.default.createElement(_snapInstallWarning.default, {
    onCancel: () => setIsShowingWarning(false),
    onSubmit: onSubmit,
    warnings: warnings,
    snapName: snapName
  }));
}
SnapInstall.propTypes = {
  request: _propTypes.default.object.isRequired,
  requestState: _propTypes.default.object.isRequired,
  approveSnapInstall: _propTypes.default.func.isRequired,
  rejectSnapInstall: _propTypes.default.func.isRequired,
  targetSubjectMetadata: _propTypes.default.shape({
    iconUrl: _propTypes.default.string,
    name: _propTypes.default.string,
    origin: _propTypes.default.string.isRequired,
    sourceCode: _propTypes.default.string,
    version: _propTypes.default.string
  }).isRequired
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\permissions-connect\\snaps\\snap-install\\snap-install.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\snaps\\snap-result\\index.js", {"./snap-result":"D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\snaps\\snap-result\\snap-result.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cpermissions-connect%5Csnaps%5Csnap-result%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _snapResult.default;
  }
});
var _snapResult = _interopRequireDefault(require("./snap-result"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\permissions-connect\\snaps\\snap-result\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\snaps\\snap-result\\snap-result.js", {"../../../../components/app/snaps/install-error/install-error":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\install-error\\install-error.js","../../../../components/app/snaps/snap-authorship-header":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-authorship-header\\index.js","../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../components/ui/box/box":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\box\\box.js","../../../../components/ui/page-container":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\page-container\\index.js","../../../../components/ui/pulse-loader/pulse-loader":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\pulse-loader\\pulse-loader.js","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cpermissions-connect%5Csnaps%5Csnap-result%5Csnap-result.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = SnapResult;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _pageContainer = require("../../../../components/ui/page-container");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _box = _interopRequireDefault(require("../../../../components/ui/box/box"));
var _designSystem = require("../../../../helpers/constants/design-system");
var _componentLibrary = require("../../../../components/component-library");
var _pulseLoader = _interopRequireDefault(require("../../../../components/ui/pulse-loader/pulse-loader"));
var _installError = _interopRequireDefault(require("../../../../components/app/snaps/install-error/install-error"));
var _snapAuthorshipHeader = _interopRequireDefault(require("../../../../components/app/snaps/snap-authorship-header"));
var _selectors = require("../../../../selectors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function SnapResult({
  request,
  requestState,
  approveSnapResult,
  targetSubjectMetadata
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  const onSubmit = (0, _react.useCallback)(() => approveSnapResult(request.metadata.id), [request, approveSnapResult]);
  const hasError = !requestState.loading && requestState.error;
  const isLoading = requestState.loading;
  const {
    name: snapName
  } = (0, _reactRedux.useSelector)(state => (0, _selectors.getSnapMetadata)(state, targetSubjectMetadata.origin));
  function getSuccessScreen(requestType, snapNameToRender) {
    let successScreenTitle;
    switch (requestType) {
      case 'wallet_installSnap':
        successScreenTitle = t('snapInstallSuccess');
        break;
      case 'wallet_updateSnap':
        successScreenTitle = t('snapUpdateSuccess');
        break;
      default:
        successScreenTitle = t('snapResultSuccess');
    }
    return /*#__PURE__*/_react.default.createElement(_box.default, {
      flexDirection: _designSystem.FlexDirection.Column,
      alignItems: _designSystem.AlignItems.center,
      justifyContent: _designSystem.JustifyContent.center,
      height: _designSystem.BlockSize.Full,
      paddingTop: 2,
      paddingBottom: 2,
      backgroundColor: _designSystem.BackgroundColor.backgroundAlternative
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarIcon, {
      className: "snap-result__header__icon",
      iconName: _componentLibrary.IconName.Confirmation,
      size: _componentLibrary.AvatarIconSize.Xl,
      color: _designSystem.IconColor.successDefault,
      backgroundColor: _designSystem.BackgroundColor.successMuted
    }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      fontWeight: _designSystem.FontWeight.Bold,
      textAlign: _designSystem.TextAlign.Center,
      variant: _designSystem.TextVariant.headingLg,
      paddingBottom: 2,
      marginTop: 4
    }, successScreenTitle), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      textAlign: _designSystem.TextAlign.Center
    }, t('snapResultSuccessDescription', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      as: "span",
      key: "1",
      fontWeight: _designSystem.FontWeight.Medium
    }, snapNameToRender)])));
  }
  function getFailedScreen(requestType, snapNameToRender) {
    let failedScreenTitle;
    let failedScreenDescription;
    switch (requestType) {
      case 'wallet_installSnap':
        failedScreenTitle = t('snapInstallationErrorTitle');
        failedScreenDescription = t('snapInstallationErrorDescription', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
          as: "span",
          key: "1",
          fontWeight: _designSystem.FontWeight.Medium
        }, snapNameToRender)]);
        break;
      case 'wallet_updateSnap':
        failedScreenTitle = t('snapUpdateErrorTitle');
        failedScreenDescription = t('snapUpdateErrorDescription', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
          as: "span",
          key: "1",
          fontWeight: _designSystem.FontWeight.Medium
        }, snapNameToRender)]);
        break;
      default:
        failedScreenTitle = t('snapResultError');
    }
    return /*#__PURE__*/_react.default.createElement(_installError.default, {
      error: requestState.error,
      title: failedScreenTitle,
      description: failedScreenDescription,
      iconName: _componentLibrary.IconName.Warning
    });
  }
  return /*#__PURE__*/_react.default.createElement(_box.default, {
    className: "page-container snap-result",
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    height: _designSystem.BlockSize.Full,
    borderStyle: _designSystem.BorderStyle.none,
    flexDirection: _designSystem.FlexDirection.Column,
    backgroundColor: _designSystem.BackgroundColor.backgroundAlternative
  }, /*#__PURE__*/_react.default.createElement(_snapAuthorshipHeader.default, {
    snapId: targetSubjectMetadata.origin,
    onCancel: onSubmit
  }), /*#__PURE__*/_react.default.createElement(_box.default, {
    className: "snap-result__content",
    paddingLeft: 4,
    paddingRight: 4,
    alignItems: _designSystem.AlignItems.center,
    flexDirection: _designSystem.FlexDirection.Column,
    backgroundColor: _designSystem.BackgroundColor.backgroundAlternative,
    height: _designSystem.BlockSize.Full,
    justifyContent: _designSystem.JustifyContent.center
  }, isLoading && /*#__PURE__*/_react.default.createElement(_box.default, {
    className: "snap-result__content__loader-container",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    height: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_pulseLoader.default, null)), !isLoading && !hasError && getSuccessScreen(requestState.type, snapName), hasError && getFailedScreen(requestState.type, snapName)), /*#__PURE__*/_react.default.createElement(_box.default, {
    className: "snap-result__footer",
    alignItems: _designSystem.AlignItems.center,
    flexDirection: _designSystem.FlexDirection.Column,
    backgroundColor: _designSystem.BackgroundColor.backgroundAlternative
  }, /*#__PURE__*/_react.default.createElement(_pageContainer.PageContainerFooter, {
    hideCancel: true,
    disabled: isLoading,
    onSubmit: onSubmit,
    submitText: t('ok').toUpperCase()
  })));
}
SnapResult.propTypes = {
  request: _propTypes.default.object.isRequired,
  requestState: _propTypes.default.object.isRequired,
  approveSnapResult: _propTypes.default.func.isRequired,
  targetSubjectMetadata: _propTypes.default.shape({
    iconUrl: _propTypes.default.string,
    name: _propTypes.default.string,
    origin: _propTypes.default.string.isRequired,
    sourceCode: _propTypes.default.string,
    version: _propTypes.default.string
  }).isRequired
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\permissions-connect\\snaps\\snap-result\\snap-result.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\snaps\\snap-update\\index.js", {"./snap-update":"D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\snaps\\snap-update\\snap-update.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cpermissions-connect%5Csnaps%5Csnap-update%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _snapUpdate.default;
  }
});
var _snapUpdate = _interopRequireDefault(require("./snap-update"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\permissions-connect\\snaps\\snap-update\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\snaps\\snap-update\\snap-update.js", {"../../../../components/app/snaps/install-error/install-error":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\install-error\\install-error.js","../../../../components/app/snaps/snap-authorship-header":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-authorship-header\\index.js","../../../../components/app/snaps/snap-install-warning":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-install-warning\\index.js","../../../../components/app/snaps/update-snap-permission-list":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\update-snap-permission-list\\index.js","../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../components/ui/page-container":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\page-container\\index.js","../../../../components/ui/pulse-loader/pulse-loader":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\pulse-loader\\pulse-loader.js","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../hooks/useScrollRequired":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useScrollRequired.js","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../util":"D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\snaps\\util.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cpermissions-connect%5Csnaps%5Csnap-update%5Csnap-update.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = SnapUpdate;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _pageContainer = require("../../../../components/ui/page-container");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _snapInstallWarning = _interopRequireDefault(require("../../../../components/app/snaps/snap-install-warning"));
var _designSystem = require("../../../../helpers/constants/design-system");
var _updateSnapPermissionList = _interopRequireDefault(require("../../../../components/app/snaps/update-snap-permission-list"));
var _util = require("../util");
var _pulseLoader = _interopRequireDefault(require("../../../../components/ui/pulse-loader/pulse-loader"));
var _installError = _interopRequireDefault(require("../../../../components/app/snaps/install-error/install-error"));
var _snapAuthorshipHeader = _interopRequireDefault(require("../../../../components/app/snaps/snap-authorship-header"));
var _componentLibrary = require("../../../../components/component-library");
var _useScrollRequired = require("../../../../hooks/useScrollRequired");
var _selectors = require("../../../../selectors");
var _util2 = require("../../../../helpers/utils/util");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function SnapUpdate({
  request,
  requestState,
  approveSnapUpdate,
  rejectSnapUpdate,
  targetSubjectMetadata
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  const [isShowingWarning, setIsShowingWarning] = (0, _react.useState)(false);
  const [showAllPermissions, setShowAllPermissions] = (0, _react.useState)(false);
  const {
    isScrollable,
    hasScrolledToBottom,
    scrollToBottom,
    ref,
    onScroll
  } = (0, _useScrollRequired.useScrollRequired)([requestState]);
  const snapsMetadata = (0, _reactRedux.useSelector)(_selectors.getSnapsMetadata);
  const onCancel = (0, _react.useCallback)(() => rejectSnapUpdate(request.metadata.id), [request, rejectSnapUpdate]);
  const onSubmit = (0, _react.useCallback)(() => approveSnapUpdate(request.metadata.id), [request, approveSnapUpdate]);
  const {
    name: snapName
  } = (0, _reactRedux.useSelector)(state => (0, _selectors.getSnapMetadata)(state, targetSubjectMetadata.origin));
  const approvedPermissions = requestState.approvedPermissions ?? {};
  const revokedPermissions = requestState.unusedPermissions ?? {};
  const newPermissions = requestState.newPermissions ?? {};
  const approvedConnections = requestState.approvedConnections ?? {};
  const revokedConnections = requestState.unusedConnections ?? {};
  const newConnections = requestState.newConnections ?? {};
  const {
    newVersion
  } = requestState;
  const isLoading = requestState.loading;
  const hasError = !isLoading && requestState.error;
  const warnings = (0, _util.getSnapInstallWarnings)(newPermissions, t, snapName, (0, _util2.getSnapName)(snapsMetadata));
  const shouldShowWarning = warnings.length > 0;
  const handleSubmit = () => {
    if (!hasError && shouldShowWarning) {
      setIsShowingWarning(true);
    } else if (hasError) {
      onCancel();
    } else {
      onSubmit();
    }
  };
  const onShowAllPermissions = () => {
    setShowAllPermissions(true);
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "snap-update",
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    height: _designSystem.BlockSize.Full,
    borderStyle: _designSystem.BorderStyle.none,
    flexDirection: _designSystem.FlexDirection.Column,
    backgroundColor: _designSystem.BackgroundColor.backgroundAlternative
  }, /*#__PURE__*/_react.default.createElement(_snapAuthorshipHeader.default, {
    snapId: targetSubjectMetadata.origin,
    onCancel: onCancel
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    ref: ref,
    onScroll: onScroll,
    className: "snap-update__content",
    style: {
      overflowY: 'auto',
      flex: !isLoading && '1'
    },
    paddingLeft: 4,
    paddingRight: 4
  }, !isLoading && !hasError && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    paddingTop: 4,
    paddingBottom: 2,
    variant: _designSystem.TextVariant.headingMd,
    textAlign: "center"
  }, t('updateRequest')), isLoading && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "snap-update__content__loader-container",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center
  }, /*#__PURE__*/_react.default.createElement(_pulseLoader.default, null)), hasError && /*#__PURE__*/_react.default.createElement(_installError.default, {
    iconName: _componentLibrary.IconName.Warning,
    error: requestState.error,
    title: t('snapUpdateErrorTitle'),
    description: t('snapUpdateErrorDescription', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      as: "span",
      key: "1",
      fontWeight: _designSystem.FontWeight.Medium
    }, snapName)])
  }), !hasError && !isLoading && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    className: "snap-update__content__permission-description",
    paddingBottom: 4,
    paddingLeft: 4,
    paddingRight: 4,
    textAlign: _designSystem.TextAlign.Center
  }, t('snapUpdateRequest', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "span",
    key: "2",
    variant: _designSystem.TextVariant.bodyMd,
    fontWeight: _designSystem.FontWeight.Medium
  }, snapName), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "span",
    key: "3",
    variant: _designSystem.TextVariant.bodyMd,
    fontWeight: _designSystem.FontWeight.Medium
  }, newVersion)])), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    paddingLeft: 4,
    paddingRight: 4,
    paddingTop: 2,
    paddingBottom: 2,
    borderRadius: _designSystem.BorderRadius.XL
  }, /*#__PURE__*/_react.default.createElement(_updateSnapPermissionList.default, {
    approvedPermissions: approvedPermissions,
    revokedPermissions: revokedPermissions,
    newPermissions: newPermissions,
    approvedConnections: approvedConnections,
    revokedConnections: revokedConnections,
    newConnections: newConnections,
    targetSubjectMetadata: targetSubjectMetadata,
    showAllPermissions: onShowAllPermissions
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "snap-update__scroll-button-area"
  }, isScrollable && !hasScrolledToBottom && !showAllPermissions ? /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarIcon, {
    className: "snap-install__scroll-button",
    "data-testid": "snap-update-scroll",
    iconName: _componentLibrary.IconName.Arrow2Down,
    backgroundColor: _designSystem.BackgroundColor.infoDefault,
    color: _designSystem.IconColor.primaryInverse,
    onClick: scrollToBottom,
    style: {
      cursor: 'pointer'
    }
  }) : null))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "snap-update__footer",
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    flexDirection: _designSystem.FlexDirection.Column,
    backgroundColor: _designSystem.BackgroundColor.backgroundAlternative
  }, /*#__PURE__*/_react.default.createElement(_pageContainer.PageContainerFooter, {
    cancelButtonType: "default",
    hideCancel: hasError,
    disabled: isLoading || !hasError && isScrollable && !hasScrolledToBottom,
    onCancel: onCancel,
    cancelText: t('cancel'),
    onSubmit: handleSubmit,
    submitText: t(hasError ? 'ok' : 'confirm')
  })), isShowingWarning && /*#__PURE__*/_react.default.createElement(_snapInstallWarning.default, {
    onCancel: () => setIsShowingWarning(false),
    onSubmit: onSubmit,
    snapName: snapName,
    warnings: warnings
  }));
}
SnapUpdate.propTypes = {
  request: _propTypes.default.object.isRequired,
  requestState: _propTypes.default.object.isRequired,
  approveSnapUpdate: _propTypes.default.func.isRequired,
  rejectSnapUpdate: _propTypes.default.func.isRequired,
  targetSubjectMetadata: _propTypes.default.shape({
    iconUrl: _propTypes.default.string,
    name: _propTypes.default.string,
    origin: _propTypes.default.string.isRequired,
    sourceCode: _propTypes.default.string,
    version: _propTypes.default.string
  }).isRequired
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\permissions-connect\\snaps\\snap-update\\snap-update.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\snaps\\snaps-connect\\index.js", {"./snaps-connect":"D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\snaps\\snaps-connect\\snaps-connect.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cpermissions-connect%5Csnaps%5Csnaps-connect%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _snapsConnect.default;
  }
});
var _snapsConnect = _interopRequireDefault(require("./snaps-connect"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\permissions-connect\\snaps\\snaps-connect\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\snaps\\snaps-connect\\snaps-connect.js", {"../../../../components/app/snaps/snap-connect-cell/snap-connect-cell":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-connect-cell\\snap-connect-cell.js","../../../../components/app/snaps/snap-icon":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-icon\\index.ts","../../../../components/app/snaps/snap-privacy-warning/snap-privacy-warning":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-privacy-warning\\snap-privacy-warning.js","../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../components/ui/page-container":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\page-container\\index.js","../../../../components/ui/pulse-loader/pulse-loader":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\pulse-loader\\pulse-loader.js","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../hooks/useOriginMetadata":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useOriginMetadata.js","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cpermissions-connect%5Csnaps%5Csnaps-connect%5Csnaps-connect.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = SnapsConnect;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _snapsUtils = require("@metamask/snaps-utils");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _componentLibrary = require("../../../../components/component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _pageContainer = require("../../../../components/ui/page-container");
var _snapConnectCell = _interopRequireDefault(require("../../../../components/app/snaps/snap-connect-cell/snap-connect-cell"));
var _util = require("../../../../helpers/utils/util");
var _pulseLoader = _interopRequireDefault(require("../../../../components/ui/pulse-loader/pulse-loader"));
var _snapPrivacyWarning = _interopRequireDefault(require("../../../../components/app/snaps/snap-privacy-warning/snap-privacy-warning"));
var _selectors = require("../../../../selectors");
var _useOriginMetadata = require("../../../../hooks/useOriginMetadata");
var _snapIcon = require("../../../../components/app/snaps/snap-icon");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SnapsConnect({
  request,
  approveConnection,
  rejectConnection,
  targetSubjectMetadata,
  snapsInstallPrivacyWarningShown,
  setSnapsInstallPrivacyWarningShownStatus
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    origin
  } = targetSubjectMetadata;
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const currentPermissions = (0, _reactRedux.useSelector)(state => {
    var _request$metadata;
    return (0, _selectors.getPermissions)(state, request === null || request === void 0 || (_request$metadata = request.metadata) === null || _request$metadata === void 0 ? void 0 : _request$metadata.origin);
  });
  const preinstalledSnaps = (0, _reactRedux.useSelector)(_selectors.getPreinstalledSnaps);
  const snaps = (0, _util.getDedupedSnaps)(request, currentPermissions);
  const snapId = snaps[0];
  const {
    name: snapName
  } = (0, _reactRedux.useSelector)(state => (0, _selectors.getSnapMetadata)(state, snapId));
  const isPreinstalled = Object.keys(preinstalledSnaps).includes(snapId);
  const [isShowingSnapsPrivacyWarning, setIsShowingSnapsPrivacyWarning] = (0, _react.useState)(!isPreinstalled && !snapsInstallPrivacyWarningShown);
  const onCancel = (0, _react.useCallback)(() => {
    rejectConnection(request.metadata.id);
  }, [request, rejectConnection]);
  const onConnect = (0, _react.useCallback)(() => {
    try {
      setIsLoading(true);
      approveConnection(request);
    } finally {
      setIsLoading(false);
    }
  }, [request, approveConnection]);
  const SnapsConnectContent = () => {
    var _ref;
    let trimmedOrigin = (_ref = (0, _useOriginMetadata.useOriginMetadata)(origin) || {}) === null || _ref === void 0 ? void 0 : _ref.hostname;
    const {
      name
    } = (0, _reactRedux.useSelector)(state =>
    // hack around the selector throwing
    (0, _selectors.getSnapMetadata)(state, (0, _snapsUtils.isSnapId)(origin) ? origin : `npm:${origin}`));
    if ((0, _snapsUtils.isSnapId)(origin)) {
      trimmedOrigin = name;
    }
    if (isLoading) {
      return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        display: _designSystem.Display.Flex,
        flexDirection: _designSystem.FlexDirection.Column,
        alignItems: _designSystem.AlignItems.center,
        justifyContent: _designSystem.JustifyContent.center,
        width: _designSystem.BlockSize.Full,
        height: _designSystem.BlockSize.Full
      }, /*#__PURE__*/_react.default.createElement(_pulseLoader.default, null));
    }
    if ((snaps === null || snaps === void 0 ? void 0 : snaps.length) > 1) {
      return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        flexDirection: _designSystem.FlexDirection.Column,
        justifyContent: _designSystem.JustifyContent.center,
        alignItems: _designSystem.AlignItems.center,
        paddingTop: 4,
        width: _designSystem.BlockSize.Full,
        style: {
          overflowY: 'hidden'
        },
        backgroundColor: _designSystem.BackgroundColor.backgroundAlternative
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        paddingBottom: 2,
        variant: _designSystem.TextVariant.headingMd,
        textAlign: _designSystem.TextAlign.Center
      }, t('connectionRequest')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        variant: _designSystem.TextVariant.bodyMd,
        textAlign: _designSystem.TextAlign.Center
      }, t('multipleSnapConnectionWarning', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        as: "span",
        key: "1",
        variant: _designSystem.TextVariant.bodyMd,
        fontWeight: _designSystem.FontWeight.Medium
      }, trimmedOrigin), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        as: "span",
        key: "2",
        variant: _designSystem.TextVariant.bodyMd,
        fontWeight: _designSystem.FontWeight.Medium
      }, snaps === null || snaps === void 0 ? void 0 : snaps.length)])), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        flexDirection: _designSystem.FlexDirection.Column,
        display: _designSystem.Display.Flex,
        marginTop: 4,
        width: _designSystem.BlockSize.Full,
        style: {
          overflowY: 'auto',
          flex: 1
        }
      }, snaps.map(snap =>
      /*#__PURE__*/
      // TODO(hbmalik88): add in the iconUrl prop when we have access to a snap's icons pre-installation
      _react.default.createElement(_snapConnectCell.default, {
        key: `snaps-connect-${snap}`,
        snapId: snap,
        origin: trimmedOrigin
      }))));
    } else if ((snaps === null || snaps === void 0 ? void 0 : snaps.length) === 1) {
      return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        display: _designSystem.Display.Flex,
        flexDirection: _designSystem.FlexDirection.Column,
        justifyContent: _designSystem.JustifyContent.center,
        alignItems: _designSystem.AlignItems.center,
        width: _designSystem.BlockSize.Full,
        height: _designSystem.BlockSize.Full,
        paddingLeft: 4,
        paddingRight: 4,
        backgroundColor: _designSystem.BackgroundColor.backgroundAlternative
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        paddingBottom: 2
      }, /*#__PURE__*/_react.default.createElement(_snapIcon.SnapIcon, {
        snapId: snaps[0],
        avatarSize: _componentLibrary.IconSize.Xl
      })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        paddingBottom: 2,
        variant: _designSystem.TextVariant.headingMd,
        textAlign: "center"
      }, t('connectionRequest')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        variant: _designSystem.TextVariant.bodyMd,
        textAlign: _designSystem.TextAlign.Center,
        padding: [0, 4],
        overflowWrap: _designSystem.OverflowWrap.Anywhere
      }, t('snapConnectionWarning', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        as: "span",
        key: "1",
        variant: _designSystem.TextVariant.bodyMd,
        fontWeight: _designSystem.FontWeight.Medium
      }, trimmedOrigin), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        as: "span",
        key: "2",
        variant: _designSystem.TextVariant.bodyMd,
        fontWeight: _designSystem.FontWeight.Medium
      }, snapName)])));
    }
    return null;
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "snaps-connect",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.center,
    height: _designSystem.BlockSize.Full,
    width: _designSystem.BlockSize.Full,
    backgroundColor: _designSystem.BackgroundColor.backgroundAlternative
  }, isShowingSnapsPrivacyWarning && /*#__PURE__*/_react.default.createElement(_snapPrivacyWarning.default, {
    onAccepted: () => {
      setIsShowingSnapsPrivacyWarning(false);
      setSnapsInstallPrivacyWarningShownStatus(true);
    },
    onCanceled: onCancel
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    height: _designSystem.BlockSize.Full,
    width: _designSystem.BlockSize.Full,
    paddingLeft: 4,
    paddingRight: 4
  }, /*#__PURE__*/_react.default.createElement(SnapsConnectContent, null)), /*#__PURE__*/_react.default.createElement(_pageContainer.PageContainerFooter, {
    cancelButtonType: "default",
    hideCancel: false,
    disabled: isLoading,
    onCancel: onCancel,
    cancelText: t('cancel'),
    onSubmit: onConnect,
    submitText: t('connect')
  }));
}
SnapsConnect.propTypes = {
  request: _propTypes.default.object.isRequired,
  approveConnection: _propTypes.default.func.isRequired,
  rejectConnection: _propTypes.default.func.isRequired,
  targetSubjectMetadata: _propTypes.default.shape({
    extensionId: _propTypes.default.string,
    iconUrl: _propTypes.default.string,
    name: _propTypes.default.string,
    origin: _propTypes.default.string,
    subjectType: _propTypes.default.string
  }),
  snapsInstallPrivacyWarningShown: _propTypes.default.bool.isRequired,
  setSnapsInstallPrivacyWarningShownStatus: _propTypes.default.func
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\permissions-connect\\snaps\\snaps-connect\\snaps-connect.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\snaps\\util.js", {"../../../helpers/utils/permission":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\permission.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cpermissions-connect%5Csnaps%5Cutil.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSnapInstallWarnings = getSnapInstallWarnings;
var _permission = require("../../../helpers/utils/permission");
function getSnapInstallWarnings(permissions, t, snapName, getSnapName) {
  const weightOneWarnings = Object.entries(permissions).reduce((filteredWarnings, [permissionName, permissionValue]) => {
    const permissionDescription = (0, _permission.getPermissionDescription)({
      t,
      permissionName,
      permissionValue,
      subjectName: snapName,
      getSubjectName: getSnapName
    });
    return filteredWarnings.concat(permissionDescription.filter(description => description.weight <= 2));
  }, []);
  return weightOneWarnings;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\permissions-connect\\snaps\\util.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\remove-snap-account\\index.ts", {"./remove-snap-account":"D:\\code\\v\\metamask-extension\\ui\\pages\\remove-snap-account\\remove-snap-account.tsx","./snap-account-card":"D:\\code\\v\\metamask-extension\\ui\\pages\\remove-snap-account\\snap-account-card.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cremove-snap-account%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  RemoveSnapAccount: true
};
Object.defineProperty(exports, "RemoveSnapAccount", {
  enumerable: true,
  get: function () {
    return _removeSnapAccount.default;
  }
});
var _removeSnapAccount = _interopRequireDefault(require("./remove-snap-account"));
var _snapAccountCard = require("./snap-account-card");
Object.keys(_snapAccountCard).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _snapAccountCard[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _snapAccountCard[key];
    }
  });
});
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\remove-snap-account\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\remove-snap-account\\remove-snap-account.tsx", {"../../components/app/snaps/snap-authorship-header":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-authorship-header\\index.js","../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","./snap-account-card":"D:\\code\\v\\metamask-extension\\ui\\pages\\remove-snap-account\\snap-account-card.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cremove-snap-account%5Cremove-snap-account.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../components/component-library");
var _designSystem = require("../../helpers/constants/design-system");
var _useI18nContext = require("../../hooks/useI18nContext");
var _snapAuthorshipHeader = _interopRequireDefault(require("../../components/app/snaps/snap-authorship-header"));
var _snapAccountCard = require("./snap-account-card");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const RemoveSnapAccount = ({
  snapId,
  publicAddress,
  onCancel
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "remove-snap-account-page",
    height: _designSystem.BlockSize.Full,
    width: _designSystem.BlockSize.Full,
    display: _designSystem.Display.Flex,
    borderStyle: _designSystem.BorderStyle.none,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.center,
    marginBottom: 0
  }, /*#__PURE__*/_react.default.createElement(_snapAuthorshipHeader.default, {
    snapId: snapId,
    onCancel: onCancel
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    padding: 4,
    width: _designSystem.BlockSize.Full,
    style: {
      flexGrow: 1
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.center,
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingBottom: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarIcon, {
    iconName: _componentLibrary.IconName.UserCircleRemove,
    color: _designSystem.IconColor.errorDefault,
    backgroundColor: _designSystem.BackgroundColor.errorMuted,
    size: _componentLibrary.AvatarIconSize.Xl
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    textAlign: _designSystem.TextAlign.Center,
    variant: _designSystem.TextVariant.headingLg,
    paddingBottom: 2
  }, t('removeSnapAccountTitle')), /*#__PURE__*/_react.default.createElement(_snapAccountCard.SnapAccountCard, {
    address: publicAddress,
    remove: true
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    textAlign: _designSystem.TextAlign.Center,
    overflowWrap: _designSystem.OverflowWrap.Anywhere
  }, t('removeSnapAccountDescription'))))));
};
var _default = exports.default = RemoveSnapAccount;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\remove-snap-account\\remove-snap-account.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\remove-snap-account\\snap-account-card.tsx", {"../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../components/multichain/account-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-list-item\\index.js","../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cremove-snap-account%5Csnap-account-card.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapAccountCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _selectors = require("../../selectors");
var _designSystem = require("../../helpers/constants/design-system");
var _componentLibrary = require("../../components/component-library");
var _accountListItem = require("../../components/multichain/account-list-item");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// Wrapper component of AccountListItem with proper styling and auto populating information for the selected account
const SnapAccountCard = ({
  address,
  remove
}) => {
  const accounts = (0, _reactRedux.useSelector)(_selectors.getMetaMaskAccountsOrdered);
  const account = accounts.find(internalAccount => internalAccount.address === address);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: remove ? 'snap-account-card-remove' : 'snap-account-card',
    borderRadius: _designSystem.BorderRadius.LG,
    marginTop: 4,
    marginBottom: 4,
    width: _designSystem.BlockSize.Full,
    style: {
      boxShadow: 'var(--shadow-size-lg) var(--color-shadow-default)'
    }
  }, /*#__PURE__*/_react.default.createElement(_accountListItem.AccountListItem, {
    account: account,
    selected: remove || false
  }));
};
exports.SnapAccountCard = SnapAccountCard;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\remove-snap-account\\snap-account-card.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\routes\\index.js", {"./routes.component":"D:\\code\\v\\metamask-extension\\ui\\pages\\routes\\routes.component.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Croutes%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _routes.default;
  }
});
var _routes = _interopRequireDefault(require("./routes.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\routes\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\routes\\routes.component.tsx", {"../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../shared/constants/preferences":"D:\\code\\v\\metamask-extension\\shared\\constants\\preferences.ts","../../../shared/lib/confirmation.utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\confirmation.utils.ts","../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../components/app/alerts":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\alerts\\index.js","../../components/app/assets/nfts/nft-default-image/toggle-ipfs-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\nfts\\nft-default-image\\toggle-ipfs-modal.js","../../components/app/assets/nfts/nft-details/nft-full-image.tsx":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\nfts\\nft-details\\nft-full-image.tsx","../../components/app/basic-configuration-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\basic-configuration-modal\\index.ts","../../components/app/modals":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\index.js","../../components/app/modals/keyring-snap-removal-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\keyring-snap-removal-modal\\index.ts","../../components/app/modals/multichain-accounts/intro-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\multichain-accounts\\intro-modal\\index.ts","../../components/app/qr-hardware-popover":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\qr-hardware-popover\\index.js","../../components/app/toast-master/toast-master":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\toast-master\\toast-master.js","../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../components/multichain":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../components/multichain-accounts/multichain-account-list-menu":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-account-list-menu\\index.ts","../../components/multichain-accounts/permissions/permission-review-page/multichain-review-permissions-page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\permissions\\permission-review-page\\multichain-review-permissions-page.tsx","../../components/multichain-accounts/state2-wrapper/state2-wrapper.tsx":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\state2-wrapper\\state2-wrapper.tsx","../../components/multichain/app-header/multichain-meta-fox-logo":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\app-header\\multichain-meta-fox-logo.js","../../components/multichain/network-list-menu/network-confirmation-popover/network-confirmation-popover":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-menu\\network-confirmation-popover\\network-confirmation-popover.tsx","../../components/multichain/pages/connections/index.js":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\connections\\index.js","../../components/multichain/pages/gator-permissions/gator-permissions-page.tsx":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\gator-permissions\\gator-permissions-page.tsx","../../components/multichain/pages/gator-permissions/review-permissions/review-gator-permissions-page.tsx":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\gator-permissions\\review-permissions\\review-gator-permissions-page.tsx","../../components/multichain/pages/gator-permissions/token-transfer/token-transfer-page.tsx":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\gator-permissions\\token-transfer\\token-transfer-page.tsx","../../components/multichain/pages/permissions-page/permissions-page.js":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\permissions-page\\permissions-page.js","../../components/multichain/pages/review-permissions-page/review-permissions-page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\review-permissions-page\\review-permissions-page.tsx","../../components/ui/alert":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\alert\\index.js","../../components/ui/deprecated-networks/deprecated-networks":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\deprecated-networks\\deprecated-networks.js","../../components/ui/loading-screen":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\loading-screen\\index.js","../../ducks/history/history":"D:\\code\\v\\metamask-extension\\ui\\ducks\\history\\history.js","../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../helpers/higher-order-components/authenticated":"D:\\code\\v\\metamask-extension\\ui\\helpers\\higher-order-components\\authenticated\\index.js","../../helpers/higher-order-components/initialized":"D:\\code\\v\\metamask-extension\\ui\\helpers\\higher-order-components\\initialized\\index.js","../../helpers/utils/mm-lazy":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\mm-lazy.ts","../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../hooks/useMultichainAccountsIntroModal":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainAccountsIntroModal.ts","../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../selectors/multi-srp/multi-srp":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multi-srp\\multi-srp.ts","../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../store/store":"D:\\code\\v\\metamask-extension\\ui\\store\\store.ts","../asset/index.js":"D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\index.js","../bridge/index.tsx":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\index.tsx","../bridge/transaction-details/transaction-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\transaction-details\\transaction-details.tsx","../confirm-add-suggested-nft/index.js":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirm-add-suggested-nft\\index.js","../confirm-add-suggested-token/index.js":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirm-add-suggested-token\\index.js","../confirmations/components/confirm/smart-account-update":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\smart-account-update\\index.ts","../confirmations/confirm-transaction/index.js":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirm-transaction\\index.js","../confirmations/confirmation/index.js":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\index.js","../confirmations/send/index.ts":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\send\\index.ts","../create-account/create-account.component.js":"D:\\code\\v\\metamask-extension\\ui\\pages\\create-account\\create-account.component.js","../deep-link/deep-link.tsx":"D:\\code\\v\\metamask-extension\\ui\\pages\\deep-link\\deep-link.tsx","../defi/index.ts":"D:\\code\\v\\metamask-extension\\ui\\pages\\defi\\index.ts","../home/index.js":"D:\\code\\v\\metamask-extension\\ui\\pages\\home\\index.js","../keychains/restore-vault.js":"D:\\code\\v\\metamask-extension\\ui\\pages\\keychains\\restore-vault.js","../keychains/reveal-seed.js":"D:\\code\\v\\metamask-extension\\ui\\pages\\keychains\\reveal-seed.js","../lock/index.js":"D:\\code\\v\\metamask-extension\\ui\\pages\\lock\\index.js","../multi-srp/import-srp/index.ts":"D:\\code\\v\\metamask-extension\\ui\\pages\\multi-srp\\import-srp\\index.ts","../multichain-accounts/account-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\account-details\\index.ts","../multichain-accounts/account-list":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\account-list\\index.ts","../multichain-accounts/add-wallet-page":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\add-wallet-page\\index.ts","../multichain-accounts/address-qr-code":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\address-qr-code\\index.ts","../multichain-accounts/multichain-account-address-list-page":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\multichain-account-address-list-page\\index.ts","../multichain-accounts/multichain-account-details-page/index.ts":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\multichain-account-details-page\\index.ts","../multichain-accounts/multichain-account-private-key-list-page":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\multichain-account-private-key-list-page\\index.ts","../multichain-accounts/smart-account-page/index.ts":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\smart-account-page\\index.ts","../multichain-accounts/wallet-details-page":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\wallet-details-page\\index.ts","../multichain-accounts/wallet-details/index.ts":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\wallet-details\\index.ts","../nonevm-balance-check/index.tsx":"D:\\code\\v\\metamask-extension\\ui\\pages\\nonevm-balance-check\\index.tsx","../notification-details/index.js":"D:\\code\\v\\metamask-extension\\ui\\pages\\notification-details\\index.js","../notifications-settings/index.js":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications-settings\\index.js","../notifications/index.js":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\index.js","../onboarding-flow/onboarding-flow.js":"D:\\code\\v\\metamask-extension\\ui\\pages\\onboarding-flow\\onboarding-flow.js","../permissions-connect":"D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\index.js","../settings/deprecated-network-modal/DeprecatedNetworkModal":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\deprecated-network-modal\\DeprecatedNetworkModal.tsx","../settings/index.js":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\index.js","../shield-plan/index.ts":"D:\\code\\v\\metamask-extension\\ui\\pages\\shield-plan\\index.ts","../snaps/snap-view/index.js":"D:\\code\\v\\metamask-extension\\ui\\pages\\snaps\\snap-view\\index.js","../snaps/snaps-list/index.js":"D:\\code\\v\\metamask-extension\\ui\\pages\\snaps\\snaps-list\\index.js","../swaps/index.js":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\index.js","../unlock-page/index.js":"D:\\code\\v\\metamask-extension\\ui\\pages\\unlock-page\\index.js","./utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\routes\\utils.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-idle-timer":"D:\\code\\v\\metamask-extension\\node_modules\\react-idle-timer\\dist\\index.min.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Croutes%5Croutes.component.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Routes;
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _reactIdleTimer = _interopRequireDefault(require("react-idle-timer"));
var _store = require("../../store/store");
var _authenticated = _interopRequireDefault(require("../../helpers/higher-order-components/authenticated"));
var _initialized = _interopRequireDefault(require("../../helpers/higher-order-components/initialized"));
var _permissionsConnect = _interopRequireDefault(require("../permissions-connect"));
var _loadingScreen = _interopRequireDefault(require("../../components/ui/loading-screen"));
var _modals = require("../../components/app/modals");
var _alert = _interopRequireDefault(require("../../components/ui/alert"));
var _multichain = require("../../components/multichain");
var _alerts = _interopRequireDefault(require("../../components/app/alerts"));
var _routes = require("../../helpers/constants/routes");
var _networks = require("../../../shared/modules/selectors/networks");
var _selectors = require("../../selectors");
var _actions = require("../../store/actions");
var _history = require("../../ducks/history/history");
var _metamask = require("../../ducks/metamask/metamask");
var _useI18nContext = require("../../hooks/useI18nContext");
var _preferences = require("../../../shared/constants/preferences");
var _multiSrp = require("../../selectors/multi-srp/multi-srp");
var _app = require("../../../shared/constants/app");
var _util = require("../../../app/scripts/lib/util");
var _qrHardwarePopover = _interopRequireDefault(require("../../components/app/qr-hardware-popover"));
var _deprecatedNetworks = _interopRequireDefault(require("../../components/ui/deprecated-networks/deprecated-networks"));
var _componentLibrary = require("../../components/component-library");
var _toggleIpfsModal = require("../../components/app/assets/nfts/nft-default-image/toggle-ipfs-modal");
var _basicConfigurationModal = require("../../components/app/basic-configuration-modal");
var _keyringSnapRemovalModal = _interopRequireDefault(require("../../components/app/modals/keyring-snap-removal-modal"));
var _multichainAccountListMenu = require("../../components/multichain-accounts/multichain-account-list-menu");
var _DeprecatedNetworkModal = require("../settings/deprecated-network-modal/DeprecatedNetworkModal");
var _multichainMetaFoxLogo = require("../../components/multichain/app-header/multichain-meta-fox-logo");
var _networkConfirmationPopover = _interopRequireDefault(require("../../components/multichain/network-list-menu/network-confirmation-popover/network-confirmation-popover"));
var _toastMaster = require("../../components/app/toast-master/toast-master");
var _mmLazy = require("../../helpers/utils/mm-lazy");
var _transactionDetails = _interopRequireDefault(require("../bridge/transaction-details/transaction-details"));
var _confirmation = require("../../../shared/lib/confirmation.utils");
var _smartAccountUpdate = require("../confirmations/components/confirm/smart-account-update");
var _accountDetails = require("../multichain-accounts/account-details");
var _addressQrCode = require("../multichain-accounts/address-qr-code");
var _multichainAccountAddressListPage = require("../multichain-accounts/multichain-account-address-list-page");
var _multichainAccountPrivateKeyListPage = require("../multichain-accounts/multichain-account-private-key-list-page");
var _introModal = _interopRequireDefault(require("../../components/app/modals/multichain-accounts/intro-modal"));
var _useMultichainAccountsIntroModal = require("../../hooks/useMultichainAccountsIntroModal");
var _accountList = require("../multichain-accounts/account-list");
var _addWalletPage = require("../multichain-accounts/add-wallet-page");
var _walletDetailsPage = require("../multichain-accounts/wallet-details-page");
var _reviewPermissionsPage = require("../../components/multichain/pages/review-permissions-page/review-permissions-page");
var _multichainReviewPermissionsPage = require("../../components/multichain-accounts/permissions/permission-review-page/multichain-review-permissions-page");
var _utils = require("./utils");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /* eslint-disable jsdoc/check-tag-names */ /* eslint-disable import/no-useless-path-segments */ /* eslint-disable import/extensions */ // TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths
///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
///: END:ONLY_INCLUDE_IF
// TODO: Fix `as unknown as` casting once `mmLazy` is updated to handle named exports, wrapped components, and other React module types.
// Casting is preferable over `@ts-expect-error` annotations in this case,
// because it doesn't suppress competing error messages e.g. "Cannot find module..."

// Begin Lazy Routes
const OnboardingFlow = (0, _mmLazy.mmLazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../onboarding-flow/onboarding-flow.js'))));
const Lock = (0, _mmLazy.mmLazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../lock/index.js'))));
const UnlockPage = (0, _mmLazy.mmLazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../unlock-page/index.js'))));
const RestoreVaultPage = (0, _mmLazy.mmLazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../keychains/restore-vault.js'))));
const ImportSrpPage = (0, _mmLazy.mmLazy)(
// TODO: This is a named export. Fix incorrect type casting once `mmLazy` is updated to handle non-default export types.
() => Promise.resolve().then(() => _interopRequireWildcard(require('../multi-srp/import-srp/index.ts'))));
const RevealSeedConfirmation = (0, _mmLazy.mmLazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../keychains/reveal-seed.js'))));
const Settings = (0, _mmLazy.mmLazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../settings/index.js'))));
const NotificationsSettings = (0, _mmLazy.mmLazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../notifications-settings/index.js'))));
const NotificationDetails = (0, _mmLazy.mmLazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../notification-details/index.js'))));
const Notifications = (0, _mmLazy.mmLazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../notifications/index.js'))));
const SnapList = (0, _mmLazy.mmLazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../snaps/snaps-list/index.js'))));
const SnapView = (0, _mmLazy.mmLazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../snaps/snap-view/index.js'))));
const ConfirmTransaction = (0, _mmLazy.mmLazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../confirmations/confirm-transaction/index.js'))));
const SendPage = (0, _mmLazy.mmLazy)(
// TODO: This is a named export. Fix incorrect type casting once `mmLazy` is updated to handle non-default export types.
() => Promise.resolve().then(() => _interopRequireWildcard(require('../confirmations/send/index.ts'))));
const Swaps = (0, _mmLazy.mmLazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../swaps/index.js'))));
const CrossChainSwap = (0, _mmLazy.mmLazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../bridge/index.tsx'))));
const ConfirmAddSuggestedTokenPage = (0, _mmLazy.mmLazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../confirm-add-suggested-token/index.js'))));
const ConfirmAddSuggestedNftPage = (0, _mmLazy.mmLazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../confirm-add-suggested-nft/index.js'))));
const ConfirmationPage = (0, _mmLazy.mmLazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../confirmations/confirmation/index.js'))));
const CreateAccountPage = (0, _mmLazy.mmLazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../create-account/create-account.component.js'))));
const NftFullImage = (0, _mmLazy.mmLazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../../components/app/assets/nfts/nft-details/nft-full-image.tsx'))));
const Asset = (0, _mmLazy.mmLazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../asset/index.js'))));
const DeFiPage = (0, _mmLazy.mmLazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../defi/index.ts'))));
const PermissionsPage = (0, _mmLazy.mmLazy)(
// TODO: This is a named export. Fix incorrect type casting once `mmLazy` is updated to handle non-default export types.
() => Promise.resolve().then(() => _interopRequireWildcard(require('../../components/multichain/pages/permissions-page/permissions-page.js'))));
const GatorPermissionsPage = (0, _mmLazy.mmLazy)(
// TODO: This is a named export. Fix incorrect type casting once `mmLazy` is updated to handle non-default export types.
() => Promise.resolve().then(() => _interopRequireWildcard(require('../../components/multichain/pages/gator-permissions/gator-permissions-page.tsx'))));
const TokenTransferPage = (0, _mmLazy.mmLazy)(
// TODO: This is a named export. Fix incorrect type casting once `mmLazy` is updated to handle non-default export types.
() => Promise.resolve().then(() => _interopRequireWildcard(require('../../components/multichain/pages/gator-permissions/token-transfer/token-transfer-page.tsx'))));
const ReviewGatorPermissionsPage = (0, _mmLazy.mmLazy)(
// TODO: This is a named export. Fix incorrect type casting once `mmLazy` is updated to handle non-default export types.
() => Promise.resolve().then(() => _interopRequireWildcard(require('../../components/multichain/pages/gator-permissions/review-permissions/review-gator-permissions-page.tsx'))));
const Connections = (0, _mmLazy.mmLazy)(
// TODO: This is a named export. Fix incorrect type casting once `mmLazy` is updated to handle non-default export types.
() => Promise.resolve().then(() => _interopRequireWildcard(require('../../components/multichain/pages/connections/index.js'))));
const State2Wrapper = (0, _mmLazy.mmLazy)(
// TODO: This is a named export. Fix incorrect type casting once `mmLazy` is updated to handle non-default export types.
() => Promise.resolve().then(() => _interopRequireWildcard(require('../../components/multichain-accounts/state2-wrapper/state2-wrapper.tsx'))));
const Home = (0, _mmLazy.mmLazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../home/index.js'))));
const DeepLink = (0, _mmLazy.mmLazy)(
// TODO: This is a named export. Fix incorrect type casting once `mmLazy` is updated to handle non-default export types.
() => Promise.resolve().then(() => _interopRequireWildcard(require('../deep-link/deep-link.tsx'))));
const WalletDetails = (0, _mmLazy.mmLazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../multichain-accounts/wallet-details/index.ts'))));
const MultichainAccountDetailsPage = (0, _mmLazy.mmLazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../multichain-accounts/multichain-account-details-page/index.ts'))));
const SmartAccountPage = (0, _mmLazy.mmLazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../multichain-accounts/smart-account-page/index.ts'))));
const NonEvmBalanceCheck = (0, _mmLazy.mmLazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../nonevm-balance-check/index.tsx'))));
const ShieldPlan = (0, _mmLazy.mmLazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../shield-plan/index.ts'))));
// End Lazy Routes

const MemoizedReviewPermissionsWrapper = /*#__PURE__*/_react.default.memo(props => /*#__PURE__*/_react.default.createElement(State2Wrapper, _extends({}, props, {
  state1Component: _reviewPermissionsPage.ReviewPermissions,
  state2Component: _multichainReviewPermissionsPage.MultichainReviewPermissions
})));

// eslint-disable-next-line @typescript-eslint/naming-convention
function Routes() {
  var _transactionsMetadata;
  const dispatch = (0, _reactRedux.useDispatch)();
  const history = (0, _reactRouterDom.useHistory)();
  const location = (0, _reactRouterDom.useLocation)();
  const alertOpen = (0, _store.useAppSelector)(state => state.appState.alertOpen);
  const alertMessage = (0, _store.useAppSelector)(state => state.appState.alertMessage);
  const isLoading = (0, _store.useAppSelector)(state => state.appState.isLoading);
  const loadingMessage = (0, _store.useAppSelector)(state => state.appState.loadingMessage);
  const {
    autoLockTimeLimit = _preferences.DEFAULT_AUTO_LOCK_TIME_LIMIT,
    privacyMode
  } = (0, _store.useAppSelector)(_selectors.getPreferences);
  const completedOnboarding = (0, _store.useAppSelector)(_metamask.getCompletedOnboarding);

  // If there is more than one connected account to activeTabOrigin,
  // *BUT* the current account is not one of them, show the banner
  const account = (0, _store.useAppSelector)(_selectors.getSelectedInternalAccount);
  const networkToAutomaticallySwitchTo = (0, _store.useAppSelector)(_selectors.getNetworkToAutomaticallySwitchTo);
  const oldestPendingApproval = (0, _store.useAppSelector)(_selectors.oldestPendingConfirmationSelector);
  const pendingApprovals = (0, _store.useAppSelector)(_selectors.getPendingApprovals);
  const transactionsMetadata = (0, _store.useAppSelector)(_selectors.getUnapprovedTransactions);
  const shouldShowSeedPhraseReminder = (0, _store.useAppSelector)(state => (0, _multiSrp.getShouldShowSeedPhraseReminder)(state, account));
  const textDirection = (0, _store.useAppSelector)(state => state.metamask.textDirection);
  const isUnlocked = (0, _store.useAppSelector)(_metamask.getIsUnlocked);
  const currentCurrency = (0, _store.useAppSelector)(state => state.metamask.currentCurrency);
  const os = (0, _store.useAppSelector)(state => {
    var _state$metamask$brows;
    return (_state$metamask$brows = state.metamask.browserEnvironment) === null || _state$metamask$brows === void 0 ? void 0 : _state$metamask$brows.os;
  });
  const browser = (0, _store.useAppSelector)(state => {
    var _state$metamask$brows2;
    return (_state$metamask$brows2 = state.metamask.browserEnvironment) === null || _state$metamask$brows2 === void 0 ? void 0 : _state$metamask$brows2.browser;
  });
  const providerId = (0, _store.useAppSelector)(_selectors.getNetworkIdentifier);
  const {
    type: providerType
  } = (0, _store.useAppSelector)(_networks.getProviderConfig);
  const theme = (0, _store.useAppSelector)(_selectors.getTheme);
  const showExtensionInFullSizeView = (0, _store.useAppSelector)(_selectors.getShowExtensionInFullSizeView);
  const forgottenPassword = (0, _store.useAppSelector)(state => state.metamask.forgottenPassword);
  const isAccountMenuOpen = (0, _store.useAppSelector)(state => state.appState.isAccountMenuOpen);
  const isNetworkMenuOpen = (0, _store.useAppSelector)(state => state.appState.isNetworkMenuOpen);
  const isImportTokensModalOpen = (0, _store.useAppSelector)(state => state.appState.importTokensModalOpen);
  const isBasicConfigurationModalOpen = (0, _store.useAppSelector)(state => state.appState.showBasicFunctionalityModal);
  const isDeprecatedNetworkModalOpen = (0, _store.useAppSelector)(state => state.appState.deprecatedNetworkModalOpen);
  const accountDetailsAddress = (0, _store.useAppSelector)(state => state.appState.accountDetailsAddress);
  const isImportNftsModalOpen = (0, _store.useAppSelector)(state => state.appState.importNftsModal.open);
  const isIpfsModalOpen = (0, _store.useAppSelector)(state => state.appState.showIpfsModalOpen);
  const totalUnapprovedConfirmationCount = (0, _store.useAppSelector)(_selectors.getNumberOfAllUnapprovedTransactionsAndMessages);
  const currentExtensionPopupId = (0, _store.useAppSelector)(state => state.metamask.currentExtensionPopupId);

  ///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
  const isShowKeyringSnapRemovalResultModal = (0, _store.useAppSelector)(state => state.appState.showKeyringRemovalSnapModal);
  const pendingConfirmations = (0, _store.useAppSelector)(_selectors.getUnapprovedConfirmations);
  const hideShowKeyringSnapRemovalResultModal = () => dispatch((0, _actions.hideKeyringRemovalResultModal)());
  ///: END:ONLY_INCLUDE_IF

  const isMultichainAccountsState1Enabled = (0, _store.useAppSelector)(_selectors.getIsMultichainAccountsState1Enabled);

  // Multichain intro modal logic (extracted to custom hook)
  const {
    showMultichainIntroModal,
    setShowMultichainIntroModal
  } = (0, _useMultichainAccountsIntroModal.useMultichainAccountsIntroModal)(isUnlocked, location);
  const prevPropsRef = (0, _react.useRef)({
    isUnlocked,
    totalUnapprovedConfirmationCount
  });
  (0, _react.useEffect)(() => {
    const prevProps = prevPropsRef.current;

    // Automatically switch the network if the user
    // no longer has unapproved transactions and they
    // should be on a different network for the
    // currently active tab's dapp
    if (networkToAutomaticallySwitchTo && totalUnapprovedConfirmationCount === 0 && (prevProps.totalUnapprovedConfirmationCount > 0 || prevProps.isUnlocked === false && isUnlocked)) {
      dispatch((0, _actions.automaticallySwitchNetwork)(networkToAutomaticallySwitchTo));
    }
    prevPropsRef.current = {
      isUnlocked,
      totalUnapprovedConfirmationCount
    };
  }, [networkToAutomaticallySwitchTo, isUnlocked, totalUnapprovedConfirmationCount, dispatch]);
  (0, _react.useEffect)(() => {
    // Terminate the popup when another popup is opened
    // if the user is using RPC queueing
    if (currentExtensionPopupId !== undefined && 'metamask' in global && typeof global.metamask === 'object' && global.metamask && 'id' in global.metamask && global.metamask.id !== undefined && currentExtensionPopupId !== global.metamask.id) {
      window.close();
    }
  }, [currentExtensionPopupId]);
  (0, _react.useEffect)(() => {
    const windowType = (0, _util.getEnvironmentType)();
    if (showExtensionInFullSizeView && windowType === _app.ENVIRONMENT_TYPE_POPUP) {
      var _global$platform, _global$platform$open;
      (_global$platform = global.platform) === null || _global$platform === void 0 || (_global$platform$open = _global$platform.openExtensionInBrowser) === null || _global$platform$open === void 0 || _global$platform$open.call(_global$platform);
    }
  }, [showExtensionInFullSizeView]);
  (0, _react.useEffect)(() => {
    const unlisten = history.listen((locationObj, action) => {
      if (action === 'PUSH') {
        dispatch((0, _history.pageChanged)(locationObj.pathname));
      }
    });
    return () => {
      unlisten();
    };
  }, [history, dispatch]);
  (0, _react.useEffect)(() => {
    (0, _utils.setTheme)(theme);
  }, [theme]);
  (0, _react.useEffect)(() => {
    if (!currentCurrency) {
      dispatch((0, _actions.setCurrentCurrency)('usd'));
    }
  }, [currentCurrency, dispatch]);
  const renderRoutes = (0, _react.useCallback)(() => {
    const RestoreVaultComponent = forgottenPassword ? _reactRouterDom.Route : _initialized.default;
    const routes = /*#__PURE__*/_react.default.createElement(_react.Suspense, {
      fallback: null
    }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Route, {
      path: _routes.ONBOARDING_ROUTE,
      component: OnboardingFlow
    }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Route, {
      path: _routes.LOCK_ROUTE,
      component: Lock,
      exact: true
    }), /*#__PURE__*/_react.default.createElement(_initialized.default, {
      path: _routes.UNLOCK_ROUTE,
      component: UnlockPage,
      exact: true
    }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Route, {
      path: _routes.DEEP_LINK_ROUTE,
      component: DeepLink
    }), /*#__PURE__*/_react.default.createElement(RestoreVaultComponent, {
      path: _routes.RESTORE_VAULT_ROUTE,
      component: RestoreVaultPage,
      exact: true
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: _routes.SMART_ACCOUNT_UPDATE,
      component: _smartAccountUpdate.SmartAccountUpdate
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default
    // `:keyringId` is optional here, if not provided, this will fallback
    // to the main seed phrase.
    , {
      path: `${_routes.REVEAL_SEED_ROUTE}/:keyringId?`,
      component: RevealSeedConfirmation
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: _routes.IMPORT_SRP_ROUTE,
      component: ImportSrpPage
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: _routes.SETTINGS_ROUTE,
      component: Settings
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: _routes.NOTIFICATIONS_SETTINGS_ROUTE,
      component: NotificationsSettings
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: `${_routes.NOTIFICATIONS_ROUTE}/:uuid`,
      component: NotificationDetails
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: _routes.NOTIFICATIONS_ROUTE,
      component: Notifications
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: _routes.SNAPS_ROUTE,
      component: SnapList,
      exact: true
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: _routes.SNAPS_VIEW_ROUTE,
      component: SnapView
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: `${_routes.CONFIRM_TRANSACTION_ROUTE}/:id?`,
      component: ConfirmTransaction
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: `${_routes.SEND_ROUTE}/:page?`,
      component: SendPage
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: _routes.SWAPS_ROUTE,
      component: Swaps
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: `${_routes.CROSS_CHAIN_SWAP_TX_DETAILS_ROUTE}/:srcTxMetaId`,
      component: _transactionDetails.default,
      exact: true
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: _routes.CROSS_CHAIN_SWAP_ROUTE,
      component: CrossChainSwap
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: _routes.CONFIRM_ADD_SUGGESTED_TOKEN_ROUTE,
      component: ConfirmAddSuggestedTokenPage,
      exact: true
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: _routes.CONFIRM_ADD_SUGGESTED_NFT_ROUTE,
      component: ConfirmAddSuggestedNftPage,
      exact: true
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: `${_routes.CONFIRMATION_V_NEXT_ROUTE}/:id?`,
      component: ConfirmationPage
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: _routes.NEW_ACCOUNT_ROUTE,
      component: CreateAccountPage
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: `${_routes.CONNECT_ROUTE}/:id`,
      component: _permissionsConnect.default
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: `${_routes.ASSET_ROUTE}/image/:asset/:id`,
      component: NftFullImage
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: `${_routes.ASSET_ROUTE}/:chainId/:asset/:id`,
      component: Asset
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: `${_routes.ASSET_ROUTE}/:chainId/:asset/`,
      component: Asset
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: `${_routes.ASSET_ROUTE}/:chainId`,
      component: Asset
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: `${_routes.DEFI_ROUTE}/:chainId/:protocolId`,
      component: DeFiPage
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: `${_routes.CONNECTIONS}/:origin`,
      component: Connections
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: _routes.PERMISSIONS,
      component: PermissionsPage,
      exact: true
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: _routes.GATOR_PERMISSIONS,
      component: GatorPermissionsPage,
      exact: true
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: _routes.TOKEN_TRANSFER_ROUTE,
      component: TokenTransferPage,
      exact: true
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: `${_routes.REVIEW_GATOR_PERMISSIONS_ROUTE}/:chainId/:permissionGroupName`,
      component: ReviewGatorPermissionsPage,
      exact: true
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: `${_routes.REVIEW_PERMISSIONS}/:origin`,
      component: MemoizedReviewPermissionsWrapper,
      exact: true
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: _routes.ACCOUNT_LIST_PAGE_ROUTE,
      component: _accountList.AccountList,
      exact: true
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: `${_routes.MULTICHAIN_ACCOUNT_ADDRESS_LIST_PAGE_ROUTE}/:accountGroupId`,
      component: _multichainAccountAddressListPage.MultichainAccountAddressListPage,
      exact: true
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: `${_routes.MULTICHAIN_ACCOUNT_PRIVATE_KEY_LIST_PAGE_ROUTE}/:accountGroupId`,
      component: _multichainAccountPrivateKeyListPage.MultichainAccountPrivateKeyListPage,
      exact: true
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: _routes.ADD_WALLET_PAGE_ROUTE,
      component: _addWalletPage.AddWalletPage,
      exact: true
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: `${_routes.MULTICHAIN_ACCOUNT_DETAILS_PAGE_ROUTE}/:id`,
      component: MultichainAccountDetailsPage,
      exact: true
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: `${_routes.MULTICHAIN_SMART_ACCOUNT_PAGE_ROUTE}/:address`,
      component: SmartAccountPage,
      exact: true
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: `${_routes.MULTICHAIN_WALLET_DETAILS_PAGE_ROUTE}/:id`,
      component: _walletDetailsPage.WalletDetailsPage,
      exact: true
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: _routes.WALLET_DETAILS_ROUTE,
      component: WalletDetails,
      exact: true
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: `${_routes.ACCOUNT_DETAILS_ROUTE}/:address`,
      component: _accountDetails.MultichainAccountDetails,
      exact: true
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: `${_routes.ACCOUNT_DETAILS_QR_CODE_ROUTE}/:address`,
      component: _addressQrCode.AddressQRCode,
      exact: true
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: _routes.NONEVM_BALANCE_CHECK_ROUTE,
      component: NonEvmBalanceCheck
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: _routes.SHIELD_PLAN_ROUTE,
      component: ShieldPlan
    }), /*#__PURE__*/_react.default.createElement(_authenticated.default, {
      path: _routes.DEFAULT_ROUTE,
      component: Home
    })));
    if (autoLockTimeLimit > 0) {
      return /*#__PURE__*/_react.default.createElement(_reactIdleTimer.default, {
        onAction: () => dispatch((0, _actions.setLastActiveTime)()),
        throttle: 1000
      }, routes);
    }
    return routes;
  }, [autoLockTimeLimit, forgottenPassword, dispatch]);
  const t = (0, _useI18nContext.useI18nContext)();
  const renderAccountDetails = () => {
    if (!accountDetailsAddress || isMultichainAccountsState1Enabled) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_multichain.AccountDetails, {
      address: accountDetailsAddress
    });
  };
  const loadMessage = loadingMessage ? (0, _utils.getConnectingLabel)(loadingMessage, {
    providerType,
    providerId
  }, {
    t
  }) : null;
  const windowType = (0, _util.getEnvironmentType)();
  const shouldShowNetworkDeprecationWarning = windowType !== _app.ENVIRONMENT_TYPE_NOTIFICATION && isUnlocked && !shouldShowSeedPhraseReminder;
  const paramsConfirmationId = location.pathname.split('/confirm-transaction/')[1];
  const confirmationId = paramsConfirmationId ?? (oldestPendingApproval === null || oldestPendingApproval === void 0 ? void 0 : oldestPendingApproval.id);
  const pendingApproval = pendingApprovals.find(approval => approval.id === confirmationId);
  const isCorrectApprovalType = (0, _confirmation.isCorrectSignatureApprovalType)(pendingApproval === null || pendingApproval === void 0 ? void 0 : pendingApproval.type);
  const isCorrectTransactionType = (0, _confirmation.isCorrectDeveloperTransactionType)((_transactionsMetadata = transactionsMetadata[confirmationId]) === null || _transactionsMetadata === void 0 ? void 0 : _transactionsMetadata.type);
  const isShowingDeepLinkRoute = location.pathname === _routes.DEEP_LINK_ROUTE;
  const isLoadingShown = isLoading && completedOnboarding &&
  ///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
  !pendingConfirmations.some(confirmation => confirmation.type === _app.SNAP_MANAGE_ACCOUNTS_CONFIRMATION_TYPES.showSnapAccountRedirect) &&
  ///: END:ONLY_INCLUDE_IF
  // In the redesigned screens, we hide the general loading spinner and the
  // loading states are on a component by component basis.
  !isCorrectApprovalType && !isCorrectTransactionType &&
  // We don't want to show the loading screen on the deep link route, as it
  // is already a fullscreen interface.
  !isShowingDeepLinkRoute;
  const accountListMenu = isMultichainAccountsState1Enabled ? /*#__PURE__*/_react.default.createElement(_multichainAccountListMenu.MultichainAccountListMenu, {
    onClose: () => dispatch((0, _actions.toggleAccountMenu)()),
    privacyMode: privacyMode
  }) : /*#__PURE__*/_react.default.createElement(_multichain.AccountListMenu, {
    onClose: () => dispatch((0, _actions.toggleAccountMenu)()),
    privacyMode: privacyMode
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('app', {
      [`os-${os}`]: Boolean(os),
      [`browser-${browser}`]: Boolean(browser)
    }),
    dir: textDirection
  }, shouldShowNetworkDeprecationWarning ? /*#__PURE__*/_react.default.createElement(_deprecatedNetworks.default, null) : null, /*#__PURE__*/_react.default.createElement(_qrHardwarePopover.default, null), /*#__PURE__*/_react.default.createElement(_modals.Modal, null), /*#__PURE__*/_react.default.createElement(_alert.default, {
    visible: alertOpen,
    msg: alertMessage
  }), true ? (0, _utils.showAppHeader)({
    location
  }) && /*#__PURE__*/_react.default.createElement(_multichain.AppHeader, {
    location: location
  }) : !(0, _utils.hideAppHeader)({
    location
  }) && /*#__PURE__*/_react.default.createElement(_multichain.AppHeader, {
    location: location
  }), (0, _utils.isConfirmTransactionRoute)(location.pathname) && /*#__PURE__*/_react.default.createElement(_multichainMetaFoxLogo.MultichainMetaFoxLogo, null), isAccountMenuOpen ? accountListMenu : null, isNetworkMenuOpen ? /*#__PURE__*/_react.default.createElement(_multichain.NetworkListMenu, {
    onClose: () => {
      dispatch((0, _actions.toggleNetworkMenu)());
      dispatch((0, _actions.setEditedNetwork)());
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_networkConfirmationPopover.default, null), renderAccountDetails(), isImportNftsModalOpen ? /*#__PURE__*/_react.default.createElement(_multichain.ImportNftsModal, {
    onClose: () => dispatch((0, _actions.hideImportNftsModal)())
  }) : null, isIpfsModalOpen ? /*#__PURE__*/_react.default.createElement(_toggleIpfsModal.ToggleIpfsModal, {
    onClose: () => dispatch((0, _actions.hideIpfsModal)())
  }) : null, isBasicConfigurationModalOpen ? /*#__PURE__*/_react.default.createElement(_basicConfigurationModal.BasicConfigurationModal, null) : null, isImportTokensModalOpen ? /*#__PURE__*/_react.default.createElement(_multichain.ImportTokensModal, {
    onClose: () => dispatch((0, _actions.hideImportTokensModal)())
  }) : null, isDeprecatedNetworkModalOpen ? /*#__PURE__*/_react.default.createElement(_DeprecatedNetworkModal.DeprecatedNetworkModal, {
    onClose: () => dispatch((0, _actions.hideDeprecatedNetworkModal)())
  }) : null,
  ///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
  isShowKeyringSnapRemovalResultModal && /*#__PURE__*/_react.default.createElement(_keyringSnapRemovalModal.default, {
    isOpen: isShowKeyringSnapRemovalResultModal,
    onClose: hideShowKeyringSnapRemovalResultModal
  })
  ///: END:ONLY_INCLUDE_IF
  , showMultichainIntroModal ? /*#__PURE__*/_react.default.createElement(_introModal.default, {
    onClose: () => setShowMultichainIntroModal(false)
  }) : null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "main-container-wrapper"
  }, isLoadingShown ? /*#__PURE__*/_react.default.createElement(_loadingScreen.default, {
    loadingMessage: loadMessage
  }) : null, renderRoutes()), isUnlocked ? /*#__PURE__*/_react.default.createElement(_alerts.default, {
    history: history
  }) : null, /*#__PURE__*/_react.default.createElement(_toastMaster.ToastMaster, null));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\routes\\routes.component.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\routes\\utils.js", {"../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../shared/constants/preferences":"D:\\code\\v\\metamask-extension\\shared\\constants\\preferences.ts","../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Croutes%5Cutils.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectingLabel = getConnectingLabel;
exports.hideAppHeader = hideAppHeader;
exports.isConfirmTransactionRoute = isConfirmTransactionRoute;
exports.setTheme = setTheme;
exports.showAppHeader = showAppHeader;
var _reactRouterDom = require("react-router-dom");
var _util = require("../../../app/scripts/lib/util");
var _app = require("../../../shared/constants/app");
var _network = require("../../../shared/constants/network");
var _preferences = require("../../../shared/constants/preferences");
var _routes = require("../../helpers/constants/routes");
// eslint-disable-next-line import/no-restricted-paths

function isConfirmTransactionRoute(pathname) {
  return Boolean((0, _reactRouterDom.matchPath)(pathname, {
    path: _routes.CONFIRM_TRANSACTION_ROUTE,
    exact: false
  }));
}
function getThemeFromRawTheme(theme) {
  if (theme === _preferences.ThemeType.os) {
    var _window;
    if ((_window = window) !== null && _window !== void 0 && (_window = _window.matchMedia('(prefers-color-scheme: dark)')) !== null && _window !== void 0 && _window.matches) {
      return _preferences.ThemeType.dark;
    }
    return _preferences.ThemeType.light;
  }
  return theme;
}
function setTheme(theme) {
  document.documentElement.setAttribute('data-theme', getThemeFromRawTheme(theme));
}
function onConfirmPage(props) {
  const {
    location
  } = props;
  return Boolean((0, _reactRouterDom.matchPath)(location.pathname, {
    path: _routes.CONFIRM_TRANSACTION_ROUTE,
    exact: false
  }));
}
function getConnectingLabel(loadingMessage, props, context) {
  if (loadingMessage) {
    return loadingMessage;
  }
  const {
    providerType,
    providerId
  } = props;
  const {
    t
  } = context;
  switch (providerType) {
    case _network.NETWORK_TYPES.MAINNET:
      return t('connectingToMainnet');
    case _network.NETWORK_TYPES.GOERLI:
      return t('connectingToGoerli');
    case _network.NETWORK_TYPES.SEPOLIA:
      return t('connectingToSepolia');
    case _network.NETWORK_TYPES.LINEA_GOERLI:
      return t('connectingToLineaGoerli');
    case _network.NETWORK_TYPES.LINEA_SEPOLIA:
      return t('connectingToLineaSepolia');
    case _network.NETWORK_TYPES.LINEA_MAINNET:
      return t('connectingToLineaMainnet');
    default:
      return t('connectingTo', [providerId]);
  }
}
function hideAppHeader(props) {
  const {
    location
  } = props;
  const isNotificationsPage = Boolean((0, _reactRouterDom.matchPath)(location.pathname, {
    path: `${_routes.NOTIFICATIONS_ROUTE}`,
    exact: false
  }));
  if (isNotificationsPage) {
    return true;
  }
  const isDeepLinksPage = Boolean((0, _reactRouterDom.matchPath)(location.pathname, {
    path: _routes.DEEP_LINK_ROUTE,
    exact: false
  }));
  if (isDeepLinksPage) {
    return true;
  }
  const isInitializing = Boolean((0, _reactRouterDom.matchPath)(location.pathname, {
    path: _routes.ONBOARDING_ROUTE,
    exact: false
  }));
  if (isInitializing) {
    return true;
  }
  const windowType = (0, _util.getEnvironmentType)();
  if (windowType === _app.ENVIRONMENT_TYPE_NOTIFICATION) {
    return true;
  }
  const isPermissionsPage = Boolean((0, _reactRouterDom.matchPath)(location.pathname, {
    path: _routes.PERMISSIONS,
    exact: false
  }));
  if (isPermissionsPage) {
    return true;
  }
  const isConnectionsPage = Boolean((0, _reactRouterDom.matchPath)(location.pathname, {
    path: _routes.CONNECTIONS,
    exact: false
  }));
  if (isConnectionsPage) {
    return true;
  }
  const isReviewPermissionsPgae = Boolean((0, _reactRouterDom.matchPath)(location.pathname, {
    path: _routes.REVIEW_PERMISSIONS,
    exact: false
  }));
  if (isReviewPermissionsPgae) {
    return true;
  }
  if (windowType === _app.ENVIRONMENT_TYPE_POPUP && onConfirmPage(props)) {
    return true;
  }
  const isHandlingPermissionsRequest = Boolean((0, _reactRouterDom.matchPath)(location.pathname, {
    path: _routes.CONNECT_ROUTE,
    exact: false
  }));
  const isMultichainSend = Boolean((0, _reactRouterDom.matchPath)(location.pathname, {
    path: _routes.SEND_ROUTE,
    exact: false
  }));
  if (isMultichainSend) {
    return true;
  }
  const isStateTwoMultichainAccountDetailsPage = Boolean((0, _reactRouterDom.matchPath)(location.pathname, {
    path: _routes.MULTICHAIN_ACCOUNT_DETAILS_PAGE_ROUTE,
    exact: false
  }));
  if (isStateTwoMultichainAccountDetailsPage) {
    return true;
  }
  const isStateTwoMultichainWalletDetailsPage = Boolean((0, _reactRouterDom.matchPath)(location.pathname, {
    path: _routes.MULTICHAIN_WALLET_DETAILS_PAGE_ROUTE,
    exact: false
  }));
  if (isStateTwoMultichainWalletDetailsPage) {
    return true;
  }
  const isWalletDetailsPage = Boolean((0, _reactRouterDom.matchPath)(location.pathname, {
    path: _routes.WALLET_DETAILS_ROUTE,
    exact: false
  }));
  if (isWalletDetailsPage) {
    return true;
  }
  const isSnapsHome = Boolean((0, _reactRouterDom.matchPath)(location.pathname, {
    path: _routes.SNAPS_VIEW_ROUTE,
    exact: false
  }));
  if (isSnapsHome) {
    return true;
  }
  const isCrossChainSwapsPage = Boolean((0, _reactRouterDom.matchPath)(location.pathname, {
    path: `${_routes.CROSS_CHAIN_SWAP_ROUTE}`,
    exact: false
  }));
  if (isCrossChainSwapsPage) {
    return true;
  }
  const isAssetsPage = Boolean((0, _reactRouterDom.matchPath)(location.pathname, {
    path: _routes.ASSET_ROUTE,
    exact: false
  }));
  if (isAssetsPage) {
    return true;
  }
  const isMultichainAccountDetailsPage = Boolean((0, _reactRouterDom.matchPath)(location.pathname, {
    path: _routes.ACCOUNT_DETAILS_ROUTE,
    exact: false
  }));
  if (isMultichainAccountDetailsPage) {
    return true;
  }
  const isMultichainAccountDetailsQRCodePage = Boolean((0, _reactRouterDom.matchPath)(location.pathname, {
    path: _routes.ACCOUNT_DETAILS_QR_CODE_ROUTE,
    exact: false
  }));
  if (isMultichainAccountDetailsQRCodePage) {
    return true;
  }
  const isHandlingAddEthereumChainRequest = Boolean((0, _reactRouterDom.matchPath)(location.pathname, {
    path: _routes.CONFIRMATION_V_NEXT_ROUTE,
    exact: false
  }));
  const isImportSrpPage = Boolean((0, _reactRouterDom.matchPath)(location.pathname, {
    path: _routes.IMPORT_SRP_ROUTE,
    exact: false
  }));
  const isShieldPlanPage = Boolean((0, _reactRouterDom.matchPath)(location.pathname, {
    path: _routes.SHIELD_PLAN_ROUTE,
    exact: false
  }));
  if (isShieldPlanPage) {
    return true;
  }
  const isGatorPermissionsPage = Boolean((0, _reactRouterDom.matchPath)(location.pathname, {
    path: _routes.GATOR_PERMISSIONS,
    exact: false
  }));
  if (isGatorPermissionsPage) {
    return true;
  }
  const isGatorPermissionsTokenTransferPage = Boolean((0, _reactRouterDom.matchPath)(location.pathname, {
    path: _routes.TOKEN_TRANSFER_ROUTE,
    exact: false
  }));
  if (isGatorPermissionsTokenTransferPage) {
    return true;
  }
  const isReviewGatorPermissionsPage = Boolean((0, _reactRouterDom.matchPath)(location.pathname, {
    path: _routes.REVIEW_GATOR_PERMISSIONS_ROUTE,
    exact: false
  }));
  if (isReviewGatorPermissionsPage) {
    return true;
  }
  return isHandlingPermissionsRequest || isHandlingAddEthereumChainRequest || isConfirmTransactionRoute(location.pathname) || isImportSrpPage;
}
function showAppHeader(props) {
  const {
    location
  } = props;
  return Boolean((0, _reactRouterDom.matchPath)(location.pathname, {
    path: _routes.DEFAULT_ROUTE,
    exact: true
  }));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\routes\\utils.js",}]],[],{})

//# sourceMappingURL=data:application/json;charset=utf8;base64,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