LavaPack.loadBundle([
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\advanced-tab\\advanced-tab.component.js", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/preferences":"D:\\code\\v\\metamask-extension\\shared\\constants\\preferences.ts","../../../../shared/constants/smartTransactions":"D:\\code\\v\\metamask-extension\\shared\\constants\\smartTransactions.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/ui/text-field":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\text-field\\index.js","../../../components/ui/toggle-button":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\toggle-button\\index.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/export-utils":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\export-utils.js","../../../helpers/utils/settings-search":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\settings-search.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Cadvanced-tab%5Cadvanced-tab.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _metametrics = require("../../../../shared/constants/metametrics");
var _preferences = require("../../../../shared/constants/preferences");
var _smartTransactions = require("../../../../shared/constants/smartTransactions");
var _componentLibrary = require("../../../components/component-library");
var _textField = _interopRequireDefault(require("../../../components/ui/text-field"));
var _toggleButton = _interopRequireDefault(require("../../../components/ui/toggle-button"));
var _designSystem = require("../../../helpers/constants/design-system");
var _exportUtils = require("../../../helpers/utils/export-utils");
var _settingsSearch = require("../../../helpers/utils/settings-search");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class AdvancedTab extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "state", {
      autoLockTimeLimit: this.props.autoLockTimeLimit,
      autoLockTimeLimitBeforeNormalization: this.props.autoLockTimeLimit,
      lockTimeError: ''
    });
    _defineProperty(this, "settingsRefs", Array((0, _settingsSearch.getNumberOfSettingRoutesInTab)(this.context.t, this.context.t('advanced'))).fill(undefined).map(() => {
      return /*#__PURE__*/_react.default.createRef();
    }));
    _defineProperty(this, "backupUserData", async () => {
      const {
        fileName,
        data
      } = await this.props.backupUserData();
      (0, _exportUtils.exportAsFile)(fileName, data, _exportUtils.ExportableContentType.JSON);
      this.context.trackEvent({
        event: 'User Data Exported',
        category: 'Backup',
        properties: {}
      });
    });
  }
  componentDidUpdate() {
    const {
      t
    } = this.context;
    (0, _settingsSearch.handleSettingsRefs)(t, t('advanced'), this.settingsRefs);
  }
  componentDidMount() {
    const {
      t
    } = this.context;
    const {
      hideErrorInSettings
    } = this.props;
    (0, _settingsSearch.handleSettingsRefs)(t, t('advanced'), this.settingsRefs);
    hideErrorInSettings();
  }
  async getTextFromFile(file) {
    return new Promise((resolve, reject) => {
      const reader = new window.FileReader();
      reader.onload = e => {
        const text = e.target.result;
        resolve(text);
      };
      reader.onerror = e => {
        reject(e);
      };
      reader.readAsText(file);
    });
  }
  renderStateLogs() {
    const {
      t
    } = this.context;
    const {
      displayErrorInSettings
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      className: "settings-page__content-row",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      ref: this.settingsRefs[0],
      "data-testid": "advanced-setting-state-logs"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("span", null, t('stateLogs')), /*#__PURE__*/_react.default.createElement("span", {
      className: "settings-page__content-description"
    }, t('stateLogsDescription'))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
      variant: _componentLibrary.ButtonVariant.Secondary,
      "data-testid": "advanced-setting-state-logs-button",
      onClick: () => {
        window.logStateString(async (err, result) => {
          if (err) {
            displayErrorInSettings(t('stateLogError'));
          } else {
            try {
              await (0, _exportUtils.exportAsFile)(`${t('stateLogFileName')}.json`, result, _exportUtils.ExportableContentType.JSON);
            } catch (error) {
              displayErrorInSettings(error.message);
            }
          }
        });
      }
    }, t('downloadStateLogs')))));
  }
  renderResetAccount() {
    const {
      t
    } = this.context;
    const {
      showResetAccountConfirmationModal
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      ref: this.settingsRefs[1],
      className: "settings-page__content-row",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      "data-testid": "advanced-setting-reset-account"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("span", null, t('clearActivity')), /*#__PURE__*/_react.default.createElement("span", {
      className: "settings-page__content-description"
    }, t('clearActivityDescription'))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
      danger: true,
      onClick: event => {
        event.preventDefault();
        this.context.trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Settings,
          event: _metametrics.MetaMetricsEventName.AccountReset,
          properties: {}
        });
        showResetAccountConfirmationModal();
      }
    }, t('clearActivityButton')))));
  }
  renderToggleSmartAccountOptIn() {
    const {
      t
    } = this.context;
    const {
      smartAccountOptIn,
      setSmartAccountOptIn
    } = this.props;
    const learMoreLink = /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
      size: _componentLibrary.ButtonLinkSize.Inherit,
      textProps: {
        variant: _designSystem.TextVariant.bodyMd,
        alignItems: _designSystem.AlignItems.flexStart
      },
      as: "a",
      href: _smartTransactions.SMART_ACCOUNT_LEARN_MORE_URL,
      target: "_blank",
      rel: "noopener noreferrer"
    }, t('learnMoreUpperCase'));
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      ref: this.settingsRefs[2],
      className: "settings-page__content-row",
      "data-testid": "advanced-setting-smart-account-optin",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      justifyContent: _designSystem.JustifyContent.spaceBetween,
      gap: [null, 4]
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("span", null, " ", t('useSmartAccountTitle')), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-description"
    }, `${t('useSmartAccountDescription')} `, learMoreLink)), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col"
    }, /*#__PURE__*/_react.default.createElement(_toggleButton.default, {
      value: smartAccountOptIn,
      onToggle: oldValue => {
        const newValue = !oldValue;
        setSmartAccountOptIn(newValue);
      },
      offLabel: t('off'),
      onLabel: t('on'),
      dataTestId: "settings-page-smart-account-optin"
    })));
  }
  renderToggleDismissSmartAccountSuggestion() {
    const {
      t
    } = this.context;
    const {
      dismissSmartAccountSuggestionEnabled,
      setDismissSmartAccountSuggestionEnabled
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      ref: this.settingsRefs[3],
      className: "settings-page__content-row",
      "data-testid": "advanced-setting-dismiss-smart-account-suggestion-enabled",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      justifyContent: _designSystem.JustifyContent.spaceBetween,
      gap: [null, 4]
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("span", null, " ", t('dismissSmartAccountSuggestionEnabledTitle')), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-description"
    }, t('dismissSmartAccountSuggestionEnabledDescription'))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col"
    }, /*#__PURE__*/_react.default.createElement(_toggleButton.default, {
      value: dismissSmartAccountSuggestionEnabled,
      onToggle: oldValue => {
        const newValue = !oldValue;
        setDismissSmartAccountSuggestionEnabled(newValue);
      },
      offLabel: t('off'),
      onLabel: t('on'),
      dataTestId: "settings-page-dismiss-smart-account-suggestion-enabled-toggle"
    })));
  }
  renderToggleStxOptIn() {
    const {
      t
    } = this.context;
    const {
      smartTransactionsEnabled,
      setSmartTransactionsEnabled
    } = this.props;
    const learMoreLink = /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
      size: _componentLibrary.ButtonLinkSize.Inherit,
      textProps: {
        variant: _designSystem.TextVariant.bodyMd,
        alignItems: _designSystem.AlignItems.flexStart
      },
      as: "a",
      href: _smartTransactions.SMART_TRANSACTIONS_LEARN_MORE_URL,
      target: "_blank",
      rel: "noopener noreferrer"
    }, t('learnMoreUpperCase'));
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      ref: this.settingsRefs[4],
      className: "settings-page__content-row",
      "data-testid": "advanced-setting-enable-smart-transactions",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      justifyContent: _designSystem.JustifyContent.spaceBetween,
      gap: [null, 4]
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("span", null, t('smartTransactions')), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-description"
    }, t('stxOptInSupportedNetworksDescription', [learMoreLink]))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col"
    }, /*#__PURE__*/_react.default.createElement(_toggleButton.default, {
      value: smartTransactionsEnabled,
      onToggle: oldValue => {
        const newValue = !oldValue;
        setSmartTransactionsEnabled(newValue);
      },
      offLabel: t('off'),
      onLabel: t('on'),
      dataTestId: "settings-page-stx-opt-in-toggle"
    })));
  }
  renderHexDataOptIn() {
    const {
      t
    } = this.context;
    const {
      sendHexData,
      setHexDataFeatureFlag
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      ref: this.settingsRefs[5],
      className: "settings-page__content-row",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      justifyContent: _designSystem.JustifyContent.spaceBetween,
      gap: [null, 4],
      "data-testid": "advanced-setting-hex-data"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("span", null, t('showHexData')), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-description"
    }, t('showHexDataDescription'))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col"
    }, /*#__PURE__*/_react.default.createElement(_toggleButton.default, {
      value: sendHexData,
      onToggle: value => setHexDataFeatureFlag(!value),
      offLabel: t('off'),
      onLabel: t('on'),
      className: "hex-data-toggle"
    })));
  }
  renderShowConversionInTestnets() {
    const {
      t
    } = this.context;
    const {
      showFiatInTestnets,
      setShowFiatConversionOnTestnetsPreference
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      ref: this.settingsRefs[6],
      className: "settings-page__content-row",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      justifyContent: _designSystem.JustifyContent.spaceBetween,
      gap: [null, 4],
      "data-testid": "advanced-setting-show-testnet-conversion"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("span", null, t('showFiatConversionInTestnets')), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-description"
    }, t('showFiatConversionInTestnetsDescription'))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col"
    }, /*#__PURE__*/_react.default.createElement(_toggleButton.default, {
      value: showFiatInTestnets,
      onToggle: value => setShowFiatConversionOnTestnetsPreference(!value),
      offLabel: t('off'),
      onLabel: t('on'),
      className: "show-fiat-on-testnets-toggle"
    })));
  }
  renderToggleTestNetworks() {
    const {
      t
    } = this.context;
    const {
      showTestNetworks,
      setShowTestNetworks
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      ref: this.settingsRefs[5],
      className: "settings-page__content-row",
      "data-testid": "advanced-setting-show-testnet-conversion",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      justifyContent: _designSystem.JustifyContent.spaceBetween,
      gap: [null, 4]
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("span", null, t('showTestnetNetworks')), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-description"
    }, t('showTestnetNetworksDescription'))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col"
    }, /*#__PURE__*/_react.default.createElement(_toggleButton.default, {
      value: showTestNetworks,
      onToggle: value => setShowTestNetworks(!value),
      offLabel: t('off'),
      onLabel: t('on')
    })));
  }
  renderToggleExtensionInFullSizeView() {
    const {
      t
    } = this.context;
    const {
      showExtensionInFullSizeView,
      setShowExtensionInFullSizeView
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      ref: this.settingsRefs[8],
      className: "settings-page__content-row",
      "data-testid": "advanced-setting-show-extension-in-full-size-view",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      justifyContent: _designSystem.JustifyContent.spaceBetween,
      gap: [null, 4]
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("span", null, t('showExtensionInFullSizeView')), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-description"
    }, t('showExtensionInFullSizeViewDescription'))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col"
    }, /*#__PURE__*/_react.default.createElement(_toggleButton.default, {
      value: showExtensionInFullSizeView,
      onToggle: value => setShowExtensionInFullSizeView(!value),
      offLabel: t('off'),
      onLabel: t('on')
    })));
  }
  renderAutoLockTimeLimit() {
    const {
      t
    } = this.context;
    const {
      lockTimeError
    } = this.state;
    const {
      setAutoLockTimeLimit
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      ref: this.settingsRefs[7],
      className: "settings-page__content-row",
      "data-testid": "advanced-setting-auto-lock",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("span", null, t('autoLockTimeLimit')), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-description"
    }, t('autoLockTimeLimitDescription'))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col"
    }, /*#__PURE__*/_react.default.createElement(_textField.default, {
      id: "autoTimeout",
      "data-testid": "auto-lockout-time",
      placeholder: "0",
      value: this.state.autoLockTimeLimitBeforeNormalization,
      onChange: e => this.handleLockChange(e.target.value),
      error: lockTimeError,
      fullWidth: true,
      margin: "dense",
      min: 0
    }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
      variant: _componentLibrary.ButtonVariant.Secondary,
      "data-testid": "auto-lockout-button",
      disabled: lockTimeError !== '',
      onClick: () => {
        setAutoLockTimeLimit(this.state.autoLockTimeLimit);
      }
    }, t('save')))));
  }
  renderDismissSeedBackupReminderControl() {
    const {
      t
    } = this.context;
    const {
      dismissSeedBackUpReminder,
      setDismissSeedBackUpReminder
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      ref: this.settingsRefs[9],
      className: "settings-page__content-row",
      "data-testid": "advanced-setting-dismiss-reminder",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      justifyContent: _designSystem.JustifyContent.spaceBetween,
      gap: [null, 4]
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("span", null, t('dismissReminderField')), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-description"
    }, t('dismissReminderDescriptionField'))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col"
    }, /*#__PURE__*/_react.default.createElement(_toggleButton.default, {
      value: dismissSeedBackUpReminder,
      onToggle: value => setDismissSeedBackUpReminder(!value),
      offLabel: t('off'),
      onLabel: t('on')
    })));
  }
  handleLockChange(autoLockTimeLimitBeforeNormalization) {
    const {
      t
    } = this.context;
    if (autoLockTimeLimitBeforeNormalization === '') {
      this.setState({
        autoLockTimeLimitBeforeNormalization,
        autoLockTimeLimit: _preferences.DEFAULT_AUTO_LOCK_TIME_LIMIT,
        lockTimeError: ''
      });
      return;
    }
    const autoLockTimeLimitAfterNormalization = Number(autoLockTimeLimitBeforeNormalization);
    if (Number.isNaN(autoLockTimeLimitAfterNormalization) || autoLockTimeLimitAfterNormalization < 0 || autoLockTimeLimitAfterNormalization > 10080) {
      this.setState({
        autoLockTimeLimitBeforeNormalization,
        autoLockTimeLimit: null,
        lockTimeError: t('lockTimeInvalid')
      });
      return;
    }
    const autoLockTimeLimit = autoLockTimeLimitAfterNormalization;
    this.setState({
      autoLockTimeLimitBeforeNormalization,
      autoLockTimeLimit,
      lockTimeError: ''
    });
  }
  renderUserDataBackup() {
    const {
      t
    } = this.context;
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      ref: this.settingsRefs[10],
      className: "settings-page__content-row",
      "data-testid": "advanced-setting-data-backup",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("span", null, t('exportYourData')), /*#__PURE__*/_react.default.createElement("span", {
      className: "settings-page__content-description"
    }, t('exportYourDataDescription'))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
      "data-testid": "export-data-button",
      variant: _componentLibrary.ButtonVariant.Secondary,
      large: true,
      onClick: this.backupUserData
    }, t('exportYourDataButton')))));
  }
  renderManageInstitutionalWallets() {
    const {
      t
    } = this.context;
    const {
      manageInstitutionalWallets,
      setManageInstitutionalWallets
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      ref: this.settingsRefs[9],
      className: "settings-page__content-row",
      "data-testid": "advanced-setting-dismiss-reminder",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      justifyContent: _designSystem.JustifyContent.spaceBetween,
      gap: [null, 4]
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("span", null, t('manageInstitutionalWallets')), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-description"
    }, t('manageInstitutionalWalletsDescription'))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col"
    }, /*#__PURE__*/_react.default.createElement(_toggleButton.default, {
      value: manageInstitutionalWallets,
      onToggle: value => setManageInstitutionalWallets(!value),
      offLabel: t('off'),
      onLabel: t('on')
    })));
  }
  render() {
    const {
      errorInSettings
    } = this.props;
    // When adding/removing/editing the order of renders, double-check the order of the settingsRefs. This affects settings-search.js
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__body"
    }, errorInSettings ? /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-tab__error"
    }, errorInSettings) : null, this.renderStateLogs(), this.renderResetAccount(), this.renderToggleSmartAccountOptIn(), this.renderToggleDismissSmartAccountSuggestion(), this.renderToggleStxOptIn(), this.renderHexDataOptIn(), this.renderShowConversionInTestnets(), this.renderToggleTestNetworks(), this.renderManageInstitutionalWallets(), this.renderToggleExtensionInFullSizeView(), this.renderAutoLockTimeLimit(), this.renderUserDataBackup(), this.renderDismissSeedBackupReminderControl());
  }
}
exports.default = AdvancedTab;
_defineProperty(AdvancedTab, "contextTypes", {
  t: _propTypes.default.func,
  trackEvent: _propTypes.default.func
});
_defineProperty(AdvancedTab, "propTypes", {
  setHexDataFeatureFlag: _propTypes.default.func,
  displayErrorInSettings: _propTypes.default.func,
  hideErrorInSettings: _propTypes.default.func,
  showResetAccountConfirmationModal: _propTypes.default.func,
  errorInSettings: _propTypes.default.string,
  sendHexData: _propTypes.default.bool,
  showFiatInTestnets: _propTypes.default.bool,
  showTestNetworks: _propTypes.default.bool,
  smartTransactionsEnabled: _propTypes.default.bool,
  autoLockTimeLimit: _propTypes.default.number,
  setAutoLockTimeLimit: _propTypes.default.func.isRequired,
  setShowFiatConversionOnTestnetsPreference: _propTypes.default.func.isRequired,
  setShowTestNetworks: _propTypes.default.func.isRequired,
  setSmartTransactionsEnabled: _propTypes.default.func.isRequired,
  setDismissSeedBackUpReminder: _propTypes.default.func.isRequired,
  dismissSeedBackUpReminder: _propTypes.default.bool.isRequired,
  backupUserData: _propTypes.default.func.isRequired,
  showExtensionInFullSizeView: _propTypes.default.bool,
  setShowExtensionInFullSizeView: _propTypes.default.func.isRequired,
  manageInstitutionalWallets: _propTypes.default.bool,
  setManageInstitutionalWallets: _propTypes.default.func.isRequired,
  dismissSmartAccountSuggestionEnabled: _propTypes.default.bool.isRequired,
  setDismissSmartAccountSuggestionEnabled: _propTypes.default.func.isRequired,
  smartAccountOptIn: _propTypes.default.bool.isRequired,
  setSmartAccountOptIn: _propTypes.default.func.isRequired
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\advanced-tab\\advanced-tab.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\advanced-tab\\advanced-tab.container.js", {"../../../../shared/constants/preferences":"D:\\code\\v\\metamask-extension\\shared\\constants\\preferences.ts","../../../../shared/modules/selectors":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\index.ts","../../../ducks/app/app":"D:\\code\\v\\metamask-extension\\ui\\ducks\\app\\app.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./advanced-tab.component":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\advanced-tab\\advanced-tab.component.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Cadvanced-tab%5Cadvanced-tab.container.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapStateToProps = exports.mapDispatchToProps = exports.default = void 0;
var _reactRedux = require("react-redux");
var _preferences = require("../../../../shared/constants/preferences");
var _selectors = require("../../../selectors");
var _actions = require("../../../store/actions");
var _selectors2 = require("../../../../shared/modules/selectors");
var _app = require("../../../ducks/app/app");
var _advancedTab = _interopRequireDefault(require("./advanced-tab.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const mapStateToProps = state => {
  const {
    appState: {
      errorInSettings
    },
    metamask
  } = state;
  const {
    featureFlags: {
      sendHexData
    } = {},
    dismissSeedBackUpReminder,
    manageInstitutionalWallets
  } = metamask;
  const {
    showFiatInTestnets,
    showTestNetworks,
    showExtensionInFullSizeView,
    autoLockTimeLimit = _preferences.DEFAULT_AUTO_LOCK_TIME_LIMIT,
    dismissSmartAccountSuggestionEnabled,
    smartAccountOptIn
  } = (0, _selectors.getPreferences)(state);
  return {
    errorInSettings,
    sendHexData,
    showFiatInTestnets,
    showTestNetworks,
    showExtensionInFullSizeView,
    smartTransactionsEnabled: (0, _selectors2.getSmartTransactionsPreferenceEnabled)(state),
    autoLockTimeLimit,
    dismissSeedBackUpReminder,
    manageInstitutionalWallets,
    dismissSmartAccountSuggestionEnabled,
    smartAccountOptIn
  };
};
exports.mapStateToProps = mapStateToProps;
const mapDispatchToProps = dispatch => {
  return {
    backupUserData: () => (0, _actions.backupUserData)(),
    setHexDataFeatureFlag: shouldShow => dispatch((0, _actions.setFeatureFlag)('sendHexData', shouldShow)),
    displayErrorInSettings: errorInSettings => dispatch((0, _app.displayErrorInSettings)(errorInSettings)),
    hideErrorInSettings: () => dispatch((0, _app.hideErrorInSettings)()),
    showResetAccountConfirmationModal: () => dispatch((0, _actions.showModal)({
      name: 'CONFIRM_RESET_ACCOUNT'
    })),
    setShowFiatConversionOnTestnetsPreference: value => {
      return dispatch((0, _actions.setShowFiatConversionOnTestnetsPreference)(value));
    },
    setShowTestNetworks: value => {
      return dispatch((0, _actions.setShowTestNetworks)(value));
    },
    setShowExtensionInFullSizeView: value => {
      return dispatch((0, _actions.setShowExtensionInFullSizeView)(value));
    },
    setSmartTransactionsEnabled: value => {
      return dispatch((0, _actions.setSmartTransactionsPreferenceEnabled)(value));
    },
    setAutoLockTimeLimit: value => {
      return dispatch((0, _actions.setAutoLockTimeLimit)(value));
    },
    setDismissSeedBackUpReminder: value => {
      return dispatch((0, _actions.setDismissSeedBackUpReminder)(value));
    },
    setManageInstitutionalWallets: value => {
      return dispatch((0, _actions.setManageInstitutionalWallets)(value));
    },
    setDismissSmartAccountSuggestionEnabled: value => {
      return dispatch((0, _actions.setDismissSmartAccountSuggestionEnabled)(value));
    },
    setSmartAccountOptIn: value => {
      return dispatch((0, _actions.setSmartAccountOptIn)(value));
    }
  };
};
exports.mapDispatchToProps = mapDispatchToProps;
var _default = exports.default = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_advancedTab.default);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\advanced-tab\\advanced-tab.container.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\advanced-tab\\index.js", {"./advanced-tab.container":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\advanced-tab\\advanced-tab.container.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Cadvanced-tab%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _advancedTab.default;
  }
});
var _advancedTab = _interopRequireDefault(require("./advanced-tab.container"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\advanced-tab\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\backup-and-sync-tab\\backup-and-sync-tab.component.tsx", {"../../../components/app/identity/backup-and-sync-features-toggles/backup-and-sync-features-toggles":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\identity\\backup-and-sync-features-toggles\\backup-and-sync-features-toggles.tsx","../../../components/app/identity/backup-and-sync-toggle/backup-and-sync-toggle":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\identity\\backup-and-sync-toggle\\backup-and-sync-toggle.tsx","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/settings-search":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\settings-search.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Cbackup-and-sync-tab%5Cbackup-and-sync-tab.component.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _settingsSearch = require("../../../helpers/utils/settings-search");
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../../components/component-library");
var _backupAndSyncFeaturesToggles = require("../../../components/app/identity/backup-and-sync-features-toggles/backup-and-sync-features-toggles");
var _backupAndSyncToggle = require("../../../components/app/identity/backup-and-sync-toggle/backup-and-sync-toggle");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class BackupAndSyncTab extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "settingsRefs", Array((0, _settingsSearch.getNumberOfSettingRoutesInTab)(this.context.t, this.context.t('backupAndSync'))).fill(undefined).map(() => {
      return /*#__PURE__*/_react.default.createRef();
    }));
  }
  componentDidUpdate() {
    const {
      t
    } = this.context;
    (0, _settingsSearch.handleSettingsRefs)(t, t('backupAndSync'), this.settingsRefs);
  }
  componentDidMount() {
    const {
      t
    } = this.context;
    (0, _settingsSearch.handleSettingsRefs)(t, t('backupAndSync'), this.settingsRefs);
  }
  render() {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__body"
    }, /*#__PURE__*/_react.default.createElement(_backupAndSyncToggle.BackupAndSyncToggle, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      borderColor: _designSystem.BorderColor.borderMuted,
      width: _designSystem.BlockSize.Full,
      style: {
        height: '1px',
        borderBottomWidth: 0
      }
    }), /*#__PURE__*/_react.default.createElement(_backupAndSyncFeaturesToggles.BackupAndSyncFeaturesToggles, null));
  }
}
exports.default = BackupAndSyncTab;
_defineProperty(BackupAndSyncTab, "contextTypes", {
  t: _propTypes.default.func,
  trackEvent: _propTypes.default.func
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\backup-and-sync-tab\\backup-and-sync-tab.component.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\backup-and-sync-tab\\backup-and-sync-tab.container.ts", {"./backup-and-sync-tab.component":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\backup-and-sync-tab\\backup-and-sync-tab.component.tsx","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js","redux":"D:\\code\\v\\metamask-extension\\node_modules\\redux\\lib\\redux.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Cbackup-and-sync-tab%5Cbackup-and-sync-tab.container.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _redux = require("redux");
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _backupAndSyncTab = _interopRequireDefault(require("./backup-and-sync-tab.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const mapStateToProps = _state => {
  return {};
};
const mapDispatchToProps = _dispatch => {
  return {};
};
var _default = exports.default = (0, _redux.compose)(_reactRouterDom.withRouter, (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps))(_backupAndSyncTab.default);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\backup-and-sync-tab\\backup-and-sync-tab.container.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\backup-and-sync-tab\\index.ts", {"./backup-and-sync-tab.container":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\backup-and-sync-tab\\backup-and-sync-tab.container.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Cbackup-and-sync-tab%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _backupAndSyncTab.default;
  }
});
var _backupAndSyncTab = _interopRequireDefault(require("./backup-and-sync-tab.container"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\backup-and-sync-tab\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\contact-list-tab\\add-contact\\add-contact.component.js", {"../../../../../shared/modules/hexstring-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\hexstring-utils.ts","../../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../../components/app/contact-list/utils":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\contact-list\\utils.ts","../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../components/multichain/pages/send/components":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\index.ts","../../../../components/ui/page-container/page-container-footer":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\page-container\\page-container-footer\\index.js","../../../../components/ui/text-field":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\text-field\\index.js","../../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../../confirmations/send-legacy/send-content/add-recipient/domain-input":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\send-legacy\\send-content\\add-recipient\\domain-input.js","../../../confirmations/send-legacy/send.constants":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\send-legacy\\send.constants.js","../contact-networks":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\contact-list-tab\\contact-networks.tsx","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Ccontact-list-tab%5Cadd-contact%5Cadd-contact.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _lodash = require("lodash");
var _reactRedux = require("react-redux");
var _textField = _interopRequireDefault(require("../../../../components/ui/text-field"));
var _routes = require("../../../../helpers/constants/routes");
var _util = require("../../../../helpers/utils/util");
var _domainInput = _interopRequireDefault(require("../../../confirmations/send-legacy/send-content/add-recipient/domain-input"));
var _pageContainerFooter = _interopRequireDefault(require("../../../../components/ui/page-container/page-container-footer"));
var _hexstringUtils = require("../../../../../shared/modules/hexstring-utils");
var _send = require("../../../confirmations/send-legacy/send.constants");
var _components = require("../../../../components/multichain/pages/send/components");
var _utils = require("../../../../components/app/contact-list/utils");
var _i18n = require("../../../../contexts/i18n");
var _componentLibrary = require("../../../../components/component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _multichain = require("../../../../selectors/multichain");
var _networks = require("../../../../../shared/modules/selectors/networks");
var _contactNetworks = require("../contact-networks");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AddContact = ({
  addressBook,
  internalAccounts,
  addToAddressBook,
  navigate,
  scanQrCode,
  qrCodeData,
  qrCodeDetected,
  domainResolutions,
  domainError,
  resetDomainResolution
}) => {
  var _networks$selectedCha, _networks$selectedCha2;
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const [newName, setNewName] = (0, _react.useState)('');
  const [selectedAddress, setSelectedAddress] = (0, _react.useState)('');
  const [addressInputError, setAddressInputError] = (0, _react.useState)('');
  const [nameInputError, setNameInputError] = (0, _react.useState)('');
  const [input, setInput] = (0, _react.useState)('');
  const currentChainId = (0, _reactRedux.useSelector)(_networks.getCurrentChainId);
  const [selectedChainId, setSelectedChainId] = (0, _react.useState)(currentChainId);
  const [showModal, setShowModal] = (0, _react.useState)(false);
  const networks = (0, _reactRedux.useSelector)(_networks.getNetworkConfigurationsByChainId);
  const validate = (0, _react.useCallback)(value => {
    const valid = !(0, _hexstringUtils.isBurnAddress)(value) && (0, _hexstringUtils.isValidHexAddress)(value, {
      mixedCaseUseChecksum: true
    });
    const validEnsAddress = (0, _util.isValidDomainName)(value);
    if (!validEnsAddress && !valid) {
      setAddressInputError(_send.INVALID_RECIPIENT_ADDRESS_ERROR);
    } else {
      setAddressInputError(null);
    }
  }, []);
  const dValidate = (0, _react.useMemo)(() => (0, _lodash.debounce)(validate, 500), [validate]);
  const handleNameChange = name => {
    const isValidName = !(0, _utils.isDuplicateContact)(addressBook, internalAccounts, name);
    setNameInputError(isValidName ? null : t('nameAlreadyInUse'));
    setNewName(name);
  };
  const onChange = value => {
    setInput(value);
    dValidate(value);
  };
  const renderInput = () => /*#__PURE__*/_react.default.createElement(_domainInput.default, {
    scanQrCode: () => scanQrCode(),
    onChange: onChange,
    onPaste: value => {
      setInput(value);
      validate(value);
    },
    onReset: () => {
      resetDomainResolution();
      setInput('');
      setSelectedAddress('');
    },
    userInput: selectedAddress || input
  });
  (0, _react.useEffect)(() => {
    if ((qrCodeData === null || qrCodeData === void 0 ? void 0 : qrCodeData.type) === 'address') {
      const scannedAddress = qrCodeData.values.address.toLowerCase();
      const addresses = [...domainResolutions.map(({
        resolvedAddress
      }) => resolvedAddress), selectedAddress].filter(Boolean).map(addr => addr.toLowerCase());
      if (!addresses.includes(scannedAddress)) {
        setInput(scannedAddress);
        validate(scannedAddress);
        qrCodeDetected(null);
      }
    }
  }, [qrCodeData, domainResolutions, selectedAddress, validate, qrCodeDetected]);
  const addressError = domainError || addressInputError;
  const newAddress = selectedAddress || input;
  const validAddress = !(0, _hexstringUtils.isBurnAddress)(newAddress) && (0, _hexstringUtils.isValidHexAddress)(newAddress, {
    mixedCaseUseChecksum: true
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "settings-page__content-row address-book__add-contact"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "address-book__add-contact__content"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "address-book__view-contact__group address-book__add-contact__content__username"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "address-book__view-contact__group__label"
  }, t('userName')), /*#__PURE__*/_react.default.createElement(_textField.default, {
    type: "text",
    id: "nickname",
    placeholder: t('addAlias'),
    value: newName,
    onChange: e => handleNameChange(e.target.value),
    fullWidth: true,
    margin: "dense",
    error: nameInputError
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "address-book__view-contact__group"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "address-book__view-contact__group__label"
  }, t('ethereumPublicAddress')), renderInput(), /*#__PURE__*/_react.default.createElement("div", {
    className: `address-book__view-contact__group__${(domainResolutions === null || domainResolutions === void 0 ? void 0 : domainResolutions.length) === 1 ? 'single-' : ''}resolution-list`
  }, domainResolutions === null || domainResolutions === void 0 ? void 0 : domainResolutions.map(resolution => {
    const {
      resolvedAddress,
      resolvingSnap,
      addressBookEntryName,
      protocol,
      domainName
    } = resolution;
    return /*#__PURE__*/_react.default.createElement(_components.DomainInputResolutionCell, {
      key: `${resolvedAddress}${resolvingSnap}${protocol}`,
      address: resolvedAddress,
      domainName: addressBookEntryName ?? domainName,
      onClick: () => {
        handleNameChange(domainName);
        setInput(resolvedAddress);
        resetDomainResolution();
      },
      protocol: protocol,
      resolvingSnap: resolvingSnap
    });
  })), addressError && /*#__PURE__*/_react.default.createElement("div", {
    className: "address-book__add-contact__error"
  }, t(addressError))), /*#__PURE__*/_react.default.createElement("div", {
    className: "address-book__view-contact__group"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "address-book__view-contact__group__label"
  }, t('network')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    as: "button",
    padding: 3,
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    backgroundColor: _designSystem.BackgroundColor.transparent,
    borderColor: _designSystem.BorderColor.borderDefault,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    borderRadius: _designSystem.BorderRadius.XL,
    onClick: () => setShowModal(true),
    className: "network-selector",
    "data-testid": "network-selector"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    gap: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
    size: _componentLibrary.AvatarNetworkSize.Sm,
    src: (0, _multichain.getImageForChainId)(selectedChainId) || undefined,
    name: networks === null || networks === void 0 || (_networks$selectedCha = networks[selectedChainId]) === null || _networks$selectedCha === void 0 ? void 0 : _networks$selectedCha.name
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, null, networks === null || networks === void 0 || (_networks$selectedCha2 = networks[selectedChainId]) === null || _networks$selectedCha2 === void 0 ? void 0 : _networks$selectedCha2.name)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.ArrowDown,
    color: _designSystem.IconColor.iconDefault,
    size: _componentLibrary.IconSize.Sm
  })), showModal && /*#__PURE__*/_react.default.createElement(_contactNetworks.ContactNetworks, {
    isOpen: true,
    onClose: () => setShowModal(false),
    selectedChainId: selectedChainId,
    onSelect: chainname => setSelectedChainId(chainname)
  }))), /*#__PURE__*/_react.default.createElement(_pageContainerFooter.default, {
    cancelText: t('cancel'),
    disabled: Boolean(addressInputError || nameInputError || !validAddress || !newName.trim()),
    onSubmit: async () => {
      await addToAddressBook(newAddress, newName, '', selectedChainId);
      navigate(_routes.CONTACT_LIST_ROUTE);
    },
    onCancel: () => {
      navigate(_routes.CONTACT_LIST_ROUTE);
    },
    submitText: t('save')
  }));
};
AddContact.propTypes = {
  addressBook: _propTypes.default.array,
  internalAccounts: _propTypes.default.array,
  addToAddressBook: _propTypes.default.func,
  navigate: _propTypes.default.func.isRequired,
  scanQrCode: _propTypes.default.func,
  qrCodeData: _propTypes.default.object,
  qrCodeDetected: _propTypes.default.func,
  domainResolutions: _propTypes.default.arrayOf(_propTypes.default.object),
  domainError: _propTypes.default.string,
  resetDomainResolution: _propTypes.default.func
};
var _default = exports.default = AddContact;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\contact-list-tab\\add-contact\\add-contact.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\contact-list-tab\\add-contact\\add-contact.container.js", {"../../../../ducks/app/app":"D:\\code\\v\\metamask-extension\\ui\\ducks\\app\\app.ts","../../../../ducks/domains":"D:\\code\\v\\metamask-extension\\ui\\ducks\\domains.js","../../../../helpers/higher-order-components/with-router-hooks/with-router-hooks":"D:\\code\\v\\metamask-extension\\ui\\helpers\\higher-order-components\\with-router-hooks\\with-router-hooks.tsx","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./add-contact.component":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\contact-list-tab\\add-contact\\add-contact.component.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","redux":"D:\\code\\v\\metamask-extension\\node_modules\\redux\\lib\\redux.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Ccontact-list-tab%5Cadd-contact%5Cadd-contact.container.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _redux = require("redux");
var _reactRedux = require("react-redux");
var _withRouterHooks = _interopRequireDefault(require("../../../../helpers/higher-order-components/with-router-hooks/with-router-hooks"));
var _actions = require("../../../../store/actions");
var _app = require("../../../../ducks/app/app");
var _domains = require("../../../../ducks/domains");
var _selectors = require("../../../../selectors");
var _addContact = _interopRequireDefault(require("./add-contact.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const mapStateToProps = state => {
  return {
    addressBook: (0, _selectors.getAddressBook)(state),
    internalAccounts: (0, _selectors.getInternalAccounts)(state),
    qrCodeData: (0, _app.getQrCodeData)(state),
    domainError: (0, _domains.getDomainError)(state),
    domainResolutions: (0, _domains.getDomainResolutions)(state)
  };
};
const mapDispatchToProps = dispatch => {
  return {
    addToAddressBook: (recipient, nickname, memo, customChainId) => dispatch((0, _actions.addToAddressBook)(recipient, nickname, memo, customChainId)),
    scanQrCode: () => dispatch((0, _actions.showQrScanner)()),
    qrCodeDetected: data => dispatch((0, _actions.qrCodeDetected)(data)),
    resetDomainResolution: () => dispatch((0, _domains.resetDomainResolution)())
  };
};
var _default = exports.default = (0, _redux.compose)(_withRouterHooks.default, (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps))(_addContact.default);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\contact-list-tab\\add-contact\\add-contact.container.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\contact-list-tab\\add-contact\\index.js", {"./add-contact.container":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\contact-list-tab\\add-contact\\add-contact.container.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Ccontact-list-tab%5Cadd-contact%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _addContact.default;
  }
});
var _addContact = _interopRequireDefault(require("./add-contact.container"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\contact-list-tab\\add-contact\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\contact-list-tab\\contact-list-tab.component.js", {"../../../components/app/contact-list":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\contact-list\\index.js","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../helpers/utils/settings-search":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\settings-search.js","./add-contact":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\contact-list-tab\\add-contact\\index.js","./edit-contact":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\contact-list-tab\\edit-contact\\index.js","./view-contact":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\contact-list-tab\\view-contact\\index.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Ccontact-list-tab%5Ccontact-list-tab.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _contactList = _interopRequireDefault(require("../../../components/app/contact-list"));
var _routes = require("../../../helpers/constants/routes");
var _settingsSearch = require("../../../helpers/utils/settings-search");
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _editContact = _interopRequireDefault(require("./edit-contact"));
var _addContact = _interopRequireDefault(require("./add-contact"));
var _viewContact = _interopRequireDefault(require("./view-contact"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class ContactListTab extends _react.Component {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "settingsRefs", Array((0, _settingsSearch.getNumberOfSettingRoutesInTab)(this.context.t, this.context.t('contacts'))).fill(undefined).map(() => {
      return /*#__PURE__*/_react.default.createRef();
    }));
  }
  componentDidUpdate() {
    const {
      t
    } = this.context;
    (0, _settingsSearch.handleSettingsRefs)(t, t('contacts'), this.settingsRefs);
  }
  componentDidMount() {
    const {
      t
    } = this.context;
    (0, _settingsSearch.handleSettingsRefs)(t, t('contacts'), this.settingsRefs);
  }
  renderAddresses() {
    const {
      completeAddressBook,
      internalAccounts,
      navigate,
      selectedAddress
    } = this.props;
    const updatedAddressBook = Object.entries(completeAddressBook).map(([_, value]) => value);
    const contacts = updatedAddressBook.filter(({
      name
    }) => Boolean(name));
    const nonContacts = updatedAddressBook.filter(({
      name
    }) => !name);
    const {
      t
    } = this.context;
    if (updatedAddressBook.length) {
      return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_contactList.default, {
        addressBook: updatedAddressBook,
        internalAccounts: internalAccounts,
        searchForContacts: () => contacts,
        searchForRecents: () => nonContacts,
        selectRecipient: address => {
          navigate(`${_routes.CONTACT_VIEW_ROUTE}/${address}`);
        },
        selectedAddress: selectedAddress
      }));
    }
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "address-book__container"
    }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
      name: _componentLibrary.IconName.Book,
      color: _designSystem.IconColor.iconMuted,
      className: "address-book__icon",
      size: _componentLibrary.IconSize.Xl
    }), /*#__PURE__*/_react.default.createElement("h4", {
      className: "address-book__title"
    }, t('buildContactList')), /*#__PURE__*/_react.default.createElement("p", {
      className: "address-book__sub-title"
    }, t('addFriendsAndAddresses')), /*#__PURE__*/_react.default.createElement("button", {
      className: "address-book__link",
      onClick: () => {
        navigate(_routes.CONTACT_ADD_ROUTE);
      }
    }, "+ ", t('addContact'))));
  }
  renderAddButton() {
    const {
      navigate,
      viewingContact,
      editingContact
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonPrimary, {
      className: (0, _classnames.default)('address-book-add-button__button', {
        'address-book-add-button__button--hidden': viewingContact || editingContact
      }),
      onClick: () => {
        navigate(_routes.CONTACT_ADD_ROUTE);
      },
      margin: 4,
      size: _designSystem.Size.LG
    }, this.context.t('addContact'));
  }
  renderContactContent() {
    const {
      viewingContact,
      editingContact,
      addingContact
    } = this.props;
    let ContactContentComponent = null;
    if (viewingContact) {
      ContactContentComponent = _viewContact.default;
    } else if (editingContact) {
      ContactContentComponent = _editContact.default;
    } else if (addingContact) {
      ContactContentComponent = _addContact.default;
    }
    return ContactContentComponent && /*#__PURE__*/_react.default.createElement("div", {
      className: "address-book-contact-content"
    }, /*#__PURE__*/_react.default.createElement(ContactContentComponent, null));
  }
  renderAddressBookContent() {
    const {
      hideAddressBook
    } = this.props;
    if (!hideAddressBook) {
      return /*#__PURE__*/_react.default.createElement("div", {
        ref: this.settingsRefs[0],
        className: "address-book"
      }, this.renderAddresses());
    }
    return null;
  }
  render() {
    const {
      addingContact,
      currentPath,
      completeAddressBook
    } = this.props;
    const addressData = completeAddressBook;
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "address-book-wrapper"
    }, this.renderAddressBookContent(), this.renderContactContent(), currentPath === _routes.CONTACT_LIST_ROUTE && !addingContact && addressData.length > 0 ? this.renderAddButton() : null);
  }
}
exports.default = ContactListTab;
_defineProperty(ContactListTab, "contextTypes", {
  t: _propTypes.default.func
});
_defineProperty(ContactListTab, "propTypes", {
  completeAddressBook: _propTypes.default.array,
  internalAccounts: _propTypes.default.array,
  navigate: _propTypes.default.func.isRequired,
  selectedAddress: _propTypes.default.string,
  viewingContact: _propTypes.default.bool,
  editingContact: _propTypes.default.bool,
  addingContact: _propTypes.default.bool,
  hideAddressBook: _propTypes.default.bool,
  currentPath: _propTypes.default.string
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\contact-list-tab\\contact-list-tab.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\contact-list-tab\\contact-list-tab.container.js", {"../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../helpers/higher-order-components/with-router-hooks/with-router-hooks":"D:\\code\\v\\metamask-extension\\ui\\helpers\\higher-order-components\\with-router-hooks\\with-router-hooks.tsx","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","./contact-list-tab.component":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\contact-list-tab\\contact-list-tab.component.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","redux":"D:\\code\\v\\metamask-extension\\node_modules\\redux\\lib\\redux.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Ccontact-list-tab%5Ccontact-list-tab.container.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _redux = require("redux");
var _reactRedux = require("react-redux");
var _withRouterHooks = _interopRequireDefault(require("../../../helpers/higher-order-components/with-router-hooks/with-router-hooks"));
var _selectors = require("../../../selectors");
var _routes = require("../../../helpers/constants/routes");
var _contactListTab = _interopRequireDefault(require("./contact-list-tab.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const mapStateToProps = (state, ownProps) => {
  const {
    location
  } = ownProps;
  const {
    pathname
  } = location;
  const pathNameTail = pathname.match(/[^/]+$/u)[0];
  const pathNameTailIsAddress = pathNameTail.includes('0x');
  const viewingContact = Boolean(pathname.match(_routes.CONTACT_VIEW_ROUTE));
  const editingContact = Boolean(pathname.match(_routes.CONTACT_EDIT_ROUTE));
  const addingContact = Boolean(pathname.match(_routes.CONTACT_ADD_ROUTE));
  const hideAddressBook = viewingContact || editingContact || addingContact;
  return {
    viewingContact,
    editingContact,
    addingContact,
    addressBook: (0, _selectors.getAddressBook)(state),
    completeAddressBook: (0, _selectors.getCompleteAddressBook)(state),
    internalAccounts: (0, _selectors.getInternalAccounts)(state),
    selectedAddress: pathNameTailIsAddress ? pathNameTail : '',
    hideAddressBook,
    currentPath: pathname
  };
};
var _default = exports.default = (0, _redux.compose)(_withRouterHooks.default, (0, _reactRedux.connect)(mapStateToProps))(_contactListTab.default);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\contact-list-tab\\contact-list-tab.container.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\contact-list-tab\\contact-networks.tsx", {"../../../../shared/constants/bridge":"D:\\code\\v\\metamask-extension\\shared\\constants\\bridge.ts","../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/multichain":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Ccontact-list-tab%5Ccontact-networks.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContactNetworks = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../../components/component-library");
var _networks = require("../../../../shared/modules/selectors/networks");
var _network = require("../../../../shared/constants/network");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _bridge = require("../../../../shared/constants/bridge");
var _multichain = require("../../../components/multichain");
var _multichain2 = require("../../../selectors/multichain");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ContactNetworks = ({
  isOpen,
  onClose,
  selectedChainId,
  onSelect
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const networkConfigurations = (0, _reactRedux.useSelector)(_networks.getNetworkConfigurationsByChainId);
  const [nonTestNetworks, testNetworks] = (0, _react.useMemo)(() => Object.entries(networkConfigurations).reduce(([nonTest, test], [chainId, config]) => {
    const isTest = _network.TEST_CHAINS.includes(chainId);
    (isTest ? test : nonTest).push(config);
    return [nonTest, test];
  }, [[], []]), [networkConfigurations]);
  const renderNetworkListItems = networks => networks.map(({
    name,
    chainId
  }) => /*#__PURE__*/_react.default.createElement(_multichain.NetworkListItem, {
    key: chainId,
    name: _bridge.NETWORK_TO_SHORT_NETWORK_NAME_MAP[chainId] ?? name,
    selected: selectedChainId === chainId,
    onClick: () => {
      onSelect === null || onSelect === void 0 || onSelect(chainId);
      onClose();
    },
    iconSrc: (0, _multichain2.getImageForChainId)(chainId),
    iconSize: _componentLibrary.AvatarNetworkSize.Sm,
    focus: false,
    variant: _designSystem.TextVariant.bodyMdMedium
  }));
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: isOpen,
    onClose: onClose,
    className: "multichain-asset-picker__network-modal"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, {
    modalDialogProps: {
      padding: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onBack: onClose,
    onClose: onClose
  }, t('bridgeSelectNetwork')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "multichain-asset-picker__network-list",
    display: _designSystem.Display.Flex
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    width: _designSystem.BlockSize.Full
  }, renderNetworkListItems(nonTestNetworks), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    padding: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium
  }, t('testnets')), renderNetworkListItems(testNetworks))))));
};
exports.ContactNetworks = ContactNetworks;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\contact-list-tab\\contact-networks.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\contact-list-tab\\edit-contact\\edit-contact.component.js", {"../../../../../shared/modules/hexstring-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\hexstring-utils.ts","../../../../components/app/contact-list/utils":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\contact-list\\utils.ts","../../../../components/app/preferred-avatar":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\preferred-avatar\\index.ts","../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../components/ui/page-container/page-container-footer":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\page-container\\page-container-footer\\index.js","../../../../components/ui/text-field":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\text-field\\index.js","../../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../contact-networks":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\contact-list-tab\\contact-networks.tsx","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Ccontact-list-tab%5Cedit-contact%5Cedit-contact.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = EditContact;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _designSystemReact = require("@metamask/design-system-react");
var _textField = _interopRequireDefault(require("../../../../components/ui/text-field"));
var _pageContainerFooter = _interopRequireDefault(require("../../../../components/ui/page-container/page-container-footer"));
var _preferredAvatar = require("../../../../components/app/preferred-avatar");
var _hexstringUtils = require("../../../../../shared/modules/hexstring-utils");
var _componentLibrary = require("../../../../components/component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _utils = require("../../../../components/app/contact-list/utils");
var _multichain = require("../../../../selectors/multichain");
var _i18n = require("../../../../contexts/i18n");
var _contactNetworks = require("../contact-networks");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function EditContact({
  addressBook,
  internalAccounts,
  networkConfigurations,
  addToAddressBook,
  removeFromAddressBook,
  name = '',
  address,
  contactChainId,
  memo = '',
  viewRoute,
  listRoute
}) {
  var _networks$selectedCha, _networks$selectedCha2;
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const navigate = (0, _reactRouterDomV5Compat.useNavigate)();
  const [contactName, setContactName] = (0, _react.useState)(name);
  const [newAddress, setNewAddress] = (0, _react.useState)(address);
  const [newMemo, setNewMemo] = (0, _react.useState)(memo);
  const [nameError, setNameError] = (0, _react.useState)('');
  const [addressError, setAddressError] = (0, _react.useState)('');
  const [showModal, setShowModal] = (0, _react.useState)(false);
  const [selectedChainId, setSelectedChainId] = (0, _react.useState)(contactChainId);
  const networks = networkConfigurations;
  const validateName = nameValue => {
    if (nameValue === name) {
      return true;
    }
    return !(0, _utils.isDuplicateContact)(addressBook, internalAccounts, nameValue);
  };
  const handleNameChange = e => {
    const nameValue = e.target.value;
    setNameError(validateName(nameValue) ? '' : t('nameAlreadyInUse'));
    setContactName(nameValue);
  };
  if (!address) {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Navigate, {
      to: {
        pathname: listRoute
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "settings-page__content-row address-book__edit-contact",
    "data-testid": "edit-contact"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "settings-page__header address-book__header--edit",
    paddingLeft: 6,
    paddingRight: 6,
    width: _designSystem.BlockSize.Full,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    style: {
      overflow: 'hidden'
    },
    paddingRight: 2
  }, /*#__PURE__*/_react.default.createElement(_preferredAvatar.PreferredAvatar, {
    size: _designSystemReact.AvatarAccountSize.Lg,
    address: address
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    className: "address-book__header__name",
    variant: _designSystem.TextVariant.bodyLgMedium,
    marginInlineStart: 4,
    style: {
      overflow: 'hidden'
    },
    ellipsis: true
  }, name || address)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "settings-page__address-book-button"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    variant: _componentLibrary.ButtonVariant.Link,
    danger: true,
    style: {
      display: 'contents'
    },
    onClick: async () => {
      await removeFromAddressBook(contactChainId, address);
      navigate(listRoute);
    },
    "data-testid": "delete-contact-button"
  }, t('deleteContact')))), /*#__PURE__*/_react.default.createElement("div", {
    className: "address-book__edit-contact__content"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "address-book__view-contact__group",
    "data-testid": "edit-contact-alias"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "address-book__view-contact__group__label"
  }, t('userName')), /*#__PURE__*/_react.default.createElement(_textField.default, {
    id: "nickname",
    "data-testid": "address-book-edit-contact-name",
    placeholder: t('addAlias'),
    value: contactName,
    onChange: handleNameChange,
    error: nameError,
    fullWidth: true,
    className: "text-field-root",
    margin: "dense"
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "address-book__view-contact__group",
    "data-testid": "edit-contact-address"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "address-book__view-contact__group__label"
  }, t('ethereumPublicAddress')), /*#__PURE__*/_react.default.createElement(_textField.default, {
    id: "address",
    "data-testid": "address-book-edit-contact-address",
    value: newAddress,
    onChange: e => setNewAddress(e.target.value),
    error: addressError,
    fullWidth: true,
    multiline: true,
    className: "text-field-root",
    margin: "dense"
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "address-book__view-contact__group",
    "data-testid": "edit-contact-memo"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "address-book__view-contact__group__label--capitalized"
  }, t('memo')), /*#__PURE__*/_react.default.createElement(_textField.default, {
    id: "memo",
    placeholder: memo,
    value: newMemo,
    onChange: e => setNewMemo(e.target.value),
    fullWidth: true,
    multiline: true,
    className: "text-field-root",
    margin: "dense"
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "address-book__view-contact__group"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "address-book__view-contact__group__label"
  }, t('network')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    as: "button",
    padding: 3,
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    backgroundColor: _designSystem.BackgroundColor.transparent,
    borderColor: _designSystem.BorderColor.borderDefault,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    borderRadius: _designSystem.BorderRadius.XL,
    onClick: () => setShowModal(true),
    className: "network-selector",
    "data-testid": "network-selector",
    marginTop: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    gap: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
    size: _componentLibrary.AvatarNetworkSize.Sm,
    src: (0, _multichain.getImageForChainId)(selectedChainId) || undefined,
    name: networks === null || networks === void 0 || (_networks$selectedCha = networks[selectedChainId]) === null || _networks$selectedCha === void 0 ? void 0 : _networks$selectedCha.name
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    "data-testid": "address-book-edit-contact-network"
  }, networks === null || networks === void 0 || (_networks$selectedCha2 = networks[selectedChainId]) === null || _networks$selectedCha2 === void 0 ? void 0 : _networks$selectedCha2.name)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.ArrowDown,
    color: _designSystem.IconColor.iconDefault,
    size: _componentLibrary.IconSize.Sm
  })))), /*#__PURE__*/_react.default.createElement(_pageContainerFooter.default, {
    cancelText: t('cancel'),
    onSubmit: async () => {
      const isChainChanged = selectedChainId !== contactChainId;
      if (newAddress && newAddress !== address) {
        if (!(0, _hexstringUtils.isBurnAddress)(newAddress) && (0, _hexstringUtils.isValidHexAddress)(newAddress, {
          mixedCaseUseChecksum: true
        })) {
          await removeFromAddressBook(contactChainId, address);
          await addToAddressBook(newAddress, contactName || name, newMemo || memo, selectedChainId);
          navigate(listRoute);
        } else {
          setAddressError(t('invalidAddress'));
        }
      } else if (isChainChanged) {
        await removeFromAddressBook(contactChainId, address);
        await addToAddressBook(address, contactName || name, newMemo || memo, selectedChainId);
        navigate(listRoute);
      } else {
        await addToAddressBook(address, contactName || name, newMemo || memo, selectedChainId);
        navigate(listRoute);
      }
    },
    onCancel: () => navigate(`${viewRoute}/${address}`),
    submitText: t('save'),
    disabled: Boolean(contactName === name && newAddress === address && selectedChainId === contactChainId && newMemo === memo || !contactName.trim() || nameError)
  }), showModal && /*#__PURE__*/_react.default.createElement(_contactNetworks.ContactNetworks, {
    isOpen: true,
    onClose: () => setShowModal(false),
    selectedChainId: selectedChainId,
    onSelect: chainId => setSelectedChainId(chainId)
  }));
}
EditContact.propTypes = {
  addressBook: _propTypes.default.array,
  internalAccounts: _propTypes.default.array,
  networkConfigurations: _propTypes.default.array,
  addToAddressBook: _propTypes.default.func.isRequired,
  removeFromAddressBook: _propTypes.default.func.isRequired,
  name: _propTypes.default.string,
  address: _propTypes.default.string.isRequired,
  contactChainId: _propTypes.default.string,
  memo: _propTypes.default.string,
  viewRoute: _propTypes.default.string.isRequired,
  listRoute: _propTypes.default.string.isRequired
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\contact-list-tab\\edit-contact\\edit-contact.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\contact-list-tab\\edit-contact\\edit-contact.container.js", {"../../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../../helpers/higher-order-components/with-router-hooks/with-router-hooks":"D:\\code\\v\\metamask-extension\\ui\\helpers\\higher-order-components\\with-router-hooks\\with-router-hooks.tsx","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./edit-contact.component":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\contact-list-tab\\edit-contact\\edit-contact.component.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","redux":"D:\\code\\v\\metamask-extension\\node_modules\\redux\\lib\\redux.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Ccontact-list-tab%5Cedit-contact%5Cedit-contact.container.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _redux = require("redux");
var _reactRedux = require("react-redux");
var _withRouterHooks = _interopRequireDefault(require("../../../../helpers/higher-order-components/with-router-hooks/with-router-hooks"));
var _selectors = require("../../../../selectors");
var _networks = require("../../../../../shared/modules/selectors/networks");
var _routes = require("../../../../helpers/constants/routes");
var _actions = require("../../../../store/actions");
var _editContact = _interopRequireDefault(require("./edit-contact.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const mapStateToProps = (state, ownProps) => {
  var _getInternalAccountBy;
  const {
    location,
    params
  } = ownProps;
  const pathNameTail = location.pathname.match(/[^/]+$/u)[0];
  const pathNameTailIsAddress = pathNameTail.includes('0x');
  const address = pathNameTailIsAddress ? pathNameTail.toLowerCase() : params.id;
  const contact = (0, _selectors.getAddressBookEntry)(state, address);
  const networkConfigurations = (0, _networks.getNetworkConfigurationsByChainId)(state);
  const {
    memo
  } = contact || {};
  const name = (contact === null || contact === void 0 ? void 0 : contact.name) || ((_getInternalAccountBy = (0, _selectors.getInternalAccountByAddress)(state, address)) === null || _getInternalAccountBy === void 0 ? void 0 : _getInternalAccountBy.metadata.name);
  const {
    chainId
  } = (0, _networks.getProviderConfig)(state);
  const contactChainId = (contact === null || contact === void 0 ? void 0 : contact.chainId) || chainId;
  return {
    address: contact ? address : null,
    addressBook: (0, _selectors.getAddressBook)(state),
    internalAccounts: (0, _selectors.getInternalAccounts)(state),
    contactChainId,
    name,
    memo,
    networkConfigurations,
    viewRoute: _routes.CONTACT_VIEW_ROUTE,
    listRoute: _routes.CONTACT_LIST_ROUTE
  };
};
const mapDispatchToProps = dispatch => {
  return {
    addToAddressBook: (recipient, nickname, memo, customChainId) => dispatch((0, _actions.addToAddressBook)(recipient, nickname, memo, customChainId)),
    removeFromAddressBook: (chainId, addressToRemove) => dispatch((0, _actions.removeFromAddressBook)(chainId, addressToRemove)),
    toggleNetworkMenu: () => dispatch((0, _actions.toggleNetworkMenu)())
  };
};
var _default = exports.default = (0, _redux.compose)(_withRouterHooks.default, (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps))(_editContact.default);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\contact-list-tab\\edit-contact\\edit-contact.container.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\contact-list-tab\\edit-contact\\index.js", {"./edit-contact.container":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\contact-list-tab\\edit-contact\\edit-contact.container.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Ccontact-list-tab%5Cedit-contact%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _editContact.default;
  }
});
var _editContact = _interopRequireDefault(require("./edit-contact.container"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\contact-list-tab\\edit-contact\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\contact-list-tab\\index.js", {"./contact-list-tab.container":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\contact-list-tab\\contact-list-tab.container.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Ccontact-list-tab%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _contactListTab.default;
  }
});
var _contactListTab = _interopRequireDefault(require("./contact-list-tab.container"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\contact-list-tab\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\contact-list-tab\\view-contact\\index.js", {"./view-contact.container":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\contact-list-tab\\view-contact\\view-contact.container.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Ccontact-list-tab%5Cview-contact%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _viewContact.default;
  }
});
var _viewContact = _interopRequireDefault(require("./view-contact.container"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\contact-list-tab\\view-contact\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\contact-list-tab\\view-contact\\view-contact.component.js", {"../../../../components/app/preferred-avatar":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\preferred-avatar\\index.ts","../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../components/ui/tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\index.js","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useCopyToClipboard":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useCopyToClipboard.js","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Ccontact-list-tab%5Cview-contact%5Cview-contact.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _designSystemReact = require("@metamask/design-system-react");
var _componentLibrary = require("../../../../components/component-library");
var _preferredAvatar = require("../../../../components/app/preferred-avatar");
var _tooltip = _interopRequireDefault(require("../../../../components/ui/tooltip"));
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _useCopyToClipboard = require("../../../../hooks/useCopyToClipboard");
var _designSystem = require("../../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function quadSplit(address) {
  return `0x${address.slice(2).match(/.{1,4}/gu).join('')}`;
}
function ViewContact({
  navigate,
  name,
  address,
  checkSummedAddress,
  memo,
  editRoute,
  listRoute
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  const [copied, handleCopy] = (0, _useCopyToClipboard.useCopyToClipboard)();
  if (!address) {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Navigate, {
      to: {
        pathname: listRoute
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "settings-page__content-row"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "settings-page__content-item"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "settings-page__header address-book__header",
    paddingLeft: 6,
    paddingRight: 6
  }, /*#__PURE__*/_react.default.createElement(_preferredAvatar.PreferredAvatar, {
    size: _designSystemReact.AvatarAccountSize.Lg,
    address: address
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    className: "address-book__header__name",
    "data-testid": "address-book-name",
    variant: _designSystem.TextVariant.bodyLgMedium,
    marginInlineStart: 4,
    style: {
      overflow: 'hidden'
    },
    ellipsis: true
  }, name || address)), /*#__PURE__*/_react.default.createElement("div", {
    className: "address-book__view-contact__group"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    variant: _componentLibrary.ButtonVariant.Secondary,
    onClick: () => {
      navigate(`${editRoute}/${address}`);
    }
  }, t('edit'))), /*#__PURE__*/_react.default.createElement("div", {
    className: "address-book__view-contact__group"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "address-book__view-contact__group__label"
  }, t('ethereumPublicAddress')), /*#__PURE__*/_react.default.createElement("div", {
    className: "address-book__view-contact__group__value"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "address-book__view-contact__group__static-address",
    "data-testid": "address-book-view-contact-address"
  }, quadSplit(checkSummedAddress)), /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    position: "bottom",
    title: copied ? t('copiedExclamation') : t('copyToClipboard')
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    ariaLabel: "copy",
    className: "address-book__view-contact__group__static-address--copy-icon",
    onClick: () => {
      handleCopy(checkSummedAddress);
    },
    iconName: copied ? _componentLibrary.IconName.CopySuccess : _componentLibrary.IconName.Copy,
    size: _componentLibrary.ButtonIconSize.Lg,
    color: _designSystem.IconColor.primaryDefault
  })))), memo.length > 0 ? /*#__PURE__*/_react.default.createElement("div", {
    className: "address-book__view-contact__group"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "address-book__view-contact__group__label--capitalized"
  }, t('memo')), /*#__PURE__*/_react.default.createElement("div", {
    className: "address-book__view-contact__group__static-address"
  }, memo)) : null));
}
ViewContact.propTypes = {
  name: _propTypes.default.string,
  address: _propTypes.default.string,
  navigate: _propTypes.default.func.isRequired,
  checkSummedAddress: _propTypes.default.string,
  memo: _propTypes.default.string,
  editRoute: _propTypes.default.string,
  listRoute: _propTypes.default.string.isRequired
};
var _default = exports.default = /*#__PURE__*/_react.default.memo(ViewContact);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\contact-list-tab\\view-contact\\view-contact.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\contact-list-tab\\view-contact\\view-contact.container.js", {"../../../../../shared/modules/hexstring-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\hexstring-utils.ts","../../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../../helpers/higher-order-components/with-router-hooks/with-router-hooks":"D:\\code\\v\\metamask-extension\\ui\\helpers\\higher-order-components\\with-router-hooks\\with-router-hooks.tsx","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","./view-contact.component":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\contact-list-tab\\view-contact\\view-contact.component.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","redux":"D:\\code\\v\\metamask-extension\\node_modules\\redux\\lib\\redux.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Ccontact-list-tab%5Cview-contact%5Cview-contact.container.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _redux = require("redux");
var _reactRedux = require("react-redux");
var _withRouterHooks = _interopRequireDefault(require("../../../../helpers/higher-order-components/with-router-hooks/with-router-hooks"));
var _selectors = require("../../../../selectors");
var _routes = require("../../../../helpers/constants/routes");
var _hexstringUtils = require("../../../../../shared/modules/hexstring-utils");
var _viewContact = _interopRequireDefault(require("./view-contact.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const mapStateToProps = (state, ownProps) => {
  const {
    location,
    params
  } = ownProps;
  const pathNameTail = location.pathname.match(/[^/]+$/u)[0];
  const pathNameTailIsAddress = pathNameTail.includes('0x');
  const address = pathNameTailIsAddress ? pathNameTail.toLowerCase() : params.id;
  const internalAccount = (0, _selectors.getInternalAccountByAddress)(state, address);
  const contact = (0, _selectors.getAddressBookEntry)(state, address);
  const {
    memo
  } = contact || {};
  const name = (contact === null || contact === void 0 ? void 0 : contact.name) || internalAccount.metadata.name;
  return {
    name,
    address: contact ? address : null,
    checkSummedAddress: (0, _hexstringUtils.toChecksumHexAddress)(address),
    memo,
    editRoute: _routes.CONTACT_EDIT_ROUTE,
    listRoute: _routes.CONTACT_LIST_ROUTE
  };
};
var _default = exports.default = (0, _redux.compose)(_withRouterHooks.default, (0, _reactRedux.connect)(mapStateToProps))(_viewContact.default);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\contact-list-tab\\view-contact\\view-contact.container.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\deprecated-network-modal\\DeprecatedNetworkModal.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/zendesk-url":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\zendesk-url.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Cdeprecated-network-modal%5CDeprecatedNetworkModal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeprecatedNetworkModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _useI18nContext = require("../../../hooks/useI18nContext");
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _zendeskUrl = _interopRequireDefault(require("../../../helpers/constants/zendesk-url"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const DeprecatedNetworkModal = ({
  onClose
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: true,
    isClosedOnOutsideClick: false,
    onClose: onClose
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    paddingTop: 2,
    paddingBottom: 2
  }, t('deprecatedNetwork')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingBottom: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    textAlign: _designSystem.TextAlign.Center,
    variant: _designSystem.TextVariant.bodyMd,
    fontWeight: _designSystem.FontWeight.Normal
  }, t('deprecatedNetworkDescription', [/*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    key: "import-token-fake-token-warning",
    rel: "noopener noreferrer",
    target: "_blank",
    href: _zendeskUrl.default.NETWORK_DEPRECATED,
    variant: _designSystem.TextVariant.bodySm,
    fontWeight: _designSystem.FontWeight.Normal
  }, t('learnMoreUpperCase'))])))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    paddingLeft: 4,
    paddingRight: 4,
    paddingBottom: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonPrimary, {
    block: true,
    size: _componentLibrary.ButtonPrimarySize.Lg,
    onClick: onClose,
    textProps: {
      variant: _designSystem.TextVariant.bodyMdMedium
    },
    style: {
      fontSize: '14px'
    }
  }, t('deprecatedNetworkButtonMsg')))));
};
exports.DeprecatedNetworkModal = DeprecatedNetworkModal;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\deprecated-network-modal\\DeprecatedNetworkModal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\developer-options-tab\\backup-and-sync.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/identity/useAccountSyncing":"D:\\code\\v\\metamask-extension\\ui\\hooks\\identity\\useAccountSyncing\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Cdeveloper-options-tab%5Cbackup-and-sync.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeleteAccountSyncDataProps = exports.BackupAndSyncDevSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _useAccountSyncing = require("../../../hooks/identity/useAccountSyncing");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DeleteSyncedData = ({
  onDelete,
  deleteSuccessful,
  title,
  description
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "settings-page__content-padded"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "settings-page__content-row",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "settings-page__content-item"
  }, /*#__PURE__*/_react.default.createElement("span", null, title), /*#__PURE__*/_react.default.createElement("div", {
    className: "settings-page__content-description"
  }, description)), /*#__PURE__*/_react.default.createElement("div", {
    className: "settings-page__content-item-col"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    variant: _componentLibrary.ButtonVariant.Primary,
    onClick: onDelete
  }, "Reset")), /*#__PURE__*/_react.default.createElement("div", {
    className: "settings-page__content-item-col"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    paddingLeft: 2,
    paddingRight: 2,
    style: {
      height: '40px',
      width: '40px'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    className: "settings-page-developer-options__icon-check",
    name: _componentLibrary.IconName.Check,
    color: _designSystem.IconColor.successDefault,
    size: _componentLibrary.IconSize.Lg,
    hidden: !deleteSuccessful
  })))));
};
const useDeleteAccountSyncDataProps = () => {
  const [deleteSuccessful, setDeleteSuccessful] = (0, _react.useState)(false);
  const {
    dispatchDeleteAccountSyncingData
  } = (0, _useAccountSyncing.useDeleteAccountSyncingDataFromUserStorage)();
  const onDelete = (0, _react.useCallback)(async () => {
    await dispatchDeleteAccountSyncingData();
    setDeleteSuccessful(true);
  }, [dispatchDeleteAccountSyncingData, setDeleteSuccessful]);
  return {
    deleteSuccessful,
    onDelete,
    title: 'Account syncing',
    description: 'Deletes all user storage entries for the current SRP. This can help if you tested Account Syncing early on and have corrupted data. This will not remove internal accounts already created and renamed. If you want to start from scratch with only the first account and restart syncing from this point on, you will need to reinstall the extension after this action.'
  };
};
exports.useDeleteAccountSyncDataProps = useDeleteAccountSyncDataProps;
const BackupAndSyncDevSettings = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    className: "settings-page__security-tab-sub-header__bold"
  }, "Backup and sync"), /*#__PURE__*/_react.default.createElement(DeleteSyncedData, useDeleteAccountSyncDataProps()));
};
exports.BackupAndSyncDevSettings = BackupAndSyncDevSettings;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\developer-options-tab\\backup-and-sync.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\developer-options-tab\\developer-options-tab.tsx", {"../../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../helpers/utils/settings-search":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\settings-search.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./backup-and-sync":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\developer-options-tab\\backup-and-sync.tsx","./developer-options-toggle-row-component":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\developer-options-tab\\developer-options-toggle-row-component.tsx","./sentry-test":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\developer-options-tab\\sentry-test.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Cdeveloper-options-tab%5Cdeveloper-options-tab.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _routes = require("../../../helpers/constants/routes");
var _settingsSearch = require("../../../helpers/utils/settings-search");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _actions = require("../../../store/actions");
var _util = require("../../../../app/scripts/lib/util");
var _app = require("../../../../shared/constants/app");
var _selectors = require("../../../selectors");
var _developerOptionsToggleRowComponent = _interopRequireDefault(require("./developer-options-toggle-row-component"));
var _sentryTest = _interopRequireDefault(require("./sentry-test"));
var _backupAndSync = require("./backup-and-sync");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

/**
 * Settings Page for Developer Options (internal-only)
 *
 * This page does not need i18n translation support because it's an internal settings page.
 * We only support the t('developerOptions') translation because the general settings architecture
 * utilizes the translation key to render.
 *
 * @returns
 */
const DeveloperOptionsTab = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const navigate = (0, _reactRouterDomV5Compat.useNavigate)();
  const [hasResetAnnouncements, setHasResetAnnouncements] = (0, _react.useState)(false);
  const [hasResetOnboarding, setHasResetOnboarding] = (0, _react.useState)(false);
  const [isServiceWorkerKeptAlive, setIsServiceWorkerKeptAlive] = (0, _react.useState)(true);
  const settingsRefs = Array((0, _settingsSearch.getNumberOfSettingRoutesInTab)(t, t('developerOptions'))).fill(undefined).map(() => {
    return /*#__PURE__*/_react.default.createRef();
  });
  (0, _react.useEffect)(() => {
    (0, _settingsSearch.handleSettingsRefs)(t, t('developerOptions'), settingsRefs);
  }, [t, settingsRefs]);
  const handleResetAnnouncementClick = (0, _react.useCallback)(() => {
    (0, _actions.resetViewedNotifications)();
    setHasResetAnnouncements(true);
  }, []);
  const handleResetOnboardingClick = (0, _react.useCallback)(async () => {
    await dispatch((0, _actions.resetOnboarding)());
    setHasResetOnboarding(true);
    const backUpSRPRoute = `${_routes.ONBOARDING_REVIEW_SRP_ROUTE}/?isFromReminder=true`;
    const isPopup = (0, _util.getEnvironmentType)() === _app.ENVIRONMENT_TYPE_POPUP;
    if (isPopup) {
      const {
        platform
      } = global;
      if (platform !== null && platform !== void 0 && platform.openExtensionInBrowser) {
        platform === null || platform === void 0 || platform.openExtensionInBrowser(backUpSRPRoute, null, true);
      }
    } else {
      navigate(backUpSRPRoute);
    }
  }, [dispatch, navigate]);
  const handleToggleServiceWorkerAlive = async value => {
    await dispatch((0, _actions.setServiceWorkerKeepAlivePreference)(value));
    setIsServiceWorkerKeptAlive(value);
  };
  const renderAnnouncementReset = () => {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      ref: settingsRefs[1],
      className: "settings-page__content-row",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      justifyContent: _designSystem.JustifyContent.spaceBetween,
      gap: 4
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("span", null, "Announcements"), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-description"
    }, "Resets isShown boolean to false for all announcements. Announcements are the notifications shown in the What's New popup modal.")), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
      variant: _componentLibrary.ButtonVariant.Primary,
      onClick: handleResetAnnouncementClick
    }, "Reset")), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      alignItems: _designSystem.AlignItems.center,
      paddingLeft: 2,
      paddingRight: 2,
      style: {
        height: '40px',
        width: '40px'
      }
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
      className: "settings-page-developer-options__icon-check",
      name: _componentLibrary.IconName.Check,
      color: _designSystem.IconColor.successDefault,
      size: _componentLibrary.IconSize.Lg,
      hidden: !hasResetAnnouncements
    }))));
  };
  const renderOnboardingReset = () => {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      ref: settingsRefs[2],
      className: "settings-page__content-row",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      justifyContent: _designSystem.JustifyContent.spaceBetween,
      gap: 4
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item",
      style: {
        flex: '1 1 auto'
      }
    }, /*#__PURE__*/_react.default.createElement("span", null, "Onboarding"), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-description"
    }, "Resets various states related to onboarding and redirects to the \"Secure Your Wallet\" onboarding page.")), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
      variant: _componentLibrary.ButtonVariant.Primary
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
      // eslint-disable-next-line @typescript-eslint/no-misused-promises
      ,
      onClick: handleResetOnboardingClick
    }, "Reset")), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      alignItems: _designSystem.AlignItems.center,
      paddingLeft: 2,
      paddingRight: 2,
      style: {
        height: '40px',
        width: '40px'
      }
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
      className: "settings-page-developer-options__icon-check",
      name: _componentLibrary.IconName.Check,
      color: _designSystem.IconColor.successDefault,
      size: _componentLibrary.IconSize.Lg,
      hidden: !hasResetOnboarding
    }))));
  };
  const renderServiceWorkerKeepAliveToggle = () => {
    return /*#__PURE__*/_react.default.createElement(_developerOptionsToggleRowComponent.default, {
      title: "Service Worker Keep Alive",
      description: "Results in a timestamp being continuously saved to session.storage",
      isEnabled: isServiceWorkerKeptAlive
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
      // eslint-disable-next-line @typescript-eslint/no-misused-promises
      ,
      onToggle: value => handleToggleServiceWorkerAlive(!value),
      dataTestId: "developer-options-service-worker-alive-toggle",
      settingsRef: settingsRefs[3]
    });
  };
  const remoteFeatureFlags = (0, _reactRedux.useSelector)(_selectors.getRemoteFeatureFlags);
  const renderRemoteFeatureFlags = () => {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      className: "settings-page__content-row",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      justifyContent: _designSystem.JustifyContent.spaceBetween,
      gap: 4
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("span", null, "Remote feature flags"), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-description"
    }, "Remote feature flag values come from LaunchDarkly by default. If you need to update feature flag values locally for development purposes, you can change feature flag values in .manifest-overrides.json, which will override values coming from LaunchDarkly.")), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-description",
      "data-testid": "developer-options-remote-feature-flags"
    }, JSON.stringify(remoteFeatureFlags)));
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "settings-page__body"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    className: "settings-page__security-tab-sub-header__bold"
  }, "States"), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    className: "settings-page__security-tab-sub-header",
    color: _designSystem.TextColor.textAlternative,
    paddingTop: 6,
    ref: settingsRefs[0]
  }, "Current States"), /*#__PURE__*/_react.default.createElement("div", {
    className: "settings-page__content-padded"
  }, renderRemoteFeatureFlags()), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    className: "settings-page__security-tab-sub-header",
    color: _designSystem.TextColor.textAlternative,
    paddingTop: 6,
    ref: settingsRefs[0]
  }, "Reset States"), /*#__PURE__*/_react.default.createElement("div", {
    className: "settings-page__content-padded"
  }, renderAnnouncementReset(), renderOnboardingReset(), renderServiceWorkerKeepAliveToggle()), /*#__PURE__*/_react.default.createElement(_backupAndSync.BackupAndSyncDevSettings, null), /*#__PURE__*/_react.default.createElement(_sentryTest.default, null));
};
var _default = exports.default = DeveloperOptionsTab;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\developer-options-tab\\developer-options-tab.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\developer-options-tab\\developer-options-toggle-row-component.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/ui/toggle-button":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\toggle-button\\index.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Cdeveloper-options-tab%5Cdeveloper-options-toggle-row-component.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _toggleButton = _interopRequireDefault(require("../../../components/ui/toggle-button"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const ToggleRow = ({
  title,
  description,
  isEnabled,
  onToggle,
  dataTestId,
  settingsRef
}) => {
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    ref: settingsRef,
    className: "settings-page__content-row",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "settings-page__content-item"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "settings-page__content-description"
  }, /*#__PURE__*/_react.default.createElement("span", null, title), /*#__PURE__*/_react.default.createElement("div", {
    className: "settings-page__content-description"
  }, description))), /*#__PURE__*/_react.default.createElement("div", {
    className: "settings-page__content-item-col"
  }, /*#__PURE__*/_react.default.createElement(_toggleButton.default, {
    value: isEnabled,
    onToggle: onToggle,
    offLabel: "Off",
    onLabel: "On",
    dataTestId: dataTestId
  })));
};
var _default = exports.default = ToggleRow;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\developer-options-tab\\developer-options-toggle-row-component.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\developer-options-tab\\index.tsx", {"./developer-options-tab":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\developer-options-tab\\developer-options-tab.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Cdeveloper-options-tab%5Cindex.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _developerOptionsTab.default;
  }
});
var _developerOptionsTab = _interopRequireDefault(require("./developer-options-tab"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\developer-options-tab\\index.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\developer-options-tab\\sentry-test.tsx", {"../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../../shared/modules/i18n":"D:\\code\\v\\metamask-extension\\shared\\modules\\i18n.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/component-library/button/button.types":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\button\\button.types.ts","../../../ducks/locale/locale":"D:\\code\\v\\metamask-extension\\ui\\ducks\\locale\\locale.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Cdeveloper-options-tab%5Csentry-test.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _trace = require("../../../../shared/lib/trace");
var _button = require("../../../components/component-library/button/button.types");
var _actions = require("../../../store/actions");
var _i18n = require("../../../../shared/modules/i18n");
var _locale = require("../../../ducks/locale/locale");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function sleep(ms) {
  return new Promise(resolve => setTimeout(resolve, ms));
}
const SentryTest = () => {
  const currentLocale =
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  (0, _reactRedux.useSelector)(_locale.getCurrentLocale) || _i18n.FALLBACK_LOCALE;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    className: "settings-page__security-tab-sub-header__bold"
  }, "Sentry"), /*#__PURE__*/_react.default.createElement("div", {
    className: "settings-page__content-padded"
  }, /*#__PURE__*/_react.default.createElement(GenerateUIError, null), /*#__PURE__*/_react.default.createElement(GenerateBackgroundError, null), /*#__PURE__*/_react.default.createElement(CaptureUIError, null), /*#__PURE__*/_react.default.createElement(CaptureBackgroundError, null), /*#__PURE__*/_react.default.createElement(GenerateTrace, null), /*#__PURE__*/_react.default.createElement(GeneratePageCrash, {
    currentLocale: currentLocale
  })));
};

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function GenerateUIError() {
  const handleClick = (0, _react.useCallback)(async () => {
    var _window$stateHooks$th, _window$stateHooks;
    await ((_window$stateHooks$th = (_window$stateHooks = window.stateHooks).throwTestError) === null || _window$stateHooks$th === void 0 ? void 0 : _window$stateHooks$th.call(_window$stateHooks, 'Developer Options'));
  }, []);
  return /*#__PURE__*/_react.default.createElement(TestButton, {
    name: "Generate UI Error",
    description: /*#__PURE__*/_react.default.createElement("span", null, "Generate an unhandled ", /*#__PURE__*/_react.default.createElement("b", null, "TestError"), " in this window."),
    onClick: handleClick,
    expectError: true
  });
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function GenerateBackgroundError() {
  const handleClick = (0, _react.useCallback)(async () => {
    var _window$stateHooks$th2, _window$stateHooks2;
    await ((_window$stateHooks$th2 = (_window$stateHooks2 = window.stateHooks).throwTestBackgroundError) === null || _window$stateHooks$th2 === void 0 ? void 0 : _window$stateHooks$th2.call(_window$stateHooks2, 'Developer Options'));
  }, []);
  return /*#__PURE__*/_react.default.createElement(TestButton, {
    name: "Generate Background Error",
    description: /*#__PURE__*/_react.default.createElement("span", null, "Generate an unhandled ", /*#__PURE__*/_react.default.createElement("b", null, "TestError"), " in the service worker."),
    onClick: handleClick,
    expectError: true
  });
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function CaptureUIError() {
  const handleClick = (0, _react.useCallback)(async () => {
    var _window$stateHooks$ca, _window$stateHooks3;
    await ((_window$stateHooks$ca = (_window$stateHooks3 = window.stateHooks).captureTestError) === null || _window$stateHooks$ca === void 0 ? void 0 : _window$stateHooks$ca.call(_window$stateHooks3, 'Developer Options'));
  }, []);
  return /*#__PURE__*/_react.default.createElement(TestButton, {
    name: "Capture UI Error",
    description: /*#__PURE__*/_react.default.createElement("span", null, "Capture a ", /*#__PURE__*/_react.default.createElement("b", null, "TestError"), " in this window."),
    onClick: handleClick
  });
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function CaptureBackgroundError() {
  const handleClick = (0, _react.useCallback)(async () => {
    var _window$stateHooks$ca2, _window$stateHooks4;
    await ((_window$stateHooks$ca2 = (_window$stateHooks4 = window.stateHooks).captureBackgroundError) === null || _window$stateHooks$ca2 === void 0 ? void 0 : _window$stateHooks$ca2.call(_window$stateHooks4, 'Developer Options'));
  }, []);
  return /*#__PURE__*/_react.default.createElement(TestButton, {
    name: "Capture Background Error",
    description: /*#__PURE__*/_react.default.createElement("span", null, "Capture a ", /*#__PURE__*/_react.default.createElement("b", null, "TestError"), " in the service worker."),
    onClick: handleClick
  });
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function GenerateTrace() {
  const handleClick = (0, _react.useCallback)(async () => {
    await (0, _trace.trace)({
      name: _trace.TraceName.DeveloperTest,
      data: {
        'test.data.number': 123
      },
      tags: {
        'test.tag.number': 123
      }
    }, async context => {
      await (0, _trace.trace)({
        name: _trace.TraceName.NestedTest1,
        data: {
          'test.data.boolean': true
        },
        tags: {
          'test.tag.boolean': true
        },
        parentContext: context
      }, () => sleep(1000));
      await (0, _trace.trace)({
        name: _trace.TraceName.NestedTest2,
        data: {
          'test.data.string': 'test'
        },
        tags: {
          'test.tag.string': 'test'
        },
        parentContext: context
      }, () => sleep(500));
    });
  }, []);
  return /*#__PURE__*/_react.default.createElement(TestButton, {
    name: "Generate Trace",
    description: /*#__PURE__*/_react.default.createElement("span", null, "Generate a ", /*#__PURE__*/_react.default.createElement("b", null, "Developer Test"), " Sentry trace."),
    onClick: handleClick
  });
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function GeneratePageCrash({
  currentLocale
}) {
  const dispatch = (0, _reactRedux.useDispatch)();
  const handleClick = async () => {
    const localeMessages = await (0, _i18n.fetchLocale)(currentLocale);
    await dispatch((0, _actions.setCurrentLocale)(currentLocale, {
      ...localeMessages,
      // @ts-expect-error - remove a language string in this page to trigger a page crash
      developerOptions: undefined
    }));
    await (0, _actions.forceUpdateMetamaskState)(dispatch);
  };
  return /*#__PURE__*/_react.default.createElement(TestButton, {
    name: "Generate A Page Crash",
    description: /*#__PURE__*/_react.default.createElement("span", null, "Trigger the crash on extension to send user feedback to sentry. You can click \"Try again\" to reload extension"),
    onClick: handleClick,
    expectError: true,
    testId: "developer-options-generate-page-crash-button"
  });
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function TestButton({
  name,
  description,
  onClick,
  expectError,
  testId
}) {
  const [isComplete, setIsComplete] = (0, _react.useState)(false);
  const handleClick = (0, _react.useCallback)(async () => {
    let hasError = false;
    try {
      await onClick();
    } catch (error) {
      hasError = true;
      throw error;
    } finally {
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
      // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
      if (expectError || !hasError) {
        setIsComplete(true);
      }
    }
  }, [onClick]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "settings-page__content-row",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "settings-page__content-item"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "settings-page__content-description"
  }, description)), /*#__PURE__*/_react.default.createElement("div", {
    className: "settings-page__content-item-col"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    variant: _componentLibrary.ButtonVariant.Primary
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    ,
    onClick: handleClick,
    size: _button.ButtonSize.Lg,
    "data-testid": testId
  }, name)), /*#__PURE__*/_react.default.createElement("div", {
    className: "settings-page__content-item-col"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    paddingLeft: 2,
    paddingRight: 2,
    style: {
      height: '40px',
      width: '40px'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    className: "settings-page-developer-options__icon-check",
    name: _componentLibrary.IconName.Check,
    color: _designSystem.IconColor.successDefault,
    size: _componentLibrary.IconSize.Lg,
    hidden: !isComplete
  }))));
}
var _default = exports.default = SentryTest;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\developer-options-tab\\sentry-test.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\experimental-tab\\experimental-tab.component.tsx", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/ui/toggle-button":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\toggle-button\\index.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/settings-search":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\settings-search.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Cexperimental-tab%5Cexperimental-tab.component.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _toggleButton = _interopRequireDefault(require("../../../components/ui/toggle-button"));
var _settingsSearch = require("../../../helpers/utils/settings-search");
var _metametrics = require("../../../../shared/constants/metametrics");
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } ///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
///: END:ONLY_INCLUDE_IF
class ExperimentalTab extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "settingsRefs", Array((0, _settingsSearch.getNumberOfSettingRoutesInTab)(this.context.t, this.context.t('experimental'))).fill(undefined).map(() => {
      return /*#__PURE__*/_react.default.createRef();
    }));
  }
  componentDidUpdate() {
    const {
      t
    } = this.context;
    (0, _settingsSearch.handleSettingsRefs)(t, t('experimental'), this.settingsRefs);
  }
  componentDidMount() {
    const {
      t
    } = this.context;
    (0, _settingsSearch.handleSettingsRefs)(t, t('experimental'), this.settingsRefs);
  }
  renderToggleSection({
    title,
    description,
    toggleValue,
    toggleCallback,
    toggleDataTestId,
    toggleContainerDataTestId,
    toggleOffLabel,
    toggleOnLabel
  }) {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      ref: this.settingsRefs[0],
      className: "settings-page__content-row settings-page__content-row-experimental"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("span", null, title), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-description"
    }, description)), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col",
      "data-testid": toggleContainerDataTestId
    }, /*#__PURE__*/_react.default.createElement(_toggleButton.default, {
      value: toggleValue,
      onToggle: toggleCallback,
      offLabel: toggleOffLabel,
      onLabel: toggleOnLabel,
      dataTestId: toggleDataTestId
    })));
  }

  ///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
  renderKeyringSnapsToggle() {
    const {
      t,
      trackEvent
    } = this.context;
    const {
      addSnapAccountEnabled,
      setAddSnapAccountEnabled
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.headingSm,
      as: "h4",
      color: _designSystem.TextColor.textAlternative,
      marginBottom: 2,
      fontWeight: _designSystem.FontWeight.Bold
    }, t('snaps')), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("span", null, t('snapAccounts')), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-description"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodySm,
      as: "h6",
      color: _designSystem.TextColor.textAlternative
    }, t('snapAccountsDescription')))), this.renderToggleSection({
      title: t('addSnapAccountToggle'),
      description: t('addSnapAccountsDescription'),
      toggleValue: addSnapAccountEnabled,
      toggleCallback: value => {
        trackEvent({
          event: _metametrics.MetaMetricsEventName.AddSnapAccountEnabled,
          category: _metametrics.MetaMetricsEventCategory.Settings,
          properties: {
            enabled: !value
          }
        });
        setAddSnapAccountEnabled(!value);
      },
      toggleContainerDataTestId: 'add-account-snap-toggle-div',
      toggleDataTestId: 'add-account-snap-toggle-button',
      toggleOffLabel: t('off'),
      toggleOnLabel: t('on')
    }));
  }
  ///: END:ONLY_INCLUDE_IF

  renderNotificationsToggle() {
    const {
      t
    } = this.context;
    const {
      featureNotificationsEnabled,
      setFeatureNotificationsEnabled
    } = this.props;
    return this.renderToggleSection({
      title: t('notificationsFeatureToggle'),
      description: t('notificationsFeatureToggleDescription'),
      toggleValue: featureNotificationsEnabled,
      toggleCallback: value => setFeatureNotificationsEnabled(!value),
      toggleDataTestId: 'toggle-notifications',
      toggleOffLabel: t('off'),
      toggleOnLabel: t('on')
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__body"
    }, "" ? this.renderNotificationsToggle() : null,
    ///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
    this.renderKeyringSnapsToggle()
    ///: END:ONLY_INCLUDE_IF
    );
  }
}
exports.default = ExperimentalTab;
_defineProperty(ExperimentalTab, "contextTypes", {
  t: _propTypes.default.func,
  trackEvent: _propTypes.default.func
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\experimental-tab\\experimental-tab.component.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\experimental-tab\\experimental-tab.container.ts", {"../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./experimental-tab.component":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\experimental-tab\\experimental-tab.component.tsx","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js","redux":"D:\\code\\v\\metamask-extension\\node_modules\\redux\\lib\\redux.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Cexperimental-tab%5Cexperimental-tab.container.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _redux = require("redux");
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _actions = require("../../../store/actions");
var _selectors = require("../../../selectors");
var _experimentalTab = _interopRequireDefault(require("./experimental-tab.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const mapStateToProps = state => {
  const featureNotificationsEnabled = (0, _selectors.getFeatureNotificationsEnabled)(state);
  return {
    watchAccountEnabled: (0, _selectors.getIsWatchEthereumAccountEnabled)(state),
    ///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
    addSnapAccountEnabled: (0, _selectors.getIsAddSnapAccountEnabled)(state),
    ///: END:ONLY_INCLUDE_IF
    featureNotificationsEnabled
  };
};
const mapDispatchToProps = dispatch => {
  return {
    setWatchAccountEnabled: value => (0, _actions.setWatchEthereumAccountEnabled)(value),
    ///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
    setAddSnapAccountEnabled: value => (0, _actions.setAddSnapAccountEnabled)(value),
    ///: END:ONLY_INCLUDE_IF
    setFeatureNotificationsEnabled: value => {
      return dispatch((0, _actions.setFeatureNotificationsEnabled)(value));
    }
  };
};
var _default = exports.default = (0, _redux.compose)(_reactRouterDom.withRouter, (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps))(_experimentalTab.default);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\experimental-tab\\experimental-tab.container.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\experimental-tab\\index.js", {"./experimental-tab.container":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\experimental-tab\\experimental-tab.container.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Cexperimental-tab%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _experimentalTab.default;
  }
});
var _experimentalTab = _interopRequireDefault(require("./experimental-tab.container"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\experimental-tab\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\index.js", {"./settings.container":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\settings.container.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _settings.default;
  }
});
var _settings = _interopRequireDefault(require("./settings.container"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\info-tab\\index.js", {"./info-tab.component":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\info-tab\\info-tab.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Cinfo-tab%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _infoTab.default;
  }
});
var _infoTab = _interopRequireDefault(require("./info-tab.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\info-tab\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\info-tab\\info-tab.component.js", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../components/app/modals/visit-support-data-consent-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\visit-support-data-consent-modal\\index.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/ui/button":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\button\\index.js","../../../helpers/constants/common":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\common.ts","../../../helpers/utils/build-types":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\build-types.js","../../../helpers/utils/settings-search":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\settings-search.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Cinfo-tab%5Cinfo-tab.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _button = _interopRequireDefault(require("../../../components/ui/button"));
var _componentLibrary = require("../../../components/component-library");
var _common = require("../../../helpers/constants/common");
var _buildTypes = require("../../../helpers/utils/build-types");
var _settingsSearch = require("../../../helpers/utils/settings-search");
var _metametrics = require("../../../../shared/constants/metametrics");
var _visitSupportDataConsentModal = _interopRequireDefault(require("../../../components/app/modals/visit-support-data-consent-modal"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class InfoTab extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "state", {
      version: "13.6.0",
      isVisitSupportDataConsentModalOpen: false
    });
    _defineProperty(this, "settingsRefs", Array((0, _settingsSearch.getNumberOfSettingRoutesInTab)(this.context.t, this.context.t('about'))).fill(undefined).map(() => {
      return /*#__PURE__*/_react.default.createRef();
    }));
    _defineProperty(this, "toggleVisitSupportDataConsentModal", () => {
      this.setState(prevState => ({
        isVisitSupportDataConsentModalOpen: !prevState.isVisitSupportDataConsentModalOpen
      }));
    });
  }
  componentDidUpdate() {
    const {
      t
    } = this.context;
    (0, _settingsSearch.handleSettingsRefs)(t, t('about'), this.settingsRefs);
  }
  componentDidMount() {
    const {
      t
    } = this.context;
    (0, _settingsSearch.handleSettingsRefs)(t, t('about'), this.settingsRefs);
  }
  renderInfoLinks() {
    const {
      t
    } = this.context;
    const privacyUrl = 'https://metamask.io/privacy.html';
    const siteUrl = 'https://metamask.io/';
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item settings-page__content-item--without-height"
    }, /*#__PURE__*/_react.default.createElement("div", {
      ref: this.settingsRefs[1],
      className: "info-tab__link-header"
    }, t('links')), /*#__PURE__*/_react.default.createElement("div", {
      ref: this.settingsRefs[2],
      className: "info-tab__link-item"
    }, /*#__PURE__*/_react.default.createElement(_button.default, {
      type: "link",
      href: privacyUrl,
      target: "_blank",
      rel: "noopener noreferrer",
      className: "info-tab__link-text"
    }, t('privacyMsg'))), /*#__PURE__*/_react.default.createElement("div", {
      ref: this.settingsRefs[3],
      className: "info-tab__link-item"
    }, /*#__PURE__*/_react.default.createElement(_button.default, {
      type: "link",
      href: "https://metamask.io/terms.html",
      target: "_blank",
      rel: "noopener noreferrer",
      className: "info-tab__link-text"
    }, t('terms'))), (0, _buildTypes.isBeta)() ? /*#__PURE__*/_react.default.createElement("div", {
      ref: this.settingsRefs[8],
      className: "info-tab__link-item"
    }, /*#__PURE__*/_react.default.createElement(_button.default, {
      type: "link",
      href: "https://metamask.io/beta-terms.html",
      target: "_blank",
      rel: "noopener noreferrer",
      className: "info-tab__link-text"
    }, t('betaTerms'), /*#__PURE__*/_react.default.createElement(_componentLibrary.Tag, {
      label: t('new'),
      className: "info-tab__tag"
    }))) : null, /*#__PURE__*/_react.default.createElement("div", {
      ref: this.settingsRefs[4],
      className: "info-tab__link-item"
    }, /*#__PURE__*/_react.default.createElement(_button.default, {
      type: "link",
      href: `https://raw.githubusercontent.com/MetaMask/metamask-extension/v${this.state.version}/attribution.txt`,
      target: "_blank",
      rel: "noopener noreferrer",
      className: "info-tab__link-text"
    }, t('attributions'))), /*#__PURE__*/_react.default.createElement("hr", {
      className: "info-tab__separator"
    }), /*#__PURE__*/_react.default.createElement("div", {
      ref: this.settingsRefs[5],
      className: "info-tab__link-item"
    }, /*#__PURE__*/_react.default.createElement(_button.default, {
      type: "link",
      target: "_blank",
      rel: "noopener noreferrer",
      className: "info-tab__link-text",
      onClick: this.toggleVisitSupportDataConsentModal
    }, t('supportCenter'))), /*#__PURE__*/_react.default.createElement("div", {
      ref: this.settingsRefs[6],
      className: "info-tab__link-item"
    }, /*#__PURE__*/_react.default.createElement(_button.default, {
      type: "link",
      href: siteUrl,
      target: "_blank",
      rel: "noopener noreferrer",
      className: "info-tab__link-text"
    }, t('visitWebSite'))), /*#__PURE__*/_react.default.createElement("div", {
      ref: this.settingsRefs[7],
      className: "info-tab__link-item"
    }, /*#__PURE__*/_react.default.createElement(_button.default, {
      type: "link",
      href: _common.SUPPORT_REQUEST_LINK,
      target: "_blank",
      rel: "noopener noreferrer",
      className: "info-tab__link-text",
      onClick: () => {
        this.context.trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Settings,
          event: _metametrics.MetaMetricsEventName.SupportLinkClicked,
          properties: {
            url: _common.SUPPORT_REQUEST_LINK
          }
        }, {
          contextPropsIntoEventProperties: [_metametrics.MetaMetricsContextProp.PageTitle]
        });
      }
    }, t('contactUs'))));
  }
  render() {
    const {
      t
    } = this.context;
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__body"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-row"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item settings-page__content-item--without-height"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "info-tab__item"
    }, /*#__PURE__*/_react.default.createElement("div", {
      ref: this.settingsRefs[0],
      className: "info-tab__version-header"
    }, (0, _buildTypes.isBeta)() ? t('betaMetamaskVersion') : t('metamaskVersion')), /*#__PURE__*/_react.default.createElement("div", {
      className: "info-tab__version-number"
    }, this.state.version)), /*#__PURE__*/_react.default.createElement("div", {
      className: "info-tab__item"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "info-tab__about"
    }, t('builtAroundTheWorld')))), this.renderInfoLinks()), /*#__PURE__*/_react.default.createElement("div", {
      className: "info-tab__logo-wrapper"
    }, /*#__PURE__*/_react.default.createElement("img", {
      src: "./images/logo/metamask-fox.svg",
      className: "info-tab__logo",
      alt: "MetaMask Logo"
    })), this.state.isVisitSupportDataConsentModalOpen && /*#__PURE__*/_react.default.createElement(_visitSupportDataConsentModal.default, {
      isOpen: this.state.isVisitSupportDataConsentModalOpen,
      onClose: this.toggleVisitSupportDataConsentModal
    }));
  }
}
exports.default = InfoTab;
_defineProperty(InfoTab, "contextTypes", {
  t: _propTypes.default.func,
  trackEvent: _propTypes.default.func
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\info-tab\\info-tab.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\networks-tab\\networks-form\\index.js", {"./networks-form":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\networks-tab\\networks-form\\networks-form.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Cnetworks-tab%5Cnetworks-form%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _networksForm.default;
  }
});
var _networksForm = _interopRequireDefault(require("./networks-form"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\networks-tab\\networks-form\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\networks-tab\\networks-form\\networks-form-state.ts", {"../../../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Cnetworks-tab%5Cnetworks-form%5Cnetworks-form-state.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNetworkFormState = void 0;
var _react = require("react");
var _conversion = require("../../../../../shared/modules/conversion.utils");
/**
 * State backing the add/edit network form
 *
 * @param existingNetwork
 */
const useNetworkFormState = existingNetwork => {
  const [name, setName] = (0, _react.useState)('');
  const [chainId, setChainId] = (0, _react.useState)('');
  const [ticker, setTicker] = (0, _react.useState)('');
  const [rpcUrls, setRpcUrls] = (0, _react.useState)({
    rpcEndpoints: [],
    defaultRpcEndpointIndex: undefined
  });
  const [blockExplorers, setBlockExplorers] = (0, _react.useState)({
    blockExplorerUrls: [],
    defaultBlockExplorerUrlIndex: undefined
  });
  (0, _react.useEffect)(() => {
    setName((existingNetwork === null || existingNetwork === void 0 ? void 0 : existingNetwork.name) ?? '');
    setChainId(existingNetwork ? (0, _conversion.hexToDecimal)(existingNetwork.chainId) : '');
    setTicker((existingNetwork === null || existingNetwork === void 0 ? void 0 : existingNetwork.nativeCurrency) ?? '');
    setRpcUrls({
      rpcEndpoints: (existingNetwork === null || existingNetwork === void 0 ? void 0 : existingNetwork.rpcEndpoints) ?? [],
      defaultRpcEndpointIndex: existingNetwork === null || existingNetwork === void 0 ? void 0 : existingNetwork.defaultRpcEndpointIndex
    });
    setBlockExplorers({
      blockExplorerUrls: (existingNetwork === null || existingNetwork === void 0 ? void 0 : existingNetwork.blockExplorerUrls) ?? [],
      defaultBlockExplorerUrlIndex: existingNetwork === null || existingNetwork === void 0 ? void 0 : existingNetwork.defaultBlockExplorerUrlIndex
    });
  }, [existingNetwork === null || existingNetwork === void 0 ? void 0 : existingNetwork.chainId]);
  return {
    name,
    setName,
    chainId,
    setChainId,
    ticker,
    setTicker,
    rpcUrls,
    setRpcUrls,
    blockExplorers,
    setBlockExplorers,
    clear: () => {
      setName('');
      setChainId('');
      setTicker('');
      setRpcUrls({
        rpcEndpoints: [],
        defaultRpcEndpointIndex: undefined
      });
      setBlockExplorers({
        blockExplorerUrls: [],
        defaultBlockExplorerUrlIndex: undefined
      });
    }
  };
};
exports.useNetworkFormState = useNetworkFormState;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\networks-tab\\networks-form\\networks-form-state.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\networks-tab\\networks-form\\networks-form.tsx", {"../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../../shared/lib/only-keep-host":"D:\\code\\v\\metamask-extension\\shared\\lib\\only-keep-host.ts","../../../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../../../../shared/modules/network.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\network.utils.ts","../../../../../shared/modules/rpc.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\rpc.utils.js","../../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../components/multichain/dropdown-editor/dropdown-editor":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\dropdown-editor\\dropdown-editor.tsx","../../../../components/multichain/network-list-menu/rpc-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-menu\\rpc-list-item.tsx","../../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./use-safe-chains":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\networks-tab\\networks-form\\use-safe-chains.ts","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/network-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\network-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Cnetworks-tab%5Cnetworks-form%5Cnetworks-form.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.NetworksForm = void 0;
var _loglevel = _interopRequireDefault(require("loglevel"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _networkController = require("@metamask/network-controller");
var _utils = require("@metamask/utils");
var _controllerUtils = require("@metamask/controller-utils");
var _metametrics = require("../../../../../shared/constants/metametrics");
var _network = require("../../../../../shared/constants/network");
var _conversion = require("../../../../../shared/modules/conversion.utils");
var _network2 = require("../../../../../shared/modules/network.utils");
var _rpc = require("../../../../../shared/modules/rpc.utils");
var _metametrics2 = require("../../../../contexts/metametrics");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _networks = require("../../../../../shared/modules/selectors/networks");
var _actions = require("../../../../store/actions");
var _componentLibrary = require("../../../../components/component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _rpcListItem = _interopRequireWildcard(require("../../../../components/multichain/network-list-menu/rpc-list-item"));
var _dropdownEditor = require("../../../../components/multichain/dropdown-editor/dropdown-editor");
var _selectors = require("../../../../selectors");
var _onlyKeepHost = require("../../../../../shared/lib/only-keep-host");
var _useSafeChains = require("./use-safe-chains");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const NetworksForm = ({
  networkFormState,
  existingNetwork,
  onRpcAdd,
  onBlockExplorerAdd,
  toggleNetworkMenuAfterSubmit = true,
  onComplete,
  onEdit
}) => {
  var _warnings$name, _warnings$name2, _errors$rpcUrl, _errors$rpcUrl2, _errors$chainId, _errors$chainId2, _warnings$ticker, _rpcUrls$rpcEndpoints4;
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const scrollableRef = (0, _react.useRef)(null);
  const networkConfigurations = (0, _reactRedux.useSelector)(_networks.getNetworkConfigurationsByChainId);
  const isRpcFailoverEnabled = (0, _reactRedux.useSelector)(_selectors.getIsRpcFailoverEnabled);
  const {
    name,
    setName,
    chainId,
    setChainId,
    ticker,
    setTicker,
    rpcUrls,
    setRpcUrls,
    blockExplorers,
    setBlockExplorers
  } = networkFormState;
  const defaultRpcEndpoint = rpcUrls.defaultRpcEndpointIndex === undefined ? undefined : rpcUrls.rpcEndpoints[rpcUrls.defaultRpcEndpointIndex];
  const {
    safeChains
  } = (0, _useSafeChains.useSafeChains)();
  const [errors, setErrors] = (0, _react.useState)({});
  const [warnings, setWarnings] = (0, _react.useState)({});
  const [suggestedName, setSuggestedName] = (0, _react.useState)();
  const [suggestedTicker, setSuggestedTicker] = (0, _react.useState)();
  const [fetchedChainId, setFetchedChainId] = (0, _react.useState)();
  const tokenNetworkFilter = (0, _reactRedux.useSelector)(_selectors.getTokenNetworkFilter);
  const templateInfuraRpc = endpoint => endpoint.endsWith('{infuraProjectId}') ? endpoint.replace('{infuraProjectId}', _network.infuraProjectId ?? '') : endpoint;

  // Validate the network name when it changes
  (0, _react.useEffect)(() => {
    var _NETWORKS_BYPASSING_V, _safeChains$find;
    const chainIdHex = chainId ? toHex(chainId) : undefined;
    const expectedName = chainIdHex ? _network.NETWORK_TO_NAME_MAP[chainIdHex] ?? ((_NETWORKS_BYPASSING_V = _controllerUtils.NETWORKS_BYPASSING_VALIDATION[chainIdHex]) === null || _NETWORKS_BYPASSING_V === void 0 ? void 0 : _NETWORKS_BYPASSING_V.name) ?? (safeChains === null || safeChains === void 0 || (_safeChains$find = safeChains.find(chain => toHex(chain.chainId) === chainIdHex)) === null || _safeChains$find === void 0 ? void 0 : _safeChains$find.name) : undefined;
    const mismatch = expectedName && expectedName !== name;
    setSuggestedName(mismatch ? expectedName : undefined);
    setWarnings(state => ({
      ...state,
      name: mismatch ? {
        key: 'wrongNetworkName',
        msg: t('wrongNetworkName')
      } : undefined
    }));
  }, [chainId, name, safeChains]);

  // Validate the ticker when it changes
  (0, _react.useEffect)(() => {
    var _safeChains$find2, _NETWORKS_BYPASSING_V2;
    const chainIdHex = chainId ? toHex(chainId) : undefined;
    const expectedSymbol = chainIdHex ? _network.CHAIN_ID_TO_CURRENCY_SYMBOL_MAP[chainIdHex] ?? (safeChains === null || safeChains === void 0 || (_safeChains$find2 = safeChains.find(chain => toHex(chain.chainId) === chainIdHex)) === null || _safeChains$find2 === void 0 || (_safeChains$find2 = _safeChains$find2.nativeCurrency) === null || _safeChains$find2 === void 0 ? void 0 : _safeChains$find2.symbol) : undefined;
    const isWhitelistedSymbol = chainIdHex ? ((_NETWORKS_BYPASSING_V2 = _controllerUtils.NETWORKS_BYPASSING_VALIDATION[chainIdHex]) === null || _NETWORKS_BYPASSING_V2 === void 0 || (_NETWORKS_BYPASSING_V2 = _NETWORKS_BYPASSING_V2.symbol) === null || _NETWORKS_BYPASSING_V2 === void 0 ? void 0 : _NETWORKS_BYPASSING_V2.toLowerCase()) === (ticker === null || ticker === void 0 ? void 0 : ticker.toLowerCase()) : false;
    const mismatch = expectedSymbol && expectedSymbol !== ticker && !isWhitelistedSymbol;
    setSuggestedTicker(mismatch ? expectedSymbol : undefined);
    setWarnings(state => ({
      ...state,
      ticker: mismatch ? {
        key: 'chainListReturnedDifferentTickerSymbol',
        msg: t('chainListReturnedDifferentTickerSymbol')
      } : undefined
    }));
  }, [chainId, ticker, safeChains]);

  // Validate the chain ID when it changes
  (0, _react.useEffect)(() => {
    let error;
    if (chainId === undefined || chainId === '') {
      error = undefined;
    } else if (chainId.startsWith('0x')) {
      if (!/^0x[0-9a-f]+$/iu.test(chainId)) {
        error = ['invalidHexNumber', t('invalidHexNumber')];
      } else if (!(0, _network2.isPrefixedFormattedHexString)(chainId)) {
        error = ['invalidHexNumber', t('invalidHexNumberLeadingZeros')];
      }
    } else if (!/^[0-9]+$/u.test(chainId)) {
      error = ['invalidNumber', t('invalidNumber')];
    } else if (chainId.startsWith('0')) {
      error = ['invalidNumberLeadingZeros', t('invalidNumberLeadingZeros')];
    }
    if (chainId && !error && !(0, _network2.isSafeChainId)(parseInt(chainId, chainId.startsWith('0x') ? 16 : 10))) {
      error = ['invalidChainIdTooBig', t('invalidChainIdTooBig')];
    }
    const chainIdHex = toHex(chainId);
    if (!error && !existingNetwork) {
      const matchingNetwork = chainIdHex ? networkConfigurations[chainIdHex] : undefined;
      if (matchingNetwork) {
        error = ['existingChainId', t('chainIdExistsErrorMsg', [matchingNetwork.name])];
      }
    }
    let rpcError;
    if (fetchedChainId && chainIdHex && fetchedChainId !== chainIdHex) {
      rpcError = ['endpointReturnedDifferentChainId', t('endpointReturnedDifferentChainId', [(0, _conversion.hexToDecimal)(fetchedChainId)])];
    }
    setErrors(state => ({
      ...state,
      chainId: error ? {
        key: error[0],
        msg: error[1]
      } : undefined,
      rpcUrl: rpcError ? {
        key: rpcError[0],
        msg: rpcError[1]
      } : undefined
    }));
  }, [chainId, fetchedChainId, existingNetwork === null || existingNetwork === void 0 ? void 0 : existingNetwork.chainId]);

  // Fetch the chain ID from the RPC endpoint when it changes
  (0, _react.useEffect)(() => {
    var _rpcUrls$rpcEndpoints;
    const rpcUrl = rpcUrls === null || rpcUrls === void 0 || (_rpcUrls$rpcEndpoints = rpcUrls.rpcEndpoints) === null || _rpcUrls$rpcEndpoints === void 0 || (_rpcUrls$rpcEndpoints = _rpcUrls$rpcEndpoints[(rpcUrls === null || rpcUrls === void 0 ? void 0 : rpcUrls.defaultRpcEndpointIndex) ?? -1]) === null || _rpcUrls$rpcEndpoints === void 0 ? void 0 : _rpcUrls$rpcEndpoints.url;
    if (rpcUrl) {
      (0, _rpc.jsonRpcRequest)(templateInfuraRpc(rpcUrl), 'eth_chainId').then(response => {
        setFetchedChainId(response);
      }).catch(err => {
        setFetchedChainId(undefined);
        _loglevel.default.warn('Failed to fetch the chainId from the endpoint.', err);
        setErrors(state => ({
          ...state,
          rpcUrl: {
            key: 'failedToFetchChainId',
            msg: t('failedToFetchChainId')
          }
        }));
      });
    }
  }, [chainId, rpcUrls]);
  const onSubmit = async () => {
    try {
      const chainIdHex = chainId ? toHex(chainId) : undefined;
      if (chainIdHex === _network.CHAIN_IDS.GOERLI) {
        dispatch((0, _actions.showDeprecatedNetworkModal)());
      } else if (chainIdHex) {
        var _blockExplorers$block, _rpcUrls$rpcEndpoints2;
        const networkPayload = {
          chainId: chainIdHex,
          name,
          nativeCurrency: ticker,
          rpcEndpoints: rpcUrls === null || rpcUrls === void 0 ? void 0 : rpcUrls.rpcEndpoints,
          defaultRpcEndpointIndex: (rpcUrls === null || rpcUrls === void 0 ? void 0 : rpcUrls.defaultRpcEndpointIndex) ?? 0,
          blockExplorerUrls: blockExplorers === null || blockExplorers === void 0 ? void 0 : blockExplorers.blockExplorerUrls,
          defaultBlockExplorerUrlIndex: blockExplorers === null || blockExplorers === void 0 ? void 0 : blockExplorers.defaultBlockExplorerUrlIndex
        };
        if (existingNetwork) {
          const options = {
            replacementSelectedRpcEndpointIndex: chainIdHex === existingNetwork.chainId ? rpcUrls === null || rpcUrls === void 0 ? void 0 : rpcUrls.defaultRpcEndpointIndex : undefined
          };
          await dispatch((0, _actions.updateNetwork)(networkPayload, options));
          if (Object.keys(tokenNetworkFilter).length === 1) {
            await dispatch((0, _actions.setTokenNetworkFilter)({
              [existingNetwork.chainId]: true
            }));
            await dispatch((0, _actions.setEnabledNetworks)(existingNetwork.chainId));
          }
        } else {
          await dispatch((0, _actions.addNetwork)(networkPayload));
          await dispatch((0, _actions.setEnabledNetworks)(networkPayload.chainId));
        }
        trackEvent({
          event: _metametrics.MetaMetricsEventName.CustomNetworkAdded,
          category: _metametrics.MetaMetricsEventCategory.Network,
          properties: {
            // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
            // eslint-disable-next-line @typescript-eslint/naming-convention
            block_explorer_url: blockExplorers === null || blockExplorers === void 0 || (_blockExplorers$block = blockExplorers.blockExplorerUrls) === null || _blockExplorers$block === void 0 ? void 0 : _blockExplorers$block[(blockExplorers === null || blockExplorers === void 0 ? void 0 : blockExplorers.defaultBlockExplorerUrlIndex) ?? -1],
            // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
            // eslint-disable-next-line @typescript-eslint/naming-convention
            chain_id: chainIdHex,
            // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
            // eslint-disable-next-line @typescript-eslint/naming-convention
            network_name: name,
            // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
            // eslint-disable-next-line @typescript-eslint/naming-convention
            source_connection_method: _metametrics.MetaMetricsNetworkEventSource.CustomNetworkForm,
            // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
            // eslint-disable-next-line @typescript-eslint/naming-convention
            token_symbol: ticker
          },
          sensitiveProperties: {
            rpcUrl: (0, _useSafeChains.rpcIdentifierUtility)(rpcUrls === null || rpcUrls === void 0 || (_rpcUrls$rpcEndpoints2 = rpcUrls.rpcEndpoints[rpcUrls.defaultRpcEndpointIndex ?? -1]) === null || _rpcUrls$rpcEndpoints2 === void 0 ? void 0 : _rpcUrls$rpcEndpoints2.url, safeChains ?? [])
          }
        });
        dispatch((0, _actions.setEditedNetwork)({
          chainId: chainIdHex,
          nickname: name,
          editCompleted: true,
          newNetwork: !existingNetwork
        }));
      }
    } catch (e) {
      console.error(e);
    } finally {
      toggleNetworkMenuAfterSubmit && dispatch((0, _actions.toggleNetworkMenu)());
      onComplete === null || onComplete === void 0 || onComplete();
    }
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    height: _designSystem.BlockSize.Full,
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.center,
    ref: scrollableRef,
    className: "networks-tab__scrollable"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    width: _designSystem.BlockSize.Full,
    paddingLeft: 4,
    paddingRight: 4,
    paddingBottom: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.FormTextField, {
    id: "networkName",
    size: _componentLibrary.FormTextFieldSize.Lg,
    placeholder: t('enterNetworkName'),
    "data-testid": "network-form-name-input",
    autoFocus: true,
    helpText:
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    (name && (warnings === null || warnings === void 0 || (_warnings$name = warnings.name) === null || _warnings$name === void 0 ? void 0 : _warnings$name.msg) || suggestedName) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, name && (warnings === null || warnings === void 0 || (_warnings$name2 = warnings.name) === null || _warnings$name2 === void 0 ? void 0 : _warnings$name2.msg) && /*#__PURE__*/_react.default.createElement(_componentLibrary.HelpText, {
      variant: _designSystem.TextVariant.bodySm,
      severity: _componentLibrary.HelpTextSeverity.Warning
    }, warnings.name.msg), suggestedName && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      as: "span",
      variant: _designSystem.TextVariant.bodySm,
      color: _designSystem.TextColor.textDefault,
      "data-testid": "network-form-name-suggestion"
    }, t('suggestedTokenName'), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
      as: "button",
      variant: _designSystem.TextVariant.bodySm,
      color: _designSystem.TextColor.primaryDefault,
      onClick: () => {
        setName(suggestedName);
      },
      paddingLeft: 1,
      paddingRight: 1,
      style: {
        verticalAlign: 'baseline'
      }
    }, suggestedName)))
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    ,
    onChange: e => {
      var _e$target;
      setName((_e$target = e.target) === null || _e$target === void 0 ? void 0 : _e$target.value);
    },
    label: t('networkName'),
    labelProps: {
      children: undefined,
      variant: _designSystem.TextVariant.bodyMdMedium
    },
    textFieldProps: {
      borderRadius: _designSystem.BorderRadius.LG
    },
    inputProps: {
      'data-testid': 'network-form-network-name'
    },
    value: name
  }), /*#__PURE__*/_react.default.createElement(_dropdownEditor.DropdownEditor, {
    title: t('defaultRpcUrl'),
    placeholder: t('addAUrl'),
    style: _dropdownEditor.DropdownEditorStyle.PopoverStyle,
    items: rpcUrls.rpcEndpoints,
    itemKey: endpoint => endpoint.url,
    selectedItemIndex: rpcUrls.defaultRpcEndpointIndex,
    error: Boolean(errors.rpcUrl),
    buttonDataTestId: "test-add-rpc-drop-down",
    renderItem: (item, isList) =>
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    isList || item !== null && item !== void 0 && item.name || (item === null || item === void 0 ? void 0 : item.type) === _networkController.RpcEndpointType.Infura ? /*#__PURE__*/_react.default.createElement(_rpcListItem.default, {
      rpcEndpoint: item
    }) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      ellipsis: true,
      variant: _designSystem.TextVariant.bodyMd,
      paddingTop: 3,
      paddingBottom: 3,
      display: _designSystem.Display.Flex,
      alignItems: _designSystem.AlignItems.center,
      gap: 1
    }, (0, _rpcListItem.stripProtocol)((0, _rpcListItem.stripKeyFromInfuraUrl)(item.url)), isRpcFailoverEnabled && item.failoverUrls && item.failoverUrls.length > 0 ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Tag, {
      label: t('failover'),
      display: _designSystem.Display.Inline
    }) : null),
    renderTooltip: (item, isList) => {
      const url = (0, _rpcListItem.stripKeyFromInfuraUrl)(item.url);
      return url.length > (isList ? 37 : 35) ? url : undefined;
    },
    addButtonText: t('addRpcUrl'),
    itemIsDeletable: item => item.type !== _networkController.RpcEndpointType.Infura,
    onItemAdd: onRpcAdd,
    onItemSelected: index => setRpcUrls(state => ({
      ...state,
      defaultRpcEndpointIndex: index
    })),
    onItemDeleted: (deletedIndex, newSelectedIndex) => {
      var _rpcUrls$rpcEndpoints3;
      setRpcUrls({
        rpcEndpoints: (_rpcUrls$rpcEndpoints3 = rpcUrls.rpcEndpoints) === null || _rpcUrls$rpcEndpoints3 === void 0 ? void 0 : _rpcUrls$rpcEndpoints3.slice(0, deletedIndex).concat(rpcUrls.rpcEndpoints.slice(deletedIndex + 1)),
        defaultRpcEndpointIndex: newSelectedIndex
      });
    }
  }), ((_errors$rpcUrl = errors.rpcUrl) === null || _errors$rpcUrl === void 0 ? void 0 : _errors$rpcUrl.msg) && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.HelpText, {
    variant: _designSystem.TextVariant.bodySm,
    severity: _componentLibrary.HelpTextSeverity.Danger,
    "data-testid": "network-form-chain-id-error"
  }, (_errors$rpcUrl2 = errors.rpcUrl) === null || _errors$rpcUrl2 === void 0 ? void 0 : _errors$rpcUrl2.msg)), isRpcFailoverEnabled &&
  // eslint-disable-next-line @typescript-eslint/prefer-optional-chain
  defaultRpcEndpoint && defaultRpcEndpoint.failoverUrls && defaultRpcEndpoint.failoverUrls.length > 0 ? /*#__PURE__*/_react.default.createElement(_componentLibrary.FormTextField, {
    id: "failoverRpcUrl",
    size: _componentLibrary.FormTextFieldSize.Lg,
    paddingTop: 4,
    label: t('failoverRpcUrl'),
    labelProps: {
      children: undefined,
      variant: _designSystem.TextVariant.bodyMdMedium
    },
    textFieldProps: {
      borderRadius: _designSystem.BorderRadius.LG
    },
    value: (0, _onlyKeepHost.onlyKeepHost)(defaultRpcEndpoint.failoverUrls[0]),
    disabled: true
  }) : null, /*#__PURE__*/_react.default.createElement(_componentLibrary.FormTextField, {
    id: "chainId",
    size: _componentLibrary.FormTextFieldSize.Lg,
    placeholder: t('enterChainId'),
    paddingTop: 4,
    "data-testid": "network-form-chain-id-input",
    onChange: e => {
      var _e$target2;
      setChainId((_e$target2 = e.target) === null || _e$target2 === void 0 ? void 0 : _e$target2.value.trim());
    },
    error: Boolean(errors === null || errors === void 0 ? void 0 : errors.chainId),
    label: t('chainId'),
    labelProps: {
      children: undefined,
      variant: _designSystem.TextVariant.bodyMdMedium
    },
    textFieldProps: {
      borderRadius: _designSystem.BorderRadius.LG
    },
    inputProps: {
      'data-testid': 'network-form-chain-id'
    },
    value: chainId,
    disabled: Boolean(existingNetwork)
  }), (_errors$chainId = errors.chainId) !== null && _errors$chainId !== void 0 && _errors$chainId.msg ? /*#__PURE__*/_react.default.createElement(_componentLibrary.HelpText, {
    variant: _designSystem.TextVariant.bodySm,
    severity: _componentLibrary.HelpTextSeverity.Danger,
    "data-testid": "network-form-chain-id-error"
  }, errors.chainId.msg) : null, ((_errors$chainId2 = errors.chainId) === null || _errors$chainId2 === void 0 ? void 0 : _errors$chainId2.key) === 'existingChainId' ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.HelpText, {
    variant: _designSystem.TextVariant.bodySm,
    severity: _componentLibrary.HelpTextSeverity.Danger,
    "data-testid": "network-form-chain-id-error"
  }, t('updateOrEditNetworkInformations'), ' ', /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    as: "button",
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.primaryDefault,
    onClick: () => {
      const chainIdHex = toHex(chainId);
      if (chainIdHex) {
        dispatch((0, _actions.setEditedNetwork)({
          chainId: chainIdHex
        }));
        onEdit === null || onEdit === void 0 || onEdit();
      }
    }
  }, t('editNetworkLink')))) : null, /*#__PURE__*/_react.default.createElement(_componentLibrary.FormTextField, {
    id: "nativeCurrency",
    size: _componentLibrary.FormTextFieldSize.Lg,
    placeholder: t('enterSymbol'),
    paddingTop: 4,
    "data-testid": "network-form-ticker",
    helpText: suggestedTicker ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      as: "span",
      variant: _designSystem.TextVariant.bodySm,
      color: _designSystem.TextColor.textDefault,
      "data-testid": "network-form-ticker-suggestion"
    }, t('suggestedCurrencySymbol'), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
      as: "button",
      variant: _designSystem.TextVariant.bodySm,
      color: _designSystem.TextColor.primaryDefault,
      onClick: () => {
        setTicker(suggestedTicker);
      },
      paddingLeft: 1,
      paddingRight: 1,
      style: {
        verticalAlign: 'baseline'
      }
    }, suggestedTicker)) : null
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    ,
    onChange: e => {
      var _e$target3;
      setTicker((_e$target3 = e.target) === null || _e$target3 === void 0 ? void 0 : _e$target3.value);
    },
    label: t('currencySymbol'),
    labelProps: {
      children: undefined,
      variant: _designSystem.TextVariant.bodyMdMedium
    },
    textFieldProps: {
      borderRadius: _designSystem.BorderRadius.LG
    },
    inputProps: {
      'data-testid': 'network-form-ticker-input'
    },
    value: ticker
  }), ticker && (_warnings$ticker = warnings.ticker) !== null && _warnings$ticker !== void 0 && _warnings$ticker.msg ? /*#__PURE__*/_react.default.createElement(_componentLibrary.HelpText, {
    variant: _designSystem.TextVariant.bodySm,
    severity: _componentLibrary.HelpTextSeverity.Warning,
    "data-testid": "network-form-ticker-warning"
  }, warnings.ticker.msg) : null, /*#__PURE__*/_react.default.createElement(_dropdownEditor.DropdownEditor, {
    title: t('blockExplorerUrl'),
    placeholder: t('addAUrl'),
    style: _dropdownEditor.DropdownEditorStyle.BoxStyle,
    items: blockExplorers.blockExplorerUrls,
    itemKey: item => `${item}`,
    selectedItemIndex: blockExplorers.defaultBlockExplorerUrlIndex,
    addButtonText: t('addBlockExplorerUrl'),
    onItemAdd: onBlockExplorerAdd,
    buttonDataTestId: "test-explorer-drop-down",
    onItemSelected: index => setBlockExplorers(state => ({
      ...state,
      defaultBlockExplorerUrlIndex: index
    })),
    onItemDeleted: (deletedIndex, newSelectedIndex) => {
      var _blockExplorers$block2;
      setBlockExplorers({
        blockExplorerUrls: (_blockExplorers$block2 = blockExplorers.blockExplorerUrls) === null || _blockExplorers$block2 === void 0 ? void 0 : _blockExplorers$block2.slice(0, deletedIndex).concat(blockExplorers.blockExplorerUrls.slice(deletedIndex + 1)),
        defaultBlockExplorerUrlIndex: newSelectedIndex
      });
    }
    // Scroll to bottom so all URLs are visible
    ,
    onDropdownOpened: () => {
      if (scrollableRef.current) {
        scrollableRef.current.scrollTop = scrollableRef.current.scrollHeight;
      }
    },
    renderItem: item => /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      as: "button",
      paddingLeft: 0,
      paddingRight: 0,
      paddingTop: 3,
      paddingBottom: 3,
      color: _designSystem.TextColor.textDefault,
      variant: _designSystem.TextVariant.bodyMd,
      backgroundColor: _designSystem.BackgroundColor.transparent,
      ellipsis: true
    }, (0, _rpcListItem.stripProtocol)(item)),
    renderTooltip: item => item.length > 36 ? item : undefined
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "networks-tab__network-form__footer",
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    padding: 4,
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonPrimary, {
    disabled: !name || !chainId || !ticker || !(rpcUrls !== null && rpcUrls !== void 0 && (_rpcUrls$rpcEndpoints4 = rpcUrls.rpcEndpoints) !== null && _rpcUrls$rpcEndpoints4 !== void 0 && _rpcUrls$rpcEndpoints4.length) || Object.values(errors).some(e => e)
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    ,
    onClick: onSubmit,
    size: _componentLibrary.ButtonPrimarySize.Lg,
    width: _designSystem.BlockSize.Full
  }, t('save'))));
};
exports.NetworksForm = NetworksForm;
function toHex(value) {
  if ((0, _utils.isStrictHexString)(value)) {
    return value;
  } else if (/^\d+$/u.test(value)) {
    return `0x${(0, _conversion.decimalToHex)(value)}`;
  }
  return undefined;
}
var _default = exports.default = NetworksForm;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\networks-tab\\networks-form\\networks-form.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\networks-tab\\networks-form\\use-safe-chains.ts", {"../../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../../shared/constants/time":"D:\\code\\v\\metamask-extension\\shared\\constants\\time.ts","../../../../../shared/lib/fetch-with-cache":"D:\\code\\v\\metamask-extension\\shared\\lib\\fetch-with-cache.ts","../../../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Cnetworks-tab%5Cnetworks-form%5Cuse-safe-chains.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSafeChains = exports.rpcIdentifierUtility = exports.getSafeNativeCurrencySymbol = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _utils = require("@metamask/utils");
var _selectors = require("../../../../selectors");
var _fetchWithCache = _interopRequireDefault(require("../../../../../shared/lib/fetch-with-cache"));
var _network = require("../../../../../shared/constants/network");
var _time = require("../../../../../shared/constants/time");
var _conversion = require("../../../../../shared/modules/conversion.utils");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const useSafeChains = () => {
  const useSafeChainsListValidation = (0, _reactRedux.useSelector)(_selectors.useSafeChainsListValidationSelector);
  const [safeChains, setSafeChains] = (0, _react.useState)({
    safeChains: []
  });
  (0, _react.useEffect)(() => {
    if (useSafeChainsListValidation) {
      (0, _fetchWithCache.default)({
        url: _network.CHAIN_SPEC_URL,
        functionName: 'getSafeChainsList',
        allowStale: true,
        cacheOptions: {
          cacheRefreshTime: _time.DAY
        }
      }).then(response => {
        setSafeChains({
          safeChains: response
        });
      }).catch(error => {
        setSafeChains({
          error
        });
      });
    }
  }, [useSafeChainsListValidation]);
  return safeChains;
};
exports.useSafeChains = useSafeChains;
const getSafeNativeCurrencySymbol = (safeChains, chainId) => {
  var _safeChains$find;
  if (!safeChains || !chainId) {
    return undefined;
  }
  const decimalChainId = (0, _utils.isStrictHexString)(chainId) && parseInt((0, _conversion.hexToDecimal)(chainId), 10);
  if (typeof decimalChainId !== 'number') {
    return undefined;
  }
  return (_safeChains$find = safeChains.find(chain => chain.chainId === decimalChainId.toString())) === null || _safeChains$find === void 0 || (_safeChains$find = _safeChains$find.nativeCurrency) === null || _safeChains$find === void 0 ? void 0 : _safeChains$find.symbol;
};
exports.getSafeNativeCurrencySymbol = getSafeNativeCurrencySymbol;
const rpcIdentifierUtility = (rpcUrl, safeChains) => {
  const {
    host
  } = new URL(rpcUrl);
  for (const chain of safeChains) {
    for (const rpc of chain.rpc) {
      try {
        if (host === new URL(rpc).host) {
          return host;
        }
      } catch {
        continue;
      }
    }
  }
  return 'Unknown rpcUrl';
};
exports.rpcIdentifierUtility = rpcIdentifierUtility;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\networks-tab\\networks-form\\use-safe-chains.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\security-tab\\change-password\\change-password-warning.tsx", {"../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/constants/zendesk-url":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\zendesk-url.js","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Csecurity-tab%5Cchange-password%5Cchange-password-warning.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ChangePasswordWarning;
var _react = _interopRequireDefault(require("react"));
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _designSystem = require("../../../../helpers/constants/design-system");
var _componentLibrary = require("../../../../components/component-library");
var _zendeskUrl = _interopRequireDefault(require("../../../../helpers/constants/zendesk-url"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function ChangePasswordWarning({
  onConfirm,
  onCancel
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  const changePasswordLearnMore = /*#__PURE__*/_react.default.createElement("a", {
    key: "change-password__link-text",
    href: _zendeskUrl.default.PASSWORD_RESET,
    target: "_blank",
    rel: "noopener noreferrer"
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "change-password__link-text"
  }, t('learnMoreUpperCase')));
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: true,
    onClose: onCancel,
    className: "change-password-warning-modal",
    "data-testid": "change-password-warning-modal"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, {
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.Danger,
    size: _componentLibrary.IconSize.Xl,
    color: _designSystem.IconColor.warningDefault
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingMd,
    textAlign: _designSystem.TextAlign.Center,
    marginTop: 4
  }, t('changePasswordWarning')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    marginTop: 4
  }, t('changePasswordWarningDescription'), " ", changePasswordLearnMore))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 4,
    paddingRight: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    marginTop: 2,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    variant: _componentLibrary.ButtonVariant.Secondary,
    "data-testid": "change-password-warning-cancel",
    size: _componentLibrary.ButtonSize.Lg,
    block: true,
    onClick: () => onCancel()
  }, t('cancel')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    "data-testid": "change-password-warning-confirm",
    size: _componentLibrary.ButtonSize.Lg,
    block: true,
    onClick: () => onConfirm()
  }, t('confirm'))))));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\security-tab\\change-password\\change-password-warning.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\security-tab\\change-password\\change-password.tsx", {"../../../../../shared/constants/app-state":"D:\\code\\v\\metamask-extension\\shared\\constants\\app-state.ts","../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../components/app/password-form/password-form":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\password-form\\password-form.tsx","../../../../components/app/toast-master/utils":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\toast-master\\utils.ts","../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../components/ui/mascot":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\mascot\\index.js","../../../../components/ui/spinner":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\spinner\\index.js","../../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../../helpers/constants/zendesk-url":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\zendesk-url.js","../../../../helpers/utils/build-types":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\build-types.js","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./change-password-warning":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\security-tab\\change-password\\change-password-warning.tsx","events":"D:\\code\\v\\metamask-extension\\node_modules\\events\\events.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Csecurity-tab%5Cchange-password%5Cchange-password.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _events = _interopRequireDefault(require("events"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _componentLibrary = require("../../../../components/component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _buildTypes = require("../../../../helpers/utils/build-types");
var _mascot = _interopRequireDefault(require("../../../../components/ui/mascot"));
var _spinner = _interopRequireDefault(require("../../../../components/ui/spinner"));
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _actions = require("../../../../store/actions");
var _passwordForm = _interopRequireDefault(require("../../../../components/app/password-form/password-form"));
var _routes = require("../../../../helpers/constants/routes");
var _utils = require("../../../../components/app/toast-master/utils");
var _appState = require("../../../../../shared/constants/app-state");
var _selectors = require("../../../../selectors");
var _zendeskUrl = _interopRequireDefault(require("../../../../helpers/constants/zendesk-url"));
var _metametrics = require("../../../../contexts/metametrics");
var _metametrics2 = require("../../../../../shared/constants/metametrics");
var _changePasswordWarning = _interopRequireDefault(require("./change-password-warning"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const ChangePasswordSteps = {
  VerifyCurrentPassword: 1,
  ChangePassword: 2,
  ChangePasswordLoading: 3
};
const ChangePassword = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const navigate = (0, _reactRouterDomV5Compat.useNavigate)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const isSocialLoginFlow = (0, _reactRedux.useSelector)(_selectors.getIsSocialLoginFlow);
  const animationEventEmitter = (0, _react.useRef)(new _events.default());
  const [step, setStep] = (0, _react.useState)(ChangePasswordSteps.VerifyCurrentPassword);
  const [currentPassword, setCurrentPassword] = (0, _react.useState)('');
  const [isIncorrectPasswordError, setIsIncorrectPasswordError] = (0, _react.useState)(false);
  const [termsChecked, setTermsChecked] = (0, _react.useState)(false);
  const [newPassword, setNewPassword] = (0, _react.useState)('');
  const [showChangePasswordWarning, setShowChangePasswordWarning] = (0, _react.useState)(false);
  const renderMascot = () => {
    if ((0, _buildTypes.isFlask)()) {
      return /*#__PURE__*/_react.default.createElement("img", {
        src: "./images/logo/metamask-fox.svg",
        width: "100",
        height: "100"
      });
    }
    if ((0, _buildTypes.isBeta)()) {
      return /*#__PURE__*/_react.default.createElement("img", {
        src: "./images/logo/metamask-fox.svg",
        width: "100",
        height: "100"
      });
    }
    return /*#__PURE__*/_react.default.createElement(_mascot.default, {
      animationEventEmitter: animationEventEmitter.current,
      width: "100",
      height: "100"
    });
  };
  const handleSubmitCurrentPassword = async () => {
    try {
      await (0, _actions.verifyPassword)(currentPassword);
      setIsIncorrectPasswordError(false);
      setStep(ChangePasswordSteps.ChangePassword);
    } catch (error) {
      setIsIncorrectPasswordError(true);
    }
  };
  const onChangePassword = async () => {
    try {
      setShowChangePasswordWarning(false);
      setStep(ChangePasswordSteps.ChangePasswordLoading);
      await dispatch((0, _actions.changePassword)(newPassword, currentPassword));

      // Track password changed event
      trackEvent({
        category: _metametrics2.MetaMetricsEventCategory.Settings,
        event: _metametrics2.MetaMetricsEventName.PasswordChanged,
        properties: {
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          biometrics_enabled: false
        }
      });

      // upon successful password change, go back to the settings page
      navigate(_routes.SECURITY_ROUTE);
      dispatch((0, _utils.setShowPasswordChangeToast)(_appState.PasswordChangeToastType.Success));
    } catch (error) {
      console.error(error);
      setStep(ChangePasswordSteps.ChangePassword);
      dispatch((0, _utils.setShowPasswordChangeToast)(_appState.PasswordChangeToastType.Errored));
    }
  };
  const handleLearnMoreClick = event => {
    event.stopPropagation();
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.Onboarding,
      event: _metametrics2.MetaMetricsEventName.ExternalLinkClicked,
      properties: {
        text: 'Learn More',
        location: 'change_password',
        url: _zendeskUrl.default.PASSWORD_ARTICLE
      }
    });
  };
  const createPasswordLink = /*#__PURE__*/_react.default.createElement("a", {
    onClick: handleLearnMoreClick,
    key: "change-password__link-text",
    href: _zendeskUrl.default.PASSWORD_ARTICLE,
    target: "_blank",
    rel: "noopener noreferrer"
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "change-password__link-text"
  }, t('learnMoreUpperCaseWithDot')));
  (0, _react.useEffect)(() => {
    (async () => {
      // check if the seedless password is outdated as long as the user land on the change password page
      if (isSocialLoginFlow) {
        await dispatch((0, _actions.checkIsSeedlessPasswordOutdated)());
      }
    })();
  }, [dispatch, isSocialLoginFlow]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    padding: 4,
    className: "change-password"
  }, step === ChangePasswordSteps.VerifyCurrentPassword && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    as: "form",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 6,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    height: _designSystem.BlockSize.Full,
    onSubmit: e => {
      e.preventDefault();
      handleSubmitCurrentPassword();
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.FormTextField, {
    id: "current-password",
    label: t('enterPasswordCurrent'),
    textFieldProps: {
      type: _componentLibrary.TextFieldType.Password
    },
    size: _componentLibrary.FormTextFieldSize.Lg,
    labelProps: {
      marginBottom: 1
    },
    inputProps: {
      autoFocus: true,
      'data-testid': 'verify-current-password-input'
    },
    value: currentPassword,
    error: isIncorrectPasswordError,
    helpText: isIncorrectPasswordError ? t('unlockPageIncorrectPassword') : null,
    onChange: e => {
      setCurrentPassword(e.target.value);
      setIsIncorrectPasswordError(false);
    }
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    type: "submit",
    block: true,
    size: _componentLibrary.ButtonSize.Lg,
    disabled: isIncorrectPasswordError || !currentPassword,
    "data-testid": "verify-current-password-button"
  }, t('continue'))), step === ChangePasswordSteps.ChangePassword && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    as: "form",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 6,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    height: _designSystem.BlockSize.Full,
    onSubmit: e => {
      e.preventDefault();
      if (isSocialLoginFlow) {
        setShowChangePasswordWarning(true);
      } else {
        onChangePassword();
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    color: _designSystem.TextColor.textAlternative,
    marginBottom: 4,
    as: "h2"
  }, isSocialLoginFlow ? t('createPasswordDetailsSocial') : t('createPasswordDetails')), /*#__PURE__*/_react.default.createElement(_passwordForm.default, {
    onChange: password => setNewPassword(password),
    pwdInputTestId: "change-password-input",
    confirmPwdInputTestId: "change-password-confirm-input"
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "create-password__terms-container",
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    marginTop: 6
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Checkbox, {
    inputProps: {
      'data-testid': 'change-password-terms'
    },
    alignItems: _designSystem.AlignItems.flexStart,
    isChecked: termsChecked,
    onChange: () => {
      setTermsChecked(!termsChecked);
    },
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isSocialLoginFlow ? t('passwordTermsWarningSocial') : t('passwordTermsWarning'), "\xA0", createPasswordLink)
  }))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    type: "submit",
    disabled: !currentPassword || !newPassword || !termsChecked,
    "data-testid": "change-password-button",
    block: true
  }, t('save'))), step === ChangePasswordSteps.ChangePasswordLoading && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.center,
    marginTop: 12
  }, /*#__PURE__*/_react.default.createElement("div", null, renderMascot()), /*#__PURE__*/_react.default.createElement(_spinner.default, {
    className: "change-password__spinner"
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyLgMedium,
    marginBottom: 4
  }, t('changePasswordLoading')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative
  }, t('changePasswordLoadingNote'))), showChangePasswordWarning && /*#__PURE__*/_react.default.createElement(_changePasswordWarning.default, {
    onConfirm: () => {
      onChangePassword();
    },
    onCancel: () => setShowChangePasswordWarning(false)
  }));
};
var _default = exports.default = ChangePassword;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\security-tab\\change-password\\change-password.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\security-tab\\change-password\\index.ts", {"./change-password":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\security-tab\\change-password\\change-password.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Csecurity-tab%5Cchange-password%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _changePassword.default;
  }
});
var _changePassword = _interopRequireDefault(require("./change-password"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\security-tab\\change-password\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\security-tab\\delete-metametrics-data-button\\delete-metametrics-data-button.tsx", {"../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../../shared/lib/ui-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\ui-utils.js","../../../../components/app/clear-metametrics-data":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\clear-metametrics-data\\index.ts","../../../../components/app/data-deletion-error-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\data-deletion-error-modal\\index.ts","../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../ducks/app/app":"D:\\code\\v\\metamask-extension\\ui\\ducks\\app\\app.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Csecurity-tab%5Cdelete-metametrics-data-button%5Cdelete-metametrics-data-button.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _uiUtils = require("../../../../../shared/lib/ui-utils");
var _clearMetametricsData = _interopRequireDefault(require("../../../../components/app/clear-metametrics-data"));
var _componentLibrary = require("../../../../components/component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _selectors = require("../../../../selectors");
var _app = require("../../../../ducks/app/app");
var _dataDeletionErrorModal = _interopRequireDefault(require("../../../../components/app/data-deletion-error-modal"));
var _util = require("../../../../helpers/utils/util");
var _metametrics = require("../../../../../shared/constants/metametrics");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention

const DeleteMetaMetricsDataButton = /*#__PURE__*/_react.default.forwardRef(({
  defaultPrivacySettings,
  ...props
}, ref) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const metaMetricsId = (0, _reactRedux.useSelector)(_selectors.getMetaMetricsId);
  const metaMetricsDataDeletionStatus = (0, _reactRedux.useSelector)(_selectors.getMetaMetricsDataDeletionStatus);
  const metaMetricsDataDeletionTimestamp = (0, _reactRedux.useSelector)(_selectors.getMetaMetricsDataDeletionTimestamp);
  const formatedDate = (0, _util.formatDate)(metaMetricsDataDeletionTimestamp, 'd/MM/y');
  const showDeleteMetaMetricsDataModal = (0, _reactRedux.useSelector)(_selectors.getShowDeleteMetaMetricsDataModal);
  const showDataDeletionErrorModal = (0, _reactRedux.useSelector)(_selectors.getShowDataDeletionErrorModal);
  const latestMetricsEventTimestamp = (0, _reactRedux.useSelector)(_selectors.getLatestMetricsEventTimestamp);
  const isMetaMetricsEnabled = (0, _reactRedux.useSelector)(_selectors.getParticipateInMetaMetrics);
  let dataDeletionButtonDisabled = !isMetaMetricsEnabled;
  if (!dataDeletionButtonDisabled && metaMetricsDataDeletionStatus) {
    dataDeletionButtonDisabled = [_metametrics.DeleteRegulationStatus.Initialized, _metametrics.DeleteRegulationStatus.Running, _metametrics.DeleteRegulationStatus.Finished].includes(metaMetricsDataDeletionStatus) && metaMetricsDataDeletionTimestamp > latestMetricsEventTimestamp;
  }
  const privacyPolicyLink = /*#__PURE__*/_react.default.createElement("a", {
    href: _uiUtils.CONSENSYS_PRIVACY_LINK,
    target: "_blank",
    rel: "noopener noreferrer",
    key: "metametrics-consensys-privacy-link"
  }, t('privacyMsg'));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    ref: ref,
    className: "settings-page__content-row",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "settings-page__content-item"
  }, /*#__PURE__*/_react.default.createElement("span", null, t('deleteMetaMetricsData')), /*#__PURE__*/_react.default.createElement("div", {
    className: "settings-page__content-description"
  }, dataDeletionButtonDisabled && Boolean(metaMetricsId) ? t('deleteMetaMetricsDataRequestedDescription', [formatedDate, privacyPolicyLink]) : t('deleteMetaMetricsDataDescription', [privacyPolicyLink]))), /*#__PURE__*/_react.default.createElement("div", {
    className: `settings-page__content-item-col ${defaultPrivacySettings ? 'settings-page__button-defaut-settings' : ''}`
  }, Boolean(!metaMetricsId) && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.InlineFlex
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.Info,
    size: _componentLibrary.IconSize.Sm
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyXs,
    marginLeft: 1,
    marginBottom: 2
  }, t('metaMetricsIdNotAvailableError'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonPrimary, {
    "data-testid": "delete-metametrics-data-button",
    className: "settings-page__button",
    width: _designSystem.BlockSize.Full,
    onClick: () => {
      dispatch((0, _app.openDeleteMetaMetricsDataModal)());
    },
    disabled: dataDeletionButtonDisabled
  }, t('deleteMetaMetricsData')))), showDeleteMetaMetricsDataModal && /*#__PURE__*/_react.default.createElement(_clearMetametricsData.default, null), showDataDeletionErrorModal && /*#__PURE__*/_react.default.createElement(_dataDeletionErrorModal.default, null));
});
var _default = exports.default = DeleteMetaMetricsDataButton;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\security-tab\\delete-metametrics-data-button\\delete-metametrics-data-button.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\security-tab\\delete-metametrics-data-button\\index.ts", {"./delete-metametrics-data-button":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\security-tab\\delete-metametrics-data-button\\delete-metametrics-data-button.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Csecurity-tab%5Cdelete-metametrics-data-button%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _deleteMetametricsDataButton.default;
  }
});
var _deleteMetametricsDataButton = _interopRequireDefault(require("./delete-metametrics-data-button"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\security-tab\\delete-metametrics-data-button\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\security-tab\\index.js", {"./security-tab.container":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\security-tab\\security-tab.container.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Csecurity-tab%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _securityTab.default;
  }
});
var _securityTab = _interopRequireDefault(require("./security-tab.container"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\security-tab\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\security-tab\\metametrics-toggle\\index.ts", {"./metametrics-toggle":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\security-tab\\metametrics-toggle\\metametrics-toggle.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Csecurity-tab%5Cmetametrics-toggle%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _metametricsToggle.default;
  }
});
var _metametricsToggle = _interopRequireDefault(require("./metametrics-toggle"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\security-tab\\metametrics-toggle\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\security-tab\\metametrics-toggle\\metametrics-toggle.tsx", {"../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../components/ui/toggle-button":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\toggle-button\\index.js","../../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../hooks/useMetametrics":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMetametrics.ts","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../selectors/identity/backup-and-sync":"D:\\code\\v\\metamask-extension\\ui\\selectors\\identity\\backup-and-sync.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Csecurity-tab%5Cmetametrics-toggle%5Cmetametrics-toggle.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _metametrics = require("../../../../contexts/metametrics");
var _useMetametrics = require("../../../../hooks/useMetametrics");
var _backupAndSync = require("../../../../selectors/identity/backup-and-sync");
var _metametrics2 = require("../../../../../shared/constants/metametrics");
var _componentLibrary = require("../../../../components/component-library");
var _toggleButton = _interopRequireDefault(require("../../../../components/ui/toggle-button"));
var _designSystem = require("../../../../helpers/constants/design-system");
var _selectors = require("../../../../selectors");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MetametricsToggle = ({
  dataCollectionForMarketing,
  setDataCollectionForMarketing,
  fromDefaultSettings = false
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const {
    enableMetametrics,
    error: enableMetametricsError
  } = (0, _useMetametrics.useEnableMetametrics)();
  const {
    disableMetametrics,
    error: disableMetametricsError
  } = (0, _useMetametrics.useDisableMetametrics)();

  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  const error = enableMetametricsError || disableMetametricsError;
  const isBackupAndSyncEnabled = (0, _reactRedux.useSelector)(_backupAndSync.selectIsBackupAndSyncEnabled);
  const participateInMetaMetrics = (0, _reactRedux.useSelector)(_selectors.getParticipateInMetaMetrics);
  const useExternalServices = (0, _reactRedux.useSelector)(_selectors.getUseExternalServices);
  const handleUseParticipateInMetaMetrics = async isParticipated => {
    if (isParticipated) {
      await enableMetametrics();
      trackEvent({
        category: _metametrics2.MetaMetricsEventCategory.Settings,
        event: _metametrics2.MetaMetricsEventName.TurnOnMetaMetrics,
        properties: {
          isProfileSyncingEnabled: isBackupAndSyncEnabled,
          participateInMetaMetrics,
          location: fromDefaultSettings ? 'Default Settings' : 'Settings'
        }
      });
    } else {
      // disable data collection for marketing if participate in meta metrics is set to false
      if (dataCollectionForMarketing) {
        await setDataCollectionForMarketing(false);
      }
      await disableMetametrics();
      trackEvent({
        category: _metametrics2.MetaMetricsEventCategory.Settings,
        event: _metametrics2.MetaMetricsEventName.TurnOffMetaMetrics,
        properties: {
          isProfileSyncingEnabled: isBackupAndSyncEnabled,
          participateInMetaMetrics
        }
      });
      trackEvent({
        category: _metametrics2.MetaMetricsEventCategory.Settings,
        event: _metametrics2.MetaMetricsEventName.AnalyticsPreferenceSelected,
        properties: {
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          is_metrics_opted_in: false,
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          has_marketing_consent: false,
          location: 'Settings'
        }
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "settings-page__content-row",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    gap: 4,
    "data-testid": "participate-in-meta-metrics-container"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "settings-page__content-item"
  }, /*#__PURE__*/_react.default.createElement("span", null, t('participateInMetaMetrics')), /*#__PURE__*/_react.default.createElement("div", {
    className: "settings-page__content-description"
  }, t('participateInMetaMetricsDescription'))), /*#__PURE__*/_react.default.createElement("div", {
    className: "settings-page__content-item-col",
    "data-testid": "participate-in-meta-metrics-toggle"
  }, /*#__PURE__*/_react.default.createElement(_toggleButton.default, {
    value: participateInMetaMetrics,
    disabled: !useExternalServices,
    onToggle: value => handleUseParticipateInMetaMetrics(!value),
    offLabel: t('off'),
    onLabel: t('on')
  }))), error && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingBottom: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "p",
    color: _designSystem.TextColor.errorDefault,
    variant: _designSystem.TextVariant.bodySm
  }, t('notificationsSettingsBoxError'))));
};
var _default = exports.default = MetametricsToggle;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\security-tab\\metametrics-toggle\\metametrics-toggle.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\security-tab\\reveal-srp-list\\index.ts", {"./reveal-srp-list":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\security-tab\\reveal-srp-list\\reveal-srp-list.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Csecurity-tab%5Creveal-srp-list%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "RevealSrpList", {
  enumerable: true,
  get: function () {
    return _revealSrpList.RevealSrpList;
  }
});
var _revealSrpList = require("./reveal-srp-list");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\security-tab\\reveal-srp-list\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\security-tab\\reveal-srp-list\\reveal-srp-list.tsx", {"../../../../components/app/srp-quiz-modal/SRPQuiz":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\srp-quiz-modal\\SRPQuiz\\index.ts","../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../components/multichain/multi-srp/srp-list/srp-list":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\multi-srp\\srp-list\\srp-list.tsx","../../../../components/ui/card":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\card\\index.js","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../../hooks/social-sync/useSyncSRPs":"D:\\code\\v\\metamask-extension\\ui\\hooks\\social-sync\\useSyncSRPs.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","@metamask/seedless-onboarding-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\seedless-onboarding-controller\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Csecurity-tab%5Creveal-srp-list%5Creveal-srp-list.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RevealSrpList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _reactRedux = require("react-redux");
var _seedlessOnboardingController = require("@metamask/seedless-onboarding-controller");
var _lodash = require("lodash");
var _componentLibrary = require("../../../../components/component-library");
var _SRPQuiz = _interopRequireDefault(require("../../../../components/app/srp-quiz-modal/SRPQuiz"));
var _srpList = require("../../../../components/multichain/multi-srp/srp-list/srp-list");
var _designSystem = require("../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _routes = require("../../../../helpers/constants/routes");
var _selectors = require("../../../../selectors");
var _card = _interopRequireDefault(require("../../../../components/ui/card"));
var _useSyncSRPs = require("../../../../hooks/social-sync/useSyncSRPs");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RevealSrpList = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  const navigate = (0, _reactRouterDomV5Compat.useNavigate)();
  const [srpQuizModalVisible, setSrpQuizModalVisible] = (0, _react.useState)(false);
  const [selectedKeyringId, setSelectedKeyringId] = (0, _react.useState)('');
  const isSocialLoginFlow = (0, _reactRedux.useSelector)(_selectors.getIsSocialLoginFlow);
  const socialLoginType = (0, _reactRedux.useSelector)(_selectors.getSocialLoginType);
  const socialLoginEmail = (0, _reactRedux.useSelector)(_selectors.getSocialLoginEmail);

  // sync SRPs list when page loads
  (0, _useSyncSRPs.useSyncSRPs)();
  const onSrpActionComplete = (keyringId, triggerBackup) => {
    if (triggerBackup) {
      const backUpSRPRoute = `${_routes.ONBOARDING_REVIEW_SRP_ROUTE}/?isFromReminder=true&isFromSettingsSecurity=true`;
      navigate(backUpSRPRoute);
    } else {
      setSelectedKeyringId(keyringId);
      setSrpQuizModalVisible(true);
    }
  };
  const maskHostNameFromEmail = email => {
    const [hostname, domain] = email.split('@');
    const initialPart = hostname.slice(0, 1);
    const maskedHostname = `${initialPart}${'*'.repeat(hostname.length - initialPart.length)}`;
    return `${maskedHostname}@${domain}`;
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "srp-reveal-list"
  }, isSocialLoginFlow && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingTop: 4,
    paddingLeft: 4,
    paddingRight: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    marginBottom: 2,
    variant: _designSystem.TextVariant.bodyMd,
    color: _designSystem.TextColor.textAlternative,
    textTransform: _designSystem.TextTransform.Uppercase
  }, t('securitySocialLoginLabel', [socialLoginType])), /*#__PURE__*/_react.default.createElement(_card.default, {
    className: "srp-reveal-list__social-login-card",
    backgroundColor: _designSystem.BackgroundColor.backgroundMuted,
    border: false
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    alignItems: _designSystem.AlignItems.center,
    gap: 3
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    gap: 2
  }, socialLoginType === _seedlessOnboardingController.AuthConnection.Apple ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.Apple,
    color: _designSystem.IconColor.iconDefault,
    size: _componentLibrary.IconSize.Lg
  }) : /*#__PURE__*/_react.default.createElement("img", {
    src: `images/icons/google.svg`,
    className: "srp-reveal-list__social-icon",
    alt: "Google icon"
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    flexDirection: _designSystem.FlexDirection.Column
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    fontWeight: _designSystem.FontWeight.Medium
  }, t('securitySocialLoginEnabled')), socialLoginEmail && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative
  }, maskHostNameFromEmail(socialLoginEmail))))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    marginTop: 1,
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative
  }, t('securitySocialLoginEnabledDescription', [(0, _lodash.capitalize)(socialLoginType)])), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    width: _designSystem.BlockSize.Full,
    className: "srp-reveal-list__divider",
    marginTop: 4
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingTop: 4,
    paddingLeft: 4,
    paddingRight: 4,
    paddingBottom: 0,
    className: "srp-reveal-list__srp-list"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    marginBottom: 2,
    variant: _designSystem.TextVariant.bodyMd,
    color: _designSystem.TextColor.textAlternative,
    textTransform: _designSystem.TextTransform.Uppercase
  }, t('securitySrpLabel')), /*#__PURE__*/_react.default.createElement(_srpList.SrpList, {
    onActionComplete: onSrpActionComplete,
    hideShowAccounts: false,
    isSettingsPage: true
  })), srpQuizModalVisible && selectedKeyringId && /*#__PURE__*/_react.default.createElement(_SRPQuiz.default, {
    keyringId: selectedKeyringId,
    isOpen: srpQuizModalVisible,
    onClose: () => setSrpQuizModalVisible(false)
  }));
};
exports.RevealSrpList = RevealSrpList;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\security-tab\\reveal-srp-list\\reveal-srp-list.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\security-tab\\security-tab.component.js", {"../../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../shared/lib/ui-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\ui-utils.js","../../../../shared/modules/environment":"D:\\code\\v\\metamask-extension\\shared\\modules\\environment.ts","../../../components/app/srp-quiz-modal/SRPQuiz":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\srp-quiz-modal\\SRPQuiz\\index.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/ui/popover":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\popover\\index.js","../../../components/ui/text-field":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\text-field\\index.js","../../../components/ui/toggle-button":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\toggle-button\\index.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../helpers/constants/zendesk-url":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\zendesk-url.js","../../../helpers/utils/settings-search":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\settings-search.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./delete-metametrics-data-button":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\security-tab\\delete-metametrics-data-button\\index.ts","./metametrics-toggle":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\security-tab\\metametrics-toggle\\index.ts","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Csecurity-tab%5Csecurity-tab.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _lodash = require("lodash");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _loglevel = _interopRequireDefault(require("loglevel"));
var _util = require("../../../../app/scripts/lib/util");
var _app = require("../../../../shared/constants/app");
var _metametrics = require("../../../../shared/constants/metametrics");
var _network = require("../../../../shared/constants/network");
var _uiUtils = require("../../../../shared/lib/ui-utils");
var _SRPQuiz = _interopRequireDefault(require("../../../components/app/srp-quiz-modal/SRPQuiz"));
var _componentLibrary = require("../../../components/component-library");
var _textField = _interopRequireDefault(require("../../../components/ui/text-field"));
var _toggleButton = _interopRequireDefault(require("../../../components/ui/toggle-button"));
var _popover = _interopRequireDefault(require("../../../components/ui/popover"));
var _designSystem = require("../../../helpers/constants/design-system");
var _routes = require("../../../helpers/constants/routes");
var _settingsSearch = require("../../../helpers/utils/settings-search");
var _actions = require("../../../store/actions");
var _zendeskUrl = _interopRequireDefault(require("../../../helpers/constants/zendesk-url"));
var _environment = require("../../../../shared/modules/environment");
var _metametricsToggle = _interopRequireDefault(require("./metametrics-toggle"));
var _deleteMetametricsDataButton = _interopRequireDefault(require("./delete-metametrics-data-button"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class SecurityTab extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "state", {
      ipfsGateway: this.props.ipfsGateway || _network.IPFS_DEFAULT_GATEWAY_URL,
      ipfsGatewayError: '',
      srpQuizModalVisible: false,
      showDataCollectionDisclaimer: false,
      ipfsToggle: this.props.ipfsGateway.length > 0,
      hasEmailMarketingConsentError: false
    });
    _defineProperty(this, "settingsRefCounter", 0);
    _defineProperty(this, "settingsRefs", Array((0, _settingsSearch.getNumberOfSettingRoutesInTab)(this.context.t, this.context.t('securityAndPrivacy'))).fill(undefined).map(() => {
      return /*#__PURE__*/_react.default.createRef();
    }));
    _defineProperty(this, "hideSrpQuizModal", () => this.setState({
      srpQuizModalVisible: false
    }));
    _defineProperty(this, "renderDataCollectionWarning", () => {
      const {
        t
      } = this.context;
      return /*#__PURE__*/_react.default.createElement(_popover.default, {
        wrapTitle: true,
        centerTitle: true,
        onClose: () => this.setState({
          showDataCollectionDisclaimer: false
        }),
        title: /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
          size: _componentLibrary.IconSize.Xl,
          name: _componentLibrary.IconName.Danger,
          color: _designSystem.IconColor.warningDefault
        }),
        footer: /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
          width: _designSystem.BlockSize.Full,
          type: "primary",
          onClick: () => this.setState({
            showDataCollectionDisclaimer: false
          })
        }, t('dataCollectionWarningPopoverButton'))
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        display: _designSystem.Display.Flex,
        flexDirection: _designSystem.FlexDirection.Column,
        gap: 2,
        margin: 4
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, null, t('dataCollectionWarningPopoverDescription'))));
    });
  }
  componentDidUpdate(prevProps) {
    const {
      t
    } = this.context;
    (0, _settingsSearch.handleSettingsRefs)(t, t('securityAndPrivacy'), this.settingsRefs);
    if (prevProps.dataCollectionForMarketing === true && this.props.participateInMetaMetrics === true && this.props.dataCollectionForMarketing === false && !this.props.socialLoginEnabled) {
      this.setState({
        showDataCollectionDisclaimer: true
      });
    }
  }
  async componentDidMount() {
    const {
      t
    } = this.context;
    (0, _settingsSearch.handleSettingsRefs)(t, t('securityAndPrivacy'), this.settingsRefs);
    if (this.props.metaMetricsDataDeletionId) {
      await (0, _actions.updateDataDeletionTaskStatus)();
    }
    if (this.props.socialLoginEnabled) {
      // Fetch marketing consent from remote server for social login users
      const marketingConsentFromRemote = await this.props.getMarketingConsent();
      // Update marketing consent in the store
      this.props.setDataCollectionForMarketing(marketingConsentFromRemote);
    }
  }
  toggleSetting(value, eventName, eventAction, toggleMethod) {
    this.context.trackEvent({
      category: _metametrics.MetaMetricsEventCategory.Settings,
      event: eventName,
      properties: {
        action: eventAction,
        legacy_event: true
      }
    });
    toggleMethod(!value);
  }
  async toggleDataCollectionForMarketing(value) {
    if (this.props.socialLoginEnabled) {
      try {
        await this.props.setMarketingConsent(value);
      } catch (error) {
        _loglevel.default.error('Error setting marketing consent', error);
      }
    }
    this.props.setDataCollectionForMarketing(value);
    if (this.props.participateInMetaMetrics) {
      this.context.trackEvent({
        category: _metametrics.MetaMetricsEventCategory.Settings,
        event: _metametrics.MetaMetricsEventName.AnalyticsPreferenceSelected,
        properties: {
          is_metrics_opted_in: true,
          has_marketing_consent: Boolean(value),
          location: 'Settings'
        }
      });
    } else if (!this.props.socialLoginEnabled) {
      // for non-social login users, we need to set the participate in meta metrics to true if they have data collection for marketing
      this.props.setParticipateInMetaMetrics(true);
    }
  }
  renderSeedWords() {
    const {
      t
    } = this.context;
    const {
      isSeedPhraseBackedUp,
      socialLoginEnabled,
      socialLoginType,
      navigate,
      hdEntropyIndex
    } = this.props;
    const getBannerDescription = () => {
      if (socialLoginEnabled) {
        return t('securityLoginWithSocial', [(0, _lodash.capitalize)(socialLoginType)]);
      }
      return isSeedPhraseBackedUp ? t('securityLoginWithSrpBackedUp') : t('securityLoginWithSrpNotBackedUp');
    };
    const getBannerSeverity = () => {
      return isSeedPhraseBackedUp ? _componentLibrary.BannerAlertSeverity.Success : _componentLibrary.BannerAlertSeverity.Danger;
    };
    const getButtonText = () => {
      if (socialLoginEnabled) {
        return t('securitySrpWalletRecovery');
      }
      return t('revealSecretRecoveryPhrase');
    };
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
      ref: this.settingsRefs[1],
      className: "settings-page__security-tab-sub-header"
    }, t('secretRecoveryPhrase')), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-padded"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      className: "settings-page__content-row",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      gap: 4
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-description"
    }, t('securitySrpDescription')), /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerAlert, {
      "data-testid": "backup-state-banner-alert",
      description: getBannerDescription(),
      paddingTop: 2,
      paddingBottom: 2,
      marginTop: 4,
      severity: getBannerSeverity()
    })), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
      "data-testid": "reveal-seed-words",
      size: _componentLibrary.ButtonSize.Lg,
      onClick: event => {
        event.preventDefault();
        this.context.trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Settings,
          event: _metametrics.MetaMetricsEventName.KeyExportSelected,
          properties: {
            key_type: _metametrics.MetaMetricsEventKeyType.Srp,
            location: 'Settings',
            hd_entropy_index: hdEntropyIndex
          }
        });
        this.context.trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Settings,
          event: _metametrics.MetaMetricsEventName.SrpRevealClicked,
          properties: {
            key_type: _metametrics.MetaMetricsEventKeyType.Srp,
            location: 'Settings'
          }
        });
        navigate(_routes.REVEAL_SRP_LIST_ROUTE);
      }
    }, getButtonText()))), this.state.srpQuizModalVisible && /*#__PURE__*/_react.default.createElement(_SRPQuiz.default, {
      isOpen: this.state.srpQuizModalVisible,
      onClose: this.hideSrpQuizModal
    })));
  }
  renderChangePassword() {
    const {
      t
    } = this.context;
    const {
      navigate
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
      ref: this.settingsRefs[2],
      className: "settings-page__security-tab-sub-header"
    }, t('securityChangePasswordTitle')), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-padded"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      className: "settings-page__content-row",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      gap: 4
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-description"
    }, t('securityChangePasswordDescription'))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
      "data-testid": "change-password-button",
      size: _componentLibrary.ButtonSize.Lg,
      onClick: () => {
        navigate(_routes.SECURITY_PASSWORD_CHANGE_ROUTE);
      }
    }, t('securityChangePassword'))))));
  }
  renderSecurityAlertsToggle() {
    const {
      t
    } = this.context;
    const {
      securityAlertsEnabled,
      hasActiveShieldSubscription
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
      ref: this.settingsRefs[16]
    }, /*#__PURE__*/_react.default.createElement("span", {
      className: "settings-page__security-tab-sub-header"
    }, t('securityAlerts'))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-padded"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      ref: this.settingsRefs[2],
      className: "settings-page__content-row",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      justifyContent: _designSystem.JustifyContent.spaceBetween,
      gap: 4
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-description"
    }, t('securityAlertsDescription', [/*#__PURE__*/_react.default.createElement("a", {
      key: "learn_more_link",
      href: _uiUtils.SECURITY_ALERTS_LEARN_MORE_LINK,
      rel: "noreferrer",
      target: "_blank"
    }, t('learnMoreUpperCase'))]))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col",
      "data-testid": "securityAlert"
    }, /*#__PURE__*/_react.default.createElement(_toggleButton.default, {
      value: securityAlertsEnabled,
      onToggle: this.toggleSecurityAlert.bind(this),
      offLabel: t('off'),
      onLabel: t('on'),
      disabled: hasActiveShieldSubscription
    })))));
  }
  renderPhishingDetectionToggle() {
    const {
      t
    } = this.context;
    const {
      usePhishDetect,
      setUsePhishDetect,
      hasActiveShieldSubscription
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      ref: this.settingsRefs[4],
      className: "settings-page__content-row",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      justifyContent: _designSystem.JustifyContent.spaceBetween,
      gap: 4
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("span", null, t('usePhishingDetection')), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-description"
    }, t('usePhishingDetectionDescription'))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col",
      "data-testid": "usePhishingDetection"
    }, /*#__PURE__*/_react.default.createElement(_toggleButton.default, {
      value: usePhishDetect,
      onToggle: value => {
        setUsePhishDetect(!value);
      },
      offLabel: t('off'),
      onLabel: t('on'),
      disabled: hasActiveShieldSubscription
    })));
  }
  renderUse4ByteResolutionToggle() {
    const {
      t
    } = this.context;
    const {
      use4ByteResolution,
      setUse4ByteResolution
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      ref: this.settingsRefs[4],
      className: "settings-page__content-row",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      justifyContent: _designSystem.JustifyContent.spaceBetween,
      gap: 4
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("span", null, t('use4ByteResolution')), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-description"
    }, t('toggleDecodeDescription'))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col",
      "data-testid": "4byte-resolution-container"
    }, /*#__PURE__*/_react.default.createElement(_toggleButton.default, {
      value: use4ByteResolution,
      onToggle: value => setUse4ByteResolution(!value),
      offLabel: t('off'),
      onLabel: t('on')
    })));
  }
  renderDataCollectionForMarketing() {
    const {
      t
    } = this.context;
    const {
      dataCollectionForMarketing,
      useExternalServices,
      socialLoginEnabled,
      participateInMetaMetrics
    } = this.props;
    const handleToggle = this.toggleDataCollectionForMarketing.bind(this);
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      ref: this.settingsRefs[19],
      className: "settings-page__content-row",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      justifyContent: _designSystem.JustifyContent.spaceBetween,
      gap: 4
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("span", null, t('dataCollectionForMarketing')), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-description"
    }, /*#__PURE__*/_react.default.createElement("span", null, socialLoginEnabled ? t('dataCollectionForMarketingDescriptionSocialLogin') : t('dataCollectionForMarketingDescription')))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col",
      "data-testid": "data-collection-for-marketing-toggle"
    }, /*#__PURE__*/_react.default.createElement(_toggleButton.default, {
      value: dataCollectionForMarketing,
      disabled: !useExternalServices || !participateInMetaMetrics,
      onToggle: prev => handleToggle(!prev),
      offLabel: t('off'),
      onLabel: t('on')
    }))), this.state.hasEmailMarketingConsentError && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      paddingBottom: 4
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      as: "p",
      color: _designSystem.TextColor.errorDefault,
      variant: _designSystem.TextVariant.bodySm
    }, t('notificationsSettingsBoxError'))));
  }
  renderChooseYourNetworkButton() {
    const {
      t
    } = this.context;
    const {
      navigate
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      className: "settings-page__content-row",
      "data-testid": "advanced-setting-choose-your-network",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      gap: 4
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("span", null, t('chooseYourNetwork')), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-description"
    }, t('chooseYourNetworkDescription', [
    /*#__PURE__*/
    // TODO: Update to use real link
    _react.default.createElement("a", {
      href: _uiUtils.CONSENSYS_PRIVACY_LINK,
      target: "_blank",
      rel: "noopener noreferrer",
      key: "cyn-consensys-privacy-link"
    }, t('privacyMsg')), /*#__PURE__*/_react.default.createElement("a", {
      href: _zendeskUrl.default.SOLANA_ACCOUNTS,
      target: "_blank",
      rel: "noopener noreferrer",
      key: "cyn-consensys-privacy-link-solana"
    }, t('chooseYourNetworkDescriptionCallToAction'))]))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
      type: "secondary",
      className: "settings-page__button",
      onClick: () => {
        (0, _util.getEnvironmentType)() === _app.ENVIRONMENT_TYPE_POPUP ? global.platform.openExtensionInBrowser(_routes.ADD_POPULAR_CUSTOM_NETWORK) : navigate(_routes.ADD_POPULAR_CUSTOM_NETWORK);
      }
    }, t('addCustomNetwork'))));
  }
  renderSafeChainsListValidationToggle() {
    const {
      t
    } = this.context;
    const {
      useSafeChainsListValidation,
      setUseSafeChainsListValidation
    } = this.props;
    const useSafeChainsListValidationWebsite = t('useSafeChainsListValidationWebsite');
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      ref: this.settingsRefs[14],
      className: "settings-page__content-row",
      "data-testid": "setting-safe-chains-validation",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      gap: 4
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      className: "settings-page__content-row",
      gap: 4,
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      justifyContent: _designSystem.JustifyContent.spaceBetween
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("span", null, t('useSafeChainsListValidation')), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-description"
    }, t('useSafeChainsListValidationDescription', [/*#__PURE__*/_react.default.createElement("b", {
      key: "safechain-list-validation-website"
    }, useSafeChainsListValidationWebsite)]))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col",
      "data-testid": "useSafeChainsListValidation"
    }, /*#__PURE__*/_react.default.createElement(_toggleButton.default, {
      value: useSafeChainsListValidation,
      onToggle: value => setUseSafeChainsListValidation(!value),
      offLabel: t('off'),
      onLabel: t('on')
    }))));
  }
  renderIpfsGatewayControl() {
    const {
      t
    } = this.context;
    const {
      setIpfsGateway,
      setIsIpfsGatewayEnabled,
      useAddressBarEnsResolution,
      setUseAddressBarEnsResolution
    } = this.props;
    let ipfsError = '';
    const handleIpfsGatewayChange = url => {
      if (url.length > 0) {
        try {
          const validUrl = (0, _util.addUrlProtocolPrefix)(url);
          if (!validUrl) {
            ipfsError = t('invalidIpfsGateway');
          }
          const urlObj = new URL(validUrl);

          // don't allow the use of this gateway
          if (urlObj.host === 'gateway.ipfs.io') {
            ipfsError = t('forbiddenIpfsGateway');
          }
          if (ipfsError.length === 0) {
            setIpfsGateway(urlObj.host);
          }
        } catch (error) {
          ipfsError = t('invalidIpfsGateway');
        }
      } else {
        ipfsError = t('invalidIpfsGateway');
      }
      this.setState({
        ipfsGateway: url,
        ipfsGatewayError: ipfsError
      });
    };
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      ref: this.settingsRefs[7],
      className: "settings-page__content-row",
      "data-testid": "setting-ipfs-gateway",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      gap: 4
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      className: "settings-page__content-row",
      gap: 4,
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      justifyContent: _designSystem.JustifyContent.spaceBetween
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("span", null, t('ipfsGateway')), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-description"
    }, t('ipfsGatewayDescription'))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col",
      "data-testid": "ipfsToggle"
    }, /*#__PURE__*/_react.default.createElement(_toggleButton.default, {
      value: this.state.ipfsToggle,
      onToggle: value => {
        if (value) {
          // turning from true to false
          setIsIpfsGatewayEnabled(false);
          setIpfsGateway('');
        } else {
          // turning from false to true
          setIsIpfsGatewayEnabled(true);
          handleIpfsGatewayChange(this.state.ipfsGateway);
        }
        this.setState({
          ipfsToggle: !value
        });
      },
      offLabel: t('off'),
      onLabel: t('on')
    }))), this.state.ipfsToggle && /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("span", null, t('addIPFSGateway')), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col"
    }, /*#__PURE__*/_react.default.createElement(_textField.default, {
      type: "text",
      value: this.state.ipfsGateway,
      onChange: e => handleIpfsGatewayChange(e.target.value),
      error: this.state.ipfsGatewayError,
      fullWidth: true,
      margin: "dense"
    }))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      className: "settings-page__content-row",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      justifyContent: _designSystem.JustifyContent.spaceBetween,
      gap: 4,
      ref: this.settingsRefs[11],
      marginTop: 3,
      id: "ens-domains"
    }, /*#__PURE__*/_react.default.createElement("div", null, t('ensDomainsSettingTitle'), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-description"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      color: _designSystem.TextColor.inherit,
      variant: _designSystem.TextVariant.inherit
    }, t('ensDomainsSettingDescriptionIntroduction')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      as: "ul",
      marginTop: 4,
      marginBottom: 4,
      paddingInlineStart: 4,
      style: {
        listStyleType: 'circle'
      }
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      as: "li",
      color: _designSystem.TextColor.inherit,
      variant: _designSystem.TextVariant.inherit
    }, t('ensDomainsSettingDescriptionPart1')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      as: "li",
      color: _designSystem.TextColor.inherit,
      variant: _designSystem.TextVariant.inherit
    }, t('ensDomainsSettingDescriptionPart2'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      color: _designSystem.TextColor.inherit,
      variant: _designSystem.TextVariant.inherit
    }, t('ensDomainsSettingDescriptionOutroduction')))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col",
      "data-testid": "ipfs-gateway-resolution-container"
    }, /*#__PURE__*/_react.default.createElement(_toggleButton.default, {
      value: useAddressBarEnsResolution,
      onToggle: value => setUseAddressBarEnsResolution(!value),
      offLabel: t('off'),
      onLabel: t('on')
    }))));
  }
  renderAutoDetectTokensToggle() {
    const {
      t
    } = this.context;
    const {
      useTokenDetection,
      setUseTokenDetection
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      ref: this.settingsRefs[8],
      className: "settings-page__content-row",
      "data-testid": "advanced-setting-gas-fee-estimation",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      justifyContent: _designSystem.JustifyContent.spaceBetween,
      gap: 4,
      id: "advanced-settings-autodetect-tokens"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("span", null, t('autoDetectTokens')), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-description"
    }, t('autoDetectTokensDescription', [
    /*#__PURE__*/
    // TODO: Update to use real link
    _react.default.createElement("a", {
      href: _uiUtils.AUTO_DETECT_TOKEN_LEARN_MORE_LINK,
      target: "_blank",
      rel: "noopener noreferrer",
      key: "cyn-consensys-privacy-link"
    }, (0, _lodash.startCase)(t('learnMore')))]))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col",
      "data-testid": "autoDetectTokens"
    }, /*#__PURE__*/_react.default.createElement(_toggleButton.default, {
      value: useTokenDetection,
      onToggle: value => {
        this.toggleSetting(value, _metametrics.MetaMetricsEventName.KeyAutoDetectTokens, _metametrics.MetaMetricsEventName.KeyAutoDetectTokens, setUseTokenDetection);
      },
      offLabel: t('off'),
      onLabel: t('on')
    })));
  }
  renderBatchAccountBalanceRequestsToggle() {
    const {
      t
    } = this.context;
    const {
      useMultiAccountBalanceChecker,
      setUseMultiAccountBalanceChecker
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      ref: this.settingsRefs[9],
      className: "settings-page__content-row",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      justifyContent: _designSystem.JustifyContent.spaceBetween,
      gap: 4
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("span", null, t('useMultiAccountBalanceChecker')), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-description"
    }, t('useMultiAccountBalanceCheckerSettingDescription'))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col",
      "data-testid": "useMultiAccountBalanceChecker"
    }, /*#__PURE__*/_react.default.createElement(_toggleButton.default, {
      value: useMultiAccountBalanceChecker,
      onToggle: value => {
        this.toggleSetting(value, _metametrics.MetaMetricsEventName.KeyBatchAccountBalanceRequests, _metametrics.MetaMetricsEventName.KeyBatchAccountBalanceRequests, setUseMultiAccountBalanceChecker);
      },
      offLabel: t('off'),
      onLabel: t('on')
    })));
  }
  renderCurrencyRateCheckToggle() {
    const {
      t
    } = this.context;
    const {
      useCurrencyRateCheck,
      setUseCurrencyRateCheck
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      ref: this.settingsRefs[10],
      className: "settings-page__content-row",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      justifyContent: _designSystem.JustifyContent.spaceBetween,
      gap: 4
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("span", null, t('currencyRateCheckToggle')), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-description"
    }, t('currencyRateCheckToggleDescription', [/*#__PURE__*/_react.default.createElement("a", {
      key: "coingecko_link",
      href: _uiUtils.COINGECKO_LINK,
      rel: "noreferrer",
      target: "_blank"
    }, t('coingecko')), /*#__PURE__*/_react.default.createElement("a", {
      key: "cryptocompare_link",
      href: _uiUtils.CRYPTOCOMPARE_LINK,
      rel: "noreferrer",
      target: "_blank"
    }, t('cryptoCompare')), /*#__PURE__*/_react.default.createElement("a", {
      key: "privacy_policy_link",
      href: _uiUtils.PRIVACY_POLICY_LINK,
      rel: "noreferrer",
      target: "_blank"
    }, t('privacyMsg'))]))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col",
      "data-testid": "currencyRateCheckToggle"
    }, /*#__PURE__*/_react.default.createElement(_toggleButton.default, {
      value: useCurrencyRateCheck,
      onToggle: value => setUseCurrencyRateCheck(!value),
      offLabel: t('off'),
      onLabel: t('on')
    })));
  }
  renderDisplayNftMediaToggle() {
    const {
      t
    } = this.context;
    const {
      openSeaEnabled,
      setOpenSeaEnabled,
      useNftDetection,
      setUseNftDetection
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      ref: this.settingsRefs[12],
      className: "settings-page__content-row",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      justifyContent: _designSystem.JustifyContent.spaceBetween,
      gap: 4,
      id: "display-nft-media"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("span", null, t('displayNftMedia')), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-description"
    }, t('displayNftMediaDescription'))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col",
      "data-testid": "displayNftMedia"
    }, /*#__PURE__*/_react.default.createElement(_toggleButton.default, {
      value: openSeaEnabled,
      onToggle: value => {
        this.context.trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Settings,
          event: 'Enabled/Disable OpenSea',
          properties: {
            action: 'Enabled/Disable OpenSea',
            legacy_event: true
          }
        });
        // value is positive when being toggled off
        if (value && useNftDetection) {
          setUseNftDetection(false);
        }
        setOpenSeaEnabled(!value);
      },
      offLabel: t('off'),
      onLabel: t('on')
    })));
  }
  renderNftDetectionToggle() {
    const {
      t
    } = this.context;
    const {
      openSeaEnabled,
      setOpenSeaEnabled,
      useNftDetection,
      setUseNftDetection
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      ref: this.settingsRefs[13],
      className: "settings-page__content-row",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      justifyContent: _designSystem.JustifyContent.spaceBetween,
      gap: 4
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("span", null, t('useNftDetection')), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-description"
    }, t('useNftDetectionDescriptionText'))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col",
      "data-testid": "useNftDetection"
    }, /*#__PURE__*/_react.default.createElement(_toggleButton.default, {
      value: useNftDetection,
      onToggle: value => {
        this.context.trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Settings,
          event: 'NFT Detected',
          properties: {
            action: 'NFT Detected',
            legacy_event: true
          }
        });
        if (!value && !openSeaEnabled) {
          setOpenSeaEnabled(!value);
        }
        setUseNftDetection(!value);
      },
      offLabel: t('off'),
      onLabel: t('on')
    })));
  }
  renderExternalNameSourcesToggle() {
    const {
      t
    } = this.context;
    const {
      useExternalNameSources,
      setUseExternalNameSources
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      ref: this.settingsRefs[15],
      className: "settings-page__content-row",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      justifyContent: _designSystem.JustifyContent.spaceBetween,
      gap: 4
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("span", null, t('externalNameSourcesSetting')), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-description"
    }, t('externalNameSourcesSettingDescription'))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col",
      "data-testid": "useExternalNameSources"
    }, /*#__PURE__*/_react.default.createElement(_toggleButton.default, {
      value: useExternalNameSources,
      onToggle: value => setUseExternalNameSources(!value),
      offLabel: t('off'),
      onLabel: t('on')
    })));
  }
  renderSimulationsToggle() {
    const {
      t
    } = this.context;
    const {
      useTransactionSimulations,
      setUseTransactionSimulations,
      hasActiveShieldSubscription
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      ref: this.settingsRefs[17],
      className: "settings-page__content-row",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      justifyContent: _designSystem.JustifyContent.spaceBetween,
      gap: 4
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("span", null, t('simulationsSettingSubHeader')), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-description"
    }, t('simulationsSettingDescription', [/*#__PURE__*/_react.default.createElement("a", {
      key: "learn_more_link",
      href: _uiUtils.TRANSACTION_SIMULATIONS_LEARN_MORE_LINK,
      rel: "noreferrer",
      target: "_blank"
    }, t('learnMoreUpperCase'))]))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col",
      "data-testid": "useTransactionSimulations"
    }, /*#__PURE__*/_react.default.createElement(_toggleButton.default, {
      value: useTransactionSimulations,
      onToggle: value => {
        setUseTransactionSimulations(!value);
      },
      offLabel: t('off'),
      onLabel: t('on'),
      disabled: hasActiveShieldSubscription
    })));
  }

  /**
   * toggleSecurityAlert
   *
   * @param {boolean} oldValue - the current securityAlertEnabled value.
   */
  toggleSecurityAlert(oldValue) {
    const newValue = !oldValue;
    const {
      setSecurityAlertsEnabled
    } = this.props;
    this.context.trackEvent({
      category: _metametrics.MetaMetricsEventCategory.Settings,
      event: _metametrics.MetaMetricsEventName.SettingsUpdated,
      properties: {
        blockaid_alerts_enabled: newValue
      }
    });
    setSecurityAlertsEnabled(newValue);
  }
  renderUseExternalServices() {
    const {
      t
    } = this.context;
    const {
      useExternalServices,
      toggleExternalServices,
      setBasicFunctionalityModalOpen
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      ref: this.settingsRefs[0],
      className: "settings-page__content-row",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      justifyContent: _designSystem.JustifyContent.spaceBetween,
      gap: 4,
      "data-testid": "advanced-setting-show-testnet-conversion"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      justifyContent: _designSystem.JustifyContent.spaceBetween,
      alignItems: _designSystem.AlignItems.center,
      marginBottom: 2
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.headingSm
    }, t('basicConfigurationLabel')), /*#__PURE__*/_react.default.createElement(_toggleButton.default, {
      value: useExternalServices,
      onToggle: () => {
        if (useExternalServices) {
          // If we are going to be disabling external services, then we want to show the "turn off" warning modal
          setBasicFunctionalityModalOpen();
        } else {
          toggleExternalServices(true);
          this.context.trackEvent({
            category: _metametrics.MetaMetricsEventCategory.Settings,
            event: _metametrics.MetaMetricsEventName.SettingsUpdated,
            properties: {
              settings_group: 'security_privacy',
              settings_type: 'basic_functionality',
              old_value: false,
              new_value: true,
              // these values will always be set to false
              // when basic functionality is re-enabled
              was_notifications_on: false,
              was_profile_syncing_on: false
            }
          });
        }
      },
      offLabel: t('off'),
      onLabel: t('on')
    })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      marginBottom: 2,
      color: _designSystem.TextColor.textAlternative
    }, t('basicConfigurationDescription', [/*#__PURE__*/_react.default.createElement("a", {
      href: "https://consensys.io/privacy-policy",
      key: "link",
      target: "_blank",
      rel: "noreferrer noopener"
    }, t('privacyMsg'))]))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col"
    }));
  }
  renderSkipDeepLinkInterstitial() {
    const {
      t
    } = this.context;
    const {
      skipDeepLinkInterstitial,
      setSkipDeepLinkInterstitial
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      ref: this.settingsRefs[3],
      className: "settings-page__content-row",
      "data-testid": "setting-skip-deep-link-interstitial",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      gap: 4,
      id: "skip-deep-link-interstitial"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      className: "settings-page__content-row",
      gap: 4,
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      justifyContent: _designSystem.JustifyContent.spaceBetween
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("span", null, t('skipDeepLinkInterstitial')), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-description"
    }, t('skipDeepLinkInterstitialDescription'))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col",
      "data-testid": "skipDeepLinkInterstitial"
    }, /*#__PURE__*/_react.default.createElement(_toggleButton.default, {
      value: skipDeepLinkInterstitial,
      onToggle: value => setSkipDeepLinkInterstitial(!value),
      offLabel: t('off'),
      onLabel: t('on')
    })))));
  }
  render() {
    const {
      petnamesEnabled,
      dataCollectionForMarketing
    } = this.props;
    const {
      showDataCollectionDisclaimer
    } = this.state;
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__body"
    }, this.renderUseExternalServices(), showDataCollectionDisclaimer ? this.renderDataCollectionWarning() : null, /*#__PURE__*/_react.default.createElement("span", {
      className: "settings-page__security-tab-sub-header__bold"
    }, this.context.t('security')), this.renderSeedWords(), (0, _environment.getIsSeedlessOnboardingFeatureEnabled)() && this.renderChangePassword(), this.renderSecurityAlertsToggle(), /*#__PURE__*/_react.default.createElement("span", {
      className: "settings-page__security-tab-sub-header__bold"
    }, this.context.t('privacy')), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("span", {
      className: "settings-page__security-tab-sub-header"
    }, this.context.t('alerts'))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-padded"
    }, this.renderPhishingDetectionToggle()), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-padded"
    }, this.renderSkipDeepLinkInterstitial()), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("span", {
      className: "settings-page__security-tab-sub-header"
    }, this.context.t('smartContracts'))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-padded"
    }, this.renderUse4ByteResolutionToggle()), /*#__PURE__*/_react.default.createElement("span", {
      className: "settings-page__security-tab-sub-header"
    }, this.context.t('transactions')), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-padded"
    }, this.renderCurrencyRateCheckToggle(), this.renderSimulationsToggle()), /*#__PURE__*/_react.default.createElement("span", {
      className: "settings-page__security-tab-sub-header",
      ref: this.settingsRefs[6]
    }, this.context.t('networkProvider')), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-padded"
    }, this.renderChooseYourNetworkButton(), this.renderSafeChainsListValidationToggle(), this.renderIpfsGatewayControl()), /*#__PURE__*/_react.default.createElement("span", {
      className: "settings-page__security-tab-sub-header"
    }, this.context.t('tokenAutoDetection')), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-padded"
    }, this.renderAutoDetectTokensToggle(), this.renderBatchAccountBalanceRequestsToggle(), this.renderDisplayNftMediaToggle(), this.renderNftDetectionToggle()), petnamesEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
      className: "settings-page__security-tab-sub-header"
    }, this.context.t('settingsSubHeadingSignaturesAndTransactions')), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-padded"
    }, this.renderExternalNameSourcesToggle())), /*#__PURE__*/_react.default.createElement("span", {
      className: "settings-page__security-tab-sub-header"
    }, this.context.t('metrics')), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-padded"
    }, /*#__PURE__*/_react.default.createElement(_metametricsToggle.default, {
      dataCollectionForMarketing: dataCollectionForMarketing,
      setDataCollectionForMarketing: this.toggleDataCollectionForMarketing.bind(this)
    }), this.renderDataCollectionForMarketing(), /*#__PURE__*/_react.default.createElement(_deleteMetametricsDataButton.default, {
      ref: this.settingsRefs[20]
    })));
  }
}
exports.default = SecurityTab;
_defineProperty(SecurityTab, "contextTypes", {
  t: _propTypes.default.func,
  trackEvent: _propTypes.default.func
});
_defineProperty(SecurityTab, "propTypes", {
  navigate: _propTypes.default.func.isRequired,
  openSeaEnabled: _propTypes.default.bool,
  setOpenSeaEnabled: _propTypes.default.func,
  useNftDetection: _propTypes.default.bool,
  setUseNftDetection: _propTypes.default.func,
  dataCollectionForMarketing: _propTypes.default.bool,
  setDataCollectionForMarketing: _propTypes.default.func.isRequired,
  participateInMetaMetrics: _propTypes.default.bool.isRequired,
  setParticipateInMetaMetrics: _propTypes.default.func.isRequired,
  setUsePhishDetect: _propTypes.default.func.isRequired,
  usePhishDetect: _propTypes.default.bool.isRequired,
  setUse4ByteResolution: _propTypes.default.func.isRequired,
  use4ByteResolution: _propTypes.default.bool.isRequired,
  useTokenDetection: _propTypes.default.bool.isRequired,
  setUseTokenDetection: _propTypes.default.func.isRequired,
  setIpfsGateway: _propTypes.default.func.isRequired,
  setIsIpfsGatewayEnabled: _propTypes.default.func.isRequired,
  ipfsGateway: _propTypes.default.string.isRequired,
  useMultiAccountBalanceChecker: _propTypes.default.bool.isRequired,
  setUseMultiAccountBalanceChecker: _propTypes.default.func.isRequired,
  useSafeChainsListValidation: _propTypes.default.bool.isRequired,
  setUseSafeChainsListValidation: _propTypes.default.func.isRequired,
  useCurrencyRateCheck: _propTypes.default.bool.isRequired,
  setUseCurrencyRateCheck: _propTypes.default.func.isRequired,
  useAddressBarEnsResolution: _propTypes.default.bool.isRequired,
  setUseAddressBarEnsResolution: _propTypes.default.func.isRequired,
  useExternalNameSources: _propTypes.default.bool.isRequired,
  setUseExternalNameSources: _propTypes.default.func.isRequired,
  setBasicFunctionalityModalOpen: _propTypes.default.func.isRequired,
  setUseTransactionSimulations: _propTypes.default.func.isRequired,
  useTransactionSimulations: _propTypes.default.bool.isRequired,
  petnamesEnabled: _propTypes.default.bool.isRequired,
  securityAlertsEnabled: _propTypes.default.bool,
  useExternalServices: _propTypes.default.bool,
  toggleExternalServices: _propTypes.default.func,
  setSkipDeepLinkInterstitial: _propTypes.default.func.isRequired,
  skipDeepLinkInterstitial: _propTypes.default.bool,
  setSecurityAlertsEnabled: _propTypes.default.func,
  metaMetricsDataDeletionId: _propTypes.default.string,
  hdEntropyIndex: _propTypes.default.number,
  isSeedPhraseBackedUp: _propTypes.default.bool,
  socialLoginEnabled: _propTypes.default.bool,
  socialLoginType: _propTypes.default.string,
  setMarketingConsent: _propTypes.default.func,
  getMarketingConsent: _propTypes.default.func,
  hasActiveShieldSubscription: _propTypes.default.bool
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\security-tab\\security-tab.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\security-tab\\security-tab.container.js", {"../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../ducks/app/app":"D:\\code\\v\\metamask-extension\\ui\\ducks\\app\\app.ts","../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../helpers/higher-order-components/with-router-hooks/with-router-hooks":"D:\\code\\v\\metamask-extension\\ui\\helpers\\higher-order-components\\with-router-hooks\\with-router-hooks.tsx","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/subscription":"D:\\code\\v\\metamask-extension\\ui\\selectors\\subscription\\index.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./security-tab.component":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\security-tab\\security-tab.component.js","@metamask/subscription-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\subscription-controller\\dist\\index.cjs","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","redux":"D:\\code\\v\\metamask-extension\\node_modules\\redux\\lib\\redux.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Csecurity-tab%5Csecurity-tab.container.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactRedux = require("react-redux");
var _redux = require("redux");
var _subscriptionController = require("@metamask/subscription-controller");
var _withRouterHooks = _interopRequireDefault(require("../../../helpers/higher-order-components/with-router-hooks/with-router-hooks"));
var _actions = require("../../../store/actions");
var _selectors = require("../../../selectors");
var _networks = require("../../../../shared/modules/selectors/networks");
var _app = require("../../../ducks/app/app");
var _metamask = require("../../../ducks/metamask/metamask");
var _subscription = require("../../../selectors/subscription");
var _securityTab = _interopRequireDefault(require("./security-tab.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const mapStateToProps = state => {
  const {
    metamask
  } = state;
  const {
    usePhishDetect,
    useTokenDetection,
    ipfsGateway,
    useMultiAccountBalanceChecker,
    useSafeChainsListValidation,
    useCurrencyRateCheck,
    useAddressBarEnsResolution,
    openSeaEnabled,
    useNftDetection,
    use4ByteResolution,
    useExternalServices,
    useExternalNameSources
  } = metamask;
  const {
    skipDeepLinkInterstitial
  } = (0, _selectors.getPreferences)(state);
  const networkConfigurations = (0, _networks.getNetworkConfigurationsByChainId)(state);
  const {
    subscriptions
  } = (0, _subscription.getUserSubscriptions)(state);
  // get shield subscription
  const shieldSubscription = subscriptions.find(subscription => subscription.products.some(product => product.name === _subscriptionController.PRODUCT_TYPES.SHIELD));
  const hasActiveShieldSubscription = [_subscriptionController.SUBSCRIPTION_STATUSES.active, _subscriptionController.SUBSCRIPTION_STATUSES.trialing, _subscriptionController.SUBSCRIPTION_STATUSES.provisional].includes(shieldSubscription === null || shieldSubscription === void 0 ? void 0 : shieldSubscription.status);
  return {
    networkConfigurations,
    participateInMetaMetrics: (0, _selectors.getParticipateInMetaMetrics)(state),
    dataCollectionForMarketing: (0, _selectors.getDataCollectionForMarketing)(state),
    usePhishDetect,
    useTokenDetection,
    hasActiveShieldSubscription,
    ipfsGateway,
    useMultiAccountBalanceChecker,
    useSafeChainsListValidation,
    useCurrencyRateCheck,
    useAddressBarEnsResolution,
    openSeaEnabled,
    useNftDetection,
    use4ByteResolution,
    useExternalNameSources,
    useExternalServices,
    securityAlertsEnabled: (0, _selectors.getIsSecurityAlertsEnabled)(state),
    useTransactionSimulations: metamask.useTransactionSimulations,
    metaMetricsDataDeletionId: (0, _selectors.getMetaMetricsDataDeletionId)(state),
    hdEntropyIndex: (0, _selectors.getHDEntropyIndex)(state),
    skipDeepLinkInterstitial: Boolean(skipDeepLinkInterstitial),
    isSeedPhraseBackedUp: (0, _metamask.getIsPrimarySeedPhraseBackedUp)(state),
    socialLoginEnabled: (0, _selectors.getIsSocialLoginFlow)(state),
    socialLoginType: (0, _selectors.getSocialLoginType)(state)
  };
};
const mapDispatchToProps = dispatch => {
  return {
    setParticipateInMetaMetrics: val => dispatch((0, _actions.setParticipateInMetaMetrics)(val)),
    setDataCollectionForMarketing: val => dispatch((0, _actions.setDataCollectionForMarketing)(val)),
    setUsePhishDetect: val => dispatch((0, _actions.setUsePhishDetect)(val)),
    setUseCurrencyRateCheck: val => dispatch((0, _actions.setUseCurrencyRateCheck)(val)),
    setUseTokenDetection: val => dispatch((0, _actions.setUseTokenDetection)(val)),
    setIpfsGateway: val => dispatch((0, _actions.setIpfsGateway)(val)),
    setIsIpfsGatewayEnabled: val => dispatch((0, _actions.setIsIpfsGatewayEnabled)(val)),
    setUseMultiAccountBalanceChecker: val => dispatch((0, _actions.setUseMultiAccountBalanceChecker)(val)),
    setUseAddressBarEnsResolution: val => dispatch((0, _actions.setUseAddressBarEnsResolution)(val)),
    setUseSafeChainsListValidation: val => dispatch((0, _actions.setUseSafeChainsListValidation)(val)),
    setBasicFunctionalityModalOpen: () => dispatch((0, _app.openBasicFunctionalityModal)()),
    setSkipDeepLinkInterstitial: val => dispatch((0, _actions.setSkipDeepLinkInterstitial)(val)),
    setOpenSeaEnabled: val => dispatch((0, _actions.setOpenSeaEnabled)(val)),
    setUseNftDetection: val => dispatch((0, _actions.setUseNftDetection)(val)),
    setUse4ByteResolution: value => {
      return dispatch((0, _actions.setUse4ByteResolution)(value));
    },
    setUseExternalNameSources: value => {
      return dispatch((0, _actions.setUseExternalNameSources)(value));
    },
    toggleExternalServices: value => {
      return dispatch((0, _actions.toggleExternalServices)(value));
    },
    setUseTransactionSimulations: value => {
      return dispatch((0, _actions.setUseTransactionSimulations)(value));
    },
    updateDataDeletionTaskStatus: () => {
      return (0, _actions.updateDataDeletionTaskStatus)();
    },
    setSecurityAlertsEnabled: value => (0, _actions.setSecurityAlertsEnabled)(value),
    getMarketingConsent: () => (0, _actions.getMarketingConsent)(),
    setMarketingConsent: value => dispatch((0, _actions.setMarketingConsent)(value))
  };
};
var _default = exports.default = (0, _redux.compose)(_withRouterHooks.default, (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps))(_securityTab.default);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\security-tab\\security-tab.container.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\settings-search-list\\index.js", {"./settings-search-list":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\settings-search-list\\settings-search-list.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Csettings-search-list%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _settingsSearchList = _interopRequireDefault(require("./settings-search-list"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
var _default = exports.default = _settingsSearchList.default;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\settings-search-list\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\settings-search-list\\settings-search-list.js", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/settings-search":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\settings-search.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Csettings-search-list%5Csettings-search-list.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = SettingsSearchList;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _settingsSearch = require("../../../helpers/utils/settings-search");
var _i18n = require("../../../contexts/i18n");
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SettingsSearchList({
  results,
  onClickSetting
}) {
  const t = (0, _react.useContext)(_i18n.I18nContext);
  (0, _react.useEffect)(_settingsSearch.highlightSearchedText, [results]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "settings-page__header__search__list"
  }, results.slice(0, 5).map(result => {
    const {
      icon,
      iconName,
      tabMessage,
      sectionMessage,
      route
    } = result;
    return Boolean(icon || tabMessage || sectionMessage) && /*#__PURE__*/_react.default.createElement("div", {
      key: `settings_${route}`
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__header__search__list__item",
      onClick: () => onClickSetting(result)
    }, iconName ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
      name: iconName
    }) : /*#__PURE__*/_react.default.createElement("i", {
      className: (0, _classnames.default)('settings-page__header__search__list__item__icon', icon)
    }), /*#__PURE__*/_react.default.createElement("span", {
      id: `menu-tab_${route}`,
      className: (0, _classnames.default)('settings-page__header__search__list__item__tab', {
        'settings-page__header__search__list__item__tab-multiple-lines': tabMessage(t) === t('securityAndPrivacy')
      })
    }, tabMessage(t)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
      name: _componentLibrary.IconName.ArrowRight,
      size: _designSystem.Size.SM,
      className: "settings-page__header__search__list__item__caret"
    }), /*#__PURE__*/_react.default.createElement("span", {
      id: `menu-section_${route}`,
      className: (0, _classnames.default)('settings-page__header__search__list__item__section', {
        'settings-page__header__search__list__item__section-multiple-lines': tabMessage(t) === t('securityAndPrivacy') || tabMessage(t) === t('alerts')
      })
    }, sectionMessage(t))));
  }), results.length === 0 && /*#__PURE__*/_react.default.createElement("div", {
    className: "settings-page__header__search__list__item",
    style: {
      cursor: 'auto',
      display: 'flex'
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "settings-page__header__search__list__item__no-matching"
  }, t('settingsSearchMatchingNotFound'))), /*#__PURE__*/_react.default.createElement("div", {
    className: "settings-page__header__search__list__item",
    style: {
      cursor: 'auto',
      display: 'flex'
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "settings-page__header__search__list__item__request"
  }, t('missingSetting')), /*#__PURE__*/_react.default.createElement("a", {
    href: "https://community.metamask.io/c/feature-requests-ideas/13",
    target: "_blank",
    rel: "noopener noreferrer",
    key: "need-help-link",
    className: "settings-page__header__search__list__item__link"
  }, t('missingSettingRequest'))));
}
SettingsSearchList.propTypes = {
  results: _propTypes.default.array,
  onClickSetting: _propTypes.default.func
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\settings-search-list\\settings-search-list.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\settings-search\\index.js", {"./settings-search":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\settings-search\\settings-search.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Csettings-search%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _settingsSearch = _interopRequireDefault(require("./settings-search"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
var _default = exports.default = _settingsSearch.default;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\settings-search\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\settings-search\\settings-search.js", {"../../../../shared/modules/string-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\string-utils.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/ui/text-field":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\text-field\\index.js","../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","@material-ui/core/InputAdornment":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\InputAdornment\\index.js","fuse.js":"D:\\code\\v\\metamask-extension\\node_modules\\fuse.js\\dist\\fuse.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Csettings-search%5Csettings-search.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = SettingsSearch;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _fuse = _interopRequireDefault(require("fuse.js"));
var _InputAdornment = _interopRequireDefault(require("@material-ui/core/InputAdornment"));
var _textField = _interopRequireDefault(require("../../../components/ui/text-field"));
var _i18n = require("../../../contexts/i18n");
var _stringUtils = require("../../../../shared/modules/string-utils");
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SettingsSearch({
  onSearch,
  error,
  settingsRoutesList
}) {
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const [searchQuery, setSearchQuery] = (0, _react.useState)('');
  const [searchIconColor, setSearchIconColor] = (0, _react.useState)(_designSystem.IconColor.iconMuted);
  const settingsRoutesListArray = Object.values(settingsRoutesList);
  const settingsSearchFuse = new _fuse.default(settingsRoutesListArray, {
    shouldSort: true,
    threshold: 0.3,
    location: 0,
    distance: 100,
    maxPatternLength: 32,
    minMatchCharLength: 1,
    keys: ['tabMessage', 'sectionMessage', 'descriptionMessage'],
    getFn: (routeObject, path) => routeObject[path](t)
  });
  const handleSearch = _searchQuery => {
    const sanitizedSearchQuery = _searchQuery.trimStart();
    setSearchQuery(sanitizedSearchQuery);
    if (sanitizedSearchQuery === '') {
      setSearchIconColor(_designSystem.IconColor.iconMuted);
    } else {
      setSearchIconColor(_designSystem.IconColor.iconDefault);
    }
    const fuseSearchResult = settingsSearchFuse.search(sanitizedSearchQuery);
    const addressSearchResult = settingsRoutesListArray.filter(routes => {
      return routes.tabMessage && sanitizedSearchQuery && (0, _stringUtils.isEqualCaseInsensitive)(routes.tab, sanitizedSearchQuery);
    });
    const results = [...addressSearchResult, ...fuseSearchResult];
    onSearch({
      searchQuery: sanitizedSearchQuery,
      results
    });
  };
  const renderStartAdornment = () => {
    return /*#__PURE__*/_react.default.createElement(_InputAdornment.default, {
      position: "start",
      style: {
        marginRight: '12px'
      }
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
      size: _componentLibrary.IconSize.Sm,
      name: _componentLibrary.IconName.Search,
      color: searchIconColor
    }));
  };
  const renderEndAdornment = () => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, searchQuery && /*#__PURE__*/_react.default.createElement(_InputAdornment.default, {
      className: "imageclosectn",
      position: "end",
      onClick: () => handleSearch(''),
      style: {
        cursor: 'pointer'
      }
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
      name: _componentLibrary.IconName.Close,
      color: _designSystem.IconColor.iconDefault,
      size: _componentLibrary.IconSize.Xs
    })));
  };
  return /*#__PURE__*/_react.default.createElement(_textField.default, {
    id: "search-settings",
    placeholder: t('search'),
    type: "text",
    value: searchQuery,
    onChange: e => handleSearch(e.target.value),
    error: error,
    fullWidth: true,
    autoFocus: true,
    autoComplete: "off",
    startAdornment: renderStartAdornment(),
    endAdornment: renderEndAdornment(),
    theme: "bordered"
  });
}
SettingsSearch.propTypes = {
  onSearch: _propTypes.default.func,
  error: _propTypes.default.string,
  settingsRoutesList: _propTypes.default.array
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\settings-search\\settings-search.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\settings-tab\\index.js", {"./settings-tab.container":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\settings-tab\\settings-tab.container.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Csettings-tab%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _settingsTab.default;
  }
});
var _settingsTab = _interopRequireDefault(require("./settings-tab.container"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\settings-tab\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\settings-tab\\settings-tab.component.js", {"../../../../app/_locales/index.json":"D:\\code\\v\\metamask-extension\\app\\_locales\\index.json","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/preferences":"D:\\code\\v\\metamask-extension\\shared\\constants\\preferences.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/ui/dropdown":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\dropdown\\index.js","../../../components/ui/toggle-button":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\toggle-button\\index.js","../../../helpers/constants/available-conversions.json":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\available-conversions.json","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/settings-search":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\settings-search.js","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Csettings-tab%5Csettings-tab.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _designSystemReact = require("@metamask/design-system-react");
var _availableConversions = _interopRequireDefault(require("../../../helpers/constants/available-conversions.json"));
var _designSystem = require("../../../helpers/constants/design-system");
var _dropdown = _interopRequireDefault(require("../../../components/ui/dropdown"));
var _toggleButton = _interopRequireDefault(require("../../../components/ui/toggle-button"));
var _index = _interopRequireDefault(require("../../../../app/_locales/index.json"));
var _metametrics = require("../../../../shared/constants/metametrics");
var _settingsSearch = require("../../../helpers/utils/settings-search");
var _preferences = require("../../../../shared/constants/preferences");
var _componentLibrary = require("../../../components/component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } // TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths
const sortedCurrencies = _availableConversions.default.sort((a, b) => {
  return a.name.toLocaleLowerCase().localeCompare(b.name.toLocaleLowerCase());
});
const currencyOptions = sortedCurrencies.map(({
  code,
  name
}) => {
  return {
    name: `${code.toUpperCase()} - ${name}`,
    value: code
  };
});
const localeOptions = _index.default.map(locale => {
  return {
    name: `${locale.name}`,
    value: locale.code
  };
});
class SettingsTab extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "settingsRefs", Array((0, _settingsSearch.getNumberOfSettingRoutesInTab)(this.context.t, this.context.t('general'))).fill(undefined).map(() => {
      return /*#__PURE__*/_react.default.createRef();
    }));
  }
  componentDidUpdate() {
    const {
      t
    } = this.context;
    (0, _settingsSearch.handleSettingsRefs)(t, t('general'), this.settingsRefs);
  }
  componentDidMount() {
    const {
      t
    } = this.context;
    (0, _settingsSearch.handleSettingsRefs)(t, t('general'), this.settingsRefs);
  }
  renderCurrentConversion() {
    const {
      t
    } = this.context;
    const {
      currentCurrency,
      setCurrentCurrency
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      ref: this.settingsRefs[0],
      className: "settings-page__content-row",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMd,
      color: _designSystem.TextColor.textDefault,
      className: "settings-page__content-item__title"
    }, t('currencyConversion'))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col"
    }, /*#__PURE__*/_react.default.createElement(_dropdown.default, {
      "data-testid": "currency-select",
      id: "select-currency",
      options: currencyOptions,
      selectedOption: currentCurrency,
      onChange: newCurrency => {
        setCurrentCurrency(newCurrency);
        this.context.trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Settings,
          event: _metametrics.MetaMetricsEventName.CurrentCurrency,
          properties: {
            current_currency: newCurrency
          }
        });
      },
      className: "settings-page__content-item__dropdown"
    }))));
  }
  renderCurrentLocale() {
    const {
      t
    } = this.context;
    const {
      updateCurrentLocale,
      currentLocale
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      ref: this.settingsRefs[2],
      className: "settings-page__content-row",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMd,
      color: _designSystem.TextColor.textDefault,
      className: "settings-page__content-item__title"
    }, t('currentLanguage'))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col"
    }, /*#__PURE__*/_react.default.createElement(_dropdown.default, {
      "data-testid": "locale-select",
      id: "select-locale",
      options: localeOptions,
      selectedOption: currentLocale,
      onChange: async newLocale => updateCurrentLocale(newLocale)
    }))));
  }
  renderHideZeroBalanceTokensOptIn() {
    const {
      t
    } = this.context;
    const {
      hideZeroBalanceTokens,
      setHideZeroBalanceTokens
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      ref: this.settingsRefs[5],
      className: "settings-page__content-row",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      justifyContent: _designSystem.JustifyContent.spaceBetween,
      alignItems: _designSystem.AlignItems.center,
      id: "toggle-zero-balance"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMd,
      color: _designSystem.TextColor.textDefault,
      className: "settings-page__content-item__title"
    }, t('hideZeroBalanceTokens'))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col"
    }, /*#__PURE__*/_react.default.createElement(_toggleButton.default, {
      value: hideZeroBalanceTokens,
      onToggle: value => setHideZeroBalanceTokens(!value),
      "data-testid": "toggle-zero-balance-button"
    })));
  }
  renderBlockieOptIn() {
    const {
      t
    } = this.context;
    const {
      useBlockie,
      avatarType,
      setAvatarType,
      selectedAddress
    } = this.props;
    let currentAvatarType;
    if (avatarType !== undefined) {
      currentAvatarType = avatarType;
    } else if (useBlockie) {
      currentAvatarType = 'blockies';
    }
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      ref: this.settingsRefs[4],
      className: "settings-page__content-row",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      id: "blockie-optin"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMd,
      color: _designSystem.TextColor.textDefault,
      className: "settings-page__content-item__title"
    }, t('accountIdenticon')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMd,
      color: _designSystem.TextColor.textAlternative,
      marginBottom: 3,
      className: "settings-page__content-item__description"
    }, t('accountIdenticonDescription')), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item__identicon gap-8"
    }, /*#__PURE__*/_react.default.createElement("button", {
      "data-testid": "maskicon_icon",
      onClick: () => setAvatarType('maskicon'),
      className: "flex items-center gap-2 justify-center flex-wrap"
    }, /*#__PURE__*/_react.default.createElement(_designSystemReact.AvatarAccount, {
      address: selectedAddress,
      variant: _designSystemReact.AvatarAccountVariant.Maskicon,
      className: (0, _classnames.default)({
        'outline outline-2 outline-primary-default': currentAvatarType === 'maskicon'
      })
    }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      color: _designSystem.TextColor.textDefault,
      variant: _designSystem.TextVariant.bodySm,
      as: "h6"
    }, t('maskicons'))), /*#__PURE__*/_react.default.createElement("button", {
      "data-testid": "jazz_icon",
      onClick: () => setAvatarType('jazzicon'),
      className: "flex items-center gap-2 justify-center flex-wrap"
    }, /*#__PURE__*/_react.default.createElement(_designSystemReact.AvatarAccount, {
      id: "jazzicon",
      address: selectedAddress,
      variant: _designSystemReact.AvatarAccountVariant.Jazzicon,
      className: (0, _classnames.default)({
        'outline outline-2 outline-primary-default': currentAvatarType === 'jazzicon'
      })
    }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      color: _designSystem.TextColor.textDefault,
      variant: _designSystem.TextVariant.bodySm,
      as: "h6"
    }, t('jazzicons'))), /*#__PURE__*/_react.default.createElement("button", {
      "data-testid": "blockie_icon",
      onClick: () => setAvatarType('blockies'),
      className: "flex items-center gap-2 justify-center flex-wrap"
    }, /*#__PURE__*/_react.default.createElement(_designSystemReact.AvatarAccount, {
      id: "blockies",
      address: selectedAddress,
      variant: _designSystemReact.AvatarAccountVariant.Blockies,
      className: (0, _classnames.default)({
        'outline outline-2 outline-primary-default': currentAvatarType === 'blockies'
      })
    }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      color: _designSystem.TextColor.textDefault,
      variant: _designSystem.TextVariant.bodySm,
      as: "h6"
    }, t('blockies'))))));
  }
  renderShowNativeTokenAsMainBalance() {
    const {
      t
    } = this.context;
    const geShowNativeTokenAsMainBalanceForMetrics = value => {
      this.context.trackEvent({
        category: _metametrics.MetaMetricsEventCategory.Settings,
        event: _metametrics.MetaMetricsEventName.ShowNativeTokenAsMainBalance,
        properties: {
          show_native_token_as_main_balance: value
        }
      });
    };
    const {
      setShowNativeTokenAsMainBalancePreference,
      showNativeTokenAsMainBalance
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      ref: this.settingsRefs[1],
      className: "settings-page__content-row",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      justifyContent: _designSystem.JustifyContent.spaceBetween,
      alignItems: _designSystem.AlignItems.center,
      id: "toggle-show-native-token-as-main-balance"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMd,
      color: _designSystem.TextColor.textDefault,
      className: "settings-page__content-item__title"
    }, t('showNativeTokenAsMainBalance'))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col"
    }, /*#__PURE__*/_react.default.createElement(_toggleButton.default, {
      className: "show-native-token-as-main-balance",
      value: showNativeTokenAsMainBalance,
      onToggle: value => {
        setShowNativeTokenAsMainBalancePreference(!value);
        geShowNativeTokenAsMainBalanceForMetrics(!value);
      }
    })));
  }
  renderTheme() {
    const {
      t
    } = this.context;
    const {
      theme,
      setTheme
    } = this.props;
    const themesOptions = [{
      name: t('lightTheme'),
      value: _preferences.ThemeType.light
    }, {
      name: t('darkTheme'),
      value: _preferences.ThemeType.dark
    }, {
      name: t('osTheme'),
      value: _preferences.ThemeType.os
    }];
    const onChange = newTheme => {
      this.context.trackEvent({
        category: _metametrics.MetaMetricsEventCategory.Settings,
        event: 'Theme Changed',
        properties: {
          theme_selected: newTheme
        }
      });
      setTheme(newTheme);
    };
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      ref: this.settingsRefs[3],
      className: "settings-page__content-row",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMd,
      color: _designSystem.TextColor.textDefault,
      className: "settings-page__content-item__title"
    }, this.context.t('theme')), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-description"
    }, this.context.t('themeDescription'))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content-item-col"
    }, /*#__PURE__*/_react.default.createElement(_dropdown.default, {
      id: "select-theme",
      options: themesOptions,
      selectedOption: theme,
      onChange: onChange
    }))));
  }
  render() {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__body"
    }, this.renderCurrentConversion(), this.renderShowNativeTokenAsMainBalance(), this.renderCurrentLocale(), this.renderTheme(), this.renderBlockieOptIn(), this.renderHideZeroBalanceTokensOptIn());
  }
}
exports.default = SettingsTab;
_defineProperty(SettingsTab, "contextTypes", {
  t: _propTypes.default.func,
  metricsEvent: _propTypes.default.func,
  trackEvent: _propTypes.default.func
});
_defineProperty(SettingsTab, "propTypes", {
  avatarType: _propTypes.default.string,
  setAvatarType: _propTypes.default.func,
  setCurrentCurrency: _propTypes.default.func,
  updateCurrentLocale: _propTypes.default.func,
  currentLocale: _propTypes.default.string,
  useBlockie: _propTypes.default.bool,
  currentCurrency: _propTypes.default.string,
  showNativeTokenAsMainBalance: _propTypes.default.bool,
  setShowNativeTokenAsMainBalancePreference: _propTypes.default.func,
  hideZeroBalanceTokens: _propTypes.default.bool,
  setHideZeroBalanceTokens: _propTypes.default.func,
  selectedAddress: _propTypes.default.string,
  theme: _propTypes.default.string,
  setTheme: _propTypes.default.func
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\settings-tab\\settings-tab.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\settings-tab\\settings-tab.container.js", {"../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./settings-tab.component":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\settings-tab\\settings-tab.component.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Csettings-tab%5Csettings-tab.container.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactRedux = require("react-redux");
var _actions = require("../../../store/actions");
var _selectors = require("../../../selectors");
var _networks = require("../../../../shared/modules/selectors/networks");
var _settingsTab = _interopRequireDefault(require("./settings-tab.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const mapStateToProps = state => {
  const {
    metamask
  } = state;
  const {
    currentCurrency,
    useBlockie,
    currentLocale
  } = metamask;
  const {
    ticker: nativeCurrency
  } = (0, _networks.getProviderConfig)(state);
  const {
    address: selectedAddress
  } = (0, _selectors.getSelectedInternalAccount)(state);
  const {
    hideZeroBalanceTokens,
    showNativeTokenAsMainBalance,
    avatarType
  } = (0, _selectors.getPreferences)(state);
  const tokenList = (0, _selectors.getTokenList)(state);
  return {
    currentLocale,
    currentCurrency,
    nativeCurrency,
    useBlockie,
    avatarType,
    showNativeTokenAsMainBalance,
    hideZeroBalanceTokens,
    selectedAddress,
    tokenList,
    theme: (0, _selectors.getTheme)(state)
  };
};
const mapDispatchToProps = dispatch => {
  return {
    setCurrentCurrency: currency => dispatch((0, _actions.setCurrentCurrency)(currency)),
    setAvatarType: value => dispatch((0, _actions.setAvatarType)(value)),
    updateCurrentLocale: key => dispatch((0, _actions.updateCurrentLocale)(key)),
    setShowNativeTokenAsMainBalancePreference: value => {
      return dispatch((0, _actions.setShowNativeTokenAsMainBalancePreference)(value));
    },
    setParticipateInMetaMetrics: val => dispatch((0, _actions.setParticipateInMetaMetrics)(val)),
    setHideZeroBalanceTokens: value => dispatch((0, _actions.setHideZeroBalanceTokens)(value)),
    setTheme: val => dispatch((0, _actions.setTheme)(val))
  };
};
var _default = exports.default = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_settingsTab.default);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\settings-tab\\settings-tab.container.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\settings.component.js", {"../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../components/app/password-outdated-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\password-outdated-modal\\index.ts","../../components/app/snaps/snap-icon":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-icon\\index.ts","../../components/app/snaps/snap-settings-page":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-settings-page\\index.ts","../../components/app/tab-bar":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\tab-bar\\index.js","../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../components/ui/metafox-logo":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\metafox-logo\\index.js","../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../helpers/utils/settings-search":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\settings-search.js","./advanced-tab":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\advanced-tab\\index.js","./backup-and-sync-tab":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\backup-and-sync-tab\\index.ts","./contact-list-tab":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\contact-list-tab\\index.js","./developer-options-tab":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\developer-options-tab\\index.tsx","./experimental-tab":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\experimental-tab\\index.js","./info-tab":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\info-tab\\index.js","./security-tab":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\security-tab\\index.js","./security-tab/change-password":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\security-tab\\change-password\\index.ts","./security-tab/reveal-srp-list":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\security-tab\\reveal-srp-list\\index.ts","./settings-search":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\settings-search\\index.js","./settings-search-list":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\settings-search-list\\index.js","./settings-tab":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\settings-tab\\index.js","./transaction-shield-tab":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\transaction-shield-tab\\index.ts","./transaction-shield-tab/submit-claim-form":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\transaction-shield-tab\\submit-claim-form\\index.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Csettings.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _classnames = _interopRequireDefault(require("classnames"));
var _tabBar = _interopRequireDefault(require("../../components/app/tab-bar"));
var _routes = require("../../helpers/constants/routes");
var _settingsSearch = require("../../helpers/utils/settings-search");
var _componentLibrary = require("../../components/component-library");
var _designSystem = require("../../helpers/constants/design-system");
var _metafoxLogo = _interopRequireDefault(require("../../components/ui/metafox-logo"));
var _util = require("../../../app/scripts/lib/util");
var _app = require("../../../shared/constants/app");
var _snapIcon = require("../../components/app/snaps/snap-icon");
var _snapSettingsPage = require("../../components/app/snaps/snap-settings-page");
var _passwordOutdatedModal = _interopRequireDefault(require("../../components/app/password-outdated-modal"));
var _settingsTab = _interopRequireDefault(require("./settings-tab"));
var _advancedTab = _interopRequireDefault(require("./advanced-tab"));
var _infoTab = _interopRequireDefault(require("./info-tab"));
var _securityTab = _interopRequireDefault(require("./security-tab"));
var _contactListTab = _interopRequireDefault(require("./contact-list-tab"));
var _developerOptionsTab = _interopRequireDefault(require("./developer-options-tab"));
var _experimentalTab = _interopRequireDefault(require("./experimental-tab"));
var _settingsSearch2 = _interopRequireDefault(require("./settings-search"));
var _settingsSearchList = _interopRequireDefault(require("./settings-search-list"));
var _revealSrpList = require("./security-tab/reveal-srp-list");
var _backupAndSyncTab = _interopRequireDefault(require("./backup-and-sync-tab"));
var _changePassword = _interopRequireDefault(require("./security-tab/change-password"));
var _transactionShieldTab = _interopRequireDefault(require("./transaction-shield-tab"));
var _submitClaimForm = _interopRequireDefault(require("./transaction-shield-tab/submit-claim-form"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } // TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths
// Helper component for network routes that need side effects
const NetworkRouteHandler = ({
  onMount
}) => {
  _react.default.useEffect(() => {
    onMount();
  }, [onMount]);
  return /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Navigate, {
    to: {
      pathname: _routes.DEFAULT_ROUTE
    }
  });
};
NetworkRouteHandler.propTypes = {
  onMount: _propTypes.default.func.isRequired
};
class SettingsPage extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "state", {
      isSearchList: false,
      lastFetchedConversionDate: null,
      searchResults: [],
      searchText: ''
    });
  }
  componentDidMount() {
    this.handleConversionDate();
  }
  componentDidUpdate() {
    this.handleConversionDate();
  }
  handleConversionDate() {
    const {
      conversionDate
    } = this.props;
    if (conversionDate !== null) {
      this.setState({
        lastFetchedConversionDate: conversionDate
      });
    }
  }
  handleClickSetting(setting) {
    const {
      navigate
    } = this.props;
    navigate(setting.route);
    this.setState({
      isSearchList: '',
      searchResults: ''
    });
  }
  render() {
    const {
      navigate,
      backRoute,
      currentPath,
      mostRecentOverviewPage,
      addNewNetwork,
      isPasswordChangePage,
      isRevealSrpListPage,
      isSeedlessPasswordOutdated,
      isTransactionShieldPage
    } = this.props;
    const {
      t
    } = this.context;
    const isPopup = (0, _util.getEnvironmentType)() === _app.ENVIRONMENT_TYPE_POPUP;
    const isSearchHidden = isRevealSrpListPage || isPasswordChangePage || isTransactionShieldPage;
    return /*#__PURE__*/_react.default.createElement("div", {
      className: (0, _classnames.default)('main-container main-container--has-shadow settings-page', {
        'settings-page--selected': currentPath !== _routes.SETTINGS_ROUTE
      })
    }, isSeedlessPasswordOutdated && /*#__PURE__*/_react.default.createElement(_passwordOutdatedModal.default, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      className: "settings-page__header",
      padding: 4,
      paddingBottom: [2, 4]
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: (0, _classnames.default)('settings-page__header__title-container', {
        'settings-page__header__title-container--hide-search': isSearchHidden
      })
    }, isPopup && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, currentPath === _routes.SETTINGS_ROUTE ? /*#__PURE__*/_react.default.createElement(_metafoxLogo.default, {
      className: "settings-page__header__title-container__metamask-logo",
      unsetIconHeight: true,
      onClick: () => navigate(_routes.DEFAULT_ROUTE),
      display: [_designSystem.Display.Flex, _designSystem.Display.None]
    }) : /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      ariaLabel: t('back'),
      iconName: _componentLibrary.IconName.ArrowLeft,
      className: "settings-page__header__title-container__back-button",
      color: _designSystem.Color.iconDefault,
      onClick: () => navigate(backRoute),
      display: [_designSystem.Display.Flex, _designSystem.Display.None],
      size: _componentLibrary.ButtonIconSize.Md
    })), this.renderTitle(), this.renderSearch(), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      className: "settings-page__header__title-container__close-button",
      iconName: _componentLibrary.IconName.Close,
      ariaLabel: t('close'),
      onClick: () => {
        if (addNewNetwork) {
          navigate(_routes.NETWORKS_ROUTE);
        } else {
          navigate(mostRecentOverviewPage);
        }
      },
      size: _componentLibrary.ButtonIconSize.Md,
      marginLeft: "auto"
    }))), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content__tabs"
    }, this.renderTabs()), /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__content__modules"
    }, this.renderSubHeader(), this.renderContent())));
  }
  renderTitle() {
    const {
      t
    } = this.context;
    const {
      isPopup,
      pathnameI18nKey,
      addressName,
      snapSettingsTitle
    } = this.props;
    let titleText;
    if (isPopup && addressName) {
      titleText = t('details');
    } else if (pathnameI18nKey && isPopup) {
      titleText = t(pathnameI18nKey);
    } else if (snapSettingsTitle) {
      titleText = snapSettingsTitle;
    } else {
      titleText = t('settings');
    }
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__header__title-container__title"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.headingMd,
      ellipsis: true
    }, titleText));
  }
  renderSearch() {
    const {
      isSearchList,
      searchText,
      searchResults
    } = this.state;
    const {
      isRevealSrpListPage,
      isPasswordChangePage,
      isTransactionShieldPage
    } = this.props;
    if (isRevealSrpListPage || isPasswordChangePage || isTransactionShieldPage) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      className: "settings-page__header__title-container__search",
      display: [_designSystem.Display.Block]
    }, /*#__PURE__*/_react.default.createElement(_settingsSearch2.default, {
      onSearch: ({
        searchQuery = '',
        results = []
      }) => {
        this.setState({
          isSearchList: searchQuery !== '',
          searchResults: results,
          searchText: searchQuery
        });
      },
      settingsRoutesList: (0, _settingsSearch.getSettingsRoutes)()
    }), isSearchList && searchText.length >= 3 && /*#__PURE__*/_react.default.createElement(_settingsSearchList.default, {
      results: searchResults,
      onClickSetting: setting => this.handleClickSetting(setting)
    }));
  }
  renderSubHeader() {
    const {
      t
    } = this.context;
    const {
      currentPath,
      isPopup,
      isAddressEntryPage,
      pathnameI18nKey,
      addressName,
      initialBreadCrumbRoute,
      breadCrumbTextKey,
      navigate,
      initialBreadCrumbKey
    } = this.props;
    let subheaderText;
    if (isPopup && isAddressEntryPage) {
      subheaderText = t('settings');
    } else if (isAddressEntryPage) {
      subheaderText = t('contacts');
    } else if (initialBreadCrumbKey) {
      subheaderText = t(initialBreadCrumbKey);
    } else {
      subheaderText = t(pathnameI18nKey || 'general');
    }
    return !currentPath.startsWith(_routes.NETWORKS_ROUTE) && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      className: "settings-page__subheader",
      padding: 4,
      paddingLeft: 6,
      paddingRight: 6,
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      alignItems: _designSystem.AlignItems.center
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      className: (0, _classnames.default)({
        'settings-page__subheader--link': initialBreadCrumbRoute
      }),
      variant: _designSystem.TextVariant.headingSm,
      onClick: () => initialBreadCrumbRoute && navigate(initialBreadCrumbRoute)
    }, subheaderText), breadCrumbTextKey && /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__subheader--break"
    }, /*#__PURE__*/_react.default.createElement("span", null, ' > '), t(breadCrumbTextKey)), isAddressEntryPage && /*#__PURE__*/_react.default.createElement("div", {
      className: "settings-page__subheader--break"
    }, /*#__PURE__*/_react.default.createElement("span", null, ' > '), addressName));
  }
  renderTabs() {
    const {
      navigate,
      currentPath,
      useExternalServices,
      settingsPageSnaps,
      isMetaMaskShieldFeatureEnabled
    } = this.props;
    const {
      t
    } = this.context;
    const snapsSettings = settingsPageSnaps.map(({
      id,
      name
    }) => {
      return {
        content: name,
        icon: /*#__PURE__*/_react.default.createElement(_snapIcon.SnapIcon, {
          snapId: id,
          avatarSize: _componentLibrary.IconSize.Md,
          style: {
            '--size': '20px'
          }
        }),
        key: `${_routes.SNAP_SETTINGS_ROUTE}/${encodeURIComponent(id)}`
      };
    });
    const tabs = [{
      content: t('general'),
      icon: /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
        name: _componentLibrary.IconName.Setting
      }),
      key: _routes.GENERAL_ROUTE
    }, ...snapsSettings, {
      content: t('advanced'),
      icon: /*#__PURE__*/_react.default.createElement("i", {
        className: "fas fa-sliders-h"
      }),
      key: _routes.ADVANCED_ROUTE
    }, {
      content: t('backupAndSync'),
      icon: /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
        name: _componentLibrary.IconName.SecurityTime
      }),
      key: _routes.BACKUPANDSYNC_ROUTE
    }, {
      content: t('contacts'),
      icon: /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
        name: _componentLibrary.IconName.Book
      }),
      key: _routes.CONTACT_LIST_ROUTE
    }, {
      content: t('securityAndPrivacy'),
      icon: /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
        name: _componentLibrary.IconName.Lock
      }),
      key: _routes.SECURITY_ROUTE
    }, {
      content: t('experimental'),
      icon: /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
        name: _componentLibrary.IconName.Flask
      }),
      key: _routes.EXPERIMENTAL_ROUTE
    }, {
      content: t('about'),
      icon: /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
        name: _componentLibrary.IconName.Info
      }),
      key: _routes.ABOUT_US_ROUTE
    }];
    if (useExternalServices) {
      tabs.splice(4, 0, {
        content: t('notifications'),
        icon: /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
          name: _componentLibrary.IconName.Notification
        }),
        key: _routes.NOTIFICATIONS_SETTINGS_ROUTE
      });
    }
    if (isMetaMaskShieldFeatureEnabled && useExternalServices) {
      tabs.splice(-4, 0, {
        content: t('shieldTx'),
        icon: /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
          name: _componentLibrary.IconName.ShieldLock
        }),
        key: _routes.TRANSACTION_SHIELD_ROUTE
      });
    }
    if (false || false) {
      tabs.splice(-1, 0, {
        content: t('developerOptions'),
        icon: /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
          name: _componentLibrary.IconName.CodeCircle
        }),
        key: _routes.DEVELOPER_OPTIONS_ROUTE
      });
    }
    return /*#__PURE__*/_react.default.createElement(_tabBar.default, {
      tabs: tabs,
      isActive: key => {
        if (key === _routes.GENERAL_ROUTE && currentPath === _routes.SETTINGS_ROUTE) {
          return true;
        }
        if (key === _routes.CONTACT_LIST_ROUTE && currentPath.includes(_routes.CONTACT_LIST_ROUTE)) {
          return true;
        }
        return (0, _reactRouterDomV5Compat.matchPath)(key, currentPath);
      },
      onSelect: key => navigate(key, {
        state: {
          fromPage: currentPath
        }
      })
    });
  }
  renderContent() {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Routes, null, /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
      path: _routes.GENERAL_ROUTE,
      element: /*#__PURE__*/_react.default.createElement(_settingsTab.default, {
        lastFetchedConversionDate: this.state.lastFetchedConversionDate
      })
    }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
      path: _routes.ABOUT_US_ROUTE,
      element: /*#__PURE__*/_react.default.createElement(_infoTab.default, null)
    }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
      path: `${_routes.SNAP_SETTINGS_ROUTE}/:snapId`,
      element: /*#__PURE__*/_react.default.createElement(_snapSettingsPage.SnapSettingsRenderer, null)
    }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
      path: _routes.ADVANCED_ROUTE,
      element: /*#__PURE__*/_react.default.createElement(_advancedTab.default, null)
    }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
      path: _routes.BACKUPANDSYNC_ROUTE,
      element: /*#__PURE__*/_react.default.createElement(_backupAndSyncTab.default, null)
    }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
      path: _routes.ADD_NETWORK_ROUTE,
      element: /*#__PURE__*/_react.default.createElement(NetworkRouteHandler, {
        onMount: () => this.props.toggleNetworkMenu({
          isAddingNewNetwork: true
        })
      })
    }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
      path: _routes.NETWORKS_ROUTE,
      element: /*#__PURE__*/_react.default.createElement(NetworkRouteHandler, {
        onMount: () => this.props.toggleNetworkMenu()
      })
    }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
      path: _routes.ADD_POPULAR_CUSTOM_NETWORK,
      element: /*#__PURE__*/_react.default.createElement(NetworkRouteHandler, {
        onMount: () => this.props.toggleNetworkMenu()
      })
    }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
      path: _routes.SECURITY_ROUTE,
      element: /*#__PURE__*/_react.default.createElement(_securityTab.default, null)
    }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
      path: _routes.TRANSACTION_SHIELD_ROUTE,
      element: /*#__PURE__*/_react.default.createElement(_transactionShieldTab.default, null)
    }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
      exact: true,
      path: _routes.TRANSACTION_SHIELD_CLAIM_ROUTE,
      element: /*#__PURE__*/_react.default.createElement(_submitClaimForm.default, null)
    }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
      path: _routes.EXPERIMENTAL_ROUTE,
      element: /*#__PURE__*/_react.default.createElement(_experimentalTab.default, null)
    }), (false || false) && /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
      path: _routes.DEVELOPER_OPTIONS_ROUTE,
      element: /*#__PURE__*/_react.default.createElement(_developerOptionsTab.default, null)
    }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
      path: _routes.CONTACT_LIST_ROUTE,
      element: /*#__PURE__*/_react.default.createElement(_contactListTab.default, null)
    }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
      path: _routes.CONTACT_ADD_ROUTE,
      element: /*#__PURE__*/_react.default.createElement(_contactListTab.default, null)
    }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
      path: `${_routes.CONTACT_EDIT_ROUTE}/:id`,
      element: /*#__PURE__*/_react.default.createElement(_contactListTab.default, null)
    }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
      path: `${_routes.CONTACT_VIEW_ROUTE}/:id`,
      element: /*#__PURE__*/_react.default.createElement(_contactListTab.default, null)
    }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
      path: _routes.REVEAL_SRP_LIST_ROUTE,
      element: /*#__PURE__*/_react.default.createElement(_revealSrpList.RevealSrpList, null)
    }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
      path: _routes.SECURITY_PASSWORD_CHANGE_ROUTE,
      element: /*#__PURE__*/_react.default.createElement(_changePassword.default, null)
    }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
      path: "*",
      element: /*#__PURE__*/_react.default.createElement(_settingsTab.default, {
        lastFetchedConversionDate: this.state.lastFetchedConversionDate
      })
    }));
  }
}
_defineProperty(SettingsPage, "propTypes", {
  addNewNetwork: _propTypes.default.bool,
  addressName: _propTypes.default.string,
  backRoute: _propTypes.default.string,
  breadCrumbTextKey: _propTypes.default.string,
  conversionDate: _propTypes.default.number,
  currentPath: _propTypes.default.string,
  initialBreadCrumbKey: _propTypes.default.string,
  initialBreadCrumbRoute: _propTypes.default.string,
  isAddressEntryPage: _propTypes.default.bool,
  isMetaMaskShieldFeatureEnabled: _propTypes.default.bool,
  isPasswordChangePage: _propTypes.default.bool,
  isPopup: _propTypes.default.bool,
  isRevealSrpListPage: _propTypes.default.bool,
  isSeedlessPasswordOutdated: _propTypes.default.bool,
  isTransactionShieldPage: _propTypes.default.bool,
  mostRecentOverviewPage: _propTypes.default.string.isRequired,
  navigate: _propTypes.default.func.isRequired,
  pathnameI18nKey: _propTypes.default.string,
  settingsPageSnaps: _propTypes.default.array,
  snapSettingsTitle: _propTypes.default.string,
  toggleNetworkMenu: _propTypes.default.func.isRequired,
  useExternalServices: _propTypes.default.bool
});
_defineProperty(SettingsPage, "contextTypes", {
  t: _propTypes.default.func
});
var _default = exports.default = SettingsPage;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\settings.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\settings.container.js", {"../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../shared/modules/environment":"D:\\code\\v\\metamask-extension\\shared\\modules\\environment.ts","../../../shared/modules/hexstring-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\hexstring-utils.ts","../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../ducks/history/history":"D:\\code\\v\\metamask-extension\\ui\\ducks\\history\\history.js","../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../helpers/higher-order-components/with-router-hooks/with-router-hooks":"D:\\code\\v\\metamask-extension\\ui\\helpers\\higher-order-components\\with-router-hooks\\with-router-hooks.tsx","../../helpers/utils/snaps":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\snaps.ts","../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./settings.component":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\settings.component.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","redux":"D:\\code\\v\\metamask-extension\\node_modules\\redux\\lib\\redux.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Csettings.container.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _redux = require("redux");
var _reactRedux = require("react-redux");
var _withRouterHooks = _interopRequireDefault(require("../../helpers/higher-order-components/with-router-hooks/with-router-hooks"));
var _selectors = require("../../selectors");
var _app = require("../../../shared/constants/app");
var _util = require("../../../app/scripts/lib/util");
var _history = require("../../ducks/history/history");
var _hexstringUtils = require("../../../shared/modules/hexstring-utils");
var _routes = require("../../helpers/constants/routes");
var _networks = require("../../../shared/modules/selectors/networks");
var _actions = require("../../store/actions");
var _util2 = require("../../helpers/utils/util");
var _snaps = require("../../helpers/utils/snaps");
var _metamask = require("../../ducks/metamask/metamask");
var _environment = require("../../../shared/modules/environment");
var _settings = _interopRequireDefault(require("./settings.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

const ROUTES_TO_I18N_KEYS = {
  [_routes.ABOUT_US_ROUTE]: 'about',
  [_routes.ADD_NETWORK_ROUTE]: 'networks',
  [_routes.ADD_POPULAR_CUSTOM_NETWORK]: 'addNetwork',
  [_routes.ADVANCED_ROUTE]: 'advanced',
  [_routes.BACKUPANDSYNC_ROUTE]: 'backupAndSync',
  [_routes.CONTACT_ADD_ROUTE]: 'newContact',
  [_routes.CONTACT_EDIT_ROUTE]: 'editContact',
  [_routes.CONTACT_LIST_ROUTE]: 'contacts',
  [_routes.CONTACT_VIEW_ROUTE]: 'viewContact',
  [_routes.DEVELOPER_OPTIONS_ROUTE]: 'developerOptions',
  [_routes.EXPERIMENTAL_ROUTE]: 'experimental',
  [_routes.GENERAL_ROUTE]: 'general',
  [_routes.NETWORKS_FORM_ROUTE]: 'networks',
  [_routes.NETWORKS_ROUTE]: 'networks',
  [_routes.REVEAL_SRP_LIST_ROUTE]: 'revealSecretRecoveryPhrase',
  [_routes.SECURITY_PASSWORD_CHANGE_ROUTE]: 'securityChangePassword',
  [_routes.SECURITY_ROUTE]: 'securityAndPrivacy',
  [_routes.TRANSACTION_SHIELD_CLAIM_ROUTE]: 'shieldClaim',
  [_routes.TRANSACTION_SHIELD_ROUTE]: 'shieldTx'
};
const mapStateToProps = (state, ownProps) => {
  var _currencyRates$ticker, _pathname$match;
  const {
    location
  } = ownProps;
  const {
    pathname
  } = location;
  const {
    ticker
  } = (0, _networks.getProviderConfig)(state);
  const {
    metamask: {
      currencyRates,
      socialLoginEmail
    }
  } = state;
  const settingsPageSnapsIds = (0, _selectors.getSettingsPageSnapsIds)(state);
  const snapsMetadata = (0, _selectors.getSnapsMetadata)(state);
  const conversionDate = (_currencyRates$ticker = currencyRates[ticker]) === null || _currencyRates$ticker === void 0 ? void 0 : _currencyRates$ticker.conversionDate;
  const pathNameTail = ((_pathname$match = pathname.match(/[^/]+$/u)) === null || _pathname$match === void 0 ? void 0 : _pathname$match[0]) || '';
  const isAddressEntryPage = pathNameTail.includes('0x');
  const isAddContactPage = Boolean(pathname.match(_routes.CONTACT_ADD_ROUTE));
  const isEditContactPage = Boolean(pathname.match(_routes.CONTACT_EDIT_ROUTE));
  const isRevealSrpListPage = Boolean(pathname.match(_routes.REVEAL_SRP_LIST_ROUTE));
  const isPasswordChangePage = Boolean(pathname.match(_routes.SECURITY_PASSWORD_CHANGE_ROUTE));
  const isTransactionShieldPage = Boolean(pathname.startsWith(_routes.TRANSACTION_SHIELD_ROUTE));
  const isNetworksFormPage = Boolean(pathname.match(_routes.NETWORKS_FORM_ROUTE)) || Boolean(pathname.match(_routes.ADD_NETWORK_ROUTE));
  const addNewNetwork = Boolean(pathname.match(_routes.ADD_NETWORK_ROUTE));
  const isAddPopularCustomNetwork = Boolean(pathname.match(_routes.ADD_POPULAR_CUSTOM_NETWORK));
  const isSnapSettingsRoute = Boolean(pathname.match(_routes.SNAP_SETTINGS_ROUTE));
  const isPopup = (0, _util.getEnvironmentType)() === _app.ENVIRONMENT_TYPE_POPUP;
  const socialLoginEnabled = Boolean(socialLoginEmail);
  let pathnameI18nKey = ROUTES_TO_I18N_KEYS[pathname];

  // if pathname is `REVEAL_SRP_LIST_ROUTE` and socialLoginEnabled rename the tab title to "Manage recovery methods"
  if (isRevealSrpListPage && socialLoginEnabled) {
    pathnameI18nKey = 'securitySrpWalletRecovery';
  }
  let backRoute = _routes.SETTINGS_ROUTE;
  if (isEditContactPage) {
    backRoute = `${_routes.CONTACT_VIEW_ROUTE}/${pathNameTail}`;
  } else if (isAddressEntryPage || isAddContactPage) {
    backRoute = _routes.CONTACT_LIST_ROUTE;
  } else if (isNetworksFormPage) {
    backRoute = _routes.NETWORKS_ROUTE;
  } else if (isAddPopularCustomNetwork) {
    backRoute = _routes.NETWORKS_ROUTE;
  } else if (isRevealSrpListPage || isPasswordChangePage) {
    backRoute = _routes.SECURITY_ROUTE;
  }
  let initialBreadCrumbRoute;
  let initialBreadCrumbKey;
  const addressName = (0, _selectors.getAddressBookEntryOrAccountName)(state, !(0, _hexstringUtils.isBurnAddress)(pathNameTail) && (0, _hexstringUtils.isValidHexAddress)(pathNameTail, {
    mixedCaseUseChecksum: true
  }) ? pathNameTail : '');
  const useExternalServices = (0, _selectors.getUseExternalServices)(state);
  const snapNameGetter = (0, _util2.getSnapName)(snapsMetadata);
  const settingsPageSnaps = settingsPageSnapsIds.map(snapId => ({
    id: snapId,
    name: snapNameGetter(snapId)
  }));
  const snapSettingsTitle = isSnapSettingsRoute && snapNameGetter((0, _snaps.decodeSnapIdFromPathname)(pathname));
  return {
    addNewNetwork,
    addressName,
    backRoute,
    conversionDate,
    currentPath: pathname,
    initialBreadCrumbKey,
    initialBreadCrumbRoute,
    isAddressEntryPage,
    isMetaMaskShieldFeatureEnabled: (0, _environment.getIsMetaMaskShieldFeatureEnabled)(),
    isPasswordChangePage,
    isPopup,
    isRevealSrpListPage,
    isSeedlessPasswordOutdated: (0, _metamask.getIsSeedlessPasswordOutdated)(state),
    isTransactionShieldPage,
    mostRecentOverviewPage: (0, _history.getMostRecentOverviewPage)(state),
    pathnameI18nKey,
    settingsPageSnaps,
    snapSettingsTitle,
    useExternalServices
  };
};
function mapDispatchToProps(dispatch) {
  return {
    toggleNetworkMenu: payload => dispatch((0, _actions.toggleNetworkMenu)(payload))
  };
}
var _default = exports.default = (0, _redux.compose)(_withRouterHooks.default, (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps))(_settings.default);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\settings.container.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\transaction-shield-tab\\cancel-membership-modal.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../asset/util":"D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\util.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Ctransaction-shield-tab%5Ccancel-membership-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = CancelMembershipModal;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _util = require("../../asset/util");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function CancelMembershipModal({
  onConfirm,
  onClose,
  subscription
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: true,
    onClose: onClose,
    className: "cancel-membership-modal",
    "data-testid": "cancel-membership-modal"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, {
    alignItems: _designSystem.AlignItems.flexStart
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onClose: onClose
  }, t('areYouSure')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd
  }, t('shieldTxCancelDetails', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    key: "cancel-date",
    variant: _designSystem.TextVariant.bodyMdMedium,
    as: "span"
  }, (0, _util.getShortDateFormatterV2)().format(new Date(subscription.currentPeriodEnd)))]))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalFooter, {
    onSubmit: onConfirm,
    submitButtonProps: {
      'data-testid': 'cancel-membership-modal-submit-button',
      children: t('shieldTxMembershipCancel'),
      danger: true
    }
  })));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\transaction-shield-tab\\cancel-membership-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\transaction-shield-tab\\index.ts", {"./transaction-shield":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\transaction-shield-tab\\transaction-shield.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Ctransaction-shield-tab%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _transactionShield.default;
  }
});
var _transactionShield = _interopRequireDefault(require("./transaction-shield"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\transaction-shield-tab\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\transaction-shield-tab\\submit-claim-form\\index.ts", {"./submit-claim-form":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\transaction-shield-tab\\submit-claim-form\\submit-claim-form.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Ctransaction-shield-tab%5Csubmit-claim-form%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _submitClaimForm.default;
  }
});
var _submitClaimForm = _interopRequireDefault(require("./submit-claim-form"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\transaction-shield-tab\\submit-claim-form\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\transaction-shield-tab\\submit-claim-form\\submit-claim-form.tsx", {"../../../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../../../../shared/constants/app-state":"D:\\code\\v\\metamask-extension\\shared\\constants\\app-state.ts","../../../../components/app/toast-master/utils":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\toast-master\\utils.ts","../../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../components/component-library/file-uploader":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\file-uploader\\index.ts","../../../../components/component-library/textarea":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\textarea\\index.ts","../../../../components/ui/loading-screen":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\loading-screen\\index.js","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../../hooks/claims/useClaimState":"D:\\code\\v\\metamask-extension\\ui\\hooks\\claims\\useClaimState.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Ctransaction-shield-tab%5Csubmit-claim-form%5Csubmit-claim-form.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _controllerUtils = require("@metamask/controller-utils");
var _utils = require("@metamask/utils");
var _designSystemReact = require("@metamask/design-system-react");
var _reactRedux = require("react-redux");
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _textarea = require("../../../../components/component-library/textarea");
var _componentLibrary = require("../../../../components/component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _useClaimState = require("../../../../hooks/claims/useClaimState");
var _util = require("../../../../../app/scripts/lib/util");
var _actions = require("../../../../store/actions");
var _loadingScreen = _interopRequireDefault(require("../../../../components/ui/loading-screen"));
var _utils2 = require("../../../../components/app/toast-master/utils");
var _appState = require("../../../../../shared/constants/app-state");
var _routes = require("../../../../helpers/constants/routes");
var _fileUploader = require("../../../../components/component-library/file-uploader");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

const MAX_FILE_SIZE = 5 * 1024 * 1024;
function isValidTransactionHash(hash) {
  // Check if it's exactly 66 characters (0x + 64 hex chars)
  return hash.length === 66 && (0, _utils.isStrictHexString)(hash);
}
const SubmitClaimForm = () => {
  var _errors$impactedTrans;
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const navigate = (0, _reactRouterDomV5Compat.useNavigate)();
  const [claimSubmitLoading, setClaimSubmitLoading] = (0, _react.useState)(false);
  const {
    email,
    setEmail,
    impactedWalletAddress,
    setImpactedWalletAddress,
    impactedTransactionHash,
    setImpactedTransactionHash,
    reimbursementWalletAddress,
    setReimbursementWalletAddress,
    caseDescription,
    setCaseDescription,
    files,
    setFiles
  } = (0, _useClaimState.useClaimState)();
  const [errors, setErrors] = (0, _react.useState)({});
  const validateEmail = (0, _react.useCallback)(() => {
    if (email) {
      const isEmailValid = (0, _util.isValidEmail)(email);
      setErrors(state => ({
        ...state,
        email: isEmailValid ? undefined : {
          key: 'email',
          msg: t('shieldClaimInvalidEmail')
        }
      }));
    } else {
      setErrors(state => ({
        ...state,
        email: {
          key: 'email',
          msg: t('shieldClaimInvalidRequired')
        }
      }));
    }
  }, [t, email]);
  const validateImpactedWalletAddress = (0, _react.useCallback)(() => {
    if (impactedWalletAddress) {
      const isImpactedWalletAddressValid = (0, _controllerUtils.isValidHexAddress)(impactedWalletAddress);
      setErrors(state => ({
        ...state,
        impactedWalletAddress: isImpactedWalletAddressValid ? undefined : {
          key: 'impactedWalletAddress',
          msg: t('shieldClaimInvalidWalletAddress')
        }
      }));
    } else {
      setErrors(state => ({
        ...state,
        impactedWalletAddress: {
          key: 'impactedWalletAddress',
          msg: t('shieldClaimInvalidRequired')
        }
      }));
    }
  }, [impactedWalletAddress, t]);
  const validateReimbursementWalletAddress = (0, _react.useCallback)(() => {
    if (reimbursementWalletAddress) {
      const isReimbursementWalletAddressValid = (0, _controllerUtils.isValidHexAddress)(reimbursementWalletAddress);
      setErrors(state => ({
        ...state,
        reimbursementWalletAddress: isReimbursementWalletAddressValid ? undefined : {
          key: 'reimbursementWalletAddress',
          msg: t('shieldClaimInvalidWalletAddress')
        }
      }));
    } else {
      setErrors(state => ({
        ...state,
        reimbursementWalletAddress: {
          key: 'reimbursementWalletAddress',
          msg: t('shieldClaimInvalidRequired')
        }
      }));
    }
  }, [reimbursementWalletAddress, t]);
  const isInvalidData = (0, _react.useMemo)(() => {
    return Object.values(errors).some(error => error !== undefined) || !email || !impactedWalletAddress || !impactedTransactionHash || !reimbursementWalletAddress || !caseDescription;
  }, [errors, email, impactedWalletAddress, impactedTransactionHash, reimbursementWalletAddress, caseDescription]);
  const validateImpactedTxHash = (0, _react.useCallback)(() => {
    if (impactedTransactionHash) {
      const isImpactedTxHashValid = isValidTransactionHash(impactedTransactionHash);
      setErrors(state => ({
        ...state,
        impactedTransactionHash: isImpactedTxHashValid ? undefined : {
          key: 'impactedTransactionHash',
          msg: t('shieldClaimInvalidTxHash')
        }
      }));
    } else {
      setErrors(state => ({
        ...state,
        impactedTransactionHash: {
          key: 'impactedTransactionHash',
          msg: t('shieldClaimInvalidRequired')
        }
      }));
    }
  }, [impactedTransactionHash, t]);
  const validateDescription = (0, _react.useCallback)(() => {
    setErrors(state => ({
      ...state,
      caseDescription: caseDescription ? undefined : {
        key: 'caseDescription',
        msg: t('shieldClaimInvalidRequired')
      }
    }));
  }, [caseDescription, t]);
  const handleSubmitClaim = (0, _react.useCallback)(async () => {
    try {
      setClaimSubmitLoading(true);
      await (0, _actions.submitShieldClaim)({
        email,
        impactedWalletAddress,
        impactedTransactionHash,
        reimbursementWalletAddress,
        caseDescription,
        files
      });
      dispatch((0, _utils2.setShowClaimSubmitToast)(_appState.ClaimSubmitToastType.Success));
      navigate(_routes.TRANSACTION_SHIELD_ROUTE);
    } catch (error) {
      const {
        message
      } = error;
      dispatch((0, _utils2.setShowClaimSubmitToast)(message === _appState.ClaimSubmitToastType.Errored ? _appState.ClaimSubmitToastType.Errored : message));
    } finally {
      setClaimSubmitLoading(false);
    }
  }, [dispatch, email, impactedTransactionHash, impactedWalletAddress, reimbursementWalletAddress, caseDescription, files, navigate]);
  return /*#__PURE__*/_react.default.createElement(_designSystemReact.Box, {
    className: "submit-claim-page flex flex-col",
    "data-testid": "submit-claim-page",
    padding: 4,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_designSystemReact.Text, {
    variant: _designSystemReact.TextVariant.BodyMd,
    fontWeight: _designSystemReact.FontWeight.Medium
  }, t('shieldClaimDetails', [/*#__PURE__*/_react.default.createElement(_designSystemReact.TextButton, {
    key: "here-link",
    className: "min-w-0",
    asChild: true
  }, /*#__PURE__*/_react.default.createElement("a", {
    href: "#"
  }, t('here')))])), /*#__PURE__*/_react.default.createElement(_componentLibrary.FormTextField, {
    label: `${t('shieldClaimEmail')}*`,
    placeholder: "johncarpenter@sample.com",
    inputProps: {
      'data-testid': 'shield-claim-email-input'
    },
    helpText: errors.email ? errors.email.msg : t('shieldClaimEmailHelpText'),
    helpTextProps: {
      'data-testid': 'shield-claim-help-text',
      color: _designSystem.TextColor.textAlternative
    },
    id: "email",
    name: "email",
    size: _componentLibrary.FormTextFieldSize.Lg,
    onChange: e => setEmail(e.target.value),
    onBlur: () => validateEmail(),
    value: email,
    error: Boolean(errors.email),
    required: true,
    width: _designSystem.BlockSize.Full
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.FormTextField, {
    label: `${t('shieldClaimImpactedWalletAddress')}*`,
    placeholder: 'e.g. 0x71C...B5f6d',
    inputProps: {
      'data-testid': 'shield-claim-impacted-wallet-address-input'
    },
    helpTextProps: {
      'data-testid': 'shield-claim-impacted-wallet-address-help-text',
      color: _designSystem.TextColor.textAlternative
    },
    helpText: errors.impactedWalletAddress ? errors.impactedWalletAddress.msg : undefined,
    id: "impacted-wallet-address",
    name: "impacted-wallet-address",
    size: _componentLibrary.FormTextFieldSize.Lg,
    onChange: e => setImpactedWalletAddress(e.target.value),
    onBlur: () => validateImpactedWalletAddress(),
    value: impactedWalletAddress,
    error: Boolean(errors.impactedWalletAddress),
    required: true,
    width: _designSystem.BlockSize.Full
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.FormTextField, {
    label: `${t('shieldClaimImpactedTxHash')}*`,
    placeholder: 'e.g. a1084235686add...q46q8wurgw',
    helpText: errors.impactedTransactionHash ? (_errors$impactedTrans = errors.impactedTransactionHash) === null || _errors$impactedTrans === void 0 ? void 0 : _errors$impactedTrans.msg : /*#__PURE__*/_react.default.createElement(_designSystemReact.Text, {
      variant: _designSystemReact.TextVariant.BodySm,
      color: _designSystemReact.TextColor.TextAlternative
    }, t('shieldClaimImpactedTxHashHelpText'), ' ', /*#__PURE__*/_react.default.createElement(_designSystemReact.TextButton, {
      size: _designSystemReact.TextButtonSize.BodySm,
      className: "min-w-0",
      asChild: true
    }, /*#__PURE__*/_react.default.createElement("a", {
      href: "#"
    }, t('shieldClaimImpactedTxHashHelpTextLink')))),
    id: "impacted-tx-hash",
    name: "impacted-tx-hash",
    size: _componentLibrary.FormTextFieldSize.Lg,
    onChange: e => setImpactedTransactionHash(e.target.value),
    onBlur: () => validateImpactedTxHash(),
    value: impactedTransactionHash,
    error: Boolean(errors.impactedTransactionHash),
    required: true,
    width: _designSystem.BlockSize.Full
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.FormTextField, {
    label: `${t('shieldClaimReimbursementWalletAddress')}*`,
    placeholder: 'e.g. 0x71C...B5f6d',
    inputProps: {
      'data-testid': 'shield-claim-reimbursement-wallet-address-input'
    },
    helpTextProps: {
      'data-testid': 'shield-claim-reimbursement-wallet-address-help-text',
      color: _designSystem.TextColor.textAlternative
    },
    helpText: errors.reimbursementWalletAddress ? errors.reimbursementWalletAddress.msg : t('shieldClaimReimbursementWalletAddressHelpText'),
    id: "reimbursement-wallet-address",
    name: "reimbursement-wallet-address",
    size: _componentLibrary.FormTextFieldSize.Lg,
    onChange: e => setReimbursementWalletAddress(e.target.value),
    onBlur: () => validateReimbursementWalletAddress(),
    value: reimbursementWalletAddress,
    error: Boolean(errors.reimbursementWalletAddress),
    required: true,
    width: _designSystem.BlockSize.Full
  }), /*#__PURE__*/_react.default.createElement(_designSystemReact.Box, {
    gap: 2
  }, /*#__PURE__*/_react.default.createElement(_designSystemReact.Text, {
    variant: _designSystemReact.TextVariant.BodyMd,
    fontWeight: _designSystemReact.FontWeight.Medium
  }, `${t('shieldClaimDescription')}*`), /*#__PURE__*/_react.default.createElement(_textarea.Textarea, {
    id: "description",
    name: "description",
    onChange: e => setCaseDescription(e.target.value),
    onBlur: () => validateDescription(),
    value: caseDescription,
    error: Boolean(errors.caseDescription),
    width: _designSystem.BlockSize.Full,
    rows: 4,
    resize: _textarea.TextareaResize.Vertical,
    borderRadius: _designSystem.BorderRadius.LG,
    paddingTop: 3,
    paddingBottom: 3,
    maxLength: 2000
  }), errors.caseDescription && /*#__PURE__*/_react.default.createElement(_designSystemReact.Text, {
    variant: _designSystemReact.TextVariant.BodySm,
    color: _designSystemReact.TextColor.ErrorDefault,
    className: "mt-0.5"
  }, errors.caseDescription.msg)), /*#__PURE__*/_react.default.createElement(_fileUploader.FileUploader, {
    id: "upload-images-file-uploader",
    "data-testid": "upload-images-file-uploader",
    label: t('shieldClaimFileUploader'),
    onChange: inputFiles => setFiles(inputFiles),
    accept: ['application/pdf', 'image/png', 'image/jpeg'].join(','),
    acceptText: t('shieldClaimFileUploaderAcceptText'),
    helpText: t('shieldClaimFileUploaderHelpText'),
    maxFileSize: MAX_FILE_SIZE
  }), /*#__PURE__*/_react.default.createElement(_designSystemReact.Box, {
    className: "settings-page__content-item-col"
  }, /*#__PURE__*/_react.default.createElement(_designSystemReact.Button, {
    "data-testid": "shield-claim-submit-button",
    variant: _designSystemReact.ButtonVariant.Primary,
    size: _designSystemReact.ButtonSize.Lg,
    disabled: isInvalidData,
    onClick: handleSubmitClaim
  }, t('shieldClaimSubmit'))), claimSubmitLoading && /*#__PURE__*/_react.default.createElement(_loadingScreen.default, null));
};
var _default = exports.default = SubmitClaimForm;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\transaction-shield-tab\\submit-claim-form\\submit-claim-form.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\transaction-shield-tab\\transaction-shield.tsx", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/preferences":"D:\\code\\v\\metamask-extension\\shared\\constants\\preferences.ts","../../../../shared/lib/shield":"D:\\code\\v\\metamask-extension\\shared\\lib\\shield.ts","../../../components/app/confirm/info/row":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\index.ts","../../../components/app/modals/add-funds-modal/add-funds-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\add-funds-modal\\add-funds-modal.tsx","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/component-library/skeleton":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\skeleton\\index.ts","../../../components/ui/loading-screen":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\loading-screen\\index.js","../../../components/ui/tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\index.js","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../hooks/subscription/useSubscription":"D:\\code\\v\\metamask-extension\\ui\\hooks\\subscription\\useSubscription.ts","../../../hooks/subscription/useSubscriptionPricing":"D:\\code\\v\\metamask-extension\\ui\\hooks\\subscription\\useSubscriptionPricing.ts","../../../hooks/useFormatters":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useFormatters.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../asset/util":"D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\util.ts","../../shield-plan/utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\shield-plan\\utils.ts","./cancel-membership-modal":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\transaction-shield-tab\\cancel-membership-modal.tsx","./types":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\transaction-shield-tab\\types.ts","@metamask/subscription-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\subscription-controller\\dist\\index.cjs","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Ctransaction-shield-tab%5Ctransaction-shield.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _subscriptionController = require("@metamask/subscription-controller");
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _reactRedux = require("react-redux");
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _skeleton = require("../../../components/component-library/skeleton");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _useSubscription = require("../../../hooks/subscription/useSubscription");
var _util = require("../../asset/util");
var _routes = require("../../../helpers/constants/routes");
var _utils = require("../../shield-plan/utils");
var _tooltip = _interopRequireDefault(require("../../../components/ui/tooltip"));
var _preferences = require("../../../../shared/constants/preferences");
var _useFormatters = require("../../../hooks/useFormatters");
var _loadingScreen = _interopRequireDefault(require("../../../components/ui/loading-screen"));
var _addFundsModal = _interopRequireDefault(require("../../../components/app/modals/add-funds-modal/add-funds-modal"));
var _useSubscriptionPricing = require("../../../hooks/subscription/useSubscriptionPricing");
var _actions = require("../../../store/actions");
var _metametrics = require("../../../contexts/metametrics");
var _selectors = require("../../../selectors/selectors");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _row = require("../../../components/app/confirm/info/row");
var _shield = require("../../../../shared/lib/shield");
var _cancelMembershipModal = _interopRequireDefault(require("./cancel-membership-modal"));
var _types = require("./types");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const TransactionShield = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  const navigate = (0, _reactRouterDomV5Compat.useNavigate)();
  const {
    formatCurrency
  } = (0, _useFormatters.useFormatters)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const securityAlertsEnabled = (0, _reactRedux.useSelector)(_selectors.getIsSecurityAlertsEnabled);
  const usePhishDetect = (0, _reactRedux.useSelector)(_selectors.getUsePhishDetect);
  const useTransactionSimulations = (0, _reactRedux.useSelector)(_selectors.getUseTransactionSimulations);
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    customerId,
    subscriptions,
    loading: subscriptionsLoading
  } = (0, _useSubscription.useUserSubscriptions)({
    refetch: true // always fetch latest subscriptions state in settings screen
  });
  const shieldSubscription = (0, _useSubscription.useUserSubscriptionByProduct)(_subscriptionController.PRODUCT_TYPES.SHIELD, subscriptions);
  const {
    subscriptionPricing,
    loading: subscriptionPricingLoading
  } = (0, _useSubscriptionPricing.useSubscriptionPricing)({
    refetch: true // need to refetch here in case user already subscribed and doesn't go through shield plan screen
  });
  const cryptoPaymentMethod = (0, _useSubscriptionPricing.useSubscriptionPaymentMethods)(_subscriptionController.PAYMENT_TYPES.byCrypto, subscriptionPricing);
  const isCancelled = (shieldSubscription === null || shieldSubscription === void 0 ? void 0 : shieldSubscription.status) === _subscriptionController.SUBSCRIPTION_STATUSES.canceled;
  const isPaused = (0, _shield.getIsShieldSubscriptionPaused)(subscriptions);
  const isMembershipInactive = isCancelled || isPaused;
  const isSubscriptionEndingSoon = (0, _shield.getIsShieldSubscriptionEndingSoon)(subscriptions);

  // user can cancel subscription if not canceled and not cancel at period end
  const canCancel = !isCancelled && !(shieldSubscription !== null && shieldSubscription !== void 0 && shieldSubscription.cancelAtPeriodEnd);
  const isCryptoPayment = (shieldSubscription === null || shieldSubscription === void 0 ? void 0 : shieldSubscription.paymentMethod) && (0, _types.isCryptoPaymentMethod)(shieldSubscription === null || shieldSubscription === void 0 ? void 0 : shieldSubscription.paymentMethod);
  const productInfo = (0, _react.useMemo)(() => shieldSubscription === null || shieldSubscription === void 0 ? void 0 : shieldSubscription.products.find(p => p.name === _subscriptionController.PRODUCT_TYPES.SHIELD), [shieldSubscription]);
  const [executeCancelSubscription, cancelSubscriptionResult] = (0, _useSubscription.useCancelSubscription)({
    subscriptionId: shieldSubscription === null || shieldSubscription === void 0 ? void 0 : shieldSubscription.id
  });
  const [executeUnCancelSubscription, unCancelSubscriptionResult] = (0, _useSubscription.useUnCancelSubscription)({
    subscriptionId: shieldSubscription === null || shieldSubscription === void 0 ? void 0 : shieldSubscription.id
  });
  const [executeOpenGetSubscriptionBillingPortal, openGetSubscriptionBillingPortalResult] = (0, _useSubscription.useOpenGetSubscriptionBillingPortal)();
  const [executeUpdateSubscriptionCardPaymentMethod, updateSubscriptionCardPaymentMethodResult] = (0, _useSubscription.useUpdateSubscriptionCardPaymentMethod)({
    subscriptionId: shieldSubscription === null || shieldSubscription === void 0 ? void 0 : shieldSubscription.id,
    recurringInterval: shieldSubscription === null || shieldSubscription === void 0 ? void 0 : shieldSubscription.interval
  });
  const loading = cancelSubscriptionResult.pending || unCancelSubscriptionResult.pending || openGetSubscriptionBillingPortalResult.pending || updateSubscriptionCardPaymentMethodResult.pending;
  const showSkeletonLoader = subscriptionsLoading || subscriptionPricingLoading;
  (0, _react.useEffect)(() => {
    if (shieldSubscription) {
      // set security alerts enabled to true
      if (!securityAlertsEnabled) {
        trackEvent({
          category: _metametrics2.MetaMetricsEventCategory.Settings,
          event: _metametrics2.MetaMetricsEventName.SettingsUpdated,
          properties: {
            // eslint-disable-next-line @typescript-eslint/naming-convention
            blockaid_alerts_enabled: true
          }
        });
        (0, _actions.setSecurityAlertsEnabled)(true);
      }

      // set phishing detection to true
      if (!usePhishDetect) {
        dispatch((0, _actions.setUsePhishDetect)(true));
      }

      // set transaction simulations to true
      if (!useTransactionSimulations) {
        (0, _actions.setUseTransactionSimulations)(true);
      }
    } else {
      // redirect to shield plan page if user doesn't have a subscription
      navigate(_routes.SHIELD_PLAN_ROUTE);
    }
  }, [navigate, shieldSubscription, securityAlertsEnabled, usePhishDetect, useTransactionSimulations, dispatch, trackEvent]);
  const [isCancelMembershipModalOpen, setIsCancelMembershipModalOpen] = (0, _react.useState)(false);
  const [isAddFundsModalOpen, setIsAddFundsModalOpen] = (0, _react.useState)(false);
  const shieldDetails = [{
    icon: _componentLibrary.IconName.ShieldLock,
    title: t('shieldTxDetails1Title'),
    description: t('shieldTxDetails1Description')
  }, {
    icon: _componentLibrary.IconName.Flash,
    title: t('shieldTxDetails2Title'),
    description: t('shieldTxDetails2Description')
  }];
  const rowsStyleProps = {
    display: _designSystem.Display.Flex,
    backgroundColor: _designSystem.BackgroundColor.backgroundSection,
    padding: 4
  };
  const currentToken = (0, _react.useMemo)(() => {
    var _cryptoPaymentMethod$;
    if (!shieldSubscription || !(0, _types.isCryptoPaymentMethod)(shieldSubscription.paymentMethod)) {
      return undefined;
    }
    const chainPaymentInfo = cryptoPaymentMethod === null || cryptoPaymentMethod === void 0 || (_cryptoPaymentMethod$ = cryptoPaymentMethod.chains) === null || _cryptoPaymentMethod$ === void 0 ? void 0 : _cryptoPaymentMethod$.find(chain => chain.chainId === shieldSubscription.paymentMethod.crypto.chainId);
    const token = chainPaymentInfo === null || chainPaymentInfo === void 0 ? void 0 : chainPaymentInfo.tokens.find(paymentToken => paymentToken.symbol === shieldSubscription.paymentMethod.crypto.tokenSymbol);
    return token;
  }, [cryptoPaymentMethod, shieldSubscription]);
  const buttonRow = (label, onClick, id) => {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, _extends({
      as: "button",
      "data-testid": id,
      className: "transaction-shield-page__row"
    }, rowsStyleProps, {
      justifyContent: _designSystem.JustifyContent.spaceBetween,
      alignItems: _designSystem.AlignItems.center,
      width: _designSystem.BlockSize.Full,
      onClick: onClick
    }), showSkeletonLoader ? /*#__PURE__*/_react.default.createElement(_skeleton.Skeleton, {
      width: "50%",
      height: 20
    }) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMdMedium
    }, label), showSkeletonLoader ? /*#__PURE__*/_react.default.createElement(_skeleton.Skeleton, {
      width: 24,
      height: 24,
      borderRadius: _designSystem.BorderRadius.full
    }) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
      name: _componentLibrary.IconName.ArrowRight,
      size: _componentLibrary.IconSize.Lg,
      color: _designSystem.IconColor.iconAlternative
    }));
  };
  const billingDetails = (key, value) => {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      alignItems: _designSystem.AlignItems.center,
      gap: 2,
      justifyContent: _designSystem.JustifyContent.spaceBetween
    }, showSkeletonLoader ? /*#__PURE__*/_react.default.createElement(_skeleton.Skeleton, {
      width: "40%",
      height: 24
    }) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMdMedium
    }, key), showSkeletonLoader ? /*#__PURE__*/_react.default.createElement(_skeleton.Skeleton, {
      width: "30%",
      height: 24
    }) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMdMedium
    }, value));
  };
  const isInsufficientFundsCrypto = shieldSubscription && (0, _types.isCryptoPaymentMethod)(shieldSubscription.paymentMethod) && shieldSubscription.paymentMethod.crypto.error === 'insufficient_balance';
  const isAllowanceNeededCrypto = shieldSubscription && (0, _types.isCryptoPaymentMethod)(shieldSubscription.paymentMethod) && (shieldSubscription.paymentMethod.crypto.error === 'insufficient_allowance' || shieldSubscription.paymentMethod.crypto.error === 'approval_transaction_too_old' || shieldSubscription.paymentMethod.crypto.error === 'approval_transaction_reverted' || shieldSubscription.paymentMethod.crypto.error === 'approval_transaction_max_verification_attempts_reached');
  const membershipErrorBanner = (0, _react.useMemo)(() => {
    if (isPaused) {
      return /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerAlert, {
        description: t('shieldTxMembershipErrorPaused'),
        severity: _componentLibrary.BannerAlertSeverity.Danger,
        marginBottom: 4,
        actionButtonLabel: t(isCryptoPayment && isInsufficientFundsCrypto ? 'shieldTxMembershipErrorAddFunds' : 'shieldTxMembershipErrorUpdatePayment'),
        actionButtonOnClick: async () => {
          if (shieldSubscription && (0, _types.isCryptoPaymentMethod)(shieldSubscription.paymentMethod)) {
            if (isInsufficientFundsCrypto) {
              // TODO: handle add funds crypto
              // then use subscription controller to trigger subscription check
              setIsAddFundsModalOpen(true);
              // await dispatch(updateSubscriptionCryptoPaymentMethod({
              //   ...params,
              //   rawTransaction: undefined // no raw transaction to trigger server to check for new funded balance
              // }))
            } else if (isAllowanceNeededCrypto) {
              // TODO: handle add approval transaction crypto
              // then use subscription controller to udpate the subscription with new raw transaction
              console.log('add allowance');
              // await dispatch(updateSubscriptionCryptoPaymentMethod({
              //   ...params,
              //   rawTransaction: newApprovalRawTransaction
              // }))
            } else {
              throw new Error('Unknown crypto error action');
            }
          } else {
            await executeUpdateSubscriptionCardPaymentMethod();
          }
        }
      });
    }
    if (isSubscriptionEndingSoon && shieldSubscription) {
      return /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerAlert, {
        description: t('shieldTxMembershipErrorInsufficientFunds', [(0, _util.getShortDateFormatterV2)().format(new Date(shieldSubscription.currentPeriodEnd))]),
        severity: _componentLibrary.BannerAlertSeverity.Warning,
        marginBottom: 4,
        actionButtonLabel: isAllowanceNeededCrypto ? t('shieldTxMembershipRenew') : t('shieldTxMembershipErrorAddFunds'),
        actionButtonOnClick: () => {
          if ((0, _types.isCryptoPaymentMethod)(shieldSubscription.paymentMethod)) {
            if (isInsufficientFundsCrypto) {
              // TODO: handle add funds crypto
              setIsAddFundsModalOpen(true);
              // await dispatch(updateSubscriptionCryptoPaymentMethod({
              //   ...params,
              //   rawTransaction: undefined // no raw transaction to trigger server to check for new funded balance
              // }))
            } else if (isAllowanceNeededCrypto) {
              // TODO: handle add allowance crypto
              console.log('add allowance');
              // await dispatch(updateSubscriptionCryptoPaymentMethod({
              //   ...params,
              //   rawTransaction: newApprovalRawTransaction
              // }))
            } else {
              throw new Error('Unknown crypto error action');
            }
          } else {
            throw new Error('Only crypto payment method is supported when ending soon');
          }
        }
      });
    }
    return null;
  }, [isPaused, isSubscriptionEndingSoon, shieldSubscription, t, isCryptoPayment, executeUpdateSubscriptionCardPaymentMethod, isInsufficientFundsCrypto, isAllowanceNeededCrypto]);
  const paymentMethod = (0, _react.useMemo)(() => {
    if (!shieldSubscription) {
      return '';
    }
    if (isPaused) {
      return /*#__PURE__*/_react.default.createElement(_tooltip.default, {
        position: "top",
        title: t(isCryptoPayment ? 'shieldTxMembershipErrorPausedCryptoTooltip' : 'shieldTxMembershipErrorPausedCardTooltip')
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
        startIconName: _componentLibrary.IconName.Danger,
        startIconProps: {
          size: _componentLibrary.IconSize.Md
        },
        onClick: async () => {
          if (isCryptoPayment) {
            if (isInsufficientFundsCrypto) {
              // TODO: handle add funds crypto
              setIsAddFundsModalOpen(true);
              // await dispatch(updateSubscriptionCryptoPaymentMethod({
              //   ...params,
              //   rawTransaction: undefined // no raw transaction to trigger server to check for new funded balance
              // }))
            } else if (isAllowanceNeededCrypto) {
              // TODO: handle add allowance crypto
              console.log('add allowance');
              // await dispatch(updateSubscriptionCryptoPaymentMethod({
              //   ...params,
              //   rawTransaction: newApprovalRawTransaction
              // }))
            } else {
              throw new Error('Unknown crypto error action');
            }
          } else {
            await executeUpdateSubscriptionCardPaymentMethod();
          }
        },
        danger: true
      }, t(isCryptoPayment ? 'shieldTxMembershipErrorInsufficientToken' : 'shieldTxMembershipErrorUpdateCard', [(0, _types.isCryptoPaymentMethod)(shieldSubscription === null || shieldSubscription === void 0 ? void 0 : shieldSubscription.paymentMethod) ? shieldSubscription.paymentMethod.crypto.tokenSymbol : ''])));
    }
    if (isSubscriptionEndingSoon && shieldSubscription) {
      return /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
        className: "warning-button",
        startIconName: _componentLibrary.IconName.Danger,
        startIconProps: {
          size: _componentLibrary.IconSize.Md,
          color: _designSystem.IconColor.warningDefault
        },
        color: _designSystem.TextColor.warningDefault,
        onClick: () => {
          if ((0, _types.isCryptoPaymentMethod)(shieldSubscription.paymentMethod)) {
            if (isInsufficientFundsCrypto) {
              // TODO: handle add funds crypto
              setIsAddFundsModalOpen(true);
              // await dispatch(updateSubscriptionCryptoPaymentMethod({
              //   ...params,
              //   rawTransaction: undefined // no raw transaction to trigger server to check for new funded balance
              // }))
            } else if (isAllowanceNeededCrypto) {
              // TODO: handle add allowance crypto
              console.log('add allowance');
              // await dispatch(updateSubscriptionCryptoPaymentMethod({
              //   ...params,
              //   rawTransaction: newApprovalRawTransaction
              // }))
            } else {
              throw new Error('Unknown crypto error action');
            }
          } else {
            throw new Error('Only crypto payment method is supported when ending soon');
          }
        }
      }, (0, _types.isCryptoPaymentMethod)(shieldSubscription.paymentMethod) ? shieldSubscription.paymentMethod.crypto.tokenSymbol : '');
    }
    return (0, _types.isCryptoPaymentMethod)(shieldSubscription.paymentMethod) ? shieldSubscription.paymentMethod.crypto.tokenSymbol : `${shieldSubscription.paymentMethod.card.brand.charAt(0).toUpperCase() + shieldSubscription.paymentMethod.card.brand.slice(1)} - ${shieldSubscription.paymentMethod.card.last4}`; // display card info for card payment method;
  }, [isPaused, shieldSubscription, isCryptoPayment, isSubscriptionEndingSoon, t, executeUpdateSubscriptionCardPaymentMethod, isInsufficientFundsCrypto, isAllowanceNeededCrypto]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "transaction-shield-page",
    "data-testid": "transaction-shield-page",
    width: _designSystem.BlockSize.Full,
    flexDirection: _designSystem.FlexDirection.Column,
    padding: 4
  }, (shieldSubscription === null || shieldSubscription === void 0 ? void 0 : shieldSubscription.cancelAtPeriodEnd) && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "transaction-shield-page__notification-banner",
    backgroundColor: _designSystem.BackgroundColor.warningMuted,
    paddingTop: 1,
    paddingBottom: 1,
    paddingInline: 4,
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    gap: 2,
    marginBottom: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.Info,
    size: _componentLibrary.IconSize.Lg
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm
  }, t('shieldTxMembershipCancelNotification', [(0, _util.getShortDateFormatterV2)().format(new Date(shieldSubscription.currentPeriodEnd))]))), membershipErrorBanner, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "transaction-shield-page__container",
    marginBottom: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, _extends({
    className: (0, _classnames.default)('transaction-shield-page__row transaction-shield-page__membership', {
      'transaction-shield-page__membership--loading': showSkeletonLoader,
      'transaction-shield-page__membership--inactive': isMembershipInactive && !showSkeletonLoader,
      'transaction-shield-page__membership--active': !isMembershipInactive && !showSkeletonLoader
    })
  }, rowsStyleProps, {
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    width: _designSystem.BlockSize.Full,
    gap: showSkeletonLoader ? 2 : 0,
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    "data-theme": _preferences.ThemeType.dark
  }, showSkeletonLoader ? /*#__PURE__*/_react.default.createElement(_skeleton.Skeleton, {
    width: "60%",
    height: 20
  }) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    gap: 3
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdBold,
    className: "transaction-shield-page__membership-text"
  }, isMembershipInactive ? t('shieldTxMembershipInactive') : t('shieldTxMembershipActive')), (shieldSubscription === null || shieldSubscription === void 0 ? void 0 : shieldSubscription.status) === _subscriptionController.SUBSCRIPTION_STATUSES.trialing && /*#__PURE__*/_react.default.createElement(_componentLibrary.Tag, {
    label: t('shieldTxMembershipFreeTrial'),
    labelProps: {
      variant: _designSystem.TextVariant.bodySmMedium,
      color: _designSystem.TextColor.textAlternative
    },
    borderStyle: _designSystem.BorderStyle.none,
    borderRadius: _designSystem.BorderRadius.SM,
    backgroundColor: _designSystem.BackgroundColor.backgroundMuted
  }), isPaused && /*#__PURE__*/_react.default.createElement(_componentLibrary.Tag, {
    label: t('shieldTxMembershipPaused'),
    labelProps: {
      variant: _designSystem.TextVariant.bodySmMedium,
      color: _designSystem.TextColor.textAlternative
    },
    borderStyle: _designSystem.BorderStyle.none,
    borderRadius: _designSystem.BorderRadius.SM,
    backgroundColor: _designSystem.BackgroundColor.backgroundMuted
  })), showSkeletonLoader ? /*#__PURE__*/_react.default.createElement(_skeleton.Skeleton, {
    width: "60%",
    height: 16
  }) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyXs,
    className: "transaction-shield-page__membership-text"
  }, t('shieldTxMembershipId'), ": ", customerId))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, _extends({
    className: "transaction-shield-page__row"
  }, rowsStyleProps, {
    flexDirection: _designSystem.FlexDirection.Column,
    paddingTop: 2,
    paddingBottom: 2
  }), shieldDetails.map((detail, index) => /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    key: index,
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    gap: 2,
    paddingTop: 2,
    paddingBottom: 2
  }, showSkeletonLoader ? /*#__PURE__*/_react.default.createElement(_skeleton.Skeleton, {
    width: 32,
    height: 32,
    borderRadius: _designSystem.BorderRadius.full,
    style: {
      flexShrink: 0
    }
  }) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: detail.icon,
    size: _componentLibrary.IconSize.Xl
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    width: _designSystem.BlockSize.Full,
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: showSkeletonLoader ? 2 : 0
  }, showSkeletonLoader ? /*#__PURE__*/_react.default.createElement(_skeleton.Skeleton, {
    width: "100%",
    height: 18
  }) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySmBold
  }, detail.title), showSkeletonLoader ? /*#__PURE__*/_react.default.createElement(_skeleton.Skeleton, {
    width: "100%",
    height: 18
  }) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative
  }, detail.description))))), buttonRow(t('shieldTxMembershipViewFullBenefits'), () => {
    // todo: link to benefits page
  }), !isCancelled && buttonRow(t('shieldTxMembershipSubmitCase'), () => {
    navigate(_routes.TRANSACTION_SHIELD_CLAIM_ROUTE);
  }), !isMembershipInactive && (shieldSubscription === null || shieldSubscription === void 0 ? void 0 : shieldSubscription.cancelAtPeriodEnd) && buttonRow(t('shieldTxMembershipResubscribe'), () => {
    executeUnCancelSubscription();
  }), canCancel && buttonRow(t('shieldTxMembershipCancel'), () => {
    setIsCancelMembershipModalOpen(true);
  }, 'shield-tx-membership-cancel-button'), isCancelled && buttonRow(t('shieldTxMembershipRenew'), async () => {
    if (isCryptoPayment) {
      // TODO: handle renew membership crypto
      console.log('renew membership');
    } else {
      await executeUpdateSubscriptionCardPaymentMethod();
    }
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "transaction-shield-page__container"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, _extends({
    className: "transaction-shield-page__row"
  }, rowsStyleProps, {
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 2
  }), showSkeletonLoader ? /*#__PURE__*/_react.default.createElement(_skeleton.Skeleton, {
    width: "60%",
    height: 24
  }) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingSm
  }, t('shieldTxMembershipBillingDetails')), shieldSubscription ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, billingDetails(t('shieldTxMembershipBillingDetailsNextBilling'), shieldSubscription !== null && shieldSubscription !== void 0 && shieldSubscription.cancelAtPeriodEnd ? '-' : (0, _util.getShortDateFormatterV2)().format(new Date(shieldSubscription.currentPeriodEnd))), billingDetails(t('shieldTxMembershipBillingDetailsCharges'), isCryptoPayment ? `${(0, _utils.getProductPrice)(productInfo)} ${productInfo === null || productInfo === void 0 ? void 0 : productInfo.currency.toUpperCase()} (${shieldSubscription.interval === _subscriptionController.RECURRING_INTERVALS.year ? t('shieldPlanAnnual') : t('shieldPlanMonthly')})` : `${formatCurrency((0, _utils.getProductPrice)(productInfo), productInfo === null || productInfo === void 0 ? void 0 : productInfo.currency.toUpperCase(), {
    maximumFractionDigits: 0
  })} (${shieldSubscription.interval === _subscriptionController.RECURRING_INTERVALS.year ? t('shieldPlanAnnual') : t('shieldPlanMonthly')})`), isCryptoPayment && billingDetails(t('shieldTxMembershipBillingDetailsBillingAccount'), (0, _types.isCryptoPaymentMethod)(shieldSubscription.paymentMethod) ? /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRowAddress, {
    address: shieldSubscription.paymentMethod.crypto.payerAddress,
    chainId: shieldSubscription.paymentMethod.crypto.chainId
  }) : ''), billingDetails(t('shieldTxMembershipBillingDetailsPaymentMethod'), paymentMethod)) : /*#__PURE__*/_react.default.createElement(_skeleton.Skeleton, {
    width: "60%",
    height: 24
  })), (shieldSubscription === null || shieldSubscription === void 0 ? void 0 : shieldSubscription.status) !== _subscriptionController.SUBSCRIPTION_STATUSES.provisional && buttonRow(t('shieldTxMembershipBillingDetailsViewBillingHistory'), executeOpenGetSubscriptionBillingPortal)), shieldSubscription && isCancelMembershipModalOpen && /*#__PURE__*/_react.default.createElement(_cancelMembershipModal.default, {
    onClose: () => setIsCancelMembershipModalOpen(false),
    onConfirm: async () => {
      setIsCancelMembershipModalOpen(false);
      await executeCancelSubscription();
    },
    subscription: shieldSubscription
  }), loading && /*#__PURE__*/_react.default.createElement(_loadingScreen.default, null), currentToken && isAddFundsModalOpen && shieldSubscription && (0, _types.isCryptoPaymentMethod)(shieldSubscription.paymentMethod) && /*#__PURE__*/_react.default.createElement(_addFundsModal.default, {
    onClose: () => {
      setIsAddFundsModalOpen(false);
    },
    token: currentToken,
    chainId: shieldSubscription.paymentMethod.crypto.chainId,
    payerAddress: shieldSubscription.paymentMethod.crypto.payerAddress
  }));
};
var _default = exports.default = TransactionShield;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\transaction-shield-tab\\transaction-shield.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\transaction-shield-tab\\types.ts", {"@metamask/subscription-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\subscription-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csettings%5Ctransaction-shield-tab%5Ctypes.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isCardPaymentMethod = isCardPaymentMethod;
exports.isCryptoPaymentMethod = isCryptoPaymentMethod;
var _subscriptionController = require("@metamask/subscription-controller");
function isCryptoPaymentMethod(paymentMethod) {
  return paymentMethod.type === _subscriptionController.PAYMENT_TYPES.byCrypto;
}
function isCardPaymentMethod(paymentMethod) {
  return paymentMethod.type === _subscriptionController.PAYMENT_TYPES.byCard;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\settings\\transaction-shield-tab\\types.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\shield-plan\\index.ts", {"./shield-plan":"D:\\code\\v\\metamask-extension\\ui\\pages\\shield-plan\\shield-plan.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cshield-plan%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _shieldPlan.default;
  }
});
var _shieldPlan = _interopRequireDefault(require("./shield-plan"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\shield-plan\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\shield-plan\\shield-payment-modal.tsx", {"../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../components/multichain/asset-picker-amount/asset-picker-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\asset-picker-modal\\index.ts","../../components/multichain/asset-picker-amount/asset-picker-modal/asset-picker-modal-tabs":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\asset-picker-modal\\asset-picker-modal-tabs.tsx","../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","@metamask/subscription-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\subscription-controller\\dist\\index.cjs","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cshield-plan%5Cshield-payment-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShieldPaymentModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _subscriptionController = require("@metamask/subscription-controller");
var _componentLibrary = require("../../components/component-library");
var _designSystem = require("../../helpers/constants/design-system");
var _assetPickerModal = require("../../components/multichain/asset-picker-amount/asset-picker-modal");
var _assetPickerModalTabs = require("../../components/multichain/asset-picker-amount/asset-picker-modal/asset-picker-modal-tabs");
var _useI18nContext = require("../../hooks/useI18nContext");
var _network = require("../../../shared/constants/network");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ShieldPaymentModal = ({
  isOpen,
  onClose,
  selectedPaymentMethod,
  setSelectedPaymentMethod,
  availableTokenBalances,
  selectedToken,
  onAssetChange,
  hasStableTokenWithBalance
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const [showAssetPickerModal, setShowAssetPickerModal] = (0, _react.useState)(false);
  const selectPaymentMethod = (0, _react.useCallback)(selectedMethod => {
    setSelectedPaymentMethod(selectedMethod);
    if (selectedMethod === _subscriptionController.PAYMENT_TYPES.byCrypto) {
      setShowAssetPickerModal(true);
    } else {
      onClose();
    }
  }, [setSelectedPaymentMethod, onClose]);

  // Create custom token list generator that filters for USDT/USDC with balance
  const customTokenListGenerator = (0, _react.useMemo)(() => {
    return function* (filterPredicate) {
      // Filter for USDT and USDC tokens that have balance
      for (const token of availableTokenBalances) {
        if (filterPredicate(token.symbol, token.address, token.chainId)) {
          yield token;
        }
      }
    };
  }, [availableTokenBalances]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: isOpen,
    onClose: () => undefined,
    className: "shield-payment-modal",
    "data-testid": "shield-payment-modal"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, {
    modalDialogProps: {
      padding: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onClose: onClose
  }, t('shieldPlanPaymentTitle')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    "data-testid": "shield-payment-method-token-button",
    as: "button",
    className: (0, _classnames.default)('payment-method-item', {
      'payment-method-item--selected': selectedPaymentMethod === _subscriptionController.PAYMENT_TYPES.byCrypto
    }),
    padding: 4,
    gap: 4,
    backgroundColor: selectedPaymentMethod === _subscriptionController.PAYMENT_TYPES.byCrypto ? _designSystem.BackgroundColor.primaryMuted : _designSystem.BackgroundColor.transparent,
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    width: _designSystem.BlockSize.Full,
    onClick: () => {
      selectPaymentMethod(_subscriptionController.PAYMENT_TYPES.byCrypto);
    },
    disabled: !hasStableTokenWithBalance
  }, selectedPaymentMethod === _subscriptionController.PAYMENT_TYPES.byCrypto && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "payment-method-item__selected-indicator",
    borderRadius: _designSystem.BorderRadius.pill,
    backgroundColor: _designSystem.BackgroundColor.primaryDefault
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    gap: 4
  }, hasStableTokenWithBalance ? /*#__PURE__*/_react.default.createElement(_componentLibrary.BadgeWrapper, {
    badge: /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
      size: _componentLibrary.AvatarNetworkSize.Xs,
      name: _network.NETWORK_TO_NAME_MAP[_network.CHAIN_IDS.MAINNET],
      src: _network.CHAIN_ID_TO_NETWORK_IMAGE_URL_MAP[_network.CHAIN_IDS.MAINNET],
      borderColor: _designSystem.BorderColor.borderMuted
    })
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarToken, {
    name: selectedToken === null || selectedToken === void 0 ? void 0 : selectedToken.symbol,
    src: selectedToken === null || selectedToken === void 0 ? void 0 : selectedToken.image,
    marginTop: 1,
    borderColor: _designSystem.BorderColor.borderMuted
  })) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    size: _componentLibrary.IconSize.Xl,
    name: _componentLibrary.IconName.Coin
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    textAlign: _designSystem.TextAlign.Left
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium
  }, t('shieldPlanPayWithToken', [hasStableTokenWithBalance ? (selectedToken === null || selectedToken === void 0 ? void 0 : selectedToken.symbol) ?? '' : 'Crypto'])), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative
  }, hasStableTokenWithBalance ? `${t('balance')}: ${(selectedToken === null || selectedToken === void 0 ? void 0 : selectedToken.string) ?? ''} ${(selectedToken === null || selectedToken === void 0 ? void 0 : selectedToken.symbol) ?? ''}` : t('shieldPlanNoFunds')))), hasStableTokenWithBalance && /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    size: _componentLibrary.IconSize.Md,
    name: _componentLibrary.IconName.ArrowRight
  }))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    "data-testid": "shield-payment-method-card-button",
    as: "button",
    className: (0, _classnames.default)('payment-method-item', {
      'payment-method-item--selected': selectedPaymentMethod === _subscriptionController.PAYMENT_TYPES.byCard
    }),
    padding: 4,
    gap: 4,
    backgroundColor: selectedPaymentMethod === _subscriptionController.PAYMENT_TYPES.byCard ? _designSystem.BackgroundColor.primaryMuted : _designSystem.BackgroundColor.transparent,
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    width: _designSystem.BlockSize.Full,
    onClick: () => selectPaymentMethod(_subscriptionController.PAYMENT_TYPES.byCard)
  }, selectedPaymentMethod === _subscriptionController.PAYMENT_TYPES.byCard && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "payment-method-item__selected-indicator",
    borderRadius: _designSystem.BorderRadius.pill,
    backgroundColor: _designSystem.BackgroundColor.primaryDefault
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    size: _componentLibrary.IconSize.Xl,
    name: _componentLibrary.IconName.Card
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    textAlign: _designSystem.TextAlign.Left
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium
  }, t('shieldPlanPayWithCard')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    gap: 1,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement("img", {
    src: "./images/card-mc.svg",
    alt: "Mastercard"
  }), /*#__PURE__*/_react.default.createElement("img", {
    src: "./images/card-visa.svg",
    alt: "Visa"
  }), /*#__PURE__*/_react.default.createElement("img", {
    src: "./images/card-amex.svg",
    alt: "American Express"
  }))))))), /*#__PURE__*/_react.default.createElement(_assetPickerModal.AssetPickerModal, {
    isOpen: showAssetPickerModal,
    onClose: () => {
      setShowAssetPickerModal(false);
    },
    asset: selectedToken,
    onAssetChange: asset => {
      onAssetChange(asset);
      setShowAssetPickerModal(false);
      onClose();
    },
    header: t('shieldPlanSelectToken'),
    autoFocus: false,
    visibleTabs: [_assetPickerModalTabs.TabName.TOKENS],
    customTokenListGenerator: customTokenListGenerator
  })));
};
exports.ShieldPaymentModal = ShieldPaymentModal;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\shield-plan\\shield-payment-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\shield-plan\\shield-plan.tsx", {"../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../components/multichain/pages/page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\index.ts","../../components/ui/loading-screen":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\loading-screen\\index.js","../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../hooks/subscription/useSubscription":"D:\\code\\v\\metamask-extension\\ui\\hooks\\subscription\\useSubscription.ts","../../hooks/subscription/useSubscriptionPricing":"D:\\code\\v\\metamask-extension\\ui\\hooks\\subscription\\useSubscriptionPricing.ts","../../hooks/useAsync":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAsync.ts","../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../confirmations/send-legacy/send.utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\send-legacy\\send.utils.js","./shield-payment-modal":"D:\\code\\v\\metamask-extension\\ui\\pages\\shield-plan\\shield-payment-modal.tsx","./utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\shield-plan\\utils.ts","@metamask/subscription-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\subscription-controller\\dist\\index.cjs","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","bignumber.js":"D:\\code\\v\\metamask-extension\\node_modules\\bignumber.js\\bignumber.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cshield-plan%5Cshield-plan.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _subscriptionController = require("@metamask/subscription-controller");
var _transactionController = require("@metamask/transaction-controller");
var _bignumber = require("bignumber.js");
var _reactRedux = require("react-redux");
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _network = require("../../../shared/constants/network");
var _conversion = require("../../../shared/modules/conversion.utils");
var _componentLibrary = require("../../components/component-library");
var _page = require("../../components/multichain/pages/page");
var _loadingScreen = _interopRequireDefault(require("../../components/ui/loading-screen"));
var _designSystem = require("../../helpers/constants/design-system");
var _routes = require("../../helpers/constants/routes");
var _useSubscriptionPricing = require("../../hooks/subscription/useSubscriptionPricing");
var _actions = require("../../store/actions");
var _useSubscription = require("../../hooks/subscription/useSubscription");
var _useAsync = require("../../hooks/useAsync");
var _useI18nContext = require("../../hooks/useI18nContext");
var _selectors = require("../../selectors");
var _accountTree = require("../../selectors/multichain-accounts/account-tree");
var _send = require("../confirmations/send-legacy/send.utils");
var _shieldPaymentModal = require("./shield-payment-modal");
var _utils = require("./utils");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const ShieldPlan = () => {
  var _networkConfiguration;
  const navigate = (0, _reactRouterDomV5Compat.useNavigate)();
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const evmInternalAccount = (0, _reactRedux.useSelector)(state =>
  // Account address will be the same for all EVM accounts
  (0, _accountTree.getInternalAccountBySelectedAccountGroupAndCaip)(state, 'eip155:1'));
  const {
    subscriptions,
    trialedProducts,
    loading: subscriptionsLoading,
    error: subscriptionsError
  } = (0, _useSubscription.useUserSubscriptions)({
    refetch: true // always fetch latest subscriptions state in shield plan screen
  });
  const shieldSubscription = (0, _useSubscription.useUserSubscriptionByProduct)(_subscriptionController.PRODUCT_TYPES.SHIELD, subscriptions);
  const isTrialed = trialedProducts === null || trialedProducts === void 0 ? void 0 : trialedProducts.includes(_subscriptionController.PRODUCT_TYPES.SHIELD);
  (0, _react.useEffect)(() => {
    if (shieldSubscription) {
      // redirect to subscription settings page if user already has a subscription
      navigate(_routes.TRANSACTION_SHIELD_ROUTE);
    }
  }, [navigate, shieldSubscription]);
  const [selectedPlan, setSelectedPlan] = (0, _react.useState)(_subscriptionController.RECURRING_INTERVALS.year);
  const {
    subscriptionPricing,
    loading: subscriptionPricingLoading,
    error: subscriptionPricingError
  } = (0, _useSubscriptionPricing.useSubscriptionPricing)({
    refetch: true // always fetch latest price
  });
  const pricingPlans = (0, _useSubscriptionPricing.useSubscriptionProductPlans)(_subscriptionController.PRODUCT_TYPES.SHIELD, subscriptionPricing);
  const cryptoPaymentMethod = (0, _useSubscriptionPricing.useSubscriptionPaymentMethods)('crypto', subscriptionPricing);
  const selectedProductPrice = (0, _react.useMemo)(() => {
    return pricingPlans === null || pricingPlans === void 0 ? void 0 : pricingPlans.find(plan => plan.interval === selectedPlan);
  }, [pricingPlans, selectedPlan]);
  const availableTokenBalances = (0, _useSubscriptionPricing.useAvailableTokenBalances)({
    paymentChains: cryptoPaymentMethod === null || cryptoPaymentMethod === void 0 ? void 0 : cryptoPaymentMethod.chains,
    price: selectedProductPrice,
    productType: _subscriptionController.PRODUCT_TYPES.SHIELD
  });
  const hasAvailableToken = availableTokenBalances.length > 0;
  const [selectedPaymentMethod, setSelectedPaymentMethod] = (0, _react.useState)(hasAvailableToken ? _subscriptionController.PAYMENT_TYPES.byCrypto : _subscriptionController.PAYMENT_TYPES.byCard);
  const [selectedToken, setSelectedToken] = (0, _react.useState)(() => {
    return availableTokenBalances[0];
  });
  const networkConfiguration = (0, _reactRedux.useSelector)(state => (0, _selectors.selectNetworkConfigurationByChainId)(state, selectedToken === null || selectedToken === void 0 ? void 0 : selectedToken.chainId));
  const networkClientId = networkConfiguration === null || networkConfiguration === void 0 || (_networkConfiguration = networkConfiguration.rpcEndpoints[networkConfiguration.defaultRpcEndpointIndex ?? 0]) === null || _networkConfiguration === void 0 ? void 0 : _networkConfiguration.networkClientId;

  // set selected token to the first available token if no token is selected
  (0, _react.useEffect)(() => {
    if (!selectedToken) {
      setSelectedToken(availableTokenBalances[0]);
    }
  }, [availableTokenBalances, selectedToken, setSelectedToken]);
  const [handleSubscription, subscriptionResult] = (0, _useAsync.useAsyncCallback)(async () => {
    if (selectedPaymentMethod === _subscriptionController.PAYMENT_TYPES.byCard) {
      await dispatch((0, _actions.startSubscriptionWithCard)({
        products: [_subscriptionController.PRODUCT_TYPES.SHIELD],
        isTrialRequested: !isTrialed,
        recurringInterval: selectedPlan
      }));
    } else if (selectedPaymentMethod === _subscriptionController.PAYMENT_TYPES.byCrypto) {
      var _selectedToken$approv, _subscriptionPricing$;
      const approvalAmount = new _bignumber.BigNumber((selectedToken === null || selectedToken === void 0 || (_selectedToken$approv = selectedToken.approvalAmount) === null || _selectedToken$approv === void 0 ? void 0 : _selectedToken$approv.approveAmount) ?? '0');
      const balance = new _bignumber.BigNumber((selectedToken === null || selectedToken === void 0 ? void 0 : selectedToken.balance) ?? '0');
      const balanceInWei = balance.mul(10 ** ((selectedToken === null || selectedToken === void 0 ? void 0 : selectedToken.decimals) ?? 18));
      const userHasEnoughBalance = balanceInWei.gte(approvalAmount);
      if (!userHasEnoughBalance) {
        throw new Error('Insufficient balance');
      }
      if (!selectedToken) {
        throw new Error('No token selected');
      }
      const spenderAddress = subscriptionPricing === null || subscriptionPricing === void 0 || (_subscriptionPricing$ = subscriptionPricing.paymentMethods) === null || _subscriptionPricing$ === void 0 || (_subscriptionPricing$ = _subscriptionPricing$.find(method => method.type === _subscriptionController.PAYMENT_TYPES.byCrypto)) === null || _subscriptionPricing$ === void 0 || (_subscriptionPricing$ = _subscriptionPricing$.chains) === null || _subscriptionPricing$ === void 0 || (_subscriptionPricing$ = _subscriptionPricing$.find(chain => chain.chainId === (selectedToken === null || selectedToken === void 0 ? void 0 : selectedToken.chainId))) === null || _subscriptionPricing$ === void 0 ? void 0 : _subscriptionPricing$.paymentAddress;
      const approvalData = (0, _send.generateERC20ApprovalData)({
        spenderAddress,
        amount: (0, _conversion.decimalToHex)(selectedToken.approvalAmount.approveAmount)
      });
      const transactionParams = {
        from: evmInternalAccount === null || evmInternalAccount === void 0 ? void 0 : evmInternalAccount.address,
        to: selectedToken.address,
        value: '0x0',
        data: approvalData
      };
      const transactionOptions = {
        type: _transactionController.TransactionType.shieldSubscriptionApprove,
        networkClientId: networkClientId
      };
      await (0, _actions.addTransaction)(transactionParams, transactionOptions);
      navigate(_routes.CONFIRM_TRANSACTION_ROUTE);
    }
  }, [dispatch, evmInternalAccount === null || evmInternalAccount === void 0 ? void 0 : evmInternalAccount.address, isTrialed, navigate, networkClientId, selectedPaymentMethod, selectedPlan, selectedToken, subscriptionPricing]);
  const loading = subscriptionsLoading || subscriptionPricingLoading || subscriptionResult.pending;
  const error = subscriptionsError || subscriptionPricingError || subscriptionResult.error;
  const plans = (0, _react.useMemo)(() => (pricingPlans === null || pricingPlans === void 0 ? void 0 : pricingPlans.map(plan => {
    const isYearly = plan.interval === _subscriptionController.RECURRING_INTERVALS.year;
    const price = (0, _utils.getProductPrice)(plan);
    return {
      id: plan.interval,
      label: t(isYearly ? 'shieldPlanAnnual' : 'shieldPlanMonthly'),
      price: t(isYearly ? 'shieldPlanAnnualPrice' : 'shieldPlanMonthlyPrice', [`$${price}`])
    };
  }).sort((a, _b) =>
  // sort by year first
  a.id === _subscriptionController.RECURRING_INTERVALS.year ? -1 : 1)) ?? [], [pricingPlans, t]);
  const selectedPlanData = plans.find(plan => plan.id === selectedPlan);
  const planDetails = [t('shieldPlanDetails1'), t(selectedPaymentMethod === _subscriptionController.PAYMENT_TYPES.byCrypto ? 'shieldPlanDetails2' : 'shieldPlanDetails2Card'), t('shieldPlanDetails3')];
  const [showPaymentModal, setShowPaymentModal] = (0, _react.useState)(false);
  const handleBack = () => {
    // transaction shield settings page has guard to redirect to current shield plan page if there is no subscription
    // which create a loop so we just back to settings page
    navigate(_routes.SETTINGS_ROUTE, {
      replace: true
    });
  };
  const rowsStyleProps = {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    alignItems: _designSystem.AlignItems.center,
    backgroundColor: _designSystem.BackgroundColor.backgroundSection,
    padding: 4
  };
  return /*#__PURE__*/_react.default.createElement(_page.Page, {
    className: "shield-plan-page",
    "data-testid": "shield-plan-page"
  }, /*#__PURE__*/_react.default.createElement(_page.Header, {
    textProps: {
      variant: _designSystem.TextVariant.headingSm
    },
    startAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      size: _componentLibrary.ButtonIconSize.Md,
      ariaLabel: t('back'),
      iconName: _componentLibrary.IconName.ArrowLeft,
      onClick: handleBack
    })
  }, t('shieldPlanTitle')), error && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm
  }, error.message), loading && /*#__PURE__*/_react.default.createElement(_loadingScreen.default, null), subscriptionPricing && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page.Content, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Grid,
    gap: 2,
    marginBottom: 4,
    paddingTop: 2,
    className: "shield-plan-page__plans"
  }, plans.map(plan => /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, _extends({
    as: "button",
    key: plan.id
  }, rowsStyleProps, {
    borderRadius: _designSystem.BorderRadius.LG,
    paddingTop: 2,
    paddingBottom: 2,
    gap: 4,
    className: (0, _classnames.default)('shield-plan-page__plan', {
      'shield-plan-page__plan--selected': plan.id === selectedPlan
    }),
    onClick: () => setSelectedPlan(plan.id)
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "shield-plan-page__radio"
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    textAlign: _designSystem.TextAlign.Left,
    className: "shield-plan-page__radio-label"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm
  }, plan.label), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingMd
  }, plan.price)), plan.id === _subscriptionController.RECURRING_INTERVALS.year && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    paddingInline: 2,
    borderRadius: _designSystem.BorderRadius.SM,
    className: "shield-plan-page__save-badge"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyXs,
    color: _designSystem.TextColor.iconInverse
  }, t('shieldPlanSave')))))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "shield-plan-page__group",
    marginBottom: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, _extends({
    as: "button",
    className: "shield-plan-page__row"
  }, rowsStyleProps, {
    onClick: () => setShowPaymentModal(true),
    width: _designSystem.BlockSize.Full
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyLgMedium
  }, t('shieldPlanPayWith')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    gap: 2,
    alignItems: _designSystem.AlignItems.center
  }, selectedPaymentMethod === _subscriptionController.PAYMENT_TYPES.byCrypto && selectedToken ? /*#__PURE__*/_react.default.createElement(_componentLibrary.BadgeWrapper, {
    badge: /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
      size: _componentLibrary.AvatarNetworkSize.Xs,
      name: _network.NETWORK_TO_NAME_MAP[selectedToken.chainId],
      src: _network.CHAIN_ID_TO_NETWORK_IMAGE_URL_MAP[selectedToken.chainId],
      borderColor: _designSystem.BorderColor.borderMuted
    })
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarToken, {
    name: (selectedToken === null || selectedToken === void 0 ? void 0 : selectedToken.symbol) || '',
    src: (selectedToken === null || selectedToken === void 0 ? void 0 : selectedToken.image) || '',
    borderColor: _designSystem.BorderColor.borderMuted
  })) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    size: _componentLibrary.IconSize.Xl,
    name: _componentLibrary.IconName.Card
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyLgMedium
  }, selectedPaymentMethod === _subscriptionController.PAYMENT_TYPES.byCrypto ? (selectedToken === null || selectedToken === void 0 ? void 0 : selectedToken.symbol) || '' : t('shieldPlanCard')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    size: _componentLibrary.IconSize.Md,
    name: _componentLibrary.IconName.ArrowRight
  })))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "shield-plan-page__group"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, _extends({
    className: "shield-plan-page__row"
  }, rowsStyleProps, {
    display: _designSystem.Display.Block
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyLgMedium,
    marginBottom: 4
  }, t('shieldPlanDetails')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 2
  }, planDetails.map((detail, index) => /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    key: index,
    display: _designSystem.Display.Flex,
    gap: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    style: {
      height: '1lh'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    size: _componentLibrary.IconSize.Sm,
    name: _componentLibrary.IconName.Check,
    color: _designSystem.IconColor.primaryDefault
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm
  }, detail)))))), /*#__PURE__*/_react.default.createElement(_shieldPaymentModal.ShieldPaymentModal, {
    isOpen: showPaymentModal,
    onClose: () => setShowPaymentModal(false),
    selectedToken: selectedToken,
    selectedPaymentMethod: selectedPaymentMethod,
    hasStableTokenWithBalance: hasAvailableToken,
    setSelectedPaymentMethod: setSelectedPaymentMethod,
    onAssetChange: setSelectedToken,
    availableTokenBalances: availableTokenBalances
  })), /*#__PURE__*/_react.default.createElement(_page.Footer, {
    className: "shield-plan-page__footer",
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 3,
    backgroundColor: _designSystem.BackgroundColor.backgroundMuted
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    size: _componentLibrary.ButtonSize.Lg,
    variant: _componentLibrary.ButtonVariant.Primary,
    block: true,
    onClick: handleSubscription
  }, t('continue')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative,
    textAlign: _designSystem.TextAlign.Center
  }, t('shieldPlanAutoRenew', [selectedPlanData === null || selectedPlanData === void 0 ? void 0 : selectedPlanData.price])))));
};
var _default = exports.default = ShieldPlan;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\shield-plan\\shield-plan.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\shield-plan\\utils.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cshield-plan%5Cutils.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getProductPrice = getProductPrice;
/**
 * Get the price of a product.
 *
 * @param productInfo - The product info object.
 * @param productInfo.unitAmount - The price amount of the product.
 * @param productInfo.unitDecimals - The number of decimals of the product.
 * @returns The price of the product.
 */
function getProductPrice(productInfo) {
  // Note: no need to use BigInt here since decimals is low (2)
  return productInfo.unitAmount / 10 ** productInfo.unitDecimals;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\shield-plan\\utils.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\smart-transactions\\smart-transaction-status-page\\index.ts", {"./smart-transaction-status-page":"D:\\code\\v\\metamask-extension\\ui\\pages\\smart-transactions\\smart-transaction-status-page\\smart-transaction-status-page.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csmart-transactions%5Csmart-transaction-status-page%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "SmartTransactionStatusPage", {
  enumerable: true,
  get: function () {
    return _smartTransactionStatusPage.default;
  }
});
var _smartTransactionStatusPage = _interopRequireDefault(require("./smart-transaction-status-page"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\smart-transactions\\smart-transaction-status-page\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\smart-transactions\\smart-transaction-status-page\\smart-transaction-status-animation.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/component-library/lottie-animation":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\lottie-animation\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","@metamask/smart-transactions-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\smart-transactions-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csmart-transactions%5Csmart-transaction-status-page%5Csmart-transaction-status-animation.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SmartTransactionStatusAnimation = void 0;
var _react = _interopRequireWildcard(require("react"));
var _smartTransactionsController = require("@metamask/smart-transactions-controller");
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _lottieAnimation = require("../../../components/component-library/lottie-animation");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ANIMATIONS_FOLDER = 'images/animations/smart-transaction-status';
const Animations = {
  Failed: {
    path: `${ANIMATIONS_FOLDER}/failed.lottie.json`,
    loop: false
  },
  Confirmed: {
    path: `${ANIMATIONS_FOLDER}/confirmed.lottie.json`,
    loop: false
  },
  SubmittingIntro: {
    path: `${ANIMATIONS_FOLDER}/submitting-intro.lottie.json`,
    loop: false
  },
  SubmittingLoop: {
    path: `${ANIMATIONS_FOLDER}/submitting-loop.lottie.json`,
    loop: true
  },
  Processing: {
    path: `${ANIMATIONS_FOLDER}/processing.lottie.json`,
    loop: true
  }
};
const SmartTransactionStatusAnimation = ({
  status
}) => {
  const [isIntro, setIsIntro] = (0, _react.useState)(true);
  let animation;
  if (status === _smartTransactionsController.SmartTransactionStatuses.PENDING) {
    animation = isIntro ? Animations.SubmittingIntro : Animations.SubmittingLoop;
  } else {
    switch (status) {
      case _smartTransactionsController.SmartTransactionStatuses.SUCCESS:
        animation = Animations.Confirmed;
        break;
      case _smartTransactionsController.SmartTransactionStatuses.REVERTED:
      case _smartTransactionsController.SmartTransactionStatuses.UNKNOWN:
        animation = Animations.Failed;
        break;
      default:
        animation = Animations.Processing;
    }
  }
  const handleAnimationComplete = (0, _react.useCallback)(() => {
    if (status === _smartTransactionsController.SmartTransactionStatuses.PENDING && isIntro) {
      setIsIntro(false);
    }
  }, [status, isIntro]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    style: {
      width: '96px',
      height: '96px'
    }
  }, /*#__PURE__*/_react.default.createElement(_lottieAnimation.LottieAnimation, {
    path: animation.path,
    loop: animation.loop,
    autoplay: true,
    onComplete: handleAnimationComplete
  }));
};
exports.SmartTransactionStatusAnimation = SmartTransactionStatusAnimation;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\smart-transactions\\smart-transaction-status-page\\smart-transaction-status-animation.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\smart-transactions\\smart-transaction-status-page\\smart-transaction-status-page.tsx", {"../../../../shared/constants/notifications":"D:\\code\\v\\metamask-extension\\shared\\constants\\notifications.ts","../../../../shared/constants/urls":"D:\\code\\v\\metamask-extension\\shared\\constants\\urls.ts","../../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../confirmations/components/simulation-details":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\simulation-details\\index.ts","./smart-transaction-status-animation":"D:\\code\\v\\metamask-extension\\ui\\pages\\smart-transactions\\smart-transaction-status-page\\smart-transaction-status-animation.tsx","@metamask/smart-transactions-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\smart-transactions-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csmart-transactions%5Csmart-transaction-status-page%5Csmart-transaction-status-page.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.showRemainingTimeInMinAndSec = exports.default = exports.SmartTransactionStatusPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _smartTransactionsController = require("@metamask/smart-transactions-controller");
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _networks = require("../../../../shared/modules/selectors/networks");
var _selectors = require("../../../selectors");
var _urls = require("../../../../shared/constants/urls");
var _actions = require("../../../store/actions");
var _conversion = require("../../../../shared/modules/conversion.utils");
var _simulationDetails = require("../../confirmations/components/simulation-details");
var _notifications = require("../../../../shared/constants/notifications");
var _smartTransactionStatusAnimation = require("./smart-transaction-status-animation");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const showRemainingTimeInMinAndSec = remainingTimeInSec => {
  if (!Number.isInteger(remainingTimeInSec)) {
    return '0:00';
  }
  const minutes = Math.floor(remainingTimeInSec / 60);
  const seconds = remainingTimeInSec % 60;
  return `${minutes}:${seconds.toString().padStart(2, '0')}`;
};
exports.showRemainingTimeInMinAndSec = showRemainingTimeInMinAndSec;
const getDisplayValues = ({
  t,
  isSmartTransactionPending,
  isSmartTransactionSuccess,
  isSmartTransactionCancelled
}) => {
  if (isSmartTransactionPending) {
    return {
      title: t('smartTransactionPending'),
      iconName: _componentLibrary.IconName.Clock,
      iconColor: _designSystem.IconColor.primaryDefault
    };
  } else if (isSmartTransactionSuccess) {
    return {
      title: t('smartTransactionSuccess'),
      iconName: _componentLibrary.IconName.Confirmation,
      iconColor: _designSystem.IconColor.successDefault
    };
  } else if (isSmartTransactionCancelled) {
    return {
      title: t('smartTransactionCancelled'),
      description: t('smartTransactionCancelledDescription'),
      iconName: _componentLibrary.IconName.Danger,
      iconColor: _designSystem.IconColor.errorDefault
    };
  }
  // E.g. reverted or unknown statuses.
  return {
    title: t('smartTransactionError'),
    description: t('smartTransactionErrorDescription'),
    iconName: _componentLibrary.IconName.Danger,
    iconColor: _designSystem.IconColor.errorDefault
  };
};
const Description = ({
  description
}) => {
  if (!description) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.center,
    className: "smart-transaction-status-page__description"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    marginTop: 2,
    color: _designSystem.TextColor.textAlternative,
    variant: _designSystem.TextVariant.bodySm
  }, description));
};
const PortfolioSmartTransactionStatusUrl = ({
  portfolioSmartTransactionStatusUrl,
  isSmartTransactionPending,
  onCloseExtension
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  if (!portfolioSmartTransactionStatusUrl) {
    return null;
  }
  const handleViewTransactionLinkClick = (0, _react.useCallback)(() => {
    const isWiderThanNotificationWidth = window.innerWidth > _notifications.NOTIFICATION_WIDTH;
    if (!isSmartTransactionPending || isWiderThanNotificationWidth) {
      onCloseExtension();
    }
    global.platform.openTab({
      url: portfolioSmartTransactionStatusUrl
    });
  }, [isSmartTransactionPending, onCloseExtension, portfolioSmartTransactionStatusUrl]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    marginTop: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    type: "link",
    variant: _componentLibrary.ButtonVariant.Link,
    onClick: handleViewTransactionLinkClick
  }, t('viewTransaction')));
};
const CloseExtensionButton = ({
  isDapp,
  onCloseExtension
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  if (!isDapp) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonSecondary, {
    "data-testid": "smart-transaction-status-page-footer-close-button",
    onClick: onCloseExtension,
    width: _designSystem.BlockSize.Full,
    marginTop: 3
  }, t('closeExtension'));
};
const FooterText = ({
  isDapp,
  isSmartTransactionPending
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  if (!isDapp || !isSmartTransactionPending) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    marginTop: 2,
    color: _designSystem.TextColor.textAlternative,
    variant: _designSystem.TextVariant.bodySm
  }, t('closeWindowAnytime'));
};
const ViewActivityButton = ({
  isDapp,
  onViewActivity
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  if (isDapp) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonSecondary, {
    "data-testid": "smart-transaction-status-page-footer-close-button",
    onClick: onViewActivity,
    width: _designSystem.BlockSize.Full,
    marginTop: 3
  }, t('viewActivity'));
};
const SmartTransactionsStatusPageFooter = ({
  isDapp,
  isSmartTransactionPending,
  onCloseExtension,
  onViewActivity
}) => {
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "smart-transaction-status-page__footer",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    width: _designSystem.BlockSize.Full,
    padding: 4,
    paddingBottom: 0
  }, /*#__PURE__*/_react.default.createElement(FooterText, {
    isDapp: isDapp,
    isSmartTransactionPending: isSmartTransactionPending
  }), /*#__PURE__*/_react.default.createElement(CloseExtensionButton, {
    isDapp: isDapp,
    onCloseExtension: onCloseExtension
  }), /*#__PURE__*/_react.default.createElement(ViewActivityButton, {
    isDapp: isDapp,
    onViewActivity: onViewActivity
  }));
};
const Title = ({
  title
}) => {
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textDefault,
    variant: _designSystem.TextVariant.headingMd,
    as: "h4",
    fontWeight: _designSystem.FontWeight.Bold
  }, title);
};
const SmartTransactionStatusPage = ({
  requestState,
  onCloseExtension = () => null,
  onViewActivity = () => null
}) => {
  var _smartTransaction$sta, _fullTxData$simulatio, _fullTxData$simulatio2;
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    smartTransaction,
    isDapp,
    txId
  } = requestState;
  const isSmartTransactionPending = !smartTransaction || smartTransaction.status === _smartTransactionsController.SmartTransactionStatuses.PENDING;
  const isSmartTransactionSuccess = (smartTransaction === null || smartTransaction === void 0 ? void 0 : smartTransaction.status) === _smartTransactionsController.SmartTransactionStatuses.SUCCESS;
  const isSmartTransactionCancelled = Boolean(smartTransaction === null || smartTransaction === void 0 || (_smartTransaction$sta = smartTransaction.status) === null || _smartTransaction$sta === void 0 ? void 0 : _smartTransaction$sta.startsWith(_smartTransactionsController.SmartTransactionStatuses.CANCELLED));
  const chainId = (0, _reactRedux.useSelector)(_networks.getCurrentChainId);
  // eslint-disable-next-line @typescript-eslint/ban-ts-comment
  // @ts-ignore: This same selector is used in the awaiting-swap component.
  const fullTxData = (0, _reactRedux.useSelector)(state => (0, _selectors.getFullTxData)(state, txId)) || {};
  const {
    title,
    description
  } = getDisplayValues({
    t,
    isSmartTransactionPending,
    isSmartTransactionSuccess,
    isSmartTransactionCancelled
  });
  (0, _react.useEffect)(() => {
    dispatch((0, _actions.hideLoadingIndication)());
  }, []);
  const canShowSimulationDetails = ((_fullTxData$simulatio = fullTxData.simulationData) === null || _fullTxData$simulatio === void 0 || (_fullTxData$simulatio = _fullTxData$simulatio.tokenBalanceChanges) === null || _fullTxData$simulatio === void 0 ? void 0 : _fullTxData$simulatio.length) > 0 || ((_fullTxData$simulatio2 = fullTxData.simulationData) === null || _fullTxData$simulatio2 === void 0 ? void 0 : _fullTxData$simulatio2.nativeBalanceChange);
  const uuid = smartTransaction === null || smartTransaction === void 0 ? void 0 : smartTransaction.uuid;
  const portfolioSmartTransactionStatusUrl = uuid && chainId ? `${_urls.BaseUrl.Portfolio}/networks/${Number((0, _conversion.hexToDecimal)(chainId))}/smart-transactions/${uuid}` : undefined;
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "smart-transaction-status-page",
    height: _designSystem.BlockSize.Full,
    width: _designSystem.BlockSize.Full,
    display: _designSystem.Display.Flex,
    borderStyle: _designSystem.BorderStyle.none,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.center,
    marginBottom: 0
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    width: _designSystem.BlockSize.Full,
    style: {
      flexGrow: 1
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.center,
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_smartTransactionStatusAnimation.SmartTransactionStatusAnimation, {
    status: smartTransaction === null || smartTransaction === void 0 ? void 0 : smartTransaction.status
  }), /*#__PURE__*/_react.default.createElement(Title, {
    title: title
  }), /*#__PURE__*/_react.default.createElement(Description, {
    description: description
  }), /*#__PURE__*/_react.default.createElement(PortfolioSmartTransactionStatusUrl, {
    portfolioSmartTransactionStatusUrl: portfolioSmartTransactionStatusUrl,
    isSmartTransactionPending: isSmartTransactionPending,
    onCloseExtension: onCloseExtension
  })), canShowSimulationDetails && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_simulationDetails.SimulationDetails, {
    transaction: fullTxData
  }))), /*#__PURE__*/_react.default.createElement(SmartTransactionsStatusPageFooter, {
    isDapp: isDapp,
    isSmartTransactionPending: isSmartTransactionPending,
    onCloseExtension: onCloseExtension,
    onViewActivity: onViewActivity
  }));
};
exports.SmartTransactionStatusPage = SmartTransactionStatusPage;
var _default = exports.default = SmartTransactionStatusPage;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\smart-transactions\\smart-transaction-status-page\\smart-transaction-status-page.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\snap-account-redirect\\components\\redirect-url-icon.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csnap-account-redirect%5Ccomponents%5Credirect-url-icon.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const RedirectUrlIcon = ({
  url,
  onSubmit
}) => {
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    "data-testid": "snap-account-redirect-url-icon",
    onClick: () => {
      global.platform.openTab({
        url
      });
      onSubmit === null || onSubmit === void 0 || onSubmit();
    },
    iconName: _componentLibrary.IconName.Export,
    color: _designSystem.IconColor.primaryDefault,
    size: _componentLibrary.ButtonIconSize.Sm,
    ariaLabel: ""
  });
};
var _default = exports.default = /*#__PURE__*/_react.default.memo(RedirectUrlIcon);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\snap-account-redirect\\components\\redirect-url-icon.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\snap-account-redirect\\components\\snap-account-redirect-context.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","./snap-account-redirect-message":"D:\\code\\v\\metamask-extension\\ui\\pages\\snap-account-redirect\\components\\snap-account-redirect-message.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csnap-account-redirect%5Ccomponents%5Csnap-account-redirect-context.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _snapAccountRedirectMessage = _interopRequireDefault(require("./snap-account-redirect-message"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const SnapAccountRedirectContent = ({
  url,
  snapName,
  isBlockedUrl,
  message,
  onSubmit
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const learnMoreAboutBlockedUrls = 'https://support.metamask.io/troubleshooting/deceptive-site-ahead-when-trying-to-connect-to-a-site/';
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    paddingTop: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    gap: 4,
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    "data-testid": "snap-account-redirect-content-title",
    textAlign: _designSystem.TextAlign.Center,
    variant: _designSystem.TextVariant.headingLg,
    paddingBottom: 2
  }, t('snapAccountRedirectFinishSigningTitle')), isBlockedUrl ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    paddingLeft: 4,
    paddingRight: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerAlert, {
    severity: _componentLibrary.BannerAlertSeverity.Danger,
    "data-testid": "snap-account-redirect-content-blocked-url-banner"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, null, t('snapUrlIsBlocked', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    variant: _componentLibrary.ButtonVariant.Link,
    size: _componentLibrary.ButtonSize.Inherit,
    onClick: () => global.platform.openTab({
      url: learnMoreAboutBlockedUrls
    }),
    key: `snap-url-is-blocked-learn-more-button`
  }, t('learnMore'))])))) : null, isBlockedUrl === false ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    "data-testid": "snap-account-redirect-content-description",
    textAlign: _designSystem.TextAlign.Center,
    variant: _designSystem.TextVariant.bodyMd
  }, t('snapAccountRedirectSiteDescription', [snapName])) : null, (url.length > 0 || message.length > 0) && isBlockedUrl === false ? /*#__PURE__*/_react.default.createElement(_snapAccountRedirectMessage.default, {
    snapName: snapName,
    url: url,
    message: message,
    onSubmit: onSubmit
  }) : null));
};
var _default = exports.default = SnapAccountRedirectContent;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\snap-account-redirect\\components\\snap-account-redirect-context.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\snap-account-redirect\\components\\snap-account-redirect-message.tsx", {"../../../components/app/snaps/snap-delineator":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-delineator\\index.js","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","./url-display-box":"D:\\code\\v\\metamask-extension\\ui\\pages\\snap-account-redirect\\components\\url-display-box.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csnap-account-redirect%5Ccomponents%5Csnap-account-redirect-message.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../../components/component-library");
var _snapDelineator = require("../../../components/app/snaps/snap-delineator");
var _urlDisplayBox = _interopRequireDefault(require("./url-display-box"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const SnapAccountRedirectMessage = ({
  snapName,
  url,
  message,
  onSubmit
}) => {
  /* eslint-disable no-negated-condition */
  return /*#__PURE__*/_react.default.createElement(_snapDelineator.SnapDelineator, {
    "data-testid": "snap-account-redirect-message-container",
    snapName: snapName
  }, message !== '' ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    "data-testid": "snap-account-redirect-message"
  }, message) : null, url.length > 0 ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingTop: 2,
    display: _designSystem.Display.Flex
  }, /*#__PURE__*/_react.default.createElement(_urlDisplayBox.default, {
    url: url,
    onSubmit: onSubmit
  })) : null);
};
var _default = exports.default = /*#__PURE__*/_react.default.memo(SnapAccountRedirectMessage);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\snap-account-redirect\\components\\snap-account-redirect-message.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\snap-account-redirect\\components\\url-display-box.tsx", {"../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","./redirect-url-icon":"D:\\code\\v\\metamask-extension\\ui\\pages\\snap-account-redirect\\components\\redirect-url-icon.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csnap-account-redirect%5Ccomponents%5Curl-display-box.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../../components/component-library");
var _redirectUrlIcon = _interopRequireDefault(require("./redirect-url-icon"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const UrlDisplayBox = ({
  url,
  onSubmit
}) => {
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.InlineFlex,
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    alignItems: _designSystem.AlignItems.center,
    borderWidth: 1,
    borderRadius: _designSystem.BorderRadius.SM,
    borderColor: _designSystem.BorderColor.borderDefault,
    paddingRight: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    "data-testid": "snap-account-redirect-url-display-box",
    padding: 2,
    variant: _designSystem.TextVariant.bodyMd,
    color: _designSystem.TextColor.primaryDefault
  }, url), /*#__PURE__*/_react.default.createElement(_redirectUrlIcon.default, {
    url: url,
    onSubmit: onSubmit
  }));
};
var _default = exports.default = /*#__PURE__*/_react.default.memo(UrlDisplayBox);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\snap-account-redirect\\components\\url-display-box.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\snap-account-redirect\\index.ts", {"./snap-account-redirect":"D:\\code\\v\\metamask-extension\\ui\\pages\\snap-account-redirect\\snap-account-redirect.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csnap-account-redirect%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "SnapAccountRedirect", {
  enumerable: true,
  get: function () {
    return _snapAccountRedirect.default;
  }
});
var _snapAccountRedirect = _interopRequireDefault(require("./snap-account-redirect"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\snap-account-redirect\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\snap-account-redirect\\snap-account-redirect.tsx", {"../../components/app/snaps/snap-authorship-header":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-authorship-header\\index.js","../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","./components/snap-account-redirect-context":"D:\\code\\v\\metamask-extension\\ui\\pages\\snap-account-redirect\\components\\snap-account-redirect-context.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csnap-account-redirect%5Csnap-account-redirect.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../components/component-library");
var _designSystem = require("../../helpers/constants/design-system");
var _snapAuthorshipHeader = _interopRequireDefault(require("../../components/app/snaps/snap-authorship-header"));
var _snapAccountRedirectContext = _interopRequireDefault(require("./components/snap-account-redirect-context"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const SnapAccountRedirect = ({
  url,
  snapId,
  snapName,
  isBlockedUrl,
  message,
  onSubmit
}) => {
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "create-snap-account-page",
    height: _designSystem.BlockSize.Full,
    width: _designSystem.BlockSize.Full,
    borderStyle: _designSystem.BorderStyle.none,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_snapAuthorshipHeader.default, {
    snapId: snapId
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.center,
    height: _designSystem.BlockSize.Full,
    padding: 4
  }, /*#__PURE__*/_react.default.createElement(_snapAccountRedirectContext.default, {
    url: url,
    onSubmit: onSubmit,
    snapId: snapId,
    snapName: snapName,
    isBlockedUrl: isBlockedUrl,
    message: message
  })));
};
var _default = exports.default = SnapAccountRedirect;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\snap-account-redirect\\snap-account-redirect.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\snaps\\snap-view\\constants.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csnaps%5Csnap-view%5Cconstants.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KeyringSnapRemovalResultStatus = void 0;
const KeyringSnapRemovalResultStatus = exports.KeyringSnapRemovalResultStatus = {
  Success: 'success',
  Failed: 'failed',
  None: 'none'
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\snaps\\snap-view\\constants.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\snaps\\snap-view\\index.js", {"./snap-view":"D:\\code\\v\\metamask-extension\\ui\\pages\\snaps\\snap-view\\snap-view.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csnaps%5Csnap-view%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _snapView.default;
  }
});
var _snapView = _interopRequireDefault(require("./snap-view"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\snaps\\snap-view\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\snaps\\snap-view\\snap-settings.js", {"../../../components/app/connected-sites-list":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\connected-sites-list\\index.js","../../../components/app/snaps/keyring-snap-removal-warning":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\keyring-snap-removal-warning\\index.ts","../../../components/app/snaps/show-more":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\show-more\\index.js","../../../components/app/snaps/snap-authorship-expanded":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-authorship-expanded\\index.js","../../../components/app/snaps/snap-delineator":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-delineator\\index.js","../../../components/app/snaps/snap-permissions-list":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-permissions-list\\index.js","../../../components/app/snaps/snap-remove-warning":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-remove-warning\\index.js","../../../components/app/snaps/snap-update-alert":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-update-alert\\index.js","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../helpers/constants/snaps":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\snaps\\index.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./constants":"D:\\code\\v\\metamask-extension\\ui\\pages\\snaps\\snap-view\\constants.ts","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js","semver":"D:\\code\\v\\metamask-extension\\node_modules\\semver\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csnaps%5Csnap-view%5Csnap-settings.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRouterDom = require("react-router-dom");
var _semver = _interopRequireDefault(require("semver"));
var _snapsUtils = require("@metamask/snaps-utils");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _designSystem = require("../../../helpers/constants/design-system");
var _snapAuthorshipExpanded = _interopRequireDefault(require("../../../components/app/snaps/snap-authorship-expanded"));
var _snapRemoveWarning = _interopRequireDefault(require("../../../components/app/snaps/snap-remove-warning"));
var _connectedSitesList = _interopRequireDefault(require("../../../components/app/connected-sites-list"));
var _keyringSnapRemovalWarning = _interopRequireDefault(require("../../../components/app/snaps/keyring-snap-removal-warning"));
var _actions = require("../../../store/actions");
var _selectors = require("../../../selectors");
var _componentLibrary = require("../../../components/component-library");
var _snapPermissionsList = _interopRequireDefault(require("../../../components/app/snaps/snap-permissions-list"));
var _snapDelineator = require("../../../components/app/snaps/snap-delineator");
var _snaps = require("../../../helpers/constants/snaps");
var _snapUpdateAlert = _interopRequireDefault(require("../../../components/app/snaps/snap-update-alert"));
var _routes = require("../../../helpers/constants/routes");
var _showMore = require("../../../components/app/snaps/show-more");
var _constants = require("./constants");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)

///: END:ONLY_INCLUDE_IF

///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)

///: END:ONLY_INCLUDE_IF

function SnapSettings({
  snapId,
  initRemove,
  resetInitRemove
}) {
  const history = (0, _reactRouterDom.useHistory)();
  const t = (0, _useI18nContext.useI18nContext)();
  const snaps = (0, _reactRedux.useSelector)(_selectors.getSnaps);
  const dispatch = (0, _reactRedux.useDispatch)();
  const snap = Object.entries(snaps).map(([_, snapState]) => snapState).find(snapState => snapState.id === snapId);
  const [isShowingRemoveWarning, setIsShowingRemoveWarning] = (0, _react.useState)(false);
  // eslint-disable-next-line no-unused-vars -- Main build does not use setIsRemovingKeyringSnap
  const [isRemovingKeyringSnap, setIsRemovingKeyringSnap] = (0, _react.useState)(false);

  // eslint-disable-next-line no-unused-vars -- Main build does not use setKeyringAccounts
  const [keyringAccounts, setKeyringAccounts] = (0, _react.useState)([]);
  ///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
  const internalAccounts = (0, _reactRedux.useSelector)(_selectors.getMemoizedMetaMaskInternalAccounts);
  ///: END:ONLY_INCLUDE_IF

  const connectedSubjects = (0, _reactRedux.useSelector)(state => (0, _selectors.getSubjectsWithSnapPermission)(state, snap === null || snap === void 0 ? void 0 : snap.id));
  const permissions = (0, _reactRedux.useSelector)(state => snap && (0, _selectors.getPermissions)(state, snap.id));
  const {
    name: snapName,
    description
  } = (0, _reactRedux.useSelector)(state => (0, _selectors.getSnapMetadata)(state, snapId));
  let isKeyringSnap = false;
  ///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
  isKeyringSnap = Boolean(permissions === null || permissions === void 0 ? void 0 : permissions.snap_manageAccounts);
  (0, _react.useEffect)(() => {
    if (isKeyringSnap) {
      (async () => {
        const addresses = await (0, _actions.getSnapAccountsById)(snap.id);
        const snapIdentities = Object.values(internalAccounts).filter(internalAccount => addresses.includes(internalAccount.address.toLowerCase()));
        setKeyringAccounts(snapIdentities);
      })();
    }
  }, [snap === null || snap === void 0 ? void 0 : snap.id, internalAccounts, isKeyringSnap]);
  ///: END:ONLY_INCLUDE_IF

  const onDisconnect = connectedOrigin => {
    dispatch((0, _actions.disconnectOriginFromSnap)(connectedOrigin, snap.id));
  };
  const latestRegistryVersion = (0, _reactRedux.useSelector)(state => snap ? (0, _selectors.getSnapLatestVersion)(state, snap === null || snap === void 0 ? void 0 : snap.id) : null);
  const isUpdateAvailable = latestRegistryVersion ? _semver.default.gt(latestRegistryVersion, snap.version) : false;
  const handleUpdate = async () => {
    const snapToInstall = {
      [snap.id]: {
        version: latestRegistryVersion
      }
    };
    const approvalId = await dispatch((0, _actions.updateSnap)('MetaMask', snapToInstall));
    if (approvalId) {
      history.push(`${_routes.CONNECT_ROUTE}/${approvalId}`);
    }
  };
  const connectedTitle = () => {
    if (connectedSubjects.every(subject => (0, _snapsUtils.isSnapId)(subject.origin))) {
      return t('connectedSnaps');
    } else if (connectedSubjects.some(subject => (0, _snapsUtils.isSnapId)(subject.origin))) {
      return t('connectedSitesAndSnaps');
    }
    return t('connectedSites');
  };
  (0, _react.useEffect)(() => {
    if (initRemove) {
      setIsShowingRemoveWarning(true);
      resetInitRemove();
    }
  }, [initRemove, resetInitRemove]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, isUpdateAvailable && /*#__PURE__*/_react.default.createElement(_snapUpdateAlert.default, {
    snapName: snapName,
    onUpdateClick: handleUpdate,
    bannerAlertProps: {
      marginBottom: 4
    }
  }), /*#__PURE__*/_react.default.createElement(_snapAuthorshipExpanded.default, {
    snapId: snap.id,
    snap: snap
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "snap-view__content__description",
    marginTop: [4, 7]
  }, /*#__PURE__*/_react.default.createElement(_snapDelineator.SnapDelineator, {
    type: _snaps.DelineatorType.Description,
    snapName: snapName
  }, /*#__PURE__*/_react.default.createElement(_showMore.ShowMore, {
    buttonBackground: _designSystem.BackgroundColor.backgroundDefault
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, null, description)))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "snap-view__content__permissions",
    marginTop: 12
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyLgMedium,
    marginBottom: 1
  }, t('permissions')), /*#__PURE__*/_react.default.createElement(_snapPermissionsList.default, {
    snapId: snapId,
    snapName: snapName,
    permissions: permissions ?? {},
    showOptions: true,
    showAllPermissions: true
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "snap-view__content__connected-sites",
    marginTop: 12
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyLgMedium,
    marginBottom: 2
  }, connectedTitle()), /*#__PURE__*/_react.default.createElement(_connectedSitesList.default, {
    connectedSubjects: connectedSubjects,
    onDisconnect: origin => {
      onDisconnect(origin, snap.id);
    }
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "snap-view__content__remove",
    marginTop: 12
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyLgMedium,
    color: _designSystem.TextColor.textDefault
  }, t('removeSnap')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    color: _designSystem.TextColor.textDefault
  }, t('removeSnapDescription')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginTop: 4,
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    className: "snap-view__content__remove-button",
    danger: "true",
    variant: _componentLibrary.ButtonVariant.Secondary,
    width: _designSystem.BlockSize.Full,
    size: _componentLibrary.ButtonSize.Lg,
    onClick: () => setIsShowingRemoveWarning(true),
    "data-testid": "remove-snap-button",
    disabled: snap.preinstalled && snap.removable === false
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.inherit,
    variant: _designSystem.TextVariant.bodyMd,
    flexWrap: _designSystem.FlexWrap.NoWrap,
    ellipsis: true,
    style: {
      overflow: 'hidden'
    },
    paddingTop: 3,
    paddingBottom: 3
  }, `${t('remove')} ${snapName}`)), /*#__PURE__*/_react.default.createElement(_snapRemoveWarning.default, {
    isOpen: isShowingRemoveWarning && (!isKeyringSnap || keyringAccounts.length === 0) && !isRemovingKeyringSnap,
    onCancel: () => setIsShowingRemoveWarning(false),
    onSubmit: async () => {
      await dispatch((0, _actions.removeSnap)(snap.id));
    },
    snapName: snapName
  }),
  /*#__PURE__*/
  ///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
  _react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_keyringSnapRemovalWarning.default, {
    snap: snap,
    keyringAccounts: keyringAccounts,
    snapUrl: snap.url,
    onCancel: () => setIsShowingRemoveWarning(false),
    onClose: () => setIsShowingRemoveWarning(false),
    onBack: () => setIsShowingRemoveWarning(false),
    onSubmit: async () => {
      try {
        setIsRemovingKeyringSnap(true);
        await dispatch((0, _actions.removeSnap)(snap.id));
        setIsShowingRemoveWarning(false);
        dispatch((0, _actions.showKeyringSnapRemovalModal)({
          snapName,
          result: _constants.KeyringSnapRemovalResultStatus.Success
        }));
      } catch {
        setIsShowingRemoveWarning(false);
        dispatch((0, _actions.showKeyringSnapRemovalModal)({
          snapName,
          result: _constants.KeyringSnapRemovalResultStatus.Failed
        }));
      } finally {
        setIsRemovingKeyringSnap(false);
      }
    },
    isOpen: isShowingRemoveWarning && isKeyringSnap && keyringAccounts.length > 0
  }))
  ///: END:ONLY_INCLUDE_IF
  )));
}
SnapSettings.propTypes = {
  snapId: _propTypes.default.string.isRequired,
  initRemove: _propTypes.default.bool,
  resetInitRemove: _propTypes.default.func
};
var _default = exports.default = SnapSettings;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\snaps\\snap-view\\snap-settings.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\snaps\\snap-view\\snap-view.js", {"../../../components/app/snaps/snap-authorship-header":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-authorship-header\\index.js","../../../components/app/snaps/snap-home-menu":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-home-menu\\index.js","../../../components/app/snaps/snap-home-page/snap-home-renderer":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-home-page\\snap-home-renderer.js","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/multichain/pages/page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","./snap-settings":"D:\\code\\v\\metamask-extension\\ui\\pages\\snaps\\snap-view\\snap-settings.js","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csnaps%5Csnap-view%5Csnap-view.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _utils = require("@metamask/utils");
var _designSystem = require("../../../helpers/constants/design-system");
var _routes = require("../../../helpers/constants/routes");
var _selectors = require("../../../selectors");
var _componentLibrary = require("../../../components/component-library");
var _page = require("../../../components/multichain/pages/page");
var _snapAuthorshipHeader = _interopRequireDefault(require("../../../components/app/snaps/snap-authorship-header"));
var _snapHomeMenu = _interopRequireDefault(require("../../../components/app/snaps/snap-home-menu"));
var _snapHomeRenderer = require("../../../components/app/snaps/snap-home-page/snap-home-renderer");
var _snapSettings = _interopRequireDefault(require("./snap-settings"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SnapView() {
  const history = (0, _reactRouterDom.useHistory)();
  const location = (0, _reactRouterDom.useLocation)();
  const {
    pathname
  } = location;
  // The snap ID is in URI-encoded form in the last path segment of the URL.
  const snapId = decodeURIComponent(pathname.match(/[^/]+$/u)[0]);
  const snaps = (0, _reactRedux.useSelector)(_selectors.getSnaps);
  const snap = Object.entries(snaps).map(([_, snapState]) => snapState).find(snapState => snapState.id === snapId);
  (0, _react.useEffect)(() => {
    if (!snap) {
      history.push(_routes.SNAPS_ROUTE);
    }
  }, [history, snap]);
  const permissions = (0, _reactRedux.useSelector)(state => snap && (0, _selectors.getPermissions)(state, snap.id));
  const hasHomePage = permissions && (0, _utils.hasProperty)(permissions, 'endowment:page-home');
  const [showSettings, setShowSettings] = (0, _react.useState)(!hasHomePage);
  const [initRemove, setInitRemove] = (0, _react.useState)(false);
  if (!snap) {
    return null;
  }
  const handleSettingsClick = () => {
    setShowSettings(true);
  };
  const handleSnapRemove = () => {
    setInitRemove(true);
    setShowSettings(true);
  };
  const resetInitRemove = () => {
    setInitRemove(false);
  };
  const handleBackClick = () => {
    if (snap.preinstalled && snap.hidden) {
      history.push(_routes.DEFAULT_ROUTE);
    } else if (showSettings && hasHomePage) {
      setShowSettings(false);
    } else {
      history.push(_routes.SNAPS_ROUTE);
    }
  };
  const renderBackButton = () => {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      justifyContent: _designSystem.JustifyContent.center,
      alignItems: _designSystem.AlignItems.center
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      ariaLabel: "Back",
      iconName: "arrow-left",
      size: _componentLibrary.ButtonIconSize.Md,
      onClick: handleBackClick
    }));
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "snap-view"
  }, /*#__PURE__*/_react.default.createElement(_page.Page, {
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault
  }, !snap.hideSnapBranding && /*#__PURE__*/_react.default.createElement(_snapAuthorshipHeader.default, {
    snapId: snapId,
    showInfo: false,
    startAccessory: renderBackButton(),
    endAccessory: !snap.hidden && /*#__PURE__*/_react.default.createElement(_snapHomeMenu.default, {
      snapId: snapId,
      onSettingsClick: handleSettingsClick,
      onRemoveClick: handleSnapRemove,
      isSettingsAvailable: !snap.preinstalled
    })
  }), /*#__PURE__*/_react.default.createElement(_page.Content, {
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    className: "snap-view__content",
    marginTop: showSettings ? 4 : 0,
    padding: showSettings ? 4 : 0
  }, showSettings ? /*#__PURE__*/_react.default.createElement(_snapSettings.default, {
    snapId: snapId,
    initRemove: initRemove,
    resetInitRemove: resetInitRemove
  }) : /*#__PURE__*/_react.default.createElement(_snapHomeRenderer.SnapHomeRenderer, {
    snapId: snapId
  }))));
}
var _default = exports.default = SnapView;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\snaps\\snap-view\\snap-view.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\snaps\\snaps-list\\index.js", {"./snap-list":"D:\\code\\v\\metamask-extension\\ui\\pages\\snaps\\snaps-list\\snap-list.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csnaps%5Csnaps-list%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _snapList.default;
  }
});
var _snapList = _interopRequireDefault(require("./snap-list"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\snaps\\snaps-list\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\snaps\\snaps-list\\snap-list.js", {"../../../components/app/snaps/snap-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-list-item\\index.js","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/multichain/pages/page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../helpers/utils/settings-search":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\settings-search.js","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Csnaps%5Csnaps-list%5Csnap-list.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _snapListItem = _interopRequireDefault(require("../../../components/app/snaps/snap-list-item"));
var _useI18nContext = require("../../../hooks/useI18nContext");
var _designSystem = require("../../../helpers/constants/design-system");
var _routes = require("../../../helpers/constants/routes");
var _selectors = require("../../../selectors");
var _settingsSearch = require("../../../helpers/utils/settings-search");
var _componentLibrary = require("../../../components/component-library");
var _page = require("../../../components/multichain/pages/page");
var _util = require("../../../helpers/utils/util");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SnapList = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const settingsRef = (0, _react.useRef)();
  const onClick = snap => {
    history.push((0, _util.getSnapRoute)(snap.id));
  };
  (0, _react.useEffect)(() => {
    (0, _settingsSearch.handleSettingsRefs)(t, t('snaps'), settingsRef);
  }, [settingsRef, t]);
  const snapsList = (0, _reactRedux.useSelector)(_selectors.getSnapsList);
  const snapUpdateMap = (0, _reactRedux.useSelector)(_selectors.getAllSnapAvailableUpdates);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "snaps"
  }, /*#__PURE__*/_react.default.createElement(_page.Page, {
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault
  }, /*#__PURE__*/_react.default.createElement(_page.Header, {
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    startAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      ariaLabel: "Back",
      iconName: "arrow-left",
      size: "sm",
      onClick: () => history.push(_routes.DEFAULT_ROUTE)
    })
  }, t('snaps')), /*#__PURE__*/_react.default.createElement(_page.Content, {
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    className: "snaps__content"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "snaps__content__list",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    height: _designSystem.BlockSize.Full
  }, snapsList.length > 0 && /*#__PURE__*/_react.default.createElement("div", {
    className: "snaps__content__list__body"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "snaps__content__list__wrapper"
  }, snapsList.map(snap => {
    return /*#__PURE__*/_react.default.createElement(_snapListItem.default, {
      className: "snaps__content__list-item",
      key: snap.key,
      packageName: snap.packageName,
      name: snap.name,
      onClick: () => {
        onClick(snap);
      },
      snapId: snap.id,
      showUpdateDot: snapUpdateMap.get(snap.id)
    });
  }))), snapsList.length <= 5 && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    height: _designSystem.BlockSize.Full,
    flexDirection: _designSystem.FlexDirection.Row,
    flexWrap: _designSystem.FlexWrap.Wrap,
    justifyContent: _designSystem.JustifyContent.center,
    className: "snaps__content__list__container--snaps-info-content"
  }, snapsList.length < 1 && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "snaps__content__list__container--no-snaps_inner",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.Snaps,
    color: _designSystem.IconColor.iconMuted,
    className: "snaps__content__list__no-snaps_icon",
    size: _componentLibrary.IconSize.Inherit
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.Color.textMuted,
    align: _designSystem.TextAlign.Center,
    marginTop: 4
  }, t('noSnaps'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    width: _designSystem.BlockSize.Full,
    height: _designSystem.BlockSize.Min
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "snaps__content__list__container--no-snaps_banner-tip",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: _designSystem.JustifyContent.flexEnd,
    paddingLeft: 4,
    paddingRight: 4,
    paddingBottom: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerTip, {
    logoType: _componentLibrary.BannerTipLogoType.Greeting,
    description: t('extendWalletWithSnaps'),
    descriptionProps: {
      variant: _designSystem.TextVariant.bodyMd
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    size: _designSystem.Size.auto,
    href: "https://snaps.metamask.io/",
    target: "_blank",
    endIconName: _componentLibrary.IconName.Export
  }, `${t('discoverSnaps')}`))))))));
};
var _default = exports.default = SnapList;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\snaps\\snaps-list\\snap-list.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\awaiting-signatures\\awaiting-signatures.js", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/modules/selectors":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\index.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/ui/box":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\box\\index.js","../../../components/ui/pulse-loader":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\pulse-loader\\index.js","../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../ducks/swaps/swaps":"D:\\code\\v\\metamask-extension\\ui\\ducks\\swaps\\swaps.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","../swaps-footer":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\swaps-footer\\index.js","./swap-step-icon":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\awaiting-signatures\\swap-step-icon.js","lodash/isEqual":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\isEqual.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cswaps%5Cawaiting-signatures%5Cawaiting-signatures.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = AwaitingSignatures;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _isEqual = _interopRequireDefault(require("lodash/isEqual"));
var _i18n = require("../../../contexts/i18n");
var _swaps = require("../../../ducks/swaps/swaps");
var _selectors = require("../../../selectors/selectors");
var _selectors2 = require("../../../../shared/modules/selectors");
var _routes = require("../../../helpers/constants/routes");
var _pulseLoader = _interopRequireDefault(require("../../../components/ui/pulse-loader"));
var _box = _interopRequireDefault(require("../../../components/ui/box"));
var _designSystem = require("../../../helpers/constants/design-system");
var _swapsFooter = _interopRequireDefault(require("../swaps-footer"));
var _metametrics = require("../../../contexts/metametrics");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _componentLibrary = require("../../../components/component-library");
var _swapStepIcon = _interopRequireDefault(require("./swap-step-icon"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function AwaitingSignatures() {
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const history = (0, _reactRouterDom.useHistory)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const fetchParams = (0, _reactRedux.useSelector)(_swaps.getFetchParams, _isEqual.default);
  const {
    destinationTokenInfo,
    sourceTokenInfo
  } = (fetchParams === null || fetchParams === void 0 ? void 0 : fetchParams.metaData) || {};
  const approveTxParams = (0, _reactRedux.useSelector)(_swaps.getApproveTxParams, _reactRedux.shallowEqual);
  const hardwareWalletUsed = (0, _reactRedux.useSelector)(_selectors.isHardwareWallet);
  const hardwareWalletType = (0, _reactRedux.useSelector)(_selectors.getHardwareWalletType);
  const smartTransactionsOptInStatus = (0, _reactRedux.useSelector)(_selectors2.getSmartTransactionsOptInStatusForMetrics);
  const smartTransactionsEnabled = (0, _reactRedux.useSelector)(_selectors2.getSmartTransactionsEnabled);
  const currentSmartTransactionsEnabled = (0, _reactRedux.useSelector)(_swaps.getCurrentSmartTransactionsEnabled);
  const needsTwoConfirmations = Boolean(approveTxParams);
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  (0, _react.useEffect)(() => {
    trackEvent({
      event: 'Awaiting Signature(s) on a HW wallet',
      category: _metametrics2.MetaMetricsEventCategory.Swaps,
      sensitiveProperties: {
        needs_two_confirmations: needsTwoConfirmations,
        token_from: sourceTokenInfo === null || sourceTokenInfo === void 0 ? void 0 : sourceTokenInfo.symbol,
        token_from_amount: fetchParams === null || fetchParams === void 0 ? void 0 : fetchParams.value,
        token_to: destinationTokenInfo === null || destinationTokenInfo === void 0 ? void 0 : destinationTokenInfo.symbol,
        request_type: fetchParams !== null && fetchParams !== void 0 && fetchParams.balanceError ? 'Quote' : 'Order',
        slippage: fetchParams === null || fetchParams === void 0 ? void 0 : fetchParams.slippage,
        custom_slippage: (fetchParams === null || fetchParams === void 0 ? void 0 : fetchParams.slippage) === 2,
        is_hardware_wallet: hardwareWalletUsed,
        hardware_wallet_type: hardwareWalletType,
        stx_enabled: smartTransactionsEnabled,
        current_stx_enabled: currentSmartTransactionsEnabled,
        stx_user_opt_in: smartTransactionsOptInStatus
      }
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const headerText = needsTwoConfirmations ? t('swapTwoTransactions') : t('swapConfirmWithHwWallet');
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "awaiting-signatures"
  }, /*#__PURE__*/_react.default.createElement(_box.default, {
    paddingLeft: 8,
    paddingRight: 8,
    height: _designSystem.BLOCK_SIZES.FULL,
    justifyContent: _designSystem.JustifyContent.center,
    display: _designSystem.DISPLAY.FLEX,
    className: "awaiting-signatures__content"
  }, /*#__PURE__*/_react.default.createElement(_box.default, {
    marginTop: 3,
    marginBottom: 4
  }, /*#__PURE__*/_react.default.createElement(_pulseLoader.default, null)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textDefault,
    variant: _designSystem.TextVariant.headingMd,
    as: "h3"
  }, headerText), needsTwoConfirmations && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdBold,
    marginTop: 2
  }, t('swapToConfirmWithHwWallet')), /*#__PURE__*/_react.default.createElement("ul", {
    className: "awaiting-signatures__steps"
  }, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_swapStepIcon.default, {
    stepNumber: 1
  }), t('swapAllowSwappingOf', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "span",
    variant: _designSystem.TextVariant.bodyMdBold,
    key: "allowToken"
  }, destinationTokenInfo === null || destinationTokenInfo === void 0 ? void 0 : destinationTokenInfo.symbol)])), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_swapStepIcon.default, {
    stepNumber: 2
  }), t('swapFromTo', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "span",
    variant: _designSystem.TextVariant.bodyMdBold,
    key: "tokenFrom"
  }, sourceTokenInfo === null || sourceTokenInfo === void 0 ? void 0 : sourceTokenInfo.symbol), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "span",
    variation: _designSystem.TextVariant.bodyMdBold,
    key: "tokenTo"
  }, destinationTokenInfo === null || destinationTokenInfo === void 0 ? void 0 : destinationTokenInfo.symbol)]))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd
  }, t('swapGasFeesSplit')))), /*#__PURE__*/_react.default.createElement(_swapsFooter.default, {
    onSubmit: async () => {
      await dispatch((0, _swaps.prepareToLeaveSwaps)());
      // Go to the default route and then to the build quote route in order to clean up
      // the `inputValue` local state in `pages/swaps/index.js`
      history.push(_routes.DEFAULT_ROUTE);
      history.push(_routes.PREPARE_SWAP_ROUTE);
    },
    submitText: t('cancel'),
    hideCancel: true
  }));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\swaps\\awaiting-signatures\\awaiting-signatures.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\awaiting-signatures\\index.js", {"./awaiting-signatures":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\awaiting-signatures\\awaiting-signatures.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cswaps%5Cawaiting-signatures%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _awaitingSignatures.default;
  }
});
var _awaitingSignatures = _interopRequireDefault(require("./awaiting-signatures"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\swaps\\awaiting-signatures\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\awaiting-signatures\\swap-step-icon.js", {"prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cswaps%5Cawaiting-signatures%5Cswap-step-icon.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = SwapStepIcon;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function SwapStepIcon({
  stepNumber = 1
}) {
  switch (stepNumber) {
    case 1:
      return /*#__PURE__*/_react.default.createElement("svg", {
        width: "14",
        height: "14",
        viewBox: "0 0 14 14",
        fill: "none",
        xmlns: "http://www.w3.org/2000/svg"
      }, /*#__PURE__*/_react.default.createElement("circle", {
        cx: "7",
        cy: "7",
        r: "6.25",
        stroke: "var(--color-primary-default)",
        strokeWidth: "1.5"
      }), /*#__PURE__*/_react.default.createElement("path", {
        d: "M6.50983 5.192H5.27783L6.14183 4H7.71783V9.68H6.50983V5.192Z",
        fill: "var(--color-primary-default)"
      }));
    case 2:
      return /*#__PURE__*/_react.default.createElement("svg", {
        width: "14",
        height: "14",
        viewBox: "0 0 14 14",
        fill: "none",
        xmlns: "http://www.w3.org/2000/svg"
      }, /*#__PURE__*/_react.default.createElement("circle", {
        cx: "7",
        cy: "7",
        r: "6.25",
        stroke: "var(--color-primary-default)",
        strokeWidth: "1.5"
      }), /*#__PURE__*/_react.default.createElement("path", {
        d: "M8.92 9.776H5V9.368C5 9.048 5.056 8.77067 5.168 8.536C5.28 8.296 5.42133 8.08533 5.592 7.904C5.768 7.71733 5.96267 7.54933 6.176 7.4C6.39467 7.25067 6.608 7.10133 6.816 6.952C6.928 6.872 7.03467 6.78933 7.136 6.704C7.24267 6.61867 7.33333 6.53067 7.408 6.44C7.488 6.34933 7.552 6.256 7.6 6.16C7.648 6.064 7.672 5.96533 7.672 5.864C7.672 5.67733 7.616 5.52 7.504 5.392C7.39733 5.25867 7.22933 5.192 7 5.192C6.88267 5.192 6.776 5.21333 6.68 5.256C6.584 5.29333 6.50133 5.344 6.432 5.408C6.368 5.472 6.31733 5.54667 6.28 5.632C6.248 5.71733 6.232 5.808 6.232 5.904H5.024C5.024 5.62667 5.07467 5.37067 5.176 5.136C5.27733 4.90133 5.41867 4.70133 5.6 4.536C5.78133 4.36533 5.99467 4.23467 6.24 4.144C6.48533 4.048 6.752 4 7.04 4C7.28 4 7.50933 4.03733 7.728 4.112C7.952 4.18667 8.14933 4.29867 8.32 4.448C8.49067 4.59733 8.62667 4.784 8.728 5.008C8.82933 5.22667 8.88 5.48267 8.88 5.776C8.88 6.032 8.85067 6.25867 8.792 6.456C8.73333 6.648 8.65067 6.824 8.544 6.984C8.44267 7.13867 8.32 7.28 8.176 7.408C8.032 7.536 7.87733 7.66133 7.712 7.784C7.64267 7.832 7.55733 7.888 7.456 7.952C7.36 8.016 7.26133 8.08267 7.16 8.152C7.064 8.22133 6.97333 8.29333 6.888 8.368C6.80267 8.44267 6.74133 8.51467 6.704 8.584H8.92V9.776Z",
        fill: "var(--color-primary-default)"
      }));
    default:
      return undefined;
    // Don't return any SVG if a step number is not supported.
  }
}
SwapStepIcon.propTypes = {
  stepNumber: _propTypes.default.number
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\swaps\\awaiting-signatures\\swap-step-icon.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\awaiting-swap\\awaiting-swap.js", {"../../../../shared/constants/common":"D:\\code\\v\\metamask-extension\\shared\\constants\\common.ts","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/swaps":"D:\\code\\v\\metamask-extension\\shared\\constants\\swaps.ts","../../../../shared/lib/ui-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\ui-utils.js","../../../../shared/modules/selectors":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\index.ts","../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../../shared/modules/swaps.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\swaps.utils.js","../../../components/ui/mascot":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\mascot\\index.js","../../../components/ui/pulse-loader":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\pulse-loader\\index.js","../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../ducks/swaps/swaps":"D:\\code\\v\\metamask-extension\\ui\\ducks\\swaps\\swaps.js","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../helpers/utils/build-types":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\build-types.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../create-new-swap":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\create-new-swap\\index.js","../swaps-footer":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\swaps-footer\\index.js","../swaps.util":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\swaps.util.ts","../view-on-block-explorer":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\view-on-block-explorer\\index.js","./quotes-timeout-icon":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\awaiting-swap\\quotes-timeout-icon.js","./swap-failure-icon":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\awaiting-swap\\swap-failure-icon.js","./swap-success-icon":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\awaiting-swap\\swap-success-icon.js","@metamask/etherscan-link":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\etherscan-link\\dist\\index.js","events":"D:\\code\\v\\metamask-extension\\node_modules\\events\\events.js","lodash/isEqual":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\isEqual.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cswaps%5Cawaiting-swap%5Cawaiting-swap.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = AwaitingSwap;
var _events = _interopRequireDefault(require("events"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRouterDom = require("react-router-dom");
var _isEqual = _interopRequireDefault(require("lodash/isEqual"));
var _etherscanLink = require("@metamask/etherscan-link");
var _i18n = require("../../../contexts/i18n");
var _metametrics = require("../../../contexts/metametrics");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _networks = require("../../../../shared/modules/selectors/networks");
var _metamask = require("../../../ducks/metamask/metamask");
var _selectors = require("../../../selectors");
var _selectors2 = require("../../../selectors/selectors");
var _selectors3 = require("../../../../shared/modules/selectors");
var _swaps = require("../../../ducks/swaps/swaps");
var _mascot = _interopRequireDefault(require("../../../components/ui/mascot"));
var _swaps2 = require("../../../../shared/constants/swaps");
var _common = require("../../../../shared/constants/common");
var _swaps3 = require("../../../../shared/modules/swaps.utils");
var _pulseLoader = _interopRequireDefault(require("../../../components/ui/pulse-loader"));
var _buildTypes = require("../../../helpers/utils/build-types");
var _routes = require("../../../helpers/constants/routes");
var _actions = require("../../../store/actions");
var _swaps4 = require("../swaps.util");
var _swapsFooter = _interopRequireDefault(require("../swaps-footer"));
var _createNewSwap = _interopRequireDefault(require("../create-new-swap"));
var _viewOnBlockExplorer = _interopRequireDefault(require("../view-on-block-explorer"));
var _uiUtils = require("../../../../shared/lib/ui-utils");
var _swapFailureIcon = _interopRequireDefault(require("./swap-failure-icon"));
var _swapSuccessIcon = _interopRequireDefault(require("./swap-success-icon"));
var _quotesTimeoutIcon = _interopRequireDefault(require("./quotes-timeout-icon"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function AwaitingSwap({
  swapComplete,
  errorKey,
  txHash,
  tokensReceived,
  submittingSwap,
  txId
}) {
  var _usedQuote$destinatio, _usedQuote$sourceToke2;
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const history = (0, _reactRouterDom.useHistory)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const hdEntropyIndex = (0, _reactRedux.useSelector)(_selectors2.getHDEntropyIndex);
  const animationEventEmitter = (0, _react.useRef)(new _events.default());
  const {
    swapMetaData
  } = (0, _reactRedux.useSelector)(state => (0, _selectors.getFullTxData)(state, txId)) || {};
  const fetchParams = (0, _reactRedux.useSelector)(_swaps.getFetchParams, _isEqual.default);
  const fromTokenInputValue = (0, _reactRedux.useSelector)(_swaps.getFromTokenInputValue);
  const maxSlippage = (0, _reactRedux.useSelector)(_swaps.getMaxSlippage);
  const usedQuote = (0, _reactRedux.useSelector)(_swaps.getUsedQuote, _isEqual.default);
  const approveTxParams = (0, _reactRedux.useSelector)(_swaps.getApproveTxParams, _reactRedux.shallowEqual);
  const swapsGasPrice = (0, _reactRedux.useSelector)(_swaps.getUsedSwapsGasPrice);
  const currentCurrency = (0, _reactRedux.useSelector)(_metamask.getCurrentCurrency);
  const usdConversionRate = (0, _reactRedux.useSelector)(_selectors.getUSDConversionRate);
  const chainId = (0, _reactRedux.useSelector)(_networks.getCurrentChainId);
  const rpcPrefs = (0, _reactRedux.useSelector)(_selectors.getRpcPrefsForCurrentProvider, _reactRedux.shallowEqual);
  const [trackedQuotesExpiredEvent, setTrackedQuotesExpiredEvent] = (0, _react.useState)(false);
  const destinationTokenSymbol = (usedQuote === null || usedQuote === void 0 || (_usedQuote$destinatio = usedQuote.destinationTokenInfo) === null || _usedQuote$destinatio === void 0 ? void 0 : _usedQuote$destinatio.symbol) || (swapMetaData === null || swapMetaData === void 0 ? void 0 : swapMetaData.token_to);
  let feeinUnformattedFiat;
  if (usedQuote && swapsGasPrice) {
    var _usedQuote$trade, _usedQuote$sourceToke;
    const renderableNetworkFees = (0, _swaps4.getRenderableNetworkFeesForQuote)({
      tradeGas: usedQuote.gasEstimateWithRefund || usedQuote.averageGas,
      approveGas: (approveTxParams === null || approveTxParams === void 0 ? void 0 : approveTxParams.gas) || '0x0',
      gasPrice: swapsGasPrice,
      currentCurrency,
      conversionRate: usdConversionRate,
      tradeValue: usedQuote === null || usedQuote === void 0 || (_usedQuote$trade = usedQuote.trade) === null || _usedQuote$trade === void 0 ? void 0 : _usedQuote$trade.value,
      sourceSymbol: usedQuote === null || usedQuote === void 0 || (_usedQuote$sourceToke = usedQuote.sourceTokenInfo) === null || _usedQuote$sourceToke === void 0 ? void 0 : _usedQuote$sourceToke.symbol,
      sourceAmount: usedQuote.sourceAmount,
      chainId
    });
    feeinUnformattedFiat = renderableNetworkFees.rawNetworkFees;
  }
  const hardwareWalletUsed = (0, _reactRedux.useSelector)(_selectors.isHardwareWallet);
  const hardwareWalletType = (0, _reactRedux.useSelector)(_selectors.getHardwareWalletType);
  const smartTransactionsOptInStatus = (0, _reactRedux.useSelector)(_selectors3.getSmartTransactionsOptInStatusForMetrics);
  const smartTransactionsEnabled = (0, _reactRedux.useSelector)(_selectors3.getSmartTransactionsEnabled);
  const currentSmartTransactionsEnabled = (0, _reactRedux.useSelector)(_swaps.getCurrentSmartTransactionsEnabled);
  const swapSlippage = (swapMetaData === null || swapMetaData === void 0 ? void 0 : swapMetaData.slippage) || (usedQuote === null || usedQuote === void 0 ? void 0 : usedQuote.slippage);
  const sensitiveProperties = {
    token_from: (swapMetaData === null || swapMetaData === void 0 ? void 0 : swapMetaData.token_from) || (usedQuote === null || usedQuote === void 0 || (_usedQuote$sourceToke2 = usedQuote.sourceTokenInfo) === null || _usedQuote$sourceToke2 === void 0 ? void 0 : _usedQuote$sourceToke2.symbol),
    token_from_amount: swapMetaData === null || swapMetaData === void 0 ? void 0 : swapMetaData.token_from_amount,
    token_to: destinationTokenSymbol,
    request_type: fetchParams !== null && fetchParams !== void 0 && fetchParams.balanceError ? 'Quote' : 'Order',
    slippage: swapSlippage,
    custom_slippage: swapSlippage === 2,
    gas_fees: feeinUnformattedFiat,
    is_hardware_wallet: hardwareWalletUsed,
    hardware_wallet_type: hardwareWalletType,
    stx_enabled: smartTransactionsEnabled,
    current_stx_enabled: currentSmartTransactionsEnabled,
    stx_user_opt_in: smartTransactionsOptInStatus
  };
  const baseNetworkUrl = rpcPrefs.blockExplorerUrl ?? _common.CHAINID_DEFAULT_BLOCK_EXPLORER_URL_MAP[chainId] ?? null;
  const blockExplorerUrl = (0, _etherscanLink.getBlockExplorerLink)({
    hash: txHash,
    chainId
  }, {
    blockExplorerUrl: baseNetworkUrl
  });
  let headerText;
  let statusImage;
  let descriptionText;
  let submitText;
  let content;
  if (errorKey === _swaps2.OFFLINE_FOR_MAINTENANCE) {
    headerText = t('offlineForMaintenance');
    descriptionText = t('metamaskSwapsOfflineDescription');
    submitText = t('close');
    statusImage = /*#__PURE__*/_react.default.createElement(_swapFailureIcon.default, null);
  } else if (errorKey === _swaps2.SWAP_FAILED_ERROR) {
    headerText = t('swapFailedErrorTitle');
    descriptionText = t('swapFailedErrorDescriptionWithSupportLink', [/*#__PURE__*/_react.default.createElement("a", {
      className: "awaiting-swap__support-link",
      key: "awaiting-swap-support-link",
      href: _uiUtils.SUPPORT_LINK,
      target: "_blank",
      rel: "noopener noreferrer",
      onClick: () => {
        trackEvent({
          category: _metametrics2.MetaMetricsEventCategory.Swaps,
          event: _metametrics2.MetaMetricsEventName.SupportLinkClicked,
          properties: {
            url: _uiUtils.SUPPORT_LINK
          }
        }, {
          contextPropsIntoEventProperties: [_metametrics2.MetaMetricsContextProp.PageTitle]
        });
      }
    }, new URL(_uiUtils.SUPPORT_LINK).hostname)]);
    submitText = t('tryAgain');
    statusImage = /*#__PURE__*/_react.default.createElement(_swapFailureIcon.default, null);
    content = blockExplorerUrl && /*#__PURE__*/_react.default.createElement(_viewOnBlockExplorer.default, {
      blockExplorerUrl: blockExplorerUrl,
      sensitiveTrackingProperties: sensitiveProperties
    });
  } else if (errorKey === _swaps2.QUOTES_EXPIRED_ERROR) {
    headerText = t('swapQuotesExpiredErrorTitle');
    descriptionText = t('swapQuotesExpiredErrorDescription');
    submitText = t('tryAgain');
    statusImage = /*#__PURE__*/_react.default.createElement(_quotesTimeoutIcon.default, null);
    if (!trackedQuotesExpiredEvent) {
      setTrackedQuotesExpiredEvent(true);
      trackEvent({
        event: 'Quotes Timed Out',
        category: _metametrics2.MetaMetricsEventCategory.Swaps,
        sensitiveProperties,
        properties: {
          hd_entropy_index: hdEntropyIndex
        }
      });
    }
  } else if (errorKey === _swaps2.ERROR_FETCHING_QUOTES) {
    headerText = t('swapFetchingQuotesErrorTitle');
    descriptionText = t('swapFetchingQuotesErrorDescription');
    submitText = t('back');
    statusImage = /*#__PURE__*/_react.default.createElement(_swapFailureIcon.default, null);
  } else if (errorKey === _swaps2.QUOTES_NOT_AVAILABLE_ERROR) {
    headerText = t('swapQuotesNotAvailableErrorTitle');
    descriptionText = t('swapQuotesNotAvailableErrorDescription');
    submitText = t('tryAgain');
    statusImage = /*#__PURE__*/_react.default.createElement(_swapFailureIcon.default, null);
  } else if (errorKey === _swaps2.CONTRACT_DATA_DISABLED_ERROR) {
    headerText = t('swapContractDataDisabledErrorTitle');
    descriptionText = t('swapContractDataDisabledErrorDescription');
    submitText = t('tryAgain');
    statusImage = /*#__PURE__*/_react.default.createElement(_swapFailureIcon.default, null);
  } else if (!errorKey && !swapComplete) {
    headerText = t('swapProcessing');
    statusImage = /*#__PURE__*/_react.default.createElement(_pulseLoader.default, null);
    submitText = t('swapsViewInActivity');
    descriptionText = t('swapOnceTransactionHasProcess', [/*#__PURE__*/_react.default.createElement("span", {
      key: "swapOnceTransactionHasProcess-1",
      className: "awaiting-swap__amount-and-symbol",
      "data-testid": "awaiting-swap-amount-and-symbol"
    }, destinationTokenSymbol)]);
    content = blockExplorerUrl && /*#__PURE__*/_react.default.createElement(_viewOnBlockExplorer.default, {
      blockExplorerUrl: blockExplorerUrl,
      sensitiveTrackingProperties: sensitiveProperties
    });
  } else if (!errorKey && swapComplete) {
    headerText = t('swapTransactionComplete');
    statusImage = /*#__PURE__*/_react.default.createElement(_swapSuccessIcon.default, null);
    submitText = t('close');
    descriptionText = t('swapTokenAvailable', [/*#__PURE__*/_react.default.createElement("span", {
      key: "swapTokenAvailable-2",
      className: "awaiting-swap__amount-and-symbol"
    }, `${tokensReceived || ''} ${destinationTokenSymbol}`)]);
    content = blockExplorerUrl && /*#__PURE__*/_react.default.createElement(_viewOnBlockExplorer.default, {
      blockExplorerUrl: blockExplorerUrl,
      sensitiveTrackingProperties: sensitiveProperties
    });
  }
  (0, _react.useEffect)(() => {
    if (errorKey) {
      // If there was an error, stop polling for quotes.
      dispatch((0, _actions.stopPollingForQuotes)());
    }
  }, [dispatch, errorKey]);
  const renderMascot = () => {
    if ((0, _buildTypes.isFlask)()) {
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "awaiting-swap__mascot"
      }, /*#__PURE__*/_react.default.createElement("img", {
        src: "./images/logo/metamask-fox.svg",
        width: "90",
        height: "90"
      }));
    }
    if ((0, _buildTypes.isBeta)()) {
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "awaiting-swap__mascot"
      }, /*#__PURE__*/_react.default.createElement("img", {
        src: "./images/logo/metamask-fox.svg",
        width: "90",
        height: "90"
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_mascot.default, {
      animationEventEmitter: animationEventEmitter.current,
      width: "90",
      height: "90"
    });
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "awaiting-swap"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "awaiting-swap__content"
  }, !(swapComplete || errorKey) && renderMascot(), /*#__PURE__*/_react.default.createElement("div", {
    className: "awaiting-swap__status-image"
  }, statusImage), /*#__PURE__*/_react.default.createElement("div", {
    className: "awaiting-swap__header",
    "data-testid": "awaiting-swap-header"
  }, headerText), /*#__PURE__*/_react.default.createElement("div", {
    className: "awaiting-swap__main-description",
    "data-testid": "awaiting-swap-main-description"
  }, descriptionText), content), !errorKey && swapComplete ? /*#__PURE__*/_react.default.createElement(_createNewSwap.default, {
    sensitiveTrackingProperties: sensitiveProperties
  }) : null, /*#__PURE__*/_react.default.createElement(_swapsFooter.default, {
    onSubmit: async () => {
      /* istanbul ignore next */
      if (errorKey === _swaps2.OFFLINE_FOR_MAINTENANCE) {
        await dispatch((0, _swaps.prepareToLeaveSwaps)());
        history.push(_routes.DEFAULT_ROUTE);
      } else if (errorKey === _swaps2.QUOTES_EXPIRED_ERROR) {
        dispatch((0, _swaps.prepareForRetryGetQuotes)());
        await dispatch((0, _swaps.fetchQuotesAndSetQuoteState)(history, fromTokenInputValue, maxSlippage, trackEvent));
      } else if (errorKey) {
        await dispatch((0, _swaps.navigateBackToPrepareSwap)(history));
      } else if ((0, _swaps3.isSwapsDefaultTokenSymbol)(destinationTokenSymbol, chainId) || swapComplete) {
        history.push(_routes.DEFAULT_ROUTE);
      } else {
        await dispatch((0, _actions.setDefaultHomeActiveTabName)('activity'));
        history.push(_routes.DEFAULT_ROUTE);
      }
    },
    onCancel: async () => await dispatch((0, _swaps.navigateBackToPrepareSwap)(history)),
    submitText: submitText,
    disabled: submittingSwap,
    hideCancel: errorKey !== _swaps2.QUOTES_EXPIRED_ERROR
  }));
}
AwaitingSwap.propTypes = {
  swapComplete: _propTypes.default.bool,
  txHash: _propTypes.default.string,
  tokensReceived: _propTypes.default.string,
  errorKey: _propTypes.default.oneOf([_swaps2.QUOTES_EXPIRED_ERROR, _swaps2.SWAP_FAILED_ERROR, _swaps2.ERROR_FETCHING_QUOTES, _swaps2.QUOTES_NOT_AVAILABLE_ERROR, _swaps2.OFFLINE_FOR_MAINTENANCE, _swaps2.CONTRACT_DATA_DISABLED_ERROR]),
  submittingSwap: _propTypes.default.bool,
  txId: _propTypes.default.string
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\swaps\\awaiting-swap\\awaiting-swap.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\awaiting-swap\\index.js", {"./awaiting-swap":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\awaiting-swap\\awaiting-swap.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cswaps%5Cawaiting-swap%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _awaitingSwap.default;
  }
});
var _awaitingSwap = _interopRequireDefault(require("./awaiting-swap"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\swaps\\awaiting-swap\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\awaiting-swap\\quotes-timeout-icon.js", {"react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cswaps%5Cawaiting-swap%5Cquotes-timeout-icon.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = QuotesTimeoutIcon;
var _react = _interopRequireDefault(require("react"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function QuotesTimeoutIcon() {
  return /*#__PURE__*/_react.default.createElement("svg", {
    width: "44",
    height: "44",
    viewBox: "0 0 44 44",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "M22 0C9.96768 0 0.178406 9.78928 0.178406 21.8216C0.178406 33.8539 9.96768 43.6432 22 43.6432C34.0323 43.6432 43.8216 33.8539 43.8216 21.8216C43.8216 9.78929 34.0323 0 22 0ZM22 3.27324C32.2633 3.27324 40.5484 11.5583 40.5484 21.8216C40.5484 32.0849 32.2633 40.3699 22 40.3699C11.7367 40.3699 3.45164 32.0849 3.45164 21.8216C3.45164 11.5583 11.7367 3.27324 22 3.27324ZM22 6.00094C21.0961 6.00094 20.3634 6.73371 20.3634 7.63756V21.8216C20.3634 22.4269 20.6932 22.9534 21.1817 23.2366L32.5187 29.783C33.3014 30.235 34.3001 29.9692 34.752 29.1864C35.2039 28.4036 34.938 27.405 34.1553 26.953L23.6366 20.8839V7.63756C23.6366 6.73371 22.9039 6.00094 22 6.00094Z",
    fill: "var(--color-primary-default)"
  }));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\swaps\\awaiting-swap\\quotes-timeout-icon.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\awaiting-swap\\swap-failure-icon.js", {"react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cswaps%5Cawaiting-swap%5Cswap-failure-icon.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = SwapFailureIcon;
var _react = _interopRequireDefault(require("react"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function SwapFailureIcon() {
  return /*#__PURE__*/_react.default.createElement("svg", {
    width: "45",
    height: "39",
    viewBox: "0 0 45 39",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "M22.203 0.424438L0.285706 38.2816H44.1203L22.203 0.424438ZM22.203 8.39436L37.2064 34.2966H7.19961L22.203 8.39436ZM20.2105 16.3643V24.3342H24.1955V16.3643H20.2105ZM20.2105 28.3192V32.3041H24.1955V28.3192",
    fill: "var(--color-error-default)"
  }));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\swaps\\awaiting-swap\\swap-failure-icon.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\awaiting-swap\\swap-success-icon.js", {"react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cswaps%5Cawaiting-swap%5Cswap-success-icon.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = SwapSuccessIcon;
var _react = _interopRequireDefault(require("react"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function SwapSuccessIcon() {
  return /*#__PURE__*/_react.default.createElement("svg", {
    width: "38",
    height: "38",
    viewBox: "0 0 38 38",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "M34.1429 19C34.1429 23.0161 32.5474 26.8678 29.7076 29.7076C26.8678 32.5474 23.0161 34.1428 19 34.1428C14.9839 34.1428 11.1322 32.5474 8.29238 29.7076C5.45254 26.8678 3.85714 23.0161 3.85714 19C3.85714 14.9838 5.45254 11.1322 8.29238 8.29237C11.1322 5.45253 14.9839 3.85713 19 3.85713C20.4386 3.85713 21.8393 4.06534 23.1643 4.44391L26.1361 1.47213C23.9404 0.563554 21.5364 0.0714111 19 0.0714111C16.5143 0.0714111 14.0529 0.561013 11.7563 1.51226C9.45983 2.46351 7.37316 3.85778 5.61548 5.61546C2.06568 9.16526 0.0714264 13.9798 0.0714264 19C0.0714264 24.0201 2.06568 28.8347 5.61548 32.3845C7.37316 34.1422 9.45983 35.5364 11.7563 36.4877C14.0529 37.4389 16.5143 37.9286 19 37.9286C24.0202 37.9286 28.8347 35.9343 32.3845 32.3845C35.9343 28.8347 37.9286 24.0201 37.9286 19H34.1429ZM11.2582 15.3657L8.58928 18.0536L17.1071 26.5714L36.0357 7.64284L33.3668 4.95498L17.1071 21.2146L11.2582 15.3657Z",
    fill: "var(--color-success-default)"
  }));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\swaps\\awaiting-swap\\swap-success-icon.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\create-new-swap\\create-new-swap.js", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../components/ui/box":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\box\\index.js","../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../ducks/swaps/swaps":"D:\\code\\v\\metamask-extension\\ui\\ducks\\swaps\\swaps.js","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","lodash/isEqual":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\isEqual.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cswaps%5Ccreate-new-swap%5Ccreate-new-swap.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = CreateNewSwap;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRouterDom = require("react-router-dom");
var _isEqual = _interopRequireDefault(require("lodash/isEqual"));
var _box = _interopRequireDefault(require("../../../components/ui/box"));
var _i18n = require("../../../contexts/i18n");
var _metametrics = require("../../../contexts/metametrics");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _swaps = require("../../../ducks/swaps/swaps");
var _routes = require("../../../helpers/constants/routes");
var _selectors = require("../../../selectors");
var _selectors2 = require("../../../selectors/selectors");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function CreateNewSwap({
  sensitiveTrackingProperties
}) {
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const hdEntropyIndex = (0, _reactRedux.useSelector)(_selectors2.getHDEntropyIndex);
  const dispatch = (0, _reactRedux.useDispatch)();
  const history = (0, _reactRouterDom.useHistory)();
  const defaultSwapsToken = (0, _reactRedux.useSelector)(_selectors.getSwapsDefaultToken, _isEqual.default);
  return /*#__PURE__*/_react.default.createElement(_box.default, {
    marginBottom: 3,
    className: "create-new-swap"
  }, /*#__PURE__*/_react.default.createElement("button", {
    onClick: async () => {
      trackEvent({
        event: _metametrics2.MetaMetricsEventName.MakeAnotherSwap,
        category: _metametrics2.MetaMetricsEventCategory.Swaps,
        sensitiveProperties: sensitiveTrackingProperties,
        properties: {
          hd_entropy_index: hdEntropyIndex
        }
      });
      history.push(_routes.DEFAULT_ROUTE); // It cleans up Swaps state.
      await dispatch((0, _swaps.navigateBackToPrepareSwap)(history));
      dispatch((0, _swaps.setSwapsFromToken)(defaultSwapsToken));
    }
  }, t('makeAnotherSwap')));
}
CreateNewSwap.propTypes = {
  sensitiveTrackingProperties: _propTypes.default.object.isRequired
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\swaps\\create-new-swap\\create-new-swap.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\create-new-swap\\index.js", {"./create-new-swap":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\create-new-swap\\create-new-swap.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cswaps%5Ccreate-new-swap%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _createNewSwap.default;
  }
});
var _createNewSwap = _interopRequireDefault(require("./create-new-swap"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\swaps\\create-new-swap\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\hooks\\useSwapsFeatureFlags.ts", {"../../../ducks/swaps/swaps":"D:\\code\\v\\metamask-extension\\ui\\ducks\\swaps\\swaps.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cswaps%5Chooks%5CuseSwapsFeatureFlags.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSwapsFeatureFlags = useSwapsFeatureFlags;
var _react = require("react");
var _reactRedux = require("react-redux");
var _swaps = require("../../../ducks/swaps/swaps");
function useSwapsFeatureFlags() {
  const dispatch = (0, _reactRedux.useDispatch)();
  (0, _react.useEffect)(() => {
    const fetchSwapsLivenessAndFeatureFlagsWrapper = async () => {
      await dispatch((0, _swaps.fetchSwapsLivenessAndFeatureFlags)());
    };
    fetchSwapsLivenessAndFeatureFlagsWrapper();
  }, [dispatch]);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\swaps\\hooks\\useSwapsFeatureFlags.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\hooks\\useUpdateSwapsState.ts", {"../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../ducks/swaps/swaps":"D:\\code\\v\\metamask-extension\\ui\\ducks\\swaps\\swaps.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../swaps.util":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\swaps.util.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cswaps%5Chooks%5CuseUpdateSwapsState.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useUpdateSwapsState;
var _react = require("react");
var _reactRedux = require("react-redux");
var _swaps = require("../swaps.util");
var _swaps2 = require("../../../ducks/swaps/swaps");
var _actions = require("../../../store/actions");
var _networks = require("../../../../shared/modules/selectors/networks");
var _selectors = require("../../../selectors");
function useUpdateSwapsState() {
  const dispatch = (0, _reactRedux.useDispatch)();
  const chainId = (0, _reactRedux.useSelector)(_networks.getCurrentChainId);
  const isSwapsChain = (0, _reactRedux.useSelector)(_selectors.getIsSwapsChain);
  const networkAndAccountSupports1559 = (0, _reactRedux.useSelector)(_selectors.checkNetworkAndAccountSupports1559);
  const isBasicFunctionality = (0, _reactRedux.useSelector)(_selectors.getUseExternalServices);
  (0, _react.useEffect)(() => {
    if (!isSwapsChain || !isBasicFunctionality) {
      return undefined;
    }
    (0, _swaps.fetchTokens)(chainId).then(tokens => {
      dispatch((0, _actions.setSwapsTokens)(tokens));
    }).catch(error => console.error(error));
    (0, _swaps.fetchTopAssets)(chainId).then(topAssets => {
      dispatch((0, _swaps2.setTopAssets)(topAssets));
    });
    (0, _swaps.fetchAggregatorMetadata)(chainId).then(newAggregatorMetadata => {
      dispatch((0, _swaps2.setAggregatorMetadata)(newAggregatorMetadata));
    });
    if (!networkAndAccountSupports1559) {
      dispatch((0, _swaps2.fetchAndSetSwapsGasPriceInfo)());
    }
    return () => {
      dispatch((0, _swaps2.prepareToLeaveSwaps)());
    };
  }, [dispatch, chainId, networkAndAccountSupports1559, isSwapsChain, isBasicFunctionality]);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\swaps\\hooks\\useUpdateSwapsState.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\index.js", {"../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../shared/constants/swaps":"D:\\code\\v\\metamask-extension\\shared\\constants\\swaps.ts","../../../shared/lib/transactions-controller-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\transactions-controller-utils.js","../../../shared/modules/selectors":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\index.ts","../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../components/ui/box":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\box\\index.js","../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../ducks/swaps/swaps":"D:\\code\\v\\metamask-extension\\ui\\ducks\\swaps\\swaps.js","../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../helpers/higher-order-components/feature-toggled-route":"D:\\code\\v\\metamask-extension\\ui\\helpers\\higher-order-components\\feature-toggled-route.js","../../hooks/useGasFeeEstimates":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useGasFeeEstimates.js","../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./awaiting-signatures":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\awaiting-signatures\\index.js","./awaiting-swap":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\awaiting-swap\\index.js","./hooks/useUpdateSwapsState":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\hooks\\useUpdateSwapsState.ts","./loading-swaps-quotes":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\loading-swaps-quotes\\index.js","./notification-page/notification-page":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\notification-page\\notification-page.js","./smart-transaction-status":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\smart-transaction-status\\index.js","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cswaps%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Swap;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _lodash = require("lodash");
var _transactionController = require("@metamask/transaction-controller");
var _i18n = require("../../contexts/i18n");
var _selectors = require("../../selectors/selectors");
var _networks = require("../../../shared/modules/selectors/networks");
var _swaps = require("../../ducks/swaps/swaps");
var _selectors2 = require("../../selectors");
var _selectors3 = require("../../../shared/modules/selectors");
var _routes = require("../../helpers/constants/routes");
var _swaps2 = require("../../../shared/constants/swaps");
var _actions = require("../../store/actions");
var _useGasFeeEstimates = require("../../hooks/useGasFeeEstimates");
var _featureToggledRoute = _interopRequireDefault(require("../../helpers/higher-order-components/feature-toggled-route"));
var _metametrics = require("../../../shared/constants/metametrics");
var _metametrics2 = require("../../contexts/metametrics");
var _transactionsControllerUtils = require("../../../shared/lib/transactions-controller-utils");
var _componentLibrary = require("../../components/component-library");
var _box = _interopRequireDefault(require("../../components/ui/box"));
var _designSystem = require("../../helpers/constants/design-system");
var _useUpdateSwapsState = _interopRequireDefault(require("./hooks/useUpdateSwapsState"));
var _awaitingSignatures = _interopRequireDefault(require("./awaiting-signatures"));
var _smartTransactionStatus = _interopRequireDefault(require("./smart-transaction-status"));
var _awaitingSwap = _interopRequireDefault(require("./awaiting-swap"));
var _loadingSwapsQuotes = _interopRequireDefault(require("./loading-swaps-quotes"));
var _notificationPage = _interopRequireDefault(require("./notification-page/notification-page"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function Swap() {
  var _approveTxData$txRece, _tradeTxData$txReceip, _fetchParams$destinat3, _fetchParams$sourceTo3;
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const history = (0, _reactRouterDom.useHistory)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const hdEntropyIndex = (0, _reactRedux.useSelector)(_selectors.getHDEntropyIndex);
  const {
    pathname
  } = (0, _reactRouterDom.useLocation)();
  const isAwaitingSwapRoute = pathname === _routes.AWAITING_SWAP_ROUTE;
  const isAwaitingSignaturesRoute = pathname === _routes.AWAITING_SIGNATURES_ROUTE;
  const isSwapsErrorRoute = pathname === _routes.SWAPS_ERROR_ROUTE;
  const isLoadingQuotesRoute = pathname === _routes.LOADING_QUOTES_ROUTE;
  const isSmartTransactionStatusRoute = pathname === _routes.SMART_TRANSACTION_STATUS_ROUTE;
  const isPrepareSwapRoute = pathname === _routes.PREPARE_SWAP_ROUTE;
  const [currentStxErrorTracked, setCurrentStxErrorTracked] = (0, _react.useState)(false);
  const fetchParams = (0, _reactRedux.useSelector)(_swaps.getFetchParams, _lodash.isEqual);
  const {
    destinationTokenInfo = {}
  } = (fetchParams === null || fetchParams === void 0 ? void 0 : fetchParams.metaData) || {};
  const routeState = (0, _reactRedux.useSelector)(_swaps.getBackgroundSwapRouteState);
  const selectedAccount = (0, _reactRedux.useSelector)(_selectors.getSelectedAccount, _reactRedux.shallowEqual);
  const quotes = (0, _reactRedux.useSelector)(_swaps.getQuotes, _lodash.isEqual);
  const latestAddedTokenTo = (0, _reactRedux.useSelector)(_swaps.getLatestAddedTokenTo, _lodash.isEqual);
  const txList = (0, _reactRedux.useSelector)(_selectors2.getCurrentNetworkTransactions, _reactRedux.shallowEqual);
  const tradeTxId = (0, _reactRedux.useSelector)(_swaps.getTradeTxId);
  const approveTxId = (0, _reactRedux.useSelector)(_swaps.getApproveTxId);
  const aggregatorMetadata = (0, _reactRedux.useSelector)(_swaps.getAggregatorMetadata, _reactRedux.shallowEqual);
  const fetchingQuotes = (0, _reactRedux.useSelector)(_swaps.getFetchingQuotes);
  let swapsErrorKey = (0, _reactRedux.useSelector)(_swaps.getSwapsErrorKey);
  const swapsEnabled = (0, _reactRedux.useSelector)(_swaps.getSwapsFeatureIsLive);
  const chainId = (0, _reactRedux.useSelector)(_networks.getCurrentChainId);
  const isSwapsChain = (0, _reactRedux.useSelector)(_selectors.getIsSwapsChain);
  const reviewSwapClickedTimestamp = (0, _reactRedux.useSelector)(_swaps.getReviewSwapClickedTimestamp);
  const reviewSwapClicked = Boolean(reviewSwapClickedTimestamp);
  const smartTransactionsOptInStatus = (0, _reactRedux.useSelector)(_selectors3.getSmartTransactionsOptInStatusForMetrics);
  const smartTransactionsEnabled = (0, _reactRedux.useSelector)(_selectors3.getSmartTransactionsEnabled);
  const currentSmartTransactionsEnabled = (0, _reactRedux.useSelector)(_swaps.getCurrentSmartTransactionsEnabled);
  const currentSmartTransactionsError = (0, _reactRedux.useSelector)(_swaps.getCurrentSmartTransactionsError);
  const networkClientId = (0, _reactRedux.useSelector)(_networks.getSelectedNetworkClientId);
  (0, _react.useEffect)(() => {
    const leaveSwaps = async () => {
      await dispatch((0, _swaps.prepareToLeaveSwaps)());
      // We need to wait until "prepareToLeaveSwaps" is done, because otherwise
      // a user would be redirected from DEFAULT_ROUTE back to Swaps.
      history.push(_routes.DEFAULT_ROUTE);
    };
    if (!isSwapsChain) {
      leaveSwaps();
    }
  }, [isSwapsChain, dispatch, history]);

  // This will pre-load gas fees before going to the View Quote page.
  (0, _useGasFeeEstimates.useGasFeeEstimates)();
  const {
    address: selectedAccountAddress
  } = selectedAccount;
  const approveTxData = approveTxId && txList.find(({
    id
  }) => approveTxId === id);
  const tradeTxData = tradeTxId && txList.find(({
    id
  }) => tradeTxId === id);
  const tokensReceived = (tradeTxData === null || tradeTxData === void 0 ? void 0 : tradeTxData.txReceipt) && (0, _transactionsControllerUtils.getSwapsTokensReceivedFromTxMeta)(destinationTokenInfo === null || destinationTokenInfo === void 0 ? void 0 : destinationTokenInfo.symbol, tradeTxData, destinationTokenInfo === null || destinationTokenInfo === void 0 ? void 0 : destinationTokenInfo.address, selectedAccountAddress, destinationTokenInfo === null || destinationTokenInfo === void 0 ? void 0 : destinationTokenInfo.decimals, approveTxData, chainId);
  const tradeConfirmed = (tradeTxData === null || tradeTxData === void 0 ? void 0 : tradeTxData.status) === _transactionController.TransactionStatus.confirmed;
  const approveError = (approveTxData === null || approveTxData === void 0 ? void 0 : approveTxData.status) === _transactionController.TransactionStatus.failed || (approveTxData === null || approveTxData === void 0 || (_approveTxData$txRece = approveTxData.txReceipt) === null || _approveTxData$txRece === void 0 ? void 0 : _approveTxData$txRece.status) === '0x0';
  const tradeError = (tradeTxData === null || tradeTxData === void 0 ? void 0 : tradeTxData.status) === _transactionController.TransactionStatus.failed || (tradeTxData === null || tradeTxData === void 0 || (_tradeTxData$txReceip = tradeTxData.txReceipt) === null || _tradeTxData$txReceip === void 0 ? void 0 : _tradeTxData$txReceip.status) === '0x0';
  const conversionError = approveError || tradeError;
  if (conversionError && swapsErrorKey !== _swaps2.CONTRACT_DATA_DISABLED_ERROR) {
    swapsErrorKey = _swaps2.SWAP_FAILED_ERROR;
  }
  const clearTemporaryTokenRef = (0, _react.useRef)();
  (0, _react.useEffect)(() => {
    clearTemporaryTokenRef.current = () => {
      if (latestAddedTokenTo && (!isAwaitingSwapRoute || conversionError)) {
        dispatch((0, _actions.ignoreTokens)({
          tokensToIgnore: latestAddedTokenTo,
          dontShowLoadingIndicator: true,
          networkClientId
        }));
      }
    };
  }, [conversionError, dispatch, latestAddedTokenTo, destinationTokenInfo, fetchParams, isAwaitingSwapRoute, networkClientId]);
  (0, _react.useEffect)(() => {
    return () => {
      clearTemporaryTokenRef.current();
    };
  }, []);
  (0, _useUpdateSwapsState.default)();
  const hardwareWalletUsed = (0, _reactRedux.useSelector)(_selectors.isHardwareWallet);
  const hardwareWalletType = (0, _reactRedux.useSelector)(_selectors.getHardwareWalletType);
  const trackExitedSwapsEvent = () => {
    var _fetchParams$sourceTo, _fetchParams$destinat;
    trackEvent({
      event: _metametrics.MetaMetricsEventName.ExitedSwaps,
      category: _metametrics.MetaMetricsEventCategory.Swaps,
      sensitiveProperties: {
        token_from: fetchParams === null || fetchParams === void 0 || (_fetchParams$sourceTo = fetchParams.sourceTokenInfo) === null || _fetchParams$sourceTo === void 0 ? void 0 : _fetchParams$sourceTo.symbol,
        token_from_amount: fetchParams === null || fetchParams === void 0 ? void 0 : fetchParams.value,
        request_type: fetchParams === null || fetchParams === void 0 ? void 0 : fetchParams.balanceError,
        token_to: fetchParams === null || fetchParams === void 0 || (_fetchParams$destinat = fetchParams.destinationTokenInfo) === null || _fetchParams$destinat === void 0 ? void 0 : _fetchParams$destinat.symbol,
        slippage: fetchParams === null || fetchParams === void 0 ? void 0 : fetchParams.slippage,
        custom_slippage: (fetchParams === null || fetchParams === void 0 ? void 0 : fetchParams.slippage) !== 2,
        current_screen: pathname.match(/\/swaps\/(.+)/u)[1],
        is_hardware_wallet: hardwareWalletUsed,
        hardware_wallet_type: hardwareWalletType,
        stx_enabled: smartTransactionsEnabled,
        current_stx_enabled: currentSmartTransactionsEnabled,
        stx_user_opt_in: smartTransactionsOptInStatus
      },
      properties: {
        hd_entropy_index: hdEntropyIndex
      }
    });
  };
  const exitEventRef = (0, _react.useRef)();
  (0, _react.useEffect)(() => {
    exitEventRef.current = () => {
      trackExitedSwapsEvent();
    };
  });
  (0, _react.useEffect)(() => {
    const fetchSwapsLivenessAndFeatureFlagsWrapper = async () => {
      await dispatch((0, _swaps.fetchSwapsLivenessAndFeatureFlags)());
    };
    fetchSwapsLivenessAndFeatureFlagsWrapper();
    return () => {
      exitEventRef.current();
    };
  }, [dispatch]);
  (0, _react.useEffect)(() => {
    // If there is a swapsErrorKey and reviewSwapClicked is false, there was an error in silent quotes prefetching
    // and we don't want to show the error page in that case, because another API call for quotes can be successful.
    if (swapsErrorKey && !isSwapsErrorRoute && reviewSwapClicked) {
      history.push(_routes.SWAPS_ERROR_ROUTE);
    }
  }, [history, swapsErrorKey, isSwapsErrorRoute, reviewSwapClicked]);
  const beforeUnloadEventAddedRef = (0, _react.useRef)();
  (0, _react.useEffect)(() => {
    const fn = () => {
      clearTemporaryTokenRef.current();
      if (isLoadingQuotesRoute) {
        dispatch((0, _swaps.prepareToLeaveSwaps)());
      }
      return null;
    };
    if (isLoadingQuotesRoute && !beforeUnloadEventAddedRef.current) {
      beforeUnloadEventAddedRef.current = true;
      window.addEventListener('beforeunload', fn);
    }
    return () => window.removeEventListener('beforeunload', fn);
  }, [dispatch, isLoadingQuotesRoute]);
  const trackErrorStxEvent = (0, _react.useCallback)(() => {
    var _fetchParams$sourceTo2, _fetchParams$destinat2;
    trackEvent({
      event: 'Error Smart Transactions',
      category: _metametrics.MetaMetricsEventCategory.Swaps,
      sensitiveProperties: {
        token_from: fetchParams === null || fetchParams === void 0 || (_fetchParams$sourceTo2 = fetchParams.sourceTokenInfo) === null || _fetchParams$sourceTo2 === void 0 ? void 0 : _fetchParams$sourceTo2.symbol,
        token_from_amount: fetchParams === null || fetchParams === void 0 ? void 0 : fetchParams.value,
        request_type: fetchParams === null || fetchParams === void 0 ? void 0 : fetchParams.balanceError,
        token_to: fetchParams === null || fetchParams === void 0 || (_fetchParams$destinat2 = fetchParams.destinationTokenInfo) === null || _fetchParams$destinat2 === void 0 ? void 0 : _fetchParams$destinat2.symbol,
        slippage: fetchParams === null || fetchParams === void 0 ? void 0 : fetchParams.slippage,
        custom_slippage: (fetchParams === null || fetchParams === void 0 ? void 0 : fetchParams.slippage) !== 2,
        current_screen: pathname.match(/\/swaps\/(.+)/u)[1],
        is_hardware_wallet: hardwareWalletUsed,
        hardware_wallet_type: hardwareWalletType,
        stx_enabled: smartTransactionsEnabled,
        current_stx_enabled: currentSmartTransactionsEnabled,
        stx_user_opt_in: smartTransactionsOptInStatus,
        stx_error: currentSmartTransactionsError
      }
    });
  }, [currentSmartTransactionsError, currentSmartTransactionsEnabled, trackEvent, fetchParams === null || fetchParams === void 0 ? void 0 : fetchParams.balanceError, fetchParams === null || fetchParams === void 0 || (_fetchParams$destinat3 = fetchParams.destinationTokenInfo) === null || _fetchParams$destinat3 === void 0 ? void 0 : _fetchParams$destinat3.symbol, fetchParams === null || fetchParams === void 0 ? void 0 : fetchParams.slippage, fetchParams === null || fetchParams === void 0 || (_fetchParams$sourceTo3 = fetchParams.sourceTokenInfo) === null || _fetchParams$sourceTo3 === void 0 ? void 0 : _fetchParams$sourceTo3.symbol, fetchParams === null || fetchParams === void 0 ? void 0 : fetchParams.value, hardwareWalletType, hardwareWalletUsed, pathname, smartTransactionsEnabled, smartTransactionsOptInStatus]);
  (0, _react.useEffect)(() => {
    if (currentSmartTransactionsError && !currentStxErrorTracked) {
      setCurrentStxErrorTracked(true);
      trackErrorStxEvent();
    }
  }, [currentSmartTransactionsError, trackErrorStxEvent, currentStxErrorTracked]);
  if (!isSwapsChain) {
    // A user is being redirected outside of Swaps via the async "leaveSwaps" function above. In the meantime
    // we have to prevent the code below this condition, which wouldn't work on an unsupported chain.
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  const redirectToDefaultRoute = async () => {
    clearTemporaryTokenRef.current();
    history.push({
      pathname: _routes.DEFAULT_ROUTE,
      state: {
        stayOnHomePage: true
      }
    });
    dispatch((0, _swaps.clearSwapsState)());
    await dispatch((0, _actions.resetBackgroundSwapsState)());
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "swaps"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "swaps__container"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "swaps__header"
  }, /*#__PURE__*/_react.default.createElement(_box.default, {
    display: _designSystem.DISPLAY.FLEX,
    justifyContent: _designSystem.JustifyContent.center,
    marginLeft: 4,
    width: _designSystem.FRACTIONS.ONE_TWELFTH,
    tabIndex: "0",
    onKeyUp: e => {
      if (e.key === 'Enter') {
        redirectToDefaultRoute();
      }
    }
  }, !isAwaitingSwapRoute && !isAwaitingSignaturesRoute && !isSmartTransactionStatusRoute && /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.Arrow2Left,
    size: _componentLibrary.IconSize.Lg,
    color: _designSystem.IconColor.iconAlternative,
    onClick: redirectToDefaultRoute,
    style: {
      cursor: 'pointer'
    },
    title: t('cancel')
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "swaps__title"
  }, t('swap')), /*#__PURE__*/_react.default.createElement(_box.default, {
    display: _designSystem.DISPLAY.FLEX,
    justifyContent: _designSystem.JustifyContent.center,
    marginRight: 4,
    width: _designSystem.FRACTIONS.ONE_TWELFTH,
    tabIndex: "0",
    onKeyUp: e => {
      if (e.key === 'Enter') {
        dispatch((0, _swaps.setTransactionSettingsOpened)(true));
      }
    }
  }, isPrepareSwapRoute && /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.Setting,
    size: _componentLibrary.IconSize.Lg,
    color: _designSystem.IconColor.iconAlternative,
    onClick: () => {
      dispatch((0, _swaps.setTransactionSettingsOpened)(true));
    },
    style: {
      cursor: 'pointer'
    },
    title: t('transactionSettings')
  }))), /*#__PURE__*/_react.default.createElement("div", {
    className: "swaps__content"
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_featureToggledRoute.default, {
    redirectRoute: _routes.SWAPS_MAINTENANCE_ROUTE,
    flag: swapsEnabled,
    path: _routes.PREPARE_SWAP_ROUTE,
    exact: true,
    render: () => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: {
        pathname: `${_routes.CROSS_CHAIN_SWAP_ROUTE}${_routes.PREPARE_SWAP_ROUTE}`
      }
    })
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Route, {
    path: _routes.SWAPS_ERROR_ROUTE,
    exact: true,
    render: () => {
      if (swapsErrorKey) {
        return /*#__PURE__*/_react.default.createElement(_awaitingSwap.default, {
          swapComplete: false,
          errorKey: swapsErrorKey,
          txHash: tradeTxData === null || tradeTxData === void 0 ? void 0 : tradeTxData.hash,
          txId: tradeTxData === null || tradeTxData === void 0 ? void 0 : tradeTxData.id,
          submittedTime: tradeTxData === null || tradeTxData === void 0 ? void 0 : tradeTxData.submittedTime
        });
      }
      return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
        to: {
          pathname: _routes.PREPARE_SWAP_ROUTE
        }
      });
    }
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Route, {
    path: _routes.SWAPS_NOTIFICATION_ROUTE,
    exact: true,
    render: () => {
      if (!swapsErrorKey) {
        return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
          to: {
            pathname: _routes.PREPARE_SWAP_ROUTE
          }
        });
      }
      return /*#__PURE__*/_react.default.createElement(_notificationPage.default, {
        notificationKey: swapsErrorKey
      });
    }
  }), /*#__PURE__*/_react.default.createElement(_featureToggledRoute.default, {
    redirectRoute: _routes.SWAPS_MAINTENANCE_ROUTE,
    flag: swapsEnabled,
    path: _routes.LOADING_QUOTES_ROUTE,
    exact: true,
    render: () => {
      return aggregatorMetadata ? /*#__PURE__*/_react.default.createElement(_loadingSwapsQuotes.default, {
        loadingComplete: !fetchingQuotes && Boolean(Object.values(quotes).length),
        onDone: async () => {
          await dispatch((0, _actions.setBackgroundSwapRouteState)(''));
          if (swapsErrorKey === _swaps2.ERROR_FETCHING_QUOTES || swapsErrorKey === _swaps2.QUOTES_NOT_AVAILABLE_ERROR) {
            dispatch((0, _actions.setSwapsErrorKey)(_swaps2.QUOTES_NOT_AVAILABLE_ERROR));
            history.push(_routes.SWAPS_ERROR_ROUTE);
          } else {
            history.push(_routes.PREPARE_SWAP_ROUTE);
          }
        },
        aggregatorMetadata: aggregatorMetadata
      }) : /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
        to: {
          pathname: _routes.PREPARE_SWAP_ROUTE
        }
      });
    }
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Route, {
    path: _routes.SWAPS_MAINTENANCE_ROUTE,
    exact: true,
    render: () => {
      return swapsEnabled === false ? /*#__PURE__*/_react.default.createElement(_awaitingSwap.default, {
        errorKey: _swaps2.OFFLINE_FOR_MAINTENANCE
      }) : /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
        to: {
          pathname: _routes.PREPARE_SWAP_ROUTE
        }
      });
    }
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Route, {
    path: _routes.AWAITING_SIGNATURES_ROUTE,
    exact: true,
    render: () => {
      return /*#__PURE__*/_react.default.createElement(_awaitingSignatures.default, null);
    }
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Route, {
    path: _routes.SMART_TRANSACTION_STATUS_ROUTE,
    exact: true,
    render: () => {
      return /*#__PURE__*/_react.default.createElement(_smartTransactionStatus.default, {
        txId: tradeTxData === null || tradeTxData === void 0 ? void 0 : tradeTxData.id
      });
    }
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Route, {
    path: _routes.AWAITING_SWAP_ROUTE,
    exact: true,
    render: () => {
      return routeState === 'awaiting' || tradeTxData ? /*#__PURE__*/_react.default.createElement(_awaitingSwap.default, {
        swapComplete: tradeConfirmed,
        txHash: tradeTxData === null || tradeTxData === void 0 ? void 0 : tradeTxData.hash,
        tokensReceived: tokensReceived,
        txId: tradeTxData === null || tradeTxData === void 0 ? void 0 : tradeTxData.id,
        submittingSwap: routeState === 'awaiting' && !(approveTxId || tradeTxId)
      }) : /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
        to: {
          pathname: _routes.DEFAULT_ROUTE
        }
      });
    }
  })))));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\swaps\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\loading-swaps-quotes\\background-animation.js", {"react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cswaps%5Cloading-swaps-quotes%5Cbackground-animation.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = BackgroundAnimation;
var _react = _interopRequireDefault(require("react"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/* eslint-disable @metamask/design-tokens/color-no-hex*/

function BackgroundAnimation() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "loading-swaps-quotes__background-1",
    "data-testid": "loading-swaps-quotes-background-1"
  }, /*#__PURE__*/_react.default.createElement("svg", {
    width: "193",
    height: "190",
    viewBox: "0 0 193 190",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "M153.753 53.876C153.595 53.9493 153.419 54.0161 153.25 54.0651C151.081 54.7451 148.777 53.538 148.086 51.3768C147.763 50.3298 147.851 49.2109 148.361 48.2363C148.87 47.2618 149.732 46.5374 150.78 46.2144C151.828 45.8913 152.948 45.9781 153.923 46.4865C154.898 46.9949 155.622 47.8557 155.944 48.9027C156.567 50.918 155.592 53.0243 153.753 53.876ZM150.817 47.5708C150.245 47.8359 149.782 48.2721 149.495 48.8334C149.144 49.5127 149.073 50.2843 149.303 51.0047C149.774 52.4998 151.375 53.3384 152.877 52.8787C154.374 52.4069 155.215 50.8063 154.756 49.3056C154.526 48.5852 154.027 47.9888 153.36 47.6334C152.68 47.2836 151.908 47.213 151.187 47.4437C151.049 47.4636 150.927 47.52 150.817 47.5708Z",
    fill: "#86E29B"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M18.3624 73.9241C18.3015 73.9523 18.2407 73.9805 18.1798 74.0087C17.0495 74.4733 15.8073 74.4728 14.6751 74.0078C12.3517 73.0461 11.2387 70.3567 12.2031 68.0341C13.1676 65.7115 15.8598 64.5971 18.1833 65.5589C19.3155 66.0239 20.1951 66.9013 20.6591 68.0304C21.123 69.1595 21.1215 70.4008 20.6552 71.5326C20.2207 72.6053 19.4093 73.4391 18.3624 73.9241ZM15.0433 66.7921C14.3129 67.1305 13.713 67.7186 13.3766 68.5243C12.6776 70.207 13.4834 72.1377 15.1666 72.8348C15.9849 73.1647 16.8786 73.1789 17.6933 72.831C18.5136 72.4952 19.1388 71.8659 19.4818 71.0424C19.8126 70.2245 19.8276 69.3313 19.4801 68.5175C19.1448 67.6981 18.5155 67.0739 17.6917 66.7319C16.8144 66.3703 15.8589 66.4142 15.0433 66.7921Z",
    fill: "#FFB0EB"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M116.617 37.3839C117.397 37.0226 117.736 36.0982 117.375 35.3192C117.015 34.5402 116.09 34.2016 115.31 34.5629C114.53 34.9243 114.19 35.8487 114.551 36.6277C114.912 37.4067 115.837 37.7453 116.617 37.3839Z",
    fill: "url(#paint0_linear)"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M55.1317 91.7213C55.9116 91.36 56.2512 90.4356 55.8903 89.6566C55.5294 88.8776 54.6046 88.539 53.8247 88.9003C53.0448 89.2617 52.7052 90.1861 53.0661 90.9651C53.427 91.7441 54.3518 92.0827 55.1317 91.7213Z",
    fill: "url(#paint1_linear)"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M31.9932 126.235C32.7731 125.874 33.1127 124.95 32.7518 124.171C32.3909 123.392 31.4661 123.053 30.6863 123.414C29.9064 123.776 29.5667 124.7 29.9277 125.479C30.2886 126.258 31.2134 126.597 31.9932 126.235Z",
    fill: "url(#paint2_linear)"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M119.43 132.589C120.21 132.228 120.55 131.304 120.189 130.525C119.828 129.746 118.903 129.407 118.123 129.768C117.344 130.13 117.004 131.054 117.365 131.833C117.726 132.612 118.651 132.951 119.43 132.589Z",
    fill: "url(#paint3_linear)"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M44.7469 47.3835C46.0108 46.7979 46.5612 45.2997 45.9763 44.0372C45.3914 42.7747 43.8926 42.2259 42.6286 42.8115C41.3647 43.3971 40.8143 44.8953 41.3992 46.1578C41.9841 47.4203 43.4829 47.9691 44.7469 47.3835Z",
    fill: "url(#paint4_linear)"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M105.107 90.7857C106.371 90.2001 106.922 88.702 106.337 87.4394C105.752 86.1769 104.253 85.6282 102.989 86.2137C101.725 86.7993 101.175 88.2975 101.76 89.56C102.344 90.8226 103.843 91.3713 105.107 90.7857Z",
    fill: "url(#paint5_linear)"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M95.5179 172.376C96.7818 171.791 97.3322 170.293 96.7473 169.03C96.1624 167.767 94.6636 167.219 93.3996 167.804C92.1357 168.39 91.5853 169.888 92.1702 171.151C92.7551 172.413 94.2539 172.962 95.5179 172.376Z",
    fill: "url(#paint6_linear)"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M165.098 102.367C166.362 101.781 166.912 100.283 166.327 99.0205C165.742 97.758 164.244 97.2092 162.98 97.7948C161.716 98.3804 161.165 99.8786 161.75 101.141C162.335 102.404 163.834 102.952 165.098 102.367Z",
    fill: "url(#paint7_linear)"
  }), /*#__PURE__*/_react.default.createElement("defs", null, /*#__PURE__*/_react.default.createElement("linearGradient", {
    id: "paint0_linear",
    x1: "114.554",
    y1: "36.6326",
    x2: "117.379",
    y2: "35.3237",
    gradientUnits: "userSpaceOnUse"
  }, /*#__PURE__*/_react.default.createElement("stop", {
    stopColor: "#75C3FC"
  }), /*#__PURE__*/_react.default.createElement("stop", {
    offset: "1",
    stopColor: "#75C3FC"
  })), /*#__PURE__*/_react.default.createElement("linearGradient", {
    id: "paint1_linear",
    x1: "53.0688",
    y1: "90.97",
    x2: "55.8937",
    y2: "89.6611",
    gradientUnits: "userSpaceOnUse"
  }, /*#__PURE__*/_react.default.createElement("stop", {
    stopColor: "#75C3FC"
  }), /*#__PURE__*/_react.default.createElement("stop", {
    offset: "1",
    stopColor: "#75C3FC"
  })), /*#__PURE__*/_react.default.createElement("linearGradient", {
    id: "paint2_linear",
    x1: "29.9283",
    y1: "125.483",
    x2: "32.7532",
    y2: "124.174",
    gradientUnits: "userSpaceOnUse"
  }, /*#__PURE__*/_react.default.createElement("stop", {
    stopColor: "#75C3FC"
  }), /*#__PURE__*/_react.default.createElement("stop", {
    offset: "1",
    stopColor: "#75C3FC"
  })), /*#__PURE__*/_react.default.createElement("linearGradient", {
    id: "paint3_linear",
    x1: "117.365",
    y1: "131.837",
    x2: "120.19",
    y2: "130.528",
    gradientUnits: "userSpaceOnUse"
  }, /*#__PURE__*/_react.default.createElement("stop", {
    stopColor: "#75C3FC"
  }), /*#__PURE__*/_react.default.createElement("stop", {
    offset: "1",
    stopColor: "#75C3FC"
  })), /*#__PURE__*/_react.default.createElement("linearGradient", {
    id: "paint4_linear",
    x1: "41.4394",
    y1: "46.2402",
    x2: "45.947",
    y2: "43.9537",
    gradientUnits: "userSpaceOnUse"
  }, /*#__PURE__*/_react.default.createElement("stop", {
    stopColor: "#75C3FC"
  }), /*#__PURE__*/_react.default.createElement("stop", {
    offset: "1",
    stopColor: "#75C3FC"
  })), /*#__PURE__*/_react.default.createElement("linearGradient", {
    id: "paint5_linear",
    x1: "101.8",
    y1: "89.6425",
    x2: "106.307",
    y2: "87.356",
    gradientUnits: "userSpaceOnUse"
  }, /*#__PURE__*/_react.default.createElement("stop", {
    stopColor: "#75C3FC"
  }), /*#__PURE__*/_react.default.createElement("stop", {
    offset: "1",
    stopColor: "#75C3FC"
  })), /*#__PURE__*/_react.default.createElement("linearGradient", {
    id: "paint6_linear",
    x1: "92.2104",
    y1: "171.233",
    x2: "96.718",
    y2: "168.947",
    gradientUnits: "userSpaceOnUse"
  }, /*#__PURE__*/_react.default.createElement("stop", {
    stopColor: "#75C3FC"
  }), /*#__PURE__*/_react.default.createElement("stop", {
    offset: "1",
    stopColor: "#75C3FC"
  })), /*#__PURE__*/_react.default.createElement("linearGradient", {
    id: "paint7_linear",
    x1: "161.79",
    y1: "101.224",
    x2: "166.298",
    y2: "98.937",
    gradientUnits: "userSpaceOnUse"
  }, /*#__PURE__*/_react.default.createElement("stop", {
    stopColor: "#75C3FC"
  }), /*#__PURE__*/_react.default.createElement("stop", {
    offset: "1",
    stopColor: "#75C3FC"
  }))))), /*#__PURE__*/_react.default.createElement("div", {
    className: "loading-swaps-quotes__background-2",
    "data-testid": "loading-swaps-quotes-background-2"
  }, /*#__PURE__*/_react.default.createElement("svg", {
    width: "195",
    height: "205",
    viewBox: "0 0 195 205",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "M29.84 121.982C30.0408 121.969 30.245 122.01 30.4258 122.106L46.4233 130.275C46.8125 130.478 47.0536 130.893 47.0402 131.324C47.0143 131.768 46.7423 132.148 46.3356 132.308L24.5484 140.937C24.1417 141.097 23.6789 141.005 23.3642 140.702C23.0495 140.4 22.9398 139.937 23.0753 139.525L28.8651 122.727C28.9671 122.426 29.2065 122.169 29.5086 122.056C29.614 122.023 29.7194 121.989 29.84 121.982ZM43.1981 131.148L30.5607 124.689L25.9884 137.96L43.1981 131.148Z",
    fill: "#75C4FD"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M168.214 54.3381C168.442 54.3238 168.674 54.3764 168.869 54.485C169.217 54.6781 169.44 55.0266 169.465 55.4145L170.59 68.4358C170.631 68.8763 170.416 69.3061 170.041 69.5444C169.666 69.7827 169.182 69.7862 168.805 69.5681L156.14 62.2246C155.763 62.0065 155.535 61.5911 155.548 61.1472C155.56 60.7033 155.818 60.3112 156.209 60.1122L167.75 54.4343C167.908 54.3841 168.067 54.3473 168.214 54.3381ZM168.027 66.3674L167.248 57.3661L159.267 61.2902L168.027 66.3674Z",
    fill: "#FFB0EB"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M88.6283 16.6885C88.8694 16.6734 89.1154 16.7385 89.3255 16.873L100.21 24.1133C100.561 24.3464 100.762 24.7635 100.708 25.1832C100.653 25.6028 100.381 25.969 99.9864 26.1146L86.3391 31.4276C85.9449 31.5731 85.5106 31.5064 85.1842 31.2314C84.8712 30.9556 84.7239 30.5352 84.8192 30.1264L87.5815 17.5731C87.666 17.2053 87.9162 16.9076 88.2702 16.7646C88.3882 16.7169 88.5078 16.696 88.6283 16.6885ZM97.1342 24.7894L89.4471 19.6718L87.5021 28.5349L97.1342 24.7894Z",
    fill: "url(#paint0_linear)"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M117.145 183.156C116.944 183.289 116.698 183.356 116.449 183.344L103.402 182.517C102.982 182.49 102.6 182.229 102.437 181.839C102.274 181.448 102.327 180.995 102.596 180.671L111.758 169.247C112.027 168.923 112.436 168.764 112.856 168.839C113.265 168.921 113.603 169.212 113.725 169.614L117.609 181.866C117.72 182.227 117.652 182.61 117.417 182.911C117.339 183.011 117.246 183.089 117.145 183.156ZM105.728 180.393L114.944 180.981L112.197 172.333L105.728 180.393Z",
    fill: "url(#paint1_linear)"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M38.0816 74.0208C38.1217 74.0183 38.1485 74.0166 38.1887 74.0141C42.3831 73.805 45.9744 77.0577 46.1831 81.2474C46.3919 85.4371 43.1484 89.0241 38.9407 89.234C34.7463 89.4431 31.1549 86.1904 30.9462 82.0007C30.7391 77.8377 33.9307 74.2809 38.0816 74.0208ZM38.9104 87.2486C41.9767 87.0565 44.3523 84.4236 44.1997 81.3448C44.0455 78.2393 41.3949 75.8407 38.2859 75.9952C35.1761 76.1364 32.7753 78.7977 32.9296 81.9033C33.0838 85.0088 35.7344 87.4073 38.8434 87.2528C38.8568 87.252 38.8836 87.2503 38.9104 87.2486Z",
    fill: "#86E29B"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M162.178 97.8401C162.218 97.8376 162.245 97.8359 162.285 97.8334C166.48 97.6243 170.071 100.877 170.28 105.067C170.489 109.256 167.245 112.843 163.037 113.053C158.843 113.262 155.252 110.01 155.043 105.82C154.836 101.657 158.027 98.1002 162.178 97.8401ZM163.007 111.068C166.073 110.876 168.449 108.243 168.296 105.164C168.142 102.059 165.492 99.6601 162.383 99.8146C159.273 99.9557 156.872 102.617 157.026 105.723C157.181 108.828 159.831 111.227 162.94 111.072C162.953 111.071 162.98 111.07 163.007 111.068Z",
    fill: "#86E29B"
  }), /*#__PURE__*/_react.default.createElement("defs", null, /*#__PURE__*/_react.default.createElement("linearGradient", {
    id: "paint0_linear",
    x1: "100.609",
    y1: "23.2611",
    x2: "84.4152",
    y2: "24.2757",
    gradientUnits: "userSpaceOnUse"
  }, /*#__PURE__*/_react.default.createElement("stop", {
    stopColor: "#FFE466"
  }), /*#__PURE__*/_react.default.createElement("stop", {
    offset: "1",
    stopColor: "#FFAFEA"
  })), /*#__PURE__*/_react.default.createElement("linearGradient", {
    id: "paint1_linear",
    x1: "103.812",
    y1: "183.939",
    x2: "116.959",
    y2: "174.66",
    gradientUnits: "userSpaceOnUse"
  }, /*#__PURE__*/_react.default.createElement("stop", {
    stopColor: "#75C3FC"
  }), /*#__PURE__*/_react.default.createElement("stop", {
    offset: "0.0928503",
    stopColor: "#81C2F6"
  }), /*#__PURE__*/_react.default.createElement("stop", {
    offset: "1",
    stopColor: "#F0B8BD"
  }))))));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\swaps\\loading-swaps-quotes\\background-animation.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\loading-swaps-quotes\\index.js", {"./loading-swaps-quotes":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\loading-swaps-quotes\\loading-swaps-quotes.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cswaps%5Cloading-swaps-quotes%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _loadingSwapsQuotes.default;
  }
});
var _loadingSwapsQuotes = _interopRequireDefault(require("./loading-swaps-quotes"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\swaps\\loading-swaps-quotes\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\loading-swaps-quotes\\loading-swaps-quotes.js", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/modules/selectors":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\index.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/ui/mascot":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\mascot\\index.js","../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../ducks/swaps/swaps":"D:\\code\\v\\metamask-extension\\ui\\ducks\\swaps\\swaps.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/build-types":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\build-types.js","../../../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","../swaps-footer":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\swaps-footer\\index.js","./background-animation":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\loading-swaps-quotes\\background-animation.js","events":"D:\\code\\v\\metamask-extension\\node_modules\\events\\events.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","lodash/isEqual":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\isEqual.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cswaps%5Cloading-swaps-quotes%5Cloading-swaps-quotes.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = LoadingSwapsQuotes;
var _events = _interopRequireDefault(require("events"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _lodash = require("lodash");
var _reactRouterDom = require("react-router-dom");
var _isEqual = _interopRequireDefault(require("lodash/isEqual"));
var _swaps = require("../../../ducks/swaps/swaps");
var _selectors = require("../../../selectors/selectors");
var _selectors2 = require("../../../../shared/modules/selectors");
var _i18n = require("../../../contexts/i18n");
var _metametrics = require("../../../contexts/metametrics");
var _mascot = _interopRequireDefault(require("../../../components/ui/mascot"));
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _swapsFooter = _interopRequireDefault(require("../swaps-footer"));
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _buildTypes = require("../../../helpers/utils/build-types");
var _backgroundAnimation = _interopRequireDefault(require("./background-animation"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function LoadingSwapsQuotes({
  aggregatorMetadata,
  loadingComplete,
  onDone
}) {
  var _fetchParams$sourceTo, _fetchParams$destinat;
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const dispatch = (0, _reactRedux.useDispatch)();
  const hdEntropyIndex = (0, _reactRedux.useSelector)(_selectors.getHDEntropyIndex);
  const history = (0, _reactRouterDom.useHistory)();
  const animationEventEmitter = (0, _react.useRef)(new _events.default());
  const fetchParams = (0, _reactRedux.useSelector)(_swaps.getFetchParams, _isEqual.default);
  const quotesFetchStartTime = (0, _reactRedux.useSelector)(_swaps.getQuotesFetchStartTime);
  const hardwareWalletUsed = (0, _reactRedux.useSelector)(_selectors.isHardwareWallet);
  const hardwareWalletType = (0, _reactRedux.useSelector)(_selectors.getHardwareWalletType);
  const smartTransactionsOptInStatus = (0, _reactRedux.useSelector)(_selectors2.getSmartTransactionsOptInStatusForMetrics);
  const smartTransactionsEnabled = (0, _reactRedux.useSelector)(_selectors2.getSmartTransactionsEnabled);
  const currentSmartTransactionsEnabled = (0, _reactRedux.useSelector)(_swaps.getCurrentSmartTransactionsEnabled);
  const quotesRequestCancelledEventConfig = {
    event: 'Quotes Request Cancelled',
    category: _metametrics2.MetaMetricsEventCategory.Swaps,
    sensitiveProperties: {
      token_from: fetchParams === null || fetchParams === void 0 || (_fetchParams$sourceTo = fetchParams.sourceTokenInfo) === null || _fetchParams$sourceTo === void 0 ? void 0 : _fetchParams$sourceTo.symbol,
      token_from_amount: fetchParams === null || fetchParams === void 0 ? void 0 : fetchParams.value,
      request_type: fetchParams === null || fetchParams === void 0 ? void 0 : fetchParams.balanceError,
      token_to: fetchParams === null || fetchParams === void 0 || (_fetchParams$destinat = fetchParams.destinationTokenInfo) === null || _fetchParams$destinat === void 0 ? void 0 : _fetchParams$destinat.symbol,
      slippage: fetchParams === null || fetchParams === void 0 ? void 0 : fetchParams.slippage,
      custom_slippage: (fetchParams === null || fetchParams === void 0 ? void 0 : fetchParams.slippage) !== 2,
      response_time: Date.now() - quotesFetchStartTime,
      is_hardware_wallet: hardwareWalletUsed,
      hardware_wallet_type: hardwareWalletType,
      stx_enabled: smartTransactionsEnabled,
      current_stx_enabled: currentSmartTransactionsEnabled,
      stx_user_opt_in: smartTransactionsOptInStatus
    },
    properties: {
      hd_entropy_index: hdEntropyIndex
    }
  };
  const [aggregatorNames] = (0, _react.useState)(() => (0, _lodash.shuffle)(Object.keys(aggregatorMetadata)));
  const numberOfQuotes = aggregatorNames.length;
  const mascotContainer = (0, _react.useRef)();
  const currentMascotContainer = mascotContainer.current;
  const [quoteCount, updateQuoteCount] = (0, _react.useState)(0);
  const [midPointTarget, setMidpointTarget] = (0, _react.useState)(null);
  const renderMascot = () => {
    if ((0, _buildTypes.isFlask)()) {
      return /*#__PURE__*/_react.default.createElement("img", {
        src: "./images/logo/metamask-fox.svg",
        width: "90",
        height: "90"
      });
    }
    if ((0, _buildTypes.isBeta)()) {
      return /*#__PURE__*/_react.default.createElement("img", {
        src: "./images/logo/metamask-fox.svg",
        width: "90",
        height: "90"
      });
    }
    return /*#__PURE__*/_react.default.createElement(_mascot.default, {
      animationEventEmitter: animationEventEmitter.current,
      width: "90",
      height: "90",
      lookAtTarget: midPointTarget
    });
  };
  (0, _react.useEffect)(() => {
    let timeoutLength;

    // The below logic simulates a sequential loading of the aggregator quotes, even though we are fetching them all with a single call.
    // This is to give the user a sense of progress. The callback passed to `setTimeout` updates the quoteCount and therefore causes
    // a new logo to be shown, the fox to look at that logo, the logo bar and aggregator name to update.

    if (loadingComplete) {
      // If loading is complete, but the quoteCount is not, we quickly display the remaining logos/names/fox looks. 0.2s each
      timeoutLength = 20;
    } else {
      // If loading is not complete, we display remaining logos/names/fox looks at random intervals between 0.5s and 2s, to simulate the
      // sort of loading a user would experience in most async scenarios
      timeoutLength = 500 + Math.floor(Math.random() * 1500);
    }
    const quoteCountTimeout = setTimeout(() => {
      if (quoteCount < numberOfQuotes) {
        updateQuoteCount(quoteCount + 1);
      } else if (quoteCount === numberOfQuotes && loadingComplete) {
        onDone();
      }
    }, timeoutLength);
    return function cleanup() {
      clearTimeout(quoteCountTimeout);
    };
  }, [quoteCount, loadingComplete, onDone, numberOfQuotes]);
  (0, _react.useEffect)(() => {
    if (currentMascotContainer) {
      const {
        top,
        left,
        width,
        height
      } = currentMascotContainer.getBoundingClientRect();
      const center = {
        x: left + width / 2,
        y: top + height / 2
      };
      setMidpointTarget(center);
    }
  }, [currentMascotContainer]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "loading-swaps-quotes"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "loading-swaps-quotes__content"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyXs,
    "data-testid": "loading-swaps-quotes-quote-counter",
    color: _designSystem.TextColor.textAlternative,
    marginTop: 1,
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center,
    width: _designSystem.BlockSize.Full,
    marginBottom: 1
  }, /*#__PURE__*/_react.default.createElement("span", null, t('swapFetchingQuoteNofN', [Math.min(quoteCount + 1, numberOfQuotes), numberOfQuotes]))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingSm,
    "data-testid": "loading-swaps-quotes-quote-name-check",
    color: _designSystem.TextColor.textDefault,
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center,
    width: _designSystem.BlockSize.Full,
    textTransform: _designSystem.TextTransform.Capitalize
  }, /*#__PURE__*/_react.default.createElement("span", null, t('swapFetchingQuotes'))), /*#__PURE__*/_react.default.createElement("div", {
    className: "loading-swaps-quotes__loading-bar-container"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "loading-swaps-quotes__loading-bar",
    style: {
      width: `${100 / numberOfQuotes * quoteCount}%`
    }
  }))), /*#__PURE__*/_react.default.createElement("div", {
    className: "loading-swaps-quotes__animation"
  }, /*#__PURE__*/_react.default.createElement(_backgroundAnimation.default, null), /*#__PURE__*/_react.default.createElement("div", {
    className: "loading-swaps-quotes__mascot-container",
    ref: mascotContainer
  }, renderMascot()))), /*#__PURE__*/_react.default.createElement(_swapsFooter.default, {
    submitText: t('back'),
    onSubmit: async () => {
      trackEvent(quotesRequestCancelledEventConfig);
      await dispatch((0, _swaps.navigateBackToPrepareSwap)(history));
    },
    hideCancel: true
  }));
}
LoadingSwapsQuotes.propTypes = {
  loadingComplete: _propTypes.default.bool.isRequired,
  onDone: _propTypes.default.func.isRequired,
  aggregatorMetadata: _propTypes.default.objectOf(_propTypes.default.shape({
    title: _propTypes.default.string,
    color: _propTypes.default.string,
    icon: _propTypes.default.string
  }))
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\swaps\\loading-swaps-quotes\\loading-swaps-quotes.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\mascot-background-animation\\mascot-background-animation.js", {"../../../components/ui/mascot":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\mascot\\index.js","../../../helpers/utils/build-types":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\build-types.js","events":"D:\\code\\v\\metamask-extension\\node_modules\\events\\events.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cswaps%5Cmascot-background-animation%5Cmascot-background-animation.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = MascotBackgroundAnimation;
var _events = _interopRequireDefault(require("events"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _mascot = _interopRequireDefault(require("../../../components/ui/mascot"));
var _buildTypes = require("../../../helpers/utils/build-types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/* eslint-disable @metamask/design-tokens/color-no-hex*/

function MascotBackgroundAnimation({
  height,
  width
}) {
  const animationEventEmitter = (0, _react.useRef)(new _events.default());
  const renderMascot = () => {
    if ((0, _buildTypes.isFlask)()) {
      return /*#__PURE__*/_react.default.createElement("img", {
        src: "./images/logo/metamask-fox.svg",
        width: width ?? '42',
        height: height ?? '42'
      });
    }
    if ((0, _buildTypes.isBeta)()) {
      return /*#__PURE__*/_react.default.createElement("img", {
        src: "./images/logo/metamask-fox.svg",
        width: width ?? '42',
        height: height ?? '42'
      });
    }
    return /*#__PURE__*/_react.default.createElement(_mascot.default, {
      animationEventEmitter: animationEventEmitter.current,
      width: width ?? '42',
      height: height ?? '42',
      followMouse: false
    });
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "mascot-background-animation__animation"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "mascot-background-animation__background-1",
    "data-testid": "mascot-background-animation-background-1"
  }, /*#__PURE__*/_react.default.createElement("svg", {
    width: "193",
    height: "190",
    viewBox: "0 0 193 190",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "M153.753 53.876C153.595 53.9493 153.419 54.0161 153.25 54.0651C151.081 54.7451 148.777 53.538 148.086 51.3768C147.763 50.3298 147.851 49.2109 148.361 48.2363C148.87 47.2618 149.732 46.5374 150.78 46.2144C151.828 45.8913 152.948 45.9781 153.923 46.4865C154.898 46.9949 155.622 47.8557 155.944 48.9027C156.567 50.918 155.592 53.0243 153.753 53.876ZM150.817 47.5708C150.245 47.8359 149.782 48.2721 149.495 48.8334C149.144 49.5127 149.073 50.2843 149.303 51.0047C149.774 52.4998 151.375 53.3384 152.877 52.8787C154.374 52.4069 155.215 50.8063 154.756 49.3056C154.526 48.5852 154.027 47.9888 153.36 47.6334C152.68 47.2836 151.908 47.213 151.187 47.4437C151.049 47.4636 150.927 47.52 150.817 47.5708Z",
    fill: "#86E29B"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M18.3624 73.9241C18.3015 73.9523 18.2407 73.9805 18.1798 74.0087C17.0495 74.4733 15.8073 74.4728 14.6751 74.0078C12.3517 73.0461 11.2387 70.3567 12.2031 68.0341C13.1676 65.7115 15.8598 64.5971 18.1833 65.5589C19.3155 66.0239 20.1951 66.9013 20.6591 68.0304C21.123 69.1595 21.1215 70.4008 20.6552 71.5326C20.2207 72.6053 19.4093 73.4391 18.3624 73.9241ZM15.0433 66.7921C14.3129 67.1305 13.713 67.7186 13.3766 68.5243C12.6776 70.207 13.4834 72.1377 15.1666 72.8348C15.9849 73.1647 16.8786 73.1789 17.6933 72.831C18.5136 72.4952 19.1388 71.8659 19.4818 71.0424C19.8126 70.2245 19.8276 69.3313 19.4801 68.5175C19.1448 67.6981 18.5155 67.0739 17.6917 66.7319C16.8144 66.3703 15.8589 66.4142 15.0433 66.7921Z",
    fill: "#FFB0EB"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M116.617 37.3839C117.397 37.0226 117.736 36.0982 117.375 35.3192C117.015 34.5402 116.09 34.2016 115.31 34.5629C114.53 34.9243 114.19 35.8487 114.551 36.6277C114.912 37.4067 115.837 37.7453 116.617 37.3839Z",
    fill: "url(#paint0_linear)"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M55.1317 91.7213C55.9116 91.36 56.2512 90.4356 55.8903 89.6566C55.5294 88.8776 54.6046 88.539 53.8247 88.9003C53.0448 89.2617 52.7052 90.1861 53.0661 90.9651C53.427 91.7441 54.3518 92.0827 55.1317 91.7213Z",
    fill: "url(#paint1_linear)"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M31.9932 126.235C32.7731 125.874 33.1127 124.95 32.7518 124.171C32.3909 123.392 31.4661 123.053 30.6863 123.414C29.9064 123.776 29.5667 124.7 29.9277 125.479C30.2886 126.258 31.2134 126.597 31.9932 126.235Z",
    fill: "url(#paint2_linear)"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M119.43 132.589C120.21 132.228 120.55 131.304 120.189 130.525C119.828 129.746 118.903 129.407 118.123 129.768C117.344 130.13 117.004 131.054 117.365 131.833C117.726 132.612 118.651 132.951 119.43 132.589Z",
    fill: "url(#paint3_linear)"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M44.7469 47.3835C46.0108 46.7979 46.5612 45.2997 45.9763 44.0372C45.3914 42.7747 43.8926 42.2259 42.6286 42.8115C41.3647 43.3971 40.8143 44.8953 41.3992 46.1578C41.9841 47.4203 43.4829 47.9691 44.7469 47.3835Z",
    fill: "url(#paint4_linear)"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M105.107 90.7857C106.371 90.2001 106.922 88.702 106.337 87.4394C105.752 86.1769 104.253 85.6282 102.989 86.2137C101.725 86.7993 101.175 88.2975 101.76 89.56C102.344 90.8226 103.843 91.3713 105.107 90.7857Z",
    fill: "url(#paint5_linear)"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M95.5179 172.376C96.7818 171.791 97.3322 170.293 96.7473 169.03C96.1624 167.767 94.6636 167.219 93.3996 167.804C92.1357 168.39 91.5853 169.888 92.1702 171.151C92.7551 172.413 94.2539 172.962 95.5179 172.376Z",
    fill: "url(#paint6_linear)"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M165.098 102.367C166.362 101.781 166.912 100.283 166.327 99.0205C165.742 97.758 164.244 97.2092 162.98 97.7948C161.716 98.3804 161.165 99.8786 161.75 101.141C162.335 102.404 163.834 102.952 165.098 102.367Z",
    fill: "url(#paint7_linear)"
  }), /*#__PURE__*/_react.default.createElement("defs", null, /*#__PURE__*/_react.default.createElement("linearGradient", {
    id: "paint0_linear",
    x1: "114.554",
    y1: "36.6326",
    x2: "117.379",
    y2: "35.3237",
    gradientUnits: "userSpaceOnUse"
  }, /*#__PURE__*/_react.default.createElement("stop", {
    stopColor: "#75C3FC"
  }), /*#__PURE__*/_react.default.createElement("stop", {
    offset: "1",
    stopColor: "#75C3FC"
  })), /*#__PURE__*/_react.default.createElement("linearGradient", {
    id: "paint1_linear",
    x1: "53.0688",
    y1: "90.97",
    x2: "55.8937",
    y2: "89.6611",
    gradientUnits: "userSpaceOnUse"
  }, /*#__PURE__*/_react.default.createElement("stop", {
    stopColor: "#75C3FC"
  }), /*#__PURE__*/_react.default.createElement("stop", {
    offset: "1",
    stopColor: "#75C3FC"
  })), /*#__PURE__*/_react.default.createElement("linearGradient", {
    id: "paint2_linear",
    x1: "29.9283",
    y1: "125.483",
    x2: "32.7532",
    y2: "124.174",
    gradientUnits: "userSpaceOnUse"
  }, /*#__PURE__*/_react.default.createElement("stop", {
    stopColor: "#75C3FC"
  }), /*#__PURE__*/_react.default.createElement("stop", {
    offset: "1",
    stopColor: "#75C3FC"
  })), /*#__PURE__*/_react.default.createElement("linearGradient", {
    id: "paint3_linear",
    x1: "117.365",
    y1: "131.837",
    x2: "120.19",
    y2: "130.528",
    gradientUnits: "userSpaceOnUse"
  }, /*#__PURE__*/_react.default.createElement("stop", {
    stopColor: "#75C3FC"
  }), /*#__PURE__*/_react.default.createElement("stop", {
    offset: "1",
    stopColor: "#75C3FC"
  })), /*#__PURE__*/_react.default.createElement("linearGradient", {
    id: "paint4_linear",
    x1: "41.4394",
    y1: "46.2402",
    x2: "45.947",
    y2: "43.9537",
    gradientUnits: "userSpaceOnUse"
  }, /*#__PURE__*/_react.default.createElement("stop", {
    stopColor: "#75C3FC"
  }), /*#__PURE__*/_react.default.createElement("stop", {
    offset: "1",
    stopColor: "#75C3FC"
  })), /*#__PURE__*/_react.default.createElement("linearGradient", {
    id: "paint5_linear",
    x1: "101.8",
    y1: "89.6425",
    x2: "106.307",
    y2: "87.356",
    gradientUnits: "userSpaceOnUse"
  }, /*#__PURE__*/_react.default.createElement("stop", {
    stopColor: "#75C3FC"
  }), /*#__PURE__*/_react.default.createElement("stop", {
    offset: "1",
    stopColor: "#75C3FC"
  })), /*#__PURE__*/_react.default.createElement("linearGradient", {
    id: "paint6_linear",
    x1: "92.2104",
    y1: "171.233",
    x2: "96.718",
    y2: "168.947",
    gradientUnits: "userSpaceOnUse"
  }, /*#__PURE__*/_react.default.createElement("stop", {
    stopColor: "#75C3FC"
  }), /*#__PURE__*/_react.default.createElement("stop", {
    offset: "1",
    stopColor: "#75C3FC"
  })), /*#__PURE__*/_react.default.createElement("linearGradient", {
    id: "paint7_linear",
    x1: "161.79",
    y1: "101.224",
    x2: "166.298",
    y2: "98.937",
    gradientUnits: "userSpaceOnUse"
  }, /*#__PURE__*/_react.default.createElement("stop", {
    stopColor: "#75C3FC"
  }), /*#__PURE__*/_react.default.createElement("stop", {
    offset: "1",
    stopColor: "#75C3FC"
  }))))), /*#__PURE__*/_react.default.createElement("div", {
    className: "mascot-background-animation__background-2",
    "data-testid": "mascot-background-animation-background-2"
  }, /*#__PURE__*/_react.default.createElement("svg", {
    width: "195",
    height: "205",
    viewBox: "0 0 195 205",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "M29.84 121.982C30.0408 121.969 30.245 122.01 30.4258 122.106L46.4233 130.275C46.8125 130.478 47.0536 130.893 47.0402 131.324C47.0143 131.768 46.7423 132.148 46.3356 132.308L24.5484 140.937C24.1417 141.097 23.6789 141.005 23.3642 140.702C23.0495 140.4 22.9398 139.937 23.0753 139.525L28.8651 122.727C28.9671 122.426 29.2065 122.169 29.5086 122.056C29.614 122.023 29.7194 121.989 29.84 121.982ZM43.1981 131.148L30.5607 124.689L25.9884 137.96L43.1981 131.148Z",
    fill: "#75C4FD"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M168.214 54.3381C168.442 54.3238 168.674 54.3764 168.869 54.485C169.217 54.6781 169.44 55.0266 169.465 55.4145L170.59 68.4358C170.631 68.8763 170.416 69.3061 170.041 69.5444C169.666 69.7827 169.182 69.7862 168.805 69.5681L156.14 62.2246C155.763 62.0065 155.535 61.5911 155.548 61.1472C155.56 60.7033 155.818 60.3112 156.209 60.1122L167.75 54.4343C167.908 54.3841 168.067 54.3473 168.214 54.3381ZM168.027 66.3674L167.248 57.3661L159.267 61.2902L168.027 66.3674Z",
    fill: "#FFB0EB"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M88.6283 16.6885C88.8694 16.6734 89.1154 16.7385 89.3255 16.873L100.21 24.1133C100.561 24.3464 100.762 24.7635 100.708 25.1832C100.653 25.6028 100.381 25.969 99.9864 26.1146L86.3391 31.4276C85.9449 31.5731 85.5106 31.5064 85.1842 31.2314C84.8712 30.9556 84.7239 30.5352 84.8192 30.1264L87.5815 17.5731C87.666 17.2053 87.9162 16.9076 88.2702 16.7646C88.3882 16.7169 88.5078 16.696 88.6283 16.6885ZM97.1342 24.7894L89.4471 19.6718L87.5021 28.5349L97.1342 24.7894Z",
    fill: "url(#paint0_linear)"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M117.145 183.156C116.944 183.289 116.698 183.356 116.449 183.344L103.402 182.517C102.982 182.49 102.6 182.229 102.437 181.839C102.274 181.448 102.327 180.995 102.596 180.671L111.758 169.247C112.027 168.923 112.436 168.764 112.856 168.839C113.265 168.921 113.603 169.212 113.725 169.614L117.609 181.866C117.72 182.227 117.652 182.61 117.417 182.911C117.339 183.011 117.246 183.089 117.145 183.156ZM105.728 180.393L114.944 180.981L112.197 172.333L105.728 180.393Z",
    fill: "url(#paint1_linear)"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M38.0816 74.0208C38.1217 74.0183 38.1485 74.0166 38.1887 74.0141C42.3831 73.805 45.9744 77.0577 46.1831 81.2474C46.3919 85.4371 43.1484 89.0241 38.9407 89.234C34.7463 89.4431 31.1549 86.1904 30.9462 82.0007C30.7391 77.8377 33.9307 74.2809 38.0816 74.0208ZM38.9104 87.2486C41.9767 87.0565 44.3523 84.4236 44.1997 81.3448C44.0455 78.2393 41.3949 75.8407 38.2859 75.9952C35.1761 76.1364 32.7753 78.7977 32.9296 81.9033C33.0838 85.0088 35.7344 87.4073 38.8434 87.2528C38.8568 87.252 38.8836 87.2503 38.9104 87.2486Z",
    fill: "#86E29B"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M162.178 97.8401C162.218 97.8376 162.245 97.8359 162.285 97.8334C166.48 97.6243 170.071 100.877 170.28 105.067C170.489 109.256 167.245 112.843 163.037 113.053C158.843 113.262 155.252 110.01 155.043 105.82C154.836 101.657 158.027 98.1002 162.178 97.8401ZM163.007 111.068C166.073 110.876 168.449 108.243 168.296 105.164C168.142 102.059 165.492 99.6601 162.383 99.8146C159.273 99.9557 156.872 102.617 157.026 105.723C157.181 108.828 159.831 111.227 162.94 111.072C162.953 111.071 162.98 111.07 163.007 111.068Z",
    fill: "#86E29B"
  }), /*#__PURE__*/_react.default.createElement("defs", null, /*#__PURE__*/_react.default.createElement("linearGradient", {
    id: "paint0_linear",
    x1: "100.609",
    y1: "23.2611",
    x2: "84.4152",
    y2: "24.2757",
    gradientUnits: "userSpaceOnUse"
  }, /*#__PURE__*/_react.default.createElement("stop", {
    stopColor: "#FFE466"
  }), /*#__PURE__*/_react.default.createElement("stop", {
    offset: "1",
    stopColor: "#FFAFEA"
  })), /*#__PURE__*/_react.default.createElement("linearGradient", {
    id: "paint1_linear",
    x1: "103.812",
    y1: "183.939",
    x2: "116.959",
    y2: "174.66",
    gradientUnits: "userSpaceOnUse"
  }, /*#__PURE__*/_react.default.createElement("stop", {
    stopColor: "#75C3FC"
  }), /*#__PURE__*/_react.default.createElement("stop", {
    offset: "0.0928503",
    stopColor: "#81C2F6"
  }), /*#__PURE__*/_react.default.createElement("stop", {
    offset: "1",
    stopColor: "#F0B8BD"
  }))))), /*#__PURE__*/_react.default.createElement("div", {
    className: "mascot-background-animation__mascot-container",
    "data-testid": "mascot-background-animation-mascot-container"
  }, renderMascot()));
}
MascotBackgroundAnimation.propTypes = {
  height: _propTypes.default.string,
  width: _propTypes.default.string
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\swaps\\mascot-background-animation\\mascot-background-animation.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\notification-page\\notification-page.js", {"../../../../shared/constants/swaps":"D:\\code\\v\\metamask-extension\\shared\\constants\\swaps.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/ui/box":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\box\\index.js","../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../swaps-footer":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\swaps-footer\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cswaps%5Cnotification-page%5Cnotification-page.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = NotificationPage;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18n = require("../../../contexts/i18n");
var _actions = require("../../../store/actions");
var _box = _interopRequireDefault(require("../../../components/ui/box"));
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../../components/component-library");
var _routes = require("../../../helpers/constants/routes");
var _swapsFooter = _interopRequireDefault(require("../swaps-footer"));
var _swaps = require("../../../../shared/constants/swaps");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function NotificationPage({
  notificationKey
}) {
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const history = (0, _reactRouterDom.useHistory)();
  const dispatch = (0, _reactRedux.useDispatch)();

  // TODO: Either add default values or redirect a user out if a notificationKey value is not supported.
  let title = '';
  let description = '';
  let buttonText = '';
  if (notificationKey === _swaps.QUOTES_EXPIRED_ERROR) {
    title = t('swapAreYouStillThere');
    description = t('swapAreYouStillThereDescription');
    buttonText = t('swapShowLatestQuotes');
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "notification-page"
  }, /*#__PURE__*/_react.default.createElement(_box.default, {
    alignItems: _designSystem.AlignItems.center,
    display: _designSystem.DISPLAY.FLEX,
    flexDirection: _designSystem.FLEX_DIRECTION.COLUMN,
    marginTop: 10,
    marginLeft: 4,
    marginRight: 4,
    textAlign: _designSystem.TEXT_ALIGN.CENTER,
    className: "notification-page__content"
  }, /*#__PURE__*/_react.default.createElement(_box.default, {
    marginTop: 8,
    marginBottom: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.Warning,
    color: _designSystem.IconColor.iconMuted,
    className: "notification-page__warning-icon"
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyLgMedium,
    as: "h2"
  }, title), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    as: "h6"
  }, description)), /*#__PURE__*/_react.default.createElement(_swapsFooter.default, {
    onSubmit: async () => {
      await dispatch((0, _actions.setSwapsErrorKey)(''));
      history.push(_routes.PREPARE_SWAP_ROUTE);
    },
    submitText: buttonText,
    hideCancel: true,
    showTermsOfService: true
  }));
}
NotificationPage.propTypes = {
  notificationKey: _propTypes.default.oneOf([_swaps.QUOTES_EXPIRED_ERROR])
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\swaps\\notification-page\\notification-page.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\smart-transaction-status\\arrow-icon.js", {"react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cswaps%5Csmart-transaction-status%5Carrow-icon.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ArrowIcon;
var _react = _interopRequireDefault(require("react"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function ArrowIcon() {
  return /*#__PURE__*/_react.default.createElement("svg", {
    width: "15",
    height: "13",
    viewBox: "0 0 15 13",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "M14.4946 6.14779C14.4863 5.93594 14.3991 5.69108 14.2539 5.53666L9.51334 0.49958C9.1921 0.21091 8.57613 0.0917437 8.21709 0.425509C7.86344 0.754237 7.87396 1.39178 8.22627 1.72181L11.5595 5.25889L1.1618 5.25889C0.670919 5.25889 0.272949 5.65687 0.272949 6.14779C0.272949 6.6387 0.670919 7.03668 1.1618 7.03668L11.5595 7.03668L8.22627 10.5738C7.92297 10.8776 7.86691 11.5376 8.21709 11.8701C8.56718 12.2025 9.20529 12.0963 9.51334 11.796L14.2539 6.75891C14.4161 6.58653 14.4952 6.38428 14.4946 6.14779Z",
    fill: "var(--color-text-muted)"
  }));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\swaps\\smart-transaction-status\\arrow-icon.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\smart-transaction-status\\canceled-icon.js", {"react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cswaps%5Csmart-transaction-status%5Ccanceled-icon.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = CanceledIcon;
var _react = _interopRequireDefault(require("react"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function CanceledIcon() {
  return /*#__PURE__*/_react.default.createElement("svg", {
    width: "41",
    height: "39",
    viewBox: "0 0 41 39",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "M34.5805 6.55143C36.1394 8.11033 37.3994 9.91222 38.3237 11.8681C38.7066 12.6782 39.0318 13.5148 39.2968 14.3714L39.3242 14.4606C39.4816 14.9785 39.6171 15.5037 39.73 16.0347C40.6511 20.3654 40.0335 24.9029 37.9511 28.8509C35.6001 33.308 31.5749 36.6487 26.7609 38.138C24.3773 38.8754 21.8717 39.1361 19.3873 38.9052C16.9029 38.6743 14.4883 37.9563 12.2813 36.7922C10.2608 35.7264 8.52045 34.3588 7.08333 32.7636C5.61245 31.1448 4.43054 29.2824 3.59178 27.2574C3.32329 26.6092 2.89685 25.2767 2.89685 25.2767H6.89583C7.68667 27.4068 8.96033 29.362 10.6288 30.9609L10.6318 30.96C11.5096 31.8005 12.501 32.5516 13.595 33.1786C15.8742 34.483 18.4736 35.1864 21.1455 35.1864C25.1768 35.1864 29.0429 33.585 31.8935 30.7345C34.744 27.8839 36.3455 24.0177 36.3455 19.9865C36.3455 18.7267 36.1891 17.483 35.8871 16.2814C35.8206 16.017 35.7471 15.7546 35.6666 15.4945C34.4752 11.6432 31.8027 8.42306 28.237 6.54231C24.6713 4.66156 20.5045 4.27429 16.6533 5.46571C12.8837 6.63189 9.71868 9.21706 7.82253 12.6699L12.8961 15.307L3.28331 18.3447L0.245605 8.73191L4.45005 10.9171C6.81537 6.56278 10.7905 3.30177 15.5303 1.83546C17.3658 1.26761 19.2587 0.986653 21.1455 0.986694C26.1846 0.986694 31.0173 2.98824 34.5805 6.55143Z",
    fill: "var(--color-primary-default)"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M18.1252 22.1036L14.7107 18.689L12.0926 21.3257L18.1252 27.3584L30.2322 15.2515L27.614 12.6148L18.1252 22.1036Z",
    fill: "var(--color-primary-default)"
  }));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\swaps\\smart-transaction-status\\canceled-icon.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\smart-transaction-status\\index.js", {"./smart-transaction-status":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\smart-transaction-status\\smart-transaction-status.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cswaps%5Csmart-transaction-status%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _smartTransactionStatus.default;
  }
});
var _smartTransactionStatus = _interopRequireDefault(require("./smart-transaction-status"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\swaps\\smart-transaction-status\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\smart-transaction-status\\reverted-icon.js", {"react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cswaps%5Csmart-transaction-status%5Creverted-icon.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = RevertedIcon;
var _react = _interopRequireDefault(require("react"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function RevertedIcon() {
  return /*#__PURE__*/_react.default.createElement("svg", {
    width: "41",
    height: "39",
    viewBox: "0 0 41 39",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "M34.6806 6.55143C36.2395 8.11033 37.4995 9.91222 38.4238 11.8681C38.8067 12.6782 39.1319 13.5148 39.3969 14.3714L39.4243 14.4606C39.5817 14.9785 39.7172 15.5037 39.8301 16.0347C40.7512 20.3654 40.1336 24.9029 38.0512 28.8509C35.7002 33.308 31.675 36.6487 26.861 38.138C24.4773 38.8754 21.9718 39.1361 19.4874 38.9052C17.003 38.6743 14.5884 37.9563 12.3814 36.7922C10.3609 35.7264 8.62055 34.3588 7.18343 32.7636C5.71254 31.1448 4.53064 29.2824 3.69188 27.2574C3.42339 26.6092 2.99695 25.2767 2.99695 25.2767H6.99592C7.78677 27.4068 9.06042 29.362 10.7289 30.9609L10.7319 30.96C11.6097 31.8005 12.6011 32.5516 13.6951 33.1786C15.9743 34.483 18.5737 35.1864 21.2456 35.1864C25.2769 35.1864 29.143 33.585 31.9936 30.7345C34.8441 27.8839 36.4456 24.0177 36.4456 19.9865C36.4456 18.7267 36.2892 17.483 35.9872 16.2814C35.9207 16.017 35.8471 15.7546 35.7667 15.4945C34.5753 11.6432 31.9028 8.42306 28.3371 6.54231C24.7714 4.66156 20.6046 4.27429 16.7534 5.46571C12.9838 6.63189 9.81878 9.21706 7.92263 12.6699L12.9962 15.307L3.3834 18.3447L0.345703 8.73191L4.55015 10.9171C6.91547 6.56278 10.8906 3.30177 15.6304 1.83546C17.4659 1.26761 19.3588 0.986653 21.2456 0.986694C26.2847 0.986694 31.1174 2.98824 34.6806 6.55143Z",
    fill: "var(--color-error-default)"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M18.5849 19.9869L15.1454 23.4264L17.9845 26.2655L21.424 22.826L24.8635 26.2655L27.7026 23.4264L24.2631 19.9869L27.7026 16.5473L24.8635 13.7082L21.424 17.1478L17.9845 13.7082L15.1454 16.5473L18.5849 19.9869Z",
    fill: "var(--color-error-default)"
  }));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\swaps\\smart-transaction-status\\reverted-icon.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\smart-transaction-status\\smart-transaction-status.js", {"../../../../shared/constants/common":"D:\\code\\v\\metamask-extension\\shared\\constants\\common.ts","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../../shared/lib/transactions-controller-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\transactions-controller-utils.js","../../../../shared/modules/selectors":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\index.ts","../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../components/ui/box":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\box\\index.js","../../../components/ui/url-icon":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\url-icon\\index.js","../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../ducks/swaps/swaps":"D:\\code\\v\\metamask-extension\\ui\\ducks\\swaps\\swaps.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../create-new-swap":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\create-new-swap\\index.js","../swaps-footer":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\swaps-footer\\index.js","../swaps.util":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\swaps.util.ts","../view-on-block-explorer":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\view-on-block-explorer\\index.js","./arrow-icon":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\smart-transaction-status\\arrow-icon.js","./canceled-icon":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\smart-transaction-status\\canceled-icon.js","./reverted-icon":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\smart-transaction-status\\reverted-icon.js","./success-icon":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\smart-transaction-status\\success-icon.js","./timer-icon":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\smart-transaction-status\\timer-icon.js","./unknown-icon":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\smart-transaction-status\\unknown-icon.js","@metamask/etherscan-link":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\etherscan-link\\dist\\index.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cswaps%5Csmart-transaction-status%5Csmart-transaction-status.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = SmartTransactionStatusPage;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _etherscanLink = require("@metamask/etherscan-link");
var _lodash = require("lodash");
var _i18n = require("../../../contexts/i18n");
var _swaps = require("../../../ducks/swaps/swaps");
var _networks = require("../../../../shared/modules/selectors/networks");
var _selectors = require("../../../selectors");
var _selectors2 = require("../../../../shared/modules/selectors");
var _common = require("../../../../shared/constants/common");
var _routes = require("../../../helpers/constants/routes");
var _componentLibrary = require("../../../components/component-library");
var _box = _interopRequireDefault(require("../../../components/ui/box"));
var _urlIcon = _interopRequireDefault(require("../../../components/ui/url-icon"));
var _designSystem = require("../../../helpers/constants/design-system");
var _actions = require("../../../store/actions");
var _metametrics = require("../../../../shared/constants/metametrics");
var _transaction = require("../../../../shared/constants/transaction");
var _swapsFooter = _interopRequireDefault(require("../swaps-footer"));
var _swaps2 = require("../swaps.util");
var _metametrics2 = require("../../../contexts/metametrics");
var _createNewSwap = _interopRequireDefault(require("../create-new-swap"));
var _viewOnBlockExplorer = _interopRequireDefault(require("../view-on-block-explorer"));
var _transactionsControllerUtils = require("../../../../shared/lib/transactions-controller-utils");
var _selectors3 = require("../../../selectors/selectors");
var _successIcon = _interopRequireDefault(require("./success-icon"));
var _revertedIcon = _interopRequireDefault(require("./reverted-icon"));
var _canceledIcon = _interopRequireDefault(require("./canceled-icon"));
var _unknownIcon = _interopRequireDefault(require("./unknown-icon"));
var _arrowIcon = _interopRequireDefault(require("./arrow-icon"));
var _timerIcon = _interopRequireDefault(require("./timer-icon"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SmartTransactionStatusPage() {
  var _latestSmartTransacti4, _latestSmartTransacti5, _latestSmartTransacti6, _latestSmartTransacti8, _latestSmartTransacti1, _latestSmartTransacti10, _latestSmartTransacti11, _latestSmartTransacti12, _latestSmartTransacti13;
  const [cancelSwapLinkClicked, setCancelSwapLinkClicked] = (0, _react.useState)(false);
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const history = (0, _reactRouterDom.useHistory)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const hdEntropyIndex = (0, _reactRedux.useSelector)(_selectors3.getHDEntropyIndex);
  const fetchParams = (0, _reactRedux.useSelector)(_swaps.getFetchParams, _lodash.isEqual) || {};
  const {
    destinationTokenInfo: fetchParamsDestinationTokenInfo = {},
    sourceTokenInfo: fetchParamsSourceTokenInfo = {}
  } = (fetchParams === null || fetchParams === void 0 ? void 0 : fetchParams.metaData) || {};
  const hardwareWalletUsed = (0, _reactRedux.useSelector)(_selectors.isHardwareWallet);
  const hardwareWalletType = (0, _reactRedux.useSelector)(_selectors.getHardwareWalletType);
  const needsTwoConfirmations = true;
  const usedQuote = (0, _reactRedux.useSelector)(_swaps.getUsedQuote, _lodash.isEqual);
  const currentSmartTransactions = (0, _reactRedux.useSelector)(_swaps.getCurrentSmartTransactions, _lodash.isEqual);
  const chainId = (0, _reactRedux.useSelector)(_networks.getCurrentChainId);
  const rpcPrefs = (0, _reactRedux.useSelector)(_selectors.getRpcPrefsForCurrentProvider, _reactRedux.shallowEqual);
  const swapsNetworkConfig = (0, _reactRedux.useSelector)(_swaps.getSwapsNetworkConfig, _reactRedux.shallowEqual);
  const smartTransactionsEnabled = (0, _reactRedux.useSelector)(_selectors2.getSmartTransactionsEnabled);
  const currentSmartTransactionsEnabled = (0, _reactRedux.useSelector)(_swaps.getCurrentSmartTransactionsEnabled);
  const baseNetworkUrl = rpcPrefs.blockExplorerUrl ?? _common.CHAINID_DEFAULT_BLOCK_EXPLORER_URL_MAP[chainId] ?? null;
  let smartTransactionStatus = _transaction.SmartTransactionStatus.pending;
  let latestSmartTransaction = {};
  let latestSmartTransactionUuid;
  let cancellationFeeWei;
  if (currentSmartTransactions && currentSmartTransactions.length > 0) {
    var _latestSmartTransacti, _latestSmartTransacti2, _latestSmartTransacti3;
    latestSmartTransaction = currentSmartTransactions[currentSmartTransactions.length - 1];
    latestSmartTransactionUuid = (_latestSmartTransacti = latestSmartTransaction) === null || _latestSmartTransacti === void 0 ? void 0 : _latestSmartTransacti.uuid;
    smartTransactionStatus = ((_latestSmartTransacti2 = latestSmartTransaction) === null || _latestSmartTransacti2 === void 0 ? void 0 : _latestSmartTransacti2.status) || _transaction.SmartTransactionStatus.pending;
    cancellationFeeWei = (_latestSmartTransacti3 = latestSmartTransaction) === null || _latestSmartTransacti3 === void 0 || (_latestSmartTransacti3 = _latestSmartTransacti3.statusMetadata) === null || _latestSmartTransacti3 === void 0 ? void 0 : _latestSmartTransacti3.cancellationFeeWei;
  }
  const [timeLeftForPendingStxInSec, setTimeLeftForPendingStxInSec] = (0, _react.useState)(swapsNetworkConfig.stxStatusDeadline);
  const sensitiveProperties = {
    needs_two_confirmations: needsTwoConfirmations,
    token_from: fetchParamsSourceTokenInfo.symbol ?? ((_latestSmartTransacti4 = latestSmartTransaction) === null || _latestSmartTransacti4 === void 0 ? void 0 : _latestSmartTransacti4.sourceTokenSymbol),
    token_from_amount: (fetchParams === null || fetchParams === void 0 ? void 0 : fetchParams.value) ?? ((_latestSmartTransacti5 = latestSmartTransaction) === null || _latestSmartTransacti5 === void 0 ? void 0 : _latestSmartTransacti5.swapTokenValue),
    token_to: fetchParamsDestinationTokenInfo.symbol ?? ((_latestSmartTransacti6 = latestSmartTransaction) === null || _latestSmartTransacti6 === void 0 ? void 0 : _latestSmartTransacti6.destinationTokenSymbol),
    request_type: fetchParams !== null && fetchParams !== void 0 && fetchParams.balanceError ? 'Quote' : 'Order',
    slippage: fetchParams === null || fetchParams === void 0 ? void 0 : fetchParams.slippage,
    custom_slippage: (fetchParams === null || fetchParams === void 0 ? void 0 : fetchParams.slippage) === 2,
    is_hardware_wallet: hardwareWalletUsed,
    hardware_wallet_type: hardwareWalletType,
    stx_enabled: smartTransactionsEnabled,
    current_stx_enabled: currentSmartTransactionsEnabled,
    stx_user_opt_in: (0, _reactRedux.useSelector)(_selectors2.getSmartTransactionsOptInStatusForMetrics)
  };
  let destinationValue;
  if (usedQuote !== null && usedQuote !== void 0 && usedQuote.destinationAmount) {
    var _latestSmartTransacti7;
    destinationValue = (0, _transactionsControllerUtils.calcTokenAmount)(usedQuote === null || usedQuote === void 0 ? void 0 : usedQuote.destinationAmount, fetchParamsDestinationTokenInfo.decimals ?? ((_latestSmartTransacti7 = latestSmartTransaction) === null || _latestSmartTransacti7 === void 0 ? void 0 : _latestSmartTransacti7.destinationTokenDecimals)).toPrecision(8);
  }
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const isSmartTransactionPending = smartTransactionStatus === _transaction.SmartTransactionStatus.pending;
  const showCloseButtonOnly = isSmartTransactionPending || smartTransactionStatus === _transaction.SmartTransactionStatus.success;
  const txHash = (_latestSmartTransacti8 = latestSmartTransaction) === null || _latestSmartTransacti8 === void 0 || (_latestSmartTransacti8 = _latestSmartTransacti8.statusMetadata) === null || _latestSmartTransacti8 === void 0 ? void 0 : _latestSmartTransacti8.minedHash;
  (0, _react.useEffect)(() => {
    trackEvent({
      event: 'STX Status Page Loaded',
      category: _metametrics.MetaMetricsEventCategory.Swaps,
      sensitiveProperties,
      properties: {
        hd_entropy_index: hdEntropyIndex
      }
    });
    // eslint-disable-next-line
  }, []);
  (0, _react.useEffect)(() => {
    let intervalId;
    if (isSmartTransactionPending && latestSmartTransactionUuid) {
      const calculateRemainingTime = () => {
        const secondsAfterStxSubmission = Math.round((Date.now() - latestSmartTransaction.time) / 1000);
        if (secondsAfterStxSubmission > swapsNetworkConfig.stxStatusDeadline) {
          setTimeLeftForPendingStxInSec(0);
          clearInterval(intervalId);
          return;
        }
        setTimeLeftForPendingStxInSec(swapsNetworkConfig.stxStatusDeadline - secondsAfterStxSubmission);
      };
      intervalId = setInterval(calculateRemainingTime, 1000);
      calculateRemainingTime();
    }
    return () => clearInterval(intervalId);
  }, [dispatch, isSmartTransactionPending, latestSmartTransactionUuid, latestSmartTransaction.time, swapsNetworkConfig.stxStatusDeadline]);
  (0, _react.useEffect)(() => {
    dispatch((0, _actions.setBackgroundSwapRouteState)('smartTransactionStatus'));
    setTimeout(() => {
      // We don't need to poll for quotes on the status page.
      dispatch((0, _actions.stopPollingForQuotes)());
    }, 1000); // Stop polling for quotes after 1s.
  }, [dispatch]);
  let headerText = t('stxPendingPrivatelySubmittingSwap');
  let description;
  let subDescription;
  let icon;
  let blockExplorerUrl;
  if (isSmartTransactionPending) {
    if (cancelSwapLinkClicked) {
      headerText = t('stxTryingToCancel');
    } else if (cancellationFeeWei > 0) {
      headerText = t('stxPendingPubliclySubmittingSwap');
    }
  }
  if (smartTransactionStatus === _transaction.SmartTransactionStatus.success) {
    var _latestSmartTransacti9;
    headerText = t('stxSuccess');
    if (fetchParamsDestinationTokenInfo.symbol || (_latestSmartTransacti9 = latestSmartTransaction) !== null && _latestSmartTransacti9 !== void 0 && _latestSmartTransacti9.destinationTokenSymbol) {
      var _latestSmartTransacti0;
      description = t('stxSuccessDescription', [fetchParamsDestinationTokenInfo.symbol ?? ((_latestSmartTransacti0 = latestSmartTransaction) === null || _latestSmartTransacti0 === void 0 ? void 0 : _latestSmartTransacti0.destinationTokenSymbol)]);
    }
    icon = /*#__PURE__*/_react.default.createElement(_successIcon.default, null);
  } else if (smartTransactionStatus === 'cancelled_user_cancelled' || ((_latestSmartTransacti1 = latestSmartTransaction) === null || _latestSmartTransacti1 === void 0 || (_latestSmartTransacti1 = _latestSmartTransacti1.statusMetadata) === null || _latestSmartTransacti1 === void 0 ? void 0 : _latestSmartTransacti1.minedTx) === _transaction.SmartTransactionStatus.cancelled) {
    headerText = t('stxUserCancelled');
    description = t('stxUserCancelledDescription');
    icon = /*#__PURE__*/_react.default.createElement(_canceledIcon.default, null);
  } else if (smartTransactionStatus.startsWith('cancelled') || smartTransactionStatus.includes('deadline_missed')) {
    headerText = t('stxCancelled');
    description = t('stxCancelledDescription');
    subDescription = t('stxCancelledSubDescription');
    icon = /*#__PURE__*/_react.default.createElement(_canceledIcon.default, null);
  } else if (smartTransactionStatus === 'unknown') {
    headerText = t('stxUnknown');
    description = t('stxUnknownDescription');
    icon = /*#__PURE__*/_react.default.createElement(_unknownIcon.default, null);
  } else if (smartTransactionStatus === 'reverted') {
    headerText = t('stxFailure');
    description = t('stxFailureDescription', [/*#__PURE__*/_react.default.createElement("a", {
      className: "smart-transaction-status__support-link",
      key: "smart-transaction-status-support-link",
      href: "https://support.metamask.io",
      target: "_blank",
      rel: "noopener noreferrer"
    }, t('customerSupport'))]);
    icon = /*#__PURE__*/_react.default.createElement(_revertedIcon.default, null);
  }
  if (txHash && latestSmartTransactionUuid) {
    blockExplorerUrl = (0, _etherscanLink.getBlockExplorerLink)({
      hash: txHash,
      chainId
    }, {
      blockExplorerUrl: baseNetworkUrl
    });
  }
  const showCancelSwapLink = latestSmartTransaction.cancellable && !cancelSwapLinkClicked;
  const CancelSwap = () => {
    return /*#__PURE__*/_react.default.createElement(_box.default, {
      marginBottom: 0
    }, /*#__PURE__*/_react.default.createElement("a", {
      className: "smart-transaction-status__cancel-swap-link",
      href: "#",
      onClick: e => {
        e === null || e === void 0 || e.preventDefault();
        setCancelSwapLinkClicked(true); // We want to hide it after a user clicks on it.
        trackEvent({
          event: 'Cancel STX',
          category: _metametrics.MetaMetricsEventCategory.Swaps,
          sensitiveProperties,
          properties: {
            hd_entropy_index: hdEntropyIndex
          }
        });
        dispatch((0, _swaps.cancelSwapsSmartTransaction)(latestSmartTransactionUuid));
      }
    }, t('attemptToCancelSwapForFree')));
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "smart-transaction-status"
  }, /*#__PURE__*/_react.default.createElement(_box.default, {
    paddingLeft: 8,
    paddingRight: 8,
    height: _designSystem.BLOCK_SIZES.FULL,
    justifyContent: _designSystem.JustifyContent.flexStart,
    display: _designSystem.DISPLAY.FLEX,
    className: "smart-transaction-status__content"
  }, /*#__PURE__*/_react.default.createElement(_box.default, {
    marginTop: 10,
    marginBottom: 0,
    display: _designSystem.DISPLAY.FLEX,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textAlternative,
    variant: _designSystem.TextVariant.bodySm,
    as: "h6"
  }, `${(fetchParams === null || fetchParams === void 0 ? void 0 : fetchParams.value) && Number(fetchParams.value).toFixed(5)} `), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textAlternative,
    variant: _designSystem.TextVariant.bodySmBold,
    as: "h6",
    marginLeft: 1,
    marginRight: 2
  }, fetchParamsSourceTokenInfo.symbol ?? ((_latestSmartTransacti10 = latestSmartTransaction) === null || _latestSmartTransacti10 === void 0 ? void 0 : _latestSmartTransacti10.sourceTokenSymbol)), fetchParamsSourceTokenInfo.iconUrl ? /*#__PURE__*/_react.default.createElement(_urlIcon.default, {
    url: fetchParamsSourceTokenInfo.iconUrl,
    className: "smart-transactions-status-summary__icon",
    name: fetchParamsSourceTokenInfo.symbol ?? ((_latestSmartTransacti11 = latestSmartTransaction) === null || _latestSmartTransacti11 === void 0 ? void 0 : _latestSmartTransacti11.destinationTokenSymbol),
    fallbackClassName: "smart-transactions-status-summary__icon-fallback"
  }) : null, /*#__PURE__*/_react.default.createElement(_box.default, {
    display: _designSystem.DISPLAY.BLOCK,
    marginLeft: 2,
    marginRight: 2
  }, /*#__PURE__*/_react.default.createElement(_arrowIcon.default, null)), fetchParamsDestinationTokenInfo.iconUrl ? /*#__PURE__*/_react.default.createElement(_urlIcon.default, {
    url: fetchParamsDestinationTokenInfo.iconUrl,
    className: "smart-transactions-status-summary__icon",
    name: fetchParamsDestinationTokenInfo.symbol ?? ((_latestSmartTransacti12 = latestSmartTransaction) === null || _latestSmartTransacti12 === void 0 ? void 0 : _latestSmartTransacti12.destinationTokenSymbol),
    fallbackClassName: "smart-transactions-status-summary__icon-fallback"
  }) : null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textAlternative,
    variant: _designSystem.TextVariant.bodySm,
    as: "h6",
    marginLeft: 2
  }, `~${destinationValue && Number(destinationValue).toFixed(5)} `), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textAlternative,
    variant: _designSystem.TextVariant.bodySmBold,
    as: "h6",
    marginLeft: 1
  }, fetchParamsDestinationTokenInfo.symbol ?? ((_latestSmartTransacti13 = latestSmartTransaction) === null || _latestSmartTransacti13 === void 0 ? void 0 : _latestSmartTransacti13.destinationTokenSymbol))), /*#__PURE__*/_react.default.createElement(_box.default, {
    marginTop: 3,
    className: "smart-transaction-status__spacer-box--top"
  }), icon && /*#__PURE__*/_react.default.createElement(_box.default, {
    marginTop: 3,
    marginBottom: 2
  }, icon), isSmartTransactionPending && /*#__PURE__*/_react.default.createElement(_box.default, {
    marginTop: 7,
    marginBottom: 1,
    display: _designSystem.DISPLAY.FLEX,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_timerIcon.default, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textAlternative,
    variant: _designSystem.TextVariant.bodySm,
    as: "h6",
    marginLeft: 1
  }, `${t('stxSwapCompleteIn')} `), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textAlternative,
    variant: _designSystem.TextVariant.bodySmBold,
    as: "h6",
    marginLeft: 1,
    className: "smart-transaction-status__remaining-time"
  }, (0, _swaps2.showRemainingTimeInMinAndSec)(timeLeftForPendingStxInSec))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    "data-testid": "swap-smart-transaction-status-header",
    color: _designSystem.TextColor.textDefault,
    variant: _designSystem.TextVariant.headingSm,
    as: "h4",
    fontWeight: _designSystem.FontWeight.Bold
  }, headerText), isSmartTransactionPending && /*#__PURE__*/_react.default.createElement("div", {
    className: "smart-transaction-status__loading-bar-container"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "smart-transaction-status__loading-bar",
    style: {
      width: `${100 / swapsNetworkConfig.stxStatusDeadline * (swapsNetworkConfig.stxStatusDeadline - timeLeftForPendingStxInSec)}%`
    }
  })), description && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    "data-testid": "swap-smart-transaction-status-description",
    variant: _designSystem.TextVariant.bodySm,
    as: "h6",
    marginTop: blockExplorerUrl && 1,
    color: _designSystem.TextColor.textAlternative
  }, description), blockExplorerUrl && /*#__PURE__*/_react.default.createElement(_viewOnBlockExplorer.default, {
    blockExplorerUrl: blockExplorerUrl,
    sensitiveTrackingProperties: sensitiveProperties
  }), /*#__PURE__*/_react.default.createElement(_box.default, {
    marginTop: 3,
    className: "smart-transaction-status__spacer-box--bottom"
  }), subDescription && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    as: "h6",
    marginTop: 8,
    color: _designSystem.TextColor.textAlternative
  }, subDescription)), showCancelSwapLink && latestSmartTransactionUuid && isSmartTransactionPending && /*#__PURE__*/_react.default.createElement(CancelSwap, null), smartTransactionStatus === _transaction.SmartTransactionStatus.success ? /*#__PURE__*/_react.default.createElement(_createNewSwap.default, {
    sensitiveTrackingProperties: sensitiveProperties
  }) : null, /*#__PURE__*/_react.default.createElement(_swapsFooter.default, {
    onSubmit: async () => {
      if (showCloseButtonOnly) {
        await dispatch((0, _swaps.prepareToLeaveSwaps)());
        history.push(_routes.DEFAULT_ROUTE);
      } else {
        history.push(_routes.PREPARE_SWAP_ROUTE);
      }
    },
    onCancel: async () => {
      await dispatch((0, _swaps.prepareToLeaveSwaps)());
      history.push(_routes.DEFAULT_ROUTE);
    },
    submitText: showCloseButtonOnly ? t('close') : t('tryAgain'),
    hideCancel: showCloseButtonOnly,
    cancelText: t('close'),
    className: "smart-transaction-status__swaps-footer"
  }));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\swaps\\smart-transaction-status\\smart-transaction-status.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\smart-transaction-status\\success-icon.js", {"react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cswaps%5Csmart-transaction-status%5Csuccess-icon.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = SuccessIcon;
var _react = _interopRequireDefault(require("react"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function SuccessIcon() {
  return /*#__PURE__*/_react.default.createElement("svg", {
    width: "39",
    height: "39",
    viewBox: "0 0 39 39",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "M34.5457 19.8983C34.5457 23.9296 32.9443 27.7958 30.0937 30.6463C27.2432 33.4969 23.377 35.0983 19.3457 35.0983C15.3144 35.0983 11.4482 33.4969 8.59768 30.6463C5.74713 27.7958 4.1457 23.9296 4.1457 19.8983C4.1457 15.867 5.74713 12.0008 8.59768 9.15029C11.4482 6.29974 15.3144 4.69832 19.3457 4.69832C20.7897 4.69832 22.1957 4.90732 23.5257 5.28732L26.5087 2.30432C24.3047 1.39232 21.8917 0.898315 19.3457 0.898315C16.8506 0.898315 14.3799 1.38977 12.0747 2.3446C9.76953 3.29944 7.67499 4.69897 5.91067 6.46329C2.34748 10.0265 0.345703 14.8592 0.345703 19.8983C0.345703 24.9374 2.34748 29.7702 5.91067 33.3333C7.67499 35.0977 9.76953 36.4972 12.0747 37.452C14.3799 38.4069 16.8506 38.8983 19.3457 38.8983C24.3848 38.8983 29.2175 36.8965 32.7807 33.3333C36.3439 29.7702 38.3457 24.9374 38.3457 19.8983H34.5457ZM11.5747 16.2503L8.8957 18.9483L17.4457 27.4983L36.4457 8.49832L33.7667 5.80032L17.4457 22.1213L11.5747 16.2503Z",
    fill: "var(--color-success-default)"
  }));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\swaps\\smart-transaction-status\\success-icon.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\smart-transaction-status\\timer-icon.js", {"react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cswaps%5Csmart-transaction-status%5Ctimer-icon.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = TimerIcon;
var _react = _interopRequireDefault(require("react"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function TimerIcon() {
  return /*#__PURE__*/_react.default.createElement("svg", {
    width: "15",
    height: "14",
    viewBox: "0 0 15 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "M7.36621 0.0810547C3.62012 0.0810547 0.584961 3.11621 0.584961 6.8623C0.584961 10.6084 3.62012 13.6436 7.36621 13.6436C11.1123 13.6436 14.1475 10.6084 14.1475 6.8623C14.1475 3.11621 11.1123 0.0810547 7.36621 0.0810547ZM7.36621 12.3311C4.33105 12.3311 1.89746 9.89746 1.89746 6.8623C1.89746 3.85449 4.33105 1.39355 7.36621 1.39355C10.374 1.39355 12.835 3.85449 12.835 6.8623C12.835 9.89746 10.374 12.3311 7.36621 12.3311ZM9.03418 9.4873C9.19824 9.59668 9.38965 9.56934 9.49902 9.40527L10.0186 8.72168C10.1279 8.55762 10.1006 8.36621 9.93652 8.25684L8.13184 6.91699V3.03418C8.13184 2.87012 7.96777 2.70605 7.80371 2.70605H6.92871C6.7373 2.70605 6.60059 2.87012 6.60059 3.03418V7.5459C6.60059 7.62793 6.62793 7.7373 6.70996 7.79199L9.03418 9.4873Z",
    fill: "var(--color-primary-default)"
  }));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\swaps\\smart-transaction-status\\timer-icon.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\smart-transaction-status\\unknown-icon.js", {"react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cswaps%5Csmart-transaction-status%5Cunknown-icon.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = UnknownIcon;
var _react = _interopRequireDefault(require("react"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function UnknownIcon() {
  return /*#__PURE__*/_react.default.createElement("svg", {
    width: "39",
    height: "39",
    viewBox: "0 0 39 39",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, /*#__PURE__*/_react.default.createElement("circle", {
    cx: "19.1533",
    cy: "19.2715",
    r: "17.1",
    stroke: "var(--color-primary-default)",
    strokeWidth: "3.8"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M16.712 21.5034C16.712 20.7834 16.88 20.1834 17.216 19.7034C17.568 19.2074 18.08 18.7274 18.752 18.2634C19.008 18.0874 19.264 17.9274 19.52 17.7834C19.776 17.6394 20 17.4874 20.192 17.3274C20.4 17.1514 20.56 16.9674 20.672 16.7754C20.8 16.5674 20.864 16.3194 20.864 16.0314C20.864 15.5354 20.688 15.1594 20.336 14.9034C20 14.6474 19.592 14.5194 19.112 14.5194C18.616 14.5194 18.16 14.6794 17.744 14.9994C17.344 15.3034 17.144 15.7674 17.144 16.3914H13.52C13.52 15.6394 13.664 14.9354 13.952 14.2794C14.24 13.6074 14.632 13.0314 15.128 12.5514C15.64 12.0554 16.232 11.6634 16.904 11.3754C17.592 11.0874 18.328 10.9434 19.112 10.9434C19.896 10.9434 20.616 11.0794 21.272 11.3514C21.944 11.6234 22.512 11.9834 22.976 12.4314C23.456 12.8794 23.824 13.3994 24.08 13.9914C24.352 14.5674 24.488 15.1754 24.488 15.8154C24.488 16.2314 24.456 16.6234 24.392 16.9914C24.344 17.3594 24.24 17.7114 24.08 18.0474C23.936 18.3834 23.728 18.7114 23.456 19.0314C23.184 19.3514 22.84 19.6634 22.424 19.9674C21.784 20.4474 21.272 20.8234 20.888 21.0954C20.52 21.3674 20.336 21.6474 20.336 21.9354V21.9594H16.712V21.5034ZM18.512 28.4634C18.16 28.4634 17.824 28.3994 17.504 28.2714C17.2 28.1274 16.928 27.9434 16.688 27.7194C16.464 27.4794 16.28 27.2074 16.136 26.9034C16.008 26.5834 15.944 26.2474 15.944 25.8954C15.944 25.5434 16.008 25.2154 16.136 24.9114C16.28 24.5914 16.464 24.3194 16.688 24.0954C16.928 23.8554 17.2 23.6714 17.504 23.5434C17.824 23.3994 18.16 23.3274 18.512 23.3274C18.864 23.3274 19.192 23.3994 19.496 23.5434C19.816 23.6714 20.088 23.8554 20.312 24.0954C20.552 24.3194 20.736 24.5914 20.864 24.9114C21.008 25.2154 21.08 25.5434 21.08 25.8954C21.08 26.2474 21.008 26.5834 20.864 26.9034C20.736 27.2074 20.552 27.4794 20.312 27.7194C20.088 27.9434 19.816 28.1274 19.496 28.2714C19.192 28.3994 18.864 28.4634 18.512 28.4634Z",
    fill: "var(--color-primary-default)"
  }));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\swaps\\smart-transaction-status\\unknown-icon.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\swaps-footer\\index.js", {"./swaps-footer":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\swaps-footer\\swaps-footer.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cswaps%5Cswaps-footer%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _swapsFooter.default;
  }
});
var _swapsFooter = _interopRequireDefault(require("./swaps-footer"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\swaps\\swaps-footer\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\swaps-footer\\swaps-footer.js", {"../../../components/ui/page-container/page-container-footer":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\page-container\\page-container-footer\\index.js","../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cswaps%5Cswaps-footer%5Cswaps-footer.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = SwapsFooter;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _i18n = require("../../../contexts/i18n");
var _pageContainerFooter = _interopRequireDefault(require("../../../components/ui/page-container/page-container-footer"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SwapsFooter({
  onCancel,
  hideCancel,
  onSubmit,
  submitText,
  disabled,
  showTermsOfService,
  showTopBorder,
  className = '',
  cancelText
}) {
  const t = (0, _react.useContext)(_i18n.I18nContext);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "swaps-footer"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('swaps-footer__buttons', className, {
      'swaps-footer__buttons--border': showTopBorder
    })
  }, /*#__PURE__*/_react.default.createElement(_pageContainerFooter.default, {
    onCancel: onCancel,
    hideCancel: hideCancel,
    cancelText: cancelText || t('back'),
    onSubmit: onSubmit,
    submitText: submitText,
    footerClassName: (0, _classnames.default)('swaps-footer__custom-page-container-footer-class', className),
    footerButtonClassName: (0, _classnames.default)('swaps-footer__custom-page-container-footer-button-class', {
      'swaps-footer__custom-page-container-footer-button-class--single': hideCancel
    }),
    disabled: disabled
  })), showTermsOfService && /*#__PURE__*/_react.default.createElement("div", {
    className: "swaps-footer__bottom-text",
    onClick: () => global.platform.openTab({
      url: 'https://metamask.io/terms.html'
    })
  }, t('termsOfService')));
}
SwapsFooter.propTypes = {
  onCancel: _propTypes.default.func,
  hideCancel: _propTypes.default.bool,
  onSubmit: _propTypes.default.func,
  submitText: _propTypes.default.string,
  disabled: _propTypes.default.bool,
  showTermsOfService: _propTypes.default.bool,
  showTopBorder: _propTypes.default.bool,
  className: _propTypes.default.string,
  cancelText: _propTypes.default.string
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\swaps\\swaps-footer\\swaps-footer.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\view-on-block-explorer\\index.js", {"./view-on-block-explorer":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\view-on-block-explorer\\view-on-block-explorer.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cswaps%5Cview-on-block-explorer%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _viewOnBlockExplorer.default;
  }
});
var _viewOnBlockExplorer = _interopRequireDefault(require("./view-on-block-explorer"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\swaps\\view-on-block-explorer\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\view-on-block-explorer\\view-on-block-explorer.js", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../components/ui/box":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\box\\index.js","../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cswaps%5Cview-on-block-explorer%5Cview-on-block-explorer.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ViewOnBlockExplorer;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _box = _interopRequireDefault(require("../../../components/ui/box"));
var _i18n = require("../../../contexts/i18n");
var _util = require("../../../helpers/utils/util");
var _metametrics = require("../../../contexts/metametrics");
var _metametrics2 = require("../../../../shared/constants/metametrics");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ViewOnBlockExplorer({
  blockExplorerUrl,
  sensitiveTrackingProperties
}) {
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const blockExplorerHostName = (0, _util.getURLHostName)(blockExplorerUrl);
  return /*#__PURE__*/_react.default.createElement(_box.default, {
    marginTop: 6,
    className: "view-on-block-explorer"
  }, /*#__PURE__*/_react.default.createElement("button", {
    onClick: () => {
      trackEvent({
        event: _metametrics2.MetaMetricsEventName.ExternalLinkClicked,
        category: _metametrics2.MetaMetricsEventCategory.Swaps,
        sensitiveProperties: sensitiveTrackingProperties,
        properties: {
          link_type: _metametrics2.MetaMetricsEventLinkType.TransactionBlockExplorer,
          location: 'Swap Transaction',
          url_domain: blockExplorerHostName
        }
      });
      global.platform.openTab({
        url: blockExplorerUrl
      });
    }
  }, t('viewOnCustomBlockExplorer', [t('blockExplorerSwapAction'), blockExplorerHostName])));
}
ViewOnBlockExplorer.propTypes = {
  blockExplorerUrl: _propTypes.default.string.isRequired,
  sensitiveTrackingProperties: _propTypes.default.object.isRequired
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\swaps\\view-on-block-explorer\\view-on-block-explorer.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\trust-signals\\hooks\\useTrustSignalMetrics.ts", {"../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../confirmations/context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","../../confirmations/hooks/useSignatureEventFragment":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useSignatureEventFragment.ts","../../confirmations/hooks/useTransactionEventFragment":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useTransactionEventFragment.js","../../confirmations/utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\utils\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Ctrust-signals%5Chooks%5CuseTrustSignalMetrics.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTrustSignalMetrics = useTrustSignalMetrics;
var _react = require("react");
var _reactRedux = require("react-redux");
var _selectors = require("../../../selectors");
var _confirm = require("../../confirmations/context/confirm");
var _utils = require("../../confirmations/utils");
var _useTransactionEventFragment = require("../../confirmations/hooks/useTransactionEventFragment");
var _useSignatureEventFragment = require("../../confirmations/hooks/useSignatureEventFragment");
// eslint-disable-next-line import/no-restricted-paths

// For transactions, this is the 'to' address. For signatures, this is the verifying contract.
function getTargetAddress(confirmation) {
  if (!confirmation) {
    return null;
  }
  if (!(0, _utils.isSignatureTransactionType)(confirmation)) {
    var _txMeta$txParams;
    const txMeta = confirmation;
    return ((_txMeta$txParams = txMeta.txParams) === null || _txMeta$txParams === void 0 ? void 0 : _txMeta$txParams.to) ?? null;
  }
  try {
    var _msgParams, _parsedData$domain;
    const data = confirmation === null || confirmation === void 0 || (_msgParams = confirmation.msgParams) === null || _msgParams === void 0 ? void 0 : _msgParams.data;
    const parsedData = typeof data === 'string' ? JSON.parse(data) : data;
    if (parsedData !== null && parsedData !== void 0 && (_parsedData$domain = parsedData.domain) !== null && _parsedData$domain !== void 0 && _parsedData$domain.verifyingContract) {
      return parsedData.domain.verifyingContract;
    }
  } catch (e) {
    // do nothing
  }
  return null;
}
function useTrustSignalMetrics() {
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const {
    updateSignatureEventFragment
  } = (0, _useSignatureEventFragment.useSignatureEventFragment)();
  const {
    updateTransactionEventFragment
  } = (0, _useTransactionEventFragment.useTransactionEventFragment)();
  const addressToCheck = (0, _react.useMemo)(() => getTargetAddress(currentConfirmation), [currentConfirmation]);
  const addressSecurityAlertResponse = (0, _reactRedux.useSelector)(state => addressToCheck ? (0, _selectors.getAddressSecurityAlertResponse)(state, addressToCheck) : undefined);
  const {
    properties,
    anonymousProperties
  } = (0, _react.useMemo)(() => {
    if (!addressSecurityAlertResponse) {
      return {
        properties: {},
        anonymousProperties: {}
      };
    }
    return {
      properties: {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        address_alert_response: addressSecurityAlertResponse.result_type
      },
      anonymousProperties: {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        address_label: addressSecurityAlertResponse.label || undefined
      }
    };
  }, [addressSecurityAlertResponse]);
  const updateTrustSignalMetrics = (0, _react.useCallback)(() => {
    if (!addressSecurityAlertResponse || !currentConfirmation) {
      return;
    }
    const ownerId = (currentConfirmation === null || currentConfirmation === void 0 ? void 0 : currentConfirmation.id) ?? '';
    if ((0, _utils.isSignatureTransactionType)(currentConfirmation)) {
      updateSignatureEventFragment({
        properties
      });
      if (anonymousProperties.address_label) {
        updateSignatureEventFragment({
          sensitiveProperties: anonymousProperties
        });
      }
    } else {
      updateTransactionEventFragment({
        properties
      }, ownerId);
      if (anonymousProperties.address_label) {
        updateTransactionEventFragment({
          sensitiveProperties: anonymousProperties
        }, ownerId);
      }
    }
  }, [addressSecurityAlertResponse, currentConfirmation, properties, anonymousProperties, updateSignatureEventFragment, updateTransactionEventFragment]);
  (0, _react.useEffect)(() => {
    updateTrustSignalMetrics();
  }, [updateTrustSignalMetrics]);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\trust-signals\\hooks\\useTrustSignalMetrics.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\unlock-page\\formatted-counter.tsx", {"../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cunlock-page%5Cformatted-counter.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = FormattedCounter;
var _react = _interopRequireWildcard(require("react"));
var _designSystem = require("../../helpers/constants/design-system");
var _componentLibrary = require("../../components/component-library");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const formatTimeToUnlock = timeInSeconds => {
  if (timeInSeconds <= 60) {
    return `${timeInSeconds} seconds.`;
  }
  const hours = Math.floor(timeInSeconds / 3600);
  const minutes = Math.floor(timeInSeconds % 3600 / 60);
  const seconds = timeInSeconds % 60;
  return `${hours}:${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}.`;
};

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function FormattedCounter({
  startFrom,
  onCountdownEnd
}) {
  const [time, setTime] = (0, _react.useState)(startFrom);
  (0, _react.useEffect)(() => {
    const intervalId = setInterval(() => {
      setTime(val => {
        if (val <= 0) {
          clearInterval(intervalId);
          onCountdownEnd();
          return 0;
        }
        return val - 1;
      });
    }, 1000);
    return () => clearInterval(intervalId);
  }, [onCountdownEnd]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.inherit,
    color: _designSystem.TextColor.inherit,
    as: "span"
  }, formatTimeToUnlock(time));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\unlock-page\\formatted-counter.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\unlock-page\\index.js", {"./unlock-page.container":"D:\\code\\v\\metamask-extension\\ui\\pages\\unlock-page\\unlock-page.container.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cunlock-page%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _unlockPage = _interopRequireDefault(require("./unlock-page.container"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
var _default = exports.default = _unlockPage.default;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\unlock-page\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\unlock-page\\reset-password-modal.tsx", {"../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cunlock-page%5Creset-password-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ResetPasswordModal;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _useI18nContext = require("../../hooks/useI18nContext");
var _componentLibrary = require("../../components/component-library");
var _designSystem = require("../../helpers/constants/design-system");
var _selectors = require("../../selectors");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function ResetPasswordModal({
  onClose,
  onRestore
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  const isSocialLoginEnabled = (0, _reactRedux.useSelector)(_selectors.getIsSocialLoginFlow);
  const socialLoginContent = () => {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      paddingInline: 4
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMd,
      marginBottom: 4
    }, t('forgotPasswordSocialDescription')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      as: "ul",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      gap: 4,
      marginBottom: 6
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      gap: 4,
      as: "li"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
      name: _componentLibrary.IconName.FaceId,
      size: _componentLibrary.IconSize.Md,
      color: _designSystem.IconColor.iconMuted,
      style: {
        marginTop: '2px'
      }
    }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMd
    }, t('forgotPasswordSocialStep1', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.inherit,
      fontWeight: _designSystem.FontWeight.Bold,
      key: "reset-password-step-1-biometrics"
    }, t('forgotPasswordSocialStep1Biometrics'))]))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      gap: 4,
      as: "li"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
      name: _componentLibrary.IconName.SecurityKey,
      size: _componentLibrary.IconSize.Md,
      color: _designSystem.IconColor.iconMuted,
      style: {
        marginTop: '2px'
      }
    }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMd
    }, t('forgotPasswordSocialStep2', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.inherit,
      fontWeight: _designSystem.FontWeight.Bold,
      key: "reset-password-step-2-srp"
    }, t('secretRecoveryPhrase'))])))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
      "data-testid": "reset-password-modal-button",
      variant: _componentLibrary.ButtonVariant.Primary,
      onClick: onRestore,
      size: _componentLibrary.ButtonSize.Lg,
      block: true,
      danger: true
    }, t('forgotPasswordModalButton')));
  };
  const srpLoginContent = () => {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      paddingInline: 4
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      width: _designSystem.BlockSize.Full,
      display: _designSystem.Display.Flex,
      justifyContent: _designSystem.JustifyContent.center,
      alignItems: _designSystem.AlignItems.center,
      marginBottom: 2
    }, /*#__PURE__*/_react.default.createElement("img", {
      src: "images/forgot-password-lock.png",
      width: 154,
      height: 154,
      alt: t('forgotPasswordModalTitle'),
      style: {
        alignSelf: 'center'
      }
    })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMd,
      marginBottom: 4
    }, t('forgotPasswordModalDescription1')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMd,
      marginBottom: 6
    }, t('forgotPasswordModalDescription2')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
      "data-testid": "reset-password-modal-button",
      variant: _componentLibrary.ButtonVariant.Primary,
      onClick: onRestore,
      size: _componentLibrary.ButtonSize.Lg,
      block: true,
      danger: true
    }, t('forgotPasswordModalButton')));
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: true,
    onClose: onClose,
    className: "reset-password-modal",
    "data-testid": "reset-password-modal"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, {
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onClose: onClose
  }, t('forgotPasswordModalTitle')), isSocialLoginEnabled ? socialLoginContent() : srpLoginContent()));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\unlock-page\\reset-password-modal.tsx",}]],[],{})

//# sourceMappingURL=data:application/json;charset=utf8;base64,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