LavaPack.loadBundle([
["D:\\code\\v\\metamask-extension\\ui\\pages\\unlock-page\\unlock-page.component.js", {"../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../shared/constants/onboarding":"D:\\code\\v\\metamask-extension\\shared\\constants\\onboarding.ts","../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../shared/lib/ui-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\ui-utils.js","../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../components/ui/mascot":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\mascot\\index.js","../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../helpers/utils/build-types":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\build-types.js","./formatted-counter":"D:\\code\\v\\metamask-extension\\ui\\pages\\unlock-page\\formatted-counter.tsx","./reset-password-modal":"D:\\code\\v\\metamask-extension\\ui\\pages\\unlock-page\\reset-password-modal.tsx","./unlock-page.util":"D:\\code\\v\\metamask-extension\\ui\\pages\\unlock-page\\unlock-page.util.js","@metamask/seedless-onboarding-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\seedless-onboarding-controller\\dist\\index.cjs","events":"D:\\code\\v\\metamask-extension\\node_modules\\events\\events.js","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cunlock-page%5Cunlock-page.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _events = require("events");
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _seedlessOnboardingController = require("@metamask/seedless-onboarding-controller");
var _loglevel = _interopRequireDefault(require("loglevel"));
var _componentLibrary = require("../../components/component-library");
var _designSystem = require("../../helpers/constants/design-system");
var _mascot = _interopRequireDefault(require("../../components/ui/mascot"));
var _routes = require("../../helpers/constants/routes");
var _metametrics = require("../../../shared/constants/metametrics");
var _buildTypes = require("../../helpers/utils/build-types");
var _uiUtils = require("../../../shared/lib/ui-utils");
var _trace = require("../../../shared/lib/trace");
var _onboarding = require("../../../shared/constants/onboarding");
var _metametrics2 = require("../../contexts/metametrics");
var _unlockPage = require("./unlock-page.util");
var _resetPasswordModal = _interopRequireDefault(require("./reset-password-modal"));
var _formattedCounter = _interopRequireDefault(require("./formatted-counter"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class UnlockPage extends _react.Component {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "state", {
      password: '',
      error: null,
      showResetPasswordModal: false,
      isLocked: false,
      isSubmitting: false,
      unlockDelayPeriod: 0
    });
    _defineProperty(this, "failed_attempts", 0);
    _defineProperty(this, "animationEventEmitter", new _events.EventEmitter());
    _defineProperty(this, "passwordLoginAttemptTraceCtx", null);
    _defineProperty(this, "handleSubmit", async event => {
      event.preventDefault();
      event.stopPropagation();
      const {
        password,
        isSubmitting
      } = this.state;
      const {
        onSubmit
      } = this.props;
      if (password === '' || isSubmitting) {
        return;
      }
      this.setState({
        error: null,
        isSubmitting: true
      });

      // Capture the rehydration state before async operations that might change it
      const isRehydrationFlow = this.isSocialImportRehydration();

      // Track wallet rehydration attempted for social import users (only during rehydration)
      if (isRehydrationFlow) {
        this.context.trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Onboarding,
          event: _metametrics.MetaMetricsEventName.RehydrationPasswordAttempted,
          properties: {
            account_type: 'social',
            biometrics: false
          }
        });
      }
      try {
        var _this$context$buffere2, _this$context2, _this$context$buffere3, _this$context3;
        await onSubmit(password);

        // Track wallet rehydration completed for social import users (only during rehydration)
        if (isRehydrationFlow) {
          this.context.trackEvent({
            category: _metametrics.MetaMetricsEventCategory.Onboarding,
            event: _metametrics.MetaMetricsEventName.RehydrationCompleted,
            properties: {
              account_type: 'social',
              biometrics: false,
              failed_attempts: this.failed_attempts
            }
          });
        }
        this.context.trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Navigation,
          event: _metametrics.MetaMetricsEventName.AppUnlocked,
          properties: {
            failed_attempts: this.failed_attempts
          }
        }, {
          isNewVisit: true
        });
        if (this.passwordLoginAttemptTraceCtx) {
          var _this$context$buffere, _this$context;
          (_this$context$buffere = (_this$context = this.context).bufferedEndTrace) === null || _this$context$buffere === void 0 || _this$context$buffere.call(_this$context, {
            name: _trace.TraceName.OnboardingPasswordLoginAttempt
          });
          this.passwordLoginAttemptTraceCtx = null;
        }
        (_this$context$buffere2 = (_this$context2 = this.context).bufferedEndTrace) === null || _this$context$buffere2 === void 0 || _this$context$buffere2.call(_this$context2, {
          name: _trace.TraceName.OnboardingExistingSocialLogin
        });
        (_this$context$buffere3 = (_this$context3 = this.context).bufferedEndTrace) === null || _this$context$buffere3 === void 0 || _this$context$buffere3.call(_this$context3, {
          name: _trace.TraceName.OnboardingJourneyOverall
        });
      } catch (error) {
        await this.handleLoginError(error, isRehydrationFlow);
      } finally {
        this.setState({
          isSubmitting: false
        });
      }
    });
    _defineProperty(this, "handleLoginError", async (error, isRehydrationFlow = false) => {
      var _this$props$onboardin;
      const {
        t
      } = this.context;
      const {
        message,
        data
      } = error;

      // Sync failed_attempts with numberOfAttempts from error data
      if ((data === null || data === void 0 ? void 0 : data.numberOfAttempts) !== undefined) {
        this.failed_attempts = data.numberOfAttempts;
      }
      let finalErrorMessage = message;
      let finalUnlockDelayPeriod = 0;
      let errorReason;

      // Track wallet rehydration failed for social import users (only during rehydration)
      if (isRehydrationFlow) {
        this.context.trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Onboarding,
          event: _metametrics.MetaMetricsEventName.RehydrationPasswordFailed,
          properties: {
            account_type: 'social',
            failed_attempts: this.failed_attempts
          }
        });
      }

      // Check if we are in the onboarding flow
      if ((_this$props$onboardin = this.props.onboardingParentContext) !== null && _this$props$onboardin !== void 0 && _this$props$onboardin.current) {
        var _this$context$buffere4, _this$context4, _this$context$buffere5, _this$context5;
        (_this$context$buffere4 = (_this$context4 = this.context).bufferedTrace) === null || _this$context$buffere4 === void 0 || _this$context$buffere4.call(_this$context4, {
          name: _trace.TraceName.OnboardingPasswordLoginError,
          op: _trace.TraceOperation.OnboardingError,
          tags: {
            errorMessage: message
          },
          parentContext: this.props.onboardingParentContext.current
        });
        (_this$context$buffere5 = (_this$context5 = this.context).bufferedEndTrace) === null || _this$context$buffere5 === void 0 || _this$context$buffere5.call(_this$context5, {
          name: _trace.TraceName.OnboardingPasswordLoginError
        });
      }
      switch (message) {
        case 'Incorrect password':
        case _seedlessOnboardingController.SeedlessOnboardingControllerErrorMessage.IncorrectPassword:
          finalErrorMessage = t('unlockPageIncorrectPassword');
          errorReason = 'incorrect_password';
          break;
        case _seedlessOnboardingController.SeedlessOnboardingControllerErrorMessage.TooManyLoginAttempts:
          this.setState({
            isLocked: true
          });
          finalErrorMessage = t('unlockPageTooManyFailedAttempts');
          errorReason = 'too_many_login_attempts';
          finalUnlockDelayPeriod = data.remainingTime;
          break;
        case _seedlessOnboardingController.SeedlessOnboardingControllerErrorMessage.OutdatedPassword:
          finalErrorMessage = t('passwordChangedRecently');
          errorReason = 'outdated_password';
          break;
        default:
          finalErrorMessage = message;
          break;
      }
      if (errorReason) {
        await this.props.forceUpdateMetamaskState();
        this.context.trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Navigation,
          event: _metametrics.MetaMetricsEventName.AppUnlockedFailed,
          properties: {
            reason: errorReason,
            failed_attempts: this.failed_attempts
          }
        });
      }
      this.setState({
        error: finalErrorMessage,
        unlockDelayPeriod: finalUnlockDelayPeriod
      });
    });
    _defineProperty(this, "renderMascot", () => {
      // Always show Aeris Wallet logo instead of MetaMask mascot
      return /*#__PURE__*/_react.default.createElement("img", {
        src: "./images/logo/aeris-logo.svg",
        width: "115",
        height: "115",
        alt: "Aeris Wallet"
      });
    });
    _defineProperty(this, "renderHelpText", () => {
      const {
        error,
        unlockDelayPeriod
      } = this.state;
      if (!error) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        className: "unlock-page__help-text",
        display: _designSystem.Display.Flex,
        flexDirection: _designSystem.FlexDirection.Column
      }, error && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        "data-testid": "unlock-page-help-text",
        variant: _designSystem.TextVariant.bodySm,
        textAlign: _designSystem.TextAlign.Left,
        color: _designSystem.TextColor.errorDefault
      }, error, unlockDelayPeriod > 0 && /*#__PURE__*/_react.default.createElement(_formattedCounter.default, {
        startFrom: unlockDelayPeriod,
        onCountdownEnd: () => this.setState({
          isLocked: false,
          error: null,
          unlockDelayPeriod: 0
        })
      })));
    });
    _defineProperty(this, "onForgotPasswordOrLoginWithDiffMethods", async () => {
      const {
        isSocialLoginFlow,
        history,
        isOnboardingCompleted
      } = this.props;

      // in `onboarding_unlock` route, if the user is on a social login flow and onboarding is not completed,
      // we can redirect to `onboarding_welcome` route to select a different login method
      if (!isOnboardingCompleted && isSocialLoginFlow) {
        await this.props.loginWithDifferentMethod();
        await this.props.forceUpdateMetamaskState();
        history.replace(_routes.ONBOARDING_WELCOME_ROUTE);
        return;
      }
      this.context.trackEvent({
        category: _metametrics.MetaMetricsEventCategory.Onboarding,
        event: _metametrics.MetaMetricsEventName.ForgotPasswordClicked,
        properties: {
          account_type: isSocialLoginFlow ? 'social' : 'metamask'
        }
      });
      this.setState({
        showResetPasswordModal: true
      });
    });
    _defineProperty(this, "onRestoreWallet", () => {
      const {
        isSocialLoginFlow
      } = this.props;
      this.context.trackEvent({
        category: _metametrics.MetaMetricsEventCategory.Accounts,
        event: _metametrics.MetaMetricsEventName.ResetWallet,
        properties: {
          account_type: isSocialLoginFlow ? 'social' : 'metamask'
        }
      });
      this.props.onRestore();
    });
  }
  /**
   * Determines if the current user is in the social import rehydration phase
   *
   * @returns {boolean} True if user is importing social wallet during onboarding
   */
  isSocialImportRehydration() {
    return this.props.firstTimeFlowType === _onboarding.FirstTimeFlowType.socialImport && !this.props.isOnboardingCompleted;
  }
  UNSAFE_componentWillMount() {
    const {
      isUnlocked,
      history,
      location
    } = this.props;
    if (isUnlocked) {
      var _location$state;
      // Redirect to the intended route if available, otherwise DEFAULT_ROUTE
      let redirectTo = _routes.DEFAULT_ROUTE;
      if ((_location$state = location.state) !== null && _location$state !== void 0 && (_location$state = _location$state.from) !== null && _location$state !== void 0 && _location$state.pathname) {
        const search = location.state.from.search || '';
        redirectTo = location.state.from.pathname + search;
      }
      history.push(redirectTo);
    }
  }
  async componentDidMount() {
    var _this$context$buffere6, _this$context6, _this$props$onboardin2;
    this.passwordLoginAttemptTraceCtx = (_this$context$buffere6 = (_this$context6 = this.context).bufferedTrace) === null || _this$context$buffere6 === void 0 ? void 0 : _this$context$buffere6.call(_this$context6, {
      name: _trace.TraceName.OnboardingPasswordLoginAttempt,
      op: _trace.TraceOperation.OnboardingUserJourney,
      parentContext: (_this$props$onboardin2 = this.props.onboardingParentContext) === null || _this$props$onboardin2 === void 0 ? void 0 : _this$props$onboardin2.current
    });
    try {
      await this.props.checkIsSeedlessPasswordOutdated();
    } catch (error) {
      _loglevel.default.error('unlock page - checkIsSeedlessPasswordOutdated error', error);
    }
  }
  handleInputChange(event) {
    const {
      target
    } = event;
    this.setState({
      password: target.value,
      error: null
    });
    const element = target;
    const boundingRect = element.getBoundingClientRect();
    const coordinates = (0, _unlockPage.getCaretCoordinates)(element, element.selectionEnd ?? 0);
    this.animationEventEmitter.emit('point', {
      x: boundingRect.left + coordinates.left - element.scrollLeft,
      y: boundingRect.top + coordinates.top - element.scrollTop
    });
  }
  render() {
    const {
      password,
      error,
      isLocked,
      showResetPasswordModal
    } = this.state;
    const {
      isOnboardingCompleted,
      isSocialLoginFlow
    } = this.props;
    const {
      t
    } = this.context;
    const needHelpText = t('needHelpLinkText');
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      alignItems: _designSystem.AlignItems.center,
      justifyContent: _designSystem.JustifyContent.center,
      backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
      width: _designSystem.BlockSize.Full,
      paddingBottom: 12 // offset header to center content
    }, showResetPasswordModal && /*#__PURE__*/_react.default.createElement(_resetPasswordModal.default, {
      onClose: () => this.setState({
        showResetPasswordModal: false
      }),
      onRestore: this.onRestoreWallet
    }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      as: "form",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      justifyContent: _designSystem.JustifyContent.center,
      alignItems: _designSystem.AlignItems.center,
      padding: 4,
      width: _designSystem.BlockSize.Full,
      className: "unlock-page",
      "data-testid": "unlock-page",
      onSubmit: this.handleSubmit
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      width: _designSystem.BlockSize.Full,
      alignItems: _designSystem.AlignItems.center
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      className: "unlock-page__mascot-container",
      marginBottom: (0, _buildTypes.isBeta)() || (0, _buildTypes.isFlask)() ? 6 : 0
    }, this.renderMascot(), (0, _buildTypes.isBeta)() ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      className: "unlock-page__mascot-container__beta",
      backgroundColor: _designSystem.BackgroundColor.primaryDefault,
      color: _designSystem.TextColor.primaryInverse,
      padding: 1,
      borderRadius: _designSystem.BorderRadius.LG,
      textTransform: _designSystem.TextTransform.Uppercase,
      fontWeight: _designSystem.FontWeight.Medium
    }, t('beta')) : null), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      "data-testid": "unlock-page-title",
      as: "h1",
      variant: _designSystem.TextVariant.displayMd,
      marginBottom: 12,
      fontWeight: _designSystem.FontWeight.Medium,
      color: _designSystem.TextColor.textDefault,
      textAlign: _designSystem.TextAlign.Center
    }, t('welcomeBack')), /*#__PURE__*/_react.default.createElement(_componentLibrary.FormTextField, {
      id: "password",
      placeholder: this.props.isSocialLoginFlow ? t('enterYourPasswordSocialLoginFlow') : t('enterYourPassword'),
      size: _componentLibrary.FormTextFieldSize.Lg,
      inputProps: {
        'data-testid': 'unlock-password',
        'aria-label': t('password')
      },
      textFieldProps: {
        disabled: isLocked
      },
      onChange: event => this.handleInputChange(event),
      type: _componentLibrary.TextFieldType.Password,
      value: password,
      error: Boolean(error),
      helpText: this.renderHelpText(),
      autoComplete: true,
      autoFocus: true,
      width: _designSystem.BlockSize.Full,
      marginBottom: 4
    }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
      variant: _componentLibrary.ButtonVariant.Primary,
      size: _componentLibrary.ButtonSize.Lg,
      block: true,
      type: "submit",
      "data-testid": "unlock-submit",
      disabled: !password || isLocked,
      marginBottom: 6
    }, this.context.t('unlock')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
      variant: _componentLibrary.ButtonVariant.Link,
      "data-testid": "unlock-forgot-password-button",
      key: "import-account",
      type: "button",
      onClick: this.onForgotPasswordOrLoginWithDiffMethods,
      marginBottom: 6
    }, isSocialLoginFlow && !isOnboardingCompleted ? t('useDifferentLoginMethod') : t('forgotPassword')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, null, t('needHelp', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
      variant: _componentLibrary.ButtonVariant.Link,
      href: _uiUtils.SUPPORT_LINK,
      type: "button",
      target: "_blank",
      rel: "noopener noreferrer",
      key: "need-help-link",
      onClick: () => {
        this.context.trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Navigation,
          event: _metametrics.MetaMetricsEventName.SupportLinkClicked,
          properties: {
            url: _uiUtils.SUPPORT_LINK
          }
        }, {
          contextPropsIntoEventProperties: [_metametrics.MetaMetricsContextProp.PageTitle]
        });
      }
    }, needHelpText)])))));
  }
}
_defineProperty(UnlockPage, "contextTypes", {
  trackEvent: _propTypes.default.func,
  bufferedTrace: _propTypes.default.func,
  bufferedEndTrace: _propTypes.default.func,
  t: _propTypes.default.func
});
_defineProperty(UnlockPage, "propTypes", {
  /**
   * History router for redirect after action
   */
  history: _propTypes.default.object.isRequired,
  /**
   * Location router for redirect after action
   */
  location: _propTypes.default.object.isRequired,
  /**
   * If isUnlocked is true will redirect to most recent route in history
   */
  isUnlocked: _propTypes.default.bool,
  /**
   * If isOnboardingCompleted is true, `Use a different login method` button
   * will be shown instead of `Forgot password?`
   */
  isOnboardingCompleted: _propTypes.default.bool,
  /**
   * onClick handler for "Forgot password?" link
   */
  onRestore: _propTypes.default.func,
  /**
   * onSubmit handler when form is submitted
   */
  onSubmit: _propTypes.default.func,
  /**
   * check password is outdated for social login flow
   */
  checkIsSeedlessPasswordOutdated: _propTypes.default.func,
  /**
   * Force update metamask data state
   */
  forceUpdateMetamaskState: _propTypes.default.func,
  /**
   * isSocialLoginFlow. True if the user is on a social login flow
   */
  isSocialLoginFlow: _propTypes.default.bool,
  /**
   * Sentry trace context ref for onboarding journey tracing
   */
  onboardingParentContext: _propTypes.default.object,
  /**
   * Reset Onboarding and OAuth login state
   */
  loginWithDifferentMethod: _propTypes.default.func,
  /**
   * Indicates the type of first time flow
   */
  firstTimeFlowType: _propTypes.default.string
});
var _default = exports.default = (0, _metametrics2.withMetaMetrics)(UnlockPage);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\unlock-page\\unlock-page.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\unlock-page\\unlock-page.container.js", {"../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./unlock-page.component":"D:\\code\\v\\metamask-extension\\ui\\pages\\unlock-page\\unlock-page.component.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js","redux":"D:\\code\\v\\metamask-extension\\node_modules\\redux\\lib\\redux.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cunlock-page%5Cunlock-page.container.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _redux = require("redux");
var _util = require("../../../app/scripts/lib/util");
var _app = require("../../../shared/constants/app");
var _routes = require("../../helpers/constants/routes");
var _actions = require("../../store/actions");
var _selectors = require("../../selectors");
var _metamask = require("../../ducks/metamask/metamask");
var _unlockPage = _interopRequireDefault(require("./unlock-page.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

const mapStateToProps = state => {
  const {
    metamask: {
      isUnlocked
    }
  } = state;
  return {
    isUnlocked,
    isSocialLoginFlow: (0, _selectors.getIsSocialLoginFlow)(state),
    isOnboardingCompleted: (0, _metamask.getCompletedOnboarding)(state),
    firstTimeFlowType: (0, _selectors.getFirstTimeFlowType)(state)
  };
};
const mapDispatchToProps = dispatch => {
  return {
    tryUnlockMetamask: password => dispatch((0, _actions.tryUnlockMetamask)(password)),
    markPasswordForgotten: () => dispatch((0, _actions.markPasswordForgotten)()),
    forceUpdateMetamaskState: () => (0, _actions.forceUpdateMetamaskState)(dispatch),
    loginWithDifferentMethod: () => dispatch((0, _actions.resetOnboarding)()),
    checkIsSeedlessPasswordOutdated: () => dispatch((0, _actions.checkIsSeedlessPasswordOutdated)())
  };
};
const mergeProps = (stateProps, dispatchProps, ownProps) => {
  const {
    markPasswordForgotten: propsMarkPasswordForgotten,
    tryUnlockMetamask: propsTryUnlockMetamask,
    ...restDispatchProps
  } = dispatchProps;
  const {
    history,
    onSubmit: ownPropsSubmit,
    location,
    ...restOwnProps
  } = ownProps;
  const onImport = async () => {
    await propsMarkPasswordForgotten();
    history.push(_routes.RESTORE_VAULT_ROUTE);
    if ((0, _util.getEnvironmentType)() === _app.ENVIRONMENT_TYPE_POPUP) {
      var _global$platform$open, _global$platform;
      (_global$platform$open = (_global$platform = global.platform).openExtensionInBrowser) === null || _global$platform$open === void 0 || _global$platform$open.call(_global$platform, _routes.RESTORE_VAULT_ROUTE);
    }
  };
  const onSubmit = async password => {
    var _location$state;
    await propsTryUnlockMetamask(password);
    // Redirect to the intended route if available, otherwise DEFAULT_ROUTE
    let redirectTo = _routes.DEFAULT_ROUTE;
    if ((_location$state = location.state) !== null && _location$state !== void 0 && (_location$state = _location$state.from) !== null && _location$state !== void 0 && _location$state.pathname) {
      const search = location.state.from.search || '';
      redirectTo = location.state.from.pathname + search;
    }
    history.push(redirectTo);
  };
  return {
    ...stateProps,
    ...restDispatchProps,
    ...restOwnProps,
    onRestore: onImport,
    onSubmit: ownPropsSubmit || onSubmit,
    history,
    location
  };
};
var _default = exports.default = (0, _redux.compose)(_reactRouterDom.withRouter, (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps, mergeProps))(_unlockPage.default);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\unlock-page\\unlock-page.container.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\unlock-page\\unlock-page.util.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cunlock-page%5Cunlock-page.util.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCaretCoordinates = getCaretCoordinates;
function getCaretCoordinates(element, position) {
  const div = document.createElement('div');
  div.id = 'password-mirror-div';
  document.body.appendChild(div);
  const computed = window.getComputedStyle(element);
  div.textContent = new Array(position + 1).join('•');
  const span = document.createElement('span');
  span.textContent = '•';
  div.appendChild(span);
  const coordinates = {
    top: span.offsetTop + parseInt(computed.borderTopWidth, 10),
    left: span.offsetLeft + parseInt(computed.borderLeftWidth, 10)
  };
  document.body.removeChild(div);
  return coordinates;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\unlock-page\\unlock-page.util.js",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\account-abstraction.ts", {"reselect":"D:\\code\\v\\metamask-extension\\node_modules\\reselect\\dist\\cjs\\reselect.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Caccount-abstraction.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIsUsingPaymaster = getIsUsingPaymaster;
exports.getUserOperation = getUserOperation;
exports.getUserOperations = getUserOperations;
exports.selectUserOperationMetadata = exports.selectPaymasterData = exports.selectPaymasterAddress = void 0;
var _reselect = require("reselect");
function getUserOperations(state) {
  return state.metamask.userOperations || {};
}
const selectUserOperationMetadata = exports.selectUserOperationMetadata = (0, _reselect.createSelector)(getUserOperations, (_state, userOperationId) => userOperationId, (userOperations, userOperationId) => userOperations[userOperationId]);
function getUserOperation(state) {
  var _state$confirmTransac;
  const currentTransaction = (_state$confirmTransac = state.confirmTransaction) === null || _state$confirmTransac === void 0 ? void 0 : _state$confirmTransac.txData;
  if (!currentTransaction) {
    return undefined;
  }
  const {
    id,
    isUserOperation
  } = currentTransaction;
  if (!isUserOperation) {
    return undefined;
  }
  const userOperations = getUserOperations(state);
  return userOperations[id];
}
function getIsUsingPaymaster(state) {
  var _userOperation$userOp;
  const userOperation = getUserOperation(state);
  if (!userOperation) {
    return false;
  }
  const paymasterData = (_userOperation$userOp = userOperation.userOperation) === null || _userOperation$userOp === void 0 ? void 0 : _userOperation$userOp.paymasterAndData;
  return Boolean(paymasterData === null || paymasterData === void 0 ? void 0 : paymasterData.length) && paymasterData !== '0x';
}
const selectPaymasterData = exports.selectPaymasterData = (0, _reselect.createSelector)(selectUserOperationMetadata, userOperationMetadata => {
  var _userOperationMetadat;
  const paymasterAndData = userOperationMetadata === null || userOperationMetadata === void 0 || (_userOperationMetadat = userOperationMetadata.userOperation) === null || _userOperationMetadat === void 0 ? void 0 : _userOperationMetadat.paymasterAndData;
  return paymasterAndData === '0x' ? undefined : paymasterAndData;
});
const selectPaymasterAddress = exports.selectPaymasterAddress = (0, _reselect.createSelector)(selectPaymasterData, paymasterData => {
  return paymasterData === null || paymasterData === void 0 ? void 0 : paymasterData.slice(0, 42);
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\account-abstraction.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\alerts.ts", {"./shared":"D:\\code\\v\\metamask-extension\\ui\\selectors\\shared.ts","reselect":"D:\\code\\v\\metamask-extension\\node_modules\\reselect\\dist\\cjs\\reselect.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Calerts.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectAlerts = selectAlerts;
exports.selectConfirmedAlertKeys = selectConfirmedAlertKeys;
exports.selectGeneralAlerts = exports.selectFieldAlerts = void 0;
var _reselect = require("reselect");
var _shared = require("./shared");
function selectAlerts(state, ownerId) {
  var _state$confirmAlerts;
  return ((_state$confirmAlerts = state.confirmAlerts) === null || _state$confirmAlerts === void 0 ? void 0 : _state$confirmAlerts.alerts[ownerId]) ?? _shared.EMPTY_ARRAY;
}
const selectGeneralAlerts = exports.selectGeneralAlerts = (0, _reselect.createSelector)((state, ownerId) => selectAlerts(state, ownerId), alerts => alerts.filter(alert => !alert.field));
const selectFieldAlerts = exports.selectFieldAlerts = (0, _reselect.createSelector)((state, ownerId) => selectAlerts(state, ownerId), alerts => alerts.filter(alert => alert.field));
function selectConfirmedAlertKeys(state, ownerId) {
  const {
    confirmed
  } = state.confirmAlerts ?? {};
  const ownerConfirmed = (confirmed === null || confirmed === void 0 ? void 0 : confirmed[ownerId]) || {};
  return Object.keys(ownerConfirmed).filter(key => ownerConfirmed[key]);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\alerts.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\assets.ts", {"../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../shared/lib/asset-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\asset-utils.ts","../../shared/modules/selectors/util":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\util.js","../components/app/assets/util/calculateTokenBalance":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\util\\calculateTokenBalance.ts","../components/app/assets/util/calculateTokenFiatAmount":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\util\\calculateTokenFiatAmount.ts","../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../pages/asset/util":"D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\util.ts","./accounts":"D:\\code\\v\\metamask-extension\\ui\\selectors\\accounts.ts","./multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","./multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","./multichain/networks":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain\\networks.ts","./selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","./shared":"D:\\code\\v\\metamask-extension\\ui\\selectors\\shared.ts","@metamask/assets-controllers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","bignumber.js":"D:\\code\\v\\metamask-extension\\node_modules\\bignumber.js\\bignumber.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","reselect":"D:\\code\\v\\metamask-extension\\node_modules\\reselect\\dist\\cjs\\reselect.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Cassets.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAccountAssets = getAccountAssets;
exports.getAssetsBySelectedAccountGroup = void 0;
exports.getAssetsMetadata = getAssetsMetadata;
exports.getAssetsRates = getAssetsRates;
exports.getDefiPositions = getDefiPositions;
exports.getHistoricalMultichainAggregatedBalance = void 0;
exports.getHistoricalPrices = getHistoricalPrices;
exports.selectBalancePercentChangeByAccountGroup = exports.selectBalanceForAllWallets = exports.selectBalanceChangeForAllWallets = exports.selectBalanceChangeBySelectedAccountGroup = exports.selectBalanceChangeByAccountGroup = exports.selectBalanceByWallet = exports.selectBalanceBySelectedAccountGroup = exports.selectBalanceByAccountGroup = exports.getTokenByAccountAndAddressAndChainId = exports.getTokenBalancesEvm = exports.getMultichainNativeTokenBalance = exports.getMultichainNativeAssetType = exports.getMultichainAggregatedBalance = exports.getMultiChainAssets = void 0;
var _assetsControllers = require("@metamask/assets-controllers");
var _utils = require("@metamask/utils");
var _bignumber = require("bignumber.js");
var _lodash = require("lodash");
var _reselect = require("reselect");
var _network = require("../../shared/constants/network");
var _util = require("../../shared/modules/selectors/util");
var _calculateTokenBalance = require("../components/app/assets/util/calculateTokenBalance");
var _calculateTokenFiatAmount = require("../components/app/assets/util/calculateTokenFiatAmount");
var _metamask = require("../ducks/metamask/metamask");
var _util2 = require("../pages/asset/util");
var _assetUtils = require("../../shared/lib/asset-utils");
var _accounts = require("./accounts");
var _multichain = require("./multichain");
var _shared = require("./shared");
var _selectors = require("./selectors");
var _networks = require("./multichain/networks");
var _accountTree = require("./multichain-accounts/account-tree");
// Type for the main Redux state that includes all controller states needed for balance calculations

/**
 * Gets non-EVM accounts assets.
 *
 * @param state - Redux state object.
 * @returns An object containing non-EVM assets per accounts.
 */
function getAccountAssets(state) {
  return state.metamask.accountsAssets;
}

/**
 * Gets non-EVM assets metadata.
 *
 * @param state - Redux state object.
 * @returns An object containing non-EVM assets metadata per asset types (CAIP-19).
 */
function getAssetsMetadata(state) {
  return state.metamask.assetsMetadata;
}

/**
 * Gets non-EVM accounts assets rates.
 *
 * @param state - Redux state object.
 * @returns An object containing non-EVM assets per accounts.
 */
function getAssetsRates(state) {
  return state.metamask.conversionRates;
}

/**
 * Gets DeFi positions
 *
 * @param state - Redux state object.
 * @returns An object containing defi positions for all accounts
 */
function getDefiPositions(state) {
  var _state$metamask;
  return state === null || state === void 0 || (_state$metamask = state.metamask) === null || _state$metamask === void 0 ? void 0 : _state$metamask.allDeFiPositions;
}

/**
 * Gets non-EVM assets historical prices.
 *
 * @param state - Redux state object.
 * @returns An object containing non-EVM assets historical prices per asset types (CAIP-19).
 */
function getHistoricalPrices(state) {
  return state.metamask.historicalPrices;
}
const getTokenBalancesEvm = exports.getTokenBalancesEvm = (0, _util.createDeepEqualSelector)(_selectors.getTokensAcrossChainsByAccountAddressSelector, _selectors.getNativeTokenCachedBalanceByChainIdSelector, _metamask.getTokenBalances, (_state, accountAddress) => accountAddress, _selectors.getMarketData, _selectors.getCurrencyRates, _selectors.getPreferences, _selectors.getIsTokenNetworkFilterEqualCurrentNetwork, _selectors.getCurrentNetwork, (selectedAccountTokensChains, nativeBalances, tokenBalances, selectedAccountAddress, marketData, currencyRates, preferences, isOnCurrentNetwork, currentNetwork) => {
  const {
    hideZeroBalanceTokens
  } = preferences;
  const selectedAccountTokenBalancesAcrossChains = tokenBalances[selectedAccountAddress];

  // we need to filter Testnets
  const isTestNetwork = _network.TEST_CHAINS.includes(currentNetwork.chainId);
  const filteredAccountTokensChains = Object.fromEntries(Object.entries(selectedAccountTokensChains).filter(([chainId]) => isTestNetwork ? _network.TEST_CHAINS.includes(chainId) : !_network.TEST_CHAINS.includes(chainId)));
  const tokensWithBalance = [];
  Object.entries(filteredAccountTokensChains).forEach(([stringChainKey, tokens]) => {
    const chainId = stringChainKey;
    const tokenList = tokens;
    tokenList.forEach(token => {
      const {
        isNative,
        address,
        decimals
      } = token;
      const balance = (0, _calculateTokenBalance.calculateTokenBalance)({
        isNative,
        chainId,
        address: address,
        decimals,
        nativeBalances,
        selectedAccountTokenBalancesAcrossChains
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
        // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
      }) || '0';
      const tokenFiatAmount = (0, _calculateTokenFiatAmount.calculateTokenFiatAmount)({
        token,
        chainId,
        balance,
        marketData,
        currencyRates
      });

      // Respect the "hide zero balance" setting (when true):
      // - Native tokens should always display with zero balance when on the current network filter.
      // - Native tokens should not display with zero balance when on all networks filter
      // - ERC20 tokens with zero balances should respect the setting on both the current and all networks.

      // Respect the "hide zero balance" setting (when false):
      // - Native tokens should always display with zero balance when on the current network filter.
      // - Native tokens should always display with zero balance when on all networks filter
      // - ERC20 tokens always display with zero balance on both the current and all networks filter.
      if (!hideZeroBalanceTokens || balance !== '0' || token.isNative && isOnCurrentNetwork) {
        // title is used for sorting. We override native ETH to Ethereum
        let title;
        if (token.isNative) {
          title = token.symbol === 'ETH' ? 'Ethereum' : token.symbol;
        } else {
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
          // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
          title = token.name || token.symbol;
        }
        tokensWithBalance.push({
          ...token,
          address: token.address,
          balance,
          tokenFiatAmount,
          chainId: chainId,
          string: String(balance),
          secondary: 0,
          title
        });
      }
    });
  });
  return tokensWithBalance;
});
const getMultiChainAssets = exports.getMultiChainAssets = (0, _util.createDeepEqualSelector)((_state, selectedAccount) => selectedAccount, _multichain.getMultichainBalances, getAccountAssets, getAssetsMetadata, getAssetsRates, _selectors.getPreferences, (selectedAccountAddress, multichainBalances, accountAssets, assetsMetadata, assetRates, preferences) => {
  const {
    hideZeroBalanceTokens
  } = preferences;
  const assetIds = (accountAssets === null || accountAssets === void 0 ? void 0 : accountAssets[selectedAccountAddress.id]) || [];
  const balances = multichainBalances === null || multichainBalances === void 0 ? void 0 : multichainBalances[selectedAccountAddress.id];
  const allAssets = [];
  assetIds.forEach(assetId => {
    var _assetRates$assetId, _metadata$units$;
    const {
      chainId,
      assetNamespace
    } = (0, _utils.parseCaipAssetType)(assetId);
    const isNative = assetNamespace === 'slip44';
    const balance = (balances === null || balances === void 0 ? void 0 : balances[assetId]) || {
      amount: '0',
      unit: ''
    };
    const rate = assetRates === null || assetRates === void 0 || (_assetRates$assetId = assetRates[assetId]) === null || _assetRates$assetId === void 0 ? void 0 : _assetRates$assetId.rate;
    const balanceInFiat = rate ? new _bignumber.BigNumber(balance.amount).times(rate).toNumber() : null;
    const assetMetadataFallback = {
      name: balance.unit,
      symbol: balance.unit || '',
      fungible: true,
      units: [{
        name: assetId,
        symbol: balance.unit || '',
        decimals: 0
      }]
    };
    const metadata = assetsMetadata[assetId] || assetMetadataFallback;
    const decimals = ((_metadata$units$ = metadata.units[0]) === null || _metadata$units$ === void 0 ? void 0 : _metadata$units$.decimals) || 0;
    if (!hideZeroBalanceTokens || balance.amount !== '0' || isNative) {
      allAssets.push({
        title: metadata.name,
        address: assetId,
        symbol: metadata.symbol,
        image: metadata.iconUrl,
        decimals,
        chainId,
        isNative,
        balance: balance.amount,
        secondary: balanceInFiat,
        string: '',
        tokenFiatAmount: balanceInFiat,
        isStakeable: false
      });
    }
  });
  return allAssets;
});

/**
 * Gets a {@link Token} (EVM or Multichain) owned by the passed account by address and chainId.
 *
 * @param state - Redux state object
 * @param tokenAddress - Token address (Hex for EVM, or CaipAssetType for non-EVM)
 * @param chainId - Chain ID (Hex for EVM, or CaipChainId for non-EVM)
 * @param internalAccount - The account holding the token to search for
 * @returns Token object
 */
const getTokenByAccountAndAddressAndChainId = exports.getTokenByAccountAndAddressAndChainId = (0, _util.createDeepEqualSelector)(state => state, (_state, account) => account, (_state, _account, tokenAddress) => tokenAddress, (_state, _account, _tokenAddress, _chainId) => _chainId, (state, account, tokenAddress, chainId) => {
  const isEvm = (0, _assetUtils.isEvmChainId)(chainId);
  if (!tokenAddress && !isEvm) {
    return null;
  }
  const accountToUse = account ?? (isEvm ? (0, _accounts.getSelectedInternalAccount)(state) : (0, _accountTree.getInternalAccountBySelectedAccountGroupAndCaip)(state, chainId));
  const assetsToSearch = isEvm ? (0, _selectors.getSelectedAccountTokensAcrossChains)(state) : (0, _lodash.groupBy)(getMultiChainAssets(state, accountToUse), 'chainId');
  const result = (0, _util2.findAssetByAddress)(assetsToSearch, tokenAddress, chainId);
  return result;
});
const zeroBalanceAssetFallback = {
  amount: 0,
  unit: ''
};
const getMultichainAggregatedBalance = exports.getMultichainAggregatedBalance = (0, _util.createDeepEqualSelector)((_state, selectedAccount) => selectedAccount, _multichain.getMultichainBalances, getAccountAssets, getAssetsRates, (selectedAccountAddress, multichainBalances, accountAssets, assetRates) => {
  const {
    id
  } = selectedAccountAddress ?? {};
  const assetIds = id ? (accountAssets === null || accountAssets === void 0 ? void 0 : accountAssets[id]) || [] : [];
  const balances = id ? multichainBalances === null || multichainBalances === void 0 ? void 0 : multichainBalances[id] : {};
  let aggregatedBalance = new _bignumber.BigNumber(0);
  assetIds.forEach(assetId => {
    var _assetRates$assetId2;
    const balance = (balances === null || balances === void 0 ? void 0 : balances[assetId]) || zeroBalanceAssetFallback;
    const rate = (assetRates === null || assetRates === void 0 || (_assetRates$assetId2 = assetRates[assetId]) === null || _assetRates$assetId2 === void 0 ? void 0 : _assetRates$assetId2.rate) || '0';
    const balanceInFiat = new _bignumber.BigNumber(balance.amount).times(rate);
    aggregatedBalance = aggregatedBalance.plus(balanceInFiat);
  });
  return aggregatedBalance.toNumber();
});
const getHistoricalMultichainAggregatedBalance = exports.getHistoricalMultichainAggregatedBalance = (0, _util.createDeepEqualSelector)((_state, selectedAccount) => selectedAccount, _multichain.getMultichainBalances, getAccountAssets, getAssetsRates, (selectedAccountAddress, multichainBalances, accountAssets, assetRates) => {
  const assetIds = (accountAssets === null || accountAssets === void 0 ? void 0 : accountAssets[selectedAccountAddress.id]) || [];
  const balances = multichainBalances === null || multichainBalances === void 0 ? void 0 : multichainBalances[selectedAccountAddress.id];

  // Initialize historical balances object with zeros
  const historicalBalances = {
    PT1H: {
      balance: 0,
      percentChange: 0,
      amountChange: 0
    },
    P1D: {
      balance: 0,
      percentChange: 0,
      amountChange: 0
    },
    P7D: {
      balance: 0,
      percentChange: 0,
      amountChange: 0
    },
    P14D: {
      balance: 0,
      percentChange: 0,
      amountChange: 0
    },
    P30D: {
      balance: 0,
      percentChange: 0,
      amountChange: 0
    },
    P200D: {
      balance: 0,
      percentChange: 0,
      amountChange: 0
    },
    P1Y: {
      balance: 0,
      percentChange: 0,
      amountChange: 0
    }
  };

  // Track total current balance for calculating overall percent changes
  let totalCurrentBalance = new _bignumber.BigNumber(0);
  assetIds.forEach(assetId => {
    var _assetRate$marketData;
    const balance = (balances === null || balances === void 0 ? void 0 : balances[assetId]) || zeroBalanceAssetFallback;
    const assetRate = assetRates === null || assetRates === void 0 ? void 0 : assetRates[assetId];
    if (!(assetRate !== null && assetRate !== void 0 && (_assetRate$marketData = assetRate.marketData) !== null && _assetRate$marketData !== void 0 && _assetRate$marketData.pricePercentChange)) {
      return;
    }
    if (assetRate.rate) {
      const {
        pricePercentChange
      } = assetRate.marketData;
      // Calculate current balance in fiat
      const currentBalanceInFiat = new _bignumber.BigNumber(balance.amount).times(assetRate.rate || '0');

      // Add to total current balance
      totalCurrentBalance = totalCurrentBalance.plus(currentBalanceInFiat);

      // For each time period, reconstruct the historical balance for that period, based on current balance and percent change
      Object.entries(pricePercentChange).forEach(([period, percentChange]) => {
        if (period in historicalBalances) {
          // Calculate historical balance by adjusting current balance by the percent change
          const historicalBalance = currentBalanceInFiat.div(Number((1 + percentChange / 100).toFixed(8))).toNumber();

          // aggregated the historical balance for that period with the running balance from the other balance
          historicalBalances[period].balance += historicalBalance;
        }
      });
    }
  });

  // Calculate overall percent and amount change for each historical period
  const totalCurrentBalanceNum = totalCurrentBalance.toNumber();
  Object.entries(historicalBalances).forEach(([_period, data]) => {
    if (totalCurrentBalanceNum !== 0) {
      // Calculate amount change (current - historical)
      const amountChange = totalCurrentBalanceNum - data.balance;

      // Calculate percent change relative to historical balance
      const percentChange = amountChange / data.balance * 100;

      // Round to 8 decimal places for precision
      data.amountChange = Number(amountChange.toFixed(8));
      data.percentChange = Number(percentChange.toFixed(8));
    }
  });
  return historicalBalances;
});

/**
 * Gets the CAIP asset type of the native token of the current network.
 *
 * @param state - Redux state object
 * @param selectedAccount - Selected account
 * @returns CAIP asset type of the native token, or undefined if no native token is found
 */
const getMultichainNativeAssetType = exports.getMultichainNativeAssetType = (0, _util.createDeepEqualSelector)(_accounts.getSelectedInternalAccount, getAccountAssets, _networks.getSelectedMultichainNetworkConfiguration, (selectedAccount, accountAssets, currentNetwork) => {
  const assetTypes = (accountAssets === null || accountAssets === void 0 ? void 0 : accountAssets[selectedAccount.id]) || [];
  const nativeAssetType = assetTypes.find(assetType => {
    const {
      chainId,
      assetNamespace
    } = (0, _utils.parseCaipAssetType)(assetType);
    return chainId === currentNetwork.chainId && assetNamespace === 'slip44';
  });
  return nativeAssetType;
});

/**
 * Gets the balance of the native token of the current network for the selected account.
 *
 * @param state - Redux state object
 * @param selectedAccount - Selected account
 * @returns Balance of the native token, or fallbacks to { amount: 0, unit: '' } if no native token is found
 */
const getMultichainNativeTokenBalance = exports.getMultichainNativeTokenBalance = (0, _util.createDeepEqualSelector)((_state, selectedAccount) => selectedAccount, _multichain.getMultichainBalances, getMultichainNativeAssetType, (selectedAccountAddress, multichainBalances, nativeAssetType) => {
  const balances = multichainBalances === null || multichainBalances === void 0 ? void 0 : multichainBalances[selectedAccountAddress.id];
  if (!nativeAssetType || !(balances !== null && balances !== void 0 && balances[nativeAssetType])) {
    return zeroBalanceAssetFallback;
  }
  return balances[nativeAssetType];
});

// Aggregated balance selectors using core pure function
/**
 * Returns the `metamask` slice with a safe empty fallback.
 *
 * @param state - Redux state used by balance selectors.
 * @returns The `metamask` slice or an empty object.
 */
const getMetamaskState = state => state.metamask ?? _shared.EMPTY_OBJECT;
const EMPTY_ACCOUNT_TREE = Object.freeze({
  wallets: {},
  selectedAccountGroup: ''
});

// Renamed for clarity
/**
 * Derives the minimal Account Tree payload needed by core balance functions.
 * Provides stable empty fallbacks for memoization resilience.
 *
 * @param state
 */
const selectAccountTreeStateForBalances = (0, _reselect.createSelector)([state => getMetamaskState(state).accountTree, state => getMetamaskState(state).accountGroupsMetadata, state => getMetamaskState(state).accountWalletsMetadata], (accountTree, accountGroupsMetadata, accountWalletsMetadata) => ({
  accountTree: accountTree ?? EMPTY_ACCOUNT_TREE,
  accountGroupsMetadata: accountGroupsMetadata ?? _shared.EMPTY_OBJECT,
  accountWalletsMetadata: accountWalletsMetadata ?? _shared.EMPTY_OBJECT
}));

/**
 * Picks internal accounts with defaults in the shape expected by core.
 *
 * @param state
 */
const selectAccountsStateForBalances = (0, _reselect.createSelector)([state => getMetamaskState(state).internalAccounts], internalAccounts => ({
  internalAccounts: internalAccounts ?? {
    accounts: {},
    selectedAccount: ''
  }
}));

/**
 * Wraps token balances for core balance computations.
 */
const selectTokenBalancesStateForBalances = (0, _reselect.createSelector)([_metamask.getTokenBalances], tokenBalances => ({
  tokenBalances
}));

/**
 * Exposes market data (rates) for core balance computations.
 */
const selectTokenRatesStateForBalances = (0, _reselect.createSelector)([_selectors.getMarketData], marketData => ({
  marketData
}));

/**
 * Provides conversion rates and historical prices with stable fallbacks.
 */
const selectMultichainRatesStateForBalances = (0, _reselect.createSelector)([getAssetsRates, getHistoricalPrices], (conversionRates, historicalPrices) => ({
  conversionRates: conversionRates ?? _shared.EMPTY_OBJECT,
  historicalPrices: historicalPrices ?? _shared.EMPTY_OBJECT
}));

/**
 * Wraps multichain balances for core balance computations.
 */
const selectMultichainBalancesStateForBalances = (0, _reselect.createSelector)([_multichain.getMultichainBalances], balances => ({
  balances
}));

/**
 * Normalizes tokens state and supplies explicit empty maps for optional pieces.
 *
 * @param state - Redux state providing `metamask.allTokens`.
 */
const selectTokensStateForBalances = (0, _reselect.createSelector)([state => getMetamaskState(state).allTokens], allTokens => ({
  allTokens: allTokens ?? _shared.EMPTY_OBJECT,
  allIgnoredTokens: _shared.EMPTY_OBJECT,
  allDetectedTokens: _shared.EMPTY_OBJECT
}));

/**
 * Exposes current user currency and currency rates with safe defaults.
 */
const selectCurrencyRateStateForBalances = (0, _reselect.createSelector)([_metamask.getCurrentCurrency, _selectors.getCurrencyRates], (currentCurrency, currencyRates) => ({
  currentCurrency: currentCurrency ?? 'usd',
  currencyRates: currencyRates ?? _shared.EMPTY_OBJECT
}));

/**
 * Returns the enabled network map as-is for filtering and eligibility checks.
 */
const selectEnabledNetworkMapForBalances = (0, _reselect.createSelector)([_selectors.getEnabledNetworks], map => map);

/**
 * Aggregates balances for all wallets and groups using core pure function.
 * Only the minimal controller state is composed to keep this selector lean.
 *
 * @param state - Redux state from which the required slices are derived.
 * @returns Aggregated balances structure for all wallets and groups.
 */
const selectBalanceForAllWallets = exports.selectBalanceForAllWallets = (0, _reselect.createSelector)([selectAccountTreeStateForBalances, selectAccountsStateForBalances, selectTokenBalancesStateForBalances, selectTokenRatesStateForBalances, selectMultichainRatesStateForBalances, selectMultichainBalancesStateForBalances, selectTokensStateForBalances, selectCurrencyRateStateForBalances, selectEnabledNetworkMapForBalances], (accountTreeState, accountsState, tokenBalancesState, tokenRatesState, multichainRatesState, multichainBalancesState, tokensState, currencyRateState, enabledNetworkMap) => (0, _assetsControllers.calculateBalanceForAllWallets)(
// TODO: fix this by ensuring @metamask/assets-controllers has proper types
accountTreeState, accountsState, tokenBalancesState, tokenRatesState, multichainRatesState, multichainBalancesState, tokensState, currencyRateState, enabledNetworkMap));

// Balance change selectors (period: '1d' | '7d' | '30d')
/**
 * Factory returning a selector that computes balance change across all wallets
 * for the provided period.
 *
 * @param period - Balance change period.
 */
const selectBalanceChangeForAllWallets = period => (0, _reselect.createSelector)([selectAccountTreeStateForBalances, selectAccountsStateForBalances, selectTokenBalancesStateForBalances, selectTokenRatesStateForBalances, selectMultichainRatesStateForBalances, selectMultichainBalancesStateForBalances, selectTokensStateForBalances, selectCurrencyRateStateForBalances, selectEnabledNetworkMapForBalances], (accountTreeState, accountsState, tokenBalancesState, tokenRatesState, multichainRatesState, multichainBalancesState, tokensState, currencyRateState, enabledNetworkMap) => (0, _assetsControllers.calculateBalanceChangeForAllWallets)(
// TODO: fix this by ensuring @metamask/assets-controllers has proper types
accountTreeState, accountsState, tokenBalancesState, tokenRatesState, multichainRatesState, multichainBalancesState, tokensState, currencyRateState, enabledNetworkMap, period));

/**
 * Convenience factory returning only the percent change for the given period.
 *
 * @param period - Balance change period.
 */
// Removed percent-only selector for all wallets to match mobile API surface

// Per-account-group balance change selectors using core helper
/**
 * Factory returning a selector that computes balance change for a specific
 * account group and period.
 *
 * @param groupId - Account group identifier.
 * @param period - Balance change period.
 */
exports.selectBalanceChangeForAllWallets = selectBalanceChangeForAllWallets;
const selectBalanceChangeByAccountGroup = (groupId, period) => (0, _reselect.createSelector)([selectAccountTreeStateForBalances, selectAccountsStateForBalances, selectTokenBalancesStateForBalances, selectTokenRatesStateForBalances, selectMultichainRatesStateForBalances, selectMultichainBalancesStateForBalances, selectTokensStateForBalances, selectCurrencyRateStateForBalances, selectEnabledNetworkMapForBalances], (accountTreeState, accountsState, tokenBalancesState, tokenRatesState, multichainRatesState, multichainBalancesState, tokensState, currencyRateState, enabledNetworkMap) => (0, _assetsControllers.calculateBalanceChangeForAccountGroup)(
// TODO: fix this by ensuring @metamask/assets-controllers has proper types
accountTreeState, accountsState, tokenBalancesState, tokenRatesState, multichainRatesState, multichainBalancesState, tokensState, currencyRateState, enabledNetworkMap, groupId, period));
exports.selectBalanceChangeByAccountGroup = selectBalanceChangeByAccountGroup;
const selectBalancePercentChangeByAccountGroup = (groupId, period) => (0, _reselect.createSelector)([selectBalanceChangeByAccountGroup(groupId, period)], change => change.percentChange);

/**
 * Computes balance change for the currently selected account group.
 * Returns null when no group is selected.
 *
 * @param period - Balance change period.
 */
exports.selectBalancePercentChangeByAccountGroup = selectBalancePercentChangeByAccountGroup;
const selectBalanceChangeBySelectedAccountGroup = period => (0, _reselect.createSelector)([selectAccountTreeStateForBalances, selectAccountsStateForBalances, selectTokenBalancesStateForBalances, selectTokenRatesStateForBalances, selectMultichainRatesStateForBalances, selectMultichainBalancesStateForBalances, selectTokensStateForBalances, selectCurrencyRateStateForBalances, selectEnabledNetworkMapForBalances], (accountTreeState, accountsState, tokenBalancesState, tokenRatesState, multichainRatesState, multichainBalancesState, tokensState, currencyRateState, enabledNetworkMap) => {
  var _accountTreeState$acc;
  const groupId = accountTreeState === null || accountTreeState === void 0 || (_accountTreeState$acc = accountTreeState.accountTree) === null || _accountTreeState$acc === void 0 ? void 0 : _accountTreeState$acc.selectedAccountGroup;
  if (!groupId) {
    return null;
  }
  return (0, _assetsControllers.calculateBalanceChangeForAccountGroup)(
  // TODO: fix this by ensuring @metamask/assets-controllers has proper types
  accountTreeState, accountsState, tokenBalancesState, tokenRatesState, multichainRatesState, multichainBalancesState, tokensState, currencyRateState, enabledNetworkMap, groupId, period);
});

/**
 * Selects the selected account group's balance entry from the aggregated
 * balances output, returning a minimal fallback when not present.
 *
 * @param state - Redux state used to read selection and aggregated balances.
 */
exports.selectBalanceChangeBySelectedAccountGroup = selectBalanceChangeBySelectedAccountGroup;
const selectBalanceBySelectedAccountGroup = exports.selectBalanceBySelectedAccountGroup = (0, _reselect.createSelector)([selectAccountTreeStateForBalances, selectBalanceForAllWallets], (accountTreeState, allBalances) => {
  var _accountTreeState$acc2;
  const selectedGroupId = accountTreeState === null || accountTreeState === void 0 || (_accountTreeState$acc2 = accountTreeState.accountTree) === null || _accountTreeState$acc2 === void 0 ? void 0 : _accountTreeState$acc2.selectedAccountGroup;
  if (!selectedGroupId) {
    return null;
  }
  const walletId = selectedGroupId.split('/')[0];
  const wallet = allBalances.wallets[walletId] ?? null;
  const {
    userCurrency
  } = allBalances;
  if (!(wallet !== null && wallet !== void 0 && wallet.groups[selectedGroupId])) {
    return {
      walletId,
      groupId: selectedGroupId,
      totalBalanceInUserCurrency: 0,
      userCurrency
    };
  }
  return wallet.groups[selectedGroupId];
});
const selectBalanceByAccountGroup = groupId => (0, _reselect.createSelector)([selectBalanceForAllWallets], allBalances => {
  const walletId = groupId.split('/')[0];
  const wallet = allBalances.wallets[walletId] ?? null;
  const {
    userCurrency
  } = allBalances;
  if (!(wallet !== null && wallet !== void 0 && wallet.groups[groupId])) {
    return {
      walletId,
      groupId,
      totalBalanceInUserCurrency: 0,
      userCurrency
    };
  }
  return wallet.groups[groupId];
});

/**
 * Returns a summary for a wallet's balance and its groups, with zeroed fallback
 * when the wallet entry does not exist in the aggregated output.
 *
 * @param walletId - Wallet identifier.
 */
exports.selectBalanceByAccountGroup = selectBalanceByAccountGroup;
const selectBalanceByWallet = walletId => (0, _reselect.createSelector)([selectBalanceForAllWallets], allBalances => {
  const wallet = allBalances.wallets[walletId] ?? null;
  const {
    userCurrency
  } = allBalances;
  if (!wallet) {
    return {
      walletId,
      totalBalanceInUserCurrency: 0,
      userCurrency,
      groups: {}
    };
  }
  return {
    walletId,
    totalBalanceInUserCurrency: wallet.totalBalanceInUserCurrency,
    userCurrency,
    groups: wallet.groups
  };
});
exports.selectBalanceByWallet = selectBalanceByWallet;
const getAssetsBySelectedAccountGroup = exports.getAssetsBySelectedAccountGroup = (0, _util.createDeepEqualSelector)(({
  metamask
}) => {
  const initialState = {
    accountTree: metamask.accountTree,
    internalAccounts: metamask.internalAccounts,
    allTokens: metamask.allTokens,
    allIgnoredTokens: metamask.allIgnoredTokens,
    tokenBalances: metamask.tokenBalances,
    marketData: metamask.marketData,
    currencyRates: metamask.currencyRates,
    currentCurrency: metamask.currentCurrency,
    networkConfigurationsByChainId: metamask.networkConfigurationsByChainId,
    accountsByChainId: metamask.accountsByChainId
  };
  let multichainState = {
    accountsAssets: {},
    assetsMetadata: {},
    balances: {},
    conversionRates: {}
  };

  ///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
  multichainState = {
    accountsAssets: metamask.accountsAssets,
    assetsMetadata: metamask.assetsMetadata,
    balances: metamask.balances,
    conversionRates: metamask.conversionRates
  };
  ///: END:ONLY_INCLUDE_IF

  return {
    ...initialState,
    ...multichainState
  };
}, assetListState => (0, _assetsControllers.selectAssetsBySelectedAccountGroup)(assetListState));

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\assets.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\dapp.ts", {"../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../shared/modules/selectors/util":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\util.js","./multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","./selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Cdapp.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDappActiveNetwork = void 0;
var _keyringApi = require("@metamask/keyring-api");
var _networks = require("../../shared/modules/selectors/networks");
var _util = require("../../shared/modules/selectors/util");
var _selectors = require("./selectors");
var _multichain = require("./multichain");
const getDappActiveNetwork = exports.getDappActiveNetwork = (0, _util.createDeepEqualSelector)(_selectors.getOrderedConnectedAccountsForActiveTab, _selectors.getOriginOfCurrentTab, _selectors.getAllDomains, _networks.getNetworkConfigurationsByChainId, _multichain.getMultichainNetworkConfigurationsByChainId, (orderedConnectedAccounts, activeTabOrigin, allDomains, networkConfigurationsByChainId, multichainNetworkConfigurationsByChainId) => {
  if (!orderedConnectedAccounts || orderedConnectedAccounts.length === 0) {
    return null;
  }
  const selectedAccount = orderedConnectedAccounts[0];

  // Check if account is EVM or non-EVM using existing helper
  const isEvmAccount = (0, _keyringApi.isEvmAccountType)(selectedAccount.type);
  if (isEvmAccount) {
    if (!activeTabOrigin || !allDomains) {
      return null;
    }
    const networkClientId = allDomains[activeTabOrigin];
    if (!networkClientId) {
      return null;
    }
    for (const chainId in networkConfigurationsByChainId) {
      if (Object.prototype.hasOwnProperty.call(networkConfigurationsByChainId, chainId)) {
        const network = networkConfigurationsByChainId[chainId];
        const hasMatchingEndpoint = network.rpcEndpoints.some(rpcEndpoint => rpcEndpoint.networkClientId === networkClientId);
        if (hasMatchingEndpoint) {
          return {
            ...network,
            isEvm: true
          };
        }
      }
    }
  } else {
    // TODO: Add support for other networks (Bitcoin, Solana)
    const nonEvmScope = selectedAccount.scopes.find(scope => scope.startsWith('solana:'));
    if (nonEvmScope) {
      const network = multichainNetworkConfigurationsByChainId[nonEvmScope];
      if (network) {
        return {
          ...network,
          isEvm: false
        };
      }
    }
  }
  return null;
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\dapp.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\gator-permissions\\gator-permissions.ts", {"@metamask/gator-permissions-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\gator-permissions-controller\\dist\\index.cjs","reselect":"D:\\code\\v\\metamask-extension\\node_modules\\reselect\\dist\\cjs\\reselect.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Cgator-permissions%5Cgator-permissions.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPermissionGroupDetails = exports.getGatorPermissionsMap = exports.getAggregatedGatorPermissionsCountAcrossAllChains = void 0;
var _reselect = require("reselect");
var _gatorPermissionsController = require("@metamask/gator-permissions-controller");
// chainId -> total

const getMetamask = state => state.metamask;

/**
 * Get gator permissions map from GatorPermissionsController.
 *
 * @param state - The current state
 * @returns Gator permissions map
 * @example
 * const gatorPermissionsMap = getGatorPermissionsMap(state);
 *
 * // {
 * //   'native-token-stream': {
 * //     '0x1': [permission1, permission2],
 * //     '0x89': [permission3, permission4],
 * //   },
 * //   'native-token-periodic': {
 * //     '0x1': [permission5, permission6],
 * //     '0x89': [permission7, permission8],
 * //   },
 * //   ...
 * // }
 */
const getGatorPermissionsMap = exports.getGatorPermissionsMap = (0, _reselect.createSelector)([getMetamask], metamask => (0, _gatorPermissionsController.deserializeGatorPermissionsMap)(metamask.gatorPermissionsMapSerialized));

/**
 * Get the count of gator permissions for a specific permission type across all chains.
 *
 * @param gatorPermissionsMap - The gator permissions map
 * @param permissionType - The permission type to get permissions for (e.g. 'native-token-stream')
 * @returns The count of gator permissions for the permission type across all chains
 */
function getGatorPermissionsCountAcrossAllChainsByPermissionType(gatorPermissionsMap, permissionType) {
  // check if any undefined values are present
  const allPermissionsAcrossAllChains = Object.values(gatorPermissionsMap[permissionType]).flat();
  for (const gatorPermission of allPermissionsAcrossAllChains) {
    if (!gatorPermission) {
      throw new Error(`Undefined values present in the gatorPermissionsMap for permission type: ${permissionType}`);
    }
  }
  return allPermissionsAcrossAllChains.length;
}

/**
 * Get aggregated list of gator permissions for all chains.
 *
 * @param _state - The current state
 * @param aggregatedPermissionType - The aggregated permission type to get permissions for (e.g. 'token-transfer' is a combination of the token streams and token subscriptions types)
 * @returns A aggregated list of gator permissions count.
 */
const getAggregatedGatorPermissionsCountAcrossAllChains = exports.getAggregatedGatorPermissionsCountAcrossAllChains = (0, _reselect.createSelector)([getGatorPermissionsMap, (_state, aggregatedPermissionType) => aggregatedPermissionType], (gatorPermissionsMap, aggregatedPermissionType) => {
  switch (aggregatedPermissionType) {
    case 'token-transfer':
      {
        const nativeTokenStreams = getGatorPermissionsCountAcrossAllChainsByPermissionType(gatorPermissionsMap, 'native-token-stream');
        const erc20TokenStreams = getGatorPermissionsCountAcrossAllChainsByPermissionType(gatorPermissionsMap, 'erc20-token-stream');
        const nativeTokenPeriodicPermissions = getGatorPermissionsCountAcrossAllChainsByPermissionType(gatorPermissionsMap, 'native-token-periodic');
        const erc20TokenPeriodicPermissions = getGatorPermissionsCountAcrossAllChainsByPermissionType(gatorPermissionsMap, 'erc20-token-periodic');
        return nativeTokenStreams + erc20TokenStreams + nativeTokenPeriodicPermissions + erc20TokenPeriodicPermissions;
      }
    default:
      {
        return 0;
      }
  }
});

/**
 * Merge two records of chainId to total count of gator permissions.
 *
 * @param record1 - The first record to merge
 * @param record2 - The second record to merge
 * @returns A merged record of chainId to total count of gator permissions
 */
function mergePermissionsGroupDetailRecords(record1, record2) {
  const mergedRecord = {
    ...record1
  };
  for (const [key, value] of Object.entries(record2)) {
    mergedRecord[key] = (mergedRecord[key] || 0) + value;
  }
  return mergedRecord;
}

/**
 * Get the total count of gator permissions of a specific permission type across chains.
 *
 * @param permissionsMapByPermissionType - The map of gator permissions by permission type
 * @returns A record of chainId to total count of gator permissions
 */
function getTotalCountOfGatorPermissionsPerChainId(permissionsMapByPermissionType) {
  const flattenedGatorPermissionsAcrossAllChains = Object.values(permissionsMapByPermissionType).flat();
  const permissionsGroupDetailRecord = {};
  return flattenedGatorPermissionsAcrossAllChains.reduce((acc, gatorPermission) => {
    const {
      permissionResponse
    } = gatorPermission;
    acc[permissionResponse.chainId] = (acc[permissionResponse.chainId] || 0) + 1;
    return acc;
  }, permissionsGroupDetailRecord);
}

/**
 * Get gator permissions group details.
 *
 * @param _state - The current state
 * @param permissionGroupName - The type of list to get (token-transfer, spending-cap, nft, custom, etc.)
 * @returns A list of gator permissions group details.
 * @example
 * const permissionGroupDetails = getPermissionsGroupDetails(state, 'token-transfer');
 *
 * // [{
 * //   chainId: '0x1',
 * //   total: 2,
 * // },
 * // {
 * //   chainId: '0x89',
 * //   total: 2,
 * // }
 * ]
 */
const getPermissionGroupDetails = exports.getPermissionGroupDetails = (0, _reselect.createSelector)([getGatorPermissionsMap, (_state, permissionGroupName) => permissionGroupName], (gatorPermissionsMap, permissionGroupName) => {
  switch (permissionGroupName) {
    case 'token-transfer':
      {
        const streamsPermissionsCountPerChainId = mergePermissionsGroupDetailRecords(getTotalCountOfGatorPermissionsPerChainId(gatorPermissionsMap['native-token-stream']), getTotalCountOfGatorPermissionsPerChainId(gatorPermissionsMap['erc20-token-stream']));
        const periodicPermissionsCountPerChainId = mergePermissionsGroupDetailRecords(getTotalCountOfGatorPermissionsPerChainId(gatorPermissionsMap['native-token-periodic']), getTotalCountOfGatorPermissionsPerChainId(gatorPermissionsMap['erc20-token-periodic']));
        const totalPermissionsCountPerChainId = mergePermissionsGroupDetailRecords(streamsPermissionsCountPerChainId, periodicPermissionsCountPerChainId);
        return Object.entries(totalPermissionsCountPerChainId).map(([chainId, total]) => ({
          chainId: chainId,
          total
        }));
      }
    default:
      return [];
  }
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\gator-permissions\\gator-permissions.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\identity\\authentication.ts", {"reselect":"D:\\code\\v\\metamask-extension\\node_modules\\reselect\\dist\\cjs\\reselect.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Cidentity%5Cauthentication.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectSessionData = exports.selectIsSignedIn = void 0;
var _reselect = require("reselect");
const getMetamask = state => state.metamask;

/**
 * Selector to determine if the user is signed in.
 *
 * This selector retrieves the `isSignedIn` property from the `metamask` state using the `createSelector` function from 'reselect'.
 * It provides a memoized selector that returns the sign-in status of the user.
 *
 * @param {AppState} state - The current state of the Redux store.
 * @returns {boolean} Returns true if the user is signed in, false otherwise.
 */
const selectIsSignedIn = exports.selectIsSignedIn = (0, _reselect.createSelector)([getMetamask], metamask => metamask.isSignedIn);

/**
 * Selector to retrieve the primary SRP session data.
 *
 * This selector fetches the `srpSessionData` from the `metamask` state using the `createSelector` function, and gets the first entry.
 * It provides a memoized selector that returns the session data stored in the MetaMask state.
 *
 * @param {AppState} state - The current state of the Redux store.
 * @returns {any} Returns the session data associated with the current user session.
 */
const selectSessionData = exports.selectSessionData = (0, _reselect.createSelector)([getMetamask], metamask => {
  var _Object$entries;
  return metamask.srpSessionData ? (_Object$entries = Object.entries(metamask.srpSessionData)) === null || _Object$entries === void 0 || (_Object$entries = _Object$entries[0]) === null || _Object$entries === void 0 ? void 0 : _Object$entries[1] : undefined;
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\identity\\authentication.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\identity\\backup-and-sync.ts", {"reselect":"D:\\code\\v\\metamask-extension\\node_modules\\reselect\\dist\\cjs\\reselect.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Cidentity%5Cbackup-and-sync.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectIsContactSyncingEnabled = exports.selectIsBackupAndSyncUpdateLoading = exports.selectIsBackupAndSyncEnabled = exports.selectIsAccountSyncingEnabled = void 0;
var _reselect = require("reselect");
const getMetamask = state => state.metamask;

/**
 * Selector to determine if backup and sync is enabled.
 *
 * This selector uses the `createSelector` function from 'reselect' to compute whether backup and sync is enabled,
 * based on the `isBackupAndSyncEnabled` property of the `metamask` object in the Redux store.
 *
 * @param {AppState} state - The current state of the Redux store.
 * @returns {boolean} Returns true if backup and sync is enabled, false otherwise.
 */
const selectIsBackupAndSyncEnabled = exports.selectIsBackupAndSyncEnabled = (0, _reselect.createSelector)([getMetamask], metamask => metamask.isBackupAndSyncEnabled);

/**
 * Selector to determine if the backup and sync update is currently loading.
 *
 * This selector uses the `createSelector` function from 'reselect' to compute whether the update process for backup and sync is currently in a loading state,
 * based on the `isBackupAndSyncUpdateLoading` property of the `metamask` object in the Redux store.
 *
 * @param {AppState} state - The current state of the Redux store.
 * @returns {boolean} Returns true if the backup and sync update is loading, false otherwise.
 */
const selectIsBackupAndSyncUpdateLoading = exports.selectIsBackupAndSyncUpdateLoading = (0, _reselect.createSelector)([getMetamask], metamask => {
  return metamask.isBackupAndSyncUpdateLoading;
});

/**
 * Selector to determine if account syncing is enabled.
 *
 * This selector uses the `createSelector` function from 'reselect' to compute whether account syncing is enabled,
 * based on the `hasFinishedAddingAccountsWithBalance` property of the `metamask` object in the Redux store.
 *
 * @param {AppState} state - The current state of the Redux store.
 * @returns {boolean} Returns true if account syncing is enabled, false otherwise.
 */
const selectIsAccountSyncingEnabled = exports.selectIsAccountSyncingEnabled = (0, _reselect.createSelector)([getMetamask], metamask => {
  return metamask.isAccountSyncingEnabled;
});

/**
 * Selector to determine if contact syncing is enabled.
 *
 * This selector uses the `createSelector` function from 'reselect' to compute whether contact syncing is enabled,
 * based on the `isContactSyncingEnabled` property of the `metamask` object in the Redux store.
 */
const selectIsContactSyncingEnabled = exports.selectIsContactSyncingEnabled = (0, _reselect.createSelector)([getMetamask], metamask => {
  return metamask.isContactSyncingEnabled;
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\identity\\backup-and-sync.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\metamask-notifications\\metamask-notifications.ts", {"../../../shared/modules/selectors/util":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\util.js","../remote-feature-flags":"D:\\code\\v\\metamask-extension\\ui\\selectors\\remote-feature-flags.ts","@metamask/notification-services-controller/notification-services":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\notification-services-controller\\dist\\NotificationServicesController\\index.cjs","reselect":"D:\\code\\v\\metamask-extension\\node_modules\\reselect\\dist\\cjs\\reselect.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Cmetamask-notifications%5Cmetamask-notifications.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIsCheckingAccountsPresence = exports.getFeatureAnnouncementsUnreadCount = exports.getFeatureAnnouncementsReadCount = void 0;
exports.getIsNotificationEnabledByDefaultFeatureFlag = getIsNotificationEnabledByDefaultFeatureFlag;
exports.selectIsMetamaskNotificationsFeatureSeen = exports.selectIsMetamaskNotificationsEnabled = exports.selectIsFeatureAnnouncementsEnabled = exports.isFetchingMetamaskNotifications = exports.getValidNotificationAccounts = exports.getSnapNotificationsUnreadCount = exports.getSnapNotificationsReadCount = exports.getOnChainMetamaskNotificationsUnreadCount = exports.getOnChainMetamaskNotificationsReadCount = exports.getMetamaskNotificationsUnreadCount = exports.getMetamaskNotificationsReadList = exports.getMetamaskNotifications = exports.getMetamaskNotificationById = exports.getIsUpdatingMetamaskNotificationsAccount = exports.getIsUpdatingMetamaskNotifications = void 0;
var _reselect = require("reselect");
var _notificationServices = require("@metamask/notification-services-controller/notification-services");
var _util = require("../../../shared/modules/selectors/util");
var _remoteFeatureFlags = require("../remote-feature-flags");
// @ts-check

const getMetamask = state => ({
  ..._notificationServices.defaultState,
  ...state.metamask
});

/**
 * Get the state of the `defiPositionsEnabled` remote feature flag.
 *
 * @param state
 * @returns The state of the `defiPositionsEnabled` remote feature flag.
 */
function getIsNotificationEnabledByDefaultFeatureFlag(state) {
  const {
    assetsEnableNotificationsByDefaultV2
  } = (0, _remoteFeatureFlags.getRemoteFeatureFlags)(state);
  const result = assetsEnableNotificationsByDefaultV2 && typeof assetsEnableNotificationsByDefaultV2 === 'object' && 'value' in assetsEnableNotificationsByDefaultV2 && Boolean(assetsEnableNotificationsByDefaultV2.value);
  return Boolean(result);
}

/**
 * Selector to get the list of MetaMask notifications.
 *
 * @param {NotificationAppState} state - The current state of the Redux store.
 * @returns {Notification[]} An array of notifications.
 */
const getMetamaskNotifications = exports.getMetamaskNotifications = (0, _reselect.createSelector)([getMetamask], metamask => {
  return metamask.metamaskNotificationsList;
});

/**
 * Factory function to create a selector that retrieves a specific MetaMask notification by ID.
 *
 * This function returns a selector that is tailored to fetch a notification by its ID.
 *
 * @param id - The ID of the notification to retrieve.
 * @returns A selector function that takes the AppState and returns the notification.
 */
const getMetamaskNotificationById = id => {
  return (0, _util.createDeepEqualSelector)([getMetamaskNotifications], notifications => {
    return notifications.find(notification => notification.id === id);
  });
};

/**
 * Selector to get the list of read MetaMask notifications.
 *
 * @param {NotificationAppState} state - The current state of the Redux store.
 * @returns {string[]} An array of notifications that have been read.
 */
exports.getMetamaskNotificationById = getMetamaskNotificationById;
const getMetamaskNotificationsReadList = exports.getMetamaskNotificationsReadList = (0, _reselect.createSelector)([getMetamask], metamask => metamask.metamaskNotificationsReadList);

/**
 * Selector to get the count of unread MetaMask notifications.
 *
 * @param {NotificationAppState} state - The current state of the Redux store.
 * @returns {number} The count of notifications that have not been read.
 */
const getMetamaskNotificationsUnreadCount = exports.getMetamaskNotificationsUnreadCount = (0, _reselect.createSelector)([getMetamaskNotifications], notifications => {
  return notifications ? notifications.filter(notification => !notification.isRead).length : 0;
});

/**
 * Selector to get the count of unread feature announcement notifications.
 *
 * @param {NotificationAppState} state - The current state of the Redux store.
 * @returns {number} The count of unread feature announcement notifications.
 */
const getFeatureAnnouncementsUnreadCount = exports.getFeatureAnnouncementsUnreadCount = (0, _reselect.createSelector)([getMetamaskNotifications], notifications => {
  return notifications ? notifications.filter(notification => !notification.isRead && notification.type === _notificationServices.TRIGGER_TYPES.FEATURES_ANNOUNCEMENT).length : 0;
});

/**
 * Selector to get the count of read feature announcement notifications.
 *
 * @param {NotificationAppState} state - The current state of the Redux store.
 * @returns {number} The count of read feature announcement notifications.
 */
const getFeatureAnnouncementsReadCount = exports.getFeatureAnnouncementsReadCount = (0, _reselect.createSelector)([getMetamaskNotifications], notifications => {
  return notifications ? notifications.filter(notification => notification.isRead && notification.type === _notificationServices.TRIGGER_TYPES.FEATURES_ANNOUNCEMENT).length : 0;
});

/**
 * Selector to get the count of unread snap notifications.
 *
 * @param {NotificationAppState} state - The current state of the Redux store.
 * @returns {number} The count of unread snap notifications.
 */
const getSnapNotificationsUnreadCount = exports.getSnapNotificationsUnreadCount = (0, _reselect.createSelector)([getMetamaskNotifications], notifications => {
  return notifications ? notifications.filter(notification => !notification.isRead && notification.type === _notificationServices.TRIGGER_TYPES.SNAP).length : 0;
});

/**
 * Selector to get the count of read snap notifications.
 *
 * @param {NotificationAppState} state - The current state of the Redux store.
 * @returns {number} The count of read snap notifications.
 */
const getSnapNotificationsReadCount = exports.getSnapNotificationsReadCount = (0, _reselect.createSelector)([getMetamaskNotifications], notifications => {
  return notifications ? notifications.filter(notification => notification.isRead && notification.type === _notificationServices.TRIGGER_TYPES.SNAP).length : 0;
});

/**
 * Selector to get the count of unread non-feature announcement notifications.
 *
 * @param {NotificationAppState} state - The current state of the Redux store.
 * @returns {number} The count of unread non-feature announcement notifications.
 */
const getOnChainMetamaskNotificationsUnreadCount = exports.getOnChainMetamaskNotificationsUnreadCount = (0, _reselect.createSelector)([getMetamaskNotifications], notifications => {
  return notifications ? notifications.filter(notification => !notification.isRead && notification.type !== _notificationServices.TRIGGER_TYPES.FEATURES_ANNOUNCEMENT && notification.type !== _notificationServices.TRIGGER_TYPES.SNAP).length : 0;
});

/**
 * Selector to get the count of read non-feature announcement notifications.
 *
 * @param {NotificationAppState} state - The current state of the Redux store.
 * @returns {number} The count of read non-feature announcement notifications.
 */
const getOnChainMetamaskNotificationsReadCount = exports.getOnChainMetamaskNotificationsReadCount = (0, _reselect.createSelector)([getMetamaskNotifications], notifications => {
  return notifications ? notifications.filter(notification => notification.isRead && notification.type !== _notificationServices.TRIGGER_TYPES.FEATURES_ANNOUNCEMENT && notification.type !== _notificationServices.TRIGGER_TYPES.SNAP).length : 0;
});

/**
 * Selector to determine if the MetaMask notifications feature has been seen by the user.
 *
 * @param {NotificationAppState} state - The current state of the Redux store.
 * @returns {boolean} Returns true if the MetaMask notifications feature has been seen, false otherwise.
 */
const selectIsMetamaskNotificationsFeatureSeen = exports.selectIsMetamaskNotificationsFeatureSeen = (0, _reselect.createSelector)([getMetamask], metamask => metamask.isMetamaskNotificationsFeatureSeen);

/**
 * Selector to determine if MetaMask notifications are enabled.
 *
 * @param {NotificationAppState} state - The current state of the Redux store.
 * @returns {boolean} Returns true if MetaMask notifications are enabled, false otherwise.
 */
const selectIsMetamaskNotificationsEnabled = exports.selectIsMetamaskNotificationsEnabled = (0, _reselect.createSelector)([getMetamask], metamask => metamask.isNotificationServicesEnabled);

/**
 * Selector to determine if feature announcements are enabled.
 *
 * @param {NotificationAppState} state - The current state of the Redux store.
 * @returns {boolean} Returns true if feature announcements are enabled, false otherwise.
 */
const selectIsFeatureAnnouncementsEnabled = exports.selectIsFeatureAnnouncementsEnabled = (0, _reselect.createSelector)([getMetamask], metamask => metamask.isFeatureAnnouncementsEnabled);

/**
 * Selector to determine if MetaMask notifications are currently being created.
 *
 * This selector checks the `isUpdatingMetamaskNotifications` property of the `metamask` state to see if the notifications are in the process of being created.
 * It uses the `createSelector` function from 'reselect' for memoization, improving performance by avoiding unnecessary recalculations.
 *
 * @param state - The current state of the Redux store.
 * @returns Returns true if MetaMask notifications are being created, false otherwise.
 */
const getIsUpdatingMetamaskNotifications = exports.getIsUpdatingMetamaskNotifications = (0, _reselect.createSelector)([getMetamask], metamask => metamask.isUpdatingMetamaskNotifications);

/**
 * Selector to determine if MetaMask notifications are currently being fetched.
 *
 * This selector accesses the `isFetchingMetamaskNotifications` property from the `metamask` state to check if the notifications are currently being fetched.
 * It leverages the `createSelector` function for memoization, which helps in optimizing the performance by caching the result until the input selectors' outputs change.
 *
 * @param {NotificationAppState} state - The current state of the Redux store.
 * @returns {boolean} Returns true if MetaMask notifications are being fetched, false otherwise.
 */
const isFetchingMetamaskNotifications = exports.isFetchingMetamaskNotifications = (0, _reselect.createSelector)([getMetamask], metamask => metamask.isFetchingMetamaskNotifications);

/**
 * Selector to determine if the MetaMask notifications account is currently being updated.
 *
 * This selector checks the `isUpdatingMetamaskNotificationsAccount` property of the `metamask` state to see if the account associated with MetaMask notifications is in the process of being updated.
 * It uses the `createSelector` function from 'reselect' for memoization, improving performance by avoiding unnecessary recalculations.
 *
 * @param {NotificationAppState} state - The current state of the Redux store.
 * @returns {string[]} Returns list of accounts that are currently being updated.
 */
const getIsUpdatingMetamaskNotificationsAccount = exports.getIsUpdatingMetamaskNotificationsAccount = (0, _reselect.createSelector)([getMetamask], metamask => {
  return metamask.isUpdatingMetamaskNotificationsAccount;
});

/**
 * Selector to determine if the presence of accounts is currently being checked.
 *
 * This selector accesses the `isCheckingAccountsPresence` property from the `metamask` state to check if the system is currently verifying the presence of accounts.
 * It leverages the `createSelector` function for memoization, which helps in optimizing performance by caching the result until the input selectors' outputs change.
 *
 * @param {NotificationAppState} state - The current state of the Redux store.
 * @returns {boolean} Returns true if the account presence check is ongoing, false otherwise.
 */
const getIsCheckingAccountsPresence = exports.getIsCheckingAccountsPresence = (0, _reselect.createSelector)([getMetamask], metamask => metamask.isCheckingAccountsPresence);
const getValidNotificationAccounts = exports.getValidNotificationAccounts = (0, _reselect.createSelector)([getMetamask], metamask => metamask.subscriptionAccountsSeen);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\metamask-notifications\\metamask-notifications.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\multi-srp\\multi-srp.ts", {"..":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../shared/lib/accounts/snaps":"D:\\code\\v\\metamask-extension\\shared\\lib\\accounts\\snaps.ts","../../../shared/lib/snaps/snaps":"D:\\code\\v\\metamask-extension\\shared\\lib\\snaps\\snaps.ts","../../../shared/modules/selectors/util":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\util.js","../../../shared/modules/string-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\string-utils.ts","../assets":"D:\\code\\v\\metamask-extension\\ui\\selectors\\assets.ts","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Cmulti-srp%5Cmulti-srp.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSnapAccountsByKeyringId = exports.getShouldShowSeedPhraseReminder = void 0;
var _keyringApi = require("@metamask/keyring-api");
var _ = require("..");
var _util = require("../../../shared/modules/selectors/util");
var _assets = require("../assets");
var _snaps = require("../../../shared/lib/accounts/snaps");
var _stringUtils = require("../../../shared/modules/string-utils");
var _snaps2 = require("../../../shared/lib/snaps/snaps");
const isPrimaryHdAndFirstPartySnapAccount = (0, _util.createDeepEqualSelector)((_state, account) => account, _.getMetaMaskHdKeyrings, (account, hdKeyrings) => {
  var _account$options;
  const [primaryKeyring] = hdKeyrings;

  // There are no keyrings during onboarding.
  if (!primaryKeyring) {
    return false;
  }
  if (primaryKeyring.accounts.find(address => (0, _stringUtils.isEqualCaseInsensitive)(account.address, address))) {
    return true;
  }
  if (account.metadata.snap && (0, _snaps.isMultichainWalletSnap)(account.metadata.snap.id) && ((_account$options = account.options) === null || _account$options === void 0 ? void 0 : _account$options.entropySource) === primaryKeyring.metadata.id) {
    return true;
  }
  return false;
});
const getShouldShowSeedPhraseReminder = exports.getShouldShowSeedPhraseReminder = (0, _util.createDeepEqualSelector)(state => state, (_state, account) => account, _.getSelectedAccountTokensAcrossChains, _.getCrossChainMetaMaskCachedBalances, (state, account) => (0, _assets.getMultichainAggregatedBalance)(state, account), (state, account) => isPrimaryHdAndFirstPartySnapAccount(state, account), (state, account, tokens, crossChainBalances, aggregatedBalance, isAccountAPrimaryHdOrFirstPartySnapAccount) => {
  const {
    seedPhraseBackedUp,
    dismissSeedBackUpReminder
  } = state.metamask;

  // If there is no account, we don't need to show the seed phrase reminder
  // or if the account is not a primary HD or first party snap account
  // It is assumed that imported srp accounts are backed up
  if (!account || !isAccountAPrimaryHdOrFirstPartySnapAccount) {
    return false;
  }
  let hasBalance = false;
  if ((0, _keyringApi.isEvmAccountType)(account.type)) {
    hasBalance = Object.values(tokens).some(chains => {
      return chains.some(chain => chain.balance && parseInt(chain.balance, 16) > 0);
    }) || Object.values(crossChainBalances).some(chain => {
      return (chain === null || chain === void 0 ? void 0 : chain[account.address]) && parseInt(chain === null || chain === void 0 ? void 0 : chain[account.address], 16) > 0;
    });
  } else {
    hasBalance = aggregatedBalance > 0;
  }
  const showMessage = seedPhraseBackedUp === false && hasBalance && dismissSeedBackUpReminder === false;
  return showMessage;
});
const getSnapAccountsByKeyringId = exports.getSnapAccountsByKeyringId = (0, _util.createDeepEqualSelector)(_.getInternalAccounts, (_state, keyringId) => keyringId, (accounts, keyringId) => {
  return accounts.filter(account => {
    var _account$options2;
    return account.metadata.snap && (0, _snaps2.isSnapPreinstalled)(account.metadata.snap.id) && ((_account$options2 = account.options) === null || _account$options2 === void 0 ? void 0 : _account$options2.entropySource) === keyringId;
  });
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\multi-srp\\multi-srp.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts", {"../../../shared/modules/selectors/util":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\util.js","../../helpers/utils/network-helper":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\network-helper.ts","../accounts":"D:\\code\\v\\metamask-extension\\ui\\selectors\\accounts.ts","../multichain/networks":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain\\networks.ts","../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","./utils":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\utils.ts","@metamask/account-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\index.cjs","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","reselect":"D:\\code\\v\\metamask-extension\\node_modules\\reselect\\dist\\cjs\\reselect.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Cmultichain-accounts%5Caccount-tree.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getWalletsWithAccountsSimplified = exports.getWalletsWithAccounts = exports.getWalletIdAndNameByAccountAddress = exports.getWallet = exports.getSingleAccountGroups = exports.getSelectedAccountGroup = exports.getNormalizedGroupsMetadata = exports.getNetworkAddressCount = exports.getMultichainAccountsToScopesMap = exports.getMultichainAccountsByWalletId = exports.getMultichainAccountGroups = exports.getMultichainAccountGroupById = exports.getInternalAccountsFromGroupById = exports.getInternalAccountListSpreadByScopesByGroupId = exports.getInternalAccountBySelectedAccountGroupAndCaip = exports.getInternalAccountByGroupAndCaip = exports.getIconSeedAddressesByAccountGroups = exports.getIconSeedAddressByAccountGroupId = exports.getCaip25IdByAccountGroupAndScope = exports.getAllAccountGroups = exports.getAccountTree = exports.getAccountGroupsByScopes = exports.getAccountGroupsByAddress = exports.getAccountGroupWithInternalAccounts = void 0;
var _accountApi = require("@metamask/account-api");
var _keyringApi = require("@metamask/keyring-api");
var _reselect = require("reselect");
var _utils = require("@metamask/utils");
var _util = require("../../../shared/modules/selectors/util");
var _selectors = require("../selectors");
var _accounts = require("../accounts");
var _networks = require("../multichain/networks");
var _networkHelper = require("../../helpers/utils/network-helper");
var _utils2 = require("./utils");
/**
 * Retrieve account tree state.
 *
 * @param state - Redux state.
 * @param state.metamask - MetaMask state object.
 * @param state.metamask.accountTree - Account tree state object.
 * @returns Account tree state.
 */
const getAccountTree = state => state.metamask.accountTree;

/**
 * Common function to create consolidated wallets with accounts.
 *
 * @param internalAccounts - All available internal accounts.
 * @param accountTree - Account tree state.
 * @param connectedAccounts - Connected accounts for active tab.
 * @param selectedAccount - Currently selected account.
 * @param pinnedAccounts - List of pinned account addresses.
 * @param hiddenAccounts - List of hidden account addresses.
 * @param getAccountsForGroup - Function to determine which accounts belong to each group.
 * @returns Consolidated wallet collection with accounts metadata.
 */
exports.getAccountTree = getAccountTree;
const createConsolidatedWallets = (internalAccounts, accountTree, connectedAccounts, selectedAccount, pinnedAccounts, hiddenAccounts, getAccountsForGroup) => {
  // Precompute lookups for pinned and hidden accounts
  const pinnedAccountsSet = new Set(pinnedAccounts);
  const hiddenAccountsSet = new Set(hiddenAccounts);

  // Precompute connected account IDs for faster lookup
  const connectedAccountIdsSet = new Set(connectedAccounts.map(account => account.id));

  // Create a mapping of accounts by ID for quick access
  const accountsById = internalAccounts.reduce((accounts, account) => {
    accounts[account.id] = account;
    return accounts;
  }, {});
  const {
    wallets
  } = accountTree;
  return Object.entries(wallets).reduce((consolidatedWallets, [walletId, wallet]) => {
    consolidatedWallets[walletId] = {
      id: walletId,
      type: wallet.type,
      metadata: wallet.metadata,
      groups: {}
    };

    // Collect all accountIds used in any group's accounts array for this wallet
    const allAccountIdsInWallet = Array.from(new Set(Object.values(wallet.groups).flatMap(group => group.accounts)));
    Object.entries(wallet.groups).forEach(([groupId, group], groupIndex) => {
      const accountIds = getAccountsForGroup(group.accounts, groupIndex, allAccountIdsInWallet, accountsById);
      const accountsFromGroup = accountIds.map(accountId => {
        const accountWithMetadata = {
          ...accountsById[accountId]
        };

        // Set flags for pinned, hidden, and active accounts
        accountWithMetadata.pinned = pinnedAccountsSet.has(accountWithMetadata.address);
        accountWithMetadata.hidden = hiddenAccountsSet.has(accountWithMetadata.address);
        accountWithMetadata.active = selectedAccount.id === accountWithMetadata.id && connectedAccountIdsSet.has(accountWithMetadata.id);
        return accountWithMetadata;
      });
      consolidatedWallets[walletId].groups[groupId] = {
        id: groupId,
        type: group.type,
        metadata: group.metadata,
        accounts: accountsFromGroup
      };
    });
    return consolidatedWallets;
  }, {});
};

/**
 * Retrieve all wallets and their accounts with metadata in consolidated data structure.
 *
 * @param internalAccounts - All available internal accounts.
 * @param accountTree - Account tree state.
 * @returns Consolidated wallet collection with accounts metadata.
 */
const getWalletsWithAccounts = exports.getWalletsWithAccounts = (0, _util.createDeepEqualSelector)(_selectors.getMetaMaskAccountsOrdered, getAccountTree, _selectors.getOrderedConnectedAccountsForActiveTab, _accounts.getSelectedInternalAccount, _selectors.getPinnedAccountsList, _selectors.getHiddenAccountsList, (internalAccounts, accountTree, connectedAccounts, selectedAccount, pinnedAccounts, hiddenAccounts) => {
  return createConsolidatedWallets(internalAccounts, accountTree, connectedAccounts, selectedAccount, pinnedAccounts, hiddenAccounts,
  // Standard behavior: use the group's original accounts
  groupAccounts => groupAccounts);
});

/**
 * Retrieve the normalized groups metadata.
 *
 * @param accountTree - Account tree state.
 * @param internalAccountsObject - The internal accounts object.
 * @returns The normalized group metadata.
 */
const getNormalizedGroupsMetadata = exports.getNormalizedGroupsMetadata = (0, _util.createDeepEqualSelector)(getAccountTree, _accounts.getInternalAccountsObject, (accountTree, internalAccountsObject) => {
  const {
    wallets
  } = accountTree;
  const result = {};
  for (const wallet of Object.values(wallets)) {
    for (const group of Object.values(wallet.groups)) {
      var _group$metadata;
      result[group.id] = {
        name: ((_group$metadata = group.metadata) === null || _group$metadata === void 0 || (_group$metadata = _group$metadata.name) === null || _group$metadata === void 0 ? void 0 : _group$metadata.toLowerCase()) ?? '',
        accounts: group.accounts.map(accountId => {
          var _internalAccountsObje;
          return ((_internalAccountsObje = internalAccountsObject[accountId]) === null || _internalAccountsObje === void 0 ? void 0 : _internalAccountsObje.address.toLowerCase()) ?? '';
        })
      };
    }
  }
  return result;
});

/**
 * This selector is a temporary solution to avoid a regression in the account order UI while Multichain Accounts V2 is not completed.
 * It takes the ordered accounts from the MetaMask state and combines them with the account tree data
 * bypassing the respective groups inside a wallet and just adding all accounts inside the first group.
 *
 * To use the correct and intended functionality for Multichain Accounts V2, use `getWalletsWithAccounts` instead.
 *
 * @param internalAccounts - All available internal accounts.
 * @param accountTree - Account tree state.
 * @returns Consolidated wallet collection with accounts metadata.
 */
const getWalletsWithAccountsSimplified = exports.getWalletsWithAccountsSimplified = (0, _util.createDeepEqualSelector)(_selectors.getMetaMaskAccountsOrdered, getAccountTree, _selectors.getOrderedConnectedAccountsForActiveTab, _accounts.getSelectedInternalAccount, _selectors.getPinnedAccountsList, _selectors.getHiddenAccountsList, (internalAccounts, accountTree, connectedAccounts, selectedAccount, pinnedAccounts, hiddenAccounts) => {
  return createConsolidatedWallets(internalAccounts, accountTree, connectedAccounts, selectedAccount, pinnedAccounts, hiddenAccounts,
  // Simplified behavior: first group gets all accounts in order, others get empty arrays
  (_, groupIndex, allAccountIdsInWallet, accountsById) => {
    if (groupIndex === 0) {
      // For first group, include only those accountIds present in accountsById, preserving accountsById order
      return Object.keys(accountsById).filter(accountId => allAccountIdsInWallet.includes(accountId));
    }
    return [];
  });
});

/**
 * Retrieve the wallet ID and name for an account with a given address.
 *
 * @param walletsWithAccounts - The consolidated wallets with accounts.
 * @param address - The address of the account to find.
 * @returns The wallet ID and name for the account, or null if not found.
 */
const getWalletIdAndNameByAccountAddress = exports.getWalletIdAndNameByAccountAddress = (0, _util.createDeepEqualSelector)(getWalletsWithAccounts, (_, address) => address, (walletsWithAccounts, address) => {
  // Find the wallet that contains the account with the given address
  for (const [walletId, wallet] of Object.entries(walletsWithAccounts)) {
    for (const group of Object.values(wallet.groups)) {
      const account = group.accounts.find(acc => acc.address.toLowerCase() === address.toLowerCase());
      if (account) {
        return {
          id: walletId,
          name: wallet.metadata.name
        };
      }
    }
  }
  return null;
});

/**
 * Retrieve a multichain account group by its ID.
 *
 * @param accountTree - Account tree state.
 * @param accountId - The account group ID to find.
 * @returns The multichain account group object, or undefined if not found.
 */
const getMultichainAccountGroupById = exports.getMultichainAccountGroupById = (0, _util.createDeepEqualSelector)(getAccountTree, (_, accountId) => accountId, (accountTree, accountId) => {
  const {
    wallets
  } = accountTree;
  const walletId = (0, _utils2.extractWalletIdFromGroupId)(accountId);
  const wallet = wallets[walletId];
  return wallet === null || wallet === void 0 ? void 0 : wallet.groups[accountId];
});

/**
 * Retrieve all account groups from all wallets in the account tree.
 *
 * @param accountTree - Account tree state.
 * @returns Array of all account groups.
 */
const getAllAccountGroups = exports.getAllAccountGroups = (0, _util.createDeepEqualSelector)(getAccountTree, accountTree => {
  const {
    wallets
  } = accountTree;
  return Object.values(wallets).flatMap(wallet => {
    return Object.values(wallet.groups).map(group => ({
      ...group,
      walletName: wallet.metadata.name,
      walletId: wallet.id
    }));
  });
});

/**
 * Retrieve all multichain account groups (filtered by Entropy wallet type).
 *
 * @param accountGroups - Array of all account groups.
 * @returns Array of multichain account groups.
 */
const getMultichainAccountGroups = exports.getMultichainAccountGroups = (0, _util.createDeepEqualSelector)(getAllAccountGroups, accountGroups => {
  return accountGroups.filter(group => group.id.startsWith(_accountApi.AccountWalletType.Entropy));
});

/**
 * Retrieve all non-multichain account groups (filtered to exclude Entropy wallet type).
 *
 * @param accountGroups - Array of all account groups.
 * @returns Array of non-multichain account groups.
 */
const getSingleAccountGroups = exports.getSingleAccountGroups = (0, _util.createDeepEqualSelector)(getAllAccountGroups, accountGroups => {
  return accountGroups.filter(group => !group.id.startsWith(_accountApi.AccountWalletType.Entropy));
});

/**
 * Retrieve account groups with their internal accounts populated.
 *
 * @param accountGroups - Array of all account groups.
 * @param internalAccounts - Array of internal accounts.
 * @returns Array of account groups with internal accounts instead of account IDs.
 */
const getAccountGroupWithInternalAccounts = exports.getAccountGroupWithInternalAccounts = (0, _util.createDeepEqualSelector)(getAllAccountGroups, _accounts.getInternalAccounts, (accountGroups, internalAccounts) => {
  return accountGroups.map(accountGroup => {
    return {
      ...accountGroup,
      accounts: accountGroup.accounts.map(accountId => {
        const internalAccount = internalAccounts.find(account => account.id === accountId);
        return internalAccount;
      }).filter(account => account !== undefined)
    };
  });
});

/**
 * Create a map from multichain account group IDs to their scope mappings.
 *
 * @param multichainAccounts - Array of multichain account groups.
 * @param internalAccounts - Array of internal accounts.
 * @returns Map from multichain account group IDs to scope-to-CAIP account ID mappings.
 */
const getMultichainAccountsToScopesMap = exports.getMultichainAccountsToScopesMap = (0, _util.createDeepEqualSelector)(getMultichainAccountGroups, _accounts.getInternalAccounts, (multichainAccounts, internalAccounts) => {
  const multichainAccountsToScopesMap = new Map();
  multichainAccounts.forEach(multichainAccount => {
    const multichainAccountIdToCaip25Ids = new Map();
    Object.values(multichainAccount.accounts).forEach(internalAccountId => {
      const internalAccount = internalAccounts.find(account => account.id === internalAccountId);
      if (!internalAccount) {
        return;
      }
      const [caip25Id] = internalAccount.scopes;
      if (caip25Id) {
        const [namespace, reference] = caip25Id.split(':');
        multichainAccountIdToCaip25Ids.set(caip25Id, `${namespace}:${reference}:${internalAccount.address}`);
      }
    });
    multichainAccountsToScopesMap.set(multichainAccount.id, multichainAccountIdToCaip25Ids);
  });
  return multichainAccountsToScopesMap;
});

/**
 * Get the CAIP-25 account ID for a specific account group and scope.
 *
 * @param multichainAccountsToScopesMap - Map of multichain account groups to their scopes.
 * @param accountGroup - The account group to search in.
 * @param scope - The CAIP chain ID scope to find.
 * @returns The CAIP-25 account ID, or undefined if not found.
 */
const getCaip25IdByAccountGroupAndScope = exports.getCaip25IdByAccountGroupAndScope = (0, _util.createDeepEqualSelector)(getMultichainAccountsToScopesMap, (_, accountGroup, scope) => ({
  accountGroup,
  scope
}), (multichainAccountsToScopesMap, {
  accountGroup,
  scope
}) => {
  const multichainAccountGroup = multichainAccountsToScopesMap.get(accountGroup.id);
  if (!multichainAccountGroup) {
    return undefined;
  }
  return multichainAccountGroup.get(scope);
});

/**
 * Get account groups filtered by the provided scopes.
 *
 * @param accountGroupsWithInternalAccounts - Array of account groups with internal accounts.
 * @param scopes - Array of scope strings to filter by.
 * @returns Array of account groups that match the provided scopes.
 */
const getAccountGroupsByScopes = exports.getAccountGroupsByScopes = (0, _util.createDeepEqualSelector)(getAccountGroupWithInternalAccounts, (_, scopes) => scopes, (accountGroupsWithInternalAccounts, scopes) => {
  const {
    cleanedScopes,
    hasEvmScope
  } = scopes.reduce((acc, scope) => {
    const [namespace] = scope.split(':');
    if (namespace === _utils.KnownCaipNamespace.Eip155) {
      acc.hasEvmScope = true;
    } else {
      acc.cleanedScopes.push(scope);
    }
    return acc;
  }, {
    cleanedScopes: [],
    hasEvmScope: false
  });

  // Can early return with all multichain account groups because they all have EVM scopes
  if (hasEvmScope) {
    return accountGroupsWithInternalAccounts;
  }
  const scopesToAccountGroupsMap = new Map();
  cleanedScopes.forEach(scope => {
    const accountGroupsWithScope = accountGroupsWithInternalAccounts.filter(accountGroup => accountGroup.accounts.some(internalAccount => internalAccount.scopes.includes(scope)));
    scopesToAccountGroupsMap.set(scope, accountGroupsWithScope);
  });
  return Array.from(scopesToAccountGroupsMap.values()).flat();
});
/**
 * Get a group by its ID from the account tree.
 *
 * @param wallets - The wallets object from the account tree.
 * @param groupId - The ID of the group to get.
 * @returns The group object, or null if not found.
 */
const getGroupByGroupId = (wallets, groupId) => {
  for (const wallet of Object.values(wallets)) {
    if (wallet.groups[groupId]) {
      return wallet.groups[groupId];
    }
  }
  return null;
};

/**
 * Get an internal account from a group by its CAIP chain ID.
 *
 * @param group - The group object to search in.
 * @param caipChainId - The CAIP chain ID to search for.
 * @param internalAccounts - The internal accounts object.
 * @returns The internal account object, or null if not found.
 */
const getInternalAccountFromGroup = (group, caipChainId, internalAccounts) => {
  if (!group) {
    return null;
  }
  const sanitizedChainId = (0, _utils2.getSanitizedChainId)(caipChainId);
  for (const account of group.accounts) {
    const internalAccount = internalAccounts[account];
    if (internalAccount !== null && internalAccount !== void 0 && internalAccount.scopes.includes(sanitizedChainId)) {
      return internalAccount;
    }
  }
  return null;
};

/**
 * Get an internal account from the account tree by its group ID and CAIP chain ID.
 *
 * @param groupId - The ID of the group to search in.
 * @param caipChainId - The CAIP chain ID to search for.
 * @returns The internal account object, or null if not found.
 */
const getInternalAccountByGroupAndCaip = exports.getInternalAccountByGroupAndCaip = (0, _util.createDeepEqualSelector)(getAccountTree, _accounts.getInternalAccountsObject, (_, groupId, caipChainId) => ({
  groupId,
  caipChainId
}), (accountTree, internalAccounts, {
  groupId,
  caipChainId
}) => {
  const {
    wallets
  } = accountTree;
  const group = getGroupByGroupId(wallets, groupId);
  return getInternalAccountFromGroup(group, caipChainId, internalAccounts);
});

/**
 * Get the selected account group from the account tree.
 *
 * @param accountTree - The account tree state.
 * @returns The selected account group, or null if not found.
 */
const getSelectedAccountGroup = exports.getSelectedAccountGroup = (0, _util.createDeepEqualSelector)(getAccountTree, accountTree => accountTree.selectedAccountGroup);

/**
 * Get an internal account from the account tree by its selected account group and CAIP chain ID.
 *
 * @param caipChainId - The CAIP chain ID to search for.
 * @returns The internal account object, or null if not found.
 */
const getInternalAccountBySelectedAccountGroupAndCaip = exports.getInternalAccountBySelectedAccountGroupAndCaip = (0, _util.createDeepEqualSelector)(getAccountTree, _accounts.getInternalAccountsObject, getSelectedAccountGroup, (_, caipChainId) => caipChainId, (accountTree, internalAccounts, selectedAccountGroup, caipChainId) => {
  if (!selectedAccountGroup) {
    return null;
  }
  const {
    wallets
  } = accountTree;
  const group = getGroupByGroupId(wallets, selectedAccountGroup);
  return getInternalAccountFromGroup(group, caipChainId, internalAccounts);
});

/**
 * Retrieve wallet from account tree state.
 *
 * @param state - Redux state.
 * @param state.metamask - MetaMask state object.
 * @param state.metamask.accountTree - Account tree state object.
 * @param walletId - The ID of the wallet to retrieve.
 * @returns Wallet object from account tree state.
 */
const getWallet = exports.getWallet = (0, _reselect.createSelector)(state => {
  var _state$metamask;
  return (_state$metamask = state.metamask) === null || _state$metamask === void 0 || (_state$metamask = _state$metamask.accountTree) === null || _state$metamask === void 0 ? void 0 : _state$metamask.wallets;
}, (_, walletId) => walletId, (wallets, walletId) => {
  return wallets === null || wallets === void 0 ? void 0 : wallets[walletId];
});

/**
 * Returns all account groups that belong to a specific wallet ID.
 *
 * @param state - Redux state.
 * @param walletId - The wallet ID to filter account groups by.
 * @returns Object containing all account groups for the specified wallet.
 */
const getMultichainAccountsByWalletId = exports.getMultichainAccountsByWalletId = (0, _reselect.createSelector)(getAccountTree, (_, walletId) => walletId, (accountTree, walletId) => {
  const wallet = accountTree.wallets[walletId];
  return wallet === null || wallet === void 0 ? void 0 : wallet.groups;
});

/**
 * Get all internal accounts from a specific account group by its ID.
 *
 * @param state - Redux state.
 * @param groupId - The ID of the account group.
 * @returns Array of internal accounts in the specified group, or empty array if not found.
 */
const getInternalAccountsFromGroupById = exports.getInternalAccountsFromGroupById = (0, _reselect.createSelector)(getAccountTree, _accounts.getInternalAccountsObject, (_, groupId) => groupId, (accountTree, internalAccounts, groupId) => {
  if (!groupId) {
    return [];
  }
  const {
    wallets
  } = accountTree;
  const group = getGroupByGroupId(wallets, groupId);
  if (!group) {
    return [];
  }
  return group.accounts.map(accountId => internalAccounts[accountId]).filter(account => Boolean(account));
});

/**
 * Selector to get account groups by a list of addresses.
 * Returns groups that contain at least one account matching any of the provided addresses.
 *
 * @param _state - Redux state.
 * @param addresses - An array of addresses to filter account groups by.
 * @returns An array of AccountGroupWithInternalAccounts that contain at least one matching account.
 */
const getAccountGroupsByAddress = exports.getAccountGroupsByAddress = (0, _util.createDeepEqualSelector)([getAccountGroupWithInternalAccounts, (_state, addresses) => new Set(addresses.map(address => address.toLowerCase()))], (accountGroupWithInternalAccounts, addressesSet) => {
  const matchingGroups = new Set();
  accountGroupWithInternalAccounts.forEach(group => {
    const containsMatchingAccount = group.accounts.some(account => addressesSet.has(account.address.toLowerCase()));
    if (containsMatchingAccount) {
      matchingGroups.add(group);
    }
  });

  // Convert the Set of AccountGroupWithInternalAccounts to an Array
  return [...matchingGroups];
});

/**
 * Selector to get a list of internal accounts spread across different network scopes for a specific account group.
 *
 * @param _state - Redux state.
 * @param groupId - The ID of the account group.
 * @returns An array of internal accounts spread across different network scopes.
 */
const getInternalAccountListSpreadByScopesByGroupId = exports.getInternalAccountListSpreadByScopesByGroupId = (0, _util.createDeepEqualSelector)([getInternalAccountsFromGroupById, _networks.getMultichainNetworkConfigurationsByChainId], (internalAccounts, networks) => {
  const caipNetworks = networks[0];

  // Precompute EVM network IDs (filtered by non-test networks)
  const evmNetworkIds = new Set(Object.keys(caipNetworks).filter(chainId => chainId.startsWith(_utils.KnownCaipNamespace.Eip155) && !(0, _networkHelper.isTestNetwork)(chainId)));

  // Prepare the result array by iterating through internalAccounts
  const result = [];
  internalAccounts.forEach(account => {
    // Use the precomputed EVM network IDs or account-specific scopes
    const scopes = account.type === _keyringApi.EthAccountType.Eoa ? [...evmNetworkIds] : account.scopes || [];

    // Iterate over scopes and filter out test networks
    scopes.forEach(scope => {
      if (!(0, _networkHelper.isTestNetwork)(scope)) {
        var _caipNetworks$scope;
        result.push({
          account,
          scope,
          networkName: ((_caipNetworks$scope = caipNetworks[scope]) === null || _caipNetworks$scope === void 0 ? void 0 : _caipNetworks$scope.name) || 'Unknown Network'
        });
      }
    });
  });
  return result;
});

/**
 * Get the number of internal accounts in a specific group.
 *
 * @param _state - Redux state.
 * @param groupId - The account group ID.
 * @returns The number of accounts in the group, or 0 if the group is not found.
 */
const getNetworkAddressCount = exports.getNetworkAddressCount = (0, _util.createDeepEqualSelector)([getInternalAccountListSpreadByScopesByGroupId], accounts => {
  if (!accounts) {
    return 0;
  }
  return accounts.length;
});

/**
 * Get the corresponding address to generate the account icon
 * for a specific account group ID.
 *
 * @param groupId - The account group ID.
 * @returns The address to be used as seed for the icon generation.
 * @throws If no accounts are found in the specified group.
 */
const getIconSeedAddressByAccountGroupId = exports.getIconSeedAddressByAccountGroupId = (0, _util.createDeepEqualSelector)([getInternalAccountsFromGroupById], accounts => {
  if (!accounts || accounts.length === 0) {
    return '';
  }
  for (const account of accounts) {
    if ((0, _keyringApi.isEvmAccountType)(account.type)) {
      // Prefer an EVM account if available
      return account.address;
    }
  }

  // In case there are no EVM accounts in the group. We return the first account's address.
  return accounts[0].address;
});

/**
 * Get the seed addresses for multiple account groups at once.
 * This is more efficient than calling getIconSeedAddressByAccountGroupId multiple times.
 *
 * @param state - Redux state.
 * @param accountGroups - Array of account groups to get seed addresses for.
 * @returns Object mapping account group IDs to their seed addresses.
 */
const getIconSeedAddressesByAccountGroups = (state, accountGroups) => {
  const seedAddresses = {};
  accountGroups.forEach(accountGroup => {
    try {
      const seedAddress = getIconSeedAddressByAccountGroupId(state, accountGroup.id);
      seedAddresses[accountGroup.id] = seedAddress;
    } catch (error) {
      // don't throw and show empty string as seed address.
      seedAddresses[accountGroup.id] = '';
    }
  });
  return seedAddresses;
};
exports.getIconSeedAddressesByAccountGroups = getIconSeedAddressesByAccountGroups;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\multichain-accounts\\account-tree.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\utils.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Cmultichain-accounts%5Cutils.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSanitizedChainId = exports.extractWalletIdFromGroupId = void 0;
/**
 * Sanitizes an EIP-155 chain ID to the correct format.
 *
 * @param chainId - The chain ID to sanitize.
 * @returns The sanitized chain ID.
 */
const getSanitizedChainId = chainId => {
  if (chainId.startsWith('eip155')) {
    return 'eip155:0';
  }
  return chainId;
};

/**
 * Extracts the wallet ID from an account group ID.
 *
 * @param accountGroupId - The account group ID to extract the wallet ID from.
 * @returns The extracted wallet ID.
 */
exports.getSanitizedChainId = getSanitizedChainId;
const extractWalletIdFromGroupId = accountGroupId => {
  if (accountGroupId.startsWith('snap:')) {
    if (accountGroupId.includes('@') && accountGroupId.includes('/')) {
      const lastSlashIndex = accountGroupId.lastIndexOf('/');
      return accountGroupId.substring(0, lastSlashIndex);
    }
    if (accountGroupId.includes('/')) {
      const parts = accountGroupId.split('/');
      return parts.slice(0, -1).join('/');
    }
    return accountGroupId;
  }
  return accountGroupId.split('/')[0];
};
exports.extractWalletIdFromGroupId = extractWalletIdFromGroupId;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\multichain-accounts\\utils.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-transactions.ts", {"./multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Cmultichain-transactions.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSelectedAccountGroupMultichainTransactions = getSelectedAccountGroupMultichainTransactions;
var _accountTree = require("./multichain-accounts/account-tree");
// Lightweight shape for nonEvmTransactions state map
// accountId -> chainId -> TransactionStateEntry

function getSelectedAccountGroupMultichainTransactions(state, nonEvmChainIds) {
  const nonEvmTransactionsByAccount = state.metamask.nonEvmTransactions;
  const selectedGroupId = (0, _accountTree.getSelectedAccountGroup)(state);
  const groupsWithAccounts = (0, _accountTree.getAccountGroupWithInternalAccounts)(state);
  const selectedGroup = groupsWithAccounts.find(group => group.id === selectedGroupId);
  const selectedGroupAccountIds = selectedGroup === null || selectedGroup === void 0 ? void 0 : selectedGroup.accounts.map(account => account.id);
  const transactions = [];
  if (selectedGroupAccountIds && selectedGroupAccountIds.length > 0) {
    for (const accountId of selectedGroupAccountIds) {
      const byChain = (nonEvmTransactionsByAccount === null || nonEvmTransactionsByAccount === void 0 ? void 0 : nonEvmTransactionsByAccount[accountId]) ?? {};
      for (const chainId of nonEvmChainIds ?? []) {
        const entry = byChain === null || byChain === void 0 ? void 0 : byChain[chainId];
        if (entry !== null && entry !== void 0 && entry.transactions && Array.isArray(entry.transactions)) {
          transactions.push(...entry.transactions);
        }
      }
    }
  }
  return {
    transactions
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\multichain-transactions.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\nft.ts", {"./selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","./shared":"D:\\code\\v\\metamask-extension\\ui\\selectors\\shared.ts","reselect":"D:\\code\\v\\metamask-extension\\node_modules\\reselect\\dist\\cjs\\reselect.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Cnft.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNftContractsByAddressOnCurrentChain = exports.getNftContractsByAddressByChain = void 0;
exports.getNftsByChainByAccount = getNftsByChainByAccount;
exports.selectAllNftsFlat = void 0;
var _reselect = require("reselect");
var _selectors = require("./selectors");
var _shared = require("./shared");
function getNftContractsByChainByAccount(state) {
  return state.metamask.allNftContracts ?? _shared.EMPTY_OBJECT;
}

/**
 * Get all NFTs owned by the user.
 *
 * @param state - Metamask state.
 * @returns All NFTs owned by the user, keyed by chain ID then account address.
 */
function getNftsByChainByAccount(state) {
  return state.metamask.allNfts ?? _shared.EMPTY_OBJECT;
}
const getNftContractsByAddressByChain = exports.getNftContractsByAddressByChain = (0, _reselect.createSelector)(getNftContractsByChainByAccount, nftContractsByChainByAccount => {
  const userAccounts = Object.keys(nftContractsByChainByAccount);
  const allNftContracts = userAccounts.map(account => Object.keys(nftContractsByChainByAccount[account]).map(chainId => nftContractsByChainByAccount[account][chainId].map(contract => ({
    ...contract,
    chainId
  })))).flat().flat();
  return allNftContracts.reduce((acc, contract) => {
    const {
      chainId,
      ...data
    } = contract;
    const chainIdContracts = acc[chainId] ?? {};
    acc[chainId] = chainIdContracts;
    chainIdContracts[data.address.toLowerCase()] = data;
    return acc;
  }, {});
});
const getNftContractsByAddressOnCurrentChain = exports.getNftContractsByAddressOnCurrentChain = (0, _reselect.createSelector)(state => (0, _selectors.getMemoizedCurrentChainId)(state), getNftContractsByAddressByChain, (currentChainId, nftContractsByAddressByChain) => {
  return nftContractsByAddressByChain[currentChainId] ?? {};
});

/**
 * Get a flattened list of all NFTs owned by the user.
 * Includes all NFTs from all chains and accounts.
 *
 * @param state - Metamask state.
 * @returns All NFTs owned by the user in a single array.
 */
const selectAllNftsFlat = exports.selectAllNftsFlat = (0, _reselect.createSelector)(getNftsByChainByAccount, nftsByChainByAccount => {
  const nftsByChainArray = Object.values(nftsByChainByAccount);
  return nftsByChainArray.reduce((acc, nftsByChain) => {
    const nftsArrays = Object.values(nftsByChain);
    return acc.concat(...nftsArrays);
  }, []);
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\nft.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\shield\\coverage.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Cshield%5Ccoverage.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCoverageStatus = getCoverageStatus;
function getCoverageStatus(state, confirmationId) {
  const coverageResults = state.metamask.coverageResults[confirmationId];
  if (!coverageResults || coverageResults.results.length === 0) {
    return {
      status: undefined,
      reasonCode: undefined
    };
  }
  const result = coverageResults.results[0];
  return {
    status: result.status,
    reasonCode: result.reasonCode
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\shield\\coverage.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\signatures.ts", {"../../shared/modules/selectors/util":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\util.js","./transactions":"D:\\code\\v\\metamask-extension\\ui\\selectors\\transactions.js","reselect":"D:\\code\\v\\metamask-extension\\node_modules\\reselect\\dist\\cjs\\reselect.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Csignatures.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectUnapprovedMessages = exports.selectUnapprovedMessage = void 0;
var _reselect = require("reselect");
var _util = require("../../shared/modules/selectors/util");
var _transactions = require("./transactions");
const selectUnapprovedMessages = exports.selectUnapprovedMessages = (0, _reselect.createSelector)(_transactions.unapprovedPersonalMsgsSelector, _transactions.unapprovedTypedMessagesSelector, (personalMsgs, typedMessages) => ({
  ...personalMsgs,
  ...typedMessages
}));
const internalSelectUnapprovedMessage = (0, _reselect.createSelector)(selectUnapprovedMessages, (_state, messageId) => messageId, (messages, messageId) => messages[messageId]);
const selectUnapprovedMessage = exports.selectUnapprovedMessage = (0, _util.createDeepEqualSelector)(internalSelectUnapprovedMessage, message => message);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\signatures.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\snaps\\accounts.ts", {"../../../shared/modules/selectors/util":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\util.js","../accounts":"D:\\code\\v\\metamask-extension\\ui\\selectors\\accounts.ts","../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","reselect":"D:\\code\\v\\metamask-extension\\node_modules\\reselect\\dist\\cjs\\reselect.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Csnaps%5Caccounts.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMemoizedAccountName = exports.getAccountNameFromState = void 0;
var _reselect = require("reselect");
var _selectors = require("../selectors");
var _accounts = require("../accounts");
var _util = require("../../../shared/modules/selectors/util");
/**
 * The Metamask state for the accounts controller.
 */

/**
 * Get the account name for an address.
 *
 * @param _state -  The Metamask state for the accounts controller.
 * @param address - The address to get the display name for.
 * @returns The account name for the address.
 */
const getAccountNameFromState = exports.getAccountNameFromState = (0, _reselect.createSelector)([_accounts.getInternalAccounts, (_state, address) => address], _selectors.getAccountName);

/**
 * Get the memoized account name for an address.
 *
 * @param state - The Metamask state for the accounts controller.
 * @param address - The address to get the display name for.
 * @returns The account name for the address.
 */
const getMemoizedAccountName = exports.getMemoizedAccountName = (0, _util.createDeepEqualSelector)([getAccountNameFromState], accountName => accountName);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\snaps\\accounts.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\snaps\\address-book.ts", {"../../../shared/modules/selectors/util":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\util.js","../../../shared/modules/string-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\string-utils.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Csnaps%5Caddress-book.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMemoizedFullAddressBook = exports.getFullAddressBook = exports.getAddressBookEntryByNetwork = exports.getAddressBookByNetwork = void 0;
var _util = require("../../../shared/modules/selectors/util");
var _stringUtils = require("../../../shared/modules/string-utils");
/**
 * The Metamask state for the address book controller.
 */

/**
 * Get the full address book.
 *
 * @param state - The Metamask state for the address book controller.
 * @returns The full address book.
 */
const getFullAddressBook = state => state.metamask.addressBook;

/**
 * Get the memoized full address book.
 *
 * @param state - The Metamask state for the address book controller.
 * @returns The full address book.
 */
exports.getFullAddressBook = getFullAddressBook;
const getMemoizedFullAddressBook = exports.getMemoizedFullAddressBook = (0, _util.createDeepEqualSelector)([getFullAddressBook], addressBook => addressBook);

/**
 * Get the address book for a network.
 *
 * @param _state - The Metamask state for the address book controller.
 * @param chainId - The chain ID to get the address book for.
 * @returns The address book for the network.
 */
const getAddressBookByNetwork = exports.getAddressBookByNetwork = (0, _util.createDeepEqualSelector)([getMemoizedFullAddressBook, (_state, chainId) => chainId], (addressBook, chainId) => {
  if (!addressBook[chainId]) {
    return [];
  }
  return Object.values(addressBook[chainId]);
});

/* eslint-disable jsdoc/require-param */
/* eslint-disable jsdoc/check-param-names */
/**
 * Get an address book entry for an address on a network.
 *
 * @param state - The Metamask state for the address book controller.
 * @param address - The address to get the entry for.
 * @param chainId - The chain ID to get the entry for.
 * @returns The address book entry for the address on the network.
 */
/* eslint-enable jsdoc/require-param */
/* eslint-enable jsdoc/check-param-names */
const getAddressBookEntryByNetwork = exports.getAddressBookEntryByNetwork = (0, _util.createDeepEqualSelector)([(state, _address, chainId) => getAddressBookByNetwork(state, chainId), (_state, address) => address], (addressBook, address) => {
  return addressBook.find(contact => (0, _stringUtils.isEqualCaseInsensitive)(contact.address, address));
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\snaps\\address-book.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\snaps\\currency.ts", {"../../../shared/modules/selectors/util":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\util.js","../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Csnaps%5Ccurrency.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMemoizedCurrentCurrency = void 0;
var _util = require("../../../shared/modules/selectors/util");
var _metamask = require("../../ducks/metamask/metamask");
const getMemoizedCurrentCurrency = exports.getMemoizedCurrentCurrency = (0, _util.createDeepEqualSelector)([_metamask.getCurrentCurrency], currency => currency);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\snaps\\currency.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\snaps\\index.ts", {"./accounts":"D:\\code\\v\\metamask-extension\\ui\\selectors\\snaps\\accounts.ts","./address-book":"D:\\code\\v\\metamask-extension\\ui\\selectors\\snaps\\address-book.ts","./currency":"D:\\code\\v\\metamask-extension\\ui\\selectors\\snaps\\currency.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Csnaps%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _addressBook = require("./address-book");
Object.keys(_addressBook).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _addressBook[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _addressBook[key];
    }
  });
});
var _accounts = require("./accounts");
Object.keys(_accounts).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _accounts[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _accounts[key];
    }
  });
});
var _currency = require("./currency");
Object.keys(_currency).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _currency[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _currency[key];
    }
  });
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\snaps\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\subscription\\index.ts", {"./subscription":"D:\\code\\v\\metamask-extension\\ui\\selectors\\subscription\\subscription.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Csubscription%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _subscription = require("./subscription");
Object.keys(_subscription).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _subscription[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _subscription[key];
    }
  });
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\subscription\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\subscription\\subscription.ts", {"../../../shared/lib/shield":"D:\\code\\v\\metamask-extension\\shared\\lib\\shield.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Csubscription%5Csubscription.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHasShieldEntryModalShownOnce = getHasShieldEntryModalShownOnce;
exports.getIsActiveShieldSubscription = getIsActiveShieldSubscription;
exports.getSubscriptionPricing = getSubscriptionPricing;
exports.getUserSubscriptions = getUserSubscriptions;
var _shield = require("../../../shared/lib/shield");
function getSubscriptionPricing(state) {
  return state.metamask.pricing;
}
function getUserSubscriptions(state) {
  return {
    customerId: state.metamask.customerId,
    subscriptions: state.metamask.subscriptions,
    trialedProducts: state.metamask.trialedProducts
  };
}
function getIsActiveShieldSubscription(state) {
  return (0, _shield.getIsShieldSubscriptionActive)(state.metamask.subscriptions);
}
function getHasShieldEntryModalShownOnce(state) {
  return Boolean(state.metamask.showShieldEntryModalOnce !== null);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\subscription\\subscription.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\store\\controller-actions\\gator-permissions-controller.ts", {"../background-connection":"D:\\code\\v\\metamask-extension\\ui\\store\\background-connection.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cstore%5Ccontroller-actions%5Cgator-permissions-controller.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchAndUpdateGatorPermissions = void 0;
var _backgroundConnection = require("../background-connection");
const fetchAndUpdateGatorPermissions = async () => {
  return await (0, _backgroundConnection.submitRequestToBackground)('fetchAndUpdateGatorPermissions', []);
};
exports.fetchAndUpdateGatorPermissions = fetchAndUpdateGatorPermissions;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\store\\controller-actions\\gator-permissions-controller.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\store\\controller-actions\\multichain-asset-rates-controller.ts", {"../actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../background-connection":"D:\\code\\v\\metamask-extension\\ui\\store\\background-connection.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cstore%5Ccontroller-actions%5Cmultichain-asset-rates-controller.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.multichainAssetsRatesStartPolling = multichainAssetsRatesStartPolling;
exports.multichainAssetsRatesStopPollingByPollingToken = multichainAssetsRatesStopPollingByPollingToken;
var _actions = require("../actions");
var _backgroundConnection = require("../background-connection");
/**
 * Informs the MultichainAssetsRatesController that the UI requires asset rate polling
 *
 * @param accountId - account Id to poll.
 * @returns polling token that can be used to stop polling
 */
async function multichainAssetsRatesStartPolling(accountId) {
  const pollingToken = await (0, _backgroundConnection.submitRequestToBackground)('multichainAssetsRatesStartPolling', [{
    accountId
  }]);
  await (0, _actions.addPollingTokenToAppState)(pollingToken);
  return pollingToken;
}

/**
 * Informs the MultichainAssetsRatesController that the UI no longer requires asset rate polling
 *
 * @param pollingToken - Poll token received from calling MultichainAssetsRatesController
 */
async function multichainAssetsRatesStopPollingByPollingToken(pollingToken) {
  await (0, _backgroundConnection.submitRequestToBackground)('multichainAssetsRatesStopPollingByPollingToken', [pollingToken]);
  await (0, _actions.removePollingTokenFromAppState)(pollingToken);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\store\\controller-actions\\multichain-asset-rates-controller.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\store\\controller-actions\\transaction-controller.ts", {"../background-connection":"D:\\code\\v\\metamask-extension\\ui\\store\\background-connection.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cstore%5Ccontroller-actions%5Ctransaction-controller.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isAtomicBatchSupported = isAtomicBatchSupported;
exports.startIncomingTransactionPolling = startIncomingTransactionPolling;
exports.stopIncomingTransactionPolling = stopIncomingTransactionPolling;
exports.updateAtomicBatchData = updateAtomicBatchData;
exports.updateBatchTransactions = updateBatchTransactions;
exports.updateSelectedGasFeeToken = updateSelectedGasFeeToken;
var _backgroundConnection = require("../background-connection");
async function isAtomicBatchSupported(...args) {
  return await (0, _backgroundConnection.submitRequestToBackground)('isAtomicBatchSupported', args);
}
async function startIncomingTransactionPolling() {
  return await (0, _backgroundConnection.submitRequestToBackground)('startIncomingTransactionPolling');
}
async function stopIncomingTransactionPolling() {
  return await (0, _backgroundConnection.submitRequestToBackground)('stopIncomingTransactionPolling');
}
async function updateAtomicBatchData(request) {
  return await (0, _backgroundConnection.submitRequestToBackground)('updateAtomicBatchData', [request]);
}
async function updateBatchTransactions(...args) {
  return await (0, _backgroundConnection.submitRequestToBackground)('updateBatchTransactions', args);
}
async function updateSelectedGasFeeToken(...args) {
  return await (0, _backgroundConnection.submitRequestToBackground)('updateSelectedGasFeeToken', args);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\store\\controller-actions\\transaction-controller.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\store\\store.ts", {"../ducks":"D:\\code\\v\\metamask-extension\\ui\\ducks\\index.js","@reduxjs/toolkit":"D:\\code\\v\\metamask-extension\\node_modules\\@reduxjs\\toolkit\\dist\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","remote-redux-devtools":"D:\\code\\v\\metamask-extension\\node_modules\\remote-redux-devtools\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cstore%5Cstore.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = configureStore;
exports.useAppSelector = void 0;
var _reactRedux = require("react-redux");
var _toolkit = require("@reduxjs/toolkit");
var _remoteReduxDevtools = _interopRequireDefault(require("remote-redux-devtools"));
var _ducks = _interopRequireDefault(require("../ducks"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * This interface is temporary and is copied from the message-manager.js file
 * and is the 'msgParams' key of the interface declared there. We should get a
 * universal Message type to use for this, the Message manager and all
 * the other types of messages.
 *
 * TODO: Replace this
 */

/**
 * `ReduxState` overrides incorrectly typed properties of `RootReducerReturnType`, and is only intended to be used as an input for `configureStore`.
 * The `MetaMaskReduxState` type (derived from the returned output of `configureStore`) is to be used consistently as the single source-of-truth and representation of Redux state shape.
 *
 * Redux slice reducers that are passed an `AnyAction`-type `action` parameter are inferred to have a return type of `never`.
 * TODO: Supply exhaustive action types to all Redux slices (specifically `metamask` and `appState`)
 */

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function configureStore(preloadedState) {
  const reduxDevtoolsEnabled = null;
  const runningTests = false;
  const enhancers = [];
  if (reduxDevtoolsEnabled && !runningTests) {
    enhancers.push((0, _remoteReduxDevtools.default)({
      name: 'MetaMask',
      hostname: 'localhost',
      port: 8000,
      realtime: true
    }));
  }
  return (0, _toolkit.configureStore)({
    reducer: _ducks.default,
    middleware: getDefaultMiddleware => getDefaultMiddleware({
      /**
       * We do not persist the redux tree for rehydration, so checking for
       * serializable state keys is not relevant for now. Any state that persists
       * is managed in the background. We may at some point want this, but we can
       * gradually implement by using the ignore options to ignore those actions
       * and state keys that are not serializable, preventing us from adding new
       * actions and state that would violate our ability to persist state keys.
       * NOTE: redux-thunk is included by default in the middleware below.
       */
      serializableCheck: false,
      /**
       * immutableCheck controls whether we get warnings about mutation of
       * state, this is turned off by default for now since it heavily affects
       * performance due to the Redux state growing larger.
       */
      immutableCheck: false
    }),
    devTools: false,
    enhancers,
    preloadedState
  });
}
const useAppSelector = exports.useAppSelector = _reactRedux.useSelector;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\store\\store.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\ui.js", {"../../development/wdyr":"D:\\code\\v\\metamask-extension\\development\\wdyr.ts","../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../shared/constants/infura-project-id":"D:\\code\\v\\metamask-extension\\shared\\constants\\infura-project-id.ts","../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../shared/modules/browser-runtime.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\browser-runtime.utils.js","../../shared/modules/mv3.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\mv3.utils.js","../../ui":"D:\\code\\v\\metamask-extension\\ui\\index.js","./lib/metaRPCClientFactory":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\metaRPCClientFactory.ts","./lib/setup-initial-state-hooks":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\setup-initial-state-hooks.js","./lib/stream-utils":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\stream-utils.js","./lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","./platforms/extension":"D:\\code\\v\\metamask-extension\\app\\scripts\\platforms\\extension.js","@lavamoat/lavadome-react":"D:\\code\\v\\metamask-extension\\node_modules\\@lavamoat\\lavadome-react\\build\\main.js","@metamask/json-rpc-engine":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\json-rpc-engine\\dist\\index.cjs","@metamask/providers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\providers\\dist\\index.cjs","extension-port-stream":"D:\\code\\v\\metamask-extension\\node_modules\\extension-port-stream\\dist\\index.js","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","react-devtools-core":"D:\\code\\v\\metamask-extension\\node_modules\\react-devtools-core\\dist\\backend.js","webextension-polyfill":"D:\\code\\v\\metamask-extension\\node_modules\\webextension-polyfill\\dist\\browser-polyfill.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cui.js
      return function (require, module, exports) {
"use strict";

require("@lavamoat/lavadome-react");
require("./lib/setup-initial-state-hooks");
require("../../development/wdyr");
require("../../shared/constants/infura-project-id");
var reactDevtoolsCore = _interopRequireWildcard(require("react-devtools-core"));
var _extensionPortStream = _interopRequireDefault(require("extension-port-stream"));
var _webextensionPolyfill = _interopRequireDefault(require("webextension-polyfill"));
var _providers = require("@metamask/providers");
var _jsonRpcEngine = require("@metamask/json-rpc-engine");
var _loglevel = _interopRequireDefault(require("loglevel"));
var _ui = _interopRequireWildcard(require("../../ui"));
var _app = require("../../shared/constants/app");
var _mv = require("../../shared/modules/mv3.utils");
var _browserRuntime = require("../../shared/modules/browser-runtime.utils");
var _trace = require("../../shared/lib/trace");
var _extension = _interopRequireDefault(require("./platforms/extension"));
var _streamUtils = require("./lib/stream-utils");
var _util = require("./lib/util");
var _metaRPCClientFactory = _interopRequireDefault(require("./lib/metaRPCClientFactory"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// ESLint complains that we are mixing imports and runtime code, which we are,
// but we need to initialize React Devtools before importing React (which
// happens in the UI code).
/* eslint-disable import/first */

// This import sets up safe intrinsics required for LavaDome to function securely.
// It must be run before any less trusted code so that no such code can undermine it.

// This import sets up global functions required for Sentry to function.
// It must be run as soon as possible in case an error is thrown later during initialization.

// Import this very early, so globalThis.INFURA_PROJECT_ID_FROM_MANIFEST_FLAGS is always defined

if (reactDevtoolsCore && null) {
  const {
    initialize,
    connectToDevTools
  } = reactDevtoolsCore;
  initialize();
  connectToDevTools();
}
const PHISHING_WARNING_PAGE_TIMEOUT = 1 * 1000; // 1 Second
const PHISHING_WARNING_SW_STORAGE_KEY = 'phishing-warning-sw-registered';

/**
 * @type {HTMLElement}
 */
const container = document.getElementById('app-content');

/**
 * @typedef {__import__("@metamask/object-multiplex/dist/Substream").Substream} Substream
 */

/**
 * An error thrown if the phishing warning page takes too long to load.
 */
class PhishingWarningPageTimeoutError extends Error {
  constructor() {
    super('Timeout failed');
  }
}
start().catch(_loglevel.default.error);
async function start() {
  const startTime = performance.now();
  const traceContext = (0, _trace.trace)({
    name: _trace.TraceName.UIStartup,
    startTime: performance.timeOrigin
  });
  (0, _trace.trace)({
    name: _trace.TraceName.LoadScripts,
    startTime: performance.timeOrigin,
    parentContext: traceContext
  });
  (0, _trace.endTrace)({
    name: _trace.TraceName.LoadScripts,
    timestamp: performance.timeOrigin + startTime
  });

  // create platform global
  global.platform = new _extension.default();

  // identify window type (popup, notification)
  const windowType = (0, _util.getEnvironmentType)();

  // setup stream to background
  const extensionPort = _webextensionPolyfill.default.runtime.connect({
    name: windowType
  });

  // Set up error handlers as early as possible to ensure we are ready to
  // handle any errors that occur at any time
  const criticalErrorHandler = new _ui.CriticalStartupErrorHandler(extensionPort, container);
  criticalErrorHandler.install();
  const connectionStream = new _extensionPortStream.default(extensionPort);
  const subStreams = connectSubstreams(connectionStream);
  const backgroundConnection = (0, _metaRPCClientFactory.default)(subStreams.controller);
  (0, _ui.connectToBackground)(backgroundConnection, handleStartUISync);
  async function handleStartUISync() {
    (0, _trace.endTrace)({
      name: _trace.TraceName.BackgroundConnect
    });

    // this means we've received a message from the background, and so
    // background startup has succeed, so we don't need to listen for error
    // messages anymore
    criticalErrorHandler.uninstall();

    // Only after startUiSync has started can we set up the provider connection
    // The provider connection *must* be set up before the UI is initialized, as
    // it sets a global variable, `ethereumProvider`, that the UI relies on.
    await setupProviderConnection(subStreams.provider);
    const activeTab = await queryCurrentActiveTab(windowType);
    await initializeUiWithTab(activeTab, backgroundConnection, windowType, traceContext);
    if (_mv.isManifestV3) {
      await loadPhishingWarningPage();
    }
  }
  (0, _trace.trace)({
    name: _trace.TraceName.BackgroundConnect,
    parentContext: traceContext
  });
}

/**
 * Load the phishing warning page temporarily to ensure the service
 * worker has been registered, so that the warning page works offline.
 */
async function loadPhishingWarningPage() {
  // Check session storage for whether we've already initialized the phishing warning
  // service worker in this browser session and do not attempt to re-initialize if so.
  const phishingSWMemoryFetch = await _webextensionPolyfill.default.storage.session.get(PHISHING_WARNING_SW_STORAGE_KEY);
  if (phishingSWMemoryFetch[PHISHING_WARNING_SW_STORAGE_KEY]) {
    return;
  }
  const currentPlatform = (0, _util.getPlatform)();
  let iframe;
  try {
    const extensionStartupPhishingPageUrl = new URL("https://metamask.github.io/phishing-warning/v5.1.0/");
    // The `extensionStartup` hash signals to the phishing warning page that it should not bother
    // setting up streams for user interaction. Otherwise this page load would cause a console
    // error.
    extensionStartupPhishingPageUrl.hash = '#extensionStartup';
    iframe = window.document.createElement('iframe');
    iframe.setAttribute('src', extensionStartupPhishingPageUrl.href);
    iframe.setAttribute('sandbox', 'allow-scripts allow-same-origin');

    // Create "deferred Promise" to allow passing resolve/reject to event handlers
    let deferredResolve;
    let deferredReject;
    const loadComplete = new Promise((resolve, reject) => {
      deferredResolve = resolve;
      deferredReject = reject;
    });

    // The load event is emitted once loading has completed, even if the loading failed.
    // If loading failed we can't do anything about it, so we don't need to check.
    iframe.addEventListener('load', deferredResolve);

    // This step initiates the page loading.
    window.document.body.appendChild(iframe);

    // This timeout ensures that this iframe gets cleaned up in a reasonable
    // timeframe, and ensures that the "initialization complete" message
    // doesn't get delayed too long.
    setTimeout(() => deferredReject(new PhishingWarningPageTimeoutError()), PHISHING_WARNING_PAGE_TIMEOUT);
    await loadComplete;

    // store a flag in sessions storage that we've already loaded the service worker
    // and don't need to try again
    if (currentPlatform === _app.PLATFORM_FIREFOX) {
      // Firefox does not yet support the storage.session API introduced in MV3
      // Tracked here: https://bugzilla.mozilla.org/show_bug.cgi?id=1687778
      console.error('Firefox does not support required MV3 APIs: Phishing warning page iframe and service worker will reload each page refresh');
    } else {
      _webextensionPolyfill.default.storage.session.set({
        [PHISHING_WARNING_SW_STORAGE_KEY]: true
      });
    }
  } catch (error) {
    if (error instanceof PhishingWarningPageTimeoutError) {
      console.warn('Phishing warning page timeout; page not guaranteed to work offline.');
    } else {
      console.error('Failed to initialize phishing warning page', error);
    }
  } finally {
    if (iframe) {
      iframe.remove();
    }
  }
}
async function initializeUiWithTab(tab, connectionStream, windowType, traceContext) {
  try {
    const store = await initializeUi(tab, connectionStream, traceContext);
    (0, _trace.endTrace)({
      name: _trace.TraceName.UIStartup
    });
    if (false) {
      var _window$document;
      (_window$document = window.document) === null || _window$document === void 0 || (_window$document = _window$document.documentElement) === null || _window$document === void 0 || _window$document.classList.add('controller-loaded');
    }
    const state = store.getState();
    const {
      metamask: {
        completedOnboarding
      } = {}
    } = state;
    if (!completedOnboarding && windowType !== _app.ENVIRONMENT_TYPE_FULLSCREEN) {
      global.platform.openExtensionInBrowser();
    }
  } catch (error) {
    await (0, _ui.displayCriticalError)(container, _ui.CriticalErrorTranslationKey.TroubleStarting, error);
  }
}
async function queryCurrentActiveTab(windowType) {
  // Shims the activeTab for E2E test runs only if the
  // "activeTabOrigin" querystring key=value is set
  if (false) {
    const searchParams = new URLSearchParams(window.location.search);
    const mockUrl = searchParams.get('activeTabOrigin');
    if (mockUrl) {
      const {
        origin,
        protocol
      } = new URL(mockUrl);
      const returnUrl = {
        id: 'mock-site',
        title: 'Mock Site',
        url: mockUrl,
        origin,
        protocol
      };
      return returnUrl;
    }
  }

  // At the time of writing we only have the `activeTab` permission which means
  // that this query will only succeed in the popup context (i.e. after a "browserAction")
  if (windowType !== _app.ENVIRONMENT_TYPE_POPUP) {
    return {};
  }
  const tabs = await _webextensionPolyfill.default.tabs.query({
    active: true,
    currentWindow: true
  }).catch(e => {
    (0, _browserRuntime.checkForLastErrorAndLog)() || _loglevel.default.error(e);
  });
  const [activeTab] = tabs;
  const {
    id,
    title,
    url
  } = activeTab;
  const {
    origin,
    protocol
  } = url ? new URL(url) : {};
  if (!origin || origin === 'null') {
    return {};
  }
  return {
    id,
    title,
    origin,
    protocol,
    url
  };
}
async function initializeUi(activeTab, backgroundConnection, traceContext) {
  return await (0, _ui.default)({
    activeTab,
    container,
    backgroundConnection,
    traceContext
  });
}

/**
 * Establishes a connections between the PortStream (background) and various UI
 * streams.
 *
 * @param {PortStream} connectionStream - PortStream instance establishing a background connection
 * @returns The multiplexed streams
 */
function connectSubstreams(connectionStream) {
  const mx = (0, _streamUtils.setupMultiplex)(connectionStream);
  const controllerSubstream = mx.createStream('controller');
  const providerSubstream = mx.createStream('provider');
  mx.ignoreStream('background-liveness');
  return {
    controller: controllerSubstream,
    provider: providerSubstream
  };
}

/**
 * Establishes a streamed connection to a Web3 provider
 *
 * @param {Substream} connectionStream - PortStream instance establishing a background connection
 */
async function setupProviderConnection(connectionStream) {
  const providerStream = new _providers.StreamProvider(connectionStream, {
    rpcMiddleware: [(0, _jsonRpcEngine.createIdRemapMiddleware)()]
  });
  connectionStream.on('error', console.error.bind(console));
  providerStream.on('error', console.error.bind(console));
  await providerStream.initialize();
  global.ethereumProvider = providerStream;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\ui.js",}]],["D:\\code\\v\\metamask-extension\\app\\scripts\\ui.js"],{})

//# sourceMappingURL=data:application/json;charset=utf8;base64,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
