LavaPack.loadBundle([
["D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\node_modules\\history\\cjs\\history.js", {"resolve-pathname":"D:\\code\\v\\metamask-extension\\node_modules\\resolve-pathname\\index.js","tiny-invariant":"D:\\code\\v\\metamask-extension\\node_modules\\tiny-invariant\\dist\\tiny-invariant.cjs.js","tiny-warning":"D:\\code\\v\\metamask-extension\\node_modules\\tiny-warning\\dist\\tiny-warning.cjs.js","value-equal":"D:\\code\\v\\metamask-extension\\node_modules\\value-equal\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Creact-router-dom%5Cnode_modules%5Chistory%5Ccjs%5Chistory.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

var resolvePathname = _interopDefault(require('resolve-pathname'));
var valueEqual = _interopDefault(require('value-equal'));
var warning = _interopDefault(require('tiny-warning'));
var invariant = _interopDefault(require('tiny-invariant'));

function _extends() {
  _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  };

  return _extends.apply(this, arguments);
}

function addLeadingSlash(path) {
  return path.charAt(0) === '/' ? path : '/' + path;
}
function stripLeadingSlash(path) {
  return path.charAt(0) === '/' ? path.substr(1) : path;
}
function hasBasename(path, prefix) {
  return path.toLowerCase().indexOf(prefix.toLowerCase()) === 0 && '/?#'.indexOf(path.charAt(prefix.length)) !== -1;
}
function stripBasename(path, prefix) {
  return hasBasename(path, prefix) ? path.substr(prefix.length) : path;
}
function stripTrailingSlash(path) {
  return path.charAt(path.length - 1) === '/' ? path.slice(0, -1) : path;
}
function parsePath(path) {
  var pathname = path || '/';
  var search = '';
  var hash = '';
  var hashIndex = pathname.indexOf('#');

  if (hashIndex !== -1) {
    hash = pathname.substr(hashIndex);
    pathname = pathname.substr(0, hashIndex);
  }

  var searchIndex = pathname.indexOf('?');

  if (searchIndex !== -1) {
    search = pathname.substr(searchIndex);
    pathname = pathname.substr(0, searchIndex);
  }

  return {
    pathname: pathname,
    search: search === '?' ? '' : search,
    hash: hash === '#' ? '' : hash
  };
}
function createPath(location) {
  var pathname = location.pathname,
      search = location.search,
      hash = location.hash;
  var path = pathname || '/';
  if (search && search !== '?') path += search.charAt(0) === '?' ? search : "?" + search;
  if (hash && hash !== '#') path += hash.charAt(0) === '#' ? hash : "#" + hash;
  return path;
}

function createLocation(path, state, key, currentLocation) {
  var location;

  if (typeof path === 'string') {
    // Two-arg form: push(path, state)
    location = parsePath(path);
    location.state = state;
  } else {
    // One-arg form: push(location)
    location = _extends({}, path);
    if (location.pathname === undefined) location.pathname = '';

    if (location.search) {
      if (location.search.charAt(0) !== '?') location.search = '?' + location.search;
    } else {
      location.search = '';
    }

    if (location.hash) {
      if (location.hash.charAt(0) !== '#') location.hash = '#' + location.hash;
    } else {
      location.hash = '';
    }

    if (state !== undefined && location.state === undefined) location.state = state;
  }

  try {
    location.pathname = decodeURI(location.pathname);
  } catch (e) {
    if (e instanceof URIError) {
      throw new URIError('Pathname "' + location.pathname + '" could not be decoded. ' + 'This is likely caused by an invalid percent-encoding.');
    } else {
      throw e;
    }
  }

  if (key) location.key = key;

  if (currentLocation) {
    // Resolve incomplete/relative pathname relative to current location.
    if (!location.pathname) {
      location.pathname = currentLocation.pathname;
    } else if (location.pathname.charAt(0) !== '/') {
      location.pathname = resolvePathname(location.pathname, currentLocation.pathname);
    }
  } else {
    // When there is no prior location and pathname is empty, set it to /
    if (!location.pathname) {
      location.pathname = '/';
    }
  }

  return location;
}
function locationsAreEqual(a, b) {
  return a.pathname === b.pathname && a.search === b.search && a.hash === b.hash && a.key === b.key && valueEqual(a.state, b.state);
}

function createTransitionManager() {
  var prompt = null;

  function setPrompt(nextPrompt) {
    warning(prompt == null, 'A history supports only one prompt at a time');
    prompt = nextPrompt;
    return function () {
      if (prompt === nextPrompt) prompt = null;
    };
  }

  function confirmTransitionTo(location, action, getUserConfirmation, callback) {
    // TODO: If another transition starts while we're still confirming
    // the previous one, we may end up in a weird state. Figure out the
    // best way to handle this.
    if (prompt != null) {
      var result = typeof prompt === 'function' ? prompt(location, action) : prompt;

      if (typeof result === 'string') {
        if (typeof getUserConfirmation === 'function') {
          getUserConfirmation(result, callback);
        } else {
          warning(false, 'A history needs a getUserConfirmation function in order to use a prompt message');
          callback(true);
        }
      } else {
        // Return false from a transition hook to cancel the transition.
        callback(result !== false);
      }
    } else {
      callback(true);
    }
  }

  var listeners = [];

  function appendListener(fn) {
    var isActive = true;

    function listener() {
      if (isActive) fn.apply(void 0, arguments);
    }

    listeners.push(listener);
    return function () {
      isActive = false;
      listeners = listeners.filter(function (item) {
        return item !== listener;
      });
    };
  }

  function notifyListeners() {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    listeners.forEach(function (listener) {
      return listener.apply(void 0, args);
    });
  }

  return {
    setPrompt: setPrompt,
    confirmTransitionTo: confirmTransitionTo,
    appendListener: appendListener,
    notifyListeners: notifyListeners
  };
}

var canUseDOM = !!(typeof window !== 'undefined' && window.document && window.document.createElement);
function getConfirmation(message, callback) {
  callback(window.confirm(message)); // eslint-disable-line no-alert
}
/**
 * Returns true if the HTML5 history API is supported. Taken from Modernizr.
 *
 * https://github.com/Modernizr/Modernizr/blob/master/LICENSE
 * https://github.com/Modernizr/Modernizr/blob/master/feature-detects/history.js
 * changed to avoid false negatives for Windows Phones: https://github.com/reactjs/react-router/issues/586
 */

function supportsHistory() {
  var ua = window.navigator.userAgent;
  if ((ua.indexOf('Android 2.') !== -1 || ua.indexOf('Android 4.0') !== -1) && ua.indexOf('Mobile Safari') !== -1 && ua.indexOf('Chrome') === -1 && ua.indexOf('Windows Phone') === -1) return false;
  return window.history && 'pushState' in window.history;
}
/**
 * Returns true if browser fires popstate on hash change.
 * IE10 and IE11 do not.
 */

function supportsPopStateOnHashChange() {
  return window.navigator.userAgent.indexOf('Trident') === -1;
}
/**
 * Returns false if using go(n) with hash history causes a full page reload.
 */

function supportsGoWithoutReloadUsingHash() {
  return window.navigator.userAgent.indexOf('Firefox') === -1;
}
/**
 * Returns true if a given popstate event is an extraneous WebKit event.
 * Accounts for the fact that Chrome on iOS fires real popstate events
 * containing undefined state when pressing the back button.
 */

function isExtraneousPopstateEvent(event) {
  return event.state === undefined && navigator.userAgent.indexOf('CriOS') === -1;
}

var PopStateEvent = 'popstate';
var HashChangeEvent = 'hashchange';

function getHistoryState() {
  try {
    return window.history.state || {};
  } catch (e) {
    // IE 11 sometimes throws when accessing window.history.state
    // See https://github.com/ReactTraining/history/pull/289
    return {};
  }
}
/**
 * Creates a history object that uses the HTML5 history API including
 * pushState, replaceState, and the popstate event.
 */


function createBrowserHistory(props) {
  if (props === void 0) {
    props = {};
  }

  !canUseDOM ? invariant(false, 'Browser history needs a DOM') : void 0;
  var globalHistory = window.history;
  var canUseHistory = supportsHistory();
  var needsHashChangeListener = !supportsPopStateOnHashChange();
  var _props = props,
      _props$forceRefresh = _props.forceRefresh,
      forceRefresh = _props$forceRefresh === void 0 ? false : _props$forceRefresh,
      _props$getUserConfirm = _props.getUserConfirmation,
      getUserConfirmation = _props$getUserConfirm === void 0 ? getConfirmation : _props$getUserConfirm,
      _props$keyLength = _props.keyLength,
      keyLength = _props$keyLength === void 0 ? 6 : _props$keyLength;
  var basename = props.basename ? stripTrailingSlash(addLeadingSlash(props.basename)) : '';

  function getDOMLocation(historyState) {
    var _ref = historyState || {},
        key = _ref.key,
        state = _ref.state;

    var _window$location = window.location,
        pathname = _window$location.pathname,
        search = _window$location.search,
        hash = _window$location.hash;
    var path = pathname + search + hash;
    warning(!basename || hasBasename(path, basename), 'You are attempting to use a basename on a page whose URL path does not begin ' + 'with the basename. Expected path "' + path + '" to begin with "' + basename + '".');
    if (basename) path = stripBasename(path, basename);
    return createLocation(path, state, key);
  }

  function createKey() {
    return Math.random().toString(36).substr(2, keyLength);
  }

  var transitionManager = createTransitionManager();

  function setState(nextState) {
    _extends(history, nextState);

    history.length = globalHistory.length;
    transitionManager.notifyListeners(history.location, history.action);
  }

  function handlePopState(event) {
    // Ignore extraneous popstate events in WebKit.
    if (isExtraneousPopstateEvent(event)) return;
    handlePop(getDOMLocation(event.state));
  }

  function handleHashChange() {
    handlePop(getDOMLocation(getHistoryState()));
  }

  var forceNextPop = false;

  function handlePop(location) {
    if (forceNextPop) {
      forceNextPop = false;
      setState();
    } else {
      var action = 'POP';
      transitionManager.confirmTransitionTo(location, action, getUserConfirmation, function (ok) {
        if (ok) {
          setState({
            action: action,
            location: location
          });
        } else {
          revertPop(location);
        }
      });
    }
  }

  function revertPop(fromLocation) {
    var toLocation = history.location; // TODO: We could probably make this more reliable by
    // keeping a list of keys we've seen in sessionStorage.
    // Instead, we just default to 0 for keys we don't know.

    var toIndex = allKeys.indexOf(toLocation.key);
    if (toIndex === -1) toIndex = 0;
    var fromIndex = allKeys.indexOf(fromLocation.key);
    if (fromIndex === -1) fromIndex = 0;
    var delta = toIndex - fromIndex;

    if (delta) {
      forceNextPop = true;
      go(delta);
    }
  }

  var initialLocation = getDOMLocation(getHistoryState());
  var allKeys = [initialLocation.key]; // Public interface

  function createHref(location) {
    return basename + createPath(location);
  }

  function push(path, state) {
    warning(!(typeof path === 'object' && path.state !== undefined && state !== undefined), 'You should avoid providing a 2nd state argument to push when the 1st ' + 'argument is a location-like object that already has state; it is ignored');
    var action = 'PUSH';
    var location = createLocation(path, state, createKey(), history.location);
    transitionManager.confirmTransitionTo(location, action, getUserConfirmation, function (ok) {
      if (!ok) return;
      var href = createHref(location);
      var key = location.key,
          state = location.state;

      if (canUseHistory) {
        globalHistory.pushState({
          key: key,
          state: state
        }, null, href);

        if (forceRefresh) {
          window.location.href = href;
        } else {
          var prevIndex = allKeys.indexOf(history.location.key);
          var nextKeys = allKeys.slice(0, prevIndex + 1);
          nextKeys.push(location.key);
          allKeys = nextKeys;
          setState({
            action: action,
            location: location
          });
        }
      } else {
        warning(state === undefined, 'Browser history cannot push state in browsers that do not support HTML5 history');
        window.location.href = href;
      }
    });
  }

  function replace(path, state) {
    warning(!(typeof path === 'object' && path.state !== undefined && state !== undefined), 'You should avoid providing a 2nd state argument to replace when the 1st ' + 'argument is a location-like object that already has state; it is ignored');
    var action = 'REPLACE';
    var location = createLocation(path, state, createKey(), history.location);
    transitionManager.confirmTransitionTo(location, action, getUserConfirmation, function (ok) {
      if (!ok) return;
      var href = createHref(location);
      var key = location.key,
          state = location.state;

      if (canUseHistory) {
        globalHistory.replaceState({
          key: key,
          state: state
        }, null, href);

        if (forceRefresh) {
          window.location.replace(href);
        } else {
          var prevIndex = allKeys.indexOf(history.location.key);
          if (prevIndex !== -1) allKeys[prevIndex] = location.key;
          setState({
            action: action,
            location: location
          });
        }
      } else {
        warning(state === undefined, 'Browser history cannot replace state in browsers that do not support HTML5 history');
        window.location.replace(href);
      }
    });
  }

  function go(n) {
    globalHistory.go(n);
  }

  function goBack() {
    go(-1);
  }

  function goForward() {
    go(1);
  }

  var listenerCount = 0;

  function checkDOMListeners(delta) {
    listenerCount += delta;

    if (listenerCount === 1 && delta === 1) {
      window.addEventListener(PopStateEvent, handlePopState);
      if (needsHashChangeListener) window.addEventListener(HashChangeEvent, handleHashChange);
    } else if (listenerCount === 0) {
      window.removeEventListener(PopStateEvent, handlePopState);
      if (needsHashChangeListener) window.removeEventListener(HashChangeEvent, handleHashChange);
    }
  }

  var isBlocked = false;

  function block(prompt) {
    if (prompt === void 0) {
      prompt = false;
    }

    var unblock = transitionManager.setPrompt(prompt);

    if (!isBlocked) {
      checkDOMListeners(1);
      isBlocked = true;
    }

    return function () {
      if (isBlocked) {
        isBlocked = false;
        checkDOMListeners(-1);
      }

      return unblock();
    };
  }

  function listen(listener) {
    var unlisten = transitionManager.appendListener(listener);
    checkDOMListeners(1);
    return function () {
      checkDOMListeners(-1);
      unlisten();
    };
  }

  var history = {
    length: globalHistory.length,
    action: 'POP',
    location: initialLocation,
    createHref: createHref,
    push: push,
    replace: replace,
    go: go,
    goBack: goBack,
    goForward: goForward,
    block: block,
    listen: listen
  };
  return history;
}

var HashChangeEvent$1 = 'hashchange';
var HashPathCoders = {
  hashbang: {
    encodePath: function encodePath(path) {
      return path.charAt(0) === '!' ? path : '!/' + stripLeadingSlash(path);
    },
    decodePath: function decodePath(path) {
      return path.charAt(0) === '!' ? path.substr(1) : path;
    }
  },
  noslash: {
    encodePath: stripLeadingSlash,
    decodePath: addLeadingSlash
  },
  slash: {
    encodePath: addLeadingSlash,
    decodePath: addLeadingSlash
  }
};

function stripHash(url) {
  var hashIndex = url.indexOf('#');
  return hashIndex === -1 ? url : url.slice(0, hashIndex);
}

function getHashPath() {
  // We can't use window.location.hash here because it's not
  // consistent across browsers - Firefox will pre-decode it!
  var href = window.location.href;
  var hashIndex = href.indexOf('#');
  return hashIndex === -1 ? '' : href.substring(hashIndex + 1);
}

function pushHashPath(path) {
  window.location.hash = path;
}

function replaceHashPath(path) {
  window.location.replace(stripHash(window.location.href) + '#' + path);
}

function createHashHistory(props) {
  if (props === void 0) {
    props = {};
  }

  !canUseDOM ? invariant(false, 'Hash history needs a DOM') : void 0;
  var globalHistory = window.history;
  var canGoWithoutReload = supportsGoWithoutReloadUsingHash();
  var _props = props,
      _props$getUserConfirm = _props.getUserConfirmation,
      getUserConfirmation = _props$getUserConfirm === void 0 ? getConfirmation : _props$getUserConfirm,
      _props$hashType = _props.hashType,
      hashType = _props$hashType === void 0 ? 'slash' : _props$hashType;
  var basename = props.basename ? stripTrailingSlash(addLeadingSlash(props.basename)) : '';
  var _HashPathCoders$hashT = HashPathCoders[hashType],
      encodePath = _HashPathCoders$hashT.encodePath,
      decodePath = _HashPathCoders$hashT.decodePath;

  function getDOMLocation() {
    var path = decodePath(getHashPath());
    warning(!basename || hasBasename(path, basename), 'You are attempting to use a basename on a page whose URL path does not begin ' + 'with the basename. Expected path "' + path + '" to begin with "' + basename + '".');
    if (basename) path = stripBasename(path, basename);
    return createLocation(path);
  }

  var transitionManager = createTransitionManager();

  function setState(nextState) {
    _extends(history, nextState);

    history.length = globalHistory.length;
    transitionManager.notifyListeners(history.location, history.action);
  }

  var forceNextPop = false;
  var ignorePath = null;

  function locationsAreEqual$$1(a, b) {
    return a.pathname === b.pathname && a.search === b.search && a.hash === b.hash;
  }

  function handleHashChange() {
    var path = getHashPath();
    var encodedPath = encodePath(path);

    if (path !== encodedPath) {
      // Ensure we always have a properly-encoded hash.
      replaceHashPath(encodedPath);
    } else {
      var location = getDOMLocation();
      var prevLocation = history.location;
      if (!forceNextPop && locationsAreEqual$$1(prevLocation, location)) return; // A hashchange doesn't always == location change.

      if (ignorePath === createPath(location)) return; // Ignore this change; we already setState in push/replace.

      ignorePath = null;
      handlePop(location);
    }
  }

  function handlePop(location) {
    if (forceNextPop) {
      forceNextPop = false;
      setState();
    } else {
      var action = 'POP';
      transitionManager.confirmTransitionTo(location, action, getUserConfirmation, function (ok) {
        if (ok) {
          setState({
            action: action,
            location: location
          });
        } else {
          revertPop(location);
        }
      });
    }
  }

  function revertPop(fromLocation) {
    var toLocation = history.location; // TODO: We could probably make this more reliable by
    // keeping a list of paths we've seen in sessionStorage.
    // Instead, we just default to 0 for paths we don't know.

    var toIndex = allPaths.lastIndexOf(createPath(toLocation));
    if (toIndex === -1) toIndex = 0;
    var fromIndex = allPaths.lastIndexOf(createPath(fromLocation));
    if (fromIndex === -1) fromIndex = 0;
    var delta = toIndex - fromIndex;

    if (delta) {
      forceNextPop = true;
      go(delta);
    }
  } // Ensure the hash is encoded properly before doing anything else.


  var path = getHashPath();
  var encodedPath = encodePath(path);
  if (path !== encodedPath) replaceHashPath(encodedPath);
  var initialLocation = getDOMLocation();
  var allPaths = [createPath(initialLocation)]; // Public interface

  function createHref(location) {
    var baseTag = document.querySelector('base');
    var href = '';

    if (baseTag && baseTag.getAttribute('href')) {
      href = stripHash(window.location.href);
    }

    return href + '#' + encodePath(basename + createPath(location));
  }

  function push(path, state) {
    warning(state === undefined, 'Hash history cannot push state; it is ignored');
    var action = 'PUSH';
    var location = createLocation(path, undefined, undefined, history.location);
    transitionManager.confirmTransitionTo(location, action, getUserConfirmation, function (ok) {
      if (!ok) return;
      var path = createPath(location);
      var encodedPath = encodePath(basename + path);
      var hashChanged = getHashPath() !== encodedPath;

      if (hashChanged) {
        // We cannot tell if a hashchange was caused by a PUSH, so we'd
        // rather setState here and ignore the hashchange. The caveat here
        // is that other hash histories in the page will consider it a POP.
        ignorePath = path;
        pushHashPath(encodedPath);
        var prevIndex = allPaths.lastIndexOf(createPath(history.location));
        var nextPaths = allPaths.slice(0, prevIndex + 1);
        nextPaths.push(path);
        allPaths = nextPaths;
        setState({
          action: action,
          location: location
        });
      } else {
        warning(false, 'Hash history cannot PUSH the same path; a new entry will not be added to the history stack');
        setState();
      }
    });
  }

  function replace(path, state) {
    warning(state === undefined, 'Hash history cannot replace state; it is ignored');
    var action = 'REPLACE';
    var location = createLocation(path, undefined, undefined, history.location);
    transitionManager.confirmTransitionTo(location, action, getUserConfirmation, function (ok) {
      if (!ok) return;
      var path = createPath(location);
      var encodedPath = encodePath(basename + path);
      var hashChanged = getHashPath() !== encodedPath;

      if (hashChanged) {
        // We cannot tell if a hashchange was caused by a REPLACE, so we'd
        // rather setState here and ignore the hashchange. The caveat here
        // is that other hash histories in the page will consider it a POP.
        ignorePath = path;
        replaceHashPath(encodedPath);
      }

      var prevIndex = allPaths.indexOf(createPath(history.location));
      if (prevIndex !== -1) allPaths[prevIndex] = path;
      setState({
        action: action,
        location: location
      });
    });
  }

  function go(n) {
    warning(canGoWithoutReload, 'Hash history go(n) causes a full page reload in this browser');
    globalHistory.go(n);
  }

  function goBack() {
    go(-1);
  }

  function goForward() {
    go(1);
  }

  var listenerCount = 0;

  function checkDOMListeners(delta) {
    listenerCount += delta;

    if (listenerCount === 1 && delta === 1) {
      window.addEventListener(HashChangeEvent$1, handleHashChange);
    } else if (listenerCount === 0) {
      window.removeEventListener(HashChangeEvent$1, handleHashChange);
    }
  }

  var isBlocked = false;

  function block(prompt) {
    if (prompt === void 0) {
      prompt = false;
    }

    var unblock = transitionManager.setPrompt(prompt);

    if (!isBlocked) {
      checkDOMListeners(1);
      isBlocked = true;
    }

    return function () {
      if (isBlocked) {
        isBlocked = false;
        checkDOMListeners(-1);
      }

      return unblock();
    };
  }

  function listen(listener) {
    var unlisten = transitionManager.appendListener(listener);
    checkDOMListeners(1);
    return function () {
      checkDOMListeners(-1);
      unlisten();
    };
  }

  var history = {
    length: globalHistory.length,
    action: 'POP',
    location: initialLocation,
    createHref: createHref,
    push: push,
    replace: replace,
    go: go,
    goBack: goBack,
    goForward: goForward,
    block: block,
    listen: listen
  };
  return history;
}

function clamp(n, lowerBound, upperBound) {
  return Math.min(Math.max(n, lowerBound), upperBound);
}
/**
 * Creates a history object that stores locations in memory.
 */


function createMemoryHistory(props) {
  if (props === void 0) {
    props = {};
  }

  var _props = props,
      getUserConfirmation = _props.getUserConfirmation,
      _props$initialEntries = _props.initialEntries,
      initialEntries = _props$initialEntries === void 0 ? ['/'] : _props$initialEntries,
      _props$initialIndex = _props.initialIndex,
      initialIndex = _props$initialIndex === void 0 ? 0 : _props$initialIndex,
      _props$keyLength = _props.keyLength,
      keyLength = _props$keyLength === void 0 ? 6 : _props$keyLength;
  var transitionManager = createTransitionManager();

  function setState(nextState) {
    _extends(history, nextState);

    history.length = history.entries.length;
    transitionManager.notifyListeners(history.location, history.action);
  }

  function createKey() {
    return Math.random().toString(36).substr(2, keyLength);
  }

  var index = clamp(initialIndex, 0, initialEntries.length - 1);
  var entries = initialEntries.map(function (entry) {
    return typeof entry === 'string' ? createLocation(entry, undefined, createKey()) : createLocation(entry, undefined, entry.key || createKey());
  }); // Public interface

  var createHref = createPath;

  function push(path, state) {
    warning(!(typeof path === 'object' && path.state !== undefined && state !== undefined), 'You should avoid providing a 2nd state argument to push when the 1st ' + 'argument is a location-like object that already has state; it is ignored');
    var action = 'PUSH';
    var location = createLocation(path, state, createKey(), history.location);
    transitionManager.confirmTransitionTo(location, action, getUserConfirmation, function (ok) {
      if (!ok) return;
      var prevIndex = history.index;
      var nextIndex = prevIndex + 1;
      var nextEntries = history.entries.slice(0);

      if (nextEntries.length > nextIndex) {
        nextEntries.splice(nextIndex, nextEntries.length - nextIndex, location);
      } else {
        nextEntries.push(location);
      }

      setState({
        action: action,
        location: location,
        index: nextIndex,
        entries: nextEntries
      });
    });
  }

  function replace(path, state) {
    warning(!(typeof path === 'object' && path.state !== undefined && state !== undefined), 'You should avoid providing a 2nd state argument to replace when the 1st ' + 'argument is a location-like object that already has state; it is ignored');
    var action = 'REPLACE';
    var location = createLocation(path, state, createKey(), history.location);
    transitionManager.confirmTransitionTo(location, action, getUserConfirmation, function (ok) {
      if (!ok) return;
      history.entries[history.index] = location;
      setState({
        action: action,
        location: location
      });
    });
  }

  function go(n) {
    var nextIndex = clamp(history.index + n, 0, history.entries.length - 1);
    var action = 'POP';
    var location = history.entries[nextIndex];
    transitionManager.confirmTransitionTo(location, action, getUserConfirmation, function (ok) {
      if (ok) {
        setState({
          action: action,
          location: location,
          index: nextIndex
        });
      } else {
        // Mimic the behavior of DOM histories by
        // causing a render after a cancelled POP.
        setState();
      }
    });
  }

  function goBack() {
    go(-1);
  }

  function goForward() {
    go(1);
  }

  function canGo(n) {
    var nextIndex = history.index + n;
    return nextIndex >= 0 && nextIndex < history.entries.length;
  }

  function block(prompt) {
    if (prompt === void 0) {
      prompt = false;
    }

    return transitionManager.setPrompt(prompt);
  }

  function listen(listener) {
    return transitionManager.appendListener(listener);
  }

  var history = {
    length: entries.length,
    action: 'POP',
    location: entries[index],
    index: index,
    entries: entries,
    createHref: createHref,
    push: push,
    replace: replace,
    go: go,
    goBack: goBack,
    goForward: goForward,
    canGo: canGo,
    block: block,
    listen: listen
  };
  return history;
}

exports.createBrowserHistory = createBrowserHistory;
exports.createHashHistory = createHashHistory;
exports.createMemoryHistory = createMemoryHistory;
exports.createLocation = createLocation;
exports.locationsAreEqual = locationsAreEqual;
exports.parsePath = parsePath;
exports.createPath = createPath;

      };
    };
  }
  }
}, {package:"react-router-dom>history",file:"node_modules\\react-router-dom\\node_modules\\history\\cjs\\history.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\node_modules\\history\\cjs\\history.min.js", {"resolve-pathname":"D:\\code\\v\\metamask-extension\\node_modules\\resolve-pathname\\index.js","tiny-invariant":"D:\\code\\v\\metamask-extension\\node_modules\\tiny-invariant\\dist\\tiny-invariant.cjs.js","tiny-warning":"D:\\code\\v\\metamask-extension\\node_modules\\tiny-warning\\dist\\tiny-warning.cjs.js","value-equal":"D:\\code\\v\\metamask-extension\\node_modules\\value-equal\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Creact-router-dom%5Cnode_modules%5Chistory%5Ccjs%5Chistory.min.js
      return function (require, module, exports) {
"use strict";function _interopDefault(t){return t&&"object"==typeof t&&"default"in t?t.default:t}Object.defineProperty(exports,"__esModule",{value:!0});var resolvePathname=_interopDefault(require("resolve-pathname")),valueEqual=_interopDefault(require("value-equal"));require("tiny-warning");var invariant=_interopDefault(require("tiny-invariant"));function _extends(){return(_extends=Object.assign||function(t){for(var n=1;n<arguments.length;n++){var e=arguments[n];for(var a in e)Object.prototype.hasOwnProperty.call(e,a)&&(t[a]=e[a])}return t}).apply(this,arguments)}function addLeadingSlash(t){return"/"===t.charAt(0)?t:"/"+t}function stripLeadingSlash(t){return"/"===t.charAt(0)?t.substr(1):t}function hasBasename(t,n){return 0===t.toLowerCase().indexOf(n.toLowerCase())&&-1!=="/?#".indexOf(t.charAt(n.length))}function stripBasename(t,n){return hasBasename(t,n)?t.substr(n.length):t}function stripTrailingSlash(t){return"/"===t.charAt(t.length-1)?t.slice(0,-1):t}function parsePath(t){var n=t||"/",e="",a="",r=n.indexOf("#");-1!==r&&(a=n.substr(r),n=n.substr(0,r));var o=n.indexOf("?");return-1!==o&&(e=n.substr(o),n=n.substr(0,o)),{pathname:n,search:"?"===e?"":e,hash:"#"===a?"":a}}function createPath(t){var n=t.pathname,e=t.search,a=t.hash,r=n||"/";return e&&"?"!==e&&(r+="?"===e.charAt(0)?e:"?"+e),a&&"#"!==a&&(r+="#"===a.charAt(0)?a:"#"+a),r}function createLocation(t,n,e,a){var r;"string"==typeof t?(r=parsePath(t)).state=n:(void 0===(r=_extends({},t)).pathname&&(r.pathname=""),r.search?"?"!==r.search.charAt(0)&&(r.search="?"+r.search):r.search="",r.hash?"#"!==r.hash.charAt(0)&&(r.hash="#"+r.hash):r.hash="",void 0!==n&&void 0===r.state&&(r.state=n));try{r.pathname=decodeURI(r.pathname)}catch(t){throw t instanceof URIError?new URIError('Pathname "'+r.pathname+'" could not be decoded. This is likely caused by an invalid percent-encoding.'):t}return e&&(r.key=e),a?r.pathname?"/"!==r.pathname.charAt(0)&&(r.pathname=resolvePathname(r.pathname,a.pathname)):r.pathname=a.pathname:r.pathname||(r.pathname="/"),r}function locationsAreEqual(t,n){return t.pathname===n.pathname&&t.search===n.search&&t.hash===n.hash&&t.key===n.key&&valueEqual(t.state,n.state)}function createTransitionManager(){var o=null;var a=[];return{setPrompt:function(t){return o=t,function(){o===t&&(o=null)}},confirmTransitionTo:function(t,n,e,a){if(null!=o){var r="function"==typeof o?o(t,n):o;"string"==typeof r?"function"==typeof e?e(r,a):a(!0):a(!1!==r)}else a(!0)},appendListener:function(t){var n=!0;function e(){n&&t.apply(void 0,arguments)}return a.push(e),function(){n=!1,a=a.filter(function(t){return t!==e})}},notifyListeners:function(){for(var t=arguments.length,n=new Array(t),e=0;e<t;e++)n[e]=arguments[e];a.forEach(function(t){return t.apply(void 0,n)})}}}var canUseDOM=!("undefined"==typeof window||!window.document||!window.document.createElement);function getConfirmation(t,n){n(window.confirm(t))}function supportsHistory(){var t=window.navigator.userAgent;return(-1===t.indexOf("Android 2.")&&-1===t.indexOf("Android 4.0")||-1===t.indexOf("Mobile Safari")||-1!==t.indexOf("Chrome")||-1!==t.indexOf("Windows Phone"))&&(window.history&&"pushState"in window.history)}function supportsPopStateOnHashChange(){return-1===window.navigator.userAgent.indexOf("Trident")}function supportsGoWithoutReloadUsingHash(){return-1===window.navigator.userAgent.indexOf("Firefox")}function isExtraneousPopstateEvent(t){return void 0===t.state&&-1===navigator.userAgent.indexOf("CriOS")}var PopStateEvent="popstate",HashChangeEvent="hashchange";function getHistoryState(){try{return window.history.state||{}}catch(t){return{}}}function createBrowserHistory(t){void 0===t&&(t={}),canUseDOM||invariant(!1);var s=window.history,c=supportsHistory(),n=!supportsPopStateOnHashChange(),e=t,a=e.forceRefresh,h=void 0!==a&&a,r=e.getUserConfirmation,u=void 0===r?getConfirmation:r,o=e.keyLength,i=void 0===o?6:o,f=t.basename?stripTrailingSlash(addLeadingSlash(t.basename)):"";function l(t){var n=t||{},e=n.key,a=n.state,r=window.location,o=r.pathname+r.search+r.hash;return f&&(o=stripBasename(o,f)),createLocation(o,a,e)}function d(){return Math.random().toString(36).substr(2,i)}var v=createTransitionManager();function p(t){_extends(T,t),T.length=s.length,v.notifyListeners(T.location,T.action)}function g(t){isExtraneousPopstateEvent(t)||w(l(t.state))}function P(){w(l(getHistoryState()))}var m=!1;function w(n){if(m)m=!1,p();else{v.confirmTransitionTo(n,"POP",u,function(t){t?p({action:"POP",location:n}):function(t){var n=T.location,e=H.indexOf(n.key);-1===e&&(e=0);var a=H.indexOf(t.key);-1===a&&(a=0);var r=e-a;r&&(m=!0,L(r))}(n)})}}var y=l(getHistoryState()),H=[y.key];function x(t){return f+createPath(t)}function L(t){s.go(t)}var O=0;function E(t){1===(O+=t)&&1===t?(window.addEventListener(PopStateEvent,g),n&&window.addEventListener(HashChangeEvent,P)):0===O&&(window.removeEventListener(PopStateEvent,g),n&&window.removeEventListener(HashChangeEvent,P))}var S=!1;var T={length:s.length,action:"POP",location:y,createHref:x,push:function(t,n){var i=createLocation(t,n,d(),T.location);v.confirmTransitionTo(i,"PUSH",u,function(t){if(t){var n=x(i),e=i.key,a=i.state;if(c)if(s.pushState({key:e,state:a},null,n),h)window.location.href=n;else{var r=H.indexOf(T.location.key),o=H.slice(0,r+1);o.push(i.key),H=o,p({action:"PUSH",location:i})}else window.location.href=n}})},replace:function(t,n){var o="REPLACE",i=createLocation(t,n,d(),T.location);v.confirmTransitionTo(i,o,u,function(t){if(t){var n=x(i),e=i.key,a=i.state;if(c)if(s.replaceState({key:e,state:a},null,n),h)window.location.replace(n);else{var r=H.indexOf(T.location.key);-1!==r&&(H[r]=i.key),p({action:o,location:i})}else window.location.replace(n)}})},go:L,goBack:function(){L(-1)},goForward:function(){L(1)},block:function(t){void 0===t&&(t=!1);var n=v.setPrompt(t);return S||(E(1),S=!0),function(){return S&&(S=!1,E(-1)),n()}},listen:function(t){var n=v.appendListener(t);return E(1),function(){E(-1),n()}}};return T}var HashChangeEvent$1="hashchange",HashPathCoders={hashbang:{encodePath:function(t){return"!"===t.charAt(0)?t:"!/"+stripLeadingSlash(t)},decodePath:function(t){return"!"===t.charAt(0)?t.substr(1):t}},noslash:{encodePath:stripLeadingSlash,decodePath:addLeadingSlash},slash:{encodePath:addLeadingSlash,decodePath:addLeadingSlash}};function stripHash(t){var n=t.indexOf("#");return-1===n?t:t.slice(0,n)}function getHashPath(){var t=window.location.href,n=t.indexOf("#");return-1===n?"":t.substring(n+1)}function pushHashPath(t){window.location.hash=t}function replaceHashPath(t){window.location.replace(stripHash(window.location.href)+"#"+t)}function createHashHistory(t){void 0===t&&(t={}),canUseDOM||invariant(!1);var n=window.history,e=(supportsGoWithoutReloadUsingHash(),t),a=e.getUserConfirmation,i=void 0===a?getConfirmation:a,r=e.hashType,o=void 0===r?"slash":r,s=t.basename?stripTrailingSlash(addLeadingSlash(t.basename)):"",c=HashPathCoders[o],h=c.encodePath,u=c.decodePath;function f(){var t=u(getHashPath());return s&&(t=stripBasename(t,s)),createLocation(t)}var l=createTransitionManager();function d(t){_extends(E,t),E.length=n.length,l.notifyListeners(E.location,E.action)}var v=!1,p=null;function g(){var t=getHashPath(),n=h(t);if(t!==n)replaceHashPath(n);else{var e=f(),a=E.location;if(!v&&function(t,n){return t.pathname===n.pathname&&t.search===n.search&&t.hash===n.hash}(a,e))return;if(p===createPath(e))return;p=null,function(n){if(v)v=!1,d();else{l.confirmTransitionTo(n,"POP",i,function(t){t?d({action:"POP",location:n}):function(t){var n=E.location,e=y.lastIndexOf(createPath(n));-1===e&&(e=0);var a=y.lastIndexOf(createPath(t));-1===a&&(a=0);var r=e-a;r&&(v=!0,H(r))}(n)})}}(e)}}var P=getHashPath(),m=h(P);P!==m&&replaceHashPath(m);var w=f(),y=[createPath(w)];function H(t){n.go(t)}var x=0;function L(t){1===(x+=t)&&1===t?window.addEventListener(HashChangeEvent$1,g):0===x&&window.removeEventListener(HashChangeEvent$1,g)}var O=!1;var E={length:n.length,action:"POP",location:w,createHref:function(t){var n=document.querySelector("base"),e="";return n&&n.getAttribute("href")&&(e=stripHash(window.location.href)),e+"#"+h(s+createPath(t))},push:function(t,n){var o=createLocation(t,void 0,void 0,E.location);l.confirmTransitionTo(o,"PUSH",i,function(t){if(t){var n=createPath(o),e=h(s+n);if(getHashPath()!==e){p=n,pushHashPath(e);var a=y.lastIndexOf(createPath(E.location)),r=y.slice(0,a+1);r.push(n),y=r,d({action:"PUSH",location:o})}else d()}})},replace:function(t,n){var r="REPLACE",o=createLocation(t,void 0,void 0,E.location);l.confirmTransitionTo(o,r,i,function(t){if(t){var n=createPath(o),e=h(s+n);getHashPath()!==e&&(p=n,replaceHashPath(e));var a=y.indexOf(createPath(E.location));-1!==a&&(y[a]=n),d({action:r,location:o})}})},go:H,goBack:function(){H(-1)},goForward:function(){H(1)},block:function(t){void 0===t&&(t=!1);var n=l.setPrompt(t);return O||(L(1),O=!0),function(){return O&&(O=!1,L(-1)),n()}},listen:function(t){var n=l.appendListener(t);return L(1),function(){L(-1),n()}}};return E}function clamp(t,n,e){return Math.min(Math.max(t,n),e)}function createMemoryHistory(t){void 0===t&&(t={});var n=t,r=n.getUserConfirmation,e=n.initialEntries,a=void 0===e?["/"]:e,o=n.initialIndex,i=void 0===o?0:o,s=n.keyLength,c=void 0===s?6:s,h=createTransitionManager();function u(t){_extends(g,t),g.length=g.entries.length,h.notifyListeners(g.location,g.action)}function f(){return Math.random().toString(36).substr(2,c)}var l=clamp(i,0,a.length-1),d=a.map(function(t){return createLocation(t,void 0,"string"==typeof t?f():t.key||f())}),v=createPath;function p(t){var n=clamp(g.index+t,0,g.entries.length-1),e=g.entries[n];h.confirmTransitionTo(e,"POP",r,function(t){t?u({action:"POP",location:e,index:n}):u()})}var g={length:d.length,action:"POP",location:d[l],index:l,entries:d,createHref:v,push:function(t,n){var a=createLocation(t,n,f(),g.location);h.confirmTransitionTo(a,"PUSH",r,function(t){if(t){var n=g.index+1,e=g.entries.slice(0);e.length>n?e.splice(n,e.length-n,a):e.push(a),u({action:"PUSH",location:a,index:n,entries:e})}})},replace:function(t,n){var e="REPLACE",a=createLocation(t,n,f(),g.location);h.confirmTransitionTo(a,e,r,function(t){t&&(g.entries[g.index]=a,u({action:e,location:a}))})},go:p,goBack:function(){p(-1)},goForward:function(){p(1)},canGo:function(t){var n=g.index+t;return 0<=n&&n<g.entries.length},block:function(t){return void 0===t&&(t=!1),h.setPrompt(t)},listen:function(t){return h.appendListener(t)}};return g}exports.createBrowserHistory=createBrowserHistory,exports.createHashHistory=createHashHistory,exports.createMemoryHistory=createMemoryHistory,exports.createLocation=createLocation,exports.locationsAreEqual=locationsAreEqual,exports.parsePath=parsePath,exports.createPath=createPath;

      };
    };
  }
  }
}, {package:"react-router-dom>history",file:"node_modules\\react-router-dom\\node_modules\\history\\cjs\\history.min.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\node_modules\\history\\index.js", {"./cjs/history.js":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\node_modules\\history\\cjs\\history.js","./cjs/history.min.js":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\node_modules\\history\\cjs\\history.min.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Creact-router-dom%5Cnode_modules%5Chistory%5Cindex.js
      return function (require, module, exports) {
'use strict';

if ("development" === 'production') {
  module.exports = require('./cjs/history.min.js');
} else {
  module.exports = require('./cjs/history.js');
}

      };
    };
  }
  }
}, {package:"react-router-dom>history",file:"node_modules\\react-router-dom\\node_modules\\history\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\node_modules\\react-is\\cjs\\react-is.development.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Creact-router-dom%5Cnode_modules%5Creact-is%5Ccjs%5Creact-is.development.js
      return function (require, module, exports) {
/** @license React v16.13.1
 * react-is.development.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

'use strict';



if ("development" !== "production") {
  (function() {
'use strict';

// The Symbol used to tag the ReactElement-like types. If there is no native Symbol
// nor polyfill, then a plain number is used for performance.
var hasSymbol = typeof Symbol === 'function' && Symbol.for;
var REACT_ELEMENT_TYPE = hasSymbol ? Symbol.for('react.element') : 0xeac7;
var REACT_PORTAL_TYPE = hasSymbol ? Symbol.for('react.portal') : 0xeaca;
var REACT_FRAGMENT_TYPE = hasSymbol ? Symbol.for('react.fragment') : 0xeacb;
var REACT_STRICT_MODE_TYPE = hasSymbol ? Symbol.for('react.strict_mode') : 0xeacc;
var REACT_PROFILER_TYPE = hasSymbol ? Symbol.for('react.profiler') : 0xead2;
var REACT_PROVIDER_TYPE = hasSymbol ? Symbol.for('react.provider') : 0xeacd;
var REACT_CONTEXT_TYPE = hasSymbol ? Symbol.for('react.context') : 0xeace; // TODO: We don't use AsyncMode or ConcurrentMode anymore. They were temporary
// (unstable) APIs that have been removed. Can we remove the symbols?

var REACT_ASYNC_MODE_TYPE = hasSymbol ? Symbol.for('react.async_mode') : 0xeacf;
var REACT_CONCURRENT_MODE_TYPE = hasSymbol ? Symbol.for('react.concurrent_mode') : 0xeacf;
var REACT_FORWARD_REF_TYPE = hasSymbol ? Symbol.for('react.forward_ref') : 0xead0;
var REACT_SUSPENSE_TYPE = hasSymbol ? Symbol.for('react.suspense') : 0xead1;
var REACT_SUSPENSE_LIST_TYPE = hasSymbol ? Symbol.for('react.suspense_list') : 0xead8;
var REACT_MEMO_TYPE = hasSymbol ? Symbol.for('react.memo') : 0xead3;
var REACT_LAZY_TYPE = hasSymbol ? Symbol.for('react.lazy') : 0xead4;
var REACT_BLOCK_TYPE = hasSymbol ? Symbol.for('react.block') : 0xead9;
var REACT_FUNDAMENTAL_TYPE = hasSymbol ? Symbol.for('react.fundamental') : 0xead5;
var REACT_RESPONDER_TYPE = hasSymbol ? Symbol.for('react.responder') : 0xead6;
var REACT_SCOPE_TYPE = hasSymbol ? Symbol.for('react.scope') : 0xead7;

function isValidElementType(type) {
  return typeof type === 'string' || typeof type === 'function' || // Note: its typeof might be other than 'symbol' or 'number' if it's a polyfill.
  type === REACT_FRAGMENT_TYPE || type === REACT_CONCURRENT_MODE_TYPE || type === REACT_PROFILER_TYPE || type === REACT_STRICT_MODE_TYPE || type === REACT_SUSPENSE_TYPE || type === REACT_SUSPENSE_LIST_TYPE || typeof type === 'object' && type !== null && (type.$$typeof === REACT_LAZY_TYPE || type.$$typeof === REACT_MEMO_TYPE || type.$$typeof === REACT_PROVIDER_TYPE || type.$$typeof === REACT_CONTEXT_TYPE || type.$$typeof === REACT_FORWARD_REF_TYPE || type.$$typeof === REACT_FUNDAMENTAL_TYPE || type.$$typeof === REACT_RESPONDER_TYPE || type.$$typeof === REACT_SCOPE_TYPE || type.$$typeof === REACT_BLOCK_TYPE);
}

function typeOf(object) {
  if (typeof object === 'object' && object !== null) {
    var $$typeof = object.$$typeof;

    switch ($$typeof) {
      case REACT_ELEMENT_TYPE:
        var type = object.type;

        switch (type) {
          case REACT_ASYNC_MODE_TYPE:
          case REACT_CONCURRENT_MODE_TYPE:
          case REACT_FRAGMENT_TYPE:
          case REACT_PROFILER_TYPE:
          case REACT_STRICT_MODE_TYPE:
          case REACT_SUSPENSE_TYPE:
            return type;

          default:
            var $$typeofType = type && type.$$typeof;

            switch ($$typeofType) {
              case REACT_CONTEXT_TYPE:
              case REACT_FORWARD_REF_TYPE:
              case REACT_LAZY_TYPE:
              case REACT_MEMO_TYPE:
              case REACT_PROVIDER_TYPE:
                return $$typeofType;

              default:
                return $$typeof;
            }

        }

      case REACT_PORTAL_TYPE:
        return $$typeof;
    }
  }

  return undefined;
} // AsyncMode is deprecated along with isAsyncMode

var AsyncMode = REACT_ASYNC_MODE_TYPE;
var ConcurrentMode = REACT_CONCURRENT_MODE_TYPE;
var ContextConsumer = REACT_CONTEXT_TYPE;
var ContextProvider = REACT_PROVIDER_TYPE;
var Element = REACT_ELEMENT_TYPE;
var ForwardRef = REACT_FORWARD_REF_TYPE;
var Fragment = REACT_FRAGMENT_TYPE;
var Lazy = REACT_LAZY_TYPE;
var Memo = REACT_MEMO_TYPE;
var Portal = REACT_PORTAL_TYPE;
var Profiler = REACT_PROFILER_TYPE;
var StrictMode = REACT_STRICT_MODE_TYPE;
var Suspense = REACT_SUSPENSE_TYPE;
var hasWarnedAboutDeprecatedIsAsyncMode = false; // AsyncMode should be deprecated

function isAsyncMode(object) {
  {
    if (!hasWarnedAboutDeprecatedIsAsyncMode) {
      hasWarnedAboutDeprecatedIsAsyncMode = true; // Using console['warn'] to evade Babel and ESLint

      console['warn']('The ReactIs.isAsyncMode() alias has been deprecated, ' + 'and will be removed in React 17+. Update your code to use ' + 'ReactIs.isConcurrentMode() instead. It has the exact same API.');
    }
  }

  return isConcurrentMode(object) || typeOf(object) === REACT_ASYNC_MODE_TYPE;
}
function isConcurrentMode(object) {
  return typeOf(object) === REACT_CONCURRENT_MODE_TYPE;
}
function isContextConsumer(object) {
  return typeOf(object) === REACT_CONTEXT_TYPE;
}
function isContextProvider(object) {
  return typeOf(object) === REACT_PROVIDER_TYPE;
}
function isElement(object) {
  return typeof object === 'object' && object !== null && object.$$typeof === REACT_ELEMENT_TYPE;
}
function isForwardRef(object) {
  return typeOf(object) === REACT_FORWARD_REF_TYPE;
}
function isFragment(object) {
  return typeOf(object) === REACT_FRAGMENT_TYPE;
}
function isLazy(object) {
  return typeOf(object) === REACT_LAZY_TYPE;
}
function isMemo(object) {
  return typeOf(object) === REACT_MEMO_TYPE;
}
function isPortal(object) {
  return typeOf(object) === REACT_PORTAL_TYPE;
}
function isProfiler(object) {
  return typeOf(object) === REACT_PROFILER_TYPE;
}
function isStrictMode(object) {
  return typeOf(object) === REACT_STRICT_MODE_TYPE;
}
function isSuspense(object) {
  return typeOf(object) === REACT_SUSPENSE_TYPE;
}

exports.AsyncMode = AsyncMode;
exports.ConcurrentMode = ConcurrentMode;
exports.ContextConsumer = ContextConsumer;
exports.ContextProvider = ContextProvider;
exports.Element = Element;
exports.ForwardRef = ForwardRef;
exports.Fragment = Fragment;
exports.Lazy = Lazy;
exports.Memo = Memo;
exports.Portal = Portal;
exports.Profiler = Profiler;
exports.StrictMode = StrictMode;
exports.Suspense = Suspense;
exports.isAsyncMode = isAsyncMode;
exports.isConcurrentMode = isConcurrentMode;
exports.isContextConsumer = isContextConsumer;
exports.isContextProvider = isContextProvider;
exports.isElement = isElement;
exports.isForwardRef = isForwardRef;
exports.isFragment = isFragment;
exports.isLazy = isLazy;
exports.isMemo = isMemo;
exports.isPortal = isPortal;
exports.isProfiler = isProfiler;
exports.isStrictMode = isStrictMode;
exports.isSuspense = isSuspense;
exports.isValidElementType = isValidElementType;
exports.typeOf = typeOf;
  })();
}

      };
    };
  }
  }
}, {package:"react-router-dom>react-router>react-is",file:"node_modules\\react-router-dom\\node_modules\\react-is\\cjs\\react-is.development.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\node_modules\\react-is\\cjs\\react-is.production.min.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Creact-router-dom%5Cnode_modules%5Creact-is%5Ccjs%5Creact-is.production.min.js
      return function (require, module, exports) {
/** @license React v16.13.1
 * react-is.production.min.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

'use strict';var b="function"===typeof Symbol&&Symbol.for,c=b?Symbol.for("react.element"):60103,d=b?Symbol.for("react.portal"):60106,e=b?Symbol.for("react.fragment"):60107,f=b?Symbol.for("react.strict_mode"):60108,g=b?Symbol.for("react.profiler"):60114,h=b?Symbol.for("react.provider"):60109,k=b?Symbol.for("react.context"):60110,l=b?Symbol.for("react.async_mode"):60111,m=b?Symbol.for("react.concurrent_mode"):60111,n=b?Symbol.for("react.forward_ref"):60112,p=b?Symbol.for("react.suspense"):60113,q=b?
Symbol.for("react.suspense_list"):60120,r=b?Symbol.for("react.memo"):60115,t=b?Symbol.for("react.lazy"):60116,v=b?Symbol.for("react.block"):60121,w=b?Symbol.for("react.fundamental"):60117,x=b?Symbol.for("react.responder"):60118,y=b?Symbol.for("react.scope"):60119;
function z(a){if("object"===typeof a&&null!==a){var u=a.$$typeof;switch(u){case c:switch(a=a.type,a){case l:case m:case e:case g:case f:case p:return a;default:switch(a=a&&a.$$typeof,a){case k:case n:case t:case r:case h:return a;default:return u}}case d:return u}}}function A(a){return z(a)===m}exports.AsyncMode=l;exports.ConcurrentMode=m;exports.ContextConsumer=k;exports.ContextProvider=h;exports.Element=c;exports.ForwardRef=n;exports.Fragment=e;exports.Lazy=t;exports.Memo=r;exports.Portal=d;
exports.Profiler=g;exports.StrictMode=f;exports.Suspense=p;exports.isAsyncMode=function(a){return A(a)||z(a)===l};exports.isConcurrentMode=A;exports.isContextConsumer=function(a){return z(a)===k};exports.isContextProvider=function(a){return z(a)===h};exports.isElement=function(a){return"object"===typeof a&&null!==a&&a.$$typeof===c};exports.isForwardRef=function(a){return z(a)===n};exports.isFragment=function(a){return z(a)===e};exports.isLazy=function(a){return z(a)===t};
exports.isMemo=function(a){return z(a)===r};exports.isPortal=function(a){return z(a)===d};exports.isProfiler=function(a){return z(a)===g};exports.isStrictMode=function(a){return z(a)===f};exports.isSuspense=function(a){return z(a)===p};
exports.isValidElementType=function(a){return"string"===typeof a||"function"===typeof a||a===e||a===m||a===g||a===f||a===p||a===q||"object"===typeof a&&null!==a&&(a.$$typeof===t||a.$$typeof===r||a.$$typeof===h||a.$$typeof===k||a.$$typeof===n||a.$$typeof===w||a.$$typeof===x||a.$$typeof===y||a.$$typeof===v)};exports.typeOf=z;

      };
    };
  }
  }
}, {package:"react-router-dom>react-router>react-is",file:"node_modules\\react-router-dom\\node_modules\\react-is\\cjs\\react-is.production.min.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\node_modules\\react-is\\index.js", {"./cjs/react-is.development.js":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\node_modules\\react-is\\cjs\\react-is.development.js","./cjs/react-is.production.min.js":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\node_modules\\react-is\\cjs\\react-is.production.min.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Creact-router-dom%5Cnode_modules%5Creact-is%5Cindex.js
      return function (require, module, exports) {
'use strict';

if ("development" === 'production') {
  module.exports = require('./cjs/react-is.production.min.js');
} else {
  module.exports = require('./cjs/react-is.development.js');
}

      };
    };
  }
  }
}, {package:"react-router-dom>react-router>react-is",file:"node_modules\\react-router-dom\\node_modules\\react-is\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\node_modules\\react-router\\cjs\\react-router.js", {"history":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\node_modules\\history\\index.js","hoist-non-react-statics":"D:\\code\\v\\metamask-extension\\node_modules\\hoist-non-react-statics\\dist\\hoist-non-react-statics.cjs.js","path-to-regexp":"D:\\code\\v\\metamask-extension\\node_modules\\path-to-regexp\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-is":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\node_modules\\react-is\\index.js","tiny-invariant":"D:\\code\\v\\metamask-extension\\node_modules\\tiny-invariant\\dist\\tiny-invariant.cjs.js","tiny-warning":"D:\\code\\v\\metamask-extension\\node_modules\\tiny-warning\\dist\\tiny-warning.cjs.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Creact-router-dom%5Cnode_modules%5Creact-router%5Ccjs%5Creact-router.js
      return function (require, module, exports) {
'use strict';

function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

var React = _interopDefault(require('react'));
var PropTypes = _interopDefault(require('prop-types'));
var history = require('history');
var warning = _interopDefault(require('tiny-warning'));
var invariant = _interopDefault(require('tiny-invariant'));
var pathToRegexp = _interopDefault(require('path-to-regexp'));
var reactIs = require('react-is');
var hoistStatics = _interopDefault(require('hoist-non-react-statics'));

function _extends() {
  _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  };

  return _extends.apply(this, arguments);
}

function _inheritsLoose(subClass, superClass) {
  subClass.prototype = Object.create(superClass.prototype);
  subClass.prototype.constructor = subClass;

  _setPrototypeOf(subClass, superClass);
}

function _setPrototypeOf(o, p) {
  _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
    o.__proto__ = p;
    return o;
  };

  return _setPrototypeOf(o, p);
}

function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;

  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }

  return target;
}

var MAX_SIGNED_31_BIT_INT = 1073741823;
var commonjsGlobal = typeof globalThis !== "undefined" // 'global proper'
? // eslint-disable-next-line no-undef
globalThis : typeof window !== "undefined" ? window // Browser
: typeof global !== "undefined" ? global // node.js
: {};

function getUniqueId() {
  var key = "__global_unique_id__";
  return commonjsGlobal[key] = (commonjsGlobal[key] || 0) + 1;
} // Inlined Object.is polyfill.
// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/is


function objectIs(x, y) {
  if (x === y) {
    return x !== 0 || 1 / x === 1 / y;
  } else {
    // eslint-disable-next-line no-self-compare
    return x !== x && y !== y;
  }
}

function createEventEmitter(value) {
  var handlers = [];
  return {
    on: function on(handler) {
      handlers.push(handler);
    },
    off: function off(handler) {
      handlers = handlers.filter(function (h) {
        return h !== handler;
      });
    },
    get: function get() {
      return value;
    },
    set: function set(newValue, changedBits) {
      value = newValue;
      handlers.forEach(function (handler) {
        return handler(value, changedBits);
      });
    }
  };
}

function onlyChild(children) {
  return Array.isArray(children) ? children[0] : children;
}

function createReactContext(defaultValue, calculateChangedBits) {
  var _Provider$childContex, _Consumer$contextType;

  var contextProp = "__create-react-context-" + getUniqueId() + "__";

  var Provider = /*#__PURE__*/function (_React$Component) {
    _inheritsLoose(Provider, _React$Component);

    function Provider() {
      var _this;

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _React$Component.call.apply(_React$Component, [this].concat(args)) || this;
      _this.emitter = createEventEmitter(_this.props.value);
      return _this;
    }

    var _proto = Provider.prototype;

    _proto.getChildContext = function getChildContext() {
      var _ref;

      return _ref = {}, _ref[contextProp] = this.emitter, _ref;
    };

    _proto.componentWillReceiveProps = function componentWillReceiveProps(nextProps) {
      if (this.props.value !== nextProps.value) {
        var oldValue = this.props.value;
        var newValue = nextProps.value;
        var changedBits;

        if (objectIs(oldValue, newValue)) {
          changedBits = 0; // No change
        } else {
          changedBits = typeof calculateChangedBits === "function" ? calculateChangedBits(oldValue, newValue) : MAX_SIGNED_31_BIT_INT;

          {
             warning((changedBits & MAX_SIGNED_31_BIT_INT) === changedBits, "calculateChangedBits: Expected the return value to be a " + "31-bit integer. Instead received: " + changedBits) ;
          }

          changedBits |= 0;

          if (changedBits !== 0) {
            this.emitter.set(nextProps.value, changedBits);
          }
        }
      }
    };

    _proto.render = function render() {
      return this.props.children;
    };

    return Provider;
  }(React.Component);

  Provider.childContextTypes = (_Provider$childContex = {}, _Provider$childContex[contextProp] = PropTypes.object.isRequired, _Provider$childContex);

  var Consumer = /*#__PURE__*/function (_React$Component2) {
    _inheritsLoose(Consumer, _React$Component2);

    function Consumer() {
      var _this2;

      for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }

      _this2 = _React$Component2.call.apply(_React$Component2, [this].concat(args)) || this;
      _this2.observedBits = void 0;
      _this2.state = {
        value: _this2.getValue()
      };

      _this2.onUpdate = function (newValue, changedBits) {
        var observedBits = _this2.observedBits | 0;

        if ((observedBits & changedBits) !== 0) {
          _this2.setState({
            value: _this2.getValue()
          });
        }
      };

      return _this2;
    }

    var _proto2 = Consumer.prototype;

    _proto2.componentWillReceiveProps = function componentWillReceiveProps(nextProps) {
      var observedBits = nextProps.observedBits;
      this.observedBits = observedBits === undefined || observedBits === null ? MAX_SIGNED_31_BIT_INT // Subscribe to all changes by default
      : observedBits;
    };

    _proto2.componentDidMount = function componentDidMount() {
      if (this.context[contextProp]) {
        this.context[contextProp].on(this.onUpdate);
      }

      var observedBits = this.props.observedBits;
      this.observedBits = observedBits === undefined || observedBits === null ? MAX_SIGNED_31_BIT_INT // Subscribe to all changes by default
      : observedBits;
    };

    _proto2.componentWillUnmount = function componentWillUnmount() {
      if (this.context[contextProp]) {
        this.context[contextProp].off(this.onUpdate);
      }
    };

    _proto2.getValue = function getValue() {
      if (this.context[contextProp]) {
        return this.context[contextProp].get();
      } else {
        return defaultValue;
      }
    };

    _proto2.render = function render() {
      return onlyChild(this.props.children)(this.state.value);
    };

    return Consumer;
  }(React.Component);

  Consumer.contextTypes = (_Consumer$contextType = {}, _Consumer$contextType[contextProp] = PropTypes.object, _Consumer$contextType);
  return {
    Provider: Provider,
    Consumer: Consumer
  };
}

// MIT License
var createContext = React.createContext || createReactContext;

// TODO: Replace with React.createContext once we can assume React 16+

var createNamedContext = function createNamedContext(name) {
  var context = createContext();
  context.displayName = name;
  return context;
};

var historyContext = /*#__PURE__*/createNamedContext("Router-History");

var context = /*#__PURE__*/createNamedContext("Router");

/**
 * The public API for putting history on context.
 */

var Router = /*#__PURE__*/function (_React$Component) {
  _inheritsLoose(Router, _React$Component);

  Router.computeRootMatch = function computeRootMatch(pathname) {
    return {
      path: "/",
      url: "/",
      params: {},
      isExact: pathname === "/"
    };
  };

  function Router(props) {
    var _this;

    _this = _React$Component.call(this, props) || this;
    _this.state = {
      location: props.history.location
    }; // This is a bit of a hack. We have to start listening for location
    // changes here in the constructor in case there are any <Redirect>s
    // on the initial render. If there are, they will replace/push when
    // they mount and since cDM fires in children before parents, we may
    // get a new location before the <Router> is mounted.

    _this._isMounted = false;
    _this._pendingLocation = null;

    if (!props.staticContext) {
      _this.unlisten = props.history.listen(function (location) {
        _this._pendingLocation = location;
      });
    }

    return _this;
  }

  var _proto = Router.prototype;

  _proto.componentDidMount = function componentDidMount() {
    var _this2 = this;

    this._isMounted = true;

    if (this.unlisten) {
      // Any pre-mount location changes have been captured at
      // this point, so unregister the listener.
      this.unlisten();
    }

    if (!this.props.staticContext) {
      this.unlisten = this.props.history.listen(function (location) {
        if (_this2._isMounted) {
          _this2.setState({
            location: location
          });
        }
      });
    }

    if (this._pendingLocation) {
      this.setState({
        location: this._pendingLocation
      });
    }
  };

  _proto.componentWillUnmount = function componentWillUnmount() {
    if (this.unlisten) {
      this.unlisten();
      this._isMounted = false;
      this._pendingLocation = null;
    }
  };

  _proto.render = function render() {
    return /*#__PURE__*/React.createElement(context.Provider, {
      value: {
        history: this.props.history,
        location: this.state.location,
        match: Router.computeRootMatch(this.state.location.pathname),
        staticContext: this.props.staticContext
      }
    }, /*#__PURE__*/React.createElement(historyContext.Provider, {
      children: this.props.children || null,
      value: this.props.history
    }));
  };

  return Router;
}(React.Component);

{
  Router.propTypes = {
    children: PropTypes.node,
    history: PropTypes.object.isRequired,
    staticContext: PropTypes.object
  };

  Router.prototype.componentDidUpdate = function (prevProps) {
     warning(prevProps.history === this.props.history, "You cannot change <Router history>") ;
  };
}

/**
 * The public API for a <Router> that stores location in memory.
 */

var MemoryRouter = /*#__PURE__*/function (_React$Component) {
  _inheritsLoose(MemoryRouter, _React$Component);

  function MemoryRouter() {
    var _this;

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _React$Component.call.apply(_React$Component, [this].concat(args)) || this;
    _this.history = history.createMemoryHistory(_this.props);
    return _this;
  }

  var _proto = MemoryRouter.prototype;

  _proto.render = function render() {
    return /*#__PURE__*/React.createElement(Router, {
      history: this.history,
      children: this.props.children
    });
  };

  return MemoryRouter;
}(React.Component);

{
  MemoryRouter.propTypes = {
    initialEntries: PropTypes.array,
    initialIndex: PropTypes.number,
    getUserConfirmation: PropTypes.func,
    keyLength: PropTypes.number,
    children: PropTypes.node
  };

  MemoryRouter.prototype.componentDidMount = function () {
     warning(!this.props.history, "<MemoryRouter> ignores the history prop. To use a custom history, " + "use `import { Router }` instead of `import { MemoryRouter as Router }`.") ;
  };
}

var Lifecycle = /*#__PURE__*/function (_React$Component) {
  _inheritsLoose(Lifecycle, _React$Component);

  function Lifecycle() {
    return _React$Component.apply(this, arguments) || this;
  }

  var _proto = Lifecycle.prototype;

  _proto.componentDidMount = function componentDidMount() {
    if (this.props.onMount) this.props.onMount.call(this, this);
  };

  _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
    if (this.props.onUpdate) this.props.onUpdate.call(this, this, prevProps);
  };

  _proto.componentWillUnmount = function componentWillUnmount() {
    if (this.props.onUnmount) this.props.onUnmount.call(this, this);
  };

  _proto.render = function render() {
    return null;
  };

  return Lifecycle;
}(React.Component);

/**
 * The public API for prompting the user before navigating away from a screen.
 */

function Prompt(_ref) {
  var message = _ref.message,
      _ref$when = _ref.when,
      when = _ref$when === void 0 ? true : _ref$when;
  return /*#__PURE__*/React.createElement(context.Consumer, null, function (context) {
    !context ?  invariant(false, "You should not use <Prompt> outside a <Router>")  : void 0;
    if (!when || context.staticContext) return null;
    var method = context.history.block;
    return /*#__PURE__*/React.createElement(Lifecycle, {
      onMount: function onMount(self) {
        self.release = method(message);
      },
      onUpdate: function onUpdate(self, prevProps) {
        if (prevProps.message !== message) {
          self.release();
          self.release = method(message);
        }
      },
      onUnmount: function onUnmount(self) {
        self.release();
      },
      message: message
    });
  });
}

{
  var messageType = PropTypes.oneOfType([PropTypes.func, PropTypes.string]);
  Prompt.propTypes = {
    when: PropTypes.bool,
    message: messageType.isRequired
  };
}

var cache = {};
var cacheLimit = 10000;
var cacheCount = 0;

function compilePath(path) {
  if (cache[path]) return cache[path];
  var generator = pathToRegexp.compile(path);

  if (cacheCount < cacheLimit) {
    cache[path] = generator;
    cacheCount++;
  }

  return generator;
}
/**
 * Public API for generating a URL pathname from a path and parameters.
 */


function generatePath(path, params) {
  if (path === void 0) {
    path = "/";
  }

  if (params === void 0) {
    params = {};
  }

  return path === "/" ? path : compilePath(path)(params, {
    pretty: true
  });
}

/**
 * The public API for navigating programmatically with a component.
 */

function Redirect(_ref) {
  var computedMatch = _ref.computedMatch,
      to = _ref.to,
      _ref$push = _ref.push,
      push = _ref$push === void 0 ? false : _ref$push;
  return /*#__PURE__*/React.createElement(context.Consumer, null, function (context) {
    !context ?  invariant(false, "You should not use <Redirect> outside a <Router>")  : void 0;
    var history$1 = context.history,
        staticContext = context.staticContext;
    var method = push ? history$1.push : history$1.replace;
    var location = history.createLocation(computedMatch ? typeof to === "string" ? generatePath(to, computedMatch.params) : _extends({}, to, {
      pathname: generatePath(to.pathname, computedMatch.params)
    }) : to); // When rendering in a static context,
    // set the new location immediately.

    if (staticContext) {
      method(location);
      return null;
    }

    return /*#__PURE__*/React.createElement(Lifecycle, {
      onMount: function onMount() {
        method(location);
      },
      onUpdate: function onUpdate(self, prevProps) {
        var prevLocation = history.createLocation(prevProps.to);

        if (!history.locationsAreEqual(prevLocation, _extends({}, location, {
          key: prevLocation.key
        }))) {
          method(location);
        }
      },
      to: to
    });
  });
}

{
  Redirect.propTypes = {
    push: PropTypes.bool,
    from: PropTypes.string,
    to: PropTypes.oneOfType([PropTypes.string, PropTypes.object]).isRequired
  };
}

var cache$1 = {};
var cacheLimit$1 = 10000;
var cacheCount$1 = 0;

function compilePath$1(path, options) {
  var cacheKey = "" + options.end + options.strict + options.sensitive;
  var pathCache = cache$1[cacheKey] || (cache$1[cacheKey] = {});
  if (pathCache[path]) return pathCache[path];
  var keys = [];
  var regexp = pathToRegexp(path, keys, options);
  var result = {
    regexp: regexp,
    keys: keys
  };

  if (cacheCount$1 < cacheLimit$1) {
    pathCache[path] = result;
    cacheCount$1++;
  }

  return result;
}
/**
 * Public API for matching a URL pathname to a path.
 */


function matchPath(pathname, options) {
  if (options === void 0) {
    options = {};
  }

  if (typeof options === "string" || Array.isArray(options)) {
    options = {
      path: options
    };
  }

  var _options = options,
      path = _options.path,
      _options$exact = _options.exact,
      exact = _options$exact === void 0 ? false : _options$exact,
      _options$strict = _options.strict,
      strict = _options$strict === void 0 ? false : _options$strict,
      _options$sensitive = _options.sensitive,
      sensitive = _options$sensitive === void 0 ? false : _options$sensitive;
  var paths = [].concat(path);
  return paths.reduce(function (matched, path) {
    if (!path && path !== "") return null;
    if (matched) return matched;

    var _compilePath = compilePath$1(path, {
      end: exact,
      strict: strict,
      sensitive: sensitive
    }),
        regexp = _compilePath.regexp,
        keys = _compilePath.keys;

    var match = regexp.exec(pathname);
    if (!match) return null;
    var url = match[0],
        values = match.slice(1);
    var isExact = pathname === url;
    if (exact && !isExact) return null;
    return {
      path: path,
      // the path used to match
      url: path === "/" && url === "" ? "/" : url,
      // the matched portion of the URL
      isExact: isExact,
      // whether or not we matched exactly
      params: keys.reduce(function (memo, key, index) {
        memo[key.name] = values[index];
        return memo;
      }, {})
    };
  }, null);
}

function isEmptyChildren(children) {
  return React.Children.count(children) === 0;
}

function evalChildrenDev(children, props, path) {
  var value = children(props);
   warning(value !== undefined, "You returned `undefined` from the `children` function of " + ("<Route" + (path ? " path=\"" + path + "\"" : "") + ">, but you ") + "should have returned a React element or `null`") ;
  return value || null;
}
/**
 * The public API for matching a single path and rendering.
 */


var Route = /*#__PURE__*/function (_React$Component) {
  _inheritsLoose(Route, _React$Component);

  function Route() {
    return _React$Component.apply(this, arguments) || this;
  }

  var _proto = Route.prototype;

  _proto.render = function render() {
    var _this = this;

    return /*#__PURE__*/React.createElement(context.Consumer, null, function (context$1) {
      !context$1 ?  invariant(false, "You should not use <Route> outside a <Router>")  : void 0;
      var location = _this.props.location || context$1.location;
      var match = _this.props.computedMatch ? _this.props.computedMatch // <Switch> already computed the match for us
      : _this.props.path ? matchPath(location.pathname, _this.props) : context$1.match;

      var props = _extends({}, context$1, {
        location: location,
        match: match
      });

      var _this$props = _this.props,
          children = _this$props.children,
          component = _this$props.component,
          render = _this$props.render; // Preact uses an empty array as children by
      // default, so use null if that's the case.

      if (Array.isArray(children) && isEmptyChildren(children)) {
        children = null;
      }

      return /*#__PURE__*/React.createElement(context.Provider, {
        value: props
      }, props.match ? children ? typeof children === "function" ?  evalChildrenDev(children, props, _this.props.path)  : children : component ? /*#__PURE__*/React.createElement(component, props) : render ? render(props) : null : typeof children === "function" ?  evalChildrenDev(children, props, _this.props.path)  : null);
    });
  };

  return Route;
}(React.Component);

{
  Route.propTypes = {
    children: PropTypes.oneOfType([PropTypes.func, PropTypes.node]),
    component: function component(props, propName) {
      if (props[propName] && !reactIs.isValidElementType(props[propName])) {
        return new Error("Invalid prop 'component' supplied to 'Route': the prop is not a valid React component");
      }
    },
    exact: PropTypes.bool,
    location: PropTypes.object,
    path: PropTypes.oneOfType([PropTypes.string, PropTypes.arrayOf(PropTypes.string)]),
    render: PropTypes.func,
    sensitive: PropTypes.bool,
    strict: PropTypes.bool
  };

  Route.prototype.componentDidMount = function () {
     warning(!(this.props.children && !isEmptyChildren(this.props.children) && this.props.component), "You should not use <Route component> and <Route children> in the same route; <Route component> will be ignored") ;
     warning(!(this.props.children && !isEmptyChildren(this.props.children) && this.props.render), "You should not use <Route render> and <Route children> in the same route; <Route render> will be ignored") ;
     warning(!(this.props.component && this.props.render), "You should not use <Route component> and <Route render> in the same route; <Route render> will be ignored") ;
  };

  Route.prototype.componentDidUpdate = function (prevProps) {
     warning(!(this.props.location && !prevProps.location), '<Route> elements should not change from uncontrolled to controlled (or vice versa). You initially used no "location" prop and then provided one on a subsequent render.') ;
     warning(!(!this.props.location && prevProps.location), '<Route> elements should not change from controlled to uncontrolled (or vice versa). You provided a "location" prop initially but omitted it on a subsequent render.') ;
  };
}

function addLeadingSlash(path) {
  return path.charAt(0) === "/" ? path : "/" + path;
}

function addBasename(basename, location) {
  if (!basename) return location;
  return _extends({}, location, {
    pathname: addLeadingSlash(basename) + location.pathname
  });
}

function stripBasename(basename, location) {
  if (!basename) return location;
  var base = addLeadingSlash(basename);
  if (location.pathname.indexOf(base) !== 0) return location;
  return _extends({}, location, {
    pathname: location.pathname.substr(base.length)
  });
}

function createURL(location) {
  return typeof location === "string" ? location : history.createPath(location);
}

function staticHandler(methodName) {
  return function () {
      invariant(false, "You cannot %s with <StaticRouter>", methodName)  ;
  };
}

function noop() {}
/**
 * The public top-level API for a "static" <Router>, so-called because it
 * can't actually change the current location. Instead, it just records
 * location changes in a context object. Useful mainly in testing and
 * server-rendering scenarios.
 */


var StaticRouter = /*#__PURE__*/function (_React$Component) {
  _inheritsLoose(StaticRouter, _React$Component);

  function StaticRouter() {
    var _this;

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _React$Component.call.apply(_React$Component, [this].concat(args)) || this;

    _this.handlePush = function (location) {
      return _this.navigateTo(location, "PUSH");
    };

    _this.handleReplace = function (location) {
      return _this.navigateTo(location, "REPLACE");
    };

    _this.handleListen = function () {
      return noop;
    };

    _this.handleBlock = function () {
      return noop;
    };

    return _this;
  }

  var _proto = StaticRouter.prototype;

  _proto.navigateTo = function navigateTo(location, action) {
    var _this$props = this.props,
        _this$props$basename = _this$props.basename,
        basename = _this$props$basename === void 0 ? "" : _this$props$basename,
        _this$props$context = _this$props.context,
        context = _this$props$context === void 0 ? {} : _this$props$context;
    context.action = action;
    context.location = addBasename(basename, history.createLocation(location));
    context.url = createURL(context.location);
  };

  _proto.render = function render() {
    var _this$props2 = this.props,
        _this$props2$basename = _this$props2.basename,
        basename = _this$props2$basename === void 0 ? "" : _this$props2$basename,
        _this$props2$context = _this$props2.context,
        context = _this$props2$context === void 0 ? {} : _this$props2$context,
        _this$props2$location = _this$props2.location,
        location = _this$props2$location === void 0 ? "/" : _this$props2$location,
        rest = _objectWithoutPropertiesLoose(_this$props2, ["basename", "context", "location"]);

    var history$1 = {
      createHref: function createHref(path) {
        return addLeadingSlash(basename + createURL(path));
      },
      action: "POP",
      location: stripBasename(basename, history.createLocation(location)),
      push: this.handlePush,
      replace: this.handleReplace,
      go: staticHandler("go"),
      goBack: staticHandler("goBack"),
      goForward: staticHandler("goForward"),
      listen: this.handleListen,
      block: this.handleBlock
    };
    return /*#__PURE__*/React.createElement(Router, _extends({}, rest, {
      history: history$1,
      staticContext: context
    }));
  };

  return StaticRouter;
}(React.Component);

{
  StaticRouter.propTypes = {
    basename: PropTypes.string,
    context: PropTypes.object,
    location: PropTypes.oneOfType([PropTypes.string, PropTypes.object])
  };

  StaticRouter.prototype.componentDidMount = function () {
     warning(!this.props.history, "<StaticRouter> ignores the history prop. To use a custom history, " + "use `import { Router }` instead of `import { StaticRouter as Router }`.") ;
  };
}

/**
 * The public API for rendering the first <Route> that matches.
 */

var Switch = /*#__PURE__*/function (_React$Component) {
  _inheritsLoose(Switch, _React$Component);

  function Switch() {
    return _React$Component.apply(this, arguments) || this;
  }

  var _proto = Switch.prototype;

  _proto.render = function render() {
    var _this = this;

    return /*#__PURE__*/React.createElement(context.Consumer, null, function (context) {
      !context ?  invariant(false, "You should not use <Switch> outside a <Router>")  : void 0;
      var location = _this.props.location || context.location;
      var element, match; // We use React.Children.forEach instead of React.Children.toArray().find()
      // here because toArray adds keys to all child elements and we do not want
      // to trigger an unmount/remount for two <Route>s that render the same
      // component at different URLs.

      React.Children.forEach(_this.props.children, function (child) {
        if (match == null && /*#__PURE__*/React.isValidElement(child)) {
          element = child;
          var path = child.props.path || child.props.from;
          match = path ? matchPath(location.pathname, _extends({}, child.props, {
            path: path
          })) : context.match;
        }
      });
      return match ? /*#__PURE__*/React.cloneElement(element, {
        location: location,
        computedMatch: match
      }) : null;
    });
  };

  return Switch;
}(React.Component);

{
  Switch.propTypes = {
    children: PropTypes.node,
    location: PropTypes.object
  };

  Switch.prototype.componentDidUpdate = function (prevProps) {
     warning(!(this.props.location && !prevProps.location), '<Switch> elements should not change from uncontrolled to controlled (or vice versa). You initially used no "location" prop and then provided one on a subsequent render.') ;
     warning(!(!this.props.location && prevProps.location), '<Switch> elements should not change from controlled to uncontrolled (or vice versa). You provided a "location" prop initially but omitted it on a subsequent render.') ;
  };
}

/**
 * A public higher-order component to access the imperative API
 */

function withRouter(Component) {
  var displayName = "withRouter(" + (Component.displayName || Component.name) + ")";

  var C = function C(props) {
    var wrappedComponentRef = props.wrappedComponentRef,
        remainingProps = _objectWithoutPropertiesLoose(props, ["wrappedComponentRef"]);

    return /*#__PURE__*/React.createElement(context.Consumer, null, function (context) {
      !context ?  invariant(false, "You should not use <" + displayName + " /> outside a <Router>")  : void 0;
      return /*#__PURE__*/React.createElement(Component, _extends({}, remainingProps, context, {
        ref: wrappedComponentRef
      }));
    });
  };

  C.displayName = displayName;
  C.WrappedComponent = Component;

  {
    C.propTypes = {
      wrappedComponentRef: PropTypes.oneOfType([PropTypes.string, PropTypes.func, PropTypes.object])
    };
  }

  return hoistStatics(C, Component);
}

var useContext = React.useContext;
function useHistory() {
  {
    !(typeof useContext === "function") ?  invariant(false, "You must use React >= 16.8 in order to use useHistory()")  : void 0;
  }

  return useContext(historyContext);
}
function useLocation() {
  {
    !(typeof useContext === "function") ?  invariant(false, "You must use React >= 16.8 in order to use useLocation()")  : void 0;
  }

  return useContext(context).location;
}
function useParams() {
  {
    !(typeof useContext === "function") ?  invariant(false, "You must use React >= 16.8 in order to use useParams()")  : void 0;
  }

  var match = useContext(context).match;
  return match ? match.params : {};
}
function useRouteMatch(path) {
  {
    !(typeof useContext === "function") ?  invariant(false, "You must use React >= 16.8 in order to use useRouteMatch()")  : void 0;
  }

  var location = useLocation();
  var match = useContext(context).match;
  return path ? matchPath(location.pathname, path) : match;
}

{
  if (typeof window !== "undefined") {
    var global$1 = window;
    var key = "__react_router_build__";
    var buildNames = {
      cjs: "CommonJS",
      esm: "ES modules",
      umd: "UMD"
    };

    if (global$1[key] && global$1[key] !== "cjs") {
      var initialBuildName = buildNames[global$1[key]];
      var secondaryBuildName = buildNames["cjs"]; // TODO: Add link to article that explains in detail how to avoid
      // loading 2 different builds.

      throw new Error("You are loading the " + secondaryBuildName + " build of React Router " + ("on a page that is already running the " + initialBuildName + " ") + "build, so things won't work right.");
    }

    global$1[key] = "cjs";
  }
}

exports.MemoryRouter = MemoryRouter;
exports.Prompt = Prompt;
exports.Redirect = Redirect;
exports.Route = Route;
exports.Router = Router;
exports.StaticRouter = StaticRouter;
exports.Switch = Switch;
exports.__HistoryContext = historyContext;
exports.__RouterContext = context;
exports.generatePath = generatePath;
exports.matchPath = matchPath;
exports.useHistory = useHistory;
exports.useLocation = useLocation;
exports.useParams = useParams;
exports.useRouteMatch = useRouteMatch;
exports.withRouter = withRouter;


      };
    };
  }
  }
}, {package:"react-router-dom>react-router",file:"node_modules\\react-router-dom\\node_modules\\react-router\\cjs\\react-router.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\node_modules\\react-router\\cjs\\react-router.min.js", {"history":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\node_modules\\history\\index.js","hoist-non-react-statics":"D:\\code\\v\\metamask-extension\\node_modules\\hoist-non-react-statics\\dist\\hoist-non-react-statics.cjs.js","path-to-regexp":"D:\\code\\v\\metamask-extension\\node_modules\\path-to-regexp\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-is":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\node_modules\\react-is\\index.js","tiny-invariant":"D:\\code\\v\\metamask-extension\\node_modules\\tiny-invariant\\dist\\tiny-invariant.cjs.js","tiny-warning":"D:\\code\\v\\metamask-extension\\node_modules\\tiny-warning\\dist\\tiny-warning.cjs.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Creact-router-dom%5Cnode_modules%5Creact-router%5Ccjs%5Creact-router.min.js
      return function (require, module, exports) {
"use strict";function _interopDefault(t){return t&&"object"==typeof t&&"default"in t?t.default:t}Object.defineProperty(exports,"__esModule",{value:!0});var React=_interopDefault(require("react")),PropTypes=_interopDefault(require("prop-types")),history=require("history");require("tiny-warning");var invariant=_interopDefault(require("tiny-invariant")),pathToRegexp=_interopDefault(require("path-to-regexp"));require("react-is");var hoistStatics=_interopDefault(require("hoist-non-react-statics"));function _extends(){return(_extends=Object.assign||function(t){for(var e=1;e<arguments.length;e++){var n=arguments[e];for(var o in n)Object.prototype.hasOwnProperty.call(n,o)&&(t[o]=n[o])}return t}).apply(this,arguments)}function _inheritsLoose(t,e){t.prototype=Object.create(e.prototype),_setPrototypeOf(t.prototype.constructor=t,e)}function _setPrototypeOf(t,e){return(_setPrototypeOf=Object.setPrototypeOf||function(t,e){return t.__proto__=e,t})(t,e)}function _objectWithoutPropertiesLoose(t,e){if(null==t)return{};var n,o,r={},i=Object.keys(t);for(o=0;o<i.length;o++)n=i[o],0<=e.indexOf(n)||(r[n]=t[n]);return r}var MAX_SIGNED_31_BIT_INT=1073741823,commonjsGlobal="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:{};function getUniqueId(){var t="__global_unique_id__";return commonjsGlobal[t]=(commonjsGlobal[t]||0)+1}function objectIs(t,e){return t===e?0!==t||1/t==1/e:t!=t&&e!=e}function createEventEmitter(n){var o=[];return{on:function(t){o.push(t)},off:function(e){o=o.filter(function(t){return t!==e})},get:function(){return n},set:function(t,e){n=t,o.forEach(function(t){return t(n,e)})}}}function onlyChild(t){return Array.isArray(t)?t[0]:t}function createReactContext(n,i){var t,e,o="__create-react-context-"+getUniqueId()+"__",r=function(r){function t(){for(var t,e=arguments.length,n=new Array(e),o=0;o<e;o++)n[o]=arguments[o];return(t=r.call.apply(r,[this].concat(n))||this).emitter=createEventEmitter(t.props.value),t}_inheritsLoose(t,r);var e=t.prototype;return e.getChildContext=function(){var t;return(t={})[o]=this.emitter,t},e.componentWillReceiveProps=function(t){if(this.props.value!==t.value){var e,n=this.props.value,o=t.value;objectIs(n,o)?e=0:(e="function"==typeof i?i(n,o):MAX_SIGNED_31_BIT_INT,0!==(e|=0)&&this.emitter.set(t.value,e))}},e.render=function(){return this.props.children},t}(React.Component);r.childContextTypes=((t={})[o]=PropTypes.object.isRequired,t);var a=function(r){function t(){for(var n,t=arguments.length,e=new Array(t),o=0;o<t;o++)e[o]=arguments[o];return(n=r.call.apply(r,[this].concat(e))||this).observedBits=void 0,n.state={value:n.getValue()},n.onUpdate=function(t,e){0!=((0|n.observedBits)&e)&&n.setState({value:n.getValue()})},n}_inheritsLoose(t,r);var e=t.prototype;return e.componentWillReceiveProps=function(t){var e=t.observedBits;this.observedBits=null==e?MAX_SIGNED_31_BIT_INT:e},e.componentDidMount=function(){this.context[o]&&this.context[o].on(this.onUpdate);var t=this.props.observedBits;this.observedBits=null==t?MAX_SIGNED_31_BIT_INT:t},e.componentWillUnmount=function(){this.context[o]&&this.context[o].off(this.onUpdate)},e.getValue=function(){return this.context[o]?this.context[o].get():n},e.render=function(){return onlyChild(this.props.children)(this.state.value)},t}(React.Component);return a.contextTypes=((e={})[o]=PropTypes.object,e),{Provider:r,Consumer:a}}var createContext=React.createContext||createReactContext,createNamedContext=function(t){var e=createContext();return e.displayName=t,e},historyContext=createNamedContext("Router-History"),context=createNamedContext("Router"),Router=function(n){function t(t){var e;return(e=n.call(this,t)||this).state={location:t.history.location},e._isMounted=!1,e._pendingLocation=null,t.staticContext||(e.unlisten=t.history.listen(function(t){e._pendingLocation=t})),e}_inheritsLoose(t,n),t.computeRootMatch=function(t){return{path:"/",url:"/",params:{},isExact:"/"===t}};var e=t.prototype;return e.componentDidMount=function(){var e=this;this._isMounted=!0,this.unlisten&&this.unlisten(),this.props.staticContext||(this.unlisten=this.props.history.listen(function(t){e._isMounted&&e.setState({location:t})})),this._pendingLocation&&this.setState({location:this._pendingLocation})},e.componentWillUnmount=function(){this.unlisten&&(this.unlisten(),this._isMounted=!1,this._pendingLocation=null)},e.render=function(){return React.createElement(context.Provider,{value:{history:this.props.history,location:this.state.location,match:t.computeRootMatch(this.state.location.pathname),staticContext:this.props.staticContext}},React.createElement(historyContext.Provider,{children:this.props.children||null,value:this.props.history}))},t}(React.Component),MemoryRouter=function(r){function t(){for(var t,e=arguments.length,n=new Array(e),o=0;o<e;o++)n[o]=arguments[o];return(t=r.call.apply(r,[this].concat(n))||this).history=history.createMemoryHistory(t.props),t}return _inheritsLoose(t,r),t.prototype.render=function(){return React.createElement(Router,{history:this.history,children:this.props.children})},t}(React.Component),Lifecycle=function(t){function e(){return t.apply(this,arguments)||this}_inheritsLoose(e,t);var n=e.prototype;return n.componentDidMount=function(){this.props.onMount&&this.props.onMount.call(this,this)},n.componentDidUpdate=function(t){this.props.onUpdate&&this.props.onUpdate.call(this,this,t)},n.componentWillUnmount=function(){this.props.onUnmount&&this.props.onUnmount.call(this,this)},n.render=function(){return null},e}(React.Component);function Prompt(t){var o=t.message,e=t.when,r=void 0===e||e;return React.createElement(context.Consumer,null,function(t){if(t||invariant(!1),!r||t.staticContext)return null;var n=t.history.block;return React.createElement(Lifecycle,{onMount:function(t){t.release=n(o)},onUpdate:function(t,e){e.message!==o&&(t.release(),t.release=n(o))},onUnmount:function(t){t.release()},message:o})})}var cache={},cacheLimit=1e4,cacheCount=0;function compilePath(t){if(cache[t])return cache[t];var e=pathToRegexp.compile(t);return cacheCount<cacheLimit&&(cache[t]=e,cacheCount++),e}function generatePath(t,e){return void 0===t&&(t="/"),void 0===e&&(e={}),"/"===t?t:compilePath(t)(e,{pretty:!0})}function Redirect(t){var i=t.computedMatch,a=t.to,e=t.push,c=void 0!==e&&e;return React.createElement(context.Consumer,null,function(t){t||invariant(!1);var e=t.history,n=t.staticContext,o=c?e.push:e.replace,r=history.createLocation(i?"string"==typeof a?generatePath(a,i.params):_extends({},a,{pathname:generatePath(a.pathname,i.params)}):a);return n?(o(r),null):React.createElement(Lifecycle,{onMount:function(){o(r)},onUpdate:function(t,e){var n=history.createLocation(e.to);history.locationsAreEqual(n,_extends({},r,{key:n.key}))||o(r)},to:a})})}var cache$1={},cacheLimit$1=1e4,cacheCount$1=0;function compilePath$1(t,e){var n=""+e.end+e.strict+e.sensitive,o=cache$1[n]||(cache$1[n]={});if(o[t])return o[t];var r=[],i={regexp:pathToRegexp(t,r,e),keys:r};return cacheCount$1<cacheLimit$1&&(o[t]=i,cacheCount$1++),i}function matchPath(u,t){void 0===t&&(t={}),"string"!=typeof t&&!Array.isArray(t)||(t={path:t});var e=t,n=e.path,o=e.exact,p=void 0!==o&&o,r=e.strict,h=void 0!==r&&r,i=e.sensitive,l=void 0!==i&&i;return[].concat(n).reduce(function(t,e){if(!e&&""!==e)return null;if(t)return t;var n=compilePath$1(e,{end:p,strict:h,sensitive:l}),o=n.regexp,r=n.keys,i=o.exec(u);if(!i)return null;var a=i[0],c=i.slice(1),s=u===a;return p&&!s?null:{path:e,url:"/"===e&&""===a?"/":a,isExact:s,params:r.reduce(function(t,e,n){return t[e.name]=c[n],t},{})}},null)}function isEmptyChildren(t){return 0===React.Children.count(t)}var Route=function(t){function e(){return t.apply(this,arguments)||this}return _inheritsLoose(e,t),e.prototype.render=function(){var c=this;return React.createElement(context.Consumer,null,function(t){t||invariant(!1);var e=c.props.location||t.location,n=_extends({},t,{location:e,match:c.props.computedMatch?c.props.computedMatch:c.props.path?matchPath(e.pathname,c.props):t.match}),o=c.props,r=o.children,i=o.component,a=o.render;return Array.isArray(r)&&isEmptyChildren(r)&&(r=null),React.createElement(context.Provider,{value:n},n.match?r?"function"==typeof r?r(n):r:i?React.createElement(i,n):a?a(n):null:"function"==typeof r?r(n):null)})},e}(React.Component);function addLeadingSlash(t){return"/"===t.charAt(0)?t:"/"+t}function addBasename(t,e){return t?_extends({},e,{pathname:addLeadingSlash(t)+e.pathname}):e}function stripBasename(t,e){if(!t)return e;var n=addLeadingSlash(t);return 0!==e.pathname.indexOf(n)?e:_extends({},e,{pathname:e.pathname.substr(n.length)})}function createURL(t){return"string"==typeof t?t:history.createPath(t)}function staticHandler(t){return function(){invariant(!1)}}function noop(){}var StaticRouter=function(r){function t(){for(var e,t=arguments.length,n=new Array(t),o=0;o<t;o++)n[o]=arguments[o];return(e=r.call.apply(r,[this].concat(n))||this).handlePush=function(t){return e.navigateTo(t,"PUSH")},e.handleReplace=function(t){return e.navigateTo(t,"REPLACE")},e.handleListen=function(){return noop},e.handleBlock=function(){return noop},e}_inheritsLoose(t,r);var e=t.prototype;return e.navigateTo=function(t,e){var n=this.props,o=n.basename,r=void 0===o?"":o,i=n.context,a=void 0===i?{}:i;a.action=e,a.location=addBasename(r,history.createLocation(t)),a.url=createURL(a.location)},e.render=function(){var t=this.props,e=t.basename,n=void 0===e?"":e,o=t.context,r=void 0===o?{}:o,i=t.location,a=void 0===i?"/":i,c=_objectWithoutPropertiesLoose(t,["basename","context","location"]),s={createHref:function(t){return addLeadingSlash(n+createURL(t))},action:"POP",location:stripBasename(n,history.createLocation(a)),push:this.handlePush,replace:this.handleReplace,go:staticHandler(),goBack:staticHandler(),goForward:staticHandler(),listen:this.handleListen,block:this.handleBlock};return React.createElement(Router,_extends({},c,{history:s,staticContext:r}))},t}(React.Component),Switch=function(t){function e(){return t.apply(this,arguments)||this}return _inheritsLoose(e,t),e.prototype.render=function(){var t=this;return React.createElement(context.Consumer,null,function(n){n||invariant(!1);var o,r,i=t.props.location||n.location;return React.Children.forEach(t.props.children,function(t){if(null==r&&React.isValidElement(t)){var e=(o=t).props.path||t.props.from;r=e?matchPath(i.pathname,_extends({},t.props,{path:e})):n.match}}),r?React.cloneElement(o,{location:i,computedMatch:r}):null})},e}(React.Component);function withRouter(o){function t(t){var e=t.wrappedComponentRef,n=_objectWithoutPropertiesLoose(t,["wrappedComponentRef"]);return React.createElement(context.Consumer,null,function(t){return t||invariant(!1),React.createElement(o,_extends({},n,t,{ref:e}))})}var e="withRouter("+(o.displayName||o.name)+")";return t.displayName=e,t.WrappedComponent=o,hoistStatics(t,o)}var useContext=React.useContext;function useHistory(){return useContext(historyContext)}function useLocation(){return useContext(context).location}function useParams(){var t=useContext(context).match;return t?t.params:{}}function useRouteMatch(t){var e=useLocation(),n=useContext(context).match;return t?matchPath(e.pathname,t):n}exports.MemoryRouter=MemoryRouter,exports.Prompt=Prompt,exports.Redirect=Redirect,exports.Route=Route,exports.Router=Router,exports.StaticRouter=StaticRouter,exports.Switch=Switch,exports.__HistoryContext=historyContext,exports.__RouterContext=context,exports.generatePath=generatePath,exports.matchPath=matchPath,exports.useHistory=useHistory,exports.useLocation=useLocation,exports.useParams=useParams,exports.useRouteMatch=useRouteMatch,exports.withRouter=withRouter;


      };
    };
  }
  }
}, {package:"react-router-dom>react-router",file:"node_modules\\react-router-dom\\node_modules\\react-router\\cjs\\react-router.min.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\node_modules\\react-router\\index.js", {"./cjs/react-router.js":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\node_modules\\react-router\\cjs\\react-router.js","./cjs/react-router.min.js":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\node_modules\\react-router\\cjs\\react-router.min.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Creact-router-dom%5Cnode_modules%5Creact-router%5Cindex.js
      return function (require, module, exports) {
"use strict";

if ("development" === "production") {
  module.exports = require("./cjs/react-router.min.js");
} else {
  module.exports = require("./cjs/react-router.js");
}

      };
    };
  }
  }
}, {package:"react-router-dom>react-router",file:"node_modules\\react-router-dom\\node_modules\\react-router\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\react-router\\dist\\main.js", {"./umd/react-router.development.js":"D:\\code\\v\\metamask-extension\\node_modules\\react-router\\dist\\umd\\react-router.development.js","./umd/react-router.production.min.js":"D:\\code\\v\\metamask-extension\\node_modules\\react-router\\dist\\umd\\react-router.production.min.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Creact-router%5Cdist%5Cmain.js
      return function (require, module, exports) {
/**
 * React Router v6.26.2
 *
 * Copyright (c) Remix Software Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE.md file in the root directory of this source tree.
 *
 * @license MIT
 */
'use strict';

/* eslint-env node */

if ("development" === "production") {
  module.exports = require("./umd/react-router.production.min.js");
} else {
  module.exports = require("./umd/react-router.development.js");
}

      };
    };
  }
  }
}, {package:"react-router-dom-v5-compat>react-router",file:"node_modules\\react-router\\dist\\main.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\react-router\\dist\\umd\\react-router.development.js", {"@remix-run/router":"D:\\code\\v\\metamask-extension\\node_modules\\@remix-run\\router\\dist\\router.cjs.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Creact-router%5Cdist%5Cumd%5Creact-router.development.js
      return function (require, module, exports) {
/**
 * React Router v6.26.2
 *
 * Copyright (c) Remix Software Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE.md file in the root directory of this source tree.
 *
 * @license MIT
 */
(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('react'), require('@remix-run/router')) :
  typeof define === 'function' && define.amd ? define(['exports', 'react', '@remix-run/router'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.ReactRouter = {}, global.React, global.RemixRouter));
})(this, (function (exports, React, router) { 'use strict';

  function _interopNamespace(e) {
    if (e && e.__esModule) return e;
    var n = Object.create(null);
    if (e) {
      Object.keys(e).forEach(function (k) {
        if (k !== 'default') {
          var d = Object.getOwnPropertyDescriptor(e, k);
          Object.defineProperty(n, k, d.get ? d : {
            enumerable: true,
            get: function () { return e[k]; }
          });
        }
      });
    }
    n["default"] = e;
    return Object.freeze(n);
  }

  var React__namespace = /*#__PURE__*/_interopNamespace(React);

  function _extends() {
    _extends = Object.assign ? Object.assign.bind() : function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];
        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }
      return target;
    };
    return _extends.apply(this, arguments);
  }

  // Create react-specific types from the agnostic types in @remix-run/router to
  // export from react-router
  const DataRouterContext = /*#__PURE__*/React__namespace.createContext(null);
  {
    DataRouterContext.displayName = "DataRouter";
  }
  const DataRouterStateContext = /*#__PURE__*/React__namespace.createContext(null);
  {
    DataRouterStateContext.displayName = "DataRouterState";
  }
  const AwaitContext = /*#__PURE__*/React__namespace.createContext(null);
  {
    AwaitContext.displayName = "Await";
  }

  /**
   * A Navigator is a "location changer"; it's how you get to different locations.
   *
   * Every history instance conforms to the Navigator interface, but the
   * distinction is useful primarily when it comes to the low-level `<Router>` API
   * where both the location and a navigator must be provided separately in order
   * to avoid "tearing" that may occur in a suspense-enabled app if the action
   * and/or location were to be read directly from the history instance.
   */

  const NavigationContext = /*#__PURE__*/React__namespace.createContext(null);
  {
    NavigationContext.displayName = "Navigation";
  }
  const LocationContext = /*#__PURE__*/React__namespace.createContext(null);
  {
    LocationContext.displayName = "Location";
  }
  const RouteContext = /*#__PURE__*/React__namespace.createContext({
    outlet: null,
    matches: [],
    isDataRoute: false
  });
  {
    RouteContext.displayName = "Route";
  }
  const RouteErrorContext = /*#__PURE__*/React__namespace.createContext(null);
  {
    RouteErrorContext.displayName = "RouteError";
  }

  /**
   * Returns the full href for the given "to" value. This is useful for building
   * custom links that are also accessible and preserve right-click behavior.
   *
   * @see https://reactrouter.com/hooks/use-href
   */
  function useHref(to, _temp) {
    let {
      relative
    } = _temp === void 0 ? {} : _temp;
    !useInRouterContext() ? router.UNSAFE_invariant(false, // TODO: This error is probably because they somehow have 2 versions of the
    // router loaded. We can help them understand how to avoid that.
    "useHref() may be used only in the context of a <Router> component.")  : void 0;
    let {
      basename,
      navigator
    } = React__namespace.useContext(NavigationContext);
    let {
      hash,
      pathname,
      search
    } = useResolvedPath(to, {
      relative
    });
    let joinedPathname = pathname;

    // If we're operating within a basename, prepend it to the pathname prior
    // to creating the href.  If this is a root navigation, then just use the raw
    // basename which allows the basename to have full control over the presence
    // of a trailing slash on root links
    if (basename !== "/") {
      joinedPathname = pathname === "/" ? basename : router.joinPaths([basename, pathname]);
    }
    return navigator.createHref({
      pathname: joinedPathname,
      search,
      hash
    });
  }

  /**
   * Returns true if this component is a descendant of a `<Router>`.
   *
   * @see https://reactrouter.com/hooks/use-in-router-context
   */
  function useInRouterContext() {
    return React__namespace.useContext(LocationContext) != null;
  }

  /**
   * Returns the current location object, which represents the current URL in web
   * browsers.
   *
   * Note: If you're using this it may mean you're doing some of your own
   * "routing" in your app, and we'd like to know what your use case is. We may
   * be able to provide something higher-level to better suit your needs.
   *
   * @see https://reactrouter.com/hooks/use-location
   */
  function useLocation() {
    !useInRouterContext() ? router.UNSAFE_invariant(false, // TODO: This error is probably because they somehow have 2 versions of the
    // router loaded. We can help them understand how to avoid that.
    "useLocation() may be used only in the context of a <Router> component.")  : void 0;
    return React__namespace.useContext(LocationContext).location;
  }

  /**
   * Returns the current navigation action which describes how the router came to
   * the current location, either by a pop, push, or replace on the history stack.
   *
   * @see https://reactrouter.com/hooks/use-navigation-type
   */
  function useNavigationType() {
    return React__namespace.useContext(LocationContext).navigationType;
  }

  /**
   * Returns a PathMatch object if the given pattern matches the current URL.
   * This is useful for components that need to know "active" state, e.g.
   * `<NavLink>`.
   *
   * @see https://reactrouter.com/hooks/use-match
   */
  function useMatch(pattern) {
    !useInRouterContext() ? router.UNSAFE_invariant(false, // TODO: This error is probably because they somehow have 2 versions of the
    // router loaded. We can help them understand how to avoid that.
    "useMatch() may be used only in the context of a <Router> component.")  : void 0;
    let {
      pathname
    } = useLocation();
    return React__namespace.useMemo(() => router.matchPath(pattern, router.UNSAFE_decodePath(pathname)), [pathname, pattern]);
  }

  /**
   * The interface for the navigate() function returned from useNavigate().
   */

  const navigateEffectWarning = "You should call navigate() in a React.useEffect(), not when " + "your component is first rendered.";

  // Mute warnings for calls to useNavigate in SSR environments
  function useIsomorphicLayoutEffect(cb) {
    let isStatic = React__namespace.useContext(NavigationContext).static;
    if (!isStatic) {
      // We should be able to get rid of this once react 18.3 is released
      // See: https://github.com/facebook/react/pull/26395
      // eslint-disable-next-line react-hooks/rules-of-hooks
      React__namespace.useLayoutEffect(cb);
    }
  }

  /**
   * Returns an imperative method for changing the location. Used by `<Link>`s, but
   * may also be used by other elements to change the location.
   *
   * @see https://reactrouter.com/hooks/use-navigate
   */
  function useNavigate() {
    let {
      isDataRoute
    } = React__namespace.useContext(RouteContext);
    // Conditional usage is OK here because the usage of a data router is static
    // eslint-disable-next-line react-hooks/rules-of-hooks
    return isDataRoute ? useNavigateStable() : useNavigateUnstable();
  }
  function useNavigateUnstable() {
    !useInRouterContext() ? router.UNSAFE_invariant(false, // TODO: This error is probably because they somehow have 2 versions of the
    // router loaded. We can help them understand how to avoid that.
    "useNavigate() may be used only in the context of a <Router> component.")  : void 0;
    let dataRouterContext = React__namespace.useContext(DataRouterContext);
    let {
      basename,
      future,
      navigator
    } = React__namespace.useContext(NavigationContext);
    let {
      matches
    } = React__namespace.useContext(RouteContext);
    let {
      pathname: locationPathname
    } = useLocation();
    let routePathnamesJson = JSON.stringify(router.UNSAFE_getResolveToMatches(matches, future.v7_relativeSplatPath));
    let activeRef = React__namespace.useRef(false);
    useIsomorphicLayoutEffect(() => {
      activeRef.current = true;
    });
    let navigate = React__namespace.useCallback(function (to, options) {
      if (options === void 0) {
        options = {};
      }
      router.UNSAFE_warning(activeRef.current, navigateEffectWarning) ;

      // Short circuit here since if this happens on first render the navigate
      // is useless because we haven't wired up our history listener yet
      if (!activeRef.current) return;
      if (typeof to === "number") {
        navigator.go(to);
        return;
      }
      let path = router.resolveTo(to, JSON.parse(routePathnamesJson), locationPathname, options.relative === "path");

      // If we're operating within a basename, prepend it to the pathname prior
      // to handing off to history (but only if we're not in a data router,
      // otherwise it'll prepend the basename inside of the router).
      // If this is a root navigation, then we navigate to the raw basename
      // which allows the basename to have full control over the presence of a
      // trailing slash on root links
      if (dataRouterContext == null && basename !== "/") {
        path.pathname = path.pathname === "/" ? basename : router.joinPaths([basename, path.pathname]);
      }
      (!!options.replace ? navigator.replace : navigator.push)(path, options.state, options);
    }, [basename, navigator, routePathnamesJson, locationPathname, dataRouterContext]);
    return navigate;
  }
  const OutletContext = /*#__PURE__*/React__namespace.createContext(null);

  /**
   * Returns the context (if provided) for the child route at this level of the route
   * hierarchy.
   * @see https://reactrouter.com/hooks/use-outlet-context
   */
  function useOutletContext() {
    return React__namespace.useContext(OutletContext);
  }

  /**
   * Returns the element for the child route at this level of the route
   * hierarchy. Used internally by `<Outlet>` to render child routes.
   *
   * @see https://reactrouter.com/hooks/use-outlet
   */
  function useOutlet(context) {
    let outlet = React__namespace.useContext(RouteContext).outlet;
    if (outlet) {
      return /*#__PURE__*/React__namespace.createElement(OutletContext.Provider, {
        value: context
      }, outlet);
    }
    return outlet;
  }

  /**
   * Returns an object of key/value pairs of the dynamic params from the current
   * URL that were matched by the route path.
   *
   * @see https://reactrouter.com/hooks/use-params
   */
  function useParams() {
    let {
      matches
    } = React__namespace.useContext(RouteContext);
    let routeMatch = matches[matches.length - 1];
    return routeMatch ? routeMatch.params : {};
  }

  /**
   * Resolves the pathname of the given `to` value against the current location.
   *
   * @see https://reactrouter.com/hooks/use-resolved-path
   */
  function useResolvedPath(to, _temp2) {
    let {
      relative
    } = _temp2 === void 0 ? {} : _temp2;
    let {
      future
    } = React__namespace.useContext(NavigationContext);
    let {
      matches
    } = React__namespace.useContext(RouteContext);
    let {
      pathname: locationPathname
    } = useLocation();
    let routePathnamesJson = JSON.stringify(router.UNSAFE_getResolveToMatches(matches, future.v7_relativeSplatPath));
    return React__namespace.useMemo(() => router.resolveTo(to, JSON.parse(routePathnamesJson), locationPathname, relative === "path"), [to, routePathnamesJson, locationPathname, relative]);
  }

  /**
   * Returns the element of the route that matched the current location, prepared
   * with the correct context to render the remainder of the route tree. Route
   * elements in the tree must render an `<Outlet>` to render their child route's
   * element.
   *
   * @see https://reactrouter.com/hooks/use-routes
   */
  function useRoutes(routes, locationArg) {
    return useRoutesImpl(routes, locationArg);
  }

  // Internal implementation with accept optional param for RouterProvider usage
  function useRoutesImpl(routes, locationArg, dataRouterState, future) {
    !useInRouterContext() ? router.UNSAFE_invariant(false, // TODO: This error is probably because they somehow have 2 versions of the
    // router loaded. We can help them understand how to avoid that.
    "useRoutes() may be used only in the context of a <Router> component.")  : void 0;
    let {
      navigator
    } = React__namespace.useContext(NavigationContext);
    let {
      matches: parentMatches
    } = React__namespace.useContext(RouteContext);
    let routeMatch = parentMatches[parentMatches.length - 1];
    let parentParams = routeMatch ? routeMatch.params : {};
    let parentPathname = routeMatch ? routeMatch.pathname : "/";
    let parentPathnameBase = routeMatch ? routeMatch.pathnameBase : "/";
    let parentRoute = routeMatch && routeMatch.route;
    {
      // You won't get a warning about 2 different <Routes> under a <Route>
      // without a trailing *, but this is a best-effort warning anyway since we
      // cannot even give the warning unless they land at the parent route.
      //
      // Example:
      //
      // <Routes>
      //   {/* This route path MUST end with /* because otherwise
      //       it will never match /blog/post/123 */}
      //   <Route path="blog" element={<Blog />} />
      //   <Route path="blog/feed" element={<BlogFeed />} />
      // </Routes>
      //
      // function Blog() {
      //   return (
      //     <Routes>
      //       <Route path="post/:id" element={<Post />} />
      //     </Routes>
      //   );
      // }
      let parentPath = parentRoute && parentRoute.path || "";
      warningOnce(parentPathname, !parentRoute || parentPath.endsWith("*"), "You rendered descendant <Routes> (or called `useRoutes()`) at " + ("\"" + parentPathname + "\" (under <Route path=\"" + parentPath + "\">) but the ") + "parent route path has no trailing \"*\". This means if you navigate " + "deeper, the parent won't match anymore and therefore the child " + "routes will never render.\n\n" + ("Please change the parent <Route path=\"" + parentPath + "\"> to <Route ") + ("path=\"" + (parentPath === "/" ? "*" : parentPath + "/*") + "\">."));
    }
    let locationFromContext = useLocation();
    let location;
    if (locationArg) {
      var _parsedLocationArg$pa;
      let parsedLocationArg = typeof locationArg === "string" ? router.parsePath(locationArg) : locationArg;
      !(parentPathnameBase === "/" || ((_parsedLocationArg$pa = parsedLocationArg.pathname) == null ? void 0 : _parsedLocationArg$pa.startsWith(parentPathnameBase))) ? router.UNSAFE_invariant(false, "When overriding the location using `<Routes location>` or `useRoutes(routes, location)`, " + "the location pathname must begin with the portion of the URL pathname that was " + ("matched by all parent routes. The current pathname base is \"" + parentPathnameBase + "\" ") + ("but pathname \"" + parsedLocationArg.pathname + "\" was given in the `location` prop."))  : void 0;
      location = parsedLocationArg;
    } else {
      location = locationFromContext;
    }
    let pathname = location.pathname || "/";
    let remainingPathname = pathname;
    if (parentPathnameBase !== "/") {
      // Determine the remaining pathname by removing the # of URL segments the
      // parentPathnameBase has, instead of removing based on character count.
      // This is because we can't guarantee that incoming/outgoing encodings/
      // decodings will match exactly.
      // We decode paths before matching on a per-segment basis with
      // decodeURIComponent(), but we re-encode pathnames via `new URL()` so they
      // match what `window.location.pathname` would reflect.  Those don't 100%
      // align when it comes to encoded URI characters such as % and &.
      //
      // So we may end up with:
      //   pathname:           "/descendant/a%25b/match"
      //   parentPathnameBase: "/descendant/a%b"
      //
      // And the direct substring removal approach won't work :/
      let parentSegments = parentPathnameBase.replace(/^\//, "").split("/");
      let segments = pathname.replace(/^\//, "").split("/");
      remainingPathname = "/" + segments.slice(parentSegments.length).join("/");
    }
    let matches = router.matchRoutes(routes, {
      pathname: remainingPathname
    });
    {
      router.UNSAFE_warning(parentRoute || matches != null, "No routes matched location \"" + location.pathname + location.search + location.hash + "\" ") ;
      router.UNSAFE_warning(matches == null || matches[matches.length - 1].route.element !== undefined || matches[matches.length - 1].route.Component !== undefined || matches[matches.length - 1].route.lazy !== undefined, "Matched leaf route at location \"" + location.pathname + location.search + location.hash + "\" " + "does not have an element or Component. This means it will render an <Outlet /> with a " + "null value by default resulting in an \"empty\" page.") ;
    }
    let renderedMatches = _renderMatches(matches && matches.map(match => Object.assign({}, match, {
      params: Object.assign({}, parentParams, match.params),
      pathname: router.joinPaths([parentPathnameBase,
      // Re-encode pathnames that were decoded inside matchRoutes
      navigator.encodeLocation ? navigator.encodeLocation(match.pathname).pathname : match.pathname]),
      pathnameBase: match.pathnameBase === "/" ? parentPathnameBase : router.joinPaths([parentPathnameBase,
      // Re-encode pathnames that were decoded inside matchRoutes
      navigator.encodeLocation ? navigator.encodeLocation(match.pathnameBase).pathname : match.pathnameBase])
    })), parentMatches, dataRouterState, future);

    // When a user passes in a `locationArg`, the associated routes need to
    // be wrapped in a new `LocationContext.Provider` in order for `useLocation`
    // to use the scoped location instead of the global location.
    if (locationArg && renderedMatches) {
      return /*#__PURE__*/React__namespace.createElement(LocationContext.Provider, {
        value: {
          location: _extends({
            pathname: "/",
            search: "",
            hash: "",
            state: null,
            key: "default"
          }, location),
          navigationType: router.Action.Pop
        }
      }, renderedMatches);
    }
    return renderedMatches;
  }
  function DefaultErrorComponent() {
    let error = useRouteError();
    let message = router.isRouteErrorResponse(error) ? error.status + " " + error.statusText : error instanceof Error ? error.message : JSON.stringify(error);
    let stack = error instanceof Error ? error.stack : null;
    let lightgrey = "rgba(200,200,200, 0.5)";
    let preStyles = {
      padding: "0.5rem",
      backgroundColor: lightgrey
    };
    let codeStyles = {
      padding: "2px 4px",
      backgroundColor: lightgrey
    };
    let devInfo = null;
    {
      console.error("Error handled by React Router default ErrorBoundary:", error);
      devInfo = /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, /*#__PURE__*/React__namespace.createElement("p", null, "\uD83D\uDCBF Hey developer \uD83D\uDC4B"), /*#__PURE__*/React__namespace.createElement("p", null, "You can provide a way better UX than this when your app throws errors by providing your own ", /*#__PURE__*/React__namespace.createElement("code", {
        style: codeStyles
      }, "ErrorBoundary"), " or", " ", /*#__PURE__*/React__namespace.createElement("code", {
        style: codeStyles
      }, "errorElement"), " prop on your route."));
    }
    return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, /*#__PURE__*/React__namespace.createElement("h2", null, "Unexpected Application Error!"), /*#__PURE__*/React__namespace.createElement("h3", {
      style: {
        fontStyle: "italic"
      }
    }, message), stack ? /*#__PURE__*/React__namespace.createElement("pre", {
      style: preStyles
    }, stack) : null, devInfo);
  }
  const defaultErrorElement = /*#__PURE__*/React__namespace.createElement(DefaultErrorComponent, null);
  class RenderErrorBoundary extends React__namespace.Component {
    constructor(props) {
      super(props);
      this.state = {
        location: props.location,
        revalidation: props.revalidation,
        error: props.error
      };
    }
    static getDerivedStateFromError(error) {
      return {
        error: error
      };
    }
    static getDerivedStateFromProps(props, state) {
      // When we get into an error state, the user will likely click "back" to the
      // previous page that didn't have an error. Because this wraps the entire
      // application, that will have no effect--the error page continues to display.
      // This gives us a mechanism to recover from the error when the location changes.
      //
      // Whether we're in an error state or not, we update the location in state
      // so that when we are in an error state, it gets reset when a new location
      // comes in and the user recovers from the error.
      if (state.location !== props.location || state.revalidation !== "idle" && props.revalidation === "idle") {
        return {
          error: props.error,
          location: props.location,
          revalidation: props.revalidation
        };
      }

      // If we're not changing locations, preserve the location but still surface
      // any new errors that may come through. We retain the existing error, we do
      // this because the error provided from the app state may be cleared without
      // the location changing.
      return {
        error: props.error !== undefined ? props.error : state.error,
        location: state.location,
        revalidation: props.revalidation || state.revalidation
      };
    }
    componentDidCatch(error, errorInfo) {
      console.error("React Router caught the following error during render", error, errorInfo);
    }
    render() {
      return this.state.error !== undefined ? /*#__PURE__*/React__namespace.createElement(RouteContext.Provider, {
        value: this.props.routeContext
      }, /*#__PURE__*/React__namespace.createElement(RouteErrorContext.Provider, {
        value: this.state.error,
        children: this.props.component
      })) : this.props.children;
    }
  }
  function RenderedRoute(_ref) {
    let {
      routeContext,
      match,
      children
    } = _ref;
    let dataRouterContext = React__namespace.useContext(DataRouterContext);

    // Track how deep we got in our render pass to emulate SSR componentDidCatch
    // in a DataStaticRouter
    if (dataRouterContext && dataRouterContext.static && dataRouterContext.staticContext && (match.route.errorElement || match.route.ErrorBoundary)) {
      dataRouterContext.staticContext._deepestRenderedBoundaryId = match.route.id;
    }
    return /*#__PURE__*/React__namespace.createElement(RouteContext.Provider, {
      value: routeContext
    }, children);
  }
  function _renderMatches(matches, parentMatches, dataRouterState, future) {
    var _dataRouterState;
    if (parentMatches === void 0) {
      parentMatches = [];
    }
    if (dataRouterState === void 0) {
      dataRouterState = null;
    }
    if (future === void 0) {
      future = null;
    }
    if (matches == null) {
      var _future;
      if (!dataRouterState) {
        return null;
      }
      if (dataRouterState.errors) {
        // Don't bail if we have data router errors so we can render them in the
        // boundary.  Use the pre-matched (or shimmed) matches
        matches = dataRouterState.matches;
      } else if ((_future = future) != null && _future.v7_partialHydration && parentMatches.length === 0 && !dataRouterState.initialized && dataRouterState.matches.length > 0) {
        // Don't bail if we're initializing with partial hydration and we have
        // router matches.  That means we're actively running `patchRoutesOnNavigation`
        // so we should render down the partial matches to the appropriate
        // `HydrateFallback`.  We only do this if `parentMatches` is empty so it
        // only impacts the root matches for `RouterProvider` and no descendant
        // `<Routes>`
        matches = dataRouterState.matches;
      } else {
        return null;
      }
    }
    let renderedMatches = matches;

    // If we have data errors, trim matches to the highest error boundary
    let errors = (_dataRouterState = dataRouterState) == null ? void 0 : _dataRouterState.errors;
    if (errors != null) {
      let errorIndex = renderedMatches.findIndex(m => m.route.id && (errors == null ? void 0 : errors[m.route.id]) !== undefined);
      !(errorIndex >= 0) ? router.UNSAFE_invariant(false, "Could not find a matching route for errors on route IDs: " + Object.keys(errors).join(","))  : void 0;
      renderedMatches = renderedMatches.slice(0, Math.min(renderedMatches.length, errorIndex + 1));
    }

    // If we're in a partial hydration mode, detect if we need to render down to
    // a given HydrateFallback while we load the rest of the hydration data
    let renderFallback = false;
    let fallbackIndex = -1;
    if (dataRouterState && future && future.v7_partialHydration) {
      for (let i = 0; i < renderedMatches.length; i++) {
        let match = renderedMatches[i];
        // Track the deepest fallback up until the first route without data
        if (match.route.HydrateFallback || match.route.hydrateFallbackElement) {
          fallbackIndex = i;
        }
        if (match.route.id) {
          let {
            loaderData,
            errors
          } = dataRouterState;
          let needsToRunLoader = match.route.loader && loaderData[match.route.id] === undefined && (!errors || errors[match.route.id] === undefined);
          if (match.route.lazy || needsToRunLoader) {
            // We found the first route that's not ready to render (waiting on
            // lazy, or has a loader that hasn't run yet).  Flag that we need to
            // render a fallback and render up until the appropriate fallback
            renderFallback = true;
            if (fallbackIndex >= 0) {
              renderedMatches = renderedMatches.slice(0, fallbackIndex + 1);
            } else {
              renderedMatches = [renderedMatches[0]];
            }
            break;
          }
        }
      }
    }
    return renderedMatches.reduceRight((outlet, match, index) => {
      // Only data routers handle errors/fallbacks
      let error;
      let shouldRenderHydrateFallback = false;
      let errorElement = null;
      let hydrateFallbackElement = null;
      if (dataRouterState) {
        error = errors && match.route.id ? errors[match.route.id] : undefined;
        errorElement = match.route.errorElement || defaultErrorElement;
        if (renderFallback) {
          if (fallbackIndex < 0 && index === 0) {
            warningOnce("route-fallback", false, "No `HydrateFallback` element provided to render during initial hydration");
            shouldRenderHydrateFallback = true;
            hydrateFallbackElement = null;
          } else if (fallbackIndex === index) {
            shouldRenderHydrateFallback = true;
            hydrateFallbackElement = match.route.hydrateFallbackElement || null;
          }
        }
      }
      let matches = parentMatches.concat(renderedMatches.slice(0, index + 1));
      let getChildren = () => {
        let children;
        if (error) {
          children = errorElement;
        } else if (shouldRenderHydrateFallback) {
          children = hydrateFallbackElement;
        } else if (match.route.Component) {
          // Note: This is a de-optimized path since React won't re-use the
          // ReactElement since it's identity changes with each new
          // React.createElement call.  We keep this so folks can use
          // `<Route Component={...}>` in `<Routes>` but generally `Component`
          // usage is only advised in `RouterProvider` when we can convert it to
          // `element` ahead of time.
          children = /*#__PURE__*/React__namespace.createElement(match.route.Component, null);
        } else if (match.route.element) {
          children = match.route.element;
        } else {
          children = outlet;
        }
        return /*#__PURE__*/React__namespace.createElement(RenderedRoute, {
          match: match,
          routeContext: {
            outlet,
            matches,
            isDataRoute: dataRouterState != null
          },
          children: children
        });
      };
      // Only wrap in an error boundary within data router usages when we have an
      // ErrorBoundary/errorElement on this route.  Otherwise let it bubble up to
      // an ancestor ErrorBoundary/errorElement
      return dataRouterState && (match.route.ErrorBoundary || match.route.errorElement || index === 0) ? /*#__PURE__*/React__namespace.createElement(RenderErrorBoundary, {
        location: dataRouterState.location,
        revalidation: dataRouterState.revalidation,
        component: errorElement,
        error: error,
        children: getChildren(),
        routeContext: {
          outlet: null,
          matches,
          isDataRoute: true
        }
      }) : getChildren();
    }, null);
  }
  var DataRouterHook = /*#__PURE__*/function (DataRouterHook) {
    DataRouterHook["UseBlocker"] = "useBlocker";
    DataRouterHook["UseRevalidator"] = "useRevalidator";
    DataRouterHook["UseNavigateStable"] = "useNavigate";
    return DataRouterHook;
  }(DataRouterHook || {});
  var DataRouterStateHook = /*#__PURE__*/function (DataRouterStateHook) {
    DataRouterStateHook["UseBlocker"] = "useBlocker";
    DataRouterStateHook["UseLoaderData"] = "useLoaderData";
    DataRouterStateHook["UseActionData"] = "useActionData";
    DataRouterStateHook["UseRouteError"] = "useRouteError";
    DataRouterStateHook["UseNavigation"] = "useNavigation";
    DataRouterStateHook["UseRouteLoaderData"] = "useRouteLoaderData";
    DataRouterStateHook["UseMatches"] = "useMatches";
    DataRouterStateHook["UseRevalidator"] = "useRevalidator";
    DataRouterStateHook["UseNavigateStable"] = "useNavigate";
    DataRouterStateHook["UseRouteId"] = "useRouteId";
    return DataRouterStateHook;
  }(DataRouterStateHook || {});
  function getDataRouterConsoleError(hookName) {
    return hookName + " must be used within a data router.  See https://reactrouter.com/routers/picking-a-router.";
  }
  function useDataRouterContext(hookName) {
    let ctx = React__namespace.useContext(DataRouterContext);
    !ctx ? router.UNSAFE_invariant(false, getDataRouterConsoleError(hookName))  : void 0;
    return ctx;
  }
  function useDataRouterState(hookName) {
    let state = React__namespace.useContext(DataRouterStateContext);
    !state ? router.UNSAFE_invariant(false, getDataRouterConsoleError(hookName))  : void 0;
    return state;
  }
  function useRouteContext(hookName) {
    let route = React__namespace.useContext(RouteContext);
    !route ? router.UNSAFE_invariant(false, getDataRouterConsoleError(hookName))  : void 0;
    return route;
  }

  // Internal version with hookName-aware debugging
  function useCurrentRouteId(hookName) {
    let route = useRouteContext(hookName);
    let thisRoute = route.matches[route.matches.length - 1];
    !thisRoute.route.id ? router.UNSAFE_invariant(false, hookName + " can only be used on routes that contain a unique \"id\"")  : void 0;
    return thisRoute.route.id;
  }

  /**
   * Returns the ID for the nearest contextual route
   */
  function useRouteId() {
    return useCurrentRouteId(DataRouterStateHook.UseRouteId);
  }

  /**
   * Returns the current navigation, defaulting to an "idle" navigation when
   * no navigation is in progress
   */
  function useNavigation() {
    let state = useDataRouterState(DataRouterStateHook.UseNavigation);
    return state.navigation;
  }

  /**
   * Returns a revalidate function for manually triggering revalidation, as well
   * as the current state of any manual revalidations
   */
  function useRevalidator() {
    let dataRouterContext = useDataRouterContext(DataRouterHook.UseRevalidator);
    let state = useDataRouterState(DataRouterStateHook.UseRevalidator);
    return React__namespace.useMemo(() => ({
      revalidate: dataRouterContext.router.revalidate,
      state: state.revalidation
    }), [dataRouterContext.router.revalidate, state.revalidation]);
  }

  /**
   * Returns the active route matches, useful for accessing loaderData for
   * parent/child routes or the route "handle" property
   */
  function useMatches() {
    let {
      matches,
      loaderData
    } = useDataRouterState(DataRouterStateHook.UseMatches);
    return React__namespace.useMemo(() => matches.map(m => router.UNSAFE_convertRouteMatchToUiMatch(m, loaderData)), [matches, loaderData]);
  }

  /**
   * Returns the loader data for the nearest ancestor Route loader
   */
  function useLoaderData() {
    let state = useDataRouterState(DataRouterStateHook.UseLoaderData);
    let routeId = useCurrentRouteId(DataRouterStateHook.UseLoaderData);
    if (state.errors && state.errors[routeId] != null) {
      console.error("You cannot `useLoaderData` in an errorElement (routeId: " + routeId + ")");
      return undefined;
    }
    return state.loaderData[routeId];
  }

  /**
   * Returns the loaderData for the given routeId
   */
  function useRouteLoaderData(routeId) {
    let state = useDataRouterState(DataRouterStateHook.UseRouteLoaderData);
    return state.loaderData[routeId];
  }

  /**
   * Returns the action data for the nearest ancestor Route action
   */
  function useActionData() {
    let state = useDataRouterState(DataRouterStateHook.UseActionData);
    let routeId = useCurrentRouteId(DataRouterStateHook.UseLoaderData);
    return state.actionData ? state.actionData[routeId] : undefined;
  }

  /**
   * Returns the nearest ancestor Route error, which could be a loader/action
   * error or a render error.  This is intended to be called from your
   * ErrorBoundary/errorElement to display a proper error message.
   */
  function useRouteError() {
    var _state$errors;
    let error = React__namespace.useContext(RouteErrorContext);
    let state = useDataRouterState(DataRouterStateHook.UseRouteError);
    let routeId = useCurrentRouteId(DataRouterStateHook.UseRouteError);

    // If this was a render error, we put it in a RouteError context inside
    // of RenderErrorBoundary
    if (error !== undefined) {
      return error;
    }

    // Otherwise look for errors from our data router state
    return (_state$errors = state.errors) == null ? void 0 : _state$errors[routeId];
  }

  /**
   * Returns the happy-path data from the nearest ancestor `<Await />` value
   */
  function useAsyncValue() {
    let value = React__namespace.useContext(AwaitContext);
    return value == null ? void 0 : value._data;
  }

  /**
   * Returns the error from the nearest ancestor `<Await />` value
   */
  function useAsyncError() {
    let value = React__namespace.useContext(AwaitContext);
    return value == null ? void 0 : value._error;
  }
  let blockerId = 0;

  /**
   * Allow the application to block navigations within the SPA and present the
   * user a confirmation dialog to confirm the navigation.  Mostly used to avoid
   * using half-filled form data.  This does not handle hard-reloads or
   * cross-origin navigations.
   */
  function useBlocker(shouldBlock) {
    let {
      router: router$1,
      basename
    } = useDataRouterContext(DataRouterHook.UseBlocker);
    let state = useDataRouterState(DataRouterStateHook.UseBlocker);
    let [blockerKey, setBlockerKey] = React__namespace.useState("");
    let blockerFunction = React__namespace.useCallback(arg => {
      if (typeof shouldBlock !== "function") {
        return !!shouldBlock;
      }
      if (basename === "/") {
        return shouldBlock(arg);
      }

      // If they provided us a function and we've got an active basename, strip
      // it from the locations we expose to the user to match the behavior of
      // useLocation
      let {
        currentLocation,
        nextLocation,
        historyAction
      } = arg;
      return shouldBlock({
        currentLocation: _extends({}, currentLocation, {
          pathname: router.stripBasename(currentLocation.pathname, basename) || currentLocation.pathname
        }),
        nextLocation: _extends({}, nextLocation, {
          pathname: router.stripBasename(nextLocation.pathname, basename) || nextLocation.pathname
        }),
        historyAction
      });
    }, [basename, shouldBlock]);

    // This effect is in charge of blocker key assignment and deletion (which is
    // tightly coupled to the key)
    React__namespace.useEffect(() => {
      let key = String(++blockerId);
      setBlockerKey(key);
      return () => router$1.deleteBlocker(key);
    }, [router$1]);

    // This effect handles assigning the blockerFunction.  This is to handle
    // unstable blocker function identities, and happens only after the prior
    // effect so we don't get an orphaned blockerFunction in the router with a
    // key of "".  Until then we just have the IDLE_BLOCKER.
    React__namespace.useEffect(() => {
      if (blockerKey !== "") {
        router$1.getBlocker(blockerKey, blockerFunction);
      }
    }, [router$1, blockerKey, blockerFunction]);

    // Prefer the blocker from `state` not `router.state` since DataRouterContext
    // is memoized so this ensures we update on blocker state updates
    return blockerKey && state.blockers.has(blockerKey) ? state.blockers.get(blockerKey) : router.IDLE_BLOCKER;
  }

  /**
   * Stable version of useNavigate that is used when we are in the context of
   * a RouterProvider.
   */
  function useNavigateStable() {
    let {
      router: router$1
    } = useDataRouterContext(DataRouterHook.UseNavigateStable);
    let id = useCurrentRouteId(DataRouterStateHook.UseNavigateStable);
    let activeRef = React__namespace.useRef(false);
    useIsomorphicLayoutEffect(() => {
      activeRef.current = true;
    });
    let navigate = React__namespace.useCallback(function (to, options) {
      if (options === void 0) {
        options = {};
      }
      router.UNSAFE_warning(activeRef.current, navigateEffectWarning) ;

      // Short circuit here since if this happens on first render the navigate
      // is useless because we haven't wired up our router subscriber yet
      if (!activeRef.current) return;
      if (typeof to === "number") {
        router$1.navigate(to);
      } else {
        router$1.navigate(to, _extends({
          fromRouteId: id
        }, options));
      }
    }, [router$1, id]);
    return navigate;
  }
  const alreadyWarned = {};
  function warningOnce(key, cond, message) {
    if (!cond && !alreadyWarned[key]) {
      alreadyWarned[key] = true;
      router.UNSAFE_warning(false, message) ;
    }
  }

  /**
    Webpack + React 17 fails to compile on any of the following because webpack
    complains that `startTransition` doesn't exist in `React`:
    * import { startTransition } from "react"
    * import * as React from from "react";
      "startTransition" in React ? React.startTransition(() => setState()) : setState()
    * import * as React from from "react";
      "startTransition" in React ? React["startTransition"](() => setState()) : setState()

    Moving it to a constant such as the following solves the Webpack/React 17 issue:
    * import * as React from from "react";
      const START_TRANSITION = "startTransition";
      START_TRANSITION in React ? React[START_TRANSITION](() => setState()) : setState()

    However, that introduces webpack/terser minification issues in production builds
    in React 18 where minification/obfuscation ends up removing the call of
    React.startTransition entirely from the first half of the ternary.  Grabbing
    this exported reference once up front resolves that issue.

    See https://github.com/remix-run/react-router/issues/10579
  */
  const START_TRANSITION = "startTransition";
  const startTransitionImpl = React__namespace[START_TRANSITION];

  /**
   * Given a Remix Router instance, render the appropriate UI
   */
  function RouterProvider(_ref) {
    let {
      fallbackElement,
      router: router$1,
      future
    } = _ref;
    let [state, setStateImpl] = React__namespace.useState(router$1.state);
    let {
      v7_startTransition
    } = future || {};
    let setState = React__namespace.useCallback(newState => {
      if (v7_startTransition && startTransitionImpl) {
        startTransitionImpl(() => setStateImpl(newState));
      } else {
        setStateImpl(newState);
      }
    }, [setStateImpl, v7_startTransition]);

    // Need to use a layout effect here so we are subscribed early enough to
    // pick up on any render-driven redirects/navigations (useEffect/<Navigate>)
    React__namespace.useLayoutEffect(() => router$1.subscribe(setState), [router$1, setState]);
    React__namespace.useEffect(() => {
      router.UNSAFE_warning(fallbackElement == null || !router$1.future.v7_partialHydration, "`<RouterProvider fallbackElement>` is deprecated when using " + "`v7_partialHydration`, use a `HydrateFallback` component instead") ;
      // Only log this once on initial mount
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, []);
    let navigator = React__namespace.useMemo(() => {
      return {
        createHref: router$1.createHref,
        encodeLocation: router$1.encodeLocation,
        go: n => router$1.navigate(n),
        push: (to, state, opts) => router$1.navigate(to, {
          state,
          preventScrollReset: opts == null ? void 0 : opts.preventScrollReset
        }),
        replace: (to, state, opts) => router$1.navigate(to, {
          replace: true,
          state,
          preventScrollReset: opts == null ? void 0 : opts.preventScrollReset
        })
      };
    }, [router$1]);
    let basename = router$1.basename || "/";
    let dataRouterContext = React__namespace.useMemo(() => ({
      router: router$1,
      navigator,
      static: false,
      basename
    }), [router$1, navigator, basename]);

    // The fragment and {null} here are important!  We need them to keep React 18's
    // useId happy when we are server-rendering since we may have a <script> here
    // containing the hydrated server-side staticContext (from StaticRouterProvider).
    // useId relies on the component tree structure to generate deterministic id's
    // so we need to ensure it remains the same on the client even though
    // we don't need the <script> tag
    return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, /*#__PURE__*/React__namespace.createElement(DataRouterContext.Provider, {
      value: dataRouterContext
    }, /*#__PURE__*/React__namespace.createElement(DataRouterStateContext.Provider, {
      value: state
    }, /*#__PURE__*/React__namespace.createElement(Router, {
      basename: basename,
      location: state.location,
      navigationType: state.historyAction,
      navigator: navigator,
      future: {
        v7_relativeSplatPath: router$1.future.v7_relativeSplatPath
      }
    }, state.initialized || router$1.future.v7_partialHydration ? /*#__PURE__*/React__namespace.createElement(DataRoutes, {
      routes: router$1.routes,
      future: router$1.future,
      state: state
    }) : fallbackElement))), null);
  }
  function DataRoutes(_ref2) {
    let {
      routes,
      future,
      state
    } = _ref2;
    return useRoutesImpl(routes, undefined, state, future);
  }
  /**
   * A `<Router>` that stores all entries in memory.
   *
   * @see https://reactrouter.com/router-components/memory-router
   */
  function MemoryRouter(_ref3) {
    let {
      basename,
      children,
      initialEntries,
      initialIndex,
      future
    } = _ref3;
    let historyRef = React__namespace.useRef();
    if (historyRef.current == null) {
      historyRef.current = router.createMemoryHistory({
        initialEntries,
        initialIndex,
        v5Compat: true
      });
    }
    let history = historyRef.current;
    let [state, setStateImpl] = React__namespace.useState({
      action: history.action,
      location: history.location
    });
    let {
      v7_startTransition
    } = future || {};
    let setState = React__namespace.useCallback(newState => {
      v7_startTransition && startTransitionImpl ? startTransitionImpl(() => setStateImpl(newState)) : setStateImpl(newState);
    }, [setStateImpl, v7_startTransition]);
    React__namespace.useLayoutEffect(() => history.listen(setState), [history, setState]);
    return /*#__PURE__*/React__namespace.createElement(Router, {
      basename: basename,
      children: children,
      location: state.location,
      navigationType: state.action,
      navigator: history,
      future: future
    });
  }
  /**
   * Changes the current location.
   *
   * Note: This API is mostly useful in React.Component subclasses that are not
   * able to use hooks. In functional components, we recommend you use the
   * `useNavigate` hook instead.
   *
   * @see https://reactrouter.com/components/navigate
   */
  function Navigate(_ref4) {
    let {
      to,
      replace,
      state,
      relative
    } = _ref4;
    !useInRouterContext() ? router.UNSAFE_invariant(false, // TODO: This error is probably because they somehow have 2 versions of
    // the router loaded. We can help them understand how to avoid that.
    "<Navigate> may be used only in the context of a <Router> component.")  : void 0;
    let {
      future,
      static: isStatic
    } = React__namespace.useContext(NavigationContext);
    router.UNSAFE_warning(!isStatic, "<Navigate> must not be used on the initial render in a <StaticRouter>. " + "This is a no-op, but you should modify your code so the <Navigate> is " + "only ever rendered in response to some user interaction or state change.") ;
    let {
      matches
    } = React__namespace.useContext(RouteContext);
    let {
      pathname: locationPathname
    } = useLocation();
    let navigate = useNavigate();

    // Resolve the path outside of the effect so that when effects run twice in
    // StrictMode they navigate to the same place
    let path = router.resolveTo(to, router.UNSAFE_getResolveToMatches(matches, future.v7_relativeSplatPath), locationPathname, relative === "path");
    let jsonPath = JSON.stringify(path);
    React__namespace.useEffect(() => navigate(JSON.parse(jsonPath), {
      replace,
      state,
      relative
    }), [navigate, jsonPath, relative, replace, state]);
    return null;
  }
  /**
   * Renders the child route's element, if there is one.
   *
   * @see https://reactrouter.com/components/outlet
   */
  function Outlet(props) {
    return useOutlet(props.context);
  }
  /**
   * Declares an element that should be rendered at a certain URL path.
   *
   * @see https://reactrouter.com/components/route
   */
  function Route(_props) {
    router.UNSAFE_invariant(false, "A <Route> is only ever to be used as the child of <Routes> element, " + "never rendered directly. Please wrap your <Route> in a <Routes>.")  ;
  }
  /**
   * Provides location context for the rest of the app.
   *
   * Note: You usually won't render a `<Router>` directly. Instead, you'll render a
   * router that is more specific to your environment such as a `<BrowserRouter>`
   * in web browsers or a `<StaticRouter>` for server rendering.
   *
   * @see https://reactrouter.com/router-components/router
   */
  function Router(_ref5) {
    let {
      basename: basenameProp = "/",
      children = null,
      location: locationProp,
      navigationType = router.Action.Pop,
      navigator,
      static: staticProp = false,
      future
    } = _ref5;
    !!useInRouterContext() ? router.UNSAFE_invariant(false, "You cannot render a <Router> inside another <Router>." + " You should never have more than one in your app.")  : void 0;

    // Preserve trailing slashes on basename, so we can let the user control
    // the enforcement of trailing slashes throughout the app
    let basename = basenameProp.replace(/^\/*/, "/");
    let navigationContext = React__namespace.useMemo(() => ({
      basename,
      navigator,
      static: staticProp,
      future: _extends({
        v7_relativeSplatPath: false
      }, future)
    }), [basename, future, navigator, staticProp]);
    if (typeof locationProp === "string") {
      locationProp = router.parsePath(locationProp);
    }
    let {
      pathname = "/",
      search = "",
      hash = "",
      state = null,
      key = "default"
    } = locationProp;
    let locationContext = React__namespace.useMemo(() => {
      let trailingPathname = router.stripBasename(pathname, basename);
      if (trailingPathname == null) {
        return null;
      }
      return {
        location: {
          pathname: trailingPathname,
          search,
          hash,
          state,
          key
        },
        navigationType
      };
    }, [basename, pathname, search, hash, state, key, navigationType]);
    router.UNSAFE_warning(locationContext != null, "<Router basename=\"" + basename + "\"> is not able to match the URL " + ("\"" + pathname + search + hash + "\" because it does not start with the ") + "basename, so the <Router> won't render anything.") ;
    if (locationContext == null) {
      return null;
    }
    return /*#__PURE__*/React__namespace.createElement(NavigationContext.Provider, {
      value: navigationContext
    }, /*#__PURE__*/React__namespace.createElement(LocationContext.Provider, {
      children: children,
      value: locationContext
    }));
  }
  /**
   * A container for a nested tree of `<Route>` elements that renders the branch
   * that best matches the current location.
   *
   * @see https://reactrouter.com/components/routes
   */
  function Routes(_ref6) {
    let {
      children,
      location
    } = _ref6;
    return useRoutes(createRoutesFromChildren(children), location);
  }
  /**
   * Component to use for rendering lazily loaded data from returning defer()
   * in a loader function
   */
  function Await(_ref7) {
    let {
      children,
      errorElement,
      resolve
    } = _ref7;
    return /*#__PURE__*/React__namespace.createElement(AwaitErrorBoundary, {
      resolve: resolve,
      errorElement: errorElement
    }, /*#__PURE__*/React__namespace.createElement(ResolveAwait, null, children));
  }
  var AwaitRenderStatus = /*#__PURE__*/function (AwaitRenderStatus) {
    AwaitRenderStatus[AwaitRenderStatus["pending"] = 0] = "pending";
    AwaitRenderStatus[AwaitRenderStatus["success"] = 1] = "success";
    AwaitRenderStatus[AwaitRenderStatus["error"] = 2] = "error";
    return AwaitRenderStatus;
  }(AwaitRenderStatus || {});
  const neverSettledPromise = new Promise(() => {});
  class AwaitErrorBoundary extends React__namespace.Component {
    constructor(props) {
      super(props);
      this.state = {
        error: null
      };
    }
    static getDerivedStateFromError(error) {
      return {
        error
      };
    }
    componentDidCatch(error, errorInfo) {
      console.error("<Await> caught the following error during render", error, errorInfo);
    }
    render() {
      let {
        children,
        errorElement,
        resolve
      } = this.props;
      let promise = null;
      let status = AwaitRenderStatus.pending;
      if (!(resolve instanceof Promise)) {
        // Didn't get a promise - provide as a resolved promise
        status = AwaitRenderStatus.success;
        promise = Promise.resolve();
        Object.defineProperty(promise, "_tracked", {
          get: () => true
        });
        Object.defineProperty(promise, "_data", {
          get: () => resolve
        });
      } else if (this.state.error) {
        // Caught a render error, provide it as a rejected promise
        status = AwaitRenderStatus.error;
        let renderError = this.state.error;
        promise = Promise.reject().catch(() => {}); // Avoid unhandled rejection warnings
        Object.defineProperty(promise, "_tracked", {
          get: () => true
        });
        Object.defineProperty(promise, "_error", {
          get: () => renderError
        });
      } else if (resolve._tracked) {
        // Already tracked promise - check contents
        promise = resolve;
        status = "_error" in promise ? AwaitRenderStatus.error : "_data" in promise ? AwaitRenderStatus.success : AwaitRenderStatus.pending;
      } else {
        // Raw (untracked) promise - track it
        status = AwaitRenderStatus.pending;
        Object.defineProperty(resolve, "_tracked", {
          get: () => true
        });
        promise = resolve.then(data => Object.defineProperty(resolve, "_data", {
          get: () => data
        }), error => Object.defineProperty(resolve, "_error", {
          get: () => error
        }));
      }
      if (status === AwaitRenderStatus.error && promise._error instanceof router.AbortedDeferredError) {
        // Freeze the UI by throwing a never resolved promise
        throw neverSettledPromise;
      }
      if (status === AwaitRenderStatus.error && !errorElement) {
        // No errorElement, throw to the nearest route-level error boundary
        throw promise._error;
      }
      if (status === AwaitRenderStatus.error) {
        // Render via our errorElement
        return /*#__PURE__*/React__namespace.createElement(AwaitContext.Provider, {
          value: promise,
          children: errorElement
        });
      }
      if (status === AwaitRenderStatus.success) {
        // Render children with resolved value
        return /*#__PURE__*/React__namespace.createElement(AwaitContext.Provider, {
          value: promise,
          children: children
        });
      }

      // Throw to the suspense boundary
      throw promise;
    }
  }

  /**
   * @private
   * Indirection to leverage useAsyncValue for a render-prop API on `<Await>`
   */
  function ResolveAwait(_ref8) {
    let {
      children
    } = _ref8;
    let data = useAsyncValue();
    let toRender = typeof children === "function" ? children(data) : children;
    return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, toRender);
  }

  ///////////////////////////////////////////////////////////////////////////////
  // UTILS
  ///////////////////////////////////////////////////////////////////////////////

  /**
   * Creates a route config from a React "children" object, which is usually
   * either a `<Route>` element or an array of them. Used internally by
   * `<Routes>` to create a route config from its children.
   *
   * @see https://reactrouter.com/utils/create-routes-from-children
   */
  function createRoutesFromChildren(children, parentPath) {
    if (parentPath === void 0) {
      parentPath = [];
    }
    let routes = [];
    React__namespace.Children.forEach(children, (element, index) => {
      if (! /*#__PURE__*/React__namespace.isValidElement(element)) {
        // Ignore non-elements. This allows people to more easily inline
        // conditionals in their route config.
        return;
      }
      let treePath = [...parentPath, index];
      if (element.type === React__namespace.Fragment) {
        // Transparently support React.Fragment and its children.
        routes.push.apply(routes, createRoutesFromChildren(element.props.children, treePath));
        return;
      }
      !(element.type === Route) ? router.UNSAFE_invariant(false, "[" + (typeof element.type === "string" ? element.type : element.type.name) + "] is not a <Route> component. All component children of <Routes> must be a <Route> or <React.Fragment>")  : void 0;
      !(!element.props.index || !element.props.children) ? router.UNSAFE_invariant(false, "An index route cannot have child routes.")  : void 0;
      let route = {
        id: element.props.id || treePath.join("-"),
        caseSensitive: element.props.caseSensitive,
        element: element.props.element,
        Component: element.props.Component,
        index: element.props.index,
        path: element.props.path,
        loader: element.props.loader,
        action: element.props.action,
        errorElement: element.props.errorElement,
        ErrorBoundary: element.props.ErrorBoundary,
        hasErrorBoundary: element.props.ErrorBoundary != null || element.props.errorElement != null,
        shouldRevalidate: element.props.shouldRevalidate,
        handle: element.props.handle,
        lazy: element.props.lazy
      };
      if (element.props.children) {
        route.children = createRoutesFromChildren(element.props.children, treePath);
      }
      routes.push(route);
    });
    return routes;
  }

  /**
   * Renders the result of `matchRoutes()` into a React element.
   */
  function renderMatches(matches) {
    return _renderMatches(matches);
  }

  function mapRouteProperties(route) {
    let updates = {
      // Note: this check also occurs in createRoutesFromChildren so update
      // there if you change this -- please and thank you!
      hasErrorBoundary: route.ErrorBoundary != null || route.errorElement != null
    };
    if (route.Component) {
      {
        if (route.element) {
          router.UNSAFE_warning(false, "You should not include both `Component` and `element` on your route - " + "`Component` will be used.") ;
        }
      }
      Object.assign(updates, {
        element: /*#__PURE__*/React__namespace.createElement(route.Component),
        Component: undefined
      });
    }
    if (route.HydrateFallback) {
      {
        if (route.hydrateFallbackElement) {
          router.UNSAFE_warning(false, "You should not include both `HydrateFallback` and `hydrateFallbackElement` on your route - " + "`HydrateFallback` will be used.") ;
        }
      }
      Object.assign(updates, {
        hydrateFallbackElement: /*#__PURE__*/React__namespace.createElement(route.HydrateFallback),
        HydrateFallback: undefined
      });
    }
    if (route.ErrorBoundary) {
      {
        if (route.errorElement) {
          router.UNSAFE_warning(false, "You should not include both `ErrorBoundary` and `errorElement` on your route - " + "`ErrorBoundary` will be used.") ;
        }
      }
      Object.assign(updates, {
        errorElement: /*#__PURE__*/React__namespace.createElement(route.ErrorBoundary),
        ErrorBoundary: undefined
      });
    }
    return updates;
  }
  function createMemoryRouter(routes, opts) {
    return router.createRouter({
      basename: opts == null ? void 0 : opts.basename,
      future: _extends({}, opts == null ? void 0 : opts.future, {
        v7_prependBasename: true
      }),
      history: router.createMemoryHistory({
        initialEntries: opts == null ? void 0 : opts.initialEntries,
        initialIndex: opts == null ? void 0 : opts.initialIndex
      }),
      hydrationData: opts == null ? void 0 : opts.hydrationData,
      routes,
      mapRouteProperties,
      unstable_dataStrategy: opts == null ? void 0 : opts.unstable_dataStrategy,
      unstable_patchRoutesOnNavigation: opts == null ? void 0 : opts.unstable_patchRoutesOnNavigation
    }).initialize();
  }

  Object.defineProperty(exports, 'AbortedDeferredError', {
    enumerable: true,
    get: function () { return router.AbortedDeferredError; }
  });
  Object.defineProperty(exports, 'NavigationType', {
    enumerable: true,
    get: function () { return router.Action; }
  });
  Object.defineProperty(exports, 'createPath', {
    enumerable: true,
    get: function () { return router.createPath; }
  });
  Object.defineProperty(exports, 'defer', {
    enumerable: true,
    get: function () { return router.defer; }
  });
  Object.defineProperty(exports, 'generatePath', {
    enumerable: true,
    get: function () { return router.generatePath; }
  });
  Object.defineProperty(exports, 'isRouteErrorResponse', {
    enumerable: true,
    get: function () { return router.isRouteErrorResponse; }
  });
  Object.defineProperty(exports, 'json', {
    enumerable: true,
    get: function () { return router.json; }
  });
  Object.defineProperty(exports, 'matchPath', {
    enumerable: true,
    get: function () { return router.matchPath; }
  });
  Object.defineProperty(exports, 'matchRoutes', {
    enumerable: true,
    get: function () { return router.matchRoutes; }
  });
  Object.defineProperty(exports, 'parsePath', {
    enumerable: true,
    get: function () { return router.parsePath; }
  });
  Object.defineProperty(exports, 'redirect', {
    enumerable: true,
    get: function () { return router.redirect; }
  });
  Object.defineProperty(exports, 'redirectDocument', {
    enumerable: true,
    get: function () { return router.redirectDocument; }
  });
  Object.defineProperty(exports, 'replace', {
    enumerable: true,
    get: function () { return router.replace; }
  });
  Object.defineProperty(exports, 'resolvePath', {
    enumerable: true,
    get: function () { return router.resolvePath; }
  });
  exports.Await = Await;
  exports.MemoryRouter = MemoryRouter;
  exports.Navigate = Navigate;
  exports.Outlet = Outlet;
  exports.Route = Route;
  exports.Router = Router;
  exports.RouterProvider = RouterProvider;
  exports.Routes = Routes;
  exports.UNSAFE_DataRouterContext = DataRouterContext;
  exports.UNSAFE_DataRouterStateContext = DataRouterStateContext;
  exports.UNSAFE_LocationContext = LocationContext;
  exports.UNSAFE_NavigationContext = NavigationContext;
  exports.UNSAFE_RouteContext = RouteContext;
  exports.UNSAFE_mapRouteProperties = mapRouteProperties;
  exports.UNSAFE_useRouteId = useRouteId;
  exports.UNSAFE_useRoutesImpl = useRoutesImpl;
  exports.createMemoryRouter = createMemoryRouter;
  exports.createRoutesFromChildren = createRoutesFromChildren;
  exports.createRoutesFromElements = createRoutesFromChildren;
  exports.renderMatches = renderMatches;
  exports.useActionData = useActionData;
  exports.useAsyncError = useAsyncError;
  exports.useAsyncValue = useAsyncValue;
  exports.useBlocker = useBlocker;
  exports.useHref = useHref;
  exports.useInRouterContext = useInRouterContext;
  exports.useLoaderData = useLoaderData;
  exports.useLocation = useLocation;
  exports.useMatch = useMatch;
  exports.useMatches = useMatches;
  exports.useNavigate = useNavigate;
  exports.useNavigation = useNavigation;
  exports.useNavigationType = useNavigationType;
  exports.useOutlet = useOutlet;
  exports.useOutletContext = useOutletContext;
  exports.useParams = useParams;
  exports.useResolvedPath = useResolvedPath;
  exports.useRevalidator = useRevalidator;
  exports.useRouteError = useRouteError;
  exports.useRouteLoaderData = useRouteLoaderData;
  exports.useRoutes = useRoutes;

  Object.defineProperty(exports, '__esModule', { value: true });

}));


      };
    };
  }
  }
}, {package:"react-router-dom-v5-compat>react-router",file:"node_modules\\react-router\\dist\\umd\\react-router.development.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\react-router\\dist\\umd\\react-router.production.min.js", {"@remix-run/router":"D:\\code\\v\\metamask-extension\\node_modules\\@remix-run\\router\\dist\\router.cjs.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Creact-router%5Cdist%5Cumd%5Creact-router.production.min.js
      return function (require, module, exports) {
/**
 * React Router v6.26.2
 *
 * Copyright (c) Remix Software Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE.md file in the root directory of this source tree.
 *
 * @license MIT
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("react"),require("@remix-run/router")):"function"==typeof define&&define.amd?define(["exports","react","@remix-run/router"],t):t((e="undefined"!=typeof globalThis?globalThis:e||self).ReactRouter={},e.React,e.RemixRouter)}(this,(function(e,t,r){"use strict";function n(e){if(e&&e.__esModule)return e;var t=Object.create(null);return e&&Object.keys(e).forEach((function(r){if("default"!==r){var n=Object.getOwnPropertyDescriptor(e,r);Object.defineProperty(t,r,n.get?n:{enumerable:!0,get:function(){return e[r]}})}})),t.default=e,Object.freeze(t)}var a=n(t);function o(){return o=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var r=arguments[t];for(var n in r)Object.prototype.hasOwnProperty.call(r,n)&&(e[n]=r[n])}return e},o.apply(this,arguments)}const i=a.createContext(null),u=a.createContext(null),l=a.createContext(null),s=a.createContext(null),c=a.createContext(null),d=a.createContext({outlet:null,matches:[],isDataRoute:!1}),p=a.createContext(null);function f(){return null!=a.useContext(c)}function v(){return f()||r.UNSAFE_invariant(!1),a.useContext(c).location}function m(e){a.useContext(s).static||a.useLayoutEffect(e)}function h(){let{isDataRoute:e}=a.useContext(d);return e?function(){let{router:e}=O(U.UseNavigateStable),t=j(N.UseNavigateStable),r=a.useRef(!1);return m((()=>{r.current=!0})),a.useCallback((function(n,a){void 0===a&&(a={}),r.current&&("number"==typeof n?e.navigate(n):e.navigate(n,o({fromRouteId:t},a)))}),[e,t])}():function(){f()||r.UNSAFE_invariant(!1);let e=a.useContext(i),{basename:t,future:n,navigator:o}=a.useContext(s),{matches:u}=a.useContext(d),{pathname:l}=v(),c=JSON.stringify(r.UNSAFE_getResolveToMatches(u,n.v7_relativeSplatPath)),p=a.useRef(!1);return m((()=>{p.current=!0})),a.useCallback((function(n,a){if(void 0===a&&(a={}),!p.current)return;if("number"==typeof n)return void o.go(n);let i=r.resolveTo(n,JSON.parse(c),l,"path"===a.relative);null==e&&"/"!==t&&(i.pathname="/"===i.pathname?t:r.joinPaths([t,i.pathname])),(a.replace?o.replace:o.push)(i,a.state,a)}),[t,o,c,l,e])}()}const g=a.createContext(null);function E(e){let t=a.useContext(d).outlet;return t?a.createElement(g.Provider,{value:e},t):t}function y(e,t){let{relative:n}=void 0===t?{}:t,{future:o}=a.useContext(s),{matches:i}=a.useContext(d),{pathname:u}=v(),l=JSON.stringify(r.UNSAFE_getResolveToMatches(i,o.v7_relativeSplatPath));return a.useMemo((()=>r.resolveTo(e,JSON.parse(l),u,"path"===n)),[e,l,u,n])}function b(e,t){return R(e,t)}function R(e,t,n,i){f()||r.UNSAFE_invariant(!1);let{navigator:u}=a.useContext(s),{matches:l}=a.useContext(d),p=l[l.length-1],m=p?p.params:{};!p||p.pathname;let h=p?p.pathnameBase:"/";p&&p.route;let g,E=v();if(t){var y;let e="string"==typeof t?r.parsePath(t):t;"/"===h||(null==(y=e.pathname)?void 0:y.startsWith(h))||r.UNSAFE_invariant(!1),g=e}else g=E;let b=g.pathname||"/",R=b;if("/"!==h){let e=h.replace(/^\//,"").split("/");R="/"+b.replace(/^\//,"").split("/").slice(e.length).join("/")}let P=r.matchRoutes(e,{pathname:R}),x=S(P&&P.map((e=>Object.assign({},e,{params:Object.assign({},m,e.params),pathname:r.joinPaths([h,u.encodeLocation?u.encodeLocation(e.pathname).pathname:e.pathname]),pathnameBase:"/"===e.pathnameBase?h:r.joinPaths([h,u.encodeLocation?u.encodeLocation(e.pathnameBase).pathname:e.pathnameBase])}))),l,n,i);return t&&x?a.createElement(c.Provider,{value:{location:o({pathname:"/",search:"",hash:"",state:null,key:"default"},g),navigationType:r.Action.Pop}},x):x}function P(){let e=F(),t=r.isRouteErrorResponse(e)?e.status+" "+e.statusText:e instanceof Error?e.message:JSON.stringify(e),n=e instanceof Error?e.stack:null,o={padding:"0.5rem",backgroundColor:"rgba(200,200,200, 0.5)"};return a.createElement(a.Fragment,null,a.createElement("h2",null,"Unexpected Application Error!"),a.createElement("h3",{style:{fontStyle:"italic"}},t),n?a.createElement("pre",{style:o},n):null,null)}const x=a.createElement(P,null);class C extends a.Component{constructor(e){super(e),this.state={location:e.location,revalidation:e.revalidation,error:e.error}}static getDerivedStateFromError(e){return{error:e}}static getDerivedStateFromProps(e,t){return t.location!==e.location||"idle"!==t.revalidation&&"idle"===e.revalidation?{error:e.error,location:e.location,revalidation:e.revalidation}:{error:void 0!==e.error?e.error:t.error,location:t.location,revalidation:e.revalidation||t.revalidation}}componentDidCatch(e,t){console.error("React Router caught the following error during render",e,t)}render(){return void 0!==this.state.error?a.createElement(d.Provider,{value:this.props.routeContext},a.createElement(p.Provider,{value:this.state.error,children:this.props.component})):this.props.children}}function _(e){let{routeContext:t,match:r,children:n}=e,o=a.useContext(i);return o&&o.static&&o.staticContext&&(r.route.errorElement||r.route.ErrorBoundary)&&(o.staticContext._deepestRenderedBoundaryId=r.route.id),a.createElement(d.Provider,{value:t},n)}function S(e,t,n,o){var i;if(void 0===t&&(t=[]),void 0===n&&(n=null),void 0===o&&(o=null),null==e){var u;if(!n)return null;if(n.errors)e=n.matches;else{if(!(null!=(u=o)&&u.v7_partialHydration&&0===t.length&&!n.initialized&&n.matches.length>0))return null;e=n.matches}}let l=e,s=null==(i=n)?void 0:i.errors;if(null!=s){let e=l.findIndex((e=>e.route.id&&void 0!==(null==s?void 0:s[e.route.id])));e>=0||r.UNSAFE_invariant(!1),l=l.slice(0,Math.min(l.length,e+1))}let c=!1,d=-1;if(n&&o&&o.v7_partialHydration)for(let e=0;e<l.length;e++){let t=l[e];if((t.route.HydrateFallback||t.route.hydrateFallbackElement)&&(d=e),t.route.id){let{loaderData:e,errors:r}=n,a=t.route.loader&&void 0===e[t.route.id]&&(!r||void 0===r[t.route.id]);if(t.route.lazy||a){c=!0,l=d>=0?l.slice(0,d+1):[l[0]];break}}}return l.reduceRight(((e,r,o)=>{let i,u=!1,p=null,f=null;var v;n&&(i=s&&r.route.id?s[r.route.id]:void 0,p=r.route.errorElement||x,c&&(d<0&&0===o?(v="route-fallback",!1||B[v]||(B[v]=!0),u=!0,f=null):d===o&&(u=!0,f=r.route.hydrateFallbackElement||null)));let m=t.concat(l.slice(0,o+1)),h=()=>{let t;return t=i?p:u?f:r.route.Component?a.createElement(r.route.Component,null):r.route.element?r.route.element:e,a.createElement(_,{match:r,routeContext:{outlet:e,matches:m,isDataRoute:null!=n},children:t})};return n&&(r.route.ErrorBoundary||r.route.errorElement||0===o)?a.createElement(C,{location:n.location,revalidation:n.revalidation,component:p,error:i,children:h(),routeContext:{outlet:null,matches:m,isDataRoute:!0}}):h()}),null)}var U=function(e){return e.UseBlocker="useBlocker",e.UseRevalidator="useRevalidator",e.UseNavigateStable="useNavigate",e}(U||{}),N=function(e){return e.UseBlocker="useBlocker",e.UseLoaderData="useLoaderData",e.UseActionData="useActionData",e.UseRouteError="useRouteError",e.UseNavigation="useNavigation",e.UseRouteLoaderData="useRouteLoaderData",e.UseMatches="useMatches",e.UseRevalidator="useRevalidator",e.UseNavigateStable="useNavigate",e.UseRouteId="useRouteId",e}(N||{});function O(e){let t=a.useContext(i);return t||r.UNSAFE_invariant(!1),t}function A(e){let t=a.useContext(u);return t||r.UNSAFE_invariant(!1),t}function j(e){let t=function(e){let t=a.useContext(d);return t||r.UNSAFE_invariant(!1),t}(),n=t.matches[t.matches.length-1];return n.route.id||r.UNSAFE_invariant(!1),n.route.id}function F(){var e;let t=a.useContext(p),r=A(N.UseRouteError),n=j(N.UseRouteError);return void 0!==t?t:null==(e=r.errors)?void 0:e[n]}function D(){let e=a.useContext(l);return null==e?void 0:e._data}let k=0;const B={};const L=a.startTransition;function M(e){let{routes:t,future:r,state:n}=e;return R(t,void 0,n,r)}function T(e){r.UNSAFE_invariant(!1)}function I(e){let{basename:t="/",children:n=null,location:i,navigationType:u=r.Action.Pop,navigator:l,static:d=!1,future:p}=e;f()&&r.UNSAFE_invariant(!1);let v=t.replace(/^\/*/,"/"),m=a.useMemo((()=>({basename:v,navigator:l,static:d,future:o({v7_relativeSplatPath:!1},p)})),[v,p,l,d]);"string"==typeof i&&(i=r.parsePath(i));let{pathname:h="/",search:g="",hash:E="",state:y=null,key:b="default"}=i,R=a.useMemo((()=>{let e=r.stripBasename(h,v);return null==e?null:{location:{pathname:e,search:g,hash:E,state:y,key:b},navigationType:u}}),[v,h,g,E,y,b,u]);return null==R?null:a.createElement(s.Provider,{value:m},a.createElement(c.Provider,{children:n,value:R}))}var H=function(e){return e[e.pending=0]="pending",e[e.success=1]="success",e[e.error=2]="error",e}(H||{});const w=new Promise((()=>{}));class z extends a.Component{constructor(e){super(e),this.state={error:null}}static getDerivedStateFromError(e){return{error:e}}componentDidCatch(e,t){console.error("<Await> caught the following error during render",e,t)}render(){let{children:e,errorElement:t,resolve:n}=this.props,o=null,i=H.pending;if(n instanceof Promise)if(this.state.error){i=H.error;let e=this.state.error;o=Promise.reject().catch((()=>{})),Object.defineProperty(o,"_tracked",{get:()=>!0}),Object.defineProperty(o,"_error",{get:()=>e})}else n._tracked?(o=n,i="_error"in o?H.error:"_data"in o?H.success:H.pending):(i=H.pending,Object.defineProperty(n,"_tracked",{get:()=>!0}),o=n.then((e=>Object.defineProperty(n,"_data",{get:()=>e})),(e=>Object.defineProperty(n,"_error",{get:()=>e}))));else i=H.success,o=Promise.resolve(),Object.defineProperty(o,"_tracked",{get:()=>!0}),Object.defineProperty(o,"_data",{get:()=>n});if(i===H.error&&o._error instanceof r.AbortedDeferredError)throw w;if(i===H.error&&!t)throw o._error;if(i===H.error)return a.createElement(l.Provider,{value:o,children:t});if(i===H.success)return a.createElement(l.Provider,{value:o,children:e});throw o}}function J(e){let{children:t}=e,r=D(),n="function"==typeof t?t(r):t;return a.createElement(a.Fragment,null,n)}function q(e,t){void 0===t&&(t=[]);let n=[];return a.Children.forEach(e,((e,o)=>{if(!a.isValidElement(e))return;let i=[...t,o];if(e.type===a.Fragment)return void n.push.apply(n,q(e.props.children,i));e.type!==T&&r.UNSAFE_invariant(!1),e.props.index&&e.props.children&&r.UNSAFE_invariant(!1);let u={id:e.props.id||i.join("-"),caseSensitive:e.props.caseSensitive,element:e.props.element,Component:e.props.Component,index:e.props.index,path:e.props.path,loader:e.props.loader,action:e.props.action,errorElement:e.props.errorElement,ErrorBoundary:e.props.ErrorBoundary,hasErrorBoundary:null!=e.props.ErrorBoundary||null!=e.props.errorElement,shouldRevalidate:e.props.shouldRevalidate,handle:e.props.handle,lazy:e.props.lazy};e.props.children&&(u.children=q(e.props.children,i)),n.push(u)})),n}function V(e){let t={hasErrorBoundary:null!=e.ErrorBoundary||null!=e.errorElement};return e.Component&&Object.assign(t,{element:a.createElement(e.Component),Component:void 0}),e.HydrateFallback&&Object.assign(t,{hydrateFallbackElement:a.createElement(e.HydrateFallback),HydrateFallback:void 0}),e.ErrorBoundary&&Object.assign(t,{errorElement:a.createElement(e.ErrorBoundary),ErrorBoundary:void 0}),t}Object.defineProperty(e,"AbortedDeferredError",{enumerable:!0,get:function(){return r.AbortedDeferredError}}),Object.defineProperty(e,"NavigationType",{enumerable:!0,get:function(){return r.Action}}),Object.defineProperty(e,"createPath",{enumerable:!0,get:function(){return r.createPath}}),Object.defineProperty(e,"defer",{enumerable:!0,get:function(){return r.defer}}),Object.defineProperty(e,"generatePath",{enumerable:!0,get:function(){return r.generatePath}}),Object.defineProperty(e,"isRouteErrorResponse",{enumerable:!0,get:function(){return r.isRouteErrorResponse}}),Object.defineProperty(e,"json",{enumerable:!0,get:function(){return r.json}}),Object.defineProperty(e,"matchPath",{enumerable:!0,get:function(){return r.matchPath}}),Object.defineProperty(e,"matchRoutes",{enumerable:!0,get:function(){return r.matchRoutes}}),Object.defineProperty(e,"parsePath",{enumerable:!0,get:function(){return r.parsePath}}),Object.defineProperty(e,"redirect",{enumerable:!0,get:function(){return r.redirect}}),Object.defineProperty(e,"redirectDocument",{enumerable:!0,get:function(){return r.redirectDocument}}),Object.defineProperty(e,"replace",{enumerable:!0,get:function(){return r.replace}}),Object.defineProperty(e,"resolvePath",{enumerable:!0,get:function(){return r.resolvePath}}),e.Await=function(e){let{children:t,errorElement:r,resolve:n}=e;return a.createElement(z,{resolve:n,errorElement:r},a.createElement(J,null,t))},e.MemoryRouter=function(e){let{basename:t,children:n,initialEntries:o,initialIndex:i,future:u}=e,l=a.useRef();null==l.current&&(l.current=r.createMemoryHistory({initialEntries:o,initialIndex:i,v5Compat:!0}));let s=l.current,[c,d]=a.useState({action:s.action,location:s.location}),{v7_startTransition:p}=u||{},f=a.useCallback((e=>{p&&L?L((()=>d(e))):d(e)}),[d,p]);return a.useLayoutEffect((()=>s.listen(f)),[s,f]),a.createElement(I,{basename:t,children:n,location:c.location,navigationType:c.action,navigator:s,future:u})},e.Navigate=function(e){let{to:t,replace:n,state:o,relative:i}=e;f()||r.UNSAFE_invariant(!1);let{future:u,static:l}=a.useContext(s),{matches:c}=a.useContext(d),{pathname:p}=v(),m=h(),g=r.resolveTo(t,r.UNSAFE_getResolveToMatches(c,u.v7_relativeSplatPath),p,"path"===i),E=JSON.stringify(g);return a.useEffect((()=>m(JSON.parse(E),{replace:n,state:o,relative:i})),[m,E,i,n,o]),null},e.Outlet=function(e){return E(e.context)},e.Route=T,e.Router=I,e.RouterProvider=function(e){let{fallbackElement:t,router:r,future:n}=e,[o,l]=a.useState(r.state),{v7_startTransition:s}=n||{},c=a.useCallback((e=>{s&&L?L((()=>l(e))):l(e)}),[l,s]);a.useLayoutEffect((()=>r.subscribe(c)),[r,c]),a.useEffect((()=>{}),[]);let d=a.useMemo((()=>({createHref:r.createHref,encodeLocation:r.encodeLocation,go:e=>r.navigate(e),push:(e,t,n)=>r.navigate(e,{state:t,preventScrollReset:null==n?void 0:n.preventScrollReset}),replace:(e,t,n)=>r.navigate(e,{replace:!0,state:t,preventScrollReset:null==n?void 0:n.preventScrollReset})})),[r]),p=r.basename||"/",f=a.useMemo((()=>({router:r,navigator:d,static:!1,basename:p})),[r,d,p]);return a.createElement(a.Fragment,null,a.createElement(i.Provider,{value:f},a.createElement(u.Provider,{value:o},a.createElement(I,{basename:p,location:o.location,navigationType:o.historyAction,navigator:d,future:{v7_relativeSplatPath:r.future.v7_relativeSplatPath}},o.initialized||r.future.v7_partialHydration?a.createElement(M,{routes:r.routes,future:r.future,state:o}):t))),null)},e.Routes=function(e){let{children:t,location:r}=e;return b(q(t),r)},e.UNSAFE_DataRouterContext=i,e.UNSAFE_DataRouterStateContext=u,e.UNSAFE_LocationContext=c,e.UNSAFE_NavigationContext=s,e.UNSAFE_RouteContext=d,e.UNSAFE_mapRouteProperties=V,e.UNSAFE_useRouteId=function(){return j(N.UseRouteId)},e.UNSAFE_useRoutesImpl=R,e.createMemoryRouter=function(e,t){return r.createRouter({basename:null==t?void 0:t.basename,future:o({},null==t?void 0:t.future,{v7_prependBasename:!0}),history:r.createMemoryHistory({initialEntries:null==t?void 0:t.initialEntries,initialIndex:null==t?void 0:t.initialIndex}),hydrationData:null==t?void 0:t.hydrationData,routes:e,mapRouteProperties:V,unstable_dataStrategy:null==t?void 0:t.unstable_dataStrategy,unstable_patchRoutesOnNavigation:null==t?void 0:t.unstable_patchRoutesOnNavigation}).initialize()},e.createRoutesFromChildren=q,e.createRoutesFromElements=q,e.renderMatches=function(e){return S(e)},e.useActionData=function(){let e=A(N.UseActionData),t=j(N.UseLoaderData);return e.actionData?e.actionData[t]:void 0},e.useAsyncError=function(){let e=a.useContext(l);return null==e?void 0:e._error},e.useAsyncValue=D,e.useBlocker=function(e){let{router:t,basename:n}=O(U.UseBlocker),i=A(N.UseBlocker),[u,l]=a.useState(""),s=a.useCallback((t=>{if("function"!=typeof e)return!!e;if("/"===n)return e(t);let{currentLocation:a,nextLocation:i,historyAction:u}=t;return e({currentLocation:o({},a,{pathname:r.stripBasename(a.pathname,n)||a.pathname}),nextLocation:o({},i,{pathname:r.stripBasename(i.pathname,n)||i.pathname}),historyAction:u})}),[n,e]);return a.useEffect((()=>{let e=String(++k);return l(e),()=>t.deleteBlocker(e)}),[t]),a.useEffect((()=>{""!==u&&t.getBlocker(u,s)}),[t,u,s]),u&&i.blockers.has(u)?i.blockers.get(u):r.IDLE_BLOCKER},e.useHref=function(e,t){let{relative:n}=void 0===t?{}:t;f()||r.UNSAFE_invariant(!1);let{basename:o,navigator:i}=a.useContext(s),{hash:u,pathname:l,search:c}=y(e,{relative:n}),d=l;return"/"!==o&&(d="/"===l?o:r.joinPaths([o,l])),i.createHref({pathname:d,search:c,hash:u})},e.useInRouterContext=f,e.useLoaderData=function(){let e=A(N.UseLoaderData),t=j(N.UseLoaderData);if(!e.errors||null==e.errors[t])return e.loaderData[t];console.error("You cannot `useLoaderData` in an errorElement (routeId: "+t+")")},e.useLocation=v,e.useMatch=function(e){f()||r.UNSAFE_invariant(!1);let{pathname:t}=v();return a.useMemo((()=>r.matchPath(e,r.UNSAFE_decodePath(t))),[t,e])},e.useMatches=function(){let{matches:e,loaderData:t}=A(N.UseMatches);return a.useMemo((()=>e.map((e=>r.UNSAFE_convertRouteMatchToUiMatch(e,t)))),[e,t])},e.useNavigate=h,e.useNavigation=function(){return A(N.UseNavigation).navigation},e.useNavigationType=function(){return a.useContext(c).navigationType},e.useOutlet=E,e.useOutletContext=function(){return a.useContext(g)},e.useParams=function(){let{matches:e}=a.useContext(d),t=e[e.length-1];return t?t.params:{}},e.useResolvedPath=y,e.useRevalidator=function(){let e=O(U.UseRevalidator),t=A(N.UseRevalidator);return a.useMemo((()=>({revalidate:e.router.revalidate,state:t.revalidation})),[e.router.revalidate,t.revalidation])},e.useRouteError=F,e.useRouteLoaderData=function(e){return A(N.UseRouteLoaderData).loaderData[e]},e.useRoutes=b,Object.defineProperty(e,"__esModule",{value:!0})}));


      };
    };
  }
  }
}, {package:"react-router-dom-v5-compat>react-router",file:"node_modules\\react-router\\dist\\umd\\react-router.production.min.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\react-simple-file-input\\lib\\index.js", {"prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Creact-simple-file-input%5Clib%5Cindex.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var INPUT_FIELD_REF = 'inputField';

var READ_METHOD_ALIASES = {
  buffer: 'readAsArrayBuffer',
  binary: 'readAsBinaryString',
  dataUrl: 'readAsDataURL',
  text: 'readAsText'
};

var SUPPORTED_EVENTS = ['onLoadStart', 'onLoadEnd', 'onLoad', 'onAbort', 'onError'];

var UNSUPPORTED_BY_INPUT = {
  readAs: true,
  abortIf: true,
  cancelIf: true,
  onCancel: true
};

var FileInput = function (_Component) {
  _inherits(FileInput, _Component);

  function FileInput(props, context) {
    _classCallCheck(this, FileInput);

    var _this = _possibleConstructorReturn(this, (FileInput.__proto__ || Object.getPrototypeOf(FileInput)).call(this, props, context));

    _this.handleChange = _this.handleChange.bind(_this);
    return _this;
  }

  _createClass(FileInput, [{
    key: 'componentDidMount',
    value: function componentDidMount() {

      if (window && !window.File || !window.FileReader) {
        console.warn('Browser does not appear to support API react-simple-file-input relies upon');
      }
    }
  }, {
    key: 'handleChange',
    value: function handleChange(event) {
      var _this2 = this;

      var _props = this.props,
          readAs = _props.readAs,
          cancelIf = _props.cancelIf,
          onCancel = _props.onCancel,
          onProgress = _props.onProgress,
          abortIf = _props.abortIf,
          onChange = _props.onChange,
          multiple = _props.multiple;
      var files = event.target.files;


      if (onChange) {
        if (multiple) {
          onChange(files);
        } else {
          onChange(files[0]);
        }
      }

      if (readAs) {
        var _loop = function _loop(i) {
          var file = files[i];

          if (cancelIf && cancelIf(file)) {
            if (onCancel) {
              onCancel(file);
            }

            return {
              v: void 0
            };
          }

          var fileReader = new window.FileReader();

          var _loop2 = function _loop2(_i) {
            var handlerName = SUPPORTED_EVENTS[_i];

            if (_this2.props[handlerName]) {
              fileReader[handlerName.toLowerCase()] = function (fileReadEvent) {
                _this2.props[handlerName](fileReadEvent, file);
              };
            }
          };

          for (var _i = 0; _i < SUPPORTED_EVENTS.length; _i++) {
            _loop2(_i);
          }

          if (typeof abortIf !== 'undefined') {
            fileReader.onprogress = function (event) {

              if (abortIf(event, file)) {
                fileReader.abort();
              } else if (onProgress) {
                onProgress(event, file);
              }
            };
          } else if (onProgress) {
            fileReader.onprogress = onProgress;
          }

          fileReader[READ_METHOD_ALIASES[readAs]](file);
        };

        for (var i = 0; i < files.length; i++) {
          var _ret = _loop(i);

          if ((typeof _ret === 'undefined' ? 'undefined' : _typeof(_ret)) === "object") return _ret.v;
        }
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var inputProps = {};

      for (var property in this.props) {
        if (this.props.hasOwnProperty(property) && !UNSUPPORTED_BY_INPUT[property]) {
          inputProps[property] = this.props[property];
        }
      }

      return _react2.default.createElement('input', _extends({}, inputProps, {
        type: 'file',
        ref: INPUT_FIELD_REF,
        onChange: this.handleChange
      }));
    }
  }]);

  return FileInput;
}(_react.Component);

FileInput.propTypes = {
  id: _propTypes2.default.string,
  className: _propTypes2.default.string,

  multiple: _propTypes2.default.bool,

  readAs: _propTypes2.default.oneOf(Object.keys(READ_METHOD_ALIASES)),

  onLoadStart: _propTypes2.default.func,
  onLoadEnd: _propTypes2.default.func,
  onLoad: _propTypes2.default.func,
  onAbort: _propTypes2.default.func,
  onCancel: _propTypes2.default.func,
  onChange: _propTypes2.default.func,
  onError: _propTypes2.default.func,
  onProgress: _propTypes2.default.func,

  cancelIf: _propTypes2.default.func,
  abortIf: _propTypes2.default.func
};

exports.default = FileInput;
      };
    };
  }
  }
}, {package:"react-simple-file-input",file:"node_modules\\react-simple-file-input\\lib\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\react-tippy\\dist\\react-tippy.js", {"popper.js":"D:\\code\\v\\metamask-extension\\node_modules\\react-tippy\\node_modules\\popper.js\\dist\\umd\\popper.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Creact-tippy%5Cdist%5Creact-tippy.js
      return function (require, module, exports) {
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("react"), require("popper.js"), require("react-dom"));
	else if(typeof define === 'function' && define.amd)
		define("reactTippy", ["react", "popper.js", "react-dom"], factory);
	else if(typeof exports === 'object')
		exports["reactTippy"] = factory(require("react"), require("popper.js"), require("react-dom"));
	else
		root["reactTippy"] = factory(root["React"], root["Popper"], root["ReactDOM"]);
})(this, function(__WEBPACK_EXTERNAL_MODULE_13__, __WEBPACK_EXTERNAL_MODULE_38__, __WEBPACK_EXTERNAL_MODULE_39__) {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;
/******/
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// identity function for calling harmony imports with the correct context
/******/ 	__webpack_require__.i = function(value) { return value; };
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 15);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
var Browser = exports.Browser = {};

if (typeof window !== 'undefined') {
  Browser.SUPPORTED = 'requestAnimationFrame' in window;
  Browser.SUPPORTS_TOUCH = 'ontouchstart' in window;
  Browser.touch = false;
  Browser.dynamicInputDetection = true;
  // Chrome device/touch emulation can make this dynamic
  Browser.iOS = function () {
    return (/iPhone|iPad|iPod/.test(navigator.userAgent) && !window.MSStream
    );
  };
}

/**
* The global storage array which holds all data reference objects
* from every instance
* This allows us to hide tooltips from all instances, finding the ref when
* clicking on the body, and for followCursor
*/
var Store = exports.Store = [];

/**
* Selector constants used for grabbing elements
*/
var Selectors = exports.Selectors = {
  POPPER: '.tippy-popper',
  TOOLTIP: '.tippy-tooltip',
  CONTENT: '.tippy-tooltip-content',
  CIRCLE: '[x-circle]',
  ARROW: '[x-arrow]',
  TOOLTIPPED_EL: '[data-tooltipped]',
  CONTROLLER: '[data-tippy-controller]'
};

/**
* The default settings applied to each instance
*/
var Defaults = exports.Defaults = {
  html: false,
  position: 'top',
  animation: 'shift',
  animateFill: true,
  arrow: false,
  arrowSize: 'regular',
  delay: 0,
  trigger: 'mouseenter focus',
  duration: 350,
  interactive: false,
  interactiveBorder: 2,
  theme: 'dark',
  size: 'regular',
  distance: 10,
  offset: 0,
  hideOnClick: true,
  multiple: false,
  followCursor: false,
  inertia: false,
  flipDuration: 350,
  sticky: false,
  stickyDuration: 200,
  appendTo: function appendTo() {
    return document.body;
  },
  zIndex: 9999,
  touchHold: false,
  performance: false,
  dynamicTitle: false,
  useContext: false,
  reactInstance: undefined,
  popperOptions: {},
  open: undefined,
  onRequestClose: function onRequestClose() {}
};

/**
* The keys of the defaults object for reducing down into a new object
* Used in `getIndividualSettings()`
*/
var DefaultsKeys = exports.DefaultsKeys = Browser.SUPPORTED && Object.keys(Defaults);

/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = prefix;
/**
* Returns the supported prefixed property - only `webkit` is needed, `moz`, `ms` and `o` are obsolete
* @param {String} property
* @return {String} - browser supported prefixed property
*/
function prefix(property) {
  var prefixes = [false, 'webkit'];
  var upperProp = property.charAt(0).toUpperCase() + property.slice(1);

  for (var i = 0; i < prefixes.length; i++) {
    var _prefix = prefixes[i];
    var prefixedProp = _prefix ? '' + _prefix + upperProp : property;
    if (typeof window.document.body.style[prefixedProp] !== 'undefined') {
      return prefixedProp;
    }
  }

  return null;
}

/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = find;
/**
* Ponyfill for Array.prototype.find
* @param {Array} arr
* @param {Function} checkFn
* @return item in the array
*/
function find(arr, checkFn) {
  if (Array.prototype.find) {
    return arr.find(checkFn);
  }

  // use `filter` as fallback
  return arr.filter(checkFn)[0];
}

/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = getCorePlacement;
/**
* Returns the non-shifted placement (e.g., 'bottom-start' => 'bottom')
* @param {String} placement
* @return {String}
*/
function getCorePlacement(placement) {
  return placement.replace(/-.+/, '');
}

/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = closest;

var _matches = __webpack_require__(8);

/**
* Ponyfill to get the closest parent element
* @param {Element} element - child of parent to be returned
* @param {String} parentSelector - selector to match the parent if found
* @return {Element}
*/
function closest(element, parentSelector) {
  var _closest = Element.prototype.closest || function (selector) {
    var el = this;
    while (el) {
      if (_matches.matches.call(el, selector)) {
        return el;
      }
      el = el.parentElement;
    }
  };

  return _closest.call(element, parentSelector);
}

/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = defer;
/**
* Waits until next repaint to execute a fn
* @param {Function} fn
*/
function defer(fn) {
  window.requestAnimationFrame(function () {
    setTimeout(fn, 0);
  });
}

/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = getInnerElements;

var _globals = __webpack_require__(0);

/**
* Returns inner elements of the popper element
* @param {Element} popper
* @return {Object}
*/
function getInnerElements(popper) {
  return {
    tooltip: popper.querySelector(_globals.Selectors.TOOLTIP),
    circle: popper.querySelector(_globals.Selectors.CIRCLE),
    content: popper.querySelector(_globals.Selectors.CONTENT)
  };
}

/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = isVisible;
/**
* Determines if a popper is currently visible
* @param {Element} popper
* @return {Boolean}
*/
function isVisible(popper) {
  return popper.style.visibility === 'visible';
}

/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
function defaultMatchSelector(s) {
  var matches = (this.document || this.ownerDocument).querySelectorAll(s),
      i = matches.length;
  while (--i >= 0 && matches.item(i) !== this) {}
  return i > -1;
}

var matches = exports.matches = typeof window === 'undefined' ? defaultMatchSelector : Element.prototype.matches || Element.prototype.matchesSelector || Element.prototype.webkitMatchesSelector || Element.prototype.mozMatchesSelector || Element.prototype.msMatchesSelector || defaultMatchSelector;

/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = __webpack_require__(13);

var _react2 = _interopRequireDefault(_react);

var _tippy = __webpack_require__(30);

var _tippy2 = _interopRequireDefault(_tippy);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var defaultProps = {
  html: null,
  position: 'top',
  animation: 'shift',
  animateFill: true,
  arrow: false,
  delay: 0,
  hideDelay: 0,
  trigger: 'mouseenter focus',
  duration: 375,
  hideDuration: 375,
  interactive: false,
  interactiveBorder: 2,
  theme: 'dark',
  offset: 0,
  hideOnClick: true,
  multiple: false,
  followCursor: false,
  inertia: false,
  popperOptions: {},
  onShow: function onShow() {},
  onShown: function onShown() {},
  onHide: function onHide() {},
  onHidden: function onHidden() {},
  disabled: false,
  arrowSize: 'regular',
  size: 'regular',
  className: '',
  style: {},
  distance: 10,
  onRequestClose: function onRequestClose() {},
  sticky: false,
  stickyDuration: 200,
  touchHold: false,
  unmountHTMLWhenHide: false
};

var propKeys = Object.keys(defaultProps);

var detectPropsChanged = function detectPropsChanged(props, prevProps) {
  var result = [];
  propKeys.forEach(function (key) {
    if (props[key] !== prevProps[key]) {
      result.push(key);
    }
  });
  return result;
};

var Tooltip = function (_Component) {
  _inherits(Tooltip, _Component);

  function Tooltip(props) {
    _classCallCheck(this, Tooltip);

    var _this = _possibleConstructorReturn(this, (Tooltip.__proto__ || Object.getPrototypeOf(Tooltip)).call(this, props));

    _this.initTippy = _this._initTippy.bind(_this);
    _this.destroyTippy = _this._destroyTippy.bind(_this);
    _this.updateTippy = _this._updateTippy.bind(_this);
    _this.updateReactDom = _this._updateReactDom.bind(_this);
    _this.showTooltip = _this._showTooltip.bind(_this);
    _this.hideTooltip = _this._hideTooltip.bind(_this);
    _this.updateSettings = _this._updateSettings.bind(_this);
    return _this;
  }

  _createClass(Tooltip, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      if (typeof window === 'undefined' || typeof document === 'undefined') {
        return;
      }
      this.initTippy();
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      if (typeof window === 'undefined' || typeof document === 'undefined') {
        return;
      }
      this.destroyTippy();
    }
  }, {
    key: 'componentDidUpdate',
    value: function componentDidUpdate(prevProps) {
      var _this2 = this;

      // enable and disabled
      if (typeof window === 'undefined' || typeof document === 'undefined') {
        return;
      }
      if (this.props.disabled === false && prevProps.disabled === true) {
        this.updateSettings('disabled', false);
        this.destroyTippy();
        this.initTippy();
        return;
      }

      if (this.props.disabled === true && prevProps.disabled === false) {
        this.updateSettings('disabled', true);
        this.destroyTippy();
        return;
      }

      // open
      if (this.props.open === true && !prevProps.open) {
        this.updateSettings('open', true);
        setTimeout(function () {
          _this2.showTooltip();
        }, 0);
      }
      if (this.props.open === false && prevProps.open === true) {
        this.updateSettings('open', false);
        this.hideTooltip();
      }

      if (this.props.html !== prevProps.html) {
        this.updateReactDom();
      }

      // Update content
      if (this.props.title !== prevProps.title) {
        this.updateTippy();
      }

      // update otherProps
      var propChanges = detectPropsChanged(this.props, prevProps);
      propChanges.forEach(function (key) {
        _this2.updateSettings(key, _this2.props[key]);
      });
    }
  }, {
    key: '_showTooltip',
    value: function _showTooltip() {
      if (typeof window === 'undefined' || typeof document === 'undefined') {
        return;
      }
      if (this.tippy) {
        var popper = this.tippy.getPopperElement(this.tooltipDOM);
        this.tippy.show(popper, this.props.duration);
      }
    }
  }, {
    key: '_hideTooltip',
    value: function _hideTooltip() {
      if (typeof window === 'undefined' || typeof document === 'undefined') {
        return;
      }
      if (this.tippy) {
        var popper = this.tippy.getPopperElement(this.tooltipDOM);
        this.tippy.hide(popper, this.props.hideDuration);
      }
    }
  }, {
    key: '_updateSettings',
    value: function _updateSettings(name, value) {
      if (typeof window === 'undefined' || typeof document === 'undefined') {
        return;
      }
      if (this.tippy) {
        var popper = this.tippy.getPopperElement(this.tooltipDOM);
        this.tippy.updateSettings(popper, name, value);
      }
    }
  }, {
    key: '_updateReactDom',
    value: function _updateReactDom() {
      if (typeof window === 'undefined' || typeof document === 'undefined') {
        return;
      }
      if (this.tippy) {
        this.updateSettings('reactDOM', this.props.html);
        var popper = this.tippy.getPopperElement(this.tooltipDOM);
        var isVisible = popper.style.visibility === 'visible' || this.props.open;
        if (isVisible) {
          this.tippy.updateForReact(popper, this.props.html);
        }
      }
    }
  }, {
    key: '_updateTippy',
    value: function _updateTippy() {
      if (typeof window === 'undefined' || typeof document === 'undefined') {
        return;
      }
      if (this.tippy) {
        var popper = this.tippy.getPopperElement(this.tooltipDOM);
        this.tippy.update(popper);
      }
    }
  }, {
    key: '_initTippy',
    value: function _initTippy() {
      if (typeof window === 'undefined' || typeof document === 'undefined') {
        return;
      }
      if (!this.props.disabled) {
        this.tooltipDOM.setAttribute('title', this.props.title);
        this.tippy = (0, _tippy2.default)(this.tooltipDOM, {
          disabled: this.props.disabled,
          position: this.props.position,
          animation: this.props.animation,
          animateFill: this.props.animateFill,
          arrow: this.props.arrow,
          arrowSize: this.props.arrowSize,
          delay: this.props.delay,
          hideDelay: this.props.hideDelay,
          trigger: this.props.trigger,
          duration: this.props.duration,
          hideDuration: this.props.hideDuration,
          interactive: this.props.interactive,
          interactiveBorder: this.props.interactiveBorder,
          theme: this.props.theme,
          offset: this.props.offset,
          hideOnClick: this.props.hideOnClick,
          multiple: this.props.multiple,
          size: this.props.size,
          followCursor: this.props.followCursor,
          inertia: this.props.inertia,
          popperOptions: this.props.popperOptions,
          onShow: this.props.onShow,
          onShown: this.props.onShown,
          onHide: this.props.onHide,
          onHidden: this.props.onHidden,
          distance: this.props.distance,
          reactDOM: this.props.html,
          unmountHTMLWhenHide: this.props.unmountHTMLWhenHide,
          open: this.props.open,
          sticky: this.props.sticky,
          stickyDuration: this.props.stickyDuration,
          touchHold: this.props.touchHold,
          onRequestClose: this.props.onRequestClose,
          useContext: this.props.useContext,
          reactInstance: this.props.useContext ? this : undefined,
          performance: true,
          html: this.props.rawTemplate ? this.props.rawTemplate : undefined
        });
        if (this.props.open) {
          this.showTooltip();
        }
      } else {
        this.tippy = null;
      }
    }
  }, {
    key: '_destroyTippy',
    value: function _destroyTippy() {
      if (typeof window === 'undefined' || typeof document === 'undefined') {
        return;
      }
      if (this.tippy) {
        var popper = this.tippy.getPopperElement(this.tooltipDOM);
        this.updateSettings('open', false);
        this.tippy.hide(popper, 0);
        this.tippy.destroy(popper);
        this.tippy = null;
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var _this3 = this;

      return _react2.default.createElement(
        'div',
        {
          ref: function ref(tooltip) {
            _this3.tooltipDOM = tooltip;
          },
          title: this.props.title,
          className: this.props.className,
          tabIndex: this.props.tabIndex,
          style: _extends({
            display: 'inline'
          }, this.props.style)
        },
        this.props.children
      );
    }
  }]);

  return Tooltip;
}(_react.Component);

Tooltip.defaultProps = defaultProps;

exports.default = Tooltip;

/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = followCursorHandler;

var _globals = __webpack_require__(0);

var _getCorePlacement = __webpack_require__(3);

var _getCorePlacement2 = _interopRequireDefault(_getCorePlacement);

var _find = __webpack_require__(2);

var _find2 = _interopRequireDefault(_find);

var _prefix = __webpack_require__(1);

var _prefix2 = _interopRequireDefault(_prefix);

var _closest = __webpack_require__(4);

var _closest2 = _interopRequireDefault(_closest);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
* Mousemove event listener callback method for follow cursor setting
* @param {MouseEvent} e
*/
function followCursorHandler(e) {
  var _this = this;

  var refData = (0, _find2.default)(_globals.Store, function (refData) {
    return refData.el === _this;
  });

  var popper = refData.popper,
      offset = refData.settings.offset;


  var position = (0, _getCorePlacement2.default)(popper.getAttribute('x-placement'));
  var halfPopperWidth = Math.round(popper.offsetWidth / 2);
  var halfPopperHeight = Math.round(popper.offsetHeight / 2);
  var viewportPadding = 5;
  var pageWidth = document.documentElement.offsetWidth || document.body.offsetWidth;

  var pageX = e.pageX,
      pageY = e.pageY;


  var x = void 0,
      y = void 0;

  switch (position) {
    case 'top':
      x = pageX - halfPopperWidth + offset;
      y = pageY - 2.25 * halfPopperHeight;
      break;
    case 'left':
      x = pageX - 2 * halfPopperWidth - 10;
      y = pageY - halfPopperHeight + offset;
      break;
    case 'right':
      x = pageX + halfPopperHeight;
      y = pageY - halfPopperHeight + offset;
      break;
    case 'bottom':
      x = pageX - halfPopperWidth + offset;
      y = pageY + halfPopperHeight / 1.5;
      break;
  }

  var isRightOverflowing = pageX + viewportPadding + halfPopperWidth + offset > pageWidth;
  var isLeftOverflowing = pageX - viewportPadding - halfPopperWidth + offset < 0;

  // Prevent left/right overflow
  if (position === 'top' || position === 'bottom') {
    if (isRightOverflowing) {
      x = pageWidth - viewportPadding - 2 * halfPopperWidth;
    }

    if (isLeftOverflowing) {
      x = viewportPadding;
    }
  }

  popper.style[(0, _prefix2.default)('transform')] = 'translate3d(' + x + 'px, ' + y + 'px, 0)';
}

/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = getOffsetDistanceInPx;

var _globals = __webpack_require__(0);

/**
* Returns the distance taking into account the default distance due to
* the transform: translate setting in CSS
* @param {Number} distance
* @return {String}
*/
function getOffsetDistanceInPx(distance) {
  return -(distance - _globals.Defaults.distance) + 'px';
}

/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = removeTitle;
/**
* Removes the title from the tooltipped element, setting `data-original-title`
* appropriately
* @param {Element} el
*/
function removeTitle(el) {
  var title = el.getAttribute('title');

  // Only set `data-original-title` attr if there is a title
  if (title) {
    el.setAttribute('data-original-title', title);
  }

  el.removeAttribute('title');
}

/***/ }),
/* 13 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_13__;

/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = __webpack_require__(13);

var _react2 = _interopRequireDefault(_react);

var _component = __webpack_require__(9);

var _component2 = _interopRequireDefault(_component);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var withTooltip = function withTooltip(Component) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  return function (_ref) {
    var props = _objectWithoutProperties(_ref, []);

    return _react2.default.createElement(
      _component2.default,
      options,
      _react2.default.createElement(Component, props)
    );
  };
};

exports.default = withTooltip;

/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withTooltip = exports.Tooltip = undefined;

var _component = __webpack_require__(9);

var _component2 = _interopRequireDefault(_component);

var _hoc = __webpack_require__(14);

var _hoc2 = _interopRequireDefault(_hoc);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.Tooltip = _component2.default;
exports.withTooltip = _hoc2.default;

/***/ }),
/* 16 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = bindEventListeners;

var _globals = __webpack_require__(0);

var _hideAllPoppers = __webpack_require__(25);

var _hideAllPoppers2 = _interopRequireDefault(_hideAllPoppers);

var _closest = __webpack_require__(4);

var _closest2 = _interopRequireDefault(_closest);

var _find = __webpack_require__(2);

var _find2 = _interopRequireDefault(_find);

var _matches = __webpack_require__(8);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
* Adds the needed event listeners
*/
function bindEventListeners() {
  var touchHandler = function touchHandler() {
    _globals.Browser.touch = true;

    if (_globals.Browser.iOS()) {
      document.body.classList.add('tippy-touch');
    }

    if (_globals.Browser.dynamicInputDetection && window.performance) {
      document.addEventListener('mousemove', mousemoveHandler);
    }
  };

  var mousemoveHandler = function () {
    var time = void 0;

    return function () {
      var now = performance.now();

      // Chrome 60+ is 1 mousemove per rAF, use 20ms time difference
      if (now - time < 20) {
        _globals.Browser.touch = false;
        document.removeEventListener('mousemove', mousemoveHandler);
        if (!_globals.Browser.iOS()) {
          document.body.classList.remove('tippy-touch');
        }
      }

      time = now;
    };
  }();

  var clickHandler = function clickHandler(event) {
    // Simulated events dispatched on the document
    if (!(event.target instanceof Element)) {
      return (0, _hideAllPoppers2.default)();
    }

    var el = (0, _closest2.default)(event.target, _globals.Selectors.TOOLTIPPED_EL);
    var popper = (0, _closest2.default)(event.target, _globals.Selectors.POPPER);

    if (popper) {
      var ref = (0, _find2.default)(_globals.Store, function (ref) {
        return ref.popper === popper;
      });
      var interactive = ref.settings.interactive;

      if (interactive) return;
    }

    if (el) {
      var _ref = (0, _find2.default)(_globals.Store, function (ref) {
        return ref.el === el;
      });
      var _ref$settings = _ref.settings,
          hideOnClick = _ref$settings.hideOnClick,
          multiple = _ref$settings.multiple,
          trigger = _ref$settings.trigger;

      // Hide all poppers except the one belonging to the element that was clicked IF
      // `multiple` is false AND they are a touch user, OR
      // `multiple` is false AND it's triggered by a click

      if (!multiple && _globals.Browser.touch || !multiple && trigger.indexOf('click') !== -1) {
        return (0, _hideAllPoppers2.default)(_ref);
      }

      // If hideOnClick is not strictly true or triggered by a click don't hide poppers
      if (hideOnClick !== true || trigger.indexOf('click') !== -1) return;
    }

    // Don't trigger a hide for tippy controllers, and don't needlessly run loop
    if ((0, _closest2.default)(event.target, _globals.Selectors.CONTROLLER) || !document.querySelector(_globals.Selectors.POPPER)) return;

    (0, _hideAllPoppers2.default)();
  };

  var blurHandler = function blurHandler(event) {
    var _document = document,
        el = _document.activeElement;

    if (el && el.blur && _matches.matches.call(el, _globals.Selectors.TOOLTIPPED_EL)) {
      el.blur();
    }
  };

  // Hook events
  document.addEventListener('click', clickHandler);
  document.addEventListener('touchstart', touchHandler);
  window.addEventListener('blur', blurHandler);

  if (!_globals.Browser.SUPPORTS_TOUCH && (navigator.maxTouchPoints > 0 || navigator.msMaxTouchPoints > 0)) {
    document.addEventListener('pointerdown', touchHandler);
  }
}

/***/ }),
/* 17 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createPopperElement;

var _getCorePlacement = __webpack_require__(3);

var _getCorePlacement2 = _interopRequireDefault(_getCorePlacement);

var _getOffsetDistanceInPx = __webpack_require__(11);

var _getOffsetDistanceInPx2 = _interopRequireDefault(_getOffsetDistanceInPx);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
* Creates a popper element then returns it
* @param {Number} id - the popper id
* @param {String} title - the tooltip's `title` attribute
* @param {Object} settings - individual settings
* @return {Element} - the popper element
*/
function createPopperElement(id, title, settings) {
  var position = settings.position,
      distance = settings.distance,
      arrow = settings.arrow,
      animateFill = settings.animateFill,
      inertia = settings.inertia,
      animation = settings.animation,
      arrowSize = settings.arrowSize,
      size = settings.size,
      theme = settings.theme,
      html = settings.html,
      zIndex = settings.zIndex,
      interactive = settings.interactive;


  var popper = document.createElement('div');
  popper.setAttribute('class', 'tippy-popper');
  popper.setAttribute('role', 'tooltip');
  popper.setAttribute('aria-hidden', 'true');
  popper.setAttribute('id', 'tippy-tooltip-' + id);
  popper.style.zIndex = zIndex;

  var tooltip = document.createElement('div');
  tooltip.setAttribute('class', 'tippy-tooltip tippy-tooltip--' + size + ' leave');
  tooltip.setAttribute('data-animation', animation);

  theme.split(' ').forEach(function (t) {
    tooltip.classList.add(t + '-theme');
  });

  if (arrow) {
    // Add an arrow
    var _arrow = document.createElement('div');
    _arrow.setAttribute('class', 'arrow-' + arrowSize);
    _arrow.setAttribute('x-arrow', '');
    tooltip.appendChild(_arrow);
  }

  if (animateFill) {
    // Create animateFill circle element for animation
    tooltip.setAttribute('data-animatefill', '');
    var circle = document.createElement('div');
    circle.setAttribute('class', 'leave');
    circle.setAttribute('x-circle', '');
    tooltip.appendChild(circle);
  }

  if (inertia) {
    // Change transition timing function cubic bezier
    tooltip.setAttribute('data-inertia', '');
  }

  if (interactive) {
    tooltip.setAttribute('data-interactive', '');
  }

  // Tooltip content (text or HTML)
  var content = document.createElement('div');
  content.setAttribute('class', 'tippy-tooltip-content');

  if (html) {
    var templateId = void 0;

    if (html instanceof Element) {
      content.appendChild(html);
      templateId = '#' + html.id || 'tippy-html-template';
    } else {
      content.innerHTML = document.getElementById(html.replace('#', '')).innerHTML;
      templateId = html;
    }

    popper.classList.add('html-template');
    interactive && popper.setAttribute('tabindex', '-1');
    tooltip.setAttribute('data-template-id', templateId);
  } else {
    content.innerHTML = title;
  }

  // Init distance. Further updates are made in the popper instance's `onUpdate()` method
  tooltip.style[(0, _getCorePlacement2.default)(position)] = (0, _getOffsetDistanceInPx2.default)(distance);

  tooltip.appendChild(content);
  popper.appendChild(tooltip);

  return popper;
}

/***/ }),
/* 18 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports.default = createPopperInstance;

var _popper = __webpack_require__(38);

var _popper2 = _interopRequireDefault(_popper);

var _defer = __webpack_require__(5);

var _defer2 = _interopRequireDefault(_defer);

var _prefix = __webpack_require__(1);

var _prefix2 = _interopRequireDefault(_prefix);

var _getCorePlacement = __webpack_require__(3);

var _getCorePlacement2 = _interopRequireDefault(_getCorePlacement);

var _getInnerElements2 = __webpack_require__(6);

var _getInnerElements3 = _interopRequireDefault(_getInnerElements2);

var _getOffsetDistanceInPx = __webpack_require__(11);

var _getOffsetDistanceInPx2 = _interopRequireDefault(_getOffsetDistanceInPx);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
* Creates a new popper instance
* @param {Object} data
* @return {Object} - the popper instance
*/
function createPopperInstance(data) {
  var el = data.el,
      popper = data.popper,
      _data$settings = data.settings,
      position = _data$settings.position,
      popperOptions = _data$settings.popperOptions,
      offset = _data$settings.offset,
      distance = _data$settings.distance,
      flipDuration = _data$settings.flipDuration;

  var _getInnerElements = (0, _getInnerElements3.default)(popper),
      tooltip = _getInnerElements.tooltip;

  var config = _extends({
    placement: position
  }, popperOptions || {}, {
    modifiers: _extends({}, popperOptions ? popperOptions.modifiers : {}, {
      flip: _extends({
        padding: distance + 5 /* 5px from viewport boundary */
      }, popperOptions && popperOptions.modifiers ? popperOptions.modifiers.flip : {}),
      offset: _extends({
        offset: offset
      }, popperOptions && popperOptions.modifiers ? popperOptions.modifiers.offset : {})
    }),
    onUpdate: function onUpdate() {
      var styles = tooltip.style;
      styles.top = '';
      styles.bottom = '';
      styles.left = '';
      styles.right = '';
      styles[(0, _getCorePlacement2.default)(popper.getAttribute('x-placement'))] = (0, _getOffsetDistanceInPx2.default)(distance);
    }
  });

  // Update the popper's position whenever its content changes
  // Not supported in IE10 unless polyfilled
  if (window.MutationObserver) {
    var styles = popper.style;

    var observer = new MutationObserver(function () {
      styles[(0, _prefix2.default)('transitionDuration')] = '0ms';
      data.popperInstance.update();
      (0, _defer2.default)(function () {
        styles[(0, _prefix2.default)('transitionDuration')] = flipDuration + 'ms';
      });
    });

    observer.observe(popper, {
      childList: true,
      subtree: true,
      characterData: true
    });

    data._mutationObserver = observer;
  }

  return new _popper2.default(el, popper, config);
}

/***/ }),
/* 19 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createTooltips;

var _getIndividualSettings = __webpack_require__(24);

var _getIndividualSettings2 = _interopRequireDefault(_getIndividualSettings);

var _createPopperElement = __webpack_require__(17);

var _createPopperElement2 = _interopRequireDefault(_createPopperElement);

var _createTrigger = __webpack_require__(20);

var _createTrigger2 = _interopRequireDefault(_createTrigger);

var _getEventListenerHandlers = __webpack_require__(23);

var _getEventListenerHandlers2 = _interopRequireDefault(_getEventListenerHandlers);

var _evaluateSettings = __webpack_require__(21);

var _evaluateSettings2 = _interopRequireDefault(_evaluateSettings);

var _removeTitle = __webpack_require__(12);

var _removeTitle2 = _interopRequireDefault(_removeTitle);

var _globals = __webpack_require__(0);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var idCounter = 1;

/**
* Creates tooltips for all el elements that match the instance's selector
* @param {Element[]} els
* @return {Object[]} Array of ref data objects
*/
function createTooltips(els) {
  var _this = this;

  return els.reduce(function (a, el) {
    var id = idCounter;

    var settings = (0, _evaluateSettings2.default)(_this.settings.performance ? _this.settings : (0, _getIndividualSettings2.default)(el, _this.settings));

    var html = settings.html,
        trigger = settings.trigger,
        touchHold = settings.touchHold;


    var title = el.getAttribute('title');
    if (!title && !html) return a;

    el.setAttribute('data-tooltipped', '');
    el.setAttribute('aria-describedby', 'tippy-tooltip-' + id);
    (0, _removeTitle2.default)(el);

    var popper = (0, _createPopperElement2.default)(id, title, settings);
    var handlers = _getEventListenerHandlers2.default.call(_this, el, popper, settings);

    var listeners = [];

    trigger.trim().split(' ').forEach(function (event) {
      return listeners = listeners.concat((0, _createTrigger2.default)(event, el, handlers, touchHold));
    });

    a.push({
      id: id,
      el: el,
      popper: popper,
      settings: settings,
      listeners: listeners,
      tippyInstance: _this
    });

    idCounter++;

    return a;
  }, []);
}

/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createTrigger;

var _globals = __webpack_require__(0);

/**
* Creates a trigger
* @param {Object} event - the custom event specified in the `trigger` setting
* @param {Element} el - tooltipped element
* @param {Object} handlers - the handlers for each listener
* @param {Boolean} touchHold
* @return {Array} - array of listener objects
*/
function createTrigger(event, el, handlers, touchHold) {
  var listeners = [];

  if (event === 'manual') return listeners;

  // Enter
  el.addEventListener(event, handlers.handleTrigger);
  listeners.push({
    event: event,
    handler: handlers.handleTrigger
  });

  // Leave
  if (event === 'mouseenter') {
    if (_globals.Browser.SUPPORTS_TOUCH && touchHold) {
      el.addEventListener('touchstart', handlers.handleTrigger);
      listeners.push({
        event: 'touchstart',
        handler: handlers.handleTrigger
      });
      el.addEventListener('touchend', handlers.handleMouseleave);
      listeners.push({
        event: 'touchend',
        handler: handlers.handleMouseleave
      });
    }

    el.addEventListener('mouseleave', handlers.handleMouseleave);
    listeners.push({
      event: 'mouseleave',
      handler: handlers.handleMouseleave
    });
  }

  if (event === 'focus') {
    el.addEventListener('blur', handlers.handleBlur);
    listeners.push({
      event: 'blur',
      handler: handlers.handleBlur
    });
  }

  return listeners;
}

/***/ }),
/* 21 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = evaluateSettings;
/**
* Evaluates/modifies the settings object for appropriate behavior
* @param {Object} settings
* @return {Object} modified/evaluated settings
*/
function evaluateSettings(settings) {
  // animateFill is disabled if an arrow is true
  if (settings.arrow) {
    settings.animateFill = false;
  }

  // reassign appendTo into the result of evaluating appendTo
  // if it's set as a function instead of Element
  if (settings.appendTo && typeof settings.appendTo === 'function') {
    settings.appendTo = settings.appendTo();
  }

  return settings;
}

/***/ }),
/* 22 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = getArrayOfElements;
/**
* Returns an array of elements based on the selector input
* @param {String|Element|Element[]} selector
* @return {Element[]}
*/
function getArrayOfElements(selector) {
  if (selector instanceof Element) {
    return [selector];
  }

  if (Array.isArray(selector)) {
    return selector;
  }

  return [].slice.call(document.querySelectorAll(selector));
}

/***/ }),
/* 23 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = getEventListenerHandlers;

var _globals = __webpack_require__(0);

var _isVisible = __webpack_require__(7);

var _isVisible2 = _interopRequireDefault(_isVisible);

var _closest = __webpack_require__(4);

var _closest2 = _interopRequireDefault(_closest);

var _cursorIsOutsideInteractiveBorder = __webpack_require__(32);

var _cursorIsOutsideInteractiveBorder2 = _interopRequireDefault(_cursorIsOutsideInteractiveBorder);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
* Returns relevant listener callbacks for each ref
* @param {Element} el
* @param {Element} popper
* @param {Object} settings
* @return {Object} - relevant listener handlers
*/
function getEventListenerHandlers(el, popper, settings) {
  var _this = this;

  var position = settings.position,
      delay = settings.delay,
      duration = settings.duration,
      interactive = settings.interactive,
      interactiveBorder = settings.interactiveBorder,
      distance = settings.distance,
      hideOnClick = settings.hideOnClick,
      trigger = settings.trigger,
      touchHold = settings.touchHold,
      touchWait = settings.touchWait;


  var showDelay = void 0,
      hideDelay = void 0;

  var clearTimeouts = function clearTimeouts() {
    clearTimeout(showDelay);
    clearTimeout(hideDelay);
  };

  var _show = function _show() {
    clearTimeouts();

    // Not hidden. For clicking when it also has a `focus` event listener
    if ((0, _isVisible2.default)(popper)) return;

    var _delay = Array.isArray(delay) ? delay[0] : delay;

    if (delay) {
      showDelay = setTimeout(function () {
        return _this.show(popper);
      }, _delay);
    } else {
      _this.show(popper);
    }
  };

  var show = function show(event) {
    return _this.callbacks.wait ? _this.callbacks.wait.call(popper, _show, event) : _show();
  };

  var hide = function hide() {
    clearTimeouts();

    var _delay = Array.isArray(delay) ? delay[1] : delay;

    if (delay) {
      hideDelay = setTimeout(function () {
        return _this.hide(popper);
      }, _delay);
    } else {
      _this.hide(popper);
    }
  };

  var handleTrigger = function handleTrigger(event) {
    var mouseenterTouch = event.type === 'mouseenter' && _globals.Browser.SUPPORTS_TOUCH && _globals.Browser.touch;

    if (mouseenterTouch && touchHold) return;

    // Toggle show/hide when clicking click-triggered tooltips
    var isClick = event.type === 'click';
    var isNotPersistent = hideOnClick !== 'persistent';

    isClick && (0, _isVisible2.default)(popper) && isNotPersistent ? hide() : show(event);

    if (mouseenterTouch && _globals.Browser.iOS() && el.click) {
      el.click();
    }
  };

  var handleMouseleave = function handleMouseleave(event) {

    // Don't fire 'mouseleave', use the 'touchend'
    if (event.type === 'mouseleave' && _globals.Browser.SUPPORTS_TOUCH && _globals.Browser.touch && touchHold) {
      return;
    }

    if (interactive) {
      // Temporarily handle mousemove to check if the mouse left somewhere
      // other than its popper
      var handleMousemove = function handleMousemove(event) {

        var triggerHide = function triggerHide() {
          document.body.removeEventListener('mouseleave', hide);
          document.removeEventListener('mousemove', handleMousemove);
          hide();
        };

        var closestTooltippedEl = (0, _closest2.default)(event.target, _globals.Selectors.TOOLTIPPED_EL);

        var isOverPopper = (0, _closest2.default)(event.target, _globals.Selectors.POPPER) === popper;
        var isOverEl = closestTooltippedEl === el;
        var isClickTriggered = trigger.indexOf('click') !== -1;
        var isOverOtherTooltippedEl = closestTooltippedEl && closestTooltippedEl !== el;

        if (isOverOtherTooltippedEl) {
          return triggerHide();
        }

        if (isOverPopper || isOverEl || isClickTriggered) return;

        if ((0, _cursorIsOutsideInteractiveBorder2.default)(event, popper, settings)) {
          triggerHide();
        }
      };

      document.body.addEventListener('mouseleave', hide);
      document.addEventListener('mousemove', handleMousemove);

      return;
    }

    // If it's not interactive, just hide it
    hide();
  };

  var handleBlur = function handleBlur(event) {
    // Ignore blur on touch devices, if there is no `relatedTarget`, hide
    // If the related target is a popper, ignore
    if (!event.relatedTarget || _globals.Browser.touch) return;
    if ((0, _closest2.default)(event.relatedTarget, _globals.Selectors.POPPER)) return;

    hide();
  };

  return {
    handleTrigger: handleTrigger,
    handleMouseleave: handleMouseleave,
    handleBlur: handleBlur
  };
}

/***/ }),
/* 24 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = getIndividualSettings;

var _globals = __webpack_require__(0);

/**
* Returns an object of settings to override global settings
* @param {Element} el - the tooltipped element
* @param {Object} instanceSettings
* @return {Object} - individual settings
*/
function getIndividualSettings(el, instanceSettings) {
  var settings = _globals.DefaultsKeys.reduce(function (acc, key) {
    var val = el.getAttribute('data-' + key.toLowerCase()) || instanceSettings[key];

    // Convert strings to booleans
    if (val === 'false') val = false;
    if (val === 'true') val = true;

    // Convert number strings to true numbers
    if (isFinite(val) && !isNaN(parseFloat(val))) {
      val = parseFloat(val);
    }

    // Convert array strings to actual arrays
    if (typeof val === 'string' && val.trim().charAt(0) === '[') {
      val = JSON.parse(val);
    }

    acc[key] = val;

    return acc;
  }, {});

  return Object.assign({}, instanceSettings, settings);
}

/***/ }),
/* 25 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = hideAllPoppers;

var _globals = __webpack_require__(0);

/**
* Hides all poppers
* @param {Object} exclude - refData to exclude if needed
*/
function hideAllPoppers(exclude) {
  _globals.Store.forEach(function (refData) {
    var popper = refData.popper,
        tippyInstance = refData.tippyInstance,
        _refData$settings = refData.settings,
        appendTo = _refData$settings.appendTo,
        hideOnClick = _refData$settings.hideOnClick,
        trigger = _refData$settings.trigger;

    // Don't hide already hidden ones

    if (!appendTo.contains(popper)) return;

    // hideOnClick can have the truthy value of 'persistent', so strict check is needed
    var isHideOnClick = hideOnClick === true || trigger.indexOf('focus') !== -1;
    var isNotCurrentRef = !exclude || popper !== exclude.popper;

    if (isHideOnClick && isNotCurrentRef) {
      refData.settings.onRequestClose();
      tippyInstance.hide(popper);
    }
  });
}

/***/ }),
/* 26 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = init;

var _bindEventListeners = __webpack_require__(16);

var _bindEventListeners2 = _interopRequireDefault(_bindEventListeners);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
* To run a single time, once DOM is presumed to be ready
* @return {Boolean} whether the function has run or not
*/
function init() {
  if (init.done) return false;
  init.done = true;

  (0, _bindEventListeners2.default)();

  return true;
}

/***/ }),
/* 27 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = makeSticky;

var _defer = __webpack_require__(5);

var _defer2 = _interopRequireDefault(_defer);

var _prefix = __webpack_require__(1);

var _prefix2 = _interopRequireDefault(_prefix);

var _isVisible = __webpack_require__(7);

var _isVisible2 = _interopRequireDefault(_isVisible);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
* Updates a popper's position on each animation frame to make it stick to a moving element
* @param {Object} refData
*/
function makeSticky(refData) {
  var popper = refData.popper,
      popperInstance = refData.popperInstance,
      stickyDuration = refData.settings.stickyDuration;


  var applyTransitionDuration = function applyTransitionDuration() {
    return popper.style[(0, _prefix2.default)('transitionDuration')] = stickyDuration + 'ms';
  };

  var removeTransitionDuration = function removeTransitionDuration() {
    return popper.style[(0, _prefix2.default)('transitionDuration')] = '';
  };

  var updatePosition = function updatePosition() {
    popperInstance && popperInstance.scheduleUpdate();

    applyTransitionDuration();

    (0, _isVisible2.default)(popper) ? window.requestAnimationFrame(updatePosition) : removeTransitionDuration();
  };

  // Wait until Popper's position has been updated initially
  (0, _defer2.default)(updatePosition);
}

/***/ }),
/* 28 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = mountPopper;

var _globals = __webpack_require__(0);

var _followCursorHandler = __webpack_require__(10);

var _followCursorHandler2 = _interopRequireDefault(_followCursorHandler);

var _createPopperInstance = __webpack_require__(18);

var _createPopperInstance2 = _interopRequireDefault(_createPopperInstance);

var _prefix = __webpack_require__(1);

var _prefix2 = _interopRequireDefault(_prefix);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
* Appends the popper and creates a popper instance if one does not exist
* Also updates its position if need be and enables event listeners
* @param {Object} data -  the element/popper reference data
*/
function mountPopper(data) {
  var el = data.el,
      popper = data.popper,
      _data$settings = data.settings,
      appendTo = _data$settings.appendTo,
      followCursor = _data$settings.followCursor;

  // Already on the DOM

  if (appendTo.contains(popper)) return;

  appendTo.appendChild(popper);

  if (!data.popperInstance) {
    data.popperInstance = (0, _createPopperInstance2.default)(data);
  } else {
    data.popperInstance.update();
    if (!followCursor || _globals.Browser.touch) {
      data.popperInstance.enableEventListeners();
    }
  }

  // Since touch is determined dynamically, followCursor is set on mount
  if (followCursor && !_globals.Browser.touch) {
    el.addEventListener('mousemove', _followCursorHandler2.default);
    data.popperInstance.disableEventListeners();
  }
}

/***/ }),
/* 29 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = onTransitionEnd;

var _globals = __webpack_require__(0);

var _getInnerElements2 = __webpack_require__(6);

var _getInnerElements3 = _interopRequireDefault(_getInnerElements2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
* Prepares the callback functions for `show` and `hide` methods
* @param {Object} data
* @param {Number} duration
* @param {Function} callback - callback function to fire once transitions complete
*/
function onTransitionEnd(data, duration, callback) {
  // Make callback synchronous if duration is 0
  if (!duration) {
    return callback();
  }

  var _getInnerElements = (0, _getInnerElements3.default)(data.popper),
      tooltip = _getInnerElements.tooltip;

  var transitionendFired = false;

  var listenerCallback = function listenerCallback(e) {
    if (e.target === tooltip && !transitionendFired) {
      transitionendFired = true;
      callback();
    }
  };

  // Fire callback upon transition completion
  tooltip.addEventListener('webkitTransitionEnd', listenerCallback);
  tooltip.addEventListener('transitionend', listenerCallback);

  // Fallback: transitionend listener sometimes may not fire
  clearTimeout(data._transitionendTimeout);
  data._transitionendTimeout = setTimeout(function () {
    if (!transitionendFired) {
      callback();
    }
  }, duration);
}

/***/ }),
/* 30 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

/* Utility functions */


/* Core library functions */


var _globals = __webpack_require__(0);

var _reactDom = __webpack_require__(39);

var _reactDom2 = _interopRequireDefault(_reactDom);

var _init = __webpack_require__(26);

var _init2 = _interopRequireDefault(_init);

var _defer = __webpack_require__(5);

var _defer2 = _interopRequireDefault(_defer);

var _prefix = __webpack_require__(1);

var _prefix2 = _interopRequireDefault(_prefix);

var _find = __webpack_require__(2);

var _find2 = _interopRequireDefault(_find);

var _findIndex = __webpack_require__(34);

var _findIndex2 = _interopRequireDefault(_findIndex);

var _removeTitle = __webpack_require__(12);

var _removeTitle2 = _interopRequireDefault(_removeTitle);

var _elementIsInViewport = __webpack_require__(33);

var _elementIsInViewport2 = _interopRequireDefault(_elementIsInViewport);

var _triggerReflow = __webpack_require__(37);

var _triggerReflow2 = _interopRequireDefault(_triggerReflow);

var _modifyClassList = __webpack_require__(35);

var _modifyClassList2 = _interopRequireDefault(_modifyClassList);

var _getInnerElements4 = __webpack_require__(6);

var _getInnerElements5 = _interopRequireDefault(_getInnerElements4);

var _applyTransitionDuration = __webpack_require__(31);

var _applyTransitionDuration2 = _interopRequireDefault(_applyTransitionDuration);

var _isVisible = __webpack_require__(7);

var _isVisible2 = _interopRequireDefault(_isVisible);

var _noop = __webpack_require__(36);

var _noop2 = _interopRequireDefault(_noop);

var _followCursorHandler = __webpack_require__(10);

var _followCursorHandler2 = _interopRequireDefault(_followCursorHandler);

var _getArrayOfElements = __webpack_require__(22);

var _getArrayOfElements2 = _interopRequireDefault(_getArrayOfElements);

var _onTransitionEnd = __webpack_require__(29);

var _onTransitionEnd2 = _interopRequireDefault(_onTransitionEnd);

var _mountPopper = __webpack_require__(28);

var _mountPopper2 = _interopRequireDefault(_mountPopper);

var _makeSticky = __webpack_require__(27);

var _makeSticky2 = _interopRequireDefault(_makeSticky);

var _createTooltips = __webpack_require__(19);

var _createTooltips2 = _interopRequireDefault(_createTooltips);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
* @param {String|Element|Element[]} selector
* @param {Object} settings (optional) - the object of settings to be applied to the instance
*/
var Tippy = function () {
  function Tippy(selector) {
    var settings = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    _classCallCheck(this, Tippy);

    // Use default browser tooltip on unsupported browsers
    if (!_globals.Browser.SUPPORTED) return;

    (0, _init2.default)();

    this.state = {
      destroyed: false
    };

    this.selector = selector;

    this.settings = _extends({}, _globals.Defaults, settings);

    if (settings.show || settings.shown || settings.hide || settings.hidden) {
      console.warn('Callbacks without the `on` prefix are deprecated (with the exception of `wait`).' + ' Use onShow, onShown, onHide, and onHidden instead.');
    }

    this.callbacks = {
      wait: settings.wait,
      show: settings.onShow || settings.show || _noop2.default,
      shown: settings.onShown || settings.shown || _noop2.default,
      hide: settings.onHide || settings.hide || _noop2.default,
      hidden: settings.onHidden || settings.hidden || _noop2.default
    };

    this.store = _createTooltips2.default.call(this, (0, _getArrayOfElements2.default)(selector));
    _globals.Store.push.apply(_globals.Store, this.store);
  }

  /**
  * Returns the reference element's popper element
  * @param {Element} el
  * @return {Element}
  */


  _createClass(Tippy, [{
    key: 'getPopperElement',
    value: function getPopperElement(el) {
      try {
        return (0, _find2.default)(this.store, function (data) {
          return data.el === el;
        }).popper;
      } catch (e) {
        console.error('[getPopperElement]: Element passed as the argument does not exist in the instance');
      }
    }

    /**
    * Returns a popper's reference element
    * @param {Element} popper
    * @return {Element}
    */

  }, {
    key: 'getReferenceElement',
    value: function getReferenceElement(popper) {
      try {
        return (0, _find2.default)(this.store, function (data) {
          return data.popper === popper;
        }).el;
      } catch (e) {
        console.error('[getReferenceElement]: Popper passed as the argument does not exist in the instance');
      }
    }

    /**
    * Returns the reference data object from either the reference element or popper element
    * @param {Element} x (reference element or popper)
    * @return {Object}
    */

  }, {
    key: 'getReferenceData',
    value: function getReferenceData(x) {
      return (0, _find2.default)(this.store, function (data) {
        return data.el === x || data.popper === x;
      });
    }

    /**
    * Update settings
    * @param {DOMElement} - popper
    * @param {string} - name
    * @param {string} - value
    */

  }, {
    key: 'updateSettings',
    value: function updateSettings(popper, name, value) {
      var data = (0, _find2.default)(this.store, function (data) {
        return data.popper === popper;
      });
      var newSettings = _extends({}, data.settings, _defineProperty({}, name, value));
      data.settings = newSettings;
    }
  }, {
    key: 'updateForReact',


    /**
    * Update for React
    * @param {DOMElement} - popper
    * @param {ReactElement} - content
    */
    value: function updateForReact(popper, updatedContent) {
      var tooltipContent = popper.querySelector(_globals.Selectors.CONTENT);
      var data = (0, _find2.default)(this.store, function (data) {
        return data.popper === popper;
      });

      var _data$settings = data.settings,
          useContext = _data$settings.useContext,
          reactInstance = _data$settings.reactInstance;

      if (useContext) {
        _reactDom2.default.unstable_renderSubtreeIntoContainer(data.settings.reactInstance, updatedContent, tooltipContent);
      } else {
        _reactDom2.default.render(updatedContent, tooltipContent);
      }
    }
    /**
    * Shows a popper
    * @param {Element} popper
    * @param {Number} customDuration (optional)
    */

  }, {
    key: 'show',
    value: function show(popper, customDuration) {
      var _this = this;

      if (this.state.destroyed) return;

      var data = (0, _find2.default)(this.store, function (data) {
        return data.popper === popper;
      });

      var _getInnerElements = (0, _getInnerElements5.default)(popper),
          tooltip = _getInnerElements.tooltip,
          circle = _getInnerElements.circle,
          content = _getInnerElements.content;

      if (!document.body.contains(data.el)) {
        this.destroy(popper);
        return;
      }

      this.callbacks.show.call(popper);

      // Custom react
      if (data && data.settings && data.settings.open === false) {
        return;
      }

      if (data.settings.reactDOM) {
        this.updateForReact(popper, data.settings.reactDOM);
      }
      // end: Custom react

      var el = data.el,
          _data$settings2 = data.settings,
          appendTo = _data$settings2.appendTo,
          sticky = _data$settings2.sticky,
          interactive = _data$settings2.interactive,
          followCursor = _data$settings2.followCursor,
          flipDuration = _data$settings2.flipDuration,
          duration = _data$settings2.duration,
          dynamicTitle = _data$settings2.dynamicTitle;


      if (dynamicTitle) {
        var title = el.getAttribute('title');
        if (title) {
          content.innerHTML = title;
          (0, _removeTitle2.default)(el);
        }
      }

      var _duration = customDuration !== undefined ? customDuration : Array.isArray(duration) ? duration[0] : duration;

      // Prevent a transition when popper changes position
      (0, _applyTransitionDuration2.default)([popper, tooltip, circle], 0);

      (0, _mountPopper2.default)(data);

      popper.style.visibility = 'visible';
      popper.setAttribute('aria-hidden', 'false');

      // Wait for popper's position to update
      (0, _defer2.default)(function () {
        // Sometimes the arrow will not be in the correct position, force another update
        if (!followCursor || _globals.Browser.touch) {
          data.popperInstance.update();
          (0, _applyTransitionDuration2.default)([popper], flipDuration);
        }

        // Re-apply transition durations
        (0, _applyTransitionDuration2.default)([tooltip, circle], _duration);

        // Make content fade out a bit faster than the tooltip if `animateFill`
        if (circle) content.style.opacity = 1;

        // Interactive tooltips receive a class of 'active'
        interactive && el.classList.add('active');

        // Update popper's position on every animation frame
        sticky && (0, _makeSticky2.default)(data);

        // Repaint/reflow is required for CSS transition when appending
        (0, _triggerReflow2.default)(tooltip, circle);

        (0, _modifyClassList2.default)([tooltip, circle], function (list) {
          list.contains('tippy-notransition') && list.remove('tippy-notransition');
          list.remove('leave');
          list.add('enter');
        });

        // Wait for transitions to complete
        (0, _onTransitionEnd2.default)(data, _duration, function () {
          if (!(0, _isVisible2.default)(popper) || data._onShownFired) return;

          // Focus interactive tooltips only
          interactive && popper.focus();
          // Remove transitions from tooltip
          tooltip.classList.add('tippy-notransition');
          // Prevents shown() from firing more than once from early transition cancellations
          data._onShownFired = true;

          _this.callbacks.shown.call(popper);
        });
      });
    }

    /**
    * Hides a popper
    * @param {Element} popper
    * @param {Number} customDuration (optional)
    */

  }, {
    key: 'hide',
    value: function hide(popper, customDuration) {
      var _this2 = this;

      if (this.state.destroyed) return;

      this.callbacks.hide.call(popper);

      var data = (0, _find2.default)(this.store, function (data) {
        return data.popper === popper;
      });

      var _getInnerElements2 = (0, _getInnerElements5.default)(popper),
          tooltip = _getInnerElements2.tooltip,
          circle = _getInnerElements2.circle,
          content = _getInnerElements2.content;

      // custom react
      // Prevent hide if open


      if (data.settings.disabled === false && data.settings.open) {
        return;
      }

      var isUnmount = data && data.settings && data.settings.unmountHTMLWhenHide && data.settings.reactDOM;
      // end: custom react

      var el = data.el,
          _data$settings3 = data.settings,
          appendTo = _data$settings3.appendTo,
          sticky = _data$settings3.sticky,
          interactive = _data$settings3.interactive,
          followCursor = _data$settings3.followCursor,
          html = _data$settings3.html,
          trigger = _data$settings3.trigger,
          duration = _data$settings3.duration;


      var _duration = customDuration !== undefined ? customDuration : Array.isArray(duration) ? duration[1] : duration;

      data._onShownFired = false;
      interactive && el.classList.remove('active');

      popper.style.visibility = 'hidden';
      popper.setAttribute('aria-hidden', 'true');

      (0, _applyTransitionDuration2.default)([tooltip, circle, circle ? content : null], _duration);

      if (circle) content.style.opacity = 0;

      (0, _modifyClassList2.default)([tooltip, circle], function (list) {
        list.contains('tippy-tooltip') && list.remove('tippy-notransition');
        list.remove('enter');
        list.add('leave');
      });

      // Re-focus click-triggered html elements
      // and the tooltipped element IS in the viewport (otherwise it causes unsightly scrolling
      // if the tooltip is closed and the element isn't in the viewport anymore)
      if (html && trigger.indexOf('click') !== -1 && (0, _elementIsInViewport2.default)(el)) {
        el.focus();
      }

      // Wait for transitions to complete
      (0, _onTransitionEnd2.default)(data, _duration, function () {
        // `isVisible` is not completely reliable to determine if we shouldn't
        // run the hidden callback, we need to check the computed opacity style.
        // This prevents glitchy behavior of the transition when quickly showing
        // and hiding a tooltip.
        if ((0, _isVisible2.default)(popper) || !appendTo.contains(popper) || getComputedStyle(tooltip).opacity === '1') return;

        el.removeEventListener('mousemove', _followCursorHandler2.default);
        data.popperInstance.disableEventListeners();
        appendTo.removeChild(popper);

        _this2.callbacks.hidden.call(popper);

        // custom react
        if (isUnmount) {
          _reactDom2.default.unmountComponentAtNode(content);
        }
      });
    }

    /**
    * Updates a popper with new content
    * @param {Element} popper
    */

  }, {
    key: 'update',
    value: function update(popper) {
      if (this.state.destroyed) return;

      var data = (0, _find2.default)(this.store, function (data) {
        return data.popper === popper;
      });

      var _getInnerElements3 = (0, _getInnerElements5.default)(popper),
          content = _getInnerElements3.content;

      var el = data.el,
          html = data.settings.html;


      if (html instanceof Element) {
        console.warn('Aborted: update() should not be used if `html` is a DOM element');
        return;
      }

      content.innerHTML = html ? document.getElementById(html.replace('#', '')).innerHTML : el.getAttribute('title') || el.getAttribute('data-original-title');

      if (!html) (0, _removeTitle2.default)(el);
    }

    /**
    * Destroys a popper
    * @param {Element} popper
    * @param {Boolean} _isLast - private param used by destroyAll to optimize
    */

  }, {
    key: 'destroy',
    value: function destroy(popper, _isLast) {
      var _this3 = this;

      if (this.state.destroyed) return;

      var data = (0, _find2.default)(this.store, function (data) {
        return data.popper === popper;
      });

      var el = data.el,
          popperInstance = data.popperInstance,
          listeners = data.listeners,
          _mutationObserver = data._mutationObserver;

      // Ensure the popper is hidden

      if ((0, _isVisible2.default)(popper)) {
        this.hide(popper, 0);
      }

      // Remove Tippy-only event listeners from tooltipped element
      listeners.forEach(function (listener) {
        return el.removeEventListener(listener.event, listener.handler);
      });

      // Restore original title
      el.setAttribute('title', el.getAttribute('data-original-title'));

      el.removeAttribute('data-original-title');
      el.removeAttribute('data-tooltipped');
      el.removeAttribute('aria-describedby');

      popperInstance && popperInstance.destroy();
      _mutationObserver && _mutationObserver.disconnect();

      // Remove from store
      _globals.Store.splice((0, _findIndex2.default)(_globals.Store, function (data) {
        return data.popper === popper;
      }), 1);

      // Ensure filter is called only once
      if (_isLast === undefined || _isLast) {
        this.store = _globals.Store.filter(function (data) {
          return data.tippyInstance === _this3;
        });
      }
    }

    /**
    * Destroys all tooltips created by the instance
    */

  }, {
    key: 'destroyAll',
    value: function destroyAll() {
      var _this4 = this;

      if (this.state.destroyed) return;

      var storeLength = this.store.length;

      this.store.forEach(function (_ref, index) {
        var popper = _ref.popper;

        _this4.destroy(popper, index === storeLength - 1);
      });

      this.store = null;
      this.state.destroyed = true;
    }
  }]);

  return Tippy;
}();

function tippy(selector, settings) {
  return new Tippy(selector, settings);
}

tippy.Browser = _globals.Browser;
tippy.Defaults = _globals.Defaults;
tippy.disableDynamicInputDetection = function () {
  return _globals.Browser.dynamicInputDetection = false;
};
tippy.enableDynamicInputDetection = function () {
  return _globals.Browser.dynamicInputDetection = true;
};

exports.default = tippy;

/***/ }),
/* 31 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = applyTransitionDuration;

var _globals = __webpack_require__(0);

var _prefix = __webpack_require__(1);

var _prefix2 = _interopRequireDefault(_prefix);

var _matches = __webpack_require__(8);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
* Applies the transition duration to each element
* @param {Element[]} els - Array of elements
* @param {Number} duration
*/
function applyTransitionDuration(els, duration) {
  els.forEach(function (el) {
    if (!el) return;

    var isContent = _matches.matches.call(el, _globals.Selectors.CONTENT);

    var _duration = isContent ? Math.round(duration / 1.3) : duration;

    el.style[(0, _prefix2.default)('transitionDuration')] = _duration + 'ms';
  });
}

/***/ }),
/* 32 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = cursorIsOutsideInteractiveBorder;

var _getCorePlacement = __webpack_require__(3);

var _getCorePlacement2 = _interopRequireDefault(_getCorePlacement);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
* Determines if the mouse's cursor is outside the interactive border
* @param {MouseEvent} event
* @param {Element} popper
* @param {Object} settings
* @return {Boolean}
*/
function cursorIsOutsideInteractiveBorder(event, popper, settings) {
  if (!popper.getAttribute('x-placement')) return true;

  var x = event.clientX,
      y = event.clientY;
  var interactiveBorder = settings.interactiveBorder,
      distance = settings.distance;


  var rect = popper.getBoundingClientRect();
  var corePosition = (0, _getCorePlacement2.default)(popper.getAttribute('x-placement'));
  var borderWithDistance = interactiveBorder + distance;

  var exceeds = {
    top: rect.top - y > interactiveBorder,
    bottom: y - rect.bottom > interactiveBorder,
    left: rect.left - x > interactiveBorder,
    right: x - rect.right > interactiveBorder
  };

  switch (corePosition) {
    case 'top':
      exceeds.top = rect.top - y > borderWithDistance;
      break;
    case 'bottom':
      exceeds.bottom = y - rect.bottom > borderWithDistance;
      break;
    case 'left':
      exceeds.left = rect.left - x > borderWithDistance;
      break;
    case 'right':
      exceeds.right = x - rect.right > borderWithDistance;
      break;
  }

  return exceeds.top || exceeds.bottom || exceeds.left || exceeds.right;
}

/***/ }),
/* 33 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = elementIsInViewport;
/**
* Determines if an element is visible in the viewport
* @param {Element} el
* @return {Boolean}
*/
function elementIsInViewport(el) {
  var rect = el.getBoundingClientRect();

  return rect.top >= 0 && rect.left >= 0 && rect.bottom <= (window.innerHeight || document.documentElement.clientHeight) && rect.right <= (window.innerWidth || document.documentElement.clientWidth);
}

/***/ }),
/* 34 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = findIndex;

var _find = __webpack_require__(2);

var _find2 = _interopRequireDefault(_find);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
* Ponyfill for Array.prototype.findIndex
* @param {Array} arr
* @param {Function} checkFn
* @return index of the item in the array
*/
function findIndex(arr, checkFn) {
  if (Array.prototype.findIndex) {
    return arr.findIndex(checkFn);
  }

  // fallback
  return arr.indexOf((0, _find2.default)(arr, checkFn));
}

/***/ }),
/* 35 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = modifyClassList;
/**
* Modifies elements' class lists
* @param {Element[]} els - Array of elements
* @param {Function} callback
*/
function modifyClassList(els, callback) {
  els.forEach(function (el) {
    if (!el) return;
    callback(el.classList);
  });
}

/***/ }),
/* 36 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = noop;
function noop() {}

/***/ }),
/* 37 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = triggerReflow;

var _prefix = __webpack_require__(1);

var _prefix2 = _interopRequireDefault(_prefix);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
* Triggers a document repaint or reflow for CSS transition
* @param {Element} tooltip
* @param {Element} circle
*/
function triggerReflow(tooltip, circle) {
  // Safari needs the specific 'transform' property to be accessed
  circle ? window.getComputedStyle(circle)[(0, _prefix2.default)('transform')] : window.getComputedStyle(tooltip).opacity;
}

/***/ }),
/* 38 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_38__;

/***/ }),
/* 39 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_39__;

/***/ })
/******/ ]);
});

      };
    };
  }
  }
}, {package:"react-tippy",file:"node_modules\\react-tippy\\dist\\react-tippy.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\react-tippy\\node_modules\\popper.js\\dist\\umd\\popper.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Creact-tippy%5Cnode_modules%5Cpopper.js%5Cdist%5Cumd%5Cpopper.js
      return function (require, module, exports) {
/**!
 * @fileOverview Kickass library to create and place poppers near their reference elements.
 * @version 1.15.0
 * @license
 * Copyright (c) 2016 Federico Zivolo and contributors
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
	typeof define === 'function' && define.amd ? define(factory) :
	(global.Popper = factory());
}(this, (function () { 'use strict';

var isBrowser = typeof window !== 'undefined' && typeof document !== 'undefined';

var longerTimeoutBrowsers = ['Edge', 'Trident', 'Firefox'];
var timeoutDuration = 0;
for (var i = 0; i < longerTimeoutBrowsers.length; i += 1) {
  if (isBrowser && navigator.userAgent.indexOf(longerTimeoutBrowsers[i]) >= 0) {
    timeoutDuration = 1;
    break;
  }
}

function microtaskDebounce(fn) {
  var called = false;
  return function () {
    if (called) {
      return;
    }
    called = true;
    window.Promise.resolve().then(function () {
      called = false;
      fn();
    });
  };
}

function taskDebounce(fn) {
  var scheduled = false;
  return function () {
    if (!scheduled) {
      scheduled = true;
      setTimeout(function () {
        scheduled = false;
        fn();
      }, timeoutDuration);
    }
  };
}

var supportsMicroTasks = isBrowser && window.Promise;

/**
* Create a debounced version of a method, that's asynchronously deferred
* but called in the minimum time possible.
*
* @method
* @memberof Popper.Utils
* @argument {Function} fn
* @returns {Function}
*/
var debounce = supportsMicroTasks ? microtaskDebounce : taskDebounce;

/**
 * Check if the given variable is a function
 * @method
 * @memberof Popper.Utils
 * @argument {Any} functionToCheck - variable to check
 * @returns {Boolean} answer to: is a function?
 */
function isFunction(functionToCheck) {
  var getType = {};
  return functionToCheck && getType.toString.call(functionToCheck) === '[object Function]';
}

/**
 * Get CSS computed property of the given element
 * @method
 * @memberof Popper.Utils
 * @argument {Eement} element
 * @argument {String} property
 */
function getStyleComputedProperty(element, property) {
  if (element.nodeType !== 1) {
    return [];
  }
  // NOTE: 1 DOM access here
  var window = element.ownerDocument.defaultView;
  var css = window.getComputedStyle(element, null);
  return property ? css[property] : css;
}

/**
 * Returns the parentNode or the host of the element
 * @method
 * @memberof Popper.Utils
 * @argument {Element} element
 * @returns {Element} parent
 */
function getParentNode(element) {
  if (element.nodeName === 'HTML') {
    return element;
  }
  return element.parentNode || element.host;
}

/**
 * Returns the scrolling parent of the given element
 * @method
 * @memberof Popper.Utils
 * @argument {Element} element
 * @returns {Element} scroll parent
 */
function getScrollParent(element) {
  // Return body, `getScroll` will take care to get the correct `scrollTop` from it
  if (!element) {
    return document.body;
  }

  switch (element.nodeName) {
    case 'HTML':
    case 'BODY':
      return element.ownerDocument.body;
    case '#document':
      return element.body;
  }

  // Firefox want us to check `-x` and `-y` variations as well

  var _getStyleComputedProp = getStyleComputedProperty(element),
      overflow = _getStyleComputedProp.overflow,
      overflowX = _getStyleComputedProp.overflowX,
      overflowY = _getStyleComputedProp.overflowY;

  if (/(auto|scroll|overlay)/.test(overflow + overflowY + overflowX)) {
    return element;
  }

  return getScrollParent(getParentNode(element));
}

var isIE11 = isBrowser && !!(window.MSInputMethodContext && document.documentMode);
var isIE10 = isBrowser && /MSIE 10/.test(navigator.userAgent);

/**
 * Determines if the browser is Internet Explorer
 * @method
 * @memberof Popper.Utils
 * @param {Number} version to check
 * @returns {Boolean} isIE
 */
function isIE(version) {
  if (version === 11) {
    return isIE11;
  }
  if (version === 10) {
    return isIE10;
  }
  return isIE11 || isIE10;
}

/**
 * Returns the offset parent of the given element
 * @method
 * @memberof Popper.Utils
 * @argument {Element} element
 * @returns {Element} offset parent
 */
function getOffsetParent(element) {
  if (!element) {
    return document.documentElement;
  }

  var noOffsetParent = isIE(10) ? document.body : null;

  // NOTE: 1 DOM access here
  var offsetParent = element.offsetParent || null;
  // Skip hidden elements which don't have an offsetParent
  while (offsetParent === noOffsetParent && element.nextElementSibling) {
    offsetParent = (element = element.nextElementSibling).offsetParent;
  }

  var nodeName = offsetParent && offsetParent.nodeName;

  if (!nodeName || nodeName === 'BODY' || nodeName === 'HTML') {
    return element ? element.ownerDocument.documentElement : document.documentElement;
  }

  // .offsetParent will return the closest TH, TD or TABLE in case
  // no offsetParent is present, I hate this job...
  if (['TH', 'TD', 'TABLE'].indexOf(offsetParent.nodeName) !== -1 && getStyleComputedProperty(offsetParent, 'position') === 'static') {
    return getOffsetParent(offsetParent);
  }

  return offsetParent;
}

function isOffsetContainer(element) {
  var nodeName = element.nodeName;

  if (nodeName === 'BODY') {
    return false;
  }
  return nodeName === 'HTML' || getOffsetParent(element.firstElementChild) === element;
}

/**
 * Finds the root node (document, shadowDOM root) of the given element
 * @method
 * @memberof Popper.Utils
 * @argument {Element} node
 * @returns {Element} root node
 */
function getRoot(node) {
  if (node.parentNode !== null) {
    return getRoot(node.parentNode);
  }

  return node;
}

/**
 * Finds the offset parent common to the two provided nodes
 * @method
 * @memberof Popper.Utils
 * @argument {Element} element1
 * @argument {Element} element2
 * @returns {Element} common offset parent
 */
function findCommonOffsetParent(element1, element2) {
  // This check is needed to avoid errors in case one of the elements isn't defined for any reason
  if (!element1 || !element1.nodeType || !element2 || !element2.nodeType) {
    return document.documentElement;
  }

  // Here we make sure to give as "start" the element that comes first in the DOM
  var order = element1.compareDocumentPosition(element2) & Node.DOCUMENT_POSITION_FOLLOWING;
  var start = order ? element1 : element2;
  var end = order ? element2 : element1;

  // Get common ancestor container
  var range = document.createRange();
  range.setStart(start, 0);
  range.setEnd(end, 0);
  var commonAncestorContainer = range.commonAncestorContainer;

  // Both nodes are inside #document

  if (element1 !== commonAncestorContainer && element2 !== commonAncestorContainer || start.contains(end)) {
    if (isOffsetContainer(commonAncestorContainer)) {
      return commonAncestorContainer;
    }

    return getOffsetParent(commonAncestorContainer);
  }

  // one of the nodes is inside shadowDOM, find which one
  var element1root = getRoot(element1);
  if (element1root.host) {
    return findCommonOffsetParent(element1root.host, element2);
  } else {
    return findCommonOffsetParent(element1, getRoot(element2).host);
  }
}

/**
 * Gets the scroll value of the given element in the given side (top and left)
 * @method
 * @memberof Popper.Utils
 * @argument {Element} element
 * @argument {String} side `top` or `left`
 * @returns {number} amount of scrolled pixels
 */
function getScroll(element) {
  var side = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'top';

  var upperSide = side === 'top' ? 'scrollTop' : 'scrollLeft';
  var nodeName = element.nodeName;

  if (nodeName === 'BODY' || nodeName === 'HTML') {
    var html = element.ownerDocument.documentElement;
    var scrollingElement = element.ownerDocument.scrollingElement || html;
    return scrollingElement[upperSide];
  }

  return element[upperSide];
}

/*
 * Sum or subtract the element scroll values (left and top) from a given rect object
 * @method
 * @memberof Popper.Utils
 * @param {Object} rect - Rect object you want to change
 * @param {HTMLElement} element - The element from the function reads the scroll values
 * @param {Boolean} subtract - set to true if you want to subtract the scroll values
 * @return {Object} rect - The modifier rect object
 */
function includeScroll(rect, element) {
  var subtract = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

  var scrollTop = getScroll(element, 'top');
  var scrollLeft = getScroll(element, 'left');
  var modifier = subtract ? -1 : 1;
  rect.top += scrollTop * modifier;
  rect.bottom += scrollTop * modifier;
  rect.left += scrollLeft * modifier;
  rect.right += scrollLeft * modifier;
  return rect;
}

/*
 * Helper to detect borders of a given element
 * @method
 * @memberof Popper.Utils
 * @param {CSSStyleDeclaration} styles
 * Result of `getStyleComputedProperty` on the given element
 * @param {String} axis - `x` or `y`
 * @return {number} borders - The borders size of the given axis
 */

function getBordersSize(styles, axis) {
  var sideA = axis === 'x' ? 'Left' : 'Top';
  var sideB = sideA === 'Left' ? 'Right' : 'Bottom';

  return parseFloat(styles['border' + sideA + 'Width'], 10) + parseFloat(styles['border' + sideB + 'Width'], 10);
}

function getSize(axis, body, html, computedStyle) {
  return Math.max(body['offset' + axis], body['scroll' + axis], html['client' + axis], html['offset' + axis], html['scroll' + axis], isIE(10) ? parseInt(html['offset' + axis]) + parseInt(computedStyle['margin' + (axis === 'Height' ? 'Top' : 'Left')]) + parseInt(computedStyle['margin' + (axis === 'Height' ? 'Bottom' : 'Right')]) : 0);
}

function getWindowSizes(document) {
  var body = document.body;
  var html = document.documentElement;
  var computedStyle = isIE(10) && getComputedStyle(html);

  return {
    height: getSize('Height', body, html, computedStyle),
    width: getSize('Width', body, html, computedStyle)
  };
}

var classCallCheck = function (instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
};

var createClass = function () {
  function defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  return function (Constructor, protoProps, staticProps) {
    if (protoProps) defineProperties(Constructor.prototype, protoProps);
    if (staticProps) defineProperties(Constructor, staticProps);
    return Constructor;
  };
}();





var defineProperty = function (obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }

  return obj;
};

var _extends = Object.assign || function (target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = arguments[i];

    for (var key in source) {
      if (Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key];
      }
    }
  }

  return target;
};

/**
 * Given element offsets, generate an output similar to getBoundingClientRect
 * @method
 * @memberof Popper.Utils
 * @argument {Object} offsets
 * @returns {Object} ClientRect like output
 */
function getClientRect(offsets) {
  return _extends({}, offsets, {
    right: offsets.left + offsets.width,
    bottom: offsets.top + offsets.height
  });
}

/**
 * Get bounding client rect of given element
 * @method
 * @memberof Popper.Utils
 * @param {HTMLElement} element
 * @return {Object} client rect
 */
function getBoundingClientRect(element) {
  var rect = {};

  // IE10 10 FIX: Please, don't ask, the element isn't
  // considered in DOM in some circumstances...
  // This isn't reproducible in IE10 compatibility mode of IE11
  try {
    if (isIE(10)) {
      rect = element.getBoundingClientRect();
      var scrollTop = getScroll(element, 'top');
      var scrollLeft = getScroll(element, 'left');
      rect.top += scrollTop;
      rect.left += scrollLeft;
      rect.bottom += scrollTop;
      rect.right += scrollLeft;
    } else {
      rect = element.getBoundingClientRect();
    }
  } catch (e) {}

  var result = {
    left: rect.left,
    top: rect.top,
    width: rect.right - rect.left,
    height: rect.bottom - rect.top
  };

  // subtract scrollbar size from sizes
  var sizes = element.nodeName === 'HTML' ? getWindowSizes(element.ownerDocument) : {};
  var width = sizes.width || element.clientWidth || result.right - result.left;
  var height = sizes.height || element.clientHeight || result.bottom - result.top;

  var horizScrollbar = element.offsetWidth - width;
  var vertScrollbar = element.offsetHeight - height;

  // if an hypothetical scrollbar is detected, we must be sure it's not a `border`
  // we make this check conditional for performance reasons
  if (horizScrollbar || vertScrollbar) {
    var styles = getStyleComputedProperty(element);
    horizScrollbar -= getBordersSize(styles, 'x');
    vertScrollbar -= getBordersSize(styles, 'y');

    result.width -= horizScrollbar;
    result.height -= vertScrollbar;
  }

  return getClientRect(result);
}

function getOffsetRectRelativeToArbitraryNode(children, parent) {
  var fixedPosition = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

  var isIE10 = isIE(10);
  var isHTML = parent.nodeName === 'HTML';
  var childrenRect = getBoundingClientRect(children);
  var parentRect = getBoundingClientRect(parent);
  var scrollParent = getScrollParent(children);

  var styles = getStyleComputedProperty(parent);
  var borderTopWidth = parseFloat(styles.borderTopWidth, 10);
  var borderLeftWidth = parseFloat(styles.borderLeftWidth, 10);

  // In cases where the parent is fixed, we must ignore negative scroll in offset calc
  if (fixedPosition && isHTML) {
    parentRect.top = Math.max(parentRect.top, 0);
    parentRect.left = Math.max(parentRect.left, 0);
  }
  var offsets = getClientRect({
    top: childrenRect.top - parentRect.top - borderTopWidth,
    left: childrenRect.left - parentRect.left - borderLeftWidth,
    width: childrenRect.width,
    height: childrenRect.height
  });
  offsets.marginTop = 0;
  offsets.marginLeft = 0;

  // Subtract margins of documentElement in case it's being used as parent
  // we do this only on HTML because it's the only element that behaves
  // differently when margins are applied to it. The margins are included in
  // the box of the documentElement, in the other cases not.
  if (!isIE10 && isHTML) {
    var marginTop = parseFloat(styles.marginTop, 10);
    var marginLeft = parseFloat(styles.marginLeft, 10);

    offsets.top -= borderTopWidth - marginTop;
    offsets.bottom -= borderTopWidth - marginTop;
    offsets.left -= borderLeftWidth - marginLeft;
    offsets.right -= borderLeftWidth - marginLeft;

    // Attach marginTop and marginLeft because in some circumstances we may need them
    offsets.marginTop = marginTop;
    offsets.marginLeft = marginLeft;
  }

  if (isIE10 && !fixedPosition ? parent.contains(scrollParent) : parent === scrollParent && scrollParent.nodeName !== 'BODY') {
    offsets = includeScroll(offsets, parent);
  }

  return offsets;
}

function getViewportOffsetRectRelativeToArtbitraryNode(element) {
  var excludeScroll = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

  var html = element.ownerDocument.documentElement;
  var relativeOffset = getOffsetRectRelativeToArbitraryNode(element, html);
  var width = Math.max(html.clientWidth, window.innerWidth || 0);
  var height = Math.max(html.clientHeight, window.innerHeight || 0);

  var scrollTop = !excludeScroll ? getScroll(html) : 0;
  var scrollLeft = !excludeScroll ? getScroll(html, 'left') : 0;

  var offset = {
    top: scrollTop - relativeOffset.top + relativeOffset.marginTop,
    left: scrollLeft - relativeOffset.left + relativeOffset.marginLeft,
    width: width,
    height: height
  };

  return getClientRect(offset);
}

/**
 * Check if the given element is fixed or is inside a fixed parent
 * @method
 * @memberof Popper.Utils
 * @argument {Element} element
 * @argument {Element} customContainer
 * @returns {Boolean} answer to "isFixed?"
 */
function isFixed(element) {
  var nodeName = element.nodeName;
  if (nodeName === 'BODY' || nodeName === 'HTML') {
    return false;
  }
  if (getStyleComputedProperty(element, 'position') === 'fixed') {
    return true;
  }
  var parentNode = getParentNode(element);
  if (!parentNode) {
    return false;
  }
  return isFixed(parentNode);
}

/**
 * Finds the first parent of an element that has a transformed property defined
 * @method
 * @memberof Popper.Utils
 * @argument {Element} element
 * @returns {Element} first transformed parent or documentElement
 */

function getFixedPositionOffsetParent(element) {
  // This check is needed to avoid errors in case one of the elements isn't defined for any reason
  if (!element || !element.parentElement || isIE()) {
    return document.documentElement;
  }
  var el = element.parentElement;
  while (el && getStyleComputedProperty(el, 'transform') === 'none') {
    el = el.parentElement;
  }
  return el || document.documentElement;
}

/**
 * Computed the boundaries limits and return them
 * @method
 * @memberof Popper.Utils
 * @param {HTMLElement} popper
 * @param {HTMLElement} reference
 * @param {number} padding
 * @param {HTMLElement} boundariesElement - Element used to define the boundaries
 * @param {Boolean} fixedPosition - Is in fixed position mode
 * @returns {Object} Coordinates of the boundaries
 */
function getBoundaries(popper, reference, padding, boundariesElement) {
  var fixedPosition = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false;

  // NOTE: 1 DOM access here

  var boundaries = { top: 0, left: 0 };
  var offsetParent = fixedPosition ? getFixedPositionOffsetParent(popper) : findCommonOffsetParent(popper, reference);

  // Handle viewport case
  if (boundariesElement === 'viewport') {
    boundaries = getViewportOffsetRectRelativeToArtbitraryNode(offsetParent, fixedPosition);
  } else {
    // Handle other cases based on DOM element used as boundaries
    var boundariesNode = void 0;
    if (boundariesElement === 'scrollParent') {
      boundariesNode = getScrollParent(getParentNode(reference));
      if (boundariesNode.nodeName === 'BODY') {
        boundariesNode = popper.ownerDocument.documentElement;
      }
    } else if (boundariesElement === 'window') {
      boundariesNode = popper.ownerDocument.documentElement;
    } else {
      boundariesNode = boundariesElement;
    }

    var offsets = getOffsetRectRelativeToArbitraryNode(boundariesNode, offsetParent, fixedPosition);

    // In case of HTML, we need a different computation
    if (boundariesNode.nodeName === 'HTML' && !isFixed(offsetParent)) {
      var _getWindowSizes = getWindowSizes(popper.ownerDocument),
          height = _getWindowSizes.height,
          width = _getWindowSizes.width;

      boundaries.top += offsets.top - offsets.marginTop;
      boundaries.bottom = height + offsets.top;
      boundaries.left += offsets.left - offsets.marginLeft;
      boundaries.right = width + offsets.left;
    } else {
      // for all the other DOM elements, this one is good
      boundaries = offsets;
    }
  }

  // Add paddings
  padding = padding || 0;
  var isPaddingNumber = typeof padding === 'number';
  boundaries.left += isPaddingNumber ? padding : padding.left || 0;
  boundaries.top += isPaddingNumber ? padding : padding.top || 0;
  boundaries.right -= isPaddingNumber ? padding : padding.right || 0;
  boundaries.bottom -= isPaddingNumber ? padding : padding.bottom || 0;

  return boundaries;
}

function getArea(_ref) {
  var width = _ref.width,
      height = _ref.height;

  return width * height;
}

/**
 * Utility used to transform the `auto` placement to the placement with more
 * available space.
 * @method
 * @memberof Popper.Utils
 * @argument {Object} data - The data object generated by update method
 * @argument {Object} options - Modifiers configuration and options
 * @returns {Object} The data object, properly modified
 */
function computeAutoPlacement(placement, refRect, popper, reference, boundariesElement) {
  var padding = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 0;

  if (placement.indexOf('auto') === -1) {
    return placement;
  }

  var boundaries = getBoundaries(popper, reference, padding, boundariesElement);

  var rects = {
    top: {
      width: boundaries.width,
      height: refRect.top - boundaries.top
    },
    right: {
      width: boundaries.right - refRect.right,
      height: boundaries.height
    },
    bottom: {
      width: boundaries.width,
      height: boundaries.bottom - refRect.bottom
    },
    left: {
      width: refRect.left - boundaries.left,
      height: boundaries.height
    }
  };

  var sortedAreas = Object.keys(rects).map(function (key) {
    return _extends({
      key: key
    }, rects[key], {
      area: getArea(rects[key])
    });
  }).sort(function (a, b) {
    return b.area - a.area;
  });

  var filteredAreas = sortedAreas.filter(function (_ref2) {
    var width = _ref2.width,
        height = _ref2.height;
    return width >= popper.clientWidth && height >= popper.clientHeight;
  });

  var computedPlacement = filteredAreas.length > 0 ? filteredAreas[0].key : sortedAreas[0].key;

  var variation = placement.split('-')[1];

  return computedPlacement + (variation ? '-' + variation : '');
}

/**
 * Get offsets to the reference element
 * @method
 * @memberof Popper.Utils
 * @param {Object} state
 * @param {Element} popper - the popper element
 * @param {Element} reference - the reference element (the popper will be relative to this)
 * @param {Element} fixedPosition - is in fixed position mode
 * @returns {Object} An object containing the offsets which will be applied to the popper
 */
function getReferenceOffsets(state, popper, reference) {
  var fixedPosition = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;

  var commonOffsetParent = fixedPosition ? getFixedPositionOffsetParent(popper) : findCommonOffsetParent(popper, reference);
  return getOffsetRectRelativeToArbitraryNode(reference, commonOffsetParent, fixedPosition);
}

/**
 * Get the outer sizes of the given element (offset size + margins)
 * @method
 * @memberof Popper.Utils
 * @argument {Element} element
 * @returns {Object} object containing width and height properties
 */
function getOuterSizes(element) {
  var window = element.ownerDocument.defaultView;
  var styles = window.getComputedStyle(element);
  var x = parseFloat(styles.marginTop || 0) + parseFloat(styles.marginBottom || 0);
  var y = parseFloat(styles.marginLeft || 0) + parseFloat(styles.marginRight || 0);
  var result = {
    width: element.offsetWidth + y,
    height: element.offsetHeight + x
  };
  return result;
}

/**
 * Get the opposite placement of the given one
 * @method
 * @memberof Popper.Utils
 * @argument {String} placement
 * @returns {String} flipped placement
 */
function getOppositePlacement(placement) {
  var hash = { left: 'right', right: 'left', bottom: 'top', top: 'bottom' };
  return placement.replace(/left|right|bottom|top/g, function (matched) {
    return hash[matched];
  });
}

/**
 * Get offsets to the popper
 * @method
 * @memberof Popper.Utils
 * @param {Object} position - CSS position the Popper will get applied
 * @param {HTMLElement} popper - the popper element
 * @param {Object} referenceOffsets - the reference offsets (the popper will be relative to this)
 * @param {String} placement - one of the valid placement options
 * @returns {Object} popperOffsets - An object containing the offsets which will be applied to the popper
 */
function getPopperOffsets(popper, referenceOffsets, placement) {
  placement = placement.split('-')[0];

  // Get popper node sizes
  var popperRect = getOuterSizes(popper);

  // Add position, width and height to our offsets object
  var popperOffsets = {
    width: popperRect.width,
    height: popperRect.height
  };

  // depending by the popper placement we have to compute its offsets slightly differently
  var isHoriz = ['right', 'left'].indexOf(placement) !== -1;
  var mainSide = isHoriz ? 'top' : 'left';
  var secondarySide = isHoriz ? 'left' : 'top';
  var measurement = isHoriz ? 'height' : 'width';
  var secondaryMeasurement = !isHoriz ? 'height' : 'width';

  popperOffsets[mainSide] = referenceOffsets[mainSide] + referenceOffsets[measurement] / 2 - popperRect[measurement] / 2;
  if (placement === secondarySide) {
    popperOffsets[secondarySide] = referenceOffsets[secondarySide] - popperRect[secondaryMeasurement];
  } else {
    popperOffsets[secondarySide] = referenceOffsets[getOppositePlacement(secondarySide)];
  }

  return popperOffsets;
}

/**
 * Mimics the `find` method of Array
 * @method
 * @memberof Popper.Utils
 * @argument {Array} arr
 * @argument prop
 * @argument value
 * @returns index or -1
 */
function find(arr, check) {
  // use native find if supported
  if (Array.prototype.find) {
    return arr.find(check);
  }

  // use `filter` to obtain the same behavior of `find`
  return arr.filter(check)[0];
}

/**
 * Return the index of the matching object
 * @method
 * @memberof Popper.Utils
 * @argument {Array} arr
 * @argument prop
 * @argument value
 * @returns index or -1
 */
function findIndex(arr, prop, value) {
  // use native findIndex if supported
  if (Array.prototype.findIndex) {
    return arr.findIndex(function (cur) {
      return cur[prop] === value;
    });
  }

  // use `find` + `indexOf` if `findIndex` isn't supported
  var match = find(arr, function (obj) {
    return obj[prop] === value;
  });
  return arr.indexOf(match);
}

/**
 * Loop trough the list of modifiers and run them in order,
 * each of them will then edit the data object.
 * @method
 * @memberof Popper.Utils
 * @param {dataObject} data
 * @param {Array} modifiers
 * @param {String} ends - Optional modifier name used as stopper
 * @returns {dataObject}
 */
function runModifiers(modifiers, data, ends) {
  var modifiersToRun = ends === undefined ? modifiers : modifiers.slice(0, findIndex(modifiers, 'name', ends));

  modifiersToRun.forEach(function (modifier) {
    if (modifier['function']) {
      // eslint-disable-line dot-notation
      console.warn('`modifier.function` is deprecated, use `modifier.fn`!');
    }
    var fn = modifier['function'] || modifier.fn; // eslint-disable-line dot-notation
    if (modifier.enabled && isFunction(fn)) {
      // Add properties to offsets to make them a complete clientRect object
      // we do this before each modifier to make sure the previous one doesn't
      // mess with these values
      data.offsets.popper = getClientRect(data.offsets.popper);
      data.offsets.reference = getClientRect(data.offsets.reference);

      data = fn(data, modifier);
    }
  });

  return data;
}

/**
 * Updates the position of the popper, computing the new offsets and applying
 * the new style.<br />
 * Prefer `scheduleUpdate` over `update` because of performance reasons.
 * @method
 * @memberof Popper
 */
function update() {
  // if popper is destroyed, don't perform any further update
  if (this.state.isDestroyed) {
    return;
  }

  var data = {
    instance: this,
    styles: {},
    arrowStyles: {},
    attributes: {},
    flipped: false,
    offsets: {}
  };

  // compute reference element offsets
  data.offsets.reference = getReferenceOffsets(this.state, this.popper, this.reference, this.options.positionFixed);

  // compute auto placement, store placement inside the data object,
  // modifiers will be able to edit `placement` if needed
  // and refer to originalPlacement to know the original value
  data.placement = computeAutoPlacement(this.options.placement, data.offsets.reference, this.popper, this.reference, this.options.modifiers.flip.boundariesElement, this.options.modifiers.flip.padding);

  // store the computed placement inside `originalPlacement`
  data.originalPlacement = data.placement;

  data.positionFixed = this.options.positionFixed;

  // compute the popper offsets
  data.offsets.popper = getPopperOffsets(this.popper, data.offsets.reference, data.placement);

  data.offsets.popper.position = this.options.positionFixed ? 'fixed' : 'absolute';

  // run the modifiers
  data = runModifiers(this.modifiers, data);

  // the first `update` will call `onCreate` callback
  // the other ones will call `onUpdate` callback
  if (!this.state.isCreated) {
    this.state.isCreated = true;
    this.options.onCreate(data);
  } else {
    this.options.onUpdate(data);
  }
}

/**
 * Helper used to know if the given modifier is enabled.
 * @method
 * @memberof Popper.Utils
 * @returns {Boolean}
 */
function isModifierEnabled(modifiers, modifierName) {
  return modifiers.some(function (_ref) {
    var name = _ref.name,
        enabled = _ref.enabled;
    return enabled && name === modifierName;
  });
}

/**
 * Get the prefixed supported property name
 * @method
 * @memberof Popper.Utils
 * @argument {String} property (camelCase)
 * @returns {String} prefixed property (camelCase or PascalCase, depending on the vendor prefix)
 */
function getSupportedPropertyName(property) {
  var prefixes = [false, 'ms', 'Webkit', 'Moz', 'O'];
  var upperProp = property.charAt(0).toUpperCase() + property.slice(1);

  for (var i = 0; i < prefixes.length; i++) {
    var prefix = prefixes[i];
    var toCheck = prefix ? '' + prefix + upperProp : property;
    if (typeof document.body.style[toCheck] !== 'undefined') {
      return toCheck;
    }
  }
  return null;
}

/**
 * Destroys the popper.
 * @method
 * @memberof Popper
 */
function destroy() {
  this.state.isDestroyed = true;

  // touch DOM only if `applyStyle` modifier is enabled
  if (isModifierEnabled(this.modifiers, 'applyStyle')) {
    this.popper.removeAttribute('x-placement');
    this.popper.style.position = '';
    this.popper.style.top = '';
    this.popper.style.left = '';
    this.popper.style.right = '';
    this.popper.style.bottom = '';
    this.popper.style.willChange = '';
    this.popper.style[getSupportedPropertyName('transform')] = '';
  }

  this.disableEventListeners();

  // remove the popper if user explicity asked for the deletion on destroy
  // do not use `remove` because IE11 doesn't support it
  if (this.options.removeOnDestroy) {
    this.popper.parentNode.removeChild(this.popper);
  }
  return this;
}

/**
 * Get the window associated with the element
 * @argument {Element} element
 * @returns {Window}
 */
function getWindow(element) {
  var ownerDocument = element.ownerDocument;
  return ownerDocument ? ownerDocument.defaultView : window;
}

function attachToScrollParents(scrollParent, event, callback, scrollParents) {
  var isBody = scrollParent.nodeName === 'BODY';
  var target = isBody ? scrollParent.ownerDocument.defaultView : scrollParent;
  target.addEventListener(event, callback, { passive: true });

  if (!isBody) {
    attachToScrollParents(getScrollParent(target.parentNode), event, callback, scrollParents);
  }
  scrollParents.push(target);
}

/**
 * Setup needed event listeners used to update the popper position
 * @method
 * @memberof Popper.Utils
 * @private
 */
function setupEventListeners(reference, options, state, updateBound) {
  // Resize event listener on window
  state.updateBound = updateBound;
  getWindow(reference).addEventListener('resize', state.updateBound, { passive: true });

  // Scroll event listener on scroll parents
  var scrollElement = getScrollParent(reference);
  attachToScrollParents(scrollElement, 'scroll', state.updateBound, state.scrollParents);
  state.scrollElement = scrollElement;
  state.eventsEnabled = true;

  return state;
}

/**
 * It will add resize/scroll events and start recalculating
 * position of the popper element when they are triggered.
 * @method
 * @memberof Popper
 */
function enableEventListeners() {
  if (!this.state.eventsEnabled) {
    this.state = setupEventListeners(this.reference, this.options, this.state, this.scheduleUpdate);
  }
}

/**
 * Remove event listeners used to update the popper position
 * @method
 * @memberof Popper.Utils
 * @private
 */
function removeEventListeners(reference, state) {
  // Remove resize event listener on window
  getWindow(reference).removeEventListener('resize', state.updateBound);

  // Remove scroll event listener on scroll parents
  state.scrollParents.forEach(function (target) {
    target.removeEventListener('scroll', state.updateBound);
  });

  // Reset state
  state.updateBound = null;
  state.scrollParents = [];
  state.scrollElement = null;
  state.eventsEnabled = false;
  return state;
}

/**
 * It will remove resize/scroll events and won't recalculate popper position
 * when they are triggered. It also won't trigger `onUpdate` callback anymore,
 * unless you call `update` method manually.
 * @method
 * @memberof Popper
 */
function disableEventListeners() {
  if (this.state.eventsEnabled) {
    cancelAnimationFrame(this.scheduleUpdate);
    this.state = removeEventListeners(this.reference, this.state);
  }
}

/**
 * Tells if a given input is a number
 * @method
 * @memberof Popper.Utils
 * @param {*} input to check
 * @return {Boolean}
 */
function isNumeric(n) {
  return n !== '' && !isNaN(parseFloat(n)) && isFinite(n);
}

/**
 * Set the style to the given popper
 * @method
 * @memberof Popper.Utils
 * @argument {Element} element - Element to apply the style to
 * @argument {Object} styles
 * Object with a list of properties and values which will be applied to the element
 */
function setStyles(element, styles) {
  Object.keys(styles).forEach(function (prop) {
    var unit = '';
    // add unit if the value is numeric and is one of the following
    if (['width', 'height', 'top', 'right', 'bottom', 'left'].indexOf(prop) !== -1 && isNumeric(styles[prop])) {
      unit = 'px';
    }
    element.style[prop] = styles[prop] + unit;
  });
}

/**
 * Set the attributes to the given popper
 * @method
 * @memberof Popper.Utils
 * @argument {Element} element - Element to apply the attributes to
 * @argument {Object} styles
 * Object with a list of properties and values which will be applied to the element
 */
function setAttributes(element, attributes) {
  Object.keys(attributes).forEach(function (prop) {
    var value = attributes[prop];
    if (value !== false) {
      element.setAttribute(prop, attributes[prop]);
    } else {
      element.removeAttribute(prop);
    }
  });
}

/**
 * @function
 * @memberof Modifiers
 * @argument {Object} data - The data object generated by `update` method
 * @argument {Object} data.styles - List of style properties - values to apply to popper element
 * @argument {Object} data.attributes - List of attribute properties - values to apply to popper element
 * @argument {Object} options - Modifiers configuration and options
 * @returns {Object} The same data object
 */
function applyStyle(data) {
  // any property present in `data.styles` will be applied to the popper,
  // in this way we can make the 3rd party modifiers add custom styles to it
  // Be aware, modifiers could override the properties defined in the previous
  // lines of this modifier!
  setStyles(data.instance.popper, data.styles);

  // any property present in `data.attributes` will be applied to the popper,
  // they will be set as HTML attributes of the element
  setAttributes(data.instance.popper, data.attributes);

  // if arrowElement is defined and arrowStyles has some properties
  if (data.arrowElement && Object.keys(data.arrowStyles).length) {
    setStyles(data.arrowElement, data.arrowStyles);
  }

  return data;
}

/**
 * Set the x-placement attribute before everything else because it could be used
 * to add margins to the popper margins needs to be calculated to get the
 * correct popper offsets.
 * @method
 * @memberof Popper.modifiers
 * @param {HTMLElement} reference - The reference element used to position the popper
 * @param {HTMLElement} popper - The HTML element used as popper
 * @param {Object} options - Popper.js options
 */
function applyStyleOnLoad(reference, popper, options, modifierOptions, state) {
  // compute reference element offsets
  var referenceOffsets = getReferenceOffsets(state, popper, reference, options.positionFixed);

  // compute auto placement, store placement inside the data object,
  // modifiers will be able to edit `placement` if needed
  // and refer to originalPlacement to know the original value
  var placement = computeAutoPlacement(options.placement, referenceOffsets, popper, reference, options.modifiers.flip.boundariesElement, options.modifiers.flip.padding);

  popper.setAttribute('x-placement', placement);

  // Apply `position` to popper before anything else because
  // without the position applied we can't guarantee correct computations
  setStyles(popper, { position: options.positionFixed ? 'fixed' : 'absolute' });

  return options;
}

/**
 * @function
 * @memberof Popper.Utils
 * @argument {Object} data - The data object generated by `update` method
 * @argument {Boolean} shouldRound - If the offsets should be rounded at all
 * @returns {Object} The popper's position offsets rounded
 *
 * The tale of pixel-perfect positioning. It's still not 100% perfect, but as
 * good as it can be within reason.
 * Discussion here: https://github.com/FezVrasta/popper.js/pull/715
 *
 * Low DPI screens cause a popper to be blurry if not using full pixels (Safari
 * as well on High DPI screens).
 *
 * Firefox prefers no rounding for positioning and does not have blurriness on
 * high DPI screens.
 *
 * Only horizontal placement and left/right values need to be considered.
 */
function getRoundedOffsets(data, shouldRound) {
  var _data$offsets = data.offsets,
      popper = _data$offsets.popper,
      reference = _data$offsets.reference;
  var round = Math.round,
      floor = Math.floor;

  var noRound = function noRound(v) {
    return v;
  };

  var referenceWidth = round(reference.width);
  var popperWidth = round(popper.width);

  var isVertical = ['left', 'right'].indexOf(data.placement) !== -1;
  var isVariation = data.placement.indexOf('-') !== -1;
  var sameWidthParity = referenceWidth % 2 === popperWidth % 2;
  var bothOddWidth = referenceWidth % 2 === 1 && popperWidth % 2 === 1;

  var horizontalToInteger = !shouldRound ? noRound : isVertical || isVariation || sameWidthParity ? round : floor;
  var verticalToInteger = !shouldRound ? noRound : round;

  return {
    left: horizontalToInteger(bothOddWidth && !isVariation && shouldRound ? popper.left - 1 : popper.left),
    top: verticalToInteger(popper.top),
    bottom: verticalToInteger(popper.bottom),
    right: horizontalToInteger(popper.right)
  };
}

var isFirefox = isBrowser && /Firefox/i.test(navigator.userAgent);

/**
 * @function
 * @memberof Modifiers
 * @argument {Object} data - The data object generated by `update` method
 * @argument {Object} options - Modifiers configuration and options
 * @returns {Object} The data object, properly modified
 */
function computeStyle(data, options) {
  var x = options.x,
      y = options.y;
  var popper = data.offsets.popper;

  // Remove this legacy support in Popper.js v2

  var legacyGpuAccelerationOption = find(data.instance.modifiers, function (modifier) {
    return modifier.name === 'applyStyle';
  }).gpuAcceleration;
  if (legacyGpuAccelerationOption !== undefined) {
    console.warn('WARNING: `gpuAcceleration` option moved to `computeStyle` modifier and will not be supported in future versions of Popper.js!');
  }
  var gpuAcceleration = legacyGpuAccelerationOption !== undefined ? legacyGpuAccelerationOption : options.gpuAcceleration;

  var offsetParent = getOffsetParent(data.instance.popper);
  var offsetParentRect = getBoundingClientRect(offsetParent);

  // Styles
  var styles = {
    position: popper.position
  };

  var offsets = getRoundedOffsets(data, window.devicePixelRatio < 2 || !isFirefox);

  var sideA = x === 'bottom' ? 'top' : 'bottom';
  var sideB = y === 'right' ? 'left' : 'right';

  // if gpuAcceleration is set to `true` and transform is supported,
  //  we use `translate3d` to apply the position to the popper we
  // automatically use the supported prefixed version if needed
  var prefixedProperty = getSupportedPropertyName('transform');

  // now, let's make a step back and look at this code closely (wtf?)
  // If the content of the popper grows once it's been positioned, it
  // may happen that the popper gets misplaced because of the new content
  // overflowing its reference element
  // To avoid this problem, we provide two options (x and y), which allow
  // the consumer to define the offset origin.
  // If we position a popper on top of a reference element, we can set
  // `x` to `top` to make the popper grow towards its top instead of
  // its bottom.
  var left = void 0,
      top = void 0;
  if (sideA === 'bottom') {
    // when offsetParent is <html> the positioning is relative to the bottom of the screen (excluding the scrollbar)
    // and not the bottom of the html element
    if (offsetParent.nodeName === 'HTML') {
      top = -offsetParent.clientHeight + offsets.bottom;
    } else {
      top = -offsetParentRect.height + offsets.bottom;
    }
  } else {
    top = offsets.top;
  }
  if (sideB === 'right') {
    if (offsetParent.nodeName === 'HTML') {
      left = -offsetParent.clientWidth + offsets.right;
    } else {
      left = -offsetParentRect.width + offsets.right;
    }
  } else {
    left = offsets.left;
  }
  if (gpuAcceleration && prefixedProperty) {
    styles[prefixedProperty] = 'translate3d(' + left + 'px, ' + top + 'px, 0)';
    styles[sideA] = 0;
    styles[sideB] = 0;
    styles.willChange = 'transform';
  } else {
    // othwerise, we use the standard `top`, `left`, `bottom` and `right` properties
    var invertTop = sideA === 'bottom' ? -1 : 1;
    var invertLeft = sideB === 'right' ? -1 : 1;
    styles[sideA] = top * invertTop;
    styles[sideB] = left * invertLeft;
    styles.willChange = sideA + ', ' + sideB;
  }

  // Attributes
  var attributes = {
    'x-placement': data.placement
  };

  // Update `data` attributes, styles and arrowStyles
  data.attributes = _extends({}, attributes, data.attributes);
  data.styles = _extends({}, styles, data.styles);
  data.arrowStyles = _extends({}, data.offsets.arrow, data.arrowStyles);

  return data;
}

/**
 * Helper used to know if the given modifier depends from another one.<br />
 * It checks if the needed modifier is listed and enabled.
 * @method
 * @memberof Popper.Utils
 * @param {Array} modifiers - list of modifiers
 * @param {String} requestingName - name of requesting modifier
 * @param {String} requestedName - name of requested modifier
 * @returns {Boolean}
 */
function isModifierRequired(modifiers, requestingName, requestedName) {
  var requesting = find(modifiers, function (_ref) {
    var name = _ref.name;
    return name === requestingName;
  });

  var isRequired = !!requesting && modifiers.some(function (modifier) {
    return modifier.name === requestedName && modifier.enabled && modifier.order < requesting.order;
  });

  if (!isRequired) {
    var _requesting = '`' + requestingName + '`';
    var requested = '`' + requestedName + '`';
    console.warn(requested + ' modifier is required by ' + _requesting + ' modifier in order to work, be sure to include it before ' + _requesting + '!');
  }
  return isRequired;
}

/**
 * @function
 * @memberof Modifiers
 * @argument {Object} data - The data object generated by update method
 * @argument {Object} options - Modifiers configuration and options
 * @returns {Object} The data object, properly modified
 */
function arrow(data, options) {
  var _data$offsets$arrow;

  // arrow depends on keepTogether in order to work
  if (!isModifierRequired(data.instance.modifiers, 'arrow', 'keepTogether')) {
    return data;
  }

  var arrowElement = options.element;

  // if arrowElement is a string, suppose it's a CSS selector
  if (typeof arrowElement === 'string') {
    arrowElement = data.instance.popper.querySelector(arrowElement);

    // if arrowElement is not found, don't run the modifier
    if (!arrowElement) {
      return data;
    }
  } else {
    // if the arrowElement isn't a query selector we must check that the
    // provided DOM node is child of its popper node
    if (!data.instance.popper.contains(arrowElement)) {
      console.warn('WARNING: `arrow.element` must be child of its popper element!');
      return data;
    }
  }

  var placement = data.placement.split('-')[0];
  var _data$offsets = data.offsets,
      popper = _data$offsets.popper,
      reference = _data$offsets.reference;

  var isVertical = ['left', 'right'].indexOf(placement) !== -1;

  var len = isVertical ? 'height' : 'width';
  var sideCapitalized = isVertical ? 'Top' : 'Left';
  var side = sideCapitalized.toLowerCase();
  var altSide = isVertical ? 'left' : 'top';
  var opSide = isVertical ? 'bottom' : 'right';
  var arrowElementSize = getOuterSizes(arrowElement)[len];

  //
  // extends keepTogether behavior making sure the popper and its
  // reference have enough pixels in conjunction
  //

  // top/left side
  if (reference[opSide] - arrowElementSize < popper[side]) {
    data.offsets.popper[side] -= popper[side] - (reference[opSide] - arrowElementSize);
  }
  // bottom/right side
  if (reference[side] + arrowElementSize > popper[opSide]) {
    data.offsets.popper[side] += reference[side] + arrowElementSize - popper[opSide];
  }
  data.offsets.popper = getClientRect(data.offsets.popper);

  // compute center of the popper
  var center = reference[side] + reference[len] / 2 - arrowElementSize / 2;

  // Compute the sideValue using the updated popper offsets
  // take popper margin in account because we don't have this info available
  var css = getStyleComputedProperty(data.instance.popper);
  var popperMarginSide = parseFloat(css['margin' + sideCapitalized], 10);
  var popperBorderSide = parseFloat(css['border' + sideCapitalized + 'Width'], 10);
  var sideValue = center - data.offsets.popper[side] - popperMarginSide - popperBorderSide;

  // prevent arrowElement from being placed not contiguously to its popper
  sideValue = Math.max(Math.min(popper[len] - arrowElementSize, sideValue), 0);

  data.arrowElement = arrowElement;
  data.offsets.arrow = (_data$offsets$arrow = {}, defineProperty(_data$offsets$arrow, side, Math.round(sideValue)), defineProperty(_data$offsets$arrow, altSide, ''), _data$offsets$arrow);

  return data;
}

/**
 * Get the opposite placement variation of the given one
 * @method
 * @memberof Popper.Utils
 * @argument {String} placement variation
 * @returns {String} flipped placement variation
 */
function getOppositeVariation(variation) {
  if (variation === 'end') {
    return 'start';
  } else if (variation === 'start') {
    return 'end';
  }
  return variation;
}

/**
 * List of accepted placements to use as values of the `placement` option.<br />
 * Valid placements are:
 * - `auto`
 * - `top`
 * - `right`
 * - `bottom`
 * - `left`
 *
 * Each placement can have a variation from this list:
 * - `-start`
 * - `-end`
 *
 * Variations are interpreted easily if you think of them as the left to right
 * written languages. Horizontally (`top` and `bottom`), `start` is left and `end`
 * is right.<br />
 * Vertically (`left` and `right`), `start` is top and `end` is bottom.
 *
 * Some valid examples are:
 * - `top-end` (on top of reference, right aligned)
 * - `right-start` (on right of reference, top aligned)
 * - `bottom` (on bottom, centered)
 * - `auto-end` (on the side with more space available, alignment depends by placement)
 *
 * @static
 * @type {Array}
 * @enum {String}
 * @readonly
 * @method placements
 * @memberof Popper
 */
var placements = ['auto-start', 'auto', 'auto-end', 'top-start', 'top', 'top-end', 'right-start', 'right', 'right-end', 'bottom-end', 'bottom', 'bottom-start', 'left-end', 'left', 'left-start'];

// Get rid of `auto` `auto-start` and `auto-end`
var validPlacements = placements.slice(3);

/**
 * Given an initial placement, returns all the subsequent placements
 * clockwise (or counter-clockwise).
 *
 * @method
 * @memberof Popper.Utils
 * @argument {String} placement - A valid placement (it accepts variations)
 * @argument {Boolean} counter - Set to true to walk the placements counterclockwise
 * @returns {Array} placements including their variations
 */
function clockwise(placement) {
  var counter = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

  var index = validPlacements.indexOf(placement);
  var arr = validPlacements.slice(index + 1).concat(validPlacements.slice(0, index));
  return counter ? arr.reverse() : arr;
}

var BEHAVIORS = {
  FLIP: 'flip',
  CLOCKWISE: 'clockwise',
  COUNTERCLOCKWISE: 'counterclockwise'
};

/**
 * @function
 * @memberof Modifiers
 * @argument {Object} data - The data object generated by update method
 * @argument {Object} options - Modifiers configuration and options
 * @returns {Object} The data object, properly modified
 */
function flip(data, options) {
  // if `inner` modifier is enabled, we can't use the `flip` modifier
  if (isModifierEnabled(data.instance.modifiers, 'inner')) {
    return data;
  }

  if (data.flipped && data.placement === data.originalPlacement) {
    // seems like flip is trying to loop, probably there's not enough space on any of the flippable sides
    return data;
  }

  var boundaries = getBoundaries(data.instance.popper, data.instance.reference, options.padding, options.boundariesElement, data.positionFixed);

  var placement = data.placement.split('-')[0];
  var placementOpposite = getOppositePlacement(placement);
  var variation = data.placement.split('-')[1] || '';

  var flipOrder = [];

  switch (options.behavior) {
    case BEHAVIORS.FLIP:
      flipOrder = [placement, placementOpposite];
      break;
    case BEHAVIORS.CLOCKWISE:
      flipOrder = clockwise(placement);
      break;
    case BEHAVIORS.COUNTERCLOCKWISE:
      flipOrder = clockwise(placement, true);
      break;
    default:
      flipOrder = options.behavior;
  }

  flipOrder.forEach(function (step, index) {
    if (placement !== step || flipOrder.length === index + 1) {
      return data;
    }

    placement = data.placement.split('-')[0];
    placementOpposite = getOppositePlacement(placement);

    var popperOffsets = data.offsets.popper;
    var refOffsets = data.offsets.reference;

    // using floor because the reference offsets may contain decimals we are not going to consider here
    var floor = Math.floor;
    var overlapsRef = placement === 'left' && floor(popperOffsets.right) > floor(refOffsets.left) || placement === 'right' && floor(popperOffsets.left) < floor(refOffsets.right) || placement === 'top' && floor(popperOffsets.bottom) > floor(refOffsets.top) || placement === 'bottom' && floor(popperOffsets.top) < floor(refOffsets.bottom);

    var overflowsLeft = floor(popperOffsets.left) < floor(boundaries.left);
    var overflowsRight = floor(popperOffsets.right) > floor(boundaries.right);
    var overflowsTop = floor(popperOffsets.top) < floor(boundaries.top);
    var overflowsBottom = floor(popperOffsets.bottom) > floor(boundaries.bottom);

    var overflowsBoundaries = placement === 'left' && overflowsLeft || placement === 'right' && overflowsRight || placement === 'top' && overflowsTop || placement === 'bottom' && overflowsBottom;

    // flip the variation if required
    var isVertical = ['top', 'bottom'].indexOf(placement) !== -1;

    // flips variation if reference element overflows boundaries
    var flippedVariationByRef = !!options.flipVariations && (isVertical && variation === 'start' && overflowsLeft || isVertical && variation === 'end' && overflowsRight || !isVertical && variation === 'start' && overflowsTop || !isVertical && variation === 'end' && overflowsBottom);

    // flips variation if popper content overflows boundaries
    var flippedVariationByContent = !!options.flipVariationsByContent && (isVertical && variation === 'start' && overflowsRight || isVertical && variation === 'end' && overflowsLeft || !isVertical && variation === 'start' && overflowsBottom || !isVertical && variation === 'end' && overflowsTop);

    var flippedVariation = flippedVariationByRef || flippedVariationByContent;

    if (overlapsRef || overflowsBoundaries || flippedVariation) {
      // this boolean to detect any flip loop
      data.flipped = true;

      if (overlapsRef || overflowsBoundaries) {
        placement = flipOrder[index + 1];
      }

      if (flippedVariation) {
        variation = getOppositeVariation(variation);
      }

      data.placement = placement + (variation ? '-' + variation : '');

      // this object contains `position`, we want to preserve it along with
      // any additional property we may add in the future
      data.offsets.popper = _extends({}, data.offsets.popper, getPopperOffsets(data.instance.popper, data.offsets.reference, data.placement));

      data = runModifiers(data.instance.modifiers, data, 'flip');
    }
  });
  return data;
}

/**
 * @function
 * @memberof Modifiers
 * @argument {Object} data - The data object generated by update method
 * @argument {Object} options - Modifiers configuration and options
 * @returns {Object} The data object, properly modified
 */
function keepTogether(data) {
  var _data$offsets = data.offsets,
      popper = _data$offsets.popper,
      reference = _data$offsets.reference;

  var placement = data.placement.split('-')[0];
  var floor = Math.floor;
  var isVertical = ['top', 'bottom'].indexOf(placement) !== -1;
  var side = isVertical ? 'right' : 'bottom';
  var opSide = isVertical ? 'left' : 'top';
  var measurement = isVertical ? 'width' : 'height';

  if (popper[side] < floor(reference[opSide])) {
    data.offsets.popper[opSide] = floor(reference[opSide]) - popper[measurement];
  }
  if (popper[opSide] > floor(reference[side])) {
    data.offsets.popper[opSide] = floor(reference[side]);
  }

  return data;
}

/**
 * Converts a string containing value + unit into a px value number
 * @function
 * @memberof {modifiers~offset}
 * @private
 * @argument {String} str - Value + unit string
 * @argument {String} measurement - `height` or `width`
 * @argument {Object} popperOffsets
 * @argument {Object} referenceOffsets
 * @returns {Number|String}
 * Value in pixels, or original string if no values were extracted
 */
function toValue(str, measurement, popperOffsets, referenceOffsets) {
  // separate value from unit
  var split = str.match(/((?:\-|\+)?\d*\.?\d*)(.*)/);
  var value = +split[1];
  var unit = split[2];

  // If it's not a number it's an operator, I guess
  if (!value) {
    return str;
  }

  if (unit.indexOf('%') === 0) {
    var element = void 0;
    switch (unit) {
      case '%p':
        element = popperOffsets;
        break;
      case '%':
      case '%r':
      default:
        element = referenceOffsets;
    }

    var rect = getClientRect(element);
    return rect[measurement] / 100 * value;
  } else if (unit === 'vh' || unit === 'vw') {
    // if is a vh or vw, we calculate the size based on the viewport
    var size = void 0;
    if (unit === 'vh') {
      size = Math.max(document.documentElement.clientHeight, window.innerHeight || 0);
    } else {
      size = Math.max(document.documentElement.clientWidth, window.innerWidth || 0);
    }
    return size / 100 * value;
  } else {
    // if is an explicit pixel unit, we get rid of the unit and keep the value
    // if is an implicit unit, it's px, and we return just the value
    return value;
  }
}

/**
 * Parse an `offset` string to extrapolate `x` and `y` numeric offsets.
 * @function
 * @memberof {modifiers~offset}
 * @private
 * @argument {String} offset
 * @argument {Object} popperOffsets
 * @argument {Object} referenceOffsets
 * @argument {String} basePlacement
 * @returns {Array} a two cells array with x and y offsets in numbers
 */
function parseOffset(offset, popperOffsets, referenceOffsets, basePlacement) {
  var offsets = [0, 0];

  // Use height if placement is left or right and index is 0 otherwise use width
  // in this way the first offset will use an axis and the second one
  // will use the other one
  var useHeight = ['right', 'left'].indexOf(basePlacement) !== -1;

  // Split the offset string to obtain a list of values and operands
  // The regex addresses values with the plus or minus sign in front (+10, -20, etc)
  var fragments = offset.split(/(\+|\-)/).map(function (frag) {
    return frag.trim();
  });

  // Detect if the offset string contains a pair of values or a single one
  // they could be separated by comma or space
  var divider = fragments.indexOf(find(fragments, function (frag) {
    return frag.search(/,|\s/) !== -1;
  }));

  if (fragments[divider] && fragments[divider].indexOf(',') === -1) {
    console.warn('Offsets separated by white space(s) are deprecated, use a comma (,) instead.');
  }

  // If divider is found, we divide the list of values and operands to divide
  // them by ofset X and Y.
  var splitRegex = /\s*,\s*|\s+/;
  var ops = divider !== -1 ? [fragments.slice(0, divider).concat([fragments[divider].split(splitRegex)[0]]), [fragments[divider].split(splitRegex)[1]].concat(fragments.slice(divider + 1))] : [fragments];

  // Convert the values with units to absolute pixels to allow our computations
  ops = ops.map(function (op, index) {
    // Most of the units rely on the orientation of the popper
    var measurement = (index === 1 ? !useHeight : useHeight) ? 'height' : 'width';
    var mergeWithPrevious = false;
    return op
    // This aggregates any `+` or `-` sign that aren't considered operators
    // e.g.: 10 + +5 => [10, +, +5]
    .reduce(function (a, b) {
      if (a[a.length - 1] === '' && ['+', '-'].indexOf(b) !== -1) {
        a[a.length - 1] = b;
        mergeWithPrevious = true;
        return a;
      } else if (mergeWithPrevious) {
        a[a.length - 1] += b;
        mergeWithPrevious = false;
        return a;
      } else {
        return a.concat(b);
      }
    }, [])
    // Here we convert the string values into number values (in px)
    .map(function (str) {
      return toValue(str, measurement, popperOffsets, referenceOffsets);
    });
  });

  // Loop trough the offsets arrays and execute the operations
  ops.forEach(function (op, index) {
    op.forEach(function (frag, index2) {
      if (isNumeric(frag)) {
        offsets[index] += frag * (op[index2 - 1] === '-' ? -1 : 1);
      }
    });
  });
  return offsets;
}

/**
 * @function
 * @memberof Modifiers
 * @argument {Object} data - The data object generated by update method
 * @argument {Object} options - Modifiers configuration and options
 * @argument {Number|String} options.offset=0
 * The offset value as described in the modifier description
 * @returns {Object} The data object, properly modified
 */
function offset(data, _ref) {
  var offset = _ref.offset;
  var placement = data.placement,
      _data$offsets = data.offsets,
      popper = _data$offsets.popper,
      reference = _data$offsets.reference;

  var basePlacement = placement.split('-')[0];

  var offsets = void 0;
  if (isNumeric(+offset)) {
    offsets = [+offset, 0];
  } else {
    offsets = parseOffset(offset, popper, reference, basePlacement);
  }

  if (basePlacement === 'left') {
    popper.top += offsets[0];
    popper.left -= offsets[1];
  } else if (basePlacement === 'right') {
    popper.top += offsets[0];
    popper.left += offsets[1];
  } else if (basePlacement === 'top') {
    popper.left += offsets[0];
    popper.top -= offsets[1];
  } else if (basePlacement === 'bottom') {
    popper.left += offsets[0];
    popper.top += offsets[1];
  }

  data.popper = popper;
  return data;
}

/**
 * @function
 * @memberof Modifiers
 * @argument {Object} data - The data object generated by `update` method
 * @argument {Object} options - Modifiers configuration and options
 * @returns {Object} The data object, properly modified
 */
function preventOverflow(data, options) {
  var boundariesElement = options.boundariesElement || getOffsetParent(data.instance.popper);

  // If offsetParent is the reference element, we really want to
  // go one step up and use the next offsetParent as reference to
  // avoid to make this modifier completely useless and look like broken
  if (data.instance.reference === boundariesElement) {
    boundariesElement = getOffsetParent(boundariesElement);
  }

  // NOTE: DOM access here
  // resets the popper's position so that the document size can be calculated excluding
  // the size of the popper element itself
  var transformProp = getSupportedPropertyName('transform');
  var popperStyles = data.instance.popper.style; // assignment to help minification
  var top = popperStyles.top,
      left = popperStyles.left,
      transform = popperStyles[transformProp];

  popperStyles.top = '';
  popperStyles.left = '';
  popperStyles[transformProp] = '';

  var boundaries = getBoundaries(data.instance.popper, data.instance.reference, options.padding, boundariesElement, data.positionFixed);

  // NOTE: DOM access here
  // restores the original style properties after the offsets have been computed
  popperStyles.top = top;
  popperStyles.left = left;
  popperStyles[transformProp] = transform;

  options.boundaries = boundaries;

  var order = options.priority;
  var popper = data.offsets.popper;

  var check = {
    primary: function primary(placement) {
      var value = popper[placement];
      if (popper[placement] < boundaries[placement] && !options.escapeWithReference) {
        value = Math.max(popper[placement], boundaries[placement]);
      }
      return defineProperty({}, placement, value);
    },
    secondary: function secondary(placement) {
      var mainSide = placement === 'right' ? 'left' : 'top';
      var value = popper[mainSide];
      if (popper[placement] > boundaries[placement] && !options.escapeWithReference) {
        value = Math.min(popper[mainSide], boundaries[placement] - (placement === 'right' ? popper.width : popper.height));
      }
      return defineProperty({}, mainSide, value);
    }
  };

  order.forEach(function (placement) {
    var side = ['left', 'top'].indexOf(placement) !== -1 ? 'primary' : 'secondary';
    popper = _extends({}, popper, check[side](placement));
  });

  data.offsets.popper = popper;

  return data;
}

/**
 * @function
 * @memberof Modifiers
 * @argument {Object} data - The data object generated by `update` method
 * @argument {Object} options - Modifiers configuration and options
 * @returns {Object} The data object, properly modified
 */
function shift(data) {
  var placement = data.placement;
  var basePlacement = placement.split('-')[0];
  var shiftvariation = placement.split('-')[1];

  // if shift shiftvariation is specified, run the modifier
  if (shiftvariation) {
    var _data$offsets = data.offsets,
        reference = _data$offsets.reference,
        popper = _data$offsets.popper;

    var isVertical = ['bottom', 'top'].indexOf(basePlacement) !== -1;
    var side = isVertical ? 'left' : 'top';
    var measurement = isVertical ? 'width' : 'height';

    var shiftOffsets = {
      start: defineProperty({}, side, reference[side]),
      end: defineProperty({}, side, reference[side] + reference[measurement] - popper[measurement])
    };

    data.offsets.popper = _extends({}, popper, shiftOffsets[shiftvariation]);
  }

  return data;
}

/**
 * @function
 * @memberof Modifiers
 * @argument {Object} data - The data object generated by update method
 * @argument {Object} options - Modifiers configuration and options
 * @returns {Object} The data object, properly modified
 */
function hide(data) {
  if (!isModifierRequired(data.instance.modifiers, 'hide', 'preventOverflow')) {
    return data;
  }

  var refRect = data.offsets.reference;
  var bound = find(data.instance.modifiers, function (modifier) {
    return modifier.name === 'preventOverflow';
  }).boundaries;

  if (refRect.bottom < bound.top || refRect.left > bound.right || refRect.top > bound.bottom || refRect.right < bound.left) {
    // Avoid unnecessary DOM access if visibility hasn't changed
    if (data.hide === true) {
      return data;
    }

    data.hide = true;
    data.attributes['x-out-of-boundaries'] = '';
  } else {
    // Avoid unnecessary DOM access if visibility hasn't changed
    if (data.hide === false) {
      return data;
    }

    data.hide = false;
    data.attributes['x-out-of-boundaries'] = false;
  }

  return data;
}

/**
 * @function
 * @memberof Modifiers
 * @argument {Object} data - The data object generated by `update` method
 * @argument {Object} options - Modifiers configuration and options
 * @returns {Object} The data object, properly modified
 */
function inner(data) {
  var placement = data.placement;
  var basePlacement = placement.split('-')[0];
  var _data$offsets = data.offsets,
      popper = _data$offsets.popper,
      reference = _data$offsets.reference;

  var isHoriz = ['left', 'right'].indexOf(basePlacement) !== -1;

  var subtractLength = ['top', 'left'].indexOf(basePlacement) === -1;

  popper[isHoriz ? 'left' : 'top'] = reference[basePlacement] - (subtractLength ? popper[isHoriz ? 'width' : 'height'] : 0);

  data.placement = getOppositePlacement(placement);
  data.offsets.popper = getClientRect(popper);

  return data;
}

/**
 * Modifier function, each modifier can have a function of this type assigned
 * to its `fn` property.<br />
 * These functions will be called on each update, this means that you must
 * make sure they are performant enough to avoid performance bottlenecks.
 *
 * @function ModifierFn
 * @argument {dataObject} data - The data object generated by `update` method
 * @argument {Object} options - Modifiers configuration and options
 * @returns {dataObject} The data object, properly modified
 */

/**
 * Modifiers are plugins used to alter the behavior of your poppers.<br />
 * Popper.js uses a set of 9 modifiers to provide all the basic functionalities
 * needed by the library.
 *
 * Usually you don't want to override the `order`, `fn` and `onLoad` props.
 * All the other properties are configurations that could be tweaked.
 * @namespace modifiers
 */
var modifiers = {
  /**
   * Modifier used to shift the popper on the start or end of its reference
   * element.<br />
   * It will read the variation of the `placement` property.<br />
   * It can be one either `-end` or `-start`.
   * @memberof modifiers
   * @inner
   */
  shift: {
    /** @prop {number} order=100 - Index used to define the order of execution */
    order: 100,
    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
    enabled: true,
    /** @prop {ModifierFn} */
    fn: shift
  },

  /**
   * The `offset` modifier can shift your popper on both its axis.
   *
   * It accepts the following units:
   * - `px` or unit-less, interpreted as pixels
   * - `%` or `%r`, percentage relative to the length of the reference element
   * - `%p`, percentage relative to the length of the popper element
   * - `vw`, CSS viewport width unit
   * - `vh`, CSS viewport height unit
   *
   * For length is intended the main axis relative to the placement of the popper.<br />
   * This means that if the placement is `top` or `bottom`, the length will be the
   * `width`. In case of `left` or `right`, it will be the `height`.
   *
   * You can provide a single value (as `Number` or `String`), or a pair of values
   * as `String` divided by a comma or one (or more) white spaces.<br />
   * The latter is a deprecated method because it leads to confusion and will be
   * removed in v2.<br />
   * Additionally, it accepts additions and subtractions between different units.
   * Note that multiplications and divisions aren't supported.
   *
   * Valid examples are:
   * ```
   * 10
   * '10%'
   * '10, 10'
   * '10%, 10'
   * '10 + 10%'
   * '10 - 5vh + 3%'
   * '-10px + 5vh, 5px - 6%'
   * ```
   * > **NB**: If you desire to apply offsets to your poppers in a way that may make them overlap
   * > with their reference element, unfortunately, you will have to disable the `flip` modifier.
   * > You can read more on this at this [issue](https://github.com/FezVrasta/popper.js/issues/373).
   *
   * @memberof modifiers
   * @inner
   */
  offset: {
    /** @prop {number} order=200 - Index used to define the order of execution */
    order: 200,
    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
    enabled: true,
    /** @prop {ModifierFn} */
    fn: offset,
    /** @prop {Number|String} offset=0
     * The offset value as described in the modifier description
     */
    offset: 0
  },

  /**
   * Modifier used to prevent the popper from being positioned outside the boundary.
   *
   * A scenario exists where the reference itself is not within the boundaries.<br />
   * We can say it has "escaped the boundaries" — or just "escaped".<br />
   * In this case we need to decide whether the popper should either:
   *
   * - detach from the reference and remain "trapped" in the boundaries, or
   * - if it should ignore the boundary and "escape with its reference"
   *
   * When `escapeWithReference` is set to`true` and reference is completely
   * outside its boundaries, the popper will overflow (or completely leave)
   * the boundaries in order to remain attached to the edge of the reference.
   *
   * @memberof modifiers
   * @inner
   */
  preventOverflow: {
    /** @prop {number} order=300 - Index used to define the order of execution */
    order: 300,
    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
    enabled: true,
    /** @prop {ModifierFn} */
    fn: preventOverflow,
    /**
     * @prop {Array} [priority=['left','right','top','bottom']]
     * Popper will try to prevent overflow following these priorities by default,
     * then, it could overflow on the left and on top of the `boundariesElement`
     */
    priority: ['left', 'right', 'top', 'bottom'],
    /**
     * @prop {number} padding=5
     * Amount of pixel used to define a minimum distance between the boundaries
     * and the popper. This makes sure the popper always has a little padding
     * between the edges of its container
     */
    padding: 5,
    /**
     * @prop {String|HTMLElement} boundariesElement='scrollParent'
     * Boundaries used by the modifier. Can be `scrollParent`, `window`,
     * `viewport` or any DOM element.
     */
    boundariesElement: 'scrollParent'
  },

  /**
   * Modifier used to make sure the reference and its popper stay near each other
   * without leaving any gap between the two. Especially useful when the arrow is
   * enabled and you want to ensure that it points to its reference element.
   * It cares only about the first axis. You can still have poppers with margin
   * between the popper and its reference element.
   * @memberof modifiers
   * @inner
   */
  keepTogether: {
    /** @prop {number} order=400 - Index used to define the order of execution */
    order: 400,
    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
    enabled: true,
    /** @prop {ModifierFn} */
    fn: keepTogether
  },

  /**
   * This modifier is used to move the `arrowElement` of the popper to make
   * sure it is positioned between the reference element and its popper element.
   * It will read the outer size of the `arrowElement` node to detect how many
   * pixels of conjunction are needed.
   *
   * It has no effect if no `arrowElement` is provided.
   * @memberof modifiers
   * @inner
   */
  arrow: {
    /** @prop {number} order=500 - Index used to define the order of execution */
    order: 500,
    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
    enabled: true,
    /** @prop {ModifierFn} */
    fn: arrow,
    /** @prop {String|HTMLElement} element='[x-arrow]' - Selector or node used as arrow */
    element: '[x-arrow]'
  },

  /**
   * Modifier used to flip the popper's placement when it starts to overlap its
   * reference element.
   *
   * Requires the `preventOverflow` modifier before it in order to work.
   *
   * **NOTE:** this modifier will interrupt the current update cycle and will
   * restart it if it detects the need to flip the placement.
   * @memberof modifiers
   * @inner
   */
  flip: {
    /** @prop {number} order=600 - Index used to define the order of execution */
    order: 600,
    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
    enabled: true,
    /** @prop {ModifierFn} */
    fn: flip,
    /**
     * @prop {String|Array} behavior='flip'
     * The behavior used to change the popper's placement. It can be one of
     * `flip`, `clockwise`, `counterclockwise` or an array with a list of valid
     * placements (with optional variations)
     */
    behavior: 'flip',
    /**
     * @prop {number} padding=5
     * The popper will flip if it hits the edges of the `boundariesElement`
     */
    padding: 5,
    /**
     * @prop {String|HTMLElement} boundariesElement='viewport'
     * The element which will define the boundaries of the popper position.
     * The popper will never be placed outside of the defined boundaries
     * (except if `keepTogether` is enabled)
     */
    boundariesElement: 'viewport',
    /**
     * @prop {Boolean} flipVariations=false
     * The popper will switch placement variation between `-start` and `-end` when
     * the reference element overlaps its boundaries.
     *
     * The original placement should have a set variation.
     */
    flipVariations: false,
    /**
     * @prop {Boolean} flipVariationsByContent=false
     * The popper will switch placement variation between `-start` and `-end` when
     * the popper element overlaps its reference boundaries.
     *
     * The original placement should have a set variation.
     */
    flipVariationsByContent: false
  },

  /**
   * Modifier used to make the popper flow toward the inner of the reference element.
   * By default, when this modifier is disabled, the popper will be placed outside
   * the reference element.
   * @memberof modifiers
   * @inner
   */
  inner: {
    /** @prop {number} order=700 - Index used to define the order of execution */
    order: 700,
    /** @prop {Boolean} enabled=false - Whether the modifier is enabled or not */
    enabled: false,
    /** @prop {ModifierFn} */
    fn: inner
  },

  /**
   * Modifier used to hide the popper when its reference element is outside of the
   * popper boundaries. It will set a `x-out-of-boundaries` attribute which can
   * be used to hide with a CSS selector the popper when its reference is
   * out of boundaries.
   *
   * Requires the `preventOverflow` modifier before it in order to work.
   * @memberof modifiers
   * @inner
   */
  hide: {
    /** @prop {number} order=800 - Index used to define the order of execution */
    order: 800,
    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
    enabled: true,
    /** @prop {ModifierFn} */
    fn: hide
  },

  /**
   * Computes the style that will be applied to the popper element to gets
   * properly positioned.
   *
   * Note that this modifier will not touch the DOM, it just prepares the styles
   * so that `applyStyle` modifier can apply it. This separation is useful
   * in case you need to replace `applyStyle` with a custom implementation.
   *
   * This modifier has `850` as `order` value to maintain backward compatibility
   * with previous versions of Popper.js. Expect the modifiers ordering method
   * to change in future major versions of the library.
   *
   * @memberof modifiers
   * @inner
   */
  computeStyle: {
    /** @prop {number} order=850 - Index used to define the order of execution */
    order: 850,
    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
    enabled: true,
    /** @prop {ModifierFn} */
    fn: computeStyle,
    /**
     * @prop {Boolean} gpuAcceleration=true
     * If true, it uses the CSS 3D transformation to position the popper.
     * Otherwise, it will use the `top` and `left` properties
     */
    gpuAcceleration: true,
    /**
     * @prop {string} [x='bottom']
     * Where to anchor the X axis (`bottom` or `top`). AKA X offset origin.
     * Change this if your popper should grow in a direction different from `bottom`
     */
    x: 'bottom',
    /**
     * @prop {string} [x='left']
     * Where to anchor the Y axis (`left` or `right`). AKA Y offset origin.
     * Change this if your popper should grow in a direction different from `right`
     */
    y: 'right'
  },

  /**
   * Applies the computed styles to the popper element.
   *
   * All the DOM manipulations are limited to this modifier. This is useful in case
   * you want to integrate Popper.js inside a framework or view library and you
   * want to delegate all the DOM manipulations to it.
   *
   * Note that if you disable this modifier, you must make sure the popper element
   * has its position set to `absolute` before Popper.js can do its work!
   *
   * Just disable this modifier and define your own to achieve the desired effect.
   *
   * @memberof modifiers
   * @inner
   */
  applyStyle: {
    /** @prop {number} order=900 - Index used to define the order of execution */
    order: 900,
    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
    enabled: true,
    /** @prop {ModifierFn} */
    fn: applyStyle,
    /** @prop {Function} */
    onLoad: applyStyleOnLoad,
    /**
     * @deprecated since version 1.10.0, the property moved to `computeStyle` modifier
     * @prop {Boolean} gpuAcceleration=true
     * If true, it uses the CSS 3D transformation to position the popper.
     * Otherwise, it will use the `top` and `left` properties
     */
    gpuAcceleration: undefined
  }
};

/**
 * The `dataObject` is an object containing all the information used by Popper.js.
 * This object is passed to modifiers and to the `onCreate` and `onUpdate` callbacks.
 * @name dataObject
 * @property {Object} data.instance The Popper.js instance
 * @property {String} data.placement Placement applied to popper
 * @property {String} data.originalPlacement Placement originally defined on init
 * @property {Boolean} data.flipped True if popper has been flipped by flip modifier
 * @property {Boolean} data.hide True if the reference element is out of boundaries, useful to know when to hide the popper
 * @property {HTMLElement} data.arrowElement Node used as arrow by arrow modifier
 * @property {Object} data.styles Any CSS property defined here will be applied to the popper. It expects the JavaScript nomenclature (eg. `marginBottom`)
 * @property {Object} data.arrowStyles Any CSS property defined here will be applied to the popper arrow. It expects the JavaScript nomenclature (eg. `marginBottom`)
 * @property {Object} data.boundaries Offsets of the popper boundaries
 * @property {Object} data.offsets The measurements of popper, reference and arrow elements
 * @property {Object} data.offsets.popper `top`, `left`, `width`, `height` values
 * @property {Object} data.offsets.reference `top`, `left`, `width`, `height` values
 * @property {Object} data.offsets.arrow] `top` and `left` offsets, only one of them will be different from 0
 */

/**
 * Default options provided to Popper.js constructor.<br />
 * These can be overridden using the `options` argument of Popper.js.<br />
 * To override an option, simply pass an object with the same
 * structure of the `options` object, as the 3rd argument. For example:
 * ```
 * new Popper(ref, pop, {
 *   modifiers: {
 *     preventOverflow: { enabled: false }
 *   }
 * })
 * ```
 * @type {Object}
 * @static
 * @memberof Popper
 */
var Defaults = {
  /**
   * Popper's placement.
   * @prop {Popper.placements} placement='bottom'
   */
  placement: 'bottom',

  /**
   * Set this to true if you want popper to position it self in 'fixed' mode
   * @prop {Boolean} positionFixed=false
   */
  positionFixed: false,

  /**
   * Whether events (resize, scroll) are initially enabled.
   * @prop {Boolean} eventsEnabled=true
   */
  eventsEnabled: true,

  /**
   * Set to true if you want to automatically remove the popper when
   * you call the `destroy` method.
   * @prop {Boolean} removeOnDestroy=false
   */
  removeOnDestroy: false,

  /**
   * Callback called when the popper is created.<br />
   * By default, it is set to no-op.<br />
   * Access Popper.js instance with `data.instance`.
   * @prop {onCreate}
   */
  onCreate: function onCreate() {},

  /**
   * Callback called when the popper is updated. This callback is not called
   * on the initialization/creation of the popper, but only on subsequent
   * updates.<br />
   * By default, it is set to no-op.<br />
   * Access Popper.js instance with `data.instance`.
   * @prop {onUpdate}
   */
  onUpdate: function onUpdate() {},

  /**
   * List of modifiers used to modify the offsets before they are applied to the popper.
   * They provide most of the functionalities of Popper.js.
   * @prop {modifiers}
   */
  modifiers: modifiers
};

/**
 * @callback onCreate
 * @param {dataObject} data
 */

/**
 * @callback onUpdate
 * @param {dataObject} data
 */

// Utils
// Methods
var Popper = function () {
  /**
   * Creates a new Popper.js instance.
   * @class Popper
   * @param {Element|referenceObject} reference - The reference element used to position the popper
   * @param {Element} popper - The HTML / XML element used as the popper
   * @param {Object} options - Your custom options to override the ones defined in [Defaults](#defaults)
   * @return {Object} instance - The generated Popper.js instance
   */
  function Popper(reference, popper) {
    var _this = this;

    var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    classCallCheck(this, Popper);

    this.scheduleUpdate = function () {
      return requestAnimationFrame(_this.update);
    };

    // make update() debounced, so that it only runs at most once-per-tick
    this.update = debounce(this.update.bind(this));

    // with {} we create a new object with the options inside it
    this.options = _extends({}, Popper.Defaults, options);

    // init state
    this.state = {
      isDestroyed: false,
      isCreated: false,
      scrollParents: []
    };

    // get reference and popper elements (allow jQuery wrappers)
    this.reference = reference && reference.jquery ? reference[0] : reference;
    this.popper = popper && popper.jquery ? popper[0] : popper;

    // Deep merge modifiers options
    this.options.modifiers = {};
    Object.keys(_extends({}, Popper.Defaults.modifiers, options.modifiers)).forEach(function (name) {
      _this.options.modifiers[name] = _extends({}, Popper.Defaults.modifiers[name] || {}, options.modifiers ? options.modifiers[name] : {});
    });

    // Refactoring modifiers' list (Object => Array)
    this.modifiers = Object.keys(this.options.modifiers).map(function (name) {
      return _extends({
        name: name
      }, _this.options.modifiers[name]);
    })
    // sort the modifiers by order
    .sort(function (a, b) {
      return a.order - b.order;
    });

    // modifiers have the ability to execute arbitrary code when Popper.js get inited
    // such code is executed in the same order of its modifier
    // they could add new properties to their options configuration
    // BE AWARE: don't add options to `options.modifiers.name` but to `modifierOptions`!
    this.modifiers.forEach(function (modifierOptions) {
      if (modifierOptions.enabled && isFunction(modifierOptions.onLoad)) {
        modifierOptions.onLoad(_this.reference, _this.popper, _this.options, modifierOptions, _this.state);
      }
    });

    // fire the first update to position the popper in the right place
    this.update();

    var eventsEnabled = this.options.eventsEnabled;
    if (eventsEnabled) {
      // setup event listeners, they will take care of update the position in specific situations
      this.enableEventListeners();
    }

    this.state.eventsEnabled = eventsEnabled;
  }

  // We can't use class properties because they don't get listed in the
  // class prototype and break stuff like Sinon stubs


  createClass(Popper, [{
    key: 'update',
    value: function update$$1() {
      return update.call(this);
    }
  }, {
    key: 'destroy',
    value: function destroy$$1() {
      return destroy.call(this);
    }
  }, {
    key: 'enableEventListeners',
    value: function enableEventListeners$$1() {
      return enableEventListeners.call(this);
    }
  }, {
    key: 'disableEventListeners',
    value: function disableEventListeners$$1() {
      return disableEventListeners.call(this);
    }

    /**
     * Schedules an update. It will run on the next UI update available.
     * @method scheduleUpdate
     * @memberof Popper
     */


    /**
     * Collection of utilities useful when writing custom modifiers.
     * Starting from version 1.7, this method is available only if you
     * include `popper-utils.js` before `popper.js`.
     *
     * **DEPRECATION**: This way to access PopperUtils is deprecated
     * and will be removed in v2! Use the PopperUtils module directly instead.
     * Due to the high instability of the methods contained in Utils, we can't
     * guarantee them to follow semver. Use them at your own risk!
     * @static
     * @private
     * @type {Object}
     * @deprecated since version 1.8
     * @member Utils
     * @memberof Popper
     */

  }]);
  return Popper;
}();

/**
 * The `referenceObject` is an object that provides an interface compatible with Popper.js
 * and lets you use it as replacement of a real DOM node.<br />
 * You can use this method to position a popper relatively to a set of coordinates
 * in case you don't have a DOM node to use as reference.
 *
 * ```
 * new Popper(referenceObject, popperNode);
 * ```
 *
 * NB: This feature isn't supported in Internet Explorer 10.
 * @name referenceObject
 * @property {Function} data.getBoundingClientRect
 * A function that returns a set of coordinates compatible with the native `getBoundingClientRect` method.
 * @property {number} data.clientWidth
 * An ES6 getter that will return the width of the virtual reference element.
 * @property {number} data.clientHeight
 * An ES6 getter that will return the height of the virtual reference element.
 */


Popper.Utils = (typeof window !== 'undefined' ? window : global).PopperUtils;
Popper.placements = placements;
Popper.Defaults = Defaults;

return Popper;

})));


      };
    };
  }
  }
}, {package:"react-tippy>popper.js",file:"node_modules\\react-tippy\\node_modules\\popper.js\\dist\\umd\\popper.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\react-toggle-button\\lib\\index.js", {"react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Creact-toggle-button%5Clib%5Cindex.js
      return function (require, module, exports) {
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t(require("react")):"function"==typeof define&&define.amd?define(["react"],t):"object"==typeof exports?exports["react-toggle-button"]=t(require("react")):e["react-toggle-button"]=t(e.React)}(this,function(e){return function(e){function t(r){if(n[r])return n[r].exports;var a=n[r]={exports:{},id:r,loaded:!1};return e[r].call(a.exports,a,a.exports,t),a.loaded=!0,a.exports}var n={};return t.m=e,t.c=n,t.p="",t(0)}([function(e,t,n){e.exports=n(12)},function(e,t,n){e.exports=n(17)()},function(e,t){"use strict";function n(e){var t={};for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&(t[n]="number"==typeof e[n]?e[n]:e[n].val);return t}t.__esModule=!0,t.default=n,e.exports=t.default},function(t,n){t.exports=e},function(e,t,n){(function(t){(function(){var n,r,a;"undefined"!=typeof performance&&null!==performance&&performance.now?e.exports=function(){return performance.now()}:"undefined"!=typeof t&&null!==t&&t.hrtime?(e.exports=function(){return(n()-a)/1e6},r=t.hrtime,n=function(){var e;return e=r(),1e9*e[0]+e[1]},a=n()):Date.now?(e.exports=function(){return Date.now()-a},a=Date.now()):(e.exports=function(){return(new Date).getTime()-a},a=(new Date).getTime())}).call(this)}).call(t,n(9))},function(e,t,n){(function(t){for(var r=n(19),a="undefined"==typeof window?t:window,o=["moz","webkit"],i="AnimationFrame",l=a["request"+i],u=a["cancel"+i]||a["cancelRequest"+i],s=0;!l&&s<o.length;s++)l=a[o[s]+"Request"+i],u=a[o[s]+"Cancel"+i]||a[o[s]+"CancelRequest"+i];if(!l||!u){var c=0,f=0,p=[],d=1e3/60;l=function(e){if(0===p.length){var t=r(),n=Math.max(0,d-(t-c));c=n+t,setTimeout(function(){var e=p.slice(0);p.length=0;for(var t=0;t<e.length;t++)if(!e[t].cancelled)try{e[t].callback(c)}catch(e){setTimeout(function(){throw e},0)}},Math.round(n))}return p.push({handle:++f,callback:e,cancelled:!1}),f},u=function(e){for(var t=0;t<p.length;t++)p[t].handle===e&&(p[t].cancelled=!0)}}e.exports=function(e){return l.call(a,e)},e.exports.cancel=function(){u.apply(a,arguments)},e.exports.polyfill=function(e){e||(e=a),e.requestAnimationFrame=l,e.cancelAnimationFrame=u}}).call(t,function(){return this}())},function(e,t){"use strict";function n(e){var t={};for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&(t[n]=0);return t}t.__esModule=!0,t.default=n,e.exports=t.default},function(e,t){"use strict";function n(e,t,n){for(var r in t)if(Object.prototype.hasOwnProperty.call(t,r)){if(0!==n[r])return!1;var a="number"==typeof t[r]?t[r]:t[r].val;if(e[r]!==a)return!1}return!0}t.__esModule=!0,t.default=n,e.exports=t.default},function(e,t){"use strict";function n(e,t,n,a,o,i,l){var u=-o*(t-a),s=-i*n,c=u+s,f=n+c*e,p=t+f*e;return Math.abs(f)<l&&Math.abs(p-a)<l?(r[0]=a,r[1]=0,r):(r[0]=p,r[1]=f,r)}t.__esModule=!0,t.default=n;var r=[0,0];e.exports=t.default},function(e,t){function n(){throw new Error("setTimeout has not been defined")}function r(){throw new Error("clearTimeout has not been defined")}function a(e){if(c===setTimeout)return setTimeout(e,0);if((c===n||!c)&&setTimeout)return c=setTimeout,setTimeout(e,0);try{return c(e,0)}catch(t){try{return c.call(null,e,0)}catch(t){return c.call(this,e,0)}}}function o(e){if(f===clearTimeout)return clearTimeout(e);if((f===r||!f)&&clearTimeout)return f=clearTimeout,clearTimeout(e);try{return f(e)}catch(t){try{return f.call(null,e)}catch(t){return f.call(this,e)}}}function i(){h&&d&&(h=!1,d.length?y=d.concat(y):m=-1,y.length&&l())}function l(){if(!h){var e=a(i);h=!0;for(var t=y.length;t;){for(d=y,y=[];++m<t;)d&&d[m].run();m=-1,t=y.length}d=null,h=!1,o(e)}}function u(e,t){this.fun=e,this.array=t}function s(){}var c,f,p=e.exports={};!function(){try{c="function"==typeof setTimeout?setTimeout:n}catch(e){c=n}try{f="function"==typeof clearTimeout?clearTimeout:r}catch(e){f=r}}();var d,y=[],h=!1,m=-1;p.nextTick=function(e){var t=new Array(arguments.length-1);if(arguments.length>1)for(var n=1;n<arguments.length;n++)t[n-1]=arguments[n];y.push(new u(e,t)),1!==y.length||h||a(l)},u.prototype.run=function(){this.fun.apply(null,this.array)},p.title="browser",p.browser=!0,p.env={},p.argv=[],p.version="",p.versions={},p.on=s,p.addListener=s,p.once=s,p.off=s,p.removeListener=s,p.removeAllListeners=s,p.emit=s,p.prependListener=s,p.prependOnceListener=s,p.listeners=function(e){return[]},p.binding=function(e){throw new Error("process.binding is not supported")},p.cwd=function(){return"/"},p.chdir=function(e){throw new Error("process.chdir is not supported")},p.umask=function(){return 0}},function(e,t){"use strict";t.__esModule=!0,t.default={noWobble:{stiffness:170,damping:26},gentle:{stiffness:120,damping:14},wobbly:{stiffness:180,damping:12},stiff:{stiffness:210,damping:20}},e.exports=t.default},function(e,t){"use strict";function n(e){var t=e;if(l[t])return l[t];t=t.replace("#",""),3===t.length&&(t=t[0]+t[0]+t[1]+t[1]+t[2]+t[2]);var n=t.match(/.{2}/g),r={r:parseInt(n[0],16),g:parseInt(n[1],16),b:parseInt(n[2],16)};return l[t]=r,r}function r(e){var t=e.indexOf("rgb")!=-1,n=e.indexOf("rgba")!=-1,r=e.match(/\d+/g);if(t&&!n)return{r:parseInt(r[0]),g:parseInt(r[1]),b:parseInt(r[2])};if(t&&n){var a="0"==r[3]?"0."+r[4]:r[3];return{r:parseInt(r[0]),g:parseInt(r[1]),b:parseInt(r[2]),a:parseFloat(a)}}return null}function a(e,t,n){var r=e.toString(16),a=t.toString(16),o=n.toString(16);return r=r.length<2?"0"+r:r,a=a.length<2?"0"+a:a,o=o.length<2?"0"+o:o,"#"+r+a+o}function o(e,t,n,r,a){var o=n-t,i=a-r,l=(e-t)/o;return r+l*i}function i(e,t,n,a,i,l){var u=void 0===a?0:a,s=void 0===i?1:i,c=r(t),f=r(n),p=Math.floor(o(e,u,s,c.r,f.r)),d=Math.floor(o(e,u,s,c.g,f.g)),y=Math.floor(o(e,u,s,c.b,f.b)),h=!1,m=null;return c.a&&f.a&&(h=!0,m=o(e,u,s,c.a,f.a)),m?"rgb("+p+","+d+","+y+","+m+")":"rgb("+p+","+d+","+y+")"}Object.defineProperty(t,"__esModule",{value:!0}),t.hexToRGB=n,t.rgbToObj=r,t.rgbToHex=a,t.mapValueInRange=o,t.interpolateColor=i;var l={}},function(e,t,n){"use strict";function r(e){return e&&e.__esModule?e:{default:e}}var a=n(13),o=r(a);e.exports=o.default},function(e,t,n){"use strict";function r(e){return e&&e.__esModule?e:{default:e}}function a(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function o(e,t){if(!e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return!t||"object"!=typeof t&&"function"!=typeof t?e:t}function i(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function, not "+typeof t);e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}}),t&&(Object.setPrototypeOf?Object.setPrototypeOf(e,t):e.__proto__=t)}Object.defineProperty(t,"__esModule",{value:!0});var l=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e},u=function(){function e(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}return function(t,n,r){return n&&e(t.prototype,n),r&&e(t,r),t}}(),s=n(3),c=r(s),f=n(24),p=n(1),d=r(p),y=n(14),h=n(11),m={active:{base:"rgb(1,124,66)",hover:"rgb(1,124,66)"},inactive:{base:"rgb(65,66,68)",hover:"rgb(65,66,68)"},activeThumb:{base:"rgb(250,250,250)",hover:"rgb(250,250,250)"},inactiveThumb:{base:"rgb(250,250,250)",hover:"rgb(250,250,250)"}},v={},b=function(e){function t(e){a(this,t);var n=o(this,(t.__proto__||Object.getPrototypeOf(t)).call(this,e));return n.state={isHover:!1},n}return i(t,e),u(t,[{key:"onMouseOver",value:function(){this.setState({isHover:!0})}},{key:"onMouseOut",value:function(){this.setState({isHover:!1})}},{key:"_convertToRgb",value:function(e,t){if(e.indexOf("#")!=-1){var n=(0,h.hexToRGB)(e);return"rgb("+n.r+", "+n.g+", "+n.b+")"}return e.indexOf("rgb")==-1?t:e}},{key:"checkAllColors",value:function(e){var t=this;return Object.keys(e).forEach(function(n){t.checkColors(e,n)}),e}},{key:"checkColors",value:function(e,t){e[t]?e[t].hover?(e[t].base=this._convertToRgb(e[t].base,m[t].base),e[t].hover=this._convertToRgb(e[t].hover,m[t].hover)):e[t].base?(e[t].base=this._convertToRgb(e[t].base,m[t].base),e[t].hover=e[t].base):(console.warn('Color prop should have a "base" style and a "hover" style!'),e[t]=m[t]):e[t]=m[t]}},{key:"interpolateColorWithHover",value:function(e,t,n){var r=this.props.colors;return this.checkColors(r,t),this.checkColors(r,n),this.state.isHover?{backgroundColor:(0,h.interpolateColor)(e,r[t].hover,r[n].hover,0,400)}:{backgroundColor:(0,h.interpolateColor)(e,r[t].base,r[n].base,0,400)}}},{key:"makeStyle",value:function(e,t){return this.state.isHover?l({},e,t):e}},{key:"handleClick",value:function(e){e.target!==this._input&&(e.preventDefault(),this._input.focus(),this._input.click())}},{key:"render",value:function(){var e=this,t=this.props,n=t.internalSpringSetting,r=t.internalHoverSpringSetting,a=t.value,o=t.thumbAnimateRange,i=(t.isHover,t.containerStyle),u=t.trackStyle,s=t.animateTrackStyleToggle,p=t.animateTrackStyleHover,d=t.thumbStyleHover,h=t.trackStyleHover,m=t.activeLabelStyle,v=t.activeLabelStyleHover,b=t.activeLabel,g=t.inactiveLabelStyle,S=t.inactiveLabelStyleHover,T=t.inactiveLabel,O=t.thumbStyle,k=t.animateThumbStyleHover,w=t.animateThumbStyleToggle,I=t.thumbIcon,P=t.onClick,j=t.onToggle,_=t.passThroughInputProps,x=n,M=r;return c.default.createElement(f.Motion,{style:{opacity:(0,f.spring)(a?1:0,x),left:(0,f.spring)(a?10*o[1]:10*o[0],x),colorNumber:(0,f.spring)(a?0:400,x),toggleNumber:(0,f.spring)(a?400:0,x),hoverNumber:(0,f.spring)(this.state.isHover?400:0,M)}},function(t){var n=t.opacity,r=t.left,o=t.colorNumber,f=t.hoverNumber,x=t.toggleNumber;return c.default.createElement("div",{style:l({},e.makeStyle(l({},y.reactToggle,i))),onMouseOver:e.onMouseOver.bind(e),onMouseOut:e.onMouseOut.bind(e),onClick:e.handleClick.bind(e)},c.default.createElement("div",{style:l({},e.makeStyle(l({},y.reactToggleTrack,u,e.interpolateColorWithHover(o,"active","inactive"),s(x/400)),l({},h,p(f/400))))},c.default.createElement("div",{style:l({},e.makeStyle(l({},y.reactToggleOn,m),v),{opacity:n})},b),c.default.createElement("div",{style:l({},e.makeStyle(l({},y.reactToggleOff,g),S),{opacity:1-n})},T)),c.default.createElement("div",{style:y.reactThumbCenteringContainer},c.default.createElement("div",{style:l({},e.makeStyle(l({},y.reactToggleThumb,O,e.interpolateColorWithHover(o,"activeThumb","inactiveThumb"),w(x/400)),l({},d,k(f/400))),{position:"relative",left:Math.round(r/10)})},I)),c.default.createElement("input",l({ref:function(t){e._input=t},type:"checkbox",style:y.reactToggleScreenReaderOnly,onClick:function(e){P&&P(e),j(a)},value:a},_)))})}}]),t}(s.Component);b.defaultProps={value:!1,onToggle:function(){},colors:m,passThroughInputProps:{},activeLabel:"ON",containerStyle:v,activeLabelStyle:v,activeLabelStyleHover:v,inactiveLabel:"OFF",inactiveLabelStyle:v,inactiveLabelStyleHover:v,thumbStyle:v,thumbStyleHover:v,animateThumbStyleHover:function(){return{}},animateThumbStyleToggle:function(){return{}},trackStyle:v,trackStyleHover:v,animateTrackStyleHover:function(){return{}},animateTrackStyleToggle:function(){return{}},thumbAnimateRange:[1,33],internalSpringSetting:{stiffness:180,damping:22},internalHoverSpringSetting:{stiffness:180,damping:20}},b.displayName="Toggle",t.default=b,b.propTypes={value:d.default.bool.isRequired,onToggle:d.default.func.isRequired,passThroughInputProps:d.default.object,onClick:d.default.func,colors:d.default.object,activeLabel:d.default.oneOfType([d.default.string,d.default.object]),containerStyle:d.default.object,activeLabelStyle:d.default.object,activeLabelStyleHover:d.default.object,activeThumbStyle:d.default.object,activeThumbStyleHover:d.default.object,inactiveLabel:d.default.oneOfType([d.default.string,d.default.object]),inactiveLabelStyle:d.default.object,inactiveLabelStyleHover:d.default.object,thumbStyle:d.default.object,thumbStyleHover:d.default.object,trackStyle:d.default.object,trackStyleHover:d.default.object,animateThumbStyleHover:d.default.func,animateTrackStyleHover:d.default.func,animateTrackStyleToggle:d.default.func,animateThumbStyleToggle:d.default.func,internalSpringSetting:d.default.object,internalHoverSpringSetting:d.default.object,thumbIcon:d.default.oneOfType([d.default.string,d.default.object]),thumbAnimateRange:d.default.array}},function(e,t){"use strict";function n(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(t,"__esModule",{value:!0});var r=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e},a=(t.reactToggle=n({display:"flex",width:52,alignItems:"center",justifyContent:"flex-start",position:"relative",cursor:"pointer",backgroundColor:"transparent",border:0,padding:0,WebkitTouchCallout:"none",WebkitUserSelect:"none",KhtmlUserSelect:"none",MozUserSelect:"none",msUserSelect:"none",userSelect:"none",WebkitTapHighlightColor:"rgba(0,0,0,0)"},"WebkitTapHighlightColor","transparent"),{fontSize:11,display:"flex",alignItems:"center",justifyContent:"center",fontFamily:"'Helvetica Neue', Helvetica, sans-serif"});t.reactToggleScreenReaderOnly={border:0,clip:"rect(0 0 0 0)",height:1,margin:-1,overflow:"hidden",padding:0,position:"absolute",width:1},t.reactToggleTrack={width:"52px",height:"20px",padding:0,borderRadius:"26px",display:"flex",alignItems:"center",justifyContent:"center"},t.reactToggleOn=r({},a,{position:"relative",color:"#FAFAFA",marginTop:"auto",marginBottom:"auto",lineHeight:0,opacity:0,width:26,height:20,left:4}),t.reactToggleOff=r({},a,{position:"relative",color:"rgba(255,255,255,0.6)",bottom:"0px",marginTop:"auto",marginBottom:"auto",paddingRight:5,lineHeight:0,width:26,height:20}),t.reactToggleThumb={width:"18px",height:"18px",display:"flex",alignSelf:"center",boxShadow:"0 0 0 1px rgba(0,0,0,0.3)",borderRadius:"50%",WebkitBoxSizing:"border-box",MozBoxSizing:"border-box",boxSizing:"border-box"},t.reactThumbCenteringContainer={position:"absolute",height:"100%",top:0,left:0,display:"flex",flex:1,alignSelf:"stretch",alignItems:"center",justifyContent:"flex-start"}},function(e,t){"use strict";function n(e){return function(){return e}}var r=function(){};r.thatReturns=n,r.thatReturnsFalse=n(!1),r.thatReturnsTrue=n(!0),r.thatReturnsNull=n(null),r.thatReturnsThis=function(){return this},r.thatReturnsArgument=function(e){return e},e.exports=r},function(e,t,n){"use strict";function r(e,t,n,r,o,i,l,u){if(a(t),!e){var s;if(void 0===t)s=new Error("Minified exception occurred; use the non-minified dev environment for the full error message and additional helpful warnings.");else{var c=[n,r,o,i,l,u],f=0;s=new Error(t.replace(/%s/g,function(){return c[f++]})),s.name="Invariant Violation"}throw s.framesToPop=1,s}}var a=function(e){};e.exports=r},function(e,t,n){"use strict";var r=n(15),a=n(16),o=n(18);e.exports=function(){function e(e,t,n,r,i,l){l!==o&&a(!1,"Calling PropTypes validators directly is not supported by the `prop-types` package. Use PropTypes.checkPropTypes() to call them. Read more at http://fb.me/use-check-prop-types")}function t(){return e}e.isRequired=e;var n={array:e,bool:e,func:e,number:e,object:e,string:e,symbol:e,any:e,arrayOf:t,element:e,instanceOf:t,node:e,objectOf:t,oneOf:t,oneOfType:t,shape:t,exact:t};return n.checkPropTypes=r,n.PropTypes=n,n}},function(e,t){"use strict";var n="SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED";e.exports=n},function(e,t,n){(function(t){(function(){var n,r,a,o,i,l;"undefined"!=typeof performance&&null!==performance&&performance.now?e.exports=function(){return performance.now()}:"undefined"!=typeof t&&null!==t&&t.hrtime?(e.exports=function(){return(n()-i)/1e6},r=t.hrtime,n=function(){var e;return e=r(),1e9*e[0]+e[1]},o=n(),l=1e9*t.uptime(),i=o-l):Date.now?(e.exports=function(){return Date.now()-a},a=Date.now()):(e.exports=function(){return(new Date).getTime()-a},a=(new Date).getTime())}).call(this)}).call(t,n(9))},function(e,t,n){"use strict";function r(e){return e&&e.__esModule?e:{default:e}}function a(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function o(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function, not "+typeof t);e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}}),t&&(Object.setPrototypeOf?Object.setPrototypeOf(e,t):e.__proto__=t)}t.__esModule=!0;var i=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e},l=function(){function e(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}return function(t,n,r){return n&&e(t.prototype,n),r&&e(t,r),t}}(),u=n(6),s=r(u),c=n(2),f=r(c),p=n(8),d=r(p),y=n(4),h=r(y),m=n(5),v=r(m),b=n(7),g=r(b),S=n(3),T=r(S),O=n(1),k=r(O),w=1e3/60,I=function(e){function t(n){var r=this;a(this,t),e.call(this,n),this.wasAnimating=!1,this.animationID=null,this.prevTime=0,this.accumulatedTime=0,this.unreadPropStyle=null,this.clearUnreadPropStyle=function(e){var t=!1,n=r.state,a=n.currentStyle,o=n.currentVelocity,l=n.lastIdealStyle,u=n.lastIdealVelocity;for(var s in e)if(Object.prototype.hasOwnProperty.call(e,s)){var c=e[s];"number"==typeof c&&(t||(t=!0,a=i({},a),o=i({},o),l=i({},l),u=i({},u)),a[s]=c,o[s]=0,l[s]=c,u[s]=0)}t&&r.setState({currentStyle:a,currentVelocity:o,lastIdealStyle:l,lastIdealVelocity:u})},this.startAnimationIfNecessary=function(){r.animationID=v.default(function(e){var t=r.props.style;if(g.default(r.state.currentStyle,t,r.state.currentVelocity))return r.wasAnimating&&r.props.onRest&&r.props.onRest(),r.animationID=null,r.wasAnimating=!1,void(r.accumulatedTime=0);r.wasAnimating=!0;var n=e||h.default(),a=n-r.prevTime;if(r.prevTime=n,r.accumulatedTime=r.accumulatedTime+a,r.accumulatedTime>10*w&&(r.accumulatedTime=0),0===r.accumulatedTime)return r.animationID=null,void r.startAnimationIfNecessary();var o=(r.accumulatedTime-Math.floor(r.accumulatedTime/w)*w)/w,i=Math.floor(r.accumulatedTime/w),l={},u={},s={},c={};for(var f in t)if(Object.prototype.hasOwnProperty.call(t,f)){var p=t[f];if("number"==typeof p)s[f]=p,c[f]=0,l[f]=p,u[f]=0;else{for(var y=r.state.lastIdealStyle[f],m=r.state.lastIdealVelocity[f],v=0;v<i;v++){var b=d.default(w/1e3,y,m,p.val,p.stiffness,p.damping,p.precision);y=b[0],m=b[1]}var S=d.default(w/1e3,y,m,p.val,p.stiffness,p.damping,p.precision),T=S[0],O=S[1];s[f]=y+(T-y)*o,c[f]=m+(O-m)*o,l[f]=y,u[f]=m}}r.animationID=null,r.accumulatedTime-=i*w,r.setState({currentStyle:s,currentVelocity:c,lastIdealStyle:l,lastIdealVelocity:u}),r.unreadPropStyle=null,r.startAnimationIfNecessary()})},this.state=this.defaultState()}return o(t,e),l(t,null,[{key:"propTypes",value:{defaultStyle:k.default.objectOf(k.default.number),style:k.default.objectOf(k.default.oneOfType([k.default.number,k.default.object])).isRequired,children:k.default.func.isRequired,onRest:k.default.func},enumerable:!0}]),t.prototype.defaultState=function(){var e=this.props,t=e.defaultStyle,n=e.style,r=t||f.default(n),a=s.default(r);return{currentStyle:r,currentVelocity:a,lastIdealStyle:r,lastIdealVelocity:a}},t.prototype.componentDidMount=function(){this.prevTime=h.default(),this.startAnimationIfNecessary()},t.prototype.componentWillReceiveProps=function(e){null!=this.unreadPropStyle&&this.clearUnreadPropStyle(this.unreadPropStyle),this.unreadPropStyle=e.style,null==this.animationID&&(this.prevTime=h.default(),this.startAnimationIfNecessary())},t.prototype.componentWillUnmount=function(){null!=this.animationID&&(v.default.cancel(this.animationID),this.animationID=null)},t.prototype.render=function(){var e=this.props.children(this.state.currentStyle);return e&&T.default.Children.only(e)},t}(T.default.Component);t.default=I,e.exports=t.default},function(e,t,n){"use strict";function r(e){return e&&e.__esModule?e:{default:e}}function a(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function o(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function, not "+typeof t);e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}}),t&&(Object.setPrototypeOf?Object.setPrototypeOf(e,t):e.__proto__=t)}function i(e,t,n){for(var r=0;r<e.length;r++)if(!S.default(e[r],t[r],n[r]))return!1;return!0}t.__esModule=!0;var l=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e},u=function(){function e(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}return function(t,n,r){return n&&e(t.prototype,n),r&&e(t,r),t}}(),s=n(6),c=r(s),f=n(2),p=r(f),d=n(8),y=r(d),h=n(4),m=r(h),v=n(5),b=r(v),g=n(7),S=r(g),T=n(3),O=r(T),k=n(1),w=r(k),I=1e3/60,P=function(e){function t(n){var r=this;a(this,t),e.call(this,n),this.animationID=null,this.prevTime=0,this.accumulatedTime=0,this.unreadPropStyles=null,this.clearUnreadPropStyle=function(e){for(var t=r.state,n=t.currentStyles,a=t.currentVelocities,o=t.lastIdealStyles,i=t.lastIdealVelocities,u=!1,s=0;s<e.length;s++){var c=e[s],f=!1;for(var p in c)if(Object.prototype.hasOwnProperty.call(c,p)){var d=c[p];"number"==typeof d&&(f||(f=!0,u=!0,n[s]=l({},n[s]),a[s]=l({},a[s]),o[s]=l({},o[s]),i[s]=l({},i[s])),n[s][p]=d,a[s][p]=0,o[s][p]=d,i[s][p]=0)}}u&&r.setState({currentStyles:n,currentVelocities:a,lastIdealStyles:o,lastIdealVelocities:i})},this.startAnimationIfNecessary=function(){r.animationID=b.default(function(e){var t=r.props.styles(r.state.lastIdealStyles);if(i(r.state.currentStyles,t,r.state.currentVelocities))return r.animationID=null,void(r.accumulatedTime=0);var n=e||m.default(),a=n-r.prevTime;if(r.prevTime=n,r.accumulatedTime=r.accumulatedTime+a,r.accumulatedTime>10*I&&(r.accumulatedTime=0),0===r.accumulatedTime)return r.animationID=null,void r.startAnimationIfNecessary();for(var o=(r.accumulatedTime-Math.floor(r.accumulatedTime/I)*I)/I,l=Math.floor(r.accumulatedTime/I),u=[],s=[],c=[],f=[],p=0;p<t.length;p++){var d=t[p],h={},v={},b={},g={};for(var S in d)if(Object.prototype.hasOwnProperty.call(d,S)){var T=d[S];if("number"==typeof T)h[S]=T,v[S]=0,b[S]=T,g[S]=0;else{for(var O=r.state.lastIdealStyles[p][S],k=r.state.lastIdealVelocities[p][S],w=0;w<l;w++){var P=y.default(I/1e3,O,k,T.val,T.stiffness,T.damping,T.precision);O=P[0],k=P[1]}var j=y.default(I/1e3,O,k,T.val,T.stiffness,T.damping,T.precision),_=j[0],x=j[1];h[S]=O+(_-O)*o,v[S]=k+(x-k)*o,b[S]=O,g[S]=k}}c[p]=h,f[p]=v,u[p]=b,s[p]=g}r.animationID=null,r.accumulatedTime-=l*I,r.setState({currentStyles:c,currentVelocities:f,lastIdealStyles:u,lastIdealVelocities:s}),r.unreadPropStyles=null,r.startAnimationIfNecessary()})},this.state=this.defaultState()}return o(t,e),u(t,null,[{key:"propTypes",value:{defaultStyles:w.default.arrayOf(w.default.objectOf(w.default.number)),styles:w.default.func.isRequired,children:w.default.func.isRequired},enumerable:!0}]),t.prototype.defaultState=function(){var e=this.props,t=e.defaultStyles,n=e.styles,r=t||n().map(p.default),a=r.map(function(e){return c.default(e)});return{currentStyles:r,currentVelocities:a,lastIdealStyles:r,lastIdealVelocities:a}},t.prototype.componentDidMount=function(){this.prevTime=m.default(),this.startAnimationIfNecessary()},t.prototype.componentWillReceiveProps=function(e){null!=this.unreadPropStyles&&this.clearUnreadPropStyle(this.unreadPropStyles),this.unreadPropStyles=e.styles(this.state.lastIdealStyles),null==this.animationID&&(this.prevTime=m.default(),this.startAnimationIfNecessary())},t.prototype.componentWillUnmount=function(){null!=this.animationID&&(b.default.cancel(this.animationID),this.animationID=null)},t.prototype.render=function(){var e=this.props.children(this.state.currentStyles);return e&&O.default.Children.only(e)},t}(O.default.Component);t.default=P,e.exports=t.default},function(e,t,n){"use strict";function r(e){return e&&e.__esModule?e:{default:e}}function a(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function o(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function, not "+typeof t);e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}}),t&&(Object.setPrototypeOf?Object.setPrototypeOf(e,t):e.__proto__=t)}function i(e,t,n){var r=t;return null==r?e.map(function(e,t){return{key:e.key,data:e.data,style:n[t]}}):e.map(function(e,t){for(var a=0;a<r.length;a++)if(r[a].key===e.key)return{key:r[a].key,data:r[a].data,style:n[t]};return{key:e.key,data:e.data,style:n[t]}})}function l(e,t,n,r){if(r.length!==t.length)return!1;for(var a=0;a<r.length;a++)if(r[a].key!==t[a].key)return!1;for(var a=0;a<r.length;a++)if(!w.default(e[a],t[a].style,n[a]))return!1;return!0}function u(e,t,n,r,a,o,i,l,u){for(var s=b.default(r,a,function(e,r){var a=t(r);return null==a?(n({key:r.key,data:r.data}),null):w.default(o[e],a,i[e])?(n({key:r.key,data:r.data}),null):{key:r.key,data:r.data,style:a}}),c=[],f=[],d=[],y=[],h=0;h<s.length;h++){for(var m=s[h],v=null,g=0;g<r.length;g++)if(r[g].key===m.key){v=g;break}if(null==v){var S=e(m);c[h]=S,d[h]=S;var T=p.default(m.style);f[h]=T,y[h]=T}else c[h]=o[v],d[h]=l[v],f[h]=i[v],y[h]=u[v]}return[s,c,f,d,y]}t.__esModule=!0;var s=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e},c=function(){function e(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}return function(t,n,r){return n&&e(t.prototype,n),r&&e(t,r),t}}(),f=n(6),p=r(f),d=n(2),y=r(d),h=n(8),m=r(h),v=n(23),b=r(v),g=n(4),S=r(g),T=n(5),O=r(T),k=n(7),w=r(k),I=n(3),P=r(I),j=n(1),_=r(j),x=1e3/60,M=function(e){function t(n){var r=this;a(this,t),e.call(this,n),this.unmounting=!1,this.animationID=null,this.prevTime=0,this.accumulatedTime=0,this.unreadPropStyles=null,this.clearUnreadPropStyle=function(e){for(var t=u(r.props.willEnter,r.props.willLeave,r.props.didLeave,r.state.mergedPropsStyles,e,r.state.currentStyles,r.state.currentVelocities,r.state.lastIdealStyles,r.state.lastIdealVelocities),n=t[0],a=t[1],o=t[2],i=t[3],l=t[4],c=0;c<e.length;c++){var f=e[c].style,p=!1;for(var d in f)if(Object.prototype.hasOwnProperty.call(f,d)){var y=f[d];"number"==typeof y&&(p||(p=!0,a[c]=s({},a[c]),o[c]=s({},o[c]),i[c]=s({},i[c]),l[c]=s({},l[c]),n[c]={key:n[c].key,data:n[c].data,style:s({},n[c].style)}),a[c][d]=y,o[c][d]=0,i[c][d]=y,l[c][d]=0,n[c].style[d]=y)}}r.setState({currentStyles:a,currentVelocities:o,mergedPropsStyles:n,lastIdealStyles:i,lastIdealVelocities:l})},this.startAnimationIfNecessary=function(){r.unmounting||(r.animationID=O.default(function(e){if(!r.unmounting){var t=r.props.styles,n="function"==typeof t?t(i(r.state.mergedPropsStyles,r.unreadPropStyles,r.state.lastIdealStyles)):t;if(l(r.state.currentStyles,n,r.state.currentVelocities,r.state.mergedPropsStyles))return r.animationID=null,void(r.accumulatedTime=0);var a=e||S.default(),o=a-r.prevTime;if(r.prevTime=a,r.accumulatedTime=r.accumulatedTime+o,r.accumulatedTime>10*x&&(r.accumulatedTime=0),0===r.accumulatedTime)return r.animationID=null,void r.startAnimationIfNecessary();for(var s=(r.accumulatedTime-Math.floor(r.accumulatedTime/x)*x)/x,c=Math.floor(r.accumulatedTime/x),f=u(r.props.willEnter,r.props.willLeave,r.props.didLeave,r.state.mergedPropsStyles,n,r.state.currentStyles,r.state.currentVelocities,r.state.lastIdealStyles,r.state.lastIdealVelocities),p=f[0],d=f[1],y=f[2],h=f[3],v=f[4],b=0;b<p.length;b++){var g=p[b].style,T={},O={},k={},w={};for(var I in g)if(Object.prototype.hasOwnProperty.call(g,I)){var P=g[I];if("number"==typeof P)T[I]=P,O[I]=0,k[I]=P,w[I]=0;else{for(var j=h[b][I],_=v[b][I],M=0;M<c;M++){var R=m.default(x/1e3,j,_,P.val,P.stiffness,P.damping,P.precision);j=R[0],_=R[1]}var C=m.default(x/1e3,j,_,P.val,P.stiffness,P.damping,P.precision),D=C[0],H=C[1];T[I]=j+(D-j)*s,O[I]=_+(H-_)*s,k[I]=j,w[I]=_}}h[b]=k,v[b]=w,d[b]=T,y[b]=O}r.animationID=null,r.accumulatedTime-=c*x,r.setState({currentStyles:d,currentVelocities:y,lastIdealStyles:h,lastIdealVelocities:v,mergedPropsStyles:p}),r.unreadPropStyles=null,r.startAnimationIfNecessary()}}))},this.state=this.defaultState()}return o(t,e),c(t,null,[{key:"propTypes",value:{defaultStyles:_.default.arrayOf(_.default.shape({key:_.default.string.isRequired,data:_.default.any,style:_.default.objectOf(_.default.number).isRequired})),styles:_.default.oneOfType([_.default.func,_.default.arrayOf(_.default.shape({key:_.default.string.isRequired,data:_.default.any,style:_.default.objectOf(_.default.oneOfType([_.default.number,_.default.object])).isRequired}))]).isRequired,children:_.default.func.isRequired,willEnter:_.default.func,willLeave:_.default.func,didLeave:_.default.func},enumerable:!0},{key:"defaultProps",value:{willEnter:function(e){return y.default(e.style)},willLeave:function(){return null},didLeave:function(){}},enumerable:!0}]),t.prototype.defaultState=function(){var e=this.props,t=e.defaultStyles,n=e.styles,r=e.willEnter,a=e.willLeave,o=e.didLeave,i="function"==typeof n?n(t):n,l=void 0;l=null==t?i:t.map(function(e){for(var t=0;t<i.length;t++)if(i[t].key===e.key)return i[t];return e});var s=null==t?i.map(function(e){return y.default(e.style)}):t.map(function(e){return y.default(e.style)}),c=null==t?i.map(function(e){return p.default(e.style)}):t.map(function(e){return p.default(e.style)}),f=u(r,a,o,l,i,s,c,s,c),d=f[0],h=f[1],m=f[2],v=f[3],b=f[4];return{currentStyles:h,currentVelocities:m,lastIdealStyles:v,lastIdealVelocities:b,mergedPropsStyles:d}},t.prototype.componentDidMount=function(){this.prevTime=S.default(),this.startAnimationIfNecessary()},t.prototype.componentWillReceiveProps=function(e){this.unreadPropStyles&&this.clearUnreadPropStyle(this.unreadPropStyles);var t=e.styles;"function"==typeof t?this.unreadPropStyles=t(i(this.state.mergedPropsStyles,this.unreadPropStyles,this.state.lastIdealStyles)):this.unreadPropStyles=t,null==this.animationID&&(this.prevTime=S.default(),this.startAnimationIfNecessary())},t.prototype.componentWillUnmount=function(){this.unmounting=!0,null!=this.animationID&&(O.default.cancel(this.animationID),this.animationID=null)},t.prototype.render=function(){var e=i(this.state.mergedPropsStyles,this.unreadPropStyles,this.state.currentStyles),t=this.props.children(e);return t&&P.default.Children.only(t)},t}(P.default.Component);t.default=M,e.exports=t.default},function(e,t){"use strict";function n(e,t,n){for(var r={},a=0;a<e.length;a++)r[e[a].key]=a;for(var o={},a=0;a<t.length;a++)o[t[a].key]=a;for(var i=[],a=0;a<t.length;a++)i[a]=t[a];for(var a=0;a<e.length;a++)if(!Object.prototype.hasOwnProperty.call(o,e[a].key)){var l=n(a,e[a]);null!=l&&i.push(l)}return i.sort(function(e,n){var a=o[e.key],i=o[n.key],l=r[e.key],u=r[n.key];if(null!=a&&null!=i)return o[e.key]-o[n.key];if(null!=l&&null!=u)return r[e.key]-r[n.key];if(null!=a){for(var s=0;s<t.length;s++){var c=t[s].key;if(Object.prototype.hasOwnProperty.call(r,c)){if(a<o[c]&&u>r[c])return-1;if(a>o[c]&&u<r[c])return 1}}return 1}for(var s=0;s<t.length;s++){var c=t[s].key;if(Object.prototype.hasOwnProperty.call(r,c)){if(i<o[c]&&l>r[c])return 1;if(i>o[c]&&l<r[c])return-1}}return-1})}t.__esModule=!0,t.default=n,e.exports=t.default},function(e,t,n){"use strict";function r(e){return e&&e.__esModule?e.default:e}t.__esModule=!0;var a=n(20);t.Motion=r(a);var o=n(21);t.StaggeredMotion=r(o);var i=n(22);t.TransitionMotion=r(i);var l=n(26);t.spring=r(l);var u=n(10);t.presets=r(u);var s=n(2);t.stripStyle=r(s);var c=n(25);
t.reorderKeys=r(c)},function(e,t,n){"use strict";function r(){}t.__esModule=!0,t.default=r,e.exports=t.default},function(e,t,n){"use strict";function r(e){return e&&e.__esModule?e:{default:e}}function a(e,t){return o({},u,t,{val:e})}t.__esModule=!0;var o=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e};t.default=a;var i=n(10),l=r(i),u=o({},l.default.noWobble,{precision:.01});e.exports=t.default}])});
      };
    };
  }
  }
}, {package:"react-toggle-button",file:"node_modules\\react-toggle-button\\lib\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\react-transition-group\\cjs\\CSSTransition.js", {"./Transition":"D:\\code\\v\\metamask-extension\\node_modules\\react-transition-group\\cjs\\Transition.js","./utils/PropTypes":"D:\\code\\v\\metamask-extension\\node_modules\\react-transition-group\\cjs\\utils\\PropTypes.js","./utils/reflow":"D:\\code\\v\\metamask-extension\\node_modules\\react-transition-group\\cjs\\utils\\reflow.js","dom-helpers/addClass":"D:\\code\\v\\metamask-extension\\node_modules\\dom-helpers\\cjs\\addClass.js","dom-helpers/removeClass":"D:\\code\\v\\metamask-extension\\node_modules\\dom-helpers\\cjs\\removeClass.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Creact-transition-group%5Ccjs%5CCSSTransition.js
      return function (require, module, exports) {
"use strict";

exports.__esModule = true;
exports.default = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _addClass2 = _interopRequireDefault(require("dom-helpers/addClass"));

var _removeClass = _interopRequireDefault(require("dom-helpers/removeClass"));

var _react = _interopRequireDefault(require("react"));

var _Transition = _interopRequireDefault(require("./Transition"));

var _PropTypes = require("./utils/PropTypes");

var _reflow = require("./utils/reflow");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

var _addClass = function addClass(node, classes) {
  return node && classes && classes.split(' ').forEach(function (c) {
    return (0, _addClass2.default)(node, c);
  });
};

var removeClass = function removeClass(node, classes) {
  return node && classes && classes.split(' ').forEach(function (c) {
    return (0, _removeClass.default)(node, c);
  });
};
/**
 * A transition component inspired by the excellent
 * [ng-animate](https://docs.angularjs.org/api/ngAnimate) library, you should
 * use it if you're using CSS transitions or animations. It's built upon the
 * [`Transition`](https://reactcommunity.org/react-transition-group/transition)
 * component, so it inherits all of its props.
 *
 * `CSSTransition` applies a pair of class names during the `appear`, `enter`,
 * and `exit` states of the transition. The first class is applied and then a
 * second `*-active` class in order to activate the CSS transition. After the
 * transition, matching `*-done` class names are applied to persist the
 * transition state.
 *
 * ```jsx
 * function App() {
 *   const [inProp, setInProp] = useState(false);
 *   return (
 *     <div>
 *       <CSSTransition in={inProp} timeout={200} classNames="my-node">
 *         <div>
 *           {"I'll receive my-node-* classes"}
 *         </div>
 *       </CSSTransition>
 *       <button type="button" onClick={() => setInProp(true)}>
 *         Click to Enter
 *       </button>
 *     </div>
 *   );
 * }
 * ```
 *
 * When the `in` prop is set to `true`, the child component will first receive
 * the class `example-enter`, then the `example-enter-active` will be added in
 * the next tick. `CSSTransition` [forces a
 * reflow](https://github.com/reactjs/react-transition-group/blob/5007303e729a74be66a21c3e2205e4916821524b/src/CSSTransition.js#L208-L215)
 * between before adding the `example-enter-active`. This is an important trick
 * because it allows us to transition between `example-enter` and
 * `example-enter-active` even though they were added immediately one after
 * another. Most notably, this is what makes it possible for us to animate
 * _appearance_.
 *
 * ```css
 * .my-node-enter {
 *   opacity: 0;
 * }
 * .my-node-enter-active {
 *   opacity: 1;
 *   transition: opacity 200ms;
 * }
 * .my-node-exit {
 *   opacity: 1;
 * }
 * .my-node-exit-active {
 *   opacity: 0;
 *   transition: opacity 200ms;
 * }
 * ```
 *
 * `*-active` classes represent which styles you want to animate **to**, so it's
 * important to add `transition` declaration only to them, otherwise transitions
 * might not behave as intended! This might not be obvious when the transitions
 * are symmetrical, i.e. when `*-enter-active` is the same as `*-exit`, like in
 * the example above (minus `transition`), but it becomes apparent in more
 * complex transitions.
 *
 * **Note**: If you're using the
 * [`appear`](http://reactcommunity.org/react-transition-group/transition#Transition-prop-appear)
 * prop, make sure to define styles for `.appear-*` classes as well.
 */


var CSSTransition = /*#__PURE__*/function (_React$Component) {
  _inheritsLoose(CSSTransition, _React$Component);

  function CSSTransition() {
    var _this;

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _React$Component.call.apply(_React$Component, [this].concat(args)) || this;
    _this.appliedClasses = {
      appear: {},
      enter: {},
      exit: {}
    };

    _this.onEnter = function (maybeNode, maybeAppearing) {
      var _this$resolveArgument = _this.resolveArguments(maybeNode, maybeAppearing),
          node = _this$resolveArgument[0],
          appearing = _this$resolveArgument[1];

      _this.removeClasses(node, 'exit');

      _this.addClass(node, appearing ? 'appear' : 'enter', 'base');

      if (_this.props.onEnter) {
        _this.props.onEnter(maybeNode, maybeAppearing);
      }
    };

    _this.onEntering = function (maybeNode, maybeAppearing) {
      var _this$resolveArgument2 = _this.resolveArguments(maybeNode, maybeAppearing),
          node = _this$resolveArgument2[0],
          appearing = _this$resolveArgument2[1];

      var type = appearing ? 'appear' : 'enter';

      _this.addClass(node, type, 'active');

      if (_this.props.onEntering) {
        _this.props.onEntering(maybeNode, maybeAppearing);
      }
    };

    _this.onEntered = function (maybeNode, maybeAppearing) {
      var _this$resolveArgument3 = _this.resolveArguments(maybeNode, maybeAppearing),
          node = _this$resolveArgument3[0],
          appearing = _this$resolveArgument3[1];

      var type = appearing ? 'appear' : 'enter';

      _this.removeClasses(node, type);

      _this.addClass(node, type, 'done');

      if (_this.props.onEntered) {
        _this.props.onEntered(maybeNode, maybeAppearing);
      }
    };

    _this.onExit = function (maybeNode) {
      var _this$resolveArgument4 = _this.resolveArguments(maybeNode),
          node = _this$resolveArgument4[0];

      _this.removeClasses(node, 'appear');

      _this.removeClasses(node, 'enter');

      _this.addClass(node, 'exit', 'base');

      if (_this.props.onExit) {
        _this.props.onExit(maybeNode);
      }
    };

    _this.onExiting = function (maybeNode) {
      var _this$resolveArgument5 = _this.resolveArguments(maybeNode),
          node = _this$resolveArgument5[0];

      _this.addClass(node, 'exit', 'active');

      if (_this.props.onExiting) {
        _this.props.onExiting(maybeNode);
      }
    };

    _this.onExited = function (maybeNode) {
      var _this$resolveArgument6 = _this.resolveArguments(maybeNode),
          node = _this$resolveArgument6[0];

      _this.removeClasses(node, 'exit');

      _this.addClass(node, 'exit', 'done');

      if (_this.props.onExited) {
        _this.props.onExited(maybeNode);
      }
    };

    _this.resolveArguments = function (maybeNode, maybeAppearing) {
      return _this.props.nodeRef ? [_this.props.nodeRef.current, maybeNode] // here `maybeNode` is actually `appearing`
      : [maybeNode, maybeAppearing];
    };

    _this.getClassNames = function (type) {
      var classNames = _this.props.classNames;
      var isStringClassNames = typeof classNames === 'string';
      var prefix = isStringClassNames && classNames ? classNames + "-" : '';
      var baseClassName = isStringClassNames ? "" + prefix + type : classNames[type];
      var activeClassName = isStringClassNames ? baseClassName + "-active" : classNames[type + "Active"];
      var doneClassName = isStringClassNames ? baseClassName + "-done" : classNames[type + "Done"];
      return {
        baseClassName: baseClassName,
        activeClassName: activeClassName,
        doneClassName: doneClassName
      };
    };

    return _this;
  }

  var _proto = CSSTransition.prototype;

  _proto.addClass = function addClass(node, type, phase) {
    var className = this.getClassNames(type)[phase + "ClassName"];

    var _this$getClassNames = this.getClassNames('enter'),
        doneClassName = _this$getClassNames.doneClassName;

    if (type === 'appear' && phase === 'done' && doneClassName) {
      className += " " + doneClassName;
    } // This is to force a repaint,
    // which is necessary in order to transition styles when adding a class name.


    if (phase === 'active') {
      if (node) (0, _reflow.forceReflow)(node);
    }

    if (className) {
      this.appliedClasses[type][phase] = className;

      _addClass(node, className);
    }
  };

  _proto.removeClasses = function removeClasses(node, type) {
    var _this$appliedClasses$ = this.appliedClasses[type],
        baseClassName = _this$appliedClasses$.base,
        activeClassName = _this$appliedClasses$.active,
        doneClassName = _this$appliedClasses$.done;
    this.appliedClasses[type] = {};

    if (baseClassName) {
      removeClass(node, baseClassName);
    }

    if (activeClassName) {
      removeClass(node, activeClassName);
    }

    if (doneClassName) {
      removeClass(node, doneClassName);
    }
  };

  _proto.render = function render() {
    var _this$props = this.props,
        _ = _this$props.classNames,
        props = _objectWithoutPropertiesLoose(_this$props, ["classNames"]);

    return /*#__PURE__*/_react.default.createElement(_Transition.default, _extends({}, props, {
      onEnter: this.onEnter,
      onEntered: this.onEntered,
      onEntering: this.onEntering,
      onExit: this.onExit,
      onExiting: this.onExiting,
      onExited: this.onExited
    }));
  };

  return CSSTransition;
}(_react.default.Component);

CSSTransition.defaultProps = {
  classNames: ''
};
CSSTransition.propTypes = "development" !== "production" ? _extends({}, _Transition.default.propTypes, {
  /**
   * The animation classNames applied to the component as it appears, enters,
   * exits or has finished the transition. A single name can be provided, which
   * will be suffixed for each stage, e.g. `classNames="fade"` applies:
   *
   * - `fade-appear`, `fade-appear-active`, `fade-appear-done`
   * - `fade-enter`, `fade-enter-active`, `fade-enter-done`
   * - `fade-exit`, `fade-exit-active`, `fade-exit-done`
   *
   * A few details to note about how these classes are applied:
   *
   * 1. They are _joined_ with the ones that are already defined on the child
   *    component, so if you want to add some base styles, you can use
   *    `className` without worrying that it will be overridden.
   *
   * 2. If the transition component mounts with `in={false}`, no classes are
   *    applied yet. You might be expecting `*-exit-done`, but if you think
   *    about it, a component cannot finish exiting if it hasn't entered yet.
   *
   * 2. `fade-appear-done` and `fade-enter-done` will _both_ be applied. This
   *    allows you to define different behavior for when appearing is done and
   *    when regular entering is done, using selectors like
   *    `.fade-enter-done:not(.fade-appear-done)`. For example, you could apply
   *    an epic entrance animation when element first appears in the DOM using
   *    [Animate.css](https://daneden.github.io/animate.css/). Otherwise you can
   *    simply use `fade-enter-done` for defining both cases.
   *
   * Each individual classNames can also be specified independently like:
   *
   * ```js
   * classNames={{
   *  appear: 'my-appear',
   *  appearActive: 'my-active-appear',
   *  appearDone: 'my-done-appear',
   *  enter: 'my-enter',
   *  enterActive: 'my-active-enter',
   *  enterDone: 'my-done-enter',
   *  exit: 'my-exit',
   *  exitActive: 'my-active-exit',
   *  exitDone: 'my-done-exit',
   * }}
   * ```
   *
   * If you want to set these classes using CSS Modules:
   *
   * ```js
   * import styles from './styles.css';
   * ```
   *
   * you might want to use camelCase in your CSS file, that way could simply
   * spread them instead of listing them one by one:
   *
   * ```js
   * classNames={{ ...styles }}
   * ```
   *
   * @type {string | {
   *  appear?: string,
   *  appearActive?: string,
   *  appearDone?: string,
   *  enter?: string,
   *  enterActive?: string,
   *  enterDone?: string,
   *  exit?: string,
   *  exitActive?: string,
   *  exitDone?: string,
   * }}
   */
  classNames: _PropTypes.classNamesShape,

  /**
   * A `<Transition>` callback fired immediately after the 'enter' or 'appear' class is
   * applied.
   *
   * **Note**: when `nodeRef` prop is passed, `node` is not passed.
   *
   * @type Function(node: HtmlElement, isAppearing: bool)
   */
  onEnter: _propTypes.default.func,

  /**
   * A `<Transition>` callback fired immediately after the 'enter-active' or
   * 'appear-active' class is applied.
   *
   * **Note**: when `nodeRef` prop is passed, `node` is not passed.
   *
   * @type Function(node: HtmlElement, isAppearing: bool)
   */
  onEntering: _propTypes.default.func,

  /**
   * A `<Transition>` callback fired immediately after the 'enter' or
   * 'appear' classes are **removed** and the `done` class is added to the DOM node.
   *
   * **Note**: when `nodeRef` prop is passed, `node` is not passed.
   *
   * @type Function(node: HtmlElement, isAppearing: bool)
   */
  onEntered: _propTypes.default.func,

  /**
   * A `<Transition>` callback fired immediately after the 'exit' class is
   * applied.
   *
   * **Note**: when `nodeRef` prop is passed, `node` is not passed
   *
   * @type Function(node: HtmlElement)
   */
  onExit: _propTypes.default.func,

  /**
   * A `<Transition>` callback fired immediately after the 'exit-active' is applied.
   *
   * **Note**: when `nodeRef` prop is passed, `node` is not passed
   *
   * @type Function(node: HtmlElement)
   */
  onExiting: _propTypes.default.func,

  /**
   * A `<Transition>` callback fired immediately after the 'exit' classes
   * are **removed** and the `exit-done` class is added to the DOM node.
   *
   * **Note**: when `nodeRef` prop is passed, `node` is not passed
   *
   * @type Function(node: HtmlElement)
   */
  onExited: _propTypes.default.func
}) : {};
var _default = CSSTransition;
exports.default = _default;
module.exports = exports.default;
      };
    };
  }
  }
}, {package:"react-transition-group",file:"node_modules\\react-transition-group\\cjs\\CSSTransition.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\react-transition-group\\cjs\\ReplaceTransition.js", {"./TransitionGroup":"D:\\code\\v\\metamask-extension\\node_modules\\react-transition-group\\cjs\\TransitionGroup.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Creact-transition-group%5Ccjs%5CReplaceTransition.js
      return function (require, module, exports) {
"use strict";

exports.__esModule = true;
exports.default = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _TransitionGroup = _interopRequireDefault(require("./TransitionGroup"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

/**
 * The `<ReplaceTransition>` component is a specialized `Transition` component
 * that animates between two children.
 *
 * ```jsx
 * <ReplaceTransition in>
 *   <Fade><div>I appear first</div></Fade>
 *   <Fade><div>I replace the above</div></Fade>
 * </ReplaceTransition>
 * ```
 */
var ReplaceTransition = /*#__PURE__*/function (_React$Component) {
  _inheritsLoose(ReplaceTransition, _React$Component);

  function ReplaceTransition() {
    var _this;

    for (var _len = arguments.length, _args = new Array(_len), _key = 0; _key < _len; _key++) {
      _args[_key] = arguments[_key];
    }

    _this = _React$Component.call.apply(_React$Component, [this].concat(_args)) || this;

    _this.handleEnter = function () {
      for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }

      return _this.handleLifecycle('onEnter', 0, args);
    };

    _this.handleEntering = function () {
      for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
        args[_key3] = arguments[_key3];
      }

      return _this.handleLifecycle('onEntering', 0, args);
    };

    _this.handleEntered = function () {
      for (var _len4 = arguments.length, args = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
        args[_key4] = arguments[_key4];
      }

      return _this.handleLifecycle('onEntered', 0, args);
    };

    _this.handleExit = function () {
      for (var _len5 = arguments.length, args = new Array(_len5), _key5 = 0; _key5 < _len5; _key5++) {
        args[_key5] = arguments[_key5];
      }

      return _this.handleLifecycle('onExit', 1, args);
    };

    _this.handleExiting = function () {
      for (var _len6 = arguments.length, args = new Array(_len6), _key6 = 0; _key6 < _len6; _key6++) {
        args[_key6] = arguments[_key6];
      }

      return _this.handleLifecycle('onExiting', 1, args);
    };

    _this.handleExited = function () {
      for (var _len7 = arguments.length, args = new Array(_len7), _key7 = 0; _key7 < _len7; _key7++) {
        args[_key7] = arguments[_key7];
      }

      return _this.handleLifecycle('onExited', 1, args);
    };

    return _this;
  }

  var _proto = ReplaceTransition.prototype;

  _proto.handleLifecycle = function handleLifecycle(handler, idx, originalArgs) {
    var _child$props;

    var children = this.props.children;

    var child = _react.default.Children.toArray(children)[idx];

    if (child.props[handler]) (_child$props = child.props)[handler].apply(_child$props, originalArgs);

    if (this.props[handler]) {
      var maybeNode = child.props.nodeRef ? undefined : _reactDom.default.findDOMNode(this);
      this.props[handler](maybeNode);
    }
  };

  _proto.render = function render() {
    var _this$props = this.props,
        children = _this$props.children,
        inProp = _this$props.in,
        props = _objectWithoutPropertiesLoose(_this$props, ["children", "in"]);

    var _React$Children$toArr = _react.default.Children.toArray(children),
        first = _React$Children$toArr[0],
        second = _React$Children$toArr[1];

    delete props.onEnter;
    delete props.onEntering;
    delete props.onEntered;
    delete props.onExit;
    delete props.onExiting;
    delete props.onExited;
    return /*#__PURE__*/_react.default.createElement(_TransitionGroup.default, props, inProp ? _react.default.cloneElement(first, {
      key: 'first',
      onEnter: this.handleEnter,
      onEntering: this.handleEntering,
      onEntered: this.handleEntered
    }) : _react.default.cloneElement(second, {
      key: 'second',
      onEnter: this.handleExit,
      onEntering: this.handleExiting,
      onEntered: this.handleExited
    }));
  };

  return ReplaceTransition;
}(_react.default.Component);

ReplaceTransition.propTypes = "development" !== "production" ? {
  in: _propTypes.default.bool.isRequired,
  children: function children(props, propName) {
    if (_react.default.Children.count(props[propName]) !== 2) return new Error("\"" + propName + "\" must be exactly two transition components.");
    return null;
  }
} : {};
var _default = ReplaceTransition;
exports.default = _default;
module.exports = exports.default;
      };
    };
  }
  }
}, {package:"react-transition-group",file:"node_modules\\react-transition-group\\cjs\\ReplaceTransition.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\react-transition-group\\cjs\\SwitchTransition.js", {"./Transition":"D:\\code\\v\\metamask-extension\\node_modules\\react-transition-group\\cjs\\Transition.js","./TransitionGroupContext":"D:\\code\\v\\metamask-extension\\node_modules\\react-transition-group\\cjs\\TransitionGroupContext.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Creact-transition-group%5Ccjs%5CSwitchTransition.js
      return function (require, module, exports) {
"use strict";

exports.__esModule = true;
exports.default = exports.modes = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _Transition = require("./Transition");

var _TransitionGroupContext = _interopRequireDefault(require("./TransitionGroupContext"));

var _leaveRenders, _enterRenders;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

function areChildrenDifferent(oldChildren, newChildren) {
  if (oldChildren === newChildren) return false;

  if (_react.default.isValidElement(oldChildren) && _react.default.isValidElement(newChildren) && oldChildren.key != null && oldChildren.key === newChildren.key) {
    return false;
  }

  return true;
}
/**
 * Enum of modes for SwitchTransition component
 * @enum { string }
 */


var modes = {
  out: 'out-in',
  in: 'in-out'
};
exports.modes = modes;

var callHook = function callHook(element, name, cb) {
  return function () {
    var _element$props;

    element.props[name] && (_element$props = element.props)[name].apply(_element$props, arguments);
    cb();
  };
};

var leaveRenders = (_leaveRenders = {}, _leaveRenders[modes.out] = function (_ref) {
  var current = _ref.current,
      changeState = _ref.changeState;
  return _react.default.cloneElement(current, {
    in: false,
    onExited: callHook(current, 'onExited', function () {
      changeState(_Transition.ENTERING, null);
    })
  });
}, _leaveRenders[modes.in] = function (_ref2) {
  var current = _ref2.current,
      changeState = _ref2.changeState,
      children = _ref2.children;
  return [current, _react.default.cloneElement(children, {
    in: true,
    onEntered: callHook(children, 'onEntered', function () {
      changeState(_Transition.ENTERING);
    })
  })];
}, _leaveRenders);
var enterRenders = (_enterRenders = {}, _enterRenders[modes.out] = function (_ref3) {
  var children = _ref3.children,
      changeState = _ref3.changeState;
  return _react.default.cloneElement(children, {
    in: true,
    onEntered: callHook(children, 'onEntered', function () {
      changeState(_Transition.ENTERED, _react.default.cloneElement(children, {
        in: true
      }));
    })
  });
}, _enterRenders[modes.in] = function (_ref4) {
  var current = _ref4.current,
      children = _ref4.children,
      changeState = _ref4.changeState;
  return [_react.default.cloneElement(current, {
    in: false,
    onExited: callHook(current, 'onExited', function () {
      changeState(_Transition.ENTERED, _react.default.cloneElement(children, {
        in: true
      }));
    })
  }), _react.default.cloneElement(children, {
    in: true
  })];
}, _enterRenders);
/**
 * A transition component inspired by the [vue transition modes](https://vuejs.org/v2/guide/transitions.html#Transition-Modes).
 * You can use it when you want to control the render between state transitions.
 * Based on the selected mode and the child's key which is the `Transition` or `CSSTransition` component, the `SwitchTransition` makes a consistent transition between them.
 *
 * If the `out-in` mode is selected, the `SwitchTransition` waits until the old child leaves and then inserts a new child.
 * If the `in-out` mode is selected, the `SwitchTransition` inserts a new child first, waits for the new child to enter and then removes the old child.
 *
 * **Note**: If you want the animation to happen simultaneously
 * (that is, to have the old child removed and a new child inserted **at the same time**),
 * you should use
 * [`TransitionGroup`](https://reactcommunity.org/react-transition-group/transition-group)
 * instead.
 *
 * ```jsx
 * function App() {
 *  const [state, setState] = useState(false);
 *  return (
 *    <SwitchTransition>
 *      <CSSTransition
 *        key={state ? "Goodbye, world!" : "Hello, world!"}
 *        addEndListener={(node, done) => node.addEventListener("transitionend", done, false)}
 *        classNames='fade'
 *      >
 *        <button onClick={() => setState(state => !state)}>
 *          {state ? "Goodbye, world!" : "Hello, world!"}
 *        </button>
 *      </CSSTransition>
 *    </SwitchTransition>
 *  );
 * }
 * ```
 *
 * ```css
 * .fade-enter{
 *    opacity: 0;
 * }
 * .fade-exit{
 *    opacity: 1;
 * }
 * .fade-enter-active{
 *    opacity: 1;
 * }
 * .fade-exit-active{
 *    opacity: 0;
 * }
 * .fade-enter-active,
 * .fade-exit-active{
 *    transition: opacity 500ms;
 * }
 * ```
 */

var SwitchTransition = /*#__PURE__*/function (_React$Component) {
  _inheritsLoose(SwitchTransition, _React$Component);

  function SwitchTransition() {
    var _this;

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _React$Component.call.apply(_React$Component, [this].concat(args)) || this;
    _this.state = {
      status: _Transition.ENTERED,
      current: null
    };
    _this.appeared = false;

    _this.changeState = function (status, current) {
      if (current === void 0) {
        current = _this.state.current;
      }

      _this.setState({
        status: status,
        current: current
      });
    };

    return _this;
  }

  var _proto = SwitchTransition.prototype;

  _proto.componentDidMount = function componentDidMount() {
    this.appeared = true;
  };

  SwitchTransition.getDerivedStateFromProps = function getDerivedStateFromProps(props, state) {
    if (props.children == null) {
      return {
        current: null
      };
    }

    if (state.status === _Transition.ENTERING && props.mode === modes.in) {
      return {
        status: _Transition.ENTERING
      };
    }

    if (state.current && areChildrenDifferent(state.current, props.children)) {
      return {
        status: _Transition.EXITING
      };
    }

    return {
      current: _react.default.cloneElement(props.children, {
        in: true
      })
    };
  };

  _proto.render = function render() {
    var _this$props = this.props,
        children = _this$props.children,
        mode = _this$props.mode,
        _this$state = this.state,
        status = _this$state.status,
        current = _this$state.current;
    var data = {
      children: children,
      current: current,
      changeState: this.changeState,
      status: status
    };
    var component;

    switch (status) {
      case _Transition.ENTERING:
        component = enterRenders[mode](data);
        break;

      case _Transition.EXITING:
        component = leaveRenders[mode](data);
        break;

      case _Transition.ENTERED:
        component = current;
    }

    return /*#__PURE__*/_react.default.createElement(_TransitionGroupContext.default.Provider, {
      value: {
        isMounting: !this.appeared
      }
    }, component);
  };

  return SwitchTransition;
}(_react.default.Component);

SwitchTransition.propTypes = "development" !== "production" ? {
  /**
   * Transition modes.
   * `out-in`: Current element transitions out first, then when complete, the new element transitions in.
   * `in-out`: New element transitions in first, then when complete, the current element transitions out.
   *
   * @type {'out-in'|'in-out'}
   */
  mode: _propTypes.default.oneOf([modes.in, modes.out]),

  /**
   * Any `Transition` or `CSSTransition` component.
   */
  children: _propTypes.default.oneOfType([_propTypes.default.element.isRequired])
} : {};
SwitchTransition.defaultProps = {
  mode: modes.out
};
var _default = SwitchTransition;
exports.default = _default;
      };
    };
  }
  }
}, {package:"react-transition-group",file:"node_modules\\react-transition-group\\cjs\\SwitchTransition.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\react-transition-group\\cjs\\Transition.js", {"./TransitionGroupContext":"D:\\code\\v\\metamask-extension\\node_modules\\react-transition-group\\cjs\\TransitionGroupContext.js","./config":"D:\\code\\v\\metamask-extension\\node_modules\\react-transition-group\\cjs\\config.js","./utils/PropTypes":"D:\\code\\v\\metamask-extension\\node_modules\\react-transition-group\\cjs\\utils\\PropTypes.js","./utils/reflow":"D:\\code\\v\\metamask-extension\\node_modules\\react-transition-group\\cjs\\utils\\reflow.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Creact-transition-group%5Ccjs%5CTransition.js
      return function (require, module, exports) {
"use strict";

exports.__esModule = true;
exports.default = exports.EXITING = exports.ENTERED = exports.ENTERING = exports.EXITED = exports.UNMOUNTED = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _config = _interopRequireDefault(require("./config"));

var _PropTypes = require("./utils/PropTypes");

var _TransitionGroupContext = _interopRequireDefault(require("./TransitionGroupContext"));

var _reflow = require("./utils/reflow");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

var UNMOUNTED = 'unmounted';
exports.UNMOUNTED = UNMOUNTED;
var EXITED = 'exited';
exports.EXITED = EXITED;
var ENTERING = 'entering';
exports.ENTERING = ENTERING;
var ENTERED = 'entered';
exports.ENTERED = ENTERED;
var EXITING = 'exiting';
/**
 * The Transition component lets you describe a transition from one component
 * state to another _over time_ with a simple declarative API. Most commonly
 * it's used to animate the mounting and unmounting of a component, but can also
 * be used to describe in-place transition states as well.
 *
 * ---
 *
 * **Note**: `Transition` is a platform-agnostic base component. If you're using
 * transitions in CSS, you'll probably want to use
 * [`CSSTransition`](https://reactcommunity.org/react-transition-group/css-transition)
 * instead. It inherits all the features of `Transition`, but contains
 * additional features necessary to play nice with CSS transitions (hence the
 * name of the component).
 *
 * ---
 *
 * By default the `Transition` component does not alter the behavior of the
 * component it renders, it only tracks "enter" and "exit" states for the
 * components. It's up to you to give meaning and effect to those states. For
 * example we can add styles to a component when it enters or exits:
 *
 * ```jsx
 * import { Transition } from 'react-transition-group';
 *
 * const duration = 300;
 *
 * const defaultStyle = {
 *   transition: `opacity ${duration}ms ease-in-out`,
 *   opacity: 0,
 * }
 *
 * const transitionStyles = {
 *   entering: { opacity: 1 },
 *   entered:  { opacity: 1 },
 *   exiting:  { opacity: 0 },
 *   exited:  { opacity: 0 },
 * };
 *
 * const Fade = ({ in: inProp }) => (
 *   <Transition in={inProp} timeout={duration}>
 *     {state => (
 *       <div style={{
 *         ...defaultStyle,
 *         ...transitionStyles[state]
 *       }}>
 *         I'm a fade Transition!
 *       </div>
 *     )}
 *   </Transition>
 * );
 * ```
 *
 * There are 4 main states a Transition can be in:
 *  - `'entering'`
 *  - `'entered'`
 *  - `'exiting'`
 *  - `'exited'`
 *
 * Transition state is toggled via the `in` prop. When `true` the component
 * begins the "Enter" stage. During this stage, the component will shift from
 * its current transition state, to `'entering'` for the duration of the
 * transition and then to the `'entered'` stage once it's complete. Let's take
 * the following example (we'll use the
 * [useState](https://reactjs.org/docs/hooks-reference.html#usestate) hook):
 *
 * ```jsx
 * function App() {
 *   const [inProp, setInProp] = useState(false);
 *   return (
 *     <div>
 *       <Transition in={inProp} timeout={500}>
 *         {state => (
 *           // ...
 *         )}
 *       </Transition>
 *       <button onClick={() => setInProp(true)}>
 *         Click to Enter
 *       </button>
 *     </div>
 *   );
 * }
 * ```
 *
 * When the button is clicked the component will shift to the `'entering'` state
 * and stay there for 500ms (the value of `timeout`) before it finally switches
 * to `'entered'`.
 *
 * When `in` is `false` the same thing happens except the state moves from
 * `'exiting'` to `'exited'`.
 */

exports.EXITING = EXITING;

var Transition = /*#__PURE__*/function (_React$Component) {
  _inheritsLoose(Transition, _React$Component);

  function Transition(props, context) {
    var _this;

    _this = _React$Component.call(this, props, context) || this;
    var parentGroup = context; // In the context of a TransitionGroup all enters are really appears

    var appear = parentGroup && !parentGroup.isMounting ? props.enter : props.appear;
    var initialStatus;
    _this.appearStatus = null;

    if (props.in) {
      if (appear) {
        initialStatus = EXITED;
        _this.appearStatus = ENTERING;
      } else {
        initialStatus = ENTERED;
      }
    } else {
      if (props.unmountOnExit || props.mountOnEnter) {
        initialStatus = UNMOUNTED;
      } else {
        initialStatus = EXITED;
      }
    }

    _this.state = {
      status: initialStatus
    };
    _this.nextCallback = null;
    return _this;
  }

  Transition.getDerivedStateFromProps = function getDerivedStateFromProps(_ref, prevState) {
    var nextIn = _ref.in;

    if (nextIn && prevState.status === UNMOUNTED) {
      return {
        status: EXITED
      };
    }

    return null;
  } // getSnapshotBeforeUpdate(prevProps) {
  //   let nextStatus = null
  //   if (prevProps !== this.props) {
  //     const { status } = this.state
  //     if (this.props.in) {
  //       if (status !== ENTERING && status !== ENTERED) {
  //         nextStatus = ENTERING
  //       }
  //     } else {
  //       if (status === ENTERING || status === ENTERED) {
  //         nextStatus = EXITING
  //       }
  //     }
  //   }
  //   return { nextStatus }
  // }
  ;

  var _proto = Transition.prototype;

  _proto.componentDidMount = function componentDidMount() {
    this.updateStatus(true, this.appearStatus);
  };

  _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
    var nextStatus = null;

    if (prevProps !== this.props) {
      var status = this.state.status;

      if (this.props.in) {
        if (status !== ENTERING && status !== ENTERED) {
          nextStatus = ENTERING;
        }
      } else {
        if (status === ENTERING || status === ENTERED) {
          nextStatus = EXITING;
        }
      }
    }

    this.updateStatus(false, nextStatus);
  };

  _proto.componentWillUnmount = function componentWillUnmount() {
    this.cancelNextCallback();
  };

  _proto.getTimeouts = function getTimeouts() {
    var timeout = this.props.timeout;
    var exit, enter, appear;
    exit = enter = appear = timeout;

    if (timeout != null && typeof timeout !== 'number') {
      exit = timeout.exit;
      enter = timeout.enter; // TODO: remove fallback for next major

      appear = timeout.appear !== undefined ? timeout.appear : enter;
    }

    return {
      exit: exit,
      enter: enter,
      appear: appear
    };
  };

  _proto.updateStatus = function updateStatus(mounting, nextStatus) {
    if (mounting === void 0) {
      mounting = false;
    }

    if (nextStatus !== null) {
      // nextStatus will always be ENTERING or EXITING.
      this.cancelNextCallback();

      if (nextStatus === ENTERING) {
        if (this.props.unmountOnExit || this.props.mountOnEnter) {
          var node = this.props.nodeRef ? this.props.nodeRef.current : _reactDom.default.findDOMNode(this); // https://github.com/reactjs/react-transition-group/pull/749
          // With unmountOnExit or mountOnEnter, the enter animation should happen at the transition between `exited` and `entering`.
          // To make the animation happen,  we have to separate each rendering and avoid being processed as batched.

          if (node) (0, _reflow.forceReflow)(node);
        }

        this.performEnter(mounting);
      } else {
        this.performExit();
      }
    } else if (this.props.unmountOnExit && this.state.status === EXITED) {
      this.setState({
        status: UNMOUNTED
      });
    }
  };

  _proto.performEnter = function performEnter(mounting) {
    var _this2 = this;

    var enter = this.props.enter;
    var appearing = this.context ? this.context.isMounting : mounting;

    var _ref2 = this.props.nodeRef ? [appearing] : [_reactDom.default.findDOMNode(this), appearing],
        maybeNode = _ref2[0],
        maybeAppearing = _ref2[1];

    var timeouts = this.getTimeouts();
    var enterTimeout = appearing ? timeouts.appear : timeouts.enter; // no enter animation skip right to ENTERED
    // if we are mounting and running this it means appear _must_ be set

    if (!mounting && !enter || _config.default.disabled) {
      this.safeSetState({
        status: ENTERED
      }, function () {
        _this2.props.onEntered(maybeNode);
      });
      return;
    }

    this.props.onEnter(maybeNode, maybeAppearing);
    this.safeSetState({
      status: ENTERING
    }, function () {
      _this2.props.onEntering(maybeNode, maybeAppearing);

      _this2.onTransitionEnd(enterTimeout, function () {
        _this2.safeSetState({
          status: ENTERED
        }, function () {
          _this2.props.onEntered(maybeNode, maybeAppearing);
        });
      });
    });
  };

  _proto.performExit = function performExit() {
    var _this3 = this;

    var exit = this.props.exit;
    var timeouts = this.getTimeouts();
    var maybeNode = this.props.nodeRef ? undefined : _reactDom.default.findDOMNode(this); // no exit animation skip right to EXITED

    if (!exit || _config.default.disabled) {
      this.safeSetState({
        status: EXITED
      }, function () {
        _this3.props.onExited(maybeNode);
      });
      return;
    }

    this.props.onExit(maybeNode);
    this.safeSetState({
      status: EXITING
    }, function () {
      _this3.props.onExiting(maybeNode);

      _this3.onTransitionEnd(timeouts.exit, function () {
        _this3.safeSetState({
          status: EXITED
        }, function () {
          _this3.props.onExited(maybeNode);
        });
      });
    });
  };

  _proto.cancelNextCallback = function cancelNextCallback() {
    if (this.nextCallback !== null) {
      this.nextCallback.cancel();
      this.nextCallback = null;
    }
  };

  _proto.safeSetState = function safeSetState(nextState, callback) {
    // This shouldn't be necessary, but there are weird race conditions with
    // setState callbacks and unmounting in testing, so always make sure that
    // we can cancel any pending setState callbacks after we unmount.
    callback = this.setNextCallback(callback);
    this.setState(nextState, callback);
  };

  _proto.setNextCallback = function setNextCallback(callback) {
    var _this4 = this;

    var active = true;

    this.nextCallback = function (event) {
      if (active) {
        active = false;
        _this4.nextCallback = null;
        callback(event);
      }
    };

    this.nextCallback.cancel = function () {
      active = false;
    };

    return this.nextCallback;
  };

  _proto.onTransitionEnd = function onTransitionEnd(timeout, handler) {
    this.setNextCallback(handler);
    var node = this.props.nodeRef ? this.props.nodeRef.current : _reactDom.default.findDOMNode(this);
    var doesNotHaveTimeoutOrListener = timeout == null && !this.props.addEndListener;

    if (!node || doesNotHaveTimeoutOrListener) {
      setTimeout(this.nextCallback, 0);
      return;
    }

    if (this.props.addEndListener) {
      var _ref3 = this.props.nodeRef ? [this.nextCallback] : [node, this.nextCallback],
          maybeNode = _ref3[0],
          maybeNextCallback = _ref3[1];

      this.props.addEndListener(maybeNode, maybeNextCallback);
    }

    if (timeout != null) {
      setTimeout(this.nextCallback, timeout);
    }
  };

  _proto.render = function render() {
    var status = this.state.status;

    if (status === UNMOUNTED) {
      return null;
    }

    var _this$props = this.props,
        children = _this$props.children,
        _in = _this$props.in,
        _mountOnEnter = _this$props.mountOnEnter,
        _unmountOnExit = _this$props.unmountOnExit,
        _appear = _this$props.appear,
        _enter = _this$props.enter,
        _exit = _this$props.exit,
        _timeout = _this$props.timeout,
        _addEndListener = _this$props.addEndListener,
        _onEnter = _this$props.onEnter,
        _onEntering = _this$props.onEntering,
        _onEntered = _this$props.onEntered,
        _onExit = _this$props.onExit,
        _onExiting = _this$props.onExiting,
        _onExited = _this$props.onExited,
        _nodeRef = _this$props.nodeRef,
        childProps = _objectWithoutPropertiesLoose(_this$props, ["children", "in", "mountOnEnter", "unmountOnExit", "appear", "enter", "exit", "timeout", "addEndListener", "onEnter", "onEntering", "onEntered", "onExit", "onExiting", "onExited", "nodeRef"]);

    return (
      /*#__PURE__*/
      // allows for nested Transitions
      _react.default.createElement(_TransitionGroupContext.default.Provider, {
        value: null
      }, typeof children === 'function' ? children(status, childProps) : _react.default.cloneElement(_react.default.Children.only(children), childProps))
    );
  };

  return Transition;
}(_react.default.Component);

Transition.contextType = _TransitionGroupContext.default;
Transition.propTypes = "development" !== "production" ? {
  /**
   * A React reference to DOM element that need to transition:
   * https://stackoverflow.com/a/51127130/4671932
   *
   *   - When `nodeRef` prop is used, `node` is not passed to callback functions
   *      (e.g. `onEnter`) because user already has direct access to the node.
   *   - When changing `key` prop of `Transition` in a `TransitionGroup` a new
   *     `nodeRef` need to be provided to `Transition` with changed `key` prop
   *     (see
   *     [test/CSSTransition-test.js](https://github.com/reactjs/react-transition-group/blob/13435f897b3ab71f6e19d724f145596f5910581c/test/CSSTransition-test.js#L362-L437)).
   */
  nodeRef: _propTypes.default.shape({
    current: typeof Element === 'undefined' ? _propTypes.default.any : function (propValue, key, componentName, location, propFullName, secret) {
      var value = propValue[key];
      return _propTypes.default.instanceOf(value && 'ownerDocument' in value ? value.ownerDocument.defaultView.Element : Element)(propValue, key, componentName, location, propFullName, secret);
    }
  }),

  /**
   * A `function` child can be used instead of a React element. This function is
   * called with the current transition status (`'entering'`, `'entered'`,
   * `'exiting'`, `'exited'`), which can be used to apply context
   * specific props to a component.
   *
   * ```jsx
   * <Transition in={this.state.in} timeout={150}>
   *   {state => (
   *     <MyComponent className={`fade fade-${state}`} />
   *   )}
   * </Transition>
   * ```
   */
  children: _propTypes.default.oneOfType([_propTypes.default.func.isRequired, _propTypes.default.element.isRequired]).isRequired,

  /**
   * Show the component; triggers the enter or exit states
   */
  in: _propTypes.default.bool,

  /**
   * By default the child component is mounted immediately along with
   * the parent `Transition` component. If you want to "lazy mount" the component on the
   * first `in={true}` you can set `mountOnEnter`. After the first enter transition the component will stay
   * mounted, even on "exited", unless you also specify `unmountOnExit`.
   */
  mountOnEnter: _propTypes.default.bool,

  /**
   * By default the child component stays mounted after it reaches the `'exited'` state.
   * Set `unmountOnExit` if you'd prefer to unmount the component after it finishes exiting.
   */
  unmountOnExit: _propTypes.default.bool,

  /**
   * By default the child component does not perform the enter transition when
   * it first mounts, regardless of the value of `in`. If you want this
   * behavior, set both `appear` and `in` to `true`.
   *
   * > **Note**: there are no special appear states like `appearing`/`appeared`, this prop
   * > only adds an additional enter transition. However, in the
   * > `<CSSTransition>` component that first enter transition does result in
   * > additional `.appear-*` classes, that way you can choose to style it
   * > differently.
   */
  appear: _propTypes.default.bool,

  /**
   * Enable or disable enter transitions.
   */
  enter: _propTypes.default.bool,

  /**
   * Enable or disable exit transitions.
   */
  exit: _propTypes.default.bool,

  /**
   * The duration of the transition, in milliseconds.
   * Required unless `addEndListener` is provided.
   *
   * You may specify a single timeout for all transitions:
   *
   * ```jsx
   * timeout={500}
   * ```
   *
   * or individually:
   *
   * ```jsx
   * timeout={{
   *  appear: 500,
   *  enter: 300,
   *  exit: 500,
   * }}
   * ```
   *
   * - `appear` defaults to the value of `enter`
   * - `enter` defaults to `0`
   * - `exit` defaults to `0`
   *
   * @type {number | { enter?: number, exit?: number, appear?: number }}
   */
  timeout: function timeout(props) {
    var pt = _PropTypes.timeoutsShape;
    if (!props.addEndListener) pt = pt.isRequired;

    for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }

    return pt.apply(void 0, [props].concat(args));
  },

  /**
   * Add a custom transition end trigger. Called with the transitioning
   * DOM node and a `done` callback. Allows for more fine grained transition end
   * logic. Timeouts are still used as a fallback if provided.
   *
   * **Note**: when `nodeRef` prop is passed, `node` is not passed.
   *
   * ```jsx
   * addEndListener={(node, done) => {
   *   // use the css transitionend event to mark the finish of a transition
   *   node.addEventListener('transitionend', done, false);
   * }}
   * ```
   */
  addEndListener: _propTypes.default.func,

  /**
   * Callback fired before the "entering" status is applied. An extra parameter
   * `isAppearing` is supplied to indicate if the enter stage is occurring on the initial mount
   *
   * **Note**: when `nodeRef` prop is passed, `node` is not passed.
   *
   * @type Function(node: HtmlElement, isAppearing: bool) -> void
   */
  onEnter: _propTypes.default.func,

  /**
   * Callback fired after the "entering" status is applied. An extra parameter
   * `isAppearing` is supplied to indicate if the enter stage is occurring on the initial mount
   *
   * **Note**: when `nodeRef` prop is passed, `node` is not passed.
   *
   * @type Function(node: HtmlElement, isAppearing: bool)
   */
  onEntering: _propTypes.default.func,

  /**
   * Callback fired after the "entered" status is applied. An extra parameter
   * `isAppearing` is supplied to indicate if the enter stage is occurring on the initial mount
   *
   * **Note**: when `nodeRef` prop is passed, `node` is not passed.
   *
   * @type Function(node: HtmlElement, isAppearing: bool) -> void
   */
  onEntered: _propTypes.default.func,

  /**
   * Callback fired before the "exiting" status is applied.
   *
   * **Note**: when `nodeRef` prop is passed, `node` is not passed.
   *
   * @type Function(node: HtmlElement) -> void
   */
  onExit: _propTypes.default.func,

  /**
   * Callback fired after the "exiting" status is applied.
   *
   * **Note**: when `nodeRef` prop is passed, `node` is not passed.
   *
   * @type Function(node: HtmlElement) -> void
   */
  onExiting: _propTypes.default.func,

  /**
   * Callback fired after the "exited" status is applied.
   *
   * **Note**: when `nodeRef` prop is passed, `node` is not passed
   *
   * @type Function(node: HtmlElement) -> void
   */
  onExited: _propTypes.default.func
} : {}; // Name the function so it is clearer in the documentation

function noop() {}

Transition.defaultProps = {
  in: false,
  mountOnEnter: false,
  unmountOnExit: false,
  appear: false,
  enter: true,
  exit: true,
  onEnter: noop,
  onEntering: noop,
  onEntered: noop,
  onExit: noop,
  onExiting: noop,
  onExited: noop
};
Transition.UNMOUNTED = UNMOUNTED;
Transition.EXITED = EXITED;
Transition.ENTERING = ENTERING;
Transition.ENTERED = ENTERED;
Transition.EXITING = EXITING;
var _default = Transition;
exports.default = _default;
      };
    };
  }
  }
}, {package:"react-transition-group",file:"node_modules\\react-transition-group\\cjs\\Transition.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\react-transition-group\\cjs\\TransitionGroup.js", {"./TransitionGroupContext":"D:\\code\\v\\metamask-extension\\node_modules\\react-transition-group\\cjs\\TransitionGroupContext.js","./utils/ChildMapping":"D:\\code\\v\\metamask-extension\\node_modules\\react-transition-group\\cjs\\utils\\ChildMapping.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Creact-transition-group%5Ccjs%5CTransitionGroup.js
      return function (require, module, exports) {
"use strict";

exports.__esModule = true;
exports.default = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _TransitionGroupContext = _interopRequireDefault(require("./TransitionGroupContext"));

var _ChildMapping = require("./utils/ChildMapping");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

var values = Object.values || function (obj) {
  return Object.keys(obj).map(function (k) {
    return obj[k];
  });
};

var defaultProps = {
  component: 'div',
  childFactory: function childFactory(child) {
    return child;
  }
};
/**
 * The `<TransitionGroup>` component manages a set of transition components
 * (`<Transition>` and `<CSSTransition>`) in a list. Like with the transition
 * components, `<TransitionGroup>` is a state machine for managing the mounting
 * and unmounting of components over time.
 *
 * Consider the example below. As items are removed or added to the TodoList the
 * `in` prop is toggled automatically by the `<TransitionGroup>`.
 *
 * Note that `<TransitionGroup>`  does not define any animation behavior!
 * Exactly _how_ a list item animates is up to the individual transition
 * component. This means you can mix and match animations across different list
 * items.
 */

var TransitionGroup = /*#__PURE__*/function (_React$Component) {
  _inheritsLoose(TransitionGroup, _React$Component);

  function TransitionGroup(props, context) {
    var _this;

    _this = _React$Component.call(this, props, context) || this;

    var handleExited = _this.handleExited.bind(_assertThisInitialized(_this)); // Initial children should all be entering, dependent on appear


    _this.state = {
      contextValue: {
        isMounting: true
      },
      handleExited: handleExited,
      firstRender: true
    };
    return _this;
  }

  var _proto = TransitionGroup.prototype;

  _proto.componentDidMount = function componentDidMount() {
    this.mounted = true;
    this.setState({
      contextValue: {
        isMounting: false
      }
    });
  };

  _proto.componentWillUnmount = function componentWillUnmount() {
    this.mounted = false;
  };

  TransitionGroup.getDerivedStateFromProps = function getDerivedStateFromProps(nextProps, _ref) {
    var prevChildMapping = _ref.children,
        handleExited = _ref.handleExited,
        firstRender = _ref.firstRender;
    return {
      children: firstRender ? (0, _ChildMapping.getInitialChildMapping)(nextProps, handleExited) : (0, _ChildMapping.getNextChildMapping)(nextProps, prevChildMapping, handleExited),
      firstRender: false
    };
  } // node is `undefined` when user provided `nodeRef` prop
  ;

  _proto.handleExited = function handleExited(child, node) {
    var currentChildMapping = (0, _ChildMapping.getChildMapping)(this.props.children);
    if (child.key in currentChildMapping) return;

    if (child.props.onExited) {
      child.props.onExited(node);
    }

    if (this.mounted) {
      this.setState(function (state) {
        var children = _extends({}, state.children);

        delete children[child.key];
        return {
          children: children
        };
      });
    }
  };

  _proto.render = function render() {
    var _this$props = this.props,
        Component = _this$props.component,
        childFactory = _this$props.childFactory,
        props = _objectWithoutPropertiesLoose(_this$props, ["component", "childFactory"]);

    var contextValue = this.state.contextValue;
    var children = values(this.state.children).map(childFactory);
    delete props.appear;
    delete props.enter;
    delete props.exit;

    if (Component === null) {
      return /*#__PURE__*/_react.default.createElement(_TransitionGroupContext.default.Provider, {
        value: contextValue
      }, children);
    }

    return /*#__PURE__*/_react.default.createElement(_TransitionGroupContext.default.Provider, {
      value: contextValue
    }, /*#__PURE__*/_react.default.createElement(Component, props, children));
  };

  return TransitionGroup;
}(_react.default.Component);

TransitionGroup.propTypes = "development" !== "production" ? {
  /**
   * `<TransitionGroup>` renders a `<div>` by default. You can change this
   * behavior by providing a `component` prop.
   * If you use React v16+ and would like to avoid a wrapping `<div>` element
   * you can pass in `component={null}`. This is useful if the wrapping div
   * borks your css styles.
   */
  component: _propTypes.default.any,

  /**
   * A set of `<Transition>` components, that are toggled `in` and out as they
   * leave. the `<TransitionGroup>` will inject specific transition props, so
   * remember to spread them through if you are wrapping the `<Transition>` as
   * with our `<Fade>` example.
   *
   * While this component is meant for multiple `Transition` or `CSSTransition`
   * children, sometimes you may want to have a single transition child with
   * content that you want to be transitioned out and in when you change it
   * (e.g. routes, images etc.) In that case you can change the `key` prop of
   * the transition child as you change its content, this will cause
   * `TransitionGroup` to transition the child out and back in.
   */
  children: _propTypes.default.node,

  /**
   * A convenience prop that enables or disables appear animations
   * for all children. Note that specifying this will override any defaults set
   * on individual children Transitions.
   */
  appear: _propTypes.default.bool,

  /**
   * A convenience prop that enables or disables enter animations
   * for all children. Note that specifying this will override any defaults set
   * on individual children Transitions.
   */
  enter: _propTypes.default.bool,

  /**
   * A convenience prop that enables or disables exit animations
   * for all children. Note that specifying this will override any defaults set
   * on individual children Transitions.
   */
  exit: _propTypes.default.bool,

  /**
   * You may need to apply reactive updates to a child as it is exiting.
   * This is generally done by using `cloneElement` however in the case of an exiting
   * child the element has already been removed and not accessible to the consumer.
   *
   * If you do need to update a child as it leaves you can provide a `childFactory`
   * to wrap every child, even the ones that are leaving.
   *
   * @type Function(child: ReactElement) -> ReactElement
   */
  childFactory: _propTypes.default.func
} : {};
TransitionGroup.defaultProps = defaultProps;
var _default = TransitionGroup;
exports.default = _default;
module.exports = exports.default;
      };
    };
  }
  }
}, {package:"react-transition-group",file:"node_modules\\react-transition-group\\cjs\\TransitionGroup.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\react-transition-group\\cjs\\TransitionGroupContext.js", {"react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Creact-transition-group%5Ccjs%5CTransitionGroupContext.js
      return function (require, module, exports) {
"use strict";

exports.__esModule = true;
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _default = _react.default.createContext(null);

exports.default = _default;
module.exports = exports.default;
      };
    };
  }
  }
}, {package:"react-transition-group",file:"node_modules\\react-transition-group\\cjs\\TransitionGroupContext.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\react-transition-group\\cjs\\config.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Creact-transition-group%5Ccjs%5Cconfig.js
      return function (require, module, exports) {
"use strict";

exports.__esModule = true;
exports.default = void 0;
var _default = {
  disabled: false
};
exports.default = _default;
module.exports = exports.default;
      };
    };
  }
  }
}, {package:"react-transition-group",file:"node_modules\\react-transition-group\\cjs\\config.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\react-transition-group\\cjs\\index.js", {"./CSSTransition":"D:\\code\\v\\metamask-extension\\node_modules\\react-transition-group\\cjs\\CSSTransition.js","./ReplaceTransition":"D:\\code\\v\\metamask-extension\\node_modules\\react-transition-group\\cjs\\ReplaceTransition.js","./SwitchTransition":"D:\\code\\v\\metamask-extension\\node_modules\\react-transition-group\\cjs\\SwitchTransition.js","./Transition":"D:\\code\\v\\metamask-extension\\node_modules\\react-transition-group\\cjs\\Transition.js","./TransitionGroup":"D:\\code\\v\\metamask-extension\\node_modules\\react-transition-group\\cjs\\TransitionGroup.js","./config":"D:\\code\\v\\metamask-extension\\node_modules\\react-transition-group\\cjs\\config.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Creact-transition-group%5Ccjs%5Cindex.js
      return function (require, module, exports) {
"use strict";

exports.__esModule = true;
exports.config = exports.Transition = exports.TransitionGroup = exports.SwitchTransition = exports.ReplaceTransition = exports.CSSTransition = void 0;

var _CSSTransition = _interopRequireDefault(require("./CSSTransition"));

exports.CSSTransition = _CSSTransition.default;

var _ReplaceTransition = _interopRequireDefault(require("./ReplaceTransition"));

exports.ReplaceTransition = _ReplaceTransition.default;

var _SwitchTransition = _interopRequireDefault(require("./SwitchTransition"));

exports.SwitchTransition = _SwitchTransition.default;

var _TransitionGroup = _interopRequireDefault(require("./TransitionGroup"));

exports.TransitionGroup = _TransitionGroup.default;

var _Transition = _interopRequireDefault(require("./Transition"));

exports.Transition = _Transition.default;

var _config = _interopRequireDefault(require("./config"));

exports.config = _config.default;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
      };
    };
  }
  }
}, {package:"react-transition-group",file:"node_modules\\react-transition-group\\cjs\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\react-transition-group\\cjs\\utils\\ChildMapping.js", {"react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Creact-transition-group%5Ccjs%5Cutils%5CChildMapping.js
      return function (require, module, exports) {
"use strict";

exports.__esModule = true;
exports.getChildMapping = getChildMapping;
exports.mergeChildMappings = mergeChildMappings;
exports.getInitialChildMapping = getInitialChildMapping;
exports.getNextChildMapping = getNextChildMapping;

var _react = require("react");

/**
 * Given `this.props.children`, return an object mapping key to child.
 *
 * @param {*} children `this.props.children`
 * @return {object} Mapping of key to child
 */
function getChildMapping(children, mapFn) {
  var mapper = function mapper(child) {
    return mapFn && (0, _react.isValidElement)(child) ? mapFn(child) : child;
  };

  var result = Object.create(null);
  if (children) _react.Children.map(children, function (c) {
    return c;
  }).forEach(function (child) {
    // run the map function here instead so that the key is the computed one
    result[child.key] = mapper(child);
  });
  return result;
}
/**
 * When you're adding or removing children some may be added or removed in the
 * same render pass. We want to show *both* since we want to simultaneously
 * animate elements in and out. This function takes a previous set of keys
 * and a new set of keys and merges them with its best guess of the correct
 * ordering. In the future we may expose some of the utilities in
 * ReactMultiChild to make this easy, but for now React itself does not
 * directly have this concept of the union of prevChildren and nextChildren
 * so we implement it here.
 *
 * @param {object} prev prev children as returned from
 * `ReactTransitionChildMapping.getChildMapping()`.
 * @param {object} next next children as returned from
 * `ReactTransitionChildMapping.getChildMapping()`.
 * @return {object} a key set that contains all keys in `prev` and all keys
 * in `next` in a reasonable order.
 */


function mergeChildMappings(prev, next) {
  prev = prev || {};
  next = next || {};

  function getValueForKey(key) {
    return key in next ? next[key] : prev[key];
  } // For each key of `next`, the list of keys to insert before that key in
  // the combined list


  var nextKeysPending = Object.create(null);
  var pendingKeys = [];

  for (var prevKey in prev) {
    if (prevKey in next) {
      if (pendingKeys.length) {
        nextKeysPending[prevKey] = pendingKeys;
        pendingKeys = [];
      }
    } else {
      pendingKeys.push(prevKey);
    }
  }

  var i;
  var childMapping = {};

  for (var nextKey in next) {
    if (nextKeysPending[nextKey]) {
      for (i = 0; i < nextKeysPending[nextKey].length; i++) {
        var pendingNextKey = nextKeysPending[nextKey][i];
        childMapping[nextKeysPending[nextKey][i]] = getValueForKey(pendingNextKey);
      }
    }

    childMapping[nextKey] = getValueForKey(nextKey);
  } // Finally, add the keys which didn't appear before any key in `next`


  for (i = 0; i < pendingKeys.length; i++) {
    childMapping[pendingKeys[i]] = getValueForKey(pendingKeys[i]);
  }

  return childMapping;
}

function getProp(child, prop, props) {
  return props[prop] != null ? props[prop] : child.props[prop];
}

function getInitialChildMapping(props, onExited) {
  return getChildMapping(props.children, function (child) {
    return (0, _react.cloneElement)(child, {
      onExited: onExited.bind(null, child),
      in: true,
      appear: getProp(child, 'appear', props),
      enter: getProp(child, 'enter', props),
      exit: getProp(child, 'exit', props)
    });
  });
}

function getNextChildMapping(nextProps, prevChildMapping, onExited) {
  var nextChildMapping = getChildMapping(nextProps.children);
  var children = mergeChildMappings(prevChildMapping, nextChildMapping);
  Object.keys(children).forEach(function (key) {
    var child = children[key];
    if (!(0, _react.isValidElement)(child)) return;
    var hasPrev = (key in prevChildMapping);
    var hasNext = (key in nextChildMapping);
    var prevChild = prevChildMapping[key];
    var isLeaving = (0, _react.isValidElement)(prevChild) && !prevChild.props.in; // item is new (entering)

    if (hasNext && (!hasPrev || isLeaving)) {
      // console.log('entering', key)
      children[key] = (0, _react.cloneElement)(child, {
        onExited: onExited.bind(null, child),
        in: true,
        exit: getProp(child, 'exit', nextProps),
        enter: getProp(child, 'enter', nextProps)
      });
    } else if (!hasNext && hasPrev && !isLeaving) {
      // item is old (exiting)
      // console.log('leaving', key)
      children[key] = (0, _react.cloneElement)(child, {
        in: false
      });
    } else if (hasNext && hasPrev && (0, _react.isValidElement)(prevChild)) {
      // item hasn't changed transition states
      // copy over the last transition props;
      // console.log('unchanged', key)
      children[key] = (0, _react.cloneElement)(child, {
        onExited: onExited.bind(null, child),
        in: prevChild.props.in,
        exit: getProp(child, 'exit', nextProps),
        enter: getProp(child, 'enter', nextProps)
      });
    }
  });
  return children;
}
      };
    };
  }
  }
}, {package:"react-transition-group",file:"node_modules\\react-transition-group\\cjs\\utils\\ChildMapping.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\react-transition-group\\cjs\\utils\\PropTypes.js", {"prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Creact-transition-group%5Ccjs%5Cutils%5CPropTypes.js
      return function (require, module, exports) {
"use strict";

exports.__esModule = true;
exports.classNamesShape = exports.timeoutsShape = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var timeoutsShape = "development" !== 'production' ? _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.shape({
  enter: _propTypes.default.number,
  exit: _propTypes.default.number,
  appear: _propTypes.default.number
}).isRequired]) : null;
exports.timeoutsShape = timeoutsShape;
var classNamesShape = "development" !== 'production' ? _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.shape({
  enter: _propTypes.default.string,
  exit: _propTypes.default.string,
  active: _propTypes.default.string
}), _propTypes.default.shape({
  enter: _propTypes.default.string,
  enterDone: _propTypes.default.string,
  enterActive: _propTypes.default.string,
  exit: _propTypes.default.string,
  exitDone: _propTypes.default.string,
  exitActive: _propTypes.default.string
})]) : null;
exports.classNamesShape = classNamesShape;
      };
    };
  }
  }
}, {package:"react-transition-group",file:"node_modules\\react-transition-group\\cjs\\utils\\PropTypes.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\react-transition-group\\cjs\\utils\\reflow.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Creact-transition-group%5Ccjs%5Cutils%5Creflow.js
      return function (require, module, exports) {
"use strict";

exports.__esModule = true;
exports.forceReflow = void 0;

var forceReflow = function forceReflow(node) {
  return node.scrollTop;
};

exports.forceReflow = forceReflow;
      };
    };
  }
  }
}, {package:"react-transition-group",file:"node_modules\\react-transition-group\\cjs\\utils\\reflow.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\redux-devtools-core\\lib\\utils\\catchErrors.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Credux-devtools-core%5Clib%5Cutils%5CcatchErrors.js
      return function (require, module, exports) {
'use strict';

exports.__esModule = true;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

exports.default = catchErrors;
var ERROR = '@@remotedev/ERROR';

function catchErrors(sendError) {
  if ((typeof window === 'undefined' ? 'undefined' : _typeof(window)) === 'object' && _typeof(window.onerror) === 'object') {
    window.onerror = function (message, url, lineNo, columnNo, error) {
      var errorAction = { type: ERROR, message: message, url: url, lineNo: lineNo, columnNo: columnNo };
      if (error && error.stack) errorAction.stack = error.stack;
      sendError(errorAction);
      return false;
    };
  } else if (typeof global !== 'undefined' && global.ErrorUtils) {
    global.ErrorUtils.setGlobalHandler(function (error, isFatal) {
      sendError({ type: ERROR, error: error, isFatal: isFatal });
    });
  }

  if ((typeof console === 'undefined' ? 'undefined' : _typeof(console)) === 'object' && typeof console.error === 'function' && !console.beforeRemotedev) {
    console.beforeRemotedev = console.error.bind(console);
    console.error = function () {
      var errorAction = { type: ERROR };
      var error = arguments[0];
      errorAction.message = error.message ? error.message : error;
      if (error.sourceURL) {
        errorAction = _extends({}, errorAction, { sourceURL: error.sourceURL, line: error.line, column: error.column
        });
      }
      if (error.stack) errorAction.stack = error.stack;
      sendError(errorAction);
      console.beforeRemotedev.apply(null, arguments);
    };
  }
}
      };
    };
  }
  }
}, {package:"remote-redux-devtools>redux-devtools-core",file:"node_modules\\redux-devtools-core\\lib\\utils\\catchErrors.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\redux-devtools-core\\lib\\utils\\filters.js", {"lodash/mapValues":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\mapValues.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Credux-devtools-core%5Clib%5Cutils%5Cfilters.js
      return function (require, module, exports) {
'use strict';

exports.__esModule = true;
exports.FilterState = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports.arrToRegex = arrToRegex;
exports.getLocalFilter = getLocalFilter;
exports.isFiltered = isFiltered;
exports.filterStagedActions = filterStagedActions;
exports.filterState = filterState;

var _mapValues = require('lodash/mapValues');

var _mapValues2 = _interopRequireDefault(_mapValues);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var FilterState = exports.FilterState = {
  DO_NOT_FILTER: 'DO_NOT_FILTER',
  BLACKLIST_SPECIFIC: 'BLACKLIST_SPECIFIC',
  WHITELIST_SPECIFIC: 'WHITELIST_SPECIFIC'
};

function arrToRegex(v) {
  return typeof v === 'string' ? v : v.join('|');
}

function filterActions(actionsById, actionsFilter) {
  if (!actionsFilter) return actionsById;
  return (0, _mapValues2.default)(actionsById, function (action, id) {
    return _extends({}, action, { action: actionsFilter(action.action, id) });
  });
}

function filterStates(computedStates, statesFilter) {
  if (!statesFilter) return computedStates;
  return computedStates.map(function (state, idx) {
    return _extends({}, state, { state: statesFilter(state.state, idx) });
  });
}

function getLocalFilter(config) {
  if (config.actionsBlacklist || config.actionsWhitelist) {
    return {
      whitelist: config.actionsWhitelist && config.actionsWhitelist.join('|'),
      blacklist: config.actionsBlacklist && config.actionsBlacklist.join('|')
    };
  }
  return undefined;
}

function getDevToolsOptions() {
  return typeof window !== 'undefined' && window.devToolsOptions || {};
}

function isFiltered(action, localFilter) {
  var _ref = action.action || action,
      type = _ref.type;

  var opts = getDevToolsOptions();
  if (!localFilter && opts.filter && opts.filter === FilterState.DO_NOT_FILTER || type && typeof type.match !== 'function') return false;

  var _ref2 = localFilter || opts,
      whitelist = _ref2.whitelist,
      blacklist = _ref2.blacklist;

  return whitelist && !type.match(whitelist) || blacklist && type.match(blacklist);
}

function filterStagedActions(state, filters) {
  if (!filters) return state;

  var filteredStagedActionIds = [];
  var filteredComputedStates = [];

  state.stagedActionIds.forEach(function (id, idx) {
    if (!isFiltered(state.actionsById[id], filters)) {
      filteredStagedActionIds.push(id);
      filteredComputedStates.push(state.computedStates[idx]);
    }
  });

  return _extends({}, state, {
    stagedActionIds: filteredStagedActionIds,
    computedStates: filteredComputedStates
  });
}

function filterState(state, type, localFilter, stateSanitizer, actionSanitizer, nextActionId, predicate) {
  if (type === 'ACTION') return !stateSanitizer ? state : stateSanitizer(state, nextActionId - 1);else if (type !== 'STATE') return state;

  var _getDevToolsOptions = getDevToolsOptions(),
      filter = _getDevToolsOptions.filter;

  if (predicate || localFilter || filter && filter !== FilterState.DO_NOT_FILTER) {
    var filteredStagedActionIds = [];
    var filteredComputedStates = [];
    var sanitizedActionsById = actionSanitizer && {};
    var actionsById = state.actionsById;
    var computedStates = state.computedStates;


    state.stagedActionIds.forEach(function (id, idx) {
      var liftedAction = actionsById[id];
      var currAction = liftedAction.action;
      var liftedState = computedStates[idx];
      var currState = liftedState.state;
      if (idx) {
        if (predicate && !predicate(currState, currAction)) return;
        if (isFiltered(currAction, localFilter)) return;
      }

      filteredStagedActionIds.push(id);
      filteredComputedStates.push(stateSanitizer ? _extends({}, liftedState, { state: stateSanitizer(currState, idx) }) : liftedState);
      if (actionSanitizer) {
        sanitizedActionsById[id] = _extends({}, liftedAction, { action: actionSanitizer(currAction, id)
        });
      }
    });

    return _extends({}, state, {
      actionsById: sanitizedActionsById || actionsById,
      stagedActionIds: filteredStagedActionIds,
      computedStates: filteredComputedStates
    });
  }

  if (!stateSanitizer && !actionSanitizer) return state;
  return _extends({}, state, {
    actionsById: filterActions(state.actionsById, actionSanitizer),
    computedStates: filterStates(state.computedStates, stateSanitizer)
  });
}
      };
    };
  }
  }
}, {package:"remote-redux-devtools>redux-devtools-core",file:"node_modules\\redux-devtools-core\\lib\\utils\\filters.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\redux-devtools-core\\lib\\utils\\index.js", {"get-params":"D:\\code\\v\\metamask-extension\\node_modules\\get-params\\index.js","jsan":"D:\\code\\v\\metamask-extension\\node_modules\\jsan\\index.js","nanoid/non-secure":"D:\\code\\v\\metamask-extension\\node_modules\\redux-devtools-core\\node_modules\\nanoid\\non-secure\\index.js","remotedev-serialize/immutable/serialize":"D:\\code\\v\\metamask-extension\\node_modules\\remotedev-serialize\\immutable\\serialize.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Credux-devtools-core%5Clib%5Cutils%5Cindex.js
      return function (require, module, exports) {
'use strict';

exports.__esModule = true;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

exports.generateId = generateId;
exports.getMethods = getMethods;
exports.getActionsArray = getActionsArray;
exports.evalAction = evalAction;
exports.evalMethod = evalMethod;
exports.stringify = stringify;
exports.getSeralizeParameter = getSeralizeParameter;
exports.getStackTrace = getStackTrace;

var _getParams = require('get-params');

var _getParams2 = _interopRequireDefault(_getParams);

var _jsan = require('jsan');

var _jsan2 = _interopRequireDefault(_jsan);

var _nonSecure = require('nanoid/non-secure');

var _nonSecure2 = _interopRequireDefault(_nonSecure);

var _serialize = require('remotedev-serialize/immutable/serialize');

var _serialize2 = _interopRequireDefault(_serialize);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function generateId(id) {
  return id || (0, _nonSecure2.default)(7);
}

function flatTree(obj) {
  var namespace = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';

  var functions = [];
  Object.keys(obj).forEach(function (key) {
    var prop = obj[key];
    if (typeof prop === 'function') {
      functions.push({
        name: namespace + (key || prop.name || 'anonymous'),
        func: prop,
        args: (0, _getParams2.default)(prop)
      });
    } else if ((typeof prop === 'undefined' ? 'undefined' : _typeof(prop)) === 'object') {
      functions = functions.concat(flatTree(prop, namespace + key + '.'));
    }
  });
  return functions;
}

function getMethods(obj) {
  if ((typeof obj === 'undefined' ? 'undefined' : _typeof(obj)) !== 'object') return undefined;
  var functions = void 0;
  var m = void 0;
  if (obj.__proto__) m = obj.__proto__.__proto__;
  if (!m) m = obj;

  Object.getOwnPropertyNames(m).forEach(function (key) {
    var propDescriptor = Object.getOwnPropertyDescriptor(m, key);
    if (!propDescriptor || 'get' in propDescriptor || 'set' in propDescriptor) return;
    var prop = m[key];
    if (typeof prop === 'function' && key !== 'constructor') {
      if (!functions) functions = [];
      functions.push({
        name: key || prop.name || 'anonymous',
        args: (0, _getParams2.default)(prop)
      });
    }
  });
  return functions;
}

function getActionsArray(actionCreators) {
  if (Array.isArray(actionCreators)) return actionCreators;
  return flatTree(actionCreators);
}

/* eslint-disable no-new-func */
var interpretArg = function interpretArg(arg) {
  return new Function('return ' + arg)();
};

function evalArgs(inArgs, restArgs) {
  var args = inArgs.map(interpretArg);
  if (!restArgs) return args;
  var rest = interpretArg(restArgs);
  if (Array.isArray(rest)) return args.concat.apply(args, rest);
  throw new Error('rest must be an array');
}

function evalAction(action, actionCreators) {
  if (typeof action === 'string') {
    return new Function('return ' + action)();
  }

  var actionCreator = actionCreators[action.selected].func;
  var args = evalArgs(action.args, action.rest);
  return actionCreator.apply(undefined, args);
}

function evalMethod(action, obj) {
  if (typeof action === 'string') {
    return new Function('return ' + action).call(obj);
  }

  var args = evalArgs(action.args, action.rest);
  return new Function('args', 'return this.' + action.name + '(args)').apply(obj, args);
}
/* eslint-enable */

function tryCatchStringify(obj) {
  try {
    return JSON.stringify(obj);
  } catch (err) {
    /* eslint-disable no-console */
    if ("development" !== 'production') console.log('Failed to stringify', err);
    /* eslint-enable no-console */
    return _jsan2.default.stringify(obj, null, null, { circular: '[CIRCULAR]' });
  }
}

function stringify(obj, serialize) {
  if (typeof serialize === 'undefined') {
    return tryCatchStringify(obj);
  }
  if (serialize === true) {
    return _jsan2.default.stringify(obj, function (key, value) {
      if (value && typeof value.toJS === 'function') return value.toJS();
      return value;
    }, null, true);
  }
  return _jsan2.default.stringify(obj, serialize.replacer, null, serialize.options);
}

function getSeralizeParameter(config, param) {
  var serialize = config.serialize;
  if (serialize) {
    if (serialize === true) return { options: true };
    if (serialize.immutable) {
      return {
        replacer: (0, _serialize2.default)(serialize.immutable, serialize.refs).replacer,
        options: serialize.options || true
      };
    }
    if (!serialize.replacer) return { options: serialize.options };
    return { replacer: serialize.replacer, options: serialize.options || true };
  }

  var value = config[param];
  if (typeof value === 'undefined') return undefined;
  console.warn('`' + param + '` parameter for Redux DevTools Extension is deprecated. Use `serialize` parameter instead: https://github.com/zalmoxisus/redux-devtools-extension/releases/tag/v2.12.1'); // eslint-disable-line

  if (typeof serializeState === 'boolean') return { options: value };
  if (typeof serializeState === 'function') return { replacer: value };
  return value;
}

function getStackTrace(config, toExcludeFromTrace) {
  if (!config.trace) return undefined;
  if (typeof config.trace === 'function') return config.trace();

  var stack = void 0;
  var extraFrames = 0;
  var prevStackTraceLimit = void 0;
  var traceLimit = config.traceLimit;
  var error = Error();
  if (Error.captureStackTrace) {
    if (Error.stackTraceLimit < traceLimit) {
      prevStackTraceLimit = Error.stackTraceLimit;
      Error.stackTraceLimit = traceLimit;
    }
    Error.captureStackTrace(error, toExcludeFromTrace);
  } else {
    extraFrames = 3;
  }
  stack = error.stack;
  if (prevStackTraceLimit) Error.stackTraceLimit = prevStackTraceLimit;
  if (extraFrames || typeof Error.stackTraceLimit !== 'number' || Error.stackTraceLimit > traceLimit) {
    var frames = stack.split('\n');
    if (frames.length > traceLimit) {
      stack = frames.slice(0, traceLimit + extraFrames + (frames[0] === 'Error' ? 1 : 0)).join('\n');
    }
  }
  return stack;
}
      };
    };
  }
  }
}, {package:"remote-redux-devtools>redux-devtools-core",file:"node_modules\\redux-devtools-core\\lib\\utils\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\redux-devtools-core\\node_modules\\nanoid\\non-secure\\index.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Credux-devtools-core%5Cnode_modules%5Cnanoid%5Cnon-secure%5Cindex.js
      return function (require, module, exports) {
// This alphabet uses a-z A-Z 0-9 _- symbols.
// Symbols are generated for smaller size.
// -_zyxwvutsrqponmlkjihgfedcba9876543210ZYXWVUTSRQPONMLKJIHGFEDCBA
var url = '-_'
// Loop from 36 to 0 (from z to a and 9 to 0 in Base36).
var i = 36
while (i--) {
  // 36 is radix. Number.prototype.toString(36) returns number
  // in Base36 representation. Base36 is like hex, but it uses 0–9 and a-z.
  url += i.toString(36)
}
// Loop from 36 to 10 (from Z to A in Base36).
i = 36
while (i-- - 10) {
  url += i.toString(36).toUpperCase()
}

/**
 * Generate URL-friendly unique ID. This method use non-secure predictable
 * random generator with bigger collision probability.
 *
 * @param {number} [size=21] The number of symbols in ID.
 *
 * @return {string} Random string.
 *
 * @example
 * const nanoid = require('nanoid/non-secure')
 * model.id = nanoid() //=> "Uakgb_J5m9g-0JDMbcJqL"
 *
 * @name nonSecure
 * @function
 */
module.exports = function (size) {
  var id = ''
  i = size || 21
  // Compact alternative for `for (var i = 0; i < size; i++)`
  while (i--) {
    // `| 0` is compact and faster alternative for `Math.floor()`
    id += url[Math.random() * 64 | 0]
  }
  return id
}

      };
    };
  }
  }
}, {package:"remote-redux-devtools>redux-devtools-core>nanoid",file:"node_modules\\redux-devtools-core\\node_modules\\nanoid\\non-secure\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\redux-devtools-instrument\\lib\\instrument.js", {"_process":"D:\\code\\v\\metamask-extension\\node_modules\\process\\browser.js","lodash/difference":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\difference.js","lodash/isPlainObject":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\isPlainObject.js","lodash/union":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\union.js","symbol-observable":"D:\\code\\v\\metamask-extension\\node_modules\\symbol-observable\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Credux-devtools-instrument%5Clib%5Cinstrument.js
      return function (require, module, exports) {
(function (process){(function (){
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.liftAction = liftAction;
exports.liftReducerWith = liftReducerWith;
exports.unliftState = unliftState;
exports.unliftStore = unliftStore;
exports["default"] = instrument;
exports.INIT_ACTION = exports.ActionCreators = exports.ActionTypes = void 0;

var _difference = _interopRequireDefault(require("lodash/difference"));

var _union = _interopRequireDefault(require("lodash/union"));

var _isPlainObject = _interopRequireDefault(require("lodash/isPlainObject"));

var _symbolObservable = _interopRequireDefault(require("symbol-observable"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var ActionTypes = {
  PERFORM_ACTION: 'PERFORM_ACTION',
  RESET: 'RESET',
  ROLLBACK: 'ROLLBACK',
  COMMIT: 'COMMIT',
  SWEEP: 'SWEEP',
  TOGGLE_ACTION: 'TOGGLE_ACTION',
  SET_ACTIONS_ACTIVE: 'SET_ACTIONS_ACTIVE',
  JUMP_TO_STATE: 'JUMP_TO_STATE',
  JUMP_TO_ACTION: 'JUMP_TO_ACTION',
  REORDER_ACTION: 'REORDER_ACTION',
  IMPORT_STATE: 'IMPORT_STATE',
  LOCK_CHANGES: 'LOCK_CHANGES',
  PAUSE_RECORDING: 'PAUSE_RECORDING'
};
exports.ActionTypes = ActionTypes;
var isChrome = (typeof window === "undefined" ? "undefined" : _typeof(window)) === 'object' && (typeof window.chrome !== 'undefined' || typeof window.process !== 'undefined' && window.process.type === 'renderer');
var isChromeOrNode = isChrome || typeof process !== 'undefined' && process.release && process.release.name === 'node';

/**
 * Action creators to change the History state.
 */
var ActionCreators = {
  performAction: function performAction(action, trace, traceLimit, // eslint-disable-next-line @typescript-eslint/ban-types
  toExcludeFromTrace) {
    if (!(0, _isPlainObject["default"])(action)) {
      throw new Error('Actions must be plain objects. ' + 'Use custom middleware for async actions.');
    }

    if (typeof action.type === 'undefined') {
      throw new Error('Actions may not have an undefined "type" property. ' + 'Have you misspelled a constant?');
    }

    var stack;

    if (trace) {
      var extraFrames = 0;

      if (typeof trace === 'function') {
        stack = trace(action);
      } else {
        var error = Error();
        var prevStackTraceLimit;

        if (Error.captureStackTrace && isChromeOrNode) {
          // avoid error-polyfill
          if (traceLimit && Error.stackTraceLimit < traceLimit) {
            prevStackTraceLimit = Error.stackTraceLimit;
            Error.stackTraceLimit = traceLimit;
          }

          Error.captureStackTrace(error, toExcludeFromTrace);
        } else {
          extraFrames = 3;
        }

        stack = error.stack;
        if (prevStackTraceLimit) Error.stackTraceLimit = prevStackTraceLimit;

        if (extraFrames || typeof Error.stackTraceLimit !== 'number' || traceLimit && Error.stackTraceLimit > traceLimit) {
          if (stack != null) {
            var frames = stack.split('\n');

            if (traceLimit && frames.length > traceLimit) {
              stack = frames.slice(0, traceLimit + extraFrames + (frames[0].startsWith('Error') ? 1 : 0)).join('\n');
            }
          }
        }
      }
    }

    return {
      type: ActionTypes.PERFORM_ACTION,
      action: action,
      timestamp: Date.now(),
      stack: stack
    };
  },
  reset: function reset() {
    return {
      type: ActionTypes.RESET,
      timestamp: Date.now()
    };
  },
  rollback: function rollback() {
    return {
      type: ActionTypes.ROLLBACK,
      timestamp: Date.now()
    };
  },
  commit: function commit() {
    return {
      type: ActionTypes.COMMIT,
      timestamp: Date.now()
    };
  },
  sweep: function sweep() {
    return {
      type: ActionTypes.SWEEP
    };
  },
  toggleAction: function toggleAction(id) {
    return {
      type: ActionTypes.TOGGLE_ACTION,
      id: id
    };
  },
  setActionsActive: function setActionsActive(start, end) {
    var active = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
    return {
      type: ActionTypes.SET_ACTIONS_ACTIVE,
      start: start,
      end: end,
      active: active
    };
  },
  reorderAction: function reorderAction(actionId, beforeActionId) {
    return {
      type: ActionTypes.REORDER_ACTION,
      actionId: actionId,
      beforeActionId: beforeActionId
    };
  },
  jumpToState: function jumpToState(index) {
    return {
      type: ActionTypes.JUMP_TO_STATE,
      index: index
    };
  },
  jumpToAction: function jumpToAction(actionId) {
    return {
      type: ActionTypes.JUMP_TO_ACTION,
      actionId: actionId
    };
  },
  importState: function importState(nextLiftedState, noRecompute) {
    return {
      type: ActionTypes.IMPORT_STATE,
      nextLiftedState: nextLiftedState,
      noRecompute: noRecompute
    };
  },
  lockChanges: function lockChanges(status) {
    return {
      type: ActionTypes.LOCK_CHANGES,
      status: status
    };
  },
  pauseRecording: function pauseRecording(status) {
    return {
      type: ActionTypes.PAUSE_RECORDING,
      status: status
    };
  }
};
exports.ActionCreators = ActionCreators;
var INIT_ACTION = {
  type: '@@INIT'
};
/**
 * Computes the next entry with exceptions catching.
 */

exports.INIT_ACTION = INIT_ACTION;

function computeWithTryCatch(reducer, action, state) {
  var nextState = state;
  var nextError;

  try {
    nextState = reducer(state, action);
  } catch (err) {
    nextError = err.toString();

    if (isChrome) {
      // In Chrome, rethrowing provides better source map support
      setTimeout(function () {
        throw err;
      });
    } else {
      console.error(err); // eslint-disable-line no-console
    }
  }

  return {
    state: nextState,
    error: nextError
  };
}
/**
 * Computes the next entry in the log by applying an action.
 */


function computeNextEntry(reducer, action, state, shouldCatchErrors) {
  if (!shouldCatchErrors) {
    return {
      state: reducer(state, action)
    };
  }

  return computeWithTryCatch(reducer, action, state);
}
/**
 * Runs the reducer on invalidated actions to get a fresh computation log.
 */


function recomputeStates(computedStates, minInvalidatedStateIndex, reducer, committedState, actionsById, stagedActionIds, skippedActionIds, shouldCatchErrors) {
  // Optimization: exit early and return the same reference
  // if we know nothing could have changed.
  if (!computedStates || minInvalidatedStateIndex === -1 || minInvalidatedStateIndex >= computedStates.length && computedStates.length === stagedActionIds.length) {
    return computedStates;
  }

  var nextComputedStates = computedStates.slice(0, minInvalidatedStateIndex);

  for (var i = minInvalidatedStateIndex; i < stagedActionIds.length; i++) {
    var _actionId = stagedActionIds[i];
    var _action = actionsById[_actionId].action;
    var previousEntry = nextComputedStates[i - 1];
    var previousState = previousEntry ? previousEntry.state : committedState;
    var shouldSkip = skippedActionIds.indexOf(_actionId) > -1;
    var entry = void 0;

    if (shouldSkip) {
      entry = previousEntry;
    } else {
      if (shouldCatchErrors && previousEntry && previousEntry.error) {
        entry = {
          state: previousState,
          error: 'Interrupted by an error up the chain'
        };
      } else {
        entry = computeNextEntry(reducer, _action, previousState, shouldCatchErrors);
      }
    }

    nextComputedStates.push(entry);
  }

  return nextComputedStates;
}
/**
 * Lifts an app's action into an action on the lifted store.
 */


function liftAction(action, trace, traceLimit, // eslint-disable-next-line @typescript-eslint/ban-types
toExcludeFromTrace) {
  return ActionCreators.performAction(action, trace, traceLimit, toExcludeFromTrace);
}

function isArray(nextLiftedState) {
  return Array.isArray(nextLiftedState);
}

/**
 * Creates a history state reducer from an app's reducer.
 */
function liftReducerWith(reducer, initialCommittedState, monitorReducer, options) {
  var initialLiftedState = {
    monitorState: monitorReducer(undefined, {}),
    nextActionId: 1,
    actionsById: {
      0: liftAction(INIT_ACTION)
    },
    stagedActionIds: [0],
    skippedActionIds: [],
    committedState: initialCommittedState,
    currentStateIndex: 0,
    computedStates: [],
    isLocked: options.shouldStartLocked === true,
    isPaused: options.shouldRecordChanges === false
  };
  /**
   * Manages how the history actions modify the history state.
   */

  return function (liftedState, liftedAction) {
    var _ref = liftedState || initialLiftedState,
        monitorState = _ref.monitorState,
        actionsById = _ref.actionsById,
        nextActionId = _ref.nextActionId,
        stagedActionIds = _ref.stagedActionIds,
        skippedActionIds = _ref.skippedActionIds,
        committedState = _ref.committedState,
        currentStateIndex = _ref.currentStateIndex,
        computedStates = _ref.computedStates,
        isLocked = _ref.isLocked,
        isPaused = _ref.isPaused;

    if (!liftedState) {
      // Prevent mutating initialLiftedState
      actionsById = _objectSpread({}, actionsById);
    }

    function commitExcessActions(n) {
      // Auto-commits n-number of excess actions.
      var excess = n;
      var idsToDelete = stagedActionIds.slice(1, excess + 1);

      for (var i = 0; i < idsToDelete.length; i++) {
        if (computedStates[i + 1].error) {
          // Stop if error is found. Commit actions up to error.
          excess = i;
          idsToDelete = stagedActionIds.slice(1, excess + 1);
          break;
        } else {
          delete actionsById[idsToDelete[i]];
        }
      }

      skippedActionIds = skippedActionIds.filter(function (id) {
        return idsToDelete.indexOf(id) === -1;
      });
      stagedActionIds = [0].concat(_toConsumableArray(stagedActionIds.slice(excess + 1)));
      committedState = computedStates[excess].state;
      computedStates = computedStates.slice(excess);
      currentStateIndex = currentStateIndex > excess ? currentStateIndex - excess : 0;
    }

    function computePausedAction(shouldInit) {
      var computedState;

      if (shouldInit) {
        computedState = computedStates[currentStateIndex];
        monitorState = monitorReducer(monitorState, liftedAction);
      } else {
        computedState = computeNextEntry(reducer, liftedAction.action, computedStates[currentStateIndex].state, false);
      }

      if (!options.pauseActionType || nextActionId === 1) {
        return {
          monitorState: monitorState,
          actionsById: {
            0: liftAction(INIT_ACTION)
          },
          nextActionId: 1,
          stagedActionIds: [0],
          skippedActionIds: [],
          committedState: computedState.state,
          currentStateIndex: 0,
          computedStates: [computedState],
          isLocked: isLocked,
          isPaused: true
        };
      }

      if (shouldInit) {
        if (currentStateIndex === stagedActionIds.length - 1) {
          currentStateIndex++;
        }

        stagedActionIds = [].concat(_toConsumableArray(stagedActionIds), [nextActionId]);
        nextActionId++;
      }

      return {
        monitorState: monitorState,
        actionsById: _objectSpread(_objectSpread({}, actionsById), {}, _defineProperty({}, nextActionId - 1, liftAction({
          type: options.pauseActionType
        }))),
        nextActionId: nextActionId,
        stagedActionIds: stagedActionIds,
        skippedActionIds: skippedActionIds,
        committedState: committedState,
        currentStateIndex: currentStateIndex,
        computedStates: [].concat(_toConsumableArray(computedStates.slice(0, stagedActionIds.length - 1)), [computedState]),
        isLocked: isLocked,
        isPaused: true
      };
    } // By default, aggressively recompute every state whatever happens.
    // This has O(n) performance, so we'll override this to a sensible
    // value whenever we feel like we don't have to recompute the states.


    var minInvalidatedStateIndex = 0; // maxAge number can be changed dynamically

    var maxAge = options.maxAge;
    if (typeof maxAge === 'function') maxAge = maxAge(liftedAction, liftedState);

    if (/^@@redux\/(INIT|REPLACE)/.test(liftedAction.type)) {
      if (options.shouldHotReload === false) {
        actionsById = {
          0: liftAction(INIT_ACTION)
        };
        nextActionId = 1;
        stagedActionIds = [0];
        skippedActionIds = [];
        committedState = computedStates.length === 0 ? initialCommittedState : computedStates[currentStateIndex].state;
        currentStateIndex = 0;
        computedStates = [];
      } // Recompute states on hot reload and init.


      minInvalidatedStateIndex = 0;

      if (maxAge && stagedActionIds.length > maxAge) {
        // States must be recomputed before committing excess.
        computedStates = recomputeStates(computedStates, minInvalidatedStateIndex, reducer, committedState, actionsById, stagedActionIds, skippedActionIds, options.shouldCatchErrors);
        commitExcessActions(stagedActionIds.length - maxAge); // Avoid double computation.

        minInvalidatedStateIndex = Infinity;
      }
    } else {
      switch (liftedAction.type) {
        case ActionTypes.PERFORM_ACTION:
          {
            if (isLocked) return liftedState || initialLiftedState;
            if (isPaused) return computePausedAction(); // Auto-commit as new actions come in.

            if (maxAge && stagedActionIds.length >= maxAge) {
              commitExcessActions(stagedActionIds.length - maxAge + 1);
            }

            if (currentStateIndex === stagedActionIds.length - 1) {
              currentStateIndex++;
            }

            var _actionId2 = nextActionId++; // Mutation! This is the hottest path, and we optimize on purpose.
            // It is safe because we set a new key in a cache dictionary.


            actionsById[_actionId2] = liftedAction;
            stagedActionIds = [].concat(_toConsumableArray(stagedActionIds), [_actionId2]); // Optimization: we know that only the new action needs computing.

            minInvalidatedStateIndex = stagedActionIds.length - 1;
            break;
          }

        case ActionTypes.RESET:
          {
            // Get back to the state the store was created with.
            actionsById = {
              0: liftAction(INIT_ACTION)
            };
            nextActionId = 1;
            stagedActionIds = [0];
            skippedActionIds = [];
            committedState = initialCommittedState;
            currentStateIndex = 0;
            computedStates = [];
            break;
          }

        case ActionTypes.COMMIT:
          {
            // Consider the last committed state the new starting point.
            // Squash any staged actions into a single committed state.
            actionsById = {
              0: liftAction(INIT_ACTION)
            };
            nextActionId = 1;
            stagedActionIds = [0];
            skippedActionIds = [];
            committedState = computedStates[currentStateIndex].state;
            currentStateIndex = 0;
            computedStates = [];
            break;
          }

        case ActionTypes.ROLLBACK:
          {
            // Forget about any staged actions.
            // Start again from the last committed state.
            actionsById = {
              0: liftAction(INIT_ACTION)
            };
            nextActionId = 1;
            stagedActionIds = [0];
            skippedActionIds = [];
            currentStateIndex = 0;
            computedStates = [];
            break;
          }

        case ActionTypes.TOGGLE_ACTION:
          {
            // Toggle whether an action with given ID is skipped.
            // Being skipped means it is a no-op during the computation.
            var _actionId3 = liftedAction.id;
            var index = skippedActionIds.indexOf(_actionId3);

            if (index === -1) {
              skippedActionIds = [_actionId3].concat(_toConsumableArray(skippedActionIds));
            } else {
              skippedActionIds = skippedActionIds.filter(function (id) {
                return id !== _actionId3;
              });
            } // Optimization: we know history before this action hasn't changed


            minInvalidatedStateIndex = stagedActionIds.indexOf(_actionId3);
            break;
          }

        case ActionTypes.SET_ACTIONS_ACTIVE:
          {
            // Toggle whether an action with given ID is skipped.
            // Being skipped means it is a no-op during the computation.
            var start = liftedAction.start,
                end = liftedAction.end,
                active = liftedAction.active;
            var actionIds = [];

            for (var i = start; i < end; i++) {
              actionIds.push(i);
            }

            if (active) {
              skippedActionIds = (0, _difference["default"])(skippedActionIds, actionIds);
            } else {
              skippedActionIds = (0, _union["default"])(skippedActionIds, actionIds);
            } // Optimization: we know history before this action hasn't changed


            minInvalidatedStateIndex = stagedActionIds.indexOf(start);
            break;
          }

        case ActionTypes.JUMP_TO_STATE:
          {
            // Without recomputing anything, move the pointer that tell us
            // which state is considered the current one. Useful for sliders.
            currentStateIndex = liftedAction.index; // Optimization: we know the history has not changed.

            minInvalidatedStateIndex = Infinity;
            break;
          }

        case ActionTypes.JUMP_TO_ACTION:
          {
            // Jumps to a corresponding state to a specific action.
            // Useful when filtering actions.
            var _index = stagedActionIds.indexOf(liftedAction.actionId);

            if (_index !== -1) currentStateIndex = _index;
            minInvalidatedStateIndex = Infinity;
            break;
          }

        case ActionTypes.SWEEP:
          {
            // Forget any actions that are currently being skipped.
            stagedActionIds = (0, _difference["default"])(stagedActionIds, skippedActionIds);
            skippedActionIds = [];
            currentStateIndex = Math.min(currentStateIndex, stagedActionIds.length - 1);
            break;
          }

        case ActionTypes.REORDER_ACTION:
          {
            // Recompute actions in a new order.
            var _actionId4 = liftedAction.actionId;
            var idx = stagedActionIds.indexOf(_actionId4); // do nothing in case the action is already removed or trying to move the first action

            if (idx < 1) break;
            var beforeActionId = liftedAction.beforeActionId;
            var newIdx = stagedActionIds.indexOf(beforeActionId);

            if (newIdx < 1) {
              // move to the beginning or to the end
              var count = stagedActionIds.length;
              newIdx = beforeActionId > stagedActionIds[count - 1] ? count : 1;
            }

            var diff = idx - newIdx;

            if (diff > 0) {
              // move left
              stagedActionIds = [].concat(_toConsumableArray(stagedActionIds.slice(0, newIdx)), [_actionId4], _toConsumableArray(stagedActionIds.slice(newIdx, idx)), _toConsumableArray(stagedActionIds.slice(idx + 1)));
              minInvalidatedStateIndex = newIdx;
            } else if (diff < 0) {
              // move right
              stagedActionIds = [].concat(_toConsumableArray(stagedActionIds.slice(0, idx)), _toConsumableArray(stagedActionIds.slice(idx + 1, newIdx)), [_actionId4], _toConsumableArray(stagedActionIds.slice(newIdx)));
              minInvalidatedStateIndex = idx;
            }

            break;
          }

        case ActionTypes.IMPORT_STATE:
          {
            if (isArray(liftedAction.nextLiftedState)) {
              // recompute array of actions
              actionsById = {
                0: liftAction(INIT_ACTION)
              };
              nextActionId = 1;
              stagedActionIds = [0];
              skippedActionIds = [];
              currentStateIndex = liftedAction.nextLiftedState.length;
              computedStates = [];
              committedState = liftedAction.preloadedState;
              minInvalidatedStateIndex = 0; // iterate through actions

              liftedAction.nextLiftedState.forEach(function (action) {
                actionsById[nextActionId] = liftAction(action, options.trace || options.shouldIncludeCallstack);
                stagedActionIds.push(nextActionId);
                nextActionId++;
              });
            } else {
              // Completely replace everything.
              var _liftedAction$nextLif = liftedAction.nextLiftedState;
              monitorState = _liftedAction$nextLif.monitorState;
              actionsById = _liftedAction$nextLif.actionsById;
              nextActionId = _liftedAction$nextLif.nextActionId;
              stagedActionIds = _liftedAction$nextLif.stagedActionIds;
              skippedActionIds = _liftedAction$nextLif.skippedActionIds;
              committedState = _liftedAction$nextLif.committedState;
              currentStateIndex = _liftedAction$nextLif.currentStateIndex;
              computedStates = _liftedAction$nextLif.computedStates;

              if (liftedAction.noRecompute) {
                minInvalidatedStateIndex = Infinity;
              }
            }

            break;
          }

        case ActionTypes.LOCK_CHANGES:
          {
            isLocked = liftedAction.status;
            minInvalidatedStateIndex = Infinity;
            break;
          }

        case ActionTypes.PAUSE_RECORDING:
          {
            isPaused = liftedAction.status;

            if (isPaused) {
              return computePausedAction(true);
            } // Commit when unpausing


            actionsById = {
              0: liftAction(INIT_ACTION)
            };
            nextActionId = 1;
            stagedActionIds = [0];
            skippedActionIds = [];
            committedState = computedStates[currentStateIndex].state;
            currentStateIndex = 0;
            computedStates = [];
            break;
          }

        default:
          {
            // If the action is not recognized, it's a monitor action.
            // Optimization: a monitor action can't change history.
            minInvalidatedStateIndex = Infinity;
            break;
          }
      }
    }

    computedStates = recomputeStates(computedStates, minInvalidatedStateIndex, reducer, committedState, actionsById, stagedActionIds, skippedActionIds, options.shouldCatchErrors);
    monitorState = monitorReducer(monitorState, liftedAction);
    return {
      monitorState: monitorState,
      actionsById: actionsById,
      nextActionId: nextActionId,
      stagedActionIds: stagedActionIds,
      skippedActionIds: skippedActionIds,
      committedState: committedState,
      currentStateIndex: currentStateIndex,
      computedStates: computedStates,
      isLocked: isLocked,
      isPaused: isPaused
    };
  };
}
/**
 * Provides an app's view into the state of the lifted store.
 */


function unliftState(liftedState) {
  var computedStates = liftedState.computedStates,
      currentStateIndex = liftedState.currentStateIndex;
  var state = computedStates[currentStateIndex].state;
  return state;
}

/**
 * Provides an app's view into the lifted store.
 */
function unliftStore(liftedStore, liftReducer, options) {
  var lastDefinedState;
  var trace = options.trace || options.shouldIncludeCallstack;
  var traceLimit = options.traceLimit || 10;

  function getState() {
    var state = unliftState(liftedStore.getState());

    if (state !== undefined) {
      lastDefinedState = state;
    }

    return lastDefinedState;
  }

  function dispatch(action) {
    liftedStore.dispatch(liftAction(action, trace, traceLimit, dispatch));
    return action;
  }

  return _objectSpread(_objectSpread({}, liftedStore), {}, _defineProperty({
    liftedStore: liftedStore,
    dispatch: dispatch,
    getState: getState,
    replaceReducer: function replaceReducer(nextReducer) {
      liftedStore.replaceReducer(liftReducer(nextReducer));
    }
  }, _symbolObservable["default"], function () {
    return _objectSpread(_objectSpread({}, liftedStore[_symbolObservable["default"]]()), {}, _defineProperty({
      subscribe: function subscribe(observer) {
        if (_typeof(observer) !== 'object') {
          throw new TypeError('Expected the observer to be an object.');
        }

        function observeState() {
          if (observer.next) {
            observer.next(getState());
          }
        }

        observeState();
        var unsubscribe = liftedStore.subscribe(observeState);
        return {
          unsubscribe: unsubscribe
        };
      }
    }, _symbolObservable["default"], function () {
      return this;
    }));
  }));
}

/**
 * Redux instrumentation store enhancer.
 */
function instrument() {
  var monitorReducer = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : function () {
    return null;
  };
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

  if (typeof options.maxAge === 'number' && options.maxAge < 2) {
    throw new Error('DevTools.instrument({ maxAge }) option, if specified, ' + 'may not be less than 2.');
  }

  return function (createStore) {
    return function (reducer, initialState) {
      function liftReducer(r) {
        if (typeof r !== 'function') {
          if (r && typeof r["default"] === 'function') {
            throw new Error('Expected the reducer to be a function. ' + 'Instead got an object with a "default" field. ' + 'Did you pass a module instead of the default export? ' + 'Try passing require(...).default instead.');
          }

          throw new Error('Expected the reducer to be a function.');
        }

        return liftReducerWith(r, initialState, monitorReducer, options);
      }

      var liftedStore = createStore(liftReducer(reducer));

      if (liftedStore.liftedStore) {
        throw new Error('DevTools instrumentation should not be applied more than once. ' + 'Check your store configuration.');
      }

      return unliftStore(liftedStore, liftReducer, options);
    };
  };
}

}).call(this)}).call(this,require('_process'))

      };
    };
  }
  }
}, {package:"remote-redux-devtools>redux-devtools-instrument",file:"node_modules\\redux-devtools-instrument\\lib\\instrument.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\regexp.prototype.flags\\implementation.js", {"es-errors/type":"D:\\code\\v\\metamask-extension\\node_modules\\es-errors\\type.js","set-function-name":"D:\\code\\v\\metamask-extension\\node_modules\\set-function-name\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cregexp.prototype.flags%5Cimplementation.js
      return function (require, module, exports) {
'use strict';

var setFunctionName = require('set-function-name');
var $TypeError = require('es-errors/type');

var $Object = Object;

module.exports = setFunctionName(function flags() {
	if (this == null || this !== $Object(this)) {
		throw new $TypeError('RegExp.prototype.flags getter called on non-object');
	}
	var result = '';
	if (this.hasIndices) {
		result += 'd';
	}
	if (this.global) {
		result += 'g';
	}
	if (this.ignoreCase) {
		result += 'i';
	}
	if (this.multiline) {
		result += 'm';
	}
	if (this.dotAll) {
		result += 's';
	}
	if (this.unicode) {
		result += 'u';
	}
	if (this.unicodeSets) {
		result += 'v';
	}
	if (this.sticky) {
		result += 'y';
	}
	return result;
}, 'get flags', true);


      };
    };
  }
  }
}, {package:"string.prototype.matchall>regexp.prototype.flags",file:"node_modules\\regexp.prototype.flags\\implementation.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\regexp.prototype.flags\\index.js", {"./implementation":"D:\\code\\v\\metamask-extension\\node_modules\\regexp.prototype.flags\\implementation.js","./polyfill":"D:\\code\\v\\metamask-extension\\node_modules\\regexp.prototype.flags\\polyfill.js","./shim":"D:\\code\\v\\metamask-extension\\node_modules\\regexp.prototype.flags\\shim.js","call-bind":"D:\\code\\v\\metamask-extension\\node_modules\\call-bind\\index.js","define-properties":"D:\\code\\v\\metamask-extension\\node_modules\\define-properties\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cregexp.prototype.flags%5Cindex.js
      return function (require, module, exports) {
'use strict';

var define = require('define-properties');
var callBind = require('call-bind');

var implementation = require('./implementation');
var getPolyfill = require('./polyfill');
var shim = require('./shim');

var flagsBound = callBind(getPolyfill());

define(flagsBound, {
	getPolyfill: getPolyfill,
	implementation: implementation,
	shim: shim
});

module.exports = flagsBound;

      };
    };
  }
  }
}, {package:"string.prototype.matchall>regexp.prototype.flags",file:"node_modules\\regexp.prototype.flags\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\regexp.prototype.flags\\polyfill.js", {"./implementation":"D:\\code\\v\\metamask-extension\\node_modules\\regexp.prototype.flags\\implementation.js","define-properties":"D:\\code\\v\\metamask-extension\\node_modules\\define-properties\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cregexp.prototype.flags%5Cpolyfill.js
      return function (require, module, exports) {
'use strict';

var implementation = require('./implementation');

var supportsDescriptors = require('define-properties').supportsDescriptors;
var $gOPD = Object.getOwnPropertyDescriptor;

module.exports = function getPolyfill() {
	if (supportsDescriptors && (/a/mig).flags === 'gim') {
		var descriptor = $gOPD(RegExp.prototype, 'flags');
		if (
			descriptor
			&& typeof descriptor.get === 'function'
			&& 'dotAll' in RegExp.prototype
			&& 'hasIndices' in RegExp.prototype
		) {
			/* eslint getter-return: 0 */
			var calls = '';
			var o = {};
			Object.defineProperty(o, 'hasIndices', {
				get: function () {
					calls += 'd';
				}
			});
			Object.defineProperty(o, 'sticky', {
				get: function () {
					calls += 'y';
				}
			});

			descriptor.get.call(o);

			if (calls === 'dy') {
				return descriptor.get;
			}
		}
	}
	return implementation;
};

      };
    };
  }
  }
}, {package:"string.prototype.matchall>regexp.prototype.flags",file:"node_modules\\regexp.prototype.flags\\polyfill.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\regexp.prototype.flags\\shim.js", {"./polyfill":"D:\\code\\v\\metamask-extension\\node_modules\\regexp.prototype.flags\\polyfill.js","define-properties":"D:\\code\\v\\metamask-extension\\node_modules\\define-properties\\index.js","es-errors":"D:\\code\\v\\metamask-extension\\node_modules\\es-errors\\index.js","get-proto":"D:\\code\\v\\metamask-extension\\node_modules\\get-proto\\index.js","gopd":"D:\\code\\v\\metamask-extension\\node_modules\\gopd\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cregexp.prototype.flags%5Cshim.js
      return function (require, module, exports) {
'use strict';

var supportsDescriptors = require('define-properties').supportsDescriptors;
var getPolyfill = require('./polyfill');
var gOPD = require('gopd');
var defineProperty = Object.defineProperty;
var $TypeError = require('es-errors');
var getProto = require('get-proto');
var regex = /a/;

module.exports = function shimFlags() {
	if (!supportsDescriptors || !getProto) {
		throw new $TypeError('RegExp.prototype.flags requires a true ES5 environment that supports property descriptors');
	}
	var polyfill = getPolyfill();
	var proto = getProto(regex);
	var descriptor = gOPD(proto, 'flags');
	if (!descriptor || descriptor.get !== polyfill) {
		defineProperty(proto, 'flags', {
			configurable: true,
			enumerable: false,
			get: polyfill
		});
	}
	return polyfill;
};

      };
    };
  }
  }
}, {package:"string.prototype.matchall>regexp.prototype.flags",file:"node_modules\\regexp.prototype.flags\\shim.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\remark-parse\\index.js", {"mdast-util-from-markdown":"D:\\code\\v\\metamask-extension\\node_modules\\mdast-util-from-markdown\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cremark-parse%5Cindex.js
      return function (require, module, exports) {
'use strict'

module.exports = parse

var fromMarkdown = require('mdast-util-from-markdown')

function parse(options) {
  var self = this

  this.Parser = parse

  function parse(doc) {
    return fromMarkdown(
      doc,
      Object.assign({}, self.data('settings'), options, {
        // Note: these options are not in the readme.
        // The goal is for them to be set by plugins on `data` instead of being
        // passed by users.
        extensions: self.data('micromarkExtensions') || [],
        mdastExtensions: self.data('fromMarkdownExtensions') || []
      })
    )
  }
}

      };
    };
  }
  }
}, {package:"react-markdown>remark-parse",file:"node_modules\\remark-parse\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\remark-rehype\\index.js", {"mdast-util-to-hast":"D:\\code\\v\\metamask-extension\\node_modules\\mdast-util-to-hast\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cremark-rehype%5Cindex.js
      return function (require, module, exports) {
'use strict'

var mdast2hast = require('mdast-util-to-hast')

module.exports = remark2rehype

// Attacher.
// If a destination is given, runs the destination with the new hast tree
// (bridge mode).
// Without destination, returns the tree: further plugins run on that tree
// (mutate mode).
function remark2rehype(destination, options) {
  if (destination && !destination.process) {
    options = destination
    destination = null
  }

  return destination ? bridge(destination, options) : mutate(options)
}

// Bridge mode.
// Runs the destination with the new hast tree.
function bridge(destination, options) {
  return transformer

  function transformer(node, file, next) {
    destination.run(mdast2hast(node, options), file, done)

    function done(error) {
      next(error)
    }
  }
}

// Mutate-mode.
// Further transformers run on the hast tree.
function mutate(options) {
  return transformer

  function transformer(node) {
    return mdast2hast(node, options)
  }
}

      };
    };
  }
  }
}, {package:"react-markdown>remark-rehype",file:"node_modules\\remark-rehype\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\remote-redux-devtools\\lib\\configureStore.js", {"redux-devtools-instrument":"D:\\code\\v\\metamask-extension\\node_modules\\redux-devtools-instrument\\lib\\instrument.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cremote-redux-devtools%5Clib%5CconfigureStore.js
      return function (require, module, exports) {
'use strict';

exports.__esModule = true;
exports.default = configureStore;

var _reduxDevtoolsInstrument = require('redux-devtools-instrument');

var _reduxDevtoolsInstrument2 = _interopRequireDefault(_reduxDevtoolsInstrument);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function configureStore(next, subscriber, options) {
  return (0, _reduxDevtoolsInstrument2.default)(subscriber, options)(next);
}
      };
    };
  }
  }
}, {package:"remote-redux-devtools",file:"node_modules\\remote-redux-devtools\\lib\\configureStore.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\remote-redux-devtools\\lib\\constants.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cremote-redux-devtools%5Clib%5Cconstants.js
      return function (require, module, exports) {
'use strict';

exports.__esModule = true;
var defaultSocketOptions = exports.defaultSocketOptions = {
  secure: true,
  hostname: 'remotedev.io',
  port: 443,
  autoReconnect: true,
  autoReconnectOptions: {
    randomness: 30000
  }
};
      };
    };
  }
  }
}, {package:"remote-redux-devtools",file:"node_modules\\remote-redux-devtools\\lib\\constants.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\remote-redux-devtools\\lib\\devTools.js", {"./configureStore":"D:\\code\\v\\metamask-extension\\node_modules\\remote-redux-devtools\\lib\\configureStore.js","./constants":"D:\\code\\v\\metamask-extension\\node_modules\\remote-redux-devtools\\lib\\constants.js","jsan":"D:\\code\\v\\metamask-extension\\node_modules\\jsan\\index.js","redux-devtools-core/lib/utils":"D:\\code\\v\\metamask-extension\\node_modules\\redux-devtools-core\\lib\\utils\\index.js","redux-devtools-core/lib/utils/catchErrors":"D:\\code\\v\\metamask-extension\\node_modules\\redux-devtools-core\\lib\\utils\\catchErrors.js","redux-devtools-core/lib/utils/filters":"D:\\code\\v\\metamask-extension\\node_modules\\redux-devtools-core\\lib\\utils\\filters.js","rn-host-detect":"D:\\code\\v\\metamask-extension\\node_modules\\rn-host-detect\\index.js","socketcluster-client":"D:\\code\\v\\metamask-extension\\node_modules\\socketcluster-client\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cremote-redux-devtools%5Clib%5CdevTools.js
      return function (require, module, exports) {
'use strict';

exports.__esModule = true;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports.default = devToolsEnhancer;
exports.preEnhancer = preEnhancer;
exports.composeWithDevTools = composeWithDevTools;

var _jsan = require('jsan');

var _socketclusterClient = require('socketcluster-client');

var _socketclusterClient2 = _interopRequireDefault(_socketclusterClient);

var _configureStore = require('./configureStore');

var _configureStore2 = _interopRequireDefault(_configureStore);

var _constants = require('./constants');

var _rnHostDetect = require('rn-host-detect');

var _rnHostDetect2 = _interopRequireDefault(_rnHostDetect);

var _utils = require('redux-devtools-core/lib/utils');

var _catchErrors = require('redux-devtools-core/lib/utils/catchErrors');

var _catchErrors2 = _interopRequireDefault(_catchErrors);

var _filters = require('redux-devtools-core/lib/utils/filters');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var instanceId = void 0;
var instanceName = void 0;
var suppressConnectErrors = void 0;
var errorCounts = {};
var socketOptions = void 0;
var socket = void 0;
var channel = void 0;
var store = {};
var lastAction = void 0;
var filters = void 0;
var isExcess = void 0;
var isMonitored = void 0;
var started = void 0;
var startOn = void 0;
var stopOn = void 0;
var sendOn = void 0;
var sendOnError = void 0;
var sendTo = void 0;
var lastErrorMsg = void 0;
var locked = void 0;
var paused = void 0;
var actionCreators = void 0;
var stateSanitizer = void 0;
var actionSanitizer = void 0;

function getLiftedState() {
  return (0, _filters.filterStagedActions)(store.liftedStore.getState(), filters);
}

function send() {
  if (!instanceId) instanceId = socket && socket.id || Math.random().toString(36).substr(2);
  try {
    fetch(sendTo, {
      method: 'POST',
      headers: {
        'content-type': 'application/json'
      },
      body: JSON.stringify({
        type: 'STATE',
        id: instanceId,
        name: instanceName,
        payload: (0, _jsan.stringify)(getLiftedState())
      })
    }).catch(function (err) {
      console.log(err);
    });
  } catch (err) {
    console.log(err);
  }
}

function relay(type, state, action, nextActionId) {
  var message = {
    type: type,
    id: socket.id,
    name: instanceName
  };
  if (state) {
    message.payload = type === 'ERROR' ? state : (0, _jsan.stringify)((0, _filters.filterState)(state, type, filters, stateSanitizer, actionSanitizer, nextActionId));
  }
  if (type === 'ACTION') {
    message.action = (0, _jsan.stringify)(!actionSanitizer ? action : actionSanitizer(action.action, nextActionId - 1));
    message.isExcess = isExcess;
    message.nextActionId = nextActionId;
  } else if (action) {
    message.action = action;
  }
  socket.emit(socket.id ? 'log' : 'log-noid', message);
}

function dispatchRemotely(action) {
  try {
    var result = (0, _utils.evalAction)(action, actionCreators);
    store.dispatch(result);
  } catch (e) {
    relay('ERROR', e.message);
  }
}

function handleMessages(message) {
  if (message.type === 'IMPORT' || message.type === 'SYNC' && socket.id && message.id !== socket.id) {
    store.liftedStore.dispatch({
      type: 'IMPORT_STATE', nextLiftedState: (0, _jsan.parse)(message.state)
    });
  } else if (message.type === 'UPDATE') {
    relay('STATE', getLiftedState());
  } else if (message.type === 'START') {
    isMonitored = true;
    if (typeof actionCreators === 'function') actionCreators = actionCreators();
    relay('STATE', getLiftedState(), actionCreators);
  } else if (message.type === 'STOP' || message.type === 'DISCONNECTED') {
    isMonitored = false;
    relay('STOP');
  } else if (message.type === 'ACTION') {
    dispatchRemotely(message.action);
  } else if (message.type === 'DISPATCH') {
    store.liftedStore.dispatch(message.action);
  }
}

function async(fn) {
  setTimeout(fn, 0);
}

function sendError(errorAction) {
  // Prevent flooding
  if (errorAction.message && errorAction.message === lastErrorMsg) return;
  lastErrorMsg = errorAction.message;

  async(function () {
    store.dispatch(errorAction);
    if (!started) send();
  });
}

function str2array(str) {
  return typeof str === 'string' ? [str] : str && str.length;
}

function init(options) {
  instanceName = options.name;

  var _ref = options.filters || {},
      blacklist = _ref.blacklist,
      whitelist = _ref.whitelist;

  filters = (0, _filters.getLocalFilter)({
    actionsBlacklist: blacklist || options.actionsBlacklist,
    actionsWhitelist: whitelist || options.actionsWhitelist
  });
  if (options.port) {
    socketOptions = {
      port: options.port,
      hostname: options.hostname || 'localhost',
      secure: options.secure
    };
  } else socketOptions = _constants.defaultSocketOptions;

  suppressConnectErrors = options.suppressConnectErrors !== undefined ? options.suppressConnectErrors : true;

  startOn = str2array(options.startOn);
  stopOn = str2array(options.stopOn);
  sendOn = str2array(options.sendOn);
  sendOnError = options.sendOnError;
  if (sendOn || sendOnError) {
    sendTo = options.sendTo || (socketOptions.secure ? 'https' : 'http') + '://' + socketOptions.hostname + ':' + socketOptions.port;
    instanceId = options.id;
  }
  if (sendOnError === 1) (0, _catchErrors2.default)(sendError);

  if (options.actionCreators) actionCreators = function actionCreators() {
    return (0, _utils.getActionsArray)(options.actionCreators);
  };
  stateSanitizer = options.stateSanitizer;
  actionSanitizer = options.actionSanitizer;
}

function login() {
  socket.emit('login', 'master', function (err, channelName) {
    if (err) {
      console.log(err);return;
    }
    channel = channelName;
    socket.subscribe(channelName).watch(handleMessages);
    socket.on(channelName, handleMessages);
  });
  started = true;
  relay('START');
}

function stop(keepConnected) {
  started = false;
  isMonitored = false;
  if (!socket) return;
  socket.destroyChannel(channel);
  if (keepConnected) {
    socket.off(channel, handleMessages);
  } else {
    socket.off();
    socket.disconnect();
  }
}

function start() {
  if (started || socket && socket.getState() === socket.CONNECTING) return;

  socket = _socketclusterClient2.default.connect(socketOptions);

  socket.on('error', function (err) {
    // if we've already had this error before, increment it's counter, otherwise assign it '1' since we've had the error once.
    errorCounts[err.name] = errorCounts.hasOwnProperty(err.name) ? errorCounts[err.name] + 1 : 1;

    if (suppressConnectErrors) {
      if (errorCounts[err.name] === 1) {
        console.log('remote-redux-devtools: Socket connection errors are being suppressed. ' + '\n' + 'This can be disabled by setting suppressConnectErrors to \'false\'.');
        console.log(err);
      }
    } else {
      console.log(err);
    }
  });
  socket.on('connect', function () {
    console.log('connected to remotedev-server');
    errorCounts = {}; // clear the errorCounts object, so that we'll log any new errors in the event of a disconnect
    login();
  });
  socket.on('disconnect', function () {
    stop(true);
  });
}

function checkForReducerErrors() {
  var liftedState = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : store.liftedStore.getState();

  if (liftedState.computedStates[liftedState.currentStateIndex].error) {
    if (started) relay('STATE', (0, _filters.filterStagedActions)(liftedState, filters));else send();
    return true;
  }
  return false;
}

function monitorReducer() {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var action = arguments[1];

  lastAction = action.type;
  if (!started && sendOnError === 2 && store.liftedStore) async(checkForReducerErrors);else if (action.action) {
    if (startOn && !started && startOn.indexOf(action.action.type) !== -1) async(start);else if (stopOn && started && stopOn.indexOf(action.action.type) !== -1) async(stop);else if (sendOn && !started && sendOn.indexOf(action.action.type) !== -1) async(send);
  }
  return state;
}

function handleChange(state, liftedState, maxAge) {
  if (checkForReducerErrors(liftedState)) return;

  if (lastAction === 'PERFORM_ACTION') {
    var nextActionId = liftedState.nextActionId;
    var liftedAction = liftedState.actionsById[nextActionId - 1];
    if ((0, _filters.isFiltered)(liftedAction.action, filters)) return;
    relay('ACTION', state, liftedAction, nextActionId);
    if (!isExcess && maxAge) isExcess = liftedState.stagedActionIds.length >= maxAge;
  } else {
    if (lastAction === 'JUMP_TO_STATE') return;
    if (lastAction === 'PAUSE_RECORDING') {
      paused = liftedState.isPaused;
    } else if (lastAction === 'LOCK_CHANGES') {
      locked = liftedState.isLocked;
    }
    if (paused || locked) {
      if (lastAction) lastAction = undefined;else return;
    }
    relay('STATE', (0, _filters.filterStagedActions)(liftedState, filters));
  }
}

function devToolsEnhancer() {
  var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

  init(_extends({}, options, {
    hostname: (0, _rnHostDetect2.default)(options.hostname || 'localhost')
  }));
  var realtime = typeof options.realtime === 'undefined' ? "development" === 'development' : options.realtime;
  if (!realtime && !(startOn || sendOn || sendOnError)) return function (f) {
    return f;
  };

  var maxAge = options.maxAge || 30;
  return function (next) {
    return function (reducer, initialState) {
      store = (0, _configureStore2.default)(next, monitorReducer, {
        maxAge: maxAge,
        trace: options.trace,
        traceLimit: options.traceLimit,
        shouldCatchErrors: !!sendOnError,
        shouldHotReload: options.shouldHotReload,
        shouldRecordChanges: options.shouldRecordChanges,
        shouldStartLocked: options.shouldStartLocked,
        pauseActionType: options.pauseActionType || '@@PAUSED'
      })(reducer, initialState);

      if (realtime) start();
      store.subscribe(function () {
        if (isMonitored) handleChange(store.getState(), store.liftedStore.getState(), maxAge);
      });
      return store;
    };
  };
}

function preEnhancer(createStore) {
  return function (reducer, preloadedState, enhancer) {
    store = createStore(reducer, preloadedState, enhancer);
    return _extends({}, store, {
      dispatch: function dispatch(action) {
        return locked ? action : store.dispatch(action);
      }
    });
  };
}

devToolsEnhancer.updateStore = function (newStore) {
  console.warn('devTools.updateStore is deprecated use composeWithDevTools instead: ' + 'https://github.com/zalmoxisus/remote-redux-devtools#use-devtools-compose-helper');
  store = newStore;
};

var compose = function compose(options) {
  return function () {
    for (var _len = arguments.length, funcs = Array(_len), _key = 0; _key < _len; _key++) {
      funcs[_key] = arguments[_key];
    }

    return function () {
      return [preEnhancer].concat(funcs).reduceRight(function (composed, f) {
        return f(composed);
      }, devToolsEnhancer(options).apply(undefined, arguments));
    };
  };
};

function composeWithDevTools() {
  if (arguments.length === 0) {
    return devToolsEnhancer();
  }
  if (arguments.length === 1 && _typeof(arguments.length <= 0 ? undefined : arguments[0]) === 'object') {
    return compose(arguments.length <= 0 ? undefined : arguments[0]);
  }
  return compose({}).apply(undefined, arguments);
}
      };
    };
  }
  }
}, {package:"remote-redux-devtools",file:"node_modules\\remote-redux-devtools\\lib\\devTools.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\remote-redux-devtools\\lib\\index.js", {"./devTools":"D:\\code\\v\\metamask-extension\\node_modules\\remote-redux-devtools\\lib\\devTools.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cremote-redux-devtools%5Clib%5Cindex.js
      return function (require, module, exports) {
'use strict';

exports.__esModule = true;
exports.composeWithDevTools = exports.default = undefined;

var _devTools = require('./devTools');

Object.defineProperty(exports, 'composeWithDevTools', {
  enumerable: true,
  get: function get() {
    return _devTools.composeWithDevTools;
  }
});

var _devTools2 = _interopRequireDefault(_devTools);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = _devTools2.default;
      };
    };
  }
  }
}, {package:"remote-redux-devtools",file:"node_modules\\remote-redux-devtools\\lib\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\remotedev-serialize\\constants\\options.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cremotedev-serialize%5Cconstants%5Coptions.js
      return function (require, module, exports) {
// jsan stringify options

module.exports = {
  refs: false, // references can't be resolved on the original Immutable structure
  date: true,
  function: true,
  regex: true,
  undefined: true,
  error: true,
  symbol: true,
  map: true,
  set: true,
  nan: true,
  infinity: true,
};

      };
    };
  }
  }
}, {package:"remote-redux-devtools>redux-devtools-core>remotedev-serialize",file:"node_modules\\remotedev-serialize\\constants\\options.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\remotedev-serialize\\helpers\\index.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cremotedev-serialize%5Chelpers%5Cindex.js
      return function (require, module, exports) {
function mark(data, type, transformMethod) {
  return {
    data: transformMethod ? data[transformMethod]() : data,
    __serializedType__: type,
  };
}

function extract(data, type) {
  return {
    data: Object.assign({}, data),
    __serializedType__: type,
  };
}

function refer(data, type, isArray, refs) {
  var r = mark(data, type, isArray);
  if (!refs) return r;
  for (var i = 0; i < refs.length; i++) {
    var ref = refs[i];
    if (typeof ref === 'function' && data instanceof ref) {
      r.__serializedRef__ = i;
      return r;
    }
  }
  return r;
}

module.exports = {
  mark: mark,
  extract: extract,
  refer: refer,
};

      };
    };
  }
  }
}, {package:"remote-redux-devtools>redux-devtools-core>remotedev-serialize",file:"node_modules\\remotedev-serialize\\helpers\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\remotedev-serialize\\immutable\\serialize.js", {"../constants/options":"D:\\code\\v\\metamask-extension\\node_modules\\remotedev-serialize\\constants\\options.js","../helpers":"D:\\code\\v\\metamask-extension\\node_modules\\remotedev-serialize\\helpers\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cremotedev-serialize%5Cimmutable%5Cserialize.js
      return function (require, module, exports) {
var helpers = require('../helpers');
var mark = helpers.mark;
var extract = helpers.extract;
var refer = helpers.refer;
var options = require('../constants/options');

module.exports = function serialize(
  Immutable,
  refs,
  customReplacer,
  customReviver
) {
  function replacer(key, value) {
    if (value instanceof Immutable.Record)
      return refer(value, 'ImmutableRecord', 'toObject', refs);
    if (value instanceof Immutable.Range)
      return extract(value, 'ImmutableRange');
    if (value instanceof Immutable.Repeat)
      return extract(value, 'ImmutableRepeat');
    if (Immutable.OrderedMap.isOrderedMap(value))
      return mark(value, 'ImmutableOrderedMap', 'toObject');
    if (Immutable.Map.isMap(value))
      return mark(value, 'ImmutableMap', 'toObject');
    if (Immutable.List.isList(value))
      return mark(value, 'ImmutableList', 'toArray');
    if (Immutable.OrderedSet.isOrderedSet(value))
      return mark(value, 'ImmutableOrderedSet', 'toArray');
    if (Immutable.Set.isSet(value))
      return mark(value, 'ImmutableSet', 'toArray');
    if (Immutable.Seq.isSeq(value))
      return mark(value, 'ImmutableSeq', 'toArray');
    if (Immutable.Stack.isStack(value))
      return mark(value, 'ImmutableStack', 'toArray');
    return value;
  }

  function reviver(key, value) {
    if (
      typeof value === 'object' &&
      value !== null &&
      '__serializedType__' in value
    ) {
      var data = value.data;
      switch (value.__serializedType__) {
        case 'ImmutableMap':
          return Immutable.Map(data);
        case 'ImmutableOrderedMap':
          return Immutable.OrderedMap(data);
        case 'ImmutableList':
          return Immutable.List(data);
        case 'ImmutableRange':
          return Immutable.Range(data._start, data._end, data._step);
        case 'ImmutableRepeat':
          return Immutable.Repeat(data._value, data.size);
        case 'ImmutableSet':
          return Immutable.Set(data);
        case 'ImmutableOrderedSet':
          return Immutable.OrderedSet(data);
        case 'ImmutableSeq':
          return Immutable.Seq(data);
        case 'ImmutableStack':
          return Immutable.Stack(data);
        case 'ImmutableRecord':
          return refs && refs[value.__serializedRef__]
            ? new refs[value.__serializedRef__](data)
            : Immutable.Map(data);
        default:
          return data;
      }
    }
    return value;
  }

  return {
    replacer: customReplacer
      ? function (key, value) {
          return customReplacer(key, value, replacer);
        }
      : replacer,
    reviver: customReviver
      ? function (key, value) {
          return customReviver(key, value, reviver);
        }
      : reviver,
    options: options,
  };
};

      };
    };
  }
  }
}, {package:"remote-redux-devtools>redux-devtools-core>remotedev-serialize",file:"node_modules\\remotedev-serialize\\immutable\\serialize.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\resolve-pathname\\cjs\\resolve-pathname.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cresolve-pathname%5Ccjs%5Cresolve-pathname.js
      return function (require, module, exports) {
'use strict';

function isAbsolute(pathname) {
  return pathname.charAt(0) === '/';
}

// About 1.5x faster than the two-arg version of Array#splice()
function spliceOne(list, index) {
  for (var i = index, k = i + 1, n = list.length; k < n; i += 1, k += 1) {
    list[i] = list[k];
  }

  list.pop();
}

// This implementation is based heavily on node's url.parse
function resolvePathname(to, from) {
  if (from === undefined) from = '';

  var toParts = (to && to.split('/')) || [];
  var fromParts = (from && from.split('/')) || [];

  var isToAbs = to && isAbsolute(to);
  var isFromAbs = from && isAbsolute(from);
  var mustEndAbs = isToAbs || isFromAbs;

  if (to && isAbsolute(to)) {
    // to is absolute
    fromParts = toParts;
  } else if (toParts.length) {
    // to is relative, drop the filename
    fromParts.pop();
    fromParts = fromParts.concat(toParts);
  }

  if (!fromParts.length) return '/';

  var hasTrailingSlash;
  if (fromParts.length) {
    var last = fromParts[fromParts.length - 1];
    hasTrailingSlash = last === '.' || last === '..' || last === '';
  } else {
    hasTrailingSlash = false;
  }

  var up = 0;
  for (var i = fromParts.length; i >= 0; i--) {
    var part = fromParts[i];

    if (part === '.') {
      spliceOne(fromParts, i);
    } else if (part === '..') {
      spliceOne(fromParts, i);
      up++;
    } else if (up) {
      spliceOne(fromParts, i);
      up--;
    }
  }

  if (!mustEndAbs) for (; up--; up) fromParts.unshift('..');

  if (
    mustEndAbs &&
    fromParts[0] !== '' &&
    (!fromParts[0] || !isAbsolute(fromParts[0]))
  )
    fromParts.unshift('');

  var result = fromParts.join('/');

  if (hasTrailingSlash && result.substr(-1) !== '/') result += '/';

  return result;
}

module.exports = resolvePathname;

      };
    };
  }
  }
}, {package:"react-router-dom>history>resolve-pathname",file:"node_modules\\resolve-pathname\\cjs\\resolve-pathname.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\resolve-pathname\\cjs\\resolve-pathname.min.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cresolve-pathname%5Ccjs%5Cresolve-pathname.min.js
      return function (require, module, exports) {
"use strict";function isAbsolute(e){return"/"===e.charAt(0)}function spliceOne(e,t){for(var s=t,n=s+1,i=e.length;n<i;s+=1,n+=1)e[s]=e[n];e.pop()}function resolvePathname(e,t){void 0===t&&(t="");var s,n=e&&e.split("/")||[],i=t&&t.split("/")||[],l=e&&isAbsolute(e),r=t&&isAbsolute(t),o=l||r;if(e&&isAbsolute(e)?i=n:n.length&&(i.pop(),i=i.concat(n)),!i.length)return"/";if(i.length){var u=i[i.length-1];s="."===u||".."===u||""===u}else s=!1;for(var a=0,c=i.length;0<=c;c--){var f=i[c];"."===f?spliceOne(i,c):".."===f?(spliceOne(i,c),a++):a&&(spliceOne(i,c),a--)}if(!o)for(;a--;a)i.unshift("..");!o||""===i[0]||i[0]&&isAbsolute(i[0])||i.unshift("");var h=i.join("/");return s&&"/"!==h.substr(-1)&&(h+="/"),h}module.exports=resolvePathname;

      };
    };
  }
  }
}, {package:"react-router-dom>history>resolve-pathname",file:"node_modules\\resolve-pathname\\cjs\\resolve-pathname.min.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\resolve-pathname\\index.js", {"./cjs/resolve-pathname.js":"D:\\code\\v\\metamask-extension\\node_modules\\resolve-pathname\\cjs\\resolve-pathname.js","./cjs/resolve-pathname.min.js":"D:\\code\\v\\metamask-extension\\node_modules\\resolve-pathname\\cjs\\resolve-pathname.min.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cresolve-pathname%5Cindex.js
      return function (require, module, exports) {
'use strict';

if ("development" === 'production') {
  module.exports = require('./cjs/resolve-pathname.min.js');
} else {
  module.exports = require('./cjs/resolve-pathname.js');
}

      };
    };
  }
  }
}, {package:"react-router-dom>history>resolve-pathname",file:"node_modules\\resolve-pathname\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rn-host-detect\\index.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crn-host-detect%5Cindex.js
      return function (require, module, exports) {
'use strict'

/*
 * It only for Debug Remotely mode for Android
 * When __DEV__ === false, we can't use window.require('NativeModules')
 */
function getByRemoteConfig(hostname) {
  var remoteModuleConfig = typeof window !== 'undefined' &&
    window.__fbBatchedBridgeConfig &&
    window.__fbBatchedBridgeConfig.remoteModuleConfig

  if (
    !Array.isArray(remoteModuleConfig) ||
    hostname !== 'localhost' && hostname !== '127.0.0.1'
  ) return { hostname: hostname, passed: false }

  var result = hostname
  var passed = false
  remoteModuleConfig.some(function (config) {
    if (!config) return false
    
    var name = config[0]
    var content = config[1]
    if (
      (name === 'AndroidConstants' || name === 'PlatformConstants') &&
      content &&
      content.ServerHost
    ) {
      result = content.ServerHost.split(':')[0]
      passed = true
      return true
    }

    if (
      name === 'SourceCode' &&
      content &&
      content.scriptURL
    ) {
      result = content.scriptURL.replace(/https?:\/\//, '').split(':')[0]
      passed = true
      return true
    }
    return false
  })

  return { hostname: result, passed: passed }
}

function getByRNRequirePolyfill(hostname) {
  var originalWarn = console.warn
  var NativeModules
  var Constants
  var SourceCode
  if (
    typeof window === 'undefined' ||
    !window.__DEV__ ||
    typeof window.require !== 'function' ||
    // RN >= 0.56
    // TODO: Get NativeModules for RN >= 0.56
    window.require.name === 'metroRequire'
  ) {
    return hostname
  }
  console.warn = function() {
    if (
      arguments[0] &&
      typeof arguments[0].indexOf == 'function' &&
      arguments[0].indexOf("Requiring module 'NativeModules' by name") > -1
    )
      return
    return originalWarn.apply(console, arguments)
  }
  try {
    NativeModules = window.require('NativeModules')
  } catch (e) {}
  console.warn = originalWarn
  if (!NativeModules) return hostname

  Constants = NativeModules.PlatformConstants || NativeModules.AndroidConstants
  SourceCode = NativeModules.SourceCode

  if (Constants && Constants.ServerHost) {
    return Constants.ServerHost.split(':')[0]
  } else if (SourceCode && SourceCode.scriptURL) {
    return SourceCode.scriptURL.replace(/https?:\/\//, '').split(':')[0]
  }
  return hostname
}

/*
 * Get React Native server IP if hostname is `localhost`
 * On Android emulator, the IP of host is `10.0.2.2` (Genymotion: 10.0.3.2)
 */
module.exports = function (hostname) {
  // Check if it in React Native environment
  if (
    typeof __fbBatchedBridgeConfig !== 'object' ||
    hostname !== 'localhost' && hostname !== '127.0.0.1'
  ) {
    return hostname
  }
  var result = getByRemoteConfig(hostname)

  // Leave if get hostname by remote config successful
  if (result.passed) {
    return result.hostname
  }

  // Otherwise, use RN's require polyfill
  return getByRNRequirePolyfill(hostname)
}

      };
    };
  }
  }
}, {package:"remote-redux-devtools>rn-host-detect",file:"node_modules\\rn-host-detect\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\sc-channel\\index.js", {"component-emitter":"D:\\code\\v\\metamask-extension\\node_modules\\sc-channel\\node_modules\\component-emitter\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Csc-channel%5Cindex.js
      return function (require, module, exports) {
var Emitter = require('component-emitter');

var SCChannel = function (name, client, options) {
  var self = this;

  Emitter.call(this);

  this.PENDING = 'pending';
  this.SUBSCRIBED = 'subscribed';
  this.UNSUBSCRIBED = 'unsubscribed';

  this.name = name;
  this.state = this.UNSUBSCRIBED;
  this.client = client;

  this.options = options || {};
  this.setOptions(this.options);
};

SCChannel.prototype = Object.create(Emitter.prototype);

SCChannel.prototype.setOptions = function (options) {
  if (!options) {
    options = {};
  }
  this.waitForAuth = options.waitForAuth || false;
  this.batch = options.batch || false;

  if (options.data !== undefined) {
    this.data = options.data;
  }
};

SCChannel.prototype.getState = function () {
  return this.state;
};

SCChannel.prototype.subscribe = function (options) {
  this.client.subscribe(this.name, options);
};

SCChannel.prototype.unsubscribe = function () {
  this.client.unsubscribe(this.name);
};

SCChannel.prototype.isSubscribed = function (includePending) {
  return this.client.isSubscribed(this.name, includePending);
};

SCChannel.prototype.publish = function (data, callback) {
  this.client.publish(this.name, data, callback);
};

SCChannel.prototype.watch = function (handler) {
  this.client.watch(this.name, handler);
};

SCChannel.prototype.unwatch = function (handler) {
  this.client.unwatch(this.name, handler);
};

SCChannel.prototype.watchers = function () {
  return this.client.watchers(this.name);
};

SCChannel.prototype.destroy = function () {
  this.client.destroyChannel(this.name);
};

module.exports.SCChannel = SCChannel;

      };
    };
  }
  }
}, {package:"remote-redux-devtools>socketcluster-client>sc-channel",file:"node_modules\\sc-channel\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\sc-channel\\node_modules\\component-emitter\\index.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Csc-channel%5Cnode_modules%5Ccomponent-emitter%5Cindex.js
      return function (require, module, exports) {

/**
 * Expose `Emitter`.
 */

if (typeof module !== 'undefined') {
  module.exports = Emitter;
}

/**
 * Initialize a new `Emitter`.
 *
 * @api public
 */

function Emitter(obj) {
  if (obj) return mixin(obj);
};

/**
 * Mixin the emitter properties.
 *
 * @param {Object} obj
 * @return {Object}
 * @api private
 */

function mixin(obj) {
  for (var key in Emitter.prototype) {
    obj[key] = Emitter.prototype[key];
  }
  return obj;
}

/**
 * Listen on the given `event` with `fn`.
 *
 * @param {String} event
 * @param {Function} fn
 * @return {Emitter}
 * @api public
 */

Emitter.prototype.on =
Emitter.prototype.addEventListener = function(event, fn){
  this._callbacks = this._callbacks || {};
  (this._callbacks['$' + event] = this._callbacks['$' + event] || [])
    .push(fn);
  return this;
};

/**
 * Adds an `event` listener that will be invoked a single
 * time then automatically removed.
 *
 * @param {String} event
 * @param {Function} fn
 * @return {Emitter}
 * @api public
 */

Emitter.prototype.once = function(event, fn){
  function on() {
    this.off(event, on);
    fn.apply(this, arguments);
  }

  on.fn = fn;
  this.on(event, on);
  return this;
};

/**
 * Remove the given callback for `event` or all
 * registered callbacks.
 *
 * @param {String} event
 * @param {Function} fn
 * @return {Emitter}
 * @api public
 */

Emitter.prototype.off =
Emitter.prototype.removeListener =
Emitter.prototype.removeAllListeners =
Emitter.prototype.removeEventListener = function(event, fn){
  this._callbacks = this._callbacks || {};

  // all
  if (0 == arguments.length) {
    this._callbacks = {};
    return this;
  }

  // specific event
  var callbacks = this._callbacks['$' + event];
  if (!callbacks) return this;

  // remove all handlers
  if (1 == arguments.length) {
    delete this._callbacks['$' + event];
    return this;
  }

  // remove specific handler
  var cb;
  for (var i = 0; i < callbacks.length; i++) {
    cb = callbacks[i];
    if (cb === fn || cb.fn === fn) {
      callbacks.splice(i, 1);
      break;
    }
  }
  return this;
};

/**
 * Emit `event` with the given args.
 *
 * @param {String} event
 * @param {Mixed} ...
 * @return {Emitter}
 */

Emitter.prototype.emit = function(event){
  this._callbacks = this._callbacks || {};
  var args = [].slice.call(arguments, 1)
    , callbacks = this._callbacks['$' + event];

  if (callbacks) {
    callbacks = callbacks.slice(0);
    for (var i = 0, len = callbacks.length; i < len; ++i) {
      callbacks[i].apply(this, args);
    }
  }

  return this;
};

/**
 * Return array of callbacks for `event`.
 *
 * @param {String} event
 * @return {Array}
 * @api public
 */

Emitter.prototype.listeners = function(event){
  this._callbacks = this._callbacks || {};
  return this._callbacks['$' + event] || [];
};

/**
 * Check if this emitter has `event` handlers.
 *
 * @param {String} event
 * @return {Boolean}
 * @api public
 */

Emitter.prototype.hasListeners = function(event){
  return !! this.listeners(event).length;
};

      };
    };
  }
  }
}, {package:"remote-redux-devtools>socketcluster-client>sc-channel>component-emitter",file:"node_modules\\sc-channel\\node_modules\\component-emitter\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\sc-errors\\decycle.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Csc-errors%5Cdecycle.js
      return function (require, module, exports) {
// Based on https://github.com/dscape/cycle/blob/master/cycle.js

module.exports = function decycle(object) {
// Make a deep copy of an object or array, assuring that there is at most
// one instance of each object or array in the resulting structure. The
// duplicate references (which might be forming cycles) are replaced with
// an object of the form
//      {$ref: PATH}
// where the PATH is a JSONPath string that locates the first occurance.
// So,
//      var a = [];
//      a[0] = a;
//      return JSON.stringify(JSON.decycle(a));
// produces the string '[{"$ref":"$"}]'.

// JSONPath is used to locate the unique object. $ indicates the top level of
// the object or array. [NUMBER] or [STRING] indicates a child member or
// property.

    var objects = [],   // Keep a reference to each unique object or array
        paths = [];     // Keep the path to each unique object or array

    return (function derez(value, path) {

// The derez recurses through the object, producing the deep copy.

        var i,          // The loop counter
            name,       // Property name
            nu;         // The new object or array

// typeof null === 'object', so go on if this value is really an object but not
// one of the weird builtin objects.

        if (typeof value === 'object' && value !== null &&
                !(value instanceof Boolean) &&
                !(value instanceof Date)    &&
                !(value instanceof Number)  &&
                !(value instanceof RegExp)  &&
                !(value instanceof String)) {

// If the value is an object or array, look to see if we have already
// encountered it. If so, return a $ref/path object. This is a hard way,
// linear search that will get slower as the number of unique objects grows.

            for (i = 0; i < objects.length; i += 1) {
                if (objects[i] === value) {
                    return {$ref: paths[i]};
                }
            }

// Otherwise, accumulate the unique value and its path.

            objects.push(value);
            paths.push(path);

// If it is an array, replicate the array.

            if (Object.prototype.toString.apply(value) === '[object Array]') {
                nu = [];
                for (i = 0; i < value.length; i += 1) {
                    nu[i] = derez(value[i], path + '[' + i + ']');
                }
            } else {

// If it is an object, replicate the object.

                nu = {};
                for (name in value) {
                    if (Object.prototype.hasOwnProperty.call(value, name)) {
                        nu[name] = derez(value[name],
                            path + '[' + JSON.stringify(name) + ']');
                    }
                }
            }
            return nu;
        }
        return value;
    }(object, '$'));
};

      };
    };
  }
  }
}, {package:"remote-redux-devtools>socketcluster-client>sc-errors",file:"node_modules\\sc-errors\\decycle.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\sc-errors\\index.js", {"./decycle":"D:\\code\\v\\metamask-extension\\node_modules\\sc-errors\\decycle.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Csc-errors%5Cindex.js
      return function (require, module, exports) {
var decycle = require('./decycle');

var isStrict = (function () { return !this; })();

function AuthTokenExpiredError(message, expiry) {
  this.name = 'AuthTokenExpiredError';
  this.message = message;
  this.expiry = expiry;
  if (Error.captureStackTrace && !isStrict) {
    Error.captureStackTrace(this, arguments.callee);
  } else {
    this.stack = (new Error()).stack;
  }
}
AuthTokenExpiredError.prototype = Object.create(Error.prototype);


function AuthTokenInvalidError(message) {
  this.name = 'AuthTokenInvalidError';
  this.message = message;
  if (Error.captureStackTrace && !isStrict) {
    Error.captureStackTrace(this, arguments.callee);
  } else {
    this.stack = (new Error()).stack;
  }
}
AuthTokenInvalidError.prototype = Object.create(Error.prototype);


function AuthTokenNotBeforeError(message, date) {
  this.name = 'AuthTokenNotBeforeError';
  this.message = message;
  this.date = date;
  if (Error.captureStackTrace && !isStrict) {
    Error.captureStackTrace(this, arguments.callee);
  } else {
    this.stack = (new Error()).stack;
  }
}
AuthTokenNotBeforeError.prototype = Object.create(Error.prototype);


// For any other auth token error.
function AuthTokenError(message) {
  this.name = 'AuthTokenError';
  this.message = message;
  if (Error.captureStackTrace && !isStrict) {
    Error.captureStackTrace(this, arguments.callee);
  } else {
    this.stack = (new Error()).stack;
  }
}
AuthTokenError.prototype = Object.create(Error.prototype);

// For any other auth error; not specifically related to the auth token itself.
function AuthError(message) {
  this.name = 'AuthError';
  this.message = message;
  if (Error.captureStackTrace && !isStrict) {
    Error.captureStackTrace(this, arguments.callee);
  } else {
    this.stack = (new Error()).stack;
  }
}
AuthError.prototype = Object.create(Error.prototype);


function SilentMiddlewareBlockedError(message, type) {
  this.name = 'SilentMiddlewareBlockedError';
  this.message = message;
  this.type = type;
  if (Error.captureStackTrace && !isStrict) {
    Error.captureStackTrace(this, arguments.callee);
  } else {
    this.stack = (new Error()).stack;
  }
}
SilentMiddlewareBlockedError.prototype = Object.create(Error.prototype);


function InvalidActionError(message) {
  this.name = 'InvalidActionError';
  this.message = message;
  if (Error.captureStackTrace && !isStrict) {
    Error.captureStackTrace(this, arguments.callee);
  } else {
    this.stack = (new Error()).stack;
  }
}
InvalidActionError.prototype = Object.create(Error.prototype);

function InvalidArgumentsError(message) {
  this.name = 'InvalidArgumentsError';
  this.message = message;
  if (Error.captureStackTrace && !isStrict) {
    Error.captureStackTrace(this, arguments.callee);
  } else {
    this.stack = (new Error()).stack;
  }
}
InvalidArgumentsError.prototype = Object.create(Error.prototype);

function InvalidOptionsError(message) {
  this.name = 'InvalidOptionsError';
  this.message = message;
  if (Error.captureStackTrace && !isStrict) {
    Error.captureStackTrace(this, arguments.callee);
  } else {
    this.stack = (new Error()).stack;
  }
}
InvalidOptionsError.prototype = Object.create(Error.prototype);


function InvalidMessageError(message) {
  this.name = 'InvalidMessageError';
  this.message = message;
  if (Error.captureStackTrace && !isStrict) {
    Error.captureStackTrace(this, arguments.callee);
  } else {
    this.stack = (new Error()).stack;
  }
}
InvalidMessageError.prototype = Object.create(Error.prototype);


function SocketProtocolError(message, code) {
  this.name = 'SocketProtocolError';
  this.message = message;
  this.code = code;
  if (Error.captureStackTrace && !isStrict) {
    Error.captureStackTrace(this, arguments.callee);
  } else {
    this.stack = (new Error()).stack;
  }
}
SocketProtocolError.prototype = Object.create(Error.prototype);


function ServerProtocolError(message) {
  this.name = 'ServerProtocolError';
  this.message = message;
  if (Error.captureStackTrace && !isStrict) {
    Error.captureStackTrace(this, arguments.callee);
  } else {
    this.stack = (new Error()).stack;
  }
}
ServerProtocolError.prototype = Object.create(Error.prototype);

function HTTPServerError(message) {
  this.name = 'HTTPServerError';
  this.message = message;
  if (Error.captureStackTrace && !isStrict) {
    Error.captureStackTrace(this, arguments.callee);
  } else {
    this.stack = (new Error()).stack;
  }
}
HTTPServerError.prototype = Object.create(Error.prototype);


function ResourceLimitError(message) {
  this.name = 'ResourceLimitError';
  this.message = message;
  if (Error.captureStackTrace && !isStrict) {
    Error.captureStackTrace(this, arguments.callee);
  } else {
    this.stack = (new Error()).stack;
  }
}
ResourceLimitError.prototype = Object.create(Error.prototype);


function TimeoutError(message) {
  this.name = 'TimeoutError';
  this.message = message;
  if (Error.captureStackTrace && !isStrict) {
    Error.captureStackTrace(this, arguments.callee);
  } else {
    this.stack = (new Error()).stack;
  }
}
TimeoutError.prototype = Object.create(Error.prototype);


function BadConnectionError(message, type) {
  this.name = 'BadConnectionError';
  this.message = message;
  this.type = type;
  if (Error.captureStackTrace && !isStrict) {
    Error.captureStackTrace(this, arguments.callee);
  } else {
    this.stack = (new Error()).stack;
  }
}
BadConnectionError.prototype = Object.create(Error.prototype);


function BrokerError(message) {
  this.name = 'BrokerError';
  this.message = message;
  if (Error.captureStackTrace && !isStrict) {
    Error.captureStackTrace(this, arguments.callee);
  } else {
    this.stack = (new Error()).stack;
  }
}
BrokerError.prototype = Object.create(Error.prototype);


function ProcessExitError(message, code) {
  this.name = 'ProcessExitError';
  this.message = message;
  this.code = code;
  if (Error.captureStackTrace && !isStrict) {
    Error.captureStackTrace(this, arguments.callee);
  } else {
    this.stack = (new Error()).stack;
  }
}
ProcessExitError.prototype = Object.create(Error.prototype);


function UnknownError(message) {
  this.name = 'UnknownError';
  this.message = message;
  if (Error.captureStackTrace && !isStrict) {
    Error.captureStackTrace(this, arguments.callee);
  } else {
    this.stack = (new Error()).stack;
  }
}
UnknownError.prototype = Object.create(Error.prototype);


// Expose all error types.

module.exports = {
  AuthTokenExpiredError: AuthTokenExpiredError,
  AuthTokenInvalidError: AuthTokenInvalidError,
  AuthTokenNotBeforeError: AuthTokenNotBeforeError,
  AuthTokenError: AuthTokenError,
  AuthError: AuthError,
  SilentMiddlewareBlockedError: SilentMiddlewareBlockedError,
  InvalidActionError: InvalidActionError,
  InvalidArgumentsError: InvalidArgumentsError,
  InvalidOptionsError: InvalidOptionsError,
  InvalidMessageError: InvalidMessageError,
  SocketProtocolError: SocketProtocolError,
  ServerProtocolError: ServerProtocolError,
  HTTPServerError: HTTPServerError,
  ResourceLimitError: ResourceLimitError,
  TimeoutError: TimeoutError,
  BadConnectionError: BadConnectionError,
  BrokerError: BrokerError,
  ProcessExitError: ProcessExitError,
  UnknownError: UnknownError
};

module.exports.socketProtocolErrorStatuses = {
  1001: 'Socket was disconnected',
  1002: 'A WebSocket protocol error was encountered',
  1003: 'Server terminated socket because it received invalid data',
  1005: 'Socket closed without status code',
  1006: 'Socket hung up',
  1007: 'Message format was incorrect',
  1008: 'Encountered a policy violation',
  1009: 'Message was too big to process',
  1010: 'Client ended the connection because the server did not comply with extension requirements',
  1011: 'Server encountered an unexpected fatal condition',
  4000: 'Server ping timed out',
  4001: 'Client pong timed out',
  4002: 'Server failed to sign auth token',
  4003: 'Failed to complete handshake',
  4004: 'Client failed to save auth token',
  4005: 'Did not receive #handshake from client before timeout',
  4006: 'Failed to bind socket to message broker',
  4007: 'Client connection establishment timed out',
  4008: 'Server rejected handshake from client',
  4009: 'Server received a message before the client handshake'
};

module.exports.socketProtocolIgnoreStatuses = {
  1000: 'Socket closed normally',
  1001: 'Socket hung up'
};

// Properties related to error domains cannot be serialized.
var unserializableErrorProperties = {
  domain: 1,
  domainEmitter: 1,
  domainThrown: 1
};

// Convert an error into a JSON-compatible type which can later be hydrated
// back to its *original* form.
module.exports.dehydrateError = function dehydrateError(error, includeStackTrace) {
  var dehydratedError;

  if (error && typeof error === 'object') {
    dehydratedError = {
      message: error.message
    };
    if (includeStackTrace) {
      dehydratedError.stack = error.stack;
    }
    for (var i in error) {
      if (!unserializableErrorProperties[i]) {
        dehydratedError[i] = error[i];
      }
    }
  } else if (typeof error === 'function') {
    dehydratedError = '[function ' + (error.name || 'anonymous') + ']';
  } else {
    dehydratedError = error;
  }

  return decycle(dehydratedError);
};

// Convert a dehydrated error back to its *original* form.
module.exports.hydrateError = function hydrateError(error) {
  var hydratedError = null;
  if (error != null) {
    if (typeof error === 'object') {
      hydratedError = new Error(error.message);
      for (var i in error) {
        if (error.hasOwnProperty(i)) {
          hydratedError[i] = error[i];
        }
      }
    } else {
      hydratedError = error;
    }
  }
  return hydratedError;
};

module.exports.decycle = decycle;

      };
    };
  }
  }
}, {package:"remote-redux-devtools>socketcluster-client>sc-errors",file:"node_modules\\sc-errors\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\sc-formatter\\index.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Csc-formatter%5Cindex.js
      return function (require, module, exports) {
const base64Chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
const validJSONStartRegex = /^[ \n\r\t]*[{\[]/;

let arrayBufferToBase64 = function (arraybuffer) {
  let bytes = new Uint8Array(arraybuffer);
  let len = bytes.length;
  let base64 = '';

  for (let i = 0; i < len; i += 3) {
    base64 += base64Chars[bytes[i] >> 2];
    base64 += base64Chars[((bytes[i] & 3) << 4) | (bytes[i + 1] >> 4)];
    base64 += base64Chars[((bytes[i + 1] & 15) << 2) | (bytes[i + 2] >> 6)];
    base64 += base64Chars[bytes[i + 2] & 63];
  }

  if ((len % 3) === 2) {
    base64 = base64.substring(0, base64.length - 1) + '=';
  } else if (len % 3 === 1) {
    base64 = base64.substring(0, base64.length - 2) + '==';
  }

  return base64;
};

let binaryToBase64Replacer = function (key, value) {
  if (global.ArrayBuffer && value instanceof global.ArrayBuffer) {
    return {
      base64: true,
      data: arrayBufferToBase64(value)
    };
  } else if (global.Buffer) {
    if (value instanceof global.Buffer){
      return {
        base64: true,
        data: value.toString('base64')
      };
    }
    // Some versions of Node.js convert Buffers to Objects before they are passed to
    // the replacer function - Because of this, we need to rehydrate Buffers
    // before we can convert them to base64 strings.
    if (value && value.type === 'Buffer' && Array.isArray(value.data)) {
      let rehydratedBuffer;
      if (global.Buffer.from) {
        rehydratedBuffer = global.Buffer.from(value.data);
      } else {
        rehydratedBuffer = new global.Buffer(value.data);
      }
      return {
        base64: true,
        data: rehydratedBuffer.toString('base64')
      };
    }
  }
  return value;
};

// Decode the data which was transmitted over the wire to a JavaScript Object in a format which SC understands.
// See encode function below for more details.
module.exports.decode = function (encodedMessage) {
  if (encodedMessage == null) {
   return null;
  }
  // Leave ping or pong message as is
  if (encodedMessage === '#1' || encodedMessage === '#2') {
    return encodedMessage;
  }
  let message = encodedMessage.toString();

  // Performance optimization to detect invalid JSON packet sooner.
  if (!validJSONStartRegex.test(message)) {
    return message;
  }

  try {
    return JSON.parse(message);
  } catch (err) {}
  return message;
};

// Encode raw data (which is in the SC protocol format) into a format for
// transfering it over the wire. In this case, we just convert it into a simple JSON string.
// If you want to create your own custom codec, you can encode the object into any format
// (e.g. binary ArrayBuffer or string with any kind of compression) so long as your decode
// function is able to rehydrate that object back into its original JavaScript Object format
// (which adheres to the SC protocol).
// See https://github.com/SocketCluster/socketcluster/blob/master/socketcluster-protocol.md
// for details about the SC protocol.
module.exports.encode = function (rawData) {
  // Leave ping or pong message as is
  if (rawData === '#1' || rawData === '#2') {
    return rawData;
  }
  return JSON.stringify(rawData, binaryToBase64Replacer);
};

      };
    };
  }
  }
}, {package:"remote-redux-devtools>socketcluster-client>sc-formatter",file:"node_modules\\sc-formatter\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\set-function-name\\index.js", {"define-data-property":"D:\\code\\v\\metamask-extension\\node_modules\\define-data-property\\index.js","es-errors/type":"D:\\code\\v\\metamask-extension\\node_modules\\es-errors\\type.js","functions-have-names":"D:\\code\\v\\metamask-extension\\node_modules\\functions-have-names\\index.js","has-property-descriptors":"D:\\code\\v\\metamask-extension\\node_modules\\has-property-descriptors\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cset-function-name%5Cindex.js
      return function (require, module, exports) {
'use strict';

var define = require('define-data-property');
var hasDescriptors = require('has-property-descriptors')();
var functionsHaveConfigurableNames = require('functions-have-names').functionsHaveConfigurableNames();

var $TypeError = require('es-errors/type');

/** @type {__import__('.')} */
module.exports = function setFunctionName(fn, name) {
	if (typeof fn !== 'function') {
		throw new $TypeError('`fn` is not a function');
	}
	var loose = arguments.length > 2 && !!arguments[2];
	if (!loose || functionsHaveConfigurableNames) {
		if (hasDescriptors) {
			define(/** @type {Parameters<define>[0]} */ (fn), 'name', name, true, true);
		} else {
			define(/** @type {Parameters<define>[0]} */ (fn), 'name', name);
		}
	}
	return fn;
};

      };
    };
  }
  }
}, {package:"string.prototype.matchall>regexp.prototype.flags>set-function-name",file:"node_modules\\set-function-name\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\socketcluster-client\\index.js", {"./lib/factory":"D:\\code\\v\\metamask-extension\\node_modules\\socketcluster-client\\lib\\factory.js","./lib/scclientsocket":"D:\\code\\v\\metamask-extension\\node_modules\\socketcluster-client\\lib\\scclientsocket.js","component-emitter":"D:\\code\\v\\metamask-extension\\node_modules\\socketcluster-client\\node_modules\\component-emitter\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Csocketcluster-client%5Cindex.js
      return function (require, module, exports) {
var SCClientSocket = require('./lib/scclientsocket');
var factory = require('./lib/factory');

module.exports.factory = factory;
module.exports.SCClientSocket = SCClientSocket;

module.exports.Emitter = require('component-emitter');

module.exports.create = function (options) {
  return factory.create(options);
};

module.exports.connect = module.exports.create;

module.exports.destroy = function (socket) {
  return factory.destroy(socket);
};

module.exports.clients = factory.clients;

module.exports.version = '14.3.1';

      };
    };
  }
  }
}, {package:"remote-redux-devtools>socketcluster-client",file:"node_modules\\socketcluster-client\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\socketcluster-client\\lib\\auth.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Csocketcluster-client%5Clib%5Cauth.js
      return function (require, module, exports) {
var AuthEngine = function () {
  this._internalStorage = {};
  this.isLocalStorageEnabled = this._checkLocalStorageEnabled();
};

AuthEngine.prototype._checkLocalStorageEnabled = function () {
  var err;
  try {
    // Some browsers will throw an error here if localStorage is disabled.
    global.localStorage;

    // Safari, in Private Browsing Mode, looks like it supports localStorage but all calls to setItem
    // throw QuotaExceededError. We're going to detect this and avoid hard to debug edge cases.
    global.localStorage.setItem('__scLocalStorageTest', 1);
    global.localStorage.removeItem('__scLocalStorageTest');
  } catch (e) {
    err = e;
  }
  return !err;
};

AuthEngine.prototype.saveToken = function (name, token, options, callback) {
  if (this.isLocalStorageEnabled && global.localStorage) {
    global.localStorage.setItem(name, token);
  } else {
    this._internalStorage[name] = token;
  }
  callback && callback(null, token);
};

AuthEngine.prototype.removeToken = function (name, callback) {
  var token;

  this.loadToken(name, function (err, authToken) {
    token = authToken;
  });

  if (this.isLocalStorageEnabled && global.localStorage) {
    global.localStorage.removeItem(name);
  } else {
    delete this._internalStorage[name];
  }

  callback && callback(null, token);
};

AuthEngine.prototype.loadToken = function (name, callback) {
  var token;

  if (this.isLocalStorageEnabled && global.localStorage) {
    token = global.localStorage.getItem(name);
  } else {
    token = this._internalStorage[name] || null;
  }
  callback(null, token);
};

module.exports.AuthEngine = AuthEngine;

      };
    };
  }
  }
}, {package:"remote-redux-devtools>socketcluster-client",file:"node_modules\\socketcluster-client\\lib\\auth.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\socketcluster-client\\lib\\factory.js", {"./scclientsocket":"D:\\code\\v\\metamask-extension\\node_modules\\socketcluster-client\\lib\\scclientsocket.js","sc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\sc-errors\\index.js","uuid":"D:\\code\\v\\metamask-extension\\node_modules\\socketcluster-client\\node_modules\\uuid\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Csocketcluster-client%5Clib%5Cfactory.js
      return function (require, module, exports) {
var SCClientSocket = require('./scclientsocket');
var scErrors = require('sc-errors');
var uuid = require('uuid');
var InvalidArgumentsError = scErrors.InvalidArgumentsError;

var _clients = {};

function getMultiplexId(options) {
  var protocolPrefix = options.secure ? 'https://' : 'http://';
  var queryString = '';
  if (options.query) {
    if (typeof options.query === 'string') {
      queryString = options.query;
    } else {
      var queryArray = [];
      var queryMap = options.query;
      for (var key in queryMap) {
        if (queryMap.hasOwnProperty(key)) {
          queryArray.push(key + '=' + queryMap[key]);
        }
      }
      if (queryArray.length) {
        queryString = '?' + queryArray.join('&');
      }
    }
  }
  var host;
  if (options.host) {
    host = options.host;
  } else {
    host = options.hostname + ':' + options.port;
  }
  return protocolPrefix + host + options.path + queryString;
}

function isUrlSecure() {
  return global.location && location.protocol === 'https:';
}

function getPort(options, isSecureDefault) {
  var isSecure = options.secure == null ? isSecureDefault : options.secure;
  return options.port || (global.location && location.port ? location.port : isSecure ? 443 : 80);
}

function create(options) {
  var self = this;

  options = options || {};

  if (options.host && !options.host.match(/[^:]+:\d{2,5}/)) {
    throw new InvalidArgumentsError('The host option should include both' +
      ' the hostname and the port number in the format "hostname:port"');
  }

  if (options.host && options.hostname) {
    throw new InvalidArgumentsError('The host option should already include' +
      ' the hostname and the port number in the format "hostname:port"' +
      ' - Because of this, you should never use host and hostname options together');
  }

  if (options.host && options.port) {
    throw new InvalidArgumentsError('The host option should already include' +
      ' the hostname and the port number in the format "hostname:port"' +
      ' - Because of this, you should never use host and port options together');
  }

  var isSecureDefault = isUrlSecure();

  var opts = {
    port: getPort(options, isSecureDefault),
    hostname: global.location && location.hostname || 'localhost',
    path: '/socketcluster/',
    secure: isSecureDefault,
    autoConnect: true,
    autoReconnect: true,
    autoSubscribeOnConnect: true,
    connectTimeout: 20000,
    ackTimeout: 10000,
    timestampRequests: false,
    timestampParam: 't',
    authEngine: null,
    authTokenName: 'socketCluster.authToken',
    binaryType: 'arraybuffer',
    multiplex: true,
    pubSubBatchDuration: null,
    cloneData: false
  };
  for (var i in options) {
    if (options.hasOwnProperty(i)) {
      opts[i] = options[i];
    }
  }
  opts.clientMap = _clients;

  if (opts.multiplex === false) {
    opts.clientId = uuid.v4();
    var socket = new SCClientSocket(opts);
    _clients[opts.clientId] = socket;
    return socket;
  }
  opts.clientId = getMultiplexId(opts);

  if (_clients[opts.clientId]) {
    if (opts.autoConnect) {
      _clients[opts.clientId].connect();
    }
  } else {
    _clients[opts.clientId] = new SCClientSocket(opts);
  }
  return _clients[opts.clientId];
}

function destroy(socket) {
  socket.destroy();
}

module.exports = {
  create: create,
  destroy: destroy,
  clients: _clients
};

      };
    };
  }
  }
}, {package:"remote-redux-devtools>socketcluster-client",file:"node_modules\\socketcluster-client\\lib\\factory.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\socketcluster-client\\lib\\response.js", {"sc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\sc-errors\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Csocketcluster-client%5Clib%5Cresponse.js
      return function (require, module, exports) {
var scErrors = require('sc-errors');
var InvalidActionError = scErrors.InvalidActionError;

var Response = function (socket, id) {
  this.socket = socket;
  this.id = id;
  this.sent = false;
};

Response.prototype._respond = function (responseData) {
  if (this.sent) {
    throw new InvalidActionError('Response ' + this.id + ' has already been sent');
  } else {
    this.sent = true;
    this.socket.send(this.socket.encode(responseData));
  }
};

Response.prototype.end = function (data) {
  if (this.id) {
    var responseData = {
      rid: this.id
    };
    if (data !== undefined) {
      responseData.data = data;
    }
    this._respond(responseData);
  }
};

Response.prototype.error = function (error, data) {
  if (this.id) {
    var err = scErrors.dehydrateError(error);

    var responseData = {
      rid: this.id,
      error: err
    };
    if (data !== undefined) {
      responseData.data = data;
    }

    this._respond(responseData);
  }
};

Response.prototype.callback = function (error, data) {
  if (error) {
    this.error(error, data);
  } else {
    this.end(data);
  }
};

module.exports.Response = Response;

      };
    };
  }
  }
}, {package:"remote-redux-devtools>socketcluster-client",file:"node_modules\\socketcluster-client\\lib\\response.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\socketcluster-client\\lib\\scclientsocket.js", {"./auth":"D:\\code\\v\\metamask-extension\\node_modules\\socketcluster-client\\lib\\auth.js","./response":"D:\\code\\v\\metamask-extension\\node_modules\\socketcluster-client\\lib\\response.js","./sctransport":"D:\\code\\v\\metamask-extension\\node_modules\\socketcluster-client\\lib\\sctransport.js","buffer/":"D:\\code\\v\\metamask-extension\\node_modules\\socketcluster-client\\node_modules\\buffer\\index.js","clone":"D:\\code\\v\\metamask-extension\\node_modules\\socketcluster-client\\node_modules\\clone\\clone.js","component-emitter":"D:\\code\\v\\metamask-extension\\node_modules\\socketcluster-client\\node_modules\\component-emitter\\index.js","linked-list":"D:\\code\\v\\metamask-extension\\node_modules\\linked-list\\index.js","querystring":"D:\\code\\v\\metamask-extension\\node_modules\\querystring-es3\\index.js","sc-channel":"D:\\code\\v\\metamask-extension\\node_modules\\sc-channel\\index.js","sc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\sc-errors\\index.js","sc-formatter":"D:\\code\\v\\metamask-extension\\node_modules\\sc-formatter\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Csocketcluster-client%5Clib%5Cscclientsocket.js
      return function (require, module, exports) {
var Emitter = require('component-emitter');
var SCChannel = require('sc-channel').SCChannel;
var Response = require('./response').Response;
var AuthEngine = require('./auth').AuthEngine;
var formatter = require('sc-formatter');
var SCTransport = require('./sctransport').SCTransport;
var querystring = require('querystring');
var LinkedList = require('linked-list');
var Buffer = require('buffer/').Buffer;
var clone = require('clone');

var scErrors = require('sc-errors');
var InvalidArgumentsError = scErrors.InvalidArgumentsError;
var InvalidMessageError = scErrors.InvalidMessageError;
var InvalidActionError = scErrors.InvalidActionError;
var SocketProtocolError = scErrors.SocketProtocolError;
var TimeoutError = scErrors.TimeoutError;
var BadConnectionError = scErrors.BadConnectionError;

var isBrowser = typeof window !== 'undefined';


var SCClientSocket = function (opts) {
  var self = this;

  Emitter.call(this);

  this.id = null;
  this.state = this.CLOSED;
  this.authState = this.UNAUTHENTICATED;
  this.signedAuthToken = null;
  this.authToken = null;
  this.pendingReconnect = false;
  this.pendingReconnectTimeout = null;
  this.preparingPendingSubscriptions = false;
  this.clientId = opts.clientId;

  this.connectTimeout = opts.connectTimeout;
  this.ackTimeout = opts.ackTimeout;
  this.channelPrefix = opts.channelPrefix || null;
  this.disconnectOnUnload = opts.disconnectOnUnload == null ? true : opts.disconnectOnUnload;
  this.authTokenName = opts.authTokenName;

  // pingTimeout will be ackTimeout at the start, but it will
  // be updated with values provided by the 'connect' event
  this.pingTimeout = this.ackTimeout;
  this.pingTimeoutDisabled = !!opts.pingTimeoutDisabled;
  this.active = true;

  this._clientMap = opts.clientMap || {};

  var maxTimeout = Math.pow(2, 31) - 1;

  var verifyDuration = function (propertyName) {
    if (self[propertyName] > maxTimeout) {
      throw new InvalidArgumentsError('The ' + propertyName +
        ' value provided exceeded the maximum amount allowed');
    }
  };

  verifyDuration('connectTimeout');
  verifyDuration('ackTimeout');

  this._localEvents = {
    'connect': 1,
    'connectAbort': 1,
    'close': 1,
    'disconnect': 1,
    'message': 1,
    'error': 1,
    'raw': 1,
    'kickOut': 1,
    'subscribe': 1,
    'unsubscribe': 1,
    'subscribeStateChange': 1,
    'authStateChange': 1,
    'authenticate': 1,
    'deauthenticate': 1,
    'removeAuthToken': 1,
    'subscribeRequest': 1
  };

  this.connectAttempts = 0;

  this._emitBuffer = new LinkedList();
  this.channels = {};

  this.options = opts;

  this._cid = 1;

  this.options.callIdGenerator = function () {
    return self._cid++;
  };

  if (this.options.autoReconnect) {
    if (this.options.autoReconnectOptions == null) {
      this.options.autoReconnectOptions = {};
    }

    // Add properties to the this.options.autoReconnectOptions object.
    // We assign the reference to a reconnectOptions variable to avoid repetition.
    var reconnectOptions = this.options.autoReconnectOptions;
    if (reconnectOptions.initialDelay == null) {
      reconnectOptions.initialDelay = 10000;
    }
    if (reconnectOptions.randomness == null) {
      reconnectOptions.randomness = 10000;
    }
    if (reconnectOptions.multiplier == null) {
      reconnectOptions.multiplier = 1.5;
    }
    if (reconnectOptions.maxDelay == null) {
      reconnectOptions.maxDelay = 60000;
    }
  }

  if (this.options.subscriptionRetryOptions == null) {
    this.options.subscriptionRetryOptions = {};
  }

  if (this.options.authEngine) {
    this.auth = this.options.authEngine;
  } else {
    this.auth = new AuthEngine();
  }

  if (this.options.codecEngine) {
    this.codec = this.options.codecEngine;
  } else {
    // Default codec engine
    this.codec = formatter;
  }

  if (this.options.protocol) {
    var protocolOptionError = new InvalidArgumentsError('The "protocol" option' +
      ' does not affect socketcluster-client. If you want to utilize SSL/TLS' +
      ' - use "secure" option instead');
    this._onSCError(protocolOptionError);
  }

  this.options.path = this.options.path.replace(/\/$/, '') + '/';

  this.options.query = opts.query || {};
  if (typeof this.options.query === 'string') {
    this.options.query = querystring.parse(this.options.query);
  }

  this._channelEmitter = new Emitter();

  this._unloadHandler = function () {
    self.disconnect();
  };

  if (isBrowser && this.disconnectOnUnload && global.addEventListener) {
    global.addEventListener('beforeunload', this._unloadHandler, false);
  }
  this._clientMap[this.clientId] = this;

  if (this.options.autoConnect) {
    this.connect();
  }
};

SCClientSocket.prototype = Object.create(Emitter.prototype);

SCClientSocket.CONNECTING = SCClientSocket.prototype.CONNECTING = SCTransport.prototype.CONNECTING;
SCClientSocket.OPEN = SCClientSocket.prototype.OPEN = SCTransport.prototype.OPEN;
SCClientSocket.CLOSED = SCClientSocket.prototype.CLOSED = SCTransport.prototype.CLOSED;

SCClientSocket.AUTHENTICATED = SCClientSocket.prototype.AUTHENTICATED = 'authenticated';
SCClientSocket.UNAUTHENTICATED = SCClientSocket.prototype.UNAUTHENTICATED = 'unauthenticated';

SCClientSocket.PENDING = SCClientSocket.prototype.PENDING = 'pending';

SCClientSocket.ignoreStatuses = scErrors.socketProtocolIgnoreStatuses;
SCClientSocket.errorStatuses = scErrors.socketProtocolErrorStatuses;

SCClientSocket.prototype._privateEventHandlerMap = {
  '#publish': function (data) {
    var undecoratedChannelName = this._undecorateChannelName(data.channel);
    var isSubscribed = this.isSubscribed(undecoratedChannelName, true);

    if (isSubscribed) {
      this._channelEmitter.emit(undecoratedChannelName, data.data);
    }
  },
  '#kickOut': function (data) {
    var undecoratedChannelName = this._undecorateChannelName(data.channel);
    var channel = this.channels[undecoratedChannelName];
    if (channel) {
      Emitter.prototype.emit.call(this, 'kickOut', data.message, undecoratedChannelName);
      channel.emit('kickOut', data.message, undecoratedChannelName);
      this._triggerChannelUnsubscribe(channel);
    }
  },
  '#setAuthToken': function (data, response) {
    var self = this;

    if (data) {
      var triggerAuthenticate = function (err) {
        if (err) {
          // This is a non-fatal error, we don't want to close the connection
          // because of this but we do want to notify the server and throw an error
          // on the client.
          response.error(err);
          self._onSCError(err);
        } else {
          self._changeToAuthenticatedState(data.token);
          response.end();
        }
      };

      this.auth.saveToken(this.authTokenName, data.token, {}, triggerAuthenticate);
    } else {
      response.error(new InvalidMessageError('No token data provided by #setAuthToken event'));
    }
  },
  '#removeAuthToken': function (data, response) {
    var self = this;

    this.auth.removeToken(this.authTokenName, function (err, oldToken) {
      if (err) {
        // Non-fatal error - Do not close the connection
        response.error(err);
        self._onSCError(err);
      } else {
        Emitter.prototype.emit.call(self, 'removeAuthToken', oldToken);
        self._changeToUnauthenticatedStateAndClearTokens();
        response.end();
      }
    });
  },
  '#disconnect': function (data) {
    this.transport.close(data.code, data.data);
  }
};

SCClientSocket.prototype.getState = function () {
  return this.state;
};

SCClientSocket.prototype.getBytesReceived = function () {
  return this.transport.getBytesReceived();
};

SCClientSocket.prototype.deauthenticate = function (callback) {
  var self = this;

  this.auth.removeToken(this.authTokenName, function (err, oldToken) {
    if (err) {
      // Non-fatal error - Do not close the connection
      self._onSCError(err);
    } else {
      Emitter.prototype.emit.call(self, 'removeAuthToken', oldToken);
      if (self.state !== self.CLOSED) {
        self.emit('#removeAuthToken');
      }
      self._changeToUnauthenticatedStateAndClearTokens();
    }
    callback && callback(err);
  });
};

SCClientSocket.prototype.connect = SCClientSocket.prototype.open = function () {
  var self = this;

  if (!this.active) {
    var error = new InvalidActionError('Cannot connect a destroyed client');
    this._onSCError(error);
    return;
  }

  if (this.state === this.CLOSED) {
    this.pendingReconnect = false;
    this.pendingReconnectTimeout = null;
    clearTimeout(this._reconnectTimeoutRef);

    this.state = this.CONNECTING;
    Emitter.prototype.emit.call(this, 'connecting');

    if (this.transport) {
      this.transport.off();
    }

    this.transport = new SCTransport(this.auth, this.codec, this.options);

    this.transport.on('open', function (status) {
      self.state = self.OPEN;
      self._onSCOpen(status);
    });

    this.transport.on('error', function (err) {
      self._onSCError(err);
    });

    this.transport.on('close', function (code, data) {
      self.state = self.CLOSED;
      self._onSCClose(code, data);
    });

    this.transport.on('openAbort', function (code, data) {
      self.state = self.CLOSED;
      self._onSCClose(code, data, true);
    });

    this.transport.on('event', function (event, data, res) {
      self._onSCEvent(event, data, res);
    });
  }
};

SCClientSocket.prototype.reconnect = function (code, data) {
  this.disconnect(code, data);
  this.connect();
};

SCClientSocket.prototype.disconnect = function (code, data) {
  code = code || 1000;

  if (typeof code !== 'number') {
    throw new InvalidArgumentsError('If specified, the code argument must be a number');
  }

  if (this.state === this.OPEN || this.state === this.CONNECTING) {
    this.transport.close(code, data);
  } else {
    this.pendingReconnect = false;
    this.pendingReconnectTimeout = null;
    clearTimeout(this._reconnectTimeoutRef);
  }
};

SCClientSocket.prototype.destroy = function (code, data) {
  if (isBrowser && global.removeEventListener) {
    global.removeEventListener('beforeunload', this._unloadHandler, false);
  }
  this.active = false;
  this.disconnect(code, data);
  delete this._clientMap[this.clientId];
};

SCClientSocket.prototype._changeToUnauthenticatedStateAndClearTokens = function () {
  if (this.authState !== this.UNAUTHENTICATED) {
    var oldState = this.authState;
    var oldSignedToken = this.signedAuthToken;
    this.authState = this.UNAUTHENTICATED;
    this.signedAuthToken = null;
    this.authToken = null;

    var stateChangeData = {
      oldState: oldState,
      newState: this.authState
    };
    Emitter.prototype.emit.call(this, 'authStateChange', stateChangeData);
    Emitter.prototype.emit.call(this, 'deauthenticate', oldSignedToken);
  }
};

SCClientSocket.prototype._changeToAuthenticatedState = function (signedAuthToken) {
  this.signedAuthToken = signedAuthToken;
  this.authToken = this._extractAuthTokenData(signedAuthToken);

  if (this.authState !== this.AUTHENTICATED) {
    var oldState = this.authState;
    this.authState = this.AUTHENTICATED;
    var stateChangeData = {
      oldState: oldState,
      newState: this.authState,
      signedAuthToken: signedAuthToken,
      authToken: this.authToken
    };
    if (!this.preparingPendingSubscriptions) {
      this.processPendingSubscriptions();
    }

    Emitter.prototype.emit.call(this, 'authStateChange', stateChangeData);
  }
  Emitter.prototype.emit.call(this, 'authenticate', signedAuthToken);
};

SCClientSocket.prototype.decodeBase64 = function (encodedString) {
  return Buffer.from(encodedString, 'base64').toString('utf8');
};

SCClientSocket.prototype.encodeBase64 = function (decodedString) {
  return Buffer.from(decodedString, 'utf8').toString('base64');
};

SCClientSocket.prototype._extractAuthTokenData = function (signedAuthToken) {
  var tokenParts = (signedAuthToken || '').split('.');
  var encodedTokenData = tokenParts[1];
  if (encodedTokenData != null) {
    var tokenData = encodedTokenData;
    try {
      tokenData = this.decodeBase64(tokenData);
      return JSON.parse(tokenData);
    } catch (e) {
      return tokenData;
    }
  }
  return null;
};

SCClientSocket.prototype.getAuthToken = function () {
  return this.authToken;
};

SCClientSocket.prototype.getSignedAuthToken = function () {
  return this.signedAuthToken;
};

// Perform client-initiated authentication by providing an encrypted token string.
SCClientSocket.prototype.authenticate = function (signedAuthToken, callback) {
  var self = this;

  this.emit('#authenticate', signedAuthToken, function (err, authStatus) {
    if (authStatus && authStatus.isAuthenticated != null) {
      // If authStatus is correctly formatted (has an isAuthenticated property),
      // then we will rehydrate the authError.
      if (authStatus.authError) {
        authStatus.authError = scErrors.hydrateError(authStatus.authError);
      }
    } else {
      // Some errors like BadConnectionError and TimeoutError will not pass a valid
      // authStatus object to the current function, so we need to create it ourselves.
      authStatus = {
        isAuthenticated: self.authState,
        authError: null
      };
    }
    if (err) {
      if (err.name !== 'BadConnectionError' && err.name !== 'TimeoutError') {
        // In case of a bad/closed connection or a timeout, we maintain the last
        // known auth state since those errors don't mean that the token is invalid.

        self._changeToUnauthenticatedStateAndClearTokens();
      }
      callback && callback(err, authStatus);
    } else {
      self.auth.saveToken(self.authTokenName, signedAuthToken, {}, function (err) {
        if (err) {
          self._onSCError(err);
        }
        if (authStatus.isAuthenticated) {
          self._changeToAuthenticatedState(signedAuthToken);
        } else {
          self._changeToUnauthenticatedStateAndClearTokens();
        }
        callback && callback(err, authStatus);
      });
    }
  });
};

SCClientSocket.prototype._tryReconnect = function (initialDelay) {
  var self = this;

  var exponent = this.connectAttempts++;
  var reconnectOptions = this.options.autoReconnectOptions;
  var timeout;

  if (initialDelay == null || exponent > 0) {
    var initialTimeout = Math.round(reconnectOptions.initialDelay + (reconnectOptions.randomness || 0) * Math.random());

    timeout = Math.round(initialTimeout * Math.pow(reconnectOptions.multiplier, exponent));
  } else {
    timeout = initialDelay;
  }

  if (timeout > reconnectOptions.maxDelay) {
    timeout = reconnectOptions.maxDelay;
  }

  clearTimeout(this._reconnectTimeoutRef);

  this.pendingReconnect = true;
  this.pendingReconnectTimeout = timeout;
  this._reconnectTimeoutRef = setTimeout(function () {
    self.connect();
  }, timeout);
};

SCClientSocket.prototype._onSCOpen = function (status) {
  var self = this;

  this.preparingPendingSubscriptions = true;

  if (status) {
    this.id = status.id;
    this.pingTimeout = status.pingTimeout;
    this.transport.pingTimeout = this.pingTimeout;
    if (status.isAuthenticated) {
      this._changeToAuthenticatedState(status.authToken);
    } else {
      this._changeToUnauthenticatedStateAndClearTokens();
    }
  } else {
    // This can happen if auth.loadToken (in sctransport.js) fails with
    // an error - This means that the signedAuthToken cannot be loaded by
    // the auth engine and therefore, we need to unauthenticate the client.
    this._changeToUnauthenticatedStateAndClearTokens();
  }

  this.connectAttempts = 0;

  if (this.options.autoSubscribeOnConnect) {
    this.processPendingSubscriptions();
  }

  // If the user invokes the callback while in autoSubscribeOnConnect mode, it
  // won't break anything.
  Emitter.prototype.emit.call(this, 'connect', status, function () {
    self.processPendingSubscriptions();
  });

  if (this.state === this.OPEN) {
    this._flushEmitBuffer();
  }
};

SCClientSocket.prototype._onSCError = function (err) {
  var self = this;

  // Throw error in different stack frame so that error handling
  // cannot interfere with a reconnect action.
  setTimeout(function () {
    if (self.listeners('error').length < 1) {
      throw err;
    } else {
      Emitter.prototype.emit.call(self, 'error', err);
    }
  }, 0);
};

SCClientSocket.prototype._suspendSubscriptions = function () {
  var channel, newState;
  for (var channelName in this.channels) {
    if (this.channels.hasOwnProperty(channelName)) {
      channel = this.channels[channelName];
      if (channel.state === channel.SUBSCRIBED ||
        channel.state === channel.PENDING) {

        newState = channel.PENDING;
      } else {
        newState = channel.UNSUBSCRIBED;
      }

      this._triggerChannelUnsubscribe(channel, newState);
    }
  }
};

SCClientSocket.prototype._abortAllPendingEventsDueToBadConnection = function (failureType) {
  var currentNode = this._emitBuffer.head;
  var nextNode;

  while (currentNode) {
    nextNode = currentNode.next;
    var eventObject = currentNode.data;
    clearTimeout(eventObject.timeout);
    delete eventObject.timeout;
    currentNode.detach();
    currentNode = nextNode;

    var callback = eventObject.callback;
    if (callback) {
      delete eventObject.callback;
      var errorMessage = "Event '" + eventObject.event +
        "' was aborted due to a bad connection";
      var error = new BadConnectionError(errorMessage, failureType);
      callback.call(eventObject, error, eventObject);
    }
    // Cleanup any pending response callback in the transport layer too.
    if (eventObject.cid) {
      this.transport.cancelPendingResponse(eventObject.cid);
    }
  }
};

SCClientSocket.prototype._onSCClose = function (code, data, openAbort) {
  var self = this;

  this.id = null;

  if (this.transport) {
    this.transport.off();
  }
  this.pendingReconnect = false;
  this.pendingReconnectTimeout = null;
  clearTimeout(this._reconnectTimeoutRef);

  this._suspendSubscriptions();
  this._abortAllPendingEventsDueToBadConnection(openAbort ? 'connectAbort' : 'disconnect');

  // Try to reconnect
  // on server ping timeout (4000)
  // or on client pong timeout (4001)
  // or on close without status (1005)
  // or on handshake failure (4003)
  // or on handshake rejection (4008)
  // or on socket hung up (1006)
  if (this.options.autoReconnect) {
    if (code === 4000 || code === 4001 || code === 1005) {
      // If there is a ping or pong timeout or socket closes without
      // status, don't wait before trying to reconnect - These could happen
      // if the client wakes up after a period of inactivity and in this case we
      // want to re-establish the connection as soon as possible.
      this._tryReconnect(0);

      // Codes 4500 and above will be treated as permanent disconnects.
      // Socket will not try to auto-reconnect.
    } else if (code !== 1000 && code < 4500) {
      this._tryReconnect();
    }
  }

  if (openAbort) {
    Emitter.prototype.emit.call(self, 'connectAbort', code, data);
  } else {
    Emitter.prototype.emit.call(self, 'disconnect', code, data);
  }
  Emitter.prototype.emit.call(self, 'close', code, data);

  if (!SCClientSocket.ignoreStatuses[code]) {
    var closeMessage;
    if (data) {
      closeMessage = 'Socket connection closed with status code ' + code + ' and reason: ' + data;
    } else {
      closeMessage = 'Socket connection closed with status code ' + code;
    }
    var err = new SocketProtocolError(SCClientSocket.errorStatuses[code] || closeMessage, code);
    this._onSCError(err);
  }
};

SCClientSocket.prototype._onSCEvent = function (event, data, res) {
  var handler = this._privateEventHandlerMap[event];
  if (handler) {
    handler.call(this, data, res);
  } else {
    Emitter.prototype.emit.call(this, event, data, function () {
      res && res.callback.apply(res, arguments);
    });
  }
};

SCClientSocket.prototype.decode = function (message) {
  return this.transport.decode(message);
};

SCClientSocket.prototype.encode = function (object) {
  return this.transport.encode(object);
};

SCClientSocket.prototype._flushEmitBuffer = function () {
  var currentNode = this._emitBuffer.head;
  var nextNode;

  while (currentNode) {
    nextNode = currentNode.next;
    var eventObject = currentNode.data;
    currentNode.detach();
    this.transport.emitObject(eventObject);
    currentNode = nextNode;
  }
};

SCClientSocket.prototype._handleEventAckTimeout = function (eventObject, eventNode) {
  if (eventNode) {
    eventNode.detach();
  }
  delete eventObject.timeout;

  var callback = eventObject.callback;
  if (callback) {
    delete eventObject.callback;
    var error = new TimeoutError("Event response for '" + eventObject.event + "' timed out");
    callback.call(eventObject, error, eventObject);
  }
  // Cleanup any pending response callback in the transport layer too.
  if (eventObject.cid) {
    this.transport.cancelPendingResponse(eventObject.cid);
  }
};

SCClientSocket.prototype._emit = function (event, data, callback) {
  var self = this;

  if (this.state === this.CLOSED) {
    this.connect();
  }
  var eventObject = {
    event: event,
    callback: callback
  };

  var eventNode = new LinkedList.Item();

  if (this.options.cloneData) {
    eventObject.data = clone(data);
  } else {
    eventObject.data = data;
  }
  eventNode.data = eventObject;

  eventObject.timeout = setTimeout(function () {
    self._handleEventAckTimeout(eventObject, eventNode);
  }, this.ackTimeout);

  this._emitBuffer.append(eventNode);
  if (this.state === this.OPEN) {
    this._flushEmitBuffer();
  }
};

SCClientSocket.prototype.send = function (data) {
  this.transport.send(data);
};

SCClientSocket.prototype.emit = function (event, data, callback) {
  if (this._localEvents[event] == null) {
    this._emit(event, data, callback);
  } else if (event === 'error') {
    Emitter.prototype.emit.call(this, event, data);
  } else {
    var error = new InvalidActionError('The "' + event + '" event is reserved and cannot be emitted on a client socket');
    this._onSCError(error);
  }
};

SCClientSocket.prototype.publish = function (channelName, data, callback) {
  var pubData = {
    channel: this._decorateChannelName(channelName),
    data: data
  };
  this.emit('#publish', pubData, callback);
};

SCClientSocket.prototype._triggerChannelSubscribe = function (channel, subscriptionOptions) {
  var channelName = channel.name;

  if (channel.state !== channel.SUBSCRIBED) {
    var oldState = channel.state;
    channel.state = channel.SUBSCRIBED;

    var stateChangeData = {
      channel: channelName,
      oldState: oldState,
      newState: channel.state,
      subscriptionOptions: subscriptionOptions
    };
    channel.emit('subscribeStateChange', stateChangeData);
    channel.emit('subscribe', channelName, subscriptionOptions);
    Emitter.prototype.emit.call(this, 'subscribeStateChange', stateChangeData);
    Emitter.prototype.emit.call(this, 'subscribe', channelName, subscriptionOptions);
  }
};

SCClientSocket.prototype._triggerChannelSubscribeFail = function (err, channel, subscriptionOptions) {
  var channelName = channel.name;
  var meetsAuthRequirements = !channel.waitForAuth || this.authState === this.AUTHENTICATED;

  if (channel.state !== channel.UNSUBSCRIBED && meetsAuthRequirements) {
    channel.state = channel.UNSUBSCRIBED;

    channel.emit('subscribeFail', err, channelName, subscriptionOptions);
    Emitter.prototype.emit.call(this, 'subscribeFail', err, channelName, subscriptionOptions);
  }
};

// Cancel any pending subscribe callback
SCClientSocket.prototype._cancelPendingSubscribeCallback = function (channel) {
  if (channel._pendingSubscriptionCid != null) {
    this.transport.cancelPendingResponse(channel._pendingSubscriptionCid);
    delete channel._pendingSubscriptionCid;
  }
};

SCClientSocket.prototype._decorateChannelName = function (channelName) {
  if (this.channelPrefix) {
    channelName = this.channelPrefix + channelName;
  }
  return channelName;
};

SCClientSocket.prototype._undecorateChannelName = function (decoratedChannelName) {
  if (this.channelPrefix && decoratedChannelName.indexOf(this.channelPrefix) === 0) {
    return decoratedChannelName.replace(this.channelPrefix, '');
  }
  return decoratedChannelName;
};

SCClientSocket.prototype._trySubscribe = function (channel) {
  var self = this;

  var meetsAuthRequirements = !channel.waitForAuth || this.authState === this.AUTHENTICATED;

  // We can only ever have one pending subscribe action at any given time on a channel
  if (this.state === this.OPEN && !this.preparingPendingSubscriptions &&
    channel._pendingSubscriptionCid == null && meetsAuthRequirements) {

    var options = {
      noTimeout: true
    };

    var subscriptionOptions = {
      channel: this._decorateChannelName(channel.name)
    };
    if (channel.waitForAuth) {
      options.waitForAuth = true;
      subscriptionOptions.waitForAuth = options.waitForAuth;
    }
    if (channel.data) {
      subscriptionOptions.data = channel.data;
    }
    if (channel.batch) {
      options.batch = true;
      subscriptionOptions.batch = true;
    }

    channel._pendingSubscriptionCid = this.transport.emit(
      '#subscribe', subscriptionOptions, options,
      function (err) {
        delete channel._pendingSubscriptionCid;
        if (err) {
          self._triggerChannelSubscribeFail(err, channel, subscriptionOptions);
        } else {
          self._triggerChannelSubscribe(channel, subscriptionOptions);
        }
      }
    );
    Emitter.prototype.emit.call(this, 'subscribeRequest', channel.name, subscriptionOptions);
  }
};

SCClientSocket.prototype.subscribe = function (channelName, options) {
  var channel = this.channels[channelName];

  if (!channel) {
    channel = new SCChannel(channelName, this, options);
    this.channels[channelName] = channel;
  } else if (options) {
    channel.setOptions(options);
  }

  if (channel.state === channel.UNSUBSCRIBED) {
    channel.state = channel.PENDING;
    this._trySubscribe(channel);
  }

  return channel;
};

SCClientSocket.prototype._triggerChannelUnsubscribe = function (channel, newState) {
  var channelName = channel.name;
  var oldState = channel.state;

  if (newState) {
    channel.state = newState;
  } else {
    channel.state = channel.UNSUBSCRIBED;
  }
  this._cancelPendingSubscribeCallback(channel);

  if (oldState === channel.SUBSCRIBED) {
    var stateChangeData = {
      channel: channelName,
      oldState: oldState,
      newState: channel.state
    };
    channel.emit('subscribeStateChange', stateChangeData);
    channel.emit('unsubscribe', channelName);
    Emitter.prototype.emit.call(this, 'subscribeStateChange', stateChangeData);
    Emitter.prototype.emit.call(this, 'unsubscribe', channelName);
  }
};

SCClientSocket.prototype._tryUnsubscribe = function (channel) {
  var self = this;

  if (this.state === this.OPEN) {
    var options = {
      noTimeout: true
    };
    if (channel.batch) {
      options.batch = true;
    }
    // If there is a pending subscribe action, cancel the callback
    this._cancelPendingSubscribeCallback(channel);

    // This operation cannot fail because the TCP protocol guarantees delivery
    // so long as the connection remains open. If the connection closes,
    // the server will automatically unsubscribe the client and thus complete
    // the operation on the server side.
    var decoratedChannelName = this._decorateChannelName(channel.name);
    this.transport.emit('#unsubscribe', decoratedChannelName, options);
  }
};

SCClientSocket.prototype.unsubscribe = function (channelName) {
  var channel = this.channels[channelName];

  if (channel) {
    if (channel.state !== channel.UNSUBSCRIBED) {
      this._triggerChannelUnsubscribe(channel);
      this._tryUnsubscribe(channel);
    }
  }
};

SCClientSocket.prototype.channel = function (channelName, options) {
  var currentChannel = this.channels[channelName];

  if (!currentChannel) {
    currentChannel = new SCChannel(channelName, this, options);
    this.channels[channelName] = currentChannel;
  }
  return currentChannel;
};

SCClientSocket.prototype.destroyChannel = function (channelName) {
  var channel = this.channels[channelName];

  if (channel) {
    channel.unwatch();
    channel.unsubscribe();
    delete this.channels[channelName];
  }
};

SCClientSocket.prototype.subscriptions = function (includePending) {
  var subs = [];
  var channel, includeChannel;
  for (var channelName in this.channels) {
    if (this.channels.hasOwnProperty(channelName)) {
      channel = this.channels[channelName];

      if (includePending) {
        includeChannel = channel && (channel.state === channel.SUBSCRIBED ||
          channel.state === channel.PENDING);
      } else {
        includeChannel = channel && channel.state === channel.SUBSCRIBED;
      }

      if (includeChannel) {
        subs.push(channelName);
      }
    }
  }
  return subs;
};

SCClientSocket.prototype.isSubscribed = function (channelName, includePending) {
  var channel = this.channels[channelName];
  if (includePending) {
    return !!channel && (channel.state === channel.SUBSCRIBED ||
      channel.state === channel.PENDING);
  }
  return !!channel && channel.state === channel.SUBSCRIBED;
};

SCClientSocket.prototype.processPendingSubscriptions = function () {
  var self = this;

  this.preparingPendingSubscriptions = false;

  var pendingChannels = [];

  for (var i in this.channels) {
    if (this.channels.hasOwnProperty(i)) {
      var channel = this.channels[i];
      if (channel.state === channel.PENDING) {
        pendingChannels.push(channel);
      }
    }
  }

  pendingChannels.sort(function (a, b) {
    var ap = a.priority || 0;
    var bp = b.priority || 0;
    if (ap > bp) {
      return -1;
    }
    if (ap < bp) {
      return 1;
    }
    return 0;
  });

  pendingChannels.forEach(function (channel) {
    self._trySubscribe(channel);
  });
};

SCClientSocket.prototype.watch = function (channelName, handler) {
  if (typeof handler !== 'function') {
    throw new InvalidArgumentsError('No handler function was provided');
  }
  this._channelEmitter.on(channelName, handler);
};

SCClientSocket.prototype.unwatch = function (channelName, handler) {
  if (handler) {
    this._channelEmitter.removeListener(channelName, handler);
  } else {
    this._channelEmitter.removeAllListeners(channelName);
  }
};

SCClientSocket.prototype.watchers = function (channelName) {
  return this._channelEmitter.listeners(channelName);
};

module.exports = SCClientSocket;

      };
    };
  }
  }
}, {package:"remote-redux-devtools>socketcluster-client",file:"node_modules\\socketcluster-client\\lib\\scclientsocket.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\socketcluster-client\\lib\\sctransport.js", {"./response":"D:\\code\\v\\metamask-extension\\node_modules\\socketcluster-client\\lib\\response.js","component-emitter":"D:\\code\\v\\metamask-extension\\node_modules\\socketcluster-client\\node_modules\\component-emitter\\index.js","querystring":"D:\\code\\v\\metamask-extension\\node_modules\\querystring-es3\\index.js","sc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\sc-errors\\index.js","ws":"D:\\code\\v\\metamask-extension\\node_modules\\socketcluster-client\\lib\\ws-browser.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Csocketcluster-client%5Clib%5Csctransport.js
      return function (require, module, exports) {
var Emitter = require('component-emitter');
var Response = require('./response').Response;
var querystring = require('querystring');
var WebSocket;
var createWebSocket;

if (global.WebSocket) {
  WebSocket = global.WebSocket;
  createWebSocket = function (uri, options) {
    return new WebSocket(uri);
  };
} else {
  WebSocket = require('ws');
  createWebSocket = function (uri, options) {
    return new WebSocket(uri, null, options);
  };
}

var scErrors = require('sc-errors');
var TimeoutError = scErrors.TimeoutError;
var BadConnectionError = scErrors.BadConnectionError;


var SCTransport = function (authEngine, codecEngine, options) {
  var self = this;

  this.state = this.CLOSED;
  this.auth = authEngine;
  this.codec = codecEngine;
  this.options = options;
  this.connectTimeout = options.connectTimeout;
  this.pingTimeout = options.ackTimeout;
  this.pingTimeoutDisabled = !!options.pingTimeoutDisabled;
  this.callIdGenerator = options.callIdGenerator;
  this.authTokenName = options.authTokenName;

  this._pingTimeoutTicker = null;
  this._callbackMap = {};
  this._batchSendList = [];

  // Open the connection.

  this.state = this.CONNECTING;
  var uri = this.uri();

  var wsSocket = createWebSocket(uri, this.options);
  wsSocket.binaryType = this.options.binaryType;

  this.socket = wsSocket;

  wsSocket.onopen = function () {
    self._onOpen();
  };

  wsSocket.onclose = function (event) {
    var code;
    if (event.code == null) {
      // This is to handle an edge case in React Native whereby
      // event.code is undefined when the mobile device is locked.
      // TODO: This is not perfect since this condition could also apply to
      // an abnormal close (no close control frame) which would be a 1006.
      code = 1005;
    } else {
      code = event.code;
    }
    self._onClose(code, event.reason);
  };

  wsSocket.onmessage = function (message, flags) {
    self._onMessage(message.data);
  };

  wsSocket.onerror = function (error) {
    // The onclose event will be called automatically after the onerror event
    // if the socket is connected - Otherwise, if it's in the middle of
    // connecting, we want to close it manually with a 1006 - This is necessary
    // to prevent inconsistent behavior when running the client in Node.js
    // vs in a browser.

    if (self.state === self.CONNECTING) {
      self._onClose(1006);
    }
  };

  this._connectTimeoutRef = setTimeout(function () {
    self._onClose(4007);
    self.socket.close(4007);
  }, this.connectTimeout);
};

SCTransport.prototype = Object.create(Emitter.prototype);

SCTransport.CONNECTING = SCTransport.prototype.CONNECTING = 'connecting';
SCTransport.OPEN = SCTransport.prototype.OPEN = 'open';
SCTransport.CLOSED = SCTransport.prototype.CLOSED = 'closed';

SCTransport.prototype.uri = function () {
  var query = this.options.query || {};
  var schema = this.options.secure ? 'wss' : 'ws';

  if (this.options.timestampRequests) {
    query[this.options.timestampParam] = (new Date()).getTime();
  }

  query = querystring.encode(query);

  if (query.length) {
    query = '?' + query;
  }

  var host;
  if (this.options.host) {
    host = this.options.host;
  } else {
    var port = '';

    if (this.options.port && ((schema === 'wss' && this.options.port !== 443)
      || (schema === 'ws' && this.options.port !== 80))) {
      port = ':' + this.options.port;
    }
    host = this.options.hostname + port;
  }

  return schema + '://' + host + this.options.path + query;
};

SCTransport.prototype._onOpen = function () {
  var self = this;

  clearTimeout(this._connectTimeoutRef);
  this._resetPingTimeout();

  this._handshake(function (err, status) {
    if (err) {
      var statusCode;
      if (status && status.code) {
        statusCode = status.code;
      } else {
        statusCode = 4003;
      }
      self._onError(err);
      self._onClose(statusCode, err.toString());
      self.socket.close(statusCode);
    } else {
      self.state = self.OPEN;
      Emitter.prototype.emit.call(self, 'open', status);
      self._resetPingTimeout();
    }
  });
};

SCTransport.prototype._handshake = function (callback) {
  var self = this;
  this.auth.loadToken(this.authTokenName, function (err, token) {
    if (err) {
      callback(err);
    } else {
      // Don't wait for this.state to be 'open'.
      // The underlying WebSocket (this.socket) is already open.
      var options = {
        force: true
      };
      self.emit('#handshake', {
        authToken: token
      }, options, function (err, status) {
        if (status) {
          // Add the token which was used as part of authentication attempt
          // to the status object.
          status.authToken = token;
          if (status.authError) {
            status.authError = scErrors.hydrateError(status.authError);
          }
        }
        callback(err, status);
      });
    }
  });
};

SCTransport.prototype._abortAllPendingEventsDueToBadConnection = function (failureType) {
  for (var i in this._callbackMap) {
    if (this._callbackMap.hasOwnProperty(i)) {
      var eventObject = this._callbackMap[i];
      delete this._callbackMap[i];

      clearTimeout(eventObject.timeout);
      delete eventObject.timeout;

      var errorMessage = "Event '" + eventObject.event +
        "' was aborted due to a bad connection";
      var badConnectionError = new BadConnectionError(errorMessage, failureType);

      var callback = eventObject.callback;
      delete eventObject.callback;
      callback.call(eventObject, badConnectionError, eventObject);
    }
  }
};

SCTransport.prototype._onClose = function (code, data) {
  delete this.socket.onopen;
  delete this.socket.onclose;
  delete this.socket.onmessage;
  delete this.socket.onerror;

  clearTimeout(this._connectTimeoutRef);
  clearTimeout(this._pingTimeoutTicker);
  clearTimeout(this._batchTimeout);

  if (this.state === this.OPEN) {
    this.state = this.CLOSED;
    Emitter.prototype.emit.call(this, 'close', code, data);
    this._abortAllPendingEventsDueToBadConnection('disconnect');

  } else if (this.state === this.CONNECTING) {
    this.state = this.CLOSED;
    Emitter.prototype.emit.call(this, 'openAbort', code, data);
    this._abortAllPendingEventsDueToBadConnection('connectAbort');
  }
};

SCTransport.prototype._handleEventObject = function (obj, message) {
  if (obj && obj.event != null) {
    var response = new Response(this, obj.cid);
    Emitter.prototype.emit.call(this, 'event', obj.event, obj.data, response);
  } else if (obj && obj.rid != null) {
    var eventObject = this._callbackMap[obj.rid];
    if (eventObject) {
      clearTimeout(eventObject.timeout);
      delete eventObject.timeout;
      delete this._callbackMap[obj.rid];

      if (eventObject.callback) {
        var rehydratedError = scErrors.hydrateError(obj.error);
        eventObject.callback(rehydratedError, obj.data);
      }
    }
  } else {
    Emitter.prototype.emit.call(this, 'event', 'raw', message);
  }
};

SCTransport.prototype._onMessage = function (message) {
  Emitter.prototype.emit.call(this, 'event', 'message', message);

  var obj = this.decode(message);

  // If ping
  if (obj === '#1') {
    this._resetPingTimeout();
    if (this.socket.readyState === this.socket.OPEN) {
      this.sendObject('#2');
    }
  } else {
    if (Array.isArray(obj)) {
      var len = obj.length;
      for (var i = 0; i < len; i++) {
        this._handleEventObject(obj[i], message);
      }
    } else {
      this._handleEventObject(obj, message);
    }
  }
};

SCTransport.prototype._onError = function (err) {
  Emitter.prototype.emit.call(this, 'error', err);
};

SCTransport.prototype._resetPingTimeout = function () {
  if (this.pingTimeoutDisabled) {
    return;
  }
  var self = this;

  var now = (new Date()).getTime();
  clearTimeout(this._pingTimeoutTicker);

  this._pingTimeoutTicker = setTimeout(function () {
    self._onClose(4000);
    self.socket.close(4000);
  }, this.pingTimeout);
};

SCTransport.prototype.getBytesReceived = function () {
  return this.socket.bytesReceived;
};

SCTransport.prototype.close = function (code, data) {
  code = code || 1000;

  if (this.state === this.OPEN) {
    var packet = {
      code: code,
      data: data
    };
    this.emit('#disconnect', packet);

    this._onClose(code, data);
    this.socket.close(code);

  } else if (this.state === this.CONNECTING) {
    this._onClose(code, data);
    this.socket.close(code);
  }
};

SCTransport.prototype.emitObject = function (eventObject, options) {
  var simpleEventObject = {
    event: eventObject.event,
    data: eventObject.data
  };

  if (eventObject.callback) {
    simpleEventObject.cid = eventObject.cid = this.callIdGenerator();
    this._callbackMap[eventObject.cid] = eventObject;
  }

  this.sendObject(simpleEventObject, options);

  return eventObject.cid || null;
};

SCTransport.prototype._handleEventAckTimeout = function (eventObject) {
  if (eventObject.cid) {
    delete this._callbackMap[eventObject.cid];
  }
  delete eventObject.timeout;

  var callback = eventObject.callback;
  if (callback) {
    delete eventObject.callback;
    var error = new TimeoutError("Event response for '" + eventObject.event + "' timed out");
    callback.call(eventObject, error, eventObject);
  }
};

// The last two optional arguments (a and b) can be options and/or callback
SCTransport.prototype.emit = function (event, data, a, b) {
  var self = this;

  var callback, options;

  if (b) {
    options = a;
    callback = b;
  } else {
    if (a instanceof Function) {
      options = {};
      callback = a;
    } else {
      options = a;
    }
  }

  var eventObject = {
    event: event,
    data: data,
    callback: callback
  };

  if (callback && !options.noTimeout) {
    eventObject.timeout = setTimeout(function () {
      self._handleEventAckTimeout(eventObject);
    }, this.options.ackTimeout);
  }

  var cid = null;
  if (this.state === this.OPEN || options.force) {
    cid = this.emitObject(eventObject, options);
  }
  return cid;
};

SCTransport.prototype.cancelPendingResponse = function (cid) {
  delete this._callbackMap[cid];
};

SCTransport.prototype.decode = function (message) {
  return this.codec.decode(message);
};

SCTransport.prototype.encode = function (object) {
  return this.codec.encode(object);
};

SCTransport.prototype.send = function (data) {
  if (this.socket.readyState !== this.socket.OPEN) {
    this._onClose(1005);
  } else {
    this.socket.send(data);
  }
};

SCTransport.prototype.serializeObject = function (object) {
  var str, formatError;
  try {
    str = this.encode(object);
  } catch (err) {
    formatError = err;
    this._onError(formatError);
  }
  if (!formatError) {
    return str;
  }
  return null;
};

SCTransport.prototype.sendObjectBatch = function (object) {
  var self = this;

  this._batchSendList.push(object);
  if (this._batchTimeout) {
    return;
  }

  this._batchTimeout = setTimeout(function () {
    delete self._batchTimeout;
    if (self._batchSendList.length) {
      var str = self.serializeObject(self._batchSendList);
      if (str != null) {
        self.send(str);
      }
      self._batchSendList = [];
    }
  }, this.options.pubSubBatchDuration || 0);
};

SCTransport.prototype.sendObjectSingle = function (object) {
  var str = this.serializeObject(object);
  if (str != null) {
    this.send(str);
  }
};

SCTransport.prototype.sendObject = function (object, options) {
  if (options && options.batch) {
    this.sendObjectBatch(object);
  } else {
    this.sendObjectSingle(object);
  }
};

module.exports.SCTransport = SCTransport;

      };
    };
  }
  }
}, {package:"remote-redux-devtools>socketcluster-client",file:"node_modules\\socketcluster-client\\lib\\sctransport.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\socketcluster-client\\lib\\ws-browser.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Csocketcluster-client%5Clib%5Cws-browser.js
      return function (require, module, exports) {
var global;
if (typeof WorkerGlobalScope !== 'undefined') {
  global = self;
} else {
  global = typeof window !== 'undefined' && window || (function() { return this; })();
}

var WebSocket = global.WebSocket || global.MozWebSocket;

/**
 * WebSocket constructor.
 *
 * The third `opts` options object gets ignored in web browsers, since it's
 * non-standard, and throws a TypeError if passed to the constructor.
 * See: https://github.com/einaros/ws/issues/227
 *
 * @param {String} uri
 * @param {Array} protocols (optional)
 * @param {Object} opts (optional)
 * @api public
 */

function ws(uri, protocols, opts) {
  var instance;
  if (protocols) {
    instance = new WebSocket(uri, protocols);
  } else {
    instance = new WebSocket(uri);
  }
  return instance;
}

if (WebSocket) ws.prototype = WebSocket.prototype;

module.exports = WebSocket ? ws : null;

      };
    };
  }
  }
}, {package:"remote-redux-devtools>socketcluster-client",file:"node_modules\\socketcluster-client\\lib\\ws-browser.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\socketcluster-client\\node_modules\\buffer\\index.js", {"base64-js":"D:\\code\\v\\metamask-extension\\node_modules\\base64-js\\index.js","ieee754":"D:\\code\\v\\metamask-extension\\node_modules\\ieee754\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Csocketcluster-client%5Cnode_modules%5Cbuffer%5Cindex.js
      return function (require, module, exports) {
/*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <https://feross.org>
 * @license  MIT
 */
/* eslint-disable no-proto */

'use strict'

var base64 = require('base64-js')
var ieee754 = require('ieee754')
var customInspectSymbol =
  (typeof Symbol === 'function' && typeof Symbol['for'] === 'function') // eslint-disable-line dot-notation
    ? Symbol['for']('nodejs.util.inspect.custom') // eslint-disable-line dot-notation
    : null

exports.Buffer = Buffer
exports.SlowBuffer = SlowBuffer
exports.INSPECT_MAX_BYTES = 50

var K_MAX_LENGTH = 0x7fffffff
exports.kMaxLength = K_MAX_LENGTH

/**
 * If `Buffer.TYPED_ARRAY_SUPPORT`:
 *   === true    Use Uint8Array implementation (fastest)
 *   === false   Print warning and recommend using `buffer` v4.x which has an Object
 *               implementation (most compatible, even IE6)
 *
 * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,
 * Opera 11.6+, iOS 4.2+.
 *
 * We report that the browser does not support typed arrays if the are not subclassable
 * using __proto__. Firefox 4-29 lacks support for adding new properties to `Uint8Array`
 * (See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438). IE 10 lacks support
 * for __proto__ and has a buggy typed array implementation.
 */
Buffer.TYPED_ARRAY_SUPPORT = typedArraySupport()

if (!Buffer.TYPED_ARRAY_SUPPORT && typeof console !== 'undefined' &&
    typeof console.error === 'function') {
  console.error(
    'This browser lacks typed array (Uint8Array) support which is required by ' +
    '`buffer` v5.x. Use `buffer` v4.x if you require old browser support.'
  )
}

function typedArraySupport () {
  // Can typed array instances can be augmented?
  try {
    var arr = new Uint8Array(1)
    var proto = { foo: function () { return 42 } }
    Object.setPrototypeOf(proto, Uint8Array.prototype)
    Object.setPrototypeOf(arr, proto)
    return arr.foo() === 42
  } catch (e) {
    return false
  }
}

Object.defineProperty(Buffer.prototype, 'parent', {
  enumerable: true,
  get: function () {
    if (!Buffer.isBuffer(this)) return undefined
    return this.buffer
  }
})

Object.defineProperty(Buffer.prototype, 'offset', {
  enumerable: true,
  get: function () {
    if (!Buffer.isBuffer(this)) return undefined
    return this.byteOffset
  }
})

function createBuffer (length) {
  if (length > K_MAX_LENGTH) {
    throw new RangeError('The value "' + length + '" is invalid for option "size"')
  }
  // Return an augmented `Uint8Array` instance
  var buf = new Uint8Array(length)
  Object.setPrototypeOf(buf, Buffer.prototype)
  return buf
}

/**
 * The Buffer constructor returns instances of `Uint8Array` that have their
 * prototype changed to `Buffer.prototype`. Furthermore, `Buffer` is a subclass of
 * `Uint8Array`, so the returned instances will have all the node `Buffer` methods
 * and the `Uint8Array` methods. Square bracket notation works as expected -- it
 * returns a single octet.
 *
 * The `Uint8Array` prototype remains unmodified.
 */

function Buffer (arg, encodingOrOffset, length) {
  // Common case.
  if (typeof arg === 'number') {
    if (typeof encodingOrOffset === 'string') {
      throw new TypeError(
        'The "string" argument must be of type string. Received type number'
      )
    }
    return allocUnsafe(arg)
  }
  return from(arg, encodingOrOffset, length)
}

Buffer.poolSize = 8192 // not used by this implementation

function from (value, encodingOrOffset, length) {
  if (typeof value === 'string') {
    return fromString(value, encodingOrOffset)
  }

  if (ArrayBuffer.isView(value)) {
    return fromArrayView(value)
  }

  if (value == null) {
    throw new TypeError(
      'The first argument must be one of type string, Buffer, ArrayBuffer, Array, ' +
      'or Array-like Object. Received type ' + (typeof value)
    )
  }

  if (isInstance(value, ArrayBuffer) ||
      (value && isInstance(value.buffer, ArrayBuffer))) {
    return fromArrayBuffer(value, encodingOrOffset, length)
  }

  if (typeof SharedArrayBuffer !== 'undefined' &&
      (isInstance(value, SharedArrayBuffer) ||
      (value && isInstance(value.buffer, SharedArrayBuffer)))) {
    return fromArrayBuffer(value, encodingOrOffset, length)
  }

  if (typeof value === 'number') {
    throw new TypeError(
      'The "value" argument must not be of type number. Received type number'
    )
  }

  var valueOf = value.valueOf && value.valueOf()
  if (valueOf != null && valueOf !== value) {
    return Buffer.from(valueOf, encodingOrOffset, length)
  }

  var b = fromObject(value)
  if (b) return b

  if (typeof Symbol !== 'undefined' && Symbol.toPrimitive != null &&
      typeof value[Symbol.toPrimitive] === 'function') {
    return Buffer.from(
      value[Symbol.toPrimitive]('string'), encodingOrOffset, length
    )
  }

  throw new TypeError(
    'The first argument must be one of type string, Buffer, ArrayBuffer, Array, ' +
    'or Array-like Object. Received type ' + (typeof value)
  )
}

/**
 * Functionally equivalent to Buffer(arg, encoding) but throws a TypeError
 * if value is a number.
 * Buffer.from(str[, encoding])
 * Buffer.from(array)
 * Buffer.from(buffer)
 * Buffer.from(arrayBuffer[, byteOffset[, length]])
 **/
Buffer.from = function (value, encodingOrOffset, length) {
  return from(value, encodingOrOffset, length)
}

// Note: Change prototype *after* Buffer.from is defined to workaround Chrome bug:
// https://github.com/feross/buffer/pull/148
Object.setPrototypeOf(Buffer.prototype, Uint8Array.prototype)
Object.setPrototypeOf(Buffer, Uint8Array)

function assertSize (size) {
  if (typeof size !== 'number') {
    throw new TypeError('"size" argument must be of type number')
  } else if (size < 0) {
    throw new RangeError('The value "' + size + '" is invalid for option "size"')
  }
}

function alloc (size, fill, encoding) {
  assertSize(size)
  if (size <= 0) {
    return createBuffer(size)
  }
  if (fill !== undefined) {
    // Only pay attention to encoding if it's a string. This
    // prevents accidentally sending in a number that would
    // be interpreted as a start offset.
    return typeof encoding === 'string'
      ? createBuffer(size).fill(fill, encoding)
      : createBuffer(size).fill(fill)
  }
  return createBuffer(size)
}

/**
 * Creates a new filled Buffer instance.
 * alloc(size[, fill[, encoding]])
 **/
Buffer.alloc = function (size, fill, encoding) {
  return alloc(size, fill, encoding)
}

function allocUnsafe (size) {
  assertSize(size)
  return createBuffer(size < 0 ? 0 : checked(size) | 0)
}

/**
 * Equivalent to Buffer(num), by default creates a non-zero-filled Buffer instance.
 * */
Buffer.allocUnsafe = function (size) {
  return allocUnsafe(size)
}
/**
 * Equivalent to SlowBuffer(num), by default creates a non-zero-filled Buffer instance.
 */
Buffer.allocUnsafeSlow = function (size) {
  return allocUnsafe(size)
}

function fromString (string, encoding) {
  if (typeof encoding !== 'string' || encoding === '') {
    encoding = 'utf8'
  }

  if (!Buffer.isEncoding(encoding)) {
    throw new TypeError('Unknown encoding: ' + encoding)
  }

  var length = byteLength(string, encoding) | 0
  var buf = createBuffer(length)

  var actual = buf.write(string, encoding)

  if (actual !== length) {
    // Writing a hex string, for example, that contains invalid characters will
    // cause everything after the first invalid character to be ignored. (e.g.
    // 'abxxcd' will be treated as 'ab')
    buf = buf.slice(0, actual)
  }

  return buf
}

function fromArrayLike (array) {
  var length = array.length < 0 ? 0 : checked(array.length) | 0
  var buf = createBuffer(length)
  for (var i = 0; i < length; i += 1) {
    buf[i] = array[i] & 255
  }
  return buf
}

function fromArrayView (arrayView) {
  if (isInstance(arrayView, Uint8Array)) {
    var copy = new Uint8Array(arrayView)
    return fromArrayBuffer(copy.buffer, copy.byteOffset, copy.byteLength)
  }
  return fromArrayLike(arrayView)
}

function fromArrayBuffer (array, byteOffset, length) {
  if (byteOffset < 0 || array.byteLength < byteOffset) {
    throw new RangeError('"offset" is outside of buffer bounds')
  }

  if (array.byteLength < byteOffset + (length || 0)) {
    throw new RangeError('"length" is outside of buffer bounds')
  }

  var buf
  if (byteOffset === undefined && length === undefined) {
    buf = new Uint8Array(array)
  } else if (length === undefined) {
    buf = new Uint8Array(array, byteOffset)
  } else {
    buf = new Uint8Array(array, byteOffset, length)
  }

  // Return an augmented `Uint8Array` instance
  Object.setPrototypeOf(buf, Buffer.prototype)

  return buf
}

function fromObject (obj) {
  if (Buffer.isBuffer(obj)) {
    var len = checked(obj.length) | 0
    var buf = createBuffer(len)

    if (buf.length === 0) {
      return buf
    }

    obj.copy(buf, 0, 0, len)
    return buf
  }

  if (obj.length !== undefined) {
    if (typeof obj.length !== 'number' || numberIsNaN(obj.length)) {
      return createBuffer(0)
    }
    return fromArrayLike(obj)
  }

  if (obj.type === 'Buffer' && Array.isArray(obj.data)) {
    return fromArrayLike(obj.data)
  }
}

function checked (length) {
  // Note: cannot use `length < K_MAX_LENGTH` here because that fails when
  // length is NaN (which is otherwise coerced to zero.)
  if (length >= K_MAX_LENGTH) {
    throw new RangeError('Attempt to allocate Buffer larger than maximum ' +
                         'size: 0x' + K_MAX_LENGTH.toString(16) + ' bytes')
  }
  return length | 0
}

function SlowBuffer (length) {
  if (+length != length) { // eslint-disable-line eqeqeq
    length = 0
  }
  return Buffer.alloc(+length)
}

Buffer.isBuffer = function isBuffer (b) {
  return b != null && b._isBuffer === true &&
    b !== Buffer.prototype // so Buffer.isBuffer(Buffer.prototype) will be false
}

Buffer.compare = function compare (a, b) {
  if (isInstance(a, Uint8Array)) a = Buffer.from(a, a.offset, a.byteLength)
  if (isInstance(b, Uint8Array)) b = Buffer.from(b, b.offset, b.byteLength)
  if (!Buffer.isBuffer(a) || !Buffer.isBuffer(b)) {
    throw new TypeError(
      'The "buf1", "buf2" arguments must be one of type Buffer or Uint8Array'
    )
  }

  if (a === b) return 0

  var x = a.length
  var y = b.length

  for (var i = 0, len = Math.min(x, y); i < len; ++i) {
    if (a[i] !== b[i]) {
      x = a[i]
      y = b[i]
      break
    }
  }

  if (x < y) return -1
  if (y < x) return 1
  return 0
}

Buffer.isEncoding = function isEncoding (encoding) {
  switch (String(encoding).toLowerCase()) {
    case 'hex':
    case 'utf8':
    case 'utf-8':
    case 'ascii':
    case 'latin1':
    case 'binary':
    case 'base64':
    case 'ucs2':
    case 'ucs-2':
    case 'utf16le':
    case 'utf-16le':
      return true
    default:
      return false
  }
}

Buffer.concat = function concat (list, length) {
  if (!Array.isArray(list)) {
    throw new TypeError('"list" argument must be an Array of Buffers')
  }

  if (list.length === 0) {
    return Buffer.alloc(0)
  }

  var i
  if (length === undefined) {
    length = 0
    for (i = 0; i < list.length; ++i) {
      length += list[i].length
    }
  }

  var buffer = Buffer.allocUnsafe(length)
  var pos = 0
  for (i = 0; i < list.length; ++i) {
    var buf = list[i]
    if (isInstance(buf, Uint8Array)) {
      if (pos + buf.length > buffer.length) {
        Buffer.from(buf).copy(buffer, pos)
      } else {
        Uint8Array.prototype.set.call(
          buffer,
          buf,
          pos
        )
      }
    } else if (!Buffer.isBuffer(buf)) {
      throw new TypeError('"list" argument must be an Array of Buffers')
    } else {
      buf.copy(buffer, pos)
    }
    pos += buf.length
  }
  return buffer
}

function byteLength (string, encoding) {
  if (Buffer.isBuffer(string)) {
    return string.length
  }
  if (ArrayBuffer.isView(string) || isInstance(string, ArrayBuffer)) {
    return string.byteLength
  }
  if (typeof string !== 'string') {
    throw new TypeError(
      'The "string" argument must be one of type string, Buffer, or ArrayBuffer. ' +
      'Received type ' + typeof string
    )
  }

  var len = string.length
  var mustMatch = (arguments.length > 2 && arguments[2] === true)
  if (!mustMatch && len === 0) return 0

  // Use a for loop to avoid recursion
  var loweredCase = false
  for (;;) {
    switch (encoding) {
      case 'ascii':
      case 'latin1':
      case 'binary':
        return len
      case 'utf8':
      case 'utf-8':
        return utf8ToBytes(string).length
      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return len * 2
      case 'hex':
        return len >>> 1
      case 'base64':
        return base64ToBytes(string).length
      default:
        if (loweredCase) {
          return mustMatch ? -1 : utf8ToBytes(string).length // assume utf8
        }
        encoding = ('' + encoding).toLowerCase()
        loweredCase = true
    }
  }
}
Buffer.byteLength = byteLength

function slowToString (encoding, start, end) {
  var loweredCase = false

  // No need to verify that "this.length <= MAX_UINT32" since it's a read-only
  // property of a typed array.

  // This behaves neither like String nor Uint8Array in that we set start/end
  // to their upper/lower bounds if the value passed is out of range.
  // undefined is handled specially as per ECMA-262 6th Edition,
  // Section 13.3.3.7 Runtime Semantics: KeyedBindingInitialization.
  if (start === undefined || start < 0) {
    start = 0
  }
  // Return early if start > this.length. Done here to prevent potential uint32
  // coercion fail below.
  if (start > this.length) {
    return ''
  }

  if (end === undefined || end > this.length) {
    end = this.length
  }

  if (end <= 0) {
    return ''
  }

  // Force coercion to uint32. This will also coerce falsey/NaN values to 0.
  end >>>= 0
  start >>>= 0

  if (end <= start) {
    return ''
  }

  if (!encoding) encoding = 'utf8'

  while (true) {
    switch (encoding) {
      case 'hex':
        return hexSlice(this, start, end)

      case 'utf8':
      case 'utf-8':
        return utf8Slice(this, start, end)

      case 'ascii':
        return asciiSlice(this, start, end)

      case 'latin1':
      case 'binary':
        return latin1Slice(this, start, end)

      case 'base64':
        return base64Slice(this, start, end)

      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return utf16leSlice(this, start, end)

      default:
        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
        encoding = (encoding + '').toLowerCase()
        loweredCase = true
    }
  }
}

// This property is used by `Buffer.isBuffer` (and the `is-buffer` npm package)
// to detect a Buffer instance. It's not possible to use `instanceof Buffer`
// reliably in a browserify context because there could be multiple different
// copies of the 'buffer' package in use. This method works even for Buffer
// instances that were created from another copy of the `buffer` package.
// See: https://github.com/feross/buffer/issues/154
Buffer.prototype._isBuffer = true

function swap (b, n, m) {
  var i = b[n]
  b[n] = b[m]
  b[m] = i
}

Buffer.prototype.swap16 = function swap16 () {
  var len = this.length
  if (len % 2 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 16-bits')
  }
  for (var i = 0; i < len; i += 2) {
    swap(this, i, i + 1)
  }
  return this
}

Buffer.prototype.swap32 = function swap32 () {
  var len = this.length
  if (len % 4 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 32-bits')
  }
  for (var i = 0; i < len; i += 4) {
    swap(this, i, i + 3)
    swap(this, i + 1, i + 2)
  }
  return this
}

Buffer.prototype.swap64 = function swap64 () {
  var len = this.length
  if (len % 8 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 64-bits')
  }
  for (var i = 0; i < len; i += 8) {
    swap(this, i, i + 7)
    swap(this, i + 1, i + 6)
    swap(this, i + 2, i + 5)
    swap(this, i + 3, i + 4)
  }
  return this
}

Buffer.prototype.toString = function toString () {
  var length = this.length
  if (length === 0) return ''
  if (arguments.length === 0) return utf8Slice(this, 0, length)
  return slowToString.apply(this, arguments)
}

Buffer.prototype.toLocaleString = Buffer.prototype.toString

Buffer.prototype.equals = function equals (b) {
  if (!Buffer.isBuffer(b)) throw new TypeError('Argument must be a Buffer')
  if (this === b) return true
  return Buffer.compare(this, b) === 0
}

Buffer.prototype.inspect = function inspect () {
  var str = ''
  var max = exports.INSPECT_MAX_BYTES
  str = this.toString('hex', 0, max).replace(/(.{2})/g, '$1 ').trim()
  if (this.length > max) str += ' ... '
  return '<Buffer ' + str + '>'
}
if (customInspectSymbol) {
  Buffer.prototype[customInspectSymbol] = Buffer.prototype.inspect
}

Buffer.prototype.compare = function compare (target, start, end, thisStart, thisEnd) {
  if (isInstance(target, Uint8Array)) {
    target = Buffer.from(target, target.offset, target.byteLength)
  }
  if (!Buffer.isBuffer(target)) {
    throw new TypeError(
      'The "target" argument must be one of type Buffer or Uint8Array. ' +
      'Received type ' + (typeof target)
    )
  }

  if (start === undefined) {
    start = 0
  }
  if (end === undefined) {
    end = target ? target.length : 0
  }
  if (thisStart === undefined) {
    thisStart = 0
  }
  if (thisEnd === undefined) {
    thisEnd = this.length
  }

  if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
    throw new RangeError('out of range index')
  }

  if (thisStart >= thisEnd && start >= end) {
    return 0
  }
  if (thisStart >= thisEnd) {
    return -1
  }
  if (start >= end) {
    return 1
  }

  start >>>= 0
  end >>>= 0
  thisStart >>>= 0
  thisEnd >>>= 0

  if (this === target) return 0

  var x = thisEnd - thisStart
  var y = end - start
  var len = Math.min(x, y)

  var thisCopy = this.slice(thisStart, thisEnd)
  var targetCopy = target.slice(start, end)

  for (var i = 0; i < len; ++i) {
    if (thisCopy[i] !== targetCopy[i]) {
      x = thisCopy[i]
      y = targetCopy[i]
      break
    }
  }

  if (x < y) return -1
  if (y < x) return 1
  return 0
}

// Finds either the first index of `val` in `buffer` at offset >= `byteOffset`,
// OR the last index of `val` in `buffer` at offset <= `byteOffset`.
//
// Arguments:
// - buffer - a Buffer to search
// - val - a string, Buffer, or number
// - byteOffset - an index into `buffer`; will be clamped to an int32
// - encoding - an optional encoding, relevant is val is a string
// - dir - true for indexOf, false for lastIndexOf
function bidirectionalIndexOf (buffer, val, byteOffset, encoding, dir) {
  // Empty buffer means no match
  if (buffer.length === 0) return -1

  // Normalize byteOffset
  if (typeof byteOffset === 'string') {
    encoding = byteOffset
    byteOffset = 0
  } else if (byteOffset > 0x7fffffff) {
    byteOffset = 0x7fffffff
  } else if (byteOffset < -0x80000000) {
    byteOffset = -0x80000000
  }
  byteOffset = +byteOffset // Coerce to Number.
  if (numberIsNaN(byteOffset)) {
    // byteOffset: it it's undefined, null, NaN, "foo", etc, search whole buffer
    byteOffset = dir ? 0 : (buffer.length - 1)
  }

  // Normalize byteOffset: negative offsets start from the end of the buffer
  if (byteOffset < 0) byteOffset = buffer.length + byteOffset
  if (byteOffset >= buffer.length) {
    if (dir) return -1
    else byteOffset = buffer.length - 1
  } else if (byteOffset < 0) {
    if (dir) byteOffset = 0
    else return -1
  }

  // Normalize val
  if (typeof val === 'string') {
    val = Buffer.from(val, encoding)
  }

  // Finally, search either indexOf (if dir is true) or lastIndexOf
  if (Buffer.isBuffer(val)) {
    // Special case: looking for empty string/buffer always fails
    if (val.length === 0) {
      return -1
    }
    return arrayIndexOf(buffer, val, byteOffset, encoding, dir)
  } else if (typeof val === 'number') {
    val = val & 0xFF // Search for a byte value [0-255]
    if (typeof Uint8Array.prototype.indexOf === 'function') {
      if (dir) {
        return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset)
      } else {
        return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset)
      }
    }
    return arrayIndexOf(buffer, [val], byteOffset, encoding, dir)
  }

  throw new TypeError('val must be string, number or Buffer')
}

function arrayIndexOf (arr, val, byteOffset, encoding, dir) {
  var indexSize = 1
  var arrLength = arr.length
  var valLength = val.length

  if (encoding !== undefined) {
    encoding = String(encoding).toLowerCase()
    if (encoding === 'ucs2' || encoding === 'ucs-2' ||
        encoding === 'utf16le' || encoding === 'utf-16le') {
      if (arr.length < 2 || val.length < 2) {
        return -1
      }
      indexSize = 2
      arrLength /= 2
      valLength /= 2
      byteOffset /= 2
    }
  }

  function read (buf, i) {
    if (indexSize === 1) {
      return buf[i]
    } else {
      return buf.readUInt16BE(i * indexSize)
    }
  }

  var i
  if (dir) {
    var foundIndex = -1
    for (i = byteOffset; i < arrLength; i++) {
      if (read(arr, i) === read(val, foundIndex === -1 ? 0 : i - foundIndex)) {
        if (foundIndex === -1) foundIndex = i
        if (i - foundIndex + 1 === valLength) return foundIndex * indexSize
      } else {
        if (foundIndex !== -1) i -= i - foundIndex
        foundIndex = -1
      }
    }
  } else {
    if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength
    for (i = byteOffset; i >= 0; i--) {
      var found = true
      for (var j = 0; j < valLength; j++) {
        if (read(arr, i + j) !== read(val, j)) {
          found = false
          break
        }
      }
      if (found) return i
    }
  }

  return -1
}

Buffer.prototype.includes = function includes (val, byteOffset, encoding) {
  return this.indexOf(val, byteOffset, encoding) !== -1
}

Buffer.prototype.indexOf = function indexOf (val, byteOffset, encoding) {
  return bidirectionalIndexOf(this, val, byteOffset, encoding, true)
}

Buffer.prototype.lastIndexOf = function lastIndexOf (val, byteOffset, encoding) {
  return bidirectionalIndexOf(this, val, byteOffset, encoding, false)
}

function hexWrite (buf, string, offset, length) {
  offset = Number(offset) || 0
  var remaining = buf.length - offset
  if (!length) {
    length = remaining
  } else {
    length = Number(length)
    if (length > remaining) {
      length = remaining
    }
  }

  var strLen = string.length

  if (length > strLen / 2) {
    length = strLen / 2
  }
  for (var i = 0; i < length; ++i) {
    var parsed = parseInt(string.substr(i * 2, 2), 16)
    if (numberIsNaN(parsed)) return i
    buf[offset + i] = parsed
  }
  return i
}

function utf8Write (buf, string, offset, length) {
  return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length)
}

function asciiWrite (buf, string, offset, length) {
  return blitBuffer(asciiToBytes(string), buf, offset, length)
}

function base64Write (buf, string, offset, length) {
  return blitBuffer(base64ToBytes(string), buf, offset, length)
}

function ucs2Write (buf, string, offset, length) {
  return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length)
}

Buffer.prototype.write = function write (string, offset, length, encoding) {
  // Buffer#write(string)
  if (offset === undefined) {
    encoding = 'utf8'
    length = this.length
    offset = 0
  // Buffer#write(string, encoding)
  } else if (length === undefined && typeof offset === 'string') {
    encoding = offset
    length = this.length
    offset = 0
  // Buffer#write(string, offset[, length][, encoding])
  } else if (isFinite(offset)) {
    offset = offset >>> 0
    if (isFinite(length)) {
      length = length >>> 0
      if (encoding === undefined) encoding = 'utf8'
    } else {
      encoding = length
      length = undefined
    }
  } else {
    throw new Error(
      'Buffer.write(string, encoding, offset[, length]) is no longer supported'
    )
  }

  var remaining = this.length - offset
  if (length === undefined || length > remaining) length = remaining

  if ((string.length > 0 && (length < 0 || offset < 0)) || offset > this.length) {
    throw new RangeError('Attempt to write outside buffer bounds')
  }

  if (!encoding) encoding = 'utf8'

  var loweredCase = false
  for (;;) {
    switch (encoding) {
      case 'hex':
        return hexWrite(this, string, offset, length)

      case 'utf8':
      case 'utf-8':
        return utf8Write(this, string, offset, length)

      case 'ascii':
      case 'latin1':
      case 'binary':
        return asciiWrite(this, string, offset, length)

      case 'base64':
        // Warning: maxLength not taken into account in base64Write
        return base64Write(this, string, offset, length)

      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return ucs2Write(this, string, offset, length)

      default:
        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
        encoding = ('' + encoding).toLowerCase()
        loweredCase = true
    }
  }
}

Buffer.prototype.toJSON = function toJSON () {
  return {
    type: 'Buffer',
    data: Array.prototype.slice.call(this._arr || this, 0)
  }
}

function base64Slice (buf, start, end) {
  if (start === 0 && end === buf.length) {
    return base64.fromByteArray(buf)
  } else {
    return base64.fromByteArray(buf.slice(start, end))
  }
}

function utf8Slice (buf, start, end) {
  end = Math.min(buf.length, end)
  var res = []

  var i = start
  while (i < end) {
    var firstByte = buf[i]
    var codePoint = null
    var bytesPerSequence = (firstByte > 0xEF)
      ? 4
      : (firstByte > 0xDF)
          ? 3
          : (firstByte > 0xBF)
              ? 2
              : 1

    if (i + bytesPerSequence <= end) {
      var secondByte, thirdByte, fourthByte, tempCodePoint

      switch (bytesPerSequence) {
        case 1:
          if (firstByte < 0x80) {
            codePoint = firstByte
          }
          break
        case 2:
          secondByte = buf[i + 1]
          if ((secondByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0x1F) << 0x6 | (secondByte & 0x3F)
            if (tempCodePoint > 0x7F) {
              codePoint = tempCodePoint
            }
          }
          break
        case 3:
          secondByte = buf[i + 1]
          thirdByte = buf[i + 2]
          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0xF) << 0xC | (secondByte & 0x3F) << 0x6 | (thirdByte & 0x3F)
            if (tempCodePoint > 0x7FF && (tempCodePoint < 0xD800 || tempCodePoint > 0xDFFF)) {
              codePoint = tempCodePoint
            }
          }
          break
        case 4:
          secondByte = buf[i + 1]
          thirdByte = buf[i + 2]
          fourthByte = buf[i + 3]
          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80 && (fourthByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0xF) << 0x12 | (secondByte & 0x3F) << 0xC | (thirdByte & 0x3F) << 0x6 | (fourthByte & 0x3F)
            if (tempCodePoint > 0xFFFF && tempCodePoint < 0x110000) {
              codePoint = tempCodePoint
            }
          }
      }
    }

    if (codePoint === null) {
      // we did not generate a valid codePoint so insert a
      // replacement char (U+FFFD) and advance only 1 byte
      codePoint = 0xFFFD
      bytesPerSequence = 1
    } else if (codePoint > 0xFFFF) {
      // encode to utf16 (surrogate pair dance)
      codePoint -= 0x10000
      res.push(codePoint >>> 10 & 0x3FF | 0xD800)
      codePoint = 0xDC00 | codePoint & 0x3FF
    }

    res.push(codePoint)
    i += bytesPerSequence
  }

  return decodeCodePointsArray(res)
}

// Based on http://stackoverflow.com/a/22747272/680742, the browser with
// the lowest limit is Chrome, with 0x10000 args.
// We go 1 magnitude less, for safety
var MAX_ARGUMENTS_LENGTH = 0x1000

function decodeCodePointsArray (codePoints) {
  var len = codePoints.length
  if (len <= MAX_ARGUMENTS_LENGTH) {
    return String.fromCharCode.apply(String, codePoints) // avoid extra slice()
  }

  // Decode in chunks to avoid "call stack size exceeded".
  var res = ''
  var i = 0
  while (i < len) {
    res += String.fromCharCode.apply(
      String,
      codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH)
    )
  }
  return res
}

function asciiSlice (buf, start, end) {
  var ret = ''
  end = Math.min(buf.length, end)

  for (var i = start; i < end; ++i) {
    ret += String.fromCharCode(buf[i] & 0x7F)
  }
  return ret
}

function latin1Slice (buf, start, end) {
  var ret = ''
  end = Math.min(buf.length, end)

  for (var i = start; i < end; ++i) {
    ret += String.fromCharCode(buf[i])
  }
  return ret
}

function hexSlice (buf, start, end) {
  var len = buf.length

  if (!start || start < 0) start = 0
  if (!end || end < 0 || end > len) end = len

  var out = ''
  for (var i = start; i < end; ++i) {
    out += hexSliceLookupTable[buf[i]]
  }
  return out
}

function utf16leSlice (buf, start, end) {
  var bytes = buf.slice(start, end)
  var res = ''
  // If bytes.length is odd, the last 8 bits must be ignored (same as node.js)
  for (var i = 0; i < bytes.length - 1; i += 2) {
    res += String.fromCharCode(bytes[i] + (bytes[i + 1] * 256))
  }
  return res
}

Buffer.prototype.slice = function slice (start, end) {
  var len = this.length
  start = ~~start
  end = end === undefined ? len : ~~end

  if (start < 0) {
    start += len
    if (start < 0) start = 0
  } else if (start > len) {
    start = len
  }

  if (end < 0) {
    end += len
    if (end < 0) end = 0
  } else if (end > len) {
    end = len
  }

  if (end < start) end = start

  var newBuf = this.subarray(start, end)
  // Return an augmented `Uint8Array` instance
  Object.setPrototypeOf(newBuf, Buffer.prototype)

  return newBuf
}

/*
 * Need to make sure that buffer isn't trying to write out of bounds.
 */
function checkOffset (offset, ext, length) {
  if ((offset % 1) !== 0 || offset < 0) throw new RangeError('offset is not uint')
  if (offset + ext > length) throw new RangeError('Trying to access beyond buffer length')
}

Buffer.prototype.readUintLE =
Buffer.prototype.readUIntLE = function readUIntLE (offset, byteLength, noAssert) {
  offset = offset >>> 0
  byteLength = byteLength >>> 0
  if (!noAssert) checkOffset(offset, byteLength, this.length)

  var val = this[offset]
  var mul = 1
  var i = 0
  while (++i < byteLength && (mul *= 0x100)) {
    val += this[offset + i] * mul
  }

  return val
}

Buffer.prototype.readUintBE =
Buffer.prototype.readUIntBE = function readUIntBE (offset, byteLength, noAssert) {
  offset = offset >>> 0
  byteLength = byteLength >>> 0
  if (!noAssert) {
    checkOffset(offset, byteLength, this.length)
  }

  var val = this[offset + --byteLength]
  var mul = 1
  while (byteLength > 0 && (mul *= 0x100)) {
    val += this[offset + --byteLength] * mul
  }

  return val
}

Buffer.prototype.readUint8 =
Buffer.prototype.readUInt8 = function readUInt8 (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 1, this.length)
  return this[offset]
}

Buffer.prototype.readUint16LE =
Buffer.prototype.readUInt16LE = function readUInt16LE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 2, this.length)
  return this[offset] | (this[offset + 1] << 8)
}

Buffer.prototype.readUint16BE =
Buffer.prototype.readUInt16BE = function readUInt16BE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 2, this.length)
  return (this[offset] << 8) | this[offset + 1]
}

Buffer.prototype.readUint32LE =
Buffer.prototype.readUInt32LE = function readUInt32LE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 4, this.length)

  return ((this[offset]) |
      (this[offset + 1] << 8) |
      (this[offset + 2] << 16)) +
      (this[offset + 3] * 0x1000000)
}

Buffer.prototype.readUint32BE =
Buffer.prototype.readUInt32BE = function readUInt32BE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 4, this.length)

  return (this[offset] * 0x1000000) +
    ((this[offset + 1] << 16) |
    (this[offset + 2] << 8) |
    this[offset + 3])
}

Buffer.prototype.readIntLE = function readIntLE (offset, byteLength, noAssert) {
  offset = offset >>> 0
  byteLength = byteLength >>> 0
  if (!noAssert) checkOffset(offset, byteLength, this.length)

  var val = this[offset]
  var mul = 1
  var i = 0
  while (++i < byteLength && (mul *= 0x100)) {
    val += this[offset + i] * mul
  }
  mul *= 0x80

  if (val >= mul) val -= Math.pow(2, 8 * byteLength)

  return val
}

Buffer.prototype.readIntBE = function readIntBE (offset, byteLength, noAssert) {
  offset = offset >>> 0
  byteLength = byteLength >>> 0
  if (!noAssert) checkOffset(offset, byteLength, this.length)

  var i = byteLength
  var mul = 1
  var val = this[offset + --i]
  while (i > 0 && (mul *= 0x100)) {
    val += this[offset + --i] * mul
  }
  mul *= 0x80

  if (val >= mul) val -= Math.pow(2, 8 * byteLength)

  return val
}

Buffer.prototype.readInt8 = function readInt8 (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 1, this.length)
  if (!(this[offset] & 0x80)) return (this[offset])
  return ((0xff - this[offset] + 1) * -1)
}

Buffer.prototype.readInt16LE = function readInt16LE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 2, this.length)
  var val = this[offset] | (this[offset + 1] << 8)
  return (val & 0x8000) ? val | 0xFFFF0000 : val
}

Buffer.prototype.readInt16BE = function readInt16BE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 2, this.length)
  var val = this[offset + 1] | (this[offset] << 8)
  return (val & 0x8000) ? val | 0xFFFF0000 : val
}

Buffer.prototype.readInt32LE = function readInt32LE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 4, this.length)

  return (this[offset]) |
    (this[offset + 1] << 8) |
    (this[offset + 2] << 16) |
    (this[offset + 3] << 24)
}

Buffer.prototype.readInt32BE = function readInt32BE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 4, this.length)

  return (this[offset] << 24) |
    (this[offset + 1] << 16) |
    (this[offset + 2] << 8) |
    (this[offset + 3])
}

Buffer.prototype.readFloatLE = function readFloatLE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 4, this.length)
  return ieee754.read(this, offset, true, 23, 4)
}

Buffer.prototype.readFloatBE = function readFloatBE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 4, this.length)
  return ieee754.read(this, offset, false, 23, 4)
}

Buffer.prototype.readDoubleLE = function readDoubleLE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 8, this.length)
  return ieee754.read(this, offset, true, 52, 8)
}

Buffer.prototype.readDoubleBE = function readDoubleBE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 8, this.length)
  return ieee754.read(this, offset, false, 52, 8)
}

function checkInt (buf, value, offset, ext, max, min) {
  if (!Buffer.isBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance')
  if (value > max || value < min) throw new RangeError('"value" argument is out of bounds')
  if (offset + ext > buf.length) throw new RangeError('Index out of range')
}

Buffer.prototype.writeUintLE =
Buffer.prototype.writeUIntLE = function writeUIntLE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset >>> 0
  byteLength = byteLength >>> 0
  if (!noAssert) {
    var maxBytes = Math.pow(2, 8 * byteLength) - 1
    checkInt(this, value, offset, byteLength, maxBytes, 0)
  }

  var mul = 1
  var i = 0
  this[offset] = value & 0xFF
  while (++i < byteLength && (mul *= 0x100)) {
    this[offset + i] = (value / mul) & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeUintBE =
Buffer.prototype.writeUIntBE = function writeUIntBE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset >>> 0
  byteLength = byteLength >>> 0
  if (!noAssert) {
    var maxBytes = Math.pow(2, 8 * byteLength) - 1
    checkInt(this, value, offset, byteLength, maxBytes, 0)
  }

  var i = byteLength - 1
  var mul = 1
  this[offset + i] = value & 0xFF
  while (--i >= 0 && (mul *= 0x100)) {
    this[offset + i] = (value / mul) & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeUint8 =
Buffer.prototype.writeUInt8 = function writeUInt8 (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 1, 0xff, 0)
  this[offset] = (value & 0xff)
  return offset + 1
}

Buffer.prototype.writeUint16LE =
Buffer.prototype.writeUInt16LE = function writeUInt16LE (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)
  this[offset] = (value & 0xff)
  this[offset + 1] = (value >>> 8)
  return offset + 2
}

Buffer.prototype.writeUint16BE =
Buffer.prototype.writeUInt16BE = function writeUInt16BE (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)
  this[offset] = (value >>> 8)
  this[offset + 1] = (value & 0xff)
  return offset + 2
}

Buffer.prototype.writeUint32LE =
Buffer.prototype.writeUInt32LE = function writeUInt32LE (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)
  this[offset + 3] = (value >>> 24)
  this[offset + 2] = (value >>> 16)
  this[offset + 1] = (value >>> 8)
  this[offset] = (value & 0xff)
  return offset + 4
}

Buffer.prototype.writeUint32BE =
Buffer.prototype.writeUInt32BE = function writeUInt32BE (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)
  this[offset] = (value >>> 24)
  this[offset + 1] = (value >>> 16)
  this[offset + 2] = (value >>> 8)
  this[offset + 3] = (value & 0xff)
  return offset + 4
}

Buffer.prototype.writeIntLE = function writeIntLE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) {
    var limit = Math.pow(2, (8 * byteLength) - 1)

    checkInt(this, value, offset, byteLength, limit - 1, -limit)
  }

  var i = 0
  var mul = 1
  var sub = 0
  this[offset] = value & 0xFF
  while (++i < byteLength && (mul *= 0x100)) {
    if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {
      sub = 1
    }
    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeIntBE = function writeIntBE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) {
    var limit = Math.pow(2, (8 * byteLength) - 1)

    checkInt(this, value, offset, byteLength, limit - 1, -limit)
  }

  var i = byteLength - 1
  var mul = 1
  var sub = 0
  this[offset + i] = value & 0xFF
  while (--i >= 0 && (mul *= 0x100)) {
    if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {
      sub = 1
    }
    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeInt8 = function writeInt8 (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 1, 0x7f, -0x80)
  if (value < 0) value = 0xff + value + 1
  this[offset] = (value & 0xff)
  return offset + 1
}

Buffer.prototype.writeInt16LE = function writeInt16LE (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)
  this[offset] = (value & 0xff)
  this[offset + 1] = (value >>> 8)
  return offset + 2
}

Buffer.prototype.writeInt16BE = function writeInt16BE (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)
  this[offset] = (value >>> 8)
  this[offset + 1] = (value & 0xff)
  return offset + 2
}

Buffer.prototype.writeInt32LE = function writeInt32LE (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)
  this[offset] = (value & 0xff)
  this[offset + 1] = (value >>> 8)
  this[offset + 2] = (value >>> 16)
  this[offset + 3] = (value >>> 24)
  return offset + 4
}

Buffer.prototype.writeInt32BE = function writeInt32BE (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)
  if (value < 0) value = 0xffffffff + value + 1
  this[offset] = (value >>> 24)
  this[offset + 1] = (value >>> 16)
  this[offset + 2] = (value >>> 8)
  this[offset + 3] = (value & 0xff)
  return offset + 4
}

function checkIEEE754 (buf, value, offset, ext, max, min) {
  if (offset + ext > buf.length) throw new RangeError('Index out of range')
  if (offset < 0) throw new RangeError('Index out of range')
}

function writeFloat (buf, value, offset, littleEndian, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) {
    checkIEEE754(buf, value, offset, 4, 3.4028234663852886e+38, -3.4028234663852886e+38)
  }
  ieee754.write(buf, value, offset, littleEndian, 23, 4)
  return offset + 4
}

Buffer.prototype.writeFloatLE = function writeFloatLE (value, offset, noAssert) {
  return writeFloat(this, value, offset, true, noAssert)
}

Buffer.prototype.writeFloatBE = function writeFloatBE (value, offset, noAssert) {
  return writeFloat(this, value, offset, false, noAssert)
}

function writeDouble (buf, value, offset, littleEndian, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) {
    checkIEEE754(buf, value, offset, 8, 1.7976931348623157E+308, -1.7976931348623157E+308)
  }
  ieee754.write(buf, value, offset, littleEndian, 52, 8)
  return offset + 8
}

Buffer.prototype.writeDoubleLE = function writeDoubleLE (value, offset, noAssert) {
  return writeDouble(this, value, offset, true, noAssert)
}

Buffer.prototype.writeDoubleBE = function writeDoubleBE (value, offset, noAssert) {
  return writeDouble(this, value, offset, false, noAssert)
}

// copy(targetBuffer, targetStart=0, sourceStart=0, sourceEnd=buffer.length)
Buffer.prototype.copy = function copy (target, targetStart, start, end) {
  if (!Buffer.isBuffer(target)) throw new TypeError('argument should be a Buffer')
  if (!start) start = 0
  if (!end && end !== 0) end = this.length
  if (targetStart >= target.length) targetStart = target.length
  if (!targetStart) targetStart = 0
  if (end > 0 && end < start) end = start

  // Copy 0 bytes; we're done
  if (end === start) return 0
  if (target.length === 0 || this.length === 0) return 0

  // Fatal error conditions
  if (targetStart < 0) {
    throw new RangeError('targetStart out of bounds')
  }
  if (start < 0 || start >= this.length) throw new RangeError('Index out of range')
  if (end < 0) throw new RangeError('sourceEnd out of bounds')

  // Are we oob?
  if (end > this.length) end = this.length
  if (target.length - targetStart < end - start) {
    end = target.length - targetStart + start
  }

  var len = end - start

  if (this === target && typeof Uint8Array.prototype.copyWithin === 'function') {
    // Use built-in when available, missing from IE11
    this.copyWithin(targetStart, start, end)
  } else {
    Uint8Array.prototype.set.call(
      target,
      this.subarray(start, end),
      targetStart
    )
  }

  return len
}

// Usage:
//    buffer.fill(number[, offset[, end]])
//    buffer.fill(buffer[, offset[, end]])
//    buffer.fill(string[, offset[, end]][, encoding])
Buffer.prototype.fill = function fill (val, start, end, encoding) {
  // Handle string cases:
  if (typeof val === 'string') {
    if (typeof start === 'string') {
      encoding = start
      start = 0
      end = this.length
    } else if (typeof end === 'string') {
      encoding = end
      end = this.length
    }
    if (encoding !== undefined && typeof encoding !== 'string') {
      throw new TypeError('encoding must be a string')
    }
    if (typeof encoding === 'string' && !Buffer.isEncoding(encoding)) {
      throw new TypeError('Unknown encoding: ' + encoding)
    }
    if (val.length === 1) {
      var code = val.charCodeAt(0)
      if ((encoding === 'utf8' && code < 128) ||
          encoding === 'latin1') {
        // Fast path: If `val` fits into a single byte, use that numeric value.
        val = code
      }
    }
  } else if (typeof val === 'number') {
    val = val & 255
  } else if (typeof val === 'boolean') {
    val = Number(val)
  }

  // Invalid ranges are not set to a default, so can range check early.
  if (start < 0 || this.length < start || this.length < end) {
    throw new RangeError('Out of range index')
  }

  if (end <= start) {
    return this
  }

  start = start >>> 0
  end = end === undefined ? this.length : end >>> 0

  if (!val) val = 0

  var i
  if (typeof val === 'number') {
    for (i = start; i < end; ++i) {
      this[i] = val
    }
  } else {
    var bytes = Buffer.isBuffer(val)
      ? val
      : Buffer.from(val, encoding)
    var len = bytes.length
    if (len === 0) {
      throw new TypeError('The value "' + val +
        '" is invalid for argument "value"')
    }
    for (i = 0; i < end - start; ++i) {
      this[i + start] = bytes[i % len]
    }
  }

  return this
}

// HELPER FUNCTIONS
// ================

var INVALID_BASE64_RE = /[^+/0-9A-Za-z-_]/g

function base64clean (str) {
  // Node takes equal signs as end of the Base64 encoding
  str = str.split('=')[0]
  // Node strips out invalid characters like \n and \t from the string, base64-js does not
  str = str.trim().replace(INVALID_BASE64_RE, '')
  // Node converts strings with length < 2 to ''
  if (str.length < 2) return ''
  // Node allows for non-padded base64 strings (missing trailing ===), base64-js does not
  while (str.length % 4 !== 0) {
    str = str + '='
  }
  return str
}

function utf8ToBytes (string, units) {
  units = units || Infinity
  var codePoint
  var length = string.length
  var leadSurrogate = null
  var bytes = []

  for (var i = 0; i < length; ++i) {
    codePoint = string.charCodeAt(i)

    // is surrogate component
    if (codePoint > 0xD7FF && codePoint < 0xE000) {
      // last char was a lead
      if (!leadSurrogate) {
        // no lead yet
        if (codePoint > 0xDBFF) {
          // unexpected trail
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
          continue
        } else if (i + 1 === length) {
          // unpaired lead
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
          continue
        }

        // valid lead
        leadSurrogate = codePoint

        continue
      }

      // 2 leads in a row
      if (codePoint < 0xDC00) {
        if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
        leadSurrogate = codePoint
        continue
      }

      // valid surrogate pair
      codePoint = (leadSurrogate - 0xD800 << 10 | codePoint - 0xDC00) + 0x10000
    } else if (leadSurrogate) {
      // valid bmp char, but last char was a lead
      if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
    }

    leadSurrogate = null

    // encode utf8
    if (codePoint < 0x80) {
      if ((units -= 1) < 0) break
      bytes.push(codePoint)
    } else if (codePoint < 0x800) {
      if ((units -= 2) < 0) break
      bytes.push(
        codePoint >> 0x6 | 0xC0,
        codePoint & 0x3F | 0x80
      )
    } else if (codePoint < 0x10000) {
      if ((units -= 3) < 0) break
      bytes.push(
        codePoint >> 0xC | 0xE0,
        codePoint >> 0x6 & 0x3F | 0x80,
        codePoint & 0x3F | 0x80
      )
    } else if (codePoint < 0x110000) {
      if ((units -= 4) < 0) break
      bytes.push(
        codePoint >> 0x12 | 0xF0,
        codePoint >> 0xC & 0x3F | 0x80,
        codePoint >> 0x6 & 0x3F | 0x80,
        codePoint & 0x3F | 0x80
      )
    } else {
      throw new Error('Invalid code point')
    }
  }

  return bytes
}

function asciiToBytes (str) {
  var byteArray = []
  for (var i = 0; i < str.length; ++i) {
    // Node's code seems to be doing this and not & 0x7F..
    byteArray.push(str.charCodeAt(i) & 0xFF)
  }
  return byteArray
}

function utf16leToBytes (str, units) {
  var c, hi, lo
  var byteArray = []
  for (var i = 0; i < str.length; ++i) {
    if ((units -= 2) < 0) break

    c = str.charCodeAt(i)
    hi = c >> 8
    lo = c % 256
    byteArray.push(lo)
    byteArray.push(hi)
  }

  return byteArray
}

function base64ToBytes (str) {
  return base64.toByteArray(base64clean(str))
}

function blitBuffer (src, dst, offset, length) {
  for (var i = 0; i < length; ++i) {
    if ((i + offset >= dst.length) || (i >= src.length)) break
    dst[i + offset] = src[i]
  }
  return i
}

// ArrayBuffer or Uint8Array objects from other contexts (i.e. iframes) do not pass
// the `instanceof` check but they should be treated as of that type.
// See: https://github.com/feross/buffer/issues/166
function isInstance (obj, type) {
  return obj instanceof type ||
    (obj != null && obj.constructor != null && obj.constructor.name != null &&
      obj.constructor.name === type.name)
}
function numberIsNaN (obj) {
  // For IE11 support
  return obj !== obj // eslint-disable-line no-self-compare
}

// Create lookup table for `toString('hex')`
// See: https://github.com/feross/buffer/issues/219
var hexSliceLookupTable = (function () {
  var alphabet = '0123456789abcdef'
  var table = new Array(256)
  for (var i = 0; i < 16; ++i) {
    var i16 = i * 16
    for (var j = 0; j < 16; ++j) {
      table[i16 + j] = alphabet[i] + alphabet[j]
    }
  }
  return table
})()

      };
    };
  }
  }
}, {package:"remote-redux-devtools>socketcluster-client>buffer",file:"node_modules\\socketcluster-client\\node_modules\\buffer\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\socketcluster-client\\node_modules\\clone\\clone.js", {"buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Csocketcluster-client%5Cnode_modules%5Cclone%5Cclone.js
      return function (require, module, exports) {
(function (Buffer){(function (){
var clone = (function() {
'use strict';

function _instanceof(obj, type) {
  return type != null && obj instanceof type;
}

var nativeMap;
try {
  nativeMap = Map;
} catch(_) {
  // maybe a reference error because no `Map`. Give it a dummy value that no
  // value will ever be an instanceof.
  nativeMap = function() {};
}

var nativeSet;
try {
  nativeSet = Set;
} catch(_) {
  nativeSet = function() {};
}

var nativePromise;
try {
  nativePromise = Promise;
} catch(_) {
  nativePromise = function() {};
}

/**
 * Clones (copies) an Object using deep copying.
 *
 * This function supports circular references by default, but if you are certain
 * there are no circular references in your object, you can save some CPU time
 * by calling clone(obj, false).
 *
 * Caution: if `circular` is false and `parent` contains circular references,
 * your program may enter an infinite loop and crash.
 *
 * @param `parent` - the object to be cloned
 * @param `circular` - set to true if the object to be cloned may contain
 *    circular references. (optional - true by default)
 * @param `depth` - set to a number if the object is only to be cloned to
 *    a particular depth. (optional - defaults to Infinity)
 * @param `prototype` - sets the prototype to be used when cloning an object.
 *    (optional - defaults to parent prototype).
 * @param `includeNonEnumerable` - set to true if the non-enumerable properties
 *    should be cloned as well. Non-enumerable properties on the prototype
 *    chain will be ignored. (optional - false by default)
*/
function clone(parent, circular, depth, prototype, includeNonEnumerable) {
  if (typeof circular === 'object') {
    depth = circular.depth;
    prototype = circular.prototype;
    includeNonEnumerable = circular.includeNonEnumerable;
    circular = circular.circular;
  }
  // maintain two arrays for circular references, where corresponding parents
  // and children have the same index
  var allParents = [];
  var allChildren = [];

  var useBuffer = typeof Buffer != 'undefined';

  if (typeof circular == 'undefined')
    circular = true;

  if (typeof depth == 'undefined')
    depth = Infinity;

  // recurse this function so we don't reset allParents and allChildren
  function _clone(parent, depth) {
    // cloning null always returns null
    if (parent === null)
      return null;

    if (depth === 0)
      return parent;

    var child;
    var proto;
    if (typeof parent != 'object') {
      return parent;
    }

    if (_instanceof(parent, nativeMap)) {
      child = new nativeMap();
    } else if (_instanceof(parent, nativeSet)) {
      child = new nativeSet();
    } else if (_instanceof(parent, nativePromise)) {
      child = new nativePromise(function (resolve, reject) {
        parent.then(function(value) {
          resolve(_clone(value, depth - 1));
        }, function(err) {
          reject(_clone(err, depth - 1));
        });
      });
    } else if (clone.__isArray(parent)) {
      child = [];
    } else if (clone.__isRegExp(parent)) {
      child = new RegExp(parent.source, __getRegExpFlags(parent));
      if (parent.lastIndex) child.lastIndex = parent.lastIndex;
    } else if (clone.__isDate(parent)) {
      child = new Date(parent.getTime());
    } else if (useBuffer && Buffer.isBuffer(parent)) {
      child = new Buffer(parent.length);
      parent.copy(child);
      return child;
    } else if (_instanceof(parent, Error)) {
      child = Object.create(parent);
    } else {
      if (typeof prototype == 'undefined') {
        proto = Object.getPrototypeOf(parent);
        child = Object.create(proto);
      }
      else {
        child = Object.create(prototype);
        proto = prototype;
      }
    }

    if (circular) {
      var index = allParents.indexOf(parent);

      if (index != -1) {
        return allChildren[index];
      }
      allParents.push(parent);
      allChildren.push(child);
    }

    if (_instanceof(parent, nativeMap)) {
      parent.forEach(function(value, key) {
        var keyChild = _clone(key, depth - 1);
        var valueChild = _clone(value, depth - 1);
        child.set(keyChild, valueChild);
      });
    }
    if (_instanceof(parent, nativeSet)) {
      parent.forEach(function(value) {
        var entryChild = _clone(value, depth - 1);
        child.add(entryChild);
      });
    }

    for (var i in parent) {
      var attrs;
      if (proto) {
        attrs = Object.getOwnPropertyDescriptor(proto, i);
      }

      if (attrs && attrs.set == null) {
        continue;
      }
      child[i] = _clone(parent[i], depth - 1);
    }

    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(parent);
      for (var i = 0; i < symbols.length; i++) {
        // Don't need to worry about cloning a symbol because it is a primitive,
        // like a number or string.
        var symbol = symbols[i];
        var descriptor = Object.getOwnPropertyDescriptor(parent, symbol);
        if (descriptor && !descriptor.enumerable && !includeNonEnumerable) {
          continue;
        }
        child[symbol] = _clone(parent[symbol], depth - 1);
        if (!descriptor.enumerable) {
          Object.defineProperty(child, symbol, {
            enumerable: false
          });
        }
      }
    }

    if (includeNonEnumerable) {
      var allPropertyNames = Object.getOwnPropertyNames(parent);
      for (var i = 0; i < allPropertyNames.length; i++) {
        var propertyName = allPropertyNames[i];
        var descriptor = Object.getOwnPropertyDescriptor(parent, propertyName);
        if (descriptor && descriptor.enumerable) {
          continue;
        }
        child[propertyName] = _clone(parent[propertyName], depth - 1);
        Object.defineProperty(child, propertyName, {
          enumerable: false
        });
      }
    }

    return child;
  }

  return _clone(parent, depth);
}

/**
 * Simple flat clone using prototype, accepts only objects, usefull for property
 * override on FLAT configuration object (no nested props).
 *
 * USE WITH CAUTION! This may not behave as you wish if you do not know how this
 * works.
 */
clone.clonePrototype = function clonePrototype(parent) {
  if (parent === null)
    return null;

  var c = function () {};
  c.prototype = parent;
  return new c();
};

// private utility functions

function __objToStr(o) {
  return Object.prototype.toString.call(o);
}
clone.__objToStr = __objToStr;

function __isDate(o) {
  return typeof o === 'object' && __objToStr(o) === '[object Date]';
}
clone.__isDate = __isDate;

function __isArray(o) {
  return typeof o === 'object' && __objToStr(o) === '[object Array]';
}
clone.__isArray = __isArray;

function __isRegExp(o) {
  return typeof o === 'object' && __objToStr(o) === '[object RegExp]';
}
clone.__isRegExp = __isRegExp;

function __getRegExpFlags(re) {
  var flags = '';
  if (re.global) flags += 'g';
  if (re.ignoreCase) flags += 'i';
  if (re.multiline) flags += 'm';
  return flags;
}
clone.__getRegExpFlags = __getRegExpFlags;

return clone;
})();

if (typeof module === 'object' && module.exports) {
  module.exports = clone;
}

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"remote-redux-devtools>socketcluster-client>clone",file:"node_modules\\socketcluster-client\\node_modules\\clone\\clone.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\socketcluster-client\\node_modules\\component-emitter\\index.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Csocketcluster-client%5Cnode_modules%5Ccomponent-emitter%5Cindex.js
      return function (require, module, exports) {

/**
 * Expose `Emitter`.
 */

if (typeof module !== 'undefined') {
  module.exports = Emitter;
}

/**
 * Initialize a new `Emitter`.
 *
 * @api public
 */

function Emitter(obj) {
  if (obj) return mixin(obj);
};

/**
 * Mixin the emitter properties.
 *
 * @param {Object} obj
 * @return {Object}
 * @api private
 */

function mixin(obj) {
  for (var key in Emitter.prototype) {
    obj[key] = Emitter.prototype[key];
  }
  return obj;
}

/**
 * Listen on the given `event` with `fn`.
 *
 * @param {String} event
 * @param {Function} fn
 * @return {Emitter}
 * @api public
 */

Emitter.prototype.on =
Emitter.prototype.addEventListener = function(event, fn){
  this._callbacks = this._callbacks || {};
  (this._callbacks['$' + event] = this._callbacks['$' + event] || [])
    .push(fn);
  return this;
};

/**
 * Adds an `event` listener that will be invoked a single
 * time then automatically removed.
 *
 * @param {String} event
 * @param {Function} fn
 * @return {Emitter}
 * @api public
 */

Emitter.prototype.once = function(event, fn){
  function on() {
    this.off(event, on);
    fn.apply(this, arguments);
  }

  on.fn = fn;
  this.on(event, on);
  return this;
};

/**
 * Remove the given callback for `event` or all
 * registered callbacks.
 *
 * @param {String} event
 * @param {Function} fn
 * @return {Emitter}
 * @api public
 */

Emitter.prototype.off =
Emitter.prototype.removeListener =
Emitter.prototype.removeAllListeners =
Emitter.prototype.removeEventListener = function(event, fn){
  this._callbacks = this._callbacks || {};

  // all
  if (0 == arguments.length) {
    this._callbacks = {};
    return this;
  }

  // specific event
  var callbacks = this._callbacks['$' + event];
  if (!callbacks) return this;

  // remove all handlers
  if (1 == arguments.length) {
    delete this._callbacks['$' + event];
    return this;
  }

  // remove specific handler
  var cb;
  for (var i = 0; i < callbacks.length; i++) {
    cb = callbacks[i];
    if (cb === fn || cb.fn === fn) {
      callbacks.splice(i, 1);
      break;
    }
  }
  return this;
};

/**
 * Emit `event` with the given args.
 *
 * @param {String} event
 * @param {Mixed} ...
 * @return {Emitter}
 */

Emitter.prototype.emit = function(event){
  this._callbacks = this._callbacks || {};
  var args = [].slice.call(arguments, 1)
    , callbacks = this._callbacks['$' + event];

  if (callbacks) {
    callbacks = callbacks.slice(0);
    for (var i = 0, len = callbacks.length; i < len; ++i) {
      callbacks[i].apply(this, args);
    }
  }

  return this;
};

/**
 * Return array of callbacks for `event`.
 *
 * @param {String} event
 * @return {Array}
 * @api public
 */

Emitter.prototype.listeners = function(event){
  this._callbacks = this._callbacks || {};
  return this._callbacks['$' + event] || [];
};

/**
 * Check if this emitter has `event` handlers.
 *
 * @param {String} event
 * @return {Boolean}
 * @api public
 */

Emitter.prototype.hasListeners = function(event){
  return !! this.listeners(event).length;
};

      };
    };
  }
  }
}, {package:"remote-redux-devtools>socketcluster-client>component-emitter",file:"node_modules\\socketcluster-client\\node_modules\\component-emitter\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\socketcluster-client\\node_modules\\uuid\\index.js", {"./v1":"D:\\code\\v\\metamask-extension\\node_modules\\socketcluster-client\\node_modules\\uuid\\v1.js","./v4":"D:\\code\\v\\metamask-extension\\node_modules\\socketcluster-client\\node_modules\\uuid\\v4.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Csocketcluster-client%5Cnode_modules%5Cuuid%5Cindex.js
      return function (require, module, exports) {
var v1 = require('./v1');
var v4 = require('./v4');

var uuid = v4;
uuid.v1 = v1;
uuid.v4 = v4;

module.exports = uuid;

      };
    };
  }
  }
}, {package:"remote-redux-devtools>socketcluster-client>uuid",file:"node_modules\\socketcluster-client\\node_modules\\uuid\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\socketcluster-client\\node_modules\\uuid\\lib\\bytesToUuid.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Csocketcluster-client%5Cnode_modules%5Cuuid%5Clib%5CbytesToUuid.js
      return function (require, module, exports) {
/**
 * Convert array of 16 byte values to UUID string format of the form:
 * XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX
 */
var byteToHex = [];
for (var i = 0; i < 256; ++i) {
  byteToHex[i] = (i + 0x100).toString(16).substr(1);
}

function bytesToUuid(buf, offset) {
  var i = offset || 0;
  var bth = byteToHex;
  return bth[buf[i++]] + bth[buf[i++]] +
          bth[buf[i++]] + bth[buf[i++]] + '-' +
          bth[buf[i++]] + bth[buf[i++]] + '-' +
          bth[buf[i++]] + bth[buf[i++]] + '-' +
          bth[buf[i++]] + bth[buf[i++]] + '-' +
          bth[buf[i++]] + bth[buf[i++]] +
          bth[buf[i++]] + bth[buf[i++]] +
          bth[buf[i++]] + bth[buf[i++]];
}

module.exports = bytesToUuid;

      };
    };
  }
  }
}, {package:"remote-redux-devtools>socketcluster-client>uuid",file:"node_modules\\socketcluster-client\\node_modules\\uuid\\lib\\bytesToUuid.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\socketcluster-client\\node_modules\\uuid\\lib\\rng-browser.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Csocketcluster-client%5Cnode_modules%5Cuuid%5Clib%5Crng-browser.js
      return function (require, module, exports) {
// Unique ID creation requires a high quality random # generator.  In the
// browser this is a little complicated due to unknown quality of Math.random()
// and inconsistent support for the `crypto` API.  We do the best we can via
// feature-detection

// getRandomValues needs to be invoked in a context where "this" is a Crypto implementation.
var getRandomValues = (typeof(crypto) != 'undefined' && crypto.getRandomValues.bind(crypto)) ||
                      (typeof(msCrypto) != 'undefined' && msCrypto.getRandomValues.bind(msCrypto));
if (getRandomValues) {
  // WHATWG crypto RNG - http://wiki.whatwg.org/wiki/Crypto
  var rnds8 = new Uint8Array(16); // eslint-disable-line no-undef

  module.exports = function whatwgRNG() {
    getRandomValues(rnds8);
    return rnds8;
  };
} else {
  // Math.random()-based (RNG)
  //
  // If all else fails, use Math.random().  It's fast, but is of unspecified
  // quality.
  var rnds = new Array(16);

  module.exports = function mathRNG() {
    for (var i = 0, r; i < 16; i++) {
      if ((i & 0x03) === 0) r = Math.random() * 0x100000000;
      rnds[i] = r >>> ((i & 0x03) << 3) & 0xff;
    }

    return rnds;
  };
}

      };
    };
  }
  }
}, {package:"remote-redux-devtools>socketcluster-client>uuid",file:"node_modules\\socketcluster-client\\node_modules\\uuid\\lib\\rng-browser.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\socketcluster-client\\node_modules\\uuid\\v1.js", {"./lib/bytesToUuid":"D:\\code\\v\\metamask-extension\\node_modules\\socketcluster-client\\node_modules\\uuid\\lib\\bytesToUuid.js","./lib/rng":"D:\\code\\v\\metamask-extension\\node_modules\\socketcluster-client\\node_modules\\uuid\\lib\\rng-browser.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Csocketcluster-client%5Cnode_modules%5Cuuid%5Cv1.js
      return function (require, module, exports) {
var rng = require('./lib/rng');
var bytesToUuid = require('./lib/bytesToUuid');

// **`v1()` - Generate time-based UUID**
//
// Inspired by https://github.com/LiosK/UUID.js
// and http://docs.python.org/library/uuid.html

var _nodeId;
var _clockseq;

// Previous uuid creation time
var _lastMSecs = 0;
var _lastNSecs = 0;

// See https://github.com/broofa/node-uuid for API details
function v1(options, buf, offset) {
  var i = buf && offset || 0;
  var b = buf || [];

  options = options || {};
  var node = options.node || _nodeId;
  var clockseq = options.clockseq !== undefined ? options.clockseq : _clockseq;

  // node and clockseq need to be initialized to random values if they're not
  // specified.  We do this lazily to minimize issues related to insufficient
  // system entropy.  See #189
  if (node == null || clockseq == null) {
    var seedBytes = rng();
    if (node == null) {
      // Per 4.5, create and 48-bit node id, (47 random bits + multicast bit = 1)
      node = _nodeId = [
        seedBytes[0] | 0x01,
        seedBytes[1], seedBytes[2], seedBytes[3], seedBytes[4], seedBytes[5]
      ];
    }
    if (clockseq == null) {
      // Per 4.2.2, randomize (14 bit) clockseq
      clockseq = _clockseq = (seedBytes[6] << 8 | seedBytes[7]) & 0x3fff;
    }
  }

  // UUID timestamps are 100 nano-second units since the Gregorian epoch,
  // (1582-10-15 00:00).  JSNumbers aren't precise enough for this, so
  // time is handled internally as 'msecs' (integer milliseconds) and 'nsecs'
  // (100-nanoseconds offset from msecs) since unix epoch, 1970-01-01 00:00.
  var msecs = options.msecs !== undefined ? options.msecs : new Date().getTime();

  // Per 4.2.1.2, use count of uuid's generated during the current clock
  // cycle to simulate higher resolution clock
  var nsecs = options.nsecs !== undefined ? options.nsecs : _lastNSecs + 1;

  // Time since last uuid creation (in msecs)
  var dt = (msecs - _lastMSecs) + (nsecs - _lastNSecs)/10000;

  // Per 4.2.1.2, Bump clockseq on clock regression
  if (dt < 0 && options.clockseq === undefined) {
    clockseq = clockseq + 1 & 0x3fff;
  }

  // Reset nsecs if clock regresses (new clockseq) or we've moved onto a new
  // time interval
  if ((dt < 0 || msecs > _lastMSecs) && options.nsecs === undefined) {
    nsecs = 0;
  }

  // Per 4.2.1.2 Throw error if too many uuids are requested
  if (nsecs >= 10000) {
    throw new Error('uuid.v1(): Can\'t create more than 10M uuids/sec');
  }

  _lastMSecs = msecs;
  _lastNSecs = nsecs;
  _clockseq = clockseq;

  // Per 4.1.4 - Convert from unix epoch to Gregorian epoch
  msecs += 12219292800000;

  // `time_low`
  var tl = ((msecs & 0xfffffff) * 10000 + nsecs) % 0x100000000;
  b[i++] = tl >>> 24 & 0xff;
  b[i++] = tl >>> 16 & 0xff;
  b[i++] = tl >>> 8 & 0xff;
  b[i++] = tl & 0xff;

  // `time_mid`
  var tmh = (msecs / 0x100000000 * 10000) & 0xfffffff;
  b[i++] = tmh >>> 8 & 0xff;
  b[i++] = tmh & 0xff;

  // `time_high_and_version`
  b[i++] = tmh >>> 24 & 0xf | 0x10; // include version
  b[i++] = tmh >>> 16 & 0xff;

  // `clock_seq_hi_and_reserved` (Per 4.2.2 - include variant)
  b[i++] = clockseq >>> 8 | 0x80;

  // `clock_seq_low`
  b[i++] = clockseq & 0xff;

  // `node`
  for (var n = 0; n < 6; ++n) {
    b[i + n] = node[n];
  }

  return buf ? buf : bytesToUuid(b);
}

module.exports = v1;

      };
    };
  }
  }
}, {package:"remote-redux-devtools>socketcluster-client>uuid",file:"node_modules\\socketcluster-client\\node_modules\\uuid\\v1.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\socketcluster-client\\node_modules\\uuid\\v4.js", {"./lib/bytesToUuid":"D:\\code\\v\\metamask-extension\\node_modules\\socketcluster-client\\node_modules\\uuid\\lib\\bytesToUuid.js","./lib/rng":"D:\\code\\v\\metamask-extension\\node_modules\\socketcluster-client\\node_modules\\uuid\\lib\\rng-browser.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Csocketcluster-client%5Cnode_modules%5Cuuid%5Cv4.js
      return function (require, module, exports) {
var rng = require('./lib/rng');
var bytesToUuid = require('./lib/bytesToUuid');

function v4(options, buf, offset) {
  var i = buf && offset || 0;

  if (typeof(options) == 'string') {
    buf = options === 'binary' ? new Array(16) : null;
    options = null;
  }
  options = options || {};

  var rnds = options.random || (options.rng || rng)();

  // Per 4.4, set bits for version and `clock_seq_hi_and_reserved`
  rnds[6] = (rnds[6] & 0x0f) | 0x40;
  rnds[8] = (rnds[8] & 0x3f) | 0x80;

  // Copy bytes to buffer, if provided
  if (buf) {
    for (var ii = 0; ii < 16; ++ii) {
      buf[i + ii] = rnds[ii];
    }
  }

  return buf || bytesToUuid(rnds);
}

module.exports = v4;

      };
    };
  }
  }
}, {package:"remote-redux-devtools>socketcluster-client>uuid",file:"node_modules\\socketcluster-client\\node_modules\\uuid\\v4.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\space-separated-tokens\\index.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cspace-separated-tokens%5Cindex.js
      return function (require, module, exports) {
'use strict'

exports.parse = parse
exports.stringify = stringify

var empty = ''
var space = ' '
var whiteSpace = /[ \t\n\r\f]+/g

function parse(value) {
  var input = String(value || empty).trim()
  return input === empty ? [] : input.split(whiteSpace)
}

function stringify(values) {
  return values.join(space).trim()
}

      };
    };
  }
  }
}, {package:"react-markdown>space-separated-tokens",file:"node_modules\\space-separated-tokens\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\stop-iteration-iterator\\index.js", {"internal-slot":"D:\\code\\v\\metamask-extension\\node_modules\\internal-slot\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cstop-iteration-iterator%5Cindex.js
      return function (require, module, exports) {
'use strict';

var SLOT = require('internal-slot');

var $SyntaxError = SyntaxError;
var $StopIteration = typeof StopIteration === 'object' ? StopIteration : null;

module.exports = function getStopIterationIterator(origIterator) {
	if (!$StopIteration) {
		throw new $SyntaxError('this environment lacks StopIteration');
	}

	SLOT.set(origIterator, '[[Done]]', false);

	var siIterator = {
		next: function next() {
			var iterator = SLOT.get(this, '[[Iterator]]');
			var done = SLOT.get(iterator, '[[Done]]');
			try {
				return {
					done: done,
					value: done ? void undefined : iterator.next()
				};
			} catch (e) {
				SLOT.set(iterator, '[[Done]]', true);
				if (e !== $StopIteration) {
					throw e;
				}
				return {
					done: true,
					value: void undefined
				};
			}
		}
	};

	SLOT.set(siIterator, '[[Iterator]]', origIterator);

	return siIterator;
};

      };
    };
  }
  }
}, {package:"@metamask/eth-token-tracker>deep-equal>es-get-iterator>stop-iteration-iterator",file:"node_modules\\stop-iteration-iterator\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\style-to-object\\index.js", {"inline-style-parser":"D:\\code\\v\\metamask-extension\\node_modules\\inline-style-parser\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cstyle-to-object%5Cindex.js
      return function (require, module, exports) {
var parse = require('inline-style-parser');

/**
 * Parses inline style to object.
 *
 * @example
 * // returns { 'line-height': '42' }
 * StyleToObject('line-height: 42;');
 *
 * @param  {String}      style      - The inline style.
 * @param  {Function}    [iterator] - The iterator function.
 * @return {null|Object}
 */
function StyleToObject(style, iterator) {
  var output = null;
  if (!style || typeof style !== 'string') {
    return output;
  }

  var declaration;
  var declarations = parse(style);
  var hasIterator = typeof iterator === 'function';
  var property;
  var value;

  for (var i = 0, len = declarations.length; i < len; i++) {
    declaration = declarations[i];
    property = declaration.property;
    value = declaration.value;

    if (hasIterator) {
      iterator(property, value, declaration);
    } else if (value) {
      output || (output = {});
      output[property] = value;
    }
  }

  return output;
}

module.exports = StyleToObject;

      };
    };
  }
  }
}, {package:"react-markdown>style-to-object",file:"node_modules\\style-to-object\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\symbol-observable\\lib\\index.js", {"./ponyfill.js":"D:\\code\\v\\metamask-extension\\node_modules\\symbol-observable\\lib\\ponyfill.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Csymbol-observable%5Clib%5Cindex.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _ponyfill = require('./ponyfill.js');

var _ponyfill2 = _interopRequireDefault(_ponyfill);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var root; /* global window */


if (typeof self !== 'undefined') {
  root = self;
} else if (typeof window !== 'undefined') {
  root = window;
} else if (typeof global !== 'undefined') {
  root = global;
} else if (typeof module !== 'undefined') {
  root = module;
} else {
  root = Function('return this')();
}

var result = (0, _ponyfill2['default'])(root);
exports['default'] = result;
      };
    };
  }
  }
}, {package:"mockttp>@httptoolkit/subscriptions-transport-ws>symbol-observable",file:"node_modules\\symbol-observable\\lib\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\symbol-observable\\lib\\ponyfill.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Csymbol-observable%5Clib%5Cponyfill.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, "__esModule", {
	value: true
});
exports['default'] = symbolObservablePonyfill;
function symbolObservablePonyfill(root) {
	var result;
	var _Symbol = root.Symbol;

	if (typeof _Symbol === 'function') {
		if (_Symbol.observable) {
			result = _Symbol.observable;
		} else {

			// This just needs to be something that won't trample other user's Symbol.for use
			// It also will guide people to the source of their issues, if this is problematic.
			// META: It's a resource locator!
			result = _Symbol['for']('https://github.com/benlesh/symbol-observable');
			try {
				_Symbol.observable = result;
			} catch (err) {
				// Do nothing. In some environments, users have frozen `Symbol` for security reasons,
				// if it is frozen assigning to it will throw. In this case, we don't care, because
				// they will need to use the returned value from the ponyfill.
			}
		}
	} else {
		result = '@@observable';
	}

	return result;
};
      };
    };
  }
  }
}, {package:"mockttp>@httptoolkit/subscriptions-transport-ws>symbol-observable",file:"node_modules\\symbol-observable\\lib\\ponyfill.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\tiny-invariant\\dist\\tiny-invariant.cjs.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Ctiny-invariant%5Cdist%5Ctiny-invariant.cjs.js
      return function (require, module, exports) {
'use strict';

var isProduction = "development" === 'production';
var prefix = 'Invariant failed';
function invariant(condition, message) {
    if (condition) {
        return;
    }
    if (isProduction) {
        throw new Error(prefix);
    }
    var provided = typeof message === 'function' ? message() : message;
    var value = provided ? "".concat(prefix, ": ").concat(provided) : prefix;
    throw new Error(value);
}

module.exports = invariant;

      };
    };
  }
  }
}, {package:"react-router-dom>tiny-invariant",file:"node_modules\\tiny-invariant\\dist\\tiny-invariant.cjs.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\tiny-warning\\dist\\tiny-warning.cjs.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Ctiny-warning%5Cdist%5Ctiny-warning.cjs.js
      return function (require, module, exports) {
'use strict';

var isProduction = "development" === 'production';
function warning(condition, message) {
  if (!isProduction) {
    if (condition) {
      return;
    }

    var text = "Warning: " + message;

    if (typeof console !== 'undefined') {
      console.warn(text);
    }

    try {
      throw Error(text);
    } catch (x) {}
  }
}

module.exports = warning;

      };
    };
  }
  }
}, {package:"react-router-dom>tiny-warning",file:"node_modules\\tiny-warning\\dist\\tiny-warning.cjs.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\toggle-selection\\index.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Ctoggle-selection%5Cindex.js
      return function (require, module, exports) {

module.exports = function () {
  var selection = document.getSelection();
  if (!selection.rangeCount) {
    return function () {};
  }
  var active = document.activeElement;

  var ranges = [];
  for (var i = 0; i < selection.rangeCount; i++) {
    ranges.push(selection.getRangeAt(i));
  }

  switch (active.tagName.toUpperCase()) { // .toUpperCase handles XHTML
    case 'INPUT':
    case 'TEXTAREA':
      active.blur();
      break;

    default:
      active = null;
      break;
  }

  selection.removeAllRanges();
  return function () {
    selection.type === 'Caret' &&
    selection.removeAllRanges();

    if (!selection.rangeCount) {
      ranges.forEach(function(range) {
        selection.addRange(range);
      });
    }

    active &&
    active.focus();
  };
};

      };
    };
  }
  }
}, {package:"copy-to-clipboard>toggle-selection",file:"node_modules\\toggle-selection\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\trough\\index.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Ctrough%5Cindex.js
      return function (require, module, exports) {
'use strict';

/* Expose. */
module.exports = trough;

/* Methods. */
var slice = [].slice;

/* Create new middleware. */
function trough() {
  var fns = [];
  var middleware = {};

  middleware.run = run;
  middleware.use = use;

  return middleware;

  /* Run `fns`.  Last argument must be
   * a completion handler. */
  function run() {
    var index = -1;
    var input = slice.call(arguments, 0, -1);
    var done = arguments[arguments.length - 1];

    if (typeof done !== 'function') {
      throw new Error('Expected function as last argument, not ' + done);
    }

    next.apply(null, [null].concat(input));

    /* Run the next `fn`, if any. */
    function next(err) {
      var fn = fns[++index];
      var params = slice.call(arguments, 0);
      var values = params.slice(1);
      var length = input.length;
      var pos = -1;

      if (err) {
        done(err);
        return;
      }

      /* Copy non-nully input into values. */
      while (++pos < length) {
        if (values[pos] === null || values[pos] === undefined) {
          values[pos] = input[pos];
        }
      }

      input = values;

      /* Next or done. */
      if (fn) {
        wrap(fn, next).apply(null, input);
      } else {
        done.apply(null, [null].concat(input));
      }
    }
  }

  /* Add `fn` to the list. */
  function use(fn) {
    if (typeof fn !== 'function') {
      throw new Error('Expected `fn` to be a function, not ' + fn);
    }

    fns.push(fn);

    return middleware;
  }
}

/* Wrap `fn`.  Can be sync or async; return a promise,
 * receive a completion handler, return new values and
 * errors. */
function wrap(fn, next) {
  var invoked;

  return wrapped;

  function wrapped() {
    var params = slice.call(arguments, 0);
    var callback = fn.length > params.length;
    var result;

    if (callback) {
      params.push(done);
    }

    try {
      result = fn.apply(null, params);
    } catch (err) {
      /* Well, this is quite the pickle.  `fn` received
       * a callback and invoked it (thus continuing the
       * pipeline), but later also threw an error.
       * We’re not about to restart the pipeline again,
       * so the only thing left to do is to throw the
       * thing instea. */
      if (callback && invoked) {
        throw err;
      }

      return done(err);
    }

    if (!callback) {
      if (result && typeof result.then === 'function') {
        result.then(then, done);
      } else if (result instanceof Error) {
        done(result);
      } else {
        then(result);
      }
    }
  }

  /* Invoke `next`, only once. */
  function done() {
    if (!invoked) {
      invoked = true;

      next.apply(null, arguments);
    }
  }

  /* Invoke `done` with one value.
   * Tracks if an error is passed, too. */
  function then(value) {
    done(null, value);
  }
}

      };
    };
  }
  }
}, {package:"react-markdown>unified>trough",file:"node_modules\\trough\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ts-custom-error\\dist\\custom-error.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cts-custom-error%5Cdist%5Ccustom-error.js
      return function (require, module, exports) {
function fixProto(target, prototype) {
  var setPrototypeOf = Object.setPrototypeOf;
  setPrototypeOf ? setPrototypeOf(target, prototype) : target.__proto__ = prototype;
}
function fixStack(target, fn) {
  if (fn === void 0) {
    fn = target.constructor;
  }

  var captureStackTrace = Error.captureStackTrace;
  captureStackTrace && captureStackTrace(target, fn);
}

var __extends = undefined && undefined.__extends || function () {
  var _extendStatics = function extendStatics(d, b) {
    _extendStatics = Object.setPrototypeOf || {
      __proto__: []
    } instanceof Array && function (d, b) {
      d.__proto__ = b;
    } || function (d, b) {
      for (var p in b) {
        if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p];
      }
    };

    return _extendStatics(d, b);
  };

  return function (d, b) {
    if (typeof b !== "function" && b !== null) throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");

    _extendStatics(d, b);

    function __() {
      this.constructor = d;
    }

    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
}();

var CustomError = function (_super) {
  __extends(CustomError, _super);

  function CustomError(message, options) {
    var _newTarget = this.constructor;

    var _this = _super.call(this, message, options) || this;

    Object.defineProperty(_this, 'name', {
      value: _newTarget.name,
      enumerable: false,
      configurable: true
    });
    fixProto(_this, _newTarget.prototype);
    fixStack(_this);
    return _this;
  }

  return CustomError;
}(Error);

var __spreadArray = undefined && undefined.__spreadArray || function (to, from, pack) {
  if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
    if (ar || !(i in from)) {
      if (!ar) ar = Array.prototype.slice.call(from, 0, i);
      ar[i] = from[i];
    }
  }
  return to.concat(ar || Array.prototype.slice.call(from));
};
function customErrorFactory(fn, parent) {
  if (parent === void 0) {
    parent = Error;
  }

  function CustomError() {
    var args = [];

    for (var _i = 0; _i < arguments.length; _i++) {
      args[_i] = arguments[_i];
    }

    if (!(this instanceof CustomError)) return new (CustomError.bind.apply(CustomError, __spreadArray([void 0], args, false)))();
    parent.apply(this, args);
    Object.defineProperty(this, 'name', {
      value: fn.name || parent.name,
      enumerable: false,
      configurable: true
    });
    fn.apply(this, args);
    fixStack(this, CustomError);
  }

  return Object.defineProperties(CustomError, {
    prototype: {
      value: Object.create(parent.prototype, {
        constructor: {
          value: CustomError,
          writable: true,
          configurable: true
        }
      })
    }
  });
}

exports.CustomError = CustomError;
exports.customErrorFactory = customErrorFactory;


      };
    };
  }
  }
}, {package:"@zxing/library>ts-custom-error",file:"node_modules\\ts-custom-error\\dist\\custom-error.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\unicode-confusables\\data\\confusables.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cunicode-confusables%5Cdata%5Cconfusables.json
      return function (require, module, exports) {
module.exports={
 "0": "O",
 "1": "l",
 "֭": "֖",
 "֮": "֘",
 "֨": "֙",
 "֤": "֚",
 "᪴": "ۛ",
 "⃛": "ۛ",
 "ؙ": "̓",
 "ࣳ": "̓",
 "̓": "̓",
 "̕": "̓",
 "ُ": "̓",
 "ٝ": "̔",
 "֜": "́",
 "֝": "́",
 "ؘ": "́",
 "݇": "́",
 "́": "́",
 "॔": "́",
 "َ": "́",
 "̀": "̀",
 "॓": "̀",
 "̌": "̆",
 "꙼": "̆",
 "٘": "̆",
 "ٚ": "̆",
 "ͮ": "̆",
 "ۨ": "̆̇",
 "̐": "̆̇",
 "ँ": "̆̇",
 "ঁ": "̆̇",
 "ઁ": "̆̇",
 "ଁ": "̆̇",
 "ఀ": "̆̇",
 "ಁ": "̆̇",
 "ഁ": "̆̇",
 "𑒿": "̆̇",
 "᳐": "̂",
 "̑": "̂",
 "ٛ": "̂",
 "߮": "̂",
 "꛰": "̂",
 "֯": "̊",
 "۟": "̊",
 "៓": "̊",
 "゚": "̊",
 "ْ": "̊",
 "ஂ": "̊",
 "ံ": "̊",
 "ំ": "̊",
 "𑌀": "̊",
 "ํ": "̊",
 "ໍ": "̊",
 "ͦ": "̊",
 "ⷪ": "̊",
 "࣫": "̈",
 "߳": "̈",
 "ً": "̋",
 "ࣰ": "̋",
 "͂": "̃",
 "ٓ": "̃",
 "ׄ": "̇",
 "۬": "̇",
 "݀": "̇",
 "࣪": "̇",
 "݁": "̇",
 "͘": "̇",
 "ֹ": "̇",
 "ֺ": "̇",
 "ׂ": "̇",
 "ׁ": "̇",
 "߭": "̇",
 "ं": "̇",
 "ਂ": "̇",
 "ં": "̇",
 "்": "̇",
 "̷": "̸",
 "᪷": "̨",
 "̢": "̨",
 "ͅ": "̨",
 "᳒": "̄",
 "̅": "̄",
 "ٙ": "̄",
 "߫": "̄",
 "꛱": "̄",
 "᳚": "̎",
 "ٗ": "̒",
 "͗": "͐",
 "ࣿ": "͐",
 "ࣸ": "͐",
 "ऀ": "͒",
 "᳭": "̖",
 "᳜": "̩",
 "ٖ": "̩",
 "᳕": "̫",
 "͇": "̳",
 "ࣹ": "͔",
 "ࣺ": "͕",
 "゛": "ﾞ",
 "゜": "ﾟ",
 "̶": "̵",
 "〬": "̉",
 "ׅ": "̣",
 "࣭": "̣",
 "᳝": "̣",
 "ִ": "̣",
 "ٜ": "̣",
 "़": "̣",
 "়": "̣",
 "਼": "̣",
 "઼": "̣",
 "଼": "̣",
 "𑇊": "̣",
 "𑓃": "̣",
 "𐨺": "̣",
 "࣮": "̤",
 "᳞": "̤",
 "༷": "̥",
 "〭": "̥",
 "̧": "̦",
 "̡": "̦",
 "̹": "̦",
 "᳙": "̭",
 "᳘": "̮",
 "॒": "̱",
 "̠": "̱",
 "ࣱ": "ٌ",
 "ࣨ": "ٌ",
 "ࣥ": "ٌ",
 "ﱞ": "ﹲّ",
 "ࣲ": "ٍ",
 "ﱟ": "ﹴّ",
 "ﳲ": "ﹷّ",
 "ﱠ": "ﹶّ",
 "ﳳ": "ﹹّ",
 "ﱡ": "ﹸّ",
 "ؚ": "ِ",
 "̗": "ِ",
 "ﳴ": "ﹻّ",
 "ﱢ": "ﹺّ",
 "ﱣ": "ﹼٰ",
 "ٟ": "ٕ",
 "̍": "ٰ",
 "݂": "ܼ",
 "ਃ": "ঃ",
 "ః": "ঃ",
 "ಃ": "ঃ",
 "ഃ": "ঃ",
 "ඃ": "ঃ",
 "း": "ঃ",
 "𑓁": "ঃ",
 "់": "่",
 "່": "่",
 "້": "้",
 "໊": "๊",
 "໋": "๋",
 "꙯": "⃩",
 "\u2028": " ",
 "\u2029": " ",
 " ": " ",
 " ": " ",
 " ": " ",
 " ": " ",
 " ": " ",
 " ": " ",
 " ": " ",
 " ": " ",
 " ": " ",
 " ": " ",
 " ": " ",
 " ": " ",
 " ": " ",
 " ": " ",
 " ": " ",
 "ߺ": "_",
 "﹍": "_",
 "﹎": "_",
 "﹏": "_",
 "‐": "-",
 "‑": "-",
 "‒": "-",
 "–": "-",
 "﹘": "-",
 "۔": "-",
 "⁃": "-",
 "˗": "-",
 "−": "-",
 "➖": "-",
 "Ⲻ": "-",
 "⨩": "-̓",
 "⸚": "-̈",
 "﬩": "-̇",
 "∸": "-̇",
 "⨪": "-̣",
 "꓾": "-.",
 "～": "〜",
 "؍": ",",
 "٫": ",",
 "‚": ",",
 "¸": ",",
 "ꓹ": ",",
 "⸲": "،",
 "٬": "،",
 ";": ";",
 "⸵": "؛",
 "ः": ":",
 "ઃ": ":",
 "：": ":",
 "։": ":",
 "܃": ":",
 "܄": ":",
 "᛬": ":",
 "︰": ":",
 "᠃": ":",
 "᠉": ":",
 "⁚": ":",
 "׃": ":",
 "˸": ":",
 "꞉": ":",
 "∶": ":",
 "ː": ":",
 "ꓽ": ":",
 "⩴": "::=",
 "⧴": ":→",
 "！": "!",
 "ǃ": "!",
 "ⵑ": "!",
 "‼": "!!",
 "⁉": "!?",
 "ʔ": "?",
 "Ɂ": "?",
 "ॽ": "?",
 "Ꭾ": "?",
 "ꛫ": "?",
 "⁈": "?!",
 "⁇": "??",
 "⸮": "؟",
 "𝅭": ".",
 "․": ".",
 "܁": ".",
 "܂": ".",
 "꘎": ".",
 "𐩐": ".",
 "٠": ".",
 "۰": ".",
 "ꓸ": ".",
 "ꓻ": ".,",
 "‥": "..",
 "ꓺ": "..",
 "…": "...",
 "꛴": "꛳꛳",
 "・": "·",
 "･": "·",
 "᛫": "·",
 "·": "·",
 "⸱": "·",
 "𐄁": "·",
 "•": "·",
 "‧": "·",
 "∙": "·",
 "⋅": "·",
 "ꞏ": "·",
 "ᐧ": "·",
 "⋯": "···",
 "ⵈ": "···",
 "ᑄ": "·<",
 "⋗": "·>",
 "ᐷ": "·>",
 "ᑀ": "·>",
 "ᔯ": "·4",
 "ᑺ": "·d",
 "ᒘ": "·J",
 "ᒶ": "·L",
 "ᑶ": "·P",
 "ᑗ": "·U",
 "ᐺ": "·V",
 "ᐼ": "·Ʌ",
 "ᒮ": "·Γ",
 "ᐎ": "·Δ",
 "ᑙ": "·Ո",
 "ᐌ": "·ᐁ",
 "ᐐ": "·ᐄ",
 "ᐒ": "·ᐅ",
 "ᐔ": "·ᐆ",
 "ᐗ": "·ᐊ",
 "ᐙ": "·ᐋ",
 "ᐾ": "·ᐲ",
 "ᑂ": "·ᐴ",
 "ᑆ": "·ᐹ",
 "ᑛ": "·ᑏ",
 "ᑔ": "·ᑐ",
 "ᑝ": "·ᑐ",
 "ᑟ": "·ᑑ",
 "ᑡ": "·ᑕ",
 "ᑣ": "·ᑖ",
 "ᑴ": "·ᑫ",
 "ᑸ": "·ᑮ",
 "ᑼ": "·ᑰ",
 "ᑾ": "·ᑲ",
 "ᒀ": "·ᑳ",
 "ᒒ": "·ᒉ",
 "ᒔ": "·ᒋ",
 "ᒖ": "·ᒌ",
 "ᒚ": "·ᒎ",
 "ᒜ": "·ᒐ",
 "ᒞ": "·ᒑ",
 "ᒬ": "·ᒣ",
 "ᒰ": "·ᒦ",
 "ᒲ": "·ᒧ",
 "ᒴ": "·ᒨ",
 "ᒸ": "·ᒫ",
 "ᓉ": "·ᓀ",
 "ᣆ": "·ᓂ",
 "ᣈ": "·ᓃ",
 "ᣊ": "·ᓄ",
 "ᣌ": "·ᓅ",
 "ᓋ": "·ᓇ",
 "ᓍ": "·ᓈ",
 "ᓜ": "·ᓓ",
 "ᓞ": "·ᓕ",
 "ᓠ": "·ᓖ",
 "ᓢ": "·ᓗ",
 "ᓤ": "·ᓘ",
 "ᓦ": "·ᓚ",
 "ᓨ": "·ᓛ",
 "ᓶ": "·ᓭ",
 "ᓸ": "·ᓯ",
 "ᓺ": "·ᓰ",
 "ᓼ": "·ᓱ",
 "ᓾ": "·ᓲ",
 "ᔀ": "·ᓴ",
 "ᔂ": "·ᓵ",
 "ᔗ": "·ᔐ",
 "ᔙ": "·ᔑ",
 "ᔛ": "·ᔒ",
 "ᔝ": "·ᔓ",
 "ᔟ": "·ᔔ",
 "ᔡ": "·ᔕ",
 "ᔣ": "·ᔖ",
 "ᔱ": "·ᔨ",
 "ᔳ": "·ᔩ",
 "ᔵ": "·ᔪ",
 "ᔷ": "·ᔫ",
 "ᔹ": "·ᔭ",
 "ᔻ": "·ᔮ",
 "ᣎ": "·ᕃ",
 "ᣏ": "·ᕆ",
 "ᣐ": "·ᕇ",
 "ᣑ": "·ᕈ",
 "ᣒ": "·ᕉ",
 "ᣓ": "·ᕋ",
 "ᕎ": "·ᕌ",
 "ᕛ": "·ᕚ",
 "ᕨ": "·ᕧ",
 "ᢳ": "·ᢱ",
 "ᢶ": "·ᢴ",
 "ᢹ": "·ᢸ",
 "ᣂ": "·ᣀ",
 "꠰": "।",
 "॥": "।।",
 "᰼": "᰻᰻",
 "။": "၊၊",
 "᪩": "᪨᪨",
 "᪫": "᪪᪨",
 "᭟": "᭞᭞",
 "𐩗": "𐩖𐩖",
 "𑑌": "𑑋𑑋",
 "𑙂": "𑙁𑙁",
 "𑱂": "𑱁𑱁",
 "᱿": "᱾᱾",
 "՝": "'",
 "＇": "'",
 "‘": "'",
 "’": "'",
 "‛": "'",
 "′": "'",
 "‵": "'",
 "՚": "'",
 "׳": "'",
 "`": "'",
 "`": "'",
 "｀": "'",
 "´": "'",
 "΄": "'",
 "´": "'",
 "᾽": "'",
 "᾿": "'",
 "῾": "'",
 "ʹ": "'",
 "ʹ": "'",
 "ˈ": "'",
 "ˊ": "'",
 "ˋ": "'",
 "˴": "'",
 "ʻ": "'",
 "ʽ": "'",
 "ʼ": "'",
 "ʾ": "'",
 "ꞌ": "'",
 "י": "'",
 "ߴ": "'",
 "ߵ": "'",
 "ᑊ": "'",
 "ᛌ": "'",
 "𖽑": "'",
 "𖽒": "'",
 "᳓": "''",
 "\"": "''",
 "＂": "''",
 "“": "''",
 "”": "''",
 "‟": "''",
 "″": "''",
 "‶": "''",
 "〃": "''",
 "״": "''",
 "˝": "''",
 "ʺ": "''",
 "˶": "''",
 "ˮ": "''",
 "ײ": "''",
 "‴": "'''",
 "‷": "'''",
 "⁗": "''''",
 "Ɓ": "'B",
 "Ɗ": "'D",
 "ŉ": "'n",
 "Ƥ": "'P",
 "Ƭ": "'T",
 "Ƴ": "'Y",
 "［": "(",
 "❨": "(",
 "❲": "(",
 "〔": "(",
 "﴾": "(",
 "⸨": "((",
 "㈠": "(ー)",
 "⑵": "(2)",
 "⒇": "(2O)",
 "⑶": "(3)",
 "⑷": "(4)",
 "⑸": "(5)",
 "⑹": "(6)",
 "⑺": "(7)",
 "⑻": "(8)",
 "⑼": "(9)",
 "⒜": "(a)",
 "🄐": "(A)",
 "⒝": "(b)",
 "🄑": "(B)",
 "⒞": "(c)",
 "🄒": "(C)",
 "⒟": "(d)",
 "🄓": "(D)",
 "⒠": "(e)",
 "🄔": "(E)",
 "⒡": "(f)",
 "🄕": "(F)",
 "⒢": "(g)",
 "🄖": "(G)",
 "⒣": "(h)",
 "🄗": "(H)",
 "⒤": "(i)",
 "⒥": "(j)",
 "🄙": "(J)",
 "⒦": "(k)",
 "🄚": "(K)",
 "⑴": "(l)",
 "🄘": "(l)",
 "⒧": "(l)",
 "🄛": "(L)",
 "⑿": "(l2)",
 "⒀": "(l3)",
 "⒁": "(l4)",
 "⒂": "(l5)",
 "⒃": "(l6)",
 "⒄": "(l7)",
 "⒅": "(l8)",
 "⒆": "(l9)",
 "⑾": "(ll)",
 "⑽": "(lO)",
 "🄜": "(M)",
 "⒩": "(n)",
 "🄝": "(N)",
 "⒪": "(o)",
 "🄞": "(O)",
 "⒫": "(p)",
 "🄟": "(P)",
 "⒬": "(q)",
 "🄠": "(Q)",
 "⒭": "(r)",
 "🄡": "(R)",
 "⒨": "(rn)",
 "⒮": "(s)",
 "🄢": "(S)",
 "🄪": "(S)",
 "⒯": "(t)",
 "🄣": "(T)",
 "⒰": "(u)",
 "🄤": "(U)",
 "⒱": "(v)",
 "🄥": "(V)",
 "⒲": "(w)",
 "🄦": "(W)",
 "⒳": "(x)",
 "🄧": "(X)",
 "⒴": "(y)",
 "🄨": "(Y)",
 "⒵": "(z)",
 "🄩": "(Z)",
 "㈀": "(ᄀ)",
 "㈎": "(가)",
 "㈁": "(ᄂ)",
 "㈏": "(나)",
 "㈂": "(ᄃ)",
 "㈐": "(다)",
 "㈃": "(ᄅ)",
 "㈑": "(라)",
 "㈄": "(ᄆ)",
 "㈒": "(마)",
 "㈅": "(ᄇ)",
 "㈓": "(바)",
 "㈆": "(ᄉ)",
 "㈔": "(사)",
 "㈇": "(ᄋ)",
 "㈕": "(아)",
 "㈝": "(오전)",
 "㈞": "(오후)",
 "㈈": "(ᄌ)",
 "㈖": "(자)",
 "㈜": "(주)",
 "㈉": "(ᄎ)",
 "㈗": "(차)",
 "㈊": "(ᄏ)",
 "㈘": "(카)",
 "㈋": "(ᄐ)",
 "㈙": "(타)",
 "㈌": "(ᄑ)",
 "㈚": "(파)",
 "㈍": "(ᄒ)",
 "㈛": "(하)",
 "㈦": "(七)",
 "㈢": "(三)",
 "🉁": "(三)",
 "㈨": "(九)",
 "㈡": "(二)",
 "🉂": "(二)",
 "㈤": "(五)",
 "㈹": "(代)",
 "㈽": "(企)",
 "㉁": "(休)",
 "㈧": "(八)",
 "㈥": "(六)",
 "㈸": "(労)",
 "🉇": "(勝)",
 "㈩": "(十)",
 "㈿": "(協)",
 "㈴": "(名)",
 "㈺": "(呼)",
 "㈣": "(四)",
 "㈯": "(土)",
 "㈻": "(学)",
 "🉃": "(安)",
 "🉅": "(打)",
 "🉈": "(敗)",
 "㈰": "(日)",
 "㈪": "(月)",
 "㈲": "(有)",
 "㈭": "(木)",
 "🉀": "(本)",
 "㈱": "(株)",
 "㈬": "(水)",
 "㈫": "(火)",
 "🉄": "(点)",
 "㈵": "(特)",
 "🉆": "(盗)",
 "㈼": "(監)",
 "㈳": "(社)",
 "㈷": "(祝)",
 "㉀": "(祭)",
 "㉂": "(自)",
 "㉃": "(至)",
 "㈶": "(財)",
 "㈾": "(資)",
 "㈮": "(金)",
 "］": ")",
 "❩": ")",
 "❳": ")",
 "〕": ")",
 "﴿": ")",
 "⸩": "))",
 "❴": "{",
 "𝄔": "{",
 "❵": "}",
 "〚": "⟦",
 "〛": "⟧",
 "⟨": "❬",
 "〈": "❬",
 "〈": "❬",
 "㇛": "❬",
 "く": "❬",
 "𡿨": "❬",
 "⟩": "❭",
 "〉": "❭",
 "〉": "❭",
 "＾": "︿",
 "⸿": "¶",
 "⁎": "*",
 "٭": "*",
 "∗": "*",
 "𐌟": "*",
 "᜵": "/",
 "⁁": "/",
 "∕": "/",
 "⁄": "/",
 "╱": "/",
 "⟋": "/",
 "⧸": "/",
 "𝈺": "/",
 "㇓": "/",
 "〳": "/",
 "Ⳇ": "/",
 "ノ": "/",
 "丿": "/",
 "⼃": "/",
 "⧶": "/̄",
 "⫽": "//",
 "⫻": "///",
 "＼": "\\",
 "﹨": "\\",
 "∖": "\\",
 "⟍": "\\",
 "⧵": "\\",
 "⧹": "\\",
 "𝈏": "\\",
 "𝈻": "\\",
 "㇔": "\\",
 "丶": "\\",
 "⼂": "\\",
 "⳹": "\\\\",
 "⑊": "\\\\",
 "⟈": "\\ᑕ",
 "ꝸ": "&",
 "૰": "॰",
 "𑂻": "॰",
 "𑇇": "॰",
 "⚬": "॰",
 "𑇛": "꣼",
 "៙": "๏",
 "៕": "๚",
 "៚": "๛",
 "༌": "་",
 "༎": "།།",
 "˄": "^",
 "ˆ": "^",
 "꙾": "ˇ",
 "˘": "ˇ",
 "‾": "ˉ",
 "﹉": "ˉ",
 "﹊": "ˉ",
 "﹋": "ˉ",
 "﹌": "ˉ",
 "¯": "ˉ",
 "￣": "ˉ",
 "▔": "ˉ",
 "ъ": "ˉb",
 "ꙑ": "ˉbi",
 "͵": "ˏ",
 "˻": "˪",
 "꜖": "˪",
 "꜔": "˫",
 "。": "˳",
 "⸰": "°",
 "˚": "°",
 "∘": "°",
 "○": "°",
 "◦": "°",
 "⍜": "°̲",
 "⍤": "°̈",
 "℃": "°C",
 "℉": "°F",
 "௵": "௳",
 "༛": "༚༚",
 "༟": "༚༝",
 "࿎": "༝༚",
 "༞": "༝༝",
 "Ⓒ": "©",
 "Ⓡ": "®",
 "Ⓟ": "℗",
 "𝈛": "⅄",
 "⯬": "↞",
 "⯭": "↟",
 "⯮": "↠",
 "⯯": "↡",
 "↵": "↲",
 "⥥": "⇃⇂",
 "⥯": "⇃ᛚ",
 "𝛛": "∂",
 "𝜕": "∂",
 "𝝏": "∂",
 "𝞉": "∂",
 "𝟃": "∂",
 "𞣌": "∂",
 "𞣍": "∂̵",
 "ð": "∂̵",
 "⌀": "∅",
 "𝛁": "∇",
 "𝛻": "∇",
 "𝜵": "∇",
 "𝝯": "∇",
 "𝞩": "∇",
 "𑢨": "∇",
 "⍢": "∇̈",
 "⍫": "∇̴",
 "█": "∎",
 "■": "∎",
 "⨿": "∐",
 "᛭": "+",
 "➕": "+",
 "𐊛": "+",
 "⨣": "+̂",
 "⨢": "+̊",
 "⨤": "+̃",
 "∔": "+̇",
 "⨥": "+̣",
 "⨦": "+̰",
 "⨧": "+₂",
 "➗": "÷",
 "‹": "<",
 "❮": "<",
 "˂": "<",
 "𝈶": "<",
 "ᐸ": "<",
 "ᚲ": "<",
 "⋖": "<·",
 "Ⲵ": "<·",
 "ᑅ": "<·",
 "≪": "<<",
 "⋘": "<<<",
 "᐀": "=",
 "⹀": "=",
 "゠": "=",
 "꓿": "=",
 "≚": "=̆",
 "≙": "=̂",
 "≗": "=̊",
 "≐": "=̇",
 "≑": "=̣̇",
 "⩮": "=⃰",
 "⩵": "==",
 "⩶": "===",
 "≞": "=ͫ",
 "›": ">",
 "❯": ">",
 "˃": ">",
 "𝈷": ">",
 "ᐳ": ">",
 "𖼿": ">",
 "ᑁ": ">·",
 "⪥": "><",
 "≫": ">>",
 "⨠": ">>",
 "⋙": ">>>",
 "⁓": "~",
 "˜": "~",
 "῀": "~",
 "∼": "~",
 "⍨": "~̈",
 "⸞": "~̇",
 "⩪": "~̇",
 "⸟": "~̣",
 "𞣈": "∠",
 "⋀": "∧",
 "∯": "∮∮",
 "∰": "∮∮∮",
 "⸫": "∴",
 "⸪": "∵",
 "⸬": "∷",
 "𑇞": "≈",
 "♎": "≏",
 "🝞": "≏",
 "≣": "≡",
 "⨃": "⊍",
 "⨄": "⊎",
 "𝈸": "⊏",
 "𝈹": "⊐",
 "⨅": "⊓",
 "⨆": "⊔",
 "⨂": "⊗",
 "⍟": "⊛",
 "🝱": "⊠",
 "🝕": "⊡",
 "◁": "⊲",
 "▷": "⊳",
 "⍣": "⋆̈",
 "︴": "⌇",
 "◠": "⌒",
 "⨽": "⌙",
 "⌥": "⌤",
 "⧇": "⌻",
 "◎": "⌾",
 "⦾": "⌾",
 "⧅": "⍂",
 "⦰": "⍉",
 "⏃": "⍋",
 "⏂": "⍎",
 "⏁": "⍕",
 "Ö": "⍥",
 "Ő": "⍥",
 "⏆": "⍭",
 "☸": "⎈",
 "︵": "⏜",
 "︶": "⏝",
 "︷": "⏞",
 "︸": "⏟",
 "︹": "⏠",
 "︺": "⏡",
 "▱": "⏥",
 "⏼": "⏻",
 "︱": "│",
 "｜": "│",
 "┃": "│",
 "┏": "┌",
 "┣": "├",
 "▐": "▌",
 "▗": "▖",
 "▝": "▘",
 "☐": "□",
 "￭": "▪",
 "▸": "▶",
 "►": "▶",
 "⳩": "☧",
 "🜊": "☩",
 "🌒": "☽",
 "🌙": "☽",
 "⏾": "☾",
 "🌘": "☾",
 "⧙": "⦚",
 "🜺": "⧟",
 "⨾": "⨟",
 "𐆠": "⳨",
 "♩": "𝅘𝅥",
 "♪": "𝅘𝅥𝅮",
 "˙": "ॱ",
 "ൎ": "ॱ",
 "－": "ー",
 "—": "ー",
 "―": "ー",
 "─": "ー",
 "━": "ー",
 "㇐": "ー",
 "ꟷ": "ー",
 "ᅳ": "ー",
 "ㅡ": "ー",
 "一": "ー",
 "⼀": "ー",
 "ᆖ": "ーー",
 "ힹ": "ーᅡ",
 "ힺ": "ーᅥ",
 "ힻ": "ーᅥ丨",
 "ힼ": "ーᅩ",
 "ᆕ": "ーᅮ",
 "ᅴ": "ー丨",
 "ㅢ": "ー丨",
 "ᆗ": "ー丨ᅮ",
 "₤": "£",
 "〒": "₸",
 "〶": "₸",
 "᭜": "᭐",
 "꧆": "꧐",
 "𑓑": "১",
 "೧": "౧",
 "ၥ": "၁",
 "①": "➀",
 "⑩": "➉",
 "⏨": "₁₀",
 "𝟐": "2",
 "𝟚": "2",
 "𝟤": "2",
 "𝟮": "2",
 "𝟸": "2",
 "Ꝛ": "2",
 "Ƨ": "2",
 "Ϩ": "2",
 "Ꙅ": "2",
 "ᒿ": "2",
 "ꛯ": "2",
 "ꧏ": "٢",
 "۲": "٢",
 "૨": "२",
 "𑓒": "২",
 "೨": "౨",
 "②": "➁",
 "ƻ": "2̵",
 "🄃": "2,",
 "⒉": "2.",
 "㏵": "22日",
 "㍮": "22点",
 "㏶": "23日",
 "㍯": "23点",
 "㏷": "24日",
 "㍰": "24点",
 "㏸": "25日",
 "㏹": "26日",
 "㏺": "27日",
 "㏻": "28日",
 "㏼": "29日",
 "㏴": "2l日",
 "㍭": "2l点",
 "⒛": "2O.",
 "㏳": "2O日",
 "㍬": "2O点",
 "෩": "෨ා",
 "෯": "෨ී",
 "㏡": "2日",
 "㋁": "2月",
 "㍚": "2点",
 "𝈆": "3",
 "𝟑": "3",
 "𝟛": "3",
 "𝟥": "3",
 "𝟯": "3",
 "𝟹": "3",
 "Ɜ": "3",
 "Ȝ": "3",
 "Ʒ": "3",
 "Ꝫ": "3",
 "Ⳍ": "3",
 "З": "3",
 "Ӡ": "3",
 "𖼻": "3",
 "𑣊": "3",
 "۳": "٣",
 "𞣉": "٣",
 "૩": "३",
 "③": "➂",
 "Ҙ": "3̦",
 "🄄": "3,",
 "⒊": "3.",
 "㏾": "3l日",
 "㏽": "3O日",
 "㏢": "3日",
 "㋂": "3月",
 "㍛": "3点",
 "𝟒": "4",
 "𝟜": "4",
 "𝟦": "4",
 "𝟰": "4",
 "𝟺": "4",
 "Ꮞ": "4",
 "𑢯": "4",
 "۴": "٤",
 "૪": "४",
 "④": "➃",
 "🄅": "4,",
 "⒋": "4.",
 "ᔰ": "4·",
 "㏣": "4日",
 "㋃": "4月",
 "㍜": "4点",
 "𝟓": "5",
 "𝟝": "5",
 "𝟧": "5",
 "𝟱": "5",
 "𝟻": "5",
 "Ƽ": "5",
 "𑢻": "5",
 "⑤": "➄",
 "🄆": "5,",
 "⒌": "5.",
 "㏤": "5日",
 "㋄": "5月",
 "㍝": "5点",
 "𝟔": "6",
 "𝟞": "6",
 "𝟨": "6",
 "𝟲": "6",
 "𝟼": "6",
 "Ⳓ": "6",
 "б": "6",
 "Ꮾ": "6",
 "𑣕": "6",
 "۶": "٦",
 "𑓖": "৬",
 "⑥": "➅",
 "🄇": "6,",
 "⒍": "6.",
 "㏥": "6日",
 "㋅": "6月",
 "㍞": "6点",
 "𝈒": "7",
 "𝟕": "7",
 "𝟟": "7",
 "𝟩": "7",
 "𝟳": "7",
 "𝟽": "7",
 "𐓒": "7",
 "𑣆": "7",
 "⑦": "➆",
 "🄈": "7,",
 "⒎": "7.",
 "㏦": "7日",
 "㋆": "7月",
 "㍟": "7点",
 "ଃ": "8",
 "৪": "8",
 "੪": "8",
 "𞣋": "8",
 "𝟖": "8",
 "𝟠": "8",
 "𝟪": "8",
 "𝟴": "8",
 "𝟾": "8",
 "ȣ": "8",
 "Ȣ": "8",
 "𐌚": "8",
 "૮": "८",
 "⑧": "➇",
 "🄉": "8,",
 "⒏": "8.",
 "㏧": "8日",
 "㋇": "8月",
 "㍠": "8点",
 "੧": "9",
 "୨": "9",
 "৭": "9",
 "൭": "9",
 "𝟗": "9",
 "𝟡": "9",
 "𝟫": "9",
 "𝟵": "9",
 "𝟿": "9",
 "Ꝯ": "9",
 "Ⳋ": "9",
 "𑣌": "9",
 "𑢬": "9",
 "𑣖": "9",
 "१": "٩",
 "𑣤": "٩",
 "۹": "٩",
 "೯": "౯",
 "⑨": "➈",
 "🄊": "9,",
 "⒐": "9.",
 "㏨": "9日",
 "㋈": "9月",
 "㍡": "9点",
 "⍺": "a",
 "ａ": "a",
 "𝐚": "a",
 "𝑎": "a",
 "𝒂": "a",
 "𝒶": "a",
 "𝓪": "a",
 "𝔞": "a",
 "𝕒": "a",
 "𝖆": "a",
 "𝖺": "a",
 "𝗮": "a",
 "𝘢": "a",
 "𝙖": "a",
 "𝚊": "a",
 "ɑ": "a",
 "α": "a",
 "𝛂": "a",
 "𝛼": "a",
 "𝜶": "a",
 "𝝰": "a",
 "𝞪": "a",
 "а": "a",
 "ⷶ": "ͣ",
 "Ａ": "A",
 "𝐀": "A",
 "𝐴": "A",
 "𝑨": "A",
 "𝒜": "A",
 "𝓐": "A",
 "𝔄": "A",
 "𝔸": "A",
 "𝕬": "A",
 "𝖠": "A",
 "𝗔": "A",
 "𝘈": "A",
 "𝘼": "A",
 "𝙰": "A",
 "Α": "A",
 "𝚨": "A",
 "𝛢": "A",
 "𝜜": "A",
 "𝝖": "A",
 "𝞐": "A",
 "А": "A",
 "Ꭺ": "A",
 "ᗅ": "A",
 "ꓮ": "A",
 "𖽀": "A",
 "𐊠": "A",
 "⍶": "a̲",
 "ǎ": "ă",
 "Ǎ": "Ă",
 "ȧ": "å",
 "Ȧ": "Å",
 "ẚ": "ả",
 "℀": "a/c",
 "℁": "a/s",
 "ꜳ": "aa",
 "Ꜳ": "AA",
 "æ": "ae",
 "ӕ": "ae",
 "Æ": "AE",
 "Ӕ": "AE",
 "ꜵ": "ao",
 "Ꜵ": "AO",
 "🜇": "AR",
 "ꜷ": "au",
 "Ꜷ": "AU",
 "ꜹ": "av",
 "ꜻ": "av",
 "Ꜹ": "AV",
 "Ꜻ": "AV",
 "ꜽ": "ay",
 "Ꜽ": "AY",
 "ꭺ": "ᴀ",
 "∀": "Ɐ",
 "𝈗": "Ɐ",
 "ᗄ": "Ɐ",
 "ꓯ": "Ɐ",
 "𐐟": "Ɒ",
 "𝐛": "b",
 "𝑏": "b",
 "𝒃": "b",
 "𝒷": "b",
 "𝓫": "b",
 "𝔟": "b",
 "𝕓": "b",
 "𝖇": "b",
 "𝖻": "b",
 "𝗯": "b",
 "𝘣": "b",
 "𝙗": "b",
 "𝚋": "b",
 "Ƅ": "b",
 "Ь": "b",
 "Ꮟ": "b",
 "ᖯ": "b",
 "Ｂ": "B",
 "ℬ": "B",
 "𝐁": "B",
 "𝐵": "B",
 "𝑩": "B",
 "𝓑": "B",
 "𝔅": "B",
 "𝔹": "B",
 "𝕭": "B",
 "𝖡": "B",
 "𝗕": "B",
 "𝘉": "B",
 "𝘽": "B",
 "𝙱": "B",
 "Ꞵ": "B",
 "Β": "B",
 "𝚩": "B",
 "𝛣": "B",
 "𝜝": "B",
 "𝝗": "B",
 "𝞑": "B",
 "В": "B",
 "Ᏼ": "B",
 "ᗷ": "B",
 "ꓐ": "B",
 "𐊂": "B",
 "𐊡": "B",
 "𐌁": "B",
 "ɓ": "b̔",
 "ƃ": "b̄",
 "Ƃ": "b̄",
 "Б": "b̄",
 "ƀ": "b̵",
 "ҍ": "b̵",
 "Ҍ": "b̵",
 "ѣ": "b̵",
 "Ѣ": "b̵",
 "Ы": "bl",
 "в": "ʙ",
 "ᏼ": "ʙ",
 "ｃ": "c",
 "ⅽ": "c",
 "𝐜": "c",
 "𝑐": "c",
 "𝒄": "c",
 "𝒸": "c",
 "𝓬": "c",
 "𝔠": "c",
 "𝕔": "c",
 "𝖈": "c",
 "𝖼": "c",
 "𝗰": "c",
 "𝘤": "c",
 "𝙘": "c",
 "𝚌": "c",
 "ᴄ": "c",
 "ϲ": "c",
 "ⲥ": "c",
 "с": "c",
 "ꮯ": "c",
 "𐐽": "c",
 "ⷭ": "ͨ",
 "🝌": "C",
 "𑣲": "C",
 "𑣩": "C",
 "Ｃ": "C",
 "Ⅽ": "C",
 "ℂ": "C",
 "ℭ": "C",
 "𝐂": "C",
 "𝐶": "C",
 "𝑪": "C",
 "𝒞": "C",
 "𝓒": "C",
 "𝕮": "C",
 "𝖢": "C",
 "𝗖": "C",
 "𝘊": "C",
 "𝘾": "C",
 "𝙲": "C",
 "Ϲ": "C",
 "Ⲥ": "C",
 "С": "C",
 "Ꮯ": "C",
 "ꓚ": "C",
 "𐊢": "C",
 "𐌂": "C",
 "𐐕": "C",
 "𐔜": "C",
 "¢": "c̸",
 "ȼ": "c̸",
 "₡": "C⃫",
 "ç": "c̦",
 "ҫ": "c̦",
 "Ç": "C̦",
 "Ҫ": "C̦",
 "Ƈ": "C'",
 "℅": "c/o",
 "℆": "c/u",
 "⋴": "ꞓ",
 "ɛ": "ꞓ",
 "ε": "ꞓ",
 "ϵ": "ꞓ",
 "𝛆": "ꞓ",
 "𝛜": "ꞓ",
 "𝜀": "ꞓ",
 "𝜖": "ꞓ",
 "𝜺": "ꞓ",
 "𝝐": "ꞓ",
 "𝝴": "ꞓ",
 "𝞊": "ꞓ",
 "𝞮": "ꞓ",
 "𝟄": "ꞓ",
 "ⲉ": "ꞓ",
 "є": "ꞓ",
 "ԑ": "ꞓ",
 "ꮛ": "ꞓ",
 "𑣎": "ꞓ",
 "𐐩": "ꞓ",
 "€": "Ꞓ",
 "Ⲉ": "Ꞓ",
 "Є": "Ꞓ",
 "⍷": "ꞓ̲",
 "ͽ": "ꜿ",
 "Ͽ": "Ꜿ",
 "ⅾ": "d",
 "ⅆ": "d",
 "𝐝": "d",
 "𝑑": "d",
 "𝒅": "d",
 "𝒹": "d",
 "𝓭": "d",
 "𝔡": "d",
 "𝕕": "d",
 "𝖉": "d",
 "𝖽": "d",
 "𝗱": "d",
 "𝘥": "d",
 "𝙙": "d",
 "𝚍": "d",
 "ԁ": "d",
 "Ꮷ": "d",
 "ᑯ": "d",
 "ꓒ": "d",
 "Ⅾ": "D",
 "ⅅ": "D",
 "𝐃": "D",
 "𝐷": "D",
 "𝑫": "D",
 "𝒟": "D",
 "𝓓": "D",
 "𝔇": "D",
 "𝔻": "D",
 "𝕯": "D",
 "𝖣": "D",
 "𝗗": "D",
 "𝘋": "D",
 "𝘿": "D",
 "𝙳": "D",
 "Ꭰ": "D",
 "ᗞ": "D",
 "ᗪ": "D",
 "ꓓ": "D",
 "ɗ": "d̔",
 "ɖ": "d̨",
 "ƌ": "d̄",
 "đ": "d̵",
 "Đ": "D̵",
 "Ð": "D̵",
 "Ɖ": "D̵",
 "₫": "ḏ̵",
 "ꝺ": "Ꝺ",
 "ᑻ": "d·",
 "ᒇ": "d'",
 "ʤ": "dȝ",
 "ǳ": "dz",
 "ʣ": "dz",
 "ǲ": "Dz",
 "Ǳ": "DZ",
 "ǆ": "dž",
 "ǅ": "Dž",
 "Ǆ": "DŽ",
 "ʥ": "dʑ",
 "ꭰ": "ᴅ",
 "⸹": "ẟ",
 "δ": "ẟ",
 "𝛅": "ẟ",
 "𝛿": "ẟ",
 "𝜹": "ẟ",
 "𝝳": "ẟ",
 "𝞭": "ẟ",
 "ծ": "ẟ",
 "ᕷ": "ẟ",
 "℮": "e",
 "ｅ": "e",
 "ℯ": "e",
 "ⅇ": "e",
 "𝐞": "e",
 "𝑒": "e",
 "𝒆": "e",
 "𝓮": "e",
 "𝔢": "e",
 "𝕖": "e",
 "𝖊": "e",
 "𝖾": "e",
 "𝗲": "e",
 "𝘦": "e",
 "𝙚": "e",
 "𝚎": "e",
 "ꬲ": "e",
 "е": "e",
 "ҽ": "e",
 "ⷷ": "ͤ",
 "⋿": "E",
 "Ｅ": "E",
 "ℰ": "E",
 "𝐄": "E",
 "𝐸": "E",
 "𝑬": "E",
 "𝓔": "E",
 "𝔈": "E",
 "𝔼": "E",
 "𝕰": "E",
 "𝖤": "E",
 "𝗘": "E",
 "𝘌": "E",
 "𝙀": "E",
 "𝙴": "E",
 "Ε": "E",
 "𝚬": "E",
 "𝛦": "E",
 "𝜠": "E",
 "𝝚": "E",
 "𝞔": "E",
 "Е": "E",
 "ⴹ": "E",
 "Ꭼ": "E",
 "ꓰ": "E",
 "𑢦": "E",
 "𑢮": "E",
 "𐊆": "E",
 "ě": "ĕ",
 "Ě": "Ĕ",
 "ɇ": "e̸",
 "Ɇ": "E̸",
 "ҿ": "ę",
 "ꭼ": "ᴇ",
 "ə": "ǝ",
 "ә": "ǝ",
 "∃": "Ǝ",
 "ⴺ": "Ǝ",
 "ꓱ": "Ǝ",
 "ɚ": "ǝ˞",
 "ᴔ": "ǝo",
 "ꭁ": "ǝo̸",
 "ꭂ": "ǝo̵",
 "Ә": "Ə",
 "𝈡": "Ɛ",
 "ℇ": "Ɛ",
 "Ԑ": "Ɛ",
 "Ꮛ": "Ɛ",
 "𖼭": "Ɛ",
 "𐐁": "Ɛ",
 "ᶟ": "ᵋ",
 "ᴈ": "ɜ",
 "з": "ɜ",
 "ҙ": "ɜ̦",
 "𐑂": "ɞ",
 "ꞝ": "ʚ",
 "𐐪": "ʚ",
 "𝐟": "f",
 "𝑓": "f",
 "𝒇": "f",
 "𝒻": "f",
 "𝓯": "f",
 "𝔣": "f",
 "𝕗": "f",
 "𝖋": "f",
 "𝖿": "f",
 "𝗳": "f",
 "𝘧": "f",
 "𝙛": "f",
 "𝚏": "f",
 "ꬵ": "f",
 "ꞙ": "f",
 "ſ": "f",
 "ẝ": "f",
 "ք": "f",
 "𝈓": "F",
 "ℱ": "F",
 "𝐅": "F",
 "𝐹": "F",
 "𝑭": "F",
 "𝓕": "F",
 "𝔉": "F",
 "𝔽": "F",
 "𝕱": "F",
 "𝖥": "F",
 "𝗙": "F",
 "𝘍": "F",
 "𝙁": "F",
 "𝙵": "F",
 "Ꞙ": "F",
 "Ϝ": "F",
 "𝟊": "F",
 "ᖴ": "F",
 "ꓝ": "F",
 "𑣂": "F",
 "𑢢": "F",
 "𐊇": "F",
 "𐊥": "F",
 "𐔥": "F",
 "ƒ": "f̦",
 "Ƒ": "F̦",
 "ᵮ": "f̴",
 "℻": "FAX",
 "ﬀ": "ff",
 "ﬃ": "ffi",
 "ﬄ": "ffl",
 "ﬁ": "fi",
 "ﬂ": "fl",
 "ʩ": "fŋ",
 "ᖵ": "Ⅎ",
 "ꓞ": "Ⅎ",
 "𝈰": "ꟻ",
 "ᖷ": "ꟻ",
 "ｇ": "g",
 "ℊ": "g",
 "𝐠": "g",
 "𝑔": "g",
 "𝒈": "g",
 "𝓰": "g",
 "𝔤": "g",
 "𝕘": "g",
 "𝖌": "g",
 "𝗀": "g",
 "𝗴": "g",
 "𝘨": "g",
 "𝙜": "g",
 "𝚐": "g",
 "ɡ": "g",
 "ᶃ": "g",
 "ƍ": "g",
 "ց": "g",
 "𝐆": "G",
 "𝐺": "G",
 "𝑮": "G",
 "𝒢": "G",
 "𝓖": "G",
 "𝔊": "G",
 "𝔾": "G",
 "𝕲": "G",
 "𝖦": "G",
 "𝗚": "G",
 "𝘎": "G",
 "𝙂": "G",
 "𝙶": "G",
 "Ԍ": "G",
 "Ꮐ": "G",
 "Ᏻ": "G",
 "ꓖ": "G",
 "ᶢ": "ᵍ",
 "ɠ": "g̔",
 "ǧ": "ğ",
 "Ǧ": "Ğ",
 "ǵ": "ģ",
 "ǥ": "g̵",
 "Ǥ": "G̵",
 "Ɠ": "G'",
 "ԍ": "ɢ",
 "ꮐ": "ɢ",
 "ᏻ": "ɢ",
 "ｈ": "h",
 "ℎ": "h",
 "𝐡": "h",
 "𝒉": "h",
 "𝒽": "h",
 "𝓱": "h",
 "𝔥": "h",
 "𝕙": "h",
 "𝖍": "h",
 "𝗁": "h",
 "𝗵": "h",
 "𝘩": "h",
 "𝙝": "h",
 "𝚑": "h",
 "һ": "h",
 "հ": "h",
 "Ꮒ": "h",
 "Ｈ": "H",
 "ℋ": "H",
 "ℌ": "H",
 "ℍ": "H",
 "𝐇": "H",
 "𝐻": "H",
 "𝑯": "H",
 "𝓗": "H",
 "𝕳": "H",
 "𝖧": "H",
 "𝗛": "H",
 "𝘏": "H",
 "𝙃": "H",
 "𝙷": "H",
 "Η": "H",
 "𝚮": "H",
 "𝛨": "H",
 "𝜢": "H",
 "𝝜": "H",
 "𝞖": "H",
 "Ⲏ": "H",
 "Н": "H",
 "Ꮋ": "H",
 "ᕼ": "H",
 "ꓧ": "H",
 "𐋏": "H",
 "ᵸ": "ᴴ",
 "ɦ": "h̔",
 "ꚕ": "h̔",
 "Ᏺ": "h̔",
 "Ⱨ": "H̩",
 "Ң": "H̩",
 "ħ": "h̵",
 "ℏ": "h̵",
 "ћ": "h̵",
 "Ħ": "H̵",
 "Ӊ": "H̦",
 "Ӈ": "H̦",
 "н": "ʜ",
 "ꮋ": "ʜ",
 "ң": "ʜ̩",
 "ӊ": "ʜ̦",
 "ӈ": "ʜ̦",
 "Ԋ": "Ƕ",
 "ꮀ": "ⱶ",
 "Ͱ": "Ⱶ",
 "Ꭸ": "Ⱶ",
 "Ꮀ": "Ⱶ",
 "ꚱ": "Ⱶ",
 "ꞕ": "ꜧ",
 "˛": "i",
 "⍳": "i",
 "ｉ": "i",
 "ⅰ": "i",
 "ℹ": "i",
 "ⅈ": "i",
 "𝐢": "i",
 "𝑖": "i",
 "𝒊": "i",
 "𝒾": "i",
 "𝓲": "i",
 "𝔦": "i",
 "𝕚": "i",
 "𝖎": "i",
 "𝗂": "i",
 "𝗶": "i",
 "𝘪": "i",
 "𝙞": "i",
 "𝚒": "i",
 "ı": "i",
 "𝚤": "i",
 "ɪ": "i",
 "ɩ": "i",
 "ι": "i",
 "ι": "i",
 "ͺ": "i",
 "𝛊": "i",
 "𝜄": "i",
 "𝜾": "i",
 "𝝸": "i",
 "𝞲": "i",
 "і": "i",
 "ꙇ": "i",
 "ӏ": "i",
 "ꭵ": "i",
 "Ꭵ": "i",
 "𑣃": "i",
 "ⓛ": "Ⓘ",
 "⍸": "i̲",
 "ǐ": "ĭ",
 "Ǐ": "Ĭ",
 "ɨ": "i̵",
 "ᵻ": "i̵",
 "ᵼ": "i̵",
 "ⅱ": "ii",
 "ⅲ": "iii",
 "ĳ": "ij",
 "ⅳ": "iv",
 "ⅸ": "ix",
 "ｊ": "j",
 "ⅉ": "j",
 "𝐣": "j",
 "𝑗": "j",
 "𝒋": "j",
 "𝒿": "j",
 "𝓳": "j",
 "𝔧": "j",
 "𝕛": "j",
 "𝖏": "j",
 "𝗃": "j",
 "𝗷": "j",
 "𝘫": "j",
 "𝙟": "j",
 "𝚓": "j",
 "ϳ": "j",
 "ј": "j",
 "Ｊ": "J",
 "𝐉": "J",
 "𝐽": "J",
 "𝑱": "J",
 "𝒥": "J",
 "𝓙": "J",
 "𝔍": "J",
 "𝕁": "J",
 "𝕵": "J",
 "𝖩": "J",
 "𝗝": "J",
 "𝘑": "J",
 "𝙅": "J",
 "𝙹": "J",
 "Ʝ": "J",
 "Ϳ": "J",
 "Ј": "J",
 "Ꭻ": "J",
 "ᒍ": "J",
 "ꓙ": "J",
 "ɉ": "j̵",
 "Ɉ": "J̵",
 "ᒙ": "J·",
 "𝚥": "ȷ",
 "յ": "ȷ",
 "ꭻ": "ᴊ",
 "𝐤": "k",
 "𝑘": "k",
 "𝒌": "k",
 "𝓀": "k",
 "𝓴": "k",
 "𝔨": "k",
 "𝕜": "k",
 "𝖐": "k",
 "𝗄": "k",
 "𝗸": "k",
 "𝘬": "k",
 "𝙠": "k",
 "𝚔": "k",
 "K": "K",
 "Ｋ": "K",
 "𝐊": "K",
 "𝐾": "K",
 "𝑲": "K",
 "𝒦": "K",
 "𝓚": "K",
 "𝔎": "K",
 "𝕂": "K",
 "𝕶": "K",
 "𝖪": "K",
 "𝗞": "K",
 "𝘒": "K",
 "𝙆": "K",
 "𝙺": "K",
 "Κ": "K",
 "𝚱": "K",
 "𝛫": "K",
 "𝜥": "K",
 "𝝟": "K",
 "𝞙": "K",
 "Ⲕ": "K",
 "К": "K",
 "Ꮶ": "K",
 "ᛕ": "K",
 "ꓗ": "K",
 "𐔘": "K",
 "ƙ": "k̔",
 "Ⱪ": "K̩",
 "Қ": "K̩",
 "₭": "K̵",
 "Ꝁ": "K̵",
 "Ҟ": "K̵",
 "Ƙ": "K'",
 "׀": "l",
 "|": "l",
 "∣": "l",
 "⏽": "l",
 "￨": "l",
 "١": "l",
 "۱": "l",
 "𐌠": "l",
 "𞣇": "l",
 "𝟏": "l",
 "𝟙": "l",
 "𝟣": "l",
 "𝟭": "l",
 "𝟷": "l",
 "I": "l",
 "Ｉ": "l",
 "Ⅰ": "l",
 "ℐ": "l",
 "ℑ": "l",
 "𝐈": "l",
 "𝐼": "l",
 "𝑰": "l",
 "𝓘": "l",
 "𝕀": "l",
 "𝕴": "l",
 "𝖨": "l",
 "𝗜": "l",
 "𝘐": "l",
 "𝙄": "l",
 "𝙸": "l",
 "Ɩ": "l",
 "ｌ": "l",
 "ⅼ": "l",
 "ℓ": "l",
 "𝐥": "l",
 "𝑙": "l",
 "𝒍": "l",
 "𝓁": "l",
 "𝓵": "l",
 "𝔩": "l",
 "𝕝": "l",
 "𝖑": "l",
 "𝗅": "l",
 "𝗹": "l",
 "𝘭": "l",
 "𝙡": "l",
 "𝚕": "l",
 "ǀ": "l",
 "Ι": "l",
 "𝚰": "l",
 "𝛪": "l",
 "𝜤": "l",
 "𝝞": "l",
 "𝞘": "l",
 "Ⲓ": "l",
 "І": "l",
 "Ӏ": "l",
 "ו": "l",
 "ן": "l",
 "ا": "l",
 "𞸀": "l",
 "𞺀": "l",
 "ﺎ": "l",
 "ﺍ": "l",
 "ߊ": "l",
 "ⵏ": "l",
 "ᛁ": "l",
 "ꓲ": "l",
 "𖼨": "l",
 "𐊊": "l",
 "𐌉": "l",
 "𝈪": "L",
 "Ⅼ": "L",
 "ℒ": "L",
 "𝐋": "L",
 "𝐿": "L",
 "𝑳": "L",
 "𝓛": "L",
 "𝔏": "L",
 "𝕃": "L",
 "𝕷": "L",
 "𝖫": "L",
 "𝗟": "L",
 "𝘓": "L",
 "𝙇": "L",
 "𝙻": "L",
 "Ⳑ": "L",
 "Ꮮ": "L",
 "ᒪ": "L",
 "ꓡ": "L",
 "𖼖": "L",
 "𑢣": "L",
 "𑢲": "L",
 "𐐛": "L",
 "𐔦": "L",
 "ﴼ": "l̋",
 "ﴽ": "l̋",
 "ł": "l̸",
 "Ł": "L̸",
 "ɭ": "l̨",
 "Ɨ": "l̵",
 "ƚ": "l̵",
 "ɫ": "l̴",
 "إ": "lٕ",
 "ﺈ": "lٕ",
 "ﺇ": "lٕ",
 "ٳ": "lٕ",
 "ŀ": "l·",
 "Ŀ": "l·",
 "ᒷ": "l·",
 "🄂": "l,",
 "⒈": "l.",
 "ױ": "l'",
 "⒓": "l2.",
 "㏫": "l2日",
 "㋋": "l2月",
 "㍤": "l2点",
 "⒔": "l3.",
 "㏬": "l3日",
 "㍥": "l3点",
 "⒕": "l4.",
 "㏭": "l4日",
 "㍦": "l4点",
 "⒖": "l5.",
 "㏮": "l5日",
 "㍧": "l5点",
 "⒗": "l6.",
 "㏯": "l6日",
 "㍨": "l6点",
 "⒘": "l7.",
 "㏰": "l7日",
 "㍩": "l7点",
 "⒙": "l8.",
 "㏱": "l8日",
 "㍪": "l8点",
 "⒚": "l9.",
 "㏲": "l9日",
 "㍫": "l9点",
 "ǉ": "lj",
 "Ĳ": "lJ",
 "ǈ": "Lj",
 "Ǉ": "LJ",
 "‖": "ll",
 "∥": "ll",
 "Ⅱ": "ll",
 "ǁ": "ll",
 "װ": "ll",
 "𐆙": "l̵l̵",
 "⒒": "ll.",
 "Ⅲ": "lll",
 "𐆘": "l̵l̵S̵",
 "㏪": "ll日",
 "㋊": "ll月",
 "㍣": "ll点",
 "Ю": "lO",
 "⒑": "lO.",
 "㏩": "lO日",
 "㋉": "lO月",
 "㍢": "lO点",
 "ʪ": "ls",
 "₶": "lt",
 "Ⅳ": "lV",
 "Ⅸ": "lX",
 "ɮ": "lȝ",
 "ʫ": "lz",
 "أ": "lٴ",
 "ﺄ": "lٴ",
 "ﺃ": "lٴ",
 "ٲ": "lٴ",
 "ٵ": "lٴ",
 "ﷳ": "lكبر",
 "ﷲ": "lللّٰo",
 "㏠": "l日",
 "㋀": "l月",
 "㍙": "l点",
 "ⳑ": "ʟ",
 "ꮮ": "ʟ",
 "𐑃": "ʟ",
 "Ｍ": "M",
 "Ⅿ": "M",
 "ℳ": "M",
 "𝐌": "M",
 "𝑀": "M",
 "𝑴": "M",
 "𝓜": "M",
 "𝔐": "M",
 "𝕄": "M",
 "𝕸": "M",
 "𝖬": "M",
 "𝗠": "M",
 "𝘔": "M",
 "𝙈": "M",
 "𝙼": "M",
 "Μ": "M",
 "𝚳": "M",
 "𝛭": "M",
 "𝜧": "M",
 "𝝡": "M",
 "𝞛": "M",
 "Ϻ": "M",
 "Ⲙ": "M",
 "М": "M",
 "Ꮇ": "M",
 "ᗰ": "M",
 "ᛖ": "M",
 "ꓟ": "M",
 "𐊰": "M",
 "𐌑": "M",
 "Ӎ": "M̦",
 "🝫": "MB",
 "ⷨ": "ᷟ",
 "𝐧": "n",
 "𝑛": "n",
 "𝒏": "n",
 "𝓃": "n",
 "𝓷": "n",
 "𝔫": "n",
 "𝕟": "n",
 "𝖓": "n",
 "𝗇": "n",
 "𝗻": "n",
 "𝘯": "n",
 "𝙣": "n",
 "𝚗": "n",
 "ո": "n",
 "ռ": "n",
 "Ｎ": "N",
 "ℕ": "N",
 "𝐍": "N",
 "𝑁": "N",
 "𝑵": "N",
 "𝒩": "N",
 "𝓝": "N",
 "𝔑": "N",
 "𝕹": "N",
 "𝖭": "N",
 "𝗡": "N",
 "𝘕": "N",
 "𝙉": "N",
 "𝙽": "N",
 "Ν": "N",
 "𝚴": "N",
 "𝛮": "N",
 "𝜨": "N",
 "𝝢": "N",
 "𝞜": "N",
 "Ⲛ": "N",
 "ꓠ": "N",
 "𐔓": "N",
 "𐆎": "N̊",
 "ɳ": "n̨",
 "ƞ": "n̩",
 "η": "n̩",
 "𝛈": "n̩",
 "𝜂": "n̩",
 "𝜼": "n̩",
 "𝝶": "n̩",
 "𝞰": "n̩",
 "Ɲ": "N̦",
 "ᵰ": "n̴",
 "ǌ": "nj",
 "ǋ": "Nj",
 "Ǌ": "NJ",
 "№": "No",
 "ͷ": "ᴎ",
 "и": "ᴎ",
 "𐑍": "ᴎ",
 "ņ": "ɲ",
 "ం": "o",
 "ಂ": "o",
 "ം": "o",
 "ං": "o",
 "०": "o",
 "੦": "o",
 "૦": "o",
 "௦": "o",
 "౦": "o",
 "೦": "o",
 "൦": "o",
 "๐": "o",
 "໐": "o",
 "၀": "o",
 "٥": "o",
 "۵": "o",
 "ｏ": "o",
 "ℴ": "o",
 "𝐨": "o",
 "𝑜": "o",
 "𝒐": "o",
 "𝓸": "o",
 "𝔬": "o",
 "𝕠": "o",
 "𝖔": "o",
 "𝗈": "o",
 "𝗼": "o",
 "𝘰": "o",
 "𝙤": "o",
 "𝚘": "o",
 "ᴏ": "o",
 "ᴑ": "o",
 "ꬽ": "o",
 "ο": "o",
 "𝛐": "o",
 "𝜊": "o",
 "𝝄": "o",
 "𝝾": "o",
 "𝞸": "o",
 "σ": "o",
 "𝛔": "o",
 "𝜎": "o",
 "𝝈": "o",
 "𝞂": "o",
 "𝞼": "o",
 "ⲟ": "o",
 "о": "o",
 "ჿ": "o",
 "օ": "o",
 "ס": "o",
 "ه": "o",
 "𞸤": "o",
 "𞹤": "o",
 "𞺄": "o",
 "ﻫ": "o",
 "ﻬ": "o",
 "ﻪ": "o",
 "ﻩ": "o",
 "ھ": "o",
 "ﮬ": "o",
 "ﮭ": "o",
 "ﮫ": "o",
 "ﮪ": "o",
 "ہ": "o",
 "ﮨ": "o",
 "ﮩ": "o",
 "ﮧ": "o",
 "ﮦ": "o",
 "ە": "o",
 "ഠ": "o",
 "ဝ": "o",
 "𐓪": "o",
 "𑣈": "o",
 "𑣗": "o",
 "𐐬": "o",
 "߀": "O",
 "০": "O",
 "୦": "O",
 "〇": "O",
 "𑓐": "O",
 "𑣠": "O",
 "𝟎": "O",
 "𝟘": "O",
 "𝟢": "O",
 "𝟬": "O",
 "𝟶": "O",
 "Ｏ": "O",
 "𝐎": "O",
 "𝑂": "O",
 "𝑶": "O",
 "𝒪": "O",
 "𝓞": "O",
 "𝔒": "O",
 "𝕆": "O",
 "𝕺": "O",
 "𝖮": "O",
 "𝗢": "O",
 "𝘖": "O",
 "𝙊": "O",
 "𝙾": "O",
 "Ο": "O",
 "𝚶": "O",
 "𝛰": "O",
 "𝜪": "O",
 "𝝤": "O",
 "𝞞": "O",
 "Ⲟ": "O",
 "О": "O",
 "Օ": "O",
 "ⵔ": "O",
 "ዐ": "O",
 "ଠ": "O",
 "𐓂": "O",
 "ꓳ": "O",
 "𑢵": "O",
 "𐊒": "O",
 "𐊫": "O",
 "𐐄": "O",
 "𐔖": "O",
 "⁰": "º",
 "ᵒ": "º",
 "ǒ": "ŏ",
 "Ǒ": "Ŏ",
 "ۿ": "ô",
 "ø": "o̸",
 "ꬾ": "o̸",
 "Ø": "O̸",
 "ⵁ": "O̸",
 "Ǿ": "Ó̸",
 "ɵ": "o̵",
 "ꝋ": "o̵",
 "ө": "o̵",
 "ѳ": "o̵",
 "ꮎ": "o̵",
 "ꮻ": "o̵",
 "⊖": "O̵",
 "⊝": "O̵",
 "⍬": "O̵",
 "𝈚": "O̵",
 "🜔": "O̵",
 "Ɵ": "O̵",
 "Ꝋ": "O̵",
 "θ": "O̵",
 "ϑ": "O̵",
 "𝛉": "O̵",
 "𝛝": "O̵",
 "𝜃": "O̵",
 "𝜗": "O̵",
 "𝜽": "O̵",
 "𝝑": "O̵",
 "𝝷": "O̵",
 "𝞋": "O̵",
 "𝞱": "O̵",
 "𝟅": "O̵",
 "Θ": "O̵",
 "ϴ": "O̵",
 "𝚯": "O̵",
 "𝚹": "O̵",
 "𝛩": "O̵",
 "𝛳": "O̵",
 "𝜣": "O̵",
 "𝜭": "O̵",
 "𝝝": "O̵",
 "𝝧": "O̵",
 "𝞗": "O̵",
 "𝞡": "O̵",
 "Ө": "O̵",
 "Ѳ": "O̵",
 "ⴱ": "O̵",
 "Ꮎ": "O̵",
 "Ꮻ": "O̵",
 "ꭴ": "ơ",
 "ﳙ": "oٰ",
 "🄁": "O,",
 "🄀": "O.",
 "ơ": "o'",
 "Ơ": "O'",
 "Ꭴ": "O'",
 "%": "º/₀",
 "٪": "º/₀",
 "⁒": "º/₀",
 "‰": "º/₀₀",
 "؉": "º/₀₀",
 "‱": "º/₀₀₀",
 "؊": "º/₀₀₀",
 "œ": "oe",
 "Œ": "OE",
 "ɶ": "oᴇ",
 "∞": "oo",
 "ꝏ": "oo",
 "ꚙ": "oo",
 "Ꝏ": "OO",
 "Ꚙ": "OO",
 "ﳗ": "oج",
 "ﱑ": "oج",
 "ﳘ": "oم",
 "ﱒ": "oم",
 "ﶓ": "oمج",
 "ﶔ": "oمم",
 "ﱓ": "oى",
 "ﱔ": "oى",
 "ൟ": "oരo",
 "တ": "oာ",
 "㍘": "O点",
 "ↄ": "ɔ",
 "ᴐ": "ɔ",
 "ͻ": "ɔ",
 "𐑋": "ɔ",
 "Ↄ": "Ɔ",
 "Ͻ": "Ɔ",
 "ꓛ": "Ɔ",
 "𐐣": "Ɔ",
 "ꬿ": "ɔ̸",
 "ꭢ": "ɔe",
 "𐐿": "ɷ",
 "⍴": "p",
 "ｐ": "p",
 "𝐩": "p",
 "𝑝": "p",
 "𝒑": "p",
 "𝓅": "p",
 "𝓹": "p",
 "𝔭": "p",
 "𝕡": "p",
 "𝖕": "p",
 "𝗉": "p",
 "𝗽": "p",
 "𝘱": "p",
 "𝙥": "p",
 "𝚙": "p",
 "ρ": "p",
 "ϱ": "p",
 "𝛒": "p",
 "𝛠": "p",
 "𝜌": "p",
 "𝜚": "p",
 "𝝆": "p",
 "𝝔": "p",
 "𝞀": "p",
 "𝞎": "p",
 "𝞺": "p",
 "𝟈": "p",
 "ⲣ": "p",
 "р": "p",
 "Ｐ": "P",
 "ℙ": "P",
 "𝐏": "P",
 "𝑃": "P",
 "𝑷": "P",
 "𝒫": "P",
 "𝓟": "P",
 "𝔓": "P",
 "𝕻": "P",
 "𝖯": "P",
 "𝗣": "P",
 "𝘗": "P",
 "𝙋": "P",
 "𝙿": "P",
 "Ρ": "P",
 "𝚸": "P",
 "𝛲": "P",
 "𝜬": "P",
 "𝝦": "P",
 "𝞠": "P",
 "Ⲣ": "P",
 "Р": "P",
 "Ꮲ": "P",
 "ᑭ": "P",
 "ꓑ": "P",
 "𐊕": "P",
 "ƥ": "p̔",
 "ᵽ": "p̵",
 "ᑷ": "p·",
 "ᒆ": "P'",
 "ᴩ": "ᴘ",
 "ꮲ": "ᴘ",
 "φ": "ɸ",
 "ϕ": "ɸ",
 "𝛗": "ɸ",
 "𝛟": "ɸ",
 "𝜑": "ɸ",
 "𝜙": "ɸ",
 "𝝋": "ɸ",
 "𝝓": "ɸ",
 "𝞅": "ɸ",
 "𝞍": "ɸ",
 "𝞿": "ɸ",
 "𝟇": "ɸ",
 "ⲫ": "ɸ",
 "ф": "ɸ",
 "𝐪": "q",
 "𝑞": "q",
 "𝒒": "q",
 "𝓆": "q",
 "𝓺": "q",
 "𝔮": "q",
 "𝕢": "q",
 "𝖖": "q",
 "𝗊": "q",
 "𝗾": "q",
 "𝘲": "q",
 "𝙦": "q",
 "𝚚": "q",
 "ԛ": "q",
 "գ": "q",
 "զ": "q",
 "ℚ": "Q",
 "𝐐": "Q",
 "𝑄": "Q",
 "𝑸": "Q",
 "𝒬": "Q",
 "𝓠": "Q",
 "𝔔": "Q",
 "𝕼": "Q",
 "𝖰": "Q",
 "𝗤": "Q",
 "𝘘": "Q",
 "𝙌": "Q",
 "𝚀": "Q",
 "ⵕ": "Q",
 "ʠ": "q̔",
 "🜀": "QE",
 "ᶐ": "ɋ",
 "ᴋ": "ĸ",
 "κ": "ĸ",
 "ϰ": "ĸ",
 "𝛋": "ĸ",
 "𝛞": "ĸ",
 "𝜅": "ĸ",
 "𝜘": "ĸ",
 "𝜿": "ĸ",
 "𝝒": "ĸ",
 "𝝹": "ĸ",
 "𝞌": "ĸ",
 "𝞳": "ĸ",
 "𝟆": "ĸ",
 "ⲕ": "ĸ",
 "к": "ĸ",
 "ꮶ": "ĸ",
 "қ": "ĸ̩",
 "ҟ": "ĸ̵",
 "𝐫": "r",
 "𝑟": "r",
 "𝒓": "r",
 "𝓇": "r",
 "𝓻": "r",
 "𝔯": "r",
 "𝕣": "r",
 "𝖗": "r",
 "𝗋": "r",
 "𝗿": "r",
 "𝘳": "r",
 "𝙧": "r",
 "𝚛": "r",
 "ꭇ": "r",
 "ꭈ": "r",
 "ᴦ": "r",
 "ⲅ": "r",
 "г": "r",
 "ꮁ": "r",
 "𝈖": "R",
 "ℛ": "R",
 "ℜ": "R",
 "ℝ": "R",
 "𝐑": "R",
 "𝑅": "R",
 "𝑹": "R",
 "𝓡": "R",
 "𝕽": "R",
 "𝖱": "R",
 "𝗥": "R",
 "𝘙": "R",
 "𝙍": "R",
 "𝚁": "R",
 "Ʀ": "R",
 "Ꭱ": "R",
 "Ꮢ": "R",
 "𐒴": "R",
 "ᖇ": "R",
 "ꓣ": "R",
 "𖼵": "R",
 "ɽ": "r̨",
 "ɼ": "r̩",
 "ɍ": "r̵",
 "ғ": "r̵",
 "ᵲ": "r̴",
 "ґ": "r'",
 "𑣣": "rn",
 "m": "rn",
 "ⅿ": "rn",
 "𝐦": "rn",
 "𝑚": "rn",
 "𝒎": "rn",
 "𝓂": "rn",
 "𝓶": "rn",
 "𝔪": "rn",
 "𝕞": "rn",
 "𝖒": "rn",
 "𝗆": "rn",
 "𝗺": "rn",
 "𝘮": "rn",
 "𝙢": "rn",
 "𝚖": "rn",
 "𑜀": "rn",
 "₥": "rn̸",
 "ɱ": "rn̦",
 "ᵯ": "rn̴",
 "₨": "Rs",
 "ꭱ": "ʀ",
 "ꮢ": "ʀ",
 "я": "ᴙ",
 "ᵳ": "ɾ̴",
 "℩": "ɿ",
 "ｓ": "s",
 "𝐬": "s",
 "𝑠": "s",
 "𝒔": "s",
 "𝓈": "s",
 "𝓼": "s",
 "𝔰": "s",
 "𝕤": "s",
 "𝖘": "s",
 "𝗌": "s",
 "𝘀": "s",
 "𝘴": "s",
 "𝙨": "s",
 "𝚜": "s",
 "ꜱ": "s",
 "ƽ": "s",
 "ѕ": "s",
 "ꮪ": "s",
 "𑣁": "s",
 "𐑈": "s",
 "Ｓ": "S",
 "𝐒": "S",
 "𝑆": "S",
 "𝑺": "S",
 "𝒮": "S",
 "𝓢": "S",
 "𝔖": "S",
 "𝕊": "S",
 "𝕾": "S",
 "𝖲": "S",
 "𝗦": "S",
 "𝘚": "S",
 "𝙎": "S",
 "𝚂": "S",
 "Ѕ": "S",
 "Տ": "S",
 "Ꮥ": "S",
 "Ꮪ": "S",
 "ꓢ": "S",
 "𖼺": "S",
 "𐊖": "S",
 "𐐠": "S",
 "ʂ": "s̨",
 "ᵴ": "s̴",
 "ꞵ": "ß",
 "β": "ß",
 "ϐ": "ß",
 "𝛃": "ß",
 "𝛽": "ß",
 "𝜷": "ß",
 "𝝱": "ß",
 "𝞫": "ß",
 "Ᏸ": "ß",
 "🝜": "sss",
 "ﬆ": "st",
 "∫": "ʃ",
 "ꭍ": "ʃ",
 "∑": "Ʃ",
 "⅀": "Ʃ",
 "Σ": "Ʃ",
 "𝚺": "Ʃ",
 "𝛴": "Ʃ",
 "𝜮": "Ʃ",
 "𝝨": "Ʃ",
 "𝞢": "Ʃ",
 "ⵉ": "Ʃ",
 "∬": "ʃʃ",
 "∭": "ʃʃʃ",
 "⨌": "ʃʃʃʃ",
 "𝐭": "t",
 "𝑡": "t",
 "𝒕": "t",
 "𝓉": "t",
 "𝓽": "t",
 "𝔱": "t",
 "𝕥": "t",
 "𝖙": "t",
 "𝗍": "t",
 "𝘁": "t",
 "𝘵": "t",
 "𝙩": "t",
 "𝚝": "t",
 "⊤": "T",
 "⟙": "T",
 "🝨": "T",
 "Ｔ": "T",
 "𝐓": "T",
 "𝑇": "T",
 "𝑻": "T",
 "𝒯": "T",
 "𝓣": "T",
 "𝔗": "T",
 "𝕋": "T",
 "𝕿": "T",
 "𝖳": "T",
 "𝗧": "T",
 "𝘛": "T",
 "𝙏": "T",
 "𝚃": "T",
 "Τ": "T",
 "𝚻": "T",
 "𝛵": "T",
 "𝜯": "T",
 "𝝩": "T",
 "𝞣": "T",
 "Ⲧ": "T",
 "Т": "T",
 "Ꭲ": "T",
 "ꓔ": "T",
 "𖼊": "T",
 "𑢼": "T",
 "𐊗": "T",
 "𐊱": "T",
 "𐌕": "T",
 "ƭ": "t̔",
 "⍡": "T̈",
 "Ⱦ": "T̸",
 "Ț": "Ţ",
 "Ʈ": "T̨",
 "Ҭ": "T̩",
 "₮": "T⃫",
 "ŧ": "t̵",
 "Ŧ": "T̵",
 "ᵵ": "t̴",
 "Ⴀ": "Ꞇ",
 "Ꜩ": "T3",
 "ʨ": "tɕ",
 "℡": "TEL",
 "ꝷ": "tf",
 "ʦ": "ts",
 "ʧ": "tʃ",
 "ꜩ": "tȝ",
 "τ": "ᴛ",
 "𝛕": "ᴛ",
 "𝜏": "ᴛ",
 "𝝉": "ᴛ",
 "𝞃": "ᴛ",
 "𝞽": "ᴛ",
 "т": "ᴛ",
 "ꭲ": "ᴛ",
 "ҭ": "ᴛ̩",
 "ţ": "ƫ",
 "ț": "ƫ",
 "Ꮏ": "ƫ",
 "𝐮": "u",
 "𝑢": "u",
 "𝒖": "u",
 "𝓊": "u",
 "𝓾": "u",
 "𝔲": "u",
 "𝕦": "u",
 "𝖚": "u",
 "𝗎": "u",
 "𝘂": "u",
 "𝘶": "u",
 "𝙪": "u",
 "𝚞": "u",
 "ꞟ": "u",
 "ᴜ": "u",
 "ꭎ": "u",
 "ꭒ": "u",
 "ʋ": "u",
 "υ": "u",
 "𝛖": "u",
 "𝜐": "u",
 "𝝊": "u",
 "𝞄": "u",
 "𝞾": "u",
 "ս": "u",
 "𐓶": "u",
 "𑣘": "u",
 "∪": "U",
 "⋃": "U",
 "𝐔": "U",
 "𝑈": "U",
 "𝑼": "U",
 "𝒰": "U",
 "𝓤": "U",
 "𝔘": "U",
 "𝕌": "U",
 "𝖀": "U",
 "𝖴": "U",
 "𝗨": "U",
 "𝘜": "U",
 "𝙐": "U",
 "𝚄": "U",
 "Ս": "U",
 "ሀ": "U",
 "𐓎": "U",
 "ᑌ": "U",
 "ꓴ": "U",
 "𖽂": "U",
 "𑢸": "U",
 "ǔ": "ŭ",
 "Ǔ": "Ŭ",
 "ᵾ": "u̵",
 "ꮜ": "u̵",
 "Ʉ": "U̵",
 "Ꮜ": "U̵",
 "ᑘ": "U·",
 "ᑧ": "U'",
 "ᵫ": "ue",
 "ꭣ": "uo",
 "ṃ": "ꭑ",
 "պ": "ɰ",
 "ሣ": "ɰ",
 "℧": "Ʊ",
 "ᘮ": "Ʊ",
 "ᘴ": "Ʊ",
 "ᵿ": "ʊ̵",
 "∨": "v",
 "⋁": "v",
 "ｖ": "v",
 "ⅴ": "v",
 "𝐯": "v",
 "𝑣": "v",
 "𝒗": "v",
 "𝓋": "v",
 "𝓿": "v",
 "𝔳": "v",
 "𝕧": "v",
 "𝖛": "v",
 "𝗏": "v",
 "𝘃": "v",
 "𝘷": "v",
 "𝙫": "v",
 "𝚟": "v",
 "ᴠ": "v",
 "ν": "v",
 "𝛎": "v",
 "𝜈": "v",
 "𝝂": "v",
 "𝝼": "v",
 "𝞶": "v",
 "ѵ": "v",
 "ט": "v",
 "𑜆": "v",
 "ꮩ": "v",
 "𑣀": "v",
 "𝈍": "V",
 "٧": "V",
 "۷": "V",
 "Ⅴ": "V",
 "𝐕": "V",
 "𝑉": "V",
 "𝑽": "V",
 "𝒱": "V",
 "𝓥": "V",
 "𝔙": "V",
 "𝕍": "V",
 "𝖁": "V",
 "𝖵": "V",
 "𝗩": "V",
 "𝘝": "V",
 "𝙑": "V",
 "𝚅": "V",
 "Ѵ": "V",
 "ⴸ": "V",
 "Ꮩ": "V",
 "ᐯ": "V",
 "ꛟ": "V",
 "ꓦ": "V",
 "𖼈": "V",
 "𑢠": "V",
 "𐔝": "V",
 "𐆗": "V̵",
 "ᐻ": "V·",
 "🝬": "VB",
 "ⅵ": "vi",
 "ⅶ": "vii",
 "ⅷ": "viii",
 "Ⅵ": "Vl",
 "Ⅶ": "Vll",
 "Ⅷ": "Vlll",
 "🜈": "Vᷤ",
 "ᴧ": "ʌ",
 "𐓘": "ʌ",
 "٨": "Ʌ",
 "۸": "Ʌ",
 "Λ": "Ʌ",
 "𝚲": "Ʌ",
 "𝛬": "Ʌ",
 "𝜦": "Ʌ",
 "𝝠": "Ʌ",
 "𝞚": "Ʌ",
 "Л": "Ʌ",
 "ⴷ": "Ʌ",
 "𐒰": "Ʌ",
 "ᐱ": "Ʌ",
 "ꛎ": "Ʌ",
 "ꓥ": "Ʌ",
 "𖼽": "Ʌ",
 "𐊍": "Ʌ",
 "Ӆ": "Ʌ̦",
 "ᐽ": "Ʌ·",
 "ɯ": "w",
 "𝐰": "w",
 "𝑤": "w",
 "𝒘": "w",
 "𝓌": "w",
 "𝔀": "w",
 "𝔴": "w",
 "𝕨": "w",
 "𝖜": "w",
 "𝗐": "w",
 "𝘄": "w",
 "𝘸": "w",
 "𝙬": "w",
 "𝚠": "w",
 "ᴡ": "w",
 "ѡ": "w",
 "ԝ": "w",
 "ա": "w",
 "𑜊": "w",
 "𑜎": "w",
 "𑜏": "w",
 "ꮃ": "w",
 "𑣯": "W",
 "𑣦": "W",
 "𝐖": "W",
 "𝑊": "W",
 "𝑾": "W",
 "𝒲": "W",
 "𝓦": "W",
 "𝔚": "W",
 "𝕎": "W",
 "𝖂": "W",
 "𝖶": "W",
 "𝗪": "W",
 "𝘞": "W",
 "𝙒": "W",
 "𝚆": "W",
 "Ԝ": "W",
 "Ꮃ": "W",
 "Ꮤ": "W",
 "ꓪ": "W",
 "ѽ": "w҆҇",
 "𑓅": "ẇ",
 "₩": "W̵",
 "ꝡ": "w̦",
 "ᴍ": "ʍ",
 "м": "ʍ",
 "ꮇ": "ʍ",
 "ӎ": "ʍ̦",
 "᙮": "x",
 "×": "x",
 "⤫": "x",
 "⤬": "x",
 "⨯": "x",
 "ｘ": "x",
 "ⅹ": "x",
 "𝐱": "x",
 "𝑥": "x",
 "𝒙": "x",
 "𝓍": "x",
 "𝔁": "x",
 "𝔵": "x",
 "𝕩": "x",
 "𝖝": "x",
 "𝗑": "x",
 "𝘅": "x",
 "𝘹": "x",
 "𝙭": "x",
 "𝚡": "x",
 "х": "x",
 "ᕁ": "x",
 "ᕽ": "x",
 "ⷯ": "ͯ",
 "᙭": "X",
 "╳": "X",
 "𐌢": "X",
 "𑣬": "X",
 "Ｘ": "X",
 "Ⅹ": "X",
 "𝐗": "X",
 "𝑋": "X",
 "𝑿": "X",
 "𝒳": "X",
 "𝓧": "X",
 "𝔛": "X",
 "𝕏": "X",
 "𝖃": "X",
 "𝖷": "X",
 "𝗫": "X",
 "𝘟": "X",
 "𝙓": "X",
 "𝚇": "X",
 "Ꭓ": "X",
 "Χ": "X",
 "𝚾": "X",
 "𝛸": "X",
 "𝜲": "X",
 "𝝬": "X",
 "𝞦": "X",
 "Ⲭ": "X",
 "Х": "X",
 "ⵝ": "X",
 "ᚷ": "X",
 "ꓫ": "X",
 "𐊐": "X",
 "𐊴": "X",
 "𐌗": "X",
 "𐔧": "X",
 "⨰": "ẋ",
 "Ҳ": "X̩",
 "𐆖": "X̵",
 "ⅺ": "xi",
 "ⅻ": "xii",
 "Ⅺ": "Xl",
 "Ⅻ": "Xll",
 "ɣ": "y",
 "ᶌ": "y",
 "ｙ": "y",
 "𝐲": "y",
 "𝑦": "y",
 "𝒚": "y",
 "𝓎": "y",
 "𝔂": "y",
 "𝔶": "y",
 "𝕪": "y",
 "𝖞": "y",
 "𝗒": "y",
 "𝘆": "y",
 "𝘺": "y",
 "𝙮": "y",
 "𝚢": "y",
 "ʏ": "y",
 "ỿ": "y",
 "ꭚ": "y",
 "γ": "y",
 "ℽ": "y",
 "𝛄": "y",
 "𝛾": "y",
 "𝜸": "y",
 "𝝲": "y",
 "𝞬": "y",
 "у": "y",
 "ү": "y",
 "ყ": "y",
 "𑣜": "y",
 "Ｙ": "Y",
 "𝐘": "Y",
 "𝑌": "Y",
 "𝒀": "Y",
 "𝒴": "Y",
 "𝓨": "Y",
 "𝔜": "Y",
 "𝕐": "Y",
 "𝖄": "Y",
 "𝖸": "Y",
 "𝗬": "Y",
 "𝘠": "Y",
 "𝙔": "Y",
 "𝚈": "Y",
 "Υ": "Y",
 "ϒ": "Y",
 "𝚼": "Y",
 "𝛶": "Y",
 "𝜰": "Y",
 "𝝪": "Y",
 "𝞤": "Y",
 "Ⲩ": "Y",
 "У": "Y",
 "Ү": "Y",
 "Ꭹ": "Y",
 "Ꮍ": "Y",
 "ꓬ": "Y",
 "𖽃": "Y",
 "𑢤": "Y",
 "𐊲": "Y",
 "ƴ": "y̔",
 "ɏ": "y̵",
 "ұ": "y̵",
 "¥": "Y̵",
 "Ɏ": "Y̵",
 "Ұ": "Y̵",
 "ʒ": "ȝ",
 "ꝫ": "ȝ",
 "ⳍ": "ȝ",
 "ӡ": "ȝ",
 "ჳ": "ȝ",
 "𝐳": "z",
 "𝑧": "z",
 "𝒛": "z",
 "𝓏": "z",
 "𝔃": "z",
 "𝔷": "z",
 "𝕫": "z",
 "𝖟": "z",
 "𝗓": "z",
 "𝘇": "z",
 "𝘻": "z",
 "𝙯": "z",
 "𝚣": "z",
 "ᴢ": "z",
 "ꮓ": "z",
 "𑣄": "z",
 "𐋵": "Z",
 "𑣥": "Z",
 "Ｚ": "Z",
 "ℤ": "Z",
 "ℨ": "Z",
 "𝐙": "Z",
 "𝑍": "Z",
 "𝒁": "Z",
 "𝒵": "Z",
 "𝓩": "Z",
 "𝖅": "Z",
 "𝖹": "Z",
 "𝗭": "Z",
 "𝘡": "Z",
 "𝙕": "Z",
 "𝚉": "Z",
 "Ζ": "Z",
 "𝚭": "Z",
 "𝛧": "Z",
 "𝜡": "Z",
 "𝝛": "Z",
 "𝞕": "Z",
 "Ꮓ": "Z",
 "ꓜ": "Z",
 "𑢩": "Z",
 "ʐ": "z̨",
 "ƶ": "z̵",
 "Ƶ": "Z̵",
 "ȥ": "z̦",
 "Ȥ": "Z̦",
 "ᵶ": "z̴",
 "ƿ": "þ",
 "ϸ": "þ",
 "Ϸ": "Þ",
 "𐓄": "Þ",
 "⁹": "ꝰ",
 "ᴤ": "ƨ",
 "ϩ": "ƨ",
 "ꙅ": "ƨ",
 "ь": "ƅ",
 "ꮟ": "ƅ",
 "ы": "ƅi",
 "ꭾ": "ɂ",
 "ˤ": "ˁ",
 "ꛍ": "ʡ",
 "⊙": "ʘ",
 "☉": "ʘ",
 "⨀": "ʘ",
 "Ꙩ": "ʘ",
 "ⵙ": "ʘ",
 "𐓃": "ʘ",
 "ℾ": "Γ",
 "𝚪": "Γ",
 "𝛤": "Γ",
 "𝜞": "Γ",
 "𝝘": "Γ",
 "𝞒": "Γ",
 "Ⲅ": "Γ",
 "Г": "Γ",
 "Ꮁ": "Γ",
 "ᒥ": "Γ",
 "𖼇": "Γ",
 "Ғ": "Γ̵",
 "ᒯ": "Γ·",
 "Ґ": "Γ'",
 "∆": "Δ",
 "△": "Δ",
 "🜂": "Δ",
 "𝚫": "Δ",
 "𝛥": "Δ",
 "𝜟": "Δ",
 "𝝙": "Δ",
 "𝞓": "Δ",
 "Ⲇ": "Δ",
 "ⵠ": "Δ",
 "ᐃ": "Δ",
 "𖼚": "Δ",
 "𐊅": "Δ",
 "𐊣": "Δ",
 "⍙": "Δ̲",
 "ᐏ": "Δ·",
 "ᐬ": "Δᐠ",
 "𝟋": "ϝ",
 "𝛇": "ζ",
 "𝜁": "ζ",
 "𝜻": "ζ",
 "𝝵": "ζ",
 "𝞯": "ζ",
 "ⳤ": "ϗ",
 "𝛌": "λ",
 "𝜆": "λ",
 "𝝀": "λ",
 "𝝺": "λ",
 "𝞴": "λ",
 "Ⲗ": "λ",
 "𐓛": "λ",
 "µ": "μ",
 "𝛍": "μ",
 "𝜇": "μ",
 "𝝁": "μ",
 "𝝻": "μ",
 "𝞵": "μ",
 "𝛏": "ξ",
 "𝜉": "ξ",
 "𝝃": "ξ",
 "𝝽": "ξ",
 "𝞷": "ξ",
 "𝚵": "Ξ",
 "𝛯": "Ξ",
 "𝜩": "Ξ",
 "𝝣": "Ξ",
 "𝞝": "Ξ",
 "ϖ": "π",
 "ℼ": "π",
 "𝛑": "π",
 "𝛡": "π",
 "𝜋": "π",
 "𝜛": "π",
 "𝝅": "π",
 "𝝕": "π",
 "𝝿": "π",
 "𝞏": "π",
 "𝞹": "π",
 "𝟉": "π",
 "ᴨ": "π",
 "п": "π",
 "∏": "Π",
 "ℿ": "Π",
 "𝚷": "Π",
 "𝛱": "Π",
 "𝜫": "Π",
 "𝝥": "Π",
 "𝞟": "Π",
 "Ⲡ": "Π",
 "П": "Π",
 "ꛛ": "Π",
 "𐊭": "Ϙ",
 "𐌒": "Ϙ",
 "ϛ": "ς",
 "𝛓": "ς",
 "𝜍": "ς",
 "𝝇": "ς",
 "𝞁": "ς",
 "𝞻": "ς",
 "𝚽": "Φ",
 "𝛷": "Φ",
 "𝜱": "Φ",
 "𝝫": "Φ",
 "𝞥": "Φ",
 "Ⲫ": "Φ",
 "Ф": "Φ",
 "Փ": "Φ",
 "ቀ": "Φ",
 "ᛰ": "Φ",
 "𐊳": "Φ",
 "ꭓ": "χ",
 "ꭕ": "χ",
 "𝛘": "χ",
 "𝜒": "χ",
 "𝝌": "χ",
 "𝞆": "χ",
 "𝟀": "χ",
 "ⲭ": "χ",
 "𝛙": "ψ",
 "𝜓": "ψ",
 "𝝍": "ψ",
 "𝞇": "ψ",
 "𝟁": "ψ",
 "ѱ": "ψ",
 "𐓹": "ψ",
 "𝚿": "Ψ",
 "𝛹": "Ψ",
 "𝜳": "Ψ",
 "𝝭": "Ψ",
 "𝞧": "Ψ",
 "Ⲯ": "Ψ",
 "Ѱ": "Ψ",
 "𐓑": "Ψ",
 "ᛘ": "Ψ",
 "𐊵": "Ψ",
 "⍵": "ω",
 "ꞷ": "ω",
 "𝛚": "ω",
 "𝜔": "ω",
 "𝝎": "ω",
 "𝞈": "ω",
 "𝟂": "ω",
 "ⲱ": "ω",
 "ꙍ": "ω",
 "Ω": "Ω",
 "𝛀": "Ω",
 "𝛺": "Ω",
 "𝜴": "Ω",
 "𝝮": "Ω",
 "𝞨": "Ω",
 "ᘯ": "Ω",
 "ᘵ": "Ω",
 "𐊶": "Ω",
 "⍹": "ω̲",
 "ώ": "ῴ",
 "☰": "Ⲷ",
 "Ⳝ": "Ϭ",
 "җ": "ж̩",
 "Җ": "Ж̩",
 "𝈋": "И",
 "Ͷ": "И",
 "ꚡ": "И",
 "𐐥": "И",
 "Й": "Ѝ",
 "Ҋ": "Ѝ̦",
 "ѝ": "й",
 "ҋ": "й̦",
 "𐒼": "Ӄ",
 "ᴫ": "л",
 "ӆ": "л̦",
 "ꭠ": "љ",
 "𐓫": "ꙩ",
 "ᷮ": "ⷬ",
 "𐓍": "Ћ",
 "𝈂": "Ӿ",
 "𝈢": "Ѡ",
 "Ꮗ": "Ѡ",
 "ᗯ": "Ѡ",
 "Ѽ": "Ѡ҆҇",
 "ᣭ": "Ѡ·",
 "Ꞷ": "Ꙍ",
 "ӌ": "ҷ",
 "Ӌ": "Ҷ",
 "Ҿ": "Ҽ̨",
 "ⲽ": "ш",
 "Ⲽ": "Ш",
 "Ꙑ": "Ъl",
 "℈": "Э",
 "🜁": "Ꙙ",
 "𖼜": "Ꙙ",
 "ꦒ": "ⰿ",
 "և": "եւ",
 "ኔ": "ձ",
 "ﬔ": "մե",
 "ﬕ": "մի",
 "ﬗ": "մխ",
 "ﬓ": "մն",
 "∩": "Ո",
 "⋂": "Ո",
 "𝉅": "Ո",
 "በ": "Ո",
 "ᑎ": "Ո",
 "ꓵ": "Ո",
 "ᑚ": "Ո·",
 "ᑨ": "Ո'",
 "ﬖ": "վն",
 "₽": "Ք",
 "˓": "ՙ",
 "ʿ": "ՙ",
 "ℵ": "א",
 "ﬡ": "א",
 "אָ": "אַ",
 "אּ": "אַ",
 "ﭏ": "אל",
 "ℶ": "ב",
 "ℷ": "ג",
 "ℸ": "ד",
 "ﬢ": "ד",
 "ﬣ": "ה",
 "יּ": "יִ",
 "ﬤ": "כ",
 "ﬥ": "ל",
 "ﬦ": "ם",
 "ﬠ": "ע",
 "ﬧ": "ר",
 "שׂ": "שׁ",
 "שּ": "שׁ",
 "שּׂ": "שּׁ",
 "ﬨ": "ת",
 "ﺀ": "ء",
 "۽": "ء͈",
 "ﺂ": "آ",
 "ﺁ": "آ",
 "ﭑ": "ٱ",
 "ﭐ": "ٱ",
 "𞸁": "ب",
 "𞸡": "ب",
 "𞹡": "ب",
 "𞺁": "ب",
 "𞺡": "ب",
 "ﺑ": "ب",
 "ﺒ": "ب",
 "ﺐ": "ب",
 "ﺏ": "ب",
 "ݑ": "بۛ",
 "ࢶ": "بۢ",
 "ࢡ": "بٔ",
 "ﲠ": "بo",
 "ﳢ": "بo",
 "ﲜ": "بج",
 "ﰅ": "بج",
 "ﲝ": "بح",
 "ﰆ": "بح",
 "ﷂ": "بحى",
 "ﲞ": "بخ",
 "ﰇ": "بخ",
 "ﳒ": "بخ",
 "ﱋ": "بخ",
 "ﶞ": "بخى",
 "ﱪ": "بر",
 "ﱫ": "بز",
 "ﲟ": "بم",
 "ﳡ": "بم",
 "ﱬ": "بم",
 "ﰈ": "بم",
 "ﱭ": "بن",
 "ﱮ": "بى",
 "ﰉ": "بى",
 "ﱯ": "بى",
 "ﰊ": "بى",
 "ﭔ": "ٻ",
 "ﭕ": "ٻ",
 "ﭓ": "ٻ",
 "ﭒ": "ٻ",
 "ې": "ٻ",
 "ﯦ": "ٻ",
 "ﯧ": "ٻ",
 "ﯥ": "ٻ",
 "ﯤ": "ٻ",
 "ﭜ": "ڀ",
 "ﭝ": "ڀ",
 "ﭛ": "ڀ",
 "ﭚ": "ڀ",
 "ࢩ": "ݔ",
 "ݧ": "ݔ",
 "ö": "ة",
 "ﺔ": "ة",
 "ﺓ": "ة",
 "ۃ": "ة",
 "𞸕": "ت",
 "𞸵": "ت",
 "𞹵": "ت",
 "𞺕": "ت",
 "𞺵": "ت",
 "ﺗ": "ت",
 "ﺘ": "ت",
 "ﺖ": "ت",
 "ﺕ": "ت",
 "ﲥ": "تo",
 "ﳤ": "تo",
 "ﲡ": "تج",
 "ﰋ": "تج",
 "ﵐ": "تجم",
 "ﶠ": "تجى",
 "ﶟ": "تجى",
 "ﲢ": "تح",
 "ﰌ": "تح",
 "ﵒ": "تحج",
 "ﵑ": "تحج",
 "ﵓ": "تحم",
 "ﲣ": "تخ",
 "ﰍ": "تخ",
 "ﵔ": "تخم",
 "ﶢ": "تخى",
 "ﶡ": "تخى",
 "ﱰ": "تر",
 "ﱱ": "تز",
 "ﲤ": "تم",
 "ﳣ": "تم",
 "ﱲ": "تم",
 "ﰎ": "تم",
 "ﵕ": "تمج",
 "ﵖ": "تمح",
 "ﵗ": "تمخ",
 "ﶤ": "تمى",
 "ﶣ": "تمى",
 "ﱳ": "تن",
 "ﱴ": "تى",
 "ﰏ": "تى",
 "ﱵ": "تى",
 "ﰐ": "تى",
 "ﭠ": "ٺ",
 "ﭡ": "ٺ",
 "ﭟ": "ٺ",
 "ﭞ": "ٺ",
 "ﭤ": "ٿ",
 "ﭥ": "ٿ",
 "ﭣ": "ٿ",
 "ﭢ": "ٿ",
 "𞸂": "ج",
 "𞸢": "ج",
 "𞹂": "ج",
 "𞹢": "ج",
 "𞺂": "ج",
 "𞺢": "ج",
 "ﺟ": "ج",
 "ﺠ": "ج",
 "ﺞ": "ج",
 "ﺝ": "ج",
 "ﲧ": "جح",
 "ﰕ": "جح",
 "ﶦ": "جحى",
 "ﶾ": "جحى",
 "ﷻ": "جل جلlلo",
 "ﲨ": "جم",
 "ﰖ": "جم",
 "ﵙ": "جمح",
 "ﵘ": "جمح",
 "ﶧ": "جمى",
 "ﶥ": "جمى",
 "ﴝ": "جى",
 "ﴁ": "جى",
 "ﴞ": "جى",
 "ﴂ": "جى",
 "ﭸ": "ڃ",
 "ﭹ": "ڃ",
 "ﭷ": "ڃ",
 "ﭶ": "ڃ",
 "ﭴ": "ڄ",
 "ﭵ": "ڄ",
 "ﭳ": "ڄ",
 "ﭲ": "ڄ",
 "ﭼ": "چ",
 "ﭽ": "چ",
 "ﭻ": "چ",
 "ﭺ": "چ",
 "ﮀ": "ڇ",
 "ﮁ": "ڇ",
 "ﭿ": "ڇ",
 "ﭾ": "ڇ",
 "𞸇": "ح",
 "𞸧": "ح",
 "𞹇": "ح",
 "𞹧": "ح",
 "𞺇": "ح",
 "𞺧": "ح",
 "ﺣ": "ح",
 "ﺤ": "ح",
 "ﺢ": "ح",
 "ﺡ": "ح",
 "څ": "حۛ",
 "ځ": "حٔ",
 "ݲ": "حٔ",
 "ﲩ": "حج",
 "ﰗ": "حج",
 "ﶿ": "حجى",
 "ﲪ": "حم",
 "ﰘ": "حم",
 "ﵛ": "حمى",
 "ﵚ": "حمى",
 "ﴛ": "حى",
 "ﳿ": "حى",
 "ﴜ": "حى",
 "ﴀ": "حى",
 "𞸗": "خ",
 "𞸷": "خ",
 "𞹗": "خ",
 "𞹷": "خ",
 "𞺗": "خ",
 "𞺷": "خ",
 "ﺧ": "خ",
 "ﺨ": "خ",
 "ﺦ": "خ",
 "ﺥ": "خ",
 "ﲫ": "خج",
 "ﰙ": "خج",
 "ﰚ": "خح",
 "ﲬ": "خم",
 "ﰛ": "خم",
 "ﴟ": "خى",
 "ﴃ": "خى",
 "ﴠ": "خى",
 "ﴄ": "خى",
 "𐋡": "د",
 "𞸃": "د",
 "𞺃": "د",
 "𞺣": "د",
 "ﺪ": "د",
 "ﺩ": "د",
 "ڈ": "دؕ",
 "ﮉ": "دؕ",
 "ﮈ": "دؕ",
 "ڎ": "دۛ",
 "ﮇ": "دۛ",
 "ﮆ": "دۛ",
 "ۮ": "د̂",
 "ࢮ": "د̤̣",
 "𞸘": "ذ",
 "𞺘": "ذ",
 "𞺸": "ذ",
 "ﺬ": "ذ",
 "ﺫ": "ذ",
 "ﱛ": "ذٰ",
 "ڋ": "ڊؕ",
 "ﮅ": "ڌ",
 "ﮄ": "ڌ",
 "ﮃ": "ڍ",
 "ﮂ": "ڍ",
 "𞸓": "ر",
 "𞺓": "ر",
 "𞺳": "ر",
 "ﺮ": "ر",
 "ﺭ": "ر",
 "ڑ": "رؕ",
 "ﮍ": "رؕ",
 "ﮌ": "رؕ",
 "ژ": "رۛ",
 "ﮋ": "رۛ",
 "ﮊ": "رۛ",
 "ڒ": "ر̆",
 "ࢹ": "ر̆̇",
 "ۯ": "ر̂",
 "ݬ": "رٔ",
 "ﱜ": "رٰ",
 "ﷶ": "رسول",
 "﷼": "رىlل",
 "𞸆": "ز",
 "𞺆": "ز",
 "𞺦": "ز",
 "ﺰ": "ز",
 "ﺯ": "ز",
 "ࢲ": "ز̂",
 "ݱ": "ڗؕ",
 "𞸎": "س",
 "𞸮": "س",
 "𞹎": "س",
 "𞹮": "س",
 "𞺎": "س",
 "𞺮": "س",
 "ﺳ": "س",
 "ﺴ": "س",
 "ﺲ": "س",
 "ﺱ": "س",
 "ش": "سۛ",
 "𞸔": "سۛ",
 "𞸴": "سۛ",
 "𞹔": "سۛ",
 "𞹴": "سۛ",
 "𞺔": "سۛ",
 "𞺴": "سۛ",
 "ﺷ": "سۛ",
 "ﺸ": "سۛ",
 "ﺶ": "سۛ",
 "ﺵ": "سۛ",
 "ݾ": "س̂",
 "ﴱ": "سo",
 "ﳨ": "سo",
 "ﴲ": "سۛo",
 "ﳪ": "سۛo",
 "ﲭ": "سج",
 "ﴴ": "سج",
 "ﰜ": "سج",
 "ﴭ": "سۛج",
 "ﴷ": "سۛج",
 "ﴥ": "سۛج",
 "ﴉ": "سۛج",
 "ﵝ": "سجح",
 "ﵞ": "سجى",
 "ﵩ": "سۛجى",
 "ﲮ": "سح",
 "ﴵ": "سح",
 "ﰝ": "سح",
 "ﴮ": "سۛح",
 "ﴸ": "سۛح",
 "ﴦ": "سۛح",
 "ﴊ": "سۛح",
 "ﵜ": "سحج",
 "ﵨ": "سۛحم",
 "ﵧ": "سۛحم",
 "ﶪ": "سۛحى",
 "ﲯ": "سخ",
 "ﴶ": "سخ",
 "ﰞ": "سخ",
 "ﴯ": "سۛخ",
 "ﴹ": "سۛخ",
 "ﴧ": "سۛخ",
 "ﴋ": "سۛخ",
 "ﶨ": "سخى",
 "ﷆ": "سخى",
 "ﴪ": "سر",
 "ﴎ": "سر",
 "ﴩ": "سۛر",
 "ﴍ": "سۛر",
 "ﲰ": "سم",
 "ﳧ": "سم",
 "ﰟ": "سم",
 "ﴰ": "سۛم",
 "ﳩ": "سۛم",
 "ﴨ": "سۛم",
 "ﴌ": "سۛم",
 "ﵡ": "سمج",
 "ﵠ": "سمح",
 "ﵟ": "سمح",
 "ﵫ": "سۛمخ",
 "ﵪ": "سۛمخ",
 "ﵣ": "سمم",
 "ﵢ": "سمم",
 "ﵭ": "سۛمم",
 "ﵬ": "سۛمم",
 "ﴗ": "سى",
 "ﳻ": "سى",
 "ﴘ": "سى",
 "ﳼ": "سى",
 "ﴙ": "سۛى",
 "ﳽ": "سۛى",
 "ﴚ": "سۛى",
 "ﳾ": "سۛى",
 "𐋲": "ص",
 "𞸑": "ص",
 "𞸱": "ص",
 "𞹑": "ص",
 "𞹱": "ص",
 "𞺑": "ص",
 "𞺱": "ص",
 "ﺻ": "ص",
 "ﺼ": "ص",
 "ﺺ": "ص",
 "ﺹ": "ص",
 "ڞ": "صۛ",
 "ࢯ": "ص̤̣",
 "ﲱ": "صح",
 "ﰠ": "صح",
 "ﵥ": "صحح",
 "ﵤ": "صحح",
 "ﶩ": "صحى",
 "ﲲ": "صخ",
 "ﴫ": "صر",
 "ﴏ": "صر",
 "ﷵ": "صلعم",
 "ﷹ": "صلى",
 "ﷰ": "صلى",
 "ﷺ": "صلى lللo علىo وسلم",
 "ﲳ": "صم",
 "ﰡ": "صم",
 "ﷅ": "صمم",
 "ﵦ": "صمم",
 "ﴡ": "صى",
 "ﴅ": "صى",
 "ﴢ": "صى",
 "ﴆ": "صى",
 "𞸙": "ض",
 "𞸹": "ض",
 "𞹙": "ض",
 "𞹹": "ض",
 "𞺙": "ض",
 "𞺹": "ض",
 "ﺿ": "ض",
 "ﻀ": "ض",
 "ﺾ": "ض",
 "ﺽ": "ض",
 "ﲴ": "ضج",
 "ﰢ": "ضج",
 "ﲵ": "ضح",
 "ﰣ": "ضح",
 "ﵮ": "ضحى",
 "ﶫ": "ضحى",
 "ﲶ": "ضخ",
 "ﰤ": "ضخ",
 "ﵰ": "ضخم",
 "ﵯ": "ضخم",
 "ﴬ": "ضر",
 "ﴐ": "ضر",
 "ﲷ": "ضم",
 "ﰥ": "ضم",
 "ﴣ": "ضى",
 "ﴇ": "ضى",
 "ﴤ": "ضى",
 "ﴈ": "ضى",
 "𐋨": "ط",
 "𞸈": "ط",
 "𞹨": "ط",
 "𞺈": "ط",
 "𞺨": "ط",
 "ﻃ": "ط",
 "ﻄ": "ط",
 "ﻂ": "ط",
 "ﻁ": "ط",
 "ڟ": "طۛ",
 "ﲸ": "طح",
 "ﰦ": "طح",
 "ﴳ": "طم",
 "ﴺ": "طم",
 "ﰧ": "طم",
 "ﵲ": "طمح",
 "ﵱ": "طمح",
 "ﵳ": "طمم",
 "ﵴ": "طمى",
 "ﴑ": "طى",
 "ﳵ": "طى",
 "ﴒ": "طى",
 "ﳶ": "طى",
 "𞸚": "ظ",
 "𞹺": "ظ",
 "𞺚": "ظ",
 "𞺺": "ظ",
 "ﻇ": "ظ",
 "ﻈ": "ظ",
 "ﻆ": "ظ",
 "ﻅ": "ظ",
 "ﲹ": "ظم",
 "ﴻ": "ظم",
 "ﰨ": "ظم",
 "؏": "ع",
 "𞸏": "ع",
 "𞸯": "ع",
 "𞹏": "ع",
 "𞹯": "ع",
 "𞺏": "ع",
 "𞺯": "ع",
 "ﻋ": "ع",
 "ﻌ": "ع",
 "ﻊ": "ع",
 "ﻉ": "ع",
 "ﲺ": "عج",
 "ﰩ": "عج",
 "ﷄ": "عجم",
 "ﵵ": "عجم",
 "ﷷ": "علىo",
 "ﲻ": "عم",
 "ﰪ": "عم",
 "ﵷ": "عمم",
 "ﵶ": "عمم",
 "ﵸ": "عمى",
 "ﶶ": "عمى",
 "ﴓ": "عى",
 "ﳷ": "عى",
 "ﴔ": "عى",
 "ﳸ": "عى",
 "𞸛": "غ",
 "𞸻": "غ",
 "𞹛": "غ",
 "𞹻": "غ",
 "𞺛": "غ",
 "𞺻": "غ",
 "ﻏ": "غ",
 "ﻐ": "غ",
 "ﻎ": "غ",
 "ﻍ": "غ",
 "ﲼ": "غج",
 "ﰫ": "غج",
 "ﲽ": "غم",
 "ﰬ": "غم",
 "ﵹ": "غمم",
 "ﵻ": "غمى",
 "ﵺ": "غمى",
 "ﴕ": "غى",
 "ﳹ": "غى",
 "ﴖ": "غى",
 "ﳺ": "غى",
 "𞸐": "ف",
 "𞸰": "ف",
 "𞹰": "ف",
 "𞺐": "ف",
 "𞺰": "ف",
 "ﻓ": "ف",
 "ﻔ": "ف",
 "ﻒ": "ف",
 "ﻑ": "ف",
 "ڧ": "ف",
 "ﲾ": "فج",
 "ﰭ": "فج",
 "ﲿ": "فح",
 "ﰮ": "فح",
 "ﳀ": "فخ",
 "ﰯ": "فخ",
 "ﵽ": "فخم",
 "ﵼ": "فخم",
 "ﳁ": "فم",
 "ﰰ": "فم",
 "ﷁ": "فمى",
 "ﱼ": "فى",
 "ﰱ": "فى",
 "ﱽ": "فى",
 "ﰲ": "فى",
 "𞸞": "ڡ",
 "𞹾": "ڡ",
 "ࢻ": "ڡ",
 "ٯ": "ڡ",
 "𞸟": "ڡ",
 "𞹟": "ڡ",
 "ࢼ": "ڡ",
 "ڤ": "ڡۛ",
 "ﭬ": "ڡۛ",
 "ﭭ": "ڡۛ",
 "ﭫ": "ڡۛ",
 "ﭪ": "ڡۛ",
 "ڨ": "ڡۛ",
 "ࢤ": "ڢۛ",
 "ﭰ": "ڦ",
 "ﭱ": "ڦ",
 "ﭯ": "ڦ",
 "ﭮ": "ڦ",
 "𞸒": "ق",
 "𞸲": "ق",
 "𞹒": "ق",
 "𞹲": "ق",
 "𞺒": "ق",
 "𞺲": "ق",
 "ﻗ": "ق",
 "ﻘ": "ق",
 "ﻖ": "ق",
 "ﻕ": "ق",
 "ﳂ": "قح",
 "ﰳ": "قح",
 "ﷱ": "قلى",
 "ﳃ": "قم",
 "ﰴ": "قم",
 "ﶴ": "قمح",
 "ﵾ": "قمح",
 "ﵿ": "قمم",
 "ﶲ": "قمى",
 "ﱾ": "قى",
 "ﰵ": "قى",
 "ﱿ": "قى",
 "ﰶ": "قى",
 "𞸊": "ك",
 "𞸪": "ك",
 "𞹪": "ك",
 "ﻛ": "ك",
 "ﻜ": "ك",
 "ﻚ": "ك",
 "ﻙ": "ك",
 "ک": "ك",
 "ﮐ": "ك",
 "ﮑ": "ك",
 "ﮏ": "ك",
 "ﮎ": "ك",
 "ڪ": "ك",
 "ڭ": "كۛ",
 "ﯕ": "كۛ",
 "ﯖ": "كۛ",
 "ﯔ": "كۛ",
 "ﯓ": "كۛ",
 "ݣ": "كۛ",
 "ﲀ": "كl",
 "ﰷ": "كl",
 "ﳄ": "كج",
 "ﰸ": "كج",
 "ﳅ": "كح",
 "ﰹ": "كح",
 "ﳆ": "كخ",
 "ﰺ": "كخ",
 "ﳇ": "كل",
 "ﳫ": "كل",
 "ﲁ": "كل",
 "ﰻ": "كل",
 "ﳈ": "كم",
 "ﳬ": "كم",
 "ﲂ": "كم",
 "ﰼ": "كم",
 "ﷃ": "كمم",
 "ﶻ": "كمم",
 "ﶷ": "كمى",
 "ﲃ": "كى",
 "ﰽ": "كى",
 "ﲄ": "كى",
 "ﰾ": "كى",
 "ݢ": "ڬ",
 "ﮔ": "گ",
 "ﮕ": "گ",
 "ﮓ": "گ",
 "ﮒ": "گ",
 "ࢰ": "گ",
 "ڴ": "گۛ",
 "ﮜ": "ڱ",
 "ﮝ": "ڱ",
 "ﮛ": "ڱ",
 "ﮚ": "ڱ",
 "ﮘ": "ڳ",
 "ﮙ": "ڳ",
 "ﮗ": "ڳ",
 "ﮖ": "ڳ",
 "𞸋": "ل",
 "𞸫": "ل",
 "𞹋": "ل",
 "𞺋": "ل",
 "𞺫": "ل",
 "ﻟ": "ل",
 "ﻠ": "ل",
 "ﻞ": "ل",
 "ﻝ": "ل",
 "ڷ": "لۛ",
 "ڵ": "ل̆",
 "ﻼ": "لl",
 "ﻻ": "لl",
 "ﻺ": "لlٕ",
 "ﻹ": "لlٕ",
 "ﻸ": "لlٴ",
 "ﻷ": "لlٴ",
 "ﳍ": "لo",
 "ﻶ": "لآ",
 "ﻵ": "لآ",
 "ﳉ": "لج",
 "ﰿ": "لج",
 "ﶃ": "لجج",
 "ﶄ": "لجج",
 "ﶺ": "لجم",
 "ﶼ": "لجم",
 "ﶬ": "لجى",
 "ﳊ": "لح",
 "ﱀ": "لح",
 "ﶵ": "لحم",
 "ﶀ": "لحم",
 "ﶂ": "لحى",
 "ﶁ": "لحى",
 "ﳋ": "لخ",
 "ﱁ": "لخ",
 "ﶆ": "لخم",
 "ﶅ": "لخم",
 "ﳌ": "لم",
 "ﳭ": "لم",
 "ﲅ": "لم",
 "ﱂ": "لم",
 "ﶈ": "لمح",
 "ﶇ": "لمح",
 "ﶭ": "لمى",
 "ﲆ": "لى",
 "ﱃ": "لى",
 "ﲇ": "لى",
 "ﱄ": "لى",
 "𞸌": "م",
 "𞸬": "م",
 "𞹬": "م",
 "𞺌": "م",
 "𞺬": "م",
 "ﻣ": "م",
 "ﻤ": "م",
 "ﻢ": "م",
 "ﻡ": "م",
 "ࢧ": "مۛ",
 "۾": "م͈",
 "ﲈ": "مl",
 "ﳎ": "مج",
 "ﱅ": "مج",
 "ﶌ": "مجح",
 "ﶒ": "مجخ",
 "ﶍ": "مجم",
 "ﷀ": "مجى",
 "ﳏ": "مح",
 "ﱆ": "مح",
 "ﶉ": "محج",
 "ﶊ": "محم",
 "ﷴ": "محمد",
 "ﶋ": "محى",
 "ﳐ": "مخ",
 "ﱇ": "مخ",
 "ﶎ": "مخج",
 "ﶏ": "مخم",
 "ﶹ": "مخى",
 "ﳑ": "مم",
 "ﲉ": "مم",
 "ﱈ": "مم",
 "ﶱ": "ممى",
 "ﱉ": "مى",
 "ﱊ": "مى",
 "𞸍": "ن",
 "𞸭": "ن",
 "𞹍": "ن",
 "𞹭": "ن",
 "𞺍": "ن",
 "𞺭": "ن",
 "ﻧ": "ن",
 "ﻨ": "ن",
 "ﻦ": "ن",
 "ﻥ": "ن",
 "ݨ": "نؕ",
 "ݩ": "ن̆",
 "ﳖ": "نo",
 "ﳯ": "نo",
 "ﶸ": "نجح",
 "ﶽ": "نجح",
 "ﶘ": "نجم",
 "ﶗ": "نجم",
 "ﶙ": "نجى",
 "ﷇ": "نجى",
 "ﳓ": "نح",
 "ﱌ": "نح",
 "ﶕ": "نحم",
 "ﶖ": "نحى",
 "ﶳ": "نحى",
 "ﳔ": "نخ",
 "ﱍ": "نخ",
 "ﲊ": "نر",
 "ﲋ": "نز",
 "ﳕ": "نم",
 "ﳮ": "نم",
 "ﲌ": "نم",
 "ﱎ": "نم",
 "ﶛ": "نمى",
 "ﶚ": "نمى",
 "ﲍ": "نن",
 "ﲎ": "نى",
 "ﱏ": "نى",
 "ﲏ": "نى",
 "ﱐ": "نى",
 "ۂ": "ۀ",
 "ﮥ": "ۀ",
 "ﮤ": "ۀ",
 "𐋤": "و",
 "𞸅": "و",
 "𞺅": "و",
 "𞺥": "و",
 "ﻮ": "و",
 "ﻭ": "و",
 "ࢱ": "و",
 "ۋ": "وۛ",
 "ﯟ": "وۛ",
 "ﯞ": "وۛ",
 "ۇ": "و̓",
 "ﯘ": "و̓",
 "ﯗ": "و̓",
 "ۆ": "و̆",
 "ﯚ": "و̆",
 "ﯙ": "و̆",
 "ۉ": "و̂",
 "ﯣ": "و̂",
 "ﯢ": "و̂",
 "ۈ": "وٰ",
 "ﯜ": "وٰ",
 "ﯛ": "وٰ",
 "ؤ": "وٴ",
 "ﺆ": "وٴ",
 "ﺅ": "وٴ",
 "ٶ": "وٴ",
 "ٷ": "و̓ٴ",
 "ﯝ": "و̓ٴ",
 "ﷸ": "وسلم",
 "ﯡ": "ۅ",
 "ﯠ": "ۅ",
 "ٮ": "ى",
 "𞸜": "ى",
 "𞹼": "ى",
 "ں": "ى",
 "𞸝": "ى",
 "𞹝": "ى",
 "ﮟ": "ى",
 "ﮞ": "ى",
 "ࢽ": "ى",
 "ﯨ": "ى",
 "ﯩ": "ى",
 "ﻰ": "ى",
 "ﻯ": "ى",
 "ي": "ى",
 "𞸉": "ى",
 "𞸩": "ى",
 "𞹉": "ى",
 "𞹩": "ى",
 "𞺉": "ى",
 "𞺩": "ى",
 "ﻳ": "ى",
 "ﻴ": "ى",
 "ﻲ": "ى",
 "ﻱ": "ى",
 "ی": "ى",
 "ﯾ": "ى",
 "ﯿ": "ى",
 "ﯽ": "ى",
 "ﯼ": "ى",
 "ے": "ى",
 "ﮯ": "ى",
 "ﮮ": "ى",
 "ٹ": "ىؕ",
 "ﭨ": "ىؕ",
 "ﭩ": "ىؕ",
 "ﭧ": "ىؕ",
 "ﭦ": "ىؕ",
 "ڻ": "ىؕ",
 "ﮢ": "ىؕ",
 "ﮣ": "ىؕ",
 "ﮡ": "ىؕ",
 "ﮠ": "ىؕ",
 "پ": "ىۛ",
 "ﭘ": "ىۛ",
 "ﭙ": "ىۛ",
 "ﭗ": "ىۛ",
 "ﭖ": "ىۛ",
 "ث": "ىۛ",
 "𞸖": "ىۛ",
 "𞸶": "ىۛ",
 "𞹶": "ىۛ",
 "𞺖": "ىۛ",
 "𞺶": "ىۛ",
 "ﺛ": "ىۛ",
 "ﺜ": "ىۛ",
 "ﺚ": "ىۛ",
 "ﺙ": "ىۛ",
 "ڽ": "ىۛ",
 "ۑ": "ىۛ",
 "ؿ": "ىۛ",
 "ࢷ": "ىۛۢ",
 "ݖ": "ى̆",
 "ێ": "ى̆",
 "ࢺ": "ى̆̇",
 "ؽ": "ى̂",
 "ࢨ": "ىٔ",
 "ﲐ": "ىٰ",
 "ﱝ": "ىٰ",
 "ﳞ": "ىo",
 "ﳱ": "ىo",
 "ﳦ": "ىۛo",
 "ئ": "ىٴ",
 "ﺋ": "ىٴ",
 "ﺌ": "ىٴ",
 "ﺊ": "ىٴ",
 "ﺉ": "ىٴ",
 "ٸ": "ىٴ",
 "ﯫ": "ىٴl",
 "ﯪ": "ىٴl",
 "ﲛ": "ىٴo",
 "ﳠ": "ىٴo",
 "ﯭ": "ىٴo",
 "ﯬ": "ىٴo",
 "ﯸ": "ىٴٻ",
 "ﯷ": "ىٴٻ",
 "ﯶ": "ىٴٻ",
 "ﲗ": "ىٴج",
 "ﰀ": "ىٴج",
 "ﲘ": "ىٴح",
 "ﰁ": "ىٴح",
 "ﲙ": "ىٴخ",
 "ﱤ": "ىٴر",
 "ﱥ": "ىٴز",
 "ﲚ": "ىٴم",
 "ﳟ": "ىٴم",
 "ﱦ": "ىٴم",
 "ﰂ": "ىٴم",
 "ﱧ": "ىٴن",
 "ﯯ": "ىٴو",
 "ﯮ": "ىٴو",
 "ﯱ": "ىٴو̓",
 "ﯰ": "ىٴو̓",
 "ﯳ": "ىٴو̆",
 "ﯲ": "ىٴو̆",
 "ﯵ": "ىٴوٰ",
 "ﯴ": "ىٴوٰ",
 "ﯻ": "ىٴى",
 "ﯺ": "ىٴى",
 "ﱨ": "ىٴى",
 "ﯹ": "ىٴى",
 "ﰃ": "ىٴى",
 "ﱩ": "ىٴى",
 "ﰄ": "ىٴى",
 "ﳚ": "ىج",
 "ﱕ": "ىج",
 "ﰑ": "ىۛج",
 "ﶯ": "ىجى",
 "ﳛ": "ىح",
 "ﱖ": "ىح",
 "ﶮ": "ىحى",
 "ﳜ": "ىخ",
 "ﱗ": "ىخ",
 "ﲑ": "ىر",
 "ﱶ": "ىۛر",
 "ﲒ": "ىز",
 "ﱷ": "ىۛز",
 "ﳝ": "ىم",
 "ﳰ": "ىم",
 "ﲓ": "ىم",
 "ﱘ": "ىم",
 "ﲦ": "ىۛم",
 "ﳥ": "ىۛم",
 "ﱸ": "ىۛم",
 "ﰒ": "ىۛم",
 "ﶝ": "ىمم",
 "ﶜ": "ىمم",
 "ﶰ": "ىمى",
 "ﲔ": "ىن",
 "ﱹ": "ىۛن",
 "ﲕ": "ىى",
 "ﱙ": "ىى",
 "ﲖ": "ىى",
 "ﱚ": "ىى",
 "ﱺ": "ىۛى",
 "ﰓ": "ىۛى",
 "ﱻ": "ىۛى",
 "ﰔ": "ىۛى",
 "ﮱ": "ۓ",
 "ﮰ": "ۓ",
 "𐊸": "ⵀ",
 "⁞": "ⵂ",
 "⸽": "ⵂ",
 "⦙": "ⵂ",
 "︙": "ⵗ",
 "⁝": "ⵗ",
 "⋮": "ⵗ",
 "Մ": "ሆ",
 "Ռ": "ቡ",
 "Ի": "ኮ",
 "Պ": "ጣ",
 "आ": "अा",
 "ऒ": "अाॆ",
 "ओ": "अाे",
 "औ": "अाै",
 "ऄ": "अॆ",
 "ऑ": "अॉ",
 "ऍ": "एॅ",
 "ऎ": "एॆ",
 "ऐ": "एे",
 "ई": "र्इ",
 "ઽ": "ऽ",
 "𑇜": "ꣻ",
 "𑇋": "ऺ",
 "ુ": "ु",
 "ૂ": "ू",
 "ੋ": "ॆ",
 "੍": "्",
 "્": "्",
 "আ": "অা",
 "ৠ": "ঋৃ",
 "ৡ": "ঋৃ",
 "𑒒": "ঘ",
 "𑒔": "চ",
 "𑒖": "জ",
 "𑒘": "ঞ",
 "𑒙": "ট",
 "𑒛": "ড",
 "𑒪": "ণ",
 "𑒞": "ত",
 "𑒟": "থ",
 "𑒠": "দ",
 "𑒡": "ধ",
 "𑒢": "ন",
 "𑒣": "প",
 "𑒩": "ব",
 "𑒧": "ম",
 "𑒨": "য",
 "𑒫": "র",
 "𑒝": "ল",
 "𑒭": "ষ",
 "𑒮": "স",
 "𑓄": "ঽ",
 "𑒰": "া",
 "𑒱": "ি",
 "𑒹": "ে",
 "𑒼": "ো",
 "𑒾": "ৌ",
 "𑓂": "্",
 "𑒽": "ৗ",
 "ਉ": "ੳੁ",
 "ਊ": "ੳੂ",
 "ਆ": "ਅਾ",
 "ਐ": "ਅੈ",
 "ਔ": "ਅੌ",
 "ਇ": "ੲਿ",
 "ਈ": "ੲੀ",
 "ਏ": "ੲੇ",
 "આ": "અા",
 "ઑ": "અાૅ",
 "ઓ": "અાે",
 "ઔ": "અાૈ",
 "ઍ": "અૅ",
 "એ": "અે",
 "ઐ": "અૈ",
 "ଆ": "ଅା",
 "௮": "அ",
 "ர": "ஈ",
 "ா": "ஈ",
 "௫": "ஈு",
 "௨": "உ",
 "ഉ": "உ",
 "ஊ": "உள",
 "ഊ": "உൗ",
 "௭": "எ",
 "௷": "எவ",
 "ஜ": "ஐ",
 "ജ": "ஐ",
 "௧": "க",
 "௪": "ச",
 "௬": "சு",
 "௲": "சூ",
 "ഺ": "டி",
 "ണ": "ண",
 "௺": "நீ",
 "௴": "மீ",
 "௰": "ய",
 "ഴ": "ழ",
 "ௗ": "ள",
 "ை": "ன",
 "ശ": "ஶ",
 "௸": "ஷ",
 "ി": "ி",
 "ീ": "ி",
 "ொ": "ெஈ",
 "ௌ": "ெள",
 "ோ": "ேஈ",
 "ಅ": "అ",
 "ಆ": "ఆ",
 "ಇ": "ఇ",
 "ౠ": "ఋా",
 "ౡ": "ఌా",
 "ಒ": "ఒ",
 "ఔ": "ఒౌ",
 "ಔ": "ఒౌ",
 "ఓ": "ఒౕ",
 "ಓ": "ఒౕ",
 "ಜ": "జ",
 "ಞ": "ఞ",
 "ఢ": "డ̣",
 "ಣ": "ణ",
 "థ": "ధּ",
 "భ": "బ̣",
 "ಯ": "య",
 "ఠ": "రּ",
 "ಱ": "ఱ",
 "ಲ": "ల",
 "ష": "వ̣",
 "హ": "వా",
 "మ": "వు",
 "ూ": "ుా",
 "ౄ": "ృా",
 "ೡ": "ಌಾ",
 "ഈ": "ഇൗ",
 "ഐ": "എെ",
 "ഓ": "ഒാ",
 "ഔ": "ഒൗ",
 "ൡ": "ഞ",
 "൫": "ദ്ര",
 "൹": "നു",
 "ഌ": "നു",
 "ങ": "നു",
 "൯": "ന്",
 "ൻ": "ന്",
 "൬": "ന്ന",
 "൚": "ന്മ",
 "റ": "ര",
 "൪": "ര്",
 "ർ": "ര്",
 "൮": "വ്ര",
 "൶": "ഹ്മ",
 "ൂ": "ു",
 "ൃ": "ു",
 "ൈ": "െെ",
 "෪": "ජ",
 "෫": "ද",
 "𑐓": "𑐴𑑂𑐒",
 "𑐙": "𑐴𑑂𑐘",
 "𑐤": "𑐴𑑂𑐣",
 "𑐪": "𑐴𑑂𑐩",
 "𑐭": "𑐴𑑂𑐬",
 "𑐯": "𑐴𑑂𑐮",
 "𑗘": "𑖂",
 "𑗙": "𑖂",
 "𑗚": "𑖃",
 "𑗛": "𑖄",
 "𑗜": "𑖲",
 "𑗝": "𑖳",
 "ฃ": "ข",
 "ด": "ค",
 "ต": "ค",
 "ม": "ฆ",
 "ຈ": "จ",
 "ซ": "ช",
 "ฏ": "ฎ",
 "ท": "ฑ",
 "ບ": "บ",
 "ປ": "ป",
 "ຝ": "ฝ",
 "ພ": "พ",
 "ຟ": "ฟ",
 "ฦ": "ภ",
 "ຍ": "ย",
 "។": "ฯ",
 "ๅ": "า",
 "ำ": "̊า",
 "ិ": "ิ",
 "ី": "ี",
 "ឹ": "ึ",
 "ឺ": "ื",
 "ຸ": "ุ",
 "ູ": "ู",
 "แ": "เเ",
 "ໜ": "ຫນ",
 "ໝ": "ຫມ",
 "ຳ": "̊າ",
 "༂": "འུྂཿ",
 "༃": "འུྂ༔",
 "ཪ": "ར",
 "ༀ": "ཨོཾ",
 "ཷ": "ྲཱྀ",
 "ཹ": "ླཱྀ",
 "𑲲": "𑲪",
 "ႁ": "ဂှ",
 "က": "ဂာ",
 "ၰ": "ဃှ",
 "ၦ": "ပှ",
 "ဟ": "ပာ",
 "ၯ": "ပာှ",
 "ၾ": "ၽှ",
 "ဩ": "သြ",
 "ဪ": "သြော်",
 "႞": "ႃ̊",
 "ឣ": "អ",
 "᧐": "ᦞ",
 "᧑": "ᦱ",
 "᪀": "ᩅ",
 "᪐": "ᩅ",
 "꩓": "ꨁ",
 "꩖": "ꨣ",
 "᭒": "ᬍ",
 "᭓": "ᬑ",
 "᭘": "ᬨ",
 "ꦣ": "ꦝ",
 "ᢖ": "ᡜ",
 "ᡕ": "ᠵ",
 "ῶ": "Ꮿ",
 "ᐍ": "ᐁ·",
 "ᐫ": "ᐁᐠ",
 "ᐑ": "ᐄ·",
 "ᐓ": "ᐅ·",
 "ᐭ": "ᐅᐠ",
 "ᐕ": "ᐆ·",
 "ᐘ": "ᐊ·",
 "ᐮ": "ᐊᐠ",
 "ᐚ": "ᐋ·",
 "ᣝ": "ᐞᣟ",
 "ᓑ": "ᐡ",
 "ᕀ": "ᐩ",
 "ᐿ": "ᐲ·",
 "ᑃ": "ᐴ·",
 "⍩": "ᐵ",
 "ᑇ": "ᐹ·",
 "ᑜ": "ᑏ·",
 "⸧": "ᑐ",
 "⊃": "ᑐ",
 "ᑞ": "ᑐ·",
 "ᑩ": "ᑐ'",
 "⟉": "ᑐ/",
 "⫗": "ᑐᑕ",
 "ᑠ": "ᑑ·",
 "⸦": "ᑕ",
 "⊂": "ᑕ",
 "ᑢ": "ᑕ·",
 "ᑪ": "ᑕ'",
 "ᑤ": "ᑖ·",
 "ᑵ": "ᑫ·",
 "ᒅ": "ᑫ'",
 "ᑹ": "ᑮ·",
 "ᑽ": "ᑰ·",
 "ᑿ": "ᑲ·",
 "ᒈ": "ᑲ'",
 "ᒁ": "ᑳ·",
 "ᘃ": "ᒉ",
 "ᒓ": "ᒉ·",
 "ᒕ": "ᒋ·",
 "ᒗ": "ᒌ·",
 "ᒛ": "ᒎ·",
 "ᘂ": "ᒐ",
 "ᒝ": "ᒐ·",
 "ᒟ": "ᒑ·",
 "ᒭ": "ᒣ·",
 "ᒱ": "ᒦ·",
 "ᒳ": "ᒧ·",
 "ᒵ": "ᒨ·",
 "ᒹ": "ᒫ·",
 "ᓊ": "ᓀ·",
 "ᣇ": "ᓂ·",
 "ᣉ": "ᓃ·",
 "ᣋ": "ᓄ·",
 "ᣍ": "ᓅ·",
 "ᓌ": "ᓇ·",
 "ᓎ": "ᓈ·",
 "ᘄ": "ᓓ",
 "ᓝ": "ᓓ·",
 "ᓟ": "ᓕ·",
 "ᓡ": "ᓖ·",
 "ᓣ": "ᓗ·",
 "ᓥ": "ᓘ·",
 "ᘇ": "ᓚ",
 "ᓧ": "ᓚ·",
 "ᓩ": "ᓛ·",
 "ᓷ": "ᓭ·",
 "ᓹ": "ᓯ·",
 "ᓻ": "ᓰ·",
 "ᓽ": "ᓱ·",
 "ᓿ": "ᓲ·",
 "ᔁ": "ᓴ·",
 "ᔃ": "ᓵ·",
 "ᔌ": "ᔋ<",
 "ᔍ": "ᔋᑕ",
 "ᔎ": "ᔋᑲ",
 "ᔏ": "ᔋᒐ",
 "ᔘ": "ᔐ·",
 "ᔚ": "ᔑ·",
 "ᔜ": "ᔒ·",
 "ᔞ": "ᔓ·",
 "ᔠ": "ᔔ·",
 "ᔢ": "ᔕ·",
 "ᔤ": "ᔖ·",
 "ᔲ": "ᔨ·",
 "ᔴ": "ᔩ·",
 "ᔶ": "ᔪ·",
 "ᔸ": "ᔫ·",
 "ᔺ": "ᔭ·",
 "ᔼ": "ᔮ·",
 "ᘢ": "ᕃ",
 "ᣠ": "ᕃ·",
 "ᘣ": "ᕆ",
 "ᘤ": "ᕊ",
 "ᕏ": "ᕌ·",
 "ᖁ": "ᕐd",
 "ᕿ": "ᕐP",
 "ᙯ": "ᕐᑫ",
 "ᕾ": "ᕐᑬ",
 "ᖀ": "ᕐᑮ",
 "ᖂ": "ᕐᑰ",
 "ᖃ": "ᕐᑲ",
 "ᖄ": "ᕐᑳ",
 "ᖅ": "ᕐᒃ",
 "ᕜ": "ᕚ·",
 "ᣣ": "ᕞ·",
 "ᣤ": "ᕦ·",
 "ᕩ": "ᕧ·",
 "ᣥ": "ᕫ·",
 "ᣨ": "ᖆ·",
 "ᖑ": "ᖕJ",
 "ᙰ": "ᖕᒉ",
 "ᖎ": "ᖕᒊ",
 "ᖏ": "ᖕᒋ",
 "ᖐ": "ᖕᒌ",
 "ᖒ": "ᖕᒎ",
 "ᖓ": "ᖕᒐ",
 "ᖔ": "ᖕᒑ",
 "ᙳ": "ᖖJ",
 "ᙱ": "ᖖᒋ",
 "ᙲ": "ᖖᒌ",
 "ᙴ": "ᖖᒎ",
 "ᙵ": "ᖖᒐ",
 "ᙶ": "ᖖᒑ",
 "ᣪ": "ᖗ·",
 "ᙷ": "ᖧ·",
 "ᙸ": "ᖨ·",
 "ᙹ": "ᖩ·",
 "ᙺ": "ᖪ·",
 "ᙻ": "ᖫ·",
 "ᙼ": "ᖬ·",
 "ᙽ": "ᖭ·",
 "⪫": "ᗒ",
 "⪪": "ᗕ",
 "ꓷ": "ᗡ",
 "ᣰ": "ᗴ·",
 "ᣲ": "ᘛ·",
 "ᶻ": "ᙆ",
 "ꓭ": "ᙠ",
 "ᶺ": "ᣔ",
 "ᴾ": "ᣖ",
 "ᣜ": "ᣟᐞ",
 "ˡ": "ᣳ",
 "ʳ": "ᣴ",
 "ˢ": "ᣵ",
 "ᣛ": "ᣵ",
 "ꚰ": "ᚹ",
 "ᛡ": "ᚼ",
 "⍿": "ᚽ",
 "ᛂ": "ᚽ",
 "𝈿": "ᛋ",
 "↑": "ᛏ",
 "↿": "ᛐ",
 "⥮": "ᛐ⇂",
 "⥣": "ᛐᛚ",
 "ⵣ": "ᛯ",
 "↾": "ᛚ",
 "⨡": "ᛚ",
 "⋄": "ᛜ",
 "◇": "ᛜ",
 "◊": "ᛜ",
 "♢": "ᛜ",
 "🝔": "ᛜ",
 "𑢷": "ᛜ",
 "𐊔": "ᛜ",
 "⍚": "ᛜ̲",
 "⋈": "ᛞ",
 "⨝": "ᛞ",
 "𐓐": "ᛦ",
 "↕": "ᛨ",
 "𐳼": "𐲂",
 "𐳺": "𐲥",
 "ㄱ": "ᄀ",
 "ᆨ": "ᄀ",
 "ᄁ": "ᄀᄀ",
 "ㄲ": "ᄀᄀ",
 "ᆩ": "ᄀᄀ",
 "ᇺ": "ᄀᄂ",
 "ᅚ": "ᄀᄃ",
 "ᇃ": "ᄀᄅ",
 "ᇻ": "ᄀᄇ",
 "ᆪ": "ᄀᄉ",
 "ㄳ": "ᄀᄉ",
 "ᇄ": "ᄀᄉᄀ",
 "ᇼ": "ᄀᄎ",
 "ᇽ": "ᄀᄏ",
 "ᇾ": "ᄀᄒ",
 "ㄴ": "ᄂ",
 "ᆫ": "ᄂ",
 "ᄓ": "ᄂᄀ",
 "ᇅ": "ᄂᄀ",
 "ᄔ": "ᄂᄂ",
 "ㅥ": "ᄂᄂ",
 "ᇿ": "ᄂᄂ",
 "ᄕ": "ᄂᄃ",
 "ㅦ": "ᄂᄃ",
 "ᇆ": "ᄂᄃ",
 "ퟋ": "ᄂᄅ",
 "ᄖ": "ᄂᄇ",
 "ᅛ": "ᄂᄉ",
 "ᇇ": "ᄂᄉ",
 "ㅧ": "ᄂᄉ",
 "ᅜ": "ᄂᄌ",
 "ᆬ": "ᄂᄌ",
 "ㄵ": "ᄂᄌ",
 "ퟌ": "ᄂᄎ",
 "ᇉ": "ᄂᄐ",
 "ᅝ": "ᄂᄒ",
 "ᆭ": "ᄂᄒ",
 "ㄶ": "ᄂᄒ",
 "ᇈ": "ᄂᅀ",
 "ㅨ": "ᄂᅀ",
 "ㄷ": "ᄃ",
 "ᆮ": "ᄃ",
 "ᄗ": "ᄃᄀ",
 "ᇊ": "ᄃᄀ",
 "ᄄ": "ᄃᄃ",
 "ㄸ": "ᄃᄃ",
 "ퟍ": "ᄃᄃ",
 "ퟎ": "ᄃᄃᄇ",
 "ᅞ": "ᄃᄅ",
 "ᇋ": "ᄃᄅ",
 "ꥠ": "ᄃᄆ",
 "ꥡ": "ᄃᄇ",
 "ퟏ": "ᄃᄇ",
 "ꥢ": "ᄃᄉ",
 "ퟐ": "ᄃᄉ",
 "ퟑ": "ᄃᄉᄀ",
 "ꥣ": "ᄃᄌ",
 "ퟒ": "ᄃᄌ",
 "ퟓ": "ᄃᄎ",
 "ퟔ": "ᄃᄐ",
 "ㄹ": "ᄅ",
 "ᆯ": "ᄅ",
 "ꥤ": "ᄅᄀ",
 "ᆰ": "ᄅᄀ",
 "ㄺ": "ᄅᄀ",
 "ꥥ": "ᄅᄀᄀ",
 "ퟕ": "ᄅᄀᄀ",
 "ᇌ": "ᄅᄀᄉ",
 "ㅩ": "ᄅᄀᄉ",
 "ퟖ": "ᄅᄀᄒ",
 "ᄘ": "ᄅᄂ",
 "ᇍ": "ᄅᄂ",
 "ꥦ": "ᄅᄃ",
 "ᇎ": "ᄅᄃ",
 "ㅪ": "ᄅᄃ",
 "ꥧ": "ᄅᄃᄃ",
 "ᇏ": "ᄅᄃᄒ",
 "ᄙ": "ᄅᄅ",
 "ᇐ": "ᄅᄅ",
 "ퟗ": "ᄅᄅᄏ",
 "ꥨ": "ᄅᄆ",
 "ᆱ": "ᄅᄆ",
 "ㄻ": "ᄅᄆ",
 "ᇑ": "ᄅᄆᄀ",
 "ᇒ": "ᄅᄆᄉ",
 "ퟘ": "ᄅᄆᄒ",
 "ꥩ": "ᄅᄇ",
 "ᆲ": "ᄅᄇ",
 "ㄼ": "ᄅᄇ",
 "ퟙ": "ᄅᄇᄃ",
 "ꥪ": "ᄅᄇᄇ",
 "ᇓ": "ᄅᄇᄉ",
 "ㅫ": "ᄅᄇᄉ",
 "ꥫ": "ᄅᄇᄋ",
 "ᇕ": "ᄅᄇᄋ",
 "ퟚ": "ᄅᄇᄑ",
 "ᇔ": "ᄅᄇᄒ",
 "ꥬ": "ᄅᄉ",
 "ᆳ": "ᄅᄉ",
 "ㄽ": "ᄅᄉ",
 "ᇖ": "ᄅᄉᄉ",
 "ᄛ": "ᄅᄋ",
 "ퟝ": "ᄅᄋ",
 "ꥭ": "ᄅᄌ",
 "ꥮ": "ᄅᄏ",
 "ᇘ": "ᄅᄏ",
 "ᆴ": "ᄅᄐ",
 "ㄾ": "ᄅᄐ",
 "ᆵ": "ᄅᄑ",
 "ㄿ": "ᄅᄑ",
 "ᄚ": "ᄅᄒ",
 "ㅀ": "ᄅᄒ",
 "ᄻ": "ᄅᄒ",
 "ᆶ": "ᄅᄒ",
 "ퟲ": "ᄅᄒ",
 "ᇗ": "ᄅᅀ",
 "ㅬ": "ᄅᅀ",
 "ퟛ": "ᄅᅌ",
 "ᇙ": "ᄅᅙ",
 "ㅭ": "ᄅᅙ",
 "ퟜ": "ᄅᅙᄒ",
 "ㅁ": "ᄆ",
 "ᆷ": "ᄆ",
 "ꥯ": "ᄆᄀ",
 "ᇚ": "ᄆᄀ",
 "ퟞ": "ᄆᄂ",
 "ퟟ": "ᄆᄂᄂ",
 "ꥰ": "ᄆᄃ",
 "ᇛ": "ᄆᄅ",
 "ퟠ": "ᄆᄆ",
 "ᄜ": "ᄆᄇ",
 "ㅮ": "ᄆᄇ",
 "ᇜ": "ᄆᄇ",
 "ퟡ": "ᄆᄇᄉ",
 "ꥱ": "ᄆᄉ",
 "ᇝ": "ᄆᄉ",
 "ㅯ": "ᄆᄉ",
 "ᇞ": "ᄆᄉᄉ",
 "ᄝ": "ᄆᄋ",
 "ㅱ": "ᄆᄋ",
 "ᇢ": "ᄆᄋ",
 "ퟢ": "ᄆᄌ",
 "ᇠ": "ᄆᄎ",
 "ᇡ": "ᄆᄒ",
 "ᇟ": "ᄆᅀ",
 "ㅰ": "ᄆᅀ",
 "ㅂ": "ᄇ",
 "ᆸ": "ᄇ",
 "ᄞ": "ᄇᄀ",
 "ㅲ": "ᄇᄀ",
 "ᄟ": "ᄇᄂ",
 "ᄠ": "ᄇᄃ",
 "ㅳ": "ᄇᄃ",
 "ퟣ": "ᄇᄃ",
 "ᇣ": "ᄇᄅ",
 "ퟤ": "ᄇᄅᄑ",
 "ퟥ": "ᄇᄆ",
 "ᄈ": "ᄇᄇ",
 "ㅃ": "ᄇᄇ",
 "ퟦ": "ᄇᄇ",
 "ᄬ": "ᄇᄇᄋ",
 "ㅹ": "ᄇᄇᄋ",
 "ᄡ": "ᄇᄉ",
 "ㅄ": "ᄇᄉ",
 "ᆹ": "ᄇᄉ",
 "ᄢ": "ᄇᄉᄀ",
 "ㅴ": "ᄇᄉᄀ",
 "ᄣ": "ᄇᄉᄃ",
 "ㅵ": "ᄇᄉᄃ",
 "ퟧ": "ᄇᄉᄃ",
 "ᄤ": "ᄇᄉᄇ",
 "ᄥ": "ᄇᄉᄉ",
 "ᄦ": "ᄇᄉᄌ",
 "ꥲ": "ᄇᄉᄐ",
 "ᄫ": "ᄇᄋ",
 "ㅸ": "ᄇᄋ",
 "ᇦ": "ᄇᄋ",
 "ᄧ": "ᄇᄌ",
 "ㅶ": "ᄇᄌ",
 "ퟨ": "ᄇᄌ",
 "ᄨ": "ᄇᄎ",
 "ퟩ": "ᄇᄎ",
 "ꥳ": "ᄇᄏ",
 "ᄩ": "ᄇᄐ",
 "ㅷ": "ᄇᄐ",
 "ᄪ": "ᄇᄑ",
 "ᇤ": "ᄇᄑ",
 "ꥴ": "ᄇᄒ",
 "ᇥ": "ᄇᄒ",
 "ㅅ": "ᄉ",
 "ᆺ": "ᄉ",
 "ᄭ": "ᄉᄀ",
 "ㅺ": "ᄉᄀ",
 "ᇧ": "ᄉᄀ",
 "ᄮ": "ᄉᄂ",
 "ㅻ": "ᄉᄂ",
 "ᄯ": "ᄉᄃ",
 "ㅼ": "ᄉᄃ",
 "ᇨ": "ᄉᄃ",
 "ᄰ": "ᄉᄅ",
 "ᇩ": "ᄉᄅ",
 "ᄱ": "ᄉᄆ",
 "ퟪ": "ᄉᄆ",
 "ᄲ": "ᄉᄇ",
 "ㅽ": "ᄉᄇ",
 "ᇪ": "ᄉᄇ",
 "ᄳ": "ᄉᄇᄀ",
 "ퟫ": "ᄉᄇᄋ",
 "ᄊ": "ᄉᄉ",
 "ㅆ": "ᄉᄉ",
 "ᆻ": "ᄉᄉ",
 "ퟬ": "ᄉᄉᄀ",
 "ퟭ": "ᄉᄉᄃ",
 "ꥵ": "ᄉᄉᄇ",
 "ᄴ": "ᄉᄉᄉ",
 "ᄵ": "ᄉᄋ",
 "ᄶ": "ᄉᄌ",
 "ㅾ": "ᄉᄌ",
 "ퟯ": "ᄉᄌ",
 "ᄷ": "ᄉᄎ",
 "ퟰ": "ᄉᄎ",
 "ᄸ": "ᄉᄏ",
 "ᄹ": "ᄉᄐ",
 "ퟱ": "ᄉᄐ",
 "ᄺ": "ᄉᄑ",
 "ퟮ": "ᄉᅀ",
 "ㅇ": "ᄋ",
 "ᆼ": "ᄋ",
 "ᅁ": "ᄋᄀ",
 "ᇬ": "ᄋᄀ",
 "ᇭ": "ᄋᄀᄀ",
 "ᅂ": "ᄋᄃ",
 "ꥶ": "ᄋᄅ",
 "ᅃ": "ᄋᄆ",
 "ᅄ": "ᄋᄇ",
 "ᅅ": "ᄋᄉ",
 "ᇱ": "ᄋᄉ",
 "ㆂ": "ᄋᄉ",
 "ᅇ": "ᄋᄋ",
 "ㆀ": "ᄋᄋ",
 "ᇮ": "ᄋᄋ",
 "ᅈ": "ᄋᄌ",
 "ᅉ": "ᄋᄎ",
 "ᇯ": "ᄋᄏ",
 "ᅊ": "ᄋᄐ",
 "ᅋ": "ᄋᄑ",
 "ꥷ": "ᄋᄒ",
 "ᅆ": "ᄋᅀ",
 "ᇲ": "ᄋᅀ",
 "ㆃ": "ᄋᅀ",
 "ㅈ": "ᄌ",
 "ᆽ": "ᄌ",
 "ퟷ": "ᄌᄇ",
 "ퟸ": "ᄌᄇᄇ",
 "ᅍ": "ᄌᄋ",
 "ᄍ": "ᄌᄌ",
 "ㅉ": "ᄌᄌ",
 "ퟹ": "ᄌᄌ",
 "ꥸ": "ᄌᄌᄒ",
 "ㅊ": "ᄎ",
 "ᆾ": "ᄎ",
 "ᅒ": "ᄎᄏ",
 "ᅓ": "ᄎᄒ",
 "ㅋ": "ᄏ",
 "ᆿ": "ᄏ",
 "ㅌ": "ᄐ",
 "ᇀ": "ᄐ",
 "ꥹ": "ᄐᄐ",
 "ㅍ": "ᄑ",
 "ᇁ": "ᄑ",
 "ᅖ": "ᄑᄇ",
 "ᇳ": "ᄑᄇ",
 "ퟺ": "ᄑᄉ",
 "ᅗ": "ᄑᄋ",
 "ㆄ": "ᄑᄋ",
 "ᇴ": "ᄑᄋ",
 "ퟻ": "ᄑᄐ",
 "ꥺ": "ᄑᄒ",
 "ㅎ": "ᄒ",
 "ᇂ": "ᄒ",
 "ᇵ": "ᄒᄂ",
 "ᇶ": "ᄒᄅ",
 "ᇷ": "ᄒᄆ",
 "ᇸ": "ᄒᄇ",
 "ꥻ": "ᄒᄉ",
 "ᅘ": "ᄒᄒ",
 "ㆅ": "ᄒᄒ",
 "ᄽ": "ᄼᄼ",
 "ᄿ": "ᄾᄾ",
 "ㅿ": "ᅀ",
 "ᇫ": "ᅀ",
 "ퟳ": "ᅀᄇ",
 "ퟴ": "ᅀᄇᄋ",
 "ㆁ": "ᅌ",
 "ᇰ": "ᅌ",
 "ퟵ": "ᅌᄆ",
 "ퟶ": "ᅌᄒ",
 "ᅏ": "ᅎᅎ",
 "ᅑ": "ᅐᅐ",
 "ㆆ": "ᅙ",
 "ᇹ": "ᅙ",
 "ꥼ": "ᅙᅙ",
 "ㅤ": "ᅠ",
 "ㅏ": "ᅡ",
 "ᆣ": "ᅡー",
 "ᅶ": "ᅡᅩ",
 "ᅷ": "ᅡᅮ",
 "ᅢ": "ᅡ丨",
 "ㅐ": "ᅡ丨",
 "ㅑ": "ᅣ",
 "ᅸ": "ᅣᅩ",
 "ᅹ": "ᅣᅭ",
 "ᆤ": "ᅣᅮ",
 "ᅤ": "ᅣ丨",
 "ㅒ": "ᅣ丨",
 "ㅓ": "ᅥ",
 "ᅼ": "ᅥー",
 "ᅺ": "ᅥᅩ",
 "ᅻ": "ᅥᅮ",
 "ᅦ": "ᅥ丨",
 "ㅔ": "ᅥ丨",
 "ㅕ": "ᅧ",
 "ᆥ": "ᅧᅣ",
 "ᅽ": "ᅧᅩ",
 "ᅾ": "ᅧᅮ",
 "ᅨ": "ᅧ丨",
 "ㅖ": "ᅧ丨",
 "ㅗ": "ᅩ",
 "ᅪ": "ᅩᅡ",
 "ㅘ": "ᅩᅡ",
 "ᅫ": "ᅩᅡ丨",
 "ㅙ": "ᅩᅡ丨",
 "ᆦ": "ᅩᅣ",
 "ᆧ": "ᅩᅣ丨",
 "ᅿ": "ᅩᅥ",
 "ᆀ": "ᅩᅥ丨",
 "ힰ": "ᅩᅧ",
 "ᆁ": "ᅩᅧ丨",
 "ᆂ": "ᅩᅩ",
 "ힱ": "ᅩᅩ丨",
 "ᆃ": "ᅩᅮ",
 "ᅬ": "ᅩ丨",
 "ㅚ": "ᅩ丨",
 "ㅛ": "ᅭ",
 "ힲ": "ᅭᅡ",
 "ힳ": "ᅭᅡ丨",
 "ᆄ": "ᅭᅣ",
 "ㆇ": "ᅭᅣ",
 "ᆆ": "ᅭᅣ",
 "ᆅ": "ᅭᅣ丨",
 "ㆈ": "ᅭᅣ丨",
 "ힴ": "ᅭᅥ",
 "ᆇ": "ᅭᅩ",
 "ᆈ": "ᅭ丨",
 "ㆉ": "ᅭ丨",
 "ㅜ": "ᅮ",
 "ᆉ": "ᅮᅡ",
 "ᆊ": "ᅮᅡ丨",
 "ᅯ": "ᅮᅥ",
 "ㅝ": "ᅮᅥ",
 "ᆋ": "ᅮᅥー",
 "ᅰ": "ᅮᅥ丨",
 "ㅞ": "ᅮᅥ丨",
 "ힵ": "ᅮᅧ",
 "ᆌ": "ᅮᅧ丨",
 "ᆍ": "ᅮᅮ",
 "ᅱ": "ᅮ丨",
 "ㅟ": "ᅮ丨",
 "ힶ": "ᅮ丨丨",
 "ㅠ": "ᅲ",
 "ᆎ": "ᅲᅡ",
 "ힷ": "ᅲᅡ丨",
 "ᆏ": "ᅲᅥ",
 "ᆐ": "ᅲᅥ丨",
 "ᆑ": "ᅲᅧ",
 "ㆊ": "ᅲᅧ",
 "ᆒ": "ᅲᅧ丨",
 "ㆋ": "ᅲᅧ丨",
 "ힸ": "ᅲᅩ",
 "ᆓ": "ᅲᅮ",
 "ᆔ": "ᅲ丨",
 "ㆌ": "ᅲ丨",
 "ㆍ": "ᆞ",
 "ퟅ": "ᆞᅡ",
 "ᆟ": "ᆞᅥ",
 "ퟆ": "ᆞᅥ丨",
 "ᆠ": "ᆞᅮ",
 "ᆢ": "ᆞᆞ",
 "ᆡ": "ᆞ丨",
 "ㆎ": "ᆞ丨",
 "ヘ": "へ",
 "⍁": "〼",
 "⧄": "〼",
 "꒞": "ꁊ",
 "꒬": "ꁐ",
 "꒜": "ꃀ",
 "꒨": "ꄲ",
 "꒿": "ꉙ",
 "꒾": "ꊱ",
 "꒔": "ꋍ",
 "꓀": "ꎫ",
 "꓂": "ꎵ",
 "꒺": "ꎿ",
 "꒰": "ꏂ",
 "꒧": "ꑘ",
 "⊥": "ꓕ",
 "⟂": "ꓕ",
 "𝈜": "ꓕ",
 "Ʇ": "ꓕ",
 "Ꞟ": "ꓤ",
 "⅁": "ꓨ",
 "⅂": "ꓶ",
 "𝈕": "ꓶ",
 "𝈫": "ꓶ",
 "𖼦": "ꓶ",
 "𐐑": "ꓶ",
 "⅃": "𖼀",
 "𑫦": "𑫥𑫯",
 "𑫨": "𑫥𑫥",
 "𑫩": "𑫥𑫥𑫯",
 "𑫪": "𑫥𑫥𑫰",
 "𑫧": "𑫥𑫰",
 "𑫴": "𑫳𑫯",
 "𑫶": "𑫳𑫳",
 "𑫷": "𑫳𑫳𑫯",
 "𑫸": "𑫳𑫳𑫰",
 "𑫵": "𑫳𑫰",
 "𑫬": "𑫫𑫯",
 "𑫭": "𑫫𑫫",
 "𑫮": "𑫫𑫫𑫯",
 "⊕": "𐊨",
 "⨁": "𐊨",
 "🜨": "𐊨",
 "Ꚛ": "𐊨",
 "▽": "𐊼",
 "𝈔": "𐊼",
 "🜄": "𐊼",
 "⧖": "𐋀",
 "ꞛ": "𐐺",
 "Ꞛ": "𐐒",
 "𐒠": "𐒆",
 "𐏑": "𐎂",
 "𐏓": "𐎓",
 "𒀸": "𐎚",
 "☥": "𐦞",
 "𓋹": "𐦞",
 "〹": "卄",
 "不": "不",
 "丽": "丽",
 "並": "並",
 "⎜": "丨",
 "⎟": "丨",
 "⎢": "丨",
 "⎥": "丨",
 "⎪": "丨",
 "⎮": "丨",
 "㇑": "丨",
 "ᅵ": "丨",
 "ㅣ": "丨",
 "⼁": "丨",
 "ᆜ": "丨ー",
 "ᆘ": "丨ᅡ",
 "ᆙ": "丨ᅣ",
 "ힽ": "丨ᅣᅩ",
 "ힾ": "丨ᅣ丨",
 "ힿ": "丨ᅧ",
 "ퟀ": "丨ᅧ丨",
 "ᆚ": "丨ᅩ",
 "ퟁ": "丨ᅩ丨",
 "ퟂ": "丨ᅭ",
 "ᆛ": "丨ᅮ",
 "ퟃ": "丨ᅲ",
 "ᆝ": "丨ᆞ",
 "ퟄ": "丨丨",
 "串": "串",
 "丸": "丸",
 "丹": "丹",
 "乁": "乁",
 "㇠": "乙",
 "⼄": "乙",
 "㇟": "乚",
 "⺃": "乚",
 "㇖": "乛",
 "⺂": "乛",
 "⻲": "亀",
 "亂": "亂",
 "㇚": "亅",
 "⼅": "亅",
 "了": "了",
 "ニ": "二",
 "⼆": "二",
 "𠄢": "𠄢",
 "⼇": "亠",
 "亮": "亮",
 "⼈": "人",
 "イ": "亻",
 "⺅": "亻",
 "什": "什",
 "仌": "仌",
 "令": "令",
 "你": "你",
 "倂": "併",
 "倂": "併",
 "侀": "侀",
 "來": "來",
 "例": "例",
 "侮": "侮",
 "侮": "侮",
 "侻": "侻",
 "便": "便",
 "值": "値",
 "倫": "倫",
 "偺": "偺",
 "備": "備",
 "像": "像",
 "僚": "僚",
 "僧": "僧",
 "僧": "僧",
 "㒞": "㒞",
 "⼉": "儿",
 "兀": "兀",
 "⺎": "兀",
 "充": "充",
 "免": "免",
 "免": "免",
 "兔": "兔",
 "兤": "兤",
 "⼊": "入",
 "內": "內",
 "全": "全",
 "兩": "兩",
 "ハ": "八",
 "⼋": "八",
 "六": "六",
 "具": "具",
 "𠔜": "𠔜",
 "𠔥": "𠔥",
 "冀": "冀",
 "㒹": "㒹",
 "⼌": "冂",
 "再": "再",
 "𠕋": "𠕋",
 "冒": "冒",
 "冕": "冕",
 "㒻": "㒻",
 "最": "最",
 "⼍": "冖",
 "冗": "冗",
 "冤": "冤",
 "⼎": "冫",
 "冬": "冬",
 "况": "况",
 "况": "况",
 "冷": "冷",
 "凉": "凉",
 "凌": "凌",
 "凜": "凜",
 "凞": "凞",
 "⼏": "几",
 "𠘺": "𠘺",
 "凵": "凵",
 "⼐": "凵",
 "⼑": "刀",
 "⺉": "刂",
 "刃": "刃",
 "切": "切",
 "切": "切",
 "列": "列",
 "利": "利",
 "㓟": "㓟",
 "刺": "刺",
 "刻": "刻",
 "剆": "剆",
 "割": "割",
 "剷": "剷",
 "劉": "劉",
 "𠠄": "𠠄",
 "カ": "力",
 "力": "力",
 "⼒": "力",
 "劣": "劣",
 "㔕": "㔕",
 "劳": "劳",
 "勇": "勇",
 "勇": "勇",
 "勉": "勉",
 "勉": "勉",
 "勒": "勒",
 "勞": "勞",
 "勤": "勤",
 "勤": "勤",
 "勵": "勵",
 "⼓": "勹",
 "勺": "勺",
 "勺": "勺",
 "包": "包",
 "匆": "匆",
 "𠣞": "𠣞",
 "⼔": "匕",
 "北": "北",
 "北": "北",
 "⼕": "匚",
 "⼖": "匸",
 "匿": "匿",
 "⼗": "十",
 "〸": "十",
 "〺": "卅",
 "卉": "卉",
 "࿖": "卍",
 "࿕": "卐",
 "卑": "卑",
 "卑": "卑",
 "博": "博",
 "ト": "卜",
 "⼘": "卜",
 "⼙": "卩",
 "⺋": "㔾",
 "即": "即",
 "卵": "卵",
 "卽": "卽",
 "卿": "卿",
 "卿": "卿",
 "卿": "卿",
 "⼚": "厂",
 "𠨬": "𠨬",
 "⼛": "厶",
 "參": "參",
 "⼜": "又",
 "及": "及",
 "叟": "叟",
 "𠭣": "𠭣",
 "ロ": "口",
 "⼝": "口",
 "囗": "口",
 "⼞": "口",
 "句": "句",
 "叫": "叫",
 "叱": "叱",
 "吆": "吆",
 "吏": "吏",
 "吝": "吝",
 "吸": "吸",
 "呂": "呂",
 "呈": "呈",
 "周": "周",
 "咞": "咞",
 "咢": "咢",
 "咽": "咽",
 "䎛": "㖈",
 "哶": "哶",
 "唐": "唐",
 "啓": "啓",
 "啟": "啓",
 "啕": "啕",
 "啣": "啣",
 "善": "善",
 "善": "善",
 "喇": "喇",
 "喙": "喙",
 "喙": "喙",
 "喝": "喝",
 "喝": "喝",
 "喫": "喫",
 "喳": "喳",
 "嗀": "嗀",
 "嗂": "嗂",
 "嗢": "嗢",
 "嘆": "嘆",
 "嘆": "嘆",
 "噑": "噑",
 "噴": "噴",
 "器": "器",
 "囹": "囹",
 "圖": "圖",
 "圗": "圗",
 "⼟": "土",
 "士": "土",
 "⼠": "土",
 "型": "型",
 "城": "城",
 "㦳": "㘽",
 "埴": "埴",
 "堍": "堍",
 "報": "報",
 "堲": "堲",
 "塀": "塀",
 "塚": "塚",
 "塚": "塚",
 "塞": "塞",
 "填": "塡",
 "壿": "墫",
 "墬": "墬",
 "墳": "墳",
 "壘": "壘",
 "壟": "壟",
 "𡓤": "𡓤",
 "壮": "壮",
 "売": "売",
 "壷": "壷",
 "⼡": "夂",
 "夆": "夆",
 "⼢": "夊",
 "タ": "夕",
 "⼣": "夕",
 "多": "多",
 "夢": "夢",
 "⼤": "大",
 "奄": "奄",
 "奈": "奈",
 "契": "契",
 "奔": "奔",
 "奢": "奢",
 "女": "女",
 "⼥": "女",
 "𡚨": "𡚨",
 "𡛪": "𡛪",
 "姘": "姘",
 "姬": "姬",
 "娛": "娛",
 "娧": "娧",
 "婢": "婢",
 "婦": "婦",
 "嬀": "媯",
 "㛮": "㛮",
 "㛼": "㛼",
 "媵": "媵",
 "嬈": "嬈",
 "嬨": "嬨",
 "嬾": "嬾",
 "嬾": "嬾",
 "⼦": "子",
 "⼧": "宀",
 "宅": "宅",
 "𡧈": "𡧈",
 "寃": "寃",
 "寘": "寘",
 "寧": "寧",
 "寧": "寧",
 "寧": "寧",
 "寮": "寮",
 "寳": "寳",
 "𡬘": "𡬘",
 "⼨": "寸",
 "寿": "寿",
 "将": "将",
 "⼩": "小",
 "尢": "尢",
 "⺐": "尢",
 "⼪": "尢",
 "⺏": "尣",
 "㞁": "㞁",
 "⼫": "尸",
 "尿": "尿",
 "屠": "屠",
 "屢": "屢",
 "層": "層",
 "履": "履",
 "屮": "屮",
 "屮": "屮",
 "⼬": "屮",
 "𡴋": "𡴋",
 "⼭": "山",
 "峀": "峀",
 "岍": "岍",
 "𡷤": "𡷤",
 "𡷦": "𡷦",
 "崙": "崙",
 "嵃": "嵃",
 "嵐": "嵐",
 "嵫": "嵫",
 "嵮": "嵮",
 "嵼": "嵼",
 "嶲": "嶲",
 "嶺": "嶺",
 "⼮": "巛",
 "巢": "巢",
 "エ": "工",
 "⼯": "工",
 "⼰": "己",
 "⺒": "巳",
 "㠯": "㠯",
 "巽": "巽",
 "⼱": "巾",
 "帲": "帡",
 "帨": "帨",
 "帽": "帽",
 "幩": "幩",
 "㡢": "㡢",
 "𢆃": "𢆃",
 "⼲": "干",
 "年": "年",
 "𢆟": "𢆟",
 "⺓": "幺",
 "⼳": "幺",
 "⼴": "广",
 "度": "度",
 "㡼": "㡼",
 "庰": "庰",
 "庳": "庳",
 "庶": "庶",
 "廊": "廊",
 "廊": "廊",
 "廉": "廉",
 "廒": "廒",
 "廓": "廓",
 "廙": "廙",
 "廬": "廬",
 "⼵": "廴",
 "廾": "廾",
 "⼶": "廾",
 "𢌱": "𢌱",
 "𢌱": "𢌱",
 "弄": "弄",
 "⼷": "弋",
 "⼸": "弓",
 "弢": "弢",
 "弢": "弢",
 "⼹": "彐",
 "⺔": "彑",
 "当": "当",
 "㣇": "㣇",
 "⼺": "彡",
 "形": "形",
 "彩": "彩",
 "彫": "彫",
 "⼻": "彳",
 "律": "律",
 "㣣": "㣣",
 "徚": "徚",
 "復": "復",
 "徭": "徭",
 "⼼": "心",
 "⺖": "忄",
 "⺗": "㣺",
 "忍": "忍",
 "志": "志",
 "念": "念",
 "忹": "忹",
 "怒": "怒",
 "怜": "怜",
 "恵": "恵",
 "㤜": "㤜",
 "㤺": "㤺",
 "悁": "悁",
 "悔": "悔",
 "悔": "悔",
 "惇": "惇",
 "惘": "惘",
 "惡": "惡",
 "𢛔": "𢛔",
 "愈": "愈",
 "慨": "慨",
 "慄": "慄",
 "慈": "慈",
 "慌": "慌",
 "慌": "慌",
 "慎": "慎",
 "慎": "慎",
 "慠": "慠",
 "慺": "慺",
 "憎": "憎",
 "憎": "憎",
 "憎": "憎",
 "憐": "憐",
 "憤": "憤",
 "憯": "憯",
 "憲": "憲",
 "𢡄": "𢡄",
 "𢡊": "𢡊",
 "懞": "懞",
 "懲": "懲",
 "懲": "懲",
 "懲": "懲",
 "懶": "懶",
 "懶": "懶",
 "戀": "戀",
 "⼽": "戈",
 "成": "成",
 "戛": "戛",
 "戮": "戮",
 "戴": "戴",
 "⼾": "戶",
 "戸": "戶",
 "⼿": "手",
 "⺘": "扌",
 "扝": "扝",
 "抱": "抱",
 "拉": "拉",
 "拏": "拏",
 "拓": "拓",
 "拔": "拔",
 "拼": "拼",
 "拾": "拾",
 "𢬌": "𢬌",
 "挽": "挽",
 "捐": "捐",
 "捨": "捨",
 "捻": "捻",
 "掃": "掃",
 "掠": "掠",
 "掩": "掩",
 "揄": "揄",
 "揤": "揤",
 "摒": "摒",
 "𢯱": "𢯱",
 "搜": "搜",
 "搢": "搢",
 "揅": "揅",
 "摩": "摩",
 "摷": "摷",
 "摾": "摾",
 "㨮": "㨮",
 "搉": "㩁",
 "撚": "撚",
 "撝": "撝",
 "擄": "擄",
 "㩬": "㩬",
 "⽀": "支",
 "⽁": "攴",
 "⺙": "攵",
 "敏": "敏",
 "敏": "敏",
 "敖": "敖",
 "敬": "敬",
 "數": "數",
 "𣀊": "𣀊",
 "⽂": "文",
 "⻫": "斉",
 "⽃": "斗",
 "料": "料",
 "⽄": "斤",
 "⽅": "方",
 "旅": "旅",
 "⽆": "无",
 "⺛": "旡",
 "既": "既",
 "旣": "旣",
 "⽇": "日",
 "易": "易",
 "曶": "㫚",
 "㫤": "㫤",
 "晉": "晉",
 "晩": "晚",
 "晴": "晴",
 "晴": "晴",
 "暑": "暑",
 "暑": "暑",
 "暈": "暈",
 "㬈": "㬈",
 "暜": "暜",
 "暴": "暴",
 "曆": "曆",
 "㬙": "㬙",
 "𣊸": "𣊸",
 "⽈": "曰",
 "更": "更",
 "書": "書",
 "⽉": "月",
 "𣍟": "𣍟",
 "肦": "朌",
 "胐": "朏",
 "胊": "朐",
 "脁": "朓",
 "胶": "㬵",
 "朗": "朗",
 "朗": "朗",
 "朗": "朗",
 "脧": "朘",
 "望": "望",
 "望": "望",
 "朡": "朡",
 "幐": "㬺",
 "䐠": "㬻",
 "𣎓": "𣎓",
 "膧": "朣",
 "𣎜": "𣎜",
 "⽊": "木",
 "李": "李",
 "杓": "杓",
 "杖": "杖",
 "杞": "杞",
 "𣏃": "𣏃",
 "柿": "杮",
 "杻": "杻",
 "枅": "枅",
 "林": "林",
 "㭉": "㭉",
 "𣏕": "𣏕",
 "柳": "柳",
 "柺": "柺",
 "栗": "栗",
 "栟": "栟",
 "桒": "桒",
 "𣑭": "𣑭",
 "梁": "梁",
 "梅": "梅",
 "梅": "梅",
 "梎": "梎",
 "梨": "梨",
 "椔": "椔",
 "楂": "楂",
 "㮝": "㮝",
 "㮝": "㮝",
 "槩": "㮣",
 "樧": "榝",
 "榣": "榣",
 "槪": "槪",
 "樂": "樂",
 "樂": "樂",
 "樂": "樂",
 "樓": "樓",
 "𣚣": "𣚣",
 "檨": "檨",
 "櫓": "櫓",
 "櫛": "櫛",
 "欄": "欄",
 "㰘": "㰘",
 "⽋": "欠",
 "次": "次",
 "𣢧": "𣢧",
 "歔": "歔",
 "㱎": "㱎",
 "⽌": "止",
 "⻭": "歯",
 "歲": "歲",
 "歷": "歷",
 "歹": "歹",
 "⽍": "歹",
 "⺞": "歺",
 "殟": "殟",
 "殮": "殮",
 "⽎": "殳",
 "殺": "殺",
 "殺": "殺",
 "殺": "殺",
 "殻": "殻",
 "𣪍": "𣪍",
 "⽏": "毋",
 "⺟": "母",
 "𣫺": "𣫺",
 "⽐": "比",
 "⽑": "毛",
 "⽒": "氏",
 "⺠": "民",
 "⽓": "气",
 "⽔": "水",
 "⺡": "氵",
 "⺢": "氺",
 "汎": "汎",
 "汧": "汧",
 "沈": "沈",
 "沿": "沿",
 "泌": "泌",
 "泍": "泍",
 "泥": "泥",
 "𣲼": "𣲼",
 "洛": "洛",
 "洞": "洞",
 "洴": "洴",
 "派": "派",
 "流": "流",
 "流": "流",
 "流": "流",
 "洖": "洖",
 "浩": "浩",
 "浪": "浪",
 "海": "海",
 "海": "海",
 "浸": "浸",
 "涅": "涅",
 "𣴞": "𣴞",
 "淋": "淋",
 "淚": "淚",
 "淪": "淪",
 "淹": "淹",
 "渚": "渚",
 "港": "港",
 "湮": "湮",
 "潙": "溈",
 "滋": "滋",
 "滋": "滋",
 "溜": "溜",
 "溺": "溺",
 "滇": "滇",
 "滑": "滑",
 "滛": "滛",
 "㴳": "㴳",
 "漏": "漏",
 "漢": "漢",
 "漢": "漢",
 "漣": "漣",
 "𣻑": "𣻑",
 "潮": "潮",
 "𣽞": "𣽞",
 "𣾎": "𣾎",
 "濆": "濆",
 "濫": "濫",
 "濾": "濾",
 "瀛": "瀛",
 "瀞": "瀞",
 "瀞": "瀞",
 "瀹": "瀹",
 "灊": "灊",
 "㶖": "㶖",
 "⽕": "火",
 "⺣": "灬",
 "灰": "灰",
 "灷": "灷",
 "災": "災",
 "炙": "炙",
 "炭": "炭",
 "烈": "烈",
 "烙": "烙",
 "煮": "煮",
 "煮": "煮",
 "𤉣": "𤉣",
 "煅": "煅",
 "煉": "煉",
 "𤋮": "𤋮",
 "熜": "熜",
 "燎": "燎",
 "燐": "燐",
 "𤎫": "𤎫",
 "爐": "爐",
 "爛": "爛",
 "爨": "爨",
 "⽖": "爪",
 "爫": "爫",
 "⺤": "爫",
 "爵": "爵",
 "爵": "爵",
 "⽗": "父",
 "⽘": "爻",
 "⺦": "丬",
 "⽙": "爿",
 "⽚": "片",
 "牐": "牐",
 "⽛": "牙",
 "𤘈": "𤘈",
 "⽜": "牛",
 "牢": "牢",
 "犀": "犀",
 "犕": "犕",
 "⽝": "犬",
 "⺨": "犭",
 "犯": "犯",
 "狀": "狀",
 "𤜵": "𤜵",
 "狼": "狼",
 "猪": "猪",
 "猪": "猪",
 "𤠔": "𤠔",
 "獵": "獵",
 "獺": "獺",
 "⽞": "玄",
 "率": "率",
 "率": "率",
 "⽟": "玉",
 "王": "王",
 "㺬": "㺬",
 "玥": "玥",
 "玲": "玲",
 "㺸": "㺸",
 "㺸": "㺸",
 "珞": "珞",
 "琉": "琉",
 "理": "理",
 "琢": "琢",
 "瑇": "瑇",
 "瑜": "瑜",
 "瑩": "瑩",
 "瑱": "瑱",
 "瑱": "瑱",
 "璅": "璅",
 "璉": "璉",
 "璘": "璘",
 "瓊": "瓊",
 "⽠": "瓜",
 "⽡": "瓦",
 "㼛": "㼛",
 "甆": "甆",
 "⽢": "甘",
 "⽣": "生",
 "甤": "甤",
 "⽤": "用",
 "⽥": "田",
 "画": "画",
 "甾": "甾",
 "𤰶": "𤰶",
 "留": "留",
 "略": "略",
 "異": "異",
 "異": "異",
 "𤲒": "𤲒",
 "⽦": "疋",
 "⽧": "疒",
 "痢": "痢",
 "瘐": "瘐",
 "瘟": "瘟",
 "瘝": "瘝",
 "療": "療",
 "癩": "癩",
 "⽨": "癶",
 "⽩": "白",
 "𤾡": "𤾡",
 "𤾸": "𤾸",
 "⽪": "皮",
 "⽫": "皿",
 "𥁄": "𥁄",
 "㿼": "㿼",
 "益": "益",
 "益": "益",
 "盛": "盛",
 "盧": "盧",
 "䀈": "䀈",
 "⽬": "目",
 "直": "直",
 "直": "直",
 "𥃲": "𥃲",
 "𥃳": "𥃳",
 "省": "省",
 "䀘": "䀘",
 "𥄙": "𥄙",
 "眞": "眞",
 "真": "真",
 "真": "真",
 "𥄳": "𥄳",
 "着": "着",
 "睊": "睊",
 "睊": "睊",
 "鿃": "䀹",
 "䀹": "䀹",
 "䀹": "䀹",
 "晣": "䀿",
 "䁆": "䁆",
 "瞋": "瞋",
 "𥉉": "𥉉",
 "瞧": "瞧",
 "⽭": "矛",
 "⽮": "矢",
 "⽯": "石",
 "䂖": "䂖",
 "𥐝": "𥐝",
 "硏": "研",
 "硎": "硎",
 "硫": "硫",
 "碌": "碌",
 "碌": "碌",
 "碑": "碑",
 "磊": "磊",
 "磌": "磌",
 "磌": "磌",
 "磻": "磻",
 "䃣": "䃣",
 "礪": "礪",
 "⽰": "示",
 "⺭": "礻",
 "礼": "礼",
 "社": "社",
 "祈": "祈",
 "祉": "祉",
 "𥘦": "𥘦",
 "祐": "祐",
 "祖": "祖",
 "祖": "祖",
 "祝": "祝",
 "神": "神",
 "祥": "祥",
 "視": "視",
 "視": "視",
 "祿": "祿",
 "𥚚": "𥚚",
 "禍": "禍",
 "禎": "禎",
 "福": "福",
 "福": "福",
 "𥛅": "𥛅",
 "禮": "禮",
 "⽱": "禸",
 "⽲": "禾",
 "秊": "秊",
 "䄯": "䄯",
 "秫": "秫",
 "稜": "稜",
 "穊": "穊",
 "穀": "穀",
 "穀": "穀",
 "穏": "穏",
 "⽳": "穴",
 "突": "突",
 "𥥼": "𥥼",
 "窱": "窱",
 "立": "立",
 "⽴": "立",
 "⻯": "竜",
 "𥪧": "𥪧",
 "𥪧": "𥪧",
 "竮": "竮",
 "⽵": "竹",
 "笠": "笠",
 "節": "節",
 "節": "節",
 "䈂": "䈂",
 "𥮫": "𥮫",
 "篆": "篆",
 "䈧": "䈧",
 "築": "築",
 "𥲀": "𥲀",
 "𥳐": "𥳐",
 "簾": "簾",
 "籠": "籠",
 "⽶": "米",
 "类": "类",
 "粒": "粒",
 "精": "精",
 "糒": "糒",
 "糖": "糖",
 "糨": "糨",
 "䊠": "䊠",
 "糣": "糣",
 "糧": "糧",
 "⽷": "糸",
 "⺯": "糹",
 "𥾆": "𥾆",
 "紀": "紀",
 "紐": "紐",
 "索": "索",
 "累": "累",
 "絶": "絕",
 "絣": "絣",
 "絛": "絛",
 "綠": "綠",
 "綾": "綾",
 "緇": "緇",
 "練": "練",
 "練": "練",
 "練": "練",
 "縂": "縂",
 "䌁": "䌁",
 "縉": "縉",
 "縷": "縷",
 "繁": "繁",
 "繅": "繅",
 "𦇚": "𦇚",
 "䌴": "䌴",
 "⽸": "缶",
 "𦈨": "𦈨",
 "缾": "缾",
 "𦉇": "𦉇",
 "⽹": "网",
 "⺫": "罒",
 "⺲": "罒",
 "⺱": "罓",
 "䍙": "䍙",
 "署": "署",
 "𦋙": "𦋙",
 "罹": "罹",
 "罺": "罺",
 "羅": "羅",
 "𦌾": "𦌾",
 "⽺": "羊",
 "羕": "羕",
 "羚": "羚",
 "羽": "羽",
 "⽻": "羽",
 "翺": "翺",
 "老": "老",
 "⽼": "老",
 "⺹": "耂",
 "者": "者",
 "者": "者",
 "者": "者",
 "⽽": "而",
 "𦓚": "𦓚",
 "⽾": "耒",
 "𦔣": "𦔣",
 "⽿": "耳",
 "聆": "聆",
 "聠": "聠",
 "𦖨": "𦖨",
 "聯": "聯",
 "聰": "聰",
 "聾": "聾",
 "⾀": "聿",
 "⺺": "肀",
 "⾁": "肉",
 "肋": "肋",
 "肭": "肭",
 "育": "育",
 "䏕": "䏕",
 "䏙": "䏙",
 "腁": "胼",
 "脃": "脃",
 "脾": "脾",
 "䐋": "䐋",
 "𦞧": "𦞧",
 "𦞵": "𦞵",
 "朦": "䑃",
 "臘": "臘",
 "⾂": "臣",
 "臨": "臨",
 "⾃": "自",
 "臭": "臭",
 "⾄": "至",
 "⾅": "臼",
 "舁": "舁",
 "舁": "舁",
 "舄": "舄",
 "⾆": "舌",
 "舘": "舘",
 "⾇": "舛",
 "⾈": "舟",
 "䑫": "䑫",
 "⾉": "艮",
 "良": "良",
 "⾊": "色",
 "⾋": "艸",
 "艹": "艹",
 "艹": "艹",
 "⺾": "艹",
 "⺿": "艹",
 "⻀": "艹",
 "芋": "芋",
 "芑": "芑",
 "芝": "芝",
 "花": "花",
 "芳": "芳",
 "芽": "芽",
 "若": "若",
 "若": "若",
 "苦": "苦",
 "𦬼": "𦬼",
 "茶": "茶",
 "荒": "荒",
 "荣": "荣",
 "茝": "茝",
 "茣": "茣",
 "莽": "莽",
 "荓": "荓",
 "菉": "菉",
 "菊": "菊",
 "菌": "菌",
 "菜": "菜",
 "菧": "菧",
 "華": "華",
 "菱": "菱",
 "著": "著",
 "著": "著",
 "𦰶": "𦰶",
 "莭": "莭",
 "落": "落",
 "葉": "葉",
 "蔿": "蒍",
 "𦳕": "𦳕",
 "𦵫": "𦵫",
 "蓮": "蓮",
 "蓱": "蓱",
 "蓳": "蓳",
 "蓼": "蓼",
 "蔖": "蔖",
 "䔫": "䔫",
 "蕤": "蕤",
 "𦼬": "𦼬",
 "藍": "藍",
 "䕝": "䕝",
 "𦾱": "𦾱",
 "䕡": "䕡",
 "藺": "藺",
 "蘆": "蘆",
 "䕫": "䕫",
 "蘒": "蘒",
 "蘭": "蘭",
 "𧃒": "𧃒",
 "虁": "蘷",
 "蘿": "蘿",
 "⾌": "虍",
 "⻁": "虎",
 "虐": "虐",
 "虜": "虜",
 "虜": "虜",
 "虧": "虧",
 "虩": "虩",
 "⾍": "虫",
 "蚩": "蚩",
 "蚈": "蚈",
 "蛢": "蛢",
 "蜎": "蜎",
 "蜨": "蜨",
 "蝫": "蝫",
 "蟡": "蟡",
 "蝹": "蝹",
 "蝹": "蝹",
 "螆": "螆",
 "䗗": "䗗",
 "𧏊": "𧏊",
 "螺": "螺",
 "蠁": "蠁",
 "䗹": "䗹",
 "蠟": "蠟",
 "⾎": "血",
 "行": "行",
 "⾏": "行",
 "衠": "衠",
 "衣": "衣",
 "⾐": "衣",
 "⻂": "衤",
 "裂": "裂",
 "𧙧": "𧙧",
 "裏": "裏",
 "裗": "裗",
 "裞": "裞",
 "裡": "裡",
 "裸": "裸",
 "裺": "裺",
 "䘵": "䘵",
 "褐": "褐",
 "襁": "襁",
 "襤": "襤",
 "⾑": "襾",
 "⻄": "西",
 "⻃": "覀",
 "覆": "覆",
 "見": "見",
 "⾒": "見",
 "𧢮": "𧢮",
 "⻅": "见",
 "⾓": "角",
 "⾔": "言",
 "𧥦": "𧥦",
 "詽": "訮",
 "訞": "䚶",
 "䚾": "䚾",
 "䛇": "䛇",
 "誠": "誠",
 "說": "說",
 "說": "說",
 "調": "調",
 "請": "請",
 "諒": "諒",
 "論": "論",
 "諭": "諭",
 "諭": "諭",
 "諸": "諸",
 "諸": "諸",
 "諾": "諾",
 "諾": "諾",
 "謁": "謁",
 "謁": "謁",
 "謹": "謹",
 "謹": "謹",
 "識": "識",
 "讀": "讀",
 "讏": "讆",
 "變": "變",
 "變": "變",
 "⻈": "讠",
 "⾕": "谷",
 "⾖": "豆",
 "豈": "豈",
 "豕": "豕",
 "⾗": "豕",
 "豣": "豜",
 "⾘": "豸",
 "𧲨": "𧲨",
 "⾙": "貝",
 "貫": "貫",
 "賁": "賁",
 "賂": "賂",
 "賈": "賈",
 "賓": "賓",
 "贈": "贈",
 "贈": "贈",
 "贛": "贛",
 "⻉": "贝",
 "⾚": "赤",
 "⾛": "走",
 "起": "起",
 "趆": "赿",
 "𧻓": "𧻓",
 "𧼯": "𧼯",
 "⾜": "足",
 "跋": "跋",
 "趼": "趼",
 "跺": "跥",
 "路": "路",
 "跰": "跰",
 "躛": "躗",
 "⾝": "身",
 "車": "車",
 "⾞": "車",
 "軔": "軔",
 "輧": "軿",
 "輦": "輦",
 "輪": "輪",
 "輸": "輸",
 "輸": "輸",
 "輻": "輻",
 "轢": "轢",
 "⻋": "车",
 "⾟": "辛",
 "辞": "辞",
 "辰": "辰",
 "⾠": "辰",
 "⾡": "辵",
 "辶": "辶",
 "⻌": "辶",
 "⻍": "辶",
 "巡": "巡",
 "連": "連",
 "逸": "逸",
 "逸": "逸",
 "遲": "遲",
 "遼": "遼",
 "𨗒": "𨗒",
 "𨗭": "𨗭",
 "邏": "邏",
 "⾢": "邑",
 "邔": "邔",
 "郎": "郎",
 "郞": "郎",
 "郞": "郎",
 "郱": "郱",
 "都": "都",
 "𨜮": "𨜮",
 "鄑": "鄑",
 "鄛": "鄛",
 "⾣": "酉",
 "酪": "酪",
 "醙": "醙",
 "醴": "醴",
 "⾤": "釆",
 "里": "里",
 "⾥": "里",
 "量": "量",
 "金": "金",
 "⾦": "金",
 "鈴": "鈴",
 "鈸": "鈸",
 "鉶": "鉶",
 "鋗": "鋗",
 "鋘": "鋘",
 "鉼": "鉼",
 "錄": "錄",
 "鍊": "鍊",
 "鎮": "鎭",
 "鏹": "鏹",
 "鐕": "鐕",
 "𨯺": "𨯺",
 "⻐": "钅",
 "⻑": "長",
 "⾧": "長",
 "⻒": "镸",
 "⻓": "长",
 "⾨": "門",
 "開": "開",
 "䦕": "䦕",
 "閭": "閭",
 "閷": "閷",
 "𨵷": "𨵷",
 "⻔": "门",
 "⾩": "阜",
 "⻏": "阝",
 "⻖": "阝",
 "阮": "阮",
 "陋": "陋",
 "降": "降",
 "陵": "陵",
 "陸": "陸",
 "陼": "陼",
 "隆": "隆",
 "隣": "隣",
 "䧦": "䧦",
 "⾪": "隶",
 "隷": "隷",
 "隸": "隷",
 "隸": "隷",
 "⾫": "隹",
 "雃": "雃",
 "離": "離",
 "難": "難",
 "難": "難",
 "⾬": "雨",
 "零": "零",
 "雷": "雷",
 "霣": "霣",
 "𩅅": "𩅅",
 "露": "露",
 "靈": "靈",
 "⾭": "靑",
 "⻘": "青",
 "靖": "靖",
 "靖": "靖",
 "𩇟": "𩇟",
 "⾮": "非",
 "⾯": "面",
 "𩈚": "𩈚",
 "⾰": "革",
 "䩮": "䩮",
 "䩶": "䩶",
 "⾱": "韋",
 "韛": "韛",
 "韠": "韠",
 "⻙": "韦",
 "⾲": "韭",
 "𩐊": "𩐊",
 "⾳": "音",
 "響": "響",
 "響": "響",
 "⾴": "頁",
 "䪲": "䪲",
 "頋": "頋",
 "頋": "頋",
 "頋": "頋",
 "領": "領",
 "頩": "頩",
 "𩒖": "𩒖",
 "頻": "頻",
 "頻": "頻",
 "類": "類",
 "⻚": "页",
 "⾵": "風",
 "𩖶": "𩖶",
 "⻛": "风",
 "⾶": "飛",
 "⻜": "飞",
 "⻝": "食",
 "⾷": "食",
 "⻟": "飠",
 "飢": "飢",
 "飯": "飯",
 "飼": "飼",
 "䬳": "䬳",
 "館": "館",
 "餩": "餩",
 "⻠": "饣",
 "⾸": "首",
 "⾹": "香",
 "馧": "馧",
 "⾺": "馬",
 "駂": "駂",
 "駱": "駱",
 "駾": "駾",
 "驪": "驪",
 "⻢": "马",
 "⾻": "骨",
 "䯎": "䯎",
 "⾼": "高",
 "⾽": "髟",
 "𩬰": "𩬰",
 "鬒": "鬒",
 "鬒": "鬒",
 "⾾": "鬥",
 "⾿": "鬯",
 "⿀": "鬲",
 "⿁": "鬼",
 "⻤": "鬼",
 "⿂": "魚",
 "魯": "魯",
 "鱀": "鱀",
 "鱗": "鱗",
 "⻥": "鱼",
 "⿃": "鳥",
 "鳽": "鳽",
 "䳎": "䳎",
 "鵧": "鵧",
 "䳭": "䳭",
 "𪃎": "𪃎",
 "鶴": "鶴",
 "𪄅": "𪄅",
 "䳸": "䳸",
 "鷺": "鷺",
 "𪈎": "𪈎",
 "鸞": "鸞",
 "鹃": "鹂",
 "⿄": "鹵",
 "鹿": "鹿",
 "⿅": "鹿",
 "𪊑": "𪊑",
 "麗": "麗",
 "麟": "麟",
 "⿆": "麥",
 "⻨": "麦",
 "麻": "麻",
 "⿇": "麻",
 "𪎒": "𪎒",
 "⿈": "黃",
 "⻩": "黄",
 "⿉": "黍",
 "黎": "黎",
 "䵖": "䵖",
 "⿊": "黑",
 "黒": "黑",
 "墨": "墨",
 "黹": "黹",
 "⿋": "黹",
 "⿌": "黽",
 "鼅": "鼅",
 "黾": "黾",
 "⿍": "鼎",
 "鼏": "鼏",
 "⿎": "鼓",
 "鼖": "鼖",
 "⿏": "鼠",
 "鼻": "鼻",
 "⿐": "鼻",
 "齃": "齃",
 "⿑": "齊",
 "⻬": "齐",
 "⿒": "齒",
 "𪘀": "𪘀",
 "⻮": "齿",
 "龍": "龍",
 "⿓": "龍",
 "龎": "龎",
 "⻰": "龙",
 "龜": "龜",
 "龜": "龜",
 "龜": "龜",
 "⿔": "龜",
 "⻳": "龟",
 "⿕": "龠"
}
      };
    };
  }
  }
}, {package:"unicode-confusables",file:"node_modules\\unicode-confusables\\data\\confusables.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\unicode-confusables\\index.js", {"./data/confusables.json":"D:\\code\\v\\metamask-extension\\node_modules\\unicode-confusables\\data\\confusables.json"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cunicode-confusables%5Cindex.js
      return function (require, module, exports) {
const CONFUSABLES = require('./data/confusables.json')

const ZERO_WIDTH = ''
const zeroWidthPoints = new Set([
  '\u200b', // zero width space
  '\u200c', // zero width non-joiner
  '\u200d', // zero width joiner
  '\ufeff', // zero width no-break space
  '\u2028', // line separator
  '\u2029', // paragraph separator,
])

function makeSkeleton (string) {
  return [...string].reduce((acc, point) => {
    if (zeroWidthPoints.has(point)) return acc
    acc.push(CONFUSABLES[point] || point)
    return acc
  }, [])
}

function isConfusing (string) {
  const skeleton = makeSkeleton(string)
  const original = [...string]
  for (var i = 0, l = skeleton.length; i < l; i++) {
    if (skeleton[i] !== original[i]) return true
  }

  return false
}

function confusables (string) {
  const skeleton = makeSkeleton(string)
  const original = [...string]
  let offset = 0

  return original.reduce((acc, point, index) => {
    const target = skeleton[index - offset]
    if (target === point || !target) {
      acc.push({point: point})
    } else if (zeroWidthPoints.has(point)) {
      acc.push({ point, similarTo: ZERO_WIDTH })
      offset = offset + 1
    } else {
      acc.push({ point, similarTo: target })
    }

    return acc
  }, [])
}

function rectifyConfusion (string) {
  return confusables(string).map(({ point, similarTo }) => (
    similarTo == null ? point : similarTo
  )).join('')
}

module.exports = {
  isConfusing,
  confusables,
  rectifyConfusion,
}

      };
    };
  }
  }
}, {package:"unicode-confusables",file:"node_modules\\unicode-confusables\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\unified\\index.js", {"bail":"D:\\code\\v\\metamask-extension\\node_modules\\bail\\index.js","extend":"D:\\code\\v\\metamask-extension\\node_modules\\extend\\index.js","is-buffer":"D:\\code\\v\\metamask-extension\\node_modules\\unified\\node_modules\\is-buffer\\index.js","is-plain-obj":"D:\\code\\v\\metamask-extension\\node_modules\\is-plain-obj\\index.js","trough":"D:\\code\\v\\metamask-extension\\node_modules\\trough\\index.js","vfile":"D:\\code\\v\\metamask-extension\\node_modules\\vfile\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cunified%5Cindex.js
      return function (require, module, exports) {
'use strict'

var bail = require('bail')
var buffer = require('is-buffer')
var extend = require('extend')
var plain = require('is-plain-obj')
var trough = require('trough')
var vfile = require('vfile')

// Expose a frozen processor.
module.exports = unified().freeze()

var slice = [].slice
var own = {}.hasOwnProperty

// Process pipeline.
var pipeline = trough()
  .use(pipelineParse)
  .use(pipelineRun)
  .use(pipelineStringify)

function pipelineParse(p, ctx) {
  ctx.tree = p.parse(ctx.file)
}

function pipelineRun(p, ctx, next) {
  p.run(ctx.tree, ctx.file, done)

  function done(err, tree, file) {
    if (err) {
      next(err)
    } else {
      ctx.tree = tree
      ctx.file = file
      next()
    }
  }
}

function pipelineStringify(p, ctx) {
  var result = p.stringify(ctx.tree, ctx.file)
  var file = ctx.file

  if (result === undefined || result === null) {
    // Empty.
  } else if (typeof result === 'string' || buffer(result)) {
    file.contents = result
  } else {
    file.result = result
  }
}

// Function to create the first processor.
function unified() {
  var attachers = []
  var transformers = trough()
  var namespace = {}
  var frozen = false
  var freezeIndex = -1

  // Data management.
  processor.data = data

  // Lock.
  processor.freeze = freeze

  // Plugins.
  processor.attachers = attachers
  processor.use = use

  // API.
  processor.parse = parse
  processor.stringify = stringify
  processor.run = run
  processor.runSync = runSync
  processor.process = process
  processor.processSync = processSync

  // Expose.
  return processor

  // Create a new processor based on the processor in the current scope.
  function processor() {
    var destination = unified()
    var length = attachers.length
    var index = -1

    while (++index < length) {
      destination.use.apply(null, attachers[index])
    }

    destination.data(extend(true, {}, namespace))

    return destination
  }

  // Freeze: used to signal a processor that has finished configuration.
  //
  // For example, take unified itself: it’s frozen.
  // Plugins should not be added to it.
  // Rather, it should be extended, by invoking it, before modifying it.
  //
  // In essence, always invoke this when exporting a processor.
  function freeze() {
    var values
    var plugin
    var options
    var transformer

    if (frozen) {
      return processor
    }

    while (++freezeIndex < attachers.length) {
      values = attachers[freezeIndex]
      plugin = values[0]
      options = values[1]
      transformer = null

      if (options === false) {
        continue
      }

      if (options === true) {
        values[1] = undefined
      }

      transformer = plugin.apply(processor, values.slice(1))

      if (typeof transformer === 'function') {
        transformers.use(transformer)
      }
    }

    frozen = true
    freezeIndex = Infinity

    return processor
  }

  // Data management.
  // Getter / setter for processor-specific informtion.
  function data(key, value) {
    if (typeof key === 'string') {
      // Set `key`.
      if (arguments.length === 2) {
        assertUnfrozen('data', frozen)

        namespace[key] = value

        return processor
      }

      // Get `key`.
      return (own.call(namespace, key) && namespace[key]) || null
    }

    // Set space.
    if (key) {
      assertUnfrozen('data', frozen)
      namespace = key
      return processor
    }

    // Get space.
    return namespace
  }

  // Plugin management.
  //
  // Pass it:
  // *   an attacher and options,
  // *   a preset,
  // *   a list of presets, attachers, and arguments (list of attachers and
  //     options).
  function use(value) {
    var settings

    assertUnfrozen('use', frozen)

    if (value === null || value === undefined) {
      // Empty.
    } else if (typeof value === 'function') {
      addPlugin.apply(null, arguments)
    } else if (typeof value === 'object') {
      if ('length' in value) {
        addList(value)
      } else {
        addPreset(value)
      }
    } else {
      throw new Error('Expected usable value, not `' + value + '`')
    }

    if (settings) {
      namespace.settings = extend(namespace.settings || {}, settings)
    }

    return processor

    function addPreset(result) {
      addList(result.plugins)

      if (result.settings) {
        settings = extend(settings || {}, result.settings)
      }
    }

    function add(value) {
      if (typeof value === 'function') {
        addPlugin(value)
      } else if (typeof value === 'object') {
        if ('length' in value) {
          addPlugin.apply(null, value)
        } else {
          addPreset(value)
        }
      } else {
        throw new Error('Expected usable value, not `' + value + '`')
      }
    }

    function addList(plugins) {
      var length
      var index

      if (plugins === null || plugins === undefined) {
        // Empty.
      } else if (typeof plugins === 'object' && 'length' in plugins) {
        length = plugins.length
        index = -1

        while (++index < length) {
          add(plugins[index])
        }
      } else {
        throw new Error('Expected a list of plugins, not `' + plugins + '`')
      }
    }

    function addPlugin(plugin, value) {
      var entry = find(plugin)

      if (entry) {
        if (plain(entry[1]) && plain(value)) {
          value = extend(entry[1], value)
        }

        entry[1] = value
      } else {
        attachers.push(slice.call(arguments))
      }
    }
  }

  function find(plugin) {
    var length = attachers.length
    var index = -1
    var entry

    while (++index < length) {
      entry = attachers[index]

      if (entry[0] === plugin) {
        return entry
      }
    }
  }

  // Parse a file (in string or vfile representation) into a unist node using
  // the `Parser` on the processor.
  function parse(doc) {
    var file = vfile(doc)
    var Parser

    freeze()
    Parser = processor.Parser
    assertParser('parse', Parser)

    if (newable(Parser, 'parse')) {
      return new Parser(String(file), file).parse()
    }

    return Parser(String(file), file) // eslint-disable-line new-cap
  }

  // Run transforms on a unist node representation of a file (in string or
  // vfile representation), async.
  function run(node, file, cb) {
    assertNode(node)
    freeze()

    if (!cb && typeof file === 'function') {
      cb = file
      file = null
    }

    if (!cb) {
      return new Promise(executor)
    }

    executor(null, cb)

    function executor(resolve, reject) {
      transformers.run(node, vfile(file), done)

      function done(err, tree, file) {
        tree = tree || node
        if (err) {
          reject(err)
        } else if (resolve) {
          resolve(tree)
        } else {
          cb(null, tree, file)
        }
      }
    }
  }

  // Run transforms on a unist node representation of a file (in string or
  // vfile representation), sync.
  function runSync(node, file) {
    var complete = false
    var result

    run(node, file, done)

    assertDone('runSync', 'run', complete)

    return result

    function done(err, tree) {
      complete = true
      bail(err)
      result = tree
    }
  }

  // Stringify a unist node representation of a file (in string or vfile
  // representation) into a string using the `Compiler` on the processor.
  function stringify(node, doc) {
    var file = vfile(doc)
    var Compiler

    freeze()
    Compiler = processor.Compiler
    assertCompiler('stringify', Compiler)
    assertNode(node)

    if (newable(Compiler, 'compile')) {
      return new Compiler(node, file).compile()
    }

    return Compiler(node, file) // eslint-disable-line new-cap
  }

  // Parse a file (in string or vfile representation) into a unist node using
  // the `Parser` on the processor, then run transforms on that node, and
  // compile the resulting node using the `Compiler` on the processor, and
  // store that result on the vfile.
  function process(doc, cb) {
    freeze()
    assertParser('process', processor.Parser)
    assertCompiler('process', processor.Compiler)

    if (!cb) {
      return new Promise(executor)
    }

    executor(null, cb)

    function executor(resolve, reject) {
      var file = vfile(doc)

      pipeline.run(processor, {file: file}, done)

      function done(err) {
        if (err) {
          reject(err)
        } else if (resolve) {
          resolve(file)
        } else {
          cb(null, file)
        }
      }
    }
  }

  // Process the given document (in string or vfile representation), sync.
  function processSync(doc) {
    var complete = false
    var file

    freeze()
    assertParser('processSync', processor.Parser)
    assertCompiler('processSync', processor.Compiler)
    file = vfile(doc)

    process(file, done)

    assertDone('processSync', 'process', complete)

    return file

    function done(err) {
      complete = true
      bail(err)
    }
  }
}

// Check if `value` is a constructor.
function newable(value, name) {
  return (
    typeof value === 'function' &&
    value.prototype &&
    // A function with keys in its prototype is probably a constructor.
    // Classes’ prototype methods are not enumerable, so we check if some value
    // exists in the prototype.
    (keys(value.prototype) || name in value.prototype)
  )
}

// Check if `value` is an object with keys.
function keys(value) {
  var key
  for (key in value) {
    return true
  }

  return false
}

// Assert a parser is available.
function assertParser(name, Parser) {
  if (typeof Parser !== 'function') {
    throw new Error('Cannot `' + name + '` without `Parser`')
  }
}

// Assert a compiler is available.
function assertCompiler(name, Compiler) {
  if (typeof Compiler !== 'function') {
    throw new Error('Cannot `' + name + '` without `Compiler`')
  }
}

// Assert the processor is not frozen.
function assertUnfrozen(name, frozen) {
  if (frozen) {
    throw new Error(
      'Cannot invoke `' +
        name +
        '` on a frozen processor.\nCreate a new processor first, by invoking it: use `processor()` instead of `processor`.'
    )
  }
}

// Assert `node` is a unist node.
function assertNode(node) {
  if (!node || typeof node.type !== 'string') {
    throw new Error('Expected node, got `' + node + '`')
  }
}

// Assert that `complete` is `true`.
function assertDone(name, asyncName, complete) {
  if (!complete) {
    throw new Error(
      '`' + name + '` finished async. Use `' + asyncName + '` instead'
    )
  }
}

      };
    };
  }
  }
}, {package:"react-markdown>unified",file:"node_modules\\unified\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\unified\\node_modules\\is-buffer\\index.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cunified%5Cnode_modules%5Cis-buffer%5Cindex.js
      return function (require, module, exports) {
/*!
 * Determine if an object is a Buffer
 *
 * @author   Feross Aboukhadijeh <https://feross.org>
 * @license  MIT
 */

module.exports = function isBuffer (obj) {
  return obj != null && obj.constructor != null &&
    typeof obj.constructor.isBuffer === 'function' && obj.constructor.isBuffer(obj)
}

      };
    };
  }
  }
}, {package:"react-markdown>unified>is-buffer",file:"node_modules\\unified\\node_modules\\is-buffer\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\unist-builder\\index.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cunist-builder%5Cindex.js
      return function (require, module, exports) {
'use strict'

module.exports = u

function u(type, props, value) {
  var node

  if (
    (value === null || value === undefined) &&
    (typeof props !== 'object' || Array.isArray(props))
  ) {
    value = props
    props = {}
  }

  node = Object.assign({type: String(type)}, props)

  if (Array.isArray(value)) {
    node.children = value
  } else if (value !== null && value !== undefined) {
    node.value = String(value)
  }

  return node
}

      };
    };
  }
  }
}, {package:"react-markdown>remark-rehype>mdast-util-to-hast>unist-builder",file:"node_modules\\unist-builder\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\unist-util-generated\\index.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cunist-util-generated%5Cindex.js
      return function (require, module, exports) {
'use strict'

module.exports = generated

function generated(node) {
  return (
    !node ||
    !node.position ||
    !node.position.start ||
    !node.position.start.line ||
    !node.position.start.column ||
    !node.position.end ||
    !node.position.end.line ||
    !node.position.end.column
  )
}

      };
    };
  }
  }
}, {package:"react-markdown>remark-rehype>mdast-util-to-hast>unist-util-generated",file:"node_modules\\unist-util-generated\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\unist-util-is\\convert.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cunist-util-is%5Cconvert.js
      return function (require, module, exports) {
'use strict'

module.exports = convert

function convert(test) {
  if (typeof test === 'string') {
    return typeFactory(test)
  }

  if (test === null || test === undefined) {
    return ok
  }

  if (typeof test === 'object') {
    return ('length' in test ? anyFactory : matchesFactory)(test)
  }

  if (typeof test === 'function') {
    return test
  }

  throw new Error('Expected function, string, or object as test')
}

function convertAll(tests) {
  var results = []
  var length = tests.length
  var index = -1

  while (++index < length) {
    results[index] = convert(tests[index])
  }

  return results
}

// Utility assert each property in `test` is represented in `node`, and each
// values are strictly equal.
function matchesFactory(test) {
  return matches

  function matches(node) {
    var key

    for (key in test) {
      if (node[key] !== test[key]) {
        return false
      }
    }

    return true
  }
}

function anyFactory(tests) {
  var checks = convertAll(tests)
  var length = checks.length

  return matches

  function matches() {
    var index = -1

    while (++index < length) {
      if (checks[index].apply(this, arguments)) {
        return true
      }
    }

    return false
  }
}

// Utility to convert a string into a function which checks a given node’s type
// for said string.
function typeFactory(test) {
  return type

  function type(node) {
    return Boolean(node && node.type === test)
  }
}

// Utility to return true.
function ok() {
  return true
}

      };
    };
  }
  }
}, {package:"react-markdown>unist-util-visit>unist-util-is",file:"node_modules\\unist-util-is\\convert.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\unist-util-position\\index.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cunist-util-position%5Cindex.js
      return function (require, module, exports) {
'use strict'

var start = factory('start')
var end = factory('end')

module.exports = position

position.start = start
position.end = end

function position(node) {
  return {start: start(node), end: end(node)}
}

function factory(type) {
  point.displayName = type

  return point

  function point(node) {
    var point = (node && node.position && node.position[type]) || {}

    return {
      line: point.line || null,
      column: point.column || null,
      offset: isNaN(point.offset) ? null : point.offset
    }
  }
}

      };
    };
  }
  }
}, {package:"react-markdown>remark-rehype>mdast-util-to-hast>unist-util-position",file:"node_modules\\unist-util-position\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\unist-util-stringify-position\\index.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cunist-util-stringify-position%5Cindex.js
      return function (require, module, exports) {
'use strict'

var own = {}.hasOwnProperty

module.exports = stringify

function stringify(value) {
  // Nothing.
  if (!value || typeof value !== 'object') {
    return ''
  }

  // Node.
  if (own.call(value, 'position') || own.call(value, 'type')) {
    return position(value.position)
  }

  // Position.
  if (own.call(value, 'start') || own.call(value, 'end')) {
    return position(value)
  }

  // Point.
  if (own.call(value, 'line') || own.call(value, 'column')) {
    return point(value)
  }

  // ?
  return ''
}

function point(point) {
  if (!point || typeof point !== 'object') {
    point = {}
  }

  return index(point.line) + ':' + index(point.column)
}

function position(pos) {
  if (!pos || typeof pos !== 'object') {
    pos = {}
  }

  return point(pos.start) + '-' + point(pos.end)
}

function index(value) {
  return value && typeof value === 'number' ? value : 1
}

      };
    };
  }
  }
}, {package:"react-markdown>vfile>unist-util-stringify-position",file:"node_modules\\unist-util-stringify-position\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\unist-util-visit-parents\\color.browser.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cunist-util-visit-parents%5Ccolor.browser.js
      return function (require, module, exports) {
module.exports = identity
function identity(d) {
  return d
}

      };
    };
  }
  }
}, {package:"react-markdown>unist-util-visit>unist-util-visit-parents",file:"node_modules\\unist-util-visit-parents\\color.browser.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\unist-util-visit-parents\\index.js", {"./color":"D:\\code\\v\\metamask-extension\\node_modules\\unist-util-visit-parents\\color.browser.js","unist-util-is/convert":"D:\\code\\v\\metamask-extension\\node_modules\\unist-util-is\\convert.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cunist-util-visit-parents%5Cindex.js
      return function (require, module, exports) {
'use strict'

module.exports = visitParents

var convert = require('unist-util-is/convert')
var color = require('./color')

var CONTINUE = true
var SKIP = 'skip'
var EXIT = false

visitParents.CONTINUE = CONTINUE
visitParents.SKIP = SKIP
visitParents.EXIT = EXIT

function visitParents(tree, test, visitor, reverse) {
  var is

  if (func(test) && !func(visitor)) {
    reverse = visitor
    visitor = test
    test = null
  }

  is = convert(test)

  one(tree, null, [])()

  function one(child, index, parents) {
    var value = object(child) ? child : {}
    var name

    if (string(value.type)) {
      name = string(value.tagName)
        ? value.tagName
        : string(value.name)
        ? value.name
        : undefined

      node.displayName =
        'node (' + color(value.type + (name ? '<' + name + '>' : '')) + ')'
    }

    return node

    function node() {
      var result = []
      var subresult

      if (!test || is(child, index, parents[parents.length - 1] || null)) {
        result = toResult(visitor(child, parents))

        if (result[0] === EXIT) {
          return result
        }
      }

      if (!child.children || result[0] === SKIP) {
        return result
      }

      subresult = toResult(children(child.children, parents.concat(child)))
      return subresult[0] === EXIT ? subresult : result
    }
  }

  // Visit children in `parent`.
  function children(children, parents) {
    var min = -1
    var step = reverse ? -1 : 1
    var index = (reverse ? children.length : min) + step
    var child
    var result

    while (index > min && index < children.length) {
      child = children[index]
      result = one(child, index, parents)()

      if (result[0] === EXIT) {
        return result
      }

      index = typeof result[1] === 'number' ? result[1] : index + step
    }
  }
}

function toResult(value) {
  if (object(value) && 'length' in value) {
    return value
  }

  if (typeof value === 'number') {
    return [CONTINUE, value]
  }

  return [value]
}

function func(d) {
  return typeof d === 'function'
}

function string(d) {
  return typeof d === 'string'
}

function object(d) {
  return typeof d === 'object' && d !== null
}

      };
    };
  }
  }
}, {package:"react-markdown>unist-util-visit>unist-util-visit-parents",file:"node_modules\\unist-util-visit-parents\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\unist-util-visit\\index.js", {"unist-util-visit-parents":"D:\\code\\v\\metamask-extension\\node_modules\\unist-util-visit-parents\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cunist-util-visit%5Cindex.js
      return function (require, module, exports) {
'use strict'

module.exports = visit

var visitParents = require('unist-util-visit-parents')

var CONTINUE = visitParents.CONTINUE
var SKIP = visitParents.SKIP
var EXIT = visitParents.EXIT

visit.CONTINUE = CONTINUE
visit.SKIP = SKIP
visit.EXIT = EXIT

function visit(tree, test, visitor, reverse) {
  if (typeof test === 'function' && typeof visitor !== 'function') {
    reverse = visitor
    visitor = test
    test = null
  }

  visitParents(tree, test, overload, reverse)

  function overload(node, parents) {
    var parent = parents[parents.length - 1]
    var index = parent ? parent.children.indexOf(node) : null
    return visitor(node, index, parent)
  }
}

      };
    };
  }
  }
}, {package:"react-markdown>unist-util-visit",file:"node_modules\\unist-util-visit\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\use-memo-one\\dist\\use-memo-one.cjs.js", {"react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cuse-memo-one%5Cdist%5Cuse-memo-one.cjs.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var react = require('react');

function areInputsEqual(newInputs, lastInputs) {
  if (newInputs.length !== lastInputs.length) {
    return false;
  }

  for (var i = 0; i < newInputs.length; i++) {
    if (newInputs[i] !== lastInputs[i]) {
      return false;
    }
  }

  return true;
}

function useMemoOne(getResult, inputs) {
  var initial = react.useState(function () {
    return {
      inputs: inputs,
      result: getResult()
    };
  })[0];
  var isFirstRun = react.useRef(true);
  var committed = react.useRef(initial);
  var useCache = isFirstRun.current || Boolean(inputs && committed.current.inputs && areInputsEqual(inputs, committed.current.inputs));
  var cache = useCache ? committed.current : {
    inputs: inputs,
    result: getResult()
  };
  react.useEffect(function () {
    isFirstRun.current = false;
    committed.current = cache;
  }, [cache]);
  return cache.result;
}
function useCallbackOne(callback, inputs) {
  return useMemoOne(function () {
    return callback;
  }, inputs);
}
var useMemo = useMemoOne;
var useCallback = useCallbackOne;

exports.useCallback = useCallback;
exports.useCallbackOne = useCallbackOne;
exports.useMemo = useMemo;
exports.useMemoOne = useMemoOne;

      };
    };
  }
  }
}, {package:"react-beautiful-dnd>use-memo-one",file:"node_modules\\use-memo-one\\dist\\use-memo-one.cjs.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\value-equal\\cjs\\value-equal.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cvalue-equal%5Ccjs%5Cvalue-equal.js
      return function (require, module, exports) {
'use strict';

function valueOf(obj) {
  return obj.valueOf ? obj.valueOf() : Object.prototype.valueOf.call(obj);
}

function valueEqual(a, b) {
  // Test for strict equality first.
  if (a === b) return true;

  // Otherwise, if either of them == null they are not equal.
  if (a == null || b == null) return false;

  if (Array.isArray(a)) {
    return (
      Array.isArray(b) &&
      a.length === b.length &&
      a.every(function(item, index) {
        return valueEqual(item, b[index]);
      })
    );
  }

  if (typeof a === 'object' || typeof b === 'object') {
    var aValue = valueOf(a);
    var bValue = valueOf(b);

    if (aValue !== a || bValue !== b) return valueEqual(aValue, bValue);

    return Object.keys(Object.assign({}, a, b)).every(function(key) {
      return valueEqual(a[key], b[key]);
    });
  }

  return false;
}

module.exports = valueEqual;

      };
    };
  }
  }
}, {package:"react-router-dom>history>value-equal",file:"node_modules\\value-equal\\cjs\\value-equal.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\value-equal\\cjs\\value-equal.min.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cvalue-equal%5Ccjs%5Cvalue-equal.min.js
      return function (require, module, exports) {
"use strict";function valueOf(e){return e.valueOf?e.valueOf():Object.prototype.valueOf.call(e)}function valueEqual(u,r){if(u===r)return!0;if(null==u||null==r)return!1;if(Array.isArray(u))return Array.isArray(r)&&u.length===r.length&&u.every(function(e,u){return valueEqual(e,r[u])});if("object"!=typeof u&&"object"!=typeof r)return!1;var e=valueOf(u),t=valueOf(r);return e!==u||t!==r?valueEqual(e,t):Object.keys(Object.assign({},u,r)).every(function(e){return valueEqual(u[e],r[e])})}module.exports=valueEqual;

      };
    };
  }
  }
}, {package:"react-router-dom>history>value-equal",file:"node_modules\\value-equal\\cjs\\value-equal.min.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\value-equal\\index.js", {"./cjs/value-equal.js":"D:\\code\\v\\metamask-extension\\node_modules\\value-equal\\cjs\\value-equal.js","./cjs/value-equal.min.js":"D:\\code\\v\\metamask-extension\\node_modules\\value-equal\\cjs\\value-equal.min.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cvalue-equal%5Cindex.js
      return function (require, module, exports) {
'use strict';

if ("development" === 'production') {
  module.exports = require('./cjs/value-equal.min.js');
} else {
  module.exports = require('./cjs/value-equal.js');
}

      };
    };
  }
  }
}, {package:"react-router-dom>history>value-equal",file:"node_modules\\value-equal\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\vfile-message\\index.js", {"unist-util-stringify-position":"D:\\code\\v\\metamask-extension\\node_modules\\unist-util-stringify-position\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cvfile-message%5Cindex.js
      return function (require, module, exports) {
'use strict'

var stringify = require('unist-util-stringify-position')

module.exports = VMessage

// Inherit from `Error#`.
function VMessagePrototype() {}
VMessagePrototype.prototype = Error.prototype
VMessage.prototype = new VMessagePrototype()

// Message properties.
var proto = VMessage.prototype

proto.file = ''
proto.name = ''
proto.reason = ''
proto.message = ''
proto.stack = ''
proto.fatal = null
proto.column = null
proto.line = null

// Construct a new VMessage.
//
// Note: We cannot invoke `Error` on the created context, as that adds readonly
// `line` and `column` attributes on Safari 9, thus throwing and failing the
// data.
function VMessage(reason, position, origin) {
  var parts
  var range
  var location

  if (typeof position === 'string') {
    origin = position
    position = null
  }

  parts = parseOrigin(origin)
  range = stringify(position) || '1:1'

  location = {
    start: {line: null, column: null},
    end: {line: null, column: null}
  }

  // Node.
  if (position && position.position) {
    position = position.position
  }

  if (position) {
    // Position.
    if (position.start) {
      location = position
      position = position.start
    } else {
      // Point.
      location.start = position
    }
  }

  if (reason.stack) {
    this.stack = reason.stack
    reason = reason.message
  }

  this.message = reason
  this.name = range
  this.reason = reason
  this.line = position ? position.line : null
  this.column = position ? position.column : null
  this.location = location
  this.source = parts[0]
  this.ruleId = parts[1]
}

function parseOrigin(origin) {
  var result = [null, null]
  var index

  if (typeof origin === 'string') {
    index = origin.indexOf(':')

    if (index === -1) {
      result[1] = origin
    } else {
      result[0] = origin.slice(0, index)
      result[1] = origin.slice(index + 1)
    }
  }

  return result
}

      };
    };
  }
  }
}, {package:"react-markdown>vfile>vfile-message",file:"node_modules\\vfile-message\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\vfile\\core.js", {"_process":"D:\\code\\v\\metamask-extension\\node_modules\\process\\browser.js","is-buffer":"D:\\code\\v\\metamask-extension\\node_modules\\vfile\\node_modules\\is-buffer\\index.js","path":"D:\\code\\v\\metamask-extension\\node_modules\\path-browserify\\index.js","replace-ext":"D:\\code\\v\\metamask-extension\\node_modules\\vfile\\node_modules\\replace-ext\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cvfile%5Ccore.js
      return function (require, module, exports) {
(function (process){(function (){
'use strict'

var path = require('path')
var replace = require('replace-ext')
var buffer = require('is-buffer')

module.exports = VFile

var own = {}.hasOwnProperty
var proto = VFile.prototype

// Order of setting (least specific to most), we need this because otherwise
// `{stem: 'a', path: '~/b.js'}` would throw, as a path is needed before a
// stem can be set.
var order = ['history', 'path', 'basename', 'stem', 'extname', 'dirname']

proto.toString = toString

// Access full path (`~/index.min.js`).
Object.defineProperty(proto, 'path', {get: getPath, set: setPath})

// Access parent path (`~`).
Object.defineProperty(proto, 'dirname', {get: getDirname, set: setDirname})

// Access basename (`index.min.js`).
Object.defineProperty(proto, 'basename', {get: getBasename, set: setBasename})

// Access extname (`.js`).
Object.defineProperty(proto, 'extname', {get: getExtname, set: setExtname})

// Access stem (`index.min`).
Object.defineProperty(proto, 'stem', {get: getStem, set: setStem})

// Construct a new file.
function VFile(options) {
  var prop
  var index
  var length

  if (!options) {
    options = {}
  } else if (typeof options === 'string' || buffer(options)) {
    options = {contents: options}
  } else if ('message' in options && 'messages' in options) {
    return options
  }

  if (!(this instanceof VFile)) {
    return new VFile(options)
  }

  this.data = {}
  this.messages = []
  this.history = []
  this.cwd = process.cwd()

  // Set path related properties in the correct order.
  index = -1
  length = order.length

  while (++index < length) {
    prop = order[index]

    if (own.call(options, prop)) {
      this[prop] = options[prop]
    }
  }

  // Set non-path related properties.
  for (prop in options) {
    if (order.indexOf(prop) === -1) {
      this[prop] = options[prop]
    }
  }
}

function getPath() {
  return this.history[this.history.length - 1]
}

function setPath(path) {
  assertNonEmpty(path, 'path')

  if (path !== this.path) {
    this.history.push(path)
  }
}

function getDirname() {
  return typeof this.path === 'string' ? path.dirname(this.path) : undefined
}

function setDirname(dirname) {
  assertPath(this.path, 'dirname')
  this.path = path.join(dirname || '', this.basename)
}

function getBasename() {
  return typeof this.path === 'string' ? path.basename(this.path) : undefined
}

function setBasename(basename) {
  assertNonEmpty(basename, 'basename')
  assertPart(basename, 'basename')
  this.path = path.join(this.dirname || '', basename)
}

function getExtname() {
  return typeof this.path === 'string' ? path.extname(this.path) : undefined
}

function setExtname(extname) {
  var ext = extname || ''

  assertPart(ext, 'extname')
  assertPath(this.path, 'extname')

  if (ext) {
    if (ext.charAt(0) !== '.') {
      throw new Error('`extname` must start with `.`')
    }

    if (ext.indexOf('.', 1) !== -1) {
      throw new Error('`extname` cannot contain multiple dots')
    }
  }

  this.path = replace(this.path, ext)
}

function getStem() {
  return typeof this.path === 'string'
    ? path.basename(this.path, this.extname)
    : undefined
}

function setStem(stem) {
  assertNonEmpty(stem, 'stem')
  assertPart(stem, 'stem')
  this.path = path.join(this.dirname || '', stem + (this.extname || ''))
}

// Get the value of the file.
function toString(encoding) {
  var value = this.contents || ''
  return buffer(value) ? value.toString(encoding) : String(value)
}

// Assert that `part` is not a path (i.e., does not contain `path.sep`).
function assertPart(part, name) {
  if (part.indexOf(path.sep) !== -1) {
    throw new Error(
      '`' + name + '` cannot be a path: did not expect `' + path.sep + '`'
    )
  }
}

// Assert that `part` is not empty.
function assertNonEmpty(part, name) {
  if (!part) {
    throw new Error('`' + name + '` cannot be empty')
  }
}

// Assert `path` exists.
function assertPath(path, name) {
  if (!path) {
    throw new Error('Setting `' + name + '` requires `path` to be set too')
  }
}

}).call(this)}).call(this,require('_process'))

      };
    };
  }
  }
}, {package:"react-markdown>vfile",file:"node_modules\\vfile\\core.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\vfile\\index.js", {"./core.js":"D:\\code\\v\\metamask-extension\\node_modules\\vfile\\core.js","vfile-message":"D:\\code\\v\\metamask-extension\\node_modules\\vfile-message\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cvfile%5Cindex.js
      return function (require, module, exports) {
'use strict'

var VMessage = require('vfile-message')
var VFile = require('./core.js')

module.exports = VFile

var proto = VFile.prototype

proto.message = message
proto.info = info
proto.fail = fail

// Create a message with `reason` at `position`.
// When an error is passed in as `reason`, copies the stack.
function message(reason, position, origin) {
  var filePath = this.path
  var message = new VMessage(reason, position, origin)

  if (filePath) {
    message.name = filePath + ':' + message.name
    message.file = filePath
  }

  message.fatal = false

  this.messages.push(message)

  return message
}

// Fail: creates a vmessage, associates it with the file, and throws it.
function fail() {
  var message = this.message.apply(this, arguments)

  message.fatal = true

  throw message
}

// Info: creates a vmessage, associates it with the file, and marks the fatality
// as null.
function info() {
  var message = this.message.apply(this, arguments)

  message.fatal = null

  return message
}

      };
    };
  }
  }
}, {package:"react-markdown>vfile",file:"node_modules\\vfile\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\vfile\\node_modules\\is-buffer\\index.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cvfile%5Cnode_modules%5Cis-buffer%5Cindex.js
      return function (require, module, exports) {
/*!
 * Determine if an object is a Buffer
 *
 * @author   Feross Aboukhadijeh <https://feross.org>
 * @license  MIT
 */

module.exports = function isBuffer (obj) {
  return obj != null && obj.constructor != null &&
    typeof obj.constructor.isBuffer === 'function' && obj.constructor.isBuffer(obj)
}

      };
    };
  }
  }
}, {package:"react-markdown>vfile>is-buffer",file:"node_modules\\vfile\\node_modules\\is-buffer\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\vfile\\node_modules\\replace-ext\\index.js", {"path":"D:\\code\\v\\metamask-extension\\node_modules\\path-browserify\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cvfile%5Cnode_modules%5Creplace-ext%5Cindex.js
      return function (require, module, exports) {
'use strict';

var path = require('path');

function replaceExt(npath, ext) {
  if (typeof npath !== 'string') {
    return npath;
  }

  if (npath.length === 0) {
    return npath;
  }

  var nFileName = path.basename(npath, path.extname(npath)) + ext;
  return path.join(path.dirname(npath), nFileName);
}

module.exports = replaceExt;

      };
    };
  }
  }
}, {package:"react-markdown>vfile>replace-ext",file:"node_modules\\vfile\\node_modules\\replace-ext\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\which-boxed-primitive\\index.js", {"is-bigint":"D:\\code\\v\\metamask-extension\\node_modules\\is-bigint\\index.js","is-boolean-object":"D:\\code\\v\\metamask-extension\\node_modules\\is-boolean-object\\index.js","is-number-object":"D:\\code\\v\\metamask-extension\\node_modules\\is-number-object\\index.js","is-string":"D:\\code\\v\\metamask-extension\\node_modules\\is-string\\index.js","is-symbol":"D:\\code\\v\\metamask-extension\\node_modules\\is-symbol\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cwhich-boxed-primitive%5Cindex.js
      return function (require, module, exports) {
'use strict';

var isString = require('is-string');
var isNumber = require('is-number-object');
var isBoolean = require('is-boolean-object');
var isSymbol = require('is-symbol');
var isBigInt = require('is-bigint');

// eslint-disable-next-line consistent-return
module.exports = function whichBoxedPrimitive(value) {
	// eslint-disable-next-line eqeqeq
	if (value == null || (typeof value !== 'object' && typeof value !== 'function')) {
		return null;
	}
	if (isString(value)) {
		return 'String';
	}
	if (isNumber(value)) {
		return 'Number';
	}
	if (isBoolean(value)) {
		return 'Boolean';
	}
	if (isSymbol(value)) {
		return 'Symbol';
	}
	if (isBigInt(value)) {
		return 'BigInt';
	}
};

      };
    };
  }
  }
}, {package:"@metamask/eth-token-tracker>deep-equal>which-boxed-primitive",file:"node_modules\\which-boxed-primitive\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\which-collection\\index.js", {"is-map":"D:\\code\\v\\metamask-extension\\node_modules\\is-map\\index.js","is-set":"D:\\code\\v\\metamask-extension\\node_modules\\is-set\\index.js","is-weakmap":"D:\\code\\v\\metamask-extension\\node_modules\\is-weakmap\\index.js","is-weakset":"D:\\code\\v\\metamask-extension\\node_modules\\is-weakset\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cwhich-collection%5Cindex.js
      return function (require, module, exports) {
'use strict';

var isMap = require('is-map');
var isSet = require('is-set');
var isWeakMap = require('is-weakmap');
var isWeakSet = require('is-weakset');

module.exports = function whichCollection(value) {
	if (value && typeof value === 'object') {
		if (isMap(value)) {
			return 'Map';
		}
		if (isSet(value)) {
			return 'Set';
		}
		if (isWeakMap(value)) {
			return 'WeakMap';
		}
		if (isWeakSet(value)) {
			return 'WeakSet';
		}
	}
	return false;
};

      };
    };
  }
  }
}, {package:"@metamask/eth-token-tracker>deep-equal>which-collection",file:"node_modules\\which-collection\\index.js",}],
["D:\\code\\v\\metamask-extension\\shared\\constants\\copy.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cshared%5Cconstants%5Ccopy.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.COPY_OPTIONS = void 0;
const COPY_OPTIONS = exports.COPY_OPTIONS = {
  format: 'text/plain'
};

      };
    };
  }
  }
}, {package:"$root$",file:"shared\\constants\\copy.ts",}],
["D:\\code\\v\\metamask-extension\\shared\\constants\\first-party-contracts.ts", {"./network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cshared%5Cconstants%5Cfirst-party-contracts.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FIRST_PARTY_CONTRACT_NAMES = exports.EXPERIENCES_TYPE = void 0;
var _network = require("./network");
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
let EXPERIENCES_TYPE = exports.EXPERIENCES_TYPE = /*#__PURE__*/function (EXPERIENCES_TYPE) {
  EXPERIENCES_TYPE["METAMASK_VALIDATOR_STAKING"] = "MetaMask Validator Staking";
  EXPERIENCES_TYPE["METAMASK_POOLED_STAKING"] = "MetaMask Pooled Staking";
  EXPERIENCES_TYPE["METAMASK_THIRD_PARTY_STAKING"] = "MetaMask Third Party Staking";
  EXPERIENCES_TYPE["METAMASK_POOLED_STAKING_V1"] = "MetaMask Pool Staking (v1)";
  EXPERIENCES_TYPE["METAMASK_BRIDGE"] = "MetaMask Bridge";
  EXPERIENCES_TYPE["METAMASK_SWAPS"] = "MetaMask Swaps";
  return EXPERIENCES_TYPE;
}({});
/**
 * A map of first-party contract names to their addresses on various chains.
 */
const FIRST_PARTY_CONTRACT_NAMES = exports.FIRST_PARTY_CONTRACT_NAMES = {
  [EXPERIENCES_TYPE.METAMASK_VALIDATOR_STAKING]: {
    [_network.CHAIN_IDS.MAINNET]: '0xDc71aFFC862fceB6aD32BE58E098423A7727bEbd'
  },
  [EXPERIENCES_TYPE.METAMASK_POOLED_STAKING]: {
    [_network.CHAIN_IDS.MAINNET]: '0x4FEF9D741011476750A243aC70b9789a63dd47Df'
  },
  [EXPERIENCES_TYPE.METAMASK_THIRD_PARTY_STAKING]: {
    [_network.CHAIN_IDS.MAINNET]: '0x1f6692E78dDE07FF8da75769B6d7c716215bC7D0'
  },
  [EXPERIENCES_TYPE.METAMASK_POOLED_STAKING_V1]: {
    [_network.CHAIN_IDS.MAINNET]: '0xc7bE520a13dC023A1b34C03F4Abdab8A43653F7B'
  },
  [EXPERIENCES_TYPE.METAMASK_BRIDGE]: {
    [_network.CHAIN_IDS.MAINNET]: '0x0439e60F02a8900a951603950d8D4527f400C3f1',
    [_network.CHAIN_IDS.OPTIMISM]: '0xB90357f2b86dbfD59c3502215d4060f71DF8ca0e',
    [_network.CHAIN_IDS.BSC]: '0xaEc23140408534b378bf5832defc426dF8604B59',
    [_network.CHAIN_IDS.POLYGON]: '0x3A0b42cE6166abB05d30DdF12E726c95a83D7a16',
    [_network.CHAIN_IDS.ZKSYNC_ERA]: '0x357B5935482AD8a4A2e181e0132aBd1882E16520',
    [_network.CHAIN_IDS.BASE]: '0xa20ECbC821fB54064aa7B5C6aC81173b8b34Df71',
    [_network.CHAIN_IDS.ARBITRUM]: '0x23981fC34e69eeDFE2BD9a0a9fCb0719Fe09DbFC',
    [_network.CHAIN_IDS.AVALANCHE]: '0x29106d08382d3c73bF477A94333C61Db1142E1B6',
    [_network.CHAIN_IDS.LINEA_MAINNET]: '0xE3d0d2607182Af5B24f5C3C2E4990A053aDd64e3'
  },
  [EXPERIENCES_TYPE.METAMASK_SWAPS]: {
    [_network.CHAIN_IDS.MAINNET]: '0x881D40237659C251811CEC9c364ef91dC08D300C',
    [_network.CHAIN_IDS.BSC]: '0x1a1ec25DC08e98e5E93F1104B5e5cdD298707d31',
    [_network.CHAIN_IDS.POLYGON]: '0x1a1ec25DC08e98e5E93F1104B5e5cdD298707d31',
    [_network.CHAIN_IDS.AVALANCHE]: '0x1a1ec25DC08e98e5E93F1104B5e5cdD298707d31',
    [_network.CHAIN_IDS.ARBITRUM]: '0x9dDA6Ef3D919c9bC8885D5560999A3640431e8e6',
    [_network.CHAIN_IDS.OPTIMISM]: '0x9dDA6Ef3D919c9bC8885D5560999A3640431e8e6',
    [_network.CHAIN_IDS.ZKSYNC_ERA]: '0xf504c1fe13d14DF615E66dcd0ABF39e60c697f34',
    [_network.CHAIN_IDS.LINEA_MAINNET]: '0x9dDA6Ef3D919c9bC8885D5560999A3640431e8e6'
  }
};

      };
    };
  }
  }
}, {package:"$root$",file:"shared\\constants\\first-party-contracts.ts",}],
["D:\\code\\v\\metamask-extension\\shared\\constants\\verification.ts", {"./first-party-contracts":"D:\\code\\v\\metamask-extension\\shared\\constants\\first-party-contracts.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cshared%5Cconstants%5Cverification.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExperience = exports.TX_SIG_LEN = exports.TRUSTED_SIGNERS = exports.EXPERIENCES_TO_VERIFY = void 0;
var _firstPartyContracts = require("./first-party-contracts");
const TX_SIG_LEN = exports.TX_SIG_LEN = 130;
const EXPERIENCES_TO_VERIFY = exports.EXPERIENCES_TO_VERIFY = [_firstPartyContracts.EXPERIENCES_TYPE.METAMASK_BRIDGE];
const TRUSTED_SIGNERS = exports.TRUSTED_SIGNERS = {
  [_firstPartyContracts.EXPERIENCES_TYPE.METAMASK_BRIDGE]: '0x533FbF047Ed13C20e263e2576e41c747206d1348'
};

// look up the corresponding experience provided an address on a chain id
const getExperience = (address, chainId) => {
  var _find;
  return (_find = Object.entries(_firstPartyContracts.FIRST_PARTY_CONTRACT_NAMES).find(([, chainMap]) => {
    var _chainMap$chainId;
    return ((_chainMap$chainId = chainMap[chainId]) === null || _chainMap$chainId === void 0 ? void 0 : _chainMap$chainId.toLowerCase()) === address.toLowerCase();
  })) === null || _find === void 0 ? void 0 : _find[0];
};
exports.getExperience = getExperience;

      };
    };
  }
  }
}, {package:"$root$",file:"shared\\constants\\verification.ts",}],
["D:\\code\\v\\metamask-extension\\shared\\lib\\asset-utils.ts", {"../modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../modules/fetch-with-timeout":"D:\\code\\v\\metamask-extension\\shared\\modules\\fetch-with-timeout.ts","./transactions-controller-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\transactions-controller-utils.js","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","@metamask/multichain-network-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-network-controller\\dist\\index.cjs","@metamask/multichain-transactions-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-transactions-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cshared%5Clib%5Casset-utils.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toAssetId = exports.isEvmChainId = exports.getAssetImageUrl = exports.fetchAssetMetadataForAssetIds = exports.fetchAssetMetadata = void 0;
var _utils = require("@metamask/utils");
var _multichainNetworkController = require("@metamask/multichain-network-controller");
var _multichainTransactionsController = require("@metamask/multichain-transactions-controller");
var _bridgeController = require("@metamask/bridge-controller");
var _fetchWithTimeout = _interopRequireDefault(require("../modules/fetch-with-timeout"));
var _conversion = require("../modules/conversion.utils");
var _transactionsControllerUtils = require("./transactions-controller-utils");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const TOKEN_API_V3_BASE_URL = 'https://tokens.api.cx.metamask.io/v3';
const STATIC_METAMASK_BASE_URL = 'https://static.cx.metamask.io';
const toAssetId = (address, chainId) => {
  if ((0, _utils.isCaipAssetType)(address)) {
    return address;
  }
  if ((0, _bridgeController.isNativeAddress)(address)) {
    var _getNativeAssetForCha;
    return (_getNativeAssetForCha = (0, _bridgeController.getNativeAssetForChainId)(chainId)) === null || _getNativeAssetForCha === void 0 ? void 0 : _getNativeAssetForCha.assetId;
  }
  if (chainId === _multichainTransactionsController.MultichainNetwork.Solana) {
    return _utils.CaipAssetTypeStruct.create(`${chainId}/token:${address}`);
  }
  // EVM assets
  if ((0, _utils.isStrictHexString)(address)) {
    return _utils.CaipAssetTypeStruct.create(`${chainId}/erc20:${address.toLowerCase()}`);
  }
  return undefined;
};

/**
 * Returns the image url for a caip-formatted asset
 *
 * @param assetId - The hex address or caip-formatted asset id
 * @param chainId - The chainId in caip or hex format
 * @returns The image url for the asset
 */
exports.toAssetId = toAssetId;
const getAssetImageUrl = (assetId, chainId) => {
  const chainIdInCaip = (0, _utils.isCaipChainId)(chainId) ? chainId : (0, _multichainNetworkController.toEvmCaipChainId)(chainId);
  const assetIdInCaip = toAssetId(assetId, chainIdInCaip);
  if (!assetIdInCaip) {
    return undefined;
  }
  return `${STATIC_METAMASK_BASE_URL}/api/v2/tokenIcons/assets/${assetIdInCaip.replaceAll(':', '/')}.png`;
};
exports.getAssetImageUrl = getAssetImageUrl;
/**
 * Fetches the metadata for a token
 *
 * @param address - The address of the token
 * @param chainId - The chainId of the token
 * @param abortSignal - The abort signal for the fetch request
 * @returns The metadata for the token
 */
const fetchAssetMetadata = async (address, chainId, abortSignal) => {
  try {
    const chainIdInCaip = (0, _utils.isCaipChainId)(chainId) ? chainId : (0, _multichainNetworkController.toEvmCaipChainId)(chainId);
    const assetId = toAssetId(address, chainIdInCaip);
    if (!assetId) {
      return undefined;
    }
    const fetchWithTimeout = (0, _fetchWithTimeout.default)(_transactionsControllerUtils.TEN_SECONDS_IN_MILLISECONDS);
    const [assetMetadata] = await (await fetchWithTimeout(`${TOKEN_API_V3_BASE_URL}/assets?assetIds=${assetId}`, {
      method: 'GET',
      headers: {
        'X-Client-Id': 'extension'
      },
      signal: abortSignal
    })).json();
    const commonFields = {
      symbol: assetMetadata.symbol,
      decimals: assetMetadata.decimals,
      image: getAssetImageUrl(assetId, chainIdInCaip),
      assetId
    };
    if (chainId === _multichainTransactionsController.MultichainNetwork.Solana && assetId) {
      const {
        assetReference
      } = (0, _utils.parseCaipAssetType)(assetId);
      return {
        ...commonFields,
        address: assetReference,
        assetId,
        chainId
      };
    }
    const {
      reference
    } = (0, _utils.parseCaipChainId)(chainIdInCaip);
    return {
      ...commonFields,
      address: address.toLowerCase(),
      chainId: (0, _conversion.decimalToPrefixedHex)(reference)
    };
  } catch (error) {
    return undefined;
  }
};

/**
 * Fetches the metadata for a list of token assetIds
 *
 * @param assetIds - The assetIds of the tokens
 * @param abortSignal - The abort signal for the fetch request
 * @returns The metadata for the tokens by assetId
 */
exports.fetchAssetMetadata = fetchAssetMetadata;
const fetchAssetMetadataForAssetIds = async (assetIds, abortSignal) => {
  try {
    const fetchWithTimeout = (0, _fetchWithTimeout.default)(_transactionsControllerUtils.TEN_SECONDS_IN_MILLISECONDS);
    const assetIdsString = assetIds.map(assetId => {
      if (!assetId) {
        return null;
      }
      const {
        assetReference
      } = (0, _utils.parseCaipAssetType)(assetId);
      if ((0, _utils.isStrictHexString)(assetReference)) {
        return assetId.toLowerCase();
      }
      return assetId;
    }).filter(Boolean).join(',');
    if (!assetIdsString) {
      return {};
    }
    const assetMetadata = await (await fetchWithTimeout(`${TOKEN_API_V3_BASE_URL}/assets?assetIds=${assetIdsString}`, {
      method: 'GET',
      headers: {
        'X-Client-Id': 'extension'
      },
      signal: abortSignal
    })).json();
    return assetMetadata.reduce((acc, asset) => {
      acc[asset.assetId] = asset;
      return acc;
    }, {});
  } catch (error) {
    return null;
  }
};

/**
 * Checks if the given chain ID is an EVM chain ID
 *
 * @param chainId - The chain ID to check. It can be in caip or hex format.
 * @returns `true` if the chain ID is an EVM chain ID, `false` otherwise.
 */
exports.fetchAssetMetadataForAssetIds = fetchAssetMetadataForAssetIds;
const isEvmChainId = chainId => {
  const chainIdInCaip = (0, _utils.isCaipChainId)(chainId) ? chainId : (0, _multichainNetworkController.toEvmCaipChainId)(chainId);

  // TODO Replace with isEvmCaipChainId from @metamask/multichain-network-controller when it is exported
  const {
    namespace
  } = (0, _utils.parseCaipChainId)(chainIdInCaip);
  return namespace === _utils.KnownCaipNamespace.Eip155;
};
exports.isEvmChainId = isEvmChainId;

      };
    };
  }
  }
}, {package:"$root$",file:"shared\\lib\\asset-utils.ts",}],
["D:\\code\\v\\metamask-extension\\shared\\lib\\bridge-status\\utils.ts", {"@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cshared%5Clib%5Cbridge-status%5Cutils.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isBridgeComplete = isBridgeComplete;
exports.isBridgeFailed = isBridgeFailed;
var _bridgeController = require("@metamask/bridge-controller");
var _keyringApi = require("@metamask/keyring-api");
function isBridgeComplete({
  status,
  quote
}) {
  return Boolean((0, _bridgeController.isCrossChain)(quote.srcChainId, quote.destChainId) && status.srcChain.txHash && status.status === _bridgeController.StatusTypes.COMPLETE);
}
function isBridgeFailed(transaction, {
  quote,
  status
}) {
  const bridgeFailed = Boolean((0, _bridgeController.isCrossChain)(quote.srcChainId, quote.destChainId) && status.status === _bridgeController.StatusTypes.FAILED);
  return bridgeFailed || transaction.status === _keyringApi.TransactionStatus.Failed;
}

      };
    };
  }
  }
}, {package:"$root$",file:"shared\\lib\\bridge-status\\utils.ts",}],
["D:\\code\\v\\metamask-extension\\shared\\lib\\caip25-caveat-merger.ts", {"@metamask/chain-agnostic-permission":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\chain-agnostic-permission\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cshared%5Clib%5Ccaip25-caveat-merger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mergeCaip25CaveatValues = mergeCaip25CaveatValues;
var _chainAgnosticPermission = require("@metamask/chain-agnostic-permission");
/**
 * TODO: Isolate the merger function from @metamask/chain-agnostic-permissions and reuse it here
 * See https://github.com/MetaMask/MetaMask-planning/issues/5113
 *
 * Merges two Caip25CaveatValue objects
 *
 * @param first - The first Caip25CaveatValue to merge
 * @param second - The second Caip25CaveatValue to merge
 * @returns A new Caip25CaveatValue with merged data
 */
function mergeCaip25CaveatValues(first, second) {
  const firstAccounts = (0, _chainAgnosticPermission.getCaipAccountIdsFromCaip25CaveatValue)(first);
  const secondAccounts = (0, _chainAgnosticPermission.getCaipAccountIdsFromCaip25CaveatValue)(second);
  const mergedAccounts = Array.from(new Set([...firstAccounts, ...secondAccounts]));
  const firstChainIds = (0, _chainAgnosticPermission.getAllScopesFromCaip25CaveatValue)(first);
  const secondChainIds = (0, _chainAgnosticPermission.getAllScopesFromCaip25CaveatValue)(second);
  const mergedChainIds = Array.from(new Set([...firstChainIds, ...secondChainIds]));
  let mergedCaveatValue = {
    ...first
  };
  mergedCaveatValue.sessionProperties = {
    ...first.sessionProperties,
    ...second.sessionProperties
  };
  mergedCaveatValue.isMultichainOrigin = first.isMultichainOrigin || second.isMultichainOrigin;
  mergedCaveatValue = (0, _chainAgnosticPermission.setChainIdsInCaip25CaveatValue)(mergedCaveatValue, mergedChainIds);
  mergedCaveatValue = (0, _chainAgnosticPermission.setNonSCACaipAccountIdsInCaip25CaveatValue)(mergedCaveatValue, mergedAccounts);
  return mergedCaveatValue;
}

      };
    };
  }
  }
}, {package:"$root$",file:"shared\\lib\\caip25-caveat-merger.ts",}],
["D:\\code\\v\\metamask-extension\\shared\\lib\\error-utils.js", {"../modules/i18n":"D:\\code\\v\\metamask-extension\\shared\\modules\\i18n.ts","./get-first-preferred-lang-code":"D:\\code\\v\\metamask-extension\\shared\\lib\\get-first-preferred-lang-code.js","./switch-direction":"D:\\code\\v\\metamask-extension\\shared\\lib\\switch-direction.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cshared%5Clib%5Cerror-utils.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getErrorHtml = getErrorHtml;
exports.getErrorHtmlBase = getErrorHtmlBase;
exports.getLocaleContext = void 0;
exports.maybeGetLocaleContext = maybeGetLocaleContext;
exports.setupLocale = void 0;
var _lodash = require("lodash");
var _i18n = require("../modules/i18n");
var _getFirstPreferredLangCode = _interopRequireDefault(require("./get-first-preferred-lang-code"));
var _switchDirection = require("./switch-direction");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const defaultLocale = 'en';
const _setupLocale = async currentLocale => {
  const enRelativeTime = (0, _i18n.loadRelativeTimeFormatLocaleData)(defaultLocale);
  const enLocale = (0, _i18n.fetchLocale)(defaultLocale);
  const promises = [enRelativeTime, enLocale];
  if (currentLocale === defaultLocale) {
    // enLocaleMessages and currentLocaleMessages are the same; reuse enLocale
    promises.push(enLocale); // currentLocaleMessages
  } else if (currentLocale) {
    // currentLocale does not match enLocaleMessages
    promises.push((0, _i18n.fetchLocale)(currentLocale)); // currentLocaleMessages
    promises.push((0, _i18n.loadRelativeTimeFormatLocaleData)(currentLocale));
  } else {
    // currentLocale is not set
    promises.push(Promise.resolve({})); // currentLocaleMessages
  }
  const [, enLocaleMessages, currentLocaleMessages] = await Promise.all(promises);
  return {
    currentLocaleMessages,
    enLocaleMessages
  };
};
const setupLocale = exports.setupLocale = (0, _lodash.memoize)(_setupLocale);
const getLocaleContext = (currentLocaleMessages, enLocaleMessages) => {
  return key => {
    var _currentLocaleMessage;
    let message = (_currentLocaleMessage = currentLocaleMessages[key]) === null || _currentLocaleMessage === void 0 ? void 0 : _currentLocaleMessage.message;
    if (!message && enLocaleMessages[key]) {
      message = enLocaleMessages[key].message;
    }
    return message;
  };
};
exports.getLocaleContext = getLocaleContext;
function getErrorHtmlBase(errorBody) {
  return `
    <div class="critical-error__container">
      <div class="critical-error">
        <div class="critical-error__icon">
          <svg width="24" height="24" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
            <path d="m443 342l-126-241c-16-32-40-50-65-50-26 0-50 18-66 50l-126 241c-16 30-18 60-5 83 13 23 38 36 71 36l251 0c33 0 58-13 71-36 13-23 11-53-5-83z m-206-145c0-8 6-15 15-15 8 0 14 7 14 15l0 105c0 8-6 15-14 15-9 0-15-7-15-15z m28 182c-1 1-2 2-3 3-1 0-2 1-3 1-1 1-2 1-4 2-1 0-2 0-3 0-2 0-3 0-4 0-2-1-3-1-4-2-1 0-2-1-3-1-1-1-2-2-3-3-4-4-6-9-6-15 0-5 2-11 6-15 1 0 2-1 3-2 1-1 2-2 3-2 1-1 2-1 4-1 2-1 5-1 7 0 2 0 3 0 4 1 1 0 2 1 3 2 1 1 2 2 3 2 4 4 6 10 6 15 0 6-2 11-6 15z"/>
          </svg>
        </div>
        <div>
          ${errorBody}
        </div>
      </div>
    </div>
  `;
}

/**
 * Tries really hard to get the locale context function from the given locale.
 *
 * It falls back to the default browser locale, or 'en' if that fails.
 * If we can't get the locale context from some reason (the `messages.json`
 * file for the locale), we return a function that just returns the value passed
 * to it, which isn't ideal... but at least it is something (the alternative
 * is to hard-code the English locale in this file, which would be very hard
 * to maintain).
 *
 * Does not throw.
 *
 * @param {string} [currentLocale] - The current locale
 * @returns {Promise<{preferredLocale: string, t: (any) => any}>} A promise that resolves to an object containing the preferred locale and a translation function.
 */
async function maybeGetLocaleContext(currentLocale) {
  let preferredLocale;
  try {
    preferredLocale = currentLocale ?? (await (0, _getFirstPreferredLangCode.default)());
    const response = await setupLocale(preferredLocale);
    const {
      currentLocaleMessages,
      enLocaleMessages
    } = response;
    const t = getLocaleContext(currentLocaleMessages, enLocaleMessages);
    return {
      preferredLocale,
      t
    };
  } catch (error) {
    console.error('Error setting up locale:', error);
    return {
      preferredLocale: preferredLocale ?? 'en',
      t: value => value
    };
  }
}

/**
 * Get the HTML for a critical error message.
 *
 * @param {__import__('../../ui/helpers/utils/display-critical-error').CriticalErrorTranslationKey} errorKey - The key for the error message.
 * @param {ErrorLike} error - The error object to log.
 * @param {{preferredLocale: string, t: (string) => string}} localeContext - The MetaMask state containing the current locale and translation function.
 * @param {string} [supportLink] - The support link to include in the footer.
 * @returns {string} The HTML string for the critical error message.
 */
function getErrorHtml(errorKey, error, localeContext, supportLink) {
  (0, _switchDirection.switchDirectionForPreferredLocale)(localeContext.preferredLocale);
  const {
    t
  } = localeContext;
  const legalText = `
    <span>${(0, _lodash.escape)(t('errorLegalTextSummary'))}</span>
    <p>• ${(0, _lodash.escape)(t('errorLegalTextFirstInfo'))}</p>
    <p>• ${(0, _lodash.escape)(t('errorLegalTextSecondInfo'))}</p>
    <span>${(0, _lodash.escape)(t('errorLegalTextNoPersonalInfo'))}</span>
`;
  const footer = supportLink ? `
      <p class="critical-error__footer">
        <span>${(0, _lodash.escape)(t('stillGettingMessage'))}</span>
        <a
          href="${(0, _lodash.escape)(supportLink)}"
          class="critical-error__link"
          target="_blank"
          rel="noopener noreferrer">
            ${(0, _lodash.escape)(t('errorPageContactSupport'))}
        </a>
      </p>
    ` : '';
  let detailsRawHtml = '';
  if (error !== null && error !== void 0 && error.message) {
    detailsRawHtml += `<strong>${(0, _lodash.escape)(t('errorDetails'))}</strong>\n`;
    detailsRawHtml += `<p class="critical-error__details"><code>${(0, _lodash.escape)(error === null || error === void 0 ? void 0 : error.message)}</code></p>`;
  }

  /**
   * The pattern ${errorKey === 'somethingIsWrong' ? t('somethingIsWrong') : ''}
   * is necessary because we we need linter to see the string
   * of the locale keys. If we use the variable directly, the linter will not
   * see the string and will not be able to check if the locale key exists.
   */
  return getErrorHtmlBase(`
      <h1>${(0, _lodash.escape)(t('troubleStartingTitle'))}</h1>
      <p>
        ${errorKey === 'troubleStarting' ? t('troubleStartingMessage') : ''}
        ${errorKey === 'somethingIsWrong' ? t('somethingIsWrong') : ''}
      </p>
      ${detailsRawHtml}
      <label class="critical-error__report">
        <input
        id="critical-error-checkbox"
          type="checkbox"
          checked
          class="critical-error__report-checkbox"
        />
        <span class="critical-error__report-text">
          ${(0, _lodash.escape)(t('reportThisError'))}
        </span>
        <button
          id="critical-error-tip-anchor"
          popovertarget="critical-error-legal-text"
          type="button"
          class="critical-error__info"
        >
          <svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" class="critical-error__info-icon">
            <path d="m11 17h2v-6h-2zm1-8c.2833 0 .5208-.09583.7125-.2875s.2875-.42917.2875-.7125-.0958-.52083-.2875-.7125-.4292-.2875-.7125-.2875-.5208.09583-.7125.2875-.2875.42917-.2875.7125.0958.52083.2875.7125.4292.2875.7125.2875zm0 13c-1.3833 0-2.68333-.2625-3.9-.7875s-2.275-1.2375-3.175-2.1375-1.6125-1.9583-2.1375-3.175-.7875-2.5167-.7875-3.9.2625-2.68333.7875-3.9 1.2375-2.275 2.1375-3.175 1.95833-1.6125 3.175-2.1375 2.5167-.7875 3.9-.7875 2.6833.2625 3.9.7875 2.275 1.2375 3.175 2.1375 1.6125 1.95833 2.1375 3.175.7875 2.5167.7875 3.9-.2625 2.6833-.7875 3.9-1.2375 2.275-2.1375 3.175-1.9583 1.6125-3.175 2.1375-2.5167.7875-3.9.7875zm0-2c2.2333 0 4.125-.775 5.675-2.325s2.325-3.4417 2.325-5.675c0-2.23333-.775-4.125-2.325-5.675s-3.4417-2.325-5.675-2.325c-2.23333 0-4.125.775-5.675 2.325s-2.325 3.44167-2.325 5.675c0 2.2333.775 4.125 2.325 5.675s3.44167 2.325 5.675 2.325z"/>
          </svg>
        </button>
      </label>
      <div
        popover
        anchor="critical-error-tip-anchor"
        id="critical-error-legal-text"
        class="critical-error__legal-text"
      >
        ${legalText}
      </div>
      <button
        id="critical-error-button"
        class="critical-error__button-restore button btn-primary"
        title="Report this error and restart MetaMask">
        ${(0, _lodash.escape)(t('restartMetamask'))}
      </button>
      ${footer}
    `);
}

      };
    };
  }
  }
}, {package:"$root$",file:"shared\\lib\\error-utils.js",}],
["D:\\code\\v\\metamask-extension\\shared\\lib\\keyring.ts", {"../modules/string-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\string-utils.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cshared%5Clib%5Ckeyring.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findKeyringId = findKeyringId;
exports.findKeyringIdByAddress = findKeyringIdByAddress;
var _stringUtils = require("../modules/string-utils");
// TODO: This kind of logic should be inside the `KeyringController` (using `KeyringSelector` query, or make `addNewKeyring` returns it keyring ID alongside

function findKeyringId(keyrings, selector) {
  const matchingKeyring = keyrings.find(keyring => {
    if (selector.address && selector.type) {
      return keyring.accounts.some(account => (0, _stringUtils.isEqualCaseInsensitive)(account, selector.address)) && keyring.type === selector.type;
    }
    if (selector.address) {
      return keyring.accounts.some(account => (0, _stringUtils.isEqualCaseInsensitive)(account, selector.address));
    }
    if (selector.type) {
      return keyring.type === selector.type;
    }
    throw new Error('Must provide either address or type selector');
  });
  if (!matchingKeyring) {
    throw new Error('Could not find keyring with specified criteria');
  }
  return matchingKeyring.metadata.id;
}
function findKeyringIdByAddress(keyrings, address) {
  return findKeyringId(keyrings, {
    address
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"shared\\lib\\keyring.ts",}],
["D:\\code\\v\\metamask-extension\\shared\\lib\\multichain\\networks.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cshared%5Clib%5Cmultichain%5Cnetworks.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatBlockExplorerAddressUrl = formatBlockExplorerAddressUrl;
exports.formatBlockExplorerTransactionUrl = formatBlockExplorerTransactionUrl;
exports.formatBlockExplorerUrl = formatBlockExplorerUrl;
/**
 * Base URL of a block explorer.
 */

/**
 * Format URL of a block explorer for addresses.
 *
 * The format URLs can be used to "expand" some strings within the format string. (Similar
 * to "string interpolation"). The "tags" are being identified with curly-braces.
 */

/**
 * A group of URL and format URL for block explorers.
 */

/**
 * Format a URL by replacing a "tag" with a corresponding value.
 *
 * @param url - Format URL.
 * @param tag - Format URL tag.
 * @param value - The value to expand.
 * @returns A formatted URL.
 */
function formatBlockExplorerUrl(url, tag, value) {
  return url.replaceAll(tag, value);
}

/**
 * Format a URL for addresses.
 *
 * @param urls - The group of format URLs for a given block explorer.
 * @param address - The address to create the URL for.
 * @returns The formatted URL for the given address.
 */
function formatBlockExplorerAddressUrl(urls, address) {
  return formatBlockExplorerUrl(urls.address, '{address}', address);
}

/**
 * Format a URL for transactions.
 *
 * @param urls - The group of format URLs for a given block explorer.
 * @param txId - The transaction ID to create the URL for.
 * @returns The formatted URL for the given transaction.
 */
function formatBlockExplorerTransactionUrl(urls, txId) {
  return urls.transaction.replace('{txId}', txId);
}

      };
    };
  }
  }
}, {package:"$root$",file:"shared\\lib\\multichain\\networks.ts",}],
["D:\\code\\v\\metamask-extension\\shared\\lib\\multichain\\scope-utils.ts", {"@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cshared%5Clib%5Cmultichain%5Cscope-utils.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scopeMatches = exports.hasNamespaceSupport = exports.hasChainIdSupport = exports.getCaip25AccountIdsFromAccountGroupAndScope = exports.anyScopesMatch = void 0;
var _utils = require("@metamask/utils");
var _keyringApi = require("@metamask/keyring-api");
// eslint-disable-next-line import/no-restricted-paths

/**
 * Helper function to check if any of the account scopes match the target scope.
 * Handles the special case of eip155:0 (wildcard) which matches any EVM scope.
 *
 * This function provides a consistent approach to scope matching across the codebase,
 * ensuring that eip155:0 wildcard logic is handled uniformly in both selectors and
 * permission/handler level code.
 *
 * @param accountScopes - Array of scope strings from the account
 * @param targetScope - The target scope to match against
 * @returns True if any scope matches, false otherwise
 */
const anyScopesMatch = (accountScopes, targetScope) => {
  if (!Array.isArray(accountScopes) || accountScopes.length === 0) {
    return false;
  }

  // Direct match
  if (accountScopes.includes(targetScope)) {
    return true;
  }
  try {
    const parsed = (0, _utils.parseCaipChainId)(targetScope);
    const {
      namespace,
      reference
    } = parsed;
    if (namespace === _utils.KnownCaipNamespace.Eip155) {
      // If requesting eip155:0 (wildcard), include any account that has any EVM scope
      if (reference === '0') {
        return accountScopes.some(scope => scope.startsWith(`${_utils.KnownCaipNamespace.Eip155}:`));
      }

      // For a specific EVM chain, include accounts that have the wildcard scope
      return accountScopes.includes(_keyringApi.EthScope.Eoa);
    }
  } catch {
    // If parsing fails, fall back to exact match only
  }
  return false;
};

/**
 * Helper function to check if a single account scope matches the target scope.
 * This is a convenience wrapper around anyScopesMatch for single scope comparisons.
 *
 * @param accountScope - Single scope string from the account
 * @param targetScope - The target scope to match against
 * @returns True if the scope matches, false otherwise
 */
exports.anyScopesMatch = anyScopesMatch;
const scopeMatches = (accountScope, targetScope) => {
  return anyScopesMatch([accountScope], targetScope);
};

/**
 * Checks if an account supports the requested chain IDs
 *
 * @param accountScopes - Array of account scopes to check
 * @param requestedChainIds - Array of requested chain IDs to match against
 * @returns True if any scope matches any requested chain ID
 */
exports.scopeMatches = scopeMatches;
const hasChainIdSupport = (accountScopes, requestedChainIds) => {
  if (!accountScopes || requestedChainIds.length === 0) {
    return false;
  }
  return accountScopes.some(accountScope => requestedChainIds.some(requestedChainId => anyScopesMatch([accountScope], requestedChainId)));
};

/**
 * Checks if an account supports the requested namespaces
 *
 * @param accountScopes - Array of account scopes to check
 * @param requestedNamespaces - Set of requested namespaces to match against
 * @returns True if any scope namespace matches any requested namespace
 */
exports.hasChainIdSupport = hasChainIdSupport;
const hasNamespaceSupport = (accountScopes, requestedNamespaces) => {
  if (!accountScopes || requestedNamespaces.size === 0) {
    return false;
  }
  for (const scope of accountScopes) {
    const [scopeNamespace] = scope.split(':');
    if (scopeNamespace && requestedNamespaces.has(scopeNamespace)) {
      return true;
    }
  }
  return false;
};

/**
 * Generates CAIP-25 account IDs from account groups filtered by supported scopes.
 *
 * This function takes account groups and filters their accounts based on scope compatibility,
 * returning CAIP-25 formatted account identifiers. It handles special EIP-155 wildcard logic
 * where eip155:0 scope matches any EVM chain, and specific EVM chains match the wildcard scope.
 *
 * @param accountGroups - Array of account groups containing internal accounts with scope information
 * @param scopes - Array of CAIP chain IDs to filter accounts by
 * @returns Array of unique CAIP-25 account IDs for accounts that support the requested scopes
 */
exports.hasNamespaceSupport = hasNamespaceSupport;
const getCaip25AccountIdsFromAccountGroupAndScope = (accountGroups, scopes) => {
  // Pre-parse all chain namespaces and cache common strings
  const chainNamespaces = new Map();
  const eip155Scope = `${_utils.KnownCaipNamespace.Eip155}:0`;
  scopes.forEach(chainId => {
    try {
      const {
        namespace
      } = (0, _utils.parseCaipChainId)(chainId);
      chainNamespaces.set(chainId, namespace);
    } catch (err) {
      // Skip invalid chain IDs
    }
  });
  const updatedSelectedCaipAccountAddresses = new Set();
  accountGroups.forEach(accountGroup => {
    accountGroup.accounts.forEach(account => {
      const accountScopesSet = new Set(account.scopes);
      scopes.forEach(chainId => {
        const namespace = chainNamespaces.get(chainId);
        if (!namespace) {
          return;
        }
        let shouldAdd = false;
        if (namespace === _utils.KnownCaipNamespace.Eip155) {
          // Use the same logic as anyScopesMatch for EIP-155 scopes
          // Check for direct match first
          shouldAdd = accountScopesSet.has(chainId);

          // If no direct match, check for wildcard scope
          if (!shouldAdd) {
            shouldAdd = accountScopesSet.has(eip155Scope);
          }
        } else {
          shouldAdd = accountScopesSet.has(chainId);
        }
        if (shouldAdd) {
          updatedSelectedCaipAccountAddresses.add(`${chainId}:${account.address}`);
        }
      });
    });
  });
  return Array.from(updatedSelectedCaipAccountAddresses);
};
exports.getCaip25AccountIdsFromAccountGroupAndScope = getCaip25AccountIdsFromAccountGroupAndScope;

      };
    };
  }
  }
}, {package:"$root$",file:"shared\\lib\\multichain\\scope-utils.ts",}],
["D:\\code\\v\\metamask-extension\\shared\\lib\\transaction-breakdown-utils.ts", {"../../ui/helpers/utils/confirm-tx.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\confirm-tx.util.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cshared%5Clib%5Ctransaction-breakdown-utils.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calcHexGasTotal = void 0;
var _confirmTx = require("../../ui/helpers/utils/confirm-tx.util");
// eslint-disable-next-line import/no-restricted-paths

/**
 * Calculates the total cost of a transaction in hex wei.
 *
 * @param txMeta - The transaction meta object.
 * @returns The total cost of the transaction in hex wei.
 */
const calcHexGasTotal = txMeta => {
  const {
    txParams: {
      gas,
      gasPrice
    } = {},
    txReceipt: {
      gasUsed,
      effectiveGasPrice
    } = {}
  } = txMeta;
  const gasLimit = typeof gasUsed === 'string' ? gasUsed : gas;

  // To calculate the total cost of the transaction, we use gasPrice if it is in the txParam,
  // which will only be the case on non-EIP1559 networks. If it is not in the params, we can
  // use the effectiveGasPrice from the receipt, which will ultimately represent to true cost
  // of the transaction. Either of these are used the same way with gasLimit to calculate total
  // cost. effectiveGasPrice will be available on the txReciept for all EIP1559 networks
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  const usedGasPrice = gasPrice || effectiveGasPrice;
  const hexGasTotal = gasLimit && usedGasPrice &&
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  (0, _confirmTx.getHexGasTotal)({
    gasLimit,
    gasPrice: usedGasPrice
  }) || '0x0';
  return hexGasTotal;
};
exports.calcHexGasTotal = calcHexGasTotal;

      };
    };
  }
  }
}, {package:"$root$",file:"shared\\lib\\transaction-breakdown-utils.ts",}],
["D:\\code\\v\\metamask-extension\\shared\\lib\\transactions.utils.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cshared%5Clib%5Ctransactions.utils.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isBatchTransaction = isBatchTransaction;
/**
 * Determines if a transaction is a batch transaction.
 *
 * @param nestedTransactions - An array of nested transaction.
 * @returns A boolean indicating whether the transaction is a batch transaction.
 */
function isBatchTransaction(nestedTransactions) {
  return Boolean(nestedTransactions === null || nestedTransactions === void 0 ? void 0 : nestedTransactions.length);
}

      };
    };
  }
  }
}, {package:"$root$",file:"shared\\lib\\transactions.utils.ts",}],
["D:\\code\\v\\metamask-extension\\shared\\lib\\transactions\\approvals.ts", {"../../modules/transaction.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\transaction.utils.ts","@ethersproject/abi":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\abi\\lib\\index.js","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","bignumber.js":"D:\\code\\v\\metamask-extension\\node_modules\\bignumber.js\\bignumber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cshared%5Clib%5Ctransactions%5Capprovals.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateApprovalAmount = updateApprovalAmount;
var _utils = require("@metamask/utils");
var _bignumber = require("bignumber.js");
var _abi = require("@ethersproject/abi");
var _transaction = require("../../modules/transaction.utils");
const SIGNATURE_LEGACY = 'function approve(address,uint256)';
const SIGNATURE_PERMIT2 = 'function approve(address,address,uint160,uint48)';
const SIGNATURE_INCREASE_ALLOWANCE = 'function increaseAllowance(address,uint256)';
function updateApprovalAmount(originalData, newAmount, decimals) {
  const {
    name,
    tokenAddress
  } = (0, _transaction.parseApprovalTransactionData)(originalData) ?? {};
  if (!name) {
    throw new Error('Invalid approval transaction data');
  }
  const multiplier = new _bignumber.BigNumber(10).pow(decimals);
  const value = (0, _utils.add0x)(new _bignumber.BigNumber(newAmount).times(multiplier).toString(16));
  let signature = tokenAddress ? SIGNATURE_PERMIT2 : SIGNATURE_LEGACY;
  if (name === 'increaseAllowance') {
    signature = SIGNATURE_INCREASE_ALLOWANCE;
  }
  const iface = new _abi.Interface([signature]);
  const decoded = iface.decodeFunctionData(name, originalData);
  if (signature === SIGNATURE_PERMIT2) {
    return iface.encodeFunctionData(name, [tokenAddress, decoded[1], value, decoded[3]]);
  }
  return iface.encodeFunctionData(name, [decoded[0], value]);
}

      };
    };
  }
  }
}, {package:"$root$",file:"shared\\lib\\transactions\\approvals.ts",}],
["D:\\code\\v\\metamask-extension\\shared\\lib\\ui-utils.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cshared%5Clib%5Cui-utils.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VAULT_RECOVERY_LINK = exports.TRANSACTION_SIMULATIONS_LEARN_MORE_LINK = exports.SURVEY_LINK = exports.SUPPORT_LINK = exports.SMART_ACCOUNT_INFO_LINK = exports.SECURITY_ALERTS_LEARN_MORE_LINK = exports.PRIVACY_POLICY_LINK = exports.HYPERLIQUID_REFERRAL_LEARN_MORE_URL = exports.GAS_FEES_LEARN_MORE_URL = exports.ETHERSCAN_PRIVACY_LINK = exports.CRYPTOCOMPARE_LINK = exports.CONSENSYS_TERMS_OF_USE = exports.CONSENSYS_PRIVACY_LINK = exports.COINGECKO_LINK = exports.AUTO_DETECT_TOKEN_LEARN_MORE_LINK = void 0;
// no destructuring as process.env detection stops working
// eslint-disable-next-line prefer-destructuring
const SUPPORT_LINK = exports.SUPPORT_LINK = "https://support.metamask.io";
const COINGECKO_LINK = exports.COINGECKO_LINK = 'https://www.coingecko.com/';
const CRYPTOCOMPARE_LINK = exports.CRYPTOCOMPARE_LINK = 'https://www.cryptocompare.com/';
const PRIVACY_POLICY_LINK = exports.PRIVACY_POLICY_LINK = 'https://consensys.io/privacy-policy/';
const SURVEY_LINK = exports.SURVEY_LINK = 'https://www.getfeedback.com/r/Oczu1vP0';

// TODO make sure these links are correct
const ETHERSCAN_PRIVACY_LINK = exports.ETHERSCAN_PRIVACY_LINK = 'https://etherscan.io/privacyPolicy';
const CONSENSYS_PRIVACY_LINK = exports.CONSENSYS_PRIVACY_LINK = 'https://consensys.io/privacy-policy/';
const AUTO_DETECT_TOKEN_LEARN_MORE_LINK = exports.AUTO_DETECT_TOKEN_LEARN_MORE_LINK = 'https://consensys.io/privacy-policy/';
const CONSENSYS_TERMS_OF_USE = exports.CONSENSYS_TERMS_OF_USE = 'https://consensys.io/terms-of-use';
const SECURITY_ALERTS_LEARN_MORE_LINK = exports.SECURITY_ALERTS_LEARN_MORE_LINK = 'https://support.metamask.io/privacy-and-security/how-to-turn-on-security-alerts/';
const TRANSACTION_SIMULATIONS_LEARN_MORE_LINK = exports.TRANSACTION_SIMULATIONS_LEARN_MORE_LINK = 'https://support.metamask.io/transactions-and-gas/transactions/simulations/';
const GAS_FEES_LEARN_MORE_URL = exports.GAS_FEES_LEARN_MORE_URL = 'https://community.metamask.io/t/what-is-gas-why-do-transactions-take-so-long/3172';
const SMART_ACCOUNT_INFO_LINK = exports.SMART_ACCOUNT_INFO_LINK = 'https://support.metamask.io/configure/accounts/what-is-a-smart-account';
const VAULT_RECOVERY_LINK = exports.VAULT_RECOVERY_LINK = `https://support.metamask.io/configure/wallet/how-to-recover-your-secret-recovery-phrase/#step-two-locate-your-vault`;
const HYPERLIQUID_REFERRAL_LEARN_MORE_URL = exports.HYPERLIQUID_REFERRAL_LEARN_MORE_URL = 'https://hyperliquid.gitbook.io/hyperliquid-docs/referrals';

      };
    };
  }
  }
}, {package:"$root$",file:"shared\\lib\\ui-utils.js",}],
["D:\\code\\v\\metamask-extension\\shared\\modules\\bridge-utils\\security-alerts-api.util.ts", {"../../constants/multichain/networks":"D:\\code\\v\\metamask-extension\\shared\\constants\\multichain\\networks.ts","../../types/security-alerts-api":"D:\\code\\v\\metamask-extension\\shared\\types\\security-alerts-api.ts","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js","ethers/lib/utils":"D:\\code\\v\\metamask-extension\\node_modules\\ethers\\lib\\utils.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cshared%5Cmodules%5Cbridge-utils%5Csecurity-alerts-api.util.ts
      return function (require, module, exports) {
(function (Buffer){(function (){
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CHAIN_ID_TO_SECURITY_API_NAME = void 0;
exports.convertChainIdToBlockAidChainName = convertChainIdToBlockAidChainName;
exports.fetchTokenAlert = fetchTokenAlert;
exports.fetchTxAlerts = fetchTxAlerts;
exports.getTokenFeatureTitleDescriptionIds = getTokenFeatureTitleDescriptionIds;
exports.isSecurityAlertsAPIEnabled = isSecurityAlertsAPIEnabled;
var _transactionController = require("@metamask/transaction-controller");
var _keyringApi = require("@metamask/keyring-api");
var _utils = require("ethers/lib/utils");
var _superstruct = require("@metamask/superstruct");
var _securityAlertsApi = require("../../types/security-alerts-api");
var _networks = require("../../constants/multichain/networks");
const DOMAIN = 'https://metamask.io';
function isSecurityAlertsAPIEnabled() {
  const isEnabled = "true";
  return (isEnabled === null || isEnabled === void 0 ? void 0 : isEnabled.toString()) === 'true';
}
function getUrl(endpoint) {
  const host = "https://security-alerts.api.cx.metamask.io";
  if (!host) {
    throw new Error('Security alerts API URL is not set');
  }
  return `${host}/${endpoint}`;
}
function getSecurityApiScanTokenRequestBody(chain, address) {
  return {
    chain,
    address,
    metadata: {
      domain: DOMAIN
    }
  };
}

/**
 * Given a list of TokenFeatures, return the first TokenFeature that is the type Malicious, if not try for Warning, if not return null
 *
 * @param features
 * @returns TokenFeature
 */
function getFirstTokenAlert(features) {
  return (
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    features.find(feature => feature.type === _securityAlertsApi.TokenFeatureType.MALICIOUS) ||
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    features.find(feature => feature.type === _securityAlertsApi.TokenFeatureType.WARNING) || null
  );
}
async function fetchTokenAlert(chain, tokenAddress) {
  if (!isSecurityAlertsAPIEnabled()) {
    return null;
  }
  const url = getUrl('token/scan');
  const body = getSecurityApiScanTokenRequestBody(chain, tokenAddress);
  const response = await fetch(url, {
    method: 'POST',
    body: JSON.stringify(body),
    headers: {
      'Content-Type': 'application/json'
    }
  });
  if (!response.ok) {
    throw new Error(`Security alerts token scan request failed with status: ${response.status}`);
  }
  const respBody = await response.json();
  const tokenAlert = getFirstTokenAlert(respBody.features);
  if (!tokenAlert) {
    return null;
  }
  return getTokenFeatureTitleDescriptionIds(tokenAlert);
}
function getTokenFeatureTitleDescriptionIds(tokenFeature) {
  let titleId = null;
  let descriptionId = null;
  switch (tokenFeature.feature_id) {
    case 'UNSTABLE_TOKEN_PRICE':
      titleId = 'unstableTokenPriceTitle';
      descriptionId = 'unstableTokenPriceDescription';
      break;
    case 'HONEYPOT':
      titleId = 'honeypotTitle';
      descriptionId = 'honeypotDescription';
      break;
    case 'INSUFFICIENT_LOCKED_LIQUIDITY':
      titleId = 'insufficientLockedLiquidityTitle';
      descriptionId = 'insufficientLockedLiquidityDescription';
      break;
    case 'AIRDROP_PATTERN':
      titleId = 'airDropPatternTitle';
      descriptionId = 'airDropPatternDescription';
      break;
    case 'CONCENTRATED_SUPPLY_DISTRIBUTION':
      titleId = 'concentratedSupplyDistributionTitle';
      descriptionId = 'concentratedSupplyDistributionDescription';
      break;
    default:
      console.warn(`Missing token alert translation for ${tokenFeature.feature_id}.`, tokenFeature.description);
  }
  return {
    ...tokenFeature,
    titleId,
    descriptionId
  };
}
const CHAIN_ID_TO_SECURITY_API_NAME = exports.CHAIN_ID_TO_SECURITY_API_NAME = {
  [_transactionController.CHAIN_IDS.MAINNET]: 'ethereum',
  [_transactionController.CHAIN_IDS.LINEA_MAINNET]: 'linea',
  [_transactionController.CHAIN_IDS.POLYGON]: 'polygon',
  [_transactionController.CHAIN_IDS.AVALANCHE]: 'avalanche',
  [_transactionController.CHAIN_IDS.BSC]: 'bsc',
  [_transactionController.CHAIN_IDS.ARBITRUM]: 'arbitrum',
  [_transactionController.CHAIN_IDS.OPTIMISM]: 'optimism',
  [_transactionController.CHAIN_IDS.ZKSYNC_ERA]: 'zksync',
  [_transactionController.CHAIN_IDS.BASE]: 'base',
  [_transactionController.CHAIN_IDS.SEI]: 'sei',
  [_networks.MultichainNetworks.SOLANA]: 'solana',
  [_networks.MultichainNetworks.BITCOIN]: 'bitcoin',
  [_networks.MultichainNetworks.BITCOIN_TESTNET]: null,
  // not supported
  [_networks.MultichainNetworks.BITCOIN_SIGNET]: null,
  // not supported
  [_networks.MultichainNetworks.SOLANA_DEVNET]: null,
  // not supported
  [_networks.MultichainNetworks.SOLANA_TESTNET]: null // not supported
};
function convertChainIdToBlockAidChainName(chainId) {
  return CHAIN_ID_TO_SECURITY_API_NAME[chainId] ?? null;
}
async function fetchTxAlerts(params) {
  if (!isSecurityAlertsAPIEnabled() || !params) {
    return null;
  }
  const {
    chainId,
    trade,
    accountAddress
  } = params;
  const chain = convertChainIdToBlockAidChainName(chainId);
  if (!chain) {
    return null;
  }
  const url = getUrl(`${chain}/message/scan`);
  const body = {
    method: _keyringApi.SolMethod.SignAndSendTransaction,
    encoding: 'base64',
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
    // eslint-disable-next-line @typescript-eslint/naming-convention
    account_address: Buffer.from(_utils.base58.decode(accountAddress)).toString('base64'),
    chain: 'mainnet',
    transactions: [trade],
    options: ['simulation', 'validation'],
    metadata: {
      url: null
    }
  };
  const response = await fetch(url, {
    method: 'POST',
    body: JSON.stringify(body),
    headers: {
      'Content-Type': 'application/json'
    }
  });
  if (!response.ok) {
    throw new Error(`Security alerts message scan request failed with status: ${response.status}`);
  }
  const respBody = await response.json();
  (0, _superstruct.assert)(respBody, _securityAlertsApi.MessageScanResponse);
  if (respBody.status === 'ERROR') {
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
    // eslint-disable-next-line camelcase, @typescript-eslint/naming-convention
    const {
      error_details
    } = respBody;
    return {
      titleId: 'txAlertTitle',
      // eslint-disable-next-line camelcase
      description: error_details !== null && error_details !== void 0 && error_details.message ?
      // eslint-disable-next-line camelcase
      `The ${error_details.message}.` : '',
      descriptionId: 'bridgeSelectDifferentQuote'
    };
  }
  return null;
}

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"$root$",file:"shared\\modules\\bridge-utils\\security-alerts-api.util.ts",}],
["D:\\code\\v\\metamask-extension\\shared\\types\\security-alerts-api.ts", {"@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cshared%5Ctypes%5Csecurity-alerts-api.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TokenFeatureType = exports.MessageScanResponse = void 0;
var _superstruct = require("@metamask/superstruct");
let TokenFeatureType = exports.TokenFeatureType = /*#__PURE__*/function (TokenFeatureType) {
  TokenFeatureType["MALICIOUS"] = "Malicious";
  TokenFeatureType["WARNING"] = "Warning";
  TokenFeatureType["INFO"] = "Info";
  TokenFeatureType["BENIGN"] = "Benign";
  return TokenFeatureType;
}({});
const MessageScanResponse = exports.MessageScanResponse = (0, _superstruct.type)({
  error: (0, _superstruct.nullable)((0, _superstruct.string)()),
  status: (0, _superstruct.string)(),
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
  // eslint-disable-next-line @typescript-eslint/naming-convention
  error_details: (0, _superstruct.nullable)((0, _superstruct.type)({
    message: (0, _superstruct.string)(),
    code: (0, _superstruct.string)()
  }))
});

      };
    };
  }
  }
}, {package:"$root$",file:"shared\\types\\security-alerts-api.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\account-icon-tour\\account-icon-tour.tsx", {"../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../multichain/product-tour-popover":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\product-tour-popover\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Caccount-icon-tour%5Caccount-icon-tour.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountIconTour = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _productTourPopover = require("../../multichain/product-tour-popover");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _actions = require("../../../store/actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const options = {
  placement: 'bottom-start',
  modifiers: [{
    name: 'offset',
    options: {
      offset: [0, 8]
    }
  }, {
    name: 'preventOverflow',
    options: {
      boundary: 'clippingParents',
      altBoundary: true
    }
  }]
};
const accountIconTour = state => state.metamask.productTour === 'accountIcon';
const AccountIconTour = props => {
  const {
    anchorElement
  } = props;
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const isVisible = (0, _reactRedux.useSelector)(accountIconTour);
  const handleClose = (0, _react.useCallback)(() => {
    dispatch((0, _actions.clearProductTour)());
  }, [dispatch]);
  if (false || !isVisible || !anchorElement) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_productTourPopover.ProductTour, {
    anchorElement: anchorElement,
    title: t('newAccountIconTitle'),
    description: t('newAccountIconMessage', [/*#__PURE__*/_react.default.createElement("b", {
      key: "0"
    }, t('settings')), /*#__PURE__*/_react.default.createElement("b", {
      key: "1"
    }, t('general')), /*#__PURE__*/_react.default.createElement("b", {
      key: "2"
    }, t('accountIdenticon'))]),
    arrowPosition: "-4px",
    popperOptions: options,
    closeMenu: handleClose,
    onClick: handleClose
  });
};
exports.AccountIconTour = AccountIconTour;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\account-icon-tour\\account-icon-tour.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\account-list-item\\account-list-item.js", {"../../../../app/scripts/lib/multichain/address":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\multichain\\address.ts","../../ui/account-mismatch-warning/account-mismatch-warning.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\account-mismatch-warning\\account-mismatch-warning.component.js","../../ui/identicon":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\identicon\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Caccount-list-item%5Caccount-list-item.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = AccountListItem;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _identicon = _interopRequireDefault(require("../../ui/identicon"));
var _accountMismatchWarning = _interopRequireDefault(require("../../ui/account-mismatch-warning/account-mismatch-warning.component"));
var _address = require("../../../../app/scripts/lib/multichain/address");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

function AccountListItem({
  account,
  className,
  displayAddress = false,
  handleClick,
  icon = null
}) {
  const {
    metadata: {
      name
    },
    address,
    balance
  } = account;
  const showDefaultMismatchWarning = true;
  return /*#__PURE__*/_react.default.createElement("div", {
    className: `account-list-item ${className}`,
    "data-testid": "account-list-item",
    onClick: () => handleClick === null || handleClick === void 0 ? void 0 : handleClick({
      name,
      address,
      balance
    })
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "account-list-item__top-row"
  }, /*#__PURE__*/_react.default.createElement(_identicon.default, {
    address: address,
    className: "account-list-item__identicon",
    diameter: 18
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "account-list-item__account-name"
  }, name || address), icon ? /*#__PURE__*/_react.default.createElement("div", {
    className: "account-list-item__icon",
    "data-testid": "account-list-item-icon"
  }, icon) : null, showDefaultMismatchWarning && /*#__PURE__*/_react.default.createElement(_accountMismatchWarning.default, {
    address: address
  })), displayAddress && name && /*#__PURE__*/_react.default.createElement("div", {
    className: "account-list-item__account-address"
  }, (0, _address.normalizeSafeAddress)(address)));
}
AccountListItem.propTypes = {
  /**
   * An account object that has name, address, and balance data
   */
  account: _propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    address: _propTypes.default.string.isRequired,
    balance: _propTypes.default.string.isRequired,
    metadata: _propTypes.default.shape({
      name: _propTypes.default.string.isRequired,
      snap: _propTypes.default.shape({
        id: _propTypes.default.string.isRequired,
        name: _propTypes.default.string,
        enabled: _propTypes.default.bool
      }),
      keyring: _propTypes.default.shape({
        type: _propTypes.default.string.isRequired
      }).isRequired
    }).isRequired
  }).isRequired,
  /**
   * Additional className to add to the root div element of AccountListItem
   */
  className: _propTypes.default.string,
  /**
   * Display the address of the account object
   */
  displayAddress: _propTypes.default.bool,
  /**
   * The onClick handler of the AccountListItem
   */
  handleClick: _propTypes.default.func,
  /**
   * Pass icon component to be displayed. Currently not used
   */
  icon: _propTypes.default.node
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\account-list-item\\account-list-item.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\account-list-item\\index.js", {"./account-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\account-list-item\\account-list-item.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Caccount-list-item%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _accountListItem.default;
  }
});
var _accountListItem = _interopRequireDefault(require("./account-list-item"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\account-list-item\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\alert-system\\alert-modal\\alert-modal.tsx", {"../../../../../shared/constants/security-provider":"D:\\code\\v\\metamask-extension\\shared\\constants\\security-provider.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useAlerts":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAlerts.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../pages/confirmations/context/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\context\\confirm\\index.tsx","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../contexts/alertActionHandler":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\alert-system\\contexts\\alertActionHandler.tsx","../contexts/alertMetricsContext":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\alert-system\\contexts\\alertMetricsContext.tsx","@metamask/snaps-sdk":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Calert-system%5Calert-modal%5Calert-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AcknowledgeCheckboxBase = AcknowledgeCheckboxBase;
exports.AlertModal = AlertModal;
var _snapsSdk = require("@metamask/snaps-sdk");
var _react = _interopRequireWildcard(require("react"));
var _securityProvider = require("../../../../../shared/constants/security-provider");
var _designSystem = require("../../../../helpers/constants/design-system");
var _useAlerts = _interopRequireDefault(require("../../../../hooks/useAlerts"));
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _confirm = require("../../../../pages/confirmations/context/confirm");
var _componentLibrary = require("../../../component-library");
var _alertActionHandler = require("../contexts/alertActionHandler");
var _alertMetricsContext = require("../contexts/alertMetricsContext");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getSeverityStyle(severity) {
  switch (severity) {
    case _designSystem.Severity.Warning:
      return {
        background: _designSystem.BackgroundColor.warningMuted,
        icon: _designSystem.IconColor.warningDefault
      };
    case _designSystem.Severity.Danger:
      return {
        background: _designSystem.BackgroundColor.errorMuted,
        icon: _designSystem.IconColor.errorDefault
      };
    default:
      return {
        background: _designSystem.BackgroundColor.backgroundDefault,
        icon: _designSystem.IconColor.infoDefault
      };
  }
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function AlertHeader({
  selectedAlert,
  customTitle
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    severity,
    reason
  } = selectedAlert;
  const severityStyle = getSeverityStyle(severity);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    gap: 3,
    display: _designSystem.Display.Block,
    alignItems: _designSystem.AlignItems.center,
    textAlign: _designSystem.TextAlign.Center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: severity === _designSystem.Severity.Info ? _componentLibrary.IconName.Info : _componentLibrary.IconName.Danger,
    size: _componentLibrary.IconSize.Xl,
    color: severityStyle.icon
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingSm,
    color: _designSystem.TextColor.inherit,
    marginTop: 3,
    marginBottom: 4
  }, customTitle ?? reason ?? t('alert')));
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function BlockaidAlertDetails() {
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    currentConfirmation
  } = (0, _confirm.useConfirmContext)();
  const {
    securityAlertResponse
  } = currentConfirmation;
  let copy;
  switch (securityAlertResponse === null || securityAlertResponse === void 0 ? void 0 : securityAlertResponse.reason) {
    case _securityProvider.BlockaidReason.approvalFarming:
    case _securityProvider.BlockaidReason.setApprovalForAll:
    case _securityProvider.BlockaidReason.permitFarming:
      copy = t('blockaidAlertDescriptionWithdraw');
      break;
    case _securityProvider.BlockaidReason.transferFarming:
    case _securityProvider.BlockaidReason.transferFromFarming:
    case _securityProvider.BlockaidReason.rawNativeTokenTransfer:
      copy = t('blockaidAlertDescriptionTokenTransfer');
      break;
    case _securityProvider.BlockaidReason.seaportFarming:
      copy = t('blockaidAlertDescriptionOpenSea');
      break;
    case _securityProvider.BlockaidReason.blurFarming:
      copy = t('blockaidAlertDescriptionBlur');
      break;
    case _securityProvider.BlockaidReason.maliciousDomain:
      copy = t('blockaidAlertDescriptionMalicious');
      break;
    case _securityProvider.BlockaidReason.rawSignatureFarming:
    case _securityProvider.BlockaidReason.tradeOrderFarming:
    case _securityProvider.BlockaidReason.other:
    default:
      copy = t('blockaidAlertDescriptionOthers');
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    textAlign: _designSystem.TextAlign.Center,
    variant: _designSystem.TextVariant.bodyMd
  }, copy);
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function AlertDetails({
  selectedAlert,
  customDetails
}) {
  var _selectedAlert$alertD, _selectedAlert$alertD2;
  const t = (0, _useI18nContext.useI18nContext)();
  const severityStyle = getSeverityStyle(selectedAlert.severity);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    key: selectedAlert.key,
    display: _designSystem.Display.InlineBlock,
    padding: customDetails ? 0 : 2,
    width: _designSystem.BlockSize.Full,
    backgroundColor: customDetails ? undefined : severityStyle.background,
    borderRadius: _designSystem.BorderRadius.SM
  }, customDetails ?? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, Boolean(selectedAlert.content) && selectedAlert.content, Boolean(selectedAlert.message) && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    "data-testid": "alert-modal__selected-alert"
  }, selectedAlert.message), (_selectedAlert$alertD = selectedAlert.alertDetails) !== null && _selectedAlert$alertD !== void 0 && _selectedAlert$alertD.length ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdBold,
    marginTop: 1
  }, t('alertModalDetails')) : null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    as: "ul",
    className: "alert-modal__alert-details",
    paddingLeft: 6
  }, (_selectedAlert$alertD2 = selectedAlert.alertDetails) === null || _selectedAlert$alertD2 === void 0 ? void 0 : _selectedAlert$alertD2.map((detail, index) => /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    as: "li",
    key: `${selectedAlert.key}-detail-${index}`
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd
  }, detail))))));
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function AcknowledgeCheckboxBase({
  selectedAlert,
  onCheckboxClick,
  isConfirmed,
  label
}) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  if (selectedAlert.isBlocking || selectedAlert.severity !== _designSystem.Severity.Danger) {
    return null;
  }
  const t = (0, _useI18nContext.useI18nContext)();
  const severityStyle = getSeverityStyle(selectedAlert.severity);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    padding: 4,
    width: _designSystem.BlockSize.Full,
    backgroundColor: severityStyle.background,
    borderRadius: _designSystem.BorderRadius.LG,
    marginTop: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Checkbox, {
    label: label ?? t('alertModalAcknowledge'),
    "data-testid": "alert-modal-acknowledge-checkbox",
    isChecked: isConfirmed,
    onChange: onCheckboxClick,
    alignItems: _designSystem.AlignItems.flexStart,
    className: "alert-modal__acknowledge-checkbox"
  }));
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function AcknowledgeButton({
  onAcknowledgeClick,
  isConfirmed,
  hasActions,
  isBlocking
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    variant: hasActions ? _snapsSdk.ButtonVariant.Secondary : _snapsSdk.ButtonVariant.Primary,
    width: _designSystem.BlockSize.Full,
    onClick: onAcknowledgeClick,
    size: _componentLibrary.ButtonSize.Lg,
    "data-testid": "alert-modal-button",
    disabled: !isBlocking && !isConfirmed
  }, t('gotIt'));
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function ActionButton({
  action,
  onClose,
  alertKey
}) {
  const {
    processAction
  } = (0, _alertActionHandler.useAlertActionHandler)();
  const {
    trackAlertActionClicked
  } = (0, _alertMetricsContext.useAlertMetrics)();
  const handleClick = (0, _react.useCallback)(() => {
    if (!action) {
      return;
    }
    trackAlertActionClicked(alertKey);
    processAction(action.key);
    onClose({
      recursive: true
    });
  }, [action, onClose, processAction, trackAlertActionClicked, alertKey]);
  if (!action) {
    return null;
  }
  const {
    key,
    label
  } = action;
  const dataTestId = `alert-modal-action-${key}`;
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    "data-testid": dataTestId,
    key: key,
    variant: _snapsSdk.ButtonVariant.Primary,
    width: _designSystem.BlockSize.Full,
    size: _componentLibrary.ButtonSize.Lg,
    onClick: handleClick
  }, label);
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function AlertModal({
  ownerId,
  onAcknowledgeClick,
  alertKey,
  onClose,
  headerStartAccessory,
  customTitle,
  customDetails,
  customAcknowledgeCheckbox,
  customAcknowledgeButton,
  showCloseIcon = true
}) {
  const {
    isAlertConfirmed,
    setAlertConfirmed,
    alerts
  } = (0, _useAlerts.default)(ownerId);
  const {
    trackAlertRender
  } = (0, _alertMetricsContext.useAlertMetrics)();
  const handleClose = (0, _react.useCallback)((...args) => {
    onClose(...args);
  }, [onClose]);
  const selectedAlert = alerts.find(alert => alert.key === alertKey);
  (0, _react.useEffect)(() => {
    if (selectedAlert) {
      trackAlertRender(selectedAlert.key);
    }
  }, [selectedAlert, trackAlertRender]);
  const isConfirmed = selectedAlert ? isAlertConfirmed(selectedAlert.key) : false;
  const isAlertDanger = selectedAlert ? selectedAlert.severity === _designSystem.Severity.Danger : false;
  const handleCheckboxClick = (0, _react.useCallback)(() => {
    if (selectedAlert) {
      setAlertConfirmed(selectedAlert.key, !isConfirmed);
    }
  }, [isConfirmed, selectedAlert, setAlertConfirmed]);
  if (!selectedAlert) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: true,
    onClose: handleClose,
    "data-testid": "alert-modal"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onClose: showCloseIcon ? handleClose : undefined,
    startAccessory: headerStartAccessory,
    paddingBottom: 0,
    display: headerStartAccessory ? _designSystem.Display.InlineFlex : _designSystem.Display.Block,
    closeButtonProps: {
      'data-testid': 'alert-modal-close-button'
    },
    endAccessory: showCloseIcon ? undefined : null // Override endAccessory to omit the close icon
  }), /*#__PURE__*/_react.default.createElement(AlertHeader, {
    selectedAlert: selectedAlert,
    customTitle: customTitle
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, null, selectedAlert.provider === _securityProvider.SecurityProvider.Blockaid ? /*#__PURE__*/_react.default.createElement(BlockaidAlertDetails, null) : /*#__PURE__*/_react.default.createElement(AlertDetails, {
    selectedAlert: selectedAlert,
    customDetails: customDetails
  }), customAcknowledgeCheckbox ?? /*#__PURE__*/_react.default.createElement(AcknowledgeCheckboxBase, {
    selectedAlert: selectedAlert,
    isConfirmed: isConfirmed,
    onCheckboxClick: handleCheckboxClick
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalFooter, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 4,
    paddingTop: 2,
    width: _designSystem.BlockSize.Full
  }, customAcknowledgeButton ?? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(AcknowledgeButton, {
    onAcknowledgeClick: onAcknowledgeClick,
    isConfirmed: !isAlertDanger || isConfirmed,
    hasActions: Boolean(selectedAlert.actions),
    isBlocking: selectedAlert.isBlocking
  }), (selectedAlert.actions ?? []).map(action => /*#__PURE__*/_react.default.createElement(ActionButton, {
    key: action.key,
    action: action,
    onClose: handleClose,
    alertKey: selectedAlert.key
  })))))));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\alert-system\\alert-modal\\alert-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\alert-system\\alert-modal\\index.tsx", {"./alert-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\alert-system\\alert-modal\\alert-modal.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Calert-system%5Calert-modal%5Cindex.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "AlertModal", {
  enumerable: true,
  get: function () {
    return _alertModal.AlertModal;
  }
});
var _alertModal = require("./alert-modal");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\alert-system\\alert-modal\\index.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\alert-system\\alert-provider\\alert-provider.tsx", {"../../../../../shared/constants/security-provider":"D:\\code\\v\\metamask-extension\\shared\\constants\\security-provider.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Calert-system%5Calert-provider%5Calert-provider.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertProvider = AlertProvider;
var _react = _interopRequireDefault(require("react"));
var _securityProvider = require("../../../../../shared/constants/security-provider");
var _componentLibrary = require("../../../component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../hooks/useI18nContext");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function AlertProvider({
  provider,
  paddingTop = 0,
  textAlign
}) {
  var _SECURITY_PROVIDER_CO, _SECURITY_PROVIDER_CO2;
  const t = (0, _useI18nContext.useI18nContext)();
  if (!provider) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingTop: paddingTop,
    textAlign: textAlign
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    marginTop: 1,
    display: _designSystem.Display.InlineFlex,
    alignItems: _designSystem.AlignItems.center,
    color: _designSystem.TextColor.textAlternative,
    variant: _designSystem.TextVariant.bodySm
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    color: _designSystem.IconColor.primaryDefault,
    name: _componentLibrary.IconName.SecurityTick,
    size: _componentLibrary.IconSize.Sm,
    marginInlineEnd: 1
  }), t('securityProviderPoweredBy', [/*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    key: `security-provider-button-link-${provider}`,
    size: _componentLibrary.ButtonLinkSize.Inherit,
    href: (_SECURITY_PROVIDER_CO = _securityProvider.SECURITY_PROVIDER_CONFIG[provider]) === null || _SECURITY_PROVIDER_CO === void 0 ? void 0 : _SECURITY_PROVIDER_CO.url,
    externalLink: true
  }, t((_SECURITY_PROVIDER_CO2 = _securityProvider.SECURITY_PROVIDER_CONFIG[provider]) === null || _SECURITY_PROVIDER_CO2 === void 0 ? void 0 : _SECURITY_PROVIDER_CO2.tKeyName))])));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\alert-system\\alert-provider\\alert-provider.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\alert-system\\alert-provider\\index.tsx", {"./alert-provider":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\alert-system\\alert-provider\\alert-provider.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Calert-system%5Calert-provider%5Cindex.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "AlertProvider", {
  enumerable: true,
  get: function () {
    return _alertProvider.AlertProvider;
  }
});
var _alertProvider = require("./alert-provider");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\alert-system\\alert-provider\\index.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\alert-system\\confirm-alert-modal\\confirm-alert-modal.tsx", {"../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useAlerts":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAlerts.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../alert-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\alert-system\\alert-modal\\index.tsx","../alert-modal/alert-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\alert-system\\alert-modal\\alert-modal.tsx","../multiple-alert-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\alert-system\\multiple-alert-modal\\index.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Calert-system%5Cconfirm-alert-modal%5Cconfirm-alert-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmAlertModal = ConfirmAlertModal;
var _react = _interopRequireWildcard(require("react"));
var _componentLibrary = require("../../../component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _useAlerts = _interopRequireDefault(require("../../../../hooks/useAlerts"));
var _alertModal = require("../alert-modal");
var _alertModal2 = require("../alert-modal/alert-modal");
var _multipleAlertModal = require("../multiple-alert-modal");
var _metametrics = require("../../../../../shared/constants/metametrics");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function ConfirmButtons({
  onCancel,
  onSubmit,
  isConfirmed
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  const onAlertCancel = (0, _react.useCallback)(() => {
    onCancel({
      location: _metametrics.MetaMetricsEventLocation.AlertFrictionModal
    });
  }, [onCancel]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    block: true,
    onClick: onAlertCancel,
    size: _componentLibrary.ButtonSize.Lg,
    variant: _componentLibrary.ButtonVariant.Secondary,
    "data-testid": "confirm-alert-modal-cancel-button"
  }, t('reject')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    variant: _componentLibrary.ButtonVariant.Primary,
    onClick: onSubmit,
    size: _componentLibrary.ButtonSize.Lg,
    "data-testid": "confirm-alert-modal-submit-button",
    disabled: !isConfirmed,
    danger: true,
    startIconName: _componentLibrary.IconName.Danger
  }, t('confirm')));
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function ConfirmDetails({
  onAlertLinkClick
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    alignItems: _designSystem.AlignItems.center,
    textAlign: _designSystem.TextAlign.Center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd
  }, t('confirmationAlertDetails')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    marginTop: 4,
    size: _componentLibrary.ButtonLinkSize.Inherit,
    textProps: {
      variant: _designSystem.TextVariant.bodyMd,
      alignItems: _designSystem.AlignItems.flexStart
    },
    as: "a",
    onClick: onAlertLinkClick,
    target: "_blank",
    rel: "noopener noreferrer",
    "data-testid": "confirm-alert-modal-review-all-alerts"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.SecuritySearch,
    size: _componentLibrary.IconSize.Inherit
  }), t('alertModalReviewAllAlerts'))));
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function ConfirmAlertModal({
  onCancel,
  onClose,
  onSubmit,
  ownerId
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    fieldAlerts,
    alerts,
    hasUnconfirmedFieldDangerAlerts
  } = (0, _useAlerts.default)(ownerId);
  const [confirmCheckbox, setConfirmCheckbox] = (0, _react.useState)(false);
  const hasDangerBlockingAlerts = fieldAlerts.some(alert => alert.severity === _designSystem.Severity.Danger && alert.isBlocking);

  // if there are unconfirmed danger alerts, show the multiple alert modal
  const [multipleAlertModalVisible, setMultipleAlertModalVisible] = (0, _react.useState)(hasUnconfirmedFieldDangerAlerts);
  const handleCloseMultipleAlertModal = (0, _react.useCallback)(request => {
    setMultipleAlertModalVisible(false);
    if (
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    request !== null && request !== void 0 && request.recursive || hasUnconfirmedFieldDangerAlerts || hasDangerBlockingAlerts) {
      onClose();
    }
  }, [onClose, hasUnconfirmedFieldDangerAlerts, hasDangerBlockingAlerts]);
  const handleOpenMultipleAlertModal = (0, _react.useCallback)(() => {
    setMultipleAlertModalVisible(true);
  }, []);
  const handleConfirmCheckbox = (0, _react.useCallback)(() => {
    setConfirmCheckbox(!confirmCheckbox);
  }, [confirmCheckbox]);
  if (multipleAlertModalVisible) {
    return /*#__PURE__*/_react.default.createElement(_multipleAlertModal.MultipleAlertModal, {
      ownerId: ownerId,
      onFinalAcknowledgeClick: handleCloseMultipleAlertModal,
      onClose: handleCloseMultipleAlertModal,
      showCloseIcon: false
    });
  }
  const selectedAlert = alerts[0];
  if (!selectedAlert) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_alertModal.AlertModal, {
    ownerId: ownerId,
    onAcknowledgeClick: onClose,
    alertKey: selectedAlert.key,
    onClose: onClose,
    customTitle: t('confirmationAlertModalTitleDescription'),
    customDetails: /*#__PURE__*/_react.default.createElement(ConfirmDetails, {
      onAlertLinkClick: handleOpenMultipleAlertModal
    }),
    customAcknowledgeCheckbox: /*#__PURE__*/_react.default.createElement(_alertModal2.AcknowledgeCheckboxBase, {
      selectedAlert: selectedAlert,
      isConfirmed: confirmCheckbox,
      onCheckboxClick: handleConfirmCheckbox,
      label: alerts.length === 1 ? t('confirmAlertModalAcknowledgeSingle') : t('confirmAlertModalAcknowledgeMultiple')
    }),
    customAcknowledgeButton: /*#__PURE__*/_react.default.createElement(ConfirmButtons, {
      onCancel: onCancel,
      onSubmit: onSubmit,
      isConfirmed: confirmCheckbox
    })
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\alert-system\\confirm-alert-modal\\confirm-alert-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\alert-system\\confirm-alert-modal\\index.tsx", {"./confirm-alert-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\alert-system\\confirm-alert-modal\\confirm-alert-modal.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Calert-system%5Cconfirm-alert-modal%5Cindex.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ConfirmAlertModal", {
  enumerable: true,
  get: function () {
    return _confirmAlertModal.ConfirmAlertModal;
  }
});
var _confirmAlertModal = require("./confirm-alert-modal");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\alert-system\\confirm-alert-modal\\index.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\alert-system\\contexts\\alertActionHandler.tsx", {"react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Calert-system%5Ccontexts%5CalertActionHandler.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertActionHandler = exports.AlertActionHandlerProvider = exports.AlertActionHandlerContext = void 0;
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AlertActionHandlerContext = exports.AlertActionHandlerContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const AlertActionHandlerProvider = ({
  children,
  onProcessAction
}) => {
  const processAction = (0, _react.useCallback)(_actionKey => {
    onProcessAction(_actionKey);
  }, [onProcessAction]);
  return /*#__PURE__*/_react.default.createElement(AlertActionHandlerContext.Provider, {
    value: {
      processAction
    }
  }, children);
};
exports.AlertActionHandlerProvider = AlertActionHandlerProvider;
const useAlertActionHandler = () => {
  const context = (0, _react.useContext)(AlertActionHandlerContext);
  if (!context) {
    throw new Error('useAlertActionHandler must be used within an AlertActionHandlerProvider');
  }
  return context;
};
exports.useAlertActionHandler = useAlertActionHandler;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\alert-system\\contexts\\alertActionHandler.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\alert-system\\contexts\\alertMetricsContext.tsx", {"react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Calert-system%5Ccontexts%5CalertMetricsContext.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertMetrics = exports.AlertMetricsProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AlertMetricsContext = /*#__PURE__*/(0, _react.createContext)(null);
const AlertMetricsProvider = ({
  children,
  metrics
}) => {
  const {
    trackAlertActionClicked,
    trackAlertRender,
    trackInlineAlertClicked
  } = metrics;
  const value = (0, _react.useMemo)(() => ({
    trackAlertActionClicked,
    trackAlertRender,
    trackInlineAlertClicked
  }), [trackAlertActionClicked, trackAlertRender, trackInlineAlertClicked]);
  return /*#__PURE__*/_react.default.createElement(AlertMetricsContext.Provider, {
    value: value
  }, children);
};
exports.AlertMetricsProvider = AlertMetricsProvider;
const useAlertMetrics = () => {
  const context = (0, _react.useContext)(AlertMetricsContext);
  if (!context) {
    throw new Error('useAlertMetrics must be used within an AlertMetricsProvider');
  }
  return context;
};
exports.useAlertMetrics = useAlertMetrics;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\alert-system\\contexts\\alertMetricsContext.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\alert-system\\general-alert\\general-alert.tsx", {"../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/constants/zendesk-url":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\zendesk-url.js","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../ui/disclosure":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\disclosure\\index.js","../../../ui/disclosure/disclosure.constants":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\disclosure\\disclosure.constants.ts","../alert-provider":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\alert-system\\alert-provider\\index.tsx","../utils":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\alert-system\\utils.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Calert-system%5Cgeneral-alert%5Cgeneral-alert.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../../component-library");
var _disclosure = _interopRequireDefault(require("../../../ui/disclosure"));
var _disclosure2 = require("../../../ui/disclosure/disclosure.constants");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _designSystem = require("../../../../helpers/constants/design-system");
var _zendeskUrl = _interopRequireDefault(require("../../../../helpers/constants/zendesk-url"));
var _utils = require("../utils");
var _alertProvider = require("../alert-provider");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function ReportLink({
  reportUrl,
  provider,
  onClickSupportLink
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    marginTop: 1,
    display: _designSystem.Display.Flex
  }, t('somethingDoesntLookRight', [/*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    "data-testid": "alert-provider-report-link",
    key: `security-provider-button-supporturl-${provider}`,
    size: _componentLibrary.ButtonLinkSize.Inherit,
    href: reportUrl ?? _zendeskUrl.default.SUPPORT_URL,
    externalLink: true,
    onClick: onClickSupportLink
  }, t('reportIssue'))]));
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function AlertDetails({
  details,
  reportUrl,
  onClickSupportLink,
  provider
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  if (!details) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginTop: 1
  }, /*#__PURE__*/_react.default.createElement(_disclosure.default, {
    title: t('seeDetails'),
    variant: _disclosure2.DisclosureVariant.Arrow
  }, details instanceof Array ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    as: "ul",
    className: "alert-modal__alert-details",
    paddingLeft: 6
  }, details.map((detail, index) => /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    as: "li",
    key: `disclosure-detail-${index}`
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    fontWeight: _designSystem.FontWeight.Normal
  }, detail)))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, details), /*#__PURE__*/_react.default.createElement(ReportLink, {
    reportUrl: reportUrl,
    provider: provider,
    onClickSupportLink: onClickSupportLink
  })));
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function GeneralAlert({
  description,
  details,
  onClickSupportLink,
  provider,
  severity,
  title,
  reportUrl,
  ...props
}) {
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerAlert, _extends({
    title: title,
    severity: (0, _utils.getBannerAlertSeverity)(severity),
    description: description
  }, props), props.children, /*#__PURE__*/_react.default.createElement(AlertDetails, {
    details: details,
    reportUrl: reportUrl,
    onClickSupportLink: onClickSupportLink,
    provider: provider
  }), /*#__PURE__*/_react.default.createElement(_alertProvider.AlertProvider, {
    provider: provider
  }));
}
var _default = exports.default = GeneralAlert;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\alert-system\\general-alert\\general-alert.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\alert-system\\inline-alert\\index.ts", {"./inline-alert":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\alert-system\\inline-alert\\inline-alert.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Calert-system%5Cinline-alert%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _inlineAlert.default;
  }
});
var _inlineAlert = _interopRequireDefault(require("./inline-alert"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\alert-system\\inline-alert\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\alert-system\\inline-alert\\inline-alert.tsx", {"../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Calert-system%5Cinline-alert%5Cinline-alert.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = InlineAlert;
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireDefault(require("react"));
var _designSystem = require("../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _componentLibrary = require("../../../component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function InlineAlert({
  onClick,
  severity = _designSystem.Severity.Info,
  style,
  textOverride,
  showArrow = true
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    "data-testid": "inline-alert",
    borderRadius: _designSystem.BorderRadius.SM,
    gap: 1,
    display: _designSystem.Display.InlineFlex,
    alignItems: _designSystem.AlignItems.center,
    className: (0, _classnames.default)({
      'inline-alert': true,
      'inline-alert__info': severity === _designSystem.Severity.Info,
      'inline-alert__warning': severity === _designSystem.Severity.Warning,
      'inline-alert__danger': severity === _designSystem.Severity.Danger,
      'inline-alert__success': severity === _designSystem.Severity.Success
    }),
    style: {
      cursor: onClick ? 'pointer' : 'default',
      ...style
    },
    onClick: onClick
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: severity === _designSystem.Severity.Danger ? _componentLibrary.IconName.Danger : _componentLibrary.IconName.Info,
    size: _componentLibrary.IconSize.Sm
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.inherit
  }, textOverride ?? t('alert')), showArrow && /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.ArrowRight,
    size: _componentLibrary.IconSize.Xs
  })));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\alert-system\\inline-alert\\inline-alert.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\alert-system\\multiple-alert-modal\\index.tsx", {"./multiple-alert-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\alert-system\\multiple-alert-modal\\multiple-alert-modal.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Calert-system%5Cmultiple-alert-modal%5Cindex.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "MultipleAlertModal", {
  enumerable: true,
  get: function () {
    return _multipleAlertModal.MultipleAlertModal;
  }
});
var _multipleAlertModal = require("./multiple-alert-modal");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\alert-system\\multiple-alert-modal\\index.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\alert-system\\multiple-alert-modal\\multiple-alert-modal.tsx", {"../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useAlerts":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAlerts.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../alert-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\alert-system\\alert-modal\\index.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Calert-system%5Cmultiple-alert-modal%5Cmultiple-alert-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultipleAlertModal = MultipleAlertModal;
var _react = _interopRequireWildcard(require("react"));
var _componentLibrary = require("../../../component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _useAlerts = _interopRequireDefault(require("../../../../hooks/useAlerts"));
var _alertModal = require("../alert-modal");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function PreviousButton({
  selectedIndex,
  onBackButtonClick
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  const showPreviousButton = selectedIndex + 1 > 1;
  if (!showPreviousButton) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    iconName: _componentLibrary.IconName.ArrowLeft,
    ariaLabel: t('back'),
    size: _componentLibrary.ButtonIconSize.Sm,
    onClick: onBackButtonClick,
    className: "confirm_nav__left_btn",
    "data-testid": "alert-modal-back-button",
    borderRadius: _designSystem.BorderRadius.full,
    color: _designSystem.IconColor.iconAlternative,
    backgroundColor: _designSystem.BackgroundColor.backgroundAlternative
  });
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function NextButton({
  selectedIndex,
  alertsLength,
  onNextButtonClick
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  const showNextButton = selectedIndex + 1 < alertsLength;
  if (!showNextButton) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    iconName: _componentLibrary.IconName.ArrowRight,
    ariaLabel: t('next'),
    size: _componentLibrary.ButtonIconSize.Sm,
    onClick: onNextButtonClick,
    className: "confirm_nav__right_btn",
    "data-testid": "alert-modal-next-button",
    borderRadius: _designSystem.BorderRadius.full,
    color: _designSystem.IconColor.iconAlternative,
    backgroundColor: _designSystem.BackgroundColor.backgroundAlternative
  });
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function PageNumber({
  selectedIndex,
  alertsLength
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative,
    marginInline: 1,
    style: {
      whiteSpace: 'nowrap'
    }
  }, `${selectedIndex + 1} ${t('ofTextNofM')} ${alertsLength}`);
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function PageNavigation({
  alerts,
  onBackButtonClick,
  onNextButtonClick,
  selectedIndex
}) {
  if (alerts.length <= 1) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(PreviousButton, {
    selectedIndex: selectedIndex,
    onBackButtonClick: onBackButtonClick
  }), /*#__PURE__*/_react.default.createElement(PageNumber, {
    selectedIndex: selectedIndex,
    alertsLength: alerts.length
  }), /*#__PURE__*/_react.default.createElement(NextButton, {
    selectedIndex: selectedIndex,
    alertsLength: alerts.length,
    onNextButtonClick: onNextButtonClick
  }));
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function MultipleAlertModal({
  alertKey,
  displayAllAlerts = false,
  onClose,
  onFinalAcknowledgeClick,
  ownerId,
  showCloseIcon = true,
  skipAlertNavigation = false
}) {
  const {
    isAlertConfirmed,
    fieldAlerts,
    alerts
  } = (0, _useAlerts.default)(ownerId);
  const alertsToDisplay = displayAllAlerts ? alerts : fieldAlerts;
  const initialAlertIndex = alertsToDisplay.findIndex(alert => alert.key === alertKey);
  const [selectedIndex, setSelectedIndex] = (0, _react.useState)(initialAlertIndex === -1 ? 0 : initialAlertIndex);

  // If the selected alert is not found, default to the first alert
  const selectedAlert = alertsToDisplay[selectedIndex] ?? alertsToDisplay[0];
  const hasUnconfirmedAlerts = alerts.some(alert => !isAlertConfirmed(alert.key) && alert.severity === _designSystem.Severity.Danger);
  const handleBackButtonClick = (0, _react.useCallback)(() => {
    setSelectedIndex(prevIndex => prevIndex > 0 ? prevIndex - 1 : prevIndex);
  }, []);
  const handleNextButtonClick = (0, _react.useCallback)(() => {
    setSelectedIndex(prevIndex => prevIndex + 1);
  }, []);
  const handleAcknowledgeClick = (0, _react.useCallback)(() => {
    if (skipAlertNavigation) {
      onFinalAcknowledgeClick();
      return;
    }
    if (selectedIndex + 1 === alertsToDisplay.length) {
      if (!hasUnconfirmedAlerts) {
        onFinalAcknowledgeClick();
        return;
      }
      setSelectedIndex(0);
      return;
    }
    handleNextButtonClick();
  }, [onFinalAcknowledgeClick, handleNextButtonClick, selectedIndex, alertsToDisplay.length, hasUnconfirmedAlerts, skipAlertNavigation]);
  return /*#__PURE__*/_react.default.createElement(_alertModal.AlertModal, {
    ownerId: ownerId,
    onAcknowledgeClick: handleAcknowledgeClick,
    alertKey: selectedAlert === null || selectedAlert === void 0 ? void 0 : selectedAlert.key,
    onClose: onClose,
    headerStartAccessory: /*#__PURE__*/_react.default.createElement(PageNavigation, {
      alerts: alertsToDisplay,
      onBackButtonClick: handleBackButtonClick,
      onNextButtonClick: handleNextButtonClick,
      selectedIndex: selectedIndex
    }),
    showCloseIcon: showCloseIcon
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\alert-system\\multiple-alert-modal\\multiple-alert-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\alert-system\\utils.ts", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Calert-system%5Cutils.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBannerAlertSeverity = getBannerAlertSeverity;
exports.getHighestSeverity = getHighestSeverity;
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../component-library");
/**
 * Returns the highest severity from an array of alerts.
 *
 * @param alerts - An array of alerts.
 * @returns The highest  severity.
 */
function getHighestSeverity(alerts) {
  let highestSeverity = _designSystem.Severity.Info;
  alerts.forEach(alert => {
    if (alert.severity === _designSystem.Severity.Danger) {
      highestSeverity = _designSystem.Severity.Danger;
    } else if (alert.severity === _designSystem.Severity.Warning && highestSeverity !== _designSystem.Severity.Danger) {
      highestSeverity = _designSystem.Severity.Warning;
    }
  });
  return highestSeverity;
}

/**
 * Converts the severity of a banner alert to the corresponding BannerAlertSeverity.
 *
 * @param severity - The severity of the banner alert.
 * @returns The corresponding BannerAlertSeverity.
 */
function getBannerAlertSeverity(severity) {
  switch (severity) {
    case _designSystem.Severity.Danger:
      return _componentLibrary.BannerAlertSeverity.Danger;
    case _designSystem.Severity.Warning:
      return _componentLibrary.BannerAlertSeverity.Warning;
    default:
      return _componentLibrary.BannerAlertSeverity.Info;
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\alert-system\\utils.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\alerts\\alerts.js", {"../../../ducks/alerts/invalid-custom-network":"D:\\code\\v\\metamask-extension\\ui\\ducks\\alerts\\invalid-custom-network.js","./invalid-custom-network-alert":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\alerts\\invalid-custom-network-alert\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Calerts%5Calerts.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _invalidCustomNetwork = require("../../../ducks/alerts/invalid-custom-network");
var _invalidCustomNetworkAlert = _interopRequireDefault(require("./invalid-custom-network-alert"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const Alerts = ({
  history
}) => {
  const _invalidCustomNetworkAlertIsOpen = (0, _reactRedux.useSelector)(_invalidCustomNetwork.alertIsOpen);
  if (_invalidCustomNetworkAlertIsOpen) {
    return /*#__PURE__*/_react.default.createElement(_invalidCustomNetworkAlert.default, {
      history: history
    });
  }
  return null;
};
Alerts.propTypes = {
  history: _propTypes.default.object.isRequired
};
var _default = exports.default = Alerts;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\alerts\\alerts.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\alerts\\index.js", {"./alerts":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\alerts\\alerts.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Calerts%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _alerts.default;
  }
});
var _alerts = _interopRequireDefault(require("./alerts"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\alerts\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\alerts\\invalid-custom-network-alert\\index.js", {"./invalid-custom-network-alert":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\alerts\\invalid-custom-network-alert\\invalid-custom-network-alert.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Calerts%5Cinvalid-custom-network-alert%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _invalidCustomNetworkAlert.default;
  }
});
var _invalidCustomNetworkAlert = _interopRequireDefault(require("./invalid-custom-network-alert"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\alerts\\invalid-custom-network-alert\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\alerts\\invalid-custom-network-alert\\invalid-custom-network-alert.js", {"../../../../ducks/alerts":"D:\\code\\v\\metamask-extension\\ui\\ducks\\alerts\\index.js","../../../../ducks/alerts/invalid-custom-network":"D:\\code\\v\\metamask-extension\\ui\\ducks\\alerts\\invalid-custom-network.js","../../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../ui/popover":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\popover\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Calerts%5Cinvalid-custom-network-alert%5Cinvalid-custom-network-alert.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _alerts = require("../../../../ducks/alerts");
var _invalidCustomNetwork = require("../../../../ducks/alerts/invalid-custom-network");
var _popover = _interopRequireDefault(require("../../../ui/popover"));
var _componentLibrary = require("../../../component-library");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _routes = require("../../../../helpers/constants/routes");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const {
  ERROR,
  LOADING
} = _alerts.ALERT_STATE;
const InvalidCustomNetworkAlert = ({
  history
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const alertState = (0, _reactRedux.useSelector)(_invalidCustomNetwork.getAlertState);
  const networkName = (0, _reactRedux.useSelector)(_invalidCustomNetwork.getNetworkName);
  const onClose = () => dispatch((0, _invalidCustomNetwork.dismissAlert)());
  const footer = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, alertState === ERROR ? /*#__PURE__*/_react.default.createElement("div", {
    className: "invalid-custom-network-alert__error"
  }, t('failureMessage')) : null, /*#__PURE__*/_react.default.createElement("div", {
    className: "invalid-custom-network-alert__footer-row"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    disabled: alertState === LOADING,
    onClick: onClose,
    variant: _componentLibrary.ButtonVariant.Secondary,
    className: "invalid-custom-network-alert__footer-row-button"
  }, t('dismiss')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    disabled: alertState === LOADING,
    onClick: async () => {
      await onClose();
      history.push(_routes.NETWORKS_ROUTE);
    },
    variant: _componentLibrary.ButtonVariant.Primary,
    className: "invalid-custom-network-alert__footer-row-button"
  }, t('settings'))));
  return /*#__PURE__*/_react.default.createElement(_popover.default, {
    title: t('invalidCustomNetworkAlertTitle'),
    onClose: onClose,
    contentClassName: "invalid-custom-network-alert__content",
    footerClassName: "invalid-custom-network-alert__footer",
    footer: footer
  }, /*#__PURE__*/_react.default.createElement("p", null, t('invalidCustomNetworkAlertContent1', [networkName])), /*#__PURE__*/_react.default.createElement("p", null, t('invalidCustomNetworkAlertContent2')), /*#__PURE__*/_react.default.createElement("p", null, t('invalidCustomNetworkAlertContent3', [/*#__PURE__*/_react.default.createElement("span", {
    key: "invalidCustomNetworkAlertContentLink",
    className: "invalid-custom-network-alert__content-link",
    onClick: () => global.platform.openTab({
      url: 'https://chainid.network'
    })
  }, "chainId.network")])));
};
InvalidCustomNetworkAlert.propTypes = {
  history: _propTypes.default.object.isRequired
};
var _default = exports.default = InvalidCustomNetworkAlert;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\alerts\\invalid-custom-network-alert\\invalid-custom-network-alert.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\app-loading-spinner\\app-loading-spinner.js", {"../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../ui/spinner":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\spinner\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Capp-loading-spinner%5Capp-loading-spinner.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactRedux = require("react-redux");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _selectors = require("../../../selectors");
var _spinner = _interopRequireDefault(require("../../ui/spinner"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const AppLoadingSpinner = ({
  className
}) => {
  const appIsLoading = (0, _reactRedux.useSelector)(_selectors.getAppIsLoading);
  if (!appIsLoading) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: `${className} app-loading-spinner`,
    role: "alert",
    "aria-busy": "true"
  }, /*#__PURE__*/_react.default.createElement(_spinner.default, {
    className: "app-loading-spinner__inner"
  }));
};
AppLoadingSpinner.propTypes = {
  className: _propTypes.default.string
};
var _default = exports.default = AppLoadingSpinner;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\app-loading-spinner\\app-loading-spinner.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\app-loading-spinner\\index.js", {"./app-loading-spinner":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\app-loading-spinner\\app-loading-spinner.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Capp-loading-spinner%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _appLoadingSpinner.default;
  }
});
var _appLoadingSpinner = _interopRequireDefault(require("./app-loading-spinner"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\app-loading-spinner\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\account-group-balance-change\\account-group-balance-change.tsx", {"../../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/utils/number-utils":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\number-utils.ts","../../../../hooks/useFormatters":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useFormatters.ts","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../component-library/skeleton":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\skeleton\\index.ts","./useAccountGroupBalanceDisplay":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\account-group-balance-change\\useAccountGroupBalanceDisplay.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cassets%5Caccount-group-balance-change%5Caccount-group-balance-change.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountGroupBalanceChange = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _designSystem = require("../../../../helpers/constants/design-system");
var _useFormatters = require("../../../../hooks/useFormatters");
var _metamask = require("../../../../ducks/metamask/metamask");
var _selectors = require("../../../../selectors");
var _componentLibrary = require("../../../component-library");
var _numberUtils = require("../../../../helpers/utils/number-utils");
var _skeleton = require("../../../component-library/skeleton");
var _useAccountGroupBalanceDisplay = require("./useAccountGroupBalanceDisplay");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const balanceAmountSpanStyle = {
  whiteSpace: 'pre'
};
const AccountGroupBalanceChangeComponent = ({
  period,
  portfolioButton
}) => {
  const {
    privacyMode,
    color,
    amountChange,
    percentChange
  } = (0, _useAccountGroupBalanceDisplay.useAccountGroupBalanceDisplay)(period);
  const {
    formatCurrency,
    formatPercentWithMinThreshold
  } = (0, _useFormatters.useFormatters)();
  const currency = (0, _reactRedux.useSelector)(_metamask.getCurrentCurrency);
  const anyEnabledNetworksAreAvailable = (0, _reactRedux.useSelector)(_selectors.selectAnyEnabledNetworksAreAvailable);
  return /*#__PURE__*/_react.default.createElement(_skeleton.Skeleton, {
    isLoading: !anyEnabledNetworksAreAvailable && (0, _numberUtils.isZeroAmount)(amountChange)
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    gap: 1
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.SensitiveText, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: color,
    style: balanceAmountSpanStyle,
    "data-testid": "account-group-balance-change-value",
    isHidden: privacyMode,
    ellipsis: true,
    length: "10"
  }, formatCurrency(amountChange, currency, {
    signDisplay: 'always'
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.SensitiveText, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: color,
    "data-testid": "account-group-balance-change-percentage",
    isHidden: privacyMode,
    ellipsis: true,
    length: "10"
  }, `(${formatPercentWithMinThreshold(percentChange, {
    signDisplay: 'always'
  })})`)), portfolioButton());
};
const AccountGroupBalanceChange = props => {
  const isMultichainAccountsState2Enabled = (0, _reactRedux.useSelector)(_selectors.getIsMultichainAccountsState2Enabled);
  if (!isMultichainAccountsState2Enabled) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(AccountGroupBalanceChangeComponent, props);
};
exports.AccountGroupBalanceChange = AccountGroupBalanceChange;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\assets\\account-group-balance-change\\account-group-balance-change.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\account-group-balance-change\\get-display-balance.ts", {"../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cassets%5Caccount-group-balance-change%5Cget-display-balance.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isValidAmount = exports.determineBalanceColor = void 0;
var _designSystem = require("../../../../helpers/constants/design-system");
const isValidAmount = value => typeof value === 'number' && !Number.isNaN(value) && Number.isFinite(value);
exports.isValidAmount = isValidAmount;
const determineBalanceColor = (changeValue, privacyMode) => {
  if (privacyMode) {
    return _designSystem.TextColor.textAlternative;
  }
  const val = changeValue ?? 0;
  if (val > 0) {
    return _designSystem.TextColor.successDefault;
  }
  if (val < 0) {
    return _designSystem.TextColor.errorDefault;
  }
  return _designSystem.TextColor.textDefault;
};
exports.determineBalanceColor = determineBalanceColor;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\assets\\account-group-balance-change\\get-display-balance.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\account-group-balance-change\\useAccountGroupBalanceDisplay.ts", {"../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../selectors/assets":"D:\\code\\v\\metamask-extension\\ui\\selectors\\assets.ts","./get-display-balance":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\account-group-balance-change\\get-display-balance.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cassets%5Caccount-group-balance-change%5CuseAccountGroupBalanceDisplay.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAccountGroupBalanceDisplay = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _selectors = require("../../../../selectors");
var _assets = require("../../../../selectors/assets");
var _getDisplayBalance = require("./get-display-balance");
const useAccountGroupBalanceDisplay = period => {
  const privacyMode = (0, _reactRedux.useSelector)(_selectors.getPrivacyMode);

  // Memoized selector for the specified period
  const changeSelector = (0, _react.useMemo)(() => (0, _assets.selectBalanceChangeBySelectedAccountGroup)(period), [period]);

  // Get the data
  const portfolioChange = (0, _reactRedux.useSelector)(changeSelector);
  const {
    amountChangeInUserCurrency,
    percentChange
  } = portfolioChange ?? {};
  const valueChange = [(0, _getDisplayBalance.isValidAmount)(amountChangeInUserCurrency) && amountChangeInUserCurrency, (0, _getDisplayBalance.isValidAmount)(percentChange) && percentChange].find(v => v !== false);
  const color = (0, _react.useMemo)(() => (0, _getDisplayBalance.determineBalanceColor)(valueChange, privacyMode), [valueChange, privacyMode]);
  return {
    privacyMode,
    color,
    amountChange: amountChangeInUserCurrency ?? 0,
    percentChange: (percentChange ?? 0) / 100,
    portfolioChange
  };
};
exports.useAccountGroupBalanceDisplay = useAccountGroupBalanceDisplay;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\assets\\account-group-balance-change\\useAccountGroupBalanceDisplay.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\account-group-balance\\account-group-balance.tsx", {"../../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/utils/number-utils":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\number-utils.ts","../../../../hooks/useFormatters":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useFormatters.ts","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../selectors/assets":"D:\\code\\v\\metamask-extension\\ui\\selectors\\assets.ts","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../component-library/skeleton":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\skeleton\\index.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cassets%5Caccount-group-balance%5Caccount-group-balance.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.AccountGroupBalance = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _classnames = _interopRequireDefault(require("classnames"));
var _assets = require("../../../../selectors/assets");
var _designSystem = require("../../../../helpers/constants/design-system");
var _componentLibrary = require("../../../component-library");
var _selectors = require("../../../../selectors");
var _useFormatters = require("../../../../hooks/useFormatters");
var _metamask = require("../../../../ducks/metamask/metamask");
var _skeleton = require("../../../component-library/skeleton");
var _numberUtils = require("../../../../helpers/utils/number-utils");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const AccountGroupBalance = ({
  classPrefix,
  balanceIsCached,
  handleSensitiveToggle
}) => {
  const {
    privacyMode
  } = (0, _reactRedux.useSelector)(_selectors.getPreferences);
  const {
    formatCurrency
  } = (0, _useFormatters.useFormatters)();
  const selectedGroupBalance = (0, _reactRedux.useSelector)(_assets.selectBalanceBySelectedAccountGroup);
  const fallbackCurrency = (0, _reactRedux.useSelector)(_metamask.getCurrentCurrency);
  const anyEnabledNetworksAreAvailable = (0, _reactRedux.useSelector)(_selectors.selectAnyEnabledNetworksAreAvailable);
  const total = selectedGroupBalance === null || selectedGroupBalance === void 0 ? void 0 : selectedGroupBalance.totalBalanceInUserCurrency;
  const currency = selectedGroupBalance ? selectedGroupBalance.userCurrency ?? fallbackCurrency : undefined;
  return /*#__PURE__*/_react.default.createElement(_skeleton.Skeleton, {
    isLoading: !anyEnabledNetworksAreAvailable && ((0, _numberUtils.isZeroAmount)(total) || currency === undefined),
    marginBottom: 1
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: (0, _classnames.default)(`${classPrefix}-overview__primary-balance`, {
      [`${classPrefix}-overview__cached-balance`]: balanceIsCached
    }),
    "data-testid": `${classPrefix}-overview__primary-currency`,
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    flexWrap: _designSystem.FlexWrap.Wrap
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.SensitiveText, {
    ellipsis: true,
    variant: _designSystem.TextVariant.inherit,
    isHidden: privacyMode,
    "data-testid": "account-value-and-suffix",
    onClick: handleSensitiveToggle,
    className: "cursor-pointer transition-colors duration-200 hover:text-text-alternative"
  }, total === undefined ? null : formatCurrency(total, currency))));
};
exports.AccountGroupBalance = AccountGroupBalance;
var _default = exports.default = AccountGroupBalance;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\assets\\account-group-balance\\account-group-balance.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\asset-list\\asset-list-control-bar\\asset-list-control-bar.tsx", {"../../../../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../../hooks/useNftsCollections":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useNftsCollections.js","../../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../../../../selectors/multichain/networks":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain\\networks.ts","../../../../../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","../../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../ui/tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\index.js","../import-control":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\asset-list\\import-control\\index.ts","../network-filter":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\asset-list\\network-filter\\index.ts","../sort-control/sort-control":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\asset-list\\sort-control\\sort-control.tsx","@metamask/multichain-network-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-network-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cassets%5Casset-list%5Casset-list-control-bar%5Casset-list-control-bar.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _utils = require("@metamask/utils");
var _multichainNetworkController = require("@metamask/multichain-network-controller");
var _selectors = require("../../../../../selectors");
var _networks = require("../../../../../selectors/multichain/networks");
var _networks2 = require("../../../../../../shared/modules/selectors/networks");
var _componentLibrary = require("../../../../component-library");
var _sortControl = _interopRequireWildcard(require("../sort-control/sort-control"));
var _designSystem = require("../../../../../helpers/constants/design-system");
var _importControl = _interopRequireDefault(require("../import-control"));
var _useI18nContext = require("../../../../../hooks/useI18nContext");
var _metametrics = require("../../../../../contexts/metametrics");
var _network = require("../../../../../../shared/constants/network");
var _metametrics2 = require("../../../../../../shared/constants/metametrics");
var _util = require("../../../../../../app/scripts/lib/util");
var _app = require("../../../../../../shared/constants/app");
var _networkFilter = _interopRequireDefault(require("../network-filter"));
var _actions = require("../../../../../store/actions");
var _tooltip = _interopRequireDefault(require("../../../../ui/tooltip"));
var _multichain = require("../../../../../selectors/multichain");
var _useNftsCollections = require("../../../../../hooks/useNftsCollections");
var _routes = require("../../../../../helpers/constants/routes");
var _selectors2 = require("../../../../../selectors/selectors");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

const AssetListControlBar = ({
  showTokensLinks,
  showTokenFiatBalance,
  showImportTokenButton = true,
  showSortControl = true
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const navigate = (0, _reactRouterDomV5Compat.useNavigate)();
  const popoverRef = (0, _react.useRef)(null);
  const useNftDetection = (0, _reactRedux.useSelector)(_selectors.getUseNftDetection);
  const currentMultichainNetwork = (0, _reactRedux.useSelector)(_multichain.getMultichainNetwork);
  const allNetworks = (0, _reactRedux.useSelector)(_networks2.getNetworkConfigurationsByChainId);
  const allCaipNetworks = (0, _reactRedux.useSelector)(_networks2.getAllNetworkConfigurationsByCaipChainId);
  const isTokenNetworkFilterEqualCurrentNetwork = (0, _reactRedux.useSelector)(_selectors.getIsTokenNetworkFilterEqualCurrentNetwork);
  const isMainnet = (0, _reactRedux.useSelector)(_selectors.getIsMainnet);
  const isLineaMainnet = (0, _reactRedux.useSelector)(_selectors.getIsLineaMainnet);
  const allChainIds = (0, _reactRedux.useSelector)(_selectors.getAllChainsToPoll);
  const {
    collections
  } = (0, _useNftsCollections.useNftsCollections)();
  const isMultichainAccountsState2Enabled = (0, _reactRedux.useSelector)(_selectors.getIsMultichainAccountsState2Enabled);
  const enabledNetworksByNamespace = (0, _reactRedux.useSelector)(_networks.getEnabledNetworksByNamespace);
  const allEnabledNetworksForAllNamespaces = (0, _reactRedux.useSelector)(_networks.getAllEnabledNetworksForAllNamespaces);
  const tokenNetworkFilter = (0, _reactRedux.useSelector)(_selectors.getTokenNetworkFilter);
  const [isTokenSortPopoverOpen, setIsTokenSortPopoverOpen] = (0, _react.useState)(false);
  const [isImportTokensPopoverOpen, setIsImportTokensPopoverOpen] = (0, _react.useState)(false);
  const [isNetworkFilterPopoverOpen, setIsNetworkFilterPopoverOpen] = (0, _react.useState)(false);
  const [isImportNftPopoverOpen, setIsImportNftPopoverOpen] = (0, _react.useState)(false);
  const currentMultichainChainId = (0, _reactRedux.useSelector)(_networks.getSelectedMultichainNetworkChainId);
  const {
    namespace
  } = (0, _utils.parseCaipChainId)(currentMultichainChainId);
  const allNetworkClientIds = (0, _react.useMemo)(() => {
    return Object.keys(tokenNetworkFilter).flatMap(chainId => {
      const entry = allNetworks[chainId];
      if (!entry) {
        return [];
      }
      const index = entry.defaultRpcEndpointIndex;
      const endpoint = entry.rpcEndpoints[index];
      return endpoint !== null && endpoint !== void 0 && endpoint.networkClientId ? [endpoint.networkClientId] : [];
    });
  }, [tokenNetworkFilter, allNetworks]);
  const networksToDisplay = (0, _react.useMemo)(() => {
    return _selectors2.isGlobalNetworkSelectorRemoved ? enabledNetworksByNamespace : tokenNetworkFilter;
  }, [tokenNetworkFilter, enabledNetworksByNamespace]);
  const shouldShowRefreshButtons = (0, _react.useMemo)(() => (isMainnet || isLineaMainnet || Object.keys(collections).length > 0) && useNftDetection, [isMainnet, isLineaMainnet, collections, useNftDetection]);
  const shouldShowEnableAutoDetect = (0, _react.useMemo)(() => !shouldShowRefreshButtons && !useNftDetection, [shouldShowRefreshButtons, useNftDetection]);
  const isTestNetwork = (0, _react.useMemo)(() => {
    return _network.TEST_CHAINS.includes(currentMultichainNetwork.network.chainId);
  }, [currentMultichainNetwork.network.chainId]);
  const allOpts = (0, _react.useMemo)(() => {
    const opts = {};
    Object.keys(allNetworks || {}).forEach(chainId => {
      opts[chainId] = true;
    });
    return opts;
  }, [allNetworks]);
  (0, _react.useEffect)(() => {
    if (isTestNetwork) {
      const testnetFilter = {
        [currentMultichainNetwork.network.chainId]: true
      };
      dispatch((0, _actions.setTokenNetworkFilter)(testnetFilter));
    }
  }, [isTestNetwork, currentMultichainNetwork.network.chainId, dispatch]);

  // TODO: This useEffect should be a migration
  // We need to set the default filter for all users to be all included networks, rather than defaulting to empty object
  // This effect is to unblock and derisk in the short-term
  (0, _react.useEffect)(() => {
    if (Object.keys(networksToDisplay).length === 0) {
      dispatch((0, _actions.setTokenNetworkFilter)(allOpts));
    } else {
      dispatch((0, _actions.setTokenNetworkFilter)({
        [currentMultichainNetwork.network.chainId]: true
      }));
    }
  }, [allOpts, currentMultichainNetwork.network.chainId, dispatch, networksToDisplay]);
  const windowType = (0, _util.getEnvironmentType)();
  const isFullScreen = windowType !== _app.ENVIRONMENT_TYPE_NOTIFICATION && windowType !== _app.ENVIRONMENT_TYPE_POPUP;
  const toggleTokenSortPopover = () => {
    setIsNetworkFilterPopoverOpen(false);
    setIsImportTokensPopoverOpen(false);
    setIsImportNftPopoverOpen(false);
    setIsTokenSortPopoverOpen(!isTokenSortPopoverOpen);
  };
  const toggleNetworkFilterPopover = () => {
    setIsTokenSortPopoverOpen(false);
    setIsImportTokensPopoverOpen(false);
    setIsImportNftPopoverOpen(false);
    setIsNetworkFilterPopoverOpen(!isNetworkFilterPopoverOpen);
  };
  const toggleImportTokensPopover = () => {
    setIsTokenSortPopoverOpen(false);
    setIsNetworkFilterPopoverOpen(false);
    setIsImportNftPopoverOpen(false);
    setIsImportTokensPopoverOpen(!isImportTokensPopoverOpen);
  };
  const toggleImportNftPopover = () => {
    setIsTokenSortPopoverOpen(false);
    setIsNetworkFilterPopoverOpen(false);
    setIsImportTokensPopoverOpen(false);
    setIsImportNftPopoverOpen(!isImportNftPopoverOpen);
  };
  const closePopover = () => {
    setIsTokenSortPopoverOpen(false);
    setIsNetworkFilterPopoverOpen(false);
    setIsImportTokensPopoverOpen(false);
    setIsImportNftPopoverOpen(false);
  };
  const handleTokenImportModal = () => {
    dispatch((0, _actions.showImportTokensModal)());
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.Navigation,
      event: _metametrics2.MetaMetricsEventName.TokenImportButtonClicked,
      properties: {
        location: 'HOME'
      }
    });
    closePopover();
  };
  const handleNftImportModal = () => {
    dispatch((0, _actions.showImportNftsModal)({}));
    closePopover();
  };
  const handleRefresh = () => {
    dispatch((0, _actions.detectTokens)());
    closePopover();
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.Tokens,
      event: _metametrics2.MetaMetricsEventName.TokenListRefreshed
    });
  };
  const onEnableAutoDetect = () => {
    navigate(_routes.SECURITY_ROUTE);
  };
  const handleNetworkManager = (0, _react.useCallback)(() => {
    dispatch((0, _actions.showModal)({
      name: 'NETWORK_MANAGER'
    }));
  }, [dispatch]);
  const handleNftRefresh = () => {
    if (isMainnet || isLineaMainnet) {
      dispatch((0, _actions.detectNfts)(allChainIds));
    }
    // loop through allNetworkClientIds and call checkAndUpdateAllNftsOwnershipStatus for each one
    allNetworkClientIds.forEach(networkClientId => {
      (0, _actions.checkAndUpdateAllNftsOwnershipStatus)(networkClientId);
    });
  };
  const isDisabled = (0, _react.useMemo)(() => {
    const isPopularNetwork = _network.FEATURED_NETWORK_CHAIN_IDS.includes(currentMultichainNetwork.network.chainId);
    return !currentMultichainNetwork.isEvmNetwork || isTestNetwork || !isPopularNetwork;
  }, [currentMultichainNetwork, isTestNetwork]);
  const networkButtonText = (0, _react.useMemo)(() => {
    if (_selectors2.isGlobalNetworkSelectorRemoved && Object.keys(enabledNetworksByNamespace).length === 1) {
      var _allNetworks$chainId;
      const chainId = Object.keys(enabledNetworksByNamespace)[0];
      return (0, _utils.isStrictHexString)(chainId) ? ((_allNetworks$chainId = allNetworks[chainId]) === null || _allNetworks$chainId === void 0 ? void 0 : _allNetworks$chainId.name) ?? t('currentNetwork') : currentMultichainNetwork.network.nickname ?? t('currentNetwork');
    }
    if (_selectors2.isGlobalNetworkSelectorRemoved && namespace !== _utils.KnownCaipNamespace.Eip155 && Object.keys(enabledNetworksByNamespace).length > 1) {
      return currentMultichainNetwork.network.nickname ?? t('currentNetwork');
    }

    // > 1 network selected, show "all networks"
    if (_selectors2.isGlobalNetworkSelectorRemoved && Object.keys(enabledNetworksByNamespace).length > 1) {
      return t('allNetworks');
    }
    if (_selectors2.isGlobalNetworkSelectorRemoved && Object.keys(enabledNetworksByNamespace).length === 0) {
      return t('noNetworksSelected');
    }
    if (!_selectors2.isGlobalNetworkSelectorRemoved && isTokenNetworkFilterEqualCurrentNetwork || !_selectors2.isGlobalNetworkSelectorRemoved && !currentMultichainNetwork.isEvmNetwork) {
      return (currentMultichainNetwork === null || currentMultichainNetwork === void 0 ? void 0 : currentMultichainNetwork.nickname) ?? t('currentNetwork');
    }
    return t('popularNetworks');
  }, [enabledNetworksByNamespace, isTokenNetworkFilterEqualCurrentNetwork, currentMultichainNetwork.isEvmNetwork, currentMultichainNetwork.network.nickname, currentMultichainNetwork === null || currentMultichainNetwork === void 0 ? void 0 : currentMultichainNetwork.nickname, t, allNetworks, namespace]);
  const networkButtonTextEnabledAccountState2 = (0, _react.useMemo)(() => {
    if (_selectors2.isGlobalNetworkSelectorRemoved && Object.keys(allEnabledNetworksForAllNamespaces).length === 1) {
      var _allCaipNetworks$caip;
      const chainId = allEnabledNetworksForAllNamespaces[0];
      const caipChainId = (0, _utils.isStrictHexString)(chainId) ? (0, _multichainNetworkController.toEvmCaipChainId)(chainId) : chainId;
      return ((_allCaipNetworks$caip = allCaipNetworks[caipChainId]) === null || _allCaipNetworks$caip === void 0 ? void 0 : _allCaipNetworks$caip.name) ?? t('currentNetwork');
    }

    // > 1 network selected, show "all networks"
    if (_selectors2.isGlobalNetworkSelectorRemoved && allEnabledNetworksForAllNamespaces.length > 1) {
      return t('allPopularNetworks');
    }
    if (_selectors2.isGlobalNetworkSelectorRemoved && allEnabledNetworksForAllNamespaces.length === 0) {
      return t('noNetworksSelected');
    }
    if (!_selectors2.isGlobalNetworkSelectorRemoved && isTokenNetworkFilterEqualCurrentNetwork || !_selectors2.isGlobalNetworkSelectorRemoved && !currentMultichainNetwork.isEvmNetwork) {
      return (currentMultichainNetwork === null || currentMultichainNetwork === void 0 ? void 0 : currentMultichainNetwork.nickname) ?? t('currentNetwork');
    }
    return t('popularNetworks');
  }, [allEnabledNetworksForAllNamespaces, isTokenNetworkFilterEqualCurrentNetwork, currentMultichainNetwork.isEvmNetwork, currentMultichainNetwork === null || currentMultichainNetwork === void 0 ? void 0 : currentMultichainNetwork.nickname, t, allCaipNetworks]);
  const singleNetworkIconUrl = (0, _react.useMemo)(() => {
    if (!_selectors2.isGlobalNetworkSelectorRemoved) {
      return undefined;
    }
    const chainIds = allEnabledNetworksForAllNamespaces;
    if (chainIds.length !== 1) {
      return undefined;
    }
    const singleEnabledChainId = chainIds[0];
    return _network.CHAIN_ID_TO_NETWORK_IMAGE_URL_MAP[singleEnabledChainId];
  }, [allEnabledNetworksForAllNamespaces]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "asset-list-control-bar",
    marginLeft: 4,
    marginRight: 4,
    ref: popoverRef
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonBase, {
    "data-testid": "sort-by-networks",
    variant: _designSystem.TextVariant.bodySmMedium,
    className: "asset-list-control-bar__button asset-list-control-bar__network_control",
    onClick: _selectors2.isGlobalNetworkSelectorRemoved ? handleNetworkManager : toggleNetworkFilterPopover,
    disabled: _selectors2.isGlobalNetworkSelectorRemoved ? false : isDisabled,
    size: _componentLibrary.ButtonBaseSize.Sm,
    endIconName: _componentLibrary.IconName.ArrowDown,
    backgroundColor: isNetworkFilterPopoverOpen ? _designSystem.BackgroundColor.backgroundPressed : _designSystem.BackgroundColor.backgroundDefault,
    color: _designSystem.TextColor.textDefault,
    marginRight: isFullScreen ? 2 : null,
    borderColor: _designSystem.BorderColor.borderMuted,
    ellipsis: true
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    gap: 2
  }, singleNetworkIconUrl && /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
    name: currentMultichainNetwork.nickname,
    src: singleNetworkIconUrl,
    size: _componentLibrary.AvatarNetworkSize.Xs,
    borderWidth: 0
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySmMedium,
    ellipsis: true
  }, isMultichainAccountsState2Enabled ? networkButtonTextEnabledAccountState2 : networkButtonText))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "asset-list-control-bar__buttons",
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.flexEnd
  }, showSortControl && /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    title: t('sortBy'),
    position: "bottom",
    distance: 20
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonBase, {
    "data-testid": "sort-by-popover-toggle",
    className: "asset-list-control-bar__button",
    onClick: toggleTokenSortPopover,
    size: _componen