LavaPack.loadBundle([
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\cancel-speedup-popover\\cancel-speedup-popover.js", {"../../../../shared/constants/gas":"D:\\code\\v\\metamask-extension\\shared\\constants\\gas.ts","../../../contexts/gasFee":"D:\\code\\v\\metamask-extension\\ui\\contexts\\gasFee.js","../../../contexts/transaction-modal":"D:\\code\\v\\metamask-extension\\ui\\contexts\\transaction-modal.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/gas":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\gas.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../pages/confirmations/components/gas-details-item":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\gas-details-item\\index.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../component-library/modal-content/deprecated":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\modal-content\\deprecated\\index.ts","../../component-library/modal-header/deprecated":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\modal-header\\deprecated\\index.ts","../../ui/box":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\box\\index.js","../../ui/info-tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\info-tooltip\\index.js","../app-loading-spinner":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\app-loading-spinner\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Ccancel-speedup-popover%5Ccancel-speedup-popover.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactRedux = require("react-redux");
var _react = _interopRequireWildcard(require("react"));
var _gas = require("../../../../shared/constants/gas");
var _designSystem = require("../../../helpers/constants/design-system");
var _selectors = require("../../../selectors");
var _gas2 = require("../../../helpers/utils/gas");
var _gasFee = require("../../../contexts/gasFee");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _transactionModal = require("../../../contexts/transaction-modal");
var _gasDetailsItem = _interopRequireDefault(require("../../../pages/confirmations/components/gas-details-item"));
var _box = _interopRequireDefault(require("../../ui/box"));
var _infoTooltip = _interopRequireDefault(require("../../ui/info-tooltip"));
var _appLoadingSpinner = _interopRequireDefault(require("../app-loading-spinner"));
var _componentLibrary = require("../../component-library");
var _deprecated = require("../../component-library/modal-content/deprecated");
var _deprecated2 = require("../../component-library/modal-header/deprecated");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CancelSpeedupPopover = () => {
  const {
    cancelTransaction,
    editGasMode,
    gasFeeEstimates,
    speedUpTransaction,
    transaction,
    updateTransaction,
    updateTransactionToTenPercentIncreasedGasFee,
    updateTransactionUsingEstimate
  } = (0, _gasFee.useGasFeeContext)();
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    closeModal,
    currentModal
  } = (0, _transactionModal.useTransactionModalContext)();
  const appIsLoading = (0, _reactRedux.useSelector)(_selectors.getAppIsLoading);
  (0, _react.useEffect)(() => {
    if (transaction.previousGas || appIsLoading || currentModal !== 'cancelSpeedUpTransaction') {
      return;
    }
    // If gas used previously + 10% is less than medium estimated gas
    // estimate is set to medium, else estimate is set to tenPercentIncreased
    const gasUsedLessThanMedium = gasFeeEstimates && (0, _gas2.gasEstimateGreaterThanGasUsedPlusTenPercent)(transaction.txParams, gasFeeEstimates, _gas.PriorityLevels.medium);
    if (gasUsedLessThanMedium) {
      updateTransactionUsingEstimate(_gas.PriorityLevels.medium);
      return;
    }
    updateTransactionToTenPercentIncreasedGasFee(true);
  }, [appIsLoading, currentModal, editGasMode, gasFeeEstimates, transaction, updateTransaction, updateTransactionToTenPercentIncreasedGasFee, updateTransactionUsingEstimate]);
  if (currentModal !== 'cancelSpeedUpTransaction') {
    return null;
  }
  const submitTransactionChange = () => {
    if (editGasMode === _gas.EditGasModes.cancel) {
      cancelTransaction();
    } else {
      speedUpTransaction();
    }
    closeModal(['cancelSpeedUpTransaction']);
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: true,
    onClose: () => closeModal(['cancelSpeedUpTransaction']),
    className: "cancel-speedup-popover"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_deprecated.ModalContent, null, /*#__PURE__*/_react.default.createElement(_deprecated2.ModalHeader, {
    onClose: () => closeModal(['cancelSpeedUpTransaction']),
    marginBottom: 4
  }, editGasMode === _gas.EditGasModes.cancel ? `❌${t('cancel')}` : `🚀${t('speedUp')}`), /*#__PURE__*/_react.default.createElement(_appLoadingSpinner.default, {
    className: "cancel-speedup-popover__spinner"
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "cancel-speedup-popover__wrapper"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    alignItems: _designSystem.AlignItems.center,
    display: _designSystem.Display.Flex,
    variant: _designSystem.TextVariant.bodySm,
    marginBottom: 2,
    paddingBottom: 2,
    className: "cancel-speedup-popover__description"
  }, t('cancelSpeedUpLabel', [/*#__PURE__*/_react.default.createElement("strong", {
    key: "cancelSpeedupReplace"
  }, t('replace'))]), /*#__PURE__*/_react.default.createElement(_infoTooltip.default, {
    position: "top",
    contentText: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodySm
    }, t('cancelSpeedUpTransactionTooltip', [editGasMode === _gas.EditGasModes.cancel ? t('cancel') : t('speedUp')])), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
      variant: _designSystem.TextVariant.bodySm,
      href: "https://community.metamask.io/t/how-to-speed-up-or-cancel-transactions-on-metamask/3296",
      target: "_blank"
    }, t('learnMoreUpperCase')))
  })), /*#__PURE__*/_react.default.createElement(_box.default, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    flexDirection: _designSystem.FlexDirection.Column,
    marginTop: 2,
    paddingBottom: 4
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "cancel-speedup-popover__gas-details"
  }, /*#__PURE__*/_react.default.createElement(_gasDetailsItem.default, null))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    onClick: submitTransactionChange
  }, t('submit')))));
};
var _default = exports.default = CancelSpeedupPopover;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\cancel-speedup-popover\\cancel-speedup-popover.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\cancel-speedup-popover\\index.js", {"./cancel-speedup-popover":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\cancel-speedup-popover\\cancel-speedup-popover.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Ccancel-speedup-popover%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _cancelSpeedupPopover.default;
  }
});
var _cancelSpeedupPopover = _interopRequireDefault(require("./cancel-speedup-popover"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\cancel-speedup-popover\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\clear-metametrics-data\\clear-metametrics-data.tsx", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../ducks/app/app":"D:\\code\\v\\metamask-extension\\ui\\ducks\\app\\app.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cclear-metametrics-data%5Cclear-metametrics-data.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ClearMetaMetricsData;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _app = require("../../../ducks/app/app");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _actions = require("../../../store/actions");
var _metametrics = require("../../../contexts/metametrics");
var _metametrics2 = require("../../../../shared/constants/metametrics");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function ClearMetaMetricsData() {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const closeModal = () => {
    dispatch((0, _app.hideDeleteMetaMetricsDataModal)());
  };
  const deleteMetaMetricsData = async () => {
    try {
      await (0, _actions.createMetaMetricsDataDeletionTask)();
      trackEvent({
        category: _metametrics2.MetaMetricsEventCategory.Settings,
        event: _metametrics2.MetaMetricsEventName.MetricsDataDeletionRequest
      }, {
        excludeMetaMetricsId: true
      });
    } catch (error) {
      dispatch((0, _app.openDataDeletionErrorModal)());
      trackEvent({
        category: _metametrics2.MetaMetricsEventCategory.Settings,
        event: _metametrics2.MetaMetricsEventName.ErrorOccured
      }, {
        excludeMetaMetricsId: true
      });
    } finally {
      dispatch((0, _app.hideDeleteMetaMetricsDataModal)());
    }
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: true,
    onClose: closeModal
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, {
    modalDialogProps: {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onClose: closeModal
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingSm
  }, t('deleteMetaMetricsDataModalTitle')))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginLeft: 4,
    marginRight: 4,
    marginBottom: 3,
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySmMedium
  }, t('deleteMetaMetricsDataModalDesc'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalFooter, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    size: _componentLibrary.ButtonSize.Lg,
    width: _designSystem.BlockSize.Half,
    variant: _componentLibrary.ButtonVariant.Secondary,
    onClick: closeModal
  }, t('cancel')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    "data-testid": "clear-metametrics-data",
    size: _componentLibrary.ButtonSize.Lg,
    width: _designSystem.BlockSize.Half,
    variant: _componentLibrary.ButtonVariant.Primary
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    ,
    onClick: deleteMetaMetricsData,
    danger: true
  }, t('clear'))))));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\clear-metametrics-data\\clear-metametrics-data.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\clear-metametrics-data\\index.ts", {"./clear-metametrics-data":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\clear-metametrics-data\\clear-metametrics-data.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cclear-metametrics-data%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _clearMetametricsData.default;
  }
});
var _clearMetametricsData = _interopRequireDefault(require("./clear-metametrics-data"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\clear-metametrics-data\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\address.tsx", {"../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../modals/nickname-popovers":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\nickname-popovers\\index.js","../../../name/name":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\name\\name.tsx","../../../preferred-avatar":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\preferred-avatar\\index.ts","./hook":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\hook.ts","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","@metamask/name-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\name-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cconfirm%5Cinfo%5Crow%5Caddress.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmInfoRowAddress = void 0;
var _nameController = require("@metamask/name-controller");
var _react = _interopRequireWildcard(require("react"));
var _designSystemReact = require("@metamask/design-system-react");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _componentLibrary = require("../../../../component-library");
var _nicknamePopovers = _interopRequireDefault(require("../../../modals/nickname-popovers"));
var _name = _interopRequireDefault(require("../../../name/name"));
var _util = require("../../../../../helpers/utils/util");
var _preferredAvatar = require("../../../preferred-avatar");
var _hook = require("./hook");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConfirmInfoRowAddress = exports.ConfirmInfoRowAddress = /*#__PURE__*/(0, _react.memo)(({
  address,
  chainId,
  isSnapUsingThis
}) => {
  const {
    displayName,
    hexAddress
  } = (0, _hook.useFallbackDisplayName)(address);
  const [isNicknamePopoverShown, setIsNicknamePopoverShown] = (0, _react.useState)(false);
  const handleDisplayNameClick = () => setIsNicknamePopoverShown(true);
  const onCloseHandler = () => setIsNicknamePopoverShown(false);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    alignItems: _designSystem.AlignItems.center
  },
  // PetNames on this component are disabled for snaps until the `<Name />`
  // component can support variations. See this comment for context: //
  // https://github.com/MetaMask/metamask-extension/pull/23487#discussion_r1525055546
  isSnapUsingThis ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    alignItems: _designSystem.AlignItems.center,
    onClick: isSnapUsingThis ? () => null : handleDisplayNameClick
  }, /*#__PURE__*/_react.default.createElement(_preferredAvatar.PreferredAvatar, {
    address: address,
    size: _designSystemReact.AvatarAccountSize.Xs
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    marginLeft: 2,
    color: _designSystem.TextColor.inherit,
    "data-testid": "confirm-info-row-display-name"
  }, isSnapUsingThis ? (0, _util.shortenAddress)(address) : displayName)), isNicknamePopoverShown ? /*#__PURE__*/_react.default.createElement(_nicknamePopovers.default, {
    onClose: onCloseHandler,
    address: hexAddress
  }) : null) : /*#__PURE__*/_react.default.createElement(_name.default, {
    value: hexAddress,
    type: _nameController.NameType.ETHEREUM_ADDRESS,
    preferContractSymbol: true,
    variation: chainId
  }));
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\confirm\\info\\row\\address.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\alert-row\\alert-row.tsx", {"../../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../../hooks/useAlerts":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAlerts.ts","../../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../../component-library/skeleton":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\skeleton\\index.ts","../../../../alert-system/contexts/alertMetricsContext":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\alert-system\\contexts\\alertMetricsContext.tsx","../../../../alert-system/inline-alert/inline-alert":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\alert-system\\inline-alert\\inline-alert.tsx","../../../../alert-system/multiple-alert-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\alert-system\\multiple-alert-modal\\index.tsx","../row":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\row.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cconfirm%5Cinfo%5Crow%5Calert-row%5Calert-row.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmInfoAlertRow = void 0;
exports.getAlertTextColors = getAlertTextColors;
var _react = _interopRequireWildcard(require("react"));
var _designSystem = require("../../../../../../helpers/constants/design-system");
var _useAlerts = _interopRequireDefault(require("../../../../../../hooks/useAlerts"));
var _componentLibrary = require("../../../../../component-library");
var _alertMetricsContext = require("../../../../alert-system/contexts/alertMetricsContext");
var _inlineAlert = _interopRequireDefault(require("../../../../alert-system/inline-alert/inline-alert"));
var _multipleAlertModal = require("../../../../alert-system/multiple-alert-modal");
var _row = require("../row");
var _skeleton = require("../../../../../component-library/skeleton");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function getAlertTextColors(variant) {
  switch (variant) {
    case _row.ConfirmInfoRowVariant.Critical:
    case _designSystem.Severity.Danger:
      return _designSystem.TextColor.errorDefault;
    case _row.ConfirmInfoRowVariant.Warning:
    case _designSystem.Severity.Warning:
      return _designSystem.TextColor.warningDefault;
    case _row.ConfirmInfoRowVariant.Default:
    default:
      return _designSystem.TextColor.textDefault;
  }
}
const ConfirmInfoAlertRow = ({
  alertKey,
  ownerId,
  variant,
  isShownWithAlertsOnly = false,
  showAlertLoader = false,
  ...rowProperties
}) => {
  var _fieldAlerts$, _fieldAlerts$2, _fieldAlerts$3, _fieldAlerts$4, _fieldAlerts$5;
  const {
    trackInlineAlertClicked
  } = (0, _alertMetricsContext.useAlertMetrics)();
  const {
    getFieldAlerts
  } = (0, _useAlerts.default)(ownerId);
  const fieldAlerts = getFieldAlerts(alertKey);
  const hasFieldAlert = fieldAlerts.length > 0;
  const selectedAlertSeverity = (_fieldAlerts$ = fieldAlerts[0]) === null || _fieldAlerts$ === void 0 ? void 0 : _fieldAlerts$.severity;
  const selectedAlertKey = (_fieldAlerts$2 = fieldAlerts[0]) === null || _fieldAlerts$2 === void 0 ? void 0 : _fieldAlerts$2.key;
  const selectedAlertShowArrow = (_fieldAlerts$3 = fieldAlerts[0]) === null || _fieldAlerts$3 === void 0 ? void 0 : _fieldAlerts$3.showArrow;
  const selectedAlertInlineAlertText = (_fieldAlerts$4 = fieldAlerts[0]) === null || _fieldAlerts$4 === void 0 ? void 0 : _fieldAlerts$4.inlineAlertText;
  const selectedAlertIsOpenModalOnClick = ((_fieldAlerts$5 = fieldAlerts[0]) === null || _fieldAlerts$5 === void 0 ? void 0 : _fieldAlerts$5.isOpenModalOnClick) ?? true;
  const [alertModalVisible, setAlertModalVisible] = (0, _react.useState)(false);
  const handleModalClose = () => {
    setAlertModalVisible(false);
  };
  const handleInlineAlertClick = () => {
    setAlertModalVisible(true);
    trackInlineAlertClicked(selectedAlertKey);
  };
  const onClickHandler = hasFieldAlert && selectedAlertIsOpenModalOnClick ? handleInlineAlertClick : undefined;
  const confirmInfoRowProps = {
    ...rowProperties,
    style: {
      background: 'transparent',
      ...rowProperties.style
    },
    color: getAlertTextColors(variant ?? selectedAlertSeverity),
    variant,
    onClick: onClickHandler,
    labelChildrenStyleOverride: rowProperties.labelChildren ? {
      justifyContent: _designSystem.JustifyContent.center
    } : {}
  };
  if (isShownWithAlertsOnly && !hasFieldAlert) {
    return null;
  }
  const inlineAlertLoader = showAlertLoader ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginLeft: 1,
    className: "flex-grow justify-items-end"
  }, /*#__PURE__*/_react.default.createElement(_skeleton.Skeleton, {
    width: "50%",
    height: 26
  })) : null;
  const inlineAlert = hasFieldAlert ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginLeft: 1
  }, /*#__PURE__*/_react.default.createElement(_inlineAlert.default, {
    severity: selectedAlertSeverity,
    showArrow: selectedAlertShowArrow,
    textOverride: selectedAlertInlineAlertText,
    onClick: onClickHandler
  })) : inlineAlertLoader;
  let confirmInfoRow;
  if (confirmInfoRowProps.labelChildren) {
    confirmInfoRow = /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRow, _extends({}, rowProperties, {
      labelChildren: rowProperties.labelChildren
    }), inlineAlert);
  } else {
    confirmInfoRow = /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRow, _extends({}, confirmInfoRowProps, {
      labelChildren: inlineAlert
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, alertModalVisible && /*#__PURE__*/_react.default.createElement(_multipleAlertModal.MultipleAlertModal, {
    alertKey: selectedAlertKey,
    ownerId: ownerId,
    onFinalAcknowledgeClick: handleModalClose,
    onClose: handleModalClose,
    showCloseIcon: false,
    skipAlertNavigation: true
  }), confirmInfoRow);
};
exports.ConfirmInfoAlertRow = ConfirmInfoAlertRow;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\confirm\\info\\row\\alert-row\\alert-row.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\constants.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cconfirm%5Cinfo%5Crow%5Cconstants.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TEST_ADDRESS = exports.RowAlertKey = exports.AlertActionKey = void 0;
const TEST_ADDRESS = exports.TEST_ADDRESS = '0x5CfE73b6021E818B776b421B1c4Db2474086a7e1';
let RowAlertKey = exports.RowAlertKey = /*#__PURE__*/function (RowAlertKey) {
  RowAlertKey["AccountTypeUpgrade"] = "accountTypeUpgrade";
  RowAlertKey["EstimatedChangesStatic"] = "estimatedChangesStatic";
  RowAlertKey["EstimatedFee"] = "estimatedFee";
  RowAlertKey["IncomingTokens"] = "incomingTokens";
  RowAlertKey["InteractingWith"] = "interactingWith";
  RowAlertKey["Network"] = "network";
  RowAlertKey["RequestFrom"] = "requestFrom";
  RowAlertKey["Resimulation"] = "resimulation";
  RowAlertKey["ShieldFooterCoverageIndicator"] = "shieldFooterCoverageIndicator";
  RowAlertKey["SigningInWith"] = "signingInWith";
  RowAlertKey["Speed"] = "speed";
  return RowAlertKey;
}({});
let AlertActionKey = exports.AlertActionKey = /*#__PURE__*/function (AlertActionKey) {
  AlertActionKey["Buy"] = "buy";
  AlertActionKey["ShowAdvancedGasFeeModal"] = "showAdvancedGasModal";
  AlertActionKey["ShowGasFeeModal"] = "showGasFeeModal";
  AlertActionKey["ShowPendingConfirmation"] = "showPendingConfirmation";
  return AlertActionKey;
}({});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\confirm\\info\\row\\constants.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\copy-icon.tsx", {"../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../hooks/useCopyToClipboard":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useCopyToClipboard.js","../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cconfirm%5Cinfo%5Crow%5Ccopy-icon.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CopyIcon = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useCopyToClipboard = require("../../../../../hooks/useCopyToClipboard");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _componentLibrary = require("../../../../component-library");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CopyIcon = ({
  copyText,
  color,
  style = {}
}) => {
  const [copied, handleCopy] = (0, _useCopyToClipboard.useCopyToClipboard)();
  const handleClick = (0, _react.useCallback)(async () => {
    handleCopy(copyText);
  }, [copyText]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    color: color ?? _designSystem.IconColor.iconAlternative,
    iconName: copied ? _componentLibrary.IconName.CopySuccess : _componentLibrary.IconName.Copy,
    size: _componentLibrary.ButtonIconSize.Sm,
    style: {
      cursor: 'pointer',
      position: 'absolute',
      right: 0,
      top: 2,
      ...style
    }
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    ,
    onClick: handleClick,
    ariaLabel: "copy-button"
  });
};
exports.CopyIcon = CopyIcon;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\confirm\\info\\row\\copy-icon.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\currency.tsx", {"../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../ui/currency-display/currency-display.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\currency-display\\currency-display.component.js","../../../user-preferenced-currency-display/user-preferenced-currency-display.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\user-preferenced-currency-display\\user-preferenced-currency-display.component.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cconfirm%5Cinfo%5Crow%5Ccurrency.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmInfoRowCurrency = void 0;
var _react = _interopRequireDefault(require("react"));
var _designSystem = require("../../../../../helpers/constants/design-system");
var _componentLibrary = require("../../../../component-library");
var _userPreferencedCurrencyDisplay = _interopRequireDefault(require("../../../user-preferenced-currency-display/user-preferenced-currency-display.component"));
var _currencyDisplay = _interopRequireDefault(require("../../../../ui/currency-display/currency-display.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// todo: the component currently takes care of displaying value in the currency passed
// it will default to using User's preferred currency.
// As we encounter different use cases in future we would need to extend this
// to support more configurations / formatting options.
const ConfirmInfoRowCurrency = ({
  value,
  currency,
  'data-testid': dataTestId
}) => /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
  display: _designSystem.Display.Flex,
  alignItems: _designSystem.AlignItems.center,
  flexWrap: _designSystem.FlexWrap.Wrap,
  style: {
    columnGap: '8px',
    fontSize: 'var(--font-size-3)'
  },
  "data-testid": dataTestId
}, currency ? /*#__PURE__*/_react.default.createElement(_currencyDisplay.default, {
  currency: currency,
  value: `${value}`
}) : /*#__PURE__*/_react.default.createElement(_userPreferencedCurrencyDisplay.default, {
  showNative: true,
  value: `${value}`
}));
exports.ConfirmInfoRowCurrency = ConfirmInfoRowCurrency;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\confirm\\info\\row\\currency.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\date.tsx", {"../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cconfirm%5Cinfo%5Crow%5Cdate.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmInfoRowDate = void 0;
var _react = _interopRequireDefault(require("react"));
var _designSystem = require("../../../../../helpers/constants/design-system");
var _util = require("../../../../../helpers/utils/util");
var _componentLibrary = require("../../../../component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const ConfirmInfoRowDate = ({
  unixTimestamp
}) => /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
  display: _designSystem.Display.Flex,
  alignItems: _designSystem.AlignItems.center,
  flexWrap: _designSystem.FlexWrap.Wrap,
  gap: 2
}, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
  color: _designSystem.TextColor.inherit,
  style: {
    whiteSpace: 'pre-wrap'
  }
}, (0, _util.formatUTCDateFromUnixTimestamp)(unixTimestamp)));
exports.ConfirmInfoRowDate = ConfirmInfoRowDate;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\confirm\\info\\row\\date.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\divider.tsx", {"react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cconfirm%5Cinfo%5Crow%5Cdivider.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmInfoRowDivider = void 0;
var _react = _interopRequireDefault(require("react"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const ConfirmInfoRowDivider = () => {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      paddingTop: '8px',
      paddingBottom: '8px'
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height: '1px',
      backgroundColor: 'var(--color-border-muted)',
      // Ignore the padding from the section.
      marginLeft: '-8px',
      marginRight: '-8px'
    }
  }));
};
exports.ConfirmInfoRowDivider = ConfirmInfoRowDivider;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\confirm\\info\\row\\divider.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\expandable-row.tsx", {"../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","./row":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\row.tsx","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cconfirm%5Cinfo%5Crow%5Cexpandable-row.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmInfoExpandableRow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _componentLibrary = require("../../../../component-library");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _row = require("./row");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConfirmInfoExpandableRow = props => {
  var _ref$current;
  const {
    content,
    children,
    startExpanded,
    ...rowProps
  } = props;
  const ref = (0, _react.useRef)();
  const [expanded, setExpanded] = (0, _react.useState)(Boolean(startExpanded));
  const [, setLoaded] = (0, _react.useState)(false);
  const handleClick = (0, _react.useCallback)(() => {
    setExpanded(!expanded);
  }, [expanded]);

  // Required to force a re-render so the content height can be calculated.
  (0, _react.useEffect)(() => {
    setLoaded(true);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRow, rowProps, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    marginLeft: 1,
    className: (0, _classnames.default)({
      expandIcon: true,
      expanded
    }),
    iconName: _componentLibrary.IconName.ArrowDown,
    color: _designSystem.IconColor.primaryDefault,
    size: _componentLibrary.ButtonIconSize.Sm,
    onClick: handleClick,
    ariaLabel: "expand"
  }), children)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    ref: ref,
    className: "expandable",
    style: {
      height: expanded ? (_ref$current = ref.current) === null || _ref$current === void 0 ? void 0 : _ref$current.scrollHeight : '0px'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    style: {
      marginTop: '-8px'
    }
  }, content)));
};
exports.ConfirmInfoExpandableRow = ConfirmInfoExpandableRow;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\confirm\\info\\row\\expandable-row.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\hook.ts", {"../../../../../../shared/modules/hexstring-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\hexstring-utils.ts","../../../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","./row":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\row.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cconfirm%5Cinfo%5Crow%5Chook.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRowContext = exports.useFallbackDisplayName = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _hexstringUtils = require("../../../../../../shared/modules/hexstring-utils");
var _util = require("../../../../../helpers/utils/util");
var _selectors = require("../../../../../selectors");
var _accountTree = require("../../../../../selectors/multichain-accounts/account-tree");
var _row = require("./row");
const useRowContext = () => (0, _react.useContext)(_row.ConfirmInfoRowContext);
exports.useRowContext = useRowContext;
const useFallbackDisplayName = function (address) {
  var _accountGroup$metadat;
  const hexAddress = (0, _hexstringUtils.toChecksumHexAddress)(address);
  const isMultichainAccountsState2Enabled = (0, _reactRedux.useSelector)(_selectors.getIsMultichainAccountsState2Enabled);
  const accountGroups = (0, _reactRedux.useSelector)(state => (0, _accountTree.getAccountGroupsByAddress)(state, [hexAddress]));
  const accountGroup = Array.isArray(accountGroups) ? accountGroups[0] : undefined;
  const internalAccounts = (0, _reactRedux.useSelector)(_selectors.getInternalAccounts);
  const accountName = isMultichainAccountsState2Enabled ? accountGroup === null || accountGroup === void 0 || (_accountGroup$metadat = accountGroup.metadata) === null || _accountGroup$metadat === void 0 ? void 0 : _accountGroup$metadat.name : (0, _selectors.getAccountName)(internalAccounts, hexAddress);
  const addressBookContact = (0, _reactRedux.useSelector)(state => (0, _selectors.getAddressBookEntry)(state, hexAddress));
  const addressBookContactName = addressBookContact === null || addressBookContact === void 0 ? void 0 : addressBookContact.name;
  const metadataName = (0, _reactRedux.useSelector)(state => (0, _selectors.getMetadataContractName)(state, hexAddress));
  const ensName = (0, _reactRedux.useSelector)(state => (0, _selectors.getEnsResolutionByAddress)(state, address));
  const displayName = accountName || addressBookContactName || metadataName || ensName || (0, _util.shortenAddress)(hexAddress);
  return {
    displayName,
    hexAddress
  };
};
exports.useFallbackDisplayName = useFallbackDisplayName;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\confirm\\info\\row\\hook.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\index.ts", {"./address":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\address.tsx","./date":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\date.tsx","./divider":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\divider.tsx","./row":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\row.tsx","./text":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\text.tsx","./text-token-units":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\text-token-units.tsx","./url":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\url.tsx","./value-double":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\value-double.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cconfirm%5Cinfo%5Crow%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _address = require("./address");
Object.keys(_address).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _address[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _address[key];
    }
  });
});
var _date = require("./date");
Object.keys(_date).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _date[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _date[key];
    }
  });
});
var _divider = require("./divider");
Object.keys(_divider).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _divider[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _divider[key];
    }
  });
});
var _row = require("./row");
Object.keys(_row).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _row[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _row[key];
    }
  });
});
var _text = require("./text");
Object.keys(_text).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _text[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _text[key];
    }
  });
});
var _textTokenUnits = require("./text-token-units");
Object.keys(_textTokenUnits).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _textTokenUnits[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _textTokenUnits[key];
    }
  });
});
var _url = require("./url");
Object.keys(_url).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _url[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _url[key];
    }
  });
});
var _valueDouble = require("./value-double");
Object.keys(_valueDouble).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _valueDouble[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _valueDouble[key];
    }
  });
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\confirm\\info\\row\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\row.tsx", {"../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../ui/tooltip/tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\tooltip.js","./copy-icon":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\copy-icon.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cconfirm%5Cinfo%5Crow%5Crow.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmInfoRowVariant = exports.ConfirmInfoRowContext = exports.ConfirmInfoRow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _tooltip = _interopRequireDefault(require("../../../../ui/tooltip/tooltip"));
var _componentLibrary = require("../../../../component-library");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _copyIcon = require("./copy-icon");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
let ConfirmInfoRowVariant = exports.ConfirmInfoRowVariant = /*#__PURE__*/function (ConfirmInfoRowVariant) {
  ConfirmInfoRowVariant["Default"] = "default";
  ConfirmInfoRowVariant["Critical"] = "critical";
  ConfirmInfoRowVariant["Warning"] = "warning";
  return ConfirmInfoRowVariant;
}({});
const BACKGROUND_COLORS = {
  [ConfirmInfoRowVariant.Default]: undefined,
  [ConfirmInfoRowVariant.Critical]: _designSystem.BackgroundColor.errorMuted,
  [ConfirmInfoRowVariant.Warning]: _designSystem.BackgroundColor.warningMuted
};
const TEXT_COLORS = {
  [ConfirmInfoRowVariant.Default]: _designSystem.TextColor.textDefault,
  [ConfirmInfoRowVariant.Critical]: _designSystem.Color.errorAlternative,
  [ConfirmInfoRowVariant.Warning]: _designSystem.Color.warningDefault
};
const TOOLTIP_ICONS = {
  [ConfirmInfoRowVariant.Default]: _componentLibrary.IconName.Question,
  [ConfirmInfoRowVariant.Critical]: _componentLibrary.IconName.Warning,
  [ConfirmInfoRowVariant.Warning]: _componentLibrary.IconName.Warning
};
const TOOLTIP_ICON_COLORS = {
  [ConfirmInfoRowVariant.Default]: _designSystem.Color.iconAlternative,
  [ConfirmInfoRowVariant.Critical]: _designSystem.Color.errorAlternative,
  [ConfirmInfoRowVariant.Warning]: _designSystem.Color.warningDefault
};
const ConfirmInfoRowContext = exports.ConfirmInfoRowContext = /*#__PURE__*/(0, _react.createContext)({
  variant: ConfirmInfoRowVariant.Default
});
const ConfirmInfoRow = ({
  label,
  children,
  variant = ConfirmInfoRowVariant.Default,
  tooltip,
  style,
  labelChildren,
  color,
  copyEnabled = false,
  copyText,
  'data-testid': dataTestId,
  collapsed,
  tooltipIcon,
  tooltipIconColor,
  onClick,
  labelChildrenStyleOverride
}) => {
  const [expanded, setExpanded] = (0, _react.useState)(!collapsed);
  const isCollapsible = collapsed !== undefined;
  const contentPaddingRight = (copyEnabled ? 6 : 0) + (isCollapsible ? 6 : 0);
  return /*#__PURE__*/_react.default.createElement(ConfirmInfoRowContext.Provider, {
    value: {
      variant
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    "data-testid": dataTestId,
    className: "confirm-info-row",
    display: _designSystem.Display.Flex,
    flexDirection: isCollapsible ? _designSystem.FlexDirection.Column : _designSystem.FlexDirection.Row,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    flexWrap: _designSystem.FlexWrap.Wrap,
    alignItems: _designSystem.AlignItems.flexStart,
    backgroundColor: BACKGROUND_COLORS[variant],
    borderRadius: _designSystem.BorderRadius.LG,
    marginTop: 2,
    marginBottom: 2,
    paddingLeft: 2,
    paddingRight: 2,
    color: TEXT_COLORS[variant],
    style: {
      overflowWrap: _designSystem.OverflowWrap.Anywhere,
      minHeight: '24px',
      position: 'relative',
      ...style
    }
  }, copyEnabled && /*#__PURE__*/_react.default.createElement(_copyIcon.CopyIcon, {
    copyText: copyText ?? '',
    style: {
      right: isCollapsible ? 32 : 4
    },
    color: _designSystem.IconColor.iconAlternative
  }), isCollapsible && /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    color: _designSystem.IconColor.iconAlternative,
    iconName: expanded ? _componentLibrary.IconName.Collapse : _componentLibrary.IconName.Expand,
    size: _componentLibrary.ButtonIconSize.Sm,
    style: {
      cursor: 'pointer',
      position: 'absolute',
      right: 8
    },
    onClick: () => setExpanded(!expanded),
    "data-testid": "sectionCollapseButton",
    ariaLabel: "collapse-button"
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.flexStart,
    color: color,
    paddingRight: contentPaddingRight || null,
    onClick: onClick,
    className: onClick && 'hoverable'
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    style: labelChildrenStyleOverride
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: _designSystem.TextColor.inherit
  }, label), labelChildren, !labelChildren && (tooltip === null || tooltip === void 0 ? void 0 : tooltip.length) && /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    position: "bottom",
    title: tooltip,
    style: {
      display: 'flex'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, _extends({
    name: tooltipIcon ?? TOOLTIP_ICONS[variant],
    marginLeft: 1,
    color: tooltipIconColor ?? TOOLTIP_ICON_COLORS[variant],
    size: _componentLibrary.IconSize.Sm
  }, dataTestId ? {
    'data-testid': `${dataTestId}-tooltip`
  } : {}))))), expanded && children && (typeof children === 'string' ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    marginRight: copyEnabled ? 3 : 0,
    color: _designSystem.TextColor.inherit
  }, children) : children)));
};
exports.ConfirmInfoRow = ConfirmInfoRow;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\confirm\\info\\row\\row.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\section.tsx", {"../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cconfirm%5Cinfo%5Crow%5Csection.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmInfoSection = void 0;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../../../component-library");
var _designSystem = require("../../../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const ConfirmInfoSection = ({
  children,
  noPadding,
  style = {},
  'data-testid': dataTestId
}) => {
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    "data-testid": dataTestId,
    backgroundColor: _designSystem.BackgroundColor.backgroundSection,
    borderRadius: _designSystem.BorderRadius.LG,
    paddingInline: noPadding ? 0 : 2,
    paddingTop: noPadding ? 0 : 1,
    paddingBottom: noPadding ? 0 : 1,
    marginBottom: 4,
    style: style
  }, children);
};
exports.ConfirmInfoSection = ConfirmInfoSection;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\confirm\\info\\row\\section.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\text-token-units.tsx", {"../../../../../../shared/lib/transactions-controller-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\transactions-controller-utils.js","../../../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../../../pages/confirmations/components/simulation-details/formatAmount":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\simulation-details\\formatAmount.ts","./text":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\text.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cconfirm%5Cinfo%5Crow%5Ctext-token-units.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmInfoRowTextTokenUnits = void 0;
var _react = _interopRequireDefault(require("react"));
var _transactionsControllerUtils = require("../../../../../../shared/lib/transactions-controller-utils");
var _formatAmount = require("../../../../../pages/confirmations/components/simulation-details/formatAmount");
var _util = require("../../../../../helpers/utils/util");
var _text = require("./text");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const ConfirmInfoRowTextTokenUnits = ({
  value,
  decimals
}) => {
  const tokenValue = (0, _transactionsControllerUtils.calcTokenAmount)(value, decimals);
  const tokenText = (0, _formatAmount.formatAmount)('en-US', tokenValue);
  const tokenTextMaxPrecision = (0, _formatAmount.formatAmountMaxPrecision)('en-US', tokenValue);
  return /*#__PURE__*/_react.default.createElement(_text.ConfirmInfoRowText, {
    text: (0, _util.shortenString)(tokenText, {
      truncatedCharLimit: 15,
      truncatedStartChars: 15,
      truncatedEndChars: 0,
      skipCharacterInEnd: true
    }),
    tooltip: tokenTextMaxPrecision
  });
};
exports.ConfirmInfoRowTextTokenUnits = ConfirmInfoRowTextTokenUnits;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\confirm\\info\\row\\text-token-units.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\text.tsx", {"../../../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../ui/tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cconfirm%5Cinfo%5Crow%5Ctext.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmInfoRowText = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("../../../../../contexts/i18n");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _componentLibrary = require("../../../../component-library");
var _tooltip = _interopRequireDefault(require("../../../../ui/tooltip"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const InfoText = ({
  text
}) => /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
  color: _designSystem.TextColor.inherit,
  style: {
    whiteSpace: 'pre-wrap'
  }
}, text);
const ConfirmInfoRowText = ({
  text,
  onEditClick,
  editIconClassName,
  tooltip,
  'data-testid': dataTestId,
  editIconDataTestId
}) => {
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const isEditable = Boolean(onEditClick);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    "data-testid": dataTestId,
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    flexWrap: _designSystem.FlexWrap.Wrap,
    gap: 2,
    minWidth: _designSystem.BlockSize.Zero
  }, isEditable ? /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  , {
    className: editIconClassName || undefined,
    color: _designSystem.IconColor.primaryDefault,
    ariaLabel: t('edit'),
    iconName: _componentLibrary.IconName.Edit,
    onClick: onEditClick,
    size: _componentLibrary.ButtonIconSize.Sm
    // to reset the button padding
    ,
    style: {
      marginRight: '-4px'
    },
    "data-testid": editIconDataTestId
  }) : null, tooltip ? /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    position: "bottom",
    title: tooltip,
    wrapperStyle: {
      minWidth: 0
    },
    interactive: true
  }, /*#__PURE__*/_react.default.createElement(InfoText, {
    text: text
  })) : /*#__PURE__*/_react.default.createElement(InfoText, {
    text: text
  }));
};
exports.ConfirmInfoRowText = ConfirmInfoRowText;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\confirm\\info\\row\\text.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\url.tsx", {"../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../../hooks/useOriginTrustSignals":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useOriginTrustSignals.ts","../../../../../hooks/useTrustSignals":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTrustSignals.ts","../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../ui/tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\index.js","../../../snaps/snap-authorship-pill":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-authorship-pill\\index.ts","../../../snaps/snap-metadata-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-metadata-modal\\index.js","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cconfirm%5Cinfo%5Crow%5Curl.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmInfoRowUrl = void 0;
var _react = _interopRequireWildcard(require("react"));
var _snapsUtils = require("@metamask/snaps-utils");
var _componentLibrary = require("../../../../component-library");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _snapAuthorshipPill = _interopRequireDefault(require("../../../snaps/snap-authorship-pill"));
var _snapMetadataModal = require("../../../snaps/snap-metadata-modal");
var _useOriginTrustSignals = require("../../../../../hooks/useOriginTrustSignals");
var _useTrustSignals = require("../../../../../hooks/useTrustSignals");
var _tooltip = _interopRequireDefault(require("../../../../ui/tooltip"));
var _useI18nContext = require("../../../../../hooks/useI18nContext");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HttpWarning = () => /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
  variant: _designSystem.TextVariant.bodySm,
  display: _designSystem.Display.Flex,
  alignItems: _designSystem.AlignItems.center,
  borderRadius: _designSystem.BorderRadius.SM,
  backgroundColor: _designSystem.BackgroundColor.warningMuted,
  paddingLeft: 1,
  paddingRight: 1,
  color: _designSystem.TextColor.warningDefault
}, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
  name: _componentLibrary.IconName.Danger,
  color: _designSystem.IconColor.warningDefault,
  size: _componentLibrary.IconSize.Sm,
  marginInlineEnd: 1
}), "HTTP");
const ConfirmInfoRowUrl = ({
  url
}) => {
  var _urlObject;
  const t = (0, _useI18nContext.useI18nContext)();
  const [isModalOpen, setIsModalOpen] = (0, _react.useState)(false);
  const handlePillClick = (0, _react.useCallback)(() => setIsModalOpen(true), [setIsModalOpen]);
  const handleModalClose = (0, _react.useCallback)(() => setIsModalOpen(false), [setIsModalOpen]);
  const originTrustSignals = (0, _useOriginTrustSignals.useOriginTrustSignals)(url);

  // Check if it's a Snap ID first to avoid unnecessary processing
  if ((0, _snapsUtils.isSnapId)(url)) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_snapAuthorshipPill.default, {
      snapId: url,
      onClick: handlePillClick
    }), /*#__PURE__*/_react.default.createElement(_snapMetadataModal.SnapMetadataModal, {
      snapId: url,
      isOpen: isModalOpen,
      onClose: handleModalClose
    }));
  }
  let urlObject;
  try {
    urlObject = new URL(url);
  } catch (e) {
    console.log(`ConfirmInfoRowUrl: new URL(url) cannot parse ${url}`);
  }
  const isHTTP = ((_urlObject = urlObject) === null || _urlObject === void 0 ? void 0 : _urlObject.protocol) === 'http:';
  const urlWithoutProtocol = url === null || url === void 0 ? void 0 : url.replace(/https?:\/\//u, '');
  const renderIcon = () => {
    // Priority 1: Malicious
    if (originTrustSignals.state === _useTrustSignals.TrustSignalDisplayState.Malicious) {
      return /*#__PURE__*/_react.default.createElement(_tooltip.default, {
        title: t('alertReasonOriginTrustSignalMalicious'),
        position: "bottom",
        style: {
          display: 'flex'
        }
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
        name: _componentLibrary.IconName.Danger,
        color: _designSystem.IconColor.errorDefault,
        size: _componentLibrary.IconSize.Sm
      }));
    }

    // Priority 2: HTTP Warning
    if (isHTTP) {
      return /*#__PURE__*/_react.default.createElement(HttpWarning, null);
    }

    // Priority 3: Warning
    if (originTrustSignals.state === _useTrustSignals.TrustSignalDisplayState.Warning) {
      return /*#__PURE__*/_react.default.createElement(_tooltip.default, {
        title: t('alertReasonOriginTrustSignalWarning'),
        position: "bottom",
        style: {
          display: 'flex'
        }
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
        name: _componentLibrary.IconName.Danger,
        color: _designSystem.IconColor.warningDefault,
        size: _componentLibrary.IconSize.Sm
      }));
    }

    // Priority 4: Verified
    if (originTrustSignals.state === _useTrustSignals.TrustSignalDisplayState.Verified) {
      return /*#__PURE__*/_react.default.createElement(_tooltip.default, {
        title: t('alertReasonOriginTrustSignalVerified'),
        position: "bottom",
        style: {
          display: 'flex'
        }
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
        name: _componentLibrary.IconName.VerifiedFilled,
        color: _designSystem.IconColor.infoDefault,
        size: _componentLibrary.IconSize.Sm
      }));
    }

    // Priority 5: No icon (Unknown state)
    return null;
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    flexWrap: _designSystem.FlexWrap.Wrap,
    gap: 2
  }, renderIcon(), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.inherit
  }, urlWithoutProtocol));
};
exports.ConfirmInfoRowUrl = ConfirmInfoRowUrl;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\confirm\\info\\row\\url.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\value-double.tsx", {"../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","./hook":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\hook.ts","./row":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\row.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cconfirm%5Cinfo%5Crow%5Cvalue-double.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmInfoRowValueDouble = void 0;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../../../component-library");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _hook = require("./hook");
var _row = require("./row");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const LEFT_TEXT_COLORS = {
  [_row.ConfirmInfoRowVariant.Default]: _designSystem.TextColor.textMuted,
  [_row.ConfirmInfoRowVariant.Critical]: _designSystem.Color.errorAlternative,
  [_row.ConfirmInfoRowVariant.Warning]: _designSystem.Color.warningDefault
};
const ConfirmInfoRowValueDouble = ({
  left,
  right
}) => {
  const {
    variant
  } = (0, _hook.useRowContext)();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    alignItems: _designSystem.AlignItems.center,
    flexWrap: _designSystem.FlexWrap.Wrap,
    gap: 1
  }, typeof left === 'string' ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: LEFT_TEXT_COLORS[variant]
  }, left) : left, typeof right === 'string' ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.inherit
  }, right) : right);
};
exports.ConfirmInfoRowValueDouble = ConfirmInfoRowValueDouble;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\confirm\\info\\row\\value-double.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\connected-accounts-list\\connected-accounts-list-item\\connected-accounts-list-item.component.js", {"../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../preferred-avatar":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\preferred-avatar\\index.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cconnected-accounts-list%5Cconnected-accounts-list-item%5Cconnected-accounts-list-item.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ConnectedAccountsListItem;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _util = require("../../../../helpers/utils/util");
var _componentLibrary = require("../../../component-library");
var _preferredAvatar = require("../../preferred-avatar");
var _designSystem = require("../../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function ConnectedAccountsListItem({
  address,
  className = null,
  name,
  status,
  action = null,
  options = null,
  backgroundColor
}) {
  const containerbackgroundColor = backgroundColor ?? _designSystem.BackgroundColor.backgroundDefault;
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: (0, _classnames.default)('connected-accounts-list__row', className),
    padding: 4,
    backgroundColor: containerbackgroundColor,
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "connected-accounts-list__row-content",
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_preferredAvatar.PreferredAvatar, {
    address: address
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyLgMedium,
    className: "connected-accounts-list__account-name"
  }, name), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd
  }, (0, _util.shortenAddress)(address)), status ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    className: "connected-accounts-list__account-status",
    color: _designSystem.TextColor.successDefault
  }, status) : null), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column
  }, action))), options);
}
ConnectedAccountsListItem.propTypes = {
  /**
   * Address for Avatar
   */
  address: _propTypes.default.string.isRequired,
  /**
   * An additional className to apply
   */
  className: _propTypes.default.string,
  /**
   * Name of the account
   */
  name: _propTypes.default.node.isRequired,
  /**
   * Status showing connected, not connected and active state
   */
  status: _propTypes.default.string,
  /**
   * Action for account
   */
  action: _propTypes.default.node,
  /**
   * Render Options button with actions
   */
  options: _propTypes.default.node,
  /**
   * ContainerbackgroundColor showing highlighted state when not connected
   */
  backgroundColor: _propTypes.default.string
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\connected-accounts-list\\connected-accounts-list-item\\connected-accounts-list-item.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\connected-accounts-list\\connected-accounts-list-item\\index.js", {"./connected-accounts-list-item.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\connected-accounts-list\\connected-accounts-list-item\\connected-accounts-list-item.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cconnected-accounts-list%5Cconnected-accounts-list-item%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _connectedAccountsListItem.default;
  }
});
var _connectedAccountsListItem = _interopRequireDefault(require("./connected-accounts-list-item.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\connected-accounts-list\\connected-accounts-list-item\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\connected-accounts-list\\connected-accounts-list-options\\connected-accounts-list-options.component.js", {"../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../ui/menu":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\menu\\index.ts","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cconnected-accounts-list%5Cconnected-accounts-list-options%5Cconnected-accounts-list-options.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _menu = require("../../../ui/menu");
var _componentLibrary = require("../../../component-library");
var _useI18nContext = require("../../../../hooks/useI18nContext");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const ConnectedAccountsListOptions = ({
  children,
  onShowOptions,
  onHideOptions,
  show
}) => {
  const ref = (0, _react.useRef)(false);
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: ref
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    iconName: _componentLibrary.IconName.MoreVertical,
    className: "connected-accounts-options__button",
    onClick: onShowOptions,
    ariaLabel: t('options')
  }), show ? /*#__PURE__*/_react.default.createElement(_menu.Menu, {
    anchorElement: ref.current,
    onHide: onHideOptions,
    popperOptions: {
      modifiers: [{
        name: 'preventOverflow',
        options: {
          altBoundary: true
        }
      }]
    }
  }, children) : null);
};
ConnectedAccountsListOptions.propTypes = {
  children: _propTypes.default.node.isRequired,
  onHideOptions: _propTypes.default.func.isRequired,
  onShowOptions: _propTypes.default.func.isRequired,
  show: _propTypes.default.bool.isRequired
};
var _default = exports.default = ConnectedAccountsListOptions;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\connected-accounts-list\\connected-accounts-list-options\\connected-accounts-list-options.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\connected-accounts-list\\connected-accounts-list-options\\index.js", {"./connected-accounts-list-options.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\connected-accounts-list\\connected-accounts-list-options\\connected-accounts-list-options.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cconnected-accounts-list%5Cconnected-accounts-list-options%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _connectedAccountsListOptions.default;
  }
});
var _connectedAccountsListOptions = _interopRequireDefault(require("./connected-accounts-list-options.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\connected-accounts-list\\connected-accounts-list-options\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\connected-accounts-list\\connected-accounts-list.component.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/menu":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\menu\\index.ts","./connected-accounts-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\connected-accounts-list\\connected-accounts-list-item\\index.js","./connected-accounts-list-options":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\connected-accounts-list\\connected-accounts-list-options\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cconnected-accounts-list%5Cconnected-accounts-list.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../component-library");
var _menu = require("../../ui/menu");
var _connectedAccountsListItem = _interopRequireDefault(require("./connected-accounts-list-item"));
var _connectedAccountsListOptions = _interopRequireDefault(require("./connected-accounts-list-options"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class ConnectedAccountsList extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "state", {
      accountWithOptionsShown: null
    });
    _defineProperty(this, "disconnectAccount", () => {
      this.hideAccountOptions();
      this.props.removePermittedAccount(this.state.accountWithOptionsShown);
    });
    _defineProperty(this, "switchAccount", address => {
      this.hideAccountOptions();
      this.props.setSelectedAddress(address);
    });
    _defineProperty(this, "hideAccountOptions", () => {
      this.setState({
        accountWithOptionsShown: null
      });
    });
    _defineProperty(this, "showAccountOptions", address => {
      this.setState({
        accountWithOptionsShown: address
      });
    });
  }
  renderUnconnectedAccount() {
    const {
      accountToConnect,
      connectAccount
    } = this.props;
    const {
      t
    } = this.context;
    if (!accountToConnect) {
      return null;
    }
    const {
      address,
      metadata: {
        name
      }
    } = accountToConnect;
    return /*#__PURE__*/_react.default.createElement(_connectedAccountsListItem.default, {
      className: "connected-accounts-list__row--highlight",
      backgroundColor: _designSystem.BackgroundColor.warningMuted,
      address: address,
      name: name,
      status: t('statusNotConnected'),
      action: /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        variant: _designSystem.TextVariant.bodyMd
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
        className: "connected-accounts-list__account-status-link",
        onClick: () => connectAccount(address),
        size: _componentLibrary.ButtonLinkSize.Inherit
      }, t('connect')))
    });
  }
  renderListItemOptions(address) {
    const {
      accountWithOptionsShown
    } = this.state;
    const {
      t
    } = this.context;
    return /*#__PURE__*/_react.default.createElement(_connectedAccountsListOptions.default, {
      onHideOptions: this.hideAccountOptions,
      onShowOptions: this.showAccountOptions.bind(null, address),
      show: accountWithOptionsShown === address
    }, /*#__PURE__*/_react.default.createElement(_menu.MenuItem, {
      iconName: _componentLibrary.IconName.Logout,
      onClick: this.disconnectAccount
    }, t('disconnectThisAccount')));
  }
  renderListItemAction(address) {
    const {
      t
    } = this.context;
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMd
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
      className: "connected-accounts-list__account-status-link",
      onClick: () => this.switchAccount(address),
      size: _componentLibrary.ButtonLinkSize.Inherit
    }, t('switchToThisAccount')));
  }
  render() {
    const {
      connectedAccounts,
      selectedAddress,
      shouldRenderListOptions
    } = this.props;
    const {
      t
    } = this.context;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("main", {
      className: "connected-accounts-list"
    }, this.renderUnconnectedAccount(), connectedAccounts.map(({
      address,
      name
    }, index) => {
      return /*#__PURE__*/_react.default.createElement(_connectedAccountsListItem.default, {
        key: address,
        address: address,
        name: name,
        status: index === 0 ? t('active') : null,
        options: shouldRenderListOptions ? this.renderListItemOptions(address) : null,
        action: address === selectedAddress ? null : this.renderListItemAction(address)
      });
    })));
  }
}
exports.default = ConnectedAccountsList;
_defineProperty(ConnectedAccountsList, "contextTypes", {
  t: _propTypes.default.func.isRequired
});
_defineProperty(ConnectedAccountsList, "defaultProps", {
  accountToConnect: null
});
_defineProperty(ConnectedAccountsList, "propTypes", {
  accountToConnect: _propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    address: _propTypes.default.string.isRequired,
    metadata: _propTypes.default.shape({
      name: _propTypes.default.string.isRequired,
      keyring: _propTypes.default.shape({
        type: _propTypes.default.string.isRequired
      }).isRequired
    }).isRequired,
    options: _propTypes.default.object.isRequired,
    methods: _propTypes.default.arrayOf(_propTypes.default.string).isRequired,
    type: _propTypes.default.string.isRequired
  }),
  connectedAccounts: _propTypes.default.arrayOf(_propTypes.default.shape({
    address: _propTypes.default.string.isRequired,
    name: _propTypes.default.string.isRequired,
    lastActive: _propTypes.default.number
  })).isRequired,
  connectAccount: _propTypes.default.func.isRequired,
  selectedAddress: _propTypes.default.string.isRequired,
  removePermittedAccount: _propTypes.default.func,
  setSelectedAddress: _propTypes.default.func.isRequired,
  shouldRenderListOptions: (props, propName, componentName) => {
    if (typeof props[propName] !== 'boolean') {
      return new Error(`Warning: Failed prop type: '${propName}' of component '${componentName}' must be a boolean. Received: ${typeof props[propName]}`);
    } else if (props[propName] && !props.removePermittedAccount) {
      return new Error(`Warning: Failed prop type: '${propName}' of component '${componentName}' requires prop 'removePermittedAccount'.`);
    }
    return undefined;
  }
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\connected-accounts-list\\connected-accounts-list.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\connected-accounts-list\\index.js", {"./connected-accounts-list.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\connected-accounts-list\\connected-accounts-list.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cconnected-accounts-list%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _connectedAccountsList.default;
  }
});
var _connectedAccountsList = _interopRequireDefault(require("./connected-accounts-list.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\connected-accounts-list\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\connected-accounts-permissions\\connected-accounts-permissions.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/permission":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\permission.js","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cconnected-accounts-permissions%5Cconnected-accounts-permissions.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _reactRedux = require("react-redux");
var _componentLibrary = require("../../component-library");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _permission = require("../../../helpers/utils/permission");
var _designSystem = require("../../../helpers/constants/design-system");
var _util = require("../../../helpers/utils/util");
var _selectors = require("../../../selectors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const ConnectedAccountsPermissions = ({
  permissions
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const [expanded, setExpanded] = (0, _react.useState)(false);
  const snapsMetadata = (0, _reactRedux.useSelector)(_selectors.getSnapsMetadata);
  const toggleExpanded = () => {
    setExpanded(_expanded => !_expanded);
  };
  if (!permissions.length) {
    return null;
  }
  const permissionLabels = (0, _lodash.flatten)(permissions.map(({
    key,
    value
  }) => (0, _permission.getPermissionDescription)({
    t,
    permissionName: key,
    permissionValue: value,
    getSubjectName: (0, _util.getSnapName)(snapsMetadata)
  })));
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "connected-accounts-permissions",
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    as: "button",
    onClick: toggleExpanded,
    width: _designSystem.BlockSize.Full,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    className: "connected-accounts-permissions__header",
    padding: 0,
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    onClick: toggleExpanded,
    as: "h6",
    variant: _designSystem.TextVariant.bodyMdMedium
  }, t('permissions')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    size: _componentLibrary.ButtonIconSize.Sm,
    iconName: expanded ? _componentLibrary.IconName.ArrowUp : _componentLibrary.IconName.ArrowDown,
    ariaLabel: t('showPermissions')
  })), expanded ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: (0, _classnames.default)('connected-accounts-permissions__list-container-expanded'),
    marginTop: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "h6",
    variant: _designSystem.TextVariant.bodySm
  }, t('authorizedPermissions'), ":"), /*#__PURE__*/_react.default.createElement("ul", {
    className: "connected-accounts-permissions__list"
  }, permissionLabels.map(({
    label
  }, idx) => /*#__PURE__*/_react.default.createElement("li", {
    key: `connected-permission-${idx}`,
    className: "connected-accounts-permissions__list-item"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Checkbox, {
    isChecked: true,
    isDisabled: true,
    id: `connected-permission-${idx}`,
    label: label
  }))))) : null);
};
ConnectedAccountsPermissions.propTypes = {
  permissions: _propTypes.default.arrayOf(_propTypes.default.shape({
    key: _propTypes.default.string.isRequired
  }))
};
ConnectedAccountsPermissions.defaultProps = {
  permissions: []
};
ConnectedAccountsPermissions.displayName = 'ConnectedAccountsPermissions';
var _default = exports.default = /*#__PURE__*/_react.default.memo(ConnectedAccountsPermissions);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\connected-accounts-permissions\\connected-accounts-permissions.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\connected-accounts-permissions\\index.js", {"./connected-accounts-permissions":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\connected-accounts-permissions\\connected-accounts-permissions.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cconnected-accounts-permissions%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _connectedAccountsPermissions.default;
  }
});
var _connectedAccountsPermissions = _interopRequireDefault(require("./connected-accounts-permissions"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\connected-accounts-permissions\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\connected-sites-list\\connected-sites-list.component.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/button":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\button\\index.js","../../ui/site-origin":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\site-origin\\index.js","../snaps/snap-icon":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-icon\\index.ts","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cconnected-sites-list%5Cconnected-sites-list.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _snapsUtils = require("@metamask/snaps-utils");
var _button = _interopRequireDefault(require("../../ui/button"));
var _componentLibrary = require("../../component-library");
var _util = require("../../../helpers/utils/util");
var _siteOrigin = _interopRequireDefault(require("../../ui/site-origin"));
var _designSystem = require("../../../helpers/constants/design-system");
var _snapIcon = require("../snaps/snap-icon");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class ConnectedSitesList extends _react.Component {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "getConnectedSitesListContent", () => {
      const {
        connectedSubjects,
        onDisconnect,
        getSnapName
      } = this.props;
      const {
        t
      } = this.context;
      return connectedSubjects.map(subject => {
        if ((0, _snapsUtils.isSnapId)(subject.origin)) {
          const snapName = getSnapName(subject.origin);
          return /*#__PURE__*/_react.default.createElement("div", {
            key: subject.origin,
            className: "connected-sites-list__content-row"
          }, /*#__PURE__*/_react.default.createElement("div", {
            className: "connected-sites-list__subject-info"
          }, /*#__PURE__*/_react.default.createElement(_snapIcon.SnapIcon, {
            avatarSize: _componentLibrary.IconSize.Md,
            snapId: subject.origin
          }), /*#__PURE__*/_react.default.createElement(_siteOrigin.default, {
            className: "connected-sites-list__subject-name",
            title: snapName,
            siteOrigin: snapName
          })), /*#__PURE__*/_react.default.createElement(_button.default, {
            className: "connected-sites-list__content-row-link-button",
            onClick: () => onDisconnect(subject.origin),
            type: "link"
          }, t('disconnect')));
        }
        return /*#__PURE__*/_react.default.createElement("div", {
          key: subject.origin,
          className: "connected-sites-list__content-row"
        }, /*#__PURE__*/_react.default.createElement("div", {
          className: "connected-sites-list__subject-info"
        }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarFavicon, {
          className: "connected-sites-list__subject-icon",
          name: subject.name,
          size: _designSystem.Size.MD,
          src: subject.iconUrl
        }), /*#__PURE__*/_react.default.createElement(_siteOrigin.default, {
          className: "connected-sites-list__subject-name",
          title: subject.extensionId || subject.origin,
          siteOrigin: this.getSubjectDisplayName(subject)
        })), /*#__PURE__*/_react.default.createElement(_button.default, {
          className: "connected-sites-list__content-row-link-button",
          onClick: () => onDisconnect(subject.origin),
          type: "link"
        }, t('disconnect')));
      });
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement("main", {
      className: "connected-sites-list__content-rows"
    }, this.getConnectedSitesListContent());
  }
  getSubjectDisplayName(subject) {
    if (subject.extensionId) {
      return this.context.t('externalExtension');
    }

    // We strip https schemes only, and only if the URL has no port.
    return (0, _util.stripHttpsSchemeWithoutPort)(subject.origin);
  }
}
exports.default = ConnectedSitesList;
_defineProperty(ConnectedSitesList, "contextTypes", {
  t: _propTypes.default.func
});
_defineProperty(ConnectedSitesList, "propTypes", {
  connectedSubjects: _propTypes.default.arrayOf(_propTypes.default.shape({
    name: _propTypes.default.string,
    iconUrl: _propTypes.default.string,
    origin: _propTypes.default.string
  })).isRequired,
  onDisconnect: _propTypes.default.func.isRequired,
  getSnapName: _propTypes.default.func.isRequired
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\connected-sites-list\\connected-sites-list.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\connected-sites-list\\connected-sites-list.container.js", {"../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","./connected-sites-list.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\connected-sites-list\\connected-sites-list.component.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cconnected-sites-list%5Cconnected-sites-list.container.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactRedux = require("react-redux");
var _selectors = require("../../../selectors");
var _connectedSitesList = _interopRequireDefault(require("./connected-sites-list.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function mapStateToProps(state) {
  return {
    getSnapName: id => (0, _selectors.getSnapMetadata)(state, id).name
  };
}
var _default = exports.default = (0, _reactRedux.connect)(mapStateToProps, null)(_connectedSitesList.default);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\connected-sites-list\\connected-sites-list.container.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\connected-sites-list\\connected-sites-list.js", {"./connected-sites-list.container":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\connected-sites-list\\connected-sites-list.container.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cconnected-sites-list%5Cconnected-sites-list.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _connectedSitesList.default;
  }
});
var _connectedSitesList = _interopRequireDefault(require("./connected-sites-list.container"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\connected-sites-list\\connected-sites-list.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\connected-sites-list\\connected-snaps.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/menu":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\menu\\index.ts","../connected-accounts-list/connected-accounts-list-options":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\connected-accounts-list\\connected-accounts-list-options\\index.js","../snaps/snap-icon":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-icon\\index.ts","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cconnected-sites-list%5Cconnected-snaps.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ConnectedSnaps;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _componentLibrary = require("../../component-library");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _menu = require("../../ui/menu");
var _designSystem = require("../../../helpers/constants/design-system");
var _connectedAccountsListOptions = _interopRequireDefault(require("../connected-accounts-list/connected-accounts-list-options"));
var _selectors = require("../../../selectors");
var _actions = require("../../../store/actions");
var _util = require("../../../helpers/utils/util");
var _snapIcon = require("../snaps/snap-icon");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ConnectedSnaps({
  connectedSubjects
}) {
  const [showOptions, setShowOptions] = (0, _react.useState)();
  const t = (0, _useI18nContext.useI18nContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const connectedOrigin = (0, _reactRedux.useSelector)(_selectors.getOriginOfCurrentTab);
  const onDisconnect = snapId => {
    dispatch((0, _actions.disconnectOriginFromSnap)(connectedOrigin, snapId));
  };
  const renderListItemOptions = snapId => {
    return /*#__PURE__*/_react.default.createElement(_connectedAccountsListOptions.default, {
      onHideOptions: () => setShowOptions(),
      onShowOptions: () => setShowOptions(snapId),
      show: showOptions === snapId
    }, /*#__PURE__*/_react.default.createElement(_menu.MenuItem, {
      iconName: _componentLibrary.IconName.Logout,
      onClick: e => {
        e.preventDefault();
        onDisconnect(snapId);
      }
    }, t('disconnect')), /*#__PURE__*/_react.default.createElement(_menu.MenuItem, {
      iconName: _componentLibrary.IconName.Setting,
      onClick: () => history.push((0, _util.getSnapRoute)(snapId))
    }, t('snapsSettings')));
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "connected-snaps-list__content-rows",
    width: _designSystem.BlockSize.Full
  }, connectedSubjects.map(subject => /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    key: subject.origin,
    className: "connected-snaps-list__content-row",
    width: _designSystem.BlockSize.Full,
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    padding: 4,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "connected-snaps-list__subject-info",
    gap: 4,
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_snapIcon.SnapIcon, {
    snapId: subject.origin,
    avatarSize: _componentLibrary.IconSize.Md
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyLgMedium,
    className: "connected-accounts-list__account-name"
  }, subject.name)), renderListItemOptions(subject.origin))));
}
ConnectedSnaps.propTypes = {
  /**
   * Shape of ConnectedSnaps
   */
  connectedSubjects: _propTypes.default.arrayOf(_propTypes.default.shape({
    /**
     * It should have a name for Snap
     */
    name: _propTypes.default.string,
    /**
     * Origin of connected subject, in case of snaps it's snapId
     */
    origin: _propTypes.default.string
  })).isRequired
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\connected-sites-list\\connected-snaps.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\connected-sites-list\\index.js", {"./connected-sites-list":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\connected-sites-list\\connected-sites-list.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cconnected-sites-list%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _connectedSitesList.default;
  }
});
var _connectedSitesList = _interopRequireDefault(require("./connected-sites-list"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\connected-sites-list\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\connected-status-indicator\\connected-status-indicator.js", {"../../../helpers/constants/connected-sites":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\connected-sites.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","../../multichain":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","@metamask/chain-agnostic-permission":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\chain-agnostic-permission\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cconnected-status-indicator%5Cconnected-status-indicator.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ConnectedStatusIndicator;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRedux = require("react-redux");
var _snapsUtils = require("@metamask/snaps-utils");
var _chainAgnosticPermission = require("@metamask/chain-agnostic-permission");
var _connectedSites = require("../../../helpers/constants/connected-sites");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _selectors = require("../../../selectors");
var _multichain = require("../../multichain");
var _accountTree = require("../../../selectors/multichain-accounts/account-tree");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function ConnectedStatusIndicator({
  onClick,
  disabled
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  const selectedAccountGroupId = (0, _reactRedux.useSelector)(_accountTree.getSelectedAccountGroup);
  const accountGroupInternalAccounts = (0, _reactRedux.useSelector)(state => (0, _accountTree.getInternalAccountsFromGroupById)(state, selectedAccountGroupId));
  const permissionsForActiveTab = (0, _reactRedux.useSelector)(_selectors.getPermissionsForActiveTab);
  const activeWalletSnap = permissionsForActiveTab.map(permission => permission.key).includes(_snapsUtils.WALLET_SNAP_PERMISSION_KEY);
  const permittedAccounts = (0, _reactRedux.useSelector)(_selectors.getAllPermittedAccountsForCurrentTab);
  const currentTabIsConnectedToAccountGroup = selectedAccountGroupId && accountGroupInternalAccounts && accountGroupInternalAccounts.some(account => (0, _chainAgnosticPermission.isInternalAccountInPermittedAccountIds)(account, permittedAccounts));
  let status;
  if (currentTabIsConnectedToAccountGroup) {
    status = _connectedSites.STATUS_CONNECTED;
  } else if (permittedAccounts.length > 0) {
    status = _connectedSites.STATUS_CONNECTED_TO_ANOTHER_ACCOUNT;
  } else if (activeWalletSnap) {
    status = _connectedSites.STATUS_CONNECTED_TO_SNAP;
  } else {
    status = _connectedSites.STATUS_NOT_CONNECTED;
  }
  let globalMenuColor = _designSystem.Color.iconAlternative;
  if (status === _connectedSites.STATUS_CONNECTED) {
    globalMenuColor = _designSystem.Color.successDefault;
  } else if (status === _connectedSites.STATUS_CONNECTED_TO_ANOTHER_ACCOUNT || status === _connectedSites.STATUS_CONNECTED_TO_SNAP) {
    globalMenuColor = _designSystem.BackgroundColor.backgroundDefault;
  }
  const tooltipText = status === _connectedSites.STATUS_CONNECTED ? t('tooltipSatusConnected') : t('tooltipSatusNotConnected');
  return /*#__PURE__*/_react.default.createElement(_multichain.ConnectedSiteMenu, {
    status: status,
    globalMenuColor: globalMenuColor,
    text: tooltipText,
    as: "button",
    onClick: onClick,
    disabled: disabled
  });
}
ConnectedStatusIndicator.propTypes = {
  onClick: _propTypes.default.func,
  disabled: _propTypes.default.bool
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\connected-status-indicator\\connected-status-indicator.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\connected-status-indicator\\index.js", {"./connected-status-indicator":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\connected-status-indicator\\connected-status-indicator.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cconnected-status-indicator%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _connectedStatusIndicator.default;
  }
});
var _connectedStatusIndicator = _interopRequireDefault(require("./connected-status-indicator"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\connected-status-indicator\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\connections-removed-modal\\connections-removed-modal.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cconnections-removed-modal%5Cconnections-removed-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ConnectionsRemovedModal;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../component-library");
var _actions = require("../../../store/actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function ConnectionsRemovedModal() {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const onConfirm = (0, _react.useCallback)(() => {
    dispatch((0, _actions.setShowConnectionsRemovedModal)(false));
  }, [dispatch]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: true,
    onClose: () => undefined,
    "data-testid": "connections-removed-modal"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, {
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.Danger,
    size: _componentLibrary.IconSize.Xl,
    color: _designSystem.IconColor.warningDefault
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingSm,
    textAlign: _designSystem.TextAlign.Center,
    marginTop: 4
  }, t('connectionsRemovedModalTitle')))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, null, t('connectionsRemovedModalDescription')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalFooter, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    size: _componentLibrary.ButtonSize.Lg,
    block: true,
    onClick: onConfirm
  }, t('gotIt')))));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\connections-removed-modal\\connections-removed-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\connections-removed-modal\\index.ts", {"./connections-removed-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\connections-removed-modal\\connections-removed-modal.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cconnections-removed-modal%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _connectionsRemovedModal.default;
  }
});
var _connectionsRemovedModal = _interopRequireDefault(require("./connections-removed-modal"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\connections-removed-modal\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\contact-list\\contact-list.component.js", {"../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/button":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\button\\index.js","./recipient-group/recipient-group.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\contact-list\\recipient-group\\recipient-group.component.js","./utils":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\contact-list\\utils.ts","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Ccontact-list%5Ccontact-list.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _lodash = require("lodash");
var _button = _interopRequireDefault(require("../../ui/button"));
var _componentLibrary = require("../../component-library");
var _recipientGroup = _interopRequireDefault(require("./recipient-group/recipient-group.component"));
var _utils = require("./utils");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class ContactList extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "state", {
      isShowingAllRecent: false
    });
  }
  renderDuplicateContactWarning() {
    const {
      t
    } = this.context;
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "send__select-recipient-wrapper__list__duplicate-contact-banner"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerAlert, {
      severity: _componentLibrary.BannerAlertSeverity.Warning,
      description: t('duplicateContactWarning')
    }));
  }
  renderRecents() {
    const {
      t
    } = this.context;
    const {
      isShowingAllRecent
    } = this.state;
    const nonContacts = this.props.searchForRecents();
    const showLoadMore = !isShowingAllRecent && nonContacts.length > 2;
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "send__select-recipient-wrapper__recent-group-wrapper"
    }, showLoadMore && /*#__PURE__*/_react.default.createElement(_button.default, {
      type: "link",
      className: "send__select-recipient-wrapper__recent-group-wrapper__load-more",
      onClick: () => this.setState({
        isShowingAllRecent: true
      })
    }, t('loadMore')));
  }
  renderAddressBook() {
    const {
      addressBook,
      internalAccounts,
      searchForContacts,
      selectRecipient,
      selectedAddress
    } = this.props;
    const duplicateContactMap = (0, _utils.buildDuplicateContactMap)(addressBook, internalAccounts);
    const unsortedContactsByLetter = searchForContacts().reduce((obj, contact) => {
      const firstLetter = contact.name[0].toUpperCase();
      const isDuplicate = (duplicateContactMap.get(contact.name.trim().toLowerCase()) ?? []).length > 1;
      return {
        ...obj,
        [firstLetter]: [...(obj[firstLetter] || []), {
          ...contact,
          isDuplicate
        }]
      };
    }, {});
    const letters = Object.keys(unsortedContactsByLetter).sort();
    const sortedContactGroups = letters.map(letter => {
      return [letter, (0, _lodash.sortBy)(unsortedContactsByLetter[letter], contact => {
        return contact.name.toLowerCase();
      })];
    });
    return sortedContactGroups.map(([letter, groupItems]) => /*#__PURE__*/_react.default.createElement(_recipientGroup.default, {
      key: `${letter}-contact-group`,
      label: letter,
      items: groupItems,
      onSelect: selectRecipient,
      selectedAddress: selectedAddress
    }));
  }
  renderMyAccounts() {
    const myAccounts = this.props.searchForMyAccounts();
    return /*#__PURE__*/_react.default.createElement(_recipientGroup.default, {
      items: myAccounts,
      onSelect: this.props.selectRecipient,
      selectedAddress: this.props.selectedAddress
    });
  }
  render() {
    const {
      children,
      searchForRecents,
      searchForContacts,
      searchForMyAccounts,
      addressBook,
      internalAccounts
    } = this.props;
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "send__select-recipient-wrapper__list"
    }, children || null, (0, _utils.hasDuplicateContacts)(addressBook, internalAccounts) ? this.renderDuplicateContactWarning() : null, searchForRecents ? this.renderRecents() : null, searchForContacts ? this.renderAddressBook() : null, searchForMyAccounts ? this.renderMyAccounts() : null);
  }
}
exports.default = ContactList;
_defineProperty(ContactList, "propTypes", {
  addressBook: _propTypes.default.array,
  internalAccounts: _propTypes.default.array,
  searchForContacts: _propTypes.default.func,
  searchForRecents: _propTypes.default.func,
  searchForMyAccounts: _propTypes.default.func,
  selectRecipient: _propTypes.default.func,
  children: _propTypes.default.node,
  selectedAddress: _propTypes.default.string
});
_defineProperty(ContactList, "contextTypes", {
  t: _propTypes.default.func
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\contact-list\\contact-list.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\contact-list\\index.js", {"./contact-list.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\contact-list\\contact-list.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Ccontact-list%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _contactList.default;
  }
});
var _contactList = _interopRequireDefault(require("./contact-list.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\contact-list\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\contact-list\\recipient-group\\recipient-group.component.js", {"../../../multichain":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Ccontact-list%5Crecipient-group%5Crecipient-group.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = RecipientGroup;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _multichain = require("../../../multichain");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function RecipientGroup({
  items,
  onSelect
}) {
  if (!items || !items.length) {
    return null;
  }
  return items.map(({
    address,
    name,
    isDuplicate,
    chainId
  }) => /*#__PURE__*/_react.default.createElement(_multichain.AddressListItem, {
    address: address,
    label: name,
    onClick: () => onSelect(address, name, chainId),
    key: address,
    chainId: chainId,
    isDuplicate: isDuplicate
  }));
}
RecipientGroup.propTypes = {
  items: _propTypes.default.arrayOf(_propTypes.default.shape({
    address: _propTypes.default.string.isRequired,
    name: _propTypes.default.string
  })),
  onSelect: _propTypes.default.func.isRequired
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\contact-list\\recipient-group\\recipient-group.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\contact-list\\utils.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Ccontact-list%5Cutils.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isDuplicateContact = exports.hasDuplicateContacts = exports.buildDuplicateContactMap = void 0;
const buildDuplicateContactMap = (addressBook, internalAccounts) => {
  const contactMap = new Map(internalAccounts.map(account => [account.metadata.name.trim().toLowerCase(), [`account-id-${account.id}`]]));
  addressBook.forEach(entry => {
    const {
      name,
      address
    } = entry;
    const sanitizedName = name.trim().toLowerCase();
    const currentArray = contactMap.get(sanitizedName) ?? [];
    currentArray.push(address);
    contactMap.set(sanitizedName, currentArray);
  });
  return contactMap;
};
exports.buildDuplicateContactMap = buildDuplicateContactMap;
const hasDuplicateContacts = (addressBook, internalAccounts) => {
  const uniqueContactNames = Array.from(new Set(addressBook.map(({
    name
  }) => name.toLowerCase().trim())));
  const hasAccountNameCollision = internalAccounts.some(account => uniqueContactNames.includes(account.metadata.name.toLowerCase().trim()));
  return uniqueContactNames.length !== addressBook.length || hasAccountNameCollision;
};
exports.hasDuplicateContacts = hasDuplicateContacts;
const isDuplicateContact = (addressBook, internalAccounts, newName) => {
  const nameExistsInAddressBook = addressBook.some(({
    name
  }) => name.toLowerCase().trim() === newName.toLowerCase().trim());
  const nameExistsInAccountList = internalAccounts.some(({
    metadata
  }) => metadata.name.toLowerCase().trim() === newName.toLowerCase().trim());
  return nameExistsInAddressBook || nameExistsInAccountList;
};
exports.isDuplicateContact = isDuplicateContact;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\contact-list\\utils.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\create-new-vault\\create-new-vault.js", {"../../../helpers/constants/common":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\common.ts","../../../hooks/identity/useAuthentication":"D:\\code\\v\\metamask-extension\\ui\\hooks\\identity\\useAuthentication\\index.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/text-field":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\text-field\\index.js","../srp-input":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\srp-input\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Ccreate-new-vault%5Ccreate-new-vault.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = CreateNewVault;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _useI18nContext = require("../../../hooks/useI18nContext");
var _textField = _interopRequireDefault(require("../../ui/text-field"));
var _componentLibrary = require("../../component-library");
var _srpInput = _interopRequireDefault(require("../srp-input"));
var _common = require("../../../helpers/constants/common");
var _useAuthentication = require("../../../hooks/identity/useAuthentication");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function CreateNewVault({
  disabled = false,
  includeTerms = false,
  onSubmit,
  submitText
}) {
  const [confirmPassword, setConfirmPassword] = (0, _react.useState)('');
  const [confirmPasswordError, setConfirmPasswordError] = (0, _react.useState)('');
  const [password, setPassword] = (0, _react.useState)('');
  const [passwordError, setPasswordError] = (0, _react.useState)('');
  const [seedPhrase, setSeedPhrase] = (0, _react.useState)('');
  const [termsChecked, setTermsChecked] = (0, _react.useState)(false);
  const {
    signOut
  } = (0, _useAuthentication.useSignOut)();
  const t = (0, _useI18nContext.useI18nContext)();
  const onPasswordChange = (0, _react.useCallback)(newPassword => {
    let newConfirmPasswordError = '';
    let newPasswordError = '';
    if (newPassword && newPassword.length < _common.PASSWORD_MIN_LENGTH) {
      newPasswordError = t('passwordNotLongEnough');
    }
    if (confirmPassword && newPassword !== confirmPassword) {
      newConfirmPasswordError = t('passwordsDontMatch');
    }
    setPassword(newPassword);
    setPasswordError(newPasswordError);
    setConfirmPasswordError(newConfirmPasswordError);
  }, [confirmPassword, t]);
  const onConfirmPasswordChange = (0, _react.useCallback)(newConfirmPassword => {
    let newConfirmPasswordError = '';
    if (password !== newConfirmPassword) {
      newConfirmPasswordError = t('passwordsDontMatch');
    }
    setConfirmPassword(newConfirmPassword);
    setConfirmPasswordError(newConfirmPasswordError);
  }, [password, t]);
  const isValid = !disabled && password && confirmPassword && password === confirmPassword && seedPhrase && (!includeTerms || termsChecked) && !passwordError && !confirmPasswordError;
  const onImport = (0, _react.useCallback)(async event => {
    event.preventDefault();
    if (!isValid) {
      return;
    }
    await signOut();
    await onSubmit(password, seedPhrase);
  }, [isValid, onSubmit, password, seedPhrase, signOut]);
  const toggleTermsCheck = (0, _react.useCallback)(() => {
    setTermsChecked(currentTermsChecked => !currentTermsChecked);
  }, []);
  const termsOfUse = t('acceptTermsOfUse', [/*#__PURE__*/_react.default.createElement("a", {
    className: "create-new-vault__terms-link",
    key: "create-new-vault__link-text",
    href: "https://metamask.io/terms.html",
    target: "_blank",
    rel: "noopener noreferrer"
  }, t('terms'))]);
  return /*#__PURE__*/_react.default.createElement("form", {
    className: "create-new-vault__form",
    onSubmit: onImport
  }, /*#__PURE__*/_react.default.createElement(_srpInput.default, {
    onChange: setSeedPhrase,
    srpText: t('secretRecoveryPhrase')
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "create-new-vault__create-password"
  }, /*#__PURE__*/_react.default.createElement(_textField.default, {
    "data-testid": "create-vault-password",
    id: "password",
    label: t('newPassword'),
    type: "password",
    value: password,
    onChange: event => onPasswordChange(event.target.value),
    error: passwordError,
    autoComplete: "new-password",
    margin: "normal",
    largeLabel: true
  }), /*#__PURE__*/_react.default.createElement(_textField.default, {
    "data-testid": "create-vault-confirm-password",
    id: "confirm-password",
    label: t('confirmPassword'),
    type: "password",
    value: confirmPassword,
    onChange: event => onConfirmPasswordChange(event.target.value),
    error: confirmPasswordError,
    autoComplete: "new-password",
    margin: "normal",
    largeLabel: true
  })), includeTerms ? /*#__PURE__*/_react.default.createElement("div", {
    className: "create-new-vault__terms"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Checkbox, {
    id: "create-new-vault-terms-checkbox",
    "data-testid": "create-new-vault-terms-checkbox",
    isChecked: termsChecked,
    onChange: toggleTermsCheck,
    label: termsOfUse
  })) : null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    "data-testid": "create-new-vault-submit-button",
    className: "create-new-vault__submit-button",
    variant: _componentLibrary.ButtonVariant.Primary,
    disabled: !isValid,
    type: "submit"
  }, submitText));
}
CreateNewVault.propTypes = {
  disabled: _propTypes.default.bool,
  includeTerms: _propTypes.default.bool,
  onSubmit: _propTypes.default.func.isRequired,
  submitText: _propTypes.default.string.isRequired
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\create-new-vault\\create-new-vault.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\create-new-vault\\index.js", {"./create-new-vault":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\create-new-vault\\create-new-vault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Ccreate-new-vault%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _createNewVault.default;
  }
});
var _createNewVault = _interopRequireDefault(require("./create-new-vault"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\create-new-vault\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\currency-input\\currency-input.js", {"../../../../shared/constants/common":"D:\\code\\v\\metamask-extension\\shared\\constants\\common.ts","../../../../shared/modules/Numeric":"D:\\code\\v\\metamask-extension\\shared\\modules\\Numeric.ts","../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/confirm-tx.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\confirm-tx.util.ts","../../../hooks/useIsOriginalNativeTokenSymbol":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useIsOriginalNativeTokenSymbol.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/currency-display":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\currency-display\\index.js","../../ui/unit-input":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\unit-input\\index.js","./hooks/useProcessNewDecimalValue":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\currency-input\\hooks\\useProcessNewDecimalValue.tsx","./hooks/useStateWithFirstTouch":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\currency-input\\hooks\\useStateWithFirstTouch.tsx","./hooks/useTokenExchangeRate":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\currency-input\\hooks\\useTokenExchangeRate.tsx","bignumber.js":"D:\\code\\v\\metamask-extension\\node_modules\\bignumber.js\\bignumber.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Ccurrency-input%5Ccurrency-input.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = CurrencyInput;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRedux = require("react-redux");
var _bignumber = _interopRequireDefault(require("bignumber.js"));
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _unitInput = _interopRequireDefault(require("../../ui/unit-input"));
var _currencyDisplay = _interopRequireDefault(require("../../ui/currency-display"));
var _metamask = require("../../../ducks/metamask/metamask");
var _networks = require("../../../../shared/modules/selectors/networks");
var _selectors = require("../../../selectors");
var _common = require("../../../../shared/constants/common");
var _Numeric = require("../../../../shared/modules/Numeric");
var _useIsOriginalNativeTokenSymbol = require("../../../hooks/useIsOriginalNativeTokenSymbol");
var _confirmTx = require("../../../helpers/utils/confirm-tx.util");
var _useTokenExchangeRate = _interopRequireDefault(require("./hooks/useTokenExchangeRate"));
var _useProcessNewDecimalValue = _interopRequireDefault(require("./hooks/useProcessNewDecimalValue"));
var _useStateWithFirstTouch = _interopRequireDefault(require("./hooks/useStateWithFirstTouch"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NATIVE_CURRENCY_DECIMALS = 18;
const LARGE_SYMBOL_LENGTH = 7;

/**
 * Component that allows user to enter currency values as a number, and props receive a converted
 * hex value in WEI. props.value, used as a default or forced value, should be a hex value, which
 * gets converted into a decimal value depending on the currency (ETH or Fiat).
 *
 * @param options0
 * @param options0.hexValue
 * @param options0.isFiatPreferred
 * @param options0.onChange
 * @param options0.onPreferenceToggle
 * @param options0.swapIcon
 * @param options0.className
 * @param options0.asset
 * @param options0.isSkeleton
 * @param options0.isMatchingUpstream
 */
function CurrencyInput({
  hexValue,
  isFiatPreferred,
  onChange,
  onPreferenceToggle,
  swapIcon,
  className = '',
  // if null, the asset is the native currency
  asset,
  isSkeleton,
  isMatchingUpstream
}) {
  const assetDecimals = isNaN(Number(asset === null || asset === void 0 ? void 0 : asset.decimals)) ? NATIVE_CURRENCY_DECIMALS : Number(asset === null || asset === void 0 ? void 0 : asset.decimals);
  const preferredCurrency = (0, _reactRedux.useSelector)(_metamask.getNativeCurrency);
  const secondaryCurrency = (0, _reactRedux.useSelector)(_metamask.getCurrentCurrency);
  const primarySuffix = (asset === null || asset === void 0 ? void 0 : asset.symbol) || preferredCurrency || _common.EtherDenomination.ETH;
  const secondarySuffix = secondaryCurrency.toUpperCase();
  const isLongSymbol = ((primarySuffix === null || primarySuffix === void 0 ? void 0 : primarySuffix.length) || 0) > LARGE_SYMBOL_LENGTH;
  const isFiatAvailable = (0, _reactRedux.useSelector)(_selectors.getShouldShowFiat);
  const shouldUseFiat = isFiatAvailable && isFiatPreferred;
  const isTokenPrimary = !shouldUseFiat;
  const [tokenDecimalValue, setTokenDecimalValue, isInputUnchanged] = (0, _useStateWithFirstTouch.default)('0');
  const [fiatDecimalValue, setFiatDecimalValue] = (0, _react.useState)('0');
  const chainId = (0, _reactRedux.useSelector)(_networks.getCurrentChainId);
  const {
    ticker,
    type,
    rpcUrl
  } = (0, _reactRedux.useSelector)(_networks.getProviderConfig);
  const isOriginalNativeSymbol = (0, _useIsOriginalNativeTokenSymbol.useIsOriginalNativeTokenSymbol)(chainId, ticker, type, rpcUrl);
  const inputRef = (0, _react.useRef)();
  const tokenToFiatConversionRate = (0, _useTokenExchangeRate.default)(asset === null || asset === void 0 ? void 0 : asset.address);
  const isNonZeroConversionRate = Boolean(tokenToFiatConversionRate === null || tokenToFiatConversionRate === void 0 ? void 0 : tokenToFiatConversionRate.toNumber());
  const processNewDecimalValue = (0, _useProcessNewDecimalValue.default)(assetDecimals, isTokenPrimary, tokenToFiatConversionRate);
  const isDisabled = onChange === undefined;
  const swap = async () => {
    await onPreferenceToggle();
  };

  // if the conversion rate is undefined, do not allow a fiat input
  (0, _react.useEffect)(() => {
    if (isTokenPrimary) {
      return;
    }
    if (!isNonZeroConversionRate) {
      onPreferenceToggle();
    }
  }, [isNonZeroConversionRate, isTokenPrimary, onPreferenceToggle]);
  const handleChange = newDecimalValue => {
    const {
      newTokenDecimalValue,
      newFiatDecimalValue
    } = processNewDecimalValue(newDecimalValue);
    setTokenDecimalValue(newTokenDecimalValue);
    setFiatDecimalValue(newFiatDecimalValue);
    onChange(new _Numeric.Numeric(newTokenDecimalValue, 10).times(Math.pow(10, assetDecimals), 10).toPrefixedHexString(), newTokenDecimalValue);
  };
  const timeoutRef = (0, _react.useRef)(null);
  // align input to upstream value
  (0, _react.useEffect)(() => {
    const decimalizedHexValue = new _Numeric.Numeric(hexValue, 16).toBase(10).shiftedBy(assetDecimals).toString();
    if (Number(decimalizedHexValue) === Number(tokenDecimalValue)) {
      return;
    }

    // if input is disabled or the input hasn't changed, the value is upstream (i.e., based on the raw token value)
    const isUpstreamValue = isDisabled || isInputUnchanged || isMatchingUpstream;
    const {
      newTokenDecimalValue,
      newFiatDecimalValue
    } = processNewDecimalValue(decimalizedHexValue, isUpstreamValue ? true : undefined);
    setTokenDecimalValue(newTokenDecimalValue);
    setFiatDecimalValue(newFiatDecimalValue);

    // timeout intentionally not cleared after render so this always runs
    if (timeoutRef.current) {
      clearTimeout(timeoutRef.current);
    }
    timeoutRef.current = setTimeout(() => {
      var _inputRef$current, _inputRef$current$upd;
      return (_inputRef$current = inputRef.current) === null || _inputRef$current === void 0 || (_inputRef$current$upd = _inputRef$current.updateIsOverflowing) === null || _inputRef$current$upd === void 0 ? void 0 : _inputRef$current$upd.call(_inputRef$current);
    }, 500);

    // tokenDecimalValue does not need to be in here, since this side effect is only for upstream updates
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [hexValue, asset === null || asset === void 0 ? void 0 : asset.address, processNewDecimalValue, isTokenPrimary, assetDecimals, isDisabled]);
  const renderSwapButton = () => {
    if (swapIcon) {
      return swapIcon(swap);
    }
    if (!isOriginalNativeSymbol) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement("button", {
      className: "currency-input__swap-component",
      "data-testid": "currency-swap",
      onClick: swap
    }, /*#__PURE__*/_react.default.createElement("i", {
      className: "fa fa-retweet fa-lg"
    }));
  };
  const renderConversionComponent = () => {
    let suffix, displayValue;
    if (!isFiatAvailable || !tokenToFiatConversionRate) {
      return null;
    }
    if (!isOriginalNativeSymbol) {
      return null;
    }
    if (isTokenPrimary) {
      // Display fiat; `displayValue` bypasses calculations
      const isNonZeroSmallValue = fiatDecimalValue && new _bignumber.default(fiatDecimalValue).lt(new _bignumber.default(0.01)) && new _bignumber.default(fiatDecimalValue).greaterThan(new _bignumber.default(0));
      displayValue = isNonZeroSmallValue ? `< ${(0, _confirmTx.formatCurrency)(new _Numeric.Numeric('0.01', 10).toString(), secondaryCurrency)}` : (0, _confirmTx.formatCurrency)(new _Numeric.Numeric(fiatDecimalValue, 10).toString(), secondaryCurrency);
    } else {
      // Display token
      suffix = primarySuffix;
      displayValue = new _Numeric.Numeric(tokenDecimalValue, 10).toString();
    }
    return /*#__PURE__*/_react.default.createElement(_currencyDisplay.default
    // hides the fiat suffix
    , {
      hideLabel: isTokenPrimary || isLongSymbol,
      suffix: suffix,
      className: "currency-input__conversion-component",
      displayValue: displayValue
    });
  };
  return isSkeleton ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingRight: 4,
    className: "currency-input__skeleton-container"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    width: _designSystem.BlockSize.Half,
    className: "currency-input__pulsing-bar"
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    width: _designSystem.BlockSize.OneThird,
    className: "currency-input__pulsing-bar"
  })) : /*#__PURE__*/_react.default.createElement(_unitInput.default, {
    ref: inputRef,
    isDisabled: isDisabled,
    isFocusOnInput: !isDisabled,
    hideSuffix: isTokenPrimary && isLongSymbol,
    dataTestId: "currency-input",
    suffix: isTokenPrimary ? primarySuffix : secondarySuffix,
    onChange: handleChange,
    value: isTokenPrimary ? tokenDecimalValue : fiatDecimalValue,
    className: className,
    actionComponent: isFiatAvailable && tokenToFiatConversionRate ? renderSwapButton() : undefined
  }, renderConversionComponent());
}
CurrencyInput.propTypes = {
  hexValue: _propTypes.default.string,
  isFiatPreferred: _propTypes.default.bool,
  onChange: _propTypes.default.func,
  onPreferenceToggle: _propTypes.default.func,
  swapIcon: _propTypes.default.func,
  className: _propTypes.default.string,
  asset: _propTypes.default.shape({
    address: _propTypes.default.string,
    symbol: _propTypes.default.string,
    decimals: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),
    isERC721: _propTypes.default.bool
  }),
  isSkeleton: _propTypes.default.bool,
  isMatchingUpstream: _propTypes.default.bool
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\currency-input\\currency-input.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\currency-input\\hooks\\useProcessNewDecimalValue.tsx", {"../../../../../shared/modules/Numeric":"D:\\code\\v\\metamask-extension\\shared\\modules\\Numeric.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Ccurrency-input%5Chooks%5CuseProcessNewDecimalValue.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useProcessNewDecimalValue;
var _react = require("react");
var _Numeric = require("../../../../../shared/modules/Numeric");
const MAX_DECIMALS_TOKEN_SECONDARY = 6;

/**
 * A hook that creates a function which processes a new decimal value and returns the new fiat and token decimal values
 *
 * @param assetDecimals - The number of decimals that asset supports
 * @param isTokenPrimary - If the token is the input currency
 * @param tokenToFiatConversionRate - The conversion rate from the asset to the user's fiat currency
 * @returns A function that processes a new decimal value and returns the new fiat and token decimal values
 */
function useProcessNewDecimalValue(assetDecimals, isTokenPrimary, tokenToFiatConversionRate) {
  return (0, _react.useCallback)((newDecimalValue, isTokenPrimaryOverride) => {
    let newFiatDecimalValue, newTokenDecimalValue;
    const truncateToDecimals = (numeric, maxDecimals = assetDecimals) => {
      const digitsAfterDecimal = numeric.toString().split('.')[1] || '';
      const maxPossibleDecimals = Math.min(maxDecimals, assetDecimals);
      const digitsCutoff = Math.min(digitsAfterDecimal.length, maxPossibleDecimals);
      return numeric.toFixed(digitsCutoff);
    };
    const numericDecimalValue = new _Numeric.Numeric(newDecimalValue, 10);
    if (isTokenPrimaryOverride ?? isTokenPrimary) {
      newFiatDecimalValue = tokenToFiatConversionRate ? numericDecimalValue.times(tokenToFiatConversionRate).toFixed(2) : undefined;
      newTokenDecimalValue = truncateToDecimals(numericDecimalValue);
    } else {
      newFiatDecimalValue = numericDecimalValue.toFixed(2);
      newTokenDecimalValue = tokenToFiatConversionRate ? truncateToDecimals(numericDecimalValue.divide(tokenToFiatConversionRate), MAX_DECIMALS_TOKEN_SECONDARY) : undefined;
    }
    return {
      newFiatDecimalValue,
      newTokenDecimalValue
    };
  }, [tokenToFiatConversionRate === null || tokenToFiatConversionRate === void 0 ? void 0 : tokenToFiatConversionRate.toString(), isTokenPrimary, assetDecimals]);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\currency-input\\hooks\\useProcessNewDecimalValue.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\currency-input\\hooks\\useStateWithFirstTouch.tsx", {"react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Ccurrency-input%5Chooks%5CuseStateWithFirstTouch.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useStateWithFirstTouch;
var _react = require("react");
// symbol to cover edge case where initial value is literally 'INITIAL_VALUE'
const INITIAL_VALUE = Symbol('INITIAL_VALUE');

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function useStateWithFirstTouch(initialValue) {
  const [rawValue, setValue] = (0, _react.useState)(INITIAL_VALUE);
  const value = rawValue === INITIAL_VALUE ? initialValue : rawValue;
  const isUnchanged = rawValue === INITIAL_VALUE;
  return [value, setValue, isUnchanged];
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\currency-input\\hooks\\useStateWithFirstTouch.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\currency-input\\hooks\\useTokenExchangeRate.tsx", {"../../../../../shared/modules/Numeric":"D:\\code\\v\\metamask-extension\\shared\\modules\\Numeric.ts","../../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","ethereumjs-util":"D:\\code\\v\\metamask-extension\\node_modules\\ethereumjs-util\\dist.browser\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Ccurrency-input%5Chooks%5CuseTokenExchangeRate.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useTokenExchangeRate;
var _react = require("react");
var _ethereumjsUtil = require("ethereumjs-util");
var _reactRedux = require("react-redux");
var _networks = require("../../../../../shared/modules/selectors/networks");
var _selectors = require("../../../../selectors");
var _Numeric = require("../../../../../shared/modules/Numeric");
var _metamask = require("../../../../ducks/metamask/metamask");
var _util = require("../../../../helpers/utils/util");
const LOADING = 'loading';
const FAILED = 'failed';

/**
 * A hook that returns the exchange rate of the given token –– assumes native if no token address is passed.
 *
 * @param uncheckedTokenAddress - the address of the token. If not provided, the function will return the native exchange rate.
 * @returns the exchange rate of the token
 */
function useTokenExchangeRate(uncheckedTokenAddress) {
  const tokenAddress = uncheckedTokenAddress ? (0, _ethereumjsUtil.toChecksumAddress)(uncheckedTokenAddress) : undefined;
  const nativeCurrency = (0, _reactRedux.useSelector)(_metamask.getNativeCurrency);
  const chainId = (0, _reactRedux.useSelector)(_networks.getCurrentChainId);
  const selectedNativeConversionRate = (0, _reactRedux.useSelector)(_metamask.getConversionRate);
  const contractExchangeRates = (0, _reactRedux.useSelector)(_selectors.getTokenExchangeRates, _reactRedux.shallowEqual);
  const [exchangeRates, setExchangeRates] = (0, _react.useState)({});
  return (0, _react.useMemo)(() => {
    if (!selectedNativeConversionRate) {
      return undefined;
    }
    const nativeConversionRate = new _Numeric.Numeric(selectedNativeConversionRate, 10);
    if (!tokenAddress) {
      return nativeConversionRate;
    }
    const isLoadingOrUnavailable = tokenAddress ? [LOADING, FAILED].includes(exchangeRates[tokenAddress]) : false;
    if (isLoadingOrUnavailable) {
      return undefined;
    }
    const contractExchangeRate = contractExchangeRates[tokenAddress] || exchangeRates[tokenAddress];
    if (!contractExchangeRate) {
      setExchangeRates(prev => ({
        ...prev,
        [tokenAddress]: LOADING
      }));
      (0, _util.fetchTokenExchangeRates)(nativeCurrency, [tokenAddress], chainId).then(addressToExchangeRate => {
        setExchangeRates(prev => ({
          ...prev,
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
          // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
          [tokenAddress]: addressToExchangeRate[tokenAddress] || FAILED
        }));
      }).catch(() => {
        setExchangeRates(prev => ({
          ...prev,
          [tokenAddress]: FAILED
        }));
      });
      return undefined;
    }
    return new _Numeric.Numeric(contractExchangeRate, 10).times(nativeConversionRate);
  }, [exchangeRates, chainId, nativeCurrency, tokenAddress, selectedNativeConversionRate, contractExchangeRates]);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\currency-input\\hooks\\useTokenExchangeRate.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\currency-input\\index.js", {"./currency-input":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\currency-input\\currency-input.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Ccurrency-input%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _currencyInput.default;
  }
});
var _currencyInput = _interopRequireDefault(require("./currency-input"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\currency-input\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\data-deletion-error-modal\\data-deletion-error-modal.tsx", {"../../../ducks/app/app":"D:\\code\\v\\metamask-extension\\ui\\ducks\\app\\app.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cdata-deletion-error-modal%5Cdata-deletion-error-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = DataDeletionErrorModal;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _componentLibrary = require("../../component-library");
var _app = require("../../../ducks/app/app");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function DataDeletionErrorModal() {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  function closeModal() {
    dispatch((0, _app.hideDataDeletionErrorModal)());
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    onClose: closeModal,
    isOpen: true
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, {
    modalDialogProps: {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    paddingBottom: 4,
    paddingRight: 6,
    paddingLeft: 6,
    onClose: closeModal
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    size: _componentLibrary.IconSize.Xl,
    name: _componentLibrary.IconName.Danger,
    color: _designSystem.IconColor.warningDefault
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingSm,
    textAlign: _designSystem.TextAlign.Center
  }, t('deleteMetaMetricsDataErrorTitle')))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 6,
    paddingRight: 6,
    display: _designSystem.Display.Flex,
    gap: 4,
    flexDirection: _designSystem.FlexDirection.Column
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    textAlign: _designSystem.TextAlign.Justify
  }, t('deleteMetaMetricsDataErrorDesc'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalFooter, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    size: _componentLibrary.ButtonSize.Lg,
    width: _designSystem.BlockSize.Full,
    variant: _componentLibrary.ButtonVariant.Primary,
    onClick: closeModal
  }, t('ok'))))));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\data-deletion-error-modal\\data-deletion-error-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\data-deletion-error-modal\\index.ts", {"./data-deletion-error-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\data-deletion-error-modal\\data-deletion-error-modal.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cdata-deletion-error-modal%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _dataDeletionErrorModal.default;
  }
});
var _dataDeletionErrorModal = _interopRequireDefault(require("./data-deletion-error-modal"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\data-deletion-error-modal\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\detected-token\\detected-token-address\\detected-token-address.js", {"../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../../hooks/useCopyToClipboard":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useCopyToClipboard.js","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../ui/tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cdetected-token%5Cdetected-token-address%5Cdetected-token-address.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _useCopyToClipboard = require("../../../../hooks/useCopyToClipboard");
var _tooltip = _interopRequireDefault(require("../../../ui/tooltip"));
var _designSystem = require("../../../../helpers/constants/design-system");
var _util = require("../../../../helpers/utils/util");
var _componentLibrary = require("../../../component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const DetectedTokenAddress = ({
  tokenAddress
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const [copied, handleCopy] = (0, _useCopyToClipboard.useCopyToClipboard)();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.InlineFlex,
    className: "detected-token-address"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textDefault
  }, `${t('tokenAddress')}:`), /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    position: "bottom",
    title: copied ? t('copiedExclamation') : t('copyToClipboard')
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    className: "detected-token-address__copy-link",
    onClick: () => {
      handleCopy(tokenAddress);
    },
    endIconName: _componentLibrary.IconName.Copy,
    marginLeft: 2,
    marginRight: 2
  }, (0, _util.shortenAddress)(tokenAddress))));
};
DetectedTokenAddress.propTypes = {
  tokenAddress: _propTypes.default.string
};
var _default = exports.default = DetectedTokenAddress;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\detected-token\\detected-token-address\\detected-token-address.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\detected-token\\detected-token-aggregators\\detected-token-aggregators.js", {"../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cdetected-token%5Cdetected-token-aggregators%5Cdetected-token-aggregators.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _designSystem = require("../../../../helpers/constants/design-system");
var _componentLibrary = require("../../../component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NUMBER_OF_AGGREGATORS_TO_DISPLAY = 2;
const DetectedTokenAggregators = ({
  aggregators
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const numOfHiddenAggregators = parseInt(aggregators.length, 10) - NUMBER_OF_AGGREGATORS_TO_DISPLAY;
  const [displayMore, setDisplayMore] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.InlineFlex,
    className: "detected-token-aggregators"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    as: "h6",
    fontWeight: _designSystem.FontWeight.Normal
  }, t('fromTokenLists', [numOfHiddenAggregators > 0 && !displayMore ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "h6",
    fontWeight: _designSystem.FontWeight.Normal,
    key: "detected-token-aggrgators-with-more"
  }, `${aggregators.slice(0, NUMBER_OF_AGGREGATORS_TO_DISPLAY).join(', ')}`, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    className: "detected-token-aggregators__link",
    onClick: () => setDisplayMore(true),
    key: "detected-token-aggrgators-link"
  }, t('plusXMore', [numOfHiddenAggregators]))) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "h6",
    fontWeight: _designSystem.FontWeight.Normal,
    key: "detected-token-aggrgators-without-more"
  }, `${aggregators.join(', ')}.`)])));
};
DetectedTokenAggregators.propTypes = {
  aggregators: _propTypes.default.array.isRequired
};
var _default = exports.default = DetectedTokenAggregators;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\detected-token\\detected-token-aggregators\\detected-token-aggregators.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\detected-token\\detected-token-details\\detected-token-details.js", {"../../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../detected-token-address/detected-token-address":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\detected-token\\detected-token-address\\detected-token-address.js","../detected-token-aggregators/detected-token-aggregators":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\detected-token\\detected-token-aggregators\\detected-token-aggregators.js","../detected-token-values/detected-token-values":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\detected-token\\detected-token-values\\detected-token-values.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cdetected-token%5Cdetected-token-details%5Cdetected-token-details.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRedux = require("react-redux");
var _componentLibrary = require("../../../component-library");
var _detectedTokenValues = _interopRequireDefault(require("../detected-token-values/detected-token-values"));
var _detectedTokenAddress = _interopRequireDefault(require("../detected-token-address/detected-token-address"));
var _detectedTokenAggregators = _interopRequireDefault(require("../detected-token-aggregators/detected-token-aggregators"));
var _designSystem = require("../../../../helpers/constants/design-system");
var _selectors = require("../../../../selectors");
var _network = require("../../../../../shared/constants/network");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const DetectedTokenDetails = ({
  token,
  handleTokenSelection,
  tokensListDetected,
  chainId
}) => {
  var _token$address;
  const tokenList = (0, _reactRedux.useSelector)(_selectors.getTokenList);
  const tokenData = tokenList[(_token$address = token.address) === null || _token$address === void 0 ? void 0 : _token$address.toLowerCase()];
  const testNetworkBackgroundColor = (0, _reactRedux.useSelector)(_selectors.getTestNetworkBackgroundColor);
  const currentNetwork = (0, _reactRedux.useSelector)(_selectors.getCurrentNetwork);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    className: "detected-token-details",
    marginBottom: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.BadgeWrapper, {
    badge: /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
      size: _componentLibrary.AvatarNetworkSize.Xs,
      src: _network.CHAIN_ID_TO_NETWORK_IMAGE_URL_MAP[chainId],
      name: (currentNetwork === null || currentNetwork === void 0 ? void 0 : currentNetwork.nickname) || '',
      backgroundColor: testNetworkBackgroundColor,
      borderWidth: 2
    }),
    marginRight: 2,
    className: "detected-token-details__identicon"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarToken, {
    name: token.symbol,
    src: token.image,
    size: _componentLibrary.AvatarTokenSize.Md
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Grid,
    marginLeft: 2,
    className: "detected-token-details__data"
  }, /*#__PURE__*/_react.default.createElement(_detectedTokenValues.default, {
    token: token,
    handleTokenSelection: handleTokenSelection,
    tokensListDetected: tokensListDetected
  }), /*#__PURE__*/_react.default.createElement(_detectedTokenAddress.default, {
    tokenAddress: token.address
  }), (tokenData === null || tokenData === void 0 ? void 0 : tokenData.aggregators.length) > 0 && /*#__PURE__*/_react.default.createElement(_detectedTokenAggregators.default, {
    aggregators: tokenData === null || tokenData === void 0 ? void 0 : tokenData.aggregators
  })));
};
DetectedTokenDetails.propTypes = {
  token: _propTypes.default.shape({
    address: _propTypes.default.string.isRequired,
    decimals: _propTypes.default.number,
    symbol: _propTypes.default.string,
    iconUrl: _propTypes.default.string,
    aggregators: _propTypes.default.array,
    image: _propTypes.default.string
  }),
  handleTokenSelection: _propTypes.default.func.isRequired,
  tokensListDetected: _propTypes.default.object,
  chainId: _propTypes.default.string
};
var _default = exports.default = DetectedTokenDetails;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\detected-token\\detected-token-details\\detected-token-details.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\detected-token\\detected-token-ignored-popover\\detected-token-ignored-popover.js", {"../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../component-library/modal-content/deprecated":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\modal-content\\deprecated\\index.ts","../../../component-library/modal-header/deprecated":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\modal-header\\deprecated\\index.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cdetected-token%5Cdetected-token-ignored-popover%5Cdetected-token-ignored-popover.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _designSystem = require("../../../../helpers/constants/design-system");
var _componentLibrary = require("../../../component-library");
var _deprecated = require("../../../component-library/modal-content/deprecated");
var _deprecated2 = require("../../../component-library/modal-header/deprecated");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const DetectedTokenIgnoredPopover = ({
  partiallyIgnoreDetectedTokens,
  onCancelIgnore,
  handleClearTokensSelection,
  isOpen
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: isOpen,
    className: (0, _classnames.default)('detected-token-ignored-popover', {
      'detected-token-ignored-popover--import': partiallyIgnoreDetectedTokens,
      'detected-token-ignored-popover--ignore': !partiallyIgnoreDetectedTokens
    }),
    onClose: onCancelIgnore,
    autoFocus: false
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_deprecated.ModalContent, null, /*#__PURE__*/_react.default.createElement(_deprecated2.ModalHeader, {
    marginBottom: 4
  }, partiallyIgnoreDetectedTokens ? t('importSelectedTokens') : t('areYouSure')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    marginBottom: 4
  }, partiallyIgnoreDetectedTokens ? t('importSelectedTokensDescription') : t('ignoreTokenWarning')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    className: "detected-token-ignored-popover__ignore-button",
    block: true,
    variant: _componentLibrary.BUTTON_VARIANT.SECONDARY,
    onClick: onCancelIgnore,
    size: _componentLibrary.BUTTON_SIZES.LG
  }, t('cancel')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    className: "detected-token-ignored-popover__import-button",
    block: true,
    variant: _componentLibrary.BUTTON_VARIANT.PRIMARY,
    onClick: handleClearTokensSelection,
    size: _componentLibrary.BUTTON_SIZES.LG,
    "data-testid": "detected-token-ignored-popover-confirm-button"
  }, t('confirm')))));
};
DetectedTokenIgnoredPopover.propTypes = {
  partiallyIgnoreDetectedTokens: _propTypes.default.bool.isRequired,
  onCancelIgnore: _propTypes.default.func.isRequired,
  handleClearTokensSelection: _propTypes.default.func.isRequired,
  isOpen: _propTypes.default.bool.isRequired
};
var _default = exports.default = DetectedTokenIgnoredPopover;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\detected-token\\detected-token-ignored-popover\\detected-token-ignored-popover.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\detected-token\\detected-token-selection-popover\\detected-token-selection-popover.js", {"../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../ui/box":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\box\\index.js","../../../ui/popover":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\popover\\index.js","../detected-token-details/detected-token-details":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\detected-token\\detected-token-details\\detected-token-details.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cdetected-token%5Cdetected-token-selection-popover%5Cdetected-token-selection-popover.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRedux = require("react-redux");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _metametrics = require("../../../../contexts/metametrics");
var _metametrics2 = require("../../../../../shared/constants/metametrics");
var _selectors = require("../../../../selectors");
var _popover = _interopRequireDefault(require("../../../ui/popover"));
var _box = _interopRequireDefault(require("../../../ui/box"));
var _componentLibrary = require("../../../component-library");
var _detectedTokenDetails = _interopRequireDefault(require("../detected-token-details/detected-token-details"));
var _trace = require("../../../../../shared/lib/trace");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DetectedTokenSelectionPopover = ({
  tokensListDetected,
  handleTokenSelection,
  onImport,
  onIgnoreAll,
  setShowDetectedTokens,
  sortingBasedOnTokenSelection
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const detectedTokens = (0, _reactRedux.useSelector)(_selectors.getDetectedTokensInCurrentNetwork);
  const isTokenNetworkFilterEqualCurrentNetwork = (0, _reactRedux.useSelector)(_selectors.getIsTokenNetworkFilterEqualCurrentNetwork);
  const currentNetwork = (0, _reactRedux.useSelector)(_selectors.getCurrentNetwork);
  const detectedTokensMultichain = (0, _reactRedux.useSelector)(_selectors.getAllDetectedTokensForSelectedAddress);
  const totalTokens = (0, _react.useMemo)(() => {
    return isTokenNetworkFilterEqualCurrentNetwork ? detectedTokens.length : Object.values(detectedTokensMultichain).reduce((count, tokenArray) => count + tokenArray.length, 0);
  }, [detectedTokensMultichain, detectedTokens, isTokenNetworkFilterEqualCurrentNetwork]);
  const {
    selected: selectedTokens = []
  } = sortingBasedOnTokenSelection(tokensListDetected);
  const onClose = () => {
    const chainIds = Object.keys(detectedTokensMultichain);
    setShowDetectedTokens(false);
    const eventTokensDetails = detectedTokens.map(({
      address,
      symbol
    }) => `${symbol} - ${address}`);
    trackEvent({
      event: _metametrics2.MetaMetricsEventName.TokenImportCanceled,
      category: _metametrics2.MetaMetricsEventCategory.Wallet,
      properties: {
        source_connection_method: _metametrics2.MetaMetricsTokenEventSource.Detected,
        tokens: eventTokensDetails,
        chain_ids: chainIds
      }
    });
  };
  const footer = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    className: "detected-token-selection-popover__ignore-button",
    variant: _componentLibrary.ButtonVariant.Secondary,
    block: true,
    onClick: () => onIgnoreAll()
  }, t('ignoreAll')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    className: "detected-token-selection-popover__import-button",
    variant: _componentLibrary.ButtonVariant.Primary,
    block: true,
    onClick: () => {
      (0, _trace.endTrace)({
        name: _trace.TraceName.AccountOverviewAssetListTab
      });
      (0, _trace.trace)({
        name: _trace.TraceName.AccountOverviewAssetListTab
      });
      onImport();
    },
    disabled: selectedTokens.length === 0
  }, t('importWithCount', [`(${selectedTokens.length})`])));
  return /*#__PURE__*/_react.default.createElement(_popover.default, {
    className: "detected-token-selection-popover",
    title: totalTokens === 1 ? t('tokenFoundTitle') : t('tokensFoundTitle', [totalTokens]),
    onClose: onClose,
    footer: footer
  }, isTokenNetworkFilterEqualCurrentNetwork ? /*#__PURE__*/_react.default.createElement(_box.default, {
    margin: 3
  }, detectedTokens.map((token, index) => {
    return /*#__PURE__*/_react.default.createElement(_detectedTokenDetails.default, {
      key: index,
      token: token,
      handleTokenSelection: handleTokenSelection,
      tokensListDetected: tokensListDetected,
      chainId: currentNetwork.chainId
    });
  })) : /*#__PURE__*/_react.default.createElement(_box.default, {
    margin: 3
  }, Object.entries(detectedTokensMultichain).map(([networkId, tokens]) => {
    return tokens.map((token, index) => /*#__PURE__*/_react.default.createElement(_detectedTokenDetails.default, {
      key: `${networkId}-${index}`,
      token: token,
      chainId: networkId,
      handleTokenSelection: handleTokenSelection,
      tokensListDetected: tokensListDetected
    }));
  })));
};
DetectedTokenSelectionPopover.propTypes = {
  tokensListDetected: _propTypes.default.object,
  handleTokenSelection: _propTypes.default.func.isRequired,
  onIgnoreAll: _propTypes.default.func.isRequired,
  onImport: _propTypes.default.func.isRequired,
  setShowDetectedTokens: _propTypes.default.func.isRequired,
  sortingBasedOnTokenSelection: _propTypes.default.func.isRequired
};
var _default = exports.default = DetectedTokenSelectionPopover;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\detected-token\\detected-token-selection-popover\\detected-token-selection-popover.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\detected-token\\detected-token-values\\detected-token-values.js", {"../../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useTokenBalances":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTokenBalances.ts","../../../../hooks/useTokenFiatAmount":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTokenFiatAmount.js","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cdetected-token%5Cdetected-token-values%5Cdetected-token-values.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRedux = require("react-redux");
var _designSystem = require("../../../../helpers/constants/design-system");
var _useTokenFiatAmount = require("../../../../hooks/useTokenFiatAmount");
var _networks = require("../../../../../shared/modules/selectors/networks");
var _selectors = require("../../../../selectors");
var _componentLibrary = require("../../../component-library");
var _useTokenBalances = require("../../../../hooks/useTokenBalances");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DetectedTokenValues = ({
  token,
  handleTokenSelection,
  tokensListDetected
}) => {
  var _tokensWithBalances$;
  const [tokenSelection, setTokenSelection] = (0, _react.useState)(() => {
    var _tokensListDetected$t;
    return (_tokensListDetected$t = tokensListDetected[token.address]) === null || _tokensListDetected$t === void 0 ? void 0 : _tokensListDetected$t.selected;
  });
  const selectedAddress = (0, _reactRedux.useSelector)(_selectors.getSelectedAddress);
  const currentChainId = (0, _reactRedux.useSelector)(_networks.getCurrentChainId);
  const chainId = token.chainId ?? currentChainId;
  const {
    tokensWithBalances
  } = (0, _useTokenBalances.useTokenTracker)({
    chainId,
    tokens: [token],
    address: selectedAddress,
    hideZeroBalanceTokens: false
  });
  const balanceString = (_tokensWithBalances$ = tokensWithBalances[0]) === null || _tokensWithBalances$ === void 0 ? void 0 : _tokensWithBalances$.string;
  const formattedFiatBalance = (0, _useTokenFiatAmount.useTokenFiatAmount)(token.address, balanceString, token.symbol, {}, false, chainId);
  const useCurrencyRateCheck = (0, _reactRedux.useSelector)(_selectors.getUseCurrencyRateCheck);
  (0, _react.useEffect)(() => {
    var _tokensListDetected$t2;
    setTokenSelection((_tokensListDetected$t2 = tokensListDetected[token.address]) === null || _tokensListDetected$t2 === void 0 ? void 0 : _tokensListDetected$t2.selected);
  }, [tokensListDetected, token.address, tokenSelection, setTokenSelection]);
  const handleCheckBoxSelection = () => {
    setTokenSelection(!tokenSelection);
    handleTokenSelection(token);
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.InlineFlex,
    className: "detected-token-values"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginBottom: 1
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyLgMedium,
    as: "h4"
  }, `${balanceString || '0'} ${token.symbol}`), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    as: "h6",
    color: _designSystem.TextColor.textAlternative
  }, useCurrencyRateCheck ? formattedFiatBalance || '$0' // since formattedFiatBalance will be when the conversion rate is not obtained, should replace the `$0` with `N/A`
  : formattedFiatBalance)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "detected-token-values__checkbox"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Checkbox, {
    isChecked: tokenSelection,
    onClick: handleCheckBoxSelection
  })));
};
DetectedTokenValues.propTypes = {
  token: _propTypes.default.shape({
    address: _propTypes.default.string.isRequired,
    decimals: _propTypes.default.number,
    symbol: _propTypes.default.string,
    iconUrl: _propTypes.default.string,
    aggregators: _propTypes.default.array,
    chainId: _propTypes.default.string
  }),
  handleTokenSelection: _propTypes.default.func.isRequired,
  tokensListDetected: _propTypes.default.object
};
var _default = exports.default = DetectedTokenValues;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\detected-token\\detected-token-values\\detected-token-values.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\detected-token\\detected-token.js", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./detected-token-ignored-popover/detected-token-ignored-popover":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\detected-token\\detected-token-ignored-popover\\detected-token-ignored-popover.js","./detected-token-selection-popover/detected-token-selection-popover":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\detected-token\\detected-token-selection-popover\\detected-token-selection-popover.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cdetected-token%5Cdetected-token.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRedux = require("react-redux");
var _lodash = require("lodash");
var _actions = require("../../../store/actions");
var _networks = require("../../../../shared/modules/selectors/networks");
var _selectors = require("../../../selectors");
var _metametrics = require("../../../contexts/metametrics");
var _transaction = require("../../../../shared/constants/transaction");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _detectedTokenSelectionPopover = _interopRequireDefault(require("./detected-token-selection-popover/detected-token-selection-popover"));
var _detectedTokenIgnoredPopover = _interopRequireDefault(require("./detected-token-ignored-popover/detected-token-ignored-popover"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const sortingBasedOnTokenSelection = tokensDetected => {
  return (0, _lodash.chain)(tokensDetected)
  // get the values
  .values()
  // create a new object with keys 'selected', 'deselected' and group the tokens
  .groupBy(token => token.selected ? 'selected' : 'deselected')
  // ditch the 'selected' property and get just the tokens'
  .mapValues(group => group.map(({
    token
  }) => {
    const {
      address,
      symbol,
      decimals,
      aggregators,
      chainId
    } = token;
    return {
      address,
      symbol,
      decimals,
      aggregators,
      chainId
    };
  }))
  // Exit the chain and get the underlying value, an object.
  .value();
};
const DetectedToken = ({
  setShowDetectedTokens
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const detectedTokens = (0, _reactRedux.useSelector)(_selectors.getDetectedTokensInCurrentNetwork);
  const networkClientId = (0, _reactRedux.useSelector)(_networks.getSelectedNetworkClientId);
  const detectedTokensMultichain = (0, _reactRedux.useSelector)(_selectors.getAllDetectedTokensForSelectedAddress);
  const currentChainId = (0, _reactRedux.useSelector)(_networks.getCurrentChainId);
  const allNetworks = (0, _reactRedux.useSelector)(_networks.getNetworkConfigurationsByChainId);
  const isTokenNetworkFilterEqualCurrentNetwork = (0, _reactRedux.useSelector)(_selectors.getIsTokenNetworkFilterEqualCurrentNetwork);
  const totalDetectedTokens = (0, _react.useMemo)(() => {
    return "true" && !isTokenNetworkFilterEqualCurrentNetwork ? Object.values(detectedTokensMultichain).flat().length : detectedTokens.length;
  }, [detectedTokens, detectedTokensMultichain, isTokenNetworkFilterEqualCurrentNetwork]);
  const [tokensListDetected, setTokensListDetected] = (0, _react.useState)({});
  (0, _react.useEffect)(() => {
    const newTokensList = () => {
      if ("true" && !isTokenNetworkFilterEqualCurrentNetwork) {
        return Object.entries(detectedTokensMultichain).reduce((acc, [chainId, tokens]) => {
          if (Array.isArray(tokens)) {
            tokens.forEach(token => {
              var _tokensListDetected$t;
              acc[token.address] = {
                token: {
                  ...token,
                  chainId
                },
                selected: ((_tokensListDetected$t = tokensListDetected[token.address]) === null || _tokensListDetected$t === void 0 ? void 0 : _tokensListDetected$t.selected) ?? true
              };
            });
          }
          return acc;
        }, {});
      }
      return detectedTokens.reduce((tokenObj, token) => {
        var _tokensListDetected$t2;
        tokenObj[token.address] = {
          token,
          selected: ((_tokensListDetected$t2 = tokensListDetected[token.address]) === null || _tokensListDetected$t2 === void 0 ? void 0 : _tokensListDetected$t2.selected) ?? true,
          chainId: currentChainId
        };
        return tokenObj;
      }, {});
    };
    setTokensListDetected(newTokensList());
  }, [isTokenNetworkFilterEqualCurrentNetwork, detectedTokensMultichain, detectedTokens, currentChainId]);
  const [showDetectedTokenIgnoredPopover, setShowDetectedTokenIgnoredPopover] = (0, _react.useState)(false);
  const [partiallyIgnoreDetectedTokens, setPartiallyIgnoreDetectedTokens] = (0, _react.useState)(false);
  const importSelectedTokens = async selectedTokens => {
    selectedTokens.forEach(importedToken => {
      trackEvent({
        event: _metametrics2.MetaMetricsEventName.TokenAdded,
        category: _metametrics2.MetaMetricsEventCategory.Wallet,
        sensitiveProperties: {
          token_symbol: importedToken.symbol,
          token_contract_address: importedToken.address,
          token_decimal_precision: importedToken.decimals,
          source: _metametrics2.MetaMetricsTokenEventSource.Detected,
          token_standard: _transaction.TokenStandard.ERC20,
          asset_type: _transaction.AssetType.token,
          token_added_type: 'detected',
          chain_id: importedToken.chainId
        }
      });
    });
    if ("true" && !isTokenNetworkFilterEqualCurrentNetwork) {
      const tokensByChainId = selectedTokens.reduce((acc, token) => {
        const {
          chainId
        } = token;
        if (!acc[chainId]) {
          acc[chainId] = {
            tokens: []
          };
        }
        acc[chainId].tokens.push(token);
        return acc;
      }, {});
      const importPromises = Object.entries(tokensByChainId).map(async ([networkId, {
        tokens
      }]) => {
        const chainConfig = allNetworks[networkId];
        const {
          defaultRpcEndpointIndex
        } = chainConfig;
        const {
          networkClientId: networkInstanceId
        } = chainConfig.rpcEndpoints[defaultRpcEndpointIndex];
        await dispatch((0, _actions.addImportedTokens)(tokens, networkInstanceId));
        const tokenSymbols = tokens.map(({
          symbol
        }) => symbol);
        dispatch((0, _actions.setNewTokensImported)(tokenSymbols.join(', ')));
      });
      await Promise.all(importPromises);
    } else {
      await dispatch((0, _actions.addImportedTokens)(selectedTokens, networkClientId));
      const tokenSymbols = selectedTokens.map(({
        symbol
      }) => symbol);
      dispatch((0, _actions.setNewTokensImported)(tokenSymbols.join(', ')));
    }
  };
  const handleClearTokensSelection = async () => {
    const {
      selected: selectedTokens = [],
      deselected: deSelectedTokens = []
    } = sortingBasedOnTokenSelection(tokensListDetected);
    if (deSelectedTokens.length < totalDetectedTokens) {
      await importSelectedTokens(selectedTokens);
    }
    const tokensDetailsList = deSelectedTokens.map(({
      symbol,
      address
    }) => `${symbol} - ${address}`);
    trackEvent({
      event: _metametrics2.MetaMetricsEventName.TokenHidden,
      category: _metametrics2.MetaMetricsEventCategory.Wallet,
      sensitiveProperties: {
        tokens: tokensDetailsList,
        location: _metametrics2.MetaMetricsEventLocation.TokenDetection,
        token_standard: _transaction.TokenStandard.ERC20,
        asset_type: _transaction.AssetType.token
      }
    });
    if ("true" && !isTokenNetworkFilterEqualCurrentNetwork) {
      // group deselected tokens by chainId
      const groupedByChainId = deSelectedTokens.reduce((acc, token) => {
        const {
          chainId
        } = token;
        if (!acc[chainId]) {
          acc[chainId] = [];
        }
        acc[chainId].push(token);
        return acc;
      }, {});
      const promises = Object.entries(groupedByChainId).map(async ([chainId, tokens]) => {
        const {
          defaultRpcEndpointIndex,
          rpcEndpoints
        } = allNetworks[chainId];
        const networkInstanceId = rpcEndpoints[defaultRpcEndpointIndex].networkClientId;
        const tokensToIgnore = tokens.map(token => token.address);
        await dispatch((0, _actions.ignoreTokens)({
          tokensToIgnore,
          dontShowLoadingIndicator: true,
          networkClientId: networkInstanceId
        }));
      });
      await Promise.all(promises);
      setShowDetectedTokens(false);
      setPartiallyIgnoreDetectedTokens(false);
    } else {
      const deSelectedTokensAddresses = deSelectedTokens.map(({
        address
      }) => address);
      await dispatch((0, _actions.ignoreTokens)({
        tokensToIgnore: deSelectedTokensAddresses,
        dontShowLoadingIndicator: true,
        networkClientId
      }));
      setShowDetectedTokens(false);
      setPartiallyIgnoreDetectedTokens(false);
    }
  };
  const handleTokenSelection = token => {
    setTokensListDetected(prevState => ({
      ...prevState,
      [token.address]: {
        ...prevState[token.address],
        selected: !prevState[token.address].selected
      }
    }));
  };
  const onImport = async () => {
    const {
      selected: selectedTokens = []
    } = sortingBasedOnTokenSelection(tokensListDetected);
    if (selectedTokens.length < totalDetectedTokens) {
      setShowDetectedTokenIgnoredPopover(true);
      setPartiallyIgnoreDetectedTokens(true);
    } else {
      await importSelectedTokens(selectedTokens);
      setShowDetectedTokens(false);
    }
  };
  const onIgnoreAll = () => {
    const newTokensListDetected = {
      ...tokensListDetected
    };
    for (const tokenAddress of Object.keys(tokensListDetected)) {
      newTokensListDetected[tokenAddress].selected = false;
    }
    setTokensListDetected(newTokensListDetected);
    setShowDetectedTokenIgnoredPopover(true);
  };
  const onCancelIgnore = () => {
    setShowDetectedTokenIgnoredPopover(false);
    setPartiallyIgnoreDetectedTokens(false);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showDetectedTokenIgnoredPopover && /*#__PURE__*/_react.default.createElement(_detectedTokenIgnoredPopover.default, {
    isOpen: true,
    onCancelIgnore: onCancelIgnore,
    handleClearTokensSelection: handleClearTokensSelection,
    partiallyIgnoreDetectedTokens: partiallyIgnoreDetectedTokens
  }), totalDetectedTokens > 0 && /*#__PURE__*/_react.default.createElement(_detectedTokenSelectionPopover.default, {
    detectedTokens: "true" ? detectedTokensMultichain : detectedTokens,
    tokensListDetected: tokensListDetected,
    handleTokenSelection: handleTokenSelection,
    onImport: onImport,
    onIgnoreAll: onIgnoreAll,
    setShowDetectedTokens: setShowDetectedTokens,
    sortingBasedOnTokenSelection: sortingBasedOnTokenSelection
  }));
};
DetectedToken.propTypes = {
  setShowDetectedTokens: _propTypes.default.func.isRequired
};
var _default = exports.default = DetectedToken;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\detected-token\\detected-token.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\download-mobile-modal\\download-mobile-modal.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cdownload-mobile-modal%5Cdownload-mobile-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _componentLibrary = require("../../component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const DownloadMobileAppModal = ({
  onClose
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: true,
    onClose: onClose,
    className: "download-mobile-app-modal",
    "data-testid": "download-mobile-app-modal"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, {
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onClose: onClose
  }, t('downloadMetaMaskMobileTitle')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 4,
    paddingRight: 4,
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd
  }, t('downloadMetaMaskMobileDescription')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "download-mobile-app-modal__qr-code-wrapper",
    width: _designSystem.BlockSize.Full,
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.center,
    borderWidth: 1,
    paddingInline: 0,
    paddingTop: 3,
    paddingBottom: 3,
    borderColor: _designSystem.BorderColor.borderMuted,
    style: {
      borderRadius: '16px'
    }
  }, /*#__PURE__*/_react.default.createElement("img", {
    src: "images/download-mobile-app-qr-code.png",
    width: 300,
    height: 300,
    alt: t('downloadMetaMaskMobileTitle'),
    style: {
      alignSelf: 'center'
    }
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    textAlign: _designSystem.TextAlign.Center
  }, t('downloadMetaMaskMobileQrNote')))));
};
var _default = exports.default = DownloadMobileAppModal;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\download-mobile-modal\\download-mobile-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\hold-to-reveal-button\\hold-to-reveal-button.js", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Chold-to-reveal-button%5Chold-to-reveal-button.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = HoldToRevealButton;
var _classnames = _interopRequireDefault(require("classnames"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _metametrics = require("../../../../shared/constants/metametrics");
var _i18n = require("../../../contexts/i18n");
var _metametrics2 = require("../../../contexts/metametrics");
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../component-library");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const radius = 14;
const strokeWidth = 2;
const radiusWithStroke = radius - strokeWidth / 2;
function HoldToRevealButton({
  buttonText,
  onLongPressed
}) {
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const isLongPressing = (0, _react.useRef)(false);
  const [isUnlocking, setIsUnlocking] = (0, _react.useState)(false);
  const [hasTriggeredUnlock, setHasTriggeredUnlock] = (0, _react.useState)(false);
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);

  /**
   * Prevent animation events from propogating up
   *
   * @param e - Native animation event - React.AnimationEvent<HTMLDivElement>
   */
  const preventPropogation = e => {
    e.stopPropagation();
  };

  /**
   * Event for mouse click down
   */
  const onMouseDown = () => {
    isLongPressing.current = true;
    trackEvent({
      category: _metametrics.MetaMetricsEventCategory.Keys,
      event: _metametrics.MetaMetricsEventName.SrpHoldToRevealClickStarted,
      properties: {
        key_type: _metametrics.MetaMetricsEventKeyType.Srp
      }
    });
  };

  /**
   * Event for mouse click up
   */
  const onMouseUp = () => {
    isLongPressing.current = false;
  };

  /**
   * 1. Progress cirle completed. Begin next animation phase (Shrink halo and show unlocked padlock)
   */
  const onProgressComplete = () => {
    isLongPressing.current && setIsUnlocking(true);
  };

  /**
   * 2. Trigger onLongPressed callback. Begin next animation phase (Shrink unlocked padlock and fade in original content)
   *
   * @param e - Native animation event - React.AnimationEvent<HTMLDivElement>
   */
  const triggerOnLongPressed = (0, _react.useCallback)(e => {
    trackEvent({
      category: _metametrics.MetaMetricsEventCategory.Keys,
      event: _metametrics.MetaMetricsEventName.SrpHoldToRevealCompleted,
      properties: {
        key_type: _metametrics.MetaMetricsEventKeyType.Srp
      }
    });
    trackEvent({
      category: _metametrics.MetaMetricsEventCategory.Keys,
      event: _metametrics.MetaMetricsEventName.SrpRevealViewed,
      properties: {
        key_type: _metametrics.MetaMetricsEventKeyType.Srp
      }
    });
    onLongPressed();
    setHasTriggeredUnlock(true);
    preventPropogation(e);
  }, [onLongPressed, trackEvent]);

  /**
   * 3. Reset animation states
   */
  const resetAnimationStates = () => {
    setIsUnlocking(false);
    setHasTriggeredUnlock(false);
  };
  const renderPreCompleteContent = (0, _react.useCallback)(() => {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      className: (0, _classnames.default)('hold-to-reveal-button__absolute-fill', {
        'hold-to-reveal-button__absolute-fill': isUnlocking,
        'hold-to-reveal-button__main-icon-show': hasTriggeredUnlock
      })
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      className: "hold-to-reveal-button__absolute-fill"
    }, /*#__PURE__*/_react.default.createElement("svg", {
      className: "hold-to-reveal-button__circle-svg"
    }, /*#__PURE__*/_react.default.createElement("circle", {
      className: "hold-to-reveal-button__circle-background",
      cx: radius,
      cy: radius,
      r: radiusWithStroke
    }))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      className: "hold-to-reveal-button__absolute-fill"
    }, /*#__PURE__*/_react.default.createElement("svg", {
      className: "hold-to-reveal-button__circle-svg"
    }, /*#__PURE__*/_react.default.createElement("circle", {
      "aria-label": t('holdToRevealLockedLabel'),
      onTransitionEnd: onProgressComplete,
      className: "hold-to-reveal-button__circle-foreground",
      cx: radius,
      cy: radius,
      r: radiusWithStroke
    }))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      alignItems: _designSystem.AlignItems.center,
      justifyContent: _designSystem.JustifyContent.center,
      className: "hold-to-reveal-button__lock-icon-container"
    }, /*#__PURE__*/_react.default.createElement("img", {
      src: "images/lock-icon.svg",
      alt: t('padlock'),
      className: "hold-to-reveal-button__lock-icon"
    })));
  }, [isUnlocking, hasTriggeredUnlock, t]);
  const renderPostCompleteContent = (0, _react.useCallback)(() => {
    return isUnlocking ? /*#__PURE__*/_react.default.createElement("div", {
      className: (0, _classnames.default)('hold-to-reveal-button__absolute-fill', {
        'hold-to-reveal-button__unlock-icon-hide': hasTriggeredUnlock
      }),
      onAnimationEnd: resetAnimationStates
    }, /*#__PURE__*/_react.default.createElement("div", {
      onAnimationEnd: preventPropogation,
      className: "hold-to-reveal-button__absolute-fill hold-to-reveal-button__circle-static-outer-container"
    }, /*#__PURE__*/_react.default.createElement("svg", {
      className: "hold-to-reveal-button__circle-svg"
    }, /*#__PURE__*/_react.default.createElement("circle", {
      className: "hold-to-reveal-button__circle-static-outer",
      cx: 14,
      cy: 14,
      r: 14
    }))), /*#__PURE__*/_react.default.createElement("div", {
      onAnimationEnd: preventPropogation,
      className: "hold-to-reveal-button__absolute-fill hold-to-reveal-button__circle-static-inner-container"
    }, /*#__PURE__*/_react.default.createElement("svg", {
      className: "hold-to-reveal-button__circle-svg"
    }, /*#__PURE__*/_react.default.createElement("circle", {
      className: "hold-to-reveal-button__circle-static-inner",
      cx: 14,
      cy: 14,
      r: 12
    }))), /*#__PURE__*/_react.default.createElement("div", {
      "aria-label": t('holdToRevealUnlockedLabel'),
      className: "hold-to-reveal-button__unlock-icon-container",
      onAnimationEnd: triggerOnLongPressed
    }, /*#__PURE__*/_react.default.createElement("img", {
      src: "images/unlock-icon.svg",
      alt: t('padlock'),
      className: "hold-to-reveal-button__unlock-icon"
    }))) : null;
  }, [isUnlocking, hasTriggeredUnlock, triggerOnLongPressed, t]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    width: _designSystem.BlockSize.Full,
    onPointerDown: onMouseDown // allows for touch and mouse events
    ,
    onPointerUp: onMouseUp // allows for touch and mouse events
    ,
    className: "hold-to-reveal-button__button-hold",
    textProps: {
      display: _designSystem.Display.Flex,
      alignItems: _designSystem.AlignItems.center
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "hold-to-reveal-button__icon-container",
    marginRight: 2
  }, renderPreCompleteContent(), renderPostCompleteContent()), buttonText);
}
HoldToRevealButton.propTypes = {
  /**
   * Text to be displayed on the button
   */
  buttonText: _propTypes.default.string.isRequired,
  /**
   * Function to be called after the animation is finished
   */
  onLongPressed: _propTypes.default.func.isRequired
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\hold-to-reveal-button\\hold-to-reveal-button.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\home-notification\\home-notification.component.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/check-box":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\check-box\\index.js","../../ui/tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\index.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Chome-notification%5Chome-notification.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _componentLibrary = require("../../component-library");
var _checkBox = _interopRequireDefault(require("../../ui/check-box"));
var _tooltip = _interopRequireDefault(require("../../ui/tooltip"));
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HomeNotification = ({
  acceptText,
  checkboxText,
  checkboxTooltipText,
  classNames = [],
  descriptionText,
  ignoreText,
  infoText,
  onAccept,
  onIgnore
}) => {
  const [checkboxState, setCheckBoxState] = (0, _react.useState)(false);
  const checkboxElement = checkboxText && /*#__PURE__*/_react.default.createElement(_checkBox.default, {
    id: "homeNotification_checkbox",
    checked: checkboxState,
    className: "home-notification__checkbox",
    onClick: () => setCheckBoxState(checked => !checked)
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('home-notification', ...classNames)
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "home-notification__content"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "home-notification__content-container"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "home-notification__text"
  }, descriptionText)), infoText ? /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    position: "top",
    title: infoText,
    wrapperClassName: "home-notification__tooltip-wrapper"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.Info,
    color: _designSystem.IconColor.iconDefault
  })) : null), /*#__PURE__*/_react.default.createElement("div", {
    className: "home-notification__buttons"
  }, onAccept && acceptText ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    variant: _componentLibrary.ButtonVariant.Primary,
    className: "home-notification__accept-button",
    onClick: onAccept
  }, acceptText) : null, onIgnore && ignoreText ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    variant: _componentLibrary.ButtonVariant.Secondary,
    className: "home-notification__ignore-button"
    // Some onIgnore handlers use the checkboxState to determine whether
    // to disable the notification
    ,
    onClick: () => onIgnore(checkboxState)
  }, ignoreText) : null, checkboxText ? /*#__PURE__*/_react.default.createElement("div", {
    className: "home-notification__checkbox-wrapper"
  }, checkboxTooltipText ? /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    position: "top",
    title: checkboxTooltipText,
    wrapperClassName: "home-notification__checkbox-label-tooltip"
  }, checkboxElement) : checkboxElement, /*#__PURE__*/_react.default.createElement("label", {
    className: "home-notification__checkbox-label",
    htmlFor: "homeNotification_checkbox"
  }, checkboxText)) : null));
};
HomeNotification.propTypes = {
  /**
   * The text for the "Accept" button. This must be accompanied by the `onAccept` prop.
   *
   * The "Accept" button is only rendered if this prop is set.
   */
  acceptText: _propTypes.default.node,
  /**
   * The text to display alongside the checkbox.
   *
   * The checkbox state is passed to the `onIgnore` handler, so this should only be used if the `onIgnore` prop is set.
   *
   * The checkbox is only rendered if this prop is set.
   */
  checkboxText: _propTypes.default.node,
  /**
   * The text to display in the checkbox tooltip.
   *
   * The tooltip is only rendered if this prop is set.
   */
  checkboxTooltipText: _propTypes.default.node,
  /**
   * Custom class names.
   */
  classNames: _propTypes.default.array,
  /**
   * The notification description.
   */
  descriptionText: _propTypes.default.node.isRequired,
  /**
   * The text for the "Ignore" button. This must be accompanied by the `onIgnore` prop.
   *
   * The "Ignore" button is only rendered if this prop is set.
   */
  ignoreText: _propTypes.default.node,
  /**
   * The text for the info icon tooltip in the top-right of the notification.
   *
   * The info-icon is only rendered if this prop is set.
   */
  infoText: _propTypes.default.node,
  /**
   * The handler for the "Accept" button. This must be accompanied by the `acceptText` prop.
   */
  onAccept: _propTypes.default.func,
  /**
   * The handler for the "Ignore" button. This must be accompanied by the `ignoreText` prop.
   *
   * If `checkboxText` is set, the checkbox state will be passed to this function as a boolean.
   */
  onIgnore: _propTypes.default.func
};
var _default = exports.default = HomeNotification;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\home-notification\\home-notification.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\home-notification\\index.js", {"./home-notification.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\home-notification\\home-notification.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Chome-notification%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _homeNotification.default;
  }
});
var _homeNotification = _interopRequireDefault(require("./home-notification.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\home-notification\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\identity\\backup-and-sync-features-toggles\\backup-and-sync-features-toggles.tsx", {"../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/identity/useBackupAndSync/useBackupAndSync":"D:\\code\\v\\metamask-extension\\ui\\hooks\\identity\\useBackupAndSync\\useBackupAndSync.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../selectors/identity/backup-and-sync":"D:\\code\\v\\metamask-extension\\ui\\selectors\\identity\\backup-and-sync.ts","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../ui/icon/preloader/preloader-icon.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\icon\\preloader\\preloader-icon.component.js","../../../ui/toggle-button":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\toggle-button\\index.js","@metamask/profile-sync-controller/user-storage":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\profile-sync-controller\\dist\\controllers\\user-storage\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cidentity%5Cbackup-and-sync-features-toggles%5Cbackup-and-sync-features-toggles.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.backupAndSyncFeaturesTogglesTestIds = exports.backupAndSyncFeaturesTogglesSections = exports.BackupAndSyncFeaturesToggles = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _userStorage = require("@metamask/profile-sync-controller/user-storage");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _backupAndSync = require("../../../../selectors/identity/backup-and-sync");
var _componentLibrary = require("../../../component-library");
var _toggleButton = _interopRequireDefault(require("../../../ui/toggle-button"));
var _designSystem = require("../../../../helpers/constants/design-system");
var _preloaderIcon = _interopRequireDefault(require("../../../ui/icon/preloader/preloader-icon.component"));
var _useBackupAndSync = require("../../../../hooks/identity/useBackupAndSync/useBackupAndSync");
var _metametrics = require("../../../../contexts/metametrics");
var _metametrics2 = require("../../../../../shared/constants/metametrics");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const backupAndSyncFeaturesTogglesTestIds = exports.backupAndSyncFeaturesTogglesTestIds = {
  container: 'backup-and-sync-features-toggles-container',
  accountSyncingToggleContainer: 'account-syncing-toggle-container',
  accountSyncingToggleButton: 'account-syncing-toggle-button',
  contactSyncingToggleContainer: 'contact-syncing-toggle-container',
  contactSyncingToggleButton: 'contact-syncing-toggle-button'
};
const backupAndSyncFeaturesTogglesSections = exports.backupAndSyncFeaturesTogglesSections = [{
  id: 'accounts',
  titleI18NKey: 'backupAndSyncFeatureAccounts',
  iconName: _componentLibrary.IconName.UserCircle,
  backupAndSyncfeatureKey: _userStorage.BACKUPANDSYNC_FEATURES.accountSyncing,
  featureReduxSelector: _backupAndSync.selectIsAccountSyncingEnabled,
  toggleContainerTestId: backupAndSyncFeaturesTogglesTestIds.accountSyncingToggleContainer,
  toggleButtonTestId: backupAndSyncFeaturesTogglesTestIds.accountSyncingToggleButton
}, {
  id: 'contactSyncing',
  titleI18NKey: 'backupAndSyncFeatureContacts',
  iconName: _componentLibrary.IconName.Book,
  backupAndSyncfeatureKey: _userStorage.BACKUPANDSYNC_FEATURES.contactSyncing,
  featureReduxSelector: _backupAndSync.selectIsContactSyncingEnabled,
  toggleContainerTestId: backupAndSyncFeaturesTogglesTestIds.contactSyncingToggleContainer,
  toggleButtonTestId: backupAndSyncFeaturesTogglesTestIds.contactSyncingToggleButton
}];
const FeatureToggle = ({
  section,
  isBackupAndSyncUpdateLoading,
  isBackupAndSyncEnabled
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const {
    setIsBackupAndSyncFeatureEnabled
  } = (0, _useBackupAndSync.useBackupAndSync)();
  const isFeatureEnabled = (0, _reactRedux.useSelector)(section.featureReduxSelector);
  const trackBackupAndSyncToggleEvent = (0, _react.useCallback)(newValue => {
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.Settings,
      event: _metametrics2.MetaMetricsEventName.SettingsUpdated,
      properties: {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        settings_group: 'backup_and_sync',
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        settings_type: section.id,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        old_value: isFeatureEnabled,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        new_value: newValue
      }
    });
  }, [trackEvent, isFeatureEnabled, section.id]);
  const handleToggleFeature = async () => {
    trackBackupAndSyncToggleEvent(!isFeatureEnabled);
    await setIsBackupAndSyncFeatureEnabled(section.backupAndSyncfeatureKey, !isFeatureEnabled);
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    alignItems: _designSystem.AlignItems.flexStart,
    marginBottom: 4,
    id: `backup-and-sync-features-toggles-${section.id}`
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: section.iconName
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium
  }, t(section.titleI18NKey))), isBackupAndSyncUpdateLoading ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 5,
    paddingRight: 5
  }, /*#__PURE__*/_react.default.createElement(_preloaderIcon.default, {
    size: 36
  })) : /*#__PURE__*/_react.default.createElement("div", {
    className: "privacy-settings__setting__toggle",
    "data-testid": section.toggleContainerTestId
  }, /*#__PURE__*/_react.default.createElement(_toggleButton.default, {
    value: isFeatureEnabled,
    disabled: !isBackupAndSyncEnabled,
    onToggle: handleToggleFeature,
    offLabel: t('off'),
    onLabel: t('on'),
    dataTestId: section.toggleButtonTestId
  })));
};
const BackupAndSyncFeaturesToggles = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  const isBackupAndSyncEnabled = (0, _reactRedux.useSelector)(_backupAndSync.selectIsBackupAndSyncEnabled);
  const isBackupAndSyncUpdateLoading = (0, _reactRedux.useSelector)(_backupAndSync.selectIsBackupAndSyncUpdateLoading);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginTop: 4,
    marginBottom: 4,
    className: "privacy-settings__setting__wrapper",
    "data-testid": backupAndSyncFeaturesTogglesTestIds.container
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium
  }, t('backupAndSyncManageWhatYouSync')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative,
    as: "div",
    marginBottom: 4
  }, t('backupAndSyncManageWhatYouSyncDescription')), backupAndSyncFeaturesTogglesSections.map(section => FeatureToggle({
    section,
    isBackupAndSyncUpdateLoading,
    isBackupAndSyncEnabled
  })));
};
exports.BackupAndSyncFeaturesToggles = BackupAndSyncFeaturesToggles;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\identity\\backup-and-sync-features-toggles\\backup-and-sync-features-toggles.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\identity\\backup-and-sync-toggle\\backup-and-sync-toggle.tsx", {"../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/identity/useBackupAndSync":"D:\\code\\v\\metamask-extension\\ui\\hooks\\identity\\useBackupAndSync\\index.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../selectors/identity/backup-and-sync":"D:\\code\\v\\metamask-extension\\ui\\selectors\\identity\\backup-and-sync.ts","../../../../selectors/metamask-notifications/metamask-notifications":"D:\\code\\v\\metamask-extension\\ui\\selectors\\metamask-notifications\\metamask-notifications.ts","../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../ui/icon/preloader/preloader-icon.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\icon\\preloader\\preloader-icon.component.js","../../../ui/toggle-button":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\toggle-button\\index.js","../../modals/identity":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\identity\\index.tsx","@metamask/profile-sync-controller/user-storage":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\profile-sync-controller\\dist\\controllers\\user-storage\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cidentity%5Cbackup-and-sync-toggle%5Cbackup-and-sync-toggle.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.backupAndSyncToggleTestIds = exports.BackupAndSyncToggle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _userStorage = require("@metamask/profile-sync-controller/user-storage");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _metametrics = require("../../../../contexts/metametrics");
var _useBackupAndSync = require("../../../../hooks/identity/useBackupAndSync");
var _metametrics2 = require("../../../../../shared/constants/metametrics");
var _backupAndSync = require("../../../../selectors/identity/backup-and-sync");
var _metamaskNotifications = require("../../../../selectors/metamask-notifications/metamask-notifications");
var _actions = require("../../../../store/actions");
var _componentLibrary = require("../../../component-library");
var _toggleButton = _interopRequireDefault(require("../../../ui/toggle-button"));
var _designSystem = require("../../../../helpers/constants/design-system");
var _preloaderIcon = _interopRequireDefault(require("../../../ui/icon/preloader/preloader-icon.component"));
var _selectors = require("../../../../selectors");
var _identity = require("../../modals/identity");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const backupAndSyncToggleTestIds = exports.backupAndSyncToggleTestIds = {
  container: 'backup-and-sync-container',
  toggleContainer: 'backup-and-sync-toggle-container',
  toggleButton: 'backup-and-sync-toggle-button'
};
const BackupAndSyncToggle = () => {
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    setIsBackupAndSyncFeatureEnabled,
    error
  } = (0, _useBackupAndSync.useBackupAndSync)();
  const isBasicFunctionalityEnabled = (0, _reactRedux.useSelector)(_selectors.getUseExternalServices);
  const isOnboardingBasicFunctionalityEnabled = (0, _reactRedux.useSelector)(_selectors.getExternalServicesOnboardingToggleState);
  const isBackupAndSyncEnabled = (0, _reactRedux.useSelector)(_backupAndSync.selectIsBackupAndSyncEnabled);
  const isBackupAndSyncUpdateLoading = (0, _reactRedux.useSelector)(_backupAndSync.selectIsBackupAndSyncUpdateLoading);
  const isMetamaskNotificationsEnabled = (0, _reactRedux.useSelector)(_metamaskNotifications.selectIsMetamaskNotificationsEnabled);
  const trackBackupAndSyncToggleEvent = (0, _react.useCallback)(newValue => {
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.Settings,
      event: _metametrics2.MetaMetricsEventName.SettingsUpdated,
      properties: {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        settings_group: 'backup_and_sync',
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        settings_type: 'main',
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        old_value: isBackupAndSyncEnabled,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        new_value: newValue,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        was_notifications_on: isMetamaskNotificationsEnabled
      }
    });
  }, [trackEvent, isBackupAndSyncEnabled, isMetamaskNotificationsEnabled]);

  // Cascading side effects
  (0, _react.useEffect)(() => {
    if (!isBasicFunctionalityEnabled && isBackupAndSyncEnabled) {
      setIsBackupAndSyncFeatureEnabled(_userStorage.BACKUPANDSYNC_FEATURES.main, false);
    }
  }, [isBasicFunctionalityEnabled, isBackupAndSyncEnabled, setIsBackupAndSyncFeatureEnabled]);
  const handleBackupAndSyncToggleSetValue = async () => {
    if (isBackupAndSyncEnabled) {
      trackBackupAndSyncToggleEvent(false);
      await setIsBackupAndSyncFeatureEnabled(_userStorage.BACKUPANDSYNC_FEATURES.main, false);
    } else {
      trackBackupAndSyncToggleEvent(true);
      if (isBasicFunctionalityEnabled === false || isOnboardingBasicFunctionalityEnabled === false) {
        dispatch((0, _actions.showModal)({
          name: _identity.CONFIRM_TURN_ON_BACKUP_AND_SYNC_MODAL_NAME,
          enableBackupAndSync: async () => {
            await setIsBackupAndSyncFeatureEnabled(_userStorage.BACKUPANDSYNC_FEATURES.main, true);
          }
        }));
      } else {
        await setIsBackupAndSyncFeatureEnabled(_userStorage.BACKUPANDSYNC_FEATURES.main, true);
      }
    }
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginTop: 4,
    marginBottom: 4,
    className: "privacy-settings__setting__wrapper",
    id: "backup-and-sync-toggle",
    "data-testid": backupAndSyncToggleTestIds.container
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    alignItems: _designSystem.AlignItems.flexStart,
    marginBottom: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium
  }, t('backupAndSyncEnable')), isBackupAndSyncUpdateLoading ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 5,
    paddingRight: 5
  }, /*#__PURE__*/_react.default.createElement(_preloaderIcon.default, {
    size: 36
  })) : /*#__PURE__*/_react.default.createElement("div", {
    className: "privacy-settings__setting__toggle",
    "data-testid": backupAndSyncToggleTestIds.toggleContainer
  }, /*#__PURE__*/_react.default.createElement(_toggleButton.default, {
    value: isBackupAndSyncEnabled,
    onToggle: handleBackupAndSyncToggleSetValue,
    offLabel: t('off'),
    onLabel: t('on'),
    dataTestId: backupAndSyncToggleTestIds.toggleButton
  }))), /*#__PURE__*/_react.default.createElement("div", {
    className: "privacy-settings__setting__description"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative,
    as: "div"
  }, t('backupAndSyncEnableDescription', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "a",
    variant: _designSystem.TextVariant.bodySm,
    href: "https://support.metamask.io/privacy-and-security/profile-privacy",
    target: "_blank",
    rel: "noopener noreferrer",
    key: "privacy-link",
    color: _designSystem.TextColor.infoDefault
  }, t('backupAndSyncPrivacyLink'))])), error && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginTop: 4,
    paddingBottom: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "p",
    color: _designSystem.TextColor.errorDefault,
    variant: _designSystem.TextVariant.bodySm
  }, t('notificationsSettingsBoxError')))));
};
exports.BackupAndSyncToggle = BackupAndSyncToggle;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\identity\\backup-and-sync-toggle\\backup-and-sync-toggle.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\import-token\\network-filter-import-token\\index.tsx", {"../../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../assets/asset-list/network-filter":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\asset-list\\network-filter\\index.ts","./network-filter-dropdown":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\import-token\\network-filter-import-token\\network-filter-dropdown\\index.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cimport-token%5Cnetwork-filter-import-token%5Cindex.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.NetworkFilterImportToken = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _designSystem = require("../../../../helpers/constants/design-system");
var _componentLibrary = require("../../../component-library");
var _networkFilter = _interopRequireDefault(require("../../assets/asset-list/network-filter"));
var _selectors = require("../../../../selectors");
var _networks = require("../../../../../shared/modules/selectors/networks");
var _multichain = require("../../../../selectors/multichain");
var _networkFilterDropdown = require("./network-filter-dropdown");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const NetworkFilterImportToken = ({
  title,
  buttonDataTestId,
  openListNetwork,
  networkFilter,
  setNetworkFilter
}) => {
  const dropdown = (0, _react.useRef)(null);
  const [isDropdownOpen, setIsDropdownOpen] = (0, _react.useState)(false);
  const isTokenNetworkFilterEqualCurrentNetwork = (0, _reactRedux.useSelector)(_selectors.getIsTokenNetworkFilterEqualCurrentNetwork);
  const currentNetwork = (0, _reactRedux.useSelector)(_selectors.getCurrentNetwork);
  const currentNetworkImageUrl = (0, _multichain.getImageForChainId)(currentNetwork === null || currentNetwork === void 0 ? void 0 : currentNetwork.chainId);
  const allNetworks = (0, _reactRedux.useSelector)(_networks.getNetworkConfigurationsByChainId);
  const allOpts = (0, _react.useMemo)(() => Object.keys(allNetworks || {}).reduce((acc, chain) => {
    acc[chain] = true;
    return acc;
  }, {}), [allNetworks]);
  const isCurrentNetwork = networkFilter ? Object.keys(networkFilter).length === 1 && networkFilter[currentNetwork === null || currentNetwork === void 0 ? void 0 : currentNetwork.chainId] : isTokenNetworkFilterEqualCurrentNetwork;
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, title ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Label, {
    variant: _designSystem.TextVariant.bodyMdMedium
  }, title) : null, /*#__PURE__*/_react.default.createElement(_networkFilterDropdown.NetworkFilterDropdown, {
    title: title,
    buttonDataTestId: buttonDataTestId,
    isCurrentNetwork: isCurrentNetwork,
    openListNetwork: openListNetwork,
    currentNetworkImageUrl: currentNetworkImageUrl ?? '',
    allOpts: allOpts,
    isDropdownOpen: isDropdownOpen,
    setIsDropdownOpen: setIsDropdownOpen,
    dropdownRef: dropdown
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Popover, {
    onClickOutside: () => setIsDropdownOpen(false),
    isOpen: isDropdownOpen,
    position: _componentLibrary.PopoverPosition.BottomStart,
    referenceElement: dropdown.current,
    matchWidth: true,
    style: {
      zIndex: 10,
      display: 'flex',
      flexDirection: 'column',
      padding: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_networkFilter.default, _extends({
    handleClose: () => setIsDropdownOpen(false),
    handleFilterNetwork: chainFilters => {
      if (setNetworkFilter) {
        setNetworkFilter(chainFilters);
      }
    }
  }, networkFilter && {
    networkFilter
  }))));
};
exports.NetworkFilterImportToken = NetworkFilterImportToken;
var _default = exports.default = NetworkFilterImportToken;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\import-token\\network-filter-import-token\\index.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\import-token\\network-filter-import-token\\network-filter-dropdown\\index.tsx", {"../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","./network-filter-drop-down-item":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\import-token\\network-filter-import-token\\network-filter-dropdown\\network-filter-drop-down-item\\index.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cimport-token%5Cnetwork-filter-import-token%5Cnetwork-filter-dropdown%5Cindex.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.NetworkFilterDropdown = void 0;
var _react = _interopRequireWildcard(require("react"));
var _componentLibrary = require("../../../../component-library");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _networkFilterDropDownItem = require("./network-filter-drop-down-item");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NetworkFilterDropdown = ({
  title,
  buttonDataTestId,
  isCurrentNetwork,
  openListNetwork,
  currentNetworkImageUrl,
  allOpts,
  isDropdownOpen,
  setIsDropdownOpen,
  dropdownRef
}) => {
  const setDropdownOpen = (0, _react.useCallback)(() => {
    setIsDropdownOpen(!isDropdownOpen);
  }, [isDropdownOpen, setIsDropdownOpen]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "dropdown-editor__item-dropdown",
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    borderRadius: _designSystem.BorderRadius.LG,
    borderColor: _designSystem.BorderColor.borderDefault,
    borderWidth: 1,
    paddingLeft: 4,
    paddingRight: 2,
    ref: dropdownRef
  }, /*#__PURE__*/_react.default.createElement(_networkFilterDropDownItem.NetworkFilterDropdownItem, {
    isCurrentNetwork: isCurrentNetwork,
    openListNetwork: openListNetwork,
    currentNetworkImageUrl: currentNetworkImageUrl,
    allOpts: allOpts,
    setDropdownOpen: setDropdownOpen
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    marginLeft: "auto",
    iconName: isDropdownOpen ? _componentLibrary.IconName.ArrowUp : _componentLibrary.IconName.ArrowDown,
    ariaLabel: title,
    size: _componentLibrary.ButtonIconSize.Sm,
    onClick: setDropdownOpen,
    "data-testid": buttonDataTestId
  }));
};
exports.NetworkFilterDropdown = NetworkFilterDropdown;
var _default = exports.default = NetworkFilterDropdown;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\import-token\\network-filter-import-token\\network-filter-dropdown\\index.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\import-token\\network-filter-import-token\\network-filter-dropdown\\network-filter-drop-down-item\\index.tsx", {"../../../../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cimport-token%5Cnetwork-filter-import-token%5Cnetwork-filter-dropdown%5Cnetwork-filter-drop-down-item%5Cindex.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkFilterDropdownItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _componentLibrary = require("../../../../../component-library");
var _designSystem = require("../../../../../../helpers/constants/design-system");
var _network = require("../../../../../../../shared/constants/network");
var _useI18nContext = require("../../../../../../hooks/useI18nContext");
var _selectors = require("../../../../../../selectors");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const NetworkFilterDropdownItem = ({
  isCurrentNetwork,
  openListNetwork,
  currentNetworkImageUrl,
  allOpts,
  setDropdownOpen
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const currentNetwork = (0, _reactRedux.useSelector)(_selectors.getCurrentNetwork);
  if (isCurrentNetwork) {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      justifyContent: _designSystem.JustifyContent.spaceBetween,
      width: _designSystem.BlockSize.Full,
      paddingTop: 3,
      paddingBottom: 3,
      gap: 3,
      onClick: setDropdownOpen
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMdMedium,
      color: _designSystem.TextColor.textDefault
    }, (currentNetwork === null || currentNetwork === void 0 ? void 0 : currentNetwork.nickname) ?? t('currentNetwork'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      alignItems: _designSystem.AlignItems.flexStart
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
      key: currentNetworkImageUrl,
      name: currentNetworkImageUrl ?? '',
      src: currentNetworkImageUrl ?? undefined,
      size: _componentLibrary.AvatarNetworkSize.Sm
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    width: _designSystem.BlockSize.Full,
    paddingTop: 3,
    paddingBottom: 3,
    gap: 3,
    onClick: setDropdownOpen
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: _designSystem.TextColor.textDefault
  }, t('popularNetworks')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.flexEnd,
    onClick: openListNetwork
  }, _network.FEATURED_NETWORK_CHAIN_IDS.filter(chain => allOpts[chain]).map((chain, index) => {
    const networkImageUrl = _network.CHAIN_ID_TO_NETWORK_IMAGE_URL_MAP[chain];
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
      key: networkImageUrl,
      name: networkImageUrl,
      src: networkImageUrl ?? undefined,
      size: _componentLibrary.AvatarNetworkSize.Sm,
      style: {
        marginLeft: index === 0 ? 0 : '-20px',
        zIndex: 5 - index
      }
    });
  })));
};
exports.NetworkFilterDropdownItem = NetworkFilterDropdownItem;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\import-token\\network-filter-import-token\\network-filter-dropdown\\network-filter-drop-down-item\\index.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\import-token\\network-selector-custom-import\\index.tsx", {"../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cimport-token%5Cnetwork-selector-custom-import%5Cindex.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.NetworkSelectorCustomImport = void 0;
var _react = _interopRequireDefault(require("react"));
var _designSystem = require("../../../../helpers/constants/design-system");
var _componentLibrary = require("../../../component-library");
var _multichain = require("../../../../selectors/multichain");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const NetworkSelectorCustomImport = ({
  title,
  buttonDataTestId,
  chainId,
  onSelectNetwork
}) => {
  const networkImageUrl = (0, _multichain.getImageForChainId)(chainId);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    padding: 4,
    onClick: onSelectNetwork,
    "data-testid": buttonDataTestId
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "dropdown-editor__item-dropdown",
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    borderRadius: _designSystem.BorderRadius.LG,
    borderColor: _designSystem.BorderColor.borderDefault,
    borderWidth: 1,
    paddingLeft: 4,
    paddingRight: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: _designSystem.TextColor.textDefault,
    paddingTop: 3,
    paddingBottom: 3
  }, title), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    marginLeft: "auto"
  }, networkImageUrl ? /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
    key: networkImageUrl,
    name: networkImageUrl ?? '',
    src: networkImageUrl ?? undefined,
    size: _componentLibrary.AvatarNetworkSize.Sm
  }) : null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    marginLeft: "auto",
    iconName: _componentLibrary.IconName.ArrowRight,
    size: _componentLibrary.ButtonIconSize.Sm,
    ariaLabel: title
  }))));
};
exports.NetworkSelectorCustomImport = NetworkSelectorCustomImport;
var _default = exports.default = NetworkSelectorCustomImport;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\import-token\\network-selector-custom-import\\index.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\import-token\\token-list\\index.js", {"./token-list.container":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\import-token\\token-list\\token-list.container.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cimport-token%5Ctoken-list%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _tokenList = _interopRequireDefault(require("./token-list.container"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
var _default = exports.default = _tokenList.default;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\import-token\\token-list\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\import-token\\token-list\\token-list-placeholder\\index.js", {"./token-list-placeholder.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\import-token\\token-list\\token-list-placeholder\\token-list-placeholder.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cimport-token%5Ctoken-list%5Ctoken-list-placeholder%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _tokenListPlaceholder = _interopRequireDefault(require("./token-list-placeholder.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
var _default = exports.default = _tokenListPlaceholder.default;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\import-token\\token-list\\token-list-placeholder\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\import-token\\token-list\\token-list-placeholder\\token-list-placeholder.component.js", {"../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../helpers/constants/zendesk-url":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\zendesk-url.js","../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cimport-token%5Ctoken-list%5Ctoken-list-placeholder%5Ctoken-list-placeholder.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _zendeskUrl = _interopRequireDefault(require("../../../../../helpers/constants/zendesk-url"));
var _componentLibrary = require("../../../../component-library");
var _designSystem = require("../../../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class TokenListPlaceholder extends _react.Component {
  render() {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      alignItems: _designSystem.AlignItems.center,
      flexDirection: _designSystem.FlexDirection.Column,
      textAlign: _designSystem.TextAlign.Center
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      color: _designSystem.TextColor.textAlternative
    }, this.context.t('addAcquiredTokens')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
      href: _zendeskUrl.default.ADD_CUSTOM_TOKENS,
      externalLink: true
    }, this.context.t('learnMoreUpperCase')));
  }
}
exports.default = TokenListPlaceholder;
_defineProperty(TokenListPlaceholder, "contextTypes", {
  t: _propTypes.default.func
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\import-token\\token-list\\token-list-placeholder\\token-list-placeholder.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\import-token\\token-list\\token-list.component.js", {"../../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","./token-list-placeholder":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\import-token\\token-list\\token-list-placeholder\\index.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cimport-token%5Ctoken-list%5Ctoken-list.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _util = require("../../../../helpers/utils/util");
var _componentLibrary = require("../../../component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _network = require("../../../../../shared/constants/network");
var _tokenListPlaceholder = _interopRequireDefault(require("./token-list-placeholder"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class TokenList extends _react.Component {
  render() {
    const {
      results = [],
      selectedTokens = {},
      onToggleToken,
      allTokens = {},
      accountAddress,
      currentNetwork,
      testNetworkBackgroundColor,
      isTokenNetworkFilterEqualCurrentNetwork
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      className: "token-list"
    }, results.length === 0 ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      paddingLeft: 4,
      paddingRight: 4,
      className: "token-list__empty-list"
    }, /*#__PURE__*/_react.default.createElement(_tokenListPlaceholder.default, null)) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      className: "token-list__tokens-container",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column
    }, Array(Math.min(12, results.length)).fill(undefined).map((_, i) => {
      var _results$i, _results$i2, _results$i3;
      const {
        symbol,
        name,
        address,
        chainId
      } = results[i] || {};
      let tokenAlreadyAdded = false;
      if (isTokenNetworkFilterEqualCurrentNetwork) {
        results[i].chainId = currentNetwork === null || currentNetwork === void 0 ? void 0 : currentNetwork.chainId;
      }
      tokenAlreadyAdded = (0, _util.checkExistingAllTokens)(address, chainId, accountAddress, allTokens);
      const onClick = () => !tokenAlreadyAdded && onToggleToken(results[i]);
      return Boolean(((_results$i = results[i]) === null || _results$i === void 0 ? void 0 : _results$i.iconUrl) || symbol || name) && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        key: address,
        display: _designSystem.Display.Flex,
        alignItems: _designSystem.AlignItems.center,
        flexDirection: _designSystem.FlexDirection.Row,
        flexWrap: _designSystem.FlexWrap.NoWrap,
        paddingLeft: 4,
        paddingRight: 4,
        paddingTop: 2,
        paddingBottom: 2,
        backgroundColor: selectedTokens[address] ? _designSystem.BackgroundColor.primaryMuted : _designSystem.BackgroundColor.transparent,
        className: (0, _classnames.default)('token-list__token_component', {
          'token-list__token_component--disabled': tokenAlreadyAdded
        }),
        onClick: onClick
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        display: _designSystem.Display.Flex,
        alignItems: _designSystem.AlignItems.center
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Checkbox, {
        isChecked: selectedTokens[address] || tokenAlreadyAdded,
        marginRight: 4,
        onClick: onClick
      }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.BadgeWrapper, {
        badge: /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
          size: _componentLibrary.AvatarNetworkSize.Xs,
          name: currentNetwork === null || currentNetwork === void 0 ? void 0 : currentNetwork.nickname,
          src: isTokenNetworkFilterEqualCurrentNetwork ? _network.CHAIN_ID_TO_NETWORK_IMAGE_URL_MAP[currentNetwork === null || currentNetwork === void 0 ? void 0 : currentNetwork.chainId] : _network.CHAIN_ID_TO_NETWORK_IMAGE_URL_MAP[(_results$i2 = results[i]) === null || _results$i2 === void 0 ? void 0 : _results$i2.chainId],
          backgroundColor: testNetworkBackgroundColor,
          borderWidth: 2,
          className: "token-list__token_component__network-badge"
        }),
        marginRight: 4,
        marginTop: 1
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarToken, {
        name: symbol,
        src: (_results$i3 = results[i]) === null || _results$i3 === void 0 ? void 0 : _results$i3.iconUrl
      }))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        fontWeight: _designSystem.FontWeight.Medium,
        variant: _designSystem.TextVariant.bodyMd
      }, name), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        variant: _designSystem.TextVariant.bodySm,
        color: _designSystem.TextColor.textAlternative
      }, symbol))));
    })));
  }
}
exports.default = TokenList;
_defineProperty(TokenList, "contextTypes", {
  t: _propTypes.default.func
});
_defineProperty(TokenList, "propTypes", {
  allTokens: _propTypes.default.object,
  results: _propTypes.default.array,
  selectedTokens: _propTypes.default.object,
  onToggleToken: _propTypes.default.func,
  currentNetwork: _propTypes.default.object,
  testNetworkBackgroundColor: _propTypes.default.object,
  isTokenNetworkFilterEqualCurrentNetwork: _propTypes.default.bool,
  accountAddress: _propTypes.default.string
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\import-token\\token-list\\token-list.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\import-token\\token-list\\token-list.container.js", {"../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","./token-list.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\import-token\\token-list\\token-list.component.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cimport-token%5Ctoken-list%5Ctoken-list.container.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactRedux = require("react-redux");
var _selectors = require("../../../../selectors");
var _tokenList = _interopRequireDefault(require("./token-list.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const mapStateToProps = state => {
  const {
    allTokens
  } = state.metamask;
  const {
    address
  } = (0, _selectors.getSelectedInternalAccount)(state);
  return {
    allTokens,
    accountAddress: address
  };
};
var _default = exports.default = (0, _reactRedux.connect)(mapStateToProps)(_tokenList.default);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\import-token\\token-list\\token-list.container.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\import-token\\token-search\\index.js", {"./token-search.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\import-token\\token-search\\token-search.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cimport-token%5Ctoken-search%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _tokenSearch = _interopRequireDefault(require("./token-search.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
var _default = exports.default = _tokenSearch.default;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\import-token\\token-search\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\import-token\\token-search\\token-search.component.js", {"../../../../../shared/modules/string-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\string-utils.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../component-library/text-field-search/deprecated":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\text-field-search\\deprecated\\index.js","fuse.js":"D:\\code\\v\\metamask-extension\\node_modules\\fuse.js\\dist\\fuse.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cimport-token%5Ctoken-search%5Ctoken-search.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = TokenSearch;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _fuse = _interopRequireDefault(require("fuse.js"));
var _stringUtils = require("../../../../../shared/modules/string-utils");
var _deprecated = require("../../../component-library/text-field-search/deprecated");
var _designSystem = require("../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _selectors = require("../../../../selectors");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getTokens = (tokenList = {}) => Object.values(tokenList);
const createTokenSearchFuse = tokenList => {
  return new _fuse.default(getTokens(tokenList), {
    shouldSort: true,
    threshold: 0.45,
    location: 0,
    distance: 100,
    maxPatternLength: 32,
    minMatchCharLength: 1,
    keys: [{
      name: 'name',
      weight: 0.5
    }, {
      name: 'symbol',
      weight: 0.5
    }]
  });
};
function TokenSearch({
  onSearch,
  error,
  tokenList,
  searchClassName,
  networkFilter,
  setSearchResults
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  const isTokenNetworkFilterEqualCurrentNetwork = Object.keys(networkFilter).length === 1;
  const {
    chainId
  } = (0, _reactRedux.useSelector)(_selectors.getCurrentNetwork);
  const filteredTokenList = (0, _react.useMemo)(() => {
    if (isTokenNetworkFilterEqualCurrentNetwork) {
      var _tokenList$chainId;
      return tokenList === null || tokenList === void 0 || (_tokenList$chainId = tokenList[chainId]) === null || _tokenList$chainId === void 0 ? void 0 : _tokenList$chainId.data;
    }
    return Object.entries(tokenList).flatMap(([networkId, {
      data
    }]) => Object.values(data).map(item => ({
      ...item,
      chainId: networkId
    })));
  }, [tokenList, isTokenNetworkFilterEqualCurrentNetwork, chainId]);
  const [searchQuery, setSearchQuery] = (0, _react.useState)('');
  const [tokenSearchFuse, setTokenSearchFuse] = (0, _react.useState)(createTokenSearchFuse(filteredTokenList));
  (0, _react.useEffect)(() => {
    setTokenSearchFuse(createTokenSearchFuse(filteredTokenList));
  }, [filteredTokenList]);
  const handleSearch = newSearchQuery => {
    setSearchQuery(newSearchQuery);
    const fuseSearchResult = tokenSearchFuse.search(newSearchQuery);
    const addressSearchResult = getTokens(filteredTokenList).filter(token => {
      return token.address && newSearchQuery && (0, _stringUtils.isEqualCaseInsensitive)(token.address, newSearchQuery);
    });
    const results = [...addressSearchResult, ...fuseSearchResult];
    onSearch({
      newSearchQuery,
      results
    });
  };
  const clear = () => {
    setSearchQuery('');
    setSearchResults([]);
  };
  (0, _react.useEffect)(() => {
    clear();
  }, [isTokenNetworkFilterEqualCurrentNetwork]);
  return /*#__PURE__*/_react.default.createElement(_deprecated.TextFieldSearch, {
    className: searchClassName,
    placeholder: t('searchTokens'),
    value: searchQuery,
    onChange: e => handleSearch(e.target.value),
    error: error,
    autoFocus: true,
    autoComplete: false,
    width: _designSystem.BlockSize.Full,
    size: _designSystem.Size.LG,
    paddingRight: 2,
    borderRadius: _designSystem.BorderRadius.LG,
    clearButtonOnClick: clear,
    clearButtonProps: {
      size: _designSystem.Size.SM
    }
  });
}
TokenSearch.propTypes = {
  onSearch: _propTypes.default.func.isRequired,
  error: _propTypes.default.object,
  tokenList: _propTypes.default.object.isRequired,
  searchClassName: _propTypes.default.string.isRequired,
  networkFilter: _propTypes.default.object.isRequired,
  setSearchResults: _propTypes.default.func.isRequired
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\import-token\\token-search\\token-search.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\metamask-template-renderer\\index.js", {"./metamask-template-renderer":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\metamask-template-renderer\\metamask-template-renderer.js","./section-shape":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\metamask-template-renderer\\section-shape.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmetamask-template-renderer%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "SectionShape", {
  enumerable: true,
  get: function () {
    return _sectionShape.SectionShape;
  }
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _metamaskTemplateRenderer.default;
  }
});
var _metamaskTemplateRenderer = _interopRequireDefault(require("./metamask-template-renderer"));
var _sectionShape = require("./section-shape");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\metamask-template-renderer\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\metamask-template-renderer\\metamask-template-renderer.js", {"./safe-component-list":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\metamask-template-renderer\\safe-component-list.js","./section-shape":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\metamask-template-renderer\\section-shape.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmetamask-template-renderer%5Cmetamask-template-renderer.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _safeComponentList = require("./safe-component-list");
var _sectionShape = require("./section-shape");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function getElement(section) {
  const {
    element
  } = section;
  const Element = _safeComponentList.safeComponentList[element];
  if (!Element) {
    throw new Error(`${element} is not in the safe component list for MetaMask template renderer`);
  }
  return Element;
}
function renderElement(element) {
  const Element = getElement(element);
  const propsAsComponents = element.propComponents ? getPropComponents(element.propComponents) : {};
  return /*#__PURE__*/_react.default.createElement(Element, _extends({}, element.props, propsAsComponents), typeof element.children === 'object' ? /*#__PURE__*/_react.default.createElement(MetaMaskTemplateRenderer, {
    sections: element.children
  }) : element === null || element === void 0 ? void 0 : element.children);
}
function getPropComponents(components) {
  return Object.entries(components).reduce((accumulator, [key, component]) => {
    if (component) {
      accumulator[key] = Array.isArray(component) ? component.map(renderElement) : renderElement(component);
    }
    return accumulator;
  }, {});
}
const MetaMaskTemplateRenderer = ({
  sections
}) => {
  if (!sections) {
    // If sections is null eject early by returning null
    return null;
  } else if (typeof sections === 'string') {
    // React can render strings directly, so return the string
    return sections;
  } else if (sections && typeof sections === 'object' && !Array.isArray(sections)) {
    // If dealing with a single entry, then render a single object without key
    return renderElement(sections);
  }

  // The last case is dealing with an array of objects
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, sections.reduce((allChildren, child) => {
    if (child === undefined || (child === null || child === void 0 ? void 0 : child.hide) === true) {
      return allChildren;
    }
    if (typeof child === 'string') {
      // React can render strings directly, so push them into the accumulator
      allChildren.push(child);
    } else {
      // If the entry in array is not a string, then it must be a Section.
      // Sections are handled by the main function, but must
      // be provided a key when a part of an array.
      if (!child.key) {
        throw new Error('When using array syntax in MetaMask Template Language, you must specify a key for each child of the array');
      }
      if (typeof (child === null || child === void 0 ? void 0 : child.children) === 'object') {
        // If this child has its own children, check if children is an
        // object, and in that case use recursion to render.
        allChildren.push(/*#__PURE__*/_react.default.createElement(MetaMaskTemplateRenderer, {
          sections: child,
          key: child.key
        }));
      } else {
        // Otherwise render the element.
        const Element = getElement(child);
        const propsAsComponents = child.propComponents ? getPropComponents(child.propComponents) : {};
        allChildren.push(/*#__PURE__*/_react.default.createElement(Element, _extends({
          key: child.key
        }, child.props, propsAsComponents), child === null || child === void 0 ? void 0 : child.children));
      }
    }
    return allChildren;
  }, []));
};
MetaMaskTemplateRenderer.propTypes = {
  sections: _sectionShape.ValidChildren
};
var _default = exports.default = /*#__PURE__*/(0, _react.memo)(MetaMaskTemplateRenderer, (prevProps, nextProps) => {
  return (0, _lodash.isEqual)(prevProps.sections, nextProps.sections);
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\metamask-template-renderer\\metamask-template-renderer.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\metamask-template-renderer\\safe-component-list.js", {"../../../pages/confirmations/components/snap-account-error-message":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\snap-account-error-message\\index.tsx","../../../pages/confirmations/components/snap-account-success-message":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\snap-account-success-message\\index.tsx","../../../pages/confirmations/confirmation/components/confirmation-network-switch":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\components\\confirmation-network-switch\\index.js","../../../pages/core/hyperliquid-referral-consent":"D:\\code\\v\\metamask-extension\\ui\\pages\\core\\hyperliquid-referral-consent\\index.ts","../../../pages/create-snap-account":"D:\\code\\v\\metamask-extension\\ui\\pages\\create-snap-account\\index.ts","../../../pages/remove-snap-account":"D:\\code\\v\\metamask-extension\\ui\\pages\\remove-snap-account\\index.ts","../../../pages/smart-transactions/smart-transaction-status-page":"D:\\code\\v\\metamask-extension\\ui\\pages\\smart-transactions\\smart-transaction-status-page\\index.ts","../../../pages/snap-account-redirect":"D:\\code\\v\\metamask-extension\\ui\\pages\\snap-account-redirect\\index.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../component-library/skeleton":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\skeleton\\index.ts","../../multichain":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../multichain/create-named-snap-account":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\create-named-snap-account\\index.js","../../ui/actionable-message/actionable-message":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\actionable-message\\actionable-message.js","../../ui/box":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\box\\index.js","../../ui/button":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\button\\index.js","../../ui/chip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\chip\\index.js","../../ui/definition-list":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\definition-list\\index.js","../../ui/icon/preloader":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\icon\\preloader\\index.js","../../ui/origin-pill/origin-pill":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\origin-pill\\origin-pill.tsx","../../ui/popover":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\popover\\index.js","../../ui/spinner":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\spinner\\index.js","../../ui/text-field":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\text-field\\index.js","../../ui/textarea/textarea":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\textarea\\textarea.js","../../ui/tooltip/tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\tooltip.js","../../ui/truncated-definition-list":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\truncated-definition-list\\index.js","../../ui/typography":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\typography\\index.js","../../ui/url-icon":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\url-icon\\index.js","../confirm/info/row":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\index.ts","../metamask-translation":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\metamask-translation\\index.js","../network-display":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\network-display\\index.js","../snaps/copyable":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\copyable\\index.js","../snaps/snap-authorship-header":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-authorship-header\\index.js","../snaps/snap-delineator":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-delineator\\index.js","../snaps/snap-ui-account-selector":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-ui-account-selector\\index.ts","../snaps/snap-ui-address":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-ui-address\\index.ts","../snaps/snap-ui-address-input":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-ui-address-input\\index.ts","../snaps/snap-ui-asset-selector":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-ui-asset-selector\\index.ts","../snaps/snap-ui-avatar":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-ui-avatar\\index.ts","../snaps/snap-ui-banner":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-ui-banner\\index.ts","../snaps/snap-ui-button":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-ui-button\\index.ts","../snaps/snap-ui-card":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-ui-card\\index.ts","../snaps/snap-ui-checkbox":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-ui-checkbox\\index.ts","../snaps/snap-ui-dropdown":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-ui-dropdown\\index.ts","../snaps/snap-ui-file-input":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-ui-file-input\\index.ts","../snaps/snap-ui-footer-button":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-ui-footer-button\\index.ts","../snaps/snap-ui-form":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-ui-form\\index.ts","../snaps/snap-ui-icon":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-ui-icon\\index.ts","../snaps/snap-ui-image":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-ui-image\\index.ts","../snaps/snap-ui-input":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-ui-input\\index.ts","../snaps/snap-ui-link":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-ui-link\\index.js","../snaps/snap-ui-markdown":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-ui-markdown\\index.js","../snaps/snap-ui-radio-group":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-ui-radio-group\\index.ts","../snaps/snap-ui-selector":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-ui-selector\\index.ts","../snaps/snap-ui-tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-ui-tooltip\\index.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmetamask-template-renderer%5Csafe-component-list.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.safeComponentList = void 0;
var _confirmationNetworkSwitch = _interopRequireDefault(require("../../../pages/confirmations/confirmation/components/confirmation-network-switch"));
var _smartTransactionStatusPage = require("../../../pages/smart-transactions/smart-transaction-status-page");
var _componentLibrary = require("../../component-library");
var _multichain = require("../../multichain");
var _actionableMessage = _interopRequireDefault(require("../../ui/actionable-message/actionable-message"));
var _box = _interopRequireDefault(require("../../ui/box"));
var _button = _interopRequireDefault(require("../../ui/button"));
var _chip = _interopRequireDefault(require("../../ui/chip"));
var _definitionList = _interopRequireDefault(require("../../ui/definition-list"));
var _preloader = _interopRequireDefault(require("../../ui/icon/preloader"));
var _originPill = _interopRequireDefault(require("../../ui/origin-pill/origin-pill"));
var _popover = _interopRequireDefault(require("../../ui/popover"));
var _spinner = _interopRequireDefault(require("../../ui/spinner"));
var _textField = _interopRequireDefault(require("../../ui/text-field"));
var _textarea = _interopRequireDefault(require("../../ui/textarea/textarea"));
var _tooltip = _interopRequireDefault(require("../../ui/tooltip/tooltip"));
var _truncatedDefinitionList = _interopRequireDefault(require("../../ui/truncated-definition-list"));
var _typography = _interopRequireDefault(require("../../ui/typography"));
var _urlIcon = _interopRequireDefault(require("../../ui/url-icon"));
var _row = require("../confirm/info/row");
var _metamaskTranslation = _interopRequireDefault(require("../metamask-translation"));
var _networkDisplay = _interopRequireDefault(require("../network-display"));
var _copyable = require("../snaps/copyable");
var _snapDelineator = require("../snaps/snap-delineator");
var _snapUiAddress = require("../snaps/snap-ui-address");
var _snapUiAvatar = require("../snaps/snap-ui-avatar");
var _snapUiBanner = require("../snaps/snap-ui-banner");
var _snapUiButton = require("../snaps/snap-ui-button");
var _snapUiCard = require("../snaps/snap-ui-card");
var _snapUiCheckbox = require("../snaps/snap-ui-checkbox");
var _snapUiDropdown = require("../snaps/snap-ui-dropdown");
var _snapUiFileInput = require("../snaps/snap-ui-file-input");
var _snapUiFooterButton = require("../snaps/snap-ui-footer-button");
var _snapUiForm = require("../snaps/snap-ui-form");
var _snapUiIcon = require("../snaps/snap-ui-icon");
var _snapUiImage = require("../snaps/snap-ui-image");
var _snapUiInput = require("../snaps/snap-ui-input");
var _snapUiLink = require("../snaps/snap-ui-link");
var _snapUiAddressInput = require("../snaps/snap-ui-address-input");
var _snapUiMarkdown = require("../snaps/snap-ui-markdown");
var _snapUiRadioGroup = require("../snaps/snap-ui-radio-group");
var _snapUiSelector = require("../snaps/snap-ui-selector");
var _snapUiTooltip = require("../snaps/snap-ui-tooltip");
var _snapUiAssetSelector = require("../snaps/snap-ui-asset-selector");
var _snapUiAccountSelector = require("../snaps/snap-ui-account-selector");
var _snapAccountErrorMessage = require("../../../pages/confirmations/components/snap-account-error-message");
var _snapAccountSuccessMessage = require("../../../pages/confirmations/components/snap-account-success-message");
var _createSnapAccount = require("../../../pages/create-snap-account");
var _removeSnapAccount = require("../../../pages/remove-snap-account");
var _snapAccountRedirect = require("../../../pages/snap-account-redirect");
var _createNamedSnapAccount = require("../../multichain/create-named-snap-account");
var _snapAuthorshipHeader = _interopRequireDefault(require("../snaps/snap-authorship-header"));
var _skeleton = require("../../component-library/skeleton");
var _hyperliquidReferralConsent = require("../../../pages/core/hyperliquid-referral-consent");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)

///: END:ONLY_INCLUDE_IF

const safeComponentList = exports.safeComponentList = {
  a: 'a',
  AccountListItem: _multichain.AccountListItem,
  ActionableMessage: _actionableMessage.default,
  AvatarIcon: _componentLibrary.AvatarIcon,
  b: 'b',
  BannerAlert: _componentLibrary.BannerAlert,
  Box: _box.default,
  Button: _button.default,
  Chip: _chip.default,
  ConfirmationNetworkSwitch: _confirmationNetworkSwitch.default,
  ConfirmInfoRow: _row.ConfirmInfoRow,
  ConfirmInfoRowAddress: _row.ConfirmInfoRowAddress,
  ConfirmInfoRowValueDouble: _row.ConfirmInfoRowValueDouble,
  Copyable: _copyable.Copyable,
  DefinitionList: _definitionList.default,
  div: 'div',
  FormTextField: _componentLibrary.FormTextField,
  HyperliquidReferralConsent: _hyperliquidReferralConsent.HyperliquidReferralConsent,
  i: 'i',
  MetaMaskTranslation: _metamaskTranslation.default,
  NetworkDisplay: _networkDisplay.default,
  OriginPill: _originPill.default,
  p: 'p',
  Popover: _popover.default,
  Preloader: _preloader.default,
  SnapDelineator: _snapDelineator.SnapDelineator,
  SnapUIAccountSelector: _snapUiAccountSelector.SnapUIAccountSelector,
  SnapUIAddress: _snapUiAddress.SnapUIAddress,
  SnapUIAvatar: _snapUiAvatar.SnapUIAvatar,
  SnapUIBanner: _snapUiBanner.SnapUIBanner,
  SnapUIButton: _snapUiButton.SnapUIButton,
  SnapUICard: _snapUiCard.SnapUICard,
  SnapUICheckbox: _snapUiCheckbox.SnapUICheckbox,
  SnapUIDropdown: _snapUiDropdown.SnapUIDropdown,
  SnapUIFileInput: _snapUiFileInput.SnapUIFileInput,
  SnapUIForm: _snapUiForm.SnapUIForm,
  SnapUIFooterButton: _snapUiFooterButton.SnapUIFooterButton,
  SnapUIIcon: _snapUiIcon.SnapUIIcon,
  SnapUIImage: _snapUiImage.SnapUIImage,
  SnapUIInput: _snapUiInput.SnapUIInput,
  SnapUIAddressInput: _snapUiAddressInput.SnapUIAddressInput,
  SnapUILink: _snapUiLink.SnapUILink,
  SnapUIMarkdown: _snapUiMarkdown.SnapUIMarkdown,
  SnapUIRadioGroup: _snapUiRadioGroup.SnapUIRadioGroup,
  SnapUISelector: _snapUiSelector.SnapUISelector,
  SnapUITooltip: _snapUiTooltip.SnapUITooltip,
  SnapUIAssetSelector: _snapUiAssetSelector.SnapUIAssetSelector,
  span: 'span',
  Spinner: _spinner.default,
  Skeleton: _skeleton.Skeleton,
  Text: _componentLibrary.Text,
  TextArea: _textarea.default,
  TextField: _textField.default,
  Tooltip: _tooltip.default,
  TruncatedDefinitionList: _truncatedDefinitionList.default,
  Typography: _typography.default,
  SmartTransactionStatusPage: _smartTransactionStatusPage.SmartTransactionStatusPage,
  UrlIcon: _urlIcon.default,
  ///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
  CreateNamedSnapAccount: _createNamedSnapAccount.CreateNamedSnapAccount,
  CreateSnapAccount: _createSnapAccount.CreateSnapAccount,
  RemoveSnapAccount: _removeSnapAccount.RemoveSnapAccount,
  SnapAccountCard: _removeSnapAccount.SnapAccountCard,
  SnapAccountErrorMessage: _snapAccountErrorMessage.SnapAccountErrorMessage,
  SnapAccountRedirect: _snapAccountRedirect.SnapAccountRedirect,
  SnapAccountSuccessMessage: _snapAccountSuccessMessage.SnapAccountSuccessMessage,
  SnapAuthorshipHeader: _snapAuthorshipHeader.default
  ///: END:ONLY_INCLUDE_IF
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\metamask-template-renderer\\safe-component-list.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\metamask-template-renderer\\section-shape.js", {"prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmetamask-template-renderer%5Csection-shape.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValidChildren = exports.SectionShape = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const SectionShape = exports.SectionShape = {
  props: _propTypes.default.object,
  propComponents: _propTypes.default.object,
  element: _propTypes.default.string,
  key: _propTypes.default.string
};
const ValidChildren = exports.ValidChildren = _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.shape(SectionShape), _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.shape(SectionShape), _propTypes.default.string]))]);
SectionShape.children = ValidChildren;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\metamask-template-renderer\\section-shape.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\metamask-translation\\index.js", {"./metamask-translation":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\metamask-translation\\metamask-translation.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmetamask-translation%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _metamaskTranslation.default;
  }
});
var _metamaskTranslation = _interopRequireDefault(require("./metamask-translation"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\metamask-translation\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\metamask-translation\\metamask-translation.js", {"../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../metamask-template-renderer":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\metamask-template-renderer\\index.js","../metamask-template-renderer/section-shape":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\metamask-template-renderer\\section-shape.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmetamask-translation%5Cmetamask-translation.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = MetaMaskTranslation;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _useI18nContext = require("../../../hooks/useI18nContext");
var _metamaskTemplateRenderer = _interopRequireDefault(require("../metamask-template-renderer"));
var _sectionShape = require("../metamask-template-renderer/section-shape");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * MetaMaskTranslation is a simple helper component for adding full translation
 * support to the template system. We do pass the translation function to the
 * template getValues function, but passing it React components as variables
 * would require React to be in scope, and breaks the object pattern paradigm.
 *
 * This component gets around that by converting variables that are templates
 * themselves into tiny React trees. This component does additional validation
 * to make sure that the tree has a single root node, with maximum two leaves.
 * Each subnode can have a maximum of one child that must be a string.
 *
 * This enforces a maximum recursion depth of 2, preventing translation strings
 * from being performance hogs. We could further limit this, and also attenuate
 * the safeComponentList for what kind of components we allow these special
 * trees to contain.
 *
 * @param options
 * @param options.translationKey
 * @param options.variables
 */
function MetaMaskTranslation({
  translationKey,
  variables
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  return t(translationKey, variables === null || variables === void 0 ? void 0 : variables.map(variable => {
    if (typeof variable === 'object' && !Array.isArray(variable) && variable.element) {
      var _variable$children, _variable$children2;
      if (!variable.key) {
        throw new Error(`When using MetaMask Template Language in a MetaMaskTranslation variable, you must provide a key for the section regardless of syntax.
            Section with element '${variable.element}' for translationKey: '${translationKey}' has no key property`);
      }
      if (variable.children && Array.isArray(variable.children) && variable.children.length > 2) {
        throw new Error('MetaMaskTranslation only renders templates with a single section and maximum two children');
      } else if (((_variable$children = variable.children) === null || _variable$children === void 0 || (_variable$children = _variable$children[0]) === null || _variable$children === void 0 ? void 0 : _variable$children.children) !== undefined && typeof variable.children[0].children !== 'string' || ((_variable$children2 = variable.children) === null || _variable$children2 === void 0 || (_variable$children2 = _variable$children2[1]) === null || _variable$children2 === void 0 ? void 0 : _variable$children2.children) !== undefined && typeof variable.children[1].children !== 'string') {
        throw new Error('MetaMaskTranslation does not allow for component trees of non trivial depth');
      }
      return /*#__PURE__*/_react.default.createElement(_metamaskTemplateRenderer.default, {
        key: `${translationKey}-${variable.key}`,
        sections: variable
      });
    }
    return variable;
  }));
}
MetaMaskTranslation.propTypes = {
  /**
   * Translation object key
   */
  translationKey: _propTypes.default.string.isRequired,
  /**
   * Array of variables for the MetaMaskTranslation component
   */
  variables: _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number, _propTypes.default.shape(_sectionShape.SectionShape)]))
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\metamask-translation\\metamask-translation.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modal\\index.js", {"./modal-content":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modal\\modal-content\\index.js","./modal.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modal\\modal.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodal%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ModalContent", {
  enumerable: true,
  get: function () {
    return _modalContent.default;
  }
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _modal.default;
  }
});
var _modal = _interopRequireDefault(require("./modal.component"));
var _modalContent = _interopRequireDefault(require("./modal-content"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modal\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modal\\modal-content\\index.js", {"./modal-content.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modal\\modal-content\\modal-content.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodal%5Cmodal-content%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _modalContent.default;
  }
});
var _modalContent = _interopRequireDefault(require("./modal-content.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modal\\modal-content\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modal\\modal-content\\modal-content.component.js", {"prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodal%5Cmodal-content%5Cmodal-content.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class ModalContent extends _react.PureComponent {
  render() {
    const {
      title,
      description
    } = this.props;
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "modal-content"
    }, title ? /*#__PURE__*/_react.default.createElement("div", {
      className: "modal-content__title"
    }, title) : null, description && /*#__PURE__*/_react.default.createElement("div", {
      className: "modal-content__description"
    }, description));
  }
}
exports.default = ModalContent;
_defineProperty(ModalContent, "propTypes", {
  title: _propTypes.default.string,
  description: _propTypes.default.string
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modal\\modal-content\\modal-content.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modal\\modal.component.js", {"../../ui/button":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\button\\index.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodal%5Cmodal.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _button = _interopRequireDefault(require("../../ui/button"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @deprecated The `<Modal />` component has been deprecated in favor of the new `<Modal>` component from the component-library.
 * Please update your code to use the new `<Modal>` component instead, which can be found at ui/components/component-library/modal/modal.tsx.
 * You can find documentation for the new Modal component in the MetaMask Storybook:
 * {@link https://metamask.github.io/metamask-storybook/?path=/docs/components-componentlibrary-modal--docs}
 * If you would like to help with the replacement of the old Modal component, please submit a pull request
 */

class Modal extends _react.PureComponent {
  render() {
    const {
      children,
      headerText,
      onClose,
      onSubmit,
      submitType,
      submitText,
      submitDisabled,
      onCancel,
      cancelType,
      cancelText,
      contentClass,
      containerClass,
      hideFooter,
      testId
    } = this.props;
    return /*#__PURE__*/_react.default.createElement("div", {
      className: (0, _classnames.default)('modal-container', containerClass),
      "data-testid": testId
    }, headerText && /*#__PURE__*/_react.default.createElement("div", {
      className: "modal-container__header"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "modal-container__header-text"
    }, headerText), /*#__PURE__*/_react.default.createElement("div", {
      className: "modal-container__header-close",
      "data-testid": "modal-header-close",
      onClick: onClose
    })), /*#__PURE__*/_react.default.createElement("div", {
      className: (0, _classnames.default)('modal-container__content', contentClass)
    }, children), hideFooter ? null : /*#__PURE__*/_react.default.createElement("div", {
      className: "modal-container__footer"
    }, onCancel && /*#__PURE__*/_react.default.createElement(_button.default, {
      type: cancelType,
      onClick: onCancel,
      className: "modal-container__footer-button"
    }, cancelText), /*#__PURE__*/_react.default.createElement(_button.default, {
      type: submitType,
      onClick: onSubmit,
      disabled: submitDisabled,
      className: "modal-container__footer-button"
    }, submitText)));
  }
}
exports.default = Modal;
_defineProperty(Modal, "propTypes", {
  children: _propTypes.default.node,
  contentClass: _propTypes.default.string,
  containerClass: _propTypes.default.string,
  testId: _propTypes.default.string,
  // Header text
  headerText: _propTypes.default.string,
  onClose: _propTypes.default.func,
  // Submit button (right button)
  onSubmit: _propTypes.default.func,
  submitType: _propTypes.default.string,
  submitText: _propTypes.default.string,
  submitDisabled: _propTypes.default.bool,
  hideFooter: _propTypes.default.bool,
  // Cancel button (left button)
  onCancel: _propTypes.default.func,
  cancelType: _propTypes.default.string,
  cancelText: _propTypes.default.string
});
_defineProperty(Modal, "defaultProps", {
  submitType: 'primary',
  cancelType: 'secondary'
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modal\\modal.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\add-funds-modal\\add-funds-modal.tsx", {"../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../../ducks/ramps":"D:\\code\\v\\metamask-extension\\ui\\ducks\\ramps\\index.ts","../../../../hooks/bridge/useBridging":"D:\\code\\v\\metamask-extension\\ui\\hooks\\bridge\\useBridging.ts","../../../../hooks/ramps/useRamps/useRamps":"D:\\code\\v\\metamask-extension\\ui\\hooks\\ramps\\useRamps\\useRamps.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../multichain/receive-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\receive-modal\\index.js","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cadd-funds-modal%5Cadd-funds-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _designSystemReact = require("@metamask/design-system-react");
var _reactRedux = require("react-redux");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _componentLibrary = require("../../../component-library");
var _ramps = require("../../../../ducks/ramps");
var _useRamps = _interopRequireDefault(require("../../../../hooks/ramps/useRamps/useRamps"));
var _receiveModal = require("../../../multichain/receive-modal");
var _useBridging = _interopRequireDefault(require("../../../../hooks/bridge/useBridging"));
var _metametrics = require("../../../../../shared/constants/metametrics");
var _metametrics2 = require("../../../../contexts/metametrics");
var _conversion = require("../../../../../shared/modules/conversion.utils");
var _trace = require("../../../../../shared/lib/trace");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AddFundsModal = ({
  onClose,
  token,
  chainId,
  payerAddress
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    openBuyCryptoInPdapp
  } = (0, _useRamps.default)();
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const buyableChains = (0, _reactRedux.useSelector)(_ramps.getBuyableChains);
  const {
    openBridgeExperience
  } = (0, _useBridging.default)();
  const [showReceiveModal, setShowReceiveModal] = (0, _react.useState)(false);
  const isBuyableChain = (0, _react.useMemo)(() => {
    if (!chainId) {
      return false;
    }
    return buyableChains.some(network => String(network.chainId) === (0, _conversion.hexToDecimal)(chainId));
  }, [buyableChains, chainId]);
  const handleBuyAndSellOnClick = (0, _react.useCallback)(() => {
    openBuyCryptoInPdapp();
    trackEvent({
      event: _metametrics.MetaMetricsEventName.NavBuyButtonClicked,
      category: _metametrics.MetaMetricsEventCategory.Navigation,
      properties: {
        location: 'Transaction Shield',
        text: 'Buy',
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        chain_id: chainId,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        token_symbol: token.symbol
      }
    });
    onClose();
  }, [chainId, openBuyCryptoInPdapp, token.symbol, trackEvent]);
  const handleReceiveOnClick = (0, _react.useCallback)(() => {
    (0, _trace.trace)({
      name: _trace.TraceName.ReceiveModal
    });
    trackEvent({
      event: _metametrics.MetaMetricsEventName.NavReceiveButtonClicked,
      category: _metametrics.MetaMetricsEventCategory.Navigation,
      properties: {
        text: 'Receive',
        location: 'Transaction Shield',
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        chain_id: chainId
      }
    });
    setShowReceiveModal(true);
  }, [chainId, trackEvent]);
  const handleSwapOnClick = (0, _react.useCallback)(async () => {
    openBridgeExperience(_metametrics.MetaMetricsSwapsEventSource.TransactionShield, {
      symbol: token.symbol,
      address: token.address,
      chainId
    });
  }, [token, openBridgeExperience]);
  const buttonRow = ({
    label,
    iconName,
    onClick,
    id,
    disabled = false
  }) => {
    return /*#__PURE__*/_react.default.createElement(_designSystemReact.Box, {
      asChild: true,
      "data-testid": id,
      className: "add-funds-modal__row flex items-center w-full gap-3 p-4",
      onClick: onClick
    }, /*#__PURE__*/_react.default.createElement("button", {
      disabled: disabled
    }, /*#__PURE__*/_react.default.createElement(_designSystemReact.Icon, {
      name: iconName,
      size: _designSystemReact.IconSize.Lg,
      color: _designSystemReact.IconColor.IconAlternative
    }), /*#__PURE__*/_react.default.createElement(_designSystemReact.Text, {
      variant: _designSystemReact.TextVariant.BodyMd
    }, label)));
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: true,
    onClose: () => undefined,
    "data-testid": "add-funds-modal",
    className: "add-funds-modal"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onClose: onClose
  }, t('addFunds')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, {
    className: "add-funds-modal__body",
    paddingLeft: 0,
    paddingRight: 0
  }, buttonRow({
    id: 'add-funds-modal-buy-crypto-button',
    label: t('addFundsModalBuyCrypto'),
    iconName: _designSystemReact.IconName.Add,
    onClick: handleBuyAndSellOnClick,
    disabled: !isBuyableChain
  }), buttonRow({
    id: 'add-funds-modal-receive-crypto-button',
    label: t('addFundsModalReceiveTokens'),
    iconName: _designSystemReact.IconName.QrCode,
    onClick: handleReceiveOnClick
  }), buttonRow({
    id: 'add-funds-modal-swap-crypto-button',
    label: t('addFundsModalSwapTokens'),
    iconName: _designSystemReact.IconName.SwapHorizontal,
    onClick: handleSwapOnClick
  }), showReceiveModal && /*#__PURE__*/_react.default.createElement(_receiveModal.ReceiveModal, {
    address: payerAddress,
    onClose: () => setShowReceiveModal(false)
  }))));
};
var _default = exports.default = AddFundsModal;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\add-funds-modal\\add-funds-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\confirm-delete-network\\confirm-delete-network.component.js", {"../../modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modal\\index.js","@metamask/multichain-network-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-network-controller\\dist\\index.cjs","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cconfirm-delete-network%5Cconfirm-delete-network.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _multichainNetworkController = require("@metamask/multichain-network-controller");
var _modal = _interopRequireWildcard(require("../../modal"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class ConfirmDeleteNetwork extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "handleDelete", async () => {
      const {
        chainId,
        onConfirm,
        hideModal,
        removeNetwork,
        isChainToDeleteSelected,
        switchToEthereumNetwork,
        isMultichainAccountsFeatureEnabled
      } = this.props;

      // NOTE: We only support EVM networks removal, so the conversion is safe here.
      const caipChainId = (0, _multichainNetworkController.toEvmCaipChainId)(chainId);

      // NOTE: ensure that we are not deleting a selected evm chain
      if (isChainToDeleteSelected) {
        await (switchToEthereumNetwork === null || switchToEthereumNetwork === void 0 ? void 0 : switchToEthereumNetwork(isMultichainAccountsFeatureEnabled));
      }
      await removeNetwork(caipChainId);
      onConfirm();
      hideModal();
    });
  }
  render() {
    const {
      t
    } = this.context;
    const {
      networkNickname
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_modal.default, {
      onSubmit: this.handleDelete,
      onCancel: () => this.props.hideModal(),
      submitText: t('delete'),
      cancelText: t('cancel'),
      submitType: "danger-primary",
      testId: "confirm-delete-network-modal"
    }, /*#__PURE__*/_react.default.createElement(_modal.ModalContent, {
      title: t('deleteNetworkTitle', [networkNickname]),
      description: t('deleteNetworkIntro')
    }));
  }
}
exports.default = ConfirmDeleteNetwork;
_defineProperty(ConfirmDeleteNetwork, "propTypes", {
  hideModal: _propTypes.default.func.isRequired,
  removeNetwork: _propTypes.default.func.isRequired,
  onConfirm: _propTypes.default.func.isRequired,
  networkNickname: _propTypes.default.string.isRequired,
  chainId: _propTypes.default.string.isRequired,
  isChainToDeleteSelected: _propTypes.default.bool,
  switchToEthereumNetwork: _propTypes.default.func,
  isMultichainAccountsFeatureEnabled: _propTypes.default.bool
});
_defineProperty(ConfirmDeleteNetwork, "contextTypes", {
  t: _propTypes.default.func
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\confirm-delete-network\\confirm-delete-network.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\confirm-delete-network\\confirm-delete-network.container.js", {"../../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../../helpers/higher-order-components/with-modal-props":"D:\\code\\v\\metamask-extension\\ui\\helpers\\higher-order-components\\with-modal-props\\index.js","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./confirm-delete-network.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\confirm-delete-network\\confirm-delete-network.component.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","redux":"D:\\code\\v\\metamask-extension\\node_modules\\redux\\lib\\redux.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cconfirm-delete-network%5Cconfirm-delete-network.container.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactRedux = require("react-redux");
var _redux = require("redux");
var _withModalProps = _interopRequireDefault(require("../../../../helpers/higher-order-components/with-modal-props"));
var _actions = require("../../../../store/actions");
var _networks = require("../../../../../shared/modules/selectors/networks");
var _selectors = require("../../../../selectors");
var _confirmDeleteNetwork = _interopRequireDefault(require("./confirm-delete-network.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const mapStateToProps = (state, ownProps) => {
  const networks = (0, _networks.getNetworkConfigurationsByChainId)(state);
  const isMultichainAccountsFeatureEnabled = (0, _selectors.getIsMultichainAccountsState2Enabled)(state);
  let selectedEvmChainId;
  try {
    selectedEvmChainId = (0, _networks.getProviderConfig)(state).chainId;
  } catch {
    // Do nothing
  }
  const {
    chainId,
    name: networkNickname
  } = networks[ownProps.target];
  const isChainToDeleteSelected = chainId === selectedEvmChainId;
  return {
    chainId,
    networkNickname,
    isChainToDeleteSelected,
    isMultichainAccountsFeatureEnabled
  };
};
const mapDispatchToProps = dispatch => {
  return {
    switchToEthereumNetwork: async () => {
      await dispatch((0, _actions.setEnabledNetworks)('0x1'));
    },
    removeNetwork: chainId => {
      dispatch((0, _actions.removeNetwork)(chainId));
    }
  };
};
var _default = exports.default = (0, _redux.compose)(_withModalProps.default, (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps))(_confirmDeleteNetwork.default);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\confirm-delete-network\\confirm-delete-network.container.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\confirm-delete-network\\index.js", {"./confirm-delete-network.container":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\confirm-delete-network\\confirm-delete-network.container.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cconfirm-delete-network%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _confirmDeleteNetwork.default;
  }
});
var _confirmDeleteNetwork = _interopRequireDefault(require("./confirm-delete-network.container"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\confirm-delete-network\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\confirm-remove-account\\confirm-remove-account.component.js", {"../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../helpers/constants/zendesk-url":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\zendesk-url.js","../../../../helpers/utils/multichain/blockExplorer":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\multichain\\blockExplorer.ts","../../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../../ui/identicon":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\identicon\\index.js","../../modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modal\\index.js","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cconfirm-remove-account%5Cconfirm-remove-account.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _keyringApi = require("@metamask/keyring-api");
var _blockExplorer = require("../../../../helpers/utils/multichain/blockExplorer");
var _modal = _interopRequireDefault(require("../../modal"));
var _util = require("../../../../helpers/utils/util");
var _identicon = _interopRequireDefault(require("../../../ui/identicon"));
var _metametrics = require("../../../../../shared/constants/metametrics");
var _zendeskUrl = _interopRequireDefault(require("../../../../helpers/constants/zendesk-url"));
var _multichain = require("../../../../selectors/multichain");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class ConfirmRemoveAccount extends _react.Component {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "handleRemove", () => {
      this.props.removeAccount(this.props.account.address).then(() => this.props.hideModal());
    });
    _defineProperty(this, "handleCancel", () => {
      this.props.hideModal();
    });
  }
  renderSelectedAccount() {
    const {
      t
    } = this.context;
    const {
      account,
      network
    } = this.props;
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "confirm-remove-account__account"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "confirm-remove-account__account__identicon"
    }, /*#__PURE__*/_react.default.createElement(_identicon.default, {
      address: account.address,
      diameter: 32
    })), /*#__PURE__*/_react.default.createElement("div", {
      className: "confirm-remove-account__account__name"
    }, /*#__PURE__*/_react.default.createElement("span", {
      className: "confirm-remove-account__account__label"
    }, t('name')), /*#__PURE__*/_react.default.createElement("span", {
      className: "account_value"
    }, account.metadata.name)), /*#__PURE__*/_react.default.createElement("div", {
      className: "confirm-remove-account__account__address"
    }, /*#__PURE__*/_react.default.createElement("span", {
      className: "confirm-remove-account__account__label"
    }, t('publicAddress')), /*#__PURE__*/_react.default.createElement("span", {
      className: "account_value"
    }, (0, _util.addressSummary)(account.address, 4, 4, (0, _keyringApi.isEvmAccountType)(account.type)))), /*#__PURE__*/_react.default.createElement("div", {
      className: "confirm-remove-account__account__link"
    }, /*#__PURE__*/_react.default.createElement("a", {
      onClick: () => {
        const accountLink = (0, _blockExplorer.getMultichainAccountUrl)(account.address, network);
        this.context.trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Accounts,
          event: 'Clicked Block Explorer Link',
          properties: {
            link_type: 'Account Tracker',
            action: 'Remove Account',
            block_explorer_domain: (0, _util.getURLHostName)(accountLink)
          }
        });
        global.platform.openTab({
          url: accountLink
        });
      },
      target: "_blank",
      rel: "noopener noreferrer",
      title: t('etherscanView'),
      "data-testid": "explorer-link"
    }, /*#__PURE__*/_react.default.createElement("i", {
      className: "fa fa-share-square",
      style: {
        color: 'var(--color-icon-muted)'
      },
      title: t('etherscanView')
    }))));
  }
  render() {
    const {
      t
    } = this.context;
    return /*#__PURE__*/_react.default.createElement(_modal.default, {
      headerText: `${t('removeAccount')}?`,
      onClose: this.handleCancel,
      onSubmit: this.handleRemove,
      onCancel: this.handleCancel,
      submitText: t('remove'),
      cancelText: t('nevermind')
    }, /*#__PURE__*/_react.default.createElement("div", null, this.renderSelectedAccount(), /*#__PURE__*/_react.default.createElement("div", {
      className: "confirm-remove-account__description"
    }, t('removeAccountDescription'), /*#__PURE__*/_react.default.createElement("a", {
      className: "confirm-remove-account__link",
      rel: "noopener noreferrer",
      target: "_blank",
      href: _zendeskUrl.default.IMPORTED_ACCOUNTS
    }, t('learnMore')))));
  }
}
exports.default = ConfirmRemoveAccount;
_defineProperty(ConfirmRemoveAccount, "propTypes", {
  hideModal: _propTypes.default.func.isRequired,
  removeAccount: _propTypes.default.func.isRequired,
  account: _multichain.InternalAccountPropType.isRequired,
  network: _multichain.MultichainNetworkPropType.isRequired
});
_defineProperty(ConfirmRemoveAccount, "contextTypes", {
  t: _propTypes.default.func,
  trackEvent: _propTypes.default.func
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\confirm-remove-account\\confirm-remove-account.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\confirm-remove-account\\confirm-remove-account.container.js", {"../../../../helpers/higher-order-components/with-modal-props":"D:\\code\\v\\metamask-extension\\ui\\helpers\\higher-order-components\\with-modal-props\\index.js","../../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./confirm-remove-account.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\confirm-remove-account\\confirm-remove-account.component.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","redux":"D:\\code\\v\\metamask-extension\\node_modules\\redux\\lib\\redux.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cconfirm-remove-account%5Cconfirm-remove-account.container.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactRedux = require("react-redux");
var _redux = require("redux");
var _withModalProps = _interopRequireDefault(require("../../../../helpers/higher-order-components/with-modal-props"));
var _actions = require("../../../../store/actions");
var _multichain = require("../../../../selectors/multichain");
var _confirmRemoveAccount = _interopRequireDefault(require("./confirm-remove-account.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const mapStateToProps = (state, ownProps) => {
  return {
    network: (0, _multichain.getMultichainNetwork)(state, ownProps.account)
  };
};
const mapDispatchToProps = dispatch => {
  return {
    removeAccount: address => dispatch((0, _actions.removeAccount)(address))
  };
};
var _default = exports.default = (0, _redux.compose)(_withModalProps.default, (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps))(_confirmRemoveAccount.default);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\confirm-remove-account\\confirm-remove-account.container.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\confirm-remove-account\\index.js", {"./confirm-remove-account.container":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\confirm-remove-account\\confirm-remove-account.container.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cconfirm-remove-account%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _confirmRemoveAccount.default;
  }
});
var _confirmRemoveAccount = _interopRequireDefault(require("./confirm-remove-account.container"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\confirm-remove-account\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\confirm-reset-account\\confirm-reset-account.component.js", {"../../modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modal\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cconfirm-reset-account%5Cconfirm-reset-account.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _modal = _interopRequireWildcard(require("../../modal"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class ConfirmResetAccount extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "handleReset", () => {
      this.props.resetAccount().then(() => this.props.hideModal());
    });
  }
  render() {
    const {
      t
    } = this.context;
    return /*#__PURE__*/_react.default.createElement(_modal.default, {
      onSubmit: this.handleReset,
      onCancel: () => this.props.hideModal(),
      submitText: t('clear'),
      cancelText: t('nevermind'),
      submitType: "danger-primary"
    }, /*#__PURE__*/_react.default.createElement(_modal.ModalContent, {
      title: `${t('clearActivity')}?`,
      description: t('clearActivityDescription')
    }));
  }
}
exports.default = ConfirmResetAccount;
_defineProperty(ConfirmResetAccount, "propTypes", {
  hideModal: _propTypes.default.func.isRequired,
  resetAccount: _propTypes.default.func.isRequired
});
_defineProperty(ConfirmResetAccount, "contextTypes", {
  t: _propTypes.default.func
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\confirm-reset-account\\confirm-reset-account.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\confirm-reset-account\\confirm-reset-account.container.js", {"../../../../helpers/higher-order-components/with-modal-props":"D:\\code\\v\\metamask-extension\\ui\\helpers\\higher-order-components\\with-modal-props\\index.js","../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./confirm-reset-account.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\confirm-reset-account\\confirm-reset-account.component.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","redux":"D:\\code\\v\\metamask-extension\\node_modules\\redux\\lib\\redux.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cconfirm-reset-account%5Cconfirm-reset-account.container.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactRedux = require("react-redux");
var _redux = require("redux");
var _withModalProps = _interopRequireDefault(require("../../../../helpers/higher-order-components/with-modal-props"));
var _actions = require("../../../../store/actions");
var _confirmResetAccount = _interopRequireDefault(require("./confirm-reset-account.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const mapDispatchToProps = dispatch => {
  return {
    resetAccount: () => dispatch((0, _actions.resetAccount)())
  };
};
var _default = exports.default = (0, _redux.compose)(_withModalProps.default, (0, _reactRedux.connect)(null, mapDispatchToProps))(_confirmResetAccount.default);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\confirm-reset-account\\confirm-reset-account.container.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\confirm-reset-account\\index.js", {"./confirm-reset-account.container":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\confirm-reset-account\\confirm-reset-account.container.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cconfirm-reset-account%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _confirmResetAccount.default;
  }
});
var _confirmResetAccount = _interopRequireDefault(require("./confirm-reset-account.container"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\confirm-reset-account\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\convert-token-to-nft-modal\\convert-token-to-nft-modal.js", {"../../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../../../shared/modules/string-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\string-utils.ts","../../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../../helpers/higher-order-components/with-modal-props":"D:\\code\\v\\metamask-extension\\ui\\helpers\\higher-order-components\\with-modal-props\\index.js","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../../component-library/text":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\text\\index.ts","../../modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modal\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cconvert-token-to-nft-modal%5Cconvert-token-to-nft-modal.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _modal = _interopRequireDefault(require("../../modal"));
var _text = require("../../../component-library/text");
var _withModalProps = _interopRequireDefault(require("../../../../helpers/higher-order-components/with-modal-props"));
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _routes = require("../../../../helpers/constants/routes");
var _metamask = require("../../../../ducks/metamask/metamask");
var _actions = require("../../../../store/actions");
var _stringUtils = require("../../../../../shared/modules/string-utils");
var _networks = require("../../../../../shared/modules/selectors/networks");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const ConvertTokenToNFTModal = ({
  hideModal,
  tokenAddress
}) => {
  const history = (0, _reactRouterDom.useHistory)();
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const allNfts = (0, _reactRedux.useSelector)(_metamask.getNfts);
  const tokenAddedAsNFT = allNfts.find(({
    address
  }) => (0, _stringUtils.isEqualCaseInsensitive)(address, tokenAddress));
  const networkClientId = (0, _reactRedux.useSelector)(_networks.getSelectedNetworkClientId);
  return /*#__PURE__*/_react.default.createElement(_modal.default, {
    onSubmit: async () => {
      if (tokenAddedAsNFT) {
        await dispatch((0, _actions.ignoreTokens)({
          tokensToIgnore: tokenAddress,
          dontShowLoadingIndicator: true,
          networkClientId
        }));
        const {
          tokenId
        } = tokenAddedAsNFT;
        history.push({
          pathname: `${_routes.ASSET_ROUTE}/${tokenAddress}/${tokenId}`
        });
      } else {
        dispatch((0, _actions.showImportNftsModal)({
          tokenAddress,
          ignoreErc20Token: true
        }));
      }
      hideModal();
    },
    submitText: t('yes'),
    onCancel: () => hideModal(),
    cancelText: t('cancel')
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "convert-token-to-nft-modal"
  }, /*#__PURE__*/_react.default.createElement(_text.Text, {
    marginTop: 2
  }, tokenAddedAsNFT ? t('convertTokenToNFTExistDescription') : t('convertTokenToNFTDescription'))));
};
ConvertTokenToNFTModal.propTypes = {
  hideModal: _propTypes.default.func.isRequired,
  tokenAddress: _propTypes.default.string
};
var _default = exports.default = (0, _withModalProps.default)(ConvertTokenToNFTModal);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\convert-token-to-nft-modal\\convert-token-to-nft-modal.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\customize-nonce\\customize-nonce.component.js", {"../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/constants/zendesk-url":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\zendesk-url.js","../../../../helpers/higher-order-components/with-modal-props":"D:\\code\\v\\metamask-extension\\ui\\helpers\\higher-order-components\\with-modal-props\\index.js","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../ui/text-field":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\text-field\\index.js","../../modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modal\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Ccustomize-nonce%5Ccustomize-nonce.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _modal = _interopRequireDefault(require("../../modal"));
var _textField = _interopRequireDefault(require("../../../ui/text-field"));
var _designSystem = require("../../../../helpers/constants/design-system");
var _withModalProps = _interopRequireDefault(require("../../../../helpers/higher-order-components/with-modal-props"));
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _zendeskUrl = _interopRequireDefault(require("../../../../helpers/constants/zendesk-url"));
var _componentLibrary = require("../../../component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CustomizeNonce = ({
  hideModal,
  customNonceValue,
  nextNonce,
  updateCustomNonce,
  getNextNonce
}) => {
  const defaultNonce = customNonceValue || typeof nextNonce === 'number' && nextNonce.toString();
  const [customNonce, setCustomNonce] = (0, _react.useState)(defaultNonce);
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_modal.default, {
    onSubmit: () => {
      if (customNonce === '') {
        updateCustomNonce(customNonceValue);
      } else {
        updateCustomNonce(customNonce);
      }
      getNextNonce();
      hideModal();
    },
    submitText: t('save'),
    onCancel: () => hideModal(),
    cancelText: t('cancel'),
    contentClass: "customize-nonce-modal-content",
    containerClass: "customize-nonce-modal-container"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "customize-nonce-modal"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "customize-nonce-modal__main-header"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    className: "customize-nonce-modal__main-title",
    variant: _designSystem.TextVariant.headingSm,
    as: "h4"
  }, t('editNonceField')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    iconName: _componentLibrary.IconName.Close,
    className: "customize-nonce-modal__close",
    size: _componentLibrary.ButtonIconSize.Sm,
    ariaLabel: t('close'),
    onClick: hideModal
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginTop: 2,
    display: _designSystem.Display.InlineFlex,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    as: "h6"
  }, t('editNonceMessage'), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    className: "customize-nonce-modal__link",
    rel: "noopener noreferrer",
    target: "_blank",
    href: _zendeskUrl.default.CUSTOMIZE_NONCE
  }, t('learnMoreUpperCase')))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginTop: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    alignItems: _designSystem.AlignItems.center,
    display: _designSystem.Display.Flex
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdBold,
    as: "h6",
    width: _designSystem.BlockSize.FiveSixths
  }, t('editNonceField')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    width: _designSystem.BlockSize.OneSixth
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    className: "customize-nonce-modal__reset",
    "data-testid": "customize-nonce-reset",
    onClick: () => {
      setCustomNonce(nextNonce);
    }
  }, t('reset')))), /*#__PURE__*/_react.default.createElement("div", {
    className: "customize-nonce-modal__input"
  }, /*#__PURE__*/_react.default.createElement(_textField.default, {
    type: "number",
    "data-testid": "custom-nonce-input",
    min: "0",
    placeholder: defaultNonce,
    onChange: e => {
      // Prevent decimal nonce values
      const sanitizedValue = e.target.value.replace(/[.,]/gu, '');
      setCustomNonce(sanitizedValue);
    },
    fullWidth: true,
    margin: "dense",
    value: customNonce,
    id: "custom-nonce-id"
  })))));
};
CustomizeNonce.propTypes = {
  hideModal: _propTypes.default.func.isRequired,
  customNonceValue: _propTypes.default.string,
  nextNonce: _propTypes.default.number,
  updateCustomNonce: _propTypes.default.func,
  getNextNonce: _propTypes.default.func
};
var _default = exports.default = (0, _withModalProps.default)(CustomizeNonce);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\customize-nonce\\customize-nonce.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\customize-nonce\\index.js", {"./customize-nonce.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\customize-nonce\\customize-nonce.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Ccustomize-nonce%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _customizeNonce.default;
  }
});
var _customizeNonce = _interopRequireDefault(require("./customize-nonce.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\customize-nonce\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\edit-approval-permission\\edit-approval-permission.component.js", {"../../../../../shared/lib/transactions-controller-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\transactions-controller-utils.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../ui/identicon":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\identicon\\index.js","../../../ui/text-field":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\text-field\\index.js","../../modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modal\\index.js","bignumber.js":"D:\\code\\v\\metamask-extension\\node_modules\\bignumber.js\\bignumber.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cedit-approval-permission%5Cedit-approval-permission.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _loglevel = _interopRequireDefault(require("loglevel"));
var _classnames = _interopRequireDefault(require("classnames"));
var _bignumber = _interopRequireDefault(require("bignumber.js"));
var _modal = _interopRequireDefault(require("../../modal"));
var _identicon = _interopRequireDefault(require("../../../ui/identicon"));
var _textField = _interopRequireDefault(require("../../../ui/text-field"));
var _transactionsControllerUtils = require("../../../../../shared/lib/transactions-controller-utils");
var _componentLibrary = require("../../../component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
const MAX_UNSIGNED_256_INT = new _bignumber.default(2).pow(256).minus(1).toString(10);
class EditApprovalPermission extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "state", {
      // This is used as a TextField value, which should be a string.
      customSpendLimit: this.props.customTokenAmount || '',
      selectedOptionIsUnlimited: !this.props.customTokenAmount
    });
  }
  renderModalContent(error) {
    const {
      t
    } = this.context;
    const {
      hideModal,
      selectedAccount,
      tokenAmount,
      tokenSymbol,
      tokenBalance,
      customTokenAmount,
      origin
    } = this.props;
    const {
      name,
      address
    } = selectedAccount || {};
    const {
      selectedOptionIsUnlimited
    } = this.state;
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "edit-approval-permission"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "edit-approval-permission__header"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "edit-approval-permission__title"
    }, t('editPermission')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      iconName: _componentLibrary.IconName.Close,
      size: _componentLibrary.ButtonIconSize.Lg,
      className: "edit-approval-permission__header__close",
      onClick: hideModal
    })), /*#__PURE__*/_react.default.createElement("div", {
      className: "edit-approval-permission__account-info"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "edit-approval-permission__account-info__account"
    }, /*#__PURE__*/_react.default.createElement(_identicon.default, {
      address: address,
      diameter: 32
    }), /*#__PURE__*/_react.default.createElement("div", {
      className: "edit-approval-permission__name-and-balance-container"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "edit-approval-permission__account-info__name"
    }, name), /*#__PURE__*/_react.default.createElement("div", null, t('balance')))), /*#__PURE__*/_react.default.createElement("div", {
      className: "edit-approval-permission__account-info__balance"
    }, `${(0, _transactionsControllerUtils.toPrecisionWithoutTrailingZeros)(tokenBalance, 9)} ${tokenSymbol}`)), /*#__PURE__*/_react.default.createElement("div", {
      className: "edit-approval-permission__edit-section"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "edit-approval-permission__edit-section__title"
    }, t('spendLimitPermission')), /*#__PURE__*/_react.default.createElement("div", {
      className: "edit-approval-permission__edit-section__description"
    }, t('allowWithdrawAndSpend', [origin])), /*#__PURE__*/_react.default.createElement("div", {
      className: "edit-approval-permission__edit-section__option"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "edit-approval-permission__edit-section__radio-button",
      onClick: () => this.setState({
        selectedOptionIsUnlimited: true
      })
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: (0, _classnames.default)({
        'edit-approval-permission__edit-section__radio-button-outline': !selectedOptionIsUnlimited,
        'edit-approval-permission__edit-section__radio-button-outline--selected': selectedOptionIsUnlimited
      })
    }), /*#__PURE__*/_react.default.createElement("div", {
      className: "edit-approval-permission__edit-section__radio-button-fill"
    }), selectedOptionIsUnlimited && /*#__PURE__*/_react.default.createElement("div", {
      className: "edit-approval-permission__edit-section__radio-button-dot"
    })), /*#__PURE__*/_react.default.createElement("div", {
      className: "edit-approval-permission__edit-section__option-text"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: (0, _classnames.default)({
        'edit-approval-permission__edit-section__option-label': !selectedOptionIsUnlimited,
        'edit-approval-permission__edit-section__option-label--selected': selectedOptionIsUnlimited
      })
    }, new _bignumber.default(tokenAmount).equals(new _bignumber.default(MAX_UNSIGNED_256_INT)) ? t('unlimited') : t('proposedApprovalLimit')), /*#__PURE__*/_react.default.createElement("div", {
      className: "edit-approval-permission__edit-section__option-description"
    }, t('spendLimitRequestedBy', [origin])), /*#__PURE__*/_react.default.createElement("div", {
      className: "edit-approval-permission__edit-section__option-value"
    }, `${Number(tokenAmount)} ${tokenSymbol}`))), /*#__PURE__*/_react.default.createElement("div", {
      className: "edit-approval-permission__edit-section__option"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "edit-approval-permission__edit-section__radio-button",
      onClick: () => this.setState({
        selectedOptionIsUnlimited: false
      })
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: (0, _classnames.default)({
        'edit-approval-permission__edit-section__radio-button-outline': selectedOptionIsUnlimited,
        'edit-approval-permission__edit-section__radio-button-outline--selected': !selectedOptionIsUnlimited
      })
    }), /*#__PURE__*/_react.default.createElement("div", {
      className: "edit-approval-permission__edit-section__radio-button-fill"
    }), !selectedOptionIsUnlimited && /*#__PURE__*/_react.default.createElement("div", {
      className: "edit-approval-permission__edit-section__radio-button-dot"
    })), /*#__PURE__*/_react.default.createElement("div", {
      className: "edit-approval-permission__edit-section__option-text"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: (0, _classnames.default)({
        'edit-approval-permission__edit-section__option-label': selectedOptionIsUnlimited,
        'edit-approval-permission__edit-section__option-label--selected': !selectedOptionIsUnlimited
      })
    }, t('customSpendLimit')), /*#__PURE__*/_react.default.createElement("div", {
      className: "edit-approval-permission__edit-section__option-description"
    }, t('enterMaxSpendLimit')), /*#__PURE__*/_react.default.createElement("div", {
      className: "edit-approval-permission__edit-section__option-input"
    }, /*#__PURE__*/_react.default.createElement(_textField.default, {
      type: "number",
      placeholder: `${Number(customTokenAmount || tokenAmount)} ${tokenSymbol}`,
      onChange: event => {
        this.setState({
          customSpendLimit: event.target.value
        });
        if (selectedOptionIsUnlimited) {
          this.setState({
            selectedOptionIsUnlimited: false
          });
        }
      },
      fullWidth: true,
      margin: "dense",
      value: this.state.customSpendLimit,
      error: error
    }))))));
  }
  validateSpendLimit() {
    const {
      t
    } = this.context;
    const {
      decimals,
      requiredMinimum
    } = this.props;
    const {
      selectedOptionIsUnlimited,
      customSpendLimit
    } = this.state;
    if (selectedOptionIsUnlimited || !customSpendLimit) {
      return undefined;
    }
    let customSpendLimitNumber;
    try {
      customSpendLimitNumber = new _bignumber.default(customSpendLimit);
    } catch (error) {
      _loglevel.default.debug(`Error converting '${customSpendLimit}' to BigNumber:`, error);
      return t('spendLimitInvalid');
    }
    if (customSpendLimitNumber.isNegative()) {
      return t('spendLimitInvalid');
    }
    const maxTokenAmount = (0, _transactionsControllerUtils.calcTokenAmount)(MAX_UNSIGNED_256_INT, decimals);
    if (customSpendLimitNumber.greaterThan(maxTokenAmount)) {
      return t('spendLimitTooLarge');
    }
    if (requiredMinimum !== undefined && customSpendLimitNumber.lessThan(requiredMinimum)) {
      return t('spendLimitInsufficient');
    }
    return undefined;
  }
  render() {
    const {
      t
    } = this.context;
    const {
      setCustomAmount,
      hideModal,
      customTokenAmount
    } = this.props;
    const {
      selectedOptionIsUnlimited,
      customSpendLimit
    } = this.state;
    const error = this.validateSpendLimit();
    const disabled = Boolean(customSpendLimit === customTokenAmount && !selectedOptionIsUnlimited || error);
    return /*#__PURE__*/_react.default.createElement(_modal.default, {
      onSubmit: () => {
        setCustomAmount(selectedOptionIsUnlimited ? '' : customSpendLimit);
        hideModal();
      },
      submitText: t('save'),
      contentClass: "edit-approval-permission-modal-content",
      containerClass: "edit-approval-permission-modal-container",
      submitDisabled: disabled
    }, this.renderModalContent(error));
  }
}
exports.default = EditApprovalPermission;
_defineProperty(EditApprovalPermission, "propTypes", {
  decimals: _propTypes.default.number,
  hideModal: _propTypes.default.func.isRequired,
  selectedAccount: _propTypes.default.object,
  tokenAmount: _propTypes.default.string,
  customTokenAmount: _propTypes.default.string,
  tokenSymbol: _propTypes.default.string,
  tokenBalance: _propTypes.default.string,
  setCustomAmount: _propTypes.default.func,
  origin: _propTypes.default.string.isRequired,
  requiredMinimum: _propTypes.default.instanceOf(_bignumber.default)
});
_defineProperty(EditApprovalPermission, "contextTypes", {
  t: _propTypes.default.func
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\edit-approval-permission\\edit-approval-permission.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\edit-approval-permission\\edit-approval-permission.container.js", {"../../../../helpers/higher-order-components/with-modal-props":"D:\\code\\v\\metamask-extension\\ui\\helpers\\higher-order-components\\with-modal-props\\index.js","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","./edit-approval-permission.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\edit-approval-permission\\edit-approval-permission.component.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","redux":"D:\\code\\v\\metamask-extension\\node_modules\\redux\\lib\\redux.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cedit-approval-permission%5Cedit-approval-permission.container.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactRedux = require("react-redux");
var _redux = require("redux");
var _withModalProps = _interopRequireDefault(require("../../../../helpers/higher-order-components/with-modal-props"));
var _selectors = require("../../../../selectors");
var _editApprovalPermission = _interopRequireDefault(require("./edit-approval-permission.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const mapStateToProps = state => {
  const modalStateProps = state.appState.modal.modalState.props || {};
  return {
    selectedAccount: (0, _selectors.getSelectedInternalAccount)(state),
    ...modalStateProps
  };
};
var _default = exports.default = (0, _redux.compose)(_withModalProps.default, (0, _reactRedux.connect)(mapStateToProps))(_editApprovalPermission.default);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\edit-approval-permission\\edit-approval-permission.container.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\edit-approval-permission\\index.js", {"./edit-approval-permission.container":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\edit-approval-permission\\edit-approval-permission.container.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cedit-approval-permission%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _editApprovalPermission.default;
  }
});
var _editApprovalPermission = _interopRequireDefault(require("./edit-approval-permission.container"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\edit-approval-permission\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\fade-modal.js", {"prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cfade-modal.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
let index = 0;
let extraSheet;
const insertRule = css => {
  if (!extraSheet) {
    // First time, create an extra stylesheet for adding rules
    extraSheet = document.createElement('style');
    document.getElementsByTagName('head')[0].appendChild(extraSheet);
    // Keep reference to actual StyleSheet object (`styleSheet` for IE < 9)
    extraSheet = extraSheet.sheet || extraSheet.styleSheet;
  }
  extraSheet.insertRule(css, (extraSheet.cssRules || extraSheet.rules).length);
  return extraSheet;
};
const insertKeyframesRule = keyframes => {
  // random name
  // eslint-disable-next-line no-plusplus
  const name = `anim_${++index}${Number(new Date())}`;
  let css = `@keyframes ${name} {`;
  Object.keys(keyframes).forEach(key => {
    css += `${key} {`;
    Object.keys(keyframes[key]).forEach(property => {
      const part = `:${keyframes[key][property]};`;
      css += property + part;
    });
    css += '}';
  });
  css += '}';
  insertRule(css);
  return name;
};
const animation = {
  show: {
    animationDuration: '0.3s',
    animationTimingFunction: 'ease-out'
  },
  hide: {
    animationDuration: '0.3s',
    animationTimingFunction: 'ease-out'
  },
  showContentAnimation: insertKeyframesRule({
    '0%': {
      opacity: 0
    },
    '100%': {
      opacity: 1
    }
  }),
  hideContentAnimation: insertKeyframesRule({
    '0%': {
      opacity: 1
    },
    '100%': {
      opacity: 0
    }
  }),
  showBackdropAnimation: insertKeyframesRule({
    '0%': {
      opacity: 0
    },
    '100%': {
      opacity: 0.9
    }
  }),
  hideBackdropAnimation: insertKeyframesRule({
    '0%': {
      opacity: 0.9
    },
    '100%': {
      opacity: 0
    }
  })
};
const endEvents = ['transitionend', 'animationend'];
function addEventListener(node, eventName, eventListener) {
  node.addEventListener(eventName, eventListener, false);
}
function removeEventListener(node, eventName, eventListener) {
  node.removeEventListener(eventName, eventListener, false);
}
const removeEndEventListener = (node, eventListener) => {
  if (endEvents.length === 0) {
    return;
  }
  endEvents.forEach(function (endEvent) {
    removeEventListener(node, endEvent, eventListener);
  });
};
const addEndEventListener = (node, eventListener) => {
  if (endEvents.length === 0) {
    // If CSS transitions are not supported, trigger an "end animation"
    // event immediately.
    window.setTimeout(eventListener, 0);
    return;
  }
  endEvents.forEach(function (endEvent) {
    addEventListener(node, endEvent, eventListener);
  });
};
class FadeModal extends _react.Component {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "content", null);
    _defineProperty(this, "state", {
      willHide: true,
      hidden: true
    });
    _defineProperty(this, "addTransitionListener", (node, handle) => {
      if (node) {
        const endListener = function (e) {
          if (e && e.target !== node) {
            return;
          }
          removeEndEventListener(node, endListener);
          handle();
        };
        addEndEventListener(node, endListener);
      }
    });
    _defineProperty(this, "handleBackdropClick", () => {
      if (this.props.closeOnClick) {
        this.hide();
      }
    });
    _defineProperty(this, "hasHidden", () => {
      return this.state.hidden;
    });
    _defineProperty(this, "leave", () => {
      this.setState({
        hidden: true
      });
      this.props.onHide(this.state.hideSource);
    });
    _defineProperty(this, "enter", () => {
      this.props.onShow();
    });
    _defineProperty(this, "show", () => {
      if (!this.state.hidden) {
        return;
      }
      this.setState({
        willHide: false,
        hidden: false
      });
      setTimeout(function () {
        this.addTransitionListener(this.content, this.enter);
      }.bind(this), 0);
    });
    _defineProperty(this, "hide", () => {
      if (this.hasHidden()) {
        return;
      }
      this.setState({
        willHide: true
      });
    });
    _defineProperty(this, "listenKeyboard", event => {
      if (typeof this.props.keyboard === 'function') {
        this.props.keyboard(event);
      } else {
        this.closeOnEsc(event);
      }
    });
    _defineProperty(this, "closeOnEsc", event => {
      if (this.props.keyboard && (event.key === 'Escape' || event.keyCode === 27)) {
        this.hide();
      }
    });
    _defineProperty(this, "UNSAFE_componentDidMount", () => {
      window.addEventListener('keydown', this.listenKeyboard, true);
    });
    _defineProperty(this, "UNSAFE_componentWillUnmount", () => {
      window.removeEventListener('keydown', this.listenKeyboard, true);
    });
  }
  render() {
    if (this.state.hidden) {
      return null;
    }
    const {
      willHide
    } = this.state;
    const {
      modalStyle,
      testId
    } = this.props;
    const backdropStyle = {
      animationName: willHide ? animation.hideBackdropAnimation : animation.showBackdropAnimation,
      animationTimingFunction: (willHide ? animation.hide : animation.show).animationTimingFunction,
      ...this.props.backdropStyle
    };
    const contentStyle = {
      animationDuration: (willHide ? animation.hide : animation.show).animationDuration,
      animationName: willHide ? animation.hideContentAnimation : animation.showContentAnimation,
      animationTimingFunction: (willHide ? animation.hide : animation.show).animationTimingFunction,
      ...this.props.contentStyle
    };
    const backdrop = this.props.backdrop ? /*#__PURE__*/_react.default.createElement("div", {
      className: "modal__backdrop",
      style: backdropStyle,
      onClick: this.props.closeOnClick ? this.handleBackdropClick : null
    }) : undefined;
    if (willHide) {
      this.addTransitionListener(this.content, this.leave);
    }
    return /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement("div", {
      className: "modal",
      style: modalStyle,
      "data-testid": testId
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "modal__content",
      ref: el => this.content = el,
      tabIndex: "-1",
      style: contentStyle
    }, this.props.children)), backdrop);
  }
}
_defineProperty(FadeModal, "propTypes", {
  backdrop: _propTypes.default.bool,
  backdropStyle: _propTypes.default.object,
  closeOnClick: _propTypes.default.bool,
  contentStyle: _propTypes.default.object,
  keyboard: _propTypes.default.bool,
  modalStyle: _propTypes.default.object,
  onShow: _propTypes.default.func,
  onHide: _propTypes.default.func,
  children: _propTypes.default.node,
  testId: _propTypes.default.string
});
_defineProperty(FadeModal, "defaultProps", {
  testId: '',
  onShow: () => undefined,
  onHide: () => undefined,
  keyboard: true,
  backdrop: true,
  closeOnClick: true,
  modalStyle: {},
  backdropStyle: {},
  contentStyle: {},
  children: []
});
var _default = exports.default = FadeModal;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\fade-modal.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\hide-token-confirmation-modal\\hide-token-confirmation-modal.js", {"../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../ui/identicon":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\identicon\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Chide-token-confirmation-modal%5Chide-token-confirmation-modal.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var actions = _interopRequireWildcard(require("../../../../store/actions"));
var _identicon = _interopRequireDefault(require("../../../ui/identicon"));
var _componentLibrary = require("../../../component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _routes = require("../../../../helpers/constants/routes");
var _metametrics = require("../../../../../shared/constants/metametrics");
var _networks = require("../../../../../shared/modules/selectors/networks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function mapStateToProps(state) {
  return {
    chainId: (0, _networks.getCurrentChainId)(state),
    token: state.appState.modal.modalState.props.token,
    history: state.appState.modal.modalState.props.history,
    networkConfigurationsByChainId: (0, _networks.getNetworkConfigurationsByChainId)(state)
  };
}
function mapDispatchToProps(dispatch) {
  return {
    hideModal: () => dispatch(actions.hideModal()),
    hideToken: async (address, networkClientId) => {
      await dispatch(actions.ignoreTokens({
        tokensToIgnore: address,
        networkClientId
      }));
      dispatch(actions.hideModal());
    }
  };
}
class HideTokenConfirmationModal extends _react.Component {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "state", {});
  }
  render() {
    const {
      chainId,
      token,
      hideToken,
      hideModal,
      history,
      networkConfigurationsByChainId
    } = this.props;
    const {
      symbol,
      address,
      image,
      chainId: tokenChainId
    } = token;
    const chainIdToUse = tokenChainId || chainId;
    const chainConfig = networkConfigurationsByChainId[chainIdToUse];
    const {
      defaultRpcEndpointIndex
    } = chainConfig;
    const {
      networkClientId: networkInstanceId
    } = chainConfig.rpcEndpoints[defaultRpcEndpointIndex];
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "hide-token-confirmation__container"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "hide-token-confirmation__title"
    }, this.context.t('hideTokenPrompt')), /*#__PURE__*/_react.default.createElement(_identicon.default, {
      className: "hide-token-confirmation__identicon",
      diameter: 45,
      address: address,
      image: image
    }), /*#__PURE__*/_react.default.createElement("div", {
      className: "hide-token-confirmation__symbol"
    }, symbol), /*#__PURE__*/_react.default.createElement("div", {
      className: "hide-token-confirmation__copy"
    }, this.context.t('readdToken')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      justifyContent: _designSystem.JustifyContent.Center,
      alignItems: _designSystem.AlignItems.Center,
      gap: 4,
      marginTop: 4,
      width: _designSystem.BlockSize.Full
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
      variant: _componentLibrary.ButtonVariant.Secondary,
      block: true,
      "data-testid": "hide-token-confirmation__cancel",
      onClick: () => hideModal()
    }, this.context.t('cancel')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
      variant: _componentLibrary.ButtonVariant.Primary,
      block: true,
      "data-testid": "hide-token-confirmation__hide",
      onClick: () => {
        this.context.trackEvent({
          event: _metametrics.MetaMetricsEventName.TokenRemoved,
          category: _metametrics.MetaMetricsEventCategory.Tokens,
          sensitiveProperties: {
            chain_id: chainId,
            token_contract_address: address,
            token_symbol: symbol
          }
        });
        hideToken(address, networkInstanceId);
        history.push(_routes.DEFAULT_ROUTE);
      }
    }, this.context.t('hide'))));
  }
}
_defineProperty(HideTokenConfirmationModal, "contextTypes", {
  t: _propTypes.default.func,
  trackEvent: _propTypes.default.func
});
_defineProperty(HideTokenConfirmationModal, "propTypes", {
  hideToken: _propTypes.default.func.isRequired,
  hideModal: _propTypes.default.func.isRequired,
  chainId: _propTypes.default.string.isRequired,
  networkConfigurationsByChainId: _propTypes.default.object.isRequired,
  token: _propTypes.default.shape({
    symbol: _propTypes.default.string,
    address: _propTypes.default.string,
    image: _propTypes.default.string,
    chainId: _propTypes.default.string
  }),
  history: _propTypes.default.object
});
var _default = exports.default = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(HideTokenConfirmationModal);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\hide-token-confirmation-modal\\hide-token-confirmation-modal.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\hide-token-confirmation-modal\\index.js", {"./hide-token-confirmation-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\hide-token-confirmation-modal\\hide-token-confirmation-modal.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Chide-token-confirmation-modal%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _hideTokenConfirmationModal.default;
  }
});
var _hideTokenConfirmationModal = _interopRequireDefault(require("./hide-token-confirmation-modal"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\hide-token-confirmation-modal\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\hold-to-reveal-modal\\hold-to-reveal-modal.tsx", {"../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/constants/zendesk-url":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\zendesk-url.js","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../hold-to-reveal-button/hold-to-reveal-button":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\hold-to-reveal-button\\hold-to-reveal-button.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Chold-to-reveal-modal%5Chold-to-reveal-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = HoldToRevealModal;
var _react = _interopRequireDefault(require("react"));
var _designSystem = require("../../../../helpers/constants/design-system");
var _zendeskUrl = _interopRequireDefault(require("../../../../helpers/constants/zendesk-url"));
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _componentLibrary = require("../../../component-library");
var _holdToRevealButton = _interopRequireDefault(require("../../hold-to-reveal-button/hold-to-reveal-button"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function HoldToRevealModal({
  isOpen,
  onClose,
  onLongPressed,
  holdToRevealType
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  const holdToRevealTitle = holdToRevealType === 'SRP' ? 'holdToRevealSRPTitle' : 'holdToRevealPrivateKeyTitle';
  const holdToRevealButton = holdToRevealType === 'SRP' ? 'holdToRevealSRP' : 'holdToRevealPrivateKey';
  const holdToRevealContent = holdToRevealType === 'SRP' ? 'holdToRevealContent' : 'holdToRevealContentPrivateKey';

  // If this is done inline, verify-locales will output `Forbidden use of template strings in 't' function`
  const holdToRevealContent1 = `${holdToRevealContent}1`;
  const holdToRevealContent2 = `${holdToRevealContent}2`;

  // This is here to stop yarn verify-locales from removing these strings
  t('holdToRevealContentPrivateKey1');
  t('holdToRevealContentPrivateKey2');
  t('holdToRevealContent1');
  t('holdToRevealContent2');
  const MainContent = () => {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      gap: 4,
      marginTop: 4,
      marginBottom: 6
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMd
    }, t(holdToRevealContent1, [/*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      key: "hold-to-reveal-2",
      variant: _designSystem.TextVariant.bodyMdBold,
      as: "span"
    }, t(holdToRevealContent2))])), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMdBold
    }, t('holdToRevealContent3', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      key: "hold-to-reveal-4",
      variant: _designSystem.TextVariant.bodyMd,
      as: "span",
      display: _designSystem.Display.Inline
    }, t('holdToRevealContent4')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
      key: "hold-to-reveal-5",
      variant: _componentLibrary.ButtonVariant.Link,
      size: _componentLibrary.ButtonSize.Inherit,
      href: _zendeskUrl.default.NON_CUSTODIAL_WALLET,
      externalLink: true
    }, t('holdToRevealContent5'))])));
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: isOpen,
    onClose: onClose
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onClose: onClose
  }, t(holdToRevealTitle)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Container, {
    paddingLeft: 4,
    paddingRight: 4
  }, /*#__PURE__*/_react.default.createElement(MainContent, null), /*#__PURE__*/_react.default.createElement(_holdToRevealButton.default, {
    buttonText: t(holdToRevealButton),
    onLongPressed: onLongPressed
  }))));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\hold-to-reveal-modal\\hold-to-reveal-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\identity\\confirm-turn-on-backup-and-sync-modal\\confirm-turn-on-backup-and-sync-modal.tsx", {"../../../../../ducks/app/app":"D:\\code\\v\\metamask-extension\\ui\\ducks\\app\\app.ts","../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../../hooks/useModalProps":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useModalProps.ts","../../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cidentity%5Cconfirm-turn-on-backup-and-sync-modal%5Cconfirm-turn-on-backup-and-sync-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CONFIRM_TURN_ON_BACKUP_AND_SYNC_MODAL_NAME = void 0;
exports.ConfirmTurnOnBackupAndSyncModal = ConfirmTurnOnBackupAndSyncModal;
exports.confirmTurnOnBackupAndSyncModalTestIds = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _useModalProps = require("../../../../../hooks/useModalProps");
var _componentLibrary = require("../../../../component-library");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../../hooks/useI18nContext");
var _actions = require("../../../../../store/actions");
var _app = require("../../../../../ducks/app/app");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const CONFIRM_TURN_ON_BACKUP_AND_SYNC_MODAL_NAME = exports.CONFIRM_TURN_ON_BACKUP_AND_SYNC_MODAL_NAME = 'CONFIRM_TURN_ON_BACKUP_AND_SYNC';
const confirmTurnOnBackupAndSyncModalTestIds = exports.confirmTurnOnBackupAndSyncModalTestIds = {
  modal: 'confirm-turn-on-backup-and-sync-modal',
  toggleButton: 'confirm-turn-on-backup-and-sync-toggle-button',
  cancelButton: 'confirm-turn-on-backup-and-sync-cancel-button'
};

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function ConfirmTurnOnBackupAndSyncModal() {
  const {
    props,
    hideModal
  } = (0, _useModalProps.useModalProps)();
  const {
    enableBackupAndSync
  } = props;
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const handleHideModal = () => {
    hideModal();
  };
  const enableBasicFunctionality = async () => {
    await Promise.all([dispatch((0, _app.onboardingToggleBasicFunctionalityOn)()), dispatch((0, _actions.toggleExternalServices)(true))]);
  };
  const handleEnableBackupAndSync = async () => {
    await enableBasicFunctionality();
    await enableBackupAndSync();
    hideModal();
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: true,
    onClose: handleHideModal,
    "data-testid": confirmTurnOnBackupAndSyncModalTestIds.modal
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, {
    modalDialogProps: {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    paddingBottom: 4,
    paddingRight: 4,
    paddingLeft: 4,
    onClose: handleHideModal
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingSm
  }, t('backupAndSyncEnable')))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginLeft: 4,
    marginRight: 4,
    marginBottom: 4,
    display: _designSystem.Display.Flex,
    gap: 4,
    flexDirection: _designSystem.FlexDirection.Column
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm
  }, t('backupAndSyncEnableConfirmation', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    key: "basic-functionality",
    variant: _designSystem.TextVariant.bodySmBold,
    as: "span"
  }, t('backupAndSyncBasicFunctionalityNameMention'))]))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalFooter, {
    containerProps: {
      flexDirection: _designSystem.FlexDirection.Row,
      alignItems: _designSystem.AlignItems.stretch
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    size: _componentLibrary.ButtonSize.Lg,
    width: _designSystem.BlockSize.Half,
    variant: _componentLibrary.ButtonVariant.Secondary,
    "data-testid": confirmTurnOnBackupAndSyncModalTestIds.cancelButton,
    onClick: handleHideModal
  }, t('cancel')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    size: _componentLibrary.ButtonSize.Lg,
    width: _designSystem.BlockSize.Half,
    variant: _componentLibrary.ButtonVariant.Primary,
    "data-testid": confirmTurnOnBackupAndSyncModalTestIds.toggleButton
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    ,
    onClick: handleEnableBackupAndSync
  }, t('turnOn'))))));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\identity\\confirm-turn-on-backup-and-sync-modal\\confirm-turn-on-backup-and-sync-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\identity\\confirm-turn-on-backup-and-sync-modal\\index.ts", {"./confirm-turn-on-backup-and-sync-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\identity\\confirm-turn-on-backup-and-sync-modal\\confirm-turn-on-backup-and-sync-modal.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cidentity%5Cconfirm-turn-on-backup-and-sync-modal%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _confirmTurnOnBackupAndSyncModal = require("./confirm-turn-on-backup-and-sync-modal");
Object.keys(_confirmTurnOnBackupAndSyncModal).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _confirmTurnOnBackupAndSyncModal[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _confirmTurnOnBackupAndSyncModal[key];
    }
  });
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\identity\\confirm-turn-on-backup-and-sync-modal\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\identity\\index.tsx", {"./confirm-turn-on-backup-and-sync-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\identity\\confirm-turn-on-backup-and-sync-modal\\index.ts","./turn-on-backup-and-sync-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\identity\\turn-on-backup-and-sync-modal\\index.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cidentity%5Cindex.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _confirmTurnOnBackupAndSyncModal = require("./confirm-turn-on-backup-and-sync-modal");
Object.keys(_confirmTurnOnBackupAndSyncModal).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _confirmTurnOnBackupAndSyncModal[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _confirmTurnOnBackupAndSyncModal[key];
    }
  });
});
var _turnOnBackupAndSyncModal = require("./turn-on-backup-and-sync-modal");
Object.keys(_turnOnBackupAndSyncModal).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _turnOnBackupAndSyncModal[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _turnOnBackupAndSyncModal[key];
    }
  });
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\identity\\index.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\identity\\turn-on-backup-and-sync-modal\\index.ts", {"./turn-on-backup-and-sync-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\identity\\turn-on-backup-and-sync-modal\\turn-on-backup-and-sync-modal.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cidentity%5Cturn-on-backup-and-sync-modal%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _turnOnBackupAndSyncModal = require("./turn-on-backup-and-sync-modal");
Object.keys(_turnOnBackupAndSyncModal).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _turnOnBackupAndSyncModal[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _turnOnBackupAndSyncModal[key];
    }
  });
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\identity\\turn-on-backup-and-sync-modal\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\identity\\turn-on-backup-and-sync-modal\\turn-on-backup-and-sync-modal.tsx", {"../../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../../../hooks/identity/useBackupAndSync":"D:\\code\\v\\metamask-extension\\ui\\hooks\\identity\\useBackupAndSync\\index.ts","../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../../hooks/useModalProps":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useModalProps.ts","../../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../../selectors/identity/backup-and-sync":"D:\\code\\v\\metamask-extension\\ui\\selectors\\identity\\backup-and-sync.ts","../../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../confirm-turn-on-backup-and-sync-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\identity\\confirm-turn-on-backup-and-sync-modal\\index.ts","@metamask/profile-sync-controller/user-storage":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\profile-sync-controller\\dist\\controllers\\user-storage\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cidentity%5Cturn-on-backup-and-sync-modal%5Cturn-on-backup-and-sync-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TURN_ON_BACKUP_AND_SYNC_MODAL_NAME = void 0;
exports.TurnOnBackupAndSyncModal = TurnOnBackupAndSyncModal;
exports.turnOnBackupAndSyncModalTestIds = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _userStorage = require("@metamask/profile-sync-controller/user-storage");
var _useModalProps = require("../../../../../hooks/useModalProps");
var _backupAndSync = require("../../../../../selectors/identity/backup-and-sync");
var _routes = require("../../../../../helpers/constants/routes");
var _componentLibrary = require("../../../../component-library");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _useBackupAndSync = require("../../../../../hooks/identity/useBackupAndSync");
var _useI18nContext = require("../../../../../hooks/useI18nContext");
var _selectors = require("../../../../../selectors");
var _actions = require("../../../../../store/actions");
var _confirmTurnOnBackupAndSyncModal = require("../confirm-turn-on-backup-and-sync-modal");
var _metametrics = require("../../../../../contexts/metametrics");
var _metametrics2 = require("../../../../../../shared/constants/metametrics");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TURN_ON_BACKUP_AND_SYNC_MODAL_NAME = exports.TURN_ON_BACKUP_AND_SYNC_MODAL_NAME = 'TURN_ON_BACKUP_AND_SYNC';
const turnOnBackupAndSyncModalTestIds = exports.turnOnBackupAndSyncModalTestIds = {
  modal: 'turn-on-backup-and-sync-modal',
  button: 'turn-on-backup-and-sync-button'
};

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function TurnOnBackupAndSyncModal() {
  const {
    hideModal
  } = (0, _useModalProps.useModalProps)();
  const history = (0, _reactRouterDom.useHistory)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const t = (0, _useI18nContext.useI18nContext)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const isBasicFunctionalityEnabled = (0, _reactRedux.useSelector)(_selectors.getUseExternalServices);
  const isBackupAndSyncEnabled = (0, _reactRedux.useSelector)(_backupAndSync.selectIsBackupAndSyncEnabled);
  const isBackupAndSyncUpdateLoading = (0, _reactRedux.useSelector)(_backupAndSync.selectIsBackupAndSyncUpdateLoading);
  const {
    setIsBackupAndSyncFeatureEnabled,
    error
  } = (0, _useBackupAndSync.useBackupAndSync)();
  const handleDismissModal = () => {
    trackEvent({
      event: _metametrics2.MetaMetricsEventName.ProfileActivityUpdated,
      category: _metametrics2.MetaMetricsEventCategory.BackupAndSync,
      properties: {
        // eslint-disable-next-line @typescript-eslint/naming-convention
        feature_name: 'Backup And Sync Carousel Modal',
        action: 'Modal Dismissed'
      }
    });
    hideModal();
  };
  const handleTurnOnBackupAndSync = async () => {
    trackEvent({
      event: _metametrics2.MetaMetricsEventName.ProfileActivityUpdated,
      category: _metametrics2.MetaMetricsEventCategory.BackupAndSync,
      properties: {
        // eslint-disable-next-line @typescript-eslint/naming-convention
        feature_name: 'Backup And Sync Carousel Modal',
        action: 'Turned On'
      }
    });
    if (!isBasicFunctionalityEnabled) {
      dispatch((0, _actions.showModal)({
        name: _confirmTurnOnBackupAndSyncModal.CONFIRM_TURN_ON_BACKUP_AND_SYNC_MODAL_NAME,
        enableBackupAndSync: async () => {
          history.push(_routes.BACKUPANDSYNC_ROUTE);
          await setIsBackupAndSyncFeatureEnabled(_userStorage.BACKUPANDSYNC_FEATURES.main, true);
        }
      }));
      return;
    }
    if (!isBackupAndSyncEnabled) {
      await setIsBackupAndSyncFeatureEnabled(_userStorage.BACKUPANDSYNC_FEATURES.main, true);
    }
    history.push(_routes.BACKUPANDSYNC_ROUTE);
    hideModal();
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: true,
    onClose: handleDismissModal,
    "data-testid": turnOnBackupAndSyncModalTestIds.modal
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onClose: handleDismissModal
  }, t('backupAndSyncEnable')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    as: "img",
    src: "./images/turn-on-backup-and-sync.png",
    width: _designSystem.BlockSize.Full,
    borderRadius: _designSystem.BorderRadius.MD,
    marginBottom: 4
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative,
    marginBottom: 4,
    as: "div"
  }, t('backupAndSyncEnableDescription', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "a",
    variant: _designSystem.TextVariant.bodySm,
    href: "https://support.metamask.io/privacy-and-security/profile-privacy",
    target: "_blank",
    rel: "noopener noreferrer",
    key: "privacy-link",
    color: _designSystem.TextColor.infoDefault
  }, t('backupAndSyncPrivacyLink'))])), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative,
    marginBottom: 4,
    as: "div"
  }, t('backupAndSyncEnableDescriptionUpdatePreferences', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "span",
    key: "backup-and-sync-enable-preferences",
    variant: _designSystem.TextVariant.bodySmBold
  }, t('backupAndSyncEnableDescriptionUpdatePreferencesPath'))]))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalFooter, {
    paddingTop: 4
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    ,
    onSubmit: () => handleTurnOnBackupAndSync(),
    containerProps: {
      flexDirection: _designSystem.FlexDirection.Column,
      alignItems: _designSystem.AlignItems.stretch
    },
    submitButtonProps: {
      children: t('backupAndSyncEnable'),
      loading: isBackupAndSyncUpdateLoading,
      disabled: isBackupAndSyncUpdateLoading,
      'data-testid': turnOnBackupAndSyncModalTestIds.button
    }
  }), error && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 4,
    paddingRight: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "p",
    color: _designSystem.TextColor.errorDefault,
    paddingTop: 4
  }, t('notificationsSettingsBoxError')))));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\identity\\turn-on-backup-and-sync-modal\\turn-on-backup-and-sync-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\index.js", {"./modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\modal.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "Modal", {
  enumerable: true,
  get: function () {
    return _modal.default;
  }
});
var _modal = _interopRequireDefault(require("./modal"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\keyring-snap-removal-modal\\index.ts", {"./keyring-snap-removal-result-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\keyring-snap-removal-modal\\keyring-snap-removal-result-modal.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Ckeyring-snap-removal-modal%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _keyringSnapRemovalResultModal.default;
  }
});
var _keyringSnapRemovalResultModal = _interopRequireDefault(require("./keyring-snap-removal-result-modal"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\keyring-snap-removal-modal\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\keyring-snap-removal-modal\\keyring-snap-removal-result-modal.tsx", {"../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../component-library/modal-content/deprecated":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\modal-content\\deprecated\\index.ts","../../../component-library/modal-header/deprecated":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\modal-header\\deprecated\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Ckeyring-snap-removal-modal%5Ckeyring-snap-removal-result-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _designSystem = require("../../../../helpers/constants/design-system");
var _componentLibrary = require("../../../component-library");
var _deprecated = require("../../../component-library/modal-content/deprecated");
var _deprecated2 = require("../../../component-library/modal-header/deprecated");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _selectors = require("../../../../selectors");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const KeyringSnapRemovalResult = ({
  isOpen,
  onClose
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const snapRemovalResult = (0, _reactRedux.useSelector)(_selectors.getKeyringSnapRemovalResult);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: isOpen,
    onClose: () => onClose()
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_deprecated.ModalContent, {
    modalDialogProps: {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      gap: 4
    }
  }, /*#__PURE__*/_react.default.createElement(_deprecated2.ModalHeader, {
    onClose: onClose
  }, ''), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: snapRemovalResult.result === 'success' ? _componentLibrary.IconName.Confirmation : _componentLibrary.IconName.Danger,
    color: snapRemovalResult.result === 'success' ? _designSystem.IconColor.successDefault : _designSystem.IconColor.errorDefault,
    size: _componentLibrary.IconSize.Xl,
    marginBottom: 4
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdBold,
    textAlign: _designSystem.TextAlign.Center
  }, t('keyringSnapRemovalResult1', [snapRemovalResult.snapName, snapRemovalResult.result === 'failed' ? t('keyringSnapRemovalResultNotSuccessful') : '']))))));
};
var _default = exports.default = KeyringSnapRemovalResult;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\keyring-snap-removal-modal\\keyring-snap-removal-result-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\modal.js", {"../../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../helpers/utils/is-mobile-view":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\is-mobile-view.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../multichain/network-manager":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-manager\\index.ts","./confirm-delete-network":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\confirm-delete-network\\index.js","./confirm-remove-account":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\confirm-remove-account\\index.js","./confirm-reset-account":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\confirm-reset-account\\index.js","./convert-token-to-nft-modal/convert-token-to-nft-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\convert-token-to-nft-modal\\convert-token-to-nft-modal.js","./customize-nonce":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\customize-nonce\\index.js","./edit-approval-permission":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\edit-approval-permission\\index.js","./fade-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\fade-modal.js","./hide-token-confirmation-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\hide-token-confirmation-modal\\index.js","./identity":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\identity\\index.tsx","./new-account-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\new-account-modal\\index.js","./qr-scanner":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\qr-scanner\\index.js","./reject-transactions":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\reject-transactions\\index.js","./transaction-already-confirmed":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\transaction-already-confirmed\\index.ts","./transaction-confirmed":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\transaction-confirmed\\index.js","./turn-on-metamask-notifications/turn-on-metamask-notifications":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\turn-on-metamask-notifications\\turn-on-metamask-notifications.tsx","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cmodal.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _util = require("../../../../app/scripts/lib/util");
var _app = require("../../../../shared/constants/app");
var _isMobileView = _interopRequireDefault(require("../../../helpers/utils/is-mobile-view"));
var actions = _interopRequireWildcard(require("../../../store/actions"));
var _networkManager = require("../../multichain/network-manager");
var _identity = require("./identity");
var _hideTokenConfirmationModal = _interopRequireDefault(require("./hide-token-confirmation-modal"));
var _qrScanner = _interopRequireDefault(require("./qr-scanner"));
var _confirmRemoveAccount = _interopRequireDefault(require("./confirm-remove-account"));
var _confirmResetAccount = _interopRequireDefault(require("./confirm-reset-account"));
var _transactionConfirmed = _interopRequireDefault(require("./transaction-confirmed"));
var _confirmDeleteNetwork = _interopRequireDefault(require("./confirm-delete-network"));
var _convertTokenToNftModal = _interopRequireDefault(require("./convert-token-to-nft-modal/convert-token-to-nft-modal"));
var _customizeNonce = _interopRequireDefault(require("./customize-nonce"));
var _editApprovalPermission = _interopRequireDefault(require("./edit-approval-permission"));
var _fadeModal = _interopRequireDefault(require("./fade-modal"));
var _newAccountModal = _interopRequireDefault(require("./new-account-modal"));
var _rejectTransactions = _interopRequireDefault(require("./reject-transactions"));
var _transactionAlreadyConfirmed = _interopRequireDefault(require("./transaction-already-confirmed"));
var _turnOnMetamaskNotifications = _interopRequireDefault(require("./turn-on-metamask-notifications/turn-on-metamask-notifications"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } // TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths
// Metamask Notifications
const modalContainerBaseStyle = {
  transform: 'translate3d(-50%, 0, 0px)',
  border: '1px solid var(--color-border-default)',
  borderRadius: '8px',
  backgroundColor: 'var(--color-background-default)',
  boxShadow: 'var(--shadow-size-sm) var(--color-shadow-default)'
};
const modalContainerLaptopStyle = {
  ...modalContainerBaseStyle,
  width: '344px',
  top: '15%'
};
const modalContainerMobileStyle = {
  ...modalContainerBaseStyle,
  width: '309px',
  top: '12.5%'
};
const MODALS = {
  NEW_ACCOUNT: {
    contents: /*#__PURE__*/_react.default.createElement(_newAccountModal.default, null),
    mobileModalStyle: {
      width: '95%',
      top: '10%',
      boxShadow: 'var(--shadow-size-xs) var(--color-shadow-default)',
      transform: 'none',
      left: '0',
      right: '0',
      margin: '0 auto',
      borderRadius: '10px'
    },
    laptopModalStyle: {
      width: '375px',
      top: '10%',
      boxShadow: 'var(--shadow-size-xs) var(--color-shadow-default)',
      transform: 'none',
      left: '0',
      right: '0',
      margin: '0 auto',
      borderRadius: '10px'
    },
    contentStyle: {
      borderRadius: '10px'
    }
  },
  HIDE_TOKEN_CONFIRMATION: {
    contents: /*#__PURE__*/_react.default.createElement(_hideTokenConfirmationModal.default, null),
    testId: 'hide-token-confirmation-modal',
    mobileModalStyle: {
      width: '95%',
      top: (0, _util.getEnvironmentType)() === _app.ENVIRONMENT_TYPE_POPUP ? '52vh' : '36.5vh'
    },
    laptopModalStyle: {
      width: (0, _util.getEnvironmentType)() === _app.ENVIRONMENT_TYPE_POPUP ? '400px' : '449px',
      top: 'calc(33% + 45px)',
      paddingLeft: (0, _util.getEnvironmentType)() === _app.ENVIRONMENT_TYPE_POPUP ? '16px' : null,
      paddingRight: (0, _util.getEnvironmentType)() === _app.ENVIRONMENT_TYPE_POPUP ? '16px' : null
    }
  },
  CONFIRM_RESET_ACCOUNT: {
    contents: /*#__PURE__*/_react.default.createElement(_confirmResetAccount.default, null),
    mobileModalStyle: {
      ...modalContainerMobileStyle
    },
    laptopModalStyle: {
      ...modalContainerLaptopStyle
    },
    contentStyle: {
      borderRadius: '8px'
    }
  },
  CONFIRM_REMOVE_ACCOUNT: {
    contents: /*#__PURE__*/_react.default.createElement(_confirmRemoveAccount.default, null),
    mobileModalStyle: {
      ...modalContainerMobileStyle
    },
    laptopModalStyle: {
      ...modalContainerLaptopStyle
    },
    contentStyle: {
      borderRadius: '8px'
    }
  },
  CONVERT_TOKEN_TO_NFT: {
    contents: /*#__PURE__*/_react.default.createElement(_convertTokenToNftModal.default, null),
    mobileModalStyle: {
      ...modalContainerMobileStyle
    },
    laptopModalStyle: {
      ...modalContainerLaptopStyle
    },
    contentStyle: {
      borderRadius: '8px'
    }
  },
  CONFIRM_DELETE_NETWORK: {
    contents: /*#__PURE__*/_react.default.createElement(_confirmDeleteNetwork.default, null),
    mobileModalStyle: {
      ...modalContainerMobileStyle
    },
    laptopModalStyle: {
      ...modalContainerLaptopStyle
    },
    contentStyle: {
      borderRadius: '8px'
    }
  },
  EDIT_APPROVAL_PERMISSION: {
    contents: /*#__PURE__*/_react.default.createElement(_editApprovalPermission.default, null),
    mobileModalStyle: {
      width: '95vw',
      height: '100vh',
      top: '50px',
      transform: 'none',
      left: '0',
      right: '0',
      margin: '0 auto'
    },
    laptopModalStyle: {
      width: 'auto',
      height: '0px',
      top: '80px',
      left: '0px',
      transform: 'none',
      margin: '0 auto',
      position: 'relative'
    },
    contentStyle: {
      borderRadius: '8px'
    }
  },
  TRANSACTION_CONFIRMED: {
    disableBackdropClick: true,
    contents: /*#__PURE__*/_react.default.createElement(_transactionConfirmed.default, null),
    mobileModalStyle: {
      ...modalContainerMobileStyle
    },
    laptopModalStyle: {
      ...modalContainerLaptopStyle
    },
    contentStyle: {
      borderRadius: '8px'
    }
  },
  TRANSACTION_ALREADY_CONFIRMED: {
    disableBackdropClick: true,
    contents: /*#__PURE__*/_react.default.createElement(_transactionAlreadyConfirmed.default, null),
    mobileModalStyle: {
      ...modalContainerMobileStyle
    },
    laptopModalStyle: {
      ...modalContainerLaptopStyle
    }
  },
  QR_SCANNER: {
    contents: /*#__PURE__*/_react.default.createElement(_qrScanner.default, null),
    testId: 'qr-scanner-modal',
    mobileModalStyle: {
      ...modalContainerMobileStyle
    },
    laptopModalStyle: {
      ...modalContainerLaptopStyle
    },
    contentStyle: {
      borderRadius: '8px'
    }
  },
  REJECT_TRANSACTIONS: {
    contents: /*#__PURE__*/_react.default.createElement(_rejectTransactions.default, null),
    mobileModalStyle: {
      ...modalContainerMobileStyle
    },
    laptopModalStyle: {
      ...modalContainerLaptopStyle
    },
    contentStyle: {
      borderRadius: '8px'
    }
  },
  CUSTOMIZE_NONCE: {
    contents: /*#__PURE__*/_react.default.createElement(_customizeNonce.default, null),
    mobileModalStyle: {
      ...modalContainerMobileStyle
    },
    laptopModalStyle: {
      ...modalContainerLaptopStyle
    },
    contentStyle: {
      borderRadius: '8px'
    }
  },
  [_identity.CONFIRM_TURN_ON_BACKUP_AND_SYNC_MODAL_NAME]: {
    contents: /*#__PURE__*/_react.default.createElement(_identity.ConfirmTurnOnBackupAndSyncModal, null),
    mobileModalStyle: {
      ...modalContainerMobileStyle
    },
    laptopModalStyle: {
      ...modalContainerLaptopStyle
    },
    contentStyle: {
      borderRadius: '8px'
    }
  },
  [_identity.TURN_ON_BACKUP_AND_SYNC_MODAL_NAME]: {
    contents: /*#__PURE__*/_react.default.createElement(_identity.TurnOnBackupAndSyncModal, null),
    mobileModalStyle: {
      ...modalContainerMobileStyle
    },
    laptopModalStyle: {
      ...modalContainerLaptopStyle
    },
    contentStyle: {
      borderRadius: '8px'
    }
  },
  TURN_ON_METAMASK_NOTIFICATIONS: {
    contents: /*#__PURE__*/_react.default.createElement(_turnOnMetamaskNotifications.default, null),
    mobileModalStyle: {
      ...modalContainerMobileStyle
    },
    laptopModalStyle: {
      ...modalContainerLaptopStyle
    },
    contentStyle: {
      borderRadius: '8px'
    }
  },
  NETWORK_MANAGER: {
    contents: /*#__PURE__*/_react.default.createElement(_networkManager.NetworkManager, null),
    mobileModalStyle: {
      ...modalContainerMobileStyle
    },
    laptopModalStyle: {
      ...modalContainerLaptopStyle
    }
  },
  DEFAULT: {
    contents: [],
    mobileModalStyle: {},
    laptopModalStyle: {}
  }
};
const BACKDROPSTYLE = {
  backgroundColor: 'var(--color-overlay-default)'
};
function mapStateToProps(state) {
  return {
    active: state.appState.modal.open,
    modalState: state.appState.modal.modalState
  };
}
function mapDispatchToProps(dispatch) {
  return {
    hideModal: customOnHideOpts => {
      dispatch(actions.hideModal());
      if (customOnHideOpts && customOnHideOpts.action) {
        dispatch(customOnHideOpts.action(...customOnHideOpts.args));
      }
    },
    hideWarning: () => {
      dispatch(actions.hideWarning());
    }
  };
}

/**
 * @deprecated The `<Modal />` and the dispatch method of displaying modals has been deprecated in favor of local state and the `<Modal>` component from the component-library.
 * Please update your code to use the new `<Modal>` component instead, which can be found at ui/components/component-library/modal/modal.tsx.
 * You can find documentation for the new Modal component in the MetaMask Storybook:
 * {@link https://metamask.github.io/metamask-storybook/?path=/docs/components-componentlibrary-modal--docs}
 * If you would like to help with the replacement of the old Modal component, please submit a pull request
 */
class Modal extends _react.Component {
  hide() {
    this.modalRef.hide();
  }
  show() {
    this.modalRef.show();
  }
  UNSAFE_componentWillReceiveProps(nextProps, _) {
    if (nextProps.active) {
      this.show();
    } else if (this.props.active) {
      this.hide();
    }
  }
  render() {
    const modal = MODALS[this.props.modalState.name || 'DEFAULT'];
    const {
      contents: children,
      disableBackdropClick = false,
      testId
    } = modal;
    const modalStyle = modal[(0, _isMobileView.default)() ? 'mobileModalStyle' : 'laptopModalStyle'];
    const contentStyle = modal.contentStyle || {};
    return /*#__PURE__*/_react.default.createElement(_fadeModal.default, {
      keyboard: false,
      onHide: () => {
        if (modal.onHide) {
          modal.onHide({
            hideWarning: this.props.hideWarning
          });
        }
        this.props.hideModal(modal.customOnHideOpts);
      },
      ref: ref => {
        this.modalRef = ref;
      },
      modalStyle: modalStyle,
      contentStyle: contentStyle,
      backdropStyle: BACKDROPSTYLE,
      closeOnClick: !disableBackdropClick,
      testId: testId
    }, children);
  }
}
_defineProperty(Modal, "propTypes", {
  active: _propTypes.default.bool.isRequired,
  hideModal: _propTypes.default.func.isRequired,
  hideWarning: _propTypes.default.func.isRequired,
  modalState: _propTypes.default.object.isRequired
});
var _default = exports.default = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(Modal);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\modal.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\multichain-accounts\\intro-modal\\index.ts", {"./multichain-account-intro-modal.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\multichain-accounts\\intro-modal\\multichain-account-intro-modal.component.tsx","./multichain-account-intro-modal.container":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\multichain-accounts\\intro-modal\\multichain-account-intro-modal.container.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cmultichain-accounts%5Cintro-modal%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "MultichainAccountIntroModal", {
  enumerable: true,
  get: function () {
    return _multichainAccountIntroModal2.MultichainAccountIntroModal;
  }
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _multichainAccountIntroModal.MultichainAccountIntroModalContainer;
  }
});
var _multichainAccountIntroModal = require("./multichain-account-intro-modal.container");
var _multichainAccountIntroModal2 = require("./multichain-account-intro-modal.component");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\multichain-accounts\\intro-modal\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\multichain-accounts\\intro-modal\\multichain-account-intro-modal.component.tsx", {"../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../component-library/lottie-animation":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\lottie-animation\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cmultichain-accounts%5Cintro-modal%5Cmultichain-account-intro-modal.component.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultichainAccountIntroModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _designSystem = require("../../../../../helpers/constants/design-system");
var _componentLibrary = require("../../../../component-library");
var _useI18nContext = require("../../../../../hooks/useI18nContext");
var _lottieAnimation = require("../../../../component-library/lottie-animation");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const MemoizedLottieAnimation = /*#__PURE__*/_react.default.memo(_lottieAnimation.LottieAnimation);
const MultichainAccountIntroModal = exports.MultichainAccountIntroModal = /*#__PURE__*/_react.default.memo(({
  isOpen,
  onViewAccounts,
  onLearnMore,
  onClose,
  isLoading = false
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: isOpen,
    onClose: onClose,
    isClosedOnOutsideClick: true,
    isClosedOnEscapeKey: true
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onClose: onClose
  }, t('multichainAccountsIntroductionModalTitle')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    marginBottom: 4
  }, /*#__PURE__*/_react.default.createElement(MemoizedLottieAnimation, {
    path: "images/animations/multichain-accounts/MM_MultichainAccounts_Polycon-and-network_Lottie.json",
    loop: true,
    autoplay: true,
    className: "multichain-accounts-intro-modal__lottie-animation"
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.flexStart,
    width: _designSystem.BlockSize.Full,
    gap: 3
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingMd,
    marginBottom: 2
  }, t('multichainAccountIntroWhatTitle')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    color: _designSystem.TextColor.textAlternative
  }, t('multichainAccountIntroWhatDescription'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingMd,
    marginBottom: 2
  }, t('multichainAccountIntroSameAddressTitle')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    color: _designSystem.TextColor.textAlternative
  }, t('multichainAccountIntroSameAddressDescription'))))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalFooter, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    variant: _componentLibrary.ButtonVariant.Primary,
    size: _componentLibrary.ButtonSize.Lg,
    block: true,
    onClick: onViewAccounts,
    loading: isLoading,
    disabled: isLoading
  }, isLoading ? t('multichainAccountIntroSettingUp') : t('multichainAccountIntroViewAccounts')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    variant: _componentLibrary.ButtonVariant.Link,
    size: _componentLibrary.ButtonSize.Lg,
    block: true,
    onClick: onLearnMore,
    disabled: isLoading
  }, t('multichainAccountIntroLearnMore'))))));
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\multichain-accounts\\intro-modal\\multichain-account-intro-modal.component.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\multichain-accounts\\intro-modal\\multichain-account-intro-modal.container.tsx", {"../../../../../../shared/lib/sentry":"D:\\code\\v\\metamask-extension\\shared\\lib\\sentry.ts","../../../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./multichain-account-intro-modal.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\multichain-accounts\\intro-modal\\multichain-account-intro-modal.component.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cmultichain-accounts%5Cintro-modal%5Cmultichain-account-intro-modal.container.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultichainAccountIntroModalContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _sentry = require("../../../../../../shared/lib/sentry");
var _actions = require("../../../../../store/actions");
var _routes = require("../../../../../helpers/constants/routes");
var _multichainAccountIntroModal = require("./multichain-account-intro-modal.component");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MultichainAccountIntroModalContainer = ({
  onClose
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const history = (0, _reactRouterDom.useHistory)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const isClosingRef = (0, _react.useRef)(false);
  const MINIMUM_LOADING_TIME_MS = 2000;
  const SUPPORT_URL = 'https://support.metamask.io/configure/accounts/multichain-accounts/';

  // Create alignment promise - always defined, no conditionals needed
  const alignmentPromise = (0, _react.useMemo)(() => (0, _actions.alignMultichainWallets)().catch(err => {
    console.error('Wallet alignment failed:', err);
    (0, _sentry.captureException)(err);
    // Even if alignment fails, we continue
    return Promise.resolve();
  }), []);
  const handleViewAccounts = (0, _react.useCallback)(async () => {
    // Start loading when user clicks
    setIsLoading(true);
    try {
      // Wait for alignment + minimum 2s UX delay
      await Promise.all([alignmentPromise, new Promise(resolve => setTimeout(resolve, MINIMUM_LOADING_TIME_MS))]);
    } catch (err) {
      // Error already captured when alignment promise was created
      // Don't capture again to avoid duplicate Sentry reports
    } finally {
      setIsLoading(false); // Clear loading state before closing modal
    }

    // Prevent race condition if modal was closed while aligning
    if (isClosingRef.current) {
      return;
    }
    isClosingRef.current = true;

    // Mark modal as shown so it doesn't show again
    dispatch((0, _actions.setMultichainAccountsIntroModalShown)(true));
    onClose();

    // Navigate to account list
    history.push(_routes.ACCOUNT_LIST_PAGE_ROUTE);
  }, [alignmentPromise, dispatch, history, onClose]);
  const handleLearnMore = (0, _react.useCallback)(() => {
    // Open multichain accounts support page
    window.open(SUPPORT_URL, '_blank', 'noopener,noreferrer');
  }, []);
  const handleClose = (0, _react.useCallback)(async () => {
    // Prevent race condition if alignment is handling the close
    if (isClosingRef.current) {
      return;
    }
    isClosingRef.current = true;

    // Wait for alignment to complete
    try {
      await alignmentPromise;
    } catch (err) {
      // Silently handle alignment errors during close
      console.error('Alignment failed during modal close:', err);
    }

    // Mark modal as shown so it doesn't show again
    dispatch((0, _actions.setMultichainAccountsIntroModalShown)(true));
    onClose();
  }, [dispatch, onClose, alignmentPromise]);

  // Clean up if component unmounts while loading
  (0, _react.useEffect)(() => {
    return () => {
      // Let the alignment promise continue but don't wait for it
      alignmentPromise.catch(() => {
        // Silently handle cleanup errors
      });
    };
  }, [alignmentPromise]);
  const props = {
    isOpen: true,
    // Always open when component is rendered
    onViewAccounts: handleViewAccounts,
    onLearnMore: handleLearnMore,
    onClose: handleClose,
    isLoading
  };
  return /*#__PURE__*/_react.default.createElement(_multichainAccountIntroModal.MultichainAccountIntroModal, props);
};
exports.MultichainAccountIntroModalContainer = MultichainAccountIntroModalContainer;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\multichain-accounts\\intro-modal\\multichain-account-intro-modal.container.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\new-account-modal\\index.js", {"./new-account-modal.container":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\new-account-modal\\new-account-modal.container.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cnew-account-modal%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _newAccountModal.default;
  }
});
var _newAccountModal = _interopRequireDefault(require("./new-account-modal.container"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\new-account-modal\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\new-account-modal\\new-account-modal.component.js", {"../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cnew-account-modal%5Cnew-account-modal.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _componentLibrary = require("../../../component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class NewAccountModal extends _react.Component {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "state", {
      alias: this.context.t('newAccountNumberName', [this.props.newAccountNumber])
    });
    _defineProperty(this, "onChange", e => {
      this.setState({
        alias: e.target.value
      });
    });
    _defineProperty(this, "onSubmit", async () => {
      await this.props.onSave(this.state.alias).then(this.props.hideModal);
    });
    _defineProperty(this, "onKeyPress", e => {
      if (e.key === 'Enter' && this.state.alias) {
        this.onSubmit();
      }
    });
  }
  render() {
    const {
      t
    } = this.context;
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "new-account-modal"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "new-account-modal__content"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "new-account-modal__content__header"
    }, t('newAccount'), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      className: "new-account-modal__content__header-close",
      ariaLabel: t('close'),
      onClick: this.props.hideModal,
      iconName: _componentLibrary.IconName.Close
    })), /*#__PURE__*/_react.default.createElement("div", {
      className: "new-account-modal__input-label"
    }, t('accountName')), /*#__PURE__*/_react.default.createElement("input", {
      type: "text",
      className: "new-account-modal__input",
      onChange: this.onChange,
      onKeyPress: this.onKeyPress,
      value: this.state.alias,
      autoFocus: true
    })), /*#__PURE__*/_react.default.createElement("div", {
      className: "new-account-modal__footer"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
      variant: _componentLibrary.ButtonVariant.Secondary,
      block: true,
      onClick: this.props.hideModal
    }, t('cancel')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
      variant: _componentLibrary.ButtonVariant.Primary,
      block: true,
      onClick: this.onSubmit,
      disabled: !this.state.alias
    }, t('save'))));
  }
}
exports.default = NewAccountModal;
_defineProperty(NewAccountModal, "contextTypes", {
  t: _propTypes.default.func
});
_defineProperty(NewAccountModal, "propTypes", {
  hideModal: _propTypes.default.func.isRequired,
  newAccountNumber: _propTypes.default.number.isRequired,
  onSave: _propTypes.default.func.isRequired
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\new-account-modal\\new-account-modal.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\new-account-modal\\new-account-modal.container.js", {"../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./new-account-modal.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\new-account-modal\\new-account-modal.component.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cnew-account-modal%5Cnew-account-modal.container.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactRedux = require("react-redux");
var _actions = require("../../../../store/actions");
var _newAccountModal = _interopRequireDefault(require("./new-account-modal.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function mapStateToProps(state) {
  return {
    ...(state.appState.modal.modalState.props || {})
  };
}
function mapDispatchToProps(dispatch) {
  return {
    hideModal: () => dispatch((0, _actions.hideModal)()),
    createAccount: async newAccountName => {
      const {
        address: newAccountAddress
      } = await dispatch((0, _actions.addNewAccount)());
      if (newAccountName) {
        dispatch((0, _actions.setAccountLabel)(newAccountAddress, newAccountName));
      }
      await (0, _actions.forceUpdateMetamaskState)(dispatch);
      return newAccountAddress;
    }
  };
}
function mergeProps(stateProps, dispatchProps) {
  const {
    onCreateNewAccount
  } = stateProps;
  const {
    createAccount
  } = dispatchProps;
  return {
    ...stateProps,
    ...dispatchProps,
    onSave: newAccountName => {
      return createAccount(newAccountName).then(newAccountAddress => {
        onCreateNewAccount(newAccountAddress);
      });
    }
  };
}
var _default = exports.default = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps, mergeProps)(_newAccountModal.default);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\new-account-modal\\new-account-modal.container.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\nickname-popovers\\index.js", {"./nickname-popovers.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\nickname-popovers\\nickname-popovers.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cnickname-popovers%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _nicknamePopovers.default;
  }
});
var _nicknamePopovers = _interopRequireDefault(require("./nickname-popovers.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\nickname-popovers\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\nickname-popovers\\nickname-popovers.component.js", {"../../../../helpers/utils/multichain/blockExplorer":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\multichain\\blockExplorer.ts","../../../../hooks/useMultichainSelector":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainSelector.ts","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../../ui/nickname-popover":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\nickname-popover\\index.js","../../../ui/update-nickname-popover/update-nickname-popover":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\update-nickname-popover\\update-nickname-popover.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cnickname-popovers%5Cnickname-popovers.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _blockExplorer = require("../../../../helpers/utils/multichain/blockExplorer");
var _actions = require("../../../../store/actions");
var _selectors = require("../../../../selectors");
var _nicknamePopover = _interopRequireDefault(require("../../../ui/nickname-popover"));
var _updateNicknamePopover = _interopRequireDefault(require("../../../ui/update-nickname-popover/update-nickname-popover"));
var _multichain = require("../../../../selectors/multichain");
var _useMultichainSelector = require("../../../../hooks/useMultichainSelector");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SHOW_NICKNAME_POPOVER = 'SHOW_NICKNAME_POPOVER';
const ADD_NICKNAME_POPOVER = 'ADD_NICKNAME_POPOVER';
const NicknamePopovers = ({
  address,
  onClose
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const [popoverToDisplay, setPopoverToDisplay] = (0, _react.useState)(SHOW_NICKNAME_POPOVER);
  const addressBook = (0, _reactRedux.useSelector)(_selectors.getAddressBook);
  const addressBookEntryObject = addressBook.find(entry => entry.address === address);
  const recipientNickname = addressBookEntryObject === null || addressBookEntryObject === void 0 ? void 0 : addressBookEntryObject.name;

  // This may be undefined because the address may be a contract address
  const account = (0, _reactRedux.useSelector)(state => (0, _selectors.getInternalAccountByAddress)(state, address));
  const multichainNetwork = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainNetwork, account);
  const explorerLink = (0, _blockExplorer.getMultichainAccountUrl)(address, multichainNetwork);
  if (popoverToDisplay === ADD_NICKNAME_POPOVER) {
    return /*#__PURE__*/_react.default.createElement(_updateNicknamePopover.default, {
      address: address,
      nickname: recipientNickname || null,
      memo: (addressBookEntryObject === null || addressBookEntryObject === void 0 ? void 0 : addressBookEntryObject.memo) || null,
      onClose: () => setPopoverToDisplay(SHOW_NICKNAME_POPOVER),
      onAdd: (recipient, nickname, memo) => dispatch((0, _actions.addToAddressBook)(recipient, nickname, memo))
    });
  }

  // SHOW_NICKNAME_POPOVER case
  return /*#__PURE__*/_react.default.createElement(_nicknamePopover.default, {
    address: address,
    nickname: recipientNickname || null,
    onClose: onClose,
    onAdd: () => setPopoverToDisplay(ADD_NICKNAME_POPOVER),
    explorerLink: explorerLink
  });
};
NicknamePopovers.propTypes = {
  address: _propTypes.default.string,
  onClose: _propTypes.default.func
};
var _default = exports.default = NicknamePopovers;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\nickname-popovers\\nickname-popovers.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\qr-scanner\\index.js", {"./qr-scanner.container":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\qr-scanner\\qr-scanner.container.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cqr-scanner%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _qrScanner = _interopRequireDefault(require("./qr-scanner.container"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
var _default = exports.default = _qrScanner.default;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\qr-scanner\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\qr-scanner\\qr-scanner.component.js", {"../../../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../../../shared/constants/time":"D:\\code\\v\\metamask-extension\\shared\\constants\\time.ts","../../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../../helpers/utils/webcam-utils":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\webcam-utils.js","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../hooks/usePrevious":"D:\\code\\v\\metamask-extension\\ui\\hooks\\usePrevious.ts","../../../ui/page-container/page-container-footer/page-container-footer.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\page-container\\page-container-footer\\page-container-footer.component.js","../../../ui/spinner":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\spinner\\index.js","./scan-util":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\qr-scanner\\scan-util.ts","@zxing/browser":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\browser\\cjs\\index.js","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cqr-scanner%5Cqr-scanner.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = QRCodeScanner;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _loglevel = _interopRequireDefault(require("loglevel"));
var _browser = require("@zxing/browser");
var _usePrevious = require("../../../../hooks/usePrevious");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _util = require("../../../../../app/scripts/lib/util");
var _util2 = require("../../../../helpers/utils/util");
var _webcamUtils = _interopRequireDefault(require("../../../../helpers/utils/webcam-utils"));
var _pageContainerFooter = _interopRequireDefault(require("../../../ui/page-container/page-container-footer/page-container-footer.component"));
var _spinner = _interopRequireDefault(require("../../../ui/spinner"));
var _app = require("../../../../../shared/constants/app");
var _time = require("../../../../../shared/constants/time");
var _scanUtil = require("./scan-util");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

const READY_STATE = {
  ACCESSING_CAMERA: 'ACCESSING_CAMERA',
  NEED_TO_ALLOW_ACCESS: 'NEED_TO_ALLOW_ACCESS',
  READY: 'READY'
};
const ethereumPrefix = 'ethereum:';
// A 0x-prefixed Ethereum address is 42 characters (2 prefix + 40 address)
const addressLength = 42;
const parseContent = content => {
  let type = 'unknown';
  let values = {};

  // Here we could add more cases
  // To parse other type of links
  // For ex. EIP-681 (https://eips.ethereum.org/EIPS/eip-681)

  // Ethereum address links - fox ex. ethereum:0x.....1111
  if (content.split(ethereumPrefix).length > 1 && content.length === ethereumPrefix.length + addressLength) {
    type = 'address';
    // uses regex capture groups to match and extract address
    values = {
      address: (0, _scanUtil.parseScanContent)(content)
    };
    // Regular ethereum addresses - fox ex. 0x.....1111
  } else if (content.substring(0, 2).toLowerCase() === '0x' && content.length === addressLength) {
    type = 'address';
    values = {
      address: content
    };
  }
  return {
    type,
    values
  };
};
function QRCodeScanner({
  hideModal,
  qrCodeDetected
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  const [isReady, setIsReady] = (0, _react.useState)(READY_STATE.ACCESSING_CAMERA);
  const previousIsReady = (0, _usePrevious.usePrevious)(isReady);
  const [errorData, setErrorData] = (0, _react.useState)(null);
  const [isMounted, setIsMounted] = (0, _react.useState)(false);
  const [codeReader, setCodeReader] = (0, _react.useState)(null);
  const [permissionChecker, setPermissionChecker] = (0, _react.useState)(null);
  const checkPermissions = (0, _react.useCallback)(async () => {
    try {
      const {
        permissions
      } = await _webcamUtils.default.checkStatus();
      if (permissions) {
        // Let the video stream load first...
        await new Promise(resolve => setTimeout(resolve, _time.SECOND * 2));
        if (!isMounted) {
          return;
        }
        setIsReady(READY_STATE.READY);
      } else if (isMounted) {
        // Keep checking for permissions
        setPermissionChecker(setTimeout(this.checkPermissions, _time.SECOND));
      }
    } catch (error) {
      if (isMounted) {
        setErrorData({
          error
        });
      }
    }
  }, [isMounted]);
  const teardownCodeReader = (0, _react.useCallback)(() => {
    if (codeReader) {
      codeReader.constructor.cleanVideoSource();
      codeReader.constructor.releaseAllStreams();
      setCodeReader(null);
    }
  }, [codeReader]);
  const stopAndClose = (0, _react.useCallback)(() => {
    if (codeReader) {
      teardownCodeReader(hideModal);
    }
    hideModal();
  }, [codeReader, hideModal, teardownCodeReader]);
  const initCamera = (0, _react.useCallback)(async () => {
    // The `decodeFromInputVideoDevice` call prompts the browser to show
    // the user the camera permission request.  We must then call it again
    // once we receive permission so that the video displays.
    // It's important to prevent this codeReader from being created twice;
    // Firefox otherwise starts 2 video streams, one of which cannot be stopped
    if (!codeReader) {
      setCodeReader(new _browser.BrowserQRCodeReader());
    }
  }, [codeReader]);
  (0, _react.useEffect)(() => {
    (async () => {
      if (codeReader) {
        try {
          await checkPermissions();
          await codeReader.constructor.listVideoInputDevices();
          const content = await codeReader.decodeOnceFromVideoDevice(undefined, 'video');
          const result = parseContent(content.text);
          if (isMounted) {
            if (result.type === 'unknown') {
              setErrorData(new Error(t('unknownQrCode')));
            } else {
              qrCodeDetected(result);
              stopAndClose();
            }
          }
        } catch (error) {
          if (isMounted) {
            return;
          }
          if (error.name === 'NotAllowedError') {
            _loglevel.default.info(`Permission denied: '${error}'`);
            setIsReady(READY_STATE.NEED_TO_ALLOW_ACCESS);
          } else {
            setErrorData(error);
          }
        }
      }
    })();
  }, [checkPermissions, codeReader, isMounted, qrCodeDetected, stopAndClose, t]);
  const checkEnvironment = async () => {
    try {
      const {
        environmentReady
      } = await _webcamUtils.default.checkStatus();
      if (!environmentReady && (0, _util.getEnvironmentType)() !== _app.ENVIRONMENT_TYPE_FULLSCREEN) {
        const currentUrl = (0, _util2.getURL)(window.location.href);
        const currentHash = currentUrl === null || currentUrl === void 0 ? void 0 : currentUrl.hash;
        const currentRoute = currentHash ? currentHash.substring(1) : null;
        global.platform.openExtensionInBrowser(currentRoute);
      }
    } catch (error) {
      if (isMounted) {
        setErrorData({
          error
        });
      }
    }
    // initial attempt is required to trigger permission prompt
    await initCamera();
  };
  (0, _react.useEffect)(() => {
    // Anything in here is fired on component mount.
    setIsMounted(true);
    (async () => {
      await checkEnvironment();
    })();
    // only renders when component is mounted and unmounted
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(() => {
    (async () => {
      if (previousIsReady !== isReady) {
        if (isReady === READY_STATE.READY) {
          await initCamera();
        } else if (isReady === READY_STATE.NEED_TO_ALLOW_ACCESS) {
          await checkPermissions();
        }
      }
    })();
  }, [previousIsReady, isReady, initCamera, checkPermissions]);
  const tryAgain = async () => {
    clearTimeout(permissionChecker);
    if (codeReader) {
      teardownCodeReader();
    }
    setIsReady(READY_STATE.ACCESSING_CAMERA);
    setErrorData(null);
    await checkEnvironment();
  };
  const renderError = () => {
    let title, msg;
    if (errorData.type === 'NO_WEBCAM_FOUND') {
      title = t('noWebcamFoundTitle');
      msg = t('noWebcamFound');
    } else if (errorData.message === t('unknownQrCode')) {
      msg = t('unknownQrCode');
    } else {
      title = t('generalCameraErrorTitle');
      msg = t('generalCameraError');
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
      className: "qr-scanner__image"
    }, /*#__PURE__*/_react.default.createElement("img", {
      src: "images/webcam.svg",
      width: "70",
      height: "70",
      alt: ""
    })), title && /*#__PURE__*/_react.default.createElement("div", {
      className: "qr-scanner__title"
    }, title), /*#__PURE__*/_react.default.createElement("div", {
      className: "qr-scanner__error"
    }, msg), /*#__PURE__*/_react.default.createElement(_pageContainerFooter.default, {
      onCancel: stopAndClose,
      onSubmit: tryAgain,
      cancelText: t('cancel'),
      submitText: t('tryAgain')
    }));
  };
  const getQRScanMessage = state => {
    let message;
    switch (state) {
      case READY_STATE.ACCESSING_CAMERA:
        message = t('accessingYourCamera');
        break;
      case READY_STATE.READY:
        message = t('scanInstructions');
        break;
      case READY_STATE.NEED_TO_ALLOW_ACCESS:
        message = t('youNeedToAllowCameraAccess');
        break;
      default:
        message = t('accessingYourCamera');
    }
    return message;
  };
  const renderVideo = () => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
      className: "qr-scanner__title"
    }, `${t('scanQrCode')}`), /*#__PURE__*/_react.default.createElement("div", {
      className: "qr-scanner__content"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "qr-scanner__content__video-wrapper"
    }, /*#__PURE__*/_react.default.createElement("video", {
      id: "video",
      style: {
        display: isReady === READY_STATE.READY ? 'block' : 'none'
      }
    }), isReady !== READY_STATE.READY && /*#__PURE__*/_react.default.createElement(_spinner.default, null))), /*#__PURE__*/_react.default.createElement("div", {
      className: "qr-scanner__status"
    }, getQRScanMessage(isReady)));
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "qr-scanner"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "qr-scanner__close",
    onClick: stopAndClose
  }), errorData ? renderError() : renderVideo());
}
QRCodeScanner.propTypes = {
  hideModal: _propTypes.default.func.isRequired,
  qrCodeDetected: _propTypes.default.func.isRequired
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\qr-scanner\\qr-scanner.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\qr-scanner\\qr-scanner.container.js", {"../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./qr-scanner.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\qr-scanner\\qr-scanner.component.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cqr-scanner%5Cqr-scanner.container.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactRedux = require("react-redux");
var _actions = require("../../../../store/actions");
var _qrScanner = _interopRequireDefault(require("./qr-scanner.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const mapDispatchToProps = dispatch => {
  return {
    hideModal: () => dispatch((0, _actions.hideModal)()),
    qrCodeDetected: data => dispatch((0, _actions.qrCodeDetected)(data))
  };
};
var _default = exports.default = (0, _reactRedux.connect)(null, mapDispatchToProps)(_qrScanner.default);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\qr-scanner\\qr-scanner.container.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\qr-scanner\\scan-util.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cqr-scanner%5Cscan-util.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseScanContent = parseScanContent;
function parseScanContent(content) {
  const matches = content.match(/^[a-zA-Z]+:(0x[0-9a-fA-F]{40})(?:@.*)?/u);
  if (!matches) {
    return null;
  }
  return matches[1];
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\qr-scanner\\scan-util.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\reject-transactions\\index.js", {"./reject-transactions.container":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\reject-transactions\\reject-transactions.container.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Creject-transactions%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _rejectTransactions.default;
  }
});
var _rejectTransactions = _interopRequireDefault(require("./reject-transactions.container"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\reject-transactions\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\reject-transactions\\reject-transactions.component.js", {"../../modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modal\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Creject-transactions%5Creject-transactions.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _modal = _interopRequireDefault(require("../../modal"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class RejectTransactionsModal extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "onSubmit", async () => {
      const {
        onSubmit,
        hideModal
      } = this.props;
      await onSubmit();
      hideModal();
    });
  }
  render() {
    const {
      t
    } = this.context;
    const {
      hideModal,
      unapprovedTxCount,
      isRequestType
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_modal.default, {
      headerText: isRequestType ? t('rejectRequestsN', [unapprovedTxCount]) : t('rejectTxsN', [unapprovedTxCount]),
      onClose: hideModal,
      onSubmit: this.onSubmit,
      onCancel: hideModal,
      submitText: t('rejectAll'),
      cancelText: t('cancel')
    }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("div", {
      className: "reject-transactions__description"
    }, isRequestType ? t('rejectRequestsDescription', [unapprovedTxCount]) : t('rejectTxsDescription', [unapprovedTxCount]))));
  }
}
exports.default = RejectTransactionsModal;
_defineProperty(RejectTransactionsModal, "contextTypes", {
  t: _propTypes.default.func.isRequired
});
_defineProperty(RejectTransactionsModal, "propTypes", {
  onSubmit: _propTypes.default.func.isRequired,
  hideModal: _propTypes.default.func.isRequired,
  unapprovedTxCount: _propTypes.default.number.isRequired,
  isRequestType: _propTypes.default.bool
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\reject-transactions\\reject-transactions.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\reject-transactions\\reject-transactions.container.js", {"../../../../helpers/higher-order-components/with-modal-props":"D:\\code\\v\\metamask-extension\\ui\\helpers\\higher-order-components\\with-modal-props\\index.js","./reject-transactions.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\reject-transactions\\reject-transactions.component.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","redux":"D:\\code\\v\\metamask-extension\\node_modules\\redux\\lib\\redux.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Creject-transactions%5Creject-transactions.container.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactRedux = require("react-redux");
var _redux = require("redux");
var _withModalProps = _interopRequireDefault(require("../../../../helpers/higher-order-components/with-modal-props"));
var _rejectTransactions = _interopRequireDefault(require("./reject-transactions.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const mapStateToProps = (_, ownProps) => {
  const {
    unapprovedTxCount
  } = ownProps;
  return {
    unapprovedTxCount
  };
};
var _default = exports.default = (0, _redux.compose)(_withModalProps.default, (0, _reactRedux.connect)(mapStateToProps))(_rejectTransactions.default);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\reject-transactions\\reject-transactions.container.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\transaction-already-confirmed\\index.ts", {"./transaction-already-confirmed":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\transaction-already-confirmed\\transaction-already-confirmed.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Ctransaction-already-confirmed%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _transactionAlreadyConfirmed.default;
  }
});
var _transactionAlreadyConfirmed = _interopRequireDefault(require("./transaction-already-confirmed"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\transaction-already-confirmed\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\transaction-already-confirmed\\transaction-already-confirmed.tsx", {"../../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useModalProps":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useModalProps.ts","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","@metamask/etherscan-link":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\etherscan-link\\dist\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Ctransaction-already-confirmed%5Ctransaction-already-confirmed.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = TransactionAlreadyConfirmed;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _etherscanLink = require("@metamask/etherscan-link");
var _selectors = require("../../../../selectors");
var _useModalProps = require("../../../../hooks/useModalProps");
var _componentLibrary = require("../../../component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _i18n = require("../../../../contexts/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function TransactionAlreadyConfirmed() {
  const {
    hideModal,
    props: {
      originalTransactionId
    }
  } = (0, _useModalProps.useModalProps)();
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const dispatch = (0, _reactRedux.useDispatch)();
  const transaction = (0, _reactRedux.useSelector)(state =>
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  (0, _selectors.getTransaction)(state, originalTransactionId));
  const rpcPrefs = (0, _reactRedux.useSelector)(_selectors.getRpcPrefsForCurrentProvider);
  const viewTransaction = () => {
    // TODO: Fix getBlockExplorerLink arguments compatible with the actual controller types
    const blockExplorerLink = (0, _etherscanLink.getBlockExplorerLink)(
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    transaction, rpcPrefs);
    global.platform.openTab({
      url: blockExplorerLink
    });
    dispatch(hideModal());
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: true,
    onClose: hideModal
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onClose: hideModal
  }, t('yourTransactionConfirmed')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, null, t('yourTransactionJustConfirmed'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalFooter, {
    onSubmit: hideModal,
    onCancel: viewTransaction,
    submitButtonProps: {
      children: t('gotIt')
    },
    cancelButtonProps: {
      children: t('viewOnBlockExplorer')
    },
    containerProps: {
      flexDirection: _designSystem.FlexDirection.Column,
      alignItems: _designSystem.AlignItems.stretch
    }
  })));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\transaction-already-confirmed\\transaction-already-confirmed.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\transaction-confirmed\\index.js", {"./transaction-confirmed.container":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\transaction-confirmed\\transaction-confirmed.container.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Ctransaction-confirmed%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _transactionConfirmed.default;
  }
});
var _transactionConfirmed = _interopRequireDefault(require("./transaction-confirmed.container"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\transaction-confirmed\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\transaction-confirmed\\transaction-confirmed.component.js", {"../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modal\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Ctransaction-confirmed%5Ctransaction-confirmed.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _modal = _interopRequireDefault(require("../../modal"));
var _componentLibrary = require("../../../component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class TransactionConfirmed extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "handleSubmit", () => {
      const {
        hideModal,
        onSubmit
      } = this.props;
      hideModal();
      if (onSubmit && typeof onSubmit === 'function') {
        onSubmit();
      }
    });
  }
  render() {
    const {
      t
    } = this.context;
    return /*#__PURE__*/_react.default.createElement(_modal.default, {
      onSubmit: this.handleSubmit,
      submitText: t('ok')
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "transaction-confirmed__content"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
      name: _componentLibrary.IconName.Check,
      color: _designSystem.IconColor.successDefault,
      size: _componentLibrary.IconSize.Xl
    }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.headingMd,
      fontWeight: _designSystem.FontWeight.Medium,
      textAlign: _designSystem.TextAlign.Center
    }, `${t('confirmed')}!`), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      textAlign: _designSystem.TextAlign.Center
    }, t('initialTransactionConfirmed'))));
  }
}
exports.default = TransactionConfirmed;
_defineProperty(TransactionConfirmed, "contextTypes", {
  t: _propTypes.default.func
});
_defineProperty(TransactionConfirmed, "propTypes", {
  onSubmit: _propTypes.default.func,
  hideModal: _propTypes.default.func
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\transaction-confirmed\\transaction-confirmed.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\transaction-confirmed\\transaction-confirmed.container.js", {"../../../../helpers/higher-order-components/with-modal-props":"D:\\code\\v\\metamask-extension\\ui\\helpers\\higher-order-components\\with-modal-props\\index.js","./transaction-confirmed.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\transaction-confirmed\\transaction-confirmed.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Ctransaction-confirmed%5Ctransaction-confirmed.container.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _withModalProps = _interopRequireDefault(require("../../../../helpers/higher-order-components/with-modal-props"));
var _transactionConfirmed = _interopRequireDefault(require("./transaction-confirmed.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
var _default = exports.default = (0, _withModalProps.default)(_transactionConfirmed.default);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\transaction-confirmed\\transaction-confirmed.container.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\turn-on-metamask-notifications\\turn-on-metamask-notifications.tsx", {"../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../../contexts/metamask-notifications/metamask-notifications":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metamask-notifications\\metamask-notifications.tsx","../../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../../hooks/metamask-notifications/useNotifications":"D:\\code\\v\\metamask-extension\\ui\\hooks\\metamask-notifications\\useNotifications.ts","../../../../hooks/useModalProps":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useModalProps.ts","../../../../selectors/identity/backup-and-sync":"D:\\code\\v\\metamask-extension\\ui\\selectors\\identity\\backup-and-sync.ts","../../../../selectors/metamask-notifications/metamask-notifications":"D:\\code\\v\\metamask-extension\\ui\\selectors\\metamask-notifications\\metamask-notifications.ts","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cturn-on-metamask-notifications%5Cturn-on-metamask-notifications.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = TurnOnMetamaskNotifications;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _i18n = require("../../../../contexts/i18n");
var _useModalProps = require("../../../../hooks/useModalProps");
var _metamaskNotifications = require("../../../../contexts/metamask-notifications/metamask-notifications");
var _metametrics = require("../../../../contexts/metametrics");
var _metametrics2 = require("../../../../../shared/constants/metametrics");
var _metamaskNotifications2 = require("../../../../selectors/metamask-notifications/metamask-notifications");
var _backupAndSync = require("../../../../selectors/identity/backup-and-sync");
var _useNotifications = require("../../../../hooks/metamask-notifications/useNotifications");
var _routes = require("../../../../helpers/constants/routes");
var _componentLibrary = require("../../../component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function TurnOnMetamaskNotifications() {
  const {
    hideModal
  } = (0, _useModalProps.useModalProps)();
  const history = (0, _reactRouterDom.useHistory)();
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const {
    listNotifications
  } = (0, _metamaskNotifications.useMetamaskNotificationsContext)();
  const isNotificationEnabled = (0, _reactRedux.useSelector)(_metamaskNotifications2.selectIsMetamaskNotificationsEnabled);
  const isUpdatingMetamaskNotifications = (0, _reactRedux.useSelector)(_metamaskNotifications2.getIsUpdatingMetamaskNotifications);
  const isBackupAndSyncEnabled = (0, _reactRedux.useSelector)(_backupAndSync.selectIsBackupAndSyncEnabled);
  const [isLoading, setIsLoading] = (0, _react.useState)(isUpdatingMetamaskNotifications);
  const {
    enableNotifications,
    error
  } = (0, _useNotifications.useEnableNotifications)();
  const handleTurnOnNotifications = async () => {
    setIsLoading(true);
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.NotificationsActivationFlow,
      event: _metametrics2.MetaMetricsEventName.NotificationsActivated,
      properties: {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        is_profile_syncing_enabled: true,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        action_type: 'activated'
      }
    });
    await enableNotifications();
  };
  const handleHideModal = () => {
    hideModal();
    setIsLoading(prevLoadingState => {
      if (!prevLoadingState) {
        trackEvent({
          category: _metametrics2.MetaMetricsEventCategory.NotificationsActivationFlow,
          event: _metametrics2.MetaMetricsEventName.NotificationsActivated,
          properties: {
            // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
            // eslint-disable-next-line @typescript-eslint/naming-convention
            is_profile_syncing_enabled: isBackupAndSyncEnabled,
            // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
            // eslint-disable-next-line @typescript-eslint/naming-convention
            action_type: 'dismissed'
          }
        });
      }
      return prevLoadingState;
    });
  };
  (0, _react.useEffect)(() => {
    if (isNotificationEnabled && !error) {
      history.push(_routes.NOTIFICATIONS_ROUTE);
      hideModal();
      listNotifications();
    }
  }, [isNotificationEnabled, error, history, hideModal, listNotifications]);
  const privacyLink = /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "a",
    href: "https://support.metamask.io/privacy-and-security/profile-privacy",
    target: "_blank",
    rel: "noopener noreferrer",
    key: "privacy-link",
    color: _designSystem.TextColor.infoDefault
  }, t('turnOnMetamaskNotificationsMessagePrivacyLink'));
  const strongText = /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "span",
    fontWeight: _designSystem.FontWeight.Bold,
    key: "strong-text"
  }, t('turnOnMetamaskNotificationsMessagePrivacyBold'));
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: true,
    onClose: () => handleHideModal()
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onClose: () => handleHideModal()
  }, t('turnOnMetamaskNotifications')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    as: "img",
    src: "./images/turn-on-metamask-notifications.png",
    width: _designSystem.BlockSize.Full,
    borderRadius: _designSystem.BorderRadius.MD,
    marginBottom: 4
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "p"
  }, t('turnOnMetamaskNotificationsMessageFirst')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "p",
    paddingTop: 4
  },
  // @ts-expect-error: Expected 0-1 arguments, but got an array.
  // eslint-disable-next-line @typescript-eslint/ban-ts-comment
  t('turnOnMetamaskNotificationsMessageSecond', [privacyLink])), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "p",
    paddingTop: 4
  },
  // @ts-expect-error: Expected 0-1 arguments, but got an array.
  // eslint-disable-next-line @typescript-eslint/ban-ts-comment
  t('turnOnMetamaskNotificationsMessageThird', [strongText]))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalFooter, {
    paddingTop: 4
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    ,
    onSubmit: () => handleTurnOnNotifications(),
    containerProps: {
      flexDirection: _designSystem.FlexDirection.Column,
      alignItems: _designSystem.AlignItems.stretch
    },
    submitButtonProps: {
      children: t('turnOnMetamaskNotificationsButton'),
      loading: isLoading,
      disabled: isLoading,
      'data-testid': 'turn-on-notifications-button'
    }
  }), error && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 4,
    paddingRight: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "p",
    color: _designSystem.TextColor.errorDefault,
    paddingTop: 4
  }, t('turnOnMetamaskNotificationsError')))));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\turn-on-metamask-notifications\\turn-on-metamask-notifications.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\visit-support-data-consent-modal\\index.ts", {"./visit-support-data-consent-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\visit-support-data-consent-modal\\visit-support-data-consent-modal.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cvisit-support-data-consent-modal%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _visitSupportDataConsentModal.default;
  }
});
var _visitSupportDataConsentModal = _interopRequireDefault(require("./visit-support-data-consent-modal"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\visit-support-data-consent-modal\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\visit-support-data-consent-modal\\visit-support-data-consent-modal.tsx", {"../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../../shared/lib/ui-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\ui-utils.js","../../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/utils/window":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\window.ts","../../../../hooks/subscription/useSubscription":"D:\\code\\v\\metamask-extension\\ui\\hooks\\subscription\\useSubscription.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../selectors/identity/authentication":"D:\\code\\v\\metamask-extension\\ui\\selectors\\identity\\authentication.ts","../../../../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmodals%5Cvisit-support-data-consent-modal%5Cvisit-support-data-consent-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _authentication = require("../../../../selectors/identity/authentication");
var _selectors = require("../../../../selectors/selectors");
var _window = require("../../../../helpers/utils/window");
var _componentLibrary = require("../../../component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _metametrics = require("../../../../../shared/constants/metametrics");
var _metametrics2 = require("../../../../contexts/metametrics");
var _uiUtils = require("../../../../../shared/lib/ui-utils");
var _useSubscription = require("../../../../hooks/subscription/useSubscription");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const VisitSupportDataConsentModal = ({
  isOpen,
  onClose
}) => {
  var _sessionData$profile;
  const version = "13.6.0";
  const t = (0, _useI18nContext.useI18nContext)();
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const sessionData = (0, _reactRedux.useSelector)(_authentication.selectSessionData);
  const profileId = sessionData === null || sessionData === void 0 || (_sessionData$profile = sessionData.profile) === null || _sessionData$profile === void 0 ? void 0 : _sessionData$profile.profileId;
  const metaMetricsId = (0, _reactRedux.useSelector)(_selectors.getMetaMetricsId);
  const {
    customerId: shieldCustomerId
  } = (0, _useSubscription.useUserSubscriptions)();
  const handleClickContactSupportButton = (0, _react.useCallback)(params => {
    onClose();
    let supportLinkWithUserId = _uiUtils.SUPPORT_LINK;
    const queryParams = new URLSearchParams();
    queryParams.append('metamask_version', params.version);
    if (params.profileId) {
      queryParams.append('metamask_profile_id', params.profileId);
    }
    if (params.metaMetricsId) {
      queryParams.append('metamask_metametrics_id', params.metaMetricsId);
    }
    if (params.shieldCustomerId) {
      queryParams.append('shield_id', params.shieldCustomerId);
    }
    const queryString = queryParams.toString();
    if (queryString) {
      supportLinkWithUserId += `?${queryString}`;
    }
    trackEvent({
      category: _metametrics.MetaMetricsEventCategory.Settings,
      event: _metametrics.MetaMetricsEventName.SupportLinkClicked,
      properties: {
        url: supportLinkWithUserId
      }
    }, {
      contextPropsIntoEventProperties: [_metametrics.MetaMetricsContextProp.PageTitle]
    });
    (0, _window.openWindow)(supportLinkWithUserId);
  }, [onClose, trackEvent]);
  const handleClickNoShare = (0, _react.useCallback)(() => {
    onClose();
    trackEvent({
      category: _metametrics.MetaMetricsEventCategory.Settings,
      event: _metametrics.MetaMetricsEventName.SupportLinkClicked,
      properties: {
        url: _uiUtils.SUPPORT_LINK
      }
    }, {
      contextPropsIntoEventProperties: [_metametrics.MetaMetricsContextProp.PageTitle]
    });
    (0, _window.openWindow)(_uiUtils.SUPPORT_LINK);
  }, [onClose, trackEvent]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: isOpen,
    onClose: onClose,
    "data-testid": "visit-support-data-consent-modal",
    className: "visit-support-data-consent-modal"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, null, t('visitSupportDataConsentModalTitle')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, {
    paddingLeft: 4,
    paddingRight: 4,
    className: "visit-support-data-consent-modal__body"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd
  }, t('visitSupportDataConsentModalDescription'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalFooter, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonSecondary, {
    size: _componentLibrary.ButtonSecondarySize.Lg,
    width: _designSystem.BlockSize.Half,
    onClick: handleClickNoShare,
    "data-testid": "visit-support-data-consent-modal-reject-button"
  }, t('visitSupportDataConsentModalReject')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonPrimary, {
    size: _componentLibrary.ButtonPrimarySize.Lg,
    width: _designSystem.BlockSize.Half,
    onClick: () => handleClickContactSupportButton({
      version,
      profileId,
      metaMetricsId,
      shieldCustomerId
    }),
    "data-testid": "visit-support-data-consent-modal-accept-button"
  }, t('visitSupportDataConsentModalAccept'))))));
};
var _default = exports.default = VisitSupportDataConsentModal;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\modals\\visit-support-data-consent-modal\\visit-support-data-consent-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\multi-rpc-edit-modal\\multi-rpc-edit-modal.tsx", {"../../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","./network-list-item/network-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\multi-rpc-edit-modal\\network-list-item\\network-list-item.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmulti-rpc-edit-modal%5Cmulti-rpc-edit-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _componentLibrary = require("../../component-library");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _designSystem = require("../../../helpers/constants/design-system");
var _actions = require("../../../store/actions");
var _util = require("../../../../app/scripts/lib/util");
var _networks = require("../../../../shared/modules/selectors/networks");
var _app = require("../../../../shared/constants/app");
var _networkListItem = _interopRequireDefault(require("./network-list-item/network-list-item"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function MultiRpcEditModal() {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const isPopUp = (0, _util.getEnvironmentType)() === _app.ENVIRONMENT_TYPE_POPUP;
  const networkConfigurations = (0, _reactRedux.useSelector)(_networks.getNetworkConfigurationsByChainId);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: true,
    onClose: () => dispatch((0, _actions.setShowMultiRpcModal)(false)),
    isClosedOnOutsideClick: false,
    isClosedOnEscapeKey: false,
    "data-testid": "multi-rpc-edit-modal",
    autoFocus: false
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    borderRadius: _designSystem.BorderRadius.SM
  }, /*#__PURE__*/_react.default.createElement("img", {
    src: "/images/networks1.png"
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdBold,
    textAlign: _designSystem.TextAlign.Center
  }, t('updatedRpcForNetworks')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    textAlign: _designSystem.TextAlign.Center,
    paddingTop: 2
  }, t('supportMultiRpcInformation')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingBottom: 6
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginTop: isPopUp ? 0 : 4,
    marginBottom: 1
  }, Object.values(networkConfigurations).map(networkConfiguration => networkConfiguration.rpcEndpoints.length > 1 ? /*#__PURE__*/_react.default.createElement(_networkListItem.default, {
    networkConfiguration: networkConfiguration,
    key: networkConfiguration.chainId
  }) : null)))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalFooter, {
    onSubmit: () => {
      dispatch((0, _actions.setShowMultiRpcModal)(false));
    },
    submitButtonProps: {
      children: t('accept'),
      block: true
    }
  })));
}
var _default = exports.default = MultiRpcEditModal;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\multi-rpc-edit-modal\\multi-rpc-edit-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\multi-rpc-edit-modal\\network-list-item\\network-list-item.tsx", {"../../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","@metamask/network-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\network-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmulti-rpc-edit-modal%5Cnetwork-list-item%5Cnetwork-list-item.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _networkController = require("@metamask/network-controller");
var _componentLibrary = require("../../../component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _actions = require("../../../../store/actions");
var _network = require("../../../../../shared/constants/network");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NetworkListItem = ({
  networkConfiguration
}) => {
  const rpcEndpoint = networkConfiguration.rpcEndpoints[networkConfiguration.defaultRpcEndpointIndex];
  const t = (0, _useI18nContext.useI18nContext)();
  const [isOpenTooltip, setIsOpenTooltip] = (0, _react.useState)(false);
  const dispatch = (0, _reactRedux.useDispatch)();
  const [referenceElement, setReferenceElement] = (0, _react.useState)();
  const setBoxRef = anchorRef => {
    setReferenceElement(anchorRef);
  };
  const handleMouseEnter = () => {
    setIsOpenTooltip(true);
  };
  const handleMouseLeave = () => {
    setIsOpenTooltip(false);
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    flexDirection: _designSystem.FlexDirection.Row,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    paddingBottom: 4,
    paddingTop: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    width: _designSystem.BlockSize.EightTwelfths
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
    size: _componentLibrary.AvatarNetworkSize.Md,
    src: _network.CHAIN_ID_TO_NETWORK_IMAGE_URL_MAP[networkConfiguration.chainId],
    name: networkConfiguration.name
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    width: _designSystem.BlockSize.ElevenTwelfths
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginLeft: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textDefault,
    backgroundColor: _designSystem.BackgroundColor.transparent,
    ellipsis: true
  }, networkConfiguration.name)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    marginLeft: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    padding: 0,
    backgroundColor: _designSystem.BackgroundColor.transparent,
    as: "button",
    variant: _designSystem.TextVariant.bodySmMedium,
    color: _designSystem.TextColor.textAlternative,
    ref: setBoxRef,
    style: {
      width: 220
    },
    textAlign: _designSystem.TextAlign.Left,
    onMouseLeave: handleMouseLeave,
    onMouseOver: handleMouseEnter,
    ellipsis: true
  }, rpcEndpoint.name ?? new URL(rpcEndpoint.url).host), /*#__PURE__*/_react.default.createElement(_componentLibrary.Popover, {
    referenceElement: referenceElement,
    position: _componentLibrary.PopoverPosition.Bottom,
    isOpen: isOpenTooltip,
    hasArrow: true,
    backgroundColor: _designSystem.BackgroundColor.backgroundAlternative,
    paddingTop: 2,
    paddingBottom: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyXsMedium,
    ellipsis: true
  }, rpcEndpoint.type === _networkController.RpcEndpointType.Infura ? rpcEndpoint.url.replace('/v3/{infuraProjectId}', '') : rpcEndpoint.url))))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    marginLeft: 1
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    type: "button",
    variant: _componentLibrary.ButtonVariant.Link,
    onClick: () => {
      dispatch((0, _actions.toggleNetworkMenu)({
        isAddingNewNetwork: false,
        isMultiRpcOnboarding: true
      }));
      dispatch((0, _actions.setEditedNetwork)({
        chainId: networkConfiguration.chainId,
        nickname: networkConfiguration.name
      }));
    }
  }, t('edit'))));
};
var _default = exports.default = NetworkListItem;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\multi-rpc-edit-modal\\network-list-item\\network-list-item.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\multichain-bridge-transaction-details-modal\\multichain-bridge-transaction-details-modal.tsx", {"../../../../shared/constants/bridge":"D:\\code\\v\\metamask-extension\\shared\\constants\\bridge.ts","../../../../shared/constants/common":"D:\\code\\v\\metamask-extension\\shared\\constants\\common.ts","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/multichain/networks":"D:\\code\\v\\metamask-extension\\shared\\constants\\multichain\\networks.ts","../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../shared/lib/bridge-status/utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\bridge-status\\utils.ts","../../../../shared/lib/multichain/networks":"D:\\code\\v\\metamask-extension\\shared\\lib\\multichain\\networks.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../hooks/bridge/useBridgeChainInfo":"D:\\code\\v\\metamask-extension\\ui\\hooks\\bridge\\useBridgeChainInfo.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../confirm/info/row":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\index.ts","../multichain-transaction-details-modal/helpers":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\multichain-transaction-details-modal\\helpers.ts","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmultichain-bridge-transaction-details-modal%5Cmultichain-bridge-transaction-details-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _bridgeController = require("@metamask/bridge-controller");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _componentLibrary = require("../../component-library");
var _metametrics = require("../../../../shared/constants/metametrics");
var _metametrics2 = require("../../../contexts/metametrics");
var _row = require("../confirm/info/row");
var _util = require("../../../helpers/utils/util");
var _helpers = require("../multichain-transaction-details-modal/helpers");
var _networks = require("../../../../shared/lib/multichain/networks");
var _networks2 = require("../../../../shared/constants/multichain/networks");
var _network = require("../../../../shared/constants/network");
var _common = require("../../../../shared/constants/common");
var _bridge = require("../../../../shared/constants/bridge");
var _utils = require("../../../../shared/lib/bridge-status/utils");
var _useBridgeChainInfo = _interopRequireDefault(require("../../../hooks/bridge/useBridgeChainInfo"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MultichainBridgeTransactionDetailsModal = ({
  transaction,
  bridgeHistoryItem,
  onClose
}) => {
  var _from$, _transaction$fees, _status$destChain, _status$destChain$cha, _status$destChain2, _status$destChain3;
  const t = (0, _useI18nContext.useI18nContext)();
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const {
    quote,
    status
  } = bridgeHistoryItem;

  // --- Extract data directly from transaction ---
  const {
    id,
    timestamp,
    from
  } = transaction;
  const assetData = from === null || from === void 0 || (_from$ = from[0]) === null || _from$ === void 0 ? void 0 : _from$.asset;
  const baseFeeAsset = (_transaction$fees = transaction.fees) === null || _transaction$fees === void 0 || (_transaction$fees = _transaction$fees.find(fee => fee.type === 'base')) === null || _transaction$fees === void 0 ? void 0 : _transaction$fees.asset;
  // --- End direct extraction ---

  // Determine display status text and color based on finalDisplayStatusKey
  let displayStatus = t('bridgeStatusInProgress');
  let statusColor = _designSystem.TextColor.primaryDefault;
  if ((0, _utils.isBridgeComplete)(bridgeHistoryItem)) {
    displayStatus = t('bridgeStatusComplete');
    statusColor = _designSystem.TextColor.successDefault;
  } else if ((0, _utils.isBridgeFailed)(transaction, bridgeHistoryItem)) {
    displayStatus = t('bridgeStatusFailed');
    statusColor = _designSystem.TextColor.errorDefault;
  }
  const getChainExplorerUrl = (txHash, chainId) => {
    if (!txHash || !chainId) {
      return '';
    }
    try {
      const caipChainId = (0, _bridgeController.formatChainIdToCaip)(chainId);
      let blockExplorerUrl = '';
      if ((0, _bridgeController.isNonEvmChainId)(chainId)) {
        const blockExplorerUrls = _networks2.MULTICHAIN_NETWORK_BLOCK_EXPLORER_FORMAT_URLS_MAP[caipChainId];
        if (blockExplorerUrls) {
          blockExplorerUrl = (0, _networks.formatBlockExplorerTransactionUrl)(blockExplorerUrls, txHash.split(':').at(-1) ?? txHash);
        }
      } else {
        // Handle EVM chains using MetaMask's predefined block explorer URLs
        // Make sure chainId is in the correct format (0x-prefixed hex string)
        const formattedChainId = chainId.startsWith('0x') ? chainId : `0x${Number(chainId).toString(16)}`;

        // Use common mapping of chain IDs to block explorer URLs
        const explorerBaseUrl = _common.CHAINID_DEFAULT_BLOCK_EXPLORER_URL_MAP[formattedChainId];
        if (explorerBaseUrl) {
          blockExplorerUrl = `${explorerBaseUrl}tx/${txHash}`;
        } else {
          // Fallback to Etherscan as a last resort
          blockExplorerUrl = `https://etherscan.io/tx/${txHash}`;
        }
      }
      return blockExplorerUrl;
    } catch (error) {
      console.error('Error generating block explorer URL:', error);
      return '';
    }
  };
  const formatDestTokenAmount = (amount, decimals = 18) => {
    if (!amount) {
      return '0';
    }
    try {
      const amountBN = BigInt(amount);
      const divisor = BigInt(10) ** BigInt(decimals);
      const integerPart = amountBN / divisor;
      const remainder = amountBN % divisor;
      const remainderStr = remainder.toString().padStart(decimals, '0');
      const decimalPlaces = 4;
      const formattedDecimal = remainderStr.substring(0, decimalPlaces).replace(/0+$/u, '');
      return formattedDecimal.length > 0 ? `${integerPart}.${formattedDecimal}` : `${integerPart}`;
    } catch (e) {
      console.error('Error formatting destination token amount:', e);
      return amount.toString();
    }
  };
  const {
    srcNetwork,
    destNetwork
  } = (0, _useBridgeChainInfo.default)({
    bridgeHistoryItem,
    nonEvmTransaction: transaction
  });

  // Get source network info from chain ID
  const sourceNetworkNickname = srcNetwork !== null && srcNetwork !== void 0 && srcNetwork.chainId ? _networks2.MULTICHAIN_NETWORK_TO_NICKNAME[srcNetwork.chainId] : undefined;
  const sourceNetworkImage = srcNetwork !== null && srcNetwork !== void 0 && srcNetwork.chainId ? _networks2.MULTICHAIN_TOKEN_IMAGE_MAP[srcNetwork.chainId] : undefined;
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    onClose: onClose,
    "data-testid": "multichain-bridge-transaction-details-modal",
    isOpen: true,
    isClosedOnOutsideClick: true,
    isClosedOnEscapeKey: true
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, {
    className: "multichain-bridge-transaction-details-modal",
    modalDialogProps: {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      padding: 4
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onClose: onClose,
    padding: 0
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingMd,
    textAlign: _designSystem.TextAlign.Center
  }, t('bridgeDetailsTitle')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    color: _designSystem.TextColor.textAlternative,
    textAlign: _designSystem.TextAlign.Center
  }, (0, _helpers.formatTimestamp)(timestamp))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingBottom: 4
  }, /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRowDivider, null)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "multichain-bridge-transaction-details-modal__content",
    style: {
      overflow: 'auto',
      flex: '1'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    fontWeight: _designSystem.FontWeight.Medium
  }, t('status')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    color: statusColor
  }, displayStatus)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    fontWeight: _designSystem.FontWeight.Medium
  }, t('transactionIdLabel')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    gap: 1
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    size: _componentLibrary.ButtonLinkSize.Inherit,
    textProps: {
      variant: _designSystem.TextVariant.bodyMd,
      alignItems: _designSystem.AlignItems.flexStart
    },
    as: "a",
    externalLink: true,
    href: (0, _helpers.getTransactionUrl)(id, (srcNetwork === null || srcNetwork === void 0 ? void 0 : srcNetwork.chainId) ?? transaction.chain)
  }, (0, _helpers.shortenTransactionId)(id), /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    marginLeft: 2,
    name: _componentLibrary.IconName.Export,
    size: _componentLibrary.IconSize.Sm,
    color: _designSystem.IconColor.primaryDefault
  })))), ((_status$destChain = status.destChain) === null || _status$destChain === void 0 ? void 0 : _status$destChain.txHash) && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    fontWeight: _designSystem.FontWeight.Medium
  }, t('destinationTransactionIdLabel')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    gap: 1
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    size: _componentLibrary.ButtonLinkSize.Inherit,
    textProps: {
      variant: _designSystem.TextVariant.bodyMd,
      alignItems: _designSystem.AlignItems.flexStart
    },
    as: "a",
    externalLink: true,
    href: getChainExplorerUrl(status.destChain.txHash, ((_status$destChain$cha = status.destChain.chainId) === null || _status$destChain$cha === void 0 ? void 0 : _status$destChain$cha.toString()) ?? '')
  }, (0, _helpers.shortenTransactionId)(status.destChain.txHash), /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    marginLeft: 2,
    name: _componentLibrary.IconName.Export,
    size: _componentLibrary.IconSize.Sm,
    color: _designSystem.IconColor.primaryDefault
  }))))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingTop: 4,
    paddingBottom: 4
  }, /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRowDivider, null)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginBottom: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    fontWeight: _designSystem.FontWeight.Medium,
    marginBottom: 2
  }, t('bridging')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    alignItems: _designSystem.AlignItems.center,
    marginBottom: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    fontWeight: _designSystem.FontWeight.Medium
  }, t('from')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    gap: 2,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
    size: _componentLibrary.AvatarNetworkSize.Sm,
    className: "multichain-bridge-transaction-details-modal__network-badge",
    name: sourceNetworkNickname ?? '',
    src: sourceNetworkImage ?? '',
    borderColor: _designSystem.BorderColor.backgroundDefault
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd
  }, sourceNetworkNickname))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    fontWeight: _designSystem.FontWeight.Medium
  }, t('to')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    gap: 2,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
    size: _componentLibrary.AvatarNetworkSize.Sm,
    className: "multichain-bridge-transaction-details-modal__network-badge",
    name: destNetwork !== null && destNetwork !== void 0 && destNetwork.chainId ? _bridge.NETWORK_TO_SHORT_NETWORK_NAME_MAP[destNetwork === null || destNetwork === void 0 ? void 0 : destNetwork.chainId] ?? '' : '',
    src: _network.CHAIN_ID_TO_NETWORK_IMAGE_URL_MAP[destNetwork !== null && destNetwork !== void 0 && destNetwork.isEvm ? (0, _bridgeController.formatChainIdToHex)(destNetwork === null || destNetwork === void 0 ? void 0 : destNetwork.chainId) : destNetwork === null || destNetwork === void 0 ? void 0 : destNetwork.chainId] || '',
    borderColor: _designSystem.BorderColor.backgroundDefault
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd
  }, destNetwork !== null && destNetwork !== void 0 && destNetwork.chainId ? _bridge.NETWORK_TO_SHORT_NETWORK_NAME_MAP[destNetwork.chainId] : '')))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    fontWeight: _designSystem.FontWeight.Medium
  }, t('youSent')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.flexEnd
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    "data-testid": "transaction-source-amount"
  }, (() => {
    if (assetData !== null && assetData !== void 0 && assetData.fungible) {
      var _assetData$amount;
      const displayAmount = (_assetData$amount = assetData.amount) !== null && _assetData$amount !== void 0 && _assetData$amount.startsWith('-') ? assetData.amount.substring(1) : assetData.amount;
      return `${displayAmount} ${assetData.unit}`;
    }
    return '';
  })()))), (0, _utils.isBridgeComplete)(bridgeHistoryItem) && (((_status$destChain2 = status.destChain) === null || _status$destChain2 === void 0 ? void 0 : _status$destChain2.amount) ?? quote.destTokenAmount) && quote.destAsset.symbol && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    fontWeight: _designSystem.FontWeight.Medium
  }, t('youReceived')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.flexEnd
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    "data-testid": "transaction-dest-amount"
  }, formatDestTokenAmount(((_status$destChain3 = status.destChain) === null || _status$destChain3 === void 0 ? void 0 : _status$destChain3.amount) ?? quote.destTokenAmount, quote.destAsset.decimals), ' ', quote.destAsset.symbol))), baseFeeAsset && baseFeeAsset.fungible && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    fontWeight: _designSystem.FontWeight.Medium
  }, t('transactionTotalGasFee')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.flexEnd
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    "data-testid": "transaction-gas-fee"
  }, baseFeeAsset.amount, " ", baseFeeAsset.unit))))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingTop: 4
  }, /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRowDivider, null))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalFooter, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    block: true,
    size: _componentLibrary.ButtonSize.Md,
    variant: _componentLibrary.ButtonVariant.Link,
    onClick: () => {
      global.platform.openTab({
        url: getChainExplorerUrl(id, srcNetwork === null || srcNetwork === void 0 ? void 0 : srcNetwork.chainId)
      });
      trackEvent({
        event: _metametrics.MetaMetricsEventName.ExternalLinkClicked,
        category: _metametrics.MetaMetricsEventCategory.Navigation,
        properties: {
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          link_type: _metametrics.MetaMetricsEventLinkType.AccountTracker,
          location: 'Transaction Details',
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          url_domain: (0, _util.getURLHostName)(getChainExplorerUrl(id, srcNetwork === null || srcNetwork === void 0 ? void 0 : srcNetwork.chainId))
        }
      });
    },
    endIconName: _componentLibrary.IconName.Export
  }, t('viewOnBlockExplorer')))));
};
var _default = exports.default = MultichainBridgeTransactionDetailsModal;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\multichain-bridge-transaction-details-modal\\multichain-bridge-transaction-details-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\multichain-bridge-transaction-list-item\\multichain-bridge-transaction-list-item.tsx", {"../../../../shared/constants/bridge":"D:\\code\\v\\metamask-extension\\shared\\constants\\bridge.ts","../../../../shared/constants/multichain/networks":"D:\\code\\v\\metamask-extension\\shared\\constants\\multichain\\networks.ts","../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../../shared/lib/bridge-status/utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\bridge-status\\utils.ts","../../../ducks/locale/locale":"D:\\code\\v\\metamask-extension\\ui\\ducks\\locale\\locale.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/bridge/useBridgeChainInfo":"D:\\code\\v\\metamask-extension\\ui\\hooks\\bridge\\useBridgeChainInfo.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../hooks/useMultichainTransactionDisplay":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainTransactionDisplay.ts","../../../pages/bridge/transaction-details/segment":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\transaction-details\\segment.tsx","../../../pages/confirmations/components/simulation-details/formatAmount":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\simulation-details\\formatAmount.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../multichain/activity-list-item/activity-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\activity-list-item\\activity-list-item.js","../multichain-transaction-details-modal/helpers":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\multichain-transaction-details-modal\\helpers.ts","../transaction-icon":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\transaction-icon\\index.js","../transaction-status-label/transaction-status-label":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\transaction-status-label\\transaction-status-label.js","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","bignumber.js":"D:\\code\\v\\metamask-extension\\node_modules\\bignumber.js\\bignumber.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmultichain-bridge-transaction-list-item%5Cmultichain-bridge-transaction-list-item.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _lodash = require("lodash");
var _bignumber = require("bignumber.js");
var _keyringApi = require("@metamask/keyring-api");
var _bridgeController = require("@metamask/bridge-controller");
var _utils = require("../../../../shared/lib/bridge-status/utils");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _useMultichainTransactionDisplay = require("../../../hooks/useMultichainTransactionDisplay");
var _helpers = require("../multichain-transaction-details-modal/helpers");
var _transactionIcon = _interopRequireDefault(require("../transaction-icon"));
var _transactionStatusLabel = _interopRequireDefault(require("../transaction-status-label/transaction-status-label"));
var _activityListItem = require("../../multichain/activity-list-item/activity-list-item");
var _segment = _interopRequireDefault(require("../../../pages/bridge/transaction-details/segment"));
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../component-library");
var _networks = require("../../../../shared/constants/multichain/networks");
var _transaction = require("../../../../shared/constants/transaction");
var _bridge = require("../../../../shared/constants/bridge");
var _useBridgeChainInfo = _interopRequireDefault(require("../../../hooks/bridge/useBridgeChainInfo"));
var _formatAmount = require("../../../pages/confirmations/components/simulation-details/formatAmount");
var _locale = require("../../../ducks/locale/locale");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * Renders a transaction list item for multichain bridge operations (Solana, Bitcoin, etc.),
 * displaying progress across source and destination chains.
 *
 * @param options0 - Component props
 * @param options0.transaction - The transaction data to display
 * @param options0.bridgeHistoryItem - The bridge history item data to display
 * @param options0.toggleShowDetails - Function to call when the item is clicked
 */
const MultichainBridgeTransactionListItem = ({
  transaction,
  bridgeHistoryItem,
  toggleShowDetails
}) => {
  var _from$;
  const t = (0, _useI18nContext.useI18nContext)();
  const locale = (0, _reactRedux.useSelector)(_locale.getIntlLocale);
  const isSourceTxConfirmed = transaction.status === _keyringApi.TransactionStatus.Confirmed;
  const {
    type,
    from
  } = transaction;
  const sourceAsset = from === null || from === void 0 || (_from$ = from[0]) === null || _from$ === void 0 ? void 0 : _from$.asset;
  const isBridgeFullyComplete = (0, _utils.isBridgeComplete)(bridgeHistoryItem);
  const isBridgeFailedOrSourceFailed = (0, _utils.isBridgeFailed)(transaction, bridgeHistoryItem);
  const isTerminalState = isBridgeFullyComplete || isBridgeFailedOrSourceFailed;
  const srcSegmentStatus = isSourceTxConfirmed ? _bridgeController.StatusTypes.COMPLETE : _bridgeController.StatusTypes.PENDING;
  let destSegmentStatus = null;
  if (isSourceTxConfirmed) {
    destSegmentStatus = isBridgeFullyComplete ? _bridgeController.StatusTypes.COMPLETE : _bridgeController.StatusTypes.PENDING;
  }
  const txIndex = isSourceTxConfirmed ? 2 : 1;
  const {
    srcNetwork,
    destNetwork
  } = (0, _useBridgeChainInfo.default)({
    bridgeHistoryItem,
    nonEvmTransaction: transaction
  });

  // Get source network info from chain ID
  const sourceNetworkNickname = srcNetwork !== null && srcNetwork !== void 0 && srcNetwork.chainId ? _networks.MULTICHAIN_NETWORK_TO_NICKNAME[srcNetwork.chainId] : undefined;
  const sourceNetworkImage = srcNetwork !== null && srcNetwork !== void 0 && srcNetwork.chainId ? _networks.MULTICHAIN_TOKEN_IMAGE_MAP[srcNetwork.chainId] : undefined;
  const displayChainName = (destNetwork !== null && destNetwork !== void 0 && destNetwork.chainId ? _bridge.NETWORK_TO_SHORT_NETWORK_NAME_MAP[destNetwork.chainId] : undefined) ?? (destNetwork === null || destNetwork === void 0 ? void 0 : destNetwork.chainId);
  const title = displayChainName ? `${t('bridgeTo')} ${displayChainName}` : (0, _lodash.capitalize)(type);
  return /*#__PURE__*/_react.default.createElement(_activityListItem.ActivityListItem, {
    className: "multichain-bridge-transaction-list-item",
    "data-testid": "multichain-bridge-activity-item",
    onClick: () => toggleShowDetails(transaction),
    icon: /*#__PURE__*/_react.default.createElement(_componentLibrary.BadgeWrapper, {
      anchorElementShape: _componentLibrary.BadgeWrapperAnchorElementShape.circular,
      badge: /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
        borderColor: _designSystem.BorderColor.backgroundDefault,
        borderWidth: 1,
        className: "activity-tx__network-badge",
        "data-testid": "activity-tx-network-badge",
        name: sourceNetworkNickname ?? '',
        size: _componentLibrary.AvatarNetworkSize.Xs,
        src: sourceNetworkImage ?? ''
      }),
      display: _designSystem.Display.Block,
      positionObj: {
        right: -4,
        top: -4
      }
    }, /*#__PURE__*/_react.default.createElement(_transactionIcon.default, {
      category: _transaction.TransactionGroupCategory.bridge,
      status: _useMultichainTransactionDisplay.KEYRING_TRANSACTION_STATUS_KEY[transaction.status] ?? _keyringApi.TransactionStatus.Submitted
    })),
    rightContent: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      className: "activity-list-item__primary-currency",
      color: _designSystem.TextColor.textDefault,
      "data-testid": "transaction-list-item-primary-currency",
      ellipsis: true,
      fontWeight: _designSystem.FontWeight.Medium,
      textAlign: _designSystem.TextAlign.Right,
      title: "Primary Currency",
      variant: _designSystem.TextVariant.bodyMdMedium
    }, (() => {
      if (sourceAsset !== null && sourceAsset !== void 0 && sourceAsset.fungible) {
        const displayAmount = (0, _formatAmount.formatAmount)(locale, new _bignumber.BigNumber(sourceAsset.amount));
        return `-${displayAmount} ${bridgeHistoryItem.quote.srcAsset.symbol ?? sourceAsset.unit}`;
      }
      return '';
    })())),
    title: title,
    subtitle: /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      gap: 1
    }, isTerminalState ? /*#__PURE__*/_react.default.createElement(_transactionStatusLabel.default, {
      date: (0, _helpers.formatTimestamp)(transaction.timestamp),
      error: {},
      status: _useMultichainTransactionDisplay.KEYRING_TRANSACTION_STATUS_KEY[transaction.status],
      statusOnly: true,
      className: isBridgeFullyComplete ? 'transaction-status-label--confirmed' : undefined
    }) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      marginTop: 0,
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      gap: 1,
      width: _designSystem.BlockSize.Full
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      color: _designSystem.TextColor.textAlternative,
      variant: _designSystem.TextVariant.bodySm
    }, t('bridgeTransactionProgress', [txIndex])), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      gap: 2,
      width: _designSystem.BlockSize.Full
    }, /*#__PURE__*/_react.default.createElement(_segment.default, {
      type: srcSegmentStatus
    }), /*#__PURE__*/_react.default.createElement(_segment.default, {
      type: destSegmentStatus
    }))))
  });
};
var _default = exports.default = MultichainBridgeTransactionListItem;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\multichain-bridge-transaction-list-item\\multichain-bridge-transaction-list-item.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\multichain-transaction-details-modal\\helpers.ts", {"../../../../shared/constants/multichain/networks":"D:\\code\\v\\metamask-extension\\shared\\constants\\multichain\\networks.ts","../../../../shared/lib/multichain/networks":"D:\\code\\v\\metamask-extension\\shared\\lib\\multichain\\networks.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","luxon":"D:\\code\\v\\metamask-extension\\node_modules\\luxon\\build\\cjs-browser\\luxon.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmultichain-transaction-details-modal%5Chelpers.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTransactionUrl = exports.getAddressUrl = exports.formatTimestamp = void 0;
exports.shortenTransactionId = shortenTransactionId;
var _luxon = require("luxon");
var _networks = require("../../../../shared/constants/multichain/networks");
var _util = require("../../../helpers/utils/util");
var _networks2 = require("../../../../shared/lib/multichain/networks");
/**
 * Creates a transaction URL for block explorer based on network type
 * Different networks have different URL patterns:
 * Bitcoin Mainnet: https://mempool.space/tx/{txId}
 * Bitcoin Testnet: https://mempool.space/testnet/tx/{txId}
 * Solana Mainnet: https://solscan.io/tx/{txId}
 * Solana Devnet: https://solscan.io/tx/{txId}?cluster=devnet
 *
 * @param txId - Transaction ID
 * @param chainId - Network chain ID
 * @returns Full URL to transaction in block explorer, or empty string if no explorer URL
 */
const getTransactionUrl = (txId, chainId) => {
  const explorerUrls = _networks.MULTICHAIN_NETWORK_BLOCK_EXPLORER_FORMAT_URLS_MAP[chainId];
  if (!explorerUrls) {
    return '';
  }
  return (0, _networks2.formatBlockExplorerTransactionUrl)(explorerUrls, txId);
};

/**
 * Creates an address URL for block explorer based on network type
 * Different networks have different URL patterns:
 * Bitcoin Mainnet: https://mempool.space/address/{address}
 * Bitcoin Testnet: https://mempool.space/testnet/address/{address}
 * Solana Mainnet: https://solscan.io/account/{address}
 * Solana Devnet: https://solscan.io/account/{address}?cluster=devnet
 *
 * @param address - Wallet address
 * @param chainId - Network chain ID
 * @returns Full URL to address in block explorer, or empty string if no explorer URL
 */
exports.getTransactionUrl = getTransactionUrl;
const getAddressUrl = (address, chainId) => {
  const explorerUrls = _networks.MULTICHAIN_NETWORK_BLOCK_EXPLORER_FORMAT_URLS_MAP[chainId];
  if (!explorerUrls) {
    return '';
  }
  return (0, _networks2.formatBlockExplorerAddressUrl)(explorerUrls, address);
};

/**
 * Formats a timestamp into a localized date and time string
 * Example outputs: "Mar 15, 2024, 14:30" or "Dec 25, 2023, 09:45"
 *
 * @param timestamp - Unix timestamp in milliseconds
 * @returns Formatted date and time string, or empty string if timestamp is null
 */
exports.getAddressUrl = getAddressUrl;
const formatTimestamp = timestamp => {
  if (!timestamp) {
    return '';
  }

  // It's typical for Solana timestamps to use seconds, while JS Dates and most EVM chains use milliseconds.
  // Hence we needed to use the conversion `timestamp < 1e12 ? timestamp * 1000 : timestamp` for it to work.
  const timestampMs = timestamp < 1e12 ? timestamp * 1000 : timestamp;
  const dateTime = _luxon.DateTime.fromMillis(timestampMs);
  const date = (0, _util.formatDateWithYearContext)(timestampMs, 'MMM d, y', 'MMM d');
  const time = dateTime.toFormat('HH:mm');
  return `${date}, ${time}`;
};

/**
 * Formats a shorten version of a transaction ID.
 *
 * @param txId - Transaction ID.
 * @returns Formatted transaction ID.
 */
exports.formatTimestamp = formatTimestamp;
function shortenTransactionId(txId) {
  // For transactions we use a similar output for now, but shortenTransactionId will be added later.
  return (0, _util.shortenAddress)(txId);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\multichain-transaction-details-modal\\helpers.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\multichain-transaction-details-modal\\index.ts", {"./multichain-transaction-details-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\multichain-transaction-details-modal\\multichain-transaction-details-modal.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmultichain-transaction-details-modal%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "MultichainTransactionDetailsModal", {
  enumerable: true,
  get: function () {
    return _multichainTransactionDetailsModal.MultichainTransactionDetailsModal;
  }
});
var _multichainTransactionDetailsModal = require("./multichain-transaction-details-modal");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\multichain-transaction-details-modal\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\multichain-transaction-details-modal\\multichain-transaction-details-modal.tsx", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../hooks/useMultichainTransactionDisplay":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainTransactionDisplay.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../confirm/info/row":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\confirm\\info\\row\\index.ts","./helpers":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\multichain-transaction-details-modal\\helpers.ts","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmultichain-transaction-details-modal%5Cmultichain-transaction-details-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultichainTransactionDetailsModal = MultichainTransactionDetailsModal;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _keyringApi = require("@metamask/keyring-api");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _componentLibrary = require("../../component-library");
var _metametrics = require("../../../../shared/constants/metametrics");
var _metametrics2 = require("../../../contexts/metametrics");
var _row = require("../confirm/info/row");
var _util = require("../../../helpers/utils/util");
var _useMultichainTransactionDisplay = require("../../../hooks/useMultichainTransactionDisplay");
var _helpers = require("./helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function MultichainTransactionDetailsModal({
  transaction,
  onClose,
  userAddress,
  networkConfig
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const {
    from,
    to,
    isRedeposit,
    baseFee,
    priorityFee,
    status,
    chain,
    type,
    timestamp,
    id
  } = (0, _useMultichainTransactionDisplay.useMultichainTransactionDisplay)(transaction, networkConfig);
  const getStatusColor = txStatus => {
    switch (txStatus === null || txStatus === void 0 ? void 0 : txStatus.toLowerCase()) {
      case _keyringApi.TransactionStatus.Confirmed:
        return _designSystem.TextColor.successDefault;
      case _keyringApi.TransactionStatus.Unconfirmed:
        return _designSystem.TextColor.warningDefault;
      case _keyringApi.TransactionStatus.Failed:
        return _designSystem.TextColor.errorDefault;
      default:
        return _designSystem.TextColor.textDefault;
    }
  };
  const statusKey = _useMultichainTransactionDisplay.KEYRING_TRANSACTION_STATUS_KEY[status];
  const accountComponent = (label, address) => address ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    fontWeight: _designSystem.FontWeight.Medium
  }, label), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    gap: 1
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    size: _componentLibrary.ButtonLinkSize.Inherit,
    textProps: {
      variant: _designSystem.TextVariant.bodyMd,
      alignItems: _designSystem.AlignItems.flexStart
    },
    as: "a",
    externalLink: true,
    href: (0, _helpers.getAddressUrl)(address, chain)
  }, (0, _util.shortenAddress)(address), /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    marginLeft: 2,
    name: _componentLibrary.IconName.Export,
    size: _componentLibrary.IconSize.Sm,
    color: _designSystem.IconColor.primaryDefault
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    ,
    onClick: () => navigator.clipboard.writeText((0, _helpers.getAddressUrl)(address, chain))
  })))) : null;
  const amountComponent = (asset, label, dataTestId) => {
    if (!asset) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      justifyContent: _designSystem.JustifyContent.spaceBetween
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMd,
      fontWeight: _designSystem.FontWeight.Medium
    }, label), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      alignItems: _designSystem.AlignItems.flexEnd
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMd,
      "data-testid": dataTestId
    }, asset.amount, " ", asset.unit)));
  };
  const typeToTitle = {
    // TODO: Add support for other transaction types
    [_keyringApi.TransactionType.Send]: t('send'),
    [_keyringApi.TransactionType.Receive]: t('receive'),
    [_keyringApi.TransactionType.Swap]: t('swap'),
    [_keyringApi.TransactionType.Unknown]: t('interaction')
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    onClose: onClose,
    "data-testid": "multichain-transaction-details-modal",
    isOpen: true,
    isClosedOnOutsideClick: true,
    isClosedOnEscapeKey: true
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, {
    modalDialogProps: {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      padding: 4
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onClose: onClose,
    padding: 0
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingMd,
    textAlign: _designSystem.TextAlign.Center
  }, (0, _lodash.capitalize)(isRedeposit ? t('redeposit') : typeToTitle[type])), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    color: _designSystem.TextColor.textAlternative,
    textAlign: _designSystem.TextAlign.Center
  }, (0, _helpers.formatTimestamp)(timestamp))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingBottom: 4
  }, /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRowDivider, null)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 4
  }, status && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    fontWeight: _designSystem.FontWeight.Medium
  }, t('status')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    color: getStatusColor(status)
  }, (0, _lodash.capitalize)(t(statusKey)))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    fontWeight: _designSystem.FontWeight.Medium
  }, t('notificationItemTransactionId')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    gap: 1
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    size: _componentLibrary.ButtonLinkSize.Inherit,
    textProps: {
      variant: _designSystem.TextVariant.bodyMd,
      alignItems: _designSystem.AlignItems.flexStart
    },
    as: "a",
    externalLink: true,
    href: (0, _helpers.getTransactionUrl)(id, chain)
  }, (0, _helpers.shortenTransactionId)(id), /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    marginLeft: 2,
    name: _componentLibrary.IconName.Export,
    size: _componentLibrary.IconSize.Sm,
    color: _designSystem.IconColor.primaryDefault
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    ,
    onClick: () => navigator.clipboard.writeText((0, _helpers.getTransactionUrl)(id, chain))
  }))))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingTop: 4,
    paddingBottom: 4
  }, /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRowDivider, null)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 4
  }, type === _keyringApi.TransactionType.Send ? accountComponent(t('from'), userAddress) : accountComponent(t('from'), from === null || from === void 0 ? void 0 : from.address), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, accountComponent(t('to'), to === null || to === void 0 ? void 0 : to.address), amountComponent(type === _keyringApi.TransactionType.Swap ? from : to, t('amount'), 'transaction-amount')), amountComponent(baseFee, t('networkFee'), 'transaction-base-fee'), amountComponent(priorityFee, t('priorityFee'), 'transaction-priority-fee'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingTop: 4
  }, /*#__PURE__*/_react.default.createElement(_row.ConfirmInfoRowDivider, null)), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalFooter, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    block: true,
    size: _componentLibrary.ButtonSize.Md,
    variant: _componentLibrary.ButtonVariant.Link,
    onClick: () => {
      global.platform.openTab({
        url: (0, _helpers.getTransactionUrl)(id, chain)
      });
      trackEvent({
        event: _metametrics.MetaMetricsEventName.ExternalLinkClicked,
        category: _metametrics.MetaMetricsEventCategory.Navigation,
        properties: {
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          link_type: _metametrics.MetaMetricsEventLinkType.AccountTracker,
          location: 'Transaction Details',
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          url_domain: (0, _util.getURLHostName)((0, _helpers.getTransactionUrl)(id, chain))
        }
      });
    },
    endIconName: _componentLibrary.IconName.Export
  }, t('viewDetails')))));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\multichain-transaction-details-modal\\multichain-transaction-details-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\multiple-notifications\\index.js", {"./multiple-notifications.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\multiple-notifications\\multiple-notifications.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmultiple-notifications%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _multipleNotifications.default;
  }
});
var _multipleNotifications = _interopRequireDefault(require("./multiple-notifications.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\multiple-notifications\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\multiple-notifications\\multiple-notifications.component.js", {"classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cmultiple-notifications%5Cmultiple-notifications.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _propTypes = _interopRequireDefault(require("prop-types"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class MultipleNotifications extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "state", {
      showAll: false
    });
  }
  render() {
    const {
      showAll
    } = this.state;
    const {
      children,
      classNames
    } = this.props;
    const childrenToRender = children.filter(Boolean);
    if (childrenToRender.length === 0) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement("div", {
      className: (0, _classnames.default)(...classNames, 'home-notification-wrapper--multichain', {
        'home-notification-wrapper--show-all': showAll,
        'home-notification-wrapper--show-first': !showAll
      })
    }, childrenToRender, /*#__PURE__*/_react.default.createElement("div", {
      className: "home-notification-wrapper__i-container",
      onClick: () => this.setState({
        showAll: !showAll
      })
    }, childrenToRender.length > 1 ? /*#__PURE__*/_react.default.createElement("i", {
      className: (0, _classnames.default)('fa fa-sm fa-sort-amount', {
        flipped: !showAll
      })
    }) : null));
  }
}
exports.default = MultipleNotifications;
_defineProperty(MultipleNotifications, "defaultProps", {
  children: [],
  classNames: []
});
_defineProperty(MultipleNotifications, "propTypes", {
  children: _propTypes.default.array,
  classNames: _propTypes.default.array
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\multiple-notifications\\multiple-notifications.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\name\\index.ts", {"./name":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\name\\name.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cname%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _name.default;
  }
});
var _name = _interopRequireDefault(require("./name"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\name\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\name\\name-details\\formatted-value.tsx", {"../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","@metamask/name-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\name-controller\\dist\\index.cjs","ethereumjs-util":"D:\\code\\v\\metamask-extension\\node_modules\\ethereumjs-util\\dist.browser\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cname%5Cname-details%5Cformatted-value.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _ethereumjsUtil = require("ethereumjs-util");
var _nameController = require("@metamask/name-controller");
var _componentLibrary = require("../../../component-library");
var _util = require("../../../../helpers/utils/util");
var _designSystem = require("../../../../helpers/constants/design-system");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function formatValue(value, type) {
  if (!value.length) {
    return value;
  }
  switch (type) {
    case _nameController.NameType.ETHEREUM_ADDRESS:
      return (0, _util.shortenAddress)((0, _ethereumjsUtil.toChecksumAddress)(value));
    default:
      return value;
  }
}
const FormattedValue = /*#__PURE__*/(0, _react.memo)(({
  value,
  type,
  ...props
}) => {
  const formattedValue = formatValue(value, type);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, _extends({
    className: "name__value",
    variant: _designSystem.TextVariant.bodyMd
  }, props), formattedValue);
});
var _default = exports.default = FormattedValue;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\name\\name-details\\formatted-value.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\name\\name-details\\metrics.ts", {"../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cname%5Cname-details%5Cmetrics.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePetnamesMetrics = usePetnamesMetrics;
var _react = require("react");
var _metametrics = require("../../../../contexts/metametrics");
var _metametrics2 = require("../../../../../shared/constants/metametrics");
function usePetnamesMetrics({
  initialSources,
  name,
  proposedNameOptions,
  savedName,
  savedSourceId,
  selectedSourceId,
  type
}) {
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const trackPetnamesEvent = (0, _react.useCallback)((event,
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  additionalProperties = {}) => {
    const suggestedNameSources = [
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    ...new Set(proposedNameOptions.map(option => option.sourceId))];

    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    const properties = {
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      petname_category: type,
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      suggested_names_sources: suggestedNameSources,
      ...additionalProperties
    };
    trackEvent({
      event,
      category: _metametrics2.MetaMetricsEventCategory.Petnames,
      properties
    });
  }, [trackEvent, type, proposedNameOptions]);
  const trackPetnamesSaveEvent = (0, _react.useCallback)(() => {
    const petnameSource = selectedSourceId ?? null;
    const isDeleted = (savedName === null || savedName === void 0 ? void 0 : savedName.length) && !(name !== null && name !== void 0 && name.length);
    const isUpdated = (savedName === null || savedName === void 0 ? void 0 : savedName.length) && (name === null || name === void 0 ? void 0 : name.length) && name !== savedName;
    const isCreated = !(savedName !== null && savedName !== void 0 && savedName.length) && (name === null || name === void 0 ? void 0 : name.length);
    let event = null;

    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    let additionalProperties = {};
    if (isDeleted) {
      event = _metametrics2.MetaMetricsEventName.PetnameDeleted;
      additionalProperties = {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        petname_previous_source: savedSourceId
      };
    }
    if (isUpdated) {
      event = _metametrics2.MetaMetricsEventName.PetnameUpdated;
      additionalProperties = {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        petname_previous_source: savedSourceId,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        petname_source: petnameSource
      };
    }
    if (isCreated) {
      event = _metametrics2.MetaMetricsEventName.PetnameCreated;
      additionalProperties = {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        petname_source: petnameSource
      };
    }
    if (!event) {
      return;
    }
    trackPetnamesEvent(event, additionalProperties);
  }, [trackPetnamesEvent, name, selectedSourceId, savedName, savedSourceId]);
  const trackPetnamesOpenEvent = (0, _react.useCallback)(() => {
    trackPetnamesEvent(_metametrics2.MetaMetricsEventName.PetnameModalOpened, {
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      has_petname: Boolean(savedName === null || savedName === void 0 ? void 0 : savedName.length),
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      suggested_names_sources: initialSources
    });
  }, [trackPetnamesEvent, savedName, initialSources]);
  return {
    trackPetnamesOpenEvent,
    trackPetnamesSaveEvent
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\name\\name-details\\metrics.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\name\\name-details\\name-details.tsx", {"../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useCopyToClipboard":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useCopyToClipboard.js","../../../../hooks/useDisplayName":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useDisplayName.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../hooks/useName":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useName.ts","../../../../hooks/useTrustSignals":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTrustSignals.ts","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../ui/form-combo-field/form-combo-field":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\form-combo-field\\form-combo-field.tsx","./metrics":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\name\\name-details\\metrics.ts","./name-display":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\name\\name-details\\name-display.tsx","@metamask/name-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\name-controller\\dist\\index.cjs","ethereumjs-util":"D:\\code\\v\\metamask-extension\\node_modules\\ethereumjs-util\\dist.browser\\index.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cname%5Cname-details%5Cname-details.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = NameDetails;
var _react = _interopRequireWildcard(require("react"));
var _nameController = require("@metamask/name-controller");
var _reactRedux = require("react-redux");
var _lodash = require("lodash");
var _ethereumjsUtil = require("ethereumjs-util");
var _componentLibrary = require("../../../component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _formComboField = _interopRequireDefault(require("../../../ui/form-combo-field/form-combo-field"));
var _selectors = require("../../../../selectors");
var _actions = require("../../../../store/actions");
var _useCopyToClipboard = require("../../../../hooks/useCopyToClipboard");
var _useName = require("../../../../hooks/useName");
var _useDisplayName = require("../../../../hooks/useDisplayName");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _useTrustSignals = require("../../../../hooks/useTrustSignals");
var _nameDisplay = _interopRequireDefault(require("./name-display"));
var _metrics = require("./metrics");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/* eslint-disable @typescript-eslint/ban-ts-comment */

const UPDATE_DELAY = 1000 * 2; // 2 Seconds

function formatValue(value, type) {
  if (!value.length) {
    return value;
  }
  switch (type) {
    case _nameController.NameType.ETHEREUM_ADDRESS:
      return (0, _ethereumjsUtil.toChecksumAddress)(value);
    default:
      return value;
  }
}

// Provider source ids that have a localized name:
const LOCALIZED_PROVIDERS = ['ens', 'etherscan', 'lens', 'token'];
// The following lines avoid i18n "unused messages" lint error.
// t('nameProvider_ens');
// t('nameProvider_etherscan');
// t('nameProvider_lens');
// t('nameProvider_token');

function getProviderLabel(sourceId, t, nameSources) {
  var _nameSources$sourceId;
  if (LOCALIZED_PROVIDERS.includes(sourceId)) {
    // Use intermediate variable to avoid "Forbidden use of template strings
    // in 't' function" error.
    const messageKey = `nameProvider_${sourceId}`;
    return t(messageKey);
  }
  return ((_nameSources$sourceId = nameSources[sourceId]) === null || _nameSources$sourceId === void 0 ? void 0 : _nameSources$sourceId.label) ?? sourceId;
}
function generateComboOptions(proposedNameEntries, t, nameSources) {
  const sourceIds = Object.keys(proposedNameEntries);
  const sourceIdsWithProposedNames = sourceIds.filter(sourceId => {
    var _proposedNameEntries$;
    return (_proposedNameEntries$ = proposedNameEntries[sourceId]) === null || _proposedNameEntries$ === void 0 || (_proposedNameEntries$ = _proposedNameEntries$.proposedNames) === null || _proposedNameEntries$ === void 0 ? void 0 : _proposedNameEntries$.length;
  });
  const options = sourceIdsWithProposedNames.map(sourceId => {
    var _proposedNameEntries$2;
    const sourceProposedNames = ((_proposedNameEntries$2 = proposedNameEntries[sourceId]) === null || _proposedNameEntries$2 === void 0 ? void 0 : _proposedNameEntries$2.proposedNames) ?? [];
    return sourceProposedNames.map(proposedName => ({
      value: proposedName,
      primaryLabel: t('nameModalMaybeProposedName', [proposedName]),
      secondaryLabel: t('nameProviderProposedBy', [getProviderLabel(sourceId, t, nameSources)]),
      sourceId
    }));
  }).flat();
  return options.sort((a, b) => a.secondaryLabel.toLowerCase().localeCompare(b.secondaryLabel.toLowerCase()));
}
function getInitialSources(proposedNamesResult, proposedNamesState) {
  const resultSources = Object.keys(proposedNamesResult).filter(sourceId => {
    var _proposedNamesResult$;
    return (_proposedNamesResult$ = proposedNamesResult[sourceId].proposedNames) === null || _proposedNamesResult$ === void 0 ? void 0 : _proposedNamesResult$.length;
  });
  const stateSources = Object.keys(proposedNamesState).filter(sourceId => {
    var _proposedNamesResult$2, _proposedNamesState$s;
    return !((_proposedNamesResult$2 = proposedNamesResult[sourceId]) !== null && _proposedNamesResult$2 !== void 0 && _proposedNamesResult$2.proposedNames) && ((_proposedNamesState$s = proposedNamesState[sourceId].proposedNames) === null || _proposedNamesState$s === void 0 ? void 0 : _proposedNamesState$s.length);
  });
  return [...resultSources, ...stateSources].sort();
}
function useProposedNames(value, type, variation) {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    proposedNames
  } = (0, _useName.useName)(value, type, variation);

  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  const updateInterval = (0, _react.useRef)();
  const [initialSources, setInitialSources] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    const reset = () => {
      if (updateInterval.current) {
        clearInterval(updateInterval.current);
      }
    };
    const update = async () => {
      const result = await dispatch((0, _actions.updateProposedNames)({
        value,
        type,
        onlyUpdateAfterDelay: true,
        variation
      })

      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
      );
      if (!initialSources) {
        setInitialSources(getInitialSources((result === null || result === void 0 ? void 0 : result.results) ?? {}, proposedNames));
      }
    };
    reset();
    update();

    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    updateInterval.current = setInterval(update, UPDATE_DELAY);
    return reset;
  }, [value, type, variation, dispatch, initialSources, setInitialSources]);
  return {
    proposedNames,
    initialSources
  };
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function NameDetails({
  onClose,
  type,
  value,
  variation
}) {
  const {
    name: savedPetname,
    sourceId: savedSourceId
  } = (0, _useName.useName)(value, type, variation);
  const {
    name: displayName,
    hasPetname: hasSavedPetname,
    displayState,
    subtitle
  } = (0, _useDisplayName.useDisplayName)({
    value,
    type,
    variation
  });
  const nameSources = (0, _reactRedux.useSelector)(_selectors.getNameSources, _lodash.isEqual);
  const [name, setName] = (0, _react.useState)('');
  const [openMetricSent, setOpenMetricSent] = (0, _react.useState)(false);
  const [selectedSourceId, setSelectedSourceId] = (0, _react.useState)();
  const [selectedSourceName, setSelectedSourceName] = (0, _react.useState)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const t = (0, _useI18nContext.useI18nContext)();
  const formattedValue = formatValue(value, type);
  const {
    proposedNames,
    initialSources
  } = useProposedNames(value, type, variation);
  const [copiedAddress, handleCopyAddress] = (0, _useCopyToClipboard.useCopyToClipboard)();
  (0, _react.useEffect)(() => {
    setName(savedPetname ?? '');
    setSelectedSourceId(savedSourceId ?? undefined);
    setSelectedSourceName(savedSourceId ? savedPetname ?? undefined : undefined);
  }, [savedPetname, savedSourceId, setName, setSelectedSourceId]);
  const proposedNameOptions = (0, _react.useMemo)(() => generateComboOptions(proposedNames, t, nameSources), [proposedNames, t, nameSources]);
  const {
    trackPetnamesOpenEvent,
    trackPetnamesSaveEvent
  } = (0, _metrics.usePetnamesMetrics)({
    initialSources,
    name,
    proposedNameOptions,
    savedName: savedPetname,
    savedSourceId,
    selectedSourceId,
    type
  });
  (0, _react.useEffect)(() => {
    if (initialSources && !openMetricSent) {
      trackPetnamesOpenEvent();
      setOpenMetricSent(true);
    }
  }, [initialSources, openMetricSent, trackPetnamesOpenEvent]);
  const handleSaveClick = (0, _react.useCallback)(async () => {
    trackPetnamesSaveEvent();
    await dispatch((0, _actions.setName)({
      value,
      type,
      name: name !== null && name !== void 0 && name.length ? name : null,
      sourceId: selectedSourceId,
      variation
    }));
    onClose();
  }, [name, selectedSourceId, onClose, trackPetnamesSaveEvent, variation]);
  const handleClose = (0, _react.useCallback)(() => {
    onClose();
  }, [onClose]);
  const handleNameChange = (0, _react.useCallback)(newName => {
    setName(newName);
    if (newName !== selectedSourceName) {
      setSelectedSourceId(undefined);
      setSelectedSourceName(undefined);
    }
  }, [setName, selectedSourceId, setSelectedSourceId, setSelectedSourceName]);
  const handleProposedNameClick = (0, _react.useCallback)(option => {
    setSelectedSourceId(option.sourceId);
    setSelectedSourceName(option.value);
  }, [setSelectedSourceId, setSelectedSourceName]);
  const handleCopyClick = (0, _react.useCallback)(() => {
    handleCopyAddress(formattedValue);
  }, [handleCopyAddress, formattedValue]);
  const getTitleAndInstructions = () => {
    let titleKey;
    let instructionsKey;
    switch (displayState) {
      case _useTrustSignals.TrustSignalDisplayState.Malicious:
        titleKey = 'nameModalTitleMalicious';
        instructionsKey = 'nameInstructionsMalicious';
        break;
      case _useTrustSignals.TrustSignalDisplayState.Warning:
        titleKey = 'nameModalTitleWarning';
        instructionsKey = 'nameInstructionsWarning';
        break;
      case _useTrustSignals.TrustSignalDisplayState.Verified:
        titleKey = 'nameModalTitleVerified';
        instructionsKey = '';
        break;
      case _useTrustSignals.TrustSignalDisplayState.Petname:
        titleKey = 'nameModalTitleSaved';
        instructionsKey = 'nameInstructionsSaved';
        break;
      case _useTrustSignals.TrustSignalDisplayState.Recognized:
        titleKey = 'nameModalTitleRecognized';
        instructionsKey = 'nameInstructionsRecognized';
        break;
      case _useTrustSignals.TrustSignalDisplayState.Unknown:
      default:
        titleKey = 'nameModalTitleNew';
        instructionsKey = 'nameInstructionsNew';
        break;
    }
    return {
      title: t(titleKey),
      instructions: instructionsKey ? t(instructionsKey) : ''
    };
  };
  const {
    title,
    instructions
  } = getTitleAndInstructions();
  const showFooterWarning = displayState === _useTrustSignals.TrustSignalDisplayState.Malicious || displayState === _useTrustSignals.TrustSignalDisplayState.Warning;
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: true,
    onClose: handleClose
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onClose: handleClose
  }, title), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, {
    className: "name-details__modal-body"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    marginBottom: 4,
    marginTop: 2,
    style: {
      textAlign: 'center'
    }
  }, /*#__PURE__*/_react.default.createElement(_nameDisplay.default, {
    value: value,
    type: type,
    variation: variation,
    showFullName: true
  }), subtitle && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "span",
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative,
    style: {
      marginLeft: 4
    }
  }, subtitle)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    marginBottom: 4,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, instructions), /*#__PURE__*/_react.default.createElement(_componentLibrary.FormTextField, {
    id: "address",
    className: "name-details__address",
    label: t('nameAddressLabel'),
    value: formattedValue,
    marginBottom: 4,
    disabled: true,
    endAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      display: _designSystem.Display.Flex,
      iconName: copiedAddress ? _componentLibrary.IconName.CopySuccess : _componentLibrary.IconName.Copy,
      size: _componentLibrary.ButtonIconSize.Sm,
      onClick: handleCopyClick,
      color: _designSystem.IconColor.iconMuted,
      ariaLabel: t('copyAddress')
    })
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Label, {
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.flexStart,
    marginBottom: 2,
    className: "name-details__display-name"
  }, t('nameLabel'), /*#__PURE__*/_react.default.createElement(_formComboField.default, {
    hideDropdownIfNoOptions: true,
    value: name,
    options: proposedNameOptions,
    placeholder: displayName && !hasSavedPetname ? t('nameSetPlaceholderSuggested', [displayName]) : t('nameSetPlaceholder'),
    onChange: handleNameChange,
    onOptionClick: handleProposedNameClick
  }))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalFooter, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    variant: _componentLibrary.ButtonVariant.Primary,
    startIconName: _componentLibrary.IconName.Save,
    width: _designSystem.BlockSize.Full
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    ,
    onClick: handleSaveClick,
    size: _componentLibrary.ButtonSize.Lg
  }, t('save')), showFooterWarning && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative,
    marginTop: 3,
    textAlign: _designSystem.TextAlign.Center
  }, t('nameFooterTrustWarning'))))));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\name\\name-details\\name-details.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\name\\name-details\\name-display.tsx", {"../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useDisplayName":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useDisplayName.ts","../../../../hooks/useTrustSignals":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTrustSignals.ts","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../ui/identicon":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\identicon\\index.js","../../preferred-avatar":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\preferred-avatar\\index.ts","./formatted-value":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\name\\name-details\\formatted-value.tsx","./shortened-name":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\name\\name-details\\shortened-name.tsx","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cname%5Cname-details%5Cname-display.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _designSystemReact = require("@metamask/design-system-react");
var _classnames = _interopRequireDefault(require("classnames"));
var _identicon = _interopRequireDefault(require("../../../ui/identicon"));
var _componentLibrary = require("../../../component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _useDisplayName = require("../../../../hooks/useDisplayName");
var _useTrustSignals = require("../../../../hooks/useTrustSignals");
var _preferredAvatar = require("../../preferred-avatar");
var _shortenedName = _interopRequireDefault(require("./shortened-name"));
var _formattedValue = _interopRequireDefault(require("./formatted-value"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const NameDisplay = /*#__PURE__*/(0, _react.memo)(({
  value,
  type,
  preferContractSymbol,
  variation,
  handleClick,
  showFullName = false,
  ...props
}) => {
  const {
    name,
    image,
    icon,
    displayState,
    isAccount
  } = (0, _useDisplayName.useDisplayName)({
    value,
    type,
    preferContractSymbol,
    variation
  });
  const renderIcon = () => {
    // If icon exists, use it (trust signal /unknown)
    if (icon) {
      return /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
        name: icon.name,
        className: "name__icon",
        size: _componentLibrary.IconSize.Sm,
        color: icon.color
      });
    }
    if (image) {
      return /*#__PURE__*/_react.default.createElement(_identicon.default, {
        address: value,
        diameter: 16,
        image: image
      });
    }
    return /*#__PURE__*/_react.default.createElement(_preferredAvatar.PreferredAvatar, {
      className: "rounded-md",
      address: value,
      size: _designSystemReact.AvatarAccountSize.Xs
    });
  };
  const renderName = () => {
    if (!name) {
      return /*#__PURE__*/_react.default.createElement(_formattedValue.default, _extends({
        value: value,
        type: type
      }, props));
    }
    if (showFullName) {
      return /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, _extends({
        className: "name__name",
        variant: _designSystem.TextVariant.bodyMd
      }, props), name);
    }
    return /*#__PURE__*/_react.default.createElement(_shortenedName.default, _extends({
      name: name
    }, props));
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)({
      name: true,
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      name__clickable: Boolean(handleClick) && !isAccount,
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      name__saved: displayState === _useTrustSignals.TrustSignalDisplayState.Petname,
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      name__recognized_unsaved: displayState === _useTrustSignals.TrustSignalDisplayState.Recognized,
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      name__missing: displayState === _useTrustSignals.TrustSignalDisplayState.Unknown,
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      name__malicious: displayState === _useTrustSignals.TrustSignalDisplayState.Malicious,
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      name__verified: displayState === _useTrustSignals.TrustSignalDisplayState.Verified,
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      name__warning: displayState === _useTrustSignals.TrustSignalDisplayState.Warning
    }),
    onClick: handleClick
  }, renderIcon(), renderName());
});
var _default = exports.default = NameDisplay;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\name\\name-details\\name-display.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\name\\name-details\\shortened-name.tsx", {"../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cname%5Cname-details%5Cshortened-name.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _componentLibrary = require("../../../component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _util = require("../../../../helpers/utils/util");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const MAX_PET_NAME_LENGTH = 12;
const ShortenedName = /*#__PURE__*/(0, _react.memo)(({
  name,
  ...props
}) => {
  const shortenedName = (0, _util.shortenString)(name || '', {
    truncatedCharLimit: MAX_PET_NAME_LENGTH,
    truncatedStartChars: MAX_PET_NAME_LENGTH - 3,
    truncatedEndChars: 0,
    skipCharacterInEnd: true
  });
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, _extends({
    className: "name__name",
    variant: _designSystem.TextVariant.bodyMd
  }, props), shortenedName);
});
var _default = exports.default = ShortenedName;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\name\\name-details\\shortened-name.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\name\\name.tsx", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useDisplayName":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useDisplayName.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","./name-details/name-details":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\name\\name-details\\name-details.tsx","./name-details/name-display":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\name\\name-details\\name-display.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cname%5Cname.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _componentLibrary = require("../../component-library");
var _metametrics = require("../../../contexts/metametrics");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _designSystem = require("../../../helpers/constants/design-system");
var _useDisplayName = require("../../../hooks/useDisplayName");
var _nameDisplay = _interopRequireDefault(require("./name-details/name-display"));
var _nameDetails = _interopRequireDefault(require("./name-details/name-details"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const Name = /*#__PURE__*/(0, _react.memo)(({
  value,
  type,
  preferContractSymbol = false,
  variation,
  ...props
}) => {
  const [modalOpen, setModalOpen] = (0, _react.useState)(false);
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const {
    name,
    subtitle,
    isAccount
  } = (0, _useDisplayName.useDisplayName)({
    value,
    type,
    preferContractSymbol,
    variation
  });
  (0, _react.useEffect)(() => {
    trackEvent({
      event: _metametrics2.MetaMetricsEventName.PetnameDisplayed,
      category: _metametrics2.MetaMetricsEventCategory.Petnames,
      properties: {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        petname_category: type,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        has_petname: Boolean(name === null || name === void 0 ? void 0 : name.length)
      }
    });
    // using `[]` as we only want to call `trackEvent` on the initial render
  }, []);
  const handleClick = (0, _react.useCallback)(() => {
    if (isAccount) {
      return;
    }
    setModalOpen(true);
  }, [isAccount, setModalOpen]);
  const handleModalClose = (0, _react.useCallback)(() => {
    setModalOpen(false);
  }, [setModalOpen]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column
  }, modalOpen && /*#__PURE__*/_react.default.createElement(_nameDetails.default, {
    value: value,
    type: type,
    variation: variation,
    onClose: handleModalClose
  }), /*#__PURE__*/_react.default.createElement(_nameDisplay.default, _extends({
    value: value,
    type: type,
    preferContractSymbol: preferContractSymbol,
    variation: variation,
    handleClick: handleClick
  }, props)), subtitle && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative,
    style: {
      textAlign: 'right'
    }
  }, subtitle));
});
var _default = exports.default = Name;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\name\\name.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\network-account-balance-header\\network-account-balance-header.js", {"../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/box/box":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\box\\box.js","../../ui/icon-with-fallback":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\icon-with-fallback\\index.js","../../ui/identicon":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\identicon\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cnetwork-account-balance-header%5Cnetwork-account-balance-header.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = NetworkAccountBalanceHeader;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _iconWithFallback = _interopRequireDefault(require("../../ui/icon-with-fallback"));
var _identicon = _interopRequireDefault(require("../../ui/identicon"));
var _designSystem = require("../../../helpers/constants/design-system");
var _box = _interopRequireDefault(require("../../ui/box/box"));
var _i18n = require("../../../contexts/i18n");
var _network = require("../../../../shared/constants/network");
var _componentLibrary = require("../../component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function NetworkAccountBalanceHeader({
  networkName,
  accountName,
  accountBalance,
  tokenName,
  // Derived from nativeCurrency
  accountAddress,
  chainId
}) {
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const networkIcon = _network.CHAIN_ID_TO_NETWORK_IMAGE_URL_MAP[chainId];
  const networkIconWrapperClass = networkIcon ? 'network-account-balance-header__network-account__ident-icon-ethereum' : 'network-account-balance-header__network-account__ident-icon-ethereum--gray';
  return /*#__PURE__*/_react.default.createElement(_box.default, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    padding: 4,
    className: "network-account-balance-header",
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, /*#__PURE__*/_react.default.createElement(_box.default, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    alignItems: _designSystem.AlignItems.center,
    gap: 2
  }, /*#__PURE__*/_react.default.createElement(_box.default, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_identicon.default, {
    address: accountAddress,
    diameter: 32
  }), /*#__PURE__*/_react.default.createElement(_iconWithFallback.default, {
    name: networkName,
    size: 16,
    icon: networkIcon,
    wrapperClassName: networkIconWrapperClass
  })), /*#__PURE__*/_react.default.createElement(_box.default, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.flexStart,
    flexDirection: _designSystem.FlexDirection.Column
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    as: "h6",
    color: _designSystem.TextColor.textAlternative,
    "data-testid": "signature-request-network-display"
  }, networkName), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    as: "h6",
    color: _designSystem.TextColor.textDefault,
    fontWeight: _designSystem.FontWeight.Bold
  }, accountName))), /*#__PURE__*/_react.default.createElement(_box.default, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.flexEnd,
    flexDirection: _designSystem.FlexDirection.Column
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    as: "h6",
    color: _designSystem.TextColor.textAlternative
  }, t('balance')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    as: "h6",
    color: _designSystem.TextColor.textDefault,
    fontWeight: _designSystem.FontWeight.Bold,
    align: _designSystem.TextAlign.End
  }, accountBalance, " ", tokenName)));
}
NetworkAccountBalanceHeader.propTypes = {
  networkName: _propTypes.default.string,
  accountName: _propTypes.default.string,
  accountBalance: _propTypes.default.string,
  tokenName: _propTypes.default.string,
  accountAddress: _propTypes.default.string,
  chainId: _propTypes.default.string
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\network-account-balance-header\\network-account-balance-header.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\network-connection-banner\\index.ts", {"./network-connection-banner":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\network-connection-banner\\network-connection-banner.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cnetwork-connection-banner%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "NetworkConnectionBanner", {
  enumerable: true,
  get: function () {
    return _networkConnectionBanner.NetworkConnectionBanner;
  }
});
var _networkConnectionBanner = require("./network-connection-banner");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\network-connection-banner\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\network-connection-banner\\network-connection-banner.tsx", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../hooks/useNetworkConnectionBanner":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useNetworkConnectionBanner.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../component-library/text":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\text\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cnetwork-connection-banner%5Cnetwork-connection-banner.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.NetworkConnectionBanner = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _reactRedux = require("react-redux");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _text = require("../../component-library/text");
var _useNetworkConnectionBanner = require("../../../hooks/useNetworkConnectionBanner");
var _routes = require("../../../helpers/constants/routes");
var _actions = require("../../../store/actions");
var _metametrics = require("../../../../shared/constants/metametrics");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PrimaryMessage = ({
  t,
  primaryMessageKey,
  networkConnectionBanner
}) => {
  return /*#__PURE__*/_react.default.createElement(_text.Text, {
    variant: _designSystem.TextVariant.bodyXsMedium,
    style: {
      display: 'inline-block',
      verticalAlign: 'middle',
      paddingRight: '4px'
    }
  }, t(primaryMessageKey, [networkConnectionBanner.networkName]));
};
const SecondaryMessage = ({
  content
}) => {
  return /*#__PURE__*/_react.default.createElement(_text.Text, {
    variant: _designSystem.TextVariant.bodyXsMedium,
    style: {
      display: 'inline-block',
      verticalAlign: 'middle'
    }
  }, content);
};
const UpdateRpcButton = ({
  t,
  isLowerCase,
  updateRpc
}) => {
  const updateRpcText = t('updateRpc');
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    key: "updateRpc",
    size: _componentLibrary.ButtonLinkSize.Auto,
    variant: _designSystem.TextVariant.bodyXsMedium,
    onClick: updateRpc,
    paddingTop: 0,
    paddingBottom: 0,
    style: {
      verticalAlign: 'bottom'
    }
  }, isLowerCase ? updateRpcText[0].toLowerCase() + updateRpcText.slice(1) : updateRpcText);
};
const getBannerContent = (networkConnectionBanner, t, updateRpc) => {
  // Align the indicator with the text
  const verticalAdjustment = '0.25em';
  if (networkConnectionBanner.status === 'degraded') {
    const primaryMessage = /*#__PURE__*/_react.default.createElement(PrimaryMessage, {
      t: t,
      primaryMessageKey: "stillConnectingTo",
      networkConnectionBanner: networkConnectionBanner
    });
    const secondaryMessage = networkConnectionBanner.isInfuraEndpoint ? null : /*#__PURE__*/_react.default.createElement(SecondaryMessage, {
      content: /*#__PURE__*/_react.default.createElement(UpdateRpcButton, {
        t: t,
        isLowerCase: false,
        updateRpc: updateRpc
      })
    });
    return {
      primaryMessage,
      secondaryMessage,
      backgroundColor: _designSystem.BackgroundColor.backgroundSection,
      icon: {
        color: _designSystem.IconColor.iconDefault,
        name: _componentLibrary.IconName.Loading,
        verticalAdjustment,
        className: 'animate-spin'
      }
    };
  }
  const primaryMessage = /*#__PURE__*/_react.default.createElement(PrimaryMessage, {
    t: t,
    primaryMessageKey: "unableToConnectTo",
    networkConnectionBanner: networkConnectionBanner
  });
  const secondaryMessageContent = networkConnectionBanner.isInfuraEndpoint ? t('checkNetworkConnectivity') : t('checkNetworkConnectivityOr', [/*#__PURE__*/_react.default.createElement(UpdateRpcButton, {
    key: "updateRpc",
    t: t,
    isLowerCase: true,
    updateRpc: updateRpc
  })]);
  const secondaryMessage = /*#__PURE__*/_react.default.createElement(SecondaryMessage, {
    content: secondaryMessageContent
  });
  return {
    primaryMessage,
    secondaryMessage,
    backgroundColor: _designSystem.BackgroundColor.errorMuted,
    icon: {
      color: _designSystem.IconColor.errorDefault,
      name: _componentLibrary.IconName.Danger,
      verticalAdjustment
    }
  };
};
const NetworkConnectionBanner = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  const navigate = (0, _reactRouterDomV5Compat.useNavigate)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const networkConnectionBanner = (0, _useNetworkConnectionBanner.useNetworkConnectionBanner)();
  const updateRpc = (0, _react.useCallback)(() => {
    if (networkConnectionBanner.status === 'degraded' || networkConnectionBanner.status === 'unavailable') {
      networkConnectionBanner.trackNetworkBannerEvent({
        bannerType: networkConnectionBanner.status,
        eventName: _metametrics.MetaMetricsEventName.NetworkConnectionBannerUpdateRpcClicked,
        networkClientId: networkConnectionBanner.networkClientId
      });
      dispatch((0, _actions.setEditedNetwork)({
        chainId: networkConnectionBanner.chainId
      }));
      navigate(_routes.NETWORKS_ROUTE);
    }
  }, [networkConnectionBanner, dispatch, navigate]);
  if (networkConnectionBanner.status === 'degraded' || networkConnectionBanner.status === 'unavailable') {
    const {
      primaryMessage,
      secondaryMessage,
      backgroundColor,
      icon
    } = getBannerContent(networkConnectionBanner, t, updateRpc);
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      width: _designSystem.BlockSize.Full,
      paddingLeft: 4,
      paddingRight: 4,
      paddingTop: 4
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerBase, {
      className: "network-connection-banner",
      backgroundColor: backgroundColor,
      startAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
        name: icon.name,
        size: _componentLibrary.IconSize.Sm,
        color: icon.color,
        className: icon.className,
        style: {
          marginTop: icon.verticalAdjustment
        },
        "data-testid": "icon"
      }),
      borderRadius: _designSystem.BorderRadius.MD
    }, primaryMessage, secondaryMessage));
  }
  return null;
};
exports.NetworkConnectionBanner = NetworkConnectionBanner;
var _default = exports.default = NetworkConnectionBanner;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\network-connection-banner\\network-connection-banner.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\network-display\\index.js", {"./network-display":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\network-display\\network-display.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cnetwork-display%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _networkDisplay.default;
  }
});
var _networkDisplay = _interopRequireDefault(require("./network-display"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\network-display\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\network-display\\network-display.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cnetwork-display%5Cnetwork-display.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = NetworkDisplay;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _designSystem = require("../../../helpers/constants/design-system");
var _selectors = require("../../../selectors");
var _componentLibrary = require("../../component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function NetworkDisplay() {
  var _currentNetwork$rpcPr;
  const currentNetwork = (0, _reactRedux.useSelector)(_selectors.getCurrentNetwork);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.PickerNetwork, {
    className: "network-display",
    label: currentNetwork === null || currentNetwork === void 0 ? void 0 : currentNetwork.nickname,
    labelProps: {
      'data-testid': 'network-display'
    },
    src: currentNetwork === null || currentNetwork === void 0 || (_currentNetwork$rpcPr = currentNetwork.rpcPrefs) === null || _currentNetwork$rpcPr === void 0 ? void 0 : _currentNetwork$rpcPr.imageUrl,
    iconProps: {
      display: 'none'
    } // do not show the dropdown icon
    ,
    avatarNetworkProps: {
      size: _componentLibrary.AvatarNetworkSize.Xs
    },
    as: "div" // do not render as a button
    ,
    backgroundColor: _designSystem.BackgroundColor.transparent,
    borderWidth: 0,
    borderColor: _designSystem.BorderColor.borderMuted
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\network-display\\network-display.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\password-form\\password-form.tsx", {"../../../helpers/constants/common":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\common.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cpassword-form%5Cpassword-form.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = PasswordForm;
var _react = _interopRequireWildcard(require("react"));
var _componentLibrary = require("../../component-library");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _common = require("../../../helpers/constants/common");
var _designSystem = require("../../../helpers/constants/design-system");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function PasswordForm({
  onChange,
  pwdInputTestId,
  confirmPwdInputTestId
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  const [password, setPassword] = (0, _react.useState)('');
  const [showPassword, setShowPassword] = (0, _react.useState)(false);
  const [confirmPassword, setConfirmPassword] = (0, _react.useState)('');
  const [showConfirmPassword, setShowConfirmPassword] = (0, _react.useState)(false);
  const [confirmPasswordError, setConfirmPasswordError] = (0, _react.useState)('');
  const [passwordLengthError, setPasswordLengthError] = (0, _react.useState)(false);
  const handlePasswordChange = (0, _react.useCallback)(passwordInput => {
    const confirmError = !confirmPassword || passwordInput === confirmPassword ? '' : t('passwordsDontMatch');
    setPassword(passwordInput);
    setConfirmPasswordError(confirmError);
    setPasswordLengthError(false);
  }, [confirmPassword, t]);
  const handleConfirmPasswordChange = (0, _react.useCallback)(confirmPasswordInput => {
    const error = password === confirmPasswordInput || confirmPasswordInput.length === 0 ? '' : t('passwordsDontMatch');
    setConfirmPassword(confirmPasswordInput);
    setConfirmPasswordError(error);
  }, [password, t]);
  (0, _react.useEffect)(() => {
    if (password.length >= _common.PASSWORD_MIN_LENGTH && confirmPassword.length >= _common.PASSWORD_MIN_LENGTH && password === confirmPassword) {
      onChange(password);
    } else {
      onChange('');
    }
  }, [password, confirmPassword, onChange]);
  const handlePasswordBlur = (0, _react.useCallback)(() => {
    if (password.length < _common.PASSWORD_MIN_LENGTH) {
      setPasswordLengthError(true);
    } else {
      setPasswordLengthError(false);
    }
  }, [password.length]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.FormTextField, {
    label: t('newPasswordCreate'),
    id: "create-password-new",
    autoFocus: true,
    autoComplete: true,
    size: _componentLibrary.FormTextFieldSize.Lg,
    value: password,
    inputProps: {
      'data-testid': pwdInputTestId || 'create-password-new-input',
      type: showPassword ? _componentLibrary.InputType.Text : _componentLibrary.InputType.Password
    },
    onChange: e => {
      handlePasswordChange(e.target.value);
    },
    helpTextProps: {
      color: _designSystem.TextColor.textAlternative,
      'data-testid': 'short-password-error'
    },
    helpText: t('passwordNotLongEnough'),
    onBlur: handlePasswordBlur,
    error: passwordLengthError,
    endAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      iconName: showPassword ? _componentLibrary.IconName.EyeSlash : _componentLibrary.IconName.Eye,
      "data-testid": "show-password",
      type: "button",
      onClick: e => {
        e.stopPropagation();
        setShowPassword(!showPassword);
      },
      ariaLabel: showPassword ? t('passwordToggleHide') : t('passwordToggleShow')
    })
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.FormTextField, {
    label: t('confirmPassword'),
    id: "create-password-confirm",
    autoComplete: true,
    marginTop: 4,
    size: _componentLibrary.FormTextFieldSize.Lg,
    error: Boolean(confirmPasswordError),
    helpTextProps: {
      'data-testid': 'confirm-password-error'
    },
    helpText: confirmPasswordError,
    value: confirmPassword,
    inputProps: {
      'data-testid': confirmPwdInputTestId || 'create-password-confirm-input',
      type: showConfirmPassword ? _componentLibrary.InputType.Text : _componentLibrary.InputType.Password
    },
    onChange: e => {
      handleConfirmPasswordChange(e.target.value);
    },
    endAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      iconName: showConfirmPassword ? _componentLibrary.IconName.EyeSlash : _componentLibrary.IconName.Eye,
      "data-testid": "show-confirm-password",
      type: "button",
      onClick: e => {
        e.stopPropagation();
        setShowConfirmPassword(!showConfirmPassword);
      },
      ariaLabel: showConfirmPassword ? t('passwordToggleHide') : t('passwordToggleShow')
    })
  }));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\password-form\\password-form.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\password-outdated-modal\\index.ts", {"./password-outdated-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\password-outdated-modal\\password-outdated-modal.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cpassword-outdated-modal%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _passwordOutdatedModal.default;
  }
});
var _passwordOutdatedModal = _interopRequireDefault(require("./password-outdated-modal"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\password-outdated-modal\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\password-outdated-modal\\password-outdated-modal.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../toast-master/utils":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\toast-master\\utils.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cpassword-outdated-modal%5Cpassword-outdated-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = PasswordOutdatedModal;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../component-library");
var _routes = require("../../../helpers/constants/routes");
var _actions = require("../../../store/actions");
var _utils = require("../toast-master/utils");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function PasswordOutdatedModal() {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const history = (0, _reactRouterDom.useHistory)();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: true,
    onClose: () => undefined,
    "data-testid": "password-outdated-modal"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, {
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.Danger,
    size: _componentLibrary.IconSize.Xl,
    color: _designSystem.IconColor.warningDefault
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingMd,
    textAlign: _designSystem.TextAlign.Center,
    marginTop: 4
  }, t('passwordChangedRecently')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    marginTop: 4
  }, t('passwordChangedRecentlyDescription')))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 4,
    paddingRight: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    marginTop: 2,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    "data-testid": "password-changed",
    size: _componentLibrary.ButtonSize.Lg,
    block: true,
    onClick: async () => {
      // remove the password change toast from the app state
      await dispatch((0, _utils.setShowPasswordChangeToast)(null));
      await dispatch((0, _actions.lockMetamask)());
      history.push(_routes.DEFAULT_ROUTE);
    }
  }, t('continue'))))));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\password-outdated-modal\\password-outdated-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\permission-cell\\index.js", {"./permission-cell":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\permission-cell\\permission-cell.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cpermission-cell%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _permissionCell.default;
  }
});
var _permissionCell = _interopRequireDefault(require("./permission-cell"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\permission-cell\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\permission-cell\\permission-cell-options.js", {"../../../../shared/constants/snaps/permissions":"D:\\code\\v\\metamask-extension\\shared\\constants\\snaps\\permissions.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/box":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\box\\index.js","../../ui/menu":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\menu\\index.ts","../../ui/popover/popover.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\popover\\popover.component.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cpermission-cell%5Cpermission-cell-options.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PermissionCellOptions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRedux = require("react-redux");
var _box = _interopRequireDefault(require("../../ui/box"));
var _useI18nContext = require("../../../hooks/useI18nContext");
var _componentLibrary = require("../../component-library");
var _menu = require("../../ui/menu");
var _designSystem = require("../../../helpers/constants/design-system");
var _popover = _interopRequireDefault(require("../../ui/popover/popover.component"));
var _permissions = require("../../../../shared/constants/snaps/permissions");
var _actions = require("../../../store/actions");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PermissionCellOptions = ({
  snapId,
  permissionName,
  description
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const ref = (0, _react.useRef)(false);
  const [showOptions, setShowOptions] = (0, _react.useState)(false);
  const [showDetails, setShowDetails] = (0, _react.useState)(false);
  const isRevokable = _permissions.DynamicSnapPermissions.includes(permissionName);
  const handleOpen = () => {
    setShowOptions(true);
  };
  const handleClose = () => {
    setShowOptions(false);
  };
  const handleDetailsOpen = () => {
    setShowOptions(false);
    setShowDetails(true);
  };
  const handleDetailsClose = () => {
    setShowOptions(false);
    setShowDetails(false);
  };
  const handleRevokePermission = () => {
    setShowOptions(false);
    dispatch((0, _actions.revokeDynamicSnapPermissions)(snapId, [permissionName]));
  };
  if (!description && !isRevokable) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_box.default, {
    ref: ref
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    iconName: _componentLibrary.IconName.MoreVertical,
    ariaLabel: t('options'),
    onClick: handleOpen,
    "data-testid": permissionName
  }), showOptions && /*#__PURE__*/_react.default.createElement(_menu.Menu, {
    anchorElement: ref.current,
    onHide: handleClose
  }, description && /*#__PURE__*/_react.default.createElement(_menu.MenuItem, {
    onClick: handleDetailsOpen
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    style: {
      whiteSpace: 'nowrap'
    }
  }, t('details'))), isRevokable && /*#__PURE__*/_react.default.createElement(_menu.MenuItem, {
    onClick: handleRevokePermission
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.errorDefault,
    style: {
      whiteSpace: 'nowrap'
    }
  }, t('revokePermission')))), showDetails && /*#__PURE__*/_react.default.createElement(_popover.default, {
    title: t('details'),
    onClose: handleDetailsClose
  }, /*#__PURE__*/_react.default.createElement(_box.default, {
    marginLeft: 4,
    marginRight: 4,
    marginBottom: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, null, description))));
};
exports.PermissionCellOptions = PermissionCellOptions;
PermissionCellOptions.propTypes = {
  snapId: _propTypes.default.string.isRequired,
  permissionName: _propTypes.default.string.isRequired,
  description: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.object])
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\permission-cell\\permission-cell-options.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\permission-cell\\permission-cell-status.js", {"../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../multichain/avatar-group":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\avatar-group\\index.ts","../../multichain/avatar-group/avatar-group.types":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\avatar-group\\avatar-group.types.tsx","../../ui/tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\index.js","../preferred-avatar":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\preferred-avatar\\index.ts","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cpermission-cell%5Cpermission-cell-status.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PermissionCellStatus = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _designSystemReact = require("@metamask/design-system-react");
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _tooltip = _interopRequireDefault(require("../../ui/tooltip"));
var _avatarGroup = require("../../multichain/avatar-group");
var _avatarGroup2 = require("../../multichain/avatar-group/avatar-group.types");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _util = require("../../../helpers/utils/util");
var _network = require("../../../../shared/constants/network");
var _preferredAvatar = require("../preferred-avatar");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * Renders status of the given permission. Used by PermissionCell component.
 *
 * @param props - The props.
 * @param props.revoked - Boolean value to identify if permission is being revoked.
 * @param props.dateApproved - Timestamp when permission is approved.
 * @param props.accounts - List of accounts for which permission is requested, approved or revoked.
 * @param props.approved - Boolean value in case a permission has been approved, but there is no date to show.
 * @param props.networks
 * @returns React element rendering permission status with or without account icons displayed as AvatarGroup.
 */
const PermissionCellStatus = ({
  revoked,
  approved,
  dateApproved,
  accounts,
  networks
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const renderAccountsGroup = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, networks.length > 0 ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    as: "span",
    className: "permission-cell__status__accounts-group-box",
    display: _designSystem.Display.InlineFlex
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column
  }, networks === null || networks === void 0 ? void 0 : networks.map((network, index) => /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    key: `${network.name}_${index}`,
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.flexStart,
    alignItems: _designSystem.AlignItems.center,
    marginTop: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
    size: _componentLibrary.AvatarNetworkSize.Xs,
    src: _network.CHAIN_ID_TO_NETWORK_IMAGE_URL_MAP[network.chainId],
    name: network.name
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    marginLeft: 2
  }, network.name))))) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    as: "span",
    className: "permission-cell__status__accounts-group-box",
    display: _designSystem.Display.InlineFlex
  }, /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    position: "bottom",
    html: /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      justifyContent: _designSystem.JustifyContent.center,
      alignItems: _designSystem.AlignItems.center
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.headingSm,
      color: _designSystem.TextColor.textAlternative,
      textAlign: _designSystem.TextAlign.Center
    }, t('accounts')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column
    }, accounts.map((account, index) => /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      key: `${account.avatarValue}_${index}`,
      display: _designSystem.Display.Flex,
      justifyContent: _designSystem.JustifyContent.flexStart,
      alignItems: _designSystem.AlignItems.center,
      marginTop: 2
    }, /*#__PURE__*/_react.default.createElement(_preferredAvatar.PreferredAvatar, {
      address: account.avatarValue,
      size: _designSystemReact.AvatarAccountSize.Xs
    }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMdMedium,
      marginLeft: 2
    }, account.avatarName)))))
  }, /*#__PURE__*/_react.default.createElement(_avatarGroup.AvatarGroup, {
    limit: 3,
    members: accounts,
    avatarType: _avatarGroup2.AvatarType.ACCOUNT,
    size: _componentLibrary.AvatarTokenSize.Xs,
    width: _designSystem.BlockSize.Min,
    borderColor: _designSystem.BorderColor.backgroundDefault,
    marginLeft: 4,
    paddingLeft: 4
  }))));
  const getStatusMessage = () => {
    if (revoked) {
      return accounts && accounts.length ? t('permissionRevokedForAccounts', [renderAccountsGroup()]) : t('permissionRevoked');
    }
    if (dateApproved) {
      return accounts && accounts.length ? t('approvedOnForAccounts', [(0, _util.formatDate)(dateApproved, 'yyyy-MM-dd'), renderAccountsGroup()]) : t('approvedOn', [(0, _util.formatDate)(dateApproved, 'yyyy-MM-dd')]);
    }
    if (approved) {
      return t('approved');
    }
    return accounts && accounts.length ? t('permissionRequestedForAccounts', [renderAccountsGroup()]) : t('permissionRequested');
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "div",
    className: "permission-cell__status",
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative,
    display: _designSystem.Display.Flex
  }, getStatusMessage());
};
exports.PermissionCellStatus = PermissionCellStatus;
PermissionCellStatus.propTypes = {
  revoked: _propTypes.default.bool,
  approved: _propTypes.default.bool,
  dateApproved: _propTypes.default.number,
  accounts: _propTypes.default.array,
  networks: _propTypes.default.array
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\permission-cell\\permission-cell-status.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\permission-cell\\permission-cell.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\index.js","./permission-cell-options":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\permission-cell\\permission-cell-options.js","./permission-cell-status":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\permission-cell\\permission-cell-status.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cpermission-cell%5Cpermission-cell.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _reactRedux = require("react-redux");
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../component-library");
var _tooltip = _interopRequireDefault(require("../../ui/tooltip"));
var _selectors = require("../../../selectors");
var _permissionCellOptions = require("./permission-cell-options");
var _permissionCellStatus = require("./permission-cell-status");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const PermissionCell = ({
  snapId,
  permissionName,
  title,
  description,
  weight,
  avatarIcon,
  dateApproved,
  revoked,
  approved,
  showOptions,
  hideStatus,
  accounts,
  chainIds
}) => {
  var _avatarIcon$props;
  const infoIcon = _componentLibrary.IconName.Info;
  let infoIconColor = _designSystem.IconColor.iconMuted;
  let iconColor = _designSystem.IconColor.primaryDefault;
  let iconBackgroundColor = _designSystem.Color.primaryMuted;
  if (!revoked && weight <= 2) {
    iconColor = _designSystem.IconColor.warningDefault;
    iconBackgroundColor = _designSystem.Color.warningMuted;
    infoIconColor = _designSystem.IconColor.warningDefault;
  }
  if (dateApproved || approved) {
    iconColor = _designSystem.IconColor.iconMuted;
    iconBackgroundColor = _designSystem.Color.backgroundAlternative;
  }
  if (revoked) {
    iconColor = _designSystem.IconColor.iconMuted;
    iconBackgroundColor = _designSystem.Color.backgroundAlternative;
  }
  let permissionIcon = avatarIcon;
  if (typeof avatarIcon !== 'string' && avatarIcon !== null && avatarIcon !== void 0 && (_avatarIcon$props = avatarIcon.props) !== null && _avatarIcon$props !== void 0 && _avatarIcon$props.iconName) {
    permissionIcon = avatarIcon.props.iconName;
  }
  const networksInfo = (0, _reactRedux.useSelector)(state => (0, _selectors.getRequestingNetworkInfo)(state, chainIds));
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "permission-cell",
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.flexStart,
    paddingTop: 2,
    paddingBottom: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex
  }, typeof permissionIcon === 'string' ? /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarIcon, {
    iconName: permissionIcon,
    size: _componentLibrary.AvatarIconSize.Md,
    iconProps: {
      size: _componentLibrary.IconSize.Sm
    },
    color: iconColor,
    backgroundColor: iconBackgroundColor
  }) : permissionIcon), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexWrap: _designSystem.FlexWrap.Wrap,
    flexDirection: _designSystem.FlexDirection.Column,
    width: _designSystem.BlockSize.Full,
    marginLeft: 4,
    marginRight: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    size: _designSystem.Size.MD,
    variant: _designSystem.TextVariant.bodyMd,
    className: (0, _classnames.default)('permission-cell__title', {
      'permission-cell__title-revoked': revoked
    })
  }, title), !hideStatus && /*#__PURE__*/_react.default.createElement(_permissionCellStatus.PermissionCellStatus, {
    revoked: revoked,
    approved: approved,
    dateApproved: dateApproved,
    accounts: accounts,
    networks: networksInfo || null
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex
  }, showOptions && snapId ? /*#__PURE__*/_react.default.createElement(_permissionCellOptions.PermissionCellOptions, {
    snapId: snapId,
    permissionName: permissionName,
    description: description
  }) : description && /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    html: /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodySm,
      color: _designSystem.TextColor.textAlternative
    }, description),
    position: "bottom"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    color: infoIconColor,
    name: infoIcon,
    size: _componentLibrary.IconSize.Sm
  }))));
};
PermissionCell.propTypes = {
  snapId: _propTypes.default.string,
  permissionName: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.element]).isRequired,
  title: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.object.isRequired]),
  description: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.object]),
  weight: _propTypes.default.number,
  avatarIcon: _propTypes.default.any.isRequired,
  dateApproved: _propTypes.default.number,
  revoked: _propTypes.default.bool,
  approved: _propTypes.default.bool,
  showOptions: _propTypes.default.bool,
  hideStatus: _propTypes.default.bool,
  accounts: _propTypes.default.array,
  chainIds: _propTypes.default.array
};
var _default = exports.default = PermissionCell;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\permission-cell\\permission-cell.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\permission-connect-header\\index.js", {"./permission-connect-header":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\permission-connect-header\\permission-connect-header.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cpermission-connect-header%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _permissionConnectHeader.default;
  }
});
var _permissionConnectHeader = _interopRequireDefault(require("./permission-connect-header"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\permission-connect-header\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\permission-connect-header\\permission-connect-header.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../pages/confirmations/components/confirm/nav":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\nav\\index.tsx","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cpermission-connect-header%5Cpermission-connect-header.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../component-library");
var _util = require("../../../helpers/utils/util");
var _nav = require("../../../pages/confirmations/components/confirm/nav");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const PermissionConnectHeader = ({
  requestId,
  origin,
  iconUrl
}) => {
  const transformOriginToTitle = rawOrigin => {
    try {
      const url = new URL(rawOrigin);
      return url.hostname;
    } catch (e) {
      return 'Unknown Origin';
    }
  };
  const title = transformOriginToTitle(origin);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_nav.Nav, {
    confirmationId: requestId
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    width: _designSystem.BlockSize.Full,
    alignItems: _designSystem.AlignItems.center,
    display: _designSystem.Display.Flex,
    padding: 4,
    style: {
      boxShadow: 'var(--shadow-size-lg) var(--color-shadow-default)'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, iconUrl ? /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarFavicon, {
    backgroundColor: _designSystem.BackgroundColor.backgroundAlternative,
    size: _componentLibrary.IconSize.Lg,
    src: iconUrl,
    name: title
  }) : /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarBase, {
    size: _componentLibrary.IconSize.Lg,
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    color: _designSystem.TextColor.textAlternative,
    style: {
      borderWidth: '0px'
    },
    backgroundColor: _designSystem.BackgroundColor.backgroundAlternative
  }, (0, _util.getAvatarFallbackLetter)(title))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginLeft: 4,
    marginRight: 4,
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    style: {
      overflow: 'hidden'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    ellipsis: true,
    fontWeight: _designSystem.FontWeight.Medium
  }, title), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    ellipsis: true,
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative
  }, origin))));
};
PermissionConnectHeader.propTypes = {
  requestId: _propTypes.default.string,
  origin: _propTypes.default.string,
  iconUrl: _propTypes.default.string
};
var _default = exports.default = PermissionConnectHeader;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\permission-connect-header\\permission-connect-header.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\permission-page-container\\index.js", {"./permission-page-container-content":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\permission-page-container\\permission-page-container-content\\index.js","./permission-page-container.container":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\permission-page-container\\permission-page-container.container.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cpermission-page-container%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "PermissionPageContainerContent", {
  enumerable: true,
  get: function () {
    return _permissionPageContainerContent.default;
  }
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _permissionPageContainer.default;
  }
});
var _permissionPageContainer = _interopRequireDefault(require("./permission-page-container.container"));
var _permissionPageContainerContent = _interopRequireDefault(require("./permission-page-container-content"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\permission-page-container\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\permission-page-container\\permission-page-container-content\\index.js", {"./permission-page-container-content.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\permission-page-container\\permission-page-container-content\\permission-page-container-content.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cpermission-page-container%5Cpermission-page-container-content%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _permissionPageContainerContent.default;
  }
});
var _permissionPageContainerContent = _interopRequireDefault(require("./permission-page-container-content.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\permission-page-container\\permission-page-container-content\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\permission-page-container\\permission-page-container-content\\permission-page-container-content.component.js", {"../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../permissions-connect-permission-list":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\permissions-connect-permission-list\\index.js","@metamask/chain-agnostic-permission":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\chain-agnostic-permission\\dist\\index.cjs","@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cpermission-page-container%5Cpermission-page-container-content%5Cpermission-page-container-content.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _permissionController = require("@metamask/permission-controller");
var _chainAgnosticPermission = require("@metamask/chain-agnostic-permission");
var _permissionsConnectPermissionList = _interopRequireDefault(require("../../permissions-connect-permission-list"));
var _designSystem = require("../../../../helpers/constants/design-system");
var _componentLibrary = require("../../../component-library");
var _util = require("../../../../helpers/utils/util");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class PermissionPageContainerContent extends _react.PureComponent {
  render() {
    var _request$diff, _permissionDiffMap$Ca, _request$diff2;
    const {
      t
    } = this.context;
    const {
      selectedPermissions,
      selectedAccounts,
      subjectMetadata,
      requestedChainIds,
      request
    } = this.props;
    const accounts = selectedAccounts.reduce((accumulator, account) => {
      accumulator.push({
        avatarValue: account.address,
        avatarName: account.label
      });
      return accumulator;
    }, []);
    const {
      origin,
      subjectType
    } = subjectMetadata;
    const displayOrigin = subjectType === _permissionController.SubjectType.Website ? (0, _util.getURLHost)(origin) : origin;

    // permissionDiffMap is expected to be present when an incremental permission request is made
    // This occurs when a "wallet_switchEthereumChain" request comes in and we already have a set of permissions
    const permissionDiffMap = (_request$diff = request.diff) === null || _request$diff === void 0 ? void 0 : _request$diff.permissionDiffMap;
    // Extract the requested chain IDs from the permission diff, specifically from the CAIP-25 endowment permission
    // This represents the new chains being requested in addition to existing permissions
    const permissionDiffRequestedChainIds = (0, _chainAgnosticPermission.getPermittedEthChainIds)((permissionDiffMap === null || permissionDiffMap === void 0 || (_permissionDiffMap$Ca = permissionDiffMap[_chainAgnosticPermission.Caip25EndowmentPermissionName]) === null || _permissionDiffMap$Ca === void 0 ? void 0 : _permissionDiffMap$Ca[_chainAgnosticPermission.Caip25CaveatType]) ?? {
      requiredScopes: {},
      optionalScopes: {}
    });
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      className: "permission-page-container-content",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      justifyContent: _designSystem.JustifyContent.flexStart,
      alignItems: _designSystem.AlignItems.center,
      height: _designSystem.BlockSize.Full,
      paddingLeft: 4,
      paddingRight: 4,
      backgroundColor: _designSystem.BackgroundColor.backgroundDefault
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      justifyContent: _designSystem.JustifyContent.center,
      alignItems: _designSystem.AlignItems.center,
      paddingTop: 4,
      paddingBottom: 4
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.headingMd,
      textAlign: _designSystem.TextAlign.Center
    }, t('reviewPermissions')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMd,
      textAlign: _designSystem.TextAlign.Center
    }, t('nativeNetworkPermissionRequestDescription', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      as: "span",
      key: `description_key_${displayOrigin}`,
      fontWeight: _designSystem.FontWeight.Medium
    }, displayOrigin)]))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
      paddingLeft: 4,
      paddingRight: 4,
      paddingTop: 2,
      paddingBottom: 2,
      borderRadius: _designSystem.BorderRadius.XL
    }, /*#__PURE__*/_react.default.createElement(_permissionsConnectPermissionList.default, {
      isRequestApprovalPermittedChains: Boolean((_request$diff2 = request.diff) === null || _request$diff2 === void 0 ? void 0 : _request$diff2.permissionDiffMap),
      permissions: selectedPermissions,
      subjectName: subjectMetadata.origin,
      accounts: accounts
      // On an incremental permission request, we only want to render the newly requested chains in the UI
      // permissionDiffRequestedChainIds will only have content when an incremental permission request is made
      // Otherwise, we fall back to the original requestedChainIds for initial permission requests
      ,
      requestedChainIds: permissionDiffRequestedChainIds.length > 0 ? permissionDiffRequestedChainIds : requestedChainIds
    })));
  }
}
exports.default = PermissionPageContainerContent;
_defineProperty(PermissionPageContainerContent, "propTypes", {
  request: _propTypes.default.object,
  subjectMetadata: _propTypes.default.shape({
    name: _propTypes.default.string.isRequired,
    origin: _propTypes.default.string.isRequired,
    subjectType: _propTypes.default.string.isRequired,
    extensionId: _propTypes.default.string,
    iconUrl: _propTypes.default.string
  }),
  selectedPermissions: _propTypes.default.object.isRequired,
  selectedAccounts: _propTypes.default.array,
  requestedChainIds: _propTypes.default.array
});
_defineProperty(PermissionPageContainerContent, "defaultProps", {
  request: {},
  selectedAccounts: [],
  requestedChainIds: []
});
_defineProperty(PermissionPageContainerContent, "contextTypes", {
  t: _propTypes.default.func
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\permission-page-container\\permission-page-container-content\\permission-page-container-content.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\permission-page-container\\permission-page-container-footer.component.tsx", {"../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../pages/confirmations/confirmation/alerts/TemplateAlertContext":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\alerts\\TemplateAlertContext.tsx","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/page-container":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\page-container\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cpermission-page-container%5Cpermission-page-container-footer.component.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PermissionPageContainerFooter = void 0;
var _react = _interopRequireDefault(require("react"));
var _useI18nContext = require("../../../hooks/useI18nContext");
var _TemplateAlertContext = require("../../../pages/confirmations/confirmation/alerts/TemplateAlertContext");
var _componentLibrary = require("../../component-library");
var _pageContainer = require("../../ui/page-container");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const PermissionPageContainerFooter = ({
  cancelText,
  disabled,
  onCancel,
  onSubmit
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    hasAlerts,
    showAlertsModal
  } = (0, _TemplateAlertContext.useTemplateAlertContext)();
  return /*#__PURE__*/_react.default.createElement(_pageContainer.PageContainerFooter, {
    footerClassName: "permission-page-container-footer",
    cancelButtonType: "default",
    onCancel: onCancel,
    cancelText: cancelText,
    onSubmit: hasAlerts ? showAlertsModal : onSubmit,
    submitText: t('confirm'),
    disabled: disabled,
    submitButtonIcon: hasAlerts ? _componentLibrary.IconName.Info : undefined
  });
};
exports.PermissionPageContainerFooter = PermissionPageContainerFooter;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\permission-page-container\\permission-page-container-footer.component.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\permission-page-container\\permission-page-container.component.js", {".":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\permission-page-container\\index.js","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/permissions":"D:\\code\\v\\metamask-extension\\shared\\constants\\permissions.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/permissions":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\permissions.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../pages/confirmations/confirmation/alerts/TemplateAlertContext":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\alerts\\TemplateAlertContext.tsx","../../../pages/permissions-connect/connect-page/utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\connect-page\\utils.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../permissions-connect-footer":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\permissions-connect-footer\\index.js","../snaps/snap-privacy-warning":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-privacy-warning\\index.js","./permission-page-container-footer.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\permission-page-container\\permission-page-container-footer.component.tsx","@metamask/chain-agnostic-permission":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\chain-agnostic-permission\\dist\\index.cjs","@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs","@metamask/snaps-rpc-methods":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\index.cjs","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cpermission-page-container%5Cpermission-page-container.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _snapsRpcMethods = require("@metamask/snaps-rpc-methods");
var _chainAgnosticPermission = require("@metamask/chain-agnostic-permission");
var _permissionController = require("@metamask/permission-controller");
var _metametrics = require("../../../../shared/constants/metametrics");
var _permissionsConnectFooter = _interopRequireDefault(require("../permissions-connect-footer"));
var _permissions = require("../../../../shared/constants/permissions");
var _snapPrivacyWarning = _interopRequireDefault(require("../snaps/snap-privacy-warning"));
var _util = require("../../../helpers/utils/util");
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../component-library");
var _utils = require("../../../pages/permissions-connect/connect-page/utils");
var _TemplateAlertContext = require("../../../pages/confirmations/confirmation/alerts/TemplateAlertContext");
var _permissions2 = require("../../../helpers/utils/permissions");
var _permissionPageContainerFooter = require("./permission-page-container-footer.component");
var _ = require(".");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class PermissionPageContainer extends _react.Component {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "state", {});
    _defineProperty(this, "onCancel", () => {
      const {
        request,
        rejectPermissionsRequest
      } = this.props;
      rejectPermissionsRequest(request.metadata.id);
    });
    _defineProperty(this, "onSubmit", () => {
      const {
        request: _request,
        approvePermissionsRequest,
        rejectPermissionsRequest,
        selectedAccounts,
        requestedChainIds
      } = this.props;
      const approvedAccounts = selectedAccounts.map(selectedAccount => selectedAccount.address);
      const requestedCaip25CaveatValue = (0, _utils.getCaip25CaveatValueFromPermissions)(_request.permissions);
      const request = {
        ..._request,
        permissions: {
          ..._request.permissions,
          ...(0, _utils.getCaip25PermissionsResponse)(requestedCaip25CaveatValue, approvedAccounts, requestedChainIds)
        }
      };
      if (Object.keys(request.permissions).length > 0) {
        approvePermissionsRequest(request);
      } else {
        rejectPermissionsRequest(request.metadata.id);
      }
    });
    _defineProperty(this, "onLeftFooterClick", () => {
      const requestedPermissions = this.getRequestedPermissions();
      if (requestedPermissions[_chainAgnosticPermission.Caip25EndowmentPermissionName] === undefined) {
        this.goBack();
      } else {
        this.onCancel();
      }
    });
  }
  getRequestedPermissions() {
    var _request$diff;
    const {
      request
    } = this.props;

    // if the request contains a diff this means its an incremental permission request
    const permissions = (request === null || request === void 0 || (_request$diff = request.diff) === null || _request$diff === void 0 ? void 0 : _request$diff.permissionDiffMap) ?? request.permissions ?? {};
    return Object.entries(permissions).reduce((acc, [permissionName, permissionValue]) => {
      if (permissionName === _permissions.RestrictedMethods.wallet_snap) {
        acc[permissionName] = this.getDedupedSnapPermissions();
        return acc;
      }
      acc[permissionName] = permissionValue;
      return acc;
    }, {});
  }
  getDedupedSnapPermissions() {
    var _request$permissions;
    const {
      request,
      currentPermissions
    } = this.props;
    const snapKeys = (0, _util.getDedupedSnaps)(request, currentPermissions);
    const permission = (request === null || request === void 0 || (_request$permissions = request.permissions) === null || _request$permissions === void 0 ? void 0 : _request$permissions[_snapsRpcMethods.WALLET_SNAP_PERMISSION_KEY]) || {};
    return {
      ...permission,
      caveats: [{
        type: _snapsRpcMethods.SnapCaveatType.SnapIds,
        value: snapKeys.reduce((caveatValue, snapId) => {
          caveatValue[snapId] = {};
          return caveatValue;
        }, {})
      }]
    };
  }
  showSnapsPrivacyWarning() {
    this.setState({
      isShowingSnapsPrivacyWarning: true
    });
  }
  componentDidMount() {
    this.context.trackEvent({
      category: _metametrics.MetaMetricsEventCategory.Auth,
      event: 'Tab Opened',
      properties: {
        action: 'Connect',
        legacy_event: true
      }
    });
    if (this.props.request.permissions[_snapsRpcMethods.WALLET_SNAP_PERMISSION_KEY]) {
      if (this.props.snapsInstallPrivacyWarningShown === false) {
        this.showSnapsPrivacyWarning();
      }
    }
  }
  goBack() {
    const {
      history,
      connectPath
    } = this.props;
    history.push(connectPath);
  }
  render() {
    var _request$metadata;
    const {
      request,
      requestMetadata,
      targetSubjectMetadata,
      selectedAccounts,
      allAccountsSelected,
      requestedChainIds
    } = this.props;
    const requestedPermissions = this.getRequestedPermissions();
    const setIsShowingSnapsPrivacyWarning = value => {
      this.setState({
        isShowingSnapsPrivacyWarning: value
      });
    };
    const confirmSnapsPrivacyWarning = () => {
      setIsShowingSnapsPrivacyWarning(false);
      this.props.setSnapsInstallPrivacyWarningShownStatus(true);
    };
    const footerLeftActionText = requestedPermissions[_chainAgnosticPermission.Caip25EndowmentPermissionName] ? this.context.t('cancel') : this.context.t('back');
    return /*#__PURE__*/_react.default.createElement(_TemplateAlertContext.TemplateAlertContextProvider, {
      onSubmit: () => this.onSubmit(),
      confirmationId: request === null || request === void 0 || (_request$metadata = request.metadata) === null || _request$metadata === void 0 ? void 0 : _request$metadata.id
    }, this.state.isShowingSnapsPrivacyWarning && /*#__PURE__*/_react.default.createElement(_snapPrivacyWarning.default, {
      onAccepted: () => confirmSnapsPrivacyWarning(),
      onCanceled: () => this.onCancel()
    }), /*#__PURE__*/_react.default.createElement(_.PermissionPageContainerContent, {
      request: request,
      requestMetadata: requestMetadata,
      subjectMetadata: targetSubjectMetadata,
      selectedPermissions: requestedPermissions,
      requestedChainIds: requestedChainIds,
      selectedAccounts: selectedAccounts,
      allAccountsSelected: allAccountsSelected
    }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      backgroundColor: _designSystem.BackgroundColor.backgroundAlternative,
      flexDirection: _designSystem.FlexDirection.Column
    }, (targetSubjectMetadata === null || targetSubjectMetadata === void 0 ? void 0 : targetSubjectMetadata.subjectType) !== _permissionController.SubjectType.Snap && /*#__PURE__*/_react.default.createElement(_permissionsConnectFooter.default, null), /*#__PURE__*/_react.default.createElement(_permissionPageContainerFooter.PermissionPageContainerFooter, {
      onCancel: () => this.onLeftFooterClick(),
      cancelText: footerLeftActionText,
      onSubmit: () => this.onSubmit(),
      disabled: (0, _permissions2.containsEthPermissionsAndNonEvmAccount)(selectedAccounts, requestedPermissions)
    })));
  }
}
exports.default = PermissionPageContainer;
_defineProperty(PermissionPageContainer, "propTypes", {
  approvePermissionsRequest: _propTypes.default.func.isRequired,
  rejectPermissionsRequest: _propTypes.default.func.isRequired,
  selectedAccounts: _propTypes.default.array,
  requestedChainIds: _propTypes.default.array,
  allAccountsSelected: _propTypes.default.bool,
  currentPermissions: _propTypes.default.object,
  snapsInstallPrivacyWarningShown: _propTypes.default.bool.isRequired,
  setSnapsInstallPrivacyWarningShownStatus: _propTypes.default.func,
  request: _propTypes.default.object,
  requestMetadata: _propTypes.default.object,
  targetSubjectMetadata: _propTypes.default.shape({
    name: _propTypes.default.string,
    origin: _propTypes.default.string.isRequired,
    subjectType: _propTypes.default.string.isRequired,
    extensionId: _propTypes.default.string,
    iconUrl: _propTypes.default.string
  }),
  history: _propTypes.default.object.isRequired,
  connectPath: _propTypes.default.string.isRequired
});
_defineProperty(PermissionPageContainer, "defaultProps", {
  request: {},
  requestMetadata: {},
  selectedAccounts: [],
  allAccountsSelected: false,
  currentPermissions: {}
});
_defineProperty(PermissionPageContainer, "contextTypes", {
  t: _propTypes.default.func,
  trackEvent: _propTypes.default.func
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\permission-page-container\\permission-page-container.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\permission-page-container\\permission-page-container.container.js", {"../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","./permission-page-container.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\permission-page-container\\permission-page-container.component.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cpermission-page-container%5Cpermission-page-container.container.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactRedux = require("react-redux");
var _selectors = require("../../../selectors");
var _permissionPageContainer = _interopRequireDefault(require("./permission-page-container.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const mapStateToProps = (state, ownProps) => {
  var _ownProps$request$met;
  const {
    selectedAccounts
  } = ownProps;
  const currentPermissions = (0, _selectors.getPermissions)(state, (_ownProps$request$met = ownProps.request.metadata) === null || _ownProps$request$met === void 0 ? void 0 : _ownProps$request$met.origin);
  const allInternalAccounts = (0, _selectors.getInternalAccounts)(state);
  const allInternalAccountsSelected = Object.keys(selectedAccounts).length === Object.keys(allInternalAccounts).length && selectedAccounts.length > 1;
  return {
    allInternalAccountsSelected,
    currentPermissions
  };
};
var _default = exports.default = (0, _reactRedux.connect)(mapStateToProps)(_permissionPageContainer.default);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\permission-page-container\\permission-page-container.container.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\permissions-connect-footer\\index.js", {"./permissions-connect-footer.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\permissions-connect-footer\\permissions-connect-footer.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cpermissions-connect-footer%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _permissionsConnectFooter.default;
  }
});
var _permissionsConnectFooter = _interopRequireDefault(require("./permissions-connect-footer.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\permissions-connect-footer\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\permissions-connect-footer\\permissions-connect-footer.component.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/zendesk-url":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\zendesk-url.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cpermissions-connect-footer%5Cpermissions-connect-footer.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _zendeskUrl = _interopRequireDefault(require("../../../helpers/constants/zendesk-url"));
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../component-library");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class PermissionsConnectFooter extends _react.Component {
  render() {
    const {
      t
    } = this.context;
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      alignItems: _designSystem.AlignItems.center,
      justifyContent: _designSystem.JustifyContent.center
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMd
    }, t('onlyConnectTrust', [/*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
      key: "permission-connect-footer-learn-more-link",
      size: _componentLibrary.ButtonLinkSize.Inherit,
      target: "_blank",
      onClick: () => {
        global.platform.openTab({
          url: _zendeskUrl.default.USER_GUIDE_DAPPS
        });
      }
    }, t('learnMoreUpperCase'))])));
  }
}
exports.default = PermissionsConnectFooter;
_defineProperty(PermissionsConnectFooter, "contextTypes", {
  t: _propTypes.default.func
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\permissions-connect-footer\\permissions-connect-footer.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\permissions-connect-permission-list\\index.js", {"./permissions-connect-permission-list":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\permissions-connect-permission-list\\permissions-connect-permission-list.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cpermissions-connect-permission-list%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _permissionsConnectPermissionList.default;
  }
});
var _permissionsConnectPermissionList = _interopRequireDefault(require("./permissions-connect-permission-list"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\permissions-connect-permission-list\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\permissions-connect-permission-list\\permissions-connect-permission-list.js", {"../../../helpers/utils/permission":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\permission.js","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../permission-cell":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\permission-cell\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cpermissions-connect-permission-list%5Cpermissions-connect-permission-list.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = PermissionsConnectPermissionList;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRedux = require("react-redux");
var _permission = require("../../../helpers/utils/permission");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _selectors = require("../../../selectors");
var _util = require("../../../helpers/utils/util");
var _permissionCell = _interopRequireDefault(require("../permission-cell"));
var _componentLibrary = require("../../component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * Get one or more permission descriptions for a permission name.
 *
 * @param options - The options object.
 * @param options.permission - The permission to render.
 * @param options.index - The index of the permission.
 * @param options.accounts - An array representing list of accounts for which permission is used.
 * @param options.requestedChainIds - An array representing list of chain ids for which permission is used.
 * @returns {JSX.Element} A permission description node.
 */
function getDescriptionNode({
  permission,
  index,
  accounts,
  requestedChainIds
}) {
  return /*#__PURE__*/_react.default.createElement(_permissionCell.default, {
    permissionName: permission.name,
    title: permission.label,
    description: permission.description,
    weight: permission.weight,
    avatarIcon: permission.leftIcon,
    key: `${permission.permissionName}-${index}`,
    accounts: accounts,
    chainIds: requestedChainIds
  });
}
function PermissionsConnectPermissionList({
  isRequestApprovalPermittedChains,
  permissions,
  subjectName,
  accounts,
  requestedChainIds
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  const snapsMetadata = (0, _reactRedux.useSelector)(_selectors.getSnapsMetadata);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    as: "span"
  }, (0, _permission.getWeightedPermissions)({
    t,
    isRequestApprovalPermittedChains,
    permissions,
    getSubjectName: (0, _util.getSnapName)(snapsMetadata),
    subjectName
  }).map((permission, index) => {
    return getDescriptionNode({
      permission,
      index,
      accounts,
      requestedChainIds
    });
  }));
}
PermissionsConnectPermissionList.propTypes = {
  permissions: _propTypes.default.object.isRequired,
  subjectName: _propTypes.default.string.isRequired,
  requestedChainIds: _propTypes.default.array,
  accounts: _propTypes.default.arrayOf(_propTypes.default.object),
  isRequestApprovalPermittedChains: _propTypes.default.boolean
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\permissions-connect-permission-list\\permissions-connect-permission-list.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\preferred-avatar\\index.ts", {"./preferred-avatar":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\preferred-avatar\\preferred-avatar.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cpreferred-avatar%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "PreferredAvatar", {
  enumerable: true,
  get: function () {
    return _preferredAvatar.PreferredAvatar;
  }
});
var _preferredAvatar = require("./preferred-avatar");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\preferred-avatar\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\preferred-avatar\\preferred-avatar.tsx", {"@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cpreferred-avatar%5Cpreferred-avatar.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PreferredAvatar = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _designSystemReact = require("@metamask/design-system-react");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
/**
 * Renders an avatar for an address based on the user's settings. This wraps AvatarAccount.
 *
 * @param props - Props to pass to AvatarAccount
 */
const PreferredAvatar = props => {
  const variant = (0, _reactRedux.useSelector)(getAvatarType);
  return /*#__PURE__*/_react.default.createElement(_designSystemReact.AvatarAccount, _extends({}, props, {
    variant: variant
  }));
};
exports.PreferredAvatar = PreferredAvatar;
const avatarTypeMap = {
  maskicon: _designSystemReact.AvatarAccountVariant.Maskicon,
  jazzicon: _designSystemReact.AvatarAccountVariant.Jazzicon,
  blockies: _designSystemReact.AvatarAccountVariant.Blockies
};
function getAvatarType({
  metamask: {
    preferences
  }
}) {
  const avatarType = preferences === null || preferences === void 0 ? void 0 : preferences.avatarType;
  return avatarType ? avatarTypeMap[avatarType] : undefined;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\preferred-avatar\\preferred-avatar.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\qr-hardware-popover\\base-reader.js", {"../../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../../shared/constants/time":"D:\\code\\v\\metamask-extension\\shared\\constants\\time.ts","../../../helpers/utils/webcam-utils":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\webcam-utils.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../ui/page-container/page-container-footer/page-container-footer.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\page-container\\page-container-footer\\page-container-footer.component.js","./enhanced-reader":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\qr-hardware-popover\\enhanced-reader.js","@ngraveio/bc-ur":"D:\\code\\v\\metamask-extension\\node_modules\\@ngraveio\\bc-ur\\dist\\index.js","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cqr-hardware-popover%5Cbase-reader.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _loglevel = _interopRequireDefault(require("loglevel"));
var _bcUr = require("@ngraveio/bc-ur");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _util = require("../../../../app/scripts/lib/util");
var _app = require("../../../../shared/constants/app");
var _webcamUtils = _interopRequireDefault(require("../../../helpers/utils/webcam-utils"));
var _pageContainerFooter = _interopRequireDefault(require("../../ui/page-container/page-container-footer/page-container-footer.component"));
var _useI18nContext = require("../../../hooks/useI18nContext");
var _time = require("../../../../shared/constants/time");
var _enhancedReader = _interopRequireDefault(require("./enhanced-reader"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

const READY_STATE = {
  ACCESSING_CAMERA: 'ACCESSING_CAMERA',
  NEED_TO_ALLOW_ACCESS: 'NEED_TO_ALLOW_ACCESS',
  READY: 'READY'
};
const BaseReader = ({
  isReadingWallet,
  handleCancel,
  handleSuccess,
  setErrorTitle
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const [ready, setReady] = (0, _react.useState)(READY_STATE.ACCESSING_CAMERA);
  const [error, setError] = (0, _react.useState)(null);
  const [urDecoder, setURDecoder] = (0, _react.useState)(new _bcUr.URDecoder());
  const [progress, setProgress] = (0, _react.useState)(0);
  let permissionChecker = null;
  const mounted = (0, _react.useRef)(false);
  const reset = () => {
    setReady(READY_STATE.ACCESSING_CAMERA);
    setError(null);
    setURDecoder(new _bcUr.URDecoder());
    setProgress(0);
  };
  const checkEnvironment = async () => {
    try {
      const {
        environmentReady
      } = await _webcamUtils.default.checkStatus();
      if (!environmentReady && (0, _util.getEnvironmentType)() !== _app.ENVIRONMENT_TYPE_FULLSCREEN) {
        const currentUrl = new URL(window.location.href);
        const currentHash = currentUrl.hash;
        const currentRoute = currentHash ? currentHash.substring(1) : null;
        global.platform.openExtensionInBrowser(currentRoute);
      }
    } catch (e) {
      if (mounted.current) {
        setError(e);
      }
    }
    // initial attempt is required to trigger permission prompt
    // eslint-disable-next-line no-use-before-define
    return initCamera();
  };
  const checkPermissions = async () => {
    try {
      const {
        permissions
      } = await _webcamUtils.default.checkStatus();
      if (permissions) {
        // Let the video stream load first...
        await new Promise(resolve => setTimeout(resolve, _time.SECOND * 2));
        if (!mounted.current) {
          return;
        }
        setReady(READY_STATE.READY);
      } else if (mounted.current) {
        // Keep checking for permissions
        permissionChecker = setTimeout(checkPermissions, _time.SECOND);
        setReady(READY_STATE.NEED_TO_ALLOW_ACCESS);
      }
    } catch (e) {
      if (mounted.current) {
        setError(e);
      }
    }
  };
  const handleScan = data => {
    try {
      if (!data || urDecoder.isComplete()) {
        return;
      }
      urDecoder.receivePart(data);
      setProgress(urDecoder.estimatedPercentComplete());
      if (urDecoder.isComplete()) {
        const result = urDecoder.resultUR();
        handleSuccess(result).catch(setError);
      }
    } catch (e) {
      if (isReadingWallet) {
        setErrorTitle(t('QRHardwareUnknownQRCodeTitle'));
      } else {
        setErrorTitle(t('QRHardwareInvalidTransactionTitle'));
      }
      setError(new Error(t('unknownQrCode')));
    }
  };
  const initCamera = () => {
    try {
      checkPermissions();
    } catch (e) {
      if (!mounted.current) {
        return;
      }
      if (e.name === 'NotAllowedError') {
        _loglevel.default.info(`Permission denied: '${e}'`);
        setReady(READY_STATE.NEED_TO_ALLOW_ACCESS);
      } else {
        setError(e);
      }
    }
  };
  (0, _react.useEffect)(() => {
    mounted.current = true;
    checkEnvironment();
    return () => {
      mounted.current = false;
      clearTimeout(permissionChecker);
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(() => {
    if (ready === READY_STATE.READY) {
      initCamera();
    } else if (ready === READY_STATE.NEED_TO_ALLOW_ACCESS) {
      checkPermissions();
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [ready]);
  const tryAgain = () => {
    clearTimeout(permissionChecker);
    reset();
    checkEnvironment();
  };
  const renderError = () => {
    let title, msg;
    if (error.type === 'NO_WEBCAM_FOUND') {
      title = t('noWebcamFoundTitle');
      msg = t('noWebcamFound');
    } else if (error.message === t('unknownQrCode')) {
      if (isReadingWallet) {
        msg = t('QRHardwareUnknownWalletQRCode');
      } else {
        msg = t('unknownQrCode');
      }
    } else if (error.message === t('QRHardwareMismatchedSignId')) {
      msg = t('QRHardwareMismatchedSignId');
    } else {
      title = t('generalCameraErrorTitle');
      msg = t('generalCameraError');
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
      className: "qr-scanner__image"
    }, /*#__PURE__*/_react.default.createElement("img", {
      src: "images/webcam.svg",
      width: "70",
      height: "70",
      alt: ""
    })), title ? /*#__PURE__*/_react.default.createElement("div", {
      className: "qr-scanner__title"
    }, title) : null, /*#__PURE__*/_react.default.createElement("div", {
      className: "qr-scanner__error",
      "data-testid": "qr-scanner__error"
    }, msg), /*#__PURE__*/_react.default.createElement(_pageContainerFooter.default, {
      onCancel: () => {
        setErrorTitle('');
        handleCancel();
      },
      onSubmit: () => {
        setErrorTitle('');
        tryAgain();
      },
      cancelText: t('cancel'),
      submitText: t('tryAgain'),
      submitButtonType: "confirm"
    }));
  };
  const renderVideo = () => {
    let message;
    if (ready === READY_STATE.ACCESSING_CAMERA) {
      message = t('accessingYourCamera');
    } else if (ready === READY_STATE.READY) {
      message = t('QRHardwareScanInstructions');
    } else if (ready === READY_STATE.NEED_TO_ALLOW_ACCESS) {
      message = t('youNeedToAllowCameraAccess');
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
      className: "qr-scanner__content"
    }, /*#__PURE__*/_react.default.createElement(_enhancedReader.default, {
      handleScan: handleScan
    })), progress > 0 && /*#__PURE__*/_react.default.createElement("div", {
      className: "qr-scanner__progress",
      "data-testid": "qr-reader-progress-bar",
      style: {
        '--progress': `${Math.floor(progress * 100)}%`
      }
    }), message && /*#__PURE__*/_react.default.createElement("div", {
      className: "qr-scanner__status"
    }, message));
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "qr-scanner"
  }, error ? renderError() : renderVideo());
};
BaseReader.propTypes = {
  isReadingWallet: _propTypes.default.bool.isRequired,
  handleCancel: _propTypes.default.func.isRequired,
  handleSuccess: _propTypes.default.func.isRequired,
  setErrorTitle: _propTypes.default.func.isRequired
};
var _default = exports.default = BaseReader;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\qr-hardware-popover\\base-reader.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\qr-hardware-popover\\enhanced-reader.js", {"../../../../shared/constants/time":"D:\\code\\v\\metamask-extension\\shared\\constants\\time.ts","../../ui/spinner":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\spinner\\index.js","@zxing/browser":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\browser\\cjs\\index.js","@zxing/library":"D:\\code\\v\\metamask-extension\\node_modules\\@zxing\\library\\cjs\\index.js","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cqr-hardware-popover%5Cenhanced-reader.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _library = require("@zxing/library");
var _browser = require("@zxing/browser");
var _loglevel = _interopRequireDefault(require("loglevel"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _time = require("../../../../shared/constants/time");
var _spinner = _interopRequireDefault(require("../../ui/spinner"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EnhancedReader = ({
  handleScan
}) => {
  const [canplay, setCanplay] = (0, _react.useState)(false);
  const codeReader = (0, _react.useMemo)(() => {
    const hint = new Map();
    hint.set(_library.DecodeHintType.POSSIBLE_FORMATS, [_library.BarcodeFormat.QR_CODE]);
    return new _browser.BrowserQRCodeReader(hint, {
      delayBetweenScanAttempts: _time.MILLISECOND * 100,
      delayBetweenScanSuccess: _time.MILLISECOND * 100
    });
  }, []);
  (0, _react.useEffect)(() => {
    const videoElem = document.getElementById('video');
    const canplayListener = () => {
      setCanplay(true);
    };
    videoElem.addEventListener('canplay', canplayListener);
    const promise = codeReader.decodeFromVideoDevice(undefined, 'video', result => {
      if (result) {
        handleScan(result.getText());
      }
    });
    return () => {
      videoElem.removeEventListener('canplay', canplayListener);
      promise.then(controls => {
        if (controls) {
          controls.stop();
        }
      }).catch(_loglevel.default.info);
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "qr-scanner__content__video-wrapper"
  }, /*#__PURE__*/_react.default.createElement("video", {
    id: "video",
    style: {
      display: canplay ? 'block' : 'none',
      width: '100%',
      filter: 'blur(4px)'
    }
  }), canplay ? null : /*#__PURE__*/_react.default.createElement(_spinner.default, null));
};
EnhancedReader.propTypes = {
  handleScan: _propTypes.default.func.isRequired
};
var _default = exports.default = EnhancedReader;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\qr-hardware-popover\\enhanced-reader.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\qr-hardware-popover\\index.js", {"./qr-hardware-popover":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\qr-hardware-popover\\qr-hardware-popover.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cqr-hardware-popover%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _qrHardwarePopover = _interopRequireDefault(require("./qr-hardware-popover"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
var _default = exports.default = _qrHardwarePopover.default;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\qr-hardware-popover\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\qr-hardware-popover\\qr-hardware-popover.js", {"../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../ui/popover":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\popover\\index.js","./qr-hardware-sign-request":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\qr-hardware-popover\\qr-hardware-sign-request\\index.js","./qr-hardware-wallet-importer":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\qr-hardware-popover\\qr-hardware-wallet-importer\\index.js","@metamask/eth-qr-keyring":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-qr-keyring\\dist\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cqr-hardware-popover%5Cqr-hardware-popover.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _rpcErrors = require("@metamask/rpc-errors");
var _ethQrKeyring = require("@metamask/eth-qr-keyring");
var _selectors = require("../../../selectors");
var _popover = _interopRequireDefault(require("../../ui/popover"));
var _useI18nContext = require("../../../hooks/useI18nContext");
var _actions = require("../../../store/actions");
var _qrHardwareWalletImporter = _interopRequireDefault(require("./qr-hardware-wallet-importer"));
var _qrHardwareSignRequest = _interopRequireDefault(require("./qr-hardware-sign-request"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const QRHardwarePopover = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  const activeScanRequest = (0, _reactRedux.useSelector)(_selectors.getActiveQrCodeScanRequest);
  const [errorTitle, setErrorTitle] = (0, _react.useState)('');
  const {
    txData
  } = (0, _reactRedux.useSelector)(state => {
    return state.confirmTransaction;
  });
  // the confirmTransaction's life cycle is not consistent with QR hardware wallet;
  // the confirmTransaction will change after the previous tx is confirmed or cancel,
  // we want to block the changing by sign request id;
  const _txData = (0, _react.useMemo)(() => {
    return txData;
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [activeScanRequest === null || activeScanRequest === void 0 ? void 0 : activeScanRequest.requestId]);
  const dispatch = (0, _reactRedux.useDispatch)();
  const walletImporterCancel = (0, _react.useCallback)(() => dispatch((0, _actions.cancelQrCodeScan)()), [dispatch]);
  const signRequestCancel = (0, _react.useCallback)(() => {
    dispatch((0, _actions.rejectPendingApproval)(_txData.id, (0, _rpcErrors.serializeError)(_rpcErrors.providerErrors.userRejectedRequest())));
    dispatch((0, _actions.cancelTx)(_txData));
    dispatch((0, _actions.cancelQrCodeScan)());
  }, [dispatch, _txData]);
  const title = (0, _react.useMemo)(() => {
    if (activeScanRequest === _ethQrKeyring.QrScanRequestType.SIGN) {
      return t('QRHardwareSignRequestTitle');
    }
    if (activeScanRequest === _ethQrKeyring.QrScanRequestType.PAIR) {
      return t('QRHardwareWalletImporterTitle');
    }
    if (errorTitle !== '') {
      return errorTitle;
    }
    return '';
  }, [activeScanRequest, t, errorTitle]);
  return activeScanRequest ? /*#__PURE__*/_react.default.createElement(_popover.default, {
    title: title,
    onClose: activeScanRequest.type === _ethQrKeyring.QrScanRequestType.PAIR ? walletImporterCancel : signRequestCancel
  }, activeScanRequest.type === _ethQrKeyring.QrScanRequestType.PAIR && /*#__PURE__*/_react.default.createElement(_qrHardwareWalletImporter.default, {
    handleCancel: walletImporterCancel,
    setErrorTitle: setErrorTitle
  }), activeScanRequest.type === _ethQrKeyring.QrScanRequestType.SIGN && /*#__PURE__*/_react.default.createElement(_qrHardwareSignRequest.default, {
    setErrorTitle: setErrorTitle,
    handleCancel: signRequestCancel,
    request: activeScanRequest.request
  })) : null;
};
var _default = exports.default = QRHardwarePopover;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\qr-hardware-popover\\qr-hardware-popover.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\qr-hardware-popover\\qr-hardware-sign-request\\index.js", {"./qr-hardware-sign-request.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\qr-hardware-popover\\qr-hardware-sign-request\\qr-hardware-sign-request.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cqr-hardware-popover%5Cqr-hardware-sign-request%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _qrHardwareSignRequest = _interopRequireDefault(require("./qr-hardware-sign-request.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
var _default = exports.default = _qrHardwareSignRequest.default;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\qr-hardware-popover\\qr-hardware-sign-request\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\qr-hardware-popover\\qr-hardware-sign-request\\player.js", {"../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../ui/page-container":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\page-container\\index.js","@ngraveio/bc-ur":"D:\\code\\v\\metamask-extension\\node_modules\\@ngraveio\\bc-ur\\dist\\index.js","buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","qrcode.react":"D:\\code\\v\\metamask-extension\\node_modules\\qrcode.react\\lib\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cqr-hardware-popover%5Cqr-hardware-sign-request%5Cplayer.js
      return function (require, module, exports) {
(function (Buffer){(function (){
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _qrcode = require("qrcode.react");
var _bcUr = require("@ngraveio/bc-ur");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _designSystem = require("../../../../helpers/constants/design-system");
var _pageContainer = require("../../../ui/page-container");
var _componentLibrary = require("../../../component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// QR code configuration constants to help with memory optimization
const QR_FRAGMENT_SIZE = 200;
const QR_REFRESH_RATE = 200;
const QR_CODE_SIZE = 225;
const Player = ({
  type,
  cbor,
  cancelQRHardwareSignRequest,
  toRead
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const urEncoder = (0, _react.useMemo)(() => new _bcUr.UREncoder(new _bcUr.UR(Buffer.from(cbor, 'hex'), type), QR_FRAGMENT_SIZE), [cbor, type]);
  const [currentQRCode, setCurrentQRCode] = (0, _react.useState)(urEncoder.nextPart());
  (0, _react.useEffect)(() => {
    const id = setInterval(() => {
      setCurrentQRCode(urEncoder.nextPart());
    }, QR_REFRESH_RATE);
    return () => {
      clearInterval(id);
    };
  }, [urEncoder]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    align: _designSystem.TextAlign.Center
  }, t('QRHardwareSignRequestSubtitle'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingTop: 4,
    paddingBottom: 4,
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    flexDirection: _designSystem.FlexDirection.Column
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      padding: 20,
      backgroundColor: 'var(--qr-code-white-background)'
    }
  }, /*#__PURE__*/_react.default.createElement(_qrcode.QRCodeSVG, {
    value: currentQRCode.toUpperCase(),
    size: QR_CODE_SIZE
  }))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingBottom: 4,
    paddingLeft: 4,
    paddingRight: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    align: _designSystem.TextAlign.Center
  }, t('QRHardwareSignRequestDescription'))), /*#__PURE__*/_react.default.createElement(_pageContainer.PageContainerFooter, {
    onCancel: cancelQRHardwareSignRequest,
    onSubmit: toRead,
    cancelText: t('QRHardwareSignRequestCancel'),
    submitText: t('QRHardwareSignRequestGetSignature'),
    submitButtonType: "confirm"
  }));
};
Player.propTypes = {
  type: _propTypes.default.string.isRequired,
  cbor: _propTypes.default.string.isRequired,
  cancelQRHardwareSignRequest: _propTypes.default.func.isRequired,
  toRead: _propTypes.default.func.isRequired
};
var _default = exports.default = Player;

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\qr-hardware-popover\\qr-hardware-sign-request\\player.js",}]],[],{})

//# sourceMappingURL=data:application/json;charset=utf8;base64,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