LavaPack.loadBundle([
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\transaction-list\\unified-transaction-list.component.js", {"../../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../../shared/constants/multichain/networks":"D:\\code\\v\\metamask-extension\\shared\\constants\\multichain\\networks.ts","../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../shared/constants/swaps":"D:\\code\\v\\metamask-extension\\shared\\constants\\swaps.ts","../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../../shared/modules/string-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\string-utils.ts","../../../ducks/bridge-status/selectors":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge-status\\selectors.ts","../../../ducks/ramps":"D:\\code\\v\\metamask-extension\\ui\\ducks\\ramps\\index.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/transactions":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\transactions.js","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../hooks/useAccountTotalFiatBalance":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAccountTotalFiatBalance.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../hooks/useMultichainTransactionDisplay":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainTransactionDisplay.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/multichain-transactions":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-transactions.ts","../../../selectors/multichain/networks":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain\\networks.ts","../../../selectors/transactions":"D:\\code\\v\\metamask-extension\\ui\\selectors\\transactions.js","../../../store/controller-actions/transaction-controller":"D:\\code\\v\\metamask-extension\\ui\\store\\controller-actions\\transaction-controller.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../multichain/activity-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\activity-list-item\\index.js","../../multichain/ramps-card/ramps-card":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\ramps-card\\ramps-card.js","../assets/asset-list/asset-list-control-bar":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\asset-list\\asset-list-control-bar\\index.ts","../multichain-bridge-transaction-details-modal/multichain-bridge-transaction-details-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\multichain-bridge-transaction-details-modal\\multichain-bridge-transaction-details-modal.tsx","../multichain-bridge-transaction-list-item/multichain-bridge-transaction-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\multichain-bridge-transaction-list-item\\multichain-bridge-transaction-list-item.tsx","../multichain-transaction-details-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\multichain-transaction-details-modal\\index.ts","../multichain-transaction-details-modal/helpers":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\multichain-transaction-details-modal\\helpers.ts","../transaction-activity-empty-state":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\transaction-activity-empty-state\\index.ts","../transaction-icon":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\transaction-icon\\index.js","../transaction-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\transaction-list-item\\index.js","../transaction-list-item/smart-transaction-list-item.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\transaction-list-item\\smart-transaction-list-item.component.js","../transaction-status-label/transaction-status-label":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\transaction-status-label\\transaction-status-label.js","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Ctransaction-list%5Cunified-transaction-list.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildUnifiedActivityItems = void 0;
exports.default = UnifiedTransactionList;
exports.groupAnyTransactionsByDate = exports.filterNonEvmTxByToken = void 0;
var _react = _interopRequireWildcard(require("react"));
var _bridgeController = require("@metamask/bridge-controller");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRedux = require("react-redux");
var _transactionController = require("@metamask/transaction-controller");
var _keyringApi = require("@metamask/keyring-api");
var _transactions = require("../../../selectors/transactions");
var _selectors = require("../../../selectors");
var _multichainBridgeTransactionListItem = _interopRequireDefault(require("../multichain-bridge-transaction-list-item/multichain-bridge-transaction-list-item"));
var _multichainBridgeTransactionDetailsModal = _interopRequireDefault(require("../multichain-bridge-transaction-details-modal/multichain-bridge-transaction-details-modal"));
var _useI18nContext = require("../../../hooks/useI18nContext");
var _transactionListItem = _interopRequireDefault(require("../transaction-list-item"));
var _smartTransactionListItem = _interopRequireDefault(require("../transaction-list-item/smart-transaction-list-item.component"));
var _transactions2 = require("../../../helpers/constants/transactions");
var _swaps = require("../../../../shared/constants/swaps");
var _stringUtils = require("../../../../shared/modules/string-utils");
var _networks = require("../../../selectors/multichain/networks");
var _componentLibrary = require("../../component-library");
var _transactionIcon = _interopRequireDefault(require("../transaction-icon"));
var _transactionStatusLabel = _interopRequireDefault(require("../transaction-status-label/transaction-status-label"));
var _multichainTransactionDetailsModal = require("../multichain-transaction-details-modal");
var _helpers = require("../multichain-transaction-details-modal/helpers");
var _designSystem = require("../../../helpers/constants/design-system");
var _util = require("../../../helpers/utils/util");
var _useAccountTotalFiatBalance = require("../../../hooks/useAccountTotalFiatBalance");
var _rampsCard = require("../../multichain/ramps-card/ramps-card");
var _ramps = require("../../../ducks/ramps");
var _activityListItem = require("../../multichain/activity-list-item");
var _useMultichainTransactionDisplay = require("../../../hooks/useMultichainTransactionDisplay");
var _transaction = require("../../../../shared/constants/transaction");
var _trace = require("../../../../shared/lib/trace");
var _network = require("../../../../shared/constants/network");
var _networks2 = require("../../../../shared/constants/multichain/networks");
var _util2 = require("../../../../app/scripts/lib/util");
var _app = require("../../../../shared/constants/app");
var _assetListControlBar = _interopRequireDefault(require("../assets/asset-list/asset-list-control-bar"));
var _transactionController2 = require("../../../store/controller-actions/transaction-controller");
var _selectors2 = require("../../../ducks/bridge-status/selectors");
var _multichainTransactions = require("../../../selectors/multichain-transactions");
var _transactionActivityEmptyState = require("../transaction-activity-empty-state");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); } ///: BEGIN:ONLY_INCLUDE_IF(multichain)
///: END:ONLY_INCLUDE_IF
///: BEGIN:ONLY_INCLUDE_IF(multichain)
///: END:ONLY_INCLUDE_IF
///: BEGIN:ONLY_INCLUDE_IF(multichain)
///: END:ONLY_INCLUDE_IF
///: BEGIN:ONLY_INCLUDE_IF(multichain)
///: END:ONLY_INCLUDE_IF
///: BEGIN:ONLY_INCLUDE_IF(multichain)
///: END:ONLY_INCLUDE_IF
// eslint-disable-next-line import/no-restricted-paths
const PAGE_DAYS_INCREMENT = 10;

// When we are on a token page, we only want to show transactions that involve that token.
// In the case of token transfers or approvals, these will be transactions sent to the
// token contract. In the case of swaps, these will be transactions sent to the swaps contract
// and which have the token address in the transaction data.
//
// getTransactionGroupRecipientAddressFilter is used to determine whether a transaction matches
// either of those criteria
const getTransactionGroupRecipientAddressFilter = (recipientAddress, chainIds) => {
  return ({
    initialTransaction: {
      txParams
    }
  }) => {
    return (0, _stringUtils.isEqualCaseInsensitive)(txParams === null || txParams === void 0 ? void 0 : txParams.to, recipientAddress) || chainIds.some(chainId => (txParams === null || txParams === void 0 ? void 0 : txParams.to) === _swaps.SWAPS_CHAINID_CONTRACT_ADDRESS_MAP[chainId]) && txParams.data.match(recipientAddress.slice(2));
  };
};
const getTransactionGroupRecipientAddressFilterAllChain = (recipientAddress, chainIds) => {
  return ({
    initialTransaction: {
      txParams
    }
  }) => {
    const isNativeAssetActivityFilter = recipientAddress === '0x0000000000000000000000000000000000000000';
    const isSimpleSendTx = !txParams.data || (txParams === null || txParams === void 0 ? void 0 : txParams.data) === '' || (txParams === null || txParams === void 0 ? void 0 : txParams.data) === '0x' || (txParams === null || txParams === void 0 ? void 0 : txParams.data) === '0x0';
    const isOnSameChain = chainIds.includes(txParams === null || txParams === void 0 ? void 0 : txParams.chainId);
    if (isNativeAssetActivityFilter && isSimpleSendTx && isOnSameChain) {
      return true;
    }
    return (0, _stringUtils.isEqualCaseInsensitive)(txParams === null || txParams === void 0 ? void 0 : txParams.to, recipientAddress) || chainIds.some(chainId => (txParams === null || txParams === void 0 ? void 0 : txParams.to) === _swaps.SWAPS_CHAINID_CONTRACT_ADDRESS_MAP[chainId]) && txParams.data.match(recipientAddress.slice(2));
  };
};
const tokenTransactionFilter = ({
  initialTransaction: {
    type,
    destinationTokenSymbol,
    sourceTokenSymbol
  }
}) => {
  if (_transactions2.TOKEN_CATEGORY_HASH[type]) {
    return false;
  } else if ([_transactionController.TransactionType.swap, _transactionController.TransactionType.swapAndSend].includes(type)) {
    return destinationTokenSymbol === 'ETH' || sourceTokenSymbol === 'ETH';
  }
  return true;
};
const getFilteredTransactionGroups = (transactionGroups, hideTokenTransactions, tokenAddress, chainIds) => {
  if (hideTokenTransactions) {
    return transactionGroups.filter(tokenTransactionFilter);
  } else if (tokenAddress) {
    return transactionGroups.filter(getTransactionGroupRecipientAddressFilter(tokenAddress, chainIds));
  }
  return transactionGroups;
};
const getFilteredTransactionGroupsAllChains = (transactionGroups, hideTokenTransactions, tokenAddress, tokenChainIds) => {
  if (hideTokenTransactions) {
    return transactionGroups.filter(tokenTransactionFilter);
  } else if (tokenAddress) {
    return transactionGroups.filter(getTransactionGroupRecipientAddressFilterAllChain(tokenAddress, tokenChainIds));
  }
  return transactionGroups;
};
const groupTransactionsByDate = (transactionGroups, getTransactionTimestamp, shouldSort = true) => {
  const groupedTransactions = [];
  if (!transactionGroups) {
    return groupedTransactions;
  }
  transactionGroups.forEach(transactionGroup => {
    const timestamp = getTransactionTimestamp(transactionGroup);
    const date = (0, _util.formatDateWithYearContext)(timestamp, 'MMM d, y', 'MMM d');
    const existingGroup = groupedTransactions.find(group => group.date === date);
    if (existingGroup) {
      existingGroup.transactionGroups.push(transactionGroup);
      if (shouldSort) {
        // Sort transactions within the group by timestamp (newest first)
        existingGroup.transactionGroups.sort((a, b) => {
          const aTime = getTransactionTimestamp(a);
          const bTime = getTransactionTimestamp(b);
          return bTime - aTime; // Descending order (newest first)
        });
      }
    } else {
      groupedTransactions.push({
        date,
        dateMillis: timestamp,
        transactionGroups: [transactionGroup]
      });
    }
    if (shouldSort) {
      // Sort date groups by timestamp (newest first)
      groupedTransactions.sort((a, b) => b.dateMillis - a.dateMillis);
    }
  });
  return groupedTransactions;
};

///: BEGIN:ONLY_INCLUDE_IF(multichain)
/**
 * Returns a copy of the nonEvmTransactions object with only the transactions that involve the tokenAddress.
 *
 * @param nonEvmTransactions - The nonEvmTransactions object.
 * @param tokenAddress - [Optional] The address of the token to filter for. Returns all transactions if not provided.
 * @returns A copy of the nonEvmTransactions object with only the transactions
 * that involve the tokenAddress.
 */
const filterNonEvmTxByToken = (nonEvmTransactions = {
  transactions: []
}, tokenAddress) => {
  if (!tokenAddress) {
    return nonEvmTransactions;
  }
  const transactionForToken = (nonEvmTransactions.transactions || []).filter(transaction => {
    return [...transaction.to, ...transaction.from].some(item => item.asset.type === tokenAddress);
  });
  return {
    ...nonEvmTransactions,
    transactions: transactionForToken
  };
};
exports.filterNonEvmTxByToken = filterNonEvmTxByToken;
function filterNonEvmTxByChainIds(nonEvmTransactions, chainIds) {
  if (!chainIds || chainIds.length === 0) {
    return {
      transactions: []
    };
  }
  const transactionForChainIds = (nonEvmTransactions.transactions || []).filter(transaction => chainIds.includes(transaction.chain));
  return {
    ...nonEvmTransactions,
    transactions: transactionForChainIds
  };
}
///: END:ONLY_INCLUDE_IF

const buildUnifiedActivityItems = (unfilteredPendingTransactions = [], enabledNetworksFilteredCompletedTransactions = [], nonEvmTransactions, {
  hideTokenTransactions,
  tokenAddress,
  evmChainIds,
  nonEvmChainIds
}) => {
  // Apply existing token filters to EVM groups (all chains)
  const filteredPending = getFilteredTransactionGroups(unfilteredPendingTransactions, hideTokenTransactions, tokenAddress, evmChainIds);
  const filteredCompleted = getFilteredTransactionGroupsAllChains(enabledNetworksFilteredCompletedTransactions, hideTokenTransactions, tokenAddress, evmChainIds);

  // Apply token filter to non‑EVM like nonEvmTransactionsForToken
  const filteredNonEvm = filterNonEvmTxByChainIds(filterNonEvmTxByToken(nonEvmTransactions, tokenAddress), nonEvmChainIds);

  // Normalize to a common shape for final sorting and grouping
  const evmItems = [...filteredPending, ...filteredCompleted].map(group => {
    var _group$primaryTransac, _group$primaryTransac2;
    return {
      kind: _transactions2.TransactionKind.EVM,
      transactionGroup: group,
      timeMs: (group === null || group === void 0 || (_group$primaryTransac = group.primaryTransaction) === null || _group$primaryTransac === void 0 ? void 0 : _group$primaryTransac.time) ?? 0,
      id: (group === null || group === void 0 || (_group$primaryTransac2 = group.primaryTransaction) === null || _group$primaryTransac2 === void 0 ? void 0 : _group$primaryTransac2.id) ?? (group === null || group === void 0 ? void 0 : group.id)
    };
  });
  const nonEvmItems = ((filteredNonEvm === null || filteredNonEvm === void 0 ? void 0 : filteredNonEvm.transactions) || []).map(tx => ({
    kind: _transactions2.TransactionKind.NON_EVM,
    transaction: tx,
    timeMs: ((tx === null || tx === void 0 ? void 0 : tx.timestamp) ?? 0) * 1000,
    id: tx === null || tx === void 0 ? void 0 : tx.id
  }));
  const sortedUnifiedItems = [...evmItems, ...nonEvmItems].sort((a, b) => b.timeMs - a.timeMs);
  return sortedUnifiedItems;
};

// Group EVM transaction groups, non‑EVM transactions, or unified items by date alike
exports.buildUnifiedActivityItems = buildUnifiedActivityItems;
const groupAnyTransactionsByDate = items => groupTransactionsByDate(items, item => {
  var _item$primaryTransact;
  // Prefer precomputed timeMs (unified items)
  if (typeof (item === null || item === void 0 ? void 0 : item.timeMs) === 'number') {
    return item.timeMs;
  }
  // EVM transactionGroup
  if (item !== null && item !== void 0 && (_item$primaryTransact = item.primaryTransaction) !== null && _item$primaryTransact !== void 0 && _item$primaryTransact.time) {
    return item.primaryTransaction.time;
  }
  // Non‑EVM transaction
  if (item !== null && item !== void 0 && item.timestamp) {
    return item.timestamp * 1000;
  }
  return 0;
}, true);
exports.groupAnyTransactionsByDate = groupAnyTransactionsByDate;
function getFilteredChainIds(enabledNetworks, tokenChainIdOverride) {
  const filteredUniqueEVMChainIds = Object.keys(enabledNetworks === null || enabledNetworks === void 0 ? void 0 : enabledNetworks.eip155) ?? [];
  const filteredUniqueNonEvmChainIds = [...new Set(Object.keys(enabledNetworks).filter(namespace => namespace !== 'eip155').reduce((acc, namespace) => {
    return [...acc, ...Object.keys(enabledNetworks[namespace])];
  }, []))] ?? [];
  if (tokenChainIdOverride && !tokenChainIdOverride.startsWith('solana')) {
    return {
      evmChainIds: [tokenChainIdOverride],
      nonEvmChainIds: []
    };
  }
  if (tokenChainIdOverride && tokenChainIdOverride.startsWith('solana')) {
    return {
      evmChainIds: [],
      nonEvmChainIds: [tokenChainIdOverride]
    };
  }
  return {
    evmChainIds: filteredUniqueEVMChainIds,
    nonEvmChainIds: filteredUniqueNonEvmChainIds
  };
}
function UnifiedTransactionList({
  hideTokenTransactions,
  tokenAddress,
  boxProps,
  hideNetworkFilter,
  tokenChainIdOverride
}) {
  const [daysLimit, setDaysLimit] = (0, _react.useState)(PAGE_DAYS_INCREMENT);
  const t = (0, _useI18nContext.useI18nContext)();
  const currentNetworkConfig = (0, _reactRedux.useSelector)(_selectors.getCurrentNetwork);
  const selectedAccount = (0, _reactRedux.useSelector)(_selectors.getSelectedAccount);
  const enabledNetworks = (0, _reactRedux.useSelector)(_selectors.getEnabledNetworks);
  const {
    evmChainIds,
    nonEvmChainIds
  } = getFilteredChainIds(enabledNetworks, tokenChainIdOverride);

  ///: BEGIN:ONLY_INCLUDE_IF(multichain)
  const [selectedTransaction, setSelectedTransaction] = (0, _react.useState)(null);
  const nonEvmTransactions = (0, _reactRedux.useSelector)(state => (0, _multichainTransactions.getSelectedAccountGroupMultichainTransactions)(state, nonEvmChainIds));
  const nonEvmTransactionsForToken = (0, _react.useMemo)(() => filterNonEvmTxByToken(nonEvmTransactions, tokenAddress), [nonEvmTransactions, tokenAddress]);
  ///: END:ONLY_INCLUDE_IF

  const unfilteredPendingTransactionsAllChains = (0, _reactRedux.useSelector)(_transactions.nonceSortedPendingTransactionsSelectorAllChains);
  const unfilteredPendingTransactions = (0, _react.useMemo)(() => {
    return unfilteredPendingTransactionsAllChains;
  }, [unfilteredPendingTransactionsAllChains]);
  const isTestNetwork = (0, _react.useMemo)(() => {
    return _network.TEST_CHAINS.includes(currentNetworkConfig.chainId);
  }, [currentNetworkConfig.chainId]);
  const unfilteredCompletedTransactionsAllChains = (0, _reactRedux.useSelector)(_transactions.nonceSortedCompletedTransactionsSelectorAllChains);
  const isEvmNetwork = (0, _reactRedux.useSelector)(_networks.getIsEvmMultichainNetworkSelected);
  const enabledNetworksForAllNamespaces = (0, _reactRedux.useSelector)(_networks.getAllEnabledNetworksForAllNamespaces);
  const currentMultichainChainId = (0, _reactRedux.useSelector)(_selectors.getSelectedMultichainNetworkChainId);
  const enabledNetworksFilteredCompletedTransactions = (0, _react.useMemo)(() => {
    if (!currentMultichainChainId) {
      return unfilteredCompletedTransactionsAllChains;
    }

    // If no networks are enabled for this namespace, return empty array
    if (enabledNetworksForAllNamespaces.length === 0) {
      return [];
    }
    const transactionsToFilter = unfilteredCompletedTransactionsAllChains;

    // Filter transactions to only include those from enabled networks
    const filteredTransactions = transactionsToFilter.filter(transactionGroup => {
      var _transactionGroup$ini;
      const transactionChainId = (_transactionGroup$ini = transactionGroup.initialTransaction) === null || _transactionGroup$ini === void 0 ? void 0 : _transactionGroup$ini.chainId;
      const isIncluded = enabledNetworksForAllNamespaces.includes(transactionChainId);
      return isIncluded;
    });
    return filteredTransactions;
  }, [enabledNetworksForAllNamespaces, currentMultichainChainId, unfilteredCompletedTransactionsAllChains]);
  const enabledNonEvmChainIds = (0, _react.useMemo)(() => {
    return nonEvmChainIds.filter(chainId => enabledNetworksForAllNamespaces.includes(chainId));
  }, [nonEvmChainIds, enabledNetworksForAllNamespaces]);
  const unifiedActivityItems = (0, _react.useMemo)(() => {
    return buildUnifiedActivityItems(unfilteredPendingTransactions, enabledNetworksFilteredCompletedTransactions, nonEvmTransactionsForToken, {
      hideTokenTransactions,
      tokenAddress,
      evmChainIds,
      nonEvmChainIds: enabledNonEvmChainIds
    });
  }, [unfilteredPendingTransactions, enabledNetworksFilteredCompletedTransactions, nonEvmTransactionsForToken, hideTokenTransactions, tokenAddress, evmChainIds, enabledNonEvmChainIds]);
  const groupedUnifiedActivityItems = groupAnyTransactionsByDate(unifiedActivityItems);
  const shouldHideZeroBalanceTokens = (0, _reactRedux.useSelector)(_selectors.getShouldHideZeroBalanceTokens);
  const {
    totalFiatBalance
  } = (0, _useAccountTotalFiatBalance.useAccountTotalFiatBalance)(selectedAccount, shouldHideZeroBalanceTokens);
  const balanceIsZero = Number(totalFiatBalance) === 0;
  const isBuyableChain = (0, _reactRedux.useSelector)(_ramps.getIsNativeTokenBuyable);
  const showRampsCard = isBuyableChain && balanceIsZero;
  const [isNetworkFilterPopoverOpen, setIsNetworkFilterPopoverOpen] = (0, _react.useState)(false);
  const windowType = (0, _util2.getEnvironmentType)();
  const isFullScreen = windowType !== _app.ENVIRONMENT_TYPE_NOTIFICATION && windowType !== _app.ENVIRONMENT_TYPE_POPUP;
  (0, _react.useEffect)(() => {
    (0, _transactionController2.stopIncomingTransactionPolling)();
    (0, _transactionController2.startIncomingTransactionPolling)();
    return () => {
      (0, _transactionController2.stopIncomingTransactionPolling)();
    };
  }, [
  // Required to restart polling on new account
  selectedAccount]);
  const viewMore = (0, _react.useCallback)(() => setDaysLimit(prev => prev + PAGE_DAYS_INCREMENT), []);
  const toggleNetworkFilterPopover = (0, _react.useCallback)(() => {
    setIsNetworkFilterPopoverOpen(!isNetworkFilterPopoverOpen);
  }, [isNetworkFilterPopoverOpen]);
  const closePopover = (0, _react.useCallback)(() => {
    setIsNetworkFilterPopoverOpen(false);
  }, []);
  const renderFilterButton = (0, _react.useCallback)(() => {
    if (hideNetworkFilter) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_assetListControlBar.default, {
      showSortControl: false,
      showTokenFiatBalance: false,
      showImportTokenButton: false
    });
  }, [hideNetworkFilter, isEvmNetwork, isFullScreen, isNetworkFilterPopoverOpen, currentNetworkConfig, toggleNetworkFilterPopover, closePopover, isTestNetwork]);
  (0, _react.useEffect)(() => {
    (0, _trace.endTrace)({
      name: _trace.TraceName.AccountOverviewActivityTab
    });
  }, []);

  ///: BEGIN:ONLY_INCLUDE_IF(multichain)
  const toggleShowDetails = (0, _react.useCallback)((transaction = null) => {
    setSelectedTransaction(transaction);
  }, []);
  const multichainNetworkConfig = (0, _reactRedux.useSelector)(_networks.getSelectedMultichainNetworkConfiguration);
  const bridgeHistoryItems = (0, _reactRedux.useSelector)(_selectors2.selectBridgeHistoryForAccountGroup);
  const selectedBridgeHistoryItem = (0, _reactRedux.useSelector)(state => (0, _selectors2.selectBridgeHistoryItemForTxMetaId)(state, selectedTransaction === null || selectedTransaction === void 0 ? void 0 : selectedTransaction.id));

  ///: END:ONLY_INCLUDE_IF

  // Unified item renderer (handles both EVM and non‑EVM unified items)
  const renderTransaction = (0, _react.useCallback)((item, index) => {
    var _transactionGroup$ini2;
    if (item.kind === _transactions2.TransactionKind.NON_EVM) {
      var _matchedBridgeHistory, _matchedBridgeHistory2;
      const matchedBridgeHistoryItem = bridgeHistoryItems[item.id];
      if (matchedBridgeHistoryItem && (0, _bridgeController.isCrossChain)((_matchedBridgeHistory = matchedBridgeHistoryItem.quote) === null || _matchedBridgeHistory === void 0 ? void 0 : _matchedBridgeHistory.srcChainId, (_matchedBridgeHistory2 = matchedBridgeHistoryItem.quote) === null || _matchedBridgeHistory2 === void 0 ? void 0 : _matchedBridgeHistory2.destChainId)) {
        return /*#__PURE__*/_react.default.createElement(_multichainBridgeTransactionListItem.default, {
          key: `bridge-${item.id}`,
          transaction: item.transaction,
          bridgeHistoryItem: matchedBridgeHistoryItem,
          toggleShowDetails: toggleShowDetails
        });
      }
      return /*#__PURE__*/_react.default.createElement(MultichainTransactionListItem, {
        key: `non-evm-${item.id ?? index}`,
        transaction: item.transaction,
        networkConfig: multichainNetworkConfig,
        toggleShowDetails: toggleShowDetails
      });
    }

    // evm transaction
    const {
      transactionGroup
    } = item;
    if ((_transactionGroup$ini2 = transactionGroup.initialTransaction) !== null && _transactionGroup$ini2 !== void 0 && _transactionGroup$ini2.isSmartTransaction) {
      return /*#__PURE__*/_react.default.createElement(_smartTransactionListItem.default, {
        key: `${transactionGroup.nonce}:${index}`,
        isEarliestNonce: index === 0,
        smartTransaction: transactionGroup.initialTransaction,
        transactionGroup: transactionGroup,
        chainId: transactionGroup.initialTransaction.chainId
      });
    }
    return /*#__PURE__*/_react.default.createElement(_transactionListItem.default, {
      key: `${transactionGroup.nonce}:${index}`,
      isEarliestNonce: index === 0,
      transactionGroup: transactionGroup,
      chainId: transactionGroup.initialTransaction.chainId
    });
  }, [bridgeHistoryItems, multichainNetworkConfig, toggleShowDetails]);

  // Remove transactions within each date group that are incoming transactions
  // to a user that not the current one.
  const removeIncomingTxsButToAnotherAddressUnified = (0, _react.useCallback)(dateGroup => {
    const isIncomingTxsButToAnotherAddress = transaction => transaction.type === _transactionController.TransactionType.incoming && transaction.txParams.to.toLowerCase() !== selectedAccount.address.toLowerCase();
    dateGroup.transactionGroups = dateGroup.transactionGroups.map(item => {
      if ((item === null || item === void 0 ? void 0 : item.kind) !== _transactions2.TransactionKind.EVM) {
        return item;
      }
      const {
        transactionGroup
      } = item;
      transactionGroup.transactions = transactionGroup.transactions.filter(transaction => !isIncomingTxsButToAnotherAddress(transaction));
      return item;
    });
    return dateGroup;
  }, [selectedAccount]);
  const removeEmptyEvmItemsFromUnifiedDateGroup = (0, _react.useCallback)(dateGroup => {
    dateGroup.transactionGroups = dateGroup.transactionGroups.filter(item => {
      if ((item === null || item === void 0 ? void 0 : item.kind) !== _transactions2.TransactionKind.EVM) {
        return true;
      }
      return item.transactionGroup.transactions.length > 0;
    });
    return dateGroup;
  }, []);
  const dateGroupsWithItems = dateGroup => dateGroup.transactionGroups.length > 0;
  const processedUnifiedActivityItems = (0, _react.useMemo)(() => groupedUnifiedActivityItems.map(removeIncomingTxsButToAnotherAddressUnified).map(removeEmptyEvmItemsFromUnifiedDateGroup).filter(dateGroupsWithItems), [groupedUnifiedActivityItems, removeIncomingTxsButToAnotherAddressUnified, removeEmptyEvmItemsFromUnifiedDateGroup]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, selectedTransaction && (selectedBridgeHistoryItem && (0, _bridgeController.isCrossChain)(selectedBridgeHistoryItem.quote.srcChainId, selectedBridgeHistoryItem.quote.destChainId) ? /*#__PURE__*/_react.default.createElement(_multichainBridgeTransactionDetailsModal.default, {
    transaction: selectedTransaction,
    bridgeHistoryItem: selectedBridgeHistoryItem,
    onClose: () => toggleShowDetails(null)
  }) : /*#__PURE__*/_react.default.createElement(_multichainTransactionDetailsModal.MultichainTransactionDetailsModal, {
    transaction: selectedTransaction,
    onClose: () => toggleShowDetails(null),
    userAddress: selectedAccount.address,
    networkConfig: multichainNetworkConfig
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, _extends({
    className: "transaction-list"
  }, boxProps), renderFilterButton(), showRampsCard ? /*#__PURE__*/_react.default.createElement(_rampsCard.RampsCard, {
    variant: _rampsCard.RAMPS_CARD_VARIANT_TYPES.ACTIVITY
  }) : null, processedUnifiedActivityItems.length === 0 ? /*#__PURE__*/_react.default.createElement(_transactionActivityEmptyState.TransactionActivityEmptyState, {
    className: "mx-auto mt-5 mb-6",
    account: selectedAccount
  }) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "transaction-list__transactions"
  }, processedUnifiedActivityItems.slice(0, daysLimit).map(dateGroup => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: dateGroup.date
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    paddingTop: 3,
    paddingInline: 4,
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: _designSystem.TextColor.textAlternative
  }, dateGroup.date), dateGroup.transactionGroups.map((item, index) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: item.id ?? index
  }, renderTransaction(item, index))))), processedUnifiedActivityItems.length > daysLimit && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.center,
    paddingInline: 4,
    paddingBottom: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    className: "transaction-list__view-more",
    variant: _componentLibrary.ButtonVariant.Secondary,
    onClick: viewMore
  }, t('viewMore'))))));
}

///: BEGIN:ONLY_INCLUDE_IF(multichain)

// Regular transaction list item for non-bridge transactions
const MultichainTransactionListItem = ({
  transaction,
  networkConfig,
  toggleShowDetails
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    from,
    to,
    type,
    timestamp,
    isRedeposit,
    title
  } = (0, _useMultichainTransactionDisplay.useMultichainTransactionDisplay)(transaction, networkConfig);
  const networkLogo = _networks2.MULTICHAIN_TOKEN_IMAGE_MAP[transaction.chain];
  const statusKey = _useMultichainTransactionDisplay.KEYRING_TRANSACTION_STATUS_KEY[transaction.status];

  // A redeposit transaction is a special case where the outputs list is empty because we are sending to ourselves and only pay the fees
  // Mainly used for consolidation transactions
  if (isRedeposit) {
    return /*#__PURE__*/_react.default.createElement(_activityListItem.ActivityListItem, {
      className: "custom-class",
      "data-testid": "activity-list-item",
      onClick: () => toggleShowDetails(transaction),
      icon: /*#__PURE__*/_react.default.createElement(_componentLibrary.BadgeWrapper, {
        display: _designSystem.Display.Block,
        badge: /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
          className: "activity-tx__network-badge",
          "data-testid": "activity-tx-network-badge",
          size: _componentLibrary.AvatarNetworkSize.Xs,
          name: transaction.chain,
          src: networkLogo,
          borderColor: _designSystem.BackgroundColor.backgroundDefault,
          borderWidth: 2
        })
      }, /*#__PURE__*/_react.default.createElement(_transactionIcon.default, {
        category: _transaction.TransactionGroupCategory.redeposit,
        status: statusKey
      })),
      title: t('redeposit'),
      subtitle: /*#__PURE__*/_react.default.createElement(_transactionStatusLabel.default, {
        date: (0, _helpers.formatTimestamp)(timestamp),
        error: {},
        status: statusKey,
        statusOnly: true
      })
    });
  }
  let {
    amount,
    unit
  } = to ?? {};
  let category = type;
  if (type === _keyringApi.TransactionType.Swap) {
    amount = from.amount;
    unit = from.unit;
  }
  if (type === _keyringApi.TransactionType.Unknown) {
    category = _transaction.TransactionGroupCategory.interaction;
  }
  return /*#__PURE__*/_react.default.createElement(_activityListItem.ActivityListItem, {
    className: "custom-class",
    "data-testid": "activity-list-item",
    onClick: () => toggleShowDetails(transaction),
    icon: /*#__PURE__*/_react.default.createElement(_componentLibrary.BadgeWrapper, {
      display: _designSystem.Display.Block,
      badge: /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
        className: "activity-tx__network-badge",
        "data-testid": "activity-tx-network-badge",
        size: _componentLibrary.AvatarNetworkSize.Xs,
        name: transaction.chain,
        src: networkLogo,
        borderColor: _designSystem.BackgroundColor.backgroundDefault,
        borderWidth: 2
      })
    }, /*#__PURE__*/_react.default.createElement(_transactionIcon.default, {
      category: category,
      status: statusKey
    })),
    rightContent: /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      className: "activity-list-item__primary-currency",
      "data-testid": "transaction-list-item-primary-currency",
      color: _designSystem.TextColor.textDefault,
      variant: _designSystem.TextVariant.bodyMdMedium,
      ellipsis: true,
      textAlign: "right",
      title: "Primary Currency"
    }, amount, " ", unit),
    title: title,
    subtitle: /*#__PURE__*/_react.default.createElement(_transactionStatusLabel.default, {
      date: (0, _helpers.formatTimestamp)(transaction.timestamp),
      error: {},
      status: statusKey,
      statusOnly: true
    })
  });
};
MultichainTransactionListItem.propTypes = {
  transaction: _propTypes.default.object.isRequired,
  networkConfig: _propTypes.default.object.isRequired,
  toggleShowDetails: _propTypes.default.func.isRequired
};

///: END:ONLY_INCLUDE_IF

UnifiedTransactionList.propTypes = {
  hideTokenTransactions: _propTypes.default.bool,
  tokenAddress: _propTypes.default.string,
  boxProps: _propTypes.default.object,
  tokenChainIdOverride: _propTypes.default.string,
  hideNetworkFilter: _propTypes.default.bool
};
UnifiedTransactionList.defaultProps = {
  hideTokenTransactions: false,
  tokenAddress: undefined,
  boxProps: undefined,
  tokenChainIdOverride: null
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\transaction-list\\unified-transaction-list.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\transaction-status-label\\transaction-status-label.js", {"../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../ui/tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\index.js","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Ctransaction-status-label%5Ctransaction-status-label.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = TransactionStatusLabel;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _transactionController = require("@metamask/transaction-controller");
var _tooltip = _interopRequireDefault(require("../../ui/tooltip"));
var _useI18nContext = require("../../../hooks/useI18nContext");
var _transaction = require("../../../../shared/constants/transaction");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const QUEUED_PSEUDO_STATUS = 'queued';
const SIGNING_PSUEDO_STATUS = 'signing';

/**
 * A note about status logic for this component:
 * Approved, Signed and Submitted statuses are all treated, effectively
 * as pending. Transactions are only approved or signed for less than a
 * second, usually, and ultimately should be rendered in the UI no
 * differently than a pending transaction.
 *
 * Confirmed transactions are not especially highlighted except that their
 * status label will be the date the transaction was finalized.
 */
const pendingStatusHash = {
  [_transactionController.TransactionStatus.submitted]: _transaction.TransactionGroupStatus.pending,
  [_transactionController.TransactionStatus.approved]: _transaction.TransactionGroupStatus.pending
};
const statusToClassNameHash = {
  [_transactionController.TransactionStatus.unapproved]: 'transaction-status-label--unapproved',
  [_transactionController.TransactionStatus.rejected]: 'transaction-status-label--rejected',
  [_transactionController.TransactionStatus.failed]: 'transaction-status-label--failed',
  [_transactionController.TransactionStatus.dropped]: 'transaction-status-label--dropped',
  [_transaction.TransactionGroupStatus.cancelled]: 'transaction-status-label--cancelled',
  [QUEUED_PSEUDO_STATUS]: 'transaction-status-label--queued',
  [_transaction.TransactionGroupStatus.pending]: 'transaction-status-label--pending'
};
function getStatusKey(status, isEarliestNonce) {
  if (status === _transactionController.TransactionStatus.approved) {
    return SIGNING_PSUEDO_STATUS;
  }
  if (pendingStatusHash[status]) {
    return isEarliestNonce ? _transaction.TransactionGroupStatus.pending : QUEUED_PSEUDO_STATUS;
  }
  return status;
}
function TransactionStatusLabel({
  status,
  date,
  error,
  isEarliestNonce,
  className,
  statusOnly
}) {
  var _error$rpc;
  const t = (0, _useI18nContext.useI18nContext)();
  const statusKey = getStatusKey(status, isEarliestNonce);
  const tooltipText = (error === null || error === void 0 || (_error$rpc = error.rpc) === null || _error$rpc === void 0 ? void 0 : _error$rpc.message) || (error === null || error === void 0 ? void 0 : error.message);
  let statusText = statusKey && t(statusKey);
  if (statusKey === _transactionController.TransactionStatus.confirmed && !statusOnly) {
    statusText = date;
  }
  return /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    position: "top",
    title: tooltipText,
    wrapperClassName: (0, _classnames.default)('transaction-status-label', `transaction-status-label--${statusKey}`, className, statusToClassNameHash[statusKey])
  }, statusText);
}
TransactionStatusLabel.propTypes = {
  status: _propTypes.default.string,
  className: _propTypes.default.string,
  date: _propTypes.default.string,
  error: _propTypes.default.object,
  isEarliestNonce: _propTypes.default.bool,
  statusOnly: _propTypes.default.bool
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\transaction-status-label\\transaction-status-label.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\update-modal\\update-modal.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cupdate-modal%5Cupdate-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _componentLibrary = require("../../component-library");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _designSystem = require("../../../helpers/constants/design-system");
var _actions = require("../../../store/actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function UpdateModal() {
  const t = (0, _useI18nContext.useI18nContext)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: true,
    onClose: async () => await (0, _actions.setUpdateModalLastDismissedAt)(Date.now()),
    isClosedOnOutsideClick: false,
    isClosedOnEscapeKey: false,
    "data-testid": "update-modal",
    autoFocus: false
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onClose: async () => await (0, _actions.setUpdateModalLastDismissedAt)(Date.now()),
    startAccessory: true,
    closeButtonProps: {
      'data-testid': 'update-modal-close-button'
    }
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    borderRadius: _designSystem.BorderRadius.SM,
    padding: 10
  }, /*#__PURE__*/_react.default.createElement("img", {
    src: "/images/logo/metamask-fox.svg",
    width: 160,
    height: 160
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingMd,
    textAlign: _designSystem.TextAlign.Center
  }, t('getTheNewestFeatures')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    textAlign: _designSystem.TextAlign.Center,
    padding: 4,
    paddingBottom: 12
  }, t('updateInformation'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalFooter, {
    onSubmit: async () => {
      try {
        setIsLoading(true);
        await (0, _actions.openUpdateTabAndReload)();
      } catch (error) {
        console.error(error);
      } finally {
        setIsLoading(false);
      }
    },
    submitButtonProps: {
      children: t('updateToTheLatestVersion'),
      loading: isLoading,
      disabled: isLoading,
      block: true,
      'data-testid': 'update-modal-submit-button'
    }
  })));
}
var _default = exports.default = UpdateModal;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\update-modal\\update-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\user-preferenced-currency-display\\index.js", {"./user-preferenced-currency-display.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\user-preferenced-currency-display\\user-preferenced-currency-display.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cuser-preferenced-currency-display%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _userPreferencedCurrencyDisplay.default;
  }
});
var _userPreferencedCurrencyDisplay = _interopRequireDefault(require("./user-preferenced-currency-display.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\user-preferenced-currency-display\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\user-preferenced-currency-display\\user-preferenced-currency-display.component.js", {"../../../../shared/constants/common":"D:\\code\\v\\metamask-extension\\shared\\constants\\common.ts","../../../helpers/constants/common":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\common.ts","../../../hooks/useUserPreferencedCurrency":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useUserPreferencedCurrency.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../ui/currency-display":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\currency-display\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cuser-preferenced-currency-display%5Cuser-preferenced-currency-display.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = UserPreferencedCurrencyDisplay;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRedux = require("react-redux");
var _common = require("../../../../shared/constants/common");
var _common2 = require("../../../helpers/constants/common");
var _currencyDisplay = _interopRequireDefault(require("../../ui/currency-display"));
var _useUserPreferencedCurrency = require("../../../hooks/useUserPreferencedCurrency");
var _selectors = require("../../../selectors");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
/* eslint-disable jsdoc/require-param-name */
// eslint-disable-next-line jsdoc/require-param
/** @param {PropTypes.InferProps<typeof UserPreferencedCurrencyDisplayPropTypes>>} */
function UserPreferencedCurrencyDisplay({
  'data-testid': dataTestId,
  account: multichainAccount,
  ethNumberOfDecimals,
  numberOfDecimals: propsNumberOfDecimals,
  type,
  showFiat,
  showNative,
  shouldCheckShowNativeToken,
  privacyMode = false,
  ...restProps
}) {
  // NOTE: When displaying currencies, we need the actual account to detect whether we're in a
  // multichain world or EVM-only world.
  // To preserve the original behavior of this component, we default to the lastly selected
  // EVM accounts (when used in an EVM-only context).
  // The caller has to pass the account in a multichain context to properly display the currency
  // here (e.g for Bitcoin).
  const evmAccount = (0, _reactRedux.useSelector)(_selectors.getSelectedEvmInternalAccount);
  const account = multichainAccount ?? evmAccount;
  const {
    currency,
    numberOfDecimals
  } = (0, _useUserPreferencedCurrency.useUserPreferencedCurrency)(type, {
    account,
    ethNumberOfDecimals,
    numberOfDecimals: propsNumberOfDecimals,
    showFiatOverride: showFiat,
    showNativeOverride: showNative,
    shouldCheckShowNativeToken
  });
  return /*#__PURE__*/_react.default.createElement(_currencyDisplay.default, _extends({}, restProps, {
    account: account,
    currency: currency,
    "data-testid": dataTestId,
    numberOfDecimals: numberOfDecimals,
    suffix: false,
    privacyMode: privacyMode
  }));
}
const UserPreferencedCurrencyDisplayPropTypes = {
  className: _propTypes.default.string,
  account: _propTypes.default.object,
  'data-testid': _propTypes.default.string,
  prefix: _propTypes.default.string,
  value: _propTypes.default.string,
  numberOfDecimals: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),
  hideLabel: _propTypes.default.bool,
  hideTitle: _propTypes.default.bool,
  style: _propTypes.default.object,
  type: _propTypes.default.oneOf([_common2.PRIMARY, _common2.SECONDARY]),
  ethNumberOfDecimals: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),
  showFiat: _propTypes.default.bool,
  showNative: _propTypes.default.bool,
  /**
   * Following are the props from CurrencyDisplay component.
   * UserPreferencedCurrencyDisplay component should also accept all the props from Currency component
   */
  currency: _propTypes.default.string,
  denomination: _propTypes.default.oneOf([_common.EtherDenomination.GWEI, _common.EtherDenomination.ETH]),
  displayValue: _propTypes.default.string,
  suffix: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.bool]),
  textProps: _propTypes.default.object,
  suffixProps: _propTypes.default.object,
  shouldCheckShowNativeToken: _propTypes.default.bool,
  privacyMode: _propTypes.default.bool
};
UserPreferencedCurrencyDisplay.propTypes = UserPreferencedCurrencyDisplayPropTypes;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\user-preferenced-currency-display\\user-preferenced-currency-display.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\wallet-overview\\aggregated-percentage-overview-cross-chains.tsx", {"../../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/number-utils":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\number-utils.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../hooks/useAccountTotalCrossChainFiatBalance":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAccountTotalCrossChainFiatBalance.ts","../../../hooks/useFormatters":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useFormatters.ts","../../../hooks/useGetFormattedTokensPerChain":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useGetFormattedTokensPerChain.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../component-library/skeleton":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\skeleton\\index.ts","@metamask/assets-controllers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\index.cjs","ethereumjs-util":"D:\\code\\v\\metamask-extension\\node_modules\\ethereumjs-util\\dist.browser\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cwallet-overview%5Caggregated-percentage-overview-cross-chains.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AggregatedPercentageOverviewCrossChains = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _ethereumjsUtil = require("ethereumjs-util");
var _assetsControllers = require("@metamask/assets-controllers");
var _selectors = require("../../../selectors");
var _metamask = require("../../../ducks/metamask/metamask");
var _util = require("../../../../app/scripts/lib/util");
var _useFormatters = require("../../../hooks/useFormatters");
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../component-library");
var _util2 = require("../../../helpers/utils/util");
var _useAccountTotalCrossChainFiatBalance = require("../../../hooks/useAccountTotalCrossChainFiatBalance");
var _useGetFormattedTokensPerChain = require("../../../hooks/useGetFormattedTokensPerChain");
var _skeleton = require("../../component-library/skeleton");
var _numberUtils = require("../../../helpers/utils/number-utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

const AggregatedPercentageOverviewCrossChains = ({
  portfolioButton
}) => {
  const {
    formatCurrencyCompact
  } = (0, _useFormatters.useFormatters)();
  const fiatCurrency = (0, _reactRedux.useSelector)(_metamask.getCurrentCurrency);
  const {
    privacyMode
  } = (0, _reactRedux.useSelector)(_selectors.getPreferences);
  const selectedAccount = (0, _reactRedux.useSelector)(_selectors.getSelectedAccount);
  const shouldHideZeroBalanceTokens = (0, _reactRedux.useSelector)(_selectors.getShouldHideZeroBalanceTokens);
  const crossChainMarketData = (0, _reactRedux.useSelector)(_selectors.getMarketData);
  const allChainIDs = (0, _reactRedux.useSelector)(_selectors.getChainIdsToPoll);
  const {
    formattedTokensWithBalancesPerChain
  } = (0, _useGetFormattedTokensPerChain.useGetFormattedTokensPerChain)(selectedAccount, shouldHideZeroBalanceTokens, false, allChainIDs);
  const {
    totalFiatBalance: totalFiatCrossChains,
    tokenFiatBalancesCrossChains
  } = (0, _useAccountTotalCrossChainFiatBalance.useAccountTotalCrossChainFiatBalance)(selectedAccount, formattedTokensWithBalancesPerChain);
  const anyEnabledNetworksAreAvailable = (0, _reactRedux.useSelector)(_selectors.selectAnyEnabledNetworksAreAvailable);
  const getPerChainTotalFiat1dAgo = (chainId, tokenFiatBalances, tokensWithBalances) => {
    const totalPerChain1dAgoERC20 = tokensWithBalances.reduce((total1dAgo, item, idx) => {
      var _crossChainMarketData;
      const found = crossChainMarketData === null || crossChainMarketData === void 0 || (_crossChainMarketData = crossChainMarketData[chainId]) === null || _crossChainMarketData === void 0 ? void 0 : _crossChainMarketData[(0, _ethereumjsUtil.toChecksumAddress)(item.address)];
      const tokenFiat1dAgo = (0, _util2.getCalculatedTokenAmount1dAgo)(tokenFiatBalances[idx], found === null || found === void 0 ? void 0 : found.pricePercentChange1d);
      return total1dAgo + Number(tokenFiat1dAgo);
    }, 0);
    return totalPerChain1dAgoERC20;
  };
  const totalFiat1dAgoCrossChains = (0, _react.useMemo)(() => {
    return tokenFiatBalancesCrossChains.reduce((total1dAgoCrossChains, item) => {
      var _crossChainMarketData2;
      const perChainERC20Total = getPerChainTotalFiat1dAgo(item.chainId, item.tokenFiatBalances, item.tokensWithBalances);
      const nativePricePercentChange1d = crossChainMarketData === null || crossChainMarketData === void 0 || (_crossChainMarketData2 = crossChainMarketData[item.chainId]) === null || _crossChainMarketData2 === void 0 || (_crossChainMarketData2 = _crossChainMarketData2[(0, _assetsControllers.getNativeTokenAddress)(item.chainId)]) === null || _crossChainMarketData2 === void 0 ? void 0 : _crossChainMarketData2.pricePercentChange1d;
      const nativeFiat1dAgo = (0, _util2.getCalculatedTokenAmount1dAgo)(item.nativeFiatValue, nativePricePercentChange1d);
      return total1dAgoCrossChains + perChainERC20Total + Number(nativeFiat1dAgo);
    }, 0); // Initial total1dAgo is 0
  }, [tokenFiatBalancesCrossChains, crossChainMarketData]);
  const totalCrossChainBalance = Number(totalFiatCrossChains);
  const crossChainTotalBalance1dAgo = totalFiat1dAgoCrossChains;
  const amountChangeCrossChains = totalCrossChainBalance - crossChainTotalBalance1dAgo;
  const percentageChangeCrossChains = crossChainTotalBalance1dAgo === 0 ? 0 : amountChangeCrossChains / crossChainTotalBalance1dAgo * 100;
  const formattedPercentChangeCrossChains = (0, _util.formatValue)(amountChangeCrossChains === 0 ? 0 : percentageChangeCrossChains, true);
  let formattedAmountChangeCrossChains = '';
  if ((0, _util.isValidAmount)(amountChangeCrossChains)) {
    formattedAmountChangeCrossChains = amountChangeCrossChains >= 0 ? '+' : '';
    formattedAmountChangeCrossChains += formatCurrencyCompact(amountChangeCrossChains, fiatCurrency);
  }
  let color = _designSystem.TextColor.textDefault;
  if (!privacyMode && (0, _util.isValidAmount)(amountChangeCrossChains)) {
    if (amountChangeCrossChains === 0) {
      color = _designSystem.TextColor.textDefault;
    } else if (amountChangeCrossChains > 0) {
      color = _designSystem.TextColor.successDefault;
    } else {
      color = _designSystem.TextColor.errorDefault;
    }
  } else {
    color = _designSystem.TextColor.textAlternative;
  }
  return /*#__PURE__*/_react.default.createElement(_skeleton.Skeleton, {
    isLoading: !anyEnabledNetworksAreAvailable && (0, _numberUtils.isZeroAmount)(formattedAmountChangeCrossChains)
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    className: "gap-1"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.SensitiveText, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: color,
    "data-testid": "aggregated-value-change",
    style: {
      whiteSpace: 'pre'
    },
    isHidden: privacyMode,
    ellipsis: true,
    length: "10"
  }, formattedAmountChangeCrossChains), /*#__PURE__*/_react.default.createElement(_componentLibrary.SensitiveText, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: color,
    "data-testid": "aggregated-percentage-change",
    isHidden: privacyMode,
    ellipsis: true,
    length: "10"
  }, formattedPercentChangeCrossChains)), portfolioButton());
};
exports.AggregatedPercentageOverviewCrossChains = AggregatedPercentageOverviewCrossChains;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\wallet-overview\\aggregated-percentage-overview-cross-chains.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\wallet-overview\\aggregated-percentage-overview.tsx", {"../../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../ducks/locale/locale":"D:\\code\\v\\metamask-extension\\ui\\ducks\\locale\\locale.ts","../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/number-utils":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\number-utils.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../hooks/useAccountTotalFiatBalance":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAccountTotalFiatBalance.js","../../../hooks/useFormatters":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useFormatters.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/assets":"D:\\code\\v\\metamask-extension\\ui\\selectors\\assets.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../component-library/skeleton":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\skeleton\\index.ts","../assets/util/formatWithThreshold":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\util\\formatWithThreshold.ts","@metamask/assets-controllers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\index.cjs","ethereumjs-util":"D:\\code\\v\\metamask-extension\\node_modules\\ethereumjs-util\\dist.browser\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cwallet-overview%5Caggregated-percentage-overview.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AggregatedPercentageOverview = exports.AggregatedMultichainPercentageOverview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _ethereumjsUtil = require("ethereumjs-util");
var _assetsControllers = require("@metamask/assets-controllers");
var _metamask = require("../../../ducks/metamask/metamask");
var _selectors = require("../../../selectors");
var _networks = require("../../../../shared/modules/selectors/networks");
var _useAccountTotalFiatBalance = require("../../../hooks/useAccountTotalFiatBalance");
var _util = require("../../../../app/scripts/lib/util");
var _locale = require("../../../ducks/locale/locale");
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../component-library");
var _util2 = require("../../../helpers/utils/util");
var _assets = require("../../../selectors/assets");
var _formatWithThreshold = require("../assets/util/formatWithThreshold");
var _useFormatters = require("../../../hooks/useFormatters");
var _numberUtils = require("../../../helpers/utils/number-utils");
var _skeleton = require("../../component-library/skeleton");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

// core already has this exported type but its not yet available in this version
// todo remove this and use core type once available

const AggregatedPercentageOverview = ({
  portfolioButton
}) => {
  const tokensMarketData = (0, _reactRedux.useSelector)(_selectors.getTokensMarketData);
  const {
    formatCurrencyCompact
  } = (0, _useFormatters.useFormatters)();
  const fiatCurrency = (0, _reactRedux.useSelector)(_metamask.getCurrentCurrency);
  const {
    privacyMode
  } = (0, _reactRedux.useSelector)(_selectors.getPreferences);
  const selectedAccount = (0, _reactRedux.useSelector)(_selectors.getSelectedAccount);
  const currentChainId = (0, _reactRedux.useSelector)(_networks.getCurrentChainId);
  const shouldHideZeroBalanceTokens = (0, _reactRedux.useSelector)(_selectors.getShouldHideZeroBalanceTokens);
  // Get total balance (native + tokens)
  const {
    totalFiatBalance,
    orderedTokenList
  } = (0, _useAccountTotalFiatBalance.useAccountTotalFiatBalance)(selectedAccount, shouldHideZeroBalanceTokens);
  const anyEnabledNetworksAreAvailable = (0, _reactRedux.useSelector)(_selectors.selectAnyEnabledNetworksAreAvailable);

  // Memoize the calculation to avoid recalculating unless orderedTokenList or tokensMarketData changes
  const totalFiat1dAgo = (0, _react.useMemo)(() => {
    return orderedTokenList.reduce((total1dAgo, item) => {
      var _tokensMarketData$get;
      if (item.address) {
        // This is a regular ERC20 token
        // find the relevant pricePercentChange1d in tokensMarketData
        // Find the corresponding market data for the token by filtering the values of the tokensMarketData object
        const found = tokensMarketData === null || tokensMarketData === void 0 ? void 0 : tokensMarketData[(0, _ethereumjsUtil.toChecksumAddress)(item.address)];
        const tokenFiat1dAgo = (0, _util2.getCalculatedTokenAmount1dAgo)(item.fiatBalance, found === null || found === void 0 ? void 0 : found.pricePercentChange1d);
        return total1dAgo + Number(tokenFiat1dAgo);
      }
      // native token
      const nativePricePercentChange1d = tokensMarketData === null || tokensMarketData === void 0 || (_tokensMarketData$get = tokensMarketData[(0, _assetsControllers.getNativeTokenAddress)(currentChainId)]) === null || _tokensMarketData$get === void 0 ? void 0 : _tokensMarketData$get.pricePercentChange1d;
      const nativeFiat1dAgo = (0, _util2.getCalculatedTokenAmount1dAgo)(item.fiatBalance, nativePricePercentChange1d);
      return total1dAgo + Number(nativeFiat1dAgo);
    }, 0); // Initial total1dAgo is 0
  }, [orderedTokenList, tokensMarketData, currentChainId]); // Dependencies: recalculate if orderedTokenList or tokensMarketData changes

  const totalBalance = Number(totalFiatBalance);
  const totalBalance1dAgo = totalFiat1dAgo;
  const amountChange = totalBalance - totalBalance1dAgo;
  const percentageChange = amountChange / totalBalance1dAgo * 100 || 0;
  const formattedPercentChange = (0, _util.formatValue)(amountChange === 0 ? 0 : percentageChange, true);
  let formattedAmountChange = '';
  if ((0, _util.isValidAmount)(amountChange)) {
    formattedAmountChange = amountChange >= 0 ? '+' : '';
    formattedAmountChange += formatCurrencyCompact(amountChange, fiatCurrency);
  }
  let color = _designSystem.TextColor.textAlternative;
  if (!privacyMode && (0, _util.isValidAmount)(amountChange)) {
    if (amountChange === 0) {
      color = _designSystem.TextColor.textAlternative;
    } else if (amountChange > 0) {
      color = _designSystem.TextColor.successDefault;
    } else {
      color = _designSystem.TextColor.errorDefault;
    }
  } else {
    color = _designSystem.TextColor.textAlternative;
  }
  return /*#__PURE__*/_react.default.createElement(_skeleton.Skeleton, {
    isLoading: !anyEnabledNetworksAreAvailable && (0, _numberUtils.isZeroAmount)(amountChange)
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    className: "gap-1"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.SensitiveText, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: color,
    "data-testid": "aggregated-value-change",
    style: {
      whiteSpace: 'pre'
    },
    isHidden: privacyMode,
    ellipsis: true,
    length: "10"
  }, formattedAmountChange), /*#__PURE__*/_react.default.createElement(_componentLibrary.SensitiveText, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: color,
    "data-testid": "aggregated-percentage-change",
    isHidden: privacyMode,
    ellipsis: true,
    length: "10"
  }, formattedPercentChange)), portfolioButton());
};
exports.AggregatedPercentageOverview = AggregatedPercentageOverview;
const AggregatedMultichainPercentageOverview = ({
  portfolioButton,
  privacyMode = false
}) => {
  const locale = (0, _reactRedux.useSelector)(_locale.getIntlLocale);
  const currentCurrency = (0, _reactRedux.useSelector)(_metamask.getCurrentCurrency);
  const selectedAccount = (0, _reactRedux.useSelector)(_selectors.getSelectedInternalAccount);
  const historicalAggregatedBalances = (0, _reactRedux.useSelector)(state => (0, _assets.getHistoricalMultichainAggregatedBalance)(state, selectedAccount));
  const anyEnabledNetworksAreAvailable = (0, _reactRedux.useSelector)(_selectors.selectAnyEnabledNetworksAreAvailable);
  let color = _designSystem.TextColor.textAlternative;
  const singleDayPercentChange = historicalAggregatedBalances.P1D.percentChange;
  const singleDayAmountChange = historicalAggregatedBalances.P1D.amountChange;
  const signPrefix = singleDayPercentChange >= 0 ? '+' : '-';
  if (!privacyMode && (0, _util.isValidAmount)(singleDayPercentChange)) {
    if (singleDayPercentChange === 0) {
      color = _designSystem.TextColor.textAlternative;
    } else if (singleDayPercentChange > 0) {
      color = _designSystem.TextColor.successDefault;
    } else {
      color = _designSystem.TextColor.errorDefault;
    }
  } else {
    color = _designSystem.TextColor.textAlternative;
  }
  const localizedAmountChange = (0, _formatWithThreshold.formatWithThreshold)(Math.abs(singleDayAmountChange), 0.01, locale, {
    style: 'currency',
    currency: currentCurrency
  });
  const localizedPercentChange = (0, _formatWithThreshold.formatWithThreshold)(Math.abs(singleDayPercentChange) / 100, 0.0001, locale, {
    style: 'percent',
    maximumFractionDigits: 2,
    minimumFractionDigits: 2
  });
  return /*#__PURE__*/_react.default.createElement(_skeleton.Skeleton, {
    isLoading: !anyEnabledNetworksAreAvailable && (0, _numberUtils.isZeroAmount)(singleDayAmountChange)
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.SensitiveText, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: color,
    "data-testid": "aggregated-value-change",
    style: {
      whiteSpace: 'pre'
    },
    isHidden: privacyMode,
    ellipsis: true,
    length: "10"
  }, signPrefix, localizedAmountChange, ' '), /*#__PURE__*/_react.default.createElement(_componentLibrary.SensitiveText, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: color,
    "data-testid": "aggregated-percentage-change",
    isHidden: privacyMode,
    ellipsis: true,
    length: "10"
  }, "(", signPrefix, localizedPercentChange, ")")), portfolioButton());
};
exports.AggregatedMultichainPercentageOverview = AggregatedMultichainPercentageOverview;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\wallet-overview\\aggregated-percentage-overview.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\wallet-overview\\coin-buttons.tsx", {"../../../../shared/constants/bridge":"D:\\code\\v\\metamask-extension\\shared\\constants\\bridge.ts","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../ducks/send":"D:\\code\\v\\metamask-extension\\ui\\ducks\\send\\index.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../hooks/bridge/useBridging":"D:\\code\\v\\metamask-extension\\ui\\hooks\\bridge\\useBridging.ts","../../../hooks/ramps/useRamps/useRamps":"D:\\code\\v\\metamask-extension\\ui\\hooks\\ramps\\useRamps\\useRamps.ts","../../../hooks/useMultichainSelector":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainSelector.ts","../../../pages/confirmations/hooks/useRedesignedSendFlow":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useRedesignedSendFlow.ts","../../../pages/confirmations/utils/send":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\utils\\send.ts","../../../pages/multichain-accounts/multichain-account-address-list-page":"D:\\code\\v\\metamask-extension\\ui\\pages\\multichain-accounts\\multichain-account-address-list-page\\index.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","../../../selectors/multichain-accounts/feature-flags":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\feature-flags.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../multichain/receive-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\receive-modal\\index.js","../../ui/icon-button":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\icon-button\\index.ts","../../ui/tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\index.js","./hooks/useHandleSendNonEvm":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\wallet-overview\\hooks\\useHandleSendNonEvm.ts","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cwallet-overview%5Ccoin-buttons.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _controllerUtils = require("@metamask/controller-utils");
var _utils = require("@metamask/utils");
var _bridgeController = require("@metamask/bridge-controller");
var _keyringApi = require("@metamask/keyring-api");
var _i18n = require("../../../contexts/i18n");
var _routes = require("../../../helpers/constants/routes");
var _multichainAccountAddressListPage = require("../../../pages/multichain-accounts/multichain-account-address-list-page");
var _selectors = require("../../../selectors");
var _featureFlags = require("../../../selectors/multichain-accounts/feature-flags");
var _accountTree = require("../../../selectors/multichain-accounts/account-tree");
var _tooltip = _interopRequireDefault(require("../../ui/tooltip"));
var _metametrics = require("../../../../shared/constants/metametrics");
var _transaction = require("../../../../shared/constants/transaction");
var _metametrics2 = require("../../../contexts/metametrics");
var _send = require("../../../ducks/send");
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../component-library");
var _iconButton = _interopRequireDefault(require("../../ui/icon-button"));
var _useRamps = _interopRequireDefault(require("../../../hooks/ramps/useRamps/useRamps"));
var _useBridging = _interopRequireDefault(require("../../../hooks/bridge/useBridging"));
var _receiveModal = require("../../multichain/receive-modal");
var _actions = require("../../../store/actions");
var _multichain = require("../../../selectors/multichain");
var _useMultichainSelector = require("../../../hooks/useMultichainSelector");
var _networks = require("../../../../shared/modules/selectors/networks");
var _bridge = require("../../../../shared/constants/bridge");
var _trace = require("../../../../shared/lib/trace");
var _send2 = require("../../../pages/confirmations/utils/send");
var _useRedesignedSendFlow = require("../../../pages/confirmations/hooks/useRedesignedSendFlow");
var _useHandleSendNonEvm = require("./hooks/useHandleSendNonEvm");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
///: BEGIN:ONLY_INCLUDE_IF(multichain)

///: END:ONLY_INCLUDE_IF

///: BEGIN:ONLY_INCLUDE_IF(multichain)

///: END:ONLY_INCLUDE_IF

const CoinButtons = ({
  account,
  chainId,
  trackingLocation,
  isSwapsChain,
  isSigningEnabled,
  isBuyableChain,
  classPrefix = 'coin'
}) => {
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const dispatch = (0, _reactRedux.useDispatch)();
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const [showReceiveModal, setShowReceiveModal] = (0, _react.useState)(false);
  const {
    address: selectedAddress
  } = account;
  const history = (0, _reactRouterDom.useHistory)();
  const networks = (0, _reactRedux.useSelector)(_selectors.getNetworkConfigurationIdByChainId);
  const currentChainId = (0, _reactRedux.useSelector)(_networks.getCurrentChainId);
  const displayNewIconButtons = true;
  const {
    enabled: isSendRedesignEnabled
  } = (0, _useRedesignedSendFlow.useRedesignedSendFlow)();

  // Multichain accounts feature flag and selected account group
  const isMultichainAccountsState2Enabled = (0, _reactRedux.useSelector)(_featureFlags.getIsMultichainAccountsState2Enabled);
  const selectedAccountGroup = (0, _reactRedux.useSelector)(_accountTree.getSelectedAccountGroup);
  const defaultSwapsToken = (0, _reactRedux.useSelector)(state => (0, _selectors.getSwapsDefaultToken)(state, chainId.toString()));

  // Pre-conditions
  if (isSwapsChain && defaultSwapsToken === undefined) {
    throw new Error('defaultSwapsToken is required');
  }

  ///: BEGIN:ONLY_INCLUDE_IF(multichain)
  const handleSendNonEvm = (0, _useHandleSendNonEvm.useHandleSendNonEvm)();
  ///: END:ONLY_INCLUDE_IF

  const location = (0, _reactRouterDom.useLocation)();

  // Initially, those events were using a "ETH" as `token_symbol`, so we keep this behavior
  // for EVM, no matter the currently selected native token (e.g. SepoliaETH if you are on Sepolia
  // network).
  const {
    isEvmNetwork,
    chainId: multichainChainId
  } = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainNetwork, account);
  const multichainNativeToken = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainNativeCurrency, account);
  const nativeToken = isEvmNetwork ? 'ETH' : multichainNativeToken;
  const isExternalServicesEnabled = (0, _reactRedux.useSelector)(_selectors.getUseExternalServices);
  const isNonEvmAccountWithoutExternalServices = !isExternalServicesEnabled && (0, _selectors.isNonEvmAccount)(account);
  const buttonTooltips = {
    buyButton: [{
      condition: !isBuyableChain,
      message: ''
    }],
    sendButton: [{
      condition: !isSigningEnabled,
      message: 'methodNotSupported'
    }],
    swapButton: [{
      condition: !isExternalServicesEnabled,
      message: 'currentlyUnavailable'
    }, {
      condition: !isSigningEnabled,
      message: 'methodNotSupported'
    }],
    bridgeButton: [{
      condition: !isSigningEnabled,
      message: 'methodNotSupported'
    }]
  };
  const generateTooltip = (buttonKey, contents) => {
    const conditions = buttonTooltips[buttonKey];
    const tooltipInfo = conditions.find(({
      condition
    }) => condition);
    if (tooltipInfo !== null && tooltipInfo !== void 0 && tooltipInfo.message) {
      return /*#__PURE__*/_react.default.createElement(_tooltip.default, {
        title: t(tooltipInfo.message),
        position: "bottom",
        wrapperClassName: "tooltip-button-wrapper"
      }, contents);
    }
    return contents;
  };
  const getChainId = () => {
    if ((0, _utils.isCaipChainId)(chainId)) {
      return chainId;
    }
    // Otherwise we assume that's an EVM chain ID, so use the usual 0x prefix
    return (0, _controllerUtils.toHex)(chainId);
  };
  const getSnapAccountMetaMetricsPropertiesIfAny = (internalAccount
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
  // eslint-disable-next-line @typescript-eslint/naming-convention
  ) => {
    var _internalAccount$meta;
    // Some accounts might be Snap accounts, in this case we add some extra properties
    // to the metrics:
    const snapId = (_internalAccount$meta = internalAccount.metadata.snap) === null || _internalAccount$meta === void 0 ? void 0 : _internalAccount$meta.id;
    if (snapId) {
      return {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        snap_id: snapId
      };
    }

    // If the account is not a Snap account or that we could not get the Snap ID for
    // some reason, we don't add any extra property.
    return {};
  };
  const {
    openBuyCryptoInPdapp
  } = (0, _useRamps.default)();
  const {
    openBridgeExperience
  } = (0, _useBridging.default)();
  const setCorrectChain = (0, _react.useCallback)(async () => {
    if (currentChainId !== chainId && multichainChainId !== chainId && !isMultichainAccountsState2Enabled) {
      try {
        const networkConfigurationId = networks[chainId];
        await dispatch((0, _actions.setActiveNetworkWithError)(networkConfigurationId));
      } catch (err) {
        console.error(`Failed to switch chains.
        Target chainId: ${chainId}, Current chainId: ${currentChainId}.
        ${
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31893
        // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
        err}`);
        throw err;
      }
    }
  }, [isMultichainAccountsState2Enabled, currentChainId, multichainChainId, chainId, networks, dispatch]);
  const handleSendOnClick = (0, _react.useCallback)(async () => {
    trackEvent({
      event: _metametrics.MetaMetricsEventName.SendStarted,
      category: _metametrics.MetaMetricsEventCategory.Navigation,
      properties: {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        account_type: account.type,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        token_symbol: nativeToken,
        location: 'Home',
        text: 'Send',
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        chain_id: chainId,
        ...getSnapAccountMetaMetricsPropertiesIfAny(account)
      }
    }, {
      excludeMetaMetricsId: false
    });

    ///: BEGIN:ONLY_INCLUDE_IF(multichain)
    if (!(0, _keyringApi.isEvmAccountType)(account.type) && !isSendRedesignEnabled) {
      await handleSendNonEvm();
      // Early return, not to let the non-EVM flow slip into the native send flow.
      return;
    }
    ///: END:ONLY_INCLUDE_IF

    // Native Send flow
    await setCorrectChain();
    await dispatch((0, _send.startNewDraftTransaction)({
      type: _transaction.AssetType.native
    }));
    let params;
    if (trackingLocation !== 'home') {
      params = {
        chainId: chainId.toString()
      };
    }
    (0, _send2.navigateToSendRoute)(history, isSendRedesignEnabled, params);
  }, [chainId, account, setCorrectChain, isSendRedesignEnabled,
  ///: BEGIN:ONLY_INCLUDE_IF(multichain)
  handleSendNonEvm,
  ///: END:ONLY_INCLUDE_IF
  trackingLocation]);
  const handleBuyAndSellOnClick = (0, _react.useCallback)(() => {
    openBuyCryptoInPdapp(getChainId());
    trackEvent({
      event: _metametrics.MetaMetricsEventName.NavBuyButtonClicked,
      category: _metametrics.MetaMetricsEventCategory.Navigation,
      properties: {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        account_type: account.type,
        location: 'Home',
        text: 'Buy',
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        chain_id: chainId,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        token_symbol: defaultSwapsToken,
        ...getSnapAccountMetaMetricsPropertiesIfAny(account)
      }
    });
  }, [chainId, defaultSwapsToken]);
  const handleSwapOnClick = (0, _react.useCallback)(async () => {
    // Determine the chainId to use in the Swap experience using the url
    const urlSuffix = location.pathname.split('/').filter(Boolean).at(-1);
    const hexChainOrAssetId = urlSuffix ? decodeURIComponent(urlSuffix) : undefined;
    const chainIdToUse = (0, _utils.isCaipAssetType)(hexChainOrAssetId) ? (0, _utils.parseCaipAssetType)(hexChainOrAssetId).chainId : hexChainOrAssetId;

    // Handle clicking from the wallet or native asset overview page
    openBridgeExperience(_metametrics.MetaMetricsSwapsEventSource.MainView, chainIdToUse && _bridge.ALL_ALLOWED_BRIDGE_CHAIN_IDS.includes(chainIdToUse) ? (0, _bridgeController.getNativeAssetForChainId)(chainIdToUse) : undefined);
  }, [location, openBridgeExperience]);
  const handleReceiveOnClick = (0, _react.useCallback)(() => {
    (0, _trace.trace)({
      name: _trace.TraceName.ReceiveModal
    });
    trackEvent({
      event: _metametrics.MetaMetricsEventName.NavReceiveButtonClicked,
      category: _metametrics.MetaMetricsEventCategory.Navigation,
      properties: {
        text: 'Receive',
        location: trackingLocation,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        chain_id: chainId
      }
    });
    if (isMultichainAccountsState2Enabled && selectedAccountGroup) {
      // Navigate to the multichain address list page with receive source
      history.push(`${_routes.MULTICHAIN_ACCOUNT_ADDRESS_LIST_PAGE_ROUTE}/${encodeURIComponent(selectedAccountGroup)}?${_multichainAccountAddressListPage.AddressListQueryParams.Source}=${_multichainAccountAddressListPage.AddressListSource.Receive}`);
    } else {
      // Show the traditional receive modal
      setShowReceiveModal(true);
    }
  }, [isMultichainAccountsState2Enabled, selectedAccountGroup, history, trackEvent, trackingLocation, chainId]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    width: _designSystem.BlockSize.Full,
    gap: 3
  }, /*#__PURE__*/_react.default.createElement(_iconButton.default, {
    className: `${classPrefix}-overview__button`,
    Icon: displayNewIconButtons ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
      name: _componentLibrary.IconName.Dollar,
      color: _designSystem.IconColor.iconAlternative,
      size: _componentLibrary.IconSize.Md
    }) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
      name: _componentLibrary.IconName.PlusAndMinus,
      color: _designSystem.IconColor.iconDefault,
      size: _componentLibrary.IconSize.Sm
    }),
    disabled: !isBuyableChain,
    "data-testid": `${classPrefix}-overview-buy`,
    label: t('buy'),
    onClick: handleBuyAndSellOnClick,
    width: _designSystem.BlockSize.Full,
    tooltipRender: contents => generateTooltip('buyButton', contents)
  }), /*#__PURE__*/_react.default.createElement(_iconButton.default, {
    className: `${classPrefix}-overview__button`,
    disabled: !isSigningEnabled || !isExternalServicesEnabled,
    Icon: displayNewIconButtons ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
      name: _componentLibrary.IconName.SwapVertical,
      color: _designSystem.IconColor.iconAlternative,
      size: _componentLibrary.IconSize.Md
    }) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
      name: _componentLibrary.IconName.SwapVertical,
      color: _designSystem.IconColor.iconDefault,
      size: _componentLibrary.IconSize.Sm
    }),
    onClick: handleSwapOnClick,
    label: t('swap'),
    "data-testid": `${classPrefix}-overview-swap`,
    width: _designSystem.BlockSize.Full,
    tooltipRender: contents => generateTooltip('swapButton', contents)
  }), /*#__PURE__*/_react.default.createElement(_iconButton.default, {
    className: `${classPrefix}-overview__button`,
    "data-testid": `${classPrefix}-overview-send`,
    Icon: displayNewIconButtons ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
      name: _componentLibrary.IconName.Send,
      color: _designSystem.IconColor.iconAlternative,
      size: _componentLibrary.IconSize.Md
    }) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
      name: _componentLibrary.IconName.Arrow2UpRight,
      color: _designSystem.IconColor.iconDefault,
      size: _componentLibrary.IconSize.Sm
    }),
    disabled: !isSigningEnabled || isNonEvmAccountWithoutExternalServices,
    label: t('send'),
    onClick: handleSendOnClick,
    width: _designSystem.BlockSize.Full,
    tooltipRender: contents => generateTooltip('sendButton', contents)
  }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showReceiveModal && /*#__PURE__*/_react.default.createElement(_receiveModal.ReceiveModal, {
    address: selectedAddress,
    onClose: () => setShowReceiveModal(false)
  }), /*#__PURE__*/_react.default.createElement(_iconButton.default, {
    className: `${classPrefix}-overview__button`,
    "data-testid": `${classPrefix}-overview-receive`,
    Icon: displayNewIconButtons ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
      name: _componentLibrary.IconName.Received,
      color: _designSystem.IconColor.iconAlternative,
      size: _componentLibrary.IconSize.Md
    }) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
      name: _componentLibrary.IconName.ScanBarcode,
      color: _designSystem.IconColor.iconDefault,
      size: _componentLibrary.IconSize.Sm
    }),
    label: t('receive'),
    width: _designSystem.BlockSize.Full,
    onClick: handleReceiveOnClick
  })));
};
var _default = exports.default = CoinButtons;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\wallet-overview\\coin-buttons.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\wallet-overview\\coin-overview.tsx", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/common":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\common.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/number-utils":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\number-utils.ts","../../../helpers/utils/portfolio":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\portfolio.js","../../../hooks/useAccountTotalCrossChainFiatBalance":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAccountTotalCrossChainFiatBalance.ts","../../../hooks/useGetFormattedTokensPerChain":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useGetFormattedTokensPerChain.ts","../../../hooks/useMultichainSelector":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainSelector.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../component-library/skeleton":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\skeleton\\index.ts","../../multichain/token-list-item/price/percentage-and-amount-change/percentage-and-amount-change":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\token-list-item\\price\\percentage-and-amount-change\\percentage-and-amount-change.tsx","../../ui/aggregated-balance/aggregated-balance":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\aggregated-balance\\aggregated-balance.tsx","../../ui/tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\index.js","../assets/account-group-balance-change/account-group-balance-change":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\account-group-balance-change\\account-group-balance-change.tsx","../assets/account-group-balance/account-group-balance":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\account-group-balance\\account-group-balance.tsx","../user-preferenced-currency-display":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\user-preferenced-currency-display\\index.js","./aggregated-percentage-overview":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\wallet-overview\\aggregated-percentage-overview.tsx","./aggregated-percentage-overview-cross-chains":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\wallet-overview\\aggregated-percentage-overview-cross-chains.tsx","./coin-buttons":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\wallet-overview\\coin-buttons.tsx","./wallet-overview":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\wallet-overview\\wallet-overview.js","@metamask/assets-controllers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\index.cjs","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cwallet-overview%5Ccoin-overview.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LegacyAggregatedBalance = exports.CoinOverview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _classnames = _interopRequireDefault(require("classnames"));
var _assetsControllers = require("@metamask/assets-controllers");
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _portfolio = require("../../../helpers/utils/portfolio");
var _metametrics = require("../../../contexts/metametrics");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _i18n = require("../../../contexts/i18n");
var _tooltip = _interopRequireDefault(require("../../ui/tooltip"));
var _userPreferencedCurrencyDisplay = _interopRequireDefault(require("../user-preferenced-currency-display"));
var _common = require("../../../helpers/constants/common");
var _selectors = require("../../../selectors");
var _percentageAndAmountChange = require("../../multichain/token-list-item/price/percentage-and-amount-change/percentage-and-amount-change");
var _accountGroupBalance = require("../assets/account-group-balance/account-group-balance");
var _accountGroupBalanceChange = require("../assets/account-group-balance-change/account-group-balance-change");
var _multichain = require("../../../selectors/multichain");
var _actions = require("../../../store/actions");
var _useAccountTotalCrossChainFiatBalance = require("../../../hooks/useAccountTotalCrossChainFiatBalance");
var _useGetFormattedTokensPerChain = require("../../../hooks/useGetFormattedTokensPerChain");
var _useMultichainSelector = require("../../../hooks/useMultichainSelector");
var _aggregatedBalance = require("../../ui/aggregated-balance/aggregated-balance");
var _skeleton = require("../../component-library/skeleton");
var _numberUtils = require("../../../helpers/utils/number-utils");
var _walletOverview = _interopRequireDefault(require("./wallet-overview"));
var _coinButtons = _interopRequireDefault(require("./coin-buttons"));
var _aggregatedPercentageOverview = require("./aggregated-percentage-overview");
var _aggregatedPercentageOverviewCrossChains = require("./aggregated-percentage-overview-cross-chains");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LegacyAggregatedBalance = ({
  classPrefix,
  account,
  balance,
  balanceIsCached,
  handleSensitiveToggle
}) => {
  const isTokenNetworkFilterEqualCurrentNetwork = (0, _reactRedux.useSelector)(_selectors.getIsTokenNetworkFilterEqualCurrentNetwork);
  const shouldHideZeroBalanceTokens = (0, _reactRedux.useSelector)(_selectors.getShouldHideZeroBalanceTokens);
  const enabledNetworks = (0, _reactRedux.useSelector)(_selectors.getEnabledNetworksByNamespace);
  const allChainIDs = (0, _reactRedux.useSelector)(_selectors.getChainIdsToPoll);
  const shouldShowFiat = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainShouldShowFiat, account);
  const {
    privacyMode,
    showNativeTokenAsMainBalance
  } = (0, _reactRedux.useSelector)(_selectors.getPreferences);
  const isTestnet = (0, _reactRedux.useSelector)(_selectors.getIsTestnet);
  const {
    formattedTokensWithBalancesPerChain
  } = (0, _useGetFormattedTokensPerChain.useGetFormattedTokensPerChain)(account, shouldHideZeroBalanceTokens, isTokenNetworkFilterEqualCurrentNetwork, allChainIDs);
  const {
    totalFiatBalance
  } = (0, _useAccountTotalCrossChainFiatBalance.useAccountTotalCrossChainFiatBalance)(account, formattedTokensWithBalancesPerChain);
  const anyEnabledNetworksAreAvailable = (0, _reactRedux.useSelector)(_selectors.selectAnyEnabledNetworksAreAvailable);
  const showNativeTokenAsMain = _selectors.isGlobalNetworkSelectorRemoved ? showNativeTokenAsMainBalance && Object.keys(enabledNetworks).length === 1 : showNativeTokenAsMainBalance;
  const isNotAggregatedFiatBalance = !shouldShowFiat || showNativeTokenAsMain || isTestnet;
  let balanceToDisplay;
  if (isNotAggregatedFiatBalance) {
    balanceToDisplay = balance;
  } else {
    balanceToDisplay = totalFiatBalance;
  }

  /**
   * Determines the currency display type based on network configuration.
   * Returns SECONDARY for multi-network setups when global network selector is removed,
   * otherwise returns PRIMARY for single network or legacy configurations.
   */
  const getCurrencyDisplayType = () => {
    const isMultiNetwork = Object.keys(enabledNetworks).length > 1;
    if (_selectors.isGlobalNetworkSelectorRemoved) {
      if (isMultiNetwork && showNativeTokenAsMainBalance) {
        return _common.SECONDARY;
      }
      return _common.PRIMARY;
    }
    return _common.PRIMARY;
  };
  return /*#__PURE__*/_react.default.createElement(_skeleton.Skeleton, {
    isLoading: !anyEnabledNetworksAreAvailable && (0, _numberUtils.isZeroAmount)(balanceToDisplay),
    marginBottom: 1
  }, /*#__PURE__*/_react.default.createElement(_userPreferencedCurrencyDisplay.default, {
    style: {
      display: 'contents'
    },
    account: account,
    className: (0, _classnames.default)(`${classPrefix}-overview__primary-balance`, {
      [`${classPrefix}-overview__cached-balance`]: balanceIsCached
    }),
    "data-testid": `${classPrefix}-overview__primary-currency`,
    value: balanceToDisplay,
    type: getCurrencyDisplayType(),
    ethNumberOfDecimals: 4,
    hideTitle: true,
    shouldCheckShowNativeToken: true,
    isAggregatedFiatOverviewBalance: !showNativeTokenAsMain && !isTestnet && shouldShowFiat,
    privacyMode: privacyMode,
    onClick: handleSensitiveToggle
  }));
};
exports.LegacyAggregatedBalance = LegacyAggregatedBalance;
const CoinOverview = ({
  account,
  balance,
  balanceIsCached,
  className,
  classPrefix = 'coin',
  chainId,
  isBridgeChain,
  isBuyableChain,
  isSwapsChain,
  isSigningEnabled
}) => {
  const enabledNetworks = (0, _reactRedux.useSelector)(_selectors.getEnabledNetworksByNamespace);
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const metaMetricsId = (0, _reactRedux.useSelector)(_selectors.getMetaMetricsId);
  const isMetaMetricsEnabled = (0, _reactRedux.useSelector)(_selectors.getParticipateInMetaMetrics);
  const isMarketingEnabled = (0, _reactRedux.useSelector)(_selectors.getDataCollectionForMarketing);
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    privacyMode,
    showNativeTokenAsMainBalance
  } = (0, _reactRedux.useSelector)(_selectors.getPreferences);
  const isTokenNetworkFilterEqualCurrentNetwork = (0, _reactRedux.useSelector)(_selectors.getIsTokenNetworkFilterEqualCurrentNetwork);
  const isEvm = (0, _reactRedux.useSelector)(_multichain.getMultichainIsEvm);
  const tokensMarketData = (0, _reactRedux.useSelector)(_selectors.getTokensMarketData);
  const isMultichainAccountsState2Enabled = (0, _reactRedux.useSelector)(_selectors.getIsMultichainAccountsState2Enabled);
  const anyEnabledNetworksAreAvailable = (0, _reactRedux.useSelector)(_selectors.selectAnyEnabledNetworksAreAvailable);
  const handleSensitiveToggle = () => {
    dispatch((0, _actions.setPrivacyMode)(!privacyMode));
  };
  const handlePortfolioOnClick = (0, _react.useCallback)(() => {
    const url = (0, _portfolio.getPortfolioUrl)('explore/tokens', 'ext_portfolio_button', metaMetricsId, isMetaMetricsEnabled, isMarketingEnabled);
    global.platform.openTab({
      url
    });
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.Navigation,
      event: _metametrics2.MetaMetricsEventName.PortfolioLinkClicked,
      properties: {
        location: 'Home',
        text: 'Portfolio'
      }
    });
  }, [isMarketingEnabled, isMetaMetricsEnabled, metaMetricsId, trackEvent]);
  const renderPercentageAndAmountChange = () => {
    const renderPortfolioButton = () => {
      return /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
        endIconName: _componentLibrary.IconName.Export,
        onClick: handlePortfolioOnClick,
        as: "a",
        "data-testid": "portfolio-link",
        textProps: {
          variant: _designSystem.TextVariant.bodyMdMedium
        }
      }, t('discover'));
      return null;
    };
    const renderNativeTokenView = () => {
      var _tokensMarketData$get;
      const value = tokensMarketData === null || tokensMarketData === void 0 || (_tokensMarketData$get = tokensMarketData[(0, _assetsControllers.getNativeTokenAddress)(chainId)]) === null || _tokensMarketData$get === void 0 ? void 0 : _tokensMarketData$get.pricePercentChange1d;
      return /*#__PURE__*/_react.default.createElement(_skeleton.Skeleton, {
        isLoading: !anyEnabledNetworksAreAvailable && (0, _numberUtils.isZeroAmount)(value)
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        className: "wallet-overview__currency-wrapper"
      }, /*#__PURE__*/_react.default.createElement(_percentageAndAmountChange.PercentageAndAmountChange, {
        value: value
      }), renderPortfolioButton()));
    };
    const renderAggregatedView = () => /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      className: "wallet-overview__currency-wrapper"
    }, isTokenNetworkFilterEqualCurrentNetwork ? /*#__PURE__*/_react.default.createElement(_aggregatedPercentageOverview.AggregatedPercentageOverview, {
      portfolioButton: renderPortfolioButton
    }) : /*#__PURE__*/_react.default.createElement(_aggregatedPercentageOverviewCrossChains.AggregatedPercentageOverviewCrossChains, {
      portfolioButton: renderPortfolioButton
    }));
    const renderNonEvmView = () => /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      className: "wallet-overview__currency-wrapper"
    }, /*#__PURE__*/_react.default.createElement(_aggregatedPercentageOverview.AggregatedMultichainPercentageOverview, {
      privacyMode: privacyMode,
      portfolioButton: renderPortfolioButton
    }));

    // Early exit for state2 unified view
    if (isMultichainAccountsState2Enabled) {
      return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        className: "wallet-overview__currency-wrapper"
      }, /*#__PURE__*/_react.default.createElement(_accountGroupBalanceChange.AccountGroupBalanceChange, {
        period: "1d",
        portfolioButton: renderPortfolioButton
      }));
    }
    if (!isEvm) {
      return renderNonEvmView();
    }
    return showNativeTokenAsMainBalance && Object.keys(enabledNetworks).length === 1 ? renderNativeTokenView() : renderAggregatedView();
  };
  let balanceSection;
  if (isMultichainAccountsState2Enabled) {
    balanceSection = /*#__PURE__*/_react.default.createElement(_accountGroupBalance.AccountGroupBalance, {
      classPrefix: classPrefix,
      balanceIsCached: balanceIsCached,
      handleSensitiveToggle: handleSensitiveToggle
    });
  } else if (isEvm) {
    balanceSection = /*#__PURE__*/_react.default.createElement(LegacyAggregatedBalance, {
      classPrefix: classPrefix,
      account: account,
      balance: balance,
      balanceIsCached: balanceIsCached,
      handleSensitiveToggle: handleSensitiveToggle
    });
  } else {
    balanceSection = /*#__PURE__*/_react.default.createElement(_aggregatedBalance.AggregatedBalance, {
      classPrefix: classPrefix,
      balanceIsCached: balanceIsCached,
      handleSensitiveToggle: handleSensitiveToggle
    });
  }
  return /*#__PURE__*/_react.default.createElement(_walletOverview.default, {
    balance: /*#__PURE__*/_react.default.createElement(_tooltip.default, {
      position: "top",
      title: t('balanceOutdated'),
      disabled: !balanceIsCached
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: `${classPrefix}-overview__balance [.wallet-overview-fullscreen_&]:items-center`
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: `${classPrefix}-overview__primary-container`
    }, balanceSection, balanceIsCached && /*#__PURE__*/_react.default.createElement("span", {
      className: `${classPrefix}-overview__cached-star`
    }, "*")), renderPercentageAndAmountChange())),
    buttons: /*#__PURE__*/_react.default.createElement(_coinButtons.default, {
      account,
      trackingLocation: 'home',
      chainId,
      isSwapsChain,
      isSigningEnabled,
      isBridgeChain,
      isBuyableChain,
      classPrefix
    }),
    className: className
  });
};
exports.CoinOverview = CoinOverview;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\wallet-overview\\coin-overview.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\wallet-overview\\eth-overview.js", {"../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../ducks/ramps":"D:\\code\\v\\metamask-extension\\ui\\ducks\\ramps\\index.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","./coin-overview":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\wallet-overview\\coin-overview.tsx","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cwallet-overview%5Ceth-overview.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRedux = require("react-redux");
var _keyringApi = require("@metamask/keyring-api");
var _lodash = require("lodash");
var _networks = require("../../../../shared/modules/selectors/networks");
var _selectors = require("../../../selectors");
var _ramps = require("../../../ducks/ramps");
var _coinOverview = require("./coin-overview");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const EthOverview = ({
  className
}) => {
  const isBridgeChain = (0, _reactRedux.useSelector)(_selectors.getIsBridgeChain);
  const isBuyableChain = (0, _reactRedux.useSelector)(_ramps.getIsNativeTokenBuyable);
  const balanceIsCached = (0, _reactRedux.useSelector)(_selectors.isBalanceCached);
  const chainId = (0, _reactRedux.useSelector)(_networks.getCurrentChainId);
  const balance = (0, _reactRedux.useSelector)(_selectors.getSelectedAccountCachedBalance);

  // FIXME: This causes re-renders, so use isEqual to avoid this
  const account = (0, _reactRedux.useSelector)(_selectors.getSelectedInternalAccount, _lodash.isEqual);
  const isSwapsChain = (0, _reactRedux.useSelector)(_selectors.getIsSwapsChain);
  const isSigningEnabled = account.methods.includes(_keyringApi.EthMethod.SignTransaction) || account.methods.includes(_keyringApi.EthMethod.SignUserOperation);
  return /*#__PURE__*/_react.default.createElement(_coinOverview.CoinOverview, {
    account: account,
    balance: balance,
    balanceIsCached: balanceIsCached,
    className: className,
    classPrefix: "eth",
    chainId: chainId,
    isSigningEnabled: isSigningEnabled,
    isSwapsChain: isSwapsChain,
    isBridgeChain: isBridgeChain,
    isBuyableChain: isBuyableChain
  });
};
EthOverview.propTypes = {
  className: _propTypes.default.string
};
var _default = exports.default = EthOverview;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\wallet-overview\\eth-overview.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\wallet-overview\\hooks\\useHandleSendNonEvm.ts", {"../../../../../shared/lib/accounts/snaps":"D:\\code\\v\\metamask-extension\\shared\\lib\\accounts\\snaps.ts","../../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../selectors/multichain/networks":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain\\networks.ts","../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cwallet-overview%5Chooks%5CuseHandleSendNonEvm.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHandleSendNonEvm = void 0;
var _utils = require("@metamask/utils");
var _react = require("react");
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _actions = require("../../../../store/actions");
var _selectors = require("../../../../selectors");
var _networks = require("../../../../selectors/multichain/networks");
var _snaps = require("../../../../../shared/lib/accounts/snaps");
var _routes = require("../../../../helpers/constants/routes");
/**
 * Use this hook to trigger the send flow for non-EVM accounts.
 *
 * On non-EVM, the send flow is delegated to a Snap that displays the UI,
 * builds the transaction, and sends it to the blockchain.
 *
 * @param caipAssetType - The optional CAIP asset type to use for the send flow. Defaults to the chain's native asset if not provided.
 * @returns A function that triggers the send flow for non-EVM accounts.
 */
const useHandleSendNonEvm = caipAssetType => {
  const {
    nativeCurrency
  } = (0, _reactRedux.useSelector)(_networks.getSelectedMultichainNetworkConfiguration);
  const account = (0, _reactRedux.useSelector)(_selectors.getSelectedInternalAccount);
  const history = (0, _reactRouterDom.useHistory)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const currentActivityTabName = (0, _reactRedux.useSelector)(
  // @ts-expect-error TODO: fix state type
  state => state.metamask.defaultHomeActiveTabName);
  const unapprovedTemplatedConfirmations = (0, _reactRedux.useSelector)(_selectors.getMemoizedUnapprovedTemplatedConfirmations);
  (0, _react.useEffect)(() => {
    const templatedSnapApproval = unapprovedTemplatedConfirmations.find(approval => {
      return approval.type === 'snap_dialog' && account.metadata.snap && account.metadata.snap.id === approval.origin && (0, _snaps.isMultichainWalletSnap)(account.metadata.snap.id);
    });
    if (templatedSnapApproval) {
      history.push(`${_routes.CONFIRMATION_V_NEXT_ROUTE}/${templatedSnapApproval.id}`);
    }
  }, [unapprovedTemplatedConfirmations, history, account]);
  return async () => {
    // Non-EVM (Snap) Send flow
    if (!account.metadata.snap) {
      throw new Error('Non-EVM needs to be Snap accounts');
    }

    // TODO: Remove this once we want to enable all non-EVM Snaps
    if (!(0, _snaps.isMultichainWalletSnap)(account.metadata.snap.id)) {
      throw new Error(`Non-EVM Snap is not whitelisted: ${account.metadata.snap.id}`);
    }

    // Either use the passed caipAssetType, or fallback to the chain's native asset
    const assetTypeToUse = (() => {
      if (caipAssetType) {
        return caipAssetType;
      }
      if (!nativeCurrency) {
        throw new Error('No CAIP asset type provided, and could not find a fallback native asset for the selected account');
      }
      return nativeCurrency;
    })();
    const {
      chainId
    } = (0, _utils.parseCaipAssetType)(assetTypeToUse);
    try {
      // FIXME: We switch the tab before starting the send flow (we
      // faced some inconsistencies when changing it after).
      await dispatch((0, _actions.setDefaultHomeActiveTabName)('activity'));
      await (0, _actions.sendMultichainTransaction)(account.metadata.snap.id, {
        account: account.id,
        scope: chainId,
        assetType: assetTypeToUse
      });
    } catch (error) {
      // Restore the previous tab in case of any error (see FIXME comment above).
      await dispatch((0, _actions.setDefaultHomeActiveTabName)(currentActivityTabName));
    }
  };
};
exports.useHandleSendNonEvm = useHandleSendNonEvm;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\wallet-overview\\hooks\\useHandleSendNonEvm.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\wallet-overview\\index.js", {"./eth-overview":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\wallet-overview\\eth-overview.js","./non-evm-overview":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\wallet-overview\\non-evm-overview.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cwallet-overview%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EthOverview", {
  enumerable: true,
  get: function () {
    return _ethOverview.default;
  }
});
Object.defineProperty(exports, "NonEvmOverview", {
  enumerable: true,
  get: function () {
    return _nonEvmOverview.default;
  }
});
var _ethOverview = _interopRequireDefault(require("./eth-overview"));
var _nonEvmOverview = _interopRequireDefault(require("./non-evm-overview"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\wallet-overview\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\wallet-overview\\non-evm-overview.tsx", {"../../../ducks/ramps":"D:\\code\\v\\metamask-extension\\ui\\ducks\\ramps\\index.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../../selectors/multichain/networks":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain\\networks.ts","./coin-overview":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\wallet-overview\\coin-overview.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cwallet-overview%5Cnon-evm-overview.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _multichain = require("../../../selectors/multichain");
var _networks = require("../../../selectors/multichain/networks");
var _ramps = require("../../../ducks/ramps");
var _selectors = require("../../../selectors");
var _coinOverview = require("./coin-overview");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const NonEvmOverview = ({
  className
}) => {
  const {
    chainId
  } = (0, _reactRedux.useSelector)(_networks.getSelectedMultichainNetworkConfiguration);
  const balance = (0, _reactRedux.useSelector)(_multichain.getMultichainSelectedAccountCachedBalance);
  const account = (0, _reactRedux.useSelector)(_selectors.getSelectedInternalAccount);
  const isNativeTokenBuyable = (0, _reactRedux.useSelector)(_ramps.getIsNativeTokenBuyable);
  let isSwapsChain = false;
  let isBridgeChain = false;
  isSwapsChain = (0, _reactRedux.useSelector)(state => (0, _selectors.getIsSwapsChain)(state, chainId));
  isBridgeChain = (0, _reactRedux.useSelector)(state => (0, _selectors.getIsBridgeChain)(state, chainId));
  return /*#__PURE__*/_react.default.createElement(_coinOverview.CoinOverview, {
    account: account,
    balance: balance
    // We turn this off to avoid having that asterisk + the "Balance maybe be outdated" message for now
    ,
    balanceIsCached: false,
    className: className,
    chainId: chainId,
    isSigningEnabled: true,
    isSwapsChain: isSwapsChain,
    isBridgeChain: isBridgeChain,
    isBuyableChain: isNativeTokenBuyable
  });
};
var _default = exports.default = NonEvmOverview;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\wallet-overview\\non-evm-overview.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\wallet-overview\\wallet-overview.js", {"../../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cwallet-overview%5Cwallet-overview.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _util = require("../../../../app/scripts/lib/util");
var _app = require("../../../../shared/constants/app");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Move this function to shared
// eslint-disable-next-line import/no-restricted-paths

const WalletOverview = ({
  balance,
  buttons,
  className
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('wallet-overview', {
      'wallet-overview-fullscreen': (0, _util.getEnvironmentType)() === _app.ENVIRONMENT_TYPE_FULLSCREEN
    }, className)
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "wallet-overview__balance"
  }, balance), /*#__PURE__*/_react.default.createElement("div", {
    className: "wallet-overview__buttons"
  }, buttons));
};
WalletOverview.propTypes = {
  balance: _propTypes.default.element.isRequired,
  buttons: _propTypes.default.element.isRequired,
  className: _propTypes.default.string
};
var _default = exports.default = WalletOverview;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\wallet-overview\\wallet-overview.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\whats-new-modal\\index.ts", {"./whats-new-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\whats-new-modal\\whats-new-modal.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cwhats-new-modal%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _whatsNewModal.default;
  }
});
var _whatsNewModal = _interopRequireDefault(require("./whats-new-modal"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\whats-new-modal\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\whats-new-modal\\notifications.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cwhats-new-modal%5Cnotifications.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTranslatedUINotifications = void 0;
const getTranslatedUINotifications = _t => {
  return {};
};
exports.getTranslatedUINotifications = getTranslatedUINotifications;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\whats-new-modal\\notifications.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\app\\whats-new-modal\\whats-new-modal.tsx", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","./notifications":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\whats-new-modal\\notifications.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Capp%5Cwhats-new-modal%5Cwhats-new-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = WhatsNewModal;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _metametrics = require("../../../../shared/constants/metametrics");
var _i18n = require("../../../contexts/i18n");
var _metametrics2 = require("../../../contexts/metametrics");
var _designSystem = require("../../../helpers/constants/design-system");
var _selectors = require("../../../selectors");
var _actions = require("../../../store/actions");
var _componentLibrary = require("../../component-library");
var _notifications = require("./notifications");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const renderNotification = ({
  notification,
  onClose,
  onNotificationViewed
}) => {
  const {
    id,
    title,
    image,
    modal
  } = notification;
  const handleNotificationClose = async () => {
    await onNotificationViewed(id);
    onClose();
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, {
    modalDialogProps: {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      padding: 4
    }
  }, (modal === null || modal === void 0 ? void 0 : modal.header) && /*#__PURE__*/_react.default.createElement(modal.header.component, {
    onClose: onClose,
    image: image
  }), (modal === null || modal === void 0 ? void 0 : modal.body) && /*#__PURE__*/_react.default.createElement(modal.body.component, {
    title: title
  }), (modal === null || modal === void 0 ? void 0 : modal.footer) && /*#__PURE__*/_react.default.createElement(modal.footer.component, {
    onAction: () => {
      // No action needed for whats-new notifications
      // This is required by the ModalFooterProps type
      console.log('No action needed for now');
    },
    onCancel: handleNotificationClose
  }));
};

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function WhatsNewModal({
  onClose
}) {
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const notifications = (0, _reactRedux.useSelector)(_selectors.getSortedAnnouncementsToShow);
  const handleNotificationViewed = async id => {
    await (0, _actions.updateViewedNotifications)({
      [id]: true
    });
  };
  const handleModalClose = async () => {
    await Promise.all(notifications.map(({
      id
    }) => handleNotificationViewed(id)));
    trackEvent({
      category: _metametrics.MetaMetricsEventCategory.Home,
      event: _metametrics.MetaMetricsEventName.WhatsNewViewed
    });
    onClose();
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  , {
    onClose: handleModalClose,
    "data-testid": "whats-new-modal",
    isOpen: notifications.length > 0,
    isClosedOnOutsideClick: true,
    isClosedOnEscapeKey: true,
    autoFocus: false
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), notifications.map(({
    id
  }) => {
    const notification = (0, _notifications.getTranslatedUINotifications)(t)[id];
    return renderNotification({
      notification,
      onClose,
      onNotificationViewed: handleNotificationViewed
    });
  })));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\app\\whats-new-modal\\whats-new-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\file-uploader\\file-uploader.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../help-text":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\help-text\\index.ts","../label":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\label\\index.ts","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-simple-file-input":"D:\\code\\v\\metamask-extension\\node_modules\\react-simple-file-input\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Ccomponent-library%5Cfile-uploader%5Cfile-uploader.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileUploader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactSimpleFileInput = _interopRequireDefault(require("react-simple-file-input"));
var _designSystemReact = require("@metamask/design-system-react");
var _label = require("../label");
var _helpText = require("../help-text");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); } // Legacy components
// Constants
const BYTES_PER_KB = 1024;
const BYTES_PER_MB = BYTES_PER_KB * 1024;
const FileUploader = ({
  helpText,
  helpTextProps,
  id,
  label,
  labelProps,
  dropAreaProps,
  accept,
  acceptText,
  maxFileSize,
  fileInputProps,
  onChange,
  ...props
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const fileInputRef = (0, _react.useRef)(null);
  const [files, setFiles] = (0, _react.useState)(null);
  const [error, setError] = (0, _react.useState)(null);
  const [isDragging, setIsDragging] = (0, _react.useState)(false);

  // Helper function to convert bytes to MB
  const convertBytesToMB = (0, _react.useCallback)(bytes => {
    return parseFloat((bytes / BYTES_PER_MB).toFixed(2));
  }, []);

  // Helper function to create a FileList from an array of Files
  const createFileList = (0, _react.useCallback)(fileArray => {
    const dt = new DataTransfer();
    fileArray.forEach(file => dt.items.add(file));
    return dt.files;
  }, []);

  // Helper function to validate a single file
  const validateFile = (0, _react.useCallback)((file, existingNames) => {
    // Skip if duplicate
    if (existingNames.has(file.name)) {
      return null; // Skip silently
    }

    // Check file type
    if (accept) {
      const acceptArray = accept === null || accept === void 0 ? void 0 : accept.replace(/\s/gu, '').split(',');
      if (!acceptArray.includes(file.type)) {
        return t('fileUploaderInvalidFileTypeError');
      }
    }

    // Check file size
    if (maxFileSize && file.size > maxFileSize) {
      const maxFileSizeInMB = convertBytesToMB(maxFileSize);
      return t('fileUploaderMaxFileSizeError', [maxFileSizeInMB]);
    }
    return null; // File is valid
  }, [accept, maxFileSize, convertBytesToMB, t]);
  const addFiles = (0, _react.useCallback)(newFiles => {
    setError(null);
    const isFileList = newFiles instanceof FileList;
    if (!newFiles || isFileList && !(newFiles !== null && newFiles !== void 0 && newFiles.length)) {
      return;
    }
    const existingFileNames = new Set(files ? Array.from(files).map(f => f.name) : []);
    const filesToProcess = isFileList ? Array.from(newFiles) : [newFiles];
    const validFiles = [];

    // Validate all files using the extracted validation logic
    for (const file of filesToProcess) {
      const validationError = validateFile(file, existingFileNames);
      if (validationError) {
        setError(validationError);
        return; // Stop processing on first error
      }
      if (!existingFileNames.has(file.name)) {
        validFiles.push(file);
      }
    }
    if (!validFiles.length) {
      return;
    }

    // Combine existing files with new valid files using helper function
    const existingFiles = files ? Array.from(files) : [];
    const allFiles = [...existingFiles, ...validFiles];
    setFiles(createFileList(allFiles));
  }, [files, validateFile, createFileList]);
  const onFileDrop = e => {
    e.preventDefault();
    setIsDragging(false);
    const {
      files: dtFiles
    } = e.dataTransfer;
    addFiles(dtFiles);
  };
  const onFileChange = fileChangeFiles => {
    if (!fileChangeFiles) {
      return;
    }
    addFiles(fileChangeFiles);
  };

  // Optimize onChange callback to prevent unnecessary re-renders
  const handleFilesChange = (0, _react.useCallback)(newFiles => {
    onChange === null || onChange === void 0 || onChange(newFiles);
  }, [onChange]);

  // emit the files to parent when they change
  (0, _react.useEffect)(() => {
    handleFilesChange(files);
  }, [files, handleFilesChange]);
  const inputId = id || 'file-uploader-input';
  const handleClick = () => {
    var _fileInputRef$current;
    const inputField = (_fileInputRef$current = fileInputRef.current) === null || _fileInputRef$current === void 0 ? void 0 : _fileInputRef$current.refs.inputField;
    if (inputField) {
      inputField.click();
    }
  };
  const handleKeyDown = e => {
    if (e.key === 'Enter' || e.key === ' ') {
      e.preventDefault();
      handleClick();
    }
  };
  return /*#__PURE__*/_react.default.createElement(_designSystemReact.Box, props, label && /*#__PURE__*/_react.default.createElement(_label.Label, _extends({
    htmlFor: inputId
  }, labelProps, {
    className: (0, _designSystemReact.twMerge)('mb-1', (labelProps === null || labelProps === void 0 ? void 0 : labelProps.className) ?? '')
  }), label), /*#__PURE__*/_react.default.createElement("div", _extends({
    role: "button",
    "aria-label": label ? undefined : t('fileUploaderDescription'),
    onDragOver: e => {
      e.preventDefault();
      setIsDragging(true);
    },
    onDragLeave: e => {
      e.preventDefault();
      setIsDragging(false);
    },
    onDrop: onFileDrop,
    onClick: handleClick,
    onKeyDown: handleKeyDown
  }, dropAreaProps, {
    className: (0, _designSystemReact.twMerge)('flex flex-col items-center justify-center w-full p-6 gap-2 text-center rounded-lg border border-dashed border-default hover:bg-background-default-hover hover:border-solid cursor-pointer focus:outline-none focus:ring-2 focus:ring-primary-default focus:ring-offset-2', isDragging && 'bg-background-default-hover border-solid', (dropAreaProps === null || dropAreaProps === void 0 ? void 0 : dropAreaProps.className) || ''),
    tabIndex: 0
  }), /*#__PURE__*/_react.default.createElement(_reactSimpleFileInput.default, _extends({
    id: inputId,
    ref: fileInputRef,
    "data-testid": "file-uploader-input",
    accept: accept ?? undefined,
    multiple: true
  }, fileInputProps, {
    className: (0, _designSystemReact.twMerge)('sr-only', (fileInputProps === null || fileInputProps === void 0 ? void 0 : fileInputProps.className) ?? ''),
    onChange: onFileChange
    // don't save the value to the input field to allow reuploading the same file
    ,
    value: ''
  })), /*#__PURE__*/_react.default.createElement(_designSystemReact.Icon, {
    name: _designSystemReact.IconName.Upload,
    size: _designSystemReact.IconSize.Xl,
    color: _designSystemReact.IconColor.IconAlternative
  }), /*#__PURE__*/_react.default.createElement(_designSystemReact.Box, {
    flexDirection: _designSystemReact.BoxFlexDirection.Column,
    gap: 1
  }, /*#__PURE__*/_react.default.createElement(_designSystemReact.Text, {
    variant: _designSystemReact.TextVariant.BodyMd,
    fontWeight: _designSystemReact.FontWeight.Medium,
    color: _designSystemReact.TextColor.TextAlternative
  }, t('fileUploaderDescription')), acceptText && /*#__PURE__*/_react.default.createElement(_designSystemReact.Text, {
    variant: _designSystemReact.TextVariant.BodySm,
    fontWeight: _designSystemReact.FontWeight.Medium,
    color: _designSystemReact.TextColor.TextAlternative
  }, acceptText))), (error || helpText) && /*#__PURE__*/_react.default.createElement(_helpText.HelpText, _extends({
    severity: error ? _helpText.HelpTextSeverity.Danger : undefined,
    color: _designSystem.TextColor.textAlternative
  }, helpTextProps, {
    className: (0, _designSystemReact.twMerge)('mt-1', (helpTextProps === null || helpTextProps === void 0 ? void 0 : helpTextProps.className) ?? '')
  }), error || helpText), files && /*#__PURE__*/_react.default.createElement(_designSystemReact.Box, {
    flexDirection: _designSystemReact.BoxFlexDirection.Column,
    gap: 2,
    marginTop: 4
  }, Array.from(files).map(file => {
    var _file$type;
    return /*#__PURE__*/_react.default.createElement(_designSystemReact.Box, {
      key: file.name,
      alignItems: _designSystemReact.BoxAlignItems.Center,
      flexDirection: _designSystemReact.BoxFlexDirection.Row,
      backgroundColor: _designSystemReact.BoxBackgroundColor.BackgroundSection,
      paddingTop: 2,
      paddingBottom: 2,
      paddingLeft: 4,
      paddingRight: 4,
      gap: 2,
      className: "rounded-lg"
    }, /*#__PURE__*/_react.default.createElement(_designSystemReact.Icon, {
      name: (_file$type = file.type) !== null && _file$type !== void 0 && _file$type.includes('image') ? _designSystemReact.IconName.Image : _designSystemReact.IconName.File,
      size: _designSystemReact.IconSize.Md,
      color: _designSystemReact.IconColor.IconAlternative
    }), /*#__PURE__*/_react.default.createElement(_designSystemReact.Text, {
      variant: _designSystemReact.TextVariant.BodySm,
      color: _designSystemReact.TextColor.TextAlternative
    }, file.name), /*#__PURE__*/_react.default.createElement(_designSystemReact.ButtonIcon, {
      iconName: _designSystemReact.IconName.Close,
      size: _designSystemReact.ButtonIconSize.Sm,
      color: _designSystemReact.IconColor.IconAlternative,
      ariaLabel: t('delete'),
      onClick: () => {
        const remainingFiles = Array.from(files).filter(f => f.name !== file.name);
        setFiles(createFileList(remainingFiles));
      },
      className: "ml-auto"
    }));
  })));
};
exports.FileUploader = FileUploader;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\component-library\\file-uploader\\file-uploader.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\file-uploader\\index.ts", {"./file-uploader":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\file-uploader\\file-uploader.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Ccomponent-library%5Cfile-uploader%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "FileUploader", {
  enumerable: true,
  get: function () {
    return _fileUploader.FileUploader;
  }
});
var _fileUploader = require("./file-uploader");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\component-library\\file-uploader\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\form-text-field\\deprecated\\form-text-field.js", {"../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../ui/box/box":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\box\\box.js","../../help-text":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\help-text\\index.ts","../../label":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\label\\index.ts","../../text-field":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\text-field\\index.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Ccomponent-library%5Cform-text-field%5Cdeprecated%5Cform-text-field.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormTextField = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _designSystem = require("../../../../helpers/constants/design-system");
var _box = _interopRequireDefault(require("../../../ui/box/box"));
var _textField = require("../../text-field");
var _helpText = require("../../help-text");
var _label = require("../../label");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
/**
 * @deprecated This has been deprecated in favor of the TypeScript version `<FormTextField />` component in ./ui/components/component-library/form-text-field/form-text-field.tsx
 * See storybook documentation for FormTextField here https://metamask.github.io/metamask-storybook/?path=/docs/components-componentlibrary-formtextfield--docs
 */

const FormTextField = ({
  autoComplete,
  autoFocus,
  className,
  defaultValue,
  disabled,
  error,
  helpText,
  helpTextProps,
  id,
  inputProps,
  inputRef,
  label,
  labelProps,
  startAccessory,
  maxLength,
  name,
  onBlur,
  onChange,
  onFocus,
  placeholder,
  readOnly,
  required,
  endAccessory,
  size = _designSystem.Size.MD,
  textFieldProps,
  truncate,
  type = 'text',
  value,
  ...props
}) => /*#__PURE__*/_react.default.createElement(_box.default, _extends({
  className: (0, _classnames.default)('mm-form-text-field', {
    'mm-form-text-field--disabled': disabled
  }, className),
  display: _designSystem.Display.Flex,
  flexDirection: _designSystem.FlexDirection.Column
}, props), label && /*#__PURE__*/_react.default.createElement(_label.Label, _extends({
  htmlFor: id
}, labelProps, {
  className: (0, _classnames.default)('mm-form-text-field__label', labelProps === null || labelProps === void 0 ? void 0 : labelProps.className)
}), label), /*#__PURE__*/_react.default.createElement(_textField.TextField, _extends({
  className: (0, _classnames.default)('mm-form-text-field__text-field', textFieldProps === null || textFieldProps === void 0 ? void 0 : textFieldProps.className),
  id: id,
  autoComplete,
  autoFocus,
  defaultValue,
  disabled,
  error,
  id,
  inputProps,
  inputRef,
  startAccessory,
  maxLength,
  name,
  onBlur,
  onChange,
  onFocus,
  placeholder,
  readOnly,
  required,
  endAccessory,
  size,
  truncate,
  type,
  value
}, textFieldProps)), helpText && /*#__PURE__*/_react.default.createElement(_helpText.HelpText, _extends({
  severity: error && _helpText.HelpTextSeverity.Danger,
  marginTop: 1
}, helpTextProps, {
  className: (0, _classnames.default)('mm-form-text-field__help-text', helpTextProps === null || helpTextProps === void 0 ? void 0 : helpTextProps.className)
}), helpText));
exports.FormTextField = FormTextField;
FormTextField.propTypes = {
  /**
   * An additional className to apply to the form-text-field
   */
  className: _propTypes.default.string,
  /**
   * The id of the FormTextField
   * Required if label prop exists to ensure accessibility
   *
   * @param {object} props - The props passed to the component.
   * @param {string} propName - The prop name in this case 'id'.
   * @param {string} componentName - The name of the component.
   */
  id: (props, propName, componentName) => {
    if (props.label && !props[propName]) {
      return new Error(`If a label prop exists you must provide an ${propName} prop for the label's htmlFor attribute for accessibility. Warning coming from ${componentName} ui/components/component-library/form-text-field/form-text-field.js`);
    }
    return null;
  },
  /**
   * The content of the Label component
   */
  label: _propTypes.default.string,
  /**
   * Props that are applied to the Label component
   */
  labelProps: _propTypes.default.object,
  /**
   * The content of the HelpText component
   */
  helpText: _propTypes.default.oneOfType([_propTypes.default.node, _propTypes.default.string]),
  /**
   * Props that are applied to the HelpText component
   */
  helpTextProps: _propTypes.default.object,
  /**
   * Props that are applied to the TextField component
   */
  textFieldProps: _propTypes.default.object,
  /**
   * FormTextField accepts all the props from TextField and Box
   */
  ..._textField.TextField.propTypes
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\component-library\\form-text-field\\deprecated\\form-text-field.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\form-text-field\\deprecated\\index.js", {"./form-text-field":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\form-text-field\\deprecated\\form-text-field.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Ccomponent-library%5Cform-text-field%5Cdeprecated%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "FormTextField", {
  enumerable: true,
  get: function () {
    return _formTextField.FormTextField;
  }
});
var _formTextField = require("./form-text-field");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\component-library\\form-text-field\\deprecated\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\lottie-animation\\index.ts", {"./lottie-animation":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\lottie-animation\\lottie-animation.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Ccomponent-library%5Clottie-animation%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "LottieAnimation", {
  enumerable: true,
  get: function () {
    return _lottieAnimation.LottieAnimation;
  }
});
var _lottieAnimation = require("./lottie-animation");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\component-library\\lottie-animation\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\lottie-animation\\lottie-animation.tsx", {"lottie-web/build/player/lottie_light":"D:\\code\\v\\metamask-extension\\node_modules\\lottie-web\\build\\player\\lottie_light.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Ccomponent-library%5Clottie-animation%5Clottie-animation.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LottieAnimation = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lottie_light = _interopRequireDefault(require("lottie-web/build/player/lottie_light"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Use lottie_light to avoid unsafe-eval which breaks the CSP
// https://github.com/airbnb/lottie-web/issues/289#issuecomment-1454909624

const LottieAnimation = ({
  data,
  path,
  loop = true,
  autoplay = true,
  style = {},
  className = '',
  onComplete = () => null
}) => {
  const containerRef = (0, _react.useRef)(null);
  const animationInstance = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    if (!containerRef.current) {
      console.error('LottieAnimation: containerRef is null');
      return () => null;
    }
    if (Boolean(data) === Boolean(path)) {
      console.error('LottieAnimation: Exactly one of data or path must be provided');
      return () => null;
    }
    const animationConfig = {
      container: containerRef.current,
      renderer: 'svg',
      loop,
      autoplay,
      ...(data ? {
        animationData: data
      } : {
        path
      })
    };
    try {
      animationInstance.current = _lottie_light.default.loadAnimation(animationConfig);
      animationInstance.current.addEventListener('complete', onComplete);
      animationInstance.current.addEventListener('error', error => {
        console.error('LottieAnimation error:', error);
      });
    } catch (error) {
      console.error('Failed to load animation:', error);
    }
    return () => {
      if (animationInstance.current) {
        animationInstance.current.removeEventListener('complete', onComplete);
        animationInstance.current.destroy();
        animationInstance.current = null;
      }
    };
  }, [data, path, loop, autoplay, onComplete]);
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: containerRef,
    style: style,
    className: className
  });
};
exports.LottieAnimation = LottieAnimation;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\component-library\\lottie-animation\\lottie-animation.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\modal-content\\deprecated\\index.ts", {"../modal-content.types":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\modal-content\\modal-content.types.ts","./modal-content":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\modal-content\\deprecated\\modal-content.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Ccomponent-library%5Cmodal-content%5Cdeprecated%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ModalContent", {
  enumerable: true,
  get: function () {
    return _modalContent.ModalContent;
  }
});
Object.defineProperty(exports, "ModalContentSize", {
  enumerable: true,
  get: function () {
    return _modalContent2.ModalContentSize;
  }
});
var _modalContent = require("./modal-content");
var _modalContent2 = require("../modal-content.types");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\component-library\\modal-content\\deprecated\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\modal-content\\deprecated\\modal-content.tsx", {"../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../box":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\box\\index.ts","../../modal-focus":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\modal-focus\\index.ts","../../modal/modal.context":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\modal\\modal.context.ts","../modal-content.types":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\modal-content\\modal-content.types.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Ccomponent-library%5Cmodal-content%5Cdeprecated%5Cmodal-content.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ModalContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _designSystem = require("../../../../helpers/constants/design-system");
var _box = require("../../box");
var _modalContent = require("../modal-content.types");
var _modal = require("../../modal/modal.context");
var _modalFocus = require("../../modal-focus");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
/**
 * @deprecated This version of `ModalContent` is deprecated. Please use the version from the component-library in ui/components/component-library/modal-content/modal-content.tsx
 * See PR https://github.com/MetaMask/metamask-extension/pull/22207 for details.
 */

const ModalContent = exports.ModalContent = /*#__PURE__*/_react.default.forwardRef(({
  className = '',
  children,
  size = _modalContent.ModalContentSize.Sm,
  modalDialogProps,
  ...props
}, ref) => {
  const {
    onClose,
    isClosedOnEscapeKey,
    isClosedOnOutsideClick,
    initialFocusRef,
    finalFocusRef,
    restoreFocus,
    autoFocus
  } = (0, _modal.useModalContext)();
  const modalDialogRef = (0, _react.useRef)(null);
  const handleEscKey = event => {
    if (isClosedOnEscapeKey && event.key === 'Escape') {
      onClose();
    }
  };
  const handleClickOutside = event => {
    // Popover should be launched from within Modal but
    // the Popover containing element is a sibling to modal,
    // so this is required to ensure `onClose` isn't triggered
    // when clicking on a popover item
    if (isClosedOnOutsideClick && event.target.closest('.mm-popover')) {
      return;
    }
    if (isClosedOnOutsideClick && modalDialogRef !== null && modalDialogRef !== void 0 && modalDialogRef.current && !modalDialogRef.current.contains(event.target)) {
      onClose();
    }
  };
  (0, _react.useEffect)(() => {
    document.addEventListener('keydown', handleEscKey);
    document.addEventListener('mousedown', handleClickOutside);
    return () => {
      document.removeEventListener('keydown', handleEscKey);
      document.removeEventListener('mousedown', handleClickOutside);
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement(_modalFocus.ModalFocus, {
    initialFocusRef: initialFocusRef,
    finalFocusRef: finalFocusRef,
    restoreFocus: restoreFocus,
    autoFocus: autoFocus
  }, /*#__PURE__*/_react.default.createElement(_box.Box, _extends({
    className: (0, _classnames.default)('mm-modal-content', className),
    ref: ref,
    display: _designSystem.Display.Flex,
    width: _designSystem.BlockSize.Screen,
    height: _designSystem.BlockSize.Screen,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.flexStart,
    paddingRight: 4,
    paddingLeft: 4,
    paddingTop: [4, 8, 12],
    paddingBottom: [4, 8, 12]
  }, props), /*#__PURE__*/_react.default.createElement(_box.Box, _extends({
    as: "section",
    role: "dialog",
    "aria-modal": "true",
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    borderRadius: _designSystem.BorderRadius.LG,
    width: _designSystem.BlockSize.Full,
    padding: 4,
    ref: modalDialogRef
  }, modalDialogProps, {
    className: (0, _classnames.default)('mm-modal-content__dialog', `mm-modal-content__dialog--size-${size}`, modalDialogProps === null || modalDialogProps === void 0 ? void 0 : modalDialogProps.className),
    style: {
      ...(props === null || props === void 0 ? void 0 : props.style),
      overflowY: 'auto' // fallback for any content that extends beyond the modal dialog
    }
  }), children)));
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\component-library\\modal-content\\deprecated\\modal-content.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\modal-header\\deprecated\\index.ts", {"./modal-header":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\modal-header\\deprecated\\modal-header.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Ccomponent-library%5Cmodal-header%5Cdeprecated%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ModalHeader", {
  enumerable: true,
  get: function () {
    return _modalHeader.ModalHeader;
  }
});
var _modalHeader = require("./modal-header");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\component-library\\modal-header\\deprecated\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\modal-header\\deprecated\\modal-header.tsx", {"../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../button-icon":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\button-icon\\index.ts","../../header-base":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\header-base\\index.ts","../../icon":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\icon\\index.ts","../../text":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\text\\index.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Ccomponent-library%5Cmodal-header%5Cdeprecated%5Cmodal-header.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ModalHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _text = require("../../text");
var _designSystem = require("../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _headerBase = require("../../header-base");
var _buttonIcon = require("../../button-icon");
var _icon = require("../../icon");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
/**
 * @deprecated This version of `ModalHeader` is deprecated. Please use the version from the component-library in ui/components/component-library/modal-header/modal-header.tsx
 * See PR https://github.com/MetaMask/metamask-extension/pull/22207 for details.
 * @param options0
 * @param options0.children
 * @param options0.className
 * @param options0.startAccessory
 * @param options0.endAccessory
 * @param options0.onClose
 * @param options0.closeButtonProps
 * @param options0.onBack
 * @param options0.backButtonProps
 */
const ModalHeader = ({
  children,
  className = '',
  startAccessory,
  endAccessory,
  onClose,
  closeButtonProps,
  onBack,
  backButtonProps,
  ...props
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_headerBase.HeaderBase, _extends({
    className: (0, _classnames.default)('mm-modal-header', className),
    startAccessory:
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    startAccessory || onBack && /*#__PURE__*/_react.default.createElement(_buttonIcon.ButtonIcon, _extends({
      iconName: _icon.IconName.ArrowLeft,
      ariaLabel: t('back'),
      size: _buttonIcon.ButtonIconSize.Sm,
      onClick: onBack
    }, backButtonProps)),
    endAccessory:
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    endAccessory || onClose && /*#__PURE__*/_react.default.createElement(_buttonIcon.ButtonIcon, _extends({
      iconName: _icon.IconName.Close,
      ariaLabel: t('close'),
      size: _buttonIcon.ButtonIconSize.Sm,
      onClick: onClose
    }, closeButtonProps))
  }, props), typeof children === 'string' ? /*#__PURE__*/_react.default.createElement(_text.Text, {
    as: "header",
    variant: _designSystem.TextVariant.headingSm,
    textAlign: _designSystem.TextAlign.Center
  }, children) : children);
};
exports.ModalHeader = ModalHeader;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\component-library\\modal-header\\deprecated\\modal-header.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\skeleton\\index.ts", {"./skeleton":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\skeleton\\skeleton.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Ccomponent-library%5Cskeleton%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "Skeleton", {
  enumerable: true,
  get: function () {
    return _skeleton.Skeleton;
  }
});
var _skeleton = require("./skeleton");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\component-library\\skeleton\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\skeleton\\skeleton.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../box":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\box\\index.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Ccomponent-library%5Cskeleton%5Cskeleton.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Skeleton = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _designSystem = require("../../../helpers/constants/design-system");
var _box = require("../box");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const Skeleton = exports.Skeleton = /*#__PURE__*/_react.default.forwardRef(({
  className = '',
  height,
  width,
  children,
  isLoading = true,
  ...props
}, ref) => {
  if (!isLoading) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
  }
  return /*#__PURE__*/_react.default.createElement(_box.Box, _extends({
    className: (0, _classnames.default)('mm-skeleton', className),
    backgroundColor: _designSystem.BackgroundColor.iconAlternative,
    borderRadius: _designSystem.BorderRadius.SM,
    ref: ref
  }, props, {
    style: {
      ...(props === null || props === void 0 ? void 0 : props.style),
      height,
      width
    }
  }), children);
});
var _default = exports.default = Skeleton;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\component-library\\skeleton\\skeleton.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\text-field-search\\deprecated\\index.js", {"./text-field-search":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\text-field-search\\deprecated\\text-field-search.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Ccomponent-library%5Ctext-field-search%5Cdeprecated%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "TextFieldSearch", {
  enumerable: true,
  get: function () {
    return _textFieldSearch.TextFieldSearch;
  }
});
var _textFieldSearch = require("./text-field-search");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\component-library\\text-field-search\\deprecated\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\text-field-search\\deprecated\\text-field-search.js", {"../..":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Ccomponent-library%5Ctext-field-search%5Cdeprecated%5Ctext-field-search.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextFieldSearch = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _ = require("../..");
var _useI18nContext = require("../../../../hooks/useI18nContext");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
/**
 * @deprecated This has been deprecated in favor of the TypeScript version `<TextFeildSearch />` component in ./ui/components/component-library/text-field-search/text-field-search.tsx
 * See storybook documentation for TextFieldSearch here https://metamask.github.io/metamask-storybook/?path=/docs/components-componentlibrary-textfieldsearch--docs
 */

const TextFieldSearch = ({
  className,
  showClearButton = true,
  // only works with a controlled input
  clearButtonOnClick,
  clearButtonProps,
  endAccessory,
  inputProps,
  value,
  onChange,
  ...props
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_.TextField, _extends({
    className: (0, _classnames.default)('mm-text-field-search', className),
    value: value,
    onChange: onChange,
    type: _.TextFieldType.Search,
    endAccessory: value && showClearButton ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_.ButtonIcon, _extends({
      className: "mm-text-field__button-clear",
      ariaLabel: t('clear'),
      iconName: _.IconName.Close,
      size: _.ButtonIconSize.Sm,
      onClick: clearButtonOnClick
    }, clearButtonProps)), endAccessory) : endAccessory,
    startAccessory: /*#__PURE__*/_react.default.createElement(_.Icon, {
      padding: 1,
      name: _.IconName.Search,
      size: _.IconSize.Sm
    }),
    inputProps: {
      ...inputProps
    }
  }, props));
};
exports.TextFieldSearch = TextFieldSearch;
TextFieldSearch.propTypes = {
  /**
   * The value of the TextFieldSearch
   */
  value: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),
  /**
   * The onChange handler of the TextFieldSearch
   */
  onChange: _propTypes.default.func,
  /**
   * The clear button for the TextFieldSearch.
   * Defaults to true
   */
  showClearButton: _propTypes.default.bool,
  /**
   * The onClick handler for the clear button
   * Required unless showClearButton is false
   *
   * @param {object} props - The props passed to the component.
   * @param {string} propName - The prop name in this case 'id'.
   * @param {string} componentName - The name of the component.
   */
  clearButtonOnClick: (props, propName, componentName) => {
    var _props$clearButtonPro;
    if (props.showClearButton && (!props[propName] || !((_props$clearButtonPro = props.clearButtonProps) !== null && _props$clearButtonPro !== void 0 && _props$clearButtonPro.onClick))) {
      return new Error(`${propName} is required unless showClearButton is false. Warning coming from ${componentName} ui/components/component-library/text-field-search/text-field-search.js`);
    }
    return null;
  },
  /**
   * The props to pass to the clear button
   */
  clearButtonProps: _propTypes.default.object,
  /**
   * An additional className to apply to the TextFieldSearch
   */
  className: _propTypes.default.string,
  /**
   * Component to appear on the right side of the input
   */
  endAccessory: _propTypes.default.node,
  /**
   * Attributes applied to the `input` element.
   */
  inputProps: _propTypes.default.object
};
TextFieldSearch.displayName = 'TextFieldSearch';

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\component-library\\text-field-search\\deprecated\\text-field-search.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\textarea\\index.ts", {"./textarea":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\textarea\\textarea.tsx","./textarea.types":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\textarea\\textarea.types.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Ccomponent-library%5Ctextarea%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "Textarea", {
  enumerable: true,
  get: function () {
    return _textarea.Textarea;
  }
});
Object.defineProperty(exports, "TextareaResize", {
  enumerable: true,
  get: function () {
    return _textarea2.TextareaResize;
  }
});
var _textarea = require("./textarea");
var _textarea2 = require("./textarea.types");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\component-library\\textarea\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\textarea\\textarea.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../text":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\text\\index.ts","./textarea.types":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\textarea\\textarea.types.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Ccomponent-library%5Ctextarea%5Ctextarea.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Textarea = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _designSystem = require("../../../helpers/constants/design-system");
var _text = require("../text");
var _textarea = require("./textarea.types");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const Textarea = exports.Textarea = /*#__PURE__*/_react.default.forwardRef(({
  autoFocus,
  className = '',
  defaultValue,
  isDisabled,
  disabled,
  // to allow our components to maintain intuitive building and support native HTML attribute
  error,
  id,
  resize = _textarea.TextareaResize.Vertical,
  rows,
  cols,
  maxLength,
  name,
  onBlur,
  onChange,
  onClick,
  onFocus,
  placeholder,
  readOnly,
  required,
  value,
  ...props
}, ref) => {
  const handleClick = event => {
    if (onClick && (!isDisabled || !disabled)) {
      onClick === null || onClick === void 0 || onClick(event);
    }
  };
  const handleBlur = event => {
    onBlur === null || onBlur === void 0 || onBlur(event);
  };
  const handleFocus = event => {
    onFocus === null || onFocus === void 0 || onFocus(event);
  };
  return /*#__PURE__*/_react.default.createElement(_text.Text, _extends({
    className: (0, _classnames.default)('mm-textarea', `mm-textarea--resize-${resize}`, {
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
      // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
      'mm-textarea--disabled': Boolean(isDisabled || disabled)
    }, className),
    as: "textarea",
    ref: ref,
    placeholder: placeholder,
    readOnly: readOnly,
    required: required,
    autoFocus: autoFocus,
    defaultValue: defaultValue
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    ,
    disabled: isDisabled || disabled
  }, error && {
    'aria-invalid': error
  }, {
    id: id,
    maxLength: maxLength,
    name: name,
    value: value,
    onBlur: handleBlur,
    onChange: onChange,
    onClick: handleClick,
    onFocus: handleFocus,
    resize: resize,
    rows: rows,
    cols: cols,
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    borderColor: error ? _designSystem.BorderColor.errorDefault : _designSystem.BorderColor.borderDefault,
    borderRadius: _designSystem.BorderRadius.SM,
    borderWidth: 1,
    paddingBottom: 1,
    paddingLeft: 4,
    paddingRight: 4,
    paddingTop: 1
  }, props));
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\component-library\\textarea\\textarea.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\textarea\\textarea.types.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Ccomponent-library%5Ctextarea%5Ctextarea.types.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextareaResize = void 0;
let TextareaResize = exports.TextareaResize = /*#__PURE__*/function (TextareaResize) {
  TextareaResize["None"] = "none";
  TextareaResize["Both"] = "both";
  TextareaResize["Horizontal"] = "horizontal";
  TextareaResize["Vertical"] = "vertical";
  TextareaResize["Initial"] = "initial";
  TextareaResize["Inherit"] = "inherit";
  return TextareaResize;
}({}); // TODO: Convert to a `type` in a future major version.
// eslint-disable-next-line @typescript-eslint/consistent-type-definitions
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\component-library\\textarea\\textarea.types.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\account-details-row\\account-details-row.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Caccount-details-row%5Caccount-details-row.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountDetailsRow = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const AccountDetailsRow = ({
  label,
  value,
  endAccessory,
  style,
  onClick,
  labelColor
}) => {
  const rowClassName = (0, _classnames.default)('multichain-account-details__row', {
    'multichain-account-details__row--clickable': Boolean(onClick),
    'multichain-account-details__row--default': !onClick
  });
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    backgroundColor: _designSystem.BackgroundColor.backgroundSection,
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    style: style,
    paddingLeft: 4,
    paddingRight: 2,
    alignItems: _designSystem.AlignItems.center,
    onClick: onClick,
    className: rowClassName,
    "data-testid": `account-details-row-${label.toLowerCase().replaceAll(' ', '-')}`
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: labelColor ?? _designSystem.TextColor.textDefault,
    variant: _designSystem.TextVariant.bodyMdMedium,
    className: "multichain-account-details__label"
  }, label), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    className: "multichain-account-details__value-container"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textAlternative,
    variant: _designSystem.TextVariant.bodyMdMedium,
    ellipsis: true,
    className: "multichain-account-details__value",
    "data-testid": `account-details-row-value-${label.toLowerCase().replaceAll(' ', '-')}`
  }, value), endAccessory));
};
exports.AccountDetailsRow = AccountDetailsRow;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\account-details-row\\account-details-row.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\account-details-row\\index.ts", {"./account-details-row":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\account-details-row\\account-details-row.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Caccount-details-row%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "AccountDetailsRow", {
  enumerable: true,
  get: function () {
    return _accountDetailsRow.AccountDetailsRow;
  }
});
var _accountDetailsRow = require("./account-details-row");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\account-details-row\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\account-remove-modal\\account-remove-modal.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../app/preferred-avatar":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\preferred-avatar\\index.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../multichain":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Caccount-remove-modal%5Caccount-remove-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountRemoveModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../component-library");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _designSystem = require("../../../helpers/constants/design-system");
var _preferredAvatar = require("../../app/preferred-avatar");
var _multichain = require("../../multichain");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const AccountRemoveModal = ({
  isOpen,
  onClose,
  onSubmit,
  accountName,
  accountAddress
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    onClose: onClose,
    isOpen: isOpen
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onClose: onClose
  }, t('removeAccount')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.center,
    flexDirection: _designSystem.FlexDirection.Column
  }, /*#__PURE__*/_react.default.createElement(_preferredAvatar.PreferredAvatar, {
    address: accountAddress
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyLgMedium,
    marginTop: 2,
    marginBottom: 2
  }, accountName), /*#__PURE__*/_react.default.createElement(_multichain.AddressCopyButton, {
    address: accountAddress,
    shorten: true
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerAlert, {
    severity: _componentLibrary.BannerAlertSeverity.Danger,
    marginTop: 6,
    marginBottom: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    fontWeight: _designSystem.FontWeight.Bold
  }, t('removeAccountModalBannerTitle')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd
  }, t('removeAccountModalBannerDescription')))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalFooter, {
    onCancel: onClose,
    onSubmit: onSubmit,
    submitButtonProps: {
      children: t('remove'),
      danger: true
    }
  })));
};
exports.AccountRemoveModal = AccountRemoveModal;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\account-remove-modal\\account-remove-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\account-remove-modal\\index.ts", {"./account-remove-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\account-remove-modal\\account-remove-modal.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Caccount-remove-modal%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "AccountRemoveModal", {
  enumerable: true,
  get: function () {
    return _accountRemoveModal.AccountRemoveModal;
  }
});
var _accountRemoveModal = require("./account-remove-modal");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\account-remove-modal\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\account-show-private-key-row\\account-show-private-key-row.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../app/modals/hold-to-reveal-modal/hold-to-reveal-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\hold-to-reveal-modal\\hold-to-reveal-modal.tsx","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../multichain/account-details/account-details-authenticate":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-details\\account-details-authenticate.js","../../multichain/account-details/account-details-key":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-details\\account-details-key.js","../account-details-row":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\account-details-row\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Caccount-show-private-key-row%5Caccount-show-private-key-row.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountShowPrivateKeyRow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _accountDetailsRow = require("../account-details-row");
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _util = require("../../../helpers/utils/util");
var _holdToRevealModal = _interopRequireDefault(require("../../app/modals/hold-to-reveal-modal/hold-to-reveal-modal"));
var _accountDetailsAuthenticate = require("../../multichain/account-details/account-details-authenticate");
var _accountDetailsKey = require("../../multichain/account-details/account-details-key");
var _actions = require("../../../store/actions");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AccountShowPrivateKeyRow = ({
  account
}) => {
  var _account$metadata$key;
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const [showHoldToReveal, setShowHoldToReveal] = (0, _react.useState)(false);
  const [privateKey, setPrivateKey] = (0, _react.useState)('');
  const [showPrivateKeyModal, setShowPrivateKeyModal] = (0, _react.useState)(false);
  const keyringType = (_account$metadata$key = account.metadata.keyring) === null || _account$metadata$key === void 0 ? void 0 : _account$metadata$key.type;
  const canExportPrivateKey = (0, _util.isAbleToExportAccount)(keyringType);
  if (!canExportPrivateKey) {
    return null;
  }
  const handleClick = () => {
    setShowPrivateKeyModal(true);
  };
  const handleClose = () => {
    setShowPrivateKeyModal(false);
    setPrivateKey('');
    setShowHoldToReveal(false);
    dispatch((0, _actions.hideWarning)());
  };
  const showModal = showPrivateKeyModal && !showHoldToReveal;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_accountDetailsRow.AccountDetailsRow, {
    label: t('privateKey'),
    value: '',
    endAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      iconName: _componentLibrary.IconName.ArrowRight,
      ariaLabel: t('next'),
      color: _designSystem.IconColor.iconAlternative,
      size: _componentLibrary.ButtonIconSize.Md
    }),
    onClick: handleClick
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: showModal,
    onClose: handleClose,
    "data-testid": "private-key-modal"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, {
    modalDialogProps: {
      paddingLeft: 4,
      paddingRight: 4
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onClose: handleClose
  }, t('showPrivateKey')), !privateKey && !showHoldToReveal && /*#__PURE__*/_react.default.createElement(_accountDetailsAuthenticate.AccountDetailsAuthenticate, {
    address: account.address,
    onCancel: handleClose,
    setPrivateKey: setPrivateKey,
    setShowHoldToReveal: setShowHoldToReveal
  }), privateKey && !showHoldToReveal && /*#__PURE__*/_react.default.createElement(_accountDetailsKey.AccountDetailsKey, {
    accountName: account.metadata.name,
    onClose: handleClose,
    privateKey: privateKey
  }))), /*#__PURE__*/_react.default.createElement(_holdToRevealModal.default, {
    isOpen: showHoldToReveal,
    onClose: () => {
      setPrivateKey('');
      setShowHoldToReveal(false);
    },
    onLongPressed: () => {
      setShowHoldToReveal(false);
    },
    holdToRevealType: "PrivateKey"
  }));
};
exports.AccountShowPrivateKeyRow = AccountShowPrivateKeyRow;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\account-show-private-key-row\\account-show-private-key-row.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\account-show-srp-row\\account-show-srp-row.tsx", {"../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../app/srp-quiz-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\srp-quiz-modal\\index.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../account-details-row/account-details-row":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\account-details-row\\account-details-row.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Caccount-show-srp-row%5Caccount-show-srp-row.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountShowSrpRow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _designSystem = require("../../../helpers/constants/design-system");
var _accountDetailsRow = require("../account-details-row/account-details-row");
var _componentLibrary = require("../../component-library");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _metamask = require("../../../ducks/metamask/metamask");
var _selectors = require("../../../selectors");
var _routes = require("../../../helpers/constants/routes");
var _srpQuizModal = _interopRequireDefault(require("../../app/srp-quiz-modal"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AccountShowSrpRow = ({
  account
}) => {
  var _account$options, _hdKeyrings$;
  const t = (0, _useI18nContext.useI18nContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const [srpQuizModalVisible, setSrpQuizModalVisible] = (0, _react.useState)(false);
  const seedPhraseBackedUp = (0, _reactRedux.useSelector)(_metamask.getIsPrimarySeedPhraseBackedUp);
  const hdKeyrings = (0, _reactRedux.useSelector)(_selectors.getMetaMaskHdKeyrings);
  const keyringId = (_account$options = account.options) !== null && _account$options !== void 0 && _account$options.entropySource && typeof account.options.entropySource === 'string' ? account.options.entropySource : undefined;
  const isFirstHdKeyring = ((_hdKeyrings$ = hdKeyrings[0]) === null || _hdKeyrings$ === void 0 || (_hdKeyrings$ = _hdKeyrings$.metadata) === null || _hdKeyrings$ === void 0 ? void 0 : _hdKeyrings$.id) === keyringId;
  const shouldShowBackupReminder = !seedPhraseBackedUp && isFirstHdKeyring && keyringId;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_accountDetailsRow.AccountDetailsRow, {
    label: t('secretRecoveryPhrase'),
    value: '',
    endAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      alignItems: _designSystem.AlignItems.center,
      gap: 1
    }, shouldShowBackupReminder && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMdMedium,
      color: _designSystem.TextColor.errorDefault
    }, t('backup')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      iconName: _componentLibrary.IconName.ArrowRight,
      ariaLabel: t('next'),
      color: _designSystem.IconColor.iconAlternative,
      size: _componentLibrary.ButtonIconSize.Md
    })),
    onClick: () => {
      if (shouldShowBackupReminder) {
        const backUpSRPRoute = `${_routes.ONBOARDING_REVIEW_SRP_ROUTE}/?isFromReminder=true`;
        history.push(backUpSRPRoute);
      } else {
        setSrpQuizModalVisible(true);
      }
    }
  }), srpQuizModalVisible ? /*#__PURE__*/_react.default.createElement(_srpQuizModal.default, {
    keyringId: keyringId,
    isOpen: srpQuizModalVisible,
    onClose: () => setSrpQuizModalVisible(false),
    closeAfterCompleting: true
  }) : null);
};
exports.AccountShowSrpRow = AccountShowSrpRow;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\account-show-srp-row\\account-show-srp-row.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\add-multichain-account\\add-multichain-account.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/accounts/useAccountsOperationsLoadingStates":"D:\\code\\v\\metamask-extension\\ui\\hooks\\accounts\\useAccountsOperationsLoadingStates.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Cadd-multichain-account%5Cadd-multichain-account.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddMultichainAccount = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _actions = require("../../../store/actions");
var _useAccountsOperationsLoadingStates = require("../../../hooks/accounts/useAccountsOperationsLoadingStates");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AddMultichainAccount = ({
  walletId
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const {
    isAccountTreeSyncingInProgress,
    loadingMessage: accountOperationLoadingMessage
  } = (0, _useAccountsOperationsLoadingStates.useAccountsOperationsLoadingStates)();
  const isLoadingState = isLoading || isAccountTreeSyncingInProgress;
  const actionLabel = (0, _react.useMemo)(() => {
    if (isAccountTreeSyncingInProgress) {
      return accountOperationLoadingMessage;
    }
    if (isLoadingState) {
      return t('createMultichainAccountButtonLoading');
    }
    return t('createMultichainAccountButton');
  }, [isLoadingState, accountOperationLoadingMessage, isAccountTreeSyncingInProgress, t]);
  const handleCreateMultichainAccountClick = async () => {
    if (isLoadingState) {
      return;
    }
    setIsLoading(true);
    await dispatch((0, _actions.createNextMultichainAccountGroup)(walletId));
    setIsLoading(false);
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "add-multichain-account",
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.flexStart,
    style: {
      cursor: isLoadingState ? 'not-allowed' : 'pointer'
    },
    padding: 4,
    onClick: handleCreateMultichainAccountClick,
    "data-testid": `add-multichain-account-button`,
    key: `add-multichain-account-button-${walletId}`
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "add-multichain-account__icon-box",
    backgroundColor: isLoadingState ? _designSystem.BackgroundColor.transparent : _designSystem.BackgroundColor.infoMuted,
    borderRadius: _designSystem.BorderRadius.MD,
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    marginLeft: 1,
    marginRight: 4
  }, !isLoadingState && /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    className: "add-multichain-account__icon-box__icon",
    name: _componentLibrary.IconName.Add,
    color: _designSystem.IconColor.infoDefault,
    size: _componentLibrary.IconSize.Lg
  }), isLoadingState && /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    className: "add-multichain-account__icon-box__icon-loading",
    name: _componentLibrary.IconName.Loading,
    color: _designSystem.IconColor.iconMuted,
    size: _componentLibrary.IconSize.Lg
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    className: "add-multichain-account__text",
    color: isLoadingState ? _designSystem.TextColor.textMuted : _designSystem.TextColor.infoDefault,
    variant: _designSystem.TextVariant.bodyMdMedium
  }, actionLabel));
};
exports.AddMultichainAccount = AddMultichainAccount;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\add-multichain-account\\add-multichain-account.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\add-multichain-account\\index.ts", {"./add-multichain-account":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\add-multichain-account\\add-multichain-account.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Cadd-multichain-account%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "AddMultichainAccount", {
  enumerable: true,
  get: function () {
    return _addMultichainAccount.AddMultichainAccount;
  }
});
var _addMultichainAccount = require("./add-multichain-account");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\add-multichain-account\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\add-wallet-modal\\add-wallet-modal.tsx", {"../../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/lib/accounts":"D:\\code\\v\\metamask-extension\\shared\\lib\\accounts\\index.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Cadd-wallet-modal%5Cadd-wallet-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.AddWalletModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _designSystemReact = require("@metamask/design-system-react");
var _reactRedux = require("react-redux");
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _routes = require("../../../helpers/constants/routes");
var _app = require("../../../../shared/constants/app");
var _util = require("../../../../app/scripts/lib/util");
var _selectors = require("../../../selectors");
var _accounts = require("../../../../shared/lib/accounts");
var _metametrics = require("../../../../shared/constants/metametrics");
var _metametrics2 = require("../../../contexts/metametrics");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); } // TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths
const AddWalletModal = ({
  onClose,
  isOpen,
  ...props
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const institutionalWalletsEnabled = (0, _reactRedux.useSelector)(_selectors.getManageInstitutionalWallets);
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const addSnapAccountEnabled = (0, _reactRedux.useSelector)(_selectors.getIsAddSnapAccountEnabled);
  const walletOptions = [{
    id: 'import-wallet',
    titleKey: 'importAWallet',
    iconName: _designSystemReact.IconName.Wallet,
    route: _routes.IMPORT_SRP_ROUTE
  }, {
    id: 'import-account',
    titleKey: 'importAnAccount',
    iconName: _designSystemReact.IconName.Download,
    route: _routes.ADD_WALLET_PAGE_ROUTE
  }, {
    id: 'hardware-wallet',
    titleKey: 'addAHardwareWallet',
    iconName: _designSystemReact.IconName.Hardware,
    route: _routes.CONNECT_HARDWARE_ROUTE
  }, ...(institutionalWalletsEnabled ? [{
    id: 'institutional-wallet',
    titleKey: 'manageInstitutionalWallets',
    iconName: _designSystemReact.IconName.Add,
    route: `/snaps/view/${encodeURIComponent(_accounts.INSTITUTIONAL_WALLET_SNAP_ID)}`
  }] : [])];
  const handleOptionClick = option => {
    onClose === null || onClose === void 0 || onClose();

    // Hardware wallet connections require expanded view
    if (option.id === 'hardware-wallet') {
      if ((0, _util.getEnvironmentType)() === _app.ENVIRONMENT_TYPE_POPUP) {
        var _global$platform$open, _global$platform;
        (_global$platform$open = (_global$platform = global.platform).openExtensionInBrowser) === null || _global$platform$open === void 0 || _global$platform$open.call(_global$platform, option.route);
      } else {
        history.push(option.route);
      }
    } else {
      history.push(option.route);
    }
  };
  const handleSnapAccountLinkClick = (0, _react.useCallback)(() => {
    trackEvent({
      category: _metametrics.MetaMetricsEventCategory.Navigation,
      event: _metametrics.MetaMetricsEventName.AccountAddSelected,
      properties: {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        account_type: _metametrics.MetaMetricsEventAccountType.Snap,
        location: 'Main Menu',
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        hd_entropy_index: null
      }
    });
    global.platform.openTab({
      url: "https://snaps.metamask.io/account-management"
    });
  }, [trackEvent]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, _extends({
    isOpen: isOpen,
    onClose: onClose
  }, props), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onClose: onClose
  }, t('addWallet')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, {
    paddingLeft: 0,
    paddingRight: 0,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 2
  }, walletOptions.map(option => /*#__PURE__*/_react.default.createElement(_designSystemReact.Box, {
    key: option.id,
    onClick: () => handleOptionClick(option),
    onKeyDown: e => {
      if (e.key === 'Enter' || e.key === ' ') {
        e.preventDefault();
        handleOptionClick(option);
      }
    },
    alignItems: _designSystemReact.BoxAlignItems.Center,
    padding: 4,
    gap: 3,
    backgroundColor: _designSystemReact.BoxBackgroundColor.BackgroundDefault,
    flexDirection: _designSystemReact.BoxFlexDirection.Row,
    borderColor: _designSystemReact.BoxBorderColor.BorderMuted,
    className: "hover:bg-background-default-hover cursor-pointer transition-all duration-200 w-full text-left outline-none focus:outline-none focus:shadow-none focus-visible:shadow-[inset_0_0_0_2px_var(--color-primary-default)]",
    tabIndex: 0,
    "data-testid": `add-wallet-modal-${option.id}`
  }, /*#__PURE__*/_react.default.createElement(_designSystemReact.Icon, {
    name: option.iconName,
    size: _designSystemReact.IconSize.Md,
    color: _designSystemReact.IconColor.IconAlternative
  }), /*#__PURE__*/_react.default.createElement(_designSystemReact.Text, {
    variant: _designSystemReact.TextVariant.BodyMd,
    fontWeight: _designSystemReact.FontWeight.Medium,
    color: _designSystemReact.TextColor.TextDefault,
    className: "flex-1"
  }, t(option.titleKey)), /*#__PURE__*/_react.default.createElement(_designSystemReact.Icon, {
    name: _designSystemReact.IconName.ArrowRight,
    size: _designSystemReact.IconSize.Sm
  }))), addSnapAccountEnabled && /*#__PURE__*/_react.default.createElement(_designSystemReact.Box, {
    key: "snap-account",
    onClick: () => handleSnapAccountLinkClick(),
    onKeyDown: e => {
      if (e.key === 'Enter' || e.key === ' ') {
        e.preventDefault();
        handleSnapAccountLinkClick();
      }
    },
    alignItems: _designSystemReact.BoxAlignItems.Center,
    padding: 4,
    gap: 3,
    backgroundColor: _designSystemReact.BoxBackgroundColor.BackgroundDefault,
    flexDirection: _designSystemReact.BoxFlexDirection.Row,
    borderColor: _designSystemReact.BoxBorderColor.BorderMuted,
    className: "hover:bg-background-default-hover cursor-pointer transition-all duration-200 w-full text-left outline-none focus:outline-none focus:shadow-none focus-visible:shadow-[inset_0_0_0_2px_var(--color-primary-default)]",
    tabIndex: 0,
    "data-testid": `add-wallet-modal-snap-account`
  }, /*#__PURE__*/_react.default.createElement(_designSystemReact.Icon, {
    name: _designSystemReact.IconName.Snaps,
    size: _designSystemReact.IconSize.Md,
    color: _designSystemReact.IconColor.IconAlternative
  }), /*#__PURE__*/_react.default.createElement(_designSystemReact.Text, {
    variant: _designSystemReact.TextVariant.BodyMd,
    fontWeight: _designSystemReact.FontWeight.Medium,
    color: _designSystemReact.TextColor.TextDefault,
    className: "flex-1"
  }, t('settingAddSnapAccount')), /*#__PURE__*/_react.default.createElement(_designSystemReact.Icon, {
    name: _designSystemReact.IconName.ArrowRight,
    size: _designSystemReact.IconSize.Sm
  })))));
};
exports.AddWalletModal = AddWalletModal;
var _default = exports.default = AddWalletModal;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\add-wallet-modal\\add-wallet-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\add-wallet-modal\\index.ts", {"./add-wallet-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\add-wallet-modal\\add-wallet-modal.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Cadd-wallet-modal%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "AddWalletModal", {
  enumerable: true,
  get: function () {
    return _addWalletModal.AddWalletModal;
  }
});
var _addWalletModal = require("./add-wallet-modal");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\add-wallet-modal\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\address-qr-code-modal\\address-qr-code-modal.tsx", {"../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/utils/multichain/getBlockExplorerInfo":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\multichain\\getBlockExplorerInfo.ts","../../../hooks/useCopyToClipboard":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useCopyToClipboard.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../multichain/menu-items/view-explorer-menu-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\menu-items\\view-explorer-menu-item.tsx","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","qrcode-generator":"D:\\code\\v\\metamask-extension\\node_modules\\qrcode-generator\\qrcode.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Caddress-qr-code-modal%5Caddress-qr-code-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddressQRCodeModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _qrcodeGenerator = _interopRequireDefault(require("qrcode-generator"));
var _designSystemReact = require("@metamask/design-system-react");
var _componentLibrary = require("../../component-library");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _useCopyToClipboard = require("../../../hooks/useCopyToClipboard");
var _viewExplorerMenuItem = require("../../multichain/menu-items/view-explorer-menu-item");
var _metametrics = require("../../../contexts/metametrics");
var _getBlockExplorerInfo = require("../../../helpers/utils/multichain/getBlockExplorerInfo");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Constants for QR code generation
const QR_CODE_TYPE_NUMBER = 4;
const QR_CODE_CELL_SIZE = 5;
const QR_CODE_MARGIN = 16;
const QR_CODE_ERROR_CORRECTION_LEVEL = 'M';

// Constants for address segmentation
const PREFIX_LEN = 6;
const SUFFIX_LEN = 5;
const AddressQRCodeModal = ({
  isOpen,
  onClose,
  address,
  accountName,
  networkName,
  chainId,
  networkImageSrc
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const [copied, handleCopy] = (0, _useCopyToClipboard.useCopyToClipboard)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);

  // Address segmentation for display
  const addressStart = address.substring(0, PREFIX_LEN);
  const addressMiddle = address.substring(PREFIX_LEN, address.length - SUFFIX_LEN);
  const addressEnd = address.substring(address.length - SUFFIX_LEN);

  // Generate QR code data URL
  const qrImageUrl = (0, _react.useMemo)(() => {
    const qr = (0, _qrcodeGenerator.default)(QR_CODE_TYPE_NUMBER, QR_CODE_ERROR_CORRECTION_LEVEL);
    qr.addData(address);
    qr.make();

    // Get the HTML img tag and extract the data URL
    const imgTag = qr.createImgTag(QR_CODE_CELL_SIZE, QR_CODE_MARGIN);
    const srcMatch = imgTag.match(/src="([^"]+)"/u);
    return srcMatch ? srcMatch[1] : null;
  }, [address]);

  // Handle copy address
  const handleCopyClick = (0, _react.useCallback)(() => {
    handleCopy(address);
  }, [address, handleCopy]);

  // Get block explorer info from network configuration
  const explorerInfo = (0, _getBlockExplorerInfo.getBlockExplorerInfo)(t, address, {
    networkName,
    chainId
  });
  const handleExplorerNavigation = (0, _react.useCallback)(() => {
    if (!explorerInfo) {
      return;
    }
    (0, _viewExplorerMenuItem.openBlockExplorer)(explorerInfo.addressUrl, 'Address QR Code Modal', trackEvent);
  }, [explorerInfo, trackEvent]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: isOpen,
    onClose: onClose
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onClose: onClose,
    backButtonProps: {
      'data-testid': 'address-qr-code-modal-back-button'
    }
  }, t('addressQrCodeModalTitle', [accountName, networkName])), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, {
    className: "pb-1"
  }, /*#__PURE__*/_react.default.createElement(_designSystemReact.Box, {
    flexDirection: _designSystemReact.BoxFlexDirection.Column,
    alignItems: _designSystemReact.BoxAlignItems.Center,
    justifyContent: _designSystemReact.BoxJustifyContent.Center,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_designSystemReact.Box, {
    className: "relative flex border-1 border-muted rounded-2xl",
    justifyContent: _designSystemReact.BoxJustifyContent.Center,
    alignItems: _designSystemReact.BoxAlignItems.Center
  }, qrImageUrl && /*#__PURE__*/_react.default.createElement("img", {
    src: qrImageUrl,
    alt: `QR code: ${address}`
    // Background and border must remain white regardless of theme
    ,
    className: "bg-white border-4 border-white rounded-2xl"
  }), /*#__PURE__*/_react.default.createElement(_designSystemReact.Box
  // Background and border must remain white regardless of theme
  , {
    className: "absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 border-8 border-white bg-white rounded-xl flex",
    justifyContent: _designSystemReact.BoxJustifyContent.Center,
    alignItems: _designSystemReact.BoxAlignItems.Center
  }, /*#__PURE__*/_react.default.createElement(_designSystemReact.AvatarNetwork, {
    name: networkName,
    src: networkImageSrc,
    className: "bg-white" // stay white regardless of theme
  }))), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_designSystemReact.Text, {
    textAlign: _designSystemReact.TextAlign.Center,
    variant: _designSystemReact.TextVariant.HeadingSm
  }, t('addressQrCodeModalHeading', [networkName])), /*#__PURE__*/_react.default.createElement(_designSystemReact.Text, {
    textAlign: _designSystemReact.TextAlign.Center,
    color: _designSystemReact.TextColor.TextAlternative
  }, t('addressQrCodeModalDescription', [networkName]))), /*#__PURE__*/_react.default.createElement(_designSystemReact.Box, {
    flexDirection: _designSystemReact.BoxFlexDirection.Column,
    justifyContent: _designSystemReact.BoxJustifyContent.Center,
    alignItems: _designSystemReact.BoxAlignItems.Center,
    gap: 1,
    className: "w-full"
  }, /*#__PURE__*/_react.default.createElement(_designSystemReact.Text, {
    textAlign: _designSystemReact.TextAlign.Center,
    variant: _designSystemReact.TextVariant.BodyMd,
    fontWeight: _designSystemReact.FontWeight.Medium,
    className: "break-all max-w-64"
  }, /*#__PURE__*/_react.default.createElement(_designSystemReact.Text, {
    asChild: true
  }, /*#__PURE__*/_react.default.createElement("span", null, addressStart)), /*#__PURE__*/_react.default.createElement(_designSystemReact.Text, {
    asChild: true,
    color: _designSystemReact.TextColor.TextAlternative
  }, /*#__PURE__*/_react.default.createElement("span", null, addressMiddle)), /*#__PURE__*/_react.default.createElement(_designSystemReact.Text, {
    asChild: true
  }, /*#__PURE__*/_react.default.createElement("span", null, addressEnd))), /*#__PURE__*/_react.default.createElement(_designSystemReact.Button, {
    variant: _designSystemReact.ButtonVariant.Tertiary,
    endIconName: copied ? _designSystemReact.IconName.CopySuccess : _designSystemReact.IconName.Copy,
    size: _designSystemReact.ButtonSize.Lg,
    isFullWidth: true,
    onClick: handleCopyClick
  }, t('copyAddressShort'))), explorerInfo && /*#__PURE__*/_react.default.createElement(_designSystemReact.Button, {
    variant: _designSystemReact.ButtonVariant.Secondary,
    size: _designSystemReact.ButtonSize.Lg,
    isFullWidth: true,
    onClick: handleExplorerNavigation
  }, explorerInfo.buttonText)))));
};
exports.AddressQRCodeModal = AddressQRCodeModal;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\address-qr-code-modal\\address-qr-code-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\edit-account-name-modal\\edit-account-name-modal.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Cedit-account-name-modal%5Cedit-account-name-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditAccountNameModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _componentLibrary = require("../../component-library");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _actions = require("../../../store/actions");
var _designSystem = require("../../../helpers/constants/design-system");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EditAccountNameModal = ({
  isOpen,
  onClose,
  currentAccountName,
  address
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const [accountName, setAccountName] = (0, _react.useState)('');
  const handleSave = () => {
    if (accountName.trim() && accountName !== currentAccountName) {
      dispatch((0, _actions.setAccountLabel)(address, accountName.trim()));
    }
    onClose();
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: isOpen,
    onClose: onClose
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onClose: onClose,
    onBack: onClose
  }, t('editAccountName')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.FormTextField, {
    label: t('name'),
    value: accountName,
    onChange: e => setAccountName(e.target.value),
    placeholder: currentAccountName,
    autoFocus: true
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative,
    style: {
      wordBreak: 'break-all'
    },
    paddingTop: 1
  }, address)), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonPrimary, {
    onClick: handleSave,
    disabled: !accountName.trim(),
    "aria-label": t('save'),
    block: true,
    marginTop: 4
  }, t('save'))))));
};
exports.EditAccountNameModal = EditAccountNameModal;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\edit-account-name-modal\\edit-account-name-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\edit-account-name-modal\\index.ts", {"./edit-account-name-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\edit-account-name-modal\\edit-account-name-modal.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Cedit-account-name-modal%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EditAccountNameModal", {
  enumerable: true,
  get: function () {
    return _editAccountNameModal.EditAccountNameModal;
  }
});
var _editAccountNameModal = require("./edit-account-name-modal");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\edit-account-name-modal\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-account-cell\\index.ts", {"./multichain-account-cell":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-account-cell\\multichain-account-cell.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Cmultichain-account-cell%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "MultichainAccountCell", {
  enumerable: true,
  get: function () {
    return _multichainAccountCell.MultichainAccountCell;
  }
});
var _multichainAccountCell = require("./multichain-account-cell");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\multichain-account-cell\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-account-cell\\multichain-account-cell.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","../../app/preferred-avatar":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\preferred-avatar\\index.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Cmultichain-account-cell%5Cmultichain-account-cell.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultichainAccountCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _accountTree = require("../../../selectors/multichain-accounts/account-tree");
var _componentLibrary = require("../../component-library");
var _preferredAvatar = require("../../app/preferred-avatar");
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const MultichainAccountCell = ({
  accountId,
  accountName,
  accountNameString,
  onClick,
  balance,
  startAccessory,
  endAccessory,
  selected = false,
  walletName,
  disableHoverEffect = false,
  privacyMode = false
}) => {
  const handleClick = () => onClick === null || onClick === void 0 ? void 0 : onClick(accountId);

  // Use accountNameString for aria-label, or fallback to accountName if it's a string
  const ariaLabelName = accountNameString || (typeof accountName === 'string' ? accountName : 'Account');
  const seedAddressIcon = (0, _reactRedux.useSelector)(state => (0, _accountTree.getIconSeedAddressByAccountGroupId)(state, accountId));
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    style: {
      cursor: onClick ? 'pointer' : 'default',
      position: 'relative'
    },
    padding: 4,
    onClick: handleClick,
    className: `multichain-account-cell${disableHoverEffect ? ' multichain-account-cell--no-hover' : ''}${selected ? ' is-selected' : ''}`,
    "data-testid": `multichain-account-cell-${accountId}`,
    key: `multichain-account-cell-${accountId}`,
    backgroundColor: selected ? _designSystem.BackgroundColor.infoMuted : _designSystem.BackgroundColor.transparent
  }, selected && !startAccessory && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "multichain-account-cell__selected-indicator",
    style: {
      width: '4px',
      position: 'absolute',
      left: '4px',
      top: '4px',
      bottom: '4px'
    },
    borderRadius: _designSystem.BorderRadius.pill,
    backgroundColor: _designSystem.BackgroundColor.primaryDefault,
    "data-testid": `multichain-account-cell-${accountId}-selected-indicator`
  }), startAccessory, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.flexStart,
    style: {
      minWidth: 0,
      flex: 1
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "multichain-account-cell__account-avatar",
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.center,
    borderColor: _designSystem.BorderColor.transparent,
    borderRadius: _designSystem.BorderRadius.XL
  }, /*#__PURE__*/_react.default.createElement(_preferredAvatar.PreferredAvatar, {
    address: seedAddressIcon
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    style: {
      overflow: 'hidden'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    className: "multichain-account-cell__account-name",
    variant: _designSystem.TextVariant.bodyMdMedium,
    marginLeft: 3,
    ellipsis: true
  }, accountName), walletName && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    className: "multichain-account-cell__account-name",
    color: _designSystem.TextColor.textAlternative,
    variant: _designSystem.TextVariant.bodySmMedium,
    marginLeft: 3,
    ellipsis: true
  }, walletName))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    style: {
      flexShrink: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.SensitiveText, {
    className: "multichain-account-cell__account-balance",
    "data-testid": "balance-display",
    variant: _designSystem.TextVariant.bodyMdMedium,
    marginRight: 2,
    isHidden: privacyMode,
    ellipsis: true
  }, balance), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "multichain-account-cell__end_accessory",
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.flexEnd,
    "data-testid": "multichain-account-cell-end-accessory",
    "aria-label": `${ariaLabelName} options`
  }, endAccessory)));
};
exports.MultichainAccountCell = MultichainAccountCell;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\multichain-account-cell\\multichain-account-cell.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-account-edit-modal\\index.ts", {"./multichain-account-edit-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-account-edit-modal\\multichain-account-edit-modal.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Cmultichain-account-edit-modal%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "MultichainAccountEditModal", {
  enumerable: true,
  get: function () {
    return _multichainAccountEditModal.MultichainAccountEditModal;
  }
});
var _multichainAccountEditModal = require("./multichain-account-edit-modal");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\multichain-account-edit-modal\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-account-edit-modal\\multichain-account-edit-modal.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Cmultichain-account-edit-modal%5Cmultichain-account-edit-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultichainAccountEditModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _componentLibrary = require("../../component-library");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _actions = require("../../../store/actions");
var _designSystem = require("../../../helpers/constants/design-system");
var _accountTree = require("../../../selectors/multichain-accounts/account-tree");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MultichainAccountEditModal = ({
  isOpen,
  onClose,
  accountGroupId
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const accountGroup = (0, _reactRedux.useSelector)(state => (0, _accountTree.getMultichainAccountGroupById)(state, accountGroupId));
  const currentAccountName = (accountGroup === null || accountGroup === void 0 ? void 0 : accountGroup.metadata.name) || '';
  const [accountName, setAccountName] = (0, _react.useState)('');
  const [helpText, setHelpText] = (0, _react.useState)('');
  const [showErrorMessage, setShowErrorMessage] = (0, _react.useState)(false);
  const handleSave = (0, _react.useCallback)(async () => {
    const normalizedAccountName = accountName.trim();
    if (normalizedAccountName && normalizedAccountName !== currentAccountName) {
      const result = await dispatch((0, _actions.setAccountGroupName)(accountGroupId, normalizedAccountName));
      if (result) {
        onClose();
      } else {
        setHelpText(t('accountNameAlreadyInUse'));
        setShowErrorMessage(true);
      }
    }
  }, [accountName, currentAccountName, accountGroupId, dispatch, onClose, t]);
  const handleKeyDown = (0, _react.useCallback)(async e => {
    if (e.key === 'Enter' && accountName.trim()) {
      await handleSave();
    }
  }, [accountName, handleSave]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: isOpen,
    onClose: onClose
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onClose: onClose,
    onBack: onClose
  }, t('rename')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.FormTextField, {
    label: t('accountName'),
    "aria-label": t('accountName'),
    "data-testid": "account-name-input",
    value: accountName,
    onChange: e => setAccountName(e.target.value),
    onKeyDown: handleKeyDown,
    placeholder: currentAccountName,
    error: showErrorMessage,
    helpText: helpText,
    helpTextProps: {
      fontWeight: _designSystem.FontWeight.Medium
    },
    autoFocus: true
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonSecondary, {
    onClick: handleSave,
    disabled: !accountName.trim(),
    "aria-label": t('confirm'),
    block: true,
    marginTop: 4
  }, t('confirm'))))));
};
exports.MultichainAccountEditModal = MultichainAccountEditModal;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\multichain-account-edit-modal\\multichain-account-edit-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-account-list-menu\\index.ts", {"./multichain-account-list-menu":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-account-list-menu\\multichain-account-list-menu.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Cmultichain-account-list-menu%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "MultichainAccountListMenu", {
  enumerable: true,
  get: function () {
    return _multichainAccountListMenu.MultichainAccountListMenu;
  }
});
var _multichainAccountListMenu = require("./multichain-account-list-menu");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\multichain-account-list-menu\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-account-list-menu\\multichain-account-list-menu.tsx", {"../../../../shared/constants/app-state":"D:\\code\\v\\metamask-extension\\shared\\constants\\app-state.ts","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../component-library/text-field-search/text-field-search":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\text-field-search\\text-field-search.tsx","../../multichain/account-menu":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-menu\\index.ts","../multichain-accounts-tree":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-accounts-tree\\index.ts","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Cmultichain-account-list-menu%5Cmultichain-account-list-menu.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultichainAccountListMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _keyringApi = require("@metamask/keyring-api");
var _componentLibrary = require("../../component-library");
var _textFieldSearch = require("../../component-library/text-field-search/text-field-search");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _metametrics = require("../../../contexts/metametrics");
var _selectors = require("../../../selectors");
var _actions = require("../../../store/actions");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _trace = require("../../../../shared/lib/trace");
var _appState = require("../../../../shared/constants/app-state");
var _accountTree = require("../../../selectors/multichain-accounts/account-tree");
var _multichainAccountsTree = require("../multichain-accounts-tree");
var _accountMenu = require("../../multichain/account-menu");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MultichainAccountListMenu = ({
  onClose,
  privacyMode = false,
  showAccountCreation = true,
  accountListItemProps,
  allowedAccountTypes = [_keyringApi.EthAccountType.Eoa, _keyringApi.EthAccountType.Erc4337, _keyringApi.BtcAccountType.P2pkh, _keyringApi.BtcAccountType.P2sh, _keyringApi.BtcAccountType.P2wpkh, _keyringApi.BtcAccountType.P2tr, _keyringApi.SolAccountType.DataAccount]
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const hdEntropyIndex = (0, _reactRedux.useSelector)(_selectors.getHDEntropyIndex);
  (0, _react.useEffect)(() => {
    (0, _trace.endTrace)({
      name: _trace.TraceName.AccountList
    });
  }, []);
  const allChainIds = (0, _reactRedux.useSelector)(_selectors.getAllChainsToPoll);
  const selectedAccount = (0, _reactRedux.useSelector)(_selectors.getSelectedInternalAccount);
  const connectedSites = (0, _reactRedux.useSelector)(_selectors.getConnectedSubjectsForAllAddresses);
  const currentTabOrigin = (0, _reactRedux.useSelector)(_selectors.getOriginOfCurrentTab);
  const dispatch = (0, _reactRedux.useDispatch)();
  const walletAccountCollection = (0, _reactRedux.useSelector)(_accountTree.getWalletsWithAccountsSimplified);
  const defaultHomeActiveTabName = (0, _reactRedux.useSelector)(_selectors.getDefaultHomeActiveTabName);
  const [searchPattern, setSearchPattern] = (0, _react.useState)('');

  // Here we are getting the keyring of the last selected account
  // if it is not an hd keyring, we will use the primary keyring
  const onAccountTreeItemClick = (0, _react.useCallback)(account => {
    onClose();
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.Navigation,
      event: _metametrics2.MetaMetricsEventName.NavAccountSwitched,
      properties: {
        location: 'Main Menu',
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        hd_entropy_index: hdEntropyIndex
      }
    });
    (0, _trace.endTrace)({
      name: _appState.ACCOUNT_OVERVIEW_TAB_KEY_TO_TRACE_NAME_MAP[defaultHomeActiveTabName]
    });
    (0, _trace.trace)({
      name: _appState.ACCOUNT_OVERVIEW_TAB_KEY_TO_TRACE_NAME_MAP[defaultHomeActiveTabName]
    });
    dispatch((0, _actions.setSelectedAccount)(account.address));
    dispatch((0, _actions.detectNfts)(allChainIds));
  }, [dispatch, onClose, trackEvent, defaultHomeActiveTabName, hdEntropyIndex, allChainIds]);
  const onSearchBarChange = (0, _react.useCallback)(e => setSearchPattern(e.target.value), []);
  return /*#__PURE__*/_react.default.createElement(_accountMenu.AccountMenu, {
    onClose: onClose,
    showAccountCreation: showAccountCreation
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 4,
    paddingRight: 4,
    paddingBottom: 4,
    paddingTop: 0
  }, /*#__PURE__*/_react.default.createElement(_textFieldSearch.TextFieldSearch, {
    size: _componentLibrary.TextFieldSearchSize.Sm,
    width: _designSystem.BlockSize.Full,
    placeholder: t('search'),
    value: searchPattern,
    onChange: onSearchBarChange,
    clearButtonOnClick: () => setSearchPattern(''),
    "data-testid": "multichain-account-menu-search-bar"
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "multichain-account-menu-popover__list"
  }, /*#__PURE__*/_react.default.createElement(_multichainAccountsTree.MultichainAccountsTree, {
    wallets: walletAccountCollection,
    allowedAccountTypes: allowedAccountTypes,
    connectedSites: connectedSites,
    currentTabOrigin: currentTabOrigin,
    privacyMode: privacyMode,
    accountTreeItemProps: accountListItemProps,
    searchPattern: searchPattern,
    selectedAccount: selectedAccount,
    onClose: onClose,
    onAccountTreeItemClick: onAccountTreeItemClick
  })));
};
exports.MultichainAccountListMenu = MultichainAccountListMenu;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\multichain-account-list-menu\\multichain-account-list-menu.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-account-list\\index.ts", {"./multichain-account-list":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-account-list\\multichain-account-list.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Cmultichain-account-list%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "MultichainAccountList", {
  enumerable: true,
  get: function () {
    return _multichainAccountList.MultichainAccountList;
  }
});
var _multichainAccountList = require("./multichain-account-list");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\multichain-account-list\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-account-list\\multichain-account-list.tsx", {"../../../../shared/constants/app-state":"D:\\code\\v\\metamask-extension\\shared\\constants\\app-state.ts","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../hooks/useFormatters":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useFormatters.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/assets":"D:\\code\\v\\metamask-extension\\ui\\selectors\\assets.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../add-multichain-account":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\add-multichain-account\\index.ts","../multichain-account-cell":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-account-cell\\index.ts","../multichain-account-edit-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-account-edit-modal\\index.ts","../multichain-account-menu":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-account-menu\\index.ts","@metamask/account-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Cmultichain-account-list%5Cmultichain-account-list.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultichainAccountList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _accountApi = require("@metamask/account-api");
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _componentLibrary = require("../../component-library");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _designSystem = require("../../../helpers/constants/design-system");
var _multichainAccountCell = require("../multichain-account-cell");
var _actions = require("../../../store/actions");
var _routes = require("../../../helpers/constants/routes");
var _metametrics = require("../../../../shared/constants/metametrics");
var _trace = require("../../../../shared/lib/trace");
var _appState = require("../../../../shared/constants/app-state");
var _selectors = require("../../../selectors");
var _metametrics2 = require("../../../contexts/metametrics");
var _multichainAccountMenu = require("../multichain-account-menu");
var _addMultichainAccount = require("../add-multichain-account");
var _multichainAccountEditModal = require("../multichain-account-edit-modal");
var _assets = require("../../../selectors/assets");
var _useFormatters = require("../../../hooks/useFormatters");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MultichainAccountList = ({
  wallets,
  selectedAccountGroups,
  handleAccountClick,
  isInSearchMode = false,
  displayWalletHeader = true,
  showAccountCheckbox = false
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const history = (0, _reactRouterDom.useHistory)();
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const t = (0, _useI18nContext.useI18nContext)();
  const defaultHomeActiveTabName = (0, _reactRedux.useSelector)(_selectors.getDefaultHomeActiveTabName);
  const {
    formatCurrencyWithMinThreshold
  } = (0, _useFormatters.useFormatters)();
  const allBalances = (0, _reactRedux.useSelector)(_assets.selectBalanceForAllWallets);
  const hdEntropyIndex = (0, _reactRedux.useSelector)(_selectors.getHDEntropyIndex);
  const {
    privacyMode
  } = (0, _reactRedux.useSelector)(_selectors.getPreferences);
  (0, _react.useEffect)(() => {
    (0, _trace.endTrace)({
      name: _trace.TraceName.AccountList
    });
  }, []);
  const [isAccountRenameModalOpen, setIsAccountRenameModalOpen] = (0, _react.useState)(false);
  const [renameAccountGroupId, setRenameAccountGroupId] = (0, _react.useState)(undefined);
  const [openMenuAccountId, setOpenMenuAccountId] = (0, _react.useState)(null);
  const [isHiddenAccountsExpanded, setIsHiddenAccountsExpanded] = (0, _react.useState)(false);
  const handleAccountRenameActionModalClose = (0, _react.useCallback)(() => {
    setIsAccountRenameModalOpen(false);
    setRenameAccountGroupId(undefined);
  }, [setIsAccountRenameModalOpen, setRenameAccountGroupId]);
  const handleAccountRenameAction = (0, _react.useCallback)(accountGroupId => {
    setRenameAccountGroupId(accountGroupId);
    setIsAccountRenameModalOpen(true);
    setOpenMenuAccountId(null);
  }, [setIsAccountRenameModalOpen, setRenameAccountGroupId]);
  const handleMenuToggle = (0, _react.useCallback)(accountGroupId => {
    // If the same menu is clicked, close it, otherwise open the new one
    setOpenMenuAccountId(current => current === accountGroupId ? null : accountGroupId);
  }, []);

  // Convert selectedAccountGroups array to Set for O(1) lookup
  const selectedAccountGroupsSet = (0, _react.useMemo)(() => new Set(selectedAccountGroups), [selectedAccountGroups]);
  const {
    pinnedGroups,
    hiddenGroups
  } = (0, _react.useMemo)(() => {
    const pinned = [];
    const hidden = [];

    // Collect all groups to categorize them
    Object.entries(wallets).forEach(([walletId, walletData]) => {
      Object.entries(walletData.groups || {}).forEach(([groupId, groupData]) => {
        if (groupData.metadata.pinned) {
          pinned.push({
            groupId,
            groupData,
            walletId
          });
        } else if (groupData.metadata.hidden) {
          hidden.push({
            groupId,
            groupData,
            walletId
          });
        }
      });
    });
    return {
      pinnedGroups: pinned,
      hiddenGroups: hidden
    };
  }, [wallets]);
  const walletTree = (0, _react.useMemo)(() => {
    const defaultHandleAccountClick = accountGroupId => {
      trackEvent({
        category: _metametrics.MetaMetricsEventCategory.Navigation,
        event: _metametrics.MetaMetricsEventName.NavAccountSwitched,
        properties: {
          location: 'Main Menu',
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          hd_entropy_index: hdEntropyIndex
        }
      });
      (0, _trace.endTrace)({
        name: _appState.ACCOUNT_OVERVIEW_TAB_KEY_TO_TRACE_NAME_MAP[defaultHomeActiveTabName]
      });
      (0, _trace.trace)({
        name: _appState.ACCOUNT_OVERVIEW_TAB_KEY_TO_TRACE_NAME_MAP[defaultHomeActiveTabName]
      });
      dispatch((0, _actions.setSelectedMultichainAccount)(accountGroupId));
      history.push(_routes.DEFAULT_ROUTE);
    };
    const handleAccountClickToUse = handleAccountClick ?? defaultHandleAccountClick;
    const renderAccountCell = (groupId, groupData, walletId, showWalletName = false) => {
      var _allBalances$wallets, _wallets;
      // If prop is provided, attempt render balance. Otherwise do not render balance.
      const account = allBalances === null || allBalances === void 0 || (_allBalances$wallets = allBalances.wallets) === null || _allBalances$wallets === void 0 || (_allBalances$wallets = _allBalances$wallets[walletId]) === null || _allBalances$wallets === void 0 || (_allBalances$wallets = _allBalances$wallets.groups) === null || _allBalances$wallets === void 0 ? void 0 : _allBalances$wallets[groupId];
      const balance = (account === null || account === void 0 ? void 0 : account.totalBalanceInUserCurrency) ?? 0;
      const currency = (account === null || account === void 0 ? void 0 : account.userCurrency) ?? '';

      // TODO: Implement logic for removable accounts
      const isRemovable = false;
      return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        className: "multichain-account-menu-popover__list--menu-item",
        key: `multichain-account-cell-${groupId}`
      }, /*#__PURE__*/_react.default.createElement(_multichainAccountCell.MultichainAccountCell, {
        accountId: groupId,
        accountName: groupData.metadata.name,
        accountNameString: groupData.metadata.name,
        balance: formatCurrencyWithMinThreshold(balance, currency),
        selected: selectedAccountGroupsSet.has(groupId),
        onClick: handleAccountClickToUse,
        privacyMode: privacyMode,
        walletName: showWalletName ? (_wallets = wallets[walletId]) === null || _wallets === void 0 || (_wallets = _wallets.metadata) === null || _wallets === void 0 ? void 0 : _wallets.name : undefined,
        startAccessory: showAccountCheckbox ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
          marginRight: 4
        }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Checkbox, {
          isChecked: selectedAccountGroupsSet.has(groupId),
          onChange: () => {
            handleAccountClickToUse(groupId);
          }
        })) : undefined,
        endAccessory: /*#__PURE__*/_react.default.createElement(_multichainAccountMenu.MultichainAccountMenu, {
          accountGroupId: groupId,
          isRemovable: isRemovable,
          handleAccountRenameAction: handleAccountRenameAction,
          isOpen: openMenuAccountId === groupId,
          onToggle: () => handleMenuToggle(groupId)
        })
      }));
    };
    const result = [];

    // Render pinned section (if there are any pinned accounts)
    if (pinnedGroups.length > 0) {
      const pinnedHeader = /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        key: "pinned-header",
        "data-testid": "multichain-account-tree-pinned-header",
        display: _designSystem.Display.Flex,
        alignItems: _designSystem.AlignItems.center,
        paddingLeft: 4,
        paddingRight: 4,
        paddingTop: 2,
        paddingBottom: 2
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        variant: _designSystem.TextVariant.bodyMdMedium,
        color: _designSystem.TextColor.textAlternative
      }, t('pinned')));
      result.push(pinnedHeader);
      pinnedGroups.forEach(({
        groupId,
        groupData,
        walletId
      }) => {
        result.push(renderAccountCell(groupId, groupData, walletId, true));
      });
    }

    // Render wallets with their non-pinned, non-hidden accounts
    // Show wallet headers if there are multiple wallets OR if there are pinned accounts
    const shouldShowWalletHeaders = displayWalletHeader || pinnedGroups.length > 0;
    const walletSections = Object.entries(wallets).reduce((walletsAccumulator, [walletId, walletData]) => {
      var _walletData$metadata;
      const walletName = (_walletData$metadata = walletData.metadata) === null || _walletData$metadata === void 0 ? void 0 : _walletData$metadata.name;
      const walletHeader = /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        key: `wallet-header-${walletId}`,
        "data-testid": "multichain-account-tree-wallet-header",
        display: _designSystem.Display.Flex,
        justifyContent: _designSystem.JustifyContent.spaceBetween,
        alignItems: _designSystem.AlignItems.center,
        paddingLeft: 4,
        paddingRight: 4,
        paddingTop: 2,
        paddingBottom: 2
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        variant: _designSystem.TextVariant.bodyMdMedium,
        color: _designSystem.TextColor.textAlternative
      }, walletName));
      const groupsItems = Object.entries(walletData.groups || {}).flatMap(([groupId, groupData]) => {
        var _groupData$metadata, _groupData$metadata2;
        const shouldSkip = ((_groupData$metadata = groupData.metadata) === null || _groupData$metadata === void 0 ? void 0 : _groupData$metadata.pinned) || ((_groupData$metadata2 = groupData.metadata) === null || _groupData$metadata2 === void 0 ? void 0 : _groupData$metadata2.hidden);
        if (shouldSkip) {
          return [];
        }
        return [renderAccountCell(groupId, groupData, walletId)];
      });
      if (!isInSearchMode && walletData.type === _accountApi.AccountWalletType.Entropy) {
        groupsItems.push(/*#__PURE__*/_react.default.createElement(_addMultichainAccount.AddMultichainAccount, {
          walletId: walletId,
          key: `add-multichain-account-${walletId}`
        }));
      }

      // Only show wallet header if we should show headers AND there are accounts to display in this wallet
      const showThisWalletHeader = shouldShowWalletHeaders && groupsItems.length > 0;
      return [...walletsAccumulator, showThisWalletHeader ? walletHeader : null, ...groupsItems];
    }, []);
    result.push(...walletSections);

    // Render hidden section (if there are any hidden accounts)
    if (hiddenGroups.length > 0) {
      const hiddenHeader = /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        key: "hidden-header",
        as: "button",
        onClick: () => setIsHiddenAccountsExpanded(!isHiddenAccountsExpanded),
        backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
        display: _designSystem.Display.Flex,
        justifyContent: _designSystem.JustifyContent.spaceBetween,
        alignItems: _designSystem.AlignItems.center,
        paddingLeft: 4,
        paddingRight: 4,
        paddingTop: 2,
        paddingBottom: 2,
        width: _designSystem.BlockSize.Full,
        className: "hidden-accounts-list",
        "data-testid": "multichain-account-tree-hidden-header"
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        variant: _designSystem.TextVariant.bodyMdMedium,
        color: _designSystem.TextColor.textAlternative
      }, t('hidden'), " (", hiddenGroups.length, ")"), /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
        name: isHiddenAccountsExpanded ? _componentLibrary.IconName.ArrowUp : _componentLibrary.IconName.ArrowDown,
        size: _componentLibrary.IconSize.Sm,
        color: _designSystem.IconColor.iconDefault
      }));
      result.push(hiddenHeader);

      // Only render hidden accounts when expanded
      if (isHiddenAccountsExpanded) {
        hiddenGroups.forEach(({
          groupId,
          groupData,
          walletId
        }) => {
          result.push(renderAccountCell(groupId, groupData, walletId, true));
        });
      }
    }
    return result;
  }, [handleAccountClick, wallets, pinnedGroups, hiddenGroups, trackEvent, hdEntropyIndex, defaultHomeActiveTabName, dispatch, history, isInSearchMode, displayWalletHeader, allBalances, formatCurrencyWithMinThreshold, selectedAccountGroupsSet, privacyMode, showAccountCheckbox, handleAccountRenameAction, handleMenuToggle, openMenuAccountId, t, isHiddenAccountsExpanded]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, walletTree, isAccountRenameModalOpen && /*#__PURE__*/_react.default.createElement(_multichainAccountEditModal.MultichainAccountEditModal, {
    key: renameAccountGroupId,
    isOpen: isAccountRenameModalOpen,
    onClose: handleAccountRenameActionModalClose,
    accountGroupId: renameAccountGroupId
  }));
};
exports.MultichainAccountList = MultichainAccountList;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\multichain-account-list\\multichain-account-list.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-account-menu-items\\multichain-account-menu-items.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Cmultichain-account-menu-items%5Cmultichain-account-menu-items.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultichainAccountMenuItems = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MultichainAccountMenuItems = ({
  menuConfig
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const menuItems = (0, _react.useMemo)(() => {
    return menuConfig.map((item, index, menuConfigurations) => {
      const isLast = index === menuConfigurations.length - 1;
      const isDisabled = Boolean(item.disabled);
      return !isDisabled && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        key: item.textKey,
        className: (0, _classnames.default)('multichain-account-cell-menu-item', {
          'multichain-account-cell-menu-item--with-border': !isLast,
          'multichain-account-cell-menu-item--disabled': isDisabled,
          'multichain-account-cell-menu-item--enabled': !isDisabled
        }),
        paddingLeft: 4,
        paddingRight: 4,
        paddingTop: 3,
        paddingBottom: 3,
        display: _designSystem.Display.Flex,
        justifyContent: _designSystem.JustifyContent.spaceBetween,
        alignItems: _designSystem.AlignItems.center,
        onClick: item.onClick,
        "aria-label": t(item.textKey)
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        fontWeight: _designSystem.FontWeight.Medium,
        variant: _designSystem.TextVariant.bodyMdMedium,
        color: item.textColor
      }, t(item.textKey)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
        name: item.iconName,
        size: _componentLibrary.IconSize.Md
      }));
    });
  }, [menuConfig, t]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, menuItems);
};
exports.MultichainAccountMenuItems = MultichainAccountMenuItems;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\multichain-account-menu-items\\multichain-account-menu-items.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-account-menu\\index.ts", {"./multichain-account-menu":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-account-menu\\multichain-account-menu.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Cmultichain-account-menu%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "MultichainAccountMenu", {
  enumerable: true,
  get: function () {
    return _multichainAccountMenu.MultichainAccountMenu;
  }
});
var _multichainAccountMenu = require("./multichain-account-menu");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\multichain-account-menu\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-account-menu\\multichain-account-menu.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../multichain-account-menu-items/multichain-account-menu-items":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-account-menu-items\\multichain-account-menu-items.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Cmultichain-account-menu%5Cmultichain-account-menu.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultichainAccountMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _routes = require("../../../helpers/constants/routes");
var _multichainAccountMenuItems = require("../multichain-account-menu-items/multichain-account-menu-items");
var _actions = require("../../../store/actions");
var _accountTree = require("../../../selectors/multichain-accounts/account-tree");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MultichainAccountMenu = ({
  accountGroupId,
  isRemovable,
  buttonBackgroundColor,
  handleAccountRenameAction,
  isOpen = false,
  onToggle
}) => {
  const history = (0, _reactRouterDom.useHistory)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const popoverRef = (0, _react.useRef)(null);
  const accountTree = (0, _reactRedux.useSelector)(_accountTree.getAccountTree);

  // Get the account group metadata to check pinned/hidden state
  const accountGroupMetadata = (0, _react.useMemo)(() => {
    const {
      wallets
    } = accountTree;
    for (const wallet of Object.values(wallets)) {
      var _wallet$groups;
      const group = (_wallet$groups = wallet.groups) === null || _wallet$groups === void 0 ? void 0 : _wallet$groups[accountGroupId];
      if (group) {
        return group.metadata;
      }
    }
    return null;
  }, [accountTree, accountGroupId]);
  const isPinned = (accountGroupMetadata === null || accountGroupMetadata === void 0 ? void 0 : accountGroupMetadata.pinned) ?? false;
  const isHidden = (accountGroupMetadata === null || accountGroupMetadata === void 0 ? void 0 : accountGroupMetadata.hidden) ?? false;
  const togglePopover = e => {
    e.stopPropagation();
    onToggle === null || onToggle === void 0 || onToggle();
  };
  const menuConfig = (0, _react.useMemo)(() => {
    const handleAccountDetailsClick = mouseEvent => {
      mouseEvent.stopPropagation();
      const multichainAccountDetailsPageRoute = `${_routes.MULTICHAIN_ACCOUNT_DETAILS_PAGE_ROUTE}/${encodeURIComponent(accountGroupId)}`;
      history.push(multichainAccountDetailsPageRoute);
    };
    const handleAccountRenameClick = mouseEvent => {
      mouseEvent.stopPropagation();
      mouseEvent.preventDefault();
      if (handleAccountRenameAction) {
        handleAccountRenameAction(accountGroupId);
      }
    };
    const handleAccountAddressesClick = mouseEvent => {
      mouseEvent.stopPropagation();
      mouseEvent.preventDefault();
      const multichainAccountAddressesPageRoute = `${_routes.MULTICHAIN_ACCOUNT_ADDRESS_LIST_PAGE_ROUTE}/${encodeURIComponent(accountGroupId)}`;
      history.push(multichainAccountAddressesPageRoute);
    };
    const handleAccountPinClick = async mouseEvent => {
      mouseEvent.stopPropagation();
      mouseEvent.preventDefault();

      // If account is hidden, unhide it first before pinning
      if (isHidden) {
        await dispatch((0, _actions.setAccountGroupHidden)(accountGroupId, false));
      }
      await dispatch((0, _actions.setAccountGroupPinned)(accountGroupId, !isPinned));
      onToggle === null || onToggle === void 0 || onToggle();
    };
    const handleAccountHideClick = async mouseEvent => {
      mouseEvent.stopPropagation();
      mouseEvent.preventDefault();

      // If account is pinned, unpin it first before hiding
      if (isPinned) {
        await dispatch((0, _actions.setAccountGroupPinned)(accountGroupId, false));
      }
      await dispatch((0, _actions.setAccountGroupHidden)(accountGroupId, !isHidden));
      onToggle === null || onToggle === void 0 || onToggle();
    };
    const handleAccountRemoveClick = mouseEvent => {
      // TODO: Implement account remove click handling
      mouseEvent.stopPropagation();
      mouseEvent.preventDefault();
    };
    const baseMenuItems = [{
      textKey: 'accountDetails',
      iconName: _componentLibrary.IconName.Details,
      onClick: handleAccountDetailsClick
    }, {
      textKey: 'rename',
      iconName: _componentLibrary.IconName.Edit,
      onClick: handleAccountRenameClick
    }, {
      textKey: 'addresses',
      iconName: _componentLibrary.IconName.QrCode,
      onClick: handleAccountAddressesClick
    }, {
      textKey: isPinned ? 'unpin' : 'pinToTop',
      iconName: isPinned ? _componentLibrary.IconName.Unpin : _componentLibrary.IconName.Pin,
      onClick: handleAccountPinClick
    }, {
      textKey: isHidden ? 'showAccount' : 'hideAccount',
      iconName: isHidden ? _componentLibrary.IconName.Eye : _componentLibrary.IconName.EyeSlash,
      onClick: handleAccountHideClick
    }];
    if (isRemovable) {
      baseMenuItems.push({
        textKey: 'remove',
        iconName: _componentLibrary.IconName.Trash,
        onClick: handleAccountRemoveClick,
        textColor: _designSystem.TextColor.errorDefault
      });
    }
    return baseMenuItems;
  }, [accountGroupId, handleAccountRenameAction, history, isRemovable, isPinned, isHidden, dispatch, onToggle]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "multichain-account-cell-popover-menu-button",
    ref: popoverRef,
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    backgroundColor: buttonBackgroundColor || _designSystem.BackgroundColor.backgroundMuted,
    borderRadius: _designSystem.BorderRadius.LG,
    padding: 1,
    onClick: togglePopover
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    className: "multichain-account-cell-popover-menu-button-icon",
    name: _componentLibrary.IconName.MoreVertical
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Popover, {
    className: "multichain-account-cell-popover-menu",
    isOpen: isOpen,
    position: _componentLibrary.PopoverPosition.LeftStart,
    referenceElement: popoverRef.current,
    matchWidth: false,
    borderRadius: _designSystem.BorderRadius.LG,
    isPortal: true,
    flip: true,
    onClickOutside: onToggle
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalFocus, {
    restoreFocus: true,
    initialFocusRef: popoverRef
  }, /*#__PURE__*/_react.default.createElement(_multichainAccountMenuItems.MultichainAccountMenuItems, {
    menuConfig: menuConfig
  }))));
};
exports.MultichainAccountMenu = MultichainAccountMenu;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\multichain-account-menu\\multichain-account-menu.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-accounts-tree\\index.ts", {"./multichain-accounts-tree":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-accounts-tree\\multichain-accounts-tree.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Cmultichain-accounts-tree%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "MultichainAccountsTree", {
  enumerable: true,
  get: function () {
    return _multichainAccountsTree.MultichainAccountsTree;
  }
});
var _multichainAccountsTree = require("./multichain-accounts-tree");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\multichain-accounts-tree\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-accounts-tree\\multichain-accounts-tree.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../multichain/account-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-list-item\\index.js","../../multichain/account-list-menu/hidden-account-list":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-list-menu\\hidden-account-list.js","./utils":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-accounts-tree\\utils.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Cmultichain-accounts-tree%5Cmultichain-accounts-tree.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultichainAccountsTree = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _accountListItem = require("../../multichain/account-list-item");
var _hiddenAccountList = require("../../multichain/account-list-menu/hidden-account-list");
var _routes = require("../../../helpers/constants/routes");
var _utils = require("./utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const MultichainAccountsTree = ({
  wallets,
  allowedAccountTypes,
  connectedSites,
  currentTabOrigin,
  privacyMode,
  accountTreeItemProps,
  searchPattern,
  selectedAccount,
  onClose,
  onAccountTreeItemClick
}) => {
  const history = (0, _reactRouterDom.useHistory)();
  const handleWalletDetailsClick = (0, _react.useCallback)(walletId => {
    history.push(_routes.WALLET_DETAILS_ROUTE.replace(':id', encodeURIComponent(walletId)));
    onClose();
  }, [history, onClose]);
  const accountsTree = (0, _react.useMemo)(() => {
    // We keep a flag to check if there are any hidden accounts
    let hasHiddenAccounts = false;
    const allWallets = Object.entries(wallets).reduce((walletsAccumulator, [walletId, walletData]) => {
      var _walletData$metadata;
      const walletName = (_walletData$metadata = walletData.metadata) === null || _walletData$metadata === void 0 ? void 0 : _walletData$metadata.name;
      const walletHeader = /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        key: `wallet-header-${walletId}`,
        "data-testid": "multichain-account-tree-wallet-header",
        display: _designSystem.Display.Flex,
        justifyContent: _designSystem.JustifyContent.spaceBetween,
        alignItems: _designSystem.AlignItems.center,
        paddingLeft: 4,
        paddingRight: 4
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        variant: _designSystem.TextVariant.bodySm,
        fontWeight: _designSystem.FontWeight.Medium,
        color: _designSystem.TextColor.textAlternative
      }, walletName), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
        size: _componentLibrary.ButtonLinkSize.Sm,
        color: _designSystem.TextColor.primaryDefault,
        fontWeight: _designSystem.FontWeight.Medium,
        onClick: () => handleWalletDetailsClick(walletId),
        style: {
          fontSize: '0.875rem'
        }
      }, "Details"));

      // Process all groups in the wallet and collect its account items
      const groupsItems = Object.entries(walletData.groups || {}).flatMap(([groupId, groupData]) => {
        // Filter accounts based on allowed types and the search pattern
        const filteredAccounts = groupData.accounts.filter(account => {
          const matchesSearch = searchPattern ? (0, _utils.matchesSearchPattern)(searchPattern, account) : true;
          const isAllowedType = allowedAccountTypes.includes(account.type);
          hasHiddenAccounts || (hasHiddenAccounts = account.hidden);
          return matchesSearch && isAllowedType && !account.hidden;
        });
        if (filteredAccounts.length === 0) {
          return [];
        }

        // Create account items for group
        const accountItems = filteredAccounts.sort((accountA, accountB) => {
          // Convert boolean values to numbers for sorting
          return Number(accountB.pinned) - Number(accountA.pinned);
        }).map(account => {
          var _connectedSites$accou;
          const connectedSite = (_connectedSites$accou = connectedSites[account.address]) === null || _connectedSites$accou === void 0 ? void 0 : _connectedSites$accou.find(({
            origin
          }) => origin === currentTabOrigin);
          return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
            className: "multichain-account-menu-popover__list--menu-item",
            key: `box-${account.id}`
          }, /*#__PURE__*/_react.default.createElement(_accountListItem.AccountListItem, _extends({
            onClick: onAccountTreeItemClick,
            account: account,
            key: `account-list-item-${account.id}`,
            selected: selectedAccount.id === account.id,
            closeMenu: onClose,
            connectedAvatar: connectedSite === null || connectedSite === void 0 ? void 0 : connectedSite.iconUrl,
            menuType: _accountListItem.AccountListItemMenuTypes.Account,
            currentTabOrigin: currentTabOrigin,
            isActive: account.active,
            privacyMode: privacyMode,
            isPinned: account.pinned,
            showAccountLabels: false
          }, accountTreeItemProps)));
        });
        return [/*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
          key: `account-group-${groupId}`,
          marginBottom: 4,
          style: {
            borderBottom: '1px solid var(--color-border-muted)'
          }
        }, accountItems)];
      });

      // Skip adding wallet if no groupsItems exist
      if (groupsItems.length === 0) {
        return walletsAccumulator;
      }
      return [...walletsAccumulator, walletHeader, ...groupsItems];
    }, []);

    // Add a final section for hidden accounts
    if (hasHiddenAccounts) {
      allWallets.push(/*#__PURE__*/_react.default.createElement(_hiddenAccountList.HiddenAccountList, {
        onClose: onClose
      }));
    }
    return allWallets;
  }, [wallets, searchPattern, allowedAccountTypes, connectedSites, onClose, currentTabOrigin, privacyMode, accountTreeItemProps, selectedAccount, onAccountTreeItemClick, handleWalletDetailsClick]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, accountsTree);
};
exports.MultichainAccountsTree = MultichainAccountsTree;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\multichain-accounts-tree\\multichain-accounts-tree.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-accounts-tree\\utils.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Cmultichain-accounts-tree%5Cutils.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.matchesSearchPattern = void 0;
/**
 * Checks if the account matches the search pattern.
 *
 * @param pattern - The search pattern to match against.
 * @param account - The account to check.
 * @returns True if the account matches the search pattern, false otherwise.
 */
const matchesSearchPattern = (pattern, account) => {
  const lowercasedPattern = pattern.toLowerCase();
  return account.metadata.name.toLowerCase().includes(lowercasedPattern) || account.address.toLowerCase().includes(lowercasedPattern);
};
exports.matchesSearchPattern = matchesSearchPattern;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\multichain-accounts-tree\\utils.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-address-row\\multichain-address-row.tsx", {"../../../../shared/modules/network.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\network.utils.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Cmultichain-address-row%5Cmultichain-address-row.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.MultichainAddressRow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _utils = require("@metamask/utils");
var _bridgeController = require("@metamask/bridge-controller");
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../component-library");
var _util = require("../../../helpers/utils/util");
var _multichain = require("../../../selectors/multichain");
var _network = require("../../../../shared/modules/network.utils");
var _useI18nContext = require("../../../hooks/useI18nContext");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MultichainAddressRow = ({
  chainId,
  networkName,
  address,
  copyActionParams,
  qrActionParams,
  className = ''
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const networkImageSrc = (0, _multichain.getImageForChainId)(chainId.startsWith(_utils.KnownCaipNamespace.Eip155) ? (0, _network.convertCaipToHexChainId)(chainId) : chainId);
  const truncatedAddress = (0, _util.shortenAddress)(address); // Shorten address for display
  const [subText, setSubText] = (0, _react.useState)(truncatedAddress); // Message below the network name
  const [copyIcon, setCopyIcon] = (0, _react.useState)(_componentLibrary.IconName.Copy); // Default copy icon state
  const [addressCopied, setAddressCopied] = (0, _react.useState)(false);

  // Track timeout ID for managing `setTimeout`
  const timeoutRef = (0, _react.useRef)(null);

  // Update `subText` when the address prop changes
  (0, _react.useEffect)(() => {
    setSubText(truncatedAddress);
  }, [address, truncatedAddress]);

  // Cleanup timeout when component unmounts
  (0, _react.useEffect)(() => {
    return () => {
      if (timeoutRef.current) {
        clearTimeout(timeoutRef.current);
        timeoutRef.current = null;
      }
    };
  }, []);

  // Handle "Copy" button click events
  const handleCopyClick = () => {
    // Clear existing timeout if clicking multiple times in rapid succession
    if (timeoutRef.current) {
      clearTimeout(timeoutRef.current);
    }
    setAddressCopied(true);

    // Trigger copy callback and update UI state
    copyActionParams.callback();
    setSubText(copyActionParams.message);
    setCopyIcon(_componentLibrary.IconName.CopySuccess);

    // Reset state after 1 second and track the new timeout
    timeoutRef.current = window.setTimeout(() => {
      setSubText(truncatedAddress);
      setCopyIcon(_componentLibrary.IconName.Copy);
      timeoutRef.current = null; // Clear the reference after timeout resolves
      setAddressCopied(false);
    }, 1000);
  };

  // Handle "QR Code" button click
  const handleQrClick = () => {
    qrActionParams === null || qrActionParams === void 0 || qrActionParams.callback(address, networkName, (0, _bridgeController.formatChainIdToCaip)(chainId), networkImageSrc);
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: `multichain-address-row ${className}`,
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    padding: 4,
    gap: 4,
    "data-testid": "multichain-address-row",
    backgroundColor: addressCopied ? _designSystem.BackgroundColor.successMuted : _designSystem.BackgroundColor.backgroundDefault
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
    size: _componentLibrary.AvatarNetworkSize.Md,
    name: networkName,
    src: networkImageSrc,
    borderRadius: _designSystem.BorderRadius.LG,
    "data-testid": "multichain-address-row-network-icon"
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.flexStart,
    style: {
      flex: 1,
      minWidth: 0
    } // Ensure the text shrinks properly
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: _designSystem.TextColor.textDefault,
    "data-testid": "multichain-address-row-network-name",
    ellipsis: true,
    width: _designSystem.BlockSize.Full
  }, networkName), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: addressCopied ? _designSystem.TextColor.successDefault : _designSystem.TextColor.textAlternative,
    "data-testid": "multichain-address-row-address"
  }, subText)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    gap: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    iconName: copyIcon,
    size: _componentLibrary.ButtonIconSize.Md,
    onClick: handleCopyClick,
    ariaLabel: t('copyAddressShort'),
    color: addressCopied ? _designSystem.IconColor.successDefault : _designSystem.IconColor.iconDefault,
    "data-testid": "multichain-address-row-copy-button"
  }), qrActionParams ? /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    iconName: _componentLibrary.IconName.QrCode,
    size: _componentLibrary.ButtonIconSize.Md,
    onClick: handleQrClick,
    ariaLabel: "Show QR code",
    color: _designSystem.IconColor.iconDefault,
    "data-testid": "multichain-address-row-qr-button"
  }) : null));
};
exports.MultichainAddressRow = MultichainAddressRow;
var _default = exports.default = MultichainAddressRow;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\multichain-address-row\\multichain-address-row.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-address-rows-list\\index.ts", {"./multichain-address-rows-list":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-address-rows-list\\multichain-address-rows-list.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Cmultichain-address-rows-list%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "MultichainAddressRowsList", {
  enumerable: true,
  get: function () {
    return _multichainAddressRowsList.MultichainAddressRowsList;
  }
});
var _multichainAddressRowsList = require("./multichain-address-rows-list");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\multichain-address-rows-list\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-address-rows-list\\multichain-address-rows-list.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useCopyToClipboard":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useCopyToClipboard.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../multichain-address-row/multichain-address-row":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-address-row\\multichain-address-row.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Cmultichain-address-rows-list%5Cmultichain-address-rows-list.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.MultichainAddressRowsList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../component-library");
var _useCopyToClipboard = require("../../../hooks/useCopyToClipboard");
var _multichainAddressRow = require("../multichain-address-row/multichain-address-row");
var _accountTree = require("../../../selectors/multichain-accounts/account-tree");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MultichainAddressRowsList = ({
  groupId,
  onQrClick
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const [searchPattern, setSearchPattern] = _react.default.useState('');
  const [, handleCopy] = (0, _useCopyToClipboard.useCopyToClipboard)();
  const getAccountsSpreadByNetworkByGroupId = (0, _reactRedux.useSelector)(state => (0, _accountTree.getInternalAccountListSpreadByScopesByGroupId)(state, groupId));
  const filteredItems = (0, _react.useMemo)(() => {
    if (!searchPattern.trim()) {
      return getAccountsSpreadByNetworkByGroupId;
    }
    const pattern = searchPattern.toLowerCase();
    const filtered = getAccountsSpreadByNetworkByGroupId.filter(({
      networkName,
      account
    }) => {
      return networkName.toLowerCase().includes(pattern) || account.address.toLowerCase().includes(pattern);
    });
    return filtered;
  }, [getAccountsSpreadByNetworkByGroupId, searchPattern]);
  const handleSearchChange = event => {
    setSearchPattern(event.target.value);
  };
  const handleClearSearch = () => {
    setSearchPattern('');
  };
  const renderAddressItem = (0, _react.useCallback)((item, index) => {
    const handleCopyClick = () => {
      handleCopy(item.account.address);
    };
    return /*#__PURE__*/_react.default.createElement(_multichainAddressRow.MultichainAddressRow, {
      key: `${item.account.address}-${item.scope}-${index}`,
      chainId: item.scope,
      networkName: item.networkName,
      address: item.account.address,
      copyActionParams: {
        message: t('multichainAccountAddressCopied'),
        callback: handleCopyClick
      },
      qrActionParams: {
        callback: onQrClick
      }
    });
  }, [handleCopy, onQrClick, t]);
  const renderedRows = (0, _react.useMemo)(() => {
    return filteredItems.map((item, index) => renderAddressItem(item, index));
  }, [filteredItems, renderAddressItem]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    "data-testid": "multichain-address-rows-list"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 4,
    paddingRight: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.TextFieldSearch, {
    size: _componentLibrary.TextFieldSearchSize.Lg,
    placeholder: t('searchNetworks'),
    value: searchPattern,
    onChange: handleSearchChange,
    clearButtonOnClick: handleClearSearch,
    width: _designSystem.BlockSize.Full,
    borderWidth: 0,
    marginBottom: 2,
    backgroundColor: _designSystem.BackgroundColor.backgroundMuted,
    borderRadius: _designSystem.BorderRadius.LG,
    "data-testid": "multichain-address-rows-list-search"
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, filteredItems.length > 0 ? renderedRows : /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    color: _designSystem.TextColor.textAlternative,
    textAlign: _designSystem.TextAlign.Center,
    paddingTop: 8,
    "data-testid": "multichain-address-rows-list-empty-message"
  }, searchPattern ? t('noNetworksFound') : t('noNetworksAvailable'))));
};
exports.MultichainAddressRowsList = MultichainAddressRowsList;
var _default = exports.default = MultichainAddressRowsList;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\multichain-address-rows-list\\multichain-address-rows-list.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-private-key-list\\index.ts", {"./multichain-private-key-list":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-private-key-list\\multichain-private-key-list.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Cmultichain-private-key-list%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "MultichainPrivateKeyList", {
  enumerable: true,
  get: function () {
    return _multichainPrivateKeyList.MultichainPrivateKeyList;
  }
});
var _multichainPrivateKeyList = require("./multichain-private-key-list");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\multichain-private-key-list\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-private-key-list\\multichain-private-key-list.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useCopyToClipboard":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useCopyToClipboard.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../multichain-address-row/multichain-address-row":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-address-row\\multichain-address-row.tsx","@metamask/keyring-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Cmultichain-private-key-list%5Cmultichain-private-key-list.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultichainPrivateKeyList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _keyringController = require("@metamask/keyring-controller");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../component-library");
var _useCopyToClipboard = require("../../../hooks/useCopyToClipboard");
var _multichainAddressRow = require("../multichain-address-row/multichain-address-row");
var _accountTree = require("../../../selectors/multichain-accounts/account-tree");
var _actions = require("../../../store/actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Check if the account has the private key available according to its keyring type.
 * TODO: Add support for KeyringTypes.snap
 *
 * @param account - The internal account to check.
 * @returns True if the private key is available, false otherwise.
 */
const hasPrivateKeyAvailable = account => account.metadata.keyring.type === _keyringController.KeyringTypes.hd || account.metadata.keyring.type === _keyringController.KeyringTypes.simple;
const MultichainPrivateKeyList = ({
  groupId,
  goBack
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const [password, setPassword] = (0, _react.useState)('');
  const [wrongPassword, setWrongPassword] = (0, _react.useState)(false);
  const [reveal, setReveal] = (0, _react.useState)(false);
  const [privateKeys, setPrivateKeys] = (0, _react.useState)({});
  const cleanStateVariables = (0, _react.useCallback)(() => {
    setPrivateKeys({});
    setPassword('');
    setWrongPassword(false);
    setReveal(false);
  }, []);
  (0, _react.useEffect)(() => () => {
    // Clean state variables on unmount
    cleanStateVariables();
  }, [cleanStateVariables]);
  const [, handleCopy] = (0, _useCopyToClipboard.useCopyToClipboard)();
  const accountsSpreadByNetworkByGroupId = (0, _reactRedux.useSelector)(state => (0, _accountTree.getInternalAccountListSpreadByScopesByGroupId)(state, groupId));
  const accounts = (0, _reactRedux.useSelector)(state => (0, _accountTree.getInternalAccountsFromGroupById)(state, groupId));
  const handlePasswordChange = (0, _react.useCallback)(e => {
    setPassword(e.target.value);
  }, [setPassword]);
  const validatePassword = (0, _react.useCallback)(async () => {
    try {
      await (0, _actions.verifyPassword)(password);
      setWrongPassword(false);
      setReveal(true);
    } catch (error) {
      setWrongPassword(true);
      setReveal(false);
    }
  }, [password]);
  const unlockPrivateKeys = (0, _react.useCallback)(async () => {
    const pkAccounts = accounts.filter(account => hasPrivateKeyAvailable(account));
    const addresses = pkAccounts.map(account => account.address);
    const pks = await dispatch((0, _actions.exportAccounts)(password, addresses));
    const privateKeyMap = await addresses.reduce((acc, address, index) => {
      acc[address] = pks[index];
      return acc;
    }, {});
    setPrivateKeys(privateKeyMap);
  }, [accounts, dispatch, password]);
  const onSubmit = (0, _react.useCallback)(async () => {
    await validatePassword();
    await unlockPrivateKeys();
  }, [validatePassword, unlockPrivateKeys]);
  const onCancel = (0, _react.useCallback)(() => {
    cleanStateVariables();
    goBack();
  }, [cleanStateVariables, goBack]);
  const renderedPasswordInput = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingTop: 8,
    paddingBottom: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    color: _designSystem.TextColor.textDefault
  }, t('enterYourPassword')), /*#__PURE__*/_react.default.createElement(_componentLibrary.TextField, {
    type: _componentLibrary.TextFieldType.Password,
    placeholder: t('password'),
    size: _componentLibrary.TextFieldSize.Lg,
    value: password,
    onChange: handlePasswordChange,
    error: wrongPassword,
    width: _designSystem.BlockSize.Full,
    testId: "multichain-private-key-password-input"
  }), wrongPassword ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.errorDefault,
    "data-testid": "wrong-password-msg"
  }, t('wrongPassword')) : null), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    gap: 4,
    paddingBottom: 2,
    paddingTop: 8
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    block: true,
    "data-testid": "cancel-button",
    onClick: onCancel,
    size: _componentLibrary.ButtonSize.Lg,
    variant: _componentLibrary.ButtonVariant.Secondary
  }, t('cancel')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    block: true,
    "data-testid": "confirm-button",
    onClick: onSubmit,
    size: _componentLibrary.ButtonSize.Lg,
    variant: _componentLibrary.ButtonVariant.Primary
  }, t('confirm')))), [handlePasswordChange, onCancel, onSubmit, password, t, wrongPassword]);
  const renderAddressItem = (0, _react.useCallback)((item, index) => {
    const privateKey = privateKeys[item.account.address];
    if (!privateKey) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
    }
    const handleCopyClick = () => {
      handleCopy(privateKey);
    };
    return /*#__PURE__*/_react.default.createElement(_multichainAddressRow.MultichainAddressRow, {
      key: `${item.account.address}-${item.scope}-${index}`,
      chainId: item.scope,
      networkName: item.networkName,
      address: item.account.address,
      copyActionParams: {
        message: t('multichainAccountPrivateKeyCopied'),
        callback: handleCopyClick
      }
    });
  }, [handleCopy, privateKeys, t]);
  const renderedRows = (0, _react.useMemo)(() => {
    return accountsSpreadByNetworkByGroupId.map((item, index) => renderAddressItem(item, index));
  }, [accountsSpreadByNetworkByGroupId, renderAddressItem]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    "data-testid": "multichain-private-keyring-list"
  }, reveal ? renderedRows : renderedPasswordInput);
};
exports.MultichainPrivateKeyList = MultichainPrivateKeyList;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\multichain-private-key-list\\multichain-private-key-list.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-site-cell\\avatar-group\\multichain-avatar-group.tsx", {"../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../app/preferred-avatar":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\preferred-avatar\\index.ts","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Cmultichain-site-cell%5Cavatar-group%5Cmultichain-avatar-group.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultichainAvatarGroupType = exports.MultichainAvatarGroup = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _designSystemReact = require("@metamask/design-system-react");
var _designSystem = require("../../../../helpers/constants/design-system");
var _componentLibrary = require("../../../component-library");
var _preferredAvatar = require("../../../app/preferred-avatar");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
let MultichainAvatarGroupType = exports.MultichainAvatarGroupType = /*#__PURE__*/function (MultichainAvatarGroupType) {
  MultichainAvatarGroupType["ACCOUNT"] = "ACCOUNT";
  MultichainAvatarGroupType["NETWORK"] = "NETWORK";
  return MultichainAvatarGroupType;
}({});
const MultichainAvatarGroup = ({
  type,
  className = '',
  limit = 4,
  members = []
}) => {
  const visibleMembers = members.slice(0, limit);
  const showTag = members.length > limit;
  const tagValue = `+${(members.length - limit).toLocaleString()}`;
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    alignItems: _designSystem.AlignItems.center,
    display: _designSystem.Display.Flex,
    className: (0, _classnames.default)('multichain-avatar-group', className),
    "data-testid": "avatar-group",
    gap: 1
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    gap: 1
  }, visibleMembers.map((member, i) => {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      borderRadius: _designSystem.BorderRadius.full,
      key: i
    }, type === MultichainAvatarGroupType.ACCOUNT && /*#__PURE__*/_react.default.createElement(_preferredAvatar.PreferredAvatar, {
      "data-testid": `avatar-${i}`,
      size: _designSystemReact.AvatarAccountSize.Xs,
      address: member.avatarValue
    }), type === MultichainAvatarGroupType.NETWORK && /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
      "data-testid": `network-avatar-${i}`,
      src: member.avatarValue,
      name: member.symbol ?? '',
      size: _componentLibrary.AvatarNetworkSize.Xs
    }));
  })), showTag && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 1,
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative
  }, tagValue)));
};
exports.MultichainAvatarGroup = MultichainAvatarGroup;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\multichain-site-cell\\avatar-group\\multichain-avatar-group.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-site-cell\\multichain-site-cell.tsx", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","../../app/preferred-avatar":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\preferred-avatar\\index.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../multichain/edit-networks-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\edit-networks-modal\\index.js","../../multichain/pages/review-permissions-page/site-cell/site-cell-connection-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\review-permissions-page\\site-cell\\site-cell-connection-list-item.js","./tool-tip/multichain-site-cell-tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-site-cell\\tool-tip\\multichain-site-cell-tooltip.tsx","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Cmultichain-site-cell%5Cmultichain-site-cell.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultichainSiteCell = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _designSystemReact = require("@metamask/design-system-react");
var _designSystem = require("../../../helpers/constants/design-system");
var _preferredAvatar = require("../../app/preferred-avatar");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _componentLibrary = require("../../component-library");
var _editNetworksModal = require("../../multichain/edit-networks-modal");
var _metametrics = require("../../../contexts/metametrics");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _accountTree = require("../../../selectors/multichain-accounts/account-tree");
var _siteCellConnectionListItem = require("../../multichain/pages/review-permissions-page/site-cell/site-cell-connection-list-item");
var _multichainSiteCellTooltip = require("./tool-tip/multichain-site-cell-tooltip");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MultichainSiteCell = ({
  nonTestNetworks,
  testNetworks,
  supportedAccountGroups,
  showEditAccounts,
  onSelectChainIds,
  selectedAccountGroupIds,
  selectedChainIds,
  isConnectFlow,
  hideAllToasts = () => undefined
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const allNetworks = [...nonTestNetworks, ...testNetworks];
  const seedAddressIcon = (0, _reactRedux.useSelector)(state => {
    // Only get seed address if we have a valid account group ID
    if (selectedAccountGroupIds.length > 0 && selectedAccountGroupIds[0]) {
      try {
        return (0, _accountTree.getIconSeedAddressByAccountGroupId)(state, selectedAccountGroupIds[0]);
      } catch (error) {
        // Handle case where account group is not found or has no accounts
        return '';
      }
    }
    return '';
  });
  const [showEditNetworksModal, setShowEditNetworksModal] = (0, _react.useState)(false);
  const selectedNetworks = allNetworks.filter(({
    caipChainId
  }) => selectedChainIds.includes(caipChainId));
  const selectedChainIdsLength = selectedChainIds.length;
  const handleOpenAccountsModal = () => {
    hideAllToasts === null || hideAllToasts === void 0 || hideAllToasts();
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.Navigation,
      event: _metametrics2.MetaMetricsEventName.ViewPermissionedAccounts,
      properties: {
        location: 'Connect view (permissions tab), Permissions toast, Permissions (dapp)'
      }
    });
    showEditAccounts();
  };
  const handleOpenNetworksModal = () => {
    hideAllToasts === null || hideAllToasts === void 0 || hideAllToasts();
    setShowEditNetworksModal(true);
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.Navigation,
      event: _metametrics2.MetaMetricsEventName.ViewPermissionedNetworks,
      properties: {
        location: 'Connect view (permissions tab), Permissions toast, Permissions (dapp)'
      }
    });
  };
  const accountMessageConnectedState = (0, _react.useMemo)(() => {
    var _supportedAccountGrou;
    return selectedAccountGroupIds.length === 1 ? t('connectedWithAccountName', [((_supportedAccountGrou = supportedAccountGroups.find(account => account.id === selectedAccountGroupIds[0])) === null || _supportedAccountGrou === void 0 ? void 0 : _supportedAccountGrou.metadata.name) || '']) : t('connectedWithAccount', [selectedAccountGroupIds.length]);
  }, [selectedAccountGroupIds, supportedAccountGroups, t]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    padding: 4,
    gap: 4,
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    borderRadius: _designSystem.BorderRadius.LG
  }, /*#__PURE__*/_react.default.createElement(_siteCellConnectionListItem.SiteCellConnectionListItem, {
    title: t('accountsPermissionsTitle'),
    iconName: _componentLibrary.IconName.Eye,
    connectedMessage: accountMessageConnectedState,
    unconnectedMessage: t('requestingFor', [selectedAccountGroupIds.length]),
    isConnectFlow: isConnectFlow,
    onClick: handleOpenAccountsModal,
    paddingBottomValue: 2,
    paddingTopValue: 0,
    content: selectedAccountGroupIds.length === 1 ? /*#__PURE__*/_react.default.createElement(_preferredAvatar.PreferredAvatar, {
      address: seedAddressIcon,
      size: _designSystemReact.AvatarAccountSize.Xs
    }) : /*#__PURE__*/_react.default.createElement(_multichainSiteCellTooltip.MultichainSiteCellTooltip, {
      accountGroups: supportedAccountGroups.filter(account => selectedAccountGroupIds.includes(account.id))
    })
  }), /*#__PURE__*/_react.default.createElement(_siteCellConnectionListItem.SiteCellConnectionListItem, {
    title: t('permission_walletSwitchEthereumChain'),
    iconName: _componentLibrary.IconName.Global,
    connectedMessage: t('connectedWithNetwork', [selectedChainIdsLength]),
    unconnectedMessage: t('requestingFor'),
    isConnectFlow: isConnectFlow,
    onClick: handleOpenNetworksModal,
    paddingTopValue: 2,
    paddingBottomValue: 0,
    content: /*#__PURE__*/_react.default.createElement(_multichainSiteCellTooltip.MultichainSiteCellTooltip, {
      networks: selectedNetworks
    })
  })), showEditNetworksModal && /*#__PURE__*/_react.default.createElement(_editNetworksModal.EditNetworksModal, {
    nonTestNetworks: nonTestNetworks,
    testNetworks: testNetworks,
    defaultSelectedChainIds: selectedChainIds,
    onClose: () => setShowEditNetworksModal(false),
    onSubmit: onSelectChainIds
  }));
};
exports.MultichainSiteCell = MultichainSiteCell;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\multichain-site-cell\\multichain-site-cell.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-site-cell\\tool-tip\\multichain-site-cell-tooltip.tsx", {"../../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","../../../app/preferred-avatar":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\preferred-avatar\\index.ts","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../avatar-group/multichain-avatar-group":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-site-cell\\avatar-group\\multichain-avatar-group.tsx","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-tippy":"D:\\code\\v\\metamask-extension\\node_modules\\react-tippy\\dist\\react-tippy.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Cmultichain-site-cell%5Ctool-tip%5Cmultichain-site-cell-tooltip.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultichainSiteCellTooltip = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactTippy = require("react-tippy");
var _designSystemReact = require("@metamask/design-system-react");
var _designSystem = require("../../../../helpers/constants/design-system");
var _componentLibrary = require("../../../component-library");
var _preferredAvatar = require("../../../app/preferred-avatar");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _network = require("../../../../../shared/constants/network");
var _multichainAvatarGroup = require("../avatar-group/multichain-avatar-group");
var _accountTree = require("../../../../selectors/multichain-accounts/account-tree");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TOOLTIP_LIMIT = 4;
const AVATAR_GROUP_LIMIT = 4;
const TooltipContent = /*#__PURE__*/_react.default.memo(({
  accountGroups,
  networks
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const displayAccountGroups = (accountGroups === null || accountGroups === void 0 ? void 0 : accountGroups.slice(0, TOOLTIP_LIMIT)) ?? [];
  const displayNetworks = (networks === null || networks === void 0 ? void 0 : networks.slice(0, TOOLTIP_LIMIT)) ?? [];
  const hasMoreAccounts = accountGroups && accountGroups.length > TOOLTIP_LIMIT;
  const hasMoreNetworks = networks && networks.length > TOOLTIP_LIMIT;
  const getMoreText = (0, _react.useMemo)(() => {
    if (hasMoreAccounts && accountGroups) {
      return t('moreAccounts', [accountGroups.length - TOOLTIP_LIMIT]);
    }
    if (networks) {
      return t('moreNetworks', [networks.length - TOOLTIP_LIMIT]);
    }
    return '';
  }, [hasMoreAccounts, accountGroups, networks, t]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    "data-test-id": "site-cell-tooltip"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column
  }, displayAccountGroups.map(acc => /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    alignItems: _designSystem.AlignItems.center,
    textAlign: _designSystem.TextAlign.Left,
    key: acc.id,
    padding: 1,
    paddingInline: 2,
    gap: 2
  }, /*#__PURE__*/_react.default.createElement(_preferredAvatar.PreferredAvatar, {
    size: _designSystemReact.AvatarAccountSize.Xs,
    address: acc.id
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.overlayInverse,
    variant: _designSystem.TextVariant.bodyMdMedium,
    "data-testid": "accounts-list-item-connected-account-name",
    ellipsis: true
  }, acc.metadata.name))), displayNetworks.map(network => /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    alignItems: _designSystem.AlignItems.center,
    textAlign: _designSystem.TextAlign.Left,
    key: network.chainId,
    padding: 1,
    paddingInline: 2,
    gap: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
    size: _componentLibrary.AvatarNetworkSize.Xs,
    src: _network.CHAIN_ID_TO_NETWORK_IMAGE_URL_MAP[network.chainId],
    name: network.name,
    borderStyle: _designSystem.BorderStyle.none
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.overlayInverse,
    variant: _designSystem.TextVariant.bodyMdMedium,
    "data-testid": "accounts-list-item-connected-account-name",
    ellipsis: true
  }, network.name))), (accountGroups && Array.isArray(accountGroups) && hasMoreAccounts || networks && Array.isArray(networks) && hasMoreNetworks) && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    textAlign: _designSystem.TextAlign.Left,
    paddingInline: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textMuted,
    variant: _designSystem.TextVariant.bodyMdMedium,
    "data-testid": "accounts-list-item-plus-more-tooltip"
  }, getMoreText()))));
});
TooltipContent.displayName = 'TooltipContent';
const MultichainSiteCellTooltip = exports.MultichainSiteCellTooltip = /*#__PURE__*/_react.default.memo(({
  accountGroups,
  networks
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const seedAddresses = (0, _reactRedux.useSelector)(state => (0, _accountTree.getIconSeedAddressesByAccountGroups)(state, accountGroups ?? []));
  const avatarAccountsData = (0, _react.useMemo)(() => {
    return (accountGroups === null || accountGroups === void 0 ? void 0 : accountGroups.map(accountGroup => {
      const avatarValue = seedAddresses[accountGroup.id];
      return avatarValue ? {
        avatarValue
      } : null;
    }).filter(item => item !== null)) ?? [];
  }, [accountGroups, seedAddresses]);
  const avatarNetworksData = (0, _react.useMemo)(() => (networks === null || networks === void 0 ? void 0 : networks.map(network => ({
    avatarValue: _network.CHAIN_ID_TO_NETWORK_IMAGE_URL_MAP[network.chainId],
    symbol: network.name
  }))) ?? [], [networks]);
  const hasAccountGroups = Array.isArray(accountGroups) && accountGroups.length > 0;
  const hasNetworks = Array.isArray(avatarNetworksData) && avatarNetworksData.length > 0;
  return /*#__PURE__*/_react.default.createElement(_reactTippy.Tooltip, {
    position: "bottom",
    html: /*#__PURE__*/_react.default.createElement(TooltipContent, {
      accountGroups: accountGroups,
      networks: networks
    }),
    arrow: true,
    offset: 0,
    delay: 50,
    duration: 0,
    size: "small",
    title: t('alertDisableTooltip'),
    trigger: "mouseenter",
    theme: "dark"
  }, hasAccountGroups && /*#__PURE__*/_react.default.createElement(_multichainAvatarGroup.MultichainAvatarGroup, {
    type: _multichainAvatarGroup.MultichainAvatarGroupType.ACCOUNT,
    members: avatarAccountsData,
    limit: AVATAR_GROUP_LIMIT
  }), hasNetworks && /*#__PURE__*/_react.default.createElement(_multichainAvatarGroup.MultichainAvatarGroup, {
    type: _multichainAvatarGroup.MultichainAvatarGroupType.NETWORK,
    members: avatarNetworksData,
    limit: AVATAR_GROUP_LIMIT
  }));
});
MultichainSiteCellTooltip.displayName = 'MultichainSiteCellTooltip';

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\multichain-site-cell\\tool-tip\\multichain-site-cell-tooltip.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-srp-backup\\index.ts", {"./multichain-srp-backup":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-srp-backup\\multichain-srp-backup.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Cmultichain-srp-backup%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "MultichainSrpBackup", {
  enumerable: true,
  get: function () {
    return _multichainSrpBackup.MultichainSrpBackup;
  }
});
var _multichainSrpBackup = require("./multichain-srp-backup");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\multichain-srp-backup\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-srp-backup\\multichain-srp-backup.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../app/srp-quiz-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\srp-quiz-modal\\index.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Cmultichain-srp-backup%5Cmultichain-srp-backup.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultichainSrpBackup = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _classnames = _interopRequireDefault(require("classnames"));
var _designSystemReact = require("@metamask/design-system-react");
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _routes = require("../../../helpers/constants/routes");
var _srpQuizModal = _interopRequireDefault(require("../../app/srp-quiz-modal"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MultichainSrpBackup = ({
  shouldShowBackupReminder = false,
  className = '',
  keyringId
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const [srpQuizModalVisible, setSrpQuizModalVisible] = (0, _react.useState)(false);
  const handleSrpBackupClick = (0, _react.useCallback)(() => {
    if (shouldShowBackupReminder) {
      const backUpSRPRoute = `${_routes.ONBOARDING_REVIEW_SRP_ROUTE}/?isFromReminder=true`;
      history.push(backUpSRPRoute);
    } else {
      setSrpQuizModalVisible(true);
    }
  }, [shouldShowBackupReminder, history, setSrpQuizModalVisible]);
  const handleQuizModalClose = (0, _react.useCallback)(() => {
    setSrpQuizModalVisible(false);
  }, [setSrpQuizModalVisible]);
  const finalClassName = (0, _classnames.default)('multichain-srp-backup', className);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: finalClassName,
    padding: 4,
    width: _designSystem.BlockSize.Full,
    textAlign: _designSystem.TextAlign.Left,
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    alignItems: _designSystem.AlignItems.center,
    backgroundColor: _designSystem.BackgroundColor.backgroundMuted,
    onClick: handleSrpBackupClick,
    "data-testid": "multichain-srp-backup"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: _designSystem.TextColor.textDefault
  }, t('secretRecoveryPhrase'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    gap: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: _designSystem.TextColor.textAlternative
  }, shouldShowBackupReminder ? t('accountDetailsSrpBackUpMessage') : t('srpListStateBackedUp')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.ArrowRight,
    size: _designSystemReact.IconSize.Sm,
    color: _designSystem.IconColor.iconAlternative
  }))), srpQuizModalVisible && keyringId && /*#__PURE__*/_react.default.createElement(_srpQuizModal.default, {
    keyringId: keyringId,
    isOpen: srpQuizModalVisible,
    onClose: handleQuizModalClose,
    closeAfterCompleting: true
  }));
};
exports.MultichainSrpBackup = MultichainSrpBackup;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\multichain-srp-backup\\multichain-srp-backup.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\permissions\\multichain-edit-accounts-page\\multichain-edit-account-wrapper.tsx", {"../../../../hooks/useAccountGroupsForPermissions":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAccountGroupsForPermissions.ts","../../../../pages/permissions-connect/connect-page/utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\connect-page\\utils.ts","./multichain-edit-accounts-page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\permissions\\multichain-edit-accounts-page\\multichain-edit-accounts-page.tsx","@metamask/chain-agnostic-permission":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\chain-agnostic-permission\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Cpermissions%5Cmultichain-edit-accounts-page%5Cmultichain-edit-account-wrapper.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultichainEditAccountsPageWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _chainAgnosticPermission = require("@metamask/chain-agnostic-permission");
var _utils = require("@metamask/utils");
var _utils2 = require("../../../../pages/permissions-connect/connect-page/utils");
var _useAccountGroupsForPermissions = require("../../../../hooks/useAccountGroupsForPermissions");
var _multichainEditAccountsPage = require("./multichain-edit-accounts-page");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MultichainEditAccountsPageWrapper = ({
  title,
  onSubmit,
  onClose,
  permissions
}) => {
  const requestedCaip25CaveatValueWithExistingPermissions = (0, _react.useMemo)(() => {
    return (0, _utils2.getCaip25CaveatValueFromPermissions)(permissions);
  }, [permissions]);
  const requestedCaipAccountIds = (0, _react.useMemo)(() => {
    return (0, _chainAgnosticPermission.getCaipAccountIdsFromCaip25CaveatValue)(requestedCaip25CaveatValueWithExistingPermissions);
  }, [requestedCaip25CaveatValueWithExistingPermissions]);
  const requestedCaipChainIds = (0, _chainAgnosticPermission.getAllScopesFromCaip25CaveatValue)(requestedCaip25CaveatValueWithExistingPermissions).filter(chainId => {
    const {
      namespace
    } = (0, _utils.parseCaipChainId)(chainId);
    return namespace !== _utils.KnownCaipNamespace.Wallet;
  });
  const requestedNamespaces = (0, _chainAgnosticPermission.getAllNamespacesFromCaip25CaveatValue)(requestedCaip25CaveatValueWithExistingPermissions);
  const requestedNamespacesWithoutWallet = requestedNamespaces.filter(namespace => namespace !== _utils.KnownCaipNamespace.Wallet);
  const {
    connectedAccountGroups,
    supportedAccountGroups
  } = (0, _useAccountGroupsForPermissions.useAccountGroupsForPermissions)(requestedCaip25CaveatValueWithExistingPermissions, requestedCaipAccountIds, requestedCaipChainIds, requestedNamespacesWithoutWallet);
  const connectedAccountGroupIds = (0, _react.useMemo)(() => {
    return connectedAccountGroups.map(group => group.id);
  }, [connectedAccountGroups]);
  return /*#__PURE__*/_react.default.createElement(_multichainEditAccountsPage.MultichainEditAccountsPage, {
    title: title,
    defaultSelectedAccountGroups: connectedAccountGroupIds,
    supportedAccountGroups: supportedAccountGroups,
    onSubmit: onSubmit,
    onClose: onClose
  });
};
exports.MultichainEditAccountsPageWrapper = MultichainEditAccountsPageWrapper;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\permissions\\multichain-edit-accounts-page\\multichain-edit-account-wrapper.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\permissions\\multichain-edit-accounts-page\\multichain-edit-accounts-page.tsx", {"../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","../../../../selectors/multichain-accounts/utils":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\utils.ts","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../multichain/pages/page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\index.ts","../../multichain-account-list":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-account-list\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Cpermissions%5Cmultichain-edit-accounts-page%5Cmultichain-edit-accounts-page.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultichainEditAccountsPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _componentLibrary = require("../../../component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _metametrics = require("../../../../../shared/constants/metametrics");
var _metametrics2 = require("../../../../contexts/metametrics");
var _multichainAccountList = require("../../multichain-account-list");
var _accountTree = require("../../../../selectors/multichain-accounts/account-tree");
var _page = require("../../../multichain/pages/page");
var _utils = require("../../../../selectors/multichain-accounts/utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MultichainEditAccountsPage = ({
  title,
  confirmButtonText,
  defaultSelectedAccountGroups,
  supportedAccountGroups,
  onSubmit,
  onClose
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const [selectedAccountGroups, setSelectedAccountGroups] = (0, _react.useState)(defaultSelectedAccountGroups);
  const accountTree = (0, _reactRedux.useSelector)(_accountTree.getAccountTree);
  const walletsWithSupportedAccountGroups = (0, _react.useMemo)(() => {
    const walletMap = new Map();

    // Build wallets from scratch using only supported account groups
    supportedAccountGroups.forEach(group => {
      const walletId = (0, _utils.extractWalletIdFromGroupId)(group.id);
      const walletIdTyped = walletId;
      const wallet = accountTree.wallets[walletIdTyped];
      if (wallet) {
        if (!walletMap.has(walletId)) {
          walletMap.set(walletId, {
            id: wallet.id,
            type: wallet.type,
            metadata: wallet.metadata,
            groups: {}
          });
        }
        walletMap.get(walletId).groups[group.id] = group;
      }
    });
    return Object.fromEntries(walletMap);
  }, [accountTree.wallets, supportedAccountGroups]);
  const handleAccountClick = (0, _react.useCallback)(accountGroupId => {
    if (selectedAccountGroups.includes(accountGroupId)) {
      // Remove item if it exists
      setSelectedAccountGroups(selectedAccountGroups.filter(id => id !== accountGroupId));
    } else {
      // Add item if it doesn't exist
      setSelectedAccountGroups([...selectedAccountGroups, accountGroupId]);
    }
  }, [selectedAccountGroups]);
  const handleConnect = (0, _react.useCallback)(() => {
    const defaultSet = new Set(defaultSelectedAccountGroups);
    const selectedSet = new Set(selectedAccountGroups);
    const addedAccounts = selectedAccountGroups.filter(accountGroup => !defaultSet.has(accountGroup));
    const removedAccounts = defaultSelectedAccountGroups.filter(accountGroup => !selectedSet.has(accountGroup));
    onSubmit(selectedAccountGroups);
    trackEvent({
      category: _metametrics.MetaMetricsEventCategory.Permissions,
      event: _metametrics.MetaMetricsEventName.UpdatePermissionedAccounts,
      properties: {
        addedAccounts: addedAccounts.length,
        removedAccounts: removedAccounts.length,
        location: 'Edit Accounts Modal'
      }
    });
  }, [selectedAccountGroups, defaultSelectedAccountGroups, onSubmit, trackEvent]);
  return /*#__PURE__*/_react.default.createElement(_page.Page, {
    "data-testid": "modal-page",
    className: "main-container connect-page",
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault
  }, /*#__PURE__*/_react.default.createElement(_page.Header, {
    textProps: {
      variant: _designSystem.TextVariant.headingSm
    },
    startAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      size: _componentLibrary.ButtonIconSize.Md,
      ariaLabel: t('back'),
      iconName: _componentLibrary.IconName.ArrowLeft,
      onClick: onClose,
      "data-testid": "back-button"
    })
  }, title ?? t('editAccounts')), /*#__PURE__*/_react.default.createElement(_page.Content, {
    paddingLeft: 4,
    paddingRight: 4,
    backgroundColor: _designSystem.BackgroundColor.transparent
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column
  }, /*#__PURE__*/_react.default.createElement(_multichainAccountList.MultichainAccountList, {
    wallets: walletsWithSupportedAccountGroups,
    selectedAccountGroups: selectedAccountGroups,
    handleAccountClick: handleAccountClick,
    showAccountCheckbox: true
  }))), /*#__PURE__*/_react.default.createElement(_page.Footer, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonSecondary, {
    "data-testid": "connect-more-accounts-button",
    onClick: handleConnect,
    size: _componentLibrary.ButtonSecondarySize.Lg,
    block: true
  }, confirmButtonText ?? t('connect'))));
};
exports.MultichainEditAccountsPage = MultichainEditAccountsPage;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\permissions\\multichain-edit-accounts-page\\multichain-edit-accounts-page.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\permissions\\permission-review-page\\multichain-review-permissions-page.tsx", {"../../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../../shared/lib/multichain/scope-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\multichain\\scope-utils.ts","../../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../../hooks/useAccountGroupsForPermissions":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAccountGroupsForPermissions.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../pages/permissions-connect/connect-page/utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\permissions-connect\\connect-page\\utils.ts","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../multichain/disconnect-all-modal/disconnect-all-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\disconnect-all-modal\\disconnect-all-modal.tsx","../../../multichain/pages/connections/components/no-connection":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\connections\\components\\no-connection.tsx","../../../multichain/pages/page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\index.ts","../../../multichain/permissions-header/permissions-header":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\permissions-header\\permissions-header.tsx","../../../multichain/toast/toast":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\toast\\toast.tsx","../../multichain-site-cell/multichain-site-cell":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\multichain-site-cell\\multichain-site-cell.tsx","../multichain-edit-accounts-page/multichain-edit-accounts-page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\permissions\\multichain-edit-accounts-page\\multichain-edit-accounts-page.tsx","@metamask/chain-agnostic-permission":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\chain-agnostic-permission\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Cpermissions%5Cpermission-review-page%5Cmultichain-review-permissions-page.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultichainReviewPermissionsPageMode = exports.MultichainReviewPermissions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _chainAgnosticPermission = require("@metamask/chain-agnostic-permission");
var _designSystem = require("../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _networks = require("../../../../../shared/modules/selectors/networks");
var _selectors = require("../../../../selectors");
var _actions = require("../../../../store/actions");
var _componentLibrary = require("../../../component-library");
var _toast = require("../../../multichain/toast/toast");
var _noConnection = require("../../../multichain/pages/connections/components/no-connection");
var _page = require("../../../multichain/pages/page");
var _routes = require("../../../../helpers/constants/routes");
var _disconnectAllModal = require("../../../multichain/disconnect-all-modal/disconnect-all-modal");
var _permissionsHeader = require("../../../multichain/permissions-header/permissions-header");
var _network = require("../../../../../shared/constants/network");
var _trace = require("../../../../../shared/lib/trace");
var _multichainSiteCell = require("../../multichain-site-cell/multichain-site-cell");
var _useAccountGroupsForPermissions = require("../../../../hooks/useAccountGroupsForPermissions");
var _utils = require("../../../../pages/permissions-connect/connect-page/utils");
var _scopeUtils = require("../../../../../shared/lib/multichain/scope-utils");
var _multichainEditAccountsPage = require("../multichain-edit-accounts-page/multichain-edit-accounts-page");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
let MultichainReviewPermissionsPageMode = exports.MultichainReviewPermissionsPageMode = /*#__PURE__*/function (MultichainReviewPermissionsPageMode) {
  MultichainReviewPermissionsPageMode["Summary"] = "summary";
  MultichainReviewPermissionsPageMode["EditAccounts"] = "edit-accounts";
  return MultichainReviewPermissionsPageMode;
}({});
const MultichainReviewPermissions = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const history = (0, _reactRouterDom.useHistory)();
  const urlParams = (0, _reactRouterDom.useParams)();
  // @ts-expect-error TODO: Fix this type error by handling undefined parameters
  const securedOrigin = decodeURIComponent(urlParams.origin);
  const [showAccountToast, setShowAccountToast] = (0, _react.useState)(false);
  const [showNetworkToast, setShowNetworkToast] = (0, _react.useState)(false);
  const [showDisconnectAllModal, setShowDisconnectAllModal] = (0, _react.useState)(false);
  const [pageMode, setPageMode] = (0, _react.useState)(MultichainReviewPermissionsPageMode.Summary);
  const activeTabOrigin = securedOrigin;
  const showPermittedNetworkToastOpen = (0, _reactRedux.useSelector)(_selectors.getShowPermittedNetworkToastOpen);
  (0, _react.useEffect)(() => {
    if (showPermittedNetworkToastOpen) {
      setShowNetworkToast(showPermittedNetworkToastOpen);
      dispatch((0, _actions.hidePermittedNetworkToast)());
    }
  }, [showPermittedNetworkToastOpen]);
  const requestAccountsAndChainPermissions = async () => {
    const requestId = await dispatch((0, _actions.requestAccountsAndChainPermissionsWithId)(activeTabOrigin));
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31893
    // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
    history.push(`${_routes.CONNECT_ROUTE}/${requestId}`);
  };

  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  const subjectMetadata = (0, _reactRedux.useSelector)(_selectors.getConnectedSitesList);
  const connectedSubjectsMetadata = subjectMetadata[activeTabOrigin];
  const subjects = (0, _reactRedux.useSelector)(_selectors.getPermissionSubjects);
  const disconnectAllPermissions = () => {
    const subject = subjects[activeTabOrigin];
    if (subject) {
      const permissionMethodNames = Object.values(subject.permissions).map(({
        parentCapability
      }) => parentCapability);
      if (permissionMethodNames.length > 0) {
        const permissionsRecord = {
          [activeTabOrigin]: permissionMethodNames
        };
        dispatch((0, _actions.removePermissionsFor)(permissionsRecord));
      }
    }
    dispatch((0, _actions.hidePermittedNetworkToast)());
  };
  const networkConfigurationsByCaipChainId = (0, _reactRedux.useSelector)(_networks.getAllNetworkConfigurationsByCaipChainId);
  const [nonTestNetworks, testNetworks] = (0, _react.useMemo)(() => Object.entries(networkConfigurationsByCaipChainId).reduce(([nonTestNetworksList, testNetworksList], [chainId, network]) => {
    const caipChainId = chainId;
    const isTestNetwork = _network.CAIP_FORMATTED_EVM_TEST_CHAINS.includes(caipChainId);
    (isTestNetwork ? testNetworksList : nonTestNetworksList).push({
      ...network,
      caipChainId
    });
    return [nonTestNetworksList, testNetworksList];
  }, [[], []]), [networkConfigurationsByCaipChainId]);
  const connectedChainIds = (0, _reactRedux.useSelector)(state => (0, _selectors.getAllPermittedChainsForSelectedTab)(state, activeTabOrigin));
  const handleSelectChainIds = async chainIds => {
    if (chainIds.length === 0) {
      setShowDisconnectAllModal(true);
      return;
    }
    dispatch((0, _actions.setPermittedChains)(activeTabOrigin, chainIds));
    setShowNetworkToast(true);
  };
  const existingPermissions = (0, _reactRedux.useSelector)(state => (0, _selectors.getPermissions)(state, activeTabOrigin));
  const existingCaip25CaveatValue = (0, _react.useMemo)(() => existingPermissions ? (0, _utils.getCaip25CaveatValueFromPermissions)(existingPermissions) : null, [existingPermissions]);
  const existingCaip25AccountIds = (0, _react.useMemo)(() => {
    return (0, _chainAgnosticPermission.getCaipAccountIdsFromCaip25CaveatValue)(existingCaip25CaveatValue ?? {
      requiredScopes: {},
      optionalScopes: {},
      sessionProperties: {},
      isMultichainOrigin: false
    });
  }, [existingCaip25CaveatValue]);
  const existingCaipChainIds = existingCaip25CaveatValue ? (0, _chainAgnosticPermission.getAllScopesFromCaip25CaveatValue)(existingCaip25CaveatValue) : [];
  const {
    supportedAccountGroups,
    connectedAccountGroups,
    existingConnectedCaipAccountIds
  } = (0, _useAccountGroupsForPermissions.useAccountGroupsForPermissions)(existingCaip25CaveatValue ?? {
    requiredScopes: {},
    optionalScopes: {},
    sessionProperties: {},
    isMultichainOrigin: false
  }, existingCaip25AccountIds, existingCaipChainIds, []);
  const selectedAccountGroupIds = (0, _react.useMemo)(() => connectedAccountGroups.map(group => group.id), [connectedAccountGroups]);
  const setModeToEditAccounts = (0, _react.useCallback)(() => {
    setPageMode(MultichainReviewPermissionsPageMode.EditAccounts);
  }, []);
  const handleAccountGroupIdsSelected = (0, _react.useCallback)(accountGroupIds => {
    if (accountGroupIds.length === 0) {
      setPageMode(MultichainReviewPermissionsPageMode.Summary);
      setShowDisconnectAllModal(true);
      return;
    }
    const accountGroups = supportedAccountGroups.filter(group => accountGroupIds.includes(group.id));
    const caipAccountIds = (0, _scopeUtils.getCaip25AccountIdsFromAccountGroupAndScope)(accountGroups, connectedChainIds);
    setPageMode(MultichainReviewPermissionsPageMode.Summary);
    dispatch((0, _actions.setPermittedAccounts)(activeTabOrigin, caipAccountIds));
  }, [activeTabOrigin, connectedChainIds, dispatch, supportedAccountGroups]);
  return pageMode === MultichainReviewPermissionsPageMode.Summary ? /*#__PURE__*/_react.default.createElement(_page.Page, {
    "data-testid": "connections-page",
    className: "main-container connections-page"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_permissionsHeader.PermissionsHeader, {
    securedOrigin: securedOrigin,
    connectedSubjectsMetadata: connectedSubjectsMetadata
  }), /*#__PURE__*/_react.default.createElement(_page.Content, {
    padding: 0
  }, connectedAccountGroups.length > 0 ? /*#__PURE__*/_react.default.createElement(_multichainSiteCell.MultichainSiteCell, {
    nonTestNetworks: nonTestNetworks,
    testNetworks: testNetworks,
    supportedAccountGroups: supportedAccountGroups,
    showEditAccounts: setModeToEditAccounts,
    onSelectChainIds: handleSelectChainIds,
    selectedAccountGroupIds: selectedAccountGroupIds,
    selectedChainIds: connectedChainIds
  }) : /*#__PURE__*/_react.default.createElement(_noConnection.NoConnectionContent, null), showDisconnectAllModal ? /*#__PURE__*/_react.default.createElement(_disconnectAllModal.DisconnectAllModal, {
    type: _disconnectAllModal.DisconnectType.Account,
    hostname: activeTabOrigin,
    onClose: () => setShowDisconnectAllModal(false),
    onClick: () => {
      (0, _trace.trace)({
        name: _trace.TraceName.DisconnectAllModal
      });
      disconnectAllPermissions();
      setShowDisconnectAllModal(false);
      (0, _trace.endTrace)({
        name: _trace.TraceName.DisconnectAllModal
      });
    }
  }) : null), /*#__PURE__*/_react.default.createElement(_page.Footer, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, existingConnectedCaipAccountIds.length > 0 ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    width: _designSystem.BlockSize.Full,
    gap: 2,
    alignItems: _designSystem.AlignItems.center
  }, showAccountToast ? /*#__PURE__*/_react.default.createElement(_toast.ToastContainer, null, /*#__PURE__*/_react.default.createElement(_toast.Toast, {
    text: t('accountPermissionToast'),
    onClose: () => setShowAccountToast(false),
    startAdornment: /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarFavicon, {
      name: connectedSubjectsMetadata === null || connectedSubjectsMetadata === void 0 ? void 0 : connectedSubjectsMetadata.name,
      size: _componentLibrary.AvatarFaviconSize.Sm,
      src: connectedSubjectsMetadata === null || connectedSubjectsMetadata === void 0 ? void 0 : connectedSubjectsMetadata.iconUrl
    })
  })) : null, showNetworkToast ? /*#__PURE__*/_react.default.createElement(_toast.ToastContainer, null, /*#__PURE__*/_react.default.createElement(_toast.Toast, {
    text: t('networkPermissionToast'),
    onClose: () => setShowNetworkToast(false),
    startAdornment: /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarFavicon, {
      name: connectedSubjectsMetadata === null || connectedSubjectsMetadata === void 0 ? void 0 : connectedSubjectsMetadata.name,
      size: _componentLibrary.AvatarFaviconSize.Sm,
      src: connectedSubjectsMetadata === null || connectedSubjectsMetadata === void 0 ? void 0 : connectedSubjectsMetadata.iconUrl
    })
  })) : null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    size: _componentLibrary.ButtonSize.Lg,
    block: true,
    variant: _componentLibrary.ButtonVariant.Secondary,
    startIconName: _componentLibrary.IconName.Logout,
    danger: true,
    onClick: () => setShowDisconnectAllModal(true),
    "data-test-id": "disconnect-all"
  }, t('disconnect'))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, connectedAccountGroups.length > 0 ? /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonPrimary, {
    size: _componentLibrary.ButtonPrimarySize.Lg,
    block: true,
    "data-test-id": "no-connections-button"
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    ,
    onClick: requestAccountsAndChainPermissions
  }, t('connectAccounts')) : null))))) : /*#__PURE__*/_react.default.createElement(_multichainEditAccountsPage.MultichainEditAccountsPage, {
    title: t('editAccounts'),
    confirmButtonText: t('update'),
    supportedAccountGroups: supportedAccountGroups,
    defaultSelectedAccountGroups: selectedAccountGroupIds,
    onSubmit: handleAccountGroupIdsSelected,
    onClose: () => setPageMode(MultichainReviewPermissionsPageMode.Summary)
  });
};
exports.MultichainReviewPermissions = MultichainReviewPermissions;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\permissions\\permission-review-page\\multichain-review-permissions-page.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\smart-contract-account-toggle-section\\index.ts", {"./smart-contract-account-toggle-section":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\smart-contract-account-toggle-section\\smart-contract-account-toggle-section.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Csmart-contract-account-toggle-section%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "SmartContractAccountToggleSection", {
  enumerable: true,
  get: function () {
    return _smartContractAccountToggleSection.SmartContractAccountToggleSection;
  }
});
var _smartContractAccountToggleSection = require("./smart-contract-account-toggle-section");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\smart-contract-account-toggle-section\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\smart-contract-account-toggle-section\\smart-contract-account-toggle-section.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/zendesk-url":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\zendesk-url.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../pages/confirmations/hooks/useEIP7702Networks":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useEIP7702Networks.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/icon/preloader":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\icon\\preloader\\index.js","../smart-contract-account-toggle":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\smart-contract-account-toggle\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Csmart-contract-account-toggle-section%5Csmart-contract-account-toggle-section.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SmartContractAccountToggleSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _zendeskUrl = _interopRequireDefault(require("../../../helpers/constants/zendesk-url"));
var _useEIP7702Networks = require("../../../pages/confirmations/hooks/useEIP7702Networks");
var _smartContractAccountToggle = require("../smart-contract-account-toggle");
var _preloader = _interopRequireDefault(require("../../ui/icon/preloader"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SmartContractAccountToggleSection = ({
  address,
  returnToPage
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    network7702List,
    pending
  } = (0, _useEIP7702Networks.useEIP7702Networks)(address);
  const networkList = (0, _react.useMemo)(() => {
    if (pending) {
      return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        paddingTop: 12,
        paddingBottom: 12,
        display: _designSystem.Display.Flex,
        justifyContent: _designSystem.JustifyContent.center,
        alignItems: _designSystem.AlignItems.center,
        "data-testid": "network-loader"
      }, /*#__PURE__*/_react.default.createElement(_preloader.default, {
        size: 24
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, network7702List.map(network => /*#__PURE__*/_react.default.createElement(_smartContractAccountToggle.SmartContractAccountToggle, {
      key: network.chainIdHex,
      networkConfig: network,
      address: address,
      returnToPage: returnToPage
    })));
  }, [pending, network7702List, address, returnToPage]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    width: _designSystem.BlockSize.Full,
    backgroundColor: _designSystem.BackgroundColor.backgroundSection,
    paddingTop: 3,
    paddingBottom: 4,
    paddingLeft: 4,
    paddingRight: 2,
    style: {
      borderRadius: '8px'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingRight: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    marginBottom: 2
  }, t('enableSmartContractAccount')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textAlternative,
    variant: _designSystem.TextVariant.bodySm
  }, t('enableSmartContractAccountDescription'), ' ', /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    onClick: () => {
      global.platform.openTab({
        url: _zendeskUrl.default.ACCOUNT_UPGRADE
      });
    },
    size: _componentLibrary.ButtonLinkSize.Sm,
    target: "_blank",
    rel: "noopener noreferrer",
    style: {
      height: '22px',
      fontSize: '14px',
      lineHeight: '22px',
      verticalAlign: 'baseline'
    }
  }, t('learnMoreUpperCase')))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, networkList));
};
exports.SmartContractAccountToggleSection = SmartContractAccountToggleSection;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\smart-contract-account-toggle-section\\smart-contract-account-toggle-section.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\smart-contract-account-toggle\\index.ts", {"./smart-contract-account-toggle":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\smart-contract-account-toggle\\smart-contract-account-toggle.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Csmart-contract-account-toggle%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "SmartContractAccountToggle", {
  enumerable: true,
  get: function () {
    return _smartContractAccountToggle.SmartContractAccountToggle;
  }
});
var _smartContractAccountToggle = require("./smart-contract-account-toggle");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\smart-contract-account-toggle\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\smart-contract-account-toggle\\smart-contract-account-toggle.tsx", {"../../../ducks/history/history":"D:\\code\\v\\metamask-extension\\ui\\ducks\\history\\history.js","../../../ducks/smart-accounts/smart-accounts":"D:\\code\\v\\metamask-extension\\ui\\ducks\\smart-accounts\\smart-accounts.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../pages/confirmations/hooks/useBatchAuthorizationRequests":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useBatchAuthorizationRequests.ts","../../../pages/confirmations/hooks/useEIP7702Account":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useEIP7702Account.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/toggle-button":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\toggle-button\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Csmart-contract-account-toggle%5Csmart-contract-account-toggle.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SmartContractAccountToggle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _useEIP7702Account = require("../../../pages/confirmations/hooks/useEIP7702Account");
var _useBatchAuthorizationRequests = require("../../../pages/confirmations/hooks/useBatchAuthorizationRequests");
var _toggleButton = _interopRequireDefault(require("../../ui/toggle-button"));
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _routes = require("../../../helpers/constants/routes");
var _selectors = require("../../../selectors");
var _history = require("../../../ducks/history/history");
var _smartAccounts = require("../../../ducks/smart-accounts/smart-accounts");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SmartContractAccountToggle = ({
  networkConfig,
  address,
  returnToPage
}) => {
  const {
    name,
    isSupported,
    upgradeContractAddress,
    chainIdHex
  } = networkConfig;
  const history = (0, _reactRouterDom.useHistory)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const unconfirmedTransactions = (0, _reactRedux.useSelector)(_selectors.unconfirmedTransactionsListSelector);

  // Get toggleState from Redux
  const toggleState = (0, _reactRedux.useSelector)(state => (0, _smartAccounts.selectToggleState)(state, address, chainIdHex));
  const {
    downgradeAccount,
    upgradeAccount,
    isUpgraded
  } = (0, _useEIP7702Account.useEIP7702Account)({
    chainId: chainIdHex,
    onRedirect: () => null
  });
  const [addressSupportSmartAccount, setAddressSupportSmartAccount] = (0, _react.useState)(isSupported);
  const {
    hasPendingRequests
  } = (0, _useBatchAuthorizationRequests.useBatchAuthorizationRequests)(address, chainIdHex);
  const [hasUserInteracted, setHasUserInteracted] = (0, _react.useState)(false);

  // Use toggleState as primary source, fallback to actual account state
  const toggleValue = toggleState ?? addressSupportSmartAccount;

  // Keep toggle disabled when user has pending intent OR when there are pending requests
  const isToggleDisabled = hasPendingRequests || hasUserInteracted;

  // Check account state on mount and when transactions complete
  (0, _react.useEffect)(() => {
    if (!hasPendingRequests) {
      const checkUpgradeStatus = async () => {
        try {
          const upgraded = await isUpgraded(address);
          setAddressSupportSmartAccount(upgraded);
        } catch (error) {
          setAddressSupportSmartAccount(isSupported);
        }
      };
      checkUpgradeStatus();
    }
  }, [hasPendingRequests, isUpgraded, address, isSupported]);

  // Separate effect for mismatch detection when toggleState changes
  // Only runs when safe to check (no pending requests, user not actively clicking)
  (0, _react.useEffect)(() => {
    if (!hasPendingRequests && toggleState !== null && !hasUserInteracted) {
      const checkMismatch = async () => {
        try {
          const upgraded = await isUpgraded(address);

          // If user intent doesn't match blockchain reality, clear the intent
          if (toggleState !== upgraded) {
            dispatch((0, _smartAccounts.setToggleState)({
              address,
              chainId: chainIdHex,
              value: null
            }));
          }
        } catch (error) {
          // If we can't check, assume no mismatch to avoid clearing valid user intent
        }
      };
      checkMismatch();
    }
  }, [toggleState, hasPendingRequests, hasUserInteracted, isUpgraded, address, dispatch, chainIdHex]);
  const findAndRedirectToTransaction = (0, _react.useCallback)(() => {
    const matchingTransactions = unconfirmedTransactions.filter(tx => {
      var _tx$txParams;
      return ((_tx$txParams = tx.txParams) === null || _tx$txParams === void 0 ? void 0 : _tx$txParams.from) === address && tx.chainId === chainIdHex;
    });
    if (matchingTransactions.length > 0) {
      const latestTransaction = matchingTransactions.sort((a, b) => b.time - a.time)[0];
      if (returnToPage) {
        const redirectPath = returnToPage === '/account-details' ? `${returnToPage}/${address}` : returnToPage;
        dispatch((0, _history.setRedirectAfterDefaultPage)({
          path: redirectPath,
          address
        }));
      }
      history.push(`${_routes.CONFIRM_TRANSACTION_ROUTE}/${latestTransaction.id}`);
      return true;
    }
    return false;
  }, [unconfirmedTransactions, address, chainIdHex, history, returnToPage, dispatch]);

  // Monitor for transactions when toggleState is set
  (0, _react.useEffect)(() => {
    if (hasPendingRequests) {
      const found = findAndRedirectToTransaction();

      // If no transaction is found, reset after timeout
      if (!found) {
        const timeoutId = setTimeout(() => {
          dispatch((0, _smartAccounts.setToggleState)({
            address,
            chainId: chainIdHex,
            value: null
          }));
        }, 5000); // 5 second timeout

        return () => clearTimeout(timeoutId);
      }
    }
    return undefined;
  }, [hasPendingRequests, findAndRedirectToTransaction, dispatch, address, chainIdHex]);
  const onSwitch = (0, _react.useCallback)(async () => {
    // Immediately update the pending toggle state to show user's action
    dispatch((0, _smartAccounts.setToggleState)({
      address,
      chainId: chainIdHex,
      value: !toggleValue
    }));
    setHasUserInteracted(true);
    try {
      // Dispatch the transaction
      if (toggleValue) {
        await downgradeAccount(address);
      } else if (upgradeContractAddress) {
        await upgradeAccount(address, upgradeContractAddress);
      }
    } catch (error) {
      // Reset toggleState on error
      dispatch((0, _smartAccounts.setToggleState)({
        address,
        chainId: chainIdHex,
        value: null
      }));
    }
  }, [address, chainIdHex, downgradeAccount, toggleValue, upgradeAccount, upgradeContractAddress, dispatch]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    marginTop: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: _designSystem.TextColor.textAlternative
  }, name), /*#__PURE__*/_react.default.createElement(_toggleButton.default, {
    value: toggleValue,
    onToggle: onSwitch,
    disabled: isToggleDisabled
  }));
};
exports.SmartContractAccountToggle = SmartContractAccountToggle;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\smart-contract-account-toggle\\smart-contract-account-toggle.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain-accounts\\state2-wrapper\\state2-wrapper.tsx", {"../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain-accounts%5Cstate2-wrapper%5Cstate2-wrapper.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.State2Wrapper = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _selectors = require("../../../selectors");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const State2Wrapper = exports.State2Wrapper = /*#__PURE__*/_react.default.memo(props => {
  const isState2Enabled = (0, _reactRedux.useSelector)(_selectors.getIsMultichainAccountsState2Enabled);
  const {
    state1Component: State1Component,
    state2Component: State2Component,
    ...restOfProps
  } = props;
  return isState2Enabled ? /*#__PURE__*/_react.default.createElement(State2Component, restOfProps) : /*#__PURE__*/_react.default.createElement(State1Component, restOfProps);
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain-accounts\\state2-wrapper\\state2-wrapper.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-details\\account-details-authenticate.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../component-library/form-text-field/deprecated":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\form-text-field\\deprecated\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Caccount-details%5Caccount-details-authenticate.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountDetailsAuthenticate = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _actions = require("../../../store/actions");
var _componentLibrary = require("../../component-library");
var _deprecated = require("../../component-library/form-text-field/deprecated");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const AccountDetailsAuthenticate = ({
  address,
  onCancel,
  setPrivateKey,
  setShowHoldToReveal
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const [password, setPassword] = (0, _react.useState)('');

  // Password error would result from appState
  const warning = (0, _reactRedux.useSelector)(state => state.appState.warning);
  const onSubmit = (0, _react.useCallback)(() => {
    dispatch((0, _actions.exportAccount)(password, address, setPrivateKey, setShowHoldToReveal)).then(res => {
      dispatch((0, _actions.hideWarning)());
      return res;
    }).catch(() => {
      // No need to do anything more with the caught error here, we already logged the error
    });
  }, [dispatch, password, address, setPrivateKey, setShowHoldToReveal]);
  const handleKeyPress = (0, _react.useCallback)(e => {
    if (e.key === 'Enter') {
      onSubmit();
    }
  }, [onSubmit]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_deprecated.FormTextField, {
    marginTop: 6,
    id: "account-details-authenticate",
    label: t('enterYourPassword'),
    placeholder: t('password'),
    error: Boolean(warning),
    helpText: warning,
    onChange: e => setPassword(e.target.value),
    value: password,
    variant: _designSystem.TextVariant.bodySm,
    type: "password",
    inputProps: {
      onKeyPress: handleKeyPress
    },
    labelProps: {
      fontWeight: _designSystem.FontWeight.Medium
    },
    autoFocus: true
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerAlert, {
    marginTop: 6,
    severity: _designSystem.Severity.Danger,
    description: t('privateKeyWarning')
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    marginTop: 6,
    gap: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonSecondary, {
    onClick: onCancel,
    block: true
  }, t('cancel')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonPrimary, {
    onClick: onSubmit,
    disabled: password === '',
    block: true
  }, t('confirm'))));
};
exports.AccountDetailsAuthenticate = AccountDetailsAuthenticate;
AccountDetailsAuthenticate.propTypes = {
  /**
   * The account address
   */
  address: _propTypes.default.string.isRequired,
  /**
   * Executes upon Cancel button click
   */
  onCancel: _propTypes.default.func.isRequired,
  /**
   * Private key setter
   */
  setPrivateKey: _propTypes.default.func.isRequired,
  /**
   * showHoldToReveal setter
   */
  setShowHoldToReveal: _propTypes.default.func.isRequired
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\account-details\\account-details-authenticate.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-details\\account-details-display.js", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/modules/hexstring-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\hexstring-utils.ts","../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../hooks/useCopyToClipboard":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useCopyToClipboard.js","../../../pages/confirmations/components/confirm/smart-account-tab/smart-account-tab":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\confirm\\smart-account-tab\\smart-account-tab.tsx","../../../pages/confirmations/hooks/useEIP7702Networks":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useEIP7702Networks.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/editable-label/editable-label":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\editable-label\\editable-label.js","../../ui/icon/preloader":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\icon\\preloader\\index.js","../../ui/tabs":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tabs\\index.ts","./account-details-section":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-details\\account-details-section.tsx","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Caccount-details%5Caccount-details-display.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountDetailsDisplay = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRedux = require("react-redux");
var _keyringApi = require("@metamask/keyring-api");
var _editableLabel = _interopRequireDefault(require("../../ui/editable-label/editable-label"));
var _actions = require("../../../store/actions");
var _selectors = require("../../../selectors");
var _util = require("../../../helpers/utils/util");
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _metametrics = require("../../../contexts/metametrics");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _networks = require("../../../../shared/modules/selectors/networks");
var _hexstringUtils = require("../../../../shared/modules/hexstring-utils");
var _smartAccountTab = require("../../../pages/confirmations/components/confirm/smart-account-tab/smart-account-tab");
var _useCopyToClipboard = require("../../../hooks/useCopyToClipboard");
var _useEIP7702Networks = require("../../../pages/confirmations/hooks/useEIP7702Networks");
var _preloader = _interopRequireDefault(require("../../ui/icon/preloader"));
var _tabs = require("../../ui/tabs");
var _accountDetailsSection = require("./account-details-section");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AccountDetailsDisplay = ({
  accounts,
  accountName,
  address,
  accountType,
  onExportClick
}) => {
  var _toChecksumHexAddress;
  const dispatch = (0, _reactRedux.useDispatch)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const formatedAddress = (0, _keyringApi.isEvmAccountType)(accountType) ? (_toChecksumHexAddress = (0, _hexstringUtils.toChecksumHexAddress)(address)) === null || _toChecksumHexAddress === void 0 ? void 0 : _toChecksumHexAddress.toLowerCase() : address;
  const [copied, handleCopy] = (0, _useCopyToClipboard.useCopyToClipboard)();
  const handleClick = (0, _react.useCallback)(() => {
    handleCopy(formatedAddress);
  }, [formatedAddress, handleCopy]);
  const chainId = (0, _reactRedux.useSelector)(_networks.getCurrentChainId);
  const deviceName = (0, _reactRedux.useSelector)(_selectors.getHardwareWalletType);
  const {
    networkSupporting7702Present,
    pending
  } = (0, _useEIP7702Networks.useEIP7702Networks)(address);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    flexDirection: _designSystem.FlexDirection.Column
  }, /*#__PURE__*/_react.default.createElement(_editableLabel.default, {
    defaultValue: accountName,
    onSubmit: label => {
      dispatch((0, _actions.setAccountLabel)(address, label));
      trackEvent({
        category: _metametrics2.MetaMetricsEventCategory.Accounts,
        event: _metametrics2.MetaMetricsEventName.AccountRenamed,
        properties: {
          location: 'Account Details Modal',
          chain_id: chainId,
          account_hardware_type: deviceName
        }
      });
    },
    accounts: accounts
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    style: {
      position: 'relative'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    "data-testid": "account-address-shortened",
    marginBottom: 4
  }, (0, _util.shortenString)(formatedAddress, {
    truncatedStartChars: 12,
    truncatedEndChars: 10
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    color: _designSystem.IconColor.iconAlternative,
    iconName: copied ? _componentLibrary.IconName.CopySuccess : _componentLibrary.IconName.Copy,
    size: _componentLibrary.ButtonIconSize.Md,
    style: {
      cursor: 'pointer',
      position: 'absolute',
      right: -32,
      top: -2
    },
    onClick: handleClick,
    ariaLabel: "copy-button",
    "data-testid": "address-copy-button-text"
  })), pending && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingTop: 12,
    paddingBottom: 12,
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.center,
    "data-testid": "network-loader"
  }, /*#__PURE__*/_react.default.createElement(_preloader.default, {
    size: 18
  })), !pending && networkSupporting7702Present && /*#__PURE__*/_react.default.createElement(_tabs.Tabs, {
    onTabClick: () => undefined,
    style: {
      width: '100%',
      marginTop: '8px'
    }
  }, /*#__PURE__*/_react.default.createElement(_tabs.Tab, {
    name: "Type",
    tabKey: "Type",
    style: {
      width: '50%'
    }
  }, /*#__PURE__*/_react.default.createElement(_smartAccountTab.SmartAccountTab, {
    address: address
  })), /*#__PURE__*/_react.default.createElement(_tabs.Tab, {
    name: "Details",
    tabKey: "Details",
    style: {
      width: '50%'
    }
  }, /*#__PURE__*/_react.default.createElement(_accountDetailsSection.AccountDetailsSection, {
    address: address,
    onExportClick: onExportClick
  }))), !pending && !networkSupporting7702Present && /*#__PURE__*/_react.default.createElement(_accountDetailsSection.AccountDetailsSection, {
    address: address,
    onExportClick: onExportClick
  }));
};
exports.AccountDetailsDisplay = AccountDetailsDisplay;
AccountDetailsDisplay.propTypes = {
  /**
   * Array of user accounts
   */
  accounts: _propTypes.default.array.isRequired,
  /**
   * Name of the current account
   */
  accountName: _propTypes.default.string.isRequired,
  /**
   * Current address
   */
  address: _propTypes.default.string.isRequired,
  /**
   * Current account type
   */
  accountType: _propTypes.default.string.isRequired,
  /**
   * Executes upon Export button click
   */
  onExportClick: _propTypes.default.func.isRequired
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\account-details\\account-details-display.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-details\\account-details-key.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useCopyToClipboard":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useCopyToClipboard.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","@lavamoat/lavadome-react":"D:\\code\\v\\metamask-extension\\node_modules\\@lavamoat\\lavadome-react\\build\\main.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Caccount-details%5Caccount-details-key.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountDetailsKey = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lavadomeReact = require("@lavamoat/lavadome-react");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _useCopyToClipboard = require("../../../hooks/useCopyToClipboard");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const inTest = Boolean(false);
const AccountDetailsKey = ({
  accountName,
  onClose,
  privateKey
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const [showSelectDisableWarn, setShowDisableSelectWarn] = (0, _react.useState)(false);
  const [privateKeyCopied, handlePrivateKeyCopy] = (0, _useCopyToClipboard.useCopyToClipboard)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    marginTop: 6,
    variant: _designSystem.TextVariant.bodySm,
    style: {
      wordBreak: 'break-word'
    }
  }, t('privateKeyCopyWarning', [accountName])), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    alignItems: _designSystem.AlignItems.center,
    borderRadius: _designSystem.BorderRadius.SM,
    borderWidth: 1,
    borderColor: _designSystem.BorderColor.default,
    padding: 4,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    "data-testid": "account-details-key",
    variant: _designSystem.TextVariant.bodySm,
    style: {
      wordBreak: 'break-word'
    },
    onClick: () => setShowDisableSelectWarn(true)
  }, /*#__PURE__*/_react.default.createElement(_lavadomeReact.LavaDome, {
    unsafeOpenModeShadow: inTest,
    text: (0, _lavadomeReact.toLavaDomeToken)(privateKey)
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    onClick: () => setShowDisableSelectWarn(false) || handlePrivateKeyCopy(privateKey),
    iconName: privateKeyCopied ? _componentLibrary.IconName.CopySuccess : _componentLibrary.IconName.Copy,
    ariaLabel: t('copyPrivateKey')
  })), showSelectDisableWarn && /*#__PURE__*/_react.default.createElement(_componentLibrary.HelpText, {
    marginTop: 2,
    severity: _componentLibrary.HelpTextSeverity.Danger
  }, t('lavaDomeCopyWarning')), /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerAlert, {
    severity: _designSystem.Severity.Danger,
    marginTop: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm
  }, t('privateKeyWarning'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonPrimary, {
    marginTop: 6,
    onClick: onClose,
    block: true
  }, t('done')));
};
exports.AccountDetailsKey = AccountDetailsKey;
AccountDetailsKey.propTypes = {
  /**
   * Name of the account
   */
  accountName: _propTypes.default.string.isRequired,
  /**
   * Executes upon Close button click
   */
  onClose: _propTypes.default.func.isRequired,
  /**
   * The private key
   */
  privateKey: _propTypes.default.string.isRequired
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\account-details\\account-details-key.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-details\\account-details-section.tsx", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/qr-code-view":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\qr-code-view\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Caccount-details%5Caccount-details-section.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountDetailsSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _qrCodeView = _interopRequireDefault(require("../../ui/qr-code-view"));
var _selectors = require("../../../selectors");
var _util = require("../../../helpers/utils/util");
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _metametrics = require("../../../contexts/metametrics");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _selectors2 = require("../../../selectors/selectors");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AccountDetailsSection = ({
  address,
  onExportClick
}) => {
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const t = (0, _useI18nContext.useI18nContext)();
  const hdEntropyIndex = (0, _reactRedux.useSelector)(_selectors2.getHDEntropyIndex);
  const account = (0, _reactRedux.useSelector)(state => (0, _selectors.getInternalAccountByAddress)(state, address));
  const {
    metadata: {
      keyring
    }
  } = account;
  const exportPrivateKeyFeatureEnabled = (0, _util.isAbleToExportAccount)(keyring === null || keyring === void 0 ? void 0 : keyring.type);
  const keyrings = (0, _reactRedux.useSelector)(_selectors.getMetaMaskKeyrings);
  const exportSrpFeatureEnabled = (0, _util.isAbleToRevealSrp)(account, keyrings);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_qrCodeView.default, {
    Qr: {
      data: address
    }
  }), exportPrivateKeyFeatureEnabled ? /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonSecondary, {
    "data-testid": "account-details-display-export-private-key",
    block: true,
    size: _componentLibrary.ButtonSecondarySize.Lg,
    variant: _designSystem.TextVariant.bodyMd,
    marginBottom: 1,
    onClick: () => {
      trackEvent({
        category: _metametrics2.MetaMetricsEventCategory.Accounts,
        event: _metametrics2.MetaMetricsEventName.KeyExportSelected,
        properties: {
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          key_type: _metametrics2.MetaMetricsEventKeyType.Pkey,
          location: 'Account Details Modal',
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          hd_entropy_index: hdEntropyIndex
        }
      });
      onExportClick('PrivateKey');
    }
  }, t('showPrivateKey')) : null, exportSrpFeatureEnabled ? /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonSecondary, {
    "data-testid": "account-details-display-export-srp",
    block: true,
    size: _componentLibrary.ButtonSecondarySize.Lg,
    variant: _designSystem.TextVariant.bodyMd,
    onClick: () => {
      onExportClick('SRP');
    }
  }, t('showSRP')) : null);
};
exports.AccountDetailsSection = AccountDetailsSection;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\account-details\\account-details-section.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-details\\account-details.tsx", {"../../../../shared/constants/accounts":"D:\\code\\v\\metamask-extension\\shared\\constants\\accounts.ts","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/lib/accounts":"D:\\code\\v\\metamask-extension\\shared\\lib\\accounts\\index.ts","../../../../shared/lib/keyring":"D:\\code\\v\\metamask-extension\\shared\\lib\\keyring.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../app/modals/hold-to-reveal-modal/hold-to-reveal-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\hold-to-reveal-modal\\hold-to-reveal-modal.tsx","../../app/preferred-avatar":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\preferred-avatar\\index.ts","../../app/srp-quiz-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\srp-quiz-modal\\index.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../address-copy-button":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\address-copy-button\\index.js","./account-details-authenticate":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-details\\account-details-authenticate.js","./account-details-display":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-details\\account-details-display.js","./account-details-key":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-details\\account-details-key.js","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","@metamask/keyring-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-controller\\dist\\index.cjs","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Caccount-details%5Caccount-details.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountDetails = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _keyringController = require("@metamask/keyring-controller");
var _designSystemReact = require("@metamask/design-system-react");
var _metametrics = require("../../../../shared/constants/metametrics");
var _metametrics2 = require("../../../contexts/metametrics");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _selectors = require("../../../selectors");
var _actions = require("../../../store/actions");
var _holdToRevealModal = _interopRequireDefault(require("../../app/modals/hold-to-reveal-modal/hold-to-reveal-modal"));
var _componentLibrary = require("../../component-library");
var _addressCopyButton = require("../address-copy-button");
var _preferredAvatar = require("../../app/preferred-avatar");
var _srpQuizModal = _interopRequireDefault(require("../../app/srp-quiz-modal"));
var _keyring = require("../../../../shared/lib/keyring");
var _util = require("../../../helpers/utils/util");
var _accounts = require("../../../../shared/lib/accounts");
var _accounts2 = require("../../../../shared/constants/accounts");
var _accountDetailsAuthenticate = require("./account-details-authenticate");
var _accountDetailsDisplay = require("./account-details-display");
var _accountDetailsKey = require("./account-details-key");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const AccountDetails = ({
  address
}) => {
  var _account$metadata$sna;
  const dispatch = (0, _reactRedux.useDispatch)();
  const t = (0, _useI18nContext.useI18nContext)();
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const hdEntropyIndex = (0, _reactRedux.useSelector)(_selectors.getHDEntropyIndex);
  const accounts = (0, _reactRedux.useSelector)(_selectors.getMetaMaskAccountsOrdered);
  const account = (0, _reactRedux.useSelector)(state => (0, _selectors.getInternalAccountByAddress)(state, address));
  const {
    metadata: {
      name,
      keyring: {
        type: keyringType
      }
    },
    options: {
      entropySource
    },
    type
  } = account;
  const snapId = (_account$metadata$sna = account.metadata.snap) === null || _account$metadata$sna === void 0 ? void 0 : _account$metadata$sna.id;
  const [showHoldToReveal, setShowHoldToReveal] = (0, _react.useState)(false);
  let showModal = !showHoldToReveal;
  const [srpQuizModalVisible, setSrpQuizModalVisible] = (0, _react.useState)(false);
  showModal = !showHoldToReveal && !srpQuizModalVisible;
  const keyrings = (0, _reactRedux.useSelector)(_selectors.getMetaMaskKeyrings);

  // Snap accounts have an entropy source that is the id of the hd keyring
  const keyringId = keyringType === _keyringController.KeyringTypes.snap && (0, _accounts.isMultichainWalletSnap)(snapId) && entropySource ? entropySource : (0, _keyring.findKeyringId)(keyrings, {
    address
  });
  const isAbleToExportSrp = (0, _util.isAbleToRevealSrp)(account, keyrings);
  const displayExportSrpQuiz = keyringId && isAbleToExportSrp;
  const [attemptingExport, setAttemptingExport] = (0, _react.useState)(_accounts2.AttemptExportState.None);

  // This is only populated when the user properly authenticates
  const [privateKey, setPrivateKey] = (0, _react.useState)('');
  const onClose = (0, _react.useCallback)(() => {
    dispatch((0, _actions.setAccountDetailsAddress)(''));
    dispatch((0, _actions.clearAccountDetails)());
    dispatch((0, _actions.hideWarning)());
  }, [dispatch]);
  const avatar = /*#__PURE__*/_react.default.createElement(_preferredAvatar.PreferredAvatar, {
    address: address,
    size: _designSystemReact.AvatarAccountSize.Lg,
    style: {
      margin: '0 auto'
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: showModal,
    onClose: onClose,
    "data-testid": "account-details-modal"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onClose: onClose,
    onBack: () => {
      if (attemptingExport === _accounts2.AttemptExportState.PrivateKey) {
        dispatch((0, _actions.hideWarning)());
        setPrivateKey('');
        setAttemptingExport(_accounts2.AttemptExportState.None);
      } else if (attemptingExport === _accounts2.AttemptExportState.None) {
        onClose();
      }
    }
  }, attemptingExport === _accounts2.AttemptExportState.PrivateKey ? t('showPrivateKey') : avatar), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, null, attemptingExport === _accounts2.AttemptExportState.None && /*#__PURE__*/_react.default.createElement(_accountDetailsDisplay.AccountDetailsDisplay, {
    accounts: accounts,
    accountName: name,
    accountType: type,
    address: address,
    onExportClick: attemptExportMode => {
      if (attemptExportMode === _accounts2.AttemptExportState.SRP) {
        setSrpQuizModalVisible(true);
      }
      setAttemptingExport(attemptExportMode);
    }
  }), attemptingExport === _accounts2.AttemptExportState.PrivateKey && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    flexDirection: _designSystem.FlexDirection.Column
  }, avatar, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    marginTop: 2,
    marginBottom: 2,
    variant: _designSystem.TextVariant.bodyLgMedium,
    style: {
      wordBreak: 'break-word'
    }
  }, name), /*#__PURE__*/_react.default.createElement(_addressCopyButton.AddressCopyButton, {
    address: address,
    shorten: true
  })), privateKey ? /*#__PURE__*/_react.default.createElement(_accountDetailsKey.AccountDetailsKey, {
    accountName: name,
    onClose: onClose,
    privateKey: privateKey
  }) : /*#__PURE__*/_react.default.createElement(_accountDetailsAuthenticate.AccountDetailsAuthenticate, {
    address: address,
    onCancel: onClose,
    setPrivateKey: setPrivateKey,
    setShowHoldToReveal: setShowHoldToReveal
  }))))), /*#__PURE__*/_react.default.createElement(_holdToRevealModal.default, {
    isOpen: showHoldToReveal,
    onClose: () => {
      trackEvent({
        category: _metametrics.MetaMetricsEventCategory.Keys,
        event: _metametrics.MetaMetricsEventName.KeyExportCanceled,
        properties: {
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          key_type: _metametrics.MetaMetricsEventKeyType.Pkey,
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          hd_entropy_index: hdEntropyIndex
        }
      });
      setPrivateKey('');
      setShowHoldToReveal(false);
    },
    onLongPressed: () => {
      setShowHoldToReveal(false);
    },
    holdToRevealType: "PrivateKey"
  }), displayExportSrpQuiz && /*#__PURE__*/_react.default.createElement(_srpQuizModal.default, {
    keyringId: keyringId,
    isOpen: srpQuizModalVisible,
    onClose: () => {
      setSrpQuizModalVisible(false);
      onClose();
    },
    closeAfterCompleting: true
  }));
};
exports.AccountDetails = AccountDetails;
AccountDetails.propTypes = {
  /**
   * The address to show account details for
   */
  address: _propTypes.default.string
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\account-details\\account-details.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-details\\index.js", {"./account-details":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-details\\account-details.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Caccount-details%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "AccountDetails", {
  enumerable: true,
  get: function () {
    return _accountDetails.AccountDetails;
  }
});
var _accountDetails = require("./account-details");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\account-details\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-list-item-menu\\account-list-item-menu.js", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/metrics":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\metrics.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/menu":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\menu\\index.ts","../menu-items":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\menu-items\\index.js","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Caccount-list-item-menu%5Caccount-list-item-menu.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountListItemMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _bridgeController = require("@metamask/bridge-controller");
var _metametrics = require("../../../contexts/metametrics");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _networks = require("../../../../shared/modules/selectors/networks");
var _selectors = require("../../../selectors");
var _menu = require("../../ui/menu");
var _componentLibrary = require("../../component-library");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _actions = require("../../../store/actions");
var _designSystem = require("../../../helpers/constants/design-system");
var _metrics = require("../../../helpers/utils/metrics");
var _menuItems = require("../menu-items");
var _selectors2 = require("../../../selectors/selectors");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const METRICS_LOCATION = 'Account Options';
const AccountListItemMenu = ({
  anchorElement,
  onClose,
  closeMenu,
  isRemovable,
  account,
  isOpen,
  isPinned,
  isHidden
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const hdEntropyIndex = (0, _reactRedux.useSelector)(_selectors2.getHDEntropyIndex);
  const dispatch = (0, _reactRedux.useDispatch)();
  const chainId = (0, _reactRedux.useSelector)(_networks.getCurrentChainId);
  const deviceName = (0, _reactRedux.useSelector)(_selectors.getHardwareWalletType);
  const isMultichainAccountsState1Enabled = (0, _reactRedux.useSelector)(_selectors.getIsMultichainAccountsState1Enabled);
  const {
    keyring
  } = account.metadata;
  const accountType = (0, _metrics.formatAccountType)((0, _selectors.getAccountTypeForKeyring)(keyring));
  const pinnedAccountList = (0, _reactRedux.useSelector)(_selectors.getPinnedAccountsList);
  const hiddenAccountList = (0, _reactRedux.useSelector)(_selectors.getHiddenAccountsList);

  // Handle Tab key press for accessibility inside the popover and will close the popover on the last MenuItem
  const lastItemRef = (0, _react.useRef)(null);
  const accountDetailsItemRef = (0, _react.useRef)(null);
  const removeAccountItemRef = (0, _react.useRef)(null);
  const removeJWTItemRef = (0, _react.useRef)(null);

  // Checks the MenuItems from the bottom to top to set lastItemRef on the last MenuItem that is not disabled
  (0, _react.useEffect)(() => {
    if (removeJWTItemRef.current) {
      lastItemRef.current = removeJWTItemRef.current;
    } else if (removeAccountItemRef.current) {
      lastItemRef.current = removeAccountItemRef.current;
    } else {
      lastItemRef.current = accountDetailsItemRef.current;
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [removeJWTItemRef.current, removeAccountItemRef.current, accountDetailsItemRef.current]);
  const handleKeyDown = (0, _react.useCallback)(event => {
    if (event.key === 'Tab' && event.target === lastItemRef.current) {
      // If Tab is pressed at the last item to close popover and focus to next element in DOM
      onClose();
    }
  }, [onClose]);

  // Handle click outside of the popover to close it
  const popoverDialogRef = (0, _react.useRef)(null);
  const handleClickOutside = (0, _react.useCallback)(event => {
    if (popoverDialogRef !== null && popoverDialogRef !== void 0 && popoverDialogRef.current && !popoverDialogRef.current.contains(event.target)) {
      onClose();
    }
  }, [onClose]);
  (0, _react.useEffect)(() => {
    document.addEventListener('mousedown', handleClickOutside);
    return () => {
      document.removeEventListener('mousedown', handleClickOutside);
    };
  }, [handleClickOutside]);
  const handlePinning = address => {
    const updatedPinnedAccountList = [...pinnedAccountList, address];
    dispatch((0, _actions.updateAccountsList)(updatedPinnedAccountList));
  };
  const handleUnpinning = address => {
    const updatedPinnedAccountList = pinnedAccountList.filter(item => item !== address);
    dispatch((0, _actions.updateAccountsList)(updatedPinnedAccountList));
  };
  const handleHidding = address => {
    // If the account is already hidden, we do not add it again
    // TODO: The controller should handle this logic
    if (hiddenAccountList.includes(address)) {
      return;
    }
    const updatedHiddenAccountList = [...hiddenAccountList, address];
    if (pinnedAccountList.includes(address)) {
      handleUnpinning(address);
    }
    dispatch((0, _actions.updateHiddenAccountsList)(updatedHiddenAccountList));
  };
  const handleUnhidding = address => {
    const updatedHiddenAccountList = hiddenAccountList.filter(item => item !== address);
    dispatch((0, _actions.updateHiddenAccountsList)(updatedHiddenAccountList));
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Popover, {
    className: "multichain-account-list-item-menu__popover",
    referenceElement: anchorElement,
    role: _componentLibrary.PopoverRole.Dialog,
    position: _componentLibrary.PopoverPosition.Bottom,
    offset: [0, 0],
    padding: 0,
    isOpen: isOpen,
    isPortal: true,
    preventOverflow: true,
    flip: true
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalFocus, {
    restoreFocus: true,
    initialFocusRef: anchorElement
  }, /*#__PURE__*/_react.default.createElement("div", {
    onKeyDown: handleKeyDown,
    ref: popoverDialogRef
  }, /*#__PURE__*/_react.default.createElement(_menuItems.AccountDetailsMenuItem, {
    metricsLocation: METRICS_LOCATION,
    closeMenu: closeMenu,
    address: account.address,
    textProps: {
      variant: _designSystem.TextVariant.bodySm
    }
  }), /*#__PURE__*/_react.default.createElement(_menuItems.ViewExplorerMenuItem, {
    metricsLocation: METRICS_LOCATION,
    closeMenu: closeMenu,
    textProps: {
      variant: _designSystem.TextVariant.bodySm
    },
    account: account
  }), isHidden ? null : /*#__PURE__*/_react.default.createElement(_menu.MenuItem, {
    "data-testid": "account-list-menu-pin",
    onClick: () => {
      isPinned ? handleUnpinning(account.address) : handlePinning(account.address);
      onClose();
    },
    iconName: isPinned ? _componentLibrary.IconName.Unpin : _componentLibrary.IconName.Pin
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm
  }, isPinned ? t('unpin') : t('pinToTop'))), /*#__PURE__*/_react.default.createElement(_menu.MenuItem, {
    "data-testid": "account-list-menu-hide",
    onClick: () => {
      isHidden ? handleUnhidding(account.address) : handleHidding(account.address);
      onClose();
    },
    iconName: isHidden ? _componentLibrary.IconName.Eye : _componentLibrary.IconName.EyeSlash
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm
  }, isHidden ? t('showAccount') : t('hideAccount'))), isRemovable && !isMultichainAccountsState1Enabled ? /*#__PURE__*/_react.default.createElement(_menu.MenuItem, {
    ref: removeAccountItemRef,
    "data-testid": "account-list-menu-remove",
    onClick: () => {
      dispatch((0, _actions.showModal)({
        name: 'CONFIRM_REMOVE_ACCOUNT',
        account
      }));
      trackEvent({
        event: _metametrics2.MetaMetricsEventName.AccountRemoved,
        category: _metametrics2.MetaMetricsEventCategory.Accounts,
        properties: {
          account_hardware_type: deviceName,
          chain_id: chainId,
          account_type: accountType,
          hd_entropy_index: hdEntropyIndex,
          caip_chain_id: (0, _bridgeController.formatChainIdToCaip)(chainId)
        }
      });
      onClose();
      closeMenu === null || closeMenu === void 0 || closeMenu();
    },
    iconName: _componentLibrary.IconName.Trash
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm
  }, t('removeAccount'))) : null)));
};
exports.AccountListItemMenu = AccountListItemMenu;
AccountListItemMenu.propTypes = {
  /**
   * Element that the menu should display next to
   */
  anchorElement: _propTypes.default.instanceOf(window.Element),
  /**
   * Function that executes when the menu is closed
   */
  onClose: _propTypes.default.func.isRequired,
  /**
   * Represents if the menu is open or not
   *
   * @type {boolean}
   */
  isOpen: _propTypes.default.bool.isRequired,
  /**
   * Function that closes the menu
   */
  closeMenu: _propTypes.default.func,
  /**
   * Represents if the account should be removable
   */
  isRemovable: _propTypes.default.bool.isRequired,
  /**
   * Represents pinned accounts
   */
  isPinned: _propTypes.default.bool,
  /**
   * Represents hidden accounts
   */
  isHidden: _propTypes.default.bool,
  /**
   * An account object that has name, address, and balance data
   */
  account: _propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    address: _propTypes.default.string.isRequired,
    balance: _propTypes.default.string.isRequired,
    metadata: _propTypes.default.shape({
      name: _propTypes.default.string.isRequired,
      snap: _propTypes.default.shape({
        id: _propTypes.default.string.isRequired,
        name: _propTypes.default.string,
        enabled: _propTypes.default.bool
      }),
      keyring: _propTypes.default.shape({
        type: _propTypes.default.string.isRequired
      }).isRequired
    }).isRequired
  }).isRequired
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\account-list-item-menu\\account-list-item-menu.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-list-item-menu\\index.js", {"./account-list-item-menu":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-list-item-menu\\account-list-item-menu.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Caccount-list-item-menu%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "AccountListItemMenu", {
  enumerable: true,
  get: function () {
    return _accountListItemMenu.AccountListItemMenu;
  }
});
var _accountListItemMenu = require("./account-list-item-menu");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\account-list-item-menu\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-list-item\\account-list-item.js", {"../../../../app/scripts/lib/multichain/address":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\multichain\\address.ts","../../../../shared/constants/keyring":"D:\\code\\v\\metamask-extension\\shared\\constants\\keyring.ts","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/multichain/assets":"D:\\code\\v\\metamask-extension\\shared\\constants\\multichain\\assets.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/common":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\common.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/accounts":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\accounts.js","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../hooks/useAccountTotalCrossChainFiatBalance":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAccountTotalCrossChainFiatBalance.ts","../../../hooks/useGetFormattedTokensPerChain":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useGetFormattedTokensPerChain.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../hooks/useMultichainSelector":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainSelector.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/assets":"D:\\code\\v\\metamask-extension\\ui\\selectors\\assets.ts","../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","../../app/preferred-avatar":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\preferred-avatar\\index.ts","../../app/user-preferenced-currency-display/user-preferenced-currency-display.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\user-preferenced-currency-display\\user-preferenced-currency-display.component.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/tooltip/tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\tooltip.js","../account-list-item-menu":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-list-item-menu\\index.js","../account-network-indicator":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-network-indicator\\index.ts","../connected-accounts-menu":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\connected-accounts-menu\\index.ts","../connected-status":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\connected-status\\index.ts","./account-list-item.types":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-list-item\\account-list-item.types.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Caccount-list-item%5Caccount-list-item.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _reactRedux = require("react-redux");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _util = require("../../../helpers/utils/util");
var _accountListItemMenu = require("../account-list-item-menu");
var _connectedAccountsMenu = require("../connected-accounts-menu");
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _preferredAvatar = require("../../app/preferred-avatar");
var _keyring = require("../../../../shared/constants/keyring");
var _userPreferencedCurrencyDisplay = _interopRequireDefault(require("../../app/user-preferenced-currency-display/user-preferenced-currency-display.component"));
var _common = require("../../../helpers/constants/common");
var _tooltip = _interopRequireDefault(require("../../ui/tooltip/tooltip"));
var _metametrics = require("../../../../shared/constants/metametrics");
var _metametrics2 = require("../../../contexts/metametrics");
var _selectors = require("../../../selectors");
var _multichain = require("../../../selectors/multichain");
var _connectedStatus = require("../connected-status");
var _selectors2 = require("../../../selectors/selectors");
var _address = require("../../../../app/scripts/lib/multichain/address");
var _useMultichainSelector = require("../../../hooks/useMultichainSelector");
var _useGetFormattedTokensPerChain = require("../../../hooks/useGetFormattedTokensPerChain");
var _useAccountTotalCrossChainFiatBalance = require("../../../hooks/useAccountTotalCrossChainFiatBalance");
var _accounts = require("../../../helpers/utils/accounts");
var _assets = require("../../../selectors/assets");
var _accountNetworkIndicator = require("../account-network-indicator");
var _assets2 = require("../../../../shared/constants/multichain/assets");
var _accountListItem = require("./account-list-item.types");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

const MAXIMUM_CURRENCY_DECIMALS = 3;
const MAXIMUM_CHARACTERS_WITHOUT_TOOLTIP = 17;
const AccountListItem = ({
  account,
  selected,
  onClick,
  closeMenu,
  accountsCount,
  connectedAvatar,
  isPinned = false,
  menuType = _accountListItem.AccountListItemMenuTypes.None,
  isHidden = false,
  currentTabOrigin,
  isActive = false,
  startAccessory,
  onActionClick,
  shouldScrollToWhenSelected = true,
  showConnectedStatus = true,
  privacyMode = false,
  showAccountLabels = true,
  showSelectionIndicator = true
}) => {
  var _accountMultichainBal;
  const t = (0, _useI18nContext.useI18nContext)();
  const hdEntropyIndex = (0, _reactRedux.useSelector)(_selectors2.getHDEntropyIndex);
  const [accountOptionsMenuOpen, setAccountOptionsMenuOpen] = (0, _react.useState)(false);
  const [accountListItemMenuElement, setAccountListItemMenuElement] = (0, _react.useState)();
  const snapMetadata = (0, _reactRedux.useSelector)(_selectors.getSnapsMetadata);
  const keyrings = (0, _reactRedux.useSelector)(_selectors.getMetaMaskKeyrings);
  const accountLabels = (0, _react.useMemo)(() => {
    var _account$metadata;
    return (0, _accounts.getAccountLabels)(account.metadata.keyring.type, account, keyrings, account.metadata.keyring.type === _keyring.KeyringType.snap ? (0, _util.getSnapName)(snapMetadata)((_account$metadata = account.metadata) === null || _account$metadata === void 0 || (_account$metadata = _account$metadata.snap) === null || _account$metadata === void 0 ? void 0 : _account$metadata.id) : null);
  }, [account, keyrings, snapMetadata]);
  const {
    isEvmNetwork,
    chainId: multichainChainId
  } = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainNetwork, account);
  const setAccountListItemMenuRef = ref => {
    setAccountListItemMenuElement(ref);
  };
  const isTestnet = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainIsTestnet, account);
  const isMainnet = !isTestnet;
  const shouldShowFiat = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainShouldShowFiat, account);
  const showFiatInTestnets = (0, _reactRedux.useSelector)(_selectors.getShowFiatInTestnets);
  const showFiat = shouldShowFiat && (isMainnet || isTestnet && showFiatInTestnets);
  const multichainAggregatedBalance = (0, _reactRedux.useSelector)(state => (0, _assets.getMultichainAggregatedBalance)(state, account));
  const multichainBalances = (0, _reactRedux.useSelector)(_multichain.getMultichainBalances);
  const accountMultichainBalances = multichainBalances === null || multichainBalances === void 0 ? void 0 : multichainBalances[account.id];
  const accountMultichainNativeBalance = accountMultichainBalances === null || accountMultichainBalances === void 0 || (_accountMultichainBal = accountMultichainBalances[`${_assets2.MULTICHAIN_NETWORK_TO_ASSET_TYPES[multichainChainId]}`]) === null || _accountMultichainBal === void 0 ? void 0 : _accountMultichainBal.amount;
  // cross chain agg balance
  const shouldHideZeroBalanceTokens = (0, _reactRedux.useSelector)(_selectors.getShouldHideZeroBalanceTokens);
  const isTokenNetworkFilterEqualCurrentNetwork = (0, _reactRedux.useSelector)(_selectors.getIsTokenNetworkFilterEqualCurrentNetwork);
  const allChainIDs = (0, _reactRedux.useSelector)(_selectors.getChainIdsToPoll);
  const {
    formattedTokensWithBalancesPerChain
  } = (0, _useGetFormattedTokensPerChain.useGetFormattedTokensPerChain)(account, shouldHideZeroBalanceTokens, isTokenNetworkFilterEqualCurrentNetwork, allChainIDs);
  const {
    totalFiatBalance
  } = (0, _useAccountTotalCrossChainFiatBalance.useAccountTotalCrossChainFiatBalance)(account, formattedTokensWithBalancesPerChain);
  let balanceToTranslate;
  if (isEvmNetwork) {
    balanceToTranslate = !shouldShowFiat || isTestnet || !"true" ? account.balance : totalFiatBalance;
  } else {
    balanceToTranslate = !shouldShowFiat || isTestnet ? accountMultichainNativeBalance : multichainAggregatedBalance;
  }

  // If this is the selected item in the Account menu,
  // scroll the item into view
  const itemRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    if (selected && shouldScrollToWhenSelected) {
      var _itemRef$current, _itemRef$current$scro;
      (_itemRef$current = itemRef.current) === null || _itemRef$current === void 0 || (_itemRef$current$scro = _itemRef$current.scrollIntoView) === null || _itemRef$current$scro === void 0 || _itemRef$current$scro.call(_itemRef$current);
    }
  }, [itemRef, selected, shouldScrollToWhenSelected]);
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const currentTabIsConnectedToSelectedAddress = (0, _reactRedux.useSelector)(state => (0, _selectors.isAccountConnectedToCurrentTab)(state, account.address));
  const isConnected = currentTabOrigin && currentTabIsConnectedToSelectedAddress;
  const isSingleAccount = accountsCount === 1;

  // Only show connected status badge if account is actually connected
  const shouldShowConnectedStatusBadge = showConnectedStatus && isConnected;
  const getIsAggregatedFiatOverviewBalanceProp = () => {
    const isAggregatedFiatOverviewBalance = !isTestnet && "true" && shouldShowFiat || !isEvmNetwork && shouldShowFiat;
    return isAggregatedFiatOverviewBalance;
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    padding: 4,
    backgroundColor: selected ? _designSystem.Color.primaryMuted : _designSystem.Color.transparent,
    className: (0, _classnames.default)('multichain-account-list-item items-center', {
      'multichain-account-list-item--selected': selected,
      'multichain-account-list-item--connected': Boolean(connectedAvatar),
      'multichain-account-list-item--clickable': Boolean(onClick)
    }),
    "data-testid": "account-item",
    ref: itemRef,
    onClick: () => {
      // Without this check, the account will be selected after
      // the account options menu closes
      if (!accountOptionsMenuOpen) {
        onClick === null || onClick === void 0 || onClick(account);
      }
    }
  }, startAccessory ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginInlineEnd: 2,
    marginTop: 1
  }, startAccessory) : null, selected && showSelectionIndicator && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "multichain-account-list-item__selected-indicator",
    borderRadius: _designSystem.BorderRadius.pill,
    backgroundColor: _designSystem.Color.primaryDefault,
    "data-testid": "account-list-item-selected-indicator"
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "flex w-full gap-2 items-center"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: [_designSystem.Display.Flex, _designSystem.Display.None],
    "data-testid": "account-list-item-badge"
  }, /*#__PURE__*/_react.default.createElement(_connectedStatus.ConnectedStatus, {
    address: account.address,
    isActive: isActive,
    showConnectedStatus: shouldShowConnectedStatusBadge
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: [_designSystem.Display.None, _designSystem.Display.Flex]
  }, /*#__PURE__*/_react.default.createElement(_preferredAvatar.PreferredAvatar, {
    address: account.address
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    className: "multichain-account-list-item__content"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "multichain-account-list-item__account-name",
    marginInlineEnd: 2,
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    gap: 2
  }, isPinned ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.Pin,
    size: _componentLibrary.IconSize.Xs,
    className: "account-pinned-icon",
    "data-testid": "account-pinned-icon"
  }) : null, isHidden ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.EyeSlash,
    size: _componentLibrary.IconSize.Xs,
    className: "account-hidden-icon"
  }) : null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "button",
    onClick: e => {
      if (onClick) {
        e.stopPropagation();
        onClick(account);
      }
    },
    variant: _designSystem.TextVariant.bodyMdMedium,
    className: "multichain-account-list-item__account-name__button",
    padding: 0,
    backgroundColor: _designSystem.BackgroundColor.transparent,
    width: _designSystem.BlockSize.Full,
    textAlign: _designSystem.TextAlign.Left,
    ellipsis: true
  }, account.metadata.name.length > MAXIMUM_CHARACTERS_WITHOUT_TOOLTIP ? /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    title: account.metadata.name,
    position: "bottom",
    wrapperClassName: "multichain-account-list-item__tooltip"
  }, account.metadata.name) : account.metadata.name)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "div",
    className: "multichain-account-list-item__asset",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.flexEnd,
    ellipsis: true,
    textAlign: _designSystem.TextAlign.End
  }, /*#__PURE__*/_react.default.createElement(_userPreferencedCurrencyDisplay.default, {
    account: account,
    ethNumberOfDecimals: MAXIMUM_CURRENCY_DECIMALS,
    value: balanceToTranslate,
    type: _common.PRIMARY,
    showFiat: showFiat,
    isAggregatedFiatOverviewBalance: getIsAggregatedFiatOverviewBalanceProp(),
    "data-testid": "first-currency-display",
    privacyMode: privacyMode
  })))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.Color.textAlternative,
    "data-testid": "account-list-address"
  }, (0, _util.shortenAddress)((0, _address.normalizeSafeAddress)(account.address)))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "network-indicator"
  }, /*#__PURE__*/_react.default.createElement(_accountNetworkIndicator.AccountNetworkIndicator, {
    scopes: account.scopes
  }))), showAccountLabels && accountLabels.length > 0 ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    flexDirection: _designSystem.FlexDirection.Row
  }, accountLabels.map(({
    label,
    icon
  }) => {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Tag, {
      "data-testid": `account-list-item-tag-${account.id}-${label}`,
      key: label,
      label: label,
      labelProps: {
        variant: _designSystem.TextVariant.bodyXs,
        color: _designSystem.Color.textAlternative
      },
      startIconName: icon
    });
  })) : null)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.center
  }, menuType === _accountListItem.AccountListItemMenuTypes.None ? null : /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    ariaLabel: `${account.metadata.name} ${t('options')}`,
    iconName: _componentLibrary.IconName.MoreVertical,
    size: _componentLibrary.IconSize.Sm,
    ref: setAccountListItemMenuRef,
    onClick: e => {
      e.stopPropagation();
      if (!accountOptionsMenuOpen) {
        trackEvent({
          event: _metametrics.MetaMetricsEventName.AccountDetailMenuOpened,
          category: _metametrics.MetaMetricsEventCategory.Navigation,
          properties: {
            location: 'Account Options',
            hd_entropy_index: hdEntropyIndex
          }
        });
      }
      setAccountOptionsMenuOpen(!accountOptionsMenuOpen);
    },
    "data-testid": "account-list-item-menu-button"
  }), menuType === _accountListItem.AccountListItemMenuTypes.Account && /*#__PURE__*/_react.default.createElement(_accountListItemMenu.AccountListItemMenu, {
    anchorElement: accountListItemMenuElement,
    account: account,
    onClose: () => setAccountOptionsMenuOpen(false),
    isOpen: accountOptionsMenuOpen,
    isRemovable: account.metadata.keyring.type !== _keyring.KeyringType.hdKeyTree && !(0, _selectors.isSolanaAccount)(account),
    closeMenu: closeMenu,
    isPinned: isPinned,
    isHidden: isHidden,
    isConnected: isConnected
  }), menuType === _accountListItem.AccountListItemMenuTypes.Connection && /*#__PURE__*/_react.default.createElement(_connectedAccountsMenu.ConnectedAccountsMenu, {
    anchorElement: accountListItemMenuElement,
    account: account,
    onClose: () => setAccountOptionsMenuOpen(false),
    disableAccountSwitcher: isSingleAccount && selected,
    isOpen: accountOptionsMenuOpen,
    onActionClick: onActionClick,
    activeTabOrigin: currentTabOrigin
  })));
};
AccountListItem.propTypes = {
  /**
   * An account object that has name, address, and balance data
   */
  account: _propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    address: _propTypes.default.string.isRequired,
    balance: _propTypes.default.string.isRequired,
    metadata: _propTypes.default.shape({
      name: _propTypes.default.string.isRequired,
      snap: _propTypes.default.shape({
        id: _propTypes.default.string.isRequired,
        name: _propTypes.default.string,
        enabled: _propTypes.default.bool
      }),
      keyring: _propTypes.default.shape({
        type: _propTypes.default.string.isRequired
      }).isRequired
    }).isRequired,
    scopes: _propTypes.default.arrayOf(_propTypes.default.string).isRequired
  }).isRequired,
  /**
   * Represents if this account is currently selected
   */
  selected: _propTypes.default.bool.isRequired,
  /**
   * Function to execute when the item is clicked
   */
  onClick: _propTypes.default.func,
  /**
   * Represents how many accounts are being listed
   */
  accountsCount: _propTypes.default.number,
  /**
   * Function that closes the menu
   */
  closeMenu: _propTypes.default.func,
  /**
   * Function to set account name to show disconnect toast when an account is disconnected
   */
  onActionClick: _propTypes.default.func,
  /**
   * File location of the avatar icon
   */
  connectedAvatar: _propTypes.default.string,
  /**
   * Represents the type of menu to be rendered
   */
  menuType: _propTypes.default.string,
  /**
   * Represents pinned accounts
   */
  isPinned: _propTypes.default.bool,
  /**
   * Represents hidden accounts
   */
  isHidden: _propTypes.default.bool,
  /**
   * Represents current tab origin
   */
  currentTabOrigin: _propTypes.default.string,
  /**
   * Represents active accounts
   */
  isActive: _propTypes.default.bool,
  /**
   * Represents start accessory
   */
  startAccessory: _propTypes.default.node,
  /**
   * Determines if list item should be scrolled to when selected
   */
  shouldScrollToWhenSelected: _propTypes.default.bool,
  /**
   * Determines if list balance should be obfuscated
   */
  privacyMode: _propTypes.default.bool,
  /**
   * Determines if the connected status should be shown
   */
  showConnectedStatus: _propTypes.default.bool,
  /**
   * Determines if account labels should be shown
   */
  showAccountLabels: _propTypes.default.bool,
  /**
   * Determines if left dark blue selection indicator is displayed or not
   */
  showSelectionIndicator: _propTypes.default.bool
};
AccountListItem.displayName = 'AccountListItem';
var _default = exports.default = /*#__PURE__*/_react.default.memo(AccountListItem);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\account-list-item\\account-list-item.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-list-item\\account-list-item.types.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Caccount-list-item%5Caccount-list-item.types.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountListItemMenuTypes = void 0;
const AccountListItemMenuTypes = exports.AccountListItemMenuTypes = {
  None: 'none',
  Connection: 'connection',
  Account: 'account'
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\account-list-item\\account-list-item.types.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-list-item\\index.js", {"./account-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-list-item\\account-list-item.js","./account-list-item.types":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-list-item\\account-list-item.types.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Caccount-list-item%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "AccountListItem", {
  enumerable: true,
  get: function () {
    return _accountListItem.default;
  }
});
Object.defineProperty(exports, "AccountListItemMenuTypes", {
  enumerable: true,
  get: function () {
    return _accountListItem2.AccountListItemMenuTypes;
  }
});
var _accountListItem = _interopRequireDefault(require("./account-list-item"));
var _accountListItem2 = require("./account-list-item.types");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\account-list-item\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-list-menu\\account-list-menu.tsx", {"../../../../shared/constants/app-state":"D:\\code\\v\\metamask-extension\\shared\\constants\\app-state.ts","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../account-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-list-item\\index.js","../account-list-item/account-list-item.types":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-list-item\\account-list-item.types.js","../account-menu":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-menu\\index.ts","./hidden-account-list":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-list-menu\\hidden-account-list.js","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","fuse.js":"D:\\code\\v\\metamask-extension\\node_modules\\fuse.js\\dist\\fuse.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Caccount-list-menu%5Caccount-list-menu.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountListMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _fuse = _interopRequireDefault(require("fuse.js"));
var _reactRedux = require("react-redux");
var _keyringApi = require("@metamask/keyring-api");
var _componentLibrary = require("../../component-library");
var _accountListItem = require("../account-list-item");
var _accountListItem2 = require("../account-list-item/account-list-item.types");
var _designSystem = require("../../../helpers/constants/design-system");
var _metametrics = require("../../../contexts/metametrics");
var _selectors = require("../../../selectors");
var _actions = require("../../../store/actions");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _trace = require("../../../../shared/lib/trace");
var _appState = require("../../../../shared/constants/app-state");
var _accountMenu = require("../account-menu");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _hiddenAccountList = require("./hidden-account-list");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const AccountListMenu = ({
  onClose,
  privacyMode = false,
  showAccountCreation = true,
  accountListItemProps,
  allowedAccountTypes = [_keyringApi.EthAccountType.Eoa, _keyringApi.EthAccountType.Erc4337, _keyringApi.BtcAccountType.P2pkh, _keyringApi.BtcAccountType.P2sh, _keyringApi.BtcAccountType.P2wpkh, _keyringApi.BtcAccountType.P2tr, _keyringApi.SolAccountType.DataAccount]
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const hdEntropyIndex = (0, _reactRedux.useSelector)(_selectors.getHDEntropyIndex);
  (0, _react.useEffect)(() => {
    (0, _trace.endTrace)({
      name: _trace.TraceName.AccountList
    });
  }, []);
  const accounts = (0, _reactRedux.useSelector)(_selectors.getMetaMaskAccountsOrdered);
  const filteredAccounts = (0, _react.useMemo)(() => accounts.filter(account => allowedAccountTypes.includes(account.type)), [accounts, allowedAccountTypes]);
  const hiddenAddresses = (0, _reactRedux.useSelector)(_selectors.getHiddenAccountsList);
  const updatedAccountsList = (0, _reactRedux.useSelector)(_selectors.getUpdatedAndSortedAccounts);
  const filteredUpdatedAccountList = (0, _react.useMemo)(() => updatedAccountsList.filter(account => allowedAccountTypes.includes(account.type)), [updatedAccountsList, allowedAccountTypes]);
  const allChainIds = (0, _reactRedux.useSelector)(_selectors.getAllChainsToPoll);
  const selectedAccount = (0, _reactRedux.useSelector)(_selectors.getSelectedInternalAccount);
  const connectedSites = (0, _reactRedux.useSelector)(_selectors.getConnectedSubjectsForAllAddresses);
  const currentTabOrigin = (0, _reactRedux.useSelector)(_selectors.getOriginOfCurrentTab);
  const dispatch = (0, _reactRedux.useDispatch)();
  const [searchQuery, setSearchQuery] = (0, _react.useState)('');
  const searchResults = (0, _react.useMemo)(() => {
    let _searchResults = filteredUpdatedAccountList;
    if (searchQuery) {
      const fuse = new _fuse.default(filteredAccounts, {
        threshold: 0.2,
        location: 0,
        distance: 100,
        maxPatternLength: 32,
        minMatchCharLength: 1,
        keys: ['metadata.name', 'address']
      });
      fuse.setCollection(filteredAccounts);
      _searchResults = fuse.search(searchQuery);
    }
    return _searchResults;
  }, [filteredAccounts, filteredUpdatedAccountList, searchQuery]);
  const defaultHomeActiveTabName = (0, _reactRedux.useSelector)(_selectors.getDefaultHomeActiveTabName);
  const onAccountListItemItemClicked = (0, _react.useCallback)(account => {
    onClose();
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.Navigation,
      event: _metametrics2.MetaMetricsEventName.NavAccountSwitched,
      properties: {
        location: 'Main Menu',
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        hd_entropy_index: hdEntropyIndex
      }
    });
    (0, _trace.endTrace)({
      name: _appState.ACCOUNT_OVERVIEW_TAB_KEY_TO_TRACE_NAME_MAP[defaultHomeActiveTabName]
    });
    (0, _trace.trace)({
      name: _appState.ACCOUNT_OVERVIEW_TAB_KEY_TO_TRACE_NAME_MAP[defaultHomeActiveTabName]
    });
    dispatch((0, _actions.setSelectedAccount)(account.address));
    dispatch((0, _actions.detectNfts)(allChainIds));
  }, [dispatch, onClose, trackEvent, defaultHomeActiveTabName, hdEntropyIndex, allChainIds]);
  const accountListItems = (0, _react.useMemo)(() => {
    return searchResults.map(account => {
      var _connectedSites$accou;
      const connectedSite = (_connectedSites$accou = connectedSites[account.address]) === null || _connectedSites$accou === void 0 ? void 0 : _connectedSites$accou.find(({
        origin
      }) => origin === currentTabOrigin);
      const hideAccountListItem = searchQuery.length === 0 && account.hidden;

      /* NOTE: Hidden account will be displayed only in the search list */

      return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        className: account.hidden ? 'multichain-account-menu-popover__list--menu-item-hidden' : 'multichain-account-menu-popover__list--menu-item',
        display: hideAccountListItem ? _designSystem.Display.None : _designSystem.Display.Block,
        key: account.address
      }, /*#__PURE__*/_react.default.createElement(_accountListItem.AccountListItem, _extends({
        onClick: onAccountListItemItemClicked,
        account: account,
        key: account.address,
        selected: selectedAccount.address === account.address,
        closeMenu: onClose,
        connectedAvatar: connectedSite === null || connectedSite === void 0 ? void 0 : connectedSite.iconUrl,
        menuType: _accountListItem2.AccountListItemMenuTypes.Account,
        isPinned: Boolean(account.pinned),
        isHidden: Boolean(account.hidden),
        currentTabOrigin: currentTabOrigin,
        isActive: Boolean(account.active),
        privacyMode: privacyMode
      }, accountListItemProps)));
    });
  }, [searchResults, connectedSites, currentTabOrigin, privacyMode, accountListItemProps, selectedAccount, onClose, onAccountListItemItemClicked, searchQuery]);
  return /*#__PURE__*/_react.default.createElement(_accountMenu.AccountMenu, {
    onClose: onClose,
    showAccountCreation: showAccountCreation
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, filteredAccounts.length > 1 ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 4,
    paddingRight: 4,
    paddingBottom: 4,
    paddingTop: 0
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.TextFieldSearch, {
    size: _componentLibrary.TextFieldSearchSize.Sm,
    width: _designSystem.BlockSize.Full,
    placeholder: t('searchAccounts'),
    value: searchQuery,
    onChange: e => setSearchQuery(e.target.value),
    clearButtonOnClick: () => setSearchQuery(''),
    clearButtonProps: {
      size: _componentLibrary.ButtonIconSize.Sm
    },
    inputProps: {
      autoFocus: true
    },
    endAccessory: null,
    className: ""
  })) : null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "multichain-account-menu-popover__list"
  }, searchResults.length === 0 && searchQuery !== '' ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    paddingLeft: 4,
    paddingRight: 4,
    color: _designSystem.TextColor.textMuted,
    "data-testid": "multichain-account-menu-popover-no-results"
  }, t('noAccountsFound')) : null, accountListItems, hiddenAddresses.length > 0 ? /*#__PURE__*/_react.default.createElement(_hiddenAccountList.HiddenAccountList, {
    onClose: onClose
  }) : null)));
};
exports.AccountListMenu = AccountListMenu;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\account-list-menu\\account-list-menu.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-list-menu\\hidden-account-list.js", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../account-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-list-item\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Caccount-list-menu%5Chidden-account-list.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HiddenAccountList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRedux = require("react-redux");
var _metametrics = require("../../../../shared/constants/metametrics");
var _metametrics2 = require("../../../contexts/metametrics");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _selectors = require("../../../selectors");
var _actions = require("../../../store/actions");
var _componentLibrary = require("../../component-library");
var _accountListItem = require("../account-list-item");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HiddenAccountList = ({
  onClose
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const hdEntropyIndex = (0, _reactRedux.useSelector)(_selectors.getHDEntropyIndex);
  const dispatch = (0, _reactRedux.useDispatch)();
  const hiddenAddresses = (0, _reactRedux.useSelector)(_selectors.getHiddenAccountsList);
  const accounts = (0, _reactRedux.useSelector)(_selectors.getMetaMaskAccountsOrdered);
  const selectedAccount = (0, _reactRedux.useSelector)(_selectors.getSelectedAccount);
  const connectedSites = (0, _reactRedux.useSelector)(_selectors.getConnectedSubjectsForAllAddresses);
  const currentTabOrigin = (0, _reactRedux.useSelector)(_selectors.getOriginOfCurrentTab);
  const filteredHiddenAccounts = accounts.filter(account => hiddenAddresses.includes(account.address));
  const [showListItem, setShowListItem] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    as: "button",
    onClick: () => setShowListItem(!showListItem),
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    display: _designSystem.Display.Flex,
    padding: 4,
    alignItems: _designSystem.AlignItems.center,
    width: _designSystem.BlockSize.Full,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    className: "hidden-accounts-list",
    "data-testid": "hidden-accounts-list"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    width: _designSystem.BlockSize.TwoThirds,
    gap: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarIcon, {
    iconName: _componentLibrary.IconName.EyeSlash,
    color: _designSystem.IconColor.infoDefault,
    backgroundColor: _designSystem.BackgroundColor.infoMuted,
    size: _componentLibrary.AvatarIconSize.Sm
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium
  }, t('hiddenAccounts')))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    gap: 2,
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    width: _designSystem.BlockSize.OneThird,
    justifyContent: _designSystem.JustifyContent.flexEnd
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium
  }, hiddenAddresses.length), /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: showListItem ? _componentLibrary.IconName.ArrowUp : _componentLibrary.IconName.ArrowDown,
    size: _componentLibrary.IconSize.Sm,
    color: _designSystem.IconColor.iconDefault
  }))), showListItem ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, filteredHiddenAccounts.map(account => {
    var _connectedSites$accou;
    const connectedSite = (_connectedSites$accou = connectedSites[account.address]) === null || _connectedSites$accou === void 0 ? void 0 : _connectedSites$accou.find(({
      origin
    }) => origin === currentTabOrigin);
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      className: "multichain-account-menu-popover__list--menu-item-hidden-account",
      key: account.address
    }, /*#__PURE__*/_react.default.createElement(_accountListItem.AccountListItem, {
      onClick: () => {
        onClose();
        trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Navigation,
          event: _metametrics.MetaMetricsEventName.NavAccountSwitched,
          properties: {
            location: 'Main Menu',
            hd_entropy_index: hdEntropyIndex
          }
        });
        dispatch((0, _actions.setSelectedAccount)(account.address));
      },
      account: account,
      key: account.address,
      selected: selectedAccount.address === account.address,
      closeMenu: onClose,
      connectedAvatar: connectedSite === null || connectedSite === void 0 ? void 0 : connectedSite.iconUrl,
      menuType: _accountListItem.AccountListItemMenuTypes.Account,
      isPinned: Boolean(account.pinned),
      isHidden: true
    }));
  })) : null);
};
exports.HiddenAccountList = HiddenAccountList;
HiddenAccountList.propTypes = {
  /**
   * Function that executes when the menu closes
   */
  onClose: _propTypes.default.func.isRequired
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\account-list-menu\\hidden-account-list.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-list-menu\\index.js", {"./account-list-menu":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-list-menu\\account-list-menu.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Caccount-list-menu%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "AccountListMenu", {
  enumerable: true,
  get: function () {
    return _accountListMenu.AccountListMenu;
  }
});
var _accountListMenu = require("./account-list-menu");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\account-list-menu\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-menu\\account-menu.tsx", {"../../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/multichain/networks":"D:\\code\\v\\metamask-extension\\shared\\constants\\multichain\\networks.ts","../../../../shared/lib/accounts/institutional-wallet-snap":"D:\\code\\v\\metamask-extension\\shared\\lib\\accounts\\institutional-wallet-snap.ts","../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../hooks/accounts/useMultichainWalletSnapClient":"D:\\code\\v\\metamask-extension\\ui\\hooks\\accounts\\useMultichainWalletSnapClient.ts","../../../hooks/social-sync/useSyncSRPs":"D:\\code\\v\\metamask-extension\\ui\\hooks\\social-sync\\useSyncSRPs.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../component-library/modal-content/deprecated":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\modal-content\\deprecated\\index.ts","../../component-library/modal-header":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\modal-header\\index.ts","../create-eth-account":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\create-eth-account\\index.js","../create-snap-account":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\create-snap-account\\index.ts","../import-account":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\import-account\\index.js","../multi-srp/srp-list":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\multi-srp\\srp-list\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Caccount-menu%5Caccount-menu.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getActionTitle = exports.SNAP_CLIENT_CONFIG_MAP = exports.AccountMenu = exports.ACTION_MODES = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _componentLibrary = require("../../component-library");
var _deprecated = require("../../component-library/modal-content/deprecated");
var _modalHeader = require("../../component-library/modal-header");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _metametrics = require("../../../contexts/metametrics");
var _selectors = require("../../../selectors");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _routes = require("../../../helpers/constants/routes");
var _util = require("../../../../app/scripts/lib/util");
var _app = require("../../../../shared/constants/app");
var _useMultichainWalletSnapClient = require("../../../hooks/accounts/useMultichainWalletSnapClient");
var _trace = require("../../../../shared/lib/trace");
var _createEthAccount = require("../create-eth-account");
var _createSnapAccount = require("../create-snap-account");
var _importAccount = require("../import-account");
var _srpList = require("../multi-srp/srp-list");
var _institutionalWalletSnap = require("../../../../shared/lib/accounts/institutional-wallet-snap");
var _networks = require("../../../../shared/constants/multichain/networks");
var _useSyncSRPs = require("../../../hooks/social-sync/useSyncSRPs");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

///: BEGIN:ONLY_INCLUDE_IF(multichain)

///: END:ONLY_INCLUDE_IF

///: BEGIN:ONLY_INCLUDE_IF(multichain)

///: END:ONLY_INCLUDE_IF

// TODO: Should we use an enum for this instead?
const ACTION_MODES = exports.ACTION_MODES = {
  // Displays the search box and account list
  LIST: '',
  // Displays the Add, Import, Hardware accounts
  MENU: 'menu',
  // Displays the add account form controls
  ADD: 'add',
  // Displays the add account form controls (for solana account)
  ADD_SOLANA: 'add-solana',
  // Displays the import account form controls
  IMPORT: 'import',
  CREATE_SRP: 'create-srp',
  IMPORT_SRP: 'import-srp',
  SELECT_SRP: 'select-srp'
};
///: BEGIN:ONLY_INCLUDE_IF(multichain)
const SNAP_CLIENT_CONFIG_MAP = exports.SNAP_CLIENT_CONFIG_MAP = {
  [ACTION_MODES.ADD_BITCOIN]: {
    clientType: _useMultichainWalletSnapClient.WalletClientType.Bitcoin,
    chainId: _networks.MultichainNetworks.BITCOIN
  },
  [ACTION_MODES.ADD_SOLANA]: {
    clientType: _useMultichainWalletSnapClient.WalletClientType.Solana,
    chainId: _networks.MultichainNetworks.SOLANA
  }
};
///: END:ONLY_INCLUDE_IF(multichain)
/**
 * Gets the title for a given action mode.
 *
 * @param t - Function to translate text.
 * @param actionMode - An action mode.
 * @param isMultichainAccountsState1Enabled - Whether the multichain accounts state 1 is enabled.
 * @returns The title for this action mode.
 */
const getActionTitle = (t, actionMode, isMultichainAccountsState1Enabled) => {
  switch (actionMode) {
    case ACTION_MODES.ADD:
      return t('addAccountFromNetwork', [t('networkNameEthereum')]);
    case ACTION_MODES.MENU:
      return t('addAccount');
    case ACTION_MODES.ADD_SOLANA:
      return t('addAccountFromNetwork', [t('networkNameSolana')]);
    case ACTION_MODES.IMPORT:
      return t('importPrivateKey');
    case ACTION_MODES.CREATE_SRP:
      return t('createSecretRecoveryPhrase');
    case ACTION_MODES.IMPORT_SRP:
      return t('importSecretRecoveryPhrase');
    case ACTION_MODES.SELECT_SRP:
      return t('selectSecretRecoveryPhrase');
    default:
      return isMultichainAccountsState1Enabled ? t('accounts') : t('selectAnAccount');
  }
};
exports.getActionTitle = getActionTitle;
const AccountMenu = ({
  onClose,
  showAccountCreation = true,
  children
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const hdEntropyIndex = (0, _reactRedux.useSelector)(_selectors.getHDEntropyIndex);
  (0, _react.useEffect)(() => {
    (0, _trace.endTrace)({
      name: _trace.TraceName.AccountList
    });
  }, []);
  const history = (0, _reactRouterDom.useHistory)();
  const isMultichainAccountsState1Enabled = (0, _reactRedux.useSelector)(_selectors.getIsMultichainAccountsState1Enabled);

  // sync SRPs list when menu opens
  (0, _useSyncSRPs.useSyncSRPs)();
  const [actionMode, setActionMode] = (0, _react.useState)(ACTION_MODES.LIST);
  const [previousActionMode, setPreviousActionMode] = (0, _react.useState)(ACTION_MODES.LIST);
  ///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
  const addSnapAccountEnabled = (0, _reactRedux.useSelector)(_selectors.getIsAddSnapAccountEnabled);
  ///: END:ONLY_INCLUDE_IF

  const solanaSupportEnabled = (0, _reactRedux.useSelector)(_selectors.getIsSolanaSupportEnabled);
  const solanaWalletSnapClient = (0, _useMultichainWalletSnapClient.useMultichainWalletSnapClient)(_useMultichainWalletSnapClient.WalletClientType.Solana);
  ///: BEGIN:ONLY_INCLUDE_IF(multichain)
  const [primaryKeyring] = (0, _reactRedux.useSelector)(_selectors.getMetaMaskHdKeyrings);
  const handleMultichainSnapAccountCreation = async (client, _options, action) => {
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.Navigation,
      event: _metametrics2.MetaMetricsEventName.AccountAddSelected,
      properties: {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        account_type: _metametrics2.MetaMetricsEventAccountType.Snap,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        snap_id: client.getSnapId(),
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        snap_name: client.getSnapName(),
        location: 'Main Menu',
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        hd_entropy_index: hdEntropyIndex,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        chain_id_caip: _options.scope
      }
    });
    return setActionMode(action);
  };
  ///: END:ONLY_INCLUDE_IF
  const manageInstitutionalWallets = (0, _reactRedux.useSelector)(_selectors.getManageInstitutionalWallets);

  // Here we are getting the keyring of the last selected account
  // if it is not an hd keyring, we will use the primary keyring
  const hdKeyring = (0, _reactRedux.useSelector)(_selectors.getHdKeyringOfSelectedAccountOrPrimaryKeyring);
  const [selectedKeyringId, setSelectedKeyringId] = (0, _react.useState)(hdKeyring.metadata.id);
  const title = (0, _react.useMemo)(() => getActionTitle(t, actionMode, Boolean(isMultichainAccountsState1Enabled)), [actionMode, t, isMultichainAccountsState1Enabled]);

  // eslint-disable-next-line no-empty-function
  let onBack;
  if (actionMode !== ACTION_MODES.LIST) {
    if (actionMode === ACTION_MODES.MENU) {
      onBack = () => setActionMode(ACTION_MODES.LIST);
    } else if (actionMode === ACTION_MODES.SELECT_SRP) {
      onBack = () => setActionMode(previousActionMode);
    } else {
      onBack = () => setActionMode(ACTION_MODES.MENU);
    }
  }
  const onActionComplete = (0, _react.useCallback)(async confirmed => {
    if (confirmed) {
      onClose();
    } else {
      setActionMode(ACTION_MODES.LIST);
    }
  }, [onClose, setActionMode]);
  const onSelectSrp = (0, _react.useCallback)(() => {
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.Accounts,
      event: _metametrics2.MetaMetricsEventName.SecretRecoveryPhrasePickerClicked,
      properties: {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        button_type: 'picker'
      }
    });
    setPreviousActionMode(actionMode);
    setActionMode(ACTION_MODES.SELECT_SRP);
  }, [setActionMode, actionMode, trackEvent]);

  ///: BEGIN:ONLY_INCLUDE_IF(multichain)
  const {
    clientType,
    chainId
  } = SNAP_CLIENT_CONFIG_MAP[actionMode] || {
    clientType: null,
    chainId: null
  };
  ///: END:ONLY_INCLUDE_IF(multichain)

  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: true,
    onClose: onClose
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_deprecated.ModalContent, {
    className: "multichain-account-menu-popover",
    modalDialogProps: {
      className: 'multichain-account-menu-popover__dialog',
      padding: 0,
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column
    }
  }, /*#__PURE__*/_react.default.createElement(_modalHeader.ModalHeader, {
    padding: 4,
    onClose: onClose,
    onBack: onBack
  }, title), actionMode === ACTION_MODES.ADD ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 4,
    paddingRight: 4,
    paddingBottom: 4
  }, /*#__PURE__*/_react.default.createElement(_createEthAccount.CreateEthAccount, {
    onActionComplete: onActionComplete,
    selectedKeyringId: selectedKeyringId,
    onSelectSrp: onSelectSrp
  })) : null,
  ///: BEGIN:ONLY_INCLUDE_IF(multichain)
  clientType && chainId ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 4,
    paddingRight: 4,
    paddingBottom: 4
  }, /*#__PURE__*/_react.default.createElement(_createSnapAccount.CreateSnapAccount, {
    onActionComplete: onActionComplete,
    selectedKeyringId: selectedKeyringId,
    onSelectSrp: onSelectSrp,
    clientType: clientType,
    chainId: chainId
  })) : null
  ///: END:ONLY_INCLUDE_IF(multichain)
  , actionMode === ACTION_MODES.IMPORT ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 4,
    paddingRight: 4,
    paddingBottom: 4,
    paddingTop: 0
  }, /*#__PURE__*/_react.default.createElement(_importAccount.ImportAccount, {
    onActionComplete: onActionComplete
  })) : null, actionMode === ACTION_MODES.SELECT_SRP && /*#__PURE__*/_react.default.createElement(_srpList.SrpList, {
    onActionComplete: keyringId => {
      setSelectedKeyringId(keyringId);
      setActionMode(previousActionMode);
    }
  }), actionMode === ACTION_MODES.MENU ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    padding: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySmMedium,
    marginBottom: 2,
    color: _designSystem.TextColor.textAlternative
  }, t('createNewAccountHeader')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    size: _componentLibrary.ButtonLinkSize.Sm,
    startIconName: _componentLibrary.IconName.Add,
    startIconProps: {
      size: _componentLibrary.IconSize.Md
    },
    onClick: () => {
      trackEvent({
        category: _metametrics2.MetaMetricsEventCategory.Navigation,
        event: _metametrics2.MetaMetricsEventName.AccountAddSelected,
        properties: {
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          account_type: _metametrics2.MetaMetricsEventAccountType.Default,
          location: 'Main Menu',
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          hd_entropy_index: hdEntropyIndex
        }
      });
      setActionMode(ACTION_MODES.ADD);
    },
    "data-testid": "multichain-account-menu-popover-add-account"
  }, t('addNewEthereumAccountLabel'))), solanaSupportEnabled && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginTop: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    size: _componentLibrary.ButtonLinkSize.Sm,
    startIconName: _componentLibrary.IconName.Add,
    startIconProps: {
      size: _componentLibrary.IconSize.Md
    }
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    ,
    onClick: async () => {
      await handleMultichainSnapAccountCreation(solanaWalletSnapClient, {
        scope: _networks.MultichainNetworks.SOLANA,
        entropySource: primaryKeyring.metadata.id
      }, ACTION_MODES.ADD_SOLANA);
    },
    "data-testid": "multichain-account-menu-popover-add-solana-account"
  }, t('addNewSolanaAccountLabel'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySmMedium,
    marginTop: 4,
    marginBottom: 2,
    color: _designSystem.TextColor.textAlternative
  }, t('importWalletOrAccountHeader')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginTop: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    size: _componentLibrary.ButtonLinkSize.Sm,
    startIconName: _componentLibrary.IconName.Wallet,
    startIconProps: {
      size: _componentLibrary.IconSize.Md
    },
    onClick: () => {
      trackEvent({
        category: _metametrics2.MetaMetricsEventCategory.Navigation,
        event: _metametrics2.MetaMetricsEventName.ImportSecretRecoveryPhraseClicked
      });
      history.push(_routes.IMPORT_SRP_ROUTE);
      onClose();
    },
    "data-testid": "multichain-account-menu-popover-import-srp"
  }, t('secretRecoveryPhrase'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginTop: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    size: _componentLibrary.ButtonLinkSize.Sm,
    startIconName: _componentLibrary.IconName.Key,
    startIconProps: {
      size: _componentLibrary.IconSize.Md
    },
    "data-testid": "multichain-account-menu-popover-add-imported-account",
    onClick: () => {
      trackEvent({
        category: _metametrics2.MetaMetricsEventCategory.Navigation,
        event: _metametrics2.MetaMetricsEventName.AccountAddSelected,
        properties: {
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          account_type: _metametrics2.MetaMetricsEventAccountType.Imported,
          location: 'Main Menu',
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          hd_entropy_index: hdEntropyIndex
        }
      });
      setActionMode(ACTION_MODES.IMPORT);
    }
  }, t('importPrivateKey'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySmMedium,
    marginTop: 4,
    marginBottom: 2,
    color: _designSystem.TextColor.textAlternative
  }, t('connectAnAccountHeader')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginTop: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    size: _componentLibrary.ButtonLinkSize.Sm,
    startIconName: _componentLibrary.IconName.Hardware,
    startIconProps: {
      size: _componentLibrary.IconSize.Md
    },
    onClick: () => {
      onClose();
      trackEvent({
        category: _metametrics2.MetaMetricsEventCategory.Navigation,
        event: _metametrics2.MetaMetricsEventName.AccountAddSelected,
        properties: {
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          account_type: _metametrics2.MetaMetricsEventAccountType.Hardware,
          location: 'Main Menu',
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          hd_entropy_index: hdEntropyIndex
        }
      });
      if ((0, _util.getEnvironmentType)() === _app.ENVIRONMENT_TYPE_POPUP) {
        var _global$platform$open, _global$platform;
        (_global$platform$open = (_global$platform = global.platform).openExtensionInBrowser) === null || _global$platform$open === void 0 || _global$platform$open.call(_global$platform, _routes.CONNECT_HARDWARE_ROUTE);
      } else {
        history.push(_routes.CONNECT_HARDWARE_ROUTE);
      }
    }
  }, t('addHardwareWalletLabel'))),
  ///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
  addSnapAccountEnabled ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginTop: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    size: _componentLibrary.ButtonLinkSize.Sm,
    startIconName: _componentLibrary.IconName.Snaps,
    startIconProps: {
      size: _componentLibrary.IconSize.Md
    },
    onClick: () => {
      onClose();
      trackEvent({
        category: _metametrics2.MetaMetricsEventCategory.Navigation,
        event: _metametrics2.MetaMetricsEventName.AccountAddSelected,
        properties: {
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          account_type: _metametrics2.MetaMetricsEventAccountType.Snap,
          location: 'Main Menu',
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          hd_entropy_index: hdEntropyIndex
        }
      });
      global.platform.openTab({
        url: "https://snaps.metamask.io/account-management"
      });
    }
  }, t('settingAddSnapAccount'))) : null
  ///: END:ONLY_INCLUDE_IF
  , manageInstitutionalWallets && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginTop: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    size: _componentLibrary.ButtonLinkSize.Sm,
    startIconName: _componentLibrary.IconName.Add,
    onClick: () => {
      onClose();
      history.push(`/snaps/view/${encodeURIComponent(_institutionalWalletSnap.INSTITUTIONAL_WALLET_SNAP_ID)}`);
    }
  }, t('manageInstitutionalWallets')))) : null, actionMode === ACTION_MODES.LIST ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children, showAccountCreation ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingTop: 2,
    paddingBottom: 4,
    paddingLeft: 4,
    paddingRight: 4,
    alignItems: _designSystem.AlignItems.center,
    display: _designSystem.Display.Flex
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonSecondary, {
    startIconName: isMultichainAccountsState1Enabled ? undefined : _componentLibrary.IconName.Add,
    size: _componentLibrary.ButtonSecondarySize.Lg,
    block: true,
    onClick: () => setActionMode(ACTION_MODES.MENU),
    "data-testid": "multichain-account-menu-popover-action-button"
  }, isMultichainAccountsState1Enabled ? t('addAccountOrWallet') : t('addImportAccount'))) : null) : null));
};
exports.AccountMenu = AccountMenu;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\account-menu\\account-menu.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-menu\\index.ts", {"./account-menu":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-menu\\account-menu.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Caccount-menu%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "AccountMenu", {
  enumerable: true,
  get: function () {
    return _accountMenu.AccountMenu;
  }
});
var _accountMenu = require("./account-menu");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\account-menu\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-network-indicator\\account-network-indicator.tsx", {"../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\index.js","../avatar-group":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\avatar-group\\index.ts","../avatar-group/avatar-group.types":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\avatar-group\\avatar-group.types.tsx","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Caccount-network-indicator%5Caccount-network-indicator.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountNetworkIndicator = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRedux = require("react-redux");
var _designSystem = require("../../../helpers/constants/design-system");
var _avatarGroup = require("../avatar-group/avatar-group.types");
var _avatarGroup2 = require("../avatar-group");
var _componentLibrary = require("../../component-library");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _network = require("../../../../shared/constants/network");
var _networks = require("../../../../shared/modules/selectors/networks");
var _tooltip = _interopRequireDefault(require("../../ui/tooltip"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const AccountNetworkIndicator = ({
  scopes
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const AVATAR_GROUP_LIMIT = 4;
  const TOOLTIP_LIMIT = 12;
  const networks = (0, _reactRedux.useSelector)(state => (0, _networks.getNetworksByScopes)(state, scopes));
  const avatarNetworksData = networks === null || networks === void 0 ? void 0 : networks.map(network => ({
    avatarValue: _network.CHAIN_ID_TO_NETWORK_IMAGE_URL_MAP[network.chainId],
    symbol: network.name
  }));
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    "data-testid": "account-network-indicator"
  }, /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    position: "left",
    html: /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column
    }, networks === null || networks === void 0 ? void 0 : networks.slice(0, TOOLTIP_LIMIT).map(network => {
      return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        display: _designSystem.Display.Flex,
        flexDirection: _designSystem.FlexDirection.Row,
        alignItems: _designSystem.AlignItems.center,
        textAlign: _designSystem.TextAlign.Left,
        key: network.chainId,
        padding: 1,
        paddingInline: 2,
        gap: 2
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
        size: _componentLibrary.AvatarNetworkSize.Xs,
        src: _network.CHAIN_ID_TO_NETWORK_IMAGE_URL_MAP[network.chainId],
        name: network.name,
        borderStyle: _designSystem.BorderStyle.none
      }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        variant: _designSystem.TextVariant.bodyMdMedium,
        ellipsis: true
      }, network.name));
    }), (networks === null || networks === void 0 ? void 0 : networks.length) > TOOLTIP_LIMIT ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      alignItems: _designSystem.AlignItems.center,
      textAlign: _designSystem.TextAlign.Left,
      paddingInline: 2
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      color: _designSystem.TextColor.textMuted,
      variant: _designSystem.TextVariant.bodyMdMedium
    }, t('moreNetworks', [networks.length - TOOLTIP_LIMIT]))) : null)),
    arrow: true,
    offset: 0,
    delay: 50,
    duration: 0,
    size: "small",
    title: t('alertDisableTooltip')
  }, /*#__PURE__*/_react.default.createElement(_avatarGroup2.AvatarGroup, {
    members: avatarNetworksData,
    limit: AVATAR_GROUP_LIMIT,
    avatarType: _avatarGroup.AvatarType.NETWORK,
    size: _componentLibrary.AvatarTokenSize.Xl
  })));
};
exports.AccountNetworkIndicator = AccountNetworkIndicator;
AccountNetworkIndicator.propTypes = {
  /**
   * An array of CAIP scope strings, used to determine which networks to display.
   */
  scopes: _propTypes.default.arrayOf(_propTypes.default.string).isRequired
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\account-network-indicator\\account-network-indicator.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-network-indicator\\index.ts", {"./account-network-indicator":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-network-indicator\\account-network-indicator.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Caccount-network-indicator%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "AccountNetworkIndicator", {
  enumerable: true,
  get: function () {
    return _accountNetworkIndicator.AccountNetworkIndicator;
  }
});
var _accountNetworkIndicator = require("./account-network-indicator");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\account-network-indicator\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-overview\\account-overview-eth.tsx", {"../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../app/wallet-overview":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\wallet-overview\\index.js","./account-overview-layout":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-overview\\account-overview-layout.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Caccount-overview%5Caccount-overview-eth.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountOverviewEth = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _walletOverview = require("../../app/wallet-overview");
var _selectors = require("../../../selectors");
var _accountOverviewLayout = require("./account-overview-layout");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const AccountOverviewEth = props => {
  const defiPositionsEnabled = (0, _reactRedux.useSelector)(_selectors.getIsDefiPositionsEnabled);
  return /*#__PURE__*/_react.default.createElement(_accountOverviewLayout.AccountOverviewLayout, _extends({
    showTokens: true,
    showNfts: true,
    showDefi: defiPositionsEnabled,
    showActivity: true
  }, props), /*#__PURE__*/_react.default.createElement(_walletOverview.EthOverview, null));
};
exports.AccountOverviewEth = AccountOverviewEth;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\account-overview\\account-overview-eth.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-overview\\account-overview-layout.tsx", {"..":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../hooks/useCarouselManagement":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useCarouselManagement\\index.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../app/download-mobile-modal/download-mobile-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\download-mobile-modal\\download-mobile-modal.tsx","../../app/network-connection-banner":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\network-connection-banner\\index.ts","../create-solana-account-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\create-solana-account-modal\\index.ts","./account-overview-tabs":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-overview\\account-overview-tabs.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Caccount-overview%5Caccount-overview-layout.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountOverviewLayout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _actions = require("../../../store/actions");
var _ = require("..");
var _selectors = require("../../../selectors");
var _metametrics = require("../../../contexts/metametrics");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _useCarouselManagement = require("../../../hooks/useCarouselManagement");
var _createSolanaAccountModal = require("../create-solana-account-modal");
var _multichain = require("../../../selectors/multichain");
var _downloadMobileModal = _interopRequireDefault(require("../../app/download-mobile-modal/download-mobile-modal"));
var _networkConnectionBanner = require("../../app/network-connection-banner");
var _accountOverviewTabs = require("./account-overview-tabs");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AccountOverviewLayout = ({
  children,
  ...tabsProps
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const isLoading = (0, _reactRedux.useSelector)(_selectors.getAppIsLoading);
  const remoteFeatureFlags = (0, _reactRedux.useSelector)(_selectors.getRemoteFeatureFlags);
  const isCarouselEnabled = Boolean(remoteFeatureFlags === null || remoteFeatureFlags === void 0 ? void 0 : remoteFeatureFlags.carouselBanners);
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const [hasRendered, setHasRendered] = (0, _react.useState)(false);
  const [showCreateSolanaAccountModal, setShowCreateSolanaAccountModal] = (0, _react.useState)(false);
  const hasSolanaAccount = (0, _reactRedux.useSelector)(_selectors.hasCreatedSolanaAccount);
  const selectedSolanaAccount = (0, _reactRedux.useSelector)(_multichain.getLastSelectedSolanaAccount);
  const [showDownloadMobileAppModal, setShowDownloadMobileAppModal] = (0, _react.useState)(false);
  const {
    slides
  } = (0, _useCarouselManagement.useCarouselManagement)({
    enabled: isCarouselEnabled
  });
  const slideById = (0, _react.useMemo)(() => {
    const m = new Map();
    slides.forEach(s => m.set(s.id, s));
    return m;
  }, [slides]);
  const handleCarouselClick = id => {
    const slide = slideById.get(id);
    const key = (slide === null || slide === void 0 ? void 0 : slide.variableName) ?? id;
    if (key === 'solana') {
      if (hasSolanaAccount && selectedSolanaAccount) {
        dispatch((0, _actions.setSelectedAccount)(selectedSolanaAccount.address));
      } else {
        setShowCreateSolanaAccountModal(true);
      }
    }
    if (key === 'downloadMobileApp') {
      setShowDownloadMobileAppModal(true);
    }
    trackEvent({
      event: _metametrics2.MetaMetricsEventName.BannerSelect,
      category: _metametrics2.MetaMetricsEventCategory.Banner,
      properties: {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        banner_name: key
      }
    });
  };
  const handleRemoveSlide = (slideId, isLastSlide) => {
    if (isLastSlide) {
      trackEvent({
        event: _metametrics2.MetaMetricsEventName.BannerCloseAll,
        category: _metametrics2.MetaMetricsEventCategory.Banner
      });
    }
    dispatch((0, _actions.removeSlide)(slideId));
  };
  const handleRenderSlides = (0, _react.useCallback)(renderedSlides => {
    if (!hasRendered) {
      renderedSlides.forEach(slide => {
        trackEvent({
          event: _metametrics2.MetaMetricsEventName.BannerDisplay,
          category: _metametrics2.MetaMetricsEventCategory.Banner,
          properties: {
            // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
            // eslint-disable-next-line @typescript-eslint/naming-convention
            banner_name: slide.id
          }
        });
      });
      setHasRendered(true);
    }
  }, [hasRendered, trackEvent]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "account-overview__balance-wrapper"
  }, /*#__PURE__*/_react.default.createElement(_networkConnectionBanner.NetworkConnectionBanner, null), children), isCarouselEnabled && /*#__PURE__*/_react.default.createElement(_.CarouselWithEmptyState, {
    slides: slides,
    isLoading: isLoading,
    onSlideClick: handleCarouselClick,
    onSlideClose: handleRemoveSlide,
    onRenderSlides: handleRenderSlides,
    className: "mb-3 px-4"
  }), /*#__PURE__*/_react.default.createElement(_accountOverviewTabs.AccountOverviewTabs, tabsProps), showCreateSolanaAccountModal && /*#__PURE__*/_react.default.createElement(_createSolanaAccountModal.CreateSolanaAccountModal, {
    onClose: () => setShowCreateSolanaAccountModal(false)
  }), showDownloadMobileAppModal && /*#__PURE__*/_react.default.createElement(_downloadMobileModal.default, {
    onClose: () => setShowDownloadMobileAppModal(false)
  }));
};
exports.AccountOverviewLayout = AccountOverviewLayout;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\account-overview\\account-overview-layout.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-overview\\account-overview-non-evm.tsx", {"../../app/wallet-overview":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\wallet-overview\\index.js","./account-overview-layout":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-overview\\account-overview-layout.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Caccount-overview%5Caccount-overview-non-evm.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountOverviewNonEvm = void 0;
var _react = _interopRequireDefault(require("react"));
var _walletOverview = require("../../app/wallet-overview");
var _accountOverviewLayout = require("./account-overview-layout");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const AccountOverviewNonEvm = ({
  ...props
}) => {
  return /*#__PURE__*/_react.default.createElement(_accountOverviewLayout.AccountOverviewLayout, _extends({
    showTokens: true,
    showTokensLinks: false,
    showNfts: false,
    showActivity: true
  }, props), /*#__PURE__*/_react.default.createElement(_walletOverview.NonEvmOverview, null));
};
exports.AccountOverviewNonEvm = AccountOverviewNonEvm;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\account-overview\\account-overview-non-evm.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-overview\\account-overview-tabs.tsx", {"../../../../shared/constants/app-state":"D:\\code\\v\\metamask-extension\\shared\\constants\\app-state.ts","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../hooks/useTokenBalances":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTokenBalances.ts","../../../pages/settings/networks-tab/networks-form/use-safe-chains":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\networks-tab\\networks-form\\use-safe-chains.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../app/assets/asset-list":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\asset-list\\index.ts","../../app/assets/defi-list/defi-tab":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\defi-list\\defi-tab.tsx","../../app/assets/hooks":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\hooks\\index.ts","../../app/assets/nfts/nfts-tab":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\nfts\\nfts-tab\\index.ts","../../app/transaction-list":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\transaction-list\\index.js","../../app/transaction-list/unified-transaction-list.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\transaction-list\\unified-transaction-list.component.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/tabs":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tabs\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Caccount-overview%5Caccount-overview-tabs.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountOverviewTabs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _appState = require("../../../../shared/constants/app-state");
var _metametrics = require("../../../../shared/constants/metametrics");
var _trace = require("../../../../shared/lib/trace");
var _metametrics2 = require("../../../contexts/metametrics");
var _routes = require("../../../helpers/constants/routes");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _useSafeChains = require("../../../pages/settings/networks-tab/networks-form/use-safe-chains");
var _selectors = require("../../../selectors");
var _actions = require("../../../store/actions");
var _assetList = _interopRequireDefault(require("../../app/assets/asset-list"));
var _defiTab = _interopRequireDefault(require("../../app/assets/defi-list/defi-tab"));
var _hooks = require("../../app/assets/hooks");
var _nftsTab = _interopRequireDefault(require("../../app/assets/nfts/nfts-tab"));
var _transactionList = _interopRequireDefault(require("../../app/transaction-list"));
var _unifiedTransactionList = _interopRequireDefault(require("../../app/transaction-list/unified-transaction-list.component"));
var _componentLibrary = require("../../component-library");
var _tabs = require("../../ui/tabs");
var _useTokenBalances = require("../../../hooks/useTokenBalances");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AccountOverviewTabs = ({
  onTabClick,
  defaultHomeActiveTabName,
  showTokens,
  showTokensLinks,
  showNfts,
  showActivity,
  showDefi
}) => {
  const history = (0, _reactRouterDom.useHistory)();
  const t = (0, _useI18nContext.useI18nContext)();
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const dispatch = (0, _reactRedux.useDispatch)();
  const selectedChainIds = (0, _reactRedux.useSelector)(_selectors.getChainIdsToPoll);
  (0, _hooks.useAssetListTokenDetection)();

  // EVM specific tokenBalance polling, updates state via polling loop per chainId
  (0, _useTokenBalances.useTokenBalances)({
    chainIds: selectedChainIds
  });
  const handleTabClick = (0, _react.useCallback)(tabName => {
    onTabClick(tabName);
    if (tabName === _appState.AccountOverviewTabKey.Nfts) {
      dispatch((0, _actions.detectNfts)(selectedChainIds));
    }
    if (tabName === _appState.AccountOverviewTabKey.Activity) {
      dispatch((0, _actions.updateIncomingTransactions)());
    }
    trackEvent({
      category: _metametrics.MetaMetricsEventCategory.Home,
      event: _appState.ACCOUNT_OVERVIEW_TAB_KEY_TO_METAMETRICS_EVENT_NAME_MAP[tabName]
    });
    if (defaultHomeActiveTabName) {
      (0, _trace.endTrace)({
        name: _appState.ACCOUNT_OVERVIEW_TAB_KEY_TO_TRACE_NAME_MAP[defaultHomeActiveTabName]
      });
    }
    (0, _trace.trace)({
      name: _appState.ACCOUNT_OVERVIEW_TAB_KEY_TO_TRACE_NAME_MAP[tabName]
    });
  }, [onTabClick]);
  const onClickAsset = (0, _react.useCallback)((chainId, asset) => history.push(`${_routes.ASSET_ROUTE}/${chainId}/${encodeURIComponent(asset)}`), [history]);
  const onClickDeFi = (0, _react.useCallback)((chainId, protocolId) => history.push(`${_routes.DEFI_ROUTE}/${chainId}/${encodeURIComponent(protocolId)}`), [history]);
  const {
    safeChains
  } = (0, _useSafeChains.useSafeChains)();
  const isBIP44FeatureFlagEnabled = (0, _reactRedux.useSelector)(_selectors.getIsMultichainAccountsState2Enabled);
  const showUnifiedTransactionList = isBIP44FeatureFlagEnabled;
  return /*#__PURE__*/_react.default.createElement(_tabs.Tabs, {
    defaultActiveTabKey: defaultHomeActiveTabName ?? undefined,
    onTabClick: handleTabClick,
    tabListProps: {
      className: 'px-4'
    }
  }, showTokens && /*#__PURE__*/_react.default.createElement(_tabs.Tab, {
    name: t('tokens'),
    tabKey: _appState.AccountOverviewTabKey.Tokens,
    "data-testid": "account-overview__asset-tab"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginBottom: 2
  }, /*#__PURE__*/_react.default.createElement(_assetList.default, {
    showTokensLinks: showTokensLinks ?? true,
    onClickAsset: onClickAsset,
    safeChains: safeChains
  }))), showDefi && /*#__PURE__*/_react.default.createElement(_tabs.Tab, {
    name: t('defi'),
    tabKey: _appState.AccountOverviewTabKey.DeFi,
    "data-testid": "account-overview__defi-tab"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_defiTab.default, {
    showTokensLinks: showTokensLinks ?? true,
    onClickAsset: onClickDeFi,
    safeChains: safeChains
  }))), showNfts && /*#__PURE__*/_react.default.createElement(_tabs.Tab, {
    name: t('nfts'),
    tabKey: _appState.AccountOverviewTabKey.Nfts,
    "data-testid": "account-overview__nfts-tab"
  }, /*#__PURE__*/_react.default.createElement(_nftsTab.default, null)), showActivity && /*#__PURE__*/_react.default.createElement(_tabs.Tab, {
    name: t('activity'),
    tabKey: _appState.AccountOverviewTabKey.Activity,
    "data-testid": "account-overview__activity-tab"
  }, showUnifiedTransactionList ? /*#__PURE__*/_react.default.createElement(_unifiedTransactionList.default, null) : /*#__PURE__*/_react.default.createElement(_transactionList.default, null)));
};
exports.AccountOverviewTabs = AccountOverviewTabs;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\account-overview\\account-overview-tabs.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-overview\\account-overview-unknown.tsx", {"../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","./account-overview-layout":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-overview\\account-overview-layout.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Caccount-overview%5Caccount-overview-unknown.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountOverviewUnknown = void 0;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../component-library");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _accountOverviewLayout = require("./account-overview-layout");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const AccountOverviewUnknown = props => {
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_accountOverviewLayout.AccountOverviewLayout, _extends({
    showTokens: false,
    showNfts: false,
    showDefi: false,
    showActivity: true
  }, props), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "account-overview-unknown__empty"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "account-overview-unknown__empty-text"
  }, /*#__PURE__*/_react.default.createElement("span", null, t('accountTypeNotSupported')))));
};
exports.AccountOverviewUnknown = AccountOverviewUnknown;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\account-overview\\account-overview-unknown.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-overview\\account-overview.tsx", {"../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","./account-overview-eth":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-overview\\account-overview-eth.tsx","./account-overview-non-evm":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-overview\\account-overview-non-evm.tsx","./account-overview-unknown":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-overview\\account-overview-unknown.tsx","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Caccount-overview%5Caccount-overview.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountOverview = AccountOverview;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _keyringApi = require("@metamask/keyring-api");
var _selectors = require("../../../selectors");
var _accountOverviewEth = require("./account-overview-eth");
var _accountOverviewUnknown = require("./account-overview-unknown");
var _accountOverviewNonEvm = require("./account-overview-non-evm");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function AccountOverview(props) {
  const account = (0, _reactRedux.useSelector)(_selectors.getSelectedInternalAccount);
  const renderAccountOverviewOption = () => {
    switch (account.type) {
      case _keyringApi.EthAccountType.Eoa:
      case _keyringApi.EthAccountType.Erc4337:
        return /*#__PURE__*/_react.default.createElement(_accountOverviewEth.AccountOverviewEth, props);
      case _keyringApi.BtcAccountType.P2pkh:
      case _keyringApi.BtcAccountType.P2sh:
      case _keyringApi.BtcAccountType.P2wpkh:
      case _keyringApi.BtcAccountType.P2tr:
      case _keyringApi.SolAccountType.DataAccount:
        return /*#__PURE__*/_react.default.createElement(_accountOverviewNonEvm.AccountOverviewNonEvm, props);
      default:
        return /*#__PURE__*/_react.default.createElement(_accountOverviewUnknown.AccountOverviewUnknown, props);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, renderAccountOverviewOption());
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\account-overview\\account-overview.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-overview\\index.js", {"./account-overview":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-overview\\account-overview.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Caccount-overview%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "AccountOverview", {
  enumerable: true,
  get: function () {
    return _accountOverview.AccountOverview;
  }
});
var _accountOverview = require("./account-overview");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\account-overview\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-picker\\account-picker.js", {"../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../../shared/modules/hexstring-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\hexstring-utils.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../app/preferred-avatar":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\preferred-avatar\\index.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Caccount-picker%5Caccount-picker.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountPicker = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _reactRedux = require("react-redux");
var _designSystemReact = require("@metamask/design-system-react");
var _hexstringUtils = require("../../../../shared/modules/hexstring-utils");
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _util = require("../../../helpers/utils/util");
var _trace = require("../../../../shared/lib/trace");
var _selectors = require("../../../selectors");
var _preferredAvatar = require("../../app/preferred-avatar");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const AccountMenuStyle = {
  height: 'auto'
};
const AccountPicker = ({
  address,
  name,
  onClick,
  disabled = false,
  showAddress = false,
  addressProps = {},
  labelProps = {},
  textProps = {},
  className = '',
  showAvatarAccount = true,
  ...props
}) => {
  AccountPicker.propTypes = {
    showAvatarAccount: _propTypes.default.bool
  };
  const shortenedAddress = address ? (0, _util.shortenAddress)((0, _hexstringUtils.toChecksumHexAddress)(address)) : '';
  const isMultichainAccountsState2Enabled = (0, _reactRedux.useSelector)(_selectors.getIsMultichainAccountsState2Enabled);
  const accountNameStyling = (0, _react.useMemo)(() => ({
    ...labelProps.style,
    fontWeight: isMultichainAccountsState2Enabled ? 500 : _designSystem.FontWeight.Medium
  }), [isMultichainAccountsState2Enabled, labelProps.style]);
  const accountNameFontVariant = (0, _react.useMemo)(() => isMultichainAccountsState2Enabled ? _designSystem.TextVariant.bodyMdMedium : _designSystem.TextVariant.bodyMdMedium, [isMultichainAccountsState2Enabled]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    alignItems: _designSystem.AlignItems.center,
    className: "w-full"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonBase, _extends({
    className: (0, _classnames.default)('multichain-account-picker', className),
    "data-testid": "account-menu-icon",
    onClick: () => {
      (0, _trace.trace)({
        name: _trace.TraceName.AccountList
      });
      onClick();
    },
    backgroundColor: _designSystem.BackgroundColor.transparent,
    borderRadius: _designSystem.BorderRadius.LG,
    ellipsis: true,
    textProps: {
      display: _designSystem.Display.Flex,
      alignItems: _designSystem.AlignItems.center,
      gap: 2,
      ...textProps
    },
    size: showAddress ? _componentLibrary.ButtonBaseSize.Lg : _componentLibrary.ButtonBaseSize.Sm,
    disabled: disabled,
    endIconName: _componentLibrary.IconName.ArrowDown,
    endIconProps: {
      color: _designSystem.IconColor.iconDefault,
      size: _designSystem.Size.SM
    }
  }, props, {
    gap: 1,
    style: AccountMenuStyle
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: showAvatarAccount ? _designSystem.FlexDirection.Row : _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.center,
    gap: showAvatarAccount ? 2 : 0,
    className: "min-w-0"
  }, showAvatarAccount ? /*#__PURE__*/_react.default.createElement(_preferredAvatar.PreferredAvatar, {
    address: address,
    size: showAddress ? _designSystemReact.AvatarAccountSize.Md : _designSystemReact.AvatarAccountSize.Xs
  }) : null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, _extends({
    as: "span",
    ellipsis: true,
    variant: accountNameFontVariant
  }, labelProps, {
    className: (0, _classnames.default)('multichain-account-picker__label w-full', labelProps.className ?? ''),
    style: accountNameStyling
  }), name, showAddress ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, _extends({
    color: _designSystem.TextColor.textAlternative,
    variant: _designSystem.TextVariant.bodySmMedium,
    ellipsis: true
  }, addressProps), shortenedAddress) : null))));
};
exports.AccountPicker = AccountPicker;
AccountPicker.propTypes = {
  /**
   * Account name
   */
  name: _propTypes.default.string.isRequired,
  /**
   * Account address, used for blockie or jazzicon
   */
  address: _propTypes.default.string.isRequired,
  /**
   * Represents if the account address should display
   */
  showAddress: _propTypes.default.bool,
  /**
   * Props to be added to the address element
   */
  addressProps: _propTypes.default.object,
  /**
   * Action to perform when the account picker is clicked
   */
  onClick: _propTypes.default.func.isRequired,
  /**
   * Represents if the AccountPicker should be actionable
   */
  disabled: _propTypes.default.bool,
  /**
   * Represents if the AccountPicker should take full width
   */
  block: _propTypes.default.bool,
  /**
   * Props to be added to the label element
   */
  labelProps: _propTypes.default.object,
  /**
   * Props to be added to the text element
   */
  textProps: _propTypes.default.object,
  /**
   * Additional className to be added to the AccountPicker
   */
  className: _propTypes.default.string
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\account-picker\\account-picker.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-picker\\index.js", {"./account-picker":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-picker\\account-picker.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Caccount-picker%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "AccountPicker", {
  enumerable: true,
  get: function () {
    return _accountPicker.AccountPicker;
  }
});
var _accountPicker = require("./account-picker");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\account-picker\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\activity-list-item\\activity-list-item.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cactivity-list-item%5Cactivity-list-item.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActivityListItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const ActivityListItem = ({
  topContent,
  icon,
  title,
  subtitle,
  midContent,
  children,
  rightContent,
  onClick,
  className,
  'data-testid': dataTestId
}) => {
  const primaryClassName = (0, _classnames.default)('activity-list-item', className, {
    'activity-list-item--single-content-row': !(subtitle || children)
  });
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    tabIndex: 0,
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    className: primaryClassName,
    onClick: onClick,
    onKeyPress: event => {
      if (event.key === 'Enter') {
        onClick();
      }
    },
    "data-testid": dataTestId,
    paddingInline: 4,
    paddingTop: 3,
    paddingBottom: 3,
    display: _designSystem.Display.Flex,
    width: _designSystem.BlockSize.Full,
    flexWrap: _designSystem.FlexWrap.Wrap,
    gap: 4
  }, topContent && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: _designSystem.TextColor.textDefault,
    display: _designSystem.Display.Flex,
    width: _designSystem.BlockSize.Full
  }, topContent), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    width: _designSystem.BlockSize.Full,
    flexDirection: _designSystem.FlexDirection.Row,
    gap: 4
  }, icon && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.InlineFlex
  }, icon), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.InlineFlex,
    width: _designSystem.BlockSize.Full,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    className: "activity-list-item__content-container"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.InlineFlex,
    flexDirection: _designSystem.FlexDirection.Column,
    className: "activity-list-item__detail-container",
    minWidth: "0"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    ellipsis: true,
    textAlign: _designSystem.TextAlign.Left,
    variant: _designSystem.TextVariant.bodyMdMedium,
    fontWeight: _designSystem.FontWeight.Medium,
    "data-testid": "activity-list-item-action"
  }, title)), subtitle && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "div",
    ellipsis: true,
    textAlign: _designSystem.TextAlign.Left,
    variant: _designSystem.TextVariant.bodySmMedium
  }, subtitle), children && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "activity-list-item__children"
  }, children)), midContent && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.InlineFlex,
    className: "activity-list-item__mid-content"
  }, midContent), rightContent && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.InlineFlex,
    height: _designSystem.BlockSize.Min,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.flexEnd,
    className: "activity-list-item__right-content"
  }, rightContent))));
};
exports.ActivityListItem = ActivityListItem;
ActivityListItem.propTypes = {
  /**
   * Top content for the activity
   */
  topContent: _propTypes.default.node,
  /**
   * Icon which represents the activity
   */
  icon: _propTypes.default.node,
  /**
   * Title text
   */
  title: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.node]),
  /**
   * Additional text detail
   */
  subtitle: _propTypes.default.node,
  /**
   * Middle content
   */
  midContent: _propTypes.default.node,
  /**
   * Additional variable contents
   */
  children: _propTypes.default.node,
  /**
   * Right-most content
   */
  rightContent: _propTypes.default.node,
  /**
   * Executes upon click of the activity
   */
  onClick: _propTypes.default.func,
  /**
   * Additional classname for this component
   */
  className: _propTypes.default.string,
  /**
   * Test ID for this component
   */
  'data-testid': _propTypes.default.string
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\activity-list-item\\activity-list-item.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\activity-list-item\\index.js", {"./activity-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\activity-list-item\\activity-list-item.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cactivity-list-item%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ActivityListItem", {
  enumerable: true,
  get: function () {
    return _activityListItem.ActivityListItem;
  }
});
var _activityListItem = require("./activity-list-item");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\activity-list-item\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\address-copy-button\\address-copy-button.js", {"../../../../app/scripts/lib/multichain/address":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\multichain\\address.ts","../../../../shared/constants/time":"D:\\code\\v\\metamask-extension\\shared\\constants\\time.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../hooks/useCopyToClipboard":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useCopyToClipboard.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/tooltip/tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\tooltip.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Caddress-copy-button%5Caddress-copy-button.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _useCopyToClipboard = require("../../../hooks/useCopyToClipboard");
var _util = require("../../../helpers/utils/util");
var _tooltip = _interopRequireDefault(require("../../ui/tooltip/tooltip"));
var _useI18nContext = require("../../../hooks/useI18nContext");
var _time = require("../../../../shared/constants/time");
var _address = require("../../../../app/scripts/lib/multichain/address");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

function AddressCopyButton({
  address,
  shorten = false,
  wrap = false
}) {
  const checksummedAddress = (0, _address.normalizeSafeAddress)(address);
  const displayAddress = shorten ? (0, _util.shortenAddress)(checksummedAddress) : checksummedAddress;
  const [copied, handleCopy] = (0, _useCopyToClipboard.useCopyToClipboard)(_time.MINUTE);
  const t = (0, _useI18nContext.useI18nContext)();
  const tooltipText = copied ? t('copiedExclamation') : t('copyToClipboard');
  const tooltipTitle = tooltipText;
  const onClickCallback = (0, _react.useCallback)(() => {
    handleCopy(checksummedAddress);
  }, [handleCopy, checksummedAddress]);
  return /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    position: "bottom",
    title: tooltipTitle
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonBase, {
    backgroundColor: _designSystem.BackgroundColor.primaryMuted,
    onClick: onClickCallback,
    paddingRight: 4,
    paddingLeft: 4,
    size: _designSystem.Size.SM,
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.primaryDefault,
    endIconName: copied ? _componentLibrary.IconName.CopySuccess : _componentLibrary.IconName.Copy,
    className: (0, _classnames.default)('multichain-address-copy-button', {
      'multichain-address-copy-button__address--wrap': wrap
    }),
    borderRadius: _designSystem.BorderRadius.pill,
    alignItems: _designSystem.AlignItems.center,
    "data-testid": "address-copy-button-text"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex
  }, displayAddress)));
}
AddressCopyButton.propTypes = {
  /**
   * Address to be copied
   */
  address: _propTypes.default.string.isRequired,
  /**
   * Represents if the address should be shortened
   */
  shorten: _propTypes.default.bool,
  /**
   * Represents if the element should wrap to multiple lines
   */
  wrap: _propTypes.default.bool
};
var _default = exports.default = /*#__PURE__*/_react.default.memo(AddressCopyButton);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\address-copy-button\\address-copy-button.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\address-copy-button\\index.js", {"./address-copy-button":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\address-copy-button\\address-copy-button.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Caddress-copy-button%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "AddressCopyButton", {
  enumerable: true,
  get: function () {
    return _addressCopyButton.default;
  }
});
var _addressCopyButton = _interopRequireDefault(require("./address-copy-button"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\address-copy-button\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\address-list-item\\address-list-item.tsx", {"../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../app/preferred-avatar":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\preferred-avatar\\index.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/confusable":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\confusable\\index.js","../../ui/tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Caddress-list-item%5Caddress-list-item.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddressListItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _confusable = _interopRequireDefault(require("../../ui/confusable"));
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _preferredAvatar = require("../../app/preferred-avatar");
var _util = require("../../../helpers/utils/util");
var _tooltip = _interopRequireDefault(require("../../ui/tooltip"));
var _i18n = require("../../../contexts/i18n");
var _networks = require("../../../../shared/modules/selectors/networks");
var _multichain = require("../../../selectors/multichain");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AddressListItem = ({
  address,
  label,
  chainId,
  useConfusable = false,
  isDuplicate = false,
  onClick
}) => {
  var _allNetworks;
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const allNetworks = (0, _reactRedux.useSelector)(_networks.getNetworkConfigurationsByChainId);
  let displayName = (0, _util.shortenAddress)(address);
  if (label) {
    displayName = label;
    if (useConfusable) {
      displayName = /*#__PURE__*/_react.default.createElement(_confusable.default, {
        input: label
      });
    }
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    padding: 4,
    as: "button",
    onClick: e => {
      e.stopPropagation();
      onClick();
    },
    width: _designSystem.BlockSize.Full,
    backgroundColor: _designSystem.BackgroundColor.transparent,
    className: "address-list-item gap-4",
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.BadgeWrapper, {
    badge: /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
      size: _componentLibrary.AvatarNetworkSize.Xs,
      name: allNetworks === null || allNetworks === void 0 || (_allNetworks = allNetworks[chainId]) === null || _allNetworks === void 0 ? void 0 : _allNetworks.name,
      src: (0, _multichain.getImageForChainId)(chainId),
      backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
      borderWidth: 2
    })
  }, /*#__PURE__*/_react.default.createElement(_preferredAvatar.PreferredAvatar, {
    address: address,
    className: "flex"
  }))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    style: {
      overflow: 'hidden'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    padding: 0,
    width: _designSystem.BlockSize.Full,
    textAlign: _designSystem.TextAlign.Left,
    className: "address-list-item__label",
    "data-testid": "address-list-item-label",
    style: {
      overflow: 'hidden'
    },
    ellipsis: true
  }, displayName), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative,
    ellipsis: true,
    "data-testid": "address-list-item-address",
    as: "div",
    display: _designSystem.Display.Flex
  }, /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    title: address,
    position: "bottom"
  }, (0, _util.shortenAddress)(address)))), isDuplicate && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "address-list-item__duplicate-contact-warning-icon"
  }, /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    title: t('duplicateContactTooltip'),
    position: "top"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.Danger,
    color: _designSystem.IconColor.warningDefault
  }))));
};
exports.AddressListItem = AddressListItem;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\address-list-item\\address-list-item.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\address-list-item\\index.ts", {"./address-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\address-list-item\\address-list-item.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Caddress-list-item%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "AddressListItem", {
  enumerable: true,
  get: function () {
    return _addressListItem.AddressListItem;
  }
});
var _addressListItem = require("./address-list-item");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\address-list-item\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\app-header\\app-header-container.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Capp-header%5Capp-header-container.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppHeaderContainer = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const AppHeaderContainer = ({
  isUnlocked,
  popupStatus,
  children
}) => {
  const backgroundColor = !isUnlocked || popupStatus ? _designSystem.BackgroundColor.backgroundDefault : _designSystem.BackgroundColor.backgroundAlternative;
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    className: (0, _classnames.default)('multichain-app-header', {
      'multichain-app-header-shadow': popupStatus
    }),
    alignItems: _designSystem.AlignItems.center,
    width: _designSystem.BlockSize.Full,
    backgroundColor: backgroundColor
  }, children);
};
exports.AppHeaderContainer = AppHeaderContainer;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\app-header\\app-header-container.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\app-header\\app-header-locked-content.tsx", {"../../../../shared/modules/network.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\network.utils.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/metafox-logo":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\metafox-logo\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Capp-header%5Capp-header-locked-content.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppHeaderLockedContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _metafoxLogo = _interopRequireDefault(require("../../ui/metafox-logo"));
var _componentLibrary = require("../../component-library");
var _routes = require("../../../helpers/constants/routes");
var _selectors = require("../../../selectors");
var _network = require("../../../../shared/modules/network.utils");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const AppHeaderLockedContent = ({
  currentNetwork,
  networkOpenCallback
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const testNetworkBackgroundColor = (0, _reactRedux.useSelector)(_selectors.getTestNetworkBackgroundColor);
  const networkIconSrc = (0, _network.getNetworkIcon)(currentNetwork);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_componentLibrary.PickerNetwork, {
    avatarNetworkProps: {
      backgroundColor: testNetworkBackgroundColor,
      role: 'img',
      name: currentNetwork.name
    },
    "aria-label": `${t('networkMenu')} ${currentNetwork.name}`,
    label: currentNetwork.name,
    src: networkIconSrc,
    onClick: e => {
      e.stopPropagation();
      e.preventDefault();
      networkOpenCallback();
    },
    className: "multichain-app-header__contents__network-picker",
    "data-testid": "network-display"
  })), /*#__PURE__*/_react.default.createElement("div", null), /*#__PURE__*/_react.default.createElement(_metafoxLogo.default, {
    unsetIconHeight: true,
    onClick: async () => {
      history.push(_routes.DEFAULT_ROUTE);
    }
  }));
};
exports.AppHeaderLockedContent = AppHeaderLockedContent;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\app-header\\app-header-locked-content.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\app-header\\app-header-unlocked-content.tsx", {"../../../../app/scripts/lib/multichain/address":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\multichain\\address.ts","../../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../ducks/app/app":"D:\\code\\v\\metamask-extension\\ui\\ducks\\app\\app.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../hooks/useCopyToClipboard":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useCopyToClipboard.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../app/account-icon-tour/account-icon-tour":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\account-icon-tour\\account-icon-tour.tsx","../../app/connected-status-indicator":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\connected-status-indicator\\index.js","../../app/modals/visit-support-data-consent-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\modals\\visit-support-data-consent-modal\\index.ts","../../app/preferred-avatar":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\preferred-avatar\\index.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../account-picker":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-picker\\index.js","../global-menu":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\global-menu\\index.ts","../notifications-tag-counter":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notifications-tag-counter\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js","webextension-polyfill":"D:\\code\\v\\metamask-extension\\node_modules\\webextension-polyfill\\dist\\browser-polyfill.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Capp-header%5Capp-header-unlocked-content.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppHeaderUnlockedContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _webextensionPolyfill = _interopRequireDefault(require("webextension-polyfill"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../component-library");
var _metametrics = require("../../../../shared/constants/metametrics");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _actions = require("../../../store/actions");
var _connectedStatusIndicator = _interopRequireDefault(require("../../app/connected-status-indicator"));
var _accountPicker = require("../account-picker");
var _globalMenu = require("../global-menu");
var _selectors = require("../../../selectors");
var _util = require("../../../../app/scripts/lib/util");
var _address = require("../../../../app/scripts/lib/multichain/address");
var _util2 = require("../../../helpers/utils/util");
var _app = require("../../../../shared/constants/app");
var _metametrics2 = require("../../../contexts/metametrics");
var _useCopyToClipboard = require("../../../hooks/useCopyToClipboard");
var _notificationsTagCounter = require("../notifications-tag-counter");
var _routes = require("../../../helpers/constants/routes");
var _visitSupportDataConsentModal = _interopRequireDefault(require("../../app/modals/visit-support-data-consent-modal"));
var _app2 = require("../../../ducks/app/app");
var _preferredAvatar = require("../../app/preferred-avatar");
var _accountIconTour = require("../../app/account-icon-tour/account-icon-tour");
var _accountTree = require("../../../selectors/multichain-accounts/account-tree");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

const AppHeaderUnlockedContent = ({
  disableAccountPicker,
  menuRef
}) => {
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const t = (0, _useI18nContext.useI18nContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const origin = (0, _reactRedux.useSelector)(_selectors.getOriginOfCurrentTab);
  const [accountOptionsMenuOpen, setAccountOptionsMenuOpen] = (0, _react.useState)(false);
  const tourAnchorRef = (0, _react.useRef)(null);
  const isMultichainAccountsState2Enabled = (0, _reactRedux.useSelector)(_selectors.getIsMultichainAccountsState2Enabled);
  const selectedMultichainAccountId = (0, _reactRedux.useSelector)(_accountTree.getSelectedAccountGroup);
  const selectedMultichainAccount = (0, _reactRedux.useSelector)(state => (0, _accountTree.getMultichainAccountGroupById)(state, selectedMultichainAccountId));
  const numberOfAccountsInGroup = (0, _reactRedux.useSelector)(state => (0, _accountTree.getNetworkAddressCount)(state, selectedMultichainAccountId));

  // Used for account picker
  const internalAccount = (0, _reactRedux.useSelector)(_selectors.getSelectedInternalAccount);
  const shortenedAddress = internalAccount && (0, _util2.shortenAddress)((0, _address.normalizeSafeAddress)(internalAccount.address));
  const accountName = isMultichainAccountsState2Enabled ? selectedMultichainAccount.metadata.name : internalAccount.metadata.name;

  // During onboarding there is no selected internal account
  const currentAddress = internalAccount === null || internalAccount === void 0 ? void 0 : internalAccount.address;

  // Passing non-evm address to checksum function will throw an error
  const normalizedCurrentAddress = (0, _address.normalizeSafeAddress)(currentAddress);
  const [copied, handleCopy, resetCopyState] = (0, _useCopyToClipboard.useCopyToClipboard)(2000, {
    expireClipboard: false
  });
  const showSupportDataConsentModal = (0, _reactRedux.useSelector)(_app2.getShowSupportDataConsentModal);

  // Reset copy state when a switching accounts
  (0, _react.useEffect)(() => {
    if (normalizedCurrentAddress) {
      resetCopyState();
    }
  }, [normalizedCurrentAddress, resetCopyState]);
  (0, _react.useEffect)(() => {
    if (copied) {
      dispatch((0, _app2.setShowCopyAddressToast)(true));
    } else {
      dispatch((0, _app2.setShowCopyAddressToast)(false));
    }
  }, [copied, dispatch]);
  const showConnectedStatus = (0, _util.getEnvironmentType)() === _app.ENVIRONMENT_TYPE_POPUP && origin && origin !== _webextensionPolyfill.default.runtime.id;
  const handleMainMenuToggle = () => {
    setAccountOptionsMenuOpen(previous => {
      const isMenuOpen = !previous;
      if (isMenuOpen) {
        trackEvent({
          event: _metametrics.MetaMetricsEventName.NavMainMenuOpened,
          category: _metametrics.MetaMetricsEventCategory.Navigation,
          properties: {
            location: 'Home'
          }
        });
      }
      return isMenuOpen;
    });
  };
  const handleConnectionsRoute = () => {
    history.push(`${_routes.REVIEW_PERMISSIONS}/${encodeURIComponent(origin)}`);
  };
  const handleCopyClick = (0, _react.useCallback)(() => {
    handleCopy(normalizedCurrentAddress);
  }, [handleCopy, normalizedCurrentAddress]);
  const CopyButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonBase, {
    className: "multichain-app-header__address-copy-button",
    onClick: handleCopyClick,
    size: _componentLibrary.ButtonBaseSize.Sm,
    backgroundColor: _designSystem.BackgroundColor.transparent,
    borderRadius: _designSystem.BorderRadius.LG,
    endIconName: copied ? _componentLibrary.IconName.CopySuccess : _componentLibrary.IconName.Copy,
    endIconProps: {
      color: _designSystem.IconColor.iconAlternative,
      size: _componentLibrary.IconSize.Sm
    },
    paddingLeft: 2,
    paddingRight: 2,
    ellipsis: true,
    textProps: {
      display: _designSystem.Display.Flex,
      gap: 2,
      variant: _designSystem.TextVariant.bodyMdMedium
    },
    style: {
      height: 'auto'
    } // ButtonBase doesn't have auto size
    ,
    "data-testid": "app-header-copy-button"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textAlternative,
    variant: _designSystem.TextVariant.bodySmMedium,
    ellipsis: true,
    as: "span"
  }, shortenedAddress)), [copied, handleCopyClick, shortenedAddress]);
  const multichainAccountAppContent = (0, _react.useMemo)(() => {
    const networksLabel = numberOfAccountsInGroup === 1 ? t('networkAddress') : t('networkAddresses', [numberOfAccountsInGroup]);
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      style: {
        overflow: 'hidden'
      }
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      as: "div",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      alignItems: _designSystem.AlignItems.flexStart,
      ellipsis: true
    }, /*#__PURE__*/_react.default.createElement(_accountPicker.AccountPicker, {
      address: '' // No address shown in multichain mode
      ,
      name: accountName,
      showAvatarAccount: false,
      onClick: () => {
        history.push(_routes.ACCOUNT_LIST_PAGE_ROUTE);
        trackEvent({
          event: _metametrics.MetaMetricsEventName.NavAccountMenuOpened,
          category: _metametrics.MetaMetricsEventCategory.Navigation,
          properties: {
            location: 'Home'
          }
        });
      },
      disabled: disableAccountPicker,
      paddingLeft: 2,
      paddingRight: 2
    }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !isMultichainAccountsState2Enabled && CopyButton)), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Link, {
      to: `${_routes.MULTICHAIN_ACCOUNT_ADDRESS_LIST_PAGE_ROUTE}/${encodeURIComponent(selectedMultichainAccountId)}`,
      "data-testid": "networks-subtitle-test-id"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      className: "networks-subtitle",
      color: _designSystem.TextColor.textAlternative,
      variant: _designSystem.TextVariant.bodyXsMedium,
      paddingInline: 2
    }, networksLabel)));
  }, [CopyButton, accountName, disableAccountPicker, selectedMultichainAccountId, history, isMultichainAccountsState2Enabled, numberOfAccountsInGroup, t, trackEvent]);

  // TODO: [Multichain-Accounts-MUL-849] Delete this method once multichain accounts is released
  const AppContent = (0, _react.useMemo)(() => {
    const handleAccountMenuClick = () => {
      if (isMultichainAccountsState2Enabled) {
        history.push(_routes.ACCOUNT_LIST_PAGE_ROUTE);
      } else {
        dispatch((0, _actions.toggleAccountMenu)());
      }
    };
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
      ref: tourAnchorRef,
      className: "flex"
    }, /*#__PURE__*/_react.default.createElement(_preferredAvatar.PreferredAvatar, {
      address: internalAccount.address
    })), internalAccount && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      as: "div",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      alignItems: _designSystem.AlignItems.flexStart,
      ellipsis: true
    }, /*#__PURE__*/_react.default.createElement(_accountPicker.AccountPicker, {
      address: internalAccount.address,
      name: accountName,
      showAvatarAccount: false,
      onClick: () => {
        handleAccountMenuClick();
        trackEvent({
          event: _metametrics.MetaMetricsEventName.NavAccountMenuOpened,
          category: _metametrics.MetaMetricsEventCategory.Navigation,
          properties: {
            location: 'Home'
          }
        });
      },
      disabled: disableAccountPicker,
      paddingLeft: 2,
      paddingRight: 2
    }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, CopyButton)));
  }, [internalAccount, accountName, disableAccountPicker, CopyButton, isMultichainAccountsState2Enabled, history, dispatch, trackEvent]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    alignItems: _designSystem.AlignItems.center,
    gap: 2,
    className: "min-w-0"
  }, isMultichainAccountsState2Enabled ? multichainAccountAppContent : AppContent), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.flexEnd,
    style: {
      marginLeft: 'auto'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    gap: 2
  }, showConnectedStatus && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    ref: menuRef,
    "data-testid": "connection-menu",
    margin: "auto"
  }, /*#__PURE__*/_react.default.createElement(_connectedStatusIndicator.default, {
    onClick: () => handleConnectionsRoute()
  })), ' ', /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    ref: menuRef,
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.flexEnd,
    width: _designSystem.BlockSize.Full,
    style: {
      position: 'relative'
    }
  }, !accountOptionsMenuOpen && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    onClick: handleMainMenuToggle
  }, /*#__PURE__*/_react.default.createElement(_notificationsTagCounter.NotificationsTagCounter, {
    noLabel: true
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    iconName: _componentLibrary.IconName.Menu,
    "data-testid": "account-options-menu-button",
    ariaLabel: t('accountOptions'),
    onClick: handleMainMenuToggle,
    size: _componentLibrary.ButtonIconSize.Lg
  }))), /*#__PURE__*/_react.default.createElement(_globalMenu.GlobalMenu, {
    anchorElement: menuRef.current,
    isOpen: accountOptionsMenuOpen,
    closeMenu: () => {
      setAccountOptionsMenuOpen(false);
    }
  }), /*#__PURE__*/_react.default.createElement(_visitSupportDataConsentModal.default, {
    isOpen: showSupportDataConsentModal,
    onClose: () => dispatch((0, _actions.setShowSupportDataConsentModal)(false))
  })), !isMultichainAccountsState2Enabled && /*#__PURE__*/_react.default.createElement(_accountIconTour.AccountIconTour, {
    anchorElement: tourAnchorRef.current
  }));
};
exports.AppHeaderUnlockedContent = AppHeaderUnlockedContent;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\app-header\\app-header-unlocked-content.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\app-header\\app-header.js", {"../../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/modules/network.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\network.utils.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../ducks/send":"D:\\code\\v\\metamask-extension\\ui\\ducks\\send\\index.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/multichain/networks":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain\\networks.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","./app-header-container":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\app-header\\app-header-container.tsx","./app-header-locked-content":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\app-header\\app-header-locked-content.tsx","./app-header-unlocked-content":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\app-header\\app-header-unlocked-content.tsx","./multichain-meta-fox-logo":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\app-header\\multichain-meta-fox-logo.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Capp-header%5Capp-header.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppHeader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _metametrics = require("../../../contexts/metametrics");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _routes = require("../../../helpers/constants/routes");
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../component-library");
var _selectors = require("../../../selectors");
var _actions = require("../../../store/actions");
var _util = require("../../../../app/scripts/lib/util");
var _app = require("../../../../shared/constants/app");
var _metamask = require("../../../ducks/metamask/metamask");
var _send = require("../../../ducks/send");
var _networks = require("../../../selectors/multichain/networks");
var _network = require("../../../../shared/modules/network.utils");
var _multichainMetaFoxLogo = require("./multichain-meta-fox-logo");
var _appHeaderContainer = require("./app-header-container");
var _appHeaderUnlockedContent = require("./app-header-unlocked-content");
var _appHeaderLockedContent = require("./app-header-locked-content");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); } // TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths
const AppHeader = ({
  location
}) => {
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const menuRef = (0, _react.useRef)(null);
  const isUnlocked = (0, _reactRedux.useSelector)(_metamask.getIsUnlocked);
  const multichainNetwork = (0, _reactRedux.useSelector)(_networks.getSelectedMultichainNetworkConfiguration);
  const {
    chainId,
    isEvm
  } = multichainNetwork;
  const networkIconSrc = (0, _network.getNetworkIcon)(chainId, isEvm);
  const dispatch = (0, _reactRedux.useDispatch)();
  const popupStatus = (0, _util.getEnvironmentType)() === _app.ENVIRONMENT_TYPE_POPUP;

  // Disable the network and account pickers if the user is in
  // a critical flow
  const sendStage = (0, _reactRedux.useSelector)(_send.getSendStage);
  const isTransactionEditPage = [_send.SEND_STAGES.EDIT, _send.SEND_STAGES.DRAFT, _send.SEND_STAGES.ADD_RECIPIENT].includes(sendStage);
  const isConfirmationPage = Boolean((0, _reactRouterDom.matchPath)(location.pathname, {
    path: _routes.CONFIRM_TRANSACTION_ROUTE,
    exact: false
  }));
  const isSwapsPage = Boolean((0, _reactRouterDom.matchPath)(location.pathname, {
    path: _routes.SWAPS_ROUTE,
    exact: false
  }));
  const unapprovedTransactions = (0, _reactRedux.useSelector)(_selectors.getUnapprovedTransactions);
  const hasUnapprovedTransactions = Object.keys(unapprovedTransactions).length > 0;
  const disableAccountPicker = isConfirmationPage || isSwapsPage;
  const disableNetworkPicker = isSwapsPage || isTransactionEditPage || isConfirmationPage || hasUnapprovedTransactions;

  // Callback for network dropdown
  const networkOpenCallback = (0, _react.useCallback)(() => {
    dispatch((0, _actions.toggleNetworkMenu)());
    trackEvent({
      event: _metametrics2.MetaMetricsEventName.NavNetworkMenuOpened,
      category: _metametrics2.MetaMetricsEventCategory.Navigation,
      properties: {
        location: 'App header',
        chain_id: chainId
      }
    });
  }, [chainId, dispatch, trackEvent]);
  const unlockedStyling = {
    alignItems: _designSystem.AlignItems.center,
    width: _designSystem.BlockSize.Full,
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    padding: 2,
    paddingLeft: 2,
    paddingRight: 4,
    gap: 2
  };
  const lockStyling = {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    width: _designSystem.BlockSize.Full,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    padding: 2,
    gap: 2
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isUnlocked && !popupStatus ? /*#__PURE__*/_react.default.createElement(_multichainMetaFoxLogo.MultichainMetaFoxLogo, null) : null, /*#__PURE__*/_react.default.createElement(_appHeaderContainer.AppHeaderContainer, {
    isUnlocked: isUnlocked,
    popupStatus: popupStatus
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, _extends({
    className: (0, _classnames.default)(isUnlocked ? 'multichain-app-header__contents flex' : 'multichain-app-header__lock-contents')
  }, isUnlocked ? unlockedStyling : lockStyling), isUnlocked ? /*#__PURE__*/_react.default.createElement(_appHeaderUnlockedContent.AppHeaderUnlockedContent, {
    popupStatus: popupStatus,
    currentNetwork: multichainNetwork,
    networkIconSrc: networkIconSrc,
    networkOpenCallback: networkOpenCallback,
    disableNetworkPicker: disableNetworkPicker,
    disableAccountPicker: disableAccountPicker,
    menuRef: menuRef
  }) : /*#__PURE__*/_react.default.createElement(_appHeaderLockedContent.AppHeaderLockedContent, {
    currentNetwork: multichainNetwork,
    networkIconSrc: networkIconSrc,
    networkOpenCallback: networkOpenCallback
  })))));
};
exports.AppHeader = AppHeader;
AppHeader.propTypes = {
  /**
   * The location object for the application
   */
  location: _propTypes.default.object
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\app-header\\app-header.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\app-header\\index.js", {"./app-header":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\app-header\\app-header.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Capp-header%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "AppHeader", {
  enumerable: true,
  get: function () {
    return _appHeader.AppHeader;
  }
});
var _appHeader = require("./app-header");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\app-header\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\app-header\\multichain-meta-fox-logo.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../hooks/useTheme":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTheme.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/metafox-logo":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\metafox-logo\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Capp-header%5Cmultichain-meta-fox-logo.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultichainMetaFoxLogo = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _routes = require("../../../helpers/constants/routes");
var _useTheme = require("../../../hooks/useTheme");
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../component-library");
var _metafoxLogo = _interopRequireDefault(require("../../ui/metafox-logo"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MultichainMetaFoxLogo = () => {
  const history = (0, _reactRouterDom.useHistory)();
  const theme = (0, _useTheme.useTheme)();
  const onClick = (0, _react.useCallback)(async () => {
    history.push(_routes.DEFAULT_ROUTE);
  }, [history]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: [_designSystem.Display.None, _designSystem.Display.Flex],
    alignItems: _designSystem.AlignItems.center,
    margin: 2,
    className: "multichain-app-header-logo",
    "data-testid": "app-header-logo",
    justifyContent: _designSystem.JustifyContent.center
  }, /*#__PURE__*/_react.default.createElement(_metafoxLogo.default, {
    unsetIconHeight: true,
    onClick: onClick,
    theme: theme
  }));
};
exports.MultichainMetaFoxLogo = MultichainMetaFoxLogo;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\app-header\\multichain-meta-fox-logo.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\asset-balance\\asset-balance-text.tsx", {"../../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../../helpers/constants/common":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\common.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useCurrencyDisplay":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useCurrencyDisplay.js","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../hooks/useTokenFiatAmount":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTokenFiatAmount.js","../../../../hooks/useTokenTracker":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTokenTracker.js","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../app/user-preferenced-currency-display":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\user-preferenced-currency-display\\index.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../ui/currency-display":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\currency-display\\index.js","../utils":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\utils.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Casset-picker-amount%5Casset-balance%5Casset-balance-text.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetBalanceText = AssetBalanceText;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _componentLibrary = require("../../../component-library");
var _userPreferencedCurrencyDisplay = _interopRequireDefault(require("../../../app/user-preferenced-currency-display"));
var _common = require("../../../../helpers/constants/common");
var _selectors = require("../../../../selectors");
var _metamask = require("../../../../ducks/metamask/metamask");
var _transaction = require("../../../../../shared/constants/transaction");
var _designSystem = require("../../../../helpers/constants/design-system");
var _currencyDisplay = _interopRequireDefault(require("../../../ui/currency-display"));
var _useTokenTracker = require("../../../../hooks/useTokenTracker");
var _useCurrencyDisplay = require("../../../../hooks/useCurrencyDisplay");
var _useTokenFiatAmount = require("../../../../hooks/useTokenFiatAmount");
var _utils = require("../utils");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _conversion = require("../../../../../shared/modules/conversion.utils");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function AssetBalanceText({
  asset,
  balanceColor,
  error
}) {
  var _asset$details, _tokensWithBalances$, _asset$details2, _asset$details3;
  const t = (0, _useI18nContext.useI18nContext)();
  const secondaryCurrency = (0, _reactRedux.useSelector)(_metamask.getCurrentCurrency);
  const isFiatPrimary = (0, _reactRedux.useSelector)(_utils.getIsFiatPrimary);
  const {
    tokensWithBalances
  } = (0, _useTokenTracker.useTokenTracker)({
    tokens: (_asset$details = asset.details) !== null && _asset$details !== void 0 && _asset$details.address && !asset.balance ? [{
      address: asset.details.address
    }] : [],
    address: undefined
  });
  const balanceString = (0, _conversion.hexToDecimal)(asset.balance) || ((_tokensWithBalances$ = tokensWithBalances[0]) === null || _tokensWithBalances$ === void 0 ? void 0 : _tokensWithBalances$.string);
  const showFixedBalanceString = balanceString !== null && balanceString !== void 0 && balanceString.includes('.') ? balanceString.slice(0, balanceString.indexOf('.') + 5) // Include 4 digits after the decimal
  : balanceString;
  const balanceValue = (0, _reactRedux.useSelector)(_selectors.getSelectedAccountCachedBalance);
  const nativeTokenFiatBalance = (0, _useCurrencyDisplay.useCurrencyDisplay)(balanceValue, {
    numberOfDecimals: 2,
    currency: secondaryCurrency
  })[1].value;
  const erc20TokenFiatBalance = (0, _useTokenFiatAmount.useTokenFiatAmount)((_asset$details2 = asset.details) === null || _asset$details2 === void 0 ? void 0 : _asset$details2.address, balanceString, undefined,
  // if balance is zero, conversion rate will not be available so we just assume ~0 we can't use 0 because it will set off an undefined guard
  Number(balanceString) === 0 ? {
    exchangeRate: Number.MIN_VALUE
  } : undefined, true);
  const formattedFiat = asset.type === _transaction.AssetType.native ? nativeTokenFiatBalance : erc20TokenFiatBalance;
  const commonProps = {
    hideLabel: true,
    textProps: {
      color: balanceColor,
      variant: _designSystem.TextVariant.bodySm
    },
    suffixProps: {
      color: balanceColor,
      variant: _designSystem.TextVariant.bodySm
    }
  };
  const errorText = error ? `. ${t(error)}` : '';
  if (asset.type === _transaction.AssetType.NFT) {
    const numberOfTokens = (0, _conversion.hexToDecimal)(asset.balance || '0x0');
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, _extends({}, commonProps.textProps, {
      "data-testid": "asset-balance-nft-display"
    }), `${t(numberOfTokens === '1' ? 'assetSingleNFTBalance' : 'assetMultipleNFTsBalance', [numberOfTokens])}${errorText}`);
  }
  if (isFiatPrimary) {
    return /*#__PURE__*/_react.default.createElement(_currencyDisplay.default, _extends({}, commonProps, {
      currency: secondaryCurrency,
      numberOfDecimals: 2,
      displayValue: `${formattedFiat}${errorText}`
    }));
  }
  if (asset.type === _transaction.AssetType.native) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_userPreferencedCurrencyDisplay.default, _extends({}, commonProps, {
      value: asset.balance,
      type: _common.PRIMARY
    })), errorText ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodySm,
      color: _designSystem.TextColor.errorDefault,
      "data-testid": "send-page-amount-error"
    }, errorText) : null);
  }

  // catch-all for non-natives; they should all have addresses
  if ((_asset$details3 = asset.details) !== null && _asset$details3 !== void 0 && _asset$details3.address) {
    return /*#__PURE__*/_react.default.createElement(_userPreferencedCurrencyDisplay.default, _extends({}, commonProps, {
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
      // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
      displayValue: `${showFixedBalanceString || ''}${errorText}`
    }));
  }

  // this should never happen
  return null;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\asset-picker-amount\\asset-balance\\asset-balance-text.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\asset-balance\\asset-balance.tsx", {"../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","./asset-balance-text":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\asset-balance\\asset-balance-text.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Casset-picker-amount%5Casset-balance%5Casset-balance.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetBalance = AssetBalance;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../../component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _assetBalanceText = require("./asset-balance-text");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function AssetBalance({
  asset,
  error
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  const balanceColor = error ? _designSystem.TextColor.errorDefault : _designSystem.TextColor.textAlternative;
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "asset-picker-amount__balance",
    display: _designSystem.Display.Flex
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: balanceColor,
    marginRight: 1,
    variant: _designSystem.TextVariant.bodySm
  }, t('balance'), ":"), /*#__PURE__*/_react.default.createElement(_assetBalanceText.AssetBalanceText, {
    asset: asset,
    balanceColor: balanceColor,
    error: error
  }));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\asset-picker-amount\\asset-balance\\asset-balance.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\asset-picker-amount.tsx", {"../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../ducks/bridge/actions":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\actions.ts","../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../ducks/send":"D:\\code\\v\\metamask-extension\\ui\\ducks\\send\\index.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useGetAssetImageUrl":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useGetAssetImageUrl.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../pages/confirmations/send-legacy/send.constants":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\send-legacy\\send.constants.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","./asset-balance/asset-balance":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\asset-balance\\asset-balance.tsx","./asset-picker/asset-picker":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\asset-picker\\asset-picker.tsx","./max-clear-button":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\max-clear-button.tsx","./swappable-currency-input/swappable-currency-input":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\swappable-currency-input\\swappable-currency-input.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Casset-picker-amount%5Casset-picker-amount.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetPickerAmount = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _selectors = require("../../../selectors");
var _transaction = require("../../../../shared/constants/transaction");
var _send = require("../../../ducks/send");
var _send2 = require("../../../pages/confirmations/send-legacy/send.constants");
var _metamask = require("../../../ducks/metamask/metamask");
var _useGetAssetImageUrl = _interopRequireDefault(require("../../../hooks/useGetAssetImageUrl"));
var _networks = require("../../../../shared/modules/selectors/networks");
var _actions = require("../../../store/actions");
var _actions2 = require("../../../ducks/bridge/actions");
var _maxClearButton = _interopRequireDefault(require("./max-clear-button"));
var _assetPicker = require("./asset-picker/asset-picker");
var _swappableCurrencyInput = require("./swappable-currency-input/swappable-currency-input");
var _assetBalance = require("./asset-balance/asset-balance");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
// A component that combines an asset picker with an input for the amount to send.
const AssetPickerAmount = ({
  asset,
  amount,
  onAmountChange,
  action,
  isAmountLoading,
  disableMaxButton = false,
  showNetworkPicker,
  error: passedError,
  ...assetPickerProps
}) => {
  var _asset$details, _asset$details2, _asset$details4, _asset$details5, _asset$details6, _asset$details7;
  const selectedAccount = (0, _reactRedux.useSelector)(_selectors.getSelectedInternalAccount);
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    swapQuotesError,
    sendAsset,
    receiveAsset
  } = (0, _reactRedux.useSelector)(_send.getCurrentDraftTransaction);
  const isDisabled = !onAmountChange;
  const isSwapsErrorShown = isDisabled && swapQuotesError;
  const isMaxMode = (0, _reactRedux.useSelector)(_send.getSendMaxModeState);
  const isNativeSendPossible = (0, _reactRedux.useSelector)(_send.getIsNativeSendPossible);
  const currentChainId = (0, _reactRedux.useSelector)(_networks.getCurrentChainId);
  const nativeCurrencySymbol = (0, _reactRedux.useSelector)(_metamask.getNativeCurrency);
  const nativeCurrencyImageUrl = (0, _reactRedux.useSelector)(_selectors.getNativeCurrencyImage);
  const tokenList = (0, _reactRedux.useSelector)(_selectors.getTokenList);
  const addressBook = (0, _reactRedux.useSelector)(_selectors.getCompleteAddressBook);
  const recipient = (0, _reactRedux.useSelector)(_send.getRecipient);
  const ipfsGateway = (0, _reactRedux.useSelector)(_selectors.getIpfsGateway);
  const allNetworks = (0, _reactRedux.useSelector)(_networks.getNetworkConfigurationsByChainId);
  const showNetworkPickerinModal = showNetworkPicker;
  const currentNetwork = (0, _reactRedux.useSelector)(_selectors.getCurrentNetwork);
  const allChainIds = (0, _reactRedux.useSelector)(_selectors.getAllChainsToPoll);
  (0, _react.useEffect)(() => {
    // if this input is immutable – avoids double fire
    if (isDisabled) {
      return;
    }

    // if native send is not possible
    if (isNativeSendPossible) {
      return;
    }

    // if max mode already enabled
    if (!isMaxMode) {
      return;
    }

    // disable max mode and replace with "0"
    onAmountChange('0x0');
  }, [isDisabled, isMaxMode, isNativeSendPossible, onAmountChange]);
  const [isFocused, setIsFocused] = (0, _react.useState)(false);
  const [isNFTInputChanged, setIsTokenInputChanged] = (0, _react.useState)(false);
  const nftImageURL = (0, _useGetAssetImageUrl.default)((asset === null || asset === void 0 || (_asset$details = asset.details) === null || _asset$details === void 0 ? void 0 : _asset$details.image) ?? undefined, ipfsGateway);
  const handleChange = (0, _react.useCallback)((newAmountRaw, newAmountFormatted) => {
    if (!isNFTInputChanged && asset.type === _transaction.AssetType.NFT) {
      setIsTokenInputChanged(true);
    }
    onAmountChange === null || onAmountChange === void 0 || onAmountChange(newAmountRaw, newAmountFormatted);
  }, [onAmountChange, isNFTInputChanged, asset.type]);
  (0, _react.useEffect)(() => {
    setIsTokenInputChanged(false);
  }, [asset]);
  const {
    error: rawError
  } = amount;

  // if input hasn't been touched, don't show the zero amount error
  const isLowBalanceErrorInvalid = rawError === _send2.NEGATIVE_OR_ZERO_AMOUNT_TOKENS_ERROR && asset.type === _transaction.AssetType.NFT && !isNFTInputChanged;
  const error = rawError && !isLowBalanceErrorInvalid ? rawError : undefined;
  (0, _react.useEffect)(() => {
    if (!asset) {
      throw new Error('No asset is drafted for sending');
    }
  }, [asset, selectedAccount]);
  let borderColor = _designSystem.BorderColor.borderMuted;
  if (isDisabled) {
    // if disabled, do not show source-side border colors
    if (isSwapsErrorShown) {
      borderColor = _designSystem.BorderColor.errorDefault;
    }
  } else if (error) {
    borderColor = _designSystem.BorderColor.errorDefault;
  } else if (isFocused) {
    borderColor = _designSystem.BorderColor.primaryDefault;
  }
  const isSwapAndSendFromNative = sendAsset.type === _transaction.AssetType.native && receiveAsset.type !== _transaction.AssetType.native;
  let standardizedAsset;
  if ((asset === null || asset === void 0 ? void 0 : asset.type) === _transaction.AssetType.native) {
    standardizedAsset = {
      type: asset.type,
      image: nativeCurrencyImageUrl,
      symbol: nativeCurrencySymbol,
      chainId: currentChainId
    };
  } else if ((asset === null || asset === void 0 ? void 0 : asset.type) === _transaction.AssetType.token && asset !== null && asset !== void 0 && (_asset$details2 = asset.details) !== null && _asset$details2 !== void 0 && _asset$details2.symbol) {
    var _asset$details3, _tokenList$asset$deta;
    standardizedAsset = {
      type: asset.type,
      image: nftImageURL || tokenList && ((_asset$details3 = asset.details) === null || _asset$details3 === void 0 ? void 0 : _asset$details3.address) && ((_tokenList$asset$deta = tokenList[asset.details.address.toLowerCase()]) === null || _tokenList$asset$deta === void 0 ? void 0 : _tokenList$asset$deta.iconUrl),
      symbol: asset.details.symbol,
      address: asset.details.address,
      chainId: currentChainId
    };
  } else if ((asset === null || asset === void 0 ? void 0 : asset.type) === _transaction.AssetType.NFT && (asset === null || asset === void 0 || (_asset$details4 = asset.details) === null || _asset$details4 === void 0 ? void 0 : _asset$details4.tokenId) !== undefined && asset !== null && asset !== void 0 && (_asset$details5 = asset.details) !== null && _asset$details5 !== void 0 && _asset$details5.image) {
    standardizedAsset = {
      type: asset.type,
      tokenId: asset.details.tokenId,
      image: asset.details.image,
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
      // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
      symbol: (asset.details.symbol || asset.details.name) ?? undefined,
      address: asset.details.address
    };
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "asset-picker-amount"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    onFocus: () => setIsFocused(true),
    onBlur: () => setIsFocused(false),
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    borderRadius: _designSystem.BorderRadius.LG,
    borderColor: borderColor,
    borderStyle: _designSystem.BorderStyle.solid,
    borderWidth: 1,
    marginBottom: 1,
    padding: 1
    // apply extra padding if there isn't an input component to apply it
    ,
    paddingTop: ((_asset$details6 = asset.details) === null || _asset$details6 === void 0 ? void 0 : _asset$details6.standard) === _transaction.TokenStandard.ERC721 ? 4 : 1,
    paddingBottom: ((_asset$details7 = asset.details) === null || _asset$details7 === void 0 ? void 0 : _asset$details7.standard) === _transaction.TokenStandard.ERC721 ? 4 : 1
  }, /*#__PURE__*/_react.default.createElement(_assetPicker.AssetPicker, _extends({
    action: action,
    asset: standardizedAsset,
    networkProps: showNetworkPickerinModal ? {
      network: currentNetwork,
      networks: Object.values(allNetworks),
      onNetworkChange: networkConfig => {
        const rpcEndpoint = networkConfig.rpcEndpoints[networkConfig.defaultRpcEndpointIndex];
        dispatch((0, _actions2.setToChainId)(networkConfig.chainId));
        dispatch((0, _actions.detectNfts)(allChainIds));
        dispatch((0, _actions.setEnabledNetworks)(networkConfig.chainId));
        dispatch((0, _actions.setActiveNetworkWithError)('networkClientId' in rpcEndpoint ? rpcEndpoint.networkClientId : networkConfig.chainId));

        // Only proceed if we have recipient and addressBook
        if (recipient !== null && recipient !== void 0 && recipient.address && addressBook) {
          // Check if there's a contact with the same address on the NEW network
          const contactIsNotExistsOnNewNetwork = addressBook.find(item => {
            return item.address === recipient.address && item.chainId !== networkConfig.chainId;
          });

          // If no contact exists on the new network, clear the recipient
          if (contactIsNotExistsOnNewNetwork) {
            dispatch((0, _send.updateRecipient)({
              address: '',
              nickname: ''
            }));
          }
        }
      },
      header: t('yourNetworks')
    } : undefined
  }, assetPickerProps)), /*#__PURE__*/_react.default.createElement(_swappableCurrencyInput.SwappableCurrencyInput, {
    onAmountChange: onAmountChange ? handleChange : undefined,
    assetType: asset.type,
    asset: asset,
    amount: amount,
    isAmountLoading: isAmountLoading
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex
  }, onAmountChange &&
  /*#__PURE__*/
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  _react.default.createElement(_assetBalance.AssetBalance, {
    asset: asset,
    error: passedError || error
  }), isSwapsErrorShown && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.errorDefault
  }, t(swapQuotesError)), onAmountChange && isNativeSendPossible && !isSwapAndSendFromNative && !disableMaxButton && /*#__PURE__*/_react.default.createElement(_maxClearButton.default, {
    asset: asset
  })));
};
exports.AssetPickerAmount = AssetPickerAmount;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\asset-picker-amount\\asset-picker-amount.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\asset-picker-modal\\Asset.tsx", {"../../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../../hooks/useFormatters":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useFormatters.ts","../../../../hooks/useTokenFiatAmount":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTokenFiatAmount.js","../../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../../../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","../../token-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\token-list-item\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Casset-picker-amount%5Casset-picker-modal%5CAsset.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Asset;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _metamask = require("../../../../ducks/metamask/metamask");
var _useTokenFiatAmount = require("../../../../hooks/useTokenFiatAmount");
var _tokenListItem = require("../../token-list-item");
var _useFormatters = require("../../../../hooks/useFormatters");
var _multichain = require("../../../../selectors/multichain");
var _selectors = require("../../../../selectors/selectors");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function Asset({
  address,
  image,
  symbol,
  string: decimalTokenAmount,
  name,
  tooltipText,
  tokenFiatAmount,
  chainId,
  assetItemProps = {},
  isDestinationToken = false
}) {
  var _cachedTokens$chainId;
  const {
    formatCurrency,
    formatTokenQuantity
  } = (0, _useFormatters.useFormatters)();
  const currency = (0, _reactRedux.useSelector)(_metamask.getCurrentCurrency);
  const allNetworks = (0, _reactRedux.useSelector)(_multichain.getMultichainNetworkConfigurationsByChainId);
  const isTokenChainIdInWallet = Boolean(chainId ? allNetworks[chainId] : true);
  const cachedTokens = (0, _reactRedux.useSelector)(_selectors.selectERC20TokensByChain);
  const formattedFiat = (0, _useTokenFiatAmount.useTokenFiatAmount)(address ?? undefined, decimalTokenAmount, symbol, {}, true);
  const formattedAmount = decimalTokenAmount ? `${formatTokenQuantity(Number(decimalTokenAmount), symbol)}` : undefined;
  const primaryAmountToUse = tokenFiatAmount ? formatCurrency(tokenFiatAmount, currency) : formattedFiat;
  return /*#__PURE__*/_react.default.createElement(_tokenListItem.TokenListItem, _extends({
    key: `${chainId}-${symbol}-${address}`,
    chainId: chainId,
    tokenSymbol: symbol,
    tokenImage: image ?? (cachedTokens === null || cachedTokens === void 0 || (_cachedTokens$chainId = cachedTokens[chainId]) === null || _cachedTokens$chainId === void 0 || (_cachedTokens$chainId = _cachedTokens$chainId.data) === null || _cachedTokens$chainId === void 0 || (_cachedTokens$chainId = _cachedTokens$chainId[(address ?? '').toLowerCase()]) === null || _cachedTokens$chainId === void 0 ? void 0 : _cachedTokens$chainId.iconUrl),
    secondary: isTokenChainIdInWallet ? formattedAmount : undefined,
    primary: isTokenChainIdInWallet ? primaryAmountToUse : undefined,
    title: name ?? symbol,
    tooltipText: tooltipText,
    tokenChainImage: (0, _multichain.getImageForChainId)(chainId),
    isDestinationToken: isDestinationToken,
    address: address
  }, assetItemProps));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\asset-picker-amount\\asset-picker-modal\\Asset.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\asset-picker-modal\\AssetList.tsx", {"../..":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useCurrencyDisplay":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useCurrencyDisplay.js","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../hooks/useMultichainSelector":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainSelector.ts","../../../../pages/settings/networks-tab/networks-form/use-safe-chains":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\networks-tab\\networks-form\\use-safe-chains.ts","../../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../ui/loading-screen":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\loading-screen\\index.js","./Asset":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\asset-picker-modal\\Asset.tsx","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Casset-picker-amount%5Casset-picker-modal%5CAssetList.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = AssetList;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _utils = require("@metamask/utils");
var _reactRedux = require("react-redux");
var _useCurrencyDisplay = require("../../../../hooks/useCurrencyDisplay");
var _transaction = require("../../../../../shared/constants/transaction");
var _componentLibrary = require("../../../component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _ = require("../..");
var _loadingScreen = _interopRequireDefault(require("../../../ui/loading-screen"));
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _multichain = require("../../../../selectors/multichain");
var _useMultichainSelector = require("../../../../hooks/useMultichainSelector");
var _useSafeChains = require("../../../../pages/settings/networks-tab/networks-form/use-safe-chains");
var _conversion = require("../../../../../shared/modules/conversion.utils");
var _Asset = _interopRequireDefault(require("./Asset"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function AssetList({
  handleAssetChange,
  asset,
  tokenList,
  isTokenDisabled,
  network,
  isTokenListLoading = false,
  assetItemProps = {},
  isDestinationToken = false
}) {
  var _safeChainDetails$nat;
  const t = (0, _useI18nContext.useI18nContext)();
  const currentNetwork = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainCurrentNetwork);
  // If a network is provided, display tokens in that network
  // Otherwise, assume tokens in the current network are displayed
  const networkToUse = network ?? currentNetwork;
  // This indicates whether tokens in the wallet's active network are displayed
  const isSelectedNetworkActive = networkToUse.chainId === currentNetwork.chainId;
  const chainId = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainCurrentChainId);
  const nativeCurrency = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainNativeCurrency);
  const balanceValue = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainSelectedAccountCachedBalance);
  const currentCurrency = (0, _reactRedux.useSelector)(_multichain.getMultichainCurrentCurrency);
  const [primaryCurrencyValue] = (0, _useCurrencyDisplay.useCurrencyDisplay)(balanceValue, {
    currency: currentCurrency,
    hideLabel: true
  });
  const [secondaryCurrencyValue] = (0, _useCurrencyDisplay.useCurrencyDisplay)(balanceValue, {
    currency: nativeCurrency
  });
  const {
    safeChains
  } = (0, _useSafeChains.useSafeChains)();
  const safeChainDetails = (0, _react.useMemo)(() => safeChains === null || safeChains === void 0 ? void 0 : safeChains.find(chain => {
    const decimalChainId = (0, _utils.isStrictHexString)(chainId) && parseInt((0, _conversion.hexToDecimal)(chainId), 10);
    if (typeof decimalChainId === 'number') {
      return chain.chainId === decimalChainId.toString();
    }
    return undefined;
  }), [safeChains, chainId]);
  const nativeCurrencySymbol = safeChainDetails === null || safeChainDetails === void 0 || (_safeChainDetails$nat = safeChainDetails.nativeCurrency) === null || _safeChainDetails$nat === void 0 ? void 0 : _safeChainDetails$nat.symbol;
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "tokens-main-view-modal"
  }, isTokenListLoading && /*#__PURE__*/_react.default.createElement(_loadingScreen.default, {
    loadingMessage: t('loadingTokenList'),
    showLoadingSpinner: true
  }), tokenList.map(token => {
    var _token$address, _asset$address;
    const tokenAddress = (_token$address = token.address) === null || _token$address === void 0 ? void 0 : _token$address.toLowerCase();
    const isMatchingChainId = token.chainId === (networkToUse === null || networkToUse === void 0 ? void 0 : networkToUse.chainId);
    const isMatchingAddress =
    // the native asset can have an undefined, null, '', or zero address so compare symbols
    token.type === _transaction.AssetType.native && token.symbol === (asset === null || asset === void 0 ? void 0 : asset.symbol) || tokenAddress === (asset === null || asset === void 0 || (_asset$address = asset.address) === null || _asset$address === void 0 ? void 0 : _asset$address.toLowerCase());
    const isSelected = isMatchingChainId && isMatchingAddress;
    const isDisabled = (isTokenDisabled === null || isTokenDisabled === void 0 ? void 0 : isTokenDisabled(token)) ?? false;
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      padding: 0,
      gap: 0,
      margin: 0,
      key: `${token.symbol}-${tokenAddress ?? ''}-${token.chainId}`,
      backgroundColor: isSelected ? _designSystem.BackgroundColor.primaryMuted : _designSystem.BackgroundColor.transparent,
      className: (0, _classnames.default)('multichain-asset-picker-list-item', {
        'multichain-asset-picker-list-item--selected': isSelected,
        'multichain-asset-picker-list-item--disabled': isDisabled
      }),
      "data-testid": "asset-list-item",
      onClick: () => {
        if (isDisabled) {
          return;
        }
        handleAssetChange(token);
      }
    }, isSelected ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      className: "multichain-asset-picker-list-item__selected-indicator",
      borderRadius: _designSystem.BorderRadius.pill,
      backgroundColor: _designSystem.BackgroundColor.primaryDefault
    }) : null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      key: token.address,
      padding: 0,
      display: _designSystem.Display.Block,
      flexWrap: _designSystem.FlexWrap.NoWrap,
      alignItems: _designSystem.AlignItems.center
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, token.type === _transaction.AssetType.native && token.chainId === chainId && isSelectedNetworkActive ?
    /*#__PURE__*/
    // Only use this component for the native token of the active network
    _react.default.createElement(_.TokenListItem, _extends({
      chainId: token.chainId,
      title: token.name ?? token.symbol,
      primary: primaryCurrencyValue,
      tokenSymbol: token.symbol,
      secondary: secondaryCurrencyValue,
      tokenImage: token.image,
      tokenChainImage: (0, _multichain.getImageForChainId)(token.chainId),
      nativeCurrencySymbol: nativeCurrencySymbol
    }, assetItemProps, {
      isTitleNetworkName: false
    })) : /*#__PURE__*/_react.default.createElement(_Asset.default, _extends({}, token, {
      tooltipText: isDisabled ? 'swapTokenNotAvailable' : undefined,
      assetItemProps: {
        ...assetItemProps,
        nativeCurrencySymbol
      },
      isDestinationToken: isDestinationToken
    })))));
  }));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\asset-picker-amount\\asset-picker-modal\\AssetList.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\asset-picker-modal\\asset-picker-modal-network.tsx", {"../../../../../shared/constants/bridge":"D:\\code\\v\\metamask-extension\\shared\\constants\\bridge.ts","../../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/utils/confirm-tx.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\confirm-tx.util.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../hooks/useMultichainBalances":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainBalances.ts","../../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../../../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../network-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-item\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Casset-picker-amount%5Casset-picker-modal%5Casset-picker-modal-network.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetPickerModalNetwork = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _designSystem = require("../../../../helpers/constants/design-system");
var _componentLibrary = require("../../../component-library");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _networkListItem = require("../../network-list-item");
var _networks = require("../../../../../shared/modules/selectors/networks");
var _metamask = require("../../../../ducks/metamask/metamask");
var _confirmTx = require("../../../../helpers/utils/confirm-tx.util");
var _useMultichainBalances = require("../../../../hooks/useMultichainBalances");
var _bridge = require("../../../../../shared/constants/bridge");
var _multichain = require("../../../../selectors/multichain");
var _network = require("../../../../../shared/constants/network");
var _selectors = require("../../../../selectors/selectors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO use MultichainNetworkConfiguration type

/**
 * AssetPickerModalNetwork component displays a modal for selecting a network in the asset picker.
 *
 * @param props
 * @param props.isOpen - Determines whether the modal is open or not.
 * @param props.network - The currently selected network, not necessarily the active wallet network, and possibly not imported yet.
 * @param props.networks - The list of selectable networks.
 * @param props.onNetworkChange - The callback function to handle network change.
 * @param props.onClose - The callback function to handle modal close.
 * @param props.onBack - The callback function to handle going back in the modal.
 * @param props.shouldDisableNetwork - The callback function to determine if a network should be disabled.
 * @param props.header - A custom header for the modal.
 * @param props.onMultiselectSubmit - The callback function to run when multiple networks are selected.
 * @param props.selectedChainIds - A list of selected chainIds.
 * @param props.isMultiselectEnabled - Determines whether selecting multiple networks is enabled.
 * @returns A modal with a list of selectable networks.
 */
const AssetPickerModalNetwork = ({
  isOpen,
  onClose,
  onBack,
  network,
  networks,
  onNetworkChange,
  shouldDisableNetwork,
  header,
  isMultiselectEnabled,
  onMultiselectSubmit,
  selectedChainIds
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    balanceByChainId
  } = (0, _useMultichainBalances.useMultichainBalances)();
  const allNetworks = (0, _reactRedux.useSelector)(_networks.getNetworkConfigurationsByChainId);
  const showTestnets = (0, _reactRedux.useSelector)(_selectors.getShowTestNetworks);
  const currency = (0, _reactRedux.useSelector)(_metamask.getCurrentCurrency);
  // Use the networks prop if it is provided, otherwise use all available networks
  // Sort the networks by balance in descending order
  const networksList = (0, _react.useMemo)(() => (networks ?? Object.values(allNetworks) ?? []).sort((a, b) => balanceByChainId[b.chainId] - balanceByChainId[a.chainId]), []);
  const [nonTestNetworks, testNetworks] = (0, _react.useMemo)(() => networksList.reduce(([nonTestNetworksList, testNetworksList], networkDetail) => {
    const isTest = _network.TEST_CHAINS.includes(networkDetail.chainId);
    (isTest ? testNetworksList : nonTestNetworksList).push(networkDetail);
    return [nonTestNetworksList, testNetworksList];
  }, [[], []]), [networksList]);
  // Tracks the selection/checked state of each network
  // Initialized with the selectedChainIds if provided
  const [checkedChainIds, setCheckedChainIds] = (0, _react.useState)((networksList === null || networksList === void 0 ? void 0 : networksList.reduce((acc, {
    chainId
  }) => ({
    ...acc,
    [chainId]: selectedChainIds ? selectedChainIds.includes(chainId) : false
  }), {})) ?? {});

  // Reset checkedChainIds if selectedChainIds change in parent component
  (0, _react.useEffect)(() => {
    networksList && setCheckedChainIds(networksList.reduce((acc, {
      chainId
    }) => ({
      ...acc,
      [chainId]: selectedChainIds ? selectedChainIds.includes(chainId) : false
    }), {}));
  }, [networksList, selectedChainIds]);
  const handleToggleNetwork = (0, _react.useCallback)(chainId => {
    setCheckedChainIds(prev => ({
      ...prev,
      [chainId]: !prev[chainId]
    }));
  }, []);

  // Toggles all networks to be checked or unchecked
  const handleToggleAllNetworks = (0, _react.useCallback)(() => {
    var _Object$keys;
    setCheckedChainIds((_Object$keys = Object.keys(checkedChainIds)) === null || _Object$keys === void 0 ? void 0 : _Object$keys.reduce((agg, chainId) => ({
      ...agg,
      [chainId]: !Object.values(checkedChainIds).every(v => v)
    }), {}));
  }, [checkedChainIds]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: isOpen,
    onClose: onClose,
    className: "multichain-asset-picker__network-modal"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, {
    modalDialogProps: {
      padding: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onBack: network ? onBack : undefined,
    onClose: isMultiselectEnabled ? undefined : onClose,
    endAccessory: isMultiselectEnabled && selectedChainIds ? /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
      variant: _designSystem.TextVariant.bodyMdMedium,
      disabled: Object.values(checkedChainIds).every(v => !v),
      onClick: () => {
        onMultiselectSubmit === null || onMultiselectSubmit === void 0 || onMultiselectSubmit(Object.keys(checkedChainIds).filter(chainId => checkedChainIds[chainId]));
        onBack();
      }
    }, t('apply')) : undefined
  }, header ?? t('bridgeSelectNetwork')), isMultiselectEnabled && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    padding: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Checkbox, {
    isIndeterminate: Object.values(checkedChainIds).every(v => v),
    iconProps: {
      name: Object.values(checkedChainIds).some(v => !v) ? _componentLibrary.IconName.MinusBold : _componentLibrary.IconName.Add,
      color: _designSystem.IconColor.primaryInverse,
      backgroundColor: _designSystem.BackgroundColor.primaryDefault
    },
    isChecked: true,
    onChange: () => {
      handleToggleAllNetworks();
    }
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    onClick: () => {
      handleToggleAllNetworks();
    },
    style: {
      alignSelf: _designSystem.AlignItems.flexStart,
      paddingInline: 16
    }
  }, t('selectAll'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "multichain-asset-picker__network-list",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column
  }, testNetworks.length > 0 ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    color: _designSystem.TextColor.textAlternative,
    padding: 4
  }, t('enabledNetworks')) : null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    width: _designSystem.BlockSize.Full
  }, nonTestNetworks.map(networkConfig => {
    var _balanceByChainId$cha;
    const {
      name,
      chainId
    } = networkConfig;
    return /*#__PURE__*/_react.default.createElement(_networkListItem.NetworkListItem, {
      key: chainId,
      name: _bridge.NETWORK_TO_SHORT_NETWORK_NAME_MAP[chainId] ?? name,
      selected:
      // If multiselect is enabled, the checkbox indicates selection
      isMultiselectEnabled ? false : (network === null || network === void 0 ? void 0 : network.chainId) === chainId,
      onClick: () => {
        if (isMultiselectEnabled) {
          handleToggleNetwork(chainId);
          return;
        }
        onNetworkChange(networkConfig);
        onBack();
      },
      iconSrc: (0, _multichain.getImageForChainId)(chainId),
      iconSize: _componentLibrary.AvatarNetworkSize.Sm,
      focus: false,
      disabled: shouldDisableNetwork === null || shouldDisableNetwork === void 0 ? void 0 : shouldDisableNetwork(networkConfig),
      startAccessory: isMultiselectEnabled ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Checkbox, {
        isChecked: checkedChainIds[chainId],
        name: chainId
      }) : undefined,
      chainId: chainId,
      showEndAccessory: isMultiselectEnabled,
      variant: _designSystem.TextVariant.bodyMdMedium,
      endAccessory: isMultiselectEnabled ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        variant: _designSystem.TextVariant.bodyMdMedium
      }, (0, _confirmTx.formatCurrency)((_balanceByChainId$cha = balanceByChainId[chainId]) === null || _balanceByChainId$cha === void 0 ? void 0 : _balanceByChainId$cha.toString(), currency)) : undefined
    });
  }))), showTestnets && testNetworks.length > 0 ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "multichain-asset-picker__network-list",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    padding: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    color: _designSystem.TextColor.textAlternative
  }, t('testNetworks'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    width: _designSystem.BlockSize.Full
  }, testNetworks.map(networkConfig => {
    var _balanceByChainId$cha2;
    const {
      name,
      chainId
    } = networkConfig;
    return /*#__PURE__*/_react.default.createElement(_networkListItem.NetworkListItem, {
      key: chainId,
      name: _bridge.NETWORK_TO_SHORT_NETWORK_NAME_MAP[chainId] ?? name,
      selected:
      // If multiselect is enabled, the checkbox indicates selection
      isMultiselectEnabled ? false : (network === null || network === void 0 ? void 0 : network.chainId) === chainId,
      onClick: () => {
        if (isMultiselectEnabled) {
          handleToggleNetwork(chainId);
          return;
        }
        onNetworkChange(networkConfig);
        onBack();
      },
      iconSrc: (0, _multichain.getImageForChainId)(chainId),
      iconSize: _componentLibrary.AvatarNetworkSize.Sm,
      focus: false,
      disabled: shouldDisableNetwork === null || shouldDisableNetwork === void 0 ? void 0 : shouldDisableNetwork(networkConfig),
      startAccessory: isMultiselectEnabled ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Checkbox, {
        isChecked: checkedChainIds[chainId],
        name: chainId
      }) : undefined,
      showEndAccessory: isMultiselectEnabled,
      variant: _designSystem.TextVariant.bodyMdMedium,
      endAccessory: isMultiselectEnabled ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        variant: _designSystem.TextVariant.bodyMdMedium
      }, (0, _confirmTx.formatCurrency)((_balanceByChainId$cha2 = balanceByChainId[chainId]) === null || _balanceByChainId$cha2 === void 0 ? void 0 : _balanceByChainId$cha2.toString(), currency)) : undefined
    });
  }))) : null));
};
exports.AssetPickerModalNetwork = AssetPickerModalNetwork;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\asset-picker-amount\\asset-picker-modal\\asset-picker-modal-network.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\asset-picker-modal\\asset-picker-modal-nft-tab.tsx", {"../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../../ducks/send":"D:\\code\\v\\metamask-extension\\ui\\ducks\\send\\index.js","../../../../helpers/utils/nfts":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\nfts.ts","../../../../hooks/useNfts":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useNfts.ts","../../../../pages/confirmations/hooks/useRedesignedSendFlow":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useRedesignedSendFlow.ts","../../../../pages/confirmations/utils/send":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\utils\\send.ts","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../app/assets/nfts/nft-empty-state":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\nfts\\nft-empty-state\\index.ts","../../../app/assets/nfts/nft-grid/nft-grid":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\nfts\\nft-grid\\nft-grid.tsx","../../../app/assets/nfts/nfts-detection-notice-nfts-tab/nfts-detection-notice-nfts-tab":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\nfts\\nfts-detection-notice-nfts-tab\\nfts-detection-notice-nfts-tab.tsx","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../ui/spinner":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\spinner\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Casset-picker-amount%5Casset-picker-modal%5Casset-picker-modal-nft-tab.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetPickerModalNftTab = AssetPickerModalNftTab;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _componentLibrary = require("../../../component-library");
var _spinner = _interopRequireDefault(require("../../../ui/spinner"));
var _selectors = require("../../../../selectors");
var _nftsDetectionNoticeNftsTab = _interopRequireDefault(require("../../../app/assets/nfts/nfts-detection-notice-nfts-tab/nfts-detection-notice-nfts-tab"));
var _nftGrid = _interopRequireDefault(require("../../../app/assets/nfts/nft-grid/nft-grid"));
var _useNfts = require("../../../../hooks/useNfts");
var _metametrics = require("../../../../contexts/metametrics");
var _metametrics2 = require("../../../../../shared/constants/metametrics");
var _transaction = require("../../../../../shared/constants/transaction");
var _send = require("../../../../ducks/send");
var _nfts = require("../../../../helpers/utils/nfts");
var _useRedesignedSendFlow = require("../../../../pages/confirmations/hooks/useRedesignedSendFlow");
var _send2 = require("../../../../pages/confirmations/utils/send");
var _nftEmptyState = require("../../../app/assets/nfts/nft-empty-state");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function AssetPickerModalNftTab({
  searchQuery,
  onClose,
  renderSearch
}) {
  const dispatch = (0, _reactRedux.useDispatch)();
  const history = (0, _reactRouterDom.useHistory)();
  const useNftDetection = (0, _reactRedux.useSelector)(_selectors.getUseNftDetection);
  const isMainnet = (0, _reactRedux.useSelector)(_selectors.getIsMainnet);
  const nftsStillFetchingIndication = (0, _reactRedux.useSelector)(_selectors.getNftIsStillFetchingIndication);
  const {
    enabled: isSendRedesignEnabled
  } = (0, _useRedesignedSendFlow.useRedesignedSendFlow)();
  const {
    currentlyOwnedNfts
  } = (0, _useNfts.useNfts)({
    overridePopularNetworkFilter: true
  });
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const sendAnalytics = (0, _reactRedux.useSelector)(_send.getSendAnalyticProperties);
  const filteredNfts = currentlyOwnedNfts.reduce((acc, nft) => {
    var _nft$name;
    // Assuming `nft` has a `name` property
    const isMatchingQuery = (_nft$name = nft.name) === null || _nft$name === void 0 ? void 0 : _nft$name.toLowerCase().includes(searchQuery.toLowerCase());
    if (isMatchingQuery) {
      acc.push(nft);
    }
    return acc;
  }, []);
  const hasAnyNfts = filteredNfts.length > 0;
  const handleNftClick = async nft => {
    trackEvent({
      event: _metametrics2.MetaMetricsEventName.sendAssetSelected,
      category: _metametrics2.MetaMetricsEventCategory.Send,
      properties: {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        is_destination_asset_picker_modal: false,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        is_nft: true
      },
      sensitiveProperties: {
        ...sendAnalytics,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        new_asset_symbol: nft.name,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        new_asset_address: nft.address
      }
    }, {
      excludeMetaMetricsId: false
    });
    const nftWithSimplifiedImage = {
      ...nft,
      image: (0, _nfts.getNftImage)(nft.image)
    };
    await dispatch((0, _send.updateSendAsset)({
      type: _transaction.AssetType.NFT,
      details: nftWithSimplifiedImage,
      skipComputeEstimatedGasLimit: false
    }));
    (0, _send2.navigateToSendRoute)(history, isSendRedesignEnabled, {
      address: nft.address,
      chainId: nft.chainId
    });
    onClose && onClose();
  };
  if (!hasAnyNfts && nftsStillFetchingIndication) {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      className: "modal-tab__loading",
      "data-testid": "spinner"
    }, /*#__PURE__*/_react.default.createElement(_spinner.default, {
      color: "var(--color-warning-default)",
      className: "loading-overlay__spinner"
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "modal-tab__main-view"
  }, renderSearch(), hasAnyNfts ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_nftGrid.default, {
    nfts: filteredNfts,
    handleNftClick: handleNftClick
  })), nftsStillFetchingIndication && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "modal-tab__fetching"
  }, /*#__PURE__*/_react.default.createElement(_spinner.default, {
    color: "var(--color-warning-default)",
    className: "loading-overlay__spinner"
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isMainnet && !useNftDetection && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingTop: 4,
    paddingInlineStart: 4,
    paddingInlineEnd: 4
  }, /*#__PURE__*/_react.default.createElement(_nftsDetectionNoticeNftsTab.default, null)), /*#__PURE__*/_react.default.createElement(_nftEmptyState.NftEmptyState, {
    className: "mx-auto mt-5 mb-6"
  })));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\asset-picker-amount\\asset-picker-modal\\asset-picker-modal-nft-tab.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\asset-picker-modal\\asset-picker-modal-search.tsx", {"../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Casset-picker-amount%5Casset-picker-modal%5Casset-picker-modal-search.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Search = void 0;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../../component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../hooks/useI18nContext");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
/**
 * Renders a search component for the asset picker modal.
 *
 * @param props
 * @param props.searchQuery - The current search query.
 * @param props.onChange - The function to handle search query changes.
 * @param props.isNFTSearch - Indicates if the search is for NFTs.
 * @param props.props - Additional props for the containing Box component.
 * @param props.placeholder - A custom placeholder for the search input.
 * @param props.autoFocus - Whether to auto-focus the search input.
 * @returns The rendered search component.
 */
const Search = ({
  searchQuery,
  onChange,
  isNFTSearch = false,
  props,
  placeholder,
  autoFocus = true
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, _extends({
    paddingTop: 4,
    paddingLeft: 4,
    paddingRight: 4,
    paddingBottom: 2
  }, props), /*#__PURE__*/_react.default.createElement(_componentLibrary.TextFieldSearch, {
    borderRadius: _designSystem.BorderRadius.LG,
    placeholder: placeholder ?? t(isNFTSearch ? 'searchNfts' : 'searchTokensByNameOrAddress'),
    value: searchQuery,
    onChange: e => onChange(e.target.value),
    error: false,
    autoFocus: autoFocus,
    autoComplete: false,
    width: _designSystem.BlockSize.Full,
    clearButtonOnClick: () => onChange(''),
    clearButtonProps: {
      size: _componentLibrary.ButtonIconSize.Sm
    },
    style: {
      paddingInline: 12
    },
    showClearButton: true,
    className: "asset-picker-modal__search-list",
    inputProps: {
      'data-testid': 'asset-picker-modal-search-input',
      marginRight: 0
    },
    endAccessory: null,
    size: _componentLibrary.TextFieldSearchSize.Lg
  }));
};
exports.Search = Search;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\asset-picker-amount\\asset-picker-modal\\asset-picker-modal-search.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\asset-picker-modal\\asset-picker-modal-tabs.tsx", {"../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../ui/tabs":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tabs\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Casset-picker-amount%5Casset-picker-modal%5Casset-picker-modal-tabs.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TabName = exports.AssetPickerModalTabs = void 0;
var _react = _interopRequireDefault(require("react"));
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _tabs = require("../../../ui/tabs");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
let TabName = exports.TabName = /*#__PURE__*/function (TabName) {
  TabName["TOKENS"] = "tokens";
  TabName["NFTS"] = "nfts";
  return TabName;
}({});
/**
 * AssetPickerModalTabs component.
 *
 * @param props
 * @param props.defaultActiveTabKey - The key of the default active tab.
 * @param props.children - The child components to be displayed within tabs.
 * @param props.visibleTabs - A list of visible tabs.
 * @returns A Tabs instance with the provided visible children.
 */
const AssetPickerModalTabs = ({
  defaultActiveTabKey = TabName.TOKENS,
  children,
  visibleTabs = [TabName.TOKENS, TabName.NFTS]
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  if (visibleTabs.length > 1) {
    return /*#__PURE__*/_react.default.createElement(_tabs.Tabs, {
      defaultActiveTabKey: defaultActiveTabKey,
      onTabClick: () => null,
      tabListProps: {
        className: 'px-4'
      }
    }, visibleTabs.map(tabName => {
      return /*#__PURE__*/_react.default.createElement(_tabs.Tab, {
        key: tabName,
        name: t(tabName),
        tabKey: tabName
      }, children.find(({
        key
      }) => key === tabName));
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, visibleTabs.map(tabName => children.find(({
    key
  }) => key === tabName)));
};
exports.AssetPickerModalTabs = AssetPickerModalTabs;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\asset-picker-amount\\asset-picker-modal\\asset-picker-modal-tabs.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\asset-picker-modal\\asset-picker-modal.tsx", {"../../../../../shared/constants/bridge":"D:\\code\\v\\metamask-extension\\shared\\constants\\bridge.ts","../../../../../shared/constants/multichain/networks":"D:\\code\\v\\metamask-extension\\shared\\constants\\multichain\\networks.ts","../../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../../../shared/modules/Numeric":"D:\\code\\v\\metamask-extension\\shared\\modules\\Numeric.ts","../../../../../shared/modules/string-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\string-utils.ts","../../../../ducks/bridge/utils":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\utils.ts","../../../../ducks/send":"D:\\code\\v\\metamask-extension\\ui\\ducks\\send\\index.js","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useAsync":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAsync.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../hooks/useMultichainBalances":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainBalances.ts","../../../../hooks/useMultichainSelector":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainSelector.ts","../../../../hooks/useTokensToSearch":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTokensToSearch.js","../../../../pages/swaps/swaps.util":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\swaps.util.ts","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../avatar-group/avatar-group.types":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\avatar-group\\avatar-group.types.tsx","../../toast":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\toast\\index.ts","./AssetList":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\asset-picker-modal\\AssetList.tsx","./asset-picker-modal-nft-tab":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\asset-picker-modal\\asset-picker-modal-nft-tab.tsx","./asset-picker-modal-search":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\asset-picker-modal\\asset-picker-modal-search.tsx","./asset-picker-modal-tabs":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\asset-picker-modal\\asset-picker-modal-tabs.tsx","./hooks/useAssetMetadata":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\asset-picker-modal\\hooks\\useAssetMetadata.ts","./solana-account-creation-prompt":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\asset-picker-modal\\solana-account-creation-prompt.tsx","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","ethereumjs-util":"D:\\code\\v\\metamask-extension\\node_modules\\ethereumjs-util\\dist.browser\\index.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Casset-picker-amount%5Casset-picker-modal%5Casset-picker-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetPickerModal = AssetPickerModal;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _utils = require("@metamask/utils");
var _ethereumjsUtil = require("ethereumjs-util");
var _lodash = require("lodash");
var _componentLibrary = require("../../../component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _toast = require("../../toast");
var _transaction = require("../../../../../shared/constants/transaction");
var _selectors = require("../../../../selectors");
var _useTokensToSearch = require("../../../../hooks/useTokensToSearch");
var _send = require("../../../../ducks/send");
var _stringUtils = require("../../../../../shared/modules/string-utils");
var _network = require("../../../../../shared/constants/network");
var _useMultichainBalances = require("../../../../hooks/useMultichainBalances");
var _avatarGroup = require("../../avatar-group/avatar-group.types");
var _bridge = require("../../../../../shared/constants/bridge");
var _useAsync = require("../../../../hooks/useAsync");
var _swaps = require("../../../../pages/swaps/swaps.util");
var _useMultichainSelector = require("../../../../hooks/useMultichainSelector");
var _utils2 = require("../../../../ducks/bridge/utils");
var _multichain = require("../../../../selectors/multichain");
var _networks = require("../../../../../shared/constants/multichain/networks");
var _Numeric = require("../../../../../shared/modules/Numeric");
var _useAssetMetadata = require("./hooks/useAssetMetadata");
var _assetPickerModalTabs = require("./asset-picker-modal-tabs");
var _assetPickerModalNftTab = require("./asset-picker-modal-nft-tab");
var _AssetList = _interopRequireDefault(require("./AssetList"));
var _assetPickerModalSearch = require("./asset-picker-modal-search");
var _solanaAccountCreationPrompt = require("./solana-account-creation-prompt");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MAX_UNOWNED_TOKENS_RENDERED = 30;

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function AssetPickerModal({
  header,
  isOpen,
  onClose,
  onBack,
  asset,
  onAssetChange,
  sendingAsset,
  network,
  networks,
  action,
  onNetworkPickerClick,
  customTokenListGenerator,
  isTokenListLoading = false,
  isMultiselectEnabled,
  selectedChainIds,
  autoFocus,
  isDestinationToken = false,
  ...tabProps
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  const [showSolanaAccountCreatedToast, setShowSolanaAccountCreatedToast] = (0, _react.useState)(false);
  const prevNeedsSolanaAccountRef = (0, _react.useRef)(false);
  const [searchQuery, setSearchQuery] = (0, _react.useState)('');
  const [debouncedSearchQuery, setDebouncedSearchQuery] = (0, _react.useState)(searchQuery);
  const debouncedSetSearchQuery = (0, _react.useCallback)((0, _lodash.debounce)(value => {
    setDebouncedSearchQuery(value);
  }, 200), []);
  const abortControllerRef = (0, _react.useRef)(null);

  // Cleanup abort controller and debounce on unmount
  (0, _react.useEffect)(() => {
    return () => {
      var _abortControllerRef$c;
      (_abortControllerRef$c = abortControllerRef.current) === null || _abortControllerRef$c === void 0 || _abortControllerRef$c.abort();
      abortControllerRef.current = null;
      debouncedSetSearchQuery.cancel();
    };
  }, []);
  (0, _react.useEffect)(() => {
    debouncedSetSearchQuery(searchQuery);
  }, [searchQuery, debouncedSetSearchQuery]);
  const swapsBlockedTokens = (0, _reactRedux.useSelector)(_send.getSwapsBlockedTokens);
  const memoizedSwapsBlockedTokens = (0, _react.useMemo)(() => {
    return new Set(swapsBlockedTokens);
  }, [swapsBlockedTokens]);
  const handleAssetChange = (0, _react.useCallback)(newAsset => {
    onAssetChange(newAsset);
    setSearchQuery('');
  }, [onAssetChange]);
  const currentChainId = (0, _reactRedux.useSelector)(_multichain.getMultichainCurrentChainId);
  const allNetworks = (0, _reactRedux.useSelector)(_multichain.getMultichainNetworkConfigurationsByChainId);
  const selectedNetwork = network ?? (currentChainId && allNetworks[currentChainId]);
  const allNetworksToUse = networks ?? Object.values(allNetworks ?? {});
  const isEvm = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainIsEvm);
  (0, _react.useEffect)(() => {
    setSearchQuery('');
  }, [selectedNetwork === null || selectedNetwork === void 0 ? void 0 : selectedNetwork.chainId]);
  const nativeCurrencyImage = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainCurrencyImage);
  const nativeCurrency = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainNativeCurrency);
  const balanceValue = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainSelectedAccountCachedBalance);
  const tokenConversionRates = (0, _useMultichainSelector.useMultichainSelector)(_selectors.getTokenExchangeRates);
  const conversionRate = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainConversionRate);
  const currentCurrency = (0, _reactRedux.useSelector)(_multichain.getMultichainCurrentCurrency);

  // Default to false before the code fence is enabled (will not render the prompt)
  let needsSolanaAccount = false;
  let hasSolanaAccount = false;

  // Check if we need to show the Solana account creation UI when Solana is selected
  hasSolanaAccount = (0, _reactRedux.useSelector)(_selectors.hasCreatedSolanaAccount);
  needsSolanaAccount = !hasSolanaAccount && selectedNetwork.chainId === _networks.MultichainNetworks.SOLANA;

  // watches for needsSolanaAccount changes to show the Solana Account created toast
  (0, _react.useEffect)(() => {
    if (prevNeedsSolanaAccountRef.current === true && !needsSolanaAccount && hasSolanaAccount && showSolanaAccountCreatedToast === false) {
      setShowSolanaAccountCreatedToast(true);
    }
    prevNeedsSolanaAccountRef.current = needsSolanaAccount;
  }, [needsSolanaAccount, hasSolanaAccount, showSolanaAccountCreatedToast]);
  const {
    address: selectedEvmAddress
  } = (0, _reactRedux.useSelector)(_selectors.getSelectedEvmInternalAccount);
  const detectedTokens = (0, _reactRedux.useSelector)(_selectors.getAllTokens);

  // This only returns the detected tokens for the selected EVM account address
  const allDetectedTokens = (0, _react.useMemo)(() => {
    var _detectedTokens$curre;
    return ((0, _utils.isCaipChainId)(currentChainId) ? [] : detectedTokens === null || detectedTokens === void 0 || (_detectedTokens$curre = detectedTokens[currentChainId]) === null || _detectedTokens$curre === void 0 ? void 0 : _detectedTokens$curre[selectedEvmAddress]) ?? [];
  }, [detectedTokens, currentChainId, selectedEvmAddress]);
  const {
    assetsWithBalance: multichainTokensWithBalance
  } = (0, _useMultichainBalances.useMultichainBalances)();
  const evmTokenMetadataByAddress = (0, _reactRedux.useSelector)(_selectors.getTokenList);
  const allowExternalServices = (0, _reactRedux.useSelector)(_selectors.getUseExternalServices);
  // Swaps top tokens
  const {
    value: topTokens
  } = (0, _useAsync.useAsyncResult)(async () => {
    if (allowExternalServices && selectedNetwork !== null && selectedNetwork !== void 0 && selectedNetwork.chainId) {
      return await (0, _swaps.fetchTopAssetsList)(selectedNetwork.chainId);
    }
    return undefined;
  }, [selectedNetwork === null || selectedNetwork === void 0 ? void 0 : selectedNetwork.chainId, allowExternalServices]);
  const getIsDisabled = (0, _react.useCallback)(({
    address,
    symbol
  }) => {
    const isDisabled = sendingAsset !== null && sendingAsset !== void 0 && sendingAsset.symbol ? !(0, _stringUtils.isEqualCaseInsensitive)(sendingAsset.symbol, symbol) &&
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    memoizedSwapsBlockedTokens.has(address || '') : false;
    return isDisabled;
  }, [sendingAsset === null || sendingAsset === void 0 ? void 0 : sendingAsset.symbol, memoizedSwapsBlockedTokens]);

  /**
   * Generates a list of tokens sorted in this order
   * - native tokens with balance
   * - tokens with highest to lowest balance in selected currency
   * - selected network's native token
   * - matches URL token parameter
   * - matches search query
   * - detected tokens (without balance)
   * - popularity
   * - all other tokens
   * - blocked tokens
   */
  const tokenListGenerator = (0, _react.useCallback)(function* (shouldAddToken) {
    const blockedTokens = [];

    // Yield multichain tokens with balances
    for (const token of multichainTokensWithBalance) {
      if (shouldAddToken(token.symbol, token.address, token.chainId)) {
        yield token.isNative ? {
          ...token,
          image: _network.CHAIN_ID_TOKEN_IMAGE_MAP[token.chainId],
          type: _transaction.AssetType.native,
          // Add human-readable name for native tokens (e.g., Ether, Binance Coin)
          name: (0, _utils2.getNativeTokenName)(token.chainId)
        } : {
          ...token,
          // The Send flow requires the balance to be in Hex
          balance: _Numeric.Numeric.from(token.balance ?? '0', 10).shiftedBy(-1 * token.decimals).toPrefixedHexString()
        };
      }
    }

    // Yield the native token for the selected chain
    const nativeToken = {
      address: '',
      symbol: nativeCurrency,
      decimals: 18,
      image: nativeCurrencyImage,
      balance: balanceValue,
      string: undefined,
      chainId: selectedNetwork.chainId,
      type: _transaction.AssetType.native,
      // Add human-readable name for native token
      name: (0, _utils2.getNativeTokenName)(selectedNetwork.chainId)
    };
    if (isEvm && shouldAddToken(nativeToken.symbol, nativeToken.address, nativeToken.chainId)) {
      yield nativeToken;
    }
    for (const token of allDetectedTokens) {
      if (shouldAddToken(token.symbol, token.address, currentChainId)) {
        yield {
          ...token,
          chainId: currentChainId
        };
      }
    }

    // Return early when SOLANA is selected since blocked and top tokens are not available
    // All available solana tokens are in the multichainTokensWithBalance results
    if ((selectedNetwork === null || selectedNetwork === void 0 ? void 0 : selectedNetwork.chainId) === _networks.MultichainNetworks.SOLANA) {
      return;
    }

    // For EVM tokens only
    // topTokens are sorted by popularity
    for (const topToken of topTokens ?? []) {
      const token = evmTokenMetadataByAddress === null || evmTokenMetadataByAddress === void 0 ? void 0 : evmTokenMetadataByAddress[topToken.address];
      if (token && shouldAddToken(token.symbol, token.address, currentChainId)) {
        if (getIsDisabled(token)) {
          blockedTokens.push(token);
          continue;
        } else {
          yield {
            ...token,
            chainId: currentChainId
          };
        }
      }
    }
    for (const token of Object.values(evmTokenMetadataByAddress)) {
      if (shouldAddToken(token.symbol, token.address, currentChainId)) {
        yield {
          ...token,
          chainId: currentChainId
        };
      }
    }
    for (const token of blockedTokens) {
      yield {
        ...token,
        chainId: currentChainId
      };
    }
  }, [nativeCurrency, nativeCurrencyImage, balanceValue, currentChainId, isEvm, selectedNetwork === null || selectedNetwork === void 0 ? void 0 : selectedNetwork.chainId, multichainTokensWithBalance, allDetectedTokens, topTokens, evmTokenMetadataByAddress, getIsDisabled]);
  const filteredTokenList = (0, _react.useMemo)(() => {
    const filteredTokens = [];
    // List of token identifiers formatted like `chainId:address`
    const filteredTokensAddresses = new Set();
    const getTokenKey = (address, tokenChainId) => `${(address === null || address === void 0 ? void 0 : address.toLowerCase()) ?? (0, _ethereumjsUtil.zeroAddress)()}:${tokenChainId ?? currentChainId}`;

    // Default filter predicate for whether a token should be included in displayed list
    const shouldAddToken = (symbol, address, tokenChainId) => {
      const trimmedSearchQuery = debouncedSearchQuery.trim().toLowerCase();
      const isSymbolMatch = symbol === null || symbol === void 0 ? void 0 : symbol.toLowerCase().includes(trimmedSearchQuery);
      // only check for matching address if search term has 6 characters or more
      // users are expected to copy and paste addresses instead of typing them
      const isAddressMatch = trimmedSearchQuery.length >= 6 && (address === null || address === void 0 ? void 0 : address.toLowerCase().includes(trimmedSearchQuery));
      const isMatchedBySearchQuery = Boolean(!trimmedSearchQuery || isSymbolMatch || isAddressMatch);
      const isTokenInSelectedChain = isMultiselectEnabled ? tokenChainId && (selectedChainIds === null || selectedChainIds === void 0 ? void 0 : selectedChainIds.indexOf(tokenChainId)) !== -1 : (selectedNetwork === null || selectedNetwork === void 0 ? void 0 : selectedNetwork.chainId) === tokenChainId;
      return Boolean(isTokenInSelectedChain && isMatchedBySearchQuery && !filteredTokensAddresses.has(getTokenKey(address, tokenChainId)));
    };

    // If filteredTokensGenerator is passed in, use it to generate the filtered tokens
    // Otherwise use the default tokenGenerator
    const tokenGenerator = (customTokenListGenerator ?? tokenListGenerator)(shouldAddToken);
    for (const token of tokenGenerator) {
      if (action === 'send' && token.balance === undefined) {
        continue;
      }
      filteredTokensAddresses.add(getTokenKey(token.address, token.chainId));
      const tokenWithBalanceData = !customTokenListGenerator && (0, _utils.isStrictHexString)(token.address) ? (0, _useTokensToSearch.getRenderableTokenData)(token.address ? {
        ...token,
        ...evmTokenMetadataByAddress[token.address.toLowerCase()],
        type: _transaction.AssetType.token
      } : token, tokenConversionRates, conversionRate, currentCurrency, token.chainId, evmTokenMetadataByAddress) : token;

      // Add selected asset to the top of the list if it is the selected asset
      if ((asset === null || asset === void 0 ? void 0 : asset.address) === tokenWithBalanceData.address && (selectedNetwork === null || selectedNetwork === void 0 ? void 0 : selectedNetwork.chainId) === tokenWithBalanceData.chainId) {
        filteredTokens.unshift(tokenWithBalanceData);
      } else {
        filteredTokens.push(tokenWithBalanceData);
      }
      if (filteredTokens.length > MAX_UNOWNED_TOKENS_RENDERED) {
        break;
      }
    }
    return filteredTokens;
  }, [currentChainId, debouncedSearchQuery, isMultiselectEnabled, selectedChainIds, selectedNetwork === null || selectedNetwork === void 0 ? void 0 : selectedNetwork.chainId, customTokenListGenerator, tokenListGenerator, action, evmTokenMetadataByAddress, tokenConversionRates, conversionRate, currentCurrency, asset]);

  // This fetches the metadata for the asset if it is not already in the filteredTokenList
  const unlistedAssetMetadata = (0, _useAssetMetadata.useAssetMetadata)(searchQuery, filteredTokenList.length === 0, abortControllerRef, selectedNetwork === null || selectedNetwork === void 0 ? void 0 : selectedNetwork.chainId);
  const displayedTokens = (0, _react.useMemo)(() => {
    return unlistedAssetMetadata ? [unlistedAssetMetadata] : filteredTokenList;
  }, [unlistedAssetMetadata, filteredTokenList]);
  const getNetworkPickerLabel = () => {
    if (!isMultiselectEnabled) {
      return ((selectedNetwork === null || selectedNetwork === void 0 ? void 0 : selectedNetwork.chainId) && _network.NETWORK_TO_NAME_MAP[selectedNetwork.chainId]) ?? (selectedNetwork === null || selectedNetwork === void 0 ? void 0 : selectedNetwork.name) ?? (// @ts-expect-error TODO: fix typing
      selectedNetwork === null || selectedNetwork === void 0 ? void 0 : selectedNetwork.nickname) ?? t('bridgeSelectNetwork');
    }
    switch (selectedChainIds === null || selectedChainIds === void 0 ? void 0 : selectedChainIds.length) {
      case allNetworksToUse.length:
        return t('allNetworks');
      case 1:
        return t('singleNetwork');
      case 0:
        return t('bridgeSelectNetwork');
      default:
        return t('someNetworks', [selectedChainIds === null || selectedChainIds === void 0 ? void 0 : selectedChainIds.length]);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    className: "asset-picker-modal",
    isOpen: isOpen,
    onClose: () => {
      setSearchQuery('');
      onClose();
    },
    "data-testid": "asset-picker-modal"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, {
    modalDialogProps: {
      padding: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onClose: () => {
      setSearchQuery('');
      onClose();
    },
    onBack: asset ? undefined : onBack
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingSm,
    textAlign: _designSystem.TextAlign.Center
  }, header)), showSolanaAccountCreatedToast && /*#__PURE__*/_react.default.createElement("div", {
    style: {
      position: 'absolute',
      bottom: 15,
      left: '50%',
      transform: 'translateX(-50%)',
      zIndex: 1000,
      width: '100%',
      display: 'flex',
      justifyContent: 'center',
      padding: '16px'
    }
  }, /*#__PURE__*/_react.default.createElement(_toast.ToastContainer, null, /*#__PURE__*/_react.default.createElement(_toast.Toast, {
    text: t('bridgeSolanaAccountCreated'),
    onClose: () => setShowSolanaAccountCreatedToast(false),
    startAdornment: /*#__PURE__*/_react.default.createElement("img", {
      src: "/images/solana-logo.svg",
      alt: "Solana Logo",
      style: {
        width: '24px',
        height: '24px',
        borderRadius: '4px'
      }
    }),
    autoHideTime: 5000,
    onAutoHideToast: () => setShowSolanaAccountCreatedToast(false)
  }))), (sendingAsset === null || sendingAsset === void 0 ? void 0 : sendingAsset.image) && (sendingAsset === null || sendingAsset === void 0 ? void 0 : sendingAsset.symbol) && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    gap: 1,
    alignItems: _designSystem.AlignItems.center,
    marginInline: "auto"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarToken, {
    borderRadius: _designSystem.BorderRadius.full,
    src: sendingAsset.image,
    name: sendingAsset.symbol,
    size: _componentLibrary.AvatarTokenSize.Xs
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm
  }, t('sendingAsset', [sendingAsset.symbol]))), onNetworkPickerClick && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "network-picker",
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.PickerNetwork, {
    label: getNetworkPickerLabel(),
    src: selectedNetwork !== null && selectedNetwork !== void 0 && selectedNetwork.chainId ? (0, _multichain.getImageForChainId)(selectedNetwork.chainId) : undefined,
    avatarGroupProps: isMultiselectEnabled && selectedChainIds ? {
      limit: 2,
      members: selectedChainIds.map(c => ({
        avatarValue: (0, _multichain.getImageForChainId)(c) ?? '',
        symbol: _bridge.NETWORK_TO_SHORT_NETWORK_NAME_MAP[c]
      })),
      avatarType: _avatarGroup.AvatarType.NETWORK
    } : undefined,
    onClick: onNetworkPickerClick,
    "data-testid": "multichain-asset-picker__network"
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "modal-tab__wrapper"
  }, needsSolanaAccount ? /*#__PURE__*/_react.default.createElement(_solanaAccountCreationPrompt.SolanaAccountCreationPrompt, null) : /*#__PURE__*/_react.default.createElement(_assetPickerModalTabs.AssetPickerModalTabs, tabProps, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: _assetPickerModalTabs.TabName.TOKENS
  }, /*#__PURE__*/_react.default.createElement(_assetPickerModalSearch.Search, {
    searchQuery: searchQuery,
    onChange: value => {
      var _abortControllerRef$c2;
      // Cancel previous asset metadata fetch
      (_abortControllerRef$c2 = abortControllerRef.current) === null || _abortControllerRef$c2 === void 0 || _abortControllerRef$c2.abort();
      setSearchQuery(() => value);
    },
    autoFocus: autoFocus
  }), /*#__PURE__*/_react.default.createElement(_AssetList.default, {
    network: network,
    handleAssetChange: handleAssetChange,
    asset: (asset === null || asset === void 0 ? void 0 : asset.type) === _transaction.AssetType.NFT ? undefined : asset,
    tokenList: displayedTokens,
    isTokenDisabled: getIsDisabled,
    isTokenListLoading: isTokenListLoading,
    assetItemProps: {
      isTitleNetworkName: false,
      isTitleHidden: false
    },
    isDestinationToken: isDestinationToken
  })), /*#__PURE__*/_react.default.createElement(_assetPickerModalNftTab.AssetPickerModalNftTab, {
    key: _assetPickerModalTabs.TabName.NFTS,
    searchQuery: searchQuery,
    onClose: onClose,
    renderSearch: () => /*#__PURE__*/_react.default.createElement(_assetPickerModalSearch.Search, {
      isNFTSearch: true,
      searchQuery: searchQuery,
      onChange: value => setSearchQuery(value)
    })
  })))));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\asset-picker-amount\\asset-picker-modal\\asset-picker-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\asset-picker-modal\\hooks\\useAssetMetadata.ts", {"../../../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../../../../shared/lib/asset-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\asset-utils.ts","../../../../../hooks/useAsync":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAsync.ts","../../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Casset-picker-amount%5Casset-picker-modal%5Chooks%5CuseAssetMetadata.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAssetMetadata = void 0;
var _reactRedux = require("react-redux");
var _selectors = require("../../../../../selectors");
var _assetUtils = require("../../../../../../shared/lib/asset-utils");
var _transaction = require("../../../../../../shared/constants/transaction");
var _useAsync = require("../../../../../hooks/useAsync");
/**
 * Fetches token metadata for a single token if searchQuery is defined but filteredTokenList is empty
 *
 * @param searchQuery - The search query to fetch metadata for
 * @param shouldFetchMetadata - Whether to fetch metadata
 * @param abortControllerRef - The abort controller ref to use for the fetch request
 * @param chainId - The chain id to fetch metadata for
 * @returns The asset metadata
 */
const useAssetMetadata = (searchQuery, shouldFetchMetadata, abortControllerRef, chainId) => {
  const allowExternalServices = (0, _reactRedux.useSelector)(_selectors.getUseExternalServices);
  const {
    value: assetMetadata
  } = (0, _useAsync.useAsyncResult)(async () => {
    if (!chainId || !searchQuery) {
      return undefined;
    }
    const trimmedSearchQuery = searchQuery.trim();
    if (allowExternalServices && shouldFetchMetadata && trimmedSearchQuery.length > 30) {
      abortControllerRef.current = new AbortController();
      const metadata = await (0, _assetUtils.fetchAssetMetadata)(trimmedSearchQuery, chainId, abortControllerRef.current.signal);
      if (metadata) {
        return {
          ...metadata,
          chainId,
          isNative: false,
          type: _transaction.AssetType.token,
          image: (0, _assetUtils.getAssetImageUrl)(metadata.assetId, chainId) ?? '',
          balance: '',
          string: ''
        };
      }
      return undefined;
    }
    return undefined;
  }, [shouldFetchMetadata, searchQuery]);
  return assetMetadata;
};
exports.useAssetMetadata = useAssetMetadata;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\asset-picker-amount\\asset-picker-modal\\hooks\\useAssetMetadata.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\asset-picker-modal\\index.ts", {"./asset-picker-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\asset-picker-modal\\asset-picker-modal.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Casset-picker-amount%5Casset-picker-modal%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "AssetPickerModal", {
  enumerable: true,
  get: function () {
    return _assetPickerModal.AssetPickerModal;
  }
});
var _assetPickerModal = require("./asset-picker-modal");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\asset-picker-amount\\asset-picker-modal\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\asset-picker-modal\\solana-account-creation-prompt.tsx", {"../../../../../shared/constants/multichain/networks":"D:\\code\\v\\metamask-extension\\shared\\constants\\multichain\\networks.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/accounts/useMultichainWalletSnapClient":"D:\\code\\v\\metamask-extension\\ui\\hooks\\accounts\\useMultichainWalletSnapClient.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Casset-picker-amount%5Casset-picker-modal%5Csolana-account-creation-prompt.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SolanaAccountCreationPrompt = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _componentLibrary = require("../../../component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _networks = require("../../../../../shared/constants/multichain/networks");
var _selectors = require("../../../../selectors");
var _useMultichainWalletSnapClient = require("../../../../hooks/accounts/useMultichainWalletSnapClient");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SolanaAccountCreationPrompt = () => {
  var _primaryKeyring$metad2;
  const t = (0, _useI18nContext.useI18nContext)();
  const solanaWalletSnapClient = (0, _useMultichainWalletSnapClient.useMultichainWalletSnapClient)(_useMultichainWalletSnapClient.WalletClientType.Solana);
  const [primaryKeyring] = (0, _reactRedux.useSelector)(_selectors.getMetaMaskKeyrings);
  const [isCreating, setIsCreating] = _react.default.useState(false);
  const handleCreateAccount = (0, _react.useCallback)(async () => {
    try {
      var _primaryKeyring$metad;
      setIsCreating(true);
      await solanaWalletSnapClient.createAccount({
        scope: _networks.MultichainNetworks.SOLANA,
        entropySource: primaryKeyring === null || primaryKeyring === void 0 || (_primaryKeyring$metad = primaryKeyring.metadata) === null || _primaryKeyring$metad === void 0 ? void 0 : _primaryKeyring$metad.id
      }, {
        displayConfirmation: false,
        displayAccountNameSuggestion: false,
        setSelectedAccount: false
      });
    } catch (error) {
      console.error('Error creating Solana account:', error);
    } finally {
      setIsCreating(false);
    }
  }, [solanaWalletSnapClient, primaryKeyring === null || primaryKeyring === void 0 || (_primaryKeyring$metad2 = primaryKeyring.metadata) === null || _primaryKeyring$metad2 === void 0 ? void 0 : _primaryKeyring$metad2.id]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.flexStart,
    gap: 1,
    padding: 4,
    "data-testid": "solana-account-creation-prompt",
    style: {
      height: '100%',
      minHeight: '400px',
      paddingTop: '72px'
    }
  }, /*#__PURE__*/_react.default.createElement("img", {
    src: "/images/solana-logo.svg",
    alt: "Solana Logo",
    style: {
      width: '30px',
      height: '30px',
      marginBottom: '4px',
      borderRadius: '4px'
    }
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingSm,
    textAlign: _designSystem.TextAlign.Center,
    color: _designSystem.TextColor.textDefault
  }, t('bridgeCreateSolanaAccountTitle')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    textAlign: _designSystem.TextAlign.Center,
    color: _designSystem.TextColor.textAlternative
  }, t('bridgeCreateSolanaAccountDescription')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    block: true,
    size: _componentLibrary.ButtonSize.Md,
    variant: _componentLibrary.ButtonVariant.Secondary
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    ,
    onClick: handleCreateAccount,
    loading: isCreating,
    "data-testid": "create-solana-account-button",
    style: {
      width: '75%',
      marginTop: '10px'
    }
  }, t('bridgeCreateSolanaAccount')));
};
exports.SolanaAccountCreationPrompt = SolanaAccountCreationPrompt;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\asset-picker-amount\\asset-picker-modal\\solana-account-creation-prompt.tsx",}]],[],{})

//# sourceMappingURL=data:application/json;charset=utf8;base64,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