LavaPack.loadBundle([
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\asset-picker\\asset-picker.tsx", {"../../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/utils/nfts":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\nfts.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../hooks/useMultichainBalances":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainBalances.ts","../../../../hooks/useMultichainSelector":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainSelector.ts","../../../../pages/confirmations/send-legacy/send.utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\send-legacy\\send.utils.js","../../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../ui/tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\index.js","../asset-picker-modal/asset-picker-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\asset-picker-modal\\asset-picker-modal.tsx","../asset-picker-modal/asset-picker-modal-network":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\asset-picker-modal\\asset-picker-modal-network.tsx","../asset-picker-modal/asset-picker-modal-tabs":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\asset-picker-modal\\asset-picker-modal-tabs.tsx","../constants":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\constants.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Casset-picker-amount%5Casset-picker%5Casset-picker.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetPicker = AssetPicker;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _componentLibrary = require("../../../component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _transaction = require("../../../../../shared/constants/transaction");
var _assetPickerModal = require("../asset-picker-modal/asset-picker-modal");
var _tooltip = _interopRequireDefault(require("../../../ui/tooltip"));
var _constants = require("../constants");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _send = require("../../../../pages/confirmations/send-legacy/send.utils");
var _assetPickerModalTabs = require("../asset-picker-modal/asset-picker-modal-tabs");
var _assetPickerModalNetwork = require("../asset-picker-modal/asset-picker-modal-network");
var _network = require("../../../../../shared/constants/network");
var _useMultichainBalances = require("../../../../hooks/useMultichainBalances");
var _multichain = require("../../../../selectors/multichain");
var _useMultichainSelector = require("../../../../hooks/useMultichainSelector");
var _nfts = require("../../../../helpers/utils/nfts");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const ELLIPSIFY_LENGTH = 13; // 6 (start) + 4 (end) + 3 (...)

// A component that lets the user pick from a list of assets.
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function AssetPicker({
  children,
  header,
  asset,
  onAssetChange,
  networkProps,
  sendingAsset,
  action,
  onClick,
  isDisabled = false,
  visibleTabs,
  customTokenListGenerator,
  isTokenListLoading = false,
  isMultiselectEnabled = false,
  autoFocus = true,
  isDestinationToken = false
}) {
  var _networkProps$network2, _Object$entries$find;
  const t = (0, _useI18nContext.useI18nContext)();
  const [showAssetPickerModal, setShowAssetPickerModal] = (0, _react.useState)(false);
  const isNFT = (asset === null || asset === void 0 ? void 0 : asset.type) === _transaction.AssetType.NFT;

  // selected asset details
  const primaryTokenImage = asset === null || asset === void 0 ? void 0 : asset.image;
  const symbol = asset === null || asset === void 0 ? void 0 : asset.symbol;
  const isSymbolLong = symbol && symbol.length > _constants.LARGE_SYMBOL_LENGTH;
  const formattedSymbol = isSymbolLong && !isNFT ? `${symbol.substring(0, _constants.LARGE_SYMBOL_LENGTH - 1)}...` : symbol;

  // Badge details
  const currentChainId = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainCurrentChainId);
  const allNetworks = (0, _reactRedux.useSelector)(_multichain.getMultichainNetworkConfigurationsByChainId);
  // These 2 have similar data but different types
  const currentNetworkConfiguration = allNetworks[currentChainId];
  const currentNetworkProviderConfig = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainCurrentNetwork);
  const selectedNetwork = (networkProps === null || networkProps === void 0 ? void 0 : networkProps.network) ?? currentNetworkConfiguration;
  const allNetworksToUse = (networkProps === null || networkProps === void 0 ? void 0 : networkProps.networks) ?? Object.values(allNetworks);
  const {
    balanceByChainId
  } = (0, _useMultichainBalances.useMultichainBalances)();
  // This is used to determine which tokens to display when isMultiselectEnabled=true
  const [selectedChainIds, setSelectedChainIds] = (0, _react.useState)(isMultiselectEnabled ? (allNetworksToUse === null || allNetworksToUse === void 0 ? void 0 : allNetworksToUse.map(({
    chainId
  }) => chainId).sort((a, b) => balanceByChainId[b] - balanceByChainId[a])) ?? [] : []);
  const [isSelectingNetwork, setIsSelectingNetwork] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    var _networkProps$network;
    const newChainId = networkProps === null || networkProps === void 0 || (_networkProps$network = networkProps.network) === null || _networkProps$network === void 0 ? void 0 : _networkProps$network.chainId;
    newChainId && !selectedChainIds.includes(newChainId) && setSelectedChainIds(c => [...c, newChainId]);
  }, [networkProps === null || networkProps === void 0 || (_networkProps$network2 = networkProps.network) === null || _networkProps$network2 === void 0 ? void 0 : _networkProps$network2.chainId]);
  const handleAssetPickerTitle = () => {
    if (isDisabled) {
      return t('swapTokenNotAvailable');
    }
    return undefined;
  };
  const networkImageSrc = selectedNetwork !== null && selectedNetwork !== void 0 && selectedNetwork.chainId ? (0, _multichain.getImageForChainId)(selectedNetwork.chainId) : undefined;
  const handleButtonClick = () => {
    if (networkProps && !networkProps.network) {
      setIsSelectingNetwork(true);
    } else {
      setShowAssetPickerModal(true);
    }
    onClick === null || onClick === void 0 || onClick();
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, networkProps && /*#__PURE__*/_react.default.createElement(_assetPickerModalNetwork.AssetPickerModalNetwork, _extends({
    isOpen: isSelectingNetwork,
    onClose: () => setIsSelectingNetwork(false),
    onBack: () => {
      setIsSelectingNetwork(false);
      setShowAssetPickerModal(true);
    },
    isMultiselectEnabled: isMultiselectEnabled,
    onMultiselectSubmit: chainIds => {
      setSelectedChainIds(chainIds);
      // If there is only 1 selected network switch to that network to populate tokens
      if (chainIds.length === 1 && chainIds[0] !== (currentNetworkProviderConfig === null || currentNetworkProviderConfig === void 0 ? void 0 : currentNetworkProviderConfig.chainId)) {
        if (networkProps !== null && networkProps !== void 0 && networkProps.onNetworkChange) {
          networkProps.onNetworkChange(allNetworks[chainIds[0]]);
        }
      }
    },
    selectedChainIds: selectedChainIds
  }, networkProps)), /*#__PURE__*/_react.default.createElement(_assetPickerModal.AssetPickerModal, {
    visibleTabs: visibleTabs,
    header: header,
    action: action,
    isOpen: showAssetPickerModal,
    onClose: () => setShowAssetPickerModal(false),
    asset: asset,
    isDestinationToken: isDestinationToken,
    onAssetChange: token => {
      // If isMultiselectEnabled=true, update the network when a token is selected
      if (isMultiselectEnabled && networkProps !== null && networkProps !== void 0 && networkProps.onNetworkChange) {
        const networkFromToken = token.chainId ? allNetworks[token.chainId] : undefined;
        if (networkFromToken) {
          networkProps.onNetworkChange(networkFromToken);
        }
      }
      onAssetChange(token);
      setShowAssetPickerModal(false);
    },
    isMultiselectEnabled: isMultiselectEnabled,
    sendingAsset: sendingAsset,
    network: networkProps === null || networkProps === void 0 ? void 0 : networkProps.network,
    networks: networkProps === null || networkProps === void 0 ? void 0 : networkProps.networks,
    selectedChainIds: selectedChainIds,
    onNetworkPickerClick: networkProps !== null && networkProps !== void 0 && networkProps.networks ? () => {
      setShowAssetPickerModal(false);
      setIsSelectingNetwork(true);
    } : undefined,
    defaultActiveTabKey: (asset === null || asset === void 0 ? void 0 : asset.type) === _transaction.AssetType.NFT ? _assetPickerModalTabs.TabName.NFTS : _assetPickerModalTabs.TabName.TOKENS,
    customTokenListGenerator: customTokenListGenerator,
    isTokenListLoading: isTokenListLoading,
    autoFocus: autoFocus
  }), (children === null || children === void 0 ? void 0 : children(handleButtonClick, networkImageSrc)) || /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonBase, {
    "data-testid": "asset-picker-button",
    className: "asset-picker",
    disabled: isDisabled,
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    gap: 2,
    padding: 2,
    paddingLeft: 2,
    paddingRight: 2,
    justifyContent: isNFT ? _designSystem.JustifyContent.spaceBetween : undefined,
    backgroundColor: _designSystem.BackgroundColor.transparent,
    onClick: handleButtonClick,
    endIconName: _componentLibrary.IconName.ArrowDown,
    endIconProps: {
      color: _designSystem.IconColor.iconDefault,
      marginInlineStart: 0,
      display: isDisabled ? _designSystem.Display.None : _designSystem.Display.InlineBlock
    },
    title: handleAssetPickerTitle()
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    gap: 3
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.BadgeWrapper, {
    badge: /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
      size: _componentLibrary.AvatarNetworkSize.Xs,
      name: (selectedNetwork === null || selectedNetwork === void 0 ? void 0 : selectedNetwork.name) ?? '',
      src: networkImageSrc,
      borderWidth: 2,
      backgroundColor: (_Object$entries$find = Object.entries({
        [_network.GOERLI_DISPLAY_NAME]: _designSystem.BackgroundColor.goerli,
        [_network.SEPOLIA_DISPLAY_NAME]: _designSystem.BackgroundColor.sepolia
      }).find(([tickerSubstring]) => {
        var _selectedNetwork$nati;
        return selectedNetwork === null || selectedNetwork === void 0 || (_selectedNetwork$nati = selectedNetwork.nativeCurrency) === null || _selectedNetwork$nati === void 0 ? void 0 : _selectedNetwork$nati.includes(tickerSubstring);
      })) === null || _Object$entries$find === void 0 ? void 0 : _Object$entries$find[1],
      borderColor: primaryTokenImage ? _designSystem.BorderColor.borderMuted : _designSystem.BorderColor.borderDefault
    })
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarToken, _extends({
    borderRadius: isNFT ? _designSystem.BorderRadius.LG : _designSystem.BorderRadius.full,
    src: (0, _nfts.getNftImage)(primaryTokenImage) ?? undefined,
    size: _componentLibrary.AvatarTokenSize.Md,
    name: symbol
  }, isNFT && {
    backgroundColor: _designSystem.BackgroundColor.transparent
  })))), /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    disabled: !isSymbolLong,
    title: symbol,
    position: "bottom",
    wrapperClassName: "mm-box"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    className: "asset-picker__symbol",
    variant: _designSystem.TextVariant.bodyMd,
    color: _designSystem.TextColor.textDefault
  }, formattedSymbol), isNFT && (asset === null || asset === void 0 ? void 0 : asset.tokenId) && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative
  }, "#", String(asset.tokenId).length < ELLIPSIFY_LENGTH ? asset.tokenId : (0, _send.ellipsify)(String(asset.tokenId), 6, 4))))));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\asset-picker-amount\\asset-picker\\asset-picker.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\asset-picker\\index.ts", {"./asset-picker":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\asset-picker\\asset-picker.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Casset-picker-amount%5Casset-picker%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "AssetPicker", {
  enumerable: true,
  get: function () {
    return _assetPicker.AssetPicker;
  }
});
var _assetPicker = require("./asset-picker");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\asset-picker-amount\\asset-picker\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\constants.tsx", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Casset-picker-amount%5Cconstants.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LARGE_SYMBOL_LENGTH = void 0;
const LARGE_SYMBOL_LENGTH = exports.LARGE_SYMBOL_LENGTH = 7;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\asset-picker-amount\\constants.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\index.ts", {"./asset-picker-amount":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\asset-picker-amount.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Casset-picker-amount%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "AssetPickerAmount", {
  enumerable: true,
  get: function () {
    return _assetPickerAmount.AssetPickerAmount;
  }
});
var _assetPickerAmount = require("./asset-picker-amount");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\asset-picker-amount\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\max-clear-button.tsx", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../ducks/send":"D:\\code\\v\\metamask-extension\\ui\\ducks\\send\\index.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Casset-picker-amount%5Cmax-clear-button.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = MaxClearButton;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _send = require("../../../ducks/send");
var _metametrics = require("../../../contexts/metametrics");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _componentLibrary = require("../../component-library");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _designSystem = require("../../../helpers/constants/design-system");
var _transaction = require("../../../../shared/constants/transaction");
var _conversion = require("../../../../shared/modules/conversion.utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// A button that updates the send amount to max balance or 0.
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function MaxClearButton({
  asset
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  const maxModeOn = (0, _reactRedux.useSelector)(_send.getSendMaxModeState);
  const dispatch = (0, _reactRedux.useDispatch)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const sendAnalytics = (0, _reactRedux.useSelector)(_send.getSendAnalyticProperties);
  const onClick = () => {
    trackEvent({
      event: 'Clicked "Amount Max"',
      category: _metametrics2.MetaMetricsEventCategory.Transactions,
      properties: {
        ...sendAnalytics,
        action: 'Edit Screen',
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        legacy_event: true
      }
    });
    dispatch((0, _send.toggleSendMaxMode)());
  };
  return asset.type === _transaction.AssetType.NFT || Number((0, _conversion.hexToDecimal)(asset.balance || '0x0')) <= 0 ? null : /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    className: "asset-picker-amount__max-clear",
    onClick: onClick,
    marginLeft: "auto",
    textProps: {
      variant: _designSystem.TextVariant.bodySm
    },
    "data-testid": "max-clear-button"
  }, maxModeOn ? t('clear') : t('max'));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\asset-picker-amount\\max-clear-button.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\nft-input\\nft-input.tsx", {"../../../../../shared/modules/Numeric":"D:\\code\\v\\metamask-extension\\shared\\modules\\Numeric.ts","../../../ui/unit-input":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\unit-input\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Casset-picker-amount%5Cnft-input%5Cnft-input.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NFTInput = NFTInput;
var _react = _interopRequireDefault(require("react"));
var _unitInput = _interopRequireDefault(require("../../../ui/unit-input"));
var _Numeric = require("../../../../../shared/modules/Numeric");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const NUMBERS_REGEX = /^[0-9]*$/u;

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function NFTInput({
  integerValue,
  onChange,
  className
}) {
  const handleChange = newValueAsString => {
    if (!onChange) {
      return;
    }
    const newValue = new _Numeric.Numeric(newValueAsString, 10);
    if (!Number.isInteger(newValue.toNumber())) {
      return;
    }
    onChange(newValue.toPrefixedHexString(), String(newValueAsString));
  };
  return /*#__PURE__*/_react.default.createElement(_unitInput.default, {
    isDisabled: !onChange,
    isFocusOnInput: Boolean(onChange),
    type: "number",
    step: 1,
    min: 0,
    dataTestId: "nft-input",
    onChange: handleChange,
    value: integerValue,
    className: className,
    keyPressRegex: NUMBERS_REGEX
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\asset-picker-amount\\nft-input\\nft-input.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\swappable-currency-input\\swap-icon.tsx", {"../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Casset-picker-amount%5Cswappable-currency-input%5Cswap-icon.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = SwapIcon;
var _react = _interopRequireDefault(require("react"));
var _designSystem = require("../../../../helpers/constants/design-system");
var _componentLibrary = require("../../../component-library");
var _useI18nContext = require("../../../../hooks/useI18nContext");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function SwapIcon({
  onClick
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    backgroundColor: _designSystem.BackgroundColor.transparent,
    iconName: _componentLibrary.IconName.SwapVertical,
    size: _componentLibrary.ButtonIconSize.Sm,
    color: _designSystem.IconColor.primaryDefault,
    onClick: onClick,
    ariaLabel: t('switchInputCurrency'),
    className: "asset-picker-amount__input__swap"
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\asset-picker-amount\\swappable-currency-input\\swap-icon.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\swappable-currency-input\\swappable-currency-input.tsx", {"../../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../../ducks/app/app":"D:\\code\\v\\metamask-extension\\ui\\ducks\\app\\app.ts","../../../../ducks/send":"D:\\code\\v\\metamask-extension\\ui\\ducks\\send\\index.js","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../app/currency-input":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\currency-input\\index.js","../../../app/currency-input/hooks/useTokenExchangeRate":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\currency-input\\hooks\\useTokenExchangeRate.tsx","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../nft-input/nft-input":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\nft-input\\nft-input.tsx","../utils":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\utils.ts","./swap-icon":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\swappable-currency-input\\swap-icon.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Casset-picker-amount%5Cswappable-currency-input%5Cswappable-currency-input.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SwappableCurrencyInput = SwappableCurrencyInput;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _send = require("../../../../ducks/send");
var _app = require("../../../../ducks/app/app");
var _transaction = require("../../../../../shared/constants/transaction");
var _componentLibrary = require("../../../component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _currencyInput = _interopRequireDefault(require("../../../app/currency-input"));
var _utils = require("../utils");
var _nftInput = require("../nft-input/nft-input");
var _useTokenExchangeRate = _interopRequireDefault(require("../../../app/currency-input/hooks/useTokenExchangeRate"));
var _swapIcon = _interopRequireDefault(require("./swap-icon"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function SwappableCurrencyInput({
  assetType,
  asset,
  amount: {
    value
  },
  isAmountLoading,
  onAmountChange
}) {
  var _asset$details, _asset$details2, _asset$details3;
  const dispatch = (0, _reactRedux.useDispatch)();
  const t = (0, _useI18nContext.useI18nContext)();
  const isFiatPrimary = (0, _reactRedux.useSelector)(_utils.getIsFiatPrimary);
  const tokenToFiatConversionRate = (0, _useTokenExchangeRate.default)(asset === null || asset === void 0 || (_asset$details = asset.details) === null || _asset$details === void 0 ? void 0 : _asset$details.address);
  const isSetToMax = (0, _reactRedux.useSelector)(_send.getSendMaxModeState);
  const TokenComponent = /*#__PURE__*/_react.default.createElement(_currencyInput.default, {
    className: "asset-picker-amount__input",
    isFiatPreferred: isFiatPrimary && Boolean(tokenToFiatConversionRate === null || tokenToFiatConversionRate === void 0 ? void 0 : tokenToFiatConversionRate.toNumber()),
    onChange: onAmountChange // onChange controls disabled state, disabled if undefined
    ,
    hexValue: value,
    swapIcon: onClick => /*#__PURE__*/_react.default.createElement(_swapIcon.default, {
      onClick: onClick
    }),
    onPreferenceToggle: (0, _react.useCallback)(() => dispatch((0, _app.toggleCurrencySwitch)()), [dispatch]),
    asset: asset === null || asset === void 0 ? void 0 : asset.details,
    isSkeleton: isAmountLoading,
    isMatchingUpstream: isSetToMax
  });
  const NFTComponent = /*#__PURE__*/_react.default.createElement(_nftInput.NFTInput, {
    integerValue: parseInt(value, 16),
    onChange: onAmountChange,
    className: "asset-picker-amount__input-nft"
  });
  switch (assetType) {
    case _transaction.AssetType.token:
    case _transaction.AssetType.native:
      return TokenComponent;
    case _transaction.AssetType.NFT:
      return ((_asset$details2 = asset.details) === null || _asset$details2 === void 0 ? void 0 : _asset$details2.standard) === _transaction.TokenStandard.ERC721 ? null : NFTComponent;
    default:
    // do nothing
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginLeft: 'auto'
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm
  }, t('tokenId')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    fontWeight: _designSystem.FontWeight.Bold,
    marginLeft: 10
  }, asset === null || asset === void 0 || (_asset$details3 = asset.details) === null || _asset$details3 === void 0 ? void 0 : _asset$details3.tokenId));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\asset-picker-amount\\swappable-currency-input\\swappable-currency-input.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\utils.ts", {"reselect":"D:\\code\\v\\metamask-extension\\node_modules\\reselect\\dist\\cjs\\reselect.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Casset-picker-amount%5Cutils.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIsFiatPrimary = void 0;
var _reselect = require("reselect");
function getSendInputCurrencySwitched(state) {
  return state.appState.sendInputCurrencySwitched;
}
const getIsFiatPrimary = exports.getIsFiatPrimary = (0, _reselect.createSelector)(getSendInputCurrencySwitched, sendInputCurrencySwitched => {
  const isFiatPrimary = Boolean(sendInputCurrencySwitched);
  return isFiatPrimary;
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\asset-picker-amount\\utils.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\badge-status\\badge-status.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../app/preferred-avatar":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\preferred-avatar\\index.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\index.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cbadge-status%5Cbadge-status.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BadgeStatus = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../component-library");
var _preferredAvatar = require("../../app/preferred-avatar");
var _tooltip = _interopRequireDefault(require("../../ui/tooltip"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const TooltipStyle = {
  display: 'flex'
};
const BadgeStatus = ({
  className = '',
  badgeBackgroundColor = _designSystem.BackgroundColor.backgroundAlternative,
  badgeBorderColor = _designSystem.BorderColor.borderMuted,
  address,
  isConnectedAndNotActive = false,
  showConnectedStatus = true,
  text,
  ...props
}) => {
  const tooltipContents = (0, _react.useMemo)(() => {
    let positionObj;
    if (showConnectedStatus) {
      positionObj = isConnectedAndNotActive ? {
        bottom: '-4%',
        right: '-12%'
      } : {
        bottom: '-10%',
        right: '-20%'
      };
    }
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.BadgeWrapper, {
      positionObj: positionObj,
      badge: showConnectedStatus && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        className: (0, _classnames.default)('multichain-badge-status__badge', {
          'multichain-badge-status__badge-not-connected': isConnectedAndNotActive
        }),
        backgroundColor: badgeBackgroundColor,
        borderRadius: _designSystem.BorderRadius.full,
        borderColor: badgeBorderColor,
        borderWidth: 2
      })
    }, /*#__PURE__*/_react.default.createElement(_preferredAvatar.PreferredAvatar, {
      address: address,
      className: "flex"
    }));
  }, [address, badgeBackgroundColor, badgeBorderColor, isConnectedAndNotActive, showConnectedStatus]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, _extends({
    className: (0, _classnames.default)('multichain-badge-status pr-1', className),
    "data-testid": "multichain-badge-status",
    as: "button",
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    backgroundColor: _designSystem.BackgroundColor.transparent
  }, props), showConnectedStatus ? /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    style: TooltipStyle,
    title: text,
    "data-testid": "multichain-badge-status__tooltip",
    position: "bottom"
  }, tooltipContents) : tooltipContents);
};
exports.BadgeStatus = BadgeStatus;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\badge-status\\badge-status.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\badge-status\\index.ts", {"./badge-status":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\badge-status\\badge-status.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cbadge-status%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "BadgeStatus", {
  enumerable: true,
  get: function () {
    return _badgeStatus.BadgeStatus;
  }
});
var _badgeStatus = require("./badge-status");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\badge-status\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\carousel\\animations\\animationTimings.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Ccarousel%5Canimations%5CanimationTimings.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.ANIMATION_TIMINGS = exports.ANIMATION_EASINGS = void 0;
// Centralized animation timing configuration
const ANIMATION_TIMINGS = exports.ANIMATION_TIMINGS = {
  // Card transition timings (slowed by 50ms)
  CARD_TRANSITION_DURATION: 400,
  CARD_EXIT_DURATION: 300,
  CARD_ENTER_DURATION: 250,
  CARD_ENTER_DELAY: 100,
  // Empty state timings
  EMPTY_STATE_IDLE_TIME: 1000,
  // 1 second pause before fold
  EMPTY_STATE_DURATION: 350,
  // Total fold animation duration
  EMPTY_STATE_FADE_DURATION: 200,
  EMPTY_STATE_FOLD_DURATION: 300,
  // Carousel fold animation
  CAROUSEL_FOLD_DURATION: 350
};

// Animation easing functions
const ANIMATION_EASINGS = exports.ANIMATION_EASINGS = {
  EASE_IN_OUT: 'ease-in-out',
  EASE_OUT: 'ease-out',
  CUBIC_BEZIER_SMOOTH: 'cubic-bezier(0.33, 1, 0.68, 1)'
};

// Export for external use
var _default = exports.default = ANIMATION_TIMINGS;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\carousel\\animations\\animationTimings.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\carousel\\animations\\index.ts", {"./animationTimings":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\carousel\\animations\\animationTimings.ts","./useTransitionToEmpty":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\carousel\\animations\\useTransitionToEmpty.ts","./useTransitionToNextCard":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\carousel\\animations\\useTransitionToNextCard.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Ccarousel%5Canimations%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ANIMATION_EASINGS", {
  enumerable: true,
  get: function () {
    return _animationTimings.ANIMATION_EASINGS;
  }
});
Object.defineProperty(exports, "ANIMATION_TIMINGS", {
  enumerable: true,
  get: function () {
    return _animationTimings.ANIMATION_TIMINGS;
  }
});
Object.defineProperty(exports, "useTransitionToEmpty", {
  enumerable: true,
  get: function () {
    return _useTransitionToEmpty.useTransitionToEmpty;
  }
});
Object.defineProperty(exports, "useTransitionToNextCard", {
  enumerable: true,
  get: function () {
    return _useTransitionToNextCard.useTransitionToNextCard;
  }
});
var _animationTimings = require("./animationTimings");
var _useTransitionToNextCard = require("./useTransitionToNextCard");
var _useTransitionToEmpty = require("./useTransitionToEmpty");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\carousel\\animations\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\carousel\\animations\\useTransitionToEmpty.ts", {"./animationTimings":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\carousel\\animations\\animationTimings.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Ccarousel%5Canimations%5CuseTransitionToEmpty.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTransitionToEmpty = void 0;
var _react = require("react");
var _animationTimings = require("./animationTimings");
/**
 * Hook for managing transition to empty state and fold-up animation
 * Encapsulates the timing sequence: appear → pause → fold → complete
 *
 * @param props - Configuration object for the empty state transition
 * @param props.onEmptyStateComplete - Callback when empty state animation completes
 * @returns Object with state and control functions for empty state animation
 */
const useTransitionToEmpty = ({
  onEmptyStateComplete
}) => {
  const [emptyStatePhase, setEmptyStatePhase] = (0, _react.useState)('hidden');
  const foldTimeoutRef = (0, _react.useRef)();
  const triggerFoldAnimation = (0, _react.useCallback)(() => {
    setEmptyStatePhase('folding');

    // Complete after fold animation
    foldTimeoutRef.current = setTimeout(() => {
      setEmptyStatePhase('complete');
      onEmptyStateComplete();
    }, _animationTimings.ANIMATION_TIMINGS.EMPTY_STATE_DURATION);
  }, [onEmptyStateComplete]);
  const startEmptyStateSequence = (0, _react.useCallback)(() => {
    setEmptyStatePhase('showing');
  }, []);

  // Cleanup timeouts on unmount
  (0, _react.useEffect)(() => {
    return () => {
      if (foldTimeoutRef.current) {
        clearTimeout(foldTimeoutRef.current);
      }
    };
  }, []);

  // Auto-trigger fold after a brief delay to allow component to stabilize
  (0, _react.useEffect)(() => {
    if (emptyStatePhase === 'showing') {
      const stabilizationTimer = setTimeout(() => {
        triggerFoldAnimation();
      }, 100); // Very brief delay just to let the component render properly

      return () => clearTimeout(stabilizationTimer);
    }
    return undefined;
  }, [emptyStatePhase, triggerFoldAnimation]);
  const resetEmptyState = (0, _react.useCallback)(() => {
    setEmptyStatePhase('hidden');
  }, []);
  return {
    emptyStatePhase,
    startEmptyStateSequence,
    triggerFoldAnimation,
    resetEmptyState,
    isEmptyStateVisible: emptyStatePhase === 'showing' || emptyStatePhase === 'folding',
    isEmptyStateFolding: emptyStatePhase === 'folding'
  };
};
exports.useTransitionToEmpty = useTransitionToEmpty;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\carousel\\animations\\useTransitionToEmpty.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\carousel\\animations\\useTransitionToNextCard.ts", {"./animationTimings":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\carousel\\animations\\animationTimings.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Ccarousel%5Canimations%5CuseTransitionToNextCard.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTransitionToNextCard = void 0;
var _react = require("react");
var _animationTimings = require("./animationTimings");
/**
 * Hook for managing transition from current card to next card
 * Encapsulates the animation timing and state management
 *
 * @param props - Configuration object for the transition hook
 * @param props.onSlideRemove - Callback to remove a slide
 * @param props.isTransitioning - Current transition state
 * @param props.setIsTransitioning - Function to update transition state
 * @returns Object containing transition function and current state
 */
const useTransitionToNextCard = ({
  onSlideRemove,
  isTransitioning,
  setIsTransitioning
}) => {
  const timeoutRef = (0, _react.useRef)();

  // Cleanup timeout on unmount
  (0, _react.useEffect)(() => {
    return () => {
      if (timeoutRef.current) {
        clearTimeout(timeoutRef.current);
      }
    };
  }, []);
  const transitionToNextCard = (0, _react.useCallback)((slideId, isLastSlide) => {
    if (isTransitioning) {
      return;
    }
    setIsTransitioning(true);

    // Remove the slide immediately - TransitionGroup will handle smooth animations
    onSlideRemove(slideId, isLastSlide);

    // Reset transition state after animation completes
    timeoutRef.current = setTimeout(() => {
      setIsTransitioning(false);
    }, _animationTimings.ANIMATION_TIMINGS.CARD_EXIT_DURATION + 50); // Small buffer for animation completion
  }, [onSlideRemove, isTransitioning, setIsTransitioning]);
  return {
    transitionToNextCard,
    isTransitioning
  };
};
exports.useTransitionToNextCard = useTransitionToNextCard;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\carousel\\animations\\useTransitionToNextCard.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\carousel\\carousel-wrapper.tsx", {"./carousel":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\carousel\\carousel.tsx","./stack-card-empty":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\carousel\\stack-card-empty\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Ccarousel%5Ccarousel-wrapper.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CarouselWithEmptyState = void 0;
var _react = _interopRequireWildcard(require("react"));
var _carousel = require("./carousel");
var _stackCardEmpty = require("./stack-card-empty");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const CarouselWithEmptyState = props => {
  const [showFoldAnimation, setShowFoldAnimation] = (0, _react.useState)(false);
  const [hasCompletedEmptyState, setHasCompletedEmptyState] = (0, _react.useState)(false);
  const [hasEverHadSlides, setHasEverHadSlides] = (0, _react.useState)(false);

  // Calculate visible slides (non-dismissed) to prevent infinite loop
  const visibleSlidesCount = (0, _react.useMemo)(() => {
    return (props.slides || []).filter(slide => !slide.dismissed).length;
  }, [props.slides]);

  // Track if user has ever seen slides
  _react.default.useEffect(() => {
    if (visibleSlidesCount > 0 && !hasEverHadSlides) {
      setHasEverHadSlides(true);
    }
  }, [visibleSlidesCount, hasEverHadSlides]);
  const handleEmptyState = () => {
    if (!hasCompletedEmptyState && !showFoldAnimation) {
      setShowFoldAnimation(true);
    }
  };
  const handleEmptyStateComplete = () => {
    setShowFoldAnimation(false);
    setHasCompletedEmptyState(true); // Mark as completed to prevent re-triggering
  };

  // Reset when new visible slides become available (not just any slides)
  _react.default.useEffect(() => {
    if (visibleSlidesCount > 0 && hasCompletedEmptyState) {
      setHasCompletedEmptyState(false);
    }
  }, [visibleSlidesCount, hasCompletedEmptyState]);

  // Show the fold-up animation when triggered by carousel
  if (showFoldAnimation) {
    return /*#__PURE__*/_react.default.createElement(_stackCardEmpty.EmptyStateComponent, {
      onComplete: handleEmptyStateComplete
    });
  }

  // If empty state was completed and there are no visible slides, don't show carousel at all
  // This prevents infinite loops where dismissed slides cause the carousel to re-appear
  if (hasCompletedEmptyState && visibleSlidesCount === 0) {
    return null;
  }

  // If we never had slides and there are no slides, don't show anything
  if (!hasEverHadSlides && visibleSlidesCount === 0) {
    return null;
  }

  // Show carousel with proper empty state callback
  return /*#__PURE__*/_react.default.createElement(_carousel.Carousel, _extends({}, props, {
    onEmptyState: handleEmptyState
  }));
};
exports.CarouselWithEmptyState = CarouselWithEmptyState;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\carousel\\carousel-wrapper.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\carousel\\carousel.tsx", {"../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","./animations/useTransitionToNextCard":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\carousel\\animations\\useTransitionToNextCard.ts","./constants":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\carousel\\constants.ts","./stack-card":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\carousel\\stack-card\\index.ts","./stack-card-empty":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\carousel\\stack-card-empty\\index.ts","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-transition-group":"D:\\code\\v\\metamask-extension\\node_modules\\react-transition-group\\cjs\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Ccarousel%5Ccarousel.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Carousel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _keyringApi = require("@metamask/keyring-api");
var _reactTransitionGroup = require("react-transition-group");
var _componentLibrary = require("../../component-library");
var _selectors = require("../../../selectors");
var _constants = require("./constants");
var _stackCard = require("./stack-card");
var _stackCardEmpty = require("./stack-card-empty");
var _useTransitionToNextCard = require("./animations/useTransitionToNextCard");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const Carousel = exports.Carousel = /*#__PURE__*/_react.default.forwardRef(({
  slides = [],
  isLoading = false,
  onSlideClose,
  onSlideClick,
  onRenderSlides,
  onEmptyState,
  className = '',
  ...props
}, ref) => {
  const [state, setState] = (0, _react.useState)({
    activeSlideIndex: 0,
    isTransitioning: false,
    hasTriggeredEmptyState: false
  });
  const selectedAccount = (0, _reactRedux.useSelector)(_selectors.getSelectedAccount);
  const emptyStateTimeoutRef = (0, _react.useRef)();

  // Cleanup timeout on unmount
  (0, _react.useEffect)(() => {
    return () => {
      if (emptyStateTimeoutRef.current) {
        clearTimeout(emptyStateTimeoutRef.current);
      }
    };
  }, []);

  // Filter visible slides
  const visibleSlides = slides.filter(slide => {
    if (slide.variableName === 'solana' && (selectedAccount === null || selectedAccount === void 0 ? void 0 : selectedAccount.type) === _keyringApi.SolAccountType.DataAccount) {
      return false;
    }
    // All cards are dismissable in this implementation - ignore undismissable property
    return !slide.dismissed;
  }).slice(0, _constants.MAX_SLIDES);
  const currentSlide = visibleSlides[state.activeSlideIndex];
  const nextSlide = visibleSlides[state.activeSlideIndex + 1];
  const isLastCard = visibleSlides.length === 1 && Boolean(currentSlide);

  // Use transition hook for next card logic
  const {
    transitionToNextCard
  } = (0, _useTransitionToNextCard.useTransitionToNextCard)({
    onSlideRemove: (slideId, isLastSlide) => {
      if (onSlideClose) {
        onSlideClose(slideId, isLastSlide);
      }

      // If this was the last slide, trigger empty state after animation
      if (isLastSlide && onEmptyState) {
        // Clear any existing timeout first
        if (emptyStateTimeoutRef.current) {
          clearTimeout(emptyStateTimeoutRef.current);
        }
        emptyStateTimeoutRef.current = setTimeout(() => {
          onEmptyState();
        }, 300); // Wait for slide exit animation to complete
      }
    },
    isTransitioning: state.isTransitioning,
    setIsTransitioning: transitioning => {
      setState(prev => ({
        ...prev,
        isTransitioning: transitioning
      }));
    }
  });

  // Handle slide array changes
  (0, _react.useEffect)(() => {
    if (visibleSlides.length > 0 && state.activeSlideIndex >= visibleSlides.length) {
      setState(prev => ({
        ...prev,
        activeSlideIndex: 0
      }));
    }

    // Reset empty state trigger flag when new slides are available
    if (visibleSlides.length > 0 && state.hasTriggeredEmptyState) {
      setState(prev => ({
        ...prev,
        hasTriggeredEmptyState: false
      }));
    }
  }, [visibleSlides.length, state.activeSlideIndex, state.hasTriggeredEmptyState]);

  // Render slides callback
  (0, _react.useEffect)(() => {
    if (visibleSlides && visibleSlides.length > 0 && onRenderSlides && !isLoading) {
      onRenderSlides(visibleSlides);
    }
  }, [visibleSlides, onRenderSlides, isLoading]);
  const handleSlideClose = (slideId, isLastSlide) => {
    transitionToNextCard(slideId, isLastSlide);
  };
  const handleSlideClick = (slideId, navigation) => {
    if (state.isTransitioning) {
      return;
    }
    onSlideClick === null || onSlideClick === void 0 || onSlideClick(slideId, navigation);
  };

  // Loading state
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, _extends({
      className: `carousel-container ${className}`,
      ref: ref
    }, props), /*#__PURE__*/_react.default.createElement("div", {
      className: "carousel-cards-wrapper"
    }, [...Array(3)].map((_, index) => /*#__PURE__*/_react.default.createElement("div", {
      key: `skeleton-${index}`,
      className: "carousel-card carousel-card--current",
      style: {
        backgroundColor: 'var(--color-background-muted)',
        animation: 'pulse 2s cubic-bezier(0.4, 0, 0.6, 1) infinite'
      }
    }))));
  }

  // When no slides, don't show anything - let the wrapper handle this case
  if (visibleSlides.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, _extends({
    className: `carousel-container ${className}`,
    ref: ref
  }, props), /*#__PURE__*/_react.default.createElement("div", {
    className: "carousel-cards-wrapper"
  }, /*#__PURE__*/_react.default.createElement(_reactTransitionGroup.TransitionGroup, null, nextSlide && /*#__PURE__*/_react.default.createElement(_reactTransitionGroup.CSSTransition, {
    key: `next-${nextSlide.id}`,
    timeout: 250,
    classNames: "next-card"
  }, /*#__PURE__*/_react.default.createElement(_stackCard.StackCard, {
    slide: nextSlide,
    isCurrentCard: false,
    isLastSlide: false,
    onSlideClick: handleSlideClick,
    onTransitionToNextCard: handleSlideClose
  })), isLastCard && /*#__PURE__*/_react.default.createElement(_reactTransitionGroup.CSSTransition, {
    key: "empty-state-bg",
    timeout: 250,
    classNames: "next-card"
  }, /*#__PURE__*/_react.default.createElement(_stackCardEmpty.StackCardEmpty, {
    isBackground: true
  })), currentSlide && /*#__PURE__*/_react.default.createElement(_reactTransitionGroup.CSSTransition, {
    key: `current-${currentSlide.id}`,
    timeout: 300,
    classNames: "card"
  }, /*#__PURE__*/_react.default.createElement(_stackCard.StackCard, {
    slide: currentSlide,
    isCurrentCard: true,
    isLastSlide: isLastCard,
    onSlideClick: handleSlideClick,
    onTransitionToNextCard: handleSlideClose
  })))));
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\carousel\\carousel.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\carousel\\constants.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Ccarousel%5Cconstants.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Z_INDEX = exports.SCALE_VALUES = exports.MAX_SLIDES = exports.LAYOUT_CONSTANTS = exports.ANIMATION_TIMINGS = void 0;
// Animation Timing Constants
const ANIMATION_TIMINGS = exports.ANIMATION_TIMINGS = {
  // Card transition timings (slowed by 50ms)
  CARD_TRANSITION_DURATION: 400,
  CARD_EXIT_DURATION: 300,
  CARD_ENTER_DURATION: 250,
  CARD_ENTER_DELAY: 100,
  // Empty state timings
  EMPTY_STATE_IDLE_TIME: 1000,
  // 1 second pause before fold
  EMPTY_STATE_DURATION: 350,
  // Total fold animation duration
  EMPTY_STATE_FADE_DURATION: 200,
  EMPTY_STATE_FOLD_DURATION: 300,
  // Carousel fold animation
  CAROUSEL_FOLD_DURATION: 350
};

// Layout Constants
const LAYOUT_CONSTANTS = exports.LAYOUT_CONSTANTS = {
  CONTAINER_HEIGHT: 106,
  // BANNER_HEIGHT + 6px
  CARD_HEIGHT: 100,
  // BANNER_HEIGHT
  IMAGE_SIZE: 72,
  // Image width and height
  CARD_PADDING_HORIZONTAL: 16,
  CARD_PADDING_VERTICAL: 12,
  IMAGE_TEXT_GAP: 16,
  TEXT_HEADER_GAP: 8,
  TEXT_BODY_MARGIN_TOP: 4
};

// Z-Index Values
const Z_INDEX = exports.Z_INDEX = {
  NEXT_CARD: 1,
  CURRENT_CARD: 2,
  EXITING_CARD: 3
};

// Scale Values for Animations
const SCALE_VALUES = exports.SCALE_VALUES = {
  CURRENT_CARD: 1,
  NEXT_CARD: 0.95,
  EXIT_CARD: 1.015
};

// Max slides allowed
const MAX_SLIDES = exports.MAX_SLIDES = 8;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\carousel\\constants.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\carousel\\index.ts", {"./animations":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\carousel\\animations\\index.ts","./animations/animationTimings":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\carousel\\animations\\animationTimings.ts","./carousel":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\carousel\\carousel.tsx","./carousel-wrapper":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\carousel\\carousel-wrapper.tsx","./stack-card":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\carousel\\stack-card\\index.ts","./stack-card-empty":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\carousel\\stack-card-empty\\index.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Ccarousel%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ANIMATION_TIMINGS", {
  enumerable: true,
  get: function () {
    return _animationTimings.ANIMATION_TIMINGS;
  }
});
Object.defineProperty(exports, "Carousel", {
  enumerable: true,
  get: function () {
    return _carousel.Carousel;
  }
});
Object.defineProperty(exports, "CarouselWithEmptyState", {
  enumerable: true,
  get: function () {
    return _carouselWrapper.CarouselWithEmptyState;
  }
});
Object.defineProperty(exports, "EmptyStateComponent", {
  enumerable: true,
  get: function () {
    return _stackCardEmpty.EmptyStateComponent;
  }
});
Object.defineProperty(exports, "StackCard", {
  enumerable: true,
  get: function () {
    return _stackCard.StackCard;
  }
});
Object.defineProperty(exports, "StackCardEmpty", {
  enumerable: true,
  get: function () {
    return _stackCardEmpty.StackCardEmpty;
  }
});
Object.defineProperty(exports, "useTransitionToEmpty", {
  enumerable: true,
  get: function () {
    return _animations.useTransitionToEmpty;
  }
});
Object.defineProperty(exports, "useTransitionToNextCard", {
  enumerable: true,
  get: function () {
    return _animations.useTransitionToNextCard;
  }
});
var _carousel = require("./carousel");
var _carouselWrapper = require("./carousel-wrapper");
var _stackCard = require("./stack-card");
var _stackCardEmpty = require("./stack-card-empty");
var _animations = require("./animations");
var _animationTimings = require("./animations/animationTimings");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\carousel\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\carousel\\stack-card-empty\\index.ts", {"./stack-card-empty":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\carousel\\stack-card-empty\\stack-card-empty.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Ccarousel%5Cstack-card-empty%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EmptyStateComponent", {
  enumerable: true,
  get: function () {
    return _stackCardEmpty.EmptyStateComponent;
  }
});
Object.defineProperty(exports, "StackCardEmpty", {
  enumerable: true,
  get: function () {
    return _stackCardEmpty.StackCardEmpty;
  }
});
var _stackCardEmpty = require("./stack-card-empty");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\carousel\\stack-card-empty\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\carousel\\stack-card-empty\\stack-card-empty.tsx", {"../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../animations/useTransitionToEmpty":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\carousel\\animations\\useTransitionToEmpty.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Ccarousel%5Cstack-card-empty%5Cstack-card-empty.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StackCardEmpty = exports.EmptyStateComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _componentLibrary = require("../../../component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _useTransitionToEmpty = require("../animations/useTransitionToEmpty");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Background empty card for stacking behind last card
const StackCardEmpty = ({
  isBackground = true,
  className = ''
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement("div", {
    className: `carousel-card ${isBackground ? 'carousel-card--next' : 'carousel-card--current'} ${className}`
  }, isBackground && /*#__PURE__*/_react.default.createElement("div", {
    className: "carousel-card__pressed-overlay"
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "carousel-empty-state"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: _designSystem.TextColor.textAlternative,
    className: "carousel-empty-state__text"
  }, t('carouselAllCaughtUp'))));
};

// Main empty state component with fold animation
exports.StackCardEmpty = StackCardEmpty;
const EmptyStateComponent = ({
  onComplete,
  isBackground = false
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    startEmptyStateSequence,
    isEmptyStateFolding
  } = (0, _useTransitionToEmpty.useTransitionToEmpty)({
    onEmptyStateComplete: onComplete
  });
  (0, _react.useEffect)(() => {
    if (!isBackground) {
      startEmptyStateSequence();
    }
  }, [isBackground, startEmptyStateSequence]);
  if (isBackground) {
    return /*#__PURE__*/_react.default.createElement(StackCardEmpty, {
      isBackground: true
    });
  }

  // Standalone empty state with fold-up animation
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "carousel-container",
    style: {
      padding: '0 16px',
      height: isEmptyStateFolding ? '0px' : '106px',
      transition: isEmptyStateFolding ? 'height 300ms ease-in-out' : 'none',
      overflow: 'hidden'
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "carousel-cards-wrapper",
    style: {
      height: '100px',
      opacity: isEmptyStateFolding ? '0' : '1',
      transform: isEmptyStateFolding ? 'scaleY(0)' : 'scaleY(1)',
      transformOrigin: 'bottom',
      transition: isEmptyStateFolding ? 'opacity 200ms ease-in-out, transform 200ms ease-in-out 50ms' : 'none'
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "carousel-card carousel-card--current"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "carousel-empty-state"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: _designSystem.TextColor.textAlternative,
    className: "carousel-empty-state__text"
  }, t('carouselAllCaughtUp'))))));
};
exports.EmptyStateComponent = EmptyStateComponent;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\carousel\\stack-card-empty\\stack-card-empty.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\carousel\\stack-card\\index.ts", {"./stack-card":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\carousel\\stack-card\\stack-card.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Ccarousel%5Cstack-card%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "StackCard", {
  enumerable: true,
  get: function () {
    return _stackCard.StackCard;
  }
});
var _stackCard = require("./stack-card");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\carousel\\stack-card\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\carousel\\stack-card\\stack-card.tsx", {"../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Ccarousel%5Cstack-card%5Cstack-card.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StackCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _componentLibrary = require("../../../component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const StackCard = ({
  slide,
  isCurrentCard,
  isLastSlide = false,
  onSlideClick,
  onTransitionToNextCard,
  className = ''
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const isContentfulContent = slide.id.startsWith('contentful-');
  const handleCloseClick = e => {
    e.preventDefault();
    e.stopPropagation();
    if (onTransitionToNextCard) {
      onTransitionToNextCard(slide.id, isLastSlide);
    }
  };
  const handleCardClick = () => {
    if (!isCurrentCard) {
      return;
    }
    const navigation = {
      type: slide.href ? 'external' : 'internal',
      href: slide.href
    };
    if (slide.href) {
      global.platform.openTab({
        url: slide.href
      });
    }
    onSlideClick === null || onSlideClick === void 0 || onSlideClick(slide.id, navigation);
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: `carousel-card ${isCurrentCard ? 'carousel-card--current' : 'carousel-card--next'} ${className}`,
    onClick: handleCardClick,
    "data-testid": `carousel-slide-${slide.id}`
  }, !isCurrentCard && /*#__PURE__*/_react.default.createElement("div", {
    className: "carousel-card__pressed-overlay"
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "carousel-card__image"
  }, /*#__PURE__*/_react.default.createElement("img", {
    src: slide.image,
    alt: slide.title
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "carousel-card__text"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "carousel-card__text-header"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: _designSystem.TextColor.textDefault,
    className: "carousel-card__title"
  }, isContentfulContent ? slide.title : t(slide.title)), onTransitionToNextCard && /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    iconName: _componentLibrary.IconName.Close,
    size: _componentLibrary.ButtonIconSize.Md,
    color: _designSystem.IconColor.iconAlternative,
    ariaLabel: t('closeSlide', [isContentfulContent ? slide.title : t(slide.title)]),
    onClick: handleCloseClick,
    "data-testid": `carousel-slide-${slide.id}-close-button`
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "carousel-card__text-body"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySmMedium,
    color: _designSystem.TextColor.textAlternative,
    className: "carousel-card__description"
  }, isContentfulContent ? slide.description : t(slide.description)))));
};
exports.StackCard = StackCard;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\carousel\\stack-card\\stack-card.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\connect-accounts-modal\\connect-accounts-modal-list.tsx", {"..":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/tooltip/tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\tooltip.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cconnect-accounts-modal%5Cconnect-accounts-modal-list.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectAccountsModalList = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _componentLibrary = require("../../component-library");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _ = require("..");
var _designSystem = require("../../../helpers/constants/design-system");
var _tooltip = _interopRequireDefault(require("../../ui/tooltip/tooltip"));
var _util = require("../../../helpers/utils/util");
var _actions = require("../../../store/actions");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const ConnectAccountsModalList = ({
  onClose,
  allAreSelected,
  deselectAll,
  selectAll,
  handleAccountClick,
  selectedAccounts,
  accounts,
  checked,
  isIndeterminate,
  onAccountsUpdate,
  activeTabOrigin
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: true,
    onClose: onClose,
    "data-testid": "connect-more-accounts"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    "data-testid": "connect-more-accounts-title",
    onClose: onClose
  }, t('connectMoreAccounts')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    padding: 4,
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Checkbox, {
    label: t('selectAll'),
    isChecked: checked,
    onClick: () => allAreSelected() ? deselectAll() : selectAll(),
    isIndeterminate: isIndeterminate
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textAlternative,
    as: "div",
    display: _designSystem.Display.Flex
  }, /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    distance: 10,
    html: t('connectedAccountsListTooltip', [/*#__PURE__*/_react.default.createElement("strong", null, (0, _util.getURLHost)(activeTabOrigin))]),
    position: "top"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    marginInlineEnd: 2,
    name: _componentLibrary.IconName.Info,
    color: _designSystem.IconColor.iconMuted
  })), t('permissions'))), accounts.map(account => {
    const isSelectedAccount = selectedAccounts.includes(account.address);
    return /*#__PURE__*/_react.default.createElement(_.AccountListItem, {
      onClick: () => handleAccountClick(account.address),
      account: account,
      selected: isSelectedAccount,
      key: account.address,
      closeMenu: onClose,
      startAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.Checkbox, {
        isChecked: isSelectedAccount
      })
    });
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalFooter, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonPrimary, {
    "data-testid": "connect-more-accounts-button",
    onClick: () => {
      dispatch((0, _actions.addPermittedAccounts)(activeTabOrigin, selectedAccounts));
      onClose();
      onAccountsUpdate();
    },
    size: _componentLibrary.ButtonPrimarySize.Lg,
    block: true,
    disabled: selectedAccounts.length === 0
  }, t('confirm')))));
};
exports.ConnectAccountsModalList = ConnectAccountsModalList;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\connect-accounts-modal\\connect-accounts-modal-list.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\connect-accounts-modal\\connect-accounts-modal.tsx", {"../../../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","./connect-accounts-modal-list":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\connect-accounts-modal\\connect-accounts-modal-list.tsx","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cconnect-accounts-modal%5Cconnect-accounts-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectAccountsModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _keyringApi = require("@metamask/keyring-api");
var _selectors = require("../../../selectors/selectors");
var _connectAccountsModalList = require("./connect-accounts-modal-list");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConnectAccountsModal = ({
  onClose,
  onAccountsUpdate,
  activeTabOrigin
}) => {
  const accounts = (0, _reactRedux.useSelector)(state =>
  // We only consider EVM accounts.
  // Connections with non-EVM accounts (Bitcoin only for now) are used implicitly and handled by the Bitcoin Snap itself.
  (0, _selectors.getUnconnectedAccounts)(state, activeTabOrigin).filter(account => (0, _keyringApi.isEvmAccountType)(account.type)));
  const [selectedAccounts, setSelectedAccounts] = (0, _react.useState)([]);
  const handleAccountClick = address => {
    const index = selectedAccounts.indexOf(address);
    let newSelectedAccounts = [];
    if (index === -1) {
      // If address is not already selected, add it to the selectedAccounts array
      newSelectedAccounts = [...selectedAccounts, address];
    } else {
      // If address is already selected, remove it from the selectedAccounts array
      newSelectedAccounts = selectedAccounts.filter((_item, idx) => idx !== index);
    }
    setSelectedAccounts(newSelectedAccounts);
  };
  const deselectAll = () => {
    setSelectedAccounts([]);
  };
  const selectAll = () => {
    const newSelectedAccounts = accounts.map(account => account.address);
    setSelectedAccounts(newSelectedAccounts);
  };
  const allAreSelected = () => {
    return accounts.length === selectedAccounts.length;
  };
  const checked = allAreSelected();
  const isIndeterminate = !checked && selectedAccounts.length > 0;
  return /*#__PURE__*/_react.default.createElement(_connectAccountsModalList.ConnectAccountsModalList, {
    accounts: accounts,
    selectedAccounts: selectedAccounts,
    allAreSelected: allAreSelected,
    deselectAll: deselectAll,
    selectAll: selectAll,
    handleAccountClick: handleAccountClick,
    checked: checked,
    isIndeterminate: isIndeterminate,
    onClose: onClose,
    onAccountsUpdate: onAccountsUpdate,
    activeTabOrigin: activeTabOrigin
  });
};
exports.ConnectAccountsModal = ConnectAccountsModal;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\connect-accounts-modal\\connect-accounts-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\connected-accounts-menu\\connected-accounts-menu.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/menu":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\menu\\index.ts","../permission-details-modal/permission-details-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\permission-details-modal\\permission-details-modal.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cconnected-accounts-menu%5Cconnected-accounts-menu.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectedAccountsMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _componentLibrary = require("../../component-library");
var _menu = require("../../ui/menu");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _actions = require("../../../store/actions");
var _selectors = require("../../../selectors");
var _permissionDetailsModal = require("../permission-details-modal/permission-details-modal");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
// eslint-disable-next-line @typescript-eslint/no-explicit-any
const TsMenuItem = _menu.MenuItem;
const ConnectedAccountsMenu = ({
  isOpen,
  account,
  anchorElement,
  disableAccountSwitcher = false,
  onClose,
  onActionClick,
  activeTabOrigin
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const t = (0, _useI18nContext.useI18nContext)();
  const popoverDialogRef = (0, _react.useRef)(null);
  const [showPermissionModal, setShowPermissionModal] = (0, _react.useState)(false);
  const permissions = (0, _reactRedux.useSelector)(_selectors.getPermissionsForActiveTab);
  const handleClickOutside = (0, _react.useCallback)(event => {
    if (popoverDialogRef !== null && popoverDialogRef !== void 0 && popoverDialogRef.current && !popoverDialogRef.current.contains(event.target)) {
      onClose();
    }
  }, [onClose]);
  (0, _react.useEffect)(() => {
    document.addEventListener('mousedown', handleClickOutside);
    return () => {
      document.removeEventListener('mousedown', handleClickOutside);
    };
  }, [handleClickOutside]);
  const handleKeyDown = (0, _react.useCallback)(event => {
    var _popoverDialogRef$cur;
    if (event.key === 'Tab' && popoverDialogRef !== null && popoverDialogRef !== void 0 && (_popoverDialogRef$cur = popoverDialogRef.current) !== null && _popoverDialogRef$cur !== void 0 && _popoverDialogRef$cur.contains(event.target) && onClose) {
      onClose();
    }
  }, [onClose]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Popover, {
    className: "multichain-connected-accounts-menu__popover",
    referenceElement: anchorElement,
    role: _componentLibrary.PopoverRole.Dialog,
    position: _componentLibrary.PopoverPosition.Bottom,
    offset: [0, 0],
    padding: 0,
    isOpen: isOpen,
    flip: true,
    preventOverflow: true,
    isPortal: true
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalFocus, {
    restoreFocus: true,
    initialFocusRef: {
      current: anchorElement
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    onKeyDown: handleKeyDown,
    ref: popoverDialogRef
  }, permissions !== null && permissions !== void 0 && permissions.length ? /*#__PURE__*/_react.default.createElement(TsMenuItem, {
    iconName: _componentLibrary.IconName.SecurityTick,
    "data-testid": "permission-details-menu-item",
    onClick: () => {
      setShowPermissionModal(true);
      onClose();
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd
  }, t('permissionDetails'))) : null, disableAccountSwitcher ? null : /*#__PURE__*/_react.default.createElement(TsMenuItem, {
    iconName: _componentLibrary.IconName.SwapHorizontal,
    "data-testid": "switch-account-menu-item",
    onClick: () => {
      dispatch((0, _actions.setSelectedAccount)(account.address));
      onClose();
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd
  }, t('switchToThisAccount'))), /*#__PURE__*/_react.default.createElement(TsMenuItem, {
    iconName: _componentLibrary.IconName.Logout,
    iconColor: _designSystem.IconColor.errorDefault,
    "data-testid": "disconnect-menu-item",
    onClick: () => {
      onActionClick(account.metadata.name);
      dispatch((0, _actions.removePermittedAccount)(activeTabOrigin, account.address));
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.errorDefault,
    variant: _designSystem.TextVariant.bodyMd
  }, t('disconnect')))))), showPermissionModal ? /*#__PURE__*/_react.default.createElement(_permissionDetailsModal.PermissionDetailsModal, {
    isOpen: showPermissionModal,
    account: account,
    onClick: () => {
      dispatch((0, _actions.removePermittedAccount)(activeTabOrigin, account.address));
    },
    onClose: () => setShowPermissionModal(false),
    permissions: permissions
  }) : null);
};
exports.ConnectedAccountsMenu = ConnectedAccountsMenu;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\connected-accounts-menu\\connected-accounts-menu.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\connected-accounts-menu\\index.ts", {"./connected-accounts-menu":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\connected-accounts-menu\\connected-accounts-menu.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cconnected-accounts-menu%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ConnectedAccountsMenu", {
  enumerable: true,
  get: function () {
    return _connectedAccountsMenu.ConnectedAccountsMenu;
  }
});
var _connectedAccountsMenu = require("./connected-accounts-menu");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\connected-accounts-menu\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\connected-site-menu\\connected-site-menu.js", {"../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../helpers/constants/connected-sites":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\connected-sites.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/dapp":"D:\\code\\v\\metamask-extension\\ui\\selectors\\dapp.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../connected-site-popover":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\connected-site-popover\\index.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cconnected-site-menu%5Cconnected-site-menu.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectedSiteMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _reactRedux = require("react-redux");
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../component-library");
var _selectors = require("../../../selectors");
var _dapp = require("../../../selectors/dapp");
var _connectedSitePopover = require("../connected-site-popover");
var _connectedSites = require("../../../helpers/constants/connected-sites");
var _network = require("../../../../shared/constants/network");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConnectedSiteMenu = ({
  className,
  disabled,
  onClick,
  status
}) => {
  const [showPopover, setShowPopover] = (0, _react.useState)(false);
  const referenceElement = (0, _react.useRef)(null);
  const subjectMetadata = (0, _reactRedux.useSelector)(_selectors.getSubjectMetadata);
  const connectedOrigin = (0, _reactRedux.useSelector)(_selectors.getOriginOfCurrentTab);
  const permittedAccountsByOrigin = (0, _reactRedux.useSelector)(state => (0, _selectors.getAllPermittedAccounts)(state, connectedOrigin));
  const dappActiveNetwork = (0, _reactRedux.useSelector)(_dapp.getDappActiveNetwork);
  const currentTabHasNoAccounts = !(permittedAccountsByOrigin !== null && permittedAccountsByOrigin !== void 0 && permittedAccountsByOrigin.length);
  const connectedSubjectsMetadata = subjectMetadata[connectedOrigin];

  // Get network image URL for the badge
  const getNetworkImageSrc = () => {
    if (dappActiveNetwork !== null && dappActiveNetwork !== void 0 && dappActiveNetwork.chainId) {
      return _network.CHAIN_ID_TO_NETWORK_IMAGE_URL_MAP[dappActiveNetwork.chainId];
    }
    return undefined;
  };
  const iconElement = currentTabHasNoAccounts ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.Global,
    size: _componentLibrary.IconSize.Lg,
    color: _designSystem.IconColor.iconDefault
  }) : /*#__PURE__*/_react.default.createElement(_componentLibrary.BadgeWrapper, {
    badge: dappActiveNetwork && /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
      size: _componentLibrary.AvatarNetworkSize.Xs,
      name: dappActiveNetwork.name || dappActiveNetwork.nickname,
      src: getNetworkImageSrc(),
      backgroundColor: _designSystem.BackgroundColor.backgroundSection,
      borderWidth: 2,
      borderColor: _designSystem.BorderColor.backgroundDefault
    })
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarFavicon, {
    name: connectedSubjectsMetadata === null || connectedSubjectsMetadata === void 0 ? void 0 : connectedSubjectsMetadata.name,
    size: _designSystem.Size.SM,
    src: connectedSubjectsMetadata === null || connectedSubjectsMetadata === void 0 ? void 0 : connectedSubjectsMetadata.iconUrl
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: (0, _classnames.default)(`multichain-connected-site-menu${disabled ? '--disabled' : ''}`, className),
    "data-testid": "connection-menu",
    as: "button",
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    ref: referenceElement,
    onClick: () => setShowPopover(true),
    borderRadius: _designSystem.BorderRadius.LG
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, iconElement)), showPopover && /*#__PURE__*/_react.default.createElement(_connectedSitePopover.ConnectedSitePopover, {
    referenceElement: referenceElement,
    isOpen: showPopover,
    isConnected: status === _connectedSites.STATUS_CONNECTED,
    onClick: onClick,
    onClose: () => setShowPopover(false),
    connectedOrigin: connectedOrigin
  }));
};
exports.ConnectedSiteMenu = ConnectedSiteMenu;
ConnectedSiteMenu.propTypes = {
  /**
   * Additional classNames to be added to the ConnectedSiteMenu
   */
  className: _propTypes.default.string,
  /**
   * onClick handler to be passed
   */
  onClick: _propTypes.default.func,
  /**
   *  Disable the connected site menu if the account is non-evm
   */
  disabled: _propTypes.default.bool,
  /**
   * The status of the connected site menu
   */
  status: _propTypes.default.string
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\connected-site-menu\\connected-site-menu.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\connected-site-menu\\index.js", {"./connected-site-menu":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\connected-site-menu\\connected-site-menu.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cconnected-site-menu%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ConnectedSiteMenu", {
  enumerable: true,
  get: function () {
    return _connectedSiteMenu.ConnectedSiteMenu;
  }
});
var _connectedSiteMenu = require("./connected-site-menu");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\connected-site-menu\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\connected-site-popover\\connected-site-popover.tsx", {"../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/dapp":"D:\\code\\v\\metamask-extension\\ui\\selectors\\dapp.ts","../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cconnected-site-popover%5Cconnected-site-popover.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectedSitePopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _utils = require("@metamask/utils");
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _i18n = require("../../../contexts/i18n");
var _selectors = require("../../../selectors");
var _util = require("../../../helpers/utils/util");
var _multichain = require("../../../selectors/multichain");
var _actions = require("../../../store/actions");
var _dapp = require("../../../selectors/dapp");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConnectedSitePopover = ({
  referenceElement,
  isOpen,
  onClose,
  isConnected,
  onClick
}) => {
  var _dappActiveNetwork$ch;
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const activeTabOrigin = (0, _reactRedux.useSelector)(_selectors.getOriginOfCurrentTab);
  const dappActiveNetwork = (0, _reactRedux.useSelector)(_dapp.getDappActiveNetwork);
  const siteName = (0, _util.getURLHost)(activeTabOrigin);
  const dispatch = (0, _reactRedux.useDispatch)();
  const getChainIdForImage = chainId => {
    const {
      namespace,
      reference
    } = (0, _utils.parseCaipChainId)(chainId);
    return namespace === 'eip155' ? `0x${parseInt(reference, 10).toString(16)}` : chainId;
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Popover, {
    referenceElement: referenceElement === null || referenceElement === void 0 ? void 0 : referenceElement.current,
    isOpen: isOpen,
    style: {
      width: '260px'
    },
    onClickOutside: onClose,
    "data-testid": "connected-site-popover",
    paddingTop: 3,
    paddingLeft: 0,
    paddingRight: 0,
    offset: [8, 8],
    position: _componentLibrary.PopoverPosition.BottomEnd,
    flip: true
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    style: {
      borderBottomWidth: '1px',
      borderBottomStyle: 'solid',
      borderBottomColor: '#858B9A33'
    },
    paddingLeft: 4,
    paddingRight: 4,
    paddingBottom: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium
  }, siteName), isConnected && dappActiveNetwork ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    alignItems: _designSystem.AlignItems.center,
    gap: 1
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
    size: _componentLibrary.AvatarNetworkSize.Xs
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    ,
    name: (dappActiveNetwork === null || dappActiveNetwork === void 0 ? void 0 : dappActiveNetwork.name) || '',
    src: dappActiveNetwork !== null && dappActiveNetwork !== void 0 && (_dappActiveNetwork$ch = dappActiveNetwork.chainId) !== null && _dappActiveNetwork$ch !== void 0 && _dappActiveNetwork$ch.includes(':') ? (0, _multichain.getImageForChainId)(getChainIdForImage(dappActiveNetwork.chainId)) : (0, _multichain.getImageForChainId)(dappActiveNetwork === null || dappActiveNetwork === void 0 ? void 0 : dappActiveNetwork.chainId)
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    size: _componentLibrary.ButtonLinkSize.Sm,
    textProps: {
      variant: _designSystem.TextVariant.bodySm
    },
    onClick: () => dispatch((0, _actions.toggleNetworkMenu)({
      isAccessedFromDappConnectedSitePopover: true,
      isAddingNewNetwork: false,
      isMultiRpcOnboarding: false
    })),
    "data-testid": "connected-site-popover-network-button"
  }, dappActiveNetwork === null || dappActiveNetwork === void 0 ? void 0 : dappActiveNetwork.name)) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySmMedium,
    color: _designSystem.TextColor.textAlternative
  }, t('statusNotConnected'))), !isConnected && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 4,
    paddingRight: 4,
    paddingTop: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    color: _designSystem.TextColor.textAlternative
  }, t('connectionPopoverDescription')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    href: "https://support.metamask.io/more-web3/dapps/connecting-to-a-dapp/",
    externalLink: true,
    size: _componentLibrary.ButtonLinkSize.Sm
  }, t('learnMoreUpperCase'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingTop: 4,
    paddingLeft: 4,
    paddingRight: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonSecondary, {
    block: true,
    onClick: () => {
      if (isConnected) {
        onClick();
      } else {
        global.platform.openTab({
          url: 'https://app.metamask.io/explore/dapps'
        });
      }
    }
  }, isConnected ? t('managePermissions') : t('exploreweb3')))));
};
exports.ConnectedSitePopover = ConnectedSitePopover;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\connected-site-popover\\connected-site-popover.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\connected-site-popover\\index.ts", {"./connected-site-popover":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\connected-site-popover\\connected-site-popover.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cconnected-site-popover%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ConnectedSitePopover", {
  enumerable: true,
  get: function () {
    return _connectedSitePopover.ConnectedSitePopover;
  }
});
var _connectedSitePopover = require("./connected-site-popover");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\connected-site-popover\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\connected-status\\connected-status.tsx", {"../../../helpers/constants/connected-sites":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\connected-sites.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../badge-status":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\badge-status\\index.ts","@metamask/chain-agnostic-permission":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\chain-agnostic-permission\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cconnected-status%5Cconnected-status.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectedStatus = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _chainAgnosticPermission = require("@metamask/chain-agnostic-permission");
var _designSystem = require("../../../helpers/constants/design-system");
var _connectedSites = require("../../../helpers/constants/connected-sites");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _badgeStatus = require("../badge-status");
var _selectors = require("../../../selectors");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const ConnectedStatus = ({
  address = '',
  isActive,
  showConnectedStatus = true
}) => {
  const t = (0, _useI18nContext.useI18nContext)();

  // Get the permitted accounts and the internal account for the address
  const permittedAccounts = (0, _reactRedux.useSelector)(_selectors.getAllPermittedAccountsForCurrentTab);
  const internalAccount = (0, _reactRedux.useSelector)(state => (0, _selectors.getInternalAccountByAddress)(state, address));
  const currentTabIsConnectedToSelectedAddress = internalAccount && (0, _chainAgnosticPermission.isInternalAccountInPermittedAccountIds)(internalAccount, permittedAccounts);
  let status = _connectedSites.STATUS_NOT_CONNECTED;
  if (isActive) {
    status = _connectedSites.STATUS_CONNECTED;
  } else if (currentTabIsConnectedToSelectedAddress) {
    status = _connectedSites.STATUS_CONNECTED_TO_ANOTHER_ACCOUNT;
  }
  let badgeBorderColor = _designSystem.BorderColor.backgroundDefault; // TODO: Replace it once border-color has this value.
  let badgeBackgroundColor = _designSystem.BackgroundColor.iconAlternative;
  let tooltipText = t('statusNotConnected');
  if (status === _connectedSites.STATUS_CONNECTED) {
    badgeBorderColor = _designSystem.BorderColor.backgroundDefault;
    // eslint-disable-next-line @typescript-eslint/ban-ts-comment
    // @ts-ignore: type 'string' can't be used to index type '{}'
    badgeBackgroundColor = _designSystem.BackgroundColor.successDefault;
    tooltipText = t('active');
  } else if (status === _connectedSites.STATUS_CONNECTED_TO_ANOTHER_ACCOUNT) {
    // eslint-disable-next-line @typescript-eslint/ban-ts-comment
    // @ts-ignore: type 'string' can't be used to index type '{}'
    badgeBorderColor = _designSystem.BorderColor.successDefault;
    // eslint-disable-next-line @typescript-eslint/ban-ts-comment
    // @ts-ignore: type 'string' can't be used to index type '{}'
    badgeBackgroundColor = _designSystem.BackgroundColor.backgroundDefault;
    tooltipText = t('tooltipSatusConnectedUpperCase');
  }
  const connectedAndNotActive = currentTabIsConnectedToSelectedAddress && !isActive;
  return /*#__PURE__*/_react.default.createElement(_badgeStatus.BadgeStatus, {
    address: address
    // eslint-disable-next-line @typescript-eslint/ban-ts-comment
    // @ts-ignore: type 'string' can't be used to index type '{}'
    ,
    badgeBackgroundColor: badgeBackgroundColor
    // eslint-disable-next-line @typescript-eslint/ban-ts-comment
    // @ts-ignore: type 'string' can't be used to index type '{}'
    ,
    badgeBorderColor: badgeBorderColor,
    text: tooltipText,
    isConnectedAndNotActive: connectedAndNotActive,
    showConnectedStatus: showConnectedStatus
  });
};
exports.ConnectedStatus = ConnectedStatus;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\connected-status\\connected-status.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\connected-status\\index.ts", {"./connected-status":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\connected-status\\connected-status.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cconnected-status%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ConnectedStatus", {
  enumerable: true,
  get: function () {
    return _connectedStatus.ConnectedStatus;
  }
});
var _connectedStatus = require("./connected-status");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\connected-status\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\create-account\\create-account.tsx", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../ducks/history/history":"D:\\code\\v\\metamask-extension\\ui\\ducks\\history\\history.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/accounts":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\accounts.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/multi-srp/multi-srp":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multi-srp\\multi-srp.ts","../../../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../component-library/form-text-field/form-text-field":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\form-text-field\\form-text-field.tsx","../multi-srp/select-srp/select-srp":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\multi-srp\\select-srp\\select-srp.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Ccreate-account%5Ccreate-account.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateAccount = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _componentLibrary = require("../../component-library");
var _formTextField = require("../../component-library/form-text-field/form-text-field");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _accounts = require("../../../helpers/utils/accounts");
var _selectors = require("../../../selectors");
var _selectors2 = require("../../../selectors/selectors");
var _history = require("../../../ducks/history/history");
var _metametrics = require("../../../../shared/constants/metametrics");
var _metametrics2 = require("../../../contexts/metametrics");
var _designSystem = require("../../../helpers/constants/design-system");
var _selectSrp = require("../multi-srp/select-srp/select-srp");
var _multiSrp = require("../../../selectors/multi-srp/multi-srp");
var _trace = require("../../../../shared/lib/trace");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention

const CreateAccount = exports.CreateAccount = /*#__PURE__*/_react.default.memo(/*#__PURE__*/_react.default.forwardRef(({
  getNextAvailableAccountName,
  onCreateAccount,
  onSelectSrp,
  selectedKeyringId,
  onActionComplete,
  scope,
  redirectToOverview = true
}, ref) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const hdEntropyIndex = (0, _reactRedux.useSelector)(_selectors2.getHDEntropyIndex);
  const mostRecentOverviewPage = (0, _reactRedux.useSelector)(_history.getMostRecentOverviewPage);
  const accounts = (0, _reactRedux.useSelector)(_selectors.getMetaMaskAccountsOrdered);
  const [loading, setLoading] = (0, _react.useState)(false);
  const [defaultAccountName, setDefaultAccountName] = (0, _react.useState)('');
  // We are not using `accounts` as a dependency here to avoid having the input
  // updating when the new account will be created.
  (0, _react.useEffect)(() => {
    getNextAvailableAccountName(accounts).then(setDefaultAccountName);
  }, []);
  const [newAccountName, setNewAccountName] = (0, _react.useState)('');
  const [creationError, setCreationError] = (0, _react.useState)('');
  const trimmedAccountName = newAccountName.trim();
  const {
    isValidAccountName,
    errorMessage
  } = (0, _accounts.getAccountNameErrorMessage)(accounts, {
    t
  }, trimmedAccountName || defaultAccountName, defaultAccountName);
  const hdKeyrings = (0, _reactRedux.useSelector)(_selectors.getMetaMaskHdKeyrings);
  const selectedKeyring = (0, _reactRedux.useSelector)(state => (0, _selectors.getSelectedKeyringByIdOrDefault)(state, selectedKeyringId));
  const firstPartySnapAccounts = (0, _reactRedux.useSelector)(state => (0, _multiSrp.getSnapAccountsByKeyringId)(state, selectedKeyringId));
  const selectedHdKeyringIndex = (0, _reactRedux.useSelector)(state => (0, _selectors.getHdKeyringIndexByIdOrDefault)(state, selectedKeyringId));
  const onSubmit = (0, _react.useCallback)(async event => {
    setLoading(true);
    setCreationError('');
    event.preventDefault();
    try {
      (0, _trace.trace)({
        name: _trace.TraceName.CreateAccount
      });
      await onCreateAccount(trimmedAccountName || defaultAccountName);
      trackEvent({
        category: _metametrics.MetaMetricsEventCategory.Accounts,
        event: _metametrics.MetaMetricsEventName.AccountAdded,
        properties: {
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          account_type: _metametrics.MetaMetricsEventAccountType.Default,
          location: 'Home',
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          hd_entropy_index: hdEntropyIndex,
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          chain_id_caip: scope,
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          is_suggested_name: !trimmedAccountName || trimmedAccountName === defaultAccountName
        }
      });
      if (redirectToOverview) {
        history.push(mostRecentOverviewPage);
      }
    } catch (error) {
      setLoading(false);
      let message = 'An unexpected error occurred.';
      if (error instanceof Error) {
        message = error.message;
      }
      setCreationError(message);
      if (selectedKeyringId) {
        trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Accounts,
          event: _metametrics.MetaMetricsEventName.AccountImportFailed,
          properties: {
            // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
            // eslint-disable-next-line @typescript-eslint/naming-convention
            account_type: _metametrics.MetaMetricsEventAccountType.Imported,
            error: message,
            // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
            // eslint-disable-next-line @typescript-eslint/naming-convention
            hd_entropy_index: hdEntropyIndex,
            // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
            // eslint-disable-next-line @typescript-eslint/naming-convention
            chain_id_caip: scope
          }
        });
      } else {
        trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Accounts,
          event: _metametrics.MetaMetricsEventName.AccountAddFailed,
          properties: {
            // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
            // eslint-disable-next-line @typescript-eslint/naming-convention
            account_type: _metametrics.MetaMetricsEventAccountType.Default,
            error: message,
            // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
            // eslint-disable-next-line @typescript-eslint/naming-convention
            hd_entropy_index: hdEntropyIndex,
            // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
            // eslint-disable-next-line @typescript-eslint/naming-convention
            chain_id_caip: scope
          }
        });
      }
    } finally {
      (0, _trace.endTrace)({
        name: _trace.TraceName.CreateAccount
      });
    }
  }, [trimmedAccountName, defaultAccountName, mostRecentOverviewPage]);
  return (
    /*#__PURE__*/
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    _react.default.createElement(_componentLibrary.Box, {
      as: "form",
      onSubmit: onSubmit
    }, /*#__PURE__*/_react.default.createElement(_formTextField.FormTextField, {
      "data-testid": "account-name-input",
      inputRef: ref,
      size: _componentLibrary.FormTextFieldSize.Lg,
      gap: 2,
      autoFocus: true,
      id: "account-name",
      label: t('accountName'),
      placeholder: defaultAccountName,
      onChange: e => setNewAccountName(e.target.value),
      helpText: creationError || errorMessage,
      error: !isValidAccountName || Boolean(creationError),
      onKeyPress: e => {
        if (e.key === 'Enter') {
          onSubmit(e);
        }
      }
    }), hdKeyrings.length > 1 && onSelectSrp && selectedKeyring ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      marginBottom: 3
    }, /*#__PURE__*/_react.default.createElement(_selectSrp.SelectSrp, {
      onClick: onSelectSrp,
      srpName: t('secretRecoveryPhrasePlusNumber', [selectedHdKeyringIndex + 1]),
      srpAccounts: selectedKeyring.accounts.length + firstPartySnapAccounts.length
    })) : null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      marginTop: 1,
      gap: 2
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonSecondary, {
      "data-testid": "cancel-add-account-with-name",
      type: 'button' /* needs to be 'button' to prevent submitting form on cancel */
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
      // eslint-disable-next-line @typescript-eslint/no-misused-promises
      ,
      onClick: async () => await onActionComplete(false),
      block: true
    }, t('cancel')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonPrimary, {
      "data-testid": "submit-add-account-with-name",
      type: "submit",
      disabled: !isValidAccountName || loading,
      loading: loading,
      block: true
    }, t('addAccount'))))
  );
}));

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\create-account\\create-account.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\create-account\\index.js", {"./create-account":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\create-account\\create-account.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Ccreate-account%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "CreateAccount", {
  enumerable: true,
  get: function () {
    return _createAccount.CreateAccount;
  }
});
var _createAccount = require("./create-account");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\create-account\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\create-eth-account\\create-eth-account.js", {"../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../create-account":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\create-account\\index.js","@metamask/keyring-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-controller\\dist\\index.cjs","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Ccreate-eth-account%5Ccreate-eth-account.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateEthAccount = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRedux = require("react-redux");
var _keyringController = require("@metamask/keyring-controller");
var _actions = require("../../../store/actions");
var _trace = require("../../../../shared/lib/trace");
var _createAccount = require("../create-account");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const CreateEthAccount = ({
  onActionComplete,
  onSelectSrp,
  selectedKeyringId,
  redirectToOverview
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const onCreateAccount = async name => {
    (0, _trace.trace)({
      name: _trace.TraceName.AddAccount
    });
    try {
      const newAccount = await dispatch((0, _actions.addNewAccount)(selectedKeyringId));
      if (name) {
        dispatch((0, _actions.setAccountLabel)(newAccount.address, name));
      }
      onActionComplete(true, newAccount);
    } finally {
      (0, _trace.endTrace)({
        name: _trace.TraceName.AddAccount
      });
    }
  };
  const getNextAvailableAccountName = async () => {
    return await (0, _actions.getNextAvailableAccountName)(_keyringController.KeyringTypes.hd);
  };
  return /*#__PURE__*/_react.default.createElement(_createAccount.CreateAccount, {
    onActionComplete: onActionComplete,
    onCreateAccount: onCreateAccount,
    getNextAvailableAccountName: getNextAvailableAccountName,
    onSelectSrp: onSelectSrp,
    selectedKeyringId: selectedKeyringId,
    redirectToOverview: redirectToOverview
  });
};
exports.CreateEthAccount = CreateEthAccount;
CreateEthAccount.propTypes = {
  /**
   * Executes when the Create button is clicked
   */
  onActionComplete: _propTypes.default.func.isRequired,
  /**
   * Callback to select the SRP
   */
  onSelectSrp: _propTypes.default.func,
  /**
   * Currently selected HD keyring
   */
  selectedKeyringId: _propTypes.default.string,
  /**
   * Whether to redirect to the overview page after creating the account
   */
  redirectToOverview: _propTypes.default.bool
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\create-eth-account\\create-eth-account.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\create-eth-account\\index.js", {"./create-eth-account":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\create-eth-account\\create-eth-account.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Ccreate-eth-account%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "CreateEthAccount", {
  enumerable: true,
  get: function () {
    return _createEthAccount.CreateEthAccount;
  }
});
var _createEthAccount = require("./create-eth-account");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\create-eth-account\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\create-named-snap-account\\create-named-snap-account.tsx", {"..":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../../../shared/lib/accounts":"D:\\code\\v\\metamask-extension\\shared\\lib\\accounts\\index.ts","../../../ducks/history/history":"D:\\code\\v\\metamask-extension\\ui\\ducks\\history\\history.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","@metamask/keyring-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Ccreate-named-snap-account%5Ccreate-named-snap-account.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateNamedSnapAccount = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _keyringController = require("@metamask/keyring-controller");
var _ = require("..");
var _componentLibrary = require("../../component-library");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _history = require("../../../ducks/history/history");
var _actions = require("../../../store/actions");
var _accounts = require("../../../../shared/lib/accounts");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CreateNamedSnapAccount = ({
  onActionComplete,
  snapSuggestedAccountName
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const mostRecentOverviewPage = (0, _reactRedux.useSelector)(_history.getMostRecentOverviewPage);
  const rejectAction = (0, _react.useCallback)(async completed => {
    await onActionComplete({
      success: completed
    });
  }, []);
  const onCreateAccount = (0, _react.useCallback)(async name => {
    await onActionComplete({
      success: true,
      name
    });
  }, []);
  const getNextAccountName = (0, _react.useCallback)(async accounts => {
    // If a snap-suggested account name exists, use it as a base
    return snapSuggestedAccountName ? (0, _accounts.getUniqueAccountName)(accounts, snapSuggestedAccountName) : (0, _actions.getNextAvailableAccountName)(_keyringController.KeyringTypes.snap);
  }, []);
  const onClose = (0, _react.useCallback)(async () => {
    await onActionComplete({
      success: false
    });
    history.push(mostRecentOverviewPage);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    padding: 6,
    className: "name-snap-account-page"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    paddingTop: 2,
    paddingBottom: 4,
    paddingRight: 0,
    paddingLeft: 0
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    ,
    onClose: onClose
  }, t('addAccountToMetaMask')), /*#__PURE__*/_react.default.createElement(_.CreateAccount
  // onActionComplete is called when a user rejects the action
  // onCreateAccount will call onActionComplete if a user confirms the action
  , {
    onActionComplete: rejectAction,
    onCreateAccount: onCreateAccount,
    getNextAvailableAccountName: getNextAccountName
  }));
};
exports.CreateNamedSnapAccount = CreateNamedSnapAccount;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\create-named-snap-account\\create-named-snap-account.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\create-named-snap-account\\index.js", {"./create-named-snap-account":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\create-named-snap-account\\create-named-snap-account.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Ccreate-named-snap-account%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "CreateNamedSnapAccount", {
  enumerable: true,
  get: function () {
    return _createNamedSnapAccount.CreateNamedSnapAccount;
  }
});
var _createNamedSnapAccount = require("./create-named-snap-account");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\create-named-snap-account\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\create-snap-account\\create-snap-account.tsx", {"../../../hooks/accounts/useMultichainWalletSnapClient":"D:\\code\\v\\metamask-extension\\ui\\hooks\\accounts\\useMultichainWalletSnapClient.ts","../create-account":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\create-account\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Ccreate-snap-account%5Ccreate-snap-account.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateSnapAccount = void 0;
var _react = _interopRequireWildcard(require("react"));
var _createAccount = require("../create-account");
var _useMultichainWalletSnapClient = require("../../../hooks/accounts/useMultichainWalletSnapClient");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CreateSnapAccount = ({
  onActionComplete,
  onSelectSrp,
  selectedKeyringId,
  clientType,
  chainId,
  setNewlyCreatedAccountAsSelected,
  redirectToOverview
}) => {
  const client = (0, _useMultichainWalletSnapClient.useMultichainWalletSnapClient)(clientType);
  const onCreateAccount = (0, _react.useCallback)(async accountNameSuggestion => {
    const newAccount = await client.createAccount({
      scope: chainId,
      entropySource: selectedKeyringId,
      accountNameSuggestion
    }, {
      setSelectedAccount: setNewlyCreatedAccountAsSelected
    });
    onActionComplete(true, newAccount);
  }, [client, chainId, selectedKeyringId, setNewlyCreatedAccountAsSelected, onActionComplete]);
  const getNextAccountName = async () => {
    return await client.getNextAvailableAccountName({
      chainId
    });
  };
  return /*#__PURE__*/_react.default.createElement(_createAccount.CreateAccount, {
    onActionComplete: onActionComplete,
    onCreateAccount: onCreateAccount,
    getNextAvailableAccountName: getNextAccountName,
    scope: chainId,
    onSelectSrp: onSelectSrp,
    selectedKeyringId: selectedKeyringId,
    redirectToOverview: redirectToOverview
  });
};
exports.CreateSnapAccount = CreateSnapAccount;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\create-snap-account\\create-snap-account.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\create-snap-account\\index.ts", {"./create-snap-account":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\create-snap-account\\create-snap-account.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Ccreate-snap-account%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "CreateSnapAccount", {
  enumerable: true,
  get: function () {
    return _createSnapAccount.CreateSnapAccount;
  }
});
var _createSnapAccount = require("./create-snap-account");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\create-snap-account\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\create-solana-account-modal\\create-solana-account-modal.tsx", {"../../../../shared/constants/multichain/networks":"D:\\code\\v\\metamask-extension\\shared\\constants\\multichain\\networks.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/accounts/useMultichainWalletSnapClient":"D:\\code\\v\\metamask-extension\\ui\\hooks\\accounts\\useMultichainWalletSnapClient.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../create-snap-account":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\create-snap-account\\index.ts","../multi-srp/srp-list":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\multi-srp\\srp-list\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Ccreate-solana-account-modal%5Ccreate-solana-account-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateSolanaAccountModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _selectors = require("../../../selectors");
var _createSnapAccount = require("../create-snap-account");
var _srpList = require("../multi-srp/srp-list");
var _useMultichainWalletSnapClient = require("../../../hooks/accounts/useMultichainWalletSnapClient");
var _networks = require("../../../../shared/constants/multichain/networks");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const CreateSolanaAccountModal = ({
  onClose
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const [primaryKeyring] = (0, _reactRedux.useSelector)(_selectors.getMetaMaskKeyrings);
  const [showSrpSelection, setShowSrpSelection] = _react.default.useState(false);
  const [showCreateAccount, setShowCreateAccount] = _react.default.useState(true);
  const [selectedKeyringId, setSelectedKeyringId] = _react.default.useState(primaryKeyring.metadata.id);
  if (showCreateAccount) {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
      isOpen: true,
      onClose: onClose
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, {
      className: "create-solana-account-modal",
      "data-testid": "create-solana-account-modal",
      modalDialogProps: {
        className: 'create-solana-account-modal__dialog',
        padding: 0,
        display: _designSystem.Display.Flex,
        flexDirection: _designSystem.FlexDirection.Column
      }
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
      padding: 4,
      onClose: onClose
    }, t('createSolanaAccount')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      paddingLeft: 4,
      paddingRight: 4,
      paddingBottom: 4
    }, /*#__PURE__*/_react.default.createElement(_createSnapAccount.CreateSnapAccount, {
      onActionComplete: async confirmed => {
        if (confirmed) {
          setShowCreateAccount(false);
        }
        onClose();
      },
      selectedKeyringId: selectedKeyringId,
      onSelectSrp: () => {
        setShowSrpSelection(true);
        setShowCreateAccount(false);
      },
      clientType: _useMultichainWalletSnapClient.WalletClientType.Solana,
      chainId: _networks.MultichainNetworks.SOLANA
    }))));
  }
  if (showSrpSelection) {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
      isOpen: true,
      onClose: onClose
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, {
      className: "create-solana-account-modal",
      "data-testid": "create-solana-account-modal",
      modalDialogProps: {
        className: 'create-solana-account-modal__dialog',
        padding: 0,
        display: _designSystem.Display.Flex,
        flexDirection: _designSystem.FlexDirection.Column
      }
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
      padding: 4,
      onClose: onClose
    }, t('selectSRP')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      paddingLeft: 4,
      paddingRight: 4,
      paddingBottom: 4
    }, /*#__PURE__*/_react.default.createElement(_srpList.SrpList, {
      onActionComplete: keyringId => {
        setSelectedKeyringId(keyringId);
        setShowCreateAccount(true);
      }
    }))));
  }
  return null;
};
exports.CreateSolanaAccountModal = CreateSolanaAccountModal;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\create-solana-account-modal\\create-solana-account-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\create-solana-account-modal\\index.ts", {"./create-solana-account-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\create-solana-account-modal\\create-solana-account-modal.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Ccreate-solana-account-modal%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "CreateSolanaAccountModal", {
  enumerable: true,
  get: function () {
    return _createSolanaAccountModal.CreateSolanaAccountModal;
  }
});
var _createSolanaAccountModal = require("./create-solana-account-modal");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\create-solana-account-modal\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\detected-token-banner\\detected-token-banner.js", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cdetected-token-banner%5Cdetected-token-banner.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetectedTokensBanner = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _useI18nContext = require("../../../hooks/useI18nContext");
var _networks = require("../../../../shared/modules/selectors/networks");
var _selectors = require("../../../selectors");
var _metametrics = require("../../../contexts/metametrics");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _componentLibrary = require("../../component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const DetectedTokensBanner = ({
  className,
  actionButtonOnClick,
  ...props
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const isTokenNetworkFilterEqualCurrentNetwork = (0, _reactRedux.useSelector)(_selectors.getIsTokenNetworkFilterEqualCurrentNetwork);
  const allNetworks = (0, _reactRedux.useSelector)(_networks.getNetworkConfigurationsByChainId);
  const allOpts = {};
  Object.keys(allNetworks || {}).forEach(chainId => {
    allOpts[chainId] = true;
  });
  const detectedTokens = (0, _reactRedux.useSelector)(_selectors.getDetectedTokensInCurrentNetwork);
  const detectedTokensMultichain = (0, _reactRedux.useSelector)(_selectors.getAllDetectedTokensForSelectedAddress);
  const chainId = (0, _reactRedux.useSelector)(_networks.getCurrentChainId);
  const detectedTokensDetails = "true" && !isTokenNetworkFilterEqualCurrentNetwork ? Object.values(detectedTokensMultichain).flat().map(({
    address,
    symbol
  }) => `${symbol} - ${address}`) : detectedTokens.map(({
    address,
    symbol
  }) => `${symbol} - ${address}`);
  const totalTokens = "true" && !isTokenNetworkFilterEqualCurrentNetwork ? Object.values(detectedTokensMultichain).reduce((count, tokenArray) => count + tokenArray.length, 0) : detectedTokens.length;
  const handleOnClick = () => {
    actionButtonOnClick();
    trackEvent({
      event: _metametrics2.MetaMetricsEventName.TokenImportClicked,
      category: _metametrics2.MetaMetricsEventCategory.Wallet,
      properties: {
        source_connection_method: _metametrics2.MetaMetricsTokenEventSource.Detected,
        tokens: detectedTokensDetails,
        chain_id: chainId
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerAlert, _extends({
    className: (0, _classnames.default)('multichain-detected-token-banner', className),
    actionButtonLabel: t('importTokensCamelCase'),
    actionButtonOnClick: handleOnClick,
    "data-testid": "detected-token-banner"
  }, props), totalTokens === 1 ? t('numberOfNewTokensDetectedSingular') : t('numberOfNewTokensDetectedPlural', [totalTokens]));
};
exports.DetectedTokensBanner = DetectedTokensBanner;
DetectedTokensBanner.propTypes = {
  /**
   * Handler to be passed to the DetectedTokenBanner component
   */
  actionButtonOnClick: _propTypes.default.func.isRequired,
  /**
   * An additional className to the DetectedTokenBanner component
   */
  className: _propTypes.default.string
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\detected-token-banner\\detected-token-banner.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\detected-token-banner\\index.js", {"./detected-token-banner":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\detected-token-banner\\detected-token-banner.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cdetected-token-banner%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "DetectedTokensBanner", {
  enumerable: true,
  get: function () {
    return _detectedTokenBanner.DetectedTokensBanner;
  }
});
var _detectedTokenBanner = require("./detected-token-banner");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\detected-token-banner\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\disconnect-all-modal\\disconnect-all-modal.tsx", {"../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cdisconnect-all-modal%5Cdisconnect-all-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DisconnectType = exports.DisconnectAllModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../component-library");
var _useI18nContext = require("../../../hooks/useI18nContext");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// Maps to localizations for title and text
let DisconnectType = exports.DisconnectType = /*#__PURE__*/function (DisconnectType) {
  DisconnectType["Account"] = "disconnectAllAccountsText";
  DisconnectType["Snap"] = "disconnectAllSnapsText";
  return DisconnectType;
}({});
const DisconnectAllModal = ({
  onClick,
  onClose
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: true,
    onClose: onClose,
    "data-testid": "disconnect-all-modal"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onClose: onClose
  }, t('disconnect')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, null, t('disconnectAllDescriptionText'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalFooter, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    onClick: onClick,
    startIconName: _componentLibrary.IconName.Logout,
    block: true,
    danger: true,
    "data-testid": "disconnect-all"
  }, t('disconnect')))));
};
exports.DisconnectAllModal = DisconnectAllModal;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\disconnect-all-modal\\disconnect-all-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\dropdown-editor\\dropdown-editor.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\index.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cdropdown-editor%5Cdropdown-editor.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DropdownEditorStyle = exports.DropdownEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _tooltip = _interopRequireDefault(require("../../ui/tooltip"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
let DropdownEditorStyle = exports.DropdownEditorStyle = /*#__PURE__*/function (DropdownEditorStyle) {
  DropdownEditorStyle[DropdownEditorStyle["PopoverStyle"] = 0] = "PopoverStyle";
  DropdownEditorStyle[DropdownEditorStyle["BoxStyle"] = 1] = "BoxStyle";
  return DropdownEditorStyle;
}({}); // A dropdown for selecting, adding, and deleting items.
const DropdownEditor = ({
  title,
  placeholder,
  items,
  selectedItemIndex,
  addButtonText,
  error,
  style,
  onItemSelected,
  onItemDeleted,
  onItemAdd,
  onDropdownOpened,
  itemKey,
  itemIsDeletable = () => true,
  renderItem,
  renderTooltip,
  buttonDataTestId
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const dropdown = (0, _react.useRef)(null);
  const [isDropdownOpen, setIsDropdownOpen] = (0, _react.useState)(false);
  const renderDropdownList = () => /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, items === null || items === void 0 ? void 0 : items.map((item, index) => {
    const row = /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      alignItems: _designSystem.AlignItems.center,
      paddingLeft: 4,
      paddingRight: 4,
      display: _designSystem.Display.Flex,
      justifyContent: _designSystem.JustifyContent.spaceBetween,
      key: itemKey(item),
      onClick: () => {
        onItemSelected(index);
        setIsDropdownOpen(false);
      },
      className: (0, _classnames.default)('dropdown-editor__item', {
        'dropdown-editor__item--selected': index === selectedItemIndex
      })
    }, index === selectedItemIndex && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      className: "dropdown-editor__item-selected-pill",
      borderRadius: _designSystem.BorderRadius.pill,
      backgroundColor: _designSystem.BackgroundColor.primaryDefault
    }), renderItem(item, true), itemIsDeletable(item, items) && /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      marginLeft: 1,
      ariaLabel: t('delete'),
      size: _componentLibrary.ButtonIconSize.Sm,
      iconName: _componentLibrary.IconName.Trash,
      "data-testid": `delete-item-${index}`,
      color: _designSystem.IconColor.errorDefault,
      onClick: e => {
        e.stopPropagation();

        // Determine which item should be selected after deletion
        let newSelectedIndex;
        if (selectedItemIndex === undefined || items.length <= 1) {
          newSelectedIndex = undefined;
        } else if (index === selectedItemIndex) {
          newSelectedIndex = 0;
        } else if (index > selectedItemIndex) {
          newSelectedIndex = selectedItemIndex;
        } else if (index < selectedItemIndex) {
          newSelectedIndex = selectedItemIndex - 1;
        }
        onItemDeleted(index, newSelectedIndex);
      }
    }));
    const tooltip = renderTooltip(item, true);
    return tooltip ? /*#__PURE__*/_react.default.createElement(_tooltip.default, {
      title: tooltip,
      position: "bottom"
    }, row) : row;
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    onClick: onItemAdd,
    padding: 4,
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    className: "dropdown-editor__item"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    color: _designSystem.IconColor.primaryDefault,
    name: _componentLibrary.IconName.Add,
    size: _componentLibrary.IconSize.Sm,
    marginRight: 2
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "button",
    backgroundColor: _designSystem.BackgroundColor.transparent,
    color: _designSystem.TextColor.primaryDefault,
    variant: _designSystem.TextVariant.bodySmMedium
  }, addButtonText)));
  let borderColor = _designSystem.BorderColor.borderDefault;
  if (error) {
    borderColor = _designSystem.BorderColor.errorDefault;
  } else if (isDropdownOpen) {
    borderColor = _designSystem.BorderColor.primaryDefault;
  }

  // Call back in a useEffect so it triggers after the opening has rendered
  (0, _react.useEffect)(() => {
    if (isDropdownOpen) {
      onDropdownOpened === null || onDropdownOpened === void 0 || onDropdownOpened();
    }
  }, [isDropdownOpen]);
  const selectedItem = items === null || items === void 0 ? void 0 : items[selectedItemIndex ?? -1];
  const tooltip = selectedItem ? renderTooltip(selectedItem, false) : undefined;
  const box = /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    onClick: () => {
      setIsDropdownOpen(!isDropdownOpen);
    },
    className: "dropdown-editor__item-dropdown",
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    borderRadius: _designSystem.BorderRadius.LG,
    borderColor: borderColor,
    borderWidth: 1,
    paddingLeft: 4,
    paddingRight: 4,
    ref: dropdown
  }, selectedItem ? renderItem(selectedItem, false) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Input, {
    className: "dropdown-editor__item-placeholder",
    placeholder: placeholder,
    readOnly: true,
    tabIndex: -1,
    paddingTop: 3,
    paddingBottom: 3
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    marginLeft: "auto",
    iconName: isDropdownOpen ? _componentLibrary.IconName.ArrowUp : _componentLibrary.IconName.ArrowDown,
    ariaLabel: title,
    size: _componentLibrary.ButtonIconSize.Md,
    "data-testid": buttonDataTestId
  }));
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingTop: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Label, {
    variant: _designSystem.TextVariant.bodyMdMedium
  }, title), tooltip ? /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    title: tooltip,
    position: "bottom"
  }, box) : box, style === DropdownEditorStyle.PopoverStyle ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Popover, {
    paddingTop: items && items.length > 0 ? 2 : 0,
    paddingBottom: items && items.length > 0 ? 2 : 0,
    paddingLeft: 0,
    matchWidth: true,
    paddingRight: 0,
    className: "dropdown-editor__item-popover",
    referenceElement: dropdown.current,
    position: _componentLibrary.PopoverPosition.Bottom,
    isOpen: isDropdownOpen,
    onClickOutside: () => setIsDropdownOpen(false)
  }, renderDropdownList()) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginTop: 2,
    display: isDropdownOpen ? _designSystem.Display.Block : _designSystem.Display.None,
    borderColor: _designSystem.BorderColor.borderMuted,
    borderRadius: _designSystem.BorderRadius.LG
  }, renderDropdownList()));
};
exports.DropdownEditor = DropdownEditor;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\dropdown-editor\\dropdown-editor.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\edit-accounts-modal\\add-account.tsx", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../hooks/accounts/useMultichainWalletSnapClient":"D:\\code\\v\\metamask-extension\\ui\\hooks\\accounts\\useMultichainWalletSnapClient.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../create-eth-account":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\create-eth-account\\index.js","../create-snap-account/create-snap-account":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\create-snap-account\\create-snap-account.tsx","../multi-srp/srp-list":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\multi-srp\\srp-list\\index.ts","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cedit-accounts-modal%5Cadd-account.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditAccountAddAccountForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _keyringApi = require("@metamask/keyring-api");
var _componentLibrary = require("../../component-library");
var _useMultichainWalletSnapClient = require("../../../hooks/accounts/useMultichainWalletSnapClient");
var _createSnapAccount = require("../create-snap-account/create-snap-account");
var _createEthAccount = require("../create-eth-account");
var _selectors = require("../../../selectors");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _metametrics = require("../../../contexts/metametrics");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _srpList = require("../multi-srp/srp-list");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EditAccountAddAccountForm = ({
  accountType,
  onActionComplete,
  onBack,
  onClose
}) => {
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const t = (0, _useI18nContext.useI18nContext)();
  const [showSrpSelection, setShowSrpSelection] = (0, _react.useState)(false);

  // Here we are getting the keyring of the last selected account
  // if it is not an hd keyring, we will use the primary keyring
  const hdKeyring = (0, _reactRedux.useSelector)(_selectors.getHdKeyringOfSelectedAccountOrPrimaryKeyring);
  const [selectedKeyringId, setSelectedKeyringId] = (0, _react.useState)(hdKeyring.metadata.id);
  const onSelectSrp = (0, _react.useCallback)(() => {
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.Accounts,
      event: _metametrics2.MetaMetricsEventName.SecretRecoveryPhrasePickerClicked,
      properties: {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        button_type: 'picker'
      }
    });
    setShowSrpSelection(previous => !previous);
  }, []);
  const {
    clientType,
    chainId,
    networkName
  } = (0, _react.useMemo)(() => {
    switch (accountType) {
      case _useMultichainWalletSnapClient.WalletClientType.Bitcoin:
        return {
          clientType: _useMultichainWalletSnapClient.WalletClientType.Bitcoin,
          chainId: _keyringApi.BtcScope.Mainnet,
          networkName: t('networkNameBitcoin')
        };
      case _useMultichainWalletSnapClient.WalletClientType.Solana:
        return {
          clientType: _useMultichainWalletSnapClient.WalletClientType.Solana,
          chainId: _keyringApi.SolScope.Mainnet,
          networkName: t('networkNameSolana')
        };
      default:
        return {
          clientType: null,
          chainId: null,
          networkName: null
        };
    }
  }, [accountType]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    startAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      iconName: _componentLibrary.IconName.ArrowLeft,
      onClick: onBack,
      ariaLabel: t('back')
    }),
    endAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      iconName: _componentLibrary.IconName.Close,
      onClick: onClose,
      ariaLabel: t('close')
    })
  }, networkName ? t('addAccountFromNetwork', [networkName]) : t('addAccount')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 4,
    paddingRight: 4,
    paddingBottom: 4
  }, showSrpSelection && /*#__PURE__*/_react.default.createElement(_srpList.SrpList, {
    onActionComplete: keyringId => {
      setSelectedKeyringId(keyringId);
      setShowSrpSelection(false);
    }
  }), !showSrpSelection && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, clientType && chainId ? /*#__PURE__*/_react.default.createElement(_createSnapAccount.CreateSnapAccount, {
    onActionComplete: onActionComplete,
    selectedKeyringId: selectedKeyringId,
    onSelectSrp: onSelectSrp,
    clientType: clientType,
    chainId: chainId,
    setNewlyCreatedAccountAsSelected: true,
    redirectToOverview: false
  }) : /*#__PURE__*/_react.default.createElement(_createEthAccount.CreateEthAccount, {
    onActionComplete: onActionComplete,
    selectedKeyringId: selectedKeyringId,
    onSelectSrp: onSelectSrp,
    redirectToOverview: false
  })))));
};
exports.EditAccountAddAccountForm = EditAccountAddAccountForm;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\edit-accounts-modal\\add-account.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\edit-accounts-modal\\add-new-account-option.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/accounts/useMultichainWalletSnapClient":"D:\\code\\v\\metamask-extension\\ui\\hooks\\accounts\\useMultichainWalletSnapClient.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cedit-accounts-modal%5Cadd-new-account-option.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditAccountModalAddNewAccountOption = void 0;
var _react = _interopRequireDefault(require("react"));
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _componentLibrary = require("../../component-library");
var _useMultichainWalletSnapClient = require("../../../hooks/accounts/useMultichainWalletSnapClient");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const EditAccountModalAddNewAccountOption = ({
  setAccountTypeToAdd
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    endAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      iconName: _componentLibrary.IconName.Close,
      onClick: () => setAccountTypeToAdd(_useMultichainWalletSnapClient.EVM_WALLET_TYPE),
      ariaLabel: t('close')
    })
  }, t('newAccount')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 4,
    paddingRight: 4,
    paddingBottom: 4,
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: _designSystem.JustifyContent.flexStart,
    alignItems: _designSystem.AlignItems.flexStart
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySmMedium,
    marginBottom: 2,
    color: _designSystem.TextColor.textAlternative
  }, t('createNewAccountHeader')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    marginBottom: 2,
    size: _componentLibrary.ButtonLinkSize.Sm,
    startIconName: _componentLibrary.IconName.Add,
    startIconProps: {
      size: _componentLibrary.IconSize.Md
    },
    onClick: () => setAccountTypeToAdd(_useMultichainWalletSnapClient.EVM_WALLET_TYPE),
    "data-testid": "multichain-account-menu-popover-add-account"
  }, t('addNewEthereumAccountLabel')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    size: _componentLibrary.ButtonLinkSize.Sm,
    startIconName: _componentLibrary.IconName.Add,
    startIconProps: {
      size: _componentLibrary.IconSize.Md
    },
    onClick: () => setAccountTypeToAdd(_useMultichainWalletSnapClient.WalletClientType.Solana),
    "data-testid": "multichain-account-menu-popover-add-solana-account"
  }, t('addNewSolanaAccountLabel')))));
};
exports.EditAccountModalAddNewAccountOption = EditAccountModalAddNewAccountOption;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\edit-accounts-modal\\add-new-account-option.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\edit-accounts-modal\\edit-accounts-modal.tsx", {"..":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/modules/string-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\string-utils.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/accounts/useMultichainWalletSnapClient":"D:\\code\\v\\metamask-extension\\ui\\hooks\\accounts\\useMultichainWalletSnapClient.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","./add-account":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\edit-accounts-modal\\add-account.tsx","./add-new-account-option":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\edit-accounts-modal\\add-new-account-option.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cedit-accounts-modal%5Cedit-accounts-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditAccountsModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useI18nContext = require("../../../hooks/useI18nContext");
var _componentLibrary = require("../../component-library");
var _ = require("..");
var _designSystem = require("../../../helpers/constants/design-system");
var _metametrics = require("../../../../shared/constants/metametrics");
var _metametrics2 = require("../../../contexts/metametrics");
var _stringUtils = require("../../../../shared/modules/string-utils");
var _useMultichainWalletSnapClient = require("../../../hooks/accounts/useMultichainWalletSnapClient");
var _addAccount = require("./add-account");
var _addNewAccountOption = require("./add-new-account-option");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var EditAccountModalStage = /*#__PURE__*/function (EditAccountModalStage) {
  EditAccountModalStage["AccountList"] = "account-list";
  EditAccountModalStage["AddNewAccount"] = "add-new-account";
  EditAccountModalStage["EditAccounts"] = "edit-accounts";
  return EditAccountModalStage;
}(EditAccountModalStage || {});
const EditAccountsModal = ({
  accounts,
  defaultSelectedAccountAddresses,
  onClose,
  onSubmit
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const [modalStage, setModalStage] = (0, _react.useState)(EditAccountModalStage.AccountList);
  const [selectedAccountAddresses, setSelectedAccountAddresses] = (0, _react.useState)(defaultSelectedAccountAddresses);
  const [accountType, setAccountType] = (0, _react.useState)(_useMultichainWalletSnapClient.EVM_WALLET_TYPE);
  (0, _react.useEffect)(() => {
    setSelectedAccountAddresses(defaultSelectedAccountAddresses);
  }, [
  // TODO: Fix the source of this prop value to be the same array instance each render
  JSON.stringify(defaultSelectedAccountAddresses)]);
  const selectAll = () => {
    const allNetworksAccountAddresses = accounts.map(({
      caipAccountId
    }) => caipAccountId);
    setSelectedAccountAddresses(allNetworksAccountAddresses);
  };
  const deselectAll = () => {
    setSelectedAccountAddresses([]);
  };
  const handleAccountClick = caipAccountId => {
    const updatedSelectedAccountAddresses = selectedAccountAddresses.filter(selectedAccountId => {
      return !(0, _stringUtils.isEqualCaseInsensitive)(selectedAccountId, caipAccountId);
    });
    if (updatedSelectedAccountAddresses.length === selectedAccountAddresses.length) {
      setSelectedAccountAddresses([...selectedAccountAddresses, caipAccountId]);
    } else {
      setSelectedAccountAddresses(updatedSelectedAccountAddresses);
    }
  };
  const allAreSelected = () => accounts.length === selectedAccountAddresses.length;
  const checked = allAreSelected();
  const isIndeterminate = !checked && selectedAccountAddresses.length > 0;
  const defaultSet = new Set(defaultSelectedAccountAddresses);
  const selectedSet = new Set(selectedAccountAddresses);
  const handleAddAccount = (0, _react.useCallback)(async (completed, newAccount) => {
    if (completed && newAccount) {
      const [scope] = newAccount.scopes;
      if (!scope) {
        // Should never happen since `scopes` is declared as a non-empty array on the
        // account type.
        throw new Error('Account has no scope');
      }
      // NOTE: For now we only rely on 1 single CAIP-10. The CAIP namespace is
      // used under the hood and we assume all account's scope use the same
      // namespace.
      // TODO: Maybe use multiple CAIP-10 for each scopes instead?
      const newAccountCaipAccountId = `${scope}:${newAccount.address}`;
      onSubmit([...selectedAccountAddresses, newAccountCaipAccountId]);
      onClose();
    }
  }, [selectedAccountAddresses, onSubmit, onClose]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: true,
    onClose: onClose,
    "data-testid": "edit-accounts-modal",
    className: "edit-accounts-modal"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), modalStage === EditAccountModalStage.AccountList && /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onClose: onClose
  }, t('editAccounts')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, {
    paddingLeft: 0,
    paddingRight: 0,
    className: "edit-accounts-modal__body"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    padding: 4,
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Checkbox, {
    label: t('selectAll'),
    isChecked: checked,
    gap: 4,
    onClick: () => allAreSelected() ? deselectAll() : selectAll(),
    isIndeterminate: isIndeterminate
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    onClick: () => setModalStage(EditAccountModalStage.AddNewAccount),
    "data-testid": "add-new-account-button"
  }, t('newAccount'))), accounts.map(account => /*#__PURE__*/_react.default.createElement(_.AccountListItem, {
    onClick: () => handleAccountClick(account.caipAccountId),
    account: account,
    key: account.caipAccountId,
    isPinned: Boolean(account.pinned),
    showConnectedStatus: false,
    startAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.Checkbox, {
      isChecked: selectedAccountAddresses.some(selectedAccountAddress => (0, _stringUtils.isEqualCaseInsensitive)(selectedAccountAddress, account.caipAccountId))
    }),
    selected: false
  })))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalFooter, null, selectedAccountAddresses.length === 0 ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 4,
    width: _designSystem.BlockSize.Full,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    gap: 1,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.Danger,
    size: _componentLibrary.IconSize.Xs,
    color: _designSystem.IconColor.errorDefault
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.errorDefault
  }, t('disconnectMessage'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonPrimary, {
    "data-testid": "disconnect-accounts-button",
    onClick: () => {
      onSubmit([]);
      onClose();
    },
    size: _componentLibrary.ButtonPrimarySize.Lg,
    block: true,
    danger: true
  }, t('disconnect'))) : /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonPrimary, {
    "data-testid": "connect-more-accounts-button",
    onClick: () => {
      const addedAccounts = selectedAccountAddresses.filter(address => !defaultSet.has(address));
      const removedAccounts = defaultSelectedAccountAddresses.filter(address => !selectedSet.has(address));
      onSubmit(selectedAccountAddresses);
      trackEvent({
        category: _metametrics.MetaMetricsEventCategory.Permissions,
        event: _metametrics.MetaMetricsEventName.UpdatePermissionedAccounts,
        properties: {
          addedAccounts: addedAccounts.length,
          removedAccounts: removedAccounts.length,
          location: 'Edit Accounts Modal'
        }
      });
      onClose();
    },
    size: _componentLibrary.ButtonPrimarySize.Lg,
    block: true
  }, t('update')))), modalStage === EditAccountModalStage.AddNewAccount && /*#__PURE__*/_react.default.createElement(_addNewAccountOption.EditAccountModalAddNewAccountOption, {
    setAccountTypeToAdd: accountTypeToAdd => {
      setAccountType(accountTypeToAdd);
      setModalStage(EditAccountModalStage.EditAccounts);
    }
  }), modalStage === EditAccountModalStage.EditAccounts && /*#__PURE__*/_react.default.createElement(_addAccount.EditAccountAddAccountForm, {
    onBack: () => setModalStage(EditAccountModalStage.AddNewAccount),
    onClose: () => setModalStage(EditAccountModalStage.AccountList),
    onActionComplete: handleAddAccount,
    accountType: accountType
  }));
};
exports.EditAccountsModal = EditAccountsModal;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\edit-accounts-modal\\edit-accounts-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\edit-accounts-modal\\index.ts", {"./edit-accounts-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\edit-accounts-modal\\edit-accounts-modal.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cedit-accounts-modal%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EditAccountsModal", {
  enumerable: true,
  get: function () {
    return _editAccountsModal.EditAccountsModal;
  }
});
var _editAccountsModal = require("./edit-accounts-modal");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\edit-accounts-modal\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\edit-networks-modal\\edit-networks-modal.js", {"..":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cedit-networks-modal%5Cedit-networks-modal.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditNetworksModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _componentLibrary = require("../../component-library");
var _ = require("..");
var _network = require("../../../../shared/constants/network");
var _metametrics = require("../../../../shared/constants/metametrics");
var _metametrics2 = require("../../../contexts/metametrics");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EditNetworksModal = ({
  nonTestNetworks,
  testNetworks,
  defaultSelectedChainIds,
  onClose,
  onSubmit
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const allNetworks = [...nonTestNetworks, ...testNetworks];
  const [selectedChainIds, setSelectedChainIds] = (0, _react.useState)(defaultSelectedChainIds);
  (0, _react.useEffect)(() => {
    setSelectedChainIds(defaultSelectedChainIds);
  }, [
  // TODO: Fix the source of this prop value to be the same array instance each render
  JSON.stringify(defaultSelectedChainIds)]);
  const selectAll = () => {
    const allNetworksChainIds = allNetworks.map(({
      caipChainId
    }) => caipChainId);
    setSelectedChainIds(allNetworksChainIds);
  };
  const deselectAll = () => {
    setSelectedChainIds([]);
  };
  const handleNetworkClick = chainId => {
    if (selectedChainIds.includes(chainId)) {
      setSelectedChainIds(selectedChainIds.filter(_chainId => _chainId !== chainId));
    } else {
      setSelectedChainIds([...selectedChainIds, chainId]);
    }
  };
  const allAreSelected = () => {
    return allNetworks.length === selectedChainIds.length;
  };
  const checked = allAreSelected();
  const isIndeterminate = !checked && selectedChainIds.length > 0;
  const defaultChainIdsSet = new Set(defaultSelectedChainIds);
  const selectedChainIdsSet = new Set(selectedChainIds);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: true,
    onClose: () => {
      onClose();
    },
    className: "edit-networks-modal"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onClose: () => {
      onClose();
    }
  }, t('editNetworksTitle')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, {
    paddingLeft: 0,
    paddingRight: 0,
    className: "edit-networks-modal__body"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    padding: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Checkbox, {
    label: t('selectAll'),
    isChecked: checked,
    gap: 4,
    onClick: () => allAreSelected() ? deselectAll() : selectAll(),
    isIndeterminate: isIndeterminate
  })), nonTestNetworks.map(network => /*#__PURE__*/_react.default.createElement(_.NetworkListItem, {
    name: network.name,
    iconSrc: _network.CHAIN_ID_TO_NETWORK_IMAGE_URL_MAP[network.chainId],
    key: network.caipChainId,
    onClick: () => {
      handleNetworkClick(network.caipChainId);
    },
    startAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.Checkbox, {
      isChecked: selectedChainIds.includes(network.caipChainId)
    })
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    padding: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium
  }, t('testnets'))), testNetworks.map(network => /*#__PURE__*/_react.default.createElement(_.NetworkListItem, {
    name: network.name,
    iconSrc: _network.CHAIN_ID_TO_NETWORK_IMAGE_URL_MAP[network.caipChainId],
    key: network.caipChainId,
    onClick: () => {
      handleNetworkClick(network.caipChainId);
    },
    startAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.Checkbox, {
      isChecked: selectedChainIds.includes(network.caipChainId)
    }),
    showEndAccessory: false
  }))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalFooter, null, selectedChainIds.length === 0 ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 4,
    alignItems: _designSystem.AlignItems.center,
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    gap: 1,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.Danger,
    size: _componentLibrary.IconSize.Sm,
    color: _designSystem.IconColor.errorDefault
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.errorDefault
  }, t('disconnectMessage'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonPrimary, {
    "data-testid": "disconnect-chains-button",
    onClick: () => {
      onSubmit(selectedChainIds);
      // Get networks that are in `selectedChainIds` but not in `defaultSelectedChainIds`
      const addedNetworks = selectedChainIds.filter(chainId => !defaultChainIdsSet.has(chainId));

      // Get networks that are in `defaultSelectedChainIds` but not in `selectedChainIds`
      const removedNetworks = defaultSelectedChainIds.filter(chainId => !selectedChainIdsSet.has(chainId));
      trackEvent({
        category: _metametrics.MetaMetricsEventCategory.Permissions,
        event: _metametrics.MetaMetricsEventName.UpdatePermissionedNetworks,
        properties: {
          addedNetworks: addedNetworks.length,
          removedNetworks: removedNetworks.length,
          location: 'Edit Networks Modal'
        }
      });
      onClose();
    },
    size: _componentLibrary.ButtonPrimarySize.Lg,
    block: true,
    danger: true
  }, t('disconnect'))) : /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonPrimary, {
    "data-testid": "connect-more-chains-button",
    onClick: () => {
      onSubmit(selectedChainIds);
      onClose();
    },
    size: _componentLibrary.ButtonPrimarySize.Lg,
    block: true
  }, t('update')))));
};
exports.EditNetworksModal = EditNetworksModal;
EditNetworksModal.propTypes = {
  /**
   * Array of network objects representing available non-test networks to choose from.
   */
  nonTestNetworks: _propTypes.default.arrayOf(_propTypes.default.shape({
    caipChainId: _propTypes.default.string.isRequired,
    // The caip chain ID of the network
    name: _propTypes.default.string.isRequired // Display name of the network
  })).isRequired,
  /**
   * Array of network objects representing available test networks to choose from.
   */
  testNetworks: _propTypes.default.arrayOf(_propTypes.default.shape({
    caipChainId: _propTypes.default.string.isRequired,
    // The caip chain ID of the network
    name: _propTypes.default.string.isRequired // Display name of the network
  })).isRequired,
  /**
   * Array of chain IDs to have selected by default.
   */
  defaultSelectedChainIds: _propTypes.default.arrayOf(_propTypes.default.string),
  /**
   * Function to execute when the modal is closed.
   */
  onClose: _propTypes.default.func.isRequired,
  /**
   * Function to execute when an update or disconnect action is triggered.
   */
  onSubmit: _propTypes.default.func.isRequired
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\edit-networks-modal\\edit-networks-modal.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\edit-networks-modal\\index.js", {"./edit-networks-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\edit-networks-modal\\edit-networks-modal.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cedit-networks-modal%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EditNetworksModal", {
  enumerable: true,
  get: function () {
    return _editNetworksModal.EditNetworksModal;
  }
});
var _editNetworksModal = require("./edit-networks-modal");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\edit-networks-modal\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\funding-method-modal\\funding-method-item.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cfunding-method-modal%5Cfunding-method-item.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const FundingMethodItem = ({
  icon,
  title,
  description,
  onClick
}) => /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
  display: [_designSystem.Display.Flex],
  gap: 2,
  alignItems: _designSystem.AlignItems.center,
  onClick: onClick,
  className: "funding-method-item",
  padding: 4
}, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
  name: icon
}), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
  display: [_designSystem.Display.Flex],
  flexDirection: _designSystem.FlexDirection.Column
}, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
  variant: _designSystem.TextVariant.bodyMdMedium
}, title), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
  variant: _designSystem.TextVariant.bodySm,
  color: _designSystem.TextColor.textAlternative
}, description)));
var _default = exports.default = FundingMethodItem;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\funding-method-modal\\funding-method-item.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\funding-method-modal\\funding-method-modal.tsx", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/portfolio":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\portfolio.js","../../../hooks/ramps/useRamps/useRamps":"D:\\code\\v\\metamask-extension\\ui\\hooks\\ramps\\useRamps\\useRamps.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","./funding-method-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\funding-method-modal\\funding-method-item.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cfunding-method-modal%5Cfunding-method-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FundingMethodModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _multichain = require("../../../selectors/multichain");
var _useRamps = _interopRequireWildcard(require("../../../hooks/ramps/useRamps/useRamps"));
var _portfolio = require("../../../helpers/utils/portfolio");
var _selectors = require("../../../selectors");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _metametrics = require("../../../../shared/constants/metametrics");
var _metametrics2 = require("../../../contexts/metametrics");
var _fundingMethodItem = _interopRequireDefault(require("./funding-method-item"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FundingMethodModal = ({
  isOpen,
  onClose,
  title,
  onClickReceive
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const {
    openBuyCryptoInPdapp
  } = (0, _useRamps.default)();
  const {
    address: accountAddress
  } = (0, _reactRedux.useSelector)(_selectors.getSelectedAccount);
  const {
    chainId
  } = (0, _reactRedux.useSelector)(_multichain.getMultichainCurrentNetwork);
  const {
    symbol
  } = (0, _reactRedux.useSelector)(_multichain.getMultichainDefaultToken);
  const metaMetricsId = (0, _reactRedux.useSelector)(_selectors.getMetaMetricsId);
  const isMetaMetricsEnabled = (0, _reactRedux.useSelector)(_selectors.getParticipateInMetaMetrics);
  const isMarketingEnabled = (0, _reactRedux.useSelector)(_selectors.getDataCollectionForMarketing);
  const handleTransferCryptoClick = (0, _react.useCallback)(() => {
    trackEvent({
      event: _metametrics.MetaMetricsEventName.NavSendButtonClicked,
      category: _metametrics.MetaMetricsEventCategory.Navigation,
      properties: {
        location: _useRamps.RampsMetaMaskEntry === null || _useRamps.RampsMetaMaskEntry === void 0 ? void 0 : _useRamps.RampsMetaMaskEntry.TokensBanner,
        text: 'Transfer crypto',
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        chain_id: chainId,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        token_symbol: symbol
      }
    });
    const url = (0, _portfolio.getPortfolioUrl)('transfer', 'ext_funding_method_modal', metaMetricsId, isMetaMetricsEnabled, isMarketingEnabled, accountAddress, 'transfer');
    global.platform.openTab({
      url
    });
  }, [metaMetricsId, isMetaMetricsEnabled, isMarketingEnabled, chainId, symbol, accountAddress]);
  const handleBuyCryptoClick = (0, _react.useCallback)(() => {
    trackEvent({
      event: _metametrics.MetaMetricsEventName.NavBuyButtonClicked,
      category: _metametrics.MetaMetricsEventCategory.Navigation,
      properties: {
        location: _useRamps.RampsMetaMaskEntry === null || _useRamps.RampsMetaMaskEntry === void 0 ? void 0 : _useRamps.RampsMetaMaskEntry.TokensBanner,
        text: 'Buy crypto',
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        chain_id: chainId,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        token_symbol: symbol
      }
    });
    openBuyCryptoInPdapp(chainId);
  }, [chainId, symbol]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: isOpen,
    onClose: onClose,
    "data-testid": "funding-method-modal"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, {
    modalDialogProps: {
      padding: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    paddingBottom: 2,
    onClose: onClose
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingSm,
    textAlign: _designSystem.TextAlign.Center
  }, title)), /*#__PURE__*/_react.default.createElement(_fundingMethodItem.default, {
    icon: _componentLibrary.IconName.Card,
    title: t('tokenMarketplace'),
    description: t('debitCreditPurchaseOptions'),
    onClick: handleBuyCryptoClick
  }), /*#__PURE__*/_react.default.createElement(_fundingMethodItem.default, {
    icon: _componentLibrary.IconName.Received,
    title: t('receiveCrypto'),
    description: t('depositCrypto'),
    onClick: onClickReceive
  }), /*#__PURE__*/_react.default.createElement(_fundingMethodItem.default, {
    icon: _componentLibrary.IconName.Link,
    title: t('transferCrypto'),
    description: t('linkCentralizedExchanges'),
    onClick: handleTransferCryptoClick
  })));
};
exports.FundingMethodModal = FundingMethodModal;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\funding-method-modal\\funding-method-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\global-menu\\global-menu.tsx", {"../../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/lib/shield":"D:\\code\\v\\metamask-extension\\shared\\lib\\shield.ts","../../../../shared/lib/ui-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\ui-utils.js","../../../../shared/modules/environment":"D:\\code\\v\\metamask-extension\\shared\\modules\\environment.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../hooks/metamask-notifications/useCounter":"D:\\code\\v\\metamask-extension\\ui\\hooks\\metamask-notifications\\useCounter.tsx","../../../hooks/subscription/useSubscription":"D:\\code\\v\\metamask-extension\\ui\\hooks\\subscription\\useSubscription.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../pages/notifications/NewFeatureTag":"D:\\code\\v\\metamask-extension\\ui\\pages\\notifications\\NewFeatureTag.tsx","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/identity/backup-and-sync":"D:\\code\\v\\metamask-extension\\ui\\selectors\\identity\\backup-and-sync.ts","../../../selectors/metamask-notifications/metamask-notifications":"D:\\code\\v\\metamask-extension\\ui\\selectors\\metamask-notifications\\metamask-notifications.ts","../../../selectors/multichain-accounts/feature-flags":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\feature-flags.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/menu":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\menu\\index.ts","../menu-items":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\menu-items\\index.js","../notifications-tag-counter":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notifications-tag-counter\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cglobal-menu%5Cglobal-menu.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GlobalMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _useCounter = require("../../../hooks/metamask-notifications/useCounter");
var _notificationsTagCounter = require("../notifications-tag-counter");
var _NewFeatureTag = require("../../../pages/notifications/NewFeatureTag");
var _routes = require("../../../helpers/constants/routes");
var _actions = require("../../../store/actions");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _metamaskNotifications = require("../../../selectors/metamask-notifications/metamask-notifications");
var _backupAndSync = require("../../../selectors/identity/backup-and-sync");
var _componentLibrary = require("../../component-library");
var _menu = require("../../ui/menu");
var _util = require("../../../../app/scripts/lib/util");
var _app = require("../../../../shared/constants/app");
var _uiUtils = require("../../../../shared/lib/ui-utils");
var _metametrics = require("../../../contexts/metametrics");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _selectors = require("../../../selectors");
var _designSystem = require("../../../helpers/constants/design-system");
var _menuItems = require("../menu-items");
var _featureFlags = require("../../../selectors/multichain-accounts/feature-flags");
var _useSubscription = require("../../../hooks/subscription/useSubscription");
var _environment = require("../../../../shared/modules/environment");
var _shield = require("../../../../shared/lib/shield");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

const METRICS_LOCATION = 'Global Menu';
const GlobalMenu = ({
  closeMenu,
  anchorElement,
  isOpen
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const basicFunctionality = (0, _reactRedux.useSelector)(_selectors.getUseExternalServices);
  const history = (0, _reactRouterDom.useHistory)();
  const {
    notificationsUnreadCount
  } = (0, _useCounter.useUnreadNotificationsCounter)();
  const {
    notificationsReadCount
  } = (0, _useCounter.useReadNotificationsCounter)();
  const {
    subscriptions
  } = (0, _useSubscription.useUserSubscriptions)();
  const isActiveShieldSubscription = (0, _shield.getIsShieldSubscriptionActive)(subscriptions);
  const account = (0, _reactRedux.useSelector)(_selectors.getSelectedInternalAccount);
  const isMultichainAccountsState2Enabled = (0, _reactRedux.useSelector)(_featureFlags.getIsMultichainAccountsState2Enabled);
  const unapprovedTransactions = (0, _reactRedux.useSelector)(_selectors.getUnapprovedTransactions);
  const isMetamaskNotificationFeatureSeen = (0, _reactRedux.useSelector)(_metamaskNotifications.selectIsMetamaskNotificationsFeatureSeen);
  const isMetamaskNotificationsEnabled = (0, _reactRedux.useSelector)(_metamaskNotifications.selectIsMetamaskNotificationsEnabled);
  const isBackupAndSyncEnabled = (0, _reactRedux.useSelector)(_backupAndSync.selectIsBackupAndSyncEnabled);
  const hasUnapprovedTransactions = Object.keys(unapprovedTransactions).length > 0;

  /**
   * This condition is used to control whether the client shows the "turn on notifications"
   * modal. This allowed third party users with existing notifications to view their snap
   * notifications without turning on wallet notifications
   *
   * It excludes users with preinstalled notify snaps (e.g. the institutional snap)
   * which have the notify permission, so as to retain the existing workflow
   */

  let hasThirdPartyNotifySnaps = false;
  const snapsUpdatesAvailable = (0, _reactRedux.useSelector)(_selectors.getAnySnapUpdateAvailable);
  hasThirdPartyNotifySnaps = (0, _reactRedux.useSelector)(_selectors.getThirdPartyNotifySnaps).length > 0;
  let supportText = t('support');
  let supportLink = _uiUtils.SUPPORT_LINK || '';

  // Accessibility improvement for popover
  const lastItemRef = _react.default.useRef(null);
  _react.default.useEffect(() => {
    const lastItem = lastItemRef.current;
    const handleKeyDown = event => {
      if (event.key === 'Tab' && !event.shiftKey) {
        event.preventDefault();
        closeMenu();
      }
    };
    if (lastItem) {
      lastItem.addEventListener('keydown', handleKeyDown);
    }
    return () => {
      if (lastItem) {
        lastItem.removeEventListener('keydown', handleKeyDown);
      }
    };
  }, [closeMenu]);
  const handleNotificationsClick = () => {
    const shouldShowEnableModal = !hasThirdPartyNotifySnaps && !isMetamaskNotificationsEnabled;
    if (shouldShowEnableModal) {
      trackEvent({
        category: _metametrics2.MetaMetricsEventCategory.NotificationsActivationFlow,
        event: _metametrics2.MetaMetricsEventName.NotificationsActivated,
        properties: {
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          action_type: 'started',
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          is_profile_syncing_enabled: isBackupAndSyncEnabled
        }
      });
      dispatch((0, _actions.showConfirmTurnOnMetamaskNotifications)());
      closeMenu();
      return;
    }

    // Otherwise we can navigate to the notifications page
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.NotificationInteraction,
      event: _metametrics2.MetaMetricsEventName.NotificationsMenuOpened,
      properties: {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        unread_count: notificationsUnreadCount,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        read_count: notificationsReadCount
      }
    });
    history.push(_routes.NOTIFICATIONS_ROUTE);
    closeMenu();
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Popover, {
    "data-testid": "global-menu",
    referenceElement: anchorElement,
    isOpen: isOpen,
    padding: 0,
    onClickOutside: closeMenu,
    onPressEscKey: closeMenu,
    style: {
      overflow: 'hidden',
      minWidth: 225
    },
    offset: [0, 8],
    position: _componentLibrary.PopoverPosition.BottomEnd
  }, basicFunctionality && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_menu.MenuItem, {
    iconName: _componentLibrary.IconName.Notification,
    onClick: () => handleNotificationsClick(),
    "data-testid": "notifications-menu-item"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, t('notifications'), notificationsUnreadCount === 0 && !isMetamaskNotificationFeatureSeen && /*#__PURE__*/_react.default.createElement(_NewFeatureTag.NewFeatureTag, null), /*#__PURE__*/_react.default.createElement(_notificationsTagCounter.NotificationsTagCounter, null)))), account && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_menuItems.AccountDetailsMenuItem, {
    metricsLocation: METRICS_LOCATION,
    closeMenu: closeMenu,
    address: account.address
  }), isMultichainAccountsState2Enabled ? null : /*#__PURE__*/_react.default.createElement(_menuItems.ViewExplorerMenuItem, {
    metricsLocation: METRICS_LOCATION,
    closeMenu: closeMenu,
    account: account
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    borderColor: _designSystem.BorderColor.borderMuted,
    width: _designSystem.BlockSize.Full,
    style: {
      height: '1px',
      borderBottomWidth: 0
    }
  }), /*#__PURE__*/_react.default.createElement(_menu.MenuItem, {
    to: (0, _environment.isGatorPermissionsRevocationFeatureEnabled)() ? _routes.GATOR_PERMISSIONS : _routes.PERMISSIONS,
    iconName: _componentLibrary.IconName.SecurityTick,
    onClick: () => {
      trackEvent({
        event: _metametrics2.MetaMetricsEventName.NavPermissionsOpened,
        category: _metametrics2.MetaMetricsEventCategory.Navigation,
        properties: {
          location: METRICS_LOCATION
        }
      });
      closeMenu();
    },
    "data-testid": "global-menu-connected-sites",
    disabled: hasUnapprovedTransactions
  }, t('allPermissions')), (0, _util.getEnvironmentType)() === _app.ENVIRONMENT_TYPE_FULLSCREEN ? null : /*#__PURE__*/_react.default.createElement(_menu.MenuItem, {
    iconName: _componentLibrary.IconName.Expand,
    onClick: () => {
      var _global, _global$openExtension;
      (_global = global) === null || _global === void 0 || (_global = _global.platform) === null || _global === void 0 || (_global$openExtension = _global.openExtensionInBrowser) === null || _global$openExtension === void 0 || _global$openExtension.call(_global);
      trackEvent({
        event: _metametrics2.MetaMetricsEventName.AppWindowExpanded,
        category: _metametrics2.MetaMetricsEventCategory.Navigation,
        properties: {
          location: METRICS_LOCATION
        }
      });
      closeMenu();
    },
    "data-testid": "global-menu-expand"
  }, t('expandView')), /*#__PURE__*/_react.default.createElement(_menu.MenuItem, {
    "data-testid": "global-menu-networks",
    iconName: _componentLibrary.IconName.Hierarchy,
    onClick: () => {
      dispatch((0, _actions.toggleNetworkMenu)());
      closeMenu();
    }
  }, t('networks')), /*#__PURE__*/_react.default.createElement(_menu.MenuItem, {
    to: _routes.SNAPS_ROUTE,
    iconName: _componentLibrary.IconName.Snaps,
    onClick: closeMenu,
    showInfoDot: snapsUpdatesAvailable
  }, t('snaps')), /*#__PURE__*/_react.default.createElement(_menu.MenuItem, {
    iconName: _componentLibrary.IconName.MessageQuestion,
    onClick: () => {
      dispatch((0, _actions.setShowSupportDataConsentModal)(true));
      trackEvent({
        category: _metametrics2.MetaMetricsEventCategory.Home,
        event: _metametrics2.MetaMetricsEventName.SupportLinkClicked,
        properties: {
          url: supportLink,
          location: METRICS_LOCATION
        }
      }, {
        contextPropsIntoEventProperties: [_metametrics2.MetaMetricsContextProp.PageTitle]
      });
      closeMenu();
    },
    "data-testid": "global-menu-support"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, supportText, isActiveShieldSubscription && basicFunctionality && /*#__PURE__*/_react.default.createElement(_componentLibrary.Tag, {
    label: t('priority'),
    labelProps: {
      variant: _designSystem.TextVariant.bodySmMedium,
      color: _designSystem.TextColor.successDefault
    },
    startIconName: _componentLibrary.IconName.Sparkle,
    startIconProps: {
      color: _designSystem.IconColor.successDefault
    },
    borderStyle: _designSystem.BorderStyle.none,
    borderRadius: _designSystem.BorderRadius.LG,
    backgroundColor: _designSystem.BackgroundColor.successMuted
  }))), /*#__PURE__*/_react.default.createElement(_menu.MenuItem, {
    to: _routes.SETTINGS_ROUTE,
    iconName: _componentLibrary.IconName.Setting,
    disabled: hasUnapprovedTransactions,
    onClick: () => {
      trackEvent({
        category: _metametrics2.MetaMetricsEventCategory.Navigation,
        event: _metametrics2.MetaMetricsEventName.NavSettingsOpened,
        properties: {
          location: METRICS_LOCATION
        }
      });
      closeMenu();
    },
    "data-testid": "global-menu-settings"
  }, t('settings')), /*#__PURE__*/_react.default.createElement(_menu.MenuItem, {
    to: _routes.DEFAULT_ROUTE,
    ref: lastItemRef // ref for last item in GlobalMenu
    ,
    iconName: _componentLibrary.IconName.Lock,
    onClick: () => {
      dispatch((0, _actions.lockMetamask)(t('lockMetaMaskLoadingMessage')));
      trackEvent({
        category: _metametrics2.MetaMetricsEventCategory.Navigation,
        event: _metametrics2.MetaMetricsEventName.AppLocked,
        properties: {
          location: METRICS_LOCATION
        }
      });
      closeMenu();
    },
    "data-testid": "global-menu-lock"
  }, t('lockMetaMask')));
};
exports.GlobalMenu = GlobalMenu;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\global-menu\\global-menu.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\global-menu\\index.ts", {"./global-menu":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\global-menu\\global-menu.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cglobal-menu%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "GlobalMenu", {
  enumerable: true,
  get: function () {
    return _globalMenu.GlobalMenu;
  }
});
var _globalMenu = require("./global-menu");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\global-menu\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\import-account\\bottom-buttons.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cimport-account%5Cbottom-buttons.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = BottomButtons;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var actions = _interopRequireWildcard(require("../../../store/actions"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function BottomButtons({
  importAccountFunc,
  isPrimaryDisabled,
  onActionComplete
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonSecondary, {
    onClick: () => {
      dispatch(actions.hideWarning());
      onActionComplete();
    },
    size: _componentLibrary.ButtonSecondarySize.Lg,
    block: true
  }, t('cancel')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonPrimary, {
    onClick: async () => {
      try {
        const result = await importAccountFunc();
        if (result) {
          onActionComplete(true);
        }
      } catch (e) {
        // Take no action
      }
    },
    disabled: isPrimaryDisabled,
    size: _componentLibrary.ButtonSecondarySize.Lg,
    "data-testid": "import-account-confirm-button",
    block: true
  }, t('import')));
}
BottomButtons.propTypes = {
  /**
   * Function to import the account
   */
  importAccountFunc: _propTypes.default.func.isRequired,
  /**
   * Represents if the action button is disabled
   */
  isPrimaryDisabled: _propTypes.default.bool.isRequired,
  /**
   * Executes when the primary action is complete
   */
  onActionComplete: _propTypes.default.func.isRequired
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\import-account\\bottom-buttons.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\import-account\\import-account.js", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/modules/error":"D:\\code\\v\\metamask-extension\\shared\\modules\\error.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/zendesk-url":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\zendesk-url.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/dropdown":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\dropdown\\index.js","./json":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\import-account\\json.js","./private-key":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\import-account\\private-key.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cimport-account%5Cimport-account.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImportAccount = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRedux = require("react-redux");
var _error = require("../../../../shared/modules/error");
var _metametrics = require("../../../../shared/constants/metametrics");
var _componentLibrary = require("../../component-library");
var _dropdown = _interopRequireDefault(require("../../ui/dropdown"));
var _metametrics2 = require("../../../contexts/metametrics");
var _designSystem = require("../../../helpers/constants/design-system");
var _zendeskUrl = _interopRequireDefault(require("../../../helpers/constants/zendesk-url"));
var _useI18nContext = require("../../../hooks/useI18nContext");
var actions = _interopRequireWildcard(require("../../../store/actions"));
var _selectors = require("../../../selectors/selectors");
var _selectors2 = require("../../../selectors");
var _json = _interopRequireDefault(require("./json"));
var _privateKey = _interopRequireDefault(require("./private-key"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Subviews

const ImportAccount = ({
  onActionComplete
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const hdEntropyIndex = (0, _reactRedux.useSelector)(_selectors.getHDEntropyIndex);
  const isSocialLoginFlow = (0, _reactRedux.useSelector)(_selectors2.getIsSocialLoginFlow);
  const menuItems = [t('privateKey'), t('jsonFile')];
  const [type, setType] = (0, _react.useState)(menuItems[0]);
  async function importAccount(strategy, importArgs) {
    const loadingMessage = getLoadingMessage(strategy);
    try {
      if (isSocialLoginFlow) {
        const isPasswordOutdated = await dispatch(actions.checkIsSeedlessPasswordOutdated(true));
        if (isPasswordOutdated) {
          return false;
        }
      }
      const {
        selectedAddress
      } = await dispatch(actions.importNewAccount(strategy, importArgs, loadingMessage));
      if (selectedAddress) {
        trackImportEvent(strategy, true);
        dispatch(actions.hideWarning());
        onActionComplete(true);
      } else {
        dispatch(actions.displayWarning(t('importAccountError')));
        return false;
      }
    } catch (error) {
      const message = (0, _error.getErrorMessage)(error);
      trackImportEvent(strategy, message);
      translateWarning(message);
      return false;
    }
    return true;
  }
  function trackImportEvent(strategy, wasSuccessful) {
    const accountImportType = strategy === 'Private Key' ? _metametrics.MetaMetricsEventAccountImportType.PrivateKey : _metametrics.MetaMetricsEventAccountImportType.Json;
    const event = wasSuccessful ? _metametrics.MetaMetricsEventName.AccountAdded : _metametrics.MetaMetricsEventName.AccountAddFailed;
    trackEvent({
      category: _metametrics.MetaMetricsEventCategory.Accounts,
      event,
      properties: {
        account_type: _metametrics.MetaMetricsEventAccountType.Imported,
        account_import_type: accountImportType,
        hd_entropy_index: hdEntropyIndex,
        is_suggested_name: true
      }
    });
  }
  function getLoadingMessage(strategy) {
    if (strategy === 'json') {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        width: _designSystem.BlockSize.ThreeFourths,
        fontWeight: _designSystem.FontWeight.Bold
      }, t('importAccountJsonLoading1')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        width: _designSystem.BlockSize.ThreeFourths,
        fontWeight: _designSystem.FontWeight.Bold
      }, t('importAccountJsonLoading2')));
    }
    return '';
  }

  /**
   * @param message - an Error/Warning message caught in importAccount()
   * This function receives a message that is a string like:
   * `t('importAccountErrorNotHexadecimal')`
   * `t('importAccountErrorIsSRP')`
   * `t('importAccountErrorNotAValidPrivateKey')`
   * and feeds it through useI18nContext
   */
  function translateWarning(message) {
    if (message && !message.startsWith('t(')) {
      // This is just a normal error message
      dispatch(actions.displayWarning(message));
    } else {
      // This is an error message in a form like
      // `t('importAccountErrorNotHexadecimal')`
      // so slice off the first 3 chars and last 2 chars, and feed to i18n
      dispatch(actions.displayWarning(t(message.slice(3, -2))));
    }
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isSocialLoginFlow ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm
  }, t('importAccountWithSocialMsg')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm
  }, t('importAccountWithSocialMsgLearnMore', [/*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    size: _designSystem.Size.inherit,
    href: _zendeskUrl.default.IMPORTED_ACCOUNTS_PRIVATE_KEY,
    target: "_blank",
    rel: "noopener noreferrer",
    key: "importAccountWithSocialMsgLearnMore"
  }, t('learnMoreUpperCase'))]))) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    marginTop: 2
  }, t('importAccountMsg'), ' ', /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    size: _designSystem.Size.inherit,
    href: _zendeskUrl.default.IMPORTED_ACCOUNTS_PRIVATE_KEY,
    target: "_blank",
    rel: "noopener noreferrer"
  }, t('here'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingTop: 4,
    paddingBottom: 8
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Label, {
    width: _designSystem.BlockSize.Full,
    marginBottom: 4,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, t('selectType'), /*#__PURE__*/_react.default.createElement(_dropdown.default, {
    options: menuItems.map(text => ({
      value: text
    })),
    selectedOption: type,
    onChange: value => {
      dispatch(actions.hideWarning());
      setType(value);
    }
  })), type === menuItems[0] ? /*#__PURE__*/_react.default.createElement(_privateKey.default, {
    importAccountFunc: importAccount,
    onActionComplete: onActionComplete
  }) : /*#__PURE__*/_react.default.createElement(_json.default, {
    importAccountFunc: importAccount,
    onActionComplete: onActionComplete
  })));
};
exports.ImportAccount = ImportAccount;
ImportAccount.propTypes = {
  /**
   * Executes when the key is imported
   */
  onActionComplete: _propTypes.default.func.isRequired
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\import-account\\import-account.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\import-account\\index.js", {"./import-account":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\import-account\\import-account.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cimport-account%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ImportAccount", {
  enumerable: true,
  get: function () {
    return _importAccount.ImportAccount;
  }
});
var _importAccount = require("./import-account");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\import-account\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\import-account\\json.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/zendesk-url":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\zendesk-url.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../component-library/form-text-field/deprecated":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\form-text-field\\deprecated\\index.js","./bottom-buttons":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\import-account\\bottom-buttons.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-simple-file-input":"D:\\code\\v\\metamask-extension\\node_modules\\react-simple-file-input\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cimport-account%5Cjson.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = JsonImportSubview;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactSimpleFileInput = _interopRequireDefault(require("react-simple-file-input"));
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _deprecated = require("../../component-library/form-text-field/deprecated");
var _zendeskUrl = _interopRequireDefault(require("../../../helpers/constants/zendesk-url"));
var _useI18nContext = require("../../../hooks/useI18nContext");
var _actions = require("../../../store/actions");
var _bottomButtons = _interopRequireDefault(require("./bottom-buttons"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function JsonImportSubview({
  importAccountFunc,
  onActionComplete
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  const warning = (0, _reactRedux.useSelector)(state => state.appState.warning);
  const [password, setPassword] = (0, _react.useState)('');
  const [fileContents, setFileContents] = (0, _react.useState)('');
  const isPrimaryDisabled = fileContents === '';
  function handleKeyPress(event) {
    if (!isPrimaryDisabled && event.key === 'Enter') {
      event.preventDefault();
      _importAccountFunc();
    }
  }
  function _importAccountFunc() {
    if (isPrimaryDisabled) {
      (0, _actions.displayWarning)(t('needImportFile'));
    } else {
      importAccountFunc('json', [fileContents, password]);
    }
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    textAlign: _designSystem.TextAlign.Center
  }, t('usedByClients'), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    size: _designSystem.Size.inherit,
    href: _zendeskUrl.default.IMPORTED_ACCOUNT_JSON,
    target: "_blank",
    rel: "noopener noreferrer"
  }, t('fileImportFail'))), /*#__PURE__*/_react.default.createElement(_reactSimpleFileInput.default, {
    id: "file-input",
    "data-testid": "file-input",
    readAs: "text",
    onLoad: event => setFileContents(event.target.result),
    style: {
      padding: '20px 0px 12px 15%',
      fontSize: '16px',
      display: 'flex',
      justifyContent: 'center',
      width: '100%'
    }
  }), /*#__PURE__*/_react.default.createElement(_deprecated.FormTextField, {
    id: "json-password-box",
    size: _componentLibrary.TextFieldSize.Lg,
    autoFocus: true,
    type: _componentLibrary.TextFieldType.Password,
    helpText: warning,
    error: true,
    placeholder: t('enterOptionalPassword'),
    value: password,
    onChange: event => {
      setPassword(event.target.value);
    },
    inputProps: {
      onKeyPress: handleKeyPress
    },
    marginBottom: 4
  }), /*#__PURE__*/_react.default.createElement(_bottomButtons.default, {
    importAccountFunc: _importAccountFunc,
    isPrimaryDisabled: isPrimaryDisabled,
    onActionComplete: onActionComplete
  }));
}
JsonImportSubview.propTypes = {
  /**
   * Function to import the account
   */
  importAccountFunc: _propTypes.default.func.isRequired,
  /**
   * Executes when the key is imported
   */
  onActionComplete: _propTypes.default.func.isRequired
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\import-account\\json.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\import-account\\private-key.js", {"../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/show-hide-toggle":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\show-hide-toggle\\index.js","./bottom-buttons":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\import-account\\bottom-buttons.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cimport-account%5Cprivate-key.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = PrivateKeyImportView;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _componentLibrary = require("../../component-library");
var _actions = require("../../../store/actions");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _showHideToggle = _interopRequireDefault(require("../../ui/show-hide-toggle"));
var _bottomButtons = _interopRequireDefault(require("./bottom-buttons"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function PrivateKeyImportView({
  importAccountFunc,
  onActionComplete
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const [privateKey, setPrivateKey] = (0, _react.useState)('');
  const [showPrivateKey, setShowPrivateKey] = (0, _react.useState)(false);

  // Since MetaMask still uses a global warning state,
  // hide the "invalid" warning when the private key import view is unmounted
  (0, _react.useEffect)(() => {
    return () => {
      dispatch((0, _actions.hideWarning)());
    };
  }, [dispatch]);
  const warning = (0, _reactRedux.useSelector)(state => state.appState.warning);
  function handleKeyPress(event) {
    if (privateKey !== '' && event.key === 'Enter') {
      event.preventDefault();
      _importAccountFunc();
    }
  }
  function _importAccountFunc() {
    importAccountFunc('privateKey', [privateKey]);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.FormTextField, {
    id: "private-key-box",
    size: _componentLibrary.TextFieldSize.Lg,
    autoFocus: true,
    helpText: warning,
    error: Boolean(warning),
    label: t('pastePrivateKey'),
    value: privateKey,
    onChange: event => setPrivateKey(event.target.value),
    inputProps: {
      onKeyPress: handleKeyPress
    },
    marginBottom: 4,
    type: showPrivateKey ? _componentLibrary.TextFieldType.Text : _componentLibrary.TextFieldType.Password,
    textFieldProps: {
      endAccessory: /*#__PURE__*/_react.default.createElement(_showHideToggle.default, {
        shown: showPrivateKey,
        id: "show-hide-private-key",
        title: t('privateKeyShow'),
        ariaLabelShown: t('privateKeyShown'),
        ariaLabelHidden: t('privateKeyHidden'),
        onChange: () => setShowPrivateKey(!showPrivateKey)
      })
    }
  }), /*#__PURE__*/_react.default.createElement(_bottomButtons.default, {
    importAccountFunc: _importAccountFunc,
    isPrimaryDisabled: privateKey === '',
    onActionComplete: onActionComplete
  }));
}
PrivateKeyImportView.propTypes = {
  /**
   * Function to import the account
   */
  importAccountFunc: _propTypes.default.func.isRequired,
  /**
   * Executes when the key is imported
   */
  onActionComplete: _propTypes.default.func.isRequired
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\import-account\\private-key.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\import-nfts-modal\\import-nfts-modal.js", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../../shared/modules/error":"D:\\code\\v\\metamask-extension\\shared\\modules\\error.ts","../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../hooks/useNftsCollections":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useNftsCollections.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../app/assets/nfts/nfts-detection-notice-import-nfts/nfts-detection-notice-import-nfts":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\nfts\\nfts-detection-notice-import-nfts\\nfts-detection-notice-import-nfts.tsx","../../app/import-token/network-selector-custom-import":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\import-token\\network-selector-custom-import\\index.tsx","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../component-library/form-text-field/deprecated":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\form-text-field\\deprecated\\index.js","../../ui/tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\index.js","../network-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-item\\index.js","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cimport-nfts-modal%5Cimport-nfts-modal.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImportNftsModal = void 0;
var _controllerUtils = require("@metamask/controller-utils");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _error = require("../../../../shared/modules/error");
var _metametrics = require("../../../../shared/constants/metametrics");
var _transaction = require("../../../../shared/constants/transaction");
var _metametrics2 = require("../../../contexts/metametrics");
var _metamask = require("../../../ducks/metamask/metamask");
var _designSystem = require("../../../helpers/constants/design-system");
var _routes = require("../../../helpers/constants/routes");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _networks = require("../../../../shared/modules/selectors/networks");
var _selectors = require("../../../selectors");
var _multichain = require("../../../selectors/multichain");
var _actions = require("../../../store/actions");
var _nftsDetectionNoticeImportNfts = _interopRequireDefault(require("../../app/assets/nfts/nfts-detection-notice-import-nfts/nfts-detection-notice-import-nfts"));
var _componentLibrary = require("../../component-library");
var _deprecated = require("../../component-library/form-text-field/deprecated");
var _tooltip = _interopRequireDefault(require("../../ui/tooltip"));
var _useNftsCollections = require("../../../hooks/useNftsCollections");
var _util = require("../../../helpers/utils/util");
var _networkListItem = require("../network-list-item");
var _networkSelectorCustomImport = require("../../app/import-token/network-selector-custom-import");
var _trace = require("../../../../shared/lib/trace");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const ACTION_MODES = {
  // Displays the import nft modal
  IMPORT_TOKEN: 'IMPORT_NFT',
  // Displays the page for selecting a network from custom import
  NETWORK_SELECTOR: 'NETWORK_SELECTOR'
};
const ImportNftsModal = ({
  onClose
}) => {
  var _networkConfiguration;
  const t = (0, _useI18nContext.useI18nContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const isDisplayNFTMediaToggleEnabled = (0, _reactRedux.useSelector)(_selectors.getOpenSeaEnabled);
  const isMainnet = (0, _reactRedux.useSelector)(_selectors.getIsMainnet);
  const nftsDropdownState = (0, _reactRedux.useSelector)(_metamask.getNftsDropdownState);
  const selectedAccount = (0, _reactRedux.useSelector)(_selectors.getSelectedInternalAccount);
  const chainId = (0, _reactRedux.useSelector)(_networks.getCurrentChainId);
  const networkClientId = (0, _reactRedux.useSelector)(_networks.getSelectedNetworkClientId);
  const {
    tokenAddress: initialTokenAddress,
    tokenId: initialTokenId,
    ignoreErc20Token
  } = (0, _reactRedux.useSelector)(state => state.appState.importNftsModal);
  const existingNfts = (0, _useNftsCollections.useNftsCollections)();
  const [nftAddress, setNftAddress] = (0, _react.useState)(initialTokenAddress ?? '');
  const [tokenId, setTokenId] = (0, _react.useState)(initialTokenId ?? '');
  const [disabled, setDisabled] = (0, _react.useState)(true);
  const [nftAddFailed, setNftAddFailed] = (0, _react.useState)(false);
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const [actionMode, setActionMode] = (0, _react.useState)(ACTION_MODES.IMPORT_NFT);
  const [selectedNetworkForCustomImport, setSelectedNetworkForCustomImport] = (0, _react.useState)(null);
  const [selectedNetworkClientId, setSelectedNetworkClientIdForCustomImport] = (0, _react.useState)(null);
  const networkConfigurations = (0, _reactRedux.useSelector)(_networks.getNetworkConfigurationsByChainId);
  const [nftAddressValidationError, setNftAddressValidationError] = (0, _react.useState)(null);
  const [duplicateTokenIdError, setDuplicateTokenIdError] = (0, _react.useState)(null);
  const handleAddNft = async () => {
    (0, _trace.trace)({
      name: _trace.TraceName.ImportNfts
    });
    try {
      var _nftsDropdownState$se;
      await dispatch(
      // selectedNetworkClientId is for the network the NFT is on, not the globally selected network of the wallet
      (0, _actions.addNftVerifyOwnership)(nftAddress, tokenId, selectedNetworkClientId));
      const newNftDropdownState = {
        ...nftsDropdownState,
        [selectedAccount.address]: {
          ...(nftsDropdownState === null || nftsDropdownState === void 0 ? void 0 : nftsDropdownState[selectedAccount.address]),
          [chainId]: {
            ...(nftsDropdownState === null || nftsDropdownState === void 0 || (_nftsDropdownState$se = nftsDropdownState[selectedAccount.address]) === null || _nftsDropdownState$se === void 0 ? void 0 : _nftsDropdownState$se[chainId]),
            [nftAddress]: true
          }
        }
      };
      dispatch((0, _actions.updateNftDropDownState)(newNftDropdownState));
    } catch (error) {
      const message = (0, _error.getErrorMessage)(error);
      dispatch((0, _actions.setNewNftAddedMessage)(message));
      setNftAddFailed(true);
      return;
    } finally {
      (0, _trace.endTrace)({
        name: _trace.TraceName.ImportNfts
      });
    }
    if (ignoreErc20Token && nftAddress) {
      await dispatch((0, _actions.ignoreTokens)({
        tokensToIgnore: nftAddress,
        dontShowLoadingIndicator: true,
        networkClientId
      }));
    }
    dispatch((0, _actions.setNewNftAddedMessage)('success'));
    const tokenDetails = await (0, _actions.getTokenStandardAndDetails)(nftAddress, null, tokenId.toString()).catch(() => ({}));
    trackEvent({
      event: _metametrics.MetaMetricsEventName.TokenAdded,
      category: 'Wallet',
      sensitiveProperties: {
        token_contract_address: nftAddress,
        token_symbol: tokenDetails === null || tokenDetails === void 0 ? void 0 : tokenDetails.symbol,
        tokenId: tokenId.toString(),
        asset_type: _transaction.AssetType.NFT,
        token_standard: tokenDetails === null || tokenDetails === void 0 ? void 0 : tokenDetails.standard,
        source_connection_method: _metametrics.MetaMetricsTokenEventSource.Custom
      }
    });
    history.push(_routes.DEFAULT_ROUTE);
    onClose();
  };
  const validateAndSetAddress = val => {
    setNftAddressValidationError(null);
    if (val && !(0, _controllerUtils.isValidHexAddress)(val)) {
      setNftAddressValidationError(t('invalidAddress'));
    }
    setDisabled(!(0, _controllerUtils.isValidHexAddress)(val) || !tokenId);
    setNftAddress(val);
  };
  const validateAndSetTokenId = val => {
    setDuplicateTokenIdError(null);
    // Check if tokenId is already imported
    const tokenIdExists = (0, _util.checkTokenIdExists)(nftAddress, val, existingNfts.collections);
    if (tokenIdExists) {
      setDuplicateTokenIdError(t('nftAlreadyAdded'));
    }
    setDisabled(!(0, _controllerUtils.isValidHexAddress)(nftAddress) || !val || isNaN(Number(val)) || tokenIdExists);
    setTokenId(val);
  };
  const handleNetworkSelect = (0, _react.useCallback)(() => {
    setActionMode(ACTION_MODES.NETWORK_SELECTOR);
  }, []);
  if (actionMode === ACTION_MODES.NETWORK_SELECTOR) {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
      isOpen: true
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
      onBack: () => setActionMode(ACTION_MODES.IMPORT_NFT),
      onClose: () => {
        onClose();
        history.push();
      }
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.headingSm,
      align: _designSystem.TextAlign.Center
    }, t('networkMenuHeading'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      width: _designSystem.BlockSize.Full
    }, Object.values(networkConfigurations).map(network => /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      key: network.chainId,
      "data-testid": `select-network-item-${network.chainId}`
    }, /*#__PURE__*/_react.default.createElement(_networkListItem.NetworkListItem, {
      key: network.chainId,
      chainId: network.chainId,
      name: network.name,
      iconSrc: (0, _multichain.getImageForChainId)(network.chainId),
      iconSize: _componentLibrary.AvatarNetworkSize.Sm,
      focus: false,
      onClick: () => {
        const nftNetworkClientId = network.rpcEndpoints[network.defaultRpcEndpointIndex].networkClientId;
        setSelectedNetworkForCustomImport(network.chainId);
        setSelectedNetworkClientIdForCustomImport(nftNetworkClientId);
        setNftAddress('');
        setTokenId('');
        setActionMode(ACTION_MODES.IMPORT_TOKEN);
      },
      selected: (network === null || network === void 0 ? void 0 : network.chainId) === selectedNetworkForCustomImport
    })))))));
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: true,
    onClose: () => {
      onClose();
    },
    className: "import-nfts-modal"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onClose: () => {
      onClose();
      history.push(_routes.DEFAULT_ROUTE);
    }
  }, t('importNFT')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, isMainnet && !isDisplayNFTMediaToggleEnabled ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginTop: 6
  }, /*#__PURE__*/_react.default.createElement(_nftsDetectionNoticeImportNfts.default, {
    onActionButtonClick: onClose
  })) : null, nftAddFailed && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginTop: 6
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerAlert, {
    severity: _designSystem.Severity.Danger,
    onClose: () => setNftAddFailed(false),
    closeButtonProps: {
      'data-testid': 'add-nft-error-close'
    }
  }, t('nftAddFailedMessage'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 6,
    marginTop: 6,
    marginBottom: 6
  }, /*#__PURE__*/_react.default.createElement(_networkSelectorCustomImport.NetworkSelectorCustomImport, {
    title: selectedNetworkForCustomImport ? (_networkConfiguration = networkConfigurations[selectedNetworkForCustomImport]) === null || _networkConfiguration === void 0 ? void 0 : _networkConfiguration.name : t('networkMenuHeading'),
    buttonDataTestId: "test-import-tokens-drop-down-custom-import",
    chainId: selectedNetworkForCustomImport,
    onSelectNetwork: handleNetworkSelect
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginRight: 4,
    marginLeft: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    alignItems: _designSystem.AlignItems.flexEnd
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Label, {
    htmlFor: "address"
  }, t('address')), /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    title: t('importNFTAddressToolTip'),
    position: "bottom"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.Info,
    size: _componentLibrary.IconSize.Sm,
    marginLeft: 1,
    color: _designSystem.IconColor.iconAlternative
  })))), /*#__PURE__*/_react.default.createElement(_deprecated.FormTextField, {
    autoFocus: true,
    dataTestId: "address",
    id: "address",
    placeholder: "0x...",
    value: nftAddress,
    onChange: e => {
      validateAndSetAddress(e.target.value);
      setNftAddFailed(false);
    },
    helpText: nftAddressValidationError,
    error: Boolean(nftAddressValidationError)
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginRight: 4,
    marginLeft: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    alignItems: _designSystem.AlignItems.flexEnd
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Label, {
    htmlFor: "token-id"
  }, t('tokenId')), /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    title: t('importNFTTokenIdToolTip'),
    position: "bottom"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.Info,
    size: _componentLibrary.IconSize.Sm,
    marginLeft: 1,
    color: _designSystem.IconColor.iconAlternative
  })))), /*#__PURE__*/_react.default.createElement(_deprecated.FormTextField, {
    dataTestId: "token-id",
    id: "token-id",
    placeholder: t('nftTokenIdPlaceholder'),
    value: tokenId,
    onChange: e => {
      validateAndSetTokenId(e.target.value);
      setNftAddFailed(false);
    },
    helpText: duplicateTokenIdError,
    error: duplicateTokenIdError
  })))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    gap: 4,
    padding: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonSecondary, {
    size: _componentLibrary.ButtonSecondarySize.Lg,
    onClick: () => {
      onClose();
      history.push(_routes.DEFAULT_ROUTE);
    },
    block: true,
    className: "import-nfts-modal__cancel-button"
  }, t('cancel')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonPrimary, {
    size: _designSystem.Size.LG,
    onClick: () => handleAddNft(),
    disabled: disabled,
    block: true,
    "data-testid": "import-nfts-modal-import-button"
  }, t('import')))));
};
exports.ImportNftsModal = ImportNftsModal;
ImportNftsModal.propTypes = {
  /**
   * Executes when the modal closes
   */
  onClose: _propTypes.default.func.isRequired
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\import-nfts-modal\\import-nfts-modal.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\import-nfts-modal\\index.js", {"./import-nfts-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\import-nfts-modal\\import-nfts-modal.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cimport-nfts-modal%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ImportNftsModal", {
  enumerable: true,
  get: function () {
    return _importNftsModal.ImportNftsModal;
  }
});
var _importNftsModal = require("./import-nfts-modal");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\import-nfts-modal\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\import-tokens-modal\\import-tokens-modal-confirm.js", {"../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/token-balance/token-balance":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\token-balance\\token-balance.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cimport-tokens-modal%5Cimport-tokens-modal-confirm.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImportTokensModalConfirm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _selectors = require("../../../selectors");
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _tokenBalance = _interopRequireDefault(require("../../ui/token-balance/token-balance"));
var _i18n = require("../../../contexts/i18n");
var _network = require("../../../../shared/constants/network");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ImportTokensModalConfirm = ({
  networkFilter
}) => {
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const currentNetwork = (0, _reactRedux.useSelector)(_selectors.getCurrentNetwork);
  const testNetworkBackgroundColor = (0, _reactRedux.useSelector)(_selectors.getTestNetworkBackgroundColor);
  const pendingTokens = (0, _reactRedux.useSelector)(_selectors.getPendingTokens);
  const tokenListByChain = (0, _reactRedux.useSelector)(_selectors.selectERC20TokensByChain);
  const isCurrentNetworkSelected = Object.keys(networkFilter).length === 1 && networkFilter[currentNetwork === null || currentNetwork === void 0 ? void 0 : currentNetwork.chainId];
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingTop: 6
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    textAlign: _designSystem.TextAlign.Center
  }, Object.keys(pendingTokens).length === 1 ? t('likeToImportToken') : t('likeToImportTokens')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingTop: 6
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    flexDirection: _designSystem.FlexDirection.Column,
    className: "import-tokens-modal__confirmation-list"
  }, Object.entries(pendingTokens).map(([address, token]) => {
    var _tokenListByChain$cha, _pendingTokens$addres;
    const {
      name,
      symbol,
      iconUrl,
      chainId
    } = token;
    const tokenImage = iconUrl || (tokenListByChain === null || tokenListByChain === void 0 || (_tokenListByChain$cha = tokenListByChain[chainId]) === null || _tokenListByChain$cha === void 0 || (_tokenListByChain$cha = _tokenListByChain$cha.data[address.toLowerCase()]) === null || _tokenListByChain$cha === void 0 ? void 0 : _tokenListByChain$cha.iconUrl);
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      key: address,
      padding: 4,
      display: _designSystem.Display.Flex
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      className: "import-tokens-modal__confirm-token-list-item-wrapper"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.BadgeWrapper, {
      badge: /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
        size: _componentLibrary.AvatarNetworkSize.Xs,
        name: currentNetwork === null || currentNetwork === void 0 ? void 0 : currentNetwork.nickname,
        src: _network.CHAIN_ID_TO_NETWORK_IMAGE_URL_MAP[(_pendingTokens$addres = pendingTokens[address]) === null || _pendingTokens$addres === void 0 ? void 0 : _pendingTokens$addres.chainId],
        backgroundColor: testNetworkBackgroundColor,
        borderWidth: 2
      }),
      marginRight: 4,
      marginTop: 1
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarToken, {
      name: symbol,
      src: tokenImage
    })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      fontWeight: _designSystem.FontWeight.Medium,
      variant: _designSystem.TextVariant.bodyMd
    }, name || symbol), isCurrentNetworkSelected ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodySm,
      color: _designSystem.TextColor.textAlternative
    }, /*#__PURE__*/_react.default.createElement(_tokenBalance.default, {
      token: token,
      displayZeroBalance: true
    })) : null)), isCurrentNetworkSelected ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      alignItems: _designSystem.AlignItems.flexStart
    }, /*#__PURE__*/_react.default.createElement(_tokenBalance.default, {
      textProps: {
        font: _designSystem.FontWeight.Medium,
        variant: _designSystem.TextVariant.bodyLgMedium
      },
      suffixProps: {
        font: _designSystem.FontWeight.Medium,
        variant: _designSystem.TextVariant.bodyLgMedium
      },
      token: token,
      showFiat: true
    })) : null);
  }))));
};
exports.ImportTokensModalConfirm = ImportTokensModalConfirm;
ImportTokensModalConfirm.propTypes = {
  networkFilter: _propTypes.default.object.isRequired
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\import-tokens-modal\\import-tokens-modal-confirm.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\import-tokens-modal\\import-tokens-modal.js", {"../../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../shared/constants/tokens":"D:\\code\\v\\metamask-extension\\shared\\constants\\tokens.js","../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../../shared/modules/hexstring-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\hexstring-utils.ts","../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../helpers/constants/zendesk-url":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\zendesk-url.js","../../../helpers/utils/token-util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\token-util.js","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../app/import-token/network-filter-import-token":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\import-token\\network-filter-import-token\\index.tsx","../../app/import-token/network-selector-custom-import":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\import-token\\network-selector-custom-import\\index.tsx","../../app/import-token/token-list":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\import-token\\token-list\\index.js","../../app/import-token/token-list/token-list-placeholder":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\import-token\\token-list\\token-list-placeholder\\index.js","../../app/import-token/token-search":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\import-token\\token-search\\index.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../component-library/form-text-field/deprecated":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\form-text-field\\deprecated\\index.js","../../ui/tabs":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tabs\\index.ts","../network-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-item\\index.js","./import-tokens-modal-confirm":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\import-tokens-modal\\import-tokens-modal-confirm.js","@metamask/etherscan-link/dist/token-tracker-link":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\etherscan-link\\dist\\token-tracker-link.js","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cimport-tokens-modal%5Cimport-tokens-modal.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImportTokensModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _tokenTrackerLink = require("@metamask/etherscan-link/dist/token-tracker-link");
var _transactionController = require("@metamask/transaction-controller");
var _tabs = require("../../ui/tabs");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _networks = require("../../../../shared/modules/selectors/networks");
var _selectors = require("../../../selectors");
var _actions = require("../../../store/actions");
var _componentLibrary = require("../../component-library");
var _deprecated = require("../../component-library/form-text-field/deprecated");
var _tokenSearch = _interopRequireDefault(require("../../app/import-token/token-search"));
var _tokenList = _interopRequireDefault(require("../../app/import-token/token-list"));
var _designSystem = require("../../../helpers/constants/design-system");
var _routes = require("../../../helpers/constants/routes");
var _zendeskUrl = _interopRequireDefault(require("../../../helpers/constants/zendesk-url"));
var _hexstringUtils = require("../../../../shared/modules/hexstring-utils");
var _util = require("../../../../app/scripts/lib/util");
var _tokens = require("../../../../shared/constants/tokens");
var _transaction = require("../../../../shared/constants/transaction");
var _util2 = require("../../../helpers/utils/util");
var _tokenUtil = require("../../../helpers/utils/token-util");
var _metametrics = require("../../../contexts/metametrics");
var _metamask = require("../../../ducks/metamask/metamask");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _networkFilterImportToken = require("../../app/import-token/network-filter-import-token");
var _network = require("../../../../shared/constants/network");
var _networkSelectorCustomImport = require("../../app/import-token/network-selector-custom-import");
var _multichain = require("../../../selectors/multichain");
var _networkListItem = require("../network-list-item");
var _tokenListPlaceholder = _interopRequireDefault(require("../../app/import-token/token-list/token-list-placeholder"));
var _trace = require("../../../../shared/lib/trace");
var _selectors2 = require("../../../selectors/selectors");
var _importTokensModalConfirm = require("./import-tokens-modal-confirm");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

const ACTION_MODES = {
  // Displays the import token modal
  IMPORT_TOKEN: 'IMPORT_TOKEN',
  // Displays the page for selecting a network from custom import
  NETWORK_SELECTOR: 'NETWORK_SELECTOR',
  // Displays the page for selecting a network from a search
  SEARCH_NETWORK_SELECTOR: 'SEARCH_NETWORK_SELECTOR'
};
const TAB_NAMES = {
  SEARCH: 'search',
  CUSTOM_TOKEN: 'customToken'
};
const ImportTokensModal = ({
  onClose
}) => {
  var _allTokens$chainId, _networkConfiguration, _networkConfiguration2, _networkConfiguration6;
  const t = (0, _useI18nContext.useI18nContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const [mode, setMode] = (0, _react.useState)('');
  const [tokenSelectorError, setTokenSelectorError] = (0, _react.useState)(null);
  const [selectedTokens, setSelectedTokens] = (0, _react.useState)({});
  const [searchResults, setSearchResults] = (0, _react.useState)([]);
  // const networkClientId = useSelector(getSelectedNetworkClientId);
  const currentNetwork = (0, _reactRedux.useSelector)(_selectors.getCurrentNetwork);
  const [selectedNetworkForCustomImport, setSelectedNetworkForCustomImport] = (0, _react.useState)(null);
  const [defaultActiveTabKey, setDefaultActiveTabKey] = (0, _react.useState)(TAB_NAMES.SEARCH);
  const allNetworks = (0, _reactRedux.useSelector)(_networks.getNetworkConfigurationsByChainId);

  // Tracks which page the user is on
  const [actionMode, setActionMode] = (0, _react.useState)(ACTION_MODES.CUSTOM_IMPORT);
  const tokenNetworkFilter = (0, _reactRedux.useSelector)(_selectors.getTokenNetworkFilter);
  const enabledNetworksByNamespace = (0, _reactRedux.useSelector)(_selectors.getEnabledNetworksByNamespace);
  const [networkFilter, setNetworkFilter] = (0, _react.useState)(_selectors2.isGlobalNetworkSelectorRemoved ? enabledNetworksByNamespace : tokenNetworkFilter);

  // Determine if we should show the search tab
  const isTokenDetectionSupported = (0, _reactRedux.useSelector)(_selectors.getIsTokenDetectionSupported);
  const isTokenDetectionInactiveOnMainnet = (0, _reactRedux.useSelector)(_selectors.getIsTokenDetectionInactiveOnMainnet);
  const showSearchTab = isTokenDetectionSupported || isTokenDetectionInactiveOnMainnet || Boolean(false);
  const tokenListByChain = (0, _reactRedux.useSelector)(_selectors.selectERC20TokensByChain);
  const useTokenDetection = (0, _reactRedux.useSelector)(({
    metamask
  }) => metamask.useTokenDetection);
  const networkName = (0, _reactRedux.useSelector)(_selectors.getTokenDetectionSupportNetworkByChainId);
  const nativeCurrency = (0, _reactRedux.useSelector)(_metamask.getNativeCurrency);

  // Custom token stuff
  const tokenDetectionInactiveOnNonMainnetSupportedNetwork = (0, _reactRedux.useSelector)(_selectors.getIstokenDetectionInactiveOnNonMainnetSupportedNetwork);
  const isDynamicTokenListAvailable = (0, _reactRedux.useSelector)(_selectors.getIsDynamicTokenListAvailable);
  const selectedAccount = (0, _reactRedux.useSelector)(_selectors.getSelectedInternalAccount);
  const accounts = (0, _reactRedux.useSelector)(_selectors.getInternalAccounts);
  const chainId = (0, _reactRedux.useSelector)(_networks.getCurrentChainId);
  const allTokens = (0, _reactRedux.useSelector)(_selectors.getAllTokens);
  const tokens = (allTokens === null || allTokens === void 0 || (_allTokens$chainId = allTokens[chainId]) === null || _allTokens$chainId === void 0 ? void 0 : _allTokens$chainId[selectedAccount.address]) || [];
  const contractExchangeRates = (0, _reactRedux.useSelector)(_selectors.getTokenExchangeRates);
  const networkConfigurations = (0, _reactRedux.useSelector)(_networks.getNetworkConfigurationsByChainId);
  const allOpts = (0, _reactRedux.useSelector)(_networks.getIsAllNetworksFilterEnabled);
  const [customAddress, setCustomAddress] = (0, _react.useState)('');
  const [customAddressError, setCustomAddressError] = (0, _react.useState)(null);
  const [nftAddressError, setNftAddressError] = (0, _react.useState)(null);
  const [decimalAutoFilled, setDecimalAutoFilled] = (0, _react.useState)(false);
  const [mainnetTokenWarning, setMainnetTokenWarning] = (0, _react.useState)(null);
  const [customSymbol, setCustomSymbol] = (0, _react.useState)('');
  const [customName, setCustomName] = (0, _react.useState)('');
  const [customSymbolError, setCustomSymbolError] = (0, _react.useState)(null);
  const [customDecimals, setCustomDecimals] = (0, _react.useState)(0);
  const [customDecimalsError, setCustomDecimalsError] = (0, _react.useState)(null);
  const [tokenStandard, setTokenStandard] = (0, _react.useState)(_transaction.TokenStandard.none);
  const testNetworkBackgroundColor = (0, _reactRedux.useSelector)(_selectors.getTestNetworkBackgroundColor);
  const [showSymbolAndDecimals, setShowSymbolAndDecimals] = (0, _react.useState)(false);
  const blockExplorerUrl = ((_networkConfiguration = networkConfigurations[selectedNetworkForCustomImport]) === null || _networkConfiguration === void 0 || (_networkConfiguration = _networkConfiguration.blockExplorerUrls) === null || _networkConfiguration === void 0 ? void 0 : _networkConfiguration[(_networkConfiguration2 = networkConfigurations[selectedNetworkForCustomImport]) === null || _networkConfiguration2 === void 0 ? void 0 : _networkConfiguration2.defaultBlockExplorerUrlIndex]) ?? null;
  const blockExplorerTokenLink = (0, _tokenTrackerLink.getTokenTrackerLink)(customAddress, selectedNetworkForCustomImport, null, null, {
    blockExplorerUrl
  });
  const blockExplorerLabel = blockExplorerTokenLink ? (0, _util2.getURLHostName)(blockExplorerTokenLink) : t('etherscan');

  // Min and Max decimal values
  const EMPTY_ADDRESS = '0x0000000000000000000000000000000000000000';
  const MIN_DECIMAL_VALUE = 0;
  const MAX_DECIMAL_VALUE = 36;
  const infoGetter = (0, _react.useRef)((0, _tokenUtil.tokenInfoGetter)());

  // CONFIRMATION MODE
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const pendingTokens = (0, _reactRedux.useSelector)(_selectors.getPendingTokens);
  const handleAddTokens = (0, _react.useCallback)(async () => {
    try {
      const addedTokenValues = Object.values(pendingTokens);
      const addedTokensByChain = addedTokenValues.reduce((groups, token) => {
        if (!groups[token.chainId]) {
          groups[token.chainId] = [];
        }
        groups[token.chainId].push(token);
        return groups;
      }, {});
      const promiseAllImport = Object.keys(addedTokensByChain).map(networkId => {
        var _networkConfiguration3, _networkConfiguration4;
        const clientId = (_networkConfiguration3 = networkConfigurations[networkId]) === null || _networkConfiguration3 === void 0 || (_networkConfiguration3 = _networkConfiguration3.rpcEndpoints[(_networkConfiguration4 = networkConfigurations[networkId]) === null || _networkConfiguration4 === void 0 ? void 0 : _networkConfiguration4.defaultRpcEndpointIndex]) === null || _networkConfiguration3 === void 0 ? void 0 : _networkConfiguration3.networkClientId;
        return dispatch((0, _actions.addImportedTokens)(addedTokensByChain[networkId], clientId));
      });
      await Promise.all(promiseAllImport);
      addedTokenValues.forEach(pendingToken => {
        trackEvent({
          event: _metametrics2.MetaMetricsEventName.TokenAdded,
          category: _metametrics2.MetaMetricsEventCategory.Wallet,
          sensitiveProperties: {
            token_symbol: pendingToken.symbol,
            token_contract_address: pendingToken.address,
            token_decimal_precision: pendingToken.decimals,
            unlisted: pendingToken.unlisted,
            source_connection_method: pendingToken.isCustom ? _metametrics2.MetaMetricsTokenEventSource.Custom : _metametrics2.MetaMetricsTokenEventSource.List,
            token_standard: _transaction.TokenStandard.ERC20,
            asset_type: _transaction.AssetType.token
          }
        });
      });
      const tokenSymbols = [];
      for (const key in pendingTokens) {
        if (Object.prototype.hasOwnProperty.call(pendingTokens, key)) {
          tokenSymbols.push(pendingTokens[key].symbol);
        }
      }
      dispatch((0, _actions.setNewTokensImported)(tokenSymbols.join(', ')));
      dispatch((0, _actions.clearPendingTokens)());
      dispatch((0, _actions.hideImportTokensModal)());
      history.push(_routes.DEFAULT_ROUTE);
    } catch (err) {
      dispatch((0, _actions.setNewTokensImportedError)('error'));
      dispatch((0, _actions.clearPendingTokens)());
      history.push(_routes.DEFAULT_ROUTE);
    }
  }, [dispatch, history, pendingTokens, trackEvent]);
  (0, _react.useEffect)(() => {
    const pendingTokenKeys = Object.keys(pendingTokens);
    if (pendingTokenKeys.length === 0) {
      return;
    }
    let initialSelectedTokens = {};
    let initialCustomToken = {};
    pendingTokenKeys.forEach(tokenAddress => {
      const token = pendingTokens[tokenAddress];
      const {
        isCustom
      } = token;
      if (isCustom) {
        initialCustomToken = {
          ...token
        };
      } else {
        initialSelectedTokens = {
          ...selectedTokens,
          [tokenAddress]: {
            ...token
          }
        };
      }
    });
    setSelectedTokens(initialSelectedTokens);
    setCustomAddress(initialCustomToken.address);
    setCustomSymbol(initialCustomToken.symbol);
    setCustomDecimals(initialCustomToken.decimals);
  }, [pendingTokens]);
  (0, _react.useEffect)(() => {
    setSelectedTokens({});
  }, [networkFilter]);
  const handleCustomSymbolChange = value => {
    const symbol = value.trim();
    const symbolLength = symbol.length;
    let symbolError = null;
    if (symbolLength <= 0 || symbolLength >= 12) {
      symbolError = t('symbolBetweenZeroTwelve');
    }
    setCustomSymbol(symbol);
    setCustomSymbolError(symbolError);
  };
  const handleCustomDecimalsChange = value => {
    let decimals;
    let decimalsError = null;
    if (value) {
      decimals = Number(value.trim());
      decimalsError = value < MIN_DECIMAL_VALUE || value > MAX_DECIMAL_VALUE ? t('decimalsMustZerotoTen') : null;
    } else {
      decimals = '';
      decimalsError = t('tokenDecimalFetchFailed', [/*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
        className: "import-tokens-modal__button-link",
        key: "import-token-verify-token-decimal",
        rel: "noopener noreferrer",
        target: "_blank",
        href: blockExplorerTokenLink,
        endIconName: _componentLibrary.IconName.Export
      }, blockExplorerLabel)]);
    }
    setCustomDecimals(decimals);
    setCustomDecimalsError(decimalsError);
  };
  const attemptToAutoFillTokenParams = (0, _react.useCallback)(async address => {
    var _tokenListByChain$sel;
    const {
      symbol = '',
      decimals,
      name = ''
    } = await infoGetter.current(address, tokenListByChain === null || tokenListByChain === void 0 || (_tokenListByChain$sel = tokenListByChain[selectedNetworkForCustomImport]) === null || _tokenListByChain$sel === void 0 ? void 0 : _tokenListByChain$sel.data);
    setDecimalAutoFilled(Boolean(decimals));
    handleCustomSymbolChange(symbol || '');
    handleCustomDecimalsChange(decimals);
    // Set custom token name
    setCustomName(name);
    setShowSymbolAndDecimals(true);
  }, [selectedNetworkForCustomImport, tokenListByChain]);
  (0, _react.useEffect)(() => {
    const canAttemptAutofill = customAddress &&
    // Address is present
    !customAddressError &&
    // No general address error
    !nftAddressError &&
    // Not an NFT address
    !mainnetTokenWarning; // Not a mainnet token on the wrong chain

    if (canAttemptAutofill) {
      attemptToAutoFillTokenParams(customAddress);
    }
  }, [customAddress, customAddressError, nftAddressError, mainnetTokenWarning, attemptToAutoFillTokenParams]);
  const handleToggleToken = token => {
    const {
      address
    } = token;
    const selectedTokensCopy = {
      ...selectedTokens
    };
    if (address in selectedTokensCopy) {
      delete selectedTokensCopy[address];
    } else {
      selectedTokensCopy[address] = token;
    }
    setSelectedTokens(selectedTokensCopy);
    setTokenSelectorError(null);
  };
  const hasError = () => {
    return tokenSelectorError || customAddressError || customSymbolError || customDecimalsError || nftAddressError;
  };
  const hasSelected = () => {
    return customAddress || Object.keys(selectedTokens).length > 0;
  };
  const handleNext = async () => {
    var _tokenListByChain$sel2;
    if (hasError()) {
      return;
    }
    if (!hasSelected()) {
      setTokenSelectorError(t('mustSelectOne'));
      return;
    }
    const tokenList = (tokenListByChain === null || tokenListByChain === void 0 || (_tokenListByChain$sel2 = tokenListByChain[selectedNetworkForCustomImport]) === null || _tokenListByChain$sel2 === void 0 ? void 0 : _tokenListByChain$sel2.data) ?? {};
    const tokenAddressList = Object.keys(tokenList);
    const customToken = customAddress ? {
      address: customAddress,
      symbol: customSymbol,
      decimals: customDecimals,
      standard: tokenStandard,
      name: customName,
      chainId: selectedNetworkForCustomImport
    } : null;
    dispatch((0, _actions.setPendingTokens)({
      customToken,
      selectedTokens,
      tokenAddressList
    }));
    const tempTokensToAdd = {
      ...selectedTokens,
      ...((customToken === null || customToken === void 0 ? void 0 : customToken.address) && {
        [customToken.address]: {
          ...customToken
        }
      })
    };
    const tmpTokens = Object.values(tempTokensToAdd);
    const tmpTokensToDispatch = tmpTokens.filter(elm => (contractExchangeRates === null || contractExchangeRates === void 0 ? void 0 : contractExchangeRates[(0, _hexstringUtils.toChecksumHexAddress)(elm.address)]) === undefined);
    const tokenAddresses = tmpTokensToDispatch.map(obj => obj.address);
    if (tmpTokensToDispatch.length !== 0) {
      const result = await (0, _util2.fetchTokenExchangeRates)(nativeCurrency, tokenAddresses, chainId);
      // dispatch action
      dispatch((0, _actions.setConfirmationExchangeRates)(result));
    }
    setMode('confirm');
  };
  const handleCustomAddressChange = async value => {
    const address = value.trim();
    setCustomAddress(address);
    setCustomAddressError(null);
    setNftAddressError(null);
    setDecimalAutoFilled(false);
    setMainnetTokenWarning(null);
    setShowSymbolAndDecimals(false);
    const addressIsValid = (0, _hexstringUtils.isValidHexAddress)(address, {
      allowNonPrefixed: false
    });
    const standardAddress = (0, _util.addHexPrefix)(address).toLowerCase();
    const isMainnetToken = Object.keys(_tokens.STATIC_MAINNET_TOKEN_LIST).some(key => key.toLowerCase() === address.toLowerCase());
    let standard;
    if (addressIsValid) {
      try {
        ({
          standard
        } = await (0, _actions.getTokenStandardAndDetailsByChain)(standardAddress, selectedAccount.address, null, selectedNetworkForCustomImport));
      } catch (error) {
        // ignore
      }
    }
    const addressIsEmpty = address.length === 0 || address === EMPTY_ADDRESS;
    switch (true) {
      case !addressIsValid && !addressIsEmpty:
        setCustomAddressError(t('invalidAddress'));
        setCustomSymbol('');
        setCustomDecimals(0);
        setCustomSymbolError(null);
        setCustomDecimalsError(null);
        setShowSymbolAndDecimals(false);
        break;
      case standard === _transaction.TokenStandard.ERC1155 || standard === _transaction.TokenStandard.ERC721:
        setNftAddressError(t('nftAddressError', [/*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
          className: "import-tokens-modal__nft-address-error-link",
          onClick: () => {
            dispatch((0, _actions.showImportNftsModal)({
              tokenAddress: address
            }));
            onClose();
          },
          color: _designSystem.TextColor.primaryDefault,
          key: "nftAddressError"
        }, t('importNFTPage'))]));
        setShowSymbolAndDecimals(false);
        break;
      case isMainnetToken && selectedNetworkForCustomImport !== _transactionController.CHAIN_IDS.MAINNET:
        setMainnetTokenWarning(t('mainnetToken'));
        setCustomSymbol('');
        setCustomDecimals(0);
        setCustomSymbolError(null);
        setCustomDecimalsError(null);
        setShowSymbolAndDecimals(false);
        break;
      case Boolean(accounts.find(internalAccount => internalAccount.address.toLowerCase() === standardAddress)):
        setCustomAddressError(t('personalAddressDetected'));
        setShowSymbolAndDecimals(false);
        break;
      case (0, _util2.checkExistingAddresses)(address, tokens):
        setCustomAddressError(t('tokenAlreadyAdded'));
        setShowSymbolAndDecimals(false);
        break;
      default:
        if (standard) {
          setTokenStandard(standard);
        }
    }
  };

  // Determines whether to show the Search/Import or Confirm action
  const isConfirming = mode === 'confirm';
  if (actionMode === ACTION_MODES.NETWORK_SELECTOR) {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
      isOpen: true
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
      onBack: () => setActionMode(ACTION_MODES.IMPORT_TOKEN),
      onClose: onClose
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.headingSm,
      align: _designSystem.TextAlign.Center
    }, t('networkMenuHeading'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      width: _designSystem.BlockSize.Full
    }, Object.values(allNetworks).map(network => /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      key: network.chainId,
      "data-testid": `select-network-item-${network.chainId}`
    }, /*#__PURE__*/_react.default.createElement(_networkListItem.NetworkListItem, {
      key: network.chainId,
      chainId: network.chainId,
      name: network.name,
      iconSrc: (0, _multichain.getImageForChainId)(network.chainId),
      iconSize: _componentLibrary.AvatarNetworkSize.Sm,
      focus: false,
      onClick: () => {
        setSelectedNetworkForCustomImport(network.chainId);
        setCustomAddress('');
        setCustomSymbol('');
        setCustomDecimals(0);
        setShowSymbolAndDecimals(false);
        setActionMode(ACTION_MODES.IMPORT_TOKEN);
      },
      selected: (network === null || network === void 0 ? void 0 : network.chainId) === selectedNetworkForCustomImport
    })))))));
  }
  if (actionMode === ACTION_MODES.SEARCH_NETWORK_SELECTOR) {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
      isOpen: true
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
      onBack: () => setActionMode(ACTION_MODES.IMPORT_TOKEN),
      onClose: onClose
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.headingSm,
      align: _designSystem.TextAlign.Center
    }, t('networks'))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      width: _designSystem.BlockSize.Full
    }, _network.FEATURED_NETWORK_CHAIN_IDS.filter(chain => allOpts[chain]).map(chain => {
      var _networkConfiguration5;
      return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        key: chain,
        padding: 4,
        gap: 4,
        display: _designSystem.Display.Flex,
        alignItems: _designSystem.AlignItems.center,
        justifyContent: _designSystem.JustifyContent.spaceBetween,
        width: _designSystem.BlockSize.Full
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
        name: (0, _multichain.getImageForChainId)(chain),
        src: (0, _multichain.getImageForChainId)(chain),
        size: _componentLibrary.AvatarNetworkSize.Sm
      }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        width: _designSystem.BlockSize.Full,
        display: _designSystem.Display.Flex,
        alignItems: _designSystem.AlignItems.center
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        variant: _designSystem.TextVariant.bodyMdMedium
      }, (_networkConfiguration5 = networkConfigurations[chain]) === null || _networkConfiguration5 === void 0 ? void 0 : _networkConfiguration5.name)));
    })))));
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: true,
    onClose: () => {
      dispatch((0, _actions.clearPendingTokens)());
      onClose();
    },
    className: "import-tokens-modal"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, {
    modalDialogProps: {
      className: 'import-tokens-modal__modal-dialog-content'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onBack: isConfirming ? () => setMode('') : null,
    paddingBottom: 4,
    paddingRight: 4,
    paddingLeft: 4,
    onClose: () => {
      dispatch((0, _actions.clearPendingTokens)());
      onClose();
    }
  }, t('importTokensCamelCase')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "import-tokens-modal__body"
  }, isConfirming ? /*#__PURE__*/_react.default.createElement(_importTokensModalConfirm.ImportTokensModalConfirm, {
    networkFilter: networkFilter
  }) : /*#__PURE__*/_react.default.createElement(_tabs.Tabs, {
    t: t,
    onTabClick: tabKey => setDefaultActiveTabKey(tabKey),
    defaultActiveTabKey: defaultActiveTabKey,
    tabListProps: {
      className: 'px-4'
    }
  }, showSearchTab ? /*#__PURE__*/_react.default.createElement(_tabs.Tab, {
    tabKey: TAB_NAMES.SEARCH,
    name: t('search'),
    onClick: () => setDefaultActiveTabKey(TAB_NAMES.SEARCH)
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingTop: 4
  }, useTokenDetection ? null : /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 4,
    paddingRight: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerAlert, {
    severity: _designSystem.Severity.Info,
    marginBottom: 4,
    paddingLeft: 4,
    paddingRight: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    fontSize: "16"
  }, t('enhancedTokenDetectionAlertMessage', [networkName, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    key: "token-detection-announcement",
    className: "import-tokens-modal__autodetect",
    onClick: () => {
      onClose();
      history.push(`${_routes.SECURITY_ROUTE}#auto-detect-tokens`);
    }
  }, t('enableFromSettings'))])))), _network.FEATURED_NETWORK_CHAIN_IDS.some(networkId => networkId === currentNetwork.chainId) && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 4,
    paddingRight: 4,
    paddingBottom: 4
  }, /*#__PURE__*/_react.default.createElement(_networkFilterImportToken.NetworkFilterImportToken, {
    buttonDataTestId: "test-import-tokens-drop-down",
    openListNetwork: () => setActionMode(ACTION_MODES.SEARCH_NETWORK_SELECTOR),
    networkFilter: networkFilter,
    setNetworkFilter: setNetworkFilter
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 4,
    paddingRight: 4,
    paddingBottom: 4
  }, /*#__PURE__*/_react.default.createElement(_tokenSearch.default, {
    searchClassName: "import-tokens-modal__button-search",
    onSearch: ({
      results = []
    }) => setSearchResults(results),
    error: tokenSelectorError,
    tokenList: tokenListByChain,
    networkFilter: networkFilter,
    setSearchResults: setSearchResults
  })), searchResults.length === 0 ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 4,
    paddingRight: 4,
    className: "token-list__empty-list"
  }, /*#__PURE__*/_react.default.createElement(_tokenListPlaceholder.default, null)) : /*#__PURE__*/_react.default.createElement(_tokenList.default, {
    currentNetwork: currentNetwork,
    testNetworkBackgroundColor: testNetworkBackgroundColor,
    results: searchResults,
    selectedTokens: selectedTokens,
    onToggleToken: token => handleToggleToken(token),
    isTokenNetworkFilterEqualCurrentNetwork: Object.keys(networkFilter).length === 1 && networkFilter[chainId]
  }))) : null, /*#__PURE__*/_react.default.createElement(_tabs.Tab, {
    tabKey: TAB_NAMES.CUSTOM_TOKEN,
    name: t('customToken'),
    onClick: () => setDefaultActiveTabKey(TAB_NAMES.CUSTOM_TOKEN),
    "data-testid": "import-tokens-modal-custom-token-tab"
  }, isConfirming ? /*#__PURE__*/_react.default.createElement(_importTokensModalConfirm.ImportTokensModalConfirm, {
    networkFilter: networkFilter
  }) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingTop: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "import-tokens-modal__custom-token-form__container"
  }, tokenDetectionInactiveOnNonMainnetSupportedNetwork ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 4,
    paddingRight: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerAlert, {
    severity: _designSystem.Severity.Warning
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd
  }, t('customTokenWarningInTokenDetectionNetworkWithTDOFF', [/*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    key: "import-token-security-risk",
    rel: "noopener noreferrer",
    target: "_blank",
    href: _zendeskUrl.default.TOKEN_SAFETY_PRACTICES
  }, t('tokenScamSecurityRisk')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    type: "link",
    key: "import-token-token-detection-announcement",
    onClick: () => {
      onClose();
      history.push(`${_routes.SECURITY_ROUTE}#auto-detect-tokens`);
    }
  }, t('inYourSettings'))])))) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 4,
    paddingRight: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerAlert, {
    severity: isDynamicTokenListAvailable ? _designSystem.Severity.Warning : _designSystem.Severity.Info,
    "data-testid": "custom-token-warning"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd
  }, t(isDynamicTokenListAvailable ? 'customTokenWarningInTokenDetectionNetwork' : 'customTokenWarningInNonTokenDetectionNetwork', [/*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    key: "import-token-fake-token-warning",
    rel: "noopener noreferrer",
    target: "_blank",
    href: _zendeskUrl.default.TOKEN_SAFETY_PRACTICES
  }, t('learnScamRisk'))])))), /*#__PURE__*/_react.default.createElement(_networkSelectorCustomImport.NetworkSelectorCustomImport, {
    title: selectedNetworkForCustomImport ? (_networkConfiguration6 = networkConfigurations[selectedNetworkForCustomImport]) === null || _networkConfiguration6 === void 0 ? void 0 : _networkConfiguration6.name : t('networkMenuHeading'),
    buttonDataTestId: "test-import-tokens-drop-down-custom-import",
    chainId: selectedNetworkForCustomImport,
    onSelectNetwork: () => setActionMode(ACTION_MODES.NETWORK_SELECTOR)
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_deprecated.FormTextField, {
    paddingLeft: 4,
    paddingRight: 4,
    size: _designSystem.Size.LG,
    label: t('tokenContractAddress'),
    value: customAddress,
    onChange: e => {
      if (selectedNetworkForCustomImport) {
        handleCustomAddressChange(e.target.value);
      } else {
        setCustomAddress(e.target.value);
      }
    },
    helpText: customAddressError || mainnetTokenWarning || nftAddressError,
    error: customAddressError || mainnetTokenWarning || nftAddressError,
    textFieldProps: {
      className: customAddressError || mainnetTokenWarning || nftAddressError ? 'import-tokens-modal__custom-token-form__text-outline-error' : 'import-tokens-modal__custom-token-form__text-outline-success'
    },
    inputProps: {
      'data-testid': 'import-tokens-modal-custom-address'
    }
  }), showSymbolAndDecimals && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_deprecated.FormTextField, {
    paddingLeft: 4,
    paddingRight: 4,
    paddingTop: 4,
    size: _designSystem.Size.LG,
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, t('tokenSymbol')),
    value: customSymbol,
    onChange: e => handleCustomSymbolChange(e.target.value),
    helpText: customSymbolError,
    error: customSymbolError,
    textFieldProps: {
      className: customSymbolError ? 'import-tokens-modal__custom-token-form__text-outline-error' : 'import-tokens-modal__custom-token-form__text-outline-success'
    },
    inputProps: {
      'data-testid': 'import-tokens-modal-custom-symbol'
    }
  }), /*#__PURE__*/_react.default.createElement(_deprecated.FormTextField, {
    paddingLeft: 4,
    paddingRight: 4,
    paddingTop: 4,
    size: _designSystem.Size.LG,
    label: t('decimal'),
    type: "number",
    value: customDecimals,
    onChange: e => handleCustomDecimalsChange(e.target.value),
    helpText: customDecimalsError,
    error: customDecimalsError,
    disabled: decimalAutoFilled,
    min: MIN_DECIMAL_VALUE,
    max: MAX_DECIMAL_VALUE,
    textFieldProps: {
      className: customDecimalsError ? 'import-tokens-modal__custom-token-form__text-outline-error' : 'import-tokens-modal__custom-token-form__text-outline-success'
    },
    inputProps: {
      'data-testid': 'import-tokens-modal-custom-decimals'
    }
  })))))))), isConfirming ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingTop: 5,
    paddingLeft: 4,
    paddingRight: 4,
    display: _designSystem.Display.Flex
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonSecondary, {
    size: _designSystem.Size.LG,
    onClick: () => {
      dispatch((0, _actions.clearPendingTokens)());
      setMode('');
    },
    block: true,
    marginRight: 5
  }, t('back')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonPrimary, {
    size: _designSystem.Size.LG,
    onClick: async () => {
      (0, _trace.trace)({
        name: _trace.TraceName.ImportTokens
      });
      await handleAddTokens();
      (0, _trace.endTrace)({
        name: _trace.TraceName.ImportTokens
      });
      history.push(_routes.DEFAULT_ROUTE);
    },
    block: true,
    "data-testid": "import-tokens-modal-import-button"
  }, t('import'))) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingTop: 6,
    paddingLeft: 4,
    paddingRight: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonPrimary, {
    onClick: () => handleNext(),
    size: _designSystem.Size.LG,
    disabled: Boolean(hasError()) || !hasSelected() || defaultActiveTabKey === TAB_NAMES.CUSTOM_TOKEN && !selectedNetworkForCustomImport,
    block: true,
    "data-testid": "import-tokens-button-next"
  }, t('next')))));
};
exports.ImportTokensModal = ImportTokensModal;
ImportTokensModal.propTypes = {
  onClose: _propTypes.default.func.isRequired
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\import-tokens-modal\\import-tokens-modal.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\import-tokens-modal\\index.js", {"./import-tokens-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\import-tokens-modal\\import-tokens-modal.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cimport-tokens-modal%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ImportTokensModal", {
  enumerable: true,
  get: function () {
    return _importTokensModal.ImportTokensModal;
  }
});
var _importTokensModal = require("./import-tokens-modal");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\import-tokens-modal\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js", {"./account-details":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-details\\index.js","./account-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-list-item\\index.js","./account-list-item-menu":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-list-item-menu\\index.js","./account-list-menu":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-list-menu\\index.js","./account-overview":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-overview\\index.js","./account-picker":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-picker\\index.js","./activity-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\activity-list-item\\index.js","./address-copy-button":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\address-copy-button\\index.js","./address-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\address-list-item\\index.ts","./app-header":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\app-header\\index.js","./asset-picker-amount":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\index.ts","./avatar-group":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\avatar-group\\index.ts","./carousel":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\carousel\\index.ts","./connected-accounts-menu":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\connected-accounts-menu\\index.ts","./connected-site-menu":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\connected-site-menu\\index.js","./connected-site-popover":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\connected-site-popover\\index.ts","./connected-status":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\connected-status\\index.ts","./create-account":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\create-account\\index.js","./create-eth-account":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\create-eth-account\\index.js","./detected-token-banner":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\detected-token-banner\\index.js","./edit-accounts-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\edit-accounts-modal\\index.ts","./edit-networks-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\edit-networks-modal\\index.js","./global-menu":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\global-menu\\index.ts","./import-account":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\import-account\\index.js","./import-nfts-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\import-nfts-modal\\index.js","./import-tokens-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\import-tokens-modal\\index.js","./menu-items":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\menu-items\\index.js","./multi-srp":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\multi-srp\\index.ts","./network-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-item\\index.js","./network-list-menu":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-menu\\index.js","./notification-detail":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail\\index.ts","./notification-detail-address":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-address\\index.ts","./notification-detail-asset":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-asset\\index.ts","./notification-detail-block-explorer-button":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-block-explorer-button\\index.ts","./notification-detail-button":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-button\\index.ts","./notification-detail-collection":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-collection\\index.ts","./notification-detail-copy-button":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-copy-button\\index.ts","./notification-detail-info":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-info\\index.ts","./notification-detail-network-fee":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-network-fee\\index.ts","./notification-detail-nft":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-nft\\index.ts","./notification-detail-title":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-title\\index.ts","./notification-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-list-item\\index.ts","./notification-list-item-icon":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-list-item-icon\\index.js","./notification-list-item-snap":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-list-item-snap\\index.ts","./notification-list-item-text":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-list-item-text\\index.ts","./notifications-page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notifications-page\\index.js","./notifications-settings-account":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notifications-settings-account\\index.ts","./notifications-settings-box":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notifications-settings-box\\index.ts","./notifications-settings-type":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notifications-settings-type\\index.ts","./notifications-tag-counter":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notifications-tag-counter\\index.ts","./permission-details-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\permission-details-modal\\index.ts","./product-tour-popover":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\product-tour-popover\\index.js","./receive-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\receive-modal\\index.js","./toast":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\toast\\index.ts","./token-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\token-list-item\\index.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "AccountDetails", {
  enumerable: true,
  get: function () {
    return _accountDetails.AccountDetails;
  }
});
Object.defineProperty(exports, "AccountDetailsMenuItem", {
  enumerable: true,
  get: function () {
    return _menuItems.AccountDetailsMenuItem;
  }
});
Object.defineProperty(exports, "AccountListItem", {
  enumerable: true,
  get: function () {
    return _accountListItem.AccountListItem;
  }
});
Object.defineProperty(exports, "AccountListItemMenu", {
  enumerable: true,
  get: function () {
    return _accountListItemMenu.AccountListItemMenu;
  }
});
Object.defineProperty(exports, "AccountListItemMenuTypes", {
  enumerable: true,
  get: function () {
    return _accountListItem.AccountListItemMenuTypes;
  }
});
Object.defineProperty(exports, "AccountListMenu", {
  enumerable: true,
  get: function () {
    return _accountListMenu.AccountListMenu;
  }
});
Object.defineProperty(exports, "AccountOverview", {
  enumerable: true,
  get: function () {
    return _accountOverview.AccountOverview;
  }
});
Object.defineProperty(exports, "AccountPicker", {
  enumerable: true,
  get: function () {
    return _accountPicker.AccountPicker;
  }
});
Object.defineProperty(exports, "ActivityListItem", {
  enumerable: true,
  get: function () {
    return _activityListItem.ActivityListItem;
  }
});
Object.defineProperty(exports, "AddressCopyButton", {
  enumerable: true,
  get: function () {
    return _addressCopyButton.AddressCopyButton;
  }
});
Object.defineProperty(exports, "AddressListItem", {
  enumerable: true,
  get: function () {
    return _addressListItem.AddressListItem;
  }
});
Object.defineProperty(exports, "AppHeader", {
  enumerable: true,
  get: function () {
    return _appHeader.AppHeader;
  }
});
Object.defineProperty(exports, "AssetPickerAmount", {
  enumerable: true,
  get: function () {
    return _assetPickerAmount.AssetPickerAmount;
  }
});
Object.defineProperty(exports, "AvatarGroup", {
  enumerable: true,
  get: function () {
    return _avatarGroup.AvatarGroup;
  }
});
Object.defineProperty(exports, "Carousel", {
  enumerable: true,
  get: function () {
    return _carousel.Carousel;
  }
});
Object.defineProperty(exports, "CarouselWithEmptyState", {
  enumerable: true,
  get: function () {
    return _carousel.CarouselWithEmptyState;
  }
});
Object.defineProperty(exports, "ConnectedAccountsMenu", {
  enumerable: true,
  get: function () {
    return _connectedAccountsMenu.ConnectedAccountsMenu;
  }
});
Object.defineProperty(exports, "ConnectedSiteMenu", {
  enumerable: true,
  get: function () {
    return _connectedSiteMenu.ConnectedSiteMenu;
  }
});
Object.defineProperty(exports, "ConnectedSitePopover", {
  enumerable: true,
  get: function () {
    return _connectedSitePopover.ConnectedSitePopover;
  }
});
Object.defineProperty(exports, "ConnectedStatus", {
  enumerable: true,
  get: function () {
    return _connectedStatus.ConnectedStatus;
  }
});
Object.defineProperty(exports, "CreateAccount", {
  enumerable: true,
  get: function () {
    return _createAccount.CreateAccount;
  }
});
Object.defineProperty(exports, "CreateEthAccount", {
  enumerable: true,
  get: function () {
    return _createEthAccount.CreateEthAccount;
  }
});
Object.defineProperty(exports, "DetectedTokensBanner", {
  enumerable: true,
  get: function () {
    return _detectedTokenBanner.DetectedTokensBanner;
  }
});
Object.defineProperty(exports, "EditAccountsModal", {
  enumerable: true,
  get: function () {
    return _editAccountsModal.EditAccountsModal;
  }
});
Object.defineProperty(exports, "EditNetworksModal", {
  enumerable: true,
  get: function () {
    return _editNetworksModal.EditNetworksModal;
  }
});
Object.defineProperty(exports, "GlobalMenu", {
  enumerable: true,
  get: function () {
    return _globalMenu.GlobalMenu;
  }
});
Object.defineProperty(exports, "ImportAccount", {
  enumerable: true,
  get: function () {
    return _importAccount.ImportAccount;
  }
});
Object.defineProperty(exports, "ImportNftsModal", {
  enumerable: true,
  get: function () {
    return _importNftsModal.ImportNftsModal;
  }
});
Object.defineProperty(exports, "ImportTokensModal", {
  enumerable: true,
  get: function () {
    return _importTokensModal.ImportTokensModal;
  }
});
Object.defineProperty(exports, "NetworkListItem", {
  enumerable: true,
  get: function () {
    return _networkListItem.NetworkListItem;
  }
});
Object.defineProperty(exports, "NetworkListMenu", {
  enumerable: true,
  get: function () {
    return _networkListMenu.NetworkListMenu;
  }
});
Object.defineProperty(exports, "NotificationDetail", {
  enumerable: true,
  get: function () {
    return _notificationDetail.NotificationDetail;
  }
});
Object.defineProperty(exports, "NotificationDetailAddress", {
  enumerable: true,
  get: function () {
    return _notificationDetailAddress.NotificationDetailAddress;
  }
});
Object.defineProperty(exports, "NotificationDetailAsset", {
  enumerable: true,
  get: function () {
    return _notificationDetailAsset.NotificationDetailAsset;
  }
});
Object.defineProperty(exports, "NotificationDetailBlockExplorerButton", {
  enumerable: true,
  get: function () {
    return _notificationDetailBlockExplorerButton.NotificationDetailBlockExplorerButton;
  }
});
Object.defineProperty(exports, "NotificationDetailButton", {
  enumerable: true,
  get: function () {
    return _notificationDetailButton.NotificationDetailButton;
  }
});
Object.defineProperty(exports, "NotificationDetailCollection", {
  enumerable: true,
  get: function () {
    return _notificationDetailCollection.NotificationDetailCollection;
  }
});
Object.defineProperty(exports, "NotificationDetailCopyButton", {
  enumerable: true,
  get: function () {
    return _notificationDetailCopyButton.NotificationDetailCopyButton;
  }
});
Object.defineProperty(exports, "NotificationDetailInfo", {
  enumerable: true,
  get: function () {
    return _notificationDetailInfo.NotificationDetailInfo;
  }
});
Object.defineProperty(exports, "NotificationDetailNetworkFee", {
  enumerable: true,
  get: function () {
    return _notificationDetailNetworkFee.NotificationDetailNetworkFee;
  }
});
Object.defineProperty(exports, "NotificationDetailNft", {
  enumerable: true,
  get: function () {
    return _notificationDetailNft.NotificationDetailNft;
  }
});
Object.defineProperty(exports, "NotificationDetailTitle", {
  enumerable: true,
  get: function () {
    return _notificationDetailTitle.NotificationDetailTitle;
  }
});
Object.defineProperty(exports, "NotificationListItem", {
  enumerable: true,
  get: function () {
    return _notificationListItem.NotificationListItem;
  }
});
Object.defineProperty(exports, "NotificationListItemIcon", {
  enumerable: true,
  get: function () {
    return _notificationListItemIcon.NotificationListItemIcon;
  }
});
Object.defineProperty(exports, "NotificationListItemSnap", {
  enumerable: true,
  get: function () {
    return _notificationListItemSnap.NotificationListItemSnap;
  }
});
Object.defineProperty(exports, "NotificationListItemText", {
  enumerable: true,
  get: function () {
    return _notificationListItemText.NotificationListItemText;
  }
});
Object.defineProperty(exports, "NotificationsPage", {
  enumerable: true,
  get: function () {
    return _notificationsPage.NotificationsPage;
  }
});
Object.defineProperty(exports, "NotificationsSettingsAccount", {
  enumerable: true,
  get: function () {
    return _notificationsSettingsAccount.NotificationsSettingsAccount;
  }
});
Object.defineProperty(exports, "NotificationsSettingsBox", {
  enumerable: true,
  get: function () {
    return _notificationsSettingsBox.NotificationsSettingsBox;
  }
});
Object.defineProperty(exports, "NotificationsSettingsType", {
  enumerable: true,
  get: function () {
    return _notificationsSettingsType.NotificationsSettingsType;
  }
});
Object.defineProperty(exports, "NotificationsTagCounter", {
  enumerable: true,
  get: function () {
    return _notificationsTagCounter.NotificationsTagCounter;
  }
});
Object.defineProperty(exports, "PermissionDetailsModal", {
  enumerable: true,
  get: function () {
    return _permissionDetailsModal.PermissionDetailsModal;
  }
});
Object.defineProperty(exports, "ProductTour", {
  enumerable: true,
  get: function () {
    return _productTourPopover.ProductTour;
  }
});
Object.defineProperty(exports, "ReceiveModal", {
  enumerable: true,
  get: function () {
    return _receiveModal.ReceiveModal;
  }
});
Object.defineProperty(exports, "SelectSrp", {
  enumerable: true,
  get: function () {
    return _multiSrp.SelectSrp;
  }
});
Object.defineProperty(exports, "SrpList", {
  enumerable: true,
  get: function () {
    return _multiSrp.SrpList;
  }
});
Object.defineProperty(exports, "StackCard", {
  enumerable: true,
  get: function () {
    return _carousel.StackCard;
  }
});
Object.defineProperty(exports, "StackCardEmpty", {
  enumerable: true,
  get: function () {
    return _carousel.StackCardEmpty;
  }
});
Object.defineProperty(exports, "Toast", {
  enumerable: true,
  get: function () {
    return _toast.Toast;
  }
});
Object.defineProperty(exports, "ToastContainer", {
  enumerable: true,
  get: function () {
    return _toast.ToastContainer;
  }
});
Object.defineProperty(exports, "TokenListItem", {
  enumerable: true,
  get: function () {
    return _tokenListItem.TokenListItem;
  }
});
Object.defineProperty(exports, "ViewExplorerMenuItem", {
  enumerable: true,
  get: function () {
    return _menuItems.ViewExplorerMenuItem;
  }
});
var _accountListItem = require("./account-list-item");
var _accountListItemMenu = require("./account-list-item-menu");
var _accountListMenu = require("./account-list-menu");
var _accountOverview = require("./account-overview");
var _accountPicker = require("./account-picker");
var _activityListItem = require("./activity-list-item");
var _appHeader = require("./app-header");
var _detectedTokenBanner = require("./detected-token-banner");
var _globalMenu = require("./global-menu");
var _tokenListItem = require("./token-list-item");
var _addressCopyButton = require("./address-copy-button");
var _connectedSiteMenu = require("./connected-site-menu");
var _connectedSitePopover = require("./connected-site-popover");
var _networkListItem = require("./network-list-item");
var _networkListMenu = require("./network-list-menu");
var _productTourPopover = require("./product-tour-popover");
var _accountDetails = require("./account-details");
var _createAccount = require("./create-account");
var _createEthAccount = require("./create-eth-account");
var _connectedAccountsMenu = require("./connected-accounts-menu");
var _importAccount = require("./import-account");
var _importNftsModal = require("./import-nfts-modal");
var _menuItems = require("./menu-items");
var _importTokensModal = require("./import-tokens-modal");
var _avatarGroup = require("./avatar-group");
var _assetPickerAmount = require("./asset-picker-amount");
var _addressListItem = require("./address-list-item");
var _connectedStatus = require("./connected-status");
var _notificationListItem = require("./notification-list-item");
var _notificationListItemIcon = require("./notification-list-item-icon");
var _notificationListItemText = require("./notification-list-item-text");
var _notificationDetail = require("./notification-detail");
var _notificationDetailAddress = require("./notification-detail-address");
var _notificationDetailAsset = require("./notification-detail-asset");
var _notificationDetailCollection = require("./notification-detail-collection");
var _notificationDetailCopyButton = require("./notification-detail-copy-button");
var _notificationDetailNetworkFee = require("./notification-detail-network-fee");
var _notificationDetailInfo = require("./notification-detail-info");
var _notificationDetailNft = require("./notification-detail-nft");
var _notificationDetailTitle = require("./notification-detail-title");
var _notificationDetailButton = require("./notification-detail-button");
var _notificationDetailBlockExplorerButton = require("./notification-detail-block-explorer-button");
var _notificationsPage = require("./notifications-page");
var _notificationsSettingsBox = require("./notifications-settings-box");
var _notificationsSettingsType = require("./notifications-settings-type");
var _notificationsSettingsAccount = require("./notifications-settings-account");
var _notificationListItemSnap = require("./notification-list-item-snap");
var _notificationsTagCounter = require("./notifications-tag-counter");
var _toast = require("./toast");
var _permissionDetailsModal = require("./permission-details-modal");
var _receiveModal = require("./receive-modal");
var _editNetworksModal = require("./edit-networks-modal");
var _editAccountsModal = require("./edit-accounts-modal");
var _carousel = require("./carousel");
var _multiSrp = require("./multi-srp");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\menu-items\\account-details-menu-item.js", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","../../../selectors/multichain-accounts/feature-flags":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\feature-flags.ts","../../../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/menu":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\menu\\index.ts","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cmenu-items%5Caccount-details-menu-item.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountDetailsMenuItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _actions = require("../../../store/actions");
var _menu = require("../../ui/menu");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _metametrics = require("../../../contexts/metametrics");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _componentLibrary = require("../../component-library");
var _accountTree = require("../../../selectors/multichain-accounts/account-tree");
var _selectors = require("../../../selectors/selectors");
var _featureFlags = require("../../../selectors/multichain-accounts/feature-flags");
var _routes = require("../../../helpers/constants/routes");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AccountDetailsMenuItem = ({
  metricsLocation,
  closeMenu,
  address,
  textProps
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const selectedAccountGroup = (0, _reactRedux.useSelector)(_accountTree.getSelectedAccountGroup);
  const hdEntropyIndex = (0, _reactRedux.useSelector)(_selectors.getHDEntropyIndex);
  const history = (0, _reactRouterDom.useHistory)();
  const isMultichainAccountsState1Enabled = (0, _reactRedux.useSelector)(_featureFlags.getIsMultichainAccountsState1Enabled);
  const isMultichainAccountsState2Enabled = (0, _reactRedux.useSelector)(_featureFlags.getIsMultichainAccountsState2Enabled);
  const LABEL = t('accountDetails');
  const handleNavigation = (0, _react.useCallback)(() => {
    dispatch((0, _actions.setAccountDetailsAddress)(address));
    trackEvent({
      event: _metametrics2.MetaMetricsEventName.AccountDetailsOpened,
      category: _metametrics2.MetaMetricsEventCategory.Navigation,
      properties: {
        location: metricsLocation,
        hd_entropy_index: hdEntropyIndex
      }
    });
    if (isMultichainAccountsState2Enabled) {
      history.push(`${_routes.MULTICHAIN_ACCOUNT_DETAILS_PAGE_ROUTE}/${encodeURIComponent(selectedAccountGroup)}`);
    } else if (isMultichainAccountsState1Enabled) {
      history.push(`${_routes.ACCOUNT_DETAILS_ROUTE}/${address}`);
    }
    closeMenu === null || closeMenu === void 0 || closeMenu();
  }, [address, closeMenu, dispatch, hdEntropyIndex, history, isMultichainAccountsState1Enabled, isMultichainAccountsState2Enabled, metricsLocation, selectedAccountGroup, trackEvent]);
  return /*#__PURE__*/_react.default.createElement(_menu.MenuItem, {
    onClick: handleNavigation,
    iconName: _componentLibrary.IconName.ScanBarcode,
    "data-testid": "account-list-menu-details"
  }, textProps ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, textProps, LABEL) : LABEL);
};
exports.AccountDetailsMenuItem = AccountDetailsMenuItem;
AccountDetailsMenuItem.propTypes = {
  /**
   * Represents the "location" property of the metrics event
   */
  metricsLocation: _propTypes.default.string.isRequired,
  /**
   * Closes the menu
   */
  closeMenu: _propTypes.default.func,
  /**
   * Address to show account details for
   */
  address: _propTypes.default.string.isRequired,
  /**
   * Custom properties for the menu item text
   */
  textProps: _propTypes.default.object
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\menu-items\\account-details-menu-item.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\menu-items\\index.js", {"./account-details-menu-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\menu-items\\account-details-menu-item.js","./view-explorer-menu-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\menu-items\\view-explorer-menu-item.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cmenu-items%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "AccountDetailsMenuItem", {
  enumerable: true,
  get: function () {
    return _accountDetailsMenuItem.AccountDetailsMenuItem;
  }
});
Object.defineProperty(exports, "ViewExplorerMenuItem", {
  enumerable: true,
  get: function () {
    return _viewExplorerMenuItem.ViewExplorerMenuItem;
  }
});
var _accountDetailsMenuItem = require("./account-details-menu-item");
var _viewExplorerMenuItem = require("./view-explorer-menu-item");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\menu-items\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\menu-items\\view-explorer-menu-item.tsx", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../helpers/utils/multichain/blockExplorer":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\multichain\\blockExplorer.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../hooks/useMultichainSelector":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainSelector.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/menu":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\menu\\index.ts","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cmenu-items%5Cview-explorer-menu-item.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openBlockExplorer = exports.ViewExplorerMenuItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _utils = require("@metamask/utils");
var _blockExplorer = require("../../../helpers/utils/multichain/blockExplorer");
var _menu = require("../../ui/menu");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _metametrics = require("../../../contexts/metametrics");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _componentLibrary = require("../../component-library");
var _selectors = require("../../../selectors");
var _util = require("../../../helpers/utils/util");
var _routes = require("../../../helpers/constants/routes");
var _multichain = require("../../../selectors/multichain");
var _useMultichainSelector = require("../../../hooks/useMultichainSelector");
var _network = require("../../../../shared/constants/network");
var _networks = require("../../../../shared/modules/selectors/networks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const openBlockExplorer = (addressLink, metricsLocation, trackEvent, closeMenu) => {
  trackEvent({
    event: _metametrics2.MetaMetricsEventName.ExternalLinkClicked,
    category: _metametrics2.MetaMetricsEventCategory.Navigation,
    properties: {
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      link_type: _metametrics2.MetaMetricsEventLinkType.AccountTracker,
      location: metricsLocation,
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      url_domain: (0, _util.getURLHostName)(addressLink)
    }
  });
  global.platform.openTab({
    url: addressLink
  });
  closeMenu === null || closeMenu === void 0 || closeMenu();
};
exports.openBlockExplorer = openBlockExplorer;
const ViewExplorerMenuItem = ({
  metricsLocation,
  closeMenu,
  textProps,
  account
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const history = (0, _reactRouterDom.useHistory)();
  const multichainNetwork = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainNetwork, account);
  const addressLink = (0, _blockExplorer.getMultichainAccountUrl)(account.address, multichainNetwork);
  // TODO: Re-use CAIP-2 for metrics once event schemas support it
  const chainId = (0, _utils.parseCaipChainId)(multichainNetwork.chainId).reference;
  const blockExplorerUrl = (0, _blockExplorer.getMultichainBlockExplorerUrl)(multichainNetwork);

  // For EIP155 networks, determine subtitle based on network type
  const {
    namespace
  } = (0, _utils.parseCaipChainId)(multichainNetwork.chainId);
  const isCustomNetwork = (0, _reactRedux.useSelector)(_selectors.getIsCustomNetwork);
  const currentChainId = (0, _reactRedux.useSelector)(_networks.getCurrentChainId);
  const isTestNetwork = _network.TEST_NETWORK_IDS.includes(currentChainId);
  const isPopularNetwork = Boolean(_network.CHAIN_ID_TO_NETWORK_IMAGE_URL_MAP[currentChainId]);
  let blockExplorerUrlSubTitle = null;
  let actualAddressLink = addressLink;
  if (namespace === 'eip155') {
    // For test networks and custom networks, show actual block explorer URL
    if (isTestNetwork || !isPopularNetwork && isCustomNetwork) {
      blockExplorerUrlSubTitle = (0, _util.getURLHostName)(blockExplorerUrl);
      // network-specific explorer URL for navigation
      if (blockExplorerUrl) {
        const normalizedAddress = account.address;
        const baseUrl = blockExplorerUrl.endsWith('/') ? blockExplorerUrl : `${blockExplorerUrl}/`;
        actualAddressLink = `${baseUrl}address/${normalizedAddress}`;
      }
    } else {
      // For popular networks, show etherscan.io
      blockExplorerUrlSubTitle = 'etherscan.io';
    }
  } else {
    // For non-EIP155 networks, always show actual block explorer URL
    blockExplorerUrlSubTitle = (0, _util.getURLHostName)(blockExplorerUrl);
  }
  const blockExplorerLinkText = (0, _reactRedux.useSelector)(_selectors.getBlockExplorerLinkText);
  const routeToAddBlockExplorerUrl = () => {
    history.push(`${_routes.NETWORKS_ROUTE}#blockExplorerUrl`);
  };
  const LABEL = t('viewOnExplorer');
  return /*#__PURE__*/_react.default.createElement(_menu.MenuItem, {
    onClick: () => {
      blockExplorerLinkText.firstPart === 'addBlockExplorer' ? routeToAddBlockExplorerUrl() : openBlockExplorer(actualAddressLink, metricsLocation, trackEvent, closeMenu);
      trackEvent({
        event: _metametrics2.MetaMetricsEventName.BlockExplorerLinkClicked,
        category: _metametrics2.MetaMetricsEventCategory.Accounts,
        properties: {
          location: metricsLocation,
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          chain_id: chainId
        }
      });
      closeMenu === null || closeMenu === void 0 || closeMenu();
    },
    subtitle: blockExplorerUrlSubTitle || null,
    iconName: _componentLibrary.IconName.Export,
    "data-testid": "account-list-menu-open-explorer"
  }, textProps ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, textProps, LABEL) : LABEL);
};
exports.ViewExplorerMenuItem = ViewExplorerMenuItem;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\menu-items\\view-explorer-menu-item.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\multi-srp\\index.ts", {"./select-srp":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\multi-srp\\select-srp\\index.ts","./srp-list":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\multi-srp\\srp-list\\index.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cmulti-srp%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "SelectSrp", {
  enumerable: true,
  get: function () {
    return _selectSrp.SelectSrp;
  }
});
Object.defineProperty(exports, "SrpList", {
  enumerable: true,
  get: function () {
    return _srpList.SrpList;
  }
});
var _srpList = require("./srp-list");
var _selectSrp = require("./select-srp");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\multi-srp\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\multi-srp\\select-srp\\index.ts", {"./select-srp":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\multi-srp\\select-srp\\select-srp.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cmulti-srp%5Cselect-srp%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "SelectSrp", {
  enumerable: true,
  get: function () {
    return _selectSrp.SelectSrp;
  }
});
var _selectSrp = require("./select-srp");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\multi-srp\\select-srp\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\multi-srp\\select-srp\\select-srp.tsx", {"../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../ui/card":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\card\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cmulti-srp%5Cselect-srp%5Cselect-srp.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectSrp = void 0;
var _react = _interopRequireDefault(require("react"));
var _card = _interopRequireDefault(require("../../../ui/card"));
var _componentLibrary = require("../../../component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../hooks/useI18nContext");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const SelectSrp = ({
  srpName,
  srpAccounts,
  onClick
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    "data-testid": "select-srp-container"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Label, {
    marginBottom: 2
  }, t('selectSecretRecoveryPhrase')), /*#__PURE__*/_react.default.createElement(_card.default, {
    onClick: onClick,
    paddingTop: 1,
    paddingBottom: 1,
    className: "select-srp__container",
    "data-testid": `select-srp-${srpName}`
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, null, srpName), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textMuted
  }, srpAccounts > 1 ? t('srpListNumberOfAccounts', [srpAccounts]) : t('srpListSingleOrZero', [srpAccounts]))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.ArrowRight,
    size: _componentLibrary.IconSize.Sm
  }))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    marginTop: 1
  }, t('srpListSelectionDescription')));
};
exports.SelectSrp = SelectSrp;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\multi-srp\\select-srp\\select-srp.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\multi-srp\\srp-list\\index.ts", {"./srp-list":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\multi-srp\\srp-list\\srp-list.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cmulti-srp%5Csrp-list%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "SrpList", {
  enumerable: true,
  get: function () {
    return _srpList.SrpList;
  }
});
var _srpList = require("./srp-list");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\multi-srp\\srp-list\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\multi-srp\\srp-list\\srp-list-item.tsx", {"../../../../../app/scripts/lib/multichain/address":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\multichain\\address.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../../hooks/useMultichainAccountTotalFiatBalance":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainAccountTotalFiatBalance.ts","../../../../selectors/assets":"D:\\code\\v\\metamask-extension\\ui\\selectors\\assets.ts","../../../app/user-preferenced-currency-display":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\user-preferenced-currency-display\\index.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cmulti-srp%5Csrp-list%5Csrp-list-item.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SrpListItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _keyringApi = require("@metamask/keyring-api");
var _designSystemReact = require("@metamask/design-system-react");
var _useMultichainAccountTotalFiatBalance = require("../../../../hooks/useMultichainAccountTotalFiatBalance");
var _designSystem = require("../../../../helpers/constants/design-system");
var _util = require("../../../../helpers/utils/util");
var _userPreferencedCurrencyDisplay = _interopRequireDefault(require("../../../app/user-preferenced-currency-display"));
var _componentLibrary = require("../../../component-library");
var _address = require("../../../../../app/scripts/lib/multichain/address");
var _assets = require("../../../../selectors/assets");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// eslint-disable-next-line import/no-restricted-paths

const SrpListItem = ({
  account
}) => {
  const {
    totalFiatBalance
  } = (0, _useMultichainAccountTotalFiatBalance.useMultichainAccountTotalFiatBalance)(account);
  const isEvmAccount = (0, _keyringApi.isEvmAccountType)(account.type);
  const multichainAggregatedBalance = (0, _reactRedux.useSelector)(state => (0, _assets.getMultichainAggregatedBalance)(state, account));
  const balance = (0, _react.useMemo)(() => {
    if (isEvmAccount) {
      return totalFiatBalance;
    }
    return multichainAggregatedBalance.toString();
  }, [isEvmAccount, multichainAggregatedBalance, totalFiatBalance]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    key: account.address,
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_designSystemReact.AvatarAccount, {
    address: account.address,
    size: _designSystemReact.AvatarAccountSize.Xs
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    className: "srp-list__account-name",
    variant: _designSystem.TextVariant.bodySm,
    ellipsis: true,
    paddingInlineStart: 3
  }, account.metadata.name), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative,
    marginLeft: 1,
    paddingInlineStart: 1
  }, (0, _util.shortenAddress)((0, _address.normalizeSafeAddress)(account.address)))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm
  }, /*#__PURE__*/_react.default.createElement(_userPreferencedCurrencyDisplay.default, {
    account: account,
    value: balance,
    type: "PRIMARY",
    ethNumberOfDecimals: 4,
    hideTitle: true,
    showFiat: true,
    isAggregatedFiatOverviewBalance: true,
    hideLabel: true
  })));
};
exports.SrpListItem = SrpListItem;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\multi-srp\\srp-list\\srp-list-item.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\multi-srp\\srp-list\\srp-list.tsx", {"../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/multi-srp/useHdKeyringsWithSnapAccounts":"D:\\code\\v\\metamask-extension\\ui\\hooks\\multi-srp\\useHdKeyringsWithSnapAccounts.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../ui/card":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\card\\index.js","./srp-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\multi-srp\\srp-list\\srp-list-item.tsx","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cmulti-srp%5Csrp-list%5Csrp-list.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SrpList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _classnames = _interopRequireDefault(require("classnames"));
var _card = _interopRequireDefault(require("../../../ui/card"));
var _componentLibrary = require("../../../component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _selectors = require("../../../../selectors/selectors");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _metametrics = require("../../../../../shared/constants/metametrics");
var _metametrics2 = require("../../../../contexts/metametrics");
var _useHdKeyringsWithSnapAccounts = require("../../../../hooks/multi-srp/useHdKeyringsWithSnapAccounts");
var _metamask = require("../../../../ducks/metamask/metamask");
var _srpListItem = require("./srp-list-item");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SrpList = ({
  onActionComplete,
  hideShowAccounts,
  isSettingsPage = false
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const hdKeyringsWithSnapAccounts = (0, _useHdKeyringsWithSnapAccounts.useHdKeyringsWithSnapAccounts)();
  const isPrimarySeedPhraseBackedUp = (0, _reactRedux.useSelector)(_metamask.getIsPrimarySeedPhraseBackedUp);

  // This selector will return accounts with nonEVM balances as well.
  const accountsWithBalances = (0, _reactRedux.useSelector)(_selectors.getMetaMaskAccounts);
  const showAccountsInitState = (0, _react.useMemo)(() => new Array(hdKeyringsWithSnapAccounts.length).fill(hideShowAccounts), [hdKeyringsWithSnapAccounts, hideShowAccounts]);
  const [showAccounts, setShowAccounts] = (0, _react.useState)(showAccountsInitState);
  const showHideText = (index, numberOfAccounts) => {
    if (numberOfAccounts > 1) {
      return showAccounts[index] ? t('SrpListHideAccounts', [numberOfAccounts]) : t('SrpListShowAccounts', [numberOfAccounts]);
    }
    return showAccounts[index] ? t('SrpListHideSingleAccount', [numberOfAccounts]) : t('SrpListShowSingleAccount', [numberOfAccounts]);
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: (0, _classnames.default)('srp-list__container', {
      'srp-list__container--settings': isSettingsPage
    }),
    padding: isSettingsPage ? 0 : 4,
    "data-testid": "srp-list"
  }, hdKeyringsWithSnapAccounts.map((keyring, index) => {
    // We only consider the first(primary) keyring for the backup reminder.
    const shouldTriggerBackup = !isPrimarySeedPhraseBackedUp && index === 0;
    return /*#__PURE__*/_react.default.createElement(_card.default, {
      key: `srp-${keyring.metadata.id}`,
      "data-testid": `hd-keyring-${keyring.metadata.id}`,
      onClick: () => {
        trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Accounts,
          event: _metametrics.MetaMetricsEventName.SecretRecoveryPhrasePickerClicked,
          properties: {
            // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
            // eslint-disable-next-line @typescript-eslint/naming-convention
            button_type: 'srp_select'
          }
        });
        onActionComplete(keyring.metadata.id, shouldTriggerBackup);
      },
      className: "select-srp__container",
      marginBottom: 3
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      alignItems: _designSystem.AlignItems.center,
      justifyContent: _designSystem.JustifyContent.spaceBetween
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMdMedium
    }, t('srpListName', [index + 1])), !hideShowAccounts && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodySm,
      color: _designSystem.TextColor.primaryDefault,
      className: "srp-list__show-accounts",
      "data-testid": `srp-list-show-accounts-${index}`,
      onClick: event => {
        event.stopPropagation();
        trackEvent({
          category: _metametrics.MetaMetricsEventCategory.Accounts,
          event: _metametrics.MetaMetricsEventName.SecretRecoveryPhrasePickerClicked,
          properties: {
            // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
            // eslint-disable-next-line @typescript-eslint/naming-convention
            button_type: 'details'
          }
        });
        setShowAccounts(prevState => {
          const accountListLength = hdKeyringsWithSnapAccounts.length;
          let newState = prevState;
          if (accountListLength > prevState.length) {
            // Extend the state with `false` for new accounts
            newState = [...prevState, ...Array(accountListLength - prevState.length).fill(false)];
          }
          return newState.map((value, i) => i === index ? !value : value);
        });
      }
    }, showHideText(index, keyring.accounts.length))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      alignItems: _designSystem.AlignItems.center,
      gap: 1
    }, isSettingsPage && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMdMedium,
      color: shouldTriggerBackup ? _designSystem.TextColor.errorDefault : _designSystem.TextColor.textAlternative
    }, shouldTriggerBackup ? t('srpListStateNotBackedUp') : t('srpListStateBackedUp')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
      name: _componentLibrary.IconName.ArrowRight,
      size: _componentLibrary.IconSize.Sm,
      color: shouldTriggerBackup && isSettingsPage ? _designSystem.IconColor.errorDefault : _designSystem.IconColor.iconAlternative
    }))), showAccounts[index] && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      width: _designSystem.BlockSize.Full,
      className: "srp-list__divider",
      marginTop: 2,
      marginBottom: 2
    }), keyring.accounts.map(address => {
      const account = accountsWithBalances[address];
      return /*#__PURE__*/_react.default.createElement(_srpListItem.SrpListItem, {
        key: `account-${account.id}`,
        account: account
      });
    })));
  }));
};
exports.SrpList = SrpList;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\multi-srp\\srp-list\\srp-list.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\multichain-accounts\\wallet-details-account-item\\wallet-details-account-item.tsx", {"../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useMultichainAccountTotalFiatBalance":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainAccountTotalFiatBalance.ts","../../../app/preferred-avatar":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\preferred-avatar\\index.ts","../../../app/user-preferenced-currency-display/user-preferenced-currency-display.component":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\user-preferenced-currency-display\\user-preferenced-currency-display.component.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cmultichain-accounts%5Cwallet-details-account-item%5Cwallet-details-account-item.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _designSystemReact = require("@metamask/design-system-react");
var _componentLibrary = require("../../../component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _preferredAvatar = require("../../../app/preferred-avatar");
var _useMultichainAccountTotalFiatBalance = require("../../../../hooks/useMultichainAccountTotalFiatBalance");
var _userPreferencedCurrencyDisplay = _interopRequireDefault(require("../../../app/user-preferenced-currency-display/user-preferenced-currency-display.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const WalletDetailsAccountItem = ({
  account,
  onClick,
  onBalanceUpdate,
  className,
  ...rowStylesProps
}) => {
  const {
    totalFiatBalance
  } = (0, _useMultichainAccountTotalFiatBalance.useMultichainAccountTotalFiatBalance)(account);
  (0, _react.useEffect)(() => {
    onBalanceUpdate(account.id, totalFiatBalance);
  }, [totalFiatBalance, account.id, onBalanceUpdate]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, _extends({
    className: className,
    as: "button",
    onClick: () => onClick(account),
    width: _designSystem.BlockSize.Full,
    textAlign: _designSystem.TextAlign.Left,
    padding: 4,
    marginBottom: 1,
    style: {
      cursor: 'pointer',
      border: 'none'
    },
    "data-testid": `wallet-details-account-item-${account.id}`
  }, rowStylesProps), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    gap: 3
  }, /*#__PURE__*/_react.default.createElement(_preferredAvatar.PreferredAvatar, {
    address: account.address,
    size: _designSystemReact.AvatarAccountSize.Sm
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: _designSystem.TextColor.textDefault
  }, account.metadata.name))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    gap: 2
  }, /*#__PURE__*/_react.default.createElement(_userPreferencedCurrencyDisplay.default, {
    account: account,
    value: totalFiatBalance,
    type: "PRIMARY",
    ethNumberOfDecimals: 4,
    hideTitle: true,
    showFiat: true,
    isAggregatedFiatOverviewBalance: true,
    hideLabel: true,
    textProps: {
      color: _designSystem.TextColor.textAlternative,
      variant: _designSystem.TextVariant.bodyMdMedium
    }
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.ArrowRight,
    size: _componentLibrary.IconSize.Sm,
    color: _designSystem.IconColor.iconMuted
  })));
};
var _default = exports.default = /*#__PURE__*/(0, _react.memo)(WalletDetailsAccountItem);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\multichain-accounts\\wallet-details-account-item\\wallet-details-account-item.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\multichain-accounts\\wallet-details-account-type-selection\\index.ts", {"./wallet-details-account-type-selection":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\multichain-accounts\\wallet-details-account-type-selection\\wallet-details-account-type-selection.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cmultichain-accounts%5Cwallet-details-account-type-selection%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "WalletDetailsAccountTypeSelection", {
  enumerable: true,
  get: function () {
    return _walletDetailsAccountTypeSelection.WalletDetailsAccountTypeSelection;
  }
});
var _walletDetailsAccountTypeSelection = require("./wallet-details-account-type-selection");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\multichain-accounts\\wallet-details-account-type-selection\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\multichain-accounts\\wallet-details-account-type-selection\\wallet-details-account-type-selection.tsx", {"../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/accounts/useMultichainWalletSnapClient":"D:\\code\\v\\metamask-extension\\ui\\hooks\\accounts\\useMultichainWalletSnapClient.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cmultichain-accounts%5Cwallet-details-account-type-selection%5Cwallet-details-account-type-selection.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WalletDetailsAccountTypeSelection = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _designSystem = require("../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _componentLibrary = require("../../../component-library");
var _useMultichainWalletSnapClient = require("../../../../hooks/accounts/useMultichainWalletSnapClient");
var _selectors = require("../../../../selectors");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const WalletDetailsAccountTypeSelection = ({
  onAccountTypeSelect,
  onClose
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const solanaSupportEnabled = (0, _reactRedux.useSelector)(_selectors.getIsSolanaSupportEnabled);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    endAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      iconName: _componentLibrary.IconName.Close,
      onClick: onClose,
      ariaLabel: t('close')
    }),
    padding: 4
  }, t('newAccount')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 4,
    paddingRight: 4,
    paddingBottom: 4,
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: _designSystem.JustifyContent.flexStart,
    alignItems: _designSystem.AlignItems.flexStart
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySmMedium,
    marginBottom: 2,
    color: _designSystem.TextColor.textAlternative
  }, t('createNewAccountHeader')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    marginBottom: 2,
    size: _componentLibrary.ButtonLinkSize.Sm,
    startIconName: _componentLibrary.IconName.Add,
    startIconProps: {
      size: _componentLibrary.IconSize.Md
    },
    onClick: () => onAccountTypeSelect(_useMultichainWalletSnapClient.EVM_WALLET_TYPE),
    "data-testid": "wallet-details-add-ethereum-account"
  }, t('addNewEthereumAccountLabel')), solanaSupportEnabled && /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    marginBottom: 2,
    size: _componentLibrary.ButtonLinkSize.Sm,
    startIconName: _componentLibrary.IconName.Add,
    startIconProps: {
      size: _componentLibrary.IconSize.Md
    },
    onClick: () => onAccountTypeSelect(_useMultichainWalletSnapClient.WalletClientType.Solana),
    "data-testid": "wallet-details-add-solana-account"
  }, t('addNewSolanaAccountLabel')))));
};
exports.WalletDetailsAccountTypeSelection = WalletDetailsAccountTypeSelection;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\multichain-accounts\\wallet-details-account-type-selection\\wallet-details-account-type-selection.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-filter-menu\\index.tsx", {"../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../app/assets/asset-list/network-filter":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\asset-list\\network-filter\\index.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../component-library/button-base":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\button-base\\index.ts","../../component-library/icon":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\icon\\index.ts","../../component-library/popover":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\popover\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnetwork-filter-menu%5Cindex.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.NetworkFilterComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _icon = require("../../component-library/icon");
var _designSystem = require("../../../helpers/constants/design-system");
var _buttonBase = require("../../component-library/button-base");
var _popover = require("../../component-library/popover");
var _componentLibrary = require("../../component-library");
var _network = require("../../../../shared/constants/network");
var _networkFilter = _interopRequireDefault(require("../../app/assets/asset-list/network-filter"));
var _useI18nContext = require("../../../hooks/useI18nContext");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NetworkFilterComponent = ({
  isFullScreen,
  toggleNetworkFilterPopover,
  isTestNetwork,
  currentNetworkConfig,
  isNetworkFilterPopoverOpen,
  closePopover,
  isTokenNetworkFilterEqualCurrentNetwork
}) => {
  const popoverRef = (0, _react.useRef)(null);
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginLeft: 2,
    marginRight: 2,
    justifyContent: isFullScreen ? _designSystem.JustifyContent.flexStart : _designSystem.JustifyContent.spaceBetween,
    ref: popoverRef
  }, /*#__PURE__*/_react.default.createElement(_buttonBase.ButtonBase, {
    "data-testid": "sort-by-popover-toggle",
    className: "asset-list-control-bar__button asset-list-control-bar__network_control",
    onClick: toggleNetworkFilterPopover,
    size: _buttonBase.ButtonBaseSize.Sm,
    disabled: isTestNetwork || !_network.FEATURED_NETWORK_CHAIN_IDS.includes(currentNetworkConfig.chainId),
    endIconName: _icon.IconName.ArrowDown,
    backgroundColor: isNetworkFilterPopoverOpen ? _designSystem.BackgroundColor.backgroundPressed : _designSystem.BackgroundColor.backgroundDefault,
    color: _designSystem.TextColor.textDefault,
    marginRight: isFullScreen ? 2 : null,
    ellipsis: true
  }, isTokenNetworkFilterEqualCurrentNetwork ? (currentNetworkConfig === null || currentNetworkConfig === void 0 ? void 0 : currentNetworkConfig.nickname) ?? t('currentNetwork') : t('popularNetworks')), /*#__PURE__*/_react.default.createElement(_popover.Popover, {
    onClickOutside: closePopover,
    isOpen: isNetworkFilterPopoverOpen,
    position: _popover.PopoverPosition.BottomStart,
    referenceElement: popoverRef.current,
    matchWidth: !isFullScreen,
    style: {
      zIndex: 10,
      display: 'flex',
      flexDirection: 'column',
      padding: 0,
      minWidth: isFullScreen ? '325px' : ''
    }
  }, /*#__PURE__*/_react.default.createElement(_networkFilter.default, {
    handleClose: closePopover
  })));
};
exports.NetworkFilterComponent = NetworkFilterComponent;
var _default = exports.default = NetworkFilterComponent;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\network-filter-menu\\index.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-item-menu\\index.js", {"./network-list-item-menu":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-item-menu\\network-list-item-menu.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnetwork-list-item-menu%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "NetworkListItemMenu", {
  enumerable: true,
  get: function () {
    return _networkListItemMenu.NetworkListItemMenu;
  }
});
var _networkListItemMenu = require("./network-list-item-menu");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\network-list-item-menu\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-item-menu\\network-list-item-menu.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/menu":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\menu\\index.ts","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnetwork-list-item-menu%5Cnetwork-list-item-menu.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkListItemMenu = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _useI18nContext = require("../../../hooks/useI18nContext");
var _componentLibrary = require("../../component-library");
var _menu = require("../../ui/menu");
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const NetworkListItemMenu = ({
  anchorElement,
  onClose,
  onEditClick,
  onDeleteClick,
  onDiscoverClick,
  isOpen
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Popover, {
    className: "multichain-network-list-item-menu__popover",
    onClickOutside: onClose,
    referenceElement: anchorElement,
    role: _componentLibrary.PopoverRole.Dialog,
    position: _componentLibrary.PopoverPosition.BottomEnd,
    offset: [8, 0],
    padding: 0,
    isOpen: isOpen,
    isPortal: true,
    preventOverflow: true,
    flip: true
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalFocus, {
    restoreFocus: true,
    initialFocusRef: anchorElement
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, onDiscoverClick ? /*#__PURE__*/_react.default.createElement(_menu.MenuItem, {
    iconName: _componentLibrary.IconName.Eye,
    onClick: e => {
      e.stopPropagation();
      onDiscoverClick();
    },
    "data-testid": "network-list-item-options-discover"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, null, t('discover'))) : null, onEditClick ? /*#__PURE__*/_react.default.createElement(_menu.MenuItem, {
    iconName: _componentLibrary.IconName.Edit,
    onClick: e => {
      e.stopPropagation();
      onEditClick();
    },
    "data-testid": "network-list-item-options-edit"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, null, " ", t('edit'))) : null, onDeleteClick ? /*#__PURE__*/_react.default.createElement(_menu.MenuItem, {
    iconName: _componentLibrary.IconName.Trash,
    iconColor: _designSystem.IconColor.errorDefault,
    onClick: e => {
      e.stopPropagation();
      onDeleteClick();
    },
    "data-testid": "network-list-item-options-delete"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.errorDefault
  }, t('delete'))) : null)));
};
exports.NetworkListItemMenu = NetworkListItemMenu;
NetworkListItemMenu.propTypes = {
  /**
   * Element that the menu should display next to
   */
  anchorElement: _propTypes.default.instanceOf(window.Element),
  /**
   * Function that executes when the menu is closed
   */
  onClose: _propTypes.default.func.isRequired,
  /**
   * Function that executes when the Edit menu item is clicked
   */
  onEditClick: _propTypes.default.func,
  /**
   * Function that executes when the Delete menu item is closed
   */
  onDeleteClick: _propTypes.default.func,
  /**
   * Function that executes when the Discover menu item is clicked
   */
  onDiscoverClick: _propTypes.default.func,
  /**
   * Represents if the menu is open or not
   *
   * @type {boolean}
   */
  isOpen: _propTypes.default.bool.isRequired
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\network-list-item-menu\\network-list-item-menu.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-item\\index.js", {"./network-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-item\\network-list-item.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnetwork-list-item%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "NetworkListItem", {
  enumerable: true,
  get: function () {
    return _networkListItem.NetworkListItem;
  }
});
var _networkListItem = require("./network-list-item");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\network-list-item\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-item\\network-list-item.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/accounts":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\accounts.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/tooltip/tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\tooltip.js","../network-list-item-menu":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-item-menu\\index.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnetwork-list-item%5Cnetwork-list-item.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkListItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../component-library");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _accounts = require("../../../helpers/utils/accounts");
var _tooltip = _interopRequireDefault(require("../../ui/tooltip/tooltip"));
var _networkListItemMenu = require("../network-list-item-menu");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const isIconSrc = iconSrc => Object.values(_componentLibrary.IconName).includes(iconSrc);

// TODO: Consider increasing this. This tooltip is
// rendering when it has enough room to see everything
const MAXIMUM_CHARACTERS_WITHOUT_TOOLTIP = 20;
const NetworkListItem = ({
  name,
  iconSrc,
  iconSize = _componentLibrary.AvatarNetworkSize.Md,
  rpcEndpoint,
  chainId,
  selected = false,
  focus = true,
  onClick,
  onDeleteClick,
  onEditClick,
  onDiscoverClick,
  onRpcEndpointClick,
  startAccessory,
  endAccessory,
  showEndAccessory = true,
  disabled = false,
  variant,
  notSelectable = false
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const networkRef = (0, _react.useRef)(null);
  const [networkListItemMenuElement, setNetworkListItemMenuElement] = (0, _react.useState)();

  // I can't find a type that satisfies this.

  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  const setNetworkListItemMenuRef = ref => {
    setNetworkListItemMenuElement(ref);
  };
  const [networkOptionsMenuOpen, setNetworkOptionsMenuOpen] = (0, _react.useState)(false);
  const renderButton = (0, _react.useCallback)(() => {
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    return onDeleteClick || onEditClick || onDiscoverClick ? /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      iconName: _componentLibrary.IconName.MoreVertical,
      ref: setNetworkListItemMenuRef,
      "data-testid": `network-list-item-options-button-${chainId}`,
      ariaLabel: t('networkOptions'),
      onClick: e => {
        e.stopPropagation();
        setNetworkOptionsMenuOpen(true);
      },
      size: _componentLibrary.ButtonIconSize.Sm
    }) : null;
  }, [onDeleteClick, onEditClick, onDiscoverClick, chainId, t, setNetworkListItemMenuRef, setNetworkOptionsMenuOpen]);
  (0, _react.useEffect)(() => {
    if (networkRef.current && focus) {
      networkRef.current.focus();
    }
  }, [networkRef, focus]);
  const handleKeyPress = e => {
    if (e.key === 'Enter') {
      e.stopPropagation(); // Prevent the event from reaching the parent container
      onClick();
    }
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    "data-testid": `network-list-item-${chainId}`,
    paddingLeft: 4,
    paddingRight: 4,
    paddingTop: rpcEndpoint ? 2 : 4,
    paddingBottom: rpcEndpoint ? 2 : 4,
    gap: 4,
    backgroundColor: selected ? _designSystem.BackgroundColor.primaryMuted : _designSystem.BackgroundColor.transparent,
    className: (0, _classnames.default)('multichain-network-list-item', {
      'multichain-network-list-item--selected': selected,
      'multichain-network-list-item--deselected': !selected,
      'multichain-network-list-item--disabled': disabled,
      'multichain-network-list-item--not-selectable': notSelectable
    }),
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    width: _designSystem.BlockSize.Full,
    onClick: disabled ? undefined : onClick
  }, startAccessory ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginTop: 1
  }, startAccessory) : null, selected && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "multichain-network-list-item__selected-indicator",
    borderRadius: _designSystem.BorderRadius.pill,
    backgroundColor: _designSystem.BackgroundColor.primaryDefault
  }), isIconSrc(iconSrc) ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: iconSrc,
    size: iconSize
  }) : /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
    borderColor: _designSystem.BorderColor.backgroundDefault,
    backgroundColor: (0, _accounts.getAvatarNetworkColor)(name),
    name: name,
    src: iconSrc,
    size: iconSize
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.flexStart,
    justifyContent: _designSystem.JustifyContent.flexStart,
    width: _designSystem.BlockSize.Full,
    style: {
      overflow: 'hidden'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    width: _designSystem.BlockSize.Full,
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    "data-testid": name
  }, /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    title: name,
    position: "bottom",
    wrapperClassName: "multichain-network-list-item__tooltip",
    disabled: (name === null || name === void 0 ? void 0 : name.length) <= MAXIMUM_CHARACTERS_WITHOUT_TOOLTIP
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    ref: networkRef,
    color: _designSystem.TextColor.textDefault,
    backgroundColor: _designSystem.BackgroundColor.transparent,
    variant: variant ?? _designSystem.TextVariant.bodyMd,
    ellipsis: true,
    onKeyDown: handleKeyPress,
    tabIndex: 0 // Enable keyboard focus
  }, name))), rpcEndpoint && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "multichain-network-list-item__rpc-endpoint",
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    "data-testid": `network-rpc-name-button-${chainId}`,
    onClick: e => {
      e.stopPropagation();
      onRpcEndpointClick === null || onRpcEndpointClick === void 0 || onRpcEndpointClick();
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    padding: 0,
    backgroundColor: _designSystem.BackgroundColor.transparent,
    as: "button",
    variant: _designSystem.TextVariant.bodySmMedium,
    color: _designSystem.TextColor.textAlternative,
    ellipsis: true
  }, rpcEndpoint.name ?? new URL(rpcEndpoint.url).host), /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    marginLeft: 1,
    color: _designSystem.IconColor.iconAlternative,
    name: _componentLibrary.IconName.ArrowDown,
    size: _componentLibrary.IconSize.Xs
  }))), renderButton(), showEndAccessory ? endAccessory ?? /*#__PURE__*/_react.default.createElement(_networkListItemMenu.NetworkListItemMenu, {
    anchorElement: networkListItemMenuElement,
    isOpen: networkOptionsMenuOpen,
    onDeleteClick: onDeleteClick,
    onEditClick: onEditClick,
    onDiscoverClick: onDiscoverClick,
    onClose: () => setNetworkOptionsMenuOpen(false)
  }) : null);
};
exports.NetworkListItem = NetworkListItem;
NetworkListItem.propTypes = {
  /**
   * The name of the network
   */
  name: _propTypes.default.string.isRequired,
  /**
   * Path to the Icon image
   */
  iconSrc: _propTypes.default.string,
  /**
   * Icon network size
   */
  iconSize: _propTypes.default.string,
  /**
   * Represents if the network item is selected
   */
  selected: _propTypes.default.bool,
  /**
   * Executes when the item is clicked
   */
  onClick: _propTypes.default.func.isRequired,
  /**
   * Executes when the delete icon is clicked
   */
  onDeleteClick: _propTypes.default.func,
  /**
   * Executes when the edit icon is clicked
   */
  onEditClick: _propTypes.default.func,
  /**
   * Represents if the network item should be keyboard selected
   */
  focus: _propTypes.default.bool,
  /**
   * Represents start accessory
   */
  startAccessory: _propTypes.default.node,
  /**
   * Represents end accessory
   */
  endAccessory: _propTypes.default.node,
  /**
   * Represents if we need to show menu option or endAccessory
   */
  showEndAccessory: _propTypes.default.bool
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\network-list-item\\network-list-item.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-menu\\add-block-explorer-modal\\add-block-explorer-modal.tsx", {"../../../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnetwork-list-menu%5Cadd-block-explorer-modal%5Cadd-block-explorer-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _componentLibrary = require("../../../component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _util = require("../../../../../app/scripts/lib/util");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

const AddBlockExplorerModal = ({
  onAdded
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const [url, setUrl] = (0, _react.useState)();
  const [error, setError] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    if (url && (url === null || url === void 0 ? void 0 : url.length) > 0 && !(0, _util.isWebUrl)(url)) {
      setError(t('urlErrorMsg'));
    } else {
      setError(undefined);
    }
  }, [url]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "add-block-explorer-modal",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    height: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 4,
    paddingRight: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.FormTextField, {
    size: _componentLibrary.FormTextFieldSize.Lg,
    textFieldProps: {
      borderRadius: _designSystem.BorderRadius.LG
    },
    error: Boolean(error),
    id: "additional-rpc-url",
    label: t('blockExplorerUrl'),
    inputProps: {
      'data-testid': 'explorer-url-input'
    },
    labelProps: {
      children: undefined,
      variant: _designSystem.TextVariant.bodyMdMedium
    },
    onChange: e => setUrl(e.target.value),
    autoFocus: true
  }), error && /*#__PURE__*/_react.default.createElement(_componentLibrary.HelpText, {
    severity: _componentLibrary.HelpTextSeverity.Danger
  }, error)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "add-block-explorer-modal__footer",
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    padding: 4,
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonPrimary, {
    width: _designSystem.BlockSize.Full,
    disabled: Boolean(error),
    size: _componentLibrary.ButtonPrimarySize.Lg
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    ,
    onClick: async () => {
      if (url) {
        onAdded(url);
      }
    }
  }, t('addUrl'))));
};
var _default = exports.default = AddBlockExplorerModal;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\network-list-menu\\add-block-explorer-modal\\add-block-explorer-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-menu\\add-non-evm-account\\add-non-evm-account.tsx", {"../../../../../shared/constants/multichain/networks":"D:\\code\\v\\metamask-extension\\shared\\constants\\multichain\\networks.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/accounts/useMultichainWalletSnapClient":"D:\\code\\v\\metamask-extension\\ui\\hooks\\accounts\\useMultichainWalletSnapClient.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../create-snap-account":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\create-snap-account\\index.ts","../../multi-srp/srp-list":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\multi-srp\\srp-list\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnetwork-list-menu%5Cadd-non-evm-account%5Cadd-non-evm-account.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _actions = require("../../../../store/actions");
var _networks = require("../../../../../shared/constants/multichain/networks");
var _componentLibrary = require("../../../component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _selectors = require("../../../../selectors");
var _createSnapAccount = require("../../create-snap-account");
var _srpList = require("../../multi-srp/srp-list");
var _useMultichainWalletSnapClient = require("../../../../hooks/accounts/useMultichainWalletSnapClient");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SNAP_CLIENT_CONFIG_MAP = {
  [_networks.MultichainNetworks.BITCOIN]: {
    clientType: _useMultichainWalletSnapClient.WalletClientType.Bitcoin,
    chainId: _networks.MultichainNetworks.BITCOIN
  },
  [_networks.MultichainNetworks.BITCOIN_TESTNET]: {
    clientType: _useMultichainWalletSnapClient.WalletClientType.Bitcoin,
    chainId: _networks.MultichainNetworks.BITCOIN_TESTNET
  },
  [_networks.MultichainNetworks.BITCOIN_SIGNET]: {
    clientType: _useMultichainWalletSnapClient.WalletClientType.Bitcoin,
    chainId: _networks.MultichainNetworks.BITCOIN_SIGNET
  },
  [_networks.MultichainNetworks.SOLANA]: {
    clientType: _useMultichainWalletSnapClient.WalletClientType.Solana,
    chainId: _networks.MultichainNetworks.SOLANA
  },
  [_networks.MultichainNetworks.SOLANA_TESTNET]: {
    clientType: _useMultichainWalletSnapClient.WalletClientType.Solana,
    chainId: _networks.MultichainNetworks.SOLANA_TESTNET
  },
  [_networks.MultichainNetworks.SOLANA_DEVNET]: {
    clientType: _useMultichainWalletSnapClient.WalletClientType.Solana,
    chainId: _networks.MultichainNetworks.SOLANA_DEVNET
  }
};
const AddNonEvmAccountModal = ({
  chainId
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const [primaryKeyring] = (0, _reactRedux.useSelector)(_selectors.getMetaMaskHdKeyrings);
  const [showSrpSelection, setShowSrpSelection] = _react.default.useState(false);
  const [showCreateAccount, setShowCreateAccount] = _react.default.useState(false);
  const [selectedKeyringId, setSelectedKeyringId] = _react.default.useState(primaryKeyring.metadata.id);
  const handleActionComplete = (0, _react.useCallback)(async confirmed => {
    if (confirmed) {
      dispatch((0, _actions.toggleNetworkMenu)());
    } else {
      setShowCreateAccount(false);
    }
  }, [dispatch]);
  const handleSelectSrp = (0, _react.useCallback)(() => {
    setShowSrpSelection(true);
    setShowCreateAccount(false);
  }, []);
  const handleSrpActionComplete = (0, _react.useCallback)(keyringId => {
    setSelectedKeyringId(keyringId);
    setShowCreateAccount(true);
  }, []);
  const handleAddAccount = (0, _react.useCallback)(() => {
    setShowCreateAccount(true);
  }, []);
  const {
    clientType,
    chainId: mappedChainId
  } = SNAP_CLIENT_CONFIG_MAP[chainId] || {
    clientType: null,
    chainId: null
  };
  if (showCreateAccount && clientType && mappedChainId) {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      className: "add-non-evm-account-modal",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      justifyContent: _designSystem.JustifyContent.spaceBetween
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      paddingLeft: 4,
      paddingRight: 4,
      paddingBottom: 4
    }, /*#__PURE__*/_react.default.createElement(_createSnapAccount.CreateSnapAccount, {
      onActionComplete: handleActionComplete,
      selectedKeyringId: selectedKeyringId,
      onSelectSrp: handleSelectSrp,
      clientType: clientType,
      chainId: mappedChainId
    })));
  }
  if (showSrpSelection) {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      className: "add-non-evm-account-modal",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      justifyContent: _designSystem.JustifyContent.spaceBetween
    }, /*#__PURE__*/_react.default.createElement(_srpList.SrpList, {
      onActionComplete: handleSrpActionComplete
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "add-non-evm-account-modal",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 4,
    paddingRight: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    textAlign: _designSystem.TextAlign.Left,
    variant: _designSystem.TextVariant.bodyMd
  }, t('addNonEvmAccountFromNetworkPicker', [_networks.MULTICHAIN_NETWORK_TO_NICKNAME[chainId], _networks.MULTICHAIN_NETWORK_TO_ACCOUNT_TYPE_NAME[chainId]]))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "add-non-evm-account-modal__footer",
    padding: 4,
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonPrimary, {
    width: _designSystem.BlockSize.Full,
    size: _componentLibrary.ButtonPrimarySize.Lg,
    onClick: handleAddAccount
  }, t('addAccount'))));
};
var _default = exports.default = AddNonEvmAccountModal;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\network-list-menu\\add-non-evm-account\\add-non-evm-account.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-menu\\add-rpc-url-modal\\add-rpc-url-modal.tsx", {"../../../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnetwork-list-menu%5Cadd-rpc-url-modal%5Cadd-rpc-url-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _componentLibrary = require("../../../component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _util = require("../../../../../app/scripts/lib/util");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

const AddRpcUrlModal = ({
  onAdded
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const [url, setUrl] = (0, _react.useState)();
  const [error, setError] = (0, _react.useState)();
  const nameRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    if (url && !(0, _util.isWebUrl)(url)) {
      setError((0, _util.isWebUrl)(`https://${url}`) ? t('urlErrorMsg') : t('invalidRPC'));
    } else {
      setError(undefined);
    }
  }, [url]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "add-rpc-modal",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    height: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingTop: 4,
    paddingLeft: 4,
    paddingRight: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.FormTextField, {
    id: "rpcUrl",
    size: _componentLibrary.FormTextFieldSize.Lg,
    error: Boolean(error),
    label: t('rpcUrl'),
    placeholder: t('enterRpcUrl'),
    textFieldProps: {
      borderRadius: _designSystem.BorderRadius.LG
    },
    labelProps: {
      children: undefined,
      variant: _designSystem.TextVariant.bodyMdMedium
    },
    inputProps: {
      'data-testid': 'rpc-url-input-test'
    },
    onChange: e => setUrl(e.target.value),
    autoFocus: true
  }), error && /*#__PURE__*/_react.default.createElement(_componentLibrary.HelpText, {
    severity: _componentLibrary.HelpTextSeverity.Danger
  }, error), /*#__PURE__*/_react.default.createElement(_componentLibrary.FormTextField, {
    id: "rpcName",
    size: _componentLibrary.FormTextFieldSize.Lg,
    inputProps: {
      'data-testid': 'rpc-name-input-test'
    },
    placeholder: t('enterANameToIdentifyTheUrl'),
    paddingTop: 4,
    inputRef: nameRef,
    label: t('rpcNameOptional'),
    textFieldProps: {
      borderRadius: _designSystem.BorderRadius.LG
    },
    labelProps: {
      children: undefined,
      variant: _designSystem.TextVariant.bodyMdMedium
    }
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "add-rpc-modal__footer",
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    padding: 4,
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonPrimary, {
    width: _designSystem.BlockSize.Full,
    disabled: Boolean(error),
    size: _componentLibrary.ButtonPrimarySize.Lg
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    ,
    onClick: async () => {
      if (url && !error && nameRef.current) {
        onAdded(url, nameRef.current.value || undefined);
      }
    }
  }, t('addUrl'))));
};
var _default = exports.default = AddRpcUrlModal;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\network-list-menu\\add-rpc-url-modal\\add-rpc-url-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-menu\\index.js", {"./network-list-menu":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-menu\\network-list-menu.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnetwork-list-menu%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "NetworkListMenu", {
  enumerable: true,
  get: function () {
    return _networkListMenu.NetworkListMenu;
  }
});
var _networkListMenu = require("./network-list-menu");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\network-list-menu\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-menu\\network-confirmation-popover\\network-confirmation-popover.tsx", {"../../../../pages/confirmations/confirmation/confirmation":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\confirmation.js","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../ui/popover":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\popover\\index.js","@metamask/approval-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\approval-controller\\dist\\index.cjs","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnetwork-list-menu%5Cnetwork-confirmation-popover%5Cnetwork-confirmation-popover.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _controllerUtils = require("@metamask/controller-utils");
var _approvalController = require("@metamask/approval-controller");
var _popover = _interopRequireDefault(require("../../../ui/popover"));
var _confirmation = _interopRequireDefault(require("../../../../pages/confirmations/confirmation/confirmation"));
var _selectors = require("../../../../selectors");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NetworkConfirmationPopover = () => {
  const [showPopover, setShowPopover] = (0, _react.useState)(false);
  const unapprovedConfirmations = (0, _reactRedux.useSelector)(_selectors.getUnapprovedConfirmations);
  (0, _react.useEffect)(() => {
    const anAddNetworkConfirmationFromMetaMaskExists = unapprovedConfirmations === null || unapprovedConfirmations === void 0 ? void 0 : unapprovedConfirmations.find(confirmation => confirmation.origin === _approvalController.ORIGIN_METAMASK && confirmation.type === _controllerUtils.ApprovalType.AddEthereumChain);
    if (!showPopover && anAddNetworkConfirmationFromMetaMaskExists) {
      setShowPopover(true);
    } else if (showPopover && !anAddNetworkConfirmationFromMetaMaskExists) {
      setShowPopover(false);
    }
  }, [unapprovedConfirmations, showPopover]);
  if (!showPopover) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_popover.default, {
    "data-testid": "network-popover"
  }, /*#__PURE__*/_react.default.createElement(_confirmation.default, {
    redirectToHomeOnZeroConfirmations: false
  }));
};
var _default = exports.default = NetworkConfirmationPopover;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\network-list-menu\\network-confirmation-popover\\network-confirmation-popover.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-menu\\network-list-menu.tsx", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/multichain/networks":"D:\\code\\v\\metamask-extension\\shared\\constants\\multichain\\networks.ts","../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../../shared/modules/network.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\network.utils.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/window":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\window.ts","../../../hooks/accounts/useAccountCreationOnNetworkChange":"D:\\code\\v\\metamask-extension\\ui\\hooks\\accounts\\useAccountCreationOnNetworkChange.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../pages/settings/networks-tab/networks-form":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\networks-tab\\networks-form\\index.js","../../../pages/settings/networks-tab/networks-form/networks-form-state":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\networks-tab\\networks-form\\networks-form-state.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/toggle-button":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\toggle-button\\index.js","../network-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-item\\index.js","./add-block-explorer-modal/add-block-explorer-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-menu\\add-block-explorer-modal\\add-block-explorer-modal.tsx","./add-non-evm-account/add-non-evm-account":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-menu\\add-non-evm-account\\add-non-evm-account.tsx","./add-rpc-url-modal/add-rpc-url-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-menu\\add-rpc-url-modal\\add-rpc-url-modal.tsx","./network-list-search/network-list-search":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-menu\\network-list-search\\network-list-search.tsx","./popular-network-list/popular-network-list":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-menu\\popular-network-list\\popular-network-list.tsx","./select-rpc-url-modal/select-rpc-url-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-menu\\select-rpc-url-modal\\select-rpc-url-modal.tsx","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/multichain-network-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-network-controller\\dist\\index.cjs","@metamask/network-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\network-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","fuse.js":"D:\\code\\v\\metamask-extension\\node_modules\\fuse.js\\dist\\fuse.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-beautiful-dnd":"D:\\code\\v\\metamask-extension\\node_modules\\react-beautiful-dnd\\dist\\react-beautiful-dnd.cjs.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","uri-js":"D:\\code\\v\\metamask-extension\\node_modules\\uri-js\\dist\\es5\\uri.all.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnetwork-list-menu%5Cnetwork-list-menu.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkListMenu = exports.ACTION_MODE = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactBeautifulDnd = require("react-beautiful-dnd");
var _reactRedux = require("react-redux");
var _fuse = _interopRequireDefault(require("fuse.js"));
var URI = _interopRequireWildcard(require("uri-js"));
var _keyringApi = require("@metamask/keyring-api");
var _networkController = require("@metamask/network-controller");
var _multichainNetworkController = require("@metamask/multichain-network-controller");
var _utils = require("@metamask/utils");
var _controllerUtils = require("@metamask/controller-utils");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _useAccountCreationOnNetworkChange = require("../../../hooks/accounts/useAccountCreationOnNetworkChange");
var _networkListItem = require("../network-list-item");
var _actions = require("../../../store/actions");
var _network = require("../../../../shared/constants/network");
var _networks = require("../../../../shared/constants/multichain/networks");
var _selectors = require("../../../selectors");
var _toggleButton = _interopRequireDefault(require("../../ui/toggle-button"));
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../component-library");
var _metametrics = require("../../../contexts/metametrics");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _network2 = require("../../../../shared/modules/network.utils");
var _metamask = require("../../../ducks/metamask/metamask");
var _networksForm = _interopRequireDefault(require("../../../pages/settings/networks-tab/networks-form"));
var _networksFormState = require("../../../pages/settings/networks-tab/networks-form/networks-form-state");
var _window = require("../../../helpers/utils/window");
var _trace = require("../../../../shared/lib/trace");
var _popularNetworkList = _interopRequireDefault(require("./popular-network-list/popular-network-list"));
var _networkListSearch = _interopRequireDefault(require("./network-list-search/network-list-search"));
var _addRpcUrlModal = _interopRequireDefault(require("./add-rpc-url-modal/add-rpc-url-modal"));
var _selectRpcUrlModal = require("./select-rpc-url-modal/select-rpc-url-modal");
var _addBlockExplorerModal = _interopRequireDefault(require("./add-block-explorer-modal/add-block-explorer-modal"));
var _addNonEvmAccount = _interopRequireDefault(require("./add-non-evm-account/add-non-evm-account"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
let ACTION_MODE = exports.ACTION_MODE = /*#__PURE__*/function (ACTION_MODE) {
  ACTION_MODE[ACTION_MODE["LIST"] = 0] = "LIST";
  ACTION_MODE[ACTION_MODE["ADD_EDIT"] = 1] = "ADD_EDIT";
  ACTION_MODE[ACTION_MODE["ADD_RPC"] = 2] = "ADD_RPC";
  ACTION_MODE[ACTION_MODE["ADD_EXPLORER_URL"] = 3] = "ADD_EXPLORER_URL";
  ACTION_MODE[ACTION_MODE["SELECT_RPC"] = 4] = "SELECT_RPC";
  ACTION_MODE[ACTION_MODE["ADD_NON_EVM_ACCOUNT"] = 5] = "ADD_NON_EVM_ACCOUNT";
  return ACTION_MODE;
}({});
const NetworkListMenu = ({
  onClose
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const {
    hasAnyAccountsInNetwork
  } = (0, _useAccountCreationOnNetworkChange.useAccountCreationOnNetworkChange)();
  const {
    tokenNetworkFilter
  } = (0, _reactRedux.useSelector)(_selectors.getPreferences);
  const showTestnets = (0, _reactRedux.useSelector)(_selectors.getShowTestNetworks);
  const selectedTabOrigin = (0, _reactRedux.useSelector)(_selectors.getOriginOfCurrentTab);
  const isUnlocked = (0, _reactRedux.useSelector)(_metamask.getIsUnlocked);
  const domains = (0, _reactRedux.useSelector)(_selectors.getAllDomains);
  const orderedNetworksList = (0, _reactRedux.useSelector)(_selectors.getOrderedNetworksList);
  const isAddingNewNetwork = (0, _reactRedux.useSelector)(_selectors.getIsAddingNewNetwork);
  const isMultiRpcOnboarding = (0, _reactRedux.useSelector)(_selectors.getIsMultiRpcOnboarding);
  const isAccessedFromDappConnectedSitePopover = (0, _reactRedux.useSelector)(_selectors.getIsAccessedFromDappConnectedSitePopover);
  const completedOnboarding = (0, _reactRedux.useSelector)(_metamask.getCompletedOnboarding);
  // This selector provides the indication if the "Discover" button
  // is enabled based on the remote feature flag.
  const isNetworkDiscoverButtonEnabled = (0, _reactRedux.useSelector)(_selectors.getNetworkDiscoverButtonEnabled);
  // This selector provides an array with two elements.
  // 1 - All network configurations including EVM and non-EVM with the data type
  // MultichainNetworkConfiguration from @metamask/multichain-network-controller
  // 2 - All EVM network configurations with the data type NetworkConfiguration
  // from @metamask/network-controller. It includes necessary data like
  // the RPC endpoints that are not part of @metamask/multichain-network-controller.
  const [multichainNetworks, evmNetworks] = (0, _reactRedux.useSelector)(_selectors.getMultichainNetworkConfigurationsByChainId);
  const currentChainId = (0, _reactRedux.useSelector)(_selectors.getSelectedMultichainNetworkChainId);
  const {
    chainId: editingChainId,
    editCompleted
  } = (0, _reactRedux.useSelector)(_selectors.getEditedNetwork) ?? {};
  const permittedChainIds = (0, _reactRedux.useSelector)(state => (0, _selectors.getPermittedEVMChainsForSelectedTab)(state, selectedTabOrigin));
  const allChainIds = (0, _reactRedux.useSelector)(_selectors.getAllChainsToPoll);
  const canSelectNetwork = Boolean(selectedTabOrigin) && Boolean(domains[selectedTabOrigin]) && isAccessedFromDappConnectedSitePopover;
  (0, _react.useEffect)(() => {
    (0, _trace.endTrace)({
      name: _trace.TraceName.NetworkList
    });
  }, []);
  const currentlyOnTestnet = (0, _react.useMemo)(() => {
    const {
      namespace
    } = (0, _utils.parseCaipChainId)(currentChainId);
    if (namespace === _utils.KnownCaipNamespace.Eip155) {
      return _network.TEST_CHAINS.includes((0, _network2.convertCaipToHexChainId)(currentChainId));
    }
    return _multichainNetworkController.NON_EVM_TESTNET_IDS.includes(currentChainId);
  }, [currentChainId]);
  const [nonTestNetworks, testNetworks] = (0, _react.useMemo)(() => Object.entries(multichainNetworks).reduce(([nonTestnetsList, testnetsList], [id, network]) => {
    let chainId = id;
    let isTest = false;
    if (network.isEvm) {
      // We keep using raw chain ID for EVM.
      chainId = (0, _network2.convertCaipToHexChainId)(network.chainId);
      isTest = _network.TEST_CHAINS.includes(chainId);
    } else {
      isTest = _multichainNetworkController.NON_EVM_TESTNET_IDS.includes(network.chainId);
    }
    (isTest ? testnetsList : nonTestnetsList)[chainId] = network;
    return [nonTestnetsList, testnetsList];
  }, [{}, {}]), [multichainNetworks]);

  // The network currently being edited, or undefined
  // if the user is not currently editing a network.
  //
  // The memoized value is EVM specific, therefore we
  // provide the evmNetworks object as a dependency.
  const editedNetwork = (0, _react.useMemo)(() => {
    var _Object$entries$find;
    return !editingChainId || editCompleted ? undefined : (_Object$entries$find = Object.entries(evmNetworks).find(([chainId]) => chainId === editingChainId)) === null || _Object$entries$find === void 0 ? void 0 : _Object$entries$find[1];
  }, [editingChainId, editCompleted, evmNetworks]);

  // Tracks which page the user is on
  const [actionMode, setActionMode] = (0, _react.useState)(isAddingNewNetwork || editedNetwork ? ACTION_MODE.ADD_EDIT : ACTION_MODE.LIST);
  const networkFormState = (0, _networksFormState.useNetworkFormState)(editedNetwork);
  const {
    rpcUrls,
    setRpcUrls,
    blockExplorers,
    setBlockExplorers
  } = networkFormState;
  const [orderedNetworks, setOrderedNetworks] = (0, _react.useState)((0, _network2.sortNetworks)(nonTestNetworks, orderedNetworksList));
  (0, _react.useEffect)(() => setOrderedNetworks((0, _network2.sortNetworks)(nonTestNetworks, orderedNetworksList)), [nonTestNetworks, orderedNetworksList]);

  // Re-orders networks when the user drag + drops them
  const onDragEnd = result => {
    if (result.destination) {
      const newOrderedNetworks = [...orderedNetworks];
      const [removed] = newOrderedNetworks.splice(result.source.index, 1);
      newOrderedNetworks.splice(result.destination.index, 0, removed);
      dispatch((0, _actions.updateNetworksList)(newOrderedNetworks.map(n => n.chainId)));
      setOrderedNetworks(newOrderedNetworks);
    }
  };
  const featuredNetworksNotYetEnabled = (0, _react.useMemo)(() => _network.FEATURED_RPCS.filter(({
    chainId
  }) => !evmNetworks[chainId]).sort((a, b) => a.name.localeCompare(b.name)), [evmNetworks]);

  // This value needs to be tracked in case the user changes to a Non EVM
  // network and there is no account created for that network. This will
  // allow the user to add an account for that network.
  const [selectedNonEvmNetwork, setSelectedNonEvmNetwork] = (0, _react.useState)();

  // Searches networks by user input
  const [searchQuery, setSearchQuery] = (0, _react.useState)('');
  const [focusSearch, setFocusSearch] = (0, _react.useState)(false);

  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
  // eslint-disable-next-line @typescript-eslint/naming-convention
  const searchNetworks = (networks, query) => searchQuery === '' ? networks : new _fuse.default(networks, {
    threshold: 0.2,
    location: 0,
    distance: 100,
    maxPatternLength: 32,
    minMatchCharLength: 1,
    shouldSort: false,
    // Maintain network order instead of ordering by search score
    keys: ['name', 'chainId', 'nativeCrrency']
  }).search(query);
  const searchedEnabledNetworks = searchNetworks(orderedNetworks, searchQuery);
  const searchedFeaturedNetworks = searchNetworks(featuredNetworksNotYetEnabled, searchQuery);
  const searchedTestNetworks = searchNetworks(Object.values(testNetworks), searchQuery);
  // A sorted list of test networks that put Sepolia first then Linea Sepolia at the top
  // and the rest of the test networks in alphabetical order.
  const sortedTestNetworks = (0, _react.useMemo)(() => {
    return (0, _network2.sortNetworksByPrioity)(searchedTestNetworks, [(0, _multichainNetworkController.toEvmCaipChainId)(_controllerUtils.ChainId.sepolia), (0, _multichainNetworkController.toEvmCaipChainId)(_controllerUtils.ChainId['linea-sepolia'])]);
  }, [searchedTestNetworks]);
  const getMultichainNetworkConfigurationOrThrow = chainId => {
    const network = multichainNetworks[chainId];
    if (!network) {
      throw new Error(`Network configuration not found for chainId: ${chainId}`);
    }
    return network;
  };
  const handleEvmNetworkChange = async (chainId, networkClientId) => {
    try {
      const hexChainId = (0, _network2.convertCaipToHexChainId)(chainId);
      const {
        defaultRpcEndpoint
      } = (0, _network2.getRpcDataByChainId)(chainId, evmNetworks);
      const finalNetworkClientId = networkClientId ?? defaultRpcEndpoint.networkClientId;
      if (isAccessedFromDappConnectedSitePopover && selectedTabOrigin) {
        const isNetworkPermitted = permittedChainIds.includes(hexChainId);
        if (!isNetworkPermitted) {
          await dispatch((0, _actions.addPermittedChain)(selectedTabOrigin, chainId));
          dispatch((0, _actions.showPermittedNetworkToast)());
        }
        dispatch((0, _actions.setNetworkClientIdForDomain)(selectedTabOrigin, finalNetworkClientId));
      }
      dispatch((0, _actions.setActiveNetwork)(finalNetworkClientId));
      dispatch((0, _actions.updateCustomNonce)(''));
      dispatch((0, _actions.setNextNonce)(''));
      dispatch((0, _actions.detectNfts)(allChainIds));
      if (Object.keys(tokenNetworkFilter || {}).length <= 1) {
        dispatch((0, _actions.setTokenNetworkFilter)({
          [hexChainId]: true
        }));
      } else {
        const allOpts = Object.keys(evmNetworks).reduce((acc, id) => {
          acc[id] = true;
          return acc;
        }, {});
        dispatch((0, _actions.setTokenNetworkFilter)(allOpts));
      }
      dispatch((0, _actions.setEnabledNetworks)(hexChainId));
    } finally {
      dispatch((0, _actions.toggleNetworkMenu)());
    }
  };
  const handleNonEvmNetworkChange = async chainId => {
    if (hasAnyAccountsInNetwork(chainId)) {
      dispatch((0, _actions.toggleNetworkMenu)());
      dispatch((0, _actions.setActiveNetwork)(chainId));
      dispatch((0, _actions.setEnabledNetworks)(chainId));
      return;
    }
    setSelectedNonEvmNetwork(chainId);
    setActionMode(ACTION_MODE.ADD_NON_EVM_ACCOUNT);
  };
  const handleNetworkChange = async chainId => {
    const currentChain = getMultichainNetworkConfigurationOrThrow(currentChainId);
    const chain = getMultichainNetworkConfigurationOrThrow(chainId);
    if (chain.isEvm) {
      await handleEvmNetworkChange(chainId);
    } else {
      await handleNonEvmNetworkChange(chainId);
    }
    const chainIdToTrack = chain.isEvm ? (0, _network2.convertCaipToHexChainId)(chainId) : chainId;
    const currentChainIdToTrack = currentChain.isEvm ? (0, _network2.convertCaipToHexChainId)(currentChainId) : currentChainId;
    trackEvent({
      event: _metametrics2.MetaMetricsEventName.NavNetworkSwitched,
      category: _metametrics2.MetaMetricsEventCategory.Network,
      properties: {
        location: 'Network Menu',
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        chain_id: currentChainIdToTrack,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        from_network: currentChainIdToTrack,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        to_network: chainIdToTrack
      }
    });
  };
  const isDiscoverBtnEnabled = (0, _react.useCallback)(chainId => {
    // The "Discover" button should be enabled when the mapping for the chainId is enabled in the feature flag json
    // and in the constants `CHAIN_ID_PORTFOLIO_LANDING_PAGE_URL_MAP`.
    return Boolean(isNetworkDiscoverButtonEnabled === null || isNetworkDiscoverButtonEnabled === void 0 ? void 0 : isNetworkDiscoverButtonEnabled[chainId]) && _network.CHAIN_ID_PORTFOLIO_LANDING_PAGE_URL_MAP[chainId] !== undefined;
  }, [isNetworkDiscoverButtonEnabled]);
  const hasMultiRpcOptions = (0, _react.useCallback)(network => network.isEvm && (0, _network2.getRpcDataByChainId)(network.chainId, evmNetworks).rpcEndpoints.length > 1, [evmNetworks]);
  const isNetworkEnabled = (0, _react.useCallback)(network => {
    return network.isEvm || isUnlocked && completedOnboarding || hasAnyAccountsInNetwork(network.chainId);
  }, [isUnlocked, completedOnboarding, hasAnyAccountsInNetwork]);
  const getItemCallbacks = (0, _react.useCallback)(network => {
    const {
      chainId,
      isEvm
    } = network;
    if (!isEvm) {
      return {
        onDiscoverClick: isDiscoverBtnEnabled(chainId) ? () => {
          (0, _window.openWindow)(_network.CHAIN_ID_PORTFOLIO_LANDING_PAGE_URL_MAP[chainId], '_blank');
        } : undefined
      };
    }

    // Non-EVM networks cannot be deleted, edited or have
    // RPC endpoints so it's safe to call this conversion function here.
    const hexChainId = (0, _network2.convertCaipToHexChainId)(chainId);
    const isDeletable = isUnlocked && network.chainId !== currentChainId && network.chainId !== _keyringApi.EthScope.Mainnet;
    return {
      onDelete: isDeletable ? () => {
        dispatch((0, _actions.toggleNetworkMenu)());
        dispatch((0, _actions.showModal)({
          name: 'CONFIRM_DELETE_NETWORK',
          target: hexChainId,
          onConfirm: () => undefined
        }));
      } : undefined,
      onEdit: () => {
        dispatch((0, _actions.setEditedNetwork)({
          chainId: hexChainId,
          nickname: network.name
        }));
        setActionMode(ACTION_MODE.ADD_EDIT);
      },
      onDiscoverClick: isDiscoverBtnEnabled(hexChainId) ? () => {
        (0, _window.openWindow)(_network.CHAIN_ID_PORTFOLIO_LANDING_PAGE_URL_MAP[hexChainId], '_blank');
      } : undefined,
      onRpcConfigEdit: hasMultiRpcOptions(network) ? () => {
        setActionMode(ACTION_MODE.SELECT_RPC);
        dispatch((0, _actions.setEditedNetwork)({
          chainId: hexChainId
        }));
      } : undefined,
      onRpcSelect: () => {
        setActionMode(ACTION_MODE.SELECT_RPC);
        dispatch((0, _actions.setEditedNetwork)({
          chainId: hexChainId
        }));
      }
    };
  }, [currentChainId, dispatch, hasMultiRpcOptions, isUnlocked, isDiscoverBtnEnabled]);

  // Renders a network in the network list
  const generateMultichainNetworkListItem = network => {
    const isCurrentNetwork = network.chainId === currentChainId;
    const {
      onDelete,
      onEdit,
      onDiscoverClick,
      onRpcSelect
    } = getItemCallbacks(network);
    const iconSrc = (0, _network2.getNetworkIcon)(network);
    return /*#__PURE__*/_react.default.createElement(_networkListItem.NetworkListItem, {
      key: network.chainId,
      chainId: network.chainId,
      name: network.name,
      iconSrc: iconSrc,
      iconSize: _componentLibrary.AvatarNetworkSize.Sm,
      selected: canSelectNetwork && isCurrentNetwork && !focusSearch,
      focus: canSelectNetwork && isCurrentNetwork && !focusSearch,
      rpcEndpoint: hasMultiRpcOptions(network) ? (0, _network2.getRpcDataByChainId)(network.chainId, evmNetworks).defaultRpcEndpoint : undefined
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
      // eslint-disable-next-line @typescript-eslint/no-misused-promises
      ,
      onClick: async () => {
        if (canSelectNetwork) {
          await handleNetworkChange(network.chainId);
        }
      },
      onDeleteClick: onDelete,
      onEditClick: onEdit,
      onDiscoverClick: onDiscoverClick,
      onRpcEndpointClick: onRpcSelect,
      disabled: !isNetworkEnabled(network),
      notSelectable: !canSelectNetwork
    });
  };
  const render = () => {
    if (actionMode === ACTION_MODE.LIST) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        className: "multichain-network-list-menu"
      }, /*#__PURE__*/_react.default.createElement(_networkListSearch.default, {
        searchQuery: searchQuery,
        setSearchQuery: setSearchQuery,
        setFocusSearch: setFocusSearch
      }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, searchedEnabledNetworks.length > 0 && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        padding: 4,
        display: _designSystem.Display.Flex,
        justifyContent: _designSystem.JustifyContent.spaceBetween
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        color: _designSystem.TextColor.textAlternative
      }, t('enabledNetworks'))), searchedEnabledNetworks.length === 0 && searchedFeaturedNetworks.length === 0 && searchedTestNetworks.length === 0 && focusSearch ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        paddingLeft: 4,
        paddingRight: 4,
        color: _designSystem.TextColor.textMuted,
        "data-testid": "multichain-network-menu-popover-no-results"
      }, t('noNetworksFound')) : /*#__PURE__*/_react.default.createElement(_reactBeautifulDnd.DragDropContext, {
        onDragEnd: onDragEnd
      }, /*#__PURE__*/_react.default.createElement(_reactBeautifulDnd.Droppable, {
        droppableId: "characters"
      }, provided => /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, _extends({
        className: "characters"
      }, provided.droppableProps, {
        ref: provided.innerRef
      }), searchedEnabledNetworks.map((network, index) => {
        return /*#__PURE__*/_react.default.createElement(_reactBeautifulDnd.Draggable, {
          key: network.chainId,
          draggableId: network.chainId,
          index: index
        }, providedDrag => /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, _extends({
          ref: providedDrag.innerRef
        }, providedDrag.draggableProps, providedDrag.dragHandleProps), generateMultichainNetworkListItem(network)));
      }), provided.placeholder))), /*#__PURE__*/_react.default.createElement(_popularNetworkList.default, {
        searchAddNetworkResults: searchedFeaturedNetworks,
        "data-testid": "add-popular-network-view"
      }), searchedTestNetworks.length > 0 ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        paddingBottom: 4,
        paddingTop: 4,
        paddingLeft: 4,
        display: _designSystem.Display.Flex,
        justifyContent: _designSystem.JustifyContent.spaceBetween
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        color: _designSystem.TextColor.textAlternative
      }, t('showTestnetNetworks')), /*#__PURE__*/_react.default.createElement(_toggleButton.default, {
        value: showTestnets || currentlyOnTestnet,
        disabled: currentlyOnTestnet,
        onToggle: value => {
          dispatch((0, _actions.setShowTestNetworks)(!value));
          if (!value) {
            trackEvent({
              event: _metametrics2.MetaMetricsEventName.TestNetworksDisplayed,
              category: _metametrics2.MetaMetricsEventCategory.Network
            });
          }
        }
      })) : null, showTestnets || currentlyOnTestnet ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        className: "multichain-network-list-menu"
      }, sortedTestNetworks.map(network => generateMultichainNetworkListItem(network))) : null)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        padding: 4
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonSecondary, {
        size: _componentLibrary.ButtonSecondarySize.Lg,
        startIconName: _componentLibrary.IconName.Add,
        startIconProps: {
          marginRight: 2
        },
        block: true,
        onClick: () => {
          trackEvent({
            event: _metametrics2.MetaMetricsEventName.AddNetworkButtonClick,
            category: _metametrics2.MetaMetricsEventCategory.Network
          });
          setActionMode(ACTION_MODE.ADD_EDIT);
        }
      }, t('addACustomNetwork'))));
    } else if (actionMode === ACTION_MODE.ADD_EDIT) {
      return /*#__PURE__*/_react.default.createElement(_networksForm.default, {
        networkFormState: networkFormState,
        existingNetwork: editedNetwork,
        onRpcAdd: () => setActionMode(ACTION_MODE.ADD_RPC),
        onBlockExplorerAdd: () => setActionMode(ACTION_MODE.ADD_EXPLORER_URL)
      });
    } else if (actionMode === ACTION_MODE.ADD_RPC) {
      return /*#__PURE__*/_react.default.createElement(_addRpcUrlModal.default, {
        onAdded: (url, name) => {
          var _rpcUrls$rpcEndpoints;
          // Note: We could choose to rename the URL if it already exists with a different name
          if ((_rpcUrls$rpcEndpoints = rpcUrls.rpcEndpoints) !== null && _rpcUrls$rpcEndpoints !== void 0 && _rpcUrls$rpcEndpoints.every(e => !URI.equal(e.url, url))) {
            setRpcUrls({
              rpcEndpoints: [...rpcUrls.rpcEndpoints, {
                url,
                name,
                type: _networkController.RpcEndpointType.Custom
              }],
              defaultRpcEndpointIndex: rpcUrls.rpcEndpoints.length
            });
          }
          setActionMode(ACTION_MODE.ADD_EDIT);
        }
      });
    } else if (actionMode === ACTION_MODE.ADD_EXPLORER_URL) {
      return /*#__PURE__*/_react.default.createElement(_addBlockExplorerModal.default, {
        onAdded: url => {
          var _blockExplorers$block;
          if ((_blockExplorers$block = blockExplorers.blockExplorerUrls) !== null && _blockExplorers$block !== void 0 && _blockExplorers$block.every(u => u !== url)) {
            setBlockExplorers({
              blockExplorerUrls: [...blockExplorers.blockExplorerUrls, url],
              defaultBlockExplorerUrlIndex: blockExplorers.blockExplorerUrls.length
            });
          }
          setActionMode(ACTION_MODE.ADD_EDIT);
        }
      });
    } else if (actionMode === ACTION_MODE.SELECT_RPC && editedNetwork) {
      return /*#__PURE__*/_react.default.createElement(_selectRpcUrlModal.SelectRpcUrlModal, {
        networkConfiguration: evmNetworks[editedNetwork.chainId],
        onNetworkChange: handleEvmNetworkChange
      });
    } else if (actionMode === ACTION_MODE.ADD_NON_EVM_ACCOUNT && selectedNonEvmNetwork) {
      return /*#__PURE__*/_react.default.createElement(_addNonEvmAccount.default, {
        chainId: selectedNonEvmNetwork
      });
    }
    return null; // Should not be reachable
  };
  let title;
  if (actionMode === ACTION_MODE.LIST) {
    title = t('manageNetworksMenuHeading');
  } else if (actionMode === ACTION_MODE.ADD_EDIT && !editedNetwork) {
    title = t('addACustomNetwork');
  } else if (actionMode === ACTION_MODE.ADD_RPC) {
    title = t('addRpcUrl');
  } else if (actionMode === ACTION_MODE.ADD_EXPLORER_URL) {
    title = t('addBlockExplorerUrl');
  } else if (actionMode === ACTION_MODE.SELECT_RPC) {
    title = t('selectRpcUrl');
  } else if (actionMode === ACTION_MODE.ADD_NON_EVM_ACCOUNT && selectedNonEvmNetwork) {
    title = t('addNonEvmAccount', [_networks.MULTICHAIN_NETWORK_TO_ACCOUNT_TYPE_NAME[selectedNonEvmNetwork]]);
  } else {
    title = (editedNetwork === null || editedNetwork === void 0 ? void 0 : editedNetwork.name) ?? '';
  }
  let onBack;
  if (actionMode === ACTION_MODE.ADD_EDIT) {
    onBack = () => {
      editedNetwork ? dispatch((0, _actions.setEditedNetwork)()) : networkFormState.clear();
      setActionMode(ACTION_MODE.LIST);
    };
  } else if (actionMode === ACTION_MODE.ADD_RPC || actionMode === ACTION_MODE.ADD_EXPLORER_URL) {
    onBack = () => setActionMode(ACTION_MODE.ADD_EDIT);
  } else if (actionMode === ACTION_MODE.ADD_NON_EVM_ACCOUNT) {
    onBack = () => setActionMode(ACTION_MODE.LIST);
  }
  if (isMultiRpcOnboarding) {
    onBack = onClose;
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: true,
    onClose: onClose
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, {
    padding: 0,
    className: "multichain-network-list-menu-content-wrapper",
    modalDialogProps: {
      className: 'multichain-network-list-menu-content-wrapper__dialog',
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      paddingTop: 0,
      paddingBottom: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    paddingTop: 4,
    paddingRight: 4,
    paddingBottom: actionMode === ACTION_MODE.SELECT_RPC ? 0 : 4,
    onClose: onClose,
    onBack: onBack
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    ellipsis: true,
    variant: _designSystem.TextVariant.headingSm,
    textAlign: _designSystem.TextAlign.Center
  }, title)), render()));
};
exports.NetworkListMenu = NetworkListMenu;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\network-list-menu\\network-list-menu.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-menu\\network-list-search\\network-list-search.tsx", {"../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnetwork-list-menu%5Cnetwork-list-search%5Cnetwork-list-search.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _componentLibrary = require("../../../component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const NetworkListSearch = ({
  searchQuery,
  setSearchQuery,
  setFocusSearch
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingLeft: 4,
    paddingRight: 4,
    paddingBottom: 2,
    paddingTop: 0
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.TextFieldSearch, {
    size: _componentLibrary.TextFieldSearchSize.Lg,
    width: _designSystem.BlockSize.Full,
    placeholder: t('search'),
    autoFocus: true,
    value: searchQuery,
    onFocus: () => setFocusSearch(true),
    onBlur: () => setFocusSearch(false),
    onChange: e => setSearchQuery(e.target.value),
    clearButtonOnClick: () => setSearchQuery(''),
    clearButtonProps: {
      size: _componentLibrary.ButtonIconSize.Sm
    },
    inputProps: {
      'data-testid': 'network-redesign-modal-search-input'
    },
    borderRadius: _designSystem.BorderRadius.MD,
    "data-testid": "search-list"
  }));
};
var _default = exports.default = NetworkListSearch;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\network-list-menu\\network-list-search\\network-list-search.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-menu\\popular-network-list\\popular-network-list.tsx", {"../../../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/constants/zendesk-url":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\zendesk-url.js","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnetwork-list-menu%5Cpopular-network-list%5Cpopular-network-list.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _componentLibrary = require("../../../component-library");
var _app = require("../../../../../shared/constants/app");
var _actions = require("../../../../store/actions");
var _util = require("../../../../../app/scripts/lib/util");
var _designSystem = require("../../../../helpers/constants/design-system");
var _network = require("../../../../../shared/constants/network");
var _zendeskUrl = _interopRequireDefault(require("../../../../helpers/constants/zendesk-url"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

const PopularNetworkList = ({
  searchAddNetworkResults
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const isPopUp = (0, _util.getEnvironmentType)() === _app.ENVIRONMENT_TYPE_POPUP;
  const dispatch = (0, _reactRedux.useDispatch)();
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const handleMouseEnter = () => {
    setIsOpen(true);
  };
  const handleMouseLeave = () => {
    setIsOpen(false);
  };
  const [referenceElement, setReferenceElement] = (0, _react.useState)();

  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  const setBoxRef = ref => {
    setReferenceElement(ref);
  };

  // Memoize the popover content so it only updates when searchAddNetworkResults changes
  const popoverContent = (0, _react.useMemo)(() => {
    if (Object.keys(searchAddNetworkResults).length === 0) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      marginTop: 4,
      marginBottom: 4,
      display: _designSystem.Display.Flex,
      justifyContent: _designSystem.JustifyContent.spaceBetween
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.InlineFlex
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      color: _designSystem.TextColor.textAlternative,
      variant: _designSystem.TextVariant.bodyMd
    }, t('additionalNetworks')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      onMouseEnter: handleMouseEnter,
      marginTop: 1
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
      className: "add-network__warning-icon",
      name: _componentLibrary.IconName.Info,
      color: _designSystem.IconColor.iconMuted,
      size: _componentLibrary.IconSize.Sm,
      marginLeft: 2
    }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Popover, {
      referenceElement: referenceElement,
      position: _componentLibrary.PopoverPosition.TopStart,
      paddingTop: 3,
      paddingBottom: 3,
      offset: [16, 12],
      isOpen: isOpen,
      flip: true,
      backgroundColor: _designSystem.BackgroundColor.backgroundSection,
      onMouseLeave: handleMouseLeave,
      style: {
        width: '326px'
      }
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMd
    }, ' ', t('popularNetworkAddToolTip'), ' '), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      key: "learn-more-link"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
      size: _componentLibrary.ButtonLinkSize.Auto,
      externalLink: true,
      onClick: () => {
        global.platform.openTab({
          url: _zendeskUrl.default.UNKNOWN_NETWORK
        });
      }
    }, t('learnMoreUpperCase')))))));
  }, [searchAddNetworkResults, referenceElement, isOpen, t]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "new-network-list__networks-container"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginTop: isPopUp ? 0 : 4,
    marginBottom: 1,
    paddingLeft: 4,
    paddingRight: 4,
    ref: setBoxRef
  }, popoverContent, searchAddNetworkResults.map(network => /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    key: network.chainId,
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    paddingBottom: 4,
    paddingTop: 4,
    className: "new-network-list__list-of-networks",
    "data-testid": `popular-network-${network.chainId}`,
    onMouseEnter: handleMouseLeave
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
    borderColor: _designSystem.BorderColor.backgroundDefault,
    size: _componentLibrary.AvatarNetworkSize.Sm,
    src: _network.CHAIN_ID_TO_NETWORK_IMAGE_URL_MAP[network.chainId],
    name: network.name
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginLeft: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textDefault,
    backgroundColor: _designSystem.BackgroundColor.transparent,
    ellipsis: true
  }, network.name))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    marginLeft: 1
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    type: _componentLibrary.ButtonVariant.Link,
    className: "add-network__add-button",
    variant: _componentLibrary.ButtonVariant.Link,
    "data-testid": "test-add-button"
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    ,
    onClick: async () => {
      dispatch((0, _actions.toggleNetworkMenu)());

      // First add the network to user's configuration
      await dispatch((0, _actions.addNetwork)(network));

      // Then enable it in the network list
      await dispatch((0, _actions.setEnabledNetworks)(network.chainId));
    }
  }, t('add')))))));
};
var _default = exports.default = PopularNetworkList;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\network-list-menu\\popular-network-list\\popular-network-list.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-menu\\rpc-list-item.tsx", {"../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","@metamask/network-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\network-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnetwork-list-menu%5Crpc-list-item.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stripProtocol = exports.stripKeyFromInfuraUrl = exports.default = void 0;
var _networkController = require("@metamask/network-controller");
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _network = require("../../../../shared/constants/network");
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _selectors = require("../../../selectors");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const stripKeyFromInfuraUrl = endpoint => {
  let modifiedEndpoint = endpoint;
  if (modifiedEndpoint.endsWith('/v3/{infuraProjectId}')) {
    modifiedEndpoint = modifiedEndpoint.replace('/v3/{infuraProjectId}', '');
  } else if (modifiedEndpoint.endsWith(`/v3/${_network.infuraProjectId}`)) {
    modifiedEndpoint = modifiedEndpoint.replace(`/v3/${_network.infuraProjectId}`, '');
  }
  return modifiedEndpoint;
};
exports.stripKeyFromInfuraUrl = stripKeyFromInfuraUrl;
const stripProtocol = endpoint => {
  const url = new URL(endpoint);
  return `${url.host}${url.pathname === '/' ? '' : url.pathname}`;
};

// This components represents an RPC endpoint in a list,
// currently when selecting or editing endpoints for a network.
exports.stripProtocol = stripProtocol;
const RpcListItem = ({
  rpcEndpoint
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const isRpcFailoverEnabled = (0, _reactRedux.useSelector)(_selectors.getIsRpcFailoverEnabled);
  const {
    url,
    type
  } = rpcEndpoint;
  const name = type === _networkController.RpcEndpointType.Infura ? 'Infura' : rpcEndpoint.name;
  const displayEndpoint = endpoint => endpoint ? stripProtocol(stripKeyFromInfuraUrl(endpoint)) : '\u00A0';
  const padding = name ? 2 : 4;
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, _extends({
    className: "rpc-list-item",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    paddingTop: padding,
    paddingBottom: padding
  }, !name && {
    borderWidth: 2,
    borderStyle: _designSystem.BorderStyle.solid,
    borderColor: _designSystem.BorderColor.transparent
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "button",
    padding: 0,
    width: _designSystem.BlockSize.Full,
    color: name ? _designSystem.TextColor.textDefault : _designSystem.TextColor.textAlternative,
    variant: name ? _designSystem.TextVariant.bodyMdMedium : _designSystem.TextVariant.bodySm,
    backgroundColor: _designSystem.BackgroundColor.transparent,
    ellipsis: true,
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    gap: 1
  }, name || displayEndpoint(url), isRpcFailoverEnabled && rpcEndpoint.failoverUrls && rpcEndpoint.failoverUrls.length > 0 ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Tag, {
    label: t('failover'),
    display: _designSystem.Display.Inline
  }) : null)), name && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textAlternative,
    variant: _designSystem.TextVariant.bodySm,
    ellipsis: true
  }, displayEndpoint(url))));
};
var _default = exports.default = RpcListItem;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\network-list-menu\\rpc-list-item.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-menu\\select-rpc-url-modal\\select-rpc-url-modal.tsx", {"../../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../rpc-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-menu\\rpc-list-item.tsx","@metamask/multichain-network-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-network-controller\\dist\\index.cjs","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnetwork-list-menu%5Cselect-rpc-url-modal%5Cselect-rpc-url-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.SelectRpcUrlModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _multichainNetworkController = require("@metamask/multichain-network-controller");
var _classnames = _interopRequireDefault(require("classnames"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _componentLibrary = require("../../../component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _network = require("../../../../../shared/constants/network");
var _actions = require("../../../../store/actions");
var _rpcListItem = _interopRequireDefault(require("../rpc-list-item"));
var _selectors = require("../../../../selectors");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const SelectRpcUrlModal = ({
  networkConfiguration,
  onNetworkChange
}) => {
  var _location$state;
  const dispatch = (0, _reactRedux.useDispatch)();
  const location = (0, _reactRouterDom.useLocation)();
  const chainId = (_location$state = location.state) === null || _location$state === void 0 ? void 0 : _location$state.chainId;
  const [, evmNetworks] = (0, _reactRedux.useSelector)(_selectors.getMultichainNetworkConfigurationsByChainId);
  const networkConfigurationToUse = networkConfiguration ?? evmNetworks[chainId];

  // Handle case where both networkConfiguration and chainId are undefined
  if (!networkConfigurationToUse) {
    return null;
  }
  const image = _network.CHAIN_ID_TO_NETWORK_IMAGE_URL_MAP[networkConfigurationToUse.chainId];
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    margin: "auto",
    paddingTop: 1,
    paddingBottom: 8,
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center
  }, image && /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
    src: image,
    name: networkConfigurationToUse.name,
    size: _componentLibrary.AvatarNetworkSize.Sm,
    marginRight: 1
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative
  }, networkConfigurationToUse.name))), networkConfigurationToUse.rpcEndpoints.map((rpcEndpoint, index) => /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    alignItems: _designSystem.AlignItems.center,
    paddingLeft: 4,
    paddingRight: 4,
    display: _designSystem.Display.Flex,
    key: rpcEndpoint.url,
    onClick: () => {
      const network = {
        ...networkConfigurationToUse,
        defaultRpcEndpointIndex: index
      };
      dispatch((0, _actions.updateNetwork)(network));
      dispatch((0, _actions.setEditedNetwork)());
      onNetworkChange((0, _multichainNetworkController.toEvmCaipChainId)(network.chainId), rpcEndpoint.networkClientId);
    },
    className: (0, _classnames.default)('select-rpc-url__item', {
      'select-rpc-url__item--selected': index === networkConfigurationToUse.defaultRpcEndpointIndex
    })
  }, index === networkConfigurationToUse.defaultRpcEndpointIndex && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "select-rpc-url__item-selected-pill",
    borderRadius: _designSystem.BorderRadius.pill,
    backgroundColor: _designSystem.BackgroundColor.primaryDefault
  }), /*#__PURE__*/_react.default.createElement(_rpcListItem.default, {
    rpcEndpoint: rpcEndpoint
  }))));
};
exports.SelectRpcUrlModal = SelectRpcUrlModal;
var _default = exports.default = SelectRpcUrlModal;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\network-list-menu\\select-rpc-url-modal\\select-rpc-url-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-manager\\components\\add-network\\AddNetwork.tsx", {"../../../../../pages/settings/networks-tab/networks-form/networks-form":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\networks-tab\\networks-form\\networks-form.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnetwork-manager%5Ccomponents%5Cadd-network%5CAddNetwork.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddNetwork = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _networksForm = require("../../../../../pages/settings/networks-tab/networks-form/networks-form");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const AddNetwork = ({
  networkFormState,
  network,
  isEdit = false
}) => {
  const history = (0, _reactRouterDom.useHistory)();
  return /*#__PURE__*/_react.default.createElement(_networksForm.NetworksForm, {
    toggleNetworkMenuAfterSubmit: false,
    onComplete: () => {
      console.log(`onComplete pushing to /?tab=custom-networks`);
      history.push('/?tab=custom-networks');
    },
    onEdit: () => {
      history.push('/edit');
    },
    networkFormState: networkFormState,
    existingNetwork: network,
    onRpcAdd: () => {
      history.push(isEdit ? '/edit-rpc' : '/add-rpc');
    },
    onBlockExplorerAdd: () => {
      history.push(isEdit ? '/edit-explorer-url' : '/add-explorer-url');
    }
  });
};
exports.AddNetwork = AddNetwork;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\network-manager\\components\\add-network\\AddNetwork.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-manager\\components\\add-network\\index.ts", {"./AddNetwork":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-manager\\components\\add-network\\AddNetwork.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnetwork-manager%5Ccomponents%5Cadd-network%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _AddNetwork = require("./AddNetwork");
Object.keys(_AddNetwork).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _AddNetwork[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _AddNetwork[key];
    }
  });
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\network-manager\\components\\add-network\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-manager\\components\\additional-networks-info\\additional-networks-info.tsx", {"../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../helpers/constants/zendesk-url":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\zendesk-url.js","../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../component-library/box":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\box\\index.ts","../../../../component-library/icon":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\icon\\index.ts","../../../../component-library/text":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\text\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnetwork-manager%5Ccomponents%5Cadditional-networks-info%5Cadditional-networks-info.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdditionalNetworksInfo = void 0;
var _react = _interopRequireWildcard(require("react"));
var _designSystem = require("../../../../../helpers/constants/design-system");
var _zendeskUrl = _interopRequireDefault(require("../../../../../helpers/constants/zendesk-url"));
var _useI18nContext = require("../../../../../hooks/useI18nContext");
var _componentLibrary = require("../../../../component-library");
var _box = require("../../../../component-library/box");
var _icon = require("../../../../component-library/icon");
var _text = require("../../../../component-library/text");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * AdditionalNetworksInfo Component
 *
 * Displays information about additional networks in the network manager with
 * an info tooltip that appears on hover to provide more context to the user.
 */
const AdditionalNetworksInfo = exports.AdditionalNetworksInfo = /*#__PURE__*/(0, _react.memo)(() => {
  const t = (0, _useI18nContext.useI18nContext)();
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  // State and ref for positioning the popover relative to its trigger
  const [referenceElement, setReferenceElement] = (0, _react.useState)(null);

  // Handler for mouse enter - shows the popover
  const handleMouseEnter = (0, _react.useCallback)(() => {
    setIsOpen(true);
  }, []);

  // Handler for mouse leave - hides the popover
  const handleMouseLeave = (0, _react.useCallback)(() => {
    setIsOpen(false);
  }, []);
  const setBoxRef = (0, _react.useCallback)(ref => {
    setReferenceElement(ref);
  }, []);

  // Handler for "Learn More" button click - opens external documentation
  const handleLearnMoreClick = (0, _react.useCallback)(() => {
    global.platform.openTab({
      url: _zendeskUrl.default.UNKNOWN_NETWORK
    });
  }, []);
  return /*#__PURE__*/_react.default.createElement(_box.Box, {
    paddingTop: 2,
    paddingRight: 4,
    paddingLeft: 4,
    onMouseLeave: handleMouseLeave
  }, /*#__PURE__*/_react.default.createElement(_box.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, /*#__PURE__*/_react.default.createElement(_box.Box, {
    display: _designSystem.Display.InlineFlex,
    ref: setBoxRef
  }, /*#__PURE__*/_react.default.createElement(_text.Text, {
    color: _designSystem.TextColor.textAlternative,
    variant: _designSystem.TextVariant.bodyMdMedium
  }, t('additionalNetworks')), /*#__PURE__*/_react.default.createElement(_box.Box, {
    marginTop: 1
  }, /*#__PURE__*/_react.default.createElement(_icon.Icon, {
    onMouseEnter: handleMouseEnter,
    className: "add-network__warning-icon",
    name: _componentLibrary.IconName.Info,
    color: _designSystem.IconColor.iconMuted,
    size: _componentLibrary.IconSize.Sm,
    marginLeft: 2
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Popover, {
    referenceElement: referenceElement,
    position: _componentLibrary.PopoverPosition.TopStart,
    paddingTop: 3,
    paddingBottom: 3,
    offset: [16, 12],
    isOpen: isOpen,
    flip: true,
    backgroundColor: _designSystem.BackgroundColor.backgroundSection,
    onMouseLeave: handleMouseLeave,
    style: {
      zIndex: 1000,
      width: '326px' // Fixed width for the popover
    }
  }, /*#__PURE__*/_react.default.createElement(_text.Text, {
    variant: _designSystem.TextVariant.bodyMd
  }, t('popularNetworkAddToolTip')), /*#__PURE__*/_react.default.createElement(_box.Box, {
    key: "learn-more-link"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    size: _componentLibrary.ButtonLinkSize.Auto,
    externalLink: true,
    onClick: handleLearnMoreClick
  }, t('learnMoreUpperCase'))))))));
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\network-manager\\components\\additional-networks-info\\additional-networks-info.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-manager\\components\\additional-networks-info\\index.ts", {"./additional-networks-info":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-manager\\components\\additional-networks-info\\additional-networks-info.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnetwork-manager%5Ccomponents%5Cadditional-networks-info%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _additionalNetworksInfo = require("./additional-networks-info");
Object.keys(_additionalNetworksInfo).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _additionalNetworksInfo[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _additionalNetworksInfo[key];
    }
  });
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\network-manager\\components\\additional-networks-info\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-manager\\components\\custom-networks\\custom-networks.tsx", {"../../../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../../../../shared/modules/network.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\network.utils.ts","../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../network-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-item\\index.js","../../hooks/useNetworkChangeHandlers":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-manager\\hooks\\useNetworkChangeHandlers.ts","../../hooks/useNetworkItemCallbacks":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-manager\\hooks\\useNetworkItemCallbacks.ts","../../hooks/useNetworkManagerState":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-manager\\hooks\\useNetworkManagerState.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnetwork-manager%5Ccomponents%5Ccustom-networks%5Ccustom-networks.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomNetworks = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _trace = require("../../../../../../shared/lib/trace");
var _network = require("../../../../../../shared/modules/network.utils");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../../hooks/useI18nContext");
var _componentLibrary = require("../../../../component-library");
var _networkListItem = require("../../../network-list-item");
var _useNetworkChangeHandlers = require("../../hooks/useNetworkChangeHandlers");
var _useNetworkItemCallbacks = require("../../hooks/useNetworkItemCallbacks");
var _useNetworkManagerState = require("../../hooks/useNetworkManagerState");
var _multichain = require("../../../../../selectors/multichain");
var _selectors = require("../../../../../selectors");
var _actions = require("../../../../../store/actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CustomNetworks = exports.CustomNetworks = /*#__PURE__*/_react.default.memo(() => {
  const t = (0, _useI18nContext.useI18nContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const orderedNetworksList = (0, _reactRedux.useSelector)(_selectors.getOrderedNetworksList);
  const [, evmNetworks] = (0, _reactRedux.useSelector)(_selectors.getMultichainNetworkConfigurationsByChainId);
  const showTestnets = (0, _reactRedux.useSelector)(_selectors.getShowTestNetworks);
  const enabledNetworksByNamespace = (0, _reactRedux.useSelector)(_selectors.getEnabledNetworksByNamespace);
  const isMultichainAccountsFeatureEnabled = (0, _reactRedux.useSelector)(_selectors.getIsMultichainAccountsState2Enabled);
  const {
    nonTestNetworks,
    testNetworks
  } = (0, _useNetworkManagerState.useNetworkManagerState)();
  const {
    getItemCallbacks,
    hasMultiRpcOptions,
    isNetworkEnabled
  } = (0, _useNetworkItemCallbacks.useNetworkItemCallbacks)();
  const {
    handleNetworkChange
  } = (0, _useNetworkChangeHandlers.useNetworkChangeHandlers)();
  const isEvmNetworkSelected = (0, _reactRedux.useSelector)(_multichain.getMultichainIsEvm);
  (0, _react.useEffect)(() => {
    (0, _trace.endTrace)({
      name: _trace.TraceName.NetworkList
    });
  }, []);
  const {
    orderedNetworks,
    orderedTestNetworks
  } = (0, _react.useMemo)(() => ({
    orderedNetworks: (0, _network.sortNetworks)(nonTestNetworks, orderedNetworksList),
    orderedTestNetworks: (0, _network.sortNetworks)(testNetworks, orderedNetworksList)
  }), [nonTestNetworks, testNetworks, orderedNetworksList]);

  // Memoize the network click handler
  const handleNetworkClick = (0, _react.useCallback)(async chainId => {
    await handleNetworkChange(chainId);
    await dispatch((0, _actions.hideModal)());
  }, [dispatch, handleNetworkChange]);

  // Renders a network in the network list
  const generateMultichainNetworkListItem = (0, _react.useCallback)(network => {
    const convertedChainId = network.isEvm ? (0, _network.convertCaipToHexChainId)(network.chainId) :
    // keep CAIP for non‑EVM
    network.chainId;
    const isEnabled = Boolean(enabledNetworksByNamespace[convertedChainId]);
    const {
      onDelete,
      onEdit,
      onDiscoverClick,
      onRpcSelect
    } = getItemCallbacks(network);
    const rpcEndpoint = network.isEvm && hasMultiRpcOptions(network) ? (0, _network.getRpcDataByChainId)(network.chainId, evmNetworks).defaultRpcEndpoint : undefined;
    return /*#__PURE__*/_react.default.createElement(_networkListItem.NetworkListItem, {
      key: network.chainId,
      chainId: network.chainId,
      name: network.name,
      iconSrc: (0, _network.getNetworkIcon)(network),
      iconSize: _componentLibrary.AvatarNetworkSize.Md,
      rpcEndpoint: rpcEndpoint,
      onClick: () => handleNetworkClick(network.chainId),
      onDeleteClick: onDelete,
      onEditClick: onEdit,
      onDiscoverClick: onDiscoverClick,
      selected: isEnabled,
      onRpcEndpointClick: onRpcSelect,
      disabled: !isNetworkEnabled(network)
    });
  }, [enabledNetworksByNamespace, getItemCallbacks, hasMultiRpcOptions, evmNetworks, isNetworkEnabled, handleNetworkClick]);

  // Memoize the rendered network lists with filtering
  const renderedCustomNetworks = (0, _react.useMemo)(() => {
    const filteredNetworks = orderedNetworks.filter(network => {
      // If EVM network is selected, only show EVM networks
      if (isEvmNetworkSelected) {
        return network.isEvm;
      }
      // If non-EVM network is selected, only show non-EVM networks
      return !network.isEvm;
    });
    return filteredNetworks.length > 0 ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      paddingBottom: 2
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMdMedium,
      color: _designSystem.TextColor.textAlternative,
      paddingLeft: 4,
      paddingRight: 4
    }, t('customNetworks')), filteredNetworks.map(network => generateMultichainNetworkListItem(network))) : null;
  }, [orderedNetworks, isEvmNetworkSelected, generateMultichainNetworkListItem, isMultichainAccountsFeatureEnabled, t]);
  const renderedTestNetworks = (0, _react.useMemo)(() => {
    const filteredTestNetworks = orderedTestNetworks.filter(network => {
      // If EVM network is selected, only show EVM networks
      if (isEvmNetworkSelected) {
        return network.isEvm;
      }
      // If non-EVM network is selected, only show non-EVM networks
      return !network.isEvm;
    });
    return filteredTestNetworks.map(network => generateMultichainNetworkListItem(network));
  }, [orderedTestNetworks, isEvmNetworkSelected, generateMultichainNetworkListItem]);

  // Memoize the padding value to prevent unnecessary re-renders
  const buttonContainerPaddingTop = (0, _react.useMemo)(() => renderedTestNetworks.length > 0 ? 4 : 0, [renderedTestNetworks.length]);

  // Memoize the add button click handler
  const handleAddNetworkClick = (0, _react.useCallback)(() => {
    history.push('/add');
  }, [history]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column
  }, renderedCustomNetworks, (showTestnets || true) && renderedTestNetworks.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: _designSystem.TextColor.textAlternative,
    paddingLeft: 4,
    paddingRight: 4
  }, t('testnets')), renderedTestNetworks)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    paddingLeft: 4,
    paddingRight: 4,
    paddingTop: buttonContainerPaddingTop
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    variant: _componentLibrary.ButtonVariant.Secondary,
    size: _componentLibrary.ButtonSize.Lg,
    startIconProps: {
      size: _componentLibrary.IconSize.Lg
    },
    startIconName: _componentLibrary.IconName.Add,
    onClick: handleAddNetworkClick
  }, t('addCustomNetwork'))));
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\network-manager\\components\\custom-networks\\custom-networks.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-manager\\components\\custom-networks\\index.ts", {"./custom-networks":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-manager\\components\\custom-networks\\custom-networks.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnetwork-manager%5Ccomponents%5Ccustom-networks%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "CustomNetworks", {
  enumerable: true,
  get: function () {
    return _customNetworks.CustomNetworks;
  }
});
var _customNetworks = require("./custom-networks");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\network-manager\\components\\custom-networks\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-manager\\components\\default-networks\\default-networks.tsx", {"../../../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../../../shared/modules/network.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\network.utils.ts","../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../helpers/utils/build-types":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\build-types.js","../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../../../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","../../../../../selectors/multichain/networks":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain\\networks.ts","../../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../network-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-item\\index.js","../../hooks/useAdditionalNetworkHandlers":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-manager\\hooks\\useAdditionalNetworkHandlers.ts","../../hooks/useNetworkChangeHandlers":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-manager\\hooks\\useNetworkChangeHandlers.ts","../../hooks/useNetworkItemCallbacks":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-manager\\hooks\\useNetworkItemCallbacks.ts","../../hooks/useNetworkManagerState":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-manager\\hooks\\useNetworkManagerState.ts","../additional-networks-info":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-manager\\components\\additional-networks-info\\index.ts","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnetwork-manager%5Ccomponents%5Cdefault-networks%5Cdefault-networks.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultNetworks = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _keyringApi = require("@metamask/keyring-api");
var _network = require("../../../../../../shared/constants/network");
var _network2 = require("../../../../../../shared/modules/network.utils");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _actions = require("../../../../../store/actions");
var _componentLibrary = require("../../../../component-library");
var _networkListItem = require("../../../network-list-item");
var _useAdditionalNetworkHandlers = require("../../hooks/useAdditionalNetworkHandlers");
var _useNetworkChangeHandlers = require("../../hooks/useNetworkChangeHandlers");
var _useNetworkItemCallbacks = require("../../hooks/useNetworkItemCallbacks");
var _useNetworkManagerState = require("../../hooks/useNetworkManagerState");
var _additionalNetworksInfo = require("../additional-networks-info");
var _multichain = require("../../../../../selectors/multichain");
var _networks = require("../../../../../selectors/multichain/networks");
var _useI18nContext = require("../../../../../hooks/useI18nContext");
var _selectors = require("../../../../../selectors");
var _accountTree = require("../../../../../selectors/multichain-accounts/account-tree");
var _buildTypes = require("../../../../../helpers/utils/build-types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DefaultNetworks = exports.DefaultNetworks = /*#__PURE__*/(0, _react.memo)(() => {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const orderedNetworksList = (0, _reactRedux.useSelector)(_selectors.getOrderedNetworksList);
  const [, evmNetworks] = (0, _reactRedux.useSelector)(_selectors.getMultichainNetworkConfigurationsByChainId);
  const allEnabledNetworksForAllNamespaces = (0, _reactRedux.useSelector)(_networks.getAllEnabledNetworksForAllNamespaces);
  // Use the shared callbacks hook
  const {
    getItemCallbacks,
    hasMultiRpcOptions
  } = (0, _useNetworkItemCallbacks.useNetworkItemCallbacks)();

  // Use the shared network change handlers hook
  const {
    handleNetworkChange
  } = (0, _useNetworkChangeHandlers.useNetworkChangeHandlers)();

  // Use the additional network handlers hook
  const {
    handleAdditionalNetworkClick
  } = (0, _useAdditionalNetworkHandlers.useAdditionalNetworkHandlers)();
  const isEvmNetworkSelected = (0, _reactRedux.useSelector)(_multichain.getMultichainIsEvm);
  const isMultichainAccountsState2Enabled = (0, _reactRedux.useSelector)(_selectors.getIsMultichainAccountsState2Enabled);

  // extract the evm account of the selected account group
  const evmAccountGroup = (0, _reactRedux.useSelector)(state => (0, _accountTree.getInternalAccountBySelectedAccountGroupAndCaip)(state, _keyringApi.EthScope.Eoa));
  const enabledChainIds = (0, _reactRedux.useSelector)(_networks.getAllEnabledNetworksForAllNamespaces);
  const selectedAccount = (0, _reactRedux.useSelector)(_selectors.getSelectedInternalAccount);

  // extract the solana account of the selected account group
  const solAccountGroup = (0, _reactRedux.useSelector)(state => (0, _accountTree.getInternalAccountBySelectedAccountGroupAndCaip)(state, _keyringApi.SolScope.Mainnet));
  let btcAccountGroup = null;
  if ((0, _buildTypes.isFlask)()) {
    btcAccountGroup = (0, _reactRedux.useSelector)(state => (0, _accountTree.getInternalAccountBySelectedAccountGroupAndCaip)(state, _keyringApi.BtcScope.Mainnet));
  }

  // Use the shared state hook
  const {
    nonTestNetworks,
    isNetworkInDefaultNetworkTab
  } = (0, _useNetworkManagerState.useNetworkManagerState)({
    showDefaultNetworks: true
  });

  // Memoize sorted networks to avoid expensive sorting on every render
  const orderedNetworks = (0, _react.useMemo)(() => (0, _network2.sortNetworks)(nonTestNetworks, orderedNetworksList), [nonTestNetworks, orderedNetworksList]);

  // Memoize the featured networks calculation
  const featuredNetworksNotYetEnabled = (0, _react.useMemo)(() => _network.FEATURED_RPCS.filter(({
    chainId
  }) => !evmNetworks[chainId]).sort((a, b) => a.name.localeCompare(b.name)), [evmNetworks]);
  const isAllPopularNetworksSelected = (0, _react.useMemo)(() => allEnabledNetworksForAllNamespaces.length > 1, [allEnabledNetworksForAllNamespaces]);
  const isSingleNetworkSelected = (0, _react.useCallback)(hexChainId => {
    return !isAllPopularNetworksSelected && allEnabledNetworksForAllNamespaces.length === 1 && allEnabledNetworksForAllNamespaces[0] === hexChainId;
  }, [isAllPopularNetworksSelected, allEnabledNetworksForAllNamespaces]);

  // Use useCallback for stable function references
  const selectAllDefaultNetworks = (0, _react.useCallback)(() => {
    const evmNetworksList = orderedNetworks.filter(network => network.isEvm);
    if (evmNetworksList.length === 0) {
      return;
    }

    // Use the first EVM network's chain ID for getting RPC data
    const firstEvmChainId = evmNetworksList[0].chainId;
    const {
      defaultRpcEndpoint
    } = (0, _network2.getRpcDataByChainId)(firstEvmChainId, evmNetworks);
    const finalNetworkClientId = defaultRpcEndpoint.networkClientId;
    dispatch((0, _actions.setEnabledAllPopularNetworks)());
    dispatch((0, _actions.hideModal)());
    // deferring execution to keep select all unblocked
    setTimeout(() => {
      dispatch((0, _actions.setActiveNetwork)(finalNetworkClientId));
    }, 0);
  }, [dispatch, evmNetworks, orderedNetworks]);

  // Memoize the network change handler to avoid recreation
  const handleNetworkChangeCallback = (0, _react.useCallback)(async (chainId, isLastRemainingNetwork) => {
    if (isLastRemainingNetwork) {
      return;
    }
    await handleNetworkChange(chainId);
  }, [handleNetworkChange]);

  // Memoize the network list items to avoid recreation on every render
  const networkListItems = (0, _react.useMemo)(() => {
    // Helper function to filter networks based on account type and selection
    const getFilteredNetworks = () => {
      if (isMultichainAccountsState2Enabled) {
        return orderedNetworks.filter(network => {
          // Show EVM networks if user has EVM accounts
          if (evmAccountGroup && network.isEvm) {
            return true;
          }
          if (solAccountGroup && network.chainId === _keyringApi.SolScope.Mainnet) {
            return true;
          }
          if (btcAccountGroup && (0, _buildTypes.isFlask)() && network.chainId === _keyringApi.BtcScope.Mainnet) {
            return true;
          }
          return false;
        });
      }
      return orderedNetworks.filter(network => {
        if (isEvmNetworkSelected) {
          return network.isEvm;
        }
        if (selectedAccount.scopes.includes(_keyringApi.SolScope.Mainnet)) {
          return network.chainId === _keyringApi.SolScope.Mainnet;
        }
        if (selectedAccount.scopes.includes(_keyringApi.BtcScope.Mainnet)) {
          return network.chainId === _keyringApi.BtcScope.Mainnet;
        }
        return false;
      });
    };
    const filteredNetworks = getFilteredNetworks();
    return filteredNetworks.map(network => {
      const networkChainId = network.chainId; // eip155:59144
      // Convert CAIP format to hex format for comparison
      const hexChainId = network.isEvm ? (0, _network2.convertCaipToHexChainId)(networkChainId) : networkChainId;
      if (!isNetworkInDefaultNetworkTab(network)) {
        return null;
      }
      const {
        onDelete,
        onEdit,
        onDiscoverClick,
        onRpcSelect
      } = getItemCallbacks(network);
      const iconSrc = (0, _network2.getNetworkIcon)(network);
      const isSelected = isSingleNetworkSelected(hexChainId);
      const singleRemainingNetwork = enabledChainIds.length === 1;
      const isLastRemainingNetwork = singleRemainingNetwork && enabledChainIds[0] === hexChainId;
      return /*#__PURE__*/_react.default.createElement(_networkListItem.NetworkListItem, {
        key: network.chainId,
        chainId: network.chainId,
        name: network.name,
        iconSrc: iconSrc,
        iconSize: _componentLibrary.AvatarNetworkSize.Md,
        rpcEndpoint: hasMultiRpcOptions(network) ? (0, _network2.getRpcDataByChainId)(network.chainId, evmNetworks).defaultRpcEndpoint : undefined,
        onClick: async () => {
          await handleNetworkChangeCallback(network.chainId, isLastRemainingNetwork);
          await dispatch((0, _actions.hideModal)());
        },
        onDeleteClick: onDelete,
        onEditClick: onEdit,
        onDiscoverClick: onDiscoverClick,
        onRpcEndpointClick: onRpcSelect,
        selected: isSelected
      });
    });
  }, [orderedNetworks, isEvmNetworkSelected, isNetworkInDefaultNetworkTab, getItemCallbacks, isSingleNetworkSelected, hasMultiRpcOptions, evmNetworks, handleNetworkChangeCallback, btcAccountGroup, solAccountGroup, isMultichainAccountsState2Enabled, evmAccountGroup, dispatch, selectedAccount, enabledChainIds]);

  // Memoize the additional network list items
  const additionalNetworkListItems = (0, _react.useMemo)(() => {
    return featuredNetworksNotYetEnabled.map(network => {
      const networkImageUrl = _network.CHAIN_ID_TO_NETWORK_IMAGE_URL_MAP[network.chainId];
      return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        display: _designSystem.Display.Flex,
        alignItems: _designSystem.AlignItems.center,
        justifyContent: _designSystem.JustifyContent.flexStart,
        width: _designSystem.BlockSize.Full,
        onClick: () => handleAdditionalNetworkClick(network),
        paddingLeft: 4,
        paddingRight: 4,
        paddingTop: 4,
        paddingBottom: 4,
        gap: 4,
        "data-testid": "additional-network-item",
        className: "network-manager__additional-network-item",
        key: network.chainId
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
        name: network.name,
        size: _componentLibrary.AvatarNetworkSize.Md,
        src: networkImageUrl,
        borderRadius: _designSystem.BorderRadius.LG
      }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        variant: _designSystem.TextVariant.bodyMdMedium,
        color: _designSystem.TextColor.textDefault
      }, network.name), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
        size: _componentLibrary.ButtonIconSize.Md,
        color: _designSystem.IconColor.iconDefault,
        iconName: _componentLibrary.IconName.Add,
        padding: 0,
        marginLeft: 'auto',
        ariaLabel: t('addNetwork')
      }));
    });
  }, [featuredNetworksNotYetEnabled, handleAdditionalNetworkClick, t]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column
  }, isEvmNetworkSelected || isMultichainAccountsState2Enabled ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "network-manager__all-popular-networks",
    "data-testid": "network-manager-select-all"
  }, /*#__PURE__*/_react.default.createElement(_networkListItem.NetworkListItem, {
    name: t('allPopularNetworks'),
    onClick: selectAllDefaultNetworks,
    iconSrc: _componentLibrary.IconName.Global,
    iconSize: _componentLibrary.IconSize.Xl,
    selected: isAllPopularNetworksSelected
  })) : null, networkListItems, (isEvmNetworkSelected || isMultichainAccountsState2Enabled) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_additionalNetworksInfo.AdditionalNetworksInfo, null), additionalNetworkListItems)));
});
DefaultNetworks.displayName = 'DefaultNetworks';

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\network-manager\\components\\default-networks\\default-networks.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-manager\\components\\default-networks\\index.ts", {"./default-networks":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-manager\\components\\default-networks\\default-networks.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnetwork-manager%5Ccomponents%5Cdefault-networks%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _defaultNetworks = require("./default-networks");
Object.keys(_defaultNetworks).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _defaultNetworks[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _defaultNetworks[key];
    }
  });
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\network-manager\\components\\default-networks\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-manager\\hooks\\useAdditionalNetworkHandlers.ts", {"../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnetwork-manager%5Chooks%5CuseAdditionalNetworkHandlers.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAdditionalNetworkHandlers = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _actions = require("../../../../store/actions");
const useAdditionalNetworkHandlers = () => {
  const dispatch = (0, _reactRedux.useDispatch)();

  // Memoize the additional network click handler
  const handleAdditionalNetworkClick = (0, _react.useCallback)(async network => {
    await dispatch((0, _actions.hideModal)());

    // First add the network to user's configuration
    await dispatch((0, _actions.addNetwork)(network));
  }, [dispatch]);
  return {
    handleAdditionalNetworkClick
  };
};
exports.useAdditionalNetworkHandlers = useAdditionalNetworkHandlers;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\network-manager\\hooks\\useAdditionalNetworkHandlers.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-manager\\hooks\\useNetworkChangeHandlers.ts", {"../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../../shared/modules/network.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\network.utils.ts","../../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnetwork-manager%5Chooks%5CuseNetworkChangeHandlers.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNetworkChangeHandlers = exports.ACTION_MODE = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _metametrics = require("../../../../../shared/constants/metametrics");
var _network = require("../../../../../shared/modules/network.utils");
var _actions = require("../../../../store/actions");
var _selectors = require("../../../../selectors");
var _metametrics2 = require("../../../../contexts/metametrics");
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
let ACTION_MODE = exports.ACTION_MODE = /*#__PURE__*/function (ACTION_MODE) {
  ACTION_MODE[ACTION_MODE["LIST"] = 0] = "LIST";
  ACTION_MODE[ACTION_MODE["ADD_EDIT"] = 1] = "ADD_EDIT";
  ACTION_MODE[ACTION_MODE["ADD_RPC"] = 2] = "ADD_RPC";
  ACTION_MODE[ACTION_MODE["ADD_EXPLORER_URL"] = 3] = "ADD_EXPLORER_URL";
  ACTION_MODE[ACTION_MODE["SELECT_RPC"] = 4] = "SELECT_RPC";
  ACTION_MODE[ACTION_MODE["ADD_NON_EVM_ACCOUNT"] = 5] = "ADD_NON_EVM_ACCOUNT";
  return ACTION_MODE;
}({});
const useNetworkChangeHandlers = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const [multichainNetworks] = (0, _reactRedux.useSelector)(_selectors.getMultichainNetworkConfigurationsByChainId);
  const currentChainId = (0, _reactRedux.useSelector)(_selectors.getSelectedMultichainNetworkChainId);
  const enabledNetworksByNamespace = (0, _reactRedux.useSelector)(_selectors.getEnabledNetworksByNamespace);
  const allChainIds = (0, _reactRedux.useSelector)(_selectors.getAllChainsToPoll);
  const [, evmNetworks] = (0, _reactRedux.useSelector)(_selectors.getMultichainNetworkConfigurationsByChainId);
  // This value needs to be tracked in case the user changes to a Non EVM
  // network and there is no account created for that network. This will
  // allow the user to add an account for that network.
  const [selectedNonEvmNetwork, setSelectedNonEvmNetwork] = (0, _react.useState)();
  const [actionMode, setActionMode] = (0, _react.useState)(ACTION_MODE.LIST);
  (0, _react.useEffect)(() => {
    // Fire and forget async operations for better performance
    // setTimeout with 0 delay pushes these operations to the next event loop tick,
    // preventing them from blocking the current execution stack and improving UI responsiveness.
    // This technique is called "yielding to the event loop" - it allows higher priority
    // tasks (like UI updates) to execute first before these background operations run.
    setTimeout(() => {
      dispatch((0, _actions.updateCustomNonce)(''));
      dispatch((0, _actions.setNextNonce)(''));
      dispatch((0, _actions.detectNfts)(allChainIds));
    }, 0);
  }, [enabledNetworksByNamespace, dispatch, allChainIds]);
  const handleEvmNetworkChange = (0, _react.useCallback)(chainId => {
    const hexChainId = (0, _network.convertCaipToHexChainId)(chainId);
    const {
      defaultRpcEndpoint
    } = (0, _network.getRpcDataByChainId)(chainId, evmNetworks);
    const finalNetworkClientId = defaultRpcEndpoint.networkClientId;
    dispatch((0, _actions.setEnabledNetworks)(hexChainId));

    // deferring execution to keep select all unblocked
    setTimeout(() => {
      dispatch((0, _actions.setActiveNetwork)(finalNetworkClientId));
    }, 0);
  }, [dispatch, evmNetworks]);
  const handleNonEvmNetworkChange = (0, _react.useCallback)(async chainId => {
    dispatch((0, _actions.setActiveNetwork)(chainId));
    dispatch((0, _actions.setEnabledNetworks)(chainId));
  }, [dispatch]);
  const getMultichainNetworkConfigurationOrThrow = (0, _react.useCallback)(chainId => {
    const network = multichainNetworks[chainId];
    if (!network) {
      throw new Error(`Network configuration not found for chainId: ${chainId}`);
    }
    return network;
  }, [multichainNetworks]);
  const handleNetworkChange = (0, _react.useCallback)(async chainId => {
    const currentChain = getMultichainNetworkConfigurationOrThrow(currentChainId);
    const chain = getMultichainNetworkConfigurationOrThrow(chainId);
    if (chain.isEvm) {
      await handleEvmNetworkChange(chainId);
    } else {
      await handleNonEvmNetworkChange(chainId);
    }
    const chainIdToTrack = chain.isEvm ? (0, _network.convertCaipToHexChainId)(chainId) : chainId;
    const currentChainIdToTrack = currentChain.isEvm ? (0, _network.convertCaipToHexChainId)(currentChainId) : currentChainId;
    trackEvent({
      event: _metametrics.MetaMetricsEventName.NavNetworkSwitched,
      category: _metametrics.MetaMetricsEventCategory.Network,
      properties: {
        location: 'Network Menu',
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        chain_id: currentChainIdToTrack,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        from_network: currentChainIdToTrack,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        to_network: chainIdToTrack
      }
    });
  }, [getMultichainNetworkConfigurationOrThrow, currentChainId, handleEvmNetworkChange, handleNonEvmNetworkChange, trackEvent]);
  return {
    handleNetworkChange,
    handleEvmNetworkChange,
    handleNonEvmNetworkChange,
    getMultichainNetworkConfigurationOrThrow,
    selectedNonEvmNetwork,
    setSelectedNonEvmNetwork,
    actionMode,
    setActionMode,
    ACTION_MODE
  };
};
exports.useNetworkChangeHandlers = useNetworkChangeHandlers;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\network-manager\\hooks\\useNetworkChangeHandlers.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-manager\\hooks\\useNetworkItemCallbacks.ts", {"../../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../../shared/modules/network.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\network.utils.ts","../../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../../helpers/utils/window":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\window.ts","../../../../hooks/accounts/useAccountCreationOnNetworkChange":"D:\\code\\v\\metamask-extension\\ui\\hooks\\accounts\\useAccountCreationOnNetworkChange.ts","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnetwork-manager%5Chooks%5CuseNetworkItemCallbacks.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNetworkItemCallbacks = void 0;
var _react = require("react");
var _keyringApi = require("@metamask/keyring-api");
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _network = require("../../../../../shared/constants/network");
var _network2 = require("../../../../../shared/modules/network.utils");
var _window = require("../../../../helpers/utils/window");
var _actions = require("../../../../store/actions");
var _selectors = require("../../../../selectors");
var _metamask = require("../../../../ducks/metamask/metamask");
var _useAccountCreationOnNetworkChange = require("../../../../hooks/accounts/useAccountCreationOnNetworkChange");
const useNetworkItemCallbacks = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const history = (0, _reactRouterDom.useHistory)();
  const isUnlocked = (0, _reactRedux.useSelector)(_metamask.getIsUnlocked);
  const currentChainId = (0, _reactRedux.useSelector)(_selectors.getSelectedMultichainNetworkChainId);
  const isNetworkDiscoverButtonEnabled = (0, _reactRedux.useSelector)(_selectors.getNetworkDiscoverButtonEnabled);
  const [, evmNetworks] = (0, _reactRedux.useSelector)(_selectors.getMultichainNetworkConfigurationsByChainId);
  const completedOnboarding = (0, _reactRedux.useSelector)(_metamask.getCompletedOnboarding);
  const {
    hasAnyAccountsInNetwork
  } = (0, _useAccountCreationOnNetworkChange.useAccountCreationOnNetworkChange)();
  const isDiscoverBtnEnabled = (0, _react.useCallback)(chainId => {
    // The "Discover" button should be enabled when the mapping for the chainId is enabled in the feature flag json
    // and in the constants `CHAIN_ID_PORTFOLIO_LANDING_PAGE_URL_MAP`.
    return Boolean((isNetworkDiscoverButtonEnabled === null || isNetworkDiscoverButtonEnabled === void 0 ? void 0 : isNetworkDiscoverButtonEnabled[chainId]) && _network.CHAIN_ID_PORTFOLIO_LANDING_PAGE_URL_MAP[chainId] !== undefined);
  }, [isNetworkDiscoverButtonEnabled]);
  const hasMultiRpcOptions = (0, _react.useCallback)(network => network.isEvm && (0, _network2.getRpcDataByChainId)(network.chainId, evmNetworks).rpcEndpoints.length > 1, [evmNetworks]);
  const isNetworkEnabled = (0, _react.useCallback)(network => {
    return network.isEvm || completedOnboarding || hasAnyAccountsInNetwork(network.chainId);
  }, [hasAnyAccountsInNetwork, completedOnboarding]);
  const getItemCallbacks = (0, _react.useCallback)(network => {
    const {
      chainId,
      isEvm
    } = network;
    if (!isEvm) {
      return {
        onDiscoverClick: isDiscoverBtnEnabled(chainId) ? () => {
          (0, _window.openWindow)(_network.CHAIN_ID_PORTFOLIO_LANDING_PAGE_URL_MAP[chainId], '_blank');
        } : undefined
      };
    }
    const hexChainId = (0, _network2.convertCaipToHexChainId)(chainId);
    const isDeletable = isUnlocked && network.chainId !== currentChainId && network.chainId !== _keyringApi.EthScope.Mainnet;
    const modalProps = {
      onConfirm: () => undefined,
      onHide: () => undefined
    };
    return {
      onDelete: isDeletable ? () => {
        dispatch((0, _actions.showModal)({
          name: 'CONFIRM_DELETE_NETWORK',
          target: hexChainId,
          ...modalProps
        }));
      } : undefined,
      onEdit: () => {
        dispatch((0, _actions.setEditedNetwork)({
          chainId: hexChainId,
          nickname: network.name
        }));
        history.push('/edit');
      },
      onDiscoverClick: isDiscoverBtnEnabled(hexChainId) ? () => {
        (0, _window.openWindow)(_network.CHAIN_ID_PORTFOLIO_LANDING_PAGE_URL_MAP[hexChainId], '_blank');
      } : undefined,
      onRpcConfigEdit: hasMultiRpcOptions(network) ? () => {
        history.push('/add-rpc');
        dispatch((0, _actions.setEditedNetwork)({
          chainId: hexChainId
        }));
      } : undefined,
      onRpcSelect: () => {
        dispatch((0, _actions.setEditedNetwork)({
          chainId: hexChainId
        }));
        history.push('/select-rpc');
      }
    };
  }, [currentChainId, dispatch, hasMultiRpcOptions, isUnlocked, isDiscoverBtnEnabled, history]);
  return {
    getItemCallbacks,
    hasMultiRpcOptions,
    isNetworkEnabled
  };
};
exports.useNetworkItemCallbacks = useNetworkItemCallbacks;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\network-manager\\hooks\\useNetworkItemCallbacks.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-manager\\hooks\\useNetworkManagerState.ts", {"../../../../../shared/constants/multichain/networks":"D:\\code\\v\\metamask-extension\\shared\\constants\\multichain\\networks.ts","../../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../../shared/modules/network.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\network.utils.ts","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/multichain-network-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-network-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnetwork-manager%5Chooks%5CuseNetworkManagerState.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNetworkManagerState = exports.useNetworkManagerInitialTab = void 0;
var _controllerUtils = require("@metamask/controller-utils");
var _multichainNetworkController = require("@metamask/multichain-network-controller");
var _utils = require("@metamask/utils");
var _react = require("react");
var _reactRedux = require("react-redux");
var _network = require("../../../../../shared/modules/network.utils");
var _networks = require("../../../../../shared/constants/multichain/networks");
var _network2 = require("../../../../../shared/constants/network");
var _selectors = require("../../../../selectors");
const useNetworkManagerState = ({
  showDefaultNetworks = false
} = {}) => {
  const [multichainNetworks] = (0, _reactRedux.useSelector)(_selectors.getMultichainNetworkConfigurationsByChainId);
  const [nonTestNetworks, testNetworks] = (0, _react.useMemo)(() => Object.entries(multichainNetworks).reduce(([nonTestnetsList, testnetsList], [id, network]) => {
    let chainId = id;
    let isTest = false;
    if (network.isEvm) {
      // We keep using raw chain ID for EVM.
      chainId = (0, _network.convertCaipToHexChainId)(network.chainId);
      isTest = _network2.TEST_CHAINS.includes(chainId);
    } else {
      isTest = _multichainNetworkController.NON_EVM_TESTNET_IDS.includes(network.chainId);
    }
    if (showDefaultNetworks) {
      (isTest ? testnetsList : nonTestnetsList)[chainId] = network;
      return [nonTestnetsList, testnetsList];
    }

    // Pre-filter to only include networks that are NOT in built-in networks or featured RPCs
    const hexChainId = network.isEvm ? (0, _network.convertCaipToHexChainId)(network.chainId) : network.chainId;

    // Check if the network is NOT a built-in network or featured RPC
    const isBuiltInNetwork = Object.values(_controllerUtils.BUILT_IN_NETWORKS).some(builtInNetwork => builtInNetwork.chainId === hexChainId);
    const isFeaturedRpc = _network2.FEATURED_RPCS.some(featuredRpc => featuredRpc.chainId === hexChainId);
    const isMultichainProviderConfig = Object.values(_networks.MultichainNetworks).some(multichainNetwork => multichainNetwork === network.chainId || (network.isEvm ? (0, _network.convertCaipToHexChainId)(network.chainId) : network.chainId) === multichainNetwork);
    const shouldInclude = !isBuiltInNetwork && !isFeaturedRpc && !isMultichainProviderConfig;
    if (shouldInclude || isTest) {
      (isTest ? testnetsList : nonTestnetsList)[chainId] = network;
    }
    return [nonTestnetsList, testnetsList];
  }, [{}, {}]), [multichainNetworks, showDefaultNetworks]);
  const isNetworkInDefaultNetworkTab = (0, _react.useCallback)(network => {
    if (!network.isEvm) {
      return true;
    }
    return _network2.FEATURED_NETWORK_CHAIN_IDS.includes((0, _network.convertCaipToHexChainId)(network.chainId));
  }, []);
  return {
    nonTestNetworks,
    testNetworks,
    isNetworkInDefaultNetworkTab
  };
};
exports.useNetworkManagerState = useNetworkManagerState;
const useNetworkManagerInitialTab = () => {
  const allEnabledNetworksForAllNamespaces = (0, _reactRedux.useSelector)(_selectors.getAllEnabledNetworksForAllNamespaces);
  const initialTab = (0, _react.useMemo)(() => {
    const isSubset = (subset, superset) => {
      const supersetSet = new Set(superset);
      return subset.every(x => supersetSet.has(x));
    };
    const enabledNetworksCaipIds = allEnabledNetworksForAllNamespaces.map(c => (0, _utils.isStrictHexString)(c) ? (0, _multichainNetworkController.toEvmCaipChainId)(c) : c);
    const featuredNetworksCaipIds = _network2.FEATURED_NETWORK_CHAIN_IDS_MULTICHAIN.map(c => (0, _utils.isStrictHexString)(c) ? (0, _multichainNetworkController.toEvmCaipChainId)(c) : c);

    // Check against known list of popular chainIds
    return isSubset(enabledNetworksCaipIds, featuredNetworksCaipIds) ? 'networks' : 'custom-networks';
  }, [allEnabledNetworksForAllNamespaces]);
  return {
    initialTab
  };
};
exports.useNetworkManagerInitialTab = useNetworkManagerInitialTab;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\network-manager\\hooks\\useNetworkManagerState.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-manager\\index.ts", {"./network-manager":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-manager\\network-manager.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnetwork-manager%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "NetworkManager", {
  enumerable: true,
  get: function () {
    return _networkManager.NetworkManager;
  }
});
var _networkManager = require("./network-manager");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\network-manager\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-manager\\network-manager.tsx", {"../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../pages/settings/networks-tab/networks-form/networks-form-state":"D:\\code\\v\\metamask-extension\\ui\\pages\\settings\\networks-tab\\networks-form\\networks-form-state.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../network-list-menu/add-block-explorer-modal/add-block-explorer-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-menu\\add-block-explorer-modal\\add-block-explorer-modal.tsx","../network-list-menu/add-rpc-url-modal/add-rpc-url-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-menu\\add-rpc-url-modal\\add-rpc-url-modal.tsx","../network-list-menu/select-rpc-url-modal/select-rpc-url-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-list-menu\\select-rpc-url-modal\\select-rpc-url-modal.tsx","./components/add-network":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-manager\\components\\add-network\\index.ts","./hooks/useNetworkManagerState":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-manager\\hooks\\useNetworkManagerState.ts","./network-tabs":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-manager\\network-tabs.tsx","@metamask/network-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\network-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js","uri-js":"D:\\code\\v\\metamask-extension\\node_modules\\uri-js\\dist\\es5\\uri.all.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnetwork-manager%5Cnetwork-manager.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkManager = void 0;
var _networkController = require("@metamask/network-controller");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var URI = _interopRequireWildcard(require("uri-js"));
var _useI18nContext = require("../../../hooks/useI18nContext");
var _networksFormState = require("../../../pages/settings/networks-tab/networks-form/networks-form-state");
var _selectors = require("../../../selectors");
var _actions = require("../../../store/actions");
var _componentLibrary = require("../../component-library");
var _addBlockExplorerModal = _interopRequireDefault(require("../network-list-menu/add-block-explorer-modal/add-block-explorer-modal"));
var _addRpcUrlModal = _interopRequireDefault(require("../network-list-menu/add-rpc-url-modal/add-rpc-url-modal"));
var _selectRpcUrlModal = require("../network-list-menu/select-rpc-url-modal/select-rpc-url-modal");
var _addNetwork = require("./components/add-network");
var _networkTabs = require("./network-tabs");
var _useNetworkManagerState = require("./hooks/useNetworkManagerState");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NetworkManager = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const t = (0, _useI18nContext.useI18nContext)();
  const navigate = (0, _reactRouterDomV5Compat.useNavigate)();
  const location = (0, _reactRouterDomV5Compat.useLocation)();
  const {
    initialTab
  } = (0, _useNetworkManagerState.useNetworkManagerInitialTab)();
  const handleNewNetwork = () => {
    navigate('/add');
  };
  const [, evmNetworks] = (0, _reactRedux.useSelector)(_selectors.getMultichainNetworkConfigurationsByChainId);
  const {
    chainId: editingChainId,
    editCompleted
  } = (0, _reactRedux.useSelector)(_selectors.getEditedNetwork) ?? {};
  const editedNetwork = (0, _react.useMemo)(() => {
    var _Object$entries$find;
    if (location.pathname === '/add') {
      return undefined;
    }
    if (location.pathname === '/select-rpc') {
      return editingChainId ? evmNetworks[editingChainId] : undefined;
    }
    return !editingChainId || editCompleted ? undefined : (_Object$entries$find = Object.entries(evmNetworks).find(([chainId]) => chainId === editingChainId)) === null || _Object$entries$find === void 0 ? void 0 : _Object$entries$find[1];
  }, [editingChainId, editCompleted, evmNetworks, location.pathname]);
  const networkFormState = (0, _networksFormState.useNetworkFormState)(editedNetwork);
  const handleAddRPC = (0, _react.useCallback)((url, name) => {
    var _networkFormState$rpc;
    if ((_networkFormState$rpc = networkFormState.rpcUrls.rpcEndpoints) !== null && _networkFormState$rpc !== void 0 && _networkFormState$rpc.every(e => !URI.equal(e.url, url))) {
      networkFormState.setRpcUrls({
        rpcEndpoints: [...networkFormState.rpcUrls.rpcEndpoints, {
          url,
          name,
          type: _networkController.RpcEndpointType.Custom
        }],
        defaultRpcEndpointIndex: networkFormState.rpcUrls.rpcEndpoints.length
      });
      if (location.pathname === '/edit-rpc') {
        navigate('/edit');
      } else {
        navigate('/add');
      }
    }
  }, [navigate, networkFormState, location.pathname]);
  const handleAddExplorerUrl = (0, _react.useCallback)(onComplete => {
    return url => {
      var _networkFormState$blo;
      if ((_networkFormState$blo = networkFormState.blockExplorers.blockExplorerUrls) !== null && _networkFormState$blo !== void 0 && _networkFormState$blo.every(u => u !== url)) {
        networkFormState.setBlockExplorers({
          blockExplorerUrls: [...networkFormState.blockExplorers.blockExplorerUrls, url],
          defaultBlockExplorerUrlIndex: networkFormState.blockExplorers.blockExplorerUrls.length
        });
        if (location.pathname === '/edit-explorer-url') {
          navigate('/edit');
        } else {
          navigate('/add');
        }
        onComplete === null || onComplete === void 0 || onComplete();
      }
    };
  }, [networkFormState, navigate, location.pathname]);
  const handleClose = () => {
    dispatch((0, _actions.hideModal)());
    dispatch((0, _actions.setEditedNetwork)());
    navigate('/');
  };
  const handleGoHome = () => {
    navigate('/');
  };
  const handleEditOnComplete = (0, _react.useCallback)(() => {
    navigate('/edit');
  }, [navigate]);
  const handleAddOnComplete = (0, _react.useCallback)(() => {
    navigate('/add');
  }, [navigate]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: true,
    onClose: handleClose,
    isClosedOnEscapeKey: true,
    isClosedOnOutsideClick: true
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, {
    size: _componentLibrary.ModalContentSize.Md
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Routes, null, /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
    path: "/add",
    element: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
      onClose: handleClose,
      onBack: handleGoHome,
      closeButtonProps: {
        'data-testid': 'modal-header-close-button'
      }
    }, t('addNetwork')), /*#__PURE__*/_react.default.createElement(_addNetwork.AddNetwork, {
      networkFormState: networkFormState,
      network: editedNetwork
    }))
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
    path: "/add-rpc",
    element: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
      onClose: handleClose,
      onBack: handleNewNetwork,
      closeButtonProps: {
        'data-testid': 'modal-header-close-button'
      }
    }, t('addRpcUrl')), /*#__PURE__*/_react.default.createElement(_addRpcUrlModal.default, {
      onAdded: handleAddRPC
    }))
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
    path: "/edit-rpc",
    element: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
      onClose: handleClose,
      onBack: handleEditOnComplete,
      closeButtonProps: {
        'data-testid': 'modal-header-close-button'
      }
    }, t('addRpcUrl')), /*#__PURE__*/_react.default.createElement(_addRpcUrlModal.default, {
      onAdded: handleAddRPC
    }))
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
    path: "/add-explorer-url",
    element: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
      onClose: handleClose,
      onBack: handleNewNetwork,
      closeButtonProps: {
        'data-testid': 'modal-header-close-button'
      }
    }, t('addBlockExplorerUrl')), /*#__PURE__*/_react.default.createElement(_addBlockExplorerModal.default, {
      onAdded: handleAddExplorerUrl(handleAddOnComplete)
    }))
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
    path: "/edit-explorer-url",
    element: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
      onClose: handleClose,
      onBack: handleNewNetwork,
      closeButtonProps: {
        'data-testid': 'modal-header-close-button'
      }
    }, t('addBlockExplorerUrl')), /*#__PURE__*/_react.default.createElement(_addBlockExplorerModal.default, {
      onAdded: handleAddExplorerUrl(handleEditOnComplete)
    }))
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
    path: "/edit",
    element: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
      onClose: handleClose,
      onBack: handleGoHome,
      closeButtonProps: {
        'data-testid': 'modal-header-close-button'
      }
    }, t('editNetwork')), /*#__PURE__*/_react.default.createElement(_addNetwork.AddNetwork, {
      networkFormState: networkFormState,
      network: editedNetwork,
      isEdit: true
    }))
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
    path: "/select-rpc",
    element: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
      onClose: handleClose,
      onBack: handleGoHome,
      closeButtonProps: {
        'data-testid': 'modal-header-close-button'
      }
    }, t('selectRpcUrl')), /*#__PURE__*/_react.default.createElement(_selectRpcUrlModal.SelectRpcUrlModal, {
      networkConfiguration: editedNetwork,
      onNetworkChange: handleClose
    }))
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Route, {
    path: "/",
    element: /*#__PURE__*/_react.default.createElement(_networkTabs.NetworkTabs, {
      initialTab: initialTab
    })
  }))));
};
exports.NetworkManager = NetworkManager;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\network-manager\\network-manager.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-manager\\network-tabs.tsx", {"../../../../shared/lib/translate":"D:\\code\\v\\metamask-extension\\shared\\lib\\translate.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/tabs":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tabs\\index.ts","./components/custom-networks":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-manager\\components\\custom-networks\\index.ts","./components/default-networks":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\network-manager\\components\\default-networks\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnetwork-manager%5Cnetwork-tabs.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkTabs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _actions = require("../../../store/actions");
var _componentLibrary = require("../../component-library");
var _tabs = require("../../ui/tabs");
var _translate = require("../../../../shared/lib/translate");
var _customNetworks = require("./components/custom-networks");
var _defaultNetworks = require("./components/default-networks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Network tabs component
const NetworkTabs = ({
  initialTab
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const handleClose = (0, _react.useCallback)(() => {
    dispatch((0, _actions.hideModal)());
  }, [dispatch]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onClose: handleClose,
    closeButtonProps: {
      'data-testid': 'modal-header-close-button'
    }
  }, (0, _translate.t)('bridgeSelectNetwork') ?? 'Select network'), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, {
    style: {
      padding: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_tabs.Tabs, {
    style: {
      padding: 0
    },
    defaultActiveTabKey: initialTab,
    onTabClick: () => {
      // Tab click handler - intentionally empty for now
    },
    tabListProps: {
      className: 'network-manager__tab-list px-4'
    },
    tabContentProps: {
      className: 'network-manager__tab-content'
    }
  }, /*#__PURE__*/_react.default.createElement(_tabs.Tab, {
    tabKey: "networks",
    name: (0, _translate.t)('networkTabPopular') ?? 'Popular'
  }, /*#__PURE__*/_react.default.createElement(_defaultNetworks.DefaultNetworks, null)), /*#__PURE__*/_react.default.createElement(_tabs.Tab, {
    tabKey: "custom-networks",
    name: (0, _translate.t)('networkTabCustom') ?? 'Custom'
  }, /*#__PURE__*/_react.default.createElement(_customNetworks.CustomNetworks, null)))));
};
exports.NetworkTabs = NetworkTabs;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\network-manager\\network-tabs.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\nft-item\\index.ts", {"./nft-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\nft-item\\nft-item.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnft-item%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "NftItem", {
  enumerable: true,
  get: function () {
    return _nftItem.NftItem;
  }
});
var _nftItem = require("./nft-item");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\nft-item\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\nft-item\\nft-item.tsx", {"../../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../app/assets/nfts/nft-default-image/nft-default-image":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\nfts\\nft-default-image\\nft-default-image.tsx","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/tooltip/tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\tooltip.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnft-item%5Cnft-item.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NftItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _reactRedux = require("react-redux");
var _nftDefaultImage = _interopRequireDefault(require("../../app/assets/nfts/nft-default-image/nft-default-image"));
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _selectors = require("../../../selectors");
var _tooltip = _interopRequireDefault(require("../../ui/tooltip/tooltip"));
var _app = require("../../../../shared/constants/app");
var _util = require("../../../../app/scripts/lib/util");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// eslint-disable-next-line import/no-restricted-paths

const NftItem = ({
  nft,
  alt,
  src,
  networkName,
  networkSrc,
  onClick,
  detailView,
  clickable,
  privacyMode,
  isIpfsURL,
  name
}) => {
  var _nft$collection, _nft$collection2, _nft$collection3, _nft$collection4;
  const testNetworkBackgroundColor = (0, _reactRedux.useSelector)(_selectors.getTestNetworkBackgroundColor);
  const isIpfsEnabled = (0, _reactRedux.useSelector)(_selectors.getIpfsGateway);
  const openSeaEnabled = (0, _reactRedux.useSelector)(_selectors.getOpenSeaEnabled);
  const ipfsImageIsRenderable = isIpfsEnabled && isIpfsURL && src;
  const openseaImageIsRenderable = openSeaEnabled && src && !isIpfsURL;
  const nftImageComponentToRender = ipfsImageIsRenderable || openseaImageIsRenderable ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.center,
    style: {
      position: 'relative'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: detailView ? 'nft-item__item nft-item__item-detail' : `nft-item__item nft-item__item-image${privacyMode ? '--hidden' : ''}`,
    "data-testid": "nft-image",
    as: "img",
    src: src,
    alt: alt,
    display: _designSystem.Display.Block,
    justifyContent: _designSystem.JustifyContent.center
  }), privacyMode && /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    style: {
      position: 'absolute'
    },
    name: _componentLibrary.IconName.EyeSlash,
    color: _designSystem.IconColor.iconAlternative
  })) : /*#__PURE__*/_react.default.createElement(_nftDefaultImage.default, {
    className: "nft-item__default-image",
    "data-testid": "nft-default-image",
    clickable: clickable && isIpfsURL
  });
  const environmentType = (0, _util.getEnvironmentType)();
  const maxStrLen = environmentType === _app.ENVIRONMENT_TYPE_FULLSCREEN ? 40 : 20;
  const isLongName = (nft === null || nft === void 0 ? void 0 : nft.name) && nft.name.length > maxStrLen;
  const isLongCollection = (nft === null || nft === void 0 || (_nft$collection = nft.collection) === null || _nft$collection === void 0 ? void 0 : _nft$collection.name) && typeof (nft === null || nft === void 0 || (_nft$collection2 = nft.collection) === null || _nft$collection2 === void 0 ? void 0 : _nft$collection2.name) === 'string' && nft.collection.name.length > maxStrLen;
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "nft-item__card"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "nft-item__container",
    "data-testid": "nft-item",
    as: "button",
    onClick: onClick
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.BadgeWrapper, {
    className: (0, _classnames.default)('nft-item__badge-wrapper', {
      'nft-item__badge-wrapper__clickable': Boolean(clickable)
    }),
    anchorElementShape: _componentLibrary.BadgeWrapperAnchorElementShape.circular,
    positionObj: {
      bottom: 4,
      right: 4
    },
    display: _designSystem.Display.Block,
    badge: /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
      className: "nft-item__network-badge",
      backgroundColor: testNetworkBackgroundColor,
      "data-testid": "nft-network-badge",
      size: _componentLibrary.AvatarNetworkSize.Xs,
      name: networkName,
      src: networkSrc,
      borderWidth: 2
      // @ts-expect-error: We are using BackgroundColor.backgroundDefault here because there is no equivalent BorderColor to get the "cutout" effect
      ,
      borderColor: _designSystem.BackgroundColor.backgroundDefault
    })
  }, nftImageComponentToRender)), nft && /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    position: "bottom",
    html: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", null, nft === null || nft === void 0 ? void 0 : nft.name), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement("span", null, (nft === null || nft === void 0 || (_nft$collection3 = nft.collection) === null || _nft$collection3 === void 0 ? void 0 : _nft$collection3.name) || name)),
    disabled: !isLongName && !isLongCollection
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textDefault,
    ellipsis: true
  }, nft === null || nft === void 0 ? void 0 : nft.name), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative,
    ellipsis: true
  }, (nft === null || nft === void 0 || (_nft$collection4 = nft.collection) === null || _nft$collection4 === void 0 ? void 0 : _nft$collection4.name) || name)));
};
exports.NftItem = NftItem;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\nft-item\\nft-item.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-address\\index.ts", {"./notification-detail-address":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-address\\notification-detail-address.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotification-detail-address%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "NotificationDetailAddress", {
  enumerable: true,
  get: function () {
    return _notificationDetailAddress.NotificationDetailAddress;
  }
});
var _notificationDetailAddress = require("./notification-detail-address");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notification-detail-address\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-address\\notification-detail-address.tsx", {"../../../../shared/modules/hexstring-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\hexstring-utils.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../app/preferred-avatar":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\preferred-avatar\\index.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../notification-detail":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail\\index.ts","../notification-detail-copy-button":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-copy-button\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotification-detail-address%5Cnotification-detail-address.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationDetailAddress = void 0;
var _react = _interopRequireDefault(require("react"));
var _notificationDetail = require("../notification-detail");
var _notificationDetailCopyButton = require("../notification-detail-copy-button");
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _util = require("../../../helpers/utils/util");
var _preferredAvatar = require("../../app/preferred-avatar");
var _hexstringUtils = require("../../../../shared/modules/hexstring-utils");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const SideText = ({
  side
}) => /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
  variant: _designSystem.TextVariant.bodyLgMedium,
  fontWeight: _designSystem.FontWeight.Medium
}, side);

/**
 * A component to display a side text.
 *
 * @param props - The component props.
 * @param props.side - The side text to display.
 * @param props.address - The address to display.
 * @returns The rendered component.
 */
const NotificationDetailAddress = ({
  side,
  address
}) => {
  const checksummedAddress = (0, _hexstringUtils.toChecksumHexAddress)(address);
  const displayAddress = (0, _util.shortenAddress)(checksummedAddress);
  return /*#__PURE__*/_react.default.createElement(_notificationDetail.NotificationDetail, {
    icon: /*#__PURE__*/_react.default.createElement(_preferredAvatar.PreferredAvatar, {
      address: address
    }),
    primaryTextLeft: /*#__PURE__*/_react.default.createElement(SideText, {
      side: side
    }),
    secondaryTextLeft: /*#__PURE__*/_react.default.createElement(_notificationDetailCopyButton.NotificationDetailCopyButton, {
      text: address,
      displayText: displayAddress
    })
  });
};
exports.NotificationDetailAddress = NotificationDetailAddress;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notification-detail-address\\notification-detail-address.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-asset\\index.ts", {"./notification-detail-asset":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-asset\\notification-detail-asset.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotification-detail-asset%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "NotificationDetailAsset", {
  enumerable: true,
  get: function () {
    return _notificationDetailAsset.NotificationDetailAsset;
  }
});
var _notificationDetailAsset = require("./notification-detail-asset");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notification-detail-asset\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-asset\\notification-detail-asset.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../notification-detail":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotification-detail-asset%5Cnotification-detail-asset.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationDetailAsset = void 0;
var _react = _interopRequireDefault(require("react"));
var _notificationDetail = require("../notification-detail");
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const createTextComponent = (variant, fontWeight, color, children) => /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
  variant: variant,
  fontWeight: fontWeight,
  color: color
}, children);

/**
 * A component to display a notification detail with an asset.
 * The asset includes an icon, a label, a detail, a fiat value, and a value.
 *
 * @param props - The component props.
 * @param props.icon - The tokem icon to display with a badge.
 * @param props.label - The label to display.
 * @param props.detail - The detail to display.
 * @param props.fiatValue - The fiat value to display.
 * @param props.value - The value to display.
 * @returns The rendered component.
 */
const NotificationDetailAsset = ({
  icon,
  label,
  detail,
  fiatValue,
  value
}) => {
  var _icon$badge;
  const badgeIcon = /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarToken, {
    src: (_icon$badge = icon.badge) === null || _icon$badge === void 0 ? void 0 : _icon$badge.src,
    size: _componentLibrary.AvatarTokenSize.Sm,
    backgroundColor: _designSystem.BackgroundColor.infoDefault,
    borderColor: _designSystem.BorderColor.backgroundDefault,
    borderWidth: 2
  });
  const badgeWrapper = icon.badge ? /*#__PURE__*/_react.default.createElement(_componentLibrary.BadgeWrapper
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  , {
    position: icon.badge.position || _componentLibrary.BadgeWrapperPosition.topRight,
    badge: badgeIcon
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarToken, {
    src: icon.src,
    borderColor: _designSystem.BorderColor.borderMuted,
    className: "notification-detail-asset__icon"
  })) : /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarToken, {
    src: icon.src,
    borderColor: _designSystem.BorderColor.borderMuted,
    className: "notification-detail-asset__icon"
  });
  const primaryTextLeft = createTextComponent(_designSystem.TextVariant.bodyLgMedium, _designSystem.FontWeight.Medium, _designSystem.TextColor.textDefault, label);
  const secondaryTextLeft = createTextComponent(_designSystem.TextVariant.bodyMd, _designSystem.FontWeight.Normal, _designSystem.TextColor.textAlternative, detail);
  const primaryTextRight = value ? createTextComponent(_designSystem.TextVariant.bodyLgMedium, _designSystem.FontWeight.Medium, _designSystem.TextColor.textDefault, value) : undefined;
  const secondaryTextRight = fiatValue ? createTextComponent(_designSystem.TextVariant.bodyMd, _designSystem.FontWeight.Normal, _designSystem.TextColor.textAlternative, fiatValue) : undefined;
  return /*#__PURE__*/_react.default.createElement(_notificationDetail.NotificationDetail, {
    icon: badgeWrapper,
    primaryTextLeft: primaryTextLeft,
    secondaryTextLeft: secondaryTextLeft,
    primaryTextRight: primaryTextRight,
    secondaryTextRight: secondaryTextRight
  });
};
exports.NotificationDetailAsset = NotificationDetailAsset;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notification-detail-asset\\notification-detail-asset.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-block-explorer-button\\index.ts", {"./notification-detail-block-explorer-button":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-block-explorer-button\\notification-detail-block-explorer-button.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotification-detail-block-explorer-button%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "NotificationDetailBlockExplorerButton", {
  enumerable: true,
  get: function () {
    return _notificationDetailBlockExplorerButton.NotificationDetailBlockExplorerButton;
  }
});
var _notificationDetailBlockExplorerButton = require("./notification-detail-block-explorer-button");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notification-detail-block-explorer-button\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-block-explorer-button\\notification-detail-block-explorer-button.tsx", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/utils/notification.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\notification.util.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../notification-detail-button":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-button\\index.ts","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotification-detail-block-explorer-button%5Cnotification-detail-block-explorer-button.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationDetailBlockExplorerButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _controllerUtils = require("@metamask/controller-utils");
var _networks = require("../../../../shared/modules/selectors/networks");
var _componentLibrary = require("../../component-library");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _notification = require("../../../helpers/utils/notification.util");
var _notificationDetailButton = require("../notification-detail-button");
var _metametrics = require("../../../contexts/metametrics");
var _metametrics2 = require("../../../../shared/constants/metametrics");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NotificationDetailBlockExplorerButton = ({
  notification,
  chainId,
  txHash
}) => {
  var _networkConfiguration;
  const t = (0, _useI18nContext.useI18nContext)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const chainIdHex = (0, _controllerUtils.toHex)(chainId);
  const {
    blockExplorerConfig
  } = (0, _notification.getNetworkDetailsByChainId)(chainId);
  const networkConfigurations = (0, _reactRedux.useSelector)(_networks.getNetworkConfigurationsByChainId);
  const networkConfiguration = networkConfigurations[chainIdHex];
  const configuredBlockExplorer = networkConfiguration === null || networkConfiguration === void 0 || (_networkConfiguration = networkConfiguration.blockExplorerUrls) === null || _networkConfiguration === void 0 ? void 0 : _networkConfiguration[networkConfiguration.defaultBlockExplorerUrlIndex ?? -1];
  const blockExplorerUrl = configuredBlockExplorer ?? (blockExplorerConfig === null || blockExplorerConfig === void 0 ? void 0 : blockExplorerConfig.url);
  const blockExplorerButtonText = (0, _react.useMemo)(() => {
    if (configuredBlockExplorer) {
      return t('notificationItemCheckBlockExplorer');
    }
    if (blockExplorerConfig !== null && blockExplorerConfig !== void 0 && blockExplorerConfig.name) {
      return t('notificationTransactionSuccessView', [blockExplorerConfig.name]);
    }
    return t('notificationItemCheckBlockExplorer');
  }, [blockExplorerConfig === null || blockExplorerConfig === void 0 ? void 0 : blockExplorerConfig.name, configuredBlockExplorer, t]);
  const analyticsEvent = (0, _react.useCallback)(() => {
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.NotificationInteraction,
      event: _metametrics2.MetaMetricsEventName.NotificationDetailClicked,
      properties: {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        notification_id: notification.id,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        notification_type: notification.type,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        chain_id: chainId,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        clicked_item: 'block_explorer'
      }
    });
  }, [chainId, notification.id, notification.type, trackEvent]);
  if (!blockExplorerUrl) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_notificationDetailButton.NotificationDetailButton, {
    variant: _componentLibrary.ButtonVariant.Secondary,
    text: blockExplorerButtonText,
    href: `${blockExplorerUrl}/tx/${txHash}`,
    isExternal: true,
    onClick: analyticsEvent
  });
};
exports.NotificationDetailBlockExplorerButton = NotificationDetailBlockExplorerButton;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notification-detail-block-explorer-button\\notification-detail-block-explorer-button.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-button\\index.ts", {"./notification-detail-button":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-button\\notification-detail-button.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotification-detail-button%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "NotificationDetailButton", {
  enumerable: true,
  get: function () {
    return _notificationDetailButton.NotificationDetailButton;
  }
});
var _notificationDetailButton = require("./notification-detail-button");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notification-detail-button\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-button\\notification-detail-button.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotification-detail-button%5Cnotification-detail-button.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationDetailButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const NotificationDetailButton = ({
  variant = _componentLibrary.ButtonVariant.Secondary,
  text,
  href,
  isExternal = false,
  onClick
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    href: href,
    externalLink: Boolean(href) && isExternal,
    variant: variant,
    size: _componentLibrary.ButtonSize.Lg,
    width: _designSystem.BlockSize.Full,
    endIconName: isExternal ? _componentLibrary.IconName.Arrow2UpRight : undefined,
    onClick: onClick
  }, text));
};
exports.NotificationDetailButton = NotificationDetailButton;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notification-detail-button\\notification-detail-button.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-collection\\index.ts", {"./notification-detail-collection":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-collection\\notification-detail-collection.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotification-detail-collection%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "NotificationDetailCollection", {
  enumerable: true,
  get: function () {
    return _notificationDetailCollection.NotificationDetailCollection;
  }
});
var _notificationDetailCollection = require("./notification-detail-collection");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notification-detail-collection\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-collection\\notification-detail-collection.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/notification.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\notification.util.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../app/assets/nfts/nft-default-image/nft-default-image":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\nfts\\nft-default-image\\nft-default-image.tsx","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../notification-detail":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotification-detail-collection%5Cnotification-detail-collection.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationDetailCollection = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _selectors = require("../../../selectors");
var _nftDefaultImage = _interopRequireDefault(require("../../app/assets/nfts/nft-default-image/nft-default-image"));
var _notification = require("../../../helpers/utils/notification.util");
var _notificationDetail = require("../notification-detail");
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const NotificationDetailCollection = ({
  icon,
  label,
  collection
}) => {
  const {
    badgeSrc,
    src
  } = icon;
  const isIpfsEnabled = (0, _reactRedux.useSelector)(_selectors.getIpfsGateway);
  const openSeaEnabled = (0, _reactRedux.useSelector)(_selectors.getOpenSeaEnabled);
  const ipfsImageIsRenderable = isIpfsEnabled && (0, _notification.isIpfsURL)(src) && src;
  const openseaImageIsRenderable = openSeaEnabled && src && !(0, _notification.isIpfsURL)(src);
  const badgeIcon = /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarToken, {
    src: badgeSrc,
    backgroundColor: _designSystem.BackgroundColor.infoDefault,
    borderColor: _designSystem.BorderColor.backgroundDefault,
    borderWidth: 2,
    size: _componentLibrary.AvatarTokenSize.Sm
  });
  const badgeWrapper = /*#__PURE__*/_react.default.createElement(_componentLibrary.BadgeWrapper, {
    position: _componentLibrary.BadgeWrapperPosition.topRight,
    badge: badgeIcon
  }, ipfsImageIsRenderable || openseaImageIsRenderable ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    as: "img",
    src: src,
    display: _designSystem.Display.Block,
    justifyContent: _designSystem.JustifyContent.center,
    backgroundColor: _designSystem.BackgroundColor.primaryMuted,
    borderRadius: _designSystem.BorderRadius.LG,
    className: "notification-detail-collection__image"
  }) : /*#__PURE__*/_react.default.createElement(_nftDefaultImage.default, {
    className: "nft-item__default-image notification-detail-collection__image",
    "data-testid": "nft-default-image",
    clickable: false
  }));
  const createTextComponent = (textVariant, fontWeight, color, children) => /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: textVariant,
    fontWeight: fontWeight,
    color: color
  }, children);
  const primaryTextLeft = createTextComponent(_designSystem.TextVariant.bodyLgMedium, _designSystem.FontWeight.Medium, _designSystem.TextColor.textDefault, label);
  const secondaryTextLeft = createTextComponent(_designSystem.TextVariant.bodyMd, _designSystem.FontWeight.Normal, _designSystem.TextColor.textAlternative, collection);
  return /*#__PURE__*/_react.default.createElement(_notificationDetail.NotificationDetail, {
    icon: badgeWrapper,
    primaryTextLeft: primaryTextLeft,
    secondaryTextLeft: secondaryTextLeft
  });
};
exports.NotificationDetailCollection = NotificationDetailCollection;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notification-detail-collection\\notification-detail-collection.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-copy-button\\index.ts", {"./notification-detail-copy-button":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-copy-button\\notification-detail-copy-button.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotification-detail-copy-button%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "NotificationDetailCopyButton", {
  enumerable: true,
  get: function () {
    return _notificationDetailCopyButton.NotificationDetailCopyButton;
  }
});
var _notificationDetailCopyButton = require("./notification-detail-copy-button");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notification-detail-copy-button\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-copy-button\\notification-detail-copy-button.tsx", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/time":"D:\\code\\v\\metamask-extension\\shared\\constants\\time.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useCopyToClipboard":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useCopyToClipboard.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/tooltip/tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\tooltip.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotification-detail-copy-button%5Cnotification-detail-copy-button.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationDetailCopyButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _metametrics = require("../../../contexts/metametrics");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _useCopyToClipboard = require("../../../hooks/useCopyToClipboard");
var _tooltip = _interopRequireDefault(require("../../ui/tooltip/tooltip"));
var _useI18nContext = require("../../../hooks/useI18nContext");
var _time = require("../../../../shared/constants/time");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * A component to display a button that copies a given text to the clipboard when clicked.
 * The button includes a tooltip that displays a message based on whether the text has been copied or not.
 *
 * @param props - The component props.
 * @param props.notification - The notification object.
 * @param props.text - The text to be copied when the button is clicked.
 * @param props.displayText - The text to be displayed on the button.
 * @param [props.color] - The color of the text.
 * @returns The rendered component.
 */
const NotificationDetailCopyButton = ({
  notification,
  text,
  displayText,
  color = _designSystem.TextColor.textAlternative
}) => {
  const [copied, handleCopy] = (0, _useCopyToClipboard.useCopyToClipboard)(_time.MINUTE);
  const t = (0, _useI18nContext.useI18nContext)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const tooltipText = copied ? t('copiedExclamation') : t('copyToClipboard');
  const tooltipTitle = tooltipText;
  const onClick = () => {
    typeof handleCopy === 'function' && handleCopy(text);
    if (notification) {
      trackEvent({
        category: _metametrics2.MetaMetricsEventCategory.NotificationInteraction,
        event: _metametrics2.MetaMetricsEventName.NotificationDetailClicked,
        properties: {
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          notification_id: notification.id,
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          notification_type: notification.type,
          ...('chain_id' in notification && {
            // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
            // eslint-disable-next-line @typescript-eslint/naming-convention
            chain_id: notification.chain_id
          }),
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          clicked_item: 'tx_id'
        }
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    position: "bottom",
    title: tooltipTitle
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonBase, {
    backgroundColor: _designSystem.BackgroundColor.transparent,
    onClick: onClick,
    paddingRight: 0,
    paddingLeft: 0,
    variant: _designSystem.TextVariant.bodyMd,
    fontWeight: _designSystem.FontWeight.Normal,
    color: color,
    endIconName: copied ? _componentLibrary.IconName.CopySuccess : _componentLibrary.IconName.Copy,
    alignItems: _designSystem.AlignItems.center,
    "data-testid": "address-copy-button-text",
    size: _componentLibrary.ButtonBaseSize.Sm
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex
  }, displayText)));
};
exports.NotificationDetailCopyButton = NotificationDetailCopyButton;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notification-detail-copy-button\\notification-detail-copy-button.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-info\\index.ts", {"./notification-detail-info":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-info\\notification-detail-info.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotification-detail-info%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "NotificationDetailInfo", {
  enumerable: true,
  get: function () {
    return _notificationDetailInfo.NotificationDetailInfo;
  }
});
var _notificationDetailInfo = require("./notification-detail-info");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notification-detail-info\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-info\\notification-detail-info.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../notification-detail":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotification-detail-info%5Cnotification-detail-info.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationDetailInfo = void 0;
var _react = _interopRequireDefault(require("react"));
var _notificationDetail = require("../notification-detail");
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * A component to display a notification detail with an icon, a label, a detail, and an action.
 *
 * @param props - The component props.
 * @param props.icon - The icon to display.
 * @param props.label - The label to display.
 * @param props.detail - The detail to display.
 * @param [props.action] - The action to display.
 * @returns The rendered component.
 */
const NotificationDetailInfo = ({
  icon,
  label,
  detail,
  action
}) => {
  return /*#__PURE__*/_react.default.createElement(_notificationDetail.NotificationDetail, {
    icon: /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarIcon, icon),
    primaryTextLeft: /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyLgMedium,
      fontWeight: _designSystem.FontWeight.Medium,
      color: _designSystem.TextColor.textDefault
    }, label),
    secondaryTextLeft: /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMd,
      fontWeight: _designSystem.FontWeight.Normal,
      color: _designSystem.TextColor.textAlternative
    }, detail),
    secondaryTextRight: action
  });
};
exports.NotificationDetailInfo = NotificationDetailInfo;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notification-detail-info\\notification-detail-info.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-network-fee\\index.ts", {"./notification-detail-network-fee":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-network-fee\\notification-detail-network-fee.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotification-detail-network-fee%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "NotificationDetailNetworkFee", {
  enumerable: true,
  get: function () {
    return _notificationDetailNetworkFee.NotificationDetailNetworkFee;
  }
});
var _notificationDetailNetworkFee = require("./notification-detail-network-fee");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notification-detail-network-fee\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-network-fee\\notification-detail-network-fee.tsx", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/notification.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\notification.util.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/icon/preloader/preloader-icon.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\icon\\preloader\\preloader-icon.component.js","../notification-detail":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotification-detail-network-fee%5Cnotification-detail-network-fee.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationDetailNetworkFee = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useI18nContext = require("../../../hooks/useI18nContext");
var _metametrics = require("../../../contexts/metametrics");
var _notification = require("../../../helpers/utils/notification.util");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _notificationDetail = require("../notification-detail");
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _preloaderIcon = _interopRequireDefault(require("../../ui/icon/preloader/preloader-icon.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FeeDetail = ({
  label,
  value
}) => /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
  display: _designSystem.Display.Flex,
  justifyContent: _designSystem.JustifyContent.spaceBetween,
  padding: 4
}, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
  color: _designSystem.TextColor.textDefault,
  variant: _designSystem.TextVariant.bodyMd,
  fontWeight: _designSystem.FontWeight.Normal
}, label), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
  color: _designSystem.TextColor.textAlternative,
  variant: _designSystem.TextVariant.bodyMd,
  fontWeight: _designSystem.FontWeight.Normal
}, value));

/**
 * NotificationDetailNetworkFee component displays the network fee details.
 *
 * @param props - The props object.
 * @param props.notification - The notification object.
 * @deprecated - we are planning to remove this component
 * @returns The NotificationDetailNetworkFee component.
 */
// eslint-disable-next-line @typescript-eslint/no-unused-vars
const _NotificationDetailNetworkFee = ({
  notification
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const [networkFees, setNetworkFees] = (0, _react.useState)(null);
  const [networkFeesError, setNetworkFeesError] = (0, _react.useState)(false);
  const getNativeCurrency = n => {
    return (0, _notification.getNetworkDetailsByChainId)(n.chain_id);
  };
  const nativeCurrency = getNativeCurrency(notification);
  (0, _react.useEffect)(() => {
    const fetchNetworkFees = async () => {
      try {
        const networkFeesData = await (0, _notification.getNetworkFees)(notification);
        if (networkFeesData) {
          setNetworkFees({
            transactionFee: {
              transactionFeeInEther: networkFeesData.transactionFeeInEth,
              transactionFeeInUsd: networkFeesData.transactionFeeInUsd
            },
            gasLimitUnits: networkFeesData.gasLimit,
            gasUsedUnits: networkFeesData.gasUsed,
            baseFee: networkFeesData.baseFee,
            priorityFee: networkFeesData.priorityFee,
            maxFeePerGas: networkFeesData.maxFeePerGas
          });
        }
      } catch (err) {
        setNetworkFeesError(true);
      }
    };
    fetchNetworkFees();
  }, []);
  const handleClick = () => {
    if (!isOpen) {
      trackEvent({
        category: _metametrics2.MetaMetricsEventCategory.NotificationInteraction,
        event: _metametrics2.MetaMetricsEventName.NotificationDetailClicked,
        properties: {
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          notification_id: notification.id,
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          notification_type: notification.type,
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          chain_id: notification.chain_id,
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          clicked_item: 'fee_details'
        }
      });
    }
    setIsOpen(!isOpen);
  };
  if (!networkFees && !networkFeesError) {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      height: _designSystem.BlockSize.Full,
      width: _designSystem.BlockSize.Full,
      display: _designSystem.Display.Flex,
      justifyContent: _designSystem.JustifyContent.center,
      alignItems: _designSystem.AlignItems.center,
      flexDirection: _designSystem.FlexDirection.Column,
      "data-testid": "notifications-list-loading"
    }, /*#__PURE__*/_react.default.createElement(_preloaderIcon.default, {
      size: 36
    }));
  }
  if (!networkFees && networkFeesError) {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      height: _designSystem.BlockSize.Full,
      width: _designSystem.BlockSize.Full,
      display: _designSystem.Display.Flex,
      justifyContent: _designSystem.JustifyContent.center,
      alignItems: _designSystem.AlignItems.center,
      flexDirection: _designSystem.FlexDirection.Column,
      "data-testid": "notifications-list-loading",
      paddingTop: 4
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      as: "p",
      color: _designSystem.TextColor.errorDefault,
      variant: _designSystem.TextVariant.bodyMd
    }, t('notificationItemError')));
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    width: _designSystem.BlockSize.Full,
    backgroundColor: _designSystem.BackgroundColor.transparent,
    padding: 0
  }, /*#__PURE__*/_react.default.createElement(_notificationDetail.NotificationDetail, {
    icon: /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarIcon, {
      iconName: _componentLibrary.IconName.Gas,
      color: _designSystem.TextColor.infoDefault,
      backgroundColor: _designSystem.BackgroundColor.infoMuted
    }),
    primaryTextLeft: /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyLgMedium,
      fontWeight: _designSystem.FontWeight.Medium,
      color: _designSystem.TextColor.textDefault
    }, t('notificationDetailNetworkFee')),
    secondaryTextLeft: /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMd,
      fontWeight: _designSystem.FontWeight.Normal,
      color: _designSystem.TextColor.textAlternative
    }, networkFees === null || networkFees === void 0 ? void 0 : networkFees.transactionFee.transactionFeeInEther, ' ', nativeCurrency === null || nativeCurrency === void 0 ? void 0 : nativeCurrency.nativeCurrencySymbol, " (", networkFees === null || networkFees === void 0 ? void 0 : networkFees.transactionFee.transactionFeeInUsd, " USD)"),
    secondaryTextRight: /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      paddingLeft: 0,
      paddingRight: 0,
      paddingTop: 0,
      backgroundColor: _designSystem.BackgroundColor.transparent,
      display: _designSystem.Display.InlineFlex,
      alignItems: _designSystem.AlignItems.center,
      justifyContent: _designSystem.JustifyContent.flexEnd,
      gap: 2,
      as: "button",
      onClick: handleClick
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      color: _designSystem.TextColor.primaryDefault,
      variant: _designSystem.TextVariant.bodyMd
    }, t('notificationDetail')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
      name: isOpen ? _componentLibrary.IconName.ArrowUp : _componentLibrary.IconName.ArrowDown,
      color: _designSystem.IconColor.primaryDefault,
      size: _componentLibrary.IconSize.Sm,
      marginInlineEnd: 1
    }))
  }), isOpen && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: _designSystem.JustifyContent.flexStart,
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(FeeDetail, {
    label: t('notificationDetailGasLimit')
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    ,
    value: (networkFees === null || networkFees === void 0 ? void 0 : networkFees.gasLimitUnits.toString()) || ''
  }), /*#__PURE__*/_react.default.createElement(FeeDetail, {
    label: t('notificationDetailGasUsed')
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    ,
    value: (networkFees === null || networkFees === void 0 ? void 0 : networkFees.gasUsedUnits.toString()) || ''
  }), /*#__PURE__*/_react.default.createElement(FeeDetail, {
    label: t('notificationDetailBaseFee')
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    ,
    value: (networkFees === null || networkFees === void 0 ? void 0 : networkFees.baseFee) || ''
  }), /*#__PURE__*/_react.default.createElement(FeeDetail, {
    label: t('notificationDetailPriorityFee')
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    ,
    value: (networkFees === null || networkFees === void 0 ? void 0 : networkFees.priorityFee) || ''
  }), /*#__PURE__*/_react.default.createElement(FeeDetail, {
    label: t('notificationDetailMaxFee')
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    ,
    value: (networkFees === null || networkFees === void 0 ? void 0 : networkFees.maxFeePerGas) || ''
  })));
};

/**
 * NotificationDetailNetworkFee component displays the network fee details.
 *
 * @param _props - The props object.
 * @param _props.notification - The notification object.
 * @deprecated - we are planning to remove this component
 * @returns The NotificationDetailNetworkFee component.
 */
const NotificationDetailNetworkFee = _props => null;
exports.NotificationDetailNetworkFee = NotificationDetailNetworkFee;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notification-detail-network-fee\\notification-detail-network-fee.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-nft\\index.ts", {"./notification-detail-nft":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-nft\\notification-detail-nft.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotification-detail-nft%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "NotificationDetailNft", {
  enumerable: true,
  get: function () {
    return _notificationDetailNft.NotificationDetailNft;
  }
});
var _notificationDetailNft = require("./notification-detail-nft");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notification-detail-nft\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-nft\\notification-detail-nft.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../nft-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\nft-item\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotification-detail-nft%5Cnotification-detail-nft.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationDetailNft = void 0;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../component-library");
var _nftItem = require("../nft-item");
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * A component that renders a notification detail for an NFT.
 *
 * @param props - The component props.
 * @param props.networkSrc - The URL of the badge icon.
 * @param props.tokenId - The ID of the NFT.
 * @param props.tokenName - The name of the NFT.
 * @param props.tokenSrc - The URL of the NFT icon.
 * @param props.networkName - The name of the network.
 * @returns The NotificationDetailNft component.
 */
const NotificationDetailNft = ({
  networkSrc,
  tokenId,
  tokenName,
  tokenSrc,
  networkName
}) => /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
  paddingTop: 1,
  paddingBottom: 4,
  display: _designSystem.Display.Flex,
  alignItems: _designSystem.AlignItems.center,
  justifyContent: _designSystem.JustifyContent.center
}, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
  className: "notification-detail-nft__image"
}, /*#__PURE__*/_react.default.createElement(_nftItem.NftItem, {
  networkSrc: networkSrc,
  src: tokenSrc,
  name: tokenName,
  alt: tokenName,
  networkName: networkName,
  tokenId: tokenId
})));
exports.NotificationDetailNft = NotificationDetailNft;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notification-detail-nft\\notification-detail-nft.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-title\\index.ts", {"./notification-detail-title":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-title\\notification-detail-title.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotification-detail-title%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "NotificationDetailTitle", {
  enumerable: true,
  get: function () {
    return _notificationDetailTitle.NotificationDetailTitle;
  }
});
var _notificationDetailTitle = require("./notification-detail-title");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notification-detail-title\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail-title\\notification-detail-title.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotification-detail-title%5Cnotification-detail-title.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationDetailTitle = void 0;
var _react = _interopRequireDefault(require("react"));
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * NotificationDetailTitle component.
 * This component displays the title and date of a notification.
 *
 * @param props - Component props.
 * @param props.title - The title of the notification.
 * @param props.date - The date of the notification.
 * @returns The NotificationDetailTitle component.
 */
const NotificationDetailTitle = ({
  title,
  date
}) => {
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.center,
    width: _designSystem.BlockSize.Full,
    flexDirection: _designSystem.FlexDirection.Column,
    paddingInlineStart: 8,
    paddingInlineEnd: 8
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingSm,
    textAlign: _designSystem.TextAlign.Center,
    overflowWrap: _designSystem.OverflowWrap.BreakWord
  }, title), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyXs
  }, date));
};
exports.NotificationDetailTitle = NotificationDetailTitle;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notification-detail-title\\notification-detail-title.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail\\index.ts", {"./notification-detail":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail\\notification-detail.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotification-detail%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "NotificationDetail", {
  enumerable: true,
  get: function () {
    return _notificationDetail.NotificationDetail;
  }
});
var _notificationDetail = require("./notification-detail");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notification-detail\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-detail\\notification-detail.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotification-detail%5Cnotification-detail.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationDetail = void 0;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * `NotificationDetail` is a component that displays a single notification item.
 *
 * @param props - The properties object.
 * @param props.icon - The icon for the notification.
 * @param props.primaryTextLeft - The primary text for the left side of the notification.
 * @param props.primaryTextRight - The primary text for the right side of the notification.
 * @param props.secondaryTextLeft - The secondary text for the left side of the notification.
 * @param props.secondaryTextRight - The secondary text for the right side of the notification.
 * @returns Returns a notification list item component.
 */
const NotificationDetail = ({
  icon,
  primaryTextLeft,
  primaryTextRight,
  secondaryTextLeft,
  secondaryTextRight
}) => {
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    alignItems: _designSystem.AlignItems.flexStart,
    width: _designSystem.BlockSize.Full,
    paddingBottom: 2,
    paddingRight: 4,
    paddingLeft: 4,
    paddingTop: 2,
    backgroundColor: _designSystem.BackgroundColor.transparent
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    gap: 4,
    paddingRight: 4,
    height: _designSystem.BlockSize.Full,
    alignItems: _designSystem.AlignItems.flexStart
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    height: _designSystem.BlockSize.Full,
    className: "notification-detail__icon"
  }, icon), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Block,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.flexStart,
    textAlign: _designSystem.TextAlign.Left
  }, primaryTextLeft, secondaryTextLeft)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.flexEnd,
    textAlign: _designSystem.TextAlign.Right,
    className: "notification-detail__right-container"
  }, primaryTextRight ?? null, secondaryTextRight ?? null));
};
exports.NotificationDetail = NotificationDetail;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notification-detail\\notification-detail.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-list-item-icon\\index.js", {"./notification-list-item-icon":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-list-item-icon\\notification-list-item-icon.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotification-list-item-icon%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "NotificationListItemIcon", {
  enumerable: true,
  get: function () {
    return _notificationListItemIcon.NotificationListItemIcon;
  }
});
var _notificationListItemIcon = require("./notification-list-item-icon");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notification-list-item-icon\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-list-item-icon\\notification-list-item-icon.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/notification.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\notification.util.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../app/assets/nfts/nft-default-image/nft-default-image":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\nfts\\nft-default-image\\nft-default-image.tsx","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotification-list-item-icon%5Cnotification-list-item-icon.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationListItemIconType = exports.NotificationListItemIcon = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _selectors = require("../../../selectors");
var _nftDefaultImage = _interopRequireDefault(require("../../app/assets/nfts/nft-default-image/nft-default-image"));
var _notification = require("../../../helpers/utils/notification.util");
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
let NotificationListItemIconType = exports.NotificationListItemIconType = /*#__PURE__*/function (NotificationListItemIconType) {
  NotificationListItemIconType["Token"] = "token";
  NotificationListItemIconType["Nft"] = "nft";
  return NotificationListItemIconType;
}({});
const useNftImageRenderability = src => {
  const isIpfsEnabled = (0, _reactRedux.useSelector)(_selectors.getIpfsGateway);
  const openSeaEnabled = (0, _reactRedux.useSelector)(_selectors.getOpenSeaEnabled);
  const isIpfs = (0, _notification.isIpfsURL)(src);
  const ipfsImageIsRenderable = isIpfsEnabled && isIpfs && src;
  const openseaImageIsRenderable = openSeaEnabled && src && !isIpfs;
  return {
    ipfsImageIsRenderable,
    openseaImageIsRenderable,
    isIpfs
  };
};
const AvatarTokenComponent = ({
  src
}) => /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarToken, {
  "data-testid": "avatar-token",
  src: src,
  borderStyle: _designSystem.BorderStyle.none,
  size: _componentLibrary.AvatarTokenSize.Md
});
const NftImage = ({
  src
}) => {
  const {
    ipfsImageIsRenderable,
    openseaImageIsRenderable,
    isIpfs
  } = useNftImageRenderability(src);
  return ipfsImageIsRenderable || openseaImageIsRenderable ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    "data-testid": "nft-image",
    as: "img",
    src: src,
    display: _designSystem.Display.Block,
    justifyContent: _designSystem.JustifyContent.center,
    backgroundColor: _designSystem.BackgroundColor.primaryMuted,
    borderRadius: _designSystem.BorderRadius.SM,
    className: "notification-list-item-icon__image"
  }) : /*#__PURE__*/_react.default.createElement(_nftDefaultImage.default, {
    className: "nft-item__default-image notification-list-item-icon__image",
    "data-testid": "nft-default-image",
    clickable: isIpfs
  });
};
const DefaultIcon = () => /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
  "data-testid": "default-icon",
  as: "img",
  display: _designSystem.Display.Block,
  borderRadius: _designSystem.BorderRadius.SM,
  backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
  className: "notification-list-item-icon__image"
});
const getBadge = (badge, children) => {
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.BadgeWrapper, {
    "data-testid": "badge-wrapper"
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    ,
    position: badge.position || _componentLibrary.BadgeWrapperPosition.bottomRight,
    badge: /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarIcon, {
      iconName: badge.icon,
      size: _componentLibrary.AvatarIconSize.Sm,
      backgroundColor: _designSystem.BackgroundColor.infoDefault,
      borderColor: _designSystem.BorderColor.backgroundDefault,
      borderWidth: 2,
      iconProps: {
        name: badge.icon,
        color: _designSystem.IconColor.infoInverse,
        size: _componentLibrary.IconSize.Xs
      }
    })
  }, children);
};
const iconComponents = {
  [NotificationListItemIconType.Token]: AvatarTokenComponent,
  [NotificationListItemIconType.Nft]: ({
    src
  }) => /*#__PURE__*/_react.default.createElement(NftImage, {
    src: src
  }),
  default: DefaultIcon
};

/**
 * Renders a notification list item icon.
 *
 * @param props - The properties object.
 * @param props.type - The type of the notification item icon.
 * @param props.value - The value of the notification item icon.
 * @param props.badge - The badge of the notification item icon.
 * @returns A JSX element.
 */
const NotificationListItemIcon = ({
  type,
  value,
  badge
}) => {
  const IconComponent = iconComponents[type] || iconComponents.default;
  const NotificationIcon = /*#__PURE__*/_react.default.createElement(IconComponent, {
    src: value
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, badge ? getBadge(badge, NotificationIcon) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    borderRadius: _designSystem.BorderRadius.XL
  }, NotificationIcon));
};
exports.NotificationListItemIcon = NotificationListItemIcon;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notification-list-item-icon\\notification-list-item-icon.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-list-item-snap\\index.ts", {"./notification-list-item-snap":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-list-item-snap\\notification-list-item-snap.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotification-list-item-snap%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "NotificationListItemSnap", {
  enumerable: true,
  get: function () {
    return _notificationListItemSnap.NotificationListItemSnap;
  }
});
var _notificationListItemSnap = require("./notification-list-item-snap");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notification-list-item-snap\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-list-item-snap\\notification-list-item-snap.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/notification.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\notification.util.ts","../../app/snaps/snap-icon":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-icon\\index.ts","../../app/snaps/snap-ui-markdown":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-ui-markdown\\index.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../notification-list-item-text":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-list-item-text\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotification-list-item-snap%5Cnotification-list-item-snap.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationListItemSnap = void 0;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _notificationListItemText = require("../notification-list-item-text");
var _notification = require("../../../helpers/utils/notification.util");
var _snapUiMarkdown = require("../../app/snaps/snap-ui-markdown");
var _snapIcon = require("../../app/snaps/snap-icon");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
/**
 * `NotificationListItem` is a component that displays a single notification item.
 *
 * @param props - The properties object.
 * @param props.isRead - Indicates whether the notification has been read.
 * @param props.title - The title of the notification.
 * @param props.createdAt - The date of the notification.
 * @param props.id - The id of the notification.
 * @param props.snapId - The id of the Snap that created the notification.
 * @param props.handleSnapClick - The function to call when the notification is clicked.
 * @param props.handleSnapButton - The function to call when the snap button is clicked.
 * @param props.snapMessage - The snap message to display on the notification.
 * @returns Returns a notification list item component.
 */
const NotificationListItemSnap = ({
  id,
  isRead,
  title,
  snapMessage,
  createdAt,
  snapId,
  handleSnapClick,
  handleSnapButton
}) => {
  const handleClick = () => {
    handleSnapClick === null || handleSnapClick === void 0 || handleSnapClick();
  };
  const handleButtonClick = () => {
    handleSnapButton === null || handleSnapButton === void 0 || handleSnapButton();
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: `notification-list-item ${isRead ? '' : 'notification-list-item--unread'}`,
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    alignItems: _designSystem.AlignItems.flexStart,
    width: _designSystem.BlockSize.Full,
    paddingBottom: 3,
    paddingRight: 5,
    paddingLeft: 5,
    paddingTop: 3,
    key: id,
    onClick: handleClick,
    style: {
      cursor: 'pointer'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    flexDirection: _designSystem.FlexDirection.Row,
    alignItems: _designSystem.AlignItems.flexStart,
    width: _designSystem.BlockSize.Full,
    backgroundColor: _designSystem.BackgroundColor.transparent,
    gap: 4,
    height: _designSystem.BlockSize.Full,
    style: {
      paddingLeft: '6px',
      paddingRight: '6px',
      paddingTop: '2px'
    }
  }, !isRead && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Block,
    className: "notification-list-item__unread-dot__wrapper--snap"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.FullCircle,
    color: _designSystem.IconColor.primaryDefault,
    className: "notification-list-item__unread-dot__dot",
    "data-testid": "unread-dot"
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    height: _designSystem.BlockSize.Full,
    className: "notification-list-item__icon"
  }, /*#__PURE__*/_react.default.createElement(_snapIcon.SnapIcon, {
    snapId: snapId,
    avatarSize: _componentLibrary.IconSize.Md
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    gap: 4,
    height: _designSystem.BlockSize.Full,
    alignItems: _designSystem.AlignItems.flexStart,
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Block,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.flexStart,
    textAlign: _designSystem.TextAlign.Left,
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    alignItems: _designSystem.AlignItems.flexStart,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    onClick: handleButtonClick
  }, /*#__PURE__*/_react.default.createElement(_notificationListItemText.NotificationListItemText, _extends({}, title, {
    color: _designSystem.TextColor.primaryDefault
  }))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textMuted,
    variant: _designSystem.TextVariant.bodySm,
    fontWeight: _designSystem.FontWeight.Normal,
    as: "p"
  }, (0, _notification.formatMenuItemDate)(createdAt))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    color: _designSystem.TextColor.textDefault,
    className: "snap-notifications__item__details__message"
  }, /*#__PURE__*/_react.default.createElement(_snapUiMarkdown.SnapUIMarkdown, {
    markdown: true
  }, snapMessage))))));
};
exports.NotificationListItemSnap = NotificationListItemSnap;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notification-list-item-snap\\notification-list-item-snap.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-list-item-text\\index.ts", {"./notification-list-item-text":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-list-item-text\\notification-list-item-text.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotification-list-item-text%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "NotificationListItemText", {
  enumerable: true,
  get: function () {
    return _notificationListItemText.NotificationListItemText;
  }
});
var _notificationListItemText = require("./notification-list-item-text");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notification-list-item-text\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-list-item-text\\notification-list-item-text.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/notification.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\notification.util.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotification-list-item-text%5Cnotification-list-item-text.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationListItemText = void 0;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _notification = require("../../../helpers/utils/notification.util");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * A component to render a list of notification item titles
 *
 * @param props - The properties of the component
 * @param props.items - The list of items to render
 * @param props.variant - The text variant of the component
 * @param props.color - The text color of the component
 * @returns A JSX element
 */
const NotificationListItemText = ({
  items,
  variant = _designSystem.TextVariant.bodySm,
  color = _designSystem.TextColor.textDefault
}) => {
  const renderItems = items.map(({
    text,
    highlighted
  }, index) => {
    const key = (0, _notification.getRandomKey)(text, index);
    const textColor = highlighted ? _designSystem.TextColor.infoDefault : color;
    const separator = index !== items.length - 1 && ' ';
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      key: key,
      as: "span",
      variant: _designSystem.TextVariant.inherit,
      fontWeight: _designSystem.FontWeight.Normal,
      color: textColor
    }, text, separator);
  });
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "p",
    variant: variant
  }, renderItems);
};
exports.NotificationListItemText = NotificationListItemText;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notification-list-item-text\\notification-list-item-text.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-list-item\\index.ts", {"./notification-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-list-item\\notification-list-item.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotification-list-item%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "NotificationListItem", {
  enumerable: true,
  get: function () {
    return _notificationListItem.NotificationListItem;
  }
});
var _notificationListItem = require("./notification-list-item");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notification-list-item\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-list-item\\notification-list-item.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/notification.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\notification.util.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../notification-list-item-icon":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-list-item-icon\\index.js","../notification-list-item-text":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notification-list-item-text\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotification-list-item%5Cnotification-list-item.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationListItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _notificationListItemIcon = require("../notification-list-item-icon");
var _notificationListItemText = require("../notification-list-item-text");
var _notification = require("../../../helpers/utils/notification.util");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
/**
 * `NotificationListItem` is a component that displays a single notification item.
 *
 * @param props - The properties object.
 * @param props.isRead - Indicates whether the notification has been read.
 * @param props.icon - The icon of the notification.
 * @param props.title - The title of the notification.
 * @param props.description - The description of the notification.
 * @param props.createdAt - The date of the notification.
 * @param props.amount - The amount associated with the notification, if applicable.
 * @param props.id - The id of the notification.
 * @param props.onClick - The function to call when the notification is clicked.
 * @returns Returns a notification list item component.
 */
const NotificationListItem = ({
  id,
  isRead,
  icon,
  title,
  description,
  createdAt,
  amount,
  onClick
}) => {
  const handleClick = () => {
    onClick === null || onClick === void 0 || onClick();
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: `notification-list-item ${isRead ? '' : 'notification-list-item--unread'}`,
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    alignItems: _designSystem.AlignItems.flexStart,
    width: _designSystem.BlockSize.Full,
    paddingBottom: 3,
    paddingRight: 5,
    paddingLeft: 5,
    paddingTop: 3,
    key: id
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    flexDirection: _designSystem.FlexDirection.Row,
    alignItems: _designSystem.AlignItems.flexStart,
    as: "button",
    onClick: handleClick,
    width: _designSystem.BlockSize.Full,
    backgroundColor: _designSystem.BackgroundColor.transparent
  }, !isRead && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Block,
    className: "notification-list-item__unread-dot__wrapper"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.FullCircle,
    color: _designSystem.IconColor.primaryDefault,
    className: "notification-list-item__unread-dot__dot",
    "data-testid": "unread-dot"
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    gap: 4,
    paddingRight: 4,
    height: _designSystem.BlockSize.Full,
    alignItems: _designSystem.AlignItems.flexStart
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    height: _designSystem.BlockSize.Full,
    className: "notification-list-item__icon"
  }, /*#__PURE__*/_react.default.createElement(_notificationListItemIcon.NotificationListItemIcon, icon)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Block,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.flexStart,
    textAlign: _designSystem.TextAlign.Left,
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_notificationListItemText.NotificationListItemText, _extends({}, title, {
    color: _designSystem.TextColor.textAlternative
  })), /*#__PURE__*/_react.default.createElement(_notificationListItemText.NotificationListItemText, description))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.flexEnd,
    textAlign: _designSystem.TextAlign.Right,
    className: "notification-list-item__right-container"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textMuted,
    variant: _designSystem.TextVariant.bodySm,
    fontWeight: _designSystem.FontWeight.Normal,
    as: "p"
  }, (0, _notification.formatMenuItemDate)(createdAt)), amount && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textDefault,
    variant: _designSystem.TextVariant.bodyMd,
    fontWeight: _designSystem.FontWeight.Normal,
    as: "p"
  }, amount))));
};
exports.NotificationListItem = NotificationListItem;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notification-list-item\\notification-list-item.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notifications-page\\index.js", {"./notifications-page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notifications-page\\notifications-page.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotifications-page%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "NotificationsPage", {
  enumerable: true,
  get: function () {
    return _notificationsPage.NotificationsPage;
  }
});
var _notificationsPage = require("./notifications-page");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notifications-page\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notifications-page\\notifications-page.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/metafox-logo":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\metafox-logo\\index.js","../pages/page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotifications-page%5Cnotifications-page.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationsPage = NotificationsPage;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _metafoxLogo = _interopRequireDefault(require("../../ui/metafox-logo"));
var _routes = require("../../../helpers/constants/routes");
var _page = require("../pages/page");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function NotificationsPage({
  children
}) {
  const history = (0, _reactRouterDom.useHistory)();
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "main-container",
    "data-testid": "notifications-page"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: [_designSystem.Display.None, _designSystem.Display.Flex],
    alignItems: _designSystem.AlignItems.center,
    margin: 2,
    className: "multichain-app-header-logo",
    "data-testid": "app-header-logo",
    justifyContent: _designSystem.JustifyContent.center
  }, /*#__PURE__*/_react.default.createElement(_metafoxLogo.default, {
    unsetIconHeight: true,
    onClick: () => history.push(_routes.DEFAULT_ROUTE)
  })), /*#__PURE__*/_react.default.createElement(_page.Page, null, children));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notifications-page\\notifications-page.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notifications-settings-account\\index.ts", {"./notifications-settings-account":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notifications-settings-account\\notifications-settings-account.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotifications-settings-account%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "NotificationsSettingsAccount", {
  enumerable: true,
  get: function () {
    return _notificationsSettingsAccount.NotificationsSettingsAccount;
  }
});
var _notificationsSettingsAccount = require("./notifications-settings-account");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notifications-settings-account\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notifications-settings-account\\notifications-settings-account.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../app/preferred-avatar":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\preferred-avatar\\index.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotifications-settings-account%5Cnotifications-settings-account.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationsSettingsAccount = NotificationsSettingsAccount;
var _react = _interopRequireDefault(require("react"));
var _controllerUtils = require("@metamask/controller-utils");
var _componentLibrary = require("../../component-library");
var _preferredAvatar = require("../../app/preferred-avatar");
var _designSystem = require("../../../helpers/constants/design-system");
var _util = require("../../../helpers/utils/util");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function NotificationsSettingsAccount({
  address,
  name
}) {
  const checksumAddress = (0, _controllerUtils.toChecksumHexAddress)(address);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    alignItems: _designSystem.AlignItems.center,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_preferredAvatar.PreferredAvatar, {
    address: checksumAddress
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.flexStart,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyLgMedium,
    textAlign: _designSystem.TextAlign.Left
  }, name ?? checksumAddress), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    textAlign: _designSystem.TextAlign.Left,
    color: _designSystem.TextColor.textAlternative
  }, (0, _util.shortenAddress)(checksumAddress))));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notifications-settings-account\\notifications-settings-account.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notifications-settings-box\\index.ts", {"./notifications-settings-box":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notifications-settings-box\\notifications-settings-box.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotifications-settings-box%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "NotificationsSettingsBox", {
  enumerable: true,
  get: function () {
    return _notificationsSettingsBox.NotificationsSettingsBox;
  }
});
var _notificationsSettingsBox = require("./notifications-settings-box");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notifications-settings-box\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notifications-settings-box\\notifications-settings-box.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/icon/preloader/preloader-icon.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\icon\\preloader\\preloader-icon.component.js","../../ui/toggle-button":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\toggle-button\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotifications-settings-box%5Cnotifications-settings-box.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationsSettingsBox = NotificationsSettingsBox;
var _react = _interopRequireDefault(require("react"));
var _useI18nContext = require("../../../hooks/useI18nContext");
var _componentLibrary = require("../../component-library");
var _toggleButton = _interopRequireDefault(require("../../ui/toggle-button"));
var _designSystem = require("../../../helpers/constants/design-system");
var _preloaderIcon = _interopRequireDefault(require("../../ui/icon/preloader/preloader-icon.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function NotificationsSettingsBox({
  children,
  value,
  loading = false,
  disabled = false,
  error = null,
  dataTestId,
  onToggle
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    width: _designSystem.BlockSize.Full,
    gap: 4,
    className: "notifications-settings-box"
  }, children, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    "data-testid": `${dataTestId}-toggle-box`,
    className: "notifications-settings-box__toggle"
  }, loading ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    textAlign: _designSystem.TextAlign.Right
  }, /*#__PURE__*/_react.default.createElement(_preloaderIcon.default, {
    size: 24
  })) : /*#__PURE__*/_react.default.createElement(_toggleButton.default, {
    value: value,
    onToggle: onToggle,
    disabled: disabled,
    dataTestId: `${dataTestId}-toggle-input`,
    className: "notifications-settings-box__toggle"
  }))), error && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingTop: 0
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "p",
    color: _designSystem.TextColor.errorDefault,
    paddingTop: 2
  }, t('notificationsSettingsBoxError'))));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notifications-settings-box\\notifications-settings-box.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notifications-settings-type\\index.ts", {"./notifications-settings-type":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notifications-settings-type\\notifications-settings-type.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotifications-settings-type%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "NotificationsSettingsType", {
  enumerable: true,
  get: function () {
    return _notificationsSettingsType.NotificationsSettingsType;
  }
});
var _notificationsSettingsType = require("./notifications-settings-type");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notifications-settings-type\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notifications-settings-type\\notifications-settings-type.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotifications-settings-type%5Cnotifications-settings-type.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationsSettingsType = NotificationsSettingsType;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function NotificationsSettingsType({
  icon,
  title,
  text
}) {
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    alignItems: _designSystem.AlignItems.center,
    gap: 4
  }, icon && /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: icon,
    size: _componentLibrary.IconSize.Lg,
    "data-testid": "icon"
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.stretch,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    width: _designSystem.BlockSize.Full
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyLgMedium,
    textAlign: _designSystem.TextAlign.Left
  }, title), text && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    textAlign: _designSystem.TextAlign.Left,
    color: _designSystem.TextColor.textAlternative
  }, text)));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notifications-settings-type\\notifications-settings-type.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notifications-tag-counter\\index.ts", {"./notifications-tag-counter":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notifications-tag-counter\\notifications-tag-counter.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotifications-tag-counter%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "NotificationsTagCounter", {
  enumerable: true,
  get: function () {
    return _notificationsTagCounter.NotificationsTagCounter;
  }
});
var _notificationsTagCounter = require("./notifications-tag-counter");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notifications-tag-counter\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\notifications-tag-counter\\notifications-tag-counter.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/metamask-notifications/useCounter":"D:\\code\\v\\metamask-extension\\ui\\hooks\\metamask-notifications\\useCounter.tsx","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cnotifications-tag-counter%5Cnotifications-tag-counter.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationsTagCounter = void 0;
var _react = _interopRequireDefault(require("react"));
var _useCounter = require("../../../hooks/metamask-notifications/useCounter");
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const NotificationsTagCounter = ({
  noLabel = false
}) => {
  const {
    notificationsUnreadCount
  } = (0, _useCounter.useUnreadNotificationsCounter)();
  if (notificationsUnreadCount === 0) {
    return null;
  }
  if (noLabel) {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Block,
      className: "notification-list-item__unread-dot__wrapper",
      style: {
        position: 'absolute',
        cursor: 'pointer',
        top: 0,
        left: '50%',
        zIndex: 1
      },
      backgroundColor: _designSystem.BackgroundColor.errorDefault,
      borderStyle: _designSystem.BorderStyle.none,
      borderRadius: _designSystem.BorderRadius.LG,
      paddingTop: 0,
      paddingBottom: 0,
      paddingLeft: 0,
      paddingRight: 0
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      color: _designSystem.TextColor.errorInverse,
      variant: _designSystem.TextVariant.bodyXs,
      className: "notifications-tag-counter__unread-dot",
      "data-testid": "notifications-tag-counter__unread-dot",
      textAlign: _designSystem.TextAlign.Center
    }, notificationsUnreadCount > 10 ? '9+' : notificationsUnreadCount));
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    backgroundColor: _designSystem.BackgroundColor.errorDefault,
    borderStyle: _designSystem.BorderStyle.none,
    borderRadius: _designSystem.BorderRadius.LG,
    paddingTop: 0,
    paddingBottom: 0,
    className: "notifications-tag-counter"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.errorInverse,
    variant: _designSystem.TextVariant.bodySm,
    "data-testid": "global-menu-notification-count",
    className: "notifications-tag-counter__text",
    textAlign: _designSystem.TextAlign.Center
  }, notificationsUnreadCount > 10 ? '9+' : notificationsUnreadCount));
};
exports.NotificationsTagCounter = NotificationsTagCounter;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\notifications-tag-counter\\notifications-tag-counter.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\connections\\components\\no-connection.tsx", {"../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Cconnections%5Ccomponents%5Cno-connection.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoConnectionContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _designSystem = require("../../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../../hooks/useI18nContext");
var _componentLibrary = require("../../../../component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const NoConnectionContent = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "connections-page__no-site-connected-content",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    gap: 2,
    paddingLeft: 4,
    paddingRight: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    textAlign: _designSystem.TextAlign.Center
  }, t('noConnectedAccountTitle')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    textAlign: _designSystem.TextAlign.Center
  }, t('noConnectionDescription')));
};
exports.NoConnectionContent = NoConnectionContent;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\connections\\components\\no-connection.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\connections\\connections.tsx", {"../..":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../connect-accounts-modal/connect-accounts-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\connect-accounts-modal\\connect-accounts-modal.tsx","../../disconnect-all-modal/disconnect-all-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\disconnect-all-modal\\disconnect-all-modal.tsx","../page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\index.ts","./components/no-connection":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\connections\\components\\no-connection.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Cconnections%5Cconnections.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Connections = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _designSystem = require("../../../../helpers/constants/design-system");
var _routes = require("../../../../helpers/constants/routes");
var _util = require("../../../../helpers/utils/util");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _selectors = require("../../../../selectors");
var _componentLibrary = require("../../../component-library");
var _ = require("../..");
var _page = require("../page");
var _connectAccountsModal = require("../../connect-accounts-modal/connect-accounts-modal");
var _actions = require("../../../../store/actions");
var _disconnectAllModal = require("../../disconnect-all-modal/disconnect-all-modal");
var _noConnection = require("./components/no-connection");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Connections = () => {
  var _permittedAccountsByO;
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const history = (0, _reactRouterDom.useHistory)();
  const [showConnectAccountsModal, setShowConnectAccountsModal] = (0, _react.useState)(false);
  const [showDisconnectAllModal, setShowDisconnectAllModal] = (0, _react.useState)(false);
  const [showAccountDisconnectedToast, setShowAccountDisconnectedToast] = (0, _react.useState)(''); // This is not boolean because we need the account name from the menu when a single account is disconnected
  const [showConnectedAccountsUpdatedToast, setShowConnectedAccountsUpdatedToast] = (0, _react.useState)(false);
  const [showDisconnectedAllAccountsUpdatedToast, setShowDisconnectedAllAccountsUpdatedToast] = (0, _react.useState)(false);
  const urlParams = (0, _reactRouterDom.useParams)();
  // @ts-expect-error TODO: Fix this type error by handling undefined parameters
  const activeTabOrigin = decodeURIComponent(urlParams.origin);

  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  const subjectMetadata = (0, _reactRedux.useSelector)(_selectors.getConnectedSitesList);
  const siteMetadata = (0, _reactRedux.useSelector)(_selectors.getSubjectMetadata);
  const connectedSiteMetadata = siteMetadata[activeTabOrigin];

  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  const {
    openMetaMaskTabs
  } = (0, _reactRedux.useSelector)(state => state.appState);

  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  const {
    id
  } = (0, _reactRedux.useSelector)(state => state.activeTab);
  const unconnectedAccounts = (0, _reactRedux.useSelector)(state => (0, _selectors.getUnconnectedAccounts)(state, activeTabOrigin));
  const connectedAccounts = (0, _reactRedux.useSelector)(state => (0, _selectors.getOrderedConnectedAccountsForConnectedDapp)(state, activeTabOrigin));
  const selectedAccount = (0, _reactRedux.useSelector)(_selectors.getSelectedAccount);
  const permittedAccountsByOrigin = (0, _reactRedux.useSelector)(_selectors.getPermittedAccountsByOrigin

  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  );
  const subjects = (0, _reactRedux.useSelector)(_selectors.getPermissionSubjects);
  const currentTabHasNoAccounts = !((_permittedAccountsByO = permittedAccountsByOrigin[activeTabOrigin]) !== null && _permittedAccountsByO !== void 0 && _permittedAccountsByO.length);

  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  let tabToConnect = {
    origin: null
  };
  if (activeTabOrigin && currentTabHasNoAccounts && !openMetaMaskTabs[id]) {
    tabToConnect = {
      origin: activeTabOrigin
    };
  }
  const requestAccountsPermission = async () => {
    const requestId = await dispatch((0, _actions.requestAccountsAndChainPermissionsWithId)(tabToConnect.origin));
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31893
    // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
    history.push(`${_routes.CONNECT_ROUTE}/${requestId}`);
  };
  const connectedSubjectsMetadata = subjectMetadata[activeTabOrigin];
  const permittedAccounts = (0, _reactRedux.useSelector)(state => (0, _selectors.getPermittedEVMAccountsForSelectedTab)(state, activeTabOrigin));
  const disconnectAllAccounts = () => {
    const subject = subjects[activeTabOrigin];
    if (subject) {
      const permissionMethodNames = Object.values(subject.permissions).map(({
        parentCapability
      }) => parentCapability);
      if (permissionMethodNames.length > 0) {
        const permissionsRecord = {
          [activeTabOrigin]: permissionMethodNames
        };
        dispatch((0, _actions.removePermissionsFor)(permissionsRecord));
      }
      setShowDisconnectAllModal(false);
      setShowDisconnectedAllAccountsUpdatedToast(true);
    }
  };

  // In the connectedAccounts, we need the lastSelected value to determine which connectedAccount was last selected.
  const latestSelected = connectedAccounts.findIndex(
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  (_account, index) => {
    return index === connectedAccounts.reduce((indexOfAccountWIthHighestLastSelected, currentAccountToCompare, i) => {
      const currentLastSelected = currentAccountToCompare.metadata.lastSelected ?? 0;
      const accountAtIndexLastSelected = connectedAccounts[indexOfAccountWIthHighestLastSelected].metadata.lastSelected ? i : indexOfAccountWIthHighestLastSelected;
      return currentLastSelected > accountAtIndexLastSelected ? i : indexOfAccountWIthHighestLastSelected;
    }, 0);
  });
  return /*#__PURE__*/_react.default.createElement(_page.Page, {
    "data-testid": "connections-page",
    className: "main-container connections-page"
  }, /*#__PURE__*/_react.default.createElement(_page.Header, {
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    startAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      ariaLabel: t('back'),
      iconName: _componentLibrary.IconName.ArrowLeft,
      className: "connections-header__start-accessory",
      color: _designSystem.IconColor.iconDefault
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
      ,
      onClick: () => history.goBack(),
      size: _componentLibrary.ButtonIconSize.Sm
    })
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    gap: 2,
    justifyContent: _designSystem.JustifyContent.center,
    className: "connections-header__title"
  }, connectedSubjectsMetadata !== null && connectedSubjectsMetadata !== void 0 && connectedSubjectsMetadata.iconUrl ? /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarFavicon, {
    name: connectedSubjectsMetadata.name,
    size: _componentLibrary.AvatarFaviconSize.Sm,
    src: connectedSubjectsMetadata.iconUrl
  }) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.Global,
    size: _componentLibrary.IconSize.Sm,
    color: _designSystem.IconColor.iconDefault
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "span",
    variant: _designSystem.TextVariant.headingMd,
    textAlign: _designSystem.TextAlign.Center,
    ellipsis: true
  }, (0, _util.getURLHost)(activeTabOrigin)))), /*#__PURE__*/_react.default.createElement(_page.Content, {
    padding: 0
  }, permittedAccounts.length > 0 && connectedAccounts.length > 0 ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, connectedAccounts.map((account, index) => {
    var _connectedSites$accou;
    const connectedSites = {};
    const connectedSite = (_connectedSites$accou = connectedSites[account.address]) === null || _connectedSites$accou === void 0 ? void 0 : _connectedSites$accou.find(({
      origin
    }) => origin === activeTabOrigin);
    const isSelectedAccount = selectedAccount.address === account.address;
    // Match the index of latestSelected Account with the index of all the accounts and set the active status
    const mergedAccountsProps = {
      ...account,
      isAccountActive: index === latestSelected
    };
    return /*#__PURE__*/_react.default.createElement(_.AccountListItem, {
      account: mergedAccountsProps,
      key: account.address,
      accountsCount: connectedAccounts.length,
      selected: isSelectedAccount,
      connectedAvatar: connectedSite === null || connectedSite === void 0 ? void 0 : connectedSite.iconUrl,
      menuType: _.AccountListItemMenuTypes.Connection,
      currentTabOrigin: activeTabOrigin,
      isActive: mergedAccountsProps.isAccountActive ? t('active') : null,
      onActionClick: setShowAccountDisconnectedToast
    });
  })) : /*#__PURE__*/_react.default.createElement(_noConnection.NoConnectionContent, null), showConnectAccountsModal ? /*#__PURE__*/_react.default.createElement(_connectAccountsModal.ConnectAccountsModal, {
    onClose: () => setShowConnectAccountsModal(false),
    onAccountsUpdate: () => setShowConnectedAccountsUpdatedToast(true),
    activeTabOrigin: activeTabOrigin
  }) : null, showDisconnectAllModal ? /*#__PURE__*/_react.default.createElement(_disconnectAllModal.DisconnectAllModal, {
    type: _disconnectAllModal.DisconnectType.Account,
    hostname: activeTabOrigin,
    onClose: () => setShowDisconnectAllModal(false),
    onClick: () => disconnectAllAccounts()
  }) : null), /*#__PURE__*/_react.default.createElement(_page.Footer, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    width: _designSystem.BlockSize.Full,
    gap: 4
  }, showConnectedAccountsUpdatedToast ? /*#__PURE__*/_react.default.createElement(_.ToastContainer, null, /*#__PURE__*/_react.default.createElement(_.Toast, {
    text: t('connectedAccountsToast'),
    onClose: () => setShowConnectedAccountsUpdatedToast(false),
    startAdornment: /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarFavicon, {
      name: connectedSubjectsMetadata === null || connectedSubjectsMetadata === void 0 ? void 0 : connectedSubjectsMetadata.name,
      size: _componentLibrary.AvatarFaviconSize.Sm,
      src: connectedSubjectsMetadata === null || connectedSubjectsMetadata === void 0 ? void 0 : connectedSubjectsMetadata.iconUrl
    })
  })) : null, showDisconnectedAllAccountsUpdatedToast ? /*#__PURE__*/_react.default.createElement(_.ToastContainer, null, /*#__PURE__*/_react.default.createElement(_.Toast, {
    text: t('disconnectedAllAccountsToast', [(0, _util.getURLHost)(activeTabOrigin)]),
    onClose: () => setShowDisconnectedAllAccountsUpdatedToast(false),
    startAdornment: /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarFavicon, {
      name: connectedSiteMetadata === null || connectedSiteMetadata === void 0 ? void 0 : connectedSiteMetadata.name,
      size: _componentLibrary.AvatarFaviconSize.Sm,
      src: connectedSiteMetadata === null || connectedSiteMetadata === void 0 ? void 0 : connectedSiteMetadata.iconUrl
    })
  })) : null, showAccountDisconnectedToast.length > 0 ? /*#__PURE__*/_react.default.createElement(_.ToastContainer, null, /*#__PURE__*/_react.default.createElement(_.Toast, {
    text: t('disconnectedSingleAccountToast', [showAccountDisconnectedToast, (0, _util.getURLHost)(activeTabOrigin)]),
    onClose: () => setShowAccountDisconnectedToast(''),
    startAdornment: /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarFavicon, {
      name: connectedSiteMetadata === null || connectedSiteMetadata === void 0 ? void 0 : connectedSiteMetadata.name,
      size: _componentLibrary.AvatarFaviconSize.Sm,
      src: connectedSiteMetadata === null || connectedSiteMetadata === void 0 ? void 0 : connectedSiteMetadata.iconUrl
    })
  })) : null, permittedAccounts.length > 0 && connectedAccounts.length > 0 ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    gap: 2,
    flexDirection: _designSystem.FlexDirection.Column,
    width: _designSystem.BlockSize.Full,
    "data-test-id": "connections-button"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    size: _componentLibrary.ButtonSize.Lg,
    block: true,
    variant: _componentLibrary.ButtonVariant.Secondary,
    disabled: unconnectedAccounts.length === 0,
    startIconName: _componentLibrary.IconName.Add,
    onClick: () => setShowConnectAccountsModal(true)
  }, t('connectMoreAccounts')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    size: _componentLibrary.ButtonSize.Lg,
    block: true,
    variant: _componentLibrary.ButtonVariant.Secondary,
    startIconName: _componentLibrary.IconName.Logout,
    danger: true,
    onClick: () => setShowDisconnectAllModal(true)
  }, t('disconnectAllAccounts'))) : /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonPrimary, {
    size: _componentLibrary.ButtonPrimarySize.Lg,
    block: true,
    "data-test-id": "no-connections-button"
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    ,
    onClick: () => requestAccountsPermission()
  }, t('connectAccounts')))));
};
exports.Connections = Connections;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\connections\\connections.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\connections\\index.js", {"./connections":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\connections\\connections.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Cconnections%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "Connections", {
  enumerable: true,
  get: function () {
    return _connections.Connections;
  }
});
var _connections = require("./connections");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\connections\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\gator-permissions\\components\\index.ts", {"./permission-group-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\gator-permissions\\components\\permission-group-list-item.tsx","./permission-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\gator-permissions\\components\\permission-list-item.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Cgator-permissions%5Ccomponents%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "PermissionGroupListItem", {
  enumerable: true,
  get: function () {
    return _permissionGroupListItem.PermissionGroupListItem;
  }
});
Object.defineProperty(exports, "PermissionListItem", {
  enumerable: true,
  get: function () {
    return _permissionListItem.PermissionListItem;
  }
});
var _permissionListItem = require("./permission-list-item");
var _permissionGroupListItem = require("./permission-group-list-item");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\gator-permissions\\components\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\gator-permissions\\components\\permission-group-list-item.tsx", {"../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../helper":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\gator-permissions\\helper.ts","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Cgator-permissions%5Ccomponents%5Cpermission-group-list-item.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PermissionGroupListItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _designSystemReact = require("@metamask/design-system-react");
var _useI18nContext = require("../../../../../hooks/useI18nContext");
var _multichain = require("../../../../../selectors/multichain");
var _selectors = require("../../../../../selectors");
var _helper = require("../helper");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const PermissionGroupListItem = ({
  chainId,
  text,
  onClick
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const networkImageUrl = (0, _multichain.getImageForChainId)(chainId);
  const [, evmNetworks] = (0, _reactRedux.useSelector)(_selectors.getMultichainNetworkConfigurationsByChainId);
  const getNetworkNameForChainId = () => {
    const networkNameKey = (0, _helper.extractNetworkName)(evmNetworks, chainId);
    const networkName = t(networkNameKey);

    // If the translation key doesn't exist (returns the same key), fall back to the full network name
    if (!networkName || networkName === networkNameKey) {
      return (0, _helper.extractNetworkName)(evmNetworks, chainId, true);
    }
    return networkName;
  };
  return /*#__PURE__*/_react.default.createElement(_designSystemReact.Box, {
    "data-testid": "permission-group-list-item",
    backgroundColor: _designSystemReact.BoxBackgroundColor.BackgroundDefault,
    alignItems: _designSystemReact.BoxAlignItems.Baseline,
    padding: 4,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_designSystemReact.Button, {
    onClick: onClick,
    style: {
      width: '100%',
      backgroundColor: 'transparent',
      border: 'none',
      padding: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_designSystemReact.Box, {
    alignItems: _designSystemReact.BoxAlignItems.Start,
    marginRight: 2
  }, /*#__PURE__*/_react.default.createElement(_designSystemReact.AvatarNetwork, {
    "data-testid": "permission-group-list-item__avatar-network",
    src: networkImageUrl,
    name: chainId,
    size: _designSystemReact.AvatarNetworkSize.Lg,
    style: {
      borderRadius: '50%'
    }
  })), /*#__PURE__*/_react.default.createElement(_designSystemReact.Box, {
    flexDirection: _designSystemReact.BoxFlexDirection.Column,
    alignItems: _designSystemReact.BoxAlignItems.Start,
    justifyContent: _designSystemReact.BoxJustifyContent.Start,
    style: {
      flexGrow: '1'
    }
  }, /*#__PURE__*/_react.default.createElement(_designSystemReact.Text, {
    variant: _designSystemReact.TextVariant.BodyMd
  }, getNetworkNameForChainId()), /*#__PURE__*/_react.default.createElement(_designSystemReact.Text, {
    color: _designSystemReact.TextColor.TextAlternative,
    variant: _designSystemReact.TextVariant.BodyMd
  }, text)), /*#__PURE__*/_react.default.createElement(_designSystemReact.Box, {
    justifyContent: _designSystemReact.BoxJustifyContent.End,
    alignItems: _designSystemReact.BoxAlignItems.End,
    gap: 2
  }, /*#__PURE__*/_react.default.createElement(_designSystemReact.Icon, {
    name: _designSystemReact.IconName.ArrowRight,
    color: _designSystemReact.IconColor.IconDefault,
    size: _designSystemReact.IconSize.Sm
  }))));
};
exports.PermissionGroupListItem = PermissionGroupListItem;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\gator-permissions\\components\\permission-group-list-item.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\gator-permissions\\components\\permission-list-item.tsx", {"../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Cgator-permissions%5Ccomponents%5Cpermission-list-item.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PermissionListItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _designSystemReact = require("@metamask/design-system-react");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _componentLibrary = require("../../../../component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const PermissionListItem = ({
  total,
  permissionGroupName,
  onClick
}) => {
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    "data-testid": "permission-list-item",
    width: _designSystem.BlockSize.Full,
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault
  }, /*#__PURE__*/_react.default.createElement(_designSystemReact.Button, {
    onClick: onClick,
    style: {
      width: '100%',
      backgroundColor: 'transparent',
      border: 'none',
      padding: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    alignItems: _designSystem.AlignItems.baseline,
    width: _designSystem.BlockSize.Full,
    padding: 4,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    alignItems: _designSystem.AlignItems.center,
    style: {
      flex: '1',
      alignSelf: 'center'
    },
    gap: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    textAlign: _designSystem.TextAlign.Left,
    ellipsis: true
  }, permissionGroupName)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.flexEnd,
    flexDirection: _designSystem.FlexDirection.Row,
    alignItems: _designSystem.AlignItems.center,
    style: {
      flex: '1',
      alignSelf: 'center'
    },
    gap: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "span",
    width: _designSystem.BlockSize.Max,
    color: _designSystem.TextColor.textAlternative,
    variant: _designSystem.TextVariant.bodyMd
  }, total), /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    display: _designSystem.Display.Flex,
    name: _componentLibrary.IconName.ArrowRight,
    color: _designSystem.IconColor.iconDefault,
    size: _componentLibrary.IconSize.Sm,
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault
  })))));
};
exports.PermissionListItem = PermissionListItem;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\gator-permissions\\components\\permission-list-item.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\gator-permissions\\gator-permissions-page.tsx", {"../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../../hooks/gator-permissions/useGatorPermissions":"D:\\code\\v\\metamask-extension\\ui\\hooks\\gator-permissions\\useGatorPermissions.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../selectors/gator-permissions/gator-permissions":"D:\\code\\v\\metamask-extension\\ui\\selectors\\gator-permissions\\gator-permissions.ts","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\index.ts","./components/permission-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\gator-permissions\\components\\permission-list-item.tsx","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Cgator-permissions%5Cgator-permissions-page.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GatorPermissionsPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _snapsUtils = require("@metamask/snaps-utils");
var _page = require("../page");
var _componentLibrary = require("../../../component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _routes = require("../../../../helpers/constants/routes");
var _useGatorPermissions = require("../../../../hooks/gator-permissions/useGatorPermissions");
var _selectors = require("../../../../selectors");
var _gatorPermissions = require("../../../../selectors/gator-permissions/gator-permissions");
var _permissionListItem = require("./components/permission-list-item");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GatorPermissionsPage = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const headerRef = (0, _react.useRef)(null);
  const sitesConnectionsList = (0, _reactRedux.useSelector)(_selectors.getConnectedSitesListWithNetworkInfo);
  const totalGatorPermissions = (0, _reactRedux.useSelector)(state => (0, _gatorPermissions.getAggregatedGatorPermissionsCountAcrossAllChains)(state, 'token-transfer'));
  const totalSitesConnections = Object.keys(sitesConnectionsList).filter(site => !(0, _snapsUtils.isSnapId)(site)).length;
  const totalPermissions = totalGatorPermissions + totalSitesConnections;
  const {
    loading: gatorPermissionsLoading
  } = (0, _useGatorPermissions.useGatorPermissions)();
  const handlePermissionGroupNameClick = async permissionGroupName => {
    switch (permissionGroupName) {
      case 'sites':
        history.push(_routes.PERMISSIONS);
        break;
      case 'token-transfer':
        history.push(_routes.TOKEN_TRANSFER_ROUTE);
        break;
      default:
        console.error('Invalid permission group name:', permissionGroupName);
        break;
    }
  };
  const renderCategoryHeader = title => {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Row,
      alignItems: _designSystem.AlignItems.center,
      width: _designSystem.BlockSize.Full,
      backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
      padding: [2, 4],
      marginTop: 4
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMdMedium,
      color: _designSystem.TextColor.textAlternative,
      textAlign: _designSystem.TextAlign.Left
    }, title.toUpperCase()));
  };
  const renderPermissionsList = () => {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      "data-testid": "permission-list",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      alignItems: _designSystem.AlignItems.baseline,
      width: _designSystem.BlockSize.Full,
      backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
      padding: 4,
      gap: 4
    }, totalSitesConnections > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, renderCategoryHeader(t('sites')), /*#__PURE__*/_react.default.createElement(_permissionListItem.PermissionListItem, {
      total: totalSitesConnections,
      permissionGroupName: t('sites'),
      onClick: () => handlePermissionGroupNameClick('sites')
    })), totalGatorPermissions > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, renderCategoryHeader(t('assets')), /*#__PURE__*/_react.default.createElement(_permissionListItem.PermissionListItem, {
      total: totalGatorPermissions,
      permissionGroupName: t('tokenTransfer'),
      onClick: () => handlePermissionGroupNameClick('token-transfer')
    })));
  };
  const renderPageContent = () => {
    if (gatorPermissionsLoading) {
      return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        display: _designSystem.Display.Flex,
        flexDirection: _designSystem.FlexDirection.Column,
        justifyContent: _designSystem.JustifyContent.center,
        alignItems: _designSystem.AlignItems.center,
        height: _designSystem.BlockSize.Full,
        gap: 2,
        padding: 4
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
        name: _componentLibrary.IconName.Loading,
        color: _designSystem.IconColor.iconMuted,
        size: _componentLibrary.IconSize.Lg,
        style: {
          animation: 'spin 1.2s linear infinite'
        }
      }));
    }
    if (totalPermissions > 0) {
      return renderPermissionsList();
    }
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      "data-testid": "no-connections",
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      justifyContent: _designSystem.JustifyContent.center,
      height: _designSystem.BlockSize.Full,
      gap: 2,
      padding: 4
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMdMedium,
      backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
      textAlign: _designSystem.TextAlign.Center
    }, t('permissionsPageEmptyContent')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMd,
      color: _designSystem.TextColor.textAlternative,
      backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
      textAlign: _designSystem.TextAlign.Center
    }, t('permissionsPageEmptySubContent')));
  };
  return /*#__PURE__*/_react.default.createElement(_page.Page, {
    className: "main-container",
    "data-testid": "gator-permissions-page",
    key: "gator-permissions-page"
  }, /*#__PURE__*/_react.default.createElement(_page.Header, {
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    startAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      ariaLabel: t('back'),
      iconName: _componentLibrary.IconName.ArrowLeft,
      className: "connections-header__start-accessory",
      color: _designSystem.IconColor.iconDefault,
      onClick: () => history.push(_routes.DEFAULT_ROUTE),
      size: _componentLibrary.ButtonIconSize.Sm
    })
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "span",
    variant: _designSystem.TextVariant.headingMd,
    textAlign: _designSystem.TextAlign.Center,
    "data-testid": "gator-permissions-page-title"
  }, t('permissions'))), /*#__PURE__*/_react.default.createElement(_page.Content, {
    padding: 0
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    ref: headerRef
  }), renderPageContent()));
};
exports.GatorPermissionsPage = GatorPermissionsPage;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\gator-permissions\\gator-permissions-page.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\gator-permissions\\helper.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Cgator-permissions%5Chelper.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractNetworkName = void 0;
/**
 * Extracts the network name from the network configuration.
 *
 * @param networks - The network configurations.
 * @param chainId - The chain ID.
 * @param isFullNetworkName - Whether to return the full network name or not.
 * @returns The network name.
 */
const extractNetworkName = (networks, chainId, isFullNetworkName = false) => {
  const network = networks[chainId];
  if (network !== null && network !== void 0 && network.name && (network === null || network === void 0 ? void 0 : network.name.trim()) !== '') {
    return isFullNetworkName ? network.name : `networkName${network.name.trim().split(' ')[0]}`;
  }
  return 'unknownNetworkForGatorPermissions';
};
exports.extractNetworkName = extractNetworkName;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\gator-permissions\\helper.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\gator-permissions\\review-permissions\\review-gator-permissions-page.tsx", {"../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\index.ts","../helper":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\gator-permissions\\helper.ts","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Cgator-permissions%5Creview-permissions%5Creview-gator-permissions-page.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReviewGatorPermissionsPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _designSystemReact = require("@metamask/design-system-react");
var _page = require("../../page");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../../hooks/useI18nContext");
var _helper = require("../helper");
var _selectors = require("../../../../../selectors");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const ReviewGatorPermissionsPage = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    chainId
  } = (0, _reactRouterDom.useParams)();
  const [, evmNetworks] = (0, _reactRedux.useSelector)(_selectors.getMultichainNetworkConfigurationsByChainId);
  const getNetworkNameForChainId = () => {
    if (!chainId) {
      return t('unknownNetworkForGatorPermissions');
    }
    const networkNameKey = (0, _helper.extractNetworkName)(evmNetworks, chainId);
    const networkName = t(networkNameKey);

    // If the translation key doesn't exist (returns the same key), fall back to the full network name
    if (!networkName || networkName === networkNameKey) {
      return (0, _helper.extractNetworkName)(evmNetworks, chainId, true);
    }
    return networkName;
  };
  return /*#__PURE__*/_react.default.createElement(_page.Page, {
    className: "main-container",
    "data-testid": "review-gator-permissions-page",
    key: "review-gator-permissions-page"
  }, /*#__PURE__*/_react.default.createElement(_page.Header, {
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    startAccessory: /*#__PURE__*/_react.default.createElement(_designSystemReact.ButtonIcon, {
      ariaLabel: t('back'),
      iconName: _designSystemReact.IconName.ArrowLeft,
      className: "connections-header__start-accessory",
      color: _designSystemReact.IconColor.IconDefault,
      onClick: () => history.goBack(),
      size: _designSystemReact.ButtonIconSize.Sm
    })
  }, /*#__PURE__*/_react.default.createElement(_designSystemReact.Text, {
    variant: _designSystemReact.TextVariant.HeadingMd,
    textAlign: _designSystemReact.TextAlign.Center,
    "data-testid": "review-gator-permissions-page-title"
  }, getNetworkNameForChainId())));
};
exports.ReviewGatorPermissionsPage = ReviewGatorPermissionsPage;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\gator-permissions\\review-permissions\\review-gator-permissions-page.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\gator-permissions\\token-transfer\\token-transfer-page.tsx", {"../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../../selectors/gator-permissions/gator-permissions":"D:\\code\\v\\metamask-extension\\ui\\selectors\\gator-permissions\\gator-permissions.ts","../../page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\index.ts","../components":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\gator-permissions\\components\\index.ts","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Cgator-permissions%5Ctoken-transfer%5Ctoken-transfer-page.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TokenTransferPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _designSystemReact = require("@metamask/design-system-react");
var _page = require("../../page");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../../hooks/useI18nContext");
var _routes = require("../../../../../helpers/constants/routes");
var _components = require("../components");
var _gatorPermissions = require("../../../../../selectors/gator-permissions/gator-permissions");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const TokenTransferPage = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const permissionGroupName = 'token-transfer';
  const permissionGroupDetails = (0, _reactRedux.useSelector)(state => (0, _gatorPermissions.getPermissionGroupDetails)(state, permissionGroupName));
  const handlePermissionGroupItemClick = chainId => {
    history.push(`${_routes.REVIEW_GATOR_PERMISSIONS_ROUTE}/${chainId}/${permissionGroupName}`);
  };
  const renderPageContent = () => permissionGroupDetails.map(({
    chainId,
    total
  }) => {
    const text = total === 1 ? t('tokenPermissionCount', [total]) : t('tokenPermissionsCount', [total]);
    return /*#__PURE__*/_react.default.createElement(_components.PermissionGroupListItem, {
      "data-testid": "permission-group-list-item",
      key: chainId,
      chainId: chainId,
      text: text,
      onClick: () => handlePermissionGroupItemClick(chainId)
    });
  });
  return /*#__PURE__*/_react.default.createElement(_page.Page, {
    className: "main-container",
    "data-testid": "token-transfer-page",
    key: "token-transfer-page"
  }, /*#__PURE__*/_react.default.createElement(_page.Header, {
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    startAccessory: /*#__PURE__*/_react.default.createElement(_designSystemReact.ButtonIcon, {
      ariaLabel: t('back'),
      iconName: _designSystemReact.IconName.ArrowLeft,
      className: "connections-header__start-accessory",
      color: _designSystemReact.IconColor.IconDefault,
      onClick: () => history.push(_routes.GATOR_PERMISSIONS),
      size: _designSystemReact.ButtonIconSize.Sm
    })
  }, /*#__PURE__*/_react.default.createElement(_designSystemReact.Text, {
    variant: _designSystemReact.TextVariant.HeadingMd,
    textAlign: _designSystemReact.TextAlign.Center,
    "data-testid": "token-transfer-page-title"
  }, t('tokenTransfer'))), /*#__PURE__*/_react.default.createElement(_page.Content, {
    padding: 0
  }, permissionGroupDetails.length > 0 ? renderPageContent() : /*#__PURE__*/_react.default.createElement(_designSystemReact.Box, {
    "data-testid": "no-connections",
    flexDirection: _designSystemReact.BoxFlexDirection.Column,
    justifyContent: _designSystemReact.BoxJustifyContent.Center,
    gap: 2,
    padding: 4
  }, /*#__PURE__*/_react.default.createElement(_designSystemReact.Text, {
    variant: _designSystemReact.TextVariant.BodyMd,
    textAlign: _designSystemReact.TextAlign.Center
  }, t('permissionsPageEmptyContent')), /*#__PURE__*/_react.default.createElement(_designSystemReact.Text, {
    variant: _designSystemReact.TextVariant.BodyMd,
    color: _designSystemReact.TextColor.TextAlternative,
    textAlign: _designSystemReact.TextAlign.Center
  }, t('permissionsPageEmptySubContent')))));
};
exports.TokenTransferPage = TokenTransferPage;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\gator-permissions\\token-transfer\\token-transfer-page.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\components\\content\\content.tsx", {"../../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Cpage%5Ccomponents%5Ccontent%5Ccontent.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Content = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _componentLibrary = require("../../../../../component-library");
var _designSystem = require("../../../../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
// TODO: Convert to a `type` in a future major version.
// eslint-disable-next-line @typescript-eslint/consistent-type-definitions

const Content = ({
  children,
  className = '',
  ...props
}) => {
  const styles = {
    overflow: 'auto',
    scrollbarColor: 'var(--color-icon-muted) transparent'
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, _extends({
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    width: _designSystem.BlockSize.Full,
    padding: 4,
    paddingTop: 0,
    height: _designSystem.BlockSize.Full,
    className: (0, _classnames.default)('multichain-page-content', className),
    style: styles
  }, props), children);
};
exports.Content = Content;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\page\\components\\content\\content.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\components\\content\\index.ts", {"./content":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\components\\content\\content.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Cpage%5Ccomponents%5Ccontent%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "Content", {
  enumerable: true,
  get: function () {
    return _content.Content;
  }
});
var _content = require("./content");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\page\\components\\content\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\components\\footer\\footer.tsx", {"../../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Cpage%5Ccomponents%5Cfooter%5Cfooter.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Footer = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _componentLibrary = require("../../../../../component-library");
var _designSystem = require("../../../../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
// TODO: Convert to a `type` in a future major version.
// eslint-disable-next-line @typescript-eslint/consistent-type-definitions

const Footer = ({
  children,
  className = '',
  ...props
}) => {
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, _extends({
    padding: 4,
    display: _designSystem.Display.Flex,
    width: _designSystem.BlockSize.Full,
    gap: 4,
    className: (0, _classnames.default)('multichain-page-footer', className)
  }, props), children);
};
exports.Footer = Footer;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\page\\components\\footer\\footer.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\components\\footer\\index.ts", {"./footer":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\components\\footer\\footer.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Cpage%5Ccomponents%5Cfooter%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "Footer", {
  enumerable: true,
  get: function () {
    return _footer.Footer;
  }
});
var _footer = require("./footer");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\page\\components\\footer\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\components\\header\\header.tsx", {"../../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Cpage%5Ccomponents%5Cheader%5Cheader.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Header = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _componentLibrary = require("../../../../../component-library");
var _designSystem = require("../../../../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
// TODO: Convert to a `type` in a future major version.
// eslint-disable-next-line @typescript-eslint/consistent-type-definitions

const Header = ({
  children,
  endAccessory = null,
  startAccessory = null,
  className = '',
  textProps,
  ...props
}) => {
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.HeaderBase, _extends({
    padding: 4,
    width: _designSystem.BlockSize.Full,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.center,
    className: (0, _classnames.default)('multichain-page-header', className),
    startAccessory: startAccessory,
    endAccessory: endAccessory
  }, props), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, _extends({
    display: _designSystem.Display.Block,
    variant: _designSystem.TextVariant.bodyMdBold,
    textAlign: _designSystem.TextAlign.Center,
    paddingInlineStart: 2,
    paddingInlineEnd: 2,
    ellipsis: true
  }, textProps), children));
};
exports.Header = Header;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\page\\components\\header\\header.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\components\\header\\index.ts", {"./header":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\components\\header\\header.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Cpage%5Ccomponents%5Cheader%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "Header", {
  enumerable: true,
  get: function () {
    return _header.Header;
  }
});
var _header = require("./header");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\page\\components\\header\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\index.ts", {"./components/content":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\components\\content\\index.ts","./components/footer":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\components\\footer\\index.ts","./components/header":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\components\\header\\index.ts","./page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\page.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Cpage%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "Content", {
  enumerable: true,
  get: function () {
    return _content.Content;
  }
});
Object.defineProperty(exports, "Footer", {
  enumerable: true,
  get: function () {
    return _footer.Footer;
  }
});
Object.defineProperty(exports, "Header", {
  enumerable: true,
  get: function () {
    return _header.Header;
  }
});
Object.defineProperty(exports, "Page", {
  enumerable: true,
  get: function () {
    return _page.Page;
  }
});
var _page = require("./page");
var _header = require("./components/header");
var _content = require("./components/content");
var _footer = require("./components/footer");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\page\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\page.tsx", {"../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../pages/routes/utils":"D:\\code\\v\\metamask-extension\\ui\\pages\\routes\\utils.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Cpage%5Cpage.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Page = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _reactRouterDom = require("react-router-dom");
var _componentLibrary = require("../../../component-library");
var _designSystem = require("../../../../helpers/constants/design-system");
var _utils = require("../../../../pages/routes/utils");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
// TODO: Convert to a `type` in a future major version.
// eslint-disable-next-line @typescript-eslint/consistent-type-definitions

const Page = ({
  children,
  className = '',
  ...props
}) => {
  const location = (0, _reactRouterDom.useLocation)();
  const hasAppHeader = location !== null && location !== void 0 && location.pathname ? !(0, _utils.hideAppHeader)({
    location
  }) : true;
  const classNames = (0, _classnames.default)('multichain-page', {
    'multichain-page--has-app-header': hasAppHeader
  });
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    width: _designSystem.BlockSize.Full,
    height: _designSystem.BlockSize.Full,
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    justifyContent: _designSystem.JustifyContent.center,
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    className: classNames,
    "data-testid": "multichain-page"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, _extends({
    width: _designSystem.BlockSize.Full,
    height: _designSystem.BlockSize.Full,
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    className: (0, _classnames.default)('multichain-page__inner-container', className)
  }, props), children));
};
exports.Page = Page;
Page.propTypes = {
  className: _propTypes.default.string,
  children: _propTypes.default.node
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\page\\page.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\permissions-page\\connection-list-item.js", {"../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","../../../app/snaps/snap-icon":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\snaps\\snap-icon\\index.ts","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Cpermissions-page%5Cconnection-list-item.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectionListItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _permissionController = require("@metamask/permission-controller");
var _reactRedux = require("react-redux");
var _designSystem = require("../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _componentLibrary = require("../../../component-library");
var _util = require("../../../../helpers/utils/util");
var _snapIcon = require("../../../app/snaps/snap-icon");
var _selectors = require("../../../../selectors");
var _accountTree = require("../../../../selectors/multichain-accounts/account-tree");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConnectionListItem = ({
  connection,
  onClick
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const isSnap = connection.subjectType === _permissionController.SubjectType.Snap;
  const permittedChains = (0, _reactRedux.useSelector)(state => (0, _selectors.getAllPermittedChainsForSelectedTab)(state, connection.origin));
  const accountGroups = (0, _reactRedux.useSelector)(_accountTree.getAccountGroupWithInternalAccounts);
  const isState2Enabled = (0, _reactRedux.useSelector)(_selectors.getIsMultichainAccountsState2Enabled);
  const accountAddressSet = (0, _react.useMemo)(() => {
    if (!isState2Enabled) {
      return null;
    }
    const set = new Set();
    (accountGroups ?? []).forEach(group => {
      (group.accounts ?? []).forEach(account => {
        set.add(account.address);
      });
    });
    return set;
  }, [isState2Enabled, accountGroups]);
  const accountsToShow = (0, _react.useMemo)(() => {
    var _connection$addresses2;
    if (!isState2Enabled) {
      var _connection$addresses;
      return ((_connection$addresses = connection.addresses) === null || _connection$addresses === void 0 ? void 0 : _connection$addresses.length) ?? 0;
    }
    if (!accountAddressSet || !((_connection$addresses2 = connection.addresses) !== null && _connection$addresses2 !== void 0 && _connection$addresses2.length)) {
      return 0;
    }
    let count = 0;
    for (const address of connection.addresses) {
      if (accountAddressSet.has(address)) {
        count += 1;
      }
    }
    return count;
  }, [isState2Enabled, accountAddressSet, connection.addresses]);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    "data-testid": "connection-list-item",
    as: "button",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    alignItems: _designSystem.AlignItems.baseline,
    width: _designSystem.BlockSize.Full,
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    onClick: onClick,
    padding: 4,
    gap: 4,
    className: "multichain-connection-list-item"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    style: {
      alignSelf: 'center'
    }
  }, isSnap ? /*#__PURE__*/_react.default.createElement(_snapIcon.SnapIcon, {
    className: "connection-list-item__snap-avatar",
    snapId: connection.id,
    avatarSize: _componentLibrary.IconSize.Md
  }) : /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarFavicon, {
    "data-testid": "connection-list-item__avatar-favicon",
    src: connection.iconUrl
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    width: _designSystem.BlockSize.FiveTwelfths,
    style: {
      alignSelf: 'center',
      flexGrow: '1'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    textAlign: _designSystem.TextAlign.Left,
    ellipsis: true
  }, isSnap ? connection.packageName : (0, _util.getURLHost)(connection.origin)), isSnap ? null : /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    alignItems: _designSystem.AlignItems.center,
    gap: 1
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "span",
    width: _designSystem.BlockSize.Max,
    color: _designSystem.TextColor.textAlternative,
    variant: _designSystem.TextVariant.bodyMd
  }, accountsToShow, ' ', accountsToShow === 1 ? t('accountSmallCase') : t('accountsSmallCase'), "\u2022\xA0", permittedChains.length, " ", t('networksSmallCase')))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.flexEnd,
    alignItems: _designSystem.AlignItems.center,
    style: {
      flex: '1',
      alignSelf: 'center'
    },
    gap: 2
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    display: _designSystem.Display.Flex,
    name: _componentLibrary.IconName.ArrowRight,
    color: _designSystem.IconColor.iconDefault,
    size: _componentLibrary.IconSize.Sm,
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault
  })));
};
exports.ConnectionListItem = ConnectionListItem;
ConnectionListItem.propTypes = {
  /**
   * The connection data to display
   */
  connection: _propTypes.default.object.isRequired,
  /**
   * The function to call when the connection is clicked
   */
  onClick: _propTypes.default.func.isRequired
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\permissions-page\\connection-list-item.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\permissions-page\\permissions-page.js", {"../../../../../shared/modules/environment":"D:\\code\\v\\metamask-extension\\shared\\modules\\environment.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\index.ts","./connection-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\permissions-page\\connection-list-item.js","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Cpermissions-page%5Cpermissions-page.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PermissionsPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _snapsUtils = require("@metamask/snaps-utils");
var _page = require("../page");
var _componentLibrary = require("../../../component-library");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _designSystem = require("../../../../helpers/constants/design-system");
var _routes = require("../../../../helpers/constants/routes");
var _selectors = require("../../../../selectors");
var _environment = require("../../../../../shared/modules/environment");
var _connectionListItem = require("./connection-list-item");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PermissionsPage = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const headerRef = (0, _react.useRef)();
  const [totalConnections, setTotalConnections] = (0, _react.useState)(0);
  const sitesConnectionsList = (0, _reactRedux.useSelector)(_selectors.getConnectedSitesListWithNetworkInfo);
  (0, _react.useEffect)(() => {
    setTotalConnections(Object.keys(sitesConnectionsList).length);
  }, [sitesConnectionsList]);
  const handleConnectionClick = connection => {
    const hostName = connection.origin;
    const safeEncodedHost = encodeURIComponent(hostName);
    history.push(`${_routes.REVIEW_PERMISSIONS}/${safeEncodedHost}`);
  };
  const renderConnectionsList = connectionList => Object.entries(connectionList).map(([itemKey, connection]) => {
    const isSnap = (0, _snapsUtils.isSnapId)(connection.origin);
    return isSnap ? null : /*#__PURE__*/_react.default.createElement(_connectionListItem.ConnectionListItem, {
      "data-testid": "connection-list-item",
      key: itemKey,
      connection: connection,
      onClick: () => handleConnectionClick(connection)
    });
  });
  return /*#__PURE__*/_react.default.createElement(_page.Page, {
    className: "main-container",
    "data-testid": "permissions-page"
  }, /*#__PURE__*/_react.default.createElement(_page.Header, {
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    startAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      ariaLabel: t('back'),
      iconName: _componentLibrary.IconName.ArrowLeft,
      className: "connections-header__start-accessory",
      color: _designSystem.Color.iconDefault,
      onClick: () => history.push((0, _environment.isGatorPermissionsRevocationFeatureEnabled)() ? _routes.GATOR_PERMISSIONS : _routes.DEFAULT_ROUTE),
      size: _componentLibrary.ButtonIconSize.Sm,
      "data-testid": "permissions-page-back"
    })
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "span",
    variant: _designSystem.TextVariant.headingMd,
    textAlign: _designSystem.TextAlign.Center,
    "data-testid": "permissions-page-title"
  }, (0, _environment.isGatorPermissionsRevocationFeatureEnabled)() ? t('sites') : t('permissions'))), /*#__PURE__*/_react.default.createElement(_page.Content, {
    padding: 0
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    ref: headerRef
  }), totalConnections > 0 ? renderConnectionsList(sitesConnectionsList) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    "data-testid": "no-connections",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    justifyContent: _designSystem.JustifyContent.center,
    height: _designSystem.BlockSize.Full,
    gap: 2,
    padding: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    textAlign: _designSystem.TextAlign.Center
  }, t('permissionsPageEmptyContent')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    color: _designSystem.TextColor.textAlternative,
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    textAlign: _designSystem.TextAlign.Center
  }, t('permissionsPageEmptySubContent')))));
};
exports.PermissionsPage = PermissionsPage;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\permissions-page\\permissions-page.js",}]],[],{})

//# sourceMappingURL=data:application/json;charset=utf8;base64,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