LavaPack.loadBundle([
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\review-permissions-page\\review-permissions-page.tsx", {"../..":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../disconnect-all-modal/disconnect-all-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\disconnect-all-modal\\disconnect-all-modal.tsx","../../permissions-header/permissions-header":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\permissions-header\\permissions-header.tsx","../connections/components/no-connection":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\connections\\components\\no-connection.tsx","../page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\index.ts","./site-cell/site-cell":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\review-permissions-page\\site-cell\\site-cell.tsx","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Creview-permissions-page%5Creview-permissions-page.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReviewPermissions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
var _designSystem = require("../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../hooks/useI18nContext");
var _networks = require("../../../../../shared/modules/selectors/networks");
var _selectors = require("../../../../selectors");
var _actions = require("../../../../store/actions");
var _componentLibrary = require("../../../component-library");
var _ = require("../..");
var _noConnection = require("../connections/components/no-connection");
var _page = require("../page");
var _routes = require("../../../../helpers/constants/routes");
var _disconnectAllModal = require("../../disconnect-all-modal/disconnect-all-modal");
var _permissionsHeader = require("../../permissions-header/permissions-header");
var _network = require("../../../../../shared/constants/network");
var _trace = require("../../../../../shared/lib/trace");
var _siteCell = require("./site-cell/site-cell");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ReviewPermissions = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const history = (0, _reactRouterDom.useHistory)();
  const urlParams = (0, _reactRouterDom.useParams)();
  // @ts-expect-error TODO: Fix this type error by handling undefined parameters
  const securedOrigin = decodeURIComponent(urlParams.origin);
  const [showAccountToast, setShowAccountToast] = (0, _react.useState)(false);
  const [showNetworkToast, setShowNetworkToast] = (0, _react.useState)(false);
  const [showDisconnectAllModal, setShowDisconnectAllModal] = (0, _react.useState)(false);
  const activeTabOrigin = securedOrigin;
  const showPermittedNetworkToastOpen = (0, _reactRedux.useSelector)(_selectors.getShowPermittedNetworkToastOpen);
  (0, _react.useEffect)(() => {
    if (showPermittedNetworkToastOpen) {
      setShowNetworkToast(showPermittedNetworkToastOpen);
      dispatch((0, _actions.hidePermittedNetworkToast)());
    }
  }, [showPermittedNetworkToastOpen]);
  const requestAccountsAndChainPermissions = async () => {
    const requestId = await dispatch((0, _actions.requestAccountsAndChainPermissionsWithId)(activeTabOrigin));
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31893
    // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
    history.push(`${_routes.CONNECT_ROUTE}/${requestId}`);
  };

  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  const subjectMetadata = (0, _reactRedux.useSelector)(_selectors.getConnectedSitesList);
  const connectedSubjectsMetadata = subjectMetadata[activeTabOrigin];
  const subjects = (0, _reactRedux.useSelector)(_selectors.getPermissionSubjects);
  const disconnectAllPermissions = () => {
    const subject = subjects[activeTabOrigin];
    if (subject) {
      const permissionMethodNames = Object.values(subject.permissions).map(({
        parentCapability
      }) => parentCapability);
      if (permissionMethodNames.length > 0) {
        const permissionsRecord = {
          [activeTabOrigin]: permissionMethodNames
        };
        dispatch((0, _actions.removePermissionsFor)(permissionsRecord));
      }
    }
    dispatch((0, _actions.hidePermittedNetworkToast)());
  };
  const networkConfigurationsByCaipChainId = (0, _reactRedux.useSelector)(_networks.getAllNetworkConfigurationsByCaipChainId);
  const [nonTestNetworks, testNetworks] = (0, _react.useMemo)(() => Object.entries(networkConfigurationsByCaipChainId).reduce(([nonTestNetworksList, testNetworksList], [chainId, network]) => {
    const caipChainId = chainId;
    const isTestNetwork = _network.CAIP_FORMATTED_EVM_TEST_CHAINS.includes(caipChainId);
    (isTestNetwork ? testNetworksList : nonTestNetworksList).push({
      ...network,
      caipChainId
    });
    return [nonTestNetworksList, testNetworksList];
  }, [[], []]), [networkConfigurationsByCaipChainId]);
  const connectedChainIds = (0, _reactRedux.useSelector)(state => (0, _selectors.getAllPermittedChainsForSelectedTab)(state, activeTabOrigin));
  const handleSelectChainIds = async chainIds => {
    if (chainIds.length === 0) {
      setShowDisconnectAllModal(true);
      return;
    }
    dispatch((0, _actions.setPermittedChains)(activeTabOrigin, chainIds));
    setShowNetworkToast(true);
  };
  const allAccounts = (0, _reactRedux.useSelector)(_selectors.getUpdatedAndSortedAccountsWithCaipAccountId);
  const nonRemappedConnectedAccountAddresses = (0, _reactRedux.useSelector)(state => (0, _selectors.getAllPermittedAccountsForSelectedTab)(state, activeTabOrigin));

  // This remaps EVM caip account addresses to match the 'eip155:0'
  // value that is currently set in InternalAccount.scopes[0] for
  // EOA EVM accounts. This logic will need to be updated to
  // support non EOA accounts.
  const connectedAccountAddresses = (0, _lodash.uniq)(nonRemappedConnectedAccountAddresses.map(caipAccountId => {
    const {
      address,
      chain: {
        namespace
      }
    } = (0, _utils.parseCaipAccountId)(caipAccountId);
    if (namespace === _utils.KnownCaipNamespace.Eip155) {
      // this is very hacky, but it works for now
      return `eip155:0:${address}`;
    }
    return caipAccountId;
  }));
  const handleSelectAccountAddresses = caipAccountIds => {
    if (caipAccountIds.length === 0) {
      setShowDisconnectAllModal(true);
      return;
    }
    dispatch((0, _actions.setPermittedAccounts)(activeTabOrigin, caipAccountIds));
    setShowAccountToast(true);
  };
  const hideAllToasts = () => {
    setShowAccountToast(false);
    setShowNetworkToast(false);
  };
  return /*#__PURE__*/_react.default.createElement(_page.Page, {
    "data-testid": "connections-page",
    className: "main-container connections-page"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_permissionsHeader.PermissionsHeader, {
    securedOrigin: securedOrigin,
    connectedSubjectsMetadata: connectedSubjectsMetadata
  }), /*#__PURE__*/_react.default.createElement(_page.Content, {
    padding: 0
  }, connectedAccountAddresses.length > 0 ? /*#__PURE__*/_react.default.createElement(_siteCell.SiteCell, {
    nonTestNetworks: nonTestNetworks,
    testNetworks: testNetworks,
    accounts: allAccounts,
    onSelectAccountAddresses: handleSelectAccountAddresses
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    ,
    onSelectChainIds: handleSelectChainIds,
    selectedAccountAddresses: connectedAccountAddresses,
    selectedChainIds: connectedChainIds,
    hideAllToasts: hideAllToasts
  }) : /*#__PURE__*/_react.default.createElement(_noConnection.NoConnectionContent, null), showDisconnectAllModal ? /*#__PURE__*/_react.default.createElement(_disconnectAllModal.DisconnectAllModal, {
    type: _disconnectAllModal.DisconnectType.Account,
    hostname: activeTabOrigin,
    onClose: () => setShowDisconnectAllModal(false),
    onClick: () => {
      (0, _trace.trace)({
        name: _trace.TraceName.DisconnectAllModal
      });
      disconnectAllPermissions();
      setShowDisconnectAllModal(false);
      (0, _trace.endTrace)({
        name: _trace.TraceName.DisconnectAllModal
      });
    }
  }) : null), /*#__PURE__*/_react.default.createElement(_page.Footer, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, connectedAccountAddresses.length > 0 ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    width: _designSystem.BlockSize.Full,
    gap: 2,
    alignItems: _designSystem.AlignItems.center
  }, showAccountToast ? /*#__PURE__*/_react.default.createElement(_.ToastContainer, null, /*#__PURE__*/_react.default.createElement(_.Toast, {
    text: t('accountPermissionToast'),
    onClose: () => setShowAccountToast(false),
    startAdornment: /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarFavicon, {
      name: connectedSubjectsMetadata === null || connectedSubjectsMetadata === void 0 ? void 0 : connectedSubjectsMetadata.name,
      size: _componentLibrary.AvatarFaviconSize.Sm,
      src: connectedSubjectsMetadata === null || connectedSubjectsMetadata === void 0 ? void 0 : connectedSubjectsMetadata.iconUrl
    })
  })) : null, showNetworkToast ? /*#__PURE__*/_react.default.createElement(_.ToastContainer, null, /*#__PURE__*/_react.default.createElement(_.Toast, {
    text: t('networkPermissionToast'),
    onClose: () => setShowNetworkToast(false),
    startAdornment: /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarFavicon, {
      name: connectedSubjectsMetadata === null || connectedSubjectsMetadata === void 0 ? void 0 : connectedSubjectsMetadata.name,
      size: _componentLibrary.AvatarFaviconSize.Sm,
      src: connectedSubjectsMetadata === null || connectedSubjectsMetadata === void 0 ? void 0 : connectedSubjectsMetadata.iconUrl
    })
  })) : null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    size: _componentLibrary.ButtonSize.Lg,
    block: true,
    variant: _componentLibrary.ButtonVariant.Secondary,
    startIconName: _componentLibrary.IconName.Logout,
    danger: true,
    onClick: () => setShowDisconnectAllModal(true),
    "data-test-id": "disconnect-all"
  }, t('disconnect'))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, connectedAccountAddresses.length > 0 ? /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonPrimary, {
    size: _componentLibrary.ButtonPrimarySize.Lg,
    block: true,
    "data-test-id": "no-connections-button"
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    ,
    onClick: requestAccountsAndChainPermissions
  }, t('connectAccounts')) : null)))));
};
exports.ReviewPermissions = ReviewPermissions;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\review-permissions-page\\review-permissions-page.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\review-permissions-page\\site-cell\\site-cell-connection-list-item.js", {"../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Creview-permissions-page%5Csite-cell%5Csite-cell-connection-list-item.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SiteCellConnectionListItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _designSystem = require("../../../../../helpers/constants/design-system");
var _componentLibrary = require("../../../../component-library");
var _useI18nContext = require("../../../../../hooks/useI18nContext");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const SiteCellConnectionListItem = ({
  title,
  iconName,
  connectedMessage,
  unconnectedMessage,
  isConnectFlow,
  onClick,
  content,
  paddingTopValue,
  paddingBottomValue
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    "data-testid": "site-cell-connection-list-item",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    alignItems: _designSystem.AlignItems.baseline,
    width: _designSystem.BlockSize.Full,
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    gap: 4,
    className: "multichain-connection-list-item",
    paddingTop: paddingTopValue,
    paddingBottom: paddingBottomValue
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarIcon, {
    marginTop: 1,
    iconName: iconName,
    size: _componentLibrary.AvatarIconSize.Md,
    color: _designSystem.IconColor.iconAlternative,
    backgroundColor: _designSystem.BackgroundColor.backgroundMuted
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    width: _designSystem.BlockSize.FiveTwelfths,
    style: {
      alignSelf: 'center',
      flexGrow: 1
    },
    gap: 1
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    textAlign: _designSystem.TextAlign.Left
  }, title), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    alignItems: _designSystem.AlignItems.center,
    gap: 1
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "span",
    width: _designSystem.BlockSize.Max,
    color: _designSystem.TextColor.textAlternative,
    variant: _designSystem.TextVariant.bodySm,
    ellipsis: true
  }, isConnectFlow ? unconnectedMessage : connectedMessage), content)), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    onClick: () => onClick(),
    "data-testid": "edit"
  }, t('edit')));
};
exports.SiteCellConnectionListItem = SiteCellConnectionListItem;
SiteCellConnectionListItem.propTypes = {
  /**
   * Title that should be displayed in the connection list item
   */
  title: _propTypes.default.string,
  /**
   * The name of the icon that should be passed to the AvatarIcon component
   */
  iconName: _propTypes.default.string,
  /**
   * The message that should be displayed when there are connected accounts
   */
  connectedMessage: _propTypes.default.string,
  /**
   * Padding Top Value to keep the padding between list items same
   */
  paddingTopValue: _propTypes.default.number,
  /**
   * Padding Bottom Value to keep the padding between list items same
   */
  paddingBottomValue: _propTypes.default.number,
  /**
   * The message that should be displayed when there are no connected accounts
   */
  unconnectedMessage: _propTypes.default.string,
  /**
   * If the component should show context related to adding a connection or editing one
   */
  isConnectFlow: _propTypes.default.bool,
  /**
   * Handler called when the edit button is clicked
   */
  onClick: _propTypes.default.func,
  /**
   * Components to display in the connection list item
   */
  content: _propTypes.default.node
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\review-permissions-page\\site-cell\\site-cell-connection-list-item.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\review-permissions-page\\site-cell\\site-cell-tooltip.js", {"../../..":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../avatar-group/avatar-group.types":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\avatar-group\\avatar-group.types.tsx","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-tippy":"D:\\code\\v\\metamask-extension\\node_modules\\react-tippy\\dist\\react-tippy.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Creview-permissions-page%5Csite-cell%5Csite-cell-tooltip.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SiteCellTooltip = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactTippy = require("react-tippy");
var _reactRedux = require("react-redux");
var _designSystemReact = require("@metamask/design-system-react");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _avatarGroup = require("../../../avatar-group/avatar-group.types");
var _ = require("../../..");
var _componentLibrary = require("../../../../component-library");
var _selectors = require("../../../../../selectors");
var _useI18nContext = require("../../../../../hooks/useI18nContext");
var _network = require("../../../../../../shared/constants/network");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const SiteCellTooltip = ({
  accounts,
  networks
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const AVATAR_GROUP_LIMIT = 4;
  const TOOLTIP_LIMIT = 4;
  const useBlockie = (0, _reactRedux.useSelector)(_selectors.getUseBlockie);
  const avatarAccountVariant = useBlockie ? _designSystemReact.AvatarAccountVariant.Blockies : _designSystemReact.AvatarAccountVariant.Jazzicon;
  const avatarAccountsData = accounts === null || accounts === void 0 ? void 0 : accounts.map(account => ({
    avatarValue: account.address
  }));
  const avatarNetworksData = networks === null || networks === void 0 ? void 0 : networks.map(network => ({
    avatarValue: _network.CHAIN_ID_TO_NETWORK_IMAGE_URL_MAP[network.chainId],
    symbol: network.name
  }));
  return /*#__PURE__*/_react.default.createElement(_reactTippy.Tooltip, {
    position: "bottom",
    html: /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      "data-test-id": "site-cell-tooltip"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column
    }, accounts === null || accounts === void 0 ? void 0 : accounts.slice(0, TOOLTIP_LIMIT).map(acc => {
      return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        display: _designSystem.Display.Flex,
        flexDirection: _designSystem.FlexDirection.Row,
        alignItems: _designSystem.AlignItems.center,
        textAlign: _designSystem.TextAlign.Left,
        key: acc.address,
        padding: 1,
        paddingInline: 2,
        gap: 2
      }, /*#__PURE__*/_react.default.createElement(_designSystemReact.AvatarAccount, {
        size: _designSystemReact.AvatarAccountSize.Xs,
        address: acc.address,
        variant: avatarAccountVariant,
        borderStyle: _designSystem.BorderStyle.none
      }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        color: _designSystem.TextColor.overlayInverse,
        variant: _designSystem.TextVariant.bodyMdMedium,
        "data-testid": "accounts-list-item-connected-account-name",
        ellipsis: true
      }, acc.metadata.name || acc.label));
    }), networks === null || networks === void 0 ? void 0 : networks.slice(0, TOOLTIP_LIMIT).map(network => {
      return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
        display: _designSystem.Display.Flex,
        flexDirection: _designSystem.FlexDirection.Row,
        alignItems: _designSystem.AlignItems.center,
        textAlign: _designSystem.TextAlign.Left,
        key: network.chainId,
        padding: 1,
        paddingInline: 2,
        gap: 2
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
        size: _componentLibrary.AvatarNetworkSize.Xs,
        src: _network.CHAIN_ID_TO_NETWORK_IMAGE_URL_MAP[network.chainId],
        name: network.name,
        borderStyle: _designSystem.BorderStyle.none
      }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        color: _designSystem.TextColor.overlayInverse,
        variant: _designSystem.TextVariant.bodyMdMedium,
        "data-testid": "accounts-list-item-connected-account-name",
        ellipsis: true
      }, network.name));
    }), (accounts === null || accounts === void 0 ? void 0 : accounts.length) > TOOLTIP_LIMIT || (networks === null || networks === void 0 ? void 0 : networks.length) > TOOLTIP_LIMIT ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      alignItems: _designSystem.AlignItems.center,
      textAlign: _designSystem.TextAlign.Left,
      paddingInline: 2
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      color: _designSystem.TextColor.textMuted,
      variant: _designSystem.TextVariant.bodyMdMedium,
      "data-testid": "accounts-list-item-plus-more-tooltip"
    }, (accounts === null || accounts === void 0 ? void 0 : accounts.length) > 0 ? t('moreAccounts', [(accounts === null || accounts === void 0 ? void 0 : accounts.length) - TOOLTIP_LIMIT]) : t('moreNetworks', [networks.length - TOOLTIP_LIMIT]))) : null)),
    arrow: true,
    offset: 0,
    delay: 50,
    duration: 0,
    size: "small",
    title: t('alertDisableTooltip'),
    trigger: "mouseenter focus",
    theme: "dark",
    tag: "div"
  }, (accounts === null || accounts === void 0 ? void 0 : accounts.length) > 0 && /*#__PURE__*/_react.default.createElement(_.AvatarGroup, {
    members: avatarAccountsData,
    limit: AVATAR_GROUP_LIMIT,
    avatarType: _avatarGroup.AvatarType.ACCOUNT,
    borderColor: _designSystem.BackgroundColor.backgroundDefault
  }), (networks === null || networks === void 0 ? void 0 : networks.length) > 0 && /*#__PURE__*/_react.default.createElement(_.AvatarGroup, {
    members: avatarNetworksData,
    limit: AVATAR_GROUP_LIMIT,
    avatarType: _avatarGroup.AvatarType.TOKEN
  }));
};
exports.SiteCellTooltip = SiteCellTooltip;
SiteCellTooltip.propTypes = {
  /**
   * An array of account objects to be displayed in the tooltip.
   * Each object should contain `address`, `label`, and `metadata.name`.
   */
  accounts: _propTypes.default.arrayOf(_propTypes.default.shape({
    address: _propTypes.default.string,
    // The unique address of the account.
    label: _propTypes.default.string,
    // Optional label for the account.
    metadata: _propTypes.default.shape({
      name: _propTypes.default.string // Account's name from metadata.
    })
  })),
  /**
   * An array of network objects to display in the tooltip.
   */
  networks: _propTypes.default.arrayOf(_propTypes.default.shape({
    chainId: _propTypes.default.string,
    // The unique chain ID of the network.
    name: _propTypes.default.string // The network's name.
  }))
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\review-permissions-page\\site-cell\\site-cell-tooltip.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\review-permissions-page\\site-cell\\site-cell.tsx", {"../../..":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../../../shared/modules/string-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\string-utils.ts","../../../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../app/preferred-avatar":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\preferred-avatar\\index.ts","../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","./site-cell-connection-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\review-permissions-page\\site-cell\\site-cell-connection-list-item.js","./site-cell-tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\review-permissions-page\\site-cell\\site-cell-tooltip.js","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Creview-permissions-page%5Csite-cell%5Csite-cell.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SiteCell = void 0;
var _react = _interopRequireWildcard(require("react"));
var _designSystemReact = require("@metamask/design-system-react");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../../hooks/useI18nContext");
var _componentLibrary = require("../../../../component-library");
var _preferredAvatar = require("../../../../app/preferred-avatar");
var _ = require("../../..");
var _metametrics = require("../../../../../contexts/metametrics");
var _metametrics2 = require("../../../../../../shared/constants/metametrics");
var _stringUtils = require("../../../../../../shared/modules/string-utils");
var _siteCellTooltip = require("./site-cell-tooltip");
var _siteCellConnectionListItem = require("./site-cell-connection-list-item");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Define types for networks, accounts, and other props

const SiteCell = ({
  nonTestNetworks,
  testNetworks,
  accounts,
  onSelectAccountAddresses,
  onSelectChainIds,
  selectedAccountAddresses,
  selectedChainIds,
  isConnectFlow,
  hideAllToasts = () => undefined
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const allNetworks = [...nonTestNetworks, ...testNetworks];
  const [showEditAccountsModal, setShowEditAccountsModal] = (0, _react.useState)(false);
  const [showEditNetworksModal, setShowEditNetworksModal] = (0, _react.useState)(false);
  const selectedAccounts = accounts.filter(({
    caipAccountId
  }) => selectedAccountAddresses.some(selectedAccountAddress => (0, _stringUtils.isEqualCaseInsensitive)(selectedAccountAddress, caipAccountId)));
  const selectedNetworks = allNetworks.filter(({
    caipChainId
  }) => selectedChainIds.includes(caipChainId));
  const selectedChainIdsLength = selectedChainIds.length;

  // Determine the messages for connected and not connected states
  const accountMessageConnectedState = selectedAccounts.length === 1 ? t('connectedWithAccountName', [selectedAccounts[0].metadata.name || selectedAccounts[0].label]) : t('connectedWithAccount', [selectedAccounts.length]);
  const accountMessageNotConnectedState = selectedAccounts.length === 1 ? t('requestingForAccount', [selectedAccounts[0].metadata.name || selectedAccounts[0].label]) : t('requestingFor');
  const networkMessageConnectedState = selectedChainIdsLength === 1 ? t('connectedWithNetworkName', [selectedNetworks[0].name]) : t('connectedWithNetwork', [selectedChainIdsLength]);
  const networkMessageNotConnectedState = selectedChainIdsLength === 1 ? t('requestingForNetwork', [selectedNetworks[0].name]) : t('requestingFor');
  const handleOpenAccountsModal = () => {
    hideAllToasts === null || hideAllToasts === void 0 || hideAllToasts();
    setShowEditAccountsModal(true);
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.Navigation,
      event: _metametrics2.MetaMetricsEventName.ViewPermissionedAccounts,
      properties: {
        location: 'Connect view (permissions tab), Permissions toast, Permissions (dapp)'
      }
    });
  };
  const handleOpenNetworksModal = () => {
    hideAllToasts === null || hideAllToasts === void 0 || hideAllToasts();
    setShowEditNetworksModal(true);
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.Navigation,
      event: _metametrics2.MetaMetricsEventName.ViewPermissionedNetworks,
      properties: {
        location: 'Connect view (permissions tab), Permissions toast, Permissions (dapp)'
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    padding: 4,
    gap: 4,
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    borderRadius: _designSystem.BorderRadius.LG
  }, /*#__PURE__*/_react.default.createElement(_siteCellConnectionListItem.SiteCellConnectionListItem, {
    title: t('accountsPermissionsTitle'),
    iconName: _componentLibrary.IconName.Wallet,
    connectedMessage: accountMessageConnectedState,
    unconnectedMessage: accountMessageNotConnectedState,
    isConnectFlow: isConnectFlow,
    onClick: handleOpenAccountsModal,
    paddingBottomValue: 2,
    paddingTopValue: 0,
    content:
    // Why this difference?
    selectedAccounts.length === 1 ? /*#__PURE__*/_react.default.createElement(_preferredAvatar.PreferredAvatar, {
      address: selectedAccounts[0].address,
      size: _designSystemReact.AvatarAccountSize.Xs
    }) : /*#__PURE__*/_react.default.createElement(_siteCellTooltip.SiteCellTooltip, {
      accounts: selectedAccounts
    })
  }), /*#__PURE__*/_react.default.createElement(_siteCellConnectionListItem.SiteCellConnectionListItem, {
    title: t('permission_walletSwitchEthereumChain'),
    iconName: _componentLibrary.IconName.Data,
    connectedMessage: networkMessageConnectedState,
    unconnectedMessage: networkMessageNotConnectedState,
    isConnectFlow: isConnectFlow,
    onClick: handleOpenNetworksModal,
    paddingTopValue: 2,
    paddingBottomValue: 0,
    content: /*#__PURE__*/_react.default.createElement(_siteCellTooltip.SiteCellTooltip, {
      networks: selectedNetworks
    })
  })), showEditAccountsModal && /*#__PURE__*/_react.default.createElement(_.EditAccountsModal, {
    accounts: accounts,
    defaultSelectedAccountAddresses: selectedAccountAddresses,
    onClose: () => setShowEditAccountsModal(false),
    onSubmit: onSelectAccountAddresses
  }), showEditNetworksModal && /*#__PURE__*/_react.default.createElement(_.EditNetworksModal, {
    nonTestNetworks: nonTestNetworks,
    testNetworks: testNetworks,
    defaultSelectedChainIds: selectedChainIds,
    onClose: () => setShowEditNetworksModal(false),
    onSubmit: onSelectChainIds
  }));
};
exports.SiteCell = SiteCell;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\review-permissions-page\\site-cell\\site-cell.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\account-picker.tsx", {"../../..":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../../../ducks/send":"D:\\code\\v\\metamask-extension\\ui\\ducks\\send\\index.js","../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../account-picker":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\account-picker\\index.js","./send-page-row":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\send-page-row.tsx","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Csend%5Ccomponents%5Caccount-picker.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SendPageAccountPicker = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _keyringApi = require("@metamask/keyring-api");
var _selectors = require("../../../../../selectors");
var _componentLibrary = require("../../../../component-library");
var _accountPicker = require("../../../account-picker");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _i18n = require("../../../../../contexts/i18n");
var _ = require("../../..");
var _send = require("../../../../../ducks/send");
var _sendPageRow = require("./send-page-row");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AccountListItemProps = {
  showOptions: false
};
const SendPageAccountPicker = () => {
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const internalAccount = (0, _reactRedux.useSelector)(_selectors.getSelectedInternalAccount);
  const [showAccountPicker, setShowAccountPicker] = (0, _react.useState)(false);
  const sendStage = (0, _reactRedux.useSelector)(_send.getSendStage);
  const disabled = _send.SEND_STAGES.EDIT === sendStage;
  const onAccountListMenuClose = (0, _react.useCallback)(() => {
    setShowAccountPicker(false);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_sendPageRow.SendPageRow, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Label, {
    paddingBottom: 2
  }, t('from'))), /*#__PURE__*/_react.default.createElement(_accountPicker.AccountPicker, {
    className: "multichain-send-page__account-picker",
    address: internalAccount.address,
    name: internalAccount.metadata.name,
    onClick: () => setShowAccountPicker(true),
    showAddress: true,
    borderColor: _designSystem.BorderColor.borderMuted,
    borderWidth: 1,
    paddingTop: 3,
    paddingBottom: 3,
    paddingLeft: 3,
    block: true,
    justifyContent: _designSystem.JustifyContent.flexStart,
    addressProps: {
      display: _designSystem.Display.Flex,
      textAlign: _designSystem.TextAlign.Start
    },
    labelProps: {
      style: {
        flexGrow: 1,
        textAlign: 'start'
      },
      paddingInlineStart: 1,
      className: 'multichain-send-page__account-picker__label'
    },
    textProps: {
      display: _designSystem.Display.Flex,
      width: _designSystem.BlockSize.Full
    },
    width: _designSystem.BlockSize.Full,
    disabled: disabled,
    "data-testid": "send-page-account-picker"
  }), showAccountPicker ? /*#__PURE__*/_react.default.createElement(_.AccountListMenu, {
    accountListItemProps: AccountListItemProps,
    showAccountCreation: false,
    onClose: onAccountListMenuClose,
    allowedAccountTypes: [_keyringApi.EthAccountType.Eoa, _keyringApi.EthAccountType.Erc4337]
  }) : null);
};
exports.SendPageAccountPicker = SendPageAccountPicker;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\send\\components\\account-picker.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\address-book.tsx", {"../../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../../../ducks/send":"D:\\code\\v\\metamask-extension\\ui\\ducks\\send\\index.js","../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../../../app/contact-list":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\contact-list\\index.js","../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","./send-page-row":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\send-page-row.tsx","fuse.js":"D:\\code\\v\\metamask-extension\\node_modules\\fuse.js\\dist\\fuse.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Csend%5Ccomponents%5Caddress-book.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SendPageAddressBook = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _fuse = _interopRequireDefault(require("fuse.js"));
var _componentLibrary = require("../../../../component-library");
var _i18n = require("../../../../../contexts/i18n");
var _contactList = _interopRequireDefault(require("../../../../app/contact-list"));
var _selectors = require("../../../../../selectors");
var _send = require("../../../../../ducks/send");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _routes = require("../../../../../helpers/constants/routes");
var _metametrics = require("../../../../../contexts/metametrics");
var _metametrics2 = require("../../../../../../shared/constants/metametrics");
var _networks = require("../../../../../../shared/modules/selectors/networks");
var _actions = require("../../../../../store/actions");
var _sendPageRow = require("./send-page-row");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SendPageAddressBook = () => {
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const dispatch = (0, _reactRedux.useDispatch)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const addressBook = (0, _reactRedux.useSelector)(_selectors.getCompleteAddressBook);
  const internalAccounts = (0, _reactRedux.useSelector)(_selectors.getInternalAccounts);
  const contacts = addressBook.filter(({
    name
  }) => Boolean(name));
  const currentNetworkTransactions = (0, _reactRedux.useSelector)(_selectors.getCurrentNetworkTransactions);
  const globalChainId = (0, _reactRedux.useSelector)(_networks.getCurrentChainId);
  const networkClientIdsByChainId = (0, _reactRedux.useSelector)(_selectors.getNetworkConfigurationIdByChainId);
  const txList = [...currentNetworkTransactions].reverse();
  const nonContacts = addressBook.filter(({
    name
  }) => !name).map(nonContact => {
    const nonContactTx = txList.find(transaction => transaction.txParams.to === nonContact.address.toLowerCase());
    return {
      ...nonContact,
      timestamp: nonContactTx === null || nonContactTx === void 0 ? void 0 : nonContactTx.time
    };
  });
  const userInput = (0, _reactRedux.useSelector)(_send.getRecipientUserInput);
  const contactFuse = new _fuse.default(contacts, {
    shouldSort: true,
    threshold: 0.45,
    location: 0,
    distance: 100,
    maxPatternLength: 32,
    minMatchCharLength: 1,
    keys: [{
      name: 'name',
      weight: 0.5
    }, {
      name: 'address',
      weight: 0.5
    }]
  });
  const recentFuse = new _fuse.default(nonContacts, {
    shouldSort: true,
    threshold: 0.45,
    location: 0,
    distance: 100,
    maxPatternLength: 32,
    minMatchCharLength: 1,
    keys: [{
      name: 'address',
      weight: 0.5
    }]
  });
  const searchForContacts = () => {
    if (userInput) {
      contactFuse.setCollection(contacts);
      return contactFuse.search(userInput);
    }
    return contacts;
  };
  const searchForRecents = () => {
    if (userInput) {
      recentFuse.setCollection(nonContacts);
      return recentFuse.search(userInput);
    }
    return nonContacts;
  };
  const selectRecipient = (0, _react.useCallback)((address = '', nickname = '', type = 'user input') => {
    dispatch((0, _send.addHistoryEntry)(`sendFlow - User clicked recipient from ${type}. address: ${address}, nickname ${nickname}`));
    trackEvent({
      event: _metametrics2.MetaMetricsEventName.sendRecipientSelected,
      category: _metametrics2.MetaMetricsEventCategory.Send,
      properties: {
        location: 'address book',
        inputType: type
      }
    }, {
      excludeMetaMetricsId: false
    });
    dispatch((0, _send.updateRecipient)({
      address,
      nickname
    }));
    dispatch((0, _send.updateRecipientUserInput)(address));
  }, [dispatch, trackEvent]);
  const onSelectRecipient = (0, _react.useCallback)(async (address = '', name = '', chainId = '') => {
    if (chainId && chainId !== globalChainId) {
      const networkClientId = networkClientIdsByChainId[chainId];
      dispatch((0, _actions.setActiveNetworkWithError)(networkClientId));
    }
    selectRecipient(address, name, `${name ? 'contact' : 'recent'} list`);
  }, [globalChainId, networkClientIdsByChainId, dispatch, selectRecipient]);
  return /*#__PURE__*/_react.default.createElement(_sendPageRow.SendPageRow, null, addressBook.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_contactList.default, {
    addressBook: addressBook,
    internalAccounts: internalAccounts,
    searchForContacts: searchForContacts,
    searchForRecents: searchForRecents,
    selectRecipient: onSelectRecipient
  })) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    padding: 6,
    textAlign: _designSystem.TextAlign.Center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    marginBottom: 4,
    fontWeight: _designSystem.FontWeight.Bold
  }, t('sendNoContactsTitle')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textAlternative
  },
  // eslint-disable-next-line @typescript-eslint/ban-ts-comment
  // @ts-ignore: Expected 0-1 arguments, but got 2.
  t('sendNoContactsDescription', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "a",
    href: `#${_routes.CONTACT_LIST_ROUTE}`,
    color: _designSystem.TextColor.primaryDefault
  }, t('sendNoContactsConversionText'))]))));
};
exports.SendPageAddressBook = SendPageAddressBook;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\send\\components\\address-book.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\domain-input-resolution-cell.tsx", {"../../../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../../app/preferred-avatar":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\preferred-avatar\\index.ts","../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../ui/confusable":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\confusable\\index.js","../../../../ui/tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Csend%5Ccomponents%5Cdomain-input-resolution-cell.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DomainInputResolutionCell = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18n = require("../../../../../contexts/i18n");
var _confusable = _interopRequireDefault(require("../../../../ui/confusable"));
var _componentLibrary = require("../../../../component-library");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _tooltip = _interopRequireDefault(require("../../../../ui/tooltip"));
var _util = require("../../../../../helpers/utils/util");
var _preferredAvatar = require("../../../../app/preferred-avatar");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DomainInputResolutionCell = ({
  address,
  domainName,
  resolvingSnap = '',
  onClick,
  protocol
}) => {
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const titleRef = (0, _react.useRef)(null);
  const breakpointRef = (0, _react.useRef)(null);
  const [isTitleOverflowing, setIsTitleOverflowing] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    var _titleRef$current$tex;
    if (!titleRef.current) {
      return;
    }
    let isOverflowing = titleRef.current.offsetWidth < titleRef.current.scrollWidth;
    const breakpointLength = (_titleRef$current$tex = titleRef.current.textContent) === null || _titleRef$current$tex === void 0 ? void 0 : _titleRef$current$tex.length;
    if (isOverflowing && !breakpointRef.current && breakpointLength) {
      breakpointRef.current = breakpointLength;
    }
    if (!isOverflowing) {
      if (breakpointRef.current) {
        if (domainName.length >= breakpointRef.current) {
          isOverflowing = true;
        } else {
          isOverflowing = false;
          breakpointRef.current = null;
        }
      }
    }
    if (isOverflowing !== isTitleOverflowing) {
      setIsTitleOverflowing(isOverflowing);
    }
  }, [domainName, isTitleOverflowing]);
  const OverflowingTitle = () => /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    containerClassName: "multichain-send-page__recipient__item__title-tooltip",
    wrapperClassName: "multichain-send-page__recipient__item__title-tooltip-container",
    position: "bottom",
    title: domainName
  }, /*#__PURE__*/_react.default.createElement(_confusable.default, {
    asText: true,
    input: domainName,
    confusableWrapperName: "multichain-send-page__recipient__item__title-confusable-wrapper"
  }));

  // Snap provided resolution.
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    key: address,
    className: "multichain-send-page__recipient__item",
    onClick: () => onClick(),
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    paddingBottom: 2,
    style: {
      cursor: 'pointer'
    },
    "data-testid": "multichain-send-page__recipient__item"
  }, /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    title: t('suggestedBySnap', [resolvingSnap])
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.BadgeWrapper, {
    badge: /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarIcon, {
      iconName: _componentLibrary.IconName.Snaps,
      size: _componentLibrary.AvatarIconSize.Xs,
      className: "multichain-send-page__recipient__item__avatar",
      backgroundColor: _designSystem.BackgroundColor.infoDefault,
      borderColor: _designSystem.BorderColor.backgroundDefault,
      borderWidth: 2,
      iconProps: {
        color: _designSystem.IconColor.infoInverse,
        style: {
          width: '12px',
          height: '12px'
        },
        name: _componentLibrary.IconName.Snaps
      }
    }),
    positionObj: {
      bottom: '25%',
      right: '10%'
    },
    badgeContainerProps: {
      className: 'multichain-send-page__recipient__item__badge'
    }
  }, /*#__PURE__*/_react.default.createElement(_preferredAvatar.PreferredAvatar, {
    address: address
  }))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "multichain-send-page__recipient__item__content",
    paddingLeft: 4,
    style: {
      overflow: 'hidden'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    ref: titleRef,
    className: "multichain-send-page__recipient__item__title",
    "data-testid": "multichain-send-page__recipient__item__title",
    display: _designSystem.Display.Flex
  }, isTitleOverflowing ? /*#__PURE__*/_react.default.createElement(OverflowingTitle, null) : /*#__PURE__*/_react.default.createElement(_confusable.default, {
    asText: true,
    input: domainName
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textAlternative
  }, (0, _util.shortenAddress)(address)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "multichain-send-page__recipient__item__subtitle",
    "data-testid": "multichain-send-page__recipient__item__subtitle"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textAlternative,
    variant: _designSystem.TextVariant.bodySm
  }, protocol))));
};
exports.DomainInputResolutionCell = DomainInputResolutionCell;
DomainInputResolutionCell.propTypes = {
  address: _propTypes.default.string.isRequired,
  domainName: _propTypes.default.string.isRequired,
  resolvingSnap: _propTypes.default.string.isRequired,
  onClick: _propTypes.default.func,
  protocol: _propTypes.default.string
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\send\\components\\domain-input-resolution-cell.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\hex.tsx", {"../../../../../ducks/send":"D:\\code\\v\\metamask-extension\\ui\\ducks\\send\\index.js","../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../../pages/confirmations/send-legacy/send.constants":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\send-legacy\\send.constants.js","../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../component-library/textarea":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\textarea\\index.ts","./send-page-row":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\send-page-row.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Csend%5Ccomponents%5Chex.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SendHexData = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _useI18nContext = require("../../../../../hooks/useI18nContext");
var _componentLibrary = require("../../../../component-library");
var _send = require("../../../../../ducks/send");
var _textarea = require("../../../../component-library/textarea");
var _send2 = require("../../../../../pages/confirmations/send-legacy/send.constants");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _sendPageRow = require("./send-page-row");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const SendHexData = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const data = (0, _reactRedux.useSelector)(_send.getSendHexData);
  const error = (0, _reactRedux.useSelector)(_send.getSendHexDataError);
  const isInvalidHexDataError = error === _send2.INVALID_HEX_DATA_ERROR;
  const hasError = Boolean(error);
  return /*#__PURE__*/_react.default.createElement(_sendPageRow.SendPageRow, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Label, null, t('hexData')), /*#__PURE__*/_react.default.createElement(_textarea.Textarea
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  , {
    onInput: event => {
      const newData = event.target.value.replace(/\n/gu, '') || null;
      dispatch((0, _send.updateSendHexData)(newData ?? ''));
    },
    placeholder: t('optional')
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    ,
    defaultValue: data || '',
    "data-testid": "send-hex-textarea",
    error: hasError
  }), isInvalidHexDataError && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.errorDefault
  }, t('invalidHexData')));
};
exports.SendHexData = SendHexData;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\send\\components\\hex.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\index.ts", {"./account-picker":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\account-picker.tsx","./address-book":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\address-book.tsx","./domain-input-resolution-cell":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\domain-input-resolution-cell.tsx","./hex":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\hex.tsx","./network-picker":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\network-picker.tsx","./quote-card":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\quote-card\\index.tsx","./recipient":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\recipient.tsx","./recipient-content":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\recipient-content.tsx","./recipient-input":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\recipient-input.tsx","./send-page-row":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\send-page-row.tsx","./your-accounts":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\your-accounts.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Csend%5Ccomponents%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "DomainInputResolutionCell", {
  enumerable: true,
  get: function () {
    return _domainInputResolutionCell.DomainInputResolutionCell;
  }
});
Object.defineProperty(exports, "QuoteCard", {
  enumerable: true,
  get: function () {
    return _quoteCard.QuoteCard;
  }
});
Object.defineProperty(exports, "SendHexData", {
  enumerable: true,
  get: function () {
    return _hex.SendHexData;
  }
});
Object.defineProperty(exports, "SendPageAccountPicker", {
  enumerable: true,
  get: function () {
    return _accountPicker.SendPageAccountPicker;
  }
});
Object.defineProperty(exports, "SendPageAddressBook", {
  enumerable: true,
  get: function () {
    return _addressBook.SendPageAddressBook;
  }
});
Object.defineProperty(exports, "SendPageNetworkPicker", {
  enumerable: true,
  get: function () {
    return _networkPicker.SendPageNetworkPicker;
  }
});
Object.defineProperty(exports, "SendPageRecipient", {
  enumerable: true,
  get: function () {
    return _recipient.SendPageRecipient;
  }
});
Object.defineProperty(exports, "SendPageRecipientContent", {
  enumerable: true,
  get: function () {
    return _recipientContent.SendPageRecipientContent;
  }
});
Object.defineProperty(exports, "SendPageRecipientInput", {
  enumerable: true,
  get: function () {
    return _recipientInput.SendPageRecipientInput;
  }
});
Object.defineProperty(exports, "SendPageRow", {
  enumerable: true,
  get: function () {
    return _sendPageRow.SendPageRow;
  }
});
Object.defineProperty(exports, "SendPageYourAccounts", {
  enumerable: true,
  get: function () {
    return _yourAccounts.SendPageYourAccounts;
  }
});
var _sendPageRow = require("./send-page-row");
var _accountPicker = require("./account-picker");
var _networkPicker = require("./network-picker");
var _yourAccounts = require("./your-accounts");
var _recipientInput = require("./recipient-input");
var _addressBook = require("./address-book");
var _recipient = require("./recipient");
var _recipientContent = require("./recipient-content");
var _hex = require("./hex");
var _quoteCard = require("./quote-card");
var _domainInputResolutionCell = require("./domain-input-resolution-cell");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\send\\components\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\network-picker.tsx", {"../../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","./send-page-row":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\send-page-row.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Csend%5Ccomponents%5Cnetwork-picker.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SendPageNetworkPicker = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _selectors = require("../../../../../selectors");
var _actions = require("../../../../../store/actions");
var _componentLibrary = require("../../../../component-library");
var _sendPageRow = require("./send-page-row");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const SendPageNetworkPicker = () => {
  var _currentNetwork$rpcPr;
  const currentNetwork = (0, _reactRedux.useSelector)(_selectors.getCurrentNetwork);
  const dispatch = (0, _reactRedux.useDispatch)();
  return /*#__PURE__*/_react.default.createElement(_sendPageRow.SendPageRow, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.PickerNetwork, {
    label: (currentNetwork === null || currentNetwork === void 0 ? void 0 : currentNetwork.nickname) ?? '',
    src: currentNetwork === null || currentNetwork === void 0 || (_currentNetwork$rpcPr = currentNetwork.rpcPrefs) === null || _currentNetwork$rpcPr === void 0 ? void 0 : _currentNetwork$rpcPr.imageUrl,
    onClick: () => dispatch((0, _actions.toggleNetworkMenu)()),
    "data-testid": "send-page-network-picker"
  }));
};
exports.SendPageNetworkPicker = SendPageNetworkPicker;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\send\\components\\network-picker.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\quote-card\\hooks\\useEthFeeData.tsx", {"../../../../../../../../shared/constants/common":"D:\\code\\v\\metamask-extension\\shared\\constants\\common.ts","../../../../../../../../shared/modules/Numeric":"D:\\code\\v\\metamask-extension\\shared\\modules\\Numeric.ts","../../../../../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../../../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../../../../../ducks/swaps/swaps":"D:\\code\\v\\metamask-extension\\ui\\ducks\\swaps\\swaps.js","../../../../../../../helpers/utils/confirm-tx.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\confirm-tx.util.ts","../../../../../../../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","./utils":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\quote-card\\hooks\\utils.ts","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Csend%5Ccomponents%5Cquote-card%5Chooks%5CuseEthFeeData.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useEthFeeData;
var _react = require("react");
var _reactRedux = require("react-redux");
var _utils = require("@metamask/utils");
var _Numeric = require("../../../../../../../../shared/modules/Numeric");
var _metamask = require("../../../../../../../ducks/metamask/metamask");
var _common = require("../../../../../../../../shared/constants/common");
var _selectors = require("../../../../../../../selectors/selectors");
var _networks = require("../../../../../../../../shared/modules/selectors/networks");
var _swaps = require("../../../../../../../ducks/swaps/swaps");
var _confirmTx = require("../../../../../../../helpers/utils/confirm-tx.util");
var _utils2 = require("./utils");
function useEthFeeData(gasLimit = 0) {
  const dispatch = (0, _reactRedux.useDispatch)();
  const nativeCurrencySymbol = (0, _reactRedux.useSelector)(_metamask.getNativeCurrency);
  const selectedNativeConversionRate = (0, _reactRedux.useSelector)(_metamask.getConversionRate);
  const currentCurrency = (0, _reactRedux.useSelector)(_metamask.getCurrentCurrency);
  const networkAndAccountSupports1559 = (0, _reactRedux.useSelector)(_selectors.checkNetworkAndAccountSupports1559);
  const {
    medium,
    gasPrice: maybeGasFee
  } = (0, _reactRedux.useSelector)(_metamask.getGasFeeEstimates);

  // remove this logic once getGasFeeEstimates is typed
  const gasFee1559 = maybeGasFee ?? (medium === null || medium === void 0 ? void 0 : medium.suggestedMaxFeePerGas);
  const chainId = (0, _reactRedux.useSelector)(_networks.getCurrentChainId);
  const isSwapsChain = (0, _reactRedux.useSelector)(_selectors.getIsSwapsChain);
  const gasPriceNon1559 = (0, _reactRedux.useSelector)(_swaps.getUsedSwapsGasPrice);
  (0, _react.useEffect)(() => {
    if (!isSwapsChain) {
      return;
    }
    if (!networkAndAccountSupports1559) {
      dispatch((0, _swaps.fetchAndSetSwapsGasPriceInfo)());
    }
  }, [dispatch, chainId, networkAndAccountSupports1559, isSwapsChain]);
  return (0, _react.useMemo)(() => {
    const rawGasPrice = networkAndAccountSupports1559 ? gasFee1559 : gasPriceNon1559;
    if (!rawGasPrice) {
      return {
        formattedFiatGasFee: '',
        formattedEthGasFee: ''
      };
    }
    const ethGasFee = new _Numeric.Numeric(rawGasPrice, (0, _utils.isHexString)(rawGasPrice) ? 16 : 10, _common.EtherDenomination.GWEI).times(new _Numeric.Numeric(gasLimit, 10)).toDenomination(_common.EtherDenomination.ETH);
    const fiatGasFee = selectedNativeConversionRate ? ethGasFee.applyConversionRate(selectedNativeConversionRate).toNumber() : undefined;
    const formattedFiatGasFee = fiatGasFee ? (0, _confirmTx.formatCurrency)(new _Numeric.Numeric(fiatGasFee, 10).toString(), currentCurrency) : '';
    const formattedEthGasFee = `${(0, _utils2.toFixedNoTrailingZeros)(ethGasFee.toNumber())} ${nativeCurrencySymbol}`;
    return {
      formattedFiatGasFee,
      formattedEthGasFee
    };
  }, [networkAndAccountSupports1559, medium === null || medium === void 0 ? void 0 : medium.suggestedMaxFeePerGas, gasPriceNon1559, gasLimit, selectedNativeConversionRate, currentCurrency, nativeCurrencySymbol]);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\send\\components\\quote-card\\hooks\\useEthFeeData.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\quote-card\\hooks\\useGetConversionRate.tsx", {"../../../../../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../../../../../../shared/lib/transactions-controller-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\transactions-controller-utils.js","../../../../../../../../shared/modules/Numeric":"D:\\code\\v\\metamask-extension\\shared\\modules\\Numeric.ts","../../../../../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../../../../../ducks/send":"D:\\code\\v\\metamask-extension\\ui\\ducks\\send\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Csend%5Ccomponents%5Cquote-card%5Chooks%5CuseGetConversionRate.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useGetConversionRate;
var _react = require("react");
var _reactRedux = require("react-redux");
var _send = require("../../../../../../../ducks/send");
var _transaction = require("../../../../../../../../shared/constants/transaction");
var _transactionsControllerUtils = require("../../../../../../../../shared/lib/transactions-controller-utils");
var _Numeric = require("../../../../../../../../shared/modules/Numeric");
var _metamask = require("../../../../../../../ducks/metamask/metamask");
const NATIVE_CURRENCY_DECIMALS = 18;
function useGetConversionRate() {
  var _sendAsset$details, _receiveAsset$details, _sendAsset$details3, _receiveAsset$details3;
  const bestQuote = (0, _reactRedux.useSelector)(_send.getBestQuote);
  const {
    sendAsset,
    receiveAsset
  } = (0, _reactRedux.useSelector)(_send.getCurrentDraftTransaction);
  const nativeCurrencySymbol = (0, _reactRedux.useSelector)(_metamask.getNativeCurrency);
  const sourceTokenSymbol = (sendAsset === null || sendAsset === void 0 ? void 0 : sendAsset.type) === _transaction.AssetType.native ? nativeCurrencySymbol : sendAsset === null || sendAsset === void 0 || (_sendAsset$details = sendAsset.details) === null || _sendAsset$details === void 0 ? void 0 : _sendAsset$details.symbol;
  const destinationTokenSymbol = (receiveAsset === null || receiveAsset === void 0 ? void 0 : receiveAsset.type) === _transaction.AssetType.native ? nativeCurrencySymbol : receiveAsset === null || receiveAsset === void 0 || (_receiveAsset$details = receiveAsset.details) === null || _receiveAsset$details === void 0 ? void 0 : _receiveAsset$details.symbol;
  const formattedConversionRate = (0, _react.useMemo)(() => {
    if (bestQuote && sendAsset && receiveAsset) {
      var _sendAsset$details2, _receiveAsset$details2;
      const primaryTokenAmount = (0, _transactionsControllerUtils.calcTokenAmount)(bestQuote.sourceAmount,
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
      // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
      ((_sendAsset$details2 = sendAsset.details) === null || _sendAsset$details2 === void 0 ? void 0 : _sendAsset$details2.decimals) || NATIVE_CURRENCY_DECIMALS);
      const secondaryTokenAmount = (0, _transactionsControllerUtils.calcTokenAmount)(bestQuote.destinationAmount,
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
      // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
      ((_receiveAsset$details2 = receiveAsset.details) === null || _receiveAsset$details2 === void 0 ? void 0 : _receiveAsset$details2.decimals) || NATIVE_CURRENCY_DECIMALS);
      const conversionRateFromPrimaryToSecondary = new _Numeric.Numeric(secondaryTokenAmount).divide(primaryTokenAmount).round(9).toNumber();
      return `1 ${sourceTokenSymbol} = ${conversionRateFromPrimaryToSecondary} ${destinationTokenSymbol}`;
    }
    return undefined;
  }, [bestQuote === null || bestQuote === void 0 ? void 0 : bestQuote.sourceAmount, bestQuote === null || bestQuote === void 0 ? void 0 : bestQuote.destinationAmount, sendAsset === null || sendAsset === void 0 || (_sendAsset$details3 = sendAsset.details) === null || _sendAsset$details3 === void 0 ? void 0 : _sendAsset$details3.decimals, receiveAsset === null || receiveAsset === void 0 || (_receiveAsset$details3 = receiveAsset.details) === null || _receiveAsset$details3 === void 0 ? void 0 : _receiveAsset$details3.decimals, sourceTokenSymbol, destinationTokenSymbol]);
  return formattedConversionRate;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\send\\components\\quote-card\\hooks\\useGetConversionRate.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\quote-card\\hooks\\useTranslatedNetworkName.tsx", {"../../../../../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Csend%5Ccomponents%5Cquote-card%5Chooks%5CuseTranslatedNetworkName.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useTranslatedNetworkName;
var _reactRedux = require("react-redux");
var _controllerUtils = require("@metamask/controller-utils");
var _network = require("../../../../../../../../shared/constants/network");
var _useI18nContext = require("../../../../../../../hooks/useI18nContext");
var _networks = require("../../../../../../../../shared/modules/selectors/networks");
function useTranslatedNetworkName() {
  const chainId = (0, _reactRedux.useSelector)(_networks.getCurrentChainId);
  const t = (0, _useI18nContext.useI18nContext)();
  switch ((0, _controllerUtils.toHex)(chainId)) {
    case _network.CHAIN_IDS.MAINNET:
      return t('networkNameEthereum');
    case _network.CHAIN_IDS.BSC:
      return t('networkNameBSC');
    case _network.CHAIN_IDS.POLYGON:
      return t('networkNamePolygon');
    case _network.CHAIN_IDS.LOCALHOST:
      return t('networkNameTestnet');
    case _network.CHAIN_IDS.GOERLI:
      return t('networkNameGoerli');
    case _network.CHAIN_IDS.AVALANCHE:
      return t('networkNameAvalanche');
    case _network.CHAIN_IDS.OPTIMISM:
      return t('networkNameOpMainnet');
    case _network.CHAIN_IDS.ARBITRUM:
      return t('networkNameArbitrum');
    case _network.CHAIN_IDS.ZKSYNC_ERA:
      return t('networkNameZkSyncEra');
    case _network.CHAIN_IDS.LINEA_MAINNET:
      return t('networkNameLinea');
    case _network.CHAIN_IDS.BASE:
      return t('networkNameBase');
    default:
      return undefined;
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\send\\components\\quote-card\\hooks\\useTranslatedNetworkName.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\quote-card\\hooks\\utils.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Csend%5Ccomponents%5Cquote-card%5Chooks%5Cutils.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toFixedNoTrailingZeros = void 0;
const MAX_TOKEN_DECIMALS = 7;
const TRAILING_ZEROS = /0+$/u;
const toFixedNoTrailingZeros = (value, decimals = MAX_TOKEN_DECIMALS) => {
  const valueWithNoTrailingZeros = value.toFixed(decimals).replace(TRAILING_ZEROS, '');
  return valueWithNoTrailingZeros.endsWith('.') ? valueWithNoTrailingZeros.slice(0, -1) : valueWithNoTrailingZeros;
};
exports.toFixedNoTrailingZeros = toFixedNoTrailingZeros;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\send\\components\\quote-card\\hooks\\utils.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\quote-card\\index.tsx", {"../../../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../../../../shared/constants/time":"D:\\code\\v\\metamask-extension\\shared\\constants\\time.ts","../../../../../../../shared/lib/ui-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\ui-utils.js","../../../../../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../../../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../../../../ducks/send":"D:\\code\\v\\metamask-extension\\ui\\ducks\\send\\index.js","../../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../../ui/info-tooltip/info-tooltip-icon":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\info-tooltip\\info-tooltip-icon.js","../../../../../ui/tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\index.js","./hooks/useEthFeeData":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\quote-card\\hooks\\useEthFeeData.tsx","./hooks/useGetConversionRate":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\quote-card\\hooks\\useGetConversionRate.tsx","./hooks/useTranslatedNetworkName":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\quote-card\\hooks\\useTranslatedNetworkName.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Csend%5Ccomponents%5Cquote-card%5Cindex.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QuoteCard = QuoteCard;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _componentLibrary = require("../../../../../component-library");
var _designSystem = require("../../../../../../helpers/constants/design-system");
var _send = require("../../../../../../ducks/send");
var _useI18nContext = require("../../../../../../hooks/useI18nContext");
var _time = require("../../../../../../../shared/constants/time");
var _tooltip = _interopRequireDefault(require("../../../../../ui/tooltip"));
var _infoTooltipIcon = _interopRequireDefault(require("../../../../../ui/info-tooltip/info-tooltip-icon"));
var _metametrics = require("../../../../../../../shared/constants/metametrics");
var _uiUtils = require("../../../../../../../shared/lib/ui-utils");
var _metametrics2 = require("../../../../../../contexts/metametrics");
var _conversion = require("../../../../../../../shared/modules/conversion.utils");
var _useEthFeeData = _interopRequireDefault(require("./hooks/useEthFeeData"));
var _useTranslatedNetworkName = _interopRequireDefault(require("./hooks/useTranslatedNetworkName"));
var _useGetConversionRate = _interopRequireDefault(require("./hooks/useGetConversionRate"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// update literal below if over 60 seconds
const REFRESH_INTERVAL = 30;

/**
 * All the info about the current quote; handles polling and displaying the best quote
 *
 * @param options0
 * @param options0.scrollRef - ref to scroll to quote on quote load
 */
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function QuoteCard({
  scrollRef
}) {
  var _bestQuote$approvalNe;
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const sendAnalytics = (0, _reactRedux.useSelector)(_send.getSendAnalyticProperties);
  const translatedNetworkName = (0, _useTranslatedNetworkName.default)();
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const {
    isSwapQuoteLoading
  } = (0, _reactRedux.useSelector)(_send.getCurrentDraftTransaction);
  const bestQuote = (0, _reactRedux.useSelector)(_send.getBestQuote);
  const [timeLeft, setTimeLeft] = (0, _react.useState)(undefined);
  const {
    formattedEthGasFee,
    formattedFiatGasFee
  } = (0, _useEthFeeData.default)(
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  ((bestQuote === null || bestQuote === void 0 ? void 0 : bestQuote.gasParams.maxGas) || 0) +
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  Number((0, _conversion.hexToDecimal)((bestQuote === null || bestQuote === void 0 || (_bestQuote$approvalNe = bestQuote.approvalNeeded) === null || _bestQuote$approvalNe === void 0 ? void 0 : _bestQuote$approvalNe.gas) || '0x0')));
  const formattedConversionRate = (0, _useGetConversionRate.default)();
  const prevBestQuote = (0, _react.useRef)(bestQuote);
  (0, _react.useEffect)(() => {
    const isQuoteJustLoaded = bestQuote && prevBestQuote.current === undefined;
    prevBestQuote.current = bestQuote;
    // scroll to quote on initial load
    if (isQuoteJustLoaded) {
      var _scrollRef$current;
      (_scrollRef$current = scrollRef.current) === null || _scrollRef$current === void 0 || _scrollRef$current.scrollIntoView({
        behavior: 'smooth',
        block: 'start'
      });
    }
    if (bestQuote) {
      trackEvent({
        event: _metametrics.MetaMetricsEventName.sendSwapQuoteReceived,
        category: _metametrics.MetaMetricsEventCategory.Send,
        properties: {
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          is_first_fetch: isQuoteJustLoaded
        },
        sensitiveProperties: {
          ...sendAnalytics
        }
      }, {
        excludeMetaMetricsId: false
      });
      setTimeLeft(REFRESH_INTERVAL);
    } else {
      setTimeLeft(undefined);
    }
  }, [bestQuote]);
  (0, _react.useEffect)(() => {
    if (isSwapQuoteLoading || timeLeft === undefined) {
      return;
    }
    if (timeLeft <= 0) {
      dispatch((0, _send.updateSendQuote)(false, true));
    }
    const timeout = setTimeout(() => setTimeLeft(timeLeft - 1), _time.SECOND);
    // eslint-disable-next-line consistent-return
    return () => clearTimeout(timeout);
  }, [timeLeft]);

  // use to track when a quote is requested and received
  (0, _react.useEffect)(() => {
    if (isSwapQuoteLoading) {
      trackEvent({
        event: _metametrics.MetaMetricsEventName.sendSwapQuoteRequested,
        category: _metametrics.MetaMetricsEventCategory.Send,
        sensitiveProperties: {
          ...sendAnalytics
        }
      }, {
        excludeMetaMetricsId: false
      });
    } else if (bestQuote) {
      trackEvent({
        event: _metametrics.MetaMetricsEventName.sendSwapQuoteReceived,
        category: _metametrics.MetaMetricsEventCategory.Send,
        sensitiveProperties: {
          ...sendAnalytics
        }
      }, {
        excludeMetaMetricsId: false
      });
    }
  }, [isSwapQuoteLoading]);
  const infoText = (0, _react.useMemo)(() => {
    if (isSwapQuoteLoading) {
      return t('swapFetchingQuotes');
    } else if (bestQuote) {
      const timeLeftFormatted = `0${timeLeft}`.slice(-2);
      return timeLeft ? t('swapNewQuoteIn', [`0:${timeLeftFormatted}`]) : undefined;
    }
    return undefined;
  }, [isSwapQuoteLoading, bestQuote, timeLeft]);
  const isContent = Boolean(infoText || bestQuote);
  if (!isContent) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.flexStart,
    gap: 2
  }, infoText && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textAlternative,
    variant: _designSystem.TextVariant.bodySm,
    className: "quote-card__fetch-status"
  }, infoText), bestQuote && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    backgroundColor: _designSystem.BackgroundColor.backgroundAlternative,
    borderRadius: _designSystem.BorderRadius.LG,
    width: _designSystem.BlockSize.Full,
    gap: 2,
    padding: 3
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    className: "quote-card__text",
    color: _designSystem.TextColor.textAlternative,
    marginRight: 'auto',
    variant: _designSystem.TextVariant.bodySm
  }, t('quoteRate')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    marginLeft: 'auto',
    variant: _designSystem.TextVariant.bodySm,
    "data-testid": "quote-card__conversion-rate"
  }, formattedConversionRate)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    marginRight: 'auto',
    gap: 1,
    alignItems: _designSystem.AlignItems.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative
  }, t('transactionDetailGasHeading')), /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    interactive: true,
    position: "left",
    containerClassName: "info-tooltip__tooltip-container",
    tooltipInnerClassName: "info-tooltip__tooltip-content",
    tooltipArrowClassName: "info-tooltip__left-tooltip-arrow",
    style: {
      display: 'flex',
      height: '12px',
      aspectRatio: '1'
    },
    html: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, t('swapGasFeesSummary', [translatedNetworkName])), /*#__PURE__*/_react.default.createElement("p", null, t('swapGasFeesDetails')), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("a", {
      onClick: () => {
        /* istanbul ignore next */
        trackEvent({
          event: 'Clicked "Gas Fees: Learn More" Link',
          category: _metametrics.MetaMetricsEventCategory.Swaps
        });
        global.platform.openTab({
          url: _uiUtils.GAS_FEES_LEARN_MORE_URL
        });
      },
      target: "_blank",
      rel: "noreferrer"
    }, t('swapGasFeesLearnMore')))),
    theme: "tippy-tooltip-info"
  }, /*#__PURE__*/_react.default.createElement(_infoTooltipIcon.default, {
    fillColor: "var(--color-icon-alternative)"
  }))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    marginLeft: 'auto'
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    "data-testid": "quote-card__gas-fee"
  }, formattedEthGasFee), formattedFiatGasFee && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textAlternative,
    variant: _designSystem.TextVariant.bodySm,
    marginLeft: 1,
    "data-testid": "quote-card__fiat-gas-fee"
  }, "\u2248 ", formattedFiatGasFee)))), bestQuote && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textAlternative,
    variant: _designSystem.TextVariant.bodySm
  }, t('swapIncludesMMFeeAlt', [bestQuote === null || bestQuote === void 0 ? void 0 : bestQuote.fee])), bestQuote && /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
    variant: _designSystem.TextVariant.bodySm,
    href: _uiUtils.CONSENSYS_TERMS_OF_USE,
    target: "_blank",
    className: "quote-card__TOS"
  }, t('termsOfService')), /*#__PURE__*/_react.default.createElement("div", {
    ref: scrollRef
  }));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\send\\components\\quote-card\\index.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\recipient-content.tsx", {"../../..":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../../../../../shared/modules/string-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\string-utils.ts","../../../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../../../ducks/send":"D:\\code\\v\\metamask-extension\\ui\\ducks\\send\\index.js","../../../../../helpers/constants/common":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\common.ts","../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../hooks/useGetAssetImageUrl":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useGetAssetImageUrl.ts","../../../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../asset-picker-amount/asset-picker-modal/asset-picker-modal-tabs":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\asset-picker-amount\\asset-picker-modal\\asset-picker-modal-tabs.tsx","./hex":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\hex.tsx","./quote-card":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\quote-card\\index.tsx","./send-page-row":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\send-page-row.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Csend%5Ccomponents%5Crecipient-content.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SendPageRecipientContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _componentLibrary = require("../../../../component-library");
var _metamask = require("../../../../../ducks/metamask/metamask");
var _send = require("../../../../../ducks/send");
var _transaction = require("../../../../../../shared/constants/transaction");
var _common = require("../../../../../helpers/constants/common");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _useI18nContext = require("../../../../../hooks/useI18nContext");
var _ = require("../../..");
var _conversion = require("../../../../../../shared/modules/conversion.utils");
var _selectors = require("../../../../../selectors");
var _useGetAssetImageUrl = _interopRequireDefault(require("../../../../../hooks/useGetAssetImageUrl"));
var _stringUtils = require("../../../../../../shared/modules/string-utils");
var _assetPickerModalTabs = require("../../../asset-picker-amount/asset-picker-modal/asset-picker-modal-tabs");
var _sendPageRow = require("./send-page-row");
var _quoteCard = require("./quote-card");
var _hex = require("./hex");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SendPageRecipientContent = ({
  requireContractAddressAcknowledgement,
  onAssetChange,
  onClick
}) => {
  var _sendAsset$details, _sendAsset$details2, _receiveAsset$details, _sendAsset$details3, _tokenList$sendAsset$, _sendAsset$details$ad, _sendAsset$details4;
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    receiveAsset,
    sendAsset,
    amount: sendAmount,
    isSwapQuoteLoading
  } = (0, _reactRedux.useSelector)(_send.getCurrentDraftTransaction);
  const isBasicFunctionality = (0, _reactRedux.useSelector)(_selectors.getUseExternalServices);
  const isSwapsChain = (0, _reactRedux.useSelector)(_selectors.getIsSwapsChain);
  const isSwapAndSendDisabledForNetwork = (0, _reactRedux.useSelector)(_send.getIsSwapAndSendDisabledForNetwork);
  const swapsBlockedTokens = (0, _reactRedux.useSelector)(_send.getSwapsBlockedTokens);
  const memoizedSwapsBlockedTokens = (0, _react.useMemo)(() => {
    return new Set(swapsBlockedTokens);
  }, [swapsBlockedTokens]);
  const nativeCurrencySymbol = (0, _reactRedux.useSelector)(_metamask.getNativeCurrency);
  const nativeCurrencyImageUrl = (0, _reactRedux.useSelector)(_selectors.getNativeCurrencyImage);
  const tokenList = (0, _reactRedux.useSelector)(_selectors.getTokenList);
  const ipfsGateway = (0, _reactRedux.useSelector)(_selectors.getIpfsGateway);
  const nftImageURL = (0, _useGetAssetImageUrl.default)(((_sendAsset$details = sendAsset.details) === null || _sendAsset$details === void 0 ? void 0 : _sendAsset$details.image) ?? undefined, ipfsGateway);
  const isSwapAllowed = isSwapsChain && !isSwapAndSendDisabledForNetwork && [_transaction.AssetType.token, _transaction.AssetType.native].includes(sendAsset.type) && isBasicFunctionality && !memoizedSwapsBlockedTokens.has((_sendAsset$details2 = sendAsset.details) === null || _sendAsset$details2 === void 0 || (_sendAsset$details2 = _sendAsset$details2.address) === null || _sendAsset$details2 === void 0 ? void 0 : _sendAsset$details2.toLowerCase());
  const bestQuote = (0, _reactRedux.useSelector)(_send.getBestQuote);
  const isLoadingInitialQuotes = !bestQuote && isSwapQuoteLoading;
  const isBasicSend = (0, _stringUtils.isEqualCaseInsensitive)(((_receiveAsset$details = receiveAsset.details) === null || _receiveAsset$details === void 0 ? void 0 : _receiveAsset$details.address) ?? '', ((_sendAsset$details3 = sendAsset.details) === null || _sendAsset$details3 === void 0 ? void 0 : _sendAsset$details3.address) ?? '');
  const amount = isBasicSend ? sendAmount : {
    value: (0, _conversion.decimalToHex)((bestQuote === null || bestQuote === void 0 ? void 0 : bestQuote.destinationAmount) || '0')
  };

  // Hex data
  const showHexDataFlag = (0, _reactRedux.useSelector)(_metamask.getSendHexDataFeatureFlagState);
  const asset = (0, _reactRedux.useSelector)(_send.getSendAsset);
  const showHexData = isBasicSend && showHexDataFlag && asset && asset.type !== _transaction.AssetType.token && asset.type !== _transaction.AssetType.NFT;
  const scrollRef = (0, _react.useRef)(null);

  // Gas data
  const dispatch = (0, _reactRedux.useDispatch)();
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, requireContractAddressAcknowledgement ? /*#__PURE__*/_react.default.createElement(_sendPageRow.SendPageRow, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerAlert, {
    severity: _componentLibrary.BannerAlertSeverity.Danger,
    "data-testid": "send-warning",
    actionButtonLabel: t('tooltipApproveButton'),
    actionButtonOnClick: () => {
      dispatch((0, _send.acknowledgeRecipientWarning)());
    },
    actionButtonProps: {
      display: _designSystem.Display.Block,
      marginTop: 4
    }
  }, t('sendingToTokenContractWarning', [/*#__PURE__*/_react.default.createElement("a", {
    key: "contractWarningSupport",
    target: "_blank",
    rel: "noopener noreferrer",
    className: "send__warning-container__link",
    href: _common.CONTRACT_ADDRESS_LINK
  }, t('learnMoreUpperCase'))]))) : null, /*#__PURE__*/_react.default.createElement(_sendPageRow.SendPageRow, null, /*#__PURE__*/_react.default.createElement(_.AssetPickerAmount, {
    header: t('sendSelectReceiveAsset'),
    action: "receive",
    asset: isSwapAllowed ? receiveAsset : sendAsset,
    sendingAsset: isSwapAllowed && sendAsset && {
      image: sendAsset.type === _transaction.AssetType.native ? nativeCurrencyImageUrl : tokenList && sendAsset.details && (nftImageURL || ((_tokenList$sendAsset$ = tokenList[(_sendAsset$details$ad = sendAsset.details.address) === null || _sendAsset$details$ad === void 0 ? void 0 : _sendAsset$details$ad.toLowerCase()]) === null || _tokenList$sendAsset$ === void 0 ? void 0 : _tokenList$sendAsset$.iconUrl)),
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
      // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
      symbol: (sendAsset === null || sendAsset === void 0 || (_sendAsset$details4 = sendAsset.details) === null || _sendAsset$details4 === void 0 ? void 0 : _sendAsset$details4.symbol) || nativeCurrencySymbol
    },
    onAssetChange: (0, _react.useCallback)(newAsset => onAssetChange(newAsset, isSwapAllowed), [onAssetChange, isSwapAllowed]),
    isAmountLoading: isLoadingInitialQuotes,
    amount: amount,
    isDisabled: !isSwapAllowed,
    onClick: onClick,
    showNetworkPicker: false,
    visibleTabs: [_assetPickerModalTabs.TabName.TOKENS]
  })), /*#__PURE__*/_react.default.createElement(_quoteCard.QuoteCard, {
    scrollRef: scrollRef
  }), showHexData ? /*#__PURE__*/_react.default.createElement(_hex.SendHexData, null) : null, /*#__PURE__*/_react.default.createElement("div", {
    ref: scrollRef
  }));
};
exports.SendPageRecipientContent = SendPageRecipientContent;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\send\\components\\recipient-content.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\recipient-input.tsx", {"../../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../../../shared/modules/hexstring-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\hexstring-utils.ts","../../../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../../../ducks/send":"D:\\code\\v\\metamask-extension\\ui\\ducks\\send\\index.js","../../../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../../../pages/confirmations/send-legacy/send-content/add-recipient/domain-input":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\send-legacy\\send-content\\add-recipient\\domain-input.js","../../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","./send-page-row":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\send-page-row.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Csend%5Ccomponents%5Crecipient-input.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SendPageRecipientInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _componentLibrary = require("../../../../component-library");
var _domainInput = _interopRequireDefault(require("../../../../../pages/confirmations/send-legacy/send-content/add-recipient/domain-input"));
var _i18n = require("../../../../../contexts/i18n");
var _send = require("../../../../../ducks/send");
var _actions = require("../../../../../store/actions");
var _metametrics = require("../../../../../contexts/metametrics");
var _metametrics2 = require("../../../../../../shared/constants/metametrics");
var _util = require("../../../../../helpers/utils/util");
var _hexstringUtils = require("../../../../../../shared/modules/hexstring-utils");
var _sendPageRow = require("./send-page-row");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SendPageRecipientInput = () => {
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const dispatch = (0, _reactRedux.useDispatch)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const recipient = (0, _reactRedux.useSelector)(_send.getRecipient);
  const userInput = (0, _reactRedux.useSelector)(_send.getRecipientUserInput);
  const isUsingMyAccountsForRecipientSearch = (0, _reactRedux.useSelector)(_send.getIsUsingMyAccountForRecipientSearch);
  const onChange = (0, _react.useCallback)(address => {
    dispatch((0, _send.updateRecipientUserInput)(address));
  }, [dispatch]);
  const onValidAddressTyped = (0, _react.useCallback)(async address => {
    dispatch((0, _send.addHistoryEntry)(`sendFlow - Valid address typed ${address}`));
    await dispatch((0, _send.updateRecipientUserInput)(address));
    trackEvent({
      event: _metametrics2.MetaMetricsEventName.sendRecipientSelected,
      category: _metametrics2.MetaMetricsEventCategory.Send,
      properties: {
        location: 'send page recipient input',
        inputType: 'user input'
      }
    }, {
      excludeMetaMetricsId: false
    });
    dispatch((0, _send.updateRecipient)({
      address,
      nickname: ''
    }));
  }, [dispatch, trackEvent]);
  const onPaste = (0, _react.useCallback)(text => {
    dispatch((0, _send.addHistoryEntry)(`sendFlow - User pasted ${text} into address field`));
  }, [dispatch]);
  const scanQrCode = (0, _react.useCallback)(() => {
    trackEvent({
      event: 'Used QR scanner',
      category: _metametrics2.MetaMetricsEventCategory.Transactions,
      properties: {
        action: 'Edit Screen',
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        legacy_event: true
      }
    });
    dispatch((0, _actions.showQrScanner)());
  }, [dispatch, trackEvent]);
  const onReset = (0, _react.useCallback)(() => {
    dispatch((0, _send.resetRecipientInput)());
  }, [dispatch]);
  return /*#__PURE__*/_react.default.createElement(_sendPageRow.SendPageRow, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Label, {
    paddingBottom: 2
  }, t('to')), /*#__PURE__*/_react.default.createElement(_domainInput.default, {
    userInput: userInput,
    onChange: onChange,
    onValidAddressTyped: onValidAddressTyped,
    internalSearch: isUsingMyAccountsForRecipientSearch,
    selectedAddress: recipient.address,
    selectedName: recipient.nickname === recipient.address ? (0, _util.shortenAddress)((0, _hexstringUtils.toChecksumHexAddress)(recipient.address)) : recipient.nickname,
    onPaste: onPaste,
    onReset: onReset,
    scanQrCode: scanQrCode
  }));
};
exports.SendPageRecipientInput = SendPageRecipientInput;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\send\\components\\recipient-input.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\recipient.tsx", {"../../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../../../ducks/domains":"D:\\code\\v\\metamask-extension\\ui\\ducks\\domains.js","../../../../../ducks/send":"D:\\code\\v\\metamask-extension\\ui\\ducks\\send\\index.js","../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../../ui/tabs":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tabs\\index.ts","./address-book":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\address-book.tsx","./domain-input-resolution-cell":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\domain-input-resolution-cell.tsx","./send-page-row":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\send-page-row.tsx","./your-accounts":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\your-accounts.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Csend%5Ccomponents%5Crecipient.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SendPageRecipient = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _i18n = require("../../../../../contexts/i18n");
var _send = require("../../../../../ducks/send");
var _domains = require("../../../../../ducks/domains");
var _componentLibrary = require("../../../../component-library");
var _tabs = require("../../../../ui/tabs");
var _metametrics = require("../../../../../../shared/constants/metametrics");
var _metametrics2 = require("../../../../../contexts/metametrics");
var _domainInputResolutionCell = require("./domain-input-resolution-cell");
var _addressBook = require("./address-book");
var _sendPageRow = require("./send-page-row");
var _yourAccounts = require("./your-accounts");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CONTACTS_TAB_KEY = 'contacts';
const ACCOUNTS_TAB_KEY = 'accounts';
const SendPageRecipient = () => {
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const dispatch = (0, _reactRedux.useDispatch)();
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const recipient = (0, _reactRedux.useSelector)(_send.getRecipient);
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  const userInput = (0, _reactRedux.useSelector)(_send.getRecipientUserInput) || '';
  const domainResolutions = (0, _reactRedux.useSelector)(_domains.getDomainResolutions) || [];
  const domainError = (0, _reactRedux.useSelector)(_domains.getDomainError);
  const domainWarning = (0, _reactRedux.useSelector)(_domains.getDomainWarning);
  const showErrorBanner = domainError || recipient.error && recipient.error !== 'required';
  const showWarningBanner = !showErrorBanner && (domainWarning || recipient.warning);
  const onClick = (address, nickname, type = 'user input') => {
    dispatch((0, _send.addHistoryEntry)(`sendFlow - User clicked recipient from ${type}. address: ${address}, nickname ${nickname}`));
    trackEvent({
      event: _metametrics.MetaMetricsEventName.sendRecipientSelected,
      category: _metametrics.MetaMetricsEventCategory.Send,
      properties: {
        location: 'send page recipient screen',
        inputType: type
      }
    }, {
      excludeMetaMetricsId: false
    });
    dispatch((0, _send.updateRecipient)({
      address,
      nickname
    }));
    dispatch((0, _send.updateRecipientUserInput)(address));
  };
  let contents;
  if (recipient.address) {
    contents = /*#__PURE__*/_react.default.createElement(_domainInputResolutionCell.DomainInputResolutionCell, {
      address: recipient.address,
      domainName: recipient.nickname,
      onClick: () => onClick(recipient.address, recipient.nickname)
    });
  } else if ((domainResolutions === null || domainResolutions === void 0 ? void 0 : domainResolutions.length) > 0 && !recipient.error) {
    contents = domainResolutions.map(domainResolution => {
      const {
        resolvedAddress,
        resolvingSnap,
        addressBookEntryName,
        protocol,
        domainName
      } = domainResolution;
      return /*#__PURE__*/_react.default.createElement(_domainInputResolutionCell.DomainInputResolutionCell, {
        key: `${resolvedAddress}${resolvingSnap}${protocol}`,
        address: resolvedAddress,
        domainName: addressBookEntryName ?? domainName,
        onClick: () => onClick(resolvedAddress, addressBookEntryName ?? domainName, 'Domain resolution'),
        protocol: protocol,
        resolvingSnap: resolvingSnap
      });
    });
  } else {
    contents = /*#__PURE__*/_react.default.createElement(_tabs.Tabs, {
      defaultActiveTabKey: userInput.length > 0 ? CONTACTS_TAB_KEY : ACCOUNTS_TAB_KEY,
      onTabClick: () => null
    },
    /*#__PURE__*/
    // eslint-disable-next-line @typescript-eslint/ban-ts-comment
    // @ts-ignore
    _react.default.createElement(_tabs.Tab, {
      tabKey: ACCOUNTS_TAB_KEY,
      name: t('yourAccounts')
    }, /*#__PURE__*/_react.default.createElement(_yourAccounts.SendPageYourAccounts, null)),
    /*#__PURE__*/
    // eslint-disable-next-line @typescript-eslint/ban-ts-comment
    // @ts-ignore
    _react.default.createElement(_tabs.Tab, {
      tabKey: CONTACTS_TAB_KEY,
      name: t('contacts'),
      "data-testid": "send-contacts-tab"
    }, /*#__PURE__*/_react.default.createElement(_addressBook.SendPageAddressBook, null)));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showErrorBanner ? /*#__PURE__*/_react.default.createElement(_sendPageRow.SendPageRow, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerAlert, {
    severity: _componentLibrary.BannerAlertSeverity.Danger,
    "data-testid": "send-recipient-error"
  }, t(domainError ?? recipient.error))) : null, showWarningBanner ? /*#__PURE__*/_react.default.createElement(_sendPageRow.SendPageRow, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerAlert, {
    severity: _componentLibrary.BannerAlertSeverity.Warning,
    "data-testid": "send-recipient-warning"
  }, t(domainWarning ?? recipient.warning))) : null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "multichain-send-page__recipient"
  }, contents));
};
exports.SendPageRecipient = SendPageRecipient;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\send\\components\\recipient.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\send-page-row.tsx", {"../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Csend%5Ccomponents%5Csend-page-row.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SendPageRow = void 0;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../../../component-library");
var _designSystem = require("../../../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const SendPageRow = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
  display: _designSystem.Display.Flex,
  paddingBottom: 4,
  flexDirection: _designSystem.FlexDirection.Column
}, children);
exports.SendPageRow = SendPageRow;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\send\\components\\send-page-row.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\your-accounts.tsx", {"../../..":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../../../ducks/send":"D:\\code\\v\\metamask-extension\\ui\\ducks\\send\\index.js","../../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","./send-page-row":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\send-page-row.tsx","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Csend%5Ccomponents%5Cyour-accounts.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SendPageYourAccounts = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _keyringApi = require("@metamask/keyring-api");
var _selectors = require("../../../../../selectors");
var _ = require("../../..");
var _send = require("../../../../../ducks/send");
var _metametrics = require("../../../../../contexts/metametrics");
var _metametrics2 = require("../../../../../../shared/constants/metametrics");
var _sendPageRow = require("./send-page-row");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const defaultAllowedAccountTypes = [_keyringApi.EthAccountType.Eoa, _keyringApi.EthAccountType.Erc4337];
const SendPageYourAccounts = ({
  allowedAccountTypes = defaultAllowedAccountTypes
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);

  // Your Accounts
  const accounts = (0, _reactRedux.useSelector)(_selectors.getUpdatedAndSortedAccounts);
  const filteredAccounts = (0, _react.useMemo)(() => {
    return accounts.filter(account => allowedAccountTypes.includes(account.type));
  }, [accounts]);
  const selectedAccount = (0, _reactRedux.useSelector)(_selectors.getSelectedInternalAccount);
  const onClick = (0, _react.useCallback)(account => {
    dispatch((0, _send.addHistoryEntry)(`sendFlow - User clicked recipient from my accounts. address: ${account.address}, nickname ${account.metadata.name}`));
    trackEvent({
      event: _metametrics2.MetaMetricsEventName.sendRecipientSelected,
      category: _metametrics2.MetaMetricsEventCategory.Send,
      properties: {
        location: 'my accounts',
        inputType: 'click'
      }
    }, {
      excludeMetaMetricsId: false
    });
    dispatch((0, _send.updateRecipient)({
      address: account.address,
      nickname: account.metadata.name
    }));
    dispatch((0, _send.updateRecipientUserInput)(account.address));
  }, [dispatch, trackEvent]);
  return /*#__PURE__*/_react.default.createElement(_sendPageRow.SendPageRow, null, filteredAccounts.map(account => /*#__PURE__*/_react.default.createElement(_.AccountListItem, {
    account: account,
    selected: selectedAccount.address === account.address,
    key: account.address,
    isPinned: Boolean(account.pinned),
    shouldScrollToWhenSelected: false,
    onClick: onClick
  })));
};
exports.SendPageYourAccounts = SendPageYourAccounts;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\send\\components\\your-accounts.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\index.js", {"./send":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\send.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Csend%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "SendPage", {
  enumerable: true,
  get: function () {
    return _send.SendPage;
  }
});
var _send = require("./send");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\send\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\send.js", {"../..":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../../ducks/history/history":"D:\\code\\v\\metamask-extension\\ui\\ducks\\history\\history.js","../../../../ducks/send":"D:\\code\\v\\metamask-extension\\ui\\ducks\\send\\index.js","../../../../ducks/send/helpers":"D:\\code\\v\\metamask-extension\\ui\\ducks\\send\\helpers.js","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../../pages/confirmations/send-legacy/send.constants":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\send-legacy\\send.constants.js","../../../../pages/swaps/hooks/useUpdateSwapsState":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\hooks\\useUpdateSwapsState.ts","../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../../app/transaction-activity-log/transaction-activity-log.constants":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\transaction-activity-log\\transaction-activity-log.constants.js","../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\index.ts","./components":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\send\\components\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js","react-tippy":"D:\\code\\v\\metamask-extension\\node_modules\\react-tippy\\dist\\react-tippy.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpages%5Csend%5Csend.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SendPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _reactTippy = require("react-tippy");
var _i18n = require("../../../../contexts/i18n");
var _componentLibrary = require("../../../component-library");
var _page = require("../page");
var _send = require("../../../../ducks/send");
var _transaction = require("../../../../../shared/constants/transaction");
var _metametrics = require("../../../../contexts/metametrics");
var _send2 = require("../../../../pages/confirmations/send-legacy/send.constants");
var _actions = require("../../../../store/actions");
var _routes = require("../../../../helpers/constants/routes");
var _metametrics2 = require("../../../../../shared/constants/metametrics");
var _history = require("../../../../ducks/history/history");
var _ = require("../..");
var _useUpdateSwapsState = _interopRequireDefault(require("../../../../pages/swaps/hooks/useUpdateSwapsState"));
var _helpers = require("../../../../ducks/send/helpers");
var _selectors = require("../../../../selectors");
var _designSystem = require("../../../../helpers/constants/design-system");
var _transactionActivityLog = require("../../../app/transaction-activity-log/transaction-activity-log.constants");
var _trace = require("../../../../../shared/lib/trace");
var _components = require("./components");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SendPage = () => {
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const dispatch = (0, _reactRedux.useDispatch)();
  const startedNewDraftTransaction = (0, _react.useRef)(false);
  const draftTransactionExists = (0, _reactRedux.useSelector)(_send.getDraftTransactionExists);
  const draftTransaction = (0, _reactRedux.useSelector)(_send.getCurrentDraftTransaction);
  const {
    sendAsset: transactionAsset,
    amount,
    swapQuotesError
  } = draftTransaction;
  const draftTransactionID = (0, _reactRedux.useSelector)(_send.getDraftTransactionID);
  const mostRecentOverviewPage = (0, _reactRedux.useSelector)(_history.getMostRecentOverviewPage);
  const sendStage = (0, _reactRedux.useSelector)(_send.getSendStage);
  const isSwapAndSend = (0, _helpers.getIsDraftSwapAndSend)(draftTransaction);
  const history = (0, _reactRouterDom.useHistory)();
  const location = (0, _reactRouterDom.useLocation)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const sendAnalytics = (0, _reactRedux.useSelector)(_send.getSendAnalyticProperties);
  const [isSubmitting, setIsSubmitting] = (0, _react.useState)(false);
  const [error, setError] = (0, _react.useState)(undefined);
  const handleSelectToken = (0, _react.useCallback)((token, isReceived) => {
    const tokenType = token.type.toUpperCase();
    switch (tokenType) {
      case _transaction.TokenStandard.ERC20:
      case 'TOKEN':
        token.type = _transaction.AssetType.token;
        token.standard = _transaction.TokenStandard.ERC20;
        break;
      case _transaction.TokenStandard.ERC721:
        token.type = _transaction.AssetType.NFT;
        token.standard = _transaction.TokenStandard.ERC721;
        token.isERC721 = true;
        break;
      case _transaction.TokenStandard.ERC1155:
        token.type = _transaction.AssetType.NFT;
        token.standard = _transaction.TokenStandard.ERC1155;
        break;
      default:
        if (tokenType === 'NATIVE') {
          break;
        }
        token.type = _transaction.AssetType.unknown;
        token.standard = _transaction.TokenStandard.none;
        break;
    }
    token.image = token.image ?? token.iconUrl;
    if (token.type === _transaction.AssetType.native) {
      dispatch((0, _send.updateSendAsset)({
        type: token.type,
        details: token,
        skipComputeEstimatedGasLimit: false,
        isReceived
      }));
    } else {
      dispatch((0, _send.updateSendAsset)({
        type: token.type ?? _transaction.AssetType.token,
        details: {
          ...token,
          standard: token.standard ?? _transaction.TokenStandard.ERC20
        },
        skipComputeEstimatedGasLimit: false,
        isReceived
      }));
    }
    trackEvent({
      event: _metametrics2.MetaMetricsEventName.sendAssetSelected,
      category: _metametrics2.MetaMetricsEventCategory.Send,
      properties: {
        is_destination_asset_picker_modal: Boolean(isReceived),
        is_nft: false
      },
      sensitiveProperties: {
        ...sendAnalytics,
        new_asset_symbol: token.symbol,
        new_asset_address: token.address
      }
    }, {
      excludeMetaMetricsId: false
    });
    history.push(_routes.SEND_ROUTE);
  }, [dispatch, history, sendAnalytics, trackEvent]);
  const handleAssetPickerClick = (0, _react.useCallback)(isDest => {
    trackEvent({
      event: _metametrics2.MetaMetricsEventName.sendTokenModalOpened,
      category: _metametrics2.MetaMetricsEventCategory.Send,
      properties: {
        is_destination_asset_picker_modal: Boolean(isDest)
      },
      sensitiveProperties: {
        ...sendAnalytics
      }
    }, {
      excludeMetaMetricsId: false
    });
  }, [sendAnalytics, trackEvent]);
  const cleanup = (0, _react.useCallback)(() => {
    dispatch((0, _send.resetSendState)());
    setIsSubmitting(false);
    setError(undefined);
  }, [dispatch]);

  /**
   * It is possible to route to this page directly, either by typing in the url
   * or by clicking the browser back button after progressing to the confirm
   * screen. In the case where a draft transaction does not yet exist, this
   * hook is responsible for creating it. We will assume that this is a native
   * asset send.
   */
  (0, _react.useEffect)(() => {
    if (draftTransactionExists === false && startedNewDraftTransaction.current === false) {
      startedNewDraftTransaction.current = true;
      dispatch((0, _send.startNewDraftTransaction)({
        type: _transaction.AssetType.native
      }));
    }
  }, [draftTransactionExists, dispatch]);
  (0, _react.useEffect)(() => {
    window.addEventListener('beforeunload', cleanup);
  }, [cleanup]);
  (0, _react.useEffect)(() => {
    if (location.search === '?scan=true') {
      dispatch((0, _actions.showQrScanner)());

      // Clear the queryString param after showing the modal
      const [cleanUrl] = window.location.href.split('?');
      window.history.pushState({}, null, `${cleanUrl}`);
      window.location.hash = '#send';
    }
  }, [location, dispatch]);
  (0, _react.useEffect)(() => {
    return () => {
      dispatch((0, _send.resetSendState)());
      window.removeEventListener('beforeunload', cleanup);
    };
  }, [dispatch, cleanup]);
  const onCancel = () => {
    if (draftTransactionID) {
      dispatch((0, _actions.cancelTx)({
        id: draftTransactionID
      }));
    }
    dispatch((0, _send.resetSendState)());
    trackEvent({
      event: _metametrics2.MetaMetricsEventName.sendFlowExited,
      category: _metametrics2.MetaMetricsEventCategory.Send,
      sensitiveProperties: {
        ...sendAnalytics
      }
    }, {
      excludeMetaMetricsId: false
    });
    const nextRoute = sendStage === _send.SEND_STAGES.EDIT ? _routes.DEFAULT_ROUTE : mostRecentOverviewPage;
    history.push(nextRoute);
  };
  (0, _react.useEffect)(() => {
    if (swapQuotesError) {
      trackEvent({
        event: _metametrics2.MetaMetricsEventName.sendSwapQuoteError,
        category: _metametrics2.MetaMetricsEventCategory.Send,
        properties: {
          error: swapQuotesError
        },
        sensitiveProperties: {
          ...sendAnalytics
        }
      }, {
        excludeMetaMetricsId: false
      });
    }
    // sendAnalytics should not result in the event refiring
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [trackEvent, swapQuotesError]);
  const onSubmit = async event => {
    event.preventDefault();
    setIsSubmitting(true);
    setError(undefined);
    try {
      await (0, _trace.trace)({
        name: _trace.TraceName.SendCompleted
      }, async () => {
        await dispatch((0, _send.signTransaction)(history));
      });
      trackEvent({
        category: _metametrics2.MetaMetricsEventCategory.Transactions,
        event: 'Complete',
        properties: {
          ...sendAnalytics,
          action: isSwapAndSend ? 'Submit Immediately' : 'Edit Screen',
          legacy_event: true
        }
      });
    } catch {
      setError(_transactionActivityLog.TRANSACTION_ERRORED_EVENT);
    } finally {
      // prevents state update on unmounted component error
      if (isSubmitting) {
        setIsSubmitting(false);
      }
    }
  };

  // Submit button
  const recipient = (0, _reactRedux.useSelector)(_send.getRecipient);
  const showKnownRecipientWarning = recipient.warning === 'knownAddressRecipient';
  const recipientWarningAcknowledged = (0, _reactRedux.useSelector)(_send.getRecipientWarningAcknowledgement);
  const requireContractAddressAcknowledgement = showKnownRecipientWarning && !recipientWarningAcknowledged;
  const sendErrors = (0, _reactRedux.useSelector)(_send.getSendErrors);
  const isInvalidSendForm = (0, _reactRedux.useSelector)(_send.isSendFormInvalid);
  const smartTransactions = (0, _reactRedux.useSelector)(_selectors.smartTransactionsListSelector);
  const isSmartTransactionPending = smartTransactions === null || smartTransactions === void 0 ? void 0 : smartTransactions.find(({
    status
  }) => status === _transaction.SmartTransactionStatus.pending);
  const isGasTooLow = sendErrors.gasFee === _send2.INSUFFICIENT_FUNDS_ERROR;
  const isInsufficientFundsError = sendErrors.amount === _send2.INSUFFICIENT_FUNDS_ERROR;
  const isHexDataInvalid = sendErrors.hexData === _send2.INVALID_HEX_DATA_ERROR;
  const submitDisabled = Boolean(isInsufficientFundsError || isInvalidSendForm && !isGasTooLow || requireContractAddressAcknowledgement || isSwapAndSend && isSmartTransactionPending || isHexDataInvalid);
  const isSendFormShown = draftTransactionExists && [_send.SEND_STAGES.EDIT, _send.SEND_STAGES.DRAFT].includes(sendStage);
  const handleSelectSendToken = (0, _react.useCallback)(newToken => handleSelectToken(newToken, false), [handleSelectToken]);
  (0, _useUpdateSwapsState.default)();
  const onAmountChange = (0, _react.useCallback)((newAmountRaw, newAmountFormatted) => {
    dispatch((0, _send.updateSendAmount)(newAmountRaw, newAmountFormatted));
    setError(undefined);
  }, [dispatch]);
  let tooltipTitle = '';
  if (isSwapAndSend) {
    tooltipTitle = isSmartTransactionPending ? t('isSigningOrSubmitting') : t('sendSwapSubmissionWarning');
  }
  return /*#__PURE__*/_react.default.createElement(_page.Page, {
    className: "multichain-send-page"
  }, /*#__PURE__*/_react.default.createElement(_page.Header, {
    textProps: {
      variant: _designSystem.TextVariant.headingSm
    },
    startAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      size: _componentLibrary.ButtonIconSize.Sm,
      ariaLabel: t('back'),
      iconName: _componentLibrary.IconName.ArrowLeft,
      onClick: onCancel
    })
  }, t('send')), /*#__PURE__*/_react.default.createElement(_page.Content, null, /*#__PURE__*/_react.default.createElement(_components.SendPageAccountPicker, null), isSendFormShown && /*#__PURE__*/_react.default.createElement(_.AssetPickerAmount, {
    error: error,
    action: "send",
    header: t('sendSelectSendAsset'),
    asset: transactionAsset,
    amount: amount,
    onAssetChange: handleSelectSendToken,
    onAmountChange: onAmountChange,
    onClick: () => handleAssetPickerClick(false),
    showNetworkPicker: true
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginTop: 6
  }, /*#__PURE__*/_react.default.createElement(_components.SendPageRecipientInput, null), isSendFormShown ? /*#__PURE__*/_react.default.createElement(_components.SendPageRecipientContent, {
    requireContractAddressAcknowledgement: requireContractAddressAcknowledgement,
    onAssetChange: handleSelectToken,
    onClick: () => handleAssetPickerClick(true)
  }) : /*#__PURE__*/_react.default.createElement(_components.SendPageRecipient, null))), /*#__PURE__*/_react.default.createElement(_page.Footer, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonSecondary, {
    className: "multichain-send-page__nav-button",
    onClick: onCancel,
    size: _componentLibrary.ButtonSecondarySize.Lg,
    block: true
  }, sendStage === _send.SEND_STAGES.EDIT ? t('reject') : t('cancel')), /*#__PURE__*/_react.default.createElement(_reactTippy.Tooltip
  // changing key forces remount on title change
  , {
    key: tooltipTitle,
    className: "multichain-send-page__nav-button",
    title: tooltipTitle,
    disabled: !isSwapAndSend,
    arrow: true,
    hideOnClick: false
    // explicitly inherit display since Tooltip will default to block
    ,
    style: {
      display: 'inline-flex'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonPrimary, {
    onClick: onSubmit,
    loading: isSubmitting,
    size: _componentLibrary.ButtonPrimarySize.Lg,
    disabled: submitDisabled || isSubmitting,
    block: true
  }, t(isSwapAndSend ? 'confirm' : 'continue')))));
};
exports.SendPage = SendPage;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\pages\\send\\send.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\permission-details-modal\\index.ts", {"./permission-details-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\permission-details-modal\\permission-details-modal.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpermission-details-modal%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "PermissionDetailsModal", {
  enumerable: true,
  get: function () {
    return _permissionDetailsModal.PermissionDetailsModal;
  }
});
var _permissionDetailsModal = require("./permission-details-modal");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\permission-details-modal\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\permission-details-modal\\permission-details-modal.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/permission":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\permission.js","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../app/permission-cell":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\permission-cell\\index.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpermission-details-modal%5Cpermission-details-modal.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PermissionDetailsModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _reactRedux = require("react-redux");
var _designSystemReact = require("@metamask/design-system-react");
var _componentLibrary = require("../../component-library");
var _selectors = require("../../../selectors");
var _util = require("../../../helpers/utils/util");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _permission = require("../../../helpers/utils/permission");
var _permissionCell = _interopRequireDefault(require("../../app/permission-cell"));
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const PermissionDetailsModal = ({
  onClose,
  onClick,
  isOpen,
  account,
  permissions
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const useBlockie = (0, _reactRedux.useSelector)(_selectors.getUseBlockie);
  const permissionLabels = (0, _lodash.flatten)(permissions.map(({
    key,
    value
  }) => (0, _permission.getPermissionDescription)({
    t,
    permissionName: key,
    permissionValue: value,
    subjectName: '',
    // Used for snaps but for accounts we can set a default one. It's not used here. Done to avoid TS errors
    getSubjectName: () => '' // Used for snaps but for accounts we can set a default one. It's not used here. Done to avoid TS errors
  })));
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: isOpen,
    "data-testid": "permission-details-modal",
    onClose: onClose
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onClose: onClose
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    gap: 2
  }, /*#__PURE__*/_react.default.createElement(_designSystemReact.AvatarAccount, {
    size: _designSystemReact.AvatarAccountSize.Sm,
    address: account.address,
    variant: useBlockie ? _designSystemReact.AvatarAccountVariant.Blockies : _designSystemReact.AvatarAccountVariant.Jazzicon
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingSm
  }, account.metadata.name ? account.metadata.name : (0, _util.shortenAddress)(account.address)))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, null, permissionLabels.map((permission, index) => /*#__PURE__*/_react.default.createElement(_permissionCell.default, {
    permissionName: permission.permissionName,
    title: permission.label,
    description: permission.description,
    weight: permission.weight,
    avatarIcon: permission.leftIcon
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    ,
    dateApproved: (permission === null || permission === void 0 ? void 0 : permission.permissionValue).date,
    key: `${permission.permissionName}-${index}`
  }))), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalFooter, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Button, {
    startIconName: _componentLibrary.IconName.Logout,
    variant: _componentLibrary.ButtonVariant.Secondary,
    onClick: onClick,
    size: _componentLibrary.ButtonSize.Lg,
    danger: true,
    block: true,
    "data-testid": "disconnect"
  }, t('disconnect')))));
};
exports.PermissionDetailsModal = PermissionDetailsModal;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\permission-details-modal\\permission-details-modal.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\permissions-header\\permissions-header.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../pages/page":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\pages\\page\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cpermissions-header%5Cpermissions-header.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PermissionsHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../component-library");
var _page = require("../pages/page");
var _util = require("../../../helpers/utils/util");
var _useI18nContext = require("../../../hooks/useI18nContext");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const PermissionsHeader = ({
  securedOrigin,
  connectedSubjectsMetadata
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const history = (0, _reactRouterDom.useHistory)();
  return /*#__PURE__*/_react.default.createElement(_page.Header, {
    textProps: {
      variant: _designSystem.TextVariant.headingSm
    },
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    startAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      size: _componentLibrary.ButtonIconSize.Md,
      ariaLabel: t('back'),
      iconName: _componentLibrary.IconName.ArrowLeft,
      className: "connections-header__start-accessory",
      color: _designSystem.IconColor.iconDefault,
      onClick: () => history.goBack(),
      "data-testid": "back-button"
    })
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    gap: 2,
    justifyContent: _designSystem.JustifyContent.center,
    className: "connections-header__title"
  }, connectedSubjectsMetadata !== null && connectedSubjectsMetadata !== void 0 && connectedSubjectsMetadata.iconUrl ? /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarFavicon, {
    name: connectedSubjectsMetadata.name,
    size: _componentLibrary.AvatarFaviconSize.Sm,
    src: connectedSubjectsMetadata.iconUrl
  }) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.Global,
    size: _componentLibrary.IconSize.Sm,
    color: _designSystem.IconColor.iconDefault
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "span",
    variant: _designSystem.TextVariant.headingSm,
    textAlign: _designSystem.TextAlign.Center,
    ellipsis: true
  }, (0, _util.getURLHost)(securedOrigin))));
};
exports.PermissionsHeader = PermissionsHeader;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\permissions-header\\permissions-header.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\product-tour-popover\\index.js", {"./product-tour-popover":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\product-tour-popover\\product-tour-popover.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cproduct-tour-popover%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ProductTour", {
  enumerable: true,
  get: function () {
    return _productTourPopover.ProductTour;
  }
});
var _productTourPopover = require("./product-tour-popover");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\product-tour-popover\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\product-tour-popover\\product-tour-popover.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/menu":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\menu\\index.ts","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cproduct-tour-popover%5Cproduct-tour-popover.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProductTour = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _designSystemReact = require("@metamask/design-system-react");
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../component-library");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _menu = require("../../ui/menu");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const ProductTour = ({
  className = '',
  prevIcon = undefined,
  title,
  description,
  currentStep = '',
  totalSteps = '',
  arrowPosition = '20px',
  closeMenu,
  anchorElement,
  onClick,
  prevClick = () => undefined,
  productTourDirection = 'ltr',
  ...props
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  return /*#__PURE__*/_react.default.createElement(_menu.Menu, _extends({
    className: (0, _classnames.default)('multichain-product-tour-menu', {
      'multichain-product-tour-menu--rtl': productTourDirection === 'rtl'
    }, className),
    anchorElement: anchorElement,
    onHide: closeMenu,
    "data-testid": "multichain-product-tour-menu-popover"
  }, props), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "multichain-product-tour-menu__container",
    backgroundColor: _designSystem.BackgroundColor.infoDefault,
    borderRadius: _designSystem.BorderRadius.LG,
    padding: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    borderWidth: 1,
    className: "multichain-product-tour-menu__arrow",
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.center,
    style: {
      '--arrow-position': arrowPosition
    }
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    className: "multichain-product-tour-menu__header"
  }, prevIcon ? /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    iconName: _componentLibrary.IconName.ArrowLeft,
    size: _componentLibrary.ButtonIconSize.Sm,
    color: _designSystem.IconColor.infoInverse,
    onClick: prevClick,
    className: "multichain-product-tour-menu__previous-icon",
    "data-testid": "multichain-product-tour-menu-popover-prevIcon"
  }) : null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    textAlign: _designSystem.TextAlign.Center,
    variant: _designSystem.TextVariant.headingSm,
    width: _designSystem.BlockSize.Full,
    color: _designSystem.TextColor.infoInverse
  }, title)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    paddingBottom: 2,
    paddingTop: 2,
    color: _designSystem.TextColor.infoInverse,
    variant: _designSystem.TextVariant.bodyMd
  }, description), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    paddingBottom: 2,
    paddingTop: 2,
    color: _designSystem.TextColor.infoInverse,
    variant: _designSystem.TextVariant.bodyMd,
    "data-testid": "multichain-product-tour-menu-popover-step-counter"
  }, currentStep && totalSteps ? `${currentStep} / ${totalSteps}` : null), /*#__PURE__*/_react.default.createElement(_designSystemReact.Button, {
    isInverse: true,
    variant: _designSystemReact.ButtonVariant.Primary,
    size: _designSystemReact.ButtonBaseSize.Sm,
    "data-testid": "tour-cta-button",
    onClick: onClick
  }, t('gotIt')))));
};
exports.ProductTour = ProductTour;
ProductTour.propTypes = {
  /**
   * The element that the menu should display next to
   */
  anchorElement: _propTypes.default.instanceOf(window.Element),
  /**
   * Function that closes this menu
   */
  closeMenu: _propTypes.default.func.isRequired,
  /**
   * Additional classNames to be added
   */
  className: _propTypes.default.string,
  /**
   * Boolean to decide whether to show prevIcon or not
   */
  prevIcon: _propTypes.default.bool,
  /**
   * Title of the popover
   */
  title: _propTypes.default.string,
  /**
   * Description of the popover
   */
  description: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.node]),
  /**
   * Current step in the product tour
   */
  currentStep: _propTypes.default.string,
  /**
   * Total steps in the product tour
   */
  totalSteps: _propTypes.default.string,
  /**
   * Arrow position from left edge (e.g., '20px', '50%')
   */
  arrowPosition: _propTypes.default.string,
  /**
   * The onClick handler to be passed
   */
  onClick: _propTypes.default.func,
  /**
   * The handler to be passed to prevIcon
   */
  prevClick: _propTypes.default.func,
  /**
   * Direction to determine the css for menu component
   */
  productTourDirection: _propTypes.default.string
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\product-tour-popover\\product-tour-popover.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\ramps-card\\index.js", {"./ramps-card":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\ramps-card\\ramps-card.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cramps-card%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "RampsCard", {
  enumerable: true,
  get: function () {
    return _rampsCard.RampsCard;
  }
});
var _rampsCard = require("./ramps-card");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\ramps-card\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\ramps-card\\ramps-card.js", {"../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../ducks/locale/locale":"D:\\code\\v\\metamask-extension\\ui\\ducks\\locale\\locale.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/ramps/useRamps/useRamps":"D:\\code\\v\\metamask-extension\\ui\\hooks\\ramps\\useRamps\\useRamps.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../../store/background-connection":"D:\\code\\v\\metamask-extension\\ui\\store\\background-connection.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Cramps-card%5Cramps-card.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RampsCard = exports.RAMPS_CARD_VARIANT_TYPES = exports.RAMPS_CARD_VARIANTS = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRedux = require("react-redux");
var _classnames = _interopRequireDefault(require("classnames"));
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _multichain = require("../../../selectors/multichain");
var _metametrics = require("../../../../shared/constants/metametrics");
var _metametrics2 = require("../../../contexts/metametrics");
var _useRamps = _interopRequireWildcard(require("../../../hooks/ramps/useRamps/useRamps"));
var _app = require("../../../../shared/constants/app");
var _locale = require("../../../ducks/locale/locale");
var _backgroundConnection = require("../../../store/background-connection");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const darkenGradient = 'linear-gradient(rgba(0, 0, 0, 0.12),rgba(0, 0, 0, 0.12))';
const RAMPS_CARD_VARIANT_TYPES = exports.RAMPS_CARD_VARIANT_TYPES = {
  TOKEN: 'token',
  ACTIVITY: 'activity',
  BTC: 'btc'
};
const RAMPS_CARD_VARIANTS = exports.RAMPS_CARD_VARIANTS = {
  [RAMPS_CARD_VARIANT_TYPES.TOKEN]: {
    illustrationSrc: './images/ramps-card-token-illustration.png',
    gradient:
    // eslint-disable-next-line @metamask/design-tokens/color-no-hex
    'linear-gradient(90deg, #0189EC 0%, #4B7AED 35%, #6774EE 58%, #706AF4 80.5%, #7C5BFC 100%)',
    title: 'tipsForUsingAWallet',
    body: 'tipsForUsingAWalletDescription'
  },
  [RAMPS_CARD_VARIANT_TYPES.ACTIVITY]: {
    illustrationSrc: './images/ramps-card-activity-illustration.png',
    gradient:
    // eslint-disable-next-line @metamask/design-tokens/color-no-hex
    'linear-gradient(90deg, #57C5DC 0%, #06BFDD 49.39%, #35A9C7 100%)',
    title: 'tipsForUsingAWallet',
    body: 'tipsForUsingAWalletDescription'
  },
  [RAMPS_CARD_VARIANT_TYPES.BTC]: {
    illustrationSrc: './images/ramps-card-btc-illustration.png',
    gradient:
    // eslint-disable-next-line @metamask/design-tokens/color-no-hex
    'linear-gradient(90deg, #017ED9 0%, #446FD9 35%, #5E6AD9 58%, #635ED9 80.5%, #6855D9 92.5%, #6A4FD9 100%)',
    title: 'tipsForUsingAWallet',
    body: 'tipsForUsingAWalletDescription'
  }
};
const metamaskEntryMap = {
  [RAMPS_CARD_VARIANT_TYPES.TOKEN]: _useRamps.RampsMetaMaskEntry.TokensBanner,
  [RAMPS_CARD_VARIANT_TYPES.ACTIVITY]: _useRamps.RampsMetaMaskEntry.ActivityBanner,
  [RAMPS_CARD_VARIANT_TYPES.BTC]: _useRamps.RampsMetaMaskEntry.BtcBanner
};
const RampsCard = ({
  variant,
  handleOnClick
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    gradient,
    illustrationSrc,
    title,
    body
  } = RAMPS_CARD_VARIANTS[variant];
  const {
    openBuyCryptoInPdapp
  } = (0, _useRamps.default)(metamaskEntryMap[variant]);
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const currentLocale = (0, _reactRedux.useSelector)(_locale.getCurrentLocale);
  const {
    chainId,
    nickname
  } = (0, _reactRedux.useSelector)(_multichain.getMultichainCurrentNetwork);
  const {
    symbol
  } = (0, _reactRedux.useSelector)(_multichain.getMultichainDefaultToken);
  const isRampsCardClosed = (0, _reactRedux.useSelector)(state => state.metamask.isRampCardClosed);
  (0, _react.useEffect)(() => {
    trackEvent({
      event: _metametrics.MetaMetricsEventName.EmptyBuyBannerDisplayed,
      category: _metametrics.MetaMetricsEventCategory.Navigation,
      properties: {
        // FIXME: This might not be a number for non-EVM networks
        chain_id: chainId,
        locale: currentLocale,
        network: nickname,
        referrer: _app.ORIGIN_METAMASK
      }
    });
  }, [currentLocale, chainId, nickname, trackEvent]);
  const onClick = (0, _react.useCallback)(() => {
    openBuyCryptoInPdapp(chainId);
    trackEvent({
      event: _metametrics.MetaMetricsEventName.NavBuyButtonClicked,
      category: _metametrics.MetaMetricsEventCategory.Navigation,
      properties: {
        location: `${variant} tab`,
        text: `Token Marketplace`,
        // FIXME: This might not be a number for non-EVM networks
        chain_id: chainId,
        token_symbol: symbol
      }
    });
  }, [chainId, openBuyCryptoInPdapp, symbol, trackEvent, variant]);
  const onClose = (0, _react.useCallback)(() => {
    var _submitRequestToBackg;
    trackEvent({
      event: _metametrics.MetaMetricsEventName.EmptyBuyBannerClosed,
      category: _metametrics.MetaMetricsEventCategory.Navigation,
      properties: {
        location: `${variant} tab`,
        chain_id: chainId,
        token_symbol: symbol
      }
    });
    (_submitRequestToBackg = (0, _backgroundConnection.submitRequestToBackground)('setRampCardClosed')) === null || _submitRequestToBackg === void 0 || _submitRequestToBackg.catch(error => {
      console.error('Error caught in setRampCardClosed submitRequestToBackground', error);
    });
  }, [chainId, symbol, trackEvent, variant]);
  if (isRampsCardClosed) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: (0, _classnames.default)('ramps-card', `ramps-card-${variant}`),
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 2,
    borderRadius: _designSystem.BorderRadius.LG,
    margin: 2,
    style: {
      background: `url(${illustrationSrc}) no-repeat right bottom / contain,
            ${darkenGradient}, ${gradient}`
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    className: "ramps-card__title",
    variant: _designSystem.TextVariant.headingSm
  }, t(title)), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    "data-testid": "ramp-card-close-btn",
    color: _designSystem.IconColor.infoInverse,
    iconName: _componentLibrary.IconName.Close,
    size: _componentLibrary.ButtonIconSize.Sm,
    ariaLabel: t('close'),
    onClick: onClose
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    className: "ramps-card__body"
  }, t(body)), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonBase, {
    className: "ramps-card__cta-button",
    onClick: handleOnClick ?? onClick
  }, t('tokenMarketplace')));
};
exports.RampsCard = RampsCard;
RampsCard.propTypes = {
  variant: _propTypes.default.oneOf(Object.values(RAMPS_CARD_VARIANT_TYPES)),
  handleOnClick: _propTypes.default.func
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\ramps-card\\ramps-card.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\receive-modal\\index.js", {"./receive-modal":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\receive-modal\\receive-modal.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Creceive-modal%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ReceiveModal", {
  enumerable: true,
  get: function () {
    return _receiveModal.ReceiveModal;
  }
});
var _receiveModal = require("./receive-modal");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\receive-modal\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\receive-modal\\receive-modal.js", {"../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/qr-code-view":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\qr-code-view\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Creceive-modal%5Creceive-modal.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReceiveModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _componentLibrary = require("../../component-library");
var _qrCodeView = _interopRequireDefault(require("../../ui/qr-code-view"));
var _useI18nContext = require("../../../hooks/useI18nContext");
var _selectors = require("../../../selectors");
var _designSystem = require("../../../helpers/constants/design-system");
var _trace = require("../../../../shared/lib/trace");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ReceiveModal = ({
  address,
  onClose
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    metadata: {
      name
    }
  } = (0, _reactRedux.useSelector)(state => (0, _selectors.getInternalAccountByAddress)(state, address));
  const data = (0, _react.useMemo)(() => ({
    data: address
  }), [address]);
  (0, _react.useEffect)(() => {
    (0, _trace.endTrace)({
      name: _trace.TraceName.ReceiveModal
    });
  }, []);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: true,
    onClose: onClose
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    marginBottom: 4,
    onClose: onClose
  }, t('receive')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    flexDirection: _designSystem.FlexDirection.Column,
    paddingInlineEnd: 4,
    paddingInlineStart: 4
  }, /*#__PURE__*/_react.default.createElement(_qrCodeView.default, {
    Qr: data,
    accountName: name
  }))));
};
exports.ReceiveModal = ReceiveModal;
ReceiveModal.propTypes = {
  address: _propTypes.default.string.isRequired,
  onClose: _propTypes.default.func.isRequired
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\receive-modal\\receive-modal.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\toast\\index.ts", {"./toast":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\toast\\toast.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Ctoast%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "Toast", {
  enumerable: true,
  get: function () {
    return _toast.Toast;
  }
});
Object.defineProperty(exports, "ToastContainer", {
  enumerable: true,
  get: function () {
    return _toast.ToastContainer;
  }
});
var _toast = require("./toast");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\toast\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\toast\\toast.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Ctoast%5Ctoast.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToastContainer = exports.Toast = void 0;
var _react = _interopRequireWildcard(require("react"));
var _designSystemReact = require("@metamask/design-system-react");
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const ToastContainer = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
  className: "toasts-container"
}, children);
exports.ToastContainer = ToastContainer;
const Toast = ({
  startAdornment,
  text,
  description,
  descriptionVariant,
  actionText,
  onActionClick,
  onClose,
  borderRadius,
  textVariant,
  autoHideTime,
  onAutoHideToast,
  dataTestId,
  className,
  contentProps
}) => {
  const [shouldDisplay, setShouldDisplay] = (0, _react.useState)(true);
  (0, _react.useEffect)(function () {
    if (!autoHideTime || autoHideTime === 0) {
      return undefined;
    }
    const timeout = setTimeout(() => {
      setShouldDisplay(false);
      onAutoHideToast === null || onAutoHideToast === void 0 || onAutoHideToast();
    }, autoHideTime);
    return function () {
      clearTimeout(timeout);
    };
  }, [autoHideTime]);
  if (!shouldDisplay) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerBase, {
    onClose: onClose,
    backgroundColor: _designSystem.BackgroundColor.backgroundSection,
    borderWidth: 1,
    borderColor: _designSystem.BorderColor.borderMuted,
    borderRadius: borderRadius || _designSystem.BorderRadius.XL,
    "data-testid": dataTestId ? `${dataTestId}-banner-base` : undefined,
    closeButtonProps: {
      iconProps: {
        size: _componentLibrary.IconSize.Md
      }
    },
    className: `toasts-container__banner-base ${className}`
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, _extends({
    display: _designSystem.Display.Flex,
    gap: 3,
    "data-testid": dataTestId
  }, contentProps), startAdornment, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    className: "toast-text",
    variant: textVariant || _designSystem.TextVariant.bodyMdMedium
  }, text), description && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    className: "toast-text",
    variant: descriptionVariant || _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative
  }, description), actionText && onActionClick ? /*#__PURE__*/_react.default.createElement(_designSystemReact.Button, {
    variant: _designSystemReact.ButtonVariant.Secondary,
    size: _designSystemReact.ButtonSize.Sm,
    textProps: {
      variant: _designSystemReact.TextVariant.BodySm
    },
    onClick: onActionClick,
    className: "mt-2 rounded-lg"
  }, actionText) : null)));
};
exports.Toast = Toast;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\toast\\toast.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\token-list-item\\index.ts", {"./token-list-item":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\token-list-item\\token-list-item.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Ctoken-list-item%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "TokenListItem", {
  enumerable: true,
  get: function () {
    return _tokenListItem.TokenListItem;
  }
});
var _tokenListItem = require("./token-list-item");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\token-list-item\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\token-list-item\\price\\percentage-and-amount-change\\percentage-and-amount-change.tsx", {"../../../../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../../../../../shared/constants/common":"D:\\code\\v\\metamask-extension\\shared\\constants\\common.ts","../../../../../../shared/modules/Numeric":"D:\\code\\v\\metamask-extension\\shared\\modules\\Numeric.ts","../../../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../../hooks/useFormatters":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useFormatters.ts","../../../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","@metamask/assets-controllers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\index.cjs","bignumber.js":"D:\\code\\v\\metamask-extension\\node_modules\\bignumber.js\\bignumber.js","ethereumjs-util":"D:\\code\\v\\metamask-extension\\node_modules\\ethereumjs-util\\dist.browser\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Ctoken-list-item%5Cprice%5Cpercentage-and-amount-change%5Cpercentage-and-amount-change.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderPercentageWithNumber = exports.PercentageAndAmountChange = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _bignumber = require("bignumber.js");
var _ethereumjsUtil = require("ethereumjs-util");
var _assetsControllers = require("@metamask/assets-controllers");
var _componentLibrary = require("../../../../component-library");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _networks = require("../../../../../../shared/modules/selectors/networks");
var _selectors = require("../../../../../selectors");
var _useFormatters = require("../../../../../hooks/useFormatters");
var _common = require("../../../../../../shared/constants/common");
var _Numeric = require("../../../../../../shared/modules/Numeric");
var _metamask = require("../../../../../ducks/metamask/metamask");
var _util = require("../../../../../../app/scripts/lib/util");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const renderPercentageWithNumber = (value, formattedValuePrice, color) => {
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    className: "gap-1"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: color,
    "data-testid": "token-increase-decrease-value",
    style: {
      whiteSpace: 'pre'
    },
    ellipsis: true
  }, formattedValuePrice), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    color: color,
    "data-testid": "token-increase-decrease-percentage",
    ellipsis: true
  }, value));
};
exports.renderPercentageWithNumber = renderPercentageWithNumber;
const PercentageAndAmountChange = ({
  value
}) => {
  const fiatCurrency = (0, _reactRedux.useSelector)(_metamask.getCurrentCurrency);
  const {
    formatCurrencyCompact
  } = (0, _useFormatters.useFormatters)();
  const balanceValue = (0, _reactRedux.useSelector)(_selectors.getSelectedAccountCachedBalance);
  const conversionRate = (0, _reactRedux.useSelector)(_metamask.getConversionRate);
  const nativeCurrency = (0, _reactRedux.useSelector)(_metamask.getNativeCurrency);
  const marketData = (0, _reactRedux.useSelector)(_selectors.getTokensMarketData);
  const currentChainId = (0, _reactRedux.useSelector)(_networks.getCurrentChainId);
  const balanceChange = (0, _react.useMemo)(() => {
    var _marketData$getNative;
    // Extracts the 1-day percentage change in price from marketData using the zero address as a key.
    const percentage1d = marketData === null || marketData === void 0 || (_marketData$getNative = marketData[(0, _assetsControllers.getNativeTokenAddress)(currentChainId)]) === null || _marketData$getNative === void 0 ? void 0 : _marketData$getNative.pricePercentChange1d;

    // Checks if the balanceValue is in hex format. This is important for cryptocurrency balances which are often represented in hex.
    if ((0, _ethereumjsUtil.isHexString)(balanceValue)) {
      // Converts the hex string balanceValue to a Numeric object for precise arithmetic operations. Assumes balance is in WEI (smallest Ether unit).
      let numeric = new _Numeric.Numeric(balanceValue, 16, _common.EtherDenomination.WEI);

      // If the native currency of the balance is different from the fiat currency, applies a conversion rate to the balance.
      if (nativeCurrency !== fiatCurrency) {
        numeric = numeric.applyConversionRate(conversionRate);
      }

      // If the numeric balance is zero, immediately returns 0 to indicate no change.
      if (numeric.isZero()) {
        return 0;
      }

      // If there's a valid 1-day percentage change, calculates the balance change.
      if (percentage1d) {
        return numeric.toBase(10).toDenomination(_common.EtherDenomination.ETH).round(2, _bignumber.BigNumber.ROUND_HALF_DOWN).times(percentage1d, 10).divide(100, 10).toNumber();
      }
      // Returns null if balanceValue is not a hex string or if percentage1d is not available.
      return null;
    }
    return null;
  }, [marketData]);
  let color = _designSystem.TextColor.textDefault;
  if ((0, _util.isValidAmount)(balanceChange)) {
    if (balanceChange === 0) {
      color = _designSystem.TextColor.textDefault;
    } else if (balanceChange > 0) {
      color = _designSystem.TextColor.successDefault;
    } else {
      color = _designSystem.TextColor.errorDefault;
    }
  }
  const formattedValue = (0, _util.formatValue)(balanceChange === 0 ? 0 : value, true);
  let formattedValuePrice = '';
  if ((0, _util.isValidAmount)(balanceChange)) {
    formattedValuePrice = balanceChange >= 0 ? '+' : '';
    formattedValuePrice += formatCurrencyCompact(balanceChange ?? 0, fiatCurrency);
  }
  return renderPercentageWithNumber(formattedValue, formattedValuePrice, color);
};
exports.PercentageAndAmountChange = PercentageAndAmountChange;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\token-list-item\\price\\percentage-and-amount-change\\percentage-and-amount-change.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\token-list-item\\price\\percentage-change\\index.ts", {"./percentage-change":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\token-list-item\\price\\percentage-change\\percentage-change.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Ctoken-list-item%5Cprice%5Cpercentage-change%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "PercentageChange", {
  enumerable: true,
  get: function () {
    return _percentageChange.PercentageChange;
  }
});
var _percentageChange = require("./percentage-change");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\token-list-item\\price\\percentage-change\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\token-list-item\\price\\percentage-change\\percentage-change.tsx", {"../../../../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Ctoken-list-item%5Cprice%5Cpercentage-change%5Cpercentage-change.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.PercentageChange = void 0;
var _react = _interopRequireDefault(require("react"));
var _componentLibrary = require("../../../../component-library");
var _designSystem = require("../../../../../helpers/constants/design-system");
var _util = require("../../../../../../app/scripts/lib/util");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const PercentageChange = ({
  value,
  address
}) => {
  let color = _designSystem.TextColor.textAlternative;
  if ((0, _util.isValidAmount)(value)) {
    if (value === 0) {
      color = _designSystem.TextColor.textDefault;
    } else if (value > 0) {
      color = _designSystem.TextColor.successDefault;
    } else {
      color = _designSystem.TextColor.errorDefault;
    }
  }
  const formattedValue = (0, _util.formatValue)(value, false);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    gap: 1
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySmMedium,
    color: color,
    "data-testid": `token-increase-decrease-percentage-${address}`,
    ellipsis: true
  }, formattedValue));
};
exports.PercentageChange = PercentageChange;
var _default = exports.default = PercentageChange;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\token-list-item\\price\\percentage-change\\percentage-change.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\token-list-item\\stakeable-link.tsx", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/portfolio":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\portfolio.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Ctoken-list-item%5Cstakeable-link.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StakeableLink = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../component-library");
var _metametrics = require("../../../../shared/constants/metametrics");
var _portfolio = require("../../../helpers/utils/portfolio");
var _selectors = require("../../../selectors");
var _metametrics2 = require("../../../contexts/metametrics");
var _useI18nContext = require("../../../hooks/useI18nContext");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StakeableLink = ({
  chainId,
  symbol
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const trackEvent = (0, _react.useContext)(_metametrics2.MetaMetricsContext);
  const metaMetricsId = (0, _reactRedux.useSelector)(_selectors.getMetaMetricsId);
  const isMetaMetricsEnabled = (0, _reactRedux.useSelector)(_selectors.getParticipateInMetaMetrics);
  const isMarketingEnabled = (0, _reactRedux.useSelector)(_selectors.getDataCollectionForMarketing);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    as: "button",
    backgroundColor: _designSystem.BackgroundColor.transparent,
    "data-testid": `staking-entrypoint-${chainId}`,
    gap: 1,
    paddingInline: 0,
    paddingInlineStart: 1,
    paddingInlineEnd: 1,
    tabIndex: 0,
    onClick: e => {
      e.preventDefault();
      e.stopPropagation();
      const url = (0, _portfolio.getPortfolioUrl)('stake', 'ext_stake_button', metaMetricsId, isMetaMetricsEnabled, isMarketingEnabled);
      global.platform.openTab({
        url
      });
      trackEvent({
        event: _metametrics.MetaMetricsEventName.StakingEntryPointClicked,
        category: _metametrics.MetaMetricsEventCategory.Tokens,
        properties: {
          location: 'Token List Item',
          text: 'Stake',
          // FIXME: This might not be a number for non-EVM accounts
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          chain_id: chainId,
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          token_symbol: symbol
        }
      });
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "span"
  }, "\u2022"), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "span",
    color: _designSystem.TextColor.primaryDefault,
    paddingInlineStart: 1,
    paddingInlineEnd: 1,
    fontWeight: _designSystem.FontWeight.Medium
  }, t('earn')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.Stake,
    size: _componentLibrary.IconSize.Xs,
    color: _designSystem.IconColor.primaryDefault
  }));
};
exports.StakeableLink = StakeableLink;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\token-list-item\\stakeable-link.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\token-list-item\\token-list-item.tsx", {"../../../../shared/constants/bridge":"D:\\code\\v\\metamask-extension\\shared\\constants\\bridge.ts","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../ducks/bridge/selectors":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\selectors.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../ui/tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\index.js","./price/percentage-change/percentage-change":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\token-list-item\\price\\percentage-change\\percentage-change.tsx","./stakeable-link":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\token-list-item\\stakeable-link.tsx","@metamask/assets-controllers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\index.cjs","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cmultichain%5Ctoken-list-item%5Ctoken-list-item.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TokenListItemComponent = exports.TokenListItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _classnames = _interopRequireDefault(require("classnames"));
var _assetsControllers = require("@metamask/assets-controllers");
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../component-library");
var _selectors = require("../../../selectors");
var _multichain = require("../../../selectors/multichain");
var _tooltip = _interopRequireDefault(require("../../ui/tooltip"));
var _useI18nContext = require("../../../hooks/useI18nContext");
var _metametrics = require("../../../contexts/metametrics");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _network = require("../../../../shared/constants/network");
var _routes = require("../../../helpers/constants/routes");
var _actions = require("../../../store/actions");
var _bridge = require("../../../../shared/constants/bridge");
var _networks = require("../../../../shared/modules/selectors/networks");
var _selectors2 = require("../../../ducks/bridge/selectors");
var _percentageChange = require("./price/percentage-change/percentage-change");
var _stakeableLink = require("./stakeable-link");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const TokenListItemComponent = ({
  className,
  onClick,
  tokenSymbol,
  tokenImage,
  primary,
  secondary,
  title,
  tooltipText,
  tokenChainImage,
  chainId,
  isNativeCurrency = false,
  isStakeable = false,
  isTitleNetworkName = false,
  isTitleHidden = false,
  address = null,
  showPercentage = false,
  privacyMode = false,
  nativeCurrencySymbol,
  isDestinationToken = false
}) => {
  var _multiChainMarketData, _allNetworks, _multiChainMarketData2;
  const t = (0, _useI18nContext.useI18nContext)();
  const isEvm = (0, _reactRedux.useSelector)(_multichain.getMultichainIsEvm);
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const currencyRates = (0, _reactRedux.useSelector)(_selectors.getCurrencyRates);
  const noFeeAssets = (0, _reactRedux.useSelector)(state => (0, _selectors2.selectNoFeeAssets)(state, chainId));

  // We do not want to display any percentage with non-EVM since we don't have the data for this yet. So
  // we only use this option for EVM here:
  const shouldShowPercentage = isEvm && showPercentage;
  const isOriginalTokenSymbol = tokenSymbol && currencyRates[tokenSymbol];

  // Scam warning
  const showScamWarning = isNativeCurrency && !isOriginalTokenSymbol && shouldShowPercentage;
  const dispatch = (0, _reactRedux.useDispatch)();
  const [showScamWarningModal, setShowScamWarningModal] = (0, _react.useState)(false);
  const history = (0, _reactRouterDom.useHistory)();
  const getTokenTitle = () => {
    if (isTitleNetworkName) {
      return _bridge.NETWORK_TO_SHORT_NETWORK_NAME_MAP[chainId];
    }
    if (isTitleHidden) {
      return undefined;
    }
    switch (title) {
      case _network.CURRENCY_SYMBOLS.ETH:
        return t('networkNameEthereum');
      case _network.NON_EVM_CURRENCY_SYMBOLS.BTC:
        return t('networkNameBitcoin');
      case _network.NON_EVM_CURRENCY_SYMBOLS.SOL:
        return t('networkNameSolana');
      default:
        return title;
    }
  };
  const multiChainMarketData = (0, _reactRedux.useSelector)(_selectors.getMarketData);
  const tokenPercentageChange = address ? multiChainMarketData === null || multiChainMarketData === void 0 || (_multiChainMarketData = multiChainMarketData[chainId]) === null || _multiChainMarketData === void 0 || (_multiChainMarketData = _multiChainMarketData[address]) === null || _multiChainMarketData === void 0 ? void 0 : _multiChainMarketData.pricePercentChange1d : null;
  const tokenTitle = getTokenTitle();
  const tokenMainTitleToDisplay = shouldShowPercentage && !isTitleNetworkName ? tokenTitle : tokenSymbol;
  const isNoFeeAsset = isDestinationToken && address && (noFeeAssets === null || noFeeAssets === void 0 ? void 0 : noFeeAssets.includes(address.toLowerCase()));

  // Used for badge icon
  const allNetworks = (0, _reactRedux.useSelector)(_networks.getNetworkConfigurationsByChainId);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  , {
    className: (0, _classnames.default)('multichain-token-list-item', className || {}),
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    width: _designSystem.BlockSize.Full,
    height: _designSystem.BlockSize.Full,
    gap: 4,
    "data-testid": "multichain-token-list-item",
    title: tooltipText ? t(tooltipText) : undefined
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, _extends({
    className: (0, _classnames.default)('multichain-token-list-item__container-cell', {
      'multichain-token-list-item__container-cell--clickable': onClick !== undefined
    }),
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    paddingTop: 2,
    paddingBottom: 2,
    paddingLeft: 4,
    paddingRight: 4,
    width: _designSystem.BlockSize.Full,
    style: {
      height: 62
    },
    "data-testid": "multichain-token-list-button"
  }, onClick && {
    as: 'a',
    href: '#',
    onClick: e => {
      e.preventDefault();
      if (showScamWarningModal) {
        return;
      }
      onClick();
      trackEvent({
        category: _metametrics2.MetaMetricsEventCategory.Tokens,
        event: _metametrics2.MetaMetricsEventName.TokenDetailsOpened,
        properties: {
          location: 'Home',
          // FIXME: This might not be a number for non-EVM accounts
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          chain_id: chainId,
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          token_symbol: tokenSymbol
        }
      });
    }
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.BadgeWrapper, {
    badge: /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarNetwork, {
      size: _componentLibrary.AvatarNetworkSize.Xs,
      name: allNetworks === null || allNetworks === void 0 || (_allNetworks = allNetworks[chainId]) === null || _allNetworks === void 0 ? void 0 : _allNetworks.name
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
      // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
      ,
      src: tokenChainImage || undefined,
      backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
      borderWidth: 2,
      className: "multichain-token-list-item__badge__avatar-network"
    }),
    marginRight: 4,
    className: "multichain-token-list-item__badge"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarToken, {
    name: tokenSymbol,
    src: tokenImage
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "multichain-token-list-item__container-cell--text-container",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    width: _designSystem.BlockSize.Full,
    style: {
      flexGrow: 1,
      overflow: 'hidden'
    },
    justifyContent: _designSystem.JustifyContent.center
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    gap: 2
  }, (title === null || title === void 0 ? void 0 : title.length) > 12 ? /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    position: "bottom",
    html: title,
    tooltipInnerClassName: "multichain-token-list-item__tooltip"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "span",
    fontWeight: _designSystem.FontWeight.Medium,
    variant: _designSystem.TextVariant.bodyMd,
    display: _designSystem.Display.Block,
    ellipsis: true
  }, tokenMainTitleToDisplay, isStakeable && /*#__PURE__*/_react.default.createElement(_stakeableLink.StakeableLink, {
    chainId: chainId,
    symbol: tokenSymbol
  }))) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    fontWeight: _designSystem.FontWeight.Medium,
    variant: _designSystem.TextVariant.bodyMd,
    ellipsis: true
  }, tokenMainTitleToDisplay, isStakeable && /*#__PURE__*/_react.default.createElement(_stakeableLink.StakeableLink, {
    chainId: chainId,
    symbol: tokenSymbol
  })), isNoFeeAsset && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    backgroundColor: _designSystem.BackgroundColor.backgroundSection,
    borderRadius: _designSystem.BorderRadius.SM,
    paddingInline: 1,
    paddingTop: 0,
    paddingBottom: 0,
    style: {
      height: '20px',
      display: 'flex',
      alignItems: 'center'
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    fontWeight: _designSystem.FontWeight.Medium,
    color: _designSystem.TextColor.textAlternative,
    style: {
      lineHeight: '20px',
      whiteSpace: 'nowrap'
    }
  }, t('bridgeNoMMFee')))), showScamWarning ? /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    iconName: _componentLibrary.IconName.Danger,
    onClick: e => {
      e.preventDefault();
      e.stopPropagation();
      setShowScamWarningModal(true);
    },
    color: _designSystem.IconColor.errorDefault,
    size: _componentLibrary.ButtonIconSize.Md,
    backgroundColor: _designSystem.BackgroundColor.transparent,
    "data-testid": "scam-warning",
    ariaLabel: ""
  }) : /*#__PURE__*/_react.default.createElement(_componentLibrary.SensitiveText, {
    fontWeight: _designSystem.FontWeight.Medium,
    variant: _designSystem.TextVariant.bodyMd,
    textAlign: _designSystem.TextAlign.End,
    "data-testid": "multichain-token-list-item-secondary-value",
    ellipsis: isStakeable,
    isHidden: privacyMode,
    length: _componentLibrary.SensitiveTextLength.Medium
  }, secondary)), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, shouldShowPercentage ? /*#__PURE__*/_react.default.createElement(_percentageChange.PercentageChange, {
    value: isNativeCurrency ? multiChainMarketData === null || multiChainMarketData === void 0 || (_multiChainMarketData2 = multiChainMarketData[chainId]) === null || _multiChainMarketData2 === void 0 || (_multiChainMarketData2 = _multiChainMarketData2[(0, _assetsControllers.getNativeTokenAddress)(chainId)]) === null || _multiChainMarketData2 === void 0 ? void 0 : _multiChainMarketData2.pricePercentChange1d : tokenPercentageChange,
    address: isNativeCurrency ? (0, _assetsControllers.getNativeTokenAddress)(chainId) : address
  }) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySmMedium,
    color: _designSystem.TextColor.textAlternative,
    "data-testid": "multichain-token-list-item-token-name",
    ellipsis: true
  }, tokenTitle), showScamWarning ? /*#__PURE__*/_react.default.createElement(_componentLibrary.SensitiveText, {
    "data-testid": "multichain-token-list-item-value",
    color: _designSystem.TextColor.textAlternative,
    variant: _designSystem.TextVariant.bodyMd,
    textAlign: _designSystem.TextAlign.End,
    isHidden: privacyMode,
    length: _componentLibrary.SensitiveTextLength.Short
  }, primary) : /*#__PURE__*/_react.default.createElement(_componentLibrary.SensitiveText, {
    "data-testid": "multichain-token-list-item-value",
    color: _designSystem.TextColor.textAlternative,
    variant: _designSystem.TextVariant.bodySmMedium,
    textAlign: _designSystem.TextAlign.End,
    isHidden: privacyMode,
    length: _componentLibrary.SensitiveTextLength.Short
  }, primary)))), isEvm && showScamWarningModal ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Modal, {
    isOpen: true,
    onClose: () => setShowScamWarningModal(false)
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalOverlay, null), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalContent, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalHeader, {
    onClose: () => setShowScamWarningModal(false)
  }, t('nativeTokenScamWarningTitle')), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalBody, {
    marginTop: 4,
    marginBottom: 4
  }, t('nativeTokenScamWarningDescription', [tokenSymbol,
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  nativeCurrencySymbol || t('nativeTokenScamWarningDescriptionExpectedTokenFallback') // never render "undefined" string value
  ])), /*#__PURE__*/_react.default.createElement(_componentLibrary.ModalFooter, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonSecondary, {
    onClick: () => {
      dispatch((0, _actions.setEditedNetwork)({
        chainId
      }));
      history.push(_routes.NETWORKS_ROUTE);
    },
    block: true
  }, t('nativeTokenScamWarningConversion'))))) : null);
};
exports.TokenListItemComponent = TokenListItemComponent;
const TokenListItem = exports.TokenListItem = /*#__PURE__*/_react.default.memo(TokenListItemComponent);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\multichain\\token-list-item\\token-list-item.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\account-list\\account-list.js", {"../../../helpers/constants/common":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\common.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../app/user-preferenced-currency-display":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\user-preferenced-currency-display\\index.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../identicon":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\identicon\\index.js","../tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\index.js","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Caccount-list%5Caccount-list.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _lodash = require("lodash");
var _keyringApi = require("@metamask/keyring-api");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _identicon = _interopRequireDefault(require("../identicon"));
var _userPreferencedCurrencyDisplay = _interopRequireDefault(require("../../app/user-preferenced-currency-display"));
var _common = require("../../../helpers/constants/common");
var _tooltip = _interopRequireDefault(require("../tooltip"));
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AccountList = ({
  selectNewAccountViaModal,
  accounts,
  addressLastConnectedMap,
  selectedAccounts,
  nativeCurrency,
  allAreSelected,
  deselectAll,
  selectAll,
  handleAccountClick
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const selectedAccountScrollRef = (0, _react.useRef)(null);
  (0, _react.useLayoutEffect)(() => {
    var _selectedAccountScrol;
    (_selectedAccountScrol = selectedAccountScrollRef.current) === null || _selectedAccountScrol === void 0 || _selectedAccountScrol.scrollIntoView({
      behavior: 'smooth'
    });
  }, []);
  const [firstSelectedAccount] = selectedAccounts;
  const handleEvmAccountClick = account => {
    if (!(0, _keyringApi.isEvmAccountType)(account.type)) {
      return;
    }
    handleAccountClick(account.address);
  };
  const Header = () => {
    const checked = allAreSelected();
    const isIndeterminate = !checked && selectedAccounts.size !== 0;
    return /*#__PURE__*/_react.default.createElement("div", {
      className: (0, _classnames.default)({
        'choose-account-list__header--one-item': accounts.length === 1,
        'choose-account-list__header--multiple-items': accounts.length > 1
      })
    }, accounts.length > 1 ? /*#__PURE__*/_react.default.createElement("div", {
      className: "choose-account-list__select-all"
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Checkbox, {
      className: "choose-account-list__header-check-box",
      "data-testid": "choose-account-list-operate-all-check-box",
      isChecked: checked,
      isIndeterminate: isIndeterminate,
      onClick: () => allAreSelected() ? deselectAll() : selectAll()
    }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      as: "div",
      className: "choose-account-list__text-grey",
      color: _designSystem.TextColor.textAlternative
    }, t('selectAll')), /*#__PURE__*/_react.default.createElement(_tooltip.default, {
      position: "bottom",
      html: /*#__PURE__*/_react.default.createElement("div", {
        style: {
          width: 200,
          padding: 4
        }
      }, t('selectingAllWillAllow'))
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
      name: _componentLibrary.IconName.Info,
      color: _designSystem.IconColor.iconMuted,
      className: "info-circle",
      marginInlineStart: 2
    }))) : null, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonLink, {
      color: _designSystem.TextColor.infoDefault,
      variant: _designSystem.TextVariant.bodyMdMedium,
      style: {
        cursor: 'pointer'
      },
      onClick: () => selectNewAccountViaModal(handleAccountClick)
    }, t('newAccount')));
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "choose-account-list"
  }, /*#__PURE__*/_react.default.createElement(Header, null), /*#__PURE__*/_react.default.createElement("div", {
    className: "choose-account-list__wrapper"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "choose-account-list__list",
    style: {
      overflowX: 'hidden'
    }
  }, accounts.map((account, index) => {
    const {
      address,
      addressLabel,
      balance
    } = account;
    const isSelectedAccount = selectedAccounts.has(address);
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      width: _designSystem.BlockSize.Full,
      key: `choose-account-list-${index}`,
      "data-testid": `choose-account-list-${index}`,
      onClick: () => handleEvmAccountClick(account),
      className: "choose-account-list__account",
      ref: isSelectedAccount && address === firstSelectedAccount ? selectedAccountScrollRef : null,
      backgroundColor: isSelectedAccount ? _designSystem.Color.primaryMuted : _designSystem.BackgroundColor.backgroundDefault
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      width: _designSystem.BlockSize.Full,
      alignItems: _designSystem.AlignItems.center
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Checkbox, {
      isChecked: isSelectedAccount,
      isDisabled: !(0, _keyringApi.isEvmAccountType)(account.type)
    }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      marginLeft: 2
    }, /*#__PURE__*/_react.default.createElement(_identicon.default, {
      diameter: 34,
      address: address
    })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      justifyContent: _designSystem.JustifyContent.spaceBetween,
      width: _designSystem.BlockSize.Full,
      paddingLeft: 3,
      style: {
        minWidth: 0
      }
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      flexDirection: _designSystem.FlexDirection.Column,
      width: _designSystem.BlockSize.Full
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyMdMedium,
      style: {
        textWrap: 'nowrap'
      },
      ellipsis: true
    }, addressLabel), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex
    }, /*#__PURE__*/_react.default.createElement(_userPreferencedCurrencyDisplay.default, {
      account: account,
      type: _common.PRIMARY,
      value: balance,
      style: {
        color: 'var(--color-text-alternative)',
        flexWrap: 'nowrap'
      },
      suffix: nativeCurrency,
      numberOfDecimals: 2,
      ethNumberOfDecimals: 5,
      textProps: {
        color: _designSystem.TextColor.textAlternative,
        variant: _designSystem.TextVariant.bodySm
      },
      suffixProps: {
        color: _designSystem.TextColor.textAlternative,
        variant: _designSystem.TextVariant.bodySm
      }
    })))), addressLastConnectedMap[address] ? /*#__PURE__*/_react.default.createElement(_tooltip.default, {
      title: `${t('lastConnected')} ${addressLastConnectedMap[address]}`
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
      name: _componentLibrary.IconName.Info,
      color: _designSystem.IconColor.iconMuted,
      className: "info-circle",
      marginInlineStart: 2
    })) : null));
  }))));
};
AccountList.propTypes = {
  /**
   * Array of user account objects
   */
  accounts: _propTypes.default.arrayOf(_propTypes.default.shape({
    address: _propTypes.default.string,
    addressLabel: _propTypes.default.string,
    lastConnectedDate: _propTypes.default.string,
    balance: _propTypes.default.string
  })).isRequired,
  /**
   * Function to select a new account via modal
   */
  selectNewAccountViaModal: _propTypes.default.func.isRequired,
  /**
   * A map of the last connected addresses
   */
  addressLastConnectedMap: _propTypes.default.object,
  /**
   * Native currency of current chain
   */
  nativeCurrency: _propTypes.default.string.isRequired,
  /**
   * Currently selected accounts
   */
  selectedAccounts: _propTypes.default.object.isRequired,
  /**
   * Function to check if all accounts are selected
   */
  allAreSelected: _propTypes.default.func.isRequired,
  /**
   * Function to deselect all accounts
   */
  deselectAll: _propTypes.default.func.isRequired,
  /**
   * Function to select all accounts
   */
  selectAll: _propTypes.default.func.isRequired,
  /**
   * Function to handle account click
   */
  handleAccountClick: _propTypes.default.func.isRequired
};
var _default = exports.default = /*#__PURE__*/(0, _react.memo)(AccountList, (prevProps, nextProps) => {
  return (0, _lodash.isEqual)(prevProps.selectedAccounts, nextProps.selectedAccounts);
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\account-list\\account-list.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\account-list\\index.js", {"./account-list":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\account-list\\account-list.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Caccount-list%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _accountList.default;
  }
});
var _accountList = _interopRequireDefault(require("./account-list"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\account-list\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\account-mismatch-warning\\account-mismatch-warning.component.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../icon/info-icon.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\icon\\info-icon.component.js","../tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Caccount-mismatch-warning%5Caccount-mismatch-warning.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = AccountMismatchWarning;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _tooltip = _interopRequireDefault(require("../tooltip"));
var _selectors = require("../../../selectors");
var _infoIcon = _interopRequireDefault(require("../icon/info-icon.component"));
var _useI18nContext = require("../../../hooks/useI18nContext");
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function AccountMismatchWarning({
  address
}) {
  const selectedAccount = (0, _reactRedux.useSelector)(_selectors.getSelectedAccount);
  const t = (0, _useI18nContext.useI18nContext)();
  if (selectedAccount.address === address) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    position: "bottom",
    html: /*#__PURE__*/_react.default.createElement("p", null, t('notCurrentAccount')),
    wrapperClassName: "account-mismatch-warning__tooltip-wrapper",
    containerClassName: "account-mismatch-warning__tooltip-container"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "account-mismatch-warning__tooltip-container-icon",
    "data-testid": "account-mismatch-warning-tooltip"
  }, /*#__PURE__*/_react.default.createElement(_infoIcon.default, {
    severity: _designSystem.Severity.Warning
  })));
}
AccountMismatchWarning.propTypes = {
  address: _propTypes.default.string.isRequired
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\account-mismatch-warning\\account-mismatch-warning.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\actionable-message\\actionable-message.js", {"../info-tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\info-tooltip\\index.js","../info-tooltip/info-tooltip-icon":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\info-tooltip\\info-tooltip-icon.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cactionable-message%5Cactionable-message.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ActionableMessage;
exports.typeHash = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _infoTooltip = _interopRequireDefault(require("../info-tooltip"));
var _infoTooltipIcon = _interopRequireDefault(require("../info-tooltip/info-tooltip-icon"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CLASSNAME_WARNING = 'actionable-message--warning';
const CLASSNAME_DANGER = 'actionable-message--danger';
const CLASSNAME_SUCCESS = 'actionable-message--success';
const CLASSNAME_WITH_RIGHT_BUTTON = 'actionable-message--with-right-button';
const typeHash = exports.typeHash = {
  warning: CLASSNAME_WARNING,
  danger: CLASSNAME_DANGER,
  success: CLASSNAME_SUCCESS,
  default: ''
};

/**
 * @deprecated `<ActionableMessage />` has been deprecated in favor of the `<BannerAlert />`
 * component in ./ui/components/component-library/banner-alert/banner-alert.js.
 * See storybook documentation for BannerAlert here:
 * {@see {@link https://metamask.github.io/metamask-storybook/?path=/docs/components-componentlibrary-banneralert--default-story#banneralert}}
 *
 * Help to replace `ActionableMessage` with `BannerAlert` by submitting a PR against
 * {@link https://github.com/MetaMask/metamask-extension/issues/19528}
 */

function ActionableMessage({
  message = '',
  primaryAction = null,
  primaryActionV2 = null,
  secondaryAction = null,
  className = '',
  infoTooltipText = '',
  withRightButton = false,
  type = 'default',
  useIcon = false,
  icon,
  iconFillColor = '',
  roundedButtons,
  dataTestId,
  autoHideTime = 0,
  onAutoHide
}) {
  const [shouldDisplay, setShouldDisplay] = (0, _react.useState)(true);
  (0, _react.useEffect)(function () {
    if (autoHideTime === 0) {
      return undefined;
    }
    const timeout = setTimeout(() => {
      onAutoHide === null || onAutoHide === void 0 || onAutoHide();
      setShouldDisplay(false);
    }, autoHideTime);
    return function () {
      clearTimeout(timeout);
    };
  }, [autoHideTime, onAutoHide]);
  const actionableMessageClassName = (0, _classnames.default)('actionable-message', typeHash[type], withRightButton ? CLASSNAME_WITH_RIGHT_BUTTON : null, className, {
    'actionable-message--with-icon': useIcon
  });
  const onlyOneAction = primaryAction && !secondaryAction || secondaryAction && !primaryAction;
  if (!shouldDisplay) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: actionableMessageClassName,
    "data-testid": dataTestId
  }, useIcon ? icon || /*#__PURE__*/_react.default.createElement(_infoTooltipIcon.default, {
    fillColor: iconFillColor
  }) : null, infoTooltipText && /*#__PURE__*/_react.default.createElement(_infoTooltip.default, {
    position: "left",
    contentText: infoTooltipText,
    wrapperClassName: "actionable-message__info-tooltip-wrapper"
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "actionable-message__message"
  }, message), primaryActionV2 && /*#__PURE__*/_react.default.createElement("button", {
    className: "actionable-message__action-v2",
    onClick: primaryActionV2.onClick
  }, primaryActionV2.label), (primaryAction || secondaryAction) && /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('actionable-message__actions', {
      'actionable-message__actions--single': onlyOneAction
    })
  }, primaryAction && /*#__PURE__*/_react.default.createElement("button", {
    className: (0, _classnames.default)('actionable-message__action', 'actionable-message__action--primary', `actionable-message__action-${type}`, {
      'actionable-message__action--rounded': roundedButtons
    }),
    onClick: primaryAction.onClick
  }, primaryAction.label), secondaryAction && /*#__PURE__*/_react.default.createElement("button", {
    className: (0, _classnames.default)('actionable-message__action', 'actionable-message__action--secondary', `actionable-message__action-${type}`, {
      'actionable-message__action--rounded': roundedButtons
    }),
    onClick: secondaryAction.onClick
  }, secondaryAction.label)));
}
ActionableMessage.propTypes = {
  /**
   * Text inside actionable message
   */
  message: _propTypes.default.node.isRequired,
  /**
   * First button props that have label and onClick props
   */
  primaryAction: _propTypes.default.shape({
    label: _propTypes.default.string,
    onClick: _propTypes.default.func
  }),
  /**
   * Another style of primary action.
   * This probably shouldn't have been added. A `children` prop might have been more appropriate.
   */
  primaryActionV2: _propTypes.default.shape({
    label: _propTypes.default.string,
    onClick: _propTypes.default.func
  }),
  /**
   * Second button props that have label and onClick props
   */
  secondaryAction: _propTypes.default.shape({
    label: _propTypes.default.string,
    onClick: _propTypes.default.func
  }),
  /**
   * Additional css className for the component based on the parent css
   */
  className: _propTypes.default.string,
  /**
   * change color theme for the component that already predefined in css
   */
  type: _propTypes.default.oneOf(Object.keys(typeHash)),
  /**
   * change text align to left and button to bottom right
   */
  withRightButton: _propTypes.default.bool,
  /**
   * Add tooltip and custom message
   */
  infoTooltipText: _propTypes.default.string,
  /**
   * Add tooltip icon in the left component without message
   */
  useIcon: _propTypes.default.bool,
  /**
   * Custom icon component
   */
  icon: _propTypes.default.node,
  /**
   * change tooltip icon color
   */
  iconFillColor: _propTypes.default.string,
  /**
   * Whether the buttons are rounded
   */
  roundedButtons: _propTypes.default.bool,
  dataTestId: _propTypes.default.string,
  /**
   * Whether the actionable message should auto-hide itself after a given amount of time
   */
  autoHideTime: _propTypes.default.number,
  /**
   * Callback when autoHide time expires
   */
  onAutoHide: _propTypes.default.func
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\actionable-message\\actionable-message.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\actionable-message\\index.js", {"./actionable-message":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\actionable-message\\actionable-message.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cactionable-message%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _actionableMessage.default;
  }
});
var _actionableMessage = _interopRequireDefault(require("./actionable-message"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\actionable-message\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\aggregated-balance\\aggregated-balance.tsx", {"../../../ducks/locale/locale":"D:\\code\\v\\metamask-extension\\ui\\ducks\\locale\\locale.ts","../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/number-utils":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\number-utils.ts","../../../hooks/useMultichainSelector":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainSelector.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/assets":"D:\\code\\v\\metamask-extension\\ui\\selectors\\assets.ts","../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../app/assets/util/formatWithThreshold":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\util\\formatWithThreshold.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../component-library/skeleton":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\skeleton\\index.ts","@metamask/multichain-network-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-network-controller\\dist\\index.cjs","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Caggregated-balance%5Caggregated-balance.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AggregatedBalance = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _classnames = _interopRequireDefault(require("classnames"));
var _multichainNetworkController = require("@metamask/multichain-network-controller");
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../component-library");
var _metamask = require("../../../ducks/metamask/metamask");
var _assets = require("../../../selectors/assets");
var _selectors = require("../../../selectors");
var _multichain = require("../../../selectors/multichain");
var _formatWithThreshold = require("../../app/assets/util/formatWithThreshold");
var _locale = require("../../../ducks/locale/locale");
var _useMultichainSelector = require("../../../hooks/useMultichainSelector");
var _skeleton = require("../../component-library/skeleton");
var _numberUtils = require("../../../helpers/utils/number-utils");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const AggregatedBalance = ({
  classPrefix,
  balanceIsCached,
  handleSensitiveToggle
}) => {
  const {
    privacyMode,
    showNativeTokenAsMainBalance
  } = (0, _reactRedux.useSelector)(_selectors.getPreferences);
  const locale = (0, _reactRedux.useSelector)(_locale.getIntlLocale);
  const balances = (0, _reactRedux.useSelector)(_metamask.getTokenBalances);
  const assets = (0, _reactRedux.useSelector)(_assets.getAccountAssets);
  const selectedAccount = (0, _reactRedux.useSelector)(_selectors.getSelectedInternalAccount);
  const currentNetwork = (0, _reactRedux.useSelector)(_multichain.getMultichainNetwork);
  const currentCurrency = (0, _reactRedux.useSelector)(_metamask.getCurrentCurrency);
  const multichainAggregatedBalance = (0, _reactRedux.useSelector)(state => (0, _assets.getMultichainAggregatedBalance)(state, selectedAccount));
  const enabledNetworks = (0, _reactRedux.useSelector)(_selectors.getEnabledNetworksByNamespace);
  const anyEnabledNetworksAreAvailable = (0, _reactRedux.useSelector)(_selectors.selectAnyEnabledNetworksAreAvailable);
  const showNativeTokenAsMain = _selectors.isGlobalNetworkSelectorRemoved ? showNativeTokenAsMainBalance && Object.keys(enabledNetworks).length === 1 : showNativeTokenAsMainBalance;
  const multichainNativeTokenBalance = (0, _reactRedux.useSelector)(state => (0, _assets.getMultichainNativeTokenBalance)(state, selectedAccount));
  const shouldShowFiat = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainShouldShowFiat, selectedAccount);
  const multichainAssetsRates = (0, _reactRedux.useSelector)(_assets.getAssetsRates);
  const isNonEvmRatesAvailable = Object.keys(multichainAssetsRates).length > 0;
  const formattedFiatDisplay = (0, _formatWithThreshold.formatWithThreshold)(multichainAggregatedBalance, 0.0, locale, {
    style: 'currency',
    currency: currentCurrency.toUpperCase()
  });
  const formattedTokenDisplay = (0, _formatWithThreshold.formatWithThreshold)(parseFloat(multichainNativeTokenBalance.amount.toString()), 0.0, locale, {
    minimumFractionDigits: 0,
    maximumFractionDigits: _multichainNetworkController.MULTICHAIN_NETWORK_DECIMAL_PLACES[currentNetwork.chainId] || 5
  });
  return /*#__PURE__*/_react.default.createElement(_skeleton.Skeleton, {
    isLoading: !balances || assets[selectedAccount.id] === undefined || assets[selectedAccount.id].length === 0 || !anyEnabledNetworksAreAvailable && (0, _numberUtils.isZeroAmount)(multichainNativeTokenBalance.amount.toString()),
    marginBottom: 1
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: (0, _classnames.default)(`${classPrefix}-overview__primary-balance`, {
      [`${classPrefix}-overview__cached-balance`]: balanceIsCached
    }),
    "data-testid": `${classPrefix}-overview__primary-currency`,
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    flexWrap: _designSystem.FlexWrap.Wrap
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.SensitiveText, {
    ellipsis: true,
    variant: _designSystem.TextVariant.inherit,
    isHidden: privacyMode,
    "data-testid": "account-value-and-suffix",
    onClick: handleSensitiveToggle,
    className: "cursor-pointer transition-colors duration-200 hover:text-text-alternative"
  }, showNativeTokenAsMain || !isNonEvmRatesAvailable || !shouldShowFiat ? formattedTokenDisplay : formattedFiatDisplay), /*#__PURE__*/_react.default.createElement(_componentLibrary.SensitiveText, {
    marginInlineStart: privacyMode ? 0 : 1,
    variant: _designSystem.TextVariant.inherit,
    isHidden: privacyMode,
    onClick: handleSensitiveToggle,
    className: "cursor-pointer transition-colors duration-200 hover:text-text-alternative"
  }, showNativeTokenAsMain || !isNonEvmRatesAvailable || !shouldShowFiat ? currentNetwork.network.ticker : currentCurrency.toUpperCase())));
};
exports.AggregatedBalance = AggregatedBalance;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\aggregated-balance\\aggregated-balance.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\alert\\index.js", {"../../../../shared/constants/time":"D:\\code\\v\\metamask-extension\\shared\\constants\\time.ts","../../../hooks/usePrevious":"D:\\code\\v\\metamask-extension\\ui\\hooks\\usePrevious.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Calert%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _usePrevious = require("../../../hooks/usePrevious");
var _time = require("../../../../shared/constants/time");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function Alert(props) {
  const [visible, setVisible] = (0, _react.useState)(false);
  const [className, setClassName] = (0, _react.useState)('');
  const lastVisible = (0, _usePrevious.usePrevious)(props.visible);
  (0, _react.useEffect)(() => {
    const animateIn = () => {
      setClassName('visible');
      setVisible(true);
    };
    const animateOut = () => {
      setClassName('hidden');
      setTimeout(_ => {
        setVisible(false);
      }, _time.MILLISECOND * 500);
    };
    if (!lastVisible && props.visible) {
      animateIn(props.msg);
    } else if (lastVisible && !props.visible) {
      animateOut();
    }
  }, [lastVisible, props.msg, props.visible]);
  if (!visible) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('global-alert', className)
  }, /*#__PURE__*/_react.default.createElement("a", {
    className: "msg"
  }, props.msg));
}
Alert.propTypes = {
  visible: _propTypes.default.bool.isRequired,
  msg: _propTypes.default.string
};
var _default = exports.default = Alert;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\alert\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\box\\box.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cbox%5Cbox.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.ValidTextColors = exports.ValidIconColors = exports.ValidBorderColors = exports.ValidBackgroundColor = exports.MultipleTextColors = exports.MultipleSizesAndAuto = exports.MultipleSizes = exports.MultipleJustifyContents = exports.MultipleBorderColors = exports.MultipleBlockSizes = exports.MultipleBackgroundColor = exports.MultipleAlignItems = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _lodash = require("lodash");
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const BASE_CLASS_NAME = 'box';
const Sizes = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12];
const ValidSize = _propTypes.default.oneOf(Sizes);
const ValidBlockSize = _propTypes.default.oneOf(Object.values(_designSystem.BlockSize));
const ValidSizeAndAuto = _propTypes.default.oneOf([...Sizes, 'auto']);
const ValidBackgroundColor = exports.ValidBackgroundColor = _propTypes.default.oneOf(Object.values(_designSystem.BackgroundColor));
const ValidBorderColors = exports.ValidBorderColors = _propTypes.default.oneOf(Object.values(_designSystem.BorderColor));
const ValidTextColors = exports.ValidTextColors = _propTypes.default.oneOf(Object.values(_designSystem.TextColor));
const ValidIconColors = exports.ValidIconColors = _propTypes.default.oneOf(Object.values(_designSystem.IconColor));
const ValidAlignItem = _propTypes.default.oneOf(Object.values(_designSystem.AlignItems));
const ValidJustifyContent = _propTypes.default.oneOf(Object.values(_designSystem.JustifyContent));
const ArrayOfValidSizes = _propTypes.default.arrayOf(ValidSize);
const MultipleSizes = exports.MultipleSizes = _propTypes.default.oneOfType([ValidSize, ArrayOfValidSizes]);
const ArrayOfValidBlockSizes = _propTypes.default.arrayOf(ValidBlockSize);
const MultipleBlockSizes = exports.MultipleBlockSizes = _propTypes.default.oneOfType([ValidBlockSize, ArrayOfValidBlockSizes]);
const ArrayOfValidSizesAndAuto = _propTypes.default.arrayOf(ValidSizeAndAuto);
const MultipleSizesAndAuto = exports.MultipleSizesAndAuto = _propTypes.default.oneOfType([ValidSizeAndAuto, ArrayOfValidSizesAndAuto]);
const ArrayOfValidBorderColors = _propTypes.default.arrayOf(ValidBorderColors);
const MultipleBorderColors = exports.MultipleBorderColors = _propTypes.default.oneOfType([ValidBorderColors, ArrayOfValidBorderColors]);
const ArrayOfValidBackgroundColor = _propTypes.default.arrayOf(ValidBackgroundColor);
const MultipleBackgroundColor = exports.MultipleBackgroundColor = _propTypes.default.oneOfType([ValidBackgroundColor, ArrayOfValidBackgroundColor]);
const ArrayOfValidTextColors = _propTypes.default.arrayOf(ValidTextColors);
const ArrayOfValidIconColors = _propTypes.default.arrayOf(ValidIconColors);
const MultipleTextColors = exports.MultipleTextColors = _propTypes.default.oneOfType([ValidTextColors, ArrayOfValidTextColors, ValidIconColors, ArrayOfValidIconColors]);
const ArrayOfValidAlignItems = _propTypes.default.arrayOf(ValidAlignItem);
const MultipleAlignItems = exports.MultipleAlignItems = _propTypes.default.oneOfType([ValidAlignItem, ArrayOfValidAlignItems]);
const ArrayOfValidJustifyContents = _propTypes.default.arrayOf(ValidJustifyContent);
const MultipleJustifyContents = exports.MultipleJustifyContents = _propTypes.default.oneOfType([ValidJustifyContent, ArrayOfValidJustifyContents]);
function isValidSize(type, value) {
  // Only margin types allow 'auto'
  return typeof value === 'number' || (type === 'margin' || type === 'margin-top' || type === 'margin-right' || type === 'margin-bottom' || type === 'margin-left' || type === 'margin-inline' || type === 'margin-inline-start' || type === 'margin-inline-end') && value === 'auto';
}
function isValidString(type, value) {
  return typeof type === 'string' && typeof value === 'string';
}

/**
 * Generate classnames
 * Generates classnames for different utility styles
 * Also accepts responsive props in the form of an array
 * Maps responsive props to mobile first breakpoints
 *
 * @param {string} type - The style declaration type "margin", "margin-top", "padding", "display" etc
 * @param {array || number || string} value - prop value being passed in array props are responsive props
 * @param {*} validatorFn - The validation function for each type of value
 * @returns
 */

const generateClassNames = (0, _lodash.memoize)((type, value, validatorFn) => {
  // if value does not exist return null
  if (!value) {
    return null;
  }
  const classesObject = {};
  // if value is an array with single item e.g. marginTop={[1]}
  const singleArrayItemProp = Array.isArray(value) && value.length === 1 ? value[0] : undefined;
  // if value single value e.g. marginTop={1}
  const singleValueProp = !Array.isArray(value) && typeof value === 'string' || typeof value === 'number' ? value : undefined;
  // single digit equals single value or single array item
  const singleValue = singleValueProp || singleArrayItemProp;
  // 0 is an acceptable value but is falsy in js
  if (singleValue || singleValue === 0) {
    // add base style without any breakpoint prefixes to classObject
    classesObject[`${BASE_CLASS_NAME}--${type}-${singleValue}`] = validatorFn(type, singleValue);
  } else {
    // If array with more than one item
    switch (value.length) {
      case 4:
        // add base/sm/md/lg
        classesObject[`${BASE_CLASS_NAME}--${type}-${value[0]}`] = value[0] && validatorFn(type, value[0]);
        classesObject[`${BASE_CLASS_NAME}--${_designSystem.BREAKPOINTS[1]}:${type}-${value[1]}`] = value[1] && validatorFn(type, value[1]);
        classesObject[`${BASE_CLASS_NAME}--${_designSystem.BREAKPOINTS[2]}:${type}-${value[2]}`] = value[2] && validatorFn(type, value[2]);
        classesObject[`${BASE_CLASS_NAME}--${_designSystem.BREAKPOINTS[3]}:${type}-${value[3]}`] = value[3] && validatorFn(type, value[3]);
        break;
      case 3:
        // add base/sm/md
        classesObject[`${BASE_CLASS_NAME}--${type}-${value[0]}`] = value[0] && validatorFn(type, value[0]);
        classesObject[`${BASE_CLASS_NAME}--${_designSystem.BREAKPOINTS[1]}:${type}-${value[1]}`] = value[1] && validatorFn(type, value[1]);
        classesObject[`${BASE_CLASS_NAME}--${_designSystem.BREAKPOINTS[2]}:${type}-${value[2]}`] = value[2] && validatorFn(type, value[2]);
        break;
      case 2:
        // add base/sm
        classesObject[`${BASE_CLASS_NAME}--${type}-${value[0]}`] = value[0] && validatorFn(type, value[0]);
        classesObject[`${BASE_CLASS_NAME}--${_designSystem.BREAKPOINTS[1]}:${type}-${value[1]}`] = value[1] && validatorFn(type, value[1]);
        break;
      default:
        console.log(`Invalid array prop length: ${value.length}`);
    }
  }
  return classesObject;
}, (type, value) => `${type}${value}`);

/**
 * @deprecated The JS version of the <Box /> component has been deprecated in favor of the new TS version from the component-library.
 * Please update your code to use the new <Box> component instead
 * import { Box } from '../../component-library';
 * The component API is the same so you should only have to update the import statement but you can find documentation for the new Box component in the MetaMask Storybook:
 * {@link https://metamask.github.io/metamask-storybook/?path=/docs/components-componentlibrary-box--docs}
 * If you would like to help with the replacement of the old Button component, please submit a pull request against this GitHub issue:
 * {@link https://github.com/MetaMask/metamask-extension/issues/19526}
 */
const Box = /*#__PURE__*/_react.default.forwardRef(function Box({
  padding,
  paddingTop,
  paddingRight,
  paddingBottom,
  paddingLeft,
  paddingInline,
  paddingInlineStart,
  paddingInlineEnd,
  margin,
  marginTop,
  marginRight,
  marginBottom,
  marginLeft,
  marginInline,
  marginInlineStart,
  marginInlineEnd,
  borderColor,
  borderWidth,
  borderRadius,
  borderStyle,
  alignItems,
  justifyContent,
  textAlign,
  flexDirection = _designSystem.FlexDirection.Row,
  flexWrap,
  gap,
  display,
  width,
  height,
  children,
  className,
  backgroundColor,
  color,
  ariaLabel,
  as = 'div',
  ...props
}, ref) {
  const boxClassName = (0, _classnames.default)(BASE_CLASS_NAME, className,
  // Margin
  margin && generateClassNames('margin', margin, isValidSize), marginTop && generateClassNames('margin-top', marginTop, isValidSize), marginRight && generateClassNames('margin-right', marginRight, isValidSize), marginBottom && generateClassNames('margin-bottom', marginBottom, isValidSize), marginLeft && generateClassNames('margin-left', marginLeft, isValidSize), marginInline && generateClassNames('margin-inline', marginInline, isValidSize), marginInlineStart && generateClassNames('margin-inline-start', marginInlineStart, isValidSize), marginInlineEnd && generateClassNames('margin-inline-end', marginInlineEnd, isValidSize),
  // Padding
  padding && generateClassNames('padding', padding, isValidSize), paddingTop && generateClassNames('padding-top', paddingTop, isValidSize), paddingRight && generateClassNames('padding-right', paddingRight, isValidSize), paddingBottom && generateClassNames('padding-bottom', paddingBottom, isValidSize), paddingLeft && generateClassNames('padding-left', paddingLeft, isValidSize), paddingInline && generateClassNames('padding-inline', paddingInline, isValidSize), paddingInlineStart && generateClassNames('padding-inline-start', paddingInlineStart, isValidSize), paddingInlineEnd && generateClassNames('padding-inline-end', paddingInlineEnd, isValidSize), display && generateClassNames('display', display, isValidString), gap && generateClassNames('gap', gap, isValidSize), flexDirection && generateClassNames('flex-direction', flexDirection, isValidString), flexWrap && generateClassNames('flex-wrap', flexWrap, isValidString), justifyContent && generateClassNames('justify-content', justifyContent, isValidString), alignItems && generateClassNames('align-items', alignItems, isValidString), textAlign && generateClassNames('text-align', textAlign, isValidString), width && generateClassNames('width', width, isValidString), height && generateClassNames('height', height, isValidString), color && generateClassNames('color', color, isValidString), backgroundColor && generateClassNames('background-color', backgroundColor, isValidString), borderRadius && generateClassNames('rounded', borderRadius, isValidString), borderStyle && generateClassNames('border-style', borderStyle, isValidString), borderColor && generateClassNames('border-color', borderColor, isValidString), borderWidth && generateClassNames('border-width', borderWidth, isValidSize), {
    // Auto applied classes
    // ---Borders---
    // if borderWidth or borderColor is supplied w/o style, default to solid
    'box--border-style-solid': !borderStyle && (Boolean(borderWidth) || Boolean(borderColor)),
    // if borderColor supplied w/o width, default to 1
    'box--border-width-1': !borderWidth && Boolean(borderColor),
    // ---Flex/Grid alignment---
    // if justifyContent or alignItems supplied w/o display, default to flex
    'box--display-flex': !display && (Boolean(justifyContent) || Boolean(alignItems))
  });
  // Apply Box styles to any other component using function pattern
  if (typeof children === 'function') {
    return children(boxClassName);
  }
  const Component = as;
  const ariaLabelProp = {};
  if (isCustomComponent(Component)) {
    ariaLabelProp.ariaLabel = ariaLabel;
  } else {
    ariaLabelProp['aria-label'] = ariaLabel;
  }
  if (props['aria-label']) {
    ariaLabelProp['aria-label'] = props['aria-label'];
  }
  return /*#__PURE__*/_react.default.createElement(Component, _extends({
    className: boxClassName,
    ref: ref
  }, props, ariaLabelProp), children);
});

// Both class or functional components have type function.
// Built-in HTML elements (div, span, etc.) have type string.
function isCustomComponent(element) {
  return typeof element.type === 'function';
}
Box.propTypes = {
  children: _propTypes.default.oneOfType([_propTypes.default.node, _propTypes.default.func]),
  flexDirection: _propTypes.default.oneOfType([_propTypes.default.oneOf(Object.values(_designSystem.FlexDirection)), _propTypes.default.arrayOf(_propTypes.default.oneOf(Object.values(_designSystem.FlexDirection)))]),
  flexWrap: _propTypes.default.oneOfType([_propTypes.default.oneOf(Object.values(_designSystem.FlexWrap)), _propTypes.default.arrayOf(_propTypes.default.oneOf(Object.values(_designSystem.FlexWrap)))]),
  gap: MultipleSizes,
  margin: MultipleSizesAndAuto,
  marginTop: MultipleSizesAndAuto,
  marginBottom: MultipleSizesAndAuto,
  marginRight: MultipleSizesAndAuto,
  marginLeft: MultipleSizesAndAuto,
  marginInline: MultipleSizesAndAuto,
  marginInlineStart: MultipleSizesAndAuto,
  marginInlineEnd: MultipleSizesAndAuto,
  padding: MultipleSizes,
  paddingTop: MultipleSizes,
  paddingBottom: MultipleSizes,
  paddingRight: MultipleSizes,
  paddingLeft: MultipleSizes,
  paddingInline: MultipleSizes,
  paddingInlineStart: MultipleSizes,
  paddingInlineEnd: MultipleSizes,
  borderColor: MultipleBorderColors,
  borderWidth: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.arrayOf(_propTypes.default.number)]),
  borderRadius: _propTypes.default.oneOfType([_propTypes.default.oneOf(Object.values(_designSystem.BorderRadius)), _propTypes.default.arrayOf(_propTypes.default.oneOf(Object.values(_designSystem.BorderRadius)))]),
  borderStyle: _propTypes.default.oneOfType([_propTypes.default.oneOf(Object.values(_designSystem.BorderStyle)), _propTypes.default.arrayOf(_propTypes.default.oneOf(Object.values(_designSystem.BorderStyle)))]),
  alignItems: MultipleAlignItems,
  justifyContent: MultipleJustifyContents,
  textAlign: _propTypes.default.oneOfType([_propTypes.default.oneOf(Object.values(_designSystem.TextAlign)), _propTypes.default.arrayOf(_propTypes.default.oneOf(Object.values(_designSystem.TextAlign)))]),
  display: _propTypes.default.oneOfType([_propTypes.default.oneOf(Object.values(_designSystem.Display)), _propTypes.default.arrayOf(_propTypes.default.oneOf(Object.values(_designSystem.Display)))]),
  width: MultipleBlockSizes,
  height: MultipleBlockSizes,
  backgroundColor: MultipleBackgroundColor,
  className: _propTypes.default.string,
  style: _propTypes.default.object,
  /**
   * The polymorphic `as` prop allows you to change the root HTML element of the Box component
   * Defaults to 'div'
   */
  as: _propTypes.default.string,
  /**
   * The color of the Typography component Should use the COLOR object from
   * ./ui/helpers/constants/design-system.js
   */
  color: MultipleTextColors,
  ariaLabel: _propTypes.default.string,
  'aria-label': _propTypes.default.string
};
var _default = exports.default = Box;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\box\\box.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\box\\index.js", {"./box":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\box\\box.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cbox%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "MultipleSizes", {
  enumerable: true,
  get: function () {
    return _box.MultipleSizes;
  }
});
Object.defineProperty(exports, "MultipleSizesAndAuto", {
  enumerable: true,
  get: function () {
    return _box.MultipleSizesAndAuto;
  }
});
Object.defineProperty(exports, "ValidBackgroundColor", {
  enumerable: true,
  get: function () {
    return _box.ValidBackgroundColor;
  }
});
Object.defineProperty(exports, "ValidBorderColors", {
  enumerable: true,
  get: function () {
    return _box.ValidBorderColors;
  }
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _box.default;
  }
});
var _box = _interopRequireWildcard(require("./box"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\box\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\button\\button.component.js", {"classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cbutton%5Cbutton.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const CLASSNAME_DEFAULT = 'btn-default';
const CLASSNAME_PRIMARY = 'btn-primary';
const CLASSNAME_SECONDARY = 'btn-secondary';
const CLASSNAME_RAISED = 'btn-raised';
const CLASSNAME_LARGE = 'btn--large';
const CLASSNAME_ROUNDED = 'btn--rounded';
const CLASSNAME_INLINE = 'btn--inline';
const typeHash = {
  default: CLASSNAME_DEFAULT,
  primary: CLASSNAME_PRIMARY,
  secondary: CLASSNAME_SECONDARY,
  warning: 'btn-warning',
  danger: 'btn-danger',
  'danger-primary': 'btn-danger-primary',
  link: 'btn-link',
  inline: CLASSNAME_INLINE,
  raised: CLASSNAME_RAISED
};

/**
 * @deprecated The <Button /> component has been deprecated in favor of the new <Button> component from the component-library.
 * Please update your code to use the new <Button> component instead, which can be found at ./ui/components/component-library/button/button.js.
 * You can find documentation for the new Button component in the MetaMask Storybook:
 * {@link https://metamask.github.io/metamask-storybook/?path=/docs/components-componentlibrary-button--default-story#button}
 * If you would like to help with the replacement of the old Button component, please submit a pull request against this GitHub issue:
 * {@link https://github.com/MetaMask/metamask-extension/issues/18896}
 * @see {@link https://metamask.github.io/metamask-storybook/?path=/docs/components-componentlibrary-button--default-story#button}
 */

const Button = ({
  type,
  submit = false,
  large,
  children,
  icon,
  className,
  rounded = false,
  ...buttonProps
}) => {
  const doRounding = rounded && type !== 'link' && type !== 'inline';
  // To support using the Button component to render styled links that are semantic html
  // we swap the html tag we use to render this component and delete any buttonProps that
  // we know to be erroneous attributes for a link. We will likely want to extract Link
  // to its own component in the future.
  let Tag = 'button';
  if (type === 'link') {
    Tag = 'a';
  } else if (submit) {
    buttonProps.type = 'submit';
  }
  if (type === 'link' && typeof buttonProps.onClick === 'function') {
    buttonProps.onKeyUp ?? (buttonProps.onKeyUp = event => {
      if (event.key === 'Enter') {
        buttonProps.onClick();
      }
    });
    buttonProps.role ?? (buttonProps.role = 'button');
    buttonProps.tabIndex ?? (buttonProps.tabIndex = 0);
  }
  return /*#__PURE__*/_react.default.createElement(Tag, _extends({
    className: (0, _classnames.default)('button', doRounding && CLASSNAME_ROUNDED, typeHash[type] || CLASSNAME_DEFAULT, large && CLASSNAME_LARGE, className)
  }, buttonProps), icon ? /*#__PURE__*/_react.default.createElement("span", {
    className: "button__icon"
  }, icon) : null, children);
};
Button.propTypes = {
  /**
   * The type of variation a button can be.
   * Can be one of 'default','primary','secondary','warning','danger','danger-primary' or 'link'
   */
  type: _propTypes.default.string,
  /**
   * If true sets the html 'type' attribute to type="submit"
   */
  submit: _propTypes.default.bool,
  /**
   * Increase the height of the button to 54px
   */
  large: _propTypes.default.bool,
  /**
   * Additional className to provide on the root element of the button
   */
  className: _propTypes.default.string,
  /**
   * The children of the button component
   */
  children: _propTypes.default.node,
  /**
   * Provide an icon component for an icon to appear on the left side of the button
   */
  icon: _propTypes.default.node,
  /**
   * Buttons are rounded by default.
   */
  rounded: _propTypes.default.bool
};
var _default = exports.default = Button;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\button\\button.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\button\\index.js", {"./button.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\button\\button.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cbutton%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _button = _interopRequireDefault(require("./button.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
var _default = exports.default = _button.default;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\button\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\callout\\callout.js", {"../../../../shared/constants/time":"D:\\code\\v\\metamask-extension\\shared\\constants\\time.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../icon/info-icon-inverted.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\icon\\info-icon-inverted.component.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Ccallout%5Ccallout.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Callout;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _infoIconInverted = _interopRequireDefault(require("../icon/info-icon-inverted.component"));
var _designSystem = require("../../../helpers/constants/design-system");
var _time = require("../../../../shared/constants/time");
var _componentLibrary = require("../../component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * @deprecated `<Callout />` has been deprecated in favor of the `<BannerAlert />`
 * component in ./ui/components/component-library/banner-alert/banner-alert.js.
 * See storybook documentation for BannerAlert here:
 * {@see {@link https://metamask.github.io/metamask-storybook/?path=/docs/components-componentlibrary-banneralert--default-story#banneralert}}
 *
 * Help to replace `Callout` with `BannerAlert` by submitting a PR
 */

function Callout({
  severity,
  children,
  dismiss,
  isFirst,
  isLast,
  isMultiple
}) {
  const [removed, setRemoved] = (0, _react.useState)(false);
  const calloutClassName = (0, _classnames.default)('callout', `callout--${severity}`, {
    'callout--dismissed': removed === true,
    'callout--multiple': isMultiple === true,
    'callout--dismissible': Boolean(dismiss),
    'callout--first': isFirst === true || isMultiple !== true,
    'callout--last': isLast === true || isMultiple !== true
  });
  // Clicking the close button will set removed state, which will trigger this
  // effect to refire due to changing dependencies. When that happens, after a
  // half of a second we fire the dismiss method from the parent. The
  // consuming component is responsible for modifying state and then removing
  // the element from the DOM.
  (0, _react.useEffect)(() => {
    if (removed) {
      setTimeout(() => {
        dismiss();
      }, _time.MILLISECOND * 500);
    }
  }, [removed, dismiss]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: calloutClassName
  }, /*#__PURE__*/_react.default.createElement(_infoIconInverted.default, {
    severity: severity
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textDefault,
    className: "callout__content"
  }, children), dismiss && /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    iconName: _componentLibrary.IconName.Close,
    size: _componentLibrary.IconSize.Sm,
    className: "callout__close-button",
    onClick: () => {
      setRemoved(true);
    },
    onKeyUp: event => {
      if (event.key === 'Enter') {
        setRemoved(true);
      }
    }
  }));
}
Callout.propTypes = {
  severity: _propTypes.default.oneOf(Object.values(_designSystem.Severity)).isRequired,
  children: _propTypes.default.node.isRequired,
  dismiss: _propTypes.default.func,
  isFirst: _propTypes.default.bool,
  isLast: _propTypes.default.bool,
  isMultiple: _propTypes.default.bool
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\callout\\callout.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\callout\\index.js", {"./callout":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\callout\\callout.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Ccallout%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _callout.default;
  }
});
var _callout = _interopRequireDefault(require("./callout"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\callout\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\card\\card.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../box":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\box\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Ccard%5Ccard.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _box = _interopRequireDefault(require("../box"));
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const Card = ({
  border = true,
  backgroundColor = _designSystem.BackgroundColor.backgroundDefault,
  children,
  ...props
}) => /*#__PURE__*/_react.default.createElement(_box.default, _extends({
  borderColor: border ? _designSystem.BorderColor.borderMuted : null,
  borderRadius: border ? _designSystem.BorderRadius.MD : null,
  borderStyle: border ? _designSystem.BorderStyle.solid : null,
  backgroundColor: backgroundColor,
  padding: 4
}, props), children);
Card.propTypes = {
  /**
   * Whether the Card has a border or not.
   * Defaults to true
   */
  border: _propTypes.default.bool,
  /**
   * The background color of the card
   * Defaults to Color.backgroundDefault
   */
  backgroundColor: _propTypes.default.oneOf(Object.values(_designSystem.BackgroundColor)),
  /**
   * The Card component accepts all Box component props
   */
  ..._box.default.propTypes
};
var _default = exports.default = Card;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\card\\card.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\card\\index.js", {"./card":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\card\\card.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Ccard%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _card.default;
  }
});
var _card = _interopRequireDefault(require("./card"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\card\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\check-box\\check-box.component.js", {"classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Ccheck-box%5Ccheck-box.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.UNCHECKED = exports.INDETERMINATE = exports.CHECKED = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CHECKBOX_STATE = {
  CHECKED: 'CHECKED',
  INDETERMINATE: 'INDETERMINATE',
  UNCHECKED: 'UNCHECKED'
};
const {
  CHECKED,
  INDETERMINATE,
  UNCHECKED
} = CHECKBOX_STATE;

/**
 * @deprecated The `<CheckBox />` component has been deprecated in favor of the new `<Checkbox>` component from the component-library.
 * Please update your code to use the new `<Checkbox>` component instead, which can be found at ui/components/component-library/checkbox/checkbox.tsx.
 * You can find documentation for the new Checkbox component in the MetaMask Storybook:
 * {@link https://metamask.github.io/metamask-storybook/?path=/docs/components-componentlibrary-checkbox--docs}
 * If you would like to help with the replacement of the old CheckBox component, please submit a pull request against this GitHub issue:
 * {@link https://github.com/MetaMask/metamask-extension/issues/20163}
 */
exports.UNCHECKED = UNCHECKED;
exports.INDETERMINATE = INDETERMINATE;
exports.CHECKED = CHECKED;
const CheckBox = ({
  className,
  disabled,
  id,
  onClick,
  checked,
  title,
  dataTestId
}) => {
  if (typeof checked === 'boolean') {
    // eslint-disable-next-line no-param-reassign
    checked = checked ? CHECKBOX_STATE.CHECKED : CHECKBOX_STATE.UNCHECKED;
  }
  const ref = (0, _react.useRef)(null);
  (0, _react.useLayoutEffect)(() => {
    ref.current.indeterminate = checked === CHECKBOX_STATE.INDETERMINATE;
  }, [checked]);
  return /*#__PURE__*/_react.default.createElement("input", {
    checked: checked === CHECKBOX_STATE.CHECKED,
    className: (0, _classnames.default)('check-box', className, {
      'far fa-square': checked === CHECKBOX_STATE.UNCHECKED,
      'fa fa-check-square check-box__checked': checked === CHECKBOX_STATE.CHECKED,
      'fa fa-minus-square check-box__indeterminate': checked === CHECKBOX_STATE.INDETERMINATE
    }),
    disabled: disabled,
    id: id,
    onClick: onClick ? event => {
      event.preventDefault();
      onClick();
    } : null,
    readOnly: true,
    ref: ref,
    title: title,
    "data-testid": dataTestId,
    type: "checkbox"
  });
};
CheckBox.propTypes = {
  /**
   * Add custom classname css
   */
  className: _propTypes.default.string,
  /**
   * Check if checkbox disabled or not
   */
  disabled: _propTypes.default.bool,
  /**
   * Checkbox ID
   */
  id: _propTypes.default.string,
  /**
   * Click handler
   */
  onClick: _propTypes.default.func,
  /**
   * Check if the checkbox are checked or not
   */
  checked: _propTypes.default.oneOf([...Object.keys(CHECKBOX_STATE), true, false]).isRequired,
  /**
   * Show title
   */
  title: _propTypes.default.string,
  /**
   * Data test ID for checkbox Component
   */
  dataTestId: _propTypes.default.string
};
CheckBox.defaultProps = {
  className: undefined,
  disabled: false,
  id: undefined
};
var _default = exports.default = CheckBox;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\check-box\\check-box.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\check-box\\index.js", {"./check-box.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\check-box\\check-box.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Ccheck-box%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "CHECKED", {
  enumerable: true,
  get: function () {
    return _checkBox.CHECKED;
  }
});
Object.defineProperty(exports, "INDETERMINATE", {
  enumerable: true,
  get: function () {
    return _checkBox.INDETERMINATE;
  }
});
Object.defineProperty(exports, "UNCHECKED", {
  enumerable: true,
  get: function () {
    return _checkBox.UNCHECKED;
  }
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _checkBox.default;
  }
});
var _checkBox = _interopRequireWildcard(require("./check-box.component"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\check-box\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\chip\\chip.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../url-icon":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\url-icon\\index.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cchip%5Cchip.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Chip;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _lodash = require("lodash");
var _componentLibrary = require("../../component-library");
var _urlIcon = _interopRequireDefault(require("../url-icon"));
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
/**
 * @deprecated The `<Chip />` component has been deprecated in favor of the new `<Tag>` component from the component-library.
 * Please update your code to use the new `<Tag>` component instead, which can be found at ui/components/component-library/tag/tag.tsx.
 * You can find documentation for the new `Tag` component in the MetaMask Storybook:
 * {@link https://metamask.github.io/metamask-storybook/?path=/docs/components-componentlibrary-tag--docs}
 * If you would like to help with the replacement of the old `Chip` component, please submit a pull request against this GitHub issue:
 * {@link https://github.com/MetaMask/metamask-extension/issues/20487}
 */

function Chip({
  dataTestId,
  className,
  children,
  borderColor = _designSystem.BorderColor.borderDefault,
  backgroundColor,
  label,
  labelProps = {},
  leftIcon,
  leftIconUrl = '',
  rightIcon,
  onClick,
  maxContent = true,
  displayInlineBlock = false
}) {
  const onKeyPress = event => {
    if (event.key === 'Enter' && onClick) {
      onClick(event);
    }
  };
  const isInteractive = typeof onClick === 'function';
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-testid": dataTestId,
    onClick: onClick,
    onKeyPress: onKeyPress,
    className: (0, _classnames.default)(className, 'chip', {
      'chip--with-left-icon': Boolean(leftIcon),
      'chip--with-right-icon': Boolean(rightIcon),
      [`chip--border-color-${borderColor}`]: true,
      [`chip--background-color-${backgroundColor}`]: true,
      'chip--max-content': maxContent,
      'chip--display-inline-block': displayInlineBlock
    }),
    role: isInteractive ? 'button' : undefined,
    tabIndex: isInteractive ? 0 : undefined
  }, leftIcon && !leftIconUrl ? /*#__PURE__*/_react.default.createElement("div", {
    className: "chip__left-icon"
  }, leftIcon) : null, leftIconUrl ? /*#__PURE__*/_react.default.createElement(_urlIcon.default, {
    className: "chip__left-url-icon",
    url: leftIconUrl
  }) : null, children ?? /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, _extends({
    className: "chip__label",
    variant: _designSystem.TextVariant.bodySm,
    as: "span",
    color: _designSystem.TextColor.textAlternative
  }, labelProps), label), rightIcon ? /*#__PURE__*/_react.default.createElement("div", {
    className: "chip__right-icon"
  }, rightIcon) : null);
}
Chip.propTypes = {
  /**
   * Data test id used for testing of the Chip component
   */
  dataTestId: _propTypes.default.string,
  /**
   * The border color of the Chip
   */
  borderColor: _propTypes.default.oneOf(Object.values(_designSystem.BorderColor)),
  /**
   * The background color of the Chip component
   */
  backgroundColor: _propTypes.default.oneOf(Object.values(_designSystem.BackgroundColor)),
  /**
   * The label of the Chip component has a default typography variant of h6 and is a span html element
   */
  label: _propTypes.default.string,
  /**
   * The label props of the component. Most Typography props can be used
   */
  labelProps: _propTypes.default.shape({
    ...(0, _lodash.omit)(_designSystem.TextVariant.propTypes, ['children', 'className'])
  }),
  /**
   * Children will replace the label of the Chip component.
   */
  children: _propTypes.default.node,
  /**
   * An icon component that can be passed to appear on the left of the label
   */
  leftIcon: _propTypes.default.node,
  /**
   * An icon component that can be passed to appear on the right of the label
   */
  rightIcon: _propTypes.default.node,
  /**
   * The className of the Chip
   */
  className: _propTypes.default.string,
  /**
   * The onClick handler to be passed to the Chip component
   */
  onClick: _propTypes.default.func,
  /**
   * If the width: max-content; is used in css.
   * max-content can overflow the parent's width and break designs
   */
  maxContent: _propTypes.default.bool,
  /**
   * Icon location
   */
  leftIconUrl: _propTypes.default.string,
  /**
   * Display or not the inline block
   */
  displayInlineBlock: _propTypes.default.bool
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\chip\\chip.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\chip\\index.js", {"./chip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\chip\\chip.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cchip%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _chip.default;
  }
});
var _chip = _interopRequireDefault(require("./chip"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\chip\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\confusable\\confusable.component.js", {"../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","unicode-confusables":"D:\\code\\v\\metamask-extension\\node_modules\\unicode-confusables\\index.js","uuid":"D:\\code\\v\\metamask-extension\\node_modules\\uuid\\dist\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cconfusable%5Cconfusable.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _unicodeConfusables = require("unicode-confusables");
var _uuid = require("uuid");
var _tooltip = _interopRequireDefault(require("../tooltip"));
var _useI18nContext = require("../../../hooks/useI18nContext");
var _componentLibrary = require("../../component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Confusable = ({
  input,
  asText,
  confusableWrapperName = ''
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const confusableData = (0, _react.useMemo)(() => {
    return (0, _unicodeConfusables.confusables)(input);
  }, [input]);
  return confusableData.map(({
    point,
    similarTo
  }) => {
    const zeroWidth = similarTo === '';
    if (similarTo === undefined) {
      return asText ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        key: (0, _uuid.v4)()
      }, point) : point;
    }
    return /*#__PURE__*/_react.default.createElement(_tooltip.default, {
      key: (0, _uuid.v4)(),
      tag: "span",
      position: "top",
      title: zeroWidth ? t('confusableZeroWidthUnicode') : t('confusableUnicode', [point, similarTo]),
      wrapperClassName: confusableWrapperName
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      className: "confusable__point",
      as: asText ? 'p' : 'span'
    }, zeroWidth ? '?' : point));
  });
};
Confusable.propTypes = {
  input: _propTypes.default.string.isRequired,
  asText: _propTypes.default.bool,
  confusableWrapperName: _propTypes.default.string
};
var _default = exports.default = Confusable;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\confusable\\confusable.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\confusable\\index.js", {"./confusable.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\confusable\\confusable.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cconfusable%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _confusable.default;
  }
});
var _confusable = _interopRequireDefault(require("./confusable.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\confusable\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\currency-display\\currency-display.component.js", {"../../../../shared/constants/common":"D:\\code\\v\\metamask-extension\\shared\\constants\\common.ts","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useCurrencyDisplay":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useCurrencyDisplay.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Ccurrency-display%5Ccurrency-display.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = CurrencyDisplay;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _useCurrencyDisplay = require("../../../hooks/useCurrencyDisplay");
var _common = require("../../../../shared/constants/common");
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
/* eslint-disable jsdoc/require-param-name */
// eslint-disable-next-line jsdoc/require-param
/** @param {PropTypes.InferProps<typeof CurrencyDisplayPropTypes>>} */
function CurrencyDisplay({
  account,
  value,
  displayValue,
  'data-testid': dataTestId,
  style,
  className,
  prefix,
  hideLabel,
  hideTitle,
  numberOfDecimals,
  denomination,
  currency,
  suffix,
  textProps = {},
  suffixProps = {},
  isAggregatedFiatOverviewBalance = false,
  privacyMode = false,
  onClick,
  ...props
}) {
  const [title, parts] = (0, _useCurrencyDisplay.useCurrencyDisplay)(value, {
    account,
    displayValue,
    prefix,
    numberOfDecimals,
    hideLabel,
    denomination,
    currency,
    suffix,
    isAggregatedFiatOverviewBalance
  });
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, _extends({
    className: (0, _classnames.default)('currency-display-component', className),
    "data-testid": dataTestId,
    style: style,
    title: !hideTitle && !privacyMode && title || null,
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    flexWrap: _designSystem.FlexWrap.Wrap
  }, props), /*#__PURE__*/_react.default.createElement(_componentLibrary.SensitiveText, _extends({
    as: "span",
    className: "currency-display-component__text cursor-pointer transition-colors duration-200 hover:text-text-alternative",
    ellipsis: true,
    variant: _designSystem.TextVariant.inherit,
    isHidden: privacyMode,
    "data-testid": "account-value-and-suffix",
    onClick: onClick
  }, textProps), parts.prefix, parts.value), parts.suffix ? /*#__PURE__*/_react.default.createElement(_componentLibrary.SensitiveText, _extends({
    as: "span",
    className: `${privacyMode ? 'currency-display-component__text' : 'currency-display-component__suffix'} cursor-pointer transition-colors duration-200 hover:text-text-alternative`,
    marginInlineStart: privacyMode ? 0 : 1,
    variant: _designSystem.TextVariant.inherit,
    isHidden: privacyMode,
    onClick: onClick
  }, suffixProps), parts.suffix) : null);
}
const CurrencyDisplayPropTypes = {
  className: _propTypes.default.string,
  account: _propTypes.default.object,
  currency: _propTypes.default.string,
  'data-testid': _propTypes.default.string,
  denomination: _propTypes.default.oneOf([_common.EtherDenomination.GWEI, _common.EtherDenomination.ETH]),
  displayValue: _propTypes.default.string,
  hideLabel: _propTypes.default.bool,
  hideTitle: _propTypes.default.bool,
  numberOfDecimals: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),
  prefix: _propTypes.default.string,
  style: _propTypes.default.object,
  suffix: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.bool]),
  value: _propTypes.default.string,
  textProps: _propTypes.default.object,
  suffixProps: _propTypes.default.object,
  isAggregatedFiatOverviewBalance: _propTypes.default.bool,
  privacyMode: _propTypes.default.bool,
  onClick: _propTypes.default.func
};
CurrencyDisplay.propTypes = CurrencyDisplayPropTypes;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\currency-display\\currency-display.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\currency-display\\index.js", {"./currency-display.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\currency-display\\currency-display.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Ccurrency-display%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _currencyDisplay.default;
  }
});
var _currencyDisplay = _interopRequireDefault(require("./currency-display.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\currency-display\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\definition-list\\definition-list.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\index.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cdefinition-list%5Cdefinition-list.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = DefinitionList;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _lodash = require("lodash");
var _designSystem = require("../../../helpers/constants/design-system");
var _tooltip = _interopRequireDefault(require("../tooltip"));
var _componentLibrary = require("../../component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const MARGIN_MAP = {
  [_designSystem.Size.XS]: 0,
  [_designSystem.Size.SM]: 2,
  [_designSystem.Size.MD]: 4,
  [_designSystem.Size.LG]: 6,
  [_designSystem.Size.XL]: 8
};
function DefinitionList({
  dictionary,
  termTypography = {},
  definitionTypography = {},
  tooltips = {},
  warnings = {},
  gapSize = _designSystem.Size.SM
}) {
  return /*#__PURE__*/_react.default.createElement("dl", {
    className: "definition-list"
  }, Object.entries(dictionary).map(([term, definition]) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: `definition-for-${term}`
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, _extends({
    variant: _designSystem.TextVariant.bodyMdMedium
  }, termTypography, {
    marginTop: 0,
    marginBottom: 1,
    className: "definition-list__term",
    as: "dt"
  }), term, tooltips[term] && /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    title: tooltips[term],
    position: "top",
    containerClassName: "definition-list__tooltip-wrapper"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.Question,
    size: _componentLibrary.IconSize.Sm,
    marginLeft: 1,
    color: _designSystem.IconColor.iconDefault
  }))), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, _extends({
    variant: _designSystem.TextVariant.bodyMd,
    color: _designSystem.TextColor.textAlternative
  }, definitionTypography, {
    marginTop: 0,
    marginBottom: MARGIN_MAP[gapSize],
    className: "definition-list__definition",
    overflowWrap: _designSystem.OverflowWrap.BreakWord,
    as: "dd"
  }), definition), warnings[term] && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.warningDefault
  }, warnings[term]))));
}
DefinitionList.propTypes = {
  gapSize: _propTypes.default.oneOf(Object.values(_designSystem.Size)),
  dictionary: _propTypes.default.objectOf(_propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number])),
  tooltips: _propTypes.default.objectOf(_propTypes.default.string),
  warnings: _propTypes.default.objectOf(_propTypes.default.string),
  termTypography: _propTypes.default.shape({
    ...(0, _lodash.omit)(_designSystem.TextVariant.propTypes, ['tag', 'className', 'boxProps'])
  }),
  definitionTypography: _propTypes.default.shape({
    ...(0, _lodash.omit)(_designSystem.TextVariant.propTypes, ['tag', 'className', 'boxProps'])
  })
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\definition-list\\definition-list.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\definition-list\\index.js", {"./definition-list":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\definition-list\\definition-list.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cdefinition-list%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _definitionList.default;
  }
});
var _definitionList = _interopRequireDefault(require("./definition-list"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\definition-list\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\delineator\\delineator.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../icon/preloader/preloader-icon.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\icon\\preloader\\preloader-icon.component.js","./utils":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\delineator\\utils.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cdelineator%5Cdelineator.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Delineator = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../component-library");
var _preloaderIcon = _interopRequireDefault(require("../icon/preloader/preloader-icon.component"));
var _utils = require("./utils");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const Loader = () => /*#__PURE__*/_react.default.createElement("div", {
  role: "progressbar"
}, /*#__PURE__*/_react.default.createElement(_preloaderIcon.default, {
  size: 16
}));

/**
 * Renders the icon on the right based on the loading state.
 *
 * @param options - Options bag
 * @param options.isExpanded - Whether the delineator is expanded.
 * @returns Either a loading spinner or an arrow icon.
 */
const ExpandableIcon = ({
  isExpanded
}) => {
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: isExpanded ? _componentLibrary.IconName.ArrowUp : _componentLibrary.IconName.ArrowDown,
    size: _componentLibrary.IconSize.Sm,
    color: _designSystem.IconColor.primaryDefault
  });
};
const Header = ({
  headerComponent,
  iconName,
  isCollapsible,
  isExpanded,
  isLoading,
  isDisabled,
  onHeaderClick,
  type
}) => {
  const iconProps = (0, _utils.getIconPropsByType)(type);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: (0, _classnames.default)({
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      delineator__header: true,
      'delineator__header--expanded': isExpanded,
      'delineator__header--loading': isLoading,
      'delineator__header--disabled': isDisabled
    }),
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.spaceBetween,
    paddingTop: 2,
    paddingRight: 4,
    paddingBottom: isExpanded ? 0 : 2,
    paddingLeft: 4,
    onClick: onHeaderClick
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center
  }, iconName && /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarIcon, _extends({
    iconName: iconName
  }, iconProps)), (0, _utils.overrideTextComponentColorByType)({
    component: headerComponent,
    type
  })), isCollapsible && (isLoading ? /*#__PURE__*/_react.default.createElement(Loader, null) : /*#__PURE__*/_react.default.createElement(ExpandableIcon, {
    isExpanded: isExpanded
  })));
};
const Content = ({
  children,
  contentBoxProps
}) => {
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, _extends({
    paddingTop: 2,
    paddingRight: 4,
    paddingBottom: 4,
    paddingLeft: 4,
    flexDirection: _designSystem.FlexDirection.Column
  }, contentBoxProps), children);
};
const Container = ({
  children,
  wrapperBoxProps
}) => {
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, _extends({
    className: "delineator__wrapper",
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    borderRadius: _designSystem.BorderRadius.LG
  }, wrapperBoxProps), children);
};
const Delineator = ({
  children,
  headerComponent,
  iconName,
  isCollapsible = true,
  isExpanded: isExpandedProp,
  isLoading = false,
  isDisabled = false,
  onExpandChange,
  type,
  wrapperBoxProps,
  contentBoxProps
}) => {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  const [isExpanded, setIsExpanded] = (0, _react.useState)(isExpandedProp || false);
  const shouldShowContent = !isCollapsible || isCollapsible && isExpanded;
  const handleHeaderClick = (0, _react.useCallback)(() => {
    if (isDisabled || isLoading || !isCollapsible) {
      return;
    }
    const newExpandedState = !isExpanded;
    onExpandChange === null || onExpandChange === void 0 || onExpandChange(newExpandedState);
    setIsExpanded(newExpandedState);
  }, [isLoading, isCollapsible, isExpanded, isDisabled, onExpandChange]);
  return /*#__PURE__*/_react.default.createElement(Container, {
    wrapperBoxProps: wrapperBoxProps
  }, /*#__PURE__*/_react.default.createElement(Header, {
    headerComponent: headerComponent,
    iconName: iconName,
    isCollapsible: isCollapsible,
    isExpanded: isExpanded,
    isLoading: isLoading,
    isDisabled: isDisabled,
    onHeaderClick: handleHeaderClick,
    type: type
  }), shouldShowContent && !isLoading && /*#__PURE__*/_react.default.createElement(Content, {
    contentBoxProps: contentBoxProps
  }, children));
};
exports.Delineator = Delineator;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\delineator\\delineator.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\delineator\\delineator.types.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cdelineator%5Cdelineator.types.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DelineatorType = void 0;
let DelineatorType = exports.DelineatorType = /*#__PURE__*/function (DelineatorType) {
  DelineatorType["Error"] = "error";
  DelineatorType["Default"] = "default";
  return DelineatorType;
}({});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\delineator\\delineator.types.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\delineator\\index.ts", {"./delineator":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\delineator\\delineator.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cdelineator%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "Delineator", {
  enumerable: true,
  get: function () {
    return _delineator.Delineator;
  }
});
var _delineator = require("./delineator");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\delineator\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\delineator\\utils.ts", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","./delineator.types":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\delineator\\delineator.types.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cdelineator%5Cutils.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.overrideTextComponentColorByType = exports.getIconPropsByType = void 0;
var _react = _interopRequireDefault(require("react"));
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../component-library");
var _delineator = require("./delineator.types");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const defaultIconProps = {
  size: _componentLibrary.AvatarIconSize.Xs
};

/*
 * Get the icon props based on the type of delineator.
 */
const getIconPropsByType = type => {
  let backgroundColor;
  const inverseIconColorProp = {
    color: _designSystem.IconColor.infoInverse
  };
  switch (type) {
    case _delineator.DelineatorType.Error:
      backgroundColor = _designSystem.BackgroundColor.errorDefault;
      break;
    default:
      backgroundColor = _designSystem.BackgroundColor.overlayAlternative;
  }
  return {
    ...defaultIconProps,
    iconProps: inverseIconColorProp,
    backgroundColor
  };
};

/*
 * Get the text color based on the type of delineator.
 */
exports.getIconPropsByType = getIconPropsByType;
const getTextColorByType = type => {
  switch (type) {
    case _delineator.DelineatorType.Error:
      return _designSystem.TextColor.errorDefault;
    default:
      return _designSystem.TextColor.textDefault;
  }
};

/*
 * Override the color of a Text component based on the type of delineator.
 */
const overrideTextComponentColorByType = ({
  component,
  type
}) => {
  const color = getTextColorByType(type);
  return /*#__PURE__*/_react.default.cloneElement(component, {
    color
  });
};
exports.overrideTextComponentColorByType = overrideTextComponentColorByType;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\delineator\\utils.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\deprecated-networks\\deprecated-networks.js", {"../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../shared/modules/selectors/multichain":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\multichain.ts","../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cdeprecated-networks%5Cdeprecated-networks.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = DeprecatedNetworks;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _designSystem = require("../../../helpers/constants/design-system");
var _selectors = require("../../../selectors");
var _networks = require("../../../../shared/modules/selectors/networks");
var _multichain = require("../../../../shared/modules/selectors/multichain");
var _metamask = require("../../../ducks/metamask/metamask");
var _componentLibrary = require("../../component-library");
var _network = require("../../../../shared/constants/network");
var _actions = require("../../../store/actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function DeprecatedNetworks() {
  const {
    chainId,
    rpcUrl
  } = (0, _reactRedux.useSelector)(_selectors.getCurrentNetwork) ?? {};
  const networkConfigurations = (0, _reactRedux.useSelector)(_networks.getNetworkConfigurationsByChainId);
  const enabledNetworks = (0, _reactRedux.useSelector)(_multichain.getEnabledNetworks);
  const [isClosed, setIsClosed] = (0, _react.useState)(false);
  const completedOnboarding = (0, _reactRedux.useSelector)(_metamask.getCompletedOnboarding);
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const GOERLI_VARIANTS = [_network.CHAIN_IDS.GOERLI, _network.CHAIN_IDS.LINEA_GOERLI, _network.CHAIN_IDS.ARBITRUM_GOERLI, _network.CHAIN_IDS.OPTIMISM_GOERLI];
  const isDeprecatedNetworkGoerliVariants = Object.keys((enabledNetworks === null || enabledNetworks === void 0 ? void 0 : enabledNetworks.eip155) || {}).some(network => GOERLI_VARIANTS.includes(network));
  const isDeprecatedNetwork = Object.keys((enabledNetworks === null || enabledNetworks === void 0 ? void 0 : enabledNetworks.eip155) || {}).some(network => _network.DEPRECATED_NETWORKS.includes(network));
  if (!completedOnboarding || isClosed) {
    return null;
  }
  let props;
  if (
  // Goerli variants
  chainId === _network.CHAIN_IDS.GOERLI || chainId === _network.CHAIN_IDS.LINEA_GOERLI || chainId === _network.CHAIN_IDS.ARBITRUM_GOERLI || chainId === _network.CHAIN_IDS.OPTIMISM_GOERLI || isDeprecatedNetworkGoerliVariants) {
    props = {
      description: t('deprecatedGoerliNtwrkMsg'),
      actionButtonLabel: t('learnMoreUpperCase'),
      actionButtonProps: {
        href: 'https://github.com/eth-clients/goerli#goerli-goerlitzer-testnet',
        externalLink: true
      }
    };
  } else if (_network.DEPRECATED_NETWORKS.includes(chainId) || isDeprecatedNetwork) {
    props = {
      description: t('deprecatedNetwork')
    };
  } else if (chainId === _network.CHAIN_IDS.AURORA && rpcUrl.startsWith('https://aurora-mainnet.infura.io/')) {
    props = {
      description: t('auroraRpcDeprecationMessage'),
      actionButtonLabel: t('switchToNetwork', ['mainnet.aurora.dev']),
      actionButtonOnClick: async () => {
        setIsClosed(true);
        const networkConfiguration = networkConfigurations[chainId];
        networkConfiguration.rpcEndpoints[networkConfiguration.defaultRpcEndpointIndex].url = 'https://mainnet.aurora.dev';
        await dispatch((0, _actions.updateNetwork)(networkConfiguration));
      }
    };
  }
  return props ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "deprecated-networks",
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    padding: 4,
    borderRadius: _designSystem.BorderRadius.SM
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.BannerAlert, _extends({
    severity: _designSystem.Severity.Warning,
    onClose: () => setIsClosed(true)
  }, props))) : null;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\deprecated-networks\\deprecated-networks.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\disclosure\\disclosure.constants.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cdisclosure%5Cdisclosure.constants.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DisclosureVariant = void 0;
let DisclosureVariant = exports.DisclosureVariant = /*#__PURE__*/function (DisclosureVariant) {
  DisclosureVariant["Default"] = "default";
  DisclosureVariant["Arrow"] = "arrow";
  return DisclosureVariant;
}({});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\disclosure\\disclosure.constants.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\disclosure\\disclosure.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","./disclosure.constants":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\disclosure\\disclosure.constants.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cdisclosure%5Cdisclosure.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _disclosure = require("./disclosure.constants");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * @param {string} variant
 * @param {string} title
 * @param {string} size
 * @returns {JSX.Element}
 */
const renderSummaryByType = (variant, title, size) => {
  switch (variant) {
    case _disclosure.DisclosureVariant.Arrow:
      {
        const textVariant = size === 'small' ? _designSystem.TextVariant.bodySm : _designSystem.TextVariant.bodyMd;
        return /*#__PURE__*/_react.default.createElement("summary", {
          className: "disclosure__summary is-arrow"
        }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
          color: _designSystem.Color.primaryDefault,
          variant: textVariant
        }, title), /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
          className: "disclosure__summary--icon",
          color: _designSystem.Color.primaryDefault,
          name: _componentLibrary.IconName.ArrowUp,
          size: _componentLibrary.IconSize.Sm,
          marginInlineStart: 2
        }));
      }
    default:
      return /*#__PURE__*/_react.default.createElement("summary", {
        className: "disclosure__summary"
      }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
        className: "disclosure__summary--icon",
        name: _componentLibrary.IconName.Add,
        size: _componentLibrary.IconSize.Sm,
        marginInlineEnd: 2
      }), title);
  }
};
const Disclosure = ({
  children,
  isScrollToBottomOnOpen,
  title,
  size,
  variant
}) => {
  const disclosureFooterEl = (0, _react.useRef)(null);
  const [open, setOpen] = (0, _react.useState)(false);
  const scrollToBottom = () => {
    var _disclosureFooterEl$c;
    disclosureFooterEl === null || disclosureFooterEl === void 0 || (_disclosureFooterEl$c = disclosureFooterEl.current) === null || _disclosureFooterEl$c === void 0 || _disclosureFooterEl$c.scrollIntoView({
      behavior: 'smooth'
    });
  };
  (0, _react.useEffect)(() => {
    if (isScrollToBottomOnOpen && open) {
      scrollToBottom();
    }
  }, [isScrollToBottomOnOpen, open]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "disclosure",
    "data-testid": "disclosure",
    onClick: () => setOpen(state => !state)
  }, title ? /*#__PURE__*/_react.default.createElement("details", null, renderSummaryByType(variant, title), /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('disclosure__content', size)
  }, children), /*#__PURE__*/_react.default.createElement("div", {
    ref: disclosureFooterEl,
    className: "disclosure__footer"
  })) : children);
};
Disclosure.propTypes = {
  children: _propTypes.default.node.isRequired,
  isScrollToBottomOnOpen: _propTypes.default.bool,
  size: _propTypes.default.string,
  title: _propTypes.default.string,
  variant: _propTypes.default.string
};
Disclosure.defaultProps = {
  isScrollToBottomOnOpen: false,
  size: 'normal',
  title: null,
  variant: _disclosure.DisclosureVariant.Default
};
var _default = exports.default = Disclosure;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\disclosure\\disclosure.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\disclosure\\index.js", {"./disclosure":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\disclosure\\disclosure.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cdisclosure%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _disclosure.default;
  }
});
var _disclosure = _interopRequireDefault(require("./disclosure"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\disclosure\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\dropdown\\dropdown.js", {"../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cdropdown%5Cdropdown.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _componentLibrary = require("../../component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Dropdown = ({
  className,
  disabled = false,
  onChange,
  options,
  selectedOption = '',
  style,
  title,
  'data-testid': dataTestId
}) => {
  const _onChange = (0, _react.useCallback)(event => {
    event.preventDefault();
    event.stopPropagation();
    onChange(event.target.value);
  }, [onChange]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('dropdown', className)
  }, /*#__PURE__*/_react.default.createElement("select", {
    className: "dropdown__select",
    "data-testid": dataTestId,
    disabled: disabled,
    title: title,
    onChange: _onChange,
    style: style,
    value: selectedOption
  }, options.map(option => {
    return /*#__PURE__*/_react.default.createElement("option", {
      key: option.value,
      value: option.value,
      disabled: option.disabled
    }, option.name || option.value);
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.ArrowDown,
    size: _componentLibrary.IconSize.Sm,
    className: "dropdown__icon-caret-down"
  }));
};
Dropdown.propTypes = {
  /**
   * Additional css className to add to root of Dropdown component
   */
  className: _propTypes.default.string,
  /**
   * Disable dropdown by setting to true
   */
  disabled: _propTypes.default.bool,
  /**
   * Title of the dropdown
   */
  title: _propTypes.default.string,
  /**
   * On options change handler
   */
  onChange: _propTypes.default.func.isRequired,
  /**
   * Predefined options for component
   */
  options: _propTypes.default.arrayOf(_propTypes.default.exact({
    name: _propTypes.default.string,
    value: _propTypes.default.string.isRequired
  })).isRequired,
  /**
   * Selected options of dropdown
   */
  selectedOption: _propTypes.default.string,
  /**
   * Add inline style for the component
   */
  style: _propTypes.default.object,
  /**
   * Unit testing test id
   */
  'data-testid': _propTypes.default.string
};
var _default = exports.default = Dropdown;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\dropdown\\dropdown.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\dropdown\\index.js", {"./dropdown":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\dropdown\\dropdown.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cdropdown%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _dropdown.default;
  }
});
var _dropdown = _interopRequireDefault(require("./dropdown"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\dropdown\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\editable-label\\editable-label.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/accounts":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\accounts.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../component-library/form-text-field/deprecated":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\form-text-field\\deprecated\\index.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Ceditable-label%5Ceditable-label.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _designSystem = require("../../../helpers/constants/design-system");
var _accounts = require("../../../helpers/utils/accounts");
var _componentLibrary = require("../../component-library");
var _deprecated = require("../../component-library/form-text-field/deprecated");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class EditableLabel extends _react.Component {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "state", {
      isEditing: false,
      value: this.props.defaultValue || ''
    });
  }
  async handleSubmit(isValidAccountName) {
    if (!isValidAccountName) {
      return;
    }
    await this.props.onSubmit(this.state.value.trim());
    this.setState({
      isEditing: false
    });
  }
  renderEditing() {
    const {
      isValidAccountName,
      errorMessage
    } = (0, _accounts.getAccountNameErrorMessage)(this.props.accounts, this.context, this.state.value, this.props.defaultValue);
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      className: (0, _classnames.default)('editable-label', this.props.className),
      display: _designSystem.Display.Flex,
      gap: 3
    }, /*#__PURE__*/_react.default.createElement(_deprecated.FormTextField, {
      required: true,
      value: this.state.value,
      onKeyPress: event => {
        if (event.key === 'Enter') {
          this.handleSubmit(isValidAccountName);
        }
      },
      onChange: event => {
        this.setState({
          value: event.target.value
        });
      },
      "data-testid": "editable-input",
      error: !isValidAccountName,
      helpText: errorMessage,
      autoFocus: true,
      placeholder: this.context.t('accountName')
    }), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      iconName: _componentLibrary.IconName.Check,
      onClick: () => this.handleSubmit(isValidAccountName),
      "data-testid": "save-account-label-input"
    }));
  }
  renderReadonly() {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      display: _designSystem.Display.Flex,
      alignItems: _designSystem.AlignItems.center,
      gap: 3
    }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      variant: _designSystem.TextVariant.bodyLgMedium,
      style: {
        wordBreak: 'break-word'
      }
    }, this.state.value), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      iconName: _componentLibrary.IconName.Edit,
      ariaLabel: this.context.t('edit'),
      "data-testid": "editable-label-button",
      onClick: () => this.setState({
        isEditing: true
      }),
      color: _designSystem.Color.iconDefault
    }));
  }
  render() {
    return this.state.isEditing ? this.renderEditing() : this.renderReadonly();
  }
}
exports.default = EditableLabel;
_defineProperty(EditableLabel, "propTypes", {
  onSubmit: _propTypes.default.func.isRequired,
  defaultValue: _propTypes.default.string,
  className: _propTypes.default.string,
  accounts: _propTypes.default.array
});
_defineProperty(EditableLabel, "contextTypes", {
  t: _propTypes.default.func
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\editable-label\\editable-label.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\error-message\\error-message.component.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cerror-message%5Cerror-message.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * @deprecated The `<ErrorMessage />` component has been deprecated in favor of the new `<BannerAlert>` component from the component-library.
 * Please update your code to use the new `<BannerAlert>` component instead, which can be found at ui/components/component-library/banner-alert/banner-alert.js.
 * You can find documentation for the new BannerAlert component in the MetaMask Storybook:
 * {@link https://metamask.github.io/metamask-storybook/?path=/docs/components-componentlibrary-banneralert--docs}
 * If you would like to help with the replacement of the old ErrorMessage component, please submit a pull request against this GitHub issue:
 * {@link https://github.com/MetaMask/metamask-extension/issues/20394}
 */

const ErrorMessage = (props, context) => {
  const {
    errorMessage,
    errorKey
  } = props;
  const error = errorKey ? context.t(errorKey) : errorMessage;
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "error-message"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    className: "error-message__icon",
    name: _componentLibrary.IconName.Warning,
    size: _componentLibrary.IconSize.Sm,
    color: _designSystem.IconColor.errorDefault,
    marginRight: 2
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "error-message__text"
  }, error));
};
ErrorMessage.propTypes = {
  /**
   * The text content for the error message
   */
  errorMessage: _propTypes.default.string,
  /**
   * The translate key for localization. Uses context.t(). Will override the error message
   */
  errorKey: _propTypes.default.string
};
ErrorMessage.contextTypes = {
  t: _propTypes.default.func
};
var _default = exports.default = ErrorMessage;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\error-message\\error-message.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\error-message\\index.js", {"./error-message.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\error-message\\error-message.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cerror-message%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _errorMessage.default;
  }
});
var _errorMessage = _interopRequireDefault(require("./error-message.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\error-message\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\export-text-container\\export-text-container.component.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useCopyToClipboard":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useCopyToClipboard.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cexport-text-container%5Cexport-text-container.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _useI18nContext = require("../../../hooks/useI18nContext");
var _useCopyToClipboard = require("../../../hooks/useCopyToClipboard");
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function ExportTextContainer({
  text = '',
  onClickCopy = null
}) {
  const ONE_MINUTE = 1000 * 60;
  const t = (0, _useI18nContext.useI18nContext)();
  const [copied, handleCopy] = (0, _useCopyToClipboard.useCopyToClipboard)(ONE_MINUTE);
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.center,
    borderColor: _designSystem.BorderColor.borderDefault,
    borderRadius: _designSystem.BorderRadius.MD,
    padding: 4,
    gap: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.center,
    className: "notranslate",
    variant: _designSystem.TextVariant.bodyLgMedium,
    "data-testid": "srp_text"
  }, text), /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonSecondary, {
    className: "export-text-container__button",
    block: true,
    onClick: () => {
      if (onClickCopy) {
        onClickCopy();
      }
      handleCopy(text);
    }
  }, copied ? t('copiedExclamation') : t('copyToClipboard')));
}
ExportTextContainer.propTypes = {
  text: _propTypes.default.string,
  onClickCopy: _propTypes.default.func
};
var _default = exports.default = /*#__PURE__*/_react.default.memo(ExportTextContainer);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\export-text-container\\export-text-container.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\export-text-container\\index.js", {"./export-text-container.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\export-text-container\\export-text-container.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cexport-text-container%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _exportTextContainer = _interopRequireDefault(require("./export-text-container.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
var _default = exports.default = _exportTextContainer.default;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\export-text-container\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\form-combo-field\\form-combo-field.tsx", {"../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../component-library/form-text-field/deprecated":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\form-text-field\\deprecated\\index.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cform-combo-field%5Cform-combo-field.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = FormComboField;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _componentLibrary = require("../../component-library");
var _deprecated = require("../../component-library/form-text-field/deprecated");
var _i18n = require("../../../contexts/i18n");
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/* eslint-disable @typescript-eslint/ban-ts-comment */

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function Option({
  option,
  onClick
}) {
  const handleClick = (0, _react.useCallback)(e => {
    e.preventDefault();
    e.stopPropagation();
    e.nativeEvent.stopImmediatePropagation();
    onClick(option);
  }, [onClick, option]);
  const {
    primaryLabel,
    secondaryLabel,
    value
  } = option;
  return /*#__PURE__*/_react.default.createElement("div", {
    tabIndex: 0,
    className: "form-combo-field__option",
    onClick: handleClick
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "form-combo-field__option-primary"
  }, primaryLabel ?? value), secondaryLabel ? /*#__PURE__*/_react.default.createElement("span", {
    className: "form-combo-field__option-secondary"
  }, secondaryLabel) : null);
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function Dropdown({
  hideDropdownIfNoOptions,
  maxDropdownHeight,
  noOptionsText,
  onOptionClick,
  options,
  width
}) {
  const t = (0, _react.useContext)(_i18n.I18nContext);

  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  const ref = (0, _react.useRef)();
  const maxHeight = maxDropdownHeight ?? 179;
  const [dropdownHeight, setDropdownHeight] = (0, _react.useState)(0);
  (0, _react.useEffect)(() => {
    var _ref$current;
    setDropdownHeight(((_ref$current = ref.current) === null || _ref$current === void 0 ? void 0 : _ref$current.scrollHeight) ?? 0);
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: ref,
    style: {
      width,
      maxHeight
    },
    className: (0, _classnames.default)({
      'form-combo-field__dropdown': true,
      'form-combo-field__dropdown__scroll': dropdownHeight > maxHeight
    })
  }, options.length === 0 && !hideDropdownIfNoOptions && /*#__PURE__*/_react.default.createElement(Option, {
    option: {
      primaryLabel: noOptionsText ?? t('comboNoOptions'),
      value: ''
    },
    onClick: () => onOptionClick(undefined)
  }), options.map((option, index) => /*#__PURE__*/_react.default.createElement(Option, {
    key: index,
    option: option,
    onClick: () => {
      onOptionClick(option);
    }
  })));
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function FormComboField({
  hideDropdownIfNoOptions = false,
  maxDropdownHeight,
  noOptionsText,
  onChange,
  onOptionClick,
  options,
  placeholder,
  value
}) {
  const [dropdownVisible, setDropdownVisible] = (0, _react.useState)(false);

  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  const valueRef = (0, _react.useRef)();
  const [valueWidth, setValueWidth] = (0, _react.useState)(0);

  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  const inputRef = (0, _react.useRef)(null);
  const t = (0, _react.useContext)(_i18n.I18nContext);
  (0, _react.useEffect)(() => {
    var _valueRef$current;
    setValueWidth((_valueRef$current = valueRef.current) === null || _valueRef$current === void 0 ? void 0 : _valueRef$current.offsetWidth);
  });
  const handleBlur = (0, _react.useCallback)(
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  e => {
    var _e$relatedTarget;
    if ((e === null || e === void 0 || (_e$relatedTarget = e.relatedTarget) === null || _e$relatedTarget === void 0 ? void 0 : _e$relatedTarget.className) !== 'form-combo-field__option') {
      setDropdownVisible(false);
    }
  }, [setDropdownVisible]);
  const handleChange = (0, _react.useCallback)(
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  e => {
    onChange === null || onChange === void 0 || onChange(e.target.value);
  }, [onChange]);
  const handleOptionClick = (0, _react.useCallback)(option => {
    var _inputRef$current;
    setDropdownVisible(false);
    if (option) {
      handleChange({
        target: {
          value: option.value
        }
      });
      onOptionClick === null || onOptionClick === void 0 || onOptionClick(option);
    }
    (_inputRef$current = inputRef.current) === null || _inputRef$current === void 0 || _inputRef$current.focus();
  }, [setDropdownVisible, handleChange]);
  const handleClearClick = (0, _react.useCallback)(() => {
    var _inputRef$current2;
    handleChange({
      target: {
        value: ''
      }
    });
    (_inputRef$current2 = inputRef.current) === null || _inputRef$current2 === void 0 || _inputRef$current2.focus();
  }, [handleChange]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "form-combo-field",
    ref: valueRef
  }, /*#__PURE__*/_react.default.createElement("div", {
    onClick: () => {
      setDropdownVisible(true);
    }
  }, /*#__PURE__*/_react.default.createElement(_deprecated.FormTextField, {
    autoFocus: true,
    inputRef: inputRef,
    placeholder: placeholder,
    onBlur: handleBlur
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    ,
    onKeyUp: e => {
      if (e.key === 'Enter') {
        handleBlur();
      }
    },
    value: value,
    onChange: handleChange,
    className: (0, _classnames.default)({
      'form-combo-field__value': true,
      'form-combo-field__value-dropdown-visible': dropdownVisible
    }),
    endAccessory: /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
      display: _designSystem.Display.Flex,
      iconName: _componentLibrary.IconName.Close,
      size: _componentLibrary.ButtonIconSize.Sm,
      onClick: () => handleClearClick(),
      color: _designSystem.IconColor.iconMuted,
      ariaLabel: t('clear')
    })
  })), dropdownVisible && /*#__PURE__*/_react.default.createElement(Dropdown, {
    hideDropdownIfNoOptions: hideDropdownIfNoOptions,
    maxDropdownHeight: maxDropdownHeight,
    noOptionsText: noOptionsText,
    onOptionClick: handleOptionClick,
    options: options,
    width: valueWidth
  }));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\form-combo-field\\form-combo-field.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\form-field\\form-field.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../info-tooltip/info-tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\info-tooltip\\info-tooltip.js","../numeric-input/numeric-input.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\numeric-input\\numeric-input.component.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cform-field%5Cform-field.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = FormField;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _designSystem = require("../../../helpers/constants/design-system");
var _numericInput = _interopRequireDefault(require("../numeric-input/numeric-input.component"));
var _infoTooltip = _interopRequireDefault(require("../info-tooltip/info-tooltip"));
var _componentLibrary = require("../../component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
/**
 * @deprecated The `<FormField />` component has been deprecated in favor of the new `<FormTextField>` component from the component-library.
 * Please update your code to use the new `<FormTextField>` component instead, which can be found at ui/components/component-library/form-text-field/form-text-field.js.
 * You can find documentation for the new FormTextField component in the MetaMask Storybook:
 * {@link https://metamask.github.io/metamask-storybook/?path=/docs/components-componentlibrary-formtextfield--docs}
 * If you would like to help with the replacement of the old FormField component, please submit a pull request against this GitHub issue:
 * {@link https://github.com/MetaMask/metamask-extension/issues/19737}
 */

function FormField({
  dataTestId,
  titleText = '',
  TitleTextCustomComponent,
  titleUnit = '',
  TitleUnitCustomComponent,
  tooltipText = '',
  TooltipCustomComponent,
  titleDetail = '',
  titleDetailWrapperProps,
  titleHeadingWrapperProps,
  error,
  onChange = undefined,
  value = 0,
  numeric,
  detailText = '',
  autoFocus = false,
  password = false,
  allowDecimals = false,
  disabled = false,
  placeholder,
  warning,
  warningProps,
  passwordStrength,
  passwordStrengthText,
  id,
  inputProps,
  wrappingLabelProps,
  inputRef
}) {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('form-field', {
      'form-field__row--error': error
    })
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, _extends({
    as: "label"
  }, wrappingLabelProps), /*#__PURE__*/_react.default.createElement("div", {
    className: "form-field__heading"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, _extends({
    className: "form-field__heading-title",
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.baseline
  }, titleHeadingWrapperProps), TitleTextCustomComponent || titleText && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "h6",
    variant: _designSystem.TextVariant.bodySmBold,
    display: _designSystem.Display.InlineBlock
  }, titleText), TitleUnitCustomComponent || titleUnit && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "h6",
    variant: _designSystem.TextVariant.bodySm,
    color: _designSystem.TextColor.textAlternative,
    display: _designSystem.Display.InlineBlock
  }, titleUnit), TooltipCustomComponent || tooltipText && /*#__PURE__*/_react.default.createElement(_infoTooltip.default, {
    position: "top",
    contentText: tooltipText
  })), titleDetail && /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, _extends({
    className: "form-field__heading-detail",
    textAlign: _designSystem.TextAlign.End,
    marginRight: 2
  }, titleDetailWrapperProps), titleDetail)), numeric ? /*#__PURE__*/_react.default.createElement(_numericInput.default, {
    error: error,
    onChange: onChange,
    value: value,
    detailText: detailText,
    autoFocus: autoFocus,
    allowDecimals: allowDecimals,
    disabled: disabled,
    dataTestId: dataTestId,
    placeholder: placeholder,
    id: id,
    inputRef: inputRef
  }) : /*#__PURE__*/_react.default.createElement("input", _extends({
    className: (0, _classnames.default)('form-field__input', {
      'form-field__input--error': error,
      'form-field__input--warning': warning
    }),
    onChange: e => onChange(e.target.value),
    value: value,
    type: password ? 'password' : 'text',
    autoFocus: autoFocus,
    disabled: disabled,
    "data-testid": dataTestId,
    placeholder: placeholder,
    id: id,
    ref: inputRef
  }, inputProps)), error && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.errorDefault,
    variant: _designSystem.TextVariant.bodySm,
    as: "h6",
    className: "form-field__error"
  }, error), warning && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, _extends({
    color: _designSystem.TextColor.textAlternative,
    variant: _designSystem.TextVariant.bodySm,
    as: "h6",
    className: "form-field__warning"
  }, warningProps), warning), passwordStrength && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textDefault,
    variant: _designSystem.TextVariant.bodySm,
    as: "h6",
    className: "form-field__password-strength"
  }, passwordStrength), passwordStrengthText && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textAlternative,
    variant: _designSystem.TextVariant.bodyXs,
    as: "h6",
    className: "form-field__password-strength-text"
  }, passwordStrengthText)));
}
FormField.propTypes = {
  /**
   * Identifier for testing purpose
   */
  dataTestId: _propTypes.default.string,
  /**
   * Form Fields Title
   */
  titleText: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.node]),
  /**
   * A custom component to replace the title text Typography component
   * titleText will be ignored if this is provided
   */
  TitleTextCustomComponent: _propTypes.default.node,
  /**
   * Show unit (eg. ETH)
   */
  titleUnit: _propTypes.default.string,
  /**
   * A custom component to replace the title unit Typography component
   * titleUnit will be ignored if this is provided
   */
  TitleUnitCustomComponent: _propTypes.default.node,
  /**
   * Add Tooltip and text content
   */
  tooltipText: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.node]),
  /**
   * A custom component to replace the tooltip component
   * tooltipText will be ignored if this is provided
   */
  TooltipCustomComponent: _propTypes.default.node,
  /**
   * Show content (text, image, component) in title
   */
  titleDetail: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.node]),
  /**
   * Props to pass to wrapping Box component of the titleDetail component
   * Accepts all props of the Box component
   */
  titleDetailWrapperProps: _propTypes.default.shape({
    ..._componentLibrary.Box.propTypes
  }),
  /**
   * Props to pass to wrapping Box component of the titleHeading component
   * Accepts all props of the Box component
   */
  titleHeadingWrapperProps: _propTypes.default.shape({
    ..._componentLibrary.Box.propTypes
  }),
  /**
   * Show error message
   */
  error: _propTypes.default.string,
  /**
   * Show warning message
   */
  warning: _propTypes.default.string,
  /**
   * Props to pass to the warning text component
   * Accepts all props of the Text component
   */
  warningProps: _propTypes.default.shape({
    ..._componentLibrary.Text.propTypes
  }),
  /**
   * Handler when fields change
   */
  onChange: _propTypes.default.func,
  /**
   * Field value
   */
  value: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
  /**
   * Show detail text if field mode is numeric
   */
  detailText: _propTypes.default.string,
  /**
   * Set autofocus on render
   */
  autoFocus: _propTypes.default.bool,
  /**
   * Set numeric mode, the default is text
   */
  numeric: _propTypes.default.bool,
  /**
   * Set password mode
   */
  password: _propTypes.default.bool,
  /**
   * Allow decimals on the field
   */
  allowDecimals: _propTypes.default.bool,
  /**
   * Check if the form disabled
   */
  disabled: _propTypes.default.bool,
  /**
   * Set the placeholder text for the input field
   */
  placeholder: _propTypes.default.string,
  /**
   * Show password strength according to the score
   */
  passwordStrength: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.node]),
  /**
   * Show password strength description
   */
  passwordStrengthText: _propTypes.default.string,
  /**
   * The id of the input element. Should be used when the wrapping label is changed to a div to ensure accessibility.
   */
  id: _propTypes.default.string,
  /**
   * Any additional input attributes or overrides not provided by exposed props
   */
  inputProps: _propTypes.default.object,
  /**
   * The FormField is wrapped in a Box component that is rendered as a <label/> using the polymorphic "as" prop.
   * This object allows you to override the rendering of the label by using the wrapperProps={{ as: 'div' }} prop.
   * If used ensure the id prop is set on the input and a label element is present using htmlFor with the same id to ensure accessibility.
   */
  wrappingLabelProps: _propTypes.default.object,
  /**
   * ref for input component
   */
  inputRef: _propTypes.default.object
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\form-field\\form-field.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\form-field\\index.js", {"./form-field":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\form-field\\form-field.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cform-field%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _formField.default;
  }
});
var _formField = _interopRequireDefault(require("./form-field"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\form-field\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\hex-to-decimal\\hex-to-decimal.component.js", {"../../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Chex-to-decimal%5Chex-to-decimal.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _conversion = require("../../../../shared/modules/conversion.utils");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class HexToDecimal extends _react.PureComponent {
  render() {
    const {
      className,
      value
    } = this.props;
    const decimalValue = (0, _conversion.hexToDecimal)(value);
    return /*#__PURE__*/_react.default.createElement("div", {
      className: className
    }, decimalValue);
  }
}
exports.default = HexToDecimal;
_defineProperty(HexToDecimal, "propTypes", {
  className: _propTypes.default.string,
  value: _propTypes.default.string
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\hex-to-decimal\\hex-to-decimal.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\hex-to-decimal\\index.js", {"./hex-to-decimal.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\hex-to-decimal\\hex-to-decimal.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Chex-to-decimal%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _hexToDecimal.default;
  }
});
var _hexToDecimal = _interopRequireDefault(require("./hex-to-decimal.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\hex-to-decimal\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\icon-button\\icon-button.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../tooltip/tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\tooltip.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cicon-button%5Cicon-button.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _tooltip = _interopRequireDefault(require("../tooltip/tooltip"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const IconButton = /*#__PURE__*/(0, _react.forwardRef)(({
  onClick,
  Icon,
  disabled = false,
  label,
  className = '',
  tooltipRender,
  ...props
}, ref) => {
  const buttonContent = /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonBase, _extends({
    className: (0, _classnames.default)('icon-button', className),
    onClick: onClick,
    backgroundColor: _designSystem.BackgroundColor.backgroundMuted,
    disabled: disabled,
    ref: ref,
    display: _designSystem.Display.InlineFlex,
    flexDirection: _designSystem.FlexDirection.Column,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    paddingTop: 3,
    paddingBottom: 3,
    paddingLeft: 2,
    paddingRight: 2,
    textProps: {
      ellipsis: true,
      className: 'icon-button__label'
    }
  }, props), Icon, label.length > 10 ? /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    title: label,
    position: "bottom"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "span",
    display: _designSystem.Display.Block,
    variant: _designSystem.TextVariant.bodySmMedium,
    ellipsis: true
  }, label)) : /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    as: "span",
    display: _designSystem.Display.Block,
    variant: _designSystem.TextVariant.bodySmMedium,
    ellipsis: true,
    style: {
      marginTop: '-4px'
    }
  }, label));
  return tooltipRender ? tooltipRender(buttonContent) : buttonContent;
});
IconButton.displayName = 'IconButton';
var _default = exports.default = IconButton;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\icon-button\\icon-button.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\icon-button\\index.ts", {"./icon-button":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\icon-button\\icon-button.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cicon-button%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _iconButton.default;
  }
});
var _iconButton = _interopRequireDefault(require("./icon-button"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\icon-button\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\icon-with-fallback\\icon-with-fallback.component.js", {"classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cicon-with-fallback%5Cicon-with-fallback.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
/**
 * @deprecated The `<IconWithFallback />` component has been deprecated in favor of the new `<AvatarNetwork />` or `<AvatarFavicon />` component from the component-library.
 * Please update your code to use the new `<AvatarNetwork />` or `<AvatarFavicon />` component instead, which can be found at ui/components/component-library.
 * You can find documentation for the new `AvatarNetwork` or `AvatarFavicon` component in the MetaMask Storybook:
 * {@link https://metamask.github.io/metamask-storybook/?path=/docs/components-componentlibrary-avatarnetwork--docs}
 * {@link https://metamask.github.io/metamask-storybook/?path=/docs/components-componentlibrary-avatarfavicon--docs}
 * If you would like to help with the replacement of the old `IconWithFallback` component, please submit a pull request
 */

const IconWithFallback = ({
  name = '',
  icon = null,
  size,
  className,
  fallbackClassName,
  wrapperClassName,
  ...props
}) => {
  const [iconError, setIconError] = (0, _react.useState)(false);
  const style = size ? {
    height: `${size}px`,
    width: `${size}px`
  } : {};
  const handleOnError = () => {
    setIconError(true);
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)(wrapperClassName),
    style: style
  }, !iconError && icon ? /*#__PURE__*/_react.default.createElement("img", _extends({
    onError: handleOnError,
    src: icon,
    style: style,
    className: className,
    alt: name || 'icon'
  }, props)) : /*#__PURE__*/_react.default.createElement("span", {
    className: (0, _classnames.default)('icon-with-fallback__fallback', fallbackClassName)
  }, (name === null || name === void 0 ? void 0 : name.charAt(0).toUpperCase()) || ''));
};
IconWithFallback.propTypes = {
  /**
   * The img src of the icon
   */
  icon: _propTypes.default.string,
  /**
   * The name of the icon also used for the alt attribute of the image
   */
  name: _propTypes.default.string,
  /**
   * The size of the icon. Recommended sizes adhere to 8px grid: 16, 24, 32, 40
   */
  size: _propTypes.default.number,
  /**
   * className to apply to the image tag
   */
  className: _propTypes.default.string,
  /**
   * className to apply to the div that wraps the icon
   */
  wrapperClassName: _propTypes.default.string,
  /**
   * Additional className to apply to the fallback span tag
   */
  fallbackClassName: _propTypes.default.string
};
var _default = exports.default = IconWithFallback;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\icon-with-fallback\\icon-with-fallback.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\icon-with-fallback\\index.js", {"./icon-with-fallback.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\icon-with-fallback\\icon-with-fallback.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cicon-with-fallback%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _iconWithFallback.default;
  }
});
var _iconWithFallback = _interopRequireDefault(require("./icon-with-fallback.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\icon-with-fallback\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\icon\\icon-eye-slash.js", {"prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cicon%5Cicon-eye-slash.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * @deprecated This has been deprecated in favor of the `<Icon />` component in ./ui/components/component-library/icon/icon.js
 * See storybook documentation for Icon here https://metamask.github.io/metamask-storybook/?path=/docs/components-componentlibrary-icon--default-story#icon
 */

const IconEyeSlash = ({
  size = 24,
  color = 'currentColor',
  ariaLabel,
  className
}) =>
/*#__PURE__*/
// This SVG is copied from `@fortawesome/fontawesome-free@5.13.0/regular/eye-slash.svg`.
_react.default.createElement("svg", {
  width: size,
  height: size,
  fill: color,
  className: className,
  "aria-label": ariaLabel,
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 640 512"
}, /*#__PURE__*/_react.default.createElement("path", {
  d: "M634 471L36 3.51A16 16 0 0 0 13.51 6l-10 12.49A16 16 0 0 0 6 41l598 467.49a16 16 0 0 0 22.49-2.49l10-12.49A16 16 0 0 0 634 471zM296.79 146.47l134.79 105.38C429.36 191.91 380.48 144 320 144a112.26 112.26 0 0 0-23.21 2.47zm46.42 219.07L208.42 260.16C210.65 320.09 259.53 368 320 368a113 113 0 0 0 23.21-2.46zM320 112c98.65 0 189.09 55 237.93 144a285.53 285.53 0 0 1-44 60.2l37.74 29.5a333.7 333.7 0 0 0 52.9-75.11 32.35 32.35 0 0 0 0-29.19C550.29 135.59 442.93 64 320 64c-36.7 0-71.71 7-104.63 18.81l46.41 36.29c18.94-4.3 38.34-7.1 58.22-7.1zm0 288c-98.65 0-189.08-55-237.93-144a285.47 285.47 0 0 1 44.05-60.19l-37.74-29.5a333.6 333.6 0 0 0-52.89 75.1 32.35 32.35 0 0 0 0 29.19C89.72 376.41 197.08 448 320 448c36.7 0 71.71-7.05 104.63-18.81l-46.41-36.28C359.28 397.2 339.89 400 320 400z"
}));
IconEyeSlash.propTypes = {
  /**
   * The size of the Icon follows an 8px grid 2 = 16px, 3 = 24px etc
   */
  size: _propTypes.default.number,
  /**
   * The color of the icon accepts design token css variables
   */
  color: _propTypes.default.string,
  /**
   * An additional className to assign the Icon
   */
  className: _propTypes.default.string,
  /**
   * The aria-label of the icon for accessibility purposes
   */
  ariaLabel: _propTypes.default.string
};
var _default = exports.default = IconEyeSlash;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\icon\\icon-eye-slash.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\icon\\icon-eye.js", {"prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cicon%5Cicon-eye.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * @deprecated This has been deprecated in favor of the `<Icon />` component in ./ui/components/component-library/icon/icon.js
 * See storybook documentation for Icon here https://metamask.github.io/metamask-storybook/?path=/docs/components-componentlibrary-icon--default-story#icon
 */

const IconEye = ({
  size = 24,
  color = 'currentColor',
  ariaLabel,
  className
}) =>
/*#__PURE__*/
// This SVG copied from `@fortawesome/fontawesome-free@5.13.0/regular/eye.svg`.
_react.default.createElement("svg", {
  width: size,
  height: size,
  fill: color,
  className: className,
  "aria-label": ariaLabel,
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 576 512"
}, /*#__PURE__*/_react.default.createElement("path", {
  d: "M288 144a110.94 110.94 0 0 0-31.24 5 55.4 55.4 0 0 1 7.24 27 56 56 0 0 1-56 56 55.4 55.4 0 0 1-27-7.24A111.71 111.71 0 1 0 288 144zm284.52 97.4C518.29 135.59 410.93 64 288 64S57.68 135.64 3.48 241.41a32.35 32.35 0 0 0 0 29.19C57.71 376.41 165.07 448 288 448s230.32-71.64 284.52-177.41a32.35 32.35 0 0 0 0-29.19zM288 400c-98.65 0-189.09-55-237.93-144C98.91 167 189.34 112 288 112s189.09 55 237.93 144C477.1 345 386.66 400 288 400z"
}));
IconEye.propTypes = {
  /**
   * The size of the Icon follows an 8px grid 2 = 16px, 3 = 24px etc
   */
  size: _propTypes.default.number,
  /**
   * The color of the icon accepts design token css variables
   */
  color: _propTypes.default.string,
  /**
   * An additional className to assign the Icon
   */
  className: _propTypes.default.string,
  /**
   * The aria-label of the icon for accessibility purposes
   */
  ariaLabel: _propTypes.default.string
};
var _default = exports.default = IconEye;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\icon\\icon-eye.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\icon\\info-icon-inverted.component.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cicon%5Cinfo-icon-inverted.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = InfoIconInverted;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * @deprecated This has been deprecated in favor of the `<Icon />` component in ./ui/components/component-library/icon/icon.js
 * See storybook documentation for Icon here https://metamask.github.io/metamask-storybook/?path=/docs/components-componentlibrary-icon--default-story#icon
 */

function InfoIconInverted({
  severity
}) {
  const className = (0, _classnames.default)('info-icon', {
    'info-icon--success': severity === _designSystem.SEVERITIES.SUCCESS,
    'info-icon--warning': severity === _designSystem.SEVERITIES.WARNING,
    'info-icon--danger': severity === _designSystem.SEVERITIES.DANGER,
    'info-icon--info': severity === _designSystem.SEVERITIES.INFO
  });
  return /*#__PURE__*/_react.default.createElement("svg", {
    className: className,
    width: "16",
    height: "16",
    viewBox: "0 0 16 16",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "M15.75 8C15.75 3.75 12.25 0.25 8 0.25C3.71875 0.25 0.25 3.75 0.25 8C0.25 12.2812 3.71875 15.75 8 15.75C12.25 15.75 15.75 12.2812 15.75 8ZM8 9.5625C8.78125 9.5625 9.4375 10.2188 9.4375 11C9.4375 11.8125 8.78125 12.4375 8 12.4375C7.1875 12.4375 6.5625 11.8125 6.5625 11C6.5625 10.2188 7.1875 9.5625 8 9.5625ZM6.625 4.40625C6.59375 4.1875 6.78125 4 7 4H8.96875C9.1875 4 9.375 4.1875 9.34375 4.40625L9.125 8.65625C9.09375 8.875 8.9375 9 8.75 9H7.21875C7.03125 9 6.875 8.875 6.84375 8.65625L6.625 4.40625Z"
  }));
}
InfoIconInverted.propTypes = {
  /**
   * Severity can be 1 of 4 states:'danger', 'warning', 'info' or 'success'
   */
  severity: _propTypes.default.oneOf(Object.values(_designSystem.SEVERITIES))
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\icon\\info-icon-inverted.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\icon\\info-icon.component.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cicon%5Cinfo-icon.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = InfoIcon;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * @deprecated This has been deprecated in favor of the `<Icon />` component in ./ui/components/component-library/icon/icon.js
 * See storybook documentation for Icon here https://metamask.github.io/metamask-storybook/?path=/docs/components-componentlibrary-icon--default-story#icon
 */

function InfoIcon({
  severity
}) {
  const className = (0, _classnames.default)('info-icon', {
    'info-icon--success': severity === _designSystem.SEVERITIES.SUCCESS,
    'info-icon--warning': severity === _designSystem.SEVERITIES.WARNING,
    'info-icon--danger': severity === _designSystem.SEVERITIES.DANGER,
    'info-icon--info': severity === _designSystem.SEVERITIES.INFO
  });
  return /*#__PURE__*/_react.default.createElement("svg", {
    className: className,
    width: "16",
    height: "16",
    viewBox: "0 0 16 16",
    xmlns: "http://www.w3.org/2000/svg"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "M7.2 5.6H8.8V4H7.2V5.6ZM8 14.4C4.472 14.4 1.6 11.528 1.6 8C1.6 4.472 4.472 1.6 8 1.6C11.528 1.6 14.4 4.472 14.4 8C14.4 11.528 11.528 14.4 8 14.4ZM8 0C6.94943 0 5.90914 0.206926 4.93853 0.608964C3.96793 1.011 3.08601 1.60028 2.34315 2.34315C0.842855 3.84344 0 5.87827 0 8C0 10.1217 0.842855 12.1566 2.34315 13.6569C3.08601 14.3997 3.96793 14.989 4.93853 15.391C5.90914 15.7931 6.94943 16 8 16C10.1217 16 12.1566 15.1571 13.6569 13.6569C15.1571 12.1566 16 10.1217 16 8C16 6.94943 15.7931 5.90914 15.391 4.93853C14.989 3.96793 14.3997 3.08601 13.6569 2.34315C12.914 1.60028 12.0321 1.011 11.0615 0.608964C10.0909 0.206926 9.05058 0 8 0ZM7.2 12H8.8V7.2H7.2V12Z"
  }));
}
InfoIcon.propTypes = {
  /**
   * Severity can be 1 of 4 states:'danger', 'warning', 'info' or 'success'
   */
  severity: _propTypes.default.oneOf(Object.values(_designSystem.SEVERITIES))
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\icon\\info-icon.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\icon\\preloader\\index.js", {"./preloader-icon.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\icon\\preloader\\preloader-icon.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cicon%5Cpreloader%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _preloaderIcon.default;
  }
});
var _preloaderIcon = _interopRequireDefault(require("./preloader-icon.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\icon\\preloader\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\icon\\preloader\\preloader-icon.component.js", {"classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cicon%5Cpreloader%5Cpreloader-icon.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const Preloader = ({
  className,
  size
}) => /*#__PURE__*/_react.default.createElement("svg", {
  className: (0, _classnames.default)('preloader__icon', className),
  width: size,
  height: size,
  viewBox: "0 0 16 16",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg"
}, /*#__PURE__*/_react.default.createElement("path", {
  fillRule: "evenodd",
  clipRule: "evenodd",
  d: "M8 13.7143C4.84409 13.7143 2.28571 11.1559 2.28571 8C2.28571 4.84409 4.84409 2.28571 8 2.28571C11.1559 2.28571 13.7143 4.84409 13.7143 8C13.7143 11.1559 11.1559 13.7143 8 13.7143ZM8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8C16 12.4183 12.4183 16 8 16Z",
  fill: "var(--color-primary-muted)"
}), /*#__PURE__*/_react.default.createElement("mask", {
  id: "mask0",
  "mask-type": "alpha",
  maskUnits: "userSpaceOnUse",
  x: "0",
  y: "0",
  width: "16",
  height: "16"
}, /*#__PURE__*/_react.default.createElement("path", {
  fillRule: "evenodd",
  clipRule: "evenodd",
  d: "M8 13.7143C4.84409 13.7143 2.28571 11.1559 2.28571 8C2.28571 4.84409 4.84409 2.28571 8 2.28571C11.1559 2.28571 13.7143 4.84409 13.7143 8C13.7143 11.1559 11.1559 13.7143 8 13.7143ZM8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8C16 12.4183 12.4183 16 8 16Z",
  fill: "var(--color-primary-default)"
})), /*#__PURE__*/_react.default.createElement("g", {
  mask: "url(#mask0)"
}, /*#__PURE__*/_react.default.createElement("path", {
  d: "M6.85718 17.9999V11.4285V8.28564H-4.85711V17.9999H6.85718Z",
  fill: "var(--color-primary-default)"
})));
Preloader.defaultProps = {
  className: undefined
};
Preloader.propTypes = {
  className: _propTypes.default.string,
  size: _propTypes.default.number.isRequired
};
var _default = exports.default = Preloader;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\icon\\preloader\\preloader-icon.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\identicon\\identicon.component.js", {"../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../jazzicon":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\jazzicon\\index.js","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cidenticon%5Cidenticon.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _lodash = require("lodash");
var _designSystemReact = require("@metamask/design-system-react");
var _jazzicon = _interopRequireDefault(require("../jazzicon"));
var _util = require("../../../helpers/utils/util");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
const getStyles = diameter => ({
  height: diameter,
  width: diameter,
  borderRadius: diameter / 2
});
const getImage = async (image, ipfsGateway) => {
  return await (0, _util.getAssetImageURL)(image, ipfsGateway);
};
const mapDiameterToSize = diameter => {
  if (diameter <= 16) {
    return _designSystemReact.AvatarAccountSize.Xs;
  }
  if (diameter <= 24) {
    return _designSystemReact.AvatarAccountSize.Sm;
  }
  if (diameter <= 32) {
    return _designSystemReact.AvatarAccountSize.Md;
  }
  if (diameter <= 40) {
    return _designSystemReact.AvatarAccountSize.Lg;
  }
  if (diameter <= 48) {
    return _designSystemReact.AvatarAccountSize.Xl;
  }
  return _designSystemReact.AvatarAccountSize.Md;
};

/**
 * @deprecated Use PreferredAvatar instead
 */
class Identicon extends _react.Component {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "state", {
      imageLoadingError: false,
      imageUrl: ''
    });
    _defineProperty(this, "loadImage", async () => {
      const result = await getImage(this.props.image, this.props.ipfsGateway);
      this.setState({
        imageUrl: result
      });
    });
  }
  async componentDidMount() {
    this.loadImage();
  }
  async componentDidUpdate(prevProps) {
    if (prevProps.image !== this.props.image) {
      this.loadImage();
    }
  }
  renderImage() {
    const {
      className,
      diameter,
      alt,
      imageBorder
    } = this.props;
    let {
      image
    } = this.props;
    const {
      imageUrl
    } = this.state;
    if (Array.isArray(image) && image.length) {
      image = image[0];
    }
    if (typeof image === 'string' && image.toLowerCase().startsWith('ipfs://')) {
      image = imageUrl;
    }
    return /*#__PURE__*/_react.default.createElement("img", {
      className: (0, _classnames.default)('identicon', className, {
        'identicon__image-border': imageBorder
      }),
      src: image,
      style: getStyles(diameter),
      alt: alt,
      onError: () => {
        this.setState({
          imageLoadingError: true
        });
      }
    });
  }
  renderJazzicon() {
    const {
      address,
      className,
      diameter,
      alt
    } = this.props;
    const tokenList = this.getTokenList();
    return /*#__PURE__*/_react.default.createElement(_jazzicon.default, {
      address: address,
      diameter: diameter,
      className: (0, _classnames.default)('identicon', className),
      style: getStyles(diameter),
      alt: alt,
      tokenList: tokenList
    });
  }
  renderBlockie() {
    const {
      address,
      className,
      diameter,
      alt
    } = this.props;
    return /*#__PURE__*/_react.default.createElement("div", {
      className: (0, _classnames.default)('identicon', className),
      style: getStyles(diameter)
    }, /*#__PURE__*/_react.default.createElement(_designSystemReact.AvatarAccount, {
      variant: _designSystemReact.AvatarAccountVariant.Blockies,
      address: address,
      size: mapDiameterToSize(diameter),
      alt: alt
    }));
  }
  renderBlockieOrJazzIcon() {
    const {
      useBlockie
    } = this.props;
    return useBlockie ? this.renderBlockie() : this.renderJazzicon();
  }
  shouldComponentUpdate(nextProps, nextState) {
    // We only want to re-render if props are different.
    return !(0, _lodash.isEqual)(nextProps, this.props) || !(0, _lodash.isEqual)(nextState, this.state);
  }
  getTokenImage() {
    var _tokenList$address$to;
    const {
      address,
      tokenList
    } = this.props;
    return (_tokenList$address$to = tokenList[address === null || address === void 0 ? void 0 : address.toLowerCase()]) === null || _tokenList$address$to === void 0 ? void 0 : _tokenList$address$to.iconUrl;
  }
  getNftImage() {
    var _watchedNftContracts$;
    const {
      address,
      watchedNftContracts
    } = this.props;
    return (_watchedNftContracts$ = watchedNftContracts[address === null || address === void 0 ? void 0 : address.toLowerCase()]) === null || _watchedNftContracts$ === void 0 ? void 0 : _watchedNftContracts$.logo;
  }
  getTokenList() {
    const {
      address
    } = this.props;
    const tokenImage = this.getTokenImage();
    const nftImage = this.getNftImage();
    const iconUrl = tokenImage || nftImage;
    if (!iconUrl) {
      return {};
    }
    return {
      [address.toLowerCase()]: {
        iconUrl
      }
    };
  }
  render() {
    const {
      address,
      image,
      addBorder,
      diameter
    } = this.props;
    const {
      imageLoadingError
    } = this.state;
    const size = diameter + 8;
    if (imageLoadingError) {
      return this.renderBlockieOrJazzIcon();
    }
    if (image) {
      return this.renderImage();
    }
    if (address) {
      if (this.getTokenImage() || this.getNftImage()) {
        return this.renderJazzicon();
      }
      return /*#__PURE__*/_react.default.createElement("div", {
        className: (0, _classnames.default)({
          'identicon__address-wrapper': addBorder
        }),
        style: addBorder ? getStyles(size) : null
      }, this.renderBlockieOrJazzIcon());
    }
    return /*#__PURE__*/_react.default.createElement("div", {
      style: getStyles(diameter),
      className: "identicon__image-border"
    });
  }
}
exports.default = Identicon;
_defineProperty(Identicon, "propTypes", {
  /**
   * Adds blue border around the Identicon used for selected account.
   * Increases the width and height of the Identicon by 8px
   */
  addBorder: _propTypes.default.bool,
  /**
   * Address used for generating random image
   */
  address: _propTypes.default.string,
  /**
   * Add custom css class
   */
  className: _propTypes.default.string,
  /**
   * Sets the width and height of the inner img element
   * If addBorder is true will increase components height and width by 8px
   */
  diameter: _propTypes.default.number,
  /**
   * Used as the image source of the Identicon
   */
  image: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.array]),
  /**
   * Use the blockie type random image generator
   */
  useBlockie: _propTypes.default.bool,
  /**
   * The alt text of the image
   */
  alt: _propTypes.default.string,
  /**
   * Check if show image border
   */
  imageBorder: _propTypes.default.bool,
  /**
   * Add list of token in object
   */
  tokenList: _propTypes.default.object,
  /**
   * User preferred IPFS gateway
   */
  ipfsGateway: _propTypes.default.string,
  /**
   * Watched NFT contract data keyed by address
   */
  watchedNftContracts: _propTypes.default.object
});
_defineProperty(Identicon, "defaultProps", {
  addBorder: false,
  address: undefined,
  className: undefined,
  diameter: 46,
  image: undefined,
  useBlockie: false,
  alt: '',
  tokenList: {},
  watchedNftContracts: {}
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\identicon\\identicon.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\identicon\\identicon.container.js", {"../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/nft":"D:\\code\\v\\metamask-extension\\ui\\selectors\\nft.ts","./identicon.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\identicon\\identicon.component.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cidenticon%5Cidenticon.container.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactRedux = require("react-redux");
var _selectors = require("../../../selectors");
var _nft = require("../../../selectors/nft");
var _identicon = _interopRequireDefault(require("./identicon.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const mapStateToProps = state => {
  const {
    metamask: {
      useBlockie,
      ipfsGateway
    }
  } = state;
  return {
    useBlockie,
    tokenList: (0, _selectors.getTokenList)(state),
    ipfsGateway,
    watchedNftContracts: (0, _nft.getNftContractsByAddressOnCurrentChain)(state)
  };
};
var _default = exports.default = (0, _reactRedux.connect)(mapStateToProps)(_identicon.default);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\identicon\\identicon.container.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\identicon\\index.js", {"./identicon.container":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\identicon\\identicon.container.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cidenticon%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _identicon.default;
  }
});
var _identicon = _interopRequireDefault(require("./identicon.container"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\identicon\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\info-tooltip\\index.js", {"./info-tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\info-tooltip\\info-tooltip.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cinfo-tooltip%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _infoTooltip.default;
  }
});
var _infoTooltip = _interopRequireDefault(require("./info-tooltip"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\info-tooltip\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\info-tooltip\\info-tooltip-icon.js", {"prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cinfo-tooltip%5Cinfo-tooltip-icon.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = InfoTooltipIcon;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function InfoTooltipIcon({
  fillColor = 'var(--color-icon-default)'
}) {
  return /*#__PURE__*/_react.default.createElement("svg", {
    viewBox: "0 0 10 10",
    xmlns: "http://www.w3.org/2000/svg"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "M5 0C2.2 0 0 2.2 0 5s2.2 5 5 5 5-2.2 5-5-2.2-5-5-5zm0 2c.4 0 .7.3.7.7s-.3.7-.7.7-.7-.2-.7-.6.3-.8.7-.8zm.7 6H4.3V4.3h1.5V8z",
    fill: fillColor
  }));
}
InfoTooltipIcon.propTypes = {
  fillColor: _propTypes.default.string
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\info-tooltip\\info-tooltip-icon.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\info-tooltip\\info-tooltip.js", {"../tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\index.js","./info-tooltip-icon":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\info-tooltip\\info-tooltip-icon.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cinfo-tooltip%5Cinfo-tooltip.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = InfoTooltip;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _tooltip = _interopRequireDefault(require("../tooltip"));
var _infoTooltipIcon = _interopRequireDefault(require("./info-tooltip-icon"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const positionArrowClassMap = {
  top: 'info-tooltip__top-tooltip-arrow',
  bottom: 'info-tooltip__bottom-tooltip-arrow',
  left: 'info-tooltip__left-tooltip-arrow',
  right: 'info-tooltip__right-tooltip-arrow'
};
function InfoTooltip({
  contentText = '',
  position = '',
  containerClassName,
  wrapperClassName,
  iconFillColor = 'var(--color-icon-alternative)'
}) {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "info-tooltip",
    "data-testid": "info-tooltip"
  }, /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    interactive: true,
    position: position,
    containerClassName: (0, _classnames.default)('info-tooltip__tooltip-container', containerClassName),
    wrapperClassName: wrapperClassName,
    tooltipInnerClassName: "info-tooltip__tooltip-content",
    tooltipArrowClassName: positionArrowClassMap[position],
    html: contentText,
    theme: "tippy-tooltip-info"
  }, /*#__PURE__*/_react.default.createElement(_infoTooltipIcon.default, {
    fillColor: iconFillColor
  })));
}
InfoTooltip.propTypes = {
  /**
   * Text label that shows up after hover
   */
  contentText: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.node]),
  /**
   * Shows position of the tooltip
   */
  position: _propTypes.default.oneOf(['top', 'left', 'bottom', 'right']),
  /**
   * Add custom CSS class for container
   */
  containerClassName: _propTypes.default.string,
  /**
   * Add custom CSS class for the wrapper
   */
  wrapperClassName: _propTypes.default.string,
  /**
   * Add color for the icon
   */
  iconFillColor: _propTypes.default.string
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\info-tooltip\\info-tooltip.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\jazzicon\\index.js", {"./jazzicon.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\jazzicon\\jazzicon.component.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cjazzicon%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _jazzicon.default;
  }
});
var _jazzicon = _interopRequireDefault(require("./jazzicon.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\jazzicon\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\jazzicon\\jazzicon.component.tsx", {"../../../../shared/lib/multichain/accounts":"D:\\code\\v\\metamask-extension\\shared\\lib\\multichain\\accounts.ts","../../../helpers/utils/icon-factory":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\icon-factory.ts","@metamask/jazzicon":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\jazzicon\\index.js","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cjazzicon%5Cjazzicon.component.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _jazzicon = _interopRequireDefault(require("@metamask/jazzicon"));
var _utils = require("@metamask/utils");
var _iconFactory = _interopRequireWildcard(require("../../../helpers/utils/icon-factory"));
var _accounts = require("../../../../shared/lib/multichain/accounts");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Generates a seed for Jazzicon based on the provided address.
 *
 * Our existing seed generation for Ethereum addresses does not work with
 * arbitrary string inputs. Since it assumes the address can be parsed as
 * hexadecimal, however that assumption does not hold for all multichain
 * addresses. Therefore we choose to use a byte array as the seed for multichain
 * addresses. This works since the underlying Mersenne Twister PRNG can be
 * seeded with an array as well.
 *
 * @param address - The blockchain address to generate the seed for.
 * @returns The seed for Jazzicon.
 */
function generateSeed(address) {
  return Array.from((0, _utils.stringToBytes)(address.normalize('NFKC').toLowerCase()));
}
const ethereumIconFactory = (0, _iconFactory.default)(_jazzicon.default);
const multichainIconFactory = new _iconFactory.IconFactory(_jazzicon.default, generateSeed);

/**
 * Renders a Jazzicon component based on the provided address. Utilizes a React ref to manage the DOM element for the icon.
 *
 * @param props - The component props.
 * @param props.address - The blockchain address to generate the icon for.
 * @param props.className - Optional. Additional CSS classes to apply to the container div.
 * @param props.diameter - Optional. The diameter of the icon. Defaults to 46 pixels.
 * @param props.style - Optional. Inline styles for the container div.
 * @param props.tokenList - Optional. An object mapping addresses to token metadata, used to optionally override Jazzicon with specific icons.
 * @param props.namespace - Optional. The namespace to use for the seed generation. Defaults to 'eip155'.
 * @returns A React component displaying a Jazzicon or custom icon.
 */
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function Jazzicon({
  address,
  className,
  diameter = 46,
  style,
  tokenList = {},
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
  // eslint-disable-next-line @typescript-eslint/naming-convention
  namespace: namespace_
}) {
  const container = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    if (!container.current) {
      // eslint-disable-next-line consistent-return
      return;
    }

    // If the address is unknown, `getCaipNamespaceFromAddress` will defaults to "eip155".
    const namespace = namespace_ ?? (0, _accounts.getCaipNamespaceFromAddress)(address);
    const iconFactory = namespace === _utils.KnownCaipNamespace.Eip155 ? ethereumIconFactory : multichainIconFactory;
    const imageNode = iconFactory.iconForAddress(address, diameter, tokenList[address === null || address === void 0 ? void 0 : address.toLowerCase()]);
    container.current.appendChild(imageNode);

    // Clean-up function to remove the icon from the DOM
    // eslint-disable-next-line consistent-return
    return () => {
      while ((_container$current = container.current) !== null && _container$current !== void 0 && _container$current.firstChild) {
        var _container$current;
        container.current.firstChild.remove();
      }
    };
  }, [address, diameter, tokenList]);
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: container,
    className: className,
    style: style
  });
}
var _default = exports.default = Jazzicon;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\jazzicon\\jazzicon.component.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\loading-heartbeat\\index.js", {"../../../ducks/app/app":"D:\\code\\v\\metamask-extension\\ui\\ducks\\app\\app.ts","../../../helpers/utils/gas":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\gas.js","../../../hooks/useShouldAnimateGasEstimations":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useShouldAnimateGasEstimations.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cloading-heartbeat%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = LoadingHeartBeat;
var _reactRedux = require("react-redux");
var _classnames = _interopRequireDefault(require("classnames"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _gas = require("../../../helpers/utils/gas");
var _app = require("../../../ducks/app/app");
var _useShouldAnimateGasEstimations = require("../../../hooks/useShouldAnimateGasEstimations");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const BASE_CLASS = 'loading-heartbeat';
const LOADING_CLASS = `${BASE_CLASS}--active`;
function LoadingHeartBeat({
  estimateUsed,
  backgroundColor = 'var(--color-background-default)'
}) {
  (0, _useShouldAnimateGasEstimations.useShouldAnimateGasEstimations)();
  const active = (0, _reactRedux.useSelector)(_app.getGasLoadingAnimationIsShowing);
  if (false || estimateUsed && !(0, _gas.isMetamaskSuggestedGasEstimate)(estimateUsed)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('loading-heartbeat', {
      [LOADING_CLASS]: active
    }),
    onClick: e => {
      e.preventDefault();
      e.stopPropagation();
    },
    style: {
      backgroundColor
    }
  });
}
LoadingHeartBeat.propTypes = {
  backgroundColor: _propTypes.default.string,
  estimateUsed: _propTypes.default.string
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\loading-heartbeat\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\loading-screen\\index.js", {"./loading-screen.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\loading-screen\\loading-screen.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cloading-screen%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _loadingScreen = _interopRequireDefault(require("./loading-screen.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
var _default = exports.default = _loadingScreen.default;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\loading-screen\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\loading-screen\\loading-screen.component.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../spinner":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\spinner\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cloading-screen%5Cloading-screen.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _spinner = _interopRequireDefault(require("../spinner"));
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LoadingScreen = ({
  header,
  loadingMessage,
  showLoadingSpinner = true
}) => {
  const renderMessage = () => {
    if (!loadingMessage) {
      return null;
    }
    return /*#__PURE__*/(0, _react.isValidElement)(loadingMessage) ? loadingMessage : /*#__PURE__*/_react.default.createElement("span", {
      style: {
        textAlign: 'center'
      }
    }, loadingMessage);
  };
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "loading-overlay"
  }, header, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "loading-overlay__container",
    marginBottom: 3
  }, showLoadingSpinner && /*#__PURE__*/_react.default.createElement(_spinner.default, {
    className: "loading-overlay__spinner"
  })), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Row,
    justifyContent: _designSystem.JustifyContent.center,
    alignItems: _designSystem.AlignItems.center
  }, renderMessage()));
};
LoadingScreen.propTypes = {
  header: _propTypes.default.element,
  loadingMessage: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.element]),
  showLoadingSpinner: _propTypes.default.bool
};
var _default = exports.default = /*#__PURE__*/_react.default.memo(LoadingScreen);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\loading-screen\\loading-screen.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\logo\\logo-lattice.js", {"prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Clogo%5Clogo-lattice.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const LogoLattice = ({
  width = '100%',
  color = 'var(--color-text-default)',
  className,
  ariaLabel
}) => {
  return /*#__PURE__*/_react.default.createElement("svg", {
    width: width,
    fill: color,
    className: className,
    "aria-label": ariaLabel,
    viewBox: "0 0 2546 491",
    xmlns: "http://www.w3.org/2000/svg"
  }, /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M2460 15V30H2488H2516V140V250H2531H2546V125V0H2503H2460V15ZM1861 116.038C1796.99 123.881 1741.39 163.865 1712.97 222.5C1680.8 288.855 1690.83 365.835 1739.17 423.5C1778.97 470.987 1839.99 496.383 1898.79 489.935C1937.49 485.692 1976.26 467.949 2005.03 441.315L2010.98 435.803L1997.36 421.444L1983.74 407.085L1974.62 415.109C1953.06 434.078 1931.7 444.965 1904.88 450.669C1893.48 453.093 1867.95 453.103 1855.82 450.689C1837.26 446.995 1819.5 439.522 1802.54 428.264C1790.63 420.354 1773.3 403.429 1764.69 391.295C1752.74 374.459 1743.39 352.909 1738.81 331.648C1735.63 316.902 1735.66 289.005 1738.87 274C1751.85 213.28 1797.55 166.907 1855.82 155.311C1867.95 152.897 1893.48 152.907 1904.88 155.331C1931.7 161.035 1953.06 171.922 1974.62 190.891L1983.74 198.915L1997.38 184.534L2011.02 170.153L2003.26 163.053C1977.39 139.393 1945.42 123.844 1909.5 117.465C1898.75 115.555 1871.49 114.753 1861 116.038ZM0 303V485H120H240V465.5V446H140.5H41V283.5V121H20.5H0V303ZM407.496 297.75C364.676 394.963 328.599 476.871 327.325 479.769L325.009 485.038L347.632 484.769L370.256 484.5L386.106 448.5C394.823 428.7 403.087 410.135 404.469 407.245L406.983 401.99L508.152 402.245L609.321 402.5L627.41 443.719L645.5 484.938L668.135 484.969L690.769 485L655.85 405.75C636.645 362.163 600.584 280.269 575.716 223.763L530.5 121.027L507.925 121.013L485.35 121L407.496 297.75ZM749 140.5V160H810H871V322.5V485H891.5H912V322.5V160H973H1034V140.5V121H891.5H749V140.5ZM1133 140.5V160H1194H1255V322.5V485H1275.5H1296V322.5V160H1357H1418V140.5V121H1275.5H1133V140.5ZM1534 303V485H1554.5H1575V303V121H1554.5H1534V303ZM2120 303V485H2250.5H2381V465.5V446H2271.5H2162V382.5V319H2260.5H2359V299.5V280H2260.5H2162V220V160H2271.5H2381V140.5V121H2250.5H2120V303ZM550.073 267.125C572.858 318.894 591.65 361.644 591.833 362.125C592.022 362.621 555.677 363 507.976 363C428.21 363 423.821 362.908 424.447 361.25C426.983 354.537 507.62 173.036 508.073 173.02C508.388 173.009 527.288 215.356 550.073 267.125Z"
  }));
};
LogoLattice.propTypes = {
  /**
   * The width of the logo. Defaults to 100%
   */
  width: _propTypes.default.string,
  /**
   * The color of the logo defaults to var(--color-text-default)
   */
  color: _propTypes.default.string,
  /**
   * Additional className to add to the root svg
   */
  className: _propTypes.default.string,
  /**
   * Aria label to add to the logo component
   */
  ariaLabel: _propTypes.default.string
};
var _default = exports.default = LogoLattice;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\logo\\logo-lattice.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\logo\\logo-ledger.js", {"prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Clogo%5Clogo-ledger.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const LogoLedger = ({
  width = '100%',
  color = 'var(--color-text-default)',
  className,
  ariaLabel
}) => {
  return /*#__PURE__*/_react.default.createElement("svg", {
    width: width,
    fill: color,
    className: className,
    "aria-label": ariaLabel,
    viewBox: "0 0 2000.58 669.35",
    xmlns: "http://www.w3.org/2000/svg"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "m1711.35 627.2v42.14h289.22v-190.05h-42.14v147.91zm0-627.2v42.14h247.08v147.92h42.14v-190.06zm-149.15 326v-97.92h66.11c32.23 0 43.8 10.74 43.8 40.08v17.35c0 30.16-11.16 40.49-43.8 40.49zm104.94 17.35c30.16-7.85 51.23-35.95 51.23-69.41 0-21.07-8.26-40.08-23.96-55.37-19.83-19.01-46.28-28.51-80.57-28.51h-92.96v289.22h41.32v-115.27h61.98c31.81 0 44.62 13.22 44.62 46.28v69h42.14v-62.39c0-45.45-10.74-62.8-43.8-67.76zm-347.88 9.5h127.26v-38.01h-127.26v-86.77h139.65v-38.01h-181.8v289.22h188v-38.01h-145.85zm-138.42 15.29v19.83c0 41.73-15.29 55.37-53.71 55.37h-9.09c-38.43 0-57.02-12.4-57.02-69.83v-77.68c0-57.84 19.42-69.83 57.84-69.83h8.26c37.6 0 49.58 14.05 49.99 52.89h45.45c-4.13-57.02-42.14-92.96-99.16-92.96-27.68 0-50.82 8.68-68.17 25.2-26.03 24.38-40.49 65.7-40.49 123.54 0 55.78 12.4 97.1 38.01 122.71 17.35 16.94 41.32 26.03 64.87 26.03 24.79 0 47.52-9.92 59.08-31.4h5.78v27.27h38.01v-149.15h-111.97v38.01zm-364.41-140.07h45.04c42.56 0 65.7 10.74 65.7 68.59v76.02c0 57.84-23.14 68.59-65.7 68.59h-45.04zm48.75 251.22c78.92 0 108.25-59.91 108.25-144.61 0-85.94-31.4-144.61-109.08-144.61h-89.25v289.22zm-289.63-126.44h127.26v-38.01h-127.26v-86.77h139.65v-38.01h-181.8v289.22h188v-38.01h-145.85zm-243.77-162.79h-42.14v289.22h190.06v-38.01h-147.92zm-331.78 289.23v190.06h289.22v-42.15h-247.08v-147.91zm0-479.29v190.06h42.14v-147.92h247.08v-42.14z"
  }));
};
LogoLedger.propTypes = {
  /**
   * The width of the logo. Defaults to 100%
   */
  width: _propTypes.default.string,
  /**
   * The color of the logo defaults to var(--color-text-default)
   */
  color: _propTypes.default.string,
  /**
   * Additional className to add to the root svg
   */
  className: _propTypes.default.string,
  /**
   * Aria label to add to the logo component
   */
  ariaLabel: _propTypes.default.string
};
var _default = exports.default = LogoLedger;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\logo\\logo-ledger.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\logo\\logo-qr-based.js", {"prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Clogo%5Clogo-qr-based.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const LogoQRBased = ({
  width = '100%',
  color = 'var(--color-text-default)',
  className,
  ariaLabel
}) => {
  return /*#__PURE__*/_react.default.createElement("svg", {
    width: width,
    fill: color,
    className: className,
    "aria-label": ariaLabel,
    viewBox: "0 0 107 24",
    xmlns: "http://www.w3.org/2000/svg"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "M1.3333 8H6.6667C7.403 8 8 7.403 8 6.6667V1.3333C8 0.597002 7.403 0 6.6667 0H1.3333C0.597 0 0 0.597002 0 1.3333V6.6667C0 7.403 0.597 8 1.3333 8ZM2.6667 2.6667H5.3333V5.3333H2.6667V2.6667ZM0.6667 13.3333H2C2.3682 13.3333 2.6667 13.0349 2.6667 12.6667V11.3333C2.6667 10.9651 2.3682 10.6667 2 10.6667H0.6667C0.2985 10.6667 0 10.9651 0 11.3333V12.6667C0 13.0349 0.2985 13.3333 0.6667 13.3333ZM6.6667 16H1.3333C0.597 16 0 16.597 0 17.3333V22.6667C0 23.403 0.597 24 1.3333 24H6.6667C7.403 24 8 23.403 8 22.6667V17.3333C8 16.597 7.403 16 6.6667 16ZM5.3333 21.3333H2.6667V18.6667H5.3333V21.3333ZM19.3333 24H23.3333C23.7015 24 24 23.7015 24 23.3333V19.3333C24 18.9651 23.7015 18.6667 23.3333 18.6667H22C21.6318 18.6667 21.3333 18.9651 21.3333 19.3333V21.3333H18.6667V23.3333C18.6667 23.7015 18.9651 24 19.3333 24ZM22.6667 0H17.3333C16.597 0 16 0.597002 16 1.3333V6.6667C16 7.403 16.597 8 17.3333 8H22.6667C23.403 8 24 7.403 24 6.6667V1.3333C24 0.597002 23.403 0 22.6667 0ZM21.3333 5.3333H18.6667V2.6667H21.3333V5.3333ZM6 10.6667C5.6318 10.6667 5.3333 10.9651 5.3333 11.3333V12.6667C5.3333 13.0349 5.6318 13.3333 6 13.3333H10.6667V10.6667H6ZM10.6667 15.3333C10.6667 15.7015 10.9651 16 11.3333 16H13.3333V18C13.3333 18.3682 13.6318 18.6667 14 18.6667H16V13.3333H10.6667V15.3333ZM10.6667 22V23.3333C10.6667 23.7015 10.9651 24 11.3333 24H15.3333C15.7015 24 16 23.7015 16 23.3333V21.3333H11.3333C10.9651 21.3333 10.6667 21.6318 10.6667 22ZM23.3333 10.6667H16.6667C16.2985 10.6667 16 10.9651 16 11.3333V13.3333H18.6667V15.3333C18.6667 15.7015 18.9651 16 19.3333 16H20.6667C21.0349 16 21.3333 15.7015 21.3333 15.3333V13.3333H23.3333C23.7015 13.3333 24 13.0349 24 12.6667V11.3333C24 10.9651 23.7015 10.6667 23.3333 10.6667ZM18.6667 21.3333V18.6667H16V21.3333H18.6667ZM11.3333 5.3333H12.6667C13.0349 5.3333 13.3333 5.0349 13.3333 4.6667V0.666698C13.3333 0.298498 13.0349 0 12.6667 0H11.3333C10.9651 0 10.6667 0.298498 10.6667 0.666698V4.6667C10.6667 5.0349 10.9651 5.3333 11.3333 5.3333ZM13.3333 10V8.6667C13.3333 8.2985 13.0349 8 12.6667 8H11.3333C10.9651 8 10.6667 8.2985 10.6667 8.6667V10.6667H12.6667C13.0349 10.6667 13.3333 10.3682 13.3333 10Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M38.592 18.192C37.7707 18.192 37.0027 18.0427 36.288 17.744C35.584 17.4347 34.9653 17.0187 34.432 16.496C33.8987 15.9627 33.4773 15.3387 33.168 14.624C32.8693 13.9093 32.72 13.1413 32.72 12.32C32.72 11.4987 32.8693 10.7307 33.168 10.016C33.4773 9.3013 33.8987 8.6827 34.432 8.16C34.9653 7.6267 35.584 7.2107 36.288 6.912C37.0027 6.6027 37.7707 6.448 38.592 6.448C39.4133 6.448 40.1813 6.6027 40.896 6.912C41.6107 7.2107 42.2293 7.6267 42.752 8.16C43.2853 8.6827 43.7013 9.3013 44 10.016C44.3093 10.7307 44.464 11.4987 44.464 12.32C44.464 13.0347 44.3467 13.7067 44.112 14.336C43.888 14.9653 43.5733 15.536 43.168 16.048L45.28 18H43.248L42.16 17.008C41.6693 17.3813 41.12 17.6747 40.512 17.888C39.904 18.0907 39.264 18.192 38.592 18.192ZM38.592 16.784C39.5413 16.784 40.3787 16.528 41.104 16.016L39.296 14.336L40.208 13.312L42.08 15.056C42.3573 14.6827 42.576 14.2667 42.736 13.808C42.896 13.3387 42.976 12.8427 42.976 12.32C42.976 11.7013 42.864 11.12 42.64 10.576C42.416 10.032 42.1067 9.5573 41.712 9.152C41.328 8.7467 40.864 8.432 40.32 8.208C39.7867 7.9733 39.2107 7.856 38.592 7.856C37.9733 7.856 37.3973 7.9733 36.864 8.208C36.3307 8.432 35.8667 8.7467 35.472 9.152C35.088 9.5573 34.784 10.032 34.56 10.576C34.336 11.12 34.224 11.7013 34.224 12.32C34.224 12.9493 34.336 13.536 34.56 14.08C34.784 14.6133 35.088 15.0827 35.472 15.488C35.8667 15.8933 36.3307 16.2133 36.864 16.448C37.3973 16.672 37.9733 16.784 38.592 16.784ZM46.9259 6.64H50.7979C51.3205 6.64 51.7899 6.7147 52.2059 6.864C52.6325 7.0133 52.9899 7.2267 53.2779 7.504C53.5765 7.7813 53.8005 8.112 53.9499 8.496C54.1099 8.88 54.1899 9.3067 54.1899 9.776C54.1899 10.608 53.9392 11.2907 53.4379 11.824C52.9472 12.3573 52.2592 12.688 51.3739 12.816L55.7579 18H53.8859L49.5179 12.832H48.4139V18H46.9259V6.64ZM50.6219 11.504C51.2725 11.504 51.7792 11.36 52.1419 11.072C52.5152 10.784 52.7019 10.352 52.7019 9.776C52.7019 9.2 52.5152 8.7627 52.1419 8.464C51.7792 8.1653 51.2725 8.016 50.6219 8.016H48.4139V11.504H50.6219ZM55.8681 12.832H59.948V14.208H55.8681V12.832ZM66.488 18.16C65.88 18.16 65.325 18.0267 64.824 17.76C64.323 17.4827 63.939 17.152 63.672 16.768V18H62.296V6H63.672V11.232C63.939 10.848 64.323 10.5227 64.824 10.256C65.325 9.9787 65.88 9.84 66.488 9.84C67.043 9.84 67.56 9.952 68.04 10.176C68.52 10.3893 68.936 10.688 69.288 11.072C69.64 11.4453 69.912 11.8827 70.104 12.384C70.307 12.8853 70.408 13.424 70.408 14C70.408 14.576 70.307 15.1147 70.104 15.616C69.912 16.1173 69.64 16.56 69.288 16.944C68.936 17.3173 68.52 17.616 68.04 17.84C67.56 18.0533 67.043 18.16 66.488 18.16ZM66.28 16.896C66.685 16.896 67.053 16.8213 67.384 16.672C67.715 16.5227 67.997 16.32 68.232 16.064C68.477 15.7973 68.664 15.488 68.792 15.136C68.931 14.784 69 14.4053 69 14C69 13.5947 68.931 13.216 68.792 12.864C68.664 12.512 68.477 12.208 68.232 11.952C67.997 11.6853 67.715 11.4773 67.384 11.328C67.053 11.1787 66.685 11.104 66.28 11.104C65.875 11.104 65.507 11.1787 65.176 11.328C64.845 11.4773 64.557 11.6853 64.312 11.952C64.077 12.208 63.891 12.512 63.752 12.864C63.624 13.216 63.56 13.5947 63.56 14C63.56 14.4053 63.624 14.784 63.752 15.136C63.891 15.488 64.077 15.7973 64.312 16.064C64.557 16.32 64.845 16.5227 65.176 16.672C65.507 16.8213 65.875 16.896 66.28 16.896ZM75.67 18.16C75.105 18.16 74.582 18.0533 74.102 17.84C73.633 17.616 73.222 17.3173 72.87 16.944C72.518 16.56 72.241 16.1173 72.038 15.616C71.846 15.1147 71.75 14.576 71.75 14C71.75 13.424 71.846 12.8853 72.038 12.384C72.241 11.8827 72.518 11.4453 72.87 11.072C73.222 10.688 73.633 10.3893 74.102 10.176C74.582 9.952 75.105 9.84 75.67 9.84C76.278 9.84 76.833 9.9787 77.334 10.256C77.835 10.5227 78.219 10.848 78.486 11.232V10H79.862V18H78.486V16.768C78.219 17.152 77.835 17.4827 77.334 17.76C76.833 18.0267 76.278 18.16 75.67 18.16ZM75.878 16.896C76.283 16.896 76.651 16.8213 76.982 16.672C77.313 16.5227 77.595 16.32 77.83 16.064C78.075 15.7973 78.262 15.488 78.39 15.136C78.529 14.784 78.598 14.4053 78.598 14C78.598 13.5947 78.529 13.216 78.39 12.864C78.262 12.512 78.075 12.208 77.83 11.952C77.595 11.6853 77.313 11.4773 76.982 11.328C76.651 11.1787 76.283 11.104 75.878 11.104C75.473 11.104 75.099 11.1787 74.758 11.328C74.427 11.4773 74.139 11.6853 73.894 11.952C73.659 12.208 73.473 12.512 73.334 12.864C73.206 13.216 73.142 13.5947 73.142 14C73.142 14.4053 73.206 14.784 73.334 15.136C73.473 15.488 73.659 15.7973 73.894 16.064C74.139 16.32 74.427 16.5227 74.758 16.672C75.099 16.8213 75.473 16.896 75.878 16.896ZM85.028 18.16C84.602 18.16 84.196 18.1067 83.812 18C83.428 17.8933 83.092 17.7387 82.804 17.536C82.516 17.3227 82.282 17.0613 82.1 16.752C81.919 16.4427 81.812 16.0853 81.78 15.68H83.188C83.231 15.9253 83.311 16.1333 83.428 16.304C83.556 16.464 83.706 16.5973 83.876 16.704C84.047 16.8107 84.228 16.8853 84.42 16.928C84.623 16.9707 84.831 16.992 85.044 16.992C85.482 16.992 85.844 16.9067 86.132 16.736C86.431 16.5547 86.58 16.288 86.58 15.936C86.58 15.616 86.479 15.3547 86.276 15.152C86.074 14.9493 85.732 14.784 85.252 14.656L84.1 14.352C83.407 14.1707 82.89 13.8773 82.548 13.472C82.207 13.0667 82.036 12.576 82.036 12C82.036 11.6693 82.106 11.3707 82.244 11.104C82.383 10.8373 82.575 10.6133 82.82 10.432C83.066 10.24 83.354 10.096 83.684 10C84.026 9.8933 84.399 9.84 84.804 9.84C85.231 9.84 85.615 9.8987 85.956 10.016C86.298 10.1333 86.591 10.2987 86.836 10.512C87.092 10.7147 87.295 10.9547 87.444 11.232C87.594 11.5093 87.684 11.808 87.716 12.128H86.34C86.234 11.776 86.042 11.4987 85.764 11.296C85.498 11.0933 85.178 10.992 84.804 10.992C84.42 10.992 84.095 11.0827 83.828 11.264C83.562 11.4347 83.428 11.6747 83.428 11.984C83.428 12.2827 83.524 12.5227 83.716 12.704C83.908 12.8747 84.218 13.0187 84.644 13.136L85.924 13.472C86.596 13.6427 87.103 13.9307 87.444 14.336C87.796 14.7307 87.972 15.232 87.972 15.84C87.972 16.2347 87.898 16.5813 87.748 16.88C87.599 17.168 87.391 17.408 87.124 17.6C86.858 17.792 86.543 17.9307 86.18 18.016C85.828 18.112 85.444 18.16 85.028 18.16ZM93.329 18.16C92.742 18.16 92.204 18.0587 91.713 17.856C91.222 17.6427 90.796 17.3493 90.433 16.976C90.081 16.6027 89.804 16.1653 89.601 15.664C89.398 15.152 89.297 14.5973 89.297 14C89.297 13.4133 89.388 12.8693 89.569 12.368C89.761 11.856 90.033 11.4133 90.385 11.04C90.737 10.6667 91.164 10.3733 91.665 10.16C92.166 9.9467 92.732 9.84 93.361 9.84C93.99 9.84 94.55 9.9627 95.041 10.208C95.542 10.4427 95.958 10.768 96.289 11.184C96.63 11.5893 96.876 12.0693 97.025 12.624C97.185 13.168 97.244 13.7493 97.201 14.368H90.689C90.7 14.7307 90.774 15.0667 90.913 15.376C91.062 15.6853 91.254 15.9573 91.489 16.192C91.724 16.416 92.001 16.592 92.321 16.72C92.641 16.848 92.982 16.912 93.345 16.912C93.846 16.912 94.294 16.8107 94.689 16.608C95.094 16.3947 95.42 16.048 95.665 15.568H97.073C96.977 15.92 96.822 16.256 96.609 16.576C96.396 16.8853 96.129 17.1573 95.809 17.392C95.5 17.6267 95.137 17.8133 94.721 17.952C94.305 18.0907 93.841 18.16 93.329 18.16ZM93.313 11.056C93.025 11.056 92.742 11.0987 92.465 11.184C92.188 11.2693 91.932 11.4027 91.697 11.584C91.473 11.7653 91.276 11.9947 91.105 12.272C90.934 12.5493 90.817 12.8853 90.753 13.28H95.745C95.617 12.5333 95.329 11.9787 94.881 11.616C94.433 11.2427 93.91 11.056 93.313 11.056ZM102.483 18.16C101.917 18.16 101.395 18.0533 100.915 17.84C100.445 17.616 100.035 17.3173 99.683 16.944C99.331 16.56 99.053 16.1173 98.851 15.616C98.659 15.1147 98.563 14.576 98.563 14C98.563 13.424 98.659 12.8853 98.851 12.384C99.053 11.8827 99.331 11.4453 99.683 11.072C100.035 10.688 100.445 10.3893 100.915 10.176C101.395 9.952 101.917 9.84 102.483 9.84C103.091 9.84 103.645 9.9787 104.147 10.256C104.648 10.5227 105.032 10.848 105.299 11.232V6H106.675V18H105.299V16.768C105.032 17.152 104.648 17.4827 104.147 17.76C103.645 18.0267 103.091 18.16 102.483 18.16ZM102.691 16.896C103.096 16.896 103.464 16.8213 103.795 16.672C104.125 16.5227 104.408 16.32 104.643 16.064C104.888 15.7973 105.075 15.488 105.203 15.136C105.341 14.784 105.411 14.4053 105.411 14C105.411 13.5947 105.341 13.216 105.203 12.864C105.075 12.512 104.888 12.208 104.643 11.952C104.408 11.6853 104.125 11.4773 103.795 11.328C103.464 11.1787 103.096 11.104 102.691 11.104C102.285 11.104 101.912 11.1787 101.571 11.328C101.24 11.4773 100.952 11.6853 100.707 11.952C100.472 12.208 100.285 12.512 100.147 12.864C100.019 13.216 99.955 13.5947 99.955 14C99.955 14.4053 100.019 14.784 100.147 15.136C100.285 15.488 100.472 15.7973 100.707 16.064C100.952 16.32 101.24 16.5227 101.571 16.672C101.912 16.8213 102.285 16.896 102.691 16.896Z"
  }));
};
LogoQRBased.propTypes = {
  /**
   * The width of the logo. Defaults to 100%
   */
  width: _propTypes.default.string,
  /**
   * The color of the logo defaults to var(--color-text-default)
   */
  color: _propTypes.default.string,
  /**
   * Additional className to add to the root svg
   */
  className: _propTypes.default.string,
  /**
   * Aria label to add to the logo component
   */
  ariaLabel: _propTypes.default.string
};
var _default = exports.default = LogoQRBased;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\logo\\logo-qr-based.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\logo\\logo-trezor.js", {"prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Clogo%5Clogo-trezor.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const LogoTrezor = ({
  width = '100%',
  color = 'var(--color-text-default)',
  className,
  ariaLabel
}) => {
  return /*#__PURE__*/_react.default.createElement("svg", {
    width: width,
    fill: color,
    className: className,
    "aria-label": ariaLabel,
    viewBox: "0 0 1482 378",
    xmlns: "http://www.w3.org/2000/svg"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "m915.31 115.89h154.82v40.74l-84.2 114.08h84.2v47.98h-154.82v-40.74l84.2-114.08h-84.2z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "m1437.7101 243.55c19-7.25 38.9301-26.26 38.9301-59.76 0-40.74-28.0601-67-69.71-67h-95.0601v201.9h52.51v-67.9h19.9199l37.12 67.9h60.66l-44.37-75.14zm-37.12-39.84h-36.21v-40.74h36.21c13.58 0 22.64 8.15 22.64 19.92 0 12.67-9.0601 20.82-22.64 20.82z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "m1184.2101 113.17c-61.5699 0-105 44.36-105 104.12s44.34 104.12 105 104.12 105.9301-44.37 105.9301-104.12-44.3701-104.12-105.9301-104.12zm0 161.16c-30.78 0-51.61-23.54-51.61-57 0-34.4 20.83-57 51.61-57s52.51 23.54 52.51 57-21.7301 56.9999-52.51 56.9999z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "m743.29 115.89h146.6701v47.08h-94.1601v29.87h91.44v46.18h-91.44v32.59h94.1601v47.08h-146.6701z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "m222.7 87.82c0-48-41.65-87.82-92.35-87.82s-92.35 39.84-92.35 87.82v28.07h-38v201.9l130.35 60.62 130.38-60.66v-201h-38zm-137.62 0c0-22.63 19.92-40.74 45.27-40.74s45.27 18.11 45.27 40.74v28.07h-90.54zm123.13 197.37-77.86 36.22-77.86-36.22v-121.32h155.72z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "m718.85 183.79c0-40.74-28.07-67-69.72-67h-95.0599v201.9h52.51v-67.9h19.92l37.12 67.9h60.68l-44.37-75.14c19-7.25 38.92-26.26 38.92-59.76zm-76.06 19.92h-36.21v-40.74h36.21c13.58 0 22.64 8.15 22.64 19.92 0 12.67-9.0601 20.82-22.6401 20.82z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "m366.66 115.89h163.87v47.98h-56.13v154.82h-52.52v-154.82h-55.22z"
  }));
};
LogoTrezor.propTypes = {
  /**
   * The width of the logo. Defaults to 100%
   */
  width: _propTypes.default.string,
  /**
   * The color of the logo defaults to var(--color-text-default)
   */
  color: _propTypes.default.string,
  /**
   * Additional className to add to the root svg
   */
  className: _propTypes.default.string,
  /**
   * Aria label to add to the logo component
   */
  ariaLabel: _propTypes.default.string
};
var _default = exports.default = LogoTrezor;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\logo\\logo-trezor.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\mascot\\index.js", {"./mascot.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\mascot\\mascot.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cmascot%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _mascot.default;
  }
});
var _mascot = _interopRequireDefault(require("./mascot.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\mascot\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\mascot\\mascot.component.js", {"../../../helpers/utils/build-types":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\build-types.js","@metamask/logo":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\logo\\src\\index.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cmascot%5Cmascot.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _logo = _interopRequireDefault(require("@metamask/logo"));
var _lodash = require("lodash");
var _buildTypes = require("../../../helpers/utils/build-types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
const directionTargetGenerator = ({
  top,
  left,
  height,
  width
}) => {
  const horizontalMiddle = left + width / 2;
  const verticalMiddle = top + height / 2;
  return {
    up: {
      x: horizontalMiddle,
      y: top - height
    },
    down: {
      x: horizontalMiddle,
      y: top + height * 2
    },
    left: {
      x: left - width,
      y: verticalMiddle
    },
    right: {
      x: left + width * 2,
      y: verticalMiddle
    },
    middle: {
      x: horizontalMiddle,
      y: verticalMiddle
    }
  };
};
class Mascot extends _react.Component {
  constructor(props) {
    super(props);
    const {
      width,
      height,
      followMouse
    } = props;
    this.logo = (0, _logo.default)({
      followMouse,
      pxNotRatio: true,
      width,
      height,
      meshJson: (0, _buildTypes.getBuildSpecificAsset)('foxMeshJson'),
      verticalFieldOfView: Math.PI / 37.5,
      near: 100,
      far: 340
    });
    this.mascotContainer = /*#__PURE__*/(0, _react.createRef)();
    this.refollowMouse = (0, _lodash.debounce)(this.logo.setFollowMouse.bind(this.logo, true), 1000);
    this.unfollowMouse = this.logo.setFollowMouse.bind(this.logo, false);
  }
  handleAnimationEvents() {
    // only setup listeners once
    if (this.animations) {
      return;
    }
    this.animations = this.props.animationEventEmitter;
    this.animations.on('point', this.lookAt.bind(this));
    this.animations.on('setFollowMouse', this.logo.setFollowMouse.bind(this.logo));
  }
  lookAt(target) {
    this.unfollowMouse();
    this.logo.lookAtAndRender(target);
    this.refollowMouse();
  }
  componentDidMount() {
    this.mascotContainer.current.appendChild(this.logo.container);
    this.directionTargetMap = directionTargetGenerator(this.mascotContainer.current.getBoundingClientRect());
    const {
      lookAtTarget,
      lookAtDirection
    } = this.props;
    if (lookAtTarget !== null && lookAtTarget !== void 0 && lookAtTarget.x && lookAtTarget !== null && lookAtTarget !== void 0 && lookAtTarget.y) {
      this.logo.lookAtAndRender(lookAtTarget);
    } else if (lookAtDirection) {
      this.logo.lookAtAndRender(this.directionTargetMap[lookAtDirection]);
    }
  }
  componentDidUpdate(prevProps) {
    const {
      lookAtTarget: prevTarget = {},
      lookAtDirection: prevDirection = null,
      followMouse: prevFollowMouse
    } = prevProps;
    const {
      lookAtTarget = {},
      followMouse,
      lookAtDirection
    } = this.props;
    if (lookAtDirection && prevDirection !== lookAtDirection) {
      this.logo.lookAtAndRender(this.directionTargetMap[lookAtDirection]);
    } else if ((lookAtTarget === null || lookAtTarget === void 0 ? void 0 : lookAtTarget.x) !== (prevTarget === null || prevTarget === void 0 ? void 0 : prevTarget.x) || (lookAtTarget === null || lookAtTarget === void 0 ? void 0 : lookAtTarget.y) !== (prevTarget === null || prevTarget === void 0 ? void 0 : prevTarget.y)) {
      this.logo.lookAtAndRender(lookAtTarget);
    }
    if (prevFollowMouse !== followMouse) {
      this.unfollowMouse();
      followMouse && this.refollowMouse();
    }
  }
  componentWillUnmount() {
    this.animations = this.props.animationEventEmitter;
    this.animations.removeAllListeners();
    this.logo.container.remove();
    this.logo.stopAnimation();
  }
  render() {
    // this is a bit hacky
    // the event emitter is on `this.props`
    // and we dont get that until render
    this.handleAnimationEvents();
    return /*#__PURE__*/_react.default.createElement("div", {
      ref: this.mascotContainer,
      style: {
        zIndex: 0
      }
    });
  }
}
exports.default = Mascot;
_defineProperty(Mascot, "propTypes", {
  animationEventEmitter: _propTypes.default.object.isRequired,
  width: _propTypes.default.string,
  height: _propTypes.default.string,
  followMouse: _propTypes.default.bool,
  lookAtTarget: _propTypes.default.object,
  lookAtDirection: _propTypes.default.oneOf(['up', 'down', 'left', 'right', 'middle'])
});
_defineProperty(Mascot, "defaultProps", {
  width: '200',
  height: '200',
  followMouse: true,
  lookAtTarget: {},
  lookAtDirection: null
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\mascot\\mascot.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\menu\\index.ts", {"./menu":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\menu\\menu.js","./menu-item":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\menu\\menu-item.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cmenu%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "Menu", {
  enumerable: true,
  get: function () {
    return _menu.default;
  }
});
Object.defineProperty(exports, "MenuItem", {
  enumerable: true,
  get: function () {
    return _menuItem.default;
  }
});
var _menu = _interopRequireDefault(require("./menu"));
var _menuItem = _interopRequireDefault(require("./menu-item"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\menu\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\menu\\menu-item.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cmenu%5Cmenu-item.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MenuItem = /*#__PURE__*/_react.default.forwardRef(({
  children,
  className = '',
  'data-testid': dataTestId,
  iconName,
  iconColor,
  onClick,
  subtitle,
  disabled,
  showInfoDot,
  textVariant,
  to
}, ref) => {
  const content = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, iconName && showInfoDot && /*#__PURE__*/_react.default.createElement(_componentLibrary.BadgeWrapper, {
    anchorElementShape: _componentLibrary.BadgeWrapperAnchorElementShape.circular,
    display: _designSystem.Display.Block,
    position: _componentLibrary.BadgeWrapperPosition.topRight,
    positionObj: {
      top: -6,
      right: 4
    },
    badge: /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
      name: _componentLibrary.IconName.FullCircle,
      size: _componentLibrary.IconSize.Xs,
      color: _designSystem.IconColor.primaryDefault,
      style: {
        '--size': '10px'
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: iconName,
    size: _componentLibrary.IconSize.Sm,
    marginRight: 2
  })), iconName && !showInfoDot && /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: iconName,
    size: _componentLibrary.IconSize.Sm,
    marginRight: 3,
    color: iconColor
  }), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: textVariant,
    as: "div"
  }, children), subtitle ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyXs,
    color: _designSystem.TextColor.textAlternative
  }, subtitle) : null));
  if (to) {
    return disabled ? /*#__PURE__*/_react.default.createElement("span", {
      className: (0, _classnames.default)('menu-item', className),
      "data-testid": dataTestId,
      ref: ref
    }, content) : /*#__PURE__*/_react.default.createElement(_reactRouterDomV5Compat.Link, {
      to: to,
      className: (0, _classnames.default)('menu-item', className),
      "data-testid": dataTestId,
      ref: ref,
      onClick: onClick
    }, content);
  }
  return /*#__PURE__*/_react.default.createElement("button", {
    className: (0, _classnames.default)('menu-item', className),
    "data-testid": dataTestId,
    disabled: disabled,
    ref: ref,
    onClick: onClick
  }, content);
});
MenuItem.displayName = 'MenuItem';
var _default = exports.default = /*#__PURE__*/(0, _react.memo)(MenuItem);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\menu\\menu-item.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\menu\\menu.js", {"classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-dom\\index.js","react-popper":"D:\\code\\v\\metamask-extension\\node_modules\\react-popper\\lib\\cjs\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cmenu%5Cmenu.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _reactDom = require("react-dom");
var _reactPopper = require("react-popper");
var _classnames = _interopRequireDefault(require("classnames"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
/**
 * @deprecated The `<Menu />` component has been deprecated in favor of the new `<Popover>` component from the component-library.
 * Please update your code to use the new `<Popover>` component instead, which can be found at ui/components/component-library/popover/popover.tsx.
 * You can find documentation for the new `Popover` component in the MetaMask Storybook:
 * {@link https://metamask.github.io/metamask-storybook/?path=/docs/components-componentlibrary-popover--docs}
 * If you would like to help with the replacement of the old `Menu` component, please submit a pull request against this GitHub issue:
 * {@link https://github.com/MetaMask/metamask-extension/issues/20498}
 */

const Menu = ({
  anchorElement,
  children,
  className,
  'data-testid': dataTestId,
  onHide,
  popperOptions
}) => {
  const [popperElement, setPopperElement] = (0, _react.useState)(null);
  const popoverContainerElement = (0, _react.useRef)(document.getElementById('popover-content'));
  const {
    attributes,
    styles
  } = (0, _reactPopper.usePopper)(anchorElement, popperElement, popperOptions);
  return /*#__PURE__*/(0, _reactDom.createPortal)(/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "menu__background",
    "data-testid": dataTestId,
    onClick: onHide
  }), /*#__PURE__*/_react.default.createElement("div", _extends({
    className: (0, _classnames.default)('menu__container', className),
    "data-testid": className,
    ref: setPopperElement,
    style: styles.popper
  }, attributes.popper), children)), popoverContainerElement.current);
};
Menu.propTypes = {
  anchorElement: _propTypes.default.instanceOf(window.Element),
  children: _propTypes.default.node.isRequired,
  className: _propTypes.default.string,
  onHide: _propTypes.default.func.isRequired,
  popperOptions: _propTypes.default.object,
  dataTestId: _propTypes.default.string
};
Menu.defaultProps = {
  anchorElement: undefined,
  className: undefined,
  popperOptions: undefined
};
var _default = exports.default = Menu;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\menu\\menu.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\metafox-logo\\horizontal-logo.js", {"../../../../shared/constants/preferences":"D:\\code\\v\\metamask-extension\\shared\\constants\\preferences.ts","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cmetafox-logo%5Chorizontal-logo.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = MetaFoxHorizontalLogo;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _preferences = require("../../../../shared/constants/preferences");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/* eslint-disable @metamask/design-tokens/color-no-hex*/

const LOGO_WIDTH = 162;
const LOGO_HEIGHT = 30;
function MetaFoxHorizontalLogo({
  theme: themeProps,
  className
}) {
  const [theme, setTheme] = (0, _react.useState)(() => themeProps === undefined ? document.documentElement.getAttribute('data-theme') : themeProps);
  const fill = theme === _preferences.ThemeType.dark ? 'rgb(255,255,255)' : 'rgb(22,22,22)';
  (0, _react.useEffect)(() => {
    let newTheme = themeProps;
    if (newTheme === undefined) {
      newTheme = document.documentElement.getAttribute('data-theme');
    }
    setTheme(newTheme);
  }, [themeProps, setTheme]);
  return /*#__PURE__*/_react.default.createElement("svg", {
    height: LOGO_HEIGHT,
    width: LOGO_WIDTH,
    viewBox: "0 0 400 80",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    className: className
  }, /*#__PURE__*/_react.default.createElement("defs", null, /*#__PURE__*/_react.default.createElement("linearGradient", {
    id: "aerisTextGradient",
    x1: "0%",
    y1: "0%",
    x2: "100%",
    y2: "0%"
  }, /*#__PURE__*/_react.default.createElement("stop", {
    offset: "0%",
    style: {
      stopColor: '#667EEA',
      stopOpacity: 1
    }
  }), /*#__PURE__*/_react.default.createElement("stop", {
    offset: "100%",
    style: {
      stopColor: '#764BA2',
      stopOpacity: 1
    }
  }))), /*#__PURE__*/_react.default.createElement("text", {
    x: "10",
    y: "55",
    fontFamily: "Arial, sans-serif",
    fontSize: "48",
    fontWeight: "bold",
    fill: theme === _preferences.ThemeType.dark ? 'url(#aerisTextGradient)' : 'url(#aerisTextGradient)',
    letterSpacing: "2"
  }, "Aeris Wallet"));
}
MetaFoxHorizontalLogo.propTypes = {
  theme: _propTypes.default.oneOf([_preferences.ThemeType.light, _preferences.ThemeType.dark, _preferences.ThemeType.os]),
  className: _propTypes.default.string
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\metafox-logo\\horizontal-logo.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\metafox-logo\\index.js", {"./metafox-logo.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\metafox-logo\\metafox-logo.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cmetafox-logo%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _metafoxLogo.default;
  }
});
var _metafoxLogo = _interopRequireDefault(require("./metafox-logo.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\metafox-logo\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\metafox-logo\\metafox-logo.component.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","./horizontal-logo":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\metafox-logo\\horizontal-logo.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cmetafox-logo%5Cmetafox-logo.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _horizontalLogo = _interopRequireDefault(require("./horizontal-logo"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class MetaFoxLogo extends _react.PureComponent {
  render() {
    const {
      onClick,
      unsetIconHeight,
      isOnboarding,
      theme
    } = this.props;
    const iconProps = unsetIconHeight ? {} : {
      height: 42,
      width: 42
    };
    iconProps.src = './images/logo/metamask-fox.svg';
    let renderHorizontalLogo = () => /*#__PURE__*/_react.default.createElement(_horizontalLogo.default, {
      theme: theme,
      className: (0, _classnames.default)({
        'app-header__metafox-logo--horizontal': !isOnboarding,
        'onboarding-app-header__metafox-logo--horizontal': isOnboarding
      })
    });
    let imageSrc = './images/logo/metamask-fox.svg';
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
      as: "button",
      onClick: onClick,
      className: (0, _classnames.default)({
        'app-header__logo-container': !isOnboarding,
        'onboarding-app-header__logo-container': isOnboarding,
        'app-header__logo-container--clickable': Boolean(onClick)
      }),
      backgroundColor: _designSystem.BackgroundColor.transparent,
      "data-testid": "app-header-logo"
    }, renderHorizontalLogo(), /*#__PURE__*/_react.default.createElement("img", _extends({}, iconProps, {
      src: imageSrc,
      className: (0, _classnames.default)({
        'app-header__metafox-logo--icon': !isOnboarding,
        'onboarding-app-header__metafox-logo--icon': isOnboarding
      }),
      alt: ""
    })));
  }
}
exports.default = MetaFoxLogo;
_defineProperty(MetaFoxLogo, "propTypes", {
  onClick: _propTypes.default.func,
  unsetIconHeight: _propTypes.default.bool,
  isOnboarding: _propTypes.default.bool,
  theme: _propTypes.default.string
});
_defineProperty(MetaFoxLogo, "defaultProps", {
  onClick: undefined,
  unsetIconHeight: false,
  isOnboarding: false,
  theme: undefined
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\metafox-logo\\metafox-logo.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\nickname-popover\\index.js", {"./nickname-popover.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\nickname-popover\\nickname-popover.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cnickname-popover%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _nicknamePopover.default;
  }
});
var _nicknamePopover = _interopRequireDefault(require("./nickname-popover.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\nickname-popover\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\nickname-popover\\nickname-popover.component.js", {"../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../hooks/useCopyToClipboard":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useCopyToClipboard.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../button":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\button\\index.js","../identicon":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\identicon\\index.js","../popover":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\popover\\index.js","../tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cnickname-popover%5Cnickname-popover.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRouterDom = require("react-router-dom");
var _i18n = require("../../../contexts/i18n");
var _tooltip = _interopRequireDefault(require("../tooltip"));
var _popover = _interopRequireDefault(require("../popover"));
var _button = _interopRequireDefault(require("../button"));
var _identicon = _interopRequireDefault(require("../identicon"));
var _util = require("../../../helpers/utils/util");
var _useCopyToClipboard = require("../../../hooks/useCopyToClipboard");
var _selectors = require("../../../selectors");
var _routes = require("../../../helpers/constants/routes");
var _componentLibrary = require("../../component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NicknamePopover = ({
  address,
  nickname,
  onClose = null,
  onAdd = null,
  explorerLink
}) => {
  var _tokenList$address$to;
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const history = (0, _reactRouterDom.useHistory)();
  const onAddClick = (0, _react.useCallback)(() => {
    onAdd();
  }, [onAdd]);
  const [copied, handleCopy] = (0, _useCopyToClipboard.useCopyToClipboard)();
  const tokenList = (0, _reactRedux.useSelector)(_selectors.getTokenList);
  const blockExplorerLinkText = (0, _reactRedux.useSelector)(_selectors.getBlockExplorerLinkText);
  const routeToAddBlockExplorerUrl = () => {
    history.push(`${_routes.NETWORKS_ROUTE}#blockExplorerUrl`);
  };
  const openBlockExplorer = () => {
    global.platform.openTab({
      url: explorerLink
    });
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "nickname-popover"
  }, /*#__PURE__*/_react.default.createElement(_popover.default, {
    onClose: onClose,
    className: "nickname-popover__popover-wrap"
  }, /*#__PURE__*/_react.default.createElement(_identicon.default, {
    address: address,
    diameter: 36,
    className: "nickname-popover__identicon",
    image: (_tokenList$address$to = tokenList[address.toLowerCase()]) === null || _tokenList$address$to === void 0 ? void 0 : _tokenList$address$to.iconUrl
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "nickname-popover__address"
  }, nickname || (0, _util.shortenAddress)(address)), /*#__PURE__*/_react.default.createElement("div", {
    className: "nickname-popover__public-address"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "nickname-popover__public-address__constant"
  }, address), /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    position: "bottom",
    title: copied ? t('copiedExclamation') : t('copyToClipboard')
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    iconName: copied ? _componentLibrary.IconName.CopySuccess : _componentLibrary.IconName.Copy,
    size: _componentLibrary.IconSize.Sm,
    onClick: () => handleCopy(address)
  }))), /*#__PURE__*/_react.default.createElement("div", {
    className: "nickname-popover__view-on-block-explorer"
  }, /*#__PURE__*/_react.default.createElement(_button.default, {
    type: "link",
    className: "nickname-popover__etherscan-link",
    onClick: blockExplorerLinkText.firstPart === 'addBlockExplorer' ? routeToAddBlockExplorerUrl : openBlockExplorer,
    target: "_blank",
    rel: "noopener noreferrer",
    title: blockExplorerLinkText.firstPart === 'addBlockExplorer' ? t('addBlockExplorer') : t('etherscanView')
  }, blockExplorerLinkText.firstPart === 'addBlockExplorer' ? t('addBlockExplorer') : t('viewOnBlockExplorer'))), /*#__PURE__*/_react.default.createElement(_button.default, {
    type: "primary",
    className: "nickname-popover__footer-button",
    onClick: onAddClick
  }, nickname ? t('editANickname') : t('addANickname'))));
};
NicknamePopover.propTypes = {
  address: _propTypes.default.string,
  nickname: _propTypes.default.string,
  onClose: _propTypes.default.func,
  onAdd: _propTypes.default.func,
  explorerLink: _propTypes.default.string
};
var _default = exports.default = NicknamePopover;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\nickname-popover\\nickname-popover.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\numeric-input\\numeric-input.component.js", {"../../../../shared/constants/tokens":"D:\\code\\v\\metamask-extension\\shared\\constants\\tokens.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cnumeric-input%5Cnumeric-input.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = NumericInput;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _designSystem = require("../../../helpers/constants/design-system");
var _tokens = require("../../../../shared/constants/tokens");
var _componentLibrary = require("../../component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function NumericInput({
  detailText = '',
  value = 0,
  onChange,
  error = '',
  autoFocus = false,
  allowDecimals = true,
  disabled = false,
  dataTestId,
  placeholder,
  id,
  name,
  inputRef
}) {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('numeric-input', {
      'numeric-input--error': error
    })
  }, /*#__PURE__*/_react.default.createElement("input", {
    type: "number",
    value: value,
    onKeyDown: e => {
      if (!allowDecimals && (e.key === '.' || e.key === ',')) {
        e.preventDefault();
      }
    },
    onChange: e => {
      var _match$;
      const newValue = e.target.value;
      const match = _tokens.DECIMAL_REGEX.exec(newValue);
      if ((match === null || match === void 0 || (_match$ = match[1]) === null || _match$ === void 0 ? void 0 : _match$.length) >= 15) {
        return;
      }
      onChange === null || onChange === void 0 || onChange(newValue);
    },
    min: "0",
    autoFocus: autoFocus,
    disabled: disabled,
    "data-testid": dataTestId,
    placeholder: placeholder,
    id: id,
    name: name,
    ref: inputRef
  }), detailText && /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textAlternative,
    variant: _designSystem.TextVariant.bodySm,
    as: "span"
  }, detailText));
}
NumericInput.propTypes = {
  value: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
  detailText: _propTypes.default.string,
  onChange: _propTypes.default.func,
  error: _propTypes.default.string,
  autoFocus: _propTypes.default.bool,
  allowDecimals: _propTypes.default.bool,
  disabled: _propTypes.default.bool,
  dataTestId: _propTypes.default.string,
  placeholder: _propTypes.default.string,
  /**
   * The name of the input
   */
  name: _propTypes.default.string,
  /**
   * The id of the input element. Should be used with htmlFor with a label element.
   */
  id: _propTypes.default.string,
  inputRef: _propTypes.default.object
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\numeric-input\\numeric-input.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\origin-pill\\origin-pill.tsx", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Corigin-pill%5Corigin-pill.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = OriginPill;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _designSystem = require("../../../helpers/constants/design-system");
var _selectors = require("../../../selectors");
var _componentLibrary = require("../../component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function OriginPill({
  origin,
  dataTestId,
  style,
  textStyle
}) {
  const subjectMetadata = (0, _reactRedux.useSelector)(_selectors.getSubjectMetadata);
  const {
    iconUrl: siteImage = ''
  } = subjectMetadata[origin] || {};
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    marginTop: 6,
    marginRight: 4,
    marginLeft: 4,
    padding: 2,
    borderColor: _designSystem.BorderColor.borderMuted,
    borderStyle: _designSystem.BorderStyle.solid,
    borderRadius: _designSystem.BorderRadius.pill,
    borderWidth: 1,
    "data-testid": dataTestId,
    style: style
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.AvatarFavicon, {
    src: siteImage,
    name: origin,
    "data-testid": `${dataTestId}-avatar-favicon`
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm,
    as: "h6",
    color: _designSystem.TextColor.textAlternative,
    marginLeft: 1,
    "data-testid": `${dataTestId}-text`,
    style: textStyle,
    className: "origin-pill-text"
  }, origin));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\origin-pill\\origin-pill.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\page-container\\index.js", {"./page-container-footer":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\page-container\\page-container-footer\\index.js","./page-container-header":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\page-container\\page-container-header\\index.js","./page-container.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\page-container\\page-container.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cpage-container%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "PageContainerFooter", {
  enumerable: true,
  get: function () {
    return _pageContainerFooter.default;
  }
});
Object.defineProperty(exports, "PageContainerHeader", {
  enumerable: true,
  get: function () {
    return _pageContainerHeader.default;
  }
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _pageContainer.default;
  }
});
var _pageContainerHeader = _interopRequireDefault(require("./page-container-header"));
var _pageContainerFooter = _interopRequireDefault(require("./page-container-footer"));
var _pageContainer = _interopRequireDefault(require("./page-container.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\page-container\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\page-container\\page-container-footer\\index.js", {"./page-container-footer.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\page-container\\page-container-footer\\page-container-footer.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cpage-container%5Cpage-container-footer%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _pageContainerFooter.default;
  }
});
var _pageContainerFooter = _interopRequireDefault(require("./page-container-footer.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\page-container\\page-container-footer\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\page-container\\page-container-footer\\page-container-footer.component.js", {"../../../component-library/button":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\button\\index.ts","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cpage-container%5Cpage-container-footer%5Cpage-container-footer.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _button = require("../../../component-library/button");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class PageContainerFooter extends _react.Component {
  render() {
    const {
      children,
      onCancel,
      cancelText,
      onSubmit,
      submitText,
      disabled,
      submitButtonType,
      hideCancel,
      cancelButtonType,
      footerClassName,
      footerButtonClassName,
      submitButtonIcon
    } = this.props;
    const submitVariant = submitButtonType === 'confirm' ? _button.ButtonVariant.Primary : submitButtonType;
    const cancelVariant = cancelButtonType === 'default' ? _button.ButtonVariant.Secondary : cancelButtonType;
    return /*#__PURE__*/_react.default.createElement("div", {
      className: (0, _classnames.default)('page-container__footer', footerClassName)
    }, /*#__PURE__*/_react.default.createElement("footer", null, !hideCancel && /*#__PURE__*/_react.default.createElement(_button.Button, {
      size: _button.ButtonSize.Lg,
      variant: cancelVariant ?? _button.ButtonVariant.Secondary,
      className: (0, _classnames.default)('page-container__footer-button', 'page-container__footer-button__cancel', footerButtonClassName),
      onClick: e => onCancel(e),
      "data-testid": "page-container-footer-cancel",
      block: true
    }, cancelText || this.context.t('cancel')), /*#__PURE__*/_react.default.createElement(_button.Button, {
      size: _button.ButtonSize.Lg,
      variant: submitVariant ?? _button.ButtonVariant.Primary,
      className: (0, _classnames.default)('page-container__footer-button', footerButtonClassName),
      disabled: disabled,
      onClick: e => onSubmit(e),
      "data-testid": "page-container-footer-next",
      startIconName: submitButtonIcon,
      block: true
    }, submitText || this.context.t('next'))), children && /*#__PURE__*/_react.default.createElement("div", {
      className: "page-container__footer-secondary"
    }, children));
  }
}
exports.default = PageContainerFooter;
_defineProperty(PageContainerFooter, "propTypes", {
  children: _propTypes.default.node,
  onCancel: _propTypes.default.func,
  cancelText: _propTypes.default.string,
  cancelButtonType: _propTypes.default.string,
  onSubmit: _propTypes.default.func,
  submitText: _propTypes.default.string,
  disabled: _propTypes.default.bool,
  submitButtonType: _propTypes.default.string,
  hideCancel: _propTypes.default.bool,
  footerClassName: _propTypes.default.string,
  footerButtonClassName: _propTypes.default.string,
  submitButtonIcon: _propTypes.default.string
});
_defineProperty(PageContainerFooter, "contextTypes", {
  t: _propTypes.default.func
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\page-container\\page-container-footer\\page-container-footer.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\page-container\\page-container-header\\index.js", {"./page-container-header.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\page-container\\page-container-header\\page-container-header.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cpage-container%5Cpage-container-header%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _pageContainerHeader.default;
  }
});
var _pageContainerHeader = _interopRequireDefault(require("./page-container-header.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\page-container\\page-container-header\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\page-container\\page-container-header\\page-container-header.component.js", {"../../button":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\button\\index.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cpage-container%5Cpage-container-header%5Cpage-container-header.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _button = _interopRequireDefault(require("../../button"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class PageContainerHeader extends _react.Component {
  renderTabs() {
    const {
      tabs
    } = this.props;
    return tabs ? /*#__PURE__*/_react.default.createElement("ul", {
      className: "page-container__tabs"
    }, tabs) : null;
  }
  renderCloseAction() {
    const {
      hideClose,
      onClose,
      headerCloseText
    } = this.props;
    if (hideClose) {
      return null;
    }
    if (headerCloseText) {
      return onClose && /*#__PURE__*/_react.default.createElement(_button.default, {
        type: "link",
        className: "page-container__header-close-text",
        onClick: () => onClose()
      }, headerCloseText);
    }
    return onClose && /*#__PURE__*/_react.default.createElement("button", {
      className: "page-container__header-close",
      onClick: () => onClose(),
      "aria-label": "close"
    });
  }
  renderHeaderRow() {
    const {
      showBackButton,
      onBackButtonClick,
      backButtonStyles,
      backButtonString
    } = this.props;
    return showBackButton && /*#__PURE__*/_react.default.createElement("div", {
      className: "page-container__header-row"
    }, /*#__PURE__*/_react.default.createElement("span", {
      className: "page-container__back-button",
      onClick: onBackButtonClick,
      style: backButtonStyles
    }, backButtonString || 'Back'));
  }
  render() {
    const {
      title,
      subtitle,
      tabs,
      className,
      hideClose
    } = this.props;
    return /*#__PURE__*/_react.default.createElement("div", {
      className: (0, _classnames.default)('page-container__header', className, {
        'page-container__header--no-padding-bottom': Boolean(tabs)
      }),
      "data-testid": "page-container__header"
    }, this.renderHeaderRow(), title && /*#__PURE__*/_react.default.createElement("div", {
      className: (0, _classnames.default)('page-container__title', {
        'page-container__title--no-margin-right': hideClose
      })
    }, title), subtitle ? /*#__PURE__*/_react.default.createElement("div", {
      className: "page-container__subtitle"
    }, subtitle) : null, this.renderCloseAction(), this.renderTabs());
  }
}
exports.default = PageContainerHeader;
_defineProperty(PageContainerHeader, "propTypes", {
  title: _propTypes.default.string,
  subtitle: _propTypes.default.string,
  onClose: _propTypes.default.func,
  showBackButton: _propTypes.default.bool,
  onBackButtonClick: _propTypes.default.func,
  backButtonStyles: _propTypes.default.object,
  backButtonString: _propTypes.default.string,
  tabs: _propTypes.default.node,
  headerCloseText: _propTypes.default.string,
  className: _propTypes.default.string,
  hideClose: _propTypes.default.bool
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\page-container\\page-container-header\\page-container-header.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\page-container\\page-container.component.js", {"./page-container-footer":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\page-container\\page-container-footer\\index.js","./page-container-header":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\page-container\\page-container-header\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cpage-container%5Cpage-container.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _pageContainerHeader = _interopRequireDefault(require("./page-container-header"));
var _pageContainerFooter = _interopRequireDefault(require("./page-container-footer"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class PageContainer extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "state", {
      activeTabIndex: this.props.defaultActiveTabIndex || 0
    });
  }
  handleTabClick(activeTabIndex) {
    this.setState({
      activeTabIndex
    });
  }
  renderTabs() {
    const {
      tabsComponent
    } = this.props;
    if (!tabsComponent) {
      return null;
    }
    const numberOfTabs = _react.default.Children.count(tabsComponent.props.children);
    return _react.default.Children.map(tabsComponent.props.children, (child, tabIndex) => {
      return child && /*#__PURE__*/_react.default.cloneElement(child, {
        onClick: index => this.handleTabClick(index),
        tabIndex,
        isActive: numberOfTabs > 1 && tabIndex === this.state.activeTabIndex,
        key: tabIndex,
        className: 'page-container__tab'
      });
    });
  }
  renderActiveTabContent() {
    const {
      tabsComponent
    } = this.props;
    let {
      children
    } = tabsComponent.props;
    children = children.filter(Boolean);
    const {
      activeTabIndex
    } = this.state;
    return (children[activeTabIndex] || children[0]).props.children;
  }
  renderContent() {
    const {
      contentComponent,
      tabsComponent
    } = this.props;
    if (contentComponent) {
      return contentComponent;
    } else if (tabsComponent) {
      return this.renderActiveTabContent();
    }
    return null;
  }
  render() {
    const {
      title,
      subtitle,
      onClose,
      showBackButton,
      onBackButtonClick,
      backButtonStyles,
      backButtonString,
      onCancel,
      cancelText,
      onSubmit,
      submitText,
      disabled,
      headerCloseText,
      hideCancel
    } = this.props;
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "page-container"
    }, /*#__PURE__*/_react.default.createElement(_pageContainerHeader.default, {
      title: title,
      subtitle: subtitle,
      onClose: onClose,
      showBackButton: showBackButton,
      onBackButtonClick: onBackButtonClick,
      backButtonStyles: backButtonStyles,
      backButtonString: backButtonString,
      tabs: this.renderTabs(),
      headerCloseText: headerCloseText
    }), /*#__PURE__*/_react.default.createElement("div", {
      className: "page-container__bottom"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "page-container__content"
    }, this.renderContent()), /*#__PURE__*/_react.default.createElement(_pageContainerFooter.default, {
      onCancel: onCancel,
      cancelText: cancelText,
      hideCancel: hideCancel,
      onSubmit: onSubmit,
      submitText: submitText,
      disabled: disabled
    })));
  }
}
exports.default = PageContainer;
_defineProperty(PageContainer, "contextTypes", {
  t: _propTypes.default.func
});
_defineProperty(PageContainer, "propTypes", {
  // PageContainerHeader props
  backButtonString: _propTypes.default.string,
  backButtonStyles: _propTypes.default.object,
  headerCloseText: _propTypes.default.string,
  onBackButtonClick: _propTypes.default.func,
  onClose: _propTypes.default.func,
  showBackButton: _propTypes.default.bool,
  subtitle: _propTypes.default.string,
  title: _propTypes.default.string.isRequired,
  // Tabs-related props
  defaultActiveTabIndex: _propTypes.default.number,
  tabsComponent: _propTypes.default.node,
  // Content props
  contentComponent: _propTypes.default.node,
  // PageContainerFooter props
  cancelText: _propTypes.default.string,
  disabled: _propTypes.default.bool,
  hideCancel: _propTypes.default.bool,
  onCancel: _propTypes.default.func,
  onSubmit: _propTypes.default.func,
  submitText: _propTypes.default.string
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\page-container\\page-container.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\popover\\index.js", {"./popover.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\popover\\popover.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cpopover%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _popover.default;
  }
});
var _popover = _interopRequireDefault(require("./popover.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\popover\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\popover\\popover.component.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../box":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\box\\index.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cpopover%5Cpopover.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _useI18nContext = require("../../../hooks/useI18nContext");
var _box = _interopRequireDefault(require("../box"));
var _designSystem = require("../../../helpers/constants/design-system");
var _componentLibrary = require("../../component-library");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const defaultHeaderProps = {
  padding: [6, 4, 4],
  display: 'flex',
  flexDirection: _designSystem.FLEX_DIRECTION.COLUMN,
  backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
  borderRadius: 'xl'
};
const defaultContentProps = {
  display: 'flex',
  flexDirection: _designSystem.FLEX_DIRECTION.COLUMN,
  justifyContent: _designSystem.JustifyContent.flexStart,
  alignItems: _designSystem.AlignItems.stretch,
  borderRadius: 'xl'
};
const defaultFooterProps = {
  display: 'flex',
  justifyContent: _designSystem.JustifyContent.spaceBetween,
  padding: [4, 6, 6]
};

/**
 * @deprecated The `<Popover>` component has been deprecated in favor of the new `<Modal>` component from the component-library.
 * Please update your code to use the new `<Modal>` component instead, which can be found at ui/components/component-library/modal/modal.tsx.
 * You can find documentation for the new Modal component in the MetaMask Storybook:
 * {@link https://metamask.github.io/metamask-storybook/?path=/docs/components-componentlibrary-modal--docs}
 * If you would like to help with the replacement of the old Modal component, please submit a pull request against this GitHub issue:
 * {@link https://github.com/MetaMask/metamask-extension/issues/19555}
 */

const Popover = ({
  title,
  subtitle = '',
  children,
  footer,
  footerClassName,
  onBack,
  onClose,
  onScroll,
  className,
  contentClassName,
  showArrow,
  CustomBackground,
  popoverRef,
  showScrollDown,
  onScrollDownButtonClick,
  centerTitle,
  wrapTitle,
  headerProps = defaultHeaderProps,
  contentProps = defaultContentProps,
  footerProps = defaultFooterProps
}) => {
  const t = (0, _useI18nContext.useI18nContext)();
  const showHeader = title || onBack || subtitle || onClose;
  const Header = () => /*#__PURE__*/_react.default.createElement(_box.default, _extends({}, defaultHeaderProps, headerProps, {
    className: "popover-header"
  }), /*#__PURE__*/_react.default.createElement(_box.default, {
    display: _designSystem.DISPLAY.FLEX,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: centerTitle ? null : _designSystem.JustifyContent.spaceBetween,
    className: (0, _classnames.default)('popover-header__title', {
      'popover-header__title--center': centerTitle
    }),
    marginBottom: 2
  }, onBack && /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    iconName: _componentLibrary.IconName.ArrowLeft,
    ariaLabel: t('back'),
    onClick: onBack,
    color: _designSystem.Color.iconDefault,
    size: _designSystem.Size.SM
  }), !onBack && centerTitle && /*#__PURE__*/_react.default.createElement("div", {
    className: "size-6"
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    textAlign: centerTitle ? _designSystem.TextAlign.Center : _designSystem.TextAlign.Start,
    className: (0, _classnames.default)('flex-1', {
      'popover-header__title-wrap': wrapTitle
    }),
    ellipsis: true,
    variant: _designSystem.TextVariant.headingSm,
    as: "h2",
    width: _designSystem.BLOCK_SIZES.FULL
  }, title), onClose ? /*#__PURE__*/_react.default.createElement(_componentLibrary.ButtonIcon, {
    iconName: _componentLibrary.IconName.Close,
    ariaLabel: t('close'),
    "data-testid": "popover-close",
    onClick: onClose,
    size: _designSystem.Size.SM
  }) : /*#__PURE__*/_react.default.createElement("div", {
    className: "size-6"
  })), subtitle ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodySm
  }, subtitle) : null);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "popover-container"
  }, CustomBackground ? /*#__PURE__*/_react.default.createElement(CustomBackground, {
    onClose: onClose
  }) : /*#__PURE__*/_react.default.createElement("div", {
    className: "popover-bg",
    onClick: onClose
  }), /*#__PURE__*/_react.default.createElement("section", {
    className: (0, _classnames.default)('popover-wrap', className),
    ref: popoverRef
  }, showArrow ? /*#__PURE__*/_react.default.createElement("div", {
    className: "popover-arrow"
  }) : null, showHeader && /*#__PURE__*/_react.default.createElement(Header, null), children ? /*#__PURE__*/_react.default.createElement(_box.default, _extends({
    className: (0, _classnames.default)('popover-content', contentClassName),
    onScroll: onScroll
  }, defaultContentProps, contentProps), children) : null, showScrollDown ? /*#__PURE__*/_react.default.createElement(_box.default, {
    display: _designSystem.DISPLAY.FLEX,
    alignItems: _designSystem.AlignItems.center,
    justifyContent: _designSystem.JustifyContent.center,
    borderColor: _designSystem.BorderColor.borderDefault,
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    color: _designSystem.Color.iconDefault,
    onClick: onScrollDownButtonClick,
    className: "popover-scroll-button",
    style: {
      bottom: footer ? '140px' : '12px'
    },
    "data-testid": "popover-scroll-button"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.ArrowDown,
    color: _designSystem.IconColor.primaryDefault,
    size: _componentLibrary.IconSize.Md,
    "aria-label": t('scrollDown')
  })) : null, footer ? /*#__PURE__*/_react.default.createElement(_box.default, _extends({
    className: (0, _classnames.default)('popover-footer', footerClassName)
  }, defaultFooterProps, footerProps), footer) : null));
};
Popover.propTypes = {
  /**
   * Avoid wrapping title
   */
  wrapTitle: _propTypes.default.bool,
  /**
   * Show title of the popover
   */
  title: _propTypes.default.node,
  /**
   * Show subtitle label on popover
   */
  subtitle: _propTypes.default.string,
  /**
   * Show children content could be react child or text
   */
  children: _propTypes.default.node,
  /**
   * Show footer content could be react child or text
   */
  footer: _propTypes.default.node,
  /**
   * Add custom CSS class for footer
   */
  footerClassName: _propTypes.default.string,
  /**
   * onBack handler
   */
  onBack: _propTypes.default.func,
  /**
   * onClose handler
   */
  onClose: _propTypes.default.func,
  /**
   * onScroll handler
   */
  onScroll: _propTypes.default.func,
  CustomBackground: _propTypes.default.func,
  /**
   * Add custom CSS class for content
   */
  contentClassName: _propTypes.default.string,
  /**
   * Add custom CSS class
   */
  className: _propTypes.default.string,
  /**
   * Check if component would show arror
   */
  showArrow: _propTypes.default.bool,
  /**
   * The ref of the popover-wrap element
   */
  popoverRef: _propTypes.default.shape({
    current: _propTypes.default.instanceOf(window.Element)
  }),
  /**
   * Show title of the popover
   */
  showScrollDown: _propTypes.default.bool,
  /**
   * ScrollDown handler
   */
  onScrollDownButtonClick: _propTypes.default.func,
  /**
   * Check if use centered title
   */
  centerTitle: _propTypes.default.bool,
  /**
   * Box props for the header
   */
  headerProps: _propTypes.default.shape({
    ..._box.default.propTypes
  }),
  /**
   * Box props for the content
   */
  contentProps: _propTypes.default.shape({
    ..._box.default.propTypes
  }),
  /**
   * Box props for the footer
   */
  footerProps: _propTypes.default.shape({
    ..._box.default.propTypes
  })
};

/**
 * @deprecated The `<Popover>` component has been deprecated in favor of the new `<Modal>` component from the component-library.
 * Please update your code to use the new `<Modal>` component instead, which can be found at ui/components/component-library/modal/modal.tsx.
 * You can find documentation for the new Modal component in the MetaMask Storybook:
 * {@link https://metamask.github.io/metamask-storybook/?path=/docs/components-componentlibrary-modal--docs}
 * If you would like to help with the replacement of the old Modal component, please submit a pull request against this GitHub issue:
 * {@link https://github.com/MetaMask/metamask-extension/issues/19555}
 */
class PopoverPortal extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "rootNode", document.getElementById('popover-content'));
    _defineProperty(this, "instanceNode", document.createElement('div'));
  }
  componentDidMount() {
    if (!this.rootNode) {
      return;
    }
    this.rootNode.appendChild(this.instanceNode);
  }
  componentWillUnmount() {
    if (!this.rootNode) {
      return;
    }
    this.rootNode.removeChild(this.instanceNode);
  }
  render() {
    const children = /*#__PURE__*/_react.default.createElement(Popover, this.props);
    return this.rootNode ? /*#__PURE__*/_reactDom.default.createPortal(children, this.instanceNode) : children;
  }
}
exports.default = PopoverPortal;
_defineProperty(PopoverPortal, "propTypes", Popover.propTypes);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\popover\\popover.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\pulse-loader\\index.js", {"./pulse-loader":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\pulse-loader\\pulse-loader.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cpulse-loader%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _pulseLoader.default;
  }
});
var _pulseLoader = _interopRequireDefault(require("./pulse-loader"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\pulse-loader\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\pulse-loader\\pulse-loader.js", {"react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cpulse-loader%5Cpulse-loader.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = PulseLoader;
var _react = _interopRequireDefault(require("react"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function PulseLoader() {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "pulse-loader",
    "data-testid": "pulse-loader"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "pulse-loader__loading-dot-one"
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "pulse-loader__loading-dot-two"
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "pulse-loader__loading-dot-three"
  }));
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\pulse-loader\\pulse-loader.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\qr-code-view\\index.js", {"./qr-code-view":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\qr-code-view\\qr-code-view.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cqr-code-view%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _qrCodeView.default;
  }
});
var _qrCodeView = _interopRequireDefault(require("./qr-code-view"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\qr-code-view\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\qr-code-view\\qr-code-view.tsx", {"../../../../app/scripts/lib/multichain/address":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\multichain\\address.ts","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/time":"D:\\code\\v\\metamask-extension\\shared\\constants\\time.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useCopyToClipboard":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useCopyToClipboard.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","ethereumjs-util":"D:\\code\\v\\metamask-extension\\node_modules\\ethereumjs-util\\dist.browser\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","qrcode-generator":"D:\\code\\v\\metamask-extension\\node_modules\\qrcode-generator\\qrcode.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cqr-code-view%5Cqr-code-view.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _qrcodeGenerator = _interopRequireDefault(require("qrcode-generator"));
var _reactRedux = require("react-redux");
var _ethereumjsUtil = require("ethereumjs-util");
var _address = require("../../../../app/scripts/lib/multichain/address");
var _componentLibrary = require("../../component-library");
var _metametrics = require("../../../contexts/metametrics");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _time = require("../../../../shared/constants/time");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _useCopyToClipboard = require("../../../hooks/useCopyToClipboard");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

function mapStateToProps(state) {
  const {
    buyView,
    warning
  } = state.appState;
  return {
    buyView,
    warning
  };
}
const PREFIX_LEN = 6;
const SUFFIX_LEN = 5;
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function QrCodeView({
  Qr,
  warning,
  accountName,
  location = 'Account Details Modal'
}) {
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const [copied, handleCopy] = (0, _useCopyToClipboard.useCopyToClipboard)(_time.MINUTE);
  const t = (0, _useI18nContext.useI18nContext)();
  const {
    message,
    data
  } = Qr;
  const checksummedAddress = (0, _address.normalizeSafeAddress)(data);
  const address = `${(0, _ethereumjsUtil.isHexPrefixed)(data) ? 'ethereum:' : ''}${checksummedAddress}`;
  const qrImage = (0, _qrcodeGenerator.default)(4, 'M');
  qrImage.addData(address);
  qrImage.make();
  const header = message ? /*#__PURE__*/_react.default.createElement("div", {
    className: "qr-code__header"
  }, message) : null;
  const addressStart = data.substring(0, PREFIX_LEN);
  const addressMiddle = data.substring(PREFIX_LEN, data.length - SUFFIX_LEN);
  const addressEnd = data.substring(data.length - SUFFIX_LEN);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "qr-code"
  }, Array.isArray(message) ? /*#__PURE__*/_react.default.createElement("div", {
    className: "qr-code__message-container"
  }, message.map((msg, index) => /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    key: index,
    variant: _designSystem.TextVariant.bodyXs,
    color: _designSystem.TextColor.warningDefault
  }, msg))) : header, warning ? /*#__PURE__*/_react.default.createElement("span", {
    className: "qr-code__error"
  }, warning) : null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "qr-code__wrapper",
    marginBottom: 4
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    "data-testid": "qr-code-image",
    className: "qr-code__image",
    dangerouslySetInnerHTML: {
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      __html: qrImage.createTableTag(5, 16)
    }
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    className: "qr-code__logo"
  }, /*#__PURE__*/_react.default.createElement("img", {
    src: "images/logo/metamask-fox.svg",
    alt: "Logo"
  }))), accountName ? /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyLgMedium,
    textAlign: _designSystem.TextAlign.Center,
    marginBottom: 4
  }, accountName) : null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    className: "qr-code__address-segments",
    marginBottom: 4
  }, addressStart, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMd,
    color: _designSystem.TextColor.textMuted,
    className: "qr-code__address-inner-segment"
  }, addressMiddle), addressEnd), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    marginBottom: 4,
    gap: 2,
    alignItems: _designSystem.AlignItems.center,
    color: _designSystem.TextColor.primaryDefault,
    className: "qr-code__copy-button",
    "data-testid": "address-copy-button-text",
    "data-clipboard-text": checksummedAddress,
    onClick: () => {
      handleCopy(checksummedAddress);
      trackEvent({
        category: _metametrics2.MetaMetricsEventCategory.Accounts,
        event: _metametrics2.MetaMetricsEventName.PublicAddressCopied,
        properties: {
          location
        }
      });
    }
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: copied ? _componentLibrary.IconName.CopySuccess : _componentLibrary.IconName.Copy,
    size: _componentLibrary.IconSize.Sm,
    color: _designSystem.IconColor.primaryDefault
  }), t('copyAddressShort')));
}
QrCodeView.propTypes = {
  warning: _propTypes.default.node,
  Qr: _propTypes.default.shape({
    message: _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.node), _propTypes.default.node]),
    data: _propTypes.default.string.isRequired
  }).isRequired,
  location: _propTypes.default.string
};
var _default = exports.default = (0, _reactRedux.connect)(mapStateToProps)(QrCodeView);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\qr-code-view\\qr-code-view.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\sender-to-recipient\\index.js", {"./sender-to-recipient.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\sender-to-recipient\\sender-to-recipient.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Csender-to-recipient%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _senderToRecipient.default;
  }
});
var _senderToRecipient = _interopRequireDefault(require("./sender-to-recipient.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\sender-to-recipient\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\sender-to-recipient\\sender-to-recipient.component.js", {"../../../../shared/constants/copy":"D:\\code\\v\\metamask-extension\\shared\\constants\\copy.ts","../../../../shared/modules/hexstring-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\hexstring-utils.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../app/name/name":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\name\\name.tsx","../../app/preferred-avatar":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\preferred-avatar\\index.ts","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../account-mismatch-warning/account-mismatch-warning.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\account-mismatch-warning\\account-mismatch-warning.component.js","../tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\index.js","./sender-to-recipient.constants":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\sender-to-recipient\\sender-to-recipient.constants.js","@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","@metamask/name-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\name-controller\\dist\\index.cjs","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","copy-to-clipboard":"D:\\code\\v\\metamask-extension\\node_modules\\copy-to-clipboard\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Csender-to-recipient%5Csender-to-recipient.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RecipientWithAddress = RecipientWithAddress;
exports.default = SenderToRecipient;
var _nameController = require("@metamask/name-controller");
var _classnames = _interopRequireDefault(require("classnames"));
var _copyToClipboard = _interopRequireDefault(require("copy-to-clipboard"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _designSystemReact = require("@metamask/design-system-react");
var _copy = require("../../../../shared/constants/copy");
var _hexstringUtils = require("../../../../shared/modules/hexstring-utils");
var _util = require("../../../helpers/utils/util");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _name = _interopRequireDefault(require("../../app/name/name"));
var _componentLibrary = require("../../component-library");
var _accountMismatchWarning = _interopRequireDefault(require("../account-mismatch-warning/account-mismatch-warning.component"));
var _preferredAvatar = require("../../app/preferred-avatar");
var _tooltip = _interopRequireDefault(require("../tooltip"));
var _senderToRecipient = require("./sender-to-recipient.constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const variantHash = {
  [_senderToRecipient.DEFAULT_VARIANT]: 'sender-to-recipient--default',
  [_senderToRecipient.CARDS_VARIANT]: 'sender-to-recipient--cards',
  [_senderToRecipient.FLAT_VARIANT]: 'sender-to-recipient--flat'
};
function SenderAddress({
  addressOnly,
  checksummedSenderAddress,
  senderName,
  onSenderClick,
  senderAddress,
  warnUserOnAccountMismatch
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  const [addressCopied, setAddressCopied] = (0, _react.useState)(false);
  let tooltipHtml = /*#__PURE__*/_react.default.createElement("p", null, t('copiedExclamation'));
  if (!addressCopied) {
    tooltipHtml = addressOnly ? /*#__PURE__*/_react.default.createElement("p", null, t('copyAddress')) : /*#__PURE__*/_react.default.createElement("p", null, (0, _util.shortenAddress)(checksummedSenderAddress), /*#__PURE__*/_react.default.createElement("br", null), t('copyAddress'));
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "sender-to-recipient__party sender-to-recipient__party--sender gap-1",
    onClick: () => {
      setAddressCopied(true);
      (0, _copyToClipboard.default)(checksummedSenderAddress, _copy.COPY_OPTIONS);
      if (onSenderClick) {
        onSenderClick();
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_preferredAvatar.PreferredAvatar, {
    address: (0, _hexstringUtils.toChecksumHexAddress)(senderAddress),
    size: _designSystemReact.AvatarAccountSize.Sm
  }), /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    position: "bottom",
    html: tooltipHtml,
    wrapperClassName: "sender-to-recipient__tooltip-wrapper",
    containerClassName: "sender-to-recipient__tooltip-container",
    onHidden: () => setAddressCopied(false)
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "sender-to-recipient__name text-s-body-xs"
  }, addressOnly ? /*#__PURE__*/_react.default.createElement("span", null, `${senderName || (0, _util.shortenAddress)(checksummedSenderAddress)}`) : senderName)), warnUserOnAccountMismatch && /*#__PURE__*/_react.default.createElement(_accountMismatchWarning.default, {
    address: senderAddress
  }));
}
SenderAddress.propTypes = {
  senderName: _propTypes.default.string,
  checksummedSenderAddress: _propTypes.default.string,
  addressOnly: _propTypes.default.bool,
  senderAddress: _propTypes.default.string,
  onSenderClick: _propTypes.default.func,
  warnUserOnAccountMismatch: _propTypes.default.bool
};
function RecipientWithAddress({
  checksummedRecipientAddress,
  onRecipientClick,
  addressOnly,
  recipientName,
  recipientIsOwnedAccount,
  chainId,
  className = ''
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  const [addressCopied, setAddressCopied] = (0, _react.useState)(false);
  let tooltipHtml = /*#__PURE__*/_react.default.createElement("p", null, t('copiedExclamation'));
  if (!addressCopied) {
    tooltipHtml = addressOnly ? /*#__PURE__*/_react.default.createElement("p", null, t('copyAddress')) : /*#__PURE__*/_react.default.createElement("p", null, (0, _util.shortenAddress)(checksummedRecipientAddress), /*#__PURE__*/_react.default.createElement("br", null), t('copyAddress'));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('sender-to-recipient__party sender-to-recipient__party--recipient sender-to-recipient__party--recipient-with-address', className),
    onClick: () => {
      if (recipientIsOwnedAccount) {
        setAddressCopied(true);
        (0, _copyToClipboard.default)(checksummedRecipientAddress, _copy.COPY_OPTIONS);
      } else if (onRecipientClick) {
        onRecipientClick();
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    position: "bottom",
    disabled: !recipientName,
    html: tooltipHtml,
    wrapperClassName: "sender-to-recipient__tooltip-wrapper",
    containerClassName: "sender-to-recipient__tooltip-container",
    onHidden: () => setAddressCopied(false)
  }, /*#__PURE__*/_react.default.createElement(_name.default, {
    value: checksummedRecipientAddress,
    type: _nameController.NameType.ETHEREUM_ADDRESS,
    variation: chainId,
    variant: _designSystemReact.TextVariant.BodyXs
  }))));
}
RecipientWithAddress.propTypes = {
  checksummedRecipientAddress: _propTypes.default.string,
  recipientName: _propTypes.default.string,
  addressOnly: _propTypes.default.bool,
  onRecipientClick: _propTypes.default.func,
  recipientIsOwnedAccount: _propTypes.default.bool,
  chainId: _propTypes.default.string,
  className: _propTypes.default.string
};
function Arrow({
  variant
}) {
  return variant === _senderToRecipient.DEFAULT_VARIANT ? /*#__PURE__*/_react.default.createElement("div", {
    className: "sender-to-recipient__arrow-container"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "sender-to-recipient__arrow-circle"
  }, /*#__PURE__*/_react.default.createElement("i", {
    className: "fa fa-arrow-right sender-to-recipient__arrow-circle__icon"
  }))) : /*#__PURE__*/_react.default.createElement("div", {
    className: "sender-to-recipient__arrow-container"
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
    name: _componentLibrary.IconName.ArrowRight
  }));
}
Arrow.propTypes = {
  variant: _propTypes.default.oneOf([_senderToRecipient.DEFAULT_VARIANT, _senderToRecipient.CARDS_VARIANT, _senderToRecipient.FLAT_VARIANT])
};
function SenderToRecipient({
  senderAddress,
  addressOnly,
  senderName,
  recipientName,
  onRecipientClick,
  onSenderClick,
  recipientAddress,
  variant,
  warnUserOnAccountMismatch,
  recipientIsOwnedAccount,
  chainId
}) {
  const t = (0, _useI18nContext.useI18nContext)();
  const checksummedSenderAddress = (0, _hexstringUtils.toChecksumHexAddress)(senderAddress);
  const checksummedRecipientAddress = (0, _hexstringUtils.toChecksumHexAddress)(recipientAddress);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('sender-to-recipient', variantHash[variant]),
    "data-testid": "sender-to-recipient"
  }, /*#__PURE__*/_react.default.createElement(SenderAddress, {
    checksummedSenderAddress: checksummedSenderAddress,
    addressOnly: addressOnly,
    senderName: senderName,
    onSenderClick: onSenderClick,
    senderAddress: senderAddress,
    warnUserOnAccountMismatch: warnUserOnAccountMismatch
  }), /*#__PURE__*/_react.default.createElement(Arrow, {
    variant: variant
  }), recipientAddress ? /*#__PURE__*/_react.default.createElement(RecipientWithAddress, {
    className: "justify-end",
    checksummedRecipientAddress: checksummedRecipientAddress,
    onRecipientClick: onRecipientClick,
    addressOnly: addressOnly,
    recipientName: recipientName,
    recipientIsOwnedAccount: recipientIsOwnedAccount,
    chainId: chainId
  }) : /*#__PURE__*/_react.default.createElement("div", {
    className: "sender-to-recipient__party sender-to-recipient__party--recipient"
  }, /*#__PURE__*/_react.default.createElement("i", {
    className: "fa fa-file-text-o"
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "sender-to-recipient__name"
  }, t('newContract'))));
}
SenderToRecipient.defaultProps = {
  variant: _senderToRecipient.DEFAULT_VARIANT,
  warnUserOnAccountMismatch: true
};
SenderToRecipient.propTypes = {
  senderName: _propTypes.default.string,
  senderAddress: _propTypes.default.string,
  recipientName: _propTypes.default.string,
  recipientAddress: _propTypes.default.string,
  variant: _propTypes.default.oneOf([_senderToRecipient.DEFAULT_VARIANT, _senderToRecipient.CARDS_VARIANT, _senderToRecipient.FLAT_VARIANT]),
  addressOnly: _propTypes.default.bool,
  onRecipientClick: _propTypes.default.func,
  onSenderClick: _propTypes.default.func,
  warnUserOnAccountMismatch: _propTypes.default.bool,
  recipientIsOwnedAccount: _propTypes.default.bool,
  chainId: _propTypes.default.string
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\sender-to-recipient\\sender-to-recipient.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\sender-to-recipient\\sender-to-recipient.constants.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Csender-to-recipient%5Csender-to-recipient.constants.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FLAT_VARIANT = exports.DEFAULT_VARIANT = exports.CARDS_VARIANT = void 0;
// Component design variants
const DEFAULT_VARIANT = exports.DEFAULT_VARIANT = 'DEFAULT_VARIANT';
const CARDS_VARIANT = exports.CARDS_VARIANT = 'CARDS_VARIANT';
const FLAT_VARIANT = exports.FLAT_VARIANT = 'FLAT_VARIANT';

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\sender-to-recipient\\sender-to-recipient.constants.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\show-hide-toggle\\index.js", {"./show-hide-toggle":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\show-hide-toggle\\show-hide-toggle.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cshow-hide-toggle%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _showHideToggle.default;
  }
});
var _showHideToggle = _interopRequireDefault(require("./show-hide-toggle"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\show-hide-toggle\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\show-hide-toggle\\show-hide-toggle.js", {"../icon/icon-eye":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\icon\\icon-eye.js","../icon/icon-eye-slash":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\icon\\icon-eye-slash.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cshow-hide-toggle%5Cshow-hide-toggle.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _iconEye = _interopRequireDefault(require("../icon/icon-eye"));
var _iconEyeSlash = _interopRequireDefault(require("../icon/icon-eye-slash"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const ShowHideToggle = ({
  id,
  shown,
  onChange,
  ariaLabelHidden,
  ariaLabelShown,
  className,
  'data-testid': dataTestId,
  disabled,
  title
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('show-hide-toggle', className)
  }, /*#__PURE__*/_react.default.createElement("input", {
    className: "show-hide-toggle__input",
    id: id,
    type: "checkbox",
    checked: shown,
    onChange: onChange,
    "data-testid": dataTestId,
    disabled: disabled
  }), /*#__PURE__*/_react.default.createElement("label", {
    htmlFor: id,
    className: "show-hide-toggle__label",
    title: title
  }, shown ? /*#__PURE__*/_react.default.createElement(_iconEye.default, {
    ariaLabel: ariaLabelShown,
    className: "show-hide-toggle__icon"
  }) : /*#__PURE__*/_react.default.createElement(_iconEyeSlash.default, {
    ariaLabel: ariaLabelHidden,
    className: "show-hide-toggle__icon"
  })));
};
ShowHideToggle.propTypes = {
  /**
   * The id of the ShowHideToggle for htmlFor
   */
  id: _propTypes.default.string.isRequired,
  /**
   * If the ShowHideToggle is in the "shown" state or not
   */
  shown: _propTypes.default.bool.isRequired,
  /**
   * The onChange handler of the ShowHideToggle
   */
  onChange: _propTypes.default.func.isRequired,
  /**
   * The aria-label of the icon representing the "hidden" state
   */
  ariaLabelHidden: _propTypes.default.string.isRequired,
  /**
   * The aria-label of the icon representing the "shown" state
   */
  ariaLabelShown: _propTypes.default.string.isRequired,
  /**
   * An additional className to give the ShowHideToggle
   */
  className: _propTypes.default.string,
  /**
   * The data test id of the input
   */
  'data-testid': _propTypes.default.string,
  /**
   * Whether the input is disabled or not
   */
  disabled: _propTypes.default.bool,
  /**
   * The title for the toggle. This is shown in a tooltip on hover.
   */
  title: _propTypes.default.string
};
var _default = exports.default = ShowHideToggle;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\show-hide-toggle\\show-hide-toggle.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\site-origin\\index.js", {"./site-origin":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\site-origin\\site-origin.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Csite-origin%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _siteOrigin.default;
  }
});
var _siteOrigin = _interopRequireDefault(require("./site-origin"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\site-origin\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\site-origin\\site-origin.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../chip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\chip\\index.js","../icon-with-fallback":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\icon-with-fallback\\index.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Csite-origin%5Csite-origin.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = SiteOrigin;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _chip = _interopRequireDefault(require("../chip"));
var _iconWithFallback = _interopRequireDefault(require("../icon-with-fallback"));
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * @deprecated The `<SiteOrigin />` component has been deprecated in favor of the new `<TagUrl>` component from the component-library.
 * Please update your code to use the new `<TagUrl>` component instead, which can be found at ui/components/component-library/tag-url/tag-url.js.
 * You can find documentation for the new `TagUrl` component in the MetaMask Storybook:
 * {@link https://metamask.github.io/metamask-storybook/?path=/docs/components-componentlibrary-tagurl--docs}
 * If you would like to help with the replacement of the old `SiteOrigin` component, please submit a pull request against this GitHub issue:
 * {@link https://github.com/MetaMask/metamask-extension/issues/20489}
 */

function SiteOrigin({
  siteOrigin,
  iconSrc,
  iconName,
  chip,
  className,
  title,
  leftIcon,
  rightIcon
}) {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('site-origin', className),
    title: title
  }, chip ? /*#__PURE__*/_react.default.createElement(_chip.default, {
    borderColor: _designSystem.BorderColor.borderMuted,
    label: siteOrigin,
    maxContent: false,
    leftIcon: leftIcon || /*#__PURE__*/_react.default.createElement(_iconWithFallback.default, {
      icon: iconSrc,
      name: iconName,
      size: 24
    }),
    rightIcon: rightIcon
  }) : /*#__PURE__*/_react.default.createElement("bdi", {
    dir: "ltr"
  }, siteOrigin));
}
SiteOrigin.propTypes = {
  /**
   * The origin of the site generally the URL
   */
  siteOrigin: _propTypes.default.string.isRequired,
  /**
   * Icon name is used for the fallback icon and will display the first letter of the string
   * when iconSrc errors or is not provided.
   */
  iconName: _propTypes.default.string,
  /**
   * The image src of the icon
   */
  iconSrc: _propTypes.default.string,
  /**
   * Additional className added to the root html element
   */
  className: _propTypes.default.string,
  /**
   * title specifies extra information and is added to a title attribute added to the root html element
   * It is most often shown as a tooltip text when the mouse moves over the element.
   */
  title: _propTypes.default.string,
  /**
   * Whether the SiteOrigin is displayed as a chip or plain text.
   * if false iconSrc and iconName props will not be used.
   */
  chip: _propTypes.default.bool,
  /**
   * The icon to display on the left side of the chip. If not provided, the iconSrc and iconName will be used.
   */
  leftIcon: _propTypes.default.node,
  /**
   * The icon to display on the right side of the chip.
   */
  rightIcon: _propTypes.default.node
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\site-origin\\site-origin.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\spinner\\index.js", {"./spinner.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\spinner\\spinner.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cspinner%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _spinner = _interopRequireDefault(require("./spinner.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
var _default = exports.default = _spinner.default;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\spinner\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\spinner\\spinner.component.js", {"prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cspinner%5Cspinner.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const Spinner = ({
  className = '',
  color = 'var(--color-icon-muted)'
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: `spinner ${className}`
  }, /*#__PURE__*/_react.default.createElement("svg", {
    className: "lds-spinner",
    width: "100%",
    height: "100%",
    xmlns: "http://www.w3.org/2000/svg",
    xmlnsXlink: "http://www.w3.org/1999/xlink",
    viewBox: "0 0 100 100",
    preserveAspectRatio: "xMidYMid",
    style: {
      background: 'none'
    }
  }, /*#__PURE__*/_react.default.createElement("g", {
    transform: "rotate(0 50 50)"
  }, /*#__PURE__*/_react.default.createElement("rect", {
    x: 45,
    y: 0,
    rx: 0,
    ry: 0,
    width: 10,
    height: 30,
    fill: color
  }, /*#__PURE__*/_react.default.createElement("animate", {
    attributeName: "opacity",
    values: "1;0",
    dur: "1s",
    begin: "-0.9166666666666666s",
    repeatCount: "indefinite"
  }))), /*#__PURE__*/_react.default.createElement("g", {
    transform: "rotate(30 50 50)"
  }, /*#__PURE__*/_react.default.createElement("rect", {
    x: 45,
    y: 0,
    rx: 0,
    ry: 0,
    width: 10,
    height: 30,
    fill: color
  }, /*#__PURE__*/_react.default.createElement("animate", {
    attributeName: "opacity",
    values: "1;0",
    dur: "1s",
    begin: "-0.8333333333333334s",
    repeatCount: "indefinite"
  }))), /*#__PURE__*/_react.default.createElement("g", {
    transform: "rotate(60 50 50)"
  }, /*#__PURE__*/_react.default.createElement("rect", {
    x: 45,
    y: 0,
    rx: 0,
    ry: 0,
    width: 10,
    height: 30,
    fill: color
  }, /*#__PURE__*/_react.default.createElement("animate", {
    attributeName: "opacity",
    values: "1;0",
    dur: "1s",
    begin: "-0.75s",
    repeatCount: "indefinite"
  }))), /*#__PURE__*/_react.default.createElement("g", {
    transform: "rotate(90 50 50)"
  }, /*#__PURE__*/_react.default.createElement("rect", {
    x: 45,
    y: 0,
    rx: 0,
    ry: 0,
    width: 10,
    height: 30,
    fill: color
  }, /*#__PURE__*/_react.default.createElement("animate", {
    attributeName: "opacity",
    values: "1;0",
    dur: "1s",
    begin: "-0.6666666666666666s",
    repeatCount: "indefinite"
  }))), /*#__PURE__*/_react.default.createElement("g", {
    transform: "rotate(120 50 50)"
  }, /*#__PURE__*/_react.default.createElement("rect", {
    x: 45,
    y: 0,
    rx: 0,
    ry: 0,
    width: 10,
    height: 30,
    fill: color
  }, /*#__PURE__*/_react.default.createElement("animate", {
    attributeName: "opacity",
    values: "1;0",
    dur: "1s",
    begin: "-0.5833333333333334s",
    repeatCount: "indefinite"
  }))), /*#__PURE__*/_react.default.createElement("g", {
    transform: "rotate(150 50 50)"
  }, /*#__PURE__*/_react.default.createElement("rect", {
    x: 45,
    y: 0,
    rx: 0,
    ry: 0,
    width: 10,
    height: 30,
    fill: color
  }, /*#__PURE__*/_react.default.createElement("animate", {
    attributeName: "opacity",
    values: "1;0",
    dur: "1s",
    begin: "-0.5s",
    repeatCount: "indefinite"
  }))), /*#__PURE__*/_react.default.createElement("g", {
    transform: "rotate(180 50 50)"
  }, /*#__PURE__*/_react.default.createElement("rect", {
    x: 45,
    y: 0,
    rx: 0,
    ry: 0,
    width: 10,
    height: 30,
    fill: color
  }, /*#__PURE__*/_react.default.createElement("animate", {
    attributeName: "opacity",
    values: "1;0",
    dur: "1s",
    begin: "-0.4166666666666667s",
    repeatCount: "indefinite"
  }))), /*#__PURE__*/_react.default.createElement("g", {
    transform: "rotate(210 50 50)"
  }, /*#__PURE__*/_react.default.createElement("rect", {
    x: 45,
    y: 0,
    rx: 0,
    ry: 0,
    width: 10,
    height: 30,
    fill: color
  }, /*#__PURE__*/_react.default.createElement("animate", {
    attributeName: "opacity",
    values: "1;0",
    dur: "1s",
    begin: "-0.3333333333333333s",
    repeatCount: "indefinite"
  }))), /*#__PURE__*/_react.default.createElement("g", {
    transform: "rotate(240 50 50)"
  }, /*#__PURE__*/_react.default.createElement("rect", {
    x: 45,
    y: 0,
    rx: 0,
    ry: 0,
    width: 10,
    height: 30,
    fill: color
  }, /*#__PURE__*/_react.default.createElement("animate", {
    attributeName: "opacity",
    values: "1;0",
    dur: "1s",
    begin: "-0.25s",
    repeatCount: "indefinite"
  }))), /*#__PURE__*/_react.default.createElement("g", {
    transform: "rotate(270 50 50)"
  }, /*#__PURE__*/_react.default.createElement("rect", {
    x: 45,
    y: 0,
    rx: 0,
    ry: 0,
    width: 10,
    height: 30,
    fill: color
  }, /*#__PURE__*/_react.default.createElement("animate", {
    attributeName: "opacity",
    values: "1;0",
    dur: "1s",
    begin: "-0.16666666666666666s",
    repeatCount: "indefinite"
  }))), /*#__PURE__*/_react.default.createElement("g", {
    transform: "rotate(300 50 50)"
  }, /*#__PURE__*/_react.default.createElement("rect", {
    x: 45,
    y: 0,
    rx: 0,
    ry: 0,
    width: 10,
    height: 30,
    fill: color
  }, /*#__PURE__*/_react.default.createElement("animate", {
    attributeName: "opacity",
    values: "1;0",
    dur: "1s",
    begin: "-0.08333333333333333s",
    repeatCount: "indefinite"
  }))), /*#__PURE__*/_react.default.createElement("g", {
    transform: "rotate(330 50 50)"
  }, /*#__PURE__*/_react.default.createElement("rect", {
    x: 45,
    y: 0,
    rx: 0,
    ry: 0,
    width: 10,
    height: 30,
    fill: color
  }, /*#__PURE__*/_react.default.createElement("animate", {
    attributeName: "opacity",
    values: "1;0",
    dur: "1s",
    begin: "0s",
    repeatCount: "indefinite"
  })))));
};
Spinner.propTypes = {
  className: _propTypes.default.string,
  color: _propTypes.default.string
};
var _default = exports.default = Spinner;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\spinner\\spinner.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\survey-toast\\index.ts", {"./survey-toast":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\survey-toast\\survey-toast.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Csurvey-toast%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "SurveyToast", {
  enumerable: true,
  get: function () {
    return _surveyToast.SurveyToast;
  }
});
var _surveyToast = require("./survey-toast");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\survey-toast\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\survey-toast\\survey-toast.tsx", {"../../../../shared/constants/accounts":"D:\\code\\v\\metamask-extension\\shared\\constants\\accounts.ts","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/time":"D:\\code\\v\\metamask-extension\\shared\\constants\\time.ts","../../../../shared/lib/fetch-with-cache":"D:\\code\\v\\metamask-extension\\shared\\lib\\fetch-with-cache.ts","../../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../multichain":"D:\\code\\v\\metamask-extension\\ui\\components\\multichain\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Csurvey-toast%5Csurvey-toast.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SurveyToast = SurveyToast;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _fetchWithCache = _interopRequireDefault(require("../../../../shared/lib/fetch-with-cache"));
var _time = require("../../../../shared/constants/time");
var _metametrics = require("../../../contexts/metametrics");
var _metametrics2 = require("../../../../shared/constants/metametrics");
var _selectors = require("../../../selectors");
var _accounts = require("../../../../shared/constants/accounts");
var _actions = require("../../../store/actions");
var _multichain = require("../../multichain");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function SurveyToast() {
  const [survey, setSurvey] = (0, _react.useState)(null);
  const dispatch = (0, _reactRedux.useDispatch)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const lastViewedUserSurvey = (0, _reactRedux.useSelector)(_selectors.getLastViewedUserSurvey);
  const participateInMetaMetrics = (0, _reactRedux.useSelector)(_selectors.getParticipateInMetaMetrics);
  const basicFunctionality = (0, _reactRedux.useSelector)(_selectors.getUseExternalServices);
  const internalAccount = (0, _reactRedux.useSelector)(_selectors.getSelectedInternalAccount);
  const metaMetricsId = (0, _reactRedux.useSelector)(_selectors.getMetaMetricsId);
  const surveyUrl = (0, _react.useMemo)(() => `${_accounts.ACCOUNTS_API_BASE_URL}/v1/users/${metaMetricsId}/surveys`, [metaMetricsId]);
  (0, _react.useEffect)(() => {
    if (!basicFunctionality || !metaMetricsId || !participateInMetaMetrics) {
      return undefined;
    }
    const controller = new AbortController();
    const fetchSurvey = async () => {
      try {
        const response = await (0, _fetchWithCache.default)({
          url: surveyUrl,
          fetchOptions: {
            method: 'GET',
            headers: {
              'x-metamask-clientproduct': 'metamask-extension'
            },
            signal: controller.signal
          },
          functionName: 'fetchSurveys',
          cacheOptions: {
            cacheRefreshTime: false ? 0 : _time.DAY
          }
        });
        const _survey = response === null || response === void 0 ? void 0 : response.surveys;
        if (!_survey || Object.keys(_survey).length === 0 || _survey.id <= lastViewedUserSurvey) {
          return;
        }
        setSurvey(_survey);
      } catch (error) {
        if (error instanceof Error && error.name !== 'AbortError') {
          console.error('Failed to fetch survey:', metaMetricsId, error);
        }
      }
    };
    fetchSurvey();
    return () => {
      controller.abort();
    };
  }, [internalAccount === null || internalAccount === void 0 ? void 0 : internalAccount.address, lastViewedUserSurvey, basicFunctionality, metaMetricsId, dispatch]);
  function handleActionClick() {
    if (!survey) {
      return;
    }
    global.platform.openTab({
      url: survey.url
    });
    dispatch((0, _actions.setLastViewedUserSurvey)(survey.id));
    trackAction('accept');
  }
  function handleClose() {
    if (!survey) {
      return;
    }
    dispatch((0, _actions.setLastViewedUserSurvey)(survey.id));
    trackAction('deny');
  }
  function trackAction(response) {
    if (!participateInMetaMetrics || !survey) {
      return;
    }
    trackEvent({
      event: _metametrics2.MetaMetricsEventName.SurveyToast,
      category: _metametrics2.MetaMetricsEventCategory.Feedback,
      properties: {
        response,
        survey: survey.id
      }
    });
  }
  if (!survey || survey.id <= lastViewedUserSurvey) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_multichain.Toast, {
    dataTestId: "survey-toast",
    key: "survey-toast",
    text: survey.description,
    actionText: survey.cta,
    onActionClick: handleActionClick,
    onClose: handleClose,
    startAdornment: null
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\survey-toast\\survey-toast.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tab-empty-state\\index.ts", {"./tab-empty-state":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tab-empty-state\\tab-empty-state.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Ctab-empty-state%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "TabEmptyState", {
  enumerable: true,
  get: function () {
    return _tabEmptyState.TabEmptyState;
  }
});
var _tabEmptyState = require("./tab-empty-state");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\tab-empty-state\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tab-empty-state\\tab-empty-state.tsx", {"@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Ctab-empty-state%5Ctab-empty-state.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TabEmptyState = void 0;
var _react = _interopRequireDefault(require("react"));
var _designSystemReact = require("@metamask/design-system-react");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const TabEmptyState = ({
  icon,
  description,
  descriptionProps,
  actionButtonText,
  actionButtonProps,
  onAction,
  className,
  children,
  ...props
}) => {
  return /*#__PURE__*/_react.default.createElement(_designSystemReact.Box, _extends({
    className: (0, _designSystemReact.twMerge)('max-w-56', className),
    flexDirection: _designSystemReact.BoxFlexDirection.Column,
    alignItems: _designSystemReact.BoxAlignItems.Center,
    justifyContent: _designSystemReact.BoxJustifyContent.Center,
    backgroundColor: _designSystemReact.BoxBackgroundColor.BackgroundDefault,
    gap: 3
  }, props), icon, description && /*#__PURE__*/_react.default.createElement(_designSystemReact.Text, _extends({
    variant: _designSystemReact.TextVariant.BodyMd,
    color: _designSystemReact.TextColor.TextAlternative,
    textAlign: _designSystemReact.TextAlign.Center
  }, descriptionProps), description), actionButtonText && /*#__PURE__*/_react.default.createElement(_designSystemReact.Button, _extends({
    variant: _designSystemReact.ButtonVariant.Secondary,
    onClick: onAction
  }, actionButtonProps), actionButtonText), children);
};
exports.TabEmptyState = TabEmptyState;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\tab-empty-state\\tab-empty-state.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tabs\\index.ts", {"./tab":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tabs\\tab\\index.ts","./tabs":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tabs\\tabs.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Ctabs%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "Tab", {
  enumerable: true,
  get: function () {
    return _tab.Tab;
  }
});
Object.defineProperty(exports, "Tabs", {
  enumerable: true,
  get: function () {
    return _tabs.Tabs;
  }
});
var _tabs = require("./tabs");
var _tab = require("./tab");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\tabs\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tabs\\tab\\index.ts", {"./tab":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tabs\\tab\\tab.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Ctabs%5Ctab%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "Tab", {
  enumerable: true,
  get: function () {
    return _tab.Tab;
  }
});
var _tab = require("./tab");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\tabs\\tab\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tabs\\tab\\tab.tsx", {"@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Ctabs%5Ctab%5Ctab.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Tab = void 0;
var _react = _interopRequireDefault(require("react"));
var _designSystemReact = require("@metamask/design-system-react");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const Tab = ({
  className = '',
  'data-testid': dataTestId,
  isActive = false,
  name,
  onClick,
  tabIndex = 0,
  tabKey,
  // Declared, but we are not rendering it explicitly (it's mainly to make JSX
  // happy when being used in .tsx)
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  children,
  disabled = false,
  ...props
}) => {
  const handleClick = e => {
    e.preventDefault();
    if (!disabled && onClick) {
      onClick(tabIndex);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_designSystemReact.Text, _extends({
    key: tabKey,
    "data-testid": dataTestId,
    textAlign: _designSystemReact.TextAlign.Center,
    color: _designSystemReact.TextColor.TextAlternative,
    fontWeight: _designSystemReact.FontWeight.Medium,
    variant: _designSystemReact.TextVariant.BodyMd,
    className: (0, _designSystemReact.twMerge)('flex align-middle justify-center border-b-2 border-transparent px-0 py-1 transition-all duration-200 cubic-bezier(0.7, 0, 0.15, 1) hover:enabled:text-default', isActive && 'text-default border-b-text-default', disabled && 'text-muted', className)
  }, props, {
    asChild: true
  }), /*#__PURE__*/_react.default.createElement("button", {
    role: "tab",
    tabIndex: isActive ? 0 : -1,
    "aria-selected": isActive,
    "aria-disabled": disabled,
    onClick: handleClick,
    disabled: disabled
  }, name));
};
exports.Tab = Tab;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\tabs\\tab\\tab.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tabs\\tabs.tsx", {"@metamask/design-system-react":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-system-react\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Ctabs%5Ctabs.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Tabs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _designSystemReact = require("@metamask/design-system-react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const Tabs = ({
  defaultActiveTabKey,
  onTabClick,
  children,
  subHeader = null,
  tabListProps = {},
  tabContentProps = {},
  className = '',
  ...props
}) => {
  // Helper function to get valid children, filtering out null/undefined/false values
  const getValidChildren = (0, _react.useMemo)(() => {
    return _react.default.Children.toArray(children).filter(child => /*#__PURE__*/_react.default.isValidElement(child) && child.props && typeof child.props.tabKey === 'string');
  }, [children]);

  /**
   * Returns the index of the child with the given key
   *
   * @param tabKey
   */
  const findChildByKey = tabKey => {
    if (!tabKey) {
      return -1;
    }
    return getValidChildren.findIndex(child => child.props.tabKey === tabKey);
  };
  const [activeTabIndex, setActiveTabIndex] = (0, _react.useState)(() => Math.max(findChildByKey(defaultActiveTabKey), 0));
  const handleTabClick = (tabIndex, tabKey) => {
    if (tabIndex !== activeTabIndex) {
      setActiveTabIndex(tabIndex);
      onTabClick === null || onTabClick === void 0 || onTabClick(tabKey);
    }
  };
  const renderTabs = () => {
    const validChildren = getValidChildren;
    const numberOfTabs = validChildren.length;
    return validChildren.map((child, index) => {
      const {
        tabKey
      } = child.props;
      return /*#__PURE__*/_react.default.cloneElement(child, {
        ...child.props,
        onClick: idx => handleTabClick(idx, tabKey),
        tabIndex: index,
        isActive: numberOfTabs > 1 && index === activeTabIndex,
        key: tabKey
      });
    });
  };
  const renderActiveTabContent = () => {
    const validChildren = getValidChildren;
    if (validChildren.length === 0) {
      return null;
    }
    if (activeTabIndex >= validChildren.length || activeTabIndex < 0) {
      throw new Error(`Tab at index '${activeTabIndex}' does not exist`);
    }
    const activeChild = validChildren[activeTabIndex];
    return (activeChild === null || activeChild === void 0 ? void 0 : activeChild.props.children) || null;
  };
  return /*#__PURE__*/_react.default.createElement(_designSystemReact.Box, _extends({
    className: (0, _designSystemReact.twMerge)('tabs', 'transform-gpu', className)
  }, props), /*#__PURE__*/_react.default.createElement(_designSystemReact.Box, _extends({
    role: "tablist",
    flexDirection: _designSystemReact.BoxFlexDirection.Row,
    justifyContent: _designSystemReact.BoxJustifyContent.Start,
    backgroundColor: _designSystemReact.BoxBackgroundColor.BackgroundDefault,
    gap: 4
  }, tabListProps), renderTabs()), subHeader, /*#__PURE__*/_react.default.createElement(_designSystemReact.Box, _extends({
    role: "tabpanel"
  }, tabContentProps), renderActiveTabContent()));
};
exports.Tabs = Tabs;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\tabs\\tabs.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\text-field\\index.js", {"./text-field.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\text-field\\text-field.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Ctext-field%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _textField = _interopRequireDefault(require("./text-field.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
var _default = exports.default = _textField.default;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\text-field\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\text-field\\text-field.component.js", {"@material-ui/core/TextField":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\TextField\\index.js","@material-ui/core/styles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Ctext-field%5Ctext-field.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _styles = require("@material-ui/core/styles");
var _TextField = _interopRequireDefault(require("@material-ui/core/TextField"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
/**
 * @deprecated The `<TextField />` component has been deprecated in favor of the new `<TextField>` component from the component-library.
 * Please update your code to use the new `<TextField>` component instead, which can be found at ui/components/component-library/text-field/text-field.js.
 * You can find documentation for the new `TextField` component in the MetaMask Storybook:
 * {@link https://metamask.github.io/metamask-storybook/?path=/docs/components-componentlibrary-textfield--docs}
 * If you would like to help with the replacement of the old `TextField` component, please submit a pull request against this GitHub issue:
 * {@link https://github.com/MetaMask/metamask-extension/issues/20483}
 */

const inputLabelBase = {
  transform: 'none',
  transition: 'none',
  position: 'initial',
  color: 'var(--color-text-default)'
};
const fontFamily = ['"Geist"', 'Helvetica', 'Arial', 'sans-serif'].join(', ');
const styles = {
  materialLabel: {
    '&$materialFocused': {
      color: 'var(--color-text-alternative)'
    },
    '&$materialError': {
      color: 'var(--color-text-alternative)'
    },
    fontWeight: '400',
    color: 'var(--color-text-alternative)'
  },
  materialFocused: {},
  materialUnderline: {
    '&:before': {
      borderBottom: '1px solid var(--color-text-default) !important' // Visible bottom border
    },
    '&:after': {
      borderBottom: `2px solid var(--color-primary-default)` // Animated bottom border
    }
  },
  materialError: {},
  materialWhitePaddedRoot: {
    color: 'var(--color-text-alternative)'
  },
  materialWhitePaddedInput: {
    padding: '8px',
    '&::placeholder': {
      color: 'var(--color-text-alternative)'
    }
  },
  materialWhitePaddedFocused: {
    color: 'var(--color-background-default)'
  },
  materialWhitePaddedUnderline: {
    '&:after': {
      borderBottom: '2px solid var(--color-background-default)' // @TODO: Replace with border-muted ?
    }
  },
  // Non-material styles
  formLabel: {
    fontFamily,
    '&$formLabelFocused': {
      color: 'var(--color-text-alternative)'
    },
    '&$materialError': {
      color: 'var(--color-text-alternative)'
    }
  },
  formLabelFocused: {},
  inputFocused: {},
  inputRoot: {
    fontFamily,
    'label + &': {
      marginTop: '9px'
    },
    backgroundColor: 'var(--color-background-default)',
    border: '1px solid var(--color-border-default)',
    color: 'var(--color-text-default)',
    height: '48px',
    padding: '0 16px',
    display: 'flex',
    alignItems: 'center',
    '&$inputFocused': {
      border: '1px solid var(--color-primary-default)'
    },
    borderRadius: '8px',
    fontSize: '0.875rem'
  },
  largeInputLabel: {
    ...inputLabelBase,
    fontSize: '1rem'
  },
  inputLabel: {
    ...inputLabelBase,
    fontSize: '.75rem'
  },
  inputMultiline: {
    lineHeight: 'initial !important'
  }
};
const getMaterialThemeInputProps = ({
  dir,
  classes: {
    materialLabel,
    materialFocused,
    materialError,
    materialUnderline
  },
  startAdornment,
  endAdornment,
  min,
  max,
  autoComplete
}) => ({
  InputLabelProps: {
    classes: {
      root: materialLabel,
      focused: materialFocused,
      error: materialError
    }
  },
  InputProps: {
    startAdornment,
    endAdornment,
    classes: {
      underline: materialUnderline
    },
    inputProps: {
      dir,
      min,
      max,
      autoComplete
    }
  }
});
const getMaterialWhitePaddedThemeInputProps = ({
  dir,
  classes: {
    materialWhitePaddedRoot,
    materialWhitePaddedFocused,
    materialWhitePaddedInput,
    materialWhitePaddedUnderline
  },
  startAdornment,
  endAdornment,
  min,
  max,
  autoComplete
}) => ({
  InputProps: {
    startAdornment,
    endAdornment,
    classes: {
      root: materialWhitePaddedRoot,
      focused: materialWhitePaddedFocused,
      input: materialWhitePaddedInput,
      underline: materialWhitePaddedUnderline
    },
    inputProps: {
      dir,
      min,
      max,
      autoComplete
    }
  }
});
const getBorderedThemeInputProps = ({
  dir,
  classes: {
    formLabel,
    formLabelFocused,
    materialError,
    largeInputLabel,
    inputLabel,
    inputRoot,
    input,
    inputFocused
  },
  largeLabel,
  startAdornment,
  endAdornment,
  min,
  max,
  autoComplete
}) => ({
  InputLabelProps: {
    shrink: true,
    className: largeLabel ? largeInputLabel : inputLabel,
    classes: {
      root: formLabel,
      focused: formLabelFocused,
      error: materialError
    }
  },
  InputProps: {
    startAdornment,
    endAdornment,
    classes: {
      root: inputRoot,
      input,
      focused: inputFocused
    },
    inputProps: {
      dir,
      min,
      max,
      autoComplete
    },
    disableUnderline: 'true'
  }
});
const themeToInputProps = {
  material: getMaterialThemeInputProps,
  bordered: getBorderedThemeInputProps,
  'material-white-padded': getMaterialWhitePaddedThemeInputProps
};
const TextField = ({
  'data-testid': dataTestId,
  error,
  classes,
  theme,
  startAdornment,
  endAdornment,
  largeLabel,
  dir,
  min,
  max,
  autoComplete,
  onPaste,
  ...textFieldProps
}) => {
  const inputProps = themeToInputProps[theme]({
    classes,
    startAdornment,
    endAdornment,
    largeLabel,
    dir,
    min,
    max,
    autoComplete
  });
  if (onPaste || dataTestId) {
    if (!inputProps.InputProps) {
      inputProps.InputProps = {};
    }
    if (!inputProps.InputProps.inputProps) {
      inputProps.InputProps.inputProps = {};
    }
    inputProps.InputProps.inputProps.onPaste = onPaste;
    inputProps.InputProps.inputProps['data-testid'] = dataTestId;
  }
  return /*#__PURE__*/_react.default.createElement(_TextField.default, _extends({
    error: Boolean(error),
    helperText: error
  }, inputProps, textFieldProps));
};
TextField.defaultProps = {
  error: null,
  dir: 'auto',
  theme: 'bordered'
};
TextField.propTypes = {
  /**
   * A test ID that gets set on the input element
   */
  'data-testid': _propTypes.default.string,
  /**
   * Show error message
   */
  error: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.element]),
  /**
   * Add custom CSS class
   */
  classes: _propTypes.default.object,
  dir: _propTypes.default.string,
  /**
   * Give theme to the text field
   */
  theme: _propTypes.default.oneOf(['bordered', 'material', 'material-white-padded']),
  startAdornment: _propTypes.default.element,
  endAdornment: _propTypes.default.element,
  /**
   * Show large label
   */
  largeLabel: _propTypes.default.bool,
  /**
   * Define min number input
   */
  min: _propTypes.default.number,
  /**
   * Define max number input
   */
  max: _propTypes.default.number,
  /**
   * Show auto complete text
   */
  autoComplete: _propTypes.default.string,
  onPaste: _propTypes.default.func
};
var _default = exports.default = (0, _styles.withStyles)(styles)(TextField);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\text-field\\text-field.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\textarea\\textarea.constants.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Ctextarea%5Ctextarea.constants.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RESIZE = void 0;
const RESIZE = exports.RESIZE = {
  NONE: 'none',
  BOTH: 'both',
  HORIZONTAL: 'horizontal',
  VERTICAL: 'vertical',
  INITIAL: 'initial',
  INHERIT: 'inherit'
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\textarea\\textarea.constants.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\textarea\\textarea.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../box":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\box\\index.js","./textarea.constants":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\textarea\\textarea.constants.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Ctextarea%5Ctextarea.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _designSystem = require("../../../helpers/constants/design-system");
var _box = _interopRequireDefault(require("../box"));
var _textarea = require("./textarea.constants");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
/**
 * @deprecated `<TextArea />` has been deprecated in favor of the `<Textarea />`
 * component in ./ui/components/component-library/textarea/textarea.tsx.
 * See storybook documentation for BannerAlert here:
 * {@see {@link https://metamask.github.io/metamask-storybook/?path=/docs/components-componentlibrary-textarea--default-story#textarea}}
 *
 * Help to replace `<TextArea />` with `<Textarea />` by submitting a PR
 */

const TextArea = ({
  className,
  value,
  onChange,
  resize = _textarea.RESIZE.BOTH,
  scrollable = false,
  height,
  boxProps,
  ...props
}) => {
  const textAreaClassnames = (0, _classnames.default)('textarea', className, `textarea--resize-${resize}`, {
    'textarea--scrollable': scrollable,
    'textarea--not-scrollable': !scrollable
  });
  return /*#__PURE__*/_react.default.createElement(_box.default, _extends({
    backgroundColor: _designSystem.BackgroundColor.backgroundDefault,
    borderColor: _designSystem.BorderColor.borderDefault,
    borderRadius: _designSystem.Size.SM,
    borderStyle: _designSystem.BorderStyle.solid,
    padding: 4,
    width: _designSystem.BlockSize.Full
  }, boxProps), boxClassName => /*#__PURE__*/_react.default.createElement("textarea", _extends({
    required: true,
    style: {
      height
    },
    className: (0, _classnames.default)(boxClassName, textAreaClassnames),
    value,
    onChange
  }, props)));
};
TextArea.propTypes = {
  /**
   * The height of the Textarea component. Accepts any number, px or % value
   */
  height: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),
  /**
   * Optional additional className to add to the Textarea component
   */
  className: _propTypes.default.string,
  /**
   * Value is the text of the TextArea component
   */
  value: _propTypes.default.string,
  /**
   * The onChange function of the textarea
   */
  onChange: _propTypes.default.func,
  /**
   * Resize is the resize capability of the textarea accepts all valid css values
   * Defaults to "both"
   */
  resize: _propTypes.default.oneOf(Object.values(_textarea.RESIZE)),
  /**
   * Whether the Textarea should be scrollable. Applies overflow-y: scroll to the textarea
   * Defaults to false
   */
  scrollable: _propTypes.default.bool,
  /**
   * The Textarea component accepts all Box component props inside the boxProps object
   */
  boxProps: _propTypes.default.shape({
    ..._box.default.propTypes
  })
};
var _default = exports.default = TextArea;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\textarea\\textarea.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\toggle-button\\index.js", {"./toggle-button.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\toggle-button\\toggle-button.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Ctoggle-button%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _toggleButton = _interopRequireDefault(require("./toggle-button.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
var _default = exports.default = _toggleButton.default;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\toggle-button\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\toggle-button\\toggle-button.component.js", {"../../../hooks/useTheme":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTheme.ts","@metamask/design-tokens":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\index.cjs","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-toggle-button":"D:\\code\\v\\metamask-extension\\node_modules\\react-toggle-button\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Ctoggle-button%5Ctoggle-button.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactToggleButton = _interopRequireDefault(require("react-toggle-button"));
var _classnames = _interopRequireDefault(require("classnames"));
var _designTokens = require("@metamask/design-tokens");
var _useTheme = require("../../../hooks/useTheme");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const trackStyle = {
  width: '40px',
  height: '24px',
  padding: '0px',
  borderRadius: '26px',
  border: 'none',
  display: 'flex',
  alignItems: 'center',
  justifyContent: 'center'
};
const offTrackStyle = {
  ...trackStyle,
  border: 'none'
};
const thumbStyle = {
  width: '18px',
  height: '18px',
  display: 'flex',
  boxShadow: 'var(--shadow-size-xs) var(--color-shadow-default)',
  alignSelf: 'center',
  borderRadius: '50%',
  position: 'relative'
};
const colorsLight = {
  activeThumb: {
    base: _designTokens.lightTheme.colors.primary.inverse
  },
  inactiveThumb: {
    base: _designTokens.lightTheme.colors.primary.inverse
  },
  active: {
    base: _designTokens.lightTheme.colors.primary.default,
    hover: _designTokens.lightTheme.colors.primary.defaultHover
  },
  inactive: {
    base: _designTokens.lightTheme.colors.icon.muted,
    hover: _designTokens.lightTheme.colors.icon.muted
  }
};
const colorsDark = {
  activeThumb: {
    base: _designTokens.lightTheme.colors.primary.inverse
  },
  inactiveThumb: {
    base: _designTokens.lightTheme.colors.primary.inverse
  },
  active: {
    base: _designTokens.darkTheme.colors.primary.default,
    hover: _designTokens.darkTheme.colors.primary.defaultHover
  },
  inactive: {
    base: _designTokens.darkTheme.colors.icon.muted,
    hover: _designTokens.darkTheme.colors.icon.muted
  }
};
const ToggleButton = props => {
  const {
    value,
    onToggle,
    offLabel,
    onLabel,
    disabled,
    className,
    dataTestId
  } = props;
  const modifier = value ? 'on' : 'off';
  const theme = (0, _useTheme.useTheme)();
  return /*#__PURE__*/_react.default.createElement("label", {
    tabIndex: "0",
    onKeyDown: e => {
      if (e.key === 'Enter') {
        onToggle(value);
      }
    },
    className: (0, _classnames.default)('toggle-button', `toggle-button--${modifier}`, {
      'toggle-button--disabled': disabled
    }, className)
  }, /*#__PURE__*/_react.default.createElement(_reactToggleButton.default, {
    value: value,
    onToggle: disabled ? undefined : onToggle,
    activeLabel: "",
    inactiveLabel: "",
    trackStyle: value ? trackStyle : offTrackStyle,
    thumbStyle: thumbStyle,
    thumbAnimateRange: [3, 18],
    colors: theme === 'light' ? colorsLight : colorsDark,
    passThroughInputProps: {
      'data-testid': dataTestId
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "toggle-button__status"
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "toggle-button__label-off"
  }, offLabel), /*#__PURE__*/_react.default.createElement("span", {
    className: "toggle-button__label-on"
  }, onLabel)));
};
ToggleButton.propTypes = {
  /**
   * ToggleButton value
   */
  value: _propTypes.default.bool,
  /**
   * The onChange handler of the ToggleButton
   */
  onToggle: _propTypes.default.func,
  /**
   * Label text when toggle is off
   */
  offLabel: _propTypes.default.string,
  /**
   * Label text when toggle is on
   */
  onLabel: _propTypes.default.string,
  /**
   * Disables ToggleButton if true. Set to false as default
   */
  disabled: _propTypes.default.bool,
  /**
   * Additional className to add to the ToggleButton
   */
  className: _propTypes.default.string,
  /**
   * A test id for the toggle button
   */
  dataTestId: _propTypes.default.string
};
var _default = exports.default = ToggleButton;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\toggle-button\\toggle-button.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\token-balance\\index.js", {"./token-balance":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\token-balance\\token-balance.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Ctoken-balance%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _tokenBalance.default;
  }
});
var _tokenBalance = _interopRequireDefault(require("./token-balance"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\token-balance\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\token-balance\\token-balance.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useIsOriginalTokenSymbol":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useIsOriginalTokenSymbol.js","../../../hooks/useTokenFiatAmount":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTokenFiatAmount.js","../../../hooks/useTokenTracker":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTokenTracker.js","../../component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../currency-display":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\currency-display\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Ctoken-balance%5Ctoken-balance.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = TokenBalance;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _currencyDisplay = _interopRequireDefault(require("../currency-display"));
var _useTokenTracker = require("../../../hooks/useTokenTracker");
var _useTokenFiatAmount = require("../../../hooks/useTokenFiatAmount");
var _useIsOriginalTokenSymbol = require("../../../hooks/useIsOriginalTokenSymbol");
var _componentLibrary = require("../../component-library");
var _designSystem = require("../../../helpers/constants/design-system");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function TokenBalance({
  className,
  token,
  showFiat,
  ...restProps
}) {
  const {
    tokensWithBalances
  } = (0, _useTokenTracker.useTokenTracker)({
    tokens: [token]
  });
  const {
    string,
    symbol,
    address
  } = tokensWithBalances[0] || {};
  const formattedFiat = (0, _useTokenFiatAmount.useTokenFiatAmount)(address, string, symbol);
  const isOriginalTokenSymbol = (0, _useIsOriginalTokenSymbol.useIsOriginalTokenSymbol)(address, symbol);
  const fiatValue = isOriginalTokenSymbol ? formattedFiat : null;
  if (showFiat) {
    return /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      fontWeight: _designSystem.FontWeight.Medium,
      variant: _designSystem.TextVariant.bodyMd
    }, fiatValue);
  }
  return /*#__PURE__*/_react.default.createElement(_currencyDisplay.default, _extends({
    className: className,
    displayValue: string || '',
    suffix: symbol || ''
  }, restProps));
}
TokenBalance.propTypes = {
  className: _propTypes.default.string,
  token: _propTypes.default.shape({
    address: _propTypes.default.string.isRequired,
    decimals: _propTypes.default.number,
    symbol: _propTypes.default.string
  }).isRequired,
  showFiat: _propTypes.default.bool
};
TokenBalance.defaultProps = {
  className: undefined
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\token-balance\\token-balance.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\index.js", {"./tooltip":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\tooltip.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Ctooltip%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _tooltip.default;
  }
});
var _tooltip = _interopRequireDefault(require("./tooltip"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\tooltip\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\tooltip\\tooltip.js", {"prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-tippy":"D:\\code\\v\\metamask-extension\\node_modules\\react-tippy\\dist\\react-tippy.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Ctooltip%5Ctooltip.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _reactTippy = require("react-tippy");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class Tooltip extends _react.PureComponent {
  render() {
    const {
      arrow,
      children,
      containerClassName,
      disabled,
      position,
      html,
      interactive,
      size,
      distance,
      title,
      trigger,
      onHidden,
      offset,
      open,
      wrapperClassName,
      style,
      wrapperStyle,
      theme,
      tabIndex,
      tag
    } = this.props;
    if (!title && !html) {
      return /*#__PURE__*/_react.default.createElement("div", {
        className: wrapperClassName
      }, children);
    }
    return /*#__PURE__*/_react.default.createElement(tag, {
      className: wrapperClassName,
      style: wrapperStyle
    }, /*#__PURE__*/_react.default.createElement(_reactTippy.Tooltip, {
      arrow: arrow,
      className: containerClassName,
      disabled: disabled,
      hideOnClick: false,
      distance: distance,
      html: html,
      interactive: interactive,
      onHidden: onHidden,
      position: position,
      size: size,
      offset: offset,
      style: style,
      title: disabled ? '' : title,
      trigger: trigger,
      open: open,
      theme: `tippy-tooltip--mm-custom ${theme}` // Required for correct theming
      ,
      tabIndex: tabIndex || 0,
      tag: tag
    }, children));
  }
}
exports.default = Tooltip;
_defineProperty(Tooltip, "defaultProps", {
  arrow: true,
  children: null,
  containerClassName: '',
  html: null,
  interactive: undefined,
  onHidden: null,
  distance: 0,
  position: 'left',
  offset: 0,
  open: undefined,
  size: 'small',
  title: null,
  trigger: 'mouseenter focus',
  wrapperClassName: undefined,
  theme: '',
  tag: 'div',
  wrapperStyle: {}
});
_defineProperty(Tooltip, "propTypes", {
  arrow: _propTypes.default.bool,
  children: _propTypes.default.node,
  containerClassName: _propTypes.default.string,
  disabled: _propTypes.default.bool,
  html: _propTypes.default.node,
  distance: _propTypes.default.number,
  interactive: _propTypes.default.bool,
  offset: _propTypes.default.number,
  onHidden: _propTypes.default.func,
  open: _propTypes.default.bool,
  position: _propTypes.default.oneOf(['top', 'right', 'bottom', 'left']),
  size: _propTypes.default.oneOf(['small', 'regular', 'big']),
  title: _propTypes.default.string,
  trigger: _propTypes.default.any,
  wrapperClassName: _propTypes.default.string,
  style: _propTypes.default.object,
  wrapperStyle: _propTypes.default.object,
  theme: _propTypes.default.string,
  tabIndex: _propTypes.default.number,
  tag: _propTypes.default.string
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\tooltip\\tooltip.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\truncated-definition-list\\index.js", {"./truncated-definition-list":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\truncated-definition-list\\truncated-definition-list.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Ctruncated-definition-list%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _truncatedDefinitionList.default;
  }
});
var _truncatedDefinitionList = _interopRequireDefault(require("./truncated-definition-list"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\truncated-definition-list\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\truncated-definition-list\\truncated-definition-list.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../box":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\box\\index.js","../button":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\button\\index.js","../definition-list/definition-list":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\definition-list\\definition-list.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Ctruncated-definition-list%5Ctruncated-definition-list.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = TruncatedDefinitionList;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _designSystem = require("../../../helpers/constants/design-system");
var _box = _interopRequireDefault(require("../box"));
var _button = _interopRequireDefault(require("../button"));
var _definitionList = _interopRequireDefault(require("../definition-list/definition-list"));
var _useI18nContext = require("../../../hooks/useI18nContext");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function TruncatedDefinitionList({
  dictionary,
  tooltips,
  warnings,
  prefaceKeys
}) {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const t = (0, _useI18nContext.useI18nContext)();
  const renderDefinitionList = isFullList => /*#__PURE__*/_react.default.createElement(_definitionList.default, {
    gap: _designSystem.Size.MD,
    tooltips: tooltips,
    warnings: warnings,
    dictionary: isFullList ? dictionary : (0, _lodash.pick)(dictionary, prefaceKeys)
  });
  const renderButton = () => /*#__PURE__*/_react.default.createElement(_button.default, {
    className: "truncated-definition-list__view-more",
    type: "link",
    onClick: () => setIsPopoverOpen(true)
  }, t('seeDetails'));
  const renderContent = () => {
    return isPopoverOpen ? renderDefinitionList(true) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, renderDefinitionList(false), renderButton());
  };
  return /*#__PURE__*/_react.default.createElement(_box.default, {
    marginTop: 6,
    marginBottom: 6,
    marginLeft: 0,
    marginRight: 0,
    padding: 4,
    paddingBottom: 3,
    borderRadius: _designSystem.Size.LG,
    borderColor: _designSystem.BorderColor.borderMuted
  }, renderContent());
}
TruncatedDefinitionList.propTypes = {
  dictionary: _definitionList.default.propTypes.dictionary,
  tooltips: _definitionList.default.propTypes.dictionary,
  warnings: _definitionList.default.propTypes.dictionary,
  prefaceKeys: _propTypes.default.arrayOf(_propTypes.default.string)
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\truncated-definition-list\\truncated-definition-list.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\typography\\index.js", {"./typography":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\typography\\typography.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Ctypography%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _typography.default;
  }
});
var _typography = _interopRequireDefault(require("./typography"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\typography\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\typography\\typography.js", {"../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../box":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\box\\index.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Ctypography%5Ctypography.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValidTags = exports.ValidColors = void 0;
exports.default = Typography;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _designSystem = require("../../../helpers/constants/design-system");
var _box = _interopRequireWildcard(require("../box"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
const {
  H6,
  H7,
  H8,
  H9
} = _designSystem.TypographyVariant;
const ValidColors = exports.ValidColors = [_designSystem.Color.textDefault, _designSystem.Color.textAlternative, _designSystem.Color.textMuted, _designSystem.Color.overlayInverse, _designSystem.Color.primaryDefault, _designSystem.Color.primaryInverse, _designSystem.Color.errorDefault, _designSystem.Color.errorInverse, _designSystem.Color.successDefault, _designSystem.Color.successInverse, _designSystem.Color.sepoliaInverse, _designSystem.Color.warningDefault, _designSystem.Color.warningInverse, _designSystem.Color.infoDefault, _designSystem.Color.infoInverse, _designSystem.Color.goerli, _designSystem.Color.sepolia, _designSystem.Color.goerliInverse, _designSystem.Color.sepoliaInverse, _designSystem.Color.lineaGoerli, _designSystem.Color.lineaGoerliInverse, _designSystem.Color.lineaSepolia, _designSystem.Color.lineaSepoliaInverse, _designSystem.Color.lineaMainnet, _designSystem.Color.lineaMainnetInverse];
const ValidTags = exports.ValidTags = ['dd', 'div', 'dt', 'em', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'li', 'p', 'span', 'strong', 'ul', 'label'];

/**
 * @deprecated `<Typography />` has been deprecated in favor of the `<Text />` component in ./ui/components/component-library/text/text.js
 *
 * See storybook documentation for Text here https://metamask.github.io/metamask-storybook/?path=/docs/components-componentlibrary-text--default-story#text
 *
 * Help to replace `Typography` with `Text` by submitting PRs against https://github.com/MetaMask/metamask-extension/issues/17670
 */

function Typography({
  variant = _designSystem.TypographyVariant.paragraph,
  color = _designSystem.Color.textDefault,
  fontWeight = 'normal',
  fontStyle = 'normal',
  align,
  overflowWrap,
  title,
  as,
  margin,
  marginTop = 1,
  marginRight,
  marginBottom = 1,
  marginLeft,
  boxProps = {},
  className,
  testId,
  children
}) {
  let Tag = as ?? variant;
  let strongTagFontWeight;
  if (Tag === 'strong') {
    strongTagFontWeight = _designSystem.FONT_WEIGHT.BOLD;
  }
  const computedClassName = (0, _classnames.default)('typography', className, `typography--${variant}`, `typography--weight-${strongTagFontWeight || fontWeight}`, `typography--style-${fontStyle}`, {
    [`typography--align-${align}`]: Boolean(align),
    [`typography--color-${color}`]: Boolean(color),
    [`typography--overflowwrap-${overflowWrap}`]: Boolean(overflowWrap)
  });
  if (Tag === _designSystem.TypographyVariant.paragraph) {
    Tag = 'p';
  } else if ([H7, H8, H9].includes(Tag)) {
    Tag = H6;
  }
  return /*#__PURE__*/_react.default.createElement(_box.default, _extends({
    margin,
    marginTop,
    marginRight,
    marginBottom,
    marginLeft
  }, boxProps), boxClassName => /*#__PURE__*/_react.default.createElement(Tag, {
    className: (0, _classnames.default)(boxClassName, computedClassName),
    title: title,
    "data-testid": testId
  }, children));
}
Typography.propTypes = {
  /**
   * The variation of font sizes of the Typography component
   */
  variant: _propTypes.default.oneOf(Object.values(_designSystem.TypographyVariant)),
  /**
   * The color of the Typography component Should use the COLOR object from
   * ./ui/helpers/constants/design-system.js
   */
  color: _propTypes.default.oneOf(ValidColors),
  /**
   * The font-weight of the Typography component. Should use the FONT_WEIGHT object from
   * ./ui/helpers/constants/design-system.js
   */
  fontWeight: _propTypes.default.oneOf(Object.values(_designSystem.FONT_WEIGHT)),
  /**
   * The font-style of the Typography component. Should use the FONT_STYLE object from
   * ./ui/helpers/constants/design-system.js
   */
  fontStyle: _propTypes.default.oneOf(Object.values(_designSystem.FONT_STYLE)),
  /**
   * The text-align of the Typography component. Should use the TextAlign enum from
   * ./ui/helpers/constants/design-system.js
   */
  align: _propTypes.default.oneOf(Object.values(_designSystem.TextAlign)),
  /**
   * The overflow-wrap of the Typography component. Should use the OVERFLOW_WRAP object from
   * ./ui/helpers/constants/design-system.js
   */
  overflowWrap: _propTypes.default.oneOf(Object.values(_designSystem.OVERFLOW_WRAP)),
  /**
   * Changes the root html element of the Typography component.
   */
  as: _propTypes.default.oneOf(ValidTags),
  /**
   * Adds margin to the Typography component should use valid size
   */
  margin: _box.MultipleSizesAndAuto,
  marginTop: _box.MultipleSizesAndAuto,
  marginBottom: _box.MultipleSizesAndAuto,
  marginRight: _box.MultipleSizesAndAuto,
  marginLeft: _box.MultipleSizesAndAuto,
  /**
   * Used to pass any valid Box component props such as margin or padding
   * to the Typography component
   */
  boxProps: _propTypes.default.shape({
    ..._box.default.propTypes
  }),
  /**
   * Additional className to assign the Typography component
   */
  className: _propTypes.default.string,
  /**
   * Title attribute to include on the element. Will show as tooltip on hover.
   */
  title: _propTypes.default.string,
  /**
   * Data test ID for the Tag component
   */
  testId: _propTypes.default.string,
  /**
   * The text content of the Typography component
   */
  children: _propTypes.default.node.isRequired
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\typography\\typography.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\unit-input\\index.js", {"./unit-input.component":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\unit-input\\unit-input.component.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cunit-input%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _unitInput.default;
  }
});
var _unitInput = _interopRequireDefault(require("./unit-input.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\unit-input\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\unit-input\\unit-input.component.js", {"classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-tippy":"D:\\code\\v\\metamask-extension\\node_modules\\react-tippy\\dist\\react-tippy.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cunit-input%5Cunit-input.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactTippy = require("react-tippy");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
const INPUT_HORIZONTAL_PADDING = 4;
function removeLeadingZeroes(str) {
  return str.replace(/^0*(?=\d)/u, '');
}

// accounts for comma input
const DECIMAL_INPUT_REGEX = /^\d*(\.|,)?\d*$/u;

/**
 * Component that attaches a suffix or unit of measurement trailing user input, ex. 'ETH'. Also
 * allows rendering a child component underneath the input to, for example, display conversions of
 * the shown suffix.
 */
class UnitInput extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "state", {
      value: this.props.value,
      isOverflowing: false
    });
    _defineProperty(this, "handleFocus", () => {
      if (!['INPUT', 'TEXTAREA'].includes(document.activeElement.tagName)) {
        this.unitInput.focus();
      }
    });
    _defineProperty(this, "handleInputFocus", ({
      target: {
        value
      }
    }) => {
      if (value === '0') {
        this.setState({
          ...this.state,
          isOverflowing: false,
          value: ''
        });
      }
    });
    _defineProperty(this, "handleInputBlur", ({
      target: {
        value
      }
    }) => {
      var _this$unitInput, _this$unitInput$scrol;
      if (value === '') {
        this.setState({
          ...this.state,
          isOverflowing: false,
          value: '0'
        });
      }
      this.props.onBlur && this.props.onBlur(value);
      (_this$unitInput = this.unitInput) === null || _this$unitInput === void 0 || (_this$unitInput$scrol = _this$unitInput.scrollTo) === null || _this$unitInput$scrol === void 0 || _this$unitInput$scrol.call(_this$unitInput, 0, 0);
    });
    _defineProperty(this, "handleChange", event => {
      const {
        value: userInput
      } = event.target;
      let value = userInput;
      if (userInput.length && userInput.length > 1) {
        value = removeLeadingZeroes(userInput);
      }
      if (!this.props.keyPressRegex.test(value)) {
        event.preventDefault();
        return;
      }
      this.setState({
        ...this.state,
        isOverflowing: this.getIsOverflowing(),
        value
      });
      this.props.onChange(value);
    });
    _defineProperty(this, "handleOnKeyPress", e => {
      const isNumericInput = DECIMAL_INPUT_REGEX.test(e.key);
      if (!isNumericInput) {
        e.preventDefault();
      }
    });
    // imperatively updates the overflow when the input is changed upstreamed
    _defineProperty(this, "updateIsOverflowing", () => {
      this.setState({
        ...this.state,
        isOverflowing: this.getIsOverflowing()
      });
    });
  }
  componentDidUpdate(prevProps) {
    const {
      value: prevPropsValue
    } = prevProps;
    const {
      value: propsValue
    } = this.props;
    const {
      value: stateValue
    } = this.state;
    if (prevPropsValue !== propsValue && Number(propsValue) !== Number(stateValue)) {
      this.setState({
        ...this.state,
        value: propsValue
      });
    }
  }
  componentDidMount() {
    if (this.props.isFocusOnInput) {
      document.addEventListener('keypress', this.handleFocus);
    }
  }
  componentWillUnmount() {
    document.removeEventListener('keypress', this.handleFocus);
  }
  getInputWidth(value) {
    const valueString = String(value);
    const valueLength = valueString.length || 1;
    const decimalPointDeficit = valueString.match(/\./u) ? -0.5 : 0;
    return `${valueLength + decimalPointDeficit + 0.5}ch`;
  }
  getIsOverflowing() {
    let isOverflowing = false;
    if (this.unitInput) {
      const {
        offsetWidth,
        scrollWidth
      } = this.unitInput;

      // overflowing when scrollable width exceeds padding
      isOverflowing = scrollWidth - offsetWidth > INPUT_HORIZONTAL_PADDING;
    }
    return isOverflowing;
  }
  render() {
    const {
      className,
      error,
      placeholder,
      hideSuffix,
      suffix,
      actionComponent,
      children,
      dataTestId,
      isDisabled
    } = this.props;
    const {
      value,
      isOverflowing
    } = this.state;
    return /*#__PURE__*/_react.default.createElement("div", {
      className: (0, _classnames.default)('unit-input', {
        'unit-input--error': error
      }, className),
      onClick: this.handleFocus
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "unit-input__inputs"
    }, /*#__PURE__*/_react.default.createElement(_reactTippy.Tooltip, {
      title: value,
      disabled: !isOverflowing || !value,
      arrow: true,
      hideOnClick: false,
      className: "unit-input__input-container"
      // explicitly inherit display since Tooltip will default to block
      ,
      style: {
        display: 'inherit'
      }
    }, /*#__PURE__*/_react.default.createElement("input", {
      disabled: isDisabled,
      "data-testid": dataTestId,
      type: "number",
      dir: "ltr",
      className: (0, _classnames.default)('unit-input__input'),
      value: value,
      placeholder: placeholder,
      onChange: this.handleChange,
      onBlur: this.handleInputBlur,
      onFocus: this.handleInputFocus,
      onKeyPress: this.handleOnKeyPress,
      min: 0,
      step: "any",
      style: {
        width: this.getInputWidth(value)
      },
      ref: ref => {
        this.unitInput = ref;
      },
      autoFocus: true
    }), suffix && !hideSuffix ? /*#__PURE__*/_react.default.createElement("div", {
      className: "unit-input__suffix"
    }, suffix) : null), children), actionComponent);
  }
}
exports.default = UnitInput;
_defineProperty(UnitInput, "propTypes", {
  className: _propTypes.default.string,
  dataTestId: _propTypes.default.string,
  children: _propTypes.default.node,
  actionComponent: _propTypes.default.node,
  error: _propTypes.default.bool,
  onChange: _propTypes.default.func,
  onBlur: _propTypes.default.func,
  placeholder: _propTypes.default.string,
  suffix: _propTypes.default.string,
  hideSuffix: _propTypes.default.bool,
  value: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),
  keyPressRegex: _propTypes.default.instanceOf(RegExp),
  isDisabled: _propTypes.default.bool,
  isFocusOnInput: _propTypes.default.bool
});
_defineProperty(UnitInput, "defaultProps", {
  value: '',
  placeholder: '0',
  keyPressRegex: DECIMAL_INPUT_REGEX
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\unit-input\\unit-input.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\update-nickname-popover\\update-nickname-popover.js", {"../../../contexts/i18n":"D:\\code\\v\\metamask-extension\\ui\\contexts\\i18n.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../button":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\button\\index.js","../identicon":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\identicon\\index.js","../popover":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\popover\\index.js","../text-field":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\text-field\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Cupdate-nickname-popover%5Cupdate-nickname-popover.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = UpdateNicknamePopover;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _popover = _interopRequireDefault(require("../popover"));
var _button = _interopRequireDefault(require("../button"));
var _textField = _interopRequireDefault(require("../text-field"));
var _i18n = require("../../../contexts/i18n");
var _identicon = _interopRequireDefault(require("../identicon"));
var _selectors = require("../../../selectors");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function UpdateNicknamePopover({
  address,
  nickname = '',
  memo = '',
  onAdd,
  onClose
}) {
  var _tokenList$address$to;
  const t = (0, _react.useContext)(_i18n.I18nContext);
  const [nicknameInput, setNicknameInput] = (0, _react.useState)(nickname === null ? '' : nickname);
  const [memoInput, setMemoInput] = (0, _react.useState)(memo === null ? '' : memo);
  const handleNicknameChange = event => {
    setNicknameInput(event.target.value);
  };
  const handleMemoChange = event => {
    setMemoInput(event.target.value);
  };
  const closePopover = (0, _react.useCallback)(() => {
    onClose();
  }, [onClose]);
  const onCancel = () => {
    onClose();
  };
  const onSubmit = () => {
    onAdd(address, nicknameInput, memoInput);
    onClose();
  };
  const tokenList = (0, _reactRedux.useSelector)(_selectors.getTokenList);
  return /*#__PURE__*/_react.default.createElement(_popover.default, {
    title: nickname ? t('editAddressNickname') : t('addANickname'),
    onClose: closePopover,
    className: "update-nickname__wrapper",
    footer: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_button.default, {
      className: "update-nickname__cancel",
      type: "secondary",
      onClick: onCancel
    }, t('cancel')), /*#__PURE__*/_react.default.createElement(_button.default, {
      className: "update-nickname__save",
      type: "primary",
      onClick: onSubmit,
      disabled: !nicknameInput
    }, t('save')))
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "update-nickname__content"
  }, /*#__PURE__*/_react.default.createElement(_identicon.default, {
    className: "update-nickname__content__indenticon",
    address: address,
    diameter: 36,
    image: (_tokenList$address$to = tokenList[address.toLowerCase()]) === null || _tokenList$address$to === void 0 ? void 0 : _tokenList$address$to.iconUrl
  }), /*#__PURE__*/_react.default.createElement("label", {
    className: "update-nickname__content__label--capitalized"
  }, t('address')), /*#__PURE__*/_react.default.createElement("div", {
    className: "update-nickname__content__address"
  }, address), /*#__PURE__*/_react.default.createElement("div", {
    className: "update-nickname__content__nickname-label"
  }, t('nickname')), /*#__PURE__*/_react.default.createElement(_textField.default, {
    className: "update-nickname__content__text-field",
    value: nicknameInput,
    onChange: handleNicknameChange,
    placeholder: t('addANickname'),
    fullWidth: true
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "update-nickname__content__label--capitalized"
  }, t('memo')), /*#__PURE__*/_react.default.createElement(_textField.default, {
    type: "text",
    id: "memo",
    value: memoInput,
    onChange: handleMemoChange,
    placeholder: t('addMemo'),
    fullWidth: true,
    margin: "dense",
    multiline: true,
    rows: 3,
    classes: {
      inputMultiline: 'update-nickname__content__text-area',
      inputRoot: 'update-nickname__content__text-area-wrapper'
    }
  })));
}
UpdateNicknamePopover.propTypes = {
  nickname: _propTypes.default.string,
  address: _propTypes.default.string,
  memo: _propTypes.default.string,
  onAdd: _propTypes.default.func,
  onClose: _propTypes.default.func
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\update-nickname-popover\\update-nickname-popover.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\url-icon\\index.js", {"./url-icon":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\url-icon\\url-icon.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Curl-icon%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _urlIcon.default;
  }
});
var _urlIcon = _interopRequireDefault(require("./url-icon"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\url-icon\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\components\\ui\\url-icon\\url-icon.js", {"../icon-with-fallback":"D:\\code\\v\\metamask-extension\\ui\\components\\ui\\icon-with-fallback\\index.js","classnames":"D:\\code\\v\\metamask-extension\\node_modules\\classnames\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccomponents%5Cui%5Curl-icon%5Curl-icon.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = UrlIcon;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _iconWithFallback = _interopRequireDefault(require("../icon-with-fallback"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * @deprecated `<UrlIcon />` has been deprecated in favor of one of the avatar components `<AvatarNetwork />`, `<AvatarToken/>` or `<AvatarFavicon/>`
 * component in ./ui/components/component-library/avatar-token/
 * See storybook documentation for BannerAlert here:
 * {@see {@link https://metamask.github.io/metamask-storybook/?path=/docs/components-componentlibrary-avatartoken--docs}}
 *
 * Help to replace `UrlIcon` with `AvatarToken` by submitting a PR
 */

function UrlIcon({
  url,
  className,
  name,
  fallbackClassName
}) {
  return /*#__PURE__*/_react.default.createElement(_iconWithFallback.default, {
    className: (0, _classnames.default)('url-icon', className),
    icon: url,
    name: name,
    fallbackClassName: (0, _classnames.default)('url-icon__fallback', fallbackClassName)
  });
}
UrlIcon.propTypes = {
  url: _propTypes.default.string,
  className: _propTypes.default.string,
  name: _propTypes.default.string,
  fallbackClassName: _propTypes.default.string
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\components\\ui\\url-icon\\url-icon.js",}],
["D:\\code\\v\\metamask-extension\\ui\\constants\\index.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cconstants%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SEEDLESS_PASSWORD_OUTDATED_CHECK_INTERVAL_MS = exports.ETH_DEFAULT_DECIMALS = void 0;
const ETH_DEFAULT_DECIMALS = exports.ETH_DEFAULT_DECIMALS = 8;
const SEEDLESS_PASSWORD_OUTDATED_CHECK_INTERVAL_MS = exports.SEEDLESS_PASSWORD_OUTDATED_CHECK_INTERVAL_MS = 5 * 60 * 1000; // 5 minutes

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\constants\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\contexts\\assetPolling.tsx", {"../hooks/defi/useDeFiPolling":"D:\\code\\v\\metamask-extension\\ui\\hooks\\defi\\useDeFiPolling.ts","../hooks/useAccountTrackerPolling":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAccountTrackerPolling.ts","../hooks/useCurrencyRatePolling":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useCurrencyRatePolling.ts","../hooks/useMultichainAssetsRatesPolling":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainAssetsRatesPolling.ts","../hooks/useTokenDetectionPolling":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTokenDetectionPolling.ts","../hooks/useTokenListPolling":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTokenListPolling.ts","../hooks/useTokenRatesPolling":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTokenRatesPolling.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccontexts%5CassetPolling.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetPollingProvider = void 0;
var _react = _interopRequireDefault(require("react"));
var _useCurrencyRatePolling = _interopRequireDefault(require("../hooks/useCurrencyRatePolling"));
var _useTokenRatesPolling = _interopRequireDefault(require("../hooks/useTokenRatesPolling"));
var _useAccountTrackerPolling = _interopRequireDefault(require("../hooks/useAccountTrackerPolling"));
var _useTokenDetectionPolling = _interopRequireDefault(require("../hooks/useTokenDetectionPolling"));
var _useTokenListPolling = _interopRequireDefault(require("../hooks/useTokenListPolling"));
var _useDeFiPolling = _interopRequireDefault(require("../hooks/defi/useDeFiPolling"));
var _useMultichainAssetsRatesPolling = _interopRequireDefault(require("../hooks/useMultichainAssetsRatesPolling"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// This provider is a step towards making controller polling fully UI based.
// Eventually, individual UI components will call the use*Polling hooks to
// poll and return particular data. This polls globally in the meantime.
const AssetPollingProvider = ({
  children
}) => {
  (0, _useCurrencyRatePolling.default)();
  (0, _useTokenRatesPolling.default)();
  (0, _useAccountTrackerPolling.default)();
  (0, _useTokenDetectionPolling.default)();
  (0, _useTokenListPolling.default)();
  (0, _useDeFiPolling.default)();
  (0, _useMultichainAssetsRatesPolling.default)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
};
exports.AssetPollingProvider = AssetPollingProvider;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\contexts\\assetPolling.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\contexts\\gasFee.js", {"../pages/confirmations/hooks/useGasFeeInputs":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\hooks\\useGasFeeInputs.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccontexts%5CgasFee.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GasFeeContextProvider = exports.GasFeeContext = void 0;
exports.useGasFeeContext = useGasFeeContext;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _useGasFeeInputs = require("../pages/confirmations/hooks/useGasFeeInputs");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GasFeeContext = exports.GasFeeContext = /*#__PURE__*/(0, _react.createContext)({});
const GasFeeContextProvider = ({
  children,
  defaultEstimateToUse,
  transaction,
  minimumGasLimit,
  editGasMode
}) => {
  const gasFeeDetails = (0, _useGasFeeInputs.useGasFeeInputs)(defaultEstimateToUse, transaction, minimumGasLimit, editGasMode);
  return /*#__PURE__*/_react.default.createElement(GasFeeContext.Provider, {
    value: gasFeeDetails
  }, children);
};
exports.GasFeeContextProvider = GasFeeContextProvider;
function useGasFeeContext() {
  return (0, _react.useContext)(GasFeeContext);
}
GasFeeContextProvider.propTypes = {
  children: _propTypes.default.node.isRequired,
  defaultEstimateToUse: _propTypes.default.string,
  transaction: _propTypes.default.object,
  minimumGasLimit: _propTypes.default.string,
  editGasMode: _propTypes.default.string
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\contexts\\gasFee.js",}],
["D:\\code\\v\\metamask-extension\\ui\\contexts\\identity\\index.tsx", {"../../hooks/identity/useAccountSyncing":"D:\\code\\v\\metamask-extension\\ui\\hooks\\identity\\useAccountSyncing\\index.ts","../../hooks/identity/useAuthentication":"D:\\code\\v\\metamask-extension\\ui\\hooks\\identity\\useAuthentication\\index.ts","../../hooks/identity/useContactSyncing":"D:\\code\\v\\metamask-extension\\ui\\hooks\\identity\\useContactSyncing\\index.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccontexts%5Cidentity%5Cindex.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetamaskIdentityProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useAccountSyncing = require("../../hooks/identity/useAccountSyncing");
var _useContactSyncing = require("../../hooks/identity/useContactSyncing");
var _useAuthentication = require("../../hooks/identity/useAuthentication");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MetamaskIdentityProvider = ({
  children
}) => {
  const {
    dispatchAccountSyncing,
    shouldDispatchAccountSyncing
  } = (0, _useAccountSyncing.useAccountSyncing)();
  const {
    dispatchContactSyncing,
    shouldDispatchContactSyncing
  } = (0, _useContactSyncing.useContactSyncing)();
  const {
    autoSignIn,
    shouldAutoSignIn
  } = (0, _useAuthentication.useAutoSignIn)();
  const {
    autoSignOut,
    shouldAutoSignOut
  } = (0, _useAuthentication.useAutoSignOut)();

  /**
   * Backup and sync effects
   */
  (0, _react.useEffect)(() => {
    if (shouldDispatchAccountSyncing) {
      dispatchAccountSyncing();
    }
  }, [shouldDispatchAccountSyncing, dispatchAccountSyncing]);
  (0, _react.useEffect)(() => {
    if (shouldDispatchContactSyncing) {
      dispatchContactSyncing();
    }
  }, [shouldDispatchContactSyncing, dispatchContactSyncing]);

  /**
   * Authentication effects
   *
   * - Users should be automatically signed in based on various conditions. (see `useAutoSignIn`).
   * - Users should be signed out if basic functionality is disabled. (see `useAutoSignOut`)
   */
  (0, _react.useEffect)(() => {
    if (shouldAutoSignIn) {
      autoSignIn();
    }
  }, [shouldAutoSignIn, autoSignIn]);
  (0, _react.useEffect)(() => {
    if (shouldAutoSignOut) {
      autoSignOut();
    }
  }, [shouldAutoSignOut, autoSignOut]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
};
exports.MetamaskIdentityProvider = MetamaskIdentityProvider;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\contexts\\identity\\index.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\contexts\\metamask-notifications\\index.tsx", {"./metamask-notifications":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metamask-notifications\\metamask-notifications.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccontexts%5Cmetamask-notifications%5Cindex.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "MetamaskNotificationsProvider", {
  enumerable: true,
  get: function () {
    return _metamaskNotifications.MetamaskNotificationsProvider;
  }
});
var _metamaskNotifications = require("./metamask-notifications");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\contexts\\metamask-notifications\\index.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\contexts\\metamask-notifications\\metamask-notifications.tsx", {"../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../hooks/metamask-notifications/useNotifications":"D:\\code\\v\\metamask-extension\\ui\\hooks\\metamask-notifications\\useNotifications.ts","../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../selectors/identity/authentication":"D:\\code\\v\\metamask-extension\\ui\\selectors\\identity\\authentication.ts","../../selectors/metamask-notifications/metamask-notifications":"D:\\code\\v\\metamask-extension\\ui\\selectors\\metamask-notifications\\metamask-notifications.ts","./notification-storage-keys":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metamask-notifications\\notification-storage-keys.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccontexts%5Cmetamask-notifications%5Cmetamask-notifications.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetamaskNotificationsProvider = void 0;
exports.useBasicFunctionalityDisableEffect = useBasicFunctionalityDisableEffect;
exports.useEnableNotificationsByDefaultEffect = useEnableNotificationsByDefaultEffect;
exports.useFetchInitialNotificationsEffect = useFetchInitialNotificationsEffect;
exports.useMetamaskNotificationsContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _useNotifications = require("../../hooks/metamask-notifications/useNotifications");
var _metamaskNotifications = require("../../selectors/metamask-notifications/metamask-notifications");
var _selectors = require("../../selectors");
var _metamask = require("../../ducks/metamask/metamask");
var _authentication = require("../../selectors/identity/authentication");
var _notificationStorageKeys = require("./notification-storage-keys");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MetamaskNotificationsContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const useMetamaskNotificationsContext = () => {
  const context = (0, _react.useContext)(MetamaskNotificationsContext);
  if (!context) {
    throw new Error('useNotificationsContext must be used within a MetamaskNotificationsProvider');
  }
  return context;
};
exports.useMetamaskNotificationsContext = useMetamaskNotificationsContext;
const useDisableAndRefresh = () => {
  const {
    disableNotifications
  } = (0, _useNotifications.useDisableNotifications)();
  const {
    listNotifications
  } = (0, _useNotifications.useListNotifications)();
  return (0, _react.useCallback)(async () => {
    await disableNotifications();
    await listNotifications();
  }, [disableNotifications, listNotifications]);
};
const useEnableAndRefresh = () => {
  const {
    enableNotifications
  } = (0, _useNotifications.useEnableNotifications)();
  const {
    listNotifications
  } = (0, _useNotifications.useListNotifications)();
  return (0, _react.useCallback)(async (shouldEnable = true) => {
    shouldEnable && (await enableNotifications());
    await listNotifications();
  }, [enableNotifications, listNotifications]);
};
function useBasicFunctionalityDisableEffect() {
  const isBasicFunctionalityEnabled = (0, _reactRedux.useSelector)(_selectors.getUseExternalServices);
  const isNotificationsEnabled = (0, _reactRedux.useSelector)(_metamaskNotifications.selectIsMetamaskNotificationsEnabled);
  const disableAndRefresh = useDisableAndRefresh();
  (0, _react.useEffect)(() => {
    const run = async () => {
      try {
        if (!isBasicFunctionalityEnabled && isNotificationsEnabled) {
          await disableAndRefresh();
        }
      } catch {
        // Do nothing
      }
    };
    run();
  }, [disableAndRefresh, isBasicFunctionalityEnabled, isNotificationsEnabled]);
}
function useFetchInitialNotificationsEffect() {
  const isNotificationsEnabled = (0, _reactRedux.useSelector)(_metamaskNotifications.selectIsMetamaskNotificationsEnabled);
  const isBasicFunctionalityEnabled = (0, _reactRedux.useSelector)(_selectors.getUseExternalServices);
  const isUnlocked = (0, _reactRedux.useSelector)(_metamask.getIsUnlocked);
  const isSignedIn = (0, _reactRedux.useSelector)(_authentication.selectIsSignedIn);
  const shouldFetchNotifications = Boolean(isNotificationsEnabled) && Boolean(isSignedIn);
  const enableAndRefresh = useEnableAndRefresh();
  (0, _react.useEffect)(() => {
    const run = async () => {
      try {
        if (isBasicFunctionalityEnabled && shouldFetchNotifications && isUnlocked) {
          await enableAndRefresh(await (0, _notificationStorageKeys.hasNotificationSubscriptionExpired)());
        }
      } catch {
        // Do nothing
      }
    };
    run();
  }, [shouldFetchNotifications, isBasicFunctionalityEnabled, isUnlocked, enableAndRefresh]);
}
function useEnableNotificationsByDefaultEffect() {
  const isNotificationsEnabled = (0, _reactRedux.useSelector)(_metamaskNotifications.selectIsMetamaskNotificationsEnabled);
  const isBasicFunctionalityEnabled = (0, _reactRedux.useSelector)(_selectors.getUseExternalServices);
  const isUnlocked = (0, _reactRedux.useSelector)(_metamask.getIsUnlocked);
  const isNotificationsEnabledByDefaultFeatureFlag = (0, _reactRedux.useSelector)(_metamaskNotifications.getIsNotificationEnabledByDefaultFeatureFlag);
  const enableAndRefresh = useEnableAndRefresh();
  (0, _react.useEffect)(() => {
    const run = async () => {
      try {
        if (!isNotificationsEnabled && isBasicFunctionalityEnabled && isUnlocked && isNotificationsEnabledByDefaultFeatureFlag) {
          if (!(await (0, _notificationStorageKeys.hasUserTurnedOffNotificationsOnce)())) {
            await enableAndRefresh();
          }
        }
      } catch {
        // Do nothing
      }
    };
    run();
  }, [enableAndRefresh, isBasicFunctionalityEnabled, isNotificationsEnabled, isNotificationsEnabledByDefaultFeatureFlag, isUnlocked]);
}
const MetamaskNotificationsProvider = ({
  children
}) => {
  const {
    listNotifications,
    notificationsData,
    isLoading,
    error
  } = (0, _useNotifications.useListNotifications)();

  // Basic functionality effect
  useBasicFunctionalityDisableEffect();

  // Update subscriptions and fetch notifications
  useFetchInitialNotificationsEffect();

  // Enable notifications by default for users
  useEnableNotificationsByDefaultEffect();
  return /*#__PURE__*/_react.default.createElement(MetamaskNotificationsContext.Provider, {
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    value: {
      listNotifications,
      notificationsData,
      isLoading,
      error
    }
  }, children);
};
exports.MetamaskNotificationsProvider = MetamaskNotificationsProvider;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\contexts\\metamask-notifications\\metamask-notifications.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\contexts\\metamask-notifications\\notification-storage-keys.ts", {"../../../shared/lib/storage-helpers":"D:\\code\\v\\metamask-extension\\shared\\lib\\storage-helpers.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccontexts%5Cmetamask-notifications%5Cnotification-storage-keys.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateNotificationSubscriptionExpiration = exports.setUserHasTurnedOffNotificationsOnce = exports.hasUserTurnedOffNotificationsOnce = exports.hasNotificationSubscriptionExpired = exports.RESUBSCRIBE_NOTIFICATIONS_KEY = exports.RESUBSCRIBE_NOTIFICATIONS_EXPIRY_DURATION_MS = exports.HAS_USER_TURNED_OFF_ONCE_NOTIFICATIONS_KEY = void 0;
var _storageHelpers = require("../../../shared/lib/storage-helpers");
/**
 * Used to track when/how often we should re-subscribe users to notifications.
 * It ensures that users notification subscriptions are kept up to date (in case our backend adds new support for certian notifications)
 * And ensures that any push notification subscriptions are up-to-date
 */
const RESUBSCRIBE_NOTIFICATIONS_KEY = exports.RESUBSCRIBE_NOTIFICATIONS_KEY = 'RESUBSCRIBE_NOTIFICATIONS_EXPIRY';
const RESUBSCRIBE_NOTIFICATIONS_EXPIRY_DURATION_MS = exports.RESUBSCRIBE_NOTIFICATIONS_EXPIRY_DURATION_MS = 24 * 60 * 60 * 1000; // 1 day

const hasNotificationSubscriptionExpired = async () => {
  const expiryTimestamp = await (0, _storageHelpers.getStorageItem)(RESUBSCRIBE_NOTIFICATIONS_KEY);
  if (!expiryTimestamp) {
    return true;
  }
  const now = Date.now();
  return now > parseInt(expiryTimestamp, 10);
};
exports.hasNotificationSubscriptionExpired = hasNotificationSubscriptionExpired;
const updateNotificationSubscriptionExpiration = async () => {
  const now = Date.now();
  const expiryTimestamp = now + RESUBSCRIBE_NOTIFICATIONS_EXPIRY_DURATION_MS;
  await (0, _storageHelpers.setStorageItem)(RESUBSCRIBE_NOTIFICATIONS_KEY, expiryTimestamp.toString());
};

/**
 * Tracks if a user has turned off notifications before
 * It ensures that we don't accidentally turn on notifications during our auto-enable notification effects (enable notifications by default)
 */
exports.updateNotificationSubscriptionExpiration = updateNotificationSubscriptionExpiration;
const HAS_USER_TURNED_OFF_ONCE_NOTIFICATIONS_KEY = exports.HAS_USER_TURNED_OFF_ONCE_NOTIFICATIONS_KEY = 'NOTIFICATIONS_TURNED_OFF_ONCE';
const hasUserTurnedOffNotificationsOnce = async () => {
  const hasTurnedOffOnce = await (0, _storageHelpers.getStorageItem)(HAS_USER_TURNED_OFF_ONCE_NOTIFICATIONS_KEY);
  return Boolean(hasTurnedOffOnce);
};
exports.hasUserTurnedOffNotificationsOnce = hasUserTurnedOffNotificationsOnce;
const setUserHasTurnedOffNotificationsOnce = async () => {
  await (0, _storageHelpers.setStorageItem)(HAS_USER_TURNED_OFF_ONCE_NOTIFICATIONS_KEY, true);
};
exports.setUserHasTurnedOffNotificationsOnce = setUserHasTurnedOffNotificationsOnce;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\contexts\\metamask-notifications\\notification-storage-keys.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js", {"../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../shared/lib/sentry":"D:\\code\\v\\metamask-extension\\shared\\lib\\sentry.ts","../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../hooks/useSegmentContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useSegmentContext.js","../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../store/background-connection":"D:\\code\\v\\metamask-extension\\ui\\store\\background-connection.ts","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccontexts%5Cmetametrics.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetaMetricsContext = exports.LegacyMetaMetricsProvider = void 0;
exports.MetaMetricsProvider = MetaMetricsProvider;
exports.withMetaMetrics = withMetaMetrics;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _lodash = require("lodash");
var _sentry = require("../../shared/lib/sentry");
var _util = require("../../app/scripts/lib/util");
var _routes = require("../helpers/constants/routes");
var _metametrics = require("../../shared/constants/metametrics");
var _useSegmentContext = require("../hooks/useSegmentContext");
var _selectors = require("../selectors");
var _backgroundConnection = require("../store/background-connection");
var _actions = require("../store/actions");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /**
 * This file is intended to be renamed to metametrics.js once the conversion is complete.
 * MetaMetrics is our own brand, and should remain aptly named regardless of the underlying
 * metrics system. This file implements Segment analytics tracking.
 */ // TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths
// type imports
/**
 * @typedef {__import__('../../shared/constants/metametrics').UnsanitizedMetaMetricsEventPayload} MetaMetricsEventPayload
 * @typedef {__import__('../../shared/constants/metametrics').MetaMetricsEventOptions} MetaMetricsEventOptions
 * @typedef {__import__('../../shared/constants/metametrics').MetaMetricsPageObject} MetaMetricsPageObject
 * @typedef {__import__('../../shared/constants/metametrics').MetaMetricsReferrerObject} MetaMetricsReferrerObject
 * @typedef {__import__('../../shared/lib/trace').TraceRequest} TraceRequest
 * @typedef {__import__('../../shared/lib/trace').EndTraceRequest} EndTraceRequest
 * @typedef {__import__('../../shared/lib/trace').TraceCallback} TraceCallback
 */

// types
/**
 * @typedef {Omit<MetaMetricsEventPayload, 'environmentType' | 'page' | 'referrer'>} UIMetricsEventPayload
 */
/**
 * @typedef {(
 *  payload: UIMetricsEventPayload,
 *  options?: MetaMetricsEventOptions
 * ) => Promise<void>} UITrackEventMethod
 */

/**
 * @typedef {<T>(request: TraceRequest, fn?: TraceCallback<T>) => Promise<T | undefined>} UITraceMethod
 */

/**
 * @typedef {(request: EndTraceRequest) => void} UIEndTraceMethod
 */

/**
 * @typedef {UITrackEventMethod & {
 *   bufferedTrace?: UITraceMethod,
 *   bufferedEndTrace?: UIEndTraceMethod,
 *   onboardingParentContext?: React.MutableRefObject<Span | null>
 * }} MetaMetricsContextValue
 */

/**
 * @type {React.Context<MetaMetricsContextValue>}
 */
const MetaMetricsContext = exports.MetaMetricsContext = /*#__PURE__*/(0, _react.createContext)(() => {
  (0, _sentry.captureException)(Error(`MetaMetrics context function was called from a react node that is not a descendant of a MetaMetrics context provider`));
});
function MetaMetricsProvider({
  children
}) {
  var _context$page2;
  const location = (0, _reactRouterDom.useLocation)();
  const context = (0, _useSegmentContext.useSegmentContext)();
  const isMetricsEnabled = (0, _reactRedux.useSelector)(_selectors.getParticipateInMetaMetrics);

  /** @type {React.MutableRefObject<Span | null>} */
  const onboardingParentContext = (0, _react.useRef)(null);

  // Sometimes we want to track context properties inside the event's "properties" object.
  const addContextPropsIntoEventProperties = (0, _react.useCallback)((payload, options) => {
    const fields = options === null || options === void 0 ? void 0 : options.contextPropsIntoEventProperties;
    if (!fields || fields.length === 0) {
      return;
    }
    if (!payload.properties) {
      payload.properties = {};
    }
    if (fields.includes(_metametrics.MetaMetricsContextProp.PageTitle)) {
      var _context$page;
      payload.properties[_metametrics.MetaMetricsContextProp.PageTitle] = (_context$page = context.page) === null || _context$page === void 0 ? void 0 : _context$page.title;
    }
  }, [(_context$page2 = context.page) === null || _context$page2 === void 0 ? void 0 : _context$page2.title]);

  /**
   * @type {UITrackEventMethod}
   */
  const trackEvent = (0, _react.useCallback)(async (payload, options) => {
    addContextPropsIntoEventProperties(payload, options);
    const fullPayload = {
      ...payload,
      environmentType: (0, _util.getEnvironmentType)(),
      ...context
    };
    if (isMetricsEnabled) {
      // If metrics are enabled, track immediately
      (0, _actions.trackMetaMetricsEvent)(fullPayload, options);
    } else {
      // If metrics are not enabled, buffer the event
      await (0, _backgroundConnection.submitRequestToBackground)('addEventBeforeMetricsOptIn', [{
        ...fullPayload,
        actionId: (0, _backgroundConnection.generateActionId)()
      }]);
    }
  }, [addContextPropsIntoEventProperties, context, isMetricsEnabled]);

  /**
   * @type {UITraceMethod}
   */
  const bufferedTrace = (0, _react.useCallback)((request, fn) => {
    (0, _backgroundConnection.submitRequestToBackground)('bufferedTrace', [request, fn]);
  }, []);

  /**
   * @type {UIEndTraceMethod}
   */
  const bufferedEndTrace = (0, _react.useCallback)(request => {
    (0, _backgroundConnection.submitRequestToBackground)('bufferedEndTrace', [request]);
  }, []);

  // Used to prevent double tracking page calls
  const previousMatch = (0, _react.useRef)();

  /**
   * Anytime the location changes, track a page change with segment.
   * Previously we would manually track changes to history and keep a
   * reference to the previous url, but with page tracking we can see
   * which page the user is on and their navigation path.
   */
  (0, _react.useEffect)(() => {
    const environmentType = (0, _util.getEnvironmentType)();
    const match = (0, _reactRouterDom.matchPath)(location.pathname, {
      path: (0, _routes.getPaths)(),
      exact: true,
      strict: true
    });
    // Start by checking for a missing match route. If this falls through to
    // the else if, then we know we have a matched route for tracking.
    if (!match) {
      (0, _sentry.captureMessage)(`Segment page tracking found unmatched route`, {
        extra: {
          previousMatch,
          currentPath: location.pathname
        }
      });
    } else if (previousMatch.current !== match.path && !(environmentType === 'notification' && match.path === '/' && previousMatch.current === undefined)) {
      // When a notification window is open by a Dapp we do not want to track
      // the initial home route load that can sometimes happen. To handle
      // this we keep track of the previousMatch, and we skip the event track
      // in the event that we are dealing with the initial load of the
      // homepage
      const {
        path,
        params
      } = match;
      const name = _routes.PATH_NAME_MAP.get(path);
      (0, _actions.trackMetaMetricsPage)({
        name,
        // We do not want to send addresses or accounts in any events
        // Some routes include these as params.
        params: (0, _lodash.omit)(params, ['account', 'address']),
        environmentType,
        page: context.page,
        referrer: context.referrer
      }, {
        isOptInPath: location.pathname.startsWith('/initialize')
      });
    }
    previousMatch.current = match === null || match === void 0 ? void 0 : match.path;
  }, [location, context]);

  // For backwards compatibility, attach the new methods as properties to trackEvent
  const trackEventWithMethods = trackEvent;
  trackEventWithMethods.bufferedTrace = bufferedTrace;
  trackEventWithMethods.bufferedEndTrace = bufferedEndTrace;
  trackEventWithMethods.onboardingParentContext = onboardingParentContext;
  return /*#__PURE__*/_react.default.createElement(MetaMetricsContext.Provider, {
    value: trackEventWithMethods
  }, children);
}
MetaMetricsProvider.propTypes = {
  children: _propTypes.default.node
};
class LegacyMetaMetricsProvider extends _react.Component {
  getChildContext() {
    const trackEventWithMethods = this.context;
    return {
      trackEvent: trackEventWithMethods,
      bufferedTrace: trackEventWithMethods === null || trackEventWithMethods === void 0 ? void 0 : trackEventWithMethods.bufferedTrace,
      bufferedEndTrace: trackEventWithMethods === null || trackEventWithMethods === void 0 ? void 0 : trackEventWithMethods.bufferedEndTrace
    };
  }
  render() {
    return this.props.children;
  }
}

/**
 * HOC for class components to access MetaMetricsContext
 *
 * @param {React.ComponentType} WrappedComponent - Component to wrap
 * @returns {React.ComponentType} Wrapped component with MetaMetrics context
 */
exports.LegacyMetaMetricsProvider = LegacyMetaMetricsProvider;
_defineProperty(LegacyMetaMetricsProvider, "propTypes", {
  children: _propTypes.default.node
});
_defineProperty(LegacyMetaMetricsProvider, "defaultProps", {
  children: undefined
});
_defineProperty(LegacyMetaMetricsProvider, "contextType", MetaMetricsContext);
_defineProperty(LegacyMetaMetricsProvider, "childContextTypes", {
  // This has to be different than the type name for the old metametrics file
  // using the same name would result in whichever was lower in the tree to be
  // used.
  trackEvent: _propTypes.default.func,
  bufferedTrace: _propTypes.default.func,
  bufferedEndTrace: _propTypes.default.func
});
function withMetaMetrics(WrappedComponent) {
  const WithMetaMetrics = props => {
    const metaMetricsContext = (0, _react.useContext)(MetaMetricsContext);
    return /*#__PURE__*/_react.default.createElement(WrappedComponent, _extends({}, props, {
      trackEvent: metaMetricsContext,
      bufferedTrace: metaMetricsContext === null || metaMetricsContext === void 0 ? void 0 : metaMetricsContext.bufferedTrace,
      bufferedEndTrace: metaMetricsContext === null || metaMetricsContext === void 0 ? void 0 : metaMetricsContext.bufferedEndTrace,
      onboardingParentContext: metaMetricsContext === null || metaMetricsContext === void 0 ? void 0 : metaMetricsContext.onboardingParentContext
    }));
  };
  WithMetaMetrics.displayName = `withMetaMetrics(${WrappedComponent.displayName || WrappedComponent.name || 'Component'})`;
  return WithMetaMetrics;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\contexts\\metametrics.js",}],
["D:\\code\\v\\metamask-extension\\ui\\contexts\\shield\\shield-subscription.tsx", {"../../../shared/modules/environment":"D:\\code\\v\\metamask-extension\\shared\\modules\\environment.ts","../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../hooks/subscription/useSubscription":"D:\\code\\v\\metamask-extension\\ui\\hooks\\subscription\\useSubscription.ts","../../hooks/useAccountTotalFiatBalance":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAccountTotalFiatBalance.js","../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../selectors/identity/authentication":"D:\\code\\v\\metamask-extension\\ui\\selectors\\identity\\authentication.ts","../../selectors/subscription":"D:\\code\\v\\metamask-extension\\ui\\selectors\\subscription\\index.ts","../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","@metamask/subscription-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\subscription-controller\\dist\\index.cjs","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccontexts%5Cshield%5Cshield-subscription.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useShieldSubscriptionContext = exports.ShieldSubscriptionProvider = exports.ShieldSubscriptionContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _subscriptionController = require("@metamask/subscription-controller");
var _loglevel = _interopRequireDefault(require("loglevel"));
var _useSubscription = require("../../hooks/subscription/useSubscription");
var _actions = require("../../store/actions");
var _selectors = require("../../selectors");
var _useAccountTotalFiatBalance = require("../../hooks/useAccountTotalFiatBalance");
var _authentication = require("../../selectors/identity/authentication");
var _environment = require("../../../shared/modules/environment");
var _subscription = require("../../selectors/subscription");
var _metamask = require("../../ducks/metamask/metamask");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ShieldSubscriptionContext = exports.ShieldSubscriptionContext = /*#__PURE__*/_react.default.createContext({
  resetShieldEntryModalShownStatus: () => {
    // Default empty function
  },
  setShieldEntryModalShownStatus: () => {
    // Default empty function
  }
});
const useShieldSubscriptionContext = () => {
  const context = (0, _react.useContext)(ShieldSubscriptionContext);
  if (!context) {
    throw new Error('useShieldSubscriptionContext must be used within a ShieldSubscriptionProvider');
  }
  return context;
};
exports.useShieldSubscriptionContext = useShieldSubscriptionContext;
const ShieldSubscriptionProvider = ({
  children
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const isBasicFunctionalityEnabled = Boolean((0, _reactRedux.useSelector)(_selectors.getUseExternalServices));
  const isMetaMaskShieldFeatureEnabled = (0, _environment.getIsMetaMaskShieldFeatureEnabled)();
  const isUnlocked = (0, _reactRedux.useSelector)(_metamask.getIsUnlocked);
  const isSignedIn = (0, _reactRedux.useSelector)(_authentication.selectIsSignedIn);
  const isShieldSubscriptionActive = (0, _reactRedux.useSelector)(_subscription.getIsActiveShieldSubscription);
  const hasShieldEntryModalShownOnce = (0, _reactRedux.useSelector)(_subscription.getHasShieldEntryModalShownOnce);
  const selectedAccount = (0, _reactRedux.useSelector)(_selectors.getSelectedInternalAccount);
  const {
    getSubscriptionEligibility: getShieldSubscriptionEligibility
  } = (0, _useSubscription.useSubscriptionEligibility)(_subscriptionController.PRODUCT_TYPES.SHIELD);
  const {
    totalFiatBalance
  } = (0, _useAccountTotalFiatBalance.useAccountTotalFiatBalance)(selectedAccount, false, true // use USD conversion rate instead of the current currency
  );

  /**
   * Check if the user's balance criteria is met to show the shield entry modal.
   * Shield entry modal will be shown if:
   * - Subscription is not active
   * - User is signed in
   * - User has a balance greater than the minimum fiat balance threshold (1K USD)
   * - User has not shown the shield entry modal before
   */
  const evaluateShieldEntryPointModal = (0, _react.useCallback)(async () => {
    try {
      if (isShieldSubscriptionActive) {
        dispatch((0, _actions.setShowShieldEntryModalOnce)(false));
        return;
      } else if (!selectedAccount || !isSignedIn || !isUnlocked || hasShieldEntryModalShownOnce) {
        return;
      }
      const shieldSubscriptionEligibility = await getShieldSubscriptionEligibility();
      if (shieldSubscriptionEligibility !== null && shieldSubscriptionEligibility !== void 0 && shieldSubscriptionEligibility.canSubscribe && shieldSubscriptionEligibility !== null && shieldSubscriptionEligibility !== void 0 && shieldSubscriptionEligibility.canViewEntryModal && shieldSubscriptionEligibility !== null && shieldSubscriptionEligibility !== void 0 && shieldSubscriptionEligibility.minBalanceUSD && totalFiatBalance && Number(totalFiatBalance) >= (shieldSubscriptionEligibility === null || shieldSubscriptionEligibility === void 0 ? void 0 : shieldSubscriptionEligibility.minBalanceUSD)) {
        const shouldSubmitUserEvents = true; // submits `shield_entry_modal_viewed` event
        dispatch((0, _actions.setShowShieldEntryModalOnce)(true, shouldSubmitUserEvents));
      }
    } catch (error) {
      _loglevel.default.warn('[getIsUserBalanceCriteriaMet] error', error);
    }
  }, [isShieldSubscriptionActive, getShieldSubscriptionEligibility, selectedAccount, isSignedIn, isUnlocked, totalFiatBalance, hasShieldEntryModalShownOnce, dispatch]);
  (0, _react.useEffect)(() => {
    if (!isMetaMaskShieldFeatureEnabled || !isBasicFunctionalityEnabled) {
      return;
    }
    evaluateShieldEntryPointModal();
  }, [dispatch, isMetaMaskShieldFeatureEnabled, evaluateShieldEntryPointModal, isBasicFunctionalityEnabled]);
  (0, _react.useEffect)(() => {
    if (selectedAccount && isSignedIn && isUnlocked) {
      // start polling for the subscriptions
      dispatch((0, _actions.subscriptionsStartPolling)());
    }
  }, [isSignedIn, selectedAccount, dispatch, isUnlocked]);
  const resetShieldEntryModalShownStatus = (0, _react.useCallback)(() => {
    if (!isShieldSubscriptionActive) {
      dispatch((0, _actions.setShowShieldEntryModalOnce)(null));
    }
  }, [isShieldSubscriptionActive, dispatch]);
  const setShieldEntryModalShownStatus = (0, _react.useCallback)(showShieldEntryModalOnce => {
    if (!isShieldSubscriptionActive) {
      const shouldSubmitUserEvents = Boolean(showShieldEntryModalOnce); // submits `shield_entry_modal_viewed` event
      dispatch((0, _actions.setShowShieldEntryModalOnce)(showShieldEntryModalOnce, shouldSubmitUserEvents));
    }
  }, [dispatch, isShieldSubscriptionActive]);
  return /*#__PURE__*/_react.default.createElement(ShieldSubscriptionContext.Provider, {
    value: {
      resetShieldEntryModalShownStatus,
      setShieldEntryModalShownStatus
    }
  }, children);
};
exports.ShieldSubscriptionProvider = ShieldSubscriptionProvider;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\contexts\\shield\\shield-subscription.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\contexts\\snaps\\index.ts", {"./snap-interface":"D:\\code\\v\\metamask-extension\\ui\\contexts\\snaps\\snap-interface.tsx"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccontexts%5Csnaps%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _snapInterface = require("./snap-interface");
Object.keys(_snapInterface).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _snapInterface[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _snapInterface[key];
    }
  });
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\contexts\\snaps\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\contexts\\snaps\\snap-interface.tsx", {"../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./utils":"D:\\code\\v\\metamask-extension\\ui\\contexts\\snaps\\utils.ts","@metamask/snaps-sdk":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccontexts%5Csnaps%5Csnap-interface.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapInterfaceContextProvider = exports.SnapInterfaceContext = void 0;
exports.useSnapInterfaceContext = useSnapInterfaceContext;
var _snapsSdk = require("@metamask/snaps-sdk");
var _snapsUtils = require("@metamask/snaps-utils");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _actions = require("../../store/actions");
var _utils = require("./utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SnapInterfaceContext = exports.SnapInterfaceContext = /*#__PURE__*/(0, _react.createContext)(null);
/**
 * The Snap interface context provider that handles all the interface state operations.
 *
 * @param params - The context provider params.
 * @param params.children - The childrens to wrap with the context provider.
 * @param params.interfaceId - The interface ID to use.
 * @param params.snapId - The Snap ID that requested the interface.
 * @param params.initialState - The initial state of the interface.
 * @returns The context provider.
 */
const SnapInterfaceContextProvider = ({
  children,
  interfaceId,
  snapId,
  initialState
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();

  // We keep an internal copy of the state to speed up the state update in the
  // UI. It's kept in a ref to avoid useless re-rendering of the entire tree of
  // components.
  const internalState = (0, _react.useRef)(initialState ?? {});
  const focusedInput = (0, _react.useRef)(null);

  // Since the internal state is kept in a reference, it won't update when the
  // interface is updated. We have to manually update it.
  (0, _react.useEffect)(() => {
    internalState.current = initialState;
  }, [initialState]);
  const handleSnapRequest = (event, name, value) => {
    (0, _actions.handleSnapRequest)({
      snapId,
      origin: 'metamask',
      handler: 'onUserInput',
      request: {
        jsonrpc: '2.0',
        method: ' ',
        params: {
          event: {
            type: event,
            // TODO: Allow null in the types and simplify this
            ...(name !== undefined && name !== null ? {
              name
            } : {}),
            ...(value !== undefined && value !== null ? {
              value
            } : {})
          },
          id: interfaceId
        }
      }
    }).then(() => (0, _actions.forceUpdateMetamaskState)(dispatch)).catch(error => {
      console.error(`Failed to handle Snap request to "${snapId}" for event "${event}" with name "${name}":`, error);
    });
  };
  const updateState = state => dispatch((0, _actions.updateInterfaceState)(interfaceId, state));

  /**
   * Handle the submission of an user input event to the Snap.
   *
   * @param options - An options bag.
   * @param options.event - The event type.
   * @param options.name - The name of the component emitting the event.
   * @param options.value - The value of the component emitting the event.
   */
  const handleEvent = ({
    event,
    name,
    value = name ? internalState.current[name] : undefined
  }) => handleSnapRequest(event, name, value);
  const submitInputChange = (name, value) => handleEvent({
    event: _snapsSdk.UserInputEventType.InputChangeEvent,
    name,
    value
  });

  /**
   * Handle the value change of an input.
   *
   * @param name - The name of the input.
   * @param value - The new value.
   * @param form - The name of the form containing the input.
   * Optional if the input is not contained in a form.
   */
  const handleInputChange = (name, value, form) => {
    const state = (0, _utils.mergeValue)(internalState.current, name, value, form);
    internalState.current = state;
    updateState(state);
    submitInputChange(name, value);
  };
  const uploadFile = (name, file) => {
    (0, _actions.handleSnapRequest)({
      snapId,
      origin: 'metamask',
      handler: 'onUserInput',
      request: {
        jsonrpc: '2.0',
        method: ' ',
        params: {
          event: {
            type: _snapsSdk.UserInputEventType.FileUploadEvent,
            ...(name === undefined ? {} : {
              name
            }),
            ...(file === undefined ? {} : {
              file
            })
          },
          id: interfaceId
        }
      }
    }).then(() => (0, _actions.forceUpdateMetamaskState)(dispatch));
  };

  /**
   * Handle the file change of an input.
   *
   * @param name - The name of the input.
   * @param file - The file to upload.
   * @param form - The name of the form containing the input.
   */
  const handleFileChange = (name, file, form) => {
    if (file) {
      file.arrayBuffer().then(arrayBuffer => new Uint8Array(arrayBuffer)).then(uint8Array => (0, _snapsUtils.encodeBase64)(uint8Array)).then(base64 => {
        const fileObject = {
          name: file.name,
          size: file.size,
          contentType: file.type,
          contents: base64
        };
        const state = (0, _utils.mergeValue)(internalState.current, name, fileObject, form);
        internalState.current = state;
        updateState(state);
        uploadFile(name, fileObject);
      });
      return;
    }
    const state = (0, _utils.mergeValue)(internalState.current, name, null, form);
    internalState.current = state;
    updateState(state);
    uploadFile(name, null);
  };

  /**
   * Get the value of an input from the interface state.
   *
   * @param name - The name of the input.
   * @param form - The name of the form containing the input.
   * Optional if the input is not contained in a form.
   * @returns The value of the input or undefinded if the input has no value.
   */
  const getValue = (name, form) => {
    var _initialState$form;
    const value = form ? (_initialState$form = initialState[form]) === null || _initialState$form === void 0 ? void 0 : _initialState$form[name] : initialState === null || initialState === void 0 ? void 0 : initialState[name];
    if (value !== undefined && value !== null) {
      return value;
    }
    return undefined;
  };
  const setCurrentFocusedInput = name => focusedInput.current = name;
  return /*#__PURE__*/_react.default.createElement(SnapInterfaceContext.Provider, {
    value: {
      handleEvent,
      getValue,
      handleInputChange,
      handleFileChange,
      setCurrentFocusedInput,
      focusedInput: focusedInput.current,
      snapId
    }
  }, children);
};

/**
 * The utility hook to consume the Snap inteface context.
 *
 * @returns The snap interface context.
 */
exports.SnapInterfaceContextProvider = SnapInterfaceContextProvider;
function useSnapInterfaceContext() {
  return (0, _react.useContext)(SnapInterfaceContext);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\contexts\\snaps\\snap-interface.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\contexts\\snaps\\utils.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccontexts%5Csnaps%5Cutils.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mergeValue = void 0;
/**
 * Merge a new input value in the interface state.
 *
 * @param state - The current interface state.
 * @param name - The input name.
 * @param value - The input value.
 * @param form - The name of the form containing the input.
 * Optional if the input is not contained in a form.
 * @returns The interface state with the new value merged in.
 */
const mergeValue = (state, name, value, form) => {
  if (form) {
    return {
      ...state,
      [form]: {
        ...state[form],
        [name]: value
      }
    };
  }
  return {
    ...state,
    [name]: value
  };
};
exports.mergeValue = mergeValue;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\contexts\\snaps\\utils.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\contexts\\transaction-modal.js", {"prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Ccontexts%5Ctransaction-modal.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionModalContextProvider = exports.TransactionModalContext = void 0;
exports.useTransactionModalContext = useTransactionModalContext;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TransactionModalContext = exports.TransactionModalContext = /*#__PURE__*/(0, _react.createContext)({});
const TransactionModalContextProvider = ({
  children
}) => {
  const [openModals, setOpenModals] = (0, _react.useState)([]);
  const closeModal = modalNames => {
    if (openModals < 0) {
      return;
    }
    const modals = [...openModals];
    modalNames.forEach(modal => {
      const index = openModals.indexOf(modal);
      modals.splice(index, 1);
    });
    setOpenModals(modals);
  };
  const closeAllModals = () => {
    setOpenModals([]);
  };
  const openModal = modalName => {
    if (openModals.includes(modalName)) {
      return;
    }
    const modals = [...openModals];
    modals.push(modalName);
    setOpenModals(modals);
  };
  return /*#__PURE__*/_react.default.createElement(TransactionModalContext.Provider, {
    value: {
      closeModal,
      closeAllModals,
      currentModal: openModals[openModals.length - 1],
      openModal,
      openModalCount: openModals.length
    }
  }, children);
};

/**
 * @returns {{openModal: (modalName: string) => void}}
 */
exports.TransactionModalContextProvider = TransactionModalContextProvider;
function useTransactionModalContext() {
  return (0, _react.useContext)(TransactionModalContext);
}
TransactionModalContextProvider.propTypes = {
  children: _propTypes.default.node.isRequired
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\contexts\\transaction-modal.js",}],
["D:\\code\\v\\metamask-extension\\ui\\ducks\\alerts\\index.js", {"./enums":"D:\\code\\v\\metamask-extension\\ui\\ducks\\alerts\\enums.js","./invalid-custom-network":"D:\\code\\v\\metamask-extension\\ui\\ducks\\alerts\\invalid-custom-network.js","./unconnected-account":"D:\\code\\v\\metamask-extension\\ui\\ducks\\alerts\\unconnected-account.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cducks%5Calerts%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ALERT_STATE", {
  enumerable: true,
  get: function () {
    return _enums.ALERT_STATE;
  }
});
Object.defineProperty(exports, "invalidCustomNetwork", {
  enumerable: true,
  get: function () {
    return _invalidCustomNetwork.default;
  }
});
Object.defineProperty(exports, "unconnectedAccount", {
  enumerable: true,
  get: function () {
    return _unconnectedAccount.default;
  }
});
var _unconnectedAccount = _interopRequireDefault(require("./unconnected-account"));
var _invalidCustomNetwork = _interopRequireDefault(require("./invalid-custom-network"));
var _enums = require("./enums");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\ducks\\alerts\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\ducks\\alerts\\invalid-custom-network.js", {"../../../shared/constants/alerts":"D:\\code\\v\\metamask-extension\\shared\\constants\\alerts.ts","./enums":"D:\\code\\v\\metamask-extension\\ui\\ducks\\alerts\\enums.js","@reduxjs/toolkit":"D:\\code\\v\\metamask-extension\\node_modules\\@reduxjs\\toolkit\\dist\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cducks%5Calerts%5Cinvalid-custom-network.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openAlert = exports.getNetworkName = exports.getAlertState = exports.dismissAlert = exports.default = exports.alertIsOpen = void 0;
var _toolkit = require("@reduxjs/toolkit");
var _alerts = require("../../../shared/constants/alerts");
var _enums = require("./enums");
// Constants

const name = _alerts.AlertTypes.invalidCustomNetwork;
const initialState = {
  state: _enums.ALERT_STATE.CLOSED,
  networkName: ''
};

// Slice (reducer plus auto-generated actions and action creators)

const slice = (0, _toolkit.createSlice)({
  name,
  initialState,
  reducers: {
    openAlert: (state, action) => {
      state.state = _enums.ALERT_STATE.OPEN;
      state.networkName = action.payload;
    },
    dismissAlert: state => {
      state.state = _enums.ALERT_STATE.CLOSED;
      state.networkName = '';
    }
  }
});
const {
  actions,
  reducer
} = slice;
var _default = exports.default = reducer; // Selectors
const getAlertState = state => state[name].state;
exports.getAlertState = getAlertState;
const getNetworkName = state => state[name].networkName;
exports.getNetworkName = getNetworkName;
const alertIsOpen = state => state[name].state !== _enums.ALERT_STATE.CLOSED;

// Actions / action-creators
exports.alertIsOpen = alertIsOpen;
const {
  openAlert,
  dismissAlert
} = actions;
exports.dismissAlert = dismissAlert;
exports.openAlert = openAlert;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\ducks\\alerts\\invalid-custom-network.js",}],
["D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge-status\\actions.ts", {"../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../store/background-connection":"D:\\code\\v\\metamask-extension\\ui\\store\\background-connection.ts","@metamask/bridge-status-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-status-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cducks%5Cbridge-status%5Cactions.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.submitBridgeTx = void 0;
var _bridgeStatusController = require("@metamask/bridge-status-controller");
var _actions = require("../../store/actions");
var _backgroundConnection = require("../../store/background-connection");
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
const callBridgeStatusControllerMethod = (bridgeAction, args) => {
  return async dispatch => {
    const result = await (0, _backgroundConnection.submitRequestToBackground)(bridgeAction, args);
    await (0, _actions.forceUpdateMetamaskState)(dispatch);
    return result;
  };
};

/**
 * Submit a solana bridge or swap transaction using the bridge status controller
 *
 * @param accountAddress
 * @param quote
 * @param isStxSupportedInClient
 * @returns
 */
const submitBridgeTx = (accountAddress, quote, isStxSupportedInClient) => {
  return async dispatch => {
    return dispatch(callBridgeStatusControllerMethod(_bridgeStatusController.BridgeStatusAction.SUBMIT_TX, [accountAddress, quote, isStxSupportedInClient]));
  };
};
exports.submitBridgeTx = submitBridgeTx;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\ducks\\bridge-status\\actions.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge-status\\selectors.ts", {"../../../shared/lib/transactions-controller-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\transactions-controller-utils.js","../../../shared/modules/Numeric":"D:\\code\\v\\metamask-extension\\shared\\modules\\Numeric.ts","../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","reselect":"D:\\code\\v\\metamask-extension\\node_modules\\reselect\\dist\\cjs\\reselect.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cducks%5Cbridge-status%5Cselectors.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectReceivedSwapsTokenAmountFromTxMeta = exports.selectIncomingBridgeHistory = exports.selectBridgeHistoryItemForTxMetaId = exports.selectBridgeHistoryForApprovalTxId = exports.selectBridgeHistoryForAccountGroup = void 0;
var _reselect = require("reselect");
var _Numeric = require("../../../shared/modules/Numeric");
var _networks = require("../../../shared/modules/selectors/networks");
var _transactionsControllerUtils = require("../../../shared/lib/transactions-controller-utils");
var _accountTree = require("../../selectors/multichain-accounts/account-tree");
const selectBridgeHistory = state => state.metamask.txHistory;
const selectBridgeHistoryForAccount = (0, _reselect.createSelector)([(_, selectedAddresses) => selectedAddresses, selectBridgeHistory], (selectedAddresses, txHistory) => {
  if (!selectedAddresses || selectedAddresses.length === 0) {
    return txHistory;
  }
  return Object.keys(txHistory).reduce((acc, txMetaId) => {
    const txHistoryItem = txHistory[txMetaId];
    if (selectedAddresses.includes(txHistoryItem.account)) {
      acc[txMetaId] = txHistoryItem;
    }
    return acc;
  }, {});
});

/**
 * Returns a mapping of srcTxMetaId to txHistoryItem for the selected address
 * If no address is provided, return all bridge history items for all addresses
 *
 * @param state - the state object
 * @returns A mapping of srcTxMetaId to txHistoryItem for the selected address
 */
const selectBridgeHistoryForAccountGroup = exports.selectBridgeHistoryForAccountGroup = (0, _reselect.createSelector)([selectBridgeHistory, _accountTree.getSelectedAccountGroup, state => state], (txHistory, selectedAccountGroup, state) => {
  if (!selectedAccountGroup) {
    return txHistory;
  }
  const internalAccountAddresses = (0, _accountTree.getInternalAccountsFromGroupById)(state, selectedAccountGroup).map(internalAccount => internalAccount.address);
  return selectBridgeHistoryForAccount(state, internalAccountAddresses);
});
const selectBridgeHistoryItemForTxMetaId = exports.selectBridgeHistoryItemForTxMetaId = (0, _reselect.createSelector)([selectBridgeHistory, (_, txMetaId) => txMetaId], (bridgeHistory, txMetaId) => {
  if (!txMetaId) {
    return undefined;
  }
  return bridgeHistory[txMetaId];
});

// eslint-disable-next-line jsdoc/require-param
/**
 * Returns a bridge history item for a given approval tx id
 */
const selectBridgeHistoryForApprovalTxId = exports.selectBridgeHistoryForApprovalTxId = (0, _reselect.createSelector)([selectBridgeHistory, (_, approvalTxId) => approvalTxId], (bridgeHistory, approvalTxId) => {
  return Object.values(bridgeHistory).find(bridgeHistoryItem => bridgeHistoryItem.approvalTxId === approvalTxId);
});
const selectReceivedSwapsTokenAmountFromTxMeta = exports.selectReceivedSwapsTokenAmountFromTxMeta = (0, _reselect.createSelector)([selectBridgeHistoryItemForTxMetaId,
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
(_, __, txMeta) => txMeta,
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
(_, __, ___, approvalTxMeta) => approvalTxMeta], (bridgeHistoryItem, txMeta, approvalTxMeta) => {
  if (!bridgeHistoryItem) {
    return null;
  }
  const {
    quote: {
      destAsset
    },
    account
  } = bridgeHistoryItem;
  return (0, _transactionsControllerUtils.getSwapsTokensReceivedFromTxMeta)(destAsset.symbol, txMeta, destAsset.address, account, destAsset.decimals, approvalTxMeta, destAsset.chainId);
});

/**
 * Returns an array of sorted bridge history items for when the user's current chain is the destination chain for a bridge tx
 */
const selectIncomingBridgeHistory = exports.selectIncomingBridgeHistory = (0, _reselect.createSelector)(selectBridgeHistoryForAccountGroup, _networks.getCurrentChainId, (bridgeHistory, currentChainId) => {
  // Get all history items with dest chain that matches current chain
  return Object.values(bridgeHistory).filter(bridgeHistoryItem => {
    const hexDestChainId = new _Numeric.Numeric(bridgeHistoryItem.quote.destChainId, 10).toPrefixedHexString();
    return hexDestChainId === currentChainId;
  }).sort((a, b) => {
    if (a.startTime && b.startTime) {
      return b.startTime - a.startTime;
    }
    return 0;
  });
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\ducks\\bridge-status\\selectors.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\actions.ts", {"../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../store/background-connection":"D:\\code\\v\\metamask-extension\\ui\\store\\background-connection.ts","./bridge":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\bridge.ts","./utils":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\utils.ts","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cducks%5Cbridge%5Cactions.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.restoreQuoteRequestFromState = exports.resetInputFields = exports.resetBridgeState = void 0;
Object.defineProperty(exports, "setDestTokenExchangeRates", {
  enumerable: true,
  get: function () {
    return _bridge.setDestTokenExchangeRates;
  }
});
Object.defineProperty(exports, "setDestTokenUsdExchangeRates", {
  enumerable: true,
  get: function () {
    return _bridge.setDestTokenUsdExchangeRates;
  }
});
Object.defineProperty(exports, "setEVMSrcNativeBalance", {
  enumerable: true,
  get: function () {
    return _bridge.setEVMSrcNativeBalance;
  }
});
exports.setSortOrder = exports.setSlippage = exports.setSelectedQuote = exports.setFromTokenInputValue = exports.setFromToken = exports.setFromChain = exports.setEVMSrcTokenBalance = void 0;
Object.defineProperty(exports, "setSrcTokenExchangeRates", {
  enumerable: true,
  get: function () {
    return _bridge.setSrcTokenExchangeRates;
  }
});
exports.setToToken = exports.setToChainId = void 0;
Object.defineProperty(exports, "setTxAlerts", {
  enumerable: true,
  get: function () {
    return _bridge.setTxAlerts;
  }
});
exports.updateQuoteRequestParams = exports.trackUnifiedSwapBridgeEvent = exports.setWasTxDeclined = void 0;
var _bridgeController = require("@metamask/bridge-controller");
var _trace = require("../../../shared/lib/trace");
var _actions = require("../../store/actions");
var _backgroundConnection = require("../../store/background-connection");
var _bridge = require("./bridge");
var _utils = require("./utils");
const {
  setToChainId,
  setFromToken,
  setToToken,
  setFromTokenInputValue,
  resetInputFields,
  setSortOrder,
  setSelectedQuote,
  setWasTxDeclined,
  setSlippage,
  restoreQuoteRequestFromState
} = _bridge.bridgeSlice.actions;
exports.restoreQuoteRequestFromState = restoreQuoteRequestFromState;
exports.setSlippage = setSlippage;
exports.setWasTxDeclined = setWasTxDeclined;
exports.setSelectedQuote = setSelectedQuote;
exports.setSortOrder = setSortOrder;
exports.resetInputFields = resetInputFields;
exports.setFromTokenInputValue = setFromTokenInputValue;
exports.setToToken = setToToken;
exports.setFromToken = setFromToken;
exports.setToChainId = setToChainId;
const callBridgeControllerMethod = (bridgeAction, ...args) => {
  return async dispatch => {
    await (0, _backgroundConnection.submitRequestToBackground)(bridgeAction, args);
    await (0, _actions.forceUpdateMetamaskState)(dispatch);
  };
};

// Background actions
const resetBridgeState = () => {
  return async dispatch => {
    dispatch(resetInputFields());
    dispatch(callBridgeControllerMethod(_bridgeController.BridgeBackgroundAction.RESET_STATE));
  };
};
exports.resetBridgeState = resetBridgeState;
const trackUnifiedSwapBridgeEvent = (eventName, propertiesFromClient) => {
  return async dispatch => {
    await dispatch(callBridgeControllerMethod(_bridgeController.BridgeBackgroundAction.TRACK_METAMETRICS_EVENT, eventName, propertiesFromClient));
  };
};

// User actions
exports.trackUnifiedSwapBridgeEvent = trackUnifiedSwapBridgeEvent;
const updateQuoteRequestParams = (...[params, context]) => {
  return async dispatch => {
    await dispatch(callBridgeControllerMethod(_bridgeController.BridgeUserAction.UPDATE_QUOTE_PARAMS, params, context));
  };
};
exports.updateQuoteRequestParams = updateQuoteRequestParams;
const setEVMSrcTokenBalance = (token, selectedAddress) => {
  return async dispatch => {
    if (token) {
      (0, _trace.trace)({
        name: _trace.TraceName.BridgeBalancesUpdated,
        data: {
          srcChainId: (0, _bridgeController.formatChainIdToCaip)(token.chainId),
          isNative: (0, _bridgeController.isNativeAddress)(token.address)
        },
        startTime: Date.now()
      });
      await dispatch((0, _bridge.setEVMSrcTokenBalance)({
        selectedAddress,
        tokenAddress: token.address,
        chainId: token.chainId
      }));
    }
  };
};
exports.setEVMSrcTokenBalance = setEVMSrcTokenBalance;
const setFromChain = ({
  networkConfig,
  selectedAccount,
  token = null
}) => {
  return async dispatch => {
    if (!networkConfig) {
      return;
    }

    // Check for ALL non-EVM chains
    const isNonEvm = (0, _utils.isNonEvmChain)(networkConfig.chainId);

    // Set the src network
    if (isNonEvm) {
      dispatch((0, _actions.setActiveNetworkWithError)(networkConfig.chainId));
    } else {
      var _networkConfig$rpcEnd;
      const networkId = (0, _utils.isNetworkAdded)(networkConfig) ? (_networkConfig$rpcEnd = networkConfig.rpcEndpoints) === null || _networkConfig$rpcEnd === void 0 || (_networkConfig$rpcEnd = _networkConfig$rpcEnd[networkConfig.defaultRpcEndpointIndex]) === null || _networkConfig$rpcEnd === void 0 ? void 0 : _networkConfig$rpcEnd.networkClientId : null;
      if (networkId) {
        dispatch((0, _actions.setActiveNetworkWithError)(networkId));
      }
    }

    // Set the src token - if no token provided, set native token for non-EVM chains
    if (token) {
      dispatch(setFromToken(token));
    } else if (isNonEvm) {
      // Auto-select native token for non-EVM chains when switching
      const nativeAsset = (0, _bridgeController.getNativeAssetForChainId)(networkConfig.chainId);
      if (nativeAsset) {
        dispatch(setFromToken({
          ...nativeAsset,
          chainId: networkConfig.chainId
        }));
      }
    }

    // Fetch the native balance (EVM only)
    if (selectedAccount && !isNonEvm) {
      (0, _trace.trace)({
        name: _trace.TraceName.BridgeBalancesUpdated,
        data: {
          srcChainId: (0, _bridgeController.formatChainIdToCaip)(networkConfig.chainId),
          isNative: true
        },
        startTime: Date.now()
      });
      await dispatch((0, _bridge.setEVMSrcNativeBalance)({
        selectedAddress: selectedAccount.address,
        chainId: networkConfig.chainId
      }));
    }
  };
};
exports.setFromChain = setFromChain;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\ducks\\bridge\\actions.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\bridge.ts", {"../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../shared/modules/bridge-utils/security-alerts-api.util":"D:\\code\\v\\metamask-extension\\shared\\modules\\bridge-utils\\security-alerts-api.util.ts","./utils":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\utils.ts","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","@reduxjs/toolkit":"D:\\code\\v\\metamask-extension\\node_modules\\@reduxjs\\toolkit\\dist\\index.js","ethereumjs-util":"D:\\code\\v\\metamask-extension\\node_modules\\ethereumjs-util\\dist.browser\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cducks%5Cbridge%5Cbridge.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setTxAlerts = exports.setSrcTokenExchangeRates = exports.setEVMSrcTokenBalance = exports.setEVMSrcNativeBalance = exports.setDestTokenUsdExchangeRates = exports.setDestTokenExchangeRates = exports.default = exports.bridgeSlice = void 0;
var _toolkit = require("@reduxjs/toolkit");
var _bridgeController = require("@metamask/bridge-controller");
var _ethereumjsUtil = require("ethereumjs-util");
var _securityAlertsApi = require("../../../shared/modules/bridge-utils/security-alerts-api.util");
var _trace = require("../../../shared/lib/trace");
var _utils = require("./utils");
const initialState = {
  toChainId: null,
  fromToken: null,
  toToken: null,
  fromTokenInputValue: null,
  fromTokenExchangeRate: null,
  toTokenExchangeRate: null,
  toTokenUsdExchangeRate: null,
  fromTokenBalance: null,
  fromNativeBalance: null,
  sortOrder: _bridgeController.SortOrder.COST_ASC,
  selectedQuote: null,
  wasTxDeclined: false,
  slippage: _bridgeController.BRIDGE_DEFAULT_SLIPPAGE,
  txAlert: null
};
const setSrcTokenExchangeRates = exports.setSrcTokenExchangeRates = (0, _toolkit.createAsyncThunk)('bridge/setSrcTokenExchangeRates', _utils.getTokenExchangeRate);
const setDestTokenExchangeRates = exports.setDestTokenExchangeRates = (0, _toolkit.createAsyncThunk)('bridge/setDestTokenExchangeRates', _utils.getTokenExchangeRate);
const setDestTokenUsdExchangeRates = exports.setDestTokenUsdExchangeRates = (0, _toolkit.createAsyncThunk)('bridge/setDestTokenUsdExchangeRates', _utils.getTokenExchangeRate);
const setTxAlerts = exports.setTxAlerts = (0, _toolkit.createAsyncThunk)('bridge/setTxAlerts', _securityAlertsApi.fetchTxAlerts);
const getBalanceAmount = async ({
  selectedAddress,
  tokenAddress,
  chainId
}) => {
  var _await$calcLatestSrcB;
  if ((0, _bridgeController.isNonEvmChainId)(chainId) || !selectedAddress) {
    return null;
  }
  return (_await$calcLatestSrcB = await (0, _bridgeController.calcLatestSrcBalance)(global.ethereumProvider, selectedAddress, tokenAddress, (0, _bridgeController.formatChainIdToHex)(chainId))) === null || _await$calcLatestSrcB === void 0 ? void 0 : _await$calcLatestSrcB.toString();
};
const setEVMSrcNativeBalance = exports.setEVMSrcNativeBalance = (0, _toolkit.createAsyncThunk)('bridge/setEVMSrcNativeBalance', async ({
  selectedAddress,
  chainId
}) => await getBalanceAmount({
  selectedAddress,
  tokenAddress: (0, _ethereumjsUtil.zeroAddress)(),
  chainId
}));
const setEVMSrcTokenBalance = exports.setEVMSrcTokenBalance = (0, _toolkit.createAsyncThunk)('bridge/setEVMSrcTokenBalance', getBalanceAmount);
const bridgeSlice = exports.bridgeSlice = (0, _toolkit.createSlice)({
  name: 'bridge',
  initialState: {
    ...initialState
  },
  reducers: {
    setToChainId: (state, {
      payload
    }) => {
      state.toChainId = payload ? (0, _bridgeController.formatChainIdToCaip)(payload) : null;
      state.toToken = null;
    },
    setFromToken: (state, {
      payload
    }) => {
      var _state$fromToken, _state$toToken, _state$fromToken$asse, _state$toToken$assetI;
      state.fromToken = (0, _utils.toBridgeToken)(payload);
      state.fromTokenBalance = null;
      // Unset toToken if it's the same as the fromToken
      if ((_state$fromToken = state.fromToken) !== null && _state$fromToken !== void 0 && _state$fromToken.assetId && (_state$toToken = state.toToken) !== null && _state$toToken !== void 0 && _state$toToken.assetId &&
      // TODO: determine if this is necessary.
      ((_state$fromToken$asse = state.fromToken.assetId) === null || _state$fromToken$asse === void 0 ? void 0 : _state$fromToken$asse.toLowerCase()) === ((_state$toToken$assetI = state.toToken.assetId) === null || _state$toToken$assetI === void 0 ? void 0 : _state$toToken$assetI.toLowerCase())) {
        state.toToken = null;
      }
    },
    setToToken: (state, {
      payload
    }) => {
      var _getNativeAssetForCha;
      const toToken = (0, _utils.toBridgeToken)(payload);
      state.toToken = toToken ? {
        ...toToken,
        address: toToken.address || ((_getNativeAssetForCha = (0, _bridgeController.getNativeAssetForChainId)(toToken.chainId)) === null || _getNativeAssetForCha === void 0 ? void 0 : _getNativeAssetForCha.address)
      } : toToken;
      // Update toChainId if it's different from the toToken chainId
      if (toToken !== null && toToken !== void 0 && toToken.chainId && (state.toChainId ? (0, _bridgeController.formatChainIdToCaip)(toToken.chainId) !== (0, _bridgeController.formatChainIdToCaip)(state.toChainId) : true)) {
        state.toChainId = (0, _bridgeController.formatChainIdToCaip)(toToken.chainId);
      }
    },
    setFromTokenInputValue: (state, {
      payload
    }) => {
      state.fromTokenInputValue = payload;
    },
    resetInputFields: () => ({
      ...initialState
    }),
    restoreQuoteRequestFromState: (state, {
      payload: quote
    }) => {
      state.fromToken = (0, _utils.toBridgeToken)(quote.srcAsset);
      state.toToken = (0, _utils.toBridgeToken)(quote.destAsset);
      state.toChainId = (0, _bridgeController.formatChainIdToCaip)(quote.destChainId);
    },
    setSortOrder: (state, action) => {
      state.sortOrder = action.payload;
    },
    setSelectedQuote: (state, action) => {
      state.selectedQuote = action.payload;
    },
    setWasTxDeclined: (state, action) => {
      state.wasTxDeclined = action.payload;
    },
    setSlippage: (state, action) => {
      state.slippage = action.payload;
    }
  },
  extraReducers: builder => {
    builder.addCase(setDestTokenExchangeRates.pending, state => {
      state.toTokenExchangeRate = null;
    });
    builder.addCase(setDestTokenUsdExchangeRates.pending, state => {
      state.toTokenUsdExchangeRate = null;
    });
    builder.addCase(setSrcTokenExchangeRates.pending, state => {
      state.fromTokenExchangeRate = null;
    });
    builder.addCase(setDestTokenExchangeRates.fulfilled, (state, action) => {
      state.toTokenExchangeRate = action.payload ?? null;
    });
    builder.addCase(setDestTokenUsdExchangeRates.fulfilled, (state, action) => {
      state.toTokenUsdExchangeRate = action.payload ?? null;
    });
    builder.addCase(setSrcTokenExchangeRates.fulfilled, (state, action) => {
      state.fromTokenExchangeRate = action.payload ?? null;
    });
    builder.addCase(setTxAlerts.pending, state => {
      state.txAlert = null;
    });
    builder.addCase(setTxAlerts.fulfilled, (state, action) => {
      state.txAlert = action.payload;
    });
    builder.addCase(setTxAlerts.rejected, state => {
      state.txAlert = null;
    });
    builder.addCase(setEVMSrcTokenBalance.fulfilled, (state, action) => {
      var _state$fromToken2, _state$fromToken3;
      const isTokenInChain = !(0, _bridgeController.isCrossChain)(action.meta.arg.chainId, (_state$fromToken2 = state.fromToken) === null || _state$fromToken2 === void 0 ? void 0 : _state$fromToken2.chainId);
      if (isTokenInChain && (_state$fromToken3 = state.fromToken) !== null && _state$fromToken3 !== void 0 && _state$fromToken3.address ? action.meta.arg.tokenAddress === state.fromToken.address : true) {
        var _action$payload;
        state.fromTokenBalance = ((_action$payload = action.payload) === null || _action$payload === void 0 ? void 0 : _action$payload.toString()) ?? null;
      }
      (0, _trace.endTrace)({
        name: _trace.TraceName.BridgeBalancesUpdated
      });
    });
    builder.addCase(setEVMSrcTokenBalance.rejected, state => {
      state.fromTokenBalance = null;
      (0, _trace.endTrace)({
        name: _trace.TraceName.BridgeBalancesUpdated
      });
    });
    builder.addCase(setEVMSrcNativeBalance.fulfilled, (state, action) => {
      var _action$payload2;
      state.fromNativeBalance = ((_action$payload2 = action.payload) === null || _action$payload2 === void 0 ? void 0 : _action$payload2.toString()) ?? null;
      (0, _trace.endTrace)({
        name: _trace.TraceName.BridgeBalancesUpdated
      });
    });
    builder.addCase(setEVMSrcNativeBalance.rejected, state => {
      state.fromNativeBalance = null;
      (0, _trace.endTrace)({
        name: _trace.TraceName.BridgeBalancesUpdated
      });
    });
  }
});
var _default = exports.default = bridgeSlice.reducer;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\ducks\\bridge\\bridge.ts",}]],[],{})

//# sourceMappingURL=data:application/json;charset=utf8;base64,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