LavaPack.loadBundle([
["D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\selectors.ts", {"../../../shared/constants/bridge":"D:\\code\\v\\metamask-extension\\shared\\constants\\bridge.ts","../../../shared/constants/hardware-wallets":"D:\\code\\v\\metamask-extension\\shared\\constants\\hardware-wallets.ts","../../../shared/constants/multichain/assets":"D:\\code\\v\\metamask-extension\\shared\\constants\\multichain\\assets.ts","../../../shared/constants/multichain/networks":"D:\\code\\v\\metamask-extension\\shared\\constants\\multichain\\networks.ts","../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../shared/lib/asset-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\asset-utils.ts","../../../shared/modules/Numeric":"D:\\code\\v\\metamask-extension\\shared\\modules\\Numeric.ts","../../../shared/modules/selectors":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\index.ts","../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../shared/modules/selectors/util":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\util.js","../../selectors/accounts":"D:\\code\\v\\metamask-extension\\ui\\selectors\\accounts.ts","../../selectors/assets":"D:\\code\\v\\metamask-extension\\ui\\selectors\\assets.ts","../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","../../selectors/multichain/networks":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain\\networks.ts","../../selectors/remote-feature-flags":"D:\\code\\v\\metamask-extension\\ui\\selectors\\remote-feature-flags.ts","../../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","./utils":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\utils.ts","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/notification-services-controller/push-services":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\notification-services-controller\\dist\\NotificationServicesPushController\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","bignumber.js":"D:\\code\\v\\metamask-extension\\node_modules\\bignumber.js\\bignumber.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","reselect":"D:\\code\\v\\metamask-extension\\node_modules\\reselect\\dist\\cjs\\reselect.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cducks%5Cbridge%5Cselectors.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectNoFeeAssets = exports.needsSolanaAccountForDestination = exports.needsBitcoinAccountForDestination = exports.getWasTxDeclined = exports.getValidationErrors = exports.getTxAlerts = exports.getTopAssetsFromFeatureFlags = exports.getToTokenConversionRate = exports.getToToken = exports.getToChains = exports.getToChain = exports.getToAccounts = exports.getSlippage = exports.getQuoteRequest = exports.getQuoteRefreshRate = exports.getPriceImpactThresholds = exports.getLastSelectedChainId = exports.getIsToOrFromNonEvm = exports.getIsSwap = exports.getIsStxEnabled = exports.getIsSolanaSwap = exports.getIsQuoteExpired = exports.getIsGasIncluded = exports.getIsBridgeTx = exports.getHardwareWalletName = exports.getFromTokenConversionRate = exports.getFromTokenBalance = exports.getFromToken = exports.getFromChains = exports.getFromChain = exports.getFromAmountInCurrency = exports.getFromAmount = exports.getFromAccount = exports.getDefaultTokenPair = exports.getBridgeSortOrder = exports.getBridgeQuotes = exports.getAllBridgeableNetworks = exports.getAccountGroupNameByInternalAccount = void 0;
var _bridgeController = require("@metamask/bridge-controller");
var _keyringApi = require("@metamask/keyring-api");
var _lodash = require("lodash");
var _reselect = require("reselect");
var _bignumber = require("bignumber.js");
var _pushServices = require("@metamask/notification-services-controller/push-services");
var _utils = require("@metamask/utils");
var _networks = require("../../../shared/constants/multichain/networks");
var _selectors = require("../../selectors/selectors");
var _bridge = require("../../../shared/constants/bridge");
var _util = require("../../../shared/modules/selectors/util");
var _networks2 = require("../../../shared/modules/selectors/networks");
var _network = require("../../../shared/constants/network");
var _multichain = require("../../selectors/multichain");
var _assets = require("../../selectors/assets");
var _hardwareWallets = require("../../../shared/constants/hardware-wallets");
var _assetUtils = require("../../../shared/lib/asset-utils");
var _assets2 = require("../../../shared/constants/multichain/assets");
var _Numeric = require("../../../shared/modules/Numeric");
var _selectors2 = require("../../../shared/modules/selectors");
var _accounts = require("../../selectors/accounts");
var _remoteFeatureFlags = require("../../selectors/remote-feature-flags");
var _accountTree = require("../../selectors/multichain-accounts/account-tree");
var _networks3 = require("../../selectors/multichain/networks");
var _utils2 = require("./utils");
/**
 * Helper function to determine the CAIP asset type for non-EVM native assets
 *
 * @param chainId - The chain ID
 * @param address - The asset address
 * @param assetId - The asset ID
 * @returns The appropriate CAIP asset type string
 */
const getNonEvmNativeAssetType = (chainId, address, assetId) => {
  if ((0, _bridgeController.isSolanaChainId)(chainId)) {
    return (0, _bridgeController.isNativeAddress)(address) ? _assets2.MULTICHAIN_NATIVE_CURRENCY_TO_CAIP19.SOL : assetId ?? address;
  }
  if ((0, _bridgeController.isBitcoinChainId)(chainId)) {
    // Bitcoin bridge only supports mainnet
    return _assets2.MULTICHAIN_NATIVE_CURRENCY_TO_CAIP19.BTC;
  }
  return assetId ?? address;
};
// checks if the user has any solana accounts created
const hasSolanaAccounts = state => {
  var _state$metamask$inter;
  // Access accounts from the state
  const accounts = ((_state$metamask$inter = state.metamask.internalAccounts) === null || _state$metamask$inter === void 0 ? void 0 : _state$metamask$inter.accounts) || {};

  // Check if any account is a Solana account
  return Object.values(accounts).some(account => {
    const {
      DataAccount
    } = _keyringApi.SolAccountType;
    return Boolean(account && account.type === DataAccount);
  });
};

// checks if the user has any bitcoin accounts created
const hasBitcoinAccounts = state => {
  var _state$metamask$inter2;
  // Access accounts from the state
  const accounts = ((_state$metamask$inter2 = state.metamask.internalAccounts) === null || _state$metamask$inter2 === void 0 ? void 0 : _state$metamask$inter2.accounts) || {};

  // Check if any account is a Bitcoin account
  return Object.values(accounts).some(account => {
    const {
      P2wpkh
    } = _keyringApi.BtcAccountType;
    return Boolean(account && account.type === P2wpkh);
  });
};

// only includes networks user has added
const getAllBridgeableNetworks = exports.getAllBridgeableNetworks = (0, _util.createDeepEqualSelector)(_networks2.getNetworkConfigurationsByChainId, networkConfigurationsByChainId => {
  return (0, _lodash.uniqBy)([...Object.values(networkConfigurationsByChainId),
  // TODO: get this from network controller, use placeholder values for now
  {
    ..._networks.MULTICHAIN_PROVIDER_CONFIGS[_networks.MultichainNetworks.SOLANA],
    blockExplorerUrls: [],
    name: _networks.MULTICHAIN_PROVIDER_CONFIGS[_networks.MultichainNetworks.SOLANA].nickname,
    nativeCurrency: _networks.MULTICHAIN_PROVIDER_CONFIGS[_networks.MultichainNetworks.SOLANA].ticker,
    rpcEndpoints: [{
      url: '',
      type: '',
      networkClientId: ''
    }],
    defaultRpcEndpointIndex: 0,
    chainId: _networks.MultichainNetworks.SOLANA
  }], 'chainId').filter(({
    chainId
  }) => _bridge.ALLOWED_BRIDGE_CHAIN_IDS.includes(chainId));
});
const getBridgeFeatureFlags = (0, _util.createDeepEqualSelector)([state => (0, _remoteFeatureFlags.getRemoteFeatureFlags)(state).bridgeConfig], bridgeConfig => {
  const validatedFlags = (0, _bridgeController.selectBridgeFeatureFlags)({
    remoteFeatureFlags: {
      bridgeConfig
    }
  });
  return validatedFlags;
});
const getPriceImpactThresholds = exports.getPriceImpactThresholds = (0, _util.createDeepEqualSelector)(getBridgeFeatureFlags, bridgeFeatureFlags => bridgeFeatureFlags === null || bridgeFeatureFlags === void 0 ? void 0 : bridgeFeatureFlags.priceImpactThreshold);
const getFromChains = exports.getFromChains = (0, _util.createDeepEqualSelector)(getAllBridgeableNetworks, getBridgeFeatureFlags, state => hasSolanaAccounts(state), state => hasBitcoinAccounts(state), (allBridgeableNetworks, bridgeFeatureFlags, hasSolanaAccount, hasBitcoinAccount) => {
  // First filter out Solana from source chains if no Solana account exists
  let filteredNetworks = hasSolanaAccount ? allBridgeableNetworks : allBridgeableNetworks.filter(({
    chainId
  }) => !(0, _bridgeController.isSolanaChainId)(chainId));

  // Then filter out Bitcoin from source chains if no Bitcoin account exists
  filteredNetworks = hasBitcoinAccount ? filteredNetworks : filteredNetworks.filter(({
    chainId
  }) => !(0, _bridgeController.isBitcoinChainId)(chainId));

  // Then apply the standard filter for active source chains
  return filteredNetworks.filter(({
    chainId
  }) => {
    var _bridgeFeatureFlags$c;
    return (_bridgeFeatureFlags$c = bridgeFeatureFlags.chains[(0, _bridgeController.formatChainIdToCaip)(chainId)]) === null || _bridgeFeatureFlags$c === void 0 ? void 0 : _bridgeFeatureFlags$c.isActiveSrc;
  });
});

/**
 * This matches the network filter in the activity and asset lists
 */
const getLastSelectedChainId = exports.getLastSelectedChainId = (0, _reselect.createSelector)([_networks3.getAllEnabledNetworksForAllNamespaces], allEnabledNetworksForAllNamespaces => {
  return allEnabledNetworksForAllNamespaces[0];
});

// This returns undefined if the selected chain is not supported by swap/bridge (i.e, testnets)
const getFromChain = exports.getFromChain = (0, _util.createDeepEqualSelector)([getFromChains, _multichain.getMultichainProviderConfig], (fromChains, providerConfig) => {
  // When the page loads the global network always matches the network filter
  // Because useBridging checks whether the lastSelectedNetwork matches the provider config
  // Then useBridgeQueryParams sets the global network to lastSelectedNetwork as needed
  // TODO remove providerConfig references and just use getLastSelectedChainId
  return fromChains.find(({
    chainId
  }) => chainId === (providerConfig === null || providerConfig === void 0 ? void 0 : providerConfig.chainId));
});
const getToChains = exports.getToChains = (0, _util.createDeepEqualSelector)(getAllBridgeableNetworks, getBridgeFeatureFlags, getFromChain, (allBridgeableNetworks, bridgeFeatureFlags, fromChain) => {
  const availableChains = (0, _lodash.uniqBy)([...allBridgeableNetworks, ..._network.FEATURED_RPCS], 'chainId').filter(({
    chainId
  }) => {
    var _bridgeFeatureFlags$c2;
    return bridgeFeatureFlags === null || bridgeFeatureFlags === void 0 || (_bridgeFeatureFlags$c2 = bridgeFeatureFlags.chains) === null || _bridgeFeatureFlags$c2 === void 0 || (_bridgeFeatureFlags$c2 = _bridgeFeatureFlags$c2[(0, _bridgeController.formatChainIdToCaip)(chainId)]) === null || _bridgeFeatureFlags$c2 === void 0 ? void 0 : _bridgeFeatureFlags$c2.isActiveDest;
  });

  // Prevent Bitcoin from being selected as destination when source is Bitcoin
  // (Bitcoin bridge only supports Bitcoin <-> EVM chains, not Bitcoin <-> Bitcoin)
  if (fromChain && (0, _bridgeController.isBitcoinChainId)(fromChain.chainId)) {
    return availableChains.filter(({
      chainId
    }) => !(0, _bridgeController.isBitcoinChainId)(chainId));
  }

  // Similarly, prevent Solana from being selected as destination when source is Solana
  // if (fromChain && isSolanaChainId(fromChain.chainId)) {
  //   return availableChains.filter(({ chainId }) => !isSolanaChainId(chainId));
  // }

  return availableChains;
});
const getTopAssetsFromFeatureFlags = (state, chainId) => {
  var _bridgeFeatureFlags$c3;
  if (!chainId) {
    return undefined;
  }
  const bridgeFeatureFlags = getBridgeFeatureFlags(state);
  return bridgeFeatureFlags === null || bridgeFeatureFlags === void 0 || (_bridgeFeatureFlags$c3 = bridgeFeatureFlags.chains[(0, _bridgeController.formatChainIdToCaip)(chainId)]) === null || _bridgeFeatureFlags$c3 === void 0 ? void 0 : _bridgeFeatureFlags$c3.topAssets;
};

// If the user has selected a toChainId, return it as the destination chain
// Otherwise, use the source chain as the destination chain (default to swap params)
exports.getTopAssetsFromFeatureFlags = getTopAssetsFromFeatureFlags;
const getToChain = exports.getToChain = (0, _reselect.createSelector)([getFromChain, getToChains, state => {
  var _state$bridge;
  return (_state$bridge = state.bridge) === null || _state$bridge === void 0 ? void 0 : _state$bridge.toChainId;
}], (fromChain, toChains, toChainId) => toChainId ? toChains.find(({
  chainId
}) => chainId === toChainId || (0, _bridgeController.formatChainIdToCaip)(chainId) === toChainId) : fromChain);
const getDefaultTokenPair = exports.getDefaultTokenPair = (0, _util.createDeepEqualSelector)([state => {
  var _getFromChain;
  return (_getFromChain = getFromChain(state)) === null || _getFromChain === void 0 ? void 0 : _getFromChain.chainId;
}, state => getBridgeFeatureFlags(state).bip44DefaultPairs], (fromChainId, bip44DefaultPairs) => {
  var _bip44DefaultPairs$na;
  if (!fromChainId) {
    return null;
  }
  const {
    namespace
  } = (0, _utils.parseCaipChainId)((0, _bridgeController.formatChainIdToCaip)(fromChainId));
  const defaultTokenPair = bip44DefaultPairs === null || bip44DefaultPairs === void 0 || (_bip44DefaultPairs$na = bip44DefaultPairs[namespace]) === null || _bip44DefaultPairs$na === void 0 ? void 0 : _bip44DefaultPairs$na.standard;
  if (defaultTokenPair) {
    return Object.entries(defaultTokenPair).flat();
  }
  return null;
});
const getFromToken = exports.getFromToken = (0, _reselect.createSelector)([state => state.bridge.fromToken, state => {
  var _getFromChain2;
  return (_getFromChain2 = getFromChain(state)) === null || _getFromChain2 === void 0 ? void 0 : _getFromChain2.chainId;
}], (fromToken, fromChainId) => {
  if (!fromChainId) {
    return null;
  }
  if (fromToken !== null && fromToken !== void 0 && fromToken.address) {
    return fromToken;
  }
  const {
    iconUrl,
    ...nativeAsset
  } = (0, _bridgeController.getNativeAssetForChainId)(fromChainId);
  const newToToken = (0, _utils2.toBridgeToken)(nativeAsset);
  return newToToken ? {
    ...newToToken,
    chainId: (0, _bridgeController.formatChainIdToCaip)(fromChainId)
  } : newToToken;
});
const getToToken = exports.getToToken = (0, _reselect.createSelector)([getFromToken, getToChain, state => state.bridge.toToken], (fromToken, toChain, toToken) => {
  if (!toChain || !fromToken) {
    return null;
  }
  // If the user has selected a token, return it
  if (toToken) {
    return toToken;
  }
  // Otherwise, determine the default token to use based on fromToken and toChain
  const defaultToken = (0, _utils2.getDefaultToToken)((0, _bridgeController.formatChainIdToCaip)(toChain.chainId), fromToken);
  return defaultToken ? (0, _utils2.toBridgeToken)(defaultToken) : null;
});
const getFromAmount = state => state.bridge.fromTokenInputValue;
exports.getFromAmount = getFromAmount;
const getAccountGroupNameByInternalAccount = exports.getAccountGroupNameByInternalAccount = (0, _reselect.createSelector)([_accountTree.getAllAccountGroups, (_, account) => account], (accountGroups, account) => {
  var _accountGroups$find, _account$metadata;
  if (!(account !== null && account !== void 0 && account.id)) {
    return null;
  }
  return ((_accountGroups$find = accountGroups.find(({
    accounts
  }) => accounts.includes(account.id))) === null || _accountGroups$find === void 0 ? void 0 : _accountGroups$find.metadata.name) ?? (account === null || account === void 0 || (_account$metadata = account.metadata) === null || _account$metadata === void 0 ? void 0 : _account$metadata.name);
});
const getFromAccount = exports.getFromAccount = (0, _reselect.createSelector)([state => {
  var _getFromChain3;
  return (_getFromChain3 = getFromChain(state)) === null || _getFromChain3 === void 0 ? void 0 : _getFromChain3.chainId;
}, state => state, _accounts.getSelectedInternalAccount], (fromChainId, state, selectedInternalAccount) => {
  if (fromChainId) {
    return (0, _accountTree.getInternalAccountBySelectedAccountGroupAndCaip)(state, (0, _bridgeController.formatChainIdToCaip)(fromChainId)) ?? selectedInternalAccount;
  }
  return null;
});
const getToAccounts = exports.getToAccounts = (0, _reselect.createSelector)([getToChain, state => state], (toChain, state) => {
  if (!toChain) {
    return [];
  }
  const internalAccounts = (0, _accounts.getInternalAccountsByScope)(state, (0, _bridgeController.formatChainIdToCaip)(toChain.chainId));
  return internalAccounts.map(account => ({
    ...account,
    isExternal: false,
    displayName: getAccountGroupNameByInternalAccount(state, account) ?? account.metadata.name ?? account.address
  }));
});
const _getFromNativeBalance = (0, _reselect.createSelector)([getFromChain, state => state.bridge.fromNativeBalance, _multichain.getMultichainBalances, state => {
  var _getFromAccount;
  return (_getFromAccount = getFromAccount(state)) === null || _getFromAccount === void 0 ? void 0 : _getFromAccount.id;
}], (fromChain, fromNativeBalance, nonEvmBalancesByAccountId, id) => {
  if (!fromChain || !id) {
    return null;
  }
  const {
    chainId
  } = fromChain;
  const {
    decimals,
    address,
    assetId
  } = (0, _bridgeController.getNativeAssetForChainId)(chainId);

  // Use the balance provided by the multichain balances controller for non-EVM chains
  if ((0, _utils2.isNonEvmChain)(chainId)) {
    var _nonEvmBalancesByAcco;
    const caipAssetType = getNonEvmNativeAssetType(chainId, address, assetId);
    return (nonEvmBalancesByAccountId === null || nonEvmBalancesByAccountId === void 0 || (_nonEvmBalancesByAcco = nonEvmBalancesByAccountId[id]) === null || _nonEvmBalancesByAcco === void 0 || (_nonEvmBalancesByAcco = _nonEvmBalancesByAcco[caipAssetType]) === null || _nonEvmBalancesByAcco === void 0 ? void 0 : _nonEvmBalancesByAcco.amount) ?? null;
  }
  return fromNativeBalance ? _Numeric.Numeric.from(fromNativeBalance, 10).shiftedBy(decimals).toString() : null;
});
const getFromTokenBalance = exports.getFromTokenBalance = (0, _reselect.createSelector)(getFromToken, getFromChain, state => state.bridge.fromTokenBalance, _multichain.getMultichainBalances, getFromAccount, (fromToken, fromChain, fromTokenBalance, nonEvmBalancesByAccountId, fromAccount) => {
  if (!fromToken || !fromChain || !fromAccount) {
    return null;
  }
  const {
    id
  } = fromAccount;
  const {
    chainId,
    decimals,
    address,
    assetId
  } = fromToken;

  // Use the balance provided by the multichain balances controller for non-EVM chains
  if ((0, _utils2.isNonEvmChain)(chainId)) {
    var _nonEvmBalancesByAcco2;
    const caipAssetType = getNonEvmNativeAssetType(chainId, address, assetId);
    return (nonEvmBalancesByAccountId === null || nonEvmBalancesByAccountId === void 0 || (_nonEvmBalancesByAcco2 = nonEvmBalancesByAccountId[id]) === null || _nonEvmBalancesByAcco2 === void 0 || (_nonEvmBalancesByAcco2 = _nonEvmBalancesByAcco2[caipAssetType]) === null || _nonEvmBalancesByAcco2 === void 0 ? void 0 : _nonEvmBalancesByAcco2.amount) ?? fromToken.string ?? null;
  }
  return fromTokenBalance ? _Numeric.Numeric.from(fromTokenBalance, 10).shiftedBy(decimals).toString() : null;
});
const getSlippage = state => state.bridge.slippage;
exports.getSlippage = getSlippage;
const getQuoteRequest = state => {
  const {
    quoteRequest
  } = state.metamask;
  return quoteRequest;
};
exports.getQuoteRequest = getQuoteRequest;
const getQuoteRefreshRate = exports.getQuoteRefreshRate = (0, _reselect.createSelector)(getBridgeFeatureFlags, getFromChain, (extensionConfig, fromChain) => {
  var _extensionConfig$chai;
  return (fromChain && ((_extensionConfig$chai = extensionConfig.chains[(0, _bridgeController.formatChainIdToCaip)(fromChain.chainId)]) === null || _extensionConfig$chai === void 0 ? void 0 : _extensionConfig$chai.refreshRate)) ?? extensionConfig.refreshRate;
});
const getBridgeSortOrder = state => state.bridge.sortOrder;
exports.getBridgeSortOrder = getBridgeSortOrder;
const getFromTokenConversionRate = exports.getFromTokenConversionRate = (0, _reselect.createSelector)([getFromChain, state => state.metamask.marketData,
// rates for non-native evm tokens
_assets.getAssetsRates,
// non-evm conversion rates multichain equivalent of getMarketData
getFromToken, _multichain.getMultichainCoinRates,
// RatesController rates for native assets
state => state.metamask.currencyRates,
// EVM only
state => state.bridge.fromTokenExchangeRate], (fromChain, marketData, conversionRates, fromToken, rates, currencyRates, fromTokenExchangeRate) => {
  if (fromChain !== null && fromChain !== void 0 && fromChain.chainId && fromToken) {
    var _getNativeAssetForCha, _rates$fromChain$nati, _fromChain$nativeCurr, _conversionRates, _currencyRates$fromCh, _rates$fromChain$nati2, _fromChain$nativeCurr2, _conversionRates2, _currencyRates$fromCh2;
    const nativeAssetId = (_getNativeAssetForCha = (0, _bridgeController.getNativeAssetForChainId)(fromChain.chainId)) === null || _getNativeAssetForCha === void 0 ? void 0 : _getNativeAssetForCha.assetId;
    const tokenAssetId = (0, _assetUtils.toAssetId)(fromToken.address, (0, _bridgeController.formatChainIdToCaip)(fromChain.chainId));
    const nativeToCurrencyRate = (0, _utils2.isNonEvmChain)(fromChain.chainId) ? Number((rates === null || rates === void 0 || (_rates$fromChain$nati = rates[(_fromChain$nativeCurr = fromChain.nativeCurrency) === null || _fromChain$nativeCurr === void 0 ? void 0 : _fromChain$nativeCurr.toLowerCase()]) === null || _rates$fromChain$nati === void 0 ? void 0 : _rates$fromChain$nati.conversionRate) ?? (conversionRates === null || conversionRates === void 0 || (_conversionRates = conversionRates[nativeAssetId]) === null || _conversionRates === void 0 ? void 0 : _conversionRates.rate) ?? null) : ((_currencyRates$fromCh = currencyRates[fromChain.nativeCurrency]) === null || _currencyRates$fromCh === void 0 ? void 0 : _currencyRates$fromCh.conversionRate) ?? null;
    const nativeToUsdRate = (0, _utils2.isNonEvmChain)(fromChain.chainId) ? Number((rates === null || rates === void 0 || (_rates$fromChain$nati2 = rates[(_fromChain$nativeCurr2 = fromChain.nativeCurrency) === null || _fromChain$nativeCurr2 === void 0 ? void 0 : _fromChain$nativeCurr2.toLowerCase()]) === null || _rates$fromChain$nati2 === void 0 ? void 0 : _rates$fromChain$nati2.usdConversionRate) ?? (conversionRates === null || conversionRates === void 0 || (_conversionRates2 = conversionRates[nativeAssetId]) === null || _conversionRates2 === void 0 ? void 0 : _conversionRates2.rate) ?? null) : ((_currencyRates$fromCh2 = currencyRates[fromChain.nativeCurrency]) === null || _currencyRates$fromCh2 === void 0 ? void 0 : _currencyRates$fromCh2.usdConversionRate) ?? null;
    if ((0, _bridgeController.isNativeAddress)(fromToken.address)) {
      return {
        valueInCurrency: nativeToCurrencyRate,
        usd: nativeToUsdRate
      };
    }
    if ((0, _bridgeController.isSolanaChainId)(fromChain.chainId) && nativeAssetId && tokenAssetId) {
      var _conversionRates$toke, _conversionRates3, _rates$sol;
      // For SOLANA tokens, we use the conversion rates provided by the multichain rates controller
      const tokenToNativeAssetRate = (0, _utils2.tokenPriceInNativeAsset)(Number((conversionRates === null || conversionRates === void 0 || (_conversionRates$toke = conversionRates[tokenAssetId]) === null || _conversionRates$toke === void 0 ? void 0 : _conversionRates$toke.rate) ?? fromTokenExchangeRate ?? null), Number((conversionRates === null || conversionRates === void 0 || (_conversionRates3 = conversionRates[nativeAssetId]) === null || _conversionRates3 === void 0 ? void 0 : _conversionRates3.rate) ?? (rates === null || rates === void 0 || (_rates$sol = rates.sol) === null || _rates$sol === void 0 ? void 0 : _rates$sol.conversionRate) ?? null));
      return (0, _utils2.exchangeRatesFromNativeAndCurrencyRates)(tokenToNativeAssetRate, Number(nativeToCurrencyRate), Number(nativeToUsdRate));
    }
    if ((0, _bridgeController.isBitcoinChainId)(fromChain.chainId) && nativeAssetId && tokenAssetId) {
      var _conversionRates4, _conversionRates$toke2;
      // For Bitcoin tokens, we use the conversion rates provided by the multichain rates controller
      const nativeAssetRate = Number((conversionRates === null || conversionRates === void 0 || (_conversionRates4 = conversionRates[nativeAssetId]) === null || _conversionRates4 === void 0 ? void 0 : _conversionRates4.rate) ?? null);
      const tokenToNativeAssetRate = (0, _utils2.tokenPriceInNativeAsset)(Number((conversionRates === null || conversionRates === void 0 || (_conversionRates$toke2 = conversionRates[tokenAssetId]) === null || _conversionRates$toke2 === void 0 ? void 0 : _conversionRates$toke2.rate) ?? fromTokenExchangeRate ?? null), nativeAssetRate);
      return (0, _utils2.exchangeRatesFromNativeAndCurrencyRates)(tokenToNativeAssetRate, Number(nativeToCurrencyRate), Number(nativeToUsdRate));
    }
    // For EVM tokens, we use the market data to get the exchange rate
    const tokenToNativeAssetRate = (0, _utils2.exchangeRateFromMarketData)(fromChain.chainId, fromToken.address, marketData) ?? (0, _utils2.tokenPriceInNativeAsset)(fromTokenExchangeRate, nativeToCurrencyRate);
    return (0, _utils2.exchangeRatesFromNativeAndCurrencyRates)(tokenToNativeAssetRate, nativeToCurrencyRate, nativeToUsdRate);
  }
  return (0, _utils2.exchangeRatesFromNativeAndCurrencyRates)();
});

// A dest network can be selected before it's imported
// The cached exchange rate won't be available so the rate from the bridge state is used
const getToTokenConversionRate = exports.getToTokenConversionRate = (0, _util.createDeepEqualSelector)([getToChain, state => state.metamask.marketData,
// rates for non-native evm tokens
_assets.getAssetsRates,
// non-evm conversion rates, multichain equivalent of getMarketData
getToToken, _networks2.getNetworkConfigurationsByChainId, state => ({
  state,
  toTokenExchangeRate: state.bridge.toTokenExchangeRate,
  toTokenUsdExchangeRate: state.bridge.toTokenUsdExchangeRate
}), _multichain.getMultichainCoinRates // multichain native rates
], (toChain, marketData, conversionRates, toToken, allNetworksByChainId, {
  state,
  toTokenExchangeRate,
  toTokenUsdExchangeRate
}, rates) => {
  // When the toChain is not imported, the exchange rate to native asset is not available
  // The rate in the bridge state is used instead
  if (toChain !== null && toChain !== void 0 && toChain.chainId && !allNetworksByChainId[toChain.chainId] && toTokenExchangeRate) {
    return {
      valueInCurrency: toTokenExchangeRate,
      usd: toTokenUsdExchangeRate
    };
  }
  if (toChain !== null && toChain !== void 0 && toChain.chainId && toToken) {
    var _getNativeAssetForCha2;
    const nativeAssetId = (_getNativeAssetForCha2 = (0, _bridgeController.getNativeAssetForChainId)(toChain.chainId)) === null || _getNativeAssetForCha2 === void 0 ? void 0 : _getNativeAssetForCha2.assetId;
    const tokenAssetId = (0, _assetUtils.toAssetId)(toToken.address, (0, _bridgeController.formatChainIdToCaip)(toChain.chainId));
    if ((0, _bridgeController.isSolanaChainId)(toChain.chainId) && nativeAssetId && tokenAssetId) {
      var _conversionRates$toke3, _conversionRates5, _rates$toChain$native, _toChain$nativeCurren, _rates$toChain$native2, _toChain$nativeCurren2;
      // For SOLANA tokens, we use the conversion rates provided by the multichain rates controller
      const tokenToNativeAssetRate = (0, _utils2.tokenPriceInNativeAsset)(Number((conversionRates === null || conversionRates === void 0 || (_conversionRates$toke3 = conversionRates[tokenAssetId]) === null || _conversionRates$toke3 === void 0 ? void 0 : _conversionRates$toke3.rate) ?? null), Number((conversionRates === null || conversionRates === void 0 || (_conversionRates5 = conversionRates[nativeAssetId]) === null || _conversionRates5 === void 0 ? void 0 : _conversionRates5.rate) ?? null));
      return (0, _utils2.exchangeRatesFromNativeAndCurrencyRates)(tokenToNativeAssetRate, (rates === null || rates === void 0 || (_rates$toChain$native = rates[(_toChain$nativeCurren = toChain.nativeCurrency) === null || _toChain$nativeCurren === void 0 ? void 0 : _toChain$nativeCurren.toLowerCase()]) === null || _rates$toChain$native === void 0 ? void 0 : _rates$toChain$native.conversionRate) ?? null, (rates === null || rates === void 0 || (_rates$toChain$native2 = rates[(_toChain$nativeCurren2 = toChain.nativeCurrency) === null || _toChain$nativeCurren2 === void 0 ? void 0 : _toChain$nativeCurren2.toLowerCase()]) === null || _rates$toChain$native2 === void 0 ? void 0 : _rates$toChain$native2.usdConversionRate) ?? null);
    }
    if ((0, _bridgeController.isBitcoinChainId)(toChain.chainId) && nativeAssetId && tokenAssetId) {
      var _conversionRates6, _conversionRates$toke4, _rates$toChain$native3, _toChain$nativeCurren3, _rates$toChain$native4, _toChain$nativeCurren4;
      // For Bitcoin tokens, we use the conversion rates provided by the multichain rates controller
      const nativeAssetRate = Number((conversionRates === null || conversionRates === void 0 || (_conversionRates6 = conversionRates[nativeAssetId]) === null || _conversionRates6 === void 0 ? void 0 : _conversionRates6.rate) ?? null);
      const tokenToNativeAssetRate = (0, _utils2.tokenPriceInNativeAsset)(Number((conversionRates === null || conversionRates === void 0 || (_conversionRates$toke4 = conversionRates[tokenAssetId]) === null || _conversionRates$toke4 === void 0 ? void 0 : _conversionRates$toke4.rate) ?? null), nativeAssetRate);
      return (0, _utils2.exchangeRatesFromNativeAndCurrencyRates)(tokenToNativeAssetRate, (rates === null || rates === void 0 || (_rates$toChain$native3 = rates[(_toChain$nativeCurren3 = toChain.nativeCurrency) === null || _toChain$nativeCurren3 === void 0 ? void 0 : _toChain$nativeCurren3.toLowerCase()]) === null || _rates$toChain$native3 === void 0 ? void 0 : _rates$toChain$native3.conversionRate) ?? null, (rates === null || rates === void 0 || (_rates$toChain$native4 = rates[(_toChain$nativeCurren4 = toChain.nativeCurrency) === null || _toChain$nativeCurren4 === void 0 ? void 0 : _toChain$nativeCurren4.toLowerCase()]) === null || _rates$toChain$native4 === void 0 ? void 0 : _rates$toChain$native4.usdConversionRate) ?? null);
    }
    const {
      chainId
    } = toChain;
    const nativeToCurrencyRate = (0, _selectors.selectConversionRateByChainId)(state, chainId);
    const nativeToUsdRate = (0, _selectors.getUSDConversionRateByChainId)(chainId)(state);
    if ((0, _bridgeController.isNativeAddress)(toToken.address)) {
      return {
        valueInCurrency: nativeToCurrencyRate,
        usd: nativeToUsdRate
      };
    }
    const tokenToNativeAssetRate = (0, _utils2.exchangeRateFromMarketData)(chainId, toToken.address, marketData) ?? (0, _utils2.tokenPriceInNativeAsset)(toTokenExchangeRate, nativeToCurrencyRate);
    return (0, _utils2.exchangeRatesFromNativeAndCurrencyRates)(tokenToNativeAssetRate, nativeToCurrencyRate, nativeToUsdRate);
  }
  return (0, _utils2.exchangeRatesFromNativeAndCurrencyRates)();
});
const getIsQuoteExpired = ({
  metamask
}, currentTimeInMs) => (0, _bridgeController.selectIsQuoteExpired)(metamask, {}, currentTimeInMs);
exports.getIsQuoteExpired = getIsQuoteExpired;
const getBridgeQuotes = exports.getBridgeQuotes = (0, _reselect.createSelector)([({
  metamask
}) => metamask, ({
  bridge: {
    sortOrder
  }
}) => sortOrder, ({
  bridge: {
    selectedQuote
  }
}) => selectedQuote], (controllerStates, sortOrder, selectedQuote) => (0, _bridgeController.selectBridgeQuotes)(controllerStates, {
  sortOrder,
  selectedQuote
}));
const getIsBridgeTx = exports.getIsBridgeTx = (0, _util.createDeepEqualSelector)(getFromChain, getToChain, (fromChain, toChain) => toChain && fromChain !== null && fromChain !== void 0 && fromChain.chainId ? fromChain.chainId !== toChain.chainId : false);
const getIsSwap = exports.getIsSwap = (0, _util.createDeepEqualSelector)(getQuoteRequest, ({
  srcChainId,
  destChainId
}) => Boolean(srcChainId && destChainId && (0, _bridgeController.formatChainIdToCaip)(srcChainId) === (0, _bridgeController.formatChainIdToCaip)(destChainId)));
const _getValidatedSrcAmount = (0, _reselect.createSelector)(getFromToken, state => state.metamask.quoteRequest.srcTokenAmount, (fromToken, srcTokenAmount) => srcTokenAmount && fromToken !== null && fromToken !== void 0 && fromToken.decimals ? (0, _pushServices.calcTokenAmount)(srcTokenAmount, Number(fromToken.decimals)).toString() : null);
const getFromAmountInCurrency = exports.getFromAmountInCurrency = (0, _reselect.createSelector)(getFromToken, getFromChain, _getValidatedSrcAmount, getFromTokenConversionRate, (fromToken, fromChain, validatedSrcAmount, {
  valueInCurrency: fromTokenToCurrencyExchangeRate,
  usd: fromTokenToUsdExchangeRate
}) => {
  if (fromToken !== null && fromToken !== void 0 && fromToken.symbol && fromChain !== null && fromChain !== void 0 && fromChain.chainId && validatedSrcAmount) {
    if (fromTokenToCurrencyExchangeRate) {
      return {
        valueInCurrency: new _bignumber.BigNumber(validatedSrcAmount).mul(new _bignumber.BigNumber(fromTokenToCurrencyExchangeRate.toString() ?? 1)),
        usd: new _bignumber.BigNumber(validatedSrcAmount).mul(new _bignumber.BigNumber((fromTokenToUsdExchangeRate === null || fromTokenToUsdExchangeRate === void 0 ? void 0 : fromTokenToUsdExchangeRate.toString()) ?? 1))
      };
    }
  }
  return {
    valueInCurrency: new _bignumber.BigNumber(0),
    usd: new _bignumber.BigNumber(0)
  };
});
const getTxAlerts = state => state.bridge.txAlert;
exports.getTxAlerts = getTxAlerts;
const getValidationErrors = exports.getValidationErrors = (0, _util.createDeepEqualSelector)(getBridgeQuotes, _getValidatedSrcAmount, getFromToken, getFromAmount, ({
  metamask
}) => (0, _bridgeController.selectMinimumBalanceForRentExemptionInSOL)(metamask), getQuoteRequest, getTxAlerts, _getFromNativeBalance, getFromTokenBalance, ({
  activeQuote,
  quotesLastFetchedMs,
  isLoading,
  quotesRefreshCount
}, validatedSrcAmount, fromToken, fromTokenInputValue, minimumBalanceForRentExemptionInSOL, quoteRequest, txAlert, nativeBalance, fromTokenBalance) => {
  var _activeQuote$quote, _activeQuote$sentAmou, _activeQuote$adjusted;
  const {
    gasIncluded,
    gasIncluded7702
  } = (activeQuote === null || activeQuote === void 0 ? void 0 : activeQuote.quote) ?? {};
  const isGasless = gasIncluded7702 || gasIncluded;
  const srcChainId = quoteRequest.srcChainId ?? (activeQuote === null || activeQuote === void 0 || (_activeQuote$quote = activeQuote.quote) === null || _activeQuote$quote === void 0 ? void 0 : _activeQuote$quote.srcChainId);
  const minimumBalanceToUse = srcChainId && (0, _bridgeController.isSolanaChainId)(srcChainId) ? minimumBalanceForRentExemptionInSOL : '0';
  return {
    isTxAlertPresent: Boolean(txAlert),
    isNoQuotesAvailable: Boolean(!activeQuote && (0, _bridgeController.isValidQuoteRequest)(quoteRequest) && quotesLastFetchedMs && !isLoading && quotesRefreshCount > 0),
    // Shown prior to fetching quotes
    isInsufficientGasBalance: Boolean(nativeBalance && !activeQuote && validatedSrcAmount && fromToken && !isGasless && ((0, _bridgeController.isNativeAddress)(fromToken.address) ? new _bignumber.BigNumber(nativeBalance).sub(minimumBalanceToUse).lte(validatedSrcAmount) : new _bignumber.BigNumber(nativeBalance).lte(0))),
    // Shown after fetching quotes
    isInsufficientGasForQuote: Boolean(nativeBalance && activeQuote && fromToken && fromTokenInputValue && !isGasless && ((0, _bridgeController.isNativeAddress)(fromToken.address) ? new _bignumber.BigNumber(nativeBalance).sub(activeQuote.totalMaxNetworkFee.amount).sub(activeQuote.sentAmount.amount).sub(minimumBalanceToUse).lte(0) : new _bignumber.BigNumber(nativeBalance).lte(activeQuote.totalMaxNetworkFee.amount))),
    isInsufficientBalance: validatedSrcAmount && fromTokenBalance && !isNaN(Number(fromTokenBalance)) ? new _bignumber.BigNumber(fromTokenBalance).lt(validatedSrcAmount) : false,
    isEstimatedReturnLow: activeQuote !== null && activeQuote !== void 0 && (_activeQuote$sentAmou = activeQuote.sentAmount) !== null && _activeQuote$sentAmou !== void 0 && _activeQuote$sentAmou.valueInCurrency && activeQuote !== null && activeQuote !== void 0 && (_activeQuote$adjusted = activeQuote.adjustedReturn) !== null && _activeQuote$adjusted !== void 0 && _activeQuote$adjusted.valueInCurrency && fromTokenInputValue ? new _bignumber.BigNumber(activeQuote.adjustedReturn.valueInCurrency).lt(new _bignumber.BigNumber(1 - _bridgeController.BRIDGE_QUOTE_MAX_RETURN_DIFFERENCE_PERCENTAGE).times(activeQuote.sentAmount.valueInCurrency)) : false
  };
});
const getWasTxDeclined = state => {
  return state.bridge.wasTxDeclined;
};

/**
 * Checks if the destination chain is Solana and the user has no Solana accounts
 */
exports.getWasTxDeclined = getWasTxDeclined;
const needsSolanaAccountForDestination = exports.needsSolanaAccountForDestination = (0, _util.createDeepEqualSelector)(getToChain, state => hasSolanaAccounts(state), (toChain, hasSolanaAccount) => {
  if (!toChain) {
    return false;
  }
  const isSolanaDestination = (0, _bridgeController.isSolanaChainId)(toChain.chainId);
  return isSolanaDestination && !hasSolanaAccount;
});
const needsBitcoinAccountForDestination = exports.needsBitcoinAccountForDestination = (0, _util.createDeepEqualSelector)(getToChain, state => hasBitcoinAccounts(state), (toChain, hasBitcoinAccount) => {
  if (!toChain) {
    return false;
  }
  const isBitcoinDestination = (0, _bridgeController.isBitcoinChainId)(toChain.chainId);
  return isBitcoinDestination && !hasBitcoinAccount;
});
const getIsToOrFromNonEvm = exports.getIsToOrFromNonEvm = (0, _reselect.createSelector)(getFromChain, getToChain, (fromChain, toChain) => {
  if (!(fromChain !== null && fromChain !== void 0 && fromChain.chainId) || !(toChain !== null && toChain !== void 0 && toChain.chainId)) {
    return false;
  }

  // Parse the CAIP chain IDs to get their namespaces
  const fromCaipChainId = (0, _bridgeController.formatChainIdToCaip)(fromChain.chainId);
  const toCaipChainId = (0, _bridgeController.formatChainIdToCaip)(toChain.chainId);
  const {
    namespace: fromNamespace
  } = (0, _utils.parseCaipChainId)(fromCaipChainId);
  const {
    namespace: toNamespace
  } = (0, _utils.parseCaipChainId)(toCaipChainId);

  // Return true if chains are in different namespaces
  // This covers EVM <> non-EVM as well as non-EVM <> non-EVM (e.g., Solana <> Bitcoin)
  return fromNamespace !== toNamespace;
});
const getIsSolanaSwap = exports.getIsSolanaSwap = (0, _reselect.createSelector)(getFromChain, getToChain, (fromChain, toChain) => {
  if (!(fromChain !== null && fromChain !== void 0 && fromChain.chainId) || !(toChain !== null && toChain !== void 0 && toChain.chainId)) {
    return false;
  }
  const fromChainIsSolana = (0, _bridgeController.isSolanaChainId)(fromChain.chainId);
  const toChainIsSolana = (0, _bridgeController.isSolanaChainId)(toChain.chainId);

  // Return true if BOTH chains are Solana (Solana-to-Solana swap)
  return fromChainIsSolana && toChainIsSolana;
});
const getHardwareWalletName = state => {
  const type = (0, _selectors.getHardwareWalletType)(state);
  switch (type) {
    case _hardwareWallets.HardwareKeyringType.ledger:
      return _hardwareWallets.HardwareKeyringNames.ledger;
    case _hardwareWallets.HardwareKeyringType.trezor:
      return _hardwareWallets.HardwareKeyringNames.trezor;
    case _hardwareWallets.HardwareKeyringType.lattice:
      return _hardwareWallets.HardwareKeyringNames.lattice;
    case _hardwareWallets.HardwareKeyringType.oneKey:
      return _hardwareWallets.HardwareKeyringNames.oneKey;
    default:
      return undefined;
  }
};
exports.getHardwareWalletName = getHardwareWalletName;
const selectNoFeeAssets = exports.selectNoFeeAssets = (0, _reselect.createSelector)([getBridgeFeatureFlags, (_state, chainId) => chainId], (bridgeFeatureFlags, chainId) => {
  var _bridgeFeatureFlags$c4;
  if (!chainId) {
    return [];
  }
  const caipChainId = (0, _bridgeController.formatChainIdToCaip)(chainId);
  return (bridgeFeatureFlags === null || bridgeFeatureFlags === void 0 || (_bridgeFeatureFlags$c4 = bridgeFeatureFlags.chains) === null || _bridgeFeatureFlags$c4 === void 0 || (_bridgeFeatureFlags$c4 = _bridgeFeatureFlags$c4[caipChainId]) === null || _bridgeFeatureFlags$c4 === void 0 ? void 0 : _bridgeFeatureFlags$c4.noFeeAssets) ?? [];
});
const getIsGasIncludedSwapSupported = (0, _reselect.createSelector)([state => {
  var _getFromChain4;
  return (_getFromChain4 = getFromChain(state)) === null || _getFromChain4 === void 0 ? void 0 : _getFromChain4.chainId;
}, state => {
  var _getToChain;
  return (_getToChain = getToChain(state)) === null || _getToChain === void 0 ? void 0 : _getToChain.chainId;
}, (_, isSendBundleSupportedForChain) => isSendBundleSupportedForChain], (fromChainId, toChainId, isSendBundleSupportedForChain) => {
  if (!fromChainId) {
    return false;
  }
  const isSwap = !(0, _bridgeController.isCrossChain)(fromChainId, toChainId);
  return isSwap && isSendBundleSupportedForChain;
});
const getIsStxEnabled = exports.getIsStxEnabled = (0, _reselect.createSelector)([state => {
  var _getFromChain5;
  return (_getFromChain5 = getFromChain(state)) === null || _getFromChain5 === void 0 ? void 0 : _getFromChain5.chainId;
}, state => state], (fromChainId, state) => (0, _selectors2.getIsSmartTransaction)(state, fromChainId));
const getIsGasIncluded = exports.getIsGasIncluded = (0, _reselect.createSelector)([getIsStxEnabled, getIsGasIncludedSwapSupported], (isStxEnabled, isGasIncludedSwapSupported) => {
  return isStxEnabled && isGasIncludedSwapSupported;
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\ducks\\bridge\\selectors.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\utils.ts", {"../../../shared/constants/bridge":"D:\\code\\v\\metamask-extension\\shared\\constants\\bridge.ts","../../../shared/constants/multichain/networks":"D:\\code\\v\\metamask-extension\\shared\\constants\\multichain\\networks.ts","../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../shared/lib/asset-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\asset-utils.ts","../../../shared/modules/Numeric":"D:\\code\\v\\metamask-extension\\shared\\modules\\Numeric.ts","../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../pages/swaps/swaps.util":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\swaps.util.ts","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","bignumber.js":"D:\\code\\v\\metamask-extension\\node_modules\\bignumber.js\\bignumber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cducks%5Cbridge%5Cutils.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isNetworkAdded = exports.getTxGasEstimates = exports.getTokenExchangeRate = exports.getNativeTokenName = exports.getHexMaxGasLimit = exports.getDefaultToToken = exports.exchangeRatesFromNativeAndCurrencyRates = exports.exchangeRateFromMarketData = exports.bpsToPercentage = void 0;
Object.defineProperty(exports, "isNonEvmChain", {
  enumerable: true,
  get: function () {
    return _bridgeController.isNonEvmChainId;
  }
});
exports.tokenPriceInNativeAsset = exports.tokenAmountToCurrency = exports.toBridgeToken = void 0;
var _utils = require("@metamask/utils");
var _bignumber = require("bignumber.js");
var _bridgeController = require("@metamask/bridge-controller");
var _controllerUtils = require("@metamask/controller-utils");
var _conversion = require("../../../shared/modules/conversion.utils");
var _Numeric = require("../../../shared/modules/Numeric");
var _swaps = require("../../pages/swaps/swaps.util");
var _assetUtils = require("../../../shared/lib/asset-utils");
var _bridge = require("../../../shared/constants/bridge");
var _network = require("../../../shared/constants/network");
var _networks = require("../../../shared/constants/multichain/networks");
// Re-export isNonEvmChainId from bridge-controller for backward compatibility

/**
 * Safely gets the native token name for a given chainId.
 * Returns undefined if the chainId is not supported by the bridge controller.
 *
 * @param chainId - The chain ID to get the native token name for
 * @returns The human-readable name of the native token, or undefined if not supported
 */
const getNativeTokenName = chainId => {
  try {
    var _getNativeAssetForCha;
    return (_getNativeAssetForCha = (0, _bridgeController.getNativeAssetForChainId)(chainId)) === null || _getNativeAssetForCha === void 0 ? void 0 : _getNativeAssetForCha.name;
  } catch {
    // Return undefined for unsupported chains (e.g., test chains)
    return undefined;
  }
};
exports.getNativeTokenName = getNativeTokenName;
// We don't need to use gas multipliers here because the gasLimit from Bridge API already included it
const getHexMaxGasLimit = gasLimit => {
  return new _Numeric.Numeric(new _bignumber.BigNumber(gasLimit).toString(), 10).toPrefixedHexString();
};
/**
 * Converts basis points (BPS) to percentage
 * 1 BPS = 0.01%
 *
 * @param bps - The value in basis points (e.g., "87.5" or 87.5)
 * @returns The percentage value as a string (e.g., "0.875")
 */
exports.getHexMaxGasLimit = getHexMaxGasLimit;
const bpsToPercentage = bps => {
  if (bps === undefined || bps === null) {
    return undefined;
  }
  const bpsValue = typeof bps === 'string' ? parseFloat(bps) : bps;
  if (isNaN(bpsValue)) {
    return undefined;
  }

  // BPS to percentage: divide by 100
  return (bpsValue / 100).toString();
};
exports.bpsToPercentage = bpsToPercentage;
const getTxGasEstimates = async ({
  networkAndAccountSupports1559,
  networkGasFeeEstimates,
  txParams,
  hexChainId
}) => {
  if (networkAndAccountSupports1559) {
    var _txParams$gasLimit;
    const {
      estimatedBaseFee = '0'
    } = networkGasFeeEstimates;
    const hexEstimatedBaseFee = (0, _conversion.decGWEIToHexWEI)(estimatedBaseFee);
    const txGasFeeEstimates = await (0, _swaps.getTransaction1559GasFeeEstimates)({
      ...txParams,
      chainId: hexChainId,
      gasLimit: (_txParams$gasLimit = txParams.gasLimit) === null || _txParams$gasLimit === void 0 ? void 0 : _txParams$gasLimit.toString()
    }, hexEstimatedBaseFee, hexChainId);
    return txGasFeeEstimates;
  }
  return {
    baseAndPriorityFeePerGas: undefined,
    maxFeePerGas: undefined,
    maxPriorityFeePerGas: undefined
  };
};
exports.getTxGasEstimates = getTxGasEstimates;
const fetchTokenExchangeRates = async (chainId, currency, signal, ...tokenAddresses) => {
  const assetIds = tokenAddresses.map(address => (0, _assetUtils.toAssetId)(address, (0, _bridgeController.formatChainIdToCaip)(chainId))).filter(Boolean);
  if (assetIds.length === 0) {
    return {};
  }
  const queryParams = new URLSearchParams({
    assetIds: assetIds.join(','),
    includeMarketData: 'true',
    vsCurrency: currency
  });
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31893
  // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
  const url = `https://price.api.cx.metamask.io/v3/spot-prices?${queryParams}`;
  const tokenV3PriceResponse = await (0, _controllerUtils.handleFetch)(url, {
    method: 'GET',
    headers: {
      'X-Client-Id': _bridgeController.BridgeClientId.EXTENSION
    },
    signal
  });
  return Object.entries(tokenV3PriceResponse).reduce((acc, [k, curr]) => {
    acc[k] = curr.price;
    return acc;
  }, {});
};

// This fetches the exchange rate for a token in a given currency. This is only called when the exchange
// rate is not available in the TokenRatesController, which happens when the selected token has not been
// imported into the wallet
const getTokenExchangeRate = async request => {
  const {
    chainId,
    tokenAddress,
    currency,
    signal
  } = request;
  const exchangeRates = await fetchTokenExchangeRates(chainId, currency, signal, tokenAddress);
  const assetId = (0, _assetUtils.toAssetId)(tokenAddress, (0, _bridgeController.formatChainIdToCaip)(chainId));
  return assetId ? exchangeRates === null || exchangeRates === void 0 ? void 0 : exchangeRates[assetId] : undefined;
};

// This extracts a token's exchange rate from the marketData state object
// These exchange rates are against the native asset of the chain
exports.getTokenExchangeRate = getTokenExchangeRate;
const exchangeRateFromMarketData = (chainId, tokenAddress, marketData) => {
  var _marketData$chainId;
  return (0, _utils.isStrictHexString)(tokenAddress) && (0, _utils.isStrictHexString)(chainId) ? marketData === null || marketData === void 0 || (_marketData$chainId = marketData[chainId]) === null || _marketData$chainId === void 0 || (_marketData$chainId = _marketData$chainId[tokenAddress]) === null || _marketData$chainId === void 0 ? void 0 : _marketData$chainId.price : undefined;
};
exports.exchangeRateFromMarketData = exchangeRateFromMarketData;
const tokenAmountToCurrency = (amount, exchangeRate) => new _Numeric.Numeric(amount, 10)
// Stringify exchangeRate before applying conversion to avoid floating point issues
.applyConversionRate(new _bignumber.BigNumber(exchangeRate.toString(), 10)).toNumber();
exports.tokenAmountToCurrency = tokenAmountToCurrency;
const tokenPriceInNativeAsset = (tokenExchangeRate, nativeToCurrencyRate) => {
  return tokenExchangeRate && nativeToCurrencyRate ? tokenExchangeRate / nativeToCurrencyRate : null;
};
exports.tokenPriceInNativeAsset = tokenPriceInNativeAsset;
const exchangeRatesFromNativeAndCurrencyRates = (tokenToNativeAssetRate, nativeToCurrencyRate, nativeToUsdRate) => {
  return {
    valueInCurrency: tokenToNativeAssetRate && nativeToCurrencyRate ? tokenToNativeAssetRate * nativeToCurrencyRate : null,
    usd: tokenToNativeAssetRate && nativeToUsdRate ? tokenToNativeAssetRate * nativeToUsdRate : null
  };
};
exports.exchangeRatesFromNativeAndCurrencyRates = exchangeRatesFromNativeAndCurrencyRates;
const isNetworkAdded = v => v !== undefined && 'networkClientId' in v.rpcEndpoints[v.defaultRpcEndpointIndex];
exports.isNetworkAdded = isNetworkAdded;
const getTokenImage = payload => {
  if (!payload) {
    return '';
  }
  const {
    image,
    iconUrl,
    icon,
    chainId,
    address,
    assetId
  } = payload;
  const caipChainId = (0, _bridgeController.formatChainIdToCaip)(chainId);
  // If the token is native, return the SVG image asset
  if ((0, _bridgeController.isNativeAddress)(address)) {
    // Non-EVM chains (Solana, Bitcoin) use MULTICHAIN_TOKEN_IMAGE_MAP
    if ((0, _bridgeController.isNonEvmChainId)(chainId)) {
      return _networks.MULTICHAIN_TOKEN_IMAGE_MAP[caipChainId];
    }
    // EVM chains use CHAIN_ID_TOKEN_IMAGE_MAP
    return _network.CHAIN_ID_TOKEN_IMAGE_MAP[(0, _bridgeController.formatChainIdToHex)(chainId)];
  }
  // If the token is not native, return the image from the payload
  const imageFromPayload = image ?? iconUrl ?? icon;
  if (imageFromPayload) {
    return imageFromPayload;
  }
  // If there's no image from the payload, build the asset image URL and return it
  const assetIdToUse = assetId ?? (0, _assetUtils.toAssetId)(address, caipChainId);
  return (assetIdToUse && (0, _assetUtils.getAssetImageUrl)(assetIdToUse, caipChainId)) ?? '';
};
const toBridgeToken = payload => {
  if (!payload) {
    return null;
  }
  const caipChainId = (0, _bridgeController.formatChainIdToCaip)(payload.chainId);
  return {
    ...payload,
    balance: payload.balance ?? '0',
    string: payload.string ?? '0',
    chainId: payload.chainId,
    image: getTokenImage(payload),
    assetId: payload.assetId ?? (0, _assetUtils.toAssetId)(payload.address, caipChainId)
  };
};
exports.toBridgeToken = toBridgeToken;
const createBridgeTokenPayload = (tokenData, chainId) => {
  const {
    assetId,
    ...rest
  } = tokenData;
  return toBridgeToken({
    ...rest,
    chainId
  });
};
const getDefaultToToken = (targetChainId, fromToken) => {
  const commonPair = _bridge.BRIDGE_CHAINID_COMMON_TOKEN_PAIR[targetChainId];
  if (commonPair) {
    var _fromToken$address;
    // If source is native token, default to USDC on same chain
    if ((0, _bridgeController.isNativeAddress)(fromToken.address)) {
      return createBridgeTokenPayload(commonPair, targetChainId);
    }

    // If source is USDC (or other common pair token), default to native token
    if (((_fromToken$address = fromToken.address) === null || _fromToken$address === void 0 ? void 0 : _fromToken$address.toLowerCase()) === commonPair.address.toLowerCase()) {
      const nativeAsset = (0, _bridgeController.getNativeAssetForChainId)(targetChainId);
      if (nativeAsset) {
        return createBridgeTokenPayload(nativeAsset, targetChainId);
      }
    }

    // For any other token, default to USDC
    return createBridgeTokenPayload(commonPair, targetChainId);
  }

  // Last resort: native token
  const nativeAsset = (0, _bridgeController.getNativeAssetForChainId)(targetChainId);
  if (nativeAsset) {
    // return nativeAsset
    return createBridgeTokenPayload(nativeAsset, targetChainId);
  }
  return null;
};
exports.getDefaultToToken = getDefaultToToken;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\ducks\\bridge\\utils.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\ducks\\confirm-alerts\\confirm-alerts.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cducks%5Cconfirm-alerts%5Cconfirm-alerts.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.clearAlerts = clearAlerts;
exports.default = confirmAlertsReducer;
exports.setAlertConfirmed = setAlertConfirmed;
exports.updateAlerts = updateAlerts;
/**
 * A confirmable alert to be displayed in the UI.
 */

/**
 * Represents the state of confirm alerts in the application.
 */

const INIT_STATE = {
  alerts: {},
  confirmed: {}
};
function confirmAlertsReducer(
// eslint-disable-next-line @typescript-eslint/default-param-last
state = INIT_STATE, action) {
  switch (action.type) {
    case 'UPDATE_ALERTS':
      return {
        ...state,
        alerts: {
          ...state.alerts,
          [action.ownerId]: action.alerts
        }
      };
    case 'SET_ALERT_CONFIRMED':
      return {
        ...state,
        confirmed: {
          ...state.confirmed,
          [action.ownerId]: {
            ...state.confirmed[action.ownerId],
            [action.alertKey]: action.isConfirmed
          }
        }
      };
    case 'CLEAR_ALERTS':
      return {
        ...state,
        alerts: {
          ...state.alerts,
          [action.ownerId]: []
        },
        confirmed: {
          ...state.confirmed,
          [action.ownerId]: {}
        }
      };
    default:
      return state;
  }
}
function updateAlerts(ownerId, alerts) {
  return {
    type: 'UPDATE_ALERTS',
    alerts,
    ownerId
  };
}
function setAlertConfirmed(ownerId, alertKey, isConfirmed) {
  return {
    type: 'SET_ALERT_CONFIRMED',
    ownerId,
    alertKey,
    isConfirmed
  };
}
function clearAlerts(ownerId) {
  return {
    type: 'CLEAR_ALERTS',
    ownerId
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\ducks\\confirm-alerts\\confirm-alerts.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\ducks\\history\\history.js", {"../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","@reduxjs/toolkit":"D:\\code\\v\\metamask-extension\\node_modules\\@reduxjs\\toolkit\\dist\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cducks%5Chistory%5Chistory.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setRedirectAfterDefaultPage = exports.pageChanged = exports.getRedirectAfterDefaultPage = exports.getMostRecentOverviewPage = exports.default = exports.clearRedirectAfterDefaultPage = void 0;
var _toolkit = require("@reduxjs/toolkit");
var _routes = require("../../helpers/constants/routes");
// Constants

const initialState = {
  mostRecentOverviewPage: _routes.DEFAULT_ROUTE,
  redirectAfterDefaultPage: null // { path: string, shouldRedirect: boolean, address?: string }
};
const name = 'history';

// Slice (reducer plus auto-generated actions and action creators)

const slice = (0, _toolkit.createSlice)({
  name,
  initialState,
  reducers: {
    pageChanged: (state, action) => {
      const path = action.payload;
      if (path === _routes.DEFAULT_ROUTE || path.startsWith(_routes.ASSET_ROUTE)) {
        var _state$redirectAfterD;
        state.mostRecentOverviewPage = path;

        // If we're going to the default page and have a redirect pending, clear it
        if (path === _routes.DEFAULT_ROUTE && (_state$redirectAfterD = state.redirectAfterDefaultPage) !== null && _state$redirectAfterD !== void 0 && _state$redirectAfterD.shouldRedirect) {
          state.redirectAfterDefaultPage.shouldRedirect = false;
        }
      }
    },
    setRedirectAfterDefaultPage: (state, action) => {
      const {
        path,
        address
      } = action.payload;
      state.redirectAfterDefaultPage = {
        path,
        shouldRedirect: true,
        address
      };
    },
    clearRedirectAfterDefaultPage: state => {
      state.redirectAfterDefaultPage = null;
    }
  }
});
const {
  actions,
  reducer
} = slice;
var _default = exports.default = reducer; // Selectors
const getMostRecentOverviewPage = state => state[name].mostRecentOverviewPage;
exports.getMostRecentOverviewPage = getMostRecentOverviewPage;
const getRedirectAfterDefaultPage = state => state[name].redirectAfterDefaultPage;

// Actions / action-creators
exports.getRedirectAfterDefaultPage = getRedirectAfterDefaultPage;
const {
  pageChanged,
  setRedirectAfterDefaultPage,
  clearRedirectAfterDefaultPage
} = actions;
exports.clearRedirectAfterDefaultPage = clearRedirectAfterDefaultPage;
exports.setRedirectAfterDefaultPage = setRedirectAfterDefaultPage;
exports.pageChanged = pageChanged;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\ducks\\history\\history.js",}],
["D:\\code\\v\\metamask-extension\\ui\\ducks\\index.js", {"../../shared/constants/alerts":"D:\\code\\v\\metamask-extension\\shared\\constants\\alerts.ts","./alerts":"D:\\code\\v\\metamask-extension\\ui\\ducks\\alerts\\index.js","./app/app":"D:\\code\\v\\metamask-extension\\ui\\ducks\\app\\app.ts","./bridge/bridge":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\bridge.ts","./confirm-alerts/confirm-alerts":"D:\\code\\v\\metamask-extension\\ui\\ducks\\confirm-alerts\\confirm-alerts.ts","./confirm-transaction/confirm-transaction.duck":"D:\\code\\v\\metamask-extension\\ui\\ducks\\confirm-transaction\\confirm-transaction.duck.js","./domains":"D:\\code\\v\\metamask-extension\\ui\\ducks\\domains.js","./gas/gas.duck":"D:\\code\\v\\metamask-extension\\ui\\ducks\\gas\\gas.duck.js","./history/history":"D:\\code\\v\\metamask-extension\\ui\\ducks\\history\\history.js","./locale/locale":"D:\\code\\v\\metamask-extension\\ui\\ducks\\locale\\locale.ts","./metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","./ramps/ramps":"D:\\code\\v\\metamask-extension\\ui\\ducks\\ramps\\ramps.ts","./send/send":"D:\\code\\v\\metamask-extension\\ui\\ducks\\send\\send.js","./smart-accounts/smart-accounts":"D:\\code\\v\\metamask-extension\\ui\\ducks\\smart-accounts\\smart-accounts.ts","./swaps/swaps":"D:\\code\\v\\metamask-extension\\ui\\ducks\\swaps\\swaps.js","redux":"D:\\code\\v\\metamask-extension\\node_modules\\redux\\lib\\redux.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cducks%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _redux = require("redux");
var _alerts = require("../../shared/constants/alerts");
var _metamask = _interopRequireDefault(require("./metamask/metamask"));
var _locale = _interopRequireDefault(require("./locale/locale"));
var _send = _interopRequireDefault(require("./send/send"));
var _domains = _interopRequireDefault(require("./domains"));
var _app = _interopRequireDefault(require("./app/app"));
var _confirmTransaction = _interopRequireDefault(require("./confirm-transaction/confirm-transaction.duck"));
var _gas = _interopRequireDefault(require("./gas/gas.duck"));
var _alerts2 = require("./alerts");
var _swaps = _interopRequireDefault(require("./swaps/swaps"));
var _bridge = _interopRequireDefault(require("./bridge/bridge"));
var _history = _interopRequireDefault(require("./history/history"));
var _ramps = _interopRequireDefault(require("./ramps/ramps"));
var _confirmAlerts = _interopRequireDefault(require("./confirm-alerts/confirm-alerts"));
var _smartAccounts = _interopRequireDefault(require("./smart-accounts/smart-accounts"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
var _default = exports.default = (0, _redux.combineReducers)({
  [_alerts.AlertTypes.invalidCustomNetwork]: _alerts2.invalidCustomNetwork,
  [_alerts.AlertTypes.unconnectedAccount]: _alerts2.unconnectedAccount,
  activeTab: s => s === undefined ? null : s,
  metamask: _metamask.default,
  appState: _app.default,
  DNS: _domains.default,
  history: _history.default,
  send: _send.default,
  confirmAlerts: _confirmAlerts.default,
  confirmTransaction: _confirmTransaction.default,
  swaps: _swaps.default,
  ramps: _ramps.default,
  bridge: _bridge.default,
  gas: _gas.default,
  localeMessages: _locale.default,
  smartAccounts: _smartAccounts.default
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\ducks\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\ducks\\ramps\\constants.ts", {"../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cducks%5Cramps%5Cconstants.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultBuyableChains = void 0;
var _network = require("../../../shared/constants/network");
const defaultBuyableChains = exports.defaultBuyableChains = [{
  active: true,
  chainId: 1,
  chainName: _network.MAINNET_DISPLAY_NAME,
  shortName: 'Ethereum',
  nativeTokenSupported: true
}, {
  active: true,
  chainId: 10,
  chainName: _network.OPTIMISM_DISPLAY_NAME,
  shortName: 'Optimism',
  nativeTokenSupported: true
}, {
  active: true,
  chainId: 25,
  chainName: 'Cronos Mainnet',
  shortName: 'Cronos',
  nativeTokenSupported: true
}, {
  active: true,
  chainId: 56,
  chainName: _network.BNB_DISPLAY_NAME,
  shortName: 'BNB Chain',
  nativeTokenSupported: true
}, {
  active: true,
  chainId: 100,
  chainName: 'Gnosis Mainnet',
  shortName: 'Gnosis',
  nativeTokenSupported: true
}, {
  active: true,
  chainId: 137,
  chainName: _network.POLYGON_DISPLAY_NAME,
  shortName: 'Polygon',
  nativeTokenSupported: true
}, {
  active: true,
  chainId: 250,
  chainName: 'Fantom Mainnet',
  shortName: 'Fantom',
  nativeTokenSupported: true
}, {
  active: true,
  chainId: 324,
  chainName: _network.ZK_SYNC_ERA_DISPLAY_NAME,
  shortName: 'zkSync Era',
  nativeTokenSupported: true
}, {
  active: true,
  chainId: 1101,
  chainName: 'Polygon zkEVM',
  shortName: 'Polygon zkEVM',
  nativeTokenSupported: true
}, {
  active: true,
  chainId: 1284,
  chainName: 'Moonbeam Mainnet',
  shortName: 'Moonbeam',
  nativeTokenSupported: true
}, {
  active: true,
  chainId: 1285,
  chainName: 'Moonriver Mainnet',
  shortName: 'Moonriver',
  nativeTokenSupported: true
}, {
  active: true,
  chainId: 8453,
  chainName: _network.BASE_DISPLAY_NAME,
  shortName: 'Base',
  nativeTokenSupported: true
}, {
  active: true,
  chainId: 42161,
  chainName: _network.ARBITRUM_DISPLAY_NAME,
  shortName: 'Arbitrum',
  nativeTokenSupported: true
}, {
  active: true,
  chainId: 42220,
  chainName: _network.CELO_DISPLAY_NAME,
  shortName: 'Celo',
  nativeTokenSupported: false
}, {
  active: true,
  chainId: 43114,
  chainName: _network.AVALANCHE_DISPLAY_NAME,
  shortName: 'Avalanche C-Chain',
  nativeTokenSupported: true
}, {
  active: true,
  chainId: 59144,
  chainName: _network.LINEA_MAINNET_DISPLAY_NAME,
  shortName: 'Linea',
  nativeTokenSupported: true
}, {
  active: true,
  chainId: 1313161554,
  chainName: 'Aurora Mainnet',
  shortName: 'Aurora',
  nativeTokenSupported: false
}, {
  active: true,
  chainId: 1666600000,
  chainName: 'Harmony Mainnet (Shard 0)',
  shortName: 'Harmony (Shard 0)',
  nativeTokenSupported: true
}, {
  active: true,
  chainId: 11297108109,
  chainName: 'Palm Mainnet',
  shortName: 'Palm',
  nativeTokenSupported: false
}];

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\ducks\\ramps\\constants.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\ducks\\ramps\\index.ts", {"./ramps":"D:\\code\\v\\metamask-extension\\ui\\ducks\\ramps\\ramps.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cducks%5Cramps%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _ramps = require("./ramps");
Object.keys(_ramps).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _ramps[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _ramps[key];
    }
  });
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\ducks\\ramps\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\ducks\\ramps\\ramps.ts", {"../../../shared/constants/multichain/networks":"D:\\code\\v\\metamask-extension\\shared\\constants\\multichain\\networks.ts","../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../helpers/ramps/rampApi/rampAPI":"D:\\code\\v\\metamask-extension\\ui\\helpers\\ramps\\rampApi\\rampAPI.ts","../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","./constants":"D:\\code\\v\\metamask-extension\\ui\\ducks\\ramps\\constants.ts","@reduxjs/toolkit":"D:\\code\\v\\metamask-extension\\node_modules\\@reduxjs\\toolkit\\dist\\index.js","reselect":"D:\\code\\v\\metamask-extension\\node_modules\\reselect\\dist\\cjs\\reselect.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cducks%5Cramps%5Cramps.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIsSolanaBuyable = exports.getIsNativeTokenBuyable = exports.getIsBitcoinBuyable = exports.getBuyableChains = exports.fetchBuyableChains = exports.default = void 0;
var _reselect = require("reselect");
var _toolkit = require("@reduxjs/toolkit");
var _networks = require("../../../shared/modules/selectors/networks");
var _selectors = require("../../selectors");
var _rampAPI = _interopRequireDefault(require("../../helpers/ramps/rampApi/rampAPI"));
var _conversion = require("../../../shared/modules/conversion.utils");
var _multichain = require("../../selectors/multichain");
var _networks2 = require("../../../shared/constants/multichain/networks");
var _constants = require("./constants");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const fetchBuyableChains = exports.fetchBuyableChains = (0, _toolkit.createAsyncThunk)('ramps/fetchBuyableChains', async (_, {
  getState
}) => {
  const state = getState();
  // @ts-expect-error: TS doesn't know about the root state interface yet
  const {
    isFetched
  } = state.ramps;
  const allowExternalRequests = (0, _selectors.getUseExternalServices)(state);
  if (!allowExternalRequests) {
    return _constants.defaultBuyableChains;
  }
  if (!isFetched) {
    return await _rampAPI.default.getNetworks();
  }
  // @ts-expect-error: TS doesn't know about the root state interface yet
  return state.ramps.buyableChains;
});
const rampsSlice = (0, _toolkit.createSlice)({
  name: 'ramps',
  initialState: {
    buyableChains: _constants.defaultBuyableChains,
    isFetched: false
  },
  reducers: {
    setBuyableChains: (state, action) => {
      if (Array.isArray(action.payload) && action.payload.length > 0 && action.payload.every(network => network === null || network === void 0 ? void 0 : network.chainId)) {
        state.buyableChains = action.payload;
        state.isFetched = true;
      } else {
        state.buyableChains = _constants.defaultBuyableChains;
      }
    }
  },
  extraReducers: builder => {
    builder.addCase(fetchBuyableChains.fulfilled, (state, action) => {
      const networks = action.payload;
      if (networks && networks.length > 0) {
        state.buyableChains = networks;
      } else {
        state.buyableChains = _constants.defaultBuyableChains;
      }
      state.isFetched = true;
    }).addCase(fetchBuyableChains.rejected, state => {
      state.buyableChains = _constants.defaultBuyableChains;
      state.isFetched = true;
    });
  }
});
const {
  reducer
} = rampsSlice;

// Can be typed to RootState if/when the interface is defined

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
// eslint-disable-next-line @typescript-eslint/no-explicit-any
const getBuyableChains = state => {
  var _state$ramps;
  return ((_state$ramps = state.ramps) === null || _state$ramps === void 0 ? void 0 : _state$ramps.buyableChains) ?? _constants.defaultBuyableChains;
};
exports.getBuyableChains = getBuyableChains;
const getIsBitcoinBuyable = exports.getIsBitcoinBuyable = (0, _reselect.createSelector)([getBuyableChains], buyableChains => buyableChains.filter(Boolean).some(network => network.chainId === _networks2.MultichainNetworks.BITCOIN && network.active));
const getIsSolanaBuyable = exports.getIsSolanaBuyable = (0, _reselect.createSelector)([getBuyableChains], buyableChains => {
  return buyableChains.filter(Boolean).some(network => network.chainId === _networks2.MultichainNetworks.SOLANA && network.active);
});
const getIsNativeTokenBuyable = exports.getIsNativeTokenBuyable = (0, _reselect.createSelector)([_networks.getCurrentChainId, getBuyableChains, getIsBitcoinBuyable, _multichain.getMultichainIsBitcoin, getIsSolanaBuyable, _multichain.getMultichainIsSolana], (currentChainId, buyableChains, isBtcBuyable, isBtc, isSolanaBuyable, isSolana) => {
  try {
    if (isBtc) {
      return isBtcBuyable;
    }
    if (isSolana) {
      return isSolanaBuyable;
    }
    return buyableChains.filter(Boolean).some(network => String(network.chainId) === (0, _conversion.hexToDecimal)(currentChainId));
  } catch (e) {
    return false;
  }
});
var _default = exports.default = reducer;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\ducks\\ramps\\ramps.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\ducks\\smart-accounts\\smart-accounts.ts", {"@reduxjs/toolkit":"D:\\code\\v\\metamask-extension\\node_modules\\@reduxjs\\toolkit\\dist\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cducks%5Csmart-accounts%5Csmart-accounts.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setToggleState = exports.selectToggleState = exports.default = void 0;
var _toolkit = require("@reduxjs/toolkit");
// State interface

// Initial state
const initialState = {
  toggleStates: {}
};

// Redux slice
const smartAccountsSlice = (0, _toolkit.createSlice)({
  name: 'smartAccounts',
  initialState,
  reducers: {
    // Set pending toggle state for a specific address/chainId
    setToggleState: (state, action) => {
      const {
        address,
        chainId,
        value
      } = action.payload;
      if (!state.toggleStates[address]) {
        state.toggleStates[address] = {};
      }
      if (value === null) {
        delete state.toggleStates[address][chainId];
        // Clean up empty address entries
        if (Object.keys(state.toggleStates[address]).length === 0) {
          delete state.toggleStates[address];
        }
      } else {
        state.toggleStates[address][chainId] = value;
      }
    }
  }
});

// Export actions
const {
  setToggleState
} = smartAccountsSlice.actions;

// Selectors
exports.setToggleState = setToggleState;
const selectToggleState = (state, address, chainId) => {
  var _state$smartAccounts$;
  return ((_state$smartAccounts$ = state.smartAccounts.toggleStates[address]) === null || _state$smartAccounts$ === void 0 ? void 0 : _state$smartAccounts$[chainId]) ?? null;
};

// Export reducer
exports.selectToggleState = selectToggleState;
var _default = exports.default = smartAccountsSlice.reducer;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\ducks\\smart-accounts\\smart-accounts.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\available-conversions.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Cconstants%5Cavailable-conversions.json
      return function (require, module, exports) {
module.exports=[
  {
    "code": "aud",
    "name": "Australian Dollar"
  },
  {
    "code": "hkd",
    "name": "Hong Kong Dollar"
  },
  {
    "code": "sgd",
    "name": "Singapore Dollar"
  },
  {
    "code": "idr",
    "name": "Indonesian Rupiah"
  },
  {
    "code": "inr",
    "name": "Indian Rupee"
  },
  {
    "code": "nzd",
    "name": "New Zealand Dollar"
  },
  {
    "code": "php",
    "name": "Philippine Peso"
  },
  {
    "code": "btc",
    "name": "Bitcoin"
  },
  {
    "code": "cad",
    "name": "Canadian Dollar"
  },
  {
    "code": "eur",
    "name": "Euro"
  },
  {
    "code": "gbp",
    "name": "Pound Sterling"
  },
  {
    "code": "jpy",
    "name": "Japanese Yen"
  },
  {
    "code": "ltc",
    "name": "Litecoin"
  },
  {
    "code": "rub",
    "name": "Russian Ruble"
  },
  {
    "code": "uah",
    "name": "Ukrainian Hryvnia"
  },
  {
    "code": "usd",
    "name": "United States Dollar"
  },
  {
    "code": "xlm",
    "name": "Stellar Lumen"
  },
  {
    "code": "xrp",
    "name": "Ripple"
  },
  {
    "code": "sek",
    "name": "Swedish Krona"
  },
  {
    "code": "aed",
    "name": "United Arab Emirates Dirham"
  },
  {
    "code": "ars",
    "name": "Argentine Peso"
  },
  {
    "code": "bch",
    "name": "Bitcoin Cash"
  },
  {
    "code": "bnb",
    "name": "Binance Coin"
  },
  {
    "code": "brl",
    "name": "Brazilian Real"
  },
  {
    "code": "clp",
    "name": "Chilean Peso"
  },
  {
    "code": "cny",
    "name": "Chinese Yuan"
  },
  {
    "code": "czk",
    "name": "Czech Koruna"
  },
  {
    "code": "dkk",
    "name": "Danish Krone"
  },
  {
    "code": "chf",
    "name": "Swiss Franc"
  },
  {
    "code": "dot",
    "name": "Polkadot"
  },
  {
    "code": "eos",
    "name": "EOS"
  },
  {
    "code": "eth",
    "name": "Ethereum"
  },
  {
    "code": "gel",
    "name": "Georgian Lari"
  },
  {
    "code": "huf",
    "name": "Hungarian Forint"
  },
  {
    "code": "ils",
    "name": "Israeli Shekel"
  },
  {
    "code": "krw",
    "name": "South Korean Won"
  },
  {
    "code": "mxn",
    "name": "Mexican Peso"
  },
  {
    "code": "myr",
    "name": "Malaysian Ringgit"
  },
  {
    "code": "ngn",
    "name": "Nigerian Naira"
  },
  {
    "code": "nok",
    "name": "Norwegian Krone"
  },
  {
    "code": "pln",
    "name": "Polish Zloty"
  },
  {
    "code": "thb",
    "name": "Thai Baht"
  },
  {
    "code": "try",
    "name": "Turkish Lira"
  },
  {
    "code": "zar",
    "name": "South African Rand"
  }
]

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\constants\\available-conversions.json",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\connected-sites.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Cconstants%5Cconnected-sites.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.STATUS_NOT_CONNECTED = exports.STATUS_CONNECTED_TO_SNAP = exports.STATUS_CONNECTED_TO_ANOTHER_ACCOUNT = exports.STATUS_CONNECTED = void 0;
const STATUS_CONNECTED = exports.STATUS_CONNECTED = 'STATUS_CONNECTED';
const STATUS_CONNECTED_TO_ANOTHER_ACCOUNT = exports.STATUS_CONNECTED_TO_ANOTHER_ACCOUNT = 'STATUS_CONNECTED_TO_ANOTHER_ACCOUNT';
const STATUS_NOT_CONNECTED = exports.STATUS_NOT_CONNECTED = 'STATUS_NOT_CONNECTED';
const STATUS_CONNECTED_TO_SNAP = exports.STATUS_CONNECTED_TO_SNAP = 'STATUS_CONNECTED_TO_SNAP';

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\constants\\connected-sites.js",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\gas.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Cconstants%5Cgas.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PRIORITY_LEVEL_ICON_MAP = exports.GAS_FORM_ERRORS = void 0;
exports.getGasFormErrorText = getGasFormErrorText;
const GAS_FORM_ERRORS = exports.GAS_FORM_ERRORS = {
  GAS_LIMIT_OUT_OF_BOUNDS: 'editGasLimitOutOfBounds',
  MAX_PRIORITY_FEE_TOO_LOW: 'editGasMaxPriorityFeeLow',
  MAX_FEE_TOO_LOW: 'editGasMaxFeeLow',
  MAX_PRIORITY_FEE_BELOW_MINIMUM: 'editGasMaxPriorityFeeBelowMinimum',
  MAX_PRIORITY_FEE_HIGH_WARNING: 'editGasMaxPriorityFeeHigh',
  MAX_FEE_HIGH_WARNING: 'editGasMaxFeeHigh',
  MAX_FEE_IMBALANCE: 'editGasMaxFeeImbalance',
  GAS_PRICE_TOO_LOW: 'editGasPriceTooLow'
};
function getGasFormErrorText(type, t, {
  minimumGasLimit
} = {}) {
  switch (type) {
    case GAS_FORM_ERRORS.GAS_LIMIT_OUT_OF_BOUNDS:
      return t('editGasLimitOutOfBounds', [minimumGasLimit]);
    case GAS_FORM_ERRORS.MAX_PRIORITY_FEE_TOO_LOW:
      return t('editGasMaxPriorityFeeLow');
    case GAS_FORM_ERRORS.MAX_FEE_TOO_LOW:
      return t('editGasMaxFeeLow');
    case GAS_FORM_ERRORS.MAX_PRIORITY_FEE_BELOW_MINIMUM:
      return t('editGasMaxPriorityFeeBelowMinimum');
    case GAS_FORM_ERRORS.MAX_PRIORITY_FEE_HIGH_WARNING:
      return t('editGasMaxPriorityFeeHigh');
    case GAS_FORM_ERRORS.MAX_FEE_HIGH_WARNING:
      return t('editGasMaxFeeHigh');
    case GAS_FORM_ERRORS.MAX_FEE_IMBALANCE:
      return t('editGasMaxFeePriorityImbalance');
    case GAS_FORM_ERRORS.GAS_PRICE_TOO_LOW:
      return t('editGasPriceTooLow');
    default:
      return '';
  }
}
const PRIORITY_LEVEL_ICON_MAP = exports.PRIORITY_LEVEL_ICON_MAP = {
  low: '🐢',
  medium: '🦊',
  high: '🦍',
  dappSuggested: '🌐',
  dappSuggestedHigh: '🌐',
  swapSuggested: '🔄',
  tenPercentIncreased: '⬆',
  custom: '⚙️'
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\constants\\gas.js",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\privacy-policy.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Cconstants%5Cprivacy-policy.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PRIVACY_POLICY_DATE = void 0;
// This date indicates the date of the latest privacy policy document
const PRIVACY_POLICY_DATE = exports.PRIVACY_POLICY_DATE = '2024-06-18T12:00:00Z';

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\constants\\privacy-policy.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\settings.js", {"../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../shared/modules/browser-runtime.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\browser-runtime.utils.js","../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","./routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Cconstants%5Csettings.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _app = require("../../../shared/constants/app");
var _browserRuntime = require("../../../shared/modules/browser-runtime.utils");
var _componentLibrary = require("../../components/component-library");
var _routes = require("./routes");
/* eslint-disable @metamask/design-tokens/color-no-hex*/

/**
 * @typedef SettingRouteConfig
 * # @param {Function} tabMessage
 * # @param {Function} sectionMessage
 * # @param {Function} descriptionMessage
 * # @param {string} route tab route with appended arbitrary, unique anchor tag / hash route
 * # @param {string} iconName
 * # @param {string} featureFlag ENV variable name. If the ENV value exists, the route will be searchable; else, route will not be searchable.
 * # @param {boolean} hidden If true, the route will not be searchable.
 */

/** @type {SettingRouteConfig[]} */
// When editing this array, double-check the order of the settingsRefs in the setting's respective component.
const SETTINGS_CONSTANTS = [{
  tabMessage: t => t('general'),
  sectionMessage: t => t('currencyConversion'),
  descriptionMessage: t => t('currencyConversion'),
  route: `${_routes.GENERAL_ROUTE}#currency-conversion`,
  iconName: _componentLibrary.IconName.Setting
}, {
  tabMessage: t => t('general'),
  sectionMessage: t => t('showNativeTokenAsMainBalance'),
  descriptionMessage: t => t('showNativeTokenAsMainBalance'),
  route: `${_routes.GENERAL_ROUTE}#show-native-token-as-main-balance`,
  iconName: _componentLibrary.IconName.Setting
}, {
  tabMessage: t => t('general'),
  sectionMessage: t => t('currentLanguage'),
  descriptionMessage: t => t('currentLanguage'),
  route: `${_routes.GENERAL_ROUTE}#current-language`,
  iconName: _componentLibrary.IconName.Setting
}, {
  tabMessage: t => t('general'),
  sectionMessage: t => t('theme'),
  descriptionMessage: t => t('themeDescription'),
  route: `${_routes.GENERAL_ROUTE}#theme`,
  icon: 'fa fa-flask'
}, {
  tabMessage: t => t('general'),
  sectionMessage: t => t('accountIdenticon'),
  descriptionMessage: t => t('accountIdenticon'),
  route: `${_routes.GENERAL_ROUTE}#account-identicon`,
  iconName: _componentLibrary.IconName.Setting
}, {
  tabMessage: t => t('general'),
  sectionMessage: t => t('hideZeroBalanceTokens'),
  descriptionMessage: t => t('hideZeroBalanceTokens'),
  route: `${_routes.GENERAL_ROUTE}#zero-balancetokens`,
  iconName: _componentLibrary.IconName.Setting
},
// advanced settingsRefs[0]
{
  tabMessage: t => t('advanced'),
  sectionMessage: t => t('stateLogs'),
  descriptionMessage: t => t('stateLogsDescription'),
  route: `${_routes.ADVANCED_ROUTE}#state-logs`,
  icon: 'fas fa-sliders-h'
},
// advanced settingsRefs[1]
{
  tabMessage: t => t('advanced'),
  sectionMessage: t => t('clearActivity'),
  descriptionMessage: t => t('clearActivityDescription'),
  route: `${_routes.ADVANCED_ROUTE}#clear-activity`,
  icon: 'fas fa-sliders-h'
},
// advanced settingsRefs[2]
{
  tabMessage: t => t('advanced'),
  sectionMessage: t => t('smartTransactions'),
  descriptionMessage: t => t('stxOptInSupportedNetworksDescription'),
  route: `${_routes.ADVANCED_ROUTE}#smart-transactions`,
  icon: 'fas fa-upload'
},
// advanced settingsRefs[3]
{
  tabMessage: t => t('advanced'),
  sectionMessage: t => t('showHexData'),
  descriptionMessage: t => t('showHexDataDescription'),
  route: `${_routes.ADVANCED_ROUTE}#show-hexdata`,
  icon: 'fas fa-sliders-h'
},
// advanced settingsRefs[4]
{
  tabMessage: t => t('advanced'),
  sectionMessage: t => t('showFiatConversionInTestnets'),
  descriptionMessage: t => t('showFiatConversionInTestnetsDescription'),
  route: `${_routes.ADVANCED_ROUTE}#conversion-testnetworks`,
  icon: 'fas fa-sliders-h'
},
// advanced settingsRefs[5]
{
  tabMessage: t => t('advanced'),
  sectionMessage: t => t('showTestnetNetworks'),
  descriptionMessage: t => t('showTestnetNetworksDescription'),
  route: `${_routes.ADVANCED_ROUTE}#show-testnets`,
  icon: 'fas fa-sliders-h'
},
// advanced settingsRefs[6]
{
  tabMessage: t => t('advanced'),
  sectionMessage: t => t('autoLockTimeLimit'),
  descriptionMessage: t => t('autoLockTimeLimitDescription'),
  route: `${_routes.ADVANCED_ROUTE}#autolock-timer`,
  icon: 'fas fa-sliders-h'
},
// advanced settingsRefs[7]
{
  tabMessage: t => t('advanced'),
  sectionMessage: t => t('showExtensionInFullSizeView'),
  descriptionMessage: t => t('showExtensionInFullSizeViewDescription'),
  route: `${_routes.ADVANCED_ROUTE}#extension-full-size-view`,
  icon: 'fas fa-sliders-h'
},
// advanced settingsRefs[8]
{
  tabMessage: t => t('advanced'),
  sectionMessage: t => t('dismissReminderField'),
  descriptionMessage: t => t('dismissReminderDescriptionField'),
  route: `${_routes.ADVANCED_ROUTE}#dismiss-secretrecovery`,
  icon: 'fas fa-sliders-h'
},
// advanced settingsRefs[9]
{
  tabMessage: t => t('advanced'),
  sectionMessage: t => t('exportYourData'),
  descriptionMessage: t => t('exportYourDataDescription'),
  route: `${_routes.ADVANCED_ROUTE}#export-data`,
  icon: 'fas fa-download'
},
// advanced settingsRefs[10]
{
  tabMessage: t => t('advanced'),
  sectionMessage: t => t('overrideContentSecurityPolicyHeader'),
  descriptionMessage: t => t('overrideContentSecurityPolicyHeaderDescription'),
  route: `${_routes.ADVANCED_ROUTE}#override-content-security-policy-header`,
  icon: 'fas fa-sliders-h',
  hidden: (0, _browserRuntime.getBrowserName)() !== _app.PLATFORM_FIREFOX
}, {
  tabMessage: t => t('backupAndSync'),
  sectionMessage: t => t('backupAndSyncEnable'),
  descriptionMessage: t => t('backupAndSyncEnable'),
  route: `${_routes.BACKUPANDSYNC_ROUTE}#backup-and-sync-toggle`,
  iconName: _componentLibrary.IconName.SecurityTime
}, {
  tabMessage: t => t('backupAndSync'),
  sectionMessage: t => t('backupAndSyncFeatureAccounts'),
  descriptionMessage: t => t('backupAndSyncFeatureAccounts'),
  route: `${_routes.BACKUPANDSYNC_ROUTE}#backup-and-sync-features-toggles-account-syncing`,
  iconName: _componentLibrary.IconName.SecurityTime
}, {
  tabMessage: t => t('backupAndSync'),
  sectionMessage: t => t('backupAndSyncFeatureContacts'),
  descriptionMessage: t => t('backupAndSyncFeatureContacts'),
  route: `${_routes.BACKUPANDSYNC_ROUTE}#backup-and-sync-features-toggles-contact-syncing`,
  iconName: _componentLibrary.IconName.SecurityTime
}, {
  tabMessage: t => t('contacts'),
  sectionMessage: t => t('contacts'),
  descriptionMessage: t => t('contacts'),
  route: _routes.CONTACT_LIST_ROUTE,
  iconName: _componentLibrary.IconName.Book
},
// securityAndPrivacy settingsRefs[0]
{
  tabMessage: t => t('securityAndPrivacy'),
  sectionMessage: t => t('basicConfigurationLabel'),
  descriptionMessage: t => t('basicConfigurationDescription'),
  route: `${_routes.SECURITY_ROUTE}#basic-functionality-toggle`,
  icon: 'fa fa-lock'
},
// securityAndPrivacy settingsRefs[1]
{
  tabMessage: t => t('securityAndPrivacy'),
  sectionMessage: t => t('revealSeedWords'),
  descriptionMessage: t => t('revealSeedWords'),
  route: `${_routes.SECURITY_ROUTE}#reveal-secretrecovery`,
  icon: 'fa fa-lock'
},
// securityAndPrivacy settingsRefs[2]
{
  tabMessage: t => t('securityAndPrivacy'),
  sectionMessage: t => t('securityChangePassword'),
  descriptionMessage: t => t('securityChangePassword'),
  route: _routes.SECURITY_PASSWORD_CHANGE_ROUTE,
  icon: 'fa fa-lock'
},
// securityAndPrivacy settingsRefs[3]
{
  tabMessage: t => t('securityAndPrivacy'),
  sectionMessage: t => t('usePhishingDetection'),
  descriptionMessage: t => t('usePhishingDetectionDescription'),
  route: `${_routes.SECURITY_ROUTE}#phishing-detection`,
  icon: 'fa fa-lock'
},
// securityAndPrivacy settingsRefs[4]
{
  tabMessage: t => t('securityAndPrivacy'),
  sectionMessage: t => t('skipDeepLinkInterstitial'),
  descriptionMessage: t => t('skipDeepLinkInterstitialDescription'),
  route: `${_routes.SECURITY_ROUTE}#skip-deep-link-interstitial`,
  icon: 'fa fa-lock'
},
// securityAndPrivacy settingsRefs[5]
{
  tabMessage: t => t('securityAndPrivacy'),
  sectionMessage: t => t('use4ByteResolution'),
  descriptionMessage: t => t('toggleDecodeDescription'),
  route: `${_routes.SECURITY_ROUTE}#decode-smart-contracts`,
  icon: 'fa fa-lock'
},
// securityAndPrivacy settingsRefs[6]
{
  tabMessage: t => t('securityAndPrivacy'),
  sectionMessage: t => t('participateInMetaMetrics'),
  descriptionMessage: t => t('participateInMetaMetricsDescription'),
  route: `${_routes.SECURITY_ROUTE}#metametrics`,
  icon: 'fa fa-lock'
},
// securityAndPrivacy settingsRefs[7]
{
  tabMessage: t => t('securityAndPrivacy'),
  sectionMessage: t => t('networkProvider'),
  descriptionMessage: t => `${t('chooseYourNetwork')} ${t('chooseYourNetworkDescription')}`,
  route: `${_routes.SECURITY_ROUTE}#network-provider`,
  icon: 'fa fa-lock'
},
// securityAndPrivacy settingsRefs[8]
{
  tabMessage: t => t('securityAndPrivacy'),
  sectionMessage: t => t('ipfsGateway'),
  descriptionMessage: t => t('ipfsGatewayDescription'),
  route: `${_routes.SECURITY_ROUTE}#add-custom-ipfs-gateway`,
  icon: 'fa fa-lock'
},
// securityAndPrivacy settingsRefs[9]
{
  tabMessage: t => t('securityAndPrivacy'),
  sectionMessage: t => t('autoDetectTokens'),
  descriptionMessage: t => t('autoDetectTokensDescription'),
  route: `${_routes.SECURITY_ROUTE}#auto-detect-tokens`,
  icon: 'fa fa-lock'
},
// securityAndPrivacy settingsRefs[10]
{
  tabMessage: t => t('securityAndPrivacy'),
  sectionMessage: t => t('useMultiAccountBalanceChecker'),
  descriptionMessage: t => t('useMultiAccountBalanceCheckerSettingDescription'),
  route: `${_routes.SECURITY_ROUTE}#batch-account-balance-requests`,
  icon: 'fa fa-lock'
},
// securityAndPrivacy settingsRefs[11]
{
  tabMessage: t => t('securityAndPrivacy'),
  sectionMessage: t => t('currencyRateCheckToggle'),
  descriptionMessage: t => t('currencyRateCheckToggleDescription'),
  route: `${_routes.SECURITY_ROUTE}#price-checker`,
  icon: 'fa fa-lock'
},
// securityAndPrivacy settingsRefs[12]
{
  tabMessage: t => t('securityAndPrivacy'),
  sectionMessage: t => t('ensDomainsSettingTitle'),
  descriptionMessage: t => t('ensDomainsSettingDescriptionIntroduction'),
  route: `${_routes.SECURITY_ROUTE}#ens-domains`,
  icon: 'fa fa-lock'
},
// securityAndPrivacy settingsRefs[13]
{
  tabMessage: t => t('securityAndPrivacy'),
  sectionMessage: t => t('displayNftMedia'),
  descriptionMessage: t => t('displayNftMediaDescription'),
  route: `${_routes.SECURITY_ROUTE}#display-nft-media`,
  icon: 'fa fa-lock'
},
// securityAndPrivacy settingsRefs[14]
{
  tabMessage: t => t('securityAndPrivacy'),
  sectionMessage: t => t('useNftDetection'),
  descriptionMessage: t => t('useNftDetectionDescriptionText'),
  route: `${_routes.SECURITY_ROUTE}#autodetect-nfts`,
  icon: 'fa fa-lock'
},
// securityAndPrivacy settingsRefs[15]
{
  tabMessage: t => t('securityAndPrivacy'),
  sectionMessage: t => t('useSafeChainsListValidation'),
  descriptionMessage: t => t('useSafeChainsListValidationDescription'),
  route: `${_routes.SECURITY_ROUTE}#network-details-check`,
  icon: 'fa fa-lock'
},
// securityAndPrivacy settingsRefs[16]
{
  tabMessage: t => t('securityAndPrivacy'),
  sectionMessage: t => t('externalNameSourcesSetting'),
  descriptionMessage: t => t('externalNameSourcesSettingDescription'),
  route: `${_routes.SECURITY_ROUTE}#proposed-nicknames`,
  icon: 'fa fa-lock'
},
// securityAndPrivacy settingsRefs[17]
{
  tabMessage: t => t('securityAndPrivacy'),
  sectionMessage: t => t('securityAlerts'),
  descriptionMessage: t => t('securityAlertsDescription'),
  route: `${_routes.SECURITY_ROUTE}#security-alerts`,
  icon: 'fa fa-lock'
},
// securityAndPrivacy settingsRefs[18]
{
  tabMessage: t => t('securityAndPrivacy'),
  sectionMessage: t => t('blockaid'),
  descriptionMessage: t => t('blockaidMessage'),
  route: `${_routes.SECURITY_ROUTE}#security-alerts-blockaid`,
  icon: 'fa fa-lock'
},
// securityAndPrivacy settingsRefs[19]
{
  tabMessage: t => t('securityAndPrivacy'),
  sectionMessage: t => t('simulationsSettingSubHeader'),
  descriptionMessage: t => t('simulationsSettingDescription'),
  route: `${_routes.SECURITY_ROUTE}#transaction-simulations`,
  icon: 'fa fa-lock'
},
// securityAndPrivacy settingsRefs[20]
{
  tabMessage: t => t('securityAndPrivacy'),
  sectionMessage: t => t('dataCollectionForMarketing'),
  descriptionMessage: t => t('dataCollectionForMarketingDescription'),
  route: `${_routes.SECURITY_ROUTE}#dataCollectionForMarketing`,
  icon: 'fa fa-lock'
},
// securityAndPrivacy settingsRefs[21]
{
  tabMessage: t => t('securityAndPrivacy'),
  sectionMessage: t => t('deleteMetaMetricsData'),
  descriptionMessage: t => t('deleteMetaMetricsDataDescription'),
  route: `${_routes.SECURITY_ROUTE}#delete-metametrics-data`,
  icon: 'fa fa-lock'
}, {
  tabMessage: t => t('networks'),
  sectionMessage: t => t('mainnet'),
  descriptionMessage: t => t('mainnet'),
  route: `${_routes.NETWORKS_ROUTE}#networks-mainnet`,
  icon: 'fa fa-plug'
}, {
  tabMessage: t => t('networks'),
  sectionMessage: t => t('lineaMainnet'),
  descriptionMessage: t => t('lineaMainnet'),
  route: `${_routes.NETWORKS_ROUTE}#networks-linea-mainnet`,
  icon: 'fa fa-plug'
}, {
  tabMessage: t => t('networks'),
  sectionMessage: t => t('goerli'),
  descriptionMessage: t => t('goerli'),
  route: `${_routes.NETWORKS_ROUTE}#networks-goerli`,
  icon: 'fa fa-plug'
}, {
  tabMessage: t => t('networks'),
  sectionMessage: t => t('sepolia'),
  descriptionMessage: t => t('sepolia'),
  route: `${_routes.NETWORKS_ROUTE}#networks-sepolia`,
  icon: 'fa fa-plug'
}, {
  tabMessage: t => t('networks'),
  sectionMessage: t => t('lineaGoerli'),
  descriptionMessage: t => t('lineaGoerli'),
  route: `${_routes.NETWORKS_ROUTE}#networks-linea-goerli`,
  icon: 'fa fa-plug'
}, {
  tabMessage: t => t('networks'),
  sectionMessage: t => t('lineaSepolia'),
  descriptionMessage: t => t('lineaSepolia'),
  route: `${_routes.NETWORKS_ROUTE}#networks-linea-sepolia`,
  icon: 'fa fa-plug'
}, {
  tabMessage: t => t('networks'),
  sectionMessage: t => t('localhost'),
  descriptionMessage: t => t('localhost'),
  route: `${_routes.NETWORKS_ROUTE}#networks-localhost`,
  icon: 'fa fa-plug'
}, {
  tabMessage: t => t('about'),
  sectionMessage: t => t('metamaskVersion'),
  descriptionMessage: t => t('builtAroundTheWorld'),
  route: `${_routes.ABOUT_US_ROUTE}#version`,
  iconName: _componentLibrary.IconName.Info
}, {
  tabMessage: t => t('about'),
  sectionMessage: t => t('links'),
  descriptionMessage: t => t('links'),
  route: `${_routes.ABOUT_US_ROUTE}#links`,
  iconName: _componentLibrary.IconName.Info
}, {
  tabMessage: t => t('about'),
  sectionMessage: t => t('privacyMsg'),
  descriptionMessage: t => t('privacyMsg'),
  route: `${_routes.ABOUT_US_ROUTE}#privacy-policy`,
  iconName: _componentLibrary.IconName.Info
}, {
  tabMessage: t => t('about'),
  sectionMessage: t => t('terms'),
  descriptionMessage: t => t('terms'),
  route: `${_routes.ABOUT_US_ROUTE}#terms`,
  iconName: _componentLibrary.IconName.Info
}, {
  tabMessage: t => t('about'),
  sectionMessage: t => t('attributions'),
  descriptionMessage: t => t('attributions'),
  route: `${_routes.ABOUT_US_ROUTE}#attributions`,
  iconName: _componentLibrary.IconName.Info
}, {
  tabMessage: t => t('about'),
  sectionMessage: t => t('supportCenter'),
  descriptionMessage: t => t('supportCenter'),
  route: `${_routes.ABOUT_US_ROUTE}#supportcenter`,
  iconName: _componentLibrary.IconName.Info
}, {
  tabMessage: t => t('about'),
  sectionMessage: t => t('visitWebSite'),
  descriptionMessage: t => t('visitWebSite'),
  route: `${_routes.ABOUT_US_ROUTE}#visitwebsite`,
  iconName: _componentLibrary.IconName.Info
}, {
  tabMessage: t => t('about'),
  sectionMessage: t => t('contactUs'),
  descriptionMessage: t => t('contactUs'),
  route: `${_routes.ABOUT_US_ROUTE}#contactus`,
  iconName: _componentLibrary.IconName.Info
}, {
  tabMessage: t => t('about'),
  sectionMessage: t => t('betaTerms'),
  descriptionMessage: t => t('betaTerms'),
  route: `${_routes.ABOUT_US_ROUTE}#beta-terms`,
  iconName: _componentLibrary.IconName.Info
}, {
  featureFlag: 'METAMASK_SHIELD_ENABLED',
  tabMessage: t => t('shieldTx'),
  sectionMessage: t => t('shieldTx'),
  descriptionMessage: t => t('shieldTx'),
  route: `${_routes.TRANSACTION_SHIELD_ROUTE}`,
  iconName: _componentLibrary.IconName.ShieldLock
}, {
  featureFlag: 'METAMASK_SHIELD_ENABLED',
  tabMessage: t => t('shieldClaim'),
  sectionMessage: t => t('shieldClaim'),
  descriptionMessage: t => t('shieldClaim'),
  route: `${_routes.TRANSACTION_SHIELD_CLAIM_ROUTE}`,
  iconName: _componentLibrary.IconName.ShieldLock
},
// experimental settingsRefs[0]
{
  tabMessage: t => t('experimental'),
  sectionMessage: t => t('notificationsFeatureToggle'),
  descriptionMessage: t => t('notificationsFeatureToggleDescription'),
  route: `${_routes.EXPERIMENTAL_ROUTE}#notifications`,
  icon: 'fas fa-flask'
},
///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
// since this route is only included with keyring-snaps feature flag, this needs to be the last settingsRef for the experimental tab
// experimental settingsRefs[4]
{
  tabMessage: t => t('experimental'),
  sectionMessage: t => t('snaps'),
  descriptionMessage: t => t('addSnapAccountToggle'),
  route: `${_routes.EXPERIMENTAL_ROUTE}#snaps`,
  icon: 'fas fa-flask'
},
///: END:ONLY_INCLUDE_IF
// developerOptions settingsRefs[0]
{
  featureFlag: 'ENABLE_SETTINGS_PAGE_DEV_OPTIONS',
  tabMessage: t => t('developerOptions'),
  sectionMessage: () => 'Reset States',
  descriptionMessage: () => 'Reset States',
  route: `${_routes.DEVELOPER_OPTIONS_ROUTE}#reset-states`,
  iconName: _componentLibrary.IconName.CodeCircle
},
// developerOptions settingsRefs[1]
{
  featureFlag: 'ENABLE_SETTINGS_PAGE_DEV_OPTIONS',
  tabMessage: t => t('developerOptions'),
  sectionMessage: () => 'Announcements',
  descriptionMessage: () => "Resets isShown boolean to false for all announcements. Announcements are the notifications shown in the What's New popup modal.",
  route: `${_routes.DEVELOPER_OPTIONS_ROUTE}#reset-states-announcements`,
  iconName: _componentLibrary.IconName.CodeCircle
},
// developerOptions settingsRefs[2]
{
  featureFlag: 'ENABLE_SETTINGS_PAGE_DEV_OPTIONS',
  tabMessage: t => t('developerOptions'),
  sectionMessage: () => 'Service Worker Keep Alive',
  descriptionMessage: () => 'Resets various states related to onboarding and redirects to the "Secure Your Wallet" onboarding page.',
  route: `${_routes.DEVELOPER_OPTIONS_ROUTE}#reset-states-onboarding`,
  iconName: _componentLibrary.IconName.CodeCircle
},
// developerOptions settingsRefs[3]
{
  featureFlag: 'ENABLE_SETTINGS_PAGE_DEV_OPTIONS',
  tabMessage: t => t('developerOptions'),
  sectionMessage: () => 'Service Worker Keep Alive',
  descriptionMessage: () => 'Results in a timestamp being continuously saved to session.storage',
  route: `${_routes.DEVELOPER_OPTIONS_ROUTE}#service-worker-keep-alive`,
  iconName: _componentLibrary.IconName.CodeCircle
}];
var _default = exports.default = SETTINGS_CONSTANTS;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\constants\\settings.js",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\snaps\\delineator.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Cconstants%5Csnaps%5Cdelineator.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDelineatorTitle = exports.DelineatorType = void 0;
let DelineatorType = exports.DelineatorType = /*#__PURE__*/function (DelineatorType) {
  DelineatorType["Content"] = "content";
  DelineatorType["Error"] = "error";
  DelineatorType["Insights"] = "insights";
  DelineatorType["Description"] = "description";
  DelineatorType["Warning"] = "warning";
  return DelineatorType;
}({});
const getDelineatorTitle = type => {
  switch (type) {
    case DelineatorType.Error:
      return 'errorWithSnap';
    case DelineatorType.Insights:
      return 'insightsFromSnap';
    case DelineatorType.Description:
      return 'descriptionFromSnap';
    case DelineatorType.Warning:
      return 'warningFromSnap';
    default:
      return 'contentFromSnap';
  }
};
exports.getDelineatorTitle = getDelineatorTitle;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\constants\\snaps\\delineator.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\snaps\\index.js", {"./delineator":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\snaps\\delineator.ts","./insights":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\snaps\\insights.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Cconstants%5Csnaps%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _delineator = require("./delineator");
Object.keys(_delineator).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _delineator[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _delineator[key];
    }
  });
});
var _insights = require("./insights");
Object.keys(_insights).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _insights[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _insights[key];
    }
  });
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\constants\\snaps\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\snaps\\insights.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Cconstants%5Csnaps%5Cinsights.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InsightWarningLanguage = void 0;
/**
 * Mapping of actions to the language needed to be used in
 * the translations for the insight warnings modal.
 */
const InsightWarningLanguage = exports.InsightWarningLanguage = {
  confirming: {
    noun: 'transaction',
    imperative: 'confirm'
  },
  signing: {
    noun: 'signature',
    imperative: 'sign'
  }
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\constants\\snaps\\insights.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\survey.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Cconstants%5Csurvey.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SURVEY_START_TIME = exports.SURVEY_START_HOUR = exports.SURVEY_GMT = exports.SURVEY_END_TIME = exports.SURVEY_END_HOUR = exports.SURVEY_DATE = void 0;
const SURVEY_DATE = exports.SURVEY_DATE = 'February 28 2024';
const SURVEY_GMT = exports.SURVEY_GMT = 'GMT-0600';
const SURVEY_START_HOUR = exports.SURVEY_START_HOUR = '12:00:00';
const SURVEY_END_HOUR = exports.SURVEY_END_HOUR = '13:00:00';
const SURVEY_START_TIME = exports.SURVEY_START_TIME = `${SURVEY_START_HOUR} ${SURVEY_GMT}`;
const SURVEY_END_TIME = exports.SURVEY_END_TIME = `${SURVEY_END_HOUR} ${SURVEY_GMT}`;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\constants\\survey.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\higher-order-components\\authenticated\\authenticated.component.js", {"../../constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Chigher-order-components%5Cauthenticated%5Cauthenticated.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Authenticated;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRouterDom = require("react-router-dom");
var _routes = require("../../constants/routes");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const OnboardingRoute = {
  pathname: _routes.ONBOARDING_ROUTE
};
function Authenticated(props) {
  const {
    isUnlocked,
    completedOnboarding
  } = props;
  const location = (0, _reactRouterDom.useLocation)();
  switch (true) {
    case isUnlocked && completedOnboarding:
      return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Route, props);
    case !completedOnboarding:
      return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
        to: OnboardingRoute
      });
    default:
      return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
        to: {
          pathname: _routes.UNLOCK_ROUTE,
          state: {
            from: location
          }
        }
      });
  }
}
Authenticated.propTypes = {
  isUnlocked: _propTypes.default.bool,
  completedOnboarding: _propTypes.default.bool,
  path: _propTypes.default.string,
  component: _propTypes.default.object,
  exact: _propTypes.default.bool
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\higher-order-components\\authenticated\\authenticated.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\higher-order-components\\authenticated\\authenticated.container.js", {"./authenticated.component":"D:\\code\\v\\metamask-extension\\ui\\helpers\\higher-order-components\\authenticated\\authenticated.component.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Chigher-order-components%5Cauthenticated%5Cauthenticated.container.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactRedux = require("react-redux");
var _authenticated = _interopRequireDefault(require("./authenticated.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const mapStateToProps = state => {
  const {
    metamask: {
      isUnlocked,
      completedOnboarding
    }
  } = state;
  return {
    isUnlocked,
    completedOnboarding
  };
};
var _default = exports.default = (0, _reactRedux.connect)(mapStateToProps)(_authenticated.default);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\higher-order-components\\authenticated\\authenticated.container.js",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\higher-order-components\\authenticated\\index.js", {"./authenticated.container":"D:\\code\\v\\metamask-extension\\ui\\helpers\\higher-order-components\\authenticated\\authenticated.container.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Chigher-order-components%5Cauthenticated%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _authenticated.default;
  }
});
var _authenticated = _interopRequireDefault(require("./authenticated.container"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\higher-order-components\\authenticated\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\higher-order-components\\feature-toggled-route.js", {"prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Chigher-order-components%5Cfeature-toggled-route.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = FeatureToggledRoute;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRouterDom = require("react-router-dom");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function FeatureToggledRoute({
  flag,
  redirectRoute,
  ...props
}) {
  const redirect = (0, _react.useMemo)(() => ({
    pathname: redirectRoute
  }), [redirectRoute]);
  if (flag) {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Route, props);
  }
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: redirect
  });
}
FeatureToggledRoute.propTypes = {
  flag: _propTypes.default.bool.isRequired,
  redirectRoute: _propTypes.default.string.isRequired
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\higher-order-components\\feature-toggled-route.js",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\higher-order-components\\initialized\\index.js", {"./initialized.container":"D:\\code\\v\\metamask-extension\\ui\\helpers\\higher-order-components\\initialized\\initialized.container.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Chigher-order-components%5Cinitialized%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _initialized.default;
  }
});
var _initialized = _interopRequireDefault(require("./initialized.container"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\higher-order-components\\initialized\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\higher-order-components\\initialized\\initialized.component.js", {"../../constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Chigher-order-components%5Cinitialized%5Cinitialized.component.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Initialized;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRouterDom = require("react-router-dom");
var _routes = require("../../constants/routes");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const onboardingRoute = {
  pathname: _routes.ONBOARDING_ROUTE
};
function Initialized(props) {
  return props.completedOnboarding ? /*#__PURE__*/_react.default.createElement(_reactRouterDom.Route, props) : /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: onboardingRoute
  });
}
Initialized.propTypes = {
  completedOnboarding: _propTypes.default.bool,
  path: _propTypes.default.string,
  component: _propTypes.default.object,
  exact: _propTypes.default.bool
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\higher-order-components\\initialized\\initialized.component.js",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\higher-order-components\\initialized\\initialized.container.js", {"./initialized.component":"D:\\code\\v\\metamask-extension\\ui\\helpers\\higher-order-components\\initialized\\initialized.component.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Chigher-order-components%5Cinitialized%5Cinitialized.container.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactRedux = require("react-redux");
var _initialized = _interopRequireDefault(require("./initialized.component"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const mapStateToProps = state => {
  const {
    metamask: {
      completedOnboarding
    }
  } = state;
  return {
    completedOnboarding
  };
};
var _default = exports.default = (0, _reactRedux.connect)(mapStateToProps)(_initialized.default);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\higher-order-components\\initialized\\initialized.container.js",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\higher-order-components\\with-modal-props\\index.js", {"./with-modal-props":"D:\\code\\v\\metamask-extension\\ui\\helpers\\higher-order-components\\with-modal-props\\with-modal-props.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Chigher-order-components%5Cwith-modal-props%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _withModalProps.default;
  }
});
var _withModalProps = _interopRequireDefault(require("./with-modal-props"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\higher-order-components\\with-modal-props\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\higher-order-components\\with-modal-props\\with-modal-props.js", {"../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Chigher-order-components%5Cwith-modal-props%5Cwith-modal-props.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = withModalProps;
var _reactRedux = require("react-redux");
var _actions = require("../../../store/actions");
const mapStateToProps = state => {
  const {
    appState
  } = state;
  const {
    props: modalProps
  } = appState.modal.modalState;
  return {
    ...modalProps
  };
};
const mapDispatchToProps = dispatch => {
  return {
    hideModal: () => dispatch((0, _actions.hideModal)())
  };
};
function withModalProps(Component) {
  return (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(Component);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\higher-order-components\\with-modal-props\\with-modal-props.js",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\higher-order-components\\with-router-hooks\\with-router-hooks.tsx", {"react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Chigher-order-components%5Cwith-router-hooks%5Cwith-router-hooks.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
// Types for the router hooks

function withRouterHooks(WrappedComponent) {
  function componentWithRouterHooks(props) {
    const navigate = (0, _reactRouterDomV5Compat.useNavigate)();
    const location = (0, _reactRouterDomV5Compat.useLocation)();
    const params = (0, _reactRouterDomV5Compat.useParams)();
    return /*#__PURE__*/_react.default.createElement(WrappedComponent, _extends({}, props, {
      navigate: navigate,
      location: location,
      params: params
    }));
  }

  // Preserve component name for debugging
  componentWithRouterHooks.displayName = `withRouterHooks(${WrappedComponent.displayName || WrappedComponent.name || 'Component'})`;
  return componentWithRouterHooks;
}
var _default = exports.default = withRouterHooks;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\higher-order-components\\with-router-hooks\\with-router-hooks.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\ramps\\rampApi\\rampAPI.ts", {"../../../../shared/modules/fetch-with-timeout":"D:\\code\\v\\metamask-extension\\shared\\modules\\fetch-with-timeout.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Cramps%5CrampApi%5CrampAPI.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _fetchWithTimeout = _interopRequireDefault(require("../../../../shared/modules/fetch-with-timeout"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const fetchWithTimeout = (0, _fetchWithTimeout.default)();
const isProdEnv = "development" === 'production';
const PROD_RAMP_API_BASE_URL = 'https://on-ramp-content.api.cx.metamask.io';
const UAT_RAMP_API_BASE_URL = 'https://on-ramp-content.uat-api.cx.metamask.io';
const rampApiBaseUrl =
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
// eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
"https://on-ramp-content.api.cx.metamask.io" || (isProdEnv ? PROD_RAMP_API_BASE_URL : UAT_RAMP_API_BASE_URL);
const RampAPI = {
  async getNetworks() {
    const url = new URL('/regions/networks', rampApiBaseUrl);
    const response = await fetchWithTimeout(url.toString());
    const {
      networks
    } = await response.json();
    return networks;
  }
};
var _default = exports.default = RampAPI;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\ramps\\rampApi\\rampAPI.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\accounts.js", {"../../../shared/constants/hardware-wallets":"D:\\code\\v\\metamask-extension\\shared\\constants\\hardware-wallets.ts","../../../shared/constants/keyring":"D:\\code\\v\\metamask-extension\\shared\\constants\\keyring.ts","../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../shared/lib/snaps/snaps":"D:\\code\\v\\metamask-extension\\shared\\lib\\snaps\\snaps.ts","../../../shared/lib/translate":"D:\\code\\v\\metamask-extension\\shared\\lib\\translate.ts","../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","@metamask/snaps-sdk/jsx":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\jsx.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Cutils%5Caccounts.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAccountLabels = getAccountLabels;
exports.getAccountNameErrorMessage = getAccountNameErrorMessage;
exports.getAvatarNetworkColor = getAvatarNetworkColor;
var _jsx = require("@metamask/snaps-sdk/jsx");
var _componentLibrary = require("../../components/component-library");
var _network = require("../../../shared/constants/network");
var _designSystem = require("../constants/design-system");
var _keyring = require("../../../shared/constants/keyring");
var _hardwareWallets = require("../../../shared/constants/hardware-wallets");
var _translate = require("../../../shared/lib/translate");
var _snaps = require("../../../shared/lib/snaps/snaps");
function getAccountNameErrorMessage(accounts, context, newAccountName, defaultAccountName) {
  const isDuplicateAccountName = accounts.some(item => {
    var _item$metadata;
    return ((_item$metadata = item.metadata) === null || _item$metadata === void 0 || (_item$metadata = _item$metadata.name) === null || _item$metadata === void 0 ? void 0 : _item$metadata.toLowerCase()) === (newAccountName === null || newAccountName === void 0 ? void 0 : newAccountName.toLowerCase());
  });
  const isEmptyAccountName = !newAccountName || newAccountName === '';
  const localizedWordForAccount = context.t('newAccountNumberName').replace(' $1', '');

  // Match strings starting with ${localizedWordForAccount} and then any numeral, case insensitive
  // Trim spaces before and after
  const reservedRegEx = new RegExp(`^\\s*${localizedWordForAccount} \\d+\\s*$`, 'iu');
  const isReservedAccountName = reservedRegEx.test(newAccountName || '');
  const isValidAccountName = (newAccountName === null || newAccountName === void 0 ? void 0 : newAccountName.toLowerCase()) === (defaultAccountName === null || defaultAccountName === void 0 ? void 0 : defaultAccountName.toLowerCase()) ||
  // What is written in the text
  // field is the same as the
  // placeholder
  !isDuplicateAccountName && !isReservedAccountName && !isEmptyAccountName;
  let errorMessage;
  if (isValidAccountName) {
    errorMessage = _componentLibrary.InvisibleCharacter; // Using an invisible character, so the spacing stays
    // constant
  } else if (isDuplicateAccountName) {
    errorMessage = context.t('accountNameDuplicate');
  } else if (isReservedAccountName) {
    errorMessage = context.t('accountNameReserved');
  } else if (isEmptyAccountName) {
    errorMessage = context.t('required');
  }
  return {
    isValidAccountName,
    errorMessage
  };
}
function getAvatarNetworkColor(name) {
  switch (name) {
    case _network.GOERLI_DISPLAY_NAME:
      return _designSystem.BackgroundColor.goerli;
    case _network.LINEA_GOERLI_DISPLAY_NAME:
      return _designSystem.BackgroundColor.lineaGoerli;
    case _network.LINEA_SEPOLIA_DISPLAY_NAME:
      return _designSystem.BackgroundColor.lineaSepolia;
    case _network.SEPOLIA_DISPLAY_NAME:
      return _designSystem.BackgroundColor.sepolia;
    default:
      return undefined;
  }
}
const toSrpLabel = index =>
// Index starts at 1, for SRPs.
`SRP #${index + 1}`;
function getAccountLabels(type, account, keyrings,
///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
snapName
///: END:ONLY_INCLUDE_IF
) {
  if (!account) {
    return [];
  }
  const labels = [];
  const hdKeyrings = keyrings.filter(keyring => keyring.type === _keyring.KeyringType.hdKeyTree);
  switch (type) {
    case _keyring.KeyringType.hdKeyTree:
      {
        if (hdKeyrings.length > 1) {
          const hdKeyringIndex = hdKeyrings.findIndex(kr => kr.accounts.includes(account.address));
          labels.push({
            label: toSrpLabel(hdKeyringIndex),
            icon: null
          });
        }
        break;
      }
    case _keyring.KeyringType.imported:
      labels.push({
        label: (0, _translate.t)('imported'),
        icon: null
      });
      break;
    case _keyring.KeyringType.qr:
      labels.push({
        label: _hardwareWallets.HardwareKeyringNames.qr,
        icon: null
      });
      break;
    case _keyring.KeyringType.trezor:
      labels.push({
        label: _hardwareWallets.HardwareKeyringNames.trezor,
        icon: null
      });
      break;
    case _keyring.KeyringType.ledger:
      labels.push({
        label: _hardwareWallets.HardwareKeyringNames.ledger,
        icon: null
      });
      break;
    case _keyring.KeyringType.oneKey:
      labels.push({
        label: _hardwareWallets.HardwareKeyringNames.oneKey,
        icon: null
      });
      break;
    case _keyring.KeyringType.lattice:
      labels.push({
        label: _hardwareWallets.HardwareKeyringNames.lattice,
        icon: null
      });
      break;
    ///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
    case _keyring.KeyringType.snap:
      {
        const {
          entropySource
        } = account.options;
        if (entropySource && hdKeyrings.length > 1) {
          const hdKeyringIndex = hdKeyrings.findIndex(kr => kr.metadata.id === entropySource);
          labels.push({
            label: toSrpLabel(hdKeyringIndex),
            icon: null
          });
        }
        const isPreinstalled = (0, _snaps.isSnapPreinstalled)(account.metadata.snap.id);
        if (isPreinstalled) {
          break;
        }
        if (snapName) {
          labels.push({
            label: `${snapName} (${(0, _translate.t)('beta')})`,
            icon: _jsx.IconName.Snaps
          });
          break;
        }
        labels.push({
          label: `${(0, _translate.t)('snaps')} (${(0, _translate.t)('beta')})`,
          icon: _jsx.IconName.Snaps
        });
        break;
      }
    ///: END:ONLY_INCLUDE_IF
    default:
      {
        break;
      }
  }
  return labels;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\utils\\accounts.js",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\common.util.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Cutils%5Ccommon.util.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.camelCaseToCapitalize = camelCaseToCapitalize;
exports.getCurrencySymbol = getCurrencySymbol;
function camelCaseToCapitalize(str = '') {
  return str.replace(/([A-Z])/gu, ' $1').replace(/^./u, s => s.toUpperCase());
}
function getCurrencySymbol(currencyCode) {
  const supportedCurrencyCodes = {
    EUR: '\u20AC',
    HKD: '\u0024',
    JPY: '\u00A5',
    PHP: '\u20B1',
    RUB: '\u20BD',
    SGD: '\u0024',
    USD: '\u0024'
  };
  if (supportedCurrencyCodes[currencyCode.toUpperCase()]) {
    return supportedCurrencyCodes[currencyCode.toUpperCase()];
  }
  return currencyCode.toUpperCase();
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\utils\\common.util.js",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\critical-startup-error-handler.ts", {"../../../shared/constants/background-liveness-check":"D:\\code\\v\\metamask-extension\\shared\\constants\\background-liveness-check.ts","../../../shared/constants/start-up-errors":"D:\\code\\v\\metamask-extension\\shared\\constants\\start-up-errors.ts","../../../shared/constants/state-corruption":"D:\\code\\v\\metamask-extension\\shared\\constants\\state-corruption.ts","./display-critical-error":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\display-critical-error.ts","./state-corruption-html":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\state-corruption-html.ts","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Cutils%5Ccritical-startup-error-handler.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CriticalStartupErrorHandler = void 0;
var _utils = require("@metamask/utils");
var _loglevel = _interopRequireDefault(require("loglevel"));
var _stateCorruption = require("../../../shared/constants/state-corruption");
var _backgroundLivenessCheck = require("../../../shared/constants/background-liveness-check");
var _startUpErrors = require("../../../shared/constants/start-up-errors");
var _stateCorruptionHtml = require("./state-corruption-html");
var _displayCriticalError = require("./display-critical-error");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
// This should be long enough that it doesn't trigger when the popup is opened soon after startup.
// The extension can take a few seconds to start up after a reload.
const BACKGROUND_CONNECTION_TIMEOUT = 10_000; // 10 Seconds
var _port = /*#__PURE__*/new WeakMap();
var _container = /*#__PURE__*/new WeakMap();
var _livenessCheckTimeoutId = /*#__PURE__*/new WeakMap();
var _onLivenessCheckCompleted = /*#__PURE__*/new WeakMap();
var _CriticalStartupErrorHandler_brand = /*#__PURE__*/new WeakSet();
var _handler = /*#__PURE__*/new WeakMap();
class CriticalStartupErrorHandler {
  /**
   * Creates an instance of CriticalStartupErrorHandler.
   * This class listens for critical startup errors from the background script
   * and displays appropriate error messages in the UI.
   *
   * @param port - The port to listen for messages on.
   * @param container - The container element to display the error in.
   */
  constructor(port, container) {
    /**
     * Verify that the background connection is operational.
     */
    _classPrivateMethodInitSpec(this, _CriticalStartupErrorHandler_brand);
    _classPrivateFieldInitSpec(this, _port, void 0);
    _classPrivateFieldInitSpec(this, _container, void 0);
    _classPrivateFieldInitSpec(this, _livenessCheckTimeoutId, void 0);
    _classPrivateFieldInitSpec(this, _onLivenessCheckCompleted, void 0);
    /**
     * Handles incoming messages from the background script.
     *
     * @param message - The message received from the background script.
     */
    _classPrivateFieldInitSpec(this, _handler, async message => {
      if (!(0, _utils.isObject)(message) || !(0, _utils.hasProperty)(message, 'data')) {
        // Ignore messages that are not objects or do not have a 'data' property,
        // they're likely for some other purpose
        return;
      }
      const {
        data
      } = message;
      if (!(0, _utils.isObject)(data) || !(0, _utils.hasProperty)(data, 'method')) {
        // Ignore the data property if it not an object or does not have a
        // 'method' property, they're likely for some other purpose
        return;
      }
      const {
        method
      } = data;
      // Currently, we only handle BACKGROUND_LIVENESS_METHOD, RELOAD_WINDOW, and the state
      // corruption error message, but we will be adding more in the future.
      if (method === _backgroundLivenessCheck.BACKGROUND_LIVENESS_METHOD) {
        if (_classPrivateFieldGet(_onLivenessCheckCompleted, this)) {
          _classPrivateFieldGet(_onLivenessCheckCompleted, this).call(this);
        } else {
          await (0, _displayCriticalError.displayCriticalError)(_classPrivateFieldGet(_container, this), _displayCriticalError.CriticalErrorTranslationKey.TroubleStarting, new Error('Unreachable error, liveness check not initialized'));
        }
      } else if (method === _startUpErrors.RELOAD_WINDOW) {
        // This is a special case where we want to reload the page
        window.location.reload();
      } else if (method === _stateCorruption.METHOD_DISPLAY_STATE_CORRUPTION_ERROR) {
        if (!(0, _utils.hasProperty)(data, 'params') || !(0, _utils.isObject)(data.params)) {
          _loglevel.default.error('Received state corruption error message without valid params:', message);
          return;
        }
        const {
          error,
          hasBackup,
          currentLocale
        } = data.params;
        (0, _stateCorruptionHtml.displayStateCorruptionError)(_classPrivateFieldGet(_container, this), _classPrivateFieldGet(_port, this), error, hasBackup, currentLocale);
      } else if (method === _startUpErrors.DISPLAY_GENERAL_STARTUP_ERROR) {
        if (!(0, _utils.hasProperty)(data, 'params') || !(0, _utils.isObject)(data.params)) {
          _loglevel.default.error('Received general start up error message without valid params:', message);
          return;
        }
        const {
          error,
          currentLocale
        } = data.params;
        await (0, _displayCriticalError.displayCriticalError)(_classPrivateFieldGet(_container, this), _displayCriticalError.CriticalErrorTranslationKey.TroubleStarting, error, currentLocale);
      }
    });
    _classPrivateFieldSet(_port, this, port);
    _classPrivateFieldSet(_container, this, container);
  }
  /**
   * Detect and react to critical errors such as state corruption.
   *
   * This function attempts to verify that the connection to the background is active, displaying
   * a critical error if it's not.
   *
   * It also attaches an error listener to the provided port to handle state corruption errors.
   * This function listens for messages from the background script and displays a state corruption
   * error if the appropriate message is received.
   *
   * Critical error messages are transferred over a raw browser `Port`, not with
   * `PortStream` wrapper. We want to be as close to the "metal" as possible here,
   * it minimize abstractions that could cause further issues.
   */
  install() {
    _classPrivateFieldGet(_port, this).onMessage.addListener(_classPrivateFieldGet(_handler, this));

    // Called without `await` intentionally to ensure listeners for other messages are added as
    // quickly as possible.
    _assertClassBrand(_CriticalStartupErrorHandler_brand, this, _startLivenessCheck).call(this);
  }

  /**
   * Uninstall the error listeners from the port, and cancel any ongoing liveness check.
   */
  uninstall() {
    _classPrivateFieldGet(_port, this).onMessage.removeListener(_classPrivateFieldGet(_handler, this));
    clearTimeout(_classPrivateFieldGet(_livenessCheckTimeoutId, this));
    if (_classPrivateFieldGet(_onLivenessCheckCompleted, this)) {
      // Resolve just to allow any unresolved Promise to be garbage collected.
      _classPrivateFieldGet(_onLivenessCheckCompleted, this).call(this);
      _classPrivateFieldSet(_onLivenessCheckCompleted, this, undefined);
    }
  }
}
exports.CriticalStartupErrorHandler = CriticalStartupErrorHandler;
async function _startLivenessCheck() {
  const {
    promise: livenessCheck,
    resolve: onLivenessCheckCompleted
  } = (0, _utils.createDeferredPromise)();
  // This is called later in `#handle` when the response is received.
  _classPrivateFieldSet(_onLivenessCheckCompleted, this, onLivenessCheckCompleted);
  const timeoutPromise = new Promise((_resolve, reject) => {
    _classPrivateFieldSet(_livenessCheckTimeoutId, this, setTimeout(() => reject(new Error('Background connection unresponsive')), BACKGROUND_CONNECTION_TIMEOUT));
  });
  try {
    await Promise.race([livenessCheck, timeoutPromise]);
  } catch (error) {
    await (0, _displayCriticalError.displayCriticalError)(_classPrivateFieldGet(_container, this), _displayCriticalError.CriticalErrorTranslationKey.TroubleStarting,
    // This cast is safe because `livenessCheck` can't throw, and `timeoutPromise` only throws an
    // error.
    error);
  } finally {
    clearTimeout(_classPrivateFieldGet(_livenessCheckTimeoutId, this));
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\utils\\critical-startup-error-handler.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\display-critical-error.ts", {"../../../shared/lib/error-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\error-utils.js","../../../shared/lib/ui-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\ui-utils.js","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","uuid":"D:\\code\\v\\metamask-extension\\node_modules\\uuid\\dist\\index.js","webextension-polyfill":"D:\\code\\v\\metamask-extension\\node_modules\\webextension-polyfill\\dist\\browser-polyfill.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Cutils%5Cdisplay-critical-error.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CriticalErrorTranslationKey = void 0;
exports.displayCriticalError = displayCriticalError;
exports.extractEnvelopeUrlFromDsn = extractEnvelopeUrlFromDsn;
var _webextensionPolyfill = _interopRequireDefault(require("webextension-polyfill"));
var _loglevel = _interopRequireDefault(require("loglevel"));
var _uuid = require("uuid");
var _errorUtils = require("../../../shared/lib/error-utils");
var _uiUtils = require("../../../shared/lib/ui-utils");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * Extracts the Sentry envelope URL from a Sentry DSN.
 *
 * DSN format: https://[PUBLIC_KEY]@[ORG_ID].[INGEST_DOMAIN]/[PROJECT_ID]
 * Envelope URL format: https://[ORG_ID].[INGEST_DOMAIN]/api/[PROJECT_ID]/envelope/
 *
 * @param dsn - The Sentry DSN string
 * @returns The corresponding envelope URL
 * @throws Error if DSN format is invalid
 */
function extractEnvelopeUrlFromDsn(dsn) {
  try {
    // Parse the DSN URL
    const url = new URL(dsn);
    // Extract project ID from pathname (remove leading slash)
    const projectId = url.pathname.slice(1);
    // Extract organization ID and ingest domain from hostname
    // hostname format: [ORG_ID].[INGEST_DOMAIN]
    const hostParts = url.hostname.split('.');
    const orgId = hostParts[0];
    const ingestDomain = hostParts.slice(1).join('.');

    // Construct envelope URL
    return `https://${orgId}.${ingestDomain}/api/${projectId}/envelope/`;
  } catch (error) {
    throw new Error('Invalid Sentry DSN format');
  }
}
function getSentryTarget() {
  if ("development" !== 'production') {
    return null;
  }
  return null;
}
let CriticalErrorTranslationKey = exports.CriticalErrorTranslationKey = /*#__PURE__*/function (CriticalErrorTranslationKey) {
  CriticalErrorTranslationKey["TroubleStarting"] = "troubleStarting";
  CriticalErrorTranslationKey["SomethingIsWrong"] = "somethingIsWrong";
  return CriticalErrorTranslationKey;
}({});
/**
 * Sends critical MetaMask errors to Sentry via direct API call.
 *
 * @param error - The error object to report to Sentry
 * @returns Promise that resolves when the report is sent
 */
async function sendErrorToSentry(error) {
  const sentryDSN = getSentryTarget();
  if (!sentryDSN) {
    return;
  }
  try {
    var _browser$runtime$getM, _globalThis$navigator;
    // Generate unique event ID (32-char hex UUID4)
    const eventId = (0, _uuid.v4)().replace(/-/gu, '');
    const timestamp = Math.floor(Date.now() / 1000);

    // Create event payload according to Sentry specs
    // event_id, error_details and user_agent are required by Sentry envelope format, hence the disable is valid
    const eventPayload = {
      // eslint-disable-next-line @typescript-eslint/naming-convention
      event_id: eventId,
      timestamp,
      platform: 'javascript',
      level: 'error',
      message: (error === null || error === void 0 ? void 0 : error.message) || 'MetaMask extension crash critical error',
      release: ((_browser$runtime$getM = _webextensionPolyfill.default.runtime.getManifest()) === null || _browser$runtime$getM === void 0 ? void 0 : _browser$runtime$getM.version) || 'unknown',
      extra: {
        // eslint-disable-next-line @typescript-eslint/naming-convention
        error_details: error && typeof error === 'object' ? error : {
          message: String(error)
        },
        // eslint-disable-next-line @typescript-eslint/naming-convention
        user_agent: ((_globalThis$navigator = globalThis.navigator) === null || _globalThis$navigator === void 0 ? void 0 : _globalThis$navigator.userAgent) || 'unknown'
      }
    };

    // Create envelope headers
    // event_id and sent_at are Required by Sentry envelope format, hence the disable is valid
    const envelopeHeaders = {
      // eslint-disable-next-line @typescript-eslint/naming-convention
      event_id: eventId,
      dsn: sentryDSN,
      // eslint-disable-next-line @typescript-eslint/naming-convention
      sent_at: new Date().toISOString()
    };
    const eventPayloadString = JSON.stringify(eventPayload);
    const itemHeader = {
      type: 'event',
      length: eventPayloadString.length
    };
    const envelope = `${JSON.stringify(envelopeHeaders)}\n${JSON.stringify(itemHeader)}\n${eventPayloadString}`;
    const sentryEnvelopeURL = extractEnvelopeUrlFromDsn(sentryDSN);

    // Send to Sentry envelope API (must match DSN region)
    await fetch(sentryEnvelopeURL, {
      method: 'POST',
      headers: {
        'Content-Type': 'application/x-sentry-envelope'
      },
      body: envelope
    });
  } catch (e) {
    console.error('Error sending report to Sentry:', e);
  }
}

/**
 * Handles the restart action: sends error report to Sentry (if enabled) and restarts MetaMask.
 *
 * @param error - The error object to report
 * @param shouldReport - Whether to send the error report to Sentry
 */
async function handleRestartAction(error, shouldReport) {
  // Send error report to Sentry first (if enabled)
  if (shouldReport) {
    await sendErrorToSentry(error);
  }
  // Restart the extension
  _webextensionPolyfill.default.runtime.reload();
}

/**
 * Displays a critical error message in the given container.
 *
 * This function always throws the error after displaying the message.
 *
 * @param container - The HTML element to display the error in.
 * @param errorKey - The key for the error message to display.
 * @param error - The error object to log.
 * @param currentLocale - Optional locale context for translations.
 * @throws {ErrorLike} Throws the error after displaying the message.
 * @returns A promise that resolves to never, as it always throws an error.
 */
async function displayCriticalError(container, errorKey, error, currentLocale) {
  const localeContext = await (0, _errorUtils.maybeGetLocaleContext)(currentLocale);
  container.innerHTML = (0, _errorUtils.getErrorHtml)(errorKey, error, localeContext, _uiUtils.SUPPORT_LINK);
  const restartButton = container.querySelector('#critical-error-button');
  const reportCheckbox = container.querySelector('#critical-error-checkbox');

  // Restart button: report error and restart MetaMask
  restartButton === null || restartButton === void 0 || restartButton.addEventListener('click', async () => {
    const shouldReport = (reportCheckbox === null || reportCheckbox === void 0 ? void 0 : reportCheckbox.checked) ?? false;
    await handleRestartAction(error, shouldReport);
  });
  _loglevel.default.error(error.stack);
  throw error;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\utils\\display-critical-error.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\export-utils.js", {"buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Cutils%5Cexport-utils.js
      return function (require, module, exports) {
(function (Buffer){(function (){
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExportableContentType = void 0;
exports.exportAsFile = exportAsFile;
/**
 * @enum { string }
 */
const ExportableContentType = exports.ExportableContentType = {
  JSON: 'application/json',
  TXT: 'text/plain'
};

/**
 * @enum { string }
 */
const ExtensionForContentType = {
  [ExportableContentType.JSON]: '.json',
  [ExportableContentType.TXT]: '.txt'
};

/**
 * Export data as a file.
 *
 * @param {string} filename - The name of the file to export.
 * @param {string} data - The data to export.
 * @param {ExportableContentType} contentType - The content type of the file to export.
 */
async function exportAsFile(filename, data, contentType) {
  if (!ExtensionForContentType[contentType]) {
    throw new Error(`Unsupported file type: ${contentType}`);
  }
  if (supportsShowSaveFilePicker()) {
    // Preferred method for downloads
    await saveFileUsingFilePicker(filename, data, contentType);
  } else {
    saveFileUsingDataUri(filename, data, contentType);
  }
}
/**
 * Notes if the browser supports the File System Access API.
 *
 * @returns {boolean}
 */
function supportsShowSaveFilePicker() {
  return typeof window !== 'undefined' && typeof window.showSaveFilePicker !== 'undefined' && typeof window.Blob !== 'undefined';
}

/**
 * Saves a file using the File System Access API.
 *
 * @param {string} filename - The name of the file to export.
 * @param {string} data - The data to export.
 * @param {ExportableContentType} contentType - The content type of the file to export.
 * @returns {Promise<void>}
 */
async function saveFileUsingFilePicker(filename, data, contentType) {
  const blob = new window.Blob([data], {
    contentType
  });
  const fileExtension = ExtensionForContentType[contentType];
  const handle = await window.showSaveFilePicker({
    suggestedName: filename,
    types: [{
      description: filename,
      accept: {
        [contentType]: [fileExtension]
      }
    }]
  });
  const writable = await handle.createWritable();
  await writable.write(blob);
  await writable.close();
}

/**
 * Saves a file using a data URI.
 * This is a fallback for browsers that do not support the File System Access API.
 * This method is less preferred because it requires the entire file to be encoded in a data URI.
 *
 * @param {string} filename - The name of the file to export.
 * @param {string} data - The data to export.
 * @param {ExportableContentType} contentType - The content type of the file to export.
 */
function saveFileUsingDataUri(filename, data, contentType) {
  const b64 = Buffer.from(data, 'utf8').toString('base64');
  const elem = document.createElement('a');
  elem.href = `data:${contentType};Base64,${b64}`;
  elem.download = filename;
  document.body.appendChild(elem);
  elem.click();
  document.body.removeChild(elem);
}

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\utils\\export-utils.js",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\gas.js", {"../../../shared/constants/gas":"D:\\code\\v\\metamask-extension\\shared\\constants\\gas.ts","../../../shared/modules/Numeric":"D:\\code\\v\\metamask-extension\\shared\\modules\\Numeric.ts","../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","./util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","bignumber.js":"D:\\code\\v\\metamask-extension\\node_modules\\bignumber.js\\bignumber.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Cutils%5Cgas.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addTenPercentAndRound = addTenPercentAndRound;
exports.editGasModeIsSpeedUpOrCancel = editGasModeIsSpeedUpOrCancel;
exports.formatGasFeeOrFeeRange = formatGasFeeOrFeeRange;
exports.gasEstimateGreaterThanGasUsedPlusTenPercent = void 0;
exports.isMetamaskSuggestedGasEstimate = isMetamaskSuggestedGasEstimate;
var _lodash = require("lodash");
var _bignumber = _interopRequireDefault(require("bignumber.js"));
var _gas = require("../../../shared/constants/gas");
var _conversion = require("../../../shared/modules/conversion.utils");
var _Numeric = require("../../../shared/modules/Numeric");
var _util = require("./util");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const TEN_PERCENT_NUMERIC = new _Numeric.Numeric(1.1, 10);
const gasEstimateGreaterThanGasUsedPlusTenPercent = (gasUsed, gasFeeEstimates, estimate) => {
  var _gasFeeEstimates$esti;
  let {
    maxFeePerGas: maxFeePerGasInTransaction
  } = gasUsed;
  maxFeePerGasInTransaction = new _bignumber.default((0, _conversion.hexWEIToDecGWEI)(addTenPercentAndRound(maxFeePerGasInTransaction)));
  const maxFeePerGasFromEstimate = gasFeeEstimates === null || gasFeeEstimates === void 0 || (_gasFeeEstimates$esti = gasFeeEstimates[estimate]) === null || _gasFeeEstimates$esti === void 0 ? void 0 : _gasFeeEstimates$esti.suggestedMaxFeePerGas;
  return (0, _util.bnGreaterThan)(maxFeePerGasFromEstimate, maxFeePerGasInTransaction);
};

/**
 * Simple helper to save on duplication to multiply the supplied wei hex string
 * by 1.10 to get bare minimum new gas fee.
 *
 * @param {string | undefined} hexStringValue - hex value in wei to be incremented
 * @returns {string | undefined} hex value in WEI 10% higher than the param.
 */
exports.gasEstimateGreaterThanGasUsedPlusTenPercent = gasEstimateGreaterThanGasUsedPlusTenPercent;
function addTenPercentAndRound(hexStringValue) {
  if (hexStringValue === undefined) {
    return undefined;
  }
  return new _Numeric.Numeric(hexStringValue, 16).times(TEN_PERCENT_NUMERIC).round(0).toPrefixedHexString();
}
function isMetamaskSuggestedGasEstimate(estimate) {
  return [_gas.GasRecommendations.high, _gas.GasRecommendations.medium, _gas.GasRecommendations.low].includes(estimate);
}

/**
 * Formats a singular gas fee or a range of gas fees by rounding them to the
 * given precisions and then arranging them as a string.
 *
 * @param {string | [string, string] | null | undefined} feeOrFeeRange - The fee
 * in GWEI or range of fees in GWEI.
 * @param {object} options - The options.
 * @param {number | [number, number]} options.precision - The precision(s) to
 * use when formatting the fee(s).
 * @returns A string which represents the formatted version of the fee or fee
 * range.
 */
function formatGasFeeOrFeeRange(feeOrFeeRange, {
  precision: precisionOrPrecisions = 2
} = {}) {
  if ((0, _util.isNullish)(feeOrFeeRange) || Array.isArray(feeOrFeeRange) && feeOrFeeRange.length === 0) {
    return null;
  }
  const range = Array.isArray(feeOrFeeRange) ? feeOrFeeRange.slice(0, 2) : [feeOrFeeRange];
  const precisions = Array.isArray(precisionOrPrecisions) ? precisionOrPrecisions.slice(0, 2) : (0, _lodash.times)(range.length, (0, _lodash.constant)(precisionOrPrecisions));
  const formattedRange = (0, _lodash.uniq)((0, _lodash.zip)(range, precisions).map(([fee, precision]) => {
    return precision === undefined ? fee : (0, _util.roundToDecimalPlacesRemovingExtraZeroes)(fee, precision);
  })).join(' - ');
  return `${formattedRange} GWEI`;
}

/**
 * Helper method for determining whether an edit gas mode is either a speed up or cancel transaction
 *
 * @param {string | undefined} editGasMode - One of 'speed-up', 'cancel', 'modify-in-place', or 'swaps'
 * @returns boolean
 */
function editGasModeIsSpeedUpOrCancel(editGasMode) {
  return editGasMode === _gas.EditGasModes.cancel || editGasMode === _gas.EditGasModes.speedUp;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\utils\\gas.js",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\hardware.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Cutils%5Chardware.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isHardwareKeyring = isHardwareKeyring;
function isHardwareKeyring(keyringType = '') {
  return keyringType.includes('Hardware');
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\utils\\hardware.js",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\icon-factory.ts", {"../../../shared/modules/hexstring-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\hexstring-utils.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Cutils%5Cicon-factory.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IconFactory = void 0;
exports.default = iconFactoryGenerator;
var _hexstringUtils = require("../../../shared/modules/hexstring-utils");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * Defines the metadata for a token including optional icon URL.
 */

/**
 * A factory for generating icons for cryptocurrency addresses using Jazzicon or predefined token metadata.
 */
class IconFactory {
  /**
   * Constructs an IconFactory instance with a given Jazzicon function.
   *
   * @param jazzicon - A function that returns a Jazzicon SVG given a diameter and seed.
   * @param generateSeed - An optional function that generates a seed based on an address.
   */
  constructor(jazzicon, generateSeed = jsNumberForAddress) {
    /**
     * Function to generate a Jazzicon SVG element.
     */
    _defineProperty(this, "jazzicon", void 0);
    /**
     * Function to generate seed before passing to jazzicon implementation.
     */
    _defineProperty(this, "generateSeed", void 0);
    /**
     * Cache for storing generated SVG elements to avoid re-rendering.
     */
    _defineProperty(this, "cache", void 0);
    this.jazzicon = jazzicon;
    this.generateSeed = generateSeed;
    this.cache = {};
  }

  /**
   * Generates an icon for a given address. Returns a predefined image or generates a new Jazzicon.
   *
   * @param address - The cryptocurrency address to generate the icon for.
   * @param diameter - The diameter of the icon to be generated.
   * @param tokenMetadata - Metadata containing optional icon URL for predefined icons.
   * @returns An HTML element representing the icon.
   */
  iconForAddress(address, diameter, tokenMetadata) {
    if (iconExistsFor(address, tokenMetadata)) {
      return imageElFor(tokenMetadata);
    }
    return this.generateIdenticonSvg(address, diameter);
  }

  /**
   * Generates or retrieves from cache a Jazzicon SVG for a given address and diameter.
   *
   * @param address - The cryptocurrency address for the identicon.
   * @param diameter - The diameter of the identicon.
   * @returns A Jazzicon SVG element.
   */
  generateIdenticonSvg(address, diameter) {
    const cacheId = `${address}:${diameter}`;
    const identicon = this.cache[cacheId] || (this.cache[cacheId] = this.generateNewIdenticon(address, diameter));
    const cleanCopy = identicon.cloneNode(true);
    return cleanCopy;
  }

  /**
   * Generates a new Jazzicon SVG for a given address and diameter.
   *
   * @param address - The cryptocurrency address for the identicon.
   * @param diameter - The diameter of the identicon.
   * @returns A new Jazzicon SVG element.
   */
  generateNewIdenticon(address, diameter) {
    const numericRepresentation = this.generateSeed(address);
    const identicon = this.jazzicon(diameter, numericRepresentation);
    return identicon;
  }
}
exports.IconFactory = IconFactory;
let iconFactory;

/**
 * Generates or retrieves an existing IconFactory instance.
 *
 * @param jazzicon - A function that returns a Jazzicon SVG given a diameter and seed.
 * @returns An IconFactory instance.
 */
function iconFactoryGenerator(jazzicon) {
  if (!iconFactory) {
    iconFactory = new IconFactory(jazzicon);
  }
  return iconFactory;
}

/**
 * Determines if an icon already exists for a given address based on token metadata.
 *
 * @param address - The cryptocurrency address.
 * @param tokenMetadata - Metadata containing optional icon URL.
 * @returns True if an icon exists, otherwise false.
 */
function iconExistsFor(address, tokenMetadata) {
  if (!(tokenMetadata !== null && tokenMetadata !== void 0 && tokenMetadata.iconUrl)) {
    return false;
  }
  return (0, _hexstringUtils.isValidHexAddress)(address, {
    allowNonPrefixed: false
  });
}

/**
 * Creates an HTMLImageElement for a given token metadata.
 *
 * @param tokenMetadata - Metadata containing the icon URL. Defaults to an empty object.
 * @returns An HTMLImageElement with the source set to the icon URL.
 */
function imageElFor(tokenMetadata) {
  const img = document.createElement('img');
  img.src = tokenMetadata.iconUrl;
  img.style.width = '100%';
  return img;
}

/**
 * Converts a hexadecimal address into a numerical seed.
 *
 * @param address - The cryptocurrency address.
 * @returns A numerical seed derived from the address.
 */
function jsNumberForAddress(address) {
  const addr = address.slice(2, 10);
  const seed = parseInt(addr, 16);
  return seed;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\utils\\icon-factory.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\is-mobile-view.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Cutils%5Cis-mobile-view.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
// Checks if viewport at invoke time fits mobile dimensions
// isMobileView :: () => Bool
const isMobileView = () => window.matchMedia('screen and (max-width: 575px)').matches;
var _default = exports.default = isMobileView;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\utils\\is-mobile-view.js",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\isOriginalNativeTokenSymbol.ts", {"../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../shared/constants/time":"D:\\code\\v\\metamask-extension\\shared\\constants\\time.ts","../../../shared/lib/fetch-with-cache":"D:\\code\\v\\metamask-extension\\shared\\lib\\fetch-with-cache.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Cutils%5CisOriginalNativeTokenSymbol.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isOriginalNativeTokenSymbol = exports.getOriginalNativeTokenSymbol = void 0;
var _network = require("../../../shared/constants/network");
var _fetchWithCache = _interopRequireDefault(require("../../../shared/lib/fetch-with-cache"));
var _time = require("../../../shared/constants/time");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const getOriginalNativeTokenSymbol = async ({
  chainId,
  useAPICall = false
}) => {
  try {
    var _matchedChain$nativeC;
    const mappedCurrencySymbol = _network.CHAIN_ID_TO_CURRENCY_SYMBOL_MAP[chainId];
    if (mappedCurrencySymbol) {
      return mappedCurrencySymbol;
    }
    const mappedAsNetworkCollision = _network.CHAIN_ID_TO_CURRENCY_SYMBOL_MAP_NETWORK_COLLISION[chainId];
    if (mappedAsNetworkCollision !== null && mappedAsNetworkCollision !== void 0 && mappedAsNetworkCollision[0].currencySymbol) {
      return mappedAsNetworkCollision[0].currencySymbol;
    }
    if (!useAPICall) {
      return null;
    }
    const safeChainsList = await (0, _fetchWithCache.default)({
      url: _network.CHAIN_SPEC_URL,
      allowStale: true,
      cacheOptions: {
        cacheRefreshTime: _time.DAY
      },
      functionName: 'getSafeChainsList'
    });
    const matchedChain = safeChainsList.find(network => network.chainId === parseInt(chainId, 16));
    return (matchedChain === null || matchedChain === void 0 || (_matchedChain$nativeC = matchedChain.nativeCurrency) === null || _matchedChain$nativeC === void 0 ? void 0 : _matchedChain$nativeC.symbol) ?? null;
  } catch (err) {
    return null;
  }
};
exports.getOriginalNativeTokenSymbol = getOriginalNativeTokenSymbol;
const isOriginalNativeTokenSymbol = async ({
  ticker,
  chainId,
  useAPICall = false
}) => {
  const originalNativeTokenSymbol = await getOriginalNativeTokenSymbol({
    chainId,
    useAPICall
  });

  // No original symbol found, so we can assume the ticker provided is correct.
  if (originalNativeTokenSymbol === null) {
    return true;
  }

  // Validate that the ticker uses the correct/expected ticker symbol
  return originalNativeTokenSymbol === ticker;
};
exports.isOriginalNativeTokenSymbol = isOriginalNativeTokenSymbol;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\utils\\isOriginalNativeTokenSymbol.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\mm-lazy.ts", {"../../../shared/lib/manifestFlags":"D:\\code\\v\\metamask-extension\\shared\\lib\\manifestFlags.ts","../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Cutils%5Cmm-lazy.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mmLazy = mmLazy;
var _react = _interopRequireDefault(require("react"));
var _manifestFlags = require("../../../shared/lib/manifestFlags");
var _trace = require("../../../shared/lib/trace");
var _getManifestFlags$sen;
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// This only has to happen once per app load, so do it outside a function
const lazyLoadSubSampleRate = (_getManifestFlags$sen = (0, _manifestFlags.getManifestFlags)().sentry) === null || _getManifestFlags$sen === void 0 ? void 0 : _getManifestFlags$sen.lazyLoadSubSampleRate;

/**
 * A wrapper around React.lazy that adds two things:
 * 1. Sentry tracing for how long it takes to load the component (not render, just load)
 * 2. React.lazy can only deal with default exports, but the wrapper can handle named exports too
 *
 * @param fn - an import of the form `() => __import__('AAA')`
 */
function mmLazy(fn) {
  return /*#__PURE__*/_react.default.lazy(async () => {
    // We can't start the trace here because we don't have the componentName yet, so we just hold the startTime
    const startTime = Date.now();
    const importedModule = await fn();
    const {
      componentName,
      component
    } = parseImportedComponent(importedModule);

    // Only trace load time of lazy-loaded components if the manifestFlag is set, and then do it by Math.random probability
    if (lazyLoadSubSampleRate && Math.random() < lazyLoadSubSampleRate) {
      (0, _trace.trace)({
        name: _trace.TraceName.LazyLoadComponent,
        data: {
          componentName
        },
        startTime
      });
      (0, _trace.endTrace)({
        name: _trace.TraceName.LazyLoadComponent
      });
    }
    return component;
  });
}

// There can be a lot of different types here, and we're basically doing type-checking in the code,
// so I don't think TypeScript safety on `importedModule` is worth it in this function

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function parseImportedComponent(importedModule) {
  let componentName;

  // If there's no default export
  if (!importedModule.default) {
    const keys = Object.keys(importedModule);

    // If there's only one named export
    if (keys.length === 1) {
      componentName = keys[0];
      return {
        componentName,
        // Force the component to be the default export
        component: {
          default: importedModule[componentName]
        }
      };
    }

    // If there are multiple named exports, this isn't good for tree-shaking, so throw an error
    throw new Error('mmLazy: You cannot lazy-load a component when there are multiple exported components in one file');
  }
  if (importedModule.default.WrappedComponent) {
    // If there's a wrapped component, we don't want to see the name reported as `withRouter(Connect(AAA))` we want just `AAA`
    componentName = importedModule.default.WrappedComponent.name;
  } else {
    componentName = importedModule.default.name || importedModule.default.displayName;
  }
  return {
    componentName,
    component: importedModule
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\utils\\mm-lazy.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\multichain\\blockExplorer.ts", {"../../../../app/scripts/lib/multichain/address":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\multichain\\address.ts","../../../../shared/lib/multichain/networks":"D:\\code\\v\\metamask-extension\\shared\\lib\\multichain\\networks.ts","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Cutils%5Cmultichain%5CblockExplorer.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMultichainBlockExplorerUrl = exports.getMultichainAccountUrl = void 0;
var _utils = require("@metamask/utils");
var _address = require("../../../../app/scripts/lib/multichain/address");
var _networks = require("../../../../shared/lib/multichain/networks");
// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

const getMultichainBlockExplorerUrl = network => {
  var _network$network;
  return ((_network$network = network.network) === null || _network$network === void 0 || (_network$network = _network$network.rpcPrefs) === null || _network$network === void 0 ? void 0 : _network$network.blockExplorerUrl) ?? '';
};
exports.getMultichainBlockExplorerUrl = getMultichainBlockExplorerUrl;
const getMultichainAccountUrl = (address, network) => {
  const {
    namespace
  } = (0, _utils.parseCaipChainId)(network.chainId);
  if (namespace === _utils.KnownCaipNamespace.Eip155) {
    const normalizedAddress = (0, _address.normalizeSafeAddress)(address);
    return `https://etherscan.io/address/${normalizedAddress}#asset-multichain`;
  }

  // We're in a non-EVM context, so we assume we can use format URLs instead.
  const {
    blockExplorerFormatUrls
  } = network.network;
  if (blockExplorerFormatUrls) {
    return (0, _networks.formatBlockExplorerAddressUrl)(blockExplorerFormatUrls, address);
  }
  return '';
};
exports.getMultichainAccountUrl = getMultichainAccountUrl;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\utils\\multichain\\blockExplorer.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\multichain\\getBlockExplorerInfo.ts", {"../../../../shared/constants/common":"D:\\code\\v\\metamask-extension\\shared\\constants\\common.ts","../../../../shared/constants/multichain/networks":"D:\\code\\v\\metamask-extension\\shared\\constants\\multichain\\networks.ts","../../../../shared/lib/multichain/networks":"D:\\code\\v\\metamask-extension\\shared\\lib\\multichain\\networks.ts","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Cutils%5Cmultichain%5CgetBlockExplorerInfo.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBlockExplorerInfo = void 0;
var _utils = require("@metamask/utils");
var _common = require("../../../../shared/constants/common");
var _networks = require("../../../../shared/constants/multichain/networks");
var _networks2 = require("../../../../shared/lib/multichain/networks");
/**
 * Gets block explorer information for a specific network
 *
 * @param t - Translation function
 * @param address - The address to create the URL for
 * @param networkInfo - Information about the network including chainId, blockExplorerUrl, and networkName
 * @returns BlockExplorerInfo or null if no explorer available
 */
const getBlockExplorerInfo = (t, address, networkInfo) => {
  const {
    chainId,
    blockExplorerUrl
  } = networkInfo;

  // For multichain networks (Bitcoin, Solana), use CaipChainId for reliable detection
  if (chainId) {
    // Bitcoin networks
    if (chainId === _networks.MultichainNetworks.BITCOIN || chainId === _networks.MultichainNetworks.BITCOIN_TESTNET || chainId === _networks.MultichainNetworks.BITCOIN_SIGNET) {
      const blockExplorerFormatUrls = _networks.MULTICHAIN_NETWORK_BLOCK_EXPLORER_FORMAT_URLS_MAP[chainId];
      if (blockExplorerFormatUrls) {
        const explorerName = 'Blockstream';
        const addressUrl = (0, _networks2.formatBlockExplorerAddressUrl)(blockExplorerFormatUrls, address);
        return {
          addressUrl,
          name: explorerName,
          buttonText: t('viewAddressOnExplorer', [explorerName])
        };
      }
    }

    // Solana networks
    if (chainId === _networks.MultichainNetworks.SOLANA || chainId === _networks.MultichainNetworks.SOLANA_DEVNET || chainId === _networks.MultichainNetworks.SOLANA_TESTNET) {
      const blockExplorerFormatUrls = _networks.MULTICHAIN_NETWORK_BLOCK_EXPLORER_FORMAT_URLS_MAP[chainId];
      if (blockExplorerFormatUrls) {
        const explorerName = 'Solscan';
        const addressUrl = (0, _networks2.formatBlockExplorerAddressUrl)(blockExplorerFormatUrls, address);
        return {
          addressUrl,
          name: explorerName,
          buttonText: t('viewAddressOnExplorer', [explorerName])
        };
      }
    }
  }

  // For EVM networks, use CaipChainId for reliable detection
  if (chainId !== null && chainId !== void 0 && chainId.startsWith(_utils.KnownCaipNamespace.Eip155)) {
    // Convert CaipChainId to hex for EVM networks
    const hexChainId = `0x${parseInt(chainId.split(':')[1], 10).toString(16)}`;

    // Use the provided block explorer URL if available
    if (blockExplorerUrl) {
      const explorerName = _common.CHAINID_DEFAULT_BLOCK_EXPLORER_HUMAN_READABLE_URL_MAP[hexChainId] || 'Block Explorer';
      const addressUrl = `${blockExplorerUrl}/address/${address}`;
      return {
        addressUrl,
        name: explorerName,
        buttonText: t('viewAddressOnExplorer', [explorerName])
      };
    }

    // Use known EVM network mappings
    const explorerName = _common.CHAINID_DEFAULT_BLOCK_EXPLORER_HUMAN_READABLE_URL_MAP[hexChainId];
    if (explorerName) {
      var _CHAINID_DEFAULT_BLOC;
      // Get the base URL from the mapping (remove trailing slash)
      const baseUrl = (_CHAINID_DEFAULT_BLOC = _common.CHAINID_DEFAULT_BLOCK_EXPLORER_URL_MAP[hexChainId]) === null || _CHAINID_DEFAULT_BLOC === void 0 ? void 0 : _CHAINID_DEFAULT_BLOC.replace(/\/$/u, '');
      if (baseUrl) {
        return {
          addressUrl: `${baseUrl}/address/${address}`,
          name: explorerName,
          buttonText: t('viewAddressOnExplorer', [explorerName])
        };
      }
    }
  }
  return null;
};
exports.getBlockExplorerInfo = getBlockExplorerInfo;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\utils\\multichain\\getBlockExplorerInfo.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\network-helper.ts", {"../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../shared/modules/network.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\network.utils.ts","@metamask/multichain-network-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-network-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Cutils%5Cnetwork-helper.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isTestNetwork = exports.getMatchedSymbols = exports.getMatchedNames = exports.getMatchedChain = void 0;
var _multichainNetworkController = require("@metamask/multichain-network-controller");
var _utils = require("@metamask/utils");
var _network = require("../../../shared/constants/network");
var _network2 = require("../../../shared/modules/network.utils");
const getMatchedChain = (decimalChainId, safeChainsList) => {
  return safeChainsList.find(chain => chain.chainId.toString() === decimalChainId);
};
exports.getMatchedChain = getMatchedChain;
const getMatchedSymbols = (decimalChainId, safeChainsList) => {
  return safeChainsList.reduce((accumulator, currentNetwork) => {
    if (currentNetwork.chainId.toString() === decimalChainId) {
      var _currentNetwork$nativ;
      accumulator.push((_currentNetwork$nativ = currentNetwork.nativeCurrency) === null || _currentNetwork$nativ === void 0 ? void 0 : _currentNetwork$nativ.symbol);
    }
    return accumulator;
  }, []);
};
exports.getMatchedSymbols = getMatchedSymbols;
const getMatchedNames = (decimalChainId, safeChainsList) => {
  return safeChainsList.reduce((accumulator, currentNetwork) => {
    if (currentNetwork.chainId.toString() === decimalChainId) {
      accumulator.push(currentNetwork === null || currentNetwork === void 0 ? void 0 : currentNetwork.name);
    }
    return accumulator;
  }, []);
};

/**
 * Checks if the given chain ID is a test network.
 *
 * @param chainId - The chain ID to check.
 * @returns True if the chain ID is a test network, false otherwise.
 */
exports.getMatchedNames = getMatchedNames;
const isTestNetwork = chainId => {
  if (!(0, _utils.isCaipChainId)(chainId)) {
    return _network.TEST_CHAINS.includes(chainId);
  }
  if (chainId.startsWith('eip155:')) {
    return _network.TEST_CHAINS.includes((0, _network2.convertCaipToHexChainId)(chainId));
  }
  return _multichainNetworkController.NON_EVM_TESTNET_IDS.includes(chainId);
};
exports.isTestNetwork = isTestNetwork;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\utils\\network-helper.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\nfts.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Cutils%5Cnfts.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.nftTruncateAltText = exports.getNftImageAlt = exports.getNftImage = void 0;
const NFT_ALT_TEXT_MAX_LENGTH = 100;
const nftTruncateAltText = (text, maxLength) => {
  // if the text is shorter than or equal to maxLength, return it
  if (text.length <= maxLength) {
    return text;
  }
  const truncated = text.substring(0, maxLength);
  const lastSpaceIndex = truncated.lastIndexOf(' ');

  // If there's a space within the truncated text, cut at the last space
  if (lastSpaceIndex > 0) {
    return `${truncated.substring(0, lastSpaceIndex)}...`;
  }

  // If no space is found, return the truncated text with ellipsis
  return `${truncated}...`;
};
exports.nftTruncateAltText = nftTruncateAltText;
const getNftImageAlt = ({
  name,
  tokenId,
  description
}) => {
  // If there is no name, tokenId, or description, return an empty string
  if (!name && !tokenId && !description) {
    return '';
  }

  // if name or tokenId is undefined, don't include them in the alt text
  const altText = description ?? `${name ?? ''} ${tokenId ?? ''}`.trim();
  return nftTruncateAltText(altText, NFT_ALT_TEXT_MAX_LENGTH);
};
exports.getNftImageAlt = getNftImageAlt;
const getNftImage = image => {
  if (typeof image === 'string') {
    return image;
  }
  if (Array.isArray(image)) {
    return image[0];
  }
  return undefined;
};
exports.getNftImage = getNftImage;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\utils\\nfts.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\notification.util.ts", {"../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../shared/lib/transactions-controller-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\transactions-controller-utils.js","../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","@ethersproject/providers":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\providers\\lib\\index.js","@metamask/notification-services-controller/notification-services/ui":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\notification-services-controller\\dist\\NotificationServicesController\\ui\\index.cjs","bignumber.js":"D:\\code\\v\\metamask-extension\\node_modules\\bignumber.js\\bignumber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Cutils%5Cnotification.util.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatAmount = exports.createTextItems = void 0;
exports.formatIsoDateString = formatIsoDateString;
exports.formatMenuItemDate = formatMenuItemDate;
exports.getLeadingZeroCount = exports.getAmount = void 0;
exports.getNetworkDetailsByChainId = getNetworkDetailsByChainId;
exports.getRandomKey = exports.getNetworkNameByChainId = exports.getNetworkFees = void 0;
exports.getRpcUrlByChainId = getRpcUrlByChainId;
exports.getUsdAmount = void 0;
exports.hasNetworkFeeFields = hasNetworkFeeFields;
exports.isIpfsURL = void 0;
var _bignumber = require("bignumber.js");
var _providers = require("@ethersproject/providers");
var _ui = require("@metamask/notification-services-controller/notification-services/ui");
var _network = require("../../../shared/constants/network");
var _transactionsControllerUtils = require("../../../shared/lib/transactions-controller-utils");
var _conversion = require("../../../shared/modules/conversion.utils");
/**
 * Checks if 2 date objects are on the same day
 *
 * @param currentDate
 * @param dateToCheck
 * @returns boolean if dates are same day.
 */
const isSameDay = (currentDate, dateToCheck) => currentDate.getFullYear() === dateToCheck.getFullYear() && currentDate.getMonth() === dateToCheck.getMonth() && currentDate.getDate() === dateToCheck.getDate();

/**
 * Checks if a date is "yesterday" from the current date
 *
 * @param currentDate
 * @param dateToCheck
 * @returns boolean if dates were "yesterday"
 */
const isYesterday = (currentDate, dateToCheck) => {
  const yesterday = new Date(currentDate);
  yesterday.setDate(currentDate.getDate() - 1);
  return isSameDay(yesterday, dateToCheck);
};

/**
 * Checks if 2 date objects are in the same year.
 *
 * @param currentDate
 * @param dateToCheck
 * @returns boolean if dates were in same year
 */
const isSameYear = (currentDate, dateToCheck) => currentDate.getFullYear() === dateToCheck.getFullYear();

/**
 * Formats a given date into different formats based on how much time has elapsed since that date.
 *
 * @param date - The date to be formatted.
 * @returns The formatted date.
 */
function formatMenuItemDate(date) {
  const currentDate = new Date();

  // E.g. 12:21
  if (isSameDay(currentDate, date)) {
    return new Intl.DateTimeFormat('en', {
      hour: 'numeric',
      minute: 'numeric',
      hour12: false
    }).format(date);
  }

  // E.g. Yesterday
  if (isYesterday(currentDate, date)) {
    return new Intl.RelativeTimeFormat('en', {
      numeric: 'auto'
    }).format(-1, 'day');
  }

  // E.g. Oct 21
  if (isSameYear(currentDate, date)) {
    return new Intl.DateTimeFormat('en', {
      month: 'short',
      day: 'numeric'
    }).format(date);
  }

  // E.g. Oct 21, 2022
  return new Intl.DateTimeFormat('en', {
    year: 'numeric',
    month: 'short',
    day: 'numeric'
  }).format(date);
}
const defaultFormatOptions = {
  decimalPlaces: 4
};

/**
 * Calculates the number of leading zeros in the fractional part of a number.
 *
 * This function converts a number or a string representation of a number into
 * its decimal form and then counts the number of leading zeros present in the
 * fractional part of the number. This is useful for determining the precision
 * of very small numbers.
 *
 * @param num - The number to analyze, which can be in the form
 * of a number or a string.
 * @returns The count of leading zeros in the fractional part of the number.
 */
const getLeadingZeroCount = num => {
  var _fractionalPart$match;
  const numToString = new _bignumber.BigNumber(num, 10).toString(10);
  const fractionalPart = numToString.split('.')[1] ?? '';
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  return ((_fractionalPart$match = fractionalPart.match(/^0*/u)) === null || _fractionalPart$match === void 0 || (_fractionalPart$match = _fractionalPart$match[0]) === null || _fractionalPart$match === void 0 ? void 0 : _fractionalPart$match.length) || 0;
};

/**
 * This formats a number using Intl
 * It abbreviates large numbers (using K, M, B, T)
 * And abbreviates small numbers in 2 ways:
 * - Will format to the given number of decimal places
 * - Will format up to 4 decimal places
 * - Will ellipse the number if longer than given decimal places
 *
 * @param numericAmount
 * @param opts
 * @returns
 */
exports.getLeadingZeroCount = getLeadingZeroCount;
const formatAmount = (numericAmount, opts) => {
  // create options with defaults
  const options = {
    ...defaultFormatOptions,
    ...opts
  };
  const leadingZeros = getLeadingZeroCount(numericAmount);
  const isDecimal = numericAmount.toString().includes('.') || leadingZeros > 0 || numericAmount.toString().includes('e-');
  const isLargeNumber = numericAmount > 999;
  const handleShouldEllipse = decimalPlaces => Boolean(options === null || options === void 0 ? void 0 : options.shouldEllipse) && leadingZeros >= decimalPlaces;
  if (isLargeNumber) {
    return Intl.NumberFormat('en-US', {
      notation: 'compact',
      compactDisplay: 'short',
      maximumFractionDigits: 2
    }).format(numericAmount);
  }
  if (isDecimal) {
    const ellipse = handleShouldEllipse(options.decimalPlaces);
    const formattedValue = Intl.NumberFormat('en-US', {
      minimumFractionDigits: ellipse ? options.decimalPlaces : undefined,
      maximumFractionDigits: options.decimalPlaces
    }).format(numericAmount);
    return ellipse ? `${formattedValue}...` : formattedValue;
  }

  // Default to showing the raw amount
  return numericAmount.toString();
};

/**
 * Generates a unique key based on the provided text, index, and a random string.
 *
 * @param text - The text to be included in the key.
 * @param index - The index to be included in the key.
 * @returns The generated unique key.
 */
exports.formatAmount = formatAmount;
const getRandomKey = (text, index) => {
  const key = `${text.replace(/\s+/gu, '_').replace(/[^\w-]/gu, '')}-${index}-${Math.random().toString(36).substring(2, 15)}`;
  return key;
};

/**
 * Creates an array of text items with highlighting applied to every second item.
 *
 * This function takes an array of strings and a variant type, and returns an object containing
 * the array of items where each item is an object with the text and a boolean indicating if it
 * should be highlighted. Highlighting is applied to every second item in the array.
 *
 * @param texts - An array of strings to be transformed into text items.
 * @param variant - The variant type that applies a specific styling or type classification.
 * @returns An object containing the array of text items and the variant.
 */
exports.getRandomKey = getRandomKey;
const createTextItems = (texts, variant) => {
  const items = texts.map((text, index) => ({
    text,
    highlighted: index % 2 === 1
  }));
  return {
    items,
    variant
  };
};

/**
 * Converts a token amount from its smallest unit based on its decimals to a human-readable format,
 * applying formatting options such as decimal places and ellipsis for overflow.
 *
 * @param amount - The token amount in its smallest unit as a string.
 * @param decimals - The number of decimals the token uses.
 * @param options - Optional formatting options to specify the number of decimal places and whether to use ellipsis.
 * @returns The formatted token amount as a string. If the input is invalid, returns an empty string.
 */
exports.createTextItems = createTextItems;
const getAmount = (amount, decimals, options) => {
  if (!amount || !decimals) {
    return '';
  }
  const numericAmount = (0, _transactionsControllerUtils.calcTokenAmount)(amount, parseFloat(decimals)).toNumber();
  return formatAmount(numericAmount, options);
};

/**
 * Converts a token amount and its USD conversion rate to a formatted USD string.
 *
 * This function first converts the token amount from its smallest unit based on the provided decimals
 * to a human-readable format. It then multiplies this amount by the USD conversion rate to get the
 * equivalent amount in USD, and formats this USD amount into a readable string.
 *
 * @param amount - The token amount in its smallest unit as a string.
 * @param decimals - The number of decimals the token uses.
 * @param usd - The current USD conversion rate for the token.
 * @returns The formatted USD amount as a string. If any input is invalid, returns an empty string.
 */
exports.getAmount = getAmount;
const getUsdAmount = (amount, decimals, usd) => {
  if (!amount || !decimals || !usd) {
    return '';
  }
  const amountInEther = (0, _transactionsControllerUtils.calcTokenAmount)(amount, parseFloat(decimals)).toNumber();
  const numericAmount = parseFloat(`${amountInEther}`) * parseFloat(usd);
  return formatAmount(numericAmount);
};

/**
 * Retrieves the network name associated with a given chain ID.
 *
 * This function looks up the chain ID in a predefined map (`NETWORK_TO_NAME_MAP`)
 * to find the corresponding network name. If the chain ID is not found, it returns undefined.
 *
 * @param chainId - The chain ID for which the network name is required.
 * @returns The name of the network as a string, or undefined if the chain ID is not recognized.
 */
exports.getUsdAmount = getUsdAmount;
const getNetworkNameByChainId = chainId => {
  return _network.NETWORK_TO_NAME_MAP[chainId];
};

/**
 * Retrieves detailed information about a network based on its chain ID.
 * This includes the native currency's name, symbol, logo, a default address, and optionally a block explorer URL.
 *
 * @param chainId - The chain ID of the network for which details are required.
 * @returns An object containing details about the network:
 * - nativeCurrencyName: The name of the native currency.
 * - nativeCurrencySymbol: The symbol of the native currency.
 * - nativeCurrencyLogo: The logo URL of the native currency.
 * - nativeBlockExplorerUrl: The URL of the block explorer associated with the network, if available.
 */
exports.getNetworkNameByChainId = getNetworkNameByChainId;
function getNetworkDetailsByChainId(chainId) {
  const chainIdStr = chainId.toString();
  const hexChainId = `0x${(0, _conversion.decimalToHex)(chainId)}`;
  if (Object.values(_ui.NOTIFICATION_CHAINS_ID).includes(chainIdStr)) {
    const knownChainId = chainIdStr;
    return {
      nativeCurrencyName: _ui.NOTIFICATION_NETWORK_CURRENCY_NAME[knownChainId] ?? '',
      nativeCurrencySymbol: _ui.NOTIFICATION_NETWORK_CURRENCY_SYMBOL[knownChainId] ?? '',
      nativeCurrencyLogo: _network.CHAIN_ID_TO_NETWORK_IMAGE_URL_MAP[hexChainId],
      blockExplorerConfig: _ui.SUPPORTED_NOTIFICATION_BLOCK_EXPLORERS[knownChainId]
    };
  }
  return {
    nativeCurrencyName: _network.NETWORK_TO_NAME_MAP[hexChainId] ?? '',
    nativeCurrencySymbol: _network.CHAIN_ID_TO_CURRENCY_SYMBOL_MAP[hexChainId] ?? '',
    nativeCurrencyLogo: _network.CHAIN_ID_TO_NETWORK_IMAGE_URL_MAP[hexChainId],
    blockExplorerConfig: _ui.SUPPORTED_NOTIFICATION_BLOCK_EXPLORERS[chainIdStr]
  };
}

/**
 * Formats an ISO date string into a more readable format.
 *
 * @param isoDateString - The ISO date string to format.
 * @returns The formatted date string.
 */
function formatIsoDateString(isoDateString) {
  const date = new Date(isoDateString);
  const options = {
    year: 'numeric',
    month: 'short',
    day: 'numeric',
    hour: 'numeric',
    minute: 'numeric',
    hour12: true
  };
  const formattedDate = new Intl.DateTimeFormat('en-US', options).format(date);
  return formattedDate;
}
/**
 * Retrieves the RPC URL associated with a given chain ID.
 *
 * This function searches through the FEATURED_RPCS array to find a matching RPC configuration
 * for the provided chain ID. It returns the RPC URL if a match is found, otherwise undefined.
 *
 * @param chainId - The chain ID for which the RPC URL is required.
 * @returns The RPC URL associated with the given chain ID, or undefined if no match is found.
 */
function getRpcUrlByChainId(chainId) {
  const rpc = _network.FEATURED_RPCS.find(rpcItem => rpcItem.chainId === chainId);

  // If rpc is found, return its URL. Otherwise, return a default URL based on the chainId.
  if (rpc) {
    return rpc.rpcEndpoints[0].url;
  }
  // Fallback RPC URLs based on the chainId
  switch (chainId) {
    case _network.CHAIN_IDS.MAINNET:
      return _network.MAINNET_RPC_URL;
    case _network.CHAIN_IDS.GOERLI:
      return _network.GOERLI_RPC_URL;
    case _network.CHAIN_IDS.SEPOLIA:
      return _network.SEPOLIA_RPC_URL;
    case _network.CHAIN_IDS.LINEA_GOERLI:
      return _network.LINEA_GOERLI_RPC_URL;
    case _network.CHAIN_IDS.LINEA_SEPOLIA:
      return _network.LINEA_SEPOLIA_RPC_URL;
    case _network.CHAIN_IDS.LINEA_MAINNET:
      return _network.LINEA_MAINNET_RPC_URL;
    case _network.CHAIN_IDS.LOCALHOST:
      return _network.LOCALHOST_RPC_URL;
    default:
      // Default to MAINNET if no match is found
      return _network.MAINNET_RPC_URL;
  }
}
function hasNetworkFeeFields(notification) {
  return 'network_fee' in notification.data;
}
const getNetworkFees = async notification => {
  if (!hasNetworkFeeFields(notification)) {
    throw new Error('Invalid notification type');
  }
  const chainId = (0, _conversion.decimalToHex)(notification.chain_id);
  const rpcUrl = getRpcUrlByChainId(`0x${chainId}`);
  const connection = {
    url: rpcUrl,
    headers: false ? undefined : {
      'Infura-Source': 'metamask/metamask'
    }
  };
  const provider = new _providers.JsonRpcProvider(connection);
  if (!provider) {
    throw new Error(`No provider found for chainId ${chainId}`);
  }
  try {
    const [receipt, transaction, block] = await Promise.all([provider.getTransactionReceipt(notification.tx_hash), provider.getTransaction(notification.tx_hash), provider.getBlock(notification.block_number)]);
    const calculateUsdAmount = (value, decimalPlaces) => formatAmount(parseFloat(value) * parseFloat(notification.data.network_fee.native_token_price_in_usd), {
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
      // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
      decimalPlaces: decimalPlaces || 4
    });
    const transactionFeeInEth = (0, _conversion.hexWEIToDecETH)(receipt.gasUsed.mul(receipt.effectiveGasPrice)._hex);
    const transactionFeeInUsd = calculateUsdAmount(transactionFeeInEth);
    const gasLimit = transaction.gasLimit.toNumber();
    const gasUsed = receipt.gasUsed.toNumber();
    const baseFee = block.baseFeePerGas ? (0, _conversion.hexWEIToDecGWEI)(block.baseFeePerGas._hex) : null;
    const priorityFee = block.baseFeePerGas ? (0, _conversion.hexWEIToDecGWEI)(receipt.effectiveGasPrice.sub(block.baseFeePerGas)._hex) : null;
    const maxFeePerGas = transaction.maxFeePerGas ? (0, _conversion.hexWEIToDecGWEI)(transaction.maxFeePerGas._hex) : null;
    return {
      transactionFeeInEth,
      transactionFeeInUsd,
      gasLimit,
      gasUsed,
      baseFee,
      priorityFee,
      maxFeePerGas
    };
  } catch (error) {
    throw new Error(
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31893
    // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
    `Error fetching network fees for chainId ${chainId}: ${error}`);
  }
};

/**
 * Checks if a given URL is an IPFS URL.
 *
 * @param url - The URL to check.
 * @returns True if the URL is an IPFS URL, false otherwise.
 */
exports.getNetworkFees = getNetworkFees;
const isIpfsURL = url => {
  return url.startsWith('ipfs://');
};
exports.isIpfsURL = isIpfsURL;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\utils\\notification.util.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\number-utils.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Cutils%5Cnumber-utils.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isZeroAmount = isZeroAmount;
/**
 * Helper function to test whether an amount (with or without currency symbols) is equal to zero.
 *
 * @param amount - The amount to test.
 * @returns true if the amount is undefined, null, an empty string, or zero-like; false otherwise.
 * @example
 * ``` typescript
 * isZeroAmount(null)        // true
 * isZeroAmount(undefined)   // true
 * isZeroAmount('')          // true
 * isZeroAmount('0')         // true
 * isZeroAmount('0.00')      // true
 * isZeroAmount('$0.00')     // true
 * isZeroAmount('$1.00')     // false
 * isZeroAmount(0)           // true
 * isZeroAmount(1)           // false
 * ```
 */
function isZeroAmount(amount) {
  if (amount === null || amount === undefined) {
    return true;
  }
  if (typeof amount === 'number') {
    return amount === 0;
  }
  const onlyNumbers = amount.replace(/\D+/gu, '').trim();
  return /^0*$/u.test(onlyNumbers);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\utils\\number-utils.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\permission.js", {"../../../app/scripts/controllers/permissions":"D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\permissions\\index.js","../../../shared/constants/permissions":"D:\\code\\v\\metamask-extension\\shared\\constants\\permissions.ts","../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","./util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","@metamask/chain-agnostic-permission":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\chain-agnostic-permission\\dist\\index.cjs","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/snaps-rpc-methods":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","deep-freeze-strict":"D:\\code\\v\\metamask-extension\\node_modules\\deep-freeze-strict\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Cutils%5Cpermission.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPermissionDescription = void 0;
exports.getWeightedPermissions = getWeightedPermissions;
var _deepFreezeStrict = _interopRequireDefault(require("deep-freeze-strict"));
var _react = _interopRequireDefault(require("react"));
var _snapsRpcMethods = require("@metamask/snaps-rpc-methods");
var _snapsUtils = require("@metamask/snaps-utils");
var _controllerUtils = require("@metamask/controller-utils");
var _chainAgnosticPermission = require("@metamask/chain-agnostic-permission");
var _permissions = require("../../../shared/constants/permissions");
var _componentLibrary = require("../../components/component-library");
var _designSystem = require("../constants/design-system");
var _permissions2 = require("../../../app/scripts/controllers/permissions");
var _util = require("./util");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

const UNKNOWN_PERMISSION = Symbol('unknown');
const RIGHT_INFO_ICON = /*#__PURE__*/_react.default.createElement(_componentLibrary.Icon, {
  name: _componentLibrary.IconName.Info,
  size: _componentLibrary.IconSize.Sm,
  color: _designSystem.IconColor.iconMuted
});
function getSnapNameComponent(snapName) {
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    fontWeight: _designSystem.FontWeight.Medium,
    variant: _designSystem.TextVariant.inherit,
    color: _designSystem.TextColor.inherit
  }, snapName);
}
const PERMISSION_DESCRIPTIONS = (0, _deepFreezeStrict.default)({
  // "endowment:caip25" entry is needed for the Snaps Permissions Review UI
  [_chainAgnosticPermission.Caip25EndowmentPermissionName]: ({
    t,
    isRequestApprovalPermittedChains
  }) => {
    if (isRequestApprovalPermittedChains) {
      return {
        label: t('permission_walletSwitchEthereumChain'),
        leftIcon: _componentLibrary.IconName.Wifi,
        weight: _permissions.PermissionWeight.permittedChains
      };
    }
    return {
      label: t('permission_ethereumAccounts'),
      leftIcon: _componentLibrary.IconName.Eye,
      weight: _permissions.PermissionWeight.eth_accounts
    };
  },
  // "eth_accounts" entry is needed for the Snaps Permissions Grant UI
  [_permissions.RestrictedMethods.eth_accounts]: ({
    t
  }) => ({
    label: t('permission_ethereumAccounts'),
    leftIcon: _componentLibrary.IconName.Eye,
    weight: _permissions.PermissionWeight.eth_accounts
  }),
  [_permissions2.PermissionNames.permittedChains]: ({
    t
  }) => ({
    label: t('permission_walletSwitchEthereumChain'),
    leftIcon: _componentLibrary.IconName.Wifi,
    weight: _permissions.PermissionWeight.permittedChains
  }),
  [_permissions.RestrictedMethods.snap_dialog]: ({
    t,
    subjectName
  }) => ({
    label: t('permission_dialog'),
    description: t('permission_dialogDescription', [getSnapNameComponent(subjectName)]),
    leftIcon: _componentLibrary.IconName.Messages,
    weight: _permissions.PermissionWeight.snap_dialog
  }),
  [_permissions.RestrictedMethods.snap_notify]: ({
    t,
    subjectName
  }) => ({
    label: t('permission_notifications'),
    description: t('permission_notificationsDescription', [getSnapNameComponent(subjectName)]),
    leftIcon: _componentLibrary.IconName.Notification,
    weight: _permissions.PermissionWeight.snap_notify
  }),
  [_permissions.RestrictedMethods.snap_getBip32PublicKey]: ({
    t,
    permissionValue,
    subjectName
  }) => permissionValue.caveats[0].value.map(({
    path,
    curve
  }, i) => {
    var _path$join;
    const baseDescription = {
      leftIcon: _componentLibrary.IconName.SecuritySearch,
      weight: _permissions.PermissionWeight.snap_getBip32PublicKey,
      id: `public-key-access-bip32-${(_path$join = path.join('-')) === null || _path$join === void 0 ? void 0 : _path$join.replace(/'/gu, 'h')}-${curve}-${i}`,
      warningMessageSubject: (0, _snapsUtils.getSnapDerivationPathName)(path, curve) ?? `${t('unknownNetworkForKeyEntropy')}  ${path.join('/')} (${curve})`
    };
    const friendlyName = (0, _snapsUtils.getSnapDerivationPathName)(path, curve);
    if (friendlyName) {
      return {
        ...baseDescription,
        label: t('permission_viewNamedBip32PublicKeys', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
          color: _designSystem.TextColor.inherit,
          variant: _designSystem.TextVariant.inherit,
          fontWeight: _designSystem.FontWeight.Medium,
          key: path.join('/')
        }, friendlyName)]),
        description: t('permission_viewBip32PublicKeysDescription', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
          color: _designSystem.TextColor.inherit,
          variant: _designSystem.TextVariant.inherit,
          fontWeight: _designSystem.FontWeight.Medium,
          key: `description-${path.join('/')}`
        }, friendlyName), getSnapNameComponent(subjectName)])
      };
    }
    return {
      ...baseDescription,
      label: t('permission_viewBip32PublicKeys', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        color: _designSystem.TextColor.inherit,
        variant: _designSystem.TextVariant.inherit,
        fontWeight: _designSystem.FontWeight.Medium,
        key: path.join('/')
      }, `${t('unknownNetworkForKeyEntropy')} `, " ", path.join('/')), curve]),
      description: t('permission_viewBip32PublicKeysDescription', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        color: _designSystem.TextColor.inherit,
        variant: _designSystem.TextVariant.inherit,
        fontWeight: _designSystem.FontWeight.Medium,
        key: `description-${path.join('/')}`
      }, path.join('/')), getSnapNameComponent(subjectName)])
    };
  }),
  [_permissions.RestrictedMethods.snap_getBip32Entropy]: ({
    t,
    permissionValue,
    subjectName
  }) => permissionValue.caveats[0].value.map(({
    path,
    curve
  }, i) => {
    var _path$join2;
    const baseDescription = {
      leftIcon: _componentLibrary.IconName.Key,
      weight: _permissions.PermissionWeight.snap_getBip32Entropy,
      id: `key-access-bip32-${(_path$join2 = path.join('-')) === null || _path$join2 === void 0 ? void 0 : _path$join2.replace(/'/gu, 'h')}-${curve}-${i}`,
      warningMessageSubject: (0, _snapsUtils.getSnapDerivationPathName)(path, curve) ?? `${t('unknownNetworkForKeyEntropy')} ${path.join('/')} (${curve})`
    };
    const friendlyName = (0, _snapsUtils.getSnapDerivationPathName)(path, curve);
    if (friendlyName) {
      return {
        ...baseDescription,
        label: t('permission_manageBip32Keys', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
          color: _designSystem.TextColor.inherit,
          variant: _designSystem.TextVariant.inherit,
          fontWeight: _designSystem.FontWeight.Medium,
          key: path.join('/')
        }, friendlyName)]),
        description: t('permission_manageBip44AndBip32KeysDescription', [getSnapNameComponent(subjectName)])
      };
    }
    return {
      ...baseDescription,
      label: t('permission_manageBip32Keys', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
        color: _designSystem.TextColor.inherit,
        variant: _designSystem.TextVariant.inherit,
        fontWeight: _designSystem.FontWeight.Medium,
        key: path.join('/')
      }, `${t('unknownNetworkForKeyEntropy')} ${path.join('/')} (${curve})`)]),
      description: t('permission_manageBip44AndBip32KeysDescription', [getSnapNameComponent(subjectName)])
    };
  }),
  [_permissions.RestrictedMethods.snap_getBip44Entropy]: ({
    t,
    permissionValue,
    subjectName
  }) => permissionValue.caveats[0].value.map(({
    coinType
  }, i) => ({
    label: t('permission_manageBip44Keys', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
      color: _designSystem.TextColor.inherit,
      variant: _designSystem.TextVariant.inherit,
      fontWeight: _designSystem.FontWeight.Medium,
      key: `coin-type-${coinType}`
    }, (0, _snapsUtils.getSlip44ProtocolName)(coinType) ?? `${t('unknownNetworkForKeyEntropy')} m/44'/${coinType}'`)]),
    description: t('permission_manageBip44AndBip32KeysDescription', [getSnapNameComponent(subjectName)]),
    leftIcon: _componentLibrary.IconName.Key,
    weight: _permissions.PermissionWeight.snap_getBip44Entropy,
    id: `key-access-bip44-${coinType}-${i}`,
    warningMessageSubject: (0, _snapsUtils.getSlip44ProtocolName)(coinType) ?? `${t('unknownNetworkForKeyEntropy')} m/44'/${coinType}'`
  })),
  [_permissions.RestrictedMethods.snap_getEntropy]: ({
    t,
    subjectName
  }) => ({
    label: t('permission_getEntropy', [getSnapNameComponent(subjectName)]),
    description: t('permission_getEntropyDescription', [getSnapNameComponent(subjectName)]),
    leftIcon: _componentLibrary.IconName.SecurityKey,
    weight: _permissions.PermissionWeight.snap_getEntropy
  }),
  [_permissions.RestrictedMethods.snap_manageState]: ({
    t,
    subjectName
  }) => ({
    label: t('permission_manageState'),
    description: t('permission_manageStateDescription', [getSnapNameComponent(subjectName)]),
    leftIcon: _componentLibrary.IconName.AddSquare,
    weight: _permissions.PermissionWeight.snap_manageState
  }),
  [_permissions.RestrictedMethods.snap_getLocale]: ({
    t,
    subjectName
  }) => ({
    label: t('permission_getLocale'),
    description: t('permission_getLocaleDescription', [getSnapNameComponent(subjectName)]),
    leftIcon: _componentLibrary.IconName.Global,
    weight: _permissions.PermissionWeight.snap_getLocale
  }),
  [_permissions.RestrictedMethods.snap_getPreferences]: ({
    t,
    subjectName
  }) => ({
    label: t('permission_getPreferences'),
    description: t('permission_getPreferencesDescription', [getSnapNameComponent(subjectName)]),
    leftIcon: _componentLibrary.IconName.Customize,
    weight: 4
  }),
  [_permissions.RestrictedMethods.wallet_snap]: ({
    t,
    permissionValue,
    getSubjectName
  }) => {
    const snaps = permissionValue.caveats[0].value;
    const baseDescription = {
      leftIcon: _componentLibrary.IconName.Flash,
      rightIcon: RIGHT_INFO_ICON,
      weight: _permissions.PermissionWeight.wallet_snap
    };
    return Object.keys(snaps).map(snapId => {
      const snapName = getSubjectName(snapId);
      if (snapName) {
        return {
          ...baseDescription,
          label: t('permission_accessNamedSnap', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
            color: _designSystem.TextColor.inherit,
            variant: _designSystem.TextVariant.inherit,
            fontWeight: _designSystem.FontWeight.Medium,
            key: snapId
          }, snapName)]),
          description: t('permission_accessSnapDescription', [snapName])
        };
      }
      return {
        ...baseDescription,
        label: t('permission_accessSnap', [snapId]),
        description: t('permission_accessSnapDescription', [snapId])
      };
    });
  },
  [_permissions.EndowmentPermissions['endowment:network-access']]: ({
    t,
    subjectName
  }) => ({
    label: t('permission_accessNetwork'),
    description: t('permission_accessNetworkDescription', [getSnapNameComponent(subjectName)]),
    leftIcon: _componentLibrary.IconName.Wifi,
    weight: _permissions.PermissionWeight.endowment_networkAccess
  }),
  [_permissions.EndowmentPermissions['endowment:webassembly']]: ({
    t,
    subjectName
  }) => ({
    label: t('permission_webAssembly'),
    description: t('permission_webAssemblyDescription', [getSnapNameComponent(subjectName)]),
    leftIcon: _componentLibrary.IconName.DocumentCode,
    rightIcon: null,
    weight: _permissions.PermissionWeight.endowment_webassembly
  }),
  [_permissions.EndowmentPermissions['endowment:transaction-insight']]: ({
    t,
    permissionValue,
    subjectName
  }) => {
    const baseDescription = {
      leftIcon: _componentLibrary.IconName.Speedometer,
      weight: _permissions.PermissionWeight.endowment_transactionInsight
    };
    const result = [{
      ...baseDescription,
      label: t('permission_transactionInsight'),
      description: t('permission_transactionInsightDescription', [getSnapNameComponent(subjectName)])
    }];
    if ((0, _controllerUtils.isNonEmptyArray)(permissionValue.caveats) && permissionValue.caveats[0].type === _snapsUtils.SnapCaveatType.TransactionOrigin && permissionValue.caveats[0].value) {
      result.push({
        ...baseDescription,
        label: t('permission_transactionInsightOrigin'),
        description: t('permission_transactionInsightOriginDescription', [getSnapNameComponent(subjectName)]),
        leftIcon: _componentLibrary.IconName.Explore
      });
    }
    return result;
  },
  [_permissions.EndowmentPermissions['endowment:cronjob']]: ({
    t,
    subjectName
  }) => ({
    label: t('permission_cronjob'),
    description: t('permission_cronjobDescription', [getSnapNameComponent(subjectName)]),
    leftIcon: _componentLibrary.IconName.Clock,
    weight: _permissions.PermissionWeight.endowment_cronjob
  }),
  [_permissions.EndowmentPermissions['endowment:ethereum-provider']]: ({
    t,
    subjectName
  }) => ({
    label: t('permission_ethereumProvider'),
    description: t('permission_ethereumProviderDescription', [getSnapNameComponent(subjectName)]),
    leftIcon: _componentLibrary.IconName.Ethereum,
    weight: _permissions.PermissionWeight.endowment_ethereumProvider,
    id: 'ethereum-provider-access',
    message: t('ethereumProviderAccess', [getSnapNameComponent(subjectName)])
  }),
  [_permissions.EndowmentPermissions['endowment:rpc']]: ({
    t,
    permissionValue,
    subjectName
  }) => {
    const baseDescription = {
      leftIcon: _componentLibrary.IconName.Hierarchy,
      weight: _permissions.PermissionWeight.endowment_rpc
    };
    const {
      snaps,
      dapps,
      allowedOrigins
    } = (0, _snapsRpcMethods.getRpcCaveatOrigins)(permissionValue);
    const results = [];
    if (snaps) {
      results.push({
        ...baseDescription,
        label: t('permission_rpc', [t('otherSnaps'), getSnapNameComponent(subjectName)]),
        description: t('permission_rpcDescription', [t('otherSnaps'), getSnapNameComponent(subjectName)])
      });
    }
    if (dapps) {
      results.push({
        ...baseDescription,
        label: t('permission_rpc', [t('websites'), getSnapNameComponent(subjectName)]),
        description: t('permission_rpcDescription', [t('websites'), getSnapNameComponent(subjectName)])
      });
    }
    if ((allowedOrigins === null || allowedOrigins === void 0 ? void 0 : allowedOrigins.length) > 0) {
      let originsMessage;
      if (allowedOrigins.length === 1) {
        originsMessage = /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
          color: _designSystem.TextColor.inherit,
          variant: _designSystem.TextVariant.inherit,
          fontWeight: _designSystem.FontWeight.Medium,
          style: {
            lineBreak: 'anywhere'
          }
        }, allowedOrigins[0]);
      } else {
        const lastOrigin = allowedOrigins.slice(-1);
        const originList = allowedOrigins.slice(0, -1).map(origin => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
          color: _designSystem.TextColor.inherit,
          variant: _designSystem.TextVariant.inherit,
          fontWeight: _designSystem.FontWeight.Medium,
          style: {
            lineBreak: 'anywhere'
          }
        }, origin), ', '));
        originsMessage = t('permission_rpcDescriptionOriginList', [originList, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
          color: _designSystem.TextColor.inherit,
          variant: _designSystem.TextVariant.inherit,
          fontWeight: _designSystem.FontWeight.Medium,
          key: "2",
          style: {
            lineBreak: 'anywhere'
          }
        }, lastOrigin)]);
      }
      results.push({
        ...baseDescription,
        label: t('permission_rpc', [originsMessage, getSnapNameComponent(subjectName)]),
        description: t('permission_rpcDescription', [originsMessage, getSnapNameComponent(subjectName)])
      });
    }
    return results;
  },
  [_permissions.EndowmentPermissions['endowment:lifecycle-hooks']]: ({
    t,
    subjectName
  }) => ({
    label: t('permission_lifecycleHooks'),
    description: t('permission_lifecycleHooksDescription', [getSnapNameComponent(subjectName)]),
    leftIcon: _componentLibrary.IconName.Hierarchy,
    weight: _permissions.PermissionWeight.endowment_lifecycleHooks
  }),
  [_permissions.EndowmentPermissions['endowment:page-home']]: ({
    t,
    subjectName
  }) => ({
    label: t('permission_homePage'),
    description: t('permission_homePageDescription', [getSnapNameComponent(subjectName)]),
    leftIcon: _componentLibrary.IconName.Home,
    weight: _permissions.PermissionWeight.endowment_pageHome
  }),
  ///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
  [_permissions.RestrictedMethods.snap_manageAccounts]: ({
    t,
    subjectName
  }) => ({
    label: t('permission_manageAccounts'),
    description: t('permission_manageAccountsDescription', [getSnapNameComponent(subjectName)]),
    leftIcon: _componentLibrary.IconName.UserCircleAdd,
    rightIcon: null,
    weight: _permissions.PermissionWeight.snap_manageAccounts
  }),
  [_permissions.EndowmentPermissions['endowment:keyring']]: ({
    t,
    subjectName
  }) => ({
    label: t('permission_keyring'),
    description: t('permission_keyringDescription', [getSnapNameComponent(subjectName)]),
    leftIcon: _componentLibrary.IconName.UserCircleAdd,
    rightIcon: null,
    weight: _permissions.PermissionWeight.endowment_keyring
  }),
  ///: END:ONLY_INCLUDE_IF
  [_permissions.EndowmentPermissions['endowment:name-lookup']]: ({
    t
  }) => ({
    label: t('permission_nameLookup'),
    description: t('permission_nameLookupDescription'),
    leftIcon: _componentLibrary.IconName.Search,
    weight: _permissions.PermissionWeight.endowment_nameLookup
  }),
  [_permissions.EndowmentPermissions['endowment:assets']]: ({
    t,
    subjectName
  }) => ({
    label: t('permission_assets'),
    description: t('permission_assetsDescription', [getSnapNameComponent(subjectName)]),
    leftIcon: _componentLibrary.IconName.Coin,
    weight: _permissions.PermissionWeight.endowment_assets
  }),
  [_permissions.EndowmentPermissions['endowment:protocol']]: ({
    t,
    subjectName
  }) => ({
    label: t('permission_protocol'),
    description: t('permission_protocolDescription', [getSnapNameComponent(subjectName)]),
    leftIcon: _componentLibrary.IconName.GlobalSearch,
    weight: _permissions.PermissionWeight.endowment_protocol
  }),
  [_permissions.EndowmentPermissions['endowment:signature-insight']]: ({
    t,
    permissionValue,
    subjectName
  }) => {
    const baseDescription = {
      leftIcon: _componentLibrary.IconName.Warning,
      weight: _permissions.PermissionWeight.endowment_signatureInsight
    };
    const result = [{
      ...baseDescription,
      label: t('permission_signatureInsight'),
      description: t('permission_signatureInsightDescription', [getSnapNameComponent(subjectName)])
    }];
    if ((0, _controllerUtils.isNonEmptyArray)(permissionValue.caveats) && permissionValue.caveats.find(caveat => {
      return caveat.type === _snapsUtils.SnapCaveatType.SignatureOrigin && caveat.value;
    })) {
      result.push({
        ...baseDescription,
        label: t('permission_signatureInsightOrigin'),
        description: t('permission_signatureInsightOriginDescription', [getSnapNameComponent(subjectName)]),
        leftIcon: _componentLibrary.IconName.Explore
      });
    }
    return result;
  },
  // connection_permission is pseudo permission used only for
  // displaying pre-approved connections alongside other permissions
  [_permissions.ConnectionPermission.connection_permission]: ({
    t,
    permissionValue,
    subjectName
  }) => {
    return Object.keys(permissionValue).map(connection => {
      let connectionName = (0, _util.getURLHost)(connection);
      // In case the connection is a Snap
      if (!connectionName) {
        connectionName = connection.replace('npm:', '');
      }
      return {
        label: t('snapConnectTo', [/*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
          key: "connectToMain",
          fontWeight: _designSystem.FontWeight.Medium,
          variant: _designSystem.TextVariant.inherit,
          color: _designSystem.TextColor.inherit,
          style: {
            lineBreak: 'anywhere'
          }
        }, connectionName)]),
        description: t('snapConnectionPermissionDescription', [getSnapNameComponent(subjectName), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
          key: "connectToDescription",
          fontWeight: _designSystem.FontWeight.Medium,
          variant: _designSystem.TextVariant.inherit,
          color: _designSystem.TextColor.inherit
        }, connectionName)]),
        leftIcon: undefined,
        // Icon for connections is handled by PermissionCell
        connection,
        connectionName,
        subjectName,
        weight: _permissions.PermissionWeight.connection_permission
      };
    });
  },
  [UNKNOWN_PERMISSION]: ({
    t,
    permissionName
  }) => ({
    label: t('permission_unknown', [permissionName ?? 'undefined']),
    leftIcon: _componentLibrary.IconName.Question,
    rightIcon: null,
    weight: _permissions.PermissionWeight.unknown_permission
  })
});

/**
 * @typedef {object} PermissionLabelObject
 * @property {string} label - The text label.
 * @property {string} [description] - An optional description, shown when the
 * `rightIcon` is hovered.
 * @property {string} leftIcon - The left icon.
 * @property {string} rightIcon - The right icon.
 * @property {number} weight - The weight of the permission.
 * @property {string} permissionName - The name of the permission.
 * @property {string} permissionValue - The raw value of the permission.
 */

/**
 * @typedef {object} PermissionDescriptionParamsObject
 * @property {Function} t - The translation function.
 * @property {boolean} [isRequestApprovalPermittedChains] - Flag for checking if request incoming from 'wallet_switchEthereumChain'.
 * @property {string} permissionName - The name of the permission.
 * @property {object} permissionValue - The permission object.
 * @property {string} subjectName - The name of the subject.
 * @property {Function} getSubjectName - The function used to get the subject name.
 */

/**
 * @param {PermissionDescriptionParamsObject} params - The permission description params object.
 * @returns {PermissionLabelObject[]}
 */
const getPermissionDescription = ({
  t,
  isRequestApprovalPermittedChains,
  permissionName,
  permissionValue,
  subjectName,
  getSubjectName
}) => {
  let value = PERMISSION_DESCRIPTIONS[UNKNOWN_PERMISSION];
  if (Object.hasOwnProperty.call(PERMISSION_DESCRIPTIONS, permissionName)) {
    value = PERMISSION_DESCRIPTIONS[permissionName];
  }
  const result = value({
    t,
    isRequestApprovalPermittedChains,
    permissionName,
    permissionValue,
    subjectName,
    getSubjectName
  });
  if (!Array.isArray(result)) {
    return [{
      ...result,
      permissionName,
      permissionValue
    }];
  }
  return result.map(item => ({
    ...item,
    permissionName,
    permissionValue
  }));
};

/**
 * @typedef {object} WeightedPermissionDescriptionParamsObject
 * @property {Function} t - The translation function.
 * @property {boolean} [isRequestApprovalPermittedChains] - Flag for checking if request incoming from 'wallet_switchEthereumChain'.
 * @property {string} permissions - The permissions object.
 * @property {Function} [getSubjectName] - The function to get a subject name.
 * @property {string} [subjectName] - The name of the subject.
 */

/**
 * Get the weighted permissions from a permissions object. The weight is used to
 * sort the permissions in the UI.
 *
 * @param {WeightedPermissionDescriptionParamsObject} params - The weighted permissions params object.
 * @returns {PermissionLabelObject[]}
 */
exports.getPermissionDescription = getPermissionDescription;
function getWeightedPermissions({
  t,
  isRequestApprovalPermittedChains,
  permissions,
  getSubjectName,
  subjectName
}) {
  return Object.entries(permissions).reduce((target, [permissionName, permissionValue]) => target.concat(getPermissionDescription({
    t,
    isRequestApprovalPermittedChains,
    permissionName,
    permissionValue,
    subjectName,
    getSubjectName
  })), []).sort((left, right) => left.weight - right.weight);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\utils\\permission.js",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\permissions.ts", {"../../../shared/constants/permissions":"D:\\code\\v\\metamask-extension\\shared\\constants\\permissions.ts","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Cutils%5Cpermissions.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.containsEthPermissionsAndNonEvmAccount = void 0;
var _keyringApi = require("@metamask/keyring-api");
var _permissions = require("../../../shared/constants/permissions");
const containsEthPermissionsAndNonEvmAccount = (accounts, permissions) => {
  const restrictedEthMethods = Object.keys(_permissions.RestrictedEthMethods);
  const containsEthPermissions = Object.keys(permissions).some(permission => restrictedEthMethods.includes(permission));
  const containsNonEvmAccount = accounts.some(account => !(0, _keyringApi.isEvmAccountType)(account.type));
  return containsEthPermissions && containsNonEvmAccount;
};
exports.containsEthPermissionsAndNonEvmAccount = containsEthPermissionsAndNonEvmAccount;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\utils\\permissions.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\portfolio.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Cutils%5Cportfolio.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPortfolioUrl = getPortfolioUrl;
function getPortfolioUrl(endpoint = '', metamaskEntry = '', metaMetricsId = '', metricsEnabled = false, marketingEnabled = false, accountAddress, tab) {
  const baseUrl = "https://app.metamask.io" || '';
  const url = new URL(endpoint, baseUrl);
  url.searchParams.append('metamaskEntry', metamaskEntry);
  url.searchParams.append('metametricsId', metaMetricsId);

  // Append privacy preferences for metrics + marketing on user navigation to Portfolio
  url.searchParams.append('metricsEnabled', String(metricsEnabled));
  url.searchParams.append('marketingEnabled', String(marketingEnabled));
  if (accountAddress) {
    url.searchParams.append('accountAddress', accountAddress);
  }
  if (tab) {
    url.searchParams.append('tab', tab);
  }
  return url.href;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\utils\\portfolio.js",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\settings-search.js", {"../../../shared/modules/environment":"D:\\code\\v\\metamask-extension\\shared\\modules\\environment.ts","../constants/settings":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\settings.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Cutils%5Csettings-search.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.colorText = colorText;
exports.escapeRegExp = void 0;
exports.getNumberOfSettingRoutesInTab = getNumberOfSettingRoutesInTab;
exports.getSettingsRoutes = getSettingsRoutes;
exports.getSpecificSettingsRoute = getSpecificSettingsRoute;
exports.handleSettingsRefs = handleSettingsRefs;
exports.highlightSearchedText = highlightSearchedText;
var _settings = _interopRequireDefault(require("../constants/settings"));
var _environment = require("../../../shared/modules/environment");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/* eslint-disable require-unicode-regexp */

let settingsRoutes;
const FEATURE_FLAG_CHECKERS = {
  METAMASK_SHIELD_ENABLED: _environment.getIsMetaMaskShieldFeatureEnabled,
  ENABLE_SETTINGS_PAGE_DEV_OPTIONS: _environment.getIsSettingsPageDevOptionsEnabled
};

/**
 * Checks if a feature flag is enabled
 *
 * @param {string} featureFlag - The feature flag to check
 * @returns {boolean} Whether the feature flag is enabled
 */
function isFeatureFlagEnabled(featureFlag) {
  const checker = FEATURE_FLAG_CHECKERS[featureFlag];
  if (checker) {
    return checker();
  }
  console.warn(`Unknown feature flag: ${featureFlag}`);
  return false;
}

/** @returns {SettingRouteConfig[]} */
function getSettingsRoutes() {
  if (settingsRoutes) {
    return settingsRoutes;
  }
  settingsRoutes = _settings.default.filter(routeObject => {
    return (routeObject.featureFlag ? isFeatureFlagEnabled(routeObject.featureFlag) : true) && !routeObject.hidden;
  });
  return settingsRoutes;
}

/**
 * @param {Function} t - context.t function
 * @param {string} tabMessage
 * @returns {SettingRouteConfig[]}
 */
function getFilteredSettingsRoutes(t, tabMessage) {
  return getSettingsRoutes().filter(routeObject => {
    return routeObject.tabMessage(t) === tabMessage;
  });
}
function getSpecificSettingsRoute(t, tabMessage, sectionMessage) {
  return getSettingsRoutes().find(routeObject => {
    return routeObject.tabMessage(t) === tabMessage && routeObject.sectionMessage(t) === sectionMessage;
  });
}

/**
 * @param {Function} t - context.t function
 * @param {string} tabMessage
 * @returns {number}
 */
function getNumberOfSettingRoutesInTab(t, tabMessage) {
  return getFilteredSettingsRoutes(t, tabMessage).length;
}
function handleSettingsRefs(t, tabMessage, settingsRefs) {
  const settingsSearchJsonFiltered = getFilteredSettingsRoutes(t, tabMessage);
  const settingsRefsIndex = settingsSearchJsonFiltered.findIndex(routeObject => routeObject.route.substring(1) === window.location.hash.substring(1));
  if (settingsRefsIndex === -1) {
    return;
  }
  const settingsRef = settingsSearchJsonFiltered.length === 1 ? settingsRefs : settingsRefs[settingsRefsIndex];
  if (settingsRef !== null && settingsRef !== void 0 && settingsRef.current) {
    settingsRef.current.scrollIntoView({
      behavior: 'smooth'
    });
    settingsRef.current.focus();
    const historySettingsUrl = window.location.hash.split('#')[1];
    window.location.hash = historySettingsUrl;
  }
}
function colorText(menuElement, regex) {
  if (menuElement !== null) {
    let elemText = menuElement.innerHTML;
    elemText = elemText.replace('&amp;', '&');
    elemText = elemText.replace(/(<span class="settings-page__header__search__list__item__highlight">|<\/span>)/gim, '');
    menuElement.innerHTML = elemText.replace(regex, '<span class="settings-page__header__search__list__item__highlight">$&</span>');
  }
}

/**
 * Replaces any special characters in the input string that have a meaning in regular expressions
 * (such as \, *, +, ?, etc.) with their escaped versions (e.g., \ becomes \\).
 *
 * @param input - The input string to be escaped for use in a regular expression.
 * @returns The escaped string safe for use in a regular expression.
 */
const escapeRegExp = input => {
  return input.replace(/[.*+?^${}()|[\]\\]/g, '\\$&'); // Escapes special characters
};
exports.escapeRegExp = escapeRegExp;
function highlightSearchedText() {
  const searchElem = document.getElementById('search-settings');
  const searchRegex = new RegExp(escapeRegExp(searchElem.value), 'gi');
  const results = document.querySelectorAll('.settings-page__header__search__list__item');
  [...results].forEach(element => {
    const menuTabElement = element.querySelector('.settings-page__header__search__list__item__tab');
    const menuSectionElement = element.querySelector('.settings-page__header__search__list__item__section');
    colorText(menuTabElement, searchRegex);
    colorText(menuSectionElement, searchRegex);
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\utils\\settings-search.js",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\state-corruption-html.ts", {"../../../shared/constants/state-corruption":"D:\\code\\v\\metamask-extension\\shared\\constants\\state-corruption.ts","../../../shared/lib/error-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\error-utils.js","../../../shared/lib/get-first-preferred-lang-code":"D:\\code\\v\\metamask-extension\\shared\\lib\\get-first-preferred-lang-code.js","../../../shared/lib/switch-direction":"D:\\code\\v\\metamask-extension\\shared\\lib\\switch-direction.js","../../../shared/lib/translate":"D:\\code\\v\\metamask-extension\\shared\\lib\\translate.ts","../../../shared/lib/ui-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\ui-utils.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Cutils%5Cstate-corruption-html.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.displayStateCorruptionError = displayStateCorruptionError;
exports.getStateCorruptionErrorHtml = getStateCorruptionErrorHtml;
var _loglevel = _interopRequireDefault(require("loglevel"));
var _lodash = require("lodash");
var _uiUtils = require("../../../shared/lib/ui-utils");
var _errorUtils = require("../../../shared/lib/error-utils");
var _switchDirection = require("../../../shared/lib/switch-direction");
var _getFirstPreferredLangCode = _interopRequireDefault(require("../../../shared/lib/get-first-preferred-lang-code"));
var _stateCorruption = require("../../../shared/constants/state-corruption");
var _translate = require("../../../shared/lib/translate");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
async function getStateCorruptionErrorHtml(vaultRecoveryLink, hasBackup, currentLocale, supportLink) {
  let preferredLocale;
  if (currentLocale) {
    preferredLocale = currentLocale;
    await (0, _translate.updateCurrentLocale)(currentLocale);
  } else {
    preferredLocale = await (0, _getFirstPreferredLangCode.default)();
    await (0, _translate.updateCurrentLocale)(preferredLocale);
  }
  (0, _switchDirection.switchDirectionForPreferredLocale)(preferredLocale);
  const instructionsLink = `<a href="${(0, _lodash.escape)(vaultRecoveryLink)}" title="${(0, _lodash.escape)((0, _translate.t)('stateCorruptionTheseInstructionsLinkTitle') ?? '')}" class="critical-error__link" target="_blank" rel="noopener noreferrer">${(0, _lodash.escape)((0, _translate.t)('stateCorruptionTheseInstructions') ?? '')}</a>`;
  let corruptionDetectedMessage, copyAndRestoreMessage, restoreOrResetMessage;
  if (hasBackup) {
    corruptionDetectedMessage = (0, _translate.t)('stateCorruptionDetectedWithBackup') ?? '';
    copyAndRestoreMessage = (0, _translate.t)('stateCorruptionCopyAndRestoreBeforeRecovery', instructionsLink) ?? '';
    restoreOrResetMessage = (0, _translate.t)('stateCorruptionRestoreAccountsFromBackup') ?? '';
  } else {
    corruptionDetectedMessage = (0, _translate.t)('stateCorruptionDetectedNoBackup') ?? '';
    copyAndRestoreMessage = (0, _translate.t)('stateCorruptionCopyAndRestoreBeforeReset', instructionsLink) ?? '';
    restoreOrResetMessage = (0, _translate.t)('stateCorruptionResetMetaMaskState') ?? '';
  }
  const header = `
    <h1>${(0, _translate.t)('stateCorruptionMetamaskDatabaseCannotBeAccessed')}</h1>
  `;
  const body = `
    <p>${(0, _lodash.escape)(corruptionDetectedMessage)}</p>
    <p>${copyAndRestoreMessage}</p>
    <button disabled id="critical-error-button" class="critical-error__button-restore button btn-primary">
      ${restoreOrResetMessage}
    </button>
  `;
  const footer = supportLink ? `<p class="critical-error__footer small">${(0, _lodash.escape)((0, _translate.t)('unexpectedBehavior') ?? '')} <a
        href="${(0, _lodash.escape)(supportLink)}"
        class="critical-error__link"
        target="_blank"
        rel="noopener noreferrer">
          ${(0, _lodash.escape)((0, _translate.t)('sendBugReport') ?? '')}
      </a>
    </p>` : '';
  return (0, _errorUtils.getErrorHtmlBase)(`
    ${header}
    ${body}
    ${footer}
  `);
}
async function displayStateCorruptionError(container, port, err, hasBackup, currentLocale) {
  _loglevel.default.error(err);
  function handleRestoreClick() {
    // eslint-disable-next-line no-alert
    const theyAreSure = confirm((0, _translate.t)('stateCorruptionAreYouSure') ?? '');
    if (theyAreSure) {
      this.removeEventListener('click', handleRestoreClick);
      this.disabled = true;
      if (hasBackup) {
        this.innerText = (0, _translate.t)('stateCorruptionRestoringDatabase') ?? '';
      } else {
        this.innerText = (0, _translate.t)('stateCorruptionResettingDatabase') ?? '';
      }
      port.postMessage({
        data: {
          method: _stateCorruption.METHOD_REPAIR_DATABASE
        }
      });
    }
  }
  const html = await getStateCorruptionErrorHtml(_uiUtils.VAULT_RECOVERY_LINK, hasBackup, currentLocale, _uiUtils.SUPPORT_LINK);
  container.innerHTML = html;
  const button = container.querySelector('#critical-error-button');
  if (button) {
    button.addEventListener('click', handleRestoreClick);
    setTimeout(() => {
      button.disabled = false;
      // wait a while before enabling the button to try to prevent accidental
      // or rush clicks.
    }, 5000);
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\utils\\state-corruption-html.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\tags.ts", {"../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../selectors/metamask-notifications/metamask-notifications":"D:\\code\\v\\metamask-extension\\ui\\selectors\\metamask-notifications\\metamask-notifications.ts","../../selectors/nft":"D:\\code\\v\\metamask-extension\\ui\\selectors\\nft.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Cutils%5Ctags.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStartupTraceTags = getStartupTraceTags;
var _util = require("../../../app/scripts/lib/util");
var _metamask = require("../../ducks/metamask/metamask");
var _selectors = require("../../selectors");
var _metamaskNotifications = require("../../selectors/metamask-notifications/metamask-notifications");
var _nft = require("../../selectors/nft");
// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

/**
 * Generate the required tags for the UI startup trace.
 *
 * @param state - The current flattened UI state.
 * @returns The tags for the startup trace.
 */
function getStartupTraceTags(state) {
  var _pendingApprovals$;
  const uiType = (0, _util.getEnvironmentType)();
  const unlocked = (0, _metamask.getIsUnlocked)(state);
  const accountCount = (0, _selectors.getInternalAccounts)(state).length;
  const nftCount = (0, _nft.selectAllNftsFlat)(state).length;
  const notificationCount = (0, _metamaskNotifications.getMetamaskNotifications)(state).length;
  const tokenCount = (0, _selectors.selectAllTokensFlat)(state).length;
  const transactionCount = (0, _selectors.getTransactions)(state).length;
  const pendingApprovals = (0, _selectors.getPendingApprovals)(state);
  const firstApprovalType = pendingApprovals === null || pendingApprovals === void 0 || (_pendingApprovals$ = pendingApprovals[0]) === null || _pendingApprovals$ === void 0 ? void 0 : _pendingApprovals$.type;
  return {
    'wallet.account_count': accountCount,
    'wallet.nft_count': nftCount,
    'wallet.notification_count': notificationCount,
    'wallet.pending_approval': firstApprovalType,
    'wallet.token_count': tokenCount,
    'wallet.transaction_count': transactionCount,
    'wallet.unlocked': unlocked,
    'wallet.ui_type': uiType
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\utils\\tags.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\trust-signals.ts", {"../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../hooks/useTrustSignals":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTrustSignals.ts","../constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Cutils%5Ctrust-signals.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTrustSignalIcon = getTrustSignalIcon;
var _componentLibrary = require("../../components/component-library");
var _designSystem = require("../constants/design-system");
var _useTrustSignals = require("../../hooks/useTrustSignals");
/**
 * Get icon properties based on trust signal state, returns null if no icon is needed
 *
 * @param state - The trust signal display state
 * @returns Object containing icon name and color
 */
function getTrustSignalIcon(state) {
  if (!state) {
    return null;
  }
  switch (state) {
    case _useTrustSignals.TrustSignalDisplayState.Malicious:
      return {
        name: _componentLibrary.IconName.Danger,
        color: _designSystem.IconColor.errorDefault
      };
    case _useTrustSignals.TrustSignalDisplayState.Verified:
      return {
        name: _componentLibrary.IconName.VerifiedFilled,
        color: _designSystem.IconColor.infoDefault
      };
    case _useTrustSignals.TrustSignalDisplayState.Warning:
      // Warning state shows identicon, not a warning icon
      return null;
    case _useTrustSignals.TrustSignalDisplayState.Unknown:
      return {
        name: _componentLibrary.IconName.Question,
        color: undefined
      };
    case _useTrustSignals.TrustSignalDisplayState.Petname:
    case _useTrustSignals.TrustSignalDisplayState.Recognized:
      // These states use identicon, not an icon
      return null;
    default:
      return {
        name: _componentLibrary.IconName.Question,
        color: undefined
      };
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\utils\\trust-signals.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\webcam-utils.js", {"../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../shared/modules/browser-runtime.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\browser-runtime.utils.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Cutils%5Cwebcam-utils.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _app = require("../../../shared/constants/app");
var _util = require("../../../app/scripts/lib/util");
var _browserRuntime = require("../../../shared/modules/browser-runtime.utils");
// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

class WebcamUtils {
  static async checkStatus() {
    const isPopup = (0, _util.getEnvironmentType)() === _app.ENVIRONMENT_TYPE_POPUP;
    const isFirefoxOrBrave = (0, _browserRuntime.getBrowserName)() === (_app.PLATFORM_FIREFOX || _app.PLATFORM_BRAVE);
    const devices = await window.navigator.mediaDevices.enumerateDevices();
    const webcams = devices.filter(device => device.kind === 'videoinput');
    const hasWebcam = webcams.length > 0;
    // A non-empty-string label implies that the webcam has been granted permission, as
    // otherwise the label is kept blank to prevent fingerprinting
    const hasWebcamPermissions = webcams.some(webcam => webcam.label && webcam.label.length > 0);
    if (hasWebcam) {
      let environmentReady = true;
      if (isFirefoxOrBrave && isPopup || isPopup && !hasWebcamPermissions) {
        environmentReady = false;
      }
      return {
        permissions: hasWebcamPermissions,
        environmentReady
      };
    }
    const error = new Error('No webcam found');
    error.type = 'NO_WEBCAM_FOUND';
    throw error;
  }
}
var _default = exports.default = WebcamUtils;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\utils\\webcam-utils.js",}],
["D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\window.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chelpers%5Cutils%5Cwindow.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openWindow = void 0;
const openWindow = (url, target) => {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  window.open(url, target || '_blank', 'noopener');
};
exports.openWindow = openWindow;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\helpers\\utils\\window.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\accounts\\useAccountCreationOnNetworkChange.ts", {"../../../shared/constants/multichain/networks":"D:\\code\\v\\metamask-extension\\shared\\constants\\multichain\\networks.ts","../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","./useMultichainWalletSnapClient":"D:\\code\\v\\metamask-extension\\ui\\hooks\\accounts\\useMultichainWalletSnapClient.ts","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Caccounts%5CuseAccountCreationOnNetworkChange.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAccountCreationOnNetworkChange = void 0;
var _reactRedux = require("react-redux");
var _networks = require("../../../shared/constants/multichain/networks");
var _selectors = require("../../selectors");
var _useMultichainWalletSnapClient = require("./useMultichainWalletSnapClient");
const useAccountCreationOnNetworkChange = () => {
  const bitcoinWalletSnapClient = (0, _useMultichainWalletSnapClient.useMultichainWalletSnapClient)(_useMultichainWalletSnapClient.WalletClientType.Bitcoin);
  const solanaWalletSnapClient = (0, _useMultichainWalletSnapClient.useMultichainWalletSnapClient)(_useMultichainWalletSnapClient.WalletClientType.Solana);
  const accounts = (0, _reactRedux.useSelector)(_selectors.getMetaMaskAccountsOrdered);
  const createAccount = async chainId => {
    switch (chainId) {
      case _networks.MultichainNetworks.BITCOIN:
        await bitcoinWalletSnapClient.createAccount({
          scope: _networks.MultichainNetworks.BITCOIN
        });
        break;
      case _networks.MultichainNetworks.SOLANA:
        // TODO: We might wanna change this flow to let the use pick the SRP he wants to use.
        await solanaWalletSnapClient.createAccount({
          scope: _networks.MultichainNetworks.SOLANA
        });
        break;
      default:
        throw new Error(`Unsupported chainId: ${chainId}`);
    }
  };
  const hasAnyAccountsInNetwork = chainId => {
    return accounts.some(({
      scopes
    }) => scopes.includes(chainId));
  };
  return {
    createAccount,
    hasAnyAccountsInNetwork
  };
};
exports.useAccountCreationOnNetworkChange = useAccountCreationOnNetworkChange;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\accounts\\useAccountCreationOnNetworkChange.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\accounts\\useAccountsOperationsLoadingStates.ts", {"../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Caccounts%5CuseAccountsOperationsLoadingStates.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAccountsOperationsLoadingStates = void 0;
var _reactRedux = require("react-redux");
var _react = require("react");
var _useI18nContext = require("../useI18nContext");
var _actions = require("../../store/actions");
const useAccountsOperationsLoadingStates = () => {
  const t = (0, _useI18nContext.useI18nContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const isAccountTreeSyncingInProgress = (0, _reactRedux.useSelector)(state => state.metamask.isAccountTreeSyncingInProgress);

  // Hack: force the patches to be applied to the state
  // Somehow, the AccountTreeController state updates are picked up by the PatchStore,
  // but not by the React-Redux subscription.
  // This forces the React-Redux subscription to pick up the changes.
  (0, _react.useEffect)(() => {
    (0, _actions.forceUpdateMetamaskState)(dispatch);
  }, [isAccountTreeSyncingInProgress]);

  // Since areAnyOperationsLoading just comprises isAccountTreeSyncingInProgress,
  // we can use isAccountTreeSyncingInProgress directly instead of memoizing areAnyOperationsLoading.
  // We can use useMemo when we add more loading states in the future.
  const areAnyOperationsLoading = isAccountTreeSyncingInProgress;

  // We order by priority, the first one that matches will be shown
  const loadingMessage = (0, _react.useMemo)(() => {
    switch (true) {
      case isAccountTreeSyncingInProgress:
        return t('syncing');
      default:
        return undefined;
    }
  }, [isAccountTreeSyncingInProgress, t]);
  return {
    areAnyOperationsLoading,
    isAccountTreeSyncingInProgress,
    loadingMessage
  };
};
exports.useAccountsOperationsLoadingStates = useAccountsOperationsLoadingStates;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\accounts\\useAccountsOperationsLoadingStates.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\accounts\\useMultichainWalletSnapClient.ts", {"../../../shared/lib/accounts":"D:\\code\\v\\metamask-extension\\shared\\lib\\accounts\\index.ts","../../../shared/lib/accounts/bitcoin-wallet-snap":"D:\\code\\v\\metamask-extension\\shared\\lib\\accounts\\bitcoin-wallet-snap.ts","../../../shared/lib/accounts/solana-wallet-snap":"D:\\code\\v\\metamask-extension\\shared\\lib\\accounts\\solana-wallet-snap.ts","../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","@metamask/keyring-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-controller\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Caccounts%5CuseMultichainWalletSnapClient.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WalletClientType = exports.MultichainWalletSnapSender = exports.MultichainWalletSnapClient = exports.EVM_WALLET_TYPE = void 0;
exports.useMultichainWalletSnapClient = useMultichainWalletSnapClient;
exports.useMultichainWalletSnapSender = useMultichainWalletSnapSender;
var _keyringController = require("@metamask/keyring-controller");
var _snapsUtils = require("@metamask/snaps-utils");
var _react = require("react");
var _accounts = require("../../../shared/lib/accounts");
var _bitcoinWalletSnap = require("../../../shared/lib/accounts/bitcoin-wallet-snap");
var _solanaWalletSnap = require("../../../shared/lib/accounts/solana-wallet-snap");
var _actions = require("../../store/actions");
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
let WalletClientType = exports.WalletClientType = /*#__PURE__*/function (WalletClientType) {
  WalletClientType["Bitcoin"] = "bitcoin-wallet-snap";
  WalletClientType["Solana"] = "solana-wallet-snap";
  return WalletClientType;
}({});
const EVM_WALLET_TYPE = exports.EVM_WALLET_TYPE = 'evm';
const WALLET_SNAP_MAP = {
  [WalletClientType.Bitcoin]: {
    id: _bitcoinWalletSnap.BITCOIN_WALLET_SNAP_ID,
    name: _bitcoinWalletSnap.BITCOIN_WALLET_NAME
  },
  [WalletClientType.Solana]: {
    id: _solanaWalletSnap.SOLANA_WALLET_SNAP_ID,
    name: _solanaWalletSnap.SOLANA_WALLET_NAME
  }
};
class MultichainWalletSnapSender {
  constructor(snapId) {
    _defineProperty(this, "snapId", void 0);
    _defineProperty(this, "send", async request => {
      // We assume the caller of this module is aware of this. If we try to use this module
      // without having the pre-installed Snap, this will likely throw an error in
      // the `handleSnapRequest` action.
      return await (0, _actions.handleSnapRequest)({
        origin: 'metamask',
        snapId: this.snapId,
        handler: _snapsUtils.HandlerType.OnKeyringRequest,
        request
      });
    });
    this.snapId = snapId;
  }
}
exports.MultichainWalletSnapSender = MultichainWalletSnapSender;
function useMultichainWalletSnapSender(snapId) {
  const client = (0, _react.useMemo)(() => {
    return new MultichainWalletSnapSender(snapId);
  }, [snapId]);
  return client;
}
var _snapId = /*#__PURE__*/new WeakMap();
var _snapName = /*#__PURE__*/new WeakMap();
class MultichainWalletSnapClient {
  constructor(clientType) {
    _classPrivateFieldInitSpec(this, _snapId, void 0);
    _classPrivateFieldInitSpec(this, _snapName, void 0);
    const {
      id,
      name
    } = WALLET_SNAP_MAP[clientType];
    _classPrivateFieldSet(_snapId, this, id);
    _classPrivateFieldSet(_snapName, this, name);
    if (!_classPrivateFieldGet(_snapId, this)) {
      throw new Error(`Unsupported client type: ${clientType}`);
    }
  }
  getSnapId() {
    return _classPrivateFieldGet(_snapId, this);
  }
  getSnapName() {
    return _classPrivateFieldGet(_snapName, this);
  }
  async createAccount(options, internalOptions) {
    // This will trigger the Snap account creation flow (+ account renaming)
    return await (0, _actions.createSnapAccount)(_classPrivateFieldGet(_snapId, this), options, internalOptions);
  }
  async getNextAvailableAccountName(options) {
    return (0, _accounts.getNextAvailableSnapAccountName)(async () => (0, _actions.getNextAvailableAccountName)(_keyringController.KeyringTypes.snap), _classPrivateFieldGet(_snapId, this), options);
  }
}
exports.MultichainWalletSnapClient = MultichainWalletSnapClient;
function useMultichainWalletSnapClient(clientType) {
  const client = (0, _react.useMemo)(() => {
    return new MultichainWalletSnapClient(clientType);
  }, [clientType]);
  return client;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\accounts\\useMultichainWalletSnapClient.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\bridge\\useBridgeChainInfo.ts", {"../../../shared/constants/bridge":"D:\\code\\v\\metamask-extension\\shared\\constants\\bridge.ts","../../../shared/constants/common":"D:\\code\\v\\metamask-extension\\shared\\constants\\common.ts","../../../shared/constants/multichain/networks":"D:\\code\\v\\metamask-extension\\shared\\constants\\multichain\\networks.ts","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Cbridge%5CuseBridgeChainInfo.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useBridgeChainInfo;
var _transactionController = require("@metamask/transaction-controller");
var _bridgeController = require("@metamask/bridge-controller");
var _common = require("../../../shared/constants/common");
var _bridge = require("../../../shared/constants/bridge");
var _networks = require("../../../shared/constants/multichain/networks");
const getSourceAndDestChainIds = ({
  quote
}) => {
  const {
    srcChainId,
    destChainId
  } = quote;
  return {
    srcChainId,
    destChainId
  };
};
function useBridgeChainInfo({
  bridgeHistoryItem,
  srcTxMeta,
  nonEvmTransaction
}) {
  var _srcNativeAsset, _srcNativeAsset2, _destNativeAsset, _destNativeAsset2;
  const isEvmSwapOrBridge = (srcTxMeta === null || srcTxMeta === void 0 ? void 0 : srcTxMeta.type) && [_transactionController.TransactionType.bridge, _transactionController.TransactionType.swap].includes(srcTxMeta.type);
  if (!isEvmSwapOrBridge && !nonEvmTransaction) {
    return {
      srcNetwork: undefined,
      destNetwork: undefined
    };
  }
  const {
    srcChainId,
    destChainId
  } = bridgeHistoryItem ? getSourceAndDestChainIds(bridgeHistoryItem) : {
    srcChainId: (srcTxMeta === null || srcTxMeta === void 0 ? void 0 : srcTxMeta.chainId) ?? (nonEvmTransaction === null || nonEvmTransaction === void 0 ? void 0 : nonEvmTransaction.chain),
    destChainId: (srcTxMeta === null || srcTxMeta === void 0 ? void 0 : srcTxMeta.chainId) ?? (nonEvmTransaction === null || nonEvmTransaction === void 0 ? void 0 : nonEvmTransaction.chain)
  };
  if (!srcChainId || !destChainId) {
    return {
      srcNetwork: undefined,
      destNetwork: undefined
    };
  }

  // These utils throw an error if an unsupported chain id is passed in
  let srcChainIdInCaip, destChainIdInCaip, srcNativeAsset, destNativeAsset;
  try {
    srcChainIdInCaip = (0, _bridgeController.formatChainIdToCaip)(srcChainId);
    srcNativeAsset = (0, _bridgeController.getNativeAssetForChainId)(srcChainId);
    destChainIdInCaip = (0, _bridgeController.formatChainIdToCaip)(destChainId);
    destNativeAsset = (0, _bridgeController.getNativeAssetForChainId)(destChainId);
  } catch (error) {
    console.warn('Error getting XChain swaps network info', error);
    return {
      srcNetwork: undefined,
      destNetwork: undefined
    };
  }

  // Source chain info
  const normalizedSrcChainId = (0, _bridgeController.isSolanaChainId)(srcChainId) || (0, _bridgeController.isBitcoinChainId)(srcChainId) ? srcChainIdInCaip : (0, _bridgeController.formatChainIdToHex)(srcChainId);
  const commonSrcNetworkFields = {
    chainId: srcChainIdInCaip,
    name: _bridge.NETWORK_TO_SHORT_NETWORK_NAME_MAP[normalizedSrcChainId]
  };
  const srcNetwork = {
    ...commonSrcNetworkFields,
    ...((0, _bridgeController.isSolanaChainId)(srcChainIdInCaip) || (0, _bridgeController.isBitcoinChainId)(srcChainIdInCaip) ? {
      isEvm: false,
      nativeCurrency: (_srcNativeAsset = srcNativeAsset) === null || _srcNativeAsset === void 0 ? void 0 : _srcNativeAsset.assetId,
      blockExplorerUrl: (0, _bridgeController.isSolanaChainId)(srcChainIdInCaip) ? _networks.SOLANA_BLOCK_EXPLORER_URL : _networks.BITCOIN_BLOCK_EXPLORER_URL
    } : {
      defaultBlockExplorerUrlIndex: 0,
      blockExplorerUrls: [_common.CHAINID_DEFAULT_BLOCK_EXPLORER_URL_MAP[normalizedSrcChainId]],
      defaultRpcEndpointIndex: 0,
      rpcEndpoints: [],
      nativeCurrency: (_srcNativeAsset2 = srcNativeAsset) === null || _srcNativeAsset2 === void 0 ? void 0 : _srcNativeAsset2.symbol,
      isEvm: true
    })
  };

  // Dest chain info
  const normalizedDestChainId = (0, _bridgeController.isSolanaChainId)(destChainId) || (0, _bridgeController.isBitcoinChainId)(destChainId) ? destChainIdInCaip : (0, _bridgeController.formatChainIdToHex)(destChainId);
  const commonDestNetworkFields = {
    chainId: destChainIdInCaip,
    name: _bridge.NETWORK_TO_SHORT_NETWORK_NAME_MAP[normalizedDestChainId]
  };
  const destNetwork = {
    ...commonDestNetworkFields,
    ...((0, _bridgeController.isSolanaChainId)(destChainIdInCaip) || (0, _bridgeController.isBitcoinChainId)(destChainIdInCaip) ? {
      isEvm: false,
      nativeCurrency: (_destNativeAsset = destNativeAsset) === null || _destNativeAsset === void 0 ? void 0 : _destNativeAsset.assetId,
      blockExplorerUrl: (0, _bridgeController.isSolanaChainId)(destChainIdInCaip) ? _networks.SOLANA_BLOCK_EXPLORER_URL : _networks.BITCOIN_BLOCK_EXPLORER_URL
    } : {
      defaultBlockExplorerUrlIndex: 0,
      blockExplorerUrls: [_common.CHAINID_DEFAULT_BLOCK_EXPLORER_URL_MAP[normalizedDestChainId]],
      defaultRpcEndpointIndex: 0,
      rpcEndpoints: [],
      nativeCurrency: (_destNativeAsset2 = destNativeAsset) === null || _destNativeAsset2 === void 0 ? void 0 : _destNativeAsset2.symbol,
      isEvm: true
    })
  };
  return {
    srcNetwork,
    destNetwork
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\bridge\\useBridgeChainInfo.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\bridge\\useBridgeExchangeRates.ts", {"../../ducks/bridge/bridge":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\bridge.ts","../../ducks/bridge/selectors":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\selectors.ts","../../ducks/bridge/utils":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\utils.ts","../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../useMultichainSelector":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainSelector.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Cbridge%5CuseBridgeExchangeRates.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBridgeExchangeRates = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _selectors = require("../../ducks/bridge/selectors");
var _selectors2 = require("../../selectors");
var _metamask = require("../../ducks/metamask/metamask");
var _bridge = require("../../ducks/bridge/bridge");
var _utils = require("../../ducks/bridge/utils");
var _useMultichainSelector = require("../useMultichainSelector");
var _multichain = require("../../selectors/multichain");
const useBridgeExchangeRates = () => {
  const {
    srcTokenAddress,
    destTokenAddress
  } = (0, _reactRedux.useSelector)(_selectors.getQuoteRequest);
  const {
    activeQuote
  } = (0, _reactRedux.useSelector)(_selectors.getBridgeQuotes);
  const fromChainId = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainCurrentChainId);
  const toChain = (0, _reactRedux.useSelector)(_selectors.getToChain);
  const toChainId = toChain === null || toChain === void 0 ? void 0 : toChain.chainId;
  const isMetaMetricsEnabled = (0, _reactRedux.useSelector)(_selectors2.getParticipateInMetaMetrics);
  const dispatch = (0, _reactRedux.useDispatch)();
  const currency = (0, _reactRedux.useSelector)(_metamask.getCurrentCurrency);

  // Only use token address from quote as a fallback if there is no token address in the store
  const fromTokenAddressFromQuote = activeQuote ? activeQuote.quote.srcAsset.address : srcTokenAddress;
  const fromTokenFromStore = (0, _reactRedux.useSelector)(_selectors.getFromToken);
  const fromTokenAddress = (fromTokenFromStore === null || fromTokenFromStore === void 0 ? void 0 : fromTokenFromStore.address) ?? fromTokenAddressFromQuote;

  // Only use token address from quote as a fallback if there is no token address in the store
  const toTokenAddressFromQuote = activeQuote ? activeQuote.quote.destAsset.address : destTokenAddress;
  const toTokenFromStore = (0, _reactRedux.useSelector)(_selectors.getToToken);
  const toTokenAddress = (toTokenFromStore === null || toTokenFromStore === void 0 ? void 0 : toTokenFromStore.address) ?? toTokenAddressFromQuote;
  const marketData = (0, _reactRedux.useSelector)(_selectors2.getMarketData);
  const fromAbortController = (0, _react.useRef)(new AbortController());
  const toAbortController = (0, _react.useRef)(new AbortController());

  // Cleanup abort controller on unmount
  (0, _react.useEffect)(() => {
    return () => {
      var _fromAbortController$, _toAbortController$cu;
      (_fromAbortController$ = fromAbortController.current) === null || _fromAbortController$ === void 0 || _fromAbortController$.abort();
      fromAbortController.current = null;
      (_toAbortController$cu = toAbortController.current) === null || _toAbortController$cu === void 0 || _toAbortController$cu.abort();
      toAbortController.current = null;
    };
  }, []);

  // Fetch exchange rates for selected src token if not found in marketData
  (0, _react.useEffect)(() => {
    var _fromAbortController$2;
    (_fromAbortController$2 = fromAbortController.current) === null || _fromAbortController$2 === void 0 || _fromAbortController$2.abort();
    fromAbortController.current = new AbortController();
    if (fromChainId && fromTokenAddress) {
      const exchangeRate = (0, _utils.exchangeRateFromMarketData)(fromChainId, fromTokenAddress, marketData);
      if (!exchangeRate) {
        dispatch((0, _bridge.setSrcTokenExchangeRates)({
          chainId: fromChainId,
          tokenAddress: fromTokenAddress,
          currency,
          signal: fromAbortController.current.signal
        }));
      }
    }
  }, [currency, dispatch, fromChainId, fromTokenAddress, marketData]);

  // Fetch exchange rates for selected dest token if not found in marketData
  (0, _react.useEffect)(() => {
    var _toAbortController$cu2;
    (_toAbortController$cu2 = toAbortController.current) === null || _toAbortController$cu2 === void 0 || _toAbortController$cu2.abort();
    toAbortController.current = new AbortController();
    if (toChainId && toTokenAddress) {
      const exchangeRate = (0, _utils.exchangeRateFromMarketData)(toChainId, toTokenAddress, marketData);
      if (!exchangeRate) {
        dispatch((0, _bridge.setDestTokenExchangeRates)({
          chainId: toChainId,
          tokenAddress: toTokenAddress,
          currency,
          signal: toAbortController.current.signal
        }));
        // If the selected currency is not USD, fetch the USD exchange rate for metrics
        if (isMetaMetricsEnabled && currency !== 'usd') {
          dispatch((0, _bridge.setDestTokenUsdExchangeRates)({
            chainId: toChainId,
            tokenAddress: toTokenAddress,
            currency: 'usd',
            signal: toAbortController.current.signal
          }));
        }
      }
    }
  }, [currency, dispatch, isMetaMetricsEnabled, marketData, toChainId, toTokenAddress]);
};
exports.useBridgeExchangeRates = useBridgeExchangeRates;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\bridge\\useBridgeExchangeRates.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\bridge\\useBridgeQueryParams.ts", {"../../../shared/lib/asset-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\asset-utils.ts","../../../shared/lib/deep-links/routes/swap":"D:\\code\\v\\metamask-extension\\shared\\lib\\deep-links\\routes\\swap.ts","../../../shared/lib/transactions-controller-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\transactions-controller-utils.js","../../ducks/bridge/actions":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\actions.ts","../../ducks/bridge/selectors":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\selectors.ts","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Cbridge%5CuseBridgeQueryParams.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBridgeQueryParams = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _utils = require("@metamask/utils");
var _bridgeController = require("@metamask/bridge-controller");
var _assetUtils = require("../../../shared/lib/asset-utils");
var _swap = require("../../../shared/lib/deep-links/routes/swap");
var _transactionsControllerUtils = require("../../../shared/lib/transactions-controller-utils");
var _actions = require("../../ducks/bridge/actions");
var _selectors = require("../../ducks/bridge/selectors");
const parseAsset = assetId => {
  if (!assetId) {
    return null;
  }
  try {
    const caipAssetId = _utils.CaipAssetTypeStruct.create(assetId);
    const {
      chainId,
      assetReference
    } = (0, _utils.parseCaipAssetType)(caipAssetId);
    return {
      chainId,
      assetReference,
      assetId: caipAssetId
    };
  } catch {
    return null;
  }
};
const fetchAssetMetadata = async (signal, fromAsset, toAsset) => {
  const assetIds = [];
  if (fromAsset) {
    assetIds.push(fromAsset);
  }
  if (toAsset) {
    assetIds.push(toAsset);
  }
  if (assetIds.length === 0) {
    return null;
  }
  try {
    return await (0, _assetUtils.fetchAssetMetadataForAssetIds)(assetIds, signal);
  } catch {
    return null;
  }
};

/**
 * This hook is used to set the bridge fromChain, fromToken, fromTokenInputValue,
 * toChainId, and toToken from the URL search params.
 * It also clear the search params after setting the values.
 */
const useBridgeQueryParams = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const fromChains = (0, _reactRedux.useSelector)(_selectors.getFromChains);
  const fromChain = (0, _reactRedux.useSelector)(_selectors.getFromChain);
  const fromToken = (0, _reactRedux.useSelector)(_selectors.getFromToken);
  const selectedAccount = (0, _reactRedux.useSelector)(_selectors.getFromAccount);
  const abortController = (0, _react.useRef)(new AbortController());
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const history = (0, _reactRouterDom.useHistory)();

  // Parse CAIP asset data
  const searchParams = (0, _react.useMemo)(() => new URLSearchParams(search), [search]);

  // Clean up URL parameters
  const cleanupUrlParams = (0, _react.useCallback)(paramsToRemove => {
    const updatedSearchParams = new URLSearchParams(search);
    paramsToRemove.forEach(param => {
      if (updatedSearchParams.get(param)) {
        updatedSearchParams.delete(param);
      }
    });
    history.replace({
      search: updatedSearchParams.toString()
    });
  }, [search, history]);
  const [parsedFromAssetId, setParsedFromAssetId] = (0, _react.useState)(null);
  const [parsedToAssetId, setParsedToAssetId] = (0, _react.useState)(null);
  const [parsedAmount, setParsedAmount] = (0, _react.useState)(null);

  // Cleanup abort controller on unmount
  (0, _react.useEffect)(() => {
    return () => {
      abortController.current.abort();
    };
  }, []);
  const [assetMetadataByAssetId, setAssetMetadataByAssetId] = (0, _react.useState)(null);

  // Only update parsed values and fetch metadata if the search params
  // are set (once) to prevent infinite re-renders
  (0, _react.useEffect)(() => {
    const searchParamsFrom = parseAsset(searchParams.get(_swap.BridgeQueryParams.FROM));
    const searchParamsTo = parseAsset(searchParams.get(_swap.BridgeQueryParams.TO));
    const searchParamsAmount = searchParams.get(_swap.BridgeQueryParams.AMOUNT);
    if (searchParamsFrom || searchParamsTo || searchParamsAmount) {
      setParsedToAssetId(searchParamsTo);
      setParsedFromAssetId(searchParamsFrom);
      if (searchParamsAmount) {
        setParsedAmount(searchParamsAmount);
      }
      cleanupUrlParams([_swap.BridgeQueryParams.FROM, _swap.BridgeQueryParams.TO, _swap.BridgeQueryParams.AMOUNT]);

      // Fetch asset metadata for both tokens in 1 call
      if (searchParamsTo !== null && searchParamsTo !== void 0 && searchParamsTo.assetId || searchParamsFrom !== null && searchParamsFrom !== void 0 && searchParamsFrom.assetId) {
        abortController.current.abort();
        abortController.current = new AbortController();
        fetchAssetMetadata(abortController.current.signal, searchParamsFrom === null || searchParamsFrom === void 0 ? void 0 : searchParamsFrom.assetId, searchParamsTo === null || searchParamsTo === void 0 ? void 0 : searchParamsTo.assetId).then(result => {
          setAssetMetadataByAssetId(result);
        });
      }
    }
  }, [searchParams]);

  // Set fromChain and fromToken
  const setFromChainAndToken = (0, _react.useCallback)((fromTokenMetadata, fromAsset, networks, account, network) => {
    const {
      chainId: assetChainId
    } = fromAsset;
    if (fromTokenMetadata) {
      const {
        chainId,
        assetReference
      } = (0, _utils.parseCaipAssetType)(fromTokenMetadata.assetId);
      const nativeAsset = (0, _bridgeController.getNativeAssetForChainId)(chainId);
      // TODO remove this after v36.0.0 bridge-controller bump
      const isNativeReference = nativeAsset === null || nativeAsset === void 0 ? void 0 : nativeAsset.assetId.includes(assetReference);
      const token = {
        ...fromTokenMetadata,
        chainId,
        address: isNativeReference || (0, _bridgeController.isNativeAddress)(assetReference) ? (nativeAsset === null || nativeAsset === void 0 ? void 0 : nativeAsset.address) ?? '' : assetReference
      };
      // If asset's chain is the same as fromChain, only set the fromToken
      if (network && assetChainId === (0, _bridgeController.formatChainIdToCaip)(network.chainId)) {
        dispatch((0, _actions.setFromToken)(token));
      } else {
        // Find the chain matching the srcAsset's chainId
        const targetChain = networks.find(chain => (0, _bridgeController.formatChainIdToCaip)(chain.chainId) === assetChainId);
        if (targetChain) {
          dispatch((0, _actions.setFromChain)({
            networkConfig: targetChain,
            selectedAccount: account,
            token
          }));
        }
      }
    }
  }, []);
  const setToChainAndToken = (0, _react.useCallback)(async toTokenMetadata => {
    const {
      chainId,
      assetReference
    } = (0, _utils.parseCaipAssetType)(toTokenMetadata.assetId);
    dispatch((0, _actions.setToToken)({
      ...toTokenMetadata,
      chainId,
      address: assetReference
    }));
    // Clear parsed to asset ID after successful processing
    setParsedToAssetId(null);
  }, []);

  // Main effect to orchestrate the parameter processing
  (0, _react.useEffect)(() => {
    if (!parsedFromAssetId || !assetMetadataByAssetId || !fromChains.length) {
      return;
    }
    const fromTokenMetadata = (assetMetadataByAssetId === null || assetMetadataByAssetId === void 0 ? void 0 : assetMetadataByAssetId[parsedFromAssetId.assetId]) ?? (assetMetadataByAssetId === null || assetMetadataByAssetId === void 0 ? void 0 : assetMetadataByAssetId[parsedFromAssetId.assetId.toLowerCase()]);

    // Process from chain/token first
    setFromChainAndToken(fromTokenMetadata, parsedFromAssetId, fromChains, selectedAccount, fromChain);
  }, [assetMetadataByAssetId, parsedFromAssetId, fromChains, fromChain, selectedAccount]);

  // Set toChainId and toToken
  (0, _react.useEffect)(() => {
    if (!parsedToAssetId) {
      return;
    }
    const toTokenMetadata = (assetMetadataByAssetId === null || assetMetadataByAssetId === void 0 ? void 0 : assetMetadataByAssetId[parsedToAssetId.assetId]) ?? (assetMetadataByAssetId === null || assetMetadataByAssetId === void 0 ? void 0 : assetMetadataByAssetId[parsedToAssetId.assetId.toLowerCase()]);
    if (toTokenMetadata) {
      setToChainAndToken(toTokenMetadata);
    }
  }, [parsedToAssetId, assetMetadataByAssetId]);

  // Process amount after fromToken is set
  (0, _react.useEffect)(() => {
    var _fromToken$assetId;
    if (parsedFromAssetId && fromToken && ((_fromToken$assetId = fromToken.assetId) === null || _fromToken$assetId === void 0 ? void 0 : _fromToken$assetId.toLowerCase()) === parsedFromAssetId.assetId.toLowerCase()) {
      // Clear parsed from asset ID after successful processing
      setParsedFromAssetId(null);
      if (parsedAmount) {
        dispatch((0, _actions.setFromTokenInputValue)((0, _transactionsControllerUtils.calcTokenAmount)(parsedAmount, fromToken.decimals).toFixed(fromToken.decimals)));
        setParsedAmount(null);
      }
    }
  }, [parsedAmount, parsedFromAssetId, fromToken]);

  // Set src token balance after url params are applied
  // This effect runs on each load regardless of the url params
  (0, _react.useEffect)(() => {
    if (
    // Wait for url params to be applied
    !parsedFromAssetId && !searchParams.get(_swap.BridgeQueryParams.FROM) && fromToken &&
    // Wait for network to be changed if needed
    !(0, _bridgeController.isCrossChain)(fromToken.chainId, fromChain === null || fromChain === void 0 ? void 0 : fromChain.chainId) && selectedAccount) {
      dispatch((0, _actions.setEVMSrcTokenBalance)(fromToken, selectedAccount.address));
      dispatch((0, _actions.setEVMSrcNativeBalance)({
        selectedAddress: selectedAccount.address,
        chainId: fromToken.chainId
      }));
    }
  }, [parsedFromAssetId, selectedAccount, fromToken, fromChain, searchParams]);
};
exports.useBridgeQueryParams = useBridgeQueryParams;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\bridge\\useBridgeQueryParams.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\bridge\\useBridgeTxHistoryData.ts", {"../../../shared/lib/bridge-status/utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\bridge-status\\utils.ts","../../ducks/bridge-status/selectors":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge-status\\selectors.ts","../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Cbridge%5CuseBridgeTxHistoryData.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FINAL_NON_CONFIRMED_STATUSES = void 0;
exports.useBridgeTxHistoryData = useBridgeTxHistoryData;
var _reactRedux = require("react-redux");
var _transactionController = require("@metamask/transaction-controller");
var _reactRouterDom = require("react-router-dom");
var _bridgeController = require("@metamask/bridge-controller");
var _utils = require("../../../shared/lib/bridge-status/utils");
var _routes = require("../../helpers/constants/routes");
var _selectors = require("../../ducks/bridge-status/selectors");
const FINAL_NON_CONFIRMED_STATUSES = exports.FINAL_NON_CONFIRMED_STATUSES = [_transactionController.TransactionStatus.failed, _transactionController.TransactionStatus.dropped, _transactionController.TransactionStatus.rejected];
function useBridgeTxHistoryData({
  transactionGroup,
  isEarliestNonce
}) {
  const history = (0, _reactRouterDom.useHistory)();
  const txMeta = transactionGroup.initialTransaction;
  const srcTxMetaId = txMeta.id;
  const bridgeHistoryItem = (0, _reactRedux.useSelector)(state => (0, _selectors.selectBridgeHistoryItemForTxMetaId)(state, srcTxMetaId));
  const isBridgeFailed = bridgeHistoryItem ? (bridgeHistoryItem === null || bridgeHistoryItem === void 0 ? void 0 : bridgeHistoryItem.status.status) === _bridgeController.StatusTypes.FAILED : null;
  const showBridgeTxDetails = FINAL_NON_CONFIRMED_STATUSES.includes(txMeta.status) ? undefined : () => {
    history.push({
      pathname: `${_routes.CROSS_CHAIN_SWAP_TX_DETAILS_ROUTE}/${srcTxMetaId}`,
      state: {
        transactionGroup,
        isEarliestNonce
      }
    });
  };
  return {
    bridgeTxHistoryItem: bridgeHistoryItem,
    // By complete, this means BOTH source and dest tx are confirmed
    isBridgeComplete: bridgeHistoryItem ? (0, _utils.isBridgeComplete)(bridgeHistoryItem) : null,
    isBridgeFailed,
    showBridgeTxDetails
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\bridge\\useBridgeTxHistoryData.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\bridge\\useBridging.ts", {"../../../shared/constants/bridge":"D:\\code\\v\\metamask-extension\\shared\\constants\\bridge.ts","../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../shared/lib/asset-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\asset-utils.ts","../../../shared/lib/deep-links/routes/swap":"D:\\code\\v\\metamask-extension\\shared\\lib\\deep-links\\routes\\swap.ts","../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../../ducks/bridge/actions":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\actions.ts","../../ducks/bridge/selectors":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\selectors.ts","../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Cbridge%5CuseBridging.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _bridgeController = require("@metamask/bridge-controller");
var _actions = require("../../ducks/bridge/actions");
var _selectors = require("../../selectors");
var _metametrics = require("../../contexts/metametrics");
var _metametrics2 = require("../../../shared/constants/metametrics");
var _routes = require("../../helpers/constants/routes");
var _swap = require("../../../shared/lib/deep-links/routes/swap");
var _trace = require("../../../shared/lib/trace");
var _assetUtils = require("../../../shared/lib/asset-utils");
var _bridge = require("../../../shared/constants/bridge");
var _selectors2 = require("../../ducks/bridge/selectors");
var _multichain = require("../../selectors/multichain");
var _network = require("../../../shared/constants/network");
const useBridging = () => {
  const history = (0, _reactRouterDom.useHistory)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const metaMetricsId = (0, _reactRedux.useSelector)(_selectors.getMetaMetricsId);
  const isMetaMetricsEnabled = (0, _reactRedux.useSelector)(_selectors.getParticipateInMetaMetrics);
  const isMarketingEnabled = (0, _reactRedux.useSelector)(_selectors.getDataCollectionForMarketing);
  const lastSelectedChainId = (0, _reactRedux.useSelector)(_selectors2.getLastSelectedChainId);
  const providerConfig = (0, _reactRedux.useSelector)(_multichain.getMultichainProviderConfig);
  const openBridgeExperience = (0, _react.useCallback)((location, srcToken) => {
    // If srcToken is a bridge token, use its assetId
    let srcAssetIdToUse = srcToken !== null && srcToken !== void 0 && srcToken.chainId && _bridge.ALL_ALLOWED_BRIDGE_CHAIN_IDS.includes(srcToken.chainId) ? (0, _assetUtils.toAssetId)(srcToken.address, (0, _bridgeController.formatChainIdToCaip)(srcToken.chainId)) : undefined;

    /* If srcToken is not in a supported bridge chain, or is not specified
     * and the selected network filter is not active, set the srcAssetId to
     * a supported bridge native asset
     *
     * If an unsupported network is selected in the network filter, fall back to MAINNET
     *
     * default fromChain: srctoken.chainId > lastSelectedId > MAINNET
     */
    const targetChainId = _bridge.ALL_ALLOWED_BRIDGE_CHAIN_IDS.includes(lastSelectedChainId) ? lastSelectedChainId : _network.CHAIN_IDS.MAINNET;
    if (!srcAssetIdToUse && targetChainId !== (providerConfig === null || providerConfig === void 0 ? void 0 : providerConfig.chainId)) {
      var _getNativeAssetForCha;
      srcAssetIdToUse = (_getNativeAssetForCha = (0, _bridgeController.getNativeAssetForChainId)(targetChainId)) === null || _getNativeAssetForCha === void 0 ? void 0 : _getNativeAssetForCha.assetId;
    }
    (0, _trace.trace)({
      name: _trace.TraceName.SwapViewLoaded,
      startTime: Date.now()
    });
    trackEvent({
      event: _metametrics2.MetaMetricsEventName.SwapLinkClicked,
      category: _metametrics2.MetaMetricsEventCategory.Navigation,
      properties: {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        token_symbol: (srcToken === null || srcToken === void 0 ? void 0 : srcToken.symbol) ?? '',
        location,
        text: 'Swap',
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        chain_id: (srcToken === null || srcToken === void 0 ? void 0 : srcToken.chainId) ?? lastSelectedChainId
      }
    });
    dispatch((0, _actions.trackUnifiedSwapBridgeEvent)(_bridgeController.UnifiedSwapBridgeEventName.ButtonClicked, {
      location: location,
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      token_symbol_source: (srcToken === null || srcToken === void 0 ? void 0 : srcToken.symbol) ?? 'ETH',
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      token_symbol_destination: ''
    }));
    dispatch((0, _actions.resetInputFields)());
    let url = `${_routes.CROSS_CHAIN_SWAP_ROUTE}${_routes.PREPARE_SWAP_ROUTE}`;
    url += '?';
    if (srcAssetIdToUse) {
      url += `${_swap.BridgeQueryParams.FROM}=${srcAssetIdToUse}`;
    }
    if (location === _metametrics2.MetaMetricsSwapsEventSource.TransactionShield) {
      url += `${srcAssetIdToUse ? '&' : ''}isFromTransactionShield=true`;
    }
    history.push(url);
  }, [history, metaMetricsId, trackEvent, isMetaMetricsEnabled, isMarketingEnabled, lastSelectedChainId, providerConfig === null || providerConfig === void 0 ? void 0 : providerConfig.chainId]);
  return {
    openBridgeExperience
  };
};
var _default = exports.default = useBridging;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\bridge\\useBridging.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\bridge\\useCountdownTimer.ts", {"../../ducks/bridge/selectors":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\selectors.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Cbridge%5CuseCountdownTimer.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCountdownTimer = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _selectors = require("../../ducks/bridge/selectors");
const STEP = 1000;
/**
 * Custom hook that provides a countdown timer based on the last fetched quotes timestamp.
 *
 * This hook calculates the remaining time until the next refresh interval and updates every second.
 *
 * @returns The remaining time in seconds.
 */
const useCountdownTimer = () => {
  const {
    quotesLastFetchedMs
  } = (0, _reactRedux.useSelector)(_selectors.getBridgeQuotes);
  const refreshRate = (0, _reactRedux.useSelector)(_selectors.getQuoteRefreshRate);
  const [timeRemaining, setTimeRemaining] = (0, _react.useState)(refreshRate);
  const timeRemainingRef = (0, _react.useRef)(refreshRate);

  // Update ref whenever timeRemaining changes
  (0, _react.useEffect)(() => {
    timeRemainingRef.current = timeRemaining;
  }, [timeRemaining]);
  (0, _react.useEffect)(() => {
    if (quotesLastFetchedMs) {
      setTimeRemaining(refreshRate - (Date.now() - quotesLastFetchedMs) + STEP);
    }
  }, [quotesLastFetchedMs, refreshRate]);
  (0, _react.useEffect)(() => {
    const interval = setInterval(() => {
      setTimeRemaining(Math.max(0, timeRemainingRef.current - STEP));
    }, STEP);
    return () => clearInterval(interval);
  }, []);
  return Math.floor(timeRemaining / 1000);
};
exports.useCountdownTimer = useCountdownTimer;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\bridge\\useCountdownTimer.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\bridge\\useIsTxSubmittable.ts", {"../../ducks/bridge/selectors":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\selectors.ts","../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../useMultichainSelector":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainSelector.ts","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Cbridge%5CuseIsTxSubmittable.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsTxSubmittable = void 0;
var _reactRedux = require("react-redux");
var _selectors = require("../../ducks/bridge/selectors");
var _multichain = require("../../selectors/multichain");
var _useMultichainSelector = require("../useMultichainSelector");
const useIsTxSubmittable = () => {
  const fromToken = (0, _reactRedux.useSelector)(_selectors.getFromToken);
  const toToken = (0, _reactRedux.useSelector)(_selectors.getToToken);
  const fromChainId = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainCurrentChainId);
  const fromAmount = (0, _reactRedux.useSelector)(_selectors.getFromAmount);
  const {
    activeQuote
  } = (0, _reactRedux.useSelector)(_selectors.getBridgeQuotes);
  const {
    isInsufficientBalance,
    isInsufficientGasBalance,
    isInsufficientGasForQuote,
    isTxAlertPresent
  } = (0, _reactRedux.useSelector)(_selectors.getValidationErrors);
  return Boolean(fromToken && toToken && fromChainId && fromAmount && activeQuote && !isInsufficientBalance && !isInsufficientGasBalance && !isInsufficientGasForQuote && !isTxAlertPresent);
};
exports.useIsTxSubmittable = useIsTxSubmittable;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\bridge\\useIsTxSubmittable.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\bridge\\useQuoteFetchEvents.ts", {"../../ducks/bridge/actions":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\actions.ts","../../ducks/bridge/selectors":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\selectors.ts","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Cbridge%5CuseQuoteFetchEvents.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useQuoteFetchEvents = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _bridgeController = require("@metamask/bridge-controller");
var _selectors = require("../../ducks/bridge/selectors");
var _actions = require("../../ducks/bridge/actions");
/* eslint-disable camelcase */

// This hook is used to track cross chain swaps events related to quote-fetching
const useQuoteFetchEvents = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    isLoading,
    quotesRefreshCount,
    quoteFetchError,
    activeQuote,
    recommendedQuote
  } = (0, _reactRedux.useSelector)(_selectors.getBridgeQuotes);
  const {
    insufficientBal
  } = (0, _reactRedux.useSelector)(_selectors.getQuoteRequest);
  const validationErrors = (0, _reactRedux.useSelector)(_selectors.getValidationErrors);
  const warnings = (0, _react.useMemo)(() => {
    const {
      isEstimatedReturnLow,
      isNoQuotesAvailable,
      isInsufficientGasBalance,
      isInsufficientGasForQuote,
      isInsufficientBalance
    } = validationErrors;
    const latestWarnings = [];
    isEstimatedReturnLow && latestWarnings.push('low_return');
    isNoQuotesAvailable && latestWarnings.push('no_quotes');
    isInsufficientGasBalance && latestWarnings.push('insufficient_gas_balance');
    isInsufficientGasForQuote && latestWarnings.push('insufficient_gas_for_selected_quote');
    isInsufficientBalance && latestWarnings.push('insufficient_balance');
    return latestWarnings;
  }, [validationErrors]);

  // Emitted each time quotes are fetched successfully
  (0, _react.useEffect)(() => {
    if (!isLoading && quotesRefreshCount > 0 && !quoteFetchError) {
      var _activeQuote$quote, _activeQuote$quote2, _activeQuote$gasFee, _activeQuote$toTokenA, _activeQuote$quote$pr;
      dispatch((0, _actions.trackUnifiedSwapBridgeEvent)(_bridgeController.UnifiedSwapBridgeEventName.QuotesReceived, {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        can_submit: !insufficientBal,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        gas_included: Boolean(activeQuote === null || activeQuote === void 0 || (_activeQuote$quote = activeQuote.quote) === null || _activeQuote$quote === void 0 ? void 0 : _activeQuote$quote.gasIncluded),
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        gas_included_7702: Boolean(activeQuote === null || activeQuote === void 0 || (_activeQuote$quote2 = activeQuote.quote) === null || _activeQuote$quote2 === void 0 ? void 0 : _activeQuote$quote2.gasIncluded7702),
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        quoted_time_minutes: activeQuote !== null && activeQuote !== void 0 && activeQuote.estimatedProcessingTimeInSeconds ? activeQuote.estimatedProcessingTimeInSeconds / 60 : 0,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        usd_quoted_gas: Number((activeQuote === null || activeQuote === void 0 || (_activeQuote$gasFee = activeQuote.gasFee) === null || _activeQuote$gasFee === void 0 || (_activeQuote$gasFee = _activeQuote$gasFee.effective) === null || _activeQuote$gasFee === void 0 ? void 0 : _activeQuote$gasFee.usd) ?? 0),
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        usd_quoted_return: Number((activeQuote === null || activeQuote === void 0 || (_activeQuote$toTokenA = activeQuote.toTokenAmount) === null || _activeQuote$toTokenA === void 0 ? void 0 : _activeQuote$toTokenA.usd) ?? 0),
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        best_quote_provider: recommendedQuote ? (0, _bridgeController.formatProviderLabel)(recommendedQuote.quote) : undefined,
        provider: activeQuote ? (0, _bridgeController.formatProviderLabel)(activeQuote.quote) : '_',
        warnings,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        price_impact: Number((activeQuote === null || activeQuote === void 0 || (_activeQuote$quote$pr = activeQuote.quote.priceData) === null || _activeQuote$quote$pr === void 0 ? void 0 : _activeQuote$quote$pr.priceImpact) ?? 0)
      }));
    }
  }, [quotesRefreshCount]);
};
exports.useQuoteFetchEvents = useQuoteFetchEvents;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\bridge\\useQuoteFetchEvents.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\bridge\\useSmartSlippage.ts", {"../../ducks/bridge/actions":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\actions.ts","../../pages/bridge/utils/slippage-service":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\utils\\slippage-service.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Cbridge%5CuseSmartSlippage.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSmartSlippage = useSmartSlippage;
var _react = require("react");
var _reactRedux = require("react-redux");
var _slippageService = require("../../pages/bridge/utils/slippage-service");
var _actions = require("../../ducks/bridge/actions");
// This hook doesn't return anything as it only dispatches slippage updates
// The slippage value can be accessed via getSlippage selector

/**
 * Custom hook that manages smart slippage defaults
 *
 * Features:
 * - Sets intelligent defaults based on token types and chains
 * - Updates automatically when tokens/chains change
 * - Supports Solana AUTO mode (undefined)
 *
 * @param options0
 * @param options0.fromChain
 * @param options0.toChain
 * @param options0.fromToken
 * @param options0.toToken
 * @param options0.isSwap
 */
function useSmartSlippage({
  fromChain,
  toChain,
  fromToken,
  toToken,
  isSwap
}) {
  const dispatch = (0, _reactRedux.useDispatch)();

  // Calculate the appropriate slippage for current context
  const calculateCurrentSlippage = (0, _react.useCallback)(() => {
    const context = {
      fromChain,
      toChain,
      fromToken,
      toToken,
      isSwap
    };
    const slippage = (0, _slippageService.calculateSlippage)(context);

    // Log the reason in development
    if ("development" === 'development') {
      const reason = (0, _slippageService.getSlippageReason)(context);
      console.log(`[useSmartSlippage] Slippage calculated: ${slippage ?? 'AUTO'}% - ${reason}`);
    }
    return slippage;
  }, [fromChain, toChain, fromToken, toToken, isSwap]);

  // Update slippage when context changes
  (0, _react.useEffect)(() => {
    const newSlippage = calculateCurrentSlippage();
    dispatch((0, _actions.setSlippage)(newSlippage));
  }, [fromChain, toChain, fromToken, toToken, isSwap, calculateCurrentSlippage, dispatch]);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\bridge\\useSmartSlippage.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\bridge\\useTokenAlerts.ts", {"../../../shared/modules/bridge-utils/security-alerts-api.util":"D:\\code\\v\\metamask-extension\\shared\\modules\\bridge-utils\\security-alerts-api.util.ts","../../ducks/bridge/selectors":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\selectors.ts","../useAsync":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAsync.ts","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Cbridge%5CuseTokenAlerts.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTokenAlerts = exports.default = void 0;
var _reactRedux = require("react-redux");
var _bridgeController = require("@metamask/bridge-controller");
var _selectors = require("../../ducks/bridge/selectors");
var _securityAlertsApi = require("../../../shared/modules/bridge-utils/security-alerts-api.util");
var _useAsync = require("../useAsync");
const useTokenAlerts = () => {
  const fromToken = (0, _reactRedux.useSelector)(_selectors.getFromToken);
  const fromChain = (0, _reactRedux.useSelector)(_selectors.getFromChain);
  const toToken = (0, _reactRedux.useSelector)(_selectors.getToToken);
  const toChain = (0, _reactRedux.useSelector)(_selectors.getToChain);
  const {
    value: tokenAlert
  } = (0, _useAsync.useAsyncResult)(async () => {
    if (fromToken && fromChain && toToken && toChain && !(0, _bridgeController.isNativeAddress)(toToken.address)) {
      const chainName = (0, _securityAlertsApi.convertChainIdToBlockAidChainName)(toChain === null || toChain === void 0 ? void 0 : toChain.chainId);
      if (chainName) {
        return await (0, _securityAlertsApi.fetchTokenAlert)(chainName, (0, _bridgeController.formatAddressToCaipReference)(toToken.address));
      }
    }
    return null;
  }, [toToken === null || toToken === void 0 ? void 0 : toToken.address, toChain === null || toChain === void 0 ? void 0 : toChain.chainId]);
  return {
    tokenAlert
  };
};
exports.useTokenAlerts = useTokenAlerts;
var _default = exports.default = useTokenAlerts;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\bridge\\useTokenAlerts.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\bridge\\useTokensWithFiltering.ts", {"../../../shared/constants/bridge":"D:\\code\\v\\metamask-extension\\shared\\constants\\bridge.ts","../../../shared/constants/multichain/networks":"D:\\code\\v\\metamask-extension\\shared\\constants\\multichain\\networks.ts","../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../shared/constants/time":"D:\\code\\v\\metamask-extension\\shared\\constants\\time.ts","../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../shared/lib/asset-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\asset-utils.ts","../../../shared/lib/fetch-with-cache":"D:\\code\\v\\metamask-extension\\shared\\lib\\fetch-with-cache.ts","../../ducks/bridge/selectors":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\selectors.ts","../../pages/swaps/swaps.util":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\swaps.util.ts","../useAsync":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAsync.ts","../useMultichainBalances":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainBalances.ts","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Cbridge%5CuseTokensWithFiltering.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTokensWithFiltering = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _bridgeController = require("@metamask/bridge-controller");
var _transaction = require("../../../shared/constants/transaction");
var _network = require("../../../shared/constants/network");
var _useMultichainBalances = require("../useMultichainBalances");
var _useAsync = require("../useAsync");
var _swaps = require("../../pages/swaps/swaps.util");
var _time = require("../../../shared/constants/time");
var _selectors = require("../../ducks/bridge/selectors");
var _fetchWithCache = _interopRequireDefault(require("../../../shared/lib/fetch-with-cache"));
var _bridge = require("../../../shared/constants/bridge");
var _assetUtils = require("../../../shared/lib/asset-utils");
var _networks = require("../../../shared/constants/multichain/networks");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// This transforms the token object from the bridge-api into the format expected by the AssetPicker
const buildTokenData = (chainId, token) => {
  if (!chainId || !token) {
    return undefined;
  }
  // Only tokens on the active chain are processed here here
  const sharedFields = {
    ...token,
    chainId: (0, _bridgeController.isSolanaChainId)(chainId) || (0, _bridgeController.isBitcoinChainId)(chainId) ? (0, _bridgeController.formatChainIdToCaip)(chainId) : (0, _bridgeController.formatChainIdToHex)(chainId),
    assetId: 'assetId' in token ? token.assetId : (0, _assetUtils.toAssetId)(token.address, (0, _bridgeController.formatChainIdToCaip)(chainId))
  };
  if ((0, _bridgeController.isNativeAddress)(token.address)) {
    // Use MULTICHAIN_TOKEN_IMAGE_MAP for non-EVM chains
    const isNonEvm = (0, _bridgeController.isSolanaChainId)(chainId) || (0, _bridgeController.isBitcoinChainId)(chainId);
    const image = isNonEvm ? _networks.MULTICHAIN_TOKEN_IMAGE_MAP[sharedFields.chainId] : _network.CHAIN_ID_TOKEN_IMAGE_MAP[sharedFields.chainId];
    return {
      ...sharedFields,
      type: _transaction.AssetType.native,
      address: '',
      // Return empty string to match useMultichainBalances output
      image: image ?? (
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
      // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
      token.iconUrl || ('icon' in token ? token.icon : '') || ''),
      // Only unimported native assets are processed here so hardcode balance to 0
      balance: '0',
      string: '0'
    };
  }
  return {
    ...sharedFields,
    type: _transaction.AssetType.token,
    image: token.iconUrl ?? ('icon' in token ? token.icon : '') ?? '',
    // Only tokens with 0 balance are processed here so hardcode empty string
    balance: '',
    string: undefined
  };
};
/**
 * Returns a token list generator that filters and sorts tokens in this order
 * - matches search query
 * - tokens with highest to lowest balance in selected currency
 * - detected tokens (without balance)
 * - popularity
 * - all other tokens
 *
 * @param chainId - the selected src/dest chainId
 * @param selectedToken - the selected token to show at the top of the token list
 * @param tokenToExclude - a token to exclude from the token list, usually the token being swapped from
 * @param tokenToExclude.symbol
 * @param tokenToExclude.address
 * @param tokenToExclude.chainId
 * @param accountAddress - the account address used for balances
 */
const useTokensWithFiltering = (chainId, selectedToken, tokenToExclude, accountAddress) => {
  const topAssetsFromFeatureFlags = (0, _reactRedux.useSelector)(state => (0, _selectors.getTopAssetsFromFeatureFlags)(state, chainId));
  const {
    assetsWithBalance: multichainTokensWithBalance
  } = (0, _useMultichainBalances.useMultichainBalances)(accountAddress);
  const cachedTokens = (0, _reactRedux.useSelector)(state => state.metamask.tokensChainsCache);
  const cachedTokenList = (0, _react.useMemo)(() => {
    var _cachedTokens$hexChai;
    if (!chainId) {
      return undefined;
    }
    // For Bitcoin chains, we only support native asset
    if ((0, _bridgeController.isBitcoinChainId)(chainId)) {
      // Return native asset for Bitcoin chains
      const nativeAsset = (0, _bridgeController.getNativeAssetForChainId)(chainId);
      if (nativeAsset) {
        const key = nativeAsset.address ?? '';
        return {
          [key]: nativeAsset
        };
      }
      return undefined;
    }
    // For Solana chains, we don't cache in the same way, return undefined to trigger fetch
    if ((0, _bridgeController.isSolanaChainId)(chainId)) {
      return undefined;
    }
    // For EVM chains, check the cache
    const hexChainId = (0, _bridgeController.formatChainIdToHex)(chainId);
    return hexChainId ? (_cachedTokens$hexChai = cachedTokens[hexChainId]) === null || _cachedTokens$hexChai === void 0 ? void 0 : _cachedTokens$hexChai.data : undefined;
  }, [chainId, cachedTokens]);
  const isTokenListCached = Boolean(cachedTokenList);
  const {
    value: fetchedTokenList,
    pending: isTokenListLoading
  } = (0, _useAsync.useAsyncResult)(async () => {
    if (isTokenListCached || !chainId) {
      return {};
    }
    // Otherwise fetch new token data
    return await (0, _bridgeController.fetchBridgeTokens)(chainId, _bridgeController.BridgeClientId.EXTENSION, async (url, options) => {
      const {
        headers,
        ...requestOptions
      } = options ?? {};
      return await (0, _fetchWithCache.default)({
        url: url,
        ...requestOptions,
        fetchOptions: {
          method: 'GET',
          headers
        },
        cacheOptions: {
          cacheRefreshTime: 10 * _time.MINUTE
        },
        functionName: 'fetchBridgeTokens'
      });
    }, _bridge.BRIDGE_API_BASE_URL, "13.6.0");
  }, [chainId, isTokenListCached]);
  const tokenList = (0, _react.useMemo)(() => {
    return cachedTokenList ?? fetchedTokenList;
  }, [cachedTokenList, fetchedTokenList]);
  const {
    value: topTokens,
    pending: isTopTokenListLoading
  } = (0, _useAsync.useAsyncResult)(async () => {
    if (chainId) {
      // Use asset sorting from feature fags if defined
      if (topAssetsFromFeatureFlags) {
        return topAssetsFromFeatureFlags.map(tokenAddress => ({
          address: tokenAddress
        }));
      }
      return await (0, _swaps.fetchTopAssetsList)(chainId);
    }
    return [];
  }, [chainId, topAssetsFromFeatureFlags]);

  // shouldAddToken is a filter condition passed in from the AssetPicker that determines whether a token should be included
  const filteredTokenListGenerator = (0, _react.useCallback)(filterCondition => function* () {
    const shouldAddToken = (symbol, address, tokenChainId) => {
      var _tokenToExclude$addre;
      /**
       * Native tokens can be represented differently across the codebase:
       * - When selected as source: address = '0x0000000000000000000000000000000000000000'
       * - When yielded in token lists: address = '' (empty string)
       *
       * @param addr - The token address to normalize
       * @returns Empty string for native addresses, original address otherwise
       */
      const normalizeAddress = addr => {
        return addr && (0, _bridgeController.isNativeAddress)(addr) ? '' : addr;
      };
      return filterCondition(symbol, address, tokenChainId) && (tokenToExclude && tokenChainId ? !(tokenToExclude.symbol === symbol && ((0, _bridgeController.isSolanaChainId)(tokenChainId) ?
      // For Solana: normalize both addresses before comparison to handle native SOL
      normalizeAddress(tokenToExclude.address) === normalizeAddress(address) :
      // For EVM: use case-insensitive comparison (native tokens already normalized)
      ((_tokenToExclude$addre = tokenToExclude.address) === null || _tokenToExclude$addre === void 0 ? void 0 : _tokenToExclude$addre.toLowerCase()) === (address === null || address === void 0 ? void 0 : address.toLowerCase())) && tokenToExclude.chainId === (0, _bridgeController.formatChainIdToCaip)(tokenChainId)) : true);
    };
    if (!chainId || !topTokens) {
      return;
    }
    if (!tokenList || Object.keys(tokenList).length === 0) {
      return;
    }

    // Yield selected token first if it's defined
    if (selectedToken) {
      const token = buildTokenData(chainId, tokenList[selectedToken.address] ?? {
        symbol: selectedToken.symbol,
        address: selectedToken.address,
        decimals: selectedToken.decimals,
        iconUrl: selectedToken.image,
        name: selectedToken.symbol,
        occurrences: selectedToken.occurrences ?? 1,
        aggregators: selectedToken.aggregators ?? []
      });
      if (token) {
        yield token;
      }
    }

    // Yield multichain tokens with balances and are not blocked
    for (const token of multichainTokensWithBalance) {
      if (shouldAddToken(token.symbol, token.address ?? undefined, token.chainId)) {
        if ((0, _bridgeController.isNativeAddress)(token.address) || token.isNative) {
          var _getNativeAssetForCha, _getNativeAssetForCha2;
          yield {
            symbol: token.symbol,
            chainId: token.chainId,
            tokenFiatAmount: token.tokenFiatAmount,
            decimals: token.decimals,
            address: '',
            type: _transaction.AssetType.native,
            balance: token.balance ?? '0',
            string: token.string ?? undefined,
            image: _network.CHAIN_ID_TOKEN_IMAGE_MAP[token.chainId] ?? _networks.MULTICHAIN_TOKEN_IMAGE_MAP[token.chainId] ?? (
            // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
            // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
            ((_getNativeAssetForCha = (0, _bridgeController.getNativeAssetForChainId)(token.chainId)) === null || _getNativeAssetForCha === void 0 ? void 0 : _getNativeAssetForCha.icon) || (// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
            // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
            (_getNativeAssetForCha2 = (0, _bridgeController.getNativeAssetForChainId)(token.chainId)) === null || _getNativeAssetForCha2 === void 0 ? void 0 : _getNativeAssetForCha2.iconUrl) || (0, _assetUtils.getAssetImageUrl)(token.address, (0, _bridgeController.formatChainIdToCaip)(token.chainId)))
          };
        } else {
          var _tokenList$token$addr;
          yield {
            ...token,
            symbol: token.symbol,
            chainId: token.chainId,
            tokenFiatAmount: token.tokenFiatAmount,
            decimals: token.decimals,
            address: token.address,
            type: _transaction.AssetType.token,
            balance: token.balance ?? '',
            string: token.string ?? undefined,
            image: (token.image || token.address && (tokenList === null || tokenList === void 0 || (_tokenList$token$addr = tokenList[token.address.toLowerCase()]) === null || _tokenList$token$addr === void 0 ? void 0 : _tokenList$token$addr.iconUrl)) ?? (0, _assetUtils.getAssetImageUrl)(token.address, (0, _bridgeController.formatChainIdToCaip)(token.chainId)) ?? ''
          };
        }
      }
    }

    // Yield topTokens from selected chain
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
    // eslint-disable-next-line @typescript-eslint/naming-convention
    for (const token_ of topTokens) {
      const matchedToken = (tokenList === null || tokenList === void 0 ? void 0 : tokenList[token_.address]) ?? (tokenList === null || tokenList === void 0 ? void 0 : tokenList[token_.address.toLowerCase()]);
      const token = buildTokenData(chainId, matchedToken);
      if (token && shouldAddToken(token.symbol, token.address ?? undefined, chainId)) {
        yield token;
      }
    }

    // Yield other tokens from selected chain
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
    // eslint-disable-next-line @typescript-eslint/naming-convention
    for (const token_ of Object.values(tokenList)) {
      const token = buildTokenData(chainId, token_);
      if (token && token.symbol.indexOf('$') === -1 && shouldAddToken(token.symbol, token.address ?? undefined, chainId)) {
        yield token;
      }
    }
  }(), [multichainTokensWithBalance, topTokens, chainId, tokenList, tokenToExclude, selectedToken]);
  return {
    filteredTokenListGenerator,
    isLoading: isTokenListLoading || isTopTokenListLoading
  };
};
exports.useTokensWithFiltering = useTokensWithFiltering;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\bridge\\useTokensWithFiltering.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\bridge\\useTxAlerts.ts", {"../../../shared/constants/multichain/networks":"D:\\code\\v\\metamask-extension\\shared\\constants\\multichain\\networks.ts","../../ducks/bridge/actions":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\actions.ts","../../ducks/bridge/selectors":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge\\selectors.ts","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Cbridge%5CuseTxAlerts.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTxAlerts = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _bridgeController = require("@metamask/bridge-controller");
var _networks = require("../../../shared/constants/multichain/networks");
var _selectors = require("../../ducks/bridge/selectors");
var _actions = require("../../ducks/bridge/actions");
/**
 * Sets tx alerts for the active quote
 */
const useTxAlerts = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const fromChain = (0, _reactRedux.useSelector)(_selectors.getFromChain);
  const {
    activeQuote
  } = (0, _reactRedux.useSelector)(_selectors.getBridgeQuotes);
  const {
    trade
  } = activeQuote ?? {};
  const account = (0, _reactRedux.useSelector)(_selectors.getFromAccount);
  (0, _react.useEffect)(() => {
    if (trade && typeof trade === 'string' && fromChain !== null && fromChain !== void 0 && fromChain.chainId && (0, _bridgeController.isSolanaChainId)(fromChain.chainId) && account !== null && account !== void 0 && account.address) {
      dispatch((0, _actions.setTxAlerts)({
        chainId: _networks.MultichainNetworks.SOLANA,
        trade,
        accountAddress: account.address
      }));
    } else {
      dispatch((0, _actions.setTxAlerts)(null));
    }
  }, [trade, fromChain === null || fromChain === void 0 ? void 0 : fromChain.chainId, account === null || account === void 0 ? void 0 : account.address]);
};
exports.useTxAlerts = useTxAlerts;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\bridge\\useTxAlerts.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\claims\\useClaimState.ts", {"react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Cclaims%5CuseClaimState.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useClaimState = void 0;
var _react = require("react");
const useClaimState = () => {
  const [email, setEmail] = (0, _react.useState)('');
  const [impactedWalletAddress, setImpactedWalletAddress] = (0, _react.useState)('');
  const [impactedTransactionHash, setImpactedTransactionHash] = (0, _react.useState)('');
  const [reimbursementWalletAddress, setReimbursementWalletAddress] = (0, _react.useState)('');
  const [caseDescription, setCaseDescription] = (0, _react.useState)('');
  const [files, setFiles] = (0, _react.useState)();
  return {
    email,
    setEmail,
    impactedWalletAddress,
    setImpactedWalletAddress,
    impactedTransactionHash,
    setImpactedTransactionHash,
    reimbursementWalletAddress,
    setReimbursementWalletAddress,
    caseDescription,
    setCaseDescription,
    files,
    setFiles,
    clear: () => {
      setEmail('');
      setImpactedWalletAddress('');
      setImpactedTransactionHash('');
      setReimbursementWalletAddress('');
      setCaseDescription('');
      setFiles(undefined);
    }
  };
};
exports.useClaimState = useClaimState;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\claims\\useClaimState.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\defi\\defiPollingActions.ts", {"../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../store/background-connection":"D:\\code\\v\\metamask-extension\\ui\\store\\background-connection.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Cdefi%5CdefiPollingActions.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deFiStartPolling = deFiStartPolling;
exports.deFiStopPolling = deFiStopPolling;
var _actions = require("../../store/actions");
var _backgroundConnection = require("../../store/background-connection");
/**
 * Informs the DeFiPositionsController that the UI requires defi positions polling
 *
 * @returns polling token that can be used to stop polling.
 */
async function deFiStartPolling() {
  const pollingToken = await (0, _backgroundConnection.submitRequestToBackground)('deFiStartPolling', [null]);
  await (0, _actions.addPollingTokenToAppState)(pollingToken);
  return pollingToken;
}

/**
 * Informs the DeFiPositionsController that the UI no longer needs defi positions polling
 *
 * @param pollingToken - Poll token received from calling deFiStartPolling
 */
async function deFiStopPolling(pollingToken) {
  await (0, _backgroundConnection.submitRequestToBackground)('deFiStopPolling', [pollingToken]);
  await (0, _actions.removePollingTokenFromAppState)(pollingToken);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\defi\\defiPollingActions.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\defi\\useDeFiPolling.ts", {"../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../useMultiPolling":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultiPolling.ts","./defiPollingActions":"D:\\code\\v\\metamask-extension\\ui\\hooks\\defi\\defiPollingActions.ts","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Cdefi%5CuseDeFiPolling.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactRedux = require("react-redux");
var _metamask = require("../../ducks/metamask/metamask");
var _useMultiPolling = _interopRequireDefault(require("../useMultiPolling"));
var _defiPollingActions = require("./defiPollingActions");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const useDeFiPolling = () => {
  const completedOnboarding = (0, _reactRedux.useSelector)(_metamask.getCompletedOnboarding);
  const isUnlocked = (0, _reactRedux.useSelector)(_metamask.getIsUnlocked);
  const enabled = completedOnboarding && isUnlocked;
  (0, _useMultiPolling.default)({
    startPolling: _defiPollingActions.deFiStartPolling,
    stopPollingByPollingToken: _defiPollingActions.deFiStopPolling,
    input: enabled ? [null] : []
  });
  return {};
};
var _default = exports.default = useDeFiPolling;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\defi\\useDeFiPolling.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\gator-permissions\\useGatorPermissions.ts", {"../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../../store/controller-actions/gator-permissions-controller":"D:\\code\\v\\metamask-extension\\ui\\store\\controller-actions\\gator-permissions-controller.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Cgator-permissions%5CuseGatorPermissions.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGatorPermissions = useGatorPermissions;
var _react = require("react");
var _reactRedux = require("react-redux");
var _gatorPermissionsController = require("../../store/controller-actions/gator-permissions-controller");
var _actions = require("../../store/actions");
function useGatorPermissions() {
  const dispatch = (0, _reactRedux.useDispatch)();
  const [loading, setLoading] = (0, _react.useState)(true);
  const [data, setData] = (0, _react.useState)(undefined);
  const [error, setError] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    let cancelled = false;
    async function fetchGatorPermissions() {
      try {
        setError(undefined);
        setLoading(true);
        const newData = await (0, _gatorPermissionsController.fetchAndUpdateGatorPermissions)();
        if (!cancelled) {
          setData(newData);
          await (0, _actions.forceUpdateMetamaskState)(dispatch);
        }
      } catch (err) {
        if (!cancelled) {
          setError(err);
        }
      } finally {
        if (!cancelled) {
          setLoading(false);
        }
      }
    }
    fetchGatorPermissions();
    return () => {
      cancelled = true;
    };
  }, [dispatch]);
  return {
    data,
    error,
    loading
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\gator-permissions\\useGatorPermissions.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\identity\\useAccountSyncing\\index.ts", {"./useAccountSyncing":"D:\\code\\v\\metamask-extension\\ui\\hooks\\identity\\useAccountSyncing\\useAccountSyncing.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Cidentity%5CuseAccountSyncing%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "useAccountSyncing", {
  enumerable: true,
  get: function () {
    return _useAccountSyncing.useAccountSyncing;
  }
});
Object.defineProperty(exports, "useDeleteAccountSyncingDataFromUserStorage", {
  enumerable: true,
  get: function () {
    return _useAccountSyncing.useDeleteAccountSyncingDataFromUserStorage;
  }
});
Object.defineProperty(exports, "useShouldDispatchAccountSyncing", {
  enumerable: true,
  get: function () {
    return _useAccountSyncing.useShouldDispatchAccountSyncing;
  }
});
var _useAccountSyncing = require("./useAccountSyncing");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\identity\\useAccountSyncing\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\identity\\useAccountSyncing\\useAccountSyncing.ts", {"../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/identity/authentication":"D:\\code\\v\\metamask-extension\\ui\\selectors\\identity\\authentication.ts","../../../selectors/identity/backup-and-sync":"D:\\code\\v\\metamask-extension\\ui\\selectors\\identity\\backup-and-sync.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Cidentity%5CuseAccountSyncing%5CuseAccountSyncing.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useShouldDispatchAccountSyncing = exports.useDeleteAccountSyncingDataFromUserStorage = exports.useAccountSyncing = void 0;
var _loglevel = _interopRequireDefault(require("loglevel"));
var _react = require("react");
var _reactRedux = require("react-redux");
var _actions = require("../../../store/actions");
var _backupAndSync = require("../../../selectors/identity/backup-and-sync");
var _selectors = require("../../../selectors");
var _metamask = require("../../../ducks/metamask/metamask");
var _authentication = require("../../../selectors/identity/authentication");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * A utility used internally to decide if account syncing should be dispatched
 * Considers factors like basic functionality; unlocked; finished onboarding, is logged in, and more specific logic.
 *
 * @returns a boolean if internally we can perform account syncing or not.
 */
const useShouldDispatchAccountSyncing = () => {
  const isBackupAndSyncEnabled = (0, _reactRedux.useSelector)(_backupAndSync.selectIsBackupAndSyncEnabled);
  const isAccountSyncingEnabled = (0, _reactRedux.useSelector)(_backupAndSync.selectIsAccountSyncingEnabled);
  const basicFunctionality = (0, _reactRedux.useSelector)(_selectors.getUseExternalServices);
  const isUnlocked = (0, _reactRedux.useSelector)(_metamask.getIsUnlocked);
  const isSignedIn = (0, _reactRedux.useSelector)(_authentication.selectIsSignedIn);
  const completedOnboarding = (0, _reactRedux.useSelector)(_metamask.getCompletedOnboarding);
  const shouldDispatchAccountSyncing = Boolean(basicFunctionality && isBackupAndSyncEnabled && isAccountSyncingEnabled && isUnlocked && isSignedIn && completedOnboarding);
  return shouldDispatchAccountSyncing;
};

/**
 * Custom hook to dispatch account syncing.
 *
 * @returns An object containing the `dispatchAccountSyncing` function, boolean `shouldDispatchAccountSyncing`,
 * and error state.
 */
exports.useShouldDispatchAccountSyncing = useShouldDispatchAccountSyncing;
const useAccountSyncing = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const shouldDispatchAccountSyncing = useShouldDispatchAccountSyncing();
  const dispatchAccountSyncing = (0, _react.useCallback)(() => {
    try {
      if (!shouldDispatchAccountSyncing) {
        return;
      }
      dispatch((0, _actions.syncAccountTreeWithUserStorage)());
    } catch (e) {
      _loglevel.default.error(e);
    }
  }, [dispatch, shouldDispatchAccountSyncing]);
  return {
    dispatchAccountSyncing,
    shouldDispatchAccountSyncing
  };
};

/**
 * Custom hook to delete a user's account syncing data from user storage
 */
exports.useAccountSyncing = useAccountSyncing;
const useDeleteAccountSyncingDataFromUserStorage = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const dispatchDeleteAccountSyncingData = (0, _react.useCallback)(async () => {
    try {
      await dispatch((0, _actions.deleteAccountSyncingDataFromUserStorage)());
    } catch {
      // Do Nothing
    }
  }, [dispatch]);
  return {
    dispatchDeleteAccountSyncingData
  };
};
exports.useDeleteAccountSyncingDataFromUserStorage = useDeleteAccountSyncingDataFromUserStorage;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\identity\\useAccountSyncing\\useAccountSyncing.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\identity\\useAuthentication\\index.ts", {"./useAutoSignIn":"D:\\code\\v\\metamask-extension\\ui\\hooks\\identity\\useAuthentication\\useAutoSignIn.ts","./useAutoSignOut":"D:\\code\\v\\metamask-extension\\ui\\hooks\\identity\\useAuthentication\\useAutoSignOut.ts","./useSignIn":"D:\\code\\v\\metamask-extension\\ui\\hooks\\identity\\useAuthentication\\useSignIn.ts","./useSignOut":"D:\\code\\v\\metamask-extension\\ui\\hooks\\identity\\useAuthentication\\useSignOut.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Cidentity%5CuseAuthentication%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "useAutoSignIn", {
  enumerable: true,
  get: function () {
    return _useAutoSignIn.useAutoSignIn;
  }
});
Object.defineProperty(exports, "useAutoSignOut", {
  enumerable: true,
  get: function () {
    return _useAutoSignOut.useAutoSignOut;
  }
});
Object.defineProperty(exports, "useSignIn", {
  enumerable: true,
  get: function () {
    return _useSignIn.useSignIn;
  }
});
Object.defineProperty(exports, "useSignOut", {
  enumerable: true,
  get: function () {
    return _useSignOut.useSignOut;
  }
});
var _useSignIn = require("./useSignIn");
var _useSignOut = require("./useSignOut");
var _useAutoSignIn = require("./useAutoSignIn");
var _useAutoSignOut = require("./useAutoSignOut");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\identity\\useAuthentication\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\identity\\useAuthentication\\useAutoSignIn.ts", {"../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/identity/authentication":"D:\\code\\v\\metamask-extension\\ui\\selectors\\identity\\authentication.ts","./useSignIn":"D:\\code\\v\\metamask-extension\\ui\\hooks\\identity\\useAuthentication\\useSignIn.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Cidentity%5CuseAuthentication%5CuseAutoSignIn.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAutoSignIn = useAutoSignIn;
var _react = require("react");
var _reactRedux = require("react-redux");
var _metamask = require("../../../ducks/metamask/metamask");
var _selectors = require("../../../selectors");
var _authentication = require("../../../selectors/identity/authentication");
var _useSignIn = require("./useSignIn");
/**
 * Custom hook to manage automatically signing in a user based on the app state.
 *
 * @returns An object containing:
 * - `autoSignIn`: A function to automatically sign in the user if necessary.
 * - `shouldAutoSignIn`: A boolean indicating whether the user should be automatically signed in.
 */
function useAutoSignIn() {
  const [hasNewKeyrings, setHasNewKeyrings] = (0, _react.useState)(false);
  const {
    signIn
  } = (0, _useSignIn.useSignIn)();

  // Base prerequisites
  const isUnlocked = Boolean((0, _reactRedux.useSelector)(_metamask.getIsUnlocked));
  const isBasicFunctionalityEnabled = Boolean((0, _reactRedux.useSelector)(_selectors.getUseExternalServices));
  const completedOnboarding = Boolean((0, _reactRedux.useSelector)(_metamask.getCompletedOnboarding));
  const isSignedIn = (0, _reactRedux.useSelector)(_authentication.selectIsSignedIn);
  const keyrings = (0, _reactRedux.useSelector)(_selectors.getMetaMaskKeyrings);
  const previousKeyringsLength = (0, _react.useRef)(keyrings.length);
  (0, _react.useEffect)(() => {
    if (keyrings.length !== previousKeyringsLength.current) {
      previousKeyringsLength.current = keyrings.length;
      setHasNewKeyrings(true);
    }
  }, [keyrings.length]);
  const shouldAutoSignIn = (0, _react.useMemo)(() => (!isSignedIn || hasNewKeyrings) && isUnlocked && isBasicFunctionalityEnabled && completedOnboarding, [isSignedIn, isUnlocked, isBasicFunctionalityEnabled, completedOnboarding, hasNewKeyrings]);
  const autoSignIn = (0, _react.useCallback)(async () => {
    if (shouldAutoSignIn) {
      if (hasNewKeyrings) {
        await signIn(true);
        setHasNewKeyrings(false);
      }
      await signIn();
    }
  }, [shouldAutoSignIn, signIn, hasNewKeyrings]);
  return {
    autoSignIn,
    shouldAutoSignIn
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\identity\\useAuthentication\\useAutoSignIn.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\identity\\useAuthentication\\useAutoSignOut.ts", {"../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/identity/authentication":"D:\\code\\v\\metamask-extension\\ui\\selectors\\identity\\authentication.ts","./useSignOut":"D:\\code\\v\\metamask-extension\\ui\\hooks\\identity\\useAuthentication\\useSignOut.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Cidentity%5CuseAuthentication%5CuseAutoSignOut.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAutoSignOut = useAutoSignOut;
var _react = require("react");
var _reactRedux = require("react-redux");
var _metamask = require("../../../ducks/metamask/metamask");
var _selectors = require("../../../selectors");
var _authentication = require("../../../selectors/identity/authentication");
var _useSignOut = require("./useSignOut");
/**
 * Custom hook to manage automatically signing out a user based on the app state.
 *
 * @returns An object containing:
 * - `autoSignOut`: A function to automatically sign out the user if necessary.
 * - `shouldAutoSignOut`: A boolean indicating whether the user should be automatically signed out.
 */
function useAutoSignOut() {
  const {
    signOut
  } = (0, _useSignOut.useSignOut)();

  // Base prerequisites
  const isUnlocked = Boolean((0, _reactRedux.useSelector)(_metamask.getIsUnlocked));
  const isBasicFunctionalityEnabled = Boolean((0, _reactRedux.useSelector)(_selectors.getUseExternalServices));
  const isSignedIn = (0, _reactRedux.useSelector)(_authentication.selectIsSignedIn);
  const areBasePrerequisitesMet = (0, _react.useMemo)(() => isSignedIn && isUnlocked && !isBasicFunctionalityEnabled, [isSignedIn, isUnlocked, isBasicFunctionalityEnabled]);
  const shouldAutoSignOut = (0, _react.useMemo)(() => areBasePrerequisitesMet, [areBasePrerequisitesMet]);
  const autoSignOut = (0, _react.useCallback)(async () => {
    if (shouldAutoSignOut) {
      await signOut();
    }
  }, [shouldAutoSignOut, signOut]);
  return {
    autoSignOut,
    shouldAutoSignOut
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\identity\\useAuthentication\\useAutoSignOut.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\identity\\useAuthentication\\useSignIn.ts", {"../../../selectors/identity/authentication":"D:\\code\\v\\metamask-extension\\ui\\selectors\\identity\\authentication.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Cidentity%5CuseAuthentication%5CuseSignIn.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSignIn = useSignIn;
var _react = require("react");
var _reactRedux = require("react-redux");
var _loglevel = _interopRequireDefault(require("loglevel"));
var _authentication = require("../../../selectors/identity/authentication");
var _actions = require("../../../store/actions");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * Custom hook to manage sign-in
 * Use this hook to manually sign in the user.
 * Any automatic sign-in should be handled by the `MetamaskIdentityProvider` with the `useAutoSignIn` hook.
 *
 * This hook encapsulates the logic for initiating a sign-in process if the user is not already signed in
 * and at least one auth dependent feature is enabled. It needs the user to have basic functionality on.
 * It handles loading state and errors during the sign-in process.
 *
 * @returns An object containing:
 * - `signIn`: A function to initiate the sign-in process.
 */
function useSignIn() {
  const dispatch = (0, _reactRedux.useDispatch)();
  const isSignedIn = (0, _reactRedux.useSelector)(_authentication.selectIsSignedIn);
  const areBasePrerequisitesMet = (0, _react.useMemo)(() => !isSignedIn, [isSignedIn]);
  const signIn = (0, _react.useCallback)(async shouldSignInOverride => {
    const shouldSignIn = shouldSignInOverride ?? areBasePrerequisitesMet;
    if (shouldSignIn) {
      try {
        await dispatch((0, _actions.performSignIn)());
      } catch (e) {
        // If an error occurs during the sign-in process, silently fail
        const errorMessage = e instanceof Error ? e.message : JSON.stringify(e ?? '');
        _loglevel.default.error(errorMessage);
      }
    }
  }, [dispatch, areBasePrerequisitesMet]);
  return {
    signIn
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\identity\\useAuthentication\\useSignIn.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\identity\\useAuthentication\\useSignOut.ts", {"../../../selectors/identity/authentication":"D:\\code\\v\\metamask-extension\\ui\\selectors\\identity\\authentication.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Cidentity%5CuseAuthentication%5CuseSignOut.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSignOut = useSignOut;
var _react = require("react");
var _reactRedux = require("react-redux");
var _loglevel = _interopRequireDefault(require("loglevel"));
var _authentication = require("../../../selectors/identity/authentication");
var _actions = require("../../../store/actions");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * Custom hook to manage sign-out
 *
 * Use this hook to manually sign out the user.
 * Any automatic sign-out should be handled by the `MetamaskIdentityProvider` with the `useAutoSignOut` hook.
 * IMPORTANT: nothing other than basic functionality being turned off should trigger a sign out.
 *
 * This hook encapsulates the logic for initiating a sign-out process if the user is signed in.
 * It handles loading state and errors during the sign-out process.
 *
 * @returns An object containing:
 * - `signOut`: A function to initiate the sign-out process.
 */
function useSignOut() {
  const dispatch = (0, _reactRedux.useDispatch)();
  const isSignedIn = (0, _reactRedux.useSelector)(_authentication.selectIsSignedIn);
  const shouldSignOut = (0, _react.useMemo)(() => Boolean(isSignedIn), [isSignedIn]);
  const signOut = (0, _react.useCallback)(async () => {
    if (shouldSignOut) {
      try {
        await dispatch((0, _actions.performSignOut)());
      } catch (e) {
        // If an error occurs during the sign-out process, silently fail
        const errorMessage = e instanceof Error ? e.message : JSON.stringify(e ?? '');
        _loglevel.default.error(errorMessage);
      }
    }
  }, [dispatch, shouldSignOut]);
  return {
    signOut
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\identity\\useAuthentication\\useSignOut.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\identity\\useBackupAndSync\\index.ts", {"./useBackupAndSync":"D:\\code\\v\\metamask-extension\\ui\\hooks\\identity\\useBackupAndSync\\useBackupAndSync.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Cidentity%5CuseBackupAndSync%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "useBackupAndSync", {
  enumerable: true,
  get: function () {
    return _useBackupAndSync.useBackupAndSync;
  }
});
var _useBackupAndSync = require("./useBackupAndSync");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\identity\\useBackupAndSync\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\identity\\useBackupAndSync\\useBackupAndSync.ts", {"../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Cidentity%5CuseBackupAndSync%5CuseBackupAndSync.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBackupAndSync = useBackupAndSync;
var _react = require("react");
var _reactRedux = require("react-redux");
var _loglevel = _interopRequireDefault(require("loglevel"));
var _actions = require("../../../store/actions");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * Custom hook to set the enablement status of a backup and sync feature.
 * This hook handles the process  via dispatch actions.
 *
 * @returns An object containing the `setIsBackupAndSyncFeatureEnabled` function, loading state, and error state.
 */

function useBackupAndSync() {
  const dispatch = (0, _reactRedux.useDispatch)();
  const [error, setError] = (0, _react.useState)(null);
  const setIsBackupAndSyncFeatureEnabled = (0, _react.useCallback)(async (feature, enabled) => {
    setError(null);
    try {
      await dispatch((0, _actions.setIsBackupAndSyncFeatureEnabled)(feature, enabled));
    } catch (e) {
      const errorMessage = e instanceof Error ? e.message : JSON.stringify(e ?? '');
      _loglevel.default.error(errorMessage);
      setError(errorMessage);
    } finally {
      dispatch((0, _actions.hideLoadingIndication)());
    }
  }, [dispatch]);
  return {
    error,
    setIsBackupAndSyncFeatureEnabled
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\identity\\useBackupAndSync\\useBackupAndSync.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\identity\\useContactSyncing\\index.ts", {"./useContactSyncing":"D:\\code\\v\\metamask-extension\\ui\\hooks\\identity\\useContactSyncing\\useContactSyncing.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Cidentity%5CuseContactSyncing%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "useContactSyncing", {
  enumerable: true,
  get: function () {
    return _useContactSyncing.useContactSyncing;
  }
});
Object.defineProperty(exports, "useShouldDispatchContactSyncing", {
  enumerable: true,
  get: function () {
    return _useContactSyncing.useShouldDispatchContactSyncing;
  }
});
var _useContactSyncing = require("./useContactSyncing");

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\identity\\useContactSyncing\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\identity\\useContactSyncing\\useContactSyncing.ts", {"../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../../selectors/identity/authentication":"D:\\code\\v\\metamask-extension\\ui\\selectors\\identity\\authentication.ts","../../../selectors/identity/backup-and-sync":"D:\\code\\v\\metamask-extension\\ui\\selectors\\identity\\backup-and-sync.ts","../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Cidentity%5CuseContactSyncing%5CuseContactSyncing.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useShouldDispatchContactSyncing = exports.useContactSyncing = void 0;
var _loglevel = _interopRequireDefault(require("loglevel"));
var _react = require("react");
var _reactRedux = require("react-redux");
var _actions = require("../../../store/actions");
var _backupAndSync = require("../../../selectors/identity/backup-and-sync");
var _selectors = require("../../../selectors");
var _metamask = require("../../../ducks/metamask/metamask");
var _authentication = require("../../../selectors/identity/authentication");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * A utility used internally to decide if contact syncing should be dispatched
 * Considers factors like basic functionality; unlocked; finished onboarding, is logged in, and more specific logic.
 *
 * @returns a boolean if internally we can perform contact syncing or not.
 */
const useShouldDispatchContactSyncing = () => {
  const isBackupAndSyncEnabled = (0, _reactRedux.useSelector)(_backupAndSync.selectIsBackupAndSyncEnabled);
  const isContactSyncingEnabled = (0, _reactRedux.useSelector)(_backupAndSync.selectIsContactSyncingEnabled);
  const basicFunctionality = (0, _reactRedux.useSelector)(_selectors.getUseExternalServices);
  const isUnlocked = (0, _reactRedux.useSelector)(_metamask.getIsUnlocked);
  const isSignedIn = (0, _reactRedux.useSelector)(_authentication.selectIsSignedIn);
  const completedOnboarding = (0, _reactRedux.useSelector)(_metamask.getCompletedOnboarding);
  const shouldDispatchContactSyncing = Boolean(basicFunctionality && isBackupAndSyncEnabled && isContactSyncingEnabled && isUnlocked && isSignedIn && completedOnboarding);
  return shouldDispatchContactSyncing;
};

/**
 * Custom hook to dispatch contact syncing.
 *
 * @returns An object containing the `dispatchContactSyncing` function, boolean `shouldDispatchContactSyncing`,
 * and error state.
 */
exports.useShouldDispatchContactSyncing = useShouldDispatchContactSyncing;
const useContactSyncing = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const shouldDispatchContactSyncing = useShouldDispatchContactSyncing();
  const dispatchContactSyncing = (0, _react.useCallback)(() => {
    try {
      if (!shouldDispatchContactSyncing) {
        return;
      }
      dispatch((0, _actions.syncContactsWithUserStorage)());
    } catch (e) {
      _loglevel.default.error(e);
    }
  }, [dispatch, shouldDispatchContactSyncing]);
  return {
    dispatchContactSyncing,
    shouldDispatchContactSyncing
  };
};
exports.useContactSyncing = useContactSyncing;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\identity\\useContactSyncing\\useContactSyncing.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\metamask-notifications\\useCounter.tsx", {"../../selectors/metamask-notifications/metamask-notifications":"D:\\code\\v\\metamask-extension\\ui\\selectors\\metamask-notifications\\metamask-notifications.ts","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Cmetamask-notifications%5CuseCounter.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useReadNotificationsCounter = useReadNotificationsCounter;
exports.useUnreadNotificationsCounter = useUnreadNotificationsCounter;
var _reactRedux = require("react-redux");
var _metamaskNotifications = require("../../selectors/metamask-notifications/metamask-notifications");
const useSnapNotificationsCount = () => {
  const unreadSnapNotificationsCount = (0, _reactRedux.useSelector)(_metamaskNotifications.getSnapNotificationsUnreadCount);
  const readSnapNotificationsCount = (0, _reactRedux.useSelector)(_metamaskNotifications.getSnapNotificationsReadCount);
  return {
    unreadSnapNotificationsCount,
    readSnapNotificationsCount
  };
};
const useFeatureAnnouncementCount = () => {
  const isFeatureAnnouncementsEnabled = (0, _reactRedux.useSelector)(_metamaskNotifications.selectIsFeatureAnnouncementsEnabled);
  const featureAnnouncementsUnreadCount = (0, _reactRedux.useSelector)(_metamaskNotifications.getFeatureAnnouncementsUnreadCount);
  const featureAnnouncementsReadCount = (0, _reactRedux.useSelector)(_metamaskNotifications.getFeatureAnnouncementsReadCount);
  return isFeatureAnnouncementsEnabled ? {
    featureAnnouncementsUnreadCount,
    featureAnnouncementsReadCount
  } : {
    featureAnnouncementsUnreadCount: 0,
    featureAnnouncementsReadCount: 0
  };
};
const useWalletNotificationCount = () => {
  const isMetamaskNotificationsEnabled = (0, _reactRedux.useSelector)(_metamaskNotifications.selectIsMetamaskNotificationsEnabled);
  const onChainMetamaskNotificationsUnreadCount = (0, _reactRedux.useSelector)(_metamaskNotifications.getOnChainMetamaskNotificationsUnreadCount);
  const onChainMetamaskNotificationsReadCount = (0, _reactRedux.useSelector)(_metamaskNotifications.getOnChainMetamaskNotificationsReadCount);
  return isMetamaskNotificationsEnabled ? {
    onChainMetamaskNotificationsUnreadCount,
    onChainMetamaskNotificationsReadCount
  } : {
    onChainMetamaskNotificationsUnreadCount: 0,
    onChainMetamaskNotificationsReadCount: 0
  };
};
function useUnreadNotificationsCounter() {
  const {
    unreadSnapNotificationsCount
  } = useSnapNotificationsCount();
  const {
    featureAnnouncementsUnreadCount
  } = useFeatureAnnouncementCount();
  const {
    onChainMetamaskNotificationsUnreadCount
  } = useWalletNotificationCount();
  const notificationsUnreadCount = unreadSnapNotificationsCount + featureAnnouncementsUnreadCount + onChainMetamaskNotificationsUnreadCount;
  return {
    notificationsUnreadCount
  };
}
function useReadNotificationsCounter() {
  const {
    readSnapNotificationsCount
  } = useSnapNotificationsCount();
  const {
    featureAnnouncementsReadCount
  } = useFeatureAnnouncementCount();
  const {
    onChainMetamaskNotificationsReadCount
  } = useWalletNotificationCount();
  const notificationsReadCount = readSnapNotificationsCount + featureAnnouncementsReadCount + onChainMetamaskNotificationsReadCount;
  return {
    notificationsReadCount
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\metamask-notifications\\useCounter.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\metamask-notifications\\useNotifications.ts", {"../../contexts/metamask-notifications/notification-storage-keys":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metamask-notifications\\notification-storage-keys.ts","../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Cmetamask-notifications%5CuseNotifications.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateNotifications = useCreateNotifications;
exports.useDisableNotifications = useDisableNotifications;
exports.useEnableNotifications = useEnableNotifications;
exports.useListNotifications = useListNotifications;
exports.useMarkNotificationAsRead = useMarkNotificationAsRead;
var _react = require("react");
var _reactRedux = require("react-redux");
var _loglevel = _interopRequireDefault(require("loglevel"));
var _actions = require("../../store/actions");
var _notificationStorageKeys = require("../../contexts/metamask-notifications/notification-storage-keys");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// Define KeyringType interface

// Define AccountType interface

/**
 * Custom hook to fetch and update the list of notifications.
 * Manages loading and error states internally.
 *
 * @returns An object containing the `listNotifications` function, loading state, and error state.
 */
function useListNotifications() {
  const dispatch = (0, _reactRedux.useDispatch)();
  const [loading, setLoading] = (0, _react.useState)(false);
  const [error, setError] = (0, _react.useState)(null);
  const [notificationsData, setNotificationsData] = (0, _react.useState)(undefined);
  const listNotifications = (0, _react.useCallback)(async () => {
    setLoading(true);
    setError(null);
    const urlParams = new URLSearchParams(window.location.search);
    const previewToken = urlParams.get('previewToken');
    try {
      const data = await dispatch((0, _actions.fetchAndUpdateMetamaskNotifications)(previewToken ?? undefined));
      setNotificationsData(data);
      return data;
    } catch (e) {
      _loglevel.default.error(e);
      setError(e instanceof Error ? e.message : 'An unexpected error occurred');
      throw e;
    } finally {
      setLoading(false);
    }
  }, [dispatch]);
  return {
    listNotifications,
    notificationsData,
    isLoading: loading,
    error
  };
}

/**
 * Custom hook to enable notifications by creating on-chain triggers.
 * It manages loading and error states internally.
 *
 * @returns An object containing the `enableNotifications` function, loading state, and error state.
 */
function useCreateNotifications() {
  const dispatch = (0, _reactRedux.useDispatch)();
  const [error, setError] = (0, _react.useState)(null);
  const createNotifications = (0, _react.useCallback)(async () => {
    setError(null);
    try {
      await dispatch((0, _actions.createOnChainTriggers)());
      await (0, _notificationStorageKeys.updateNotificationSubscriptionExpiration)();
    } catch (e) {
      setError(e instanceof Error ? e.message : 'An unexpected error occurred');
      _loglevel.default.error(e);
      throw e;
    }
  }, [dispatch]);
  return {
    createNotifications,
    error
  };
}

/**
 * Custom hook to enable MetaMask notifications.
 * This hook encapsulates the logic for enabling notifications, handling loading and error states.
 * It uses Redux to dispatch actions related to notifications.
 *
 * @returns An object containing:
 * - `enableNotifications`: A function that triggers the enabling of notifications.
 * - `loading`: A boolean indicating if the enabling process is ongoing.
 * - `error`: A string or null value representing any error that occurred during the process.
 */
function useEnableNotifications() {
  const dispatch = (0, _reactRedux.useDispatch)();
  const [error, setError] = (0, _react.useState)(null);
  const enableNotifications = (0, _react.useCallback)(async () => {
    setError(null);
    try {
      await dispatch((0, _actions.enableMetamaskNotifications)());
      await (0, _notificationStorageKeys.updateNotificationSubscriptionExpiration)();
    } catch (e) {
      setError(e instanceof Error ? e.message : 'An unexpected error occurred');
      _loglevel.default.error(e);
      throw e;
    }
  }, [dispatch]);
  return {
    enableNotifications,
    error
  };
}

/**
 * Custom hook to disable notifications by deleting on-chain triggers associated with accounts.
 * It also disables snap and feature announcements. Manages loading and error states internally.
 *
 * @returns An object containing the `disableNotifications` function, loading state, and error state.
 */
function useDisableNotifications() {
  const dispatch = (0, _reactRedux.useDispatch)();
  const [error, setError] = (0, _react.useState)(null);
  const disableNotifications = (0, _react.useCallback)(async () => {
    setError(null);
    try {
      await dispatch((0, _actions.disableMetamaskNotifications)());
      await (0, _notificationStorageKeys.setUserHasTurnedOffNotificationsOnce)();
    } catch (e) {
      setError(e instanceof Error ? e.message : 'An unexpected error occurred');
      _loglevel.default.error(e);
      throw e;
    }
  }, [dispatch]);
  return {
    disableNotifications,
    error
  };
}

/**
 * Provides a function to mark notifications as read. This hook does not take parameters itself,
 * but returns a function that accepts the notification parameters when called.
 *
 * @returns An object containing the `markNotificationAsRead` function which takes a `notifications`
 * parameter of type `MarkAsReadNotificationsParam` and marks those notifications as read.
 */
function useMarkNotificationAsRead() {
  const dispatch = (0, _reactRedux.useDispatch)();
  const markNotificationAsRead = (0, _react.useCallback)(async notifications => {
    try {
      dispatch((0, _actions.markMetamaskNotificationsAsRead)(notifications));
    } catch (e) {
      _loglevel.default.error(e);
      throw e;
    }
  }, [dispatch]);
  return {
    markNotificationAsRead
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\metamask-notifications\\useNotifications.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\metamask-notifications\\useSwitchNotifications.ts", {"../../selectors/metamask-notifications/metamask-notifications":"D:\\code\\v\\metamask-extension\\ui\\selectors\\metamask-notifications\\metamask-notifications.ts","../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Cmetamask-notifications%5CuseSwitchNotifications.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAccountSettingsProps = useAccountSettingsProps;
exports.useSwitchAccountNotificationsChange = useSwitchAccountNotificationsChange;
exports.useSwitchFeatureAnnouncementsChange = useSwitchFeatureAnnouncementsChange;
var _react = require("react");
var _reactRedux = require("react-redux");
var _loglevel = _interopRequireDefault(require("loglevel"));
var _actions = require("../../store/actions");
var _metamaskNotifications = require("../../selectors/metamask-notifications/metamask-notifications");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function useSwitchFeatureAnnouncementsChange() {
  const dispatch = (0, _reactRedux.useDispatch)();
  const [error, setError] = (0, _react.useState)(null);
  const onChange = (0, _react.useCallback)(async state => {
    setError(null);
    try {
      await dispatch((0, _actions.setFeatureAnnouncementsEnabled)(state));
    } catch (e) {
      const errorMessage = e instanceof Error ? e.message : JSON.stringify(e ?? '');
      setError(errorMessage);
    }
  }, [dispatch]);
  return {
    onChange,
    error
  };
}
function useSwitchAccountNotificationsChange() {
  const dispatch = (0, _reactRedux.useDispatch)();
  const [error, setError] = (0, _react.useState)(null);
  const onChange = (0, _react.useCallback)(async (addresses, state) => {
    setError(null);
    try {
      if (state) {
        await dispatch((0, _actions.enableAccounts)(addresses));
      } else {
        await dispatch((0, _actions.disableAccounts)(addresses));
      }
    } catch (e) {
      const errorMessage = e instanceof Error ? e.message : JSON.stringify(e ?? '');
      _loglevel.default.error(errorMessage);
      setError(errorMessage);
    }
    dispatch((0, _actions.hideLoadingIndication)());
  }, [dispatch]);
  return {
    onChange,
    error
  };
}
function useRefetchAccountSettings() {
  const dispatch = (0, _reactRedux.useDispatch)();
  const getAccountSettings = (0, _react.useCallback)(async accounts => {
    try {
      const result = await dispatch((0, _actions.checkAccountsPresence)(accounts));
      return result;
    } catch {
      return {};
    }
  }, []);
  return getAccountSettings;
}

/**
 * Account Settings Hook.
 * Gets initial loading states, and returns enable/disable account states.
 * Also exposes an update() method so each switch can be manually updated.
 *
 * @param accounts - the accounts we are checking to see if notifications are enabled/disabled
 * @returns props for settings page
 */
function useAccountSettingsProps(accounts) {
  const accountsBeingUpdated = (0, _reactRedux.useSelector)(_metamaskNotifications.getIsUpdatingMetamaskNotificationsAccount);
  const isEnabled = (0, _reactRedux.useSelector)(_metamaskNotifications.selectIsMetamaskNotificationsEnabled);
  const fetchAccountSettings = useRefetchAccountSettings();
  const [data, setData] = (0, _react.useState)({});
  const [loading, setLoading] = (0, _react.useState)(false);
  const [error, setError] = (0, _react.useState)(null);

  // Memoize the accounts array to avoid unnecessary re-fetching
  const jsonAccounts = (0, _react.useMemo)(() => JSON.stringify(accounts), [accounts]);
  const update = (0, _react.useCallback)(async addresses => {
    try {
      setLoading(true);
      setError(null);
      const res = await fetchAccountSettings(addresses);
      setData(res);
    } catch {
      setError('Failed to get account settings');
    } finally {
      setLoading(false);
    }
  }, []);

  // Effect - async get if accounts are enabled/disabled
  (0, _react.useEffect)(() => {
    if (!isEnabled) {
      return;
    }
    const memoAccounts = JSON.parse(jsonAccounts);
    update(memoAccounts);
  }, [jsonAccounts, fetchAccountSettings, isEnabled]);
  return {
    data,
    initialLoading: loading,
    error,
    accountsBeingUpdated,
    update
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\metamask-notifications\\useSwitchNotifications.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\multi-srp\\useHdKeyringsWithSnapAccounts.ts", {"../../../shared/lib/snaps/snaps":"D:\\code\\v\\metamask-extension\\shared\\lib\\snaps\\snaps.ts","../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../selectors/accounts":"D:\\code\\v\\metamask-extension\\ui\\selectors\\accounts.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Cmulti-srp%5CuseHdKeyringsWithSnapAccounts.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHdKeyringsWithSnapAccounts = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _accounts = require("../../selectors/accounts");
var _selectors = require("../../selectors");
var _snaps = require("../../../shared/lib/snaps/snaps");
// TODO: Move this data type to the @metamask/keyring-controller module

/**
 * Custom hook that combines HD keyrings with their snap accounts that were derived from the same entropy source.
 *
 * @returns An array of hd keyring objects with any snap accounts that were derived from the same entropy source.
 */
const useHdKeyringsWithSnapAccounts = () => {
  const hdKeyrings = (0, _reactRedux.useSelector)(_selectors.getMetaMaskHdKeyrings);
  const internalAccounts = (0, _reactRedux.useSelector)(_accounts.getInternalAccounts);
  return (0, _react.useMemo)(() => {
    return hdKeyrings.map(keyring => {
      const firstPartySnapAccounts = internalAccounts.filter(account => {
        var _account$options;
        return account.metadata.snap && (0, _snaps.isSnapPreinstalled)(account.metadata.snap.id) && ((_account$options = account.options) === null || _account$options === void 0 ? void 0 : _account$options.entropySource) === keyring.metadata.id;
      }).map(account => account.address);
      return {
        ...keyring,
        accounts: [...keyring.accounts, ...firstPartySnapAccounts]
      };
    });
  }, [hdKeyrings, internalAccounts]);
};
exports.useHdKeyringsWithSnapAccounts = useHdKeyringsWithSnapAccounts;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\multi-srp\\useHdKeyringsWithSnapAccounts.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\multichain-accounts\\useAccountBalance.ts", {"../../components/app/assets/util/formatWithThreshold":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\util\\formatWithThreshold.ts","../../ducks/locale/locale":"D:\\code\\v\\metamask-extension\\ui\\ducks\\locale\\locale.ts","../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Cmultichain-accounts%5CuseAccountBalance.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDisplayBalanceCalc = useDisplayBalanceCalc;
var _reactRedux = require("react-redux");
var _react = require("react");
var _formatWithThreshold = require("../../components/app/assets/util/formatWithThreshold");
var _metamask = require("../../ducks/metamask/metamask");
var _locale = require("../../ducks/locale/locale");
function useDisplayBalanceCalc() {
  const fallbackCurrency = (0, _reactRedux.useSelector)(_metamask.getCurrentCurrency);
  const locale = (0, _reactRedux.useSelector)(_locale.getIntlLocale);
  const displayBalanceCalc = (0, _react.useCallback)((balance = 0, currency = fallbackCurrency) => {
    const displayBalance = (0, _formatWithThreshold.formatWithThreshold)(balance, 0.01, locale, {
      style: 'currency',
      currency
    });
    return displayBalance;
  }, [fallbackCurrency, locale]);
  return displayBalanceCalc;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\multichain-accounts\\useAccountBalance.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\multichain-accounts\\useWalletBalance.ts", {"../../selectors/assets":"D:\\code\\v\\metamask-extension\\ui\\selectors\\assets.ts","./useAccountBalance":"D:\\code\\v\\metamask-extension\\ui\\hooks\\multichain-accounts\\useAccountBalance.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Cmultichain-accounts%5CuseWalletBalance.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSingleWalletAccountsBalanceCallback = useSingleWalletAccountsBalanceCallback;
exports.useSingleWalletDisplayBalance = useSingleWalletDisplayBalance;
var _react = require("react");
var _reactRedux = require("react-redux");
var _assets = require("../../selectors/assets");
var _useAccountBalance = require("./useAccountBalance");
function useSingleWalletDisplayBalance(walletId) {
  const selector = (0, _react.useMemo)(() => (0, _assets.selectBalanceByWallet)(walletId), [walletId]);
  const walletBalance = (0, _reactRedux.useSelector)(selector);
  const displayBalanceCalc = (0, _useAccountBalance.useDisplayBalanceCalc)();
  return displayBalanceCalc(walletBalance.totalBalanceInUserCurrency, walletBalance.userCurrency);
}
function useSingleWalletAccountsBalanceCallback(walletId) {
  const selector = (0, _react.useMemo)(() => (0, _assets.selectBalanceByWallet)(walletId), [walletId]);
  const walletBalance = (0, _reactRedux.useSelector)(selector);
  const displayBalanceCalc = (0, _useAccountBalance.useDisplayBalanceCalc)();
  const getDisplayBalance = (0, _react.useCallback)(groupId => {
    var _walletBalance$groups;
    const balance = (_walletBalance$groups = walletBalance.groups) === null || _walletBalance$groups === void 0 ? void 0 : _walletBalance$groups[groupId];
    if (!balance) {
      return undefined;
    }
    const displayBalance = displayBalanceCalc(balance === null || balance === void 0 ? void 0 : balance.totalBalanceInUserCurrency, balance === null || balance === void 0 ? void 0 : balance.userCurrency);
    return displayBalance;
  }, [walletBalance, displayBalanceCalc]);
  return getDisplayBalance;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\multichain-accounts\\useWalletBalance.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\multichain-accounts\\useWalletInfo.ts", {"../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","../multi-srp/useHdKeyringsWithSnapAccounts":"D:\\code\\v\\metamask-extension\\ui\\hooks\\multi-srp\\useHdKeyringsWithSnapAccounts.ts","./utils":"D:\\code\\v\\metamask-extension\\ui\\hooks\\multichain-accounts\\utils.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Cmultichain-accounts%5CuseWalletInfo.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWalletInfo = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _useHdKeyringsWithSnapAccounts = require("../multi-srp/useHdKeyringsWithSnapAccounts");
var _accountTree = require("../../selectors/multichain-accounts/account-tree");
var _metamask = require("../../ducks/metamask/metamask");
var _utils = require("./utils");
/**
 * Hook that provides comprehensive wallet information including accounts, keyring ID and backup status.
 *
 * @param walletId - ID of a wallet.
 * @returns Object containing multichain accounts, keyringId and isSRPBackedUp.
 */
const useWalletInfo = walletId => {
  const hdKeyringsWithSnapAccounts = (0, _useHdKeyringsWithSnapAccounts.useHdKeyringsWithSnapAccounts)();
  const globalSRPBackedUp = (0, _reactRedux.useSelector)(_metamask.getIsPrimarySeedPhraseBackedUp);
  const rawMultichainAccounts = (0, _reactRedux.useSelector)(state => (0, _accountTree.getMultichainAccountsByWalletId)(state, walletId));
  const multichainAccounts = Object.values(rawMultichainAccounts ?? {});
  return (0, _react.useMemo)(() => {
    if (Object.entries(multichainAccounts || {}).length === 0) {
      return {
        multichainAccounts,
        keyringId: undefined
      };
    }

    // Find which HD keyring this wallet belongs to using the first account
    const keyringIndex = hdKeyringsWithSnapAccounts.findIndex(keyring => keyring.metadata.id === (0, _utils.stripWalletTypePrefixFromWalletId)(walletId));
    if (keyringIndex === -1) {
      return {
        multichainAccounts,
        keyringId: undefined
      };
    }
    const keyring = hdKeyringsWithSnapAccounts[keyringIndex];
    const keyringId = (keyring === null || keyring === void 0 ? void 0 : keyring.metadata.id) ?? undefined;
    const srpIndex = keyringIndex + 1;

    // Only return backup status for the primary SRP (index 1) since the current
    // backup tracking system only tracks the primary SRP, not individual SRPs.
    // For all other SRPs, we don't return backup status to avoid showing incorrect information.
    const isSRPBackedUp = srpIndex === 1 ? globalSRPBackedUp : undefined;
    return {
      multichainAccounts,
      keyringId,
      isSRPBackedUp
    };
  }, [multichainAccounts, hdKeyringsWithSnapAccounts, globalSRPBackedUp, walletId]);
};
exports.useWalletInfo = useWalletInfo;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\multichain-accounts\\useWalletInfo.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\ramps\\useRamps\\useRamps.ts", {"../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Cramps%5CuseRamps%5CuseRamps.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.RampsMetaMaskEntry = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _bridgeController = require("@metamask/bridge-controller");
var _utils = require("@metamask/utils");
var _networks = require("../../../../shared/modules/selectors/networks");
var _selectors = require("../../../selectors");
let RampsMetaMaskEntry = exports.RampsMetaMaskEntry = /*#__PURE__*/function (RampsMetaMaskEntry) {
  RampsMetaMaskEntry["BuySellButton"] = "ext_buy_sell_button";
  RampsMetaMaskEntry["NftBanner"] = "ext_buy_banner_nfts";
  RampsMetaMaskEntry["TokensBanner"] = "ext_buy_banner_tokens";
  RampsMetaMaskEntry["ActivityBanner"] = "ext_buy_banner_activity";
  RampsMetaMaskEntry["BtcBanner"] = "ext_buy_banner_btc";
  return RampsMetaMaskEntry;
}({});
const useRamps = (metamaskEntry = RampsMetaMaskEntry.BuySellButton) => {
  const chainId = (0, _reactRedux.useSelector)(_networks.getCurrentChainId);
  const metaMetricsId = (0, _reactRedux.useSelector)(_selectors.getMetaMetricsId);
  const isMetaMetricsEnabled = (0, _reactRedux.useSelector)(_selectors.getParticipateInMetaMetrics);
  const isMarketingEnabled = (0, _reactRedux.useSelector)(_selectors.getDataCollectionForMarketing);
  const getBuyURI = (0, _react.useCallback)(_chainId => {
    try {
      const params = new URLSearchParams();
      params.set('metamaskEntry', metamaskEntry);
      let numericChainId = '';
      if ((0, _bridgeController.isSolanaChainId)(_chainId)) {
        numericChainId = _chainId;
      } else {
        numericChainId = (0, _utils.hexToNumber)(_chainId).toString();
      }
      params.set('chainId', numericChainId);
      if (metaMetricsId) {
        params.set('metametricsId', metaMetricsId);
      }
      params.set('metricsEnabled', String(isMetaMetricsEnabled));
      if (isMarketingEnabled) {
        params.set('marketingEnabled', String(isMarketingEnabled));
      }
      const url = new URL("https://app.metamask.io" || '');
      url.pathname = 'buy';
      url.search = params.toString();
      return url.toString();
    } catch {
      return 'https://app.metamask.io/buy';
    }
  }, [isMarketingEnabled, isMetaMetricsEnabled, metaMetricsId, metamaskEntry]);
  const openBuyCryptoInPdapp = (0, _react.useCallback)(_chainId => {
    const buyUrl = getBuyURI(_chainId || chainId);
    global.platform.openTab({
      url: buyUrl
    });
  }, [chainId, getBuyURI]);
  return {
    openBuyCryptoInPdapp,
    getBuyURI
  };
};
var _default = exports.default = useRamps;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\ramps\\useRamps\\useRamps.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\snaps\\useDisplayName.ts", {"../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../../shared/modules/hexstring-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\hexstring-utils.ts","../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","../../selectors/snaps":"D:\\code\\v\\metamask-extension\\ui\\selectors\\snaps\\index.ts","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Csnaps%5CuseDisplayName.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDisplayName = void 0;
var _utils = require("@metamask/utils");
var _reactRedux = require("react-redux");
var _snaps = require("../../selectors/snaps");
var _hexstringUtils = require("../../../shared/modules/hexstring-utils");
var _conversion = require("../../../shared/modules/conversion.utils");
var _accountTree = require("../../selectors/multichain-accounts/account-tree");
var _selectors = require("../../selectors");
/**
 * Get the display name for an address.
 * This will look for an account name in the state, and if not found, it will look for an address book entry.
 *
 * @param params - The parsed CAIP-10 ID.
 * @returns The display name for the address.
 */
const useDisplayName = params => {
  var _accountGroups$;
  const {
    address,
    chain: {
      namespace,
      reference
    }
  } = params;
  const isEip155 = namespace === _utils.KnownCaipNamespace.Eip155;
  const parsedAddress = isEip155 ? (0, _hexstringUtils.toChecksumHexAddress)(address) : address;
  const showAccountGroupName = (0, _reactRedux.useSelector)(_selectors.getIsMultichainAccountsState2Enabled);
  const accountGroups = (0, _reactRedux.useSelector)(state => (0, _accountTree.getAccountGroupsByAddress)(state, [parsedAddress]));
  const accountGroupName = (_accountGroups$ = accountGroups[0]) === null || _accountGroups$ === void 0 ? void 0 : _accountGroups$.metadata.name;
  const accountName = (0, _reactRedux.useSelector)(state => (0, _snaps.getMemoizedAccountName)(state, parsedAddress));
  const addressBookEntry = (0, _reactRedux.useSelector)(state => (0, _snaps.getAddressBookEntryByNetwork)(state, parsedAddress, `0x${(0, _conversion.decimalToHex)(isEip155 ? reference : `0`)}`));

  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  return showAccountGroupName && accountGroupName || accountName || isEip155 && (addressBookEntry === null || addressBookEntry === void 0 ? void 0 : addressBookEntry.name) || undefined;
};
exports.useDisplayName = useDisplayName;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\snaps\\useDisplayName.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\snaps\\useInsightSnaps.js", {"../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","@metamask/snaps-sdk":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\index.cjs","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Csnaps%5CuseInsightSnaps.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInsightSnaps = useInsightSnaps;
var _reactRedux = require("react-redux");
var _snapsSdk = require("@metamask/snaps-sdk");
var _selectors = require("../../selectors");
function useInsightSnaps(id) {
  const insight = (0, _reactRedux.useSelector)(state => (0, _selectors.getSnapInsights)(state, id));
  const data = insight ? Object.values(insight) : [];
  const warnings = data.filter(result => result.severity === _snapsSdk.SeverityLevel.Critical);
  return {
    data,
    warnings
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\snaps\\useInsightSnaps.js",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\snaps\\useIsOverflowing.js", {"react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Csnaps%5CuseIsOverflowing.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("react");
const useIsOverflowing = () => {
  const contentRef = (0, _react.useRef)(null);
  const [isOverflowing, setIsOverflowing] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    setIsOverflowing(contentRef.current && contentRef.current.offsetHeight < contentRef.current.scrollHeight);
  }, [contentRef]);
  return {
    contentRef,
    isOverflowing
  };
};
var _default = exports.default = useIsOverflowing;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\snaps\\useIsOverflowing.js",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\snaps\\useSafeWebsite.ts", {"../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Csnaps%5CuseSafeWebsite.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSafeWebsite = void 0;
var _react = require("react");
var _actions = require("../../store/actions");
/**
 * Perform a phishing check on the provided link.
 *
 * @param website - The website to check.
 * @returns The safe website URL or nothing if it's a phishing website.
 */
const useSafeWebsite = website => {
  const [safeWebsite, setSafeWebsite] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    const performPhishingCheck = async () => {
      const phishingResult = await (0, _actions.getPhishingResult)(website);
      if (!phishingResult.result) {
        setSafeWebsite(new URL(website));
      }
    };
    if (website) {
      performPhishingCheck();
    }
  }, [website]);
  return safeWebsite;
};
exports.useSafeWebsite = useSafeWebsite;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\snaps\\useSafeWebsite.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\snaps\\useSnapNameResolution.ts", {"../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","@metamask/snaps-rpc-methods":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Csnaps%5CuseSnapNameResolution.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSnapNameResolution = useSnapNameResolution;
var _react = require("react");
var _reactRedux = require("react-redux");
var _snapsRpcMethods = require("@metamask/snaps-rpc-methods");
var _selectors = require("../../selectors");
var _actions = require("../../store/actions");
/**
 * A hook for using Snaps to resolve domain names for a given chain ID.
 *
 * @returns Function to get domain name resolutions.
 */
function useSnapNameResolution() {
  const snaps = (0, _reactRedux.useSelector)(_selectors.getNameLookupSnaps);

  /**
   * Filters the available snaps based on the provided chain ID and domain.
   *
   * @param chainId - The CAIP-2 chain ID.
   * @param domain - The domain to resolve.
   * @returns The filtered snap IDs.
   */
  const getAvailableSnaps = (0, _react.useCallback)((chainId, domain) => snaps.filter(({
    permission
  }) => {
    const chainIdCaveat = (0, _snapsRpcMethods.getChainIdsCaveat)(permission);
    if (chainIdCaveat && !chainIdCaveat.includes(chainId)) {
      return false;
    }
    const lookupMatchersCaveat = (0, _snapsRpcMethods.getLookupMatchersCaveat)(permission);
    if (lookupMatchersCaveat) {
      const {
        tlds,
        schemes
      } = lookupMatchersCaveat;
      return (tlds === null || tlds === void 0 ? void 0 : tlds.some(tld => domain.endsWith(`.${tld}`))) || (schemes === null || schemes === void 0 ? void 0 : schemes.some(scheme => domain.startsWith(`${scheme}:`)));
    }
    return true;
  }).map(({
    id
  }) => id), [snaps]);

  /**
   * Fetches name resolutions from the available snaps for the given chain ID and domain.
   *
   * @param chainId - The CAIP-2 chain ID.
   * @param domain - The domain to resolve.
   * @returns An object containing the resolutions and any errors encountered.
   */
  const fetchResolutions = (0, _react.useCallback)(async (chainId, domain) => {
    const availableSnaps = getAvailableSnaps(chainId, domain);
    if (availableSnaps.length === 0) {
      return [];
    }
    const responses = await Promise.allSettled(availableSnaps.map(id => (0, _actions.handleSnapRequest)({
      snapId: id,
      origin: 'metamask',
      handler: 'onNameLookup',
      request: {
        jsonrpc: '2.0',
        method: ' ',
        params: {
          chainId,
          domain
        }
      }
    })));

    /**
     * Filters the responses from the snap requests into successful resolutions and errors.
     */
    const resolutions = responses.filter(response => response.status === 'fulfilled' && response.value).flatMap(response => response.value.resolvedAddresses);
    return resolutions;
  }, [getAvailableSnaps]);
  return {
    fetchResolutions
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\snaps\\useSnapNameResolution.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\snaps\\useSnapNavigation.ts", {"../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","react-router-dom-v5-compat":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom-v5-compat\\dist\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Csnaps%5CuseSnapNavigation.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _snapsUtils = require("@metamask/snaps-utils");
var _util = require("../../helpers/utils/util");
const useSnapNavigation = () => {
  const navigate = (0, _reactRouterDomV5Compat.useNavigate)();
  const useSnapNavigate = url => {
    let path;
    const linkData = (0, _snapsUtils.parseMetaMaskUrl)(url);
    if (linkData.snapId) {
      path = (0, _util.getSnapRoute)(linkData.snapId);
    } else {
      path = linkData.path;
    }
    navigate(path);
  };
  return {
    useSnapNavigate
  };
};
var _default = exports.default = useSnapNavigation;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\snaps\\useSnapNavigation.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\snaps\\useSnapSettings.ts", {"../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Csnaps%5CuseSnapSettings.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSnapSettings = useSnapSettings;
var _react = require("react");
var _reactRedux = require("react-redux");
var _actions = require("../../store/actions");
function useSnapSettings({
  snapId
}) {
  const dispatch = (0, _reactRedux.useDispatch)();
  const [loading, setLoading] = (0, _react.useState)(true);
  const [data, setData] = (0, _react.useState)(undefined);
  const [error, setError] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    let cancelled = false;
    async function fetchPage(id) {
      try {
        setError(undefined);
        setLoading(true);
        const newData = await (0, _actions.handleSnapRequest)({
          snapId: id,
          origin: 'metamask',
          handler: 'onSettingsPage',
          request: {
            jsonrpc: '2.0',
            method: ' '
          }
        });
        if (!cancelled) {
          setData(newData);
          (0, _actions.forceUpdateMetamaskState)(dispatch);
        }
      } catch (err) {
        if (!cancelled) {
          setError(err);
        }
      } finally {
        if (!cancelled) {
          setLoading(false);
        }
      }
    }
    if (snapId) {
      fetchPage(snapId);
    }
    return () => {
      cancelled = true;
    };
  }, [snapId]);
  return {
    data,
    error,
    loading
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\snaps\\useSnapSettings.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\social-sync\\useSyncSRPs.ts", {"../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Csocial-sync%5CuseSyncSRPs.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSyncSRPs = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _loglevel = _interopRequireDefault(require("loglevel"));
var _actions = require("../../store/actions");
var _selectors = require("../../selectors");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const useSyncSRPs = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const isSocialLoginFlow = (0, _reactRedux.useSelector)(_selectors.getIsSocialLoginFlow);
  const [loading, setLoading] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    (async () => {
      if (!isSocialLoginFlow) {
        return;
      }
      try {
        setLoading(true);
        await dispatch((0, _actions.syncSeedPhrases)());
      } catch (error) {
        _loglevel.default.error('[useSyncSRPs] error', error);
      } finally {
        setLoading(false);
      }
    })();
  }, [dispatch, isSocialLoginFlow]);
  return {
    loading
  };
};
exports.useSyncSRPs = useSyncSRPs;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\social-sync\\useSyncSRPs.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\subscription\\useSubscription.ts", {"../../../shared/lib/shield":"D:\\code\\v\\metamask-extension\\shared\\lib\\shield.ts","../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../selectors/identity/authentication":"D:\\code\\v\\metamask-extension\\ui\\selectors\\identity\\authentication.ts","../../selectors/subscription":"D:\\code\\v\\metamask-extension\\ui\\selectors\\subscription\\index.ts","../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../useAsync":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAsync.ts","@metamask/subscription-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\subscription-controller\\dist\\index.cjs","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Csubscription%5CuseSubscription.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUserSubscriptions = exports.useUserSubscriptionByProduct = exports.useUpdateSubscriptionCardPaymentMethod = exports.useUnCancelSubscription = exports.useSubscriptionEligibility = exports.useOpenGetSubscriptionBillingPortal = exports.useCancelSubscription = void 0;
var _reactRedux = require("react-redux");
var _react = require("react");
var _subscriptionController = require("@metamask/subscription-controller");
var _loglevel = _interopRequireDefault(require("loglevel"));
var _subscription = require("../../selectors/subscription");
var _actions = require("../../store/actions");
var _useAsync = require("../useAsync");
var _authentication = require("../../selectors/identity/authentication");
var _metamask = require("../../ducks/metamask/metamask");
var _shield = require("../../../shared/lib/shield");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const useUserSubscriptions = ({
  refetch
} = {
  refetch: false
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const isSignedIn = (0, _reactRedux.useSelector)(_authentication.selectIsSignedIn);
  const isUnlocked = (0, _reactRedux.useSelector)(_metamask.getIsUnlocked);
  const {
    customerId,
    subscriptions,
    trialedProducts
  } = (0, _reactRedux.useSelector)(_subscription.getUserSubscriptions);
  const result = (0, _useAsync.useAsyncResult)(async () => {
    if (!isSignedIn || !refetch || !isUnlocked) {
      return undefined;
    }
    return await dispatch((0, _actions.getSubscriptions)());
  }, [refetch, dispatch, isSignedIn, isUnlocked]);
  return {
    customerId,
    subscriptions,
    trialedProducts,
    loading: result.pending,
    error: result.error
  };
};
exports.useUserSubscriptions = useUserSubscriptions;
const useUserSubscriptionByProduct = (product, subscriptions) => {
  return (0, _react.useMemo)(() => subscriptions === null || subscriptions === void 0 ? void 0 : subscriptions.find(subscription => subscription.products.some(p => p.name === product)), [subscriptions, product]);
};
exports.useUserSubscriptionByProduct = useUserSubscriptionByProduct;
const useCancelSubscription = ({
  subscriptionId
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  return (0, _useAsync.useAsyncCallback)(async () => {
    if (!subscriptionId) {
      return;
    }
    await dispatch((0, _actions.cancelSubscription)({
      subscriptionId
    }));
  }, [dispatch, subscriptionId]);
};
exports.useCancelSubscription = useCancelSubscription;
const useUnCancelSubscription = ({
  subscriptionId
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  return (0, _useAsync.useAsyncCallback)(async () => {
    if (!subscriptionId) {
      return;
    }
    await dispatch((0, _actions.unCancelSubscription)({
      subscriptionId
    }));
  }, [dispatch, subscriptionId]);
};
exports.useUnCancelSubscription = useUnCancelSubscription;
const useOpenGetSubscriptionBillingPortal = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  return (0, _useAsync.useAsyncCallback)(async () => {
    const {
      url
    } = await dispatch((0, _actions.getSubscriptionBillingPortalUrl)());
    return await platform.openTab({
      url
    });
  }, [dispatch]);
};
exports.useOpenGetSubscriptionBillingPortal = useOpenGetSubscriptionBillingPortal;
const useUpdateSubscriptionCardPaymentMethod = ({
  subscriptionId,
  recurringInterval
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  return (0, _useAsync.useAsyncCallback)(async () => {
    if (!subscriptionId || !recurringInterval) {
      throw new Error('Subscription ID and recurring interval are required');
    }
    await dispatch((0, _actions.updateSubscriptionCardPaymentMethod)({
      subscriptionId,
      paymentType: _subscriptionController.PAYMENT_TYPES.byCard,
      recurringInterval
    }));
  }, [dispatch, subscriptionId, recurringInterval]);
};

/**
 * Hook to get the eligibility of a subscription for a given product.
 *
 * @param product - The product to get the eligibility for.
 * @returns An object with the getSubscriptionEligibility function.
 */
exports.useUpdateSubscriptionCardPaymentMethod = useUpdateSubscriptionCardPaymentMethod;
const useSubscriptionEligibility = product => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const isSignedIn = (0, _reactRedux.useSelector)(_authentication.selectIsSignedIn);
  const isUnlocked = (0, _reactRedux.useSelector)(_metamask.getIsUnlocked);
  const getSubscriptionEligibility = (0, _react.useCallback)(async () => {
    try {
      // if user is not signed in or unlocked, return undefined
      if (!isSignedIn || !isUnlocked) {
        return undefined;
      }

      // get the subscriptions before making the eligibility request
      // here, we cannot `useUserSubscriptions` hook as the hook's initial state has empty subscriptions array and loading state is false
      // that mistakenly makes `user does not have a subscription` and triggers the eligibility request
      const subscriptions = await dispatch((0, _actions.getSubscriptions)());
      const isShieldSubscriptionActive = (0, _shield.getIsShieldSubscriptionActive)(subscriptions);
      if (!isShieldSubscriptionActive) {
        // only if shield subscription is not active, get the eligibility
        const eligibilities = await dispatch((0, _actions.getSubscriptionsEligibilities)());
        return eligibilities.find(eligibility => eligibility.product === product);
      }
      return undefined;
    } catch (error) {
      _loglevel.default.error('[useSubscriptionEligibility] error', error);
      return undefined;
    }
  }, [isSignedIn, isUnlocked, dispatch, product]);
  return {
    getSubscriptionEligibility
  };
};
exports.useSubscriptionEligibility = useSubscriptionEligibility;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\subscription\\useSubscription.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\subscription\\useSubscriptionPricing.ts", {"../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../selectors/assets":"D:\\code\\v\\metamask-extension\\ui\\selectors\\assets.ts","../../selectors/subscription":"D:\\code\\v\\metamask-extension\\ui\\selectors\\subscription\\index.ts","../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","../useAsync":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAsync.ts","../useTokenBalances":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTokenBalances.ts","@metamask/subscription-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\subscription-controller\\dist\\index.cjs","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5Csubscription%5CuseSubscriptionPricing.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSubscriptionProductPlans = exports.useSubscriptionPricing = exports.useSubscriptionPaymentMethods = exports.useShieldSubscriptionPricingFromTokenApproval = exports.useAvailableTokenBalances = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _loglevel = _interopRequireDefault(require("loglevel"));
var _subscriptionController = require("@metamask/subscription-controller");
var _subscription = require("../../selectors/subscription");
var _actions = require("../../store/actions");
var _selectors = require("../../selectors");
var _assets = require("../../selectors/assets");
var _useTokenBalances = require("../useTokenBalances");
var _transaction = require("../../../shared/constants/transaction");
var _useAsync = require("../useAsync");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const useAvailableTokenBalances = params => {
  const {
    paymentChains,
    price,
    productType
  } = params;
  const paymentChainIds = (0, _react.useMemo)(() => paymentChains === null || paymentChains === void 0 ? void 0 : paymentChains.map(chain => chain.chainId), [paymentChains]);
  const paymentChainTokenMap = (0, _react.useMemo)(() => paymentChains === null || paymentChains === void 0 ? void 0 : paymentChains.reduce((acc, chain) => {
    acc[chain.chainId] = chain.tokens;
    return acc;
  }, {}), [paymentChains]);
  const selectedAccount = (0, _reactRedux.useSelector)(_selectors.getSelectedAccount);
  const evmBalances = (0, _reactRedux.useSelector)(state => (0, _assets.getTokenBalancesEvm)(state, selectedAccount.address));

  // Poll and update evm balances for payment chains
  (0, _useTokenBalances.useTokenBalances)({
    chainIds: paymentChainIds
  });
  const [availableTokenBalances, setAvailableTokenBalances] = (0, _react.useState)([]);
  const validTokenBalances = (0, _react.useMemo)(() => {
    return evmBalances.filter(token => {
      const supportedTokensForChain = paymentChainTokenMap === null || paymentChainTokenMap === void 0 ? void 0 : paymentChainTokenMap[token.chainId];
      const isSupportedChain = Boolean(supportedTokensForChain);
      if (!isSupportedChain) {
        return false;
      }
      const isSupportedToken = supportedTokensForChain === null || supportedTokensForChain === void 0 ? void 0 : supportedTokensForChain.some(t => t.address.toLowerCase() === token.address.toLowerCase());
      if (!isSupportedToken) {
        return false;
      }
      const hasBalance = token.balance && parseFloat(token.balance) > 0;
      if (!hasBalance) {
        return false;
      }
      return true;
    });
  }, [evmBalances, paymentChainTokenMap]);
  (0, _react.useEffect)(() => {
    if (!price || !paymentChainTokenMap) {
      return;
    }
    const getAvailableTokenBalances = async () => {
      const availableTokens = [];
      const cryptoApprovalAmounts = await Promise.all(validTokenBalances.map(token => {
        var _paymentChainTokenMap;
        const tokenPaymentInfo = paymentChainTokenMap === null || paymentChainTokenMap === void 0 || (_paymentChainTokenMap = paymentChainTokenMap[token.chainId]) === null || _paymentChainTokenMap === void 0 ? void 0 : _paymentChainTokenMap.find(t => t.address.toLowerCase() === token.address.toLowerCase());
        if (!tokenPaymentInfo) {
          _loglevel.default.error('[useAvailableTokenBalances] tokenPaymentInfo not found', token);
          return null;
        }
        return (0, _actions.getSubscriptionCryptoApprovalAmount)({
          chainId: token.chainId,
          paymentTokenAddress: token.address,
          productType,
          interval: price.interval
        });
      }));
      cryptoApprovalAmounts.forEach((amount, index) => {
        const token = validTokenBalances[index];
        if (!token.balance) {
          return;
        }
        // NOTE: we are using stable coin for subscription atm, so we need to scale the balance by the decimals
        const scaledFactor = 10n ** 6n;
        const scaledBalance = BigInt(Math.round(Number(token.balance) * Number(scaledFactor))) / scaledFactor;
        const tokenHasEnoughBalance = amount && scaledBalance * BigInt(10 ** token.decimals) >= BigInt(amount.approveAmount);
        if (tokenHasEnoughBalance) {
          availableTokens.push({
            ...token,
            approvalAmount: {
              approveAmount: amount.approveAmount,
              chainId: token.chainId,
              paymentAddress: amount.paymentAddress,
              paymentTokenAddress: amount.paymentTokenAddress
            },
            type: token.isNative ? _transaction.AssetType.native : _transaction.AssetType.token
          });
        }
      });
      setAvailableTokenBalances(availableTokens);
    };
    getAvailableTokenBalances();
  }, [price, productType, paymentChainTokenMap, validTokenBalances]);
  return availableTokenBalances;
};
exports.useAvailableTokenBalances = useAvailableTokenBalances;
const useSubscriptionPricing = ({
  refetch
} = {
  refetch: false
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const subscriptionPricing = (0, _reactRedux.useSelector)(_subscription.getSubscriptionPricing);
  const {
    pending,
    error
  } = (0, _useAsync.useAsyncResult)(async () => {
    if (!refetch) {
      return undefined;
    }
    return await dispatch((0, _actions.getSubscriptionPricing)());
  }, [dispatch, refetch]);
  return {
    subscriptionPricing,
    loading: pending,
    error
  };
};
exports.useSubscriptionPricing = useSubscriptionPricing;
const useSubscriptionProductPlans = (productType, pricing) => {
  return (0, _react.useMemo)(() => {
    var _pricing$products$fin;
    return pricing === null || pricing === void 0 || (_pricing$products$fin = pricing.products.find(product => product.name === productType)) === null || _pricing$products$fin === void 0 ? void 0 : _pricing$products$fin.prices;
  }, [pricing, productType]);
};
exports.useSubscriptionProductPlans = useSubscriptionProductPlans;
const useSubscriptionPaymentMethods = (paymentType, pricing) => {
  return (0, _react.useMemo)(() => pricing === null || pricing === void 0 ? void 0 : pricing.paymentMethods.find(paymentMethod => paymentMethod.type === paymentType), [pricing, paymentType]);
};

/**
 * Use this hook to get the shield subscription price derived from transaction data.
 *
 * @param params - The parameters for the hook.
 * @param params.transactionMeta - The transaction meta.
 * @param params.decodedApprovalAmount - The decoded approval amount.
 * @returns The product price.
 */
exports.useSubscriptionPaymentMethods = useSubscriptionPaymentMethods;
const useShieldSubscriptionPricingFromTokenApproval = ({
  transactionMeta,
  decodedApprovalAmount
}) => {
  const {
    subscriptionPricing
  } = useSubscriptionPricing();
  const pricingPlans = useSubscriptionProductPlans(_subscriptionController.PRODUCT_TYPES.SHIELD, subscriptionPricing);
  const cryptoPaymentMethod = useSubscriptionPaymentMethods(_subscriptionController.PAYMENT_TYPES.byCrypto, subscriptionPricing);
  const selectedTokenPrice = (0, _react.useMemo)(() => {
    var _cryptoPaymentMethod$;
    return cryptoPaymentMethod === null || cryptoPaymentMethod === void 0 || (_cryptoPaymentMethod$ = cryptoPaymentMethod.chains) === null || _cryptoPaymentMethod$ === void 0 || (_cryptoPaymentMethod$ = _cryptoPaymentMethod$.find(chain => chain.chainId.toLowerCase() === (transactionMeta === null || transactionMeta === void 0 ? void 0 : transactionMeta.chainId.toLowerCase()))) === null || _cryptoPaymentMethod$ === void 0 ? void 0 : _cryptoPaymentMethod$.tokens.find(token => {
      var _transactionMeta$txPa;
      return token.address.toLowerCase() === (transactionMeta === null || transactionMeta === void 0 || (_transactionMeta$txPa = transactionMeta.txParams) === null || _transactionMeta$txPa === void 0 || (_transactionMeta$txPa = _transactionMeta$txPa.to) === null || _transactionMeta$txPa === void 0 ? void 0 : _transactionMeta$txPa.toLowerCase());
    });
  }, [cryptoPaymentMethod, transactionMeta]);

  // need to do async here since `getSubscriptionCryptoApprovalAmount` make call to background script
  const {
    value: productPrice,
    pending
  } = (0, _useAsync.useAsyncResult)(async () => {
    if (selectedTokenPrice) {
      const params = {
        chainId: transactionMeta === null || transactionMeta === void 0 ? void 0 : transactionMeta.chainId,
        paymentTokenAddress: selectedTokenPrice.address,
        productType: _subscriptionController.PRODUCT_TYPES.SHIELD
      };
      // Get all intervals from RECURRING_INTERVALS
      const intervals = Object.values(_subscriptionController.RECURRING_INTERVALS);

      // Fetch approval amounts for all intervals
      const approvalAmounts = await Promise.all(intervals.map(interval => (0, _actions.getSubscriptionCryptoApprovalAmount)({
        ...params,
        interval
      })));

      // Find the matching plan by comparing approval amounts
      for (let i = 0; i < approvalAmounts.length; i++) {
        var _approvalAmounts$i;
        if (((_approvalAmounts$i = approvalAmounts[i]) === null || _approvalAmounts$i === void 0 ? void 0 : _approvalAmounts$i.approveAmount) === decodedApprovalAmount) {
          return pricingPlans === null || pricingPlans === void 0 ? void 0 : pricingPlans.find(plan => plan.interval === intervals[i]);
        }
      }
    }
    return undefined;
  }, [transactionMeta, selectedTokenPrice, decodedApprovalAmount, pricingPlans]);
  return {
    productPrice,
    pending
  };
};
exports.useShieldSubscriptionPricingFromTokenApproval = useShieldSubscriptionPricingFromTokenApproval;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\subscription\\useSubscriptionPricing.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useAccountGroupsForPermissions.ts", {"../../shared/lib/multichain/scope-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\multichain\\scope-utils.ts","../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","@metamask/chain-agnostic-permission":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\chain-agnostic-permission\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseAccountGroupsForPermissions.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAccountGroupsForPermissions = exports.supportsNamespaces = exports.supportsChainIds = exports.hasRequestedAccountIds = void 0;
var _reactRedux = require("react-redux");
var _chainAgnosticPermission = require("@metamask/chain-agnostic-permission");
var _react = require("react");
var _accountTree = require("../selectors/multichain-accounts/account-tree");
var _scopeUtils = require("../../shared/lib/multichain/scope-utils");
/**
 * Checks if an account group has any connected accounts
 *
 * @param accountGroup - Account group to check for connected accounts
 * @param connectedAddresses - Array of connected account addresses
 * @returns True if any account in the group is connected
 */
const hasConnectedAccounts = (accountGroup, connectedAddresses) => {
  return accountGroup.accounts.some(account => {
    try {
      return (0, _chainAgnosticPermission.isInternalAccountInPermittedAccountIds)(account, connectedAddresses);
    } catch {
      return false;
    }
  });
};

/**
 * Checks if an account group supports the requested chain IDs
 *
 * @param accountGroup - Account group to check for chain ID support
 * @param requestedChainIds - Array of requested chain IDs to match against
 * @returns True if any account in the group supports the requested chain IDs
 */
const supportsChainIds = (accountGroup, requestedChainIds) => {
  return accountGroup.accounts.some(account => (0, _scopeUtils.hasChainIdSupport)(account.scopes, requestedChainIds));
};

/**
 * Checks if an account group supports the requested namespaces
 *
 * @param accountGroup - Account group to check for namespace support
 * @param requestedNamespaces - Set of requested namespaces to match against
 * @returns True if any account in the group supports the requested namespaces
 */
exports.supportsChainIds = supportsChainIds;
const supportsNamespaces = (accountGroup, requestedNamespaces) => {
  return accountGroup.accounts.some(account => (0, _scopeUtils.hasNamespaceSupport)(account.scopes, requestedNamespaces));
};

/**
 * Checks if an account group contains any of the requested account IDs
 *
 * @param accountGroup - Account group to check for requested account IDs
 * @param requestedAccountIds - Array of requested account IDs to match against
 * @returns True if any account in the group matches the requested account IDs
 */
exports.supportsNamespaces = supportsNamespaces;
const hasRequestedAccountIds = (accountGroup, requestedAccountIds) => {
  return accountGroup.accounts.some(account => {
    try {
      return (0, _chainAgnosticPermission.isInternalAccountInPermittedAccountIds)(account, requestedAccountIds);
    } catch {
      return false;
    }
  });
};

/**
 * Hook that manages account groups for CAIP-25 permissions, providing both connected
 * and supported account groups based on existing permissions, requested chains/namespaces,
 * and specific account IDs with prioritization support.
 *
 * This hook handles the complex logic of:
 * - Filtering account groups that support requested chains/namespaces
 * - Prioritizing account groups that fulfill specific requested account IDs
 * - Mapping existing CAIP-25 permissions to account groups
 * - Converting between different account ID formats
 * - Preventing duplicate account groups in results
 *
 * @param existingPermission - The current CAIP-25 caveat value containing existing permissions
 * @param requestedCaipAccountIds - Array of specific CAIP account IDs being requested (prioritized in results)
 * @param requestedCaipChainIds - Array of CAIP chain IDs being requested for permission
 * @param requestedNamespacesWithoutWallet - Array of CAIP namespaces being requested (excluding wallet namespace)
 * @returns Object containing connected account groups, supported account groups, and existing connected CAIP account IDs.
 * Account groups that fulfill requestedCaipAccountIds appear first in both arrays.
 */
exports.hasRequestedAccountIds = hasRequestedAccountIds;
const useAccountGroupsForPermissions = (existingPermission, requestedCaipAccountIds, requestedCaipChainIds, requestedNamespacesWithoutWallet) => {
  const selectedAccountGroupId = (0, _reactRedux.useSelector)(_accountTree.getSelectedAccountGroup);
  const accountGroups = (0, _reactRedux.useSelector)(_accountTree.getAccountGroupWithInternalAccounts);
  const result = (0, _react.useMemo)(() => {
    const selectedAccountGroup = accountGroups.find(accountGroup => accountGroup.id === selectedAccountGroupId);
    const connectedAccountIds = (0, _chainAgnosticPermission.getCaipAccountIdsFromCaip25CaveatValue)(existingPermission);
    const requestedNamespaceSet = new Set(requestedNamespacesWithoutWallet);
    let accountGroupsToProcess = accountGroups;
    if (selectedAccountGroup) {
      accountGroupsToProcess = Array.from(new Set([selectedAccountGroup, ...accountGroups]));
    }
    const isConnected = accountGroup => hasConnectedAccounts(accountGroup, connectedAccountIds);
    const isSupported = accountGroup => requestedCaipChainIds.length > 0 ? supportsChainIds(accountGroup, requestedCaipChainIds) : supportsNamespaces(accountGroup, requestedNamespaceSet);
    const fulfillsRequestedAccounts = accountGroup => hasRequestedAccountIds(accountGroup, requestedCaipAccountIds);

    // Account groups that are currently connected via existing permissions (non-priority)
    const connectedAccountGroups = accountGroupsToProcess.filter(isConnected);
    // Account groups that support the requested chains/namespaces (non-priority)
    const supportedAccountGroups = accountGroupsToProcess.filter(accountGroup => isSupported(accountGroup) && !fulfillsRequestedAccounts(accountGroup));
    // Priority groups are groups that fulfill the requested account IDs and should be shown first
    // Connected account groups that contain accounts matching the specifically requested account IDs
    const priorityConnectedGroups = accountGroupsToProcess.filter(accountGroup => isConnected(accountGroup) && fulfillsRequestedAccounts(accountGroup));
    // Supported account groups that contain accounts matching the specifically requested account IDs
    const prioritySupportedGroups = accountGroupsToProcess.filter(accountGroup => isSupported(accountGroup) && fulfillsRequestedAccounts(accountGroup));
    // Account groups that are either connected OR fulfill the requested account IDs (used for scope calculations)
    const connectedAndRequestedAccountGroups = accountGroupsToProcess.filter(accountGroup => isConnected(accountGroup) || fulfillsRequestedAccounts(accountGroup));

    // These are caip account ids of connected account groups with the requested chains/namespaces
    const caipAccountIdsOfConnectedAndRequestedAccountGroups = Array.from(new Set([...(0, _scopeUtils.getCaip25AccountIdsFromAccountGroupAndScope)(connectedAndRequestedAccountGroups, requestedCaipChainIds)]));

    // Determine which account groups to include based on priority and availability
    const hasPriorityGroups = prioritySupportedGroups.length > 0;
    const hasSupportedGroups = supportedAccountGroups.length > 0;
    let fallbackAccountGroups = [];
    if (!hasPriorityGroups && hasSupportedGroups) {
      // Only include fallback groups when there are no priority groups
      // Use selectedAccountGroup if it supports the request, otherwise use first supported group
      const selectedSupportsRequest = selectedAccountGroup && (requestedCaipChainIds.length > 0 ? supportsChainIds(selectedAccountGroup, requestedCaipChainIds) : supportsNamespaces(selectedAccountGroup, requestedNamespaceSet));
      const fallbackGroup = selectedSupportsRequest ? selectedAccountGroup : supportedAccountGroups[0];
      if (fallbackGroup) {
        fallbackAccountGroups = [fallbackGroup];
      }
    }

    // Combine priority groups with fallback groups (if any) and remove duplicates
    const selectedAndRequestedAccountGroups = new Set([...prioritySupportedGroups, ...fallbackAccountGroups]);
    return {
      selectedAndRequestedAccountGroups: Array.from(selectedAndRequestedAccountGroups),
      supportedAccountGroups: Array.from(new Set([...prioritySupportedGroups, ...supportedAccountGroups])),
      connectedAccountGroups: Array.from(new Set([...priorityConnectedGroups, ...connectedAccountGroups])),
      connectedCaipAccountIds: connectedAccountIds,
      connectedAccountGroupWithRequested: Array.from(new Set(connectedAndRequestedAccountGroups)),
      caipAccountIdsOfConnectedAndRequestedAccountGroups
    };
  }, [accountGroups, existingPermission, requestedNamespacesWithoutWallet, requestedCaipChainIds, selectedAccountGroupId, requestedCaipAccountIds]);
  return {
    /** Account groups that are currently connected via existing permissions */
    connectedAccountGroups: result.connectedAccountGroups,
    /** Account groups that support the requested chains/namespaces */
    supportedAccountGroups: result.supportedAccountGroups,
    /** CAIP account IDs that are already connected via existing permissions */
    existingConnectedCaipAccountIds: result.connectedCaipAccountIds,
    /** Account groups that fulfill the requested account IDs */
    connectedAccountGroupWithRequested: result.connectedAccountGroupWithRequested,
    /** CAIP account IDs that should be connected */
    caipAccountIdsOfConnectedAndRequestedAccountGroups: result.caipAccountIdsOfConnectedAndRequestedAccountGroups,
    /** Account groups that support the requested chains/namespaces incl the selected account group if not already requested */
    selectedAndRequestedAccountGroups: result.selectedAndRequestedAccountGroups
  };
};
exports.useAccountGroupsForPermissions = useAccountGroupsForPermissions;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useAccountGroupsForPermissions.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useAccountTotalCrossChainFiatBalance.ts", {"../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../helpers/utils/token-util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\token-util.js","../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","ethereumjs-util":"D:\\code\\v\\metamask-extension\\node_modules\\ethereumjs-util\\dist.browser\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseAccountTotalCrossChainFiatBalance.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAccountTotalCrossChainFiatBalance = void 0;
var _reactRedux = require("react-redux");
var _ethereumjsUtil = require("ethereumjs-util");
var _react = require("react");
var _metamask = require("../ducks/metamask/metamask");
var _selectors = require("../selectors");
var _conversion = require("../../shared/modules/conversion.utils");
var _tokenUtil = require("../helpers/utils/token-util");
var _networks = require("../../shared/modules/selectors/networks");
var _network = require("../../shared/constants/network");
const useAccountTotalCrossChainFiatBalance = (account, formattedTokensWithBalancesPerChain) => {
  const allNetworks = (0, _reactRedux.useSelector)(_networks.getNetworkConfigurationsByChainId);
  const selectedEnabledNetworks = (0, _reactRedux.useSelector)(_selectors.getEnabledNetworks);
  const enabledNetworksByNamespace = (0, _react.useMemo)(() => Object.assign({}, ...Object.values(selectedEnabledNetworks ?? {})), [selectedEnabledNetworks]);
  const currencyRates = (0, _reactRedux.useSelector)(_metamask.getCurrencyRates);
  const currentCurrency = (0, _reactRedux.useSelector)(_metamask.getCurrentCurrency);
  const crossChainContractRates = (0, _reactRedux.useSelector)(_selectors.getCrossChainTokenExchangeRates, _reactRedux.shallowEqual);
  const crossChainCachedBalances = (0, _reactRedux.useSelector)(_selectors.getCrossChainMetaMaskCachedBalances);
  const mergedCrossChainRates = (0, _react.useMemo)(() => ({
    ...crossChainContractRates // todo add confirmation exchange rates?
  }), [crossChainContractRates]);
  const filteredBalances = (0, _react.useMemo)(() => {
    return formattedTokensWithBalancesPerChain.map(balances => {
      if (Object.keys(enabledNetworksByNamespace).includes(balances.chainId.toString())) {
        return balances;
      }
      return null;
    }).filter(balance => balance !== null);
  }, [formattedTokensWithBalancesPerChain, enabledNetworksByNamespace]);
  const tokenFiatBalancesCrossChains = (0, _react.useMemo)(() => filteredBalances.map(singleChainTokenBalances => {
    var _currencyRates$matche, _crossChainCachedBala;
    const {
      tokensWithBalances
    } = singleChainTokenBalances;
    // Attempt to use known currency symbols in map
    // Otherwise fallback to user defined currency
    const matchedChainSymbol = _network.CHAIN_ID_TO_CURRENCY_SYMBOL_MAP[singleChainTokenBalances.chainId] ?? allNetworks[singleChainTokenBalances.chainId].nativeCurrency;
    const conversionRate = currencyRates === null || currencyRates === void 0 || (_currencyRates$matche = currencyRates[matchedChainSymbol]) === null || _currencyRates$matche === void 0 ? void 0 : _currencyRates$matche.conversionRate;
    const tokenFiatBalances = tokensWithBalances.map(token => {
      var _mergedCrossChainRate;
      const tokenExchangeRate = mergedCrossChainRates === null || mergedCrossChainRates === void 0 || (_mergedCrossChainRate = mergedCrossChainRates[singleChainTokenBalances.chainId]) === null || _mergedCrossChainRate === void 0 ? void 0 : _mergedCrossChainRate[(0, _ethereumjsUtil.toChecksumAddress)(token.address)];
      const totalFiatValue = (0, _tokenUtil.getTokenFiatAmount)(tokenExchangeRate, conversionRate, currentCurrency, token.string, token.symbol, false, false);
      return totalFiatValue;
    });
    const balanceCached = (crossChainCachedBalances === null || crossChainCachedBalances === void 0 || (_crossChainCachedBala = crossChainCachedBalances[singleChainTokenBalances.chainId]) === null || _crossChainCachedBala === void 0 ? void 0 : _crossChainCachedBala[account === null || account === void 0 ? void 0 : account.address]) ?? 0;
    const nativeFiatValue = (0, _conversion.getValueFromWeiHex)({
      value: balanceCached,
      toCurrency: currentCurrency,
      conversionRate,
      numberOfDecimals: 2
    });
    return {
      ...singleChainTokenBalances,
      tokenFiatBalances,
      nativeFiatValue
    };
  }), [filteredBalances, allNetworks, currencyRates, mergedCrossChainRates, crossChainCachedBalances, account === null || account === void 0 ? void 0 : account.address, currentCurrency]);
  const finalTotal = (0, _react.useMemo)(() => tokenFiatBalancesCrossChains.reduce((accumulator, currentValue) => {
    const tmpCurrentValueFiatBalances = currentValue.tokenFiatBalances.filter(value => value !== undefined);
    const totalFiatBalance = (0, _conversion.sumDecimals)(currentValue.nativeFiatValue, ...tmpCurrentValueFiatBalances);
    const totalAsNumber = totalFiatBalance.toNumber ? totalFiatBalance.toNumber() : Number(totalFiatBalance);
    return accumulator + totalAsNumber;
  }, 0), [tokenFiatBalancesCrossChains]);
  return {
    totalFiatBalance: finalTotal.toString(10),
    tokenFiatBalancesCrossChains
  };
};
exports.useAccountTotalCrossChainFiatBalance = useAccountTotalCrossChainFiatBalance;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useAccountTotalCrossChainFiatBalance.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useAccountTotalFiatBalance.js", {"../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../helpers/utils/confirm-tx.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\confirm-tx.util.ts","../helpers/utils/token-util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\token-util.js","../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","./useTokenBalances":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTokenBalances.ts","ethereumjs-util":"D:\\code\\v\\metamask-extension\\node_modules\\ethereumjs-util\\dist.browser\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseAccountTotalFiatBalance.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAccountTotalFiatBalance = void 0;
var _reactRedux = require("react-redux");
var _ethereumjsUtil = require("ethereumjs-util");
var _react = require("react");
var _networks = require("../../shared/modules/selectors/networks");
var _selectors = require("../selectors");
var _conversion = require("../../shared/modules/conversion.utils");
var _metamask = require("../ducks/metamask/metamask");
var _confirmTx = require("../helpers/utils/confirm-tx.util");
var _tokenUtil = require("../helpers/utils/token-util");
var _util = require("../helpers/utils/util");
var _useTokenBalances = require("./useTokenBalances");
const useAccountTotalFiatBalance = (account, shouldHideZeroBalanceTokens,
/**
 * The optional parameter to use USD conversion rate instead of the current currency.
 * If not provided, fallback to the current currency.
 */
useUSD = false) => {
  const currentChainId = (0, _reactRedux.useSelector)(_networks.getCurrentChainId);
  let conversionRate = (0, _reactRedux.useSelector)(_metamask.getConversionRate);
  const usdConversionRate = (0, _reactRedux.useSelector)(_selectors.getUSDConversionRate);
  let currentCurrency = (0, _reactRedux.useSelector)(_metamask.getCurrentCurrency);
  if (useUSD) {
    conversionRate = usdConversionRate;
    currentCurrency = 'usd';
  }
  const contractExchangeRates = (0, _reactRedux.useSelector)(_selectors.getTokenExchangeRates, _reactRedux.shallowEqual);
  const confirmationExchangeRates = (0, _reactRedux.useSelector)(_selectors.getConfirmationExchangeRates);
  const cachedBalances = (0, _reactRedux.useSelector)(_selectors.getMetaMaskCachedBalances);
  const balance = (cachedBalances === null || cachedBalances === void 0 ? void 0 : cachedBalances[account === null || account === void 0 ? void 0 : account.address]) ?? 0;
  const nativeFiat = (0, _conversion.getValueFromWeiHex)({
    value: balance,
    toCurrency: currentCurrency,
    conversionRate,
    numberOfDecimals: 2
  });
  const detectedTokens = (0, _reactRedux.useSelector)(_selectors.getAllTokens);
  const tokens = (0, _react.useMemo)(() => {
    var _detectedTokens$curre;
    return (detectedTokens === null || detectedTokens === void 0 || (_detectedTokens$curre = detectedTokens[currentChainId]) === null || _detectedTokens$curre === void 0 ? void 0 : _detectedTokens$curre[account === null || account === void 0 ? void 0 : account.address]) ?? [];
  }, [account === null || account === void 0 ? void 0 : account.address, currentChainId, detectedTokens]);
  // This selector returns all the tokens, we need it to get the image of token
  const allTokenList = (0, _reactRedux.useSelector)(_selectors.getTokenList);
  const primaryTokenImage = (0, _reactRedux.useSelector)(_selectors.getNativeCurrencyImage);
  const nativeCurrency = (0, _reactRedux.useSelector)(_metamask.getNativeCurrency);
  const loading = false;
  const {
    tokensWithBalances
  } = (0, _useTokenBalances.useTokenTracker)({
    chainId: currentChainId,
    tokens,
    address: account === null || account === void 0 ? void 0 : account.address,
    hideZeroBalanceTokens: shouldHideZeroBalanceTokens
  });
  const mergedRates = (0, _react.useMemo)(() => ({
    ...contractExchangeRates,
    ...confirmationExchangeRates
  }), [confirmationExchangeRates, contractExchangeRates]);

  // Create fiat values for token balances
  const tokenFiatBalances = (0, _react.useMemo)(() => tokensWithBalances.map(token => {
    const tokenExchangeRate = mergedRates[(0, _ethereumjsUtil.toChecksumAddress)(token.address)];
    const totalFiatValue = (0, _tokenUtil.getTokenFiatAmount)(tokenExchangeRate, conversionRate, currentCurrency, token.string, token.symbol, false, false);
    return totalFiatValue;
  }), [tokensWithBalances, mergedRates, conversionRate, currentCurrency]);

  // To match the list of detected tokens with the entire token list to find the image for tokens
  const findMatchingTokens = (tokenList, _tokensWithBalances) => {
    const result = [];
    _tokensWithBalances.forEach(token => {
      const matchingToken = tokenList === null || tokenList === void 0 ? void 0 : tokenList[token.address.toLowerCase()];
      if (matchingToken) {
        result.push({
          ...matchingToken,
          balance: token.balance,
          string: token.string,
          balanceError: token.balanceError
        });
      }
    });
    return result;
  };
  const matchingTokens = (0, _react.useMemo)(() => findMatchingTokens(allTokenList, tokensWithBalances), [allTokenList, tokensWithBalances]);

  // Combine native token, detected token with image in an array
  const allTokensWithFiatValues = (0, _react.useMemo)(() => {
    const nativeTokenValues = {
      iconUrl: primaryTokenImage,
      symbol: nativeCurrency,
      fiatBalance: nativeFiat
    };
    return [nativeTokenValues, ...matchingTokens.map((item, index) => ({
      ...item,
      fiatBalance: tokenFiatBalances[index]
    }))];
  }, [matchingTokens, tokenFiatBalances, primaryTokenImage, nativeCurrency, nativeFiat]);

  // Order of the tokens in this array is in decreasing order based on their fiatBalance
  const orderedTokenList = (0, _react.useMemo)(() => allTokensWithFiatValues.sort((a, b) => parseFloat(b.fiatBalance) - parseFloat(a.fiatBalance)), [allTokensWithFiatValues]);

  // Total native and token fiat balance as a string (ex: "8.90")
  const totalFiatBalance = (0, _conversion.sumDecimals)(nativeFiat, ...tokenFiatBalances).toString(10);
  const formattedTokensWithBalances = (0, _react.useMemo)(() => {
    // we need to append some values to tokensWithBalance for UI
    // this code was ported from asset-list
    tokensWithBalances.forEach(token => {
      // token.string is the balance displayed in the TokenList UI
      token.string = (0, _util.roundToDecimalPlacesRemovingExtraZeroes)(token.string, 5);

      // to sort by fiat balance, we need to compute this at this level
      const tokenExchangeRate = mergedRates[(0, _ethereumjsUtil.toChecksumAddress)(token.address)];
      token.tokenFiatAmount = (0, _tokenUtil.getTokenFiatAmount)(tokenExchangeRate, conversionRate, currentCurrency, token.string,
      // tokenAmount
      token.symbol,
      // tokenSymbol
      false,
      // no currency symbol prefix
      false // no ticker symbol suffix
      ) || '0';
    });
    return tokensWithBalances;
  }, [tokensWithBalances, mergedRates, conversionRate, currentCurrency]);

  // Fiat balance formatted in user's desired currency (ex: "$8.90")
  const formattedFiat = (0, _confirmTx.formatCurrency)(totalFiatBalance, currentCurrency);

  // WEI Number which can be used with UserPreferencedCurrencyDisplay component
  let totalWeiBalance = (0, _conversion.getWeiHexFromDecimalValue)({
    value: totalFiatBalance,
    fromCurrency: currentCurrency,
    conversionRate,
    invertConversionRate: true
  });

  // If we have a totalFiatBalance of "0" and conversionRate of "0",
  // getWeiHexFromDecimalValue responds with "NaN"
  if (totalWeiBalance === 'NaN') {
    totalWeiBalance = '0x0';
  }
  return {
    formattedFiat,
    totalWeiBalance,
    totalFiatBalance,
    tokensWithBalances: formattedTokensWithBalances,
    loading,
    orderedTokenList,
    mergedRates
  };
};
exports.useAccountTotalFiatBalance = useAccountTotalFiatBalance;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useAccountTotalFiatBalance.js",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useAccountTrackerPolling.ts", {"../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./useMultiPolling":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultiPolling.ts","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseAccountTrackerPolling.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactRedux = require("react-redux");
var _selectors = require("../selectors");
var _actions = require("../store/actions");
var _metamask = require("../ducks/metamask/metamask");
var _selectors2 = require("../selectors/selectors");
var _useMultiPolling = _interopRequireDefault(require("./useMultiPolling"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const useAccountTrackerPolling = () => {
  const networkClientIdsToPoll = (0, _reactRedux.useSelector)(_selectors.getNetworkClientIdsToPoll);
  const completedOnboarding = (0, _reactRedux.useSelector)(_metamask.getCompletedOnboarding);
  const isUnlocked = (0, _reactRedux.useSelector)(_metamask.getIsUnlocked);
  const enabledNetworkClientIds = (0, _reactRedux.useSelector)(_selectors.getEnabledNetworkClientIds);
  const canStartPolling = completedOnboarding && isUnlocked;
  const pollableNetworkClientIds = _selectors2.isGlobalNetworkSelectorRemoved ? enabledNetworkClientIds : networkClientIdsToPoll;
  (0, _useMultiPolling.default)({
    startPolling: _actions.accountTrackerStartPolling,
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    stopPollingByPollingToken: _actions.accountTrackerStopPollingByPollingToken,
    input: canStartPolling ? pollableNetworkClientIds : []
  });
};
var _default = exports.default = useAccountTrackerPolling;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useAccountTrackerPolling.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useAlerts.ts", {"../ducks/confirm-alerts/confirm-alerts":"D:\\code\\v\\metamask-extension\\ui\\ducks\\confirm-alerts\\confirm-alerts.ts","../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../selectors/alerts":"D:\\code\\v\\metamask-extension\\ui\\selectors\\alerts.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseAlerts.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactRedux = require("react-redux");
var _react = require("react");
var _alerts = require("../selectors/alerts");
var _confirmAlerts = require("../ducks/confirm-alerts/confirm-alerts");
var _designSystem = require("../helpers/constants/design-system");
const useAlerts = ownerId => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const alerts = sortAlertsBySeverity((0, _reactRedux.useSelector)(state => (0, _alerts.selectAlerts)(state, ownerId)));
  const confirmedAlertKeys = (0, _reactRedux.useSelector)(state => (0, _alerts.selectConfirmedAlertKeys)(state, ownerId));
  const generalAlerts = sortAlertsBySeverity((0, _reactRedux.useSelector)(state => (0, _alerts.selectGeneralAlerts)(state, ownerId)));
  const fieldAlerts = sortAlertsBySeverity((0, _reactRedux.useSelector)(state => (0, _alerts.selectFieldAlerts)(state, ownerId)));
  const getFieldAlerts = (0, _react.useCallback)(field => {
    if (!field) {
      return [];
    }
    return alerts.filter(alert => alert.field === field);
  }, [alerts]);
  const setAlertConfirmed = (0, _react.useCallback)((alertKey, isConfirmed) => {
    dispatch((0, _confirmAlerts.setAlertConfirmed)(ownerId, alertKey, isConfirmed));
  }, [dispatch, ownerId]);
  const isAlertConfirmed = (0, _react.useCallback)(alertKey => {
    return confirmedAlertKeys.includes(alertKey);
  }, [confirmedAlertKeys]);
  const unconfirmedDangerAlerts = alerts.filter(alert => !isAlertConfirmed(alert.key) && alert.severity === _designSystem.Severity.Danger);
  const hasAlerts = alerts.length > 0;
  const dangerAlerts = alerts.filter(alert => alert.severity === _designSystem.Severity.Danger);
  const hasUnconfirmedDangerAlerts = unconfirmedDangerAlerts.length > 0;
  const unconfirmedFieldDangerAlerts = fieldAlerts.filter(alert => !isAlertConfirmed(alert.key) && alert.severity === _designSystem.Severity.Danger);
  return {
    alerts,
    fieldAlerts,
    generalAlerts,
    getFieldAlerts,
    hasAlerts,
    dangerAlerts,
    hasDangerAlerts: (dangerAlerts === null || dangerAlerts === void 0 ? void 0 : dangerAlerts.length) > 0,
    hasUnconfirmedDangerAlerts,
    isAlertConfirmed,
    setAlertConfirmed,
    unconfirmedDangerAlerts,
    unconfirmedFieldDangerAlerts,
    hasUnconfirmedFieldDangerAlerts: unconfirmedFieldDangerAlerts.length > 0
  };
};
function sortAlertsBySeverity(alerts) {
  const severityOrder = {
    [_designSystem.Severity.Danger]: 3,
    [_designSystem.Severity.Warning]: 2,
    [_designSystem.Severity.Info]: 1,
    [_designSystem.Severity.Success]: 0
  };
  return alerts.sort((a, b) => severityOrder[b.severity] - severityOrder[a.severity]);
}
var _default = exports.default = useAlerts;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useAlerts.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useAssetsUpdateAllAccountBalances.ts", {"../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseAssetsUpdateAllAccountBalances.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAssetsUpdateAllAccountBalances = exports.default = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _selectors = require("../selectors");
var _actions = require("../store/actions");
/**
 * Assets hook to update balance state for ALL accounts when account lists are displayed.
 *
 * This hook ensures the Redux state contains current balance information for every account
 * across all enabled EVM networks, including both native currencies and tokens. This is
 * essential for account list components where users expect to see up-to-date balances
 * for all accounts without requiring manual interaction.
 *
 * The hook triggers TokenBalancesController.updateBalances() which is configured
 * with queryMultipleAccounts to update state for all accounts, not just the selected one.
 *
 * @returns Object containing updateBalances function for manual triggering if needed
 * @example
 * ```tsx
 * const AccountListComponent = () => {
 *
 *   useAssetsUpdateAllAccountBalances();
 *
 *   return <AccountList />;
 * };
 * ```
 */
const useAssetsUpdateAllAccountBalances = () => {
  const enabledChainIds = (0, _reactRedux.useSelector)(_selectors.getEnabledChainIds);
  const dispatch = (0, _reactRedux.useDispatch)();
  const updateBalances = (0, _react.useCallback)(async () => {
    try {
      if (enabledChainIds.length > 0) {
        // Update balance state for ALL accounts across all enabled EVM chains
        // TokenBalancesController is configured with queryMultipleAccounts: true
        // so this will update balances for all accounts, not just the selected one
        await dispatch((0, _actions.updateBalancesFoAccounts)(enabledChainIds, true));
      }
    } catch (error) {
      console.warn('Error updating balances state for all accounts', error);
    }
  }, [enabledChainIds, dispatch]);
  (0, _react.useEffect)(() => {
    if (enabledChainIds.length === 0) {
      return;
    } // wait until we have chain IDs

    updateBalances();
  }, [enabledChainIds, updateBalances]);
  return {
    updateBalances
  };
};
exports.useAssetsUpdateAllAccountBalances = useAssetsUpdateAllAccountBalances;
var _default = exports.default = useAssetsUpdateAllAccountBalances;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useAssetsUpdateAllAccountBalances.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useAsync.ts", {"react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseAsync.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RESULT_PENDING = exports.RESULT_IDLE = exports.RESULT_BASE = void 0;
exports.createErrorResult = createErrorResult;
exports.createSuccessResult = createSuccessResult;
exports.useAsyncCallback = useAsyncCallback;
exports.useAsyncResult = useAsyncResult;
exports.useAsyncResultOrThrow = useAsyncResultOrThrow;
var _react = require("react");
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention

/**
 * Composed types for different use cases
 */
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention

// Base object with common properties for all states
const RESULT_BASE = exports.RESULT_BASE = {
  idle: false,
  pending: false,
  value: undefined,
  error: undefined
};

// Singleton constants for stateless results
const RESULT_IDLE = exports.RESULT_IDLE = {
  ...RESULT_BASE,
  status: 'idle',
  idle: true
};
const RESULT_PENDING = exports.RESULT_PENDING = {
  ...RESULT_BASE,
  status: 'pending',
  pending: true
};
// Helper functions to create state objects
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function createSuccessResult(value) {
  return {
    ...RESULT_BASE,
    status: 'success',
    value
  };
}
function createErrorResult(error) {
  return {
    ...RESULT_BASE,
    status: 'error',
    error
  };
}

/**
 * Hook that provides a callback for manual execution of an async function,
 * along with state management for the operation.
 *
 * @param asyncFn - The async function to execute
 * @param deps - Dependencies that trigger recreation of the callback
 */
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function useAsyncCallback(asyncFn, deps = []) {
  const [result, setResult] = (0, _react.useState)(RESULT_IDLE);

  // Track component mount state
  const isMounted = (0, _react.useRef)(true);

  // Update ref when component unmounts
  (0, _react.useEffect)(() => {
    return () => {
      isMounted.current = false;
    };
  }, []);
  const execute = (0, _react.useCallback)(async () => {
    if (!isMounted.current) {
      return;
    }
    setResult(RESULT_PENDING);
    try {
      const value = await asyncFn();
      if (isMounted.current) {
        setResult(createSuccessResult(value));
      }
    } catch (error) {
      if (isMounted.current) {
        setResult(createErrorResult(error));
      }
    }
  }, deps);
  return [execute, result];
}

/**
 * Hook that executes an asynchronous function and returns its result
 * or an error (errors are caught and returned as part of the result).
 * Implemented in terms of useAsyncCallback.
 *
 * @param asyncFn - The async function to execute
 * @param deps - Dependencies that trigger re-execution
 */
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function useAsyncResult(asyncFn, deps = []) {
  const [execute, result] = useAsyncCallback(asyncFn, deps);
  (0, _react.useEffect)(() => {
    execute();
  }, [execute]);

  // When the result is in the idle state, return pending state instead
  // This is because we execute the asyncFn immediately on mount, so the component
  // should reflect a loading state rather than an idle one
  return result.status === 'idle' ? RESULT_PENDING : result;
}

/**
 * Hook that executes an asynchronous function and returns its result
 * or throws an error to be caught by a React error boundary.
 *
 * @param asyncFn - The async function to execute
 * @param deps - Dependencies that trigger re-execution of the async function
 * @returns The result of the async function if successful, or throws the error
 */
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function useAsyncResultOrThrow(asyncFn, deps = []) {
  const result = useAsyncResult(asyncFn, deps);
  if (result.status === 'error') {
    // Throw the error so it can be caught by a React error boundary.
    throw result.error;
  }

  // After throwing errors, we know the status can only be 'success' or 'pending'
  return result;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useAsync.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useCarouselManagement\\fetchCarouselSlidesFromContentful.ts", {"../../../package.json":"D:\\code\\v\\metamask-extension\\package.json","../../../shared/modules/environment":"D:\\code\\v\\metamask-extension\\shared\\modules\\environment.ts","semver":"D:\\code\\v\\metamask-extension\\node_modules\\semver\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseCarouselManagement%5CfetchCarouselSlidesFromContentful.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchCarouselSlidesFromContentful = fetchCarouselSlidesFromContentful;
exports.getContentfulEnvironmentDetails = void 0;
var _semver = _interopRequireDefault(require("semver"));
var _environment = require("../../../shared/modules/environment");
var _package = _interopRequireDefault(require("../../../package.json"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const APP_VERSION = _package.default.version;
const CONTENT_TYPE = 'promotionalBanner';
const getContentPreviewToken = () => {
  const urlParams = new URLSearchParams(window.location.search);
  const previewToken = urlParams.get('previewToken');
  return previewToken;
};
const getContentfulEnvironmentDetails = () => {
  const SPACE_ID = null ?? '';
  const ACCESS_TOKEN = null ?? '';

  // If preview mode, then show preview prod master content
  const previewToken = getContentPreviewToken();
  if (previewToken) {
    return {
      environment: 'master',
      domain: 'preview.contentful.com',
      accessToken: previewToken,
      spaceId: SPACE_ID
    };
  }
  const isProd = (0, _environment.isProduction)();

  // If production, show prod master content
  if (isProd) {
    return {
      environment: 'master',
      domain: 'cdn.contentful.com',
      accessToken: ACCESS_TOKEN,
      spaceId: SPACE_ID
    };
  }

  // Default to preview dev content
  return {
    environment: 'dev',
    domain: 'preview.contentful.com',
    accessToken: ACCESS_TOKEN,
    spaceId: SPACE_ID
  };
};

// Ideally we could construct the type through contentful package, but this is not installed
exports.getContentfulEnvironmentDetails = getContentfulEnvironmentDetails;
async function fetchCarouselSlidesFromContentful() {
  var _res$includes;
  const {
    accessToken,
    domain,
    environment,
    spaceId
  } = getContentfulEnvironmentDetails();
  if (!spaceId || !accessToken) {
    return {
      prioritySlides: [],
      regularSlides: []
    };
  }
  const url = new URL(`https://${domain}/spaces/${spaceId}/environments/${environment}/entries`);
  url.searchParams.set('access_token', accessToken);
  url.searchParams.set('content_type', CONTENT_TYPE);
  url.searchParams.set('fields.showInExtension', 'true');
  const res = await fetch(url).then(r => r.json());
  const assets = ((_res$includes = res.includes) === null || _res$includes === void 0 ? void 0 : _res$includes.Asset) || [];
  const resolveImage = imageRef => {
    var _asset$fields;
    const asset = assets.find(a => {
      var _imageRef$sys;
      return a.sys.id === (imageRef === null || imageRef === void 0 || (_imageRef$sys = imageRef.sys) === null || _imageRef$sys === void 0 ? void 0 : _imageRef$sys.id);
    });
    const rawUrl = (asset === null || asset === void 0 || (_asset$fields = asset.fields) === null || _asset$fields === void 0 || (_asset$fields = _asset$fields.file) === null || _asset$fields === void 0 ? void 0 : _asset$fields.url) || '';
    return rawUrl.startsWith('//') ? `https:${rawUrl}` : rawUrl;
  };
  const prioritySlides = [];
  const regularSlides = [];
  for (const entry of res.items) {
    const {
      headline,
      teaser,
      image,
      linkUrl,
      undismissable,
      startDate,
      endDate,
      priorityPlacement,
      variableName,
      cardPlacement,
      extensionMinimumVersionNumber
    } = entry.fields;
    const slide = {
      id: `contentful-${entry.sys.id}`,
      title: headline,
      description: teaser,
      image: resolveImage(image),
      href: linkUrl,
      undismissable,
      dismissed: false,
      startDate,
      endDate,
      priorityPlacement,
      variableName,
      cardPlacement
    };
    if (!isValidMinimumVersion(extensionMinimumVersionNumber)) {
      continue;
    }
    if (priorityPlacement) {
      prioritySlides.push(slide);
    } else {
      regularSlides.push(slide);
    }
  }
  return {
    prioritySlides,
    regularSlides
  };
}
function isValidMinimumVersion(contentfulMinimumVersionNumber) {
  // Field is not set, show by default
  if (!contentfulMinimumVersionNumber) {
    return true;
  }
  try {
    return _semver.default.gte(APP_VERSION, contentfulMinimumVersionNumber);
  } catch {
    // Invalid mobile version number, not showing banner
    return false;
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useCarouselManagement\\fetchCarouselSlidesFromContentful.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useCarouselManagement\\index.ts", {"./useCarouselManagement":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useCarouselManagement\\useCarouselManagement.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseCarouselManagement%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _useCarouselManagement = require("./useCarouselManagement");
Object.keys(_useCarouselManagement).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _useCarouselManagement[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _useCarouselManagement[key];
    }
  });
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useCarouselManagement\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useCarouselManagement\\useCarouselManagement.ts", {"../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./fetchCarouselSlidesFromContentful":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useCarouselManagement\\fetchCarouselSlidesFromContentful.ts","@metamask/profile-sync-controller/sdk":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\profile-sync-controller\\dist\\sdk\\index.cjs","bignumber.js":"D:\\code\\v\\metamask-extension\\node_modules\\bignumber.js\\bignumber.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseCarouselManagement%5CuseCarouselManagement.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isActive = isActive;
exports.useCarouselManagement = void 0;
var _lodash = require("lodash");
var _react = require("react");
var _reactRedux = require("react-redux");
var _loglevel = _interopRequireDefault(require("loglevel"));
var _bignumber = require("bignumber.js");
var _sdk = require("@metamask/profile-sync-controller/sdk");
var _actions = require("../../store/actions");
var _selectors = require("../../selectors");
var _fetchCarouselSlidesFromContentful = require("./fetchCarouselSlidesFromContentful");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const ZERO_BALANCE = '0x0';
function isActive(slide, now = new Date()) {
  const start = slide.startDate ? new Date(slide.startDate) : null;
  const end = slide.endDate ? new Date(slide.endDate) : null;
  if (start && now < start) {
    return false;
  }
  if (end && now > end) {
    return false;
  }
  return true;
}

// preserve dismissed/undismissable across re-fetches
const normalize = (raw, existing) => {
  if (!raw) {
    return undefined;
  }
  const prev = existing.find(s => s.id === raw.id);
  return {
    ...raw,
    dismissed: (prev === null || prev === void 0 ? void 0 : prev.dismissed) ?? false,
    undismissable: raw.undismissable || (prev === null || prev === void 0 ? void 0 : prev.undismissable) || false
  };
};
function orderByCardPlacement(slides) {
  const placed = [];
  const unplaced = [];
  for (const s of slides) {
    const raw = s.cardPlacement;
    const n = typeof raw === 'string' ? Number(raw) : raw;
    if (typeof n === 'number' && Number.isFinite(n)) {
      const idx = Math.max(0, Math.floor(n) - 1);
      if (idx >= placed.length) {
        placed.length = idx + 1;
      }
      placed[idx] = s;
    } else {
      unplaced.push(s);
    }
  }
  let up = 0;
  for (let i = 0; i < placed.length && up < unplaced.length; i++) {
    if (!placed[i]) {
      placed[i] = unplaced[up];
      up += 1;
    }
  }
  while (up < unplaced.length) {
    placed.push(unplaced[up]);
    up += 1;
  }
  return placed.filter(Boolean);
}
const useCarouselManagement = ({
  testDate,
  enabled = true
} = {}) => {
  const inTest = Boolean(false);
  const dispatch = (0, _reactRedux.useDispatch)();
  const slides = (0, _reactRedux.useSelector)(_selectors.getSlides);
  const remoteFeatureFlags = (0, _reactRedux.useSelector)(_selectors.getRemoteFeatureFlags);
  const totalBalance = (0, _reactRedux.useSelector)(_selectors.getSelectedAccountCachedBalance);
  const selectedAccount = (0, _reactRedux.useSelector)(_selectors.getSelectedInternalAccount);
  const useExternalServices = (0, _reactRedux.useSelector)(_selectors.getUseExternalServices);
  const showDownloadMobileAppSlide = (0, _reactRedux.useSelector)(_selectors.getShowDownloadMobileAppSlide);
  const prevSlidesRef = (0, _react.useRef)();
  const hasZeroBalance = new _bignumber.BigNumber(totalBalance ?? ZERO_BALANCE).eq(ZERO_BALANCE);
  (0, _react.useEffect)(() => {
    // If carousel is disabled, clear the slides
    if (!enabled) {
      const empty = [];
      if (!(0, _lodash.isEqual)(prevSlidesRef.current, empty)) {
        dispatch((0, _actions.updateSlides)(empty));
        prevSlidesRef.current = empty;
      }
      return;
    }
    const maybeFetchContentful = async () => {
      const contentfulEnabled = (remoteFeatureFlags === null || remoteFeatureFlags === void 0 ? void 0 : remoteFeatureFlags.contentfulCarouselEnabled) ?? false;

      // Early Return if Contentful is disabled
      if (!contentfulEnabled) {
        const empty = [];
        if (!(0, _lodash.isEqual)(prevSlidesRef.current, empty)) {
          dispatch((0, _actions.updateSlides)(empty));
          prevSlidesRef.current = empty;
        }
        return;
      }
      if (contentfulEnabled) {
        try {
          const {
            prioritySlides,
            regularSlides
          } = await (0, _fetchCarouselSlidesFromContentful.fetchCarouselSlidesFromContentful)();
          const pRaw = [...prioritySlides];
          const rRaw = [...regularSlides];
          const isNowActive = s => isActive(s, testDate ? new Date(testDate) : new Date());
          const normalizeList = list => list.map(s => normalize(s, slides)).filter(s => Boolean(s)).filter(isNowActive);

          // Fund: force undismissable on zero balance
          const fundCheck = s => {
            if (s.variableName === 'fund') {
              return {
                ...s,
                undismissable: hasZeroBalance || s.undismissable
              };
            }
            return s;
          };
          const downloadEligible = await (async _lineage$lineage => {
            if (!useExternalServices || !showDownloadMobileAppSlide) {
              return false;
            }
            const lineage = await (0, _actions.getUserProfileLineage)();
            const onMobile = Boolean(lineage === null || lineage === void 0 || (_lineage$lineage = lineage.lineage) === null || _lineage$lineage === void 0 ? void 0 : _lineage$lineage.some(l => l.agent === _sdk.Platform.MOBILE));
            return !onMobile;
          })();
          const isEligible = s => {
            // Show Download Mobile App (only if not already on mobile + flags)
            if (s.variableName === 'downloadMobileApp') {
              return downloadEligible;
            }
            return true;
          };
          const activePrioritySlides = normalizeList(pRaw).map(fundCheck).filter(isEligible);
          const activeRegularSlides = normalizeList(rRaw).map(fundCheck).filter(isEligible);

          // Order based on cardPlacement
          const orderedNonPriority = orderByCardPlacement(activeRegularSlides);
          const mergedSlides = [...activePrioritySlides, ...orderedNonPriority];
          if (!(0, _lodash.isEqual)(prevSlidesRef.current, mergedSlides)) {
            dispatch((0, _actions.updateSlides)(mergedSlides));
            prevSlidesRef.current = mergedSlides;
          }
        } catch (err) {
          _loglevel.default.warn('Failed to fetch Contentful slides:', err);
          if (!(0, _lodash.isEqual)(prevSlidesRef.current, [])) {
            dispatch((0, _actions.updateSlides)([]));
            prevSlidesRef.current = [];
          }
        }
      }
    };
    (async () => {
      try {
        await maybeFetchContentful();
      } catch (err) {
        _loglevel.default.warn('Failed to load carousel slides:', err);
      }
    })();
  }, [enabled, dispatch, hasZeroBalance, remoteFeatureFlags, testDate, inTest, slides, selectedAccount.address, useExternalServices, showDownloadMobileAppSlide]);
  return {
    slides
  };
};
exports.useCarouselManagement = useCarouselManagement;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useCarouselManagement\\useCarouselManagement.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useCopyToClipboard.js", {"../../shared/constants/copy":"D:\\code\\v\\metamask-extension\\shared\\constants\\copy.ts","../../shared/constants/time":"D:\\code\\v\\metamask-extension\\shared\\constants\\time.ts","./useTimeout":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTimeout.js","copy-to-clipboard":"D:\\code\\v\\metamask-extension\\node_modules\\copy-to-clipboard\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseCopyToClipboard.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCopyToClipboard = useCopyToClipboard;
var _react = require("react");
var _copyToClipboard = _interopRequireDefault(require("copy-to-clipboard"));
var _time = require("../../shared/constants/time");
var _copy = require("../../shared/constants/copy");
var _useTimeout = require("./useTimeout");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * useCopyToClipboard
 *
 * @param {number} [delay=3000] - delay in ms
 * @returns {[boolean, Function]}
 */
const DEFAULT_DELAY = _time.MINUTE;

/**
 * @param delay - delay in ms
 * @param opts - clipboard options
 * @param opts.expireClipboard - expires clipboard after delay
 * @returns {[boolean, (text: string) => void, () => void]}
 */
function useCopyToClipboard(delay = DEFAULT_DELAY, opts = {
  expireClipboard: true
}) {
  const [copied, setCopied] = (0, _react.useState)(false);
  const startTimeout = (0, _useTimeout.useTimeout)(() => {
    if (copied === true) {
      if (opts.expireClipboard) {
        (0, _copyToClipboard.default)(' ', _copy.COPY_OPTIONS);
      }
      setCopied(false);
    }
  }, delay, false);
  const handleCopy = (0, _react.useCallback)(text => {
    setCopied(true);
    startTimeout();
    (0, _copyToClipboard.default)(text, _copy.COPY_OPTIONS);
  }, [startTimeout]);
  const resetState = (0, _react.useCallback)(() => {
    setCopied(false);
  }, []);
  return [copied, handleCopy, resetState];
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useCopyToClipboard.js",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useCurrencyDisplay.js", {"../../shared/constants/common":"D:\\code\\v\\metamask-extension\\shared\\constants\\common.ts","../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../shared/modules/Numeric":"D:\\code\\v\\metamask-extension\\shared\\modules\\Numeric.ts","../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../helpers/utils/confirm-tx.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\confirm-tx.util.ts","../helpers/utils/token-util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\token-util.js","../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","./useFormatters":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useFormatters.ts","./useMultichainSelector":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainSelector.ts","@metamask/multichain-network-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-network-controller\\dist\\index.cjs","bignumber.js":"D:\\code\\v\\metamask-extension\\node_modules\\bignumber.js\\bignumber.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseCurrencyDisplay.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MIN_AMOUNT = exports.DEFAULT_PRECISION = void 0;
exports.useCurrencyDisplay = useCurrencyDisplay;
var _react = require("react");
var _bignumber = _interopRequireDefault(require("bignumber.js"));
var _multichainNetworkController = require("@metamask/multichain-network-controller");
var _confirmTx = require("../helpers/utils/confirm-tx.util");
var _multichain = require("../selectors/multichain");
var _conversion = require("../../shared/modules/conversion.utils");
var _network = require("../../shared/constants/network");
var _Numeric = require("../../shared/modules/Numeric");
var _common = require("../../shared/constants/common");
var _tokenUtil = require("../helpers/utils/token-util");
var _metamask = require("../ducks/metamask/metamask");
var _useFormatters = require("./useFormatters");
var _useMultichainSelector = require("./useMultichainSelector");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// The smallest non-zero amount that can be displayed.
const MIN_AMOUNT = exports.MIN_AMOUNT = 0.000001;

// The string to display when 0 < amount < MIN_AMOUNT.
// TODO(dbrans): Localize this string using Intl.NumberFormatter.
const MIN_AMOUNT_DISPLAY = `<${MIN_AMOUNT}`;

// The default precision for displaying currency values.
// It set to the number of decimal places in the minimum amount.
const DEFAULT_PRECISION = exports.DEFAULT_PRECISION = new _bignumber.default(MIN_AMOUNT).decimalPlaces();
function formatEthCurrencyDisplay({
  isNativeCurrency,
  isUserPreferredCurrency,
  nativeCurrency,
  inputValue,
  denomination,
  numberOfDecimals
}) {
  if (isNativeCurrency || !isUserPreferredCurrency && !nativeCurrency) {
    const ethDisplayValue = new _Numeric.Numeric(inputValue, 16, _common.EtherDenomination.WEI).toDenomination(denomination || _common.EtherDenomination.ETH).round(numberOfDecimals || DEFAULT_PRECISION).toBase(10).toString();
    return ethDisplayValue === '0' && inputValue && Number(inputValue) !== 0 ? MIN_AMOUNT_DISPLAY : ethDisplayValue;
  }
  return null;
}
function formatNonEvmAssetCurrencyDisplay({
  tokenSymbol,
  isNativeCurrency,
  isUserPreferredCurrency,
  currency,
  currentCurrency,
  nativeCurrency,
  inputValue,
  conversionRate
}) {
  if (isNativeCurrency || !isUserPreferredCurrency && !nativeCurrency) {
    // NOTE: We use the value coming from the MultichainBalancesController here (and thus, the non-EVM
    // account Snap).
    // We use `Numeric` here, so we handle those amount the same way than for EVMs (it's worth
    // noting that if `inputValue` is not properly defined, the amount will be set to '0', see
    // `Numeric` constructor for that)
    return new _Numeric.Numeric(inputValue, 10).toString();
  } else if (isUserPreferredCurrency && conversionRate) {
    const amount = (0, _tokenUtil.getTokenFiatAmount)(1,
    // coin to native conversion rate is 1:1
    Number(conversionRate),
    // native to fiat conversion rate
    currentCurrency, inputValue, tokenSymbol, false, false) ?? '0'; // if the conversion fails, return 0
    return (0, _confirmTx.formatCurrency)(amount, currency);
  }
  return null;
}

/**
 * Defines the shape of the options parameter for useCurrencyDisplay
 *
 * @typedef {object} UseCurrencyOptions
 * @property {string} [displayValue] - When present is used in lieu of formatting the inputValue
 * @property {string} [prefix] - String to prepend to the final result
 * @property {number} [numberOfDecimals] - Number of significant decimals to display
 * @property {string} [denomination] - Denomination (wei, gwei) to convert to for display
 * @property {string} [currency] - Currency type to convert to. Will override nativeCurrency
 * @property {boolean} [hideLabel] – hide the currency label
 * @property {object} [account] - The account object
 */

/**
 * Defines the return shape of the second value in the tuple
 *
 * @typedef {object} CurrencyDisplayParts
 * @property {string} [prefix] - string to prepend to the value for display
 * @property {string} value - string representing the value, formatted for display
 * @property {string} [suffix] - string to append to the value for display
 */

/**
 * useCurrencyDisplay hook
 *
 * Given a hexadecimal encoded value string and an object of parameters used for formatting the
 * display, produce both a fully formed string and the pieces of that string used for displaying
 * the currency to the user
 *
 * @param {string} inputValue - The value to format for display
 * @param {UseCurrencyOptions} opts - An object for options to format the inputValue
 * @param {string} chainId - chainId to use
 * @returns {[string, CurrencyDisplayParts]}
 */
function useCurrencyDisplay(inputValue, {
  account,
  displayValue,
  prefix,
  numberOfDecimals,
  denomination,
  currency,
  isAggregatedFiatOverviewBalance,
  ...opts
}, chainId = null) {
  const {
    formatCurrency
  } = (0, _useFormatters.useFormatters)();
  const isEvm = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainIsEvm, account);
  const currentCurrency = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainCurrentCurrency, account);
  const nativeCurrency = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainNativeCurrency, account);
  const conversionRate = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainConversionRate, account);
  const currencyRates = (0, _useMultichainSelector.useMultichainSelector)(_metamask.getCurrencyRates, account);
  const isUserPreferredCurrency = currency === currentCurrency;
  const isNativeCurrency = currency === nativeCurrency || currency === _network.CHAIN_ID_TO_CURRENCY_SYMBOL_MAP[chainId];
  const value = (0, _react.useMemo)(() => {
    if (displayValue) {
      return displayValue;
    }
    if (!isEvm && !isAggregatedFiatOverviewBalance) {
      var _currencyRates$CHAIN_;
      return formatNonEvmAssetCurrencyDisplay({
        tokenSymbol: nativeCurrency,
        isNativeCurrency,
        isUserPreferredCurrency,
        currency,
        currentCurrency,
        nativeCurrency,
        inputValue,
        conversionRate: chainId ? currencyRates === null || currencyRates === void 0 || (_currencyRates$CHAIN_ = currencyRates[_network.CHAIN_ID_TO_CURRENCY_SYMBOL_MAP[chainId]]) === null || _currencyRates$CHAIN_ === void 0 ? void 0 : _currencyRates$CHAIN_.conversionRate : conversionRate
      });
    }
    if (isAggregatedFiatOverviewBalance) {
      return formatCurrency(inputValue, currency);
    }
    if (!isNativeCurrency && isUserPreferredCurrency && conversionRate) {
      const valueFromHex = (0, _conversion.getValueFromWeiHex)({
        value: inputValue,
        fromCurrency: nativeCurrency,
        toCurrency: currency,
        conversionRate,
        numberOfDecimals: numberOfDecimals || 2,
        toDenomination: denomination
      });
      return formatCurrency(valueFromHex, currency);
    }
    return formatEthCurrencyDisplay({
      isNativeCurrency,
      isUserPreferredCurrency,
      nativeCurrency,
      inputValue,
      denomination,
      numberOfDecimals
    });
  }, [displayValue, isEvm, isNativeCurrency, isUserPreferredCurrency, currency, nativeCurrency, inputValue, conversionRate, denomination, numberOfDecimals, currentCurrency, isAggregatedFiatOverviewBalance, chainId, currencyRates, formatCurrency]);
  let suffix;

  // Don't add suffix to fiat currencies
  const isFiatCurrency = isAggregatedFiatOverviewBalance || !isNativeCurrency;
  if (!opts.hideLabel && !isFiatCurrency) {
    // if the currency we are displaying is the native currency of one of our preloaded test-nets (goerli, sepolia etc.)
    // then we allow lowercase characters, otherwise we force to uppercase any suffix passed as a currency
    const currencyTickerSymbol = [...Object.values(_network.TEST_NETWORK_TICKER_MAP), ...Object.values(_multichainNetworkController.MULTICHAIN_NETWORK_TICKER)].includes(currency) ? currency : currency === null || currency === void 0 ? void 0 : currency.toUpperCase();
    suffix = opts.suffix || currencyTickerSymbol;
  }
  return [`${prefix || ''}${value}${suffix ? ` ${suffix}` : ''}`, {
    prefix,
    value,
    suffix
  }];
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useCurrencyDisplay.js",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useCurrencyRatePolling.ts", {"../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../helpers/utils/isOriginalNativeTokenSymbol":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\isOriginalNativeTokenSymbol.ts","../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../selectors/multichain/networks":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain\\networks.ts","../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./usePolling":"D:\\code\\v\\metamask-extension\\ui\\hooks\\usePolling.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseCurrencyRatePolling.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _selectors = require("../selectors");
var _networks = require("../selectors/multichain/networks");
var _actions = require("../store/actions");
var _metamask = require("../ducks/metamask/metamask");
var _selectors2 = require("../selectors/selectors");
var _networks2 = require("../../shared/modules/selectors/networks");
var _isOriginalNativeTokenSymbol = require("../helpers/utils/isOriginalNativeTokenSymbol");
var _usePolling = _interopRequireDefault(require("./usePolling"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const usePollingEnabled = () => {
  const completedOnboarding = (0, _reactRedux.useSelector)(_metamask.getCompletedOnboarding);
  const isUnlocked = (0, _reactRedux.useSelector)(_metamask.getIsUnlocked);
  const useCurrencyRateCheck = (0, _reactRedux.useSelector)(_selectors.getUseCurrencyRateCheck);
  return completedOnboarding && isUnlocked && useCurrencyRateCheck;
};
const useNativeCurrencies = isPollingEnabled => {
  const networkConfigurations = (0, _reactRedux.useSelector)(_networks2.getNetworkConfigurationsByChainId);
  const useSafeChainsListValidation = (0, _reactRedux.useSelector)(_selectors.useSafeChainsListValidationSelector);
  const [nativeCurrencies, setNativeCurrencies] = (0, _react.useState)([]);
  const chainIds = (0, _reactRedux.useSelector)(_selectors.getChainIdsToPoll);
  const enabledChainIds = (0, _reactRedux.useSelector)(_networks.getEnabledChainIds);
  const pollableChains = _selectors2.isGlobalNetworkSelectorRemoved ? enabledChainIds : chainIds;
  (0, _react.useEffect)(() => {
    // Use validated currency tickers
    const fetchNativeCurrencies = async () => {
      const nativeCurrenciesArray = await Promise.all(Object.values(networkConfigurations).map(async n => {
        const originalToken = await (0, _isOriginalNativeTokenSymbol.getOriginalNativeTokenSymbol)({
          chainId: n.chainId,
          useAPICall: useSafeChainsListValidation && isPollingEnabled
        });
        if (!pollableChains.includes(n.chainId)) {
          return null;
        }
        return originalToken ?? n.nativeCurrency;
      }));

      // Use a type predicate to filter out null values.
      const filteredCurrencies = nativeCurrenciesArray.filter(currency => currency !== null);
      const uniqueCurrencies = [...new Set(filteredCurrencies)];
      setNativeCurrencies(uniqueCurrencies);
    };
    fetchNativeCurrencies();
  }, [chainIds, isPollingEnabled, networkConfigurations, pollableChains, useSafeChainsListValidation]);
  return nativeCurrencies;
};
const useCurrencyRatePolling = () => {
  const pollingEnabled = usePollingEnabled();
  const nativeCurrencies = useNativeCurrencies(pollingEnabled);
  const enabled = pollingEnabled && nativeCurrencies.length > 0;

  // usePolling is a custom hook that is invoked synchronously.
  (0, _usePolling.default)({
    startPolling: _actions.currencyRateStartPolling,
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    stopPollingByPollingToken: _actions.currencyRateStopPollingByPollingToken,
    input: nativeCurrencies,
    enabled
  });
};
var _default = exports.default = useCurrencyRatePolling;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useCurrencyRatePolling.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useCurrentAsset.js", {"../../shared/constants/swaps":"D:\\code\\v\\metamask-extension\\shared\\constants\\swaps.ts","../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../shared/modules/string-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\string-utils.ts","../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseCurrentAsset.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCurrentAsset = useCurrentAsset;
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _metamask = require("../ducks/metamask/metamask");
var _networks = require("../../shared/modules/selectors/networks");
var _routes = require("../helpers/constants/routes");
var _swaps = require("../../shared/constants/swaps");
var _stringUtils = require("../../shared/modules/string-utils");
/**
 * Returns a token object for the asset that is currently being viewed.
 * Will return the default token object for the current chain when the
 * user is viewing either the primary, unfiltered, activity list or the
 * default token asset page.
 *
 * @returns {__import__('./useTokenDisplayValue').Token}
 */
function useCurrentAsset() {
  var _match$params;
  // To determine which primary currency to display for swaps transactions we need to be aware
  // of which asset, if any, we are viewing at present
  const match = (0, _reactRouterDom.useRouteMatch)({
    path: `${_routes.ASSET_ROUTE}/:asset`,
    exact: true,
    strict: true
  });
  const tokenAddress = match === null || match === void 0 || (_match$params = match.params) === null || _match$params === void 0 ? void 0 : _match$params.asset;
  const knownTokens = (0, _reactRedux.useSelector)(_metamask.getTokens);
  const token = tokenAddress && knownTokens.find(({
    address
  }) => (0, _stringUtils.isEqualCaseInsensitive)(address, tokenAddress));
  const chainId = (0, _reactRedux.useSelector)(_networks.getCurrentChainId);
  return token ?? (_swaps.SWAPS_CHAINID_DEFAULT_TOKEN_MAP[chainId] || _swaps.ETH_SWAPS_TOKEN_OBJECT);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useCurrentAsset.js",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useDisplayName.ts", {"../../shared/constants/first-party-contracts":"D:\\code\\v\\metamask-extension\\shared\\constants\\first-party-contracts.ts","../../shared/modules/hexstring-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\hexstring-utils.ts","../ducks/domains":"D:\\code\\v\\metamask-extension\\ui\\ducks\\domains.js","../helpers/utils/trust-signals":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\trust-signals.ts","../pages/confirmations/selectors/accounts":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\selectors\\accounts.ts","../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","../selectors/nft":"D:\\code\\v\\metamask-extension\\ui\\selectors\\nft.ts","./useName":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useName.ts","./useNftCollectionsMetadata":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useNftCollectionsMetadata.ts","./useTrustSignals":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTrustSignals.ts","@metamask/name-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\name-controller\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseDisplayName.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDisplayName = useDisplayName;
exports.useDisplayNames = useDisplayNames;
var _nameController = require("@metamask/name-controller");
var _reactRedux = require("react-redux");
var _react = require("react");
var _firstPartyContracts = require("../../shared/constants/first-party-contracts");
var _hexstringUtils = require("../../shared/modules/hexstring-utils");
var _domains = require("../ducks/domains");
var _selectors = require("../selectors");
var _nft = require("../selectors/nft");
var _trustSignals = require("../helpers/utils/trust-signals");
var _accounts = require("../pages/confirmations/selectors/accounts");
var _accountTree = require("../selectors/multichain-accounts/account-tree");
var _useName = require("./useName");
var _useNftCollectionsMetadata = require("./useNftCollectionsMetadata");
var _useTrustSignals = require("./useTrustSignals");
function useDisplayNames(requests) {
  const nameEntries = (0, _useName.useNames)(requests);
  const firstPartyContractNames = useFirstPartyContractNames(requests);
  const trustSignals = (0, _useTrustSignals.useTrustSignals)(requests);
  const erc20Tokens = useERC20Tokens(requests);
  const watchedNFTNames = useWatchedNFTNames(requests);
  const nfts = useNFTs(requests);
  const ens = useDomainResolutions(requests);
  const accountGroupEntries = useAccountGroupNames(requests, nameEntries);
  return requests.map((_request, index) => {
    const nameEntry = nameEntries[index];
    const firstPartyContractName = firstPartyContractNames[index];
    const trustSignal = trustSignals[index];
    const erc20Token = erc20Tokens[index];
    const watchedNftName = watchedNFTNames[index];
    const nft = nfts[index];
    const ensName = ens[index];
    const {
      accountGroupName,
      walletName
    } = accountGroupEntries[index];
    const subtitle = walletName;
    let name = accountGroupName || (// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    nameEntry === null || nameEntry === void 0 ? void 0 : nameEntry.name) ||
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    firstPartyContractName || (// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    nft === null || nft === void 0 ? void 0 : nft.name) || (// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    erc20Token === null || erc20Token === void 0 ? void 0 : erc20Token.name) || watchedNftName || ensName || null;
    const hasPetname = Boolean(nameEntry === null || nameEntry === void 0 ? void 0 : nameEntry.name);
    const displayState = getDisplayState(trustSignal === null || trustSignal === void 0 ? void 0 : trustSignal.state, hasPetname, name);

    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    const image = (nft === null || nft === void 0 ? void 0 : nft.image) || (erc20Token === null || erc20Token === void 0 ? void 0 : erc20Token.image);
    const trustSignalIcon = (0, _trustSignals.getTrustSignalIcon)(displayState);
    const trustSignalLabel = trustSignal === null || trustSignal === void 0 ? void 0 : trustSignal.label;

    // Add trust signal label after display state calculation to avoid state recognition conflicts
    if (name === null && trustSignalLabel) {
      name = trustSignalLabel;
    }
    return {
      contractDisplayName: erc20Token === null || erc20Token === void 0 ? void 0 : erc20Token.name,
      displayState,
      hasPetname,
      icon: trustSignalIcon,
      image,
      isAccount: accountGroupName !== null,
      name,
      subtitle
    };
  });
}
function useDisplayName(request) {
  return useDisplayNames([request])[0];
}
function useERC20Tokens(nameRequests) {
  const erc20TokensByChain = (0, _reactRedux.useSelector)(_selectors.selectERC20TokensByChain);
  return nameRequests.map(({
    preferContractSymbol,
    type,
    value,
    variation
  }) => {
    var _erc20TokensByChain$v;
    if (type !== _nameController.NameType.ETHEREUM_ADDRESS) {
      return undefined;
    }
    const contractAddress = value.toLowerCase();
    const {
      iconUrl: image,
      name: tokenName,
      symbol
    } = (erc20TokensByChain === null || erc20TokensByChain === void 0 || (_erc20TokensByChain$v = erc20TokensByChain[variation]) === null || _erc20TokensByChain$v === void 0 || (_erc20TokensByChain$v = _erc20TokensByChain$v.data) === null || _erc20TokensByChain$v === void 0 ? void 0 : _erc20TokensByChain$v[contractAddress]) ?? {};
    const name = preferContractSymbol && symbol ? symbol : tokenName;
    return {
      name,
      image
    };
  });
}
function useWatchedNFTNames(nameRequests) {
  const watchedNftNamesByAddressByChain = (0, _reactRedux.useSelector)(_nft.getNftContractsByAddressByChain);
  return nameRequests.map(({
    type,
    value,
    variation
  }) => {
    var _watchedNftNamesByAdd;
    if (type !== _nameController.NameType.ETHEREUM_ADDRESS) {
      return undefined;
    }
    const contractAddress = value.toLowerCase();
    const watchedNftNamesByAddress = watchedNftNamesByAddressByChain[variation];
    return watchedNftNamesByAddress === null || watchedNftNamesByAddress === void 0 || (_watchedNftNamesByAdd = watchedNftNamesByAddress[contractAddress]) === null || _watchedNftNamesByAdd === void 0 ? void 0 : _watchedNftNamesByAdd.name;
  });
}
function useNFTs(nameRequests) {
  const requests = nameRequests.filter(({
    type
  }) => type === _nameController.NameType.ETHEREUM_ADDRESS).map(({
    value,
    variation
  }) => ({
    chainId: variation,
    contractAddress: value
  }));
  const nftCollectionsByAddressByChain = (0, _useNftCollectionsMetadata.useNftCollectionsMetadata)(requests);
  return nameRequests.map(({
    type,
    value: contractAddress,
    variation: chainId
  }) => {
    var _nftCollectionsByAddr;
    if (type !== _nameController.NameType.ETHEREUM_ADDRESS) {
      return undefined;
    }
    const nftCollectionProperties = (_nftCollectionsByAddr = nftCollectionsByAddressByChain[chainId]) === null || _nftCollectionsByAddr === void 0 ? void 0 : _nftCollectionsByAddr[contractAddress.toLowerCase()];
    const isSpam = (nftCollectionProperties === null || nftCollectionProperties === void 0 ? void 0 : nftCollectionProperties.isSpam) !== false;
    if (!nftCollectionProperties || isSpam) {
      return undefined;
    }
    const {
      name,
      image
    } = nftCollectionProperties;
    return {
      name,
      image
    };
  });
}
function useDomainResolutions(nameRequests) {
  const domainResolutions = (0, _reactRedux.useSelector)(_domains.getDomainResolutions);
  return nameRequests.map(({
    type,
    value
  }) => {
    if (type !== _nameController.NameType.ETHEREUM_ADDRESS) {
      return undefined;
    }
    const matchedResolution = domainResolutions === null || domainResolutions === void 0 ? void 0 : domainResolutions.find(resolution => (0, _hexstringUtils.toChecksumHexAddress)(resolution.resolvedAddress) === (0, _hexstringUtils.toChecksumHexAddress)(value));
    const ensName = matchedResolution === null || matchedResolution === void 0 ? void 0 : matchedResolution.domainName;
    return ensName;
  });
}
function useFirstPartyContractNames(nameRequests) {
  return nameRequests.map(({
    type,
    value,
    variation
  }) => {
    if (type !== _nameController.NameType.ETHEREUM_ADDRESS) {
      return undefined;
    }
    const normalizedContractAddress = value.toLowerCase();
    const contractNames = Object.keys(_firstPartyContracts.FIRST_PARTY_CONTRACT_NAMES);
    return contractNames.find(contractName => {
      var _FIRST_PARTY_CONTRACT;
      const currentContractAddress = (_FIRST_PARTY_CONTRACT = _firstPartyContracts.FIRST_PARTY_CONTRACT_NAMES[contractName]) === null || _FIRST_PARTY_CONTRACT === void 0 ? void 0 : _FIRST_PARTY_CONTRACT[variation];
      return (currentContractAddress === null || currentContractAddress === void 0 ? void 0 : currentContractAddress.toLowerCase()) === normalizedContractAddress;
    });
  });
}

// Priority logic for display state
function getDisplayState(trustState, hasPetname, displayName) {
  // Priority 1: Malicious takes precedence over everything
  if (trustState === _useTrustSignals.TrustSignalDisplayState.Malicious) {
    return _useTrustSignals.TrustSignalDisplayState.Malicious;
  }

  // Priority 2: Saved petname
  if (hasPetname) {
    return _useTrustSignals.TrustSignalDisplayState.Petname;
  }
  if (trustState === _useTrustSignals.TrustSignalDisplayState.Warning) {
    return _useTrustSignals.TrustSignalDisplayState.Warning;
  }

  // Priority 4: Recognized name ex. "USDC"
  if (displayName) {
    return _useTrustSignals.TrustSignalDisplayState.Recognized;
  }
  if (trustState === _useTrustSignals.TrustSignalDisplayState.Verified) {
    return _useTrustSignals.TrustSignalDisplayState.Verified;
  }

  // Priority 6: Other trust signal states (when enabled and present)
  if (trustState === _useTrustSignals.TrustSignalDisplayState.Unknown) {
    return _useTrustSignals.TrustSignalDisplayState.Unknown;
  }

  // Default: Unknown state with no name
  return _useTrustSignals.TrustSignalDisplayState.Unknown;
}
function useAccountGroupNames(requests, nameEntries) {
  const isMultichainAccountsState2Enabled = (0, _reactRedux.useSelector)(_selectors.getIsMultichainAccountsState2Enabled);
  const accountTree = (0, _reactRedux.useSelector)(_accountTree.getAccountTree);
  const {
    wallets
  } = accountTree ?? {};
  const haveMoreThanOneWallet = (0, _react.useMemo)(() => Object.keys(wallets).length > 1, [wallets]);

  // Extract unique ethereum addresses from requests
  const ethereumAddresses = (0, _react.useMemo)(() => {
    return requests.map(({
      type,
      value
    }, index) => ({
      address: type === _nameController.NameType.ETHEREUM_ADDRESS ? value : null,
      originalIndex: index
    })).filter(item => item.address !== null);
  }, [requests]);
  const namesByAddress = (0, _reactRedux.useSelector)(state => {
    const result = {};
    ethereumAddresses.forEach(({
      address
    }) => {
      if (address) {
        const accountGroupName = (0, _accounts.selectAccountGroupNameByInternalAccount)(state, address);
        const walletInfo = (0, _accountTree.getWalletIdAndNameByAccountAddress)(state, address);
        const walletName = (walletInfo === null || walletInfo === void 0 ? void 0 : walletInfo.name) || null;
        result[address] = {
          accountGroupName,
          walletName
        };
      }
    });
    return result;
  });
  return (0, _react.useMemo)(() => {
    return requests.map(({
      type,
      value
    }, index) => {
      const nameEntry = nameEntries[index];
      const names = (namesByAddress === null || namesByAddress === void 0 ? void 0 : namesByAddress[value]) || {
        accountGroupName: null,
        walletName: null
      };
      if (type !== _nameController.NameType.ETHEREUM_ADDRESS || !isMultichainAccountsState2Enabled || (nameEntry === null || nameEntry === void 0 ? void 0 : nameEntry.origin) === _nameController.NameOrigin.API) {
        return {
          accountGroupName: null,
          walletName: null
        };
      }
      return {
        accountGroupName: names.accountGroupName,
        walletName: haveMoreThanOneWallet ? names.walletName : null
      };
    });
  }, [requests, namesByAddress, isMultichainAccountsState2Enabled, nameEntries, haveMoreThanOneWallet]);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useDisplayName.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useEqualityCheck.js", {"lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseEqualityCheck.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEqualityCheck = useEqualityCheck;
var _react = require("react");
var _lodash = require("lodash");
/**
 * Given a value and a function to determine equality, return a
 * referentially equal value if the equality function returns true.
 * This hook is helpful in avoiding re-renders and effects running
 * based on an object or value that always changes references but
 * infrequently changes it's value. By default, uses isEqual from
 * lodash. This is typically only useful with objects and arrays.
 *
 * @param {T} value - any value to check equality of
 * @param {(T, T) => boolean} equalityFn - A function to determine equality
 * @returns {T}
 */
function useEqualityCheck(value, equalityFn = _lodash.isEqual) {
  const [computedValue, setComputedValue] = (0, _react.useState)(value);
  (0, _react.useLayoutEffect)(() => {
    if (!equalityFn(value, computedValue)) {
      setComputedValue(value);
    }
  }, [value, equalityFn, computedValue]);
  return computedValue;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useEqualityCheck.js",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useEthFiatAmount.js", {"../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../helpers/utils/confirm-tx.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\confirm-tx.util.ts","../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","bignumber.js":"D:\\code\\v\\metamask-extension\\node_modules\\bignumber.js\\bignumber.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseEthFiatAmount.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEthFiatAmount = useEthFiatAmount;
var _react = require("react");
var _reactRedux = require("react-redux");
var _bignumber = _interopRequireDefault(require("bignumber.js"));
var _selectors = require("../selectors");
var _confirmTx = require("../helpers/utils/confirm-tx.util");
var _metamask = require("../ducks/metamask/metamask");
var _conversion = require("../../shared/modules/conversion.utils");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * Get an Eth amount converted to fiat and formatted for display
 *
 * @param {string | BigNumber} [ethAmount] - The eth amount to convert
 * @param {object} [overrides] - A configuration object that allows the called to explicitly
 *                              ensure fiat is shown even if the property is not set in state.
 * @param {boolean} [overrides.showFiat] - If truthy, ensures the fiat value is shown even if the showFiat value from state is falsey
 * @param {boolean} hideCurrencySymbol - Indicates whether the returned formatted amount should include the trailing currency symbol
 * @returns {string} The formatted token amount in the user's chosen fiat currency
 */
function useEthFiatAmount(ethAmount, overrides = {}, hideCurrencySymbol) {
  const conversionRate = (0, _reactRedux.useSelector)(_metamask.getConversionRate);
  const currentCurrency = (0, _reactRedux.useSelector)(_metamask.getCurrentCurrency);
  const userPrefersShownFiat = (0, _reactRedux.useSelector)(_selectors.getShouldShowFiat);
  const showFiat = overrides.showFiat ?? userPrefersShownFiat;
  const formattedFiat = (0, _react.useMemo)(() => (0, _conversion.decEthToConvertedCurrency)(ethAmount, currentCurrency, conversionRate), [conversionRate, currentCurrency, ethAmount]);
  if (!showFiat || currentCurrency.toUpperCase() === 'ETH' || conversionRate <= 0 || ethAmount === undefined) {
    return undefined;
  }
  const fiatAmount = new _bignumber.default(ethAmount.toString()).times(conversionRate);
  if (ethAmount && fiatAmount.lt(new _bignumber.default(0.01)) && fiatAmount.greaterThan(new _bignumber.default(0))) {
    return hideCurrencySymbol ? `< ${(0, _confirmTx.formatCurrency)(0.01, currentCurrency)}` : `< ${(0, _confirmTx.formatCurrency)(0.01, currentCurrency)} ${currentCurrency.toUpperCase()}`;
  }
  return hideCurrencySymbol ? (0, _confirmTx.formatCurrency)(formattedFiat, currentCurrency) : `${(0, _confirmTx.formatCurrency)(formattedFiat, currentCurrency)} ${currentCurrency.toUpperCase()}`;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useEthFiatAmount.js",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useFetchNftDetailsFromTokenURI.ts", {"react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseFetchNftDetailsFromTokenURI.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("react");
const useFetchNftDetailsFromTokenURI = tokenURI => {
  const [image, setImage] = (0, _react.useState)('');
  const [name, setName] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    const fetchRemoteTokenURI = async () => {
      if (!tokenURI) {
        return;
      }
      try {
        const response = await fetch(tokenURI);
        if (!response.ok) {
          return;
        }
        let rawData = await response.text();
        // Remove trailing commas before parsing
        // eslint-disable-next-line require-unicode-regexp
        rawData = rawData.replace(/,\s*}/g, '}').replace(/,\s*\]/g, ']');

        // Try parsing JSON
        const data = JSON.parse(rawData);
        setImage(data.image);
        setName(data.name);
      } catch {
        // ignore
      }
    };
    fetchRemoteTokenURI();
  }, [tokenURI]);
  return {
    image,
    name
  };
};
var _default = exports.default = useFetchNftDetailsFromTokenURI;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useFetchNftDetailsFromTokenURI.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useFiatFormatter.ts", {"../ducks/locale/locale":"D:\\code\\v\\metamask-extension\\ui\\ducks\\locale\\locale.ts","../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseFiatFormatter.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFiatFormatter = void 0;
var _reactRedux = require("react-redux");
var _locale = require("../ducks/locale/locale");
var _metamask = require("../ducks/metamask/metamask");
var _util = require("../helpers/utils/util");
/**
 * Returns a function that formats a fiat amount as a localized string.
 * The hook takes an optional options object to configure the formatting.
 *
 * Example usage:
 *
 * ```
 * const formatFiat = useFiatFormatter();
 * const formattedAmount = formatFiat(1000);
 *
 * const shorteningFiatFormatter = useFiatFormatter();
 * const shortenedAmount = shorteningFiatFormatter(100000000000000000, { shorten: true });
 * ```
 *
 * @returns A function that takes a fiat amount as a number and returns a formatted string.
 */

const TRUNCATED_CHAR_LIMIT_FOR_SHORTENED_FIAT = 15;
const TRUNCATED_START_CHARS_FOR_SHORTENED_FIAT = 12;
const useFiatFormatter = () => {
  const locale = (0, _reactRedux.useSelector)(_locale.getIntlLocale);
  const fiatCurrency = (0, _reactRedux.useSelector)(_metamask.getCurrentCurrency);
  return (fiatAmount, options = {}) => {
    const {
      shorten,
      truncatedCharLimit,
      truncatedStartChars
    } = options;
    try {
      const formatter = new Intl.NumberFormat(locale, {
        style: 'currency',
        currency: fiatCurrency
      });
      if (!shorten) {
        return formatter.format(fiatAmount);
      }
      const parts = formatter.formatToParts(fiatAmount);
      let currencySymbol = '';
      let numberString = '';
      parts.forEach(part => {
        if (part.type === 'currency') {
          currencySymbol += part.value;
        } else {
          numberString += part.value;
        }
      });

      // Shorten the number part while preserving commas
      const shortenedNumberString = (0, _util.shortenString)(numberString, {
        truncatedCharLimit: truncatedCharLimit ?? TRUNCATED_CHAR_LIMIT_FOR_SHORTENED_FIAT,
        truncatedStartChars: truncatedStartChars ?? TRUNCATED_START_CHARS_FOR_SHORTENED_FIAT,
        truncatedEndChars: 0,
        skipCharacterInEnd: true
      });

      // Determine the position of the currency symbol
      const currencyBeforeNumber = parts.findIndex(part => part.type === 'currency') < parts.findIndex(part => part.type === 'integer');

      // Reassemble the formatted string
      return currencyBeforeNumber ? `${currencySymbol}${shortenedNumberString}` : `${shortenedNumberString}${currencySymbol}`;
    } catch (error) {
      // Fallback for unknown or unsupported currencies
      const formattedNumber = new Intl.NumberFormat(locale).format(fiatAmount);
      const shortenedNumberString = (0, _util.shortenString)(formattedNumber, {
        truncatedCharLimit: TRUNCATED_CHAR_LIMIT_FOR_SHORTENED_FIAT,
        truncatedStartChars: TRUNCATED_START_CHARS_FOR_SHORTENED_FIAT,
        truncatedEndChars: 0,
        skipCharacterInEnd: true
      });
      if (shorten) {
        return `${shortenedNumberString} ${fiatCurrency}`;
      }
      return `${formattedNumber} ${fiatCurrency}`;
    }
  };
};
exports.useFiatFormatter = useFiatFormatter;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useFiatFormatter.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useFormatters.ts", {"../ducks/locale/locale":"D:\\code\\v\\metamask-extension\\ui\\ducks\\locale\\locale.ts","@metamask/assets-controllers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseFormatters.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFormatters = useFormatters;
var _react = require("react");
var _reactRedux = require("react-redux");
var _assetsControllers = require("@metamask/assets-controllers");
var _locale = require("../ducks/locale/locale");
function formatPercentWithMinThreshold(formatNumber, value, options = {}) {
  const minThreshold = 0.0001; // 0.01%
  const number = Number(value);
  if (!Number.isFinite(number)) {
    return '';
  }
  const clamped = number === 0 ? 0 : Math.sign(number) * Math.max(Math.abs(number), minThreshold);
  return formatNumber(clamped, {
    style: 'percent',
    maximumFractionDigits: 2,
    minimumFractionDigits: 2,
    ...options
  });
}
function formatCompact(formatNumber, value) {
  return formatNumber(value, {
    notation: 'compact',
    minimumFractionDigits: 2,
    maximumFractionDigits: 2
  });
}
function useFormatters() {
  const locale = (0, _reactRedux.useSelector)(_locale.getIntlLocale);
  return (0, _react.useMemo)(() => {
    const base = (0, _assetsControllers.createFormatters)({
      locale
    });
    return {
      ...base,
      /**
       * Format a value as a percentage string with two decimal digits (ratio input: 0.1234 -> "12.34%").
       */
      formatPercentWithMinThreshold: formatPercentWithMinThreshold.bind(null, base.formatNumber),
      formatCompact: formatCompact.bind(null, base.formatNumber)
    };
  }, [locale]);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useFormatters.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useGasFeeEstimates.js", {"../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./usePolling":"D:\\code\\v\\metamask-extension\\ui\\hooks\\usePolling.ts","lodash/isEqual":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\isEqual.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseGasFeeEstimates.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGasFeeEstimates = useGasFeeEstimates;
var _isEqual = _interopRequireDefault(require("lodash/isEqual"));
var _reactRedux = require("react-redux");
var _react = require("react");
var _metamask = require("../ducks/metamask/metamask");
var _actions = require("../store/actions");
var _networks = require("../../shared/modules/selectors/networks");
var _usePolling = _interopRequireDefault(require("./usePolling"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * @typedef {object} GasEstimates
 * @property {__import__(
 *   '@metamask/gas-fee-controller'
 * ).GasFeeState['gasFeeEstimates']} gasFeeEstimates - The estimate object
 * @property {object} gasEstimateType - The type of estimate provided
 * @property {boolean} isGasEstimateLoading - indicates whether the gas
 *  estimates are currently loading.
 * @property {boolean} isNetworkBusy - indicates whether the network is busy.
 */

/**
 * Gets the current gasFeeEstimates from state and begins polling for new
 * estimates. When this hook is removed from the tree it will signal to the
 * GasFeeController that it is done requiring new gas estimates. Also checks
 * the returned gas estimate for validity on the current network.
 *
 * @param _networkClientId - The optional network client ID to get gas fee estimates for. Defaults to the currently selected network.
 * @param enabled - Whether to enable gas fee estimation polling. Defaults to true.
 * @returns {GasEstimates} GasEstimates object
 */
function useGasFeeEstimates(_networkClientId, enabled = true) {
  const selectedNetworkClientId = (0, _reactRedux.useSelector)(_networks.getSelectedNetworkClientId);
  const networkClientId = _networkClientId ?? selectedNetworkClientId;
  const [chainId, setChainId] = (0, _react.useState)('');
  const gasEstimateType = (0, _reactRedux.useSelector)(state => (0, _metamask.getGasEstimateTypeByChainId)(state, chainId));
  const gasFeeEstimates = (0, _reactRedux.useSelector)(state => (0, _metamask.getGasFeeEstimatesByChainId)(state, chainId), _isEqual.default);
  const isGasEstimatesLoading = (0, _reactRedux.useSelector)(state => (0, _metamask.getIsGasEstimatesLoadingByChainId)(state, {
    chainId,
    networkClientId
  }));
  const isNetworkBusy = (0, _reactRedux.useSelector)(state => (0, _metamask.getIsNetworkBusyByChainId)(state, chainId));
  (0, _react.useEffect)(() => {
    if (!enabled) {
      return () => {
        // No cleanup needed when disabled
      };
    }
    let isMounted = true;
    (0, _actions.getNetworkConfigurationByNetworkClientId)(networkClientId).then(networkConfig => {
      if (networkConfig && isMounted) {
        setChainId(networkConfig.chainId);
      }
    });
    return () => {
      isMounted = false;
    };
  }, [networkClientId, enabled]);
  (0, _usePolling.default)({
    startPolling: input => (0, _actions.gasFeeStartPollingByNetworkClientId)(input.networkClientId),
    stopPollingByPollingToken: _actions.gasFeeStopPollingByPollingToken,
    input: {
      networkClientId
    },
    enabled
  });
  return {
    gasFeeEstimates,
    gasEstimateType,
    isGasEstimatesLoading,
    isNetworkBusy
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useGasFeeEstimates.js",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useGetAssetImageUrl.ts", {"../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseGetAssetImageUrl.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("react");
var _util = require("../helpers/utils/util");
const useGetAssetImageUrl = (image, ipfsGateway) => {
  const [imageUrl, setImageUrl] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    const getAssetImgUrl = async () => {
      const assetImageUrl = await (0, _util.getAssetImageURL)(image, ipfsGateway);
      setImageUrl(assetImageUrl);
    };
    getAssetImgUrl();
  }, [image, ipfsGateway]);
  return imageUrl;
};
var _default = exports.default = useGetAssetImageUrl;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useGetAssetImageUrl.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useGetFormattedTokensPerChain.ts", {"../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","./useTokenBalances":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTokenBalances.ts","bn.js":"D:\\code\\v\\metamask-extension\\node_modules\\bn.js\\lib\\bn.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseGetFormattedTokensPerChain.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetFormattedTokensPerChain = void 0;
var _reactRedux = require("react-redux");
var _bn = require("bn.js");
var _selectors = require("../selectors");
var _networks = require("../../shared/modules/selectors/networks");
var _conversion = require("../../shared/modules/conversion.utils");
var _useTokenBalances = require("./useTokenBalances");
const useGetFormattedTokensPerChain = (account, shouldHideZeroBalanceTokens, shouldGetTokensPerCurrentChain, allChainIDs) => {
  const currentChainId = (0, _reactRedux.useSelector)(_networks.getCurrentChainId);
  const importedTokens = (0, _reactRedux.useSelector)(_selectors.getAllTokens); // returns the tokens only when they are imported
  const currentTokenBalances = (0, _useTokenBalances.useTokenBalances)({
    chainIds: allChainIDs
  });

  // We will calculate aggregated balance only after the user imports the tokens to the wallet
  // we need to format the balances we get from useTokenBalances and match them with symbol and decimals we get from getAllTokens
  const networksToFormat = shouldGetTokensPerCurrentChain ? [currentChainId] : allChainIDs;
  const formattedTokensWithBalancesPerChain = networksToFormat.map(singleChain => {
    var _importedTokens$singl;
    const tokens = (importedTokens === null || importedTokens === void 0 || (_importedTokens$singl = importedTokens[singleChain]) === null || _importedTokens$singl === void 0 ? void 0 : _importedTokens$singl[account === null || account === void 0 ? void 0 : account.address]) ?? [];
    const tokensWithBalances = tokens.reduce((acc, token) => {
      var _currentTokenBalances;
      const hexBalance = ((_currentTokenBalances = currentTokenBalances.tokenBalances[account.address]) === null || _currentTokenBalances === void 0 || (_currentTokenBalances = _currentTokenBalances[singleChain]) === null || _currentTokenBalances === void 0 ? void 0 : _currentTokenBalances[token.address]) ?? '0x0';
      if (hexBalance !== '0x0' || !shouldHideZeroBalanceTokens) {
        const decimalBalance = (0, _conversion.hexToDecimal)(hexBalance);
        acc.push({
          address: token.address,
          symbol: token.symbol,
          decimals: token.decimals,
          balance: decimalBalance,
          string: (0, _useTokenBalances.stringifyBalance)(new _bn.BN(decimalBalance), new _bn.BN(token.decimals))
        });
      }
      return acc;
    }, []);
    return {
      chainId: singleChain,
      tokensWithBalances
    };
  });
  return {
    formattedTokensWithBalancesPerChain
  };
};
exports.useGetFormattedTokensPerChain = useGetFormattedTokensPerChain;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useGetFormattedTokensPerChain.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useIsOriginalNativeTokenSymbol.ts", {"../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../shared/lib/asset-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\asset-utils.ts","../helpers/utils/isOriginalNativeTokenSymbol":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\isOriginalNativeTokenSymbol.ts","../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseIsOriginalNativeTokenSymbol.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsOriginalNativeTokenSymbol = useIsOriginalNativeTokenSymbol;
var _react = require("react");
var _reactRedux = require("react-redux");
var _selectors = require("../selectors");
var _multichain = require("../selectors/multichain");
var _assetUtils = require("../../shared/lib/asset-utils");
var _util = require("../../app/scripts/lib/util");
var _isOriginalNativeTokenSymbol = require("../helpers/utils/isOriginalNativeTokenSymbol");
// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

function useIsOriginalNativeTokenSymbol(chainId, ticker, type, rpcUrl = '') {
  const [isOriginalNativeSymbol, setIsOriginalNativeSymbol] = (0, _react.useState)(false);
  const useSafeChainsListValidation = (0, _reactRedux.useSelector)(_selectors.useSafeChainsListValidationSelector);
  const isEvm = (0, _assetUtils.isEvmChainId)(chainId);
  const providerConfig = (0, _reactRedux.useSelector)(_multichain.getMultichainCurrentNetwork);
  (0, _react.useEffect)(() => {
    const isLocalhost = urlString => {
      const url = (0, _util.getValidUrl)(urlString);
      return url !== null && (url.hostname === 'localhost' || url.hostname === '127.0.0.1');
    };
    async function getNativeTokenSymbol(networkId) {
      if (!isEvm) {
        setIsOriginalNativeSymbol(ticker === (providerConfig === null || providerConfig === void 0 ? void 0 : providerConfig.ticker));
        return;
      }
      try {
        // exclude local dev network
        if (isLocalhost(rpcUrl)) {
          setIsOriginalNativeSymbol(true);
          return;
        }
        const isOriginalNativeToken = await (0, _isOriginalNativeTokenSymbol.isOriginalNativeTokenSymbol)({
          ticker,
          chainId: networkId,
          useAPICall: useSafeChainsListValidation
        });
        setIsOriginalNativeSymbol(isOriginalNativeToken);
      } catch (err) {
        setIsOriginalNativeSymbol(false);
      }
    }
    getNativeTokenSymbol(chainId);
  }, [isOriginalNativeSymbol, chainId, ticker, type, rpcUrl, useSafeChainsListValidation, isEvm, providerConfig === null || providerConfig === void 0 ? void 0 : providerConfig.ticker]);
  return isOriginalNativeSymbol;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useIsOriginalNativeTokenSymbol.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useIsOriginalTokenSymbol.js", {"../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseIsOriginalTokenSymbol.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsOriginalTokenSymbol = useIsOriginalTokenSymbol;
var _react = require("react");
var _reactRedux = require("react-redux");
var _actions = require("../store/actions");
var _selectors = require("../selectors");
// TODO: reconsider this approach altogether
// checking against on-chain data to see if a user has changed a token symbol is not ideal
// we should just keep track of the original symbol in state, or better yet, rely on the address instead of the symbol
// see: https://github.com/MetaMask/metamask-extension/pull/21610 (original PR)

/**
 * This hook determines whether a token uses the original symbol based on data not influenced by the user.
 *
 * @param {string} tokenAddress - the address of the token
 * @param {string} tokenSymbol - the local symbol of the token
 * @returns a boolean indicating whether the token uses the original symbol
 */
function useIsOriginalTokenSymbol(tokenAddress, tokenSymbol) {
  const [isOriginalNativeSymbol, setIsOriginalNativeSymbol] = (0, _react.useState)(null);
  const tokens = (0, _reactRedux.useSelector)(_selectors.getTokenList);
  (0, _react.useEffect)(() => {
    async function getTokenSymbolForToken(address) {
      var _tokens$address$toLow, _trueSymbol;
      // attempt to fetch from cache first
      let trueSymbol = (_tokens$address$toLow = tokens[address === null || address === void 0 ? void 0 : address.toLowerCase()]) === null || _tokens$address$toLow === void 0 ? void 0 : _tokens$address$toLow.symbol;

      // if tokens aren't available, fetch from the blockchain
      if (!trueSymbol) {
        trueSymbol = await (0, _actions.getTokenSymbol)(address);
      }

      // if the symbol is the same as the tokenSymbol, it's the original
      setIsOriginalNativeSymbol(((_trueSymbol = trueSymbol) === null || _trueSymbol === void 0 ? void 0 : _trueSymbol.toLowerCase()) === (tokenSymbol === null || tokenSymbol === void 0 ? void 0 : tokenSymbol.toLowerCase()));
    }
    getTokenSymbolForToken(tokenAddress);
    // no need to wait for tokens to load, since we'd fetch without them if they aren't available
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [tokenAddress, tokenSymbol]);
  return isOriginalNativeSymbol;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useIsOriginalTokenSymbol.js",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useMetametrics.ts", {"../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseMetametrics.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDisableMetametrics = useDisableMetametrics;
exports.useEnableMetametrics = useEnableMetametrics;
var _react = require("react");
var _reactRedux = require("react-redux");
var _loglevel = _interopRequireDefault(require("loglevel"));
var _actions = require("../store/actions");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * Provides a hook to enable MetaMetrics tracking.
 * This hook handles sets participation in MetaMetrics to true.
 *
 * @returns An object containing the `enableMetametrics` function, a `loading` boolean indicating the operation status, and an `error` string for error messages.
 */
function useEnableMetametrics() {
  const dispatch = (0, _reactRedux.useDispatch)();
  const [loading, setLoading] = (0, _react.useState)(false);
  const [error, setError] = (0, _react.useState)(null);
  const enableMetametrics = (0, _react.useCallback)(async () => {
    setLoading(true);
    dispatch((0, _actions.showLoadingIndication)());
    setError(null);
    try {
      await dispatch((0, _actions.setParticipateInMetaMetrics)(true));
    } catch (e) {
      setError(e instanceof Error ? e.message : 'An unexpected error occurred');
      _loglevel.default.error(e);
      throw e;
    } finally {
      setLoading(false);
      dispatch((0, _actions.hideLoadingIndication)());
    }
    dispatch((0, _actions.hideLoadingIndication)());
  }, [dispatch]);
  return {
    enableMetametrics,
    loading,
    error
  };
}

/**
 * Provides a hook to disable MetaMetrics tracking.
 *
 * @returns An object containing the `disableMetametrics` function, a `loading` boolean indicating the operation status, and an `error` string for error messages.
 */
function useDisableMetametrics() {
  const dispatch = (0, _reactRedux.useDispatch)();
  const [loading, setLoading] = (0, _react.useState)(false);
  const [error, setError] = (0, _react.useState)(null);
  const disableMetametrics = (0, _react.useCallback)(async () => {
    setLoading(true);
    dispatch((0, _actions.showLoadingIndication)());
    setError(null);
    try {
      await dispatch((0, _actions.setParticipateInMetaMetrics)(false));
    } catch (e) {
      setError(e instanceof Error ? e.message : 'An unexpected error occurred');
      throw e;
    } finally {
      setLoading(false);
      dispatch((0, _actions.hideLoadingIndication)());
    }
    dispatch((0, _actions.hideLoadingIndication)());
  }, [dispatch]);
  return {
    disableMetametrics,
    loading,
    error
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useMetametrics.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useModalProps.ts", {"../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseModalProps.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useModalProps = useModalProps;
var _reactRedux = require("react-redux");
var _actions = require("../store/actions");
function useModalProps() {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  const modalProps = (0, _reactRedux.useSelector)(state => {
    var _state$appState$modal;
    return (_state$appState$modal = state.appState.modal.modalState) === null || _state$appState$modal === void 0 ? void 0 : _state$appState$modal.props;
  });
  const dispatch = (0, _reactRedux.useDispatch)();
  const onHideModal = () => dispatch((0, _actions.hideModal)());
  return {
    props: modalProps,
    hideModal: onHideModal
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useModalProps.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultiPolling.ts", {"../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseMultiPolling.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _metamask = require("../ducks/metamask/metamask");
// A hook that manages multiple polling loops of a polling controller.
// Callers provide an array of inputs, and the hook manages starting
// and stopping polling loops for each input.
const useMultiPolling = usePollingOptions => {
  const completedOnboarding = (0, _reactRedux.useSelector)(_metamask.getCompletedOnboarding);
  const pollingTokens = (0, _react.useRef)(new Map());
  (0, _react.useEffect)(() => {
    if (!completedOnboarding) {
      // don't start polling if no selected account or onboarding is not completed yet
      return;
    }

    // start new polls
    for (const input of usePollingOptions.input) {
      const key = JSON.stringify(input);
      if (!pollingTokens.current.has(key)) {
        usePollingOptions.startPolling(input).then(token => pollingTokens.current.set(key, token));
      }
    }

    // stop existing polls
    for (const [inputKey, token] of pollingTokens.current.entries()) {
      const exists = usePollingOptions.input.some(i => inputKey === JSON.stringify(i));
      if (!exists) {
        usePollingOptions.stopPollingByPollingToken(token);
        pollingTokens.current.delete(inputKey);
      }
    }
  }, [completedOnboarding, usePollingOptions.input && JSON.stringify(usePollingOptions.input)]);

  // stop all polling on dismount
  (0, _react.useEffect)(() => {
    return () => {
      for (const token of pollingTokens.current.values()) {
        usePollingOptions.stopPollingByPollingToken(token);
      }
    };
  }, []);
};
var _default = exports.default = useMultiPolling;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useMultiPolling.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainAccountTotalFiatBalance.ts", {"../../shared/constants/multichain/assets":"D:\\code\\v\\metamask-extension\\shared\\constants\\multichain\\assets.ts","../helpers/utils/confirm-tx.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\confirm-tx.util.ts","../helpers/utils/token-util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\token-util.js","../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","./useAccountTotalFiatBalance":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAccountTotalFiatBalance.js","./useMultichainSelector":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainSelector.ts","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseMultichainAccountTotalFiatBalance.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMultichainAccountTotalFiatBalance = exports.EMPTY_VALUES = void 0;
var _reactRedux = require("react-redux");
var _keyringApi = require("@metamask/keyring-api");
var _multichain = require("../selectors/multichain");
var _confirmTx = require("../helpers/utils/confirm-tx.util");
var _assets = require("../../shared/constants/multichain/assets");
var _tokenUtil = require("../helpers/utils/token-util");
var _useMultichainSelector = require("./useMultichainSelector");
var _useAccountTotalFiatBalance = require("./useAccountTotalFiatBalance");
const EMPTY_VALUES = exports.EMPTY_VALUES = {
  formattedFiat: '0',
  totalFiatBalance: '0',
  totalWeiBalance: '0',
  tokensWithBalances: [],
  loading: false,
  orderedTokenList: []
};
const useMultichainAccountTotalFiatBalance = (account, shouldHideZeroBalanceTokens = false) => {
  var _balances$account$id;
  if ((0, _keyringApi.isEvmAccountType)(account.type)) {
    return (0, _useAccountTotalFiatBalance.useAccountTotalFiatBalance)(account, shouldHideZeroBalanceTokens);
  }
  const currentCurrency = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainCurrentCurrency, account);
  const {
    network
  } = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainNetwork, account);
  const {
    ticker
  } = network;
  const conversionRate = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainConversionRate, account);
  const nativeCurrencyImage = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainCurrencyImage, account);
  const balances = (0, _reactRedux.useSelector)(_multichain.getMultichainBalances);
  // TODO: find dynamic way to ensure balance is the highest denomination.
  const asset = _assets.MULTICHAIN_NATIVE_CURRENCY_TO_CAIP19[ticker];
  if (!(balances !== null && balances !== void 0 && (_balances$account$id = balances[account.id]) !== null && _balances$account$id !== void 0 && _balances$account$id[asset])) {
    // FIXME: We might try to get the balance for a created account, but the
    // MultichainBalancesController might not have updated it yet!
    return EMPTY_VALUES;
  }
  const {
    amount: balance
  } = balances[account.id][asset];
  const totalFiatBalance = (0, _tokenUtil.getTokenFiatAmount)(1,
  // coin to native conversion rate is 1:1
  Number(conversionRate),
  // native to fiat conversion rate
  currentCurrency, balance, ticker, false, false) ?? '0'; // if the conversion fails, return 0

  // Create an object with native token info. NOTE: Native token info is fetched from a separate controller
  const nativeTokenValues = {
    iconUrl: nativeCurrencyImage,
    symbol: ticker,
    fiatBalance: totalFiatBalance
  };

  // Fiat balance formatted in user's desired currency (ex: "$8.90")
  const formattedFiat = (0, _confirmTx.formatCurrency)(totalFiatBalance, currentCurrency);
  return {
    formattedFiat,
    totalFiatBalance,
    totalBalance: balance,
    tokensWithBalances: [],
    // TODO: support tokens
    loading: false,
    // TODO: support tokens
    orderedTokenList: [nativeTokenValues] // TODO: support tokens
  };
};
exports.useMultichainAccountTotalFiatBalance = useMultichainAccountTotalFiatBalance;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useMultichainAccountTotalFiatBalance.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainAccountsIntroModal.ts", {"../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../selectors/multichain-accounts/feature-flags":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\feature-flags.ts","../store/store":"D:\\code\\v\\metamask-extension\\ui\\store\\store.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseMultichainAccountsIntroModal.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMultichainAccountsIntroModal = useMultichainAccountsIntroModal;
var _react = require("react");
var _store = require("../store/store");
var _featureFlags = require("../selectors/multichain-accounts/feature-flags");
var _routes = require("../helpers/constants/routes");
/**
 * Hook to manage the multichain accounts intro modal display logic
 * Keeps the routes component clean by encapsulating modal state logic
 *
 * @param isUnlocked - Whether the wallet is currently unlocked
 * @param location - Router location object containing pathname
 * @param location.pathname - Current route pathname
 * @returns Object containing modal state and setter function
 */
function useMultichainAccountsIntroModal(isUnlocked, location) {
  const [showMultichainIntroModal, setShowMultichainIntroModal] = (0, _react.useState)(false);
  const isMultichainAccountsState2Enabled = (0, _store.useAppSelector)(_featureFlags.getIsMultichainAccountsState2Enabled);
  const hasShownMultichainAccountsIntroModal = (0, _store.useAppSelector)(state => state.metamask.hasShownMultichainAccountsIntroModal);
  const lastUpdatedAt = (0, _store.useAppSelector)(state => state.metamask.lastUpdatedAt);
  (0, _react.useEffect)(() => {
    // Only show modal on the main wallet/home route
    const isMainWalletArea = location.pathname === _routes.DEFAULT_ROUTE;

    // Show modal for upgrades only (simple lastUpdatedAt pattern like update modal)
    const shouldShowModal = isUnlocked && isMultichainAccountsState2Enabled && !hasShownMultichainAccountsIntroModal && lastUpdatedAt !== null &&
    // null = fresh install, timestamp = upgrade
    isMainWalletArea;
    setShowMultichainIntroModal(shouldShowModal);
  }, [isUnlocked, isMultichainAccountsState2Enabled, hasShownMultichainAccountsIntroModal, lastUpdatedAt, location.pathname]);
  return {
    showMultichainIntroModal,
    setShowMultichainIntroModal
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useMultichainAccountsIntroModal.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainAssetsRatesPolling.ts", {"../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../store/controller-actions/multichain-asset-rates-controller":"D:\\code\\v\\metamask-extension\\ui\\store\\controller-actions\\multichain-asset-rates-controller.ts","./usePolling":"D:\\code\\v\\metamask-extension\\ui\\hooks\\usePolling.ts","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseMultichainAssetsRatesPolling.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactRedux = require("react-redux");
var _metamask = require("../ducks/metamask/metamask");
var _selectors = require("../selectors");
var _multichainAssetRatesController = require("../store/controller-actions/multichain-asset-rates-controller");
var _usePolling = _interopRequireDefault(require("./usePolling"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const usePollingEnabled = () => {
  const completedOnboarding = (0, _reactRedux.useSelector)(_metamask.getCompletedOnboarding);
  const isUnlocked = (0, _reactRedux.useSelector)(_metamask.getIsUnlocked);
  const useCurrencyRateCheck = (0, _reactRedux.useSelector)(_selectors.getUseCurrencyRateCheck);
  return completedOnboarding && isUnlocked && useCurrencyRateCheck;
};
const useSelectedAccountId = () => {
  const account = (0, _reactRedux.useSelector)(_selectors.getSelectedInternalAccount);
  return (account === null || account === void 0 ? void 0 : account.id) ?? '';
};
const useMultichainAssetsRatesPolling = () => {
  const pollingEnabled = usePollingEnabled();
  const accountId = useSelectedAccountId();
  (0, _usePolling.default)({
    startPolling: _multichainAssetRatesController.multichainAssetsRatesStartPolling,
    stopPollingByPollingToken: _multichainAssetRatesController.multichainAssetsRatesStopPollingByPollingToken,
    input: accountId,
    enabled: pollingEnabled
  });
};
var _default = exports.default = useMultichainAssetsRatesPolling;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useMultichainAssetsRatesPolling.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainBalances.ts", {"../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../selectors/assets":"D:\\code\\v\\metamask-extension\\ui\\selectors\\assets.ts","../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../selectors/multichain-accounts/account-tree":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\account-tree.ts","./useMultichainSelector":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainSelector.ts","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","bignumber.js":"D:\\code\\v\\metamask-extension\\node_modules\\bignumber.js\\bignumber.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseMultichainBalances.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMultichainBalances = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _utils = require("@metamask/utils");
var _keyringApi = require("@metamask/keyring-api");
var _bignumber = require("bignumber.js");
var _transaction = require("../../shared/constants/transaction");
var _assets = require("../selectors/assets");
var _multichain = require("../selectors/multichain");
var _accountTree = require("../selectors/multichain-accounts/account-tree");
var _useMultichainSelector = require("./useMultichainSelector");
const useNonEvmAssetsWithBalances = accountId => {
  // non-evm tokens owned by non-evm account, includes native and non-native assets
  const assetsByAccountId = (0, _reactRedux.useSelector)(_assets.getAccountAssets);
  const assetMetadataById = (0, _reactRedux.useSelector)(_assets.getAssetsMetadata);

  // includes native and asset balances for non-evm account
  const nonEvmBalancesByAccountId = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainBalances);
  // asset exchange rates
  const assetRates = (0, _reactRedux.useSelector)(_assets.getAssetsRates);
  const nonEvmTokensWithFiatBalances = (0, _react.useMemo)(() => {
    if (!accountId) {
      return [];
    }
    const assetIds = assetsByAccountId === null || assetsByAccountId === void 0 ? void 0 : assetsByAccountId[accountId];
    const balancesByAssetId = nonEvmBalancesByAccountId === null || nonEvmBalancesByAccountId === void 0 ? void 0 : nonEvmBalancesByAccountId[accountId];
    if (!balancesByAssetId || !assetIds) {
      return [];
    }
    // build TokenWithFiat for each asset
    return assetIds.filter(caipAssetId => assetMetadataById[caipAssetId]).map(caipAssetId => {
      var _assetMetadataById$ca, _balancesByAssetId$ca, _balancesByAssetId$ca2, _assetMetadataById$ca2, _assetMetadataById$ca3, _balancesByAssetId$ca3, _assetRates$caipAsset;
      const {
        chainId,
        assetReference,
        assetNamespace
      } = (0, _utils.parseCaipAssetType)(caipAssetId);
      return {
        chainId,
        symbol: ((_assetMetadataById$ca = assetMetadataById[caipAssetId]) === null || _assetMetadataById$ca === void 0 ? void 0 : _assetMetadataById$ca.symbol) ?? '',
        assetId: caipAssetId,
        address: assetReference,
        string: ((_balancesByAssetId$ca = balancesByAssetId[caipAssetId]) === null || _balancesByAssetId$ca === void 0 ? void 0 : _balancesByAssetId$ca.amount) ?? '0',
        balance: ((_balancesByAssetId$ca2 = balancesByAssetId[caipAssetId]) === null || _balancesByAssetId$ca2 === void 0 ? void 0 : _balancesByAssetId$ca2.amount) ?? '0',
        decimals: (_assetMetadataById$ca2 = assetMetadataById[caipAssetId]) === null || _assetMetadataById$ca2 === void 0 || (_assetMetadataById$ca2 = _assetMetadataById$ca2.units[0]) === null || _assetMetadataById$ca2 === void 0 ? void 0 : _assetMetadataById$ca2.decimals,
        image: ((_assetMetadataById$ca3 = assetMetadataById[caipAssetId]) === null || _assetMetadataById$ca3 === void 0 ? void 0 : _assetMetadataById$ca3.iconUrl) ?? '',
        type: assetNamespace === 'token' ? _transaction.AssetType.token : _transaction.AssetType.native,
        tokenFiatAmount: new _bignumber.BigNumber(((_balancesByAssetId$ca3 = balancesByAssetId[caipAssetId]) === null || _balancesByAssetId$ca3 === void 0 ? void 0 : _balancesByAssetId$ca3.amount) ?? '1').times((assetRates === null || assetRates === void 0 || (_assetRates$caipAsset = assetRates[caipAssetId]) === null || _assetRates$caipAsset === void 0 ? void 0 : _assetRates$caipAsset.rate) ?? '1').toNumber()
      };
    }).filter(Boolean);
  }, [assetMetadataById, assetRates, assetsByAccountId, accountId, nonEvmBalancesByAccountId]);
  return nonEvmTokensWithFiatBalances;
};

/**
 * This hook is used to get the balances of all tokens and native tokens across all chains
 * This also returns the total fiat balances by chainId/caipChainId
 *
 * @param accountAddress - the accountAddress to use for the token list, if not provided, the selected account will be used
 */
const useMultichainBalances = accountAddress => {
  // Use accountAddress's account group if it exists, otherwise use the selected account group
  const selectedAccountGroup = (0, _reactRedux.useSelector)(_accountTree.getSelectedAccountGroup);
  const [requestedAccountGroup] = (0, _reactRedux.useSelector)(state => (0, _accountTree.getAccountGroupsByAddress)(state, [accountAddress ?? '']));
  const accountGroupIdToUse = (requestedAccountGroup === null || requestedAccountGroup === void 0 ? void 0 : requestedAccountGroup.id) ?? selectedAccountGroup;

  // Get internal account to use for each supported scope
  const evmAccount = (0, _reactRedux.useSelector)(state => (0, _accountTree.getInternalAccountByGroupAndCaip)(state, accountGroupIdToUse, 'eip155:1'));
  const solanaAccount = (0, _reactRedux.useSelector)(state => (0, _accountTree.getInternalAccountByGroupAndCaip)(state, accountGroupIdToUse, _keyringApi.SolScope.Mainnet));
  const bitcoinAccount = (0, _reactRedux.useSelector)(state => (0, _accountTree.getInternalAccountByGroupAndCaip)(state, accountGroupIdToUse, _keyringApi.BtcScope.Mainnet));

  // EVM balances
  const evmBalancesWithFiatByChainId = (0, _reactRedux.useSelector)(state => (0, _assets.getTokenBalancesEvm)(state, evmAccount === null || evmAccount === void 0 ? void 0 : evmAccount.address));
  // Solana balances
  const solanaBalancesWithFiat = useNonEvmAssetsWithBalances(solanaAccount === null || solanaAccount === void 0 ? void 0 : solanaAccount.id);
  // Bitcoin balances
  const bitcoinBalancesWithFiat = useNonEvmAssetsWithBalances(bitcoinAccount === null || bitcoinAccount === void 0 ? void 0 : bitcoinAccount.id);

  // return TokenWithFiat sorted by fiat balance amount
  const assetsWithBalance = (0, _react.useMemo)(() => {
    return [...evmBalancesWithFiatByChainId, ...solanaBalancesWithFiat, ...bitcoinBalancesWithFiat].map(token => ({
      ...token,
      type: token.isNative ? _transaction.AssetType.native : _transaction.AssetType.token
    })).sort((a, b) => (b.tokenFiatAmount ?? 0) - (a.tokenFiatAmount ?? 0));
  }, [evmBalancesWithFiatByChainId, solanaBalancesWithFiat, bitcoinBalancesWithFiat]);

  // return total fiat balances by chainId/caipChainId
  const balanceByChainId = (0, _react.useMemo)(() => {
    return [...evmBalancesWithFiatByChainId, ...solanaBalancesWithFiat, ...bitcoinBalancesWithFiat].reduce((acc, tokenWithBalanceData) => {
      if (!acc[tokenWithBalanceData.chainId]) {
        acc[tokenWithBalanceData.chainId] = 0;
      }
      acc[tokenWithBalanceData.chainId] += tokenWithBalanceData.tokenFiatAmount ?? 0;
      return acc;
    }, {});
  }, [evmBalancesWithFiatByChainId, solanaBalancesWithFiat, bitcoinBalancesWithFiat]);
  return {
    assetsWithBalance,
    balanceByChainId
  };
};
exports.useMultichainBalances = useMultichainBalances;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useMultichainBalances.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainSelector.ts", {"../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseMultichainSelector.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMultichainSelector = useMultichainSelector;
var _reactRedux = require("react-redux");
var _selectors = require("../selectors");
function useMultichainSelector(selector, account) {
  return (0, _reactRedux.useSelector)(state => {
    // We either pass an account or fallback to the currently selected one
    // @ts-expect-error state types don't match
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    return selector(state, account || (0, _selectors.getSelectedInternalAccount)(state));
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useMultichainSelector.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainTransactionDisplay.ts", {"../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../components/app/assets/util/formatWithThreshold":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\util\\formatWithThreshold.ts","../ducks/locale/locale":"D:\\code\\v\\metamask-extension\\ui\\ducks\\locale\\locale.ts","./useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/multichain-network-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-network-controller\\dist\\index.cjs","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseMultichainTransactionDisplay.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KEYRING_TRANSACTION_STATUS_KEY = void 0;
exports.useMultichainTransactionDisplay = useMultichainTransactionDisplay;
var _keyringApi = require("@metamask/keyring-api");
var _transactionController = require("@metamask/transaction-controller");
var _multichainNetworkController = require("@metamask/multichain-network-controller");
var _reactRedux = require("react-redux");
var _formatWithThreshold = require("../components/app/assets/util/formatWithThreshold");
var _locale = require("../ducks/locale/locale");
var _transaction = require("../../shared/constants/transaction");
var _useI18nContext = require("./useI18nContext");
const KEYRING_TRANSACTION_STATUS_KEY = exports.KEYRING_TRANSACTION_STATUS_KEY = {
  [_keyringApi.TransactionStatus.Failed]: _transactionController.TransactionStatus.failed,
  [_keyringApi.TransactionStatus.Confirmed]: _transactionController.TransactionStatus.confirmed,
  [_keyringApi.TransactionStatus.Unconfirmed]: _transaction.TransactionGroupStatus.pending,
  [_keyringApi.TransactionStatus.Submitted]: _transactionController.TransactionStatus.submitted
};
function useMultichainTransactionDisplay(transaction, networkConfig) {
  const locale = (0, _reactRedux.useSelector)(_locale.getIntlLocale);
  const {
    chainId
  } = networkConfig;
  const decimalPlaces = _multichainNetworkController.MULTICHAIN_NETWORK_DECIMAL_PLACES[chainId];
  const t = (0, _useI18nContext.useI18nContext)();
  const from = aggregateAmount(transaction.from, true, locale, decimalPlaces);
  const to = aggregateAmount(transaction.to, transaction.type === _keyringApi.TransactionType.Send, locale, decimalPlaces);
  const baseFee = aggregateAmount((transaction.fees || []).filter(fee => fee.type === 'base'), true, locale);
  const priorityFee = aggregateAmount((transaction.fees || []).filter(fee => fee.type === 'priority'), true, locale);
  const typeToTitle = {
    // TODO: Add support for other transaction types
    [_keyringApi.TransactionType.Send]: t('sent'),
    [_keyringApi.TransactionType.Receive]: t('received'),
    [_keyringApi.TransactionType.Swap]: `${t('swap')} ${from === null || from === void 0 ? void 0 : from.unit} ${t('to').toLowerCase()} ${to === null || to === void 0 ? void 0 : to.unit}`,
    [_keyringApi.TransactionType.Unknown]: t('interaction')
  };
  return {
    ...transaction,
    title: typeToTitle[transaction.type],
    from,
    to,
    baseFee,
    priorityFee,
    isRedeposit: transaction.to.length === 0 && transaction.type === _keyringApi.TransactionType.Send
  };
}
function aggregateAmount(movement, isNegative, locale, decimals) {
  const amountByAsset = {};
  for (const mv of movement) {
    if (!(mv !== null && mv !== void 0 && mv.asset.fungible)) {
      continue;
    }
    const assetId = mv.asset.type;
    if (!amountByAsset[assetId]) {
      amountByAsset[assetId] = {
        amount: parseFloat(mv.asset.amount),
        address: mv.address,
        unit: mv.asset.unit
      };
      continue;
    }
    amountByAsset[assetId].amount += parseFloat(mv.asset.amount);
  }

  // We make an assumption that there is only one asset in the transaction.
  return Object.entries(amountByAsset).map(([_, mv]) => parseAsset(mv, locale, isNegative, decimals))[0];
}
function parseAsset(movement, locale, isNegative, decimals) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  const threshold = 1 / 10 ** (decimals || 8); // Smallest unit to display given the decimals.
  const displayAmount = (0, _formatWithThreshold.formatWithThreshold)(movement.amount, threshold, locale, {
    minimumFractionDigits: 0,
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    maximumFractionDigits: decimals || 8
  });
  let finalAmount = displayAmount;
  if (isNegative) {
    finalAmount = `-${displayAmount}`;
  }
  return {
    ...movement,
    amount: finalAmount
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useMultichainTransactionDisplay.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useName.ts", {"../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","@metamask/name-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\name-controller\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseName.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useName = useName;
exports.useNames = useNames;
var _nameController = require("@metamask/name-controller");
var _reactRedux = require("react-redux");
var _lodash = require("lodash");
var _selectors = require("../selectors");
function useName(value, type, variation) {
  return useNames([{
    value,
    type,
    variation
  }])[0];
}
function useNames(requests) {
  const names = (0, _reactRedux.useSelector)(_selectors.getNames, _lodash.isEqual);
  return requests.map(({
    value,
    type,
    variation
  }) => {
    var _names$type;
    const normalizedValue = normalizeValue(value, type);
    const variationsToNameEntries = ((_names$type = names[type]) === null || _names$type === void 0 ? void 0 : _names$type[normalizedValue]) ?? {};
    const variationEntry = variationsToNameEntries[variation];
    const fallbackEntry = variationsToNameEntries[_nameController.FALLBACK_VARIATION];
    const entry = !(variationEntry !== null && variationEntry !== void 0 && variationEntry.name) && fallbackEntry ? fallbackEntry : variationEntry ?? {};
    const {
      name = null,
      sourceId = null,
      origin = null,
      proposedNames = {}
    } = entry;
    return {
      name,
      sourceId,
      proposedNames,
      origin
    };
  });
}
function normalizeValue(value, type) {
  switch (type) {
    case _nameController.NameType.ETHEREUM_ADDRESS:
      return value.toLowerCase();
    default:
      return value;
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useName.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useNetworkConnectionBanner.ts", {"../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../shared/lib/network-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\network-utils.ts","../../shared/lib/only-keep-host":"D:\\code\\v\\metamask-extension\\shared\\lib\\only-keep-host.ts","../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../contexts/metametrics":"D:\\code\\v\\metamask-extension\\ui\\contexts\\metametrics.js","../selectors/multichain/networks":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain\\networks.ts","../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseNetworkConnectionBanner.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNetworkConnectionBanner = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _utils = require("@metamask/utils");
var _networks = require("../selectors/multichain/networks");
var _selectors = require("../selectors/selectors");
var _actions = require("../store/actions");
var _metametrics = require("../contexts/metametrics");
var _metametrics2 = require("../../shared/constants/metametrics");
var _network = require("../../shared/constants/network");
var _networks2 = require("../../shared/modules/selectors/networks");
var _onlyKeepHost = require("../../shared/lib/only-keep-host");
var _networkUtils = require("../../shared/lib/network-utils");
const DEGRADED_BANNER_TIMEOUT = 5 * 1000;
const UNAVAILABLE_BANNER_TIMEOUT = 30 * 1000;
const useNetworkConnectionBanner = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const trackEvent = (0, _react.useContext)(_metametrics.MetaMetricsContext);
  const firstUnavailableEvmNetwork = (0, _reactRedux.useSelector)(_networks.selectFirstUnavailableEvmNetwork);
  const networkConnectionBannerState = (0, _reactRedux.useSelector)(_selectors.getNetworkConnectionBanner);
  const networkConfigurationsByChainId = (0, _reactRedux.useSelector)(_networks2.getNetworkConfigurationsByChainId);
  const timersRef = (0, _react.useRef)({});
  const clearDegradedTimer = (0, _react.useCallback)(() => {
    if (timersRef.current.degradedTimer) {
      clearTimeout(timersRef.current.degradedTimer);
      timersRef.current.degradedTimer = undefined;
    }
  }, []);
  const clearUnavailableTimer = (0, _react.useCallback)(() => {
    if (timersRef.current.unavailableTimer) {
      clearTimeout(timersRef.current.unavailableTimer);
      timersRef.current.unavailableTimer = undefined;
    }
  }, []);
  const clearTimers = (0, _react.useCallback)(() => {
    clearDegradedTimer();
    clearUnavailableTimer();
  }, [clearDegradedTimer, clearUnavailableTimer]);
  const trackNetworkBannerEvent = (0, _react.useCallback)(({
    bannerType,
    eventName,
    networkClientId
  }) => {
    if (!_network.infuraProjectId) {
      console.warn('Infura project ID not found, cannot track network banner event');
      return;
    }
    let foundNetwork;
    for (const networkConfiguration of Object.values(networkConfigurationsByChainId)) {
      const rpcEndpoint = networkConfiguration.rpcEndpoints.find(endpoint => endpoint.networkClientId === networkClientId);
      if (rpcEndpoint) {
        foundNetwork = {
          chainId: networkConfiguration.chainId,
          url: rpcEndpoint.url
        };
        break;
      }
    }
    if (!foundNetwork) {
      console.warn(`RPC endpoint not found for network client ID: ${networkClientId}`);
      return;
    }
    const rpcUrl = foundNetwork.url;
    const chainIdAsDecimal = (0, _utils.hexToNumber)(foundNetwork.chainId);
    const sanitizedRpcUrl = (0, _networkUtils.isPublicEndpointUrl)(rpcUrl, _network.infuraProjectId) ? (0, _onlyKeepHost.onlyKeepHost)(rpcUrl) : 'custom';
    trackEvent({
      category: _metametrics2.MetaMetricsEventCategory.Network,
      event: eventName,
      // The names of Segment properties have a particular case.
      /* eslint-disable @typescript-eslint/naming-convention */
      properties: {
        banner_type: bannerType,
        chain_id_caip: `eip155:${chainIdAsDecimal}`,
        rpc_endpoint_url: sanitizedRpcUrl
      }
      /* eslint-enable @typescript-eslint/naming-convention */
    });
  }, [networkConfigurationsByChainId, trackEvent]);
  const startUnavailableTimer = (0, _react.useCallback)(() => {
    clearUnavailableTimer();
    timersRef.current.unavailableTimer = setTimeout(() => {
      if (firstUnavailableEvmNetwork) {
        trackNetworkBannerEvent({
          bannerType: 'unavailable',
          eventName: _metametrics2.MetaMetricsEventName.NetworkConnectionBannerShown,
          networkClientId: firstUnavailableEvmNetwork.networkClientId
        });
        dispatch((0, _actions.updateNetworkConnectionBanner)({
          status: 'unavailable',
          networkName: firstUnavailableEvmNetwork.networkName,
          networkClientId: firstUnavailableEvmNetwork.networkClientId,
          chainId: firstUnavailableEvmNetwork.chainId,
          isInfuraEndpoint: firstUnavailableEvmNetwork.isInfuraEndpoint
        }));
      }
    }, UNAVAILABLE_BANNER_TIMEOUT - DEGRADED_BANNER_TIMEOUT);
  }, [firstUnavailableEvmNetwork, trackNetworkBannerEvent, dispatch, clearUnavailableTimer]);
  const startDegradedTimer = (0, _react.useCallback)(() => {
    clearDegradedTimer();
    timersRef.current.degradedTimer = setTimeout(() => {
      if (firstUnavailableEvmNetwork) {
        trackNetworkBannerEvent({
          bannerType: 'degraded',
          eventName: _metametrics2.MetaMetricsEventName.NetworkConnectionBannerShown,
          networkClientId: firstUnavailableEvmNetwork.networkClientId
        });
        dispatch((0, _actions.updateNetworkConnectionBanner)({
          status: 'degraded',
          networkName: firstUnavailableEvmNetwork.networkName,
          networkClientId: firstUnavailableEvmNetwork.networkClientId,
          chainId: firstUnavailableEvmNetwork.chainId,
          isInfuraEndpoint: firstUnavailableEvmNetwork.isInfuraEndpoint
        }));
        startUnavailableTimer();
      }
    }, DEGRADED_BANNER_TIMEOUT);
  }, [firstUnavailableEvmNetwork, trackNetworkBannerEvent, dispatch, startUnavailableTimer, clearDegradedTimer]);

  // If the first unavailable network does not change but the status changes, start the degraded or unavailable timer
  // If the first unavailable network changes, reset all timers and change the status

  (0, _react.useEffect)(() => {
    if (firstUnavailableEvmNetwork) {
      if (networkConnectionBannerState.status === 'degraded') {
        startUnavailableTimer();
      } else if (networkConnectionBannerState.status === 'unknown' || networkConnectionBannerState.status === 'available') {
        startDegradedTimer();
      }
    } else if (networkConnectionBannerState.status !== 'available') {
      dispatch((0, _actions.updateNetworkConnectionBanner)({
        status: 'available'
      }));
    }
    return () => {
      clearTimers();
    };
  }, [firstUnavailableEvmNetwork, clearTimers, dispatch, networkConnectionBannerState.status, startDegradedTimer, startUnavailableTimer]);
  return {
    ...networkConnectionBannerState,
    trackNetworkBannerEvent
  };
};
exports.useNetworkConnectionBanner = useNetworkConnectionBanner;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useNetworkConnectionBanner.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useNftCollectionsMetadata.ts", {"../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./useAsync":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useAsync.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseNftCollectionsMetadata.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNftCollectionsMetadata = useNftCollectionsMetadata;
var _transaction = require("../../shared/constants/transaction");
var _actions = require("../store/actions");
var _useAsync = require("./useAsync");
// For now, we only support ERC721 tokens
const SUPPORTED_NFT_TOKEN_STANDARDS = [_transaction.TokenStandard.ERC721];
function useNftCollectionsMetadata(requests) {
  const {
    value: collectionsMetadata
  } = (0, _useAsync.useAsyncResult)(() => fetchCollections(requests), [JSON.stringify(requests)]);
  return collectionsMetadata ?? {};
}
async function fetchCollections(requests) {
  const valuesByChainId = requests.reduce((acc, {
    chainId,
    contractAddress
  }) => {
    acc[chainId] = [...(acc[chainId] ?? []), contractAddress.toLowerCase()];
    return acc;
  }, {});
  const chainIds = Object.keys(valuesByChainId);
  const responses = await Promise.all(chainIds.map(chainId => {
    const contractAddresses = valuesByChainId[chainId];
    return fetchCollectionsForChain(contractAddresses, chainId);
  }));
  return chainIds.reduce((acc, chainId, index) => {
    acc[chainId] = responses[index];
    return acc;
  }, {});
}
async function fetchCollectionsForChain(contractAddresses, chainId) {
  const contractStandardsResponses = await Promise.all(contractAddresses.map(contractAddress => (0, _actions.getTokenStandardAndDetails)(contractAddress, chainId)));
  const supportedNFTContracts = contractAddresses.filter((_contractAddress, index) => SUPPORTED_NFT_TOKEN_STANDARDS.includes(contractStandardsResponses[index].standard));
  if (supportedNFTContracts.length === 0) {
    return {};
  }
  const collectionsResult = await (0, _actions.getNFTContractInfo)(supportedNFTContracts, chainId);
  const collectionsData = collectionsResult.collections.reduce((acc, collection, index) => {
    acc[supportedNFTContracts[index]] = {
      name: collection === null || collection === void 0 ? void 0 : collection.name,
      image: collection === null || collection === void 0 ? void 0 : collection.image,
      isSpam: collection === null || collection === void 0 ? void 0 : collection.isSpam
    };
    return acc;
  }, {});
  return collectionsData;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useNftCollectionsMetadata.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useNfts.ts", {"../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../selectors/multichain/networks":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain\\networks.ts","./useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","./usePrevious":"D:\\code\\v\\metamask-extension\\ui\\hooks\\usePrevious.ts","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseNfts.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNfts = useNfts;
var _react = require("react");
var _reactRedux = require("react-redux");
var _lodash = require("lodash");
var _metamask = require("../ducks/metamask/metamask");
var _selectors = require("../selectors");
var _networks = require("../selectors/multichain/networks");
var _networks2 = require("../../shared/modules/selectors/networks");
var _trace = require("../../shared/lib/trace");
var _usePrevious = require("./usePrevious");
var _useI18nContext = require("./useI18nContext");
function useNfts({
  overridePopularNetworkFilter = false
} = {}) {
  const t = (0, _useI18nContext.useI18nContext)();
  const allUserNfts = (0, _reactRedux.useSelector)(_metamask.getAllNfts);
  const {
    address: selectedAddress
  } = (0, _reactRedux.useSelector)(_selectors.getSelectedInternalAccount);
  const chainId = (0, _reactRedux.useSelector)(_networks2.getCurrentChainId);
  const allChainIds = (0, _reactRedux.useSelector)(_selectors.getAllChainsToPoll);
  const isTokenNetworkFilterEqualCurrentNetwork = (0, _reactRedux.useSelector)(_selectors.getIsTokenNetworkFilterEqualCurrentNetwork);
  const enabledNetworksByNamespace = (0, _reactRedux.useSelector)(_networks.getEnabledNetworksByNamespace);
  const nfts = (0, _react.useMemo)(() => {
    if (_selectors.isGlobalNetworkSelectorRemoved) {
      // Filter NFTs to only include those from enabled networks
      const nftsFromEnabledNetworks = {};
      if (overridePopularNetworkFilter) {
        return (allUserNfts === null || allUserNfts === void 0 ? void 0 : allUserNfts[chainId]) ?? [];
      }
      Object.entries(allUserNfts ?? {}).forEach(([networkChainId, networkNfts]) => {
        if (enabledNetworksByNamespace !== null && enabledNetworksByNamespace !== void 0 && enabledNetworksByNamespace[networkChainId] && Array.isArray(networkNfts)) {
          nftsFromEnabledNetworks[networkChainId] = networkNfts;
        }
      });
      return nftsFromEnabledNetworks;
    }
    (0, _trace.trace)({
      name: _trace.TraceName.LoadCollectibles
    });
    const nftList = isTokenNetworkFilterEqualCurrentNetwork || overridePopularNetworkFilter ? (allUserNfts === null || allUserNfts === void 0 ? void 0 : allUserNfts[chainId]) ?? [] : allUserNfts;
    (0, _trace.endTrace)({
      name: _trace.TraceName.LoadCollectibles
    });
    return nftList;
  }, [isTokenNetworkFilterEqualCurrentNetwork, overridePopularNetworkFilter, allUserNfts, chainId, enabledNetworksByNamespace]);
  const nftContracts = (0, _reactRedux.useSelector)(_metamask.getNftContracts);
  const previouslyOwnedText = t('nftsPreviouslyOwned');
  const unknownCollectionText = t('unknownCollection');
  const [currentlyOwnedNfts, setCurrentlyOwnedNfts] = (0, _react.useState)([]);
  const [previouslyOwnedNfts, setPreviouslyOwnedNfts] = (0, _react.useState)([]);
  const [loading, setNftsLoading] = (0, _react.useState)(() => (nfts === null || nfts === void 0 ? void 0 : nfts.length) >= 0);
  const prevNfts = (0, _usePrevious.usePrevious)(nfts);
  const prevChainId = (0, _usePrevious.usePrevious)(allChainIds);
  const prevSelectedAddress = (0, _usePrevious.usePrevious)(selectedAddress);
  (0, _react.useEffect)(() => {
    const selectNfts = () => {
      setNftsLoading(true);
      if (selectedAddress === undefined || allChainIds === undefined) {
        return;
      }
      const previousNfts = [];
      const currentNfts = [];
      const allNfts = Object.values(nfts).flat();
      allNfts.forEach(nft => {
        if ((nft === null || nft === void 0 ? void 0 : nft.isCurrentlyOwned) === false) {
          previousNfts.push(nft);
        } else {
          currentNfts.push(nft);
        }
      });
      setPreviouslyOwnedNfts(previousNfts);
      setCurrentlyOwnedNfts(currentNfts);
      setNftsLoading(false);
    };
    if (!(0, _lodash.isEqual)(prevNfts, nfts) || !(0, _lodash.isEqual)(prevSelectedAddress, selectedAddress) || !(0, _lodash.isEqual)(prevChainId, chainId)) {
      selectNfts();
    }
  }, [nfts, prevNfts, nftContracts, setNftsLoading, chainId, prevChainId, selectedAddress, prevSelectedAddress, previouslyOwnedText, unknownCollectionText, allChainIds]);
  return {
    loading,
    currentlyOwnedNfts,
    previouslyOwnedNfts
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useNfts.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useNftsCollections.js", {"../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../helpers/utils/nfts":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\nfts.ts","../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../selectors/multichain/networks":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain\\networks.ts","./useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","./usePrevious":"D:\\code\\v\\metamask-extension\\ui\\hooks\\usePrevious.ts","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseNftsCollections.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNftsCollections = useNftsCollections;
var _react = require("react");
var _reactRedux = require("react-redux");
var _lodash = require("lodash");
var _metamask = require("../ducks/metamask/metamask");
var _selectors = require("../selectors");
var _networks = require("../selectors/multichain/networks");
var _networks2 = require("../../shared/modules/selectors/networks");
var _nfts = require("../helpers/utils/nfts");
var _usePrevious = require("./usePrevious");
var _useI18nContext = require("./useI18nContext");
function useNftsCollections() {
  const t = (0, _useI18nContext.useI18nContext)();
  const previouslyOwnedText = t('nftsPreviouslyOwned');
  const unknownCollectionText = t('unknownCollection');
  const [collections, setCollections] = (0, _react.useState)({});
  const [previouslyOwnedCollection, setPreviouslyOwnedCollection] = (0, _react.useState)({
    collectionName: previouslyOwnedText,
    nfts: []
  });
  const isTokenNetworkFilterEqualCurrentNetwork = (0, _reactRedux.useSelector)(_selectors.getIsTokenNetworkFilterEqualCurrentNetwork);
  const allUserNfts = (0, _reactRedux.useSelector)(_metamask.getAllNfts);
  const enabledNetworksByNamespace = (0, _reactRedux.useSelector)(_networks.getEnabledNetworksByNamespace);
  const {
    address: selectedAddress
  } = (0, _reactRedux.useSelector)(_selectors.getSelectedInternalAccount);
  const chainId = (0, _reactRedux.useSelector)(_networks2.getCurrentChainId);
  const nfts = (0, _react.useMemo)(() => {
    if (_selectors.isGlobalNetworkSelectorRemoved) {
      // Filter NFTs to only include those from enabled networks
      const nftsFromEnabledNetworks = {};
      Object.entries(allUserNfts ?? {}).forEach(([networkChainId, networkNfts]) => {
        if (enabledNetworksByNamespace !== null && enabledNetworksByNamespace !== void 0 && enabledNetworksByNamespace[networkChainId] && Array.isArray(networkNfts)) {
          nftsFromEnabledNetworks[networkChainId] = networkNfts;
        }
      });
      return nftsFromEnabledNetworks;
    }
    return isTokenNetworkFilterEqualCurrentNetwork ? (allUserNfts === null || allUserNfts === void 0 ? void 0 : allUserNfts[chainId]) ?? [] : allUserNfts;
  }, [isTokenNetworkFilterEqualCurrentNetwork, allUserNfts, chainId, enabledNetworksByNamespace]);
  const [nftsLoading, setNftsLoading] = (0, _react.useState)(() => (nfts === null || nfts === void 0 ? void 0 : nfts.length) >= 0);
  const nftContracts = (0, _reactRedux.useSelector)(_metamask.getNftContracts);
  const prevNfts = (0, _usePrevious.usePrevious)(nfts);
  const prevChainId = (0, _usePrevious.usePrevious)(chainId);
  const prevSelectedAddress = (0, _usePrevious.usePrevious)(selectedAddress);
  (0, _react.useEffect)(() => {
    const getCollections = () => {
      setNftsLoading(true);
      if (selectedAddress === undefined || chainId === undefined) {
        return;
      }
      const newCollections = {};
      const newPreviouslyOwnedCollections = {
        collectionName: previouslyOwnedText,
        nfts: []
      };
      const allNfts = Object.values(nfts).flat();
      allNfts.forEach(nft => {
        if ((nft === null || nft === void 0 ? void 0 : nft.isCurrentlyOwned) === false) {
          newPreviouslyOwnedCollections.nfts.push(nft);
        } else if (newCollections[nft.address]) {
          newCollections[nft.address].nfts.push(nft);
        } else {
          const collectionContract = nftContracts.find(({
            address
          }) => address === nft.address);
          newCollections[nft.address] = {
            collectionName: (collectionContract === null || collectionContract === void 0 ? void 0 : collectionContract.name) || unknownCollectionText,
            collectionImage: (collectionContract === null || collectionContract === void 0 ? void 0 : collectionContract.logo) || (0, _nfts.getNftImage)(nft.image),
            nfts: [nft]
          };
        }
      });
      setCollections(newCollections);
      setPreviouslyOwnedCollection(newPreviouslyOwnedCollections);
      setNftsLoading(false);
    };
    if (!(0, _lodash.isEqual)(prevNfts, nfts) || !(0, _lodash.isEqual)(prevSelectedAddress, selectedAddress) || !(0, _lodash.isEqual)(prevChainId, chainId)) {
      getCollections();
    }
  }, [nfts, prevNfts, nftContracts, setNftsLoading, chainId, prevChainId, selectedAddress, prevSelectedAddress, previouslyOwnedText, unknownCollectionText]);
  return {
    nftsLoading,
    collections,
    previouslyOwnedCollection
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useNftsCollections.js",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useNotificationTimeouts.ts", {"../helpers/constants/notifications":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\notifications.ts","../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseNotificationTimeouts.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSnapNotificationTimeouts = void 0;
var _reactRedux = require("react-redux");
var _actions = require("../store/actions");
var _notifications = require("../helpers/constants/notifications");
/**
 * This hook is used to enforce lifecycles for snap notifications.
 *
 * NOTE: This hook initiates a timeout to delete a notification,
 * but doesn't have complete control over the lifecycle of the notification.
 * The handling of deletion of stale notifications should be handled at the component
 * level where the notifications are rendered.
 *
 * @returns A function that creates a timeout to delete a notification.
 */
const useSnapNotificationTimeouts = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const setNotificationTimeout = id => {
    setTimeout(() => {
      dispatch((0, _actions.deleteNotificationsById)([id]));
    }, _notifications.NOTIFICATIONS_EXPIRATION_DELAY);
  };
  return {
    setNotificationTimeout
  };
};
exports.useSnapNotificationTimeouts = useSnapNotificationTimeouts;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useNotificationTimeouts.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useOriginMetadata.js", {"../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseOriginMetadata.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOriginMetadata = useOriginMetadata;
var _permissionController = require("@metamask/permission-controller");
var _reactRedux = require("react-redux");
var _selectors = require("../selectors");
/**
 * @typedef {object} OriginMetadata
 * @property {string} hostname - The hostname of the origin (host + port)
 * @property {string} origin - The original origin string itself
 * @property {string} [iconUrl] - The origin's site icon URL, if available
 * @property {string} [name] - The registered name of the origin if available
 */

/**
 * Gets origin metadata from redux and formats it appropriately.
 *
 * @param {string} origin - The fully formed url of the site interacting with
 * MetaMask
 * @returns {OriginMetadata | null} The origin metadata available for the
 * current origin
 */
function useOriginMetadata(origin) {
  const targetSubjectMetadata = (0, _reactRedux.useSelector)(state => (0, _selectors.getTargetSubjectMetadata)(state, origin));
  if (!origin) {
    return null;
  }
  let minimumOriginMetadata = null;
  try {
    const url = new URL(origin);
    minimumOriginMetadata = {
      host: url.host,
      hostname: url.hostname,
      origin,
      subjectType: _permissionController.SubjectType.Unknown
    };
  } catch (_) {
    // do nothing
  }
  if (targetSubjectMetadata && minimumOriginMetadata) {
    return {
      ...minimumOriginMetadata,
      ...targetSubjectMetadata
    };
  } else if (targetSubjectMetadata) {
    return targetSubjectMetadata;
  }
  return minimumOriginMetadata;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useOriginMetadata.js",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useOriginTrustSignals.ts", {"../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","./useTrustSignals":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTrustSignals.ts","@metamask/phishing-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\phishing-controller\\dist\\index.cjs","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseOriginTrustSignals.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOriginTrustSignals = useOriginTrustSignals;
var _phishingController = require("@metamask/phishing-controller");
var _reactRedux = require("react-redux");
var _selectors = require("../selectors/selectors");
var _useTrustSignals = require("./useTrustSignals");
function getTrustState(cachedResult) {
  var _cachedResult$data;
  const recommendedAction = cachedResult === null || cachedResult === void 0 || (_cachedResult$data = cachedResult.data) === null || _cachedResult$data === void 0 ? void 0 : _cachedResult$data.recommendedAction;
  if (!recommendedAction) {
    return _useTrustSignals.TrustSignalDisplayState.Unknown;
  }
  switch (recommendedAction) {
    case _phishingController.RecommendedAction.Block:
      return _useTrustSignals.TrustSignalDisplayState.Malicious;
    case _phishingController.RecommendedAction.Warn:
      return _useTrustSignals.TrustSignalDisplayState.Warning;
    case _phishingController.RecommendedAction.Verified:
      return _useTrustSignals.TrustSignalDisplayState.Verified;
    case _phishingController.RecommendedAction.None:
    default:
      return _useTrustSignals.TrustSignalDisplayState.Unknown;
  }
}
function useOriginTrustSignals(origin) {
  let hostname;
  if (origin) {
    try {
      const url = new URL(origin);
      hostname = url.hostname;
    } catch (e) {
      hostname = undefined;
    }
  }
  const urlScanCacheResult = (0, _reactRedux.useSelector)(state => (0, _selectors.getUrlScanCacheResult)(state, hostname));
  const state = getTrustState(urlScanCacheResult);
  return {
    state,
    label: null
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useOriginTrustSignals.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\usePolling.ts", {"react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CusePolling.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("react");
const usePolling = usePollingOptions => {
  const pollTokenRef = (0, _react.useRef)(null);
  const cleanupRef = (0, _react.useRef)(null);
  let isMounted = false;
  (0, _react.useEffect)(() => {
    if (usePollingOptions.enabled === false) {
      return () => {
        // noop
      };
    }
    isMounted = true;
    const cleanup = () => {
      if (pollTokenRef.current) {
        var _cleanupRef$current;
        usePollingOptions.stopPollingByPollingToken(pollTokenRef.current);
        (_cleanupRef$current = cleanupRef.current) === null || _cleanupRef$current === void 0 || _cleanupRef$current.call(cleanupRef, pollTokenRef.current);
      }
    };

    // Start polling when the component mounts
    usePollingOptions.startPolling(usePollingOptions.input).then(pollToken => {
      var _usePollingOptions$ca;
      pollTokenRef.current = pollToken;
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
      // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
      cleanupRef.current = ((_usePollingOptions$ca = usePollingOptions.callback) === null || _usePollingOptions$ca === void 0 ? void 0 : _usePollingOptions$ca.call(usePollingOptions, pollToken)) || null;
      if (!isMounted) {
        cleanup();
      }
    });

    // Return a cleanup function to stop polling when the component unmounts
    return () => {
      isMounted = false;
      cleanup();
    };
  }, [usePollingOptions.input && JSON.stringify(usePollingOptions.input), usePollingOptions.enabled]);
};
var _default = exports.default = usePolling;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\usePolling.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\usePrevious.ts", {"react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CusePrevious.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePrevious = usePrevious;
var _react = require("react");
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function usePrevious(value) {
  const ref = (0, _react.useRef)();
  (0, _react.useEffect)(() => {
    ref.current = value;
  }, [value]);
  return ref.current;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\usePrevious.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useScrollRequired.js", {"./usePrevious":"D:\\code\\v\\metamask-extension\\ui\\hooks\\usePrevious.ts","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseScrollRequired.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useScrollRequired = void 0;
var _react = require("react");
var _lodash = require("lodash");
var _usePrevious = require("./usePrevious");
/**
 * Utility hook for requiring users to scroll through content.
 * Returns an object containing state and helpers to accomplish this.
 *
 * The hook expects both the `ref` and the `onScroll` handler to be passed to the scrolling element.
 *
 * @param dependencies - Any optional hook dependencies for updating the scroll state.
 * @param opt
 * @param {number} opt.offsetPxFromBottom
 * @returns Flags for isScrollable and isScrollToBottom, a ref to use for the scrolling content, a scrollToBottom function and a onScroll handler.
 */
const useScrollRequired = (dependencies = [], {
  offsetPxFromBottom = 16
} = {}) => {
  var _ref$current, _ref$current3;
  const ref = (0, _react.useRef)(null);
  const prevOffsetHeight = (0, _usePrevious.usePrevious)((_ref$current = ref.current) === null || _ref$current === void 0 ? void 0 : _ref$current.offsetHeight);
  const [hasScrolledToBottomState, setHasScrolledToBottom] = (0, _react.useState)(false);
  const [isScrollableState, setIsScrollable] = (0, _react.useState)(false);
  const [isScrolledToBottomState, setIsScrolledToBottom] = (0, _react.useState)(false);
  const update = () => {
    if (!ref.current) {
      return;
    }
    const isScrollable = ref.current && ref.current.scrollHeight > ref.current.clientHeight;
    const isScrolledToBottom = isScrollable &&
    // Add 16px to the actual scroll position to trigger setIsScrolledToBottom sooner.
    // This avoids the problem where a user has scrolled down to the bottom and it's not detected.
    Math.round(ref.current.scrollTop) + ref.current.offsetHeight + offsetPxFromBottom >= ref.current.scrollHeight;
    if (isScrollable !== isScrollableState) {
      setHasScrolledToBottom(false);
      setIsScrollable(isScrollable);
    }
    setIsScrolledToBottom(!isScrollable || isScrolledToBottom);
    if (!isScrollable || isScrolledToBottom) {
      setHasScrolledToBottom(true);
    }
  };
  (0, _react.useEffect)(update, [ref, ...dependencies]);
  (0, _react.useEffect)(() => {
    var _ref$current2;
    if (prevOffsetHeight !== ((_ref$current2 = ref.current) === null || _ref$current2 === void 0 ? void 0 : _ref$current2.offsetHeight)) {
      update();
    }
  }, [(_ref$current3 = ref.current) === null || _ref$current3 === void 0 ? void 0 : _ref$current3.offsetHeight]);
  const scrollToBottom = () => {
    setIsScrolledToBottom(true);
    setHasScrolledToBottom(true);
    if (ref.current) {
      ref.current.scrollTo({
        top: ref.current.scrollHeight,
        behavior: 'smooth'
      });
    }
  };
  return {
    isScrollable: isScrollableState,
    isScrolledToBottom: isScrolledToBottomState,
    hasScrolledToBottom: hasScrolledToBottomState,
    scrollToBottom,
    setHasScrolledToBottom,
    ref,
    onScroll: (0, _lodash.debounce)(update, 25)
  };
};
exports.useScrollRequired = useScrollRequired;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useScrollRequired.js",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useSegmentContext.js", {"../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseSegmentContext.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSegmentContext = useSegmentContext;
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _routes = require("../helpers/constants/routes");
var _selectors = require("../selectors");
/**
 * Returns the current page if it matches our route map, as well as the origin
 * if there is a confirmation that was triggered by a dapp. These values are
 * not required but add valuable context to events, and should be included in
 * the context object on the event payload.
 *
 * @returns {{
 *  page?: MetaMetricsPageObject
 *  referrer?: MetaMetricsReferrerObject
 * }}
 */
function useSegmentContext() {
  const match = (0, _reactRouterDom.useRouteMatch)({
    path: (0, _routes.getPaths)(),
    exact: true,
    strict: true
  });
  const txData = (0, _reactRedux.useSelector)(_selectors.txDataSelector) || {};
  const confirmTransactionOrigin = txData.origin;
  const referrer = confirmTransactionOrigin ? {
    url: confirmTransactionOrigin
  } : undefined;
  const page = match ? {
    path: match.path,
    title: _routes.PATH_NAME_MAP.get(match.path),
    url: match.path
  } : undefined;
  return {
    page,
    referrer
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useSegmentContext.js",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useShouldAnimateGasEstimations.js", {"../ducks/app/app":"D:\\code\\v\\metamask-extension\\ui\\ducks\\app\\app.ts","./useGasFeeEstimates":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useGasFeeEstimates.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseShouldAnimateGasEstimations.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useShouldAnimateGasEstimations = useShouldAnimateGasEstimations;
var _react = require("react");
var _reactRedux = require("react-redux");
var _lodash = require("lodash");
var _app = require("../ducks/app/app");
var _useGasFeeEstimates = require("./useGasFeeEstimates");
function useShouldAnimateGasEstimations() {
  const {
    isGasEstimatesLoading,
    gasFeeEstimates
  } = (0, _useGasFeeEstimates.useGasFeeEstimates)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const isGasLoadingAnimationActive = (0, _reactRedux.useSelector)(_app.getGasLoadingAnimationIsShowing);

  // Do the animation only when gas prices have changed...
  const lastGasEstimates = (0, _react.useRef)(gasFeeEstimates);
  const gasEstimatesChanged = !(0, _lodash.isEqual)(lastGasEstimates.current, gasFeeEstimates);

  // ... and only if gas didn't just load
  // Removing this line will cause the initial loading screen to stay empty
  const gasJustLoaded = (0, _lodash.isEqual)(lastGasEstimates.current, {});
  if (gasEstimatesChanged) {
    lastGasEstimates.current = gasFeeEstimates;
  }
  const showLoadingAnimation = isGasEstimatesLoading || gasEstimatesChanged && !gasJustLoaded;
  (0, _react.useEffect)(() => {
    if (isGasLoadingAnimationActive === false && showLoadingAnimation === true) {
      dispatch((0, _app.toggleGasLoadingAnimation)(true));
    }
  }, [dispatch, isGasLoadingAnimationActive, showLoadingAnimation]);
  (0, _react.useEffect)(() => {
    let timer;
    if (isGasLoadingAnimationActive && !showLoadingAnimation) {
      timer = setTimeout(() => {
        dispatch((0, _app.toggleGasLoadingAnimation)(false));
      }, 2000);
    }
    return () => {
      if (timer) {
        clearTimeout(timer);
      }
    };
  }, [dispatch, isGasLoadingAnimationActive, showLoadingAnimation]);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useShouldAnimateGasEstimations.js",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useShouldShowSpeedUp.js", {"../../shared/constants/time":"D:\\code\\v\\metamask-extension\\shared\\constants\\time.ts","../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseShouldShowSpeedUp.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useShouldShowSpeedUp = useShouldShowSpeedUp;
var _react = require("react");
var _reactRedux = require("react-redux");
var _time = require("../../shared/constants/time");
var _networks = require("../../shared/modules/selectors/networks");
/**
 * Evaluates whether the transaction is eligible to be sped up, and registers
 * an effect to check the logic again after the transaction has surpassed 5 seconds
 * of queue time.
 *
 * @param {object} transactionGroup - the transaction group to check against
 * @param {boolean} isEarliestNonce - Whether this group is currently the earliest nonce
 */
function useShouldShowSpeedUp(transactionGroup, isEarliestNonce) {
  const {
    transactions,
    hasRetried
  } = transactionGroup;
  const currentChainId = (0, _reactRedux.useSelector)(_networks.getCurrentChainId);
  const [earliestTransaction = {}] = transactions;
  const matchCurrentChainId = earliestTransaction.chainId === currentChainId;
  const {
    submittedTime
  } = earliestTransaction;
  const [speedUpEnabled, setSpeedUpEnabled] = (0, _react.useState)(() => {
    return Date.now() - submittedTime > 5000 && isEarliestNonce && !hasRetried && matchCurrentChainId;
  });
  (0, _react.useEffect)(() => {
    // because this hook is optimized to only run on changes we have to
    // key into the changing time delta between submittedTime and now()
    // and if the status of the transaction changes based on that difference
    // trigger a setState call to tell react to re-render. This effect will
    // also immediately set retryEnabled and not create a timeout if the
    // condition is already met. This effect will run anytime the variables
    // for determining enabled status change
    let timeoutId;
    if (!hasRetried && isEarliestNonce && !speedUpEnabled) {
      if (Date.now() - submittedTime > _time.SECOND * 5) {
        setSpeedUpEnabled(true);
      } else {
        timeoutId = setTimeout(() => {
          setSpeedUpEnabled(true);
          clearTimeout(timeoutId);
        }, 5001 - (Date.now() - submittedTime));
      }
    }
    // Anytime the effect is re-ran, make sure to remove a previously set timeout
    // so as to avoid multiple timers potentially overlapping
    return () => {
      if (timeoutId) {
        clearTimeout(timeoutId);
      }
    };
  }, [submittedTime, speedUpEnabled, hasRetried, isEarliestNonce]);
  return speedUpEnabled;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useShouldShowSpeedUp.js",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useSwappedTokenValue.js", {"../../shared/lib/transactions-controller-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\transactions-controller-utils.js","../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../shared/modules/swaps.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\swaps.utils.js","./useTokenFiatAmount":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTokenFiatAmount.js","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseSwappedTokenValue.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSwappedTokenValue = useSwappedTokenValue;
var _reactRedux = require("react-redux");
var _transactionController = require("@metamask/transaction-controller");
var _transactionsControllerUtils = require("../../shared/lib/transactions-controller-utils");
var _swaps = require("../../shared/modules/swaps.utils");
var _networks = require("../../shared/modules/selectors/networks");
var _useTokenFiatAmount = require("./useTokenFiatAmount");
/**
 * @typedef {object} SwappedTokenValue
 * @property {string} swapTokenValue - a primary currency string formatted for display
 * @property {string} swapTokenFiatAmount - a secondary currency string formatted for display
 * @property {boolean} isViewingReceivedTokenFromSwap - true if user is on the asset page for the
 *                                                      destination/received asset in a swap.
 */

/**
 * A Swap transaction group's primaryTransaction contains details of the swap,
 * including the source (from) and destination (to) token type (ETH, DAI, etc..)
 * When viewing an asset page that is not for the current chain's default token, we
 * need to determine if that asset is the token that was received (destination) from
 * the swap. In that circumstance we would want to show the primaryCurrency in the
 * activity list that is most relevant for that token (- 1000 DAI, for example, when
 * swapping DAI for ETH).
 *
 * @param {__import__('../selectors').transactionGroup} transactionGroup - Group of transactions by nonce
 * @param {__import__('./useTokenDisplayValue').Token} currentAsset - The current asset the user is looking at
 * @returns {SwappedTokenValue}
 */
function useSwappedTokenValue(transactionGroup, currentAsset) {
  const {
    symbol,
    decimals,
    address
  } = currentAsset;
  const {
    primaryTransaction,
    initialTransaction
  } = transactionGroup;
  const {
    type
  } = initialTransaction;
  const {
    from: senderAddress
  } = initialTransaction.txParams || {};
  const chainId = (0, _reactRedux.useSelector)(_networks.getCurrentChainId);
  const isViewingReceivedTokenFromSwap = type === _transactionController.TransactionType.swap && ((currentAsset === null || currentAsset === void 0 ? void 0 : currentAsset.symbol) === primaryTransaction.destinationTokenSymbol || (0, _swaps.isSwapsDefaultTokenAddress)(currentAsset.address, chainId) && (0, _swaps.isSwapsDefaultTokenSymbol)(primaryTransaction.destinationTokenSymbol, chainId));
  const swapTokenValue = [_transactionController.TransactionType.swap].includes(type) && isViewingReceivedTokenFromSwap ? (0, _transactionsControllerUtils.getSwapsTokensReceivedFromTxMeta)(primaryTransaction.destinationTokenSymbol, initialTransaction, address, senderAddress, decimals, null, chainId) : [_transactionController.TransactionType.swap, _transactionController.TransactionType.swapAndSend].includes(type) && primaryTransaction.swapTokenValue;
  const isNegative = typeof swapTokenValue === 'string' ? Math.sign(swapTokenValue) === -1 : false;
  const _swapTokenFiatAmount = (0, _useTokenFiatAmount.useTokenFiatAmount)(address, swapTokenValue || '', symbol);
  const _swapAndSendTokenFiatAmount = (0, _useTokenFiatAmount.useTokenFiatAmount)(primaryTransaction.sourceTokenAddress, swapTokenValue, primaryTransaction.sourceTokenSymbol);
  let swapTokenFiatAmount;
  if (swapTokenValue) {
    if (isViewingReceivedTokenFromSwap) {
      swapTokenFiatAmount = _swapTokenFiatAmount;
    } else if (type === _transactionController.TransactionType.swapAndSend) {
      swapTokenFiatAmount = _swapAndSendTokenFiatAmount;
    }
  }
  return {
    swapTokenValue,
    swapTokenFiatAmount,
    isViewingReceivedTokenFromSwap,
    isNegative
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useSwappedTokenValue.js",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useTheme.ts", {"../../shared/constants/preferences":"D:\\code\\v\\metamask-extension\\shared\\constants\\preferences.ts","../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseTheme.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTheme = useTheme;
var _react = require("react");
var _reactRedux = require("react-redux");
var _selectors = require("../selectors");
var _preferences = require("../../shared/constants/preferences");
/**
 * List of valid themes. Should return an array with only the values ThemeType.light and ThemeType.dark
 * unless there is a future we add more themes.
 */
const validThemes = Object.values(_preferences.ThemeType).filter(theme => {
  return theme !== _preferences.ThemeType.os;
});

/**
 * Returns the current theme based on the user's theme setting.
 *
 * @returns theme
 */
function useTheme() {
  const settingTheme = (0, _reactRedux.useSelector)(_selectors.getTheme);
  const [theme, setTheme] = (0, _react.useState)(settingTheme);
  (0, _react.useEffect)(() => {
    const result = !settingTheme || settingTheme === _preferences.ThemeType.os ? document.documentElement.getAttribute('data-theme') : settingTheme;
    const isValidTheme = validThemes.includes(result);
    if (!isValidTheme) {
      console.warn(`useTheme: Invalid theme resolved to "${result}". Defaulting to "${_preferences.ThemeType.light}".`);
      setTheme(_preferences.ThemeType.light);
    }
    setTheme(result);
  }, [settingTheme]);
  return theme;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useTheme.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useTimeout.js", {"react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseTimeout.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimeout = useTimeout;
var _react = require("react");
/**
 * useTimeout
 *
 * @param {Function} cb - callback function inside setTimeout
 * @param {number} delay - delay in ms
 * @param {boolean} [immediate] - determines whether the timeout is invoked immediately
 * @returns {Function|undefined}
 */
function useTimeout(cb, delay, immediate = true) {
  const saveCb = (0, _react.useRef)();
  const [timeoutId, setTimeoutId] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    saveCb.current = cb;
  }, [cb]);
  (0, _react.useEffect)(() => {
    if (timeoutId !== 'start') {
      return undefined;
    }
    const id = setTimeout(() => {
      saveCb.current();
    }, delay);
    setTimeoutId(id);
    return () => {
      clearTimeout(timeoutId);
    };
  }, [delay, timeoutId]);
  const startTimeout = (0, _react.useCallback)(() => {
    clearTimeout(timeoutId);
    setTimeoutId('start');
  }, [timeoutId]);
  if (immediate) {
    startTimeout();
  }
  return startTimeout;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useTimeout.js",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useTokenBalances.ts", {"../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../selectors/multichain/networks":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain\\networks.ts","../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./useMultiPolling":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultiPolling.ts","bn.js":"D:\\code\\v\\metamask-extension\\node_modules\\bn.js\\lib\\bn.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseTokenBalances.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stringifyBalance = stringifyBalance;
exports.useTokenTracker = exports.useTokenBalances = void 0;
var _reactRedux = require("react-redux");
var _bn = _interopRequireDefault(require("bn.js"));
var _actions = require("../store/actions");
var _metamask = require("../ducks/metamask/metamask");
var _conversion = require("../../shared/modules/conversion.utils");
var _networks = require("../selectors/multichain/networks");
var _useMultiPolling = _interopRequireDefault(require("./useMultiPolling"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const useTokenBalances = ({
  chainIds
} = {}) => {
  const tokenBalances = (0, _reactRedux.useSelector)(_metamask.getTokenBalances);
  const enabledChainIds = (0, _reactRedux.useSelector)(_networks.getEnabledChainIds);
  const pollableChains = chainIds && chainIds.length > 0 ? chainIds : enabledChainIds;
  (0, _useMultiPolling.default)({
    startPolling: _actions.tokenBalancesStartPolling,
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    stopPollingByPollingToken: _actions.tokenBalancesStopPollingByPollingToken,
    input: [pollableChains]
  });
  return {
    tokenBalances
  };
};

// This hook is designed for backwards compatibility with `ui/hooks/useTokenTracker.js`
// and the github.com/MetaMask/eth-token-tracker library. It replaces RPC calls with
// reading state from `TokenBalancesController`. It should not be used in new code.
// Instead, prefer to use `useTokenBalances` directly, or compose higher level hooks from it.
exports.useTokenBalances = useTokenBalances;
const useTokenTracker = ({
  chainId,
  tokens,
  address,
  hideZeroBalanceTokens
}) => {
  const {
    tokenBalances
  } = useTokenBalances({
    chainIds: [chainId]
  });
  const tokensWithBalances = tokens.reduce((acc, token) => {
    var _tokenBalances$addres;
    const hexBalance = ((_tokenBalances$addres = tokenBalances[address]) === null || _tokenBalances$addres === void 0 || (_tokenBalances$addres = _tokenBalances$addres[chainId]) === null || _tokenBalances$addres === void 0 ? void 0 : _tokenBalances$addres[token.address]) ?? '0x0';
    if (hexBalance !== '0x0' || !hideZeroBalanceTokens) {
      const decimalBalance = (0, _conversion.hexToDecimal)(hexBalance);
      acc.push({
        address: token.address,
        symbol: token.symbol,
        decimals: token.decimals,
        balance: decimalBalance,
        balanceError: null,
        string: stringifyBalance(new _bn.default(decimalBalance), new _bn.default(token.decimals))
      });
    }
    return acc;
  }, []);
  return {
    tokensWithBalances
  };
};

// From https://github.com/MetaMask/eth-token-tracker/blob/main/lib/util.js
// Ensures backwards compatibility with display formatting.
exports.useTokenTracker = useTokenTracker;
function stringifyBalance(balance, bnDecimals, balanceDecimals = 5) {
  if (balance.eq(new _bn.default(0))) {
    return '0';
  }
  const decimals = parseInt(bnDecimals.toString(), 10);
  if (decimals === 0) {
    return balance.toString();
  }
  let bal = balance.toString();
  let len = bal.length;
  let decimalIndex = len - decimals;
  let prefix = '';
  if (decimalIndex <= 0) {
    while (prefix.length <= decimalIndex * -1) {
      prefix += '0';
      len += 1;
    }
    bal = prefix + bal;
    decimalIndex = 1;
  }
  const whole = bal.substr(0, len - decimals);
  if (balanceDecimals === 0) {
    return whole;
  }
  const fractional = bal.substr(decimalIndex, balanceDecimals);
  if (/0+$/u.test(fractional)) {
    let withOnlySigZeroes = bal.substr(decimalIndex).replace(/0+$/u, '');
    if (withOnlySigZeroes.length > 0) {
      withOnlySigZeroes = `.${withOnlySigZeroes}`;
    }
    return `${whole}${withOnlySigZeroes}`;
  }
  return `${whole}.${fractional}`;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useTokenBalances.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useTokenData.js", {"../../shared/modules/transaction.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\transaction.utils.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseTokenData.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTokenData = useTokenData;
var _react = require("react");
var _transaction = require("../../shared/modules/transaction.utils");
/**
 * useTokenData
 * Given the data string from txParams return a decoded object of the details of the
 * transaction data.
 *
 * @param {string} [transactionData] - Raw data string from token transaction
 * @param {boolean} [isTokenTransaction] - Due to the nature of hooks, it isn't possible
 *                                         to conditionally call this hook. This flag will
 *                                         force this hook to return null if it set as false
 *                                         which indicates the transaction is not associated
 *                                         with a token.
 * @returns {object} Decoded token data
 */
function useTokenData(transactionData, isTokenTransaction = true) {
  return (0, _react.useMemo)(() => {
    if (!isTokenTransaction || !transactionData) {
      return null;
    }
    return (0, _transaction.parseStandardTokenTransactionData)(transactionData);
  }, [isTokenTransaction, transactionData]);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useTokenData.js",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useTokenDetectionPolling.ts", {"../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../selectors/multichain/networks":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain\\networks.ts","../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./useMultiPolling":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultiPolling.ts","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseTokenDetectionPolling.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactRedux = require("react-redux");
var _selectors = require("../selectors");
var _networks = require("../selectors/multichain/networks");
var _actions = require("../store/actions");
var _metamask = require("../ducks/metamask/metamask");
var _useMultiPolling = _interopRequireDefault(require("./useMultiPolling"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const useTokenDetectionPolling = () => {
  const useTokenDetection = (0, _reactRedux.useSelector)(_selectors.getUseTokenDetection);
  const completedOnboarding = (0, _reactRedux.useSelector)(_metamask.getCompletedOnboarding);
  const isUnlocked = (0, _reactRedux.useSelector)(_metamask.getIsUnlocked);
  const chainIds = (0, _reactRedux.useSelector)(_selectors.getChainIdsToPoll);
  const enabledChainIds = (0, _reactRedux.useSelector)(_networks.getEnabledChainIds);
  const enabled = completedOnboarding && isUnlocked && useTokenDetection;
  const pollableChains = _selectors.isGlobalNetworkSelectorRemoved ? enabledChainIds : chainIds;
  (0, _useMultiPolling.default)({
    startPolling: _actions.tokenDetectionStartPolling,
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    stopPollingByPollingToken: _actions.tokenDetectionStopPollingByPollingToken,
    input: enabled ? [pollableChains] : []
  });
  return {};
};
var _default = exports.default = useTokenDetectionPolling;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useTokenDetectionPolling.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useTokenDisplayValue.js", {"../../shared/lib/metamask-controller-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\metamask-controller-utils.js","../../shared/lib/transactions-controller-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\transactions-controller-utils.js","./useTokenData":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTokenData.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseTokenDisplayValue.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTokenDisplayValue = useTokenDisplayValue;
var _react = require("react");
var _metamaskControllerUtils = require("../../shared/lib/metamask-controller-utils");
var _transactionsControllerUtils = require("../../shared/lib/transactions-controller-utils");
var _useTokenData = require("./useTokenData");
/**
 * Defines the shape for the Token input parameter for useTokenDisplayValue
 *
 * @typedef {object} Token
 * @property {string} symbol - The string to use as a suffix for the token (eg. DAI)
 * @property {number} decimals - The number of decimals to show when displaying this type of token
 */

/**
 * useTokenDisplayValue
 * Given the data string from txParams and a token object with symbol and decimals, return
 * a displayValue that represents a string representing that token amount as a string. Also
 * return a tokenData object for downstream usage and the suffix for the token to use as props
 * for other hooks and/or components
 *
 * @param {string} [transactionData] - Raw data string from token transaction
 * @param {Token} [token] - The token associated with this transaction
 * @param {boolean} [isTokenTransaction] - Due to the nature of hooks, it isn't possible
 *                                         to conditionally call this hook. This flag will
 *                                         force this hook to return null if it set as false
 *                                         which indicates the transaction is not associated
 *                                         with a token.
 * @returns {string} The computed displayValue of the provided transactionData and token
 */
function useTokenDisplayValue(transactionData, token, isTokenTransaction = true) {
  const tokenData = (0, _useTokenData.useTokenData)(transactionData, isTokenTransaction);
  const tokenValue = (0, _metamaskControllerUtils.getTokenValueParam)(tokenData);
  const shouldCalculateTokenValue = Boolean(
  // If we are currently processing a token transaction
  isTokenTransaction &&
  // and raw transaction data string is provided
  transactionData &&
  // and a token object has been provided
  token &&
  // and the provided token object contains a defined decimal value we need to calculate amount
  token.decimals !== null && token.decimals !== undefined &&
  // and we are able to parse the token detail we to calculate amount from the raw data
  tokenValue);
  const displayValue = (0, _react.useMemo)(() => {
    if (!shouldCalculateTokenValue) {
      return null;
    }
    return (0, _transactionsControllerUtils.calcTokenAmount)(tokenValue, token.decimals).toString(10);
  }, [shouldCalculateTokenValue, tokenValue, token]);
  return displayValue;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useTokenDisplayValue.js",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useTokenListPolling.ts", {"../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../selectors/multichain/networks":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain\\networks.ts","../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./useMultiPolling":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultiPolling.ts","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseTokenListPolling.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactRedux = require("react-redux");
var _selectors = require("../selectors");
var _networks = require("../selectors/multichain/networks");
var _actions = require("../store/actions");
var _metamask = require("../ducks/metamask/metamask");
var _selectors2 = require("../selectors/selectors");
var _useMultiPolling = _interopRequireDefault(require("./useMultiPolling"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const useTokenListPolling = () => {
  const useTokenDetection = (0, _reactRedux.useSelector)(_selectors.getUseTokenDetection);
  const useTransactionSimulations = (0, _reactRedux.useSelector)(_selectors.getUseTransactionSimulations);
  const completedOnboarding = (0, _reactRedux.useSelector)(_metamask.getCompletedOnboarding);
  const isUnlocked = (0, _reactRedux.useSelector)(_metamask.getIsUnlocked);
  const useExternalServices = (0, _reactRedux.useSelector)(_selectors.getUseExternalServices);
  const chainIds = (0, _reactRedux.useSelector)(_selectors.getChainIdsToPoll);
  const enabledChainIds = (0, _reactRedux.useSelector)(_networks.getEnabledChainIds);
  const enabled = completedOnboarding && isUnlocked && useExternalServices && (useTokenDetection || useTransactionSimulations);
  const pollableChains = _selectors2.isGlobalNetworkSelectorRemoved ? enabledChainIds : chainIds;
  (0, _useMultiPolling.default)({
    startPolling: _actions.tokenListStartPolling,
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    stopPollingByPollingToken: _actions.tokenListStopPollingByPollingToken,
    input: enabled ? pollableChains : []
  });
  return {};
};
var _default = exports.default = useTokenListPolling;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useTokenListPolling.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useTokenRatesPolling.ts", {"../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../selectors/multichain/networks":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain\\networks.ts","../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./useMultiPolling":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultiPolling.ts","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseTokenRatesPolling.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactRedux = require("react-redux");
var _selectors = require("../selectors");
var _networks = require("../selectors/multichain/networks");
var _actions = require("../store/actions");
var _metamask = require("../ducks/metamask/metamask");
var _selectors2 = require("../selectors/selectors");
var _useMultiPolling = _interopRequireDefault(require("./useMultiPolling"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const useTokenRatesPolling = () => {
  // Selectors to determine polling input
  const completedOnboarding = (0, _reactRedux.useSelector)(_metamask.getCompletedOnboarding);
  const isUnlocked = (0, _reactRedux.useSelector)(_metamask.getIsUnlocked);
  const useCurrencyRateCheck = (0, _reactRedux.useSelector)(_selectors.getUseCurrencyRateCheck);
  const chainIds = (0, _reactRedux.useSelector)(_selectors.getChainIdsToPoll);
  const enabledChainIds = (0, _reactRedux.useSelector)(_networks.getEnabledChainIds);

  // Selectors returning state updated by the polling
  const tokenExchangeRates = (0, _reactRedux.useSelector)(_selectors.getTokenExchangeRates);
  const tokensMarketData = (0, _reactRedux.useSelector)(_selectors.getTokensMarketData);
  const marketData = (0, _reactRedux.useSelector)(_selectors.getMarketData);
  const enabled = completedOnboarding && isUnlocked && useCurrencyRateCheck;
  const pollableChains = _selectors2.isGlobalNetworkSelectorRemoved ? enabledChainIds : chainIds;
  (0, _useMultiPolling.default)({
    startPolling: _actions.tokenRatesStartPolling,
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    stopPollingByPollingToken: _actions.tokenRatesStopPollingByPollingToken,
    input: enabled ? [pollableChains] : []
  });
  return {
    tokenExchangeRates,
    tokensMarketData,
    marketData
  };
};
var _default = exports.default = useTokenRatesPolling;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useTokenRatesPolling.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useTokenTracker.js", {"../../shared/constants/time":"D:\\code\\v\\metamask-extension\\shared\\constants\\time.ts","../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../shared/modules/string-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\string-utils.ts","../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","./useEqualityCheck":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useEqualityCheck.js","@metamask/eth-token-tracker":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-token-tracker\\dist\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseTokenTracker.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTokenTracker = useTokenTracker;
var _react = require("react");
var _ethTokenTracker = _interopRequireDefault(require("@metamask/eth-token-tracker"));
var _reactRedux = require("react-redux");
var _selectors = require("../selectors");
var _networks = require("../../shared/modules/selectors/networks");
var _time = require("../../shared/constants/time");
var _stringUtils = require("../../shared/modules/string-utils");
var _useEqualityCheck = require("./useEqualityCheck");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function useTokenTracker({
  tokens,
  address,
  includeFailedTokens = false,
  hideZeroBalanceTokens = false
}) {
  const {
    chainId,
    rpcUrl
  } = (0, _reactRedux.useSelector)(_networks.getProviderConfig);
  const {
    address: selectedAddress
  } = (0, _reactRedux.useSelector)(_selectors.getSelectedInternalAccount, _reactRedux.shallowEqual);
  const userAddress = address ?? selectedAddress;
  const [loading, setLoading] = (0, _react.useState)(() => (tokens === null || tokens === void 0 ? void 0 : tokens.length) >= 0);
  const [tokensWithBalances, setTokensWithBalances] = (0, _react.useState)([]);
  const [error, setError] = (0, _react.useState)(null);
  const tokenTracker = (0, _react.useRef)(null);
  const memoizedTokens = (0, _useEqualityCheck.useEqualityCheck)(tokens);
  const updateBalances = (0, _react.useCallback)(tokenWithBalances => {
    const matchingTokens = hideZeroBalanceTokens ? tokenWithBalances.filter(token => Number(token.balance) > 0) : tokenWithBalances;
    // TODO: improve this pattern for adding this field when we improve support for
    // EIP721 tokens.
    const matchingTokensWithIsERC721Flag = matchingTokens.map(token => {
      const additionalTokenData = memoizedTokens.find(t => (0, _stringUtils.isEqualCaseInsensitive)(t.address, token.address));
      return {
        ...token,
        isERC721: additionalTokenData === null || additionalTokenData === void 0 ? void 0 : additionalTokenData.isERC721,
        image: additionalTokenData === null || additionalTokenData === void 0 ? void 0 : additionalTokenData.image
      };
    });
    setTokensWithBalances(matchingTokensWithIsERC721Flag);
    setLoading(false);
    setError(null);
  }, [hideZeroBalanceTokens, memoizedTokens]);
  const showError = (0, _react.useCallback)(err => {
    setError(err);
    setLoading(false);
  }, []);
  const teardownTracker = (0, _react.useCallback)(() => {
    if (tokenTracker.current) {
      tokenTracker.current.stop();
      tokenTracker.current.removeAllListeners('update');
      tokenTracker.current.removeAllListeners('error');
      tokenTracker.current = null;
    }
  }, []);
  const buildTracker = (0, _react.useCallback)((usersAddress, tokenList) => {
    // clear out previous tracker, if it exists.
    teardownTracker();
    tokenTracker.current = new _ethTokenTracker.default({
      userAddress: usersAddress,
      provider: global.ethereumProvider,
      tokens: tokenList,
      includeFailedTokens,
      pollingInterval: _time.SECOND * 8,
      balanceDecimals: 5
    });
    tokenTracker.current.on('update', updateBalances);
    tokenTracker.current.on('error', showError);
    tokenTracker.current.updateBalances();
  }, [updateBalances, includeFailedTokens, showError, teardownTracker]);

  // Effect to remove the tracker when the component is removed from DOM
  // Do not overload this effect with additional dependencies. teardownTracker
  // is the only dependency here, which itself has no dependencies and will
  // never update. The lack of dependencies that change is what confirms
  // that this effect only runs on mount/unmount
  (0, _react.useEffect)(() => {
    return teardownTracker;
  }, [teardownTracker]);

  // Effect to set loading state and initialize tracker when values change
  (0, _react.useEffect)(() => {
    // This effect will only run initially and when:
    // 1. chainId is updated,
    // 2. rpc url is changd,
    // 3. userAddress is changed,
    // 4. token list is updated and not equal to previous list
    // in any of these scenarios, we should indicate to the user that their token
    // values are in the process of updating by setting loading state.
    setLoading(true);
    if (!userAddress || chainId === undefined || !global.ethereumProvider) {
      // If we do not have enough information to build a TokenTracker, we exit early
      // When the values above change, the effect will be restarted. We also teardown
      // tracker because inevitably this effect will run again momentarily.
      teardownTracker();
      return;
    }
    if (memoizedTokens.length === 0) {
      // sets loading state to false and token list to empty
      updateBalances([]);
    }
    buildTracker(userAddress, memoizedTokens);
  }, [userAddress, teardownTracker, chainId, rpcUrl, memoizedTokens, updateBalances, buildTracker]);
  return {
    loading,
    tokensWithBalances,
    error
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useTokenTracker.js",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useTokenTrustSignals.ts", {"../helpers/utils/token-cache-utils":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\token-cache-utils.ts","../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","./useTrustSignals":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTrustSignals.ts","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseTokenTrustSignals.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTokenTrustSignalsForAddresses = useTokenTrustSignalsForAddresses;
var _react = require("react");
var _reactRedux = require("react-redux");
var _selectors = require("../selectors/selectors");
var _tokenCacheUtils = require("../helpers/utils/token-cache-utils");
var _useTrustSignals = require("./useTrustSignals");
function getTrustState(cachedResult) {
  var _cachedResult$data;
  const resultType = cachedResult === null || cachedResult === void 0 || (_cachedResult$data = cachedResult.data) === null || _cachedResult$data === void 0 ? void 0 : _cachedResult$data.result_type;
  if (!resultType) {
    return _useTrustSignals.TrustSignalDisplayState.Unknown;
  }
  switch (resultType) {
    case 'Malicious':
      return _useTrustSignals.TrustSignalDisplayState.Malicious;
    case 'Warning':
      return _useTrustSignals.TrustSignalDisplayState.Warning;
    case 'Benign':
    default:
      return _useTrustSignals.TrustSignalDisplayState.Unknown;
  }
}
function useTokenTrustSignalsForAddresses(chainId, tokenAddresses) {
  const tokenScanResults = (0, _reactRedux.useSelector)(state => (0, _selectors.getTokenScanResultsForAddresses)(state, chainId, tokenAddresses));
  return (0, _react.useMemo)(() => {
    if (!chainId || !tokenAddresses || !Array.isArray(tokenAddresses)) {
      return [];
    }
    return tokenAddresses.map(tokenAddress => {
      if (!tokenAddress) {
        return {
          state: _useTrustSignals.TrustSignalDisplayState.Unknown,
          label: null
        };
      }
      const cacheKey = (0, _tokenCacheUtils.generateTokenCacheKey)(chainId, tokenAddress);
      const cachedResult = tokenScanResults[cacheKey];
      return {
        state: getTrustState(cachedResult),
        label: null
      };
    });
  }, [chainId, tokenAddresses, tokenScanResults]);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useTokenTrustSignals.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useTokensToSearch.js", {"../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../shared/constants/swaps":"D:\\code\\v\\metamask-extension\\shared\\constants\\swaps.ts","../../shared/modules/hexstring-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\hexstring-utils.ts","../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../shared/modules/swaps.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\swaps.utils.js","../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../ducks/swaps/swaps":"D:\\code\\v\\metamask-extension\\ui\\ducks\\swaps\\swaps.js","../helpers/utils/token-util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\token-util.js","../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","./useEqualityCheck":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useEqualityCheck.js","@metamask/assets-controllers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\index.cjs","bignumber.js":"D:\\code\\v\\metamask-extension\\node_modules\\bignumber.js\\bignumber.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseTokensToSearch.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRenderableTokenData = getRenderableTokenData;
exports.useTokensToSearch = useTokensToSearch;
var _react = require("react");
var _reactRedux = require("react-redux");
var _bignumber = _interopRequireDefault(require("bignumber.js"));
var _lodash = require("lodash");
var _assetsControllers = require("@metamask/assets-controllers");
var _tokenUtil = require("../helpers/utils/token-util");
var _selectors = require("../selectors");
var _networks = require("../../shared/modules/selectors/networks");
var _metamask = require("../ducks/metamask/metamask");
var _swaps = require("../ducks/swaps/swaps");
var _swaps2 = require("../../shared/modules/swaps.utils");
var _hexstringUtils = require("../../shared/modules/hexstring-utils");
var _swaps3 = require("../../shared/constants/swaps");
var _network = require("../../shared/constants/network");
var _useEqualityCheck = require("./useEqualityCheck");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function getRenderableTokenData(token, contractExchangeRates, conversionRate, currentCurrency, chainId, tokenList) {
  var _tokenList$address$to, _tokenList$address$to2;
  const {
    symbol,
    name,
    address,
    iconUrl,
    string,
    balance,
    decimals
  } = token;
  let contractExchangeRate;
  if ((0, _swaps2.isSwapsDefaultTokenSymbol)(symbol, chainId)) {
    contractExchangeRate = 1;
  } else if (string && conversionRate > 0) {
    // This condition improves performance significantly, because it only gets a contract exchange rate
    // if a token amount is truthy and conversion rate is higher than 0.
    contractExchangeRate = contractExchangeRates[(0, _hexstringUtils.toChecksumHexAddress)(address)];
  }
  const formattedFiat = (0, _tokenUtil.getTokenFiatAmount)(contractExchangeRate, conversionRate, currentCurrency, string, symbol, true) || '';
  const rawFiat = formattedFiat ? (0, _tokenUtil.getTokenFiatAmount)(contractExchangeRate, conversionRate, currentCurrency, string, symbol, false) : '';
  const chainIdForTokenIcons = chainId === _network.CHAIN_IDS.SEPOLIA ? _network.CHAIN_IDS.MAINNET : chainId;
  const tokenIconUrl = symbol === _network.CURRENCY_SYMBOLS.ETH && chainId === _network.CHAIN_IDS.MAINNET || symbol === _network.CURRENCY_SYMBOLS.ETH && chainId === _network.CHAIN_IDS.SEPOLIA || symbol === _network.CURRENCY_SYMBOLS.BNB && chainId === _network.CHAIN_IDS.BSC || symbol === _network.CURRENCY_SYMBOLS.MATIC && chainId === _network.CHAIN_IDS.POLYGON || symbol === _network.CURRENCY_SYMBOLS.AVALANCHE && chainId === _network.CHAIN_IDS.AVALANCHE || symbol === _network.CURRENCY_SYMBOLS.ETH && chainId === _network.CHAIN_IDS.OPTIMISM || symbol === _network.CURRENCY_SYMBOLS.ETH && chainId === _network.CHAIN_IDS.ARBITRUM || symbol === _network.CURRENCY_SYMBOLS.ETH && chainId === _network.CHAIN_IDS.LINEA_MAINNET || symbol === _network.CURRENCY_SYMBOLS.ETH && chainId === _network.CHAIN_IDS.ZKSYNC_ERA || symbol === _network.CURRENCY_SYMBOLS.ETH && chainId === _network.CHAIN_IDS.BASE ? iconUrl : (0, _assetsControllers.formatIconUrlWithProxy)({
    chainId: chainIdForTokenIcons,
    tokenAddress: address || ''
  });
  const usedIconUrl = tokenIconUrl || (token === null || token === void 0 ? void 0 : token.image);
  return {
    ...token,
    primaryLabel: symbol,
    secondaryLabel: name || ((_tokenList$address$to = tokenList[address === null || address === void 0 ? void 0 : address.toLowerCase()]) === null || _tokenList$address$to === void 0 ? void 0 : _tokenList$address$to.name),
    rightPrimaryLabel: string && `${new _bignumber.default(string).round(6).toString()} ${symbol}`,
    rightSecondaryLabel: formattedFiat,
    iconUrl: usedIconUrl,
    identiconAddress: usedIconUrl ? null : address,
    balance,
    decimals,
    name: name || ((_tokenList$address$to2 = tokenList[address === null || address === void 0 ? void 0 : address.toLowerCase()]) === null || _tokenList$address$to2 === void 0 ? void 0 : _tokenList$address$to2.name),
    rawFiat,
    image: token.image || token.iconUrl
  };
}
function useTokensToSearch({
  usersTokens = [],
  topTokens = {},
  shuffledTokensList,
  tokenBucketPriority = _swaps3.TokenBucketPriority.owned
}) {
  const chainId = (0, _reactRedux.useSelector)(_networks.getCurrentChainId);
  const tokenConversionRates = (0, _reactRedux.useSelector)(_selectors.getTokenExchangeRates, _lodash.isEqual);
  const conversionRate = (0, _reactRedux.useSelector)(_metamask.getConversionRate);
  const currentCurrency = (0, _reactRedux.useSelector)(_metamask.getCurrentCurrency);
  const defaultSwapsToken = (0, _reactRedux.useSelector)(_selectors.getSwapsDefaultToken, _reactRedux.shallowEqual);
  const tokenList = (0, _reactRedux.useSelector)(_selectors.getTokenList, _lodash.isEqual);
  const memoizedTopTokens = (0, _useEqualityCheck.useEqualityCheck)(topTokens);
  const memoizedUsersToken = (0, _useEqualityCheck.useEqualityCheck)(usersTokens);
  const defaultToken = getRenderableTokenData(defaultSwapsToken, tokenConversionRates, conversionRate, currentCurrency, chainId, tokenList);
  const memoizedDefaultToken = (0, _useEqualityCheck.useEqualityCheck)(defaultToken);
  const swapsTokens = (0, _reactRedux.useSelector)(_swaps.getSwapsTokens, _lodash.isEqual) || [];
  const tokensToSearch = swapsTokens.length ? swapsTokens : [memoizedDefaultToken, ...shuffledTokensList.filter(token => token.symbol !== memoizedDefaultToken.symbol)];
  const memoizedTokensToSearch = (0, _useEqualityCheck.useEqualityCheck)(tokensToSearch);
  return (0, _react.useMemo)(() => {
    const usersTokensAddressMap = memoizedUsersToken.reduce((acc, token) => ({
      ...acc,
      [token.address.toLowerCase()]: token
    }), {});
    const tokensToSearchBuckets = {
      owned: [],
      top: [],
      others: []
    };
    const memoizedSwapsAndUserTokensWithoutDuplicities = (0, _lodash.uniqBy)([memoizedDefaultToken, ...memoizedTokensToSearch, ...memoizedUsersToken], token => token.address.toLowerCase());
    memoizedSwapsAndUserTokensWithoutDuplicities.forEach(token => {
      const renderableDataToken = getRenderableTokenData({
        ...usersTokensAddressMap[token.address.toLowerCase()],
        ...token
      }, tokenConversionRates, conversionRate, currentCurrency, chainId, tokenList);
      if (tokenBucketPriority === _swaps3.TokenBucketPriority.owned) {
        if ((0, _swaps2.isSwapsDefaultTokenSymbol)(renderableDataToken.symbol, chainId) || usersTokensAddressMap[token.address.toLowerCase()]) {
          tokensToSearchBuckets.owned.push(renderableDataToken);
        } else if (memoizedTopTokens[token.address.toLowerCase()]) {
          tokensToSearchBuckets.top[memoizedTopTokens[token.address.toLowerCase()].index] = renderableDataToken;
        } else {
          tokensToSearchBuckets.others.push(renderableDataToken);
        }
      } else if (memoizedTopTokens[token.address.toLowerCase()]) {
        tokensToSearchBuckets.top[memoizedTopTokens[token.address.toLowerCase()].index] = renderableDataToken;
      } else if ((0, _swaps2.isSwapsDefaultTokenSymbol)(renderableDataToken.symbol, chainId) || usersTokensAddressMap[token.address.toLowerCase()]) {
        tokensToSearchBuckets.owned.push(renderableDataToken);
      } else {
        tokensToSearchBuckets.others.push(renderableDataToken);
      }
    });
    tokensToSearchBuckets.owned = tokensToSearchBuckets.owned.sort(({
      rawFiat
    }, {
      rawFiat: secondRawFiat
    }) => {
      return new _bignumber.default(rawFiat || 0).gt(secondRawFiat || 0) ? -1 : 1;
    });
    tokensToSearchBuckets.top = tokensToSearchBuckets.top.filter(Boolean);
    if (tokenBucketPriority === _swaps3.TokenBucketPriority.owned) {
      return [...tokensToSearchBuckets.owned, ...tokensToSearchBuckets.top, ...tokensToSearchBuckets.others];
    }
    return [...tokensToSearchBuckets.top, ...tokensToSearchBuckets.owned, ...tokensToSearchBuckets.others];
  }, [memoizedTokensToSearch, memoizedUsersToken, memoizedTopTokens, tokenConversionRates, conversionRate, currentCurrency, memoizedDefaultToken, chainId, tokenList, tokenBucketPriority]);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useTokensToSearch.js",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useTransactionDisplayData.js", {"../../shared/constants/bridge":"D:\\code\\v\\metamask-extension\\shared\\constants\\bridge.ts","../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../shared/lib/metamask-controller-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\metamask-controller-utils.js","../../shared/lib/transactions-controller-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\transactions-controller-utils.js","../../shared/modules/string-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\string-utils.ts","../ducks/bridge-status/selectors":"D:\\code\\v\\metamask-extension\\ui\\ducks\\bridge-status\\selectors.ts","../ducks/locale/locale":"D:\\code\\v\\metamask-extension\\ui\\ducks\\locale\\locale.ts","../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../helpers/constants/common":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\common.ts","../helpers/constants/transactions":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\transactions.js","../helpers/utils/common.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\common.util.js","../helpers/utils/token-util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\token-util.js","../helpers/utils/transactions.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\transactions.util.js","../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../pages/bridge/hooks/useBridgeTokenDisplayData":"D:\\code\\v\\metamask-extension\\ui\\pages\\bridge\\hooks\\useBridgeTokenDisplayData.ts","../pages/confirmations/components/simulation-details/formatAmount":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\components\\simulation-details\\formatAmount.ts","../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./bridge/useBridgeChainInfo":"D:\\code\\v\\metamask-extension\\ui\\hooks\\bridge\\useBridgeChainInfo.ts","./useCurrencyDisplay":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useCurrencyDisplay.js","./useCurrentAsset":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useCurrentAsset.js","./useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","./useSwappedTokenValue":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useSwappedTokenValue.js","./useTokenData":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTokenData.js","./useTokenDisplayValue":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTokenDisplayValue.js","./useTokenFiatAmount":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useTokenFiatAmount.js","./useUserPreferencedCurrency":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useUserPreferencedCurrency.js","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","bignumber.js":"D:\\code\\v\\metamask-extension\\node_modules\\bignumber.js\\bignumber.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseTransactionDisplayData.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTransactionDisplayData = useTransactionDisplayData;
var _reactRedux = require("react-redux");
var _react = require("react");
var _transactionController = require("@metamask/transaction-controller");
var _bignumber = _interopRequireDefault(require("bignumber.js"));
var _selectors = require("../selectors/selectors");
var _transactions = require("../helpers/utils/transactions.util");
var _common = require("../helpers/utils/common.util");
var _common2 = require("../helpers/constants/common");
var _tokenUtil = require("../helpers/utils/token-util");
var _util = require("../helpers/utils/util");
var _transactions2 = require("../helpers/constants/transactions");
var _metamask = require("../ducks/metamask/metamask");
var _transaction = require("../../shared/constants/transaction");
var _actions = require("../store/actions");
var _stringUtils = require("../../shared/modules/string-utils");
var _metamaskControllerUtils = require("../../shared/lib/metamask-controller-utils");
var _useBridgeTokenDisplayData = require("../pages/bridge/hooks/useBridgeTokenDisplayData");
var _formatAmount = require("../pages/confirmations/components/simulation-details/formatAmount");
var _locale = require("../ducks/locale/locale");
var _bridge = require("../../shared/constants/bridge");
var _transactionsControllerUtils = require("../../shared/lib/transactions-controller-utils");
var _selectors2 = require("../ducks/bridge-status/selectors");
var _useI18nContext = require("./useI18nContext");
var _useTokenFiatAmount = require("./useTokenFiatAmount");
var _useUserPreferencedCurrency = require("./useUserPreferencedCurrency");
var _useCurrencyDisplay = require("./useCurrencyDisplay");
var _useTokenDisplayValue = require("./useTokenDisplayValue");
var _useTokenData = require("./useTokenData");
var _useSwappedTokenValue = require("./useSwappedTokenValue");
var _useCurrentAsset = require("./useCurrentAsset");
var _useBridgeChainInfo = _interopRequireDefault(require("./bridge/useBridgeChainInfo"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 *  There are seven types of transaction entries that are currently differentiated in the design:
 *  1. Signature request
 *  2. Send (sendEth sendTokens)
 *  3. Deposit
 *  4. Site interaction
 *  5. Approval
 *  6. Swap
 *  7. Swap Approval
 */
const signatureTypes = [null, undefined, _transactionController.TransactionType.sign, _transactionController.TransactionType.personalSign, _transactionController.TransactionType.signTypedData, _transactionController.TransactionType.ethDecrypt, _transactionController.TransactionType.ethGetEncryptionPublicKey];

/**
 * @typedef {(__import__('../../selectors/transactions').TransactionGroup} TransactionGroup
 */

/**
 * @typedef {object} TransactionDisplayData
 * @property {string} category - the transaction category that will be used for rendering the icon in the activity list
 * @property {string} primaryCurrency - the currency string to display in the primary position
 * @property {string} recipientAddress - the Ethereum address of the recipient
 * @property {string} senderAddress - the Ethereum address of the sender
 * @property {string} status - the status of the transaction
 * @property {string} subtitle - the supporting text describing the transaction
 * @property {boolean} subtitleContainsOrigin - true if the subtitle includes the origin of the tx
 * @property {string} title - the primary title of the tx that will be displayed in the activity list
 * @property {string} [secondaryCurrency] - the currency string to display in the secondary position
 * @property {string} date - the formatted date of the transaction
 * @property {string} displayedStatusKey - the key representing the displayed status of the transaction
 * @property {boolean} isPending - indicates if the transaction is pending
 * @property {boolean} isSubmitted - indicates if the transaction has been submitted
 */

/**
 * Get computed values used for displaying transaction data to a user
 *
 * The goal of this method is to perform all of the necessary computation and
 * state access required to take a transactionGroup and derive from it a shape
 * of data that can power all views related to a transaction. Presently the main
 * case is for shared logic between transaction-list-item and transaction-detail-view
 *
 * @param {TransactionGroup} transactionGroup - group of transactions of the same nonce
 * @returns {TransactionDisplayData}
 */
function useTransactionDisplayData(transactionGroup) {
  var _primaryTransaction$t, _initialTransaction$t2, _token, _token2, _initialTransaction$m, _token3, _transactionGroup$ini4, _transactionGroup$ini5, _transactionGroup$ini6;
  // To determine which primary currency to display for swaps transactions we need to be aware
  // of which asset, if any, we are viewing at present
  const dispatch = (0, _reactRedux.useDispatch)();
  const locale = (0, _reactRedux.useSelector)(_locale.getIntlLocale);
  const currentAsset = (0, _useCurrentAsset.useCurrentAsset)();
  const knownTokens = (0, _reactRedux.useSelector)(_selectors.getAllTokens);
  const selectedAddress = (0, _reactRedux.useSelector)(_selectors.getSelectedAddress);
  const knownNfts = (0, _reactRedux.useSelector)(_metamask.getNfts);
  const allDetectedTokens = (0, _reactRedux.useSelector)(_selectors.getAllDetectedTokens);
  const tokenListAllChains = (0, _reactRedux.useSelector)(_selectors.selectERC20TokensByChain);
  const t = (0, _useI18nContext.useI18nContext)();

  // Bridge data
  const srcTxMetaId = transactionGroup.initialTransaction.id;
  const bridgeHistoryItem = (0, _reactRedux.useSelector)(state => (0, _selectors2.selectBridgeHistoryItemForTxMetaId)(state, srcTxMetaId));
  const {
    destNetwork
  } = (0, _useBridgeChainInfo.default)({
    bridgeHistoryItem,
    srcTxMeta: transactionGroup.initialTransaction
  });
  const destChainName = _bridge.NETWORK_TO_SHORT_NETWORK_NAME_MAP[destNetwork === null || destNetwork === void 0 ? void 0 : destNetwork.chainId];
  const {
    initialTransaction,
    primaryTransaction
  } = transactionGroup;
  // initialTransaction contains the data we need to derive the primary purpose of this transaction group
  const {
    transferInformation,
    type
  } = initialTransaction;
  const {
    from,
    to
  } = initialTransaction.txParams || {};
  const isUnifiedSwapTx = [_transactionController.TransactionType.swap, _transactionController.TransactionType.bridge].includes(type) && Boolean(bridgeHistoryItem);

  // for smart contract interactions, methodData can be used to derive the name of the action being taken
  const methodData = (0, _reactRedux.useSelector)(state => {
    var _initialTransaction$t;
    return (0, _selectors.getKnownMethodData)(state, initialTransaction === null || initialTransaction === void 0 || (_initialTransaction$t = initialTransaction.txParams) === null || _initialTransaction$t === void 0 ? void 0 : _initialTransaction$t.data);
  }) || {};
  const displayedStatusKey = (0, _transactions.getStatusKey)(primaryTransaction);
  const isPending = displayedStatusKey in _transactions2.PENDING_STATUS_HASH;
  const isSubmitted = displayedStatusKey === _transactionController.TransactionStatus.submitted;
  const mounted = (0, _react.useRef)(true);
  const primaryValue = (_primaryTransaction$t = primaryTransaction.txParams) === null || _primaryTransaction$t === void 0 ? void 0 : _primaryTransaction$t.value;
  const date = (0, _util.formatDateWithYearContext)(initialTransaction.time);
  let prefix = '-';
  let subtitle;
  let subtitleContainsOrigin = false;
  let recipientAddress = to;
  const senderAddress = from;
  const transactionData = initialTransaction === null || initialTransaction === void 0 || (_initialTransaction$t2 = initialTransaction.txParams) === null || _initialTransaction$t2 === void 0 ? void 0 : _initialTransaction$t2.data;

  // This value is used to determine whether we should look inside txParams.data
  // to pull out and render token related information
  const isTokenCategory = _transactions2.TOKEN_CATEGORY_HASH[type];
  // these values are always instantiated because they are either
  // used by or returned from hooks. Hooks must be called at the top level,
  // so as an additional safeguard against inappropriately associating token
  // transfers, we pass an additional argument to these hooks that will be
  // false for non-token transactions. This additional argument forces the
  // hook to return null
  let token = null;
  const [currentAssetDetails, setCurrentAssetDetails] = (0, _react.useState)(null);
  if (isTokenCategory) {
    var _knownTokens$transact, _transactionGroup$ini, _allDetectedTokens$tr, _transactionGroup$ini2, _tokenListAllChains$t, _transactionGroup$ini3;
    token = (knownTokens === null || knownTokens === void 0 || (_knownTokens$transact = knownTokens[transactionGroup === null || transactionGroup === void 0 || (_transactionGroup$ini = transactionGroup.initialTransaction) === null || _transactionGroup$ini === void 0 ? void 0 : _transactionGroup$ini.chainId]) === null || _knownTokens$transact === void 0 || (_knownTokens$transact = _knownTokens$transact[selectedAddress]) === null || _knownTokens$transact === void 0 ? void 0 : _knownTokens$transact.find(({
      address
    }) => (0, _stringUtils.isEqualCaseInsensitive)(address, recipientAddress))) || (allDetectedTokens === null || allDetectedTokens === void 0 || (_allDetectedTokens$tr = allDetectedTokens[transactionGroup === null || transactionGroup === void 0 || (_transactionGroup$ini2 = transactionGroup.initialTransaction) === null || _transactionGroup$ini2 === void 0 ? void 0 : _transactionGroup$ini2.chainId]) === null || _allDetectedTokens$tr === void 0 || (_allDetectedTokens$tr = _allDetectedTokens$tr[selectedAddress]) === null || _allDetectedTokens$tr === void 0 ? void 0 : _allDetectedTokens$tr.find(({
      address
    }) => (0, _stringUtils.isEqualCaseInsensitive)(address, recipientAddress))) || (tokenListAllChains === null || tokenListAllChains === void 0 || (_tokenListAllChains$t = tokenListAllChains[transactionGroup === null || transactionGroup === void 0 || (_transactionGroup$ini3 = transactionGroup.initialTransaction) === null || _transactionGroup$ini3 === void 0 ? void 0 : _transactionGroup$ini3.chainId]) === null || _tokenListAllChains$t === void 0 || (_tokenListAllChains$t = _tokenListAllChains$t.data) === null || _tokenListAllChains$t === void 0 ? void 0 : _tokenListAllChains$t[recipientAddress.toLowerCase()]);
  }
  (0, _react.useEffect)(() => {
    return () => {
      mounted.current = false;
    };
  }, []);
  (0, _react.useEffect)(() => {
    async function getAndSetAssetDetails() {
      if (isTokenCategory && !token) {
        try {
          const assetDetails = await (0, _tokenUtil.getAssetDetails)(recipientAddress, senderAddress, transactionData, knownNfts);
          if (mounted.current === true) {
            setCurrentAssetDetails(assetDetails);
          }
        } catch (e) {
          console.warn('Unable to set asset details', {
            error: e,
            transactionData
          });
        }
      }
    }
    getAndSetAssetDetails();
  }, [isTokenCategory, token, recipientAddress, senderAddress, knownNfts, mounted, transactionData]);
  if (currentAssetDetails) {
    token = {
      address: currentAssetDetails.toAddress,
      symbol: currentAssetDetails.symbol,
      decimals: currentAssetDetails.decimals
    };
  }
  const tokenData = (0, _useTokenData.useTokenData)(transactionData, isTokenCategory);

  // Sometimes the tokenId value is parsed as "_value" param. Not seeing this often any more, but still occasionally:
  // i.e. call approve() on BAYC contract - https://etherscan.io/token/0xbc4ca0eda7647a8ab7c2061c2e118a18a936f13d#writeContract, and tokenId shows up as _value,
  // not sure why since it doesn't match the ERC721 ABI spec we use to parse these transactions - https://github.com/MetaMask/metamask-eth-abis/blob/d0474308a288f9252597b7c93a3a8deaad19e1b2/src/abis/abiERC721.ts#L62.
  const transactionDataTokenId = (0, _tokenUtil.getTokenIdParam)(tokenData) ?? (0, _metamaskControllerUtils.getTokenValueParam)(tokenData);
  const nft = isTokenCategory && knownNfts.find(({
    address,
    tokenId
  }) => (0, _stringUtils.isEqualCaseInsensitive)(address, recipientAddress) && tokenId === transactionDataTokenId);
  let tokenDisplayValue = (0, _useTokenDisplayValue.useTokenDisplayValue)(transactionData, token, isTokenCategory);
  if (transferInformation !== null && transferInformation !== void 0 && transferInformation.decimals) {
    tokenDisplayValue = (0, _transactionsControllerUtils.calcTokenAmount)(transferInformation.amount, transferInformation.decimals).toString(10);
  }
  const tokenFiatAmount = (0, _useTokenFiatAmount.useTokenFiatAmount)((_token = token) === null || _token === void 0 ? void 0 : _token.address, tokenDisplayValue, (_token2 = token) === null || _token2 === void 0 ? void 0 : _token2.symbol, undefined, true);
  const origin = (0, _util.stripHttpSchemes)(initialTransaction.origin || ((_initialTransaction$m = initialTransaction.msgParams) === null || _initialTransaction$m === void 0 ? void 0 : _initialTransaction$m.origin) || '');

  // used to append to the primary display value. initialized to either token.symbol or undefined
  // but can later be modified if dealing with a swap
  let primarySuffix = isTokenCategory ? (_token3 = token) === null || _token3 === void 0 ? void 0 : _token3.symbol : undefined;
  // used to display the primary value of tx. initialized to either tokenDisplayValue or undefined
  // but can later be modified if dealing with a swap
  let primaryDisplayValue = isTokenCategory ? tokenDisplayValue : undefined;
  // used to display fiat amount of tx. initialized to either tokenFiatAmount or undefined
  // but can later be modified if dealing with a swap
  let secondaryDisplayValue = isTokenCategory ? tokenFiatAmount : undefined;
  let category;
  let title;
  const {
    swapTokenValue,
    isNegative,
    swapTokenFiatAmount,
    isViewingReceivedTokenFromSwap
  } = (0, _useSwappedTokenValue.useSwappedTokenValue)(transactionGroup, currentAsset);
  const bridgeTokenDisplayData = (0, _useBridgeTokenDisplayData.useBridgeTokenDisplayData)(transactionGroup);
  if (signatureTypes.includes(type)) {
    category = _transaction.TransactionGroupCategory.signatureRequest;
    title = t('signatureRequest');
    subtitle = origin;
    subtitleContainsOrigin = true;
  } else if (type === _transactionController.TransactionType.swap) {
    category = _transaction.TransactionGroupCategory.swap;
    title = t('swapTokenToToken', [bridgeTokenDisplayData.sourceTokenSymbol ?? initialTransaction.sourceTokenSymbol, bridgeTokenDisplayData.destinationTokenSymbol ?? initialTransaction.destinationTokenSymbol]);
    subtitle = origin;
    subtitleContainsOrigin = true;
    const symbolFromTx = bridgeTokenDisplayData.sourceTokenSymbol ?? initialTransaction.sourceTokenSymbol;
    primarySuffix = isViewingReceivedTokenFromSwap ? currentAsset.symbol : symbolFromTx;
    const value = bridgeTokenDisplayData.sourceTokenAmountSent ?? swapTokenValue;
    primaryDisplayValue = value ? (0, _formatAmount.formatAmount)(locale, new _bignumber.default(value)) : undefined;
    secondaryDisplayValue = bridgeTokenDisplayData.displayCurrencyAmount ?? swapTokenFiatAmount;
    if (isNegative) {
      prefix = '';
    } else if (isViewingReceivedTokenFromSwap) {
      prefix = '+';
    } else {
      prefix = '-';
    }
  } else if (type === _transactionController.TransactionType.swapAndSend) {
    const isSenderTokenRecipient = initialTransaction.swapAndSendRecipient === senderAddress;
    recipientAddress = initialTransaction.swapAndSendRecipient;
    category = _transaction.TransactionGroupCategory.swapAndSend;
    title = t('sentTokenAsToken', [initialTransaction.sourceTokenSymbol, initialTransaction.destinationTokenSymbol]);
    subtitle = origin;
    subtitleContainsOrigin = true;
    primarySuffix = isViewingReceivedTokenFromSwap && isSenderTokenRecipient ? currentAsset.symbol : initialTransaction.sourceTokenSymbol;
    primaryDisplayValue = swapTokenValue;
    secondaryDisplayValue = swapTokenFiatAmount;
    if (isNegative) {
      prefix = '';
    } else if (isViewingReceivedTokenFromSwap && isSenderTokenRecipient) {
      prefix = '+';
    } else {
      prefix = '-';
    }
  } else if (type === _transactionController.TransactionType.swapApproval) {
    category = _transaction.TransactionGroupCategory.approval;
    title = t('swapApproval', [bridgeTokenDisplayData.sourceTokenSymbol ?? primaryTransaction.sourceTokenSymbol]);
    subtitle = origin;
    subtitleContainsOrigin = true;
    primarySuffix = bridgeTokenDisplayData.sourceTokenSymbol ?? primaryTransaction.sourceTokenSymbol;
  } else if (type === _transactionController.TransactionType.tokenMethodApprove) {
    var _token4;
    category = _transaction.TransactionGroupCategory.approval;
    prefix = '';
    title = t('approveSpendingCap', [((_token4 = token) === null || _token4 === void 0 ? void 0 : _token4.symbol) || t('token').toLowerCase()]);
    subtitle = origin;
    subtitleContainsOrigin = true;
  } else if (type === _transactionController.TransactionType.tokenMethodSetApprovalForAll) {
    var _tokenData$args, _token5, _token6;
    const isRevoke = !(tokenData !== null && tokenData !== void 0 && (_tokenData$args = tokenData.args) !== null && _tokenData$args !== void 0 && _tokenData$args[1]);
    category = _transaction.TransactionGroupCategory.approval;
    prefix = '';
    title = isRevoke ? t('revokePermissionTitle', [((_token5 = token) === null || _token5 === void 0 ? void 0 : _token5.symbol) || (nft === null || nft === void 0 ? void 0 : nft.name) || t('token')]) : t('setApprovalForAllTitle', [((_token6 = token) === null || _token6 === void 0 ? void 0 : _token6.symbol) || t('token')]);
    subtitle = origin;
    subtitleContainsOrigin = true;
  } else if (type === _transactionController.TransactionType.tokenMethodIncreaseAllowance) {
    var _token7;
    category = _transaction.TransactionGroupCategory.approval;
    prefix = '';
    title = t('approveIncreaseAllowance', [((_token7 = token) === null || _token7 === void 0 ? void 0 : _token7.symbol) || t('token')]);
    subtitle = origin;
    subtitleContainsOrigin = true;
  } else if (type === _transactionController.TransactionType.contractInteraction || type === _transactionController.TransactionType.batch || type === _transactionController.TransactionType.revokeDelegation) {
    category = _transaction.TransactionGroupCategory.interaction;
    const transactionTypeTitle = (0, _transactions.getTransactionTypeTitle)(t, type);
    title = (methodData === null || methodData === void 0 ? void 0 : methodData.name) && (0, _common.camelCaseToCapitalize)(methodData.name) || transactionTypeTitle;
    subtitle = origin;
    subtitleContainsOrigin = true;
  } else if (type === _transactionController.TransactionType.deployContract) {
    // @todo Should perhaps be a separate group?
    category = _transaction.TransactionGroupCategory.interaction;
    title = (0, _transactions.getTransactionTypeTitle)(t, type);
    subtitle = origin;
    subtitleContainsOrigin = true;
  } else if (type === _transactionController.TransactionType.incoming) {
    category = _transaction.TransactionGroupCategory.receive;
    title = t('received');
    prefix = '';
    subtitle = t('fromAddress', [(0, _util.shortenAddress)(senderAddress)]);
  } else if (type === _transactionController.TransactionType.tokenMethodTransferFrom || type === _transactionController.TransactionType.tokenMethodTransfer) {
    var _token8;
    category = _transaction.TransactionGroupCategory.send;
    title = t('sentSpecifiedTokens', [((_token8 = token) === null || _token8 === void 0 ? void 0 : _token8.symbol) || (nft === null || nft === void 0 ? void 0 : nft.name) || t('token')]);
    recipientAddress = (0, _tokenUtil.getTokenAddressParam)(tokenData);
    subtitle = t('toAddress', [(0, _util.shortenAddress)(recipientAddress)]);
  } else if (type === _transactionController.TransactionType.tokenMethodSafeTransferFrom) {
    category = _transaction.TransactionGroupCategory.send;
    title = t('safeTransferFrom');
    recipientAddress = (0, _tokenUtil.getTokenAddressParam)(tokenData);
    subtitle = t('toAddress', [(0, _util.shortenAddress)(recipientAddress)]);
  } else if (type === _transactionController.TransactionType.simpleSend) {
    category = _transaction.TransactionGroupCategory.send;
    title = t('sent');
    subtitle = t('toAddress', [(0, _util.shortenAddress)(recipientAddress)]);
  } else if (type === _transactionController.TransactionType.bridgeApproval) {
    category = _transaction.TransactionGroupCategory.approval;
    title = t('bridgeApproval', [bridgeTokenDisplayData.sourceTokenSymbol]);
    subtitle = origin;
    subtitleContainsOrigin = true;
    primarySuffix = bridgeTokenDisplayData.sourceTokenSymbol;
  } else if (type === _transactionController.TransactionType.bridge) {
    title = destChainName ? t('bridgedToChain', [destChainName]) : t('bridged');
    category = bridgeTokenDisplayData.category;
    primarySuffix = bridgeTokenDisplayData.sourceTokenSymbol;
    primaryDisplayValue = (0, _formatAmount.formatAmount)(locale, new _bignumber.default(bridgeTokenDisplayData.sourceTokenAmountSent ?? 0));
    secondaryDisplayValue = bridgeTokenDisplayData.displayCurrencyAmount;
  } else {
    dispatch((0, _actions.captureSingleException)(`useTransactionDisplayData does not recognize transaction type. Type received is: ${type}`));
  }
  const detailsTitle = title;
  const primaryCurrencyPreferences = (0, _useUserPreferencedCurrency.useUserPreferencedCurrency)(_common2.PRIMARY, {}, transactionGroup === null || transactionGroup === void 0 || (_transactionGroup$ini4 = transactionGroup.initialTransaction) === null || _transactionGroup$ini4 === void 0 ? void 0 : _transactionGroup$ini4.chainId);
  const secondaryCurrencyPreferences = (0, _useUserPreferencedCurrency.useUserPreferencedCurrency)(_common2.SECONDARY);
  const [primaryCurrency] = (0, _useCurrencyDisplay.useCurrencyDisplay)(primaryValue, {
    prefix,
    displayValue: primaryDisplayValue,
    suffix: primarySuffix,
    ...primaryCurrencyPreferences
  }, transactionGroup === null || transactionGroup === void 0 || (_transactionGroup$ini5 = transactionGroup.initialTransaction) === null || _transactionGroup$ini5 === void 0 ? void 0 : _transactionGroup$ini5.chainId);
  const [secondaryCurrency] = (0, _useCurrencyDisplay.useCurrencyDisplay)(primaryValue, {
    prefix,
    displayValue: isUnifiedSwapTx ? bridgeTokenDisplayData.displayCurrencyAmount : secondaryDisplayValue,
    hideLabel: isTokenCategory || Boolean(swapTokenValue),
    ...secondaryCurrencyPreferences
  }, transactionGroup === null || transactionGroup === void 0 || (_transactionGroup$ini6 = transactionGroup.initialTransaction) === null || _transactionGroup$ini6 === void 0 ? void 0 : _transactionGroup$ini6.chainId);
  if (!recipientAddress && transferInformation) {
    recipientAddress = to;
  }
  return {
    title,
    category,
    date,
    subtitle,
    subtitleContainsOrigin,
    primaryCurrency: type === _transactionController.TransactionType.swap && isPending ? '' : primaryCurrency,
    senderAddress,
    recipientAddress,
    secondaryCurrency: isTokenCategory && !tokenFiatAmount || !isUnifiedSwapTx && [_transactionController.TransactionType.swap, _transactionController.TransactionType.swapAndSend].includes(type) && !swapTokenFiatAmount || isUnifiedSwapTx && !secondaryCurrency ? undefined : secondaryCurrency,
    displayedStatusKey,
    isPending,
    isSubmitted,
    detailsTitle
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useTransactionDisplayData.js",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useTrustSignals.ts", {"../../app/scripts/lib/trust-signals/types":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\trust-signals\\types.ts","../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","@metamask/name-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\name-controller\\dist\\index.cjs","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseTrustSignals.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TrustSignalDisplayState = void 0;
exports.useTrustSignal = useTrustSignal;
exports.useTrustSignals = useTrustSignals;
var _reactRedux = require("react-redux");
var _nameController = require("@metamask/name-controller");
var _selectors = require("../selectors");
var _types = require("../../app/scripts/lib/trust-signals/types");
// eslint-disable-next-line import/no-restricted-paths
let TrustSignalDisplayState = exports.TrustSignalDisplayState = /*#__PURE__*/function (TrustSignalDisplayState) {
  TrustSignalDisplayState["Loading"] = "loading";
  TrustSignalDisplayState["Malicious"] = "malicious";
  TrustSignalDisplayState["Petname"] = "petname";
  TrustSignalDisplayState["Verified"] = "verified";
  TrustSignalDisplayState["Warning"] = "warning";
  TrustSignalDisplayState["Recognized"] = "recognized";
  TrustSignalDisplayState["Unknown"] = "unknown";
  return TrustSignalDisplayState;
}({});
function useTrustSignal(value, type) {
  return useTrustSignals([{
    value,
    type
  }])[0];
}
function useTrustSignals(requests) {
  return (0, _reactRedux.useSelector)(state => requests.map(({
    value,
    type
  }) => {
    if (type !== _nameController.NameType.ETHEREUM_ADDRESS) {
      return {
        state: TrustSignalDisplayState.Unknown,
        label: null
      };
    }
    const securityAlertResponse = (0, _selectors.getAddressSecurityAlertResponse)(state, value);
    if (!securityAlertResponse) {
      return {
        state: TrustSignalDisplayState.Unknown,
        label: null
      };
    }
    const label = securityAlertResponse.label || null;
    const trustState = getTrustState(securityAlertResponse);
    return {
      state: trustState,
      label
    };
  }));
}
function getTrustState(securityAlertResponse) {
  if (!securityAlertResponse.result_type) {
    return TrustSignalDisplayState.Unknown;
  }
  switch (securityAlertResponse.result_type) {
    case _types.ResultType.Loading:
      return TrustSignalDisplayState.Loading;
    case _types.ResultType.Malicious:
      return TrustSignalDisplayState.Malicious;
    case _types.ResultType.Warning:
      return TrustSignalDisplayState.Warning;
    case _types.ResultType.Trusted:
      return TrustSignalDisplayState.Verified;
    case _types.ResultType.Benign:
    case _types.ResultType.ErrorResult:
    default:
      return TrustSignalDisplayState.Unknown;
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useTrustSignals.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useUserPreferencedCurrency.js", {"../../shared/constants/common":"D:\\code\\v\\metamask-extension\\shared\\constants\\common.ts","../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../constants":"D:\\code\\v\\metamask-extension\\ui\\constants\\index.js","../helpers/constants/common":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\common.ts","../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","./useMultichainSelector":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainSelector.ts","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseUserPreferencedCurrency.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUserPreferencedCurrency = useUserPreferencedCurrency;
var _reactRedux = require("react-redux");
var _selectors = require("../selectors");
var _multichain = require("../selectors/multichain");
var _common = require("../helpers/constants/common");
var _common2 = require("../../shared/constants/common");
var _constants = require("../constants");
var _network = require("../../shared/constants/network");
var _useMultichainSelector = require("./useMultichainSelector");
/**
 * Defines the shape of the options parameter for useUserPreferencedCurrency
 *
 * @typedef {object} UseUserPreferencedCurrencyOptions
 * @property {number} [numberOfDecimals] - Number of significant decimals to display
 * @property {number} [ethNumberOfDecimals] - Number of significant decimals to display
 *                                             when using ETH
 * @property {boolean} [shouldCheckShowNativeToken] - Boolean to know if checking the setting
 *                                                  show native token as main balance is needed
 */

/**
 * Defines the return shape of useUserPreferencedCurrency
 *
 * @typedef {object} UserPreferredCurrency
 * @property {string} currency - the currency type to use (eg: 'ETH', 'usd')
 * @property {number} numberOfDecimals - Number of significant decimals to display
 */

/**
 * useUserPreferencedCurrency
 *
 * returns an object that contains what currency to use for displaying values based
 * on whether the user needs to check showNativeTokenAsMainBalance setting, as well as the significant number of decimals
 * to display based on the currency
 *
 *
 * @param {"PRIMARY" | "SECONDARY"} type - what display type is being rendered
 * @param {UseUserPreferencedCurrencyOptions} opts - options to override default values
 * @param {string} chainId - chainId to use
 * @returns {UserPreferredCurrency}
 */
function useUserPreferencedCurrency(type, opts = {}, chainId = null) {
  const selectedAccount = (0, _reactRedux.useSelector)(_selectors.getSelectedInternalAccount);
  const account = opts.account ?? selectedAccount;
  const nativeCurrency = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainNativeCurrency, account);
  const {
    showNativeTokenAsMainBalance
  } = (0, _reactRedux.useSelector)(_selectors.getPreferences, _reactRedux.shallowEqual);
  const showFiat = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainShouldShowFiat, account);
  const currentCurrency = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainCurrentCurrency, account);
  const fiatReturn = {
    currency: currentCurrency,
    numberOfDecimals: opts.numberOfDecimals || 2
  };
  const nativeReturn = {
    currency: chainId ? _network.CHAIN_ID_TO_CURRENCY_SYMBOL_MAP[chainId] || nativeCurrency || _common2.EtherDenomination.ETH : nativeCurrency || _common2.EtherDenomination.ETH,
    numberOfDecimals: opts.numberOfDecimals || opts.ethNumberOfDecimals || _constants.ETH_DEFAULT_DECIMALS
  };
  if (opts.showNativeOverride) {
    return nativeReturn;
  } else if (opts.showFiatOverride) {
    return fiatReturn;
  } else if (!showFiat) {
    return nativeReturn;
  } else if (opts.shouldCheckShowNativeToken && showNativeTokenAsMainBalance || !opts.shouldCheckShowNativeToken) {
    return type === _common.PRIMARY ? nativeReturn : fiatReturn;
  }
  return type === _common.PRIMARY ? fiatReturn : nativeReturn;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useUserPreferencedCurrency.js",}],
["D:\\code\\v\\metamask-extension\\ui\\hooks\\useWindowFocus.ts", {"react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Chooks%5CuseWindowFocus.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWindowFocus = void 0;
var _react = require("react");
const useWindowFocus = () => {
  const [isFocused, setIsFocused] = (0, _react.useState)(document.hasFocus());
  (0, _react.useEffect)(() => {
    const onFocus = () => setIsFocused(true);
    const onBlur = () => setIsFocused(false);
    window.addEventListener('focus', onFocus);
    window.addEventListener('blur', onBlur);
    return () => {
      window.removeEventListener('focus', onFocus);
      window.removeEventListener('blur', onBlur);
    };
  }, []);
  return isFocused;
};
exports.useWindowFocus = useWindowFocus;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\hooks\\useWindowFocus.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\index.js", {"../app/scripts/constants/sentry-state":"D:\\code\\v\\metamask-extension\\app\\scripts\\constants\\sentry-state.ts","../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../shared/constants/alerts":"D:\\code\\v\\metamask-extension\\shared\\constants\\alerts.ts","../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../shared/constants/copy":"D:\\code\\v\\metamask-extension\\shared\\constants\\copy.ts","../shared/lib/error-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\error-utils.js","../shared/lib/promise-with-resolvers":"D:\\code\\v\\metamask-extension\\shared\\lib\\promise-with-resolvers.ts","../shared/lib/sentry":"D:\\code\\v\\metamask-extension\\shared\\lib\\sentry.ts","../shared/lib/switch-direction":"D:\\code\\v\\metamask-extension\\shared\\lib\\switch-direction.js","../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../shared/modules/object.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\object.utils.js","../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","./constants":"D:\\code\\v\\metamask-extension\\ui\\constants\\index.js","./ducks/alerts":"D:\\code\\v\\metamask-extension\\ui\\ducks\\alerts\\index.js","./ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","./helpers/utils/critical-startup-error-handler":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\critical-startup-error-handler.ts","./helpers/utils/display-critical-error":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\display-critical-error.ts","./helpers/utils/tags":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\tags.ts","./helpers/utils/tx-helper":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\tx-helper.ts","./pages":"D:\\code\\v\\metamask-extension\\ui\\pages\\index.js","./selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","./store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./store/background-connection":"D:\\code\\v\\metamask-extension\\ui\\store\\background-connection.ts","./store/store":"D:\\code\\v\\metamask-extension\\ui\\store\\store.ts","@metamask/chain-agnostic-permission":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\chain-agnostic-permission\\dist\\index.cjs","copy-to-clipboard":"D:\\code\\v\\metamask-extension\\node_modules\\copy-to-clipboard\\index.js","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-dom\\index.js","webextension-polyfill":"D:\\code\\v\\metamask-extension\\node_modules\\webextension-polyfill\\dist\\browser-polyfill.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "CriticalErrorTranslationKey", {
  enumerable: true,
  get: function () {
    return _displayCriticalError.CriticalErrorTranslationKey;
  }
});
Object.defineProperty(exports, "CriticalStartupErrorHandler", {
  enumerable: true,
  get: function () {
    return _criticalStartupErrorHandler.CriticalStartupErrorHandler;
  }
});
exports.connectToBackground = void 0;
exports.default = launchMetamaskUi;
Object.defineProperty(exports, "displayCriticalError", {
  enumerable: true,
  get: function () {
    return _displayCriticalError.displayCriticalError;
  }
});
exports.getCleanAppState = getCleanAppState;
exports.setupInitialStore = setupInitialStore;
var _copyToClipboard = _interopRequireDefault(require("copy-to-clipboard"));
var _loglevel = _interopRequireDefault(require("loglevel"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _webextensionPolyfill = _interopRequireDefault(require("webextension-polyfill"));
var _chainAgnosticPermission = require("@metamask/chain-agnostic-permission");
var _sentry = require("../shared/lib/sentry");
var _promiseWithResolvers = require("../shared/lib/promise-with-resolvers");
var _util = require("../app/scripts/lib/util");
var _alerts = require("../shared/constants/alerts");
var _object = require("../shared/modules/object.utils");
var _sentryState = require("../app/scripts/constants/sentry-state");
var _app = require("../shared/constants/app");
var _copy = require("../shared/constants/copy");
var _switchDirection = require("../shared/lib/switch-direction");
var _errorUtils = require("../shared/lib/error-utils");
var _trace = require("../shared/lib/trace");
var _networks = require("../shared/modules/selectors/networks");
var actions = _interopRequireWildcard(require("./store/actions"));
var _store = _interopRequireDefault(require("./store/store"));
var _selectors = require("./selectors");
var _alerts2 = require("./ducks/alerts");
var _metamask = require("./ducks/metamask/metamask");
var _pages = _interopRequireDefault(require("./pages"));
var _txHelper = _interopRequireDefault(require("./helpers/utils/tx-helper"));
var _backgroundConnection = require("./store/background-connection");
var _tags = require("./helpers/utils/tags");
var _constants = require("./constants");
var _criticalStartupErrorHandler = require("./helpers/utils/critical-startup-error-handler");
var _displayCriticalError = require("./helpers/utils/display-critical-error");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

const METHOD_START_UI_SYNC = 'startUISync';
_loglevel.default.setLevel(global.METAMASK_DEBUG ? 'debug' : 'warn', false);

/**
 * @type {PromiseWithResolvers<ReturnType<typeof configureStore>>}
 */
const reduxStore = (0, _promiseWithResolvers.withResolvers)();

/**
 * Method to update backgroundConnection object use by UI
 *
 * @param backgroundConnection - connection object to background
 * @param handleStartUISync - function to call when startUISync notification is received
 */
const connectToBackground = (backgroundConnection, handleStartUISync) => {
  (0, _backgroundConnection.setBackgroundConnection)(backgroundConnection);
  backgroundConnection.onNotification(async data => {
    const {
      method
    } = data;
    if (method === 'sendUpdate') {
      const store = await reduxStore.promise;
      store.dispatch(actions.updateMetamaskState(data.params[0]));
    } else if (method === METHOD_START_UI_SYNC) {
      await handleStartUISync();
    } else {
      throw new Error(`Internal JSON-RPC Notification Not Handled:\n\n ${JSON.stringify(data)}`);
    }
  });
};
exports.connectToBackground = connectToBackground;
async function launchMetamaskUi(opts) {
  const {
    backgroundConnection,
    traceContext
  } = opts;
  const metamaskState = await (0, _trace.trace)({
    name: _trace.TraceName.GetState,
    parentContext: traceContext
  }, backgroundConnection.getState.bind(backgroundConnection));
  const store = await startApp(metamaskState, opts);
  await backgroundConnection.startPatches();
  setupStateHooks(store);
  return store;
}

/**
 * Method to setup initial redux store for the ui application
 *
 * @param {*} metamaskState - flatten background state
 * @param {*} activeTab - active browser tab
 * @returns redux store
 */
async function setupInitialStore(metamaskState, activeTab) {
  // parse opts
  if (!metamaskState.featureFlags) {
    metamaskState.featureFlags = {};
  }
  const {
    currentLocaleMessages,
    enLocaleMessages
  } = await (0, _errorUtils.setupLocale)(metamaskState.currentLocale);
  if (metamaskState.textDirection === 'rtl') {
    (0, _switchDirection.switchDirection)('rtl');
  }
  const draftInitialState = {
    activeTab,
    // metamaskState represents the cross-tab state
    metamask: metamaskState,
    // appState represents the current tab's popup state
    appState: {},
    localeMessages: {
      currentLocale: metamaskState.currentLocale,
      current: currentLocaleMessages,
      en: enLocaleMessages
    }
  };
  if ((0, _util.getEnvironmentType)() === _app.ENVIRONMENT_TYPE_POPUP) {
    const {
      origin
    } = draftInitialState.activeTab;
    const permittedAccountsForCurrentTab = (0, _selectors.getAllPermittedAccountsForCurrentTab)(draftInitialState);
    const selectedAccount = (0, _selectors.getSelectedInternalAccount)(draftInitialState);
    const currentTabIsConnectedToSelectedAddress = selectedAccount && (0, _chainAgnosticPermission.isInternalAccountInPermittedAccountIds)(selectedAccount, permittedAccountsForCurrentTab);
    const unconnectedAccountAlertShownOrigins = (0, _metamask.getUnconnectedAccountAlertShown)(draftInitialState);
    const unconnectedAccountAlertIsEnabled = (0, _metamask.getUnconnectedAccountAlertEnabledness)(draftInitialState);
    if (origin && unconnectedAccountAlertIsEnabled && !unconnectedAccountAlertShownOrigins[origin] && permittedAccountsForCurrentTab.length > 0 && !currentTabIsConnectedToSelectedAddress) {
      draftInitialState[_alerts.AlertTypes.unconnectedAccount] = {
        state: _alerts2.ALERT_STATE.OPEN
      };
      actions.setUnconnectedAccountAlertShown(origin);
    }
  }
  const store = (0, _store.default)(draftInitialState);
  reduxStore.resolve(store);
  const unapprovedTxs = (0, _selectors.getUnapprovedTransactions)(metamaskState);

  // if unconfirmed txs, start on txConf page
  const unapprovedTxsAll = (0, _txHelper.default)(unapprovedTxs, metamaskState.unapprovedPersonalMsgs, metamaskState.unapprovedDecryptMsgs, metamaskState.unapprovedEncryptionPublicKeyMsgs, metamaskState.unapprovedTypedMessages, metamaskState.networkId, (0, _networks.getCurrentChainId)({
    metamask: metamaskState
  }));
  const numberOfUnapprovedTx = unapprovedTxsAll.length;
  if (numberOfUnapprovedTx > 0) {
    store.dispatch(actions.showConfTxPage({
      id: unapprovedTxsAll[0].id
    }));
  }
  return store;
}
async function startApp(metamaskState, opts) {
  const {
    traceContext
  } = opts;
  const tags = (0, _tags.getStartupTraceTags)({
    metamask: metamaskState
  });
  const store = await (0, _trace.trace)({
    name: _trace.TraceName.SetupStore,
    parentContext: traceContext,
    tags
  }, () => setupInitialStore(metamaskState, opts.activeTab));

  // global metamask api - used by tooling
  global.metamask = {
    updateCurrentLocale: code => {
      store.dispatch(actions.updateCurrentLocale(code));
    },
    setFeatureFlag: (key, value) => {
      store.dispatch(actions.setFeatureFlag(key, value));
    }
  };
  await (0, _trace.trace)({
    name: _trace.TraceName.InitialActions,
    parentContext: traceContext
  }, () => runInitialActions(store));
  (0, _trace.trace)({
    name: _trace.TraceName.FirstRender,
    parentContext: traceContext
  }, () => (0, _reactDom.render)(/*#__PURE__*/_react.default.createElement(_pages.default, {
    store: store
  }), opts.container));
  return store;
}
async function runInitialActions(store) {
  const initialState = store.getState();

  // This block autoswitches chains based on the last chain used
  // for a given dapp, when there are no pending confimrations
  // This allows the user to be connected on one chain
  // for one dapp, and automatically change for another
  const networkIdToSwitchTo = (0, _selectors.getNetworkToAutomaticallySwitchTo)(initialState);
  if (networkIdToSwitchTo) {
    await store.dispatch(actions.automaticallySwitchNetwork(networkIdToSwitchTo));
  }

  // Register this window as the current popup
  // and set in background state
  if ((0, _util.getEnvironmentType)() === _app.ENVIRONMENT_TYPE_POPUP) {
    const thisPopupId = Date.now();
    global.metamask.id = thisPopupId;
    await store.dispatch(actions.setCurrentExtensionPopupId(thisPopupId));
  }
  try {
    const validateSeedlessPasswordOutdated = async state => {
      const isUnlocked = (0, _metamask.getIsUnlocked)(state);
      if (isUnlocked) {
        await store.dispatch(actions.checkIsSeedlessPasswordOutdated());
      }
    };
    await validateSeedlessPasswordOutdated(initialState);
    // periodically check seedless password outdated when app UI is open
    setInterval(() => {
      const state = store.getState();
      validateSeedlessPasswordOutdated(state);
    }, _constants.SEEDLESS_PASSWORD_OUTDATED_CHECK_INTERVAL_MS);
  } catch (e) {
    _loglevel.default.error('[Metamask] checkIsSeedlessPasswordOutdated error', e);
  }
}
async function getCleanAppState(store) {
  const state = {
    ...store.getState()
  };
  // we use the manifest.json version from getVersion and not
  // `process.env.METAMASK_VERSION` as they can be different (see `getVersion`
  // for more info)
  state.version = global.platform.getVersion();
  state.browser = window.navigator.userAgent;

  // when JSON.stringiy, `undefined` value will be left out.
  state.metamask = {
    ...state.metamask,
    socialLoginEmail: undefined
  };
  return state;
}

/**
 * Setup functions on `window.stateHooks`. Some of these support
 * application features, and some are just for debugging or testing.
 *
 * @param {object} store - The Redux store.
 */
function setupStateHooks(store) {
  if (true || false || false) {
    /**
     * The following stateHook is a method intended to throw an error, used in
     * manual and E2E tests to ensure that errors are attempted to be sent to sentry.
     *
     * @param {string} [msg] - The error message to throw, defaults to 'Test Error'
     */
    window.stateHooks.throwTestError = async function (msg = 'Test Error') {
      const error = new Error(msg);
      error.name = 'TestError';
      throw error;
    };
    /**
     * The following stateHook is a method intended to capture an error, used in
     * manual and E2E tests to ensure that errors are correctly sent to sentry.
     *
     * @param {string} [msg] - The error message to capture, defaults to 'Test Error'
     */
    window.stateHooks.captureTestError = async function (msg = 'Test Error') {
      const error = new Error(msg);
      error.name = 'TestError';
      (0, _sentry.captureException)(error);
    };
    /**
     * The following stateHook is a method intended to throw an error in the
     * background, used in manual and E2E tests to ensure that errors are attempted to be
     * sent to sentry.
     *
     * @param {string} [msg] - The error message to throw, defaults to 'Test Error'
     */
    window.stateHooks.throwTestBackgroundError = async function (msg = 'Test Error') {
      await actions.throwTestBackgroundError(msg);
    };
    /**
     * The following stateHook is a method intended to capture an error in the background, used
     * in manual and E2E tests to ensure that errors are correctly sent to sentry.
     *
     * @param {string} [msg] - The error message to capture, defaults to 'Test Error'
     */
    window.stateHooks.captureBackgroundError = async function (msg = 'Test Error') {
      await actions.captureTestBackgroundError(msg);
    };
  }
  window.stateHooks.getCleanAppState = async function () {
    return getCleanAppState(store);
  };
  window.stateHooks.getSentryAppState = function () {
    const reduxState = store.getState();
    return (0, _object.maskObject)(reduxState, _sentryState.SENTRY_UI_STATE);
  };
  window.stateHooks.getLogs = function () {
    // These logs are logged by LoggingController
    const reduxState = store.getState();
    const {
      logs
    } = reduxState.metamask;
    const logsArray = Object.values(logs).sort((a, b) => {
      return a.timestamp - b.timestamp;
    });
    return logsArray;
  };
}
window.logStateString = async function (cb) {
  const state = await window.stateHooks.getCleanAppState();
  const logs = window.stateHooks.getLogs();
  _webextensionPolyfill.default.runtime.getPlatformInfo().then(platform => {
    state.platform = platform;
    state.logs = logs;
    const stateString = JSON.stringify(state, null, 2);
    cb(null, stateString);
  }).catch(err => {
    cb(err);
  });
};
window.logState = function (toClipboard) {
  return window.logStateString((err, result) => {
    if (err) {
      console.error(err.message);
    } else if (toClipboard) {
      (0, _copyToClipboard.default)(result, _copy.COPY_OPTIONS);
      console.log('State log copied');
    } else {
      console.log(result);
    }
  });
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\asset.tsx", {"../../../shared/modules/string-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\string-utils.ts","../../components/app/assets/nfts/nft-details/nft-details":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\assets\\nfts\\nft-details\\nft-details.tsx","../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../selectors/assets":"D:\\code\\v\\metamask-extension\\ui\\selectors\\assets.ts","./components/native-asset":"D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\components\\native-asset.tsx","./components/token-asset":"D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\components\\token-asset.tsx","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js","react-router-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-router-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Casset%5Casset.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _stringUtils = require("../../../shared/modules/string-utils");
var _nftDetails = _interopRequireDefault(require("../../components/app/assets/nfts/nft-details/nft-details"));
var _metamask = require("../../ducks/metamask/metamask");
var _routes = require("../../helpers/constants/routes");
var _assets = require("../../selectors/assets");
var _nativeAsset = _interopRequireDefault(require("./components/native-asset"));
var _tokenAsset = _interopRequireDefault(require("./components/token-asset"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/** A page representing a native, token, or NFT asset */
const Asset = () => {
  const params = (0, _reactRouterDom.useParams)();
  const {
    chainId,
    asset,
    id
  } = params;
  const decodedAsset = asset ? decodeURIComponent(asset) : undefined;
  const nfts = (0, _reactRedux.useSelector)(state => (0, _metamask.getNFTsByChainId)(state, chainId));
  const token = (0, _reactRedux.useSelector)(state => (0, _assets.getTokenByAccountAndAddressAndChainId)(state, undefined,
  // Defaults to the selected account
  decodedAsset, chainId));
  const nft = nfts.find(({
    address,
    tokenId
  }) =>
  // @ts-expect-error TODO: Fix this type error by handling undefined parameters
  (0, _stringUtils.isEqualCaseInsensitive)(address, decodedAsset) && id === tokenId.toString());
  (0, _react.useEffect)(() => {
    const el = document.querySelector('.app');
    el === null || el === void 0 || el.scroll(0, 0);
  }, []);
  const content = (() => {
    if (nft) {
      return /*#__PURE__*/_react.default.createElement(_nftDetails.default, {
        nft: nft
      });
    }
    const isInvalid = !token || !chainId;
    if (isInvalid) {
      return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
        to: {
          pathname: _routes.DEFAULT_ROUTE
        }
      });
    }
    const shouldShowToken = !token.isNative && token.address;
    if (shouldShowToken) {
      return /*#__PURE__*/_react.default.createElement(_tokenAsset.default, {
        chainId: chainId,
        token: token
      });
    }
    return /*#__PURE__*/_react.default.createElement(_nativeAsset.default, {
      chainId: chainId,
      token: token
    });
  })();
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "main-container asset__container"
  }, content);
};
var _default = exports.default = Asset;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\asset\\asset.tsx",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\components\\asset-market-details.tsx", {"../../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../../shared/lib/asset-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\asset-utils.ts","../../../components/component-library":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\index.ts","../../../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../helpers/utils/confirm-tx.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\confirm-tx.util.ts","../../../hooks/useFormatters":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useFormatters.ts","../../../hooks/useI18nContext":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useI18nContext.js","../../../hooks/useMultichainSelector":"D:\\code\\v\\metamask-extension\\ui\\hooks\\useMultichainSelector.ts","../../../selectors/assets":"D:\\code\\v\\metamask-extension\\ui\\selectors\\assets.ts","../../../selectors/multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","../../../selectors/selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","../util":"D:\\code\\v\\metamask-extension\\ui\\pages\\asset\\util.ts","bignumber.js":"D:\\code\\v\\metamask-extension\\node_modules\\bignumber.js\\bignumber.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-redux":"D:\\code\\v\\metamask-extension\\node_modules\\react-redux\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Casset%5Ccomponents%5Casset-market-details.tsx
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetMarketDetails = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _bignumber = require("bignumber.js");
var _confirmTx = require("../../../helpers/utils/confirm-tx.util");
var _util = require("../util");
var _componentLibrary = require("../../../components/component-library");
var _designSystem = require("../../../helpers/constants/design-system");
var _useI18nContext = require("../../../hooks/useI18nContext");
var _metamask = require("../../../ducks/metamask/metamask");
var _useMultichainSelector = require("../../../hooks/useMultichainSelector");
var _multichain = require("../../../selectors/multichain");
var _assets = require("../../../selectors/assets");
var _selectors = require("../../../selectors/selectors");
var _transaction = require("../../../../shared/constants/transaction");
var _util2 = require("../../../../app/scripts/lib/util");
var _assetUtils = require("../../../../shared/lib/asset-utils");
var _useFormatters = require("../../../hooks/useFormatters");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// eslint-disable-next-line import/no-restricted-paths

const AssetMarketDetails = ({
  asset,
  address
}) => {
  var _currencyRates$symbol, _currencyRates$native, _nonEvmConversionRate, _nonEvmConversionRate2, _evmMarketData$chainI;
  const t = (0, _useI18nContext.useI18nContext)();
  const currency = (0, _reactRedux.useSelector)(_metamask.getCurrentCurrency);
  const conversionRate = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainConversionRate);
  const evmMarketData = (0, _reactRedux.useSelector)(_selectors.getMarketData);
  const currencyRates = (0, _reactRedux.useSelector)(_selectors.getCurrencyRates);
  const nonEvmConversionRates = (0, _reactRedux.useSelector)(_assets.getAssetsRates);
  const {
    formatCurrencyCompact,
    formatCompact
  } = (0, _useFormatters.useFormatters)();
  const isEvm = (0, _assetUtils.isEvmChainId)(asset.chainId);
  const nativeCurrency = (0, _useMultichainSelector.useMultichainSelector)(_multichain.getMultichainNativeCurrency);
  const {
    type,
    symbol,
    chainId
  } = asset;
  const evmTokenExchangeRate = type === _transaction.AssetType.native ? (_currencyRates$symbol = currencyRates[symbol]) === null || _currencyRates$symbol === void 0 ? void 0 : _currencyRates$symbol.conversionRate : ((_currencyRates$native = currencyRates[nativeCurrency]) === null || _currencyRates$native === void 0 ? void 0 : _currencyRates$native.conversionRate) || 0;
  const nonEvmExchangeRate = (nonEvmConversionRates === null || nonEvmConversionRates === void 0 || (_nonEvmConversionRate = nonEvmConversionRates[address]) === null || _nonEvmConversionRate === void 0 ? void 0 : _nonEvmConversionRate.rate) || 0;
  const tokenExchangeRate = isEvm ? evmTokenExchangeRate : nonEvmExchangeRate;
  const conversionRateForNativeToken = (0, _util2.getConversionRatesForNativeAsset)({
    conversionRates: nonEvmConversionRates,
    chainId
  });
  const nonEvmMarketData = type === _transaction.AssetType.native ? conversionRateForNativeToken === null || conversionRateForNativeToken === void 0 ? void 0 : conversionRateForNativeToken.marketData : nonEvmConversionRates === null || nonEvmConversionRates === void 0 || (_nonEvmConversionRate2 = nonEvmConversionRates[address]) === null || _nonEvmConversionRate2 === void 0 ? void 0 : _nonEvmConversionRate2.marketData;
  const tokenMarketDetails = isEvm ? (_evmMarketData$chainI = evmMarketData[chainId]) === null || _evmMarketData$chainI === void 0 ? void 0 : _evmMarketData$chainI[address] : nonEvmMarketData;
  const shouldDisplayMarketData = conversionRate > 0 && tokenMarketDetails && (tokenMarketDetails.marketCap > 0 || tokenMarketDetails.totalVolume > 0 || tokenMarketDetails.circulatingSupply > 0 || tokenMarketDetails.allTimeHigh > 0 || tokenMarketDetails.allTimeLow > 0);
  if (!shouldDisplayMarketData) {
    return null;
  }
  const toNumber = value => value ? new _bignumber.BigNumber(typeof value === 'string' ? value : value.toString()).toNumber() : 0;
  let marketCap = toNumber(tokenMarketDetails.marketCap);
  let totalVolume = toNumber(tokenMarketDetails.totalVolume);
  const circulatingSupply = toNumber(tokenMarketDetails.circulatingSupply);
  let allTimeHigh = toNumber(tokenMarketDetails.allTimeHigh);
  let allTimeLow = toNumber(tokenMarketDetails.allTimeLow);
  if (isEvm) {
    marketCap *= tokenExchangeRate;
    totalVolume *= tokenExchangeRate;
    allTimeHigh *= tokenExchangeRate;
    allTimeLow *= tokenExchangeRate;
  }
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, null, /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    marginBottom: 2,
    borderColor: _designSystem.BorderColor.borderMuted,
    marginInline: 4,
    style: {
      height: '1px',
      borderBottomWidth: 0
    }
  }), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.headingSm,
    paddingInline: 4,
    paddingTop: 2,
    paddingBottom: 2
  }, t('marketDetails')), /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    paddingInline: 4,
    display: _designSystem.Display.Flex,
    flexDirection: _designSystem.FlexDirection.Column,
    gap: 2
  }, marketCap > 0 && renderRow(t('marketCap'), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium,
    "data-testid": "asset-market-cap"
  }, formatCurrencyCompact(marketCap, currency))), totalVolume > 0 && renderRow(t('totalVolume'), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium
  }, formatCurrencyCompact(totalVolume, currency))), circulatingSupply > 0 && renderRow(t('circulatingSupply'), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium
  }, formatCompact(circulatingSupply))), allTimeHigh > 0 && renderRow(t('allTimeHigh'), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium
  }, (0, _confirmTx.formatCurrency)(`${allTimeHigh}`, currency, (0, _util.getPricePrecision)(allTimeHigh)))), allTimeLow > 0 && renderRow(t('allTimeLow'), /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    variant: _designSystem.TextVariant.bodyMdMedium
  }, (0, _confirmTx.formatCurrency)(`${allTimeLow}`, currency, (0, _util.getPricePrecision)(allTimeLow))))));
};
exports.AssetMarketDetails = AssetMarketDetails;
function renderRow(leftColumn, rightColumn) {
  return /*#__PURE__*/_react.default.createElement(_componentLibrary.Box, {
    display: _designSystem.Display.Flex,
    justifyContent: _designSystem.JustifyContent.spaceBetween
  }, /*#__PURE__*/_react.default.createElement(_componentLibrary.Text, {
    color: _designSystem.TextColor.textAlternative,
    variant: _designSystem.TextVariant.bodyMdMedium
  }, leftColumn), rightColumn);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\asset\\components\\asset-market-details.tsx",}]],[],{})

//# sourceMappingURL=data:application/json;charset=utf8;base64,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